/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.samples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jets3t.samples.SamplesUtils;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multithread.ListObjectsEvent;
import org.jets3t.service.multithread.S3ServiceEventAdaptor;
import org.jets3t.service.multithread.S3ServiceMulti;
import org.jets3t.service.security.AWSCredentials;

public class ThreadedObjectListing {
    public static String TEST_PROPERTIES_FILENAME = "test.properties";

    public static void main(String[] args) throws Exception {
        String bucketName = "jets3t";
        String delimiter = "/";
        AWSCredentials awsCredentials = SamplesUtils.loadAWSCredentials();
        RestS3Service restService = new RestS3Service(awsCredentials);
        final List<StorageObject> allObjects = Collections.synchronizedList(new ArrayList());
        final Exception[] s3ServiceExceptions = new Exception[1];
        long startTime = System.currentTimeMillis();
        StorageObjectsChunk initialChunk = restService.listObjectsChunked("jets3t", null, "/", 1000L, null, true);
        long totalElapsedTime = System.currentTimeMillis() - startTime;
        final String[] commonPrefixes = initialChunk.getCommonPrefixes();
        if (commonPrefixes.length > 0) {
            System.out.println("Performing sub-listings for common prefixes: " + Arrays.asList(commonPrefixes));
            final S3ServiceMulti s3Multi = new S3ServiceMulti(restService, new S3ServiceEventAdaptor(){

                public void s3ServiceEventPerformed(ListObjectsEvent event) {
                    if (3 == event.getEventCode()) {
                        for (StorageObjectsChunk chunk : event.getChunkList()) {
                            System.out.println("Listed " + chunk.getObjects().length + " objects for sub-listing with prefix: '" + chunk.getPrefix() + "'");
                            allObjects.addAll(Arrays.asList(chunk.getObjects()));
                        }
                    } else if (0 == event.getEventCode()) {
                        s3ServiceExceptions[0] = new S3ServiceException("Failed to list all objects in S3 bucket", event.getErrorCause());
                    }
                }
            });
            startTime = System.currentTimeMillis();
            new Thread(){

                public void run() {
                    s3Multi.listObjects("jets3t", commonPrefixes, null, 1000L);
                }
            }.run();
            long threadedElapsedTime = System.currentTimeMillis() - startTime;
            totalElapsedTime += threadedElapsedTime;
            System.out.println("\nTime to list " + allObjects.size() + " objects with " + commonPrefixes.length + " sub-listings: " + threadedElapsedTime + " ms");
        }
        allObjects.addAll(Arrays.asList(initialChunk.getObjects()));
        System.out.println("\nTotal time to list " + allObjects.size() + " objects: " + totalElapsedTime + " ms");
    }
}

