/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class DDLUtils$ {
    public static final DDLUtils$ MODULE$;
    private final String HIVE_PROVIDER;

    static {
        new DDLUtils$();
    }

    public String HIVE_PROVIDER() {
        return this.HIVE_PROVIDER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDatasourceTable(CatalogTable table) {
        if (!table.provider().isDefined()) return false;
        Object object = table.provider().get();
        String string = this.HIVE_PROVIDER();
        if (object == null) {
            if (string == null) return false;
            return true;
        } else if (object.equals(string)) return false;
        return true;
    }

    public void verifyPartitionProviderIsHive(SparkSession spark, CatalogTable table, String action) {
        String tableName = table.identifier().table();
        if (!spark.sqlContext().conf().manageFilesourcePartitions() && this.isDatasourceTable(table)) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not allowed on ", " since filesource partition management is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, tableName}))).append((Object)"disabled (spark.sql.hive.manageFilesourcePartitions = false).").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (!table.tracksPartitionsInCatalog() && this.isDatasourceTable(table)) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not allowed on ", " since its partition metadata is not stored in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, tableName}))).append((Object)"the Hive metastore. To import this information into the metastore, run ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`msck repair table ", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void verifyAlterTableType(SessionCatalog catalog, CatalogTable tableMetadata, boolean isView) {
        if (!catalog.isTemporaryTable(tableMetadata.identifier())) {
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !isView) {
                throw new AnalysisException("Cannot alter a view with ALTER TABLE. Please use ALTER VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && isView) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot alter a table with ALTER VIEW. Please use ALTER TABLE instead"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private DDLUtils$() {
        MODULE$ = this;
        this.HIVE_PROVIDER = "hive";
    }
}

