/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.AlterTableSerDePropertiesCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u0001>\u0011\u0001%\u00117uKJ$\u0016M\u00197f'\u0016\u0014H)\u001a)s_B,'\u000f^5fg\u000e{W.\\1oI*\u00111\u0001B\u0001\bG>lW.\u00198e\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000e\u001fIA\u0011\u0011\u0003G\u0007\u0002%)\u00111\u0003F\u0001\bY><\u0017nY1m\u0015\t)b#A\u0003qY\u0006t7O\u0003\u0002\u0018\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001a%\tAA*Z1g\u001d>$W\r\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005})\u0013B\u0001\u0014!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0003A!f\u0001\n\u0003I\u0013!\u0003;bE2,g*Y7f+\u0005Q\u0003CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u00039\u0019XM\u001d3f\u00072\f7o\u001d(b[\u0016,\u0012a\r\t\u0004?Q2\u0014BA\u001b!\u0005\u0019y\u0005\u000f^5p]B\u0011qG\u000f\b\u0003?aJ!!\u000f\u0011\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s\u0001B\u0001B\u0010\u0001\u0003\u0012\u0003\u0006IaM\u0001\u0010g\u0016\u0014H-Z\"mCN\u001ch*Y7fA!A\u0001\t\u0001BK\u0002\u0013\u0005\u0011)A\btKJ$W\r\u0015:pa\u0016\u0014H/[3t+\u0005\u0011\u0005cA\u00105\u0007B!q\u0007\u0012\u001c7\u0013\t)EHA\u0002NCBD\u0001b\u0012\u0001\u0003\u0012\u0003\u0006IAQ\u0001\u0011g\u0016\u0014H-\u001a)s_B,'\u000f^5fg\u0002B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tAS\u0001\ta\u0006\u0014Ho\u00159fGV\t1\nE\u0002 i1\u0003\"!T1\u000f\u00059sfBA(]\u001d\t\u00016L\u0004\u0002R5:\u0011!+\u0017\b\u0003'bs!\u0001V,\u000e\u0003US!A\u0016\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qCB\u0005\u0003;Z\tqaY1uC2|w-\u0003\u0002`A\u0006a1)\u0019;bY><G+\u001f9fg*\u0011QLF\u0005\u0003E\u000e\u0014!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011q\f\u0019\u0005\tK\u0002\u0011\t\u0012)A\u0005\u0017\u0006I\u0001/\u0019:u'B,7\r\t\u0005\u0006O\u0002!\t\u0001[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%T7\u000e\\7\u0011\u0005m\u0001\u0001\"\u0002\u0015g\u0001\u0004Q\u0003\"B\u0019g\u0001\u0004\u0019\u0004\"\u0002!g\u0001\u0004\u0011\u0005\"B%g\u0001\u0004Y\u0005\"B8\u0001\t\u0003\u0002\u0018a\u0001:v]R\u0011\u0011O \t\u0004e^ThBA:v\u001d\t!F/C\u0001\"\u0013\t1\b%A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(aA*fc*\u0011a\u000f\t\t\u0003wrl\u0011AB\u0005\u0003{\u001a\u00111AU8x\u0011\u0019yh\u000e1\u0001\u0002\u0002\u0005a1\u000f]1sWN+7o]5p]B\u001910a\u0001\n\u0007\u0005\u0015aA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0005\u0002\n\u0001\t\t\u0011\"\u0001\u0002\f\u0005!1m\u001c9z)%I\u0017QBA\b\u0003#\t\u0019\u0002\u0003\u0005)\u0003\u000f\u0001\n\u00111\u0001+\u0011!\t\u0014q\u0001I\u0001\u0002\u0004\u0019\u0004\u0002\u0003!\u0002\bA\u0005\t\u0019\u0001\"\t\u0011%\u000b9\u0001%AA\u0002-C\u0011\"a\u0006\u0001#\u0003%\t!!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0004\u0016\u0004U\u0005u1FAA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\u0002%\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005E\u0002!%A\u0005\u0002\u0005M\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003kQ3aMA\u000f\u0011%\tI\u0004AI\u0001\n\u0003\tY$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u\"f\u0001\"\u0002\u001e!I\u0011\u0011\t\u0001\u0012\u0002\u0013\u0005\u00111I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t)EK\u0002L\u0003;A\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\t1\fgn\u001a\u0006\u0003\u0003/\nAA[1wC&\u00191(!\u0015\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA1!\ry\u00121M\u0005\u0004\u0003K\u0002#aA%oi\"I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00111N\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti'a\u001d\u0011\u0007}\ty'C\u0002\u0002r\u0001\u00121!\u00118z\u0011)\t)(a\u001a\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\u0004q\u0012\n\u0004\"CA=\u0001\u0005\u0005I\u0011IA>\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA?!\u0019\ty(!\"\u0002n5\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007\u0003\u0013AC2pY2,7\r^5p]&!\u0011qQAA\u0005!IE/\u001a:bi>\u0014\b\"CAF\u0001\u0005\u0005I\u0011AAG\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAH\u0003+\u00032aHAI\u0013\r\t\u0019\n\t\u0002\b\u0005>|G.Z1o\u0011)\t)(!#\u0002\u0002\u0003\u0007\u0011Q\u000e\u0005\n\u00033\u0003\u0011\u0011!C!\u00037\u000ba!Z9vC2\u001cH\u0003BAH\u0003;C!\"!\u001e\u0002\u0018\u0006\u0005\t\u0019AA7\u000f%\t\tKAA\u0001\u0012\u0003\t\u0019+\u0001\u0011BYR,'\u000fV1cY\u0016\u001cVM\u001d#f!J|\u0007/\u001a:uS\u0016\u001c8i\\7nC:$\u0007cA\u000e\u0002&\u001aA\u0011AAA\u0001\u0012\u0003\t9kE\u0003\u0002&\u0006%F\u0005E\u0005\u0002,\u0006E&f\r\"LS6\u0011\u0011Q\u0016\u0006\u0004\u0003_\u0003\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003g\u000biKA\tBEN$(/Y2u\rVt7\r^5p]RBqaZAS\t\u0003\t9\f\u0006\u0002\u0002$\"Q\u00111XAS\u0003\u0003%)%!0\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0014\t\u0015\u0005\u0005\u0017QUA\u0001\n\u0003\u000b\u0019-A\u0003baBd\u0017\u0010F\u0005j\u0003\u000b\f9-!3\u0002L\"1\u0001&a0A\u0002)Ba!MA`\u0001\u0004\u0019\u0004B\u0002!\u0002@\u0002\u0007!\t\u0003\u0004J\u0003\u007f\u0003\ra\u0013\u0005\u000b\u0003\u001f\f)+!A\u0005\u0002\u0006E\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003'\fY\u000e\u0005\u0003 i\u0005U\u0007cB\u0010\u0002X*\u001a$iS\u0005\u0004\u00033\u0004#A\u0002+va2,G\u0007C\u0005\u0002^\u00065\u0017\u0011!a\u0001S\u0006\u0019\u0001\u0010\n\u0019\t\u0015\u0005\u0005\u0018QUA\u0001\n\u0013\t\u0019/A\u0006sK\u0006$'+Z:pYZ,GCAAs!\u0011\ty%a:\n\t\u0005%\u0018\u0011\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class AlterTableSerDePropertiesCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Option<String> serdeClassName;
    private final Option<Map<String, String>> serdeProperties;
    private final Option<Map<String, String>> partSpec;

    public static Option<Tuple4<TableIdentifier, Option<String>, Option<Map<String, String>>, Option<Map<String, String>>>> unapply(AlterTableSerDePropertiesCommand alterTableSerDePropertiesCommand) {
        return AlterTableSerDePropertiesCommand$.MODULE$.unapply(alterTableSerDePropertiesCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Option<String>, Option<Map<String, String>>, Option<Map<String, String>>>, AlterTableSerDePropertiesCommand> tupled() {
        return AlterTableSerDePropertiesCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<String>, Function1<Option<Map<String, String>>, Function1<Option<Map<String, String>>, AlterTableSerDePropertiesCommand>>>> curried() {
        return AlterTableSerDePropertiesCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<String> serdeClassName() {
        return this.serdeClassName;
    }

    public Option<Map<String, String>> serdeProperties() {
        return this.serdeProperties;
    }

    public Option<Map<String, String>> partSpec() {
        return this.partSpec;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        if (this.partSpec().isDefined() && DDLUtils$.MODULE$.isDatasourceTable(table)) {
            throw new AnalysisException("Operation not allowed: ALTER TABLE SET [SERDE | SERDEPROPERTIES] for a specific partition is not supported for tables created with the datasource API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.serdeClassName().isDefined() && DDLUtils$.MODULE$.isDatasourceTable(table)) {
            throw new AnalysisException("Operation not allowed: ALTER TABLE SET SERDE is not supported for tables created with the datasource API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.partSpec().isEmpty()) {
            Option x$64 = this.serdeClassName().orElse((Function0)new Serializable(this, table){
                public static final long serialVersionUID = 0L;
                private final CatalogTable table$2;

                public final Option<String> apply() {
                    return this.table$2.storage().serde();
                }
                {
                    this.table$2 = table$2;
                }
            });
            Map x$65 = table.storage().properties().$plus$plus((GenTraversableOnce)this.serdeProperties().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Map<String, Nothing$> apply() {
                    return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                }
            }));
            Option x$66 = table.withNewStorage$default$1();
            Option x$67 = table.withNewStorage$default$2();
            Option x$68 = table.withNewStorage$default$3();
            boolean x$69 = table.withNewStorage$default$4();
            CatalogTable newTable = table.withNewStorage(x$66, x$67, x$68, x$69, x$64, x$65);
            catalog.alterTable(newTable);
        } else {
            Map spec = (Map)this.partSpec().get();
            CatalogTablePartition part = catalog.getPartition(table.identifier(), spec);
            Option x$70 = this.serdeClassName().orElse((Function0)new Serializable(this, part){
                public static final long serialVersionUID = 0L;
                private final CatalogTablePartition part$1;

                public final Option<String> apply() {
                    return this.part$1.storage().serde();
                }
                {
                    this.part$1 = part$1;
                }
            });
            Map x$71 = part.storage().properties().$plus$plus((GenTraversableOnce)this.serdeProperties().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Map<String, Nothing$> apply() {
                    return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                }
            }));
            Option x$72 = part.storage().copy$default$1();
            Option x$73 = part.storage().copy$default$2();
            Option x$74 = part.storage().copy$default$3();
            boolean x$75 = part.storage().copy$default$5();
            CatalogStorageFormat x$76 = part.storage().copy(x$72, x$73, x$74, x$70, x$75, x$71);
            Map x$77 = part.copy$default$1();
            Map x$78 = part.copy$default$3();
            CatalogTablePartition newPart = part.copy(x$77, x$76, x$78);
            catalog.alterPartitions(table.identifier(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{newPart})));
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableSerDePropertiesCommand copy(TableIdentifier tableName, Option<String> serdeClassName, Option<Map<String, String>> serdeProperties, Option<Map<String, String>> partSpec) {
        return new AlterTableSerDePropertiesCommand(tableName, serdeClassName, serdeProperties, partSpec);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<String> copy$default$2() {
        return this.serdeClassName();
    }

    public Option<Map<String, String>> copy$default$3() {
        return this.serdeProperties();
    }

    public Option<Map<String, String>> copy$default$4() {
        return this.partSpec();
    }

    public String productPrefix() {
        return "AlterTableSerDePropertiesCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = this.partSpec();
                break;
            }
            case 2: {
                object = this.serdeProperties();
                break;
            }
            case 1: {
                object = this.serdeClassName();
                break;
            }
            case 0: {
                object = this.tableName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableSerDePropertiesCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableSerDePropertiesCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableSerDePropertiesCommand alterTableSerDePropertiesCommand = (AlterTableSerDePropertiesCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableSerDePropertiesCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<String> option = this.serdeClassName();
        Option<String> option2 = alterTableSerDePropertiesCommand.serdeClassName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Map<String, String>> option3 = this.serdeProperties();
        Option<Map<String, String>> option4 = alterTableSerDePropertiesCommand.serdeProperties();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Map<String, String>> option5 = this.partSpec();
        Option<Map<String, String>> option6 = alterTableSerDePropertiesCommand.partSpec();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!alterTableSerDePropertiesCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableSerDePropertiesCommand(TableIdentifier tableName, Option<String> serdeClassName, Option<Map<String, String>> serdeProperties, Option<Map<String, String>> partSpec) {
        this.tableName = tableName;
        this.serdeClassName = serdeClassName;
        this.serdeProperties = serdeProperties;
        this.partSpec = partSpec;
        Command.class.$init$((Command)this);
        Predef$.MODULE$.require(serdeClassName.isDefined() || serdeProperties.isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "ALTER TABLE attempted to set neither serde class name nor serde properties";
            }
        });
    }
}

