/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.UnicodeUnescapeException;
import org.codehaus.janino.UnicodeUnescapeReader;
import org.codehaus.janino.util.TeeReader;

public class Scanner {
    @Nullable
    private final String optionalFileName;
    private final Reader in;
    private int nextChar = -1;
    private boolean crLfPending;
    private short nextCharLineNumber;
    private short nextCharColumnNumber;
    private short tokenLineNumber;
    private short tokenColumnNumber;
    @Nullable
    private String optionalDocComment;
    private boolean expectGreater;
    private static final Map<String, String> JAVA_KEYWORDS;
    private static final Map<String, String> JAVA_OPERATORS;
    private static final Map<String, String> JAVA_OPERATORS_EXPECT_GREATER;
    @Nullable
    private WarningHandler optionalWarningHandler;

    @Deprecated
    public Scanner(String fileName) throws CompileException, IOException {
        this(fileName, new FileInputStream(fileName));
    }

    @Deprecated
    public Scanner(String fileName, String encoding) throws CompileException, IOException {
        this(fileName, new FileInputStream(fileName), encoding);
    }

    @Deprecated
    public Scanner(File file) throws CompileException, IOException {
        this(file.getAbsolutePath(), new FileInputStream(file), null);
    }

    @Deprecated
    public Scanner(File file, @Nullable String optionalEncoding) throws CompileException, IOException {
        this(file.getAbsolutePath(), new FileInputStream(file), optionalEncoding);
    }

    public Scanner(@Nullable String optionalFileName, InputStream is) throws CompileException, IOException {
        this(optionalFileName, new InputStreamReader(is), 1, 0);
    }

    public Scanner(@Nullable String optionalFileName, InputStream is, @Nullable String optionalEncoding) throws CompileException, IOException {
        this(optionalFileName, optionalEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, optionalEncoding), 1, 0);
    }

    public Scanner(@Nullable String optionalFileName, Reader in) throws CompileException, IOException {
        this(optionalFileName, in, 1, 0);
    }

    public Scanner(@Nullable String optionalFileName, Reader in, short initialLineNumber, short initialColumnNumber) throws CompileException, IOException {
        if (optionalFileName == null && Boolean.getBoolean("org.codehaus.janino.source_debugging.enable")) {
            String dirName = System.getProperty("org.codehaus.janino.source_debugging.dir");
            File dir = dirName == null ? null : new File(dirName);
            File temporaryFile = File.createTempFile("janino", ".java", dir);
            temporaryFile.deleteOnExit();
            in = new TeeReader(in, new FileWriter(temporaryFile), true);
            optionalFileName = temporaryFile.getAbsolutePath();
        }
        this.optionalFileName = optionalFileName;
        this.in = new UnicodeUnescapeReader(in);
        this.nextCharLineNumber = initialLineNumber;
        this.nextCharColumnNumber = initialColumnNumber;
        this.readNextChar();
    }

    @Nullable
    public String getFileName() {
        return this.optionalFileName;
    }

    @Deprecated
    public void close() throws IOException {
        this.in.close();
    }

    @Nullable
    public String doc() {
        String s = this.optionalDocComment;
        this.optionalDocComment = null;
        return s;
    }

    public Location location() {
        return new Location(this.optionalFileName, this.nextCharLineNumber, this.nextCharColumnNumber);
    }

    public Token produce() throws CompileException, IOException {
        if (this.optionalDocComment != null) {
            this.warning("MDC", "Misplaced doc comment", this.location());
            this.optionalDocComment = null;
        }
        int state = 0;
        StringBuilder dcsb = null;
        block13: while (true) {
            switch (state) {
                case 0: {
                    if (this.nextChar == -1) {
                        return new Token(0, "EOF");
                    }
                    if (Character.isWhitespace((char)this.nextChar)) break;
                    if (this.nextChar != 47) break block13;
                    state = 1;
                    break;
                }
                case 1: {
                    if (this.nextChar == -1) {
                        return new Token(9, "/");
                    }
                    if (this.nextChar == 61) {
                        this.readNextChar();
                        return new Token(9, "/=");
                    }
                    if (this.nextChar == 47) {
                        state = 2;
                        break;
                    }
                    if (this.nextChar == 42) {
                        state = 3;
                        break;
                    }
                    return new Token(9, "/");
                }
                case 2: {
                    if (this.nextChar == -1) {
                        return new Token(0, "EOF");
                    }
                    if (this.nextChar != 13 && this.nextChar != 10) break;
                    state = 0;
                    break;
                }
                case 3: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in traditional comment", this.location());
                    }
                    if (this.nextChar == 42) {
                        state = 4;
                        break;
                    }
                    state = 9;
                    break;
                }
                case 4: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 47) {
                        state = 0;
                        break;
                    }
                    if (this.optionalDocComment != null) {
                        this.warning("MDC", "Multiple doc comments", new Location(this.optionalFileName, this.nextCharLineNumber, this.nextCharColumnNumber));
                    }
                    dcsb = new StringBuilder().append((char)this.nextChar);
                    state = this.nextChar == 13 || this.nextChar == 10 ? 6 : (this.nextChar == 42 ? 8 : 5);
                    break;
                }
                case 5: {
                    assert (dcsb != null);
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 42) {
                        state = 8;
                        break;
                    }
                    if (this.nextChar == 13 || this.nextChar == 10) {
                        dcsb.append((char)this.nextChar);
                        state = 6;
                        break;
                    }
                    dcsb.append((char)this.nextChar);
                    break;
                }
                case 6: {
                    assert (dcsb != null);
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 42) {
                        state = 7;
                        break;
                    }
                    if (this.nextChar == 13 || this.nextChar == 10) {
                        dcsb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 32 || this.nextChar == 9) break;
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 7: {
                    assert (dcsb != null);
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 42) break;
                    if (this.nextChar == 47) {
                        this.optionalDocComment = dcsb.toString();
                        state = 0;
                        break;
                    }
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 8: {
                    assert (dcsb != null);
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in doc comment", this.location());
                    }
                    if (this.nextChar == 47) {
                        this.optionalDocComment = dcsb.toString();
                        state = 0;
                        break;
                    }
                    if (this.nextChar == 42) {
                        dcsb.append('*');
                        break;
                    }
                    dcsb.append('*');
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 9: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in traditional comment", this.location());
                    }
                    if (this.nextChar != 42) break;
                    state = 10;
                    break;
                }
                case 10: {
                    if (this.nextChar == -1) {
                        throw new CompileException("EOF in traditional comment", this.location());
                    }
                    if (this.nextChar == 47) {
                        state = 0;
                        break;
                    }
                    if (this.nextChar == 42) break;
                    state = 9;
                    break;
                }
                default: {
                    throw new JaninoRuntimeException(Integer.toString(state));
                }
            }
            this.readNextChar();
        }
        this.tokenLineNumber = this.nextCharLineNumber;
        this.tokenColumnNumber = this.nextCharColumnNumber;
        if (Character.isJavaIdentifierStart((char)this.nextChar)) {
            StringBuilder sb = new StringBuilder();
            sb.append((char)this.nextChar);
            while (true) {
                this.readNextChar();
                if (this.nextChar == -1 || !Character.isJavaIdentifierPart((char)this.nextChar)) break;
                sb.append((char)this.nextChar);
            }
            String s = sb.toString();
            if ("true".equals(s)) {
                return new Token(5, "true");
            }
            if ("false".equals(s)) {
                return new Token(5, "false");
            }
            if ("null".equals(s)) {
                return new Token(8, "null");
            }
            String v = JAVA_KEYWORDS.get(s);
            if (v != null) {
                return new Token(2, v);
            }
            return new Token(1, s);
        }
        if (Character.isDigit((char)this.nextChar)) {
            return this.scanNumericLiteral(false);
        }
        if (this.nextChar == 46) {
            this.readNextChar();
            if (Character.isDigit((char)this.nextChar)) {
                return this.scanNumericLiteral(true);
            }
            return new Token(9, ".");
        }
        if (this.nextChar == 34) {
            StringBuilder sb = new StringBuilder("\"");
            this.readNextChar();
            while (this.nextChar != 34) {
                this.scanLiteralCharacter(sb);
            }
            this.readNextChar();
            return new Token(7, sb.append('\"').toString());
        }
        if (this.nextChar == 39) {
            this.readNextChar();
            if (this.nextChar == 39) {
                throw new CompileException("Single quote must be backslash-escaped in character literal", this.location());
            }
            StringBuilder sb = new StringBuilder("'");
            this.scanLiteralCharacter(sb);
            if (this.nextChar != 39) {
                throw new CompileException("Closing single quote missing", this.location());
            }
            this.readNextChar();
            return new Token(6, sb.append('\'').toString());
        }
        String v = JAVA_OPERATORS.get(new String(new char[]{(char)this.nextChar}));
        if (v != null) {
            while (true) {
                this.readNextChar();
                String v2 = (this.expectGreater ? JAVA_OPERATORS_EXPECT_GREATER : JAVA_OPERATORS).get(v + (char)this.nextChar);
                if (v2 == null) {
                    return new Token(9, v);
                }
                v = v2;
            }
        }
        throw new CompileException("Invalid character input \"" + (char)this.nextChar + "\" (character code " + this.nextChar + ")", this.location());
    }

    public boolean getExpectGreater() {
        return this.expectGreater;
    }

    public boolean setExpectGreater(boolean value) {
        boolean tmp = this.expectGreater;
        this.expectGreater = value;
        return tmp;
    }

    private Token scanNumericLiteral(boolean hadDecimalPoint) throws CompileException, IOException {
        StringBuilder sb = hadDecimalPoint ? new StringBuilder(".") : new StringBuilder();
        int state = hadDecimalPoint ? 2 : 0;
        while (true) {
            switch (state) {
                case 0: {
                    if (this.nextChar == 48) {
                        sb.append('0');
                        state = 6;
                        break;
                    }
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        state = 1;
                        break;
                    }
                    throw new CompileException("Numeric literal begins with invalid character '" + (char)this.nextChar + "'", this.location());
                }
                case 1: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        sb.append((char)this.nextChar);
                        this.readNextChar();
                        return new Token(3, sb.toString());
                    }
                    if (this.nextChar == 102 || this.nextChar == 70 || this.nextChar == 100 || this.nextChar == 68) {
                        sb.append((char)this.nextChar);
                        this.readNextChar();
                        return new Token(4, sb.toString());
                    }
                    if (this.nextChar == 46) {
                        sb.append('.');
                        state = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        sb.append('E');
                        state = 3;
                        break;
                    }
                    return new Token(3, sb.toString());
                }
                case 2: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 101 || this.nextChar == 69) {
                        sb.append('E');
                        state = 3;
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70 || this.nextChar == 100 || this.nextChar == 68) {
                        sb.append((char)this.nextChar);
                        this.readNextChar();
                        return new Token(4, sb.toString());
                    }
                    return new Token(4, sb.toString());
                }
                case 3: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        state = 5;
                        break;
                    }
                    if (this.nextChar == 45 || this.nextChar == 43) {
                        sb.append((char)this.nextChar);
                        state = 4;
                        break;
                    }
                    throw new CompileException("Exponent missing after \"E\"", this.location());
                }
                case 4: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        state = 5;
                        break;
                    }
                    throw new CompileException("Exponent missing after 'E' and sign", this.location());
                }
                case 5: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70 || this.nextChar == 100 || this.nextChar == 68) {
                        sb.append((char)this.nextChar);
                        this.readNextChar();
                        return new Token(4, sb.toString());
                    }
                    return new Token(4, sb.toString());
                }
                case 6: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        sb.append((char)this.nextChar);
                        state = 7;
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        sb.append((char)this.nextChar);
                        this.readNextChar();
                        return new Token(3, sb.toString());
                    }
                    if (this.nextChar == 102 || this.nextChar == 70 || this.nextChar == 100 || this.nextChar == 68) {
                        sb.append((char)this.nextChar);
                        this.readNextChar();
                        return new Token(4, sb.toString());
                    }
                    if (this.nextChar == 46) {
                        sb.append('.');
                        state = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        sb.append((char)this.nextChar);
                        state = 3;
                        break;
                    }
                    if (this.nextChar == 120 || this.nextChar == 88) {
                        sb.append((char)this.nextChar);
                        state = 8;
                        break;
                    }
                    return new Token(3, "0");
                }
                case 7: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 56 || this.nextChar == 57) {
                        throw new CompileException("Digit '" + (char)this.nextChar + "' not allowed in octal literal", this.location());
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        sb.append((char)this.nextChar);
                        this.readNextChar();
                        return new Token(3, sb.toString());
                    }
                    return new Token(3, sb.toString());
                }
                case 8: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        sb.append((char)this.nextChar);
                        state = 9;
                        break;
                    }
                    throw new CompileException("Hex digit expected after \"0x\"", this.location());
                }
                case 9: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        sb.append((char)this.nextChar);
                        this.readNextChar();
                        return new Token(3, sb.toString());
                    }
                    return new Token(3, sb.toString());
                }
                default: {
                    throw new JaninoRuntimeException(Integer.toString(state));
                }
            }
            this.readNextChar();
        }
    }

    private void scanLiteralCharacter(StringBuilder sb) throws CompileException, IOException {
        if (this.nextChar == -1) {
            throw new CompileException("EOF in literal", this.location());
        }
        if (this.nextChar == 13 || this.nextChar == 10) {
            throw new CompileException("Line break in literal not allowed", this.location());
        }
        if (this.nextChar != 92) {
            sb.append((char)this.nextChar);
            this.readNextChar();
            return;
        }
        sb.append('\\');
        this.readNextChar();
        int idx = "btnfr\"'\\".indexOf(this.nextChar);
        if (idx != -1) {
            sb.append((char)this.nextChar);
            this.readNextChar();
            return;
        }
        idx = "01234567".indexOf(this.nextChar);
        if (idx != -1) {
            char firstChar = (char)this.nextChar;
            sb.append(firstChar);
            this.readNextChar();
            idx = "01234567".indexOf(this.nextChar);
            if (idx == -1) {
                return;
            }
            sb.append((char)this.nextChar);
            this.readNextChar();
            idx = "01234567".indexOf(this.nextChar);
            if (idx == -1) {
                return;
            }
            if ("0123".indexOf(firstChar) == -1) {
                throw new CompileException("Invalid octal escape", this.location());
            }
            sb.append((char)this.nextChar);
            this.readNextChar();
            return;
        }
        throw new CompileException("Invalid escape sequence", this.location());
    }

    private void readNextChar() throws IOException, CompileException {
        try {
            this.nextChar = this.in.read();
        }
        catch (UnicodeUnescapeException ex) {
            throw new CompileException(ex.getMessage(), this.location(), (Throwable)ex);
        }
        if (this.nextChar == 13) {
            this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
            this.nextCharColumnNumber = 0;
            this.crLfPending = true;
        } else if (this.nextChar == 10) {
            if (this.crLfPending) {
                this.crLfPending = false;
            } else {
                this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
                this.nextCharColumnNumber = 0;
            }
        } else {
            this.nextCharColumnNumber = (short)(this.nextCharColumnNumber + 1);
        }
    }

    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    private void warning(String handle, String message, @Nullable Location optionalLocation) throws CompileException {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    static {
        String[] ops;
        JAVA_KEYWORDS = new HashMap<String, String>();
        String[] ks = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        for (int i = 0; i < ks.length; ++i) {
            JAVA_KEYWORDS.put(ks[i], ks[i]);
        }
        JAVA_OPERATORS = new HashMap<String, String>();
        JAVA_OPERATORS_EXPECT_GREATER = new HashMap<String, String>();
        for (String op : ops = new String[]{"(", ")", "{", "}", "[", "]", ";", ",", ".", "@", "=", ">", "<", "!", "~", "?", ":", "==", "<=", ">=", "!=", "&&", "||", "++", "--", "+", "-", "*", "/", "&", "|", "^", "%", "<<", ">>", ">>>", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="}) {
            JAVA_OPERATORS.put(op, op);
            if (op.startsWith(">>")) continue;
            JAVA_OPERATORS_EXPECT_GREATER.put(op, op);
        }
    }

    public final class Token {
        @Nullable
        private final String optionalFileName;
        private final short lineNumber;
        private final short columnNumber;
        @Nullable
        private Location location;
        public final int type;
        public static final int EOF = 0;
        public static final int IDENTIFIER = 1;
        public static final int KEYWORD = 2;
        public static final int INTEGER_LITERAL = 3;
        public static final int FLOATING_POINT_LITERAL = 4;
        public static final int BOOLEAN_LITERAL = 5;
        public static final int CHARACTER_LITERAL = 6;
        public static final int STRING_LITERAL = 7;
        public static final int NULL_LITERAL = 8;
        public static final int OPERATOR = 9;
        public final String value;

        private Token(int type, String value) {
            this.optionalFileName = Scanner.this.optionalFileName;
            this.lineNumber = Scanner.this.tokenLineNumber;
            this.columnNumber = Scanner.this.tokenColumnNumber;
            this.type = type;
            this.value = value;
        }

        public Location getLocation() {
            if (this.location != null) {
                return this.location;
            }
            this.location = new Location(this.optionalFileName, this.lineNumber, this.columnNumber);
            return this.location;
        }

        public String toString() {
            return this.value;
        }
    }
}

