/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.SqlTypeName;

public abstract class RelDataTypeSystemImpl
implements RelDataTypeSystem {
    @Override
    public int getMaxScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericScale();
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 9;
            }
        }
        return -1;
    }

    @Override
    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case CHAR: 
            case BINARY: 
            case VARCHAR: 
            case VARBINARY: {
                return 1;
            }
            case TIME: {
                return 0;
            }
            case TIMESTAMP: {
                return 0;
            }
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 2;
            }
        }
        return -1;
    }

    @Override
    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case CHAR: 
            case VARCHAR: {
                return 65536;
            }
            case BINARY: 
            case VARBINARY: {
                return 65536;
            }
            case TIME: 
            case TIMESTAMP: {
                return 3;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 10;
            }
        }
        return -1;
    }

    @Override
    public int getMaxNumericScale() {
        return 19;
    }

    @Override
    public int getMaxNumericPrecision() {
        return 19;
    }
}

