/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordWriter;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class OrcOutputFormat
extends FileOutputFormat<NullWritable, OrcSerde.OrcSerdeRow>
implements AcidOutputFormat<NullWritable, OrcSerde.OrcSerdeRow> {
    private String getSettingFromPropsFallingBackToConf(String key, Properties props, JobConf conf) {
        if (props != null && props.containsKey(key)) {
            return props.getProperty(key);
        }
        if (conf != null) {
            return conf.get(key);
        }
        return null;
    }

    private OrcFile.WriterOptions getOptions(JobConf conf, Properties props) {
        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)conf);
        String propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.STRIPE_SIZE.getPropName(), props, conf);
        if (propVal != null) {
            options.stripeSize(Long.parseLong(propVal));
        }
        if ((propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.COMPRESSION.getPropName(), props, conf)) != null) {
            options.compress(CompressionKind.valueOf(propVal));
        }
        if ((propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.COMPRESSION_BLOCK_SIZE.getPropName(), props, conf)) != null) {
            options.bufferSize(Integer.parseInt(propVal));
        }
        if ((propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.ROW_INDEX_STRIDE.getPropName(), props, conf)) != null) {
            options.rowIndexStride(Integer.parseInt(propVal));
        }
        if ((propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.ENABLE_INDEXES.getPropName(), props, conf)) != null && "false".equalsIgnoreCase(propVal)) {
            options.rowIndexStride(0);
        }
        if ((propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.BLOCK_PADDING.getPropName(), props, conf)) != null) {
            options.blockPadding(Boolean.parseBoolean(propVal));
        }
        if ((propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.ENCODING_STRATEGY.getPropName(), props, conf)) != null) {
            options.encodingStrategy(OrcFile.EncodingStrategy.valueOf(propVal));
        }
        if ((propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.BLOOM_FILTER_COLUMNS.getPropName(), props, conf)) != null) {
            options.bloomFilterColumns(propVal);
        }
        if ((propVal = this.getSettingFromPropsFallingBackToConf(OrcFile.OrcTableProperties.BLOOM_FILTER_FPP.getPropName(), props, conf)) != null) {
            options.bloomFilterFpp(Double.parseDouble(propVal));
        }
        return options;
    }

    public RecordWriter<NullWritable, OrcSerde.OrcSerdeRow> getRecordWriter(FileSystem fileSystem, JobConf conf, String name, Progressable reporter) throws IOException {
        return new OrcRecordWriter(new Path(name), this.getOptions(conf, null));
    }

    @Override
    public StatsProvidingRecordWriter getHiveRecordWriter(JobConf conf, Path path, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable reporter) throws IOException {
        return new OrcRecordWriter(path, this.getOptions(conf, tableProperties));
    }

    @Override
    public RecordUpdater getRecordUpdater(Path path, AcidOutputFormat.Options options) throws IOException {
        if (options.getDummyStream() != null) {
            return new DummyOrcRecordUpdater(path, options);
        }
        return new OrcRecordUpdater(path, options);
    }

    @Override
    public FileSinkOperator.RecordWriter getRawRecordWriter(Path path, AcidOutputFormat.Options options) throws IOException {
        Path filename = AcidUtils.createFilename(path, options);
        OrcFile.WriterOptions opts = OrcFile.writerOptions(options.getConfiguration());
        if (!options.isWritingBase()) {
            opts.bufferSize(16384).stripeSize(0x1000000L).blockPadding(false).compress(CompressionKind.NONE).rowIndexStride(0);
        }
        final OrcRecordUpdater.KeyIndexBuilder watcher = new OrcRecordUpdater.KeyIndexBuilder();
        opts.inspector(options.getInspector()).callback(watcher);
        final Writer writer = OrcFile.createWriter(filename, opts);
        return new FileSinkOperator.RecordWriter(){

            @Override
            public void write(Writable w) throws IOException {
                OrcStruct orc = (OrcStruct)w;
                watcher.addKey(((IntWritable)orc.getFieldValue(0)).get(), ((LongWritable)orc.getFieldValue(1)).get(), ((IntWritable)orc.getFieldValue(2)).get(), ((LongWritable)orc.getFieldValue(3)).get());
                writer.addRow(w);
            }

            @Override
            public void close(boolean abort) throws IOException {
                writer.close();
            }
        };
    }

    private class DummyOrcRecordUpdater
    implements RecordUpdater {
        private final Path path;
        private final ObjectInspector inspector;
        private final PrintStream out;

        private DummyOrcRecordUpdater(Path path, AcidOutputFormat.Options options) {
            this.path = path;
            this.inspector = options.getInspector();
            this.out = options.getDummyStream();
        }

        @Override
        public void insert(long currentTransaction, Object row) throws IOException {
            this.out.println("insert " + this.path + " currTxn: " + currentTransaction + " obj: " + this.stringifyObject(row, this.inspector));
        }

        @Override
        public void update(long currentTransaction, Object row) throws IOException {
            this.out.println("update " + this.path + " currTxn: " + currentTransaction + " obj: " + this.stringifyObject(row, this.inspector));
        }

        @Override
        public void delete(long currentTransaction, Object row) throws IOException {
            this.out.println("delete " + this.path + " currTxn: " + currentTransaction + " obj: " + row);
        }

        @Override
        public void flush() throws IOException {
            this.out.println("flush " + this.path);
        }

        @Override
        public void close(boolean abort) throws IOException {
            this.out.println("close " + this.path);
        }

        @Override
        public SerDeStats getStats() {
            return null;
        }

        private void stringifyObject(StringBuilder buffer, Object obj, ObjectInspector inspector) throws IOException {
            if (inspector instanceof StructObjectInspector) {
                buffer.append("{ ");
                StructObjectInspector soi = (StructObjectInspector)inspector;
                boolean isFirst = true;
                for (StructField structField : soi.getAllStructFieldRefs()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append(structField.getFieldName());
                    buffer.append(": ");
                    this.stringifyObject(buffer, soi.getStructFieldData(obj, structField), structField.getFieldObjectInspector());
                }
                buffer.append(" }");
            } else if (inspector instanceof PrimitiveObjectInspector) {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
                buffer.append(poi.getPrimitiveJavaObject(obj).toString());
            } else {
                buffer.append("*unknown*");
            }
        }

        private String stringifyObject(Object obj, ObjectInspector inspector) throws IOException {
            StringBuilder buffer = new StringBuilder();
            this.stringifyObject(buffer, obj, inspector);
            return buffer.toString();
        }
    }

    private static class OrcRecordWriter
    implements RecordWriter<NullWritable, OrcSerde.OrcSerdeRow>,
    StatsProvidingRecordWriter {
        private Writer writer = null;
        private final Path path;
        private final OrcFile.WriterOptions options;
        private final SerDeStats stats;

        OrcRecordWriter(Path path, OrcFile.WriterOptions options) {
            this.path = path;
            this.options = options;
            this.stats = new SerDeStats();
        }

        public void write(NullWritable nullWritable, OrcSerde.OrcSerdeRow row) throws IOException {
            if (this.writer == null) {
                this.options.inspector(row.getInspector());
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.addRow(row.getRow());
        }

        @Override
        public void write(Writable row) throws IOException {
            OrcSerde.OrcSerdeRow serdeRow = (OrcSerde.OrcSerdeRow)row;
            if (this.writer == null) {
                this.options.inspector(serdeRow.getInspector());
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.addRow(serdeRow.getRow());
        }

        public void close(Reporter reporter) throws IOException {
            this.close(true);
        }

        @Override
        public void close(boolean b) throws IOException {
            if (this.writer == null) {
                StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(new ArrayList<String>(), new ArrayList<ObjectInspector>());
                this.options.inspector(inspector);
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.close();
        }

        @Override
        public SerDeStats getStats() {
            this.stats.setRawDataSize(this.writer.getRawDataSize());
            this.stats.setRowCount(this.writer.getNumberOfRows());
            return this.stats;
        }
    }
}

