/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.spark.network.sasl.SaslEncryptionBackend;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.sasl.SparkSaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Throwables;
import org.spark_project.guava.collect.ImmutableMap;

public class SparkSaslClient
implements SaslEncryptionBackend {
    private static final Logger logger = LoggerFactory.getLogger(SparkSaslClient.class);
    private final String secretKeyId;
    private final SecretKeyHolder secretKeyHolder;
    private final String expectedQop;
    private SaslClient saslClient;

    public SparkSaslClient(String secretKeyId, SecretKeyHolder secretKeyHolder, boolean encrypt) {
        this.secretKeyId = secretKeyId;
        this.secretKeyHolder = secretKeyHolder;
        this.expectedQop = encrypt ? "auth-conf" : "auth";
        ImmutableMap<String, String> saslProps = ImmutableMap.builder().put("javax.security.sasl.qop", this.expectedQop).build();
        try {
            this.saslClient = Sasl.createSaslClient(new String[]{"DIGEST-MD5"}, null, null, "default", saslProps, new ClientCallbackHandler());
        }
        catch (SaslException e) {
            throw Throwables.propagate(e);
        }
    }

    public synchronized byte[] firstToken() {
        if (this.saslClient != null && this.saslClient.hasInitialResponse()) {
            try {
                return this.saslClient.evaluateChallenge(new byte[0]);
            }
            catch (SaslException e) {
                throw Throwables.propagate(e);
            }
        }
        return new byte[0];
    }

    public synchronized boolean isComplete() {
        return this.saslClient != null && this.saslClient.isComplete();
    }

    public Object getNegotiatedProperty(String name) {
        return this.saslClient.getNegotiatedProperty(name);
    }

    public synchronized byte[] response(byte[] token) {
        try {
            return this.saslClient != null ? this.saslClient.evaluateChallenge(token) : new byte[]{};
        }
        catch (SaslException e) {
            throw Throwables.propagate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() {
        if (this.saslClient != null) {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
            }
            finally {
                this.saslClient = null;
            }
        }
    }

    @Override
    public byte[] wrap(byte[] data, int offset, int len) throws SaslException {
        return this.saslClient.wrap(data, offset, len);
    }

    @Override
    public byte[] unwrap(byte[] data, int offset, int len) throws SaslException {
        return this.saslClient.unwrap(data, offset, len);
    }

    private class ClientCallbackHandler
    implements CallbackHandler {
        private ClientCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    logger.trace("SASL client callback: setting username");
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(SparkSaslServer.encodeIdentifier(SparkSaslClient.this.secretKeyHolder.getSaslUser(SparkSaslClient.this.secretKeyId)));
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    logger.trace("SASL client callback: setting password");
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(SparkSaslServer.encodePassword(SparkSaslClient.this.secretKeyHolder.getSecretKey(SparkSaslClient.this.secretKeyId)));
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    logger.trace("SASL client callback: setting realm");
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof RealmChoiceCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
        }
    }
}

