# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _util
else:
    import _util

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def disjunction(source: "std::vector< bool > const &", dest: "std::vector< bool > &") -> "void":
    r"""

    `disjunction(const std::vector< bool > &source, std::vector< bool > &dest)`  

    """
    return _util.disjunction(source, dest)

def any_true(b_vector: "std::vector< bool > const &", indices: "std::vector< unsigned int > const") -> "bool":
    r"""

    `any_true(const std::vector< bool > &b_vector, const std::vector< unsigned int >
        indices) -> bool`  

    """
    return _util.any_true(b_vector, indices)
class run_stats(object):
    r"""


    simple class to compute mean and variance sequentially one value at a time  

    C++ includes: util.hpp

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def push(self, x: "double") -> "void":
        r"""

        `push(num_t x)`  

        adds a value to the statistic  

        Parameters
        ----------
        * `x` :  
            the value to add  

        """
        return _util.run_stats_push(self, x)

    def pop(self, x: "double") -> "void":
        r"""

        `pop(num_t x)`  

        removes a value from the statistic  

        Consider this the inverse operation to push. Note: you can create a scenario
        where the variance would be negative, so a simple sanity check is implemented
        that raises a RuntimeError if that happens.  

        Parameters
        ----------
        * `x` :  
            the value to remove  

        """
        return _util.run_stats_pop(self, x)

    def divide_sdm_by(self, value: "double") -> "double":
        r"""

        `divide_sdm_by(num_t value) const -> num_t`  

        divides the (summed) squared distance from the mean by the argument  

        Parameters
        ----------
        * `value` :  
            to divide by  

        Returns
        -------
        sum([ (x - mean())**2 for x in values])/ value  

        """
        return _util.run_stats_divide_sdm_by(self, value)

    def number_of_points(self) -> "unsigned long":
        r"""

        `number_of_points() const -> long unsigned int`  

        returns the number of points  

        Returns
        -------
        the current number of points added  

        """
        return _util.run_stats_number_of_points(self)

    def mean(self) -> "double":
        r"""

        `mean() const -> num_t`  

        the mean of all values added  

        Returns
        -------
        sum([x for x in values])/number_of_points()  

        """
        return _util.run_stats_mean(self)

    def sum(self) -> "double":
        r"""

        `sum() const -> num_t`  

        the sum of all values added  

        Returns
        -------
        the sum of all values (equivalent to number_of_points()* mean())  

        """
        return _util.run_stats_sum(self)

    def sum_of_squares(self) -> "double":
        r"""

        `sum_of_squares() const -> num_t`  

        the sum of all values squared  

        Returns
        -------
        sum([x**2 for x in values])  

        """
        return _util.run_stats_sum_of_squares(self)

    def variance_population(self) -> "double":
        r"""

        `variance_population() const -> num_t`  

        the variance of all samples assuming it is the total population  

        Returns
        -------
        sum([(x-mean())**2 for x in values])/number_of_points  

        """
        return _util.run_stats_variance_population(self)

    def variance_sample(self) -> "double":
        r"""

        `variance_sample() const -> num_t`  

        unbiased variance of all samples assuming it is a sample from a population with
        unknown mean  

        Returns
        -------
        sum([(x-mean())**2 for x in values])/(number_of_points-1)  

        """
        return _util.run_stats_variance_sample(self)

    def variance_MSE(self) -> "double":
        r"""

        `variance_MSE() const -> num_t`  

        biased estimate variance of all samples with the smalles MSE  

        Returns
        -------
        sum([(x-mean())**2 for x in values])/(number_of_points+1)  

        """
        return _util.run_stats_variance_MSE(self)

    def std_population(self) -> "double":
        r"""

        `std_population() const -> num_t`  

        standard deviation based on variance_population  

        Returns
        -------
        sqrt(variance_population())  

        """
        return _util.run_stats_std_population(self)

    def std_sample(self) -> "double":
        r"""

        `std_sample() const -> num_t`  

        (biased) estimate of the standard deviation based on variance_sample  

        Returns
        -------
        sqrt(variance_sample())  

        """
        return _util.run_stats_std_sample(self)

    def std_unbiased_gaussian(self) -> "double":
        r"""

        `std_unbiased_gaussian() const -> num_t`  

        unbiased standard deviation for normally distributed values  

        Source: https://en.wikipedia.org/wiki/Unbiased_estimation_of_standard_deviation  

        Returns
        -------
        std_sample/correction_value  

        """
        return _util.run_stats_std_unbiased_gaussian(self)

    def __iadd__(self, other: "run_stats") -> "rfr::util::running_statistics< num_t > &":
        return _util.run_stats___iadd__(self, other)

    def __mul__(self, a: "double const &") -> "rfr::util::running_statistics< num_t >":
        return _util.run_stats___mul__(self, a)

    def __add__(self, *args) -> "rfr::util::running_statistics< num_t >":
        return _util.run_stats___add__(self, *args)

    def __sub__(self, *args) -> "rfr::util::running_statistics< num_t >":
        return _util.run_stats___sub__(self, *args)

    def __isub__(self, other: "run_stats") -> "rfr::util::running_statistics< num_t > &":
        return _util.run_stats___isub__(self, other)

    def numerically_equal(self, other: "run_stats", rel_error: "double") -> "bool":
        r"""

        `numerically_equal(const running_statistics other, num_t rel_error) -> bool`  

        method to check for numerical equivalency  

        Parameters
        ----------
        * `other` :  
            the other running statistic to compare against  
        * `rel_error` :  
            relative tolerance for the mean and variance  

        """
        return _util.run_stats_numerically_equal(self, other, rel_error)
    __swig_destroy__ = _util.delete_run_stats

# Register run_stats in _util:
_util.run_stats_swigregister(run_stats)

def running_statistics(*args):
    r"""

    `running_statistics(long unsigned int n, num_t a, num_t s)`  

    """
    val = _util.new_running_statistics(*args)
    return val

class weighted_running_stats(object):
    r"""


    simple class to compute weighted mean and variance sequentially one value at a
    time  

    C++ includes: util.hpp

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        `weighted_running_statistics(num_t m, num_t s, running_statistics< num_t >
            w_stat)`  

        """
        _util.weighted_running_stats_swiginit(self, _util.new_weighted_running_stats(*args))

    def push(self, x: "double", weight: "double") -> "void":
        r"""

        `push(num_t x, num_t weight)`  

        """
        return _util.weighted_running_stats_push(self, x, weight)

    def pop(self, x: "double", weight: "double") -> "void":
        r"""

        `pop(num_t x, num_t weight)`  

        """
        return _util.weighted_running_stats_pop(self, x, weight)

    def number_of_points(self) -> "unsigned long":
        r"""

        `number_of_points() const -> long unsigned int`  

        returns the number of points  

        Returns
        -------
        the current number of points added  

        """
        return _util.weighted_running_stats_number_of_points(self)

    def squared_deviations_from_the_mean(self) -> "double":
        r"""

        `squared_deviations_from_the_mean() const -> num_t`  

        """
        return _util.weighted_running_stats_squared_deviations_from_the_mean(self)

    def divide_sdm_by(self, fraction: "double", min_weight: "double") -> "double":
        r"""

        `divide_sdm_by(num_t fraction, num_t min_weight) const -> num_t`  

        """
        return _util.weighted_running_stats_divide_sdm_by(self, fraction, min_weight)

    def mean(self) -> "double":
        r"""

        `mean() const -> num_t`  

        """
        return _util.weighted_running_stats_mean(self)

    def sum_of_weights(self) -> "double":
        r"""

        `sum_of_weights() const -> num_t`  

        """
        return _util.weighted_running_stats_sum_of_weights(self)

    def sum_of_squares(self) -> "double":
        r"""

        `sum_of_squares() const -> num_t`  

        """
        return _util.weighted_running_stats_sum_of_squares(self)

    def variance_population(self) -> "double":
        r"""

        `variance_population() const -> num_t`  

        """
        return _util.weighted_running_stats_variance_population(self)

    def variance_unbiased_frequency(self) -> "double":
        r"""

        `variance_unbiased_frequency() const -> num_t`  

        """
        return _util.weighted_running_stats_variance_unbiased_frequency(self)

    def variance_unbiased_importance(self) -> "double":
        r"""

        `variance_unbiased_importance() const -> num_t`  

        """
        return _util.weighted_running_stats_variance_unbiased_importance(self)

    def __iadd__(self, other: "weighted_running_stats") -> "rfr::util::weighted_running_statistics< num_t > &":
        return _util.weighted_running_stats___iadd__(self, other)

    def __sub__(self, other: "weighted_running_stats") -> "rfr::util::weighted_running_statistics< num_t >":
        return _util.weighted_running_stats___sub__(self, other)

    def __isub__(self, other: "weighted_running_stats") -> "rfr::util::weighted_running_statistics< num_t > &":
        return _util.weighted_running_stats___isub__(self, other)

    def __mul__(self, a: "double const") -> "rfr::util::weighted_running_statistics< num_t >":
        return _util.weighted_running_stats___mul__(self, a)

    def __add__(self, *args) -> "rfr::util::weighted_running_statistics< num_t >":
        return _util.weighted_running_stats___add__(self, *args)

    def multiply_weights_by(self, a: "double const") -> "rfr::util::weighted_running_statistics< num_t >":
        r"""

        `multiply_weights_by(const num_t a) const -> weighted_running_statistics`  

        """
        return _util.weighted_running_stats_multiply_weights_by(self, a)

    def numerically_equal(self, other: "weighted_running_stats", rel_error: "double") -> "bool":
        r"""

        `numerically_equal(weighted_running_statistics other, num_t rel_error) -> bool`  

        """
        return _util.weighted_running_stats_numerically_equal(self, other, rel_error)

    def get_weight_statistics(self) -> "rfr::util::running_statistics< double >":
        r"""

        `get_weight_statistics() const -> running_statistics< num_t >`  

        """
        return _util.weighted_running_stats_get_weight_statistics(self)
    __swig_destroy__ = _util.delete_weighted_running_stats

# Register weighted_running_stats in _util:
_util.weighted_running_stats_swigregister(weighted_running_stats)



