#
# See top-level LICENSE file for Copyright information
#
# -*- coding: utf-8 -*-

"""
This script cleans up files generated by running PypeIt tests
"""

import os
import shutil
from pypeit.tests.tstutils import data_path

def delete_if_exists(fname, f_or_dir):
    if f_or_dir == 'file':
        if os.path.isfile(fname):
            os.remove(fname)
    if f_or_dir == 'dir':
        if os.path.isdir(fname):
            shutil.rmtree(fname)

if __name__ == '__main__':
    flist = ['fitstbl.fits', 'MasterArc_A_01_22.fits', 'tmp.fits', 'tmp_detector.fits', 'tst_pypeitimage.fits', 'shane_kast_blue.calib', 'shane_kast_blue.sorted', 'sensfunc.fits', 'datacube.fits', 'tst_coadd_files-SPAT0175-DET01.fits']
    try:
        from pypeit.tests.test_fluxspec import kast_blue_files
        f = os.path.basename(kast_blue_files()[1])
        print(f'adding {data_path(f)} to files to delete')
        flist.append()
    except:
        pass
    for fname in flist:
        delete_if_exists(data_path(fname), 'file')
    for dirname in ['setup_files', 'shane_kast_blue_A', 'keck_lris_blue_A']:
        delete_if_exists(data_path(dirname), 'dir')

    # TODO: just create new tests/files/out dir and make all tests write to that