
# ___________________________________________________________________________
#
# Pyomo: Python Optimization Modeling Objects
# Copyright 2017 National Technology and Engineering Solutions of Sandia, LLC
# Under the terms of Contract DE-NA0003525 with National Technology and
# Engineering Solutions of Sandia, LLC, the U.S. Government retains certain
# rights in this software.
# This software is distributed under the 3-clause BSD License.
# ___________________________________________________________________________
#
# Cache of autogenerated quadratic ROM geometries
#
# THIS FILE IS AUTOGENERATED BY pyomo.contrib.trustregion.GeometryGenerator
#
# DO NOT EDIT BY HAND
#
GeometryCache = {
    1: ( 3.225505, """1.000000000000000000e+00
-1.000000000000000000e+00
0.000000000000000000e+00
""" ),
    2: ( 5.184909, """3.907406244473407009e-01 -9.205008225995793270e-01
2.417136459205435628e-01 9.703476250168276973e-01
-8.490885806356679444e-01 5.282504919392947418e-01
-7.300366688534025705e-01 -6.834079763431410992e-01
9.895946114920586290e-01 1.438836505857484793e-01
0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    3: ( 7.491430, """-3.046667315180474622e-01 -6.668333542957874949e-01 -6.800819511681945873e-01
4.412261580405417716e-01 -8.965225446123187281e-01 3.958288092895608651e-02
-9.663737912341351377e-01 1.774910797880437097e-01 -1.860607755853939949e-01
2.771999534988984770e-01 1.807842661246170657e-01 9.436510132999339495e-01
-5.662785696540558744e-01 -5.574312466238501296e-01 6.071235350716830403e-01
-2.364692691964021543e-01 2.911079468085273625e-01 -9.270050960111508864e-01
4.343827361412194721e-01 8.810949099775366999e-01 1.870384937763991950e-01
7.305560306718085206e-01 -1.073843745578196840e-01 -6.743563465630597609e-01
-3.932907858084084829e-01 7.126700052844500144e-01 5.808819341019882954e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    4: ( 13.028996, """-7.494923632858466744e-01 3.580832620329920668e-01 1.159045821664435594e-01 -5.446133515264107716e-01
2.817824006409731519e-01 -3.929804210735780012e-01 5.380532343645405557e-01 6.904084184971241989e-01
6.297569698006716399e-01 -3.853826155110587903e-01 5.239190486656604140e-01 -4.247295952657416662e-01
3.912731056671071572e-01 7.394688648817693277e-01 -2.189456051742271481e-01 5.021493568919269679e-01
-4.639672871561680290e-01 2.544324770165806715e-01 8.469239707693225760e-01 -5.213692381102496415e-02
-5.871861084365098682e-01 -5.493273415304923413e-01 4.185679971050274562e-01 4.221999262265627717e-01
6.539080466427830141e-01 -6.943960578570733677e-01 -2.197938222212503234e-01 -2.047170170790624244e-01
-1.435424753567902112e-01 9.420236707747734473e-01 2.387509931309080846e-01 -1.870425746921582644e-01
3.747548368483367698e-01 3.244204765063415929e-01 8.171959467190799131e-01 2.941104407328675174e-01
-2.112777617956367870e-01 9.365202641475689482e-02 -3.523489464665807147e-01 -9.068854532094593468e-01
-3.250734280889678862e-01 -7.201209944961792786e-01 5.825982393320086605e-02 -6.102121045600396032e-01
-3.718852377239095230e-01 5.297762034587645275e-01 -6.411927195091585707e-01 4.122019416018057880e-01
4.555184108743520199e-01 -5.238143793842192641e-01 -4.858522443477759079e-01 5.311017510487603399e-01
-5.740880946093486203e-01 2.259680316521991972e-01 1.020993185285028193e-01 7.803441788435750981e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    5: ( 27.939993, """-1.792890140063028714e-01 -9.040597803235643493e-02 -1.701488898378634984e-02 -8.309422019788933467e-01 -5.185824516082262470e-01
-1.984570306926707398e-02 4.896243500901009127e-01 3.288979578376805546e-01 -3.801065531789645791e-01 -7.121932921820754991e-01
4.522907811049685090e-01 -1.830936041543237414e-01 7.731231604062615004e-01 -2.981791510235317633e-01 -2.743711978024604980e-01
-6.059387838427716666e-01 -2.934187339331710831e-01 2.337138814978062806e-01 -3.535478641837228042e-01 -6.059087110601358850e-01
-1.255686338399737423e-01 7.880922475799685412e-01 6.015226581872661349e-01 3.531134999484853570e-02 -8.168705453308229558e-03
-4.373923844327380350e-01 -5.593425728321131940e-01 1.231242635700003918e-01 -4.711447502932418763e-01 5.086126505006142162e-01
-3.844036643902984385e-01 -2.188909087318130844e-02 1.402446984808549931e-03 -7.480002077316054709e-01 5.406000489086052463e-01
-2.104476965705877611e-01 -3.126188480847950091e-01 -6.091286401582590715e-01 2.606034949013047441e-01 -6.473247569917633948e-01
-3.578478517014510585e-01 -6.715549884255661572e-02 3.725800072265999519e-01 5.476767047622590479e-01 6.547285080731125584e-01
9.909879105634737673e-02 -3.734650422090362576e-01 3.699348866142893599e-01 -4.461271775352837476e-01 -7.175109845772728034e-01
2.173108503992737528e-01 2.011343304727418180e-01 6.283352508319596241e-01 -6.049788425812145931e-01 3.892510603647199030e-01
9.200267723175158396e-01 -2.839706602571661631e-01 2.361026602074088251e-02 -1.956966180535371358e-01 -1.845448220703057307e-01
9.601587811816574003e-03 -6.101933687159926123e-01 4.905652982579234989e-01 1.503771920661452488e-01 -6.035762176709225102e-01
-3.900839437565781775e-01 7.749749506684475708e-01 -2.279546214772875667e-01 1.290092784271142379e-01 4.226601936385939728e-01
-4.406341918709312799e-01 3.867651446334802179e-01 2.684732440391381925e-01 7.587050599224767211e-01 9.242824857167271368e-02
-4.251262219488805560e-01 -3.434460523899415252e-01 -4.527254675600436706e-01 6.699498712792015809e-01 2.179892784169847608e-01
7.711193341185668126e-01 -1.496446899356900229e-01 1.997495915364994878e-01 4.995699899899759266e-01 3.057962803975980415e-01
8.502352373897262838e-01 -2.289937810130461826e-01 -1.381785588264014819e-01 3.640760781166162835e-02 4.519325849419089658e-01
4.143482077196752322e-01 2.725819784558845549e-01 -7.413840555371796759e-01 1.268742049554182350e-01 -4.338977369066852052e-01
-3.946019493412397106e-01 2.970040044586395589e-01 6.764788447802396743e-01 -5.207035621734958930e-01 -1.652939678761774778e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    6: ( 43.992226, """3.284319064473320005e-01 -3.619866569176278248e-01 -5.352745244150225457e-02 -7.091826310724660409e-01 3.945204003295847972e-01 -3.156685039483853039e-01
-1.704981031929917179e-01 -7.012449184050872919e-01 -1.962416253639923669e-01 -4.714937213374361530e-02 5.113934213864861356e-01 -4.206291608568651919e-01
1.727113176485547963e-01 2.823924780999576001e-01 5.961605936347583179e-02 -3.863203064465925429e-01 -4.203286373376440843e-01 -7.489670700341407583e-01
-5.113685292054617193e-01 4.358991029525413619e-02 6.445672741300612074e-01 1.597422553391866784e-01 -4.434672104557078054e-01 -3.145702167863642096e-01
1.242800488717206581e-01 1.232771192855668246e-01 5.932712476224868414e-01 -7.477842015853791713e-01 1.665911955798365374e-01 -1.745067605342284500e-01
3.562337522788288635e-01 -6.117134645662176684e-01 2.476196941117389250e-01 6.070491818599114131e-01 7.048006056428735011e-02 -2.532044430096283549e-01
-2.120495537208839099e-01 4.100042596125547112e-01 -2.769528048317726476e-01 7.634971538813972725e-01 -3.005169871017401295e-01 -1.923285580470238121e-01
6.396886072503976672e-02 7.567697049373836027e-01 3.863346974238796028e-01 4.548865184929446470e-01 -7.131837262081758277e-02 -2.488876154673261010e-01
-2.878818838347068643e-01 -4.729781047990582743e-01 -4.543887257749707476e-01 -4.215724408243429755e-01 -3.864932168560913373e-01 -3.998078159449938718e-01
2.751157842104672291e-01 4.940615437163031198e-01 2.006995105590432538e-01 -7.587441635335533396e-01 2.375061629093292992e-01 8.850039346883782632e-02
-5.278871659410603323e-01 1.273659696772725947e-01 3.005981366439289260e-01 5.025574702161486051e-01 5.683569675022865919e-01 1.978892535501385053e-01
5.567703437537926403e-01 -4.924555313041570348e-01 -5.464621107248350818e-01 3.201678605054958382e-01 1.490412159482654986e-01 -1.554115587540961241e-01
-1.797269553906882811e-01 7.420218674206056075e-01 -4.206520645101520239e-01 3.844927984744243021e-01 1.811779403536650235e-01 -2.439127964037293428e-01
-7.481309647927254503e-01 9.184355907997905633e-02 -1.590726974624929457e-01 -4.877367489787559074e-01 2.965380727109283021e-01 -2.841456179925297421e-01
2.765664198642177607e-01 2.066237242394946827e-01 3.748441420254045031e-01 2.027676803079625500e-02 2.638249483459714773e-01 8.187153171173724431e-01
-5.165382595205922911e-01 2.016487874907196276e-01 -6.231135478352068935e-01 4.336230414922334631e-01 2.342146108697517881e-01 -2.477298395456969393e-01
1.388349289052491498e-01 2.848500215632916999e-01 -3.506753821529078330e-01 -8.728289023233882782e-01 -7.244377015447271695e-02 9.764072673804598257e-02
4.308796722243988242e-01 4.248317069092267251e-01 9.610217500612903974e-02 -4.576639705450505358e-01 4.423678459233833515e-01 -4.684863709709424784e-01
-9.412228069507212400e-03 8.382392251003197015e-02 -2.720733209295550514e-01 5.324501058476608373e-01 4.359003900976159973e-01 -6.673445906813990636e-01
2.806792268562921522e-01 -5.734648342506095675e-01 3.558019362238021288e-01 -9.871453937490581865e-02 3.231707022421324571e-01 -5.929404477660431549e-01
-5.559627444967005783e-01 -4.828827233180980061e-01 -5.047228427657980167e-03 -5.449582629269370537e-01 2.990093657899664525e-01 2.670545236002005440e-01
3.660915990510865692e-01 -3.822151870048738909e-01 7.248036437776694818e-01 -1.546486509974220325e-01 4.128449985019244650e-01 1.381925650260109467e-02
9.803773648396027496e-02 3.547806965680211366e-01 4.133073674184449264e-01 -1.889481408209762181e-01 -5.527990549679783205e-01 5.936396925006384162e-01
7.260387957788509983e-01 1.423098811010514997e-01 2.502486124114835508e-01 -3.202260375507992585e-01 -5.730750269930077329e-02 5.330687870810026929e-01
-8.023454651147828853e-01 4.841577618935540839e-01 9.855193690354734082e-02 -2.439862556239621658e-02 -4.194550352653991787e-02 -3.313092418649042914e-01
4.164124327745847287e-01 -1.524883952486962013e-01 -6.318003803983399669e-01 -4.916834451691876606e-01 -3.874402896166557198e-01 -1.109669599568376547e-01
-2.797959340620627122e-01 8.657238458241097237e-03 4.127163168456902120e-01 -1.102972489322576535e-02 7.671975193982031316e-01 -4.032255457085603401e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    7: ( 56.737181, """2.001555017655779756e-01 3.006202681227533313e-01 2.988604659384096474e-01 -7.145135200004089360e-02 -4.515819828920026313e-01 -4.562521190108029256e-01 6.025363659802581706e-01
-8.996288355716089424e-02 -2.298720199245437579e-01 -2.358804579319789263e-01 7.742468416679438858e-01 2.419323483489354554e-01 2.321436438367840416e-01 -4.141809257069356542e-01
2.252600220024482125e-01 3.694267898973880304e-01 -8.535479103100079845e-01 -2.268089290940947245e-02 8.845403164742277058e-02 -2.615920181483746831e-01 8.642228660591626255e-02
-3.724673258540752568e-02 -3.454826338674508168e-01 8.243192222662673041e-01 2.006126815940917629e-01 -3.008370930693174405e-01 -1.874528039341130659e-01 -1.840252486060696691e-01
4.903867110759909109e-01 6.045598580334661243e-01 -8.791573738514046887e-02 -4.434727856095600496e-01 -8.368211351409020338e-02 8.035800928759431749e-02 4.197271225683443796e-01
-1.260256714449047889e-02 -2.066974378027816861e-01 -4.899390866172292358e-01 -3.807267558758712922e-01 -3.558147183654561951e-01 -4.210288495719275992e-01 5.179331687531643080e-01
1.197835079835432442e-01 3.533221171824632023e-01 -1.272442784591559621e-02 4.351511262066456442e-01 -4.019439133756851357e-01 5.064271427043671725e-01 -5.032589975891841316e-01
-4.630698424907958577e-01 4.148685591557336183e-01 -1.691173550557783789e-01 -6.348607587305675481e-02 -6.942505379725116832e-01 2.133268286275409320e-01 -2.309265959160339832e-01
1.165630983902441187e-01 -8.808512074899564892e-01 -1.820156381423295999e-01 6.472698965602191601e-02 -6.418803590572502715e-02 3.261230457901700963e-02 -4.098917567791189875e-01
-2.892717823662326881e-01 -2.549493894619916379e-01 4.385336391829770530e-01 -2.966243527600024854e-01 -4.424442499480976676e-01 3.384869431487936842e-01 -5.105825696201499175e-01
-2.460105215650006671e-01 -5.163653757437971364e-02 4.079627362253740452e-01 -3.735315483999083197e-01 3.861103271826786254e-01 4.348737669326531163e-01 5.409775425512672875e-01
-2.242768764213612098e-01 -2.172582529265408846e-01 -3.925611449894671895e-02 -5.747703879087803086e-02 -5.503904237837813351e-01 6.709821004689253687e-01 3.801413999838491042e-01
-1.278981598856359925e-01 -3.429602204176031011e-01 6.844388302450407080e-01 3.812133171482675054e-01 4.107168860941438626e-01 -1.862079610468612145e-01 -2.210847735835572425e-01
-5.730312327585908305e-02 -2.696309588329942261e-02 -3.835698260823339201e-01 -6.588368983041373861e-01 4.341040250241032239e-01 -2.659271108230547020e-01 -3.945046776180824444e-01
-6.144522208397217300e-01 2.505777340100188641e-02 -4.937675043309202594e-01 6.061913010274651015e-01 -5.010519347544552943e-02 8.494184989285263887e-02 2.864762200131296122e-02
-1.673242263600258073e-02 4.058129134355192846e-01 8.542561794737563163e-01 -2.344275445035021443e-01 -7.650056677776956304e-02 -2.069732557552855234e-01 4.044435950046948447e-02
-5.351103402540540177e-01 4.567336793581659449e-01 2.812917166017913639e-01 4.474164761754731434e-02 2.377406197114381725e-01 -1.270851006746291367e-01 5.926661791924424660e-01
2.817857422564106762e-01 -3.548761155490783303e-01 1.249607867787986826e-01 7.818380896982547457e-01 1.742482713867037347e-01 3.697863554492281657e-01 2.587146267088862722e-02
2.314912815205968921e-01 -4.592806781623223061e-02 -2.479796662930163209e-01 9.941259854570848320e-02 -1.949498316204316128e-01 8.545279725642179747e-01 -3.235770801195069768e-01
-4.960758122229445106e-04 5.281676685133134264e-01 6.993668069841395551e-01 -1.356174344811410248e-01 1.247234452058520182e-01 -1.442416300335283841e-01 -4.209169312118670181e-01
1.901520698505994866e-01 -1.486602495400852486e-01 -3.421401631036378732e-01 3.022606087349242188e-01 6.082698866076629018e-01 -2.549835598267181230e-02 6.022279739644310625e-01
-1.232682953266781289e-01 -5.293110250567498731e-01 -7.188219441793283759e-02 4.779031071491237626e-01 -2.609492183652100672e-01 3.599859074817460258e-01 -5.228689972379630957e-01
-1.234765476380225435e-01 2.823486840681018739e-01 5.921649899689328533e-01 1.017879039531652818e-01 -3.754786609815465304e-01 4.540265076575133452e-01 4.437209883971548474e-01
3.705780324552307992e-01 -3.388978640200496217e-01 -5.918591351590770655e-01 5.149862976191516006e-01 -3.367264256395059441e-01 1.104650776836097192e-01 8.200498707957792899e-02
6.604199101093273239e-01 -2.047572204830263864e-01 1.139059827959000709e-01 2.541572577476822192e-01 3.761860173624452797e-01 -3.017030571390812987e-01 -4.602269918884006050e-01
-7.739920595365796796e-01 8.526820277103945578e-02 1.181571369843143794e-02 1.981309930845752687e-01 3.478143965079352057e-02 5.944704485695274238e-02 -5.912075982032291011e-01
-5.159734302546714613e-01 -3.009266344124751358e-01 -1.952736476062527995e-02 -6.032197706385126201e-01 -2.986353361928018590e-01 -4.343676736701296837e-01 -3.317876363196860245e-02
5.637095552438928792e-01 -1.372208235768547779e-01 -2.828217048757200036e-01 -5.064332185739807146e-01 -5.151631411375896530e-01 1.284435554750712472e-01 -2.122462069149553821e-01
-7.314851470209328410e-02 4.969847471270414374e-01 2.434118357029146640e-01 2.603303173415072447e-01 3.881141209415232551e-01 -6.840028629766260471e-01 4.627928908403261543e-02
-4.212184564732773806e-01 -5.755786957543280735e-01 -4.068020163193535044e-02 2.049388710148971338e-01 4.482891081548654455e-01 4.822175982198781963e-01 1.188798584248327572e-01
-8.044943902301192329e-02 -3.026262252890123960e-01 6.672134277661124768e-01 -1.029469609887269932e-01 -5.003489615617506825e-01 1.171513358016709472e-01 4.267316507407772908e-01
-5.279469014981310604e-01 3.462636844045782203e-01 -2.634174253054839543e-01 3.094920780859680351e-02 -6.214905497128365985e-02 5.650910525819199393e-01 -4.558909232487234897e-01
8.025979589743374998e-01 1.623123682094013975e-01 -3.390490818342107859e-01 1.161346365741935255e-01 4.134865092011210108e-01 1.230228086733501924e-01 1.222455435851693001e-01
5.991484774145140468e-01 -3.105461710387147911e-01 4.824115759062167497e-01 -2.751309999728845379e-01 -4.258973364797444261e-01 -2.323893769352869121e-01 -2.776361319699635968e-02
5.496697588547828639e-01 4.302495382526485557e-01 2.473588763611741514e-01 5.150564300095973325e-01 -1.545922554345208200e-01 2.888059990411958045e-01 -2.810182924695445172e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    8: ( 90.576623, """-6.122663323504302646e-01 2.086361016246734701e-01 3.139854998681574916e-01 -1.710850964757892334e-01 -1.418383923375555744e-01 2.104676447691545757e-02 -5.685677797204048423e-01 -3.315320422423517766e-01
-1.169740387763179151e-01 4.907502686249946566e-01 -3.463091476642251032e-01 4.239764849526484469e-01 -1.929383364160506265e-01 -3.442509816527157818e-01 -3.991684620759254343e-01 -3.615601767399383992e-01
3.681913340018178049e-01 1.997934326703671715e-01 3.785477021039838075e-01 -1.470569098350734683e-01 1.880491819349727756e-01 1.247753158132640927e-01 -6.179748062620050719e-01 -4.762031004645296828e-01
6.132801936509444385e-01 -4.678916313889496803e-01 1.300566363756746613e-01 1.267784490049166934e-01 -1.427960497293896958e-01 -2.265318285444930801e-01 3.755367869114042967e-01 3.990514529085555373e-01
1.818798822589580144e-01 -1.089908146177737402e-01 3.176931366377705457e-01 -1.682618999319924202e-01 -1.039544336626043244e-02 5.891721363580004756e-01 -3.877385522018146902e-01 -5.729106896855407083e-01
1.193526437774786314e-01 2.371411002050115013e-01 1.243002998316438817e-01 3.484013783291408095e-01 2.566399431164068101e-01 2.191370382017160667e-01 4.448083481903419290e-01 -6.935022649729185584e-01
-1.547045842628182455e-01 -8.935008887747671047e-02 4.507543735721185052e-01 -2.110355856002588959e-01 -3.681325338843163819e-01 7.037415365384278587e-01 2.823191955305550671e-01 -9.944691359234821004e-02
-2.995468373456987021e-01 2.286288980700141027e-01 -1.567534968729185074e-01 -2.248451280446113199e-01 -3.514772128032562226e-01 -7.100402585855242199e-01 3.921492973120414560e-01 3.740397708430553275e-02
6.331802925602423304e-01 -4.772405744363373281e-01 -2.204596325707166293e-01 4.653219218280710834e-01 2.403622253407134701e-01 1.792265717088223909e-01 -5.805266343288124214e-02 1.137142717038061440e-01
-4.293088273455240023e-01 -1.063638659119385682e-01 3.503643872803867132e-01 1.794464322673782475e-01 1.832773217064923021e-01 -6.338141247074292606e-01 -1.079463245544068084e-01 4.499567785335295000e-01
-1.759087642338557633e-01 -4.744628887581242571e-01 2.862164807863350549e-02 -4.426790244626255810e-01 7.023694587357760533e-01 2.072310430214935606e-01 6.634857758959557261e-02 -8.054477583536237550e-02
2.460950386412058544e-01 7.541420397589669866e-01 9.245398826326261046e-03 5.164629637084506841e-01 -2.282131035914095607e-01 -1.708817454763191662e-02 -8.508113982657489194e-02 2.104174869824530780e-01
-6.844454882289598974e-01 -4.048292662564391131e-01 4.101510381421172302e-02 1.841582004672414896e-01 -1.133431423151074757e-01 2.186245022062678622e-01 -5.205367855425662160e-01 2.119602102474883731e-02
-3.611728982717458958e-02 -1.807519938867716836e-01 3.403972493598836913e-01 -2.436880140557793339e-01 7.270990462247306149e-03 -2.576161383664805071e-01 -3.927650995538976009e-01 7.550408975933218247e-01
3.109780051400131140e-01 1.927759787134758333e-04 -5.982351429498088402e-01 4.353101838372354648e-01 -3.642722772256265507e-01 1.800143157424112517e-01 4.341931329249175686e-01 4.784640255512064011e-02
3.716520116411125563e-01 1.085000470894057108e-02 1.623862142364578681e-02 -5.269587396824269021e-01 6.149163724100636941e-01 4.420941164443373816e-01 4.325057458175823877e-02 9.147616319672861873e-02
-5.326950820896074745e-01 -2.614172384731594523e-01 3.840648291780976442e-01 -3.826536067813297581e-01 -4.320538351252063425e-01 1.016184991898528012e-01 -9.263340394108347808e-02 -3.852137300285943255e-01
2.419953654167200097e-01 9.435058550556070511e-02 4.353401345057106298e-02 5.496654161450978959e-01 -2.101680801246204669e-02 -6.015350442729440195e-01 4.570798770298233060e-02 -5.139392904333804912e-01
-3.933920679714380531e-01 1.065798231052887540e-01 -2.114996252259295217e-01 -2.301182767764515524e-01 5.756191678922044641e-01 5.981197993320342965e-01 5.748805534362924630e-02 -2.093019638742787680e-01
-6.256737046189500551e-02 -3.065817094370419937e-01 5.104959513804049193e-02 -3.694454611596896809e-01 4.663650226538204602e-02 -4.388765706166938840e-02 7.629957543758066896e-01 -4.203966682497297658e-01
2.299795796739544443e-02 4.463382470299014360e-01 -3.453102116074256989e-01 -1.217760172834139454e-01 3.588544539279986956e-01 -2.959960737494606309e-01 -4.778121819310596763e-01 -4.706272904975342675e-01
6.479247926487111675e-01 -8.626423905940314163e-02 -6.322689836839644195e-02 -1.052342431072236795e-01 7.136834344387789075e-01 -1.550453969310527369e-01 -1.426650792166067327e-01 6.279819265925846994e-02
4.436943161143870884e-01 -2.856825281824178497e-01 -5.676177320273489285e-02 2.522582104495185717e-01 -7.494275415566482579e-01 -1.219120988645090026e-01 1.845658861192040756e-01 2.099904214258768720e-01
-5.315830698890273709e-01 -2.460648784755862795e-01 -2.416846885882419083e-01 8.985759964513630182e-02 -3.976310270541847380e-01 1.710664081659668545e-01 6.180057214838798885e-01 -1.451909673856797700e-01
-5.285528777199284267e-01 -2.510910482816772205e-01 -2.826253095140150440e-01 5.055856244234396835e-01 3.577477482731566960e-01 -7.748298774382225695e-03 3.302214409384426896e-01 -2.915502772102715467e-01
-1.784700444591825197e-01 -5.695399655713352383e-01 5.603303432425251751e-01 1.574314908519890144e-02 1.872126991393214535e-01 3.976857489727474437e-01 3.660048862897894995e-01 4.891425255779723036e-02
-2.437285520720588183e-01 -1.353937687015043523e-01 -4.137471540494804256e-01 -3.847428398907007940e-01 -5.287149927863601384e-01 5.252878821426523182e-01 -1.618683753536642456e-01 -1.462288832885867973e-01
-2.946676136375531718e-01 -1.363681512369111226e-01 -9.257900937166982369e-02 4.076624371041750461e-01 1.523042538738735296e-01 3.372404699648376414e-02 -4.844053322445480703e-01 6.788466440946526737e-01
-1.293644275562984003e-01 -1.824628175323958212e-01 3.161683055047919549e-02 -4.384408540887522326e-02 -3.382998279238834671e-01 -1.941049686799375396e-01 8.678276171068387557e-01 -2.044552563493287067e-01
2.570746041183061825e-01 -1.815808064523252371e-02 -4.550708749147422960e-01 -4.825583449049540841e-01 7.874356574201650527e-02 1.790160790253927589e-02 2.020336133259836020e-01 -6.680511035593034164e-01
4.831551320690314344e-01 1.215596178618974510e-01 -2.843139880752832971e-01 -1.439765928381477877e-01 5.288944252819302028e-01 4.383435029141431460e-01 -5.629031051275804054e-02 4.185423943414868786e-01
2.350674092412013971e-01 6.553758188294139808e-01 -2.422259111498908102e-01 3.595468768342390820e-01 -1.047663463021108049e-01 2.117598997119566062e-01 7.348934881995856927e-02 5.158096293199274651e-01
1.074589386130943292e-01 -1.111544850210909458e-01 -7.828464052110145621e-02 -3.164906207036584096e-01 6.704505460958823937e-01 -5.545173250257581232e-01 2.067677973128990987e-01 2.646812016697087655e-01
-1.336173742894337380e-01 1.007860658212703930e-01 -1.056393837868517954e-01 1.556467414395733551e-01 5.915792260115725343e-01 -2.780115704160957546e-01 6.966568074339219985e-01 1.549705049967420589e-01
-2.860846705786293520e-02 4.270595985266347622e-02 -1.585186518990799875e-01 6.548745630975868481e-01 4.002492124534212659e-01 -5.423220249537479276e-01 -2.908068831841303936e-01 6.698989540758235051e-02
-2.013112392776736370e-01 8.883500621482034454e-01 1.050461884552786052e-01 1.317551956905506083e-01 7.510298679291077528e-02 3.702122343729994519e-02 -1.687537191491781524e-02 3.669032719042658597e-01
-1.314668787236905959e-02 7.519504906442246728e-02 -4.944468440040188789e-02 -3.503866397023452373e-01 -4.346042877059007048e-01 -3.891669826731983806e-01 -6.963302446882485564e-01 2.091641894156799353e-01
-6.613045990489646586e-01 1.367457095572457704e-01 3.960881705185569368e-01 4.421389693921882191e-01 -8.299712033917329662e-05 3.455161737499882757e-01 -2.508519960369934299e-01 9.641563144714596079e-02
-4.433160544007630488e-01 6.410118696833271290e-01 3.479812292351042863e-02 4.777819817803557467e-01 -2.773279670888994519e-01 -1.799927226535033911e-02 -9.577404563248849423e-02 -2.769127740175651442e-01
-3.964151595802576367e-01 2.597145514142387146e-01 -3.841827689322959150e-01 3.407400864168846823e-03 -3.626374815032357146e-02 -5.889498224660130177e-01 3.501183147978019772e-01 -3.962771448670908692e-01
-2.930559078424894298e-02 4.101056653858337064e-01 2.970778664279538628e-01 -5.935351850853423650e-02 -5.532065586540527713e-01 6.318823496008615370e-01 -1.276091194563025166e-01 1.325878540558011742e-01
4.161967602961076373e-01 -6.392326876725767937e-01 5.558679595390405570e-01 9.728890771529516077e-03 -7.523259145968458350e-02 -3.010280981962182995e-02 1.688757933604261019e-01 -2.720162355674526355e-01
2.217105051662403292e-01 -3.785494048492978880e-01 -7.213623621982834244e-01 -1.348365876930203988e-01 1.003022823038585698e-01 -1.508324057711281363e-01 -3.292534767536848817e-01 -3.574652746627697275e-01
4.249422838424430915e-01 2.598575671645488305e-01 -6.472357326540241207e-01 -1.832337056634348593e-01 1.032012264589183131e-01 3.074704024717259121e-01 -4.278750348806123482e-01 -1.055643342323035055e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    9: ( 128.375374, """-2.196571421568267457e-01 -1.022556133726787719e-01 1.454513480926617197e-01 -2.105756193729878267e-01 -2.045368244220631959e-01 -1.153242767070083719e-01 -5.564087444358978285e-01 -2.794875836862754093e-01 -6.579949404325241558e-01
-2.862373973595725984e-01 9.848200356829037161e-02 5.422263799144994012e-01 2.945571285117468685e-01 -4.031064398517677505e-01 4.375850054083428309e-01 -2.632494002972230462e-01 2.697721732354196322e-01 1.776045812374485167e-01
1.204754514012691818e-01 -1.230377503817351725e-01 3.503525904932303647e-01 -3.369222172452088215e-01 -1.296810493064169123e-01 -6.388081843122291881e-01 -3.976855760637984516e-01 3.886336032208021485e-01 -9.453025113217571485e-04
-4.857985456161622029e-01 -2.675821903477368369e-01 2.401852484953196087e-01 9.996017236994196586e-02 2.866714781404759438e-01 -4.128893911080425139e-01 2.257824572063240331e-01 4.770894739106669724e-01 -3.057258331637093818e-01
-6.229307915774033588e-02 -7.601215468745085857e-03 4.268009172075808988e-01 -4.961575970924836376e-02 -3.422192114765883475e-01 -5.594150836082684153e-01 1.587028678715906443e-02 -3.064481762282006971e-01 5.359286072633985265e-01
-3.252175292324500089e-01 -4.829243276758488079e-01 -1.793242570334500907e-01 5.369464295494992268e-01 1.851216760682486695e-01 -4.559240454150002564e-01 1.444228858579599262e-01 -5.372801048936900505e-03 -2.784338125365993788e-01
1.640953767205364233e-01 -4.140482760408321083e-01 -6.411698444874169844e-02 1.175653109827998061e-01 8.403936113691445886e-02 7.026308610648530906e-02 7.720678025111280540e-01 1.661941980040259823e-02 4.187358715549758248e-01
5.740574028378644250e-02 -6.836765826342364738e-01 1.319240687268442569e-01 -2.601564524068955553e-01 -2.704469306533269224e-01 1.946694509680976792e-02 -7.647073845335849995e-02 -4.503645866317868007e-01 -4.025034567787293960e-01
-3.752526793793824478e-01 2.506114788838457175e-01 3.997730339656622722e-01 5.444076920135216408e-02 -1.664908725277618184e-01 2.221979584385907758e-01 4.196279550574982808e-01 -6.570889859401898847e-02 6.132704247258224939e-01
-1.018992596234251091e-01 5.401455368775998078e-02 -2.461228027292359788e-01 3.150459253654280811e-01 2.011827645388628572e-01 -1.592325116865406509e-01 6.613102529064528445e-01 4.358062086956684955e-01 -3.657605775682551963e-01
4.668144503124183053e-01 2.871059000876769463e-01 2.167880946963491040e-01 3.082871971227410524e-01 -3.345281841680260437e-01 4.001828624497755782e-01 3.195108293307649672e-01 3.200039080879806264e-01 -2.847302171354914035e-01
-5.321417730043527250e-01 -1.773083366291246243e-01 -4.793466582903868622e-01 1.655719408942744886e-01 -4.807777568930569623e-01 -6.449169744264479642e-02 -3.426852307755529070e-01 -2.283172406130883070e-01 -1.527456724261511134e-01
-6.100580864690974270e-01 9.229969138174036469e-02 -1.269207963078385071e-01 -4.261804234723479134e-01 1.834895758997968085e-01 -4.299919737901618244e-02 2.203622387784898509e-02 -4.735801684979663168e-02 6.191328806129957618e-01
-1.319271341480048217e-02 4.951340005564315860e-01 3.573925536813084974e-02 2.167670274272764097e-01 -5.164219388616954065e-01 -9.257560686710460118e-02 3.696892270518759016e-01 -2.115527980862932089e-01 -4.997163819117536598e-01
3.121876636727676790e-01 4.159507725436597525e-01 -6.705830101136794896e-02 3.961151544385312362e-01 -1.849830858289342184e-01 2.656111370713741260e-01 2.206418866836865889e-01 1.731579677325710831e-01 6.202299928516232796e-01
-5.210450287378497192e-02 1.690945448386487471e-01 7.259630391235232239e-01 -1.035298674114111944e-01 -4.325289984644293262e-01 4.212896737889486043e-01 1.554472292601254135e-01 -1.142580392804038031e-01 -1.707815086234639734e-01
1.172427494020860800e-01 2.779374939838122338e-01 6.437853661979983100e-01 5.130162206922656010e-01 -2.788663429402953864e-01 2.659074218269120715e-01 8.900522724768708538e-02 -6.564250183764320373e-03 -2.737177974870366182e-01
-1.143461331079219795e-01 2.536699197556581131e-01 4.664663961041522477e-01 -1.225495062261413304e-01 1.022560356114898955e-01 4.092290044284524475e-01 4.858869124985574217e-01 -3.335222601111833551e-01 -4.058563648290156589e-01
3.150124597567373064e-01 3.909040887505021988e-01 -1.754562918637048996e-01 -4.858777958912358259e-03 4.898341652948307590e-01 -5.264605587534114672e-01 1.992938275553355135e-02 -3.923450774761155779e-01 2.138283329882649797e-01
-3.410303611397313417e-01 3.838911871731357506e-01 3.709193790976214600e-01 -2.972345764809468383e-02 -2.043230164662106219e-01 -4.832714057923979678e-01 -2.964838200576461885e-02 2.528047024940887066e-01 5.077132936942715391e-01
-3.353867502907275089e-01 -5.540308212857901760e-01 -6.774334970104856080e-02 4.220491387547957718e-01 -2.058394043494901349e-01 -4.623513428334762726e-02 1.088506304700053579e-01 -5.107469338648183976e-01 -2.839586265836126500e-01
4.317259330821183738e-01 4.882489967962020949e-01 -3.033419687553759458e-02 3.333429089254394961e-01 2.117366612021790440e-01 4.513491783850294703e-01 1.841612509340317672e-01 -2.363627492861450352e-01 -3.533507708769555444e-01
8.398931272618279098e-02 2.739122505247613276e-02 3.992813781491990482e-03 -2.660143256541848689e-01 -2.015829960487957040e-01 -5.528196608507666282e-02 -5.866115611230431348e-01 6.917337236898302155e-01 2.347668714267644730e-01
-1.661324518233763259e-01 3.620774977796975547e-01 5.397518442149015216e-01 -4.647593572834410325e-02 4.658070257684199800e-01 5.190085698100908029e-01 -1.337159454130819325e-01 1.981219708791048806e-01 -6.579876840231690949e-02
-3.842503979363742217e-01 4.990935463176725539e-01 4.399991819976568075e-01 3.403707128484609323e-02 8.144905475885848289e-02 -3.805099594199675139e-01 3.520762424641004085e-01 -3.603039535601634258e-01 -5.745488779824728387e-02
3.893070874305114004e-01 -2.110436663496645937e-01 -5.389953814902848084e-01 -2.795225886009966021e-01 1.212173585858969255e-01 -1.934714157585001038e-01 2.816584853870204297e-01 -4.318453470419168494e-01 3.424980596639921604e-01
-1.071469555523095613e-01 5.602534562612269120e-01 2.015721390539892133e-01 -1.912125483982140550e-01 4.083288530177468512e-01 -4.178230100377215983e-01 1.813020587737002587e-01 -3.853760447512591392e-01 2.734014931341871013e-01
-1.081161604739986626e-01 -2.124142802239579464e-01 -3.803066945288561818e-01 -6.796601859998989692e-01 1.265588307116854438e-01 -4.145524432596223718e-01 2.024591370669645563e-01 3.196622576203467930e-02 3.267070728487762588e-01
9.751097686710216705e-02 1.762083717624097767e-01 -8.015279870728445610e-01 -1.804246260988220663e-01 -1.015244789776236778e-01 -2.325496587387328451e-01 -4.090422183210067342e-01 3.321170765681426967e-02 -2.272376329785343319e-01
1.788511929879407492e-01 -4.583455443801143780e-01 5.269395734124283220e-02 2.936766140134798239e-02 -2.217067917468736327e-01 -3.728535592966989443e-01 -9.924377599156467347e-03 -3.147663060902761711e-01 -6.833319113943568945e-01
-8.668417884106695281e-02 1.562538158188466753e-01 7.056280500836297209e-01 1.630333252085590934e-01 -1.407972864157890636e-01 -2.307954676060462174e-01 -5.640028777763910206e-01 6.807228458357963974e-02 2.185321079139007916e-01
2.345614550210067539e-01 2.780752123502772677e-01 -1.751152904706053740e-02 1.099661560484043177e-01 -8.325703265504652562e-02 7.691092352427451040e-01 -4.743127004712838768e-01 -1.421847414266784460e-01 -1.077316259229919720e-01
-2.345256906558567112e-01 -2.308870784699577627e-01 2.409745717429717660e-01 5.127500721529411054e-01 1.816163052602955408e-01 4.397438146004383208e-01 -4.479412900078865722e-01 9.934393112764433598e-02 -3.658247612407843352e-01
6.543455587200782686e-01 4.120715033006785433e-01 -2.571412723903271358e-01 2.738168061067616232e-01 -3.981063712261959098e-01 1.828548045462902449e-01 -2.006164279265378603e-01 -1.213859095837080682e-01 -1.184298785010925170e-01
6.813826151491826355e-01 1.943711625235555185e-01 -5.195697612123759690e-01 -1.245153891100603538e-01 1.255227768457776172e-01 -5.968793581548586386e-02 -1.928486390413379492e-01 -3.741420604501998759e-01 1.264486769135266808e-01
2.750796824116698291e-03 -4.626157455655358075e-01 -1.583236519977640200e-01 -4.137034858632312323e-02 -1.334815373920425208e-01 4.499947866101629557e-01 -5.962251029691300053e-01 -1.788323702719033792e-01 -3.891313424528107245e-01
5.582592950277823762e-01 4.310448600453564705e-01 1.108395835753220454e-01 6.643491912226077989e-02 -2.724678074108338732e-01 -1.211016944939752732e-01 5.153156499791770040e-01 3.462970303238259162e-01 -1.071060108886904283e-01
-5.267391949556127217e-02 -7.068101932971083967e-02 3.696784309898064613e-01 5.921553161699225631e-01 1.377238903560451533e-01 -4.547293080226255113e-01 3.134565701357472367e-01 -3.340776175804970882e-01 2.632681169929903531e-01
6.653537913065877829e-01 1.403343152581564557e-01 -2.129052436029736373e-01 -1.761544990445361447e-01 2.823839391536194232e-01 2.094342090169776793e-01 1.556776765345096458e-01 -4.961718336317113009e-01 -2.592800756104893245e-01
-5.309770210909561250e-01 3.259809461732306179e-02 2.896068157813947996e-01 3.735551867693216038e-03 -5.798412858158250027e-02 -2.072215421364067001e-01 -5.018923682200342462e-01 -1.013608489306838389e-01 5.697734703719364857e-01
-5.219579543591238435e-01 3.189997142699218524e-01 -2.635877779462813542e-01 -3.827916498598343820e-01 -8.881157214999337024e-02 -4.498392455368506737e-01 3.041803549205912560e-01 3.252481798146764636e-01 -3.515968325484607887e-02
-3.450302934780377639e-01 1.408508897978263952e-01 3.317461801625746221e-01 1.180085078063055903e-01 5.136752750957943592e-01 4.789347161565141869e-02 1.742892541974003229e-01 -3.044596174679684020e-01 -5.898348173793426241e-01
-1.853087110919219016e-01 5.959863791947997980e-01 -5.226636337423462564e-01 -4.722213553083713655e-02 -2.004580448160393769e-02 5.758605194279499406e-02 -1.698129491641027222e-01 5.379558376612578741e-01 -1.144674829528803395e-01
-6.204003420568190985e-02 -3.577724506362883750e-01 1.341648042721709233e-01 -6.338919070660335719e-02 -9.587789357633771936e-02 3.401526500148835952e-01 -4.405339739631804474e-01 2.168651456284728385e-01 6.929173501396829193e-01
-2.906907681287526635e-02 -2.020716612400585144e-01 2.605673879870308574e-02 7.378701660908829618e-01 -5.448582424814026881e-01 -1.539528104302230471e-01 2.955323870609356529e-01 5.214448315057274713e-02 5.059926569483782360e-02
1.144392017307511028e-01 3.979105785452888844e-01 4.307399608057989049e-01 4.922174885152401647e-01 7.370419584240599231e-02 1.715139738609853248e-01 1.335839943317282674e-01 1.615661373136651480e-01 5.674136222997384627e-01
-5.359424896743113509e-01 -2.334379828087407016e-01 6.523201398886251390e-01 2.695089432885106051e-01 -1.660545521726438378e-01 -1.595928476203119506e-01 -1.491525158823238939e-01 1.434817172885733683e-01 -2.534526642751250280e-01
-1.418284604514497560e-01 7.693672712113878986e-02 -9.352517553388600691e-02 4.499804661314617260e-03 -2.615334533581445409e-01 4.289368156154352296e-01 -4.947429822891193929e-01 -6.835427619828317036e-01 2.846675475055356758e-02
-1.998340511000667730e-01 -6.425719708878191438e-01 4.025028256857785536e-01 3.864974733682776109e-01 -1.084674470196809876e-01 -1.386729504729355689e-01 -2.517291859111014940e-02 2.684393806867338417e-01 -3.634419368420113150e-01
-3.444607220833565409e-01 -3.652606011776602379e-01 -1.490744091181997188e-01 -5.085324715028027853e-01 -1.880377306214377486e-01 2.305242704242603247e-01 3.013766548030279435e-01 5.102792593656207965e-01 -1.655010941098862542e-01
-4.875820524853547583e-02 4.384702893113820998e-01 3.256926341214622656e-01 1.674697647351305330e-01 -3.255400788480873886e-01 -3.840075013451575980e-01 2.845953588364255049e-01 5.395207620023433348e-01 -2.138442280308838483e-01
-5.570231956930495887e-01 1.555939659662673447e-01 -4.564166409101644839e-01 1.885533337630466433e-01 -1.005459354926155485e-01 -3.470544413466584710e-01 3.246321061029335264e-01 3.571630187859797245e-01 2.411212780702834957e-01
3.622346721754343690e-01 2.260299886268676561e-01 -1.777503311837376476e-01 6.166022415185259398e-01 -2.958498078182498769e-01 1.567928170747765471e-01 1.416108885915638993e-01 -3.442806733302869460e-01 -3.939658106548165617e-01
-1.669544423533116384e-01 4.981160756405776935e-01 -3.893404480303187531e-01 2.349816514565977177e-01 2.084628757961904666e-01 -2.347520380691983100e-01 5.967175480088524608e-01 -2.089626309350103295e-01 -1.374835451294700028e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    10: ( 143.437870, """-3.132080400323917213e-01 4.977440067111862931e-01 4.350545988344754478e-01 1.059981579083007913e-01 8.556341048735326138e-02 3.628047167144731744e-01 -4.992110732659583161e-01 -2.215462620726376952e-01 7.428759759576387955e-02 1.043171378270527083e-01
-5.328475200574659398e-01 -1.605903415081472441e-01 -3.322992516035570554e-01 1.445245925377186547e-01 4.466002978633394904e-01 1.563431972692884142e-01 -2.096058470790357897e-01 9.176226986208077530e-02 -3.802785595464782537e-02 5.303565287671596629e-01
-1.599304364272079171e-01 8.554815729371094690e-01 2.759908731013091532e-01 -5.213317820461634000e-02 8.556302191372993846e-03 -1.304064011429821590e-01 -9.551112024889643615e-02 -6.836784282290063117e-03 -3.676951653029313372e-01 4.729496273799765199e-02
3.214568994190492197e-03 2.199707468708495817e-01 6.179042559949758928e-01 4.857805133301748013e-01 -1.138985064874220299e-01 3.195199517288450641e-01 -2.347354501522499748e-01 -3.454173114068188055e-01 7.841179692353623942e-02 -1.954124626319623526e-01
4.004183335622416573e-01 3.474781850197263822e-01 1.779304068122694038e-01 2.833883660158523221e-01 -2.624687201793331481e-01 4.299295999177933369e-01 -4.803306241149480904e-01 3.147109153911532009e-01 -2.378996117112832862e-02 -1.513279633166055849e-01
-7.114492372223513161e-01 1.027377902404661425e-01 -1.946854898173122714e-03 2.212204320448131201e-01 4.562109260767761507e-03 5.450998510574052158e-01 -8.461006879034613237e-02 1.079326736989855567e-01 3.382758398917936060e-01 6.284209897371666187e-02
-2.480260737781794789e-01 4.084467403001146857e-01 4.139269215157083681e-01 2.156918822421991788e-01 6.166951889947169113e-02 -1.675090422777696653e-01 4.084078690711315796e-01 -5.045763490759516134e-01 -1.006601282292332866e-01 3.006770574161998777e-01
1.581240331586971637e-01 4.328347929923863080e-01 1.519182411870752814e-01 -2.673727681341518392e-01 -8.636051282571884091e-02 2.048984512107940303e-01 6.161813867138949963e-01 4.361887782042357387e-01 -6.561140202151690380e-03 -2.714014910772488687e-01
7.353106333260781002e-02 4.238396780977106704e-01 3.834492954765950090e-02 -1.665409442841486731e-01 2.157100179911930760e-01 -4.024759273766766454e-01 4.969360110546591214e-01 4.296840534547104878e-02 5.709804387338146547e-01 -4.918192669211902956e-02
-2.665376417652181584e-01 -2.625507011001930180e-01 1.671297442327440708e-01 -6.908938389575937367e-02 4.125207161372763109e-01 9.720867116773372618e-02 -7.311549428725033772e-02 -7.742373752403459708e-01 2.040372996878126177e-01 -3.571617447605728718e-02
1.587578315624803560e-01 3.535516849736833334e-01 -5.759551393152873011e-01 4.191004156299541622e-02 -3.523039866377358775e-01 -1.245126274383074050e-01 -3.694757280949318434e-01 4.249861116404594213e-02 4.873793973428500736e-01 2.894420379763798512e-02
-2.363545816281257539e-01 2.840850377255942361e-01 4.176630035307190431e-02 -3.094121264526128456e-02 1.065323263579142851e-02 -2.572864615755409146e-01 -1.827907074523786243e-02 -8.058632392618728657e-01 -1.670238455709472380e-01 3.417220451079924781e-01
5.173496989761686149e-02 2.279683278089304210e-01 5.491893267152944125e-01 -1.888629164935668181e-01 -2.039242107597362685e-01 7.812932346782215653e-02 3.621502665229315299e-01 8.425010175797630063e-02 6.446520253314064197e-01 8.099020143803424554e-02
-2.102941012283547975e-02 -5.711135355310857920e-01 -1.014132699731379456e-01 -1.570309148232888197e-01 2.233720040278619826e-02 -1.539995345228636903e-01 4.754301469359305948e-02 8.617712549747091888e-02 -7.759892279676616766e-01 -4.881403101652941057e-02
-2.866414868668017424e-01 -2.659012675261194780e-01 2.359713501524771107e-02 -3.165141123874548601e-01 -6.570846398128479260e-01 4.483379305326204989e-01 -2.267211261584520798e-01 -6.059575307525401355e-02 2.390486742016827981e-01 3.754276236902094610e-02
9.150120276246494211e-02 6.156538171105965795e-02 -2.244881150546511328e-01 2.788709276069153420e-01 -2.255902645912466198e-01 -2.651398243146386169e-01 1.849724606616471867e-01 6.028598364955877198e-01 1.783993722272089744e-01 5.558795750996277096e-01
2.548227240358221790e-01 1.400806306196929196e-01 9.276269680853799215e-02 1.060825000341601362e-02 1.009573421093131890e-01 1.078067569989215324e-01 7.381099927797588056e-02 -4.361899594813006265e-01 4.632599397323489132e-01 -6.889057594801277773e-01
-2.392056281354733305e-01 4.207186686815683196e-01 8.601174562809768553e-02 -1.479011381435195172e-01 -4.898293888079152669e-01 -5.097630379671407308e-01 -4.178813657672617587e-01 -9.537421820811551459e-03 2.139195571291040987e-01 1.274171967622294288e-01
1.153848576524915855e-02 3.254886991369907445e-01 3.128677127707766847e-01 -1.315096097523568985e-01 -2.722488385166527136e-01 8.404122371804566283e-02 -5.072212324018275931e-01 -1.581538877440227635e-03 -6.633968581845068879e-01 1.376075061552906389e-02
-2.659204101280951762e-02 2.157016940396883908e-01 3.492763073616546032e-01 -5.020313825971155497e-01 1.275332637617065112e-01 6.604437216075141892e-01 -1.825440882193523906e-01 -2.347831985815629352e-01 -9.818568227567561757e-02 1.679274518539365102e-01
-2.198030218305323247e-01 -2.366718341035583262e-01 1.317725328767522033e-02 -4.214817944695465335e-01 5.828285807423732034e-01 -4.963635739671849456e-01 8.437384244330950467e-02 -2.904654031850230078e-01 1.954046705283820351e-01 4.598367504571213710e-02
-1.032770957194208278e-01 -6.496596978238458053e-01 -5.807314413368622197e-02 1.163486161764710064e-01 -5.023280961444930304e-01 -3.052815115195247619e-01 4.750725414126669849e-02 -3.423721667005822922e-01 -4.385227332068639128e-02 -2.888557579709225553e-01
-4.107045954904382512e-01 -2.765817649144267643e-01 -1.248040587965955073e-01 2.737841558940429243e-01 4.249035006910584222e-01 5.609725480170689752e-04 4.255692753423102048e-01 -2.493667593402869587e-01 3.252197220263003397e-01 -3.669963071821062961e-01
1.949420655590167195e-01 -1.714100401617126290e-01 -9.694365139248488361e-02 -4.065871695478689984e-01 4.399379154179088314e-01 4.652437480470405506e-01 -4.395867002909013138e-02 5.709989629646671228e-01 -6.366675691814754900e-02 -1.260247610116741468e-01
-2.401329108418084612e-01 -7.157522506566139642e-01 1.327143814651494296e-03 1.932688012754524010e-01 -1.559706245648635470e-01 3.156818568648815937e-01 -1.137921188549143453e-01 3.088064269719816846e-01 -3.759370025895716894e-01 -1.380570675624361310e-01
-1.273153981117730871e-01 2.115384884589596379e-02 -2.906853141419571060e-02 -8.533649562977374536e-01 2.967317315783123410e-01 1.055314682009255017e-01 -2.821084580425984312e-01 -1.215886239056568861e-02 2.716739822790056325e-01 -3.924527920378479556e-02
-3.131070802398639441e-01 -2.552127768101440930e-01 -8.490555834191546025e-02 -4.582331791527553544e-01 -1.951025152789088446e-01 -4.715345655382273682e-01 -4.669541730215686637e-01 -2.064548050333241125e-01 -2.714689800287182764e-01 -1.576983298447068305e-01
-4.684894352895150882e-01 2.225693030210317280e-01 -2.543997173990105165e-01 -6.025005655859756032e-02 2.813987047489729387e-01 -3.081579681608282995e-01 -1.262248738167776885e-01 5.270582764742278714e-01 2.055938626206994524e-01 3.905031658694702590e-01
7.368772229626002757e-02 -7.891636278233989110e-02 -1.404358248878393167e-01 6.635022203866201007e-01 3.126596390095872091e-01 -2.190055408463525977e-02 -5.662465364245970051e-02 -2.716717183462296625e-01 5.913404661815795382e-01 -5.876908090232284970e-02
-5.335578076740960657e-02 -2.783961804021504172e-01 -4.832209816639860267e-01 1.332103430423385027e-01 3.319119987412234574e-01 -4.927585041475027738e-01 4.930659126504569056e-01 -2.419830152561214531e-01 1.715997844045081362e-03 -1.172688275948812753e-01
1.028951273930665128e-01 3.004505186237206305e-01 1.059227808021781514e-02 7.662016648108706252e-02 -5.469230660805585870e-02 3.730978121471453801e-01 1.845847295013188227e-01 -4.021027836246907072e-01 -7.218514770416771809e-01 1.847654747208927473e-01
2.939862547756074904e-02 -6.268784119317118153e-02 -3.286485373570365298e-01 -1.089699087876008256e-02 3.422890704445477605e-01 4.961252951159385582e-01 1.309464933253276231e-01 5.839929779930154163e-01 2.883272334840520923e-01 2.871373497855185253e-01
-2.571399786162942291e-01 -2.306065187341010958e-01 -8.691145132881820945e-02 -3.366318100103344868e-01 1.592003530944075540e-01 5.362573668800227900e-01 -1.525864672698657165e-01 2.870150203466798056e-01 -2.104404848168093256e-01 -5.449430461293354178e-01
-2.638979289835260630e-02 -3.391239694476552713e-02 -6.334958090240255801e-01 -4.658592706602310285e-01 1.700931301007962415e-01 -8.446272108922601995e-02 -3.054219648218295738e-02 -5.829625743552910855e-01 -5.418486266985658543e-03 5.420844061161330524e-02
4.386947439564716777e-01 -9.043189671703960597e-02 -4.644844017303396133e-01 3.240675511821927146e-01 5.541361355827756352e-01 -3.972182336996643026e-01 5.388925507215396732e-02 -4.136196891296884531e-02 -1.343112619535423956e-02 9.465207405837421095e-02
-2.019804535862622930e-01 -6.018290709462796872e-01 -2.390600415321305142e-02 7.282434372893163352e-03 -4.861169597781102580e-01 -2.421081539801635263e-01 1.497197658564506095e-01 6.332980473280294675e-02 2.874018754798940423e-01 -4.386668069907905254e-01
3.777638738093607763e-03 1.191763881553303678e-01 -3.088829893824573403e-01 -2.985888699699407178e-01 2.921617484478217786e-01 7.456726123471911841e-03 6.056971495134950700e-01 -3.443344759103834640e-01 -3.246732483230432842e-01 3.534920467642632680e-01
-1.484547175422085419e-01 -3.128023374305523019e-01 -6.547304922510932546e-01 -1.351197246116216943e-01 -3.835385879768063444e-01 -4.121414139797959231e-01 -1.163442781087618283e-01 1.813454823105377367e-01 2.071924109830498295e-01 -1.639306966934480081e-01
2.835351615323941643e-01 3.805902414214070717e-01 -1.495625144647239058e-01 3.973221513357335505e-02 3.137665442846573199e-02 2.882004861544190111e-01 7.094310214417837157e-01 -3.714229649107654574e-02 3.880656369729432176e-01 1.072399553460197108e-01
-1.759034595285510760e-01 -4.103752615237966084e-01 3.507631451531033617e-01 -4.314144353230592310e-01 1.327326645441133657e-01 -3.297279916540097888e-01 -2.290126006528961367e-01 -2.795547663019055107e-01 4.807124804278966046e-01 5.896000742985173931e-02
4.849798242613850147e-02 -8.408119677560084437e-02 2.692909296397142938e-01 -2.258788947546080395e-01 3.652428148469692992e-01 -2.977227633048596944e-01 3.817909191567039895e-01 2.400553040538823957e-01 -4.661651096183021536e-01 -4.736005660891954849e-01
-3.443840947878415992e-01 5.091207640025844361e-01 -1.670314586706622348e-02 -1.032146533309997588e-01 -3.105405795016256132e-01 2.611185037136039555e-01 1.147603910190011511e-01 -1.918918942357443758e-01 1.266348571336486650e-01 6.169410224763596240e-01
3.107715664773589292e-01 -5.026555725559391785e-01 -7.998351136576144216e-02 3.984008091710662391e-01 -4.369609068266858826e-02 -1.752445630601609516e-01 9.711728798438584720e-02 3.721010234813328932e-01 -7.376429893156874473e-02 5.474355904468158895e-01
-6.948129218769839577e-01 -1.043176629467347100e-01 -1.692625843419356402e-01 -1.869224216655503978e-01 4.196148911848343599e-01 9.037778302588610202e-02 -4.524045984246244378e-01 -1.633792462138073387e-01 1.160812144151688874e-01 1.169643831801052830e-01
2.356234946442185563e-01 6.397083314482168714e-02 -5.774838333961783698e-01 -2.568273689596759501e-01 -6.527602145811092216e-01 2.869413344337947147e-01 -5.384046880490824666e-02 2.489022693171040468e-02 1.018196717300112568e-02 1.699653109246996030e-01
-1.788542823202856069e-01 9.451325319223895585e-03 -1.300910016012870596e-01 1.275155816413552079e-01 7.105220807606920097e-01 -1.296844422851441414e-01 -5.125392666050196944e-01 2.901828981780364414e-01 -2.572328692129515204e-01 2.623138690706701588e-03
3.873582153902187936e-02 2.805895351290653705e-01 -9.723181098745432849e-02 -3.915949541756364449e-01 3.538970362861848518e-01 3.567210869167407039e-01 -3.986780979118464407e-01 -1.808642462219475500e-01 -6.285409954171594649e-03 5.592671650155174312e-01
-5.539725534474947144e-02 2.999232822711297639e-02 4.659337005076334692e-02 -7.593007774997313497e-01 -5.721834836846878547e-01 2.689021704625709219e-01 9.149935839436117505e-03 1.351652029947966044e-02 9.316811172002548852e-03 1.314056871109019753e-01
2.924040611101924592e-01 -3.540310232122854117e-01 6.587880385594007127e-01 -6.072376963951123946e-02 3.645716500051960351e-01 9.318366543097519883e-02 1.894308753384676691e-01 3.815714398982142375e-01 -4.518376740524646801e-02 -1.623415137796399565e-01
-5.224558539538479707e-01 2.475434064759622077e-01 2.838015440998291616e-01 -2.205357325319845865e-02 2.891496176179386146e-01 -3.746143373678102739e-02 5.014628605571043174e-01 -3.522050683945063265e-01 2.461721190474321364e-01 2.522052393380029844e-01
-6.566233867431266191e-02 1.358755711939165500e-01 2.818076503806857258e-02 8.214415609083516312e-01 5.496987815052895715e-02 3.317882399593120035e-01 3.189534837675172541e-01 3.383006319831721731e-02 2.878830470021992993e-01 5.299360822756261913e-02
-6.883943303990924800e-02 -3.675714311979977333e-01 -8.060256196854023725e-02 -3.398865987794819077e-02 2.050612691154311551e-01 -3.324706237797263042e-01 -2.629657741142729654e-01 -1.841963987411450177e-01 7.275606857020712193e-01 -2.597877414696523335e-01
-2.900536056050689315e-01 -2.819853177688261270e-01 -8.429458389049077072e-02 2.765688734891777467e-01 9.579970243214268322e-02 -7.165105242350062742e-01 -2.201361847569587582e-01 -2.340388961753130659e-01 -2.841673677694486755e-01 -2.149584047880730153e-01
1.117256050972756237e-01 -2.457058128310102008e-01 4.969549807093099902e-01 -3.873661588559367819e-01 4.065784513289502078e-01 7.717221919819962361e-02 -2.409357161282129067e-01 1.939452597394130395e-01 2.637869390564954175e-01 4.400219631208035498e-01
2.129558184859983716e-01 9.260611256681192116e-02 4.101722430099390970e-01 -5.621925644777594488e-01 -1.789700451368256562e-01 2.190090339204298908e-01 -1.002064117544844424e-01 -2.086434831495131287e-02 -6.087870052332443604e-01 2.605150811605181152e-02
1.781929387659488551e-01 -4.805433744715208455e-01 5.946521564977987062e-02 2.535579709388213754e-01 3.453527702557543377e-01 4.824752403165755710e-01 -4.919904183457178282e-01 1.701793690166846229e-01 -9.790066682220822936e-02 -1.919545830075075066e-01
4.015901641347276452e-01 8.158505987695052752e-02 4.551619705042029423e-02 5.313182138932850268e-02 2.197247310620164817e-01 2.922407982058111142e-01 -5.506641504009573973e-01 -7.427193423097600000e-02 1.481846377836425199e-01 -6.023162360708067542e-01
-4.910210036741836648e-01 -2.210784915356898139e-01 6.086751063035967801e-01 3.487311468214280841e-01 -2.147152829660304296e-01 -2.596047548653083667e-02 1.324757142221153483e-01 2.935865427223901397e-02 -3.210289461803474131e-02 -3.894931789199336802e-01
-2.004282355233825141e-01 3.799055250617027757e-01 -5.049366745468205492e-02 3.135062547004010547e-01 -1.380291041419046683e-01 -1.341928053318009462e-01 5.729058067575766577e-02 -8.017695911562056077e-01 -3.292494137479955174e-02 1.743675713794129722e-01
-4.670693652103435345e-01 -1.148347890171069197e-01 -3.148370376901900025e-01 -4.145585120149596070e-02 -1.523276346302843698e-01 2.878282352437062097e-01 8.042519056510745445e-02 -2.739518958510355762e-01 -6.805245508818446032e-01 -1.309118530413426740e-01
2.978219492046120798e-01 -7.970584053736459729e-02 4.161544581665353459e-01 2.207543620158008424e-01 -4.760442260420454375e-01 2.646624007632062403e-01 -5.107746963069345059e-01 -1.796331138903478897e-01 -2.659410269444864583e-01 1.499475802536527624e-01
-2.122608250006295383e-01 -5.662343484544863914e-01 -4.110513239461591750e-01 -9.141947214362709795e-02 -1.562801402044166621e-01 3.121594412352798886e-01 1.907018518752323921e-01 -3.771156659942738743e-01 3.729606250801620893e-01 1.321107312586623228e-01
1.116893603222088305e-01 -1.892530149251969440e-01 4.631698141108047673e-01 9.633343073711504723e-02 1.547110862243896053e-02 6.550254612061360282e-01 3.547468169202512289e-01 -9.944857519868284534e-02 3.558994823928599560e-01 1.902758569277677725e-01
4.851257523659424087e-01 3.445657977834445385e-01 1.806849853021775532e-01 -2.325899384784112234e-01 -5.738046890545626250e-02 -2.428464460950039150e-01 2.531121829352372399e-01 -6.562271367996382887e-01 -3.221320328989656784e-02 -3.431959662824531077e-02
-1.601698539488360662e-01 2.876039163270400212e-01 2.867766258251975287e-01 3.836610013578528044e-01 3.294894687532745614e-01 -3.384540214498115707e-01 5.349891965486839318e-01 -3.878048209631278307e-03 -9.555313898896693192e-02 3.791038003100599685e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    11: ( 217.330417, """3.610483511697422099e-01 4.046344805613201756e-01 -4.592020496982395783e-01 -1.452259054443237052e-01 -2.359856876055178299e-01 -3.629233600312141705e-01 -1.561935500075489758e-01 1.312809285209439181e-01 2.452640060686583912e-01 3.295265053621252993e-01 2.760109989148874510e-01
-2.805874160043080878e-01 -2.148272661507444684e-02 -8.870387930359643902e-02 4.320406836181993060e-01 4.362782749251262748e-01 2.246510527295488002e-01 1.794374806523576782e-01 -4.411997532706065511e-02 2.092664087222337044e-01 -1.572036994327960860e-02 6.381934610538567698e-01
-3.846215745578804857e-01 -8.311855139123568159e-02 -1.412136010403675646e-01 1.544149298663010372e-01 4.136129065003633642e-01 2.073122777748864221e-01 5.308772471311223873e-01 5.519393427484801107e-01 -2.308207678597824081e-02 -1.439574665567136189e-02 -1.051535968360740175e-02
-2.230207920912312680e-01 2.369237864329464538e-01 -5.170131873641818920e-01 2.681980766632934832e-01 -1.024014199793227553e-01 3.385275384397095633e-01 3.154062596400472041e-01 -5.422487043760996217e-01 -1.298490683357952924e-01 1.042282152670355871e-01 -9.257423488193225469e-02
2.216051897285477579e-01 -4.430009483844962737e-02 -2.430328748990804796e-02 -3.596999422718259731e-02 2.443019628202781346e-01 1.827491050343041656e-01 4.099843928252176473e-01 7.560132791542133468e-01 -2.664094886039757304e-01 9.987814073102739554e-02 1.826760180061709204e-01
-2.834747516249555011e-01 1.754947048937736676e-01 -4.330772171007498533e-02 3.431019061886537991e-02 -1.612557984353658047e-01 -5.642565065951358205e-01 3.130630067055558685e-01 2.626781797865606616e-01 1.637259320157012366e-01 -5.879515793985533589e-01 4.359558700437512341e-02
-1.543060894315322062e-01 4.199321854011578425e-01 1.743050683104319376e-01 5.566855033312624323e-01 6.690010936093458704e-02 -4.556554180342185095e-02 -2.302919820070961354e-01 2.534855789739829390e-01 -4.152756891295061314e-01 -2.089858488448548546e-01 3.458257104588998709e-01
-1.809260169824381259e-01 2.746332948564610410e-01 1.113509004899964905e-01 -2.515620857845167826e-02 -6.169924447920830390e-01 1.389193423455709619e-01 1.889141398046847650e-02 2.437846907891954851e-01 1.871099187439218547e-01 4.846657878408726083e-01 3.861778122520836964e-01
8.855913920116635640e-02 4.493183149110598906e-01 -5.414849122254239422e-01 1.219057039404030929e-01 1.174776756145248929e-01 1.030825282776227925e-01 -3.340368253657625131e-01 -1.527320818431699978e-01 -4.685755772024122745e-01 9.504464269708481905e-02 3.070377221840651649e-01
-6.118299690403228991e-02 4.289682933359021400e-01 3.292997897709192268e-01 5.414192871248751926e-01 3.792269438922902247e-01 1.235020034934711242e-01 3.502172794881835971e-01 3.907489075996604250e-02 -2.921954122631560402e-01 2.988709080767718365e-02 2.028631096650337085e-01
-3.460839440731064975e-01 1.224437459475196111e-01 -3.808919849591101969e-01 -3.582313645955346737e-01 -3.392342911324762733e-01 1.187027408976751297e-01 -3.857836958683267814e-01 3.172312183526586060e-01 2.837235666582775817e-01 -2.743338622247827874e-01 2.396496126316502440e-01
-1.813268852840749790e-01 -1.276940209039741647e-01 -1.050160917809723482e-01 -3.158645839572348790e-01 -4.910565209013737498e-01 -2.386318380967316632e-01 4.528050015748419366e-01 -4.904422456825420218e-01 -2.134181997649241963e-02 2.541640147489034329e-01 1.769563121773879699e-01
2.338958929346628690e-01 1.353667415036819144e-01 -3.942250873430065972e-01 2.664116146509379335e-01 6.911245878537136678e-01 -2.013554502554521786e-01 9.882677501620223959e-02 -8.501811930242553217e-02 2.158123231651631543e-02 -3.678062312306804582e-01 1.721650079942756983e-01
3.102963907556237078e-01 -2.871169283330800015e-01 5.299257227340179455e-01 8.674899779272261802e-02 -4.741898337849502765e-01 -3.473830199718490053e-01 -2.022186600611574903e-01 -3.038466748211846591e-01 5.345747622589329395e-02 -1.357139265901916581e-01 -1.814145478561345337e-01
-1.167359259525693471e-01 -6.357794474364242276e-02 -1.496551363426910086e-01 7.926662649144469164e-01 1.442160840032642721e-01 -3.270411129487835189e-01 9.105489307714094427e-02 -1.113134500585663961e-01 2.234233485113694684e-01 -1.023631472427633110e-01 -3.504026946704011936e-01
-4.253362453562943846e-01 -4.468744334840316634e-01 2.241155424242716465e-01 -2.401419501965907921e-01 -2.304806512498011883e-01 -9.338533609896684795e-02 4.934430557028560704e-01 -4.242632442428498352e-02 4.142218189585019639e-01 1.414604053892018487e-01 -1.130372994442317980e-01
-3.671590205457703759e-01 -5.910597644986693711e-01 -2.449347977421776901e-01 4.546912110053893258e-02 3.792423840732166845e-02 -2.215351259184939747e-01 3.573567787441882526e-01 -2.428240984560930960e-01 2.455797111764751184e-01 3.229742228091176948e-01 -2.279844275019257960e-01
-4.682554575859639023e-02 2.854410990376532453e-01 2.573783982558505712e-01 -1.756910043041214620e-01 2.841348345788068386e-01 2.318955840915361277e-01 2.213552455246017500e-02 -5.103677486556077586e-02 4.187570130461770040e-02 -8.056455511704930794e-01 1.754951563540023962e-01
5.793977086440138535e-02 2.111648085215692972e-01 -9.014050521187506881e-02 -2.874352936148550919e-01 5.389865765957140009e-02 -5.464025540030663652e-01 -4.025093324837304420e-01 -4.617352111396294534e-01 -2.084488477384043581e-01 -3.613057265232426651e-01 -1.031567423667931332e-01
2.204109487644422549e-01 9.590762358171796981e-03 4.742954193517668893e-01 2.666441927920861765e-01 -4.541444485703696188e-01 6.159364392733026466e-02 1.189266630598115326e-01 3.040043711465210130e-01 5.733284046399538258e-01 -3.024314368978953810e-02 -9.512353686041415124e-02
1.048520769715862999e-01 -1.021628087514202254e-01 2.830929318029849068e-02 1.103981078309351216e-01 -1.355472735920524585e-01 4.040042651145107078e-01 -1.862899478934997577e-01 1.082417374585464692e-01 -1.648997739937284046e-01 -1.404512521524058088e-01 8.310526014953703022e-01
-4.569094743466610709e-01 8.575033961969449892e-02 -2.160546037973467282e-01 3.299814770777760309e-01 -4.666171486848918470e-01 -1.732076487568905421e-01 4.036286006315212282e-02 8.348781930209576985e-02 3.401901327471552050e-01 3.838786941820115373e-01 -3.299836916068524806e-01
-3.747373405776199123e-02 1.827219159503968848e-01 -2.367287569331116281e-01 -5.774694716923853277e-02 5.529392076322646732e-01 -1.453515685644175826e-01 -8.781289521056761388e-03 1.162609786979024347e-02 -7.128268573945878428e-01 2.552591145372220538e-01 -7.397796445487361816e-02
4.372577363547271445e-01 2.869249988783376462e-02 -1.145909916372922083e-01 3.660083317872025455e-01 -1.641930890306870505e-01 2.416973280465794516e-01 -2.068027569242339783e-02 -6.733899360424920877e-01 -2.285601100095097094e-02 4.573112161005998821e-02 -3.449881690538778578e-01
-4.278754839151806266e-02 -1.058246501312455762e-01 3.284952821252524746e-01 6.754610494813460819e-02 1.084569342715851759e-01 3.239858381926519759e-01 3.084804394096249403e-02 5.274494913831720977e-01 -1.126128675765125375e-01 -2.283782733010320531e-01 6.432543440031530668e-01
3.294345827596305010e-01 1.059102116330110643e-01 5.915908304632980785e-01 2.892263433493557634e-01 1.160360771646823663e-01 -2.871725242538220035e-01 3.121683955879011596e-01 -2.413937261972852744e-01 -3.418723346893164788e-02 -1.388250717337579099e-01 -4.177686665641503483e-01
5.578051886719682662e-01 -3.199547456466204642e-01 -5.610325449265389508e-02 -1.609263548005247790e-01 1.252211172379810722e-01 -1.371774704481241447e-01 -3.790046826666783331e-02 -1.707465273804018580e-01 6.945810069623575833e-01 9.116886537436404148e-02 3.992642533610673422e-02
1.311849893791166843e-01 1.047987428398568233e-01 -5.742655055578470974e-02 -5.779490767285989233e-02 1.708325356546874785e-01 1.118207077494991902e-01 -3.112681995111974964e-01 7.693832153460551659e-02 1.028237287781995357e-01 7.494646687704423771e-01 -4.984020764370677425e-01
-5.731578656038108788e-01 -1.769282803822719644e-02 2.030427656804492109e-01 -3.526279272298952217e-01 5.263774484460687075e-01 -8.757953064408278976e-02 3.313782256516781266e-02 1.557249501480321985e-01 2.154016832943013993e-01 -3.825641854740187697e-01 5.252805153495158225e-02
-4.495059353309644595e-02 -5.769178986277271326e-01 1.853321680078109102e-01 -5.268063196381039814e-01 -4.214121123144080189e-02 -2.840828001868647146e-01 -1.297203019103814747e-01 5.407396306251153334e-02 -8.754366945522833177e-02 2.672750890323163930e-01 -4.146590586745714235e-01
6.478696544508774635e-02 1.247502200030310426e-01 4.129481540524135852e-01 1.285610908487379855e-01 3.951264604126455415e-01 -4.118688391723681619e-01 -1.776275831024880514e-01 1.034292893678082498e-01 -2.244273273238567012e-01 -4.554903816578692033e-01 -4.090681484693683423e-01
2.758726597494760568e-01 -1.300574789095120809e-01 -4.515950890310169163e-01 5.468809762797539609e-01 1.926122398067418029e-01 1.975254356170760561e-01 -3.512178692601383156e-01 -2.030054519938420954e-01 -4.183730365443096878e-03 -2.513470193979900902e-01 -3.163678167937712393e-01
-1.253160947245317118e-02 -4.608911547833767774e-01 1.819035199847369999e-01 3.779541902571505463e-01 -8.283727785986610970e-02 2.320935145692954449e-01 -3.642619388882933906e-01 5.363592931178507994e-01 -1.677081209220350477e-02 -1.499354216539252327e-01 3.280620144744395006e-01
6.093011749570910185e-01 -1.354858255258069299e-01 4.716541388838646487e-01 3.706073272915413885e-02 -2.480593164599378952e-01 1.993821125908994962e-01 -3.982647622151211375e-01 -2.860251651179102628e-01 -1.749661010748136680e-01 -3.057376481887039144e-02 -1.153463732134611952e-01
-5.046586151709494539e-01 1.198811086495229772e-01 -5.294415149396402009e-01 -3.241576314977546169e-01 1.075958430843653724e-01 2.427692965501119793e-01 -1.204985977397189795e-01 -1.582050069767695910e-01 1.369677193309525587e-01 -3.660051961547414190e-01 -2.877137836212617650e-01
-2.405282344108093939e-01 -1.918580593920317101e-01 -1.151118085875334485e-01 3.203708253536222128e-01 1.998921901007163215e-01 1.760550792911605156e-01 5.535329871931495838e-01 -9.581404830833700759e-02 4.372275659902344347e-01 3.180325364224882434e-01 -3.325724616181272575e-01
1.865777113225007833e-01 -2.795636995207988473e-01 -6.441094902021381463e-01 -7.198639529529124448e-02 -2.786956665241648867e-01 3.422425092739366237e-01 6.859212986279156210e-02 3.412343699270259378e-01 -1.881794626509560309e-01 2.947775213960808771e-01 -1.694742947934491373e-01
4.648365155676213029e-02 1.739489266809399470e-01 2.499447487877622109e-01 3.836245540039173174e-01 6.182891605768346954e-01 -3.311453401326796553e-01 3.137619491462773080e-01 2.862915523729058220e-01 1.032376202378988000e-01 -2.557143316946403067e-01 -9.769802160863413909e-02
3.730863328345062624e-01 1.686067928128606175e-01 -3.247602575428252814e-01 1.941906138303096940e-01 -4.838984272783698748e-02 1.653209303274850439e-01 5.724991116377901035e-01 3.799077112639274167e-01 2.549536712370290004e-01 -2.844609649657882655e-01 -2.037695130201169214e-01
2.700372911591480962e-01 4.325825219778299258e-01 3.938112054228079528e-01 -1.935148069135933513e-01 -7.066728367703271679e-04 -5.912795605519508557e-01 2.196805776653986408e-01 -1.387077962412118781e-01 2.049552756068167003e-01 1.640733412484548515e-01 -2.477474998650004978e-01
-1.818371896138140098e-01 1.506317681541280706e-01 2.568192146219676619e-01 -2.041670645597495615e-01 6.804816015761256439e-04 -3.115664572402842419e-02 -6.194281913063104383e-01 -1.789224445417119946e-01 3.847067339130720853e-01 2.465945796507600651e-01 4.594791886921013591e-01
-5.298843533857334337e-02 4.245661611734791174e-01 2.373421785694478092e-01 4.486619463245952177e-01 -1.730477535735977235e-01 -4.955149702195353612e-02 -2.302036065232282158e-01 2.164945884957795441e-01 -3.604273851815865681e-01 4.112022101778947114e-01 -3.578369850597539759e-01
-1.100942424673292813e-01 2.546584832372986718e-01 1.021799187272252746e-01 2.217471248404479234e-01 -1.941690347120372806e-02 4.092903255613388191e-01 -2.425501065045600479e-01 -5.735188657929679579e-02 -8.496586430090055653e-02 -4.300326729399471803e-01 -6.642688565892175268e-01
5.011663609002552783e-02 -2.703627999228154846e-02 -2.852730771353843564e-01 -1.771092487859360909e-01 -2.362438718616460820e-01 1.771714338782156839e-01 4.079243872324342379e-01 6.033706577911105429e-01 -5.558491304975096692e-02 4.680148866625081783e-01 2.102902535878483636e-01
-7.669502400580979762e-02 3.247468349698033330e-01 -4.336660544320291577e-01 -1.692880284537361668e-01 3.239067956390944691e-01 -6.443787092897759750e-02 -4.522875944063075027e-01 -4.841455759316223850e-01 2.445888460165046296e-01 2.518738039292946485e-01 -2.529245351673501535e-02
-1.447469676539599459e-01 3.176801068683261509e-01 3.152604560387706756e-01 3.661102379399627793e-01 6.196654102777621187e-01 -3.872170749719872629e-01 -2.883744952874759543e-02 -2.601950017158941586e-01 -1.096681100703148816e-02 -2.021280984721040841e-01 3.564327700203440141e-02
-2.478116121120594317e-01 -5.962224979864290397e-02 3.010614578461829338e-01 3.127964592185275006e-01 -2.712570767086152634e-01 5.837725521856096389e-01 -1.953272732126216937e-01 -3.048097859513266839e-01 -2.968289660226591797e-01 3.360028367156803752e-01 -1.082039546470604796e-02
1.453287560435543024e-01 -3.803801841262386407e-01 7.983968462558570234e-02 -3.053124645587362851e-01 -2.621958143308247280e-01 -5.478096008742332906e-02 2.379330292793985779e-01 1.342208094815712238e-01 -4.879101253016965289e-01 -2.489820377214040370e-01 -5.368212884139336172e-01
5.994547377778480790e-01 1.030126830676480060e-01 2.176155785065564952e-01 -2.739737985052606573e-01 4.175628742545343941e-02 2.558555966587861552e-01 -2.691502987850147299e-01 -1.317353783791716526e-01 -3.941911190431006129e-01 -3.496360272165259797e-01 2.701674762302029298e-01
1.956531977457305893e-01 1.280657949676991259e-01 2.134255039124348385e-01 1.396901756709481301e-01 6.667839513865120304e-02 2.950702274894948518e-01 3.421345020106495438e-01 3.696147282331390671e-01 5.457919910830393018e-02 6.523654354535953770e-01 -3.263619536651607422e-01
-4.050327214374815216e-02 -1.623698115121900987e-01 1.656214281325653903e-01 -1.812012289005337784e-01 1.820176522958688037e-01 -2.129115527055048529e-01 -4.213759313424655373e-01 5.559319429170090920e-01 2.930534078253848596e-01 2.149754562243193223e-01 -4.632026383058560071e-01
-4.957224279051437588e-01 -1.115506208175343905e-01 -2.552208252517529918e-01 -2.127718606662434564e-01 4.661187374468140909e-01 2.445960213145779993e-01 8.367409318460696313e-03 -1.838145672879474002e-01 2.823343841019118616e-01 -2.035639760279333577e-01 -4.464342086165583590e-01
1.839673354234227232e-01 1.008025838248733097e-01 -1.535190610795588440e-01 2.716276831767826527e-01 -5.383665138763653601e-01 2.787653540400346075e-01 1.772775874591151213e-01 3.972605744402502026e-01 3.086088003361514009e-01 1.392102903243096906e-02 -4.543347209030811906e-01
1.006916805846937157e-01 -2.538718564256556842e-01 -1.839156077049964311e-01 -2.244527670743997338e-01 4.714323825338104235e-01 -1.281093727336620192e-01 -9.324734737783105243e-02 -6.274822753821347465e-01 -3.308995462958216338e-01 -1.943654468973747829e-01 2.298787886894115562e-01
5.366029324463417183e-01 8.111143319255449680e-02 -2.593837218771863906e-01 -2.067527859605538740e-02 2.264216750454747518e-01 2.326076876913152347e-01 3.482107289989035959e-01 1.636948191476247372e-01 3.402402619754591462e-01 -8.957169520312766031e-03 5.181769604212304037e-01
-2.673172106029251816e-01 2.361432803177541603e-02 -2.243680300093332247e-01 6.033943174449634128e-01 8.631937047806011870e-03 -5.224583505132129879e-02 -6.503081875916209009e-01 -1.170281124467957845e-01 -8.496194267010187540e-02 2.160728238142858859e-01 -1.423084844610951472e-01
-7.216688219645275848e-02 -8.047964268863909421e-02 3.565212546721640008e-01 2.704942347978140371e-01 5.075474425807372514e-01 5.154945998398742513e-02 2.987645644547758800e-02 2.722159372916286846e-01 3.030605974840026029e-01 -5.177184847569312742e-01 -3.048055190909833012e-01
1.589210547504928128e-01 2.247417028165784314e-01 -4.582724260198230426e-01 -2.233347772781281992e-01 -4.634026645683914647e-01 1.160035365746401731e-01 1.074709817346964497e-01 -3.614817289976562931e-02 5.011468331554950195e-01 -1.586132596325245114e-01 -3.833814801489164870e-01
1.576346111366611902e-01 3.304489579300078778e-02 -1.523394500780368144e-01 1.366306260733035904e-01 4.417259301317350562e-01 -3.976988248739640186e-01 4.165989372664262447e-02 -6.806324744930215831e-02 -5.187585070299595147e-01 2.685642657339448736e-01 4.809289653388093555e-01
2.082293535026813469e-01 -1.065598333299799250e-01 6.016263543335351183e-02 4.491714165539004155e-01 -5.695259949268647315e-01 -3.499779696402702256e-01 -3.065146212212766508e-01 9.093653092753486988e-02 3.151641874912628483e-01 2.100334720479226647e-01 2.177232322035623779e-01
1.225648518480291910e-01 2.121126314705409910e-01 4.524303506274954811e-01 5.916285012456161674e-01 2.886433404335438380e-01 -2.619199327400565380e-01 -1.606604929425547723e-01 3.667093793754470227e-02 1.052143311935716530e-01 -2.404775736125709940e-01 3.705340514487246995e-01
2.824523072345777042e-01 7.252628010361300559e-01 -1.146158311884075548e-01 1.652787912588283281e-01 -1.108400211330743540e-01 -6.716952767721177942e-02 1.183107456197791396e-01 -1.117641489907407470e-01 5.222247438612976911e-01 -1.802897551365057471e-01 7.246864012819495549e-02
-6.034151148027335626e-02 4.830608523541020660e-01 3.285691741239303854e-01 -8.955956361758771189e-02 1.864962376729100701e-01 -3.191742919768623121e-01 -4.163003246516065459e-01 3.236876799868806387e-01 -7.831307509955660190e-03 6.193471047983575145e-02 4.779147515513716415e-01
4.140728164937121369e-02 -5.869293348562697882e-02 -2.637752095245332606e-01 3.468177744264202556e-01 5.338796723279908285e-01 -4.211784262793163980e-01 -3.079973168934321270e-01 3.034498550753636503e-02 -5.586685774588479730e-02 -1.752570665118093618e-01 -4.614570022911783642e-01
1.817294609595618560e-01 2.354060445084953934e-01 1.107741536381093017e-01 4.146969603956588979e-01 -3.416719625819690243e-01 6.635224930149577482e-02 1.449055533537067786e-01 -7.150378286166890751e-01 -2.993109991623493782e-02 -2.061926359771503736e-01 -1.745954596533831060e-01
-8.499223361813516842e-02 2.116688774607270451e-01 -1.751792363335334113e-01 2.668581595897091541e-01 5.338747736150988715e-02 2.278908370247368642e-01 -3.729758789827799514e-01 6.080519379285770354e-02 -1.791748097356046787e-01 5.860250930743359232e-01 -5.224459856927893275e-01
-1.830297844028095644e-01 -8.409105437172549602e-02 7.066908518045837695e-02 2.160901506157435481e-01 -2.702276943078344429e-01 -3.350797498415293840e-01 3.557078510699007712e-01 -2.989475495379786962e-01 -1.306649122438128807e-01 -5.706923033887432162e-01 4.046943749937511048e-01
-1.573409948201129616e-01 -2.324220070679413469e-02 6.911109154704032642e-01 -2.056394814639774804e-01 8.741551726108949191e-03 1.174425940928639084e-01 2.545823596007007472e-01 -4.715846560509032170e-01 1.046673893623128737e-01 -3.166348812520426992e-01 -2.061440368733524486e-01
4.018977303460396500e-01 6.309035037485002939e-02 -3.030274460671434911e-01 -1.380502168772061167e-01 -6.137838548288919449e-02 4.911118175776896244e-01 9.479424908753290857e-02 3.274261981104641395e-01 -9.948781105636329836e-02 5.894445884910450850e-01 7.155131511165357949e-02
2.355636210257234520e-01 5.398215766612023125e-02 -3.120012637685288248e-01 -9.906211432837368214e-02 5.568171478084558285e-02 -4.272950190506059620e-01 5.201461945577676715e-01 -2.412228909334349358e-01 -1.545144878916082098e-01 -3.254984990338343209e-01 -4.361095993936651705e-01
-7.646691750399005338e-02 -2.810334067356690113e-01 2.504438262030377338e-01 -4.116001428435299425e-02 1.842895791970676211e-01 4.171040997233581293e-02 -2.438186318152520127e-02 -4.608196261570616792e-01 -4.832855146669435414e-02 -7.695446755679966611e-01 -8.700868336278332060e-02
-5.677896874369839919e-01 3.838090147491882709e-01 -2.060283557574751900e-01 -4.404830339077041579e-01 1.248635865159389846e-01 -1.863760815782480595e-01 2.854900139977019635e-01 2.741749413879699393e-01 1.346780250019372072e-01 2.606559867731872981e-01 2.737526332455506028e-02
-4.017232188265490445e-01 9.974605981072366678e-02 -2.608175753201335545e-01 1.445166079345232835e-01 -2.952720176862249635e-01 -3.559873275536237225e-01 9.040849860347704992e-02 -3.438365883910683984e-01 -4.846419560524046211e-01 3.041726958113215584e-01 2.684206196555342094e-01
4.420225592741641174e-01 -4.631797561030728261e-01 1.518128490808552944e-01 2.241266426203656625e-01 -1.553414025548180031e-03 6.083960299752805279e-01 -2.346273116089868660e-01 -2.342276522430960239e-01 2.232452255962901269e-02 1.867926636024800080e-01 3.674347907421245812e-02
7.496031375600648028e-02 2.814898903884413203e-02 2.795205430573562411e-01 -2.874345935848307554e-01 -2.457912643329527025e-01 -3.427190342631575848e-01 2.927405260517444430e-01 -5.819489146803785706e-01 -2.495644205774491808e-01 -4.099440068096424916e-01 -1.644629139496891351e-02
-3.642246652295302312e-01 3.278972089352119590e-01 -1.883858115355653007e-01 2.397268283092191758e-03 -5.332012796110411346e-01 7.173757787202737768e-02 -4.003638726884019006e-01 -1.317975885309134731e-01 3.008942163818363325e-01 -3.081744803634223762e-01 2.677840424186611612e-01
9.294462323365612622e-02 -1.562445056616968142e-01 -7.474740081334461939e-02 1.692781249825262846e-01 -1.538432397917905980e-01 -3.236124495570269488e-01 -4.159637373236958480e-01 1.785765074795937768e-02 2.866301740967279188e-01 -6.873273459442300615e-01 2.763936872553515167e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
    12: ( 311.778849, """-1.622358097457904935e-01 1.435886498016634705e-01 -8.101461791585033712e-02 -6.007851882941374067e-01 -8.014002487686819332e-02 2.432462548837134031e-01 4.078233465127577007e-01 -2.355168428684141224e-01 -5.336557701891864181e-01 1.118730107281576229e-02 -9.323175440121647672e-02 6.760624798467695928e-02
-1.238932185854450113e-01 -1.239077952369730257e-01 -5.008737344270791647e-01 -2.172835726414704960e-01 3.386497070463200254e-01 -3.338572460679458537e-02 1.799828188699525156e-01 2.598450755103644538e-01 6.138127882203425756e-02 3.251377637035784973e-01 5.821481535172132737e-01 8.438288584984743324e-02
1.341716666123866364e-01 -5.607993648488841104e-02 -3.118379634715134907e-01 -3.352776805575228836e-01 5.705871208980484166e-01 -1.145858008811016099e-01 5.108233650689569111e-02 -1.721196345500940195e-01 7.574331459876327242e-03 -1.993478462373939608e-01 2.837333501526524415e-01 -5.272222261777886887e-01
1.579108496702477937e-01 4.013890983069492296e-02 -3.647485399914585785e-02 -2.221377259694158612e-01 -5.871175189708099929e-02 6.198711962754468452e-01 3.861353268209139628e-02 1.319092642770512865e-02 -5.085386598726826524e-01 3.185301962263176745e-01 -4.026375923500418175e-01 -1.059952202006888416e-01
9.428956322659393097e-02 -2.282386338453186725e-01 -5.102520752502816004e-01 -3.068925444189748997e-01 -6.851051880214849288e-02 -3.912740914828756467e-02 1.377632039486051674e-01 2.379709127427755699e-01 -4.296041526773545366e-02 -4.659007515621763074e-01 2.434839199059578574e-01 4.737608704017562400e-01
8.899719014871131095e-02 3.419771372156295564e-01 -2.257520131278302200e-01 -1.241557040594876843e-01 1.591485376809171348e-01 9.947441351153081535e-02 -3.678027254027896320e-01 3.390995418995956245e-01 -3.627503156432533571e-02 1.143146787901812853e-03 -2.420178199958920306e-01 6.807142994464367991e-01
-4.803968950964245255e-01 2.740112306836307021e-01 -2.216852494157997844e-01 1.701053420312875417e-02 7.095992884241308918e-02 -6.116759598720177687e-02 -1.218932150780669375e-02 -4.012296634334067309e-03 -2.075722342575192780e-01 6.635436261851065387e-01 1.634430321723981949e-01 -3.545017561649206894e-01
1.494660485141196260e-01 -1.908769492181597582e-01 3.010720087981253457e-01 -1.821487489042154240e-01 1.356587073014551004e-01 -1.298060584170503684e-01 6.361837574088409220e-01 1.794894997129485303e-01 -4.372019723175209482e-01 1.591624292250639061e-01 -1.915580235593699610e-01 3.033669364944036606e-01
-2.225533737900257381e-01 -3.932356684351471232e-01 -1.098448376603770871e-01 2.488355395497599543e-01 -4.193536210171740497e-01 -2.812957761685606628e-01 3.653288079384845455e-01 5.510184997078235725e-01 -1.347320693809692105e-01 8.575635453206952030e-02 -6.435638814006681974e-02 -1.143525881380299571e-02
5.050116743663273233e-01 2.526958014188357415e-01 -4.152889984720007921e-01 5.787154382244728140e-02 -7.390322129005347240e-02 -2.016273900331790325e-01 -4.207964601640794555e-01 1.354614108389353699e-01 -1.693982746499515801e-01 -4.165735345355983665e-02 -2.959752652441121623e-01 -3.817417444209493804e-01
-6.547054604255017618e-02 -4.009807525222996438e-01 -3.758777032047952993e-01 -9.737223456584181980e-02 1.589445741081448472e-03 4.610074021784488774e-01 -1.971439726057760411e-01 4.167078621272442551e-01 3.747330665263318844e-02 -1.746913029310126209e-01 -2.465454051948471059e-01 4.079401518951563665e-01
1.996621390076947777e-01 3.128716591643366796e-01 -1.840613140801197478e-01 2.930880901449722797e-01 1.175470749585416641e-01 -1.135653183153960272e-01 7.359828177198693422e-02 2.257440252605869557e-01 2.219544536169239524e-01 1.907291658287310621e-02 -5.689202434561029254e-01 5.348624980266944995e-01
-7.302474125537372629e-02 -5.740021788991012119e-01 2.503800441530702470e-01 -4.423887860939473282e-01 9.775195282142877529e-02 -2.217955388925710036e-01 4.880715269663412487e-02 2.793905458447600854e-01 3.830106233935902660e-01 6.191284348887873129e-02 -3.272394359298930189e-01 9.992484349813481048e-02
-1.957681695046504800e-01 -7.090260379500049059e-02 2.380945416006539361e-01 5.435977990031810592e-01 -1.911862965782410440e-01 -1.334715793104905013e-01 1.092124840282663462e-01 -2.532567438704891316e-01 4.167888824774317325e-01 3.951591125980222219e-01 -3.593213897678424473e-01 -1.226837451563005527e-01
2.223708002236801096e-01 2.881490903225413236e-01 -1.476299536014714919e-01 -2.576179828163010499e-01 2.251545096387982947e-01 -4.609254988928027652e-01 7.360094760703458916e-02 6.506324345843841339e-01 -8.025882632239811354e-02 2.091168447765258953e-01 -4.775933777097202126e-02 1.871386630418095942e-01
-4.059394763239156934e-01 3.583456321458898253e-01 6.545632607654455759e-01 7.336224368137034268e-02 1.654875540586403515e-01 -2.158401879888645000e-02 2.811341905975332511e-01 8.016952414194442045e-02 1.220015210912438613e-01 -1.103286918667598510e-01 6.825188908536442001e-02 -3.576811015985379427e-01
-2.089523701195071248e-01 -3.280627908359552425e-01 3.236572078053154278e-01 -1.951587371740426125e-01 -8.093018951550960682e-02 3.669725502028935438e-01 -4.243013569226499193e-01 -2.472367615139828556e-01 -2.097095266921722712e-01 2.722814970178157878e-01 -4.450545159497517056e-01 8.548546164069829867e-02
-2.077912923793164834e-01 6.188613809636309693e-01 1.143329885004373547e-01 7.071122897493667403e-02 2.197515088759076640e-01 9.987460311073784180e-02 -1.604834249695921700e-01 -3.345442869865024038e-01 3.774215075299761080e-01 1.787808179462553604e-01 -4.232509078648568068e-01 7.918258606116052034e-02
-7.496112467434603577e-01 -1.496270996621540395e-01 1.741950061345847733e-01 -1.105404134482796674e-01 6.020754312109287409e-02 4.034377484189032859e-01 1.369026362590604617e-01 -2.899961204624468825e-01 -1.460831908480744214e-02 7.869552554030394276e-02 2.953638267420494734e-01 1.012837645660131375e-01
1.193184832506514054e-01 -3.467078450753451335e-01 -2.111205727276982969e-01 2.943023289184382718e-01 3.537770271815001560e-02 -4.428699100889905982e-02 2.472839863758217460e-01 3.192181777458829028e-01 -1.460187143771804197e-01 5.062175014517122928e-01 8.273060650022871776e-02 -5.326222877072045447e-01
-2.131111327405561251e-01 -2.711156598178212640e-01 6.679008513599835051e-02 -6.423864716114972007e-01 1.644104107804246762e-01 3.422222678949574104e-01 -8.509640191702881606e-03 -3.674558358031428801e-02 2.729234923228319176e-01 3.017120853411474068e-01 -2.062428614611321043e-01 -3.321680312889324083e-01
1.419706140620102253e-01 -3.463625125822942796e-01 2.046323996505021725e-01 -8.537271842870114771e-03 4.267638746139178485e-01 1.973717483910135961e-01 4.028932533713024400e-01 -4.334358916198560729e-01 -3.704975328069967655e-01 3.489289256160570118e-02 3.243999426289314036e-01 5.418611061361575110e-02
-2.161815443137945214e-01 2.010114666886770873e-01 -4.713269951287753917e-02 6.521704336047901007e-01 -9.566535072427183317e-02 1.469034183986217892e-02 -3.551822590316224271e-01 -1.445382402422931423e-01 4.583746356965544555e-01 1.191205118026799348e-01 -2.411447649261029835e-01 -2.155248435727916134e-01
-3.028848553806337898e-02 2.359005886825333784e-02 -1.275840052419363879e-01 -1.439496294443434188e-01 3.466129758171855313e-01 2.246190086960031806e-01 3.701168277486339697e-01 6.475987535560123742e-02 2.581685385393109322e-01 1.834243237425428608e-01 3.218556149759325691e-01 6.677318826602418600e-01
-1.851510702035303324e-01 2.285062533417536734e-01 -3.777509053803667083e-01 -1.860772769861797626e-01 -7.164499101841305118e-01 -8.644410815433288542e-02 1.482622120264425192e-01 7.698286276292595764e-02 -5.771416558461259227e-02 3.827924052642980302e-01 -4.208345083556405686e-02 1.893948369859743963e-01
1.986309057294635971e-01 -4.878263708466592519e-01 3.669018350622357122e-02 -3.835975801966513138e-02 2.853989022269434184e-01 3.884621206588410869e-02 4.577703149040360242e-01 -6.204558116183593874e-01 4.020277729343874756e-02 -8.764236841794689759e-02 2.338092153182284860e-02 1.800799880508192619e-01
7.253445439384766102e-02 1.224842664145488202e-01 1.233968022463644981e-01 3.870178631297714889e-01 6.490937321187904008e-01 -5.279602982348108320e-02 -5.088546130719014821e-02 2.491744822597981579e-01 -3.076725686010630123e-01 1.804188580042592471e-01 -1.415630409565939996e-01 -4.227126035968085116e-01
-2.358975365480850961e-01 1.181651607856531588e-01 2.723889410505195841e-01 -5.391279649670210894e-01 -6.807857107847757883e-01 1.786349382554205389e-01 1.304196922278504089e-01 -1.364890354733565569e-01 1.564170625196609210e-01 -1.100880735844218632e-02 7.489688997624407985e-02 -6.572241395891960380e-02
6.418633643315940773e-01 3.625237945390279437e-01 2.159111615376122784e-01 -5.737964817665720113e-02 8.544220985616743369e-02 3.652205581217254221e-02 -1.287120646766729271e-01 7.817501833385519586e-03 -8.286795107265711169e-02 6.024540017696969896e-01 -1.033302527945167276e-01 3.034242575294760977e-02
-6.942392041442679851e-02 3.814366808782240215e-01 -2.997925099603684571e-02 3.310296473214270896e-01 -3.614184174262327631e-01 -2.755771958556372248e-01 2.701421112814998415e-01 3.438383980009793728e-01 -1.944731297462278796e-01 4.547004173470389765e-01 -1.036671500092835457e-01 -2.934624023293385675e-01
3.507400741717965342e-01 3.001452866207013903e-01 -2.205518191002171779e-01 -3.371532489187075710e-01 3.378239295485731541e-01 2.797774693542922492e-02 -9.479603054196216599e-03 -2.507726657217692057e-01 1.208268881776576459e-01 4.030122360994661257e-01 -4.664016507112287990e-01 -2.283544077508644909e-01
-3.697096086485556626e-02 1.851805929293295350e-01 -2.257308485513867258e-01 -3.602661671665262633e-01 9.056876217806163198e-02 -4.152589495057026348e-01 -2.308737561318068288e-01 5.083436136728506360e-01 -1.888416008887595920e-01 3.197213012638300822e-01 -3.871905407589960046e-01 -5.862743932447793405e-02
3.606174485612151370e-01 -4.413352299245992816e-01 1.632499479296709299e-01 4.579200175668606820e-01 -2.065314763792914024e-02 1.863270173617514319e-02 7.022295984121638968e-02 -1.918676966270304318e-01 2.902932665725443395e-01 -1.587817224412801931e-01 3.659232470687307642e-02 5.343200924798995333e-01
3.840658037721752516e-01 1.480020811008115889e-01 -1.300647815571378263e-01 2.861829683476957431e-01 4.266549009201344167e-01 5.345588391291763997e-02 4.564897093951347795e-01 -1.563335580842202255e-01 3.277795727045045293e-01 1.566924459378255530e-01 -3.920994815377433773e-01 -1.682924748744182297e-01
4.093181981341997289e-01 9.656330215356284663e-02 1.331748968117942022e-01 1.914975948734138345e-01 2.066642575459469999e-01 4.798944892920012917e-01 3.976743833458253052e-02 -2.158479355384335108e-01 1.499543054861716962e-01 -4.374133617242069727e-01 1.323630362019080908e-01 -4.649837918048231877e-01
-1.112686512774363062e-01 2.318199835676361398e-01 -3.660819639421666188e-02 3.236075998368592166e-01 -8.041005857963934300e-01 -1.082051396550060829e-01 1.320556934882718136e-01 -8.783958637533810510e-02 -3.178664903231440131e-01 -4.489890568606209886e-02 -9.384824722507772998e-02 -1.803153609476763064e-01
-3.313835914914044223e-02 -2.200929073756957011e-01 -1.186570328983967693e-01 -2.693723314571386251e-01 2.172810674301330069e-01 -6.871931406909960183e-01 -2.875402316084307297e-01 -1.881633491994869900e-01 -3.414836652928018301e-01 -2.196174013041850004e-01 -2.372563715333868839e-01 -7.180688520316819146e-02
-3.547809206016261374e-01 5.857399269282349830e-02 3.932594094385157280e-01 7.723745226514036610e-02 1.768466346001962564e-01 5.052881358785155097e-01 -2.153571643757746235e-01 5.549242137123918672e-01 1.981080212495506948e-02 -2.571276283627300097e-01 -1.425861125735933613e-02 4.960022004172674054e-02
-4.858749782001781092e-02 1.164936643389284099e-01 4.614132796244769241e-01 -3.506216088664689257e-01 1.355126234228626325e-01 -1.142459956054906328e-01 -2.941690496569769886e-01 2.478477047676869716e-01 -4.590480897797751814e-01 -4.377251404719949557e-01 -1.567692588686846467e-01 2.048071605073690793e-01
7.497316615833203857e-01 -1.336230900035548785e-01 -5.791753147949894875e-02 4.392988965226241049e-02 3.259528370843743361e-01 1.786447610825402377e-01 -1.164835983984480183e-01 -1.107843153972683098e-01 -3.968074853690059522e-01 -1.435394044567707590e-02 -2.610602506207513121e-02 3.040041007694797570e-01
-5.105912342869511900e-01 1.856128704058362666e-01 -2.773517015628594873e-01 2.213396526792045793e-01 -2.551277370395428346e-01 -6.048149712919386189e-01 5.276795449379639846e-02 -2.726220190989974909e-02 1.842050102101857323e-01 1.644734597355074213e-01 -2.579032379881489034e-01 -1.304345211674177996e-01
3.292819657416363732e-01 -7.678943667831483744e-02 3.084227845755197484e-01 1.477837802592630312e-01 1.113031114764711366e-01 -3.008736004001940634e-01 -1.111106243361464629e-01 4.116172179785910767e-01 -9.216743040390003305e-02 3.254332961574112892e-01 -5.605697931347590757e-01 -2.353387775733337683e-01
2.775844856505013669e-01 -2.448293936177922125e-01 -2.092673291567581639e-01 -3.622237415918790893e-01 -1.792901931039255214e-01 3.185737522968790647e-01 8.741439175708076714e-02 -1.189613884592334442e-01 3.426543144476287273e-01 -2.873128928133406035e-01 -4.105994287587610980e-01 4.050021012441007984e-01
-4.743700143306566197e-01 3.976197136519592501e-01 -1.805669819974383694e-01 4.602787778307361466e-02 -3.400581910954784681e-01 3.658744735758778788e-01 -4.306432022349320210e-01 -9.473908056535058908e-02 -7.494571278441221340e-02 -3.067151418427711135e-02 1.874747709448965349e-01 3.106629944929860110e-01
-3.090061823338239311e-01 -2.081338880081314013e-01 3.628132585925558096e-01 4.613659680542983033e-01 -2.683089590910167632e-01 -3.399423549361371699e-01 9.626189145017363669e-02 3.014256337736104796e-01 -1.052779846348721737e-01 -1.920923606115420013e-01 3.366194862232689267e-01 -2.602567437053919797e-01
5.829156195935713408e-02 -4.505717652902511694e-01 1.941556000392242742e-01 -4.102050832028790173e-01 -1.149073520882240018e-01 1.832347511585691591e-01 4.857754230091765324e-01 -4.674786749475786096e-01 3.335328627320448269e-02 1.763291991520784807e-01 -5.384264497741479694e-02 -2.263324225380341503e-01
4.374653781847121642e-02 -4.478747313972819555e-02 3.628577892230703816e-01 -2.295121653348626278e-01 -2.921718573786734607e-01 -2.483358049250606048e-01 4.266240945269093587e-01 -2.582545567622824834e-01 4.308941407208315838e-02 5.323747025699048230e-01 6.901096001196380114e-02 3.549057324524231838e-01
-3.778428155353491524e-01 3.023147798099962702e-01 -2.758917140146285862e-01 7.909680767279715641e-02 -3.291793711698581121e-02 2.136381698705346610e-01 1.617576178599519354e-01 1.562607475637885768e-01 5.135150069131618755e-01 3.375426777056348415e-01 3.781655287936538379e-01 -2.559655107054624179e-01
8.155490629642052625e-01 2.048748859857073001e-01 -1.203986325481516429e-04 2.317503035076847462e-01 -2.845798987330803720e-01 -2.540215339543230311e-01 2.178200961694214469e-02 -1.932057378458139907e-01 -6.436689709350325306e-02 4.441292825605176048e-02 -2.188307860450406928e-01 -4.335549797968848290e-02
1.837129796512369240e-01 -2.021410586086221095e-01 1.447187655156158270e-01 -6.489704180128949562e-02 -7.734913745670833896e-01 7.400501163499594026e-02 -2.972916043263210684e-01 -1.097025913868408392e-01 -3.042515397936054189e-01 -3.123841079009201938e-01 3.497008442035422909e-02 6.837429654811166824e-02
-1.806262058107201973e-01 2.258870064241741069e-02 2.932054960636188978e-01 3.809889652119077819e-01 -4.049310846510677520e-01 -2.649739778418960801e-01 -4.367673990772948101e-02 1.981116327758687332e-02 1.612925862766847740e-01 -1.080292910322010747e-01 -6.733913438627152637e-01 -9.010998665606172187e-02
-1.131172834014995271e-01 2.114186588556558610e-01 4.937915999573681824e-02 -1.454242897887238761e-01 -1.497569417508888556e-01 -2.557853500942727787e-01 -2.937635778661445429e-01 -3.261545001056376236e-01 -7.071708995705232592e-01 2.358618167564243417e-01 -1.925979718516145356e-01 2.134890261147313062e-01
-2.933145734577300989e-01 4.564663366881531459e-02 -2.887869969649735358e-02 9.919473463016226233e-02 3.816093867715180110e-01 1.949163545564120970e-01 -3.782556117329488599e-01 -2.988768061711899460e-01 -3.120825560716711244e-01 3.181191781237233118e-01 4.686927066093621308e-01 2.586859528735607205e-01
-4.027351302659685772e-01 -2.301147598508001546e-01 3.164779262233709534e-01 1.667417594122950764e-01 -9.015915354640864632e-02 -3.779582954111899151e-01 -5.437069709871163170e-02 6.051829558376101703e-01 1.924321699964208487e-02 2.311787607246973131e-01 8.696369292468758214e-03 -2.877798526697997183e-01
-2.826914206862730650e-01 -2.699039632963622440e-02 1.172596902567296651e-01 -1.341967089327176788e-01 2.026603113303628023e-01 1.808319059727756528e-01 -5.319325092506012043e-01 -3.549827641705201320e-02 3.226457642238377277e-01 4.975101069336890780e-01 4.218982097211991245e-01 -3.007618200205156044e-04
-1.030643532081507024e-01 2.007310913687605225e-01 5.319041645063031787e-01 4.824894120490108018e-01 -1.094455669516964519e-01 -6.390372459066517852e-02 -2.505425490295070667e-01 1.377700280008323230e-01 -9.692536999274403708e-02 1.921409658675958879e-02 -1.584585544548682834e-01 5.483426895016019209e-01
-3.692023735536263396e-01 -5.103007082063752975e-01 -1.292822001398547527e-01 3.469664357687179956e-01 -6.346117104132502351e-02 8.760266361881571817e-02 -2.440971137853376050e-01 -2.373804506153428251e-01 -3.558671203719809273e-01 -3.443230544178665364e-01 2.969805850876666153e-01 7.177417685463224895e-02
1.273974067629392581e-01 -4.152151186515258274e-01 2.226022657579357009e-02 4.642383463970939372e-01 1.365050595251890708e-01 2.866877022381124074e-01 3.441099787593870918e-01 2.790365466038790404e-02 2.446306428147652923e-01 -4.525614074502819495e-01 -3.319809928712647018e-01 -2.173536702454394870e-02
-3.298201346048144633e-01 -3.693568623551085617e-01 -3.592530556377511453e-02 2.667846486641458070e-01 1.439059976663175089e-01 1.953161160143913333e-01 -2.861912115181220462e-01 -2.452362232976194323e-01 -2.537063432403732777e-01 6.313618123308456509e-01 -7.742440194538140197e-02 -1.115651823118740810e-01
-3.862926423038594015e-01 -3.572456822701135237e-02 2.956932602800492194e-01 8.727652433144104938e-02 -3.164473592900083898e-01 4.715722231206009862e-01 -3.238287645906307022e-01 3.767995049852156803e-02 -1.441244259830540796e-02 5.279613875367297204e-01 -2.061846662725379531e-01 6.467497003329460148e-02
-2.065119428215742292e-01 -2.643777368896918500e-02 5.068275616488666646e-01 -2.710722108228312277e-01 4.758286338979451219e-02 -2.665165176579866180e-01 -8.622692172902689245e-02 1.650245120694478207e-02 -1.841812024247937996e-01 -4.229062246034581141e-01 -5.262992152089788211e-01 2.356558736864477199e-01
-1.234798412537037732e-01 -1.532615430568722570e-01 -1.187713922662310267e-01 7.674996492688880567e-02 -1.231675048524342314e-01 4.328206158305759055e-01 1.138264413976648563e-02 -1.164283620086584564e-01 -1.151184709029630104e-01 7.925931116090272344e-01 1.072104248435601457e-03 2.891714497644057302e-01
1.221700016575706510e-01 1.424373502987723028e-01 -1.534005832644494971e-01 -2.820762556522823927e-01 5.470141912476295110e-01 1.767267356450092641e-01 3.899053695159211963e-01 -2.057512366290210892e-01 -1.826501633238789557e-01 3.448673156646447913e-01 -3.716930555651476453e-01 -2.154540108354402461e-01
-4.868357768990908552e-01 -3.965929183176944428e-02 -2.356851139198486988e-01 1.875987565398640755e-01 5.153614409646282285e-02 -1.091935978730192852e-01 -3.479205045825356502e-01 -3.554864349458851380e-02 -4.537731458634423620e-01 -5.689610032808833928e-01 -4.138889353401246224e-02 -4.945674197239598169e-02
5.813480456588935308e-01 4.288330875255141894e-02 3.052400572344967089e-01 -2.262868884741091047e-01 1.036022372853425411e-01 2.347307506836659452e-01 -1.158909228222594484e-01 -3.837748793580636475e-01 -2.595518854362001138e-01 1.998337773938749229e-01 -4.238368449042518860e-01 -4.831168986784291353e-02
1.227078493177623658e-01 1.635370110662913989e-01 -3.425060993463113768e-01 1.092619291352903838e-01 -5.072488928881798698e-01 2.733330549704858781e-01 2.265517547142484669e-02 6.224013669010713262e-02 -2.323498422882762648e-01 4.619000143789884216e-01 -2.783104073945261159e-01 -3.843898896356298667e-01
-2.558494819151943545e-01 2.474780758132407582e-02 1.250327373417243759e-01 2.655486313683113053e-01 2.849355032581046398e-03 4.882234323047590641e-02 -1.141818044256919795e-01 -6.542206516373089142e-01 -3.048896728971152714e-01 -3.212170599302981433e-01 -1.477691094567119001e-01 -4.317077948594673087e-01
-6.505152554501424378e-01 9.123030138781582435e-03 -6.142936342293418145e-02 -4.692068146061167955e-01 1.722822559786651442e-01 4.310966830987734144e-01 -2.982961276093621938e-01 4.175773838470038524e-02 1.067667456476301541e-01 -5.276729942009698165e-02 -1.761173490681647025e-01 3.697851148538608412e-02
5.043107338583065896e-02 1.407172336670967361e-01 2.591786031579312866e-01 1.865579599161059643e-01 2.338726525329586359e-01 6.671923178536971477e-01 2.519535534694924625e-02 4.589315141880085935e-01 4.618147229687641353e-02 -1.095142513808485957e-01 3.110375612595475681e-01 -2.317596488567991719e-01
-1.238744504795375873e-01 -1.874032629074280643e-01 -3.679633554186997803e-03 1.161553283046896506e-01 -1.846520453056725575e-01 -8.582415676991972386e-02 -4.365225192543493726e-01 1.473526925647307695e-01 -6.204992287322175920e-02 4.921443479388028508e-01 3.952706488289600140e-01 -5.291573585125255441e-01
-2.858857056200173052e-01 1.971549681539271903e-01 4.883849274080807046e-01 2.288158271751209172e-01 4.453745456664892632e-01 3.611466518875020570e-01 3.033315390307035272e-02 1.271182639075486565e-01 -7.418284074917019799e-02 -4.853010728627188963e-01 -2.666511342471803922e-02 -3.044609942342790809e-02
-1.746083869279797529e-01 4.180820173445455590e-02 -4.333861752406961004e-02 -5.430851224875912209e-01 1.127133295696485932e-01 -3.852017503620420724e-01 -1.719773066793095322e-03 -2.729277190503147654e-01 -2.272998770800364610e-01 2.083785109917385137e-01 5.813000752129265924e-01 4.868781623287705279e-02
4.181055714567489395e-02 9.955532752669907226e-02 -4.032643683850618138e-02 3.049220740879228508e-02 -6.204887654565884869e-01 9.529001232199671434e-03 -3.704063691896831295e-02 2.652655669651423631e-01 7.607061324556592397e-02 -6.765079343819425661e-01 2.546974845293870082e-01 -2.508278336961522470e-02
-2.867779421278346952e-01 -7.430204220285151206e-02 -1.818387428251476423e-01 -5.454179113772764653e-01 1.262320925034055019e-01 2.297888709383110462e-01 4.559904683614521281e-01 2.692793701180939969e-01 3.024865577632623315e-01 2.751688511958385042e-01 -7.492124301725873459e-02 -2.443076590004642223e-01
-3.995691905831019741e-01 -1.162424375750518851e-01 -1.303841671537532901e-02 3.248773286701966967e-01 2.179408503614764792e-01 -7.053632858377639758e-02 -3.636897433976635785e-01 2.067067296302383533e-02 5.141009908753790825e-01 4.501330278870913082e-02 2.460282363809427886e-01 -4.572634527551616701e-01
-1.519064789861714615e-01 -3.968511860983473527e-01 -3.285443467327250344e-01 -4.076385679308708876e-01 2.701176777997534861e-01 3.248753959546422654e-01 -1.078234629637646186e-01 -2.443034519648311920e-01 3.523048578957755361e-01 2.482310339948394506e-01 3.142127187041912628e-01 -1.050633980268948220e-01
-5.809597349436980140e-01 -5.515528690071079543e-02 -8.960102753133035447e-02 4.059679627010225333e-01 2.128327927351162524e-02 8.727105857961589552e-02 6.694349351267112613e-01 -6.406346194536199912e-02 -4.949252430641352951e-02 -2.926288065818713306e-03 -1.540976614775903808e-01 9.203926502442325019e-03
-4.102159424988265912e-01 -2.305091571417448859e-01 -2.960774401263297495e-01 5.445606839291767809e-01 1.087433275375362385e-01 9.163992667820015925e-02 -2.079068463729986660e-01 2.465225062990016036e-01 8.809413318436336293e-02 1.535065356495472766e-01 4.882600472143019954e-01 -2.087877247007353249e-02
-2.273167406450064543e-01 -5.999208562843233450e-01 5.923574806709820673e-02 -2.236777089101456284e-01 -2.534992152313937375e-01 2.168840314931594071e-01 -3.031049334977822460e-02 3.312559782222142535e-01 -1.911193025439673343e-01 -5.772680249152669502e-03 -4.997916529131143371e-01 -1.630339902804279206e-01
5.036435937219500003e-01 1.164864772835474266e-01 -2.010442147294823623e-01 4.124229715785988071e-01 -1.910837967181827912e-01 -9.238610410606649948e-02 -5.244791179274405080e-01 2.410159980059408680e-01 -9.829121103755071587e-02 2.304609040745388415e-01 -2.794039822001204154e-01 5.663307841489026440e-02
-2.188003832961207817e-01 1.166601336231946895e-01 -1.581386082734091356e-02 -1.458070954213550041e-01 -2.136647893225532280e-02 4.497170410617059022e-01 -4.131348038019189151e-02 1.352394982422858993e-01 6.255887167088436396e-01 -7.993918180495920844e-02 2.516619297043690140e-01 -4.829319901499705692e-01
4.727473579123676189e-02 4.706513669183595150e-01 -3.455023560193611343e-01 8.262794087650070229e-02 1.208965877707035910e-02 -1.565807462052589694e-01 -4.307531874037423547e-01 3.007807905451241604e-02 -1.544447475105841516e-01 3.020126080989221640e-01 4.760529178260989869e-01 -3.118417391252011339e-01
1.083690723834119796e-01 4.678785002029686724e-02 1.038559044532635783e-01 -7.806411142750134535e-02 6.526254329298404600e-02 -5.093416820676764656e-02 4.952308838115114797e-01 3.331959557486423584e-01 -2.719412282582308604e-01 -1.234611790713147084e-01 7.041300399857377545e-01 -1.451430915610837646e-01
-9.910513718117122672e-02 -1.910081530833454277e-01 -1.945681180306327307e-02 6.084695114706074187e-02 -4.065502039379970817e-02 -7.192151766566766413e-02 7.750091335455291941e-02 -1.481606394981728470e-02 4.407140500639987746e-01 -2.772264602175779705e-02 8.381812968219456428e-01 1.975256696580736104e-01
-2.727292127970614710e-01 1.115516984425658359e-01 -5.308445558109379236e-01 1.515369909410660409e-01 -3.122201871072608492e-01 1.813645719264294839e-02 6.539277551989693127e-03 -3.607601725359782519e-01 1.801835385185191762e-01 -2.099314443912924655e-01 -2.247778022038217083e-01 5.033410108339629874e-01
-6.280110487199658253e-01 -6.627738194703793051e-02 -3.118778957263594886e-01 3.284625329670186056e-01 5.328450881992422006e-02 3.327359313206588731e-01 1.793770747627039530e-01 3.335414869856921927e-01 8.592243396482646123e-02 2.590932386245697883e-01 -1.259670977654368529e-01 2.206712393588484422e-01
-4.404804348903543776e-01 -8.494374805871107714e-02 1.441713058879501297e-01 1.039142363624090681e-01 4.396987423986069010e-01 -5.895479143151723805e-02 3.960658176197712765e-01 3.282105575724512114e-01 -8.036663407730146313e-02 1.357656680647426339e-01 2.790439011229780553e-01 4.505779038567300776e-01
1.845043720370603824e-01 2.478988146491494515e-01 -1.646280833186546666e-01 4.142346319859373516e-01 -3.528656780910377488e-01 -2.507580468982811839e-01 -2.491850920919957135e-01 -1.611952468048141462e-01 -5.230372011256861908e-01 -3.331089118119962555e-01 -1.179463569099117454e-01 1.786053517409938174e-01
-2.065629742254090073e-01 -1.740814284902659215e-01 -2.921944032987920381e-01 -2.737823060256667773e-01 -2.283697272004097945e-01 7.872457621175443787e-02 1.917264170035004600e-01 -1.542961451944806495e-01 -9.300847570958789556e-02 1.259146668444173223e-01 -7.887687259823257246e-01 3.339580742762712079e-02
-5.411338204064780610e-01 -2.766852995439734730e-01 6.881721982866524645e-03 -9.226100151041993769e-02 2.449612228154451066e-01 -1.306349378617222279e-01 -4.433783374872372895e-02 -2.069151963759394974e-01 -1.440395925108345354e-01 -1.003137998547053017e-01 2.498570129727753220e-01 -6.379419751682311457e-01
0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00 0.000000000000000000e+00
""" ),
}
