import numpy as np
from ...fmks.func import deprecate

@deprecate
def gsh_basis_info():

    indxvec = np.array([[0, 0, 1],
                        [2, -2, 1],
                        [2, -1, 1],
                        [2, 0, 1],
                        [2, 1, 1],
                        [2, 2, 1],
                        [4, -4, 1],
                        [4, -3, 1],
                        [4, -2, 1],
                        [4, -1, 1],
                        [4, 0, 1],
                        [4, 1, 1],
                        [4, 2, 1],
                        [4, 3, 1],
                        [4, 4, 1],
                        [6, -6, 1],
                        [6, -6, 2],
                        [6, -5, 1],
                        [6, -5, 2],
                        [6, -4, 1],
                        [6, -4, 2],
                        [6, -3, 1],
                        [6, -3, 2],
                        [6, -2, 1],
                        [6, -2, 2],
                        [6, -1, 1],
                        [6, -1, 2],
                        [6, 0, 1],
                        [6, 0, 2],
                        [6, 1, 1],
                        [6, 1, 2],
                        [6, 2, 1],
                        [6, 2, 2],
                        [6, 3, 1],
                        [6, 3, 2],
                        [6, 4, 1],
                        [6, 4, 2],
                        [6, 5, 1],
                        [6, 5, 2],
                        [6, 6, 1],
                        [6, 6, 2],
                        [7, -7, 1],
                        [7, -6, 1],
                        [7, -5, 1],
                        [7, -4, 1],
                        [7, -3, 1],
                        [7, -2, 1],
                        [7, -1, 1],
                        [7, 0, 1],
                        [7, 1, 1],
                        [7, 2, 1],
                        [7, 3, 1],
                        [7, 4, 1],
                        [7, 5, 1],
                        [7, 6, 1],
                        [7, 7, 1],
                        [8, -8, 1],
                        [8, -8, 2],
                        [8, -7, 1],
                        [8, -7, 2],
                        [8, -6, 1],
                        [8, -6, 2],
                        [8, -5, 1],
                        [8, -5, 2],
                        [8, -4, 1],
                        [8, -4, 2],
                        [8, -3, 1],
                        [8, -3, 2],
                        [8, -2, 1],
                        [8, -2, 2],
                        [8, -1, 1],
                        [8, -1, 2],
                        [8, 0, 1],
                        [8, 0, 2],
                        [8, 1, 1],
                        [8, 1, 2],
                        [8, 2, 1],
                        [8, 2, 2],
                        [8, 3, 1],
                        [8, 3, 2],
                        [8, 4, 1],
                        [8, 4, 2],
                        [8, 5, 1],
                        [8, 5, 2],
                        [8, 6, 1],
                        [8, 6, 2],
                        [8, 7, 1],
                        [8, 7, 2],
                        [8, 8, 1],
                        [8, 8, 2],
                        [9, -9, 1],
                        [9, -8, 1],
                        [9, -7, 1],
                        [9, -6, 1],
                        [9, -5, 1],
                        [9, -4, 1],
                        [9, -3, 1],
                        [9, -2, 1],
                        [9, -1, 1],
                        [9, 0, 1],
                        [9, 1, 1],
                        [9, 2, 1],
                        [9, 3, 1],
                        [9, 4, 1],
                        [9, 5, 1],
                        [9, 6, 1],
                        [9, 7, 1],
                        [9, 8, 1],
                        [9, 9, 1],
                        [10, -10, 1],
                        [10, -10, 2],
                        [10, -9, 1],
                        [10, -9, 2],
                        [10, -8, 1],
                        [10, -8, 2],
                        [10, -7, 1],
                        [10, -7, 2],
                        [10, -6, 1],
                        [10, -6, 2],
                        [10, -5, 1],
                        [10, -5, 2],
                        [10, -4, 1],
                        [10, -4, 2],
                        [10, -3, 1],
                        [10, -3, 2],
                        [10, -2, 1],
                        [10, -2, 2],
                        [10, -1, 1],
                        [10, -1, 2],
                        [10, 0, 1],
                        [10, 0, 2],
                        [10, 1, 1],
                        [10, 1, 2],
                        [10, 2, 1],
                        [10, 2, 2],
                        [10, 3, 1],
                        [10, 3, 2],
                        [10, 4, 1],
                        [10, 4, 2],
                        [10, 5, 1],
                        [10, 5, 2],
                        [10, 6, 1],
                        [10, 6, 2],
                        [10, 7, 1],
                        [10, 7, 2],
                        [10, 8, 1],
                        [10, 8, 2],
                        [10, 9, 1],
                        [10, 9, 2],
                        [10, 10, 1],
                        [10, 10, 2],
                        [11, -11, 1],
                        [11, -10, 1],
                        [11, -9, 1],
                        [11, -8, 1],
                        [11, -7, 1],
                        [11, -6, 1],
                        [11, -5, 1],
                        [11, -4, 1],
                        [11, -3, 1],
                        [11, -2, 1],
                        [11, -1, 1],
                        [11, 0, 1],
                        [11, 1, 1],
                        [11, 2, 1],
                        [11, 3, 1],
                        [11, 4, 1],
                        [11, 5, 1],
                        [11, 6, 1],
                        [11, 7, 1],
                        [11, 8, 1],
                        [11, 9, 1],
                        [11, 10, 1],
                        [11, 11, 1],
                        [12, -12, 1],
                        [12, -12, 2],
                        [12, -12, 3],
                        [12, -11, 1],
                        [12, -11, 2],
                        [12, -11, 3],
                        [12, -10, 1],
                        [12, -10, 2],
                        [12, -10, 3],
                        [12, -9, 1],
                        [12, -9, 2],
                        [12, -9, 3],
                        [12, -8, 1],
                        [12, -8, 2],
                        [12, -8, 3],
                        [12, -7, 1],
                        [12, -7, 2],
                        [12, -7, 3],
                        [12, -6, 1],
                        [12, -6, 2],
                        [12, -6, 3],
                        [12, -5, 1],
                        [12, -5, 2],
                        [12, -5, 3],
                        [12, -4, 1],
                        [12, -4, 2],
                        [12, -4, 3],
                        [12, -3, 1],
                        [12, -3, 2],
                        [12, -3, 3],
                        [12, -2, 1],
                        [12, -2, 2],
                        [12, -2, 3],
                        [12, -1, 1],
                        [12, -1, 2],
                        [12, -1, 3],
                        [12, 0, 1],
                        [12, 0, 2],
                        [12, 0, 3],
                        [12, 1, 1],
                        [12, 1, 2],
                        [12, 1, 3],
                        [12, 2, 1],
                        [12, 2, 2],
                        [12, 2, 3],
                        [12, 3, 1],
                        [12, 3, 2],
                        [12, 3, 3],
                        [12, 4, 1],
                        [12, 4, 2],
                        [12, 4, 3],
                        [12, 5, 1],
                        [12, 5, 2],
                        [12, 5, 3],
                        [12, 6, 1],
                        [12, 6, 2],
                        [12, 6, 3],
                        [12, 7, 1],
                        [12, 7, 2],
                        [12, 7, 3],
                        [12, 8, 1],
                        [12, 8, 2],
                        [12, 8, 3],
                        [12, 9, 1],
                        [12, 9, 2],
                        [12, 9, 3],
                        [12, 10, 1],
                        [12, 10, 2],
                        [12, 10, 3],
                        [12, 11, 1],
                        [12, 11, 2],
                        [12, 11, 3],
                        [12, 12, 1],
                        [12, 12, 2],
                        [12, 12, 3],
                        [13, -13, 1],
                        [13, -13, 2],
                        [13, -12, 1],
                        [13, -12, 2],
                        [13, -11, 1],
                        [13, -11, 2],
                        [13, -10, 1],
                        [13, -10, 2],
                        [13, -9, 1],
                        [13, -9, 2],
                        [13, -8, 1],
                        [13, -8, 2],
                        [13, -7, 1],
                        [13, -7, 2],
                        [13, -6, 1],
                        [13, -6, 2],
                        [13, -5, 1],
                        [13, -5, 2],
                        [13, -4, 1],
                        [13, -4, 2],
                        [13, -3, 1],
                        [13, -3, 2],
                        [13, -2, 1],
                        [13, -2, 2],
                        [13, -1, 1],
                        [13, -1, 2],
                        [13, 0, 1],
                        [13, 0, 2],
                        [13, 1, 1],
                        [13, 1, 2],
                        [13, 2, 1],
                        [13, 2, 2],
                        [13, 3, 1],
                        [13, 3, 2],
                        [13, 4, 1],
                        [13, 4, 2],
                        [13, 5, 1],
                        [13, 5, 2],
                        [13, 6, 1],
                        [13, 6, 2],
                        [13, 7, 1],
                        [13, 7, 2],
                        [13, 8, 1],
                        [13, 8, 2],
                        [13, 9, 1],
                        [13, 9, 2],
                        [13, 10, 1],
                        [13, 10, 2],
                        [13, 11, 1],
                        [13, 11, 2],
                        [13, 12, 1],
                        [13, 12, 2],
                        [13, 13, 1],
                        [13, 13, 2],
                        [14, -14, 1],
                        [14, -14, 2],
                        [14, -14, 3],
                        [14, -13, 1],
                        [14, -13, 2],
                        [14, -13, 3],
                        [14, -12, 1],
                        [14, -12, 2],
                        [14, -12, 3],
                        [14, -11, 1],
                        [14, -11, 2],
                        [14, -11, 3],
                        [14, -10, 1],
                        [14, -10, 2],
                        [14, -10, 3],
                        [14, -9, 1],
                        [14, -9, 2],
                        [14, -9, 3],
                        [14, -8, 1],
                        [14, -8, 2],
                        [14, -8, 3],
                        [14, -7, 1],
                        [14, -7, 2],
                        [14, -7, 3],
                        [14, -6, 1],
                        [14, -6, 2],
                        [14, -6, 3],
                        [14, -5, 1],
                        [14, -5, 2],
                        [14, -5, 3],
                        [14, -4, 1],
                        [14, -4, 2],
                        [14, -4, 3],
                        [14, -3, 1],
                        [14, -3, 2],
                        [14, -3, 3],
                        [14, -2, 1],
                        [14, -2, 2],
                        [14, -2, 3],
                        [14, -1, 1],
                        [14, -1, 2],
                        [14, -1, 3],
                        [14, 0, 1],
                        [14, 0, 2],
                        [14, 0, 3],
                        [14, 1, 1],
                        [14, 1, 2],
                        [14, 1, 3],
                        [14, 2, 1],
                        [14, 2, 2],
                        [14, 2, 3],
                        [14, 3, 1],
                        [14, 3, 2],
                        [14, 3, 3],
                        [14, 4, 1],
                        [14, 4, 2],
                        [14, 4, 3],
                        [14, 5, 1],
                        [14, 5, 2],
                        [14, 5, 3],
                        [14, 6, 1],
                        [14, 6, 2],
                        [14, 6, 3],
                        [14, 7, 1],
                        [14, 7, 2],
                        [14, 7, 3],
                        [14, 8, 1],
                        [14, 8, 2],
                        [14, 8, 3],
                        [14, 9, 1],
                        [14, 9, 2],
                        [14, 9, 3],
                        [14, 10, 1],
                        [14, 10, 2],
                        [14, 10, 3],
                        [14, 11, 1],
                        [14, 11, 2],
                        [14, 11, 3],
                        [14, 12, 1],
                        [14, 12, 2],
                        [14, 12, 3],
                        [14, 13, 1],
                        [14, 13, 2],
                        [14, 13, 3],
                        [14, 14, 1],
                        [14, 14, 2],
                        [14, 14, 3],
                        [15, -15, 1],
                        [15, -15, 2],
                        [15, -14, 1],
                        [15, -14, 2],
                        [15, -13, 1],
                        [15, -13, 2],
                        [15, -12, 1],
                        [15, -12, 2],
                        [15, -11, 1],
                        [15, -11, 2],
                        [15, -10, 1],
                        [15, -10, 2],
                        [15, -9, 1],
                        [15, -9, 2],
                        [15, -8, 1],
                        [15, -8, 2],
                        [15, -7, 1],
                        [15, -7, 2],
                        [15, -6, 1],
                        [15, -6, 2],
                        [15, -5, 1],
                        [15, -5, 2],
                        [15, -4, 1],
                        [15, -4, 2],
                        [15, -3, 1],
                        [15, -3, 2],
                        [15, -2, 1],
                        [15, -2, 2],
                        [15, -1, 1],
                        [15, -1, 2],
                        [15, 0, 1],
                        [15, 0, 2],
                        [15, 1, 1],
                        [15, 1, 2],
                        [15, 2, 1],
                        [15, 2, 2],
                        [15, 3, 1],
                        [15, 3, 2],
                        [15, 4, 1],
                        [15, 4, 2],
                        [15, 5, 1],
                        [15, 5, 2],
                        [15, 6, 1],
                        [15, 6, 2],
                        [15, 7, 1],
                        [15, 7, 2],
                        [15, 8, 1],
                        [15, 8, 2],
                        [15, 9, 1],
                        [15, 9, 2],
                        [15, 10, 1],
                        [15, 10, 2],
                        [15, 11, 1],
                        [15, 11, 2],
                        [15, 12, 1],
                        [15, 12, 2],
                        [15, 13, 1],
                        [15, 13, 2],
                        [15, 14, 1],
                        [15, 14, 2],
                        [15, 15, 1],
                        [15, 15, 2],
                        [16, -16, 1],
                        [16, -16, 2],
                        [16, -16, 3],
                        [16, -15, 1],
                        [16, -15, 2],
                        [16, -15, 3],
                        [16, -14, 1],
                        [16, -14, 2],
                        [16, -14, 3],
                        [16, -13, 1],
                        [16, -13, 2],
                        [16, -13, 3],
                        [16, -12, 1],
                        [16, -12, 2],
                        [16, -12, 3],
                        [16, -11, 1],
                        [16, -11, 2],
                        [16, -11, 3],
                        [16, -10, 1],
                        [16, -10, 2],
                        [16, -10, 3],
                        [16, -9, 1],
                        [16, -9, 2],
                        [16, -9, 3],
                        [16, -8, 1],
                        [16, -8, 2],
                        [16, -8, 3],
                        [16, -7, 1],
                        [16, -7, 2],
                        [16, -7, 3],
                        [16, -6, 1],
                        [16, -6, 2],
                        [16, -6, 3],
                        [16, -5, 1],
                        [16, -5, 2],
                        [16, -5, 3],
                        [16, -4, 1],
                        [16, -4, 2],
                        [16, -4, 3],
                        [16, -3, 1],
                        [16, -3, 2],
                        [16, -3, 3],
                        [16, -2, 1],
                        [16, -2, 2],
                        [16, -2, 3],
                        [16, -1, 1],
                        [16, -1, 2],
                        [16, -1, 3],
                        [16, 0, 1],
                        [16, 0, 2],
                        [16, 0, 3],
                        [16, 1, 1],
                        [16, 1, 2],
                        [16, 1, 3],
                        [16, 2, 1],
                        [16, 2, 2],
                        [16, 2, 3],
                        [16, 3, 1],
                        [16, 3, 2],
                        [16, 3, 3],
                        [16, 4, 1],
                        [16, 4, 2],
                        [16, 4, 3],
                        [16, 5, 1],
                        [16, 5, 2],
                        [16, 5, 3],
                        [16, 6, 1],
                        [16, 6, 2],
                        [16, 6, 3],
                        [16, 7, 1],
                        [16, 7, 2],
                        [16, 7, 3],
                        [16, 8, 1],
                        [16, 8, 2],
                        [16, 8, 3],
                        [16, 9, 1],
                        [16, 9, 2],
                        [16, 9, 3],
                        [16, 10, 1],
                        [16, 10, 2],
                        [16, 10, 3],
                        [16, 11, 1],
                        [16, 11, 2],
                        [16, 11, 3],
                        [16, 12, 1],
                        [16, 12, 2],
                        [16, 12, 3],
                        [16, 13, 1],
                        [16, 13, 2],
                        [16, 13, 3],
                        [16, 14, 1],
                        [16, 14, 2],
                        [16, 14, 3],
                        [16, 15, 1],
                        [16, 15, 2],
                        [16, 15, 3],
                        [16, 16, 1],
                        [16, 16, 2],
                        [16, 16, 3]])

    return indxvec


def gsh_eval(X, Bvec):

    phi1 = X[..., 0]
    phi = X[..., 1]
    phi2 = X[..., 2]

    zvec = np.abs(phi) < 1e-8
    zvec = zvec.astype(int)
    randvec = np.round(np.random.rand(zvec.size)).reshape(zvec.shape)
    randvecopp = np.ones(zvec.shape) - randvec
    phi += (1e-7)*zvec*(randvec - randvecopp)

    final_shape = np.hstack([phi1.shape, len(Bvec)])
    tfunc = np.zeros(final_shape, dtype='complex128')

    c = 0
    for Bindx in Bvec:

        if Bindx == 0:
            tfunc[..., c] = 1

        if Bindx == 1:
            t913 = np.sin(phi)
            tfunc[..., c] = -(0.5e1 / 0.4e1) * np.exp((-2*1j) * phi1) * np.sqrt(0.6e1) * t913 ** 2

        if Bindx == 2:
            t914 = np.cos(phi)
            tfunc[..., c] = (-0.5e1 / 0.2e1*1j) * np.exp((-1*1j) * phi1) * np.sqrt(0.6e1) * np.sqrt((1 + t914)) * t914 * np.sqrt((1 - t914))

        if Bindx == 3:
            t915 = np.cos(phi)
            tfunc[..., c] = 0.15e2 / 0.2e1 * t915 ** 2 - 0.5e1 / 0.2e1

        if Bindx == 4:
            t916 = np.cos(phi)
            tfunc[..., c] = (-0.5e1 / 0.2e1*1j) * np.exp((1j) * phi1) * np.sqrt(0.6e1) * np.sqrt((1 - t916)) * np.sqrt((1 + t916)) * t916

        if Bindx == 5:
            t917 = np.sin(phi)
            tfunc[..., c] = -(0.5e1 / 0.4e1) * np.exp((2*1j) * phi1) * np.sqrt(0.6e1) * t917 ** 2

        if Bindx == 6:
            t920 = np.sin(phi)
            t918 = t920 ** 2
            tfunc[..., c] = (0.9e1 / 0.16e2) * np.exp((-4*1j) * phi1) * np.sqrt(0.70e2) * t918 ** 2

        if Bindx == 7:
            t921 = np.cos(phi)
            tfunc[..., c] = (0.9e1 / 0.4e1*1j) * t921 * (1 + (-2 + t921) * t921) * ((1 + t921) ** (0.3e1 / 0.2e1)) * np.sqrt(0.35e2) * np.exp((-3*1j) * phi1) * ((1 - t921) ** (-0.1e1 / 0.2e1))

        if Bindx == 8:
            t923 = np.cos(phi)
            t922 = np.sin(phi)
            tfunc[..., c] = -(0.9e1 / 0.8e1) * np.exp((-2*1j) * phi1) * np.sqrt(0.10e2) * t922 ** 2 * (7 * t923 ** 2 - 1)

        if Bindx == 9:
            t924 = np.cos(phi)
            tfunc[..., c] = (-0.9e1 / 0.4e1*1j) * np.exp((-1*1j) * phi1) * np.sqrt(0.5e1) * t924 * np.sqrt((1 + t924)) * np.sqrt((1 - t924)) * (7 * t924 ** 2 - 3)

        if Bindx == 10:
            t929 = np.cos(phi)
            t930 = t929 ** 2
            tfunc[..., c] = 0.27e2 / 0.8e1 + (-0.135e3 / 0.4e1 + 0.315e3 / 0.8e1 * t930) * t930

        if Bindx == 11:
            t932 = np.cos(phi)
            tfunc[..., c] = (-0.9e1 / 0.4e1*1j) * np.exp((1j) * phi1) * np.sqrt(0.5e1) * np.sqrt((1 - t932)) * np.sqrt((1 + t932)) * t932 * (7 * t932 ** 2 - 3)

        if Bindx == 12:
            t934 = np.cos(phi)
            t933 = np.sin(phi)
            tfunc[..., c] = -(0.9e1 / 0.8e1) * np.exp((2*1j) * phi1) * np.sqrt(0.10e2) * t933 ** 2 * (7 * t934 ** 2 - 1)

        if Bindx == 13:
            t935 = np.cos(phi)
            tfunc[..., c] = (0.9e1 / 0.4e1*1j) * np.exp((3*1j) * phi1) * np.sqrt(0.35e2) * ((1 - t935) ** (0.3e1 / 0.2e1)) * ((1 + t935) ** (0.3e1 / 0.2e1)) * t935

        if Bindx == 14:
            t938 = np.sin(phi)
            t936 = t938 ** 2
            tfunc[..., c] = (0.9e1 / 0.16e2) * np.exp((4*1j) * phi1) * np.sqrt(0.70e2) * t936 ** 2

        if Bindx == 15:
            t942 = np.sin(phi)
            t939 = t942 ** 2
            t940 = t942 * t939
            tfunc[..., c] = -(0.13e2 / 0.32e2) * np.exp((-6*1j) * phi1) * np.sqrt(0.231e3) * t940 ** 2

        if Bindx == 16:
            t950 = np.cos(phi)
            t957 = -6 * t950
            t949 = t950 ** 2
            t951 = t950 * t949
            t952 = t949 ** 2
            t956 = t952 * t957 - 20 * t951 + t957
            t955 = t951 ** 2 + 15 * t949 + 15 * t952 + 1
            tfunc[..., c] = (0.13e2 / 0.128e3) * np.sqrt(0.2e1) * ((t955 + t956) * np.exp((-6*1j) * (phi1 - phi2)) + (t955 - t956) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 17:
            t958 = np.cos(phi)
            t959 = t958 ** 2
            tfunc[..., c] = (0.39e2 / 0.16e2*1j) * t958 * (-3 * t959 - 1 + (t959 + 3) * t958) * ((1 + t958) ** (0.5e1 / 0.2e1)) * np.sqrt(0.77e2) * np.exp((-5*1j) * phi1) * ((1 - t958) ** (-0.1e1 / 0.2e1))

        if Bindx == 18:
            t967 = np.cos(phi)
            t966 = t967 ** 2
            t970 = t966 ** 2
            t973 = -1 - 10 * t966 - 5 * t970
            t972 = (10 * t966 + t970 + 5) * t967
            t968 = 5 * phi1
            tfunc[..., c] = (-0.13e2 / 0.64e2*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt((1 - t967)) * np.sqrt((1 + t967)) * ((t972 + t973) * np.exp((-1*1j) * (t968 - 6 * phi2)) + (t972 - t973) * np.exp((-1*1j) * (t968 + 6 * phi2)))

        if Bindx == 19:
            t977 = np.sin(phi)
            t975 = t977 ** 2
            t974 = np.cos(phi)
            tfunc[..., c] = (0.39e2 / 0.32e2) * np.exp((-4*1j) * phi1) * np.sqrt(0.14e2) * t975 ** 2 * (11 * t974 ** 2 - 1)

        if Bindx == 20:
            t984 = np.cos(phi)
            t983 = t984 ** 2
            t986 = t983 ** 2
            t987 = t984 * t986
            t990 = 4 * t984 - 4 * t987
            t989 = t984 * t987 - 5 * t983 + 5 * t986 - 1
            t985 = 2 * phi1
            tfunc[..., c] = (0.13e2 / 0.64e2) * ((t989 + t990) * np.exp((-2*1j) * (t985 - 3 * phi2)) + (t989 - t990) * np.exp((-2*1j) * (t985 + 3 * phi2))) * np.sqrt(0.33e2)

        if Bindx == 21:
            t991 = np.cos(phi)
            tfunc[..., c] = (0.13e2 / 0.16e2*1j) * (11 * t991 ** 2 - 3) * t991 * ((1 + t991) ** (0.3e1 / 0.2e1)) * np.sqrt(0.105e3) * np.exp((-3*1j) * phi1) * ((1 - t991) ** (0.3e1 / 0.2e1))

        if Bindx == 22:
            t998 = np.cos(phi)
            t997 = t998 ** 2
            t1004 = 2 * t997
            t1000 = t997 ** 2
            t1003 = 1 - 3 * t1000 + t1004
            t1002 = (t1000 + t1004 - 3) * t998
            tfunc[..., c] = (-0.13e2 / 0.64e2*1j) * np.sqrt(0.55e2) * np.sqrt(0.2e1) * np.sqrt((1 - t998)) * np.sqrt((1 + t998)) * ((t1002 + t1003) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t1002 - t1003) * np.exp((-3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 23:
            t1006 = np.cos(phi)
            t1007 = t1006 ** 2
            t1005 = np.sin(phi)
            tfunc[..., c] = -(0.13e2 / 0.32e2) * np.exp((-2*1j) * phi1) * np.sqrt(0.105e3) * t1005 ** 2 * (1 + (-18 + 33 * t1007) * t1007)

        if Bindx == 24:
            t1016 = np.cos(phi)
            t1015 = t1016 ** 2
            t1017 = t1016 * t1015
            t1018 = t1015 ** 2
            t1022 = -2 * t1016 * t1018 - 2 * t1016 + 4 * t1017
            t1021 = t1017 ** 2 - t1015 - t1018 + 1
            tfunc[..., c] = (0.39e2 / 0.128e3) * np.sqrt(0.55e2) * np.sqrt(0.2e1) * ((t1021 + t1022) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t1021 - t1022) * np.exp((-2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 25:
            t1023 = np.cos(phi)
            t1024 = t1023 ** 2
            tfunc[..., c] = (-0.13e2 / 0.16e2*1j) * np.exp((-1*1j) * phi1) * np.sqrt(0.42e2) * np.sqrt((1 + t1023)) * t1023 * np.sqrt((1 - t1023)) * (5 + (-30 + 33 * t1024) * t1024)

        if Bindx == 26:
            t1036 = np.cos(phi)
            t1035 = t1036 ** 2
            t1042 = 1 + (-2 + t1035) * t1035
            t1040 = t1042 * t1036
            tfunc[..., c] = (-0.39e2 / 0.32e2*1j) * np.sqrt(0.11e2) * np.sqrt((1 - t1036)) * np.sqrt((1 + t1036)) * ((t1040 - t1042) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (t1040 + t1042) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 27:
            t1043 = np.cos(phi)
            t1044 = t1043 ** 2
            t1045 = t1044 ** 2
            tfunc[..., c] = -0.4095e4 / 0.16e2 * t1045 - 0.65e2 / 0.16e2 + (0.3003e4 / 0.16e2 * t1045 + 0.1365e4 / 0.16e2) * t1044

        if Bindx == 28:
            t1047 = np.cos(phi)
            t1048 = t1047 ** 2
            t1049 = t1048 ** 2
            tfunc[..., c] = 0.13e2 / 0.32e2 * np.sqrt(0.231e3) * np.sqrt(0.2e1) * np.cos((6 * phi2)) * (-3 * t1049 - 1 + (t1049 + 3) * t1048)

        if Bindx == 29:
            t1051 = np.cos(phi)
            t1052 = t1051 ** 2
            tfunc[..., c] = (-0.13e2 / 0.16e2*1j) * np.exp((1j) * phi1) * np.sqrt(0.42e2) * np.sqrt((1 - t1051)) * np.sqrt((1 + t1051)) * t1051 * (5 + (-30 + 33 * t1052) * t1052)

        if Bindx == 30:
            t1060 = np.cos(phi)
            t1059 = t1060 ** 2
            t1066 = 1 + (-2 + t1059) * t1059
            t1064 = t1066 * t1060
            tfunc[..., c] = (-0.39e2 / 0.32e2*1j) * np.sqrt(0.11e2) * np.sqrt((1 - t1060)) * np.sqrt((1 + t1060)) * ((t1064 - t1066) * np.exp((1j) * (phi1 - 6 * phi2)) + (t1064 + t1066) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 31:
            t1068 = np.cos(phi)
            t1069 = t1068 ** 2
            t1067 = np.sin(phi)
            tfunc[..., c] = -(0.13e2 / 0.32e2) * np.exp((2*1j) * phi1) * np.sqrt(0.105e3) * t1067 ** 2 * (1 + (-18 + 33 * t1069) * t1069)

        if Bindx == 32:
            t1078 = np.cos(phi)
            t1077 = t1078 ** 2
            t1079 = t1078 * t1077
            t1080 = t1077 ** 2
            t1084 = -2 * t1078 * t1080 - 2 * t1078 + 4 * t1079
            t1083 = t1079 ** 2 - t1077 - t1080 + 1
            tfunc[..., c] = (0.39e2 / 0.128e3) * np.sqrt(0.55e2) * np.sqrt(0.2e1) * ((t1083 + t1084) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t1083 - t1084) * np.exp((2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 33:
            t1085 = np.cos(phi)
            tfunc[..., c] = (0.13e2 / 0.16e2*1j) * np.exp((3*1j) * phi1) * np.sqrt(0.105e3) * ((1 - t1085) ** (0.3e1 / 0.2e1)) * ((1 + t1085) ** (0.3e1 / 0.2e1)) * t1085 * (11 * t1085 ** 2 - 3)

        if Bindx == 34:
            t1092 = np.cos(phi)
            t1091 = t1092 ** 2
            t1098 = 2 * t1091
            t1094 = t1091 ** 2
            t1097 = 1 + t1098 - 3 * t1094
            t1096 = (t1094 + t1098 - 3) * t1092
            tfunc[..., c] = (-0.13e2 / 0.64e2*1j) * np.sqrt(0.55e2) * np.sqrt(0.2e1) * np.sqrt((1 - t1092)) * np.sqrt((1 + t1092)) * ((t1096 + t1097) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t1096 - t1097) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 35:
            t1102 = np.sin(phi)
            t1100 = t1102 ** 2
            t1099 = np.cos(phi)
            tfunc[..., c] = (0.39e2 / 0.32e2) * np.exp((4*1j) * phi1) * np.sqrt(0.14e2) * t1100 ** 2 * (11 * t1099 ** 2 - 1)

        if Bindx == 36:
            t1109 = np.cos(phi)
            t1108 = t1109 ** 2
            t1111 = t1108 ** 2
            t1112 = t1109 * t1111
            t1115 = 4 * t1109 - 4 * t1112
            t1114 = t1109 * t1112 - 5 * t1108 + 5 * t1111 - 1
            t1110 = 2 * phi1
            tfunc[..., c] = (0.13e2 / 0.64e2) * ((t1114 + t1115) * np.exp((2*1j) * (t1110 - 3 * phi2)) + (t1114 - t1115) * np.exp((2*1j) * (t1110 + 3 * phi2))) * np.sqrt(0.33e2)

        if Bindx == 37:
            t1116 = np.cos(phi)
            tfunc[..., c] = (-0.39e2 / 0.16e2*1j) * np.exp((5*1j) * phi1) * np.sqrt(0.77e2) * ((1 - t1116) ** (0.5e1 / 0.2e1)) * ((1 + t1116) ** (0.5e1 / 0.2e1)) * t1116

        if Bindx == 38:
            t1123 = np.cos(phi)
            t1122 = t1123 ** 2
            t1126 = t1122 ** 2
            t1129 = -1 - 10 * t1122 - 5 * t1126
            t1128 = (10 * t1122 + t1126 + 5) * t1123
            t1124 = 5 * phi1
            tfunc[..., c] = (-0.13e2 / 0.64e2*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt((1 - t1123)) * np.sqrt((1 + t1123)) * ((t1128 + t1129) * np.exp((1j) * (t1124 - 6 * phi2)) + (t1128 - t1129) * np.exp((1j) * (t1124 + 6 * phi2)))

        if Bindx == 39:
            t1133 = np.sin(phi)
            t1130 = t1133 ** 2
            t1131 = t1133 * t1130
            tfunc[..., c] = -(0.13e2 / 0.32e2) * np.exp((6*1j) * phi1) * np.sqrt(0.231e3) * t1131 ** 2

        if Bindx == 40:
            t1141 = np.cos(phi)
            t1148 = -6 * t1141
            t1140 = t1141 ** 2
            t1142 = t1141 * t1140
            t1143 = t1140 ** 2
            t1147 = t1143 * t1148 - 20 * t1142 + t1148
            t1146 = t1142 ** 2 + 15 * t1140 + 15 * t1143 + 1
            tfunc[..., c] = (0.13e2 / 0.128e3) * np.sqrt(0.2e1) * ((t1146 + t1147) * np.exp((6*1j) * (phi1 - phi2)) + (t1146 - t1147) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 41:
            t1157 = np.cos(phi)
            t1156 = t1157 ** 2
            t1159 = t1157 * t1156
            t1162 = t1159 ** 2
            t1164 = -t1157 * t1162 + 1
            t1160 = t1156 ** 2
            t1158 = 7 * phi1
            t1153 = t1157 * t1160
            tfunc[..., c] = (-0.15e2 / 0.128e3*1j) * np.sqrt(0.7e1) * np.sqrt((1 + t1157)) * ((7 * t1162 - 21 * t1153 + 35 * t1160 - 35 * t1159 + 21 * t1156 - 7 * t1157 + t1164) * np.exp((-1*1j) * (t1158 - 6 * phi2)) + (5 * t1162 + 9 * t1153 + 5 * t1160 - 5 * t1159 - 9 * t1156 - 5 * t1157 - t1164) * np.exp((-1*1j) * (t1158 + 6 * phi2))) * ((1 - t1157) ** (-0.1e1 / 0.2e1))

        if Bindx == 42:
            t1173 = np.cos(phi)
            t1172 = t1173 ** 2
            t1175 = t1172 ** 2
            t1174 = t1173 * t1172
            t1177 = t1174 ** 2
            t1180 = -6 - 48 * t1172 + 50 * t1175 + 36 * t1177
            t1179 = 15 * t1174 + (-69 * t1175 - 7 * t1177 + 29) * t1173
            tfunc[..., c] = -(0.15e2 / 0.128e3) * np.sqrt(0.2e1) * ((t1179 + t1180) * np.exp((-6*1j) * (phi1 - phi2)) + (-t1179 + t1180) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 43:
            t1190 = np.cos(phi)
            t1189 = t1190 ** 2
            t1192 = t1190 * t1189
            t1193 = t1189 ** 2
            t1195 = t1192 ** 2
            t1199 = 38 * t1192 + (10 * t1193 - 30 * t1195 - 18) * t1190
            t1198 = -10 * t1189 - 38 * t1195 - 5 + (60 - 7 * t1193) * t1193
            t1191 = 5 * phi1
            tfunc[..., c] = (0.15e2 / 0.128e3*1j) * np.sqrt(0.13e2) * ((-t1198 + t1199) * np.exp((-1*1j) * (t1191 - 6 * phi2)) + (t1198 + t1199) * np.exp((-1*1j) * (t1191 + 6 * phi2))) * ((1 + t1190) ** (-0.1e1 / 0.2e1)) * ((1 - t1190) ** (-0.1e1 / 0.2e1))

        if Bindx == 44:
            t1208 = np.cos(phi)
            t1207 = t1208 ** 2
            t1211 = t1207 ** 2
            t1210 = t1208 * t1207
            t1213 = t1210 ** 2
            t1216 = 4 - 8 * t1207 - 20 * t1211 + 24 * t1213
            t1215 = 35 * t1210 + (-19 * t1211 - 7 * t1213 - 9) * t1208
            t1209 = 2 * phi1
            tfunc[..., c] = -(0.15e2 / 0.64e2) * ((t1215 + t1216) * np.exp((-2*1j) * (t1209 - 3 * phi2)) + (-t1215 + t1216) * np.exp((-2*1j) * (t1209 + 3 * phi2))) * np.sqrt(0.13e2)

        if Bindx == 45:
            t1226 = np.cos(phi)
            t1225 = t1226 ** 2
            t1227 = t1226 * t1225
            t1228 = t1225 ** 2
            t1230 = t1227 ** 2
            t1234 = -22 * t1227 + (38 * t1228 - 18 * t1230 + 2) * t1226
            t1233 = -18 * t1225 + 2 * t1230 + 3 + (20 - 7 * t1228) * t1228
            tfunc[..., c] = (0.15e2 / 0.128e3*1j) * np.sqrt(0.143e3) * ((-t1233 + t1234) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t1233 + t1234) * np.exp((-3*1j) * (phi1 + 2 * phi2))) * ((1 + t1226) ** (-0.1e1 / 0.2e1)) * ((1 - t1226) ** (-0.1e1 / 0.2e1))

        if Bindx == 46:
            t1243 = np.cos(phi)
            t1242 = t1243 ** 2
            t1245 = t1242 ** 2
            t1244 = t1243 * t1242
            t1247 = t1244 ** 2
            t1250 = 2 - 16 * t1242 + 26 * t1245 - 12 * t1247
            t1249 = -t1244 + (11 * t1245 - 7 * t1247 - 3) * t1243
            tfunc[..., c] = (0.15e2 / 0.128e3) * np.sqrt(0.143e3) * np.sqrt(0.2e1) * ((-t1249 + t1250) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t1249 + t1250) * np.exp((-2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 47:
            t1260 = np.cos(phi)
            t1259 = t1260 ** 2
            t1261 = t1260 * t1259
            t1262 = t1259 ** 2
            t1264 = t1261 ** 2
            t1268 = 18 * t1261 + 6 * (-3 * t1262 + t1264 - 1) * t1260
            t1267 = 10 * t1259 + 22 * t1264 - 1 + (-24 - 7 * t1262) * t1262
            tfunc[..., c] = (-0.15e2 / 0.128e3*1j) * np.sqrt(0.429e3) * ((t1267 + t1268) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (-t1267 + t1268) * np.exp((-1*1j) * (phi1 + 6 * phi2))) * ((1 + t1260) ** (-0.1e1 / 0.2e1)) * ((1 - t1260) ** (-0.1e1 / 0.2e1))

        if Bindx == 48:
            t1272 = np.sin(phi)
            t1269 = t1272 ** 2
            t1270 = t1272 * t1269
            tfunc[..., c] = (-0.15e2 / 0.32e2*1j) * np.sqrt(0.3003e4) * np.sqrt(0.2e1) * np.cos(phi) * np.sin((6 * phi2)) * t1270 ** 2

        if Bindx == 49:
            t1282 = np.cos(phi)
            t1281 = t1282 ** 2
            t1283 = t1282 * t1281
            t1284 = t1281 ** 2
            t1286 = t1283 ** 2
            t1290 = -18 * t1283 + 6 * (3 * t1284 - t1286 + 1) * t1282
            t1289 = 10 * t1281 + 22 * t1286 - 1 + (-24 - 7 * t1284) * t1284
            tfunc[..., c] = (-0.15e2 / 0.128e3*1j) * np.sqrt(0.429e3) * ((1 + t1282) ** (-0.1e1 / 0.2e1)) * ((1 - t1282) ** (-0.1e1 / 0.2e1)) * ((-t1289 + t1290) * np.exp((1j) * (phi1 - 6 * phi2)) + (t1289 + t1290) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 50:
            t1299 = np.cos(phi)
            t1298 = t1299 ** 2
            t1301 = t1298 ** 2
            t1300 = t1299 * t1298
            t1303 = t1300 ** 2
            t1306 = 2 - 16 * t1298 + 26 * t1301 - 12 * t1303
            t1305 = -t1300 + (11 * t1301 - 7 * t1303 - 3) * t1299
            tfunc[..., c] = -(0.15e2 / 0.128e3) * np.sqrt(0.143e3) * np.sqrt(0.2e1) * ((-t1305 + t1306) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t1305 + t1306) * np.exp((2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 51:
            t1316 = np.cos(phi)
            t1315 = t1316 ** 2
            t1317 = t1316 * t1315
            t1318 = t1315 ** 2
            t1320 = t1317 ** 2
            t1324 = -22 * t1317 + (38 * t1318 - 18 * t1320 + 2) * t1316
            t1323 = -18 * t1315 + 2 * t1320 + 3 + (20 - 7 * t1318) * t1318
            tfunc[..., c] = (-0.15e2 / 0.128e3*1j) * np.sqrt(0.143e3) * ((1 + t1316) ** (-0.1e1 / 0.2e1)) * ((1 - t1316) ** (-0.1e1 / 0.2e1)) * ((-t1323 + t1324) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t1323 + t1324) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 52:
            t1333 = np.cos(phi)
            t1332 = t1333 ** 2
            t1336 = t1332 ** 2
            t1335 = t1333 * t1332
            t1338 = t1335 ** 2
            t1341 = -4 + 8 * t1332 + 20 * t1336 - 24 * t1338
            t1340 = 35 * t1335 + (-19 * t1336 - 7 * t1338 - 9) * t1333
            t1334 = 2 * phi1
            tfunc[..., c] = -(0.15e2 / 0.64e2) * ((-t1340 + t1341) * np.exp((2*1j) * (t1334 - 3 * phi2)) + (t1340 + t1341) * np.exp((2*1j) * (t1334 + 3 * phi2))) * np.sqrt(0.13e2)

        if Bindx == 53:
            t1351 = np.cos(phi)
            t1350 = t1351 ** 2
            t1353 = t1351 * t1350
            t1354 = t1350 ** 2
            t1356 = t1353 ** 2
            t1360 = 38 * t1353 + (10 * t1354 - 30 * t1356 - 18) * t1351
            t1359 = -10 * t1350 - 38 * t1356 - 5 + (60 - 7 * t1354) * t1354
            t1352 = 5 * phi1
            tfunc[..., c] = (-0.15e2 / 0.128e3*1j) * np.sqrt(0.13e2) * ((1 - t1351) ** (-0.1e1 / 0.2e1)) * ((1 + t1351) ** (-0.1e1 / 0.2e1)) * ((-t1359 + t1360) * np.exp((1j) * (t1352 - 6 * phi2)) + (t1359 + t1360) * np.exp((1j) * (t1352 + 6 * phi2)))

        if Bindx == 54:
            t1369 = np.cos(phi)
            t1368 = t1369 ** 2
            t1371 = t1368 ** 2
            t1370 = t1369 * t1368
            t1373 = t1370 ** 2
            t1376 = 6 + 48 * t1368 - 50 * t1371 - 36 * t1373
            t1375 = 15 * t1370 + (-69 * t1371 - 7 * t1373 + 29) * t1369
            tfunc[..., c] = -(0.15e2 / 0.128e3) * np.sqrt(0.2e1) * ((-t1375 + t1376) * np.exp((6*1j) * (phi1 - phi2)) + (t1375 + t1376) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 55:
            t1385 = np.cos(phi)
            t1384 = t1385 ** 2
            t1387 = t1385 * t1384
            t1390 = t1387 ** 2
            t1392 = -t1385 * t1390 - 1
            t1388 = t1384 ** 2
            t1386 = 7 * phi1
            t1381 = t1385 * t1388
            tfunc[..., c] = (0.15e2 / 0.128e3*1j) * np.sqrt(0.7e1) * np.sqrt((1 - t1385)) * ((1 + t1385) ** (-0.1e1 / 0.2e1)) * ((-5 * t1390 + 9 * t1381 - 5 * t1388 - 5 * t1387 + 9 * t1384 - 5 * t1385 - t1392) * np.exp((1j) * (t1386 - 6 * phi2)) + (-7 * t1390 - 21 * t1381 - 35 * t1388 - 35 * t1387 - 21 * t1384 - 7 * t1385 + t1392) * np.exp((1j) * (t1386 + 6 * phi2)))

        if Bindx == 56:
            t1396 = np.sin(phi)
            t1393 = t1396 ** 2
            t1394 = t1393 ** 2
            tfunc[..., c] = (0.51e2 / 0.256e3) * np.exp((-8*1j) * phi1) * np.sqrt(0.1430e4) * t1394 ** 2

        if Bindx == 57:
            t1405 = np.cos(phi)
            t1404 = t1405 ** 2
            t1414 = -14 * t1404
            t1407 = t1405 * t1404
            t1409 = t1407 ** 2
            t1410 = t1405 * t1409
            t1413 = t1405 * t1410 + 14 * t1409 + t1414 - 1
            t1412 = 6 * t1405 - 6 * t1410 + (t1414 + 14) * t1407
            t1406 = 4 * phi1
            tfunc[..., c] = (0.17e2 / 0.128e3) * ((t1412 + t1413) * np.exp((-2*1j) * (t1406 - 3 * phi2)) + (-t1412 + t1413) * np.exp((-2*1j) * (t1406 + 3 * phi2))) * np.sqrt(0.15e2)

        if Bindx == 58:
            t1415 = np.cos(phi)
            t1419 = -4 * t1415
            t1416 = t1415 ** 2
            tfunc[..., c] = (0.51e2 / 0.64e2*1j) * t1415 * (t1419 + 1 + (t1419 + 6 + t1416) * t1416) * ((1 + t1415) ** (0.7e1 / 0.2e1)) * np.sqrt(0.1430e4) * np.exp((-7*1j) * phi1) * ((1 - t1415) ** (-0.1e1 / 0.2e1))

        if Bindx == 59:
            t1429 = np.cos(phi)
            t1428 = t1429 ** 2
            t1432 = t1428 ** 2
            t1438 = 4 * t1432 ** 2
            t1431 = t1429 * t1428
            t1437 = -3 + 21 * t1431 + 35 * t1432
            t1434 = t1431 ** 2
            t1430 = 7 * phi1
            t1425 = t1429 * t1432
            t1423 = t1429 * t1434
            tfunc[..., c] = (0.17e2 / 0.128e3*1j) * np.sqrt((1 + t1429)) * np.sqrt(0.15e2) * ((1 - t1429) ** (-0.1e1 / 0.2e1)) * ((t1438 - 25 * t1423 + 63 * t1434 - 77 * t1425 - 35 * t1428 + 17 * t1429 + t1437) * np.exp((-1*1j) * (t1430 - 6 * phi2)) + (t1438 + 17 * t1423 + 21 * t1434 - 7 * t1425 + 7 * t1428 + 11 * t1429 - t1437) * np.exp((-1*1j) * (t1430 + 6 * phi2)))

        if Bindx == 60:
            t1443 = np.sin(phi)
            t1440 = t1443 ** 2
            t1441 = t1443 * t1440
            t1439 = np.cos(phi)
            tfunc[..., c] = -(0.17e2 / 0.64e2) * np.exp((-6*1j) * phi1) * np.sqrt(0.429e3) * t1441 ** 2 * (15 * t1439 ** 2 - 1)

        if Bindx == 61:
            t1452 = np.cos(phi)
            t1453 = t1452 ** 2
            t1455 = t1453 ** 2
            t1454 = t1452 * t1453
            t1457 = t1454 ** 2
            t1461 = 196 * t1457 + 16 + (-210 + 30 * t1455) * t1455
            t1460 = 175 * t1454 + (-21 * t1455 - 135 * t1457 - 51) * t1452
            tfunc[..., c] = (0.17e2 / 0.128e3) * np.sqrt(0.2e1) * ((t1460 + t1461) * np.exp((-6*1j) * (phi1 - phi2)) + (-t1460 + t1461) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 62:
            t1462 = np.cos(phi)
            tfunc[..., c] = (-0.51e2 / 0.64e2*1j) * (5 * t1462 ** 2 - 1) * t1462 * ((1 + t1462) ** (0.5e1 / 0.2e1)) * np.sqrt(0.2002e4) * np.exp((-5*1j) * phi1) * ((1 - t1462) ** (0.5e1 / 0.2e1))

        if Bindx == 63:
            t1473 = np.cos(phi)
            t1472 = t1473 ** 2
            t1476 = t1472 ** 2
            t1475 = t1473 * t1472
            t1478 = t1475 ** 2
            t1480 = t1476 ** 2
            t1483 = 7 - 42 * t1472 + 20 * t1476 + 90 * t1478 - 75 * t1480
            t1482 = 90 * t1475 + (-162 * t1476 + 62 * t1478 + 20 * t1480 - 10) * t1473
            t1474 = 5 * phi1
            tfunc[..., c] = (0.17e2 / 0.128e3*1j) * np.sqrt(0.21e2) * ((1 + t1473) ** (-0.1e1 / 0.2e1)) * ((1 - t1473) ** (-0.1e1 / 0.2e1)) * ((t1482 + t1483) * np.exp((-1*1j) * (t1474 - 6 * phi2)) + (t1482 - t1483) * np.exp((-1*1j) * (t1474 + 6 * phi2)))

        if Bindx == 64:
            t1489 = np.sin(phi)
            t1487 = t1489 ** 2
            t1484 = np.cos(phi)
            t1485 = t1484 ** 2
            tfunc[..., c] = (0.51e2 / 0.128e3) * np.exp((-4*1j) * phi1) * np.sqrt(0.154e3) * t1487 ** 2 * (1 + (-26 + 65 * t1485) * t1485)

        if Bindx == 65:
            t1499 = np.cos(phi)
            t1498 = t1499 ** 2
            t1501 = t1499 * t1498
            t1502 = t1498 ** 2
            t1504 = t1501 ** 2
            t1508 = -5 * t1501 + (21 * t1502 - 15 * t1504 - 1) * t1499
            t1507 = 10 * t1498 + 6 * t1504 - 1 + (-20 + 5 * t1502) * t1502
            t1500 = 2 * phi1
            tfunc[..., c] = (0.17e2 / 0.64e2) * ((t1507 + t1508) * np.exp((-2*1j) * (t1500 - 3 * phi2)) + (t1507 - t1508) * np.exp((-2*1j) * (t1500 + 3 * phi2))) * np.sqrt(0.273e3)

        if Bindx == 66:
            t1509 = np.cos(phi)
            t1510 = t1509 ** 2
            tfunc[..., c] = (0.17e2 / 0.64e2*1j) * (3 + (-26 + 39 * t1510) * t1510) * t1509 * ((1 + t1509) ** (0.3e1 / 0.2e1)) * np.sqrt(0.2310e4) * np.exp((-3*1j) * phi1) * ((1 - t1509) ** (0.3e1 / 0.2e1))

        if Bindx == 67:
            t1522 = np.cos(phi)
            t1521 = t1522 ** 2
            t1524 = t1521 ** 2
            t1523 = t1522 * t1521
            t1526 = t1523 ** 2
            t1528 = t1524 ** 2
            t1531 = -1 + 14 * t1521 - 52 * t1524 + 66 * t1526 - 27 * t1528
            t1530 = 22 * t1523 - 14 * (t1524 + t1526) * t1522 + (12 * t1528 - 6) * t1522
            tfunc[..., c] = (0.17e2 / 0.128e3*1j) * np.sqrt(0.455e3) * ((1 + t1522) ** (-0.1e1 / 0.2e1)) * ((1 - t1522) ** (-0.1e1 / 0.2e1)) * ((t1530 + t1531) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t1530 - t1531) * np.exp((-3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 68:
            t1534 = np.cos(phi)
            t1535 = t1534 ** 2
            t1536 = t1535 ** 2
            t1533 = np.sin(phi)
            tfunc[..., c] = -(0.51e2 / 0.64e2) * np.exp((-2*1j) * phi1) * np.sqrt(0.35e2) * t1533 ** 2 * (-143 * t1536 - 1 + (143 * t1536 + 33) * t1535)

        if Bindx == 69:
            t1546 = np.cos(phi)
            t1545 = t1546 ** 2
            t1547 = t1546 * t1545
            t1548 = t1545 ** 2
            t1550 = t1547 ** 2
            t1553 = 2 * t1547 + 2 * (-2 * t1548 + t1550) * t1546
            t1552 = 1 - 5 * t1545 + 7 * t1548 - 3 * t1550
            tfunc[..., c] = (0.17e2 / 0.128e3) * np.sqrt(0.15015e5) * t1546 * np.sqrt(0.2e1) * ((t1552 + t1553) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (-t1552 + t1553) * np.exp((-2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 70:
            t1554 = np.cos(phi)
            t1555 = t1554 ** 2
            t1556 = t1554 * t1555
            t1561 = -1001 * t1555 ** 2 + 715 * t1556 ** 2 - 35
            tfunc[..., c] = (0.51e2 / 0.64e2*1j) * np.exp((-1*1j) * phi1) * np.sqrt(0.2e1) * np.sqrt((1 + t1554)) * t1554 * (t1561 * t1554 - 385 * t1555 + 385 * t1556 - t1561) * ((1 - t1554) ** (-0.1e1 / 0.2e1))

        if Bindx == 71:
            t1572 = np.cos(phi)
            t1571 = t1572 ** 2
            t1574 = t1571 ** 2
            t1573 = t1572 * t1571
            t1576 = t1573 ** 2
            t1578 = t1574 ** 2
            t1581 = -1 + 18 * t1571 - 48 * t1574 + 46 * t1576 - 15 * t1578
            t1580 = -38 * t1573 + (78 * t1574 - 66 * t1576 + 20 * t1578 + 6) * t1572
            tfunc[..., c] = (0.17e2 / 0.128e3*1j) * np.sqrt(0.429e3) * ((1 + t1572) ** (-0.1e1 / 0.2e1)) * ((1 - t1572) ** (-0.1e1 / 0.2e1)) * ((t1580 + t1581) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (t1580 - t1581) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 72:
            t1582 = np.cos(phi)
            t1583 = t1582 ** 2
            t1584 = t1583 ** 2
            tfunc[..., c] = -0.5355e4 / 0.32e2 * t1583 + 0.595e3 / 0.128e3 + (-0.51051e5 / 0.32e2 * t1583 + 0.58905e5 / 0.64e2 + 0.109395e6 / 0.128e3 * t1584) * t1584

        if Bindx == 73:
            t1587 = np.cos(phi)
            t1588 = t1587 ** 2
            t1589 = t1588 ** 2
            tfunc[..., c] = 0.17e2 / 0.64e2 * np.sqrt(0.429e3) * np.sqrt(0.2e1) * (-18 * t1588 + 1 + (-46 * t1588 + 48 + 15 * t1589) * t1589) * np.cos((6 * phi2))

        if Bindx == 74:
            t1592 = np.cos(phi)
            t1593 = t1592 ** 2
            t1594 = t1593 ** 2
            tfunc[..., c] = (-0.51e2 / 0.64e2*1j) * np.exp((1j) * phi1) * np.sqrt(0.2e1) * np.sqrt((1 - t1592)) * np.sqrt((1 + t1592)) * t1592 * (-1001 * t1594 - 35 + (715 * t1594 + 385) * t1593)

        if Bindx == 75:
            t1606 = np.cos(phi)
            t1605 = t1606 ** 2
            t1608 = t1605 ** 2
            t1607 = t1606 * t1605
            t1610 = t1607 ** 2
            t1612 = t1608 ** 2
            t1615 = -1 + 18 * t1605 - 48 * t1608 + 46 * t1610 - 15 * t1612
            t1614 = -38 * t1607 + (78 * t1608 - 66 * t1610 + 20 * t1612 + 6) * t1606
            tfunc[..., c] = (0.17e2 / 0.128e3*1j) * np.sqrt(0.429e3) * ((1 + t1606) ** (-0.1e1 / 0.2e1)) * ((1 - t1606) ** (-0.1e1 / 0.2e1)) * ((t1614 + t1615) * np.exp((1j) * (phi1 - 6 * phi2)) + (t1614 - t1615) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 76:
            t1617 = np.cos(phi)
            t1618 = t1617 ** 2
            t1619 = t1618 ** 2
            t1616 = np.sin(phi)
            tfunc[..., c] = -(0.51e2 / 0.64e2) * np.exp((2*1j) * phi1) * np.sqrt(0.35e2) * t1616 ** 2 * (-143 * t1619 - 1 + (143 * t1619 + 33) * t1618)

        if Bindx == 77:
            t1629 = np.cos(phi)
            t1628 = t1629 ** 2
            t1630 = t1629 * t1628
            t1631 = t1628 ** 2
            t1633 = t1630 ** 2
            t1636 = 2 * t1630 + 2 * (-2 * t1631 + t1633) * t1629
            t1635 = 1 - 5 * t1628 + 7 * t1631 - 3 * t1633
            tfunc[..., c] = (0.17e2 / 0.128e3) * np.sqrt(0.15015e5) * t1629 * np.sqrt(0.2e1) * ((t1635 + t1636) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (-t1635 + t1636) * np.exp((2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 78:
            t1637 = np.cos(phi)
            t1638 = t1637 ** 2
            tfunc[..., c] = (0.17e2 / 0.64e2*1j) * np.exp((3*1j) * phi1) * np.sqrt(0.2310e4) * ((1 - t1637) ** (0.3e1 / 0.2e1)) * ((1 + t1637) ** (0.3e1 / 0.2e1)) * t1637 * (3 + (-26 + 39 * t1638) * t1638)

        if Bindx == 79:
            t1650 = np.cos(phi)
            t1649 = t1650 ** 2
            t1652 = t1649 ** 2
            t1651 = t1650 * t1649
            t1654 = t1651 ** 2
            t1656 = t1652 ** 2
            t1659 = -1 + 14 * t1649 - 52 * t1652 + 66 * t1654 - 27 * t1656
            t1658 = 22 * t1651 - 14 * (t1652 + t1654) * t1650 + (12 * t1656 - 6) * t1650
            tfunc[..., c] = (0.17e2 / 0.128e3*1j) * np.sqrt(0.455e3) * ((1 + t1650) ** (-0.1e1 / 0.2e1)) * ((1 - t1650) ** (-0.1e1 / 0.2e1)) * ((t1658 + t1659) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t1658 - t1659) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 80:
            t1666 = np.sin(phi)
            t1664 = t1666 ** 2
            t1661 = np.cos(phi)
            t1662 = t1661 ** 2
            tfunc[..., c] = (0.51e2 / 0.128e3) * np.exp((4*1j) * phi1) * np.sqrt(0.154e3) * t1664 ** 2 * (1 + (-26 + 65 * t1662) * t1662)

        if Bindx == 81:
            t1676 = np.cos(phi)
            t1675 = t1676 ** 2
            t1678 = t1676 * t1675
            t1679 = t1675 ** 2
            t1681 = t1678 ** 2
            t1685 = -5 * t1678 + (21 * t1679 - 15 * t1681 - 1) * t1676
            t1684 = 10 * t1675 + 6 * t1681 - 1 + (-20 + 5 * t1679) * t1679
            t1677 = 2 * phi1
            tfunc[..., c] = (0.17e2 / 0.64e2) * ((t1684 + t1685) * np.exp((2*1j) * (t1677 - 3 * phi2)) + (t1684 - t1685) * np.exp((2*1j) * (t1677 + 3 * phi2))) * np.sqrt(0.273e3)

        if Bindx == 82:
            t1686 = np.cos(phi)
            tfunc[..., c] = (-0.51e2 / 0.64e2*1j) * np.exp((5*1j) * phi1) * np.sqrt(0.2002e4) * ((1 - t1686) ** (0.5e1 / 0.2e1)) * ((1 + t1686) ** (0.5e1 / 0.2e1)) * t1686 * (5 * t1686 ** 2 - 1)

        if Bindx == 83:
            t1697 = np.cos(phi)
            t1696 = t1697 ** 2
            t1700 = t1696 ** 2
            t1699 = t1697 * t1696
            t1702 = t1699 ** 2
            t1704 = t1700 ** 2
            t1707 = 7 - 42 * t1696 + 20 * t1700 + 90 * t1702 - 75 * t1704
            t1706 = 90 * t1699 + (-162 * t1700 + 62 * t1702 + 20 * t1704 - 10) * t1697
            t1698 = 5 * phi1
            tfunc[..., c] = (0.17e2 / 0.128e3*1j) * np.sqrt(0.21e2) * ((1 + t1697) ** (-0.1e1 / 0.2e1)) * ((1 - t1697) ** (-0.1e1 / 0.2e1)) * ((t1706 + t1707) * np.exp((1j) * (t1698 - 6 * phi2)) + (t1706 - t1707) * np.exp((1j) * (t1698 + 6 * phi2)))

        if Bindx == 84:
            t1712 = np.sin(phi)
            t1709 = t1712 ** 2
            t1710 = t1712 * t1709
            t1708 = np.cos(phi)
            tfunc[..., c] = -(0.17e2 / 0.64e2) * np.exp((6*1j) * phi1) * np.sqrt(0.429e3) * t1710 ** 2 * (15 * t1708 ** 2 - 1)

        if Bindx == 85:
            t1721 = np.cos(phi)
            t1722 = t1721 ** 2
            t1724 = t1722 ** 2
            t1723 = t1721 * t1722
            t1726 = t1723 ** 2
            t1730 = 196 * t1726 + 16 + (-210 + 30 * t1724) * t1724
            t1729 = 175 * t1723 + (-21 * t1724 - 135 * t1726 - 51) * t1721
            tfunc[..., c] = (0.17e2 / 0.128e3) * np.sqrt(0.2e1) * ((t1729 + t1730) * np.exp((6*1j) * (phi1 - phi2)) + (-t1729 + t1730) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 86:
            t1731 = np.cos(phi)
            tfunc[..., c] = (0.51e2 / 0.64e2*1j) * np.exp((7*1j) * phi1) * np.sqrt(0.1430e4) * ((1 - t1731) ** (0.7e1 / 0.2e1)) * ((1 + t1731) ** (0.7e1 / 0.2e1)) * t1731

        if Bindx == 87:
            t1741 = np.cos(phi)
            t1740 = t1741 ** 2
            t1744 = t1740 ** 2
            t1750 = 4 * t1744 ** 2
            t1743 = t1741 * t1740
            t1749 = 3 + 21 * t1743 - 35 * t1744
            t1746 = t1743 ** 2
            t1742 = 7 * phi1
            t1737 = t1741 * t1744
            t1735 = t1741 * t1746
            tfunc[..., c] = (-0.17e2 / 0.128e3*1j) * np.sqrt((1 - t1741)) * np.sqrt(0.15e2) * ((1 + t1741) ** (-0.1e1 / 0.2e1)) * ((t1750 - 17 * t1735 + 21 * t1746 + 7 * t1737 + 7 * t1740 - 11 * t1741 + t1749) * np.exp((1j) * (t1742 - 6 * phi2)) + (t1750 + 25 * t1735 + 63 * t1746 + 77 * t1737 - 35 * t1740 - 17 * t1741 - t1749) * np.exp((1j) * (t1742 + 6 * phi2)))

        if Bindx == 88:
            t1754 = np.sin(phi)
            t1751 = t1754 ** 2
            t1752 = t1751 ** 2
            tfunc[..., c] = (0.51e2 / 0.256e3) * np.exp((8*1j) * phi1) * np.sqrt(0.1430e4) * t1752 ** 2

        if Bindx == 89:
            t1763 = np.cos(phi)
            t1762 = t1763 ** 2
            t1772 = -14 * t1762
            t1765 = t1763 * t1762
            t1767 = t1765 ** 2
            t1768 = t1763 * t1767
            t1771 = t1763 * t1768 + 14 * t1767 + t1772 - 1
            t1770 = 6 * t1763 - 6 * t1768 + (t1772 + 14) * t1765
            t1764 = 4 * phi1
            tfunc[..., c] = (0.17e2 / 0.128e3) * ((t1770 + t1771) * np.exp((2*1j) * (t1764 - 3 * phi2)) + (-t1770 + t1771) * np.exp((2*1j) * (t1764 + 3 * phi2))) * np.sqrt(0.15e2)

        if Bindx == 90:
            t1781 = np.cos(phi)
            t1780 = t1781 ** 2
            t1790 = 14 * t1780
            t1783 = t1781 * t1780
            t1785 = t1783 ** 2
            t1786 = t1781 * t1785
            t1789 = -t1781 * t1786 - 14 * t1785 + t1790 + 1
            t1788 = -6 * t1781 + 6 * t1786 + (t1790 - 14) * t1783
            t1782 = 3 * phi1
            tfunc[..., c] = (0.19e2 / 0.256e3*1j) * np.sqrt(0.2e1) * np.sqrt(0.51e2) * np.sqrt((1 - t1781)) * np.sqrt((1 + t1781)) * ((t1788 + t1789) * np.exp((-3*1j) * (t1782 - 2 * phi2)) + (t1788 - t1789) * np.exp((-3*1j) * (t1782 + 2 * phi2)))

        if Bindx == 91:
            t1801 = np.cos(phi)
            t1800 = t1801 ** 2
            t1804 = t1800 ** 2
            t1803 = t1801 * t1800
            t1806 = t1803 ** 2
            t1808 = t1804 ** 2
            t1811 = 2 + 10 * t1800 - 42 * t1804 + 14 * t1806 + 16 * t1808
            t1810 = 14 * t1803 + (28 * t1804 - 30 * t1806 - 3 * t1808 - 9) * t1801
            t1802 = 4 * phi1
            tfunc[..., c] = -(0.19e2 / 0.128e3) * ((t1810 + t1811) * np.exp((-2*1j) * (t1802 - 3 * phi2)) + (-t1810 + t1811) * np.exp((-2*1j) * (t1802 + 3 * phi2))) * np.sqrt(0.51e2)

        if Bindx == 92:
            t1822 = np.cos(phi)
            t1821 = t1822 ** 2
            t1825 = t1821 ** 2
            t1829 = t1825 ** 2
            t1831 = -51 * t1822 * t1829 + 21
            t1824 = t1822 * t1821
            t1827 = t1824 ** 2
            t1823 = 7 * phi1
            t1818 = t1822 * t1825
            t1816 = t1822 * t1827
            tfunc[..., c] = (-0.19e2 / 0.256e3*1j) * np.sqrt(0.2e1) * np.sqrt((1 + t1822)) * np.sqrt(0.3e1) * ((1 - t1822) ** (-0.1e1 / 0.2e1)) * ((289 * t1829 - 616 * t1816 + 504 * t1827 + 154 * t1818 - 574 * t1825 + 336 * t1824 + 16 * t1821 - 79 * t1822 + t1831) * np.exp((-1*1j) * (t1823 - 6 * phi2)) + (187 * t1829 + 140 * t1816 - 252 * t1827 - 406 * t1818 - 14 * t1825 + 252 * t1824 + 100 * t1821 - 37 * t1822 - t1831) * np.exp((-1*1j) * (t1823 + 6 * phi2)))

        if Bindx == 93:
            t1842 = np.cos(phi)
            t1841 = t1842 ** 2
            t1844 = t1841 ** 2
            t1843 = t1842 * t1841
            t1846 = t1843 ** 2
            t1848 = t1844 ** 2
            t1851 = -23 + 207 * t1841 - 273 * t1844 - 287 * t1846 + 408 * t1848
            t1850 = -308 * t1843 + (798 * t1844 - 432 * t1846 - 102 * t1848 + 12) * t1842
            tfunc[..., c] = -(0.19e2 / 0.128e3) * np.sqrt(0.2e1) * ((t1850 + t1851) * np.exp((-6*1j) * (phi1 - phi2)) + (-t1850 + t1851) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 94:
            t1863 = np.cos(phi)
            t1862 = t1863 ** 2
            t1865 = t1863 * t1862
            t1866 = t1862 ** 2
            t1867 = t1863 * t1866
            t1868 = t1865 ** 2
            t1870 = t1866 ** 2
            t1874 = -30 * t1865 - 126 * t1867 + (310 * t1868 - 170 * t1870 + 16) * t1863
            t1873 = -51 * t1867 ** 2 + 75 * t1862 - 280 * t1866 + 336 * t1868 - 75 * t1870 - 5
            t1864 = 5 * phi1
            tfunc[..., c] = (0.19e2 / 0.128e3*1j) * np.sqrt(0.2e1) * np.sqrt(0.15e2) * ((-t1873 + t1874) * np.exp((-1*1j) * (t1864 - 6 * phi2)) + (t1873 + t1874) * np.exp((-1*1j) * (t1864 + 6 * phi2))) * ((1 + t1863) ** (-0.1e1 / 0.2e1)) * ((1 - t1863) ** (-0.1e1 / 0.2e1))

        if Bindx == 95:
            t1885 = np.cos(phi)
            t1884 = t1885 ** 2
            t1888 = t1884 ** 2
            t1887 = t1885 * t1884
            t1890 = t1887 ** 2
            t1892 = t1888 ** 2
            t1895 = 1 - 19 * t1884 + 131 * t1888 - 249 * t1890 + 136 * t1892
            t1894 = -106 * t1887 + (144 * t1888 - 6 * t1890 - 51 * t1892 + 19) * t1885
            t1886 = 2 * phi1
            tfunc[..., c] = -(0.19e2 / 0.64e2) * ((t1894 + t1895) * np.exp((-2*1j) * (t1886 - 3 * phi2)) + (-t1894 + t1895) * np.exp((-2*1j) * (t1886 + 3 * phi2))) * np.sqrt(0.21e2)

        if Bindx == 96:
            t1907 = np.cos(phi)
            t1906 = t1907 ** 2
            t1908 = t1907 * t1906
            t1909 = t1906 ** 2
            t1910 = t1907 * t1909
            t1911 = t1908 ** 2
            t1913 = t1909 ** 2
            t1917 = 98 * t1908 - 262 * t1910 + (278 * t1911 - 102 * t1913 - 12) * t1907
            t1916 = -51 * t1910 ** 2 + 23 * t1906 - 52 * t1909 - 12 * t1911 + 93 * t1913 - 1
            tfunc[..., c] = (0.19e2 / 0.128e3*1j) * np.sqrt(0.91e2) * np.sqrt(0.2e1) * ((-t1916 + t1917) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t1916 + t1917) * np.exp((-3*1j) * (phi1 + 2 * phi2))) * ((1 + t1907) ** (-0.1e1 / 0.2e1)) * ((1 - t1907) ** (-0.1e1 / 0.2e1))

        if Bindx == 97:
            t1928 = np.cos(phi)
            t1927 = t1928 ** 2
            t1930 = t1927 ** 2
            t1929 = t1928 * t1927
            t1932 = t1929 ** 2
            t1934 = t1930 ** 2
            t1937 = -3 + 75 * t1927 - 277 * t1930 + 341 * t1932 - 136 * t1934
            t1936 = 44 * t1929 + (-178 * t1930 + 240 * t1932 - 102 * t1934 - 4) * t1928
            tfunc[..., c] = (0.19e2 / 0.128e3) * np.sqrt(0.2e1) * np.sqrt(0.39e2) * ((-t1936 + t1937) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t1936 + t1937) * np.exp((-2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 98:
            t1949 = np.cos(phi)
            t1948 = t1949 ** 2
            t1950 = t1949 * t1948
            t1951 = t1948 ** 2
            t1952 = t1949 * t1951
            t1953 = t1950 ** 2
            t1955 = t1951 ** 2
            t1959 = -52 * t1950 + 120 * t1952 + (-108 * t1953 + 34 * t1955 + 6) * t1949
            t1958 = -51 * t1952 ** 2 - 27 * t1948 + 126 * t1951 - 226 * t1953 + 177 * t1955 + 1
            tfunc[..., c] = (-0.19e2 / 0.128e3*1j) * np.sqrt(0.429e3) * ((1 + t1949) ** (-0.1e1 / 0.2e1)) * ((1 - t1949) ** (-0.1e1 / 0.2e1)) * ((t1958 + t1959) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (-t1958 + t1959) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 99:
            t1964 = np.sin(phi)
            t1961 = t1964 ** 2
            t1962 = t1964 * t1961
            t1960 = np.cos(phi)
            tfunc[..., c] = (-0.19e2 / 0.64e2*1j) * t1960 * t1962 ** 2 * (17 * t1960 ** 2 - 3) * np.sin((6 * phi2)) * np.sqrt(0.2145e4) * np.sqrt(0.2e1)

        if Bindx == 100:
            t1976 = np.cos(phi)
            t1975 = t1976 ** 2
            t1977 = t1976 * t1975
            t1978 = t1975 ** 2
            t1979 = t1976 * t1978
            t1980 = t1977 ** 2
            t1982 = t1978 ** 2
            t1986 = 52 * t1977 - 120 * t1979 + (108 * t1980 - 34 * t1982 - 6) * t1976
            t1985 = -51 * t1979 ** 2 - 27 * t1975 + 126 * t1978 - 226 * t1980 + 177 * t1982 + 1
            tfunc[..., c] = (-0.19e2 / 0.128e3*1j) * np.sqrt(0.429e3) * ((1 + t1976) ** (-0.1e1 / 0.2e1)) * ((1 - t1976) ** (-0.1e1 / 0.2e1)) * ((-t1985 + t1986) * np.exp((1j) * (phi1 - 6 * phi2)) + (t1985 + t1986) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 101:
            t1997 = np.cos(phi)
            t1996 = t1997 ** 2
            t1999 = t1996 ** 2
            t1998 = t1997 * t1996
            t2001 = t1998 ** 2
            t2003 = t1999 ** 2
            t2006 = -3 + 75 * t1996 - 277 * t1999 + 341 * t2001 - 136 * t2003
            t2005 = 44 * t1998 + (-178 * t1999 + 240 * t2001 - 102 * t2003 - 4) * t1997
            tfunc[..., c] = -(0.19e2 / 0.128e3) * np.sqrt(0.2e1) * np.sqrt(0.39e2) * ((-t2005 + t2006) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t2005 + t2006) * np.exp((2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 102:
            t2018 = np.cos(phi)
            t2017 = t2018 ** 2
            t2019 = t2018 * t2017
            t2020 = t2017 ** 2
            t2021 = t2018 * t2020
            t2022 = t2019 ** 2
            t2024 = t2020 ** 2
            t2028 = 98 * t2019 - 262 * t2021 + (278 * t2022 - 102 * t2024 - 12) * t2018
            t2027 = -51 * t2021 ** 2 + 23 * t2017 - 52 * t2020 - 12 * t2022 + 93 * t2024 - 1
            tfunc[..., c] = (-0.19e2 / 0.128e3*1j) * np.sqrt(0.91e2) * np.sqrt(0.2e1) * ((1 + t2018) ** (-0.1e1 / 0.2e1)) * ((1 - t2018) ** (-0.1e1 / 0.2e1)) * ((-t2027 + t2028) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t2027 + t2028) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 103:
            t2039 = np.cos(phi)
            t2038 = t2039 ** 2
            t2042 = t2038 ** 2
            t2041 = t2039 * t2038
            t2044 = t2041 ** 2
            t2046 = t2042 ** 2
            t2049 = -1 + 19 * t2038 - 131 * t2042 + 249 * t2044 - 136 * t2046
            t2048 = -106 * t2041 + (144 * t2042 - 6 * t2044 - 51 * t2046 + 19) * t2039
            t2040 = 2 * phi1
            tfunc[..., c] = -(0.19e2 / 0.64e2) * ((-t2048 + t2049) * np.exp((2*1j) * (t2040 - 3 * phi2)) + (t2048 + t2049) * np.exp((2*1j) * (t2040 + 3 * phi2))) * np.sqrt(0.21e2)

        if Bindx == 104:
            t2061 = np.cos(phi)
            t2060 = t2061 ** 2
            t2063 = t2061 * t2060
            t2064 = t2060 ** 2
            t2065 = t2061 * t2064
            t2066 = t2063 ** 2
            t2068 = t2064 ** 2
            t2072 = -30 * t2063 - 126 * t2065 + (310 * t2066 - 170 * t2068 + 16) * t2061
            t2071 = -51 * t2065 ** 2 + 75 * t2060 - 280 * t2064 + 336 * t2066 - 75 * t2068 - 5
            t2062 = 5 * phi1
            tfunc[..., c] = (-0.19e2 / 0.128e3*1j) * np.sqrt(0.2e1) * np.sqrt(0.15e2) * ((1 + t2061) ** (-0.1e1 / 0.2e1)) * ((1 - t2061) ** (-0.1e1 / 0.2e1)) * ((-t2071 + t2072) * np.exp((1j) * (t2062 - 6 * phi2)) + (t2071 + t2072) * np.exp((1j) * (t2062 + 6 * phi2)))

        if Bindx == 105:
            t2083 = np.cos(phi)
            t2082 = t2083 ** 2
            t2085 = t2082 ** 2
            t2084 = t2083 * t2082
            t2087 = t2084 ** 2
            t2089 = t2085 ** 2
            t2092 = 23 - 207 * t2082 + 273 * t2085 + 287 * t2087 - 408 * t2089
            t2091 = -308 * t2084 + (798 * t2085 - 432 * t2087 - 102 * t2089 + 12) * t2083
            tfunc[..., c] = -(0.19e2 / 0.128e3) * np.sqrt(0.2e1) * ((-t2091 + t2092) * np.exp((6*1j) * (phi1 - phi2)) + (t2091 + t2092) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 106:
            t2103 = np.cos(phi)
            t2102 = t2103 ** 2
            t2106 = t2102 ** 2
            t2110 = t2106 ** 2
            t2112 = -51 * t2103 * t2110 - 21
            t2105 = t2103 * t2102
            t2108 = t2105 ** 2
            t2104 = 7 * phi1
            t2099 = t2103 * t2106
            t2097 = t2103 * t2108
            tfunc[..., c] = (0.19e2 / 0.256e3*1j) * np.sqrt(0.2e1) * np.sqrt((1 - t2103)) * np.sqrt(0.3e1) * ((1 + t2103) ** (-0.1e1 / 0.2e1)) * ((-187 * t2110 + 140 * t2097 + 252 * t2108 - 406 * t2099 + 14 * t2106 + 252 * t2105 - 100 * t2102 - 37 * t2103 - t2112) * np.exp((1j) * (t2104 - 6 * phi2)) + (-289 * t2110 - 616 * t2097 - 504 * t2108 + 154 * t2099 + 574 * t2106 + 336 * t2105 - 16 * t2102 - 79 * t2103 + t2112) * np.exp((1j) * (t2104 + 6 * phi2)))

        if Bindx == 107:
            t2123 = np.cos(phi)
            t2122 = t2123 ** 2
            t2126 = t2122 ** 2
            t2125 = t2123 * t2122
            t2128 = t2125 ** 2
            t2130 = t2126 ** 2
            t2133 = 2 + 10 * t2122 - 42 * t2126 + 14 * t2128 + 16 * t2130
            t2132 = 14 * t2125 + (28 * t2126 - 30 * t2128 - 3 * t2130 - 9) * t2123
            t2124 = 4 * phi1
            tfunc[..., c] = (0.19e2 / 0.128e3) * ((t2132 + t2133) * np.exp((2*1j) * (t2124 - 3 * phi2)) + (-t2132 + t2133) * np.exp((2*1j) * (t2124 + 3 * phi2))) * np.sqrt(0.51e2)

        if Bindx == 108:
            t2142 = np.cos(phi)
            t2141 = t2142 ** 2
            t2144 = t2142 * t2141
            t2146 = t2144 ** 2
            t2147 = t2142 * t2146
            t2150 = -t2142 * t2147 + 14 * t2141 - 14 * t2146 + 1
            t2149 = 6 * t2142 - 6 * t2147 + (-14 * t2141 + 14) * t2144
            t2143 = 3 * phi1
            tfunc[..., c] = (0.19e2 / 0.256e3*1j) * np.sqrt(0.2e1) * np.sqrt(0.51e2) * np.sqrt((1 - t2142)) * np.sqrt((1 + t2142)) * ((t2149 - t2150) * np.exp((3*1j) * (t2143 - 2 * phi2)) + (t2149 + t2150) * np.exp((3*1j) * (t2143 + 2 * phi2)))

        if Bindx == 109:
            t2155 = np.sin(phi)
            t2151 = t2155 ** 2
            t2153 = t2155 * t2151 ** 2
            tfunc[..., c] = -(0.21e2 / 0.512e3) * np.exp((-10*1j) * phi1) * np.sqrt(0.46189e5) * t2153 ** 2

        if Bindx == 110:
            t2167 = np.cos(phi)
            t2179 = -6 * t2167
            t2166 = t2167 ** 2
            t2169 = t2167 * t2166
            t2170 = t2166 ** 2
            t2171 = t2167 * t2170
            t2172 = t2169 ** 2
            t2174 = t2170 ** 2
            t2178 = -8 * t2167 * t2172 + t2174 * t2179 - 8 * t2169 + 28 * t2171 + t2179
            t2177 = t2171 ** 2 + 13 * t2166 - 14 * t2170 - 14 * t2172 + 13 * t2174 + 1
            t2168 = 5 * phi1
            tfunc[..., c] = (0.21e2 / 0.2048e4) * np.sqrt(0.2e1) * np.sqrt(0.4845e4) * ((t2177 + t2178) * np.exp((-2*1j) * (t2168 - 3 * phi2)) + (t2177 - t2178) * np.exp((-2*1j) * (t2168 + 3 * phi2)))

        if Bindx == 111:
            t2180 = np.cos(phi)
            t2181 = t2180 ** 2
            t2183 = t2181 ** 2
            tfunc[..., c] = (0.21e2 / 0.256e3*1j) * t2180 * (-10 * t2181 - 5 * t2183 - 1 + (10 * t2181 + t2183 + 5) * t2180) * ((1 + t2180) ** (0.9e1 / 0.2e1)) * np.sqrt(0.230945e6) * np.exp((-9*1j) * phi1) * ((1 - t2180) ** (-0.1e1 / 0.2e1))

        if Bindx == 112:
            t2195 = np.cos(phi)
            t2194 = t2195 ** 2
            t2198 = t2194 ** 2
            t2202 = t2198 ** 2
            t2204 = 5 * t2195 * t2202
            t2197 = t2195 * t2194
            t2200 = t2197 ** 2
            t2196 = 3 * phi1
            t2191 = t2195 * t2198
            t2189 = t2195 * t2200
            tfunc[..., c] = (0.21e2 / 0.1024e4*1j) * np.sqrt(0.2e1) * ((1 + t2195) ** (0.3e1 / 0.2e1)) * np.sqrt(0.969e3) * ((1 - t2195) ** (-0.1e1 / 0.2e1)) * ((t2204 - 37 * t2202 + 116 * t2189 - 196 * t2200 + 182 * t2191 - 70 * t2198 - 28 * t2197 + 44 * t2194 - 19 * t2195 + 3) * np.exp((-3*1j) * (t2196 - 2 * phi2)) + (t2204 + 17 * t2202 + 8 * t2189 - 32 * t2200 - 38 * t2191 + 10 * t2198 + 32 * t2197 + 8 * t2194 - 7 * t2195 - 3) * np.exp((-3*1j) * (t2196 + 2 * phi2)))

        if Bindx == 113:
            t2209 = np.sin(phi)
            t2206 = t2209 ** 2
            t2207 = t2206 ** 2
            t2205 = np.cos(phi)
            tfunc[..., c] = (0.21e2 / 0.512e3) * np.exp((-8*1j) * phi1) * np.sqrt(0.24310e5) * t2207 ** 2 * (19 * t2205 ** 2 - 1)

        if Bindx == 114:
            t2221 = np.cos(phi)
            t2220 = t2221 ** 2
            t2223 = t2221 * t2220
            t2224 = t2220 ** 2
            t2225 = t2221 * t2224
            t2226 = t2223 ** 2
            t2228 = t2224 ** 2
            t2232 = -592 * t2223 + 896 * t2225 + (80 * t2226 - 456 * t2228 + 72) * t2221
            t2231 = 95 * t2225 ** 2 + 155 * t2220 + 266 * t2224 - 1162 * t2226 + 677 * t2228 - 31
            t2222 = 4 * phi1
            tfunc[..., c] = (0.21e2 / 0.1024e4) * ((t2231 + t2232) * np.exp((-2*1j) * (t2222 - 3 * phi2)) + (t2231 - t2232) * np.exp((-2*1j) * (t2222 + 3 * phi2))) * np.sqrt(0.51e2)

        if Bindx == 115:
            t2233 = np.cos(phi)
            tfunc[..., c] = (0.21e2 / 0.256e3*1j) * (19 * t2233 ** 2 - 3) * t2233 * ((1 + t2233) ** (0.7e1 / 0.2e1)) * np.sqrt(0.36465e5) * np.exp((-7*1j) * phi1) * ((1 - t2233) ** (0.7e1 / 0.2e1))

        if Bindx == 116:
            t2245 = np.cos(phi)
            t2244 = t2245 ** 2
            t2248 = t2244 ** 2
            t2249 = t2245 * t2248
            t2255 = 285 * t2249 ** 2
            t2252 = t2248 ** 2
            t2247 = t2245 * t2244
            t2250 = t2247 ** 2
            t2246 = 7 * phi1
            t2239 = t2245 * t2250
            t2237 = t2245 * t2252
            tfunc[..., c] = (0.21e2 / 0.1024e4*1j) * np.sqrt(0.2e1) * np.sqrt((1 + t2245)) * np.sqrt(0.17e2) * ((1 - t2245) ** (-0.1e1 / 0.2e1)) * ((t2255 - 1482 * t2237 + 2673 * t2252 - 1112 * t2239 - 2422 * t2250 + 3108 * t2249 - 518 * t2248 - 1048 * t2247 + 537 * t2244 + 22 * t2245 - 43) * np.exp((-1*1j) * (t2246 - 6 * phi2)) + (t2255 + 912 * t2237 + 279 * t2252 - 1840 * t2239 - 1694 * t2250 + 1008 * t2249 + 1582 * t2248 - 16 * t2247 - 495 * t2244 - 64 * t2245 + 43) * np.exp((-1*1j) * (t2246 + 6 * phi2)))

        if Bindx == 117:
            t2262 = np.sin(phi)
            t2259 = t2262 ** 2
            t2260 = t2262 * t2259
            t2256 = np.cos(phi)
            t2257 = t2256 ** 2
            tfunc[..., c] = -(0.21e2 / 0.512e3) * np.exp((-6*1j) * phi1) * np.sqrt(0.2145e4) * t2260 ** 2 * (3 + (-102 + 323 * t2257) * t2257)

        if Bindx == 118:
            t2274 = np.cos(phi)
            t2273 = t2274 ** 2
            t2275 = t2274 * t2273
            t2276 = t2273 ** 2
            t2277 = t2274 * t2276
            t2278 = t2275 ** 2
            t2280 = t2276 ** 2
            t2284 = -6168 * t2275 - 1932 * t2277 + (23528 * t2278 - 17442 * t2280 + 1502) * t2274
            t2283 = 4845 * t2277 ** 2 - 4503 * t2273 + 22442 * t2276 - 34902 * t2278 + 12393 * t2280 + 237
            tfunc[..., c] = (0.21e2 / 0.2048e4) * np.sqrt(0.2e1) * ((t2283 + t2284) * np.exp((-6*1j) * (phi1 - phi2)) + (t2283 - t2284) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 119:
            t2285 = np.cos(phi)
            t2286 = t2285 ** 2
            tfunc[..., c] = (-0.21e2 / 0.128e3*1j) * (15 + (-170 + 323 * t2286) * t2286) * t2285 * ((1 + t2285) ** (0.5e1 / 0.2e1)) * np.sqrt(0.429e3) * np.exp((-5*1j) * phi1) * ((1 - t2285) ** (0.5e1 / 0.2e1))

        if Bindx == 120:
            t2300 = np.cos(phi)
            t2299 = t2300 ** 2
            t2303 = t2299 ** 2
            t2302 = t2300 * t2299
            t2305 = t2302 ** 2
            t2307 = t2303 ** 2
            t2304 = t2300 * t2303
            t2309 = t2304 ** 2
            t2312 = -1 + 25 * t2299 + 1110 * t2303 - 4942 * t2305 + 6715 * t2307 - 2907 * t2309
            t2311 = -2035 * t2302 + 5278 * t2304 + (-4710 * t2305 + 255 * t2307 + 969 * t2309 + 243) * t2300
            t2301 = 5 * phi1
            tfunc[..., c] = (0.21e2 / 0.512e3*1j) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * ((1 + t2300) ** (-0.1e1 / 0.2e1)) * ((1 - t2300) ** (-0.1e1 / 0.2e1)) * ((t2311 + t2312) * np.exp((-1*1j) * (t2301 - 6 * phi2)) + (t2311 - t2312) * np.exp((-1*1j) * (t2301 + 6 * phi2)))

        if Bindx == 121:
            t2319 = np.sin(phi)
            t2317 = t2319 ** 2
            t2313 = np.cos(phi)
            t2314 = t2313 ** 2
            t2315 = t2314 ** 2
            tfunc[..., c] = (0.21e2 / 0.256e3) * np.exp((-4*1j) * phi1) * np.sqrt(0.4290e4) * t2317 ** 2 * (-255 * t2315 - 1 + (323 * t2315 + 45) * t2314)

        if Bindx == 122:
            t2331 = np.cos(phi)
            t2330 = t2331 ** 2
            t2333 = t2331 * t2330
            t2334 = t2330 ** 2
            t2335 = t2331 * t2334
            t2336 = t2333 ** 2
            t2338 = t2334 ** 2
            t2342 = 0.13209e5 / 0.64e2 * t2333 - 0.6027e4 / 0.8e1 * t2335 + (0.66759e5 / 0.64e2 * t2336 - 0.61047e5 / 0.128e3 * t2338 - 0.2457e4 / 0.128e3) * t2331
            t2341 = 0.101745e6 / 0.512e3 * t2335 ** 2 - 0.50547e5 / 0.512e3 * t2330 + 0.93639e5 / 0.256e3 * t2334 - 0.84231e5 / 0.256e3 * t2336 - 0.71757e5 / 0.512e3 * t2338 + 0.1743e4 / 0.512e3
            t2332 = 2 * phi1
            tfunc[..., c] = (t2341 + t2342) * np.exp((-2*1j) * (t2332 - 3 * phi2)) + (t2341 - t2342) * np.exp((-2*1j) * (t2332 + 3 * phi2))

        if Bindx == 123:
            t2343 = np.cos(phi)
            t2344 = t2343 ** 2
            t2345 = t2344 ** 2
            tfunc[..., c] = (0.21e2 / 0.128e3*1j) * (-357 * t2345 - 7 + (323 * t2345 + 105) * t2344) * t2343 * ((1 + t2343) ** (0.3e1 / 0.2e1)) * np.sqrt(0.2145e4) * np.exp((-3*1j) * phi1) * ((1 - t2343) ** (0.3e1 / 0.2e1))

        if Bindx == 124:
            t2359 = np.cos(phi)
            t2358 = t2359 ** 2
            t2361 = t2358 ** 2
            t2360 = t2359 * t2358
            t2363 = t2360 ** 2
            t2365 = t2361 ** 2
            t2362 = t2359 * t2361
            t2367 = t2362 ** 2
            t2370 = 69 - 2277 * t2358 + 12898 * t2361 - 27962 * t2363 + 25993 * t2365 - 8721 * t2367
            t2369 = -1423 * t2360 + 662 * t2362 + (7122 * t2363 - 11373 * t2365 + 4845 * t2367 + 167) * t2359
            tfunc[..., c] = (0.21e2 / 0.512e3*1j) * np.sqrt(0.2e1) * ((1 + t2359) ** (-0.1e1 / 0.2e1)) * ((1 - t2359) ** (-0.1e1 / 0.2e1)) * ((t2369 + t2370) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t2369 - t2370) * np.exp((-3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 125:
            t2372 = np.cos(phi)
            t2373 = t2372 ** 2
            t2374 = t2373 ** 2
            t2371 = np.sin(phi)
            tfunc[..., c] = -(0.21e2 / 0.512e3) * np.exp((-2*1j) * phi1) * np.sqrt(0.330e3) * t2371 ** 2 * (-364 * t2373 + 7 + (-6188 * t2373 + 2730 + 4199 * t2374) * t2374)

        if Bindx == 126:
            t2388 = np.cos(phi)
            t2387 = t2388 ** 2
            t2389 = t2388 * t2387
            t2390 = t2387 ** 2
            t2391 = t2388 * t2390
            t2392 = t2389 ** 2
            t2394 = t2390 ** 2
            t2398 = 4888 * t2389 - 14276 * t2391 + (15640 * t2392 - 5814 * t2394 - 438) * t2388
            t2397 = 4845 * t2391 ** 2 + 665 * t2387 - 4486 * t2390 + 11898 * t2392 - 12903 * t2394 - 19
            tfunc[..., c] = (0.21e2 / 0.1024e4) * ((t2397 + t2398) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t2397 - t2398) * np.exp((-2*1j) * (phi1 + 3 * phi2))) * np.sqrt(0.13e2)

        if Bindx == 127:
            t2399 = np.cos(phi)
            t2400 = t2399 ** 2
            t2401 = t2399 * t2400
            t2402 = t2400 ** 2
            t2408 = -7956 * t2401 ** 2 + 63 + (4914 + 4199 * t2402) * t2402
            tfunc[..., c] = (0.21e2 / 0.256e3*1j) * np.exp((-1*1j) * phi1) * np.sqrt(0.110e3) * np.sqrt((1 + t2399)) * t2399 * (t2408 * t2399 + 1092 * t2400 - 1092 * t2401 - t2408) * ((1 - t2399) ** (-0.1e1 / 0.2e1))

        if Bindx == 128:
            t2421 = np.cos(phi)
            t2420 = t2421 ** 2
            t2423 = t2420 ** 2
            t2422 = t2421 * t2420
            t2425 = t2422 ** 2
            t2427 = t2423 ** 2
            t2424 = t2421 * t2423
            t2429 = t2424 ** 2
            t2432 = 9 - 333 * t2420 + 1914 * t2423 - 3834 * t2425 + 3213 * t2427 - 969 * t2429
            t2431 = 1387 * t2422 - 5110 * t2424 + (8118 * t2425 - 5899 * t2427 + 1615 * t2429 - 111) * t2421
            tfunc[..., c] = (0.21e2 / 0.512e3*1j) * np.sqrt(0.39e2) * ((1 + t2421) ** (-0.1e1 / 0.2e1)) * ((1 - t2421) ** (-0.1e1 / 0.2e1)) * ((t2431 + t2432) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (t2431 - t2432) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 129:
            t2433 = np.cos(phi)
            t2434 = t2433 ** 2
            t2435 = t2434 ** 2
            t2437 = t2435 ** 2
            tfunc[..., c] = -0.2297295e7 / 0.256e3 * t2437 - 0.315315e6 / 0.128e3 * t2435 - 0.1323e4 / 0.256e3 + (0.969969e6 / 0.256e3 * t2437 + 0.945945e6 / 0.128e3 * t2435 + 0.72765e5 / 0.256e3) * t2434

        if Bindx == 130:
            t2439 = np.cos(phi)
            t2440 = t2439 ** 2
            t2441 = t2440 ** 2
            t2443 = t2441 ** 2
            tfunc[..., c] = 0.21e2 / 0.512e3 * np.sqrt(0.2145e4) * np.sqrt(0.2e1) * (-638 * t2441 - 1071 * t2443 - 3 + (1278 * t2441 + 323 * t2443 + 111) * t2440) * np.cos((6 * phi2))

        if Bindx == 131:
            t2445 = np.cos(phi)
            t2446 = t2445 ** 2
            t2447 = t2446 ** 2
            tfunc[..., c] = (-0.21e2 / 0.256e3*1j) * np.exp((1j) * phi1) * np.sqrt(0.110e3) * np.sqrt((1 - t2445)) * np.sqrt((1 + t2445)) * t2445 * (-1092 * t2446 + 63 + (-7956 * t2446 + 4914 + 4199 * t2447) * t2447)

        if Bindx == 132:
            t2462 = np.cos(phi)
            t2461 = t2462 ** 2
            t2464 = t2461 ** 2
            t2463 = t2462 * t2461
            t2466 = t2463 ** 2
            t2468 = t2464 ** 2
            t2465 = t2462 * t2464
            t2470 = t2465 ** 2
            t2473 = 9 - 333 * t2461 + 1914 * t2464 - 3834 * t2466 + 3213 * t2468 - 969 * t2470
            t2472 = 1387 * t2463 - 5110 * t2465 + (8118 * t2466 - 5899 * t2468 + 1615 * t2470 - 111) * t2462
            tfunc[..., c] = (0.21e2 / 0.512e3*1j) * np.sqrt(0.39e2) * ((1 + t2462) ** (-0.1e1 / 0.2e1)) * ((1 - t2462) ** (-0.1e1 / 0.2e1)) * ((t2472 + t2473) * np.exp((1j) * (phi1 - 6 * phi2)) + (t2472 - t2473) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 133:
            t2475 = np.cos(phi)
            t2476 = t2475 ** 2
            t2477 = t2476 ** 2
            t2474 = np.sin(phi)
            tfunc[..., c] = -(0.21e2 / 0.512e3) * np.exp((2*1j) * phi1) * np.sqrt(0.330e3) * t2474 ** 2 * (-364 * t2476 + 7 + (-6188 * t2476 + 2730 + 4199 * t2477) * t2477)

        if Bindx == 134:
            t2491 = np.cos(phi)
            t2490 = t2491 ** 2
            t2492 = t2491 * t2490
            t2493 = t2490 ** 2
            t2494 = t2491 * t2493
            t2495 = t2492 ** 2
            t2497 = t2493 ** 2
            t2501 = 4888 * t2492 - 14276 * t2494 + (15640 * t2495 - 5814 * t2497 - 438) * t2491
            t2500 = 4845 * t2494 ** 2 + 665 * t2490 - 4486 * t2493 + 11898 * t2495 - 12903 * t2497 - 19
            tfunc[..., c] = (0.21e2 / 0.1024e4) * ((t2500 + t2501) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t2500 - t2501) * np.exp((2*1j) * (phi1 + 3 * phi2))) * np.sqrt(0.13e2)

        if Bindx == 135:
            t2502 = np.cos(phi)
            t2503 = t2502 ** 2
            t2504 = t2503 ** 2
            tfunc[..., c] = (0.21e2 / 0.128e3*1j) * np.exp((3*1j) * phi1) * np.sqrt(0.2145e4) * ((1 - t2502) ** (0.3e1 / 0.2e1)) * ((1 + t2502) ** (0.3e1 / 0.2e1)) * t2502 * (-357 * t2504 - 7 + (323 * t2504 + 105) * t2503)

        if Bindx == 136:
            t2518 = np.cos(phi)
            t2517 = t2518 ** 2
            t2520 = t2517 ** 2
            t2519 = t2518 * t2517
            t2522 = t2519 ** 2
            t2524 = t2520 ** 2
            t2521 = t2518 * t2520
            t2526 = t2521 ** 2
            t2529 = 69 - 2277 * t2517 + 12898 * t2520 - 27962 * t2522 + 25993 * t2524 - 8721 * t2526
            t2528 = -1423 * t2519 + 662 * t2521 + (7122 * t2522 - 11373 * t2524 + 4845 * t2526 + 167) * t2518
            tfunc[..., c] = (0.21e2 / 0.512e3*1j) * np.sqrt(0.2e1) * ((1 + t2518) ** (-0.1e1 / 0.2e1)) * ((1 - t2518) ** (-0.1e1 / 0.2e1)) * ((t2528 + t2529) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t2528 - t2529) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 137:
            t2536 = np.sin(phi)
            t2534 = t2536 ** 2
            t2530 = np.cos(phi)
            t2531 = t2530 ** 2
            t2532 = t2531 ** 2
            tfunc[..., c] = (0.21e2 / 0.256e3) * np.exp((4*1j) * phi1) * np.sqrt(0.4290e4) * t2534 ** 2 * (-255 * t2532 - 1 + (323 * t2532 + 45) * t2531)

        if Bindx == 138:
            t2548 = np.cos(phi)
            t2547 = t2548 ** 2
            t2550 = t2548 * t2547
            t2551 = t2547 ** 2
            t2552 = t2548 * t2551
            t2553 = t2550 ** 2
            t2555 = t2551 ** 2
            t2559 = 0.13209e5 / 0.64e2 * t2550 - 0.6027e4 / 0.8e1 * t2552 + (0.66759e5 / 0.64e2 * t2553 - 0.61047e5 / 0.128e3 * t2555 - 0.2457e4 / 0.128e3) * t2548
            t2558 = 0.101745e6 / 0.512e3 * t2552 ** 2 - 0.50547e5 / 0.512e3 * t2547 + 0.93639e5 / 0.256e3 * t2551 - 0.84231e5 / 0.256e3 * t2553 - 0.71757e5 / 0.512e3 * t2555 + 0.1743e4 / 0.512e3
            t2549 = 2 * phi1
            tfunc[..., c] = (t2558 + t2559) * np.exp((2*1j) * (t2549 - 3 * phi2)) + (t2558 - t2559) * np.exp((2*1j) * (t2549 + 3 * phi2))

        if Bindx == 139:
            t2560 = np.cos(phi)
            t2561 = t2560 ** 2
            tfunc[..., c] = (-0.21e2 / 0.128e3*1j) * np.exp((5*1j) * phi1) * np.sqrt(0.429e3) * ((1 - t2560) ** (0.5e1 / 0.2e1)) * ((1 + t2560) ** (0.5e1 / 0.2e1)) * t2560 * (15 + (-170 + 323 * t2561) * t2561)

        if Bindx == 140:
            t2575 = np.cos(phi)
            t2574 = t2575 ** 2
            t2578 = t2574 ** 2
            t2577 = t2575 * t2574
            t2580 = t2577 ** 2
            t2582 = t2578 ** 2
            t2579 = t2575 * t2578
            t2584 = t2579 ** 2
            t2587 = -1 + 25 * t2574 + 1110 * t2578 - 4942 * t2580 + 6715 * t2582 - 2907 * t2584
            t2586 = -2035 * t2577 + 5278 * t2579 + (-4710 * t2580 + 255 * t2582 + 969 * t2584 + 243) * t2575
            t2576 = 5 * phi1
            tfunc[..., c] = (0.21e2 / 0.512e3*1j) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * ((1 + t2575) ** (-0.1e1 / 0.2e1)) * ((1 - t2575) ** (-0.1e1 / 0.2e1)) * ((t2586 + t2587) * np.exp((1j) * (t2576 - 6 * phi2)) + (t2586 - t2587) * np.exp((1j) * (t2576 + 6 * phi2)))

        if Bindx == 141:
            t2594 = np.sin(phi)
            t2591 = t2594 ** 2
            t2592 = t2594 * t2591
            t2588 = np.cos(phi)
            t2589 = t2588 ** 2
            tfunc[..., c] = -(0.21e2 / 0.512e3) * np.exp((6*1j) * phi1) * np.sqrt(0.2145e4) * t2592 ** 2 * (3 + (-102 + 323 * t2589) * t2589)

        if Bindx == 142:
            t2606 = np.cos(phi)
            t2605 = t2606 ** 2
            t2607 = t2606 * t2605
            t2608 = t2605 ** 2
            t2609 = t2606 * t2608
            t2610 = t2607 ** 2
            t2612 = t2608 ** 2
            t2616 = -6168 * t2607 - 1932 * t2609 + (23528 * t2610 - 17442 * t2612 + 1502) * t2606
            t2615 = 4845 * t2609 ** 2 - 4503 * t2605 + 22442 * t2608 - 34902 * t2610 + 12393 * t2612 + 237
            tfunc[..., c] = (0.21e2 / 0.2048e4) * np.sqrt(0.2e1) * ((t2615 + t2616) * np.exp((6*1j) * (phi1 - phi2)) + (t2615 - t2616) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 143:
            t2617 = np.cos(phi)
            tfunc[..., c] = (0.21e2 / 0.256e3*1j) * np.exp((7*1j) * phi1) * np.sqrt(0.36465e5) * ((1 - t2617) ** (0.7e1 / 0.2e1)) * ((1 + t2617) ** (0.7e1 / 0.2e1)) * t2617 * (19 * t2617 ** 2 - 3)

        if Bindx == 144:
            t2629 = np.cos(phi)
            t2628 = t2629 ** 2
            t2632 = t2628 ** 2
            t2633 = t2629 * t2632
            t2639 = 285 * t2633 ** 2
            t2636 = t2632 ** 2
            t2631 = t2629 * t2628
            t2634 = t2631 ** 2
            t2630 = 7 * phi1
            t2623 = t2629 * t2634
            t2621 = t2629 * t2636
            tfunc[..., c] = (-0.21e2 / 0.1024e4*1j) * np.sqrt(0.2e1) * np.sqrt((1 - t2629)) * np.sqrt(0.17e2) * ((1 + t2629) ** (-0.1e1 / 0.2e1)) * ((t2639 - 912 * t2621 + 279 * t2636 + 1840 * t2623 - 1694 * t2634 - 1008 * t2633 + 1582 * t2632 + 16 * t2631 - 495 * t2628 + 64 * t2629 + 43) * np.exp((1j) * (t2630 - 6 * phi2)) + (t2639 + 1482 * t2621 + 2673 * t2636 + 1112 * t2623 - 2422 * t2634 - 3108 * t2633 - 518 * t2632 + 1048 * t2631 + 537 * t2628 - 22 * t2629 - 43) * np.exp((1j) * (t2630 + 6 * phi2)))

        if Bindx == 145:
            t2644 = np.sin(phi)
            t2641 = t2644 ** 2
            t2642 = t2641 ** 2
            t2640 = np.cos(phi)
            tfunc[..., c] = (0.21e2 / 0.512e3) * np.exp((8*1j) * phi1) * np.sqrt(0.24310e5) * t2642 ** 2 * (19 * t2640 ** 2 - 1)

        if Bindx == 146:
            t2656 = np.cos(phi)
            t2655 = t2656 ** 2
            t2658 = t2656 * t2655
            t2659 = t2655 ** 2
            t2660 = t2656 * t2659
            t2661 = t2658 ** 2
            t2663 = t2659 ** 2
            t2667 = -592 * t2658 + 896 * t2660 + (80 * t2661 - 456 * t2663 + 72) * t2656
            t2666 = 95 * t2660 ** 2 + 155 * t2655 + 266 * t2659 - 1162 * t2661 + 677 * t2663 - 31
            t2657 = 4 * phi1
            tfunc[..., c] = (0.21e2 / 0.1024e4) * ((t2666 + t2667) * np.exp((2*1j) * (t2657 - 3 * phi2)) + (t2666 - t2667) * np.exp((2*1j) * (t2657 + 3 * phi2))) * np.sqrt(0.51e2)

        if Bindx == 147:
            t2668 = np.cos(phi)
            tfunc[..., c] = (-0.21e2 / 0.256e3*1j) * np.exp((9*1j) * phi1) * np.sqrt(0.230945e6) * ((1 - t2668) ** (0.9e1 / 0.2e1)) * ((1 + t2668) ** (0.9e1 / 0.2e1)) * t2668

        if Bindx == 148:
            t2679 = np.cos(phi)
            t2678 = t2679 ** 2
            t2682 = t2678 ** 2
            t2686 = t2682 ** 2
            t2688 = 5 * t2679 * t2686
            t2681 = t2679 * t2678
            t2684 = t2681 ** 2
            t2680 = 3 * phi1
            t2675 = t2679 * t2682
            t2673 = t2679 * t2684
            tfunc[..., c] = (0.21e2 / 0.1024e4*1j) * np.sqrt(0.2e1) * ((1 - t2679) ** (0.3e1 / 0.2e1)) * np.sqrt(0.969e3) * ((1 + t2679) ** (-0.1e1 / 0.2e1)) * ((t2688 - 17 * t2686 + 8 * t2673 + 32 * t2684 - 38 * t2675 - 10 * t2682 + 32 * t2681 - 8 * t2678 - 7 * t2679 + 3) * np.exp((3*1j) * (t2680 - 2 * phi2)) + (t2688 + 37 * t2686 + 116 * t2673 + 196 * t2684 + 182 * t2675 + 70 * t2682 - 28 * t2681 - 44 * t2678 - 19 * t2679 - 3) * np.exp((3*1j) * (t2680 + 2 * phi2)))

        if Bindx == 149:
            t2693 = np.sin(phi)
            t2689 = t2693 ** 2
            t2691 = t2693 * t2689 ** 2
            tfunc[..., c] = -(0.21e2 / 0.512e3) * np.exp((10*1j) * phi1) * np.sqrt(0.46189e5) * t2691 ** 2

        if Bindx == 150:
            t2705 = np.cos(phi)
            t2717 = -6 * t2705
            t2704 = t2705 ** 2
            t2707 = t2705 * t2704
            t2708 = t2704 ** 2
            t2709 = t2705 * t2708
            t2710 = t2707 ** 2
            t2712 = t2708 ** 2
            t2716 = -8 * t2705 * t2710 + t2712 * t2717 - 8 * t2707 + 28 * t2709 + t2717
            t2715 = t2709 ** 2 + 13 * t2704 - 14 * t2708 - 14 * t2710 + 13 * t2712 + 1
            t2706 = 5 * phi1
            tfunc[..., c] = (0.21e2 / 0.2048e4) * np.sqrt(0.2e1) * np.sqrt(0.4845e4) * ((t2715 + t2716) * np.exp((2*1j) * (t2706 - 3 * phi2)) + (t2715 - t2716) * np.exp((2*1j) * (t2706 + 3 * phi2)))

        if Bindx == 151:
            t2729 = np.cos(phi)
            t2741 = -6 * t2729
            t2728 = t2729 ** 2
            t2731 = t2729 * t2728
            t2732 = t2728 ** 2
            t2733 = t2729 * t2732
            t2734 = t2731 ** 2
            t2736 = t2732 ** 2
            t2740 = -8 * t2729 * t2734 + t2736 * t2741 - 8 * t2731 + 28 * t2733 + t2741
            t2739 = -t2733 ** 2 - 13 * t2728 + 14 * t2732 + 14 * t2734 - 13 * t2736 - 1
            t2730 = 11 * phi1
            tfunc[..., c] = (-0.69e2 / 0.2048e4*1j) * np.sqrt(0.1463e4) * np.sqrt((1 - t2729)) * np.sqrt((1 + t2729)) * ((-t2739 + t2740) * np.exp((-1*1j) * (t2730 - 6 * phi2)) + (t2739 + t2740) * np.exp((-1*1j) * (t2730 + 6 * phi2)))

        if Bindx == 152:
            t2754 = np.cos(phi)
            t2753 = t2754 ** 2
            t2757 = t2753 ** 2
            t2756 = t2754 * t2753
            t2759 = t2756 ** 2
            t2761 = t2757 ** 2
            t2758 = t2754 * t2757
            t2763 = t2758 ** 2
            t2766 = -6 - 12 * t2753 + 172 * t2757 - 224 * t2759 + 10 * t2761 + 60 * t2763
            t2765 = -95 * t2756 - 14 * t2758 + (202 * t2759 - 107 * t2761 - 11 * t2763 + 25) * t2754
            t2755 = 5 * phi1
            tfunc[..., c] = -(0.69e2 / 0.2048e4) * np.sqrt(0.2e1) * np.sqrt(0.133e3) * ((t2765 + t2766) * np.exp((-2*1j) * (t2755 - 3 * phi2)) + (-t2765 + t2766) * np.exp((-2*1j) * (t2755 + 3 * phi2)))

        if Bindx == 153:
            t2778 = np.cos(phi)
            t2777 = t2778 ** 2
            t2781 = t2777 ** 2
            t2782 = t2778 * t2781
            t2788 = -231 * t2782 ** 2 - 61
            t2785 = t2781 ** 2
            t2780 = t2778 * t2777
            t2783 = t2780 ** 2
            t2779 = 3 * phi1
            t2772 = t2778 * t2783
            t2770 = t2778 * t2785
            tfunc[..., c] = (0.23e2 / 0.2048e4*1j) * np.sqrt(0.57e2) * ((1 + t2778) ** (0.3e1 / 0.2e1)) * ((-1596 * t2770 + 4513 * t2785 - 6368 * t2772 + 3766 * t2783 + 1288 * t2782 - 3374 * t2781 + 1792 * t2780 - 77 * t2777 - 236 * t2778 - t2788) * np.exp((-3*1j) * (t2779 - 2 * phi2)) + (-672 * t2770 + 23 * t2785 + 1688 * t2772 + 1058 * t2783 - 1352 * t2782 - 1322 * t2781 + 328 * t2780 + 533 * t2777 + 8 * t2778 + t2788) * np.exp((-3*1j) * (t2779 + 2 * phi2))) * ((1 - t2778) ** (-0.1e1 / 0.2e1))

        if Bindx == 154:
            t2801 = np.cos(phi)
            t2800 = t2801 ** 2
            t2804 = t2800 ** 2
            t2803 = t2801 * t2800
            t2806 = t2803 ** 2
            t2808 = t2804 ** 2
            t2805 = t2801 * t2804
            t2810 = t2805 ** 2
            t2813 = -8 + 128 * t2800 - 448 * t2804 + 336 * t2806 + 328 * t2808 - 336 * t2810
            t2812 = 63 * t2803 - 574 * t2805 + (958 * t2806 - 383 * t2808 - 77 * t2810 + 13) * t2801
            t2802 = 4 * phi1
            tfunc[..., c] = (0.69e2 / 0.1024e4) * ((-t2812 + t2813) * np.exp((-2*1j) * (t2802 - 3 * phi2)) + (t2812 + t2813) * np.exp((-2*1j) * (t2802 + 3 * phi2))) * np.sqrt(0.95e2)

        if Bindx == 155:
            t2826 = np.cos(phi)
            t2825 = t2826 ** 2
            t2829 = t2825 ** 2
            t2830 = t2826 * t2829
            t2835 = t2830 ** 2
            t2837 = -1463 * t2826 * t2835 + 35
            t2833 = t2829 ** 2
            t2828 = t2826 * t2825
            t2831 = t2828 ** 2
            t2827 = 7 * phi1
            t2820 = t2826 * t2831
            t2818 = t2826 * t2833
            tfunc[..., c] = (-0.69e2 / 0.2048e4*1j) * np.sqrt((1 + t2826)) * np.sqrt(0.5e1) * ((1 - t2826) ** (-0.1e1 / 0.2e1)) * ((7049 * t2835 - 10697 * t2818 - 209 * t2833 + 16058 * t2820 - 12390 * t2831 - 3794 * t2830 + 7742 * t2829 - 1491 * t2828 - 1203 * t2825 + 363 * t2826 + t2837) * np.exp((-1*1j) * (t2827 - 6 * phi2)) + (4123 * t2835 - 475 * t2818 - 10431 * t2833 - 5418 * t2820 + 9086 * t2831 + 7098 * t2830 - 3150 * t2829 - 3101 * t2828 + 407 * t2825 + 433 * t2826 - t2837) * np.exp((-1*1j) * (t2827 + 6 * phi2)))

        if Bindx == 156:
            t2850 = np.cos(phi)
            t2849 = t2850 ** 2
            t2852 = t2849 ** 2
            t2851 = t2850 * t2849
            t2854 = t2851 ** 2
            t2856 = t2852 ** 2
            t2853 = t2850 * t2852
            t2858 = t2853 ** 2
            t2861 = 94 - 2820 * t2849 + 420 * t2852 + 40096 * t2854 - 80370 * t2856 + 43092 * t2858
            t2860 = 21805 * t2851 - 69846 * t2853 + (79650 * t2854 - 16815 * t2856 - 13167 * t2858 - 2139) * t2850
            tfunc[..., c] = -(0.23e2 / 0.2048e4) * np.sqrt(0.2e1) * ((t2860 + t2861) * np.exp((-6*1j) * (phi1 - phi2)) + (-t2860 + t2861) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 157:
            t2875 = np.cos(phi)
            t2874 = t2875 ** 2
            t2877 = t2875 * t2874
            t2878 = t2874 ** 2
            t2879 = t2875 * t2878
            t2880 = t2877 ** 2
            t2882 = t2878 ** 2
            t2884 = t2879 ** 2
            t2888 = -2090 * t2877 + 12852 * t2879 + (-31412 * t2880 + 32490 * t2882 - 11970 * t2884 + 130) * t2875
            t2887 = -1908 * t2874 + 10745 * t2878 + 13815 * t2882 + 2964 * t2884 + 53 + (-21280 - 4389 * t2880) * t2880
            t2876 = 5 * phi1
            tfunc[..., c] = (0.23e2 / 0.2048e4*1j) * np.sqrt(0.51e2) * ((-t2887 + t2888) * np.exp((-1*1j) * (t2876 - 6 * phi2)) + (t2887 + t2888) * np.exp((-1*1j) * (t2876 + 6 * phi2))) * ((1 + t2875) ** (-0.1e1 / 0.2e1)) * ((1 - t2875) ** (-0.1e1 / 0.2e1))

        if Bindx == 158:
            t2901 = np.cos(phi)
            t2900 = t2901 ** 2
            t2904 = t2900 ** 2
            t2903 = t2901 * t2900
            t2906 = t2903 ** 2
            t2908 = t2904 ** 2
            t2905 = t2901 * t2904
            t2910 = t2905 ** 2
            t2913 = 4 - 160 * t2900 + 1120 * t2904 - 3016 * t2906 + 3420 * t2908 - 1368 * t2910
            t2912 = 345 * t2903 - 874 * t2905 + (330 * t2906 + 855 * t2908 - 627 * t2910 - 29) * t2901
            t2902 = 2 * phi1
            tfunc[..., c] = (0.23e2 / 0.512e3) * ((-t2912 + t2913) * np.exp((-2*1j) * (t2902 - 3 * phi2)) + (t2912 + t2913) * np.exp((-2*1j) * (t2902 + 3 * phi2))) * np.sqrt(0.357e3)

        if Bindx == 159:
            t2927 = np.cos(phi)
            t2926 = t2927 ** 2
            t2928 = t2927 * t2926
            t2929 = t2926 ** 2
            t2930 = t2927 * t2929
            t2931 = t2928 ** 2
            t2933 = t2929 ** 2
            t2935 = t2930 ** 2
            t2939 = -1502 * t2928 + 6460 * t2930 + (-11900 * t2931 + 9918 * t2933 - 3078 * t2935 + 102) * t2927
            t2938 = -44 * t2926 + 13 * t2929 - 4917 * t2933 + 5244 * t2935 + 1 + (1584 - 1881 * t2931) * t2931
            tfunc[..., c] = (0.23e2 / 0.2048e4*1j) * np.sqrt(0.595e3) * np.sqrt(0.2e1) * ((-t2938 + t2939) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t2938 + t2939) * np.exp((-3*1j) * (phi1 + 2 * phi2))) * ((1 + t2927) ** (-0.1e1 / 0.2e1)) * ((1 - t2927) ** (-0.1e1 / 0.2e1))

        if Bindx == 160:
            t2952 = np.cos(phi)
            t2951 = t2952 ** 2
            t2954 = t2951 ** 2
            t2953 = t2952 * t2951
            t2956 = t2953 ** 2
            t2958 = t2954 ** 2
            t2955 = t2952 * t2954
            t2960 = t2955 ** 2
            t2963 = 6 - 276 * t2951 + 1940 * t2954 - 4672 * t2956 + 4598 * t2958 - 1596 * t2960
            t2962 = -459 * t2953 + 2218 * t2955 + (-4638 * t2956 + 4313 * t2958 - 1463 * t2960 + 29) * t2952
            tfunc[..., c] = (0.69e2 / 0.1024e4) * ((-t2962 + t2963) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t2962 + t2963) * np.exp((-2*1j) * (phi1 + 3 * phi2))) * np.sqrt(0.85e2)

        if Bindx == 161:
            t2977 = np.cos(phi)
            t2976 = t2977 ** 2
            t2978 = t2977 * t2976
            t2979 = t2976 ** 2
            t2980 = t2977 * t2979
            t2981 = t2978 ** 2
            t2983 = t2979 ** 2
            t2985 = t2980 ** 2
            t2989 = 470 * t2978 - 2028 * t2980 + (3564 * t2981 - 2774 * t2983 + 798 * t2985 - 30) * t2977
            t2988 = 240 * t2976 - 1925 * t2979 - 8319 * t2983 + 5624 * t2985 - 5 + (5848 - 1463 * t2981) * t2981
            tfunc[..., c] = (-0.69e2 / 0.2048e4*1j) * np.sqrt(0.221e3) * np.sqrt(0.2e1) * ((1 + t2977) ** (-0.1e1 / 0.2e1)) * ((1 - t2977) ** (-0.1e1 / 0.2e1)) * ((t2988 + t2989) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (-t2988 + t2989) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 162:
            t2996 = np.sin(phi)
            t2993 = t2996 ** 2
            t2994 = t2996 * t2993
            t2990 = np.cos(phi)
            t2991 = t2990 ** 2
            tfunc[..., c] = (-0.23e2 / 0.512e3*1j) * t2990 * t2994 ** 2 * (15 + (-190 + 399 * t2991) * t2991) * np.sin((6 * phi2)) * np.sqrt(0.7293e4) * np.sqrt(0.2e1)

        if Bindx == 163:
            t3010 = np.cos(phi)
            t3009 = t3010 ** 2
            t3011 = t3010 * t3009
            t3012 = t3009 ** 2
            t3013 = t3010 * t3012
            t3014 = t3011 ** 2
            t3016 = t3012 ** 2
            t3018 = t3013 ** 2
            t3022 = -470 * t3011 + 2028 * t3013 + (-3564 * t3014 + 2774 * t3016 - 798 * t3018 + 30) * t3010
            t3021 = 240 * t3009 - 1925 * t3012 - 8319 * t3016 + 5624 * t3018 - 5 + (5848 - 1463 * t3014) * t3014
            tfunc[..., c] = (-0.69e2 / 0.2048e4*1j) * np.sqrt(0.221e3) * np.sqrt(0.2e1) * ((1 + t3010) ** (-0.1e1 / 0.2e1)) * ((1 - t3010) ** (-0.1e1 / 0.2e1)) * ((-t3021 + t3022) * np.exp((1j) * (phi1 - 6 * phi2)) + (t3021 + t3022) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 164:
            t3035 = np.cos(phi)
            t3034 = t3035 ** 2
            t3037 = t3034 ** 2
            t3036 = t3035 * t3034
            t3039 = t3036 ** 2
            t3041 = t3037 ** 2
            t3038 = t3035 * t3037
            t3043 = t3038 ** 2
            t3046 = 6 - 276 * t3034 + 1940 * t3037 - 4672 * t3039 + 4598 * t3041 - 1596 * t3043
            t3045 = -459 * t3036 + 2218 * t3038 + (-4638 * t3039 + 4313 * t3041 - 1463 * t3043 + 29) * t3035
            tfunc[..., c] = -(0.69e2 / 0.1024e4) * ((-t3045 + t3046) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t3045 + t3046) * np.exp((2*1j) * (phi1 + 3 * phi2))) * np.sqrt(0.85e2)

        if Bindx == 165:
            t3060 = np.cos(phi)
            t3059 = t3060 ** 2
            t3061 = t3060 * t3059
            t3062 = t3059 ** 2
            t3063 = t3060 * t3062
            t3064 = t3061 ** 2
            t3066 = t3062 ** 2
            t3068 = t3063 ** 2
            t3072 = -1502 * t3061 + 6460 * t3063 + (-11900 * t3064 + 9918 * t3066 - 3078 * t3068 + 102) * t3060
            t3071 = -44 * t3059 + 13 * t3062 - 4917 * t3066 + 5244 * t3068 + 1 + (1584 - 1881 * t3064) * t3064
            tfunc[..., c] = (-0.23e2 / 0.2048e4*1j) * np.sqrt(0.595e3) * np.sqrt(0.2e1) * ((1 + t3060) ** (-0.1e1 / 0.2e1)) * ((1 - t3060) ** (-0.1e1 / 0.2e1)) * ((-t3071 + t3072) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t3071 + t3072) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 166:
            t3085 = np.cos(phi)
            t3084 = t3085 ** 2
            t3088 = t3084 ** 2
            t3087 = t3085 * t3084
            t3090 = t3087 ** 2
            t3092 = t3088 ** 2
            t3089 = t3085 * t3088
            t3094 = t3089 ** 2
            t3097 = -4 + 160 * t3084 - 1120 * t3088 + 3016 * t3090 - 3420 * t3092 + 1368 * t3094
            t3096 = 345 * t3087 - 874 * t3089 + (330 * t3090 + 855 * t3092 - 627 * t3094 - 29) * t3085
            t3086 = 2 * phi1
            tfunc[..., c] = (0.23e2 / 0.512e3) * ((t3096 + t3097) * np.exp((2*1j) * (t3086 - 3 * phi2)) + (-t3096 + t3097) * np.exp((2*1j) * (t3086 + 3 * phi2))) * np.sqrt(0.357e3)

        if Bindx == 167:
            t3111 = np.cos(phi)
            t3110 = t3111 ** 2
            t3113 = t3111 * t3110
            t3114 = t3110 ** 2
            t3115 = t3111 * t3114
            t3116 = t3113 ** 2
            t3118 = t3114 ** 2
            t3120 = t3115 ** 2
            t3124 = -2090 * t3113 + 12852 * t3115 + (-31412 * t3116 + 32490 * t3118 - 11970 * t3120 + 130) * t3111
            t3123 = -1908 * t3110 + 10745 * t3114 + 13815 * t3118 + 2964 * t3120 + 53 + (-21280 - 4389 * t3116) * t3116
            t3112 = 5 * phi1
            tfunc[..., c] = (-0.23e2 / 0.2048e4*1j) * np.sqrt(0.51e2) * ((-t3123 + t3124) * np.exp((1j) * (t3112 - 6 * phi2)) + (t3123 + t3124) * np.exp((1j) * (t3112 + 6 * phi2))) * ((1 + t3111) ** (-0.1e1 / 0.2e1)) * ((1 - t3111) ** (-0.1e1 / 0.2e1))

        if Bindx == 168:
            t3137 = np.cos(phi)
            t3136 = t3137 ** 2
            t3139 = t3136 ** 2
            t3138 = t3137 * t3136
            t3141 = t3138 ** 2
            t3143 = t3139 ** 2
            t3140 = t3137 * t3139
            t3145 = t3140 ** 2
            t3148 = -94 + 2820 * t3136 - 420 * t3139 - 40096 * t3141 + 80370 * t3143 - 43092 * t3145
            t3147 = 21805 * t3138 - 69846 * t3140 + (79650 * t3141 - 16815 * t3143 - 13167 * t3145 - 2139) * t3137
            tfunc[..., c] = -(0.23e2 / 0.2048e4) * np.sqrt(0.2e1) * ((-t3147 + t3148) * np.exp((6*1j) * (phi1 - phi2)) + (t3147 + t3148) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 169:
            t3161 = np.cos(phi)
            t3160 = t3161 ** 2
            t3164 = t3160 ** 2
            t3165 = t3161 * t3164
            t3170 = t3165 ** 2
            t3172 = -1463 * t3161 * t3170 - 35
            t3168 = t3164 ** 2
            t3163 = t3161 * t3160
            t3166 = t3163 ** 2
            t3162 = 7 * phi1
            t3155 = t3161 * t3166
            t3153 = t3161 * t3168
            tfunc[..., c] = (0.69e2 / 0.2048e4*1j) * np.sqrt((1 - t3161)) * np.sqrt(0.5e1) * ((1 + t3161) ** (-0.1e1 / 0.2e1)) * ((-4123 * t3170 - 475 * t3153 + 10431 * t3168 - 5418 * t3155 - 9086 * t3166 + 7098 * t3165 + 3150 * t3164 - 3101 * t3163 - 407 * t3160 + 433 * t3161 - t3172) * np.exp((1j) * (t3162 - 6 * phi2)) + (-7049 * t3170 - 10697 * t3153 + 209 * t3168 + 16058 * t3155 + 12390 * t3166 - 3794 * t3165 - 7742 * t3164 - 1491 * t3163 + 1203 * t3160 + 363 * t3161 + t3172) * np.exp((1j) * (t3162 + 6 * phi2)))

        if Bindx == 170:
            t3185 = np.cos(phi)
            t3184 = t3185 ** 2
            t3188 = t3184 ** 2
            t3187 = t3185 * t3184
            t3190 = t3187 ** 2
            t3192 = t3188 ** 2
            t3189 = t3185 * t3188
            t3194 = t3189 ** 2
            t3197 = -8 + 128 * t3184 - 448 * t3188 + 336 * t3190 + 328 * t3192 - 336 * t3194
            t3196 = 63 * t3187 - 574 * t3189 + (958 * t3190 - 383 * t3192 - 77 * t3194 + 13) * t3185
            t3186 = 4 * phi1
            tfunc[..., c] = -(0.69e2 / 0.1024e4) * ((-t3196 + t3197) * np.exp((2*1j) * (t3186 - 3 * phi2)) + (t3196 + t3197) * np.exp((2*1j) * (t3186 + 3 * phi2))) * np.sqrt(0.95e2)

        if Bindx == 171:
            t3209 = np.cos(phi)
            t3208 = t3209 ** 2
            t3212 = t3208 ** 2
            t3213 = t3209 * t3212
            t3219 = -231 * t3213 ** 2 - 61
            t3216 = t3212 ** 2
            t3211 = t3209 * t3208
            t3214 = t3211 ** 2
            t3210 = 3 * phi1
            t3203 = t3209 * t3214
            t3201 = t3209 * t3216
            tfunc[..., c] = (-0.23e2 / 0.2048e4*1j) * ((1 - t3209) ** (0.3e1 / 0.2e1)) * np.sqrt(0.57e2) * ((1 + t3209) ** (-0.1e1 / 0.2e1)) * ((-672 * t3201 - 23 * t3216 + 1688 * t3203 - 1058 * t3214 - 1352 * t3213 + 1322 * t3212 + 328 * t3211 - 533 * t3208 + 8 * t3209 - t3219) * np.exp((3*1j) * (t3210 - 2 * phi2)) + (-1596 * t3201 - 4513 * t3216 - 6368 * t3203 - 3766 * t3214 + 1288 * t3213 + 3374 * t3212 + 1792 * t3211 + 77 * t3208 - 236 * t3209 + t3219) * np.exp((3*1j) * (t3210 + 2 * phi2)))

        if Bindx == 172:
            t3232 = np.cos(phi)
            t3231 = t3232 ** 2
            t3235 = t3231 ** 2
            t3234 = t3232 * t3231
            t3237 = t3234 ** 2
            t3239 = t3235 ** 2
            t3236 = t3232 * t3235
            t3241 = t3236 ** 2
            t3244 = 6 + 12 * t3231 - 172 * t3235 + 224 * t3237 - 10 * t3239 - 60 * t3241
            t3243 = -95 * t3234 - 14 * t3236 + (202 * t3237 - 107 * t3239 - 11 * t3241 + 25) * t3232
            t3233 = 5 * phi1
            tfunc[..., c] = -(0.69e2 / 0.2048e4) * np.sqrt(0.2e1) * np.sqrt(0.133e3) * ((-t3243 + t3244) * np.exp((2*1j) * (t3233 - 3 * phi2)) + (t3243 + t3244) * np.exp((2*1j) * (t3233 + 3 * phi2)))

        if Bindx == 173:
            t3256 = np.cos(phi)
            t3268 = 6 * t3256
            t3255 = t3256 ** 2
            t3258 = t3256 * t3255
            t3259 = t3255 ** 2
            t3260 = t3256 * t3259
            t3261 = t3258 ** 2
            t3263 = t3259 ** 2
            t3267 = 8 * t3256 * t3261 + t3263 * t3268 + 8 * t3258 - 28 * t3260 + t3268
            t3266 = -t3260 ** 2 - 13 * t3255 + 14 * t3259 + 14 * t3261 - 13 * t3263 - 1
            t3257 = 11 * phi1
            tfunc[..., c] = (-0.69e2 / 0.2048e4*1j) * np.sqrt(0.1463e4) * np.sqrt((1 - t3256)) * np.sqrt((1 + t3256)) * ((t3266 + t3267) * np.exp((1j) * (t3257 - 6 * phi2)) + (-t3266 + t3267) * np.exp((1j) * (t3257 + 6 * phi2)))

        if Bindx == 174:
            t3273 = np.sin(phi)
            t3269 = t3273 ** 2
            t3270 = t3273 * t3269
            t3271 = t3270 ** 2
            tfunc[..., c] = (0.25e2 / 0.2048e4) * np.exp((-12*1j) * phi1) * np.sqrt(0.676039e6) * t3271 ** 2

        if Bindx == 175:
            t3286 = np.cos(phi)
            t3285 = t3286 ** 2
            t3289 = t3285 ** 2
            t3292 = t3289 ** 2
            t3290 = t3286 * t3289
            t3294 = t3290 ** 2
            t3295 = t3286 * t3294
            t3298 = t3286 * t3295 - 12 * t3285 + 27 * t3289 - 27 * t3292 + 12 * t3294 - 1
            t3297 = -6 * t3295 + 2 * (18 * t3285 - 18) * t3290 + 2 * (t3285 - t3292 + 3) * t3286
            t3287 = 2 * phi1
            tfunc[..., c] = (0.25e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.33649e5) * ((t3297 + t3298) * np.exp((-6*1j) * (t3287 - phi2)) + (-t3297 + t3298) * np.exp((-6*1j) * (t3287 + phi2)))

        if Bindx == 176:
            t3312 = np.cos(phi)
            t3325 = -12 * t3312
            t3311 = t3312 ** 2
            t3313 = t3312 * t3311
            t3314 = t3311 ** 2
            t3315 = t3312 * t3314
            t3316 = t3313 ** 2
            t3318 = t3314 ** 2
            t3320 = t3315 ** 2
            t3324 = t3320 * t3325 - 220 * t3313 - 792 * t3315 + t3325 + (-792 * t3316 - 220 * t3318) * t3312
            t3323 = 66 * t3311 + 495 * t3314 + 495 * t3318 + 66 * t3320 + 1 + (924 + t3316) * t3316
            tfunc[..., c] = (0.25e2 / 0.8192e4) * np.sqrt(0.2e1) * ((t3323 + t3324) * np.exp((-12*1j) * (phi1 - phi2)) + (t3323 - t3324) * np.exp((-12*1j) * (phi1 + phi2)))

        if Bindx == 177:
            t3326 = np.cos(phi)
            t3332 = -6 * t3326
            t3327 = t3326 ** 2
            t3328 = t3326 * t3327
            tfunc[..., c] = (0.25e2 / 0.1024e4*1j) * t3326 * (t3332 + 1 + (-20 + t3328) * t3328 + (15 + (t3332 + 15) * t3327) * t3327) * ((1 + t3326) ** (0.11e2 / 0.2e1)) * np.sqrt(0.4056234e7) * np.exp((-11*1j) * phi1) * ((1 - t3326) ** (-0.1e1 / 0.2e1))

        if Bindx == 178:
            t3344 = np.cos(phi)
            t3343 = t3344 ** 2
            t3347 = t3343 ** 2
            t3348 = t3344 * t3347
            t3355 = 2 * t3348 ** 2
            t3354 = 1 + t3344
            t3351 = t3347 ** 2
            t3346 = t3344 * t3343
            t3349 = t3346 ** 2
            t3345 = 11 * phi1
            t3338 = t3344 * t3349
            t3336 = t3344 * t3351
            tfunc[..., c] = (0.25e2 / 0.2048e4*1j) * (t3354 ** (0.5e1 / 0.2e1)) * np.sqrt(0.100947e6) * ((1 - t3344) ** (-0.1e1 / 0.2e1)) * ((t3355 - 17 * t3336 + 63 * t3351 - 132 * t3338 + 168 * t3349 - 126 * t3348 + 42 * t3347 + 12 * t3346 - 18 * t3343 + 7 * t3344 - 1) * np.exp((-1*1j) * (t3345 - 6 * phi2)) + (t3355 + 5 * t3336 - 3 * t3351 - 16 * t3338 - 4 * t3349 + 18 * t3348 + 10 * t3347 - 8 * t3346 - 6 * t3343 + t3354) * np.exp((-1*1j) * (t3345 + 6 * phi2)))

        if Bindx == 179:
            t3368 = np.cos(phi)
            t3367 = t3368 ** 2
            t3371 = t3367 ** 2
            t3370 = t3368 * t3367
            t3373 = t3370 ** 2
            t3375 = t3371 ** 2
            t3372 = t3368 * t3371
            t3377 = t3372 ** 2
            t3380 = -1 - 55 * t3367 - 330 * t3371 - 462 * t3373 - 165 * t3375 - 11 * t3377
            t3379 = 165 * t3370 + 462 * t3372 + (330 * t3373 + 55 * t3375 + t3377 + 11) * t3368
            t3369 = 11 * phi1
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.3e1) * np.sqrt((1 - t3368)) * np.sqrt((1 + t3368)) * ((t3379 + t3380) * np.exp((-1*1j) * (t3369 - 12 * phi2)) + (t3379 - t3380) * np.exp((-1*1j) * (t3369 + 12 * phi2)))

        if Bindx == 180:
            t3386 = np.sin(phi)
            t3382 = t3386 ** 2
            t3384 = t3386 * t3382 ** 2
            t3381 = np.cos(phi)
            tfunc[..., c] = -(0.25e2 / 0.1024e4) * np.exp((-10*1j) * phi1) * np.sqrt(0.88179e5) * t3384 ** 2 * (23 * t3381 ** 2 - 1)

        if Bindx == 181:
            t3400 = np.cos(phi)
            t3399 = t3400 ** 2
            t3402 = t3400 * t3399
            t3403 = t3399 ** 2
            t3404 = t3400 * t3403
            t3405 = t3402 ** 2
            t3407 = t3403 ** 2
            t3409 = t3404 ** 2
            t3413 = 121 * t3402 - 366 * t3404 + (282 * t3405 + 85 * t3407 - 115 * t3409 - 7) * t3400
            t3412 = -50 * t3399 + 45 * t3403 - 441 * t3407 + 166 * t3409 + 5 + (252 + 23 * t3405) * t3405
            t3401 = 5 * phi1
            tfunc[..., c] = (0.25e2 / 0.2048e4) * np.sqrt(0.2e1) * np.sqrt(0.4389e4) * ((t3412 + t3413) * np.exp((-2*1j) * (t3401 - 3 * phi2)) + (t3412 - t3413) * np.exp((-2*1j) * (t3401 + 3 * phi2)))

        if Bindx == 182:
            t3426 = np.cos(phi)
            t3425 = t3426 ** 2
            t3429 = t3425 ** 2
            t3432 = t3429 ** 2
            t3430 = t3426 * t3429
            t3434 = t3430 ** 2
            t3435 = t3426 * t3434
            t3438 = t3426 * t3435 - 44 * t3425 - 165 * t3429 + 165 * t3432 + 44 * t3434 - 1
            t3437 = -10 * t3435 + (-132 * t3425 + 132) * t3430 + (110 * t3425 - 110 * t3432 + 10) * t3426
            t3427 = 5 * phi1
            tfunc[..., c] = (0.25e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.69e2) * ((t3437 + t3438) * np.exp((-2*1j) * (t3427 - 6 * phi2)) + (-t3437 + t3438) * np.exp((-2*1j) * (t3427 + 6 * phi2)))

        if Bindx == 183:
            t3439 = np.cos(phi)
            tfunc[..., c] = (-0.25e2 / 0.1024e4*1j) * (23 * t3439 ** 2 - 3) * t3439 * ((1 + t3439) ** (0.9e1 / 0.2e1)) * np.sqrt(0.646646e6) * np.exp((-9*1j) * phi1) * ((1 - t3439) ** (0.9e1 / 0.2e1))

        if Bindx == 184:
            t3452 = np.cos(phi)
            t3451 = t3452 ** 2
            t3455 = t3451 ** 2
            t3456 = t3452 * t3455
            t3461 = t3456 ** 2
            t3463 = 506 * t3452 * t3461
            t3459 = t3455 ** 2
            t3454 = t3452 * t3451
            t3457 = t3454 ** 2
            t3453 = 3 * phi1
            t3446 = t3452 * t3457
            t3444 = t3452 * t3459
            tfunc[..., c] = (0.25e2 / 0.2048e4*1j) * ((1 + t3452) ** (0.3e1 / 0.2e1)) * np.sqrt(0.133e3) * ((1 - t3452) ** (-0.1e1 / 0.2e1)) * ((t3463 - 3289 * t3461 + 8426 * t3444 - 9687 * t3459 + 1860 * t3446 + 7350 * t3457 - 7308 * t3456 + 1314 * t3455 + 1602 * t3454 - 845 * t3451 + 34 * t3452 + 37) * np.exp((-3*1j) * (t3453 - 2 * phi2)) + (t3463 + 1265 * t3461 - 682 * t3444 - 3777 * t3459 - 852 * t3446 + 4098 * t3457 + 1908 * t3456 - 1962 * t3455 - 1062 * t3454 + 413 * t3451 + 182 * t3452 - 37) * np.exp((-3*1j) * (t3453 + 2 * phi2)))

        if Bindx == 185:
            t3476 = np.cos(phi)
            t3475 = t3476 ** 2
            t3479 = t3475 ** 2
            t3478 = t3476 * t3475
            t3481 = t3478 ** 2
            t3483 = t3479 ** 2
            t3480 = t3476 * t3479
            t3485 = t3480 ** 2
            t3488 = 1 + 35 * t3475 + 90 * t3479 - 42 * t3481 - 75 * t3483 - 9 * t3485
            t3487 = -75 * t3478 - 42 * t3480 + (90 * t3481 + 35 * t3483 + t3485 - 9) * t3476
            t3477 = 3 * phi1
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.253e3) * np.sqrt((1 - t3476)) * np.sqrt((1 + t3476)) * ((t3487 + t3488) * np.exp((-3*1j) * (t3477 - 4 * phi2)) + (t3487 - t3488) * np.exp((-3*1j) * (t3477 + 4 * phi2)))

        if Bindx == 186:
            t3495 = np.sin(phi)
            t3492 = t3495 ** 2
            t3493 = t3492 ** 2
            t3489 = np.cos(phi)
            t3490 = t3489 ** 2
            tfunc[..., c] = (0.25e2 / 0.2048e4) * np.exp((-8*1j) * phi1) * np.sqrt(0.277134e6) * t3493 ** 2 * (1 + (-42 + 161 * t3490) * t3490)

        if Bindx == 187:
            t3509 = np.cos(phi)
            t3508 = t3509 ** 2
            t3511 = t3509 * t3508
            t3512 = t3508 ** 2
            t3513 = t3509 * t3512
            t3514 = t3511 ** 2
            t3516 = t3512 ** 2
            t3518 = t3513 ** 2
            t3522 = 3332 * t3511 - 6888 * t3513 + (-408 * t3514 + 11452 * t3516 - 7084 * t3518 - 404) * t3509
            t3521 = 532 * t3508 - 5607 * t3512 - 20337 * t3516 + 5852 * t3518 - 19 + (17808 + 1771 * t3514) * t3514
            t3510 = 4 * phi1
            tfunc[..., c] = (0.25e2 / 0.2048e4) * ((t3521 + t3522) * np.exp((-2*1j) * (t3510 - 3 * phi2)) + (t3521 - t3522) * np.exp((-2*1j) * (t3510 + 3 * phi2))) * np.sqrt(0.57e2)

        if Bindx == 188:
            t3536 = np.cos(phi)
            t3535 = t3536 ** 2
            t3538 = t3536 * t3535
            t3539 = t3535 ** 2
            t3540 = t3536 * t3539
            t3541 = t3538 ** 2
            t3543 = t3539 ** 2
            t3545 = t3540 ** 2
            t3549 = -40 * t3538 + 48 * t3540 + 8 * (6 * t3541 - 5 * t3543 - t3545 - 1) * t3536
            t3548 = 26 * t3535 + 15 * t3539 + 15 * t3543 + 26 * t3545 + 1 + (-84 + t3541) * t3541
            t3537 = 2 * phi1
            tfunc[..., c] = (0.25e2 / 0.4096e4) * ((t3548 + t3549) * np.exp((-4*1j) * (t3537 - 3 * phi2)) + (t3548 - t3549) * np.exp((-4*1j) * (t3537 + 3 * phi2))) * np.sqrt(0.5313e4)

        if Bindx == 189:
            t3550 = np.cos(phi)
            t3551 = t3550 ** 2
            tfunc[..., c] = (0.25e2 / 0.1024e4*1j) * (5 + (-70 + 161 * t3551) * t3551) * t3550 * ((1 + t3550) ** (0.7e1 / 0.2e1)) * np.sqrt(0.277134e6) * np.exp((-7*1j) * phi1) * ((1 - t3550) ** (0.7e1 / 0.2e1))

        if Bindx == 190:
            t3566 = np.cos(phi)
            t3565 = t3566 ** 2
            t3568 = t3566 * t3565
            t3571 = t3568 ** 2
            t3578 = 3542 * t3571 ** 2
            t3569 = t3565 ** 2
            t3570 = t3566 * t3569
            t3575 = t3570 ** 2
            t3573 = t3569 ** 2
            t3567 = 7 * phi1
            t3560 = t3566 * t3571
            t3558 = t3566 * t3573
            t3556 = t3566 * t3575
            tfunc[..., c] = (0.25e2 / 0.2048e4*1j) * np.sqrt((1 + t3566)) * np.sqrt(0.57e2) * ((1 - t3566) ** (-0.1e1 / 0.2e1)) * ((t3578 - 15939 * t3556 + 20097 * t3575 + 10675 * t3558 - 42195 * t3573 + 19074 * t3560 + 21882 * t3571 - 19866 * t3570 - 1680 * t3569 + 5425 * t3568 - 651 * t3565 - 393 * t3566 + 29) * np.exp((-1*1j) * (t3567 - 6 * phi2)) + (t3578 + 8855 * t3556 - 4697 * t3575 - 26075 * t3558 - 5445 * t3573 + 28566 * t3560 + 12390 * t3571 - 14406 * t3570 - 7140 * t3569 + 3395 * t3568 + 1379 * t3565 - 335 * t3566 - 29) * np.exp((-1*1j) * (t3567 + 6 * phi2)))

        if Bindx == 191:
            t3591 = np.cos(phi)
            t3590 = t3591 ** 2
            t3594 = t3590 ** 2
            t3593 = t3591 * t3590
            t3596 = t3593 ** 2
            t3598 = t3594 ** 2
            t3595 = t3591 * t3594
            t3600 = t3595 ** 2
            t3603 = -1 - 19 * t3590 + 6 * t3594 + 42 * t3596 - 21 * t3598 - 7 * t3600
            t3602 = 21 * t3593 - 42 * t3595 + (-6 * t3596 + 19 * t3598 + t3600 + 7) * t3591
            t3592 = 7 * phi1
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.5313e4) * np.sqrt((1 - t3591)) * np.sqrt((1 + t3591)) * ((t3602 + t3603) * np.exp((-1*1j) * (t3592 - 12 * phi2)) + (t3602 - t3603) * np.exp((-1*1j) * (t3592 + 12 * phi2)))

        if Bindx == 192:
            t3611 = np.sin(phi)
            t3608 = t3611 ** 2
            t3609 = t3611 * t3608
            t3604 = np.cos(phi)
            t3605 = t3604 ** 2
            t3606 = t3605 ** 2
            tfunc[..., c] = -(0.25e2 / 0.1024e4) * np.exp((-6*1j) * phi1) * np.sqrt(0.2431e4) * t3609 ** 2 * (-1995 * t3606 - 5 + (3059 * t3606 + 285) * t3605)

        if Bindx == 193:
            t3625 = np.cos(phi)
            t3624 = t3625 ** 2
            t3627 = t3624 ** 2
            t3626 = t3625 * t3624
            t3629 = t3626 ** 2
            t3631 = t3627 ** 2
            t3628 = t3625 * t3627
            t3633 = t3628 ** 2
            t3637 = 11298 * t3624 - 75285 * t3627 - 158175 * t3631 + 8778 * t3633 - 269 + (180516 + 33649 * t3629) * t3629
            t3636 = -2695 * t3626 + 49266 * t3628 + (-178182 * t3629 + 232085 * t3631 - 100947 * t3633 - 39) * t3625
            tfunc[..., c] = (0.25e2 / 0.2048e4) * np.sqrt(0.2e1) * ((t3636 + t3637) * np.exp((-6*1j) * (phi1 - phi2)) + (-t3636 + t3637) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 194:
            t3650 = np.cos(phi)
            t3649 = t3650 ** 2
            t3652 = t3649 ** 2
            t3655 = t3652 ** 2
            t3653 = t3650 * t3652
            t3657 = t3653 ** 2
            t3658 = t3650 * t3657
            t3661 = t3650 * t3658 - 12 * t3649 + 27 * t3652 - 27 * t3655 + 12 * t3657 - 1
            t3660 = -6 * t3658 + 2 * (18 * t3649 - 18) * t3653 + 2 * (t3649 - t3655 + 3) * t3650
            tfunc[..., c] = (0.25e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.33649e5) * ((t3660 + t3661) * np.exp((-6*1j) * (phi1 - 2 * phi2)) + (-t3660 + t3661) * np.exp((-6*1j) * (phi1 + 2 * phi2)))

        if Bindx == 195:
            t3662 = np.cos(phi)
            t3663 = t3662 ** 2
            t3664 = t3663 ** 2
            tfunc[..., c] = (-0.75e2 / 0.1024e4*1j) * (-399 * t3664 - 5 + (437 * t3664 + 95) * t3663) * t3662 * ((1 + t3662) ** (0.5e1 / 0.2e1)) * np.sqrt(0.34034e5) * np.exp((-5*1j) * phi1) * ((1 - t3662) ** (0.5e1 / 0.2e1))

        if Bindx == 196:
            t3680 = np.cos(phi)
            t3679 = t3680 ** 2
            t3683 = t3679 ** 2
            t3682 = t3680 * t3679
            t3685 = t3682 ** 2
            t3687 = t3683 ** 2
            t3684 = t3680 * t3683
            t3689 = t3684 ** 2
            t3691 = t3685 ** 2
            t3694 = -25 + 1200 * t3679 - 11465 * t3683 + 45592 * t3685 - 84987 * t3687 + 73720 * t3689 - 24035 * t3691
            t3693 = 5958 * t3682 - 24450 * t3684 + (37500 * t3685 - 14440 * t3687 - 13794 * t3689 + 9614 * t3691 - 388) * t3680
            t3681 = 5 * phi1
            tfunc[..., c] = (0.75e2 / 0.2048e4*1j) * np.sqrt(0.7e1) * ((1 + t3680) ** (-0.1e1 / 0.2e1)) * ((1 - t3680) ** (-0.1e1 / 0.2e1)) * ((t3693 + t3694) * np.exp((-1*1j) * (t3681 - 6 * phi2)) + (t3693 - t3694) * np.exp((-1*1j) * (t3681 + 6 * phi2)))

        if Bindx == 197:
            t3707 = np.cos(phi)
            t3706 = t3707 ** 2
            t3710 = t3706 ** 2
            t3709 = t3707 * t3706
            t3712 = t3709 ** 2
            t3714 = t3710 ** 2
            t3711 = t3707 * t3710
            t3716 = t3711 ** 2
            t3719 = 1 + 7 * t3706 - 22 * t3710 + 14 * t3712 + 5 * t3714 - 5 * t3716
            t3718 = 5 * t3709 + 14 * t3711 + (-22 * t3712 + 7 * t3714 + t3716 - 5) * t3707
            t3708 = 5 * phi1
            tfunc[..., c] = (-0.75e2 / 0.2048e4*1j) * np.sqrt(0.4807e4) * np.sqrt((1 - t3707)) * np.sqrt((1 + t3707)) * ((t3718 + t3719) * np.exp((-1*1j) * (t3708 - 12 * phi2)) + (t3718 - t3719) * np.exp((-1*1j) * (t3708 + 12 * phi2)))

        if Bindx == 198:
            t3727 = np.sin(phi)
            t3725 = t3727 ** 2
            t3720 = np.cos(phi)
            t3721 = t3720 ** 2
            t3722 = t3721 ** 2
            tfunc[..., c] = (0.75e2 / 0.2048e4) * np.exp((-4*1j) * phi1) * np.sqrt(0.1001e4) * t3725 ** 2 * (-340 * t3721 + 5 + (-9044 * t3721 + 3230 + 7429 * t3722) * t3722)

        if Bindx == 199:
            t3741 = np.cos(phi)
            t3740 = t3741 ** 2
            t3743 = t3741 * t3740
            t3744 = t3740 ** 2
            t3745 = t3741 * t3744
            t3746 = t3743 ** 2
            t3748 = t3744 ** 2
            t3750 = t3745 ** 2
            t3754 = -2470 * t3743 + 12588 * t3745 + (-27436 * t3746 + 26790 * t3748 - 9614 * t3750 + 142) * t3741
            t3753 = 364 * t3740 - 2435 * t3744 + 2755 * t3748 - 9196 * t3750 - 7 + (3712 + 4807 * t3746) * t3746
            t3742 = 2 * phi1
            tfunc[..., c] = (0.75e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.119e3) * ((t3753 + t3754) * np.exp((-2*1j) * (t3742 - 3 * phi2)) + (t3753 - t3754) * np.exp((-2*1j) * (t3742 + 3 * phi2)))

        if Bindx == 200:
            t3768 = np.cos(phi)
            t3767 = t3768 ** 2
            t3769 = t3768 * t3767
            t3770 = t3767 ** 2
            t3771 = t3768 * t3770
            t3772 = t3769 ** 2
            t3774 = t3770 ** 2
            t3776 = t3771 ** 2
            t3780 = 12 * t3769 - 8 * t3771 + 4 * (-2 * t3772 + 3 * t3774 - t3776 - 1) * t3768
            t3779 = 2 * t3767 - 17 * t3770 - 17 * t3774 + 2 * t3776 + 1 + (28 + t3772) * t3772
            tfunc[..., c] = (0.75e2 / 0.8192e4) * np.sqrt(0.2e1) * np.sqrt(0.81719e5) * ((t3779 + t3780) * np.exp((-4*1j) * (phi1 - 3 * phi2)) + (t3779 - t3780) * np.exp((-4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 201:
            t3781 = np.cos(phi)
            t3782 = t3781 ** 2
            t3783 = t3782 ** 2
            tfunc[..., c] = (0.25e2 / 0.512e3*1j) * (-1020 * t3782 + 45 + (-11628 * t3782 + 5814 + 7429 * t3783) * t3783) * t3781 * ((1 + t3781) ** (0.3e1 / 0.2e1)) * np.sqrt(0.1001e4) * np.exp((-3*1j) * phi1) * ((1 - t3781) ** (0.3e1 / 0.2e1))

        if Bindx == 202:
            t3800 = np.cos(phi)
            t3799 = t3800 ** 2
            t3802 = t3799 ** 2
            t3801 = t3800 * t3799
            t3804 = t3801 ** 2
            t3806 = t3802 ** 2
            t3803 = t3800 * t3802
            t3808 = t3803 ** 2
            t3810 = t3804 ** 2
            t3813 = -23 + 1288 * t3799 - 11855 * t3802 + 40952 * t3804 - 65797 * t3806 + 49856 * t3808 - 14421 * t3810
            t3812 = -362 * t3801 + 4222 * t3803 + (-18692 * t3804 + 35720 * t3806 - 30514 * t3808 + 9614 * t3810 + 12) * t3800
            tfunc[..., c] = (0.25e2 / 0.2048e4*1j) * np.sqrt(0.119e3) * np.sqrt(0.2e1) * ((1 + t3800) ** (-0.1e1 / 0.2e1)) * ((1 - t3800) ** (-0.1e1 / 0.2e1)) * ((t3812 + t3813) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t3812 - t3813) * np.exp((-3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 203:
            t3826 = np.cos(phi)
            t3825 = t3826 ** 2
            t3828 = t3825 ** 2
            t3827 = t3826 * t3825
            t3830 = t3827 ** 2
            t3832 = t3828 ** 2
            t3829 = t3826 * t3828
            t3834 = t3829 ** 2
            t3837 = -1 + t3825 + 6 * t3828 - 14 * t3830 + 11 * t3832 - 3 * t3834
            t3836 = -11 * t3827 + 14 * t3829 + (-6 * t3830 - t3832 + t3834 + 3) * t3826
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.81719e5) * np.sqrt((1 - t3826)) * np.sqrt((1 + t3826)) * ((t3836 + t3837) * np.exp((-3*1j) * (phi1 - 4 * phi2)) + (t3836 - t3837) * np.exp((-3*1j) * (phi1 + 4 * phi2)))

        if Bindx == 204:
            t3839 = np.cos(phi)
            t3840 = t3839 ** 2
            t3841 = t3840 ** 2
            t3843 = t3841 ** 2
            t3838 = np.sin(phi)
            tfunc[..., c] = -(0.25e2 / 0.1024e4) * np.exp((-2*1j) * phi1) * np.sqrt(0.6006e4) * t3838 ** 2 * (-2550 * t3841 - 14535 * t3843 - 3 + (9690 * t3841 + 7429 * t3843 + 225) * t3840)

        if Bindx == 205:
            t3858 = np.cos(phi)
            t3857 = t3858 ** 2
            t3859 = t3858 * t3857
            t3860 = t3857 ** 2
            t3861 = t3858 * t3860
            t3862 = t3859 ** 2
            t3864 = t3860 ** 2
            t3866 = t3861 ** 2
            t3870 = -1595 * t3859 + 8122 * t3861 + (-16606 * t3862 + 14801 * t3864 - 4807 * t3866 + 85) * t3858
            t3869 = -290 * t3857 + 2845 * t3860 + 18791 * t3864 - 15466 * t3866 + 5 + (-10692 + 4807 * t3862) * t3862
            tfunc[..., c] = (0.25e2 / 0.1024e4) * ((t3869 + t3870) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t3869 - t3870) * np.exp((-2*1j) * (phi1 + 3 * phi2))) * np.sqrt(0.357e3)

        if Bindx == 206:
            t3883 = np.cos(phi)
            t3882 = t3883 ** 2
            t3885 = t3882 ** 2
            t3895 = 5 * t3885 ** 2
            t3886 = t3883 * t3885
            t3890 = t3886 ** 2
            t3891 = t3883 * t3890
            t3894 = t3883 * t3891 + 4 * t3882 - 5 * t3885 - 4 * t3890 + t3895 - 1
            t3893 = 2 * t3883 * t3895 + 2 * t3883 + 20 * t3886 - 2 * t3891 + 2 * (-5 * t3883 - 10 * t3886) * t3882
            tfunc[..., c] = (0.25e2 / 0.2048e4) * ((t3893 + t3894) * np.exp((-2*1j) * (phi1 - 6 * phi2)) + (-t3893 + t3894) * np.exp((-2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.245157e6)

        if Bindx == 207:
            t3896 = np.cos(phi)
            t3897 = t3896 ** 2
            t3898 = t3896 * t3897
            t3899 = t3897 ** 2
            t3900 = t3896 * t3899
            t3907 = 106590 * t3898 ** 2 - 124355 * t3899 ** 2 + 52003 * t3900 ** 2 - 231
            tfunc[..., c] = (0.25e2 / 0.512e3*1j) * np.exp((-1*1j) * phi1) * np.sqrt(0.39e2) * np.sqrt((1 + t3896)) * t3896 * (t3907 * t3896 - 5775 * t3897 + 5775 * t3898 + 39270 * t3899 - 39270 * t3900 - t3907) * ((1 - t3896) ** (-0.1e1 / 0.2e1))

        if Bindx == 208:
            t3922 = np.cos(phi)
            t3921 = t3922 ** 2
            t3924 = t3921 ** 2
            t3923 = t3922 * t3921
            t3926 = t3923 ** 2
            t3928 = t3924 ** 2
            t3925 = t3922 * t3924
            t3930 = t3925 ** 2
            t3932 = t3926 ** 2
            t3935 = -5 + 300 * t3921 - 2865 * t3924 + 9904 * t3926 - 15447 * t3928 + 11172 * t3930 - 3059 * t3932
            t3934 = -2010 * t3923 + 11814 * t3925 + (-30500 * t3926 + 39216 * t3928 - 24738 * t3930 + 6118 * t3932 + 100) * t3922
            tfunc[..., c] = (0.25e2 / 0.2048e4*1j) * np.sqrt(0.561e3) * np.sqrt(0.2e1) * ((1 + t3922) ** (-0.1e1 / 0.2e1)) * ((1 - t3922) ** (-0.1e1 / 0.2e1)) * ((t3934 + t3935) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (t3934 - t3935) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 209:
            t3948 = np.cos(phi)
            t3947 = t3948 ** 2
            t3949 = t3948 * t3947
            t3950 = t3947 ** 2
            t3951 = t3948 * t3950
            t3960 = 10 * t3949 ** 2 - 5 * t3950 ** 2 + t3951 ** 2 - 1
            t3959 = -5 * t3947 + 10 * t3950 - t3960
            t3958 = t3960 * t3948 + 5 * t3949 - 10 * t3951
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.156009e6) * np.sqrt((1 - t3948)) * np.sqrt((1 + t3948)) * ((t3958 + t3959) * np.exp((-1*1j) * (phi1 - 12 * phi2)) + (t3958 - t3959) * np.exp((-1*1j) * (phi1 + 12 * phi2)))

        if Bindx == 210:
            t3961 = np.cos(phi)
            t3962 = t3961 ** 2
            t3963 = t3962 ** 2
            t3965 = t3963 ** 2
            t3964 = t3962 * t3963
            tfunc[..., c] = 0.51962625e8 / 0.1024e4 * t3965 + 0.5630625e7 / 0.1024e4 * t3963 + 0.5775e4 / 0.1024e4 + (-0.6381375e7 / 0.256e3 + 0.16900975e8 / 0.1024e4 * t3964) * t3964 + (-0.24249225e8 / 0.512e3 * t3965 - 0.225225e6 / 0.512e3) * t3962

        if Bindx == 211:
            t3968 = np.cos(phi)
            t3969 = t3968 ** 2
            t3970 = t3969 ** 2
            t3972 = t3970 ** 2
            t3971 = t3969 * t3970
            tfunc[..., c] = 0.25e2 / 0.1024e4 * np.sqrt(0.2431e4) * np.sqrt(0.2e1) * (2865 * t3970 + 15447 * t3972 + 5 + (-9904 + 3059 * t3971) * t3971 + (-11172 * t3972 - 300) * t3969) * np.cos((6 * phi2))

        if Bindx == 212:
            t3975 = np.cos(phi)
            t3976 = t3975 ** 2
            t3982 = -6 * t3976
            t3977 = t3976 ** 2
            t3978 = t3976 * t3977
            tfunc[..., c] = 0.25e2 / 0.2048e4 * np.sqrt(0.676039e6) * np.sqrt(0.2e1) * np.cos((12 * phi2)) * (t3982 + 1 + (-20 + t3978) * t3978 + (15 + (t3982 + 15) * t3977) * t3977)

        if Bindx == 213:
            t3983 = np.cos(phi)
            t3984 = t3983 ** 2
            t3985 = t3984 ** 2
            t3987 = t3985 ** 2
            tfunc[..., c] = (-0.25e2 / 0.512e3*1j) * np.exp((1j) * phi1) * np.sqrt(0.39e2) * np.sqrt((1 - t3983)) * np.sqrt((1 + t3983)) * t3983 * (-39270 * t3985 - 124355 * t3987 - 231 + (106590 * t3985 + 52003 * t3987 + 5775) * t3984)

        if Bindx == 214:
            t4003 = np.cos(phi)
            t4002 = t4003 ** 2
            t4005 = t4002 ** 2
            t4004 = t4003 * t4002
            t4007 = t4004 ** 2
            t4009 = t4005 ** 2
            t4006 = t4003 * t4005
            t4011 = t4006 ** 2
            t4013 = t4007 ** 2
            t4016 = -5 + 300 * t4002 - 2865 * t4005 + 9904 * t4007 - 15447 * t4009 + 11172 * t4011 - 3059 * t4013
            t4015 = -2010 * t4004 + 11814 * t4006 + (-30500 * t4007 + 39216 * t4009 - 24738 * t4011 + 6118 * t4013 + 100) * t4003
            tfunc[..., c] = (0.25e2 / 0.2048e4*1j) * np.sqrt(0.561e3) * np.sqrt(0.2e1) * ((1 + t4003) ** (-0.1e1 / 0.2e1)) * ((1 - t4003) ** (-0.1e1 / 0.2e1)) * ((t4015 + t4016) * np.exp((1j) * (phi1 - 6 * phi2)) + (t4015 - t4016) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 215:
            t4029 = np.cos(phi)
            t4028 = t4029 ** 2
            t4030 = t4029 * t4028
            t4031 = t4028 ** 2
            t4032 = t4029 * t4031
            t4041 = 10 * t4030 ** 2 - 5 * t4031 ** 2 + t4032 ** 2 - 1
            t4040 = -5 * t4028 + 10 * t4031 - t4041
            t4039 = t4041 * t4029 + 5 * t4030 - 10 * t4032
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.156009e6) * np.sqrt((1 - t4029)) * np.sqrt((1 + t4029)) * ((t4039 + t4040) * np.exp((1j) * (phi1 - 12 * phi2)) + (t4039 - t4040) * np.exp((1j) * (phi1 + 12 * phi2)))

        if Bindx == 216:
            t4043 = np.cos(phi)
            t4044 = t4043 ** 2
            t4045 = t4044 ** 2
            t4047 = t4045 ** 2
            t4042 = np.sin(phi)
            tfunc[..., c] = -(0.25e2 / 0.1024e4) * np.exp((2*1j) * phi1) * np.sqrt(0.6006e4) * t4042 ** 2 * (-2550 * t4045 - 14535 * t4047 - 3 + (9690 * t4045 + 7429 * t4047 + 225) * t4044)

        if Bindx == 217:
            t4062 = np.cos(phi)
            t4061 = t4062 ** 2
            t4063 = t4062 * t4061
            t4064 = t4061 ** 2
            t4065 = t4062 * t4064
            t4066 = t4063 ** 2
            t4068 = t4064 ** 2
            t4070 = t4065 ** 2
            t4074 = -1595 * t4063 + 8122 * t4065 + (-16606 * t4066 + 14801 * t4068 - 4807 * t4070 + 85) * t4062
            t4073 = -290 * t4061 + 2845 * t4064 + 18791 * t4068 - 15466 * t4070 + 5 + (-10692 + 4807 * t4066) * t4066
            tfunc[..., c] = (0.25e2 / 0.1024e4) * ((t4073 + t4074) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t4073 - t4074) * np.exp((2*1j) * (phi1 + 3 * phi2))) * np.sqrt(0.357e3)

        if Bindx == 218:
            t4087 = np.cos(phi)
            t4086 = t4087 ** 2
            t4089 = t4086 ** 2
            t4099 = 5 * t4089 ** 2
            t4090 = t4087 * t4089
            t4094 = t4090 ** 2
            t4095 = t4087 * t4094
            t4098 = t4087 * t4095 + 4 * t4086 - 5 * t4089 - 4 * t4094 + t4099 - 1
            t4097 = 2 * t4087 * t4099 + 2 * t4087 + 20 * t4090 - 2 * t4095 + 2 * (-5 * t4087 - 10 * t4090) * t4086
            tfunc[..., c] = (0.25e2 / 0.2048e4) * ((t4097 + t4098) * np.exp((2*1j) * (phi1 - 6 * phi2)) + (-t4097 + t4098) * np.exp((2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.245157e6)

        if Bindx == 219:
            t4100 = np.cos(phi)
            t4101 = t4100 ** 2
            t4102 = t4101 ** 2
            tfunc[..., c] = (0.25e2 / 0.512e3*1j) * np.exp((3*1j) * phi1) * np.sqrt(0.1001e4) * ((1 - t4100) ** (0.3e1 / 0.2e1)) * ((1 + t4100) ** (0.3e1 / 0.2e1)) * t4100 * (-1020 * t4101 + 45 + (-11628 * t4101 + 5814 + 7429 * t4102) * t4102)

        if Bindx == 220:
            t4119 = np.cos(phi)
            t4118 = t4119 ** 2
            t4121 = t4118 ** 2
            t4120 = t4119 * t4118
            t4123 = t4120 ** 2
            t4125 = t4121 ** 2
            t4122 = t4119 * t4121
            t4127 = t4122 ** 2
            t4129 = t4123 ** 2
            t4132 = -23 + 1288 * t4118 - 11855 * t4121 + 40952 * t4123 - 65797 * t4125 + 49856 * t4127 - 14421 * t4129
            t4131 = -362 * t4120 + 4222 * t4122 + (-18692 * t4123 + 35720 * t4125 - 30514 * t4127 + 9614 * t4129 + 12) * t4119
            tfunc[..., c] = (0.25e2 / 0.2048e4*1j) * np.sqrt(0.119e3) * np.sqrt(0.2e1) * ((1 + t4119) ** (-0.1e1 / 0.2e1)) * ((1 - t4119) ** (-0.1e1 / 0.2e1)) * ((t4131 + t4132) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t4131 - t4132) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 221:
            t4145 = np.cos(phi)
            t4144 = t4145 ** 2
            t4147 = t4144 ** 2
            t4146 = t4145 * t4144
            t4149 = t4146 ** 2
            t4151 = t4147 ** 2
            t4148 = t4145 * t4147
            t4153 = t4148 ** 2
            t4156 = -1 + t4144 + 6 * t4147 - 14 * t4149 + 11 * t4151 - 3 * t4153
            t4155 = -11 * t4146 + 14 * t4148 + (-6 * t4149 - t4151 + t4153 + 3) * t4145
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.81719e5) * np.sqrt((1 - t4145)) * np.sqrt((1 + t4145)) * ((t4155 + t4156) * np.exp((3*1j) * (phi1 - 4 * phi2)) + (t4155 - t4156) * np.exp((3*1j) * (phi1 + 4 * phi2)))

        if Bindx == 222:
            t4164 = np.sin(phi)
            t4162 = t4164 ** 2
            t4157 = np.cos(phi)
            t4158 = t4157 ** 2
            t4159 = t4158 ** 2
            tfunc[..., c] = (0.75e2 / 0.2048e4) * np.exp((4*1j) * phi1) * np.sqrt(0.1001e4) * t4162 ** 2 * (-340 * t4158 + 5 + (-9044 * t4158 + 3230 + 7429 * t4159) * t4159)

        if Bindx == 223:
            t4178 = np.cos(phi)
            t4177 = t4178 ** 2
            t4180 = t4178 * t4177
            t4181 = t4177 ** 2
            t4182 = t4178 * t4181
            t4183 = t4180 ** 2
            t4185 = t4181 ** 2
            t4187 = t4182 ** 2
            t4191 = -2470 * t4180 + 12588 * t4182 + (-27436 * t4183 + 26790 * t4185 - 9614 * t4187 + 142) * t4178
            t4190 = 364 * t4177 - 2435 * t4181 + 2755 * t4185 - 9196 * t4187 - 7 + (3712 + 4807 * t4183) * t4183
            t4179 = 2 * phi1
            tfunc[..., c] = (0.75e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.119e3) * ((t4190 + t4191) * np.exp((2*1j) * (t4179 - 3 * phi2)) + (t4190 - t4191) * np.exp((2*1j) * (t4179 + 3 * phi2)))

        if Bindx == 224:
            t4205 = np.cos(phi)
            t4204 = t4205 ** 2
            t4206 = t4205 * t4204
            t4207 = t4204 ** 2
            t4208 = t4205 * t4207
            t4209 = t4206 ** 2
            t4211 = t4207 ** 2
            t4213 = t4208 ** 2
            t4217 = 12 * t4206 - 8 * t4208 + 4 * (-2 * t4209 + 3 * t4211 - t4213 - 1) * t4205
            t4216 = 2 * t4204 - 17 * t4207 - 17 * t4211 + 2 * t4213 + 1 + (28 + t4209) * t4209
            tfunc[..., c] = (0.75e2 / 0.8192e4) * np.sqrt(0.2e1) * np.sqrt(0.81719e5) * ((t4216 + t4217) * np.exp((4*1j) * (phi1 - 3 * phi2)) + (t4216 - t4217) * np.exp((4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 225:
            t4218 = np.cos(phi)
            t4219 = t4218 ** 2
            t4220 = t4219 ** 2
            tfunc[..., c] = (-0.75e2 / 0.1024e4*1j) * np.exp((5*1j) * phi1) * np.sqrt(0.34034e5) * ((1 - t4218) ** (0.5e1 / 0.2e1)) * ((1 + t4218) ** (0.5e1 / 0.2e1)) * t4218 * (-399 * t4220 - 5 + (437 * t4220 + 95) * t4219)

        if Bindx == 226:
            t4236 = np.cos(phi)
            t4235 = t4236 ** 2
            t4239 = t4235 ** 2
            t4238 = t4236 * t4235
            t4241 = t4238 ** 2
            t4243 = t4239 ** 2
            t4240 = t4236 * t4239
            t4245 = t4240 ** 2
            t4247 = t4241 ** 2
            t4250 = -25 + 1200 * t4235 - 11465 * t4239 + 45592 * t4241 - 84987 * t4243 + 73720 * t4245 - 24035 * t4247
            t4249 = 5958 * t4238 - 24450 * t4240 + (37500 * t4241 - 14440 * t4243 - 13794 * t4245 + 9614 * t4247 - 388) * t4236
            t4237 = 5 * phi1
            tfunc[..., c] = (0.75e2 / 0.2048e4*1j) * np.sqrt(0.7e1) * ((1 + t4236) ** (-0.1e1 / 0.2e1)) * ((1 - t4236) ** (-0.1e1 / 0.2e1)) * ((t4249 + t4250) * np.exp((1j) * (t4237 - 6 * phi2)) + (t4249 - t4250) * np.exp((1j) * (t4237 + 6 * phi2)))

        if Bindx == 227:
            t4263 = np.cos(phi)
            t4262 = t4263 ** 2
            t4266 = t4262 ** 2
            t4265 = t4263 * t4262
            t4268 = t4265 ** 2
            t4270 = t4266 ** 2
            t4267 = t4263 * t4266
            t4272 = t4267 ** 2
            t4275 = 1 + 7 * t4262 - 22 * t4266 + 14 * t4268 + 5 * t4270 - 5 * t4272
            t4274 = 5 * t4265 + 14 * t4267 + (-22 * t4268 + 7 * t4270 + t4272 - 5) * t4263
            t4264 = 5 * phi1
            tfunc[..., c] = (-0.75e2 / 0.2048e4*1j) * np.sqrt(0.4807e4) * np.sqrt((1 - t4263)) * np.sqrt((1 + t4263)) * ((t4274 + t4275) * np.exp((1j) * (t4264 - 12 * phi2)) + (t4274 - t4275) * np.exp((1j) * (t4264 + 12 * phi2)))

        if Bindx == 228:
            t4283 = np.sin(phi)
            t4280 = t4283 ** 2
            t4281 = t4283 * t4280
            t4276 = np.cos(phi)
            t4277 = t4276 ** 2
            t4278 = t4277 ** 2
            tfunc[..., c] = -(0.25e2 / 0.1024e4) * np.exp((6*1j) * phi1) * np.sqrt(0.2431e4) * t4281 ** 2 * (-1995 * t4278 - 5 + (3059 * t4278 + 285) * t4277)

        if Bindx == 229:
            t4297 = np.cos(phi)
            t4296 = t4297 ** 2
            t4299 = t4296 ** 2
            t4298 = t4297 * t4296
            t4301 = t4298 ** 2
            t4303 = t4299 ** 2
            t4300 = t4297 * t4299
            t4305 = t4300 ** 2
            t4309 = 11298 * t4296 - 75285 * t4299 - 158175 * t4303 + 8778 * t4305 - 269 + (180516 + 33649 * t4301) * t4301
            t4308 = -2695 * t4298 + 49266 * t4300 + (-178182 * t4301 + 232085 * t4303 - 100947 * t4305 - 39) * t4297
            tfunc[..., c] = (0.25e2 / 0.2048e4) * np.sqrt(0.2e1) * ((t4308 + t4309) * np.exp((6*1j) * (phi1 - phi2)) + (-t4308 + t4309) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 230:
            t4322 = np.cos(phi)
            t4321 = t4322 ** 2
            t4324 = t4321 ** 2
            t4327 = t4324 ** 2
            t4325 = t4322 * t4324
            t4329 = t4325 ** 2
            t4330 = t4322 * t4329
            t4333 = t4322 * t4330 - 12 * t4321 + 27 * t4324 - 27 * t4327 + 12 * t4329 - 1
            t4332 = -6 * t4330 + 2 * (18 * t4321 - 18) * t4325 + 2 * (t4321 - t4327 + 3) * t4322
            tfunc[..., c] = (0.25e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.33649e5) * ((t4332 + t4333) * np.exp((6*1j) * (phi1 - 2 * phi2)) + (-t4332 + t4333) * np.exp((6*1j) * (phi1 + 2 * phi2)))

        if Bindx == 231:
            t4334 = np.cos(phi)
            t4335 = t4334 ** 2
            tfunc[..., c] = (0.25e2 / 0.1024e4*1j) * np.exp((7*1j) * phi1) * np.sqrt(0.277134e6) * ((1 - t4334) ** (0.7e1 / 0.2e1)) * ((1 + t4334) ** (0.7e1 / 0.2e1)) * t4334 * (5 + (-70 + 161 * t4335) * t4335)

        if Bindx == 232:
            t4350 = np.cos(phi)
            t4349 = t4350 ** 2
            t4352 = t4350 * t4349
            t4355 = t4352 ** 2
            t4362 = 3542 * t4355 ** 2
            t4353 = t4349 ** 2
            t4354 = t4350 * t4353
            t4359 = t4354 ** 2
            t4357 = t4353 ** 2
            t4351 = 7 * phi1
            t4344 = t4350 * t4355
            t4342 = t4350 * t4357
            t4340 = t4350 * t4359
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt((1 - t4350)) * np.sqrt(0.57e2) * ((1 + t4350) ** (-0.1e1 / 0.2e1)) * ((t4362 - 8855 * t4340 - 4697 * t4359 + 26075 * t4342 - 5445 * t4357 - 28566 * t4344 + 12390 * t4355 + 14406 * t4354 - 7140 * t4353 - 3395 * t4352 + 1379 * t4349 + 335 * t4350 - 29) * np.exp((1j) * (t4351 - 6 * phi2)) + (t4362 + 15939 * t4340 + 20097 * t4359 - 10675 * t4342 - 42195 * t4357 - 19074 * t4344 + 21882 * t4355 + 19866 * t4354 - 1680 * t4353 - 5425 * t4352 - 651 * t4349 + 393 * t4350 + 29) * np.exp((1j) * (t4351 + 6 * phi2)))

        if Bindx == 233:
            t4375 = np.cos(phi)
            t4374 = t4375 ** 2
            t4378 = t4374 ** 2
            t4377 = t4375 * t4374
            t4380 = t4377 ** 2
            t4382 = t4378 ** 2
            t4379 = t4375 * t4378
            t4384 = t4379 ** 2
            t4387 = -1 - 19 * t4374 + 6 * t4378 + 42 * t4380 - 21 * t4382 - 7 * t4384
            t4386 = 21 * t4377 - 42 * t4379 + (-6 * t4380 + 19 * t4382 + t4384 + 7) * t4375
            t4376 = 7 * phi1
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.5313e4) * np.sqrt((1 - t4375)) * np.sqrt((1 + t4375)) * ((t4386 + t4387) * np.exp((1j) * (t4376 - 12 * phi2)) + (t4386 - t4387) * np.exp((1j) * (t4376 + 12 * phi2)))

        if Bindx == 234:
            t4394 = np.sin(phi)
            t4391 = t4394 ** 2
            t4392 = t4391 ** 2
            t4388 = np.cos(phi)
            t4389 = t4388 ** 2
            tfunc[..., c] = (0.25e2 / 0.2048e4) * np.exp((8*1j) * phi1) * np.sqrt(0.277134e6) * t4392 ** 2 * (1 + (-42 + 161 * t4389) * t4389)

        if Bindx == 235:
            t4408 = np.cos(phi)
            t4407 = t4408 ** 2
            t4410 = t4408 * t4407
            t4411 = t4407 ** 2
            t4412 = t4408 * t4411
            t4413 = t4410 ** 2
            t4415 = t4411 ** 2
            t4417 = t4412 ** 2
            t4421 = 3332 * t4410 - 6888 * t4412 + (-408 * t4413 + 11452 * t4415 - 7084 * t4417 - 404) * t4408
            t4420 = 532 * t4407 - 5607 * t4411 - 20337 * t4415 + 5852 * t4417 - 19 + (17808 + 1771 * t4413) * t4413
            t4409 = 4 * phi1
            tfunc[..., c] = (0.25e2 / 0.2048e4) * ((t4420 + t4421) * np.exp((2*1j) * (t4409 - 3 * phi2)) + (t4420 - t4421) * np.exp((2*1j) * (t4409 + 3 * phi2))) * np.sqrt(0.57e2)

        if Bindx == 236:
            t4435 = np.cos(phi)
            t4434 = t4435 ** 2
            t4437 = t4435 * t4434
            t4438 = t4434 ** 2
            t4439 = t4435 * t4438
            t4440 = t4437 ** 2
            t4442 = t4438 ** 2
            t4444 = t4439 ** 2
            t4448 = -40 * t4437 + 48 * t4439 + 8 * (6 * t4440 - 5 * t4442 - t4444 - 1) * t4435
            t4447 = 26 * t4434 + 15 * t4438 + 15 * t4442 + 26 * t4444 + 1 + (-84 + t4440) * t4440
            t4436 = 2 * phi1
            tfunc[..., c] = (0.25e2 / 0.4096e4) * ((t4447 + t4448) * np.exp((4*1j) * (t4436 - 3 * phi2)) + (t4447 - t4448) * np.exp((4*1j) * (t4436 + 3 * phi2))) * np.sqrt(0.5313e4)

        if Bindx == 237:
            t4449 = np.cos(phi)
            tfunc[..., c] = (-0.25e2 / 0.1024e4*1j) * np.exp((9*1j) * phi1) * np.sqrt(0.646646e6) * ((1 - t4449) ** (0.9e1 / 0.2e1)) * ((1 + t4449) ** (0.9e1 / 0.2e1)) * t4449 * (23 * t4449 ** 2 - 3)

        if Bindx == 238:
            t4462 = np.cos(phi)
            t4461 = t4462 ** 2
            t4465 = t4461 ** 2
            t4466 = t4462 * t4465
            t4471 = t4466 ** 2
            t4473 = 506 * t4462 * t4471
            t4469 = t4465 ** 2
            t4464 = t4462 * t4461
            t4467 = t4464 ** 2
            t4463 = 3 * phi1
            t4456 = t4462 * t4467
            t4454 = t4462 * t4469
            tfunc[..., c] = (0.25e2 / 0.2048e4*1j) * ((1 - t4462) ** (0.3e1 / 0.2e1)) * np.sqrt(0.133e3) * ((1 + t4462) ** (-0.1e1 / 0.2e1)) * ((t4473 - 1265 * t4471 - 682 * t4454 + 3777 * t4469 - 852 * t4456 - 4098 * t4467 + 1908 * t4466 + 1962 * t4465 - 1062 * t4464 - 413 * t4461 + 182 * t4462 + 37) * np.exp((3*1j) * (t4463 - 2 * phi2)) + (t4473 + 3289 * t4471 + 8426 * t4454 + 9687 * t4469 + 1860 * t4456 - 7350 * t4467 - 7308 * t4466 - 1314 * t4465 + 1602 * t4464 + 845 * t4461 + 34 * t4462 - 37) * np.exp((3*1j) * (t4463 + 2 * phi2)))

        if Bindx == 239:
            t4486 = np.cos(phi)
            t4485 = t4486 ** 2
            t4489 = t4485 ** 2
            t4488 = t4486 * t4485
            t4491 = t4488 ** 2
            t4493 = t4489 ** 2
            t4490 = t4486 * t4489
            t4495 = t4490 ** 2
            t4498 = 1 + 35 * t4485 + 90 * t4489 - 42 * t4491 - 75 * t4493 - 9 * t4495
            t4497 = -75 * t4488 - 42 * t4490 + (90 * t4491 + 35 * t4493 + t4495 - 9) * t4486
            t4487 = 3 * phi1
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.253e3) * np.sqrt((1 - t4486)) * np.sqrt((1 + t4486)) * ((t4497 + t4498) * np.exp((3*1j) * (t4487 - 4 * phi2)) + (t4497 - t4498) * np.exp((3*1j) * (t4487 + 4 * phi2)))

        if Bindx == 240:
            t4504 = np.sin(phi)
            t4500 = t4504 ** 2
            t4502 = t4504 * t4500 ** 2
            t4499 = np.cos(phi)
            tfunc[..., c] = -(0.25e2 / 0.1024e4) * np.exp((10*1j) * phi1) * np.sqrt(0.88179e5) * t4502 ** 2 * (23 * t4499 ** 2 - 1)

        if Bindx == 241:
            t4518 = np.cos(phi)
            t4517 = t4518 ** 2
            t4520 = t4518 * t4517
            t4521 = t4517 ** 2
            t4522 = t4518 * t4521
            t4523 = t4520 ** 2
            t4525 = t4521 ** 2
            t4527 = t4522 ** 2
            t4531 = 121 * t4520 - 366 * t4522 + (282 * t4523 + 85 * t4525 - 115 * t4527 - 7) * t4518
            t4530 = -50 * t4517 + 45 * t4521 - 441 * t4525 + 166 * t4527 + 5 + (252 + 23 * t4523) * t4523
            t4519 = 5 * phi1
            tfunc[..., c] = (0.25e2 / 0.2048e4) * np.sqrt(0.2e1) * np.sqrt(0.4389e4) * ((t4530 + t4531) * np.exp((2*1j) * (t4519 - 3 * phi2)) + (t4530 - t4531) * np.exp((2*1j) * (t4519 + 3 * phi2)))

        if Bindx == 242:
            t4544 = np.cos(phi)
            t4543 = t4544 ** 2
            t4547 = t4543 ** 2
            t4550 = t4547 ** 2
            t4548 = t4544 * t4547
            t4552 = t4548 ** 2
            t4553 = t4544 * t4552
            t4556 = t4544 * t4553 - 44 * t4543 - 165 * t4547 + 165 * t4550 + 44 * t4552 - 1
            t4555 = -10 * t4553 + (-132 * t4543 + 132) * t4548 + (110 * t4543 - 110 * t4550 + 10) * t4544
            t4545 = 5 * phi1
            tfunc[..., c] = (0.25e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.69e2) * ((t4555 + t4556) * np.exp((2*1j) * (t4545 - 6 * phi2)) + (-t4555 + t4556) * np.exp((2*1j) * (t4545 + 6 * phi2)))

        if Bindx == 243:
            t4557 = np.cos(phi)
            tfunc[..., c] = (0.25e2 / 0.1024e4*1j) * np.exp((11*1j) * phi1) * np.sqrt(0.4056234e7) * ((1 - t4557) ** (0.11e2 / 0.2e1)) * ((1 + t4557) ** (0.11e2 / 0.2e1)) * t4557

        if Bindx == 244:
            t4569 = np.cos(phi)
            t4568 = t4569 ** 2
            t4572 = t4568 ** 2
            t4573 = t4569 * t4572
            t4580 = 2 * t4573 ** 2
            t4579 = 1 - t4569
            t4576 = t4572 ** 2
            t4571 = t4569 * t4568
            t4574 = t4571 ** 2
            t4570 = 11 * phi1
            t4563 = t4569 * t4574
            t4561 = t4569 * t4576
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * (t4579 ** (0.5e1 / 0.2e1)) * np.sqrt(0.100947e6) * ((1 + t4569) ** (-0.1e1 / 0.2e1)) * ((t4580 - 5 * t4561 - 3 * t4576 + 16 * t4563 - 4 * t4574 - 18 * t4573 + 10 * t4572 + 8 * t4571 - 6 * t4568 + t4579) * np.exp((1j) * (t4570 - 6 * phi2)) + (t4580 + 17 * t4561 + 63 * t4576 + 132 * t4563 + 168 * t4574 + 126 * t4573 + 42 * t4572 - 12 * t4571 - 18 * t4568 - 7 * t4569 - 1) * np.exp((1j) * (t4570 + 6 * phi2)))

        if Bindx == 245:
            t4593 = np.cos(phi)
            t4592 = t4593 ** 2
            t4596 = t4592 ** 2
            t4595 = t4593 * t4592
            t4598 = t4595 ** 2
            t4600 = t4596 ** 2
            t4597 = t4593 * t4596
            t4602 = t4597 ** 2
            t4605 = -1 - 55 * t4592 - 330 * t4596 - 462 * t4598 - 165 * t4600 - 11 * t4602
            t4604 = 165 * t4595 + 462 * t4597 + (330 * t4598 + 55 * t4600 + t4602 + 11) * t4593
            t4594 = 11 * phi1
            tfunc[..., c] = (-0.25e2 / 0.2048e4*1j) * np.sqrt(0.3e1) * np.sqrt((1 - t4593)) * np.sqrt((1 + t4593)) * ((t4604 + t4605) * np.exp((1j) * (t4594 - 12 * phi2)) + (t4604 - t4605) * np.exp((1j) * (t4594 + 12 * phi2)))

        if Bindx == 246:
            t4610 = np.sin(phi)
            t4606 = t4610 ** 2
            t4607 = t4610 * t4606
            t4608 = t4607 ** 2
            tfunc[..., c] = (0.25e2 / 0.2048e4) * np.exp((12*1j) * phi1) * np.sqrt(0.676039e6) * t4608 ** 2

        if Bindx == 247:
            t4623 = np.cos(phi)
            t4622 = t4623 ** 2
            t4626 = t4622 ** 2
            t4629 = t4626 ** 2
            t4627 = t4623 * t4626
            t4631 = t4627 ** 2
            t4632 = t4623 * t4631
            t4635 = t4623 * t4632 - 12 * t4622 + 27 * t4626 - 27 * t4629 + 12 * t4631 - 1
            t4634 = -6 * t4632 + 2 * (18 * t4622 - 18) * t4627 + 2 * (t4622 - t4629 + 3) * t4623
            t4624 = 2 * phi1
            tfunc[..., c] = (0.25e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.33649e5) * ((t4634 + t4635) * np.exp((6*1j) * (t4624 - phi2)) + (-t4634 + t4635) * np.exp((6*1j) * (t4624 + phi2)))

        if Bindx == 248:
            t4649 = np.cos(phi)
            t4662 = -12 * t4649
            t4648 = t4649 ** 2
            t4650 = t4649 * t4648
            t4651 = t4648 ** 2
            t4652 = t4649 * t4651
            t4653 = t4650 ** 2
            t4655 = t4651 ** 2
            t4657 = t4652 ** 2
            t4661 = t4657 * t4662 - 220 * t4650 - 792 * t4652 + t4662 + (-792 * t4653 - 220 * t4655) * t4649
            t4660 = 66 * t4648 + 495 * t4651 + 495 * t4655 + 66 * t4657 + 1 + (924 + t4653) * t4653
            tfunc[..., c] = (0.25e2 / 0.8192e4) * np.sqrt(0.2e1) * ((t4660 + t4661) * np.exp((12*1j) * (phi1 - phi2)) + (t4660 - t4661) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 249:
            t4675 = np.cos(phi)
            t4674 = t4675 ** 2
            t4678 = t4674 ** 2
            t4681 = t4678 ** 2
            t4679 = t4675 * t4678
            t4683 = t4679 ** 2
            t4684 = t4675 * t4683
            t4687 = -t4675 * t4684 + 12 * t4674 - 27 * t4678 + 27 * t4681 - 12 * t4683 + 1
            t4686 = 6 * t4684 + 2 * (-18 * t4674 + 18) * t4679 + 2 * (-t4674 + t4681 - 3) * t4675
            t4676 = 13 * phi1
            tfunc[..., c] = (0.135e3 / 0.4096e4*1j) * np.sqrt(0.3289e4) * np.sqrt((1 - t4675)) * np.sqrt((1 + t4675)) * ((t4686 + t4687) * np.exp((-1*1j) * (t4676 - 6 * phi2)) + (t4686 - t4687) * np.exp((-1*1j) * (t4676 + 6 * phi2)))

        if Bindx == 250:
            t4702 = np.cos(phi)
            t4701 = t4702 ** 2
            t4704 = t4702 * t4701
            t4707 = t4704 ** 2
            t4713 = t4707 ** 2
            t4715 = -t4702 * t4713 + 1
            t4705 = t4701 ** 2
            t4706 = t4702 * t4705
            t4711 = t4706 ** 2
            t4709 = t4705 ** 2
            t4703 = 13 * phi1
            t4696 = t4702 * t4707
            t4694 = t4702 * t4709
            t4692 = t4702 * t4711
            tfunc[..., c] = (-0.27e2 / 0.8192e4*1j) * np.sqrt(0.13e2) * np.sqrt((1 + t4702)) * ((13 * t4713 - 78 * t4692 + 286 * t4711 - 715 * t4694 + 1287 * t4709 - 1716 * t4696 + 1716 * t4707 - 1287 * t4706 + 715 * t4705 - 286 * t4704 + 78 * t4701 - 13 * t4702 + t4715) * np.exp((-1*1j) * (t4703 - 12 * phi2)) + (11 * t4713 + 54 * t4692 + 154 * t4711 + 275 * t4694 + 297 * t4709 + 132 * t4696 - 132 * t4707 - 297 * t4706 - 275 * t4705 - 154 * t4704 - 54 * t4701 - 11 * t4702 - t4715) * np.exp((-1*1j) * (t4703 + 12 * phi2))) * ((1 - t4702) ** (-0.1e1 / 0.2e1))

        if Bindx == 251:
            t4730 = np.cos(phi)
            t4729 = t4730 ** 2
            t4733 = t4729 ** 2
            t4732 = t4730 * t4729
            t4735 = t4732 ** 2
            t4737 = t4733 ** 2
            t4734 = t4730 * t4733
            t4739 = t4734 ** 2
            t4741 = t4735 ** 2
            t4744 = -6 + 6 * t4729 + 188 * t4733 - 468 * t4735 + 306 * t4737 + 46 * t4739 - 72 * t4741
            t4743 = 144 * t4732 - 135 * t4734 + (-216 * t4735 + 363 * t4737 - 120 * t4739 - 13 * t4741 - 23) * t4730
            t4731 = 2 * phi1
            tfunc[..., c] = (0.135e3 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.253e3) * ((-t4743 + t4744) * np.exp((-6*1j) * (t4731 - phi2)) + (t4743 + t4744) * np.exp((-6*1j) * (t4731 + phi2)))

        if Bindx == 252:
            t4759 = np.cos(phi)
            t4758 = t4759 ** 2
            t4761 = t4758 ** 2
            t4760 = t4759 * t4758
            t4763 = t4760 ** 2
            t4765 = t4761 ** 2
            t4762 = t4759 * t4761
            t4767 = t4762 ** 2
            t4769 = t4763 ** 2
            t4772 = 12 + 636 * t4758 + 3080 * t4761 + 792 * t4763 - 4356 * t4765 - 2068 * t4767 - 144 * t4769
            t4771 = 1782 * t4760 + 3069 * t4762 + (-2508 * t4763 - 3795 * t4765 - 714 * t4767 - 13 * t4769 + 131) * t4759
            tfunc[..., c] = (0.27e2 / 0.8192e4) * np.sqrt(0.2e1) * ((-t4771 + t4772) * np.exp((-12*1j) * (phi1 - phi2)) + (t4771 + t4772) * np.exp((-12*1j) * (phi1 + phi2)))

        if Bindx == 253:
            t4785 = np.cos(phi)
            t4784 = t4785 ** 2
            t4788 = t4784 ** 2
            t4789 = t4785 * t4788
            t4794 = t4789 ** 2
            t4796 = -325 * t4785 * t4794 + 59
            t4792 = t4788 ** 2
            t4787 = t4785 * t4784
            t4790 = t4787 ** 2
            t4786 = 11 * phi1
            t4779 = t4785 * t4790
            t4777 = t4785 * t4792
            tfunc[..., c] = (-0.27e2 / 0.4096e4*1j) * ((1 + t4785) ** (0.5e1 / 0.2e1)) * np.sqrt(0.253e3) * ((1 - t4785) ** (-0.1e1 / 0.2e1)) * ((2625 * t4794 - 9059 * t4777 + 17031 * t4792 - 17874 * t4779 + 8106 * t4790 + 3066 * t4789 - 6066 * t4788 + 2919 * t4787 - 251 * t4784 - 231 * t4785 + t4796) * np.exp((-1*1j) * (t4786 - 6 * phi2)) + (675 * t4794 - 841 * t4777 - 2423 * t4792 + 450 * t4779 + 3278 * t4790 + 446 * t4789 - 2046 * t4788 - 503 * t4787 + 575 * t4784 + 123 * t4785 - t4796) * np.exp((-1*1j) * (t4786 + 6 * phi2)))

        if Bindx == 254:
            t4812 = np.cos(phi)
            t4811 = t4812 ** 2
            t4814 = t4812 * t4811
            t4815 = t4811 ** 2
            t4816 = t4812 * t4815
            t4817 = t4814 ** 2
            t4818 = t4812 * t4817
            t4819 = t4815 ** 2
            t4821 = t4816 ** 2
            t4823 = t4817 ** 2
            t4827 = 992 * t4814 - 308 * t4816 - 3168 * t4818 + (836 * t4819 + 1408 * t4821 + 132 * t4823 + 108) * t4812
            t4826 = -13 * t4818 ** 2 - 451 * t4811 - 1023 * t4815 + 2409 * t4817 + 1551 * t4819 - 1881 * t4821 - 581 * t4823 - 11
            t4813 = 11 * phi1
            tfunc[..., c] = (-0.135e3 / 0.8192e4*1j) * ((1 + t4812) ** (-0.1e1 / 0.2e1)) * ((1 - t4812) ** (-0.1e1 / 0.2e1)) * ((t4826 + t4827) * np.exp((-1*1j) * (t4813 - 12 * phi2)) + (-t4826 + t4827) * np.exp((-1*1j) * (t4813 + 12 * phi2)))

        if Bindx == 255:
            t4842 = np.cos(phi)
            t4841 = t4842 ** 2
            t4845 = t4841 ** 2
            t4844 = t4842 * t4841
            t4847 = t4844 ** 2
            t4849 = t4845 ** 2
            t4846 = t4842 * t4845
            t4851 = t4846 ** 2
            t4853 = t4847 ** 2
            t4856 = -17 + 391 * t4841 - 2246 * t4845 + 4182 * t4847 - 1605 * t4849 - 2205 * t4851 + 1500 * t4853
            t4855 = 210 * t4844 + 1377 * t4846 + (-5436 * t4847 + 5951 * t4849 - 1702 * t4851 - 325 * t4853 - 75) * t4842
            t4843 = 5 * phi1
            tfunc[..., c] = -(0.27e2 / 0.2048e4) * np.sqrt(0.2e1) * np.sqrt(0.253e3) * ((t4855 + t4856) * np.exp((-2*1j) * (t4843 - 3 * phi2)) + (-t4855 + t4856) * np.exp((-2*1j) * (t4843 + 3 * phi2)))

        if Bindx == 256:
            t4871 = np.cos(phi)
            t4870 = t4871 ** 2
            t4874 = t4870 ** 2
            t4873 = t4871 * t4870
            t4876 = t4873 ** 2
            t4878 = t4874 ** 2
            t4875 = t4871 * t4874
            t4880 = t4875 ** 2
            t4882 = t4876 ** 2
            t4885 = 10 + 310 * t4870 + 220 * t4874 - 1716 * t4876 + 66 * t4878 + 990 * t4880 + 120 * t4882
            t4884 = -528 * t4873 + 825 * t4875 + (1320 * t4876 - 1045 * t4878 - 472 * t4880 - 13 * t4882 - 87) * t4871
            t4872 = 5 * phi1
            tfunc[..., c] = -(0.135e3 / 0.4096e4) * ((t4884 + t4885) * np.exp((-2*1j) * (t4872 - 6 * phi2)) + (-t4884 + t4885) * np.exp((-2*1j) * (t4872 + 6 * phi2))) * np.sqrt(0.2e1)

        if Bindx == 257:
            t4899 = np.cos(phi)
            t4898 = t4899 ** 2
            t4901 = t4899 * t4898
            t4904 = t4901 ** 2
            t4911 = -7475 * t4904 ** 2 - 27
            t4902 = t4898 ** 2
            t4903 = t4899 * t4902
            t4908 = t4903 ** 2
            t4906 = t4902 ** 2
            t4900 = 3 * phi1
            t4893 = t4899 * t4904
            t4891 = t4899 * t4906
            t4889 = t4899 * t4908
            tfunc[..., c] = (-0.27e2 / 0.4096e4*1j) * np.sqrt(0.2e1) * ((1 + t4899) ** (0.3e1 / 0.2e1)) * np.sqrt(0.11e2) * ((1 - t4899) ** (-0.1e1 / 0.2e1)) * ((46000 * t4889 - 107042 * t4908 + 95772 * t4891 + 34059 * t4906 - 135024 * t4893 + 80388 * t4904 + 21384 * t4903 - 39357 * t4902 + 9056 * t4901 + 3614 * t4898 - 1348 * t4899 + t4911) * np.exp((-3*1j) * (t4900 - 2 * phi2)) + (16100 * t4889 - 17158 * t4908 - 54096 * t4891 + 6789 * t4906 + 69384 * t4893 + 10044 * t4904 - 42336 * t4903 - 9171 * t4902 + 12404 * t4901 + 1994 * t4898 - 1456 * t4899 - t4911) * np.exp((-3*1j) * (t4900 + 2 * phi2)))

        if Bindx == 258:
            t4927 = np.cos(phi)
            t4926 = t4927 ** 2
            t4929 = t4927 * t4926
            t4930 = t4926 ** 2
            t4931 = t4927 * t4930
            t4932 = t4929 ** 2
            t4933 = t4927 * t4932
            t4934 = t4930 ** 2
            t4936 = t4931 ** 2
            t4938 = t4932 ** 2
            t4942 = 152 * t4929 - 1012 * t4931 + 528 * t4933 + (924 * t4934 - 552 * t4936 - 108 * t4938 + 68) * t4927
            t4941 = -13 * t4933 ** 2 + 189 * t4926 - 363 * t4930 - 759 * t4932 + 1419 * t4934 - 121 * t4936 - 361 * t4938 + 9
            t4928 = 3 * phi1
            tfunc[..., c] = (0.135e3 / 0.8192e4*1j) * np.sqrt(0.23e2) * np.sqrt(0.2e1) * ((-t4941 + t4942) * np.exp((-3*1j) * (t4928 - 4 * phi2)) + (t4941 + t4942) * np.exp((-3*1j) * (t4928 + 4 * phi2))) * ((1 - t4927) ** (-0.1e1 / 0.2e1)) * ((1 + t4927) ** (-0.1e1 / 0.2e1))

        if Bindx == 259:
            t4957 = np.cos(phi)
            t4956 = t4957 ** 2
            t4960 = t4956 ** 2
            t4959 = t4957 * t4956
            t4962 = t4959 ** 2
            t4964 = t4960 ** 2
            t4961 = t4957 * t4960
            t4966 = t4961 ** 2
            t4968 = t4962 ** 2
            t4971 = 5084 * t4956 - 24904 * t4960 + 20568 * t4962 + 69204 * t4964 - 130548 * t4966 + 60720 * t4968 - 124
            t4970 = 15864 * t4959 - 84537 * t4961 + (185544 * t4962 - 164659 * t4964 + 32384 * t4966 + 16445 * t4968 - 1041) * t4957
            t4958 = 4 * phi1
            tfunc[..., c] = -(0.27e2 / 0.2048e4) * ((-t4970 + t4971) * np.exp((-2*1j) * (t4958 - 3 * phi2)) + (t4970 + t4971) * np.exp((-2*1j) * (t4958 + 3 * phi2))) * np.sqrt(0.5e1)

        if Bindx == 260:
            t4986 = np.cos(phi)
            t4985 = t4986 ** 2
            t4989 = t4985 ** 2
            t4988 = t4986 * t4985
            t4991 = t4988 ** 2
            t4993 = t4989 ** 2
            t4990 = t4986 * t4989
            t4995 = t4990 ** 2
            t4997 = t4991 ** 2
            t5000 = -8 - 104 * t4985 + 400 * t4989 + 48 * t4991 - 744 * t4993 + 312 * t4995 + 96 * t4997
            t4999 = -18 * t4988 - 579 * t4990 + (708 * t4991 + 125 * t4993 - 274 * t4995 - 13 * t4997 + 51) * t4986
            t4987 = 2 * phi1
            tfunc[..., c] = -(0.27e2 / 0.4096e4) * ((t4999 + t5000) * np.exp((-4*1j) * (t4987 - 3 * phi2)) + (-t4999 + t5000) * np.exp((-4*1j) * (t4987 + 3 * phi2))) * np.sqrt(0.1265e4)

        if Bindx == 261:
            t5015 = np.cos(phi)
            t5014 = t5015 ** 2
            t5017 = t5015 * t5014
            t5020 = t5017 ** 2
            t5026 = t5020 ** 2
            t5028 = -16445 * t5015 * t5026 - 85
            t5018 = t5014 ** 2
            t5019 = t5015 * t5018
            t5024 = t5019 ** 2
            t5022 = t5018 ** 2
            t5016 = 7 * phi1
            t5009 = t5015 * t5020
            t5007 = t5015 * t5022
            t5005 = t5015 * t5024
            tfunc[..., c] = (-0.27e2 / 0.4096e4*1j) * np.sqrt(0.2e1) * np.sqrt((1 + t5015)) * np.sqrt(0.35e2) * ((1 - t5015) ** (-0.1e1 / 0.2e1)) * ((69575 * t5026 - 71346 * t5005 - 84502 * t5024 + 197461 * t5007 - 35523 * t5022 - 147804 * t5009 + 82140 * t5020 + 37917 * t5019 - 33871 * t5018 - 1682 * t5017 + 4314 * t5014 - 149 * t5015 + t5028) * np.exp((-1*1j) * (t5016 - 6 * phi2)) + (36685 * t5026 - 34914 * t5005 - 120934 * t5024 + 7975 * t5007 + 153963 * t5022 + 29364 * t5009 - 95028 * t5020 - 25029 * t5019 + 29075 * t5018 + 6478 * t5017 - 3846 * t5014 - 319 * t5015 - t5028) * np.exp((-1*1j) * (t5016 + 6 * phi2)))

        if Bindx == 262:
            t5044 = np.cos(phi)
            t5043 = t5044 ** 2
            t5046 = t5044 * t5043
            t5047 = t5043 ** 2
            t5048 = t5044 * t5047
            t5049 = t5046 ** 2
            t5050 = t5044 * t5049
            t5051 = t5047 ** 2
            t5053 = t5048 ** 2
            t5055 = t5049 ** 2
            t5059 = 136 * t5046 + 116 * t5048 - 720 * t5050 + (644 * t5051 - 56 * t5053 - 84 * t5055 - 36) * t5044
            t5058 = -13 * t5050 ** 2 - 35 * t5043 + 357 * t5047 - 567 * t5049 + 27 * t5051 + 423 * t5053 - 185 * t5055 - 7
            t5045 = 7 * phi1
            tfunc[..., c] = (0.27e2 / 0.8192e4*1j) * np.sqrt(0.8855e4) * np.sqrt(0.2e1) * ((-t5058 + t5059) * np.exp((-1*1j) * (t5045 - 12 * phi2)) + (t5058 + t5059) * np.exp((-1*1j) * (t5045 + 12 * phi2))) * ((1 + t5044) ** (-0.1e1 / 0.2e1)) * ((1 - t5044) ** (-0.1e1 / 0.2e1))

        if Bindx == 263:
            t5074 = np.cos(phi)
            t5073 = t5074 ** 2
            t5075 = t5074 * t5073
            t5076 = t5073 ** 2
            t5077 = t5074 * t5076
            t5078 = t5075 ** 2
            t5080 = t5076 ** 2
            t5082 = t5077 ** 2
            t5084 = t5078 ** 2
            t5087 = 45270 * t5075 - 217629 * t5077 + (410700 * t5078 - 270435 * t5080 - 47058 * t5082 + 82225 * t5084 - 2561) * t5074
            t5086 = -3795 * t5073 + 48670 * t5076 - 257454 * t5078 + 595305 * t5080 - 609983 * t5082 + 227700 * t5084 + 69
            tfunc[..., c] = -(0.27e2 / 0.2048e4) * np.sqrt(0.2e1) * ((t5086 - t5087) * np.exp((-6*1j) * (phi1 - phi2)) + (t5086 + t5087) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 264:
            t5102 = np.cos(phi)
            t5101 = t5102 ** 2
            t5104 = t5101 ** 2
            t5103 = t5102 * t5101
            t5106 = t5103 ** 2
            t5108 = t5104 ** 2
            t5105 = t5102 * t5104
            t5110 = t5105 ** 2
            t5112 = t5106 ** 2
            t5115 = 6 - 6 * t5101 - 188 * t5104 + 468 * t5106 - 306 * t5108 - 46 * t5110 + 72 * t5112
            t5114 = 144 * t5103 - 135 * t5105 + (-216 * t5106 + 363 * t5108 - 120 * t5110 - 13 * t5112 - 23) * t5102
            tfunc[..., c] = -(0.135e3 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.253e3) * ((t5114 + t5115) * np.exp((-6*1j) * (phi1 - 2 * phi2)) + (-t5114 + t5115) * np.exp((-6*1j) * (phi1 + 2 * phi2)))

        if Bindx == 265:
            t5131 = np.cos(phi)
            t5130 = t5131 ** 2
            t5134 = t5130 ** 2
            t5133 = t5131 * t5130
            t5136 = t5133 ** 2
            t5137 = t5131 * t5136
            t5138 = t5134 ** 2
            t5135 = t5131 * t5134
            t5140 = t5135 ** 2
            t5142 = t5136 ** 2
            t5146 = 82225 * t5137 ** 2 - 6893 * t5130 + 63345 * t5134 - 196005 * t5136 + 221115 * t5138 + 6369 * t5140 - 170269 * t5142 + 113
            t5145 = 26140 * t5133 - 175642 * t5135 + 542952 * t5137 + (-845090 * t5138 + 642620 * t5140 - 189750 * t5142 - 1230) * t5131
            t5132 = 5 * phi1
            tfunc[..., c] = (0.27e2 / 0.4096e4*1j) * np.sqrt(0.19e2) * ((t5145 + t5146) * np.exp((-1*1j) * (t5132 - 6 * phi2)) + (t5145 - t5146) * np.exp((-1*1j) * (t5132 + 6 * phi2))) * ((1 + t5131) ** (-0.1e1 / 0.2e1)) * ((1 - t5131) ** (-0.1e1 / 0.2e1))

        if Bindx == 266:
            t5162 = np.cos(phi)
            t5161 = t5162 ** 2
            t5164 = t5162 * t5161
            t5165 = t5161 ** 2
            t5166 = t5162 * t5165
            t5167 = t5164 ** 2
            t5168 = t5162 * t5167
            t5169 = t5165 ** 2
            t5171 = t5166 ** 2
            t5173 = t5167 ** 2
            t5177 = 128 * t5164 - 332 * t5166 + 288 * t5168 + (28 * t5169 - 160 * t5171 + 60 * t5173 - 12) * t5162
            t5176 = -13 * t5168 ** 2 - 35 * t5161 - 15 * t5165 + 297 * t5167 - 513 * t5169 + 327 * t5171 - 53 * t5173 + 5
            t5163 = 5 * phi1
            tfunc[..., c] = (-0.135e3 / 0.8192e4*1j) * np.sqrt(0.4807e4) * ((1 + t5162) ** (-0.1e1 / 0.2e1)) * ((1 - t5162) ** (-0.1e1 / 0.2e1)) * ((t5176 + t5177) * np.exp((-1*1j) * (t5163 - 12 * phi2)) + (-t5176 + t5177) * np.exp((-1*1j) * (t5163 + 12 * phi2)))

        if Bindx == 267:
            t5192 = np.cos(phi)
            t5191 = t5192 ** 2
            t5194 = t5192 * t5191
            t5195 = t5191 ** 2
            t5196 = t5192 * t5195
            t5197 = t5194 ** 2
            t5199 = t5195 ** 2
            t5201 = t5196 ** 2
            t5203 = t5197 ** 2
            t5206 = 7280 * t5194 - 27661 * t5196 + (-1480 * t5197 + 136345 * t5199 - 196328 * t5201 + 82225 * t5203 - 381) * t5192
            t5205 = -6890 * t5191 + 73180 * t5195 - 291124 * t5197 + 536930 * t5199 - 464002 * t5201 + 151800 * t5203 + 106
            t5193 = 2 * phi1
            tfunc[..., c] = -(0.27e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((t5205 - t5206) * np.exp((-2*1j) * (t5193 - 3 * phi2)) + (t5205 + t5206) * np.exp((-2*1j) * (t5193 + 3 * phi2)))

        if Bindx == 268:
            t5221 = np.cos(phi)
            t5220 = t5221 ** 2
            t5223 = t5220 ** 2
            t5222 = t5221 * t5220
            t5225 = t5222 ** 2
            t5227 = t5223 ** 2
            t5224 = t5221 * t5223
            t5229 = t5224 ** 2
            t5231 = t5225 ** 2
            t5234 = -4 + 44 * t5220 - 88 * t5223 - 8 * t5225 + 172 * t5227 - 164 * t5229 + 48 * t5231
            t5233 = -74 * t5222 + 253 * t5224 + (-332 * t5225 + 173 * t5227 - 10 * t5229 - 13 * t5231 + 3) * t5221
            tfunc[..., c] = -(0.135e3 / 0.8192e4) * np.sqrt(0.2e1) * np.sqrt(0.4807e4) * ((t5233 + t5234) * np.exp((-4*1j) * (phi1 - 3 * phi2)) + (-t5233 + t5234) * np.exp((-4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 269:
            t5250 = np.cos(phi)
            t5249 = t5250 ** 2
            t5252 = t5249 ** 2
            t5251 = t5250 * t5249
            t5254 = t5251 ** 2
            t5255 = t5250 * t5254
            t5256 = t5252 ** 2
            t5253 = t5250 * t5252
            t5258 = t5253 ** 2
            t5260 = t5254 ** 2
            t5264 = -16445 * t5255 ** 2 - 207 * t5249 + 2939 * t5252 - 17743 * t5254 + 52529 * t5256 - 79013 * t5258 + 57937 * t5260 + 3
            t5263 = 4444 * t5251 - 29390 * t5253 + 84680 * t5255 + (-120766 * t5256 + 83996 * t5258 - 22770 * t5260 - 194) * t5250
            tfunc[..., c] = (0.27e2 / 0.4096e4*1j) * np.sqrt(0.1615e4) * ((t5263 - t5264) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t5263 + t5264) * np.exp((-3*1j) * (phi1 + 2 * phi2))) * ((1 + t5250) ** (-0.1e1 / 0.2e1)) * ((1 - t5250) ** (-0.1e1 / 0.2e1))

        if Bindx == 270:
            t5280 = np.cos(phi)
            t5279 = t5280 ** 2
            t5281 = t5280 * t5279
            t5282 = t5279 ** 2
            t5283 = t5280 * t5282
            t5284 = t5281 ** 2
            t5285 = t5280 * t5284
            t5286 = t5282 ** 2
            t5288 = t5283 ** 2
            t5290 = t5284 ** 2
            t5294 = 16 * t5281 - 140 * t5283 + 320 * t5285 + (-340 * t5286 + 176 * t5288 - 36 * t5290 + 4) * t5280
            t5293 = -13 * t5285 ** 2 + 45 * t5279 - 167 * t5282 + 265 * t5284 - 185 * t5286 + 23 * t5288 + 35 * t5290 - 3
            tfunc[..., c] = (0.27e2 / 0.8192e4*1j) * np.sqrt(0.408595e6) * ((-t5293 + t5294) * np.exp((-3*1j) * (phi1 - 4 * phi2)) + (t5293 + t5294) * np.exp((-3*1j) * (phi1 + 4 * phi2))) * ((1 + t5280) ** (-0.1e1 / 0.2e1)) * ((1 - t5280) ** (-0.1e1 / 0.2e1))

        if Bindx == 271:
            t5309 = np.cos(phi)
            t5308 = t5309 ** 2
            t5311 = t5308 ** 2
            t5310 = t5309 * t5308
            t5313 = t5310 ** 2
            t5315 = t5311 ** 2
            t5312 = t5309 * t5311
            t5317 = t5312 ** 2
            t5319 = t5313 ** 2
            t5322 = -1 + 71 * t5308 - 790 * t5311 + 3142 * t5313 - 5573 * t5315 + 4531 * t5317 - 1380 * t5319
            t5321 = 214 * t5310 - 1493 * t5312 + (4588 * t5313 - 7003 * t5315 + 5198 * t5317 - 1495 * t5319 - 9) * t5309
            tfunc[..., c] = (0.27e2 / 0.1024e4) * ((-t5321 + t5322) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t5321 + t5322) * np.exp((-2*1j) * (phi1 + 3 * phi2))) * np.sqrt(0.17765e5)

        if Bindx == 272:
            t5337 = np.cos(phi)
            t5336 = t5337 ** 2
            t5339 = t5336 ** 2
            t5338 = t5337 * t5336
            t5341 = t5338 ** 2
            t5343 = t5339 ** 2
            t5340 = t5337 * t5339
            t5345 = t5340 ** 2
            t5347 = t5341 ** 2
            t5350 = 2 - 34 * t5336 + 140 * t5339 - 260 * t5341 + 250 * t5343 - 122 * t5345 + 24 * t5347
            t5349 = -32 * t5338 + 25 * t5340 + (40 * t5341 - 85 * t5343 + 56 * t5345 - 13 * t5347 + 9) * t5337
            tfunc[..., c] = -(0.27e2 / 0.2048e4) * ((t5349 + t5350) * np.exp((-2*1j) * (phi1 - 6 * phi2)) + (-t5349 + t5350) * np.exp((-2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.37145e5)

        if Bindx == 273:
            t5366 = np.cos(phi)
            t5365 = t5366 ** 2
            t5367 = t5366 * t5365
            t5368 = t5365 ** 2
            t5369 = t5366 * t5368
            t5370 = t5367 ** 2
            t5371 = t5366 * t5370
            t5372 = t5368 ** 2
            t5374 = t5369 ** 2
            t5376 = t5370 ** 2
            t5380 = -720 * t5367 + 4878 * t5369 - 14064 * t5371 + (19674 * t5372 - 13248 * t5374 + 3450 * t5376 + 30) * t5366
            t5379 = -7475 * t5371 ** 2 - 365 * t5365 + 4425 * t5368 - 20473 * t5370 + 45919 * t5372 - 53799 * t5374 + 31763 * t5376 + 5
            tfunc[..., c] = (-0.27e2 / 0.2048e4*1j) * np.sqrt(0.3553e4) * ((1 + t5366) ** (-0.1e1 / 0.2e1)) * ((1 - t5366) ** (-0.1e1 / 0.2e1)) * ((t5379 + t5380) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (-t5379 + t5380) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 274:
            t5396 = np.cos(phi)
            t5395 = t5396 ** 2
            t5397 = t5396 * t5395
            t5398 = t5395 ** 2
            t5399 = t5396 * t5398
            t5400 = t5397 ** 2
            t5401 = t5396 * t5400
            t5402 = t5398 ** 2
            t5404 = t5399 ** 2
            t5406 = t5400 ** 2
            t5410 = 72 * t5397 - 180 * t5399 + 240 * t5401 + 12 * (-15 * t5402 + 6 * t5404 - t5406 - 1) * t5396
            t5409 = -13 * t5401 ** 2 - 19 * t5395 + 93 * t5398 - 215 * t5400 + 275 * t5402 - 201 * t5404 + 79 * t5406 + 1
            tfunc[..., c] = (0.135e3 / 0.4096e4*1j) * np.sqrt(0.7429e4) * ((-t5409 + t5410) * np.exp((-1*1j) * (phi1 - 12 * phi2)) + (t5409 + t5410) * np.exp((-1*1j) * (phi1 + 12 * phi2))) * ((1 + t5396) ** (-0.1e1 / 0.2e1)) * ((1 - t5396) ** (-0.1e1 / 0.2e1))

        if Bindx == 275:
            t5418 = np.sin(phi)
            t5415 = t5418 ** 2
            t5416 = t5418 * t5415
            t5411 = np.cos(phi)
            t5412 = t5411 ** 2
            t5413 = t5412 ** 2
            tfunc[..., c] = (-0.27e2 / 0.1024e4*1j) * t5411 * t5416 ** 2 * (-483 * t5413 - 5 + (575 * t5413 + 105) * t5412) * np.sin((6 * phi2)) * np.sqrt(0.323323e6) * np.sqrt(0.2e1)

        if Bindx == 276:
            t5423 = np.sin(phi)
            t5419 = t5423 ** 2
            t5420 = t5423 * t5419
            t5421 = t5420 ** 2
            tfunc[..., c] = (0.135e3 / 0.2048e4*1j) * np.sqrt(0.676039e6) * np.sqrt(0.2e1) * np.cos(phi) * np.sin((12 * phi2)) * t5421 ** 2

        if Bindx == 277:
            t5439 = np.cos(phi)
            t5438 = t5439 ** 2
            t5440 = t5439 * t5438
            t5441 = t5438 ** 2
            t5442 = t5439 * t5441
            t5443 = t5440 ** 2
            t5444 = t5439 * t5443
            t5445 = t5441 ** 2
            t5447 = t5442 ** 2
            t5449 = t5443 ** 2
            t5453 = 720 * t5440 - 4878 * t5442 + 14064 * t5444 + (-19674 * t5445 + 13248 * t5447 - 3450 * t5449 - 30) * t5439
            t5452 = -7475 * t5444 ** 2 - 365 * t5438 + 4425 * t5441 - 20473 * t5443 + 45919 * t5445 - 53799 * t5447 + 31763 * t5449 + 5
            tfunc[..., c] = (-0.27e2 / 0.2048e4*1j) * np.sqrt(0.3553e4) * ((1 + t5439) ** (-0.1e1 / 0.2e1)) * ((1 - t5439) ** (-0.1e1 / 0.2e1)) * ((-t5452 + t5453) * np.exp((1j) * (phi1 - 6 * phi2)) + (t5452 + t5453) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 278:
            t5469 = np.cos(phi)
            t5468 = t5469 ** 2
            t5470 = t5469 * t5468
            t5471 = t5468 ** 2
            t5472 = t5469 * t5471
            t5473 = t5470 ** 2
            t5474 = t5469 * t5473
            t5475 = t5471 ** 2
            t5477 = t5472 ** 2
            t5479 = t5473 ** 2
            t5483 = 72 * t5470 - 180 * t5472 + 240 * t5474 + 12 * (-15 * t5475 + 6 * t5477 - t5479 - 1) * t5469
            t5482 = -13 * t5474 ** 2 - 19 * t5468 + 93 * t5471 - 215 * t5473 + 275 * t5475 - 201 * t5477 + 79 * t5479 + 1
            tfunc[..., c] = (-0.135e3 / 0.4096e4*1j) * np.sqrt(0.7429e4) * ((1 + t5469) ** (-0.1e1 / 0.2e1)) * ((1 - t5469) ** (-0.1e1 / 0.2e1)) * ((-t5482 + t5483) * np.exp((1j) * (phi1 - 12 * phi2)) + (t5482 + t5483) * np.exp((1j) * (phi1 + 12 * phi2)))

        if Bindx == 279:
            t5498 = np.cos(phi)
            t5497 = t5498 ** 2
            t5500 = t5497 ** 2
            t5499 = t5498 * t5497
            t5502 = t5499 ** 2
            t5504 = t5500 ** 2
            t5501 = t5498 * t5500
            t5506 = t5501 ** 2
            t5508 = t5502 ** 2
            t5511 = -1 + 71 * t5497 - 790 * t5500 + 3142 * t5502 - 5573 * t5504 + 4531 * t5506 - 1380 * t5508
            t5510 = 214 * t5499 - 1493 * t5501 + (4588 * t5502 - 7003 * t5504 + 5198 * t5506 - 1495 * t5508 - 9) * t5498
            tfunc[..., c] = -(0.27e2 / 0.1024e4) * ((-t5510 + t5511) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t5510 + t5511) * np.exp((2*1j) * (phi1 + 3 * phi2))) * np.sqrt(0.17765e5)

        if Bindx == 280:
            t5526 = np.cos(phi)
            t5525 = t5526 ** 2
            t5528 = t5525 ** 2
            t5527 = t5526 * t5525
            t5530 = t5527 ** 2
            t5532 = t5528 ** 2
            t5529 = t5526 * t5528
            t5534 = t5529 ** 2
            t5536 = t5530 ** 2
            t5539 = -2 + 34 * t5525 - 140 * t5528 + 260 * t5530 - 250 * t5532 + 122 * t5534 - 24 * t5536
            t5538 = -32 * t5527 + 25 * t5529 + (40 * t5530 - 85 * t5532 + 56 * t5534 - 13 * t5536 + 9) * t5526
            tfunc[..., c] = -(0.27e2 / 0.2048e4) * ((-t5538 + t5539) * np.exp((2*1j) * (phi1 - 6 * phi2)) + (t5538 + t5539) * np.exp((2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.37145e5)

        if Bindx == 281:
            t5555 = np.cos(phi)
            t5554 = t5555 ** 2
            t5557 = t5554 ** 2
            t5556 = t5555 * t5554
            t5559 = t5556 ** 2
            t5560 = t5555 * t5559
            t5561 = t5557 ** 2
            t5558 = t5555 * t5557
            t5563 = t5558 ** 2
            t5565 = t5559 ** 2
            t5569 = -16445 * t5560 ** 2 - 207 * t5554 + 2939 * t5557 - 17743 * t5559 + 52529 * t5561 - 79013 * t5563 + 57937 * t5565 + 3
            t5568 = 4444 * t5556 - 29390 * t5558 + 84680 * t5560 + (-120766 * t5561 + 83996 * t5563 - 22770 * t5565 - 194) * t5555
            tfunc[..., c] = (-0.27e2 / 0.4096e4*1j) * np.sqrt(0.1615e4) * ((1 + t5555) ** (-0.1e1 / 0.2e1)) * ((1 - t5555) ** (-0.1e1 / 0.2e1)) * ((t5568 - t5569) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t5568 + t5569) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 282:
            t5585 = np.cos(phi)
            t5584 = t5585 ** 2
            t5586 = t5585 * t5584
            t5587 = t5584 ** 2
            t5588 = t5585 * t5587
            t5589 = t5586 ** 2
            t5590 = t5585 * t5589
            t5591 = t5587 ** 2
            t5593 = t5588 ** 2
            t5595 = t5589 ** 2
            t5599 = 16 * t5586 - 140 * t5588 + 320 * t5590 + (-340 * t5591 + 176 * t5593 - 36 * t5595 + 4) * t5585
            t5598 = -13 * t5590 ** 2 + 45 * t5584 - 167 * t5587 + 265 * t5589 - 185 * t5591 + 23 * t5593 + 35 * t5595 - 3
            tfunc[..., c] = (-0.27e2 / 0.8192e4*1j) * np.sqrt(0.408595e6) * ((1 + t5585) ** (-0.1e1 / 0.2e1)) * ((1 - t5585) ** (-0.1e1 / 0.2e1)) * ((-t5598 + t5599) * np.exp((3*1j) * (phi1 - 4 * phi2)) + (t5598 + t5599) * np.exp((3*1j) * (phi1 + 4 * phi2)))

        if Bindx == 283:
            t5614 = np.cos(phi)
            t5613 = t5614 ** 2
            t5616 = t5614 * t5613
            t5617 = t5613 ** 2
            t5618 = t5614 * t5617
            t5619 = t5616 ** 2
            t5621 = t5617 ** 2
            t5623 = t5618 ** 2
            t5625 = t5619 ** 2
            t5628 = 7280 * t5616 - 27661 * t5618 + (-1480 * t5619 + 136345 * t5621 - 196328 * t5623 + 82225 * t5625 - 381) * t5614
            t5627 = 6890 * t5613 - 73180 * t5617 + 291124 * t5619 - 536930 * t5621 + 464002 * t5623 - 151800 * t5625 - 106
            t5615 = 2 * phi1
            tfunc[..., c] = -(0.27e2 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((t5627 + t5628) * np.exp((2*1j) * (t5615 - 3 * phi2)) + (t5627 - t5628) * np.exp((2*1j) * (t5615 + 3 * phi2)))

        if Bindx == 284:
            t5643 = np.cos(phi)
            t5642 = t5643 ** 2
            t5645 = t5642 ** 2
            t5644 = t5643 * t5642
            t5647 = t5644 ** 2
            t5649 = t5645 ** 2
            t5646 = t5643 * t5645
            t5651 = t5646 ** 2
            t5653 = t5647 ** 2
            t5656 = 4 - 44 * t5642 + 88 * t5645 + 8 * t5647 - 172 * t5649 + 164 * t5651 - 48 * t5653
            t5655 = -74 * t5644 + 253 * t5646 + (-332 * t5647 + 173 * t5649 - 10 * t5651 - 13 * t5653 + 3) * t5643
            tfunc[..., c] = -(0.135e3 / 0.8192e4) * np.sqrt(0.2e1) * np.sqrt(0.4807e4) * ((-t5655 + t5656) * np.exp((4*1j) * (phi1 - 3 * phi2)) + (t5655 + t5656) * np.exp((4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 285:
            t5672 = np.cos(phi)
            t5671 = t5672 ** 2
            t5675 = t5671 ** 2
            t5674 = t5672 * t5671
            t5677 = t5674 ** 2
            t5678 = t5672 * t5677
            t5679 = t5675 ** 2
            t5676 = t5672 * t5675
            t5681 = t5676 ** 2
            t5683 = t5677 ** 2
            t5687 = 82225 * t5678 ** 2 - 6893 * t5671 + 63345 * t5675 - 196005 * t5677 + 221115 * t5679 + 6369 * t5681 - 170269 * t5683 + 113
            t5686 = 26140 * t5674 - 175642 * t5676 + 542952 * t5678 + (-845090 * t5679 + 642620 * t5681 - 189750 * t5683 - 1230) * t5672
            t5673 = 5 * phi1
            tfunc[..., c] = (-0.27e2 / 0.4096e4*1j) * np.sqrt(0.19e2) * ((1 + t5672) ** (-0.1e1 / 0.2e1)) * ((1 - t5672) ** (-0.1e1 / 0.2e1)) * ((t5686 + t5687) * np.exp((1j) * (t5673 - 6 * phi2)) + (t5686 - t5687) * np.exp((1j) * (t5673 + 6 * phi2)))

        if Bindx == 286:
            t5703 = np.cos(phi)
            t5702 = t5703 ** 2
            t5705 = t5703 * t5702
            t5706 = t5702 ** 2
            t5707 = t5703 * t5706
            t5708 = t5705 ** 2
            t5709 = t5703 * t5708
            t5710 = t5706 ** 2
            t5712 = t5707 ** 2
            t5714 = t5708 ** 2
            t5718 = 128 * t5705 - 332 * t5707 + 288 * t5709 + (28 * t5710 - 160 * t5712 + 60 * t5714 - 12) * t5703
            t5717 = -13 * t5709 ** 2 - 35 * t5702 - 15 * t5706 + 297 * t5708 - 513 * t5710 + 327 * t5712 - 53 * t5714 + 5
            t5704 = 5 * phi1
            tfunc[..., c] = (0.135e3 / 0.8192e4*1j) * np.sqrt(0.4807e4) * ((t5717 + t5718) * np.exp((1j) * (t5704 - 12 * phi2)) + (-t5717 + t5718) * np.exp((1j) * (t5704 + 12 * phi2))) * ((1 + t5703) ** (-0.1e1 / 0.2e1)) * ((1 - t5703) ** (-0.1e1 / 0.2e1))

        if Bindx == 287:
            t5733 = np.cos(phi)
            t5732 = t5733 ** 2
            t5734 = t5733 * t5732
            t5735 = t5732 ** 2
            t5736 = t5733 * t5735
            t5737 = t5734 ** 2
            t5739 = t5735 ** 2
            t5741 = t5736 ** 2
            t5743 = t5737 ** 2
            t5746 = 45270 * t5734 - 217629 * t5736 + (410700 * t5737 - 270435 * t5739 - 47058 * t5741 + 82225 * t5743 - 2561) * t5733
            t5745 = 3795 * t5732 - 48670 * t5735 + 257454 * t5737 - 595305 * t5739 + 609983 * t5741 - 227700 * t5743 - 69
            tfunc[..., c] = -(0.27e2 / 0.2048e4) * np.sqrt(0.2e1) * ((t5745 + t5746) * np.exp((6*1j) * (phi1 - phi2)) + (t5745 - t5746) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 288:
            t5761 = np.cos(phi)
            t5760 = t5761 ** 2
            t5763 = t5760 ** 2
            t5762 = t5761 * t5760
            t5765 = t5762 ** 2
            t5767 = t5763 ** 2
            t5764 = t5761 * t5763
            t5769 = t5764 ** 2
            t5771 = t5765 ** 2
            t5774 = -6 + 6 * t5760 + 188 * t5763 - 468 * t5765 + 306 * t5767 + 46 * t5769 - 72 * t5771
            t5773 = 144 * t5762 - 135 * t5764 + (-216 * t5765 + 363 * t5767 - 120 * t5769 - 13 * t5771 - 23) * t5761
            tfunc[..., c] = -(0.135e3 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.253e3) * ((-t5773 + t5774) * np.exp((6*1j) * (phi1 - 2 * phi2)) + (t5773 + t5774) * np.exp((6*1j) * (phi1 + 2 * phi2)))

        if Bindx == 289:
            t5789 = np.cos(phi)
            t5788 = t5789 ** 2
            t5791 = t5789 * t5788
            t5794 = t5791 ** 2
            t5800 = t5794 ** 2
            t5802 = -16445 * t5789 * t5800 + 85
            t5792 = t5788 ** 2
            t5793 = t5789 * t5792
            t5798 = t5793 ** 2
            t5796 = t5792 ** 2
            t5790 = 7 * phi1
            t5783 = t5789 * t5794
            t5781 = t5789 * t5796
            t5779 = t5789 * t5798
            tfunc[..., c] = (-0.27e2 / 0.4096e4*1j) * np.sqrt(0.2e1) * np.sqrt((1 - t5789)) * np.sqrt(0.35e2) * ((36685 * t5800 + 34914 * t5779 - 120934 * t5798 - 7975 * t5781 + 153963 * t5796 - 29364 * t5783 - 95028 * t5794 + 25029 * t5793 + 29075 * t5792 - 6478 * t5791 - 3846 * t5788 + 319 * t5789 + t5802) * np.exp((1j) * (t5790 - 6 * phi2)) + (69575 * t5800 + 71346 * t5779 - 84502 * t5798 - 197461 * t5781 - 35523 * t5796 + 147804 * t5783 + 82140 * t5794 - 37917 * t5793 - 33871 * t5792 + 1682 * t5791 + 4314 * t5788 + 149 * t5789 - t5802) * np.exp((1j) * (t5790 + 6 * phi2))) * ((1 + t5789) ** (-0.1e1 / 0.2e1))

        if Bindx == 290:
            t5818 = np.cos(phi)
            t5817 = t5818 ** 2
            t5820 = t5818 * t5817
            t5821 = t5817 ** 2
            t5822 = t5818 * t5821
            t5823 = t5820 ** 2
            t5824 = t5818 * t5823
            t5825 = t5821 ** 2
            t5827 = t5822 ** 2
            t5829 = t5823 ** 2
            t5833 = -136 * t5820 - 116 * t5822 + 720 * t5824 + (-644 * t5825 + 56 * t5827 + 84 * t5829 + 36) * t5818
            t5832 = -13 * t5824 ** 2 - 35 * t5817 + 357 * t5821 - 567 * t5823 + 27 * t5825 + 423 * t5827 - 185 * t5829 - 7
            t5819 = 7 * phi1
            tfunc[..., c] = (0.27e2 / 0.8192e4*1j) * np.sqrt(0.8855e4) * np.sqrt(0.2e1) * ((t5832 + t5833) * np.exp((1j) * (t5819 - 12 * phi2)) + (-t5832 + t5833) * np.exp((1j) * (t5819 + 12 * phi2))) * ((1 + t5818) ** (-0.1e1 / 0.2e1)) * ((1 - t5818) ** (-0.1e1 / 0.2e1))

        if Bindx == 291:
            t5848 = np.cos(phi)
            t5847 = t5848 ** 2
            t5851 = t5847 ** 2
            t5850 = t5848 * t5847
            t5853 = t5850 ** 2
            t5855 = t5851 ** 2
            t5852 = t5848 * t5851
            t5857 = t5852 ** 2
            t5859 = t5853 ** 2
            t5862 = 5084 * t5847 - 24904 * t5851 + 20568 * t5853 + 69204 * t5855 - 130548 * t5857 + 60720 * t5859 - 124
            t5861 = 15864 * t5850 - 84537 * t5852 + (185544 * t5853 - 164659 * t5855 + 32384 * t5857 + 16445 * t5859 - 1041) * t5848
            t5849 = 4 * phi1
            tfunc[..., c] = (0.27e2 / 0.2048e4) * ((-t5861 + t5862) * np.exp((2*1j) * (t5849 - 3 * phi2)) + (t5861 + t5862) * np.exp((2*1j) * (t5849 + 3 * phi2))) * np.sqrt(0.5e1)

        if Bindx == 292:
            t5877 = np.cos(phi)
            t5876 = t5877 ** 2
            t5880 = t5876 ** 2
            t5879 = t5877 * t5876
            t5882 = t5879 ** 2
            t5884 = t5880 ** 2
            t5881 = t5877 * t5880
            t5886 = t5881 ** 2
            t5888 = t5882 ** 2
            t5891 = 8 + 104 * t5876 - 400 * t5880 - 48 * t5882 + 744 * t5884 - 312 * t5886 - 96 * t5888
            t5890 = -18 * t5879 - 579 * t5881 + (708 * t5882 + 125 * t5884 - 274 * t5886 - 13 * t5888 + 51) * t5877
            t5878 = 2 * phi1
            tfunc[..., c] = -(0.27e2 / 0.4096e4) * ((-t5890 + t5891) * np.exp((4*1j) * (t5878 - 3 * phi2)) + (t5890 + t5891) * np.exp((4*1j) * (t5878 + 3 * phi2))) * np.sqrt(0.1265e4)

        if Bindx == 293:
            t5905 = np.cos(phi)
            t5904 = t5905 ** 2
            t5907 = t5905 * t5904
            t5910 = t5907 ** 2
            t5917 = -7475 * t5910 ** 2 - 27
            t5908 = t5904 ** 2
            t5909 = t5905 * t5908
            t5914 = t5909 ** 2
            t5912 = t5908 ** 2
            t5906 = 3 * phi1
            t5899 = t5905 * t5910
            t5897 = t5905 * t5912
            t5895 = t5905 * t5914
            tfunc[..., c] = (0.27e2 / 0.4096e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.11e2) * ((1 - t5905) ** (0.3e1 / 0.2e1)) * ((16100 * t5895 + 17158 * t5914 - 54096 * t5897 - 6789 * t5912 + 69384 * t5899 - 10044 * t5910 - 42336 * t5909 + 9171 * t5908 + 12404 * t5907 - 1994 * t5904 - 1456 * t5905 + t5917) * np.exp((3*1j) * (t5906 - 2 * phi2)) + (46000 * t5895 + 107042 * t5914 + 95772 * t5897 - 34059 * t5912 - 135024 * t5899 - 80388 * t5910 + 21384 * t5909 + 39357 * t5908 + 9056 * t5907 - 3614 * t5904 - 1348 * t5905 - t5917) * np.exp((3*1j) * (t5906 + 2 * phi2))) * ((1 + t5905) ** (-0.1e1 / 0.2e1))

        if Bindx == 294:
            t5933 = np.cos(phi)
            t5932 = t5933 ** 2
            t5935 = t5933 * t5932
            t5936 = t5932 ** 2
            t5937 = t5933 * t5936
            t5938 = t5935 ** 2
            t5939 = t5933 * t5938
            t5940 = t5936 ** 2
            t5942 = t5937 ** 2
            t5944 = t5938 ** 2
            t5948 = 152 * t5935 - 1012 * t5937 + 528 * t5939 + (924 * t5940 - 552 * t5942 - 108 * t5944 + 68) * t5933
            t5947 = -13 * t5939 ** 2 + 189 * t5932 - 363 * t5936 - 759 * t5938 + 1419 * t5940 - 121 * t5942 - 361 * t5944 + 9
            t5934 = 3 * phi1
            tfunc[..., c] = (-0.135e3 / 0.8192e4*1j) * np.sqrt(0.23e2) * np.sqrt(0.2e1) * ((1 + t5933) ** (-0.1e1 / 0.2e1)) * ((1 - t5933) ** (-0.1e1 / 0.2e1)) * ((-t5947 + t5948) * np.exp((3*1j) * (t5934 - 4 * phi2)) + (t5947 + t5948) * np.exp((3*1j) * (t5934 + 4 * phi2)))

        if Bindx == 295:
            t5963 = np.cos(phi)
            t5962 = t5963 ** 2
            t5966 = t5962 ** 2
            t5965 = t5963 * t5962
            t5968 = t5965 ** 2
            t5970 = t5966 ** 2
            t5967 = t5963 * t5966
            t5972 = t5967 ** 2
            t5974 = t5968 ** 2
            t5977 = 17 - 391 * t5962 + 2246 * t5966 - 4182 * t5968 + 1605 * t5970 + 2205 * t5972 - 1500 * t5974
            t5976 = 210 * t5965 + 1377 * t5967 + (-5436 * t5968 + 5951 * t5970 - 1702 * t5972 - 325 * t5974 - 75) * t5963
            t5964 = 5 * phi1
            tfunc[..., c] = -(0.27e2 / 0.2048e4) * np.sqrt(0.2e1) * np.sqrt(0.253e3) * ((-t5976 + t5977) * np.exp((2*1j) * (t5964 - 3 * phi2)) + (t5976 + t5977) * np.exp((2*1j) * (t5964 + 3 * phi2)))

        if Bindx == 296:
            t5992 = np.cos(phi)
            t5991 = t5992 ** 2
            t5995 = t5991 ** 2
            t5994 = t5992 * t5991
            t5997 = t5994 ** 2
            t5999 = t5995 ** 2
            t5996 = t5992 * t5995
            t6001 = t5996 ** 2
            t6003 = t5997 ** 2
            t6006 = 10 + 310 * t5991 + 220 * t5995 - 1716 * t5997 + 66 * t5999 + 990 * t6001 + 120 * t6003
            t6005 = -528 * t5994 + 825 * t5996 + (1320 * t5997 - 1045 * t5999 - 472 * t6001 - 13 * t6003 - 87) * t5992
            t5993 = 5 * phi1
            tfunc[..., c] = (0.135e3 / 0.4096e4) * ((t6005 + t6006) * np.exp((2*1j) * (t5993 - 6 * phi2)) + (-t6005 + t6006) * np.exp((2*1j) * (t5993 + 6 * phi2))) * np.sqrt(0.2e1)

        if Bindx == 297:
            t6019 = np.cos(phi)
            t6018 = t6019 ** 2
            t6022 = t6018 ** 2
            t6023 = t6019 * t6022
            t6028 = t6023 ** 2
            t6030 = -325 * t6019 * t6028 - 59
            t6026 = t6022 ** 2
            t6021 = t6019 * t6018
            t6024 = t6021 ** 2
            t6020 = 11 * phi1
            t6013 = t6019 * t6024
            t6011 = t6019 * t6026
            tfunc[..., c] = (0.27e2 / 0.4096e4*1j) * ((1 - t6019) ** (0.5e1 / 0.2e1)) * np.sqrt(0.253e3) * ((1 + t6019) ** (-0.1e1 / 0.2e1)) * ((-675 * t6028 - 841 * t6011 + 2423 * t6026 + 450 * t6013 - 3278 * t6024 + 446 * t6023 + 2046 * t6022 - 503 * t6021 - 575 * t6018 + 123 * t6019 - t6030) * np.exp((1j) * (t6020 - 6 * phi2)) + (-2625 * t6028 - 9059 * t6011 - 17031 * t6026 - 17874 * t6013 - 8106 * t6024 + 3066 * t6023 + 6066 * t6022 + 2919 * t6021 + 251 * t6018 - 231 * t6019 + t6030) * np.exp((1j) * (t6020 + 6 * phi2)))

        if Bindx == 298:
            t6046 = np.cos(phi)
            t6045 = t6046 ** 2
            t6048 = t6046 * t6045
            t6049 = t6045 ** 2
            t6050 = t6046 * t6049
            t6051 = t6048 ** 2
            t6052 = t6046 * t6051
            t6053 = t6049 ** 2
            t6055 = t6050 ** 2
            t6057 = t6051 ** 2
            t6061 = 992 * t6048 - 308 * t6050 - 3168 * t6052 + (836 * t6053 + 1408 * t6055 + 132 * t6057 + 108) * t6046
            t6060 = -13 * t6052 ** 2 - 451 * t6045 - 1023 * t6049 + 2409 * t6051 + 1551 * t6053 - 1881 * t6055 - 581 * t6057 - 11
            t6047 = 11 * phi1
            tfunc[..., c] = (0.135e3 / 0.8192e4*1j) * ((t6060 + t6061) * np.exp((1j) * (t6047 - 12 * phi2)) + (-t6060 + t6061) * np.exp((1j) * (t6047 + 12 * phi2))) * ((1 + t6046) ** (-0.1e1 / 0.2e1)) * ((1 - t6046) ** (-0.1e1 / 0.2e1))

        if Bindx == 299:
            t6076 = np.cos(phi)
            t6075 = t6076 ** 2
            t6079 = t6075 ** 2
            t6078 = t6076 * t6075
            t6081 = t6078 ** 2
            t6083 = t6079 ** 2
            t6080 = t6076 * t6079
            t6085 = t6080 ** 2
            t6087 = t6081 ** 2
            t6090 = -6 + 6 * t6075 + 188 * t6079 - 468 * t6081 + 306 * t6083 + 46 * t6085 - 72 * t6087
            t6089 = 144 * t6078 - 135 * t6080 + (-216 * t6081 + 363 * t6083 - 120 * t6085 - 13 * t6087 - 23) * t6076
            t6077 = 2 * phi1
            tfunc[..., c] = -(0.135e3 / 0.4096e4) * np.sqrt(0.2e1) * np.sqrt(0.253e3) * ((-t6089 + t6090) * np.exp((6*1j) * (t6077 - phi2)) + (t6089 + t6090) * np.exp((6*1j) * (t6077 + phi2)))

        if Bindx == 300:
            t6105 = np.cos(phi)
            t6104 = t6105 ** 2
            t6107 = t6104 ** 2
            t6106 = t6105 * t6104
            t6109 = t6106 ** 2
            t6111 = t6107 ** 2
            t6108 = t6105 * t6107
            t6113 = t6108 ** 2
            t6115 = t6109 ** 2
            t6118 = 12 + 636 * t6104 + 3080 * t6107 + 792 * t6109 - 4356 * t6111 - 2068 * t6113 - 144 * t6115
            t6117 = 1782 * t6106 + 3069 * t6108 + (-2508 * t6109 - 3795 * t6111 - 714 * t6113 - 13 * t6115 + 131) * t6105
            tfunc[..., c] = -(0.27e2 / 0.8192e4) * np.sqrt(0.2e1) * ((-t6117 + t6118) * np.exp((12*1j) * (phi1 - phi2)) + (t6117 + t6118) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 301:
            t6131 = np.cos(phi)
            t6130 = t6131 ** 2
            t6134 = t6130 ** 2
            t6137 = t6134 ** 2
            t6135 = t6131 * t6134
            t6139 = t6135 ** 2
            t6140 = t6131 * t6139
            t6143 = -t6131 * t6140 + 12 * t6130 - 27 * t6134 + 27 * t6137 - 12 * t6139 + 1
            t6142 = 6 * t6140 + 2 * (-18 * t6130 + 18) * t6135 + 2 * (-t6130 + t6137 - 3) * t6131
            t6132 = 13 * phi1
            tfunc[..., c] = (-0.135e3 / 0.4096e4*1j) * np.sqrt(0.3289e4) * np.sqrt((1 - t6131)) * np.sqrt((1 + t6131)) * ((t6142 + t6143) * np.exp((1j) * (t6132 - 6 * phi2)) + (t6142 - t6143) * np.exp((1j) * (t6132 + 6 * phi2)))

        if Bindx == 302:
            t6158 = np.cos(phi)
            t6157 = t6158 ** 2
            t6160 = t6158 * t6157
            t6163 = t6160 ** 2
            t6169 = t6163 ** 2
            t6171 = -t6158 * t6169 - 1
            t6161 = t6157 ** 2
            t6162 = t6158 * t6161
            t6167 = t6162 ** 2
            t6165 = t6161 ** 2
            t6159 = 13 * phi1
            t6152 = t6158 * t6163
            t6150 = t6158 * t6165
            t6148 = t6158 * t6167
            tfunc[..., c] = (-0.27e2 / 0.8192e4*1j) * np.sqrt(0.13e2) * np.sqrt((1 - t6158)) * ((11 * t6169 - 54 * t6148 + 154 * t6167 - 275 * t6150 + 297 * t6165 - 132 * t6152 - 132 * t6163 + 297 * t6162 - 275 * t6161 + 154 * t6160 - 54 * t6157 + 11 * t6158 + t6171) * np.exp((1j) * (t6159 - 12 * phi2)) + (13 * t6169 + 78 * t6148 + 286 * t6167 + 715 * t6150 + 1287 * t6165 + 1716 * t6152 + 1716 * t6163 + 1287 * t6162 + 715 * t6161 + 286 * t6160 + 78 * t6157 + 13 * t6158 - t6171) * np.exp((1j) * (t6159 + 12 * phi2))) * ((1 + t6158) ** (-0.1e1 / 0.2e1))

        if Bindx == 303:
            t6177 = np.sin(phi)
            t6172 = t6177 ** 2
            t6173 = t6177 * t6172
            t6175 = t6177 * t6173 ** 2
            tfunc[..., c] = -(0.435e3 / 0.8192e4) * np.exp((-14*1j) * phi1) * np.sqrt(0.44574e5) * t6175 ** 2

        if Bindx == 304:
            t6193 = np.cos(phi)
            t6209 = -6 * t6193
            t6192 = t6193 ** 2
            t6195 = t6193 * t6192
            t6196 = t6192 ** 2
            t6197 = t6193 * t6196
            t6198 = t6195 ** 2
            t6199 = t6193 * t6198
            t6200 = t6196 ** 2
            t6202 = t6197 ** 2
            t6204 = t6198 ** 2
            t6208 = t6204 * t6209 + 4 * t6195 + 38 * t6197 - 72 * t6199 + t6209 + (38 * t6200 + 4 * t6202) * t6193
            t6207 = t6199 ** 2 + 11 * t6192 - 39 * t6196 + 27 * t6198 + 27 * t6200 - 39 * t6202 + 11 * t6204 + 1
            t6194 = 7 * phi1
            tfunc[..., c] = (0.87e2 / 0.32768e5) * np.sqrt(0.345345e6) * np.sqrt(0.2e1) * ((t6207 + t6208) * np.exp((-2*1j) * (t6194 - 3 * phi2)) + (t6207 - t6208) * np.exp((-2*1j) * (t6194 + 3 * phi2)))

        if Bindx == 305:
            t6224 = np.cos(phi)
            t6223 = t6224 ** 2
            t6226 = t6224 * t6223
            t6227 = t6223 ** 2
            t6228 = t6224 * t6227
            t6230 = t6227 ** 2
            t6232 = t6228 ** 2
            t6229 = t6226 ** 2
            t6234 = t6229 ** 2
            t6235 = t6224 * t6234
            t6238 = 208 * t6226 + 572 * t6228 - 12 * t6235 + (-572 * t6230 - 208 * t6232 + 12) * t6224
            t6237 = t6224 * t6235 - 65 * t6223 - 429 * t6227 - 429 * t6229 + 429 * t6230 + 429 * t6232 + 65 * t6234 - 1
            t6225 = 7 * phi1
            tfunc[..., c] = (0.87e2 / 0.16384e5) * ((t6237 + t6238) * np.exp((-2*1j) * (t6225 - 6 * phi2)) + (t6237 - t6238) * np.exp((-2*1j) * (t6225 + 6 * phi2))) * np.sqrt(0.21e2)

        if Bindx == 306:
            t6239 = np.cos(phi)
            t6240 = t6239 ** 2
            t6241 = t6239 * t6240
            t6244 = t6241 ** 2
            t6242 = t6240 ** 2
            tfunc[..., c] = (0.435e3 / 0.4096e4*1j) * t6239 * (-21 * t6240 + 35 * t6241 - 35 * t6242 - 7 * t6244 - 1 + (21 * t6242 + t6244 + 7) * t6239) * ((1 + t6239) ** (0.13e2 / 0.2e1)) * np.sqrt(0.312018e6) * np.exp((-13*1j) * phi1) * ((1 - t6239) ** (-0.1e1 / 0.2e1))

        if Bindx == 307:
            t6258 = np.cos(phi)
            t6257 = t6258 ** 2
            t6261 = t6257 ** 2
            t6262 = t6258 * t6261
            t6267 = t6262 ** 2
            t6269 = 7 * t6258 * t6267
            t6265 = t6261 ** 2
            t6260 = t6258 * t6257
            t6263 = t6260 ** 2
            t6259 = 13 * phi1
            t6252 = t6258 * t6263
            t6250 = t6258 * t6265
            tfunc[..., c] = (0.87e2 / 0.16384e5*1j) * np.sqrt(0.2e1) * ((1 + t6258) ** (0.7e1 / 0.2e1)) * np.sqrt(0.49335e5) * ((1 - t6258) ** (-0.1e1 / 0.2e1)) * ((t6269 - 67 * t6267 + 285 * t6250 - 705 * t6265 + 1110 * t6252 - 1134 * t6263 + 714 * t6262 - 210 * t6261 - 45 * t6260 + 65 * t6257 - 23 * t6258 + 3) * np.exp((-1*1j) * (t6259 - 6 * phi2)) + (t6269 + 11 * t6267 - 27 * t6250 - 47 * t6265 + 38 * t6252 + 78 * t6263 - 22 * t6262 - 62 * t6261 + 3 * t6260 + 23 * t6257 + t6258 - 3) * np.exp((-1*1j) * (t6259 + 6 * phi2)))

        if Bindx == 308:
            t6285 = np.cos(phi)
            t6284 = t6285 ** 2
            t6287 = t6285 * t6284
            t6290 = t6287 ** 2
            t6291 = t6285 * t6290
            t6299 = -1287 * t6290 + (-1716 + 7 * t6291) * t6291
            t6296 = t6290 ** 2
            t6288 = t6284 ** 2
            t6289 = t6285 * t6288
            t6294 = t6289 ** 2
            t6292 = t6288 ** 2
            t6286 = 13 * phi1
            t6277 = t6285 * t6292
            t6275 = t6285 * t6294
            t6273 = t6285 * t6296
            tfunc[..., c] = (0.87e2 / 0.8192e4*1j) * np.sqrt((1 + t6285)) * np.sqrt(0.3e1) * ((1 - t6285) ** (-0.1e1 / 0.2e1)) * ((-85 * t6273 + 468 * t6296 - 1534 * t6275 + 3289 * t6294 - 4719 * t6277 + 4290 * t6292 + 2717 * t6289 - 2288 * t6288 + 1170 * t6287 - 377 * t6284 + 71 * t6285 - 6 + t6299) * np.exp((-1*1j) * (t6286 - 12 * phi2)) + (71 * t6273 + 312 * t6296 + 754 * t6275 + 1001 * t6294 + 429 * t6277 - 858 * t6292 - 143 * t6289 + 572 * t6288 + 546 * t6287 + 247 * t6284 + 59 * t6285 + 6 + t6299) * np.exp((-1*1j) * (t6286 + 12 * phi2)))

        if Bindx == 309:
            t6305 = np.sin(phi)
            t6301 = t6305 ** 2
            t6302 = t6305 * t6301
            t6303 = t6302 ** 2
            t6300 = np.cos(phi)
            tfunc[..., c] = (0.145e3 / 0.4096e4) * np.exp((-12*1j) * phi1) * np.sqrt(0.52003e5) * t6303 ** 2 * (27 * t6300 ** 2 - 1)

        if Bindx == 310:
            t6321 = np.cos(phi)
            t6320 = t6321 ** 2
            t6323 = t6321 * t6320
            t6324 = t6320 ** 2
            t6325 = t6321 * t6324
            t6326 = t6323 ** 2
            t6327 = t6321 * t6326
            t6328 = t6324 ** 2
            t6330 = t6325 ** 2
            t6332 = t6326 ** 2
            t6336 = -752 * t6323 + 3708 * t6325 - 5760 * t6327 + (2372 * t6328 + 1392 * t6330 - 972 * t6332 + 12) * t6321
            t6335 = 189 * t6327 ** 2 + 435 * t6320 - 1161 * t6324 - 729 * t6326 + 5049 * t6328 - 5079 * t6330 + 1325 * t6332 - 29
            t6322 = 2 * phi1
            tfunc[..., c] = (0.29e2 / 0.16384e5) * ((t6335 + t6336) * np.exp((-6*1j) * (t6322 - phi2)) + (t6335 - t6336) * np.exp((-6*1j) * (t6322 + phi2))) * np.sqrt(0.16445e5)

        if Bindx == 311:
            t6352 = np.cos(phi)
            t6351 = t6352 ** 2
            t6353 = t6352 * t6351
            t6354 = t6351 ** 2
            t6355 = t6352 * t6354
            t6356 = t6353 ** 2
            t6357 = t6352 * t6356
            t6358 = t6354 ** 2
            t6360 = t6355 ** 2
            t6362 = t6356 ** 2
            t6366 = -11024 * t6353 + 10296 * t6355 + 41184 * t6357 + (-19448 * t6358 - 21840 * t6360 - 1944 * t6362 - 1320) * t6352
            t6365 = 189 * t6357 ** 2 + 5343 * t6351 + 9009 * t6354 - 36465 * t6356 - 14157 * t6358 + 31317 * t6360 + 8723 * t6362 + 137
            tfunc[..., c] = (0.29e2 / 0.16384e5) * np.sqrt(0.2e1) * ((t6365 + t6366) * np.exp((-12*1j) * (phi1 - phi2)) + (t6365 - t6366) * np.exp((-12*1j) * (phi1 + phi2)))

        if Bindx == 312:
            t6367 = np.cos(phi)
            tfunc[..., c] = (0.145e3 / 0.4096e4*1j) * (9 * t6367 ** 2 - 1) * t6367 * ((1 + t6367) ** (0.11e2 / 0.2e1)) * np.sqrt(0.4056234e7) * np.exp((-11*1j) * phi1) * ((1 - t6367) ** (0.11e2 / 0.2e1))

        if Bindx == 313:
            t6381 = np.cos(phi)
            t6380 = t6381 ** 2
            t6383 = t6381 * t6380
            t6386 = t6383 ** 2
            t6393 = 819 * t6386 ** 2
            t6384 = t6380 ** 2
            t6385 = t6381 * t6384
            t6390 = t6385 ** 2
            t6388 = t6384 ** 2
            t6382 = 11 * phi1
            t6375 = t6381 * t6386
            t6373 = t6381 * t6388
            t6371 = t6381 * t6390
            tfunc[..., c] = (0.29e2 / 0.16384e5*1j) * np.sqrt(0.2e1) * ((1 + t6381) ** (0.5e1 / 0.2e1)) * np.sqrt(0.3795e4) * ((1 - t6381) ** (-0.1e1 / 0.2e1)) * ((t6393 - 6318 * t6371 + 20384 * t6390 - 34250 * t6373 + 28035 * t6388 - 1068 * t6375 - 18984 * t6386 + 15372 * t6385 - 2775 * t6384 - 2310 * t6383 + 1224 * t6380 - 98 * t6381 - 31) * np.exp((-1*1j) * (t6382 - 6 * phi2)) + (t6393 + 1404 * t6371 - 2782 * t6390 - 5452 * t6373 + 3417 * t6388 + 8216 * t6375 - 1780 * t6386 - 5976 * t6385 + 373 * t6384 + 2092 * t6383 - 78 * t6380 - 284 * t6381 + 31) * np.exp((-1*1j) * (t6382 + 6 * phi2)))

        if Bindx == 314:
            t6410 = np.cos(phi)
            t6409 = t6410 ** 2
            t6413 = t6409 ** 2
            t6412 = t6410 * t6409
            t6415 = t6412 ** 2
            t6417 = t6413 ** 2
            t6414 = t6410 * t6413
            t6419 = t6414 ** 2
            t6421 = t6415 ** 2
            t6416 = t6410 * t6415
            t6423 = t6416 ** 2
            t6426 = 38 + 1026 * t6409 - 1394 * t6413 - 7062 * t6415 + 10098 * t6417 + 2662 * t6419 - 4774 * t6421 - 594 * t6423
            t6425 = -1199 * t6412 + 6237 * t6414 - 627 * t6416 + (-10637 * t6417 + 4131 * t6419 + 2351 * t6421 + 63 * t6423 - 319) * t6410
            t6411 = 11 * phi1
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.39e2) * ((1 + t6410) ** (-0.1e1 / 0.2e1)) * ((1 - t6410) ** (-0.1e1 / 0.2e1)) * ((t6425 + t6426) * np.exp((-1*1j) * (t6411 - 12 * phi2)) + (t6425 - t6426) * np.exp((-1*1j) * (t6411 + 12 * phi2)))

        if Bindx == 315:
            t6434 = np.sin(phi)
            t6430 = t6434 ** 2
            t6432 = t6434 * t6430 ** 2
            t6427 = np.cos(phi)
            t6428 = t6427 ** 2
            tfunc[..., c] = -(0.29e2 / 0.8192e4) * np.exp((-10*1j) * phi1) * np.sqrt(0.4056234e7) * t6432 ** 2 * (1 + (-50 + 225 * t6428) * t6428)

        if Bindx == 316:
            t6450 = np.cos(phi)
            t6449 = t6450 ** 2
            t6452 = t6450 * t6449
            t6453 = t6449 ** 2
            t6454 = t6450 * t6453
            t6455 = t6452 ** 2
            t6456 = t6450 * t6455
            t6457 = t6453 ** 2
            t6459 = t6454 ** 2
            t6461 = t6455 ** 2
            t6465 = -7532 * t6452 + 27822 * t6454 - 34152 * t6456 + (-5714 * t6457 + 36500 * t6459 - 17550 * t6461 + 626) * t6450
            t6464 = 4095 * t6456 ** 2 + 37 * t6449 + 6039 * t6453 - 38331 * t6455 + 81477 * t6457 - 68201 * t6459 + 14885 * t6461 - 1
            t6451 = 5 * phi1
            tfunc[..., c] = (0.29e2 / 0.32768e5) * np.sqrt(0.3795e4) * np.sqrt(0.2e1) * ((t6464 + t6465) * np.exp((-2*1j) * (t6451 - 3 * phi2)) + (t6464 - t6465) * np.exp((-2*1j) * (t6451 + 3 * phi2)))

        if Bindx == 317:
            t6481 = np.cos(phi)
            t6480 = t6481 ** 2
            t6483 = t6481 * t6480
            t6484 = t6480 ** 2
            t6485 = t6481 * t6484
            t6486 = t6483 ** 2
            t6487 = t6481 * t6486
            t6488 = t6484 ** 2
            t6490 = t6485 ** 2
            t6492 = t6486 ** 2
            t6496 = 80 * t6483 - 3828 * t6485 + 4224 * t6487 + (3124 * t6488 - 3280 * t6490 - 540 * t6492 + 220) * t6481
            t6495 = 63 * t6487 ** 2 - 527 * t6480 + 2013 * t6484 + 1485 * t6486 - 6765 * t6488 + 1859 * t6490 + 1903 * t6492 - 31
            t6482 = 5 * phi1
            tfunc[..., c] = (0.145e3 / 0.16384e5) * ((t6495 + t6496) * np.exp((-2*1j) * (t6482 - 6 * phi2)) + (t6495 - t6496) * np.exp((-2*1j) * (t6482 + 6 * phi2))) * np.sqrt(0.39e2)

        if Bindx == 318:
            t6497 = np.cos(phi)
            t6498 = t6497 ** 2
            tfunc[..., c] = (-0.29e2 / 0.2048e4*1j) * (3 + (-50 + 135 * t6498) * t6498) * t6497 * ((1 + t6497) ** (0.9e1 / 0.2e1)) * np.sqrt(0.3380195e7) * np.exp((-9*1j) * phi1) * ((1 - t6497) ** (0.9e1 / 0.2e1))

        if Bindx == 319:
            t6514 = np.cos(phi)
            t6513 = t6514 ** 2
            t6516 = t6514 * t6513
            t6519 = t6516 ** 2
            t6525 = t6519 ** 2
            t6527 = 12285 * t6514 * t6525
            t6517 = t6513 ** 2
            t6518 = t6514 * t6517
            t6523 = t6518 ** 2
            t6521 = t6517 ** 2
            t6515 = 3 * phi1
            t6508 = t6514 * t6519
            t6506 = t6514 * t6521
            t6504 = t6514 * t6523
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * ((1 + t6514) ** (0.3e1 / 0.2e1)) * np.sqrt(0.253e3) * ((1 - t6514) ** (-0.1e1 / 0.2e1)) * ((t6527 - 71955 * t6525 + 152230 * t6504 - 97010 * t6523 - 123665 * t6506 + 229431 * t6521 - 70908 * t6508 - 92652 * t6519 + 72459 * t6518 + 1035 * t6517 - 14346 * t6516 + 2558 * t6513 + 617 * t6514 - 79) * np.exp((-3*1j) * (t6515 - 2 * phi2)) + (t6527 + 22815 * t6525 - 37310 * t6504 - 83690 * t6523 + 39235 * t6506 + 120129 * t6521 - 15204 * t6508 - 84684 * t6519 + 819 * t6518 + 29745 * t6517 - 126 * t6516 - 4394 * t6513 + 301 * t6514 + 79) * np.exp((-3*1j) * (t6515 + 2 * phi2)))

        if Bindx == 320:
            t6544 = np.cos(phi)
            t6543 = t6544 ** 2
            t6547 = t6543 ** 2
            t6546 = t6544 * t6543
            t6549 = t6546 ** 2
            t6551 = t6547 ** 2
            t6548 = t6544 * t6547
            t6553 = t6548 ** 2
            t6555 = t6549 ** 2
            t6550 = t6544 * t6549
            t6557 = t6550 ** 2
            t6560 = -74 - 518 * t6543 + 5542 * t6547 - 8646 * t6549 - 4686 * t6551 + 14718 * t6553 - 4878 * t6555 - 1458 * t6557
            t6559 = -1677 * t6546 - 3333 * t6548 + 16071 * t6550 + (-12859 * t6551 - 3127 * t6553 + 4313 * t6555 + 189 * t6557 + 423) * t6544
            t6545 = 3 * phi1
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.65e2) * np.sqrt(0.2e1) * ((1 + t6544) ** (-0.1e1 / 0.2e1)) * ((1 - t6544) ** (-0.1e1 / 0.2e1)) * ((t6559 + t6560) * np.exp((-3*1j) * (t6545 - 4 * phi2)) + (t6559 - t6560) * np.exp((-3*1j) * (t6545 + 4 * phi2)))

        if Bindx == 321:
            t6568 = np.sin(phi)
            t6565 = t6568 ** 2
            t6566 = t6565 ** 2
            t6561 = np.cos(phi)
            t6562 = t6561 ** 2
            t6563 = t6562 ** 2
            tfunc[..., c] = (0.29e2 / 0.4096e4) * np.exp((-8*1j) * phi1) * np.sqrt(0.881790e6) * t6566 ** 2 * (-575 * t6563 - 1 + (1035 * t6563 + 69) * t6562)

        if Bindx == 322:
            t6584 = np.cos(phi)
            t6583 = t6584 ** 2
            t6586 = t6584 * t6583
            t6587 = t6583 ** 2
            t6588 = t6584 * t6587
            t6589 = t6586 ** 2
            t6590 = t6584 * t6589
            t6591 = t6587 ** 2
            t6593 = t6588 ** 2
            t6595 = t6589 ** 2
            t6599 = -26848 * t6586 + 59784 * t6588 + 165120 * t6590 + (-719624 * t6591 + 842720 * t6593 - 322920 * t6595 + 1768) * t6584
            t6598 = 94185 * t6590 ** 2 - 17105 * t6583 + 164979 * t6587 - 631173 * t6589 + 1090533 * t6591 - 783955 * t6593 + 82225 * t6595 + 311
            t6585 = 4 * phi1
            tfunc[..., c] = (0.29e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.33e2) * ((t6598 + t6599) * np.exp((-2*1j) * (t6585 - 3 * phi2)) + (t6598 - t6599) * np.exp((-2*1j) * (t6585 + 3 * phi2)))

        if Bindx == 323:
            t6615 = np.cos(phi)
            t6614 = t6615 ** 2
            t6617 = t6615 * t6614
            t6618 = t6614 ** 2
            t6619 = t6615 * t6618
            t6620 = t6617 ** 2
            t6621 = t6615 * t6620
            t6622 = t6618 ** 2
            t6624 = t6619 ** 2
            t6626 = t6620 ** 2
            t6630 = 608 * t6617 - 528 * t6619 - 2112 * t6621 + (3344 * t6622 - 800 * t6624 - 432 * t6626 - 80) * t6615
            t6629 = 63 * t6621 ** 2 - 19 * t6614 - 957 * t6618 + 2805 * t6620 - 1551 * t6622 - 1441 * t6624 + 1081 * t6626 + 19
            t6616 = 2 * phi1
            tfunc[..., c] = (0.29e2 / 0.8192e4) * ((t6629 + t6630) * np.exp((-4*1j) * (t6616 - 3 * phi2)) + (t6629 - t6630) * np.exp((-4*1j) * (t6616 + 3 * phi2))) * np.sqrt(0.4485e4)

        if Bindx == 324:
            t6631 = np.cos(phi)
            t6632 = t6631 ** 2
            t6633 = t6632 ** 2
            tfunc[..., c] = (0.29e2 / 0.2048e4*1j) * (-805 * t6633 - 7 + (1035 * t6633 + 161) * t6632) * t6631 * ((1 + t6631) ** (0.7e1 / 0.2e1)) * np.sqrt(0.692835e6) * np.exp((-7*1j) * phi1) * ((1 - t6631) ** (0.7e1 / 0.2e1))

        if Bindx == 325:
            t6650 = np.cos(phi)
            t6649 = t6650 ** 2
            t6652 = t6650 * t6649
            t6655 = t6652 ** 2
            t6656 = t6650 * t6655
            t6664 = 148005 * t6656 ** 2
            t6661 = t6655 ** 2
            t6653 = t6649 ** 2
            t6654 = t6650 * t6653
            t6659 = t6654 ** 2
            t6657 = t6653 ** 2
            t6651 = 7 * phi1
            t6642 = t6650 * t6657
            t6640 = t6650 * t6659
            t6638 = t6650 * t6661
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt((1 + t6650)) * np.sqrt(0.21e2) * ((1 - t6650) ** (-0.1e1 / 0.2e1)) * ((-592020 * t6638 + 1001880 * t6640 - 152812 * t6642 - 3813 * t6649 + 3372 * t6650 - 67048 * t6652 + 95307 * t6653 + 342228 * t6654 - 639777 * t6655 - 543792 * t6656 + 1650693 * t6657 - 1719135 * t6659 + 476905 * t6661 + 7 + t6664) * np.exp((-1*1j) * (t6651 - 6 * phi2)) + (296010 * t6638 - 1067660 * t6640 + 1521542 * t6642 - 2945 * t6649 + 3386 * t6650 - 67916 * t6652 + 39657 * t6653 + 397878 * t6654 - 100329 * t6655 - 1083240 * t6656 - 23661 * t6657 + 350405 * t6659 - 411125 * t6661 - 7 + t6664) * np.exp((-1*1j) * (t6651 + 6 * phi2)))

        if Bindx == 326:
            t6681 = np.cos(phi)
            t6680 = t6681 ** 2
            t6684 = t6680 ** 2
            t6683 = t6681 * t6680
            t6686 = t6683 ** 2
            t6688 = t6684 ** 2
            t6685 = t6681 * t6684
            t6690 = t6685 ** 2
            t6692 = t6686 ** 2
            t6687 = t6681 * t6686
            t6694 = t6687 ** 2
            t6697 = 2 - 18 * t6680 - 14 * t6684 + 270 * t6686 - 522 * t6688 + 314 * t6690 + 22 * t6692 - 54 * t6694
            t6696 = 71 * t6683 - 225 * t6685 + 171 * t6687 + (193 * t6688 - 315 * t6690 + 101 * t6692 + 9 * t6694 - 5) * t6681
            t6682 = 7 * phi1
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.345345e6) * np.sqrt(0.2e1) * ((1 + t6681) ** (-0.1e1 / 0.2e1)) * ((1 - t6681) ** (-0.1e1 / 0.2e1)) * ((t6696 + t6697) * np.exp((-1*1j) * (t6682 - 12 * phi2)) + (t6696 - t6697) * np.exp((-1*1j) * (t6682 + 12 * phi2)))

        if Bindx == 327:
            t6706 = np.sin(phi)
            t6703 = t6706 ** 2
            t6704 = t6706 * t6703
            t6698 = np.cos(phi)
            t6699 = t6698 ** 2
            t6700 = t6699 ** 2
            tfunc[..., c] = -(0.29e2 / 0.8192e4) * np.exp((-6*1j) * phi1) * np.sqrt(0.3233230e7) * t6704 ** 2 * (-84 * t6699 + 1 + (-3220 * t6699 + 966 + 3105 * t6700) * t6700)

        if Bindx == 328:
            t6722 = np.cos(phi)
            t6721 = t6722 ** 2
            t6723 = t6722 * t6721
            t6724 = t6721 ** 2
            t6725 = t6722 * t6724
            t6726 = t6723 ** 2
            t6727 = t6722 * t6726
            t6728 = t6724 ** 2
            t6730 = t6725 ** 2
            t6732 = t6726 ** 2
            t6736 = 520532 * t6723 - 4172562 * t6725 + 15354648 * t6727 + (-27848722 * t6728 + 24151380 * t6730 - 7992270 * t6732 - 21198) * t6722
            t6735 = 3108105 * t6727 ** 2 - 230253 * t6721 + 2425617 * t6724 - 8886957 * t6726 + 13338963 * t6728 - 5787375 * t6730 - 3963245 * t6732 + 3337
            tfunc[..., c] = (0.29e2 / 0.32768e5) * np.sqrt(0.2e1) * ((t6735 + t6736) * np.exp((-6*1j) * (phi1 - phi2)) + (t6735 - t6736) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 329:
            t6752 = np.cos(phi)
            t6751 = t6752 ** 2
            t6753 = t6752 * t6751
            t6754 = t6751 ** 2
            t6755 = t6752 * t6754
            t6756 = t6753 ** 2
            t6757 = t6752 * t6756
            t6758 = t6754 ** 2
            t6760 = t6755 ** 2
            t6762 = t6756 ** 2
            t6766 = -752 * t6753 + 3708 * t6755 - 5760 * t6757 + (2372 * t6758 + 1392 * t6760 - 972 * t6762 + 12) * t6752
            t6765 = 189 * t6757 ** 2 + 435 * t6751 - 1161 * t6754 - 729 * t6756 + 5049 * t6758 - 5079 * t6760 + 1325 * t6762 - 29
            tfunc[..., c] = (0.29e2 / 0.16384e5) * ((t6765 + t6766) * np.exp((-6*1j) * (phi1 - 2 * phi2)) + (t6765 - t6766) * np.exp((-6*1j) * (phi1 + 2 * phi2))) * np.sqrt(0.16445e5)

        if Bindx == 330:
            t6767 = np.cos(phi)
            t6768 = t6767 ** 2
            t6769 = t6768 ** 2
            tfunc[..., c] = (-0.87e2 / 0.4096e4*1j) * (-140 * t6768 + 5 + (-2300 * t6768 + 966 + 1725 * t6769) * t6769) * t6767 * ((1 + t6767) ** (0.5e1 / 0.2e1)) * np.sqrt(0.646646e6) * np.exp((-5*1j) * phi1) * ((1 - t6767) ** (0.5e1 / 0.2e1))

        if Bindx == 331:
            t6788 = np.cos(phi)
            t6787 = t6788 ** 2
            t6791 = t6787 ** 2
            t6790 = t6788 * t6787
            t6793 = t6790 ** 2
            t6795 = t6791 ** 2
            t6792 = t6788 * t6791
            t6797 = t6792 ** 2
            t6799 = t6793 ** 2
            t6794 = t6788 * t6793
            t6801 = t6794 ** 2
            t6804 = 17175 * t6787 - 222785 * t6791 + 1148347 * t6793 - 2946015 * t6795 + 3989557 * t6797 - 2726075 * t6799 + 740025 * t6801 - 229
            t6803 = -46785 * t6790 + 291903 * t6792 - 673485 * t6794 + (430705 * t6795 + 554829 * t6797 - 904475 * t6799 + 345345 * t6801 + 1963) * t6788
            t6789 = 5 * phi1
            tfunc[..., c] = (0.87e2 / 0.16384e5*1j) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * ((1 + t6788) ** (-0.1e1 / 0.2e1)) * ((1 - t6788) ** (-0.1e1 / 0.2e1)) * ((t6803 - t6804) * np.exp((-1*1j) * (t6789 - 6 * phi2)) + (t6803 + t6804) * np.exp((-1*1j) * (t6789 + 6 * phi2)))

        if Bindx == 332:
            t6821 = np.cos(phi)
            t6820 = t6821 ** 2
            t6824 = t6820 ** 2
            t6823 = t6821 * t6820
            t6826 = t6823 ** 2
            t6828 = t6824 ** 2
            t6825 = t6821 * t6824
            t6830 = t6825 ** 2
            t6832 = t6826 ** 2
            t6827 = t6821 * t6826
            t6834 = t6827 ** 2
            t6837 = -2 + 42 * t6820 - 218 * t6824 + 402 * t6826 - 198 * t6828 - 226 * t6830 + 290 * t6832 - 90 * t6834
            t6836 = -5 * t6823 + 207 * t6825 - 657 * t6827 + (833 * t6828 - 447 * t6830 + 53 * t6832 + 21 * t6834 - 5) * t6821
            t6822 = 5 * phi1
            tfunc[..., c] = (0.435e3 / 0.8192e4*1j) * np.sqrt(0.3289e4) * ((1 + t6821) ** (-0.1e1 / 0.2e1)) * ((1 - t6821) ** (-0.1e1 / 0.2e1)) * ((t6836 + t6837) * np.exp((-1*1j) * (t6822 - 12 * phi2)) + (t6836 - t6837) * np.exp((-1*1j) * (t6822 + 12 * phi2)))

        if Bindx == 333:
            t6846 = np.sin(phi)
            t6844 = t6846 ** 2
            t6838 = np.cos(phi)
            t6839 = t6838 ** 2
            t6840 = t6839 ** 2
            t6842 = t6840 ** 2
            tfunc[..., c] = (0.87e2 / 0.4096e4) * np.exp((-4*1j) * phi1) * np.sqrt(0.85085e5) * t6844 ** 2 * (-1330 * t6840 - 10925 * t6842 - 1 + (6118 * t6840 + 6555 * t6842 + 95) * t6839)

        if Bindx == 334:
            t6862 = np.cos(phi)
            t6861 = t6862 ** 2
            t6865 = t6861 ** 2
            t6864 = t6862 * t6861
            t6867 = t6864 ** 2
            t6868 = t6862 * t6867
            t6869 = t6865 ** 2
            t6866 = t6862 * t6865
            t6871 = t6866 ** 2
            t6873 = t6867 ** 2
            t6877 = 345345 * t6868 ** 2 - 2449 * t6861 + 21251 * t6865 - 2509 * t6867 - 338899 * t6869 + 947485 * t6871 - 970255 * t6873 + 31
            t6876 = 64624 * t6864 - 483996 * t6866 + 1573504 * t6868 + (-2522916 * t6869 + 1963280 * t6871 - 592020 * t6873 - 2476) * t6862
            t6863 = 2 * phi1
            tfunc[..., c] = (0.87e2 / 0.16384e5) * ((t6876 + t6877) * np.exp((-2*1j) * (t6863 - 3 * phi2)) + (-t6876 + t6877) * np.exp((-2*1j) * (t6863 + 3 * phi2))) * np.sqrt(0.19e2)

        if Bindx == 335:
            t6893 = np.cos(phi)
            t6892 = t6893 ** 2
            t6894 = t6893 * t6892
            t6895 = t6892 ** 2
            t6896 = t6893 * t6895
            t6897 = t6894 ** 2
            t6898 = t6893 * t6897
            t6899 = t6895 ** 2
            t6901 = t6896 ** 2
            t6903 = t6897 ** 2
            t6907 = -48 * t6894 + 40 * t6896 + 160 * t6898 + (-360 * t6899 + 272 * t6901 - 72 * t6903 + 8) * t6893
            t6906 = 21 * t6898 ** 2 - 25 * t6892 + 169 * t6895 - 425 * t6897 + 475 * t6899 - 211 * t6901 - 5 * t6903 + 1
            tfunc[..., c] = (0.87e2 / 0.16384e5) * np.sqrt(0.312455e6) * np.sqrt(0.2e1) * ((t6906 + t6907) * np.exp((-4*1j) * (phi1 - 3 * phi2)) + (t6906 - t6907) * np.exp((-4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 336:
            t6908 = np.cos(phi)
            t6909 = t6908 ** 2
            t6910 = t6909 ** 2
            t6912 = t6910 ** 2
            tfunc[..., c] = (0.29e2 / 0.4096e4*1j) * (-26334 * t6910 - 120175 * t6912 - 99 + (86526 * t6910 + 58995 * t6912 + 3135) * t6909) * t6908 * ((1 + t6908) ** (0.3e1 / 0.2e1)) * np.sqrt(0.15470e5) * np.exp((-3*1j) * phi1) * ((1 - t6908) ** (0.3e1 / 0.2e1))

        if Bindx == 337:
            t6930 = np.cos(phi)
            t6929 = t6930 ** 2
            t6932 = t6929 ** 2
            t6931 = t6930 * t6929
            t6934 = t6931 ** 2
            t6936 = t6932 ** 2
            t6933 = t6930 * t6932
            t6938 = t6933 ** 2
            t6940 = t6934 ** 2
            t6935 = t6930 * t6934
            t6942 = t6935 ** 2
            t6945 = 10043 * t6929 - 136357 * t6932 + 699343 * t6934 - 1726427 * t6936 + 2214049 * t6938 - 1423815 * t6940 + 363285 * t6942 - 121
            t6944 = 13093 * t6931 - 123587 * t6933 + 551233 * t6935 + (-1303597 * t6936 + 1667615 * t6938 - 1086865 * t6940 + 282555 * t6942 - 447) * t6930
            tfunc[..., c] = (0.29e2 / 0.16384e5*1j) * np.sqrt(0.209e3) * np.sqrt(0.2e1) * ((1 + t6930) ** (-0.1e1 / 0.2e1)) * ((1 - t6930) ** (-0.1e1 / 0.2e1)) * ((t6944 - t6945) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t6944 + t6945) * np.exp((-3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 338:
            t6962 = np.cos(phi)
            t6961 = t6962 ** 2
            t6964 = t6961 ** 2
            t6963 = t6962 * t6961
            t6966 = t6963 ** 2
            t6968 = t6964 ** 2
            t6965 = t6962 * t6964
            t6970 = t6965 ** 2
            t6972 = t6966 ** 2
            t6967 = t6962 * t6966
            t6974 = t6967 ** 2
            t6977 = 2 - 58 * t6961 + 746 * t6964 - 2930 * t6966 + 5350 * t6968 - 5102 * t6970 + 2478 * t6972 - 486 * t6974
            t6976 = -701 * t6963 + 2191 * t6965 - 3065 * t6967 + (1745 * t6968 + 185 * t6970 - 619 * t6972 + 189 * t6974 + 75) * t6962
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.28405e5) * ((1 + t6962) ** (-0.1e1 / 0.2e1)) * ((1 - t6962) ** (-0.1e1 / 0.2e1)) * ((t6976 + t6977) * np.exp((-3*1j) * (phi1 - 4 * phi2)) + (t6976 - t6977) * np.exp((-3*1j) * (phi1 + 4 * phi2)))

        if Bindx == 339:
            t6979 = np.cos(phi)
            t6980 = t6979 ** 2
            t6981 = t6980 ** 2
            t6983 = t6981 ** 2
            t6982 = t6980 * t6981
            t6978 = np.sin(phi)
            tfunc[..., c] = -(0.29e2 / 0.8192e4) * np.exp((-2*1j) * phi1) * np.sqrt(0.2730e4) * t6978 ** 2 * (53295 * t6981 + 735471 * t6983 + 33 + (-298452 + 334305 * t6982) * t6982 + (-817190 * t6983 - 3366) * t6980)

        if Bindx == 340:
            t7001 = np.cos(phi)
            t7000 = t7001 ** 2
            t7002 = t7001 * t7000
            t7003 = t7000 ** 2
            t7004 = t7001 * t7003
            t7005 = t7002 ** 2
            t7006 = t7001 * t7005
            t7007 = t7003 ** 2
            t7009 = t7004 ** 2
            t7011 = t7005 ** 2
            t7015 = -9596 * t7002 + 74182 * t7004 - 241480 * t7006 + (377798 * t7007 - 281980 * t7009 + 80730 * t7011 + 346) * t7001
            t7014 = 94185 * t7006 ** 2 + 1955 * t7000 - 27487 * t7003 + 147411 * t7005 - 383021 * t7007 + 518305 * t7009 - 351325 * t7011 - 23
            tfunc[..., c] = (0.29e2 / 0.32768e5) * np.sqrt(0.10659e5) * np.sqrt(0.2e1) * ((t7014 - t7015) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t7014 + t7015) * np.exp((-2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 341:
            t7031 = np.cos(phi)
            t7030 = t7031 ** 2
            t7033 = t7030 ** 2
            t7032 = t7031 * t7030
            t7035 = t7032 ** 2
            t7036 = t7031 * t7035
            t7037 = t7033 ** 2
            t7034 = t7031 * t7033
            t7039 = t7034 ** 2
            t7041 = t7035 ** 2
            t7045 = 63 * t7036 ** 2 - 31 * t7030 + 77 * t7033 + 45 * t7035 - 365 * t7037 + 499 * t7039 - 289 * t7041 + 1
            t7044 = 208 * t7032 - 740 * t7034 + 1280 * t7036 + (-1180 * t7037 + 560 * t7039 - 108 * t7041 - 20) * t7031
            tfunc[..., c] = (0.29e2 / 0.16384e5) * ((t7044 + t7045) * np.exp((-2*1j) * (phi1 - 6 * phi2)) + (-t7044 + t7045) * np.exp((-2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.1448655e7)

        if Bindx == 342:
            t7046 = np.cos(phi)
            t7047 = t7046 ** 2
            t7049 = t7047 ** 2
            t7050 = t7046 * t7049
            t7048 = t7046 * t7047
            t7051 = t7048 ** 2
            t7059 = -1062347 * t7049 ** 2 + 965770 * t7050 ** 2 - 429 + (554268 - 334305 * t7051) * t7051
            tfunc[..., c] = (0.29e2 / 0.2048e4*1j) * np.exp((-1*1j) * phi1) * np.sqrt(0.210e3) * np.sqrt((1 + t7046)) * t7046 * (-t7059 * t7046 + 14586 * t7047 - 14586 * t7048 - 138567 * t7049 + 138567 * t7050 + t7059) * ((1 - t7046) ** (-0.1e1 / 0.2e1))

        if Bindx == 343:
            t7076 = np.cos(phi)
            t7075 = t7076 ** 2
            t7078 = t7075 ** 2
            t7077 = t7076 * t7075
            t7080 = t7077 ** 2
            t7082 = t7078 ** 2
            t7079 = t7076 * t7078
            t7084 = t7079 ** 2
            t7086 = t7080 ** 2
            t7081 = t7076 * t7080
            t7088 = t7081 ** 2
            t7091 = 1 - 87 * t7075 + 1221 * t7078 - 6371 * t7080 + 15747 * t7082 - 19941 * t7084 + 12535 * t7086 - 3105 * t7088
            t7090 = 843 * t7077 - 7185 * t7079 + 27367 * t7081 + (-54231 * t7082 + 58305 * t7084 - 32315 * t7086 + 7245 * t7088 - 29) * t7076
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.138567e6) * np.sqrt(0.2e1) * ((1 + t7076) ** (-0.1e1 / 0.2e1)) * ((1 - t7076) ** (-0.1e1 / 0.2e1)) * ((t7090 + t7091) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (t7090 - t7091) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 344:
            t7108 = np.cos(phi)
            t7107 = t7108 ** 2
            t7110 = t7107 ** 2
            t7109 = t7108 * t7107
            t7112 = t7109 ** 2
            t7114 = t7110 ** 2
            t7111 = t7108 * t7110
            t7116 = t7111 ** 2
            t7118 = t7112 ** 2
            t7113 = t7108 * t7112
            t7120 = t7113 ** 2
            t7123 = 2 - 66 * t7107 + 354 * t7110 - 850 * t7112 + 1110 * t7114 - 822 * t7116 + 326 * t7118 - 54 * t7120
            t7122 = 129 * t7109 - 543 * t7111 + 1165 * t7113 + (-1425 * t7114 + 1011 * t7116 - 389 * t7118 + 63 * t7120 - 11) * t7108
            tfunc[..., c] = (0.29e2 / 0.4096e4*1j) * np.sqrt(0.111435e6) * ((1 + t7108) ** (-0.1e1 / 0.2e1)) * ((1 - t7108) ** (-0.1e1 / 0.2e1)) * ((t7122 + t7123) * np.exp((-1*1j) * (phi1 - 12 * phi2)) + (t7122 - t7123) * np.exp((-1*1j) * (phi1 + 12 * phi2)))

        if Bindx == 345:
            t7124 = np.cos(phi)
            t7125 = t7124 ** 2
            t7126 = t7125 ** 2
            t7127 = t7125 * t7126
            t7130 = t7127 ** 2
            t7128 = t7126 ** 2
            tfunc[..., c] = -0.490128275e9 / 0.2048e4 * t7130 - 0.421936515e9 / 0.2048e4 * t7128 + 0.140645505e9 / 0.2048e4 * t7127 - 0.22207185e8 / 0.2048e4 * t7126 - 0.12441e5 / 0.2048e4 + (0.145422675e9 / 0.2048e4 * t7130 + 0.646969323e9 / 0.2048e4 * t7128 + 0.1306305e7 / 0.2048e4) * t7125

        if Bindx == 346:
            t7132 = np.cos(phi)
            t7133 = t7132 ** 2
            t7134 = t7133 ** 2
            t7135 = t7133 * t7134
            t7138 = t7135 ** 2
            t7136 = t7134 ** 2
            tfunc[..., c] = 0.29e2 / 0.4096e4 * np.sqrt(0.1616615e7) * (-1221 * t7134 + 6371 * t7135 - 15747 * t7136 - 12535 * t7138 - 1 + (19941 * t7136 + 3105 * t7138 + 87) * t7133) * np.cos((6 * phi2))

        if Bindx == 347:
            t7140 = np.cos(phi)
            t7141 = t7140 ** 2
            t7142 = t7141 ** 2
            t7143 = t7141 * t7142
            t7146 = t7143 ** 2
            t7144 = t7142 ** 2
            tfunc[..., c] = 0.145e3 / 0.4096e4 * np.sqrt(0.52003e5) * np.sqrt(0.2e1) * (-177 * t7142 + 425 * t7143 - 555 * t7144 - 163 * t7146 - 1 + (411 * t7144 + 27 * t7146 + 33) * t7141) * np.cos((12 * phi2))

        if Bindx == 348:
            t7148 = np.cos(phi)
            t7149 = t7148 ** 2
            t7150 = t7149 ** 2
            t7152 = t7150 ** 2
            t7151 = t7149 * t7150
            tfunc[..., c] = (-0.29e2 / 0.2048e4*1j) * np.exp((1j) * phi1) * np.sqrt(0.210e3) * np.sqrt((1 - t7148)) * np.sqrt((1 + t7148)) * t7148 * (138567 * t7150 + 1062347 * t7152 + 429 + (-554268 + 334305 * t7151) * t7151 + (-965770 * t7152 - 14586) * t7149)

        if Bindx == 349:
            t7171 = np.cos(phi)
            t7170 = t7171 ** 2
            t7173 = t7170 ** 2
            t7172 = t7171 * t7170
            t7175 = t7172 ** 2
            t7177 = t7173 ** 2
            t7174 = t7171 * t7173
            t7179 = t7174 ** 2
            t7181 = t7175 ** 2
            t7176 = t7171 * t7175
            t7183 = t7176 ** 2
            t7186 = 1 - 87 * t7170 + 1221 * t7173 - 6371 * t7175 + 15747 * t7177 - 19941 * t7179 + 12535 * t7181 - 3105 * t7183
            t7185 = 843 * t7172 - 7185 * t7174 + 27367 * t7176 + (-54231 * t7177 + 58305 * t7179 - 32315 * t7181 + 7245 * t7183 - 29) * t7171
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.138567e6) * np.sqrt(0.2e1) * ((1 + t7171) ** (-0.1e1 / 0.2e1)) * ((1 - t7171) ** (-0.1e1 / 0.2e1)) * ((t7185 + t7186) * np.exp((1j) * (phi1 - 6 * phi2)) + (t7185 - t7186) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 350:
            t7203 = np.cos(phi)
            t7202 = t7203 ** 2
            t7205 = t7202 ** 2
            t7204 = t7203 * t7202
            t7207 = t7204 ** 2
            t7209 = t7205 ** 2
            t7206 = t7203 * t7205
            t7211 = t7206 ** 2
            t7213 = t7207 ** 2
            t7208 = t7203 * t7207
            t7215 = t7208 ** 2
            t7218 = 2 - 66 * t7202 + 354 * t7205 - 850 * t7207 + 1110 * t7209 - 822 * t7211 + 326 * t7213 - 54 * t7215
            t7217 = 129 * t7204 - 543 * t7206 + 1165 * t7208 + (-1425 * t7209 + 1011 * t7211 - 389 * t7213 + 63 * t7215 - 11) * t7203
            tfunc[..., c] = (0.29e2 / 0.4096e4*1j) * np.sqrt(0.111435e6) * ((1 + t7203) ** (-0.1e1 / 0.2e1)) * ((1 - t7203) ** (-0.1e1 / 0.2e1)) * ((t7217 + t7218) * np.exp((1j) * (phi1 - 12 * phi2)) + (t7217 - t7218) * np.exp((1j) * (phi1 + 12 * phi2)))

        if Bindx == 351:
            t7220 = np.cos(phi)
            t7221 = t7220 ** 2
            t7222 = t7221 ** 2
            t7224 = t7222 ** 2
            t7223 = t7221 * t7222
            t7219 = np.sin(phi)
            tfunc[..., c] = -(0.29e2 / 0.8192e4) * np.exp((2*1j) * phi1) * np.sqrt(0.2730e4) * t7219 ** 2 * (53295 * t7222 + 735471 * t7224 + 33 + (-298452 + 334305 * t7223) * t7223 + (-817190 * t7224 - 3366) * t7221)

        if Bindx == 352:
            t7242 = np.cos(phi)
            t7241 = t7242 ** 2
            t7243 = t7242 * t7241
            t7244 = t7241 ** 2
            t7245 = t7242 * t7244
            t7246 = t7243 ** 2
            t7247 = t7242 * t7246
            t7248 = t7244 ** 2
            t7250 = t7245 ** 2
            t7252 = t7246 ** 2
            t7256 = -9596 * t7243 + 74182 * t7245 - 241480 * t7247 + (377798 * t7248 - 281980 * t7250 + 80730 * t7252 + 346) * t7242
            t7255 = 94185 * t7247 ** 2 + 1955 * t7241 - 27487 * t7244 + 147411 * t7246 - 383021 * t7248 + 518305 * t7250 - 351325 * t7252 - 23
            tfunc[..., c] = (0.29e2 / 0.32768e5) * np.sqrt(0.10659e5) * np.sqrt(0.2e1) * ((t7255 - t7256) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t7255 + t7256) * np.exp((2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 353:
            t7272 = np.cos(phi)
            t7271 = t7272 ** 2
            t7274 = t7271 ** 2
            t7273 = t7272 * t7271
            t7276 = t7273 ** 2
            t7277 = t7272 * t7276
            t7278 = t7274 ** 2
            t7275 = t7272 * t7274
            t7280 = t7275 ** 2
            t7282 = t7276 ** 2
            t7286 = 63 * t7277 ** 2 - 31 * t7271 + 77 * t7274 + 45 * t7276 - 365 * t7278 + 499 * t7280 - 289 * t7282 + 1
            t7285 = 208 * t7273 - 740 * t7275 + 1280 * t7277 + (-1180 * t7278 + 560 * t7280 - 108 * t7282 - 20) * t7272
            tfunc[..., c] = (0.29e2 / 0.16384e5) * ((t7285 + t7286) * np.exp((2*1j) * (phi1 - 6 * phi2)) + (-t7285 + t7286) * np.exp((2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.1448655e7)

        if Bindx == 354:
            t7287 = np.cos(phi)
            t7288 = t7287 ** 2
            t7289 = t7288 ** 2
            t7291 = t7289 ** 2
            tfunc[..., c] = (0.29e2 / 0.4096e4*1j) * np.exp((3*1j) * phi1) * np.sqrt(0.15470e5) * ((1 - t7287) ** (0.3e1 / 0.2e1)) * ((1 + t7287) ** (0.3e1 / 0.2e1)) * t7287 * (-26334 * t7289 - 120175 * t7291 - 99 + (86526 * t7289 + 58995 * t7291 + 3135) * t7288)

        if Bindx == 355:
            t7309 = np.cos(phi)
            t7308 = t7309 ** 2
            t7311 = t7308 ** 2
            t7310 = t7309 * t7308
            t7313 = t7310 ** 2
            t7315 = t7311 ** 2
            t7312 = t7309 * t7311
            t7317 = t7312 ** 2
            t7319 = t7313 ** 2
            t7314 = t7309 * t7313
            t7321 = t7314 ** 2
            t7324 = 10043 * t7308 - 136357 * t7311 + 699343 * t7313 - 1726427 * t7315 + 2214049 * t7317 - 1423815 * t7319 + 363285 * t7321 - 121
            t7323 = 13093 * t7310 - 123587 * t7312 + 551233 * t7314 + (-1303597 * t7315 + 1667615 * t7317 - 1086865 * t7319 + 282555 * t7321 - 447) * t7309
            tfunc[..., c] = (0.29e2 / 0.16384e5*1j) * np.sqrt(0.209e3) * np.sqrt(0.2e1) * ((1 + t7309) ** (-0.1e1 / 0.2e1)) * ((1 - t7309) ** (-0.1e1 / 0.2e1)) * ((t7323 - t7324) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t7323 + t7324) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 356:
            t7341 = np.cos(phi)
            t7340 = t7341 ** 2
            t7343 = t7340 ** 2
            t7342 = t7341 * t7340
            t7345 = t7342 ** 2
            t7347 = t7343 ** 2
            t7344 = t7341 * t7343
            t7349 = t7344 ** 2
            t7351 = t7345 ** 2
            t7346 = t7341 * t7345
            t7353 = t7346 ** 2
            t7356 = 2 - 58 * t7340 + 746 * t7343 - 2930 * t7345 + 5350 * t7347 - 5102 * t7349 + 2478 * t7351 - 486 * t7353
            t7355 = -701 * t7342 + 2191 * t7344 - 3065 * t7346 + (1745 * t7347 + 185 * t7349 - 619 * t7351 + 189 * t7353 + 75) * t7341
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.28405e5) * ((1 + t7341) ** (-0.1e1 / 0.2e1)) * ((1 - t7341) ** (-0.1e1 / 0.2e1)) * ((t7355 + t7356) * np.exp((3*1j) * (phi1 - 4 * phi2)) + (t7355 - t7356) * np.exp((3*1j) * (phi1 + 4 * phi2)))

        if Bindx == 357:
            t7365 = np.sin(phi)
            t7363 = t7365 ** 2
            t7357 = np.cos(phi)
            t7358 = t7357 ** 2
            t7359 = t7358 ** 2
            t7361 = t7359 ** 2
            tfunc[..., c] = (0.87e2 / 0.4096e4) * np.exp((4*1j) * phi1) * np.sqrt(0.85085e5) * t7363 ** 2 * (-1330 * t7359 - 10925 * t7361 - 1 + (6118 * t7359 + 6555 * t7361 + 95) * t7358)

        if Bindx == 358:
            t7381 = np.cos(phi)
            t7380 = t7381 ** 2
            t7384 = t7380 ** 2
            t7383 = t7381 * t7380
            t7386 = t7383 ** 2
            t7387 = t7381 * t7386
            t7388 = t7384 ** 2
            t7385 = t7381 * t7384
            t7390 = t7385 ** 2
            t7392 = t7386 ** 2
            t7396 = 345345 * t7387 ** 2 - 2449 * t7380 + 21251 * t7384 - 2509 * t7386 - 338899 * t7388 + 947485 * t7390 - 970255 * t7392 + 31
            t7395 = 64624 * t7383 - 483996 * t7385 + 1573504 * t7387 + (-2522916 * t7388 + 1963280 * t7390 - 592020 * t7392 - 2476) * t7381
            t7382 = 2 * phi1
            tfunc[..., c] = (0.87e2 / 0.16384e5) * ((t7395 + t7396) * np.exp((2*1j) * (t7382 - 3 * phi2)) + (-t7395 + t7396) * np.exp((2*1j) * (t7382 + 3 * phi2))) * np.sqrt(0.19e2)

        if Bindx == 359:
            t7412 = np.cos(phi)
            t7411 = t7412 ** 2
            t7413 = t7412 * t7411
            t7414 = t7411 ** 2
            t7415 = t7412 * t7414
            t7416 = t7413 ** 2
            t7417 = t7412 * t7416
            t7418 = t7414 ** 2
            t7420 = t7415 ** 2
            t7422 = t7416 ** 2
            t7426 = -48 * t7413 + 40 * t7415 + 160 * t7417 + (-360 * t7418 + 272 * t7420 - 72 * t7422 + 8) * t7412
            t7425 = 21 * t7417 ** 2 - 25 * t7411 + 169 * t7414 - 425 * t7416 + 475 * t7418 - 211 * t7420 - 5 * t7422 + 1
            tfunc[..., c] = (0.87e2 / 0.16384e5) * np.sqrt(0.312455e6) * np.sqrt(0.2e1) * ((t7425 + t7426) * np.exp((4*1j) * (phi1 - 3 * phi2)) + (t7425 - t7426) * np.exp((4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 360:
            t7427 = np.cos(phi)
            t7428 = t7427 ** 2
            t7429 = t7428 ** 2
            tfunc[..., c] = (-0.87e2 / 0.4096e4*1j) * np.exp((5*1j) * phi1) * np.sqrt(0.646646e6) * ((1 - t7427) ** (0.5e1 / 0.2e1)) * ((1 + t7427) ** (0.5e1 / 0.2e1)) * t7427 * (-140 * t7428 + 5 + (-2300 * t7428 + 966 + 1725 * t7429) * t7429)

        if Bindx == 361:
            t7448 = np.cos(phi)
            t7447 = t7448 ** 2
            t7451 = t7447 ** 2
            t7450 = t7448 * t7447
            t7453 = t7450 ** 2
            t7455 = t7451 ** 2
            t7452 = t7448 * t7451
            t7457 = t7452 ** 2
            t7459 = t7453 ** 2
            t7454 = t7448 * t7453
            t7461 = t7454 ** 2
            t7464 = 17175 * t7447 - 222785 * t7451 + 1148347 * t7453 - 2946015 * t7455 + 3989557 * t7457 - 2726075 * t7459 + 740025 * t7461 - 229
            t7463 = -46785 * t7450 + 291903 * t7452 - 673485 * t7454 + (430705 * t7455 + 554829 * t7457 - 904475 * t7459 + 345345 * t7461 + 1963) * t7448
            t7449 = 5 * phi1
            tfunc[..., c] = (0.87e2 / 0.16384e5*1j) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * ((1 + t7448) ** (-0.1e1 / 0.2e1)) * ((1 - t7448) ** (-0.1e1 / 0.2e1)) * ((t7463 - t7464) * np.exp((1j) * (t7449 - 6 * phi2)) + (t7463 + t7464) * np.exp((1j) * (t7449 + 6 * phi2)))

        if Bindx == 362:
            t7481 = np.cos(phi)
            t7480 = t7481 ** 2
            t7484 = t7480 ** 2
            t7483 = t7481 * t7480
            t7486 = t7483 ** 2
            t7488 = t7484 ** 2
            t7485 = t7481 * t7484
            t7490 = t7485 ** 2
            t7492 = t7486 ** 2
            t7487 = t7481 * t7486
            t7494 = t7487 ** 2
            t7497 = -2 + 42 * t7480 - 218 * t7484 + 402 * t7486 - 198 * t7488 - 226 * t7490 + 290 * t7492 - 90 * t7494
            t7496 = -5 * t7483 + 207 * t7485 - 657 * t7487 + (833 * t7488 - 447 * t7490 + 53 * t7492 + 21 * t7494 - 5) * t7481
            t7482 = 5 * phi1
            tfunc[..., c] = (0.435e3 / 0.8192e4*1j) * np.sqrt(0.3289e4) * ((1 + t7481) ** (-0.1e1 / 0.2e1)) * ((1 - t7481) ** (-0.1e1 / 0.2e1)) * ((t7496 + t7497) * np.exp((1j) * (t7482 - 12 * phi2)) + (t7496 - t7497) * np.exp((1j) * (t7482 + 12 * phi2)))

        if Bindx == 363:
            t7506 = np.sin(phi)
            t7503 = t7506 ** 2
            t7504 = t7506 * t7503
            t7498 = np.cos(phi)
            t7499 = t7498 ** 2
            t7500 = t7499 ** 2
            tfunc[..., c] = -(0.29e2 / 0.8192e4) * np.exp((6*1j) * phi1) * np.sqrt(0.3233230e7) * t7504 ** 2 * (-84 * t7499 + 1 + (-3220 * t7499 + 966 + 3105 * t7500) * t7500)

        if Bindx == 364:
            t7522 = np.cos(phi)
            t7521 = t7522 ** 2
            t7523 = t7522 * t7521
            t7524 = t7521 ** 2
            t7525 = t7522 * t7524
            t7526 = t7523 ** 2
            t7527 = t7522 * t7526
            t7528 = t7524 ** 2
            t7530 = t7525 ** 2
            t7532 = t7526 ** 2
            t7536 = 520532 * t7523 - 4172562 * t7525 + 15354648 * t7527 + (-27848722 * t7528 + 24151380 * t7530 - 7992270 * t7532 - 21198) * t7522
            t7535 = 3108105 * t7527 ** 2 - 230253 * t7521 + 2425617 * t7524 - 8886957 * t7526 + 13338963 * t7528 - 5787375 * t7530 - 3963245 * t7532 + 3337
            tfunc[..., c] = (0.29e2 / 0.32768e5) * np.sqrt(0.2e1) * ((t7535 + t7536) * np.exp((6*1j) * (phi1 - phi2)) + (t7535 - t7536) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 365:
            t7552 = np.cos(phi)
            t7551 = t7552 ** 2
            t7553 = t7552 * t7551
            t7554 = t7551 ** 2
            t7555 = t7552 * t7554
            t7556 = t7553 ** 2
            t7557 = t7552 * t7556
            t7558 = t7554 ** 2
            t7560 = t7555 ** 2
            t7562 = t7556 ** 2
            t7566 = -752 * t7553 + 3708 * t7555 - 5760 * t7557 + (2372 * t7558 + 1392 * t7560 - 972 * t7562 + 12) * t7552
            t7565 = 189 * t7557 ** 2 + 435 * t7551 - 1161 * t7554 - 729 * t7556 + 5049 * t7558 - 5079 * t7560 + 1325 * t7562 - 29
            tfunc[..., c] = (0.29e2 / 0.16384e5) * ((t7565 + t7566) * np.exp((6*1j) * (phi1 - 2 * phi2)) + (t7565 - t7566) * np.exp((6*1j) * (phi1 + 2 * phi2))) * np.sqrt(0.16445e5)

        if Bindx == 366:
            t7567 = np.cos(phi)
            t7568 = t7567 ** 2
            t7569 = t7568 ** 2
            tfunc[..., c] = (0.29e2 / 0.2048e4*1j) * np.exp((7*1j) * phi1) * np.sqrt(0.692835e6) * ((1 - t7567) ** (0.7e1 / 0.2e1)) * ((1 + t7567) ** (0.7e1 / 0.2e1)) * t7567 * (-805 * t7569 - 7 + (1035 * t7569 + 161) * t7568)

        if Bindx == 367:
            t7586 = np.cos(phi)
            t7585 = t7586 ** 2
            t7588 = t7586 * t7585
            t7591 = t7588 ** 2
            t7592 = t7586 * t7591
            t7600 = 148005 * t7592 ** 2
            t7597 = t7591 ** 2
            t7589 = t7585 ** 2
            t7590 = t7586 * t7589
            t7595 = t7590 ** 2
            t7593 = t7589 ** 2
            t7587 = 7 * phi1
            t7578 = t7586 * t7593
            t7576 = t7586 * t7595
            t7574 = t7586 * t7597
            tfunc[..., c] = (-0.29e2 / 0.8192e4*1j) * np.sqrt((1 - t7586)) * np.sqrt(0.21e2) * ((1 + t7586) ** (-0.1e1 / 0.2e1)) * ((-296010 * t7574 + 1067660 * t7576 - 1521542 * t7578 - 2945 * t7585 - 3386 * t7586 + 67916 * t7588 + 39657 * t7589 - 397878 * t7590 - 100329 * t7591 + 1083240 * t7592 - 23661 * t7593 + 350405 * t7595 - 411125 * t7597 - 7 + t7600) * np.exp((1j) * (t7587 - 6 * phi2)) + (592020 * t7574 - 1001880 * t7576 + 152812 * t7578 - 3813 * t7585 - 3372 * t7586 + 67048 * t7588 + 95307 * t7589 - 342228 * t7590 - 639777 * t7591 + 543792 * t7592 + 1650693 * t7593 - 1719135 * t7595 + 476905 * t7597 + 7 + t7600) * np.exp((1j) * (t7587 + 6 * phi2)))

        if Bindx == 368:
            t7617 = np.cos(phi)
            t7616 = t7617 ** 2
            t7620 = t7616 ** 2
            t7619 = t7617 * t7616
            t7622 = t7619 ** 2
            t7624 = t7620 ** 2
            t7621 = t7617 * t7620
            t7626 = t7621 ** 2
            t7628 = t7622 ** 2
            t7623 = t7617 * t7622
            t7630 = t7623 ** 2
            t7633 = 2 - 18 * t7616 - 14 * t7620 + 270 * t7622 - 522 * t7624 + 314 * t7626 + 22 * t7628 - 54 * t7630
            t7632 = 71 * t7619 - 225 * t7621 + 171 * t7623 + (193 * t7624 - 315 * t7626 + 101 * t7628 + 9 * t7630 - 5) * t7617
            t7618 = 7 * phi1
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.345345e6) * np.sqrt(0.2e1) * ((1 + t7617) ** (-0.1e1 / 0.2e1)) * ((1 - t7617) ** (-0.1e1 / 0.2e1)) * ((t7632 + t7633) * np.exp((1j) * (t7618 - 12 * phi2)) + (t7632 - t7633) * np.exp((1j) * (t7618 + 12 * phi2)))

        if Bindx == 369:
            t7641 = np.sin(phi)
            t7638 = t7641 ** 2
            t7639 = t7638 ** 2
            t7634 = np.cos(phi)
            t7635 = t7634 ** 2
            t7636 = t7635 ** 2
            tfunc[..., c] = (0.29e2 / 0.4096e4) * np.exp((8*1j) * phi1) * np.sqrt(0.881790e6) * t7639 ** 2 * (-575 * t7636 - 1 + (1035 * t7636 + 69) * t7635)

        if Bindx == 370:
            t7657 = np.cos(phi)
            t7656 = t7657 ** 2
            t7659 = t7657 * t7656
            t7660 = t7656 ** 2
            t7661 = t7657 * t7660
            t7662 = t7659 ** 2
            t7663 = t7657 * t7662
            t7664 = t7660 ** 2
            t7666 = t7661 ** 2
            t7668 = t7662 ** 2
            t7672 = -26848 * t7659 + 59784 * t7661 + 165120 * t7663 + (-719624 * t7664 + 842720 * t7666 - 322920 * t7668 + 1768) * t7657
            t7671 = 94185 * t7663 ** 2 - 17105 * t7656 + 164979 * t7660 - 631173 * t7662 + 1090533 * t7664 - 783955 * t7666 + 82225 * t7668 + 311
            t7658 = 4 * phi1
            tfunc[..., c] = (0.29e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.33e2) * ((t7671 + t7672) * np.exp((2*1j) * (t7658 - 3 * phi2)) + (t7671 - t7672) * np.exp((2*1j) * (t7658 + 3 * phi2)))

        if Bindx == 371:
            t7688 = np.cos(phi)
            t7687 = t7688 ** 2
            t7690 = t7688 * t7687
            t7691 = t7687 ** 2
            t7692 = t7688 * t7691
            t7693 = t7690 ** 2
            t7694 = t7688 * t7693
            t7695 = t7691 ** 2
            t7697 = t7692 ** 2
            t7699 = t7693 ** 2
            t7703 = 608 * t7690 - 528 * t7692 - 2112 * t7694 + (3344 * t7695 - 800 * t7697 - 432 * t7699 - 80) * t7688
            t7702 = 63 * t7694 ** 2 - 19 * t7687 - 957 * t7691 + 2805 * t7693 - 1551 * t7695 - 1441 * t7697 + 1081 * t7699 + 19
            t7689 = 2 * phi1
            tfunc[..., c] = (0.29e2 / 0.8192e4) * ((t7702 + t7703) * np.exp((4*1j) * (t7689 - 3 * phi2)) + (t7702 - t7703) * np.exp((4*1j) * (t7689 + 3 * phi2))) * np.sqrt(0.4485e4)

        if Bindx == 372:
            t7704 = np.cos(phi)
            t7705 = t7704 ** 2
            tfunc[..., c] = (-0.29e2 / 0.2048e4*1j) * np.exp((9*1j) * phi1) * np.sqrt(0.3380195e7) * ((1 - t7704) ** (0.9e1 / 0.2e1)) * ((1 + t7704) ** (0.9e1 / 0.2e1)) * t7704 * (3 + (-50 + 135 * t7705) * t7705)

        if Bindx == 373:
            t7721 = np.cos(phi)
            t7720 = t7721 ** 2
            t7723 = t7721 * t7720
            t7726 = t7723 ** 2
            t7732 = t7726 ** 2
            t7734 = 12285 * t7721 * t7732
            t7724 = t7720 ** 2
            t7725 = t7721 * t7724
            t7730 = t7725 ** 2
            t7728 = t7724 ** 2
            t7722 = 3 * phi1
            t7715 = t7721 * t7726
            t7713 = t7721 * t7728
            t7711 = t7721 * t7730
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * ((1 - t7721) ** (0.3e1 / 0.2e1)) * np.sqrt(0.253e3) * ((1 + t7721) ** (-0.1e1 / 0.2e1)) * ((t7734 - 22815 * t7732 - 37310 * t7711 + 83690 * t7730 + 39235 * t7713 - 120129 * t7728 - 15204 * t7715 + 84684 * t7726 + 819 * t7725 - 29745 * t7724 - 126 * t7723 + 4394 * t7720 + 301 * t7721 - 79) * np.exp((3*1j) * (t7722 - 2 * phi2)) + (t7734 + 71955 * t7732 + 152230 * t7711 + 97010 * t7730 - 123665 * t7713 - 229431 * t7728 - 70908 * t7715 + 92652 * t7726 + 72459 * t7725 - 1035 * t7724 - 14346 * t7723 - 2558 * t7720 + 617 * t7721 + 79) * np.exp((3*1j) * (t7722 + 2 * phi2)))

        if Bindx == 374:
            t7751 = np.cos(phi)
            t7750 = t7751 ** 2
            t7754 = t7750 ** 2
            t7753 = t7751 * t7750
            t7756 = t7753 ** 2
            t7758 = t7754 ** 2
            t7755 = t7751 * t7754
            t7760 = t7755 ** 2
            t7762 = t7756 ** 2
            t7757 = t7751 * t7756
            t7764 = t7757 ** 2
            t7767 = -74 - 518 * t7750 + 5542 * t7754 - 8646 * t7756 - 4686 * t7758 + 14718 * t7760 - 4878 * t7762 - 1458 * t7764
            t7766 = -1677 * t7753 - 3333 * t7755 + 16071 * t7757 + (-12859 * t7758 - 3127 * t7760 + 4313 * t7762 + 189 * t7764 + 423) * t7751
            t7752 = 3 * phi1
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.65e2) * np.sqrt(0.2e1) * ((1 + t7751) ** (-0.1e1 / 0.2e1)) * ((1 - t7751) ** (-0.1e1 / 0.2e1)) * ((t7766 + t7767) * np.exp((3*1j) * (t7752 - 4 * phi2)) + (t7766 - t7767) * np.exp((3*1j) * (t7752 + 4 * phi2)))

        if Bindx == 375:
            t7775 = np.sin(phi)
            t7771 = t7775 ** 2
            t7773 = t7775 * t7771 ** 2
            t7768 = np.cos(phi)
            t7769 = t7768 ** 2
            tfunc[..., c] = -(0.29e2 / 0.8192e4) * np.exp((10*1j) * phi1) * np.sqrt(0.4056234e7) * t7773 ** 2 * (1 + (-50 + 225 * t7769) * t7769)

        if Bindx == 376:
            t7791 = np.cos(phi)
            t7790 = t7791 ** 2
            t7793 = t7791 * t7790
            t7794 = t7790 ** 2
            t7795 = t7791 * t7794
            t7796 = t7793 ** 2
            t7797 = t7791 * t7796
            t7798 = t7794 ** 2
            t7800 = t7795 ** 2
            t7802 = t7796 ** 2
            t7806 = -7532 * t7793 + 27822 * t7795 - 34152 * t7797 + (-5714 * t7798 + 36500 * t7800 - 17550 * t7802 + 626) * t7791
            t7805 = 4095 * t7797 ** 2 + 37 * t7790 + 6039 * t7794 - 38331 * t7796 + 81477 * t7798 - 68201 * t7800 + 14885 * t7802 - 1
            t7792 = 5 * phi1
            tfunc[..., c] = (0.29e2 / 0.32768e5) * np.sqrt(0.3795e4) * np.sqrt(0.2e1) * ((t7805 + t7806) * np.exp((2*1j) * (t7792 - 3 * phi2)) + (t7805 - t7806) * np.exp((2*1j) * (t7792 + 3 * phi2)))

        if Bindx == 377:
            t7822 = np.cos(phi)
            t7821 = t7822 ** 2
            t7824 = t7822 * t7821
            t7825 = t7821 ** 2
            t7826 = t7822 * t7825
            t7827 = t7824 ** 2
            t7828 = t7822 * t7827
            t7829 = t7825 ** 2
            t7831 = t7826 ** 2
            t7833 = t7827 ** 2
            t7837 = 80 * t7824 - 3828 * t7826 + 4224 * t7828 + (3124 * t7829 - 3280 * t7831 - 540 * t7833 + 220) * t7822
            t7836 = 63 * t7828 ** 2 - 527 * t7821 + 2013 * t7825 + 1485 * t7827 - 6765 * t7829 + 1859 * t7831 + 1903 * t7833 - 31
            t7823 = 5 * phi1
            tfunc[..., c] = (0.145e3 / 0.16384e5) * ((t7836 + t7837) * np.exp((2*1j) * (t7823 - 6 * phi2)) + (t7836 - t7837) * np.exp((2*1j) * (t7823 + 6 * phi2))) * np.sqrt(0.39e2)

        if Bindx == 378:
            t7838 = np.cos(phi)
            tfunc[..., c] = (0.145e3 / 0.4096e4*1j) * np.exp((11*1j) * phi1) * np.sqrt(0.4056234e7) * ((1 - t7838) ** (0.11e2 / 0.2e1)) * ((1 + t7838) ** (0.11e2 / 0.2e1)) * t7838 * (9 * t7838 ** 2 - 1)

        if Bindx == 379:
            t7852 = np.cos(phi)
            t7851 = t7852 ** 2
            t7854 = t7852 * t7851
            t7857 = t7854 ** 2
            t7864 = 819 * t7857 ** 2
            t7855 = t7851 ** 2
            t7856 = t7852 * t7855
            t7861 = t7856 ** 2
            t7859 = t7855 ** 2
            t7853 = 11 * phi1
            t7846 = t7852 * t7857
            t7844 = t7852 * t7859
            t7842 = t7852 * t7861
            tfunc[..., c] = (-0.29e2 / 0.16384e5*1j) * np.sqrt(0.2e1) * ((1 - t7852) ** (0.5e1 / 0.2e1)) * np.sqrt(0.3795e4) * ((1 + t7852) ** (-0.1e1 / 0.2e1)) * ((t7864 - 1404 * t7842 - 2782 * t7861 + 5452 * t7844 + 3417 * t7859 - 8216 * t7846 - 1780 * t7857 + 5976 * t7856 + 373 * t7855 - 2092 * t7854 - 78 * t7851 + 284 * t7852 + 31) * np.exp((1j) * (t7853 - 6 * phi2)) + (t7864 + 6318 * t7842 + 20384 * t7861 + 34250 * t7844 + 28035 * t7859 + 1068 * t7846 - 18984 * t7857 - 15372 * t7856 - 2775 * t7855 + 2310 * t7854 + 1224 * t7851 + 98 * t7852 - 31) * np.exp((1j) * (t7853 + 6 * phi2)))

        if Bindx == 380:
            t7881 = np.cos(phi)
            t7880 = t7881 ** 2
            t7884 = t7880 ** 2
            t7883 = t7881 * t7880
            t7886 = t7883 ** 2
            t7888 = t7884 ** 2
            t7885 = t7881 * t7884
            t7890 = t7885 ** 2
            t7892 = t7886 ** 2
            t7887 = t7881 * t7886
            t7894 = t7887 ** 2
            t7897 = 38 + 1026 * t7880 - 1394 * t7884 - 7062 * t7886 + 10098 * t7888 + 2662 * t7890 - 4774 * t7892 - 594 * t7894
            t7896 = -1199 * t7883 + 6237 * t7885 - 627 * t7887 + (-10637 * t7888 + 4131 * t7890 + 2351 * t7892 + 63 * t7894 - 319) * t7881
            t7882 = 11 * phi1
            tfunc[..., c] = (0.29e2 / 0.8192e4*1j) * np.sqrt(0.39e2) * ((1 + t7881) ** (-0.1e1 / 0.2e1)) * ((1 - t7881) ** (-0.1e1 / 0.2e1)) * ((t7896 + t7897) * np.exp((1j) * (t7882 - 12 * phi2)) + (t7896 - t7897) * np.exp((1j) * (t7882 + 12 * phi2)))

        if Bindx == 381:
            t7903 = np.sin(phi)
            t7899 = t7903 ** 2
            t7900 = t7903 * t7899
            t7901 = t7900 ** 2
            t7898 = np.cos(phi)
            tfunc[..., c] = (0.145e3 / 0.4096e4) * np.exp((12*1j) * phi1) * np.sqrt(0.52003e5) * t7901 ** 2 * (27 * t7898 ** 2 - 1)

        if Bindx == 382:
            t7919 = np.cos(phi)
            t7918 = t7919 ** 2
            t7921 = t7919 * t7918
            t7922 = t7918 ** 2
            t7923 = t7919 * t7922
            t7924 = t7921 ** 2
            t7925 = t7919 * t7924
            t7926 = t7922 ** 2
            t7928 = t7923 ** 2
            t7930 = t7924 ** 2
            t7934 = -752 * t7921 + 3708 * t7923 - 5760 * t7925 + (2372 * t7926 + 1392 * t7928 - 972 * t7930 + 12) * t7919
            t7933 = 189 * t7925 ** 2 + 435 * t7918 - 1161 * t7922 - 729 * t7924 + 5049 * t7926 - 5079 * t7928 + 1325 * t7930 - 29
            t7920 = 2 * phi1
            tfunc[..., c] = (0.29e2 / 0.16384e5) * ((t7933 + t7934) * np.exp((6*1j) * (t7920 - phi2)) + (t7933 - t7934) * np.exp((6*1j) * (t7920 + phi2))) * np.sqrt(0.16445e5)

        if Bindx == 383:
            t7950 = np.cos(phi)
            t7949 = t7950 ** 2
            t7951 = t7950 * t7949
            t7952 = t7949 ** 2
            t7953 = t7950 * t7952
            t7954 = t7951 ** 2
            t7955 = t7950 * t7954
            t7956 = t7952 ** 2
            t7958 = t7953 ** 2
            t7960 = t7954 ** 2
            t7964 = -11024 * t7951 + 10296 * t7953 + 41184 * t7955 + (-19448 * t7956 - 21840 * t7958 - 1944 * t7960 - 1320) * t7950
            t7963 = 189 * t7955 ** 2 + 5343 * t7949 + 9009 * t7952 - 36465 * t7954 - 14157 * t7956 + 31317 * t7958 + 8723 * t7960 + 137
            tfunc[..., c] = (0.29e2 / 0.16384e5) * np.sqrt(0.2e1) * ((t7963 + t7964) * np.exp((12*1j) * (phi1 - phi2)) + (t7963 - t7964) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 384:
            t7965 = np.cos(phi)
            tfunc[..., c] = (-0.435e3 / 0.4096e4*1j) * np.exp((13*1j) * phi1) * np.sqrt(0.312018e6) * ((1 - t7965) ** (0.13e2 / 0.2e1)) * ((1 + t7965) ** (0.13e2 / 0.2e1)) * t7965

        if Bindx == 385:
            t7978 = np.cos(phi)
            t7977 = t7978 ** 2
            t7981 = t7977 ** 2
            t7982 = t7978 * t7981
            t7987 = t7982 ** 2
            t7989 = 7 * t7978 * t7987
            t7985 = t7981 ** 2
            t7980 = t7978 * t7977
            t7983 = t7980 ** 2
            t7979 = 13 * phi1
            t7972 = t7978 * t7983
            t7970 = t7978 * t7985
            tfunc[..., c] = (0.87e2 / 0.16384e5*1j) * np.sqrt(0.2e1) * ((1 - t7978) ** (0.7e1 / 0.2e1)) * np.sqrt(0.49335e5) * ((1 + t7978) ** (-0.1e1 / 0.2e1)) * ((t7989 - 11 * t7987 - 27 * t7970 + 47 * t7985 + 38 * t7972 - 78 * t7983 - 22 * t7982 + 62 * t7981 + 3 * t7980 - 23 * t7977 + t7978 + 3) * np.exp((1j) * (t7979 - 6 * phi2)) + (t7989 + 67 * t7987 + 285 * t7970 + 705 * t7985 + 1110 * t7972 + 1134 * t7983 + 714 * t7982 + 210 * t7981 - 45 * t7980 - 65 * t7977 - 23 * t7978 - 3) * np.exp((1j) * (t7979 + 6 * phi2)))

        if Bindx == 386:
            t8005 = np.cos(phi)
            t8004 = t8005 ** 2
            t8007 = t8005 * t8004
            t8010 = t8007 ** 2
            t8011 = t8005 * t8010
            t8019 = -1287 * t8010 + (1716 + 7 * t8011) * t8011
            t8016 = t8010 ** 2
            t8008 = t8004 ** 2
            t8009 = t8005 * t8008
            t8014 = t8009 ** 2
            t8012 = t8008 ** 2
            t8006 = 13 * phi1
            t7997 = t8005 * t8012
            t7995 = t8005 * t8014
            t7993 = t8005 * t8016
            tfunc[..., c] = (-0.87e2 / 0.8192e4*1j) * np.sqrt((1 - t8005)) * np.sqrt(0.3e1) * ((1 + t8005) ** (-0.1e1 / 0.2e1)) * ((-71 * t7993 + 312 * t8016 - 754 * t7995 + 1001 * t8014 - 429 * t7997 - 858 * t8012 + 143 * t8009 + 572 * t8008 - 546 * t8007 + 247 * t8004 - 59 * t8005 + 6 + t8019) * np.exp((1j) * (t8006 - 12 * phi2)) + (85 * t7993 + 468 * t8016 + 1534 * t7995 + 3289 * t8014 + 4719 * t7997 + 4290 * t8012 - 2717 * t8009 - 2288 * t8008 - 1170 * t8007 - 377 * t8004 - 71 * t8005 - 6 + t8019) * np.exp((1j) * (t8006 + 12 * phi2)))

        if Bindx == 387:
            t8025 = np.sin(phi)
            t8020 = t8025 ** 2
            t8021 = t8025 * t8020
            t8023 = t8025 * t8021 ** 2
            tfunc[..., c] = -(0.435e3 / 0.8192e4) * np.exp((14*1j) * phi1) * np.sqrt(0.44574e5) * t8023 ** 2

        if Bindx == 388:
            t8041 = np.cos(phi)
            t8057 = -6 * t8041
            t8040 = t8041 ** 2
            t8043 = t8041 * t8040
            t8044 = t8040 ** 2
            t8045 = t8041 * t8044
            t8046 = t8043 ** 2
            t8047 = t8041 * t8046
            t8048 = t8044 ** 2
            t8050 = t8045 ** 2
            t8052 = t8046 ** 2
            t8056 = t8052 * t8057 + 4 * t8043 + 38 * t8045 - 72 * t8047 + t8057 + (38 * t8048 + 4 * t8050) * t8041
            t8055 = t8047 ** 2 + 11 * t8040 - 39 * t8044 + 27 * t8046 + 27 * t8048 - 39 * t8050 + 11 * t8052 + 1
            t8042 = 7 * phi1
            tfunc[..., c] = (0.87e2 / 0.32768e5) * np.sqrt(0.345345e6) * np.sqrt(0.2e1) * ((t8055 + t8056) * np.exp((2*1j) * (t8042 - 3 * phi2)) + (t8055 - t8056) * np.exp((2*1j) * (t8042 + 3 * phi2)))

        if Bindx == 389:
            t8072 = np.cos(phi)
            t8071 = t8072 ** 2
            t8074 = t8072 * t8071
            t8075 = t8071 ** 2
            t8076 = t8072 * t8075
            t8078 = t8075 ** 2
            t8080 = t8076 ** 2
            t8077 = t8074 ** 2
            t8082 = t8077 ** 2
            t8083 = t8072 * t8082
            t8086 = 208 * t8074 + 572 * t8076 - 12 * t8083 + (-572 * t8078 - 208 * t8080 + 12) * t8072
            t8085 = t8072 * t8083 - 65 * t8071 - 429 * t8075 - 429 * t8077 + 429 * t8078 + 429 * t8080 + 65 * t8082 - 1
            t8073 = 7 * phi1
            tfunc[..., c] = (0.87e2 / 0.16384e5) * ((t8085 + t8086) * np.exp((2*1j) * (t8073 - 6 * phi2)) + (t8085 - t8086) * np.exp((2*1j) * (t8073 + 6 * phi2))) * np.sqrt(0.21e2)

        if Bindx == 390:
            t8102 = np.cos(phi)
            t8118 = 6 * t8102
            t8101 = t8102 ** 2
            t8104 = t8102 * t8101
            t8105 = t8101 ** 2
            t8106 = t8102 * t8105
            t8107 = t8104 ** 2
            t8108 = t8102 * t8107
            t8109 = t8105 ** 2
            t8111 = t8106 ** 2
            t8113 = t8107 ** 2
            t8117 = t8113 * t8118 - 4 * t8104 - 38 * t8106 + 72 * t8108 + t8118 + (-38 * t8109 - 4 * t8111) * t8102
            t8116 = -t8108 ** 2 - 11 * t8101 + 39 * t8105 - 27 * t8107 - 27 * t8109 + 39 * t8111 - 11 * t8113 - 1
            t8103 = 5 * phi1
            tfunc[..., c] = (0.155e3 / 0.32768e5*1j) * np.sqrt(0.286143e6) * np.sqrt((1 - t8102)) * np.sqrt((1 + t8102)) * ((t8116 + t8117) * np.exp((-3*1j) * (t8103 - 2 * phi2)) + (-t8116 + t8117) * np.exp((-3*1j) * (t8103 + 2 * phi2)))

        if Bindx == 391:
            t8133 = np.cos(phi)
            t8132 = t8133 ** 2
            t8135 = t8133 * t8132
            t8136 = t8132 ** 2
            t8137 = t8133 * t8136
            t8139 = t8136 ** 2
            t8141 = t8137 ** 2
            t8138 = t8135 ** 2
            t8143 = t8138 ** 2
            t8144 = t8133 * t8143
            t8147 = 208 * t8135 + 572 * t8137 - 12 * t8144 + (-572 * t8139 - 208 * t8141 + 12) * t8133
            t8146 = -t8133 * t8144 + 65 * t8132 + 429 * t8136 + 429 * t8138 - 429 * t8139 - 429 * t8141 - 65 * t8143 + 1
            t8134 = 5 * phi1
            tfunc[..., c] = (-0.31e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt(0.1015e4) * np.sqrt((1 - t8133)) * np.sqrt((1 + t8133)) * ((-t8146 + t8147) * np.exp((-3*1j) * (t8134 - 4 * phi2)) + (t8146 + t8147) * np.exp((-3*1j) * (t8134 + 4 * phi2)))

        if Bindx == 392:
            t8164 = np.cos(phi)
            t8163 = t8164 ** 2
            t8167 = t8163 ** 2
            t8166 = t8164 * t8163
            t8169 = t8166 ** 2
            t8171 = t8167 ** 2
            t8168 = t8164 * t8167
            t8173 = t8168 ** 2
            t8175 = t8169 ** 2
            t8170 = t8164 * t8169
            t8177 = t8170 ** 2
            t8180 = 2 - 8 * t8163 - 58 * t8167 + 244 * t8169 - 306 * t8171 + 112 * t8173 + 42 * t8175 - 28 * t8177
            t8179 = -63 * t8166 + 119 * t8168 + 9 * t8170 + (-211 * t8171 + 187 * t8173 - 43 * t8175 - 5 * t8177 + 7) * t8164
            t8165 = 7 * phi1
            tfunc[..., c] = (0.93e2 / 0.32768e5) * np.sqrt(0.476905e6) * np.sqrt(0.2e1) * ((-t8179 + t8180) * np.exp((-2*1j) * (t8165 - 3 * phi2)) + (t8179 + t8180) * np.exp((-2*1j) * (t8165 + 3 * phi2)))

        if Bindx == 393:
            t8197 = np.cos(phi)
            t8196 = t8197 ** 2
            t8200 = t8196 ** 2
            t8199 = t8197 * t8196
            t8202 = t8199 ** 2
            t8204 = t8200 ** 2
            t8201 = t8197 * t8200
            t8206 = t8201 ** 2
            t8208 = t8202 ** 2
            t8203 = t8197 * t8202
            t8210 = t8203 ** 2
            t8213 = 4 + 200 * t8196 + 676 * t8200 - 1144 * t8202 - 1716 * t8204 + 1144 * t8206 + 780 * t8208 + 56 * t8210
            t8212 = -507 * t8199 - 143 * t8201 + 2145 * t8203 + (143 * t8204 - 1313 * t8206 - 277 * t8208 - 5 * t8210 - 43) * t8197
            t8198 = 7 * phi1
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * ((t8212 + t8213) * np.exp((-2*1j) * (t8198 - 6 * phi2)) + (-t8212 + t8213) * np.exp((-2*1j) * (t8198 + 6 * phi2))) * np.sqrt(0.609e3)

        if Bindx == 394:
            t8227 = np.cos(phi)
            t8226 = t8227 ** 2
            t8229 = t8227 * t8226
            t8232 = t8229 ** 2
            t8239 = -145 * t8232 ** 2 - 19
            t8230 = t8226 ** 2
            t8231 = t8227 * t8230
            t8236 = t8231 ** 2
            t8234 = t8230 ** 2
            t8228 = 13 * phi1
            t8221 = t8227 * t8232
            t8219 = t8227 * t8234
            t8217 = t8227 * t8236
            tfunc[..., c] = (0.93e2 / 0.32768e5*1j) * ((1 + t8227) ** (0.7e1 / 0.2e1)) * np.sqrt(0.16445e5) * ((-1334 * t8217 + 5384 * t8236 - 12370 * t8219 + 17385 * t8234 - 14460 * t8221 + 5208 * t8232 + 2172 * t8231 - 3405 * t8230 + 1490 * t8229 - 160 * t8226 - 74 * t8227 - t8239) * np.exp((-1*1j) * (t8228 - 6 * phi2)) + (-174 * t8217 + 648 * t8236 + 774 * t8219 - 1161 * t8234 - 1356 * t8221 + 1064 * t8232 + 1164 * t8231 - 531 * t8230 - 486 * t8229 + 144 * t8226 + 78 * t8227 + t8239) * np.exp((-1*1j) * (t8228 + 6 * phi2))) * ((1 - t8227) ** (-0.1e1 / 0.2e1))

        if Bindx == 395:
            t8256 = np.cos(phi)
            t8255 = t8256 ** 2
            t8258 = t8256 * t8255
            t8261 = t8258 ** 2
            t8262 = t8256 * t8261
            t8269 = t8262 ** 2
            t8271 = -145 * t8256 * t8269 + 91
            t8267 = t8261 ** 2
            t8259 = t8255 ** 2
            t8260 = t8256 * t8259
            t8265 = t8260 ** 2
            t8263 = t8259 ** 2
            t8257 = 13 * phi1
            t8248 = t8256 * t8263
            t8246 = t8256 * t8265
            t8244 = t8256 * t8267
            tfunc[..., c] = (-0.31e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt((1 + t8256)) * np.sqrt(0.21e2) * ((1 - t8256) ** (-0.1e1 / 0.2e1)) * ((1653 * t8269 - 8385 * t8244 + 24557 * t8267 - 44421 * t8246 + 46761 * t8265 - 15301 * t8248 - 32175 * t8263 + 55341 * t8262 - 38753 * t8261 + 7293 * t8260 + 10023 * t8259 - 9815 * t8258 + 4227 * t8255 - 951 * t8256 + t8271) * np.exp((-1*1j) * (t8257 - 12 * phi2)) + (1363 * t8269 + 5369 * t8244 + 10803 * t8267 + 9061 * t8246 - 6721 * t8265 - 24739 * t8248 - 22737 * t8263 - 429 * t8262 + 17017 * t8261 + 14443 * t8260 + 2873 * t8259 - 3081 * t8258 - 2507 * t8255 - 769 * t8256 - t8271) * np.exp((-1*1j) * (t8257 + 12 * phi2)))

        if Bindx == 396:
            t8288 = np.cos(phi)
            t8287 = t8288 ** 2
            t8291 = t8287 ** 2
            t8290 = t8288 * t8287
            t8293 = t8290 ** 2
            t8295 = t8291 ** 2
            t8292 = t8288 * t8291
            t8297 = t8292 ** 2
            t8299 = t8293 ** 2
            t8294 = t8288 * t8293
            t8301 = t8294 ** 2
            t8304 = 4 - 120 * t8287 + 996 * t8291 - 2936 * t8293 + 3276 * t8295 - 456 * t8297 - 1460 * t8299 + 696 * t8301
            t8303 = -223 * t8290 - 3 * t8292 + 2205 * t8294 + (-4717 * t8295 + 3603 * t8297 - 753 * t8299 - 145 * t8301 + 33) * t8288
            t8289 = 2 * phi1
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * ((t8303 + t8304) * np.exp((-6*1j) * (t8289 - phi2)) + (-t8303 + t8304) * np.exp((-6*1j) * (t8289 + phi2))) * np.sqrt(0.345345e6)

        if Bindx == 397:
            t8321 = np.cos(phi)
            t8320 = t8321 ** 2
            t8323 = t8320 ** 2
            t8322 = t8321 * t8320
            t8325 = t8322 ** 2
            t8327 = t8323 ** 2
            t8324 = t8321 * t8323
            t8329 = t8324 ** 2
            t8331 = t8325 ** 2
            t8326 = t8321 * t8325
            t8333 = t8326 ** 2
            t8336 = -11712 * t8320 + 30264 * t8323 + 80080 * t8325 - 175032 * t8327 - 13728 * t8329 + 84968 * t8331 + 9744 * t8333 - 488
            t8335 = -9451 * t8322 + 90519 * t8324 - 47619 * t8326 + (-152867 * t8327 + 86775 * t8329 + 39669 * t8331 + 1015 * t8333 - 3945) * t8321
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * np.sqrt(0.2e1) * ((-t8335 + t8336) * np.exp((-12*1j) * (phi1 - phi2)) + (t8335 + t8336) * np.exp((-12*1j) * (phi1 + phi2)))

        if Bindx == 398:
            t8351 = np.cos(phi)
            t8350 = t8351 ** 2
            t8353 = t8351 * t8350
            t8356 = t8353 ** 2
            t8362 = t8356 ** 2
            t8364 = -435 * t8351 * t8362 - 1
            t8354 = t8350 ** 2
            t8355 = t8351 * t8354
            t8360 = t8355 ** 2
            t8358 = t8354 ** 2
            t8352 = 11 * phi1
            t8345 = t8351 * t8356
            t8343 = t8351 * t8358
            t8341 = t8351 * t8360
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * ((1 + t8351) ** (0.5e1 / 0.2e1)) * np.sqrt(0.115115e6) * ((1 - t8351) ** (-0.1e1 / 0.2e1)) * ((3219 * t8362 - 9738 * t8341 + 14514 * t8360 - 8225 * t8343 - 5895 * t8358 + 12132 * t8345 - 5844 * t8356 - 1413 * t8355 + 2325 * t8354 - 570 * t8353 - 126 * t8350 + 57 * t8351 + t8364) * np.exp((-1*1j) * (t8352 - 6 * phi2)) + (609 * t8362 - 1746 * t8341 - 2502 * t8360 + 2813 * t8343 + 4047 * t8358 - 2364 * t8345 - 3220 * t8356 + 1149 * t8355 + 1263 * t8354 - 338 * t8353 - 198 * t8350 + 51 * t8351 - t8364) * np.exp((-1*1j) * (t8352 + 6 * phi2)))

        if Bindx == 399:
            t8382 = np.cos(phi)
            t8381 = t8382 ** 2
            t8384 = t8382 * t8381
            t8385 = t8381 ** 2
            t8386 = t8382 * t8385
            t8387 = t8384 ** 2
            t8388 = t8382 * t8387
            t8389 = t8385 ** 2
            t8391 = t8386 ** 2
            t8393 = t8387 ** 2
            t8395 = t8388 ** 2
            t8399 = -6356 * t8384 - 40092 * t8386 + 126412 * t8388 + (-56628 * t8389 - 87516 * t8391 + 52844 * t8393 + 8932 * t8395 + 2404) * t8382
            t8398 = 4356 * t8381 - 35464 * t8385 + 33748 * t8387 - 148148 * t8391 + 17056 * t8393 + 31836 * t8395 + 363 + (95238 + 1015 * t8389) * t8389
            t8383 = 11 * phi1
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * ((1 - t8382) ** (-0.1e1 / 0.2e1)) * ((1 + t8382) ** (-0.1e1 / 0.2e1)) * ((-t8398 + t8399) * np.exp((-1*1j) * (t8383 - 12 * phi2)) + (t8398 + t8399) * np.exp((-1*1j) * (t8383 + 12 * phi2)))

        if Bindx == 400:
            t8416 = np.cos(phi)
            t8415 = t8416 ** 2
            t8419 = t8415 ** 2
            t8418 = t8416 * t8415
            t8421 = t8418 ** 2
            t8423 = t8419 ** 2
            t8420 = t8416 * t8419
            t8425 = t8420 ** 2
            t8427 = t8421 ** 2
            t8422 = t8416 * t8421
            t8429 = t8422 ** 2
            t8432 = -6 + 312 * t8415 - 2386 * t8419 + 6116 * t8421 - 3562 * t8423 - 7728 * t8425 + 11778 * t8427 - 4524 * t8429
            t8431 = 511 * t8418 - 4343 * t8420 + 15175 * t8422 + (-24125 * t8423 + 16549 * t8425 - 2613 * t8427 - 1131 * t8429 - 23) * t8416
            t8417 = 5 * phi1
            tfunc[..., c] = (0.465e3 / 0.32768e5) * np.sqrt(0.1771e4) * np.sqrt(0.2e1) * ((-t8431 + t8432) * np.exp((-2*1j) * (t8417 - 3 * phi2)) + (t8431 + t8432) * np.exp((-2*1j) * (t8417 + 3 * phi2)))

        if Bindx == 401:
            t8449 = np.cos(phi)
            t8448 = t8449 ** 2
            t8452 = t8448 ** 2
            t8451 = t8449 * t8448
            t8454 = t8451 ** 2
            t8456 = t8452 ** 2
            t8453 = t8449 * t8452
            t8458 = t8453 ** 2
            t8460 = t8454 ** 2
            t8455 = t8449 * t8454
            t8462 = t8455 ** 2
            t8465 = -52 - 104 * t8448 + 4076 * t8452 - 10472 * t8454 + 1188 * t8456 + 13992 * t8458 - 7004 * t8460 - 1624 * t8462
            t8464 = 1819 * t8451 + 143 * t8453 - 13233 * t8455 + (16577 * t8456 + 289 * t8458 - 5131 * t8460 - 203 * t8462 - 261) * t8449
            t8450 = 5 * phi1
            tfunc[..., c] = (0.93e2 / 0.16384e5) * ((-t8464 + t8465) * np.exp((-2*1j) * (t8450 - 6 * phi2)) + (t8464 + t8465) * np.exp((-2*1j) * (t8450 + 6 * phi2))) * np.sqrt(0.195e3)

        if Bindx == 402:
            t8481 = np.cos(phi)
            t8480 = t8481 ** 2
            t8483 = t8481 * t8480
            t8486 = t8483 ** 2
            t8487 = t8481 * t8486
            t8495 = -28275 * t8487 ** 2 + 59
            t8492 = t8486 ** 2
            t8484 = t8480 ** 2
            t8485 = t8481 * t8484
            t8490 = t8485 ** 2
            t8488 = t8484 ** 2
            t8482 = 3 * phi1
            t8473 = t8481 * t8488
            t8471 = t8481 * t8490
            t8469 = t8481 * t8492
            tfunc[..., c] = (-0.31e2 / 0.32768e5*1j) * np.sqrt(0.5313e4) * ((1 + t8481) ** (0.3e1 / 0.2e1)) * ((158340 * t8469 - 304395 * t8492 + 112320 * t8471 + 390585 * t8490 - 498300 * t8473 + 11969 * t8488 + 316448 * t8487 - 148393 * t8486 - 54964 * t8485 + 50255 * t8484 - 1504 * t8483 - 4573 * t8480 + 428 * t8481 + t8495) * np.exp((-3*1j) * (t8482 - 2 * phi2)) + (45240 * t8469 - 102765 * t8492 - 177840 * t8471 + 147615 * t8490 + 277800 * t8473 - 109169 * t8488 - 217376 * t8487 + 47449 * t8486 + 87176 * t8485 - 13735 * t8484 - 15664 * t8483 + 2389 * t8480 + 664 * t8481 - t8495) * np.exp((-3*1j) * (t8482 + 2 * phi2))) * ((1 - t8481) ** (-0.1e1 / 0.2e1))

        if Bindx == 403:
            t8513 = np.cos(phi)
            t8512 = t8513 ** 2
            t8515 = t8513 * t8512
            t8516 = t8512 ** 2
            t8517 = t8513 * t8516
            t8518 = t8515 ** 2
            t8519 = t8513 * t8518
            t8520 = t8516 ** 2
            t8522 = t8517 ** 2
            t8524 = t8518 ** 2
            t8526 = t8519 ** 2
            t8530 = -7876 * t8515 + 23636 * t8517 - 3652 * t8519 + (-63492 * t8520 + 72084 * t8522 - 13956 * t8524 - 7308 * t8526 + 564) * t8513
            t8529 = -1416 * t8512 - 5196 * t8516 + 44088 * t8518 + 28776 * t8522 + 31364 * t8524 - 19096 * t8526 + 177 + (-77682 - 1015 * t8520) * t8520
            t8514 = 3 * phi1
            tfunc[..., c] = (0.93e2 / 0.32768e5*1j) * np.sqrt(0.65e2) * np.sqrt(0.2e1) * ((-t8529 + t8530) * np.exp((-3*1j) * (t8514 - 4 * phi2)) + (t8529 + t8530) * np.exp((-3*1j) * (t8514 + 4 * phi2))) * ((1 - t8513) ** (-0.1e1 / 0.2e1)) * ((1 + t8513) ** (-0.1e1 / 0.2e1))

        if Bindx == 404:
            t8547 = np.cos(phi)
            t8546 = t8547 ** 2
            t8550 = t8546 ** 2
            t8549 = t8547 * t8546
            t8552 = t8549 ** 2
            t8554 = t8550 ** 2
            t8551 = t8547 * t8550
            t8556 = t8551 ** 2
            t8558 = t8552 ** 2
            t8553 = t8547 * t8552
            t8560 = t8553 ** 2
            t8563 = -560 * t8546 + 2632 * t8550 + 20496 * t8552 - 140776 * t8554 + 300720 * t8556 - 273000 * t8558 + 90480 * t8560 + 8
            t8562 = -10731 * t8549 + 73633 * t8551 - 222055 * t8553 + (316967 * t8554 - 185185 * t8556 - 1365 * t8558 + 28275 * t8560 + 461) * t8547
            t8548 = 4 * phi1
            tfunc[..., c] = -(0.93e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.253e3) * ((-t8562 + t8563) * np.exp((-2*1j) * (t8548 - 3 * phi2)) + (t8562 + t8563) * np.exp((-2*1j) * (t8548 + 3 * phi2)))

        if Bindx == 405:
            t8580 = np.cos(phi)
            t8579 = t8580 ** 2
            t8583 = t8579 ** 2
            t8582 = t8580 * t8579
            t8585 = t8582 ** 2
            t8587 = t8583 ** 2
            t8584 = t8580 * t8583
            t8589 = t8584 ** 2
            t8591 = t8585 ** 2
            t8586 = t8580 * t8585
            t8593 = t8586 ** 2
            t8596 = 16 - 256 * t8579 + 592 * t8583 + 1760 * t8585 - 6864 * t8587 + 6336 * t8589 - 656 * t8591 - 928 * t8593
            t8595 = -587 * t8582 + 3047 * t8584 - 4587 * t8586 + (-11 * t8587 + 4295 * t8589 - 2027 * t8591 - 145 * t8593 + 15) * t8580
            t8581 = 2 * phi1
            tfunc[..., c] = (0.93e2 / 0.8192e4) * ((-t8595 + t8596) * np.exp((-4*1j) * (t8581 - 3 * phi2)) + (t8595 + t8596) * np.exp((-4*1j) * (t8581 + 3 * phi2))) * np.sqrt(0.1365e4)

        if Bindx == 406:
            t8613 = np.cos(phi)
            t8612 = t8613 ** 2
            t8615 = t8613 * t8612
            t8618 = t8615 ** 2
            t8619 = t8613 * t8618
            t8626 = t8619 ** 2
            t8628 = -650325 * t8613 * t8626 + 509
            t8624 = t8618 ** 2
            t8616 = t8612 ** 2
            t8617 = t8613 * t8616
            t8622 = t8617 ** 2
            t8620 = t8616 ** 2
            t8614 = 7 * phi1
            t8605 = t8613 * t8620
            t8603 = t8613 * t8622
            t8601 = t8613 * t8624
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * np.sqrt((1 + t8613)) * np.sqrt(0.11e2) * ((1 - t8613) ** (-0.1e1 / 0.2e1)) * ((-1475565 * t8601 + 7105735 * t8603 - 8315489 * t8605 - 37611 * t8612 - 2091 * t8613 + 85869 * t8615 + 416129 * t8616 - 949319 * t8617 - 1439319 * t8618 + 4184801 * t8619 + 1154071 * t8620 + 2694335 * t8622 - 5242965 * t8624 + 2471235 * t8626 + t8628) * np.exp((-1*1j) * (t8614 - 6 * phi2)) + (-2166255 * t8601 + 2689505 * t8603 - 1489411 * t8605 + 40775 * t8612 - 1073 * t8613 + 7483 * t8615 - 509481 * t8616 - 23709 * t8617 + 2412347 * t8618 + 333135 * t8619 - 5672007 * t8620 + 7110565 * t8622 - 4552275 * t8624 + 1170585 * t8626 - t8628) * np.exp((-1*1j) * (t8614 + 6 * phi2)))

        if Bindx == 407:
            t8646 = np.cos(phi)
            t8645 = t8646 ** 2
            t8648 = t8646 * t8645
            t8649 = t8645 ** 2
            t8650 = t8646 * t8649
            t8651 = t8648 ** 2
            t8652 = t8646 * t8651
            t8653 = t8649 ** 2
            t8655 = t8650 ** 2
            t8657 = t8651 ** 2
            t8659 = t8652 ** 2
            t8663 = 92 * t8648 - 1740 * t8650 + 5852 * t8652 + (-7524 * t8653 + 3060 * t8655 + 1052 * t8657 - 812 * t8659 + 20) * t8646
            t8662 = 216 * t8645 - 1252 * t8649 + 2200 * t8651 - 5368 * t8655 + 5036 * t8657 - 1272 * t8659 - 9 + (594 - 145 * t8653) * t8653
            t8647 = 7 * phi1
            tfunc[..., c] = (0.93e2 / 0.32768e5*1j) * np.sqrt(0.31395e5) * np.sqrt(0.2e1) * ((-t8662 + t8663) * np.exp((-1*1j) * (t8647 - 12 * phi2)) + (t8662 + t8663) * np.exp((-1*1j) * (t8647 + 12 * phi2))) * ((1 - t8646) ** (-0.1e1 / 0.2e1)) * ((1 + t8646) ** (-0.1e1 / 0.2e1))

        if Bindx == 408:
            t8680 = np.cos(phi)
            t8679 = t8680 ** 2
            t8682 = t8679 ** 2
            t8681 = t8680 * t8679
            t8684 = t8681 ** 2
            t8686 = t8682 ** 2
            t8683 = t8680 * t8682
            t8688 = t8683 ** 2
            t8690 = t8684 ** 2
            t8685 = t8680 * t8684
            t8692 = t8685 ** 2
            t8695 = 194712 * t8679 - 2861418 * t8682 + 16846228 * t8684 - 49242402 * t8686 + 75232080 * t8688 - 57327270 * t8690 + 17168580 * t8692 - 2318
            t8694 = 981547 * t8681 - 7094787 * t8683 + 20356083 * t8685 + (-23637537 * t8686 + 3108105 * t8688 + 13468455 * t8690 - 7153575 * t8692 - 36483) * t8680
            tfunc[..., c] = -(0.31e2 / 0.32768e5) * np.sqrt(0.2e1) * ((t8694 + t8695) * np.exp((-6*1j) * (phi1 - phi2)) + (-t8694 + t8695) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 409:
            t8712 = np.cos(phi)
            t8711 = t8712 ** 2
            t8714 = t8711 ** 2
            t8713 = t8712 * t8711
            t8716 = t8713 ** 2
            t8718 = t8714 ** 2
            t8715 = t8712 * t8714
            t8720 = t8715 ** 2
            t8722 = t8716 ** 2
            t8717 = t8712 * t8716
            t8724 = t8717 ** 2
            t8727 = 4 - 120 * t8711 + 996 * t8714 - 2936 * t8716 + 3276 * t8718 - 456 * t8720 - 1460 * t8722 + 696 * t8724
            t8726 = -223 * t8713 - 3 * t8715 + 2205 * t8717 + (-4717 * t8718 + 3603 * t8720 - 753 * t8722 - 145 * t8724 + 33) * t8712
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * ((t8726 + t8727) * np.exp((-6*1j) * (phi1 - 2 * phi2)) + (-t8726 + t8727) * np.exp((-6*1j) * (phi1 + 2 * phi2))) * np.sqrt(0.345345e6)

        if Bindx == 410:
            t8745 = np.cos(phi)
            t8744 = t8745 ** 2
            t8747 = t8745 * t8744
            t8748 = t8744 ** 2
            t8749 = t8745 * t8748
            t8750 = t8747 ** 2
            t8751 = t8745 * t8750
            t8752 = t8748 ** 2
            t8754 = t8749 ** 2
            t8756 = t8750 ** 2
            t8758 = t8751 ** 2
            t8762 = -179930 * t8747 + 1640574 * t8749 - 6840290 * t8751 + (15081330 * t8752 - 18193230 * t8754 + 11347050 * t8756 - 2861430 * t8758 + 5926) * t8745
            t8761 = -19350 * t8744 + 258470 * t8748 - 1137694 * t8750 + 596574 * t8754 - 4440150 * t8756 + 4440150 * t8758 + 215 + (1732500 - 1430715 * t8752) * t8752
            t8746 = 5 * phi1
            tfunc[..., c] = (0.31e2 / 0.32768e5*1j) * np.sqrt(0.105e3) * ((-t8761 + t8762) * np.exp((-1*1j) * (t8746 - 6 * phi2)) + (t8761 + t8762) * np.exp((-1*1j) * (t8746 + 6 * phi2))) * ((1 - t8745) ** (-0.1e1 / 0.2e1)) * ((1 + t8745) ** (-0.1e1 / 0.2e1))

        if Bindx == 411:
            t8780 = np.cos(phi)
            t8779 = t8780 ** 2
            t8782 = t8780 * t8779
            t8783 = t8779 ** 2
            t8784 = t8780 * t8783
            t8785 = t8782 ** 2
            t8786 = t8780 * t8785
            t8787 = t8783 ** 2
            t8789 = t8784 ** 2
            t8791 = t8785 ** 2
            t8793 = t8786 ** 2
            t8797 = -508 * t8782 + 1836 * t8784 - 2332 * t8786 + (-412 * t8787 + 3564 * t8789 - 3004 * t8791 + 812 * t8793 + 44) * t8780
            t8796 = -36 * t8779 + 664 * t8783 - 3380 * t8785 - 7724 * t8789 + 3568 * t8791 - 252 * t8793 + 1 + (7362 - 203 * t8787) * t8787
            t8781 = 5 * phi1
            tfunc[..., c] = (-0.465e3 / 0.32768e5*1j) * np.sqrt(0.3289e4) * np.sqrt(0.2e1) * ((1 + t8780) ** (-0.1e1 / 0.2e1)) * ((1 - t8780) ** (-0.1e1 / 0.2e1)) * ((t8796 + t8797) * np.exp((-1*1j) * (t8781 - 12 * phi2)) + (-t8796 + t8797) * np.exp((-1*1j) * (t8781 + 12 * phi2)))

        if Bindx == 412:
            t8814 = np.cos(phi)
            t8813 = t8814 ** 2
            t8816 = t8814 * t8813
            t8817 = t8813 ** 2
            t8818 = t8814 * t8817
            t8819 = t8816 ** 2
            t8820 = t8814 * t8819
            t8821 = t8817 ** 2
            t8823 = t8818 ** 2
            t8825 = t8819 ** 2
            t8827 = t8820 ** 2
            t8830 = 1509 * t8816 + 23089 * t8818 - 336111 * t8820 + (1383519 * t8821 - 2498145 * t8823 + 2076555 * t8825 - 650325 * t8827 - 91) * t8814
            t8829 = 15416 * t8813 - 234884 * t8817 + 1344056 * t8819 - 3687084 * t8821 + 5235720 * t8823 - 3713580 * t8825 + 1040520 * t8827 - 164
            t8815 = 2 * phi1
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * ((t8829 + t8830) * np.exp((-2*1j) * (t8815 - 3 * phi2)) + (t8829 - t8830) * np.exp((-2*1j) * (t8815 + 3 * phi2))) * np.sqrt(0.231e3)

        if Bindx == 413:
            t8847 = np.cos(phi)
            t8846 = t8847 ** 2
            t8849 = t8846 ** 2
            t8848 = t8847 * t8846
            t8851 = t8848 ** 2
            t8853 = t8849 ** 2
            t8850 = t8847 * t8849
            t8855 = t8850 ** 2
            t8857 = t8851 ** 2
            t8852 = t8847 * t8851
            t8859 = t8852 ** 2
            t8862 = 8 - 320 * t8846 + 872 * t8849 + 2800 * t8851 - 13800 * t8853 + 20512 * t8855 - 13320 * t8857 + 3248 * t8859
            t8861 = 2091 * t8848 - 9815 * t8850 + 20355 * t8852 + (-19805 * t8853 + 7241 * t8855 + 1099 * t8857 - 1015 * t8859 - 151) * t8847
            tfunc[..., c] = -(0.93e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.1495e4) * ((t8861 + t8862) * np.exp((-4*1j) * (phi1 - 3 * phi2)) + (-t8861 + t8862) * np.exp((-4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 414:
            t8880 = np.cos(phi)
            t8879 = t8880 ** 2
            t8881 = t8880 * t8879
            t8882 = t8879 ** 2
            t8883 = t8880 * t8882
            t8884 = t8881 ** 2
            t8885 = t8880 * t8884
            t8886 = t8882 ** 2
            t8888 = t8883 ** 2
            t8890 = t8884 ** 2
            t8892 = t8885 ** 2
            t8896 = -54794 * t8881 + 516046 * t8883 - 2153714 * t8885 + (4647426 * t8886 - 5414430 * t8888 + 3238170 * t8890 - 780390 * t8892 + 1686) * t8880
            t8895 = 4606 * t8879 - 79694 * t8882 + 559206 * t8884 + 4046298 * t8888 - 4565730 * t8890 + 2699970 * t8892 - 47 + (-2014284 - 650325 * t8886) * t8886
            tfunc[..., c] = (0.31e2 / 0.32768e5*1j) * np.sqrt(0.1463e4) * ((-t8895 + t8896) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t8895 + t8896) * np.exp((-3*1j) * (phi1 + 2 * phi2))) * ((1 + t8880) ** (-0.1e1 / 0.2e1)) * ((1 - t8880) ** (-0.1e1 / 0.2e1))

        if Bindx == 415:
            t8914 = np.cos(phi)
            t8913 = t8914 ** 2
            t8915 = t8914 * t8913
            t8916 = t8913 ** 2
            t8917 = t8914 * t8916
            t8918 = t8915 ** 2
            t8919 = t8914 * t8918
            t8920 = t8916 ** 2
            t8922 = t8917 ** 2
            t8924 = t8918 ** 2
            t8926 = t8919 ** 2
            t8930 = -1036 * t8915 + 6716 * t8917 - 20140 * t8919 + (32020 * t8920 - 28100 * t8922 + 12916 * t8924 - 2436 * t8926 + 60) * t8914
            t8929 = -572 * t8913 + 3904 * t8916 - 10380 * t8918 - 4788 * t8922 - 3448 * t8924 + 3836 * t8926 + 13 + (12450 - 1015 * t8920) * t8920
            tfunc[..., c] = (0.31e2 / 0.32768e5*1j) * np.sqrt(0.85215e5) * np.sqrt(0.2e1) * ((-t8929 + t8930) * np.exp((-3*1j) * (phi1 - 4 * phi2)) + (t8929 + t8930) * np.exp((-3*1j) * (phi1 + 4 * phi2))) * ((1 + t8914) ** (-0.1e1 / 0.2e1)) * ((1 - t8914) ** (-0.1e1 / 0.2e1))

        if Bindx == 416:
            t8947 = np.cos(phi)
            t8946 = t8947 ** 2
            t8949 = t8946 ** 2
            t8948 = t8947 * t8946
            t8951 = t8948 ** 2
            t8953 = t8949 ** 2
            t8950 = t8947 * t8949
            t8955 = t8950 ** 2
            t8957 = t8951 ** 2
            t8952 = t8947 * t8951
            t8959 = t8952 ** 2
            t8962 = -600 * t8946 + 9554 * t8949 - 55972 * t8951 + 153962 * t8953 - 215280 * t8955 + 148350 * t8957 - 40020 * t8959 + 6
            t8961 = 2763 * t8948 - 26851 * t8950 + 116355 * t8952 + (-261809 * t8953 + 318665 * t8955 - 199065 * t8957 + 50025 * t8959 - 83) * t8947
            tfunc[..., c] = (0.93e2 / 0.32768e5) * np.sqrt(0.19019e5) * np.sqrt(0.2e1) * ((t8961 + t8962) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (-t8961 + t8962) * np.exp((-2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 417:
            t8979 = np.cos(phi)
            t8978 = t8979 ** 2
            t8980 = t8979 * t8978
            t8981 = t8978 ** 2
            t8982 = t8979 * t8981
            t8983 = t8980 ** 2
            t8984 = t8979 * t8983
            t8985 = t8981 ** 2
            t8987 = t8982 ** 2
            t8989 = t8983 ** 2
            t8991 = t8984 ** 2
            t8994 = 279 * t8980 - 5 * t8982 - 3285 * t8984 + (8485 * t8985 - 9355 * t8987 + 4921 * t8989 - 1015 * t8991 - 25) * t8979
            t8993 = -12 + 552 * t8978 - 4204 * t8981 + 13160 * t8983 - 21220 * t8985 + 18712 * t8987 - 8612 * t8989 + 1624 * t8991
            tfunc[..., c] = -(0.93e2 / 0.16384e5) * ((t8993 + t8994) * np.exp((-2*1j) * (phi1 - 6 * phi2)) + (t8993 - t8994) * np.exp((-2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.6555e4)

        if Bindx == 418:
            t9012 = np.cos(phi)
            t9011 = t9012 ** 2
            t9013 = t9012 * t9011
            t9014 = t9011 ** 2
            t9015 = t9012 * t9014
            t9016 = t9013 ** 2
            t9017 = t9012 * t9016
            t9018 = t9014 ** 2
            t9020 = t9015 ** 2
            t9022 = t9016 ** 2
            t9024 = t9017 ** 2
            t9028 = 1414 * t9013 - 13650 * t9015 + 57726 * t9017 + (-124798 * t9018 + 144210 * t9020 - 84870 * t9022 + 20010 * t9024 - 42) * t9012
            t9027 = 714 * t9011 - 12082 * t9014 + 78722 * t9016 + 451582 * t9020 - 448270 * t9022 + 233910 * t9024 - 7 + (-254544 - 50025 * t9018) * t9018
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * np.sqrt(0.46189e5) * ((1 + t9012) ** (-0.1e1 / 0.2e1)) * ((1 - t9012) ** (-0.1e1 / 0.2e1)) * ((t9027 + t9028) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (-t9027 + t9028) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 419:
            t9046 = np.cos(phi)
            t9045 = t9046 ** 2
            t9047 = t9046 * t9045
            t9048 = t9045 ** 2
            t9049 = t9046 * t9048
            t9050 = t9047 ** 2
            t9051 = t9046 * t9050
            t9052 = t9048 ** 2
            t9054 = t9049 ** 2
            t9056 = t9050 ** 2
            t9058 = t9051 ** 2
            t9062 = -188 * t9047 + 876 * t9049 - 1980 * t9051 + (2500 * t9052 - 1812 * t9054 + 708 * t9056 - 116 * t9058 + 12) * t9046
            t9061 = 48 * t9045 - 412 * t9048 + 1520 * t9050 + 3536 * t9054 - 2428 * t9056 + 912 * t9058 - 1 + (-3030 - 145 * t9052) * t9052
            tfunc[..., c] = (0.93e2 / 0.32768e5*1j) * np.sqrt(0.780045e6) * np.sqrt(0.2e1) * ((-t9061 + t9062) * np.exp((-1*1j) * (phi1 - 12 * phi2)) + (t9061 + t9062) * np.exp((-1*1j) * (phi1 + 12 * phi2))) * ((1 + t9046) ** (-0.1e1 / 0.2e1)) * ((1 - t9046) ** (-0.1e1 / 0.2e1))

        if Bindx == 420:
            t9071 = np.sin(phi)
            t9068 = t9071 ** 2
            t9069 = t9071 * t9068
            t9063 = np.cos(phi)
            t9064 = t9063 ** 2
            t9065 = t9064 ** 2
            tfunc[..., c] = (-0.31e2 / 0.4096e4*1j) * t9063 * t9069 ** 2 * (-644 * t9064 + 21 + (-12420 * t9064 + 4830 + 10005 * t9065) * t9065) * np.sin((6 * phi2)) * np.sqrt(0.692835e6)

        if Bindx == 421:
            t9077 = np.sin(phi)
            t9073 = t9077 ** 2
            t9074 = t9077 * t9073
            t9075 = t9074 ** 2
            t9072 = np.cos(phi)
            tfunc[..., c] = (0.465e3 / 0.4096e4*1j) * t9072 * t9075 ** 2 * (29 * t9072 ** 2 - 3) * np.sin((12 * phi2)) * np.sqrt(0.52003e5) * np.sqrt(0.2e1)

        if Bindx == 422:
            t9095 = np.cos(phi)
            t9094 = t9095 ** 2
            t9096 = t9095 * t9094
            t9097 = t9094 ** 2
            t9098 = t9095 * t9097
            t9099 = t9096 ** 2
            t9100 = t9095 * t9099
            t9101 = t9097 ** 2
            t9103 = t9098 ** 2
            t9105 = t9099 ** 2
            t9107 = t9100 ** 2
            t9111 = -1414 * t9096 + 13650 * t9098 - 57726 * t9100 + (124798 * t9101 - 144210 * t9103 + 84870 * t9105 - 20010 * t9107 + 42) * t9095
            t9110 = 714 * t9094 - 12082 * t9097 + 78722 * t9099 + 451582 * t9103 - 448270 * t9105 + 233910 * t9107 - 7 + (-254544 - 50025 * t9101) * t9101
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * np.sqrt(0.46189e5) * ((1 + t9095) ** (-0.1e1 / 0.2e1)) * ((1 - t9095) ** (-0.1e1 / 0.2e1)) * ((-t9110 + t9111) * np.exp((1j) * (phi1 - 6 * phi2)) + (t9110 + t9111) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 423:
            t9129 = np.cos(phi)
            t9128 = t9129 ** 2
            t9130 = t9129 * t9128
            t9131 = t9128 ** 2
            t9132 = t9129 * t9131
            t9133 = t9130 ** 2
            t9134 = t9129 * t9133
            t9135 = t9131 ** 2
            t9137 = t9132 ** 2
            t9139 = t9133 ** 2
            t9141 = t9134 ** 2
            t9145 = 188 * t9130 - 876 * t9132 + 1980 * t9134 + (-2500 * t9135 + 1812 * t9137 - 708 * t9139 + 116 * t9141 - 12) * t9129
            t9144 = 48 * t9128 - 412 * t9131 + 1520 * t9133 + 3536 * t9137 - 2428 * t9139 + 912 * t9141 - 1 + (-3030 - 145 * t9135) * t9135
            tfunc[..., c] = (0.93e2 / 0.32768e5*1j) * np.sqrt(0.780045e6) * np.sqrt(0.2e1) * ((t9144 + t9145) * np.exp((1j) * (phi1 - 12 * phi2)) + (-t9144 + t9145) * np.exp((1j) * (phi1 + 12 * phi2))) * ((1 + t9129) ** (-0.1e1 / 0.2e1)) * ((1 - t9129) ** (-0.1e1 / 0.2e1))

        if Bindx == 424:
            t9162 = np.cos(phi)
            t9161 = t9162 ** 2
            t9164 = t9161 ** 2
            t9163 = t9162 * t9161
            t9166 = t9163 ** 2
            t9168 = t9164 ** 2
            t9165 = t9162 * t9164
            t9170 = t9165 ** 2
            t9172 = t9166 ** 2
            t9167 = t9162 * t9166
            t9174 = t9167 ** 2
            t9177 = -600 * t9161 + 9554 * t9164 - 55972 * t9166 + 153962 * t9168 - 215280 * t9170 + 148350 * t9172 - 40020 * t9174 + 6
            t9176 = 2763 * t9163 - 26851 * t9165 + 116355 * t9167 + (-261809 * t9168 + 318665 * t9170 - 199065 * t9172 + 50025 * t9174 - 83) * t9162
            tfunc[..., c] = -(0.93e2 / 0.32768e5) * np.sqrt(0.19019e5) * np.sqrt(0.2e1) * ((t9176 + t9177) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (-t9176 + t9177) * np.exp((2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 425:
            t9194 = np.cos(phi)
            t9193 = t9194 ** 2
            t9195 = t9194 * t9193
            t9196 = t9193 ** 2
            t9197 = t9194 * t9196
            t9198 = t9195 ** 2
            t9199 = t9194 * t9198
            t9200 = t9196 ** 2
            t9202 = t9197 ** 2
            t9204 = t9198 ** 2
            t9206 = t9199 ** 2
            t9209 = 279 * t9195 - 5 * t9197 - 3285 * t9199 + (8485 * t9200 - 9355 * t9202 + 4921 * t9204 - 1015 * t9206 - 25) * t9194
            t9208 = -12 + 552 * t9193 - 4204 * t9196 + 13160 * t9198 - 21220 * t9200 + 18712 * t9202 - 8612 * t9204 + 1624 * t9206
            tfunc[..., c] = (0.93e2 / 0.16384e5) * ((t9208 + t9209) * np.exp((2*1j) * (phi1 - 6 * phi2)) + (t9208 - t9209) * np.exp((2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.6555e4)

        if Bindx == 426:
            t9227 = np.cos(phi)
            t9226 = t9227 ** 2
            t9228 = t9227 * t9226
            t9229 = t9226 ** 2
            t9230 = t9227 * t9229
            t9231 = t9228 ** 2
            t9232 = t9227 * t9231
            t9233 = t9229 ** 2
            t9235 = t9230 ** 2
            t9237 = t9231 ** 2
            t9239 = t9232 ** 2
            t9243 = -54794 * t9228 + 516046 * t9230 - 2153714 * t9232 + (4647426 * t9233 - 5414430 * t9235 + 3238170 * t9237 - 780390 * t9239 + 1686) * t9227
            t9242 = 4606 * t9226 - 79694 * t9229 + 559206 * t9231 + 4046298 * t9235 - 4565730 * t9237 + 2699970 * t9239 - 47 + (-2014284 - 650325 * t9233) * t9233
            tfunc[..., c] = (-0.31e2 / 0.32768e5*1j) * np.sqrt(0.1463e4) * ((1 + t9227) ** (-0.1e1 / 0.2e1)) * ((1 - t9227) ** (-0.1e1 / 0.2e1)) * ((-t9242 + t9243) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t9242 + t9243) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 427:
            t9261 = np.cos(phi)
            t9260 = t9261 ** 2
            t9262 = t9261 * t9260
            t9263 = t9260 ** 2
            t9264 = t9261 * t9263
            t9265 = t9262 ** 2
            t9266 = t9261 * t9265
            t9267 = t9263 ** 2
            t9269 = t9264 ** 2
            t9271 = t9265 ** 2
            t9273 = t9266 ** 2
            t9277 = -1036 * t9262 + 6716 * t9264 - 20140 * t9266 + (32020 * t9267 - 28100 * t9269 + 12916 * t9271 - 2436 * t9273 + 60) * t9261
            t9276 = -572 * t9260 + 3904 * t9263 - 10380 * t9265 - 4788 * t9269 - 3448 * t9271 + 3836 * t9273 + 13 + (12450 - 1015 * t9267) * t9267
            tfunc[..., c] = (-0.31e2 / 0.32768e5*1j) * np.sqrt(0.85215e5) * np.sqrt(0.2e1) * ((1 + t9261) ** (-0.1e1 / 0.2e1)) * ((1 - t9261) ** (-0.1e1 / 0.2e1)) * ((-t9276 + t9277) * np.exp((3*1j) * (phi1 - 4 * phi2)) + (t9276 + t9277) * np.exp((3*1j) * (phi1 + 4 * phi2)))

        if Bindx == 428:
            t9294 = np.cos(phi)
            t9293 = t9294 ** 2
            t9296 = t9294 * t9293
            t9297 = t9293 ** 2
            t9298 = t9294 * t9297
            t9299 = t9296 ** 2
            t9300 = t9294 * t9299
            t9301 = t9297 ** 2
            t9303 = t9298 ** 2
            t9305 = t9299 ** 2
            t9307 = t9300 ** 2
            t9310 = 1509 * t9296 + 23089 * t9298 - 336111 * t9300 + (1383519 * t9301 - 2498145 * t9303 + 2076555 * t9305 - 650325 * t9307 - 91) * t9294
            t9309 = -15416 * t9293 + 234884 * t9297 - 1344056 * t9299 + 3687084 * t9301 - 5235720 * t9303 + 3713580 * t9305 - 1040520 * t9307 + 164
            t9295 = 2 * phi1
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * ((t9309 - t9310) * np.exp((2*1j) * (t9295 - 3 * phi2)) + (t9309 + t9310) * np.exp((2*1j) * (t9295 + 3 * phi2))) * np.sqrt(0.231e3)

        if Bindx == 429:
            t9327 = np.cos(phi)
            t9326 = t9327 ** 2
            t9329 = t9326 ** 2
            t9328 = t9327 * t9326
            t9331 = t9328 ** 2
            t9333 = t9329 ** 2
            t9330 = t9327 * t9329
            t9335 = t9330 ** 2
            t9337 = t9331 ** 2
            t9332 = t9327 * t9331
            t9339 = t9332 ** 2
            t9342 = 8 - 320 * t9326 + 872 * t9329 + 2800 * t9331 - 13800 * t9333 + 20512 * t9335 - 13320 * t9337 + 3248 * t9339
            t9341 = 2091 * t9328 - 9815 * t9330 + 20355 * t9332 + (-19805 * t9333 + 7241 * t9335 + 1099 * t9337 - 1015 * t9339 - 151) * t9327
            tfunc[..., c] = (0.93e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.1495e4) * ((t9341 + t9342) * np.exp((4*1j) * (phi1 - 3 * phi2)) + (-t9341 + t9342) * np.exp((4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 430:
            t9360 = np.cos(phi)
            t9359 = t9360 ** 2
            t9362 = t9360 * t9359
            t9363 = t9359 ** 2
            t9364 = t9360 * t9363
            t9365 = t9362 ** 2
            t9366 = t9360 * t9365
            t9367 = t9363 ** 2
            t9369 = t9364 ** 2
            t9371 = t9365 ** 2
            t9373 = t9366 ** 2
            t9377 = -179930 * t9362 + 1640574 * t9364 - 6840290 * t9366 + (15081330 * t9367 - 18193230 * t9369 + 11347050 * t9371 - 2861430 * t9373 + 5926) * t9360
            t9376 = -19350 * t9359 + 258470 * t9363 - 1137694 * t9365 + 596574 * t9369 - 4440150 * t9371 + 4440150 * t9373 + 215 + (1732500 - 1430715 * t9367) * t9367
            t9361 = 5 * phi1
            tfunc[..., c] = (-0.31e2 / 0.32768e5*1j) * np.sqrt(0.105e3) * ((1 + t9360) ** (-0.1e1 / 0.2e1)) * ((1 - t9360) ** (-0.1e1 / 0.2e1)) * ((-t9376 + t9377) * np.exp((1j) * (t9361 - 6 * phi2)) + (t9376 + t9377) * np.exp((1j) * (t9361 + 6 * phi2)))

        if Bindx == 431:
            t9395 = np.cos(phi)
            t9394 = t9395 ** 2
            t9397 = t9395 * t9394
            t9398 = t9394 ** 2
            t9399 = t9395 * t9398
            t9400 = t9397 ** 2
            t9401 = t9395 * t9400
            t9402 = t9398 ** 2
            t9404 = t9399 ** 2
            t9406 = t9400 ** 2
            t9408 = t9401 ** 2
            t9412 = 508 * t9397 - 1836 * t9399 + 2332 * t9401 + (412 * t9402 - 3564 * t9404 + 3004 * t9406 - 812 * t9408 - 44) * t9395
            t9411 = -36 * t9394 + 664 * t9398 - 3380 * t9400 - 7724 * t9404 + 3568 * t9406 - 252 * t9408 + 1 + (7362 - 203 * t9402) * t9402
            t9396 = 5 * phi1
            tfunc[..., c] = (-0.465e3 / 0.32768e5*1j) * np.sqrt(0.3289e4) * np.sqrt(0.2e1) * ((-t9411 + t9412) * np.exp((1j) * (t9396 - 12 * phi2)) + (t9411 + t9412) * np.exp((1j) * (t9396 + 12 * phi2))) * ((1 + t9395) ** (-0.1e1 / 0.2e1)) * ((1 - t9395) ** (-0.1e1 / 0.2e1))

        if Bindx == 432:
            t9429 = np.cos(phi)
            t9428 = t9429 ** 2
            t9431 = t9428 ** 2
            t9430 = t9429 * t9428
            t9433 = t9430 ** 2
            t9435 = t9431 ** 2
            t9432 = t9429 * t9431
            t9437 = t9432 ** 2
            t9439 = t9433 ** 2
            t9434 = t9429 * t9433
            t9441 = t9434 ** 2
            t9444 = -194712 * t9428 + 2861418 * t9431 - 16846228 * t9433 + 49242402 * t9435 - 75232080 * t9437 + 57327270 * t9439 - 17168580 * t9441 + 2318
            t9443 = 981547 * t9430 - 7094787 * t9432 + 20356083 * t9434 + (-23637537 * t9435 + 3108105 * t9437 + 13468455 * t9439 - 7153575 * t9441 - 36483) * t9429
            tfunc[..., c] = -(0.31e2 / 0.32768e5) * np.sqrt(0.2e1) * ((-t9443 + t9444) * np.exp((6*1j) * (phi1 - phi2)) + (t9443 + t9444) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 433:
            t9461 = np.cos(phi)
            t9460 = t9461 ** 2
            t9463 = t9460 ** 2
            t9462 = t9461 * t9460
            t9465 = t9462 ** 2
            t9467 = t9463 ** 2
            t9464 = t9461 * t9463
            t9469 = t9464 ** 2
            t9471 = t9465 ** 2
            t9466 = t9461 * t9465
            t9473 = t9466 ** 2
            t9476 = -4 + 120 * t9460 - 996 * t9463 + 2936 * t9465 - 3276 * t9467 + 456 * t9469 + 1460 * t9471 - 696 * t9473
            t9475 = -223 * t9462 - 3 * t9464 + 2205 * t9466 + (-4717 * t9467 + 3603 * t9469 - 753 * t9471 - 145 * t9473 + 33) * t9461
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * ((-t9475 + t9476) * np.exp((6*1j) * (phi1 - 2 * phi2)) + (t9475 + t9476) * np.exp((6*1j) * (phi1 + 2 * phi2))) * np.sqrt(0.345345e6)

        if Bindx == 434:
            t9493 = np.cos(phi)
            t9492 = t9493 ** 2
            t9495 = t9493 * t9492
            t9498 = t9495 ** 2
            t9499 = t9493 * t9498
            t9506 = t9499 ** 2
            t9508 = -650325 * t9493 * t9506 - 509
            t9504 = t9498 ** 2
            t9496 = t9492 ** 2
            t9497 = t9493 * t9496
            t9502 = t9497 ** 2
            t9500 = t9496 ** 2
            t9494 = 7 * phi1
            t9485 = t9493 * t9500
            t9483 = t9493 * t9502
            t9481 = t9493 * t9504
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * np.sqrt((1 - t9493)) * np.sqrt(0.11e2) * ((2166255 * t9481 - 2689505 * t9483 + 1489411 * t9485 + 40775 * t9492 + 1073 * t9493 - 7483 * t9495 - 509481 * t9496 + 23709 * t9497 + 2412347 * t9498 - 333135 * t9499 - 5672007 * t9500 + 7110565 * t9502 - 4552275 * t9504 + 1170585 * t9506 + t9508) * np.exp((1j) * (t9494 - 6 * phi2)) + (1475565 * t9481 - 7105735 * t9483 + 8315489 * t9485 - 37611 * t9492 + 2091 * t9493 - 85869 * t9495 + 416129 * t9496 + 949319 * t9497 - 1439319 * t9498 - 4184801 * t9499 + 1154071 * t9500 + 2694335 * t9502 - 5242965 * t9504 + 2471235 * t9506 - t9508) * np.exp((1j) * (t9494 + 6 * phi2))) * ((1 + t9493) ** (-0.1e1 / 0.2e1))

        if Bindx == 435:
            t9526 = np.cos(phi)
            t9525 = t9526 ** 2
            t9528 = t9526 * t9525
            t9529 = t9525 ** 2
            t9530 = t9526 * t9529
            t9531 = t9528 ** 2
            t9532 = t9526 * t9531
            t9533 = t9529 ** 2
            t9535 = t9530 ** 2
            t9537 = t9531 ** 2
            t9539 = t9532 ** 2
            t9543 = 92 * t9528 - 1740 * t9530 + 5852 * t9532 + (-7524 * t9533 + 3060 * t9535 + 1052 * t9537 - 812 * t9539 + 20) * t9526
            t9542 = 216 * t9525 - 1252 * t9529 + 2200 * t9531 - 5368 * t9535 + 5036 * t9537 - 1272 * t9539 - 9 + (594 - 145 * t9533) * t9533
            t9527 = 7 * phi1
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * np.sqrt(0.31395e5) * np.sqrt(0.2e1) * ((1 + t9526) ** (-0.1e1 / 0.2e1)) * ((1 - t9526) ** (-0.1e1 / 0.2e1)) * ((-t9542 + t9543) * np.exp((1j) * (t9527 - 12 * phi2)) + (t9542 + t9543) * np.exp((1j) * (t9527 + 12 * phi2)))

        if Bindx == 436:
            t9560 = np.cos(phi)
            t9559 = t9560 ** 2
            t9563 = t9559 ** 2
            t9562 = t9560 * t9559
            t9565 = t9562 ** 2
            t9567 = t9563 ** 2
            t9564 = t9560 * t9563
            t9569 = t9564 ** 2
            t9571 = t9565 ** 2
            t9566 = t9560 * t9565
            t9573 = t9566 ** 2
            t9576 = 560 * t9559 - 2632 * t9563 - 20496 * t9565 + 140776 * t9567 - 300720 * t9569 + 273000 * t9571 - 90480 * t9573 - 8
            t9575 = -10731 * t9562 + 73633 * t9564 - 222055 * t9566 + (316967 * t9567 - 185185 * t9569 - 1365 * t9571 + 28275 * t9573 + 461) * t9560
            t9561 = 4 * phi1
            tfunc[..., c] = -(0.93e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.253e3) * ((t9575 + t9576) * np.exp((2*1j) * (t9561 - 3 * phi2)) + (-t9575 + t9576) * np.exp((2*1j) * (t9561 + 3 * phi2)))

        if Bindx == 437:
            t9593 = np.cos(phi)
            t9592 = t9593 ** 2
            t9596 = t9592 ** 2
            t9595 = t9593 * t9592
            t9598 = t9595 ** 2
            t9600 = t9596 ** 2
            t9597 = t9593 * t9596
            t9602 = t9597 ** 2
            t9604 = t9598 ** 2
            t9599 = t9593 * t9598
            t9606 = t9599 ** 2
            t9609 = 16 - 256 * t9592 + 592 * t9596 + 1760 * t9598 - 6864 * t9600 + 6336 * t9602 - 656 * t9604 - 928 * t9606
            t9608 = -587 * t9595 + 3047 * t9597 - 4587 * t9599 + (-11 * t9600 + 4295 * t9602 - 2027 * t9604 - 145 * t9606 + 15) * t9593
            t9594 = 2 * phi1
            tfunc[..., c] = -(0.93e2 / 0.8192e4) * ((-t9608 + t9609) * np.exp((4*1j) * (t9594 - 3 * phi2)) + (t9608 + t9609) * np.exp((4*1j) * (t9594 + 3 * phi2))) * np.sqrt(0.1365e4)

        if Bindx == 438:
            t9625 = np.cos(phi)
            t9624 = t9625 ** 2
            t9627 = t9625 * t9624
            t9630 = t9627 ** 2
            t9631 = t9625 * t9630
            t9639 = -28275 * t9631 ** 2 + 59
            t9636 = t9630 ** 2
            t9628 = t9624 ** 2
            t9629 = t9625 * t9628
            t9634 = t9629 ** 2
            t9632 = t9628 ** 2
            t9626 = 3 * phi1
            t9617 = t9625 * t9632
            t9615 = t9625 * t9634
            t9613 = t9625 * t9636
            tfunc[..., c] = (0.31e2 / 0.32768e5*1j) * ((1 - t9625) ** (0.3e1 / 0.2e1)) * np.sqrt(0.5313e4) * ((45240 * t9613 + 102765 * t9636 - 177840 * t9615 - 147615 * t9634 + 277800 * t9617 + 109169 * t9632 - 217376 * t9631 - 47449 * t9630 + 87176 * t9629 + 13735 * t9628 - 15664 * t9627 - 2389 * t9624 + 664 * t9625 + t9639) * np.exp((3*1j) * (t9626 - 2 * phi2)) + (158340 * t9613 + 304395 * t9636 + 112320 * t9615 - 390585 * t9634 - 498300 * t9617 - 11969 * t9632 + 316448 * t9631 + 148393 * t9630 - 54964 * t9629 - 50255 * t9628 - 1504 * t9627 + 4573 * t9624 + 428 * t9625 - t9639) * np.exp((3*1j) * (t9626 + 2 * phi2))) * ((1 + t9625) ** (-0.1e1 / 0.2e1))

        if Bindx == 439:
            t9657 = np.cos(phi)
            t9656 = t9657 ** 2
            t9659 = t9657 * t9656
            t9660 = t9656 ** 2
            t9661 = t9657 * t9660
            t9662 = t9659 ** 2
            t9663 = t9657 * t9662
            t9664 = t9660 ** 2
            t9666 = t9661 ** 2
            t9668 = t9662 ** 2
            t9670 = t9663 ** 2
            t9674 = -7876 * t9659 + 23636 * t9661 - 3652 * t9663 + (-63492 * t9664 + 72084 * t9666 - 13956 * t9668 - 7308 * t9670 + 564) * t9657
            t9673 = -1416 * t9656 - 5196 * t9660 + 44088 * t9662 + 28776 * t9666 + 31364 * t9668 - 19096 * t9670 + 177 + (-77682 - 1015 * t9664) * t9664
            t9658 = 3 * phi1
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * np.sqrt(0.65e2) * np.sqrt(0.2e1) * ((1 + t9657) ** (-0.1e1 / 0.2e1)) * ((1 - t9657) ** (-0.1e1 / 0.2e1)) * ((-t9673 + t9674) * np.exp((3*1j) * (t9658 - 4 * phi2)) + (t9673 + t9674) * np.exp((3*1j) * (t9658 + 4 * phi2)))

        if Bindx == 440:
            t9691 = np.cos(phi)
            t9690 = t9691 ** 2
            t9694 = t9690 ** 2
            t9693 = t9691 * t9690
            t9696 = t9693 ** 2
            t9698 = t9694 ** 2
            t9695 = t9691 * t9694
            t9700 = t9695 ** 2
            t9702 = t9696 ** 2
            t9697 = t9691 * t9696
            t9704 = t9697 ** 2
            t9707 = -6 + 312 * t9690 - 2386 * t9694 + 6116 * t9696 - 3562 * t9698 - 7728 * t9700 + 11778 * t9702 - 4524 * t9704
            t9706 = 511 * t9693 - 4343 * t9695 + 15175 * t9697 + (-24125 * t9698 + 16549 * t9700 - 2613 * t9702 - 1131 * t9704 - 23) * t9691
            t9692 = 5 * phi1
            tfunc[..., c] = -(0.465e3 / 0.32768e5) * np.sqrt(0.2e1) * np.sqrt(0.1771e4) * ((-t9706 + t9707) * np.exp((2*1j) * (t9692 - 3 * phi2)) + (t9706 + t9707) * np.exp((2*1j) * (t9692 + 3 * phi2)))

        if Bindx == 441:
            t9724 = np.cos(phi)
            t9723 = t9724 ** 2
            t9727 = t9723 ** 2
            t9726 = t9724 * t9723
            t9729 = t9726 ** 2
            t9731 = t9727 ** 2
            t9728 = t9724 * t9727
            t9733 = t9728 ** 2
            t9735 = t9729 ** 2
            t9730 = t9724 * t9729
            t9737 = t9730 ** 2
            t9740 = 52 + 104 * t9723 - 4076 * t9727 + 10472 * t9729 - 1188 * t9731 - 13992 * t9733 + 7004 * t9735 + 1624 * t9737
            t9739 = 1819 * t9726 + 143 * t9728 - 13233 * t9730 + (16577 * t9731 + 289 * t9733 - 5131 * t9735 - 203 * t9737 - 261) * t9724
            t9725 = 5 * phi1
            tfunc[..., c] = (0.93e2 / 0.16384e5) * ((t9739 + t9740) * np.exp((2*1j) * (t9725 - 6 * phi2)) + (-t9739 + t9740) * np.exp((2*1j) * (t9725 + 6 * phi2))) * np.sqrt(0.195e3)

        if Bindx == 442:
            t9755 = np.cos(phi)
            t9754 = t9755 ** 2
            t9757 = t9755 * t9754
            t9760 = t9757 ** 2
            t9766 = t9760 ** 2
            t9768 = -435 * t9755 * t9766 + 1
            t9758 = t9754 ** 2
            t9759 = t9755 * t9758
            t9764 = t9759 ** 2
            t9762 = t9758 ** 2
            t9756 = 11 * phi1
            t9749 = t9755 * t9760
            t9747 = t9755 * t9762
            t9745 = t9755 * t9764
            tfunc[..., c] = (0.93e2 / 0.32768e5*1j) * ((1 - t9755) ** (0.5e1 / 0.2e1)) * np.sqrt(0.115115e6) * ((1 + t9755) ** (-0.1e1 / 0.2e1)) * ((-609 * t9766 - 1746 * t9745 + 2502 * t9764 + 2813 * t9747 - 4047 * t9762 - 2364 * t9749 + 3220 * t9760 + 1149 * t9759 - 1263 * t9758 - 338 * t9757 + 198 * t9754 + 51 * t9755 - t9768) * np.exp((1j) * (t9756 - 6 * phi2)) + (-3219 * t9766 - 9738 * t9745 - 14514 * t9764 - 8225 * t9747 + 5895 * t9762 + 12132 * t9749 + 5844 * t9760 - 1413 * t9759 - 2325 * t9758 - 570 * t9757 + 126 * t9754 + 57 * t9755 + t9768) * np.exp((1j) * (t9756 + 6 * phi2)))

        if Bindx == 443:
            t9786 = np.cos(phi)
            t9785 = t9786 ** 2
            t9788 = t9786 * t9785
            t9789 = t9785 ** 2
            t9790 = t9786 * t9789
            t9791 = t9788 ** 2
            t9792 = t9786 * t9791
            t9793 = t9789 ** 2
            t9795 = t9790 ** 2
            t9797 = t9791 ** 2
            t9799 = t9792 ** 2
            t9803 = -6356 * t9788 - 40092 * t9790 + 126412 * t9792 + (-56628 * t9793 - 87516 * t9795 + 52844 * t9797 + 8932 * t9799 + 2404) * t9786
            t9802 = 4356 * t9785 - 35464 * t9789 + 33748 * t9791 - 148148 * t9795 + 17056 * t9797 + 31836 * t9799 + 363 + (95238 + 1015 * t9793) * t9793
            t9787 = 11 * phi1
            tfunc[..., c] = (0.93e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * ((-t9802 + t9803) * np.exp((1j) * (t9787 - 12 * phi2)) + (t9802 + t9803) * np.exp((1j) * (t9787 + 12 * phi2))) * ((1 + t9786) ** (-0.1e1 / 0.2e1)) * ((1 - t9786) ** (-0.1e1 / 0.2e1))

        if Bindx == 444:
            t9820 = np.cos(phi)
            t9819 = t9820 ** 2
            t9823 = t9819 ** 2
            t9822 = t9820 * t9819
            t9825 = t9822 ** 2
            t9827 = t9823 ** 2
            t9824 = t9820 * t9823
            t9829 = t9824 ** 2
            t9831 = t9825 ** 2
            t9826 = t9820 * t9825
            t9833 = t9826 ** 2
            t9836 = 4 - 120 * t9819 + 996 * t9823 - 2936 * t9825 + 3276 * t9827 - 456 * t9829 - 1460 * t9831 + 696 * t9833
            t9835 = -223 * t9822 - 3 * t9824 + 2205 * t9826 + (-4717 * t9827 + 3603 * t9829 - 753 * t9831 - 145 * t9833 + 33) * t9820
            t9821 = 2 * phi1
            tfunc[..., c] = (0.31e2 / 0.16384e5) * ((t9835 + t9836) * np.exp((6*1j) * (t9821 - phi2)) + (-t9835 + t9836) * np.exp((6*1j) * (t9821 + phi2))) * np.sqrt(0.345345e6)

        if Bindx == 445:
            t9853 = np.cos(phi)
            t9852 = t9853 ** 2
            t9855 = t9852 ** 2
            t9854 = t9853 * t9852
            t9857 = t9854 ** 2
            t9859 = t9855 ** 2
            t9856 = t9853 * t9855
            t9861 = t9856 ** 2
            t9863 = t9857 ** 2
            t9858 = t9853 * t9857
            t9865 = t9858 ** 2
            t9868 = 11712 * t9852 - 30264 * t9855 - 80080 * t9857 + 175032 * t9859 + 13728 * t9861 - 84968 * t9863 - 9744 * t9865 + 488
            t9867 = -9451 * t9854 + 90519 * t9856 - 47619 * t9858 + (-152867 * t9859 + 86775 * t9861 + 39669 * t9863 + 1015 * t9865 - 3945) * t9853
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * np.sqrt(0.2e1) * ((t9867 + t9868) * np.exp((12*1j) * (phi1 - phi2)) + (-t9867 + t9868) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 446:
            t9882 = np.cos(phi)
            t9881 = t9882 ** 2
            t9884 = t9882 * t9881
            t9887 = t9884 ** 2
            t9894 = -145 * t9887 ** 2 - 19
            t9885 = t9881 ** 2
            t9886 = t9882 * t9885
            t9891 = t9886 ** 2
            t9889 = t9885 ** 2
            t9883 = 13 * phi1
            t9876 = t9882 * t9887
            t9874 = t9882 * t9889
            t9872 = t9882 * t9891
            tfunc[..., c] = (-0.93e2 / 0.32768e5*1j) * ((1 - t9882) ** (0.7e1 / 0.2e1)) * np.sqrt(0.16445e5) * ((1 + t9882) ** (-0.1e1 / 0.2e1)) * ((-174 * t9872 - 648 * t9891 + 774 * t9874 + 1161 * t9889 - 1356 * t9876 - 1064 * t9887 + 1164 * t9886 + 531 * t9885 - 486 * t9884 - 144 * t9881 + 78 * t9882 - t9894) * np.exp((1j) * (t9883 - 6 * phi2)) + (-1334 * t9872 - 5384 * t9891 - 12370 * t9874 - 17385 * t9889 - 14460 * t9876 - 5208 * t9887 + 2172 * t9886 + 3405 * t9885 + 1490 * t9884 + 160 * t9881 - 74 * t9882 + t9894) * np.exp((1j) * (t9883 + 6 * phi2)))

        if Bindx == 447:
            t9911 = np.cos(phi)
            t9910 = t9911 ** 2
            t9913 = t9911 * t9910
            t9916 = t9913 ** 2
            t9917 = t9911 * t9916
            t9924 = t9917 ** 2
            t9926 = -145 * t9911 * t9924 - 91
            t9922 = t9916 ** 2
            t9914 = t9910 ** 2
            t9915 = t9911 * t9914
            t9920 = t9915 ** 2
            t9918 = t9914 ** 2
            t9912 = 13 * phi1
            t9903 = t9911 * t9918
            t9901 = t9911 * t9920
            t9899 = t9911 * t9922
            tfunc[..., c] = (-0.31e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt((1 - t9911)) * np.sqrt(0.21e2) * ((1363 * t9924 - 5369 * t9899 + 10803 * t9922 - 9061 * t9901 - 6721 * t9920 + 24739 * t9903 - 22737 * t9918 + 429 * t9917 + 17017 * t9916 - 14443 * t9915 + 2873 * t9914 + 3081 * t9913 - 2507 * t9910 + 769 * t9911 + t9926) * np.exp((1j) * (t9912 - 12 * phi2)) + (1653 * t9924 + 8385 * t9899 + 24557 * t9922 + 44421 * t9901 + 46761 * t9920 + 15301 * t9903 - 32175 * t9918 - 55341 * t9917 - 38753 * t9916 - 7293 * t9915 + 10023 * t9914 + 9815 * t9913 + 4227 * t9910 + 951 * t9911 - t9926) * np.exp((1j) * (t9912 + 12 * phi2))) * ((1 + t9911) ** (-0.1e1 / 0.2e1))

        if Bindx == 448:
            t9943 = np.cos(phi)
            t9942 = t9943 ** 2
            t9946 = t9942 ** 2
            t9945 = t9943 * t9942
            t9948 = t9945 ** 2
            t9950 = t9946 ** 2
            t9947 = t9943 * t9946
            t9952 = t9947 ** 2
            t9954 = t9948 ** 2
            t9949 = t9943 * t9948
            t9956 = t9949 ** 2
            t9959 = 2 - 8 * t9942 - 58 * t9946 + 244 * t9948 - 306 * t9950 + 112 * t9952 + 42 * t9954 - 28 * t9956
            t9958 = -63 * t9945 + 119 * t9947 + 9 * t9949 + (-211 * t9950 + 187 * t9952 - 43 * t9954 - 5 * t9956 + 7) * t9943
            t9944 = 7 * phi1
            tfunc[..., c] = -(0.93e2 / 0.32768e5) * np.sqrt(0.2e1) * np.sqrt(0.476905e6) * ((-t9958 + t9959) * np.exp((2*1j) * (t9944 - 3 * phi2)) + (t9958 + t9959) * np.exp((2*1j) * (t9944 + 3 * phi2)))

        if Bindx == 449:
            t9976 = np.cos(phi)
            t9975 = t9976 ** 2
            t9979 = t9975 ** 2
            t9978 = t9976 * t9975
            t9981 = t9978 ** 2
            t9983 = t9979 ** 2
            t9980 = t9976 * t9979
            t9985 = t9980 ** 2
            t9987 = t9981 ** 2
            t9982 = t9976 * t9981
            t9989 = t9982 ** 2
            t9992 = -4 - 200 * t9975 - 676 * t9979 + 1144 * t9981 + 1716 * t9983 - 1144 * t9985 - 780 * t9987 - 56 * t9989
            t9991 = -507 * t9978 - 143 * t9980 + 2145 * t9982 + (143 * t9983 - 1313 * t9985 - 277 * t9987 - 5 * t9989 - 43) * t9976
            t9977 = 7 * phi1
            tfunc[..., c] = -(0.31e2 / 0.16384e5) * ((-t9991 + t9992) * np.exp((2*1j) * (t9977 - 6 * phi2)) + (t9991 + t9992) * np.exp((2*1j) * (t9977 + 6 * phi2))) * np.sqrt(0.609e3)

        if Bindx == 450:
            t10008 = np.cos(phi)
            t10024 = 6 * t10008
            t10007 = t10008 ** 2
            t10010 = t10008 * t10007
            t10011 = t10007 ** 2
            t10012 = t10008 * t10011
            t10013 = t10010 ** 2
            t10014 = t10008 * t10013
            t10015 = t10011 ** 2
            t10017 = t10012 ** 2
            t10019 = t10013 ** 2
            t10023 = t10019 * t10024 - 4 * t10010 - 38 * t10012 + 72 * t10014 + t10024 + (-38 * t10015 - 4 * t10017) * t10008
            t10022 = -t10014 ** 2 - 11 * t10007 + 39 * t10011 - 27 * t10013 - 27 * t10015 + 39 * t10017 - 11 * t10019 - 1
            t10009 = 5 * phi1
            tfunc[..., c] = (-0.155e3 / 0.32768e5*1j) * np.sqrt(0.286143e6) * np.sqrt((1 - t10008)) * np.sqrt((1 + t10008)) * ((t10022 + t10023) * np.exp((3*1j) * (t10009 - 2 * phi2)) + (-t10022 + t10023) * np.exp((3*1j) * (t10009 + 2 * phi2)))

        if Bindx == 451:
            t10039 = np.cos(phi)
            t10038 = t10039 ** 2
            t10041 = t10039 * t10038
            t10042 = t10038 ** 2
            t10043 = t10039 * t10042
            t10045 = t10042 ** 2
            t10047 = t10043 ** 2
            t10044 = t10041 ** 2
            t10049 = t10044 ** 2
            t10050 = t10039 * t10049
            t10053 = -208 * t10041 - 572 * t10043 + 12 * t10050 + (572 * t10045 + 208 * t10047 - 12) * t10039
            t10052 = -t10039 * t10050 + 65 * t10038 + 429 * t10042 + 429 * t10044 - 429 * t10045 - 429 * t10047 - 65 * t10049 + 1
            t10040 = 5 * phi1
            tfunc[..., c] = (-0.31e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt(0.1015e4) * np.sqrt((1 - t10039)) * np.sqrt((1 + t10039)) * ((t10052 + t10053) * np.exp((3*1j) * (t10040 - 4 * phi2)) + (-t10052 + t10053) * np.exp((3*1j) * (t10040 + 4 * phi2)))

        if Bindx == 452:
            t10058 = np.sin(phi)
            t10054 = t10058 ** 2
            t10055 = t10054 ** 2
            t10056 = t10055 ** 2
            tfunc[..., c] = (0.99e2 / 0.65536e5) * np.exp((-16*1j) * phi1) * np.sqrt(0.66786710e8) * t10056 ** 2

        if Bindx == 453:
            t10075 = np.cos(phi)
            t10074 = t10075 ** 2
            t10078 = t10074 ** 2
            t10077 = t10075 * t10074
            t10080 = t10077 ** 2
            t10079 = t10075 * t10078
            t10083 = t10079 ** 2
            t10085 = t10080 ** 2
            t10081 = t10075 * t10080
            t10087 = t10081 ** 2
            t10088 = t10075 * t10087
            t10091 = t10075 * t10088 - 10 * t10074 + 50 * t10078 - 66 * t10080 + 66 * t10083 - 50 * t10085 + 10 * t10087 - 1
            t10090 = -10 * t10077 - 34 * t10079 - 6 * t10088 + (-110 * t10074 + 110) * t10081 + (34 * t10083 + 10 * t10085 + 6) * t10075
            t10076 = 8 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.2e1) * np.sqrt(0.4032015e7) * ((t10090 + t10091) * np.exp((-2*1j) * (t10076 - 3 * phi2)) + (-t10090 + t10091) * np.exp((-2*1j) * (t10076 + 3 * phi2)))

        if Bindx == 454:
            t10107 = np.cos(phi)
            t10124 = -12 * t10107
            t10106 = t10107 ** 2
            t10110 = t10106 ** 2
            t10113 = t10110 ** 2
            t10114 = t10107 * t10113
            t10115 = t10106 * t10114
            t10116 = t10107 * t10115
            t10111 = t10107 * t10110
            t10112 = t10106 * t10111
            t10118 = t10112 ** 2
            t10122 = 64 * t10106 + 364 * t10110 + 364 * t10116 + 64 * t10118 + 1 + (-858 + t10113) * t10113
            t10121 = t10118 * t10124 - 364 * t10111 + 572 * t10112 + 572 * t10114 - 364 * t10115 + t10124 - 196 * (t10106 + t10116) * t10107
            t10108 = 4 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5) * ((t10121 + t10122) * np.exp((-4*1j) * (t10108 - 3 * phi2)) + (-t10121 + t10122) * np.exp((-4*1j) * (t10108 + 3 * phi2))) * np.sqrt(0.4495e4)

        if Bindx == 455:
            t10125 = np.cos(phi)
            t10133 = -8 * t10125
            t10126 = t10125 ** 2
            t10128 = t10126 ** 2
            t10127 = t10125 * t10126
            tfunc[..., c] = (0.99e2 / 0.8192e4*1j) * t10125 * (28 * t10126 + t10133 + 1 + (-56 * t10125 + 70 + t10128) * t10128 + (-56 + (t10133 + 28) * t10127) * t10127) * ((1 + t10125) ** (0.15e2 / 0.2e1)) * np.sqrt(0.33393355e8) * np.exp((-15*1j) * phi1) * ((1 - t10125) ** (-0.1e1 / 0.2e1))

        if Bindx == 456:
            t10147 = np.cos(phi)
            t10146 = t10147 ** 2
            t10149 = t10147 * t10146
            t10152 = t10149 ** 2
            t10159 = 8 * t10152 ** 2
            t10150 = t10146 ** 2
            t10151 = t10147 * t10150
            t10156 = t10151 ** 2
            t10154 = t10150 ** 2
            t10148 = 5 * phi1
            t10141 = t10147 * t10152
            t10139 = t10147 * t10154
            t10137 = t10147 * t10156
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * ((1 + t10147) ** (0.9e1 / 0.2e1)) * np.sqrt(0.4032015e7) * ((1 - t10147) ** (-0.1e1 / 0.2e1)) * ((t10159 - 85 * t10137 + 407 * t10156 - 1155 * t10139 + 2145 * t10154 - 2706 * t10141 + 2310 * t10152 - 1254 * t10151 + 330 * t10150 + 55 * t10149 - 77 * t10146 + 25 * t10147 - 3) * np.exp((-3*1j) * (t10148 - 2 * phi2)) + (t10159 + 5 * t10137 - 43 * t10156 - 25 * t10139 + 95 * t10154 + 50 * t10141 - 110 * t10152 - 50 * t10151 + 70 * t10150 + 25 * t10149 - 23 * t10146 - 5 * t10147 + 3) * np.exp((-3*1j) * (t10148 + 2 * phi2)))

        if Bindx == 457:
            t10176 = np.cos(phi)
            t10175 = t10176 ** 2
            t10178 = t10176 * t10175
            t10181 = t10178 ** 2
            t10182 = t10176 * t10181
            t10189 = t10182 ** 2
            t10191 = 4 * t10176 * t10189
            t10187 = t10181 ** 2
            t10179 = t10175 ** 2
            t10180 = t10176 * t10179
            t10185 = t10180 ** 2
            t10183 = t10179 ** 2
            t10177 = 5 * phi1
            t10168 = t10176 * t10183
            t10166 = t10176 * t10185
            t10164 = t10176 * t10187
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * ((1 + t10176) ** (0.3e1 / 0.2e1)) * np.sqrt(0.4495e4) * ((1 - t10176) ** (-0.1e1 / 0.2e1)) * ((t10191 - 53 * t10189 + 322 * t10164 - 1183 * t10187 + 2912 * t10166 - 5005 * t10185 + 6006 * t10168 - 4719 * t10183 + 1716 * t10182 + 1001 * t10181 - 2002 * t10180 + 1547 * t10179 - 728 * t10178 + 217 * t10175 - 38 * t10176 + 3) * np.exp((-3*1j) * (t10177 - 4 * phi2)) + (t10191 + 37 * t10189 + 142 * t10164 + 271 * t10187 + 184 * t10166 - 275 * t10185 - 726 * t10168 - 561 * t10183 + 132 * t10182 + 583 * t10181 + 418 * t10180 + 37 * t10179 - 128 * t10178 - 89 * t10175 - 26 * t10176 - 3) * np.exp((-3*1j) * (t10177 + 4 * phi2)))

        if Bindx == 458:
            t10198 = np.sin(phi)
            t10193 = t10198 ** 2
            t10194 = t10198 * t10193
            t10196 = t10198 * t10194 ** 2
            t10192 = np.cos(phi)
            tfunc[..., c] = -(0.99e2 / 0.16384e5) * np.exp((-14*1j) * phi1) * np.sqrt(0.2154410e7) * t10196 ** 2 * (31 * t10192 ** 2 - 1)

        if Bindx == 459:
            t10216 = np.cos(phi)
            t10215 = t10216 ** 2
            t10218 = t10216 * t10215
            t10219 = t10215 ** 2
            t10220 = t10216 * t10219
            t10221 = t10218 ** 2
            t10222 = t10216 * t10221
            t10223 = t10219 ** 2
            t10225 = t10220 ** 2
            t10227 = t10221 ** 2
            t10229 = t10222 ** 2
            t10233 = 335 * t10218 - 2599 * t10220 + 6215 * t10222 + (-5885 * t10223 + 1141 * t10225 + 1435 * t10227 - 651 * t10229 + 9) * t10216
            t10232 = -280 * t10215 + 1190 * t10219 - 924 * t10221 + 6336 * t10225 - 4310 * t10227 + 820 * t10229 + 14 + (-2970 + 124 * t10223) * t10223
            t10217 = 7 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.2e1) * np.sqrt(0.130065e6) * ((t10232 + t10233) * np.exp((-2*1j) * (t10217 - 3 * phi2)) + (t10232 - t10233) * np.exp((-2*1j) * (t10217 + 3 * phi2)))

        if Bindx == 460:
            t10251 = np.cos(phi)
            t10250 = t10251 ** 2
            t10253 = t10251 * t10250
            t10254 = t10250 ** 2
            t10255 = t10251 * t10254
            t10256 = t10253 ** 2
            t10257 = t10251 * t10256
            t10258 = t10254 ** 2
            t10260 = t10255 ** 2
            t10262 = t10256 ** 2
            t10264 = t10257 ** 2
            t10268 = 1771 * t10253 - 7553 * t10255 - 4433 * t10257 + (20449 * t10258 - 2639 * t10260 - 7259 * t10262 - 651 * t10264 + 315) * t10251
            t10267 = -1156 * t10250 + 728 * t10254 + 12012 * t10256 - 12012 * t10260 + 9464 * t10262 + 2948 * t10264 - 34 + (-12012 + 62 * t10258) * t10258
            t10252 = 7 * phi1
            tfunc[..., c] = (0.33e2 / 0.16384e5) * ((t10267 + t10268) * np.exp((-2*1j) * (t10252 - 6 * phi2)) + (t10267 - t10268) * np.exp((-2*1j) * (t10252 + 6 * phi2))) * np.sqrt(0.145e3)

        if Bindx == 461:
            t10269 = np.cos(phi)
            tfunc[..., c] = (-0.495e3 / 0.8192e4*1j) * (31 * t10269 ** 2 - 3) * t10269 * ((1 + t10269) ** (0.13e2 / 0.2e1)) * np.sqrt(0.215441e6) * np.exp((-13*1j) * phi1) * ((1 - t10269) ** (0.13e2 / 0.2e1))

        if Bindx == 462:
            t10284 = np.cos(phi)
            t10283 = t10284 ** 2
            t10286 = t10284 * t10283
            t10289 = t10286 ** 2
            t10295 = t10289 ** 2
            t10297 = 248 * t10284 * t10295
            t10287 = t10283 ** 2
            t10288 = t10284 * t10287
            t10293 = t10288 ** 2
            t10291 = t10287 ** 2
            t10285 = 13 * phi1
            t10278 = t10284 * t10289
            t10276 = t10284 * t10291
            t10274 = t10284 * t10293
            tfunc[..., c] = (0.165e3 / 0.32768e5*1j) * ((1 + t10284) ** (0.7e1 / 0.2e1)) * np.sqrt(0.26013e5) * ((1 - t10284) ** (-0.1e1 / 0.2e1)) * ((t10297 - 2201 * t10295 + 8454 * t10274 - 18040 * t10293 + 22330 * t10276 - 13761 * t10291 - 1188 * t10278 + 8712 * t10289 - 5940 * t10288 + 1045 * t10287 + 638 * t10286 - 336 * t10283 + 34 * t10284 + 5) * np.exp((-1*1j) * (t10285 - 6 * phi2)) + (t10297 + 217 * t10295 - 1218 * t10274 - 984 * t10293 + 2466 * t10276 + 1761 * t10291 - 2644 * t10278 - 1544 * t10289 + 1596 * t10288 + 651 * t10287 - 522 * t10286 - 96 * t10283 + 74 * t10284 - 5) * np.exp((-1*1j) * (t10285 + 6 * phi2)))

        if Bindx == 463:
            t10315 = np.cos(phi)
            t10314 = t10315 ** 2
            t10318 = t10314 ** 2
            t10322 = t10318 ** 2
            t10331 = 620 * t10322 ** 2
            t10317 = t10315 * t10314
            t10320 = t10317 ** 2
            t10321 = t10315 * t10320
            t10328 = t10321 ** 2
            t10326 = t10320 ** 2
            t10319 = t10315 * t10318
            t10324 = t10319 ** 2
            t10316 = 13 * phi1
            t10307 = t10315 * t10322
            t10305 = t10315 * t10324
            t10303 = t10315 * t10326
            t10301 = t10315 * t10328
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt((1 + t10315)) * np.sqrt(0.29e2) * ((1 - t10315) ** (-0.1e1 / 0.2e1)) * ((t10331 - 6665 * t10301 + 31245 * t10328 - 81529 * t10303 + 120757 * t10326 - 73437 * t10305 - 71071 * t10324 + 189475 * t10307 - 155727 * t10322 + 15301 * t10321 + 79079 * t10320 - 68523 * t10319 + 18655 * t10318 + 6881 * t10317 - 6933 * t10314 + 2113 * t10315 - 241) * np.exp((-1*1j) * (t10316 - 12 * phi2)) + (t10331 + 5425 * t10301 + 19155 * t10328 + 31129 * t10303 + 8099 * t10326 - 55419 * t10305 - 89089 * t10324 - 29315 * t10307 + 63063 * t10322 + 77363 * t10321 + 17017 * t10320 - 27573 * t10319 - 22295 * t10318 - 3241 * t10317 + 3189 * t10314 + 1631 * t10315 + 241) * np.exp((-1*1j) * (t10316 + 12 * phi2)))

        if Bindx == 464:
            t10339 = np.sin(phi)
            t10335 = t10339 ** 2
            t10336 = t10339 * t10335
            t10337 = t10336 ** 2
            t10332 = np.cos(phi)
            t10333 = t10332 ** 2
            tfunc[..., c] = (0.495e3 / 0.16384e5) * np.exp((-12*1j) * phi1) * np.sqrt(0.7429e4) * t10337 ** 2 * (3 + (-174 + 899 * t10333) * t10333)

        if Bindx == 465:
            t10357 = np.cos(phi)
            t10356 = t10357 ** 2
            t10359 = t10357 * t10356
            t10360 = t10356 ** 2
            t10361 = t10357 * t10360
            t10362 = t10359 ** 2
            t10363 = t10357 * t10362
            t10364 = t10360 ** 2
            t10366 = t10361 ** 2
            t10368 = t10362 ** 2
            t10370 = t10363 ** 2
            t10374 = 2859 * t10359 - 15009 * t10361 + 32351 * t10363 + (-24783 * t10364 - 8751 * t10366 + 21605 * t10368 - 8091 * t10370 - 181) * t10357
            t10373 = -276 * t10356 - 104 * t10360 + 11484 * t10362 + 63844 * t10366 - 40200 * t10368 + 6612 * t10370 + 6 + (-43164 + 1798 * t10364) * t10364
            t10358 = 2 * phi1
            tfunc[..., c] = (0.165e3 / 0.16384e5) * ((t10373 + t10374) * np.exp((-6*1j) * (t10358 - phi2)) + (t10373 - t10374) * np.exp((-6*1j) * (t10358 + phi2))) * np.sqrt(0.897e3)

        if Bindx == 466:
            t10392 = np.cos(phi)
            t10391 = t10392 ** 2
            t10393 = t10392 * t10391
            t10394 = t10391 ** 2
            t10395 = t10392 * t10394
            t10396 = t10393 ** 2
            t10397 = t10392 * t10396
            t10398 = t10394 ** 2
            t10400 = t10395 ** 2
            t10402 = t10396 ** 2
            t10404 = t10397 ** 2
            t10408 = 35259 * t10393 + 98553 * t10395 - 512941 * t10397 + (383955 * t10398 + 308217 * t10400 - 269381 * t10402 - 40455 * t10404 - 7303) * t10392
            t10407 = 9528 * t10391 - 129220 * t10394 + 216216 * t10396 - 664664 * t10400 + 151788 * t10402 + 149640 * t10404 + 1191 + (265122 + 4495 * t10398) * t10398
            tfunc[..., c] = (0.33e2 / 0.16384e5) * np.sqrt(0.2e1) * ((t10407 + t10408) * np.exp((-12*1j) * (phi1 - phi2)) + (t10407 - t10408) * np.exp((-12*1j) * (phi1 + phi2)))

        if Bindx == 467:
            t10409 = np.cos(phi)
            t10410 = t10409 ** 2
            tfunc[..., c] = (0.99e2 / 0.8192e4*1j) * (15 + (-290 + 899 * t10410) * t10410) * t10409 * ((1 + t10409) ** (0.11e2 / 0.2e1)) * np.sqrt(0.260015e6) * np.exp((-11*1j) * phi1) * ((1 - t10409) ** (0.11e2 / 0.2e1))

        if Bindx == 468:
            t10427 = np.cos(phi)
            t10426 = t10427 ** 2
            t10429 = t10427 * t10426
            t10432 = t10429 ** 2
            t10433 = t10427 * t10432
            t10441 = 7192 * t10433 ** 2
            t10438 = t10432 ** 2
            t10430 = t10426 ** 2
            t10431 = t10427 * t10430
            t10436 = t10431 ** 2
            t10434 = t10430 ** 2
            t10428 = 11 * phi1
            t10419 = t10427 * t10434
            t10417 = t10427 * t10436
            t10415 = t10427 * t10438
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * ((1 + t10427) ** (0.5e1 / 0.2e1)) * np.sqrt(0.31395e5) * ((1 - t10427) ** (-0.1e1 / 0.2e1)) * ((t10441 - 51243 * t10415 + 145667 * t10438 - 190298 * t10417 + 52602 * t10436 + 164087 * t10419 - 197703 * t10434 + 42372 * t10433 + 66132 * t10432 - 45133 * t10431 + 1221 * t10430 + 6646 * t10429 - 1414 * t10426 - 159 * t10427 + 31) * np.exp((-1*1j) * (t10428 - 6 * phi2)) + (t10441 + 8091 * t10415 - 32335 * t10438 - 34626 * t10417 + 60258 * t10436 + 58773 * t10419 - 60401 * t10434 - 49500 * t10433 + 35156 * t10432 + 20757 * t10431 - 11649 * t10430 - 3522 * t10429 + 1810 * t10426 + 27 * t10427 - 31) * np.exp((-1*1j) * (t10428 + 6 * phi2)))

        if Bindx == 469:
            t10460 = np.cos(phi)
            t10459 = t10460 ** 2
            t10462 = t10460 * t10459
            t10463 = t10459 ** 2
            t10464 = t10460 * t10463
            t10465 = t10462 ** 2
            t10466 = t10460 * t10465
            t10467 = t10463 ** 2
            t10469 = t10464 ** 2
            t10471 = t10465 ** 2
            t10473 = t10466 ** 2
            t10475 = t10467 ** 2
            t10478 = 30668 * t10462 - 62348 * t10464 - 125268 * t10466 + (473044 * t10467 - 364156 * t10469 - 48132 * t10471 + 95236 * t10473 + 3596 * t10475 - 2640) * t10460
            t10477 = 2468 * t10459 + 43272 * t10463 - 224588 * t10465 + 286286 * t10467 + 94380 * t10469 - 354640 * t10471 + 123772 * t10473 + 29667 * t10475 - 617
            t10461 = 11 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt(0.35e2) * ((1 + t10460) ** (-0.1e1 / 0.2e1)) * ((1 - t10460) ** (-0.1e1 / 0.2e1)) * ((-t10477 + t10478) * np.exp((-1*1j) * (t10461 - 12 * phi2)) + (t10477 + t10478) * np.exp((-1*1j) * (t10461 + 12 * phi2)))

        if Bindx == 470:
            t10487 = np.sin(phi)
            t10483 = t10487 ** 2
            t10485 = t10487 * t10483 ** 2
            t10479 = np.cos(phi)
            t10480 = t10479 ** 2
            t10481 = t10480 ** 2
            tfunc[..., c] = -(0.33e2 / 0.16384e5) * np.exp((-10*1j) * phi1) * np.sqrt(0.520030e6) * t10485 ** 2 * (-3915 * t10481 - 5 + (8091 * t10481 + 405) * t10480)

        if Bindx == 471:
            t10505 = np.cos(phi)
            t10504 = t10505 ** 2
            t10507 = t10505 * t10504
            t10508 = t10504 ** 2
            t10509 = t10505 * t10508
            t10510 = t10507 ** 2
            t10511 = t10505 * t10510
            t10512 = t10508 ** 2
            t10514 = t10509 ** 2
            t10516 = t10510 ** 2
            t10518 = t10511 ** 2
            t10522 = -4075 * t10507 + 20963 * t10509 - 32659 * t10511 + (-25311 * t10512 + 124407 * t10514 - 123975 * t10516 + 40455 * t10518 + 195) * t10505
            t10521 = 952 * t10504 - 12422 * t10508 + 67804 * t10510 + 232672 * t10514 - 134346 * t10516 + 12876 * t10518 - 14 + (-178310 + 10788 * t10512) * t10512
            t10506 = 5 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.2e1) * np.sqrt(0.31395e5) * ((t10521 - t10522) * np.exp((-2*1j) * (t10506 - 3 * phi2)) + (t10521 + t10522) * np.exp((-2*1j) * (t10506 + 3 * phi2)))

        if Bindx == 472:
            t10540 = np.cos(phi)
            t10539 = t10540 ** 2
            t10542 = t10540 * t10539
            t10543 = t10539 ** 2
            t10544 = t10540 * t10543
            t10545 = t10542 ** 2
            t10546 = t10540 * t10545
            t10547 = t10543 ** 2
            t10549 = t10544 ** 2
            t10551 = t10545 ** 2
            t10553 = t10546 ** 2
            t10557 = 9091 * t10542 - 40937 * t10544 + 40183 * t10546 + (67353 * t10547 - 127335 * t10549 + 38541 * t10551 + 13485 * t10553 - 381) * t10540
            t10556 = 2604 * t10539 - 936 * t10543 - 49764 * t10545 - 87516 * t10549 - 36296 * t10551 + 38164 * t10553 - 186 + (132132 + 1798 * t10547) * t10547
            t10541 = 5 * phi1
            tfunc[..., c] = (0.99e2 / 0.16384e5) * ((t10556 - t10557) * np.exp((-2*1j) * (t10541 - 6 * phi2)) + (t10556 + t10557) * np.exp((-2*1j) * (t10541 + 6 * phi2))) * np.sqrt(0.35e2)

        if Bindx == 473:
            t10558 = np.cos(phi)
            t10559 = t10558 ** 2
            t10560 = t10559 ** 2
            tfunc[..., c] = (-0.33e2 / 0.8192e4*1j) * (-5481 * t10560 - 35 + (8091 * t10560 + 945) * t10559) * t10558 * ((1 + t10558) ** (0.9e1 / 0.2e1)) * np.sqrt(0.482885e6) * np.exp((-9*1j) * phi1) * ((1 - t10558) ** (0.9e1 / 0.2e1))

        if Bindx == 474:
            t10578 = np.cos(phi)
            t10577 = t10578 ** 2
            t10580 = t10578 * t10577
            t10583 = t10580 ** 2
            t10584 = t10578 * t10583
            t10591 = t10584 ** 2
            t10593 = 280488 * t10578 * t10591
            t10589 = t10583 ** 2
            t10581 = t10577 ** 2
            t10582 = t10578 * t10581
            t10587 = t10582 ** 2
            t10585 = t10581 ** 2
            t10579 = 3 * phi1
            t10570 = t10578 * t10585
            t10568 = t10578 * t10587
            t10566 = t10578 * t10589
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * ((1 + t10578) ** (0.3e1 / 0.2e1)) * np.sqrt(0.345e3) * ((1 - t10578) ** (-0.1e1 / 0.2e1)) * ((2628444 * t10566 - 4592952 * t10568 + 1373372 * t10570 - 1897 * t10577 - 3436 * t10578 + 92792 * t10580 - 100429 * t10581 - 598444 * t10582 + 1161083 * t10583 + 983576 * t10584 - 3870691 * t10585 + 4369365 * t10587 - 213759 * t10589 - 1507623 * t10591 + 111 + t10593) * np.exp((-3*1j) * (t10579 - 2 * phi2)) + (-1158144 * t10566 + 1975896 * t10568 - 1823536 * t10570 + 14753 * t10577 - 2992 * t10578 + 59048 * t10580 - 216107 * t10581 - 333344 * t10582 + 1019029 * t10583 + 1002584 * t10584 - 2281741 * t10585 + 2683395 * t10587 - 1604889 * t10589 + 385671 * t10591 - 111 + t10593) * np.exp((-3*1j) * (t10579 + 2 * phi2)))

        if Bindx == 475:
            t10612 = np.cos(phi)
            t10611 = t10612 ** 2
            t10615 = t10611 ** 2
            t10614 = t10612 * t10611
            t10617 = t10614 ** 2
            t10619 = t10615 ** 2
            t10616 = t10612 * t10615
            t10621 = t10616 ** 2
            t10623 = t10617 ** 2
            t10618 = t10612 * t10617
            t10625 = t10618 ** 2
            t10627 = t10619 ** 2
            t10630 = -4824 * t10611 + 25700 * t10615 - 22936 * t10617 - 116050 * t10619 + 286968 * t10621 - 210732 * t10623 + 17400 * t10625 + 24273 * t10627 + 201
            t10629 = -5700 * t10614 + 59748 * t10616 - 179652 * t10618 + (188100 * t10619 + 16404 * t10621 - 138100 * t10623 + 55796 * t10625 + 3596 * t10627 - 192) * t10612
            t10613 = 3 * phi1
            tfunc[..., c] = (0.99e2 / 0.32768e5*1j) * np.sqrt(0.65e2) * np.sqrt(0.2e1) * ((1 + t10612) ** (-0.1e1 / 0.2e1)) * ((1 - t10612) ** (-0.1e1 / 0.2e1)) * ((t10629 - t10630) * np.exp((-3*1j) * (t10613 - 4 * phi2)) + (t10629 + t10630) * np.exp((-3*1j) * (t10613 + 4 * phi2)))

        if Bindx == 476:
            t10639 = np.sin(phi)
            t10636 = t10639 ** 2
            t10637 = t10636 ** 2
            t10631 = np.cos(phi)
            t10632 = t10631 ** 2
            t10633 = t10632 ** 2
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.exp((-8*1j) * phi1) * np.sqrt(0.965770e6) * t10637 ** 2 * (-700 * t10632 + 7 + (-36540 * t10632 + 9450 + 40455 * t10633) * t10633)

        if Bindx == 477:
            t10657 = np.cos(phi)
            t10656 = t10657 ** 2
            t10659 = t10657 * t10656
            t10660 = t10656 ** 2
            t10661 = t10657 * t10660
            t10662 = t10659 ** 2
            t10663 = t10657 * t10662
            t10664 = t10660 ** 2
            t10666 = t10661 ** 2
            t10668 = t10662 ** 2
            t10670 = t10663 ** 2
            t10674 = -2317 * t10659 + 58247 * t10661 - 448657 * t10663 + (1467345 * t10664 - 2330055 * t10666 + 1781325 * t10668 - 525915 * t10670 + 27) * t10657
            t10673 = 8342 * t10656 - 115990 * t10660 + 607838 * t10662 + 1811810 * t10666 - 832650 * t10668 - 147030 * t10670 - 97 + (-1507528 + 175305 * t10664) * t10664
            t10658 = 4 * phi1
            tfunc[..., c] = (0.33e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.345e3) * ((t10673 + t10674) * np.exp((-2*1j) * (t10658 - 3 * phi2)) + (t10673 - t10674) * np.exp((-2*1j) * (t10658 + 3 * phi2)))

        if Bindx == 478:
            t10692 = np.cos(phi)
            t10691 = t10692 ** 2
            t10695 = t10691 ** 2
            t10694 = t10692 * t10691
            t10697 = t10694 ** 2
            t10699 = t10695 ** 2
            t10696 = t10692 * t10695
            t10701 = t10696 ** 2
            t10703 = t10697 ** 2
            t10698 = t10692 * t10697
            t10705 = t10698 ** 2
            t10709 = -3552 * t10691 + 29940 * t10695 - 85536 * t10697 + 85536 * t10701 - 146252 * t10703 + 51040 * t10705 + 111 + (64218 + 4495 * t10699) * t10699
            t10708 = 3454 * t10694 + 17002 * t10696 - 121154 * t10698 + (228030 * t10699 - 146838 * t10701 - 6786 * t10703 + 26970 * t10705 - 678) * t10692
            t10693 = 2 * phi1
            tfunc[..., c] = (0.99e2 / 0.16384e5) * ((-t10708 + t10709) * np.exp((-4*1j) * (t10693 - 3 * phi2)) + (t10708 + t10709) * np.exp((-4*1j) * (t10693 + 3 * phi2))) * np.sqrt(0.65e2)

        if Bindx == 479:
            t10710 = np.cos(phi)
            t10711 = t10710 ** 2
            t10712 = t10711 ** 2
            tfunc[..., c] = (0.33e2 / 0.8192e4*1j) * (-700 * t10711 + 21 + (-15660 * t10711 + 5670 + 13485 * t10712) * t10712) * t10710 * ((1 + t10710) ** (0.7e1 / 0.2e1)) * np.sqrt(0.1448655e7) * np.exp((-7*1j) * phi1) * ((1 - t10710) ** (0.7e1 / 0.2e1))

        if Bindx == 480:
            t10732 = np.cos(phi)
            t10731 = t10732 ** 2
            t10735 = t10731 ** 2
            t10739 = t10735 ** 2
            t10748 = 1402440 * t10739 ** 2
            t10734 = t10732 * t10731
            t10737 = t10734 ** 2
            t10738 = t10732 * t10737
            t10745 = t10738 ** 2
            t10743 = t10737 ** 2
            t10736 = t10732 * t10735
            t10741 = t10736 ** 2
            t10733 = 7 * phi1
            t10724 = t10732 * t10739
            t10722 = t10732 * t10741
            t10720 = t10732 * t10743
            t10718 = t10732 * t10745
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt((1 + t10732)) * np.sqrt(0.115e3) * ((1 - t10732) ** (-0.1e1 / 0.2e1)) * ((-5083845 * t10718 + 12785955 * t10720 - 10053225 * t10722 + 887535 * t10724 + 24645 * t10731 - 5563 * t10732 + 153181 * t10734 - 490735 * t10735 - 1072407 * t10736 + 3587353 * t10737 + 2371985 * t10738 - 12032361 * t10739 + 19594575 * t10741 - 14088165 * t10743 + 2018835 * t10745 - 203 + t10748) * np.exp((-1*1j) * (t10733 - 6 * phi2)) + (2278965 * t10718 - 9460815 * t10720 + 15982785 * t10722 - 14040675 * t10724 - 13113 * t10731 - 5969 * t10732 + 190939 * t10734 + 146615 * t10735 - 1709757 * t10736 - 805189 * t10737 + 6764527 * t10738 + 2895849 * t10739 - 6441435 * t10741 + 8158605 * t10743 - 5343975 * t10745 + 203 + t10748) * np.exp((-1*1j) * (t10733 + 6 * phi2)))

        if Bindx == 481:
            t10767 = np.cos(phi)
            t10766 = t10767 ** 2
            t10770 = t10766 ** 2
            t10769 = t10767 * t10766
            t10772 = t10769 ** 2
            t10774 = t10770 ** 2
            t10771 = t10767 * t10770
            t10776 = t10771 ** 2
            t10778 = t10772 ** 2
            t10773 = t10767 * t10772
            t10780 = t10773 ** 2
            t10782 = t10774 ** 2
            t10785 = -4360 * t10766 + 67716 * t10770 - 349256 * t10772 + 773366 * t10774 - 744216 * t10776 + 157780 * t10778 + 193256 * t10780 - 94395 * t10782 + 109
            t10784 = -32788 * t10769 + 111412 * t10771 - 42900 * t10773 + (-427372 * t10774 + 842788 * t10776 - 593028 * t10778 + 121220 * t10780 + 17980 * t10782 + 2688) * t10767
            t10768 = 7 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.195e3) * np.sqrt(0.2e1) * ((1 + t10767) ** (-0.1e1 / 0.2e1)) * ((1 - t10767) ** (-0.1e1 / 0.2e1)) * ((t10784 + t10785) * np.exp((-1*1j) * (t10768 - 12 * phi2)) + (t10784 - t10785) * np.exp((-1*1j) * (t10768 + 12 * phi2)))

        if Bindx == 482:
            t10795 = np.sin(phi)
            t10792 = t10795 ** 2
            t10793 = t10795 * t10792
            t10786 = np.cos(phi)
            t10787 = t10786 ** 2
            t10788 = t10787 ** 2
            t10790 = t10788 ** 2
            tfunc[..., c] = -(0.33e2 / 0.16384e5) * np.exp((-6*1j) * phi1) * np.sqrt(0.25194e5) * t10793 ** 2 * (-40250 * t10788 - 450225 * t10790 - 21 + (217350 * t10788 + 310155 * t10790 + 2415) * t10787)

        if Bindx == 483:
            t10813 = np.cos(phi)
            t10812 = t10813 ** 2
            t10814 = t10813 * t10812
            t10815 = t10812 ** 2
            t10816 = t10813 * t10815
            t10817 = t10814 ** 2
            t10818 = t10813 * t10817
            t10819 = t10815 ** 2
            t10821 = t10816 ** 2
            t10823 = t10817 ** 2
            t10825 = t10818 ** 2
            t10829 = -1247925 * t10814 + 12674109 * t10816 - 58935085 * t10818 + (144532575 * t10819 - 192796695 * t10821 + 132015975 * t10823 - 36288135 * t10825 + 36989) * t10813
            t10828 = 227400 * t10812 - 3468010 * t10815 + 18442116 * t10817 + 33153120 * t10821 + 16011450 * t10823 - 39019500 * t10825 - 2274 + (-41464170 + 16128060 * t10819) * t10819
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.2e1) * ((t10828 + t10829) * np.exp((-6*1j) * (phi1 - phi2)) + (t10828 - t10829) * np.exp((-6*1j) * (phi1 + phi2)))

        if Bindx == 484:
            t10847 = np.cos(phi)
            t10846 = t10847 ** 2
            t10848 = t10847 * t10846
            t10849 = t10846 ** 2
            t10850 = t10847 * t10849
            t10851 = t10848 ** 2
            t10852 = t10847 * t10851
            t10853 = t10849 ** 2
            t10855 = t10850 ** 2
            t10857 = t10851 ** 2
            t10859 = t10852 ** 2
            t10863 = 2859 * t10848 - 15009 * t10850 + 32351 * t10852 + (-24783 * t10853 - 8751 * t10855 + 21605 * t10857 - 8091 * t10859 - 181) * t10847
            t10862 = -276 * t10846 - 104 * t10849 + 11484 * t10851 + 63844 * t10855 - 40200 * t10857 + 6612 * t10859 + 6 + (-43164 + 1798 * t10853) * t10853
            tfunc[..., c] = (0.165e3 / 0.16384e5) * ((t10862 + t10863) * np.exp((-6*1j) * (phi1 - 2 * phi2)) + (t10862 - t10863) * np.exp((-6*1j) * (phi1 + 2 * phi2))) * np.sqrt(0.897e3)

        if Bindx == 485:
            t10864 = np.cos(phi)
            t10865 = t10864 ** 2
            t10866 = t10865 ** 2
            t10868 = t10866 ** 2
            tfunc[..., c] = (-0.33e2 / 0.8192e4*1j) * (-88550 * t10866 - 550275 * t10868 - 231 + (341550 * t10866 + 310155 * t10868 + 8855) * t10865) * t10864 * ((1 + t10864) ** (0.5e1 / 0.2e1)) * np.sqrt(0.12597e5) * np.exp((-5*1j) * phi1) * ((1 - t10864) ** (0.5e1 / 0.2e1))

        if Bindx == 486:
            t10888 = np.cos(phi)
            t10887 = t10888 ** 2
            t10891 = t10887 ** 2
            t10890 = t10888 * t10887
            t10893 = t10890 ** 2
            t10895 = t10891 ** 2
            t10892 = t10888 * t10891
            t10897 = t10892 ** 2
            t10899 = t10893 ** 2
            t10894 = t10888 * t10893
            t10901 = t10894 ** 2
            t10903 = t10895 ** 2
            t10906 = 487918 * t10887 - 8673630 * t10891 + 60237590 * t10893 - 210521300 * t10895 + 407970090 * t10897 - 445243890 * t10899 + 256228050 * t10901 - 60480225 * t10903 - 4603
            t10905 = 745790 * t10890 - 6298922 * t10892 + 18128022 * t10894 + (-4075830 * t10895 - 74406150 * t10897 + 147870450 * t10899 - 114197070 * t10901 + 32256120 * t10903 - 22410) * t10888
            t10889 = 5 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * ((1 + t10888) ** (-0.1e1 / 0.2e1)) * ((1 - t10888) ** (-0.1e1 / 0.2e1)) * ((t10905 + t10906) * np.exp((-1*1j) * (t10889 - 6 * phi2)) + (t10905 - t10906) * np.exp((-1*1j) * (t10889 + 6 * phi2)))

        if Bindx == 487:
            t10925 = np.cos(phi)
            t10924 = t10925 ** 2
            t10928 = t10924 ** 2
            t10927 = t10925 * t10924
            t10930 = t10927 ** 2
            t10932 = t10928 ** 2
            t10929 = t10925 * t10928
            t10934 = t10929 ** 2
            t10936 = t10930 ** 2
            t10931 = t10925 * t10930
            t10938 = t10931 ** 2
            t10940 = t10932 ** 2
            t10943 = 23 - 1196 * t10924 + 9048 * t10928 - 23068 * t10930 + 11422 * t10932 + 44604 * t10934 - 82912 * t10936 + 55564 * t10938 - 13485 * t10940
            t10942 = 2956 * t10927 - 22732 * t10929 + 79212 * t10931 + (-140012 * t10932 + 127172 * t10934 - 50628 * t10936 + 580 * t10938 + 3596 * t10940 - 144) * t10925
            t10926 = 5 * phi1
            tfunc[..., c] = (0.165e3 / 0.32768e5*1j) * np.sqrt(0.897e3) * np.sqrt(0.2e1) * ((1 + t10925) ** (-0.1e1 / 0.2e1)) * ((1 - t10925) ** (-0.1e1 / 0.2e1)) * ((t10942 + t10943) * np.exp((-1*1j) * (t10926 - 12 * phi2)) + (t10942 - t10943) * np.exp((-1*1j) * (t10926 + 12 * phi2)))

        if Bindx == 488:
            t10953 = np.sin(phi)
            t10951 = t10953 ** 2
            t10944 = np.cos(phi)
            t10945 = t10944 ** 2
            t10946 = t10945 ** 2
            t10948 = t10946 ** 2
            t10947 = t10945 * t10946
            tfunc[..., c] = (0.33e2 / 0.16384e5) * np.exp((-4*1j) * phi1) * np.sqrt(0.88179e5) * t10951 ** 2 * (26565 * t10946 + 512325 * t10948 + 11 + (-177100 + 310155 * t10947) * t10947 + (-660330 * t10948 - 1386) * t10945)

        if Bindx == 489:
            t10971 = np.cos(phi)
            t10970 = t10971 ** 2
            t10973 = t10971 * t10970
            t10974 = t10970 ** 2
            t10975 = t10971 * t10974
            t10976 = t10973 ** 2
            t10977 = t10971 * t10976
            t10978 = t10974 ** 2
            t10980 = t10975 ** 2
            t10982 = t10976 ** 2
            t10984 = t10977 ** 2
            t10988 = -487715 * t10973 + 5090953 * t10975 - 23424695 * t10977 + (55508775 * t10978 - 70777785 * t10980 + 46173075 * t10982 - 12096045 * t10984 + 13437) * t10971
            t10987 = -6820 * t10970 + 175640 * t10974 - 1941492 * t10976 - 27968460 * t10980 + 40006200 * t10982 - 28614300 * t10984 + 62 + (10285140 + 8064030 * t10978) * t10978
            t10972 = 2 * phi1
            tfunc[..., c] = (0.33e2 / 0.16384e5) * ((t10987 + t10988) * np.exp((-2*1j) * (t10972 - 3 * phi2)) + (t10987 - t10988) * np.exp((-2*1j) * (t10972 + 3 * phi2))) * np.sqrt(0.7e1)

        if Bindx == 490:
            t11006 = np.cos(phi)
            t11005 = t11006 ** 2
            t11007 = t11006 * t11005
            t11008 = t11005 ** 2
            t11009 = t11006 * t11008
            t11010 = t11007 ** 2
            t11011 = t11006 * t11010
            t11012 = t11008 ** 2
            t11014 = t11009 ** 2
            t11016 = t11010 ** 2
            t11018 = t11011 ** 2
            t11022 = 85 * t11007 + 823 * t11009 - 6659 * t11011 + (17021 * t11012 - 20425 * t11014 + 11861 * t11016 - 2697 * t11018 - 9) * t11006
            t11021 = 280 * t11005 - 2612 * t11008 + 9720 * t11010 + 14664 * t11014 - 4036 * t11016 - 1624 * t11018 - 5 + (-17286 + 899 * t11012) * t11012
            tfunc[..., c] = (0.165e3 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.6279e4) * ((t11021 + t11022) * np.exp((-4*1j) * (phi1 - 3 * phi2)) + (t11021 - t11022) * np.exp((-4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 491:
            t11023 = np.cos(phi)
            t11024 = t11023 ** 2
            t11025 = t11024 ** 2
            t11027 = t11025 ** 2
            t11026 = t11024 * t11025
            tfunc[..., c] = (0.33e2 / 0.8192e4*1j) * (69069 * t11025 + 740025 * t11027 + 143 + (-328900 + 310155 * t11026) * t11026 + (-780390 * t11027 - 6006) * t11024) * t11023 * ((1 + t11023) ** (0.3e1 / 0.2e1)) * np.sqrt(0.33915e5) * np.exp((-3*1j) * phi1) * ((1 - t11023) ** (0.3e1 / 0.2e1))

        if Bindx == 492:
            t11048 = np.cos(phi)
            t11047 = t11048 ** 2
            t11050 = t11047 ** 2
            t11049 = t11048 * t11047
            t11052 = t11049 ** 2
            t11054 = t11050 ** 2
            t11051 = t11048 * t11050
            t11056 = t11051 ** 2
            t11058 = t11052 ** 2
            t11053 = t11048 * t11052
            t11060 = t11053 ** 2
            t11062 = t11054 ** 2
            t11065 = 22914 * t11047 - 427922 * t11050 + 3048346 * t11052 - 10700612 * t11054 + 20497830 * t11056 - 21875070 * t11058 + 12226110 * t11060 - 2791395 * t11062 - 201
            t11064 = -56458 * t11049 + 670766 * t11051 - 3726834 * t11053 + (11325522 * t11054 - 19943070 * t11056 + 20272890 * t11058 - 11025510 * t11060 + 2481240 * t11062 + 1454) * t11048
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.455e3) * ((1 + t11048) ** (-0.1e1 / 0.2e1)) * ((1 - t11048) ** (-0.1e1 / 0.2e1)) * ((t11064 + t11065) * np.exp((-3*1j) * (phi1 - 2 * phi2)) + (t11064 - t11065) * np.exp((-3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 493:
            t11084 = np.cos(phi)
            t11083 = t11084 ** 2
            t11085 = t11084 * t11083
            t11086 = t11083 ** 2
            t11087 = t11084 * t11086
            t11088 = t11085 ** 2
            t11089 = t11084 * t11088
            t11090 = t11086 ** 2
            t11092 = t11087 ** 2
            t11094 = t11088 ** 2
            t11096 = t11089 ** 2
            t11098 = t11090 ** 2
            t11101 = 13148 * t11085 - 69340 * t11087 + 155580 * t11089 + (-149820 * t11090 + 8628 * t11092 + 100492 * t11094 - 75980 * t11096 + 17980 * t11098 - 688) * t11084
            t11100 = -3060 * t11083 + 34864 * t11086 - 170660 * t11088 + 433870 * t11090 - 621916 * t11092 + 509000 * t11094 - 222604 * t11096 + 40455 * t11098 + 51
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.2415e4) * np.sqrt(0.2e1) * ((1 + t11084) ** (-0.1e1 / 0.2e1)) * ((1 - t11084) ** (-0.1e1 / 0.2e1)) * ((-t11100 + t11101) * np.exp((-3*1j) * (phi1 - 4 * phi2)) + (t11100 + t11101) * np.exp((-3*1j) * (phi1 + 4 * phi2)))

        if Bindx == 494:
            t11103 = np.cos(phi)
            t11104 = t11103 ** 2
            t11105 = t11104 ** 2
            t11106 = t11104 * t11105
            t11109 = t11106 ** 2
            t11107 = t11105 ** 2
            t11102 = np.sin(phi)
            tfunc[..., c] = -(0.33e2 / 0.16384e5) * np.exp((-2*1j) * phi1) * np.sqrt(0.510e3) * t11102 ** 2 * (-399399 * t11105 + 3062059 * t11106 - 10935925 * t11107 - 17298645 * t11109 - 143 + (19684665 * t11107 + 5892945 * t11109 + 19019) * t11104)

        if Bindx == 495:
            t11128 = np.cos(phi)
            t11127 = t11128 ** 2
            t11129 = t11128 * t11127
            t11130 = t11127 ** 2
            t11131 = t11128 * t11130
            t11132 = t11129 ** 2
            t11133 = t11128 * t11132
            t11134 = t11130 ** 2
            t11136 = t11131 ** 2
            t11138 = t11132 ** 2
            t11140 = t11133 ** 2
            t11144 = -37555 * t11129 + 405419 * t11131 - 1900651 * t11133 + (4521225 * t11134 - 5710785 * t11136 + 3651825 * t11138 - 930465 * t11140 + 987) * t11128
            t11143 = -8120 * t11127 + 155134 * t11130 - 1136268 * t11132 - 8169600 * t11136 + 9042450 * t11138 - 5242620 * t11140 + 70 + (4118334 + 1240620 * t11134) * t11134
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.1235e4) * np.sqrt(0.2e1) * ((t11143 + t11144) * np.exp((-2*1j) * (phi1 - 3 * phi2)) + (t11143 - t11144) * np.exp((-2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 496:
            t11162 = np.cos(phi)
            t11161 = t11162 ** 2
            t11164 = t11161 ** 2
            t11163 = t11162 * t11161
            t11166 = t11163 ** 2
            t11168 = t11164 ** 2
            t11165 = t11162 * t11164
            t11170 = t11165 ** 2
            t11172 = t11166 ** 2
            t11167 = t11162 * t11166
            t11174 = t11167 ** 2
            t11178 = 124 * t11161 + 280 * t11164 - 12180 * t11166 - 98028 * t11170 + 94136 * t11172 - 45820 * t11174 - 2 + (52500 + 8990 * t11168) * t11168
            t11177 = -7763 * t11163 + 46585 * t11165 - 129815 * t11167 + (195335 * t11168 - 164521 * t11170 + 73283 * t11172 - 13485 * t11174 + 381) * t11162
            tfunc[..., c] = (0.33e2 / 0.16384e5) * ((t11177 + t11178) * np.exp((-2*1j) * (phi1 - 6 * phi2)) + (-t11177 + t11178) * np.exp((-2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.6555e4)

        if Bindx == 497:
            t11179 = np.cos(phi)
            t11195 = 1 - t11179
            t11180 = t11179 ** 2
            t11181 = t11179 * t11180
            t11184 = t11181 ** 2
            t11185 = t11179 * t11184
            t11182 = t11180 ** 2
            t11183 = t11179 * t11182
            tfunc[..., c] = (0.33e2 / 0.8192e4*1j) * np.exp((-1*1j) * phi1) * np.sqrt(0.17e2) * np.sqrt((1 + t11179)) * t11179 * (t11195 * (54679625 * t11182 ** 2 - 80528175 * t11183 ** 2 + 59879925 * t11184 ** 2 - 17678835 * t11185 ** 2 + 6435) - 19684665 * t11184 + 19684665 * t11185 + 3594591 * t11182 - 3594591 * t11183 - 285285 * t11180 + 285285 * t11181) * (t11195 ** (-0.1e1 / 0.2e1))

        if Bindx == 498:
            t11214 = np.cos(phi)
            t11213 = t11214 ** 2
            t11216 = t11213 ** 2
            t11215 = t11214 * t11213
            t11218 = t11215 ** 2
            t11220 = t11216 ** 2
            t11217 = t11214 * t11216
            t11222 = t11217 ** 2
            t11224 = t11218 ** 2
            t11219 = t11214 * t11218
            t11226 = t11219 ** 2
            t11228 = t11220 ** 2
            t11231 = 7434 * t11213 - 142674 * t11216 + 1036098 * t11218 - 3676320 * t11220 + 7059390 * t11222 - 7495470 * t11224 + 4142070 * t11226 - 930465 * t11228 - 63
            t11230 = -97594 * t11215 + 1131214 * t11217 - 5937858 * t11219 + (16667410 * t11220 - 26756590 * t11222 + 24655770 * t11224 - 12146070 * t11226 + 2481240 * t11228 + 2478) * t11214
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.741e3) * ((1 + t11214) ** (-0.1e1 / 0.2e1)) * ((1 - t11214) ** (-0.1e1 / 0.2e1)) * ((t11230 + t11231) * np.exp((-1*1j) * (phi1 - 6 * phi2)) + (t11230 - t11231) * np.exp((-1*1j) * (phi1 + 6 * phi2)))

        if Bindx == 499:
            t11250 = np.cos(phi)
            t11249 = t11250 ** 2
            t11252 = t11249 ** 2
            t11251 = t11250 * t11249
            t11254 = t11251 ** 2
            t11256 = t11252 ** 2
            t11253 = t11250 * t11252
            t11258 = t11253 ** 2
            t11260 = t11254 ** 2
            t11255 = t11250 * t11254
            t11262 = t11255 ** 2
            t11264 = t11256 ** 2
            t11267 = -9 + 576 * t11249 - 5964 * t11252 + 24192 * t11254 - 51030 * t11256 + 61824 * t11258 - 43596 * t11260 + 16704 * t11262 - 2697 * t11264
            t11266 = -2084 * t11251 + 14084 * t11253 - 46116 * t11255 + (85540 * t11256 - 95116 * t11258 + 63084 * t11260 - 23084 * t11262 + 3596 * t11264 + 96) * t11250
            tfunc[..., c] = (0.495e3 / 0.32768e5*1j) * np.sqrt(0.437e3) * np.sqrt(0.2e1) * ((1 + t11250) ** (-0.1e1 / 0.2e1)) * ((1 - t11250) ** (-0.1e1 / 0.2e1)) * ((t11266 + t11267) * np.exp((-1*1j) * (phi1 - 12 * phi2)) + (t11266 - t11267) * np.exp((-1*1j) * (phi1 + 12 * phi2)))

        if Bindx == 500:
            t11268 = np.cos(phi)
            t11269 = t11268 ** 2
            t11270 = t11269 ** 2
            t11271 = t11269 * t11270
            t11274 = t11271 ** 2
            t11272 = t11270 ** 2
            tfunc[..., c] = 0.15058768725e11 / 0.8192e4 * t11274 - 0.672188517e9 / 0.4096e4 * t11271 + 0.160044885e9 / 0.8192e4 * t11270 + 0.212355e6 / 0.32768e5 + (0.11043097065e11 / 0.16384e5 + 0.9917826435e10 / 0.32768e5 * t11272) * t11272 + (-0.4798948275e10 / 0.4096e4 * t11274 - 0.6135053925e10 / 0.4096e4 * t11272 - 0.3610035e7 / 0.4096e4) * t11269

        if Bindx == 501:
            t11277 = np.cos(phi)
            t11278 = t11277 ** 2
            t11279 = t11278 ** 2
            t11280 = t11278 * t11279
            t11283 = t11280 ** 2
            t11281 = t11279 ** 2
            tfunc[..., c] = 0.33e2 / 0.8192e4 * np.sqrt(0.12597e5) * (47558 * t11279 - 345366 * t11280 + 2498490 * t11283 + 21 + (1225440 + 310155 * t11281) * t11281 + (-2353130 * t11281 - 1380690 * t11283 - 2478) * t11278) * np.cos((6 * phi2))

        if Bindx == 502:
            t11286 = np.cos(phi)
            t11287 = t11286 ** 2
            t11288 = t11287 ** 2
            t11289 = t11287 * t11288
            t11292 = t11289 ** 2
            t11290 = t11288 ** 2
            tfunc[..., c] = 0.495e3 / 0.16384e5 * np.sqrt(0.7429e4) * np.sqrt(0.2e1) * (1988 * t11288 - 8064 * t11289 + 14532 * t11292 + 3 + (17010 + 899 * t11290) * t11290 + (-20608 * t11290 - 5568 * t11292 - 192) * t11287) * np.cos((12 * phi2))

        if Bindx == 503:
            t11295 = np.cos(phi)
            t11296 = t11295 ** 2
            t11297 = t11296 ** 2
            t11298 = t11296 * t11297
            t11301 = t11298 ** 2
            t11299 = t11297 ** 2
            tfunc[..., c] = (-0.33e2 / 0.8192e4*1j) * np.exp((1j) * phi1) * np.sqrt(0.17e2) * np.sqrt((1 - t11295)) * np.sqrt((1 + t11295)) * t11295 * (-3594591 * t11297 + 19684665 * t11298 - 54679625 * t11299 - 59879925 * t11301 - 6435 + (80528175 * t11299 + 17678835 * t11301 + 285285) * t11296)

        if Bindx == 504:
            t11321 = np.cos(phi)
            t11320 = t11321 ** 2
            t11323 = t11320 ** 2
            t11322 = t11321 * t11320
            t11325 = t11322 ** 2
            t11327 = t11323 ** 2
            t11324 = t11321 * t11323
            t11329 = t11324 ** 2
            t11331 = t11325 ** 2
            t11326 = t11321 * t11325
            t11333 = t11326 ** 2
            t11335 = t11327 ** 2
            t11338 = 7434 * t11320 - 142674 * t11323 + 1036098 * t11325 - 3676320 * t11327 + 7059390 * t11329 - 7495470 * t11331 + 4142070 * t11333 - 930465 * t11335 - 63
            t11337 = -97594 * t11322 + 1131214 * t11324 - 5937858 * t11326 + (16667410 * t11327 - 26756590 * t11329 + 24655770 * t11331 - 12146070 * t11333 + 2481240 * t11335 + 2478) * t11321
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.741e3) * ((1 + t11321) ** (-0.1e1 / 0.2e1)) * ((1 - t11321) ** (-0.1e1 / 0.2e1)) * ((t11337 + t11338) * np.exp((1j) * (phi1 - 6 * phi2)) + (t11337 - t11338) * np.exp((1j) * (phi1 + 6 * phi2)))

        if Bindx == 505:
            t11357 = np.cos(phi)
            t11356 = t11357 ** 2
            t11359 = t11356 ** 2
            t11358 = t11357 * t11356
            t11361 = t11358 ** 2
            t11363 = t11359 ** 2
            t11360 = t11357 * t11359
            t11365 = t11360 ** 2
            t11367 = t11361 ** 2
            t11362 = t11357 * t11361
            t11369 = t11362 ** 2
            t11371 = t11363 ** 2
            t11374 = -9 + 576 * t11356 - 5964 * t11359 + 24192 * t11361 - 51030 * t11363 + 61824 * t11365 - 43596 * t11367 + 16704 * t11369 - 2697 * t11371
            t11373 = -2084 * t11358 + 14084 * t11360 - 46116 * t11362 + (85540 * t11363 - 95116 * t11365 + 63084 * t11367 - 23084 * t11369 + 3596 * t11371 + 96) * t11357
            tfunc[..., c] = (0.495e3 / 0.32768e5*1j) * np.sqrt(0.437e3) * np.sqrt(0.2e1) * ((1 + t11357) ** (-0.1e1 / 0.2e1)) * ((1 - t11357) ** (-0.1e1 / 0.2e1)) * ((t11373 + t11374) * np.exp((1j) * (phi1 - 12 * phi2)) + (t11373 - t11374) * np.exp((1j) * (phi1 + 12 * phi2)))

        if Bindx == 506:
            t11376 = np.cos(phi)
            t11377 = t11376 ** 2
            t11378 = t11377 ** 2
            t11379 = t11377 * t11378
            t11382 = t11379 ** 2
            t11380 = t11378 ** 2
            t11375 = np.sin(phi)
            tfunc[..., c] = -(0.33e2 / 0.16384e5) * np.exp((2*1j) * phi1) * np.sqrt(0.510e3) * t11375 ** 2 * (-399399 * t11378 + 3062059 * t11379 - 10935925 * t11380 - 17298645 * t11382 - 143 + (19684665 * t11380 + 5892945 * t11382 + 19019) * t11377)

        if Bindx == 507:
            t11401 = np.cos(phi)
            t11400 = t11401 ** 2
            t11402 = t11401 * t11400
            t11403 = t11400 ** 2
            t11404 = t11401 * t11403
            t11405 = t11402 ** 2
            t11406 = t11401 * t11405
            t11407 = t11403 ** 2
            t11409 = t11404 ** 2
            t11411 = t11405 ** 2
            t11413 = t11406 ** 2
            t11417 = -37555 * t11402 + 405419 * t11404 - 1900651 * t11406 + (4521225 * t11407 - 5710785 * t11409 + 3651825 * t11411 - 930465 * t11413 + 987) * t11401
            t11416 = -8120 * t11400 + 155134 * t11403 - 1136268 * t11405 - 8169600 * t11409 + 9042450 * t11411 - 5242620 * t11413 + 70 + (4118334 + 1240620 * t11407) * t11407
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.1235e4) * np.sqrt(0.2e1) * ((t11416 + t11417) * np.exp((2*1j) * (phi1 - 3 * phi2)) + (t11416 - t11417) * np.exp((2*1j) * (phi1 + 3 * phi2)))

        if Bindx == 508:
            t11435 = np.cos(phi)
            t11434 = t11435 ** 2
            t11437 = t11434 ** 2
            t11436 = t11435 * t11434
            t11439 = t11436 ** 2
            t11441 = t11437 ** 2
            t11438 = t11435 * t11437
            t11443 = t11438 ** 2
            t11445 = t11439 ** 2
            t11440 = t11435 * t11439
            t11447 = t11440 ** 2
            t11451 = 124 * t11434 + 280 * t11437 - 12180 * t11439 - 98028 * t11443 + 94136 * t11445 - 45820 * t11447 - 2 + (52500 + 8990 * t11441) * t11441
            t11450 = -7763 * t11436 + 46585 * t11438 - 129815 * t11440 + (195335 * t11441 - 164521 * t11443 + 73283 * t11445 - 13485 * t11447 + 381) * t11435
            tfunc[..., c] = (0.33e2 / 0.16384e5) * ((t11450 + t11451) * np.exp((2*1j) * (phi1 - 6 * phi2)) + (-t11450 + t11451) * np.exp((2*1j) * (phi1 + 6 * phi2))) * np.sqrt(0.6555e4)

        if Bindx == 509:
            t11452 = np.cos(phi)
            t11453 = t11452 ** 2
            t11454 = t11453 ** 2
            t11456 = t11454 ** 2
            t11455 = t11453 * t11454
            tfunc[..., c] = (0.33e2 / 0.8192e4*1j) * np.exp((3*1j) * phi1) * np.sqrt(0.33915e5) * ((1 - t11452) ** (0.3e1 / 0.2e1)) * ((1 + t11452) ** (0.3e1 / 0.2e1)) * t11452 * (69069 * t11454 + 740025 * t11456 + 143 + (-328900 + 310155 * t11455) * t11455 + (-780390 * t11456 - 6006) * t11453)

        if Bindx == 510:
            t11477 = np.cos(phi)
            t11476 = t11477 ** 2
            t11479 = t11476 ** 2
            t11478 = t11477 * t11476
            t11481 = t11478 ** 2
            t11483 = t11479 ** 2
            t11480 = t11477 * t11479
            t11485 = t11480 ** 2
            t11487 = t11481 ** 2
            t11482 = t11477 * t11481
            t11489 = t11482 ** 2
            t11491 = t11483 ** 2
            t11494 = 22914 * t11476 - 427922 * t11479 + 3048346 * t11481 - 10700612 * t11483 + 20497830 * t11485 - 21875070 * t11487 + 12226110 * t11489 - 2791395 * t11491 - 201
            t11493 = -56458 * t11478 + 670766 * t11480 - 3726834 * t11482 + (11325522 * t11483 - 19943070 * t11485 + 20272890 * t11487 - 11025510 * t11489 + 2481240 * t11491 + 1454) * t11477
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.455e3) * ((1 + t11477) ** (-0.1e1 / 0.2e1)) * ((1 - t11477) ** (-0.1e1 / 0.2e1)) * ((t11493 + t11494) * np.exp((3*1j) * (phi1 - 2 * phi2)) + (t11493 - t11494) * np.exp((3*1j) * (phi1 + 2 * phi2)))

        if Bindx == 511:
            t11513 = np.cos(phi)
            t11512 = t11513 ** 2
            t11514 = t11513 * t11512
            t11515 = t11512 ** 2
            t11516 = t11513 * t11515
            t11517 = t11514 ** 2
            t11518 = t11513 * t11517
            t11519 = t11515 ** 2
            t11521 = t11516 ** 2
            t11523 = t11517 ** 2
            t11525 = t11518 ** 2
            t11527 = t11519 ** 2
            t11530 = 13148 * t11514 - 69340 * t11516 + 155580 * t11518 + (-149820 * t11519 + 8628 * t11521 + 100492 * t11523 - 75980 * t11525 + 17980 * t11527 - 688) * t11513
            t11529 = -3060 * t11512 + 34864 * t11515 - 170660 * t11517 + 433870 * t11519 - 621916 * t11521 + 509000 * t11523 - 222604 * t11525 + 40455 * t11527 + 51
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.2415e4) * np.sqrt(0.2e1) * ((1 + t11513) ** (-0.1e1 / 0.2e1)) * ((1 - t11513) ** (-0.1e1 / 0.2e1)) * ((-t11529 + t11530) * np.exp((3*1j) * (phi1 - 4 * phi2)) + (t11529 + t11530) * np.exp((3*1j) * (phi1 + 4 * phi2)))

        if Bindx == 512:
            t11540 = np.sin(phi)
            t11538 = t11540 ** 2
            t11531 = np.cos(phi)
            t11532 = t11531 ** 2
            t11533 = t11532 ** 2
            t11535 = t11533 ** 2
            t11534 = t11532 * t11533
            tfunc[..., c] = (0.33e2 / 0.16384e5) * np.exp((4*1j) * phi1) * np.sqrt(0.88179e5) * t11538 ** 2 * (26565 * t11533 + 512325 * t11535 + 11 + (-177100 + 310155 * t11534) * t11534 + (-660330 * t11535 - 1386) * t11532)

        if Bindx == 513:
            t11558 = np.cos(phi)
            t11557 = t11558 ** 2
            t11560 = t11558 * t11557
            t11561 = t11557 ** 2
            t11562 = t11558 * t11561
            t11563 = t11560 ** 2
            t11564 = t11558 * t11563
            t11565 = t11561 ** 2
            t11567 = t11562 ** 2
            t11569 = t11563 ** 2
            t11571 = t11564 ** 2
            t11575 = -487715 * t11560 + 5090953 * t11562 - 23424695 * t11564 + (55508775 * t11565 - 70777785 * t11567 + 46173075 * t11569 - 12096045 * t11571 + 13437) * t11558
            t11574 = -6820 * t11557 + 175640 * t11561 - 1941492 * t11563 - 27968460 * t11567 + 40006200 * t11569 - 28614300 * t11571 + 62 + (10285140 + 8064030 * t11565) * t11565
            t11559 = 2 * phi1
            tfunc[..., c] = (0.33e2 / 0.16384e5) * ((t11574 + t11575) * np.exp((2*1j) * (t11559 - 3 * phi2)) + (t11574 - t11575) * np.exp((2*1j) * (t11559 + 3 * phi2))) * np.sqrt(0.7e1)

        if Bindx == 514:
            t11593 = np.cos(phi)
            t11592 = t11593 ** 2
            t11594 = t11593 * t11592
            t11595 = t11592 ** 2
            t11596 = t11593 * t11595
            t11597 = t11594 ** 2
            t11598 = t11593 * t11597
            t11599 = t11595 ** 2
            t11601 = t11596 ** 2
            t11603 = t11597 ** 2
            t11605 = t11598 ** 2
            t11609 = 85 * t11594 + 823 * t11596 - 6659 * t11598 + (17021 * t11599 - 20425 * t11601 + 11861 * t11603 - 2697 * t11605 - 9) * t11593
            t11608 = 280 * t11592 - 2612 * t11595 + 9720 * t11597 + 14664 * t11601 - 4036 * t11603 - 1624 * t11605 - 5 + (-17286 + 899 * t11599) * t11599
            tfunc[..., c] = (0.165e3 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.6279e4) * ((t11608 + t11609) * np.exp((4*1j) * (phi1 - 3 * phi2)) + (t11608 - t11609) * np.exp((4*1j) * (phi1 + 3 * phi2)))

        if Bindx == 515:
            t11610 = np.cos(phi)
            t11611 = t11610 ** 2
            t11612 = t11611 ** 2
            t11614 = t11612 ** 2
            tfunc[..., c] = (-0.33e2 / 0.8192e4*1j) * np.exp((5*1j) * phi1) * np.sqrt(0.12597e5) * ((1 - t11610) ** (0.5e1 / 0.2e1)) * ((1 + t11610) ** (0.5e1 / 0.2e1)) * t11610 * (-88550 * t11612 - 550275 * t11614 - 231 + (341550 * t11612 + 310155 * t11614 + 8855) * t11611)

        if Bindx == 516:
            t11634 = np.cos(phi)
            t11633 = t11634 ** 2
            t11637 = t11633 ** 2
            t11636 = t11634 * t11633
            t11639 = t11636 ** 2
            t11641 = t11637 ** 2
            t11638 = t11634 * t11637
            t11643 = t11638 ** 2
            t11645 = t11639 ** 2
            t11640 = t11634 * t11639
            t11647 = t11640 ** 2
            t11649 = t11641 ** 2
            t11652 = 487918 * t11633 - 8673630 * t11637 + 60237590 * t11639 - 210521300 * t11641 + 407970090 * t11643 - 445243890 * t11645 + 256228050 * t11647 - 60480225 * t11649 - 4603
            t11651 = 745790 * t11636 - 6298922 * t11638 + 18128022 * t11640 + (-4075830 * t11641 - 74406150 * t11643 + 147870450 * t11645 - 114197070 * t11647 + 32256120 * t11649 - 22410) * t11634
            t11635 = 5 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * ((1 + t11634) ** (-0.1e1 / 0.2e1)) * ((1 - t11634) ** (-0.1e1 / 0.2e1)) * ((t11651 + t11652) * np.exp((1j) * (t11635 - 6 * phi2)) + (t11651 - t11652) * np.exp((1j) * (t11635 + 6 * phi2)))

        if Bindx == 517:
            t11671 = np.cos(phi)
            t11670 = t11671 ** 2
            t11674 = t11670 ** 2
            t11673 = t11671 * t11670
            t11676 = t11673 ** 2
            t11678 = t11674 ** 2
            t11675 = t11671 * t11674
            t11680 = t11675 ** 2
            t11682 = t11676 ** 2
            t11677 = t11671 * t11676
            t11684 = t11677 ** 2
            t11686 = t11678 ** 2
            t11689 = 23 - 1196 * t11670 + 9048 * t11674 - 23068 * t11676 + 11422 * t11678 + 44604 * t11680 - 82912 * t11682 + 55564 * t11684 - 13485 * t11686
            t11688 = 2956 * t11673 - 22732 * t11675 + 79212 * t11677 + (-140012 * t11678 + 127172 * t11680 - 50628 * t11682 + 580 * t11684 + 3596 * t11686 - 144) * t11671
            t11672 = 5 * phi1
            tfunc[..., c] = (0.165e3 / 0.32768e5*1j) * np.sqrt(0.897e3) * np.sqrt(0.2e1) * ((1 + t11671) ** (-0.1e1 / 0.2e1)) * ((1 - t11671) ** (-0.1e1 / 0.2e1)) * ((t11688 + t11689) * np.exp((1j) * (t11672 - 12 * phi2)) + (t11688 - t11689) * np.exp((1j) * (t11672 + 12 * phi2)))

        if Bindx == 518:
            t11699 = np.sin(phi)
            t11696 = t11699 ** 2
            t11697 = t11699 * t11696
            t11690 = np.cos(phi)
            t11691 = t11690 ** 2
            t11692 = t11691 ** 2
            t11694 = t11692 ** 2
            tfunc[..., c] = -(0.33e2 / 0.16384e5) * np.exp((6*1j) * phi1) * np.sqrt(0.25194e5) * t11697 ** 2 * (-40250 * t11692 - 450225 * t11694 - 21 + (217350 * t11692 + 310155 * t11694 + 2415) * t11691)

        if Bindx == 519:
            t11717 = np.cos(phi)
            t11716 = t11717 ** 2
            t11718 = t11717 * t11716
            t11719 = t11716 ** 2
            t11720 = t11717 * t11719
            t11721 = t11718 ** 2
            t11722 = t11717 * t11721
            t11723 = t11719 ** 2
            t11725 = t11720 ** 2
            t11727 = t11721 ** 2
            t11729 = t11722 ** 2
            t11733 = -1247925 * t11718 + 12674109 * t11720 - 58935085 * t11722 + (144532575 * t11723 - 192796695 * t11725 + 132015975 * t11727 - 36288135 * t11729 + 36989) * t11717
            t11732 = 227400 * t11716 - 3468010 * t11719 + 18442116 * t11721 + 33153120 * t11725 + 16011450 * t11727 - 39019500 * t11729 - 2274 + (-41464170 + 16128060 * t11723) * t11723
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.2e1) * ((t11732 + t11733) * np.exp((6*1j) * (phi1 - phi2)) + (t11732 - t11733) * np.exp((6*1j) * (phi1 + phi2)))

        if Bindx == 520:
            t11751 = np.cos(phi)
            t11750 = t11751 ** 2
            t11752 = t11751 * t11750
            t11753 = t11750 ** 2
            t11754 = t11751 * t11753
            t11755 = t11752 ** 2
            t11756 = t11751 * t11755
            t11757 = t11753 ** 2
            t11759 = t11754 ** 2
            t11761 = t11755 ** 2
            t11763 = t11756 ** 2
            t11767 = 2859 * t11752 - 15009 * t11754 + 32351 * t11756 + (-24783 * t11757 - 8751 * t11759 + 21605 * t11761 - 8091 * t11763 - 181) * t11751
            t11766 = -276 * t11750 - 104 * t11753 + 11484 * t11755 + 63844 * t11759 - 40200 * t11761 + 6612 * t11763 + 6 + (-43164 + 1798 * t11757) * t11757
            tfunc[..., c] = (0.165e3 / 0.16384e5) * ((t11766 + t11767) * np.exp((6*1j) * (phi1 - 2 * phi2)) + (t11766 - t11767) * np.exp((6*1j) * (phi1 + 2 * phi2))) * np.sqrt(0.897e3)

        if Bindx == 521:
            t11768 = np.cos(phi)
            t11769 = t11768 ** 2
            t11770 = t11769 ** 2
            tfunc[..., c] = (0.33e2 / 0.8192e4*1j) * np.exp((7*1j) * phi1) * np.sqrt(0.1448655e7) * ((1 - t11768) ** (0.7e1 / 0.2e1)) * ((1 + t11768) ** (0.7e1 / 0.2e1)) * t11768 * (-700 * t11769 + 21 + (-15660 * t11769 + 5670 + 13485 * t11770) * t11770)

        if Bindx == 522:
            t11790 = np.cos(phi)
            t11789 = t11790 ** 2
            t11793 = t11789 ** 2
            t11797 = t11793 ** 2
            t11806 = 1402440 * t11797 ** 2
            t11792 = t11790 * t11789
            t11795 = t11792 ** 2
            t11796 = t11790 * t11795
            t11803 = t11796 ** 2
            t11801 = t11795 ** 2
            t11794 = t11790 * t11793
            t11799 = t11794 ** 2
            t11791 = 7 * phi1
            t11782 = t11790 * t11797
            t11780 = t11790 * t11799
            t11778 = t11790 * t11801
            t11776 = t11790 * t11803
            tfunc[..., c] = (-0.33e2 / 0.32768e5*1j) * np.sqrt((1 - t11790)) * np.sqrt(0.115e3) * ((1 + t11790) ** (-0.1e1 / 0.2e1)) * ((-2278965 * t11776 + 9460815 * t11778 - 15982785 * t11780 + 14040675 * t11782 - 13113 * t11789 + 5969 * t11790 - 190939 * t11792 + 146615 * t11793 + 1709757 * t11794 - 805189 * t11795 - 6764527 * t11796 + 2895849 * t11797 - 6441435 * t11799 + 8158605 * t11801 - 5343975 * t11803 + 203 + t11806) * np.exp((1j) * (t11791 - 6 * phi2)) + (5083845 * t11776 - 12785955 * t11778 + 10053225 * t11780 - 887535 * t11782 + 24645 * t11789 + 5563 * t11790 - 153181 * t11792 - 490735 * t11793 + 1072407 * t11794 + 3587353 * t11795 - 2371985 * t11796 - 12032361 * t11797 + 19594575 * t11799 - 14088165 * t11801 + 2018835 * t11803 - 203 + t11806) * np.exp((1j) * (t11791 + 6 * phi2)))

        if Bindx == 523:
            t11825 = np.cos(phi)
            t11824 = t11825 ** 2
            t11828 = t11824 ** 2
            t11827 = t11825 * t11824
            t11830 = t11827 ** 2
            t11832 = t11828 ** 2
            t11829 = t11825 * t11828
            t11834 = t11829 ** 2
            t11836 = t11830 ** 2
            t11831 = t11825 * t11830
            t11838 = t11831 ** 2
            t11840 = t11832 ** 2
            t11843 = -4360 * t11824 + 67716 * t11828 - 349256 * t11830 + 773366 * t11832 - 744216 * t11834 + 157780 * t11836 + 193256 * t11838 - 94395 * t11840 + 109
            t11842 = -32788 * t11827 + 111412 * t11829 - 42900 * t11831 + (-427372 * t11832 + 842788 * t11834 - 593028 * t11836 + 121220 * t11838 + 17980 * t11840 + 2688) * t11825
            t11826 = 7 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.195e3) * np.sqrt(0.2e1) * ((1 + t11825) ** (-0.1e1 / 0.2e1)) * ((1 - t11825) ** (-0.1e1 / 0.2e1)) * ((t11842 + t11843) * np.exp((1j) * (t11826 - 12 * phi2)) + (t11842 - t11843) * np.exp((1j) * (t11826 + 12 * phi2)))

        if Bindx == 524:
            t11852 = np.sin(phi)
            t11849 = t11852 ** 2
            t11850 = t11849 ** 2
            t11844 = np.cos(phi)
            t11845 = t11844 ** 2
            t11846 = t11845 ** 2
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.exp((8*1j) * phi1) * np.sqrt(0.965770e6) * t11850 ** 2 * (-700 * t11845 + 7 + (-36540 * t11845 + 9450 + 40455 * t11846) * t11846)

        if Bindx == 525:
            t11870 = np.cos(phi)
            t11869 = t11870 ** 2
            t11872 = t11870 * t11869
            t11873 = t11869 ** 2
            t11874 = t11870 * t11873
            t11875 = t11872 ** 2
            t11876 = t11870 * t11875
            t11877 = t11873 ** 2
            t11879 = t11874 ** 2
            t11881 = t11875 ** 2
            t11883 = t11876 ** 2
            t11887 = -2317 * t11872 + 58247 * t11874 - 448657 * t11876 + (1467345 * t11877 - 2330055 * t11879 + 1781325 * t11881 - 525915 * t11883 + 27) * t11870
            t11886 = 8342 * t11869 - 115990 * t11873 + 607838 * t11875 + 1811810 * t11879 - 832650 * t11881 - 147030 * t11883 - 97 + (-1507528 + 175305 * t11877) * t11877
            t11871 = 4 * phi1
            tfunc[..., c] = (0.33e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.345e3) * ((t11886 + t11887) * np.exp((2*1j) * (t11871 - 3 * phi2)) + (t11886 - t11887) * np.exp((2*1j) * (t11871 + 3 * phi2)))

        if Bindx == 526:
            t11905 = np.cos(phi)
            t11904 = t11905 ** 2
            t11908 = t11904 ** 2
            t11907 = t11905 * t11904
            t11910 = t11907 ** 2
            t11912 = t11908 ** 2
            t11909 = t11905 * t11908
            t11914 = t11909 ** 2
            t11916 = t11910 ** 2
            t11911 = t11905 * t11910
            t11918 = t11911 ** 2
            t11922 = -3552 * t11904 + 29940 * t11908 - 85536 * t11910 + 85536 * t11914 - 146252 * t11916 + 51040 * t11918 + 111 + (64218 + 4495 * t11912) * t11912
            t11921 = 3454 * t11907 + 17002 * t11909 - 121154 * t11911 + (228030 * t11912 - 146838 * t11914 - 6786 * t11916 + 26970 * t11918 - 678) * t11905
            t11906 = 2 * phi1
            tfunc[..., c] = (0.99e2 / 0.16384e5) * ((-t11921 + t11922) * np.exp((4*1j) * (t11906 - 3 * phi2)) + (t11921 + t11922) * np.exp((4*1j) * (t11906 + 3 * phi2))) * np.sqrt(0.65e2)

        if Bindx == 527:
            t11923 = np.cos(phi)
            t11924 = t11923 ** 2
            t11925 = t11924 ** 2
            tfunc[..., c] = (-0.33e2 / 0.8192e4*1j) * np.exp((9*1j) * phi1) * np.sqrt(0.482885e6) * ((1 - t11923) ** (0.9e1 / 0.2e1)) * ((1 + t11923) ** (0.9e1 / 0.2e1)) * t11923 * (-5481 * t11925 - 35 + (8091 * t11925 + 945) * t11924)

        if Bindx == 528:
            t11943 = np.cos(phi)
            t11942 = t11943 ** 2
            t11945 = t11943 * t11942
            t11948 = t11945 ** 2
            t11949 = t11943 * t11948
            t11956 = t11949 ** 2
            t11958 = 280488 * t11943 * t11956
            t11954 = t11948 ** 2
            t11946 = t11942 ** 2
            t11947 = t11943 * t11946
            t11952 = t11947 ** 2
            t11950 = t11946 ** 2
            t11944 = 3 * phi1
            t11935 = t11943 * t11950
            t11933 = t11943 * t11952
            t11931 = t11943 * t11954
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * ((1 - t11943) ** (0.3e1 / 0.2e1)) * np.sqrt(0.345e3) * ((1 + t11943) ** (-0.1e1 / 0.2e1)) * ((-1158144 * t11931 + 1975896 * t11933 - 1823536 * t11935 - 14753 * t11942 - 2992 * t11943 + 59048 * t11945 + 216107 * t11946 - 333344 * t11947 - 1019029 * t11948 + 1002584 * t11949 + 2281741 * t11950 - 2683395 * t11952 + 1604889 * t11954 - 385671 * t11956 + 111 + t11958) * np.exp((3*1j) * (t11944 - 2 * phi2)) + (2628444 * t11931 - 4592952 * t11933 + 1373372 * t11935 + 1897 * t11942 - 3436 * t11943 + 92792 * t11945 + 100429 * t11946 - 598444 * t11947 - 1161083 * t11948 + 983576 * t11949 + 3870691 * t11950 - 4369365 * t11952 + 213759 * t11954 + 1507623 * t11956 - 111 + t11958) * np.exp((3*1j) * (t11944 + 2 * phi2)))

        if Bindx == 529:
            t11977 = np.cos(phi)
            t11976 = t11977 ** 2
            t11980 = t11976 ** 2
            t11979 = t11977 * t11976
            t11982 = t11979 ** 2
            t11984 = t11980 ** 2
            t11981 = t11977 * t11980
            t11986 = t11981 ** 2
            t11988 = t11982 ** 2
            t11983 = t11977 * t11982
            t11990 = t11983 ** 2
            t11992 = t11984 ** 2
            t11995 = -4824 * t11976 + 25700 * t11980 - 22936 * t11982 - 116050 * t11984 + 286968 * t11986 - 210732 * t11988 + 17400 * t11990 + 24273 * t11992 + 201
            t11994 = -5700 * t11979 + 59748 * t11981 - 179652 * t11983 + (188100 * t11984 + 16404 * t11986 - 138100 * t11988 + 55796 * t11990 + 3596 * t11992 - 192) * t11977
            t11978 = 3 * phi1
            tfunc[..., c] = (0.99e2 / 0.32768e5*1j) * np.sqrt(0.65e2) * np.sqrt(0.2e1) * ((1 + t11977) ** (-0.1e1 / 0.2e1)) * ((1 - t11977) ** (-0.1e1 / 0.2e1)) * ((t11994 - t11995) * np.exp((3*1j) * (t11978 - 4 * phi2)) + (t11994 + t11995) * np.exp((3*1j) * (t11978 + 4 * phi2)))

        if Bindx == 530:
            t12004 = np.sin(phi)
            t12000 = t12004 ** 2
            t12002 = t12004 * t12000 ** 2
            t11996 = np.cos(phi)
            t11997 = t11996 ** 2
            t11998 = t11997 ** 2
            tfunc[..., c] = -(0.33e2 / 0.16384e5) * np.exp((10*1j) * phi1) * np.sqrt(0.520030e6) * t12002 ** 2 * (-3915 * t11998 - 5 + (8091 * t11998 + 405) * t11997)

        if Bindx == 531:
            t12022 = np.cos(phi)
            t12021 = t12022 ** 2
            t12024 = t12022 * t12021
            t12025 = t12021 ** 2
            t12026 = t12022 * t12025
            t12027 = t12024 ** 2
            t12028 = t12022 * t12027
            t12029 = t12025 ** 2
            t12031 = t12026 ** 2
            t12033 = t12027 ** 2
            t12035 = t12028 ** 2
            t12039 = -4075 * t12024 + 20963 * t12026 - 32659 * t12028 + (-25311 * t12029 + 124407 * t12031 - 123975 * t12033 + 40455 * t12035 + 195) * t12022
            t12038 = 952 * t12021 - 12422 * t12025 + 67804 * t12027 + 232672 * t12031 - 134346 * t12033 + 12876 * t12035 - 14 + (-178310 + 10788 * t12029) * t12029
            t12023 = 5 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.2e1) * np.sqrt(0.31395e5) * ((t12038 - t12039) * np.exp((2*1j) * (t12023 - 3 * phi2)) + (t12038 + t12039) * np.exp((2*1j) * (t12023 + 3 * phi2)))

        if Bindx == 532:
            t12057 = np.cos(phi)
            t12056 = t12057 ** 2
            t12059 = t12057 * t12056
            t12060 = t12056 ** 2
            t12061 = t12057 * t12060
            t12062 = t12059 ** 2
            t12063 = t12057 * t12062
            t12064 = t12060 ** 2
            t12066 = t12061 ** 2
            t12068 = t12062 ** 2
            t12070 = t12063 ** 2
            t12074 = 9091 * t12059 - 40937 * t12061 + 40183 * t12063 + (67353 * t12064 - 127335 * t12066 + 38541 * t12068 + 13485 * t12070 - 381) * t12057
            t12073 = 2604 * t12056 - 936 * t12060 - 49764 * t12062 - 87516 * t12066 - 36296 * t12068 + 38164 * t12070 - 186 + (132132 + 1798 * t12064) * t12064
            t12058 = 5 * phi1
            tfunc[..., c] = (0.99e2 / 0.16384e5) * ((t12073 - t12074) * np.exp((2*1j) * (t12058 - 6 * phi2)) + (t12073 + t12074) * np.exp((2*1j) * (t12058 + 6 * phi2))) * np.sqrt(0.35e2)

        if Bindx == 533:
            t12075 = np.cos(phi)
            t12076 = t12075 ** 2
            tfunc[..., c] = (0.99e2 / 0.8192e4*1j) * np.exp((11*1j) * phi1) * np.sqrt(0.260015e6) * ((1 - t12075) ** (0.11e2 / 0.2e1)) * ((1 + t12075) ** (0.11e2 / 0.2e1)) * t12075 * (15 + (-290 + 899 * t12076) * t12076)

        if Bindx == 534:
            t12093 = np.cos(phi)
            t12092 = t12093 ** 2
            t12095 = t12093 * t12092
            t12098 = t12095 ** 2
            t12099 = t12093 * t12098
            t12107 = 7192 * t12099 ** 2
            t12104 = t12098 ** 2
            t12096 = t12092 ** 2
            t12097 = t12093 * t12096
            t12102 = t12097 ** 2
            t12100 = t12096 ** 2
            t12094 = 11 * phi1
            t12085 = t12093 * t12100
            t12083 = t12093 * t12102
            t12081 = t12093 * t12104
            tfunc[..., c] = (-0.33e2 / 0.32768e5*1j) * ((1 - t12093) ** (0.5e1 / 0.2e1)) * np.sqrt(0.31395e5) * ((1 + t12093) ** (-0.1e1 / 0.2e1)) * ((t12107 - 8091 * t12081 - 32335 * t12104 + 34626 * t12083 + 60258 * t12102 - 58773 * t12085 - 60401 * t12100 + 49500 * t12099 + 35156 * t12098 - 20757 * t12097 - 11649 * t12096 + 3522 * t12095 + 1810 * t12092 - 27 * t12093 - 31) * np.exp((1j) * (t12094 - 6 * phi2)) + (t12107 + 51243 * t12081 + 145667 * t12104 + 190298 * t12083 + 52602 * t12102 - 164087 * t12085 - 197703 * t12100 - 42372 * t12099 + 66132 * t12098 + 45133 * t12097 + 1221 * t12096 - 6646 * t12095 - 1414 * t12092 + 159 * t12093 + 31) * np.exp((1j) * (t12094 + 6 * phi2)))

        if Bindx == 535:
            t12126 = np.cos(phi)
            t12125 = t12126 ** 2
            t12128 = t12126 * t12125
            t12129 = t12125 ** 2
            t12130 = t12126 * t12129
            t12131 = t12128 ** 2
            t12132 = t12126 * t12131
            t12133 = t12129 ** 2
            t12135 = t12130 ** 2
            t12137 = t12131 ** 2
            t12139 = t12132 ** 2
            t12141 = t12133 ** 2
            t12144 = 30668 * t12128 - 62348 * t12130 - 125268 * t12132 + (473044 * t12133 - 364156 * t12135 - 48132 * t12137 + 95236 * t12139 + 3596 * t12141 - 2640) * t12126
            t12143 = 2468 * t12125 + 43272 * t12129 - 224588 * t12131 + 286286 * t12133 + 94380 * t12135 - 354640 * t12137 + 123772 * t12139 + 29667 * t12141 - 617
            t12127 = 11 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt(0.35e2) * ((1 + t12126) ** (-0.1e1 / 0.2e1)) * ((1 - t12126) ** (-0.1e1 / 0.2e1)) * ((-t12143 + t12144) * np.exp((1j) * (t12127 - 12 * phi2)) + (t12143 + t12144) * np.exp((1j) * (t12127 + 12 * phi2)))

        if Bindx == 536:
            t12152 = np.sin(phi)
            t12148 = t12152 ** 2
            t12149 = t12152 * t12148
            t12150 = t12149 ** 2
            t12145 = np.cos(phi)
            t12146 = t12145 ** 2
            tfunc[..., c] = (0.495e3 / 0.16384e5) * np.exp((12*1j) * phi1) * np.sqrt(0.7429e4) * t12150 ** 2 * (3 + (-174 + 899 * t12146) * t12146)

        if Bindx == 537:
            t12170 = np.cos(phi)
            t12169 = t12170 ** 2
            t12172 = t12170 * t12169
            t12173 = t12169 ** 2
            t12174 = t12170 * t12173
            t12175 = t12172 ** 2
            t12176 = t12170 * t12175
            t12177 = t12173 ** 2
            t12179 = t12174 ** 2
            t12181 = t12175 ** 2
            t12183 = t12176 ** 2
            t12187 = 2859 * t12172 - 15009 * t12174 + 32351 * t12176 + (-24783 * t12177 - 8751 * t12179 + 21605 * t12181 - 8091 * t12183 - 181) * t12170
            t12186 = -276 * t12169 - 104 * t12173 + 11484 * t12175 + 63844 * t12179 - 40200 * t12181 + 6612 * t12183 + 6 + (-43164 + 1798 * t12177) * t12177
            t12171 = 2 * phi1
            tfunc[..., c] = (0.165e3 / 0.16384e5) * ((t12186 + t12187) * np.exp((6*1j) * (t12171 - phi2)) + (t12186 - t12187) * np.exp((6*1j) * (t12171 + phi2))) * np.sqrt(0.897e3)

        if Bindx == 538:
            t12205 = np.cos(phi)
            t12204 = t12205 ** 2
            t12206 = t12205 * t12204
            t12207 = t12204 ** 2
            t12208 = t12205 * t12207
            t12209 = t12206 ** 2
            t12210 = t12205 * t12209
            t12211 = t12207 ** 2
            t12213 = t12208 ** 2
            t12215 = t12209 ** 2
            t12217 = t12210 ** 2
            t12221 = 35259 * t12206 + 98553 * t12208 - 512941 * t12210 + (383955 * t12211 + 308217 * t12213 - 269381 * t12215 - 40455 * t12217 - 7303) * t12205
            t12220 = 9528 * t12204 - 129220 * t12207 + 216216 * t12209 - 664664 * t12213 + 151788 * t12215 + 149640 * t12217 + 1191 + (265122 + 4495 * t12211) * t12211
            tfunc[..., c] = (0.33e2 / 0.16384e5) * np.sqrt(0.2e1) * ((t12220 + t12221) * np.exp((12*1j) * (phi1 - phi2)) + (t12220 - t12221) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 539:
            t12222 = np.cos(phi)
            tfunc[..., c] = (-0.495e3 / 0.8192e4*1j) * np.exp((13*1j) * phi1) * np.sqrt(0.215441e6) * ((1 - t12222) ** (0.13e2 / 0.2e1)) * ((1 + t12222) ** (0.13e2 / 0.2e1)) * t12222 * (31 * t12222 ** 2 - 3)

        if Bindx == 540:
            t12237 = np.cos(phi)
            t12236 = t12237 ** 2
            t12239 = t12237 * t12236
            t12242 = t12239 ** 2
            t12248 = t12242 ** 2
            t12250 = 248 * t12237 * t12248
            t12240 = t12236 ** 2
            t12241 = t12237 * t12240
            t12246 = t12241 ** 2
            t12244 = t12240 ** 2
            t12238 = 13 * phi1
            t12231 = t12237 * t12242
            t12229 = t12237 * t12244
            t12227 = t12237 * t12246
            tfunc[..., c] = (0.165e3 / 0.32768e5*1j) * ((1 - t12237) ** (0.7e1 / 0.2e1)) * np.sqrt(0.26013e5) * ((1 + t12237) ** (-0.1e1 / 0.2e1)) * ((t12250 - 217 * t12248 - 1218 * t12227 + 984 * t12246 + 2466 * t12229 - 1761 * t12244 - 2644 * t12231 + 1544 * t12242 + 1596 * t12241 - 651 * t12240 - 522 * t12239 + 96 * t12236 + 74 * t12237 + 5) * np.exp((1j) * (t12238 - 6 * phi2)) + (t12250 + 2201 * t12248 + 8454 * t12227 + 18040 * t12246 + 22330 * t12229 + 13761 * t12244 - 1188 * t12231 - 8712 * t12242 - 5940 * t12241 - 1045 * t12240 + 638 * t12239 + 336 * t12236 + 34 * t12237 - 5) * np.exp((1j) * (t12238 + 6 * phi2)))

        if Bindx == 541:
            t12268 = np.cos(phi)
            t12267 = t12268 ** 2
            t12271 = t12267 ** 2
            t12275 = t12271 ** 2
            t12284 = 620 * t12275 ** 2
            t12270 = t12268 * t12267
            t12273 = t12270 ** 2
            t12274 = t12268 * t12273
            t12281 = t12274 ** 2
            t12279 = t12273 ** 2
            t12272 = t12268 * t12271
            t12277 = t12272 ** 2
            t12269 = 13 * phi1
            t12260 = t12268 * t12275
            t12258 = t12268 * t12277
            t12256 = t12268 * t12279
            t12254 = t12268 * t12281
            tfunc[..., c] = (-0.33e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * np.sqrt((1 - t12268)) * np.sqrt(0.29e2) * ((1 + t12268) ** (-0.1e1 / 0.2e1)) * ((t12284 - 5425 * t12254 + 19155 * t12281 - 31129 * t12256 + 8099 * t12279 + 55419 * t12258 - 89089 * t12277 + 29315 * t12260 + 63063 * t12275 - 77363 * t12274 + 17017 * t12273 + 27573 * t12272 - 22295 * t12271 + 3241 * t12270 + 3189 * t12267 - 1631 * t12268 + 241) * np.exp((1j) * (t12269 - 12 * phi2)) + (t12284 + 6665 * t12254 + 31245 * t12281 + 81529 * t12256 + 120757 * t12279 + 73437 * t12258 - 71071 * t12277 - 189475 * t12260 - 155727 * t12275 - 15301 * t12274 + 79079 * t12273 + 68523 * t12272 + 18655 * t12271 - 6881 * t12270 - 6933 * t12267 - 2113 * t12268 - 241) * np.exp((1j) * (t12269 + 12 * phi2)))

        if Bindx == 542:
            t12291 = np.sin(phi)
            t12286 = t12291 ** 2
            t12287 = t12291 * t12286
            t12289 = t12291 * t12287 ** 2
            t12285 = np.cos(phi)
            tfunc[..., c] = -(0.99e2 / 0.16384e5) * np.exp((14*1j) * phi1) * np.sqrt(0.2154410e7) * t12289 ** 2 * (31 * t12285 ** 2 - 1)

        if Bindx == 543:
            t12309 = np.cos(phi)
            t12308 = t12309 ** 2
            t12311 = t12309 * t12308
            t12312 = t12308 ** 2
            t12313 = t12309 * t12312
            t12314 = t12311 ** 2
            t12315 = t12309 * t12314
            t12316 = t12312 ** 2
            t12318 = t12313 ** 2
            t12320 = t12314 ** 2
            t12322 = t12315 ** 2
            t12326 = 335 * t12311 - 2599 * t12313 + 6215 * t12315 + (-5885 * t12316 + 1141 * t12318 + 1435 * t12320 - 651 * t12322 + 9) * t12309
            t12325 = -280 * t12308 + 1190 * t12312 - 924 * t12314 + 6336 * t12318 - 4310 * t12320 + 820 * t12322 + 14 + (-2970 + 124 * t12316) * t12316
            t12310 = 7 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.2e1) * np.sqrt(0.130065e6) * ((t12325 + t12326) * np.exp((2*1j) * (t12310 - 3 * phi2)) + (t12325 - t12326) * np.exp((2*1j) * (t12310 + 3 * phi2)))

        if Bindx == 544:
            t12344 = np.cos(phi)
            t12343 = t12344 ** 2
            t12346 = t12344 * t12343
            t12347 = t12343 ** 2
            t12348 = t12344 * t12347
            t12349 = t12346 ** 2
            t12350 = t12344 * t12349
            t12351 = t12347 ** 2
            t12353 = t12348 ** 2
            t12355 = t12349 ** 2
            t12357 = t12350 ** 2
            t12361 = 1771 * t12346 - 7553 * t12348 - 4433 * t12350 + (20449 * t12351 - 2639 * t12353 - 7259 * t12355 - 651 * t12357 + 315) * t12344
            t12360 = -1156 * t12343 + 728 * t12347 + 12012 * t12349 - 12012 * t12353 + 9464 * t12355 + 2948 * t12357 - 34 + (-12012 + 62 * t12351) * t12351
            t12345 = 7 * phi1
            tfunc[..., c] = (0.33e2 / 0.16384e5) * ((t12360 + t12361) * np.exp((2*1j) * (t12345 - 6 * phi2)) + (t12360 - t12361) * np.exp((2*1j) * (t12345 + 6 * phi2))) * np.sqrt(0.145e3)

        if Bindx == 545:
            t12362 = np.cos(phi)
            tfunc[..., c] = (0.99e2 / 0.8192e4*1j) * np.exp((15*1j) * phi1) * np.sqrt(0.33393355e8) * ((1 - t12362) ** (0.15e2 / 0.2e1)) * ((1 + t12362) ** (0.15e2 / 0.2e1)) * t12362

        if Bindx == 546:
            t12376 = np.cos(phi)
            t12375 = t12376 ** 2
            t12378 = t12376 * t12375
            t12381 = t12378 ** 2
            t12388 = 8 * t12381 ** 2
            t12379 = t12375 ** 2
            t12380 = t12376 * t12379
            t12385 = t12380 ** 2
            t12383 = t12379 ** 2
            t12377 = 5 * phi1
            t12370 = t12376 * t12381
            t12368 = t12376 * t12383
            t12366 = t12376 * t12385
            tfunc[..., c] = (-0.33e2 / 0.32768e5*1j) * ((1 - t12376) ** (0.9e1 / 0.2e1)) * np.sqrt(0.4032015e7) * ((1 + t12376) ** (-0.1e1 / 0.2e1)) * ((t12388 - 5 * t12366 - 43 * t12385 + 25 * t12368 + 95 * t12383 - 50 * t12370 - 110 * t12381 + 50 * t12380 + 70 * t12379 - 25 * t12378 - 23 * t12375 + 5 * t12376 + 3) * np.exp((3*1j) * (t12377 - 2 * phi2)) + (t12388 + 85 * t12366 + 407 * t12385 + 1155 * t12368 + 2145 * t12383 + 2706 * t12370 + 2310 * t12381 + 1254 * t12380 + 330 * t12379 - 55 * t12378 - 77 * t12375 - 25 * t12376 - 3) * np.exp((3*1j) * (t12377 + 2 * phi2)))

        if Bindx == 547:
            t12405 = np.cos(phi)
            t12404 = t12405 ** 2
            t12407 = t12405 * t12404
            t12410 = t12407 ** 2
            t12411 = t12405 * t12410
            t12418 = t12411 ** 2
            t12420 = 4 * t12405 * t12418
            t12416 = t12410 ** 2
            t12408 = t12404 ** 2
            t12409 = t12405 * t12408
            t12414 = t12409 ** 2
            t12412 = t12408 ** 2
            t12406 = 5 * phi1
            t12397 = t12405 * t12412
            t12395 = t12405 * t12414
            t12393 = t12405 * t12416
            tfunc[..., c] = (0.33e2 / 0.32768e5*1j) * np.sqrt(0.2e1) * ((1 - t12405) ** (0.3e1 / 0.2e1)) * np.sqrt(0.4495e4) * ((1 + t12405) ** (-0.1e1 / 0.2e1)) * ((t12420 - 37 * t12418 + 142 * t12393 - 271 * t12416 + 184 * t12395 + 275 * t12414 - 726 * t12397 + 561 * t12412 + 132 * t12411 - 583 * t12410 + 418 * t12409 - 37 * t12408 - 128 * t12407 + 89 * t12404 - 26 * t12405 + 3) * np.exp((3*1j) * (t12406 - 4 * phi2)) + (t12420 + 53 * t12418 + 322 * t12393 + 1183 * t12416 + 2912 * t12395 + 5005 * t12414 + 6006 * t12397 + 4719 * t12412 + 1716 * t12411 - 1001 * t12410 - 2002 * t12409 - 1547 * t12408 - 728 * t12407 - 217 * t12404 - 38 * t12405 - 3) * np.exp((3*1j) * (t12406 + 4 * phi2)))

        if Bindx == 548:
            t12425 = np.sin(phi)
            t12421 = t12425 ** 2
            t12422 = t12421 ** 2
            t12423 = t12422 ** 2
            tfunc[..., c] = (0.99e2 / 0.65536e5) * np.exp((16*1j) * phi1) * np.sqrt(0.66786710e8) * t12423 ** 2

        if Bindx == 549:
            t12442 = np.cos(phi)
            t12441 = t12442 ** 2
            t12445 = t12441 ** 2
            t12444 = t12442 * t12441
            t12447 = t12444 ** 2
            t12446 = t12442 * t12445
            t12450 = t12446 ** 2
            t12452 = t12447 ** 2
            t12448 = t12442 * t12447
            t12454 = t12448 ** 2
            t12455 = t12442 * t12454
            t12458 = t12442 * t12455 - 10 * t12441 + 50 * t12445 - 66 * t12447 + 66 * t12450 - 50 * t12452 + 10 * t12454 - 1
            t12457 = -10 * t12444 - 34 * t12446 - 6 * t12455 + (-110 * t12441 + 110) * t12448 + (34 * t12450 + 10 * t12452 + 6) * t12442
            t12443 = 8 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5) * np.sqrt(0.2e1) * np.sqrt(0.4032015e7) * ((t12457 + t12458) * np.exp((2*1j) * (t12443 - 3 * phi2)) + (-t12457 + t12458) * np.exp((2*1j) * (t12443 + 3 * phi2)))

        if Bindx == 550:
            t12474 = np.cos(phi)
            t12491 = -12 * t12474
            t12473 = t12474 ** 2
            t12477 = t12473 ** 2
            t12480 = t12477 ** 2
            t12481 = t12474 * t12480
            t12482 = t12473 * t12481
            t12483 = t12474 * t12482
            t12478 = t12474 * t12477
            t12479 = t12473 * t12478
            t12485 = t12479 ** 2
            t12489 = 64 * t12473 + 364 * t12477 + 364 * t12483 + 64 * t12485 + 1 + (-858 + t12480) * t12480
            t12488 = t12485 * t12491 - 364 * t12478 + 572 * t12479 + 572 * t12481 - 364 * t12482 + t12491 - 196 * (t12473 + t12483) * t12474
            t12475 = 4 * phi1
            tfunc[..., c] = (0.33e2 / 0.32768e5) * ((t12488 + t12489) * np.exp((4*1j) * (t12475 - 3 * phi2)) + (-t12488 + t12489) * np.exp((4*1j) * (t12475 + 3 * phi2))) * np.sqrt(0.4495e4)

        c += 1

    return tfunc


if __name__ == '__main__':
    X = np.zeros([2, 3])
    phi1 = np.array([0.1, 0.2])
    X[:, 0] = phi1
    phi = np.array([0.0, 0.4])
    X[:, 1] = phi
    phi2 = np.array([0.3, 0.6])
    X[:, 2] = phi2

    indxvec = gsh_basis_info()

    lte2 = indxvec[:, 0] <= 2

    Bvec = np.arange(indxvec.shape[0])[lte2]

    out_tvalues = gsh_eval(X, Bvec)
