import numpy as np
from ...fmks.func import deprecate

@deprecate
def gsh_basis_info():

    indxvec = np.array([[0, 0, 1],
                        [4, -4, 1],
                        [4, -3, 1],
                        [4, -2, 1],
                        [4, -1, 1],
                        [4, 0, 1],
                        [4, 1, 1],
                        [4, 2, 1],
                        [4, 3, 1],
                        [4, 4, 1],
                        [6, -6, 1],
                        [6, -5, 1],
                        [6, -4, 1],
                        [6, -3, 1],
                        [6, -2, 1],
                        [6, -1, 1],
                        [6, 0, 1],
                        [6, 1, 1],
                        [6, 2, 1],
                        [6, 3, 1],
                        [6, 4, 1],
                        [6, 5, 1],
                        [6, 6, 1],
                        [8, -8, 1],
                        [8, -7, 1],
                        [8, -6, 1],
                        [8, -5, 1],
                        [8, -4, 1],
                        [8, -3, 1],
                        [8, -2, 1],
                        [8, -1, 1],
                        [8, 0, 1],
                        [8, 1, 1],
                        [8, 2, 1],
                        [8, 3, 1],
                        [8, 4, 1],
                        [8, 5, 1],
                        [8, 6, 1],
                        [8, 7, 1],
                        [8, 8, 1],
                        [9, -9, 1],
                        [9, -8, 1],
                        [9, -7, 1],
                        [9, -6, 1],
                        [9, -5, 1],
                        [9, -4, 1],
                        [9, -3, 1],
                        [9, -2, 1],
                        [9, -1, 1],
                        [9, 0, 1],
                        [9, 1, 1],
                        [9, 2, 1],
                        [9, 3, 1],
                        [9, 4, 1],
                        [9, 5, 1],
                        [9, 6, 1],
                        [9, 7, 1],
                        [9, 8, 1],
                        [9, 9, 1],
                        [10, -10, 1],
                        [10, -9, 1],
                        [10, -8, 1],
                        [10, -7, 1],
                        [10, -6, 1],
                        [10, -5, 1],
                        [10, -4, 1],
                        [10, -3, 1],
                        [10, -2, 1],
                        [10, -1, 1],
                        [10, 0, 1],
                        [10, 1, 1],
                        [10, 2, 1],
                        [10, 3, 1],
                        [10, 4, 1],
                        [10, 5, 1],
                        [10, 6, 1],
                        [10, 7, 1],
                        [10, 8, 1],
                        [10, 9, 1],
                        [10, 10, 1],
                        [12, -12, 1],
                        [12, -12, 2],
                        [12, -11, 1],
                        [12, -11, 2],
                        [12, -10, 1],
                        [12, -10, 2],
                        [12, -9, 1],
                        [12, -9, 2],
                        [12, -8, 1],
                        [12, -8, 2],
                        [12, -7, 1],
                        [12, -7, 2],
                        [12, -6, 1],
                        [12, -6, 2],
                        [12, -5, 1],
                        [12, -5, 2],
                        [12, -4, 1],
                        [12, -4, 2],
                        [12, -3, 1],
                        [12, -3, 2],
                        [12, -2, 1],
                        [12, -2, 2],
                        [12, -1, 1],
                        [12, -1, 2],
                        [12, 0, 1],
                        [12, 0, 2],
                        [12, 1, 1],
                        [12, 1, 2],
                        [12, 2, 1],
                        [12, 2, 2],
                        [12, 3, 1],
                        [12, 3, 2],
                        [12, 4, 1],
                        [12, 4, 2],
                        [12, 5, 1],
                        [12, 5, 2],
                        [12, 6, 1],
                        [12, 6, 2],
                        [12, 7, 1],
                        [12, 7, 2],
                        [12, 8, 1],
                        [12, 8, 2],
                        [12, 9, 1],
                        [12, 9, 2],
                        [12, 10, 1],
                        [12, 10, 2],
                        [12, 11, 1],
                        [12, 11, 2],
                        [12, 12, 1],
                        [12, 12, 2],
                        [13, -13, 1],
                        [13, -12, 1],
                        [13, -11, 1],
                        [13, -10, 1],
                        [13, -9, 1],
                        [13, -8, 1],
                        [13, -7, 1],
                        [13, -6, 1],
                        [13, -5, 1],
                        [13, -4, 1],
                        [13, -3, 1],
                        [13, -2, 1],
                        [13, -1, 1],
                        [13, 0, 1],
                        [13, 1, 1],
                        [13, 2, 1],
                        [13, 3, 1],
                        [13, 4, 1],
                        [13, 5, 1],
                        [13, 6, 1],
                        [13, 7, 1],
                        [13, 8, 1],
                        [13, 9, 1],
                        [13, 10, 1],
                        [13, 11, 1],
                        [13, 12, 1],
                        [13, 13, 1],
                        [14, -14, 1],
                        [14, -13, 1],
                        [14, -12, 1],
                        [14, -11, 1],
                        [14, -10, 1],
                        [14, -9, 1],
                        [14, -8, 1],
                        [14, -7, 1],
                        [14, -6, 1],
                        [14, -5, 1],
                        [14, -4, 1],
                        [14, -3, 1],
                        [14, -2, 1],
                        [14, -1, 1],
                        [14, 0, 1],
                        [14, 1, 1],
                        [14, 2, 1],
                        [14, 3, 1],
                        [14, 4, 1],
                        [14, 5, 1],
                        [14, 6, 1],
                        [14, 7, 1],
                        [14, 8, 1],
                        [14, 9, 1],
                        [14, 10, 1],
                        [14, 11, 1],
                        [14, 12, 1],
                        [14, 13, 1],
                        [14, 14, 1],
                        [15, -15, 1],
                        [15, -14, 1],
                        [15, -13, 1],
                        [15, -12, 1],
                        [15, -11, 1],
                        [15, -10, 1],
                        [15, -9, 1],
                        [15, -8, 1],
                        [15, -7, 1],
                        [15, -6, 1],
                        [15, -5, 1],
                        [15, -4, 1],
                        [15, -3, 1],
                        [15, -2, 1],
                        [15, -1, 1],
                        [15, 0, 1],
                        [15, 1, 1],
                        [15, 2, 1],
                        [15, 3, 1],
                        [15, 4, 1],
                        [15, 5, 1],
                        [15, 6, 1],
                        [15, 7, 1],
                        [15, 8, 1],
                        [15, 9, 1],
                        [15, 10, 1],
                        [15, 11, 1],
                        [15, 12, 1],
                        [15, 13, 1],
                        [15, 14, 1],
                        [15, 15, 1],
                        [16, -16, 1],
                        [16, -16, 2],
                        [16, -15, 1],
                        [16, -15, 2],
                        [16, -14, 1],
                        [16, -14, 2],
                        [16, -13, 1],
                        [16, -13, 2],
                        [16, -12, 1],
                        [16, -12, 2],
                        [16, -11, 1],
                        [16, -11, 2],
                        [16, -10, 1],
                        [16, -10, 2],
                        [16, -9, 1],
                        [16, -9, 2],
                        [16, -8, 1],
                        [16, -8, 2],
                        [16, -7, 1],
                        [16, -7, 2],
                        [16, -6, 1],
                        [16, -6, 2],
                        [16, -5, 1],
                        [16, -5, 2],
                        [16, -4, 1],
                        [16, -4, 2],
                        [16, -3, 1],
                        [16, -3, 2],
                        [16, -2, 1],
                        [16, -2, 2],
                        [16, -1, 1],
                        [16, -1, 2],
                        [16, 0, 1],
                        [16, 0, 2],
                        [16, 1, 1],
                        [16, 1, 2],
                        [16, 2, 1],
                        [16, 2, 2],
                        [16, 3, 1],
                        [16, 3, 2],
                        [16, 4, 1],
                        [16, 4, 2],
                        [16, 5, 1],
                        [16, 5, 2],
                        [16, 6, 1],
                        [16, 6, 2],
                        [16, 7, 1],
                        [16, 7, 2],
                        [16, 8, 1],
                        [16, 8, 2],
                        [16, 9, 1],
                        [16, 9, 2],
                        [16, 10, 1],
                        [16, 10, 2],
                        [16, 11, 1],
                        [16, 11, 2],
                        [16, 12, 1],
                        [16, 12, 2],
                        [16, 13, 1],
                        [16, 13, 2],
                        [16, 14, 1],
                        [16, 14, 2],
                        [16, 15, 1],
                        [16, 15, 2],
                        [16, 16, 1],
                        [16, 16, 2]])

    return indxvec


def gsh_eval(X, Bvec):

    phi1 = X[..., 0]
    phi = X[..., 1]
    phi2 = X[..., 2]

    zvec = np.abs(phi) < 1e-8
    zvec = zvec.astype(int)
    randvec = np.round(np.random.rand(zvec.size)).reshape(zvec.shape)
    randvecopp = np.ones(zvec.shape) - randvec
    phi += (1e-7)*zvec*(randvec - randvecopp)

    final_shape = np.hstack([phi1.shape, len(Bvec)])
    tfunc = np.zeros(final_shape, dtype='complex128')

    c = 0
    for Bindx in Bvec:

        if Bindx == 0:
            tfunc[..., c] = 1

        if Bindx == 1:
            t189 = np.cos(phi)
            t188 = t189 ** 2
            t193 = 4 * (-t188 - 1) * t189
            t186 = t188 ** 2
            t192 = 1 + t186 + 6 * t188
            tfunc[..., c] = (0.3e1 / 0.64e2) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * ((14 * t186 - 28 * t188 + 14) * np.exp((-4*1j) * phi2) + (t192 - t193) * np.exp((-4*1j) * (phi1 + phi2)) + (t192 + t193) * np.exp((4*1j) * (phi1 - phi2)))

        if Bindx == 2:
            t201 = 4 * phi1
            t200 = np.cos(phi)
            t199 = t200 ** 2
            t198 = t200 * t199
            t197 = t199 ** 2
            tfunc[..., c] = (0.3e1 / 0.16e2*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt((1 + t200)) * ((1 - t200) ** (-0.1e1 / 0.2e1)) * ((t197 + 2 * t198 - 2 * t200 - 1) * np.exp((-1*1j) * (t201 + 3 * phi2)) + 14 * (t197 - t198 - t199 + t200) * np.exp((-3*1j) * phi2) + (t197 - 4 * t198 + 6 * t199 - 4 * t200 + 1) * np.exp((1j) * (t201 - 3 * phi2)))

        if Bindx == 3:
            t209 = np.cos(phi)
            t211 = t209 ** 2
            t207 = t211 ** 2
            t215 = -1 + t207
            t214 = 2 * (-t211 + 1) * t209
            t210 = 2 * phi1
            tfunc[..., c] = (0.3e1 / 0.32e2) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.21e2) * ((14 * t207 - 16 * t211 + 2) * np.exp((-2*1j) * phi2) + (-t214 + t215) * np.exp((-2*1j) * (t210 + phi2)) + (t214 + t215) * np.exp((2*1j) * (t210 - phi2)))

        if Bindx == 4:
            t223 = 4 * phi1
            t222 = np.cos(phi)
            t221 = t222 ** 2
            t220 = t222 * t221
            t219 = t221 ** 2
            tfunc[..., c] = (0.3e1 / 0.16e2*1j) * np.sqrt((1 + t222)) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * ((1 - t222) ** (-0.1e1 / 0.2e1)) * ((t219 - 2 * t221 + 1) * np.exp((-1*1j) * (t223 + phi2)) + (t219 - 2 * t220 + 2 * t222 - 1) * np.exp((1j) * (t223 - phi2)) + (14 * t219 - 14 * t220 - 6 * t221 + 6 * t222) * np.exp((-1*1j) * phi2))

        if Bindx == 5:
            t229 = np.cos(phi)
            t228 = t229 ** 2
            t227 = t228 ** 2
            tfunc[..., c] = 0.3e1 / 0.16e2 * np.sqrt(0.7e1) * np.sqrt(0.3e1) * ((35 * t227) - (30 * t228) + 0.3e1 + (5 * t227 - 10 * t228 + 5) * np.cos((4 * phi1)))

        if Bindx == 6:
            t238 = 4 * phi1
            t237 = np.cos(phi)
            t236 = t237 ** 2
            t235 = t237 * t236
            t234 = t236 ** 2
            tfunc[..., c] = (-0.3e1 / 0.16e2*1j) * np.sqrt((1 - t237)) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * ((1 + t237) ** (-0.1e1 / 0.2e1)) * ((t234 - 2 * t236 + 1) * np.exp((-1*1j) * (t238 - phi2)) + (t234 + 2 * t235 - 2 * t237 - 1) * np.exp((1j) * (t238 + phi2)) + (14 * t234 + 14 * t235 - 6 * t236 - 6 * t237) * np.exp((1j) * phi2))

        if Bindx == 7:
            t246 = np.cos(phi)
            t248 = t246 ** 2
            t244 = t248 ** 2
            t252 = -1 + t244
            t251 = 2 * (-t248 + 1) * t246
            t247 = 2 * phi1
            tfunc[..., c] = (0.3e1 / 0.32e2) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.21e2) * ((14 * t244 - 16 * t248 + 2) * np.exp((2*1j) * phi2) + (t251 + t252) * np.exp((-2*1j) * (t247 - phi2)) + (-t251 + t252) * np.exp((2*1j) * (t247 + phi2)))

        if Bindx == 8:
            t260 = 4 * phi1
            t259 = np.cos(phi)
            t258 = t259 ** 2
            t257 = t259 * t258
            t256 = t258 ** 2
            tfunc[..., c] = (-0.3e1 / 0.16e2*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt((1 - t259)) * ((1 + t259) ** (-0.1e1 / 0.2e1)) * ((t256 - 2 * t257 + 2 * t259 - 1) * np.exp((-1*1j) * (t260 - 3 * phi2)) + 14 * (t256 + t257 - t258 - t259) * np.exp((3*1j) * phi2) + (t256 + 4 * t257 + 6 * t258 + 4 * t259 + 1) * np.exp((1j) * (t260 + 3 * phi2)))

        if Bindx == 9:
            t269 = np.cos(phi)
            t268 = t269 ** 2
            t273 = 4 * (-t268 - 1) * t269
            t266 = t268 ** 2
            t272 = 1 + t266 + 6 * t268
            tfunc[..., c] = (0.3e1 / 0.64e2) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * ((14 * t266 - 28 * t268 + 14) * np.exp((4*1j) * phi2) + (t272 + t273) * np.exp((-4*1j) * (phi1 - phi2)) + (t272 - t273) * np.exp((4*1j) * (phi1 + phi2)))

        if Bindx == 10:
            t281 = np.cos(phi)
            t280 = t281 ** 2
            t283 = t280 ** 2
            t284 = t281 * t283
            t287 = 4 * t281 - 4 * t284
            t277 = t281 * t284
            t286 = -1 + t277 - 5 * t280 + 5 * t283
            t282 = 2 * phi1
            tfunc[..., c] = -(0.13e2 / 0.256e3) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.33e2) * ((-2 * t277 + 6 * t283 - 6 * t280 + 2) * np.exp((-6*1j) * phi2) + (t286 - t287) * np.exp((-2*1j) * (t282 + 3 * phi2)) + (t286 + t287) * np.exp((2*1j) * (t282 - 3 * phi2)))

        if Bindx == 11:
            t296 = np.cos(phi)
            t295 = t296 ** 2
            t298 = t296 * t295
            t291 = t298 ** 2
            t302 = 3 * t291 - 5 * t295 - 10 * t298
            t299 = t295 ** 2
            t297 = 4 * phi1
            t292 = t296 * t299
            tfunc[..., c] = (-0.13e2 / 0.128e3*1j) * np.sqrt(0.7e1) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * np.sqrt((1 + t296)) * ((1 - t296) ** (-0.1e1 / 0.2e1)) * (6 * (-t291 + t292 + 2 * t299 - 2 * t298 - t295 + t296) * np.exp((-5*1j) * phi2) + (7 * t292 + 3 * t296 + 2 + t302) * np.exp((-1*1j) * (t297 + 5 * phi2)) + (-13 * t292 + 20 * t299 + 7 * t296 - 2 + t302) * np.exp((1j) * (t297 - 5 * phi2)))

        if Bindx == 12:
            t311 = np.cos(phi)
            t310 = t311 ** 2
            t312 = t311 * t310
            t313 = t310 ** 2
            t317 = 80 * t312 + (-88 * t313 - 8) * t311
            t306 = t312 ** 2
            t316 = -13 - 33 * t306 + 65 * t310 - 35 * t313
            tfunc[..., c] = (0.13e2 / 0.128e3) * np.sqrt(0.7e1) * ((66 * t306 - 138 * t313 + 78 * t310 - 6) * np.exp((-4*1j) * phi2) + (t316 + t317) * np.exp((-4*1j) * (phi1 + phi2)) + (t316 - t317) * np.exp((4*1j) * (phi1 - phi2)))

        if Bindx == 13:
            t327 = np.cos(phi)
            t326 = t327 ** 2
            t330 = t326 ** 2
            t329 = t327 * t326
            t332 = t329 ** 2
            t335 = 2 - 18 * t326 + 38 * t330 - 22 * t332
            t321 = t327 * t332
            t323 = t327 * t330
            t334 = -11 * t321 + 9 * t323 - 5 * t327 + 7 * t329
            t328 = 4 * phi1
            tfunc[..., c] = (0.13e2 / 0.128e3*1j) * np.sqrt(0.15e2) * np.sqrt(0.7e1) * np.sqrt(0.2e1) * ((22 * t321 - 50 * t323 + 34 * t329 - 6 * t327) * np.exp((-3*1j) * phi2) + (t334 + t335) * np.exp((-1*1j) * (t328 + 3 * phi2)) + (t334 - t335) * np.exp((1j) * (t328 - 3 * phi2))) * ((1 + t327) ** (-0.1e1 / 0.2e1)) * ((1 - t327) ** (-0.1e1 / 0.2e1))

        if Bindx == 14:
            t344 = np.cos(phi)
            t343 = t344 ** 2
            t346 = t344 * t343
            t347 = t343 ** 2
            t351 = 64 * t346 + (-44 * t347 - 20) * t344
            t339 = t346 ** 2
            t350 = 1 - 33 * t339 - 11 * t343 + 43 * t347
            t345 = 2 * phi1
            tfunc[..., c] = (0.13e2 / 0.256e3) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.15e2) * ((66 * t339 - 102 * t347 + 38 * t343 - 2) * np.exp((-2*1j) * phi2) + (t350 + t351) * np.exp((-2*1j) * (t345 + phi2)) + (t350 - t351) * np.exp((2*1j) * (t345 - phi2)))

        if Bindx == 15:
            t361 = np.cos(phi)
            t360 = t361 ** 2
            t364 = t360 ** 2
            t363 = t361 * t360
            t366 = t363 ** 2
            t369 = 2 - 26 * t360 + 46 * t364 - 22 * t366
            t355 = t361 * t366
            t357 = t361 * t364
            t368 = -33 * t355 + 79 * t357 + 13 * t361 - 59 * t363
            t362 = 4 * phi1
            tfunc[..., c] = (0.13e2 / 0.64e2*1j) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * ((66 * t355 - 126 * t357 + 70 * t363 - 10 * t361) * np.exp((-1*1j) * phi2) + (t368 + t369) * np.exp((-1*1j) * (t362 + phi2)) + (t368 - t369) * np.exp((1j) * (t362 - phi2))) * ((1 + t361) ** (-0.1e1 / 0.2e1)) * ((1 - t361) ** (-0.1e1 / 0.2e1))

        if Bindx == 16:
            t374 = np.cos(phi)
            t373 = t374 ** 2
            t375 = t373 ** 2
            t371 = t373 * t375
            tfunc[..., c] = -0.13e2 / 0.64e2 * np.sqrt(0.2e1) * (-(231 * t371) + (315 * t375) - (105 * t373) + 0.5e1 + (231 * t371 - 483 * t375 + 273 * t373 - 21) * np.cos((4 * phi1)))

        if Bindx == 17:
            t386 = np.cos(phi)
            t385 = t386 ** 2
            t389 = t385 ** 2
            t388 = t386 * t385
            t391 = t388 ** 2
            t394 = 2 - 26 * t385 + 46 * t389 - 22 * t391
            t380 = t386 * t391
            t382 = t386 * t389
            t393 = -33 * t380 + 79 * t382 + 13 * t386 - 59 * t388
            t387 = 4 * phi1
            tfunc[..., c] = (0.13e2 / 0.64e2*1j) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * ((66 * t380 - 126 * t382 + 70 * t388 - 10 * t386) * np.exp((1j) * phi2) + (t393 - t394) * np.exp((-1*1j) * (t387 - phi2)) + (t393 + t394) * np.exp((1j) * (t387 + phi2))) * ((1 + t386) ** (-0.1e1 / 0.2e1)) * ((1 - t386) ** (-0.1e1 / 0.2e1))

        if Bindx == 18:
            t403 = np.cos(phi)
            t402 = t403 ** 2
            t405 = t403 * t402
            t406 = t402 ** 2
            t410 = 64 * t405 + (-44 * t406 - 20) * t403
            t398 = t405 ** 2
            t409 = 1 - 33 * t398 - 11 * t402 + 43 * t406
            t404 = 2 * phi1
            tfunc[..., c] = (0.13e2 / 0.256e3) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.15e2) * ((66 * t398 - 102 * t406 + 38 * t402 - 2) * np.exp((2*1j) * phi2) + (t409 - t410) * np.exp((-2*1j) * (t404 - phi2)) + (t409 + t410) * np.exp((2*1j) * (t404 + phi2)))

        if Bindx == 19:
            t420 = np.cos(phi)
            t419 = t420 ** 2
            t423 = t419 ** 2
            t422 = t420 * t419
            t425 = t422 ** 2
            t428 = 2 - 18 * t419 + 38 * t423 - 22 * t425
            t414 = t420 * t425
            t416 = t420 * t423
            t427 = 11 * t414 - 9 * t416 + 5 * t420 - 7 * t422
            t421 = 4 * phi1
            tfunc[..., c] = (-0.13e2 / 0.128e3*1j) * np.sqrt(0.15e2) * np.sqrt(0.7e1) * np.sqrt(0.2e1) * ((-22 * t414 + 50 * t416 - 34 * t422 + 6 * t420) * np.exp((3*1j) * phi2) + (t427 + t428) * np.exp((-1*1j) * (t421 - 3 * phi2)) + (t427 - t428) * np.exp((1j) * (t421 + 3 * phi2))) * ((1 + t420) ** (-0.1e1 / 0.2e1)) * ((1 - t420) ** (-0.1e1 / 0.2e1))

        if Bindx == 20:
            t437 = np.cos(phi)
            t436 = t437 ** 2
            t438 = t437 * t436
            t439 = t436 ** 2
            t443 = 80 * t438 + (-88 * t439 - 8) * t437
            t432 = t438 ** 2
            t442 = -13 - 33 * t432 + 65 * t436 - 35 * t439
            tfunc[..., c] = (0.13e2 / 0.128e3) * np.sqrt(0.7e1) * ((66 * t432 - 138 * t439 + 78 * t436 - 6) * np.exp((4*1j) * phi2) + (t442 - t443) * np.exp((-4*1j) * (phi1 - phi2)) + (t442 + t443) * np.exp((4*1j) * (phi1 + phi2)))

        if Bindx == 21:
            t452 = np.cos(phi)
            t451 = t452 ** 2
            t454 = t452 * t451
            t447 = t454 ** 2
            t458 = -3 * t447 + 5 * t451 - 10 * t454
            t455 = t451 ** 2
            t453 = 4 * phi1
            t448 = t452 * t455
            tfunc[..., c] = (-0.13e2 / 0.128e3*1j) * np.sqrt(0.7e1) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * np.sqrt((1 - t452)) * (6 * (t447 + t448 - 2 * t455 - 2 * t454 + t451 + t452) * np.exp((5*1j) * phi2) + (7 * t448 + 3 * t452 - 2 + t458) * np.exp((-1*1j) * (t453 - 5 * phi2)) + (-13 * t448 - 20 * t455 + 7 * t452 + 2 + t458) * np.exp((1j) * (t453 + 5 * phi2))) * ((1 + t452) ** (-0.1e1 / 0.2e1))

        if Bindx == 22:
            t466 = np.cos(phi)
            t465 = t466 ** 2
            t468 = t465 ** 2
            t469 = t466 * t468
            t472 = 4 * t466 - 4 * t469
            t462 = t466 * t469
            t471 = 1 - t462 + 5 * t465 - 5 * t468
            t467 = 2 * phi1
            tfunc[..., c] = (0.13e2 / 0.256e3) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.33e2) * ((2 * t462 - 6 * t468 + 6 * t465 - 2) * np.exp((6*1j) * phi2) + (t471 - t472) * np.exp((-2*1j) * (t467 - 3 * phi2)) + (t471 + t472) * np.exp((2*1j) * (t467 + 3 * phi2)))

        if Bindx == 23:
            t485 = np.cos(phi)
            t484 = t485 ** 2
            t486 = t485 * t484
            t489 = t486 ** 2
            t496 = (-t489 - 1) * t485
            t487 = t484 ** 2
            t481 = t485 * t487
            t495 = -56 * t481 - 56 * t486 + 8 * t496
            t478 = t487 ** 2
            t494 = 1 + t478 + 28 * t484 + 70 * t487 + 28 * t489
            t493 = 112 * t481 + 112 * t486 + 112 * t496
            t492 = 28 + 28 * t478 + 112 * t484 - 280 * t487 + 112 * t489
            tfunc[..., c] = (0.17e2 / 0.12288e5) * np.sqrt(0.2e1) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * ((198 * t478 - 792 * t489 + 1188 * t487 - 792 * t484 + 198) * np.exp((-8*1j) * phi2) + (t494 - t495) * np.exp((-8*1j) * (phi1 + phi2)) + (t494 + t495) * np.exp((8*1j) * (phi1 - phi2)) + (t492 - t493) * np.exp((-4*1j) * (phi1 + 2 * phi2)) + (t492 + t493) * np.exp((4*1j) * (phi1 - 2 * phi2)))

        if Bindx == 24:
            t509 = np.cos(phi)
            t508 = t509 ** 2
            t515 = t508 ** 2
            t502 = t515 ** 2
            t521 = 2 * t502
            t520 = 1 + t509
            t514 = t509 * t508
            t517 = t514 ** 2
            t513 = 4 * phi1
            t512 = 8 * phi1
            t511 = -7 * phi2
            t510 = 7 * phi2
            t505 = t509 * t515
            t503 = t509 * t517
            tfunc[..., c] = (0.17e2 / 0.3072e4*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(t520) * ((1 - t509) ** (-0.1e1 / 0.2e1)) * ((t502 + 6 * t503 + 14 * t517 + 14 * t505 - 14 * t514 - 14 * t508 - 6 * t509 - 1) * np.exp((-1*1j) * (t512 + t510)) + 198 * (t502 - t503 - 3 * t517 + 3 * t505 + 3 * t515 - 3 * t514 - t508 + t509) * np.exp((-7*1j) * phi2) + (t502 - 8 * t503 + 28 * t517 - 56 * t505 + 70 * t515 - 56 * t514 + 28 * t508 - 8 * t509 + 1) * np.exp((1j) * (t512 + t511)) + 14 * (t521 + (5 * t503) - t517 - (11 * t505) - (5 * t515) + (7 * t514) + (5 * t508) - t520) * np.exp((-1*1j) * (t513 + t510)) + 14 * (t521 - (9 * t503) + (13 * t517) - t505 - (15 * t515) + (13 * t514) - t508 - (3 * t509) + 0.1e1) * np.exp((1j) * (t513 + t511)))

        if Bindx == 25:
            t534 = np.cos(phi)
            t533 = t534 ** 2
            t540 = t533 ** 2
            t527 = t540 ** 2
            t539 = t534 * t533
            t542 = t539 ** 2
            t548 = -5 + 5 * t527 - 70 * t533 + 70 * t542
            t528 = t534 * t542
            t530 = t534 * t540
            t547 = -30 * t528 - 70 * t530 + 30 * t534 + 70 * t539
            t546 = -420 * t528 + 588 * t530 - 28 * t534 - 140 * t539
            t545 = -28 + 140 * t527 + 280 * t533 - 560 * t540 + 168 * t542
            t538 = 2 * phi1
            t537 = 4 * phi1
            t536 = -3 * phi2
            t535 = 3 * phi2
            tfunc[..., c] = (0.17e2 / 0.1024e4) * ((990 * t527 - 3036 * t542 + 3168 * t540 - 1188 * t533 + 66) * np.exp((-6*1j) * phi2) + (-t547 + t548) * np.exp((-2*1j) * (t537 + t535)) + (t547 + t548) * np.exp((2*1j) * (t537 + t536)) + (t545 - t546) * np.exp((-2*1j) * (t538 + t535)) + (t545 + t546) * np.exp((2*1j) * (t538 + t536))) * np.sqrt(0.13e2)

        if Bindx == 26:
            t561 = np.cos(phi)
            t560 = t561 ** 2
            t567 = t560 ** 2
            t554 = t567 ** 2
            t573 = 5 * t554
            t572 = 140 * t554
            t566 = t561 * t560
            t569 = t566 ** 2
            t565 = 4 * phi1
            t564 = 8 * phi1
            t563 = -5 * phi2
            t562 = 5 * phi2
            t557 = t561 * t567
            t555 = t561 * t569
            tfunc[..., c] = (0.17e2 / 0.3072e4*1j) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt((1 + t561)) * ((1 - t561) ** (-0.1e1 / 0.2e1)) * (198 * (t573 - 5 * t555 - 11 * t569 + 11 * t557 + 7 * t567 - 7 * t566 - t560 + t561) * np.exp((-5*1j) * phi2) + (t573 - 30 * t555 + 70 * t569 - 70 * t557 + 70 * t566 - 70 * t560 + 30 * t561 - 5) * np.exp((1j) * (t564 + t563)) + (t572 + 210 * t555 - 266 * t569 - 454 * t557 + 150 * t567 + 310 * t566 - 30 * t560 - 66 * t561 + 6) * np.exp((-1*1j) * (t565 + t562)) + (t573 + 20 * t555 + 20 * t569 - 20 * t557 - 50 * t567 - 20 * t566 + 20 * t560 + 20 * t561 + 5) * np.exp((-1*1j) * (t564 + t562)) + (t572 - 490 * t555 + 434 * t569 + 286 * t557 - 590 * t567 + 130 * t566 + 150 * t560 - 54 * t561 - 6) * np.exp((1j) * (t565 + t563)))

        if Bindx == 27:
            t586 = np.cos(phi)
            t585 = t586 ** 2
            t588 = t586 * t585
            t591 = t588 ** 2
            t580 = t586 * t591
            t589 = t585 ** 2
            t582 = t586 * t589
            t597 = -260 * t580 + 260 * t582 - 260 * t586 + 260 * t588
            t596 = -3640 * t580 + 6136 * t582 + 456 * t586 - 3080 * t588
            t579 = t589 ** 2
            t595 = 65 + 65 * t579 + 260 * t585 - 650 * t589 + 260 * t591
            t594 = -36 + 1820 * t579 + 720 * t585 - 920 * t589 - 1456 * t591
            t587 = 2 * phi1
            tfunc[..., c] = (0.17e2 / 0.6144e4) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * ((12870 * t579 - 30888 * t591 + 23364 * t589 - 5544 * t585 + 198) * np.exp((-4*1j) * phi2) + (t594 - t596) * np.exp((-4*1j) * (phi1 + phi2)) + (t595 - t597) * np.exp((-4*1j) * (t587 + phi2)) + (t594 + t596) * np.exp((4*1j) * (phi1 - phi2)) + (t595 + t597) * np.exp((4*1j) * (t587 - phi2)))

        if Bindx == 28:
            t611 = np.cos(phi)
            t610 = t611 ** 2
            t617 = t610 ** 2
            t616 = t611 * t610
            t619 = t616 ** 2
            t621 = t617 ** 2
            t626 = 13 - 78 * t617 + 104 * t619 - 39 * t621
            t603 = t611 * t621
            t607 = t611 * t617
            t625 = 13 * t603 - 78 * t607 - 39 * t611 + 104 * t616
            t624 = -10 + 240 * t610 - 932 * t617 + 1248 * t619 - 546 * t621
            t605 = t611 * t619
            t623 = 364 * t603 - 728 * t605 + 432 * t607 + 4 * t611 - 72 * t616
            t615 = 4 * phi1
            t614 = 8 * phi1
            t613 = -3 * phi2
            t612 = 3 * phi2
            tfunc[..., c] = (0.17e2 / 0.1024e4*1j) * np.sqrt(0.7e1) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * ((1 + t611) ** (-0.1e1 / 0.2e1)) * ((1 - t611) ** (-0.1e1 / 0.2e1)) * ((2574 * t603 - 6864 * t605 + 6204 * t607 - 2112 * t616 + 198 * t611) * np.exp((-3*1j) * phi2) + (t625 - t626) * np.exp((-1*1j) * (t614 + t612)) + (t625 + t626) * np.exp((1j) * (t614 + t613)) + (t623 - t624) * np.exp((-1*1j) * (t615 + t612)) + (t623 + t624) * np.exp((1j) * (t615 + t613)))

        if Bindx == 29:
            t639 = np.cos(phi)
            t638 = t639 ** 2
            t643 = t638 ** 2
            t632 = t643 ** 2
            t642 = t639 * t638
            t645 = t642 ** 2
            t651 = -13 + 13 * t632 + 26 * t638 - 26 * t645
            t633 = t639 * t645
            t635 = t639 * t643
            t650 = -26 * t633 + 78 * t635 + 26 * t639 - 78 * t642
            t649 = -364 * t633 + 676 * t635 + 44 * t639 - 356 * t642
            t648 = 4 + 364 * t632 - 104 * t638 + 464 * t643 - 728 * t645
            t641 = 2 * phi1
            t640 = 4 * phi1
            tfunc[..., c] = (0.17e2 / 0.3072e4) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.11e2) * ((2574 * t632 - 5148 * t645 + 3168 * t643 - 612 * t638 + 18) * np.exp((-2*1j) * phi2) + (-t650 + t651) * np.exp((-2*1j) * (t640 + phi2)) + (t650 + t651) * np.exp((2*1j) * (t640 - phi2)) + (t648 - t649) * np.exp((-2*1j) * (t641 + phi2)) + (t648 + t649) * np.exp((2*1j) * (t641 - phi2)))

        if Bindx == 30:
            t665 = np.cos(phi)
            t664 = t665 ** 2
            t669 = t664 ** 2
            t668 = t665 * t664
            t671 = t668 ** 2
            t673 = t669 ** 2
            t678 = -1 + 4 * t664 - 6 * t669 + 4 * t671 - t673
            t657 = t665 * t673
            t659 = t665 * t671
            t661 = t665 * t669
            t677 = t657 + t665 - 4 * t659 + 6 * t661 - 4 * t668
            t676 = -14 + 392 * t664 - 1652 * t669 + 2184 * t671 - 910 * t673
            t675 = 1820 * t657 - 5096 * t659 + 4928 * t661 + 196 * t665 - 1848 * t668
            t667 = 4 * phi1
            t666 = 8 * phi1
            tfunc[..., c] = (0.17e2 / 0.3072e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * ((1 + t665) ** (-0.1e1 / 0.2e1)) * ((1 - t665) ** (-0.1e1 / 0.2e1)) * ((12870 * t657 - 30888 * t659 + 24948 * t661 - 7560 * t668 + 630 * t665) * np.exp((-1*1j) * phi2) + (t675 - t676) * np.exp((-1*1j) * (t667 + phi2)) + (t675 + t676) * np.exp((1j) * (t667 - phi2)) + 65 * (t677 - t678) * np.exp((-1*1j) * (t666 + phi2)) + 65 * (t677 + t678) * np.exp((1j) * (t666 - phi2)))

        if Bindx == 31:
            t685 = np.cos(phi)
            t684 = t685 ** 2
            t686 = t684 ** 2
            t682 = t684 * t686
            t681 = t686 ** 2
            tfunc[..., c] = 0.17e2 / 0.1024e4 * np.sqrt(0.3e1) * np.sqrt(0.11e2) * ((6435 * t681) - (12012 * t682) + (6930 * t686) - (1260 * t684) + 0.35e2 + (1820 * t681 - 4368 * t682 + 3304 * t686 - 784 * t684 + 28) * np.cos((4 * phi1)) + (65 * t681 - 260 * t682 + 390 * t686 - 260 * t684 + 65) * np.cos((8 * phi1)))

        if Bindx == 32:
            t702 = np.cos(phi)
            t701 = t702 ** 2
            t706 = t701 ** 2
            t705 = t702 * t701
            t708 = t705 ** 2
            t710 = t706 ** 2
            t715 = -1 + 4 * t701 - 6 * t706 + 4 * t708 - t710
            t694 = t702 * t710
            t696 = t702 * t708
            t698 = t702 * t706
            t714 = t694 + t702 - 4 * t696 + 6 * t698 - 4 * t705
            t713 = -14 + 392 * t701 - 1652 * t706 + 2184 * t708 - 910 * t710
            t712 = 1820 * t694 - 5096 * t696 + 4928 * t698 + 196 * t702 - 1848 * t705
            t704 = 4 * phi1
            t703 = 8 * phi1
            tfunc[..., c] = (0.17e2 / 0.3072e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * ((1 + t702) ** (-0.1e1 / 0.2e1)) * ((1 - t702) ** (-0.1e1 / 0.2e1)) * ((12870 * t694 - 30888 * t696 + 24948 * t698 - 7560 * t705 + 630 * t702) * np.exp((1j) * phi2) + (t712 + t713) * np.exp((-1*1j) * (t704 - phi2)) + (t712 - t713) * np.exp((1j) * (t704 + phi2)) + 65 * (t714 + t715) * np.exp((-1*1j) * (t703 - phi2)) + 65 * (t714 - t715) * np.exp((1j) * (t703 + phi2)))

        if Bindx == 33:
            t728 = np.cos(phi)
            t727 = t728 ** 2
            t732 = t727 ** 2
            t721 = t732 ** 2
            t731 = t728 * t727
            t734 = t731 ** 2
            t740 = -13 + 13 * t721 + 26 * t727 - 26 * t734
            t722 = t728 * t734
            t724 = t728 * t732
            t739 = -26 * t722 + 78 * t724 + 26 * t728 - 78 * t731
            t738 = -364 * t722 + 676 * t724 + 44 * t728 - 356 * t731
            t737 = 4 + 364 * t721 - 104 * t727 + 464 * t732 - 728 * t734
            t730 = 2 * phi1
            t729 = 4 * phi1
            tfunc[..., c] = (0.17e2 / 0.3072e4) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.11e2) * ((2574 * t721 - 5148 * t734 + 3168 * t732 - 612 * t727 + 18) * np.exp((2*1j) * phi2) + (t739 + t740) * np.exp((-2*1j) * (t729 - phi2)) + (-t739 + t740) * np.exp((2*1j) * (t729 + phi2)) + (t737 + t738) * np.exp((-2*1j) * (t730 - phi2)) + (t737 - t738) * np.exp((2*1j) * (t730 + phi2)))

        if Bindx == 34:
            t754 = np.cos(phi)
            t753 = t754 ** 2
            t760 = t753 ** 2
            t759 = t754 * t753
            t762 = t759 ** 2
            t764 = t760 ** 2
            t769 = 13 - 78 * t760 + 104 * t762 - 39 * t764
            t746 = t754 * t764
            t750 = t754 * t760
            t768 = 13 * t746 - 78 * t750 - 39 * t754 + 104 * t759
            t767 = -10 + 240 * t753 - 932 * t760 + 1248 * t762 - 546 * t764
            t748 = t754 * t762
            t766 = 364 * t746 - 728 * t748 + 432 * t750 + 4 * t754 - 72 * t759
            t758 = 4 * phi1
            t757 = 8 * phi1
            t756 = -3 * phi2
            t755 = 3 * phi2
            tfunc[..., c] = (0.17e2 / 0.1024e4*1j) * np.sqrt(0.7e1) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * ((1 + t754) ** (-0.1e1 / 0.2e1)) * ((1 - t754) ** (-0.1e1 / 0.2e1)) * ((2574 * t746 - 6864 * t748 + 6204 * t750 - 2112 * t759 + 198 * t754) * np.exp((3*1j) * phi2) + (t768 + t769) * np.exp((-1*1j) * (t757 + t756)) + (t768 - t769) * np.exp((1j) * (t757 + t755)) + (t766 + t767) * np.exp((-1*1j) * (t758 + t756)) + (t766 - t767) * np.exp((1j) * (t758 + t755)))

        if Bindx == 35:
            t782 = np.cos(phi)
            t781 = t782 ** 2
            t784 = t782 * t781
            t787 = t784 ** 2
            t776 = t782 * t787
            t785 = t781 ** 2
            t778 = t782 * t785
            t793 = -260 * t776 + 260 * t778 - 260 * t782 + 260 * t784
            t792 = -3640 * t776 + 6136 * t778 + 456 * t782 - 3080 * t784
            t775 = t785 ** 2
            t791 = 65 + 65 * t775 + 260 * t781 - 650 * t785 + 260 * t787
            t790 = -36 + 1820 * t775 + 720 * t781 - 920 * t785 - 1456 * t787
            t783 = 2 * phi1
            tfunc[..., c] = (0.17e2 / 0.6144e4) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * ((12870 * t775 - 30888 * t787 + 23364 * t785 - 5544 * t781 + 198) * np.exp((4*1j) * phi2) + (t790 + t792) * np.exp((-4*1j) * (phi1 - phi2)) + (t791 + t793) * np.exp((-4*1j) * (t783 - phi2)) + (t790 - t792) * np.exp((4*1j) * (phi1 + phi2)) + (t791 - t793) * np.exp((4*1j) * (t783 + phi2)))

        if Bindx == 36:
            t806 = np.cos(phi)
            t805 = t806 ** 2
            t812 = t805 ** 2
            t799 = t812 ** 2
            t818 = 5 * t799
            t817 = 140 * t799
            t811 = t806 * t805
            t814 = t811 ** 2
            t810 = 4 * phi1
            t809 = 8 * phi1
            t808 = -5 * phi2
            t807 = 5 * phi2
            t802 = t806 * t812
            t800 = t806 * t814
            tfunc[..., c] = (-0.17e2 / 0.3072e4*1j) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt((1 - t806)) * ((1 + t806) ** (-0.1e1 / 0.2e1)) * (198 * (t818 + 5 * t800 - 11 * t814 - 11 * t802 + 7 * t812 + 7 * t811 - t805 - t806) * np.exp((5*1j) * phi2) + (t818 + 30 * t800 + 70 * t814 + 70 * t802 - 70 * t811 - 70 * t805 - 30 * t806 - 5) * np.exp((1j) * (t809 + t807)) + (t817 - 210 * t800 - 266 * t814 + 454 * t802 + 150 * t812 - 310 * t811 - 30 * t805 + 66 * t806 + 6) * np.exp((-1*1j) * (t810 + t808)) + (t818 - 20 * t800 + 20 * t814 + 20 * t802 - 50 * t812 + 20 * t811 + 20 * t805 - 20 * t806 + 5) * np.exp((-1*1j) * (t809 + t808)) + (t817 + 490 * t800 + 434 * t814 - 286 * t802 - 590 * t812 - 130 * t811 + 150 * t805 + 54 * t806 - 6) * np.exp((1j) * (t810 + t807)))

        if Bindx == 37:
            t831 = np.cos(phi)
            t830 = t831 ** 2
            t837 = t830 ** 2
            t824 = t837 ** 2
            t836 = t831 * t830
            t839 = t836 ** 2
            t845 = -5 + 5 * t824 - 70 * t830 + 70 * t839
            t825 = t831 * t839
            t827 = t831 * t837
            t844 = -30 * t825 - 70 * t827 + 30 * t831 + 70 * t836
            t843 = -420 * t825 + 588 * t827 - 28 * t831 - 140 * t836
            t842 = -28 + 140 * t824 + 280 * t830 - 560 * t837 + 168 * t839
            t835 = 2 * phi1
            t834 = 4 * phi1
            t833 = -3 * phi2
            t832 = 3 * phi2
            tfunc[..., c] = (0.17e2 / 0.1024e4) * ((990 * t824 - 3036 * t839 + 3168 * t837 - 1188 * t830 + 66) * np.exp((6*1j) * phi2) + (t844 + t845) * np.exp((-2*1j) * (t834 + t833)) + (-t844 + t845) * np.exp((2*1j) * (t834 + t832)) + (t842 + t843) * np.exp((-2*1j) * (t835 + t833)) + (t842 - t843) * np.exp((2*1j) * (t835 + t832))) * np.sqrt(0.13e2)

        if Bindx == 38:
            t858 = np.cos(phi)
            t857 = t858 ** 2
            t864 = t857 ** 2
            t851 = t864 ** 2
            t870 = 2 * t851
            t869 = 1 - t858
            t863 = t858 * t857
            t866 = t863 ** 2
            t862 = 4 * phi1
            t861 = 8 * phi1
            t860 = -7 * phi2
            t859 = 7 * phi2
            t854 = t858 * t864
            t852 = t858 * t866
            tfunc[..., c] = (-0.17e2 / 0.3072e4*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(t869) * ((1 + t858) ** (-0.1e1 / 0.2e1)) * ((t851 - 6 * t852 + 14 * t866 - 14 * t854 + 14 * t863 - 14 * t857 + 6 * t858 - 1) * np.exp((-1*1j) * (t861 + t860)) + 198 * (t851 + t852 - 3 * t866 - 3 * t854 + 3 * t864 + 3 * t863 - t857 - t858) * np.exp((7*1j) * phi2) + (t851 + 8 * t852 + 28 * t866 + 56 * t854 + 70 * t864 + 56 * t863 + 28 * t857 + 8 * t858 + 1) * np.exp((1j) * (t861 + t859)) + 14 * (t870 - (5 * t852) - t866 + (11 * t854) - (5 * t864) - (7 * t863) + (5 * t857) - t869) * np.exp((-1*1j) * (t862 + t860)) + 14 * (t870 + (9 * t852) + (13 * t866) + t854 - (15 * t864) - (13 * t863) - t857 + (3 * t858) + 0.1e1) * np.exp((1j) * (t862 + t859)))

        if Bindx == 39:
            t883 = np.cos(phi)
            t882 = t883 ** 2
            t884 = t883 * t882
            t887 = t884 ** 2
            t894 = (-t887 - 1) * t883
            t885 = t882 ** 2
            t879 = t883 * t885
            t893 = -56 * t879 - 56 * t884 + 8 * t894
            t876 = t885 ** 2
            t892 = 1 + t876 + 28 * t882 + 70 * t885 + 28 * t887
            t891 = 112 * t879 + 112 * t884 + 112 * t894
            t890 = 28 + 28 * t876 + 112 * t882 - 280 * t885 + 112 * t887
            tfunc[..., c] = (0.17e2 / 0.12288e5) * np.sqrt(0.2e1) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * ((198 * t876 - 792 * t887 + 1188 * t885 - 792 * t882 + 198) * np.exp((8*1j) * phi2) + (t892 + t893) * np.exp((-8*1j) * (phi1 - phi2)) + (t892 - t893) * np.exp((8*1j) * (phi1 + phi2)) + (t890 + t891) * np.exp((-4*1j) * (phi1 - 2 * phi2)) + (t890 - t891) * np.exp((4*1j) * (phi1 + 2 * phi2)))

        if Bindx == 40:
            t907 = np.cos(phi)
            t906 = t907 ** 2
            t913 = t906 ** 2
            t917 = t913 ** 2
            t899 = t907 * t917
            t920 = 1 - t899
            t919 = 34 - 34 * t899
            t912 = t907 * t906
            t915 = t912 ** 2
            t911 = 4 * phi1
            t910 = 8 * phi1
            t909 = -9 * phi2
            t908 = 9 * phi2
            t903 = t907 * t913
            t901 = t907 * t915
            tfunc[..., c] = (0.19e2 / 0.2048e4*1j) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt((1 + t907)) * ((-102 * t917 + 272 * t915 + 204 * t903 - 204 * t913 - 272 * t912 + 102 * t907 + t919) * np.exp((-1*1j) * (t911 + t908)) + (-170 * t917 + 272 * t901 - 476 * t903 + 476 * t913 - 272 * t906 + 170 * t907 - t919) * np.exp((1j) * (t911 + t909)) + (7 * t917 + 20 * t901 + 28 * t915 + 14 * t903 - 14 * t913 - 28 * t912 - 20 * t906 - 7 * t907 - t920) * np.exp((-1*1j) * (t910 + t908)) + (9 * t917 - 36 * t901 + 84 * t915 - 126 * t903 + 126 * t913 - 84 * t912 + 36 * t906 - 9 * t907 + t920) * np.exp((1j) * (t910 + t909))) * ((1 - t907) ** (-0.1e1 / 0.2e1))

        if Bindx == 41:
            t933 = np.cos(phi)
            t932 = t933 ** 2
            t935 = t932 ** 2
            t934 = t933 * t932
            t937 = t934 ** 2
            t939 = t935 ** 2
            t944 = 8 + 152 * t932 + 56 * t935 - 280 * t937 - 64 * t939
            t925 = t933 * t939
            t927 = t933 * t937
            t929 = t933 * t935
            t943 = -9 * t925 - 188 * t927 - 182 * t929 + 55 * t933 + 196 * t934
            t942 = -136 + 680 * t932 + 136 * t935 - 1768 * t937 + 1088 * t939
            t941 = -306 * t925 - 680 * t927 + 2516 * t929 + 238 * t933 - 1768 * t934
            tfunc[..., c] = -(0.19e2 / 0.3072e4) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * ((t943 + t944) * np.exp((-8*1j) * (phi1 + phi2)) + (-t941 + t942) * np.exp((-4*1j) * (phi1 + 2 * phi2)) + (t941 + t942) * np.exp((4*1j) * (phi1 - 2 * phi2)) + (-t943 + t944) * np.exp((8*1j) * (phi1 - phi2)))

        if Bindx == 42:
            t958 = np.cos(phi)
            t957 = t958 ** 2
            t964 = t957 ** 2
            t968 = t964 ** 2
            t950 = t958 * t968
            t963 = t958 * t957
            t966 = t963 ** 2
            t952 = t958 * t966
            t965 = t958 * t964
            t974 = 56 * t950 + 112 * t952 + 40 * t958 + 16 * t963 - 224 * t965
            t973 = -952 * t950 + 2128 * t952 + 88 * t958 + 48 * t963 - 1312 * t965
            t949 = t965 ** 2
            t972 = -7 - 9 * t949 - 77 * t957 + 154 * t964 + 70 * t966 - 131 * t968
            t971 = -46 - 306 * t949 + 598 * t957 - 1852 * t964 + 1788 * t966 - 182 * t968
            t962 = 4 * phi1
            t961 = 8 * phi1
            t960 = -7 * phi2
            t959 = 7 * phi2
            tfunc[..., c] = (0.19e2 / 0.6144e4*1j) * np.sqrt(0.7e1) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * ((t971 + t973) * np.exp((-1*1j) * (t962 + t959)) + (-t972 + t974) * np.exp((-1*1j) * (t961 + t959)) + (-t971 + t973) * np.exp((1j) * (t962 + t960)) + (t972 + t974) * np.exp((1j) * (t961 + t960))) * ((1 + t958) ** (-0.1e1 / 0.2e1)) * ((1 - t958) ** (-0.1e1 / 0.2e1))

        if Bindx == 43:
            t987 = np.cos(phi)
            t986 = t987 ** 2
            t993 = t986 ** 2
            t992 = t987 * t986
            t995 = t992 ** 2
            t997 = t993 ** 2
            t1002 = -2 - 10 * t986 + 42 * t993 - 14 * t995 - 16 * t997
            t979 = t987 * t997
            t981 = t987 * t995
            t983 = t987 * t993
            t1001 = -3 * t979 - 30 * t981 + 28 * t983 - 9 * t987 + 14 * t992
            t1000 = 2 - 38 * t986 + 262 * t993 - 498 * t995 + 272 * t997
            t999 = -102 * t979 - 12 * t981 + 288 * t983 + 38 * t987 - 212 * t992
            t991 = 2 * phi1
            t990 = 4 * phi1
            t989 = -3 * phi2
            t988 = 3 * phi2
            tfunc[..., c] = -(0.19e2 / 0.512e3) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * ((-t999 + t1000) * np.exp((-2*1j) * (t991 + t988)) + (t1001 + t1002) * np.exp((-2*1j) * (t990 + t988)) + (t999 + t1000) * np.exp((2*1j) * (t991 + t989)) + (-t1001 + t1002) * np.exp((2*1j) * (t990 + t989)))

        if Bindx == 44:
            t1016 = np.cos(phi)
            t1015 = t1016 ** 2
            t1022 = t1015 ** 2
            t1026 = t1022 ** 2
            t1008 = t1016 * t1026
            t1021 = t1016 * t1015
            t1024 = t1021 ** 2
            t1010 = t1016 * t1024
            t1023 = t1016 * t1022
            t1032 = 40 * t1008 - 40 * t1010 - 16 * t1016 + 72 * t1021 - 56 * t1023
            t1007 = t1023 ** 2
            t1031 = 5 - 9 * t1007 - 5 * t1015 - 70 * t1022 + 126 * t1024 - 47 * t1026
            t1030 = -680 * t1008 + 1640 * t1010 - 48 * t1016 + 440 * t1021 - 1352 * t1023
            t1029 = -6 - 306 * t1007 + 150 * t1015 - 460 * t1022 + 252 * t1024 + 370 * t1026
            t1020 = 4 * phi1
            t1019 = 8 * phi1
            t1018 = -5 * phi2
            t1017 = 5 * phi2
            tfunc[..., c] = (0.19e2 / 0.3072e4*1j) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.10e2) * np.sqrt(0.7e1) * ((t1029 + t1030) * np.exp((-1*1j) * (t1020 + t1017)) + (-t1031 + t1032) * np.exp((-1*1j) * (t1019 + t1017)) + (-t1029 + t1030) * np.exp((1j) * (t1020 + t1018)) + (t1031 + t1032) * np.exp((1j) * (t1019 + t1018))) * ((1 + t1016) ** (-0.1e1 / 0.2e1)) * ((1 - t1016) ** (-0.1e1 / 0.2e1))

        if Bindx == 45:
            t1045 = np.cos(phi)
            t1044 = t1045 ** 2
            t1048 = t1044 ** 2
            t1047 = t1045 * t1044
            t1050 = t1047 ** 2
            t1052 = t1048 ** 2
            t1057 = -28 + 140 * t1044 + 28 * t1048 - 364 * t1050 + 224 * t1052
            t1037 = t1045 * t1052
            t1039 = t1045 * t1050
            t1041 = t1045 * t1048
            t1056 = -63 * t1037 - 140 * t1039 + 518 * t1041 + 49 * t1045 - 364 * t1047
            t1055 = -36 + 1044 * t1044 - 4796 * t1048 + 7532 * t1050 - 3808 * t1052
            t1054 = -2142 * t1037 + 2968 * t1039 - 532 * t1041 + 66 * t1045 - 424 * t1047
            t1046 = 2 * phi1
            tfunc[..., c] = (0.19e2 / 0.1536e4) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * ((t1054 + t1055) * np.exp((-4*1j) * (phi1 + phi2)) + (-t1056 + t1057) * np.exp((-4*1j) * (t1046 + phi2)) + (-t1054 + t1055) * np.exp((4*1j) * (phi1 - phi2)) + (t1056 + t1057) * np.exp((4*1j) * (t1046 - phi2)))

        if Bindx == 46:
            t1071 = np.cos(phi)
            t1070 = t1071 ** 2
            t1077 = t1070 ** 2
            t1081 = t1077 ** 2
            t1063 = t1071 * t1081
            t1076 = t1071 * t1070
            t1079 = t1076 ** 2
            t1065 = t1071 * t1079
            t1078 = t1071 * t1077
            t1087 = -56 * t1063 + 168 * t1065 + 56 * t1076 - 168 * t1078
            t1062 = t1078 ** 2
            t1086 = -7 - 21 * t1062 + 63 * t1070 - 126 * t1077 + 70 * t1079 + 21 * t1081
            t1085 = 952 * t1063 - 2408 * t1065 + 64 * t1071 - 696 * t1076 + 2088 * t1078
            t1084 = 2 - 714 * t1062 - 66 * t1070 + 484 * t1077 - 1428 * t1079 + 1722 * t1081
            t1075 = 4 * phi1
            t1074 = 8 * phi1
            t1073 = -3 * phi2
            t1072 = 3 * phi2
            tfunc[..., c] = (-0.19e2 / 0.1024e4*1j) * np.sqrt(0.17e2) * np.sqrt(0.26e2) * ((1 + t1071) ** (-0.1e1 / 0.2e1)) * ((1 - t1071) ** (-0.1e1 / 0.2e1)) * ((t1086 + t1087) * np.exp((-1*1j) * (t1074 + t1072)) + (-t1086 + t1087) * np.exp((1j) * (t1074 + t1073)) + (-t1084 + t1085) * np.exp((-1*1j) * (t1075 + t1072)) + (t1084 + t1085) * np.exp((1j) * (t1075 + t1073)))

        if Bindx == 47:
            t1100 = np.cos(phi)
            t1099 = t1100 ** 2
            t1104 = t1099 ** 2
            t1103 = t1100 * t1099
            t1106 = t1103 ** 2
            t1108 = t1104 ** 2
            t1113 = -2 + 22 * t1099 - 54 * t1104 + 50 * t1106 - 16 * t1108
            t1092 = t1100 * t1108
            t1094 = t1100 * t1106
            t1096 = t1100 * t1104
            t1112 = -9 * t1092 + 22 * t1094 - 12 * t1096 + 5 * t1100 - 6 * t1103
            t1111 = 2 - 70 * t1099 + 358 * t1104 - 562 * t1106 + 272 * t1108
            t1110 = -306 * t1092 + 700 * t1094 - 544 * t1096 - 14 * t1100 + 164 * t1103
            t1102 = 2 * phi1
            t1101 = 4 * phi1
            tfunc[..., c] = -(0.19e2 / 0.1536e4) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.26e2) * ((-t1110 + t1111) * np.exp((-2*1j) * (t1102 + phi2)) + (t1112 + t1113) * np.exp((-2*1j) * (t1101 + phi2)) + (t1110 + t1111) * np.exp((2*1j) * (t1102 - phi2)) + (-t1112 + t1113) * np.exp((2*1j) * (t1101 - phi2)))

        if Bindx == 48:
            t1127 = np.cos(phi)
            t1126 = t1127 ** 2
            t1131 = t1126 ** 2
            t1135 = t1131 ** 2
            t1119 = t1127 * t1135
            t1130 = t1127 * t1126
            t1133 = t1130 ** 2
            t1121 = t1127 * t1133
            t1132 = t1127 * t1131
            t1141 = 8 * t1119 - 32 * t1121 + 8 * t1127 - 32 * t1130 + 48 * t1132
            t1140 = -136 * t1119 + 352 * t1121 - 8 * t1127 + 96 * t1130 - 304 * t1132
            t1118 = t1132 ** 2
            t1139 = 1 - 9 * t1118 - 13 * t1126 + 42 * t1131 - 58 * t1133 + 37 * t1135
            t1138 = 2 - 306 * t1118 - 74 * t1126 + 452 * t1131 - 996 * t1133 + 922 * t1135
            t1129 = 4 * phi1
            t1128 = 8 * phi1
            tfunc[..., c] = (0.19e2 / 0.3072e4*1j) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.143e3) * np.sqrt(0.7e1) * ((-t1139 + t1141) * np.exp((-1*1j) * (t1128 + phi2)) + (t1139 + t1141) * np.exp((1j) * (t1128 - phi2)) + (t1138 + t1140) * np.exp((-1*1j) * (t1129 + phi2)) + (-t1138 + t1140) * np.exp((1j) * (t1129 - phi2))) * ((1 + t1127) ** (-0.1e1 / 0.2e1)) * ((1 - t1127) ** (-0.1e1 / 0.2e1))

        if Bindx == 49:
            t1148 = np.cos(phi)
            t1147 = t1148 ** 2
            t1149 = t1147 ** 2
            t1145 = t1147 * t1149
            t1144 = t1149 ** 2
            tfunc[..., c] = (-0.19e2 / 0.512e3*1j) * t1148 * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.1430e4) * ((t1144 - 4 * t1145 + 6 * t1149 - 4 * t1147 + 1) * np.sin((8 * phi1)) + (-34 * t1144 + 88 * t1145 - 76 * t1149 + 24 * t1147 - 2) * np.sin((4 * phi1)))

        if Bindx == 50:
            t1165 = np.cos(phi)
            t1164 = t1165 ** 2
            t1169 = t1164 ** 2
            t1173 = t1169 ** 2
            t1157 = t1165 * t1173
            t1168 = t1165 * t1164
            t1171 = t1168 ** 2
            t1159 = t1165 * t1171
            t1170 = t1165 * t1169
            t1179 = 8 * t1157 - 32 * t1159 + 8 * t1165 - 32 * t1168 + 48 * t1170
            t1178 = -136 * t1157 + 352 * t1159 - 8 * t1165 + 96 * t1168 - 304 * t1170
            t1156 = t1170 ** 2
            t1177 = 1 - 9 * t1156 - 13 * t1164 + 42 * t1169 - 58 * t1171 + 37 * t1173
            t1176 = 2 - 306 * t1156 - 74 * t1164 + 452 * t1169 - 996 * t1171 + 922 * t1173
            t1167 = 4 * phi1
            t1166 = 8 * phi1
            tfunc[..., c] = (-0.19e2 / 0.3072e4*1j) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.143e3) * np.sqrt(0.7e1) * ((1 + t1165) ** (-0.1e1 / 0.2e1)) * ((1 - t1165) ** (-0.1e1 / 0.2e1)) * ((t1177 + t1179) * np.exp((-1*1j) * (t1166 - phi2)) + (-t1177 + t1179) * np.exp((1j) * (t1166 + phi2)) + (-t1176 + t1178) * np.exp((-1*1j) * (t1167 - phi2)) + (t1176 + t1178) * np.exp((1j) * (t1167 + phi2)))

        if Bindx == 51:
            t1192 = np.cos(phi)
            t1191 = t1192 ** 2
            t1196 = t1191 ** 2
            t1195 = t1192 * t1191
            t1198 = t1195 ** 2
            t1200 = t1196 ** 2
            t1205 = 2 - 22 * t1191 + 54 * t1196 - 50 * t1198 + 16 * t1200
            t1184 = t1192 * t1200
            t1186 = t1192 * t1198
            t1188 = t1192 * t1196
            t1204 = -9 * t1184 + 22 * t1186 - 12 * t1188 + 5 * t1192 - 6 * t1195
            t1203 = -2 + 70 * t1191 - 358 * t1196 + 562 * t1198 - 272 * t1200
            t1202 = -306 * t1184 + 700 * t1186 - 544 * t1188 - 14 * t1192 + 164 * t1195
            t1194 = 2 * phi1
            t1193 = 4 * phi1
            tfunc[..., c] = -(0.19e2 / 0.1536e4) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.26e2) * ((-t1202 + t1203) * np.exp((-2*1j) * (t1194 - phi2)) + (t1204 + t1205) * np.exp((-2*1j) * (t1193 - phi2)) + (t1202 + t1203) * np.exp((2*1j) * (t1194 + phi2)) + (-t1204 + t1205) * np.exp((2*1j) * (t1193 + phi2)))

        if Bindx == 52:
            t1219 = np.cos(phi)
            t1218 = t1219 ** 2
            t1225 = t1218 ** 2
            t1229 = t1225 ** 2
            t1211 = t1219 * t1229
            t1224 = t1219 * t1218
            t1227 = t1224 ** 2
            t1213 = t1219 * t1227
            t1226 = t1219 * t1225
            t1235 = -56 * t1211 + 168 * t1213 + 56 * t1224 - 168 * t1226
            t1210 = t1226 ** 2
            t1234 = -7 - 21 * t1210 + 63 * t1218 - 126 * t1225 + 70 * t1227 + 21 * t1229
            t1233 = 952 * t1211 - 2408 * t1213 + 64 * t1219 - 696 * t1224 + 2088 * t1226
            t1232 = 2 - 714 * t1210 - 66 * t1218 + 484 * t1225 - 1428 * t1227 + 1722 * t1229
            t1223 = 4 * phi1
            t1222 = 8 * phi1
            t1221 = -3 * phi2
            t1220 = 3 * phi2
            tfunc[..., c] = (0.19e2 / 0.1024e4*1j) * np.sqrt(0.17e2) * np.sqrt(0.26e2) * ((-t1234 + t1235) * np.exp((-1*1j) * (t1222 + t1221)) + (t1234 + t1235) * np.exp((1j) * (t1222 + t1220)) + (t1232 + t1233) * np.exp((-1*1j) * (t1223 + t1221)) + (-t1232 + t1233) * np.exp((1j) * (t1223 + t1220))) * ((1 + t1219) ** (-0.1e1 / 0.2e1)) * ((1 - t1219) ** (-0.1e1 / 0.2e1))

        if Bindx == 53:
            t1248 = np.cos(phi)
            t1247 = t1248 ** 2
            t1251 = t1247 ** 2
            t1250 = t1248 * t1247
            t1253 = t1250 ** 2
            t1255 = t1251 ** 2
            t1260 = 28 - 140 * t1247 - 28 * t1251 + 364 * t1253 - 224 * t1255
            t1240 = t1248 * t1255
            t1242 = t1248 * t1253
            t1244 = t1248 * t1251
            t1259 = -63 * t1240 - 140 * t1242 + 518 * t1244 + 49 * t1248 - 364 * t1250
            t1258 = 36 - 1044 * t1247 + 4796 * t1251 - 7532 * t1253 + 3808 * t1255
            t1257 = -2142 * t1240 + 2968 * t1242 - 532 * t1244 + 66 * t1248 - 424 * t1250
            t1249 = 2 * phi1
            tfunc[..., c] = (0.19e2 / 0.1536e4) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * ((t1257 + t1258) * np.exp((-4*1j) * (phi1 - phi2)) + (-t1259 + t1260) * np.exp((-4*1j) * (t1249 - phi2)) + (-t1257 + t1258) * np.exp((4*1j) * (phi1 + phi2)) + (t1259 + t1260) * np.exp((4*1j) * (t1249 + phi2)))

        if Bindx == 54:
            t1274 = np.cos(phi)
            t1273 = t1274 ** 2
            t1280 = t1273 ** 2
            t1284 = t1280 ** 2
            t1266 = t1274 * t1284
            t1279 = t1274 * t1273
            t1282 = t1279 ** 2
            t1268 = t1274 * t1282
            t1281 = t1274 * t1280
            t1290 = -40 * t1266 + 40 * t1268 + 16 * t1274 - 72 * t1279 + 56 * t1281
            t1265 = t1281 ** 2
            t1289 = 5 - 9 * t1265 - 5 * t1273 - 70 * t1280 + 126 * t1282 - 47 * t1284
            t1288 = 680 * t1266 - 1640 * t1268 + 48 * t1274 - 440 * t1279 + 1352 * t1281
            t1287 = -6 - 306 * t1265 + 150 * t1273 - 460 * t1280 + 252 * t1282 + 370 * t1284
            t1278 = 4 * phi1
            t1277 = 8 * phi1
            t1276 = -5 * phi2
            t1275 = 5 * phi2
            tfunc[..., c] = (0.19e2 / 0.3072e4*1j) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.10e2) * np.sqrt(0.7e1) * ((t1287 + t1288) * np.exp((-1*1j) * (t1278 + t1276)) + (-t1289 + t1290) * np.exp((-1*1j) * (t1277 + t1276)) + (-t1287 + t1288) * np.exp((1j) * (t1278 + t1275)) + (t1289 + t1290) * np.exp((1j) * (t1277 + t1275))) * ((1 + t1274) ** (-0.1e1 / 0.2e1)) * ((1 - t1274) ** (-0.1e1 / 0.2e1))

        if Bindx == 55:
            t1303 = np.cos(phi)
            t1302 = t1303 ** 2
            t1309 = t1302 ** 2
            t1308 = t1303 * t1302
            t1311 = t1308 ** 2
            t1313 = t1309 ** 2
            t1318 = -2 - 10 * t1302 + 42 * t1309 - 14 * t1311 - 16 * t1313
            t1317 = 2 - 38 * t1302 + 262 * t1309 - 498 * t1311 + 272 * t1313
            t1295 = t1303 * t1313
            t1297 = t1303 * t1311
            t1299 = t1303 * t1309
            t1316 = -3 * t1295 - 30 * t1297 + 28 * t1299 - 9 * t1303 + 14 * t1308
            t1315 = -102 * t1295 - 12 * t1297 + 288 * t1299 + 38 * t1303 - 212 * t1308
            t1307 = 2 * phi1
            t1306 = 4 * phi1
            t1305 = -3 * phi2
            t1304 = 3 * phi2
            tfunc[..., c] = (0.19e2 / 0.512e3) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * ((t1315 + t1317) * np.exp((-2*1j) * (t1307 + t1305)) + (-t1316 + t1318) * np.exp((-2*1j) * (t1306 + t1305)) + (-t1315 + t1317) * np.exp((2*1j) * (t1307 + t1304)) + (t1316 + t1318) * np.exp((2*1j) * (t1306 + t1304)))

        if Bindx == 56:
            t1332 = np.cos(phi)
            t1331 = t1332 ** 2
            t1338 = t1331 ** 2
            t1342 = t1338 ** 2
            t1324 = t1332 * t1342
            t1337 = t1332 * t1331
            t1340 = t1337 ** 2
            t1326 = t1332 * t1340
            t1339 = t1332 * t1338
            t1348 = 56 * t1324 + 112 * t1326 + 40 * t1332 + 16 * t1337 - 224 * t1339
            t1347 = -952 * t1324 + 2128 * t1326 + 88 * t1332 + 48 * t1337 - 1312 * t1339
            t1323 = t1339 ** 2
            t1346 = -7 - 9 * t1323 - 77 * t1331 + 154 * t1338 + 70 * t1340 - 131 * t1342
            t1345 = -46 - 306 * t1323 + 598 * t1331 - 1852 * t1338 + 1788 * t1340 - 182 * t1342
            t1336 = 4 * phi1
            t1335 = 8 * phi1
            t1334 = -7 * phi2
            t1333 = 7 * phi2
            tfunc[..., c] = (-0.19e2 / 0.6144e4*1j) * np.sqrt(0.7e1) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * ((1 + t1332) ** (-0.1e1 / 0.2e1)) * ((1 - t1332) ** (-0.1e1 / 0.2e1)) * ((-t1345 + t1347) * np.exp((-1*1j) * (t1336 + t1334)) + (t1346 + t1348) * np.exp((-1*1j) * (t1335 + t1334)) + (t1345 + t1347) * np.exp((1j) * (t1336 + t1333)) + (-t1346 + t1348) * np.exp((1j) * (t1335 + t1333)))

        if Bindx == 57:
            t1361 = np.cos(phi)
            t1360 = t1361 ** 2
            t1363 = t1360 ** 2
            t1362 = t1361 * t1360
            t1365 = t1362 ** 2
            t1367 = t1363 ** 2
            t1372 = 8 + 152 * t1360 + 56 * t1363 - 280 * t1365 - 64 * t1367
            t1353 = t1361 * t1367
            t1355 = t1361 * t1365
            t1357 = t1361 * t1363
            t1371 = -9 * t1353 - 188 * t1355 - 182 * t1357 + 55 * t1361 + 196 * t1362
            t1370 = -136 + 680 * t1360 + 136 * t1363 - 1768 * t1365 + 1088 * t1367
            t1369 = -306 * t1353 - 680 * t1355 + 2516 * t1357 + 238 * t1361 - 1768 * t1362
            tfunc[..., c] = (0.19e2 / 0.3072e4) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * ((-t1371 + t1372) * np.exp((-8*1j) * (phi1 - phi2)) + (t1369 + t1370) * np.exp((-4*1j) * (phi1 - 2 * phi2)) + (-t1369 + t1370) * np.exp((4*1j) * (phi1 + 2 * phi2)) + (t1371 + t1372) * np.exp((8*1j) * (phi1 + phi2)))

        if Bindx == 58:
            t1385 = np.cos(phi)
            t1384 = t1385 ** 2
            t1391 = t1384 ** 2
            t1395 = t1391 ** 2
            t1377 = t1385 * t1395
            t1398 = -1 - t1377
            t1397 = -34 - 34 * t1377
            t1390 = t1385 * t1384
            t1393 = t1390 ** 2
            t1389 = 4 * phi1
            t1388 = 8 * phi1
            t1387 = -9 * phi2
            t1386 = 9 * phi2
            t1381 = t1385 * t1391
            t1379 = t1385 * t1393
            tfunc[..., c] = (0.19e2 / 0.2048e4*1j) * np.sqrt((1 - t1385)) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * ((1 + t1385) ** (-0.1e1 / 0.2e1)) * ((-102 * t1395 + 272 * t1393 - 204 * t1381 - 204 * t1391 + 272 * t1390 - 102 * t1385 - t1397) * np.exp((-1*1j) * (t1389 + t1387)) + (-170 * t1395 - 272 * t1379 + 476 * t1381 + 476 * t1391 - 272 * t1384 - 170 * t1385 + t1397) * np.exp((1j) * (t1389 + t1386)) + (7 * t1395 - 20 * t1379 + 28 * t1393 - 14 * t1381 - 14 * t1391 + 28 * t1390 - 20 * t1384 + 7 * t1385 + t1398) * np.exp((-1*1j) * (t1388 + t1387)) + (9 * t1395 + 36 * t1379 + 84 * t1393 + 126 * t1381 + 126 * t1391 + 84 * t1390 + 36 * t1384 + 9 * t1385 - t1398) * np.exp((1j) * (t1388 + t1386)))

        if Bindx == 59:
            t1412 = np.cos(phi)
            t1411 = t1412 ** 2
            t1418 = t1411 ** 2
            t1421 = t1418 ** 2
            t1422 = t1412 * t1421
            t1428 = t1412 - t1422
            t1417 = t1412 * t1411
            t1419 = t1417 ** 2
            t1407 = t1412 * t1419
            t1427 = -48 * t1407 + 48 * t1417 + 8 * t1428
            t1426 = 96 * t1407 - 96 * t1417 + 48 * t1428
            t1404 = t1412 * t1422
            t1425 = -1 + t1404 - 27 * t1411 - 42 * t1418 + 42 * t1419 + 27 * t1421
            t1424 = -12 + 12 * t1404 - 36 * t1411 + 168 * t1418 - 168 * t1419 + 36 * t1421
            t1416 = 2 * phi1
            t1415 = 4 * phi1
            t1414 = -5 * phi2
            t1413 = 5 * phi2
            tfunc[..., c] = -(0.7e1 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.17e2) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * ((-26 * t1404 + 130 * t1421 - 260 * t1419 + 260 * t1418 - 130 * t1411 + 26) * np.exp((-10*1j) * phi2) + (t1425 - t1427) * np.exp((-2*1j) * (t1415 + t1413)) + (t1425 + t1427) * np.exp((2*1j) * (t1415 + t1414)) + (t1424 - t1426) * np.exp((-2*1j) * (t1416 + t1413)) + (t1424 + t1426) * np.exp((2*1j) * (t1416 + t1414)))

        if Bindx == 60:
            t1443 = np.cos(phi)
            t1442 = t1443 ** 2
            t1449 = t1442 ** 2
            t1450 = t1443 * t1449
            t1434 = t1450 ** 2
            t1457 = 5 * t1434 - 84 * t1449 - 126 * t1450
            t1456 = 60 * t1434 + 336 * t1449 + 504 * t1450
            t1453 = t1449 ** 2
            t1448 = t1443 * t1442
            t1451 = t1448 ** 2
            t1447 = 4 * phi1
            t1446 = 8 * phi1
            t1445 = -9 * phi2
            t1444 = 9 * phi2
            t1437 = t1443 * t1451
            t1435 = t1443 * t1453
            tfunc[..., c] = (-0.7e1 / 0.8192e4*1j) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * np.sqrt((1 + t1443)) * (130 * (-t1434 + t1435 + 4 * t1453 - 4 * t1437 - 6 * t1451 + 6 * t1450 + 4 * t1449 - 4 * t1448 - t1442 + t1443) * np.exp((-9*1j) * phi2) + (156 * t1435 - 72 * t1453 - 480 * t1437 - 168 * t1451 - 192 * t1448 - 180 * t1442 + 12 * t1443 + 24 + t1456) * np.exp((-1*1j) * (t1447 + t1444)) + (31 * t1435 + 72 * t1453 + 60 * t1437 - 42 * t1451 + 12 * t1448 + 45 * t1442 + 23 * t1443 + 4 + t1457) * np.exp((-1*1j) * (t1446 + t1444)) + (-276 * t1435 + 360 * t1453 + 192 * t1437 - 840 * t1451 - 480 * t1448 + 108 * t1442 + 60 * t1443 - 24 + t1456) * np.exp((1j) * (t1447 + t1445)) + (-41 * t1435 + 144 * t1453 - 276 * t1437 + 294 * t1451 + 156 * t1448 - 99 * t1442 + 31 * t1443 - 4 + t1457) * np.exp((1j) * (t1446 + t1445))) * ((1 - t1443) ** (-0.1e1 / 0.2e1))

        if Bindx == 61:
            t1472 = np.cos(phi)
            t1471 = t1472 ** 2
            t1474 = t1471 ** 2
            t1478 = t1474 ** 2
            t1464 = t1472 * t1478
            t1473 = t1472 * t1471
            t1476 = t1473 ** 2
            t1466 = t1472 * t1476
            t1475 = t1472 * t1474
            t1484 = -608 * t1464 - 1536 * t1466 - 320 * t1472 + 192 * t1473 + 2016 * t1475
            t1483 = -3648 * t1464 + 7680 * t1466 + 384 * t1472 - 384 * t1473 - 4032 * t1475
            t1463 = t1475 ** 2
            t1482 = -59 - 95 * t1463 - 531 * t1471 + 1722 * t1474 + 210 * t1476 - 1503 * t1478
            t1481 = -132 - 1140 * t1463 + 1980 * t1471 - 6888 * t1474 + 7224 * t1476 - 1044 * t1478
            tfunc[..., c] = (0.7e1 / 0.8192e4) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * np.sqrt(0.11e2) * ((2470 * t1463 - 10010 * t1478 + 15340 * t1476 - 10660 * t1474 + 2990 * t1471 - 130) * np.exp((-8*1j) * phi2) + (t1482 + t1484) * np.exp((-8*1j) * (phi1 + phi2)) + (t1481 + t1483) * np.exp((-4*1j) * (phi1 + 2 * phi2)) + (t1481 - t1483) * np.exp((4*1j) * (phi1 - 2 * phi2)) + (t1482 - t1484) * np.exp((8*1j) * (phi1 - phi2)))

        if Bindx == 62:
            t1500 = np.cos(phi)
            t1499 = t1500 ** 2
            t1506 = t1499 ** 2
            t1505 = t1500 * t1499
            t1508 = t1505 ** 2
            t1510 = t1506 ** 2
            t1507 = t1500 * t1506
            t1512 = t1507 ** 2
            t1517 = 44 + 44 * t1499 - 1208 * t1506 + 1960 * t1508 - 308 * t1510 - 532 * t1512
            t1516 = 8 - 184 * t1499 + 2416 * t1506 - 7504 * t1508 + 8456 * t1510 - 3192 * t1512
            t1490 = t1500 * t1512
            t1492 = t1500 * t1510
            t1494 = t1500 * t1508
            t1515 = 95 * t1490 + 1013 * t1492 - 1514 * t1494 - 175 * t1500 + 763 * t1505 - 182 * t1507
            t1514 = 1140 * t1490 - 516 * t1492 - 4376 * t1494 + 364 * t1500 - 2716 * t1505 + 6104 * t1507
            t1504 = 4 * phi1
            t1503 = 8 * phi1
            t1502 = -7 * phi2
            t1501 = 7 * phi2
            tfunc[..., c] = (-0.21e2 / 0.8192e4*1j) * np.sqrt(0.11e2) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * ((1 + t1500) ** (-0.1e1 / 0.2e1)) * ((1 - t1500) ** (-0.1e1 / 0.2e1)) * ((-2470 * t1490 + 10270 * t1492 - 16380 * t1494 + 12220 * t1507 - 4030 * t1505 + 390 * t1500) * np.exp((-7*1j) * phi2) + (t1514 - t1516) * np.exp((-1*1j) * (t1504 + t1501)) + (t1515 - t1517) * np.exp((-1*1j) * (t1503 + t1501)) + (t1514 + t1516) * np.exp((1j) * (t1504 + t1502)) + (t1515 + t1517) * np.exp((1j) * (t1503 + t1502)))

        if Bindx == 63:
            t1532 = np.cos(phi)
            t1531 = t1532 ** 2
            t1538 = t1531 ** 2
            t1542 = t1538 ** 2
            t1524 = t1532 * t1542
            t1537 = t1532 * t1531
            t1540 = t1537 ** 2
            t1526 = t1532 * t1540
            t1539 = t1532 * t1538
            t1548 = -7752 * t1524 + 1360 * t1526 + 1224 * t1532 - 10064 * t1537 + 15232 * t1539
            t1523 = t1539 ** 2
            t1547 = 527 - 1615 * t1523 - 2635 * t1531 - 4522 * t1538 + 19754 * t1540 - 11509 * t1542
            t1546 = -332 - 19380 * t1523 + 9628 * t1531 - 35672 * t1538 + 32088 * t1540 + 13668 * t1542
            t1545 = 46512 * t1524 - 101728 * t1526 + 1872 * t1532 - 20128 * t1537 + 73472 * t1539
            t1536 = 2 * phi1
            t1535 = 4 * phi1
            t1534 = -3 * phi2
            t1533 = 3 * phi2
            tfunc[..., c] = (0.21e2 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.11e2) * ((41990 * t1523 - 139230 * t1542 + 166140 * t1540 - 82940 * t1538 + 14430 * t1531 - 390) * np.exp((-6*1j) * phi2) + (-t1545 + t1546) * np.exp((-2*1j) * (t1536 + t1533)) + (t1547 + t1548) * np.exp((-2*1j) * (t1535 + t1533)) + (t1545 + t1546) * np.exp((2*1j) * (t1536 + t1534)) + (t1547 - t1548) * np.exp((2*1j) * (t1535 + t1534)))

        if Bindx == 64:
            t1564 = np.cos(phi)
            t1563 = t1564 ** 2
            t1570 = t1563 ** 2
            t1574 = t1570 ** 2
            t1571 = t1564 * t1570
            t1576 = t1571 ** 2
            t1581 = -68 + 748 * t1563 - 1632 * t1570 + 2244 * t1574 - 1292 * t1576
            t1569 = t1564 * t1563
            t1572 = t1569 ** 2
            t1580 = 40 - 1400 * t1563 + 8640 * t1570 - 20608 * t1572 + 21080 * t1574 - 7752 * t1576
            t1554 = t1564 * t1576
            t1556 = t1564 * t1574
            t1558 = t1564 * t1572
            t1579 = 323 * t1554 + 1037 * t1556 - 3978 * t1558 + 17 * t1564 - 969 * t1569 + 3570 * t1571
            t1578 = 3876 * t1554 - 7140 * t1556 + 1640 * t1558 + 172 * t1564 - 1740 * t1569 + 3192 * t1571
            t1568 = 4 * phi1
            t1567 = 8 * phi1
            t1566 = -5 * phi2
            t1565 = 5 * phi2
            tfunc[..., c] = (-0.21e2 / 0.4096e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.11e2) * ((-8398 * t1554 + 29614 * t1556 - 38844 * t1558 + 22828 * t1571 - 5590 * t1569 + 390 * t1564) * np.exp((-5*1j) * phi2) + (t1579 - t1581) * np.exp((-1*1j) * (t1567 + t1565)) + (t1579 + t1581) * np.exp((1j) * (t1567 + t1566)) + (t1578 - t1580) * np.exp((-1*1j) * (t1568 + t1565)) + (t1578 + t1580) * np.exp((1j) * (t1568 + t1566))) * ((1 + t1564) ** (-0.1e1 / 0.2e1)) * ((1 - t1564) ** (-0.1e1 / 0.2e1))

        if Bindx == 65:
            t1596 = np.cos(phi)
            t1595 = t1596 ** 2
            t1599 = t1595 ** 2
            t1603 = t1599 ** 2
            t1588 = t1596 * t1603
            t1598 = t1596 * t1595
            t1601 = t1598 ** 2
            t1590 = t1596 * t1601
            t1600 = t1596 * t1599
            t1609 = -5168 * t1588 + 10880 * t1590 + 544 * t1596 - 544 * t1598 - 5712 * t1600
            t1608 = -31008 * t1588 + 69632 * t1590 - 1216 * t1596 + 15424 * t1598 - 53088 * t1600
            t1587 = t1600 ** 2
            t1607 = 4 + 19380 * t1587 - 156 * t1595 - 2296 * t1599 + 19432 * t1601 - 36108 * t1603
            t1606 = 187 + 1615 * t1587 - 2805 * t1595 + 9758 * t1599 - 10234 * t1601 + 1479 * t1603
            t1597 = 2 * phi1
            tfunc[..., c] = -(0.21e2 / 0.4096e4) * np.sqrt(0.11e2) * ((-41990 * t1587 + 117130 * t1603 - 114140 * t1601 + 44980 * t1599 - 6110 * t1595 + 130) * np.exp((-4*1j) * phi2) + (t1607 - t1608) * np.exp((-4*1j) * (phi1 + phi2)) + (t1606 - t1609) * np.exp((-4*1j) * (t1597 + phi2)) + (t1607 + t1608) * np.exp((4*1j) * (phi1 - phi2)) + (t1606 + t1609) * np.exp((4*1j) * (t1597 - phi2)))

        if Bindx == 66:
            t1625 = np.cos(phi)
            t1624 = t1625 ** 2
            t1631 = t1624 ** 2
            t1630 = t1625 * t1624
            t1633 = t1630 ** 2
            t1635 = t1631 ** 2
            t1632 = t1625 * t1631
            t1637 = t1632 ** 2
            t1642 = 68 - 1292 * t1624 + 7344 * t1631 - 14960 * t1633 + 12716 * t1635 - 3876 * t1637
            t1641 = 88 - 3784 * t1624 + 26016 * t1631 - 63392 * t1633 + 64328 * t1635 - 23256 * t1637
            t1615 = t1625 * t1637
            t1617 = t1625 * t1635
            t1619 = t1625 * t1633
            t1640 = -1615 * t1615 + 2839 * t1617 + 1938 * t1619 - 765 * t1625 + 4301 * t1630 - 6698 * t1632
            t1639 = -19380 * t1615 + 53652 * t1617 - 54408 * t1619 + 324 * t1625 - 4996 * t1630 + 24808 * t1632
            t1629 = 4 * phi1
            t1628 = 8 * phi1
            t1627 = -3 * phi2
            t1626 = 3 * phi2
            tfunc[..., c] = (0.21e2 / 0.4096e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.11e2) * ((41990 * t1615 - 130390 * t1617 + 148460 * t1619 - 74620 * t1632 + 15470 * t1630 - 910 * t1625) * np.exp((-3*1j) * phi2) + (t1639 + t1641) * np.exp((-1*1j) * (t1629 + t1626)) + (t1640 + t1642) * np.exp((-1*1j) * (t1628 + t1626)) + (t1639 - t1641) * np.exp((1j) * (t1629 + t1627)) + (t1640 - t1642) * np.exp((1j) * (t1628 + t1627))) * ((1 + t1625) ** (-0.1e1 / 0.2e1)) * ((1 - t1625) ** (-0.1e1 / 0.2e1))

        if Bindx == 67:
            t1657 = np.cos(phi)
            t1656 = t1657 ** 2
            t1661 = t1656 ** 2
            t1665 = t1661 ** 2
            t1649 = t1657 * t1665
            t1660 = t1657 * t1656
            t1663 = t1660 ** 2
            t1651 = t1657 * t1663
            t1662 = t1657 * t1661
            t1671 = -2584 * t1649 + 8432 * t1651 - 680 * t1657 + 4624 * t1660 - 9792 * t1662
            t1670 = -15504 * t1649 + 35360 * t1651 - 496 * t1657 + 7136 * t1660 - 26496 * t1662
            t1648 = t1662 ** 2
            t1669 = -17 - 1615 * t1648 + 357 * t1656 + 646 * t1661 - 3910 * t1663 + 4539 * t1665
            t1668 = 52 - 19380 * t1648 - 2340 * t1656 + 17128 * t1661 - 45032 * t1663 + 49572 * t1665
            t1659 = 2 * phi1
            t1658 = 4 * phi1
            tfunc[..., c] = (0.21e2 / 0.8192e4) * np.sqrt(0.13e2) * np.sqrt(0.11e2) * ((41990 * t1648 - 103870 * t1665 + 89180 * t1663 - 30940 * t1661 + 3710 * t1656 - 70) * np.exp((-2*1j) * phi2) + (t1668 + t1670) * np.exp((-2*1j) * (t1659 + phi2)) + (t1669 + t1671) * np.exp((-2*1j) * (t1658 + phi2)) + (t1668 - t1670) * np.exp((2*1j) * (t1659 - phi2)) + (t1669 - t1671) * np.exp((2*1j) * (t1658 - phi2)))

        if Bindx == 68:
            t1687 = np.cos(phi)
            t1686 = t1687 ** 2
            t1691 = t1686 ** 2
            t1690 = t1687 * t1686
            t1693 = t1690 ** 2
            t1695 = t1691 ** 2
            t1692 = t1687 * t1691
            t1697 = t1692 ** 2
            t1702 = 68 - 1564 * t1686 + 5576 * t1691 - 8024 * t1693 + 5236 * t1695 - 1292 * t1697
            t1701 = 24 - 1128 * t1686 + 8304 * t1691 - 21072 * t1693 + 21624 * t1695 - 7752 * t1697
            t1677 = t1687 * t1697
            t1679 = t1687 * t1695
            t1681 = t1687 * t1693
            t1700 = -1615 * t1677 + 6851 * t1679 - 11254 * t1681 + 391 * t1687 - 3179 * t1690 + 8806 * t1692
            t1699 = -19380 * t1677 + 62628 * t1679 - 74856 * t1681 + 564 * t1687 - 8868 * t1690 + 39912 * t1692
            t1689 = 4 * phi1
            t1688 = 8 * phi1
            tfunc[..., c] = (0.7e1 / 0.4096e4*1j) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * ((41990 * t1677 - 121550 * t1679 + 128700 * t1681 - 60060 * t1692 + 11550 * t1690 - 630 * t1687) * np.exp((-1*1j) * phi2) + (t1699 + t1701) * np.exp((-1*1j) * (t1689 + phi2)) + (t1700 + t1702) * np.exp((-1*1j) * (t1688 + phi2)) + (t1699 - t1701) * np.exp((1j) * (t1689 - phi2)) + (t1700 - t1702) * np.exp((1j) * (t1688 - phi2))) * ((1 + t1687) ** (-0.1e1 / 0.2e1)) * ((1 - t1687) ** (-0.1e1 / 0.2e1))

        if Bindx == 69:
            t1710 = np.cos(phi)
            t1709 = t1710 ** 2
            t1711 = t1709 ** 2
            t1713 = t1711 ** 2
            t1707 = t1709 * t1711
            t1705 = t1709 * t1713
            tfunc[..., c] = -0.7e1 / 0.4096e4 * np.sqrt(0.2e1) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * (-(46189 * t1705) + (109395 * t1713) - (90090 * t1707) + (30030 * t1711) - (3465 * t1709) + 0.63e2 + (42636 * t1705 - 118932 * t1713 + 115896 * t1707 - 45672 * t1711 + 6204 * t1709 - 132) * np.cos((4 * phi1)) + (3553 * t1705 - 14399 * t1713 + 22066 * t1707 - 15334 * t1711 + 4301 * t1709 - 187) * np.cos((8 * phi1)))

        if Bindx == 70:
            t1730 = np.cos(phi)
            t1729 = t1730 ** 2
            t1734 = t1729 ** 2
            t1733 = t1730 * t1729
            t1736 = t1733 ** 2
            t1738 = t1734 ** 2
            t1735 = t1730 * t1734
            t1740 = t1735 ** 2
            t1745 = 68 - 1564 * t1729 + 5576 * t1734 - 8024 * t1736 + 5236 * t1738 - 1292 * t1740
            t1744 = 24 - 1128 * t1729 + 8304 * t1734 - 21072 * t1736 + 21624 * t1738 - 7752 * t1740
            t1720 = t1730 * t1740
            t1722 = t1730 * t1738
            t1724 = t1730 * t1736
            t1743 = -1615 * t1720 + 6851 * t1722 - 11254 * t1724 + 391 * t1730 - 3179 * t1733 + 8806 * t1735
            t1742 = -19380 * t1720 + 62628 * t1722 - 74856 * t1724 + 564 * t1730 - 8868 * t1733 + 39912 * t1735
            t1732 = 4 * phi1
            t1731 = 8 * phi1
            tfunc[..., c] = (0.7e1 / 0.4096e4*1j) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * ((41990 * t1720 - 121550 * t1722 + 128700 * t1724 - 60060 * t1735 + 11550 * t1733 - 630 * t1730) * np.exp((1j) * phi2) + (t1742 - t1744) * np.exp((-1*1j) * (t1732 - phi2)) + (t1743 - t1745) * np.exp((-1*1j) * (t1731 - phi2)) + (t1742 + t1744) * np.exp((1j) * (t1732 + phi2)) + (t1743 + t1745) * np.exp((1j) * (t1731 + phi2))) * ((1 + t1730) ** (-0.1e1 / 0.2e1)) * ((1 - t1730) ** (-0.1e1 / 0.2e1))

        if Bindx == 71:
            t1760 = np.cos(phi)
            t1759 = t1760 ** 2
            t1764 = t1759 ** 2
            t1768 = t1764 ** 2
            t1752 = t1760 * t1768
            t1763 = t1760 * t1759
            t1766 = t1763 ** 2
            t1754 = t1760 * t1766
            t1765 = t1760 * t1764
            t1774 = -2584 * t1752 + 8432 * t1754 - 680 * t1760 + 4624 * t1763 - 9792 * t1765
            t1773 = -15504 * t1752 + 35360 * t1754 - 496 * t1760 + 7136 * t1763 - 26496 * t1765
            t1751 = t1765 ** 2
            t1772 = 17 + 1615 * t1751 - 357 * t1759 - 646 * t1764 + 3910 * t1766 - 4539 * t1768
            t1771 = -52 + 19380 * t1751 + 2340 * t1759 - 17128 * t1764 + 45032 * t1766 - 49572 * t1768
            t1762 = 2 * phi1
            t1761 = 4 * phi1
            tfunc[..., c] = -(0.21e2 / 0.8192e4) * np.sqrt(0.13e2) * np.sqrt(0.11e2) * ((-41990 * t1751 + 103870 * t1768 - 89180 * t1766 + 30940 * t1764 - 3710 * t1759 + 70) * np.exp((2*1j) * phi2) + (t1771 + t1773) * np.exp((-2*1j) * (t1762 - phi2)) + (t1772 + t1774) * np.exp((-2*1j) * (t1761 - phi2)) + (t1771 - t1773) * np.exp((2*1j) * (t1762 + phi2)) + (t1772 - t1774) * np.exp((2*1j) * (t1761 + phi2)))

        if Bindx == 72:
            t1790 = np.cos(phi)
            t1789 = t1790 ** 2
            t1796 = t1789 ** 2
            t1795 = t1790 * t1789
            t1798 = t1795 ** 2
            t1800 = t1796 ** 2
            t1797 = t1790 * t1796
            t1802 = t1797 ** 2
            t1807 = 68 - 1292 * t1789 + 7344 * t1796 - 14960 * t1798 + 12716 * t1800 - 3876 * t1802
            t1806 = 88 - 3784 * t1789 + 26016 * t1796 - 63392 * t1798 + 64328 * t1800 - 23256 * t1802
            t1780 = t1790 * t1802
            t1782 = t1790 * t1800
            t1784 = t1790 * t1798
            t1805 = 1615 * t1780 - 2839 * t1782 - 1938 * t1784 + 765 * t1790 - 4301 * t1795 + 6698 * t1797
            t1804 = 19380 * t1780 - 53652 * t1782 + 54408 * t1784 - 324 * t1790 + 4996 * t1795 - 24808 * t1797
            t1794 = 4 * phi1
            t1793 = 8 * phi1
            t1792 = -3 * phi2
            t1791 = 3 * phi2
            tfunc[..., c] = (-0.21e2 / 0.4096e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.11e2) * ((-41990 * t1780 + 130390 * t1782 - 148460 * t1784 + 74620 * t1797 - 15470 * t1795 + 910 * t1790) * np.exp((3*1j) * phi2) + (t1804 + t1806) * np.exp((-1*1j) * (t1794 + t1792)) + (t1805 + t1807) * np.exp((-1*1j) * (t1793 + t1792)) + (t1804 - t1806) * np.exp((1j) * (t1794 + t1791)) + (t1805 - t1807) * np.exp((1j) * (t1793 + t1791))) * ((1 + t1790) ** (-0.1e1 / 0.2e1)) * ((1 - t1790) ** (-0.1e1 / 0.2e1))

        if Bindx == 73:
            t1822 = np.cos(phi)
            t1821 = t1822 ** 2
            t1825 = t1821 ** 2
            t1829 = t1825 ** 2
            t1814 = t1822 * t1829
            t1824 = t1822 * t1821
            t1827 = t1824 ** 2
            t1816 = t1822 * t1827
            t1826 = t1822 * t1825
            t1835 = -5168 * t1814 + 10880 * t1816 + 544 * t1822 - 544 * t1824 - 5712 * t1826
            t1834 = -31008 * t1814 + 69632 * t1816 - 1216 * t1822 + 15424 * t1824 - 53088 * t1826
            t1813 = t1826 ** 2
            t1833 = 4 + 19380 * t1813 - 156 * t1821 - 2296 * t1825 + 19432 * t1827 - 36108 * t1829
            t1832 = 187 + 1615 * t1813 - 2805 * t1821 + 9758 * t1825 - 10234 * t1827 + 1479 * t1829
            t1823 = 2 * phi1
            tfunc[..., c] = -(0.21e2 / 0.4096e4) * np.sqrt(0.11e2) * ((-41990 * t1813 + 117130 * t1829 - 114140 * t1827 + 44980 * t1825 - 6110 * t1821 + 130) * np.exp((4*1j) * phi2) + (t1833 + t1834) * np.exp((-4*1j) * (phi1 - phi2)) + (t1832 + t1835) * np.exp((-4*1j) * (t1823 - phi2)) + (t1833 - t1834) * np.exp((4*1j) * (phi1 + phi2)) + (t1832 - t1835) * np.exp((4*1j) * (t1823 + phi2)))

        if Bindx == 74:
            t1851 = np.cos(phi)
            t1850 = t1851 ** 2
            t1857 = t1850 ** 2
            t1861 = t1857 ** 2
            t1858 = t1851 * t1857
            t1863 = t1858 ** 2
            t1868 = -68 + 748 * t1850 - 1632 * t1857 + 2244 * t1861 - 1292 * t1863
            t1856 = t1851 * t1850
            t1859 = t1856 ** 2
            t1867 = 40 - 1400 * t1850 + 8640 * t1857 - 20608 * t1859 + 21080 * t1861 - 7752 * t1863
            t1841 = t1851 * t1863
            t1843 = t1851 * t1861
            t1845 = t1851 * t1859
            t1866 = 323 * t1841 + 1037 * t1843 - 3978 * t1845 + 17 * t1851 - 969 * t1856 + 3570 * t1858
            t1865 = 3876 * t1841 - 7140 * t1843 + 1640 * t1845 + 172 * t1851 - 1740 * t1856 + 3192 * t1858
            t1855 = 4 * phi1
            t1854 = 8 * phi1
            t1853 = -5 * phi2
            t1852 = 5 * phi2
            tfunc[..., c] = (-0.21e2 / 0.4096e4*1j) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.11e2) * ((1 + t1851) ** (-0.1e1 / 0.2e1)) * ((1 - t1851) ** (-0.1e1 / 0.2e1)) * ((-8398 * t1841 + 29614 * t1843 - 38844 * t1845 + 22828 * t1858 - 5590 * t1856 + 390 * t1851) * np.exp((5*1j) * phi2) + (t1866 + t1868) * np.exp((-1*1j) * (t1854 + t1853)) + (t1866 - t1868) * np.exp((1j) * (t1854 + t1852)) + (t1865 + t1867) * np.exp((-1*1j) * (t1855 + t1853)) + (t1865 - t1867) * np.exp((1j) * (t1855 + t1852)))

        if Bindx == 75:
            t1883 = np.cos(phi)
            t1882 = t1883 ** 2
            t1889 = t1882 ** 2
            t1893 = t1889 ** 2
            t1875 = t1883 * t1893
            t1888 = t1883 * t1882
            t1891 = t1888 ** 2
            t1877 = t1883 * t1891
            t1890 = t1883 * t1889
            t1899 = -7752 * t1875 + 1360 * t1877 + 1224 * t1883 - 10064 * t1888 + 15232 * t1890
            t1874 = t1890 ** 2
            t1898 = -527 + 1615 * t1874 + 2635 * t1882 + 4522 * t1889 - 19754 * t1891 + 11509 * t1893
            t1897 = 332 + 19380 * t1874 - 9628 * t1882 + 35672 * t1889 - 32088 * t1891 - 13668 * t1893
            t1896 = 46512 * t1875 - 101728 * t1877 + 1872 * t1883 - 20128 * t1888 + 73472 * t1890
            t1887 = 2 * phi1
            t1886 = 4 * phi1
            t1885 = -3 * phi2
            t1884 = 3 * phi2
            tfunc[..., c] = -(0.21e2 / 0.16384e5) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * ((-41990 * t1874 + 139230 * t1893 - 166140 * t1891 + 82940 * t1889 - 14430 * t1882 + 390) * np.exp((6*1j) * phi2) + (-t1896 + t1897) * np.exp((-2*1j) * (t1887 + t1885)) + (t1898 + t1899) * np.exp((-2*1j) * (t1886 + t1885)) + (t1896 + t1897) * np.exp((2*1j) * (t1887 + t1884)) + (t1898 - t1899) * np.exp((2*1j) * (t1886 + t1884)))

        if Bindx == 76:
            t1915 = np.cos(phi)
            t1914 = t1915 ** 2
            t1921 = t1914 ** 2
            t1920 = t1915 * t1914
            t1923 = t1920 ** 2
            t1925 = t1921 ** 2
            t1922 = t1915 * t1921
            t1927 = t1922 ** 2
            t1932 = 44 + 44 * t1914 - 1208 * t1921 + 1960 * t1923 - 308 * t1925 - 532 * t1927
            t1931 = 8 - 184 * t1914 + 2416 * t1921 - 7504 * t1923 + 8456 * t1925 - 3192 * t1927
            t1905 = t1915 * t1927
            t1907 = t1915 * t1925
            t1909 = t1915 * t1923
            t1930 = 95 * t1905 + 1013 * t1907 - 1514 * t1909 - 175 * t1915 + 763 * t1920 - 182 * t1922
            t1929 = 1140 * t1905 - 516 * t1907 - 4376 * t1909 + 364 * t1915 - 2716 * t1920 + 6104 * t1922
            t1919 = 4 * phi1
            t1918 = 8 * phi1
            t1917 = -7 * phi2
            t1916 = 7 * phi2
            tfunc[..., c] = (-0.21e2 / 0.8192e4*1j) * np.sqrt(0.11e2) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * ((1 + t1915) ** (-0.1e1 / 0.2e1)) * ((1 - t1915) ** (-0.1e1 / 0.2e1)) * ((-2470 * t1905 + 10270 * t1907 - 16380 * t1909 + 12220 * t1922 - 4030 * t1920 + 390 * t1915) * np.exp((7*1j) * phi2) + (t1929 + t1931) * np.exp((-1*1j) * (t1919 + t1917)) + (t1930 + t1932) * np.exp((-1*1j) * (t1918 + t1917)) + (t1929 - t1931) * np.exp((1j) * (t1919 + t1916)) + (t1930 - t1932) * np.exp((1j) * (t1918 + t1916)))

        if Bindx == 77:
            t1947 = np.cos(phi)
            t1946 = t1947 ** 2
            t1949 = t1946 ** 2
            t1953 = t1949 ** 2
            t1939 = t1947 * t1953
            t1948 = t1947 * t1946
            t1951 = t1948 ** 2
            t1941 = t1947 * t1951
            t1950 = t1947 * t1949
            t1959 = -608 * t1939 - 1536 * t1941 - 320 * t1947 + 192 * t1948 + 2016 * t1950
            t1958 = -3648 * t1939 + 7680 * t1941 + 384 * t1947 - 384 * t1948 - 4032 * t1950
            t1938 = t1950 ** 2
            t1957 = 59 + 95 * t1938 + 531 * t1946 - 1722 * t1949 - 210 * t1951 + 1503 * t1953
            t1956 = 132 + 1140 * t1938 - 1980 * t1946 + 6888 * t1949 - 7224 * t1951 + 1044 * t1953
            tfunc[..., c] = -(0.7e1 / 0.8192e4) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * np.sqrt(0.11e2) * ((-2470 * t1938 + 10010 * t1953 - 15340 * t1951 + 10660 * t1949 - 2990 * t1946 + 130) * np.exp((8*1j) * phi2) + (t1957 + t1959) * np.exp((-8*1j) * (phi1 - phi2)) + (t1956 + t1958) * np.exp((-4*1j) * (phi1 - 2 * phi2)) + (t1956 - t1958) * np.exp((4*1j) * (phi1 + 2 * phi2)) + (t1957 - t1959) * np.exp((8*1j) * (phi1 + phi2)))

        if Bindx == 78:
            t1974 = np.cos(phi)
            t1973 = t1974 ** 2
            t1980 = t1973 ** 2
            t1981 = t1974 * t1980
            t1965 = t1981 ** 2
            t1988 = 5 * t1965 - 84 * t1980 + 126 * t1981
            t1987 = 60 * t1965 + 336 * t1980 - 504 * t1981
            t1984 = t1980 ** 2
            t1979 = t1974 * t1973
            t1982 = t1979 ** 2
            t1978 = 4 * phi1
            t1977 = 8 * phi1
            t1976 = -9 * phi2
            t1975 = 9 * phi2
            t1968 = t1974 * t1982
            t1966 = t1974 * t1984
            tfunc[..., c] = (0.7e1 / 0.8192e4*1j) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * np.sqrt((1 - t1974)) * ((1 + t1974) ** (-0.1e1 / 0.2e1)) * (130 * (-t1965 - t1966 + 4 * t1984 + 4 * t1968 - 6 * t1982 - 6 * t1981 + 4 * t1980 + 4 * t1979 - t1973 - t1974) * np.exp((9*1j) * phi2) + (-156 * t1966 - 72 * t1984 + 480 * t1968 - 168 * t1982 + 192 * t1979 - 180 * t1973 - 12 * t1974 + 24 + t1987) * np.exp((-1*1j) * (t1978 + t1976)) + (-31 * t1966 + 72 * t1984 - 60 * t1968 - 42 * t1982 - 12 * t1979 + 45 * t1973 - 23 * t1974 + 4 + t1988) * np.exp((-1*1j) * (t1977 + t1976)) + (276 * t1966 + 360 * t1984 - 192 * t1968 - 840 * t1982 + 480 * t1979 + 108 * t1973 - 60 * t1974 - 24 + t1987) * np.exp((1j) * (t1978 + t1975)) + (41 * t1966 + 144 * t1984 + 276 * t1968 + 294 * t1982 - 156 * t1979 - 99 * t1973 - 31 * t1974 - 4 + t1988) * np.exp((1j) * (t1977 + t1975)))

        if Bindx == 79:
            t2002 = np.cos(phi)
            t2001 = t2002 ** 2
            t2008 = t2001 ** 2
            t2011 = t2008 ** 2
            t2012 = t2002 * t2011
            t2018 = t2002 - t2012
            t2007 = t2002 * t2001
            t2009 = t2007 ** 2
            t1997 = t2002 * t2009
            t2017 = -48 * t1997 + 48 * t2007 + 8 * t2018
            t2016 = 96 * t1997 - 96 * t2007 + 48 * t2018
            t1994 = t2002 * t2012
            t2015 = 1 - t1994 + 27 * t2001 + 42 * t2008 - 42 * t2009 - 27 * t2011
            t2014 = 12 - 12 * t1994 + 36 * t2001 - 168 * t2008 + 168 * t2009 - 36 * t2011
            t2006 = 2 * phi1
            t2005 = 4 * phi1
            t2004 = -5 * phi2
            t2003 = 5 * phi2
            tfunc[..., c] = (0.7e1 / 0.16384e5) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.11e2) * np.sqrt(0.17e2) * np.sqrt(0.19e2) * ((26 * t1994 - 130 * t2011 + 260 * t2009 - 260 * t2008 + 130 * t2001 - 26) * np.exp((10*1j) * phi2) + (t2015 - t2017) * np.exp((-2*1j) * (t2005 + t2004)) + (t2015 + t2017) * np.exp((2*1j) * (t2005 + t2003)) + (t2014 - t2016) * np.exp((-2*1j) * (t2006 + t2004)) + (t2014 + t2016) * np.exp((2*1j) * (t2006 + t2003)))

        if Bindx == 80:
            t2035 = np.cos(phi)
            t2034 = t2035 ** 2
            t2040 = t2034 ** 2
            t2041 = t2035 * t2040
            t2046 = t2041 ** 2
            t2053 = (-t2046 - 1) * t2035
            t2044 = t2040 ** 2
            t2027 = t2035 * t2044
            t2039 = t2035 * t2034
            t2042 = t2039 ** 2
            t2029 = t2035 * t2042
            t2052 = -40 * t2027 + 48 * t2029 - 40 * t2039 + 48 * t2041 + 8 * t2053
            t2051 = 48 * t2027 - 32 * t2029 + 48 * t2039 - 32 * t2041 + 16 * t2053
            t2024 = t2042 ** 2
            t2050 = 4 + 4 * t2024 + 8 * t2034 - 68 * t2040 + 112 * t2042 - 68 * t2044 + 8 * t2046
            t2049 = -1 - t2024 - 26 * t2034 - 15 * t2040 + 84 * t2042 - 15 * t2044 - 26 * t2046
            t2038 = 2 * phi1
            t2037 = -3 * phi2
            t2036 = 3 * phi2
            tfunc[..., c] = -(0.15e2 / 0.671744e6) * np.sqrt(0.11e2) * np.sqrt(0.41e2) * np.sqrt(0.13e2) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * ((-6 * t2024 + 36 * t2046 - 90 * t2044 + 120 * t2042 - 90 * t2040 + 36 * t2034 - 6) * np.exp((-12*1j) * phi2) + (t2049 + t2052) * np.exp((-4*1j) * (t2038 + t2036)) + (t2049 - t2052) * np.exp((4*1j) * (t2038 + t2037)) + (t2050 - t2051) * np.exp((-4*1j) * (phi1 + t2036)) + (t2050 + t2051) * np.exp((4*1j) * (phi1 + t2037)))

        if Bindx == 81:
            t2072 = np.cos(phi)
            t2071 = t2072 ** 2
            t2077 = t2071 ** 2
            t2081 = t2077 ** 2
            t2094 = t2081 + t2077
            t2078 = t2072 * t2077
            t2083 = t2078 ** 2
            t2093 = t2083 + t2071
            t2062 = t2072 * t2083
            t2092 = -t2062 - t2072
            t2076 = t2072 * t2071
            t2079 = t2076 ** 2
            t2061 = t2079 ** 2
            t2091 = 1025 * t2061 + 67650 * t2071 + 947100 * t2079 + 67650 * t2083 + 507375 * t2094 + 1025
            t2064 = t2072 * t2081
            t2066 = t2072 * t2079
            t2090 = -12300 * t2062 - 12300 * t2072 - 811800 * t2066 - 811800 * t2078 - 225500 * t2064 - 225500 * t2076
            t2089 = 510048 * t2066 + 510048 * t2078 - 425040 * t2064 - 425040 * t2076 + 85008 * t2092
            t2088 = 10626 * t2061 - 892584 * t2079 + 276276 * t2093 + 159390 * t2094 + 10626
            t2087 = 8825652 * t2064 + 8825652 * t2076 - 5883768 * t2066 - 5883768 * t2078 + 2941884 * t2092
            t2086 = 735471 * t2061 + 20593188 * t2079 + 1470942 * t2093 - 12503007 * t2094 + 735471
            t2075 = 2 * phi1
            t2074 = -3 * phi2
            t2073 = 3 * phi2
            tfunc[..., c] = (0.5e1 / 0.32243712e8) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * ((-54083120 * t2079 + 2704156 * t2061 + 2704156 + 40562340 * t2081 + 40562340 * t2077 - 16224936 * t2083 - 16224936 * t2071) * np.exp((-12*1j) * phi2) + (t2086 - t2087) * np.exp((-4*1j) * (phi1 + t2073)) + (t2088 - t2089) * np.exp((-4*1j) * (t2075 + t2073)) + (t2086 + t2087) * np.exp((4*1j) * (phi1 + t2074)) + (t2088 + t2089) * np.exp((4*1j) * (t2075 + t2074)) + (-t2090 + t2091) * np.exp((-12*1j) * (phi1 + phi2)) + (t2090 + t2091) * np.exp((12*1j) * (phi1 - phi2)))

        if Bindx == 82:
            t2110 = np.cos(phi)
            t2109 = t2110 ** 2
            t2116 = t2109 ** 2
            t2117 = t2110 * t2116
            t2122 = t2117 ** 2
            t2100 = t2110 * t2122
            t2125 = 3 * t2100
            t2124 = 1 - t2110
            t2120 = t2116 ** 2
            t2115 = t2110 * t2109
            t2118 = t2115 ** 2
            t2114 = 4 * phi1
            t2113 = 8 * phi1
            t2112 = -11 * phi2
            t2111 = 11 * phi2
            t2104 = t2110 * t2118
            t2102 = t2110 * t2120
            tfunc[..., c] = (0.5e1 / 0.335872e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * np.sqrt(0.41e2) * np.sqrt(0.11e2) * ((1 + t2110) ** (0.3e1 / 0.2e1)) * (t2124 ** (-0.1e1 / 0.2e1)) * (18 * (t2100 - 2 * t2122 - 3 * t2102 + 8 * t2120 + 2 * t2104 - 12 * t2118 + 2 * t2117 + 8 * t2116 - 3 * t2115 - 2 * t2109 + t2110) * np.exp((-11*1j) * phi2) + 4 * (-3 * t2100 - 5 * t2122 + 11 * t2102 + 21 * t2120 - 14 * t2104 - 34 * t2118 + 6 * t2117 + 26 * t2116 + t2115 - 9 * t2109 + t2124) * np.exp((-1*1j) * (t2114 + t2111)) + (t2125 + 16 * t2122 + 27 * t2102 - 2 * t2120 - 58 * t2104 - 56 * t2118 + 14 * t2117 + 52 * t2116 + 23 * t2115 - 8 * t2109 - 9 * t2110 - 2) * np.exp((-1*1j) * (t2113 + t2111)) + (-12 * t2100 + 68 * t2122 - 132 * t2102 + 44 * t2120 + 200 * t2104 - 280 * t2118 + 56 * t2117 + 152 * t2116 - 124 * t2115 + 20 * t2109 + 12 * t2110 - 4) * np.exp((1j) * (t2114 + t2112)) + (t2125 - 28 * t2122 + 115 * t2102 - 270 * t2120 + 390 * t2104 - 336 * t2118 + 126 * t2117 + 60 * t2116 - 105 * t2115 + 60 * t2109 - 17 * t2110 + 2) * np.exp((1j) * (t2113 + t2112)))

        if Bindx == 83:
            t2144 = np.cos(phi)
            t2143 = t2144 ** 2
            t2150 = t2144 * t2143
            t2153 = t2150 ** 2
            t2133 = t2153 ** 2
            t2162 = 1025 * t2133
            t2161 = 10626 * t2133
            t2160 = 735471 * t2133
            t2151 = t2143 ** 2
            t2152 = t2144 * t2151
            t2157 = t2152 ** 2
            t2155 = t2151 ** 2
            t2149 = 4 * phi1
            t2148 = 8 * phi1
            t2147 = 12 * phi1
            t2146 = -11 * phi2
            t2145 = 11 * phi2
            t2138 = t2144 * t2153
            t2136 = t2144 * t2155
            t2134 = t2144 * t2157
            tfunc[..., c] = (0.5e1 / 0.2686976e7*1j) * np.sqrt(0.41e2) * np.sqrt((1 + t2144)) * ((1 - t2144) ** (-0.1e1 / 0.2e1)) * (2704156 * (10 * t2155 - 10 * t2138 - 10 * t2153 + 10 * t2152 - 5 * t2157 + 5 * t2136 + 5 * t2151 - 5 * t2150 + t2133 - t2134 - t2143 + t2144) * np.exp((-11*1j) * phi2) + (-1716099 * t2155 - 7845024 * t2136 + 11767536 * t2138 + 2451570 * t2143 - 6619239 * t2151 - 7845024 * t2152 + 6864396 * t2153 - 1470942 * t2157 + t2160 - 245157 + 1961256 * t2134 + 1961256 * t2150) * np.exp((-1*1j) * (t2149 + t2145)) + (t2162 + 10250 * t2134 + 45100 * t2157 - 45100 * t2143 - 10250 * t2144 - 1025 + 169125 * t2155 - 169125 * t2151 + 135300 * t2138 - 135300 * t2152 + 112750 * t2136 - 112750 * t2150) * np.exp((-1*1j) * (t2147 + t2145)) + (67298 * t2134 + 88550 * t2136 - 403788 * t2138 - 60214 * t2143 - 38962 * t2144 + 53130 * t2150 + 265650 * t2151 + 233772 * t2152 - 148764 * t2153 - 212520 * t2155 + 152306 * t2157 + t2161 - 7084) * np.exp((-1*1j) * (t2148 + t2145)) + (-3432198 * t2134 + 5393454 * t2136 + 4903140 * t2138 - 1961256 * t2143 - 490314 * t2144 + 6374082 * t2150 - 1716099 * t2151 - 12748164 * t2152 + 13728792 * t2153 - 14954577 * t2155 + 3922512 * t2157 + t2160 + 245157) * np.exp((1j) * (t2149 + t2146)) + (-88550 * t2134 - 549010 * t2136 + 191268 * t2138 + 152306 * t2143 - 53130 * t2144 - 159390 * t2150 - 159390 * t2151 + 658812 * t2152 - 743820 * t2153 + 425040 * t2155 + 308154 * t2157 + t2161 + 7084) * np.exp((1j) * (t2148 + t2146)) + (t2162 - 12300 * t2134 + 67650 * t2157 + 947100 * t2153 + 67650 * t2143 - 12300 * t2144 + 1025 - 811800 * t2138 - 811800 * t2152 + 507375 * t2155 + 507375 * t2151 - 225500 * t2136 - 225500 * t2150) * np.exp((1j) * (t2147 + t2146)))

        if Bindx == 84:
            t2179 = np.cos(phi)
            t2178 = t2179 ** 2
            t2185 = t2178 ** 2
            t2186 = t2179 * t2185
            t2191 = t2186 ** 2
            t2169 = t2179 * t2191
            t2189 = t2185 ** 2
            t2171 = t2179 * t2189
            t2184 = t2179 * t2178
            t2187 = t2184 ** 2
            t2173 = t2179 * t2187
            t2197 = -920 * t2169 + 2680 * t2171 - 2416 * t2173 - 104 * t2179 + 392 * t2184 + 368 * t2186
            t2196 = -460 * t2169 - 1060 * t2171 + 2472 * t2173 + 140 * t2179 - 540 * t2184 - 552 * t2186
            t2168 = t2187 ** 2
            t2195 = -29 + 69 * t2168 - 116 * t2178 + 1335 * t2185 - 1680 * t2187 - 735 * t2189 + 1156 * t2191
            t2194 = 20 - 276 * t2168 - 400 * t2178 + 2020 * t2185 - 3584 * t2187 + 2332 * t2189 - 112 * t2191
            t2183 = 2 * phi1
            t2182 = 4 * phi1
            t2181 = -5 * phi2
            t2180 = 5 * phi2
            tfunc[..., c] = (0.5e1 / 0.335872e6) * np.sqrt(0.7e1) * np.sqrt(0.11e2) * np.sqrt(0.41e2) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * ((414 * t2168 - 2088 * t2191 + 4230 * t2189 - 4320 * t2187 + 2250 * t2185 - 504 * t2178 + 18) * np.exp((-10*1j) * phi2) + (t2194 + t2197) * np.exp((-2*1j) * (t2183 + t2180)) + (t2195 - t2196) * np.exp((-2*1j) * (t2182 + t2180)) + (t2194 - t2197) * np.exp((2*1j) * (t2183 + t2181)) + (t2195 + t2196) * np.exp((2*1j) * (t2182 + t2181)))

        if Bindx == 85:
            t2216 = np.cos(phi)
            t2215 = t2216 ** 2
            t2222 = t2216 * t2215
            t2225 = t2222 ** 2
            t2205 = t2225 ** 2
            t2223 = t2215 ** 2
            t2227 = t2223 ** 2
            t2224 = t2216 * t2223
            t2229 = t2224 ** 2
            t2237 = 1025 * t2205 - 45100 * t2215 + 45100 * t2229 - 1025 + 169125 * t2227 - 169125 * t2223
            t2206 = t2216 * t2229
            t2208 = t2216 * t2227
            t2210 = t2216 * t2225
            t2236 = -70840 * t2206 - 163240 * t2208 + 380688 * t2210 + 21560 * t2216 - 83160 * t2222 - 85008 * t2224
            t2235 = -10250 * t2206 + 10250 * t2216 - 135300 * t2210 + 135300 * t2224 - 112750 * t2208 + 112750 * t2222
            t2234 = 10626 * t2205 - 17864 * t2215 + 205590 * t2223 - 258720 * t2225 - 113190 * t2227 + 178024 * t2229 - 4466
            t2233 = -2451570 * t2206 + 7141530 * t2208 - 6438036 * t2210 - 277134 * t2216 + 1044582 * t2222 + 980628 * t2224
            t2232 = 735471 * t2205 + 1065900 * t2215 - 5382795 * t2223 + 9550464 * t2225 - 6214197 * t2227 + 298452 * t2229 - 53295
            t2221 = 2 * phi1
            t2220 = 4 * phi1
            t2219 = 6 * phi1
            t2218 = -5 * phi2
            t2217 = 5 * phi2
            tfunc[..., c] = (0.5e1 / 0.5373952e7) * np.sqrt(0.2e1) * np.sqrt(0.41e2) * np.sqrt(0.23e2) * ((2704156 * t2205 - 13638352 * t2229 + 27629420 * t2227 - 28217280 * t2225 + 14696500 * t2223 - 3292016 * t2215 + 117572) * np.exp((-10*1j) * phi2) + (-t2235 + t2237) * np.exp((-2*1j) * (t2219 + t2217)) + (t2235 + t2237) * np.exp((2*1j) * (t2219 + t2218)) + (t2232 - t2233) * np.exp((-2*1j) * (t2221 + t2217)) + (t2234 - t2236) * np.exp((-2*1j) * (t2220 + t2217)) + (t2232 + t2233) * np.exp((2*1j) * (t2221 + t2218)) + (t2234 + t2236) * np.exp((2*1j) * (t2220 + t2218)))

        if Bindx == 86:
            t2254 = np.cos(phi)
            t2253 = t2254 ** 2
            t2259 = t2254 * t2253
            t2262 = t2259 ** 2
            t2243 = t2262 ** 2
            t2270 = 253 * t2243
            t2269 = -1012 * t2243
            t2260 = t2253 ** 2
            t2261 = t2254 * t2260
            t2266 = t2261 ** 2
            t2264 = t2260 ** 2
            t2258 = 4 * phi1
            t2257 = 8 * phi1
            t2256 = -9 * phi2
            t2255 = 9 * phi2
            t2248 = t2254 * t2262
            t2246 = t2254 * t2264
            t2244 = t2254 * t2266
            tfunc[..., c] = (0.15e2 / 0.335872e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * np.sqrt(0.41e2) * np.sqrt((1 + t2254)) * ((1 - t2254) ** (-0.1e1 / 0.2e1)) * ((1518 * t2243 - 1518 * t2244 - 6270 * t2266 + 6270 * t2246 + 9900 * t2264 - 9900 * t2248 - 7260 * t2262 + 7260 * t2261 + 2310 * t2260 - 2310 * t2259 - 198 * t2253 + 198 * t2254) * np.exp((-9*1j) * phi2) + (t2269 - 2024 * t2244 + 2816 * t2266 + 7432 * t2246 - 2036 * t2264 - 10384 * t2248 - 672 * t2262 + 6800 * t2261 + 1252 * t2260 - 2056 * t2259 - 352 * t2253 + 232 * t2254 + 4) * np.exp((-1*1j) * (t2258 + t2255)) + (t2270 + 1265 * t2244 + 1837 * t2266 - 865 * t2246 - 4680 * t2264 - 2934 * t2248 + 2730 * t2262 + 3774 * t2261 + 285 * t2260 - 1355 * t2259 - 487 * t2253 + 115 * t2254 + 62) * np.exp((-1*1j) * (t2257 + t2255)) + (t2269 + 4048 * t2244 - 3256 * t2266 - 6992 * t2246 + 12388 * t2264 + 32 * t2248 - 11088 * t2262 + 4960 * t2261 + 3092 * t2260 - 2288 * t2259 - 120 * t2253 + 240 * t2254 - 4) * np.exp((1j) * (t2258 + t2256)) + (t2270 - 1771 * t2244 + 4873 * t2266 - 5845 * t2246 + 300 * t2264 + 7314 * t2248 - 7518 * t2262 + 1014 * t2261 + 3045 * t2260 - 1975 * t2259 + 133 * t2253 + 239 * t2254 - 62) * np.exp((1j) * (t2257 + t2256)))

        if Bindx == 87:
            t2289 = np.cos(phi)
            t2288 = t2289 ** 2
            t2294 = t2289 * t2288
            t2297 = t2294 ** 2
            t2278 = t2297 ** 2
            t2306 = 1025 * t2278
            t2305 = 10626 * t2278
            t2304 = 735471 * t2278
            t2295 = t2288 ** 2
            t2296 = t2289 * t2295
            t2301 = t2296 ** 2
            t2299 = t2295 ** 2
            t2293 = 4 * phi1
            t2292 = 8 * phi1
            t2291 = -9 * phi2
            t2290 = 9 * phi2
            t2283 = t2289 * t2297
            t2281 = t2289 * t2299
            t2279 = t2289 * t2301
            tfunc[..., c] = (0.5e1 / 0.8060928e7*1j) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.41e2) * np.sqrt(0.3e1) * np.sqrt((1 + t2289)) * ((1 - t2289) ** (-0.1e1 / 0.2e1)) * ((17635800 * t2299 - 17635800 * t2283 - 12932920 * t2297 + 12932920 * t2296 - 11169340 * t2301 + 11169340 * t2281 + 4115020 * t2295 - 4115020 * t2294 + 2704156 * t2278 - 2704156 * t2279 - 352716 * t2288 + 352716 * t2289) * np.exp((-9*1j) * phi2) + (t2306 - 10250 * t2279 + 45100 * t2301 - 45100 * t2288 + 10250 * t2289 - 1025 + 169125 * t2299 - 169125 * t2295 - 135300 * t2283 + 135300 * t2296 - 112750 * t2281 + 112750 * t2294) * np.exp((3*1j) * (t2293 - 3 * phi2)) + (t2306 + 8200 * t2279 + 26650 * t2301 + 41000 * t2281 + 15375 * t2299 - 49200 * t2283 - 86100 * t2297 - 49200 * t2296 + 15375 * t2295 + 41000 * t2294 + 26650 * t2288 + 8200 * t2289 + 1025) * np.exp((-3*1j) * (t2293 + 3 * phi2)) + (1470942 * t2279 - 5401206 * t2281 + 7546572 * t2283 + 255816 * t2288 - 168606 * t2289 + 1494198 * t2294 - 909891 * t2295 - 4941900 * t2296 + 488376 * t2297 + 1479663 * t2299 - 2046528 * t2301 - 2907 + t2304) * np.exp((-1*1j) * (t2293 + t2290)) + (t2305 + 53130 * t2279 + 77154 * t2301 - 36330 * t2281 - 196560 * t2299 - 123228 * t2283 + 114660 * t2297 + 158508 * t2296 + 11970 * t2295 - 56910 * t2294 - 20454 * t2288 + 4830 * t2289 + 2604) * np.exp((-1*1j) * (t2292 + t2290)) + (-2941884 * t2279 + 5081436 * t2281 - 23256 * t2283 + 87210 * t2288 - 174420 * t2289 + 1662804 * t2294 - 2247111 * t2295 - 3604680 * t2296 + 8058204 * t2297 - 9002979 * t2299 + 2366298 * t2301 + 2907 + t2304) * np.exp((1j) * (t2293 + t2291)) + (t2305 - 74382 * t2279 + 204666 * t2301 - 245490 * t2281 + 12600 * t2299 + 307188 * t2283 - 315756 * t2297 + 42588 * t2296 + 127890 * t2295 - 82950 * t2294 + 5586 * t2288 + 10038 * t2289 - 2604) * np.exp((1j) * (t2292 + t2291)))

        if Bindx == 88:
            t2323 = np.cos(phi)
            t2322 = t2323 ** 2
            t2325 = t2322 ** 2
            t2326 = t2323 * t2325
            t2331 = t2326 ** 2
            t2313 = t2323 * t2331
            t2329 = t2325 ** 2
            t2315 = t2323 * t2329
            t2324 = t2323 * t2322
            t2327 = t2324 ** 2
            t2317 = t2323 * t2327
            t2337 = -28336 * t2313 - 2800 * t2315 + 84384 * t2317 - 176 * t2323 + 15120 * t2324 - 69216 * t2326
            t2312 = t2327 ** 2
            t2336 = -673 - 5313 * t2312 + 9422 * t2322 - 22575 * t2325 - 20412 * t2327 + 87345 * t2329 - 48818 * t2331
            t2335 = 21252 * t2312 + 9576 * t2322 - 53956 * t2325 + 103600 * t2327 - 61124 * t2329 - 19096 * t2331 - 252
            t2334 = 56672 * t2313 - 161056 * t2315 + 161728 * t2317 - 672 * t2323 + 10976 * t2324 - 67648 * t2326
            tfunc[..., c] = -(0.5e1 / 0.671744e6) * np.sqrt(0.41e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.17e2) * ((-31878 * t2312 + 135828 * t2331 - 224730 * t2329 + 178200 * t2327 - 66330 * t2325 + 9108 * t2322 - 198) * np.exp((-8*1j) * phi2) + (t2336 + t2337) * np.exp((-8*1j) * (phi1 + phi2)) + (t2334 + t2335) * np.exp((-4*1j) * (phi1 + 2 * phi2)) + (-t2334 + t2335) * np.exp((4*1j) * (phi1 - 2 * phi2)) + (t2336 - t2337) * np.exp((8*1j) * (phi1 - phi2)))

        if Bindx == 89:
            t2356 = np.cos(phi)
            t2355 = t2356 ** 2
            t2361 = t2355 ** 2
            t2362 = t2356 * t2361
            t2367 = t2362 ** 2
            t2346 = t2356 * t2367
            t2365 = t2361 ** 2
            t2348 = t2356 * t2365
            t2360 = t2356 * t2355
            t2363 = t2360 ** 2
            t2350 = t2356 * t2363
            t2375 = -8200 * t2346 - 41000 * t2348 + 49200 * t2350 - 8200 * t2356 - 41000 * t2360 + 49200 * t2362
            t2345 = t2363 ** 2
            t2374 = 1025 + 1025 * t2345 + 26650 * t2355 + 15375 * t2361 - 86100 * t2363 + 15375 * t2365 + 26650 * t2367
            t2373 = 10626 * t2345 - 18844 * t2355 + 45150 * t2361 + 40824 * t2363 - 174690 * t2365 + 97636 * t2367 + 1346
            t2372 = 56672 * t2346 + 5600 * t2348 - 168768 * t2350 + 352 * t2356 - 30240 * t2360 + 138432 * t2362
            t2371 = -1961256 * t2346 + 5573688 * t2348 - 5596944 * t2350 + 23256 * t2356 - 379848 * t2360 + 2341104 * t2362
            t2370 = 735471 * t2345 + 331398 * t2355 - 1867263 * t2361 + 3585300 * t2363 - 2115327 * t2365 - 660858 * t2367 - 8721
            t2359 = 3 * phi1
            t2358 = -2 * phi2
            t2357 = 2 * phi2
            tfunc[..., c] = (0.5e1 / 0.5373952e7) * np.sqrt(0.41e2) * np.sqrt(0.11e2) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * ((2704156 * t2345 - 11522056 * t2367 + 19063460 * t2365 - 15116400 * t2363 + 5626660 * t2361 - 772616 * t2355 + 16796) * np.exp((-8*1j) * phi2) + (t2372 + t2373) * np.exp((-8*1j) * (phi1 + phi2)) + (t2370 - t2371) * np.exp((-4*1j) * (phi1 + t2357)) + (t2374 - t2375) * np.exp((-4*1j) * (t2359 + t2357)) + (t2370 + t2371) * np.exp((4*1j) * (phi1 + t2358)) + (t2374 + t2375) * np.exp((4*1j) * (t2359 + t2358)) + (-t2372 + t2373) * np.exp((8*1j) * (phi1 - phi2)))

        if Bindx == 90:
            t2393 = np.cos(phi)
            t2392 = t2393 ** 2
            t2399 = t2392 ** 2
            t2398 = t2393 * t2392
            t2401 = t2398 ** 2
            t2403 = t2399 ** 2
            t2400 = t2393 * t2399
            t2405 = t2400 ** 2
            t2407 = t2401 ** 2
            t2412 = 278 - 6116 * t2392 + 34650 * t2399 - 66360 * t2401 + 29610 * t2403 + 32732 * t2405 - 24794 * t2407
            t2381 = t2393 * t2407
            t2383 = t2393 * t2405
            t2385 = t2393 * t2403
            t2387 = t2393 * t2401
            t2411 = -21252 * t2381 + 41272 * t2383 + 7140 * t2385 - 64624 * t2387 + 924 * t2393 - 13384 * t2398 + 49924 * t2400
            t2410 = 5313 * t2381 + 29414 * t2383 - 95405 * t2385 + 82980 * t2387 + 1141 * t2393 - 3178 * t2398 - 20265 * t2400
            t2409 = -3864 * t2392 + 33740 * t2399 - 121296 * t2401 + 205996 * t2403 - 164248 * t2405 + 49588 * t2407 + 84
            t2397 = 4 * phi1
            t2396 = 8 * phi1
            t2395 = -7 * phi2
            t2394 = 7 * phi2
            tfunc[..., c] = (0.5e1 / 0.335872e6*1j) * np.sqrt(0.17e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * np.sqrt(0.2e1) * np.sqrt(0.41e2) * ((1 + t2393) ** (-0.1e1 / 0.2e1)) * ((1 - t2393) ** (-0.1e1 / 0.2e1)) * ((31878 * t2381 - 141372 * t2383 + 247698 * t2385 - 214632 * t2387 + 93258 * t2400 - 17820 * t2398 + 990 * t2393) * np.exp((-7*1j) * phi2) + (-t2409 + t2411) * np.exp((-1*1j) * (t2397 + t2394)) + (t2410 - t2412) * np.exp((-1*1j) * (t2396 + t2394)) + (t2409 + t2411) * np.exp((1j) * (t2397 + t2395)) + (t2410 + t2412) * np.exp((1j) * (t2396 + t2395)))

        if Bindx == 91:
            t2432 = np.cos(phi)
            t2431 = t2432 ** 2
            t2439 = t2431 ** 2
            t2438 = t2432 * t2431
            t2441 = t2438 ** 2
            t2443 = t2439 ** 2
            t2440 = t2432 * t2439
            t2445 = t2440 ** 2
            t2447 = t2441 ** 2
            t2454 = -1025 - 18450 * t2431 + 25625 * t2439 + 36900 * t2441 - 64575 * t2443 + 14350 * t2445 + 7175 * t2447
            t2420 = t2432 * t2447
            t2422 = t2432 * t2445
            t2424 = t2432 * t2443
            t2426 = t2432 * t2441
            t2453 = 1025 * t2420 + 18450 * t2422 - 25625 * t2424 - 36900 * t2426 - 7175 * t2432 - 14350 * t2438 + 64575 * t2440
            t2452 = -12232 * t2431 + 69300 * t2439 - 132720 * t2441 + 59220 * t2443 + 65464 * t2445 - 49588 * t2447 + 556
            t2451 = 10626 * t2420 + 58828 * t2422 - 190810 * t2424 + 165960 * t2426 + 2282 * t2432 - 6356 * t2438 - 40530 * t2440
            t2450 = -133722 * t2431 + 1167645 * t2439 - 4197708 * t2441 + 7128933 * t2443 - 5684154 * t2445 + 1716099 * t2447 + 2907
            t2449 = 735471 * t2420 - 1428306 * t2422 - 247095 * t2424 + 2236452 * t2426 - 31977 * t2432 + 463182 * t2438 - 1727727 * t2440
            t2437 = 4 * phi1
            t2436 = 8 * phi1
            t2435 = -7 * phi2
            t2434 = 7 * phi2
            t2433 = 12 * phi1
            tfunc[..., c] = (0.5e1 / 0.2686976e7*1j) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * np.sqrt(0.11e2) * np.sqrt(0.41e2) * ((1 + t2432) ** (-0.1e1 / 0.2e1)) * ((1 - t2432) ** (-0.1e1 / 0.2e1)) * ((-18206864 * t2426 + 7910916 * t2440 - 1511640 * t2438 + 83980 * t2432 + 2704156 * t2420 - 11992344 * t2422 + 21011796 * t2424) * np.exp((-7*1j) * phi2) + (t2449 + t2450) * np.exp((-1*1j) * (t2437 + t2434)) + (t2451 - t2452) * np.exp((-1*1j) * (t2436 + t2434)) + (t2449 - t2450) * np.exp((1j) * (t2437 + t2435)) + (t2451 + t2452) * np.exp((1j) * (t2436 + t2435)) + (t2453 + t2454) * np.exp((-1*1j) * (t2433 + t2434)) + (t2453 - t2454) * np.exp((1j) * (t2433 + t2435)))

        if Bindx == 92:
            t2471 = np.cos(phi)
            t2470 = t2471 ** 2
            t2477 = t2470 ** 2
            t2478 = t2471 * t2477
            t2483 = t2478 ** 2
            t2461 = t2471 * t2483
            t2481 = t2477 ** 2
            t2463 = t2471 * t2481
            t2476 = t2471 * t2470
            t2479 = t2476 ** 2
            t2465 = t2471 * t2479
            t2489 = -134596 * t2461 + 217588 * t2463 - 7752 * t2465 - 7676 * t2471 + 63308 * t2476 - 130872 * t2478
            t2460 = t2479 ** 2
            t2488 = 134596 * t2460 + 10192 * t2470 - 68180 * t2477 + 103936 * t2479 + 77140 * t2481 - 257488 * t2483 - 196
            t2487 = -269192 * t2461 + 750120 * t2463 - 768208 * t2465 + 3976 * t2471 - 69160 * t2476 + 352464 * t2478
            t2486 = -33649 * t2460 - 10108 * t2470 + 106533 * t2477 - 338352 * t2479 + 386403 * t2481 - 111188 * t2483 + 361
            t2475 = 2 * phi1
            t2474 = 4 * phi1
            t2473 = -3 * phi2
            t2472 = 3 * phi2
            tfunc[..., c] = -(0.15e2 / 0.335872e6) * np.sqrt(0.41e2) * np.sqrt(0.13e2) * np.sqrt(0.17e2) * ((-201894 * t2460 + 737352 * t2483 - 1019502 * t2481 + 653664 * t2479 - 189090 * t2477 + 19800 * t2470 - 330) * np.exp((-6*1j) * phi2) + (-t2487 + t2488) * np.exp((-2*1j) * (t2475 + t2472)) + (t2486 + t2489) * np.exp((-2*1j) * (t2474 + t2472)) + (t2487 + t2488) * np.exp((2*1j) * (t2475 + t2473)) + (t2486 - t2489) * np.exp((2*1j) * (t2474 + t2473)))

        if Bindx == 93:
            t2508 = np.cos(phi)
            t2507 = t2508 ** 2
            t2513 = t2508 * t2507
            t2516 = t2513 ** 2
            t2497 = t2516 ** 2
            t2514 = t2507 ** 2
            t2518 = t2514 ** 2
            t2515 = t2508 * t2514
            t2520 = t2515 ** 2
            t2528 = -1025 + 1025 * t2497 - 12300 * t2507 + 27675 * t2514 - 27675 * t2518 + 12300 * t2520
            t2498 = t2508 * t2520
            t2500 = t2508 * t2518
            t2502 = t2508 * t2516
            t2527 = -6150 * t2498 - 2050 * t2500 + 36900 * t2502 + 6150 * t2508 + 2050 * t2513 - 36900 * t2515
            t2526 = -42504 * t2498 + 68712 * t2500 - 2448 * t2502 - 2424 * t2508 + 19992 * t2513 - 41328 * t2515
            t2525 = 10626 * t2497 + 3192 * t2507 - 33642 * t2514 + 106848 * t2516 - 122022 * t2518 + 35112 * t2520 - 114
            t2524 = -1470942 * t2498 + 4098870 * t2500 - 4197708 * t2502 + 21726 * t2508 - 377910 * t2513 + 1925964 * t2515
            t2523 = 735471 * t2497 + 55692 * t2507 - 372555 * t2514 + 567936 * t2516 + 421515 * t2518 - 1406988 * t2520 - 1071
            t2512 = 2 * phi1
            t2511 = 4 * phi1
            t2510 = -3 * phi2
            t2509 = 3 * phi2
            tfunc[..., c] = (0.5e1 / 0.16121856e8) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.11e2) * np.sqrt(0.19e2) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * ((2704156 * t2497 - 9876048 * t2520 + 13655148 * t2518 - 8755136 * t2516 + 2532660 * t2514 - 265200 * t2507 + 4420) * np.exp((-6*1j) * phi2) + (-t2527 + t2528) * np.exp((-6*1j) * (t2512 + phi2)) + (t2527 + t2528) * np.exp((6*1j) * (t2512 - phi2)) + (t2523 - t2524) * np.exp((-2*1j) * (t2512 + t2509)) + (t2525 - t2526) * np.exp((-2*1j) * (t2511 + t2509)) + (t2523 + t2524) * np.exp((2*1j) * (t2512 + t2510)) + (t2525 + t2526) * np.exp((2*1j) * (t2511 + t2510)))

        if Bindx == 94:
            t2546 = np.cos(phi)
            t2545 = t2546 ** 2
            t2552 = t2545 ** 2
            t2551 = t2546 * t2545
            t2554 = t2551 ** 2
            t2556 = t2552 ** 2
            t2553 = t2546 * t2552
            t2558 = t2553 ** 2
            t2560 = t2554 ** 2
            t2565 = -11628 * t2545 + 26562 * t2552 + 94392 * t2554 - 367878 * t2556 + 402420 * t2558 - 144210 * t2560 + 342
            t2534 = t2546 * t2560
            t2536 = t2546 * t2558
            t2538 = t2546 * t2556
            t2540 = t2546 * t2554
            t2564 = 43263 * t2534 + 21318 * t2536 - 341487 * t2538 + 506388 * t2540 - 5985 * t2546 + 72390 * t2551 - 295887 * t2553
            t2563 = -173052 * t2534 + 486552 * t2536 - 475380 * t2538 + 174480 * t2540 + 404 * t2546 - 5544 * t2551 - 7460 * t2553
            t2562 = 19720 * t2545 - 189820 * t2552 + 690736 * t2554 - 1173516 * t2556 + 941640 * t2558 - 288420 * t2560 - 340
            t2550 = 4 * phi1
            t2549 = 8 * phi1
            t2548 = -5 * phi2
            t2547 = 5 * phi2
            tfunc[..., c] = (0.5e1 / 0.335872e6*1j) * np.sqrt(0.41e2) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * ((1 + t2546) ** (-0.1e1 / 0.2e1)) * ((1 - t2546) ** (-0.1e1 / 0.2e1)) * ((259578 * t2534 - 1015740 * t2536 + 1546182 * t2538 - 1142856 * t2540 + 415206 * t2553 - 65340 * t2551 + 2970 * t2546) * np.exp((-5*1j) * phi2) + (t2562 + t2563) * np.exp((-1*1j) * (t2550 + t2547)) + (t2564 - t2565) * np.exp((-1*1j) * (t2549 + t2547)) + (-t2562 + t2563) * np.exp((1j) * (t2550 + t2548)) + (t2564 + t2565) * np.exp((1j) * (t2549 + t2548)))

        if Bindx == 95:
            t2585 = np.cos(phi)
            t2584 = t2585 ** 2
            t2592 = t2584 ** 2
            t2591 = t2585 * t2584
            t2594 = t2591 ** 2
            t2596 = t2592 ** 2
            t2593 = t2585 * t2592
            t2598 = t2593 ** 2
            t2600 = t2594 ** 2
            t2607 = 84 - 2856 * t2584 + 6524 * t2592 + 23184 * t2594 - 90356 * t2596 + 98840 * t2598 - 35420 * t2600
            t2606 = -1025 - 6150 * t2584 + 29725 * t2592 - 36900 * t2594 + 9225 * t2596 + 10250 * t2598 - 5125 * t2600
            t2573 = t2585 * t2600
            t2575 = t2585 * t2598
            t2577 = t2585 * t2596
            t2579 = t2585 * t2594
            t2605 = 1025 * t2573 + 6150 * t2575 - 29725 * t2577 + 36900 * t2579 + 5125 * t2585 - 10250 * t2591 - 9225 * t2593
            t2604 = 10626 * t2573 + 5236 * t2575 - 83874 * t2577 + 124376 * t2579 - 1470 * t2585 + 17780 * t2591 - 72674 * t2593
            t2603 = 735471 * t2573 - 2067846 * t2575 + 2020365 * t2577 - 741540 * t2579 - 1717 * t2585 + 23562 * t2591 + 31705 * t2593
            t2602 = 83810 * t2584 - 806735 * t2592 + 2935628 * t2594 - 4987443 * t2596 + 4001970 * t2598 - 1225785 * t2600 - 1445
            t2590 = 4 * phi1
            t2589 = 8 * phi1
            t2588 = -5 * phi2
            t2587 = 5 * phi2
            t2586 = 12 * phi1
            tfunc[..., c] = (0.5e1 / 0.2686976e7*1j) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * np.sqrt(0.23e2) * ((1 + t2585) ** (-0.1e1 / 0.2e1)) * ((1 - t2585) ** (-0.1e1 / 0.2e1)) * ((2704156 * t2573 - 10581480 * t2575 + 16107364 * t2577 - 11905712 * t2579 + 4325412 * t2593 - 680680 * t2591 + 30940 * t2585) * np.exp((-5*1j) * phi2) + (-t2602 + t2603) * np.exp((-1*1j) * (t2590 + t2587)) + (t2604 - t2607) * np.exp((-1*1j) * (t2589 + t2587)) + (t2602 + t2603) * np.exp((1j) * (t2590 + t2588)) + (t2604 + t2607) * np.exp((1j) * (t2589 + t2588)) + (t2605 - t2606) * np.exp((-1*1j) * (t2586 + t2587)) + (t2605 + t2606) * np.exp((1j) * (t2586 + t2588)))

        if Bindx == 96:
            t2624 = np.cos(phi)
            t2623 = t2624 ** 2
            t2627 = t2623 ** 2
            t2628 = t2624 * t2627
            t2633 = t2628 ** 2
            t2614 = t2624 * t2633
            t2631 = t2627 ** 2
            t2616 = t2624 * t2631
            t2626 = t2624 * t2623
            t2629 = t2626 ** 2
            t2618 = t2624 * t2629
            t2639 = -1961256 * t2614 + 5573688 * t2616 - 5596944 * t2618 + 23256 * t2624 - 379848 * t2626 + 2341104 * t2628
            t2638 = -3922512 * t2614 + 10775280 * t2616 - 10821792 * t2618 + 42416 * t2624 - 857360 * t2626 + 4775776 * t2628
            t2613 = t2629 ** 2
            t2637 = -2941884 * t2613 + 59272 * t2623 - 698500 * t2627 + 3352944 * t2629 - 7538820 * t2631 + 7759752 * t2633 - 956
            t2636 = 735471 * t2613 + 331398 * t2623 - 1867263 * t2627 + 3585300 * t2629 - 2115327 * t2631 - 660858 * t2633 - 8721
            t2625 = 2 * phi1
            tfunc[..., c] = (0.5e1 / 0.671744e6) * np.sqrt(0.41e2) * np.sqrt(0.7e1) * np.sqrt(0.13e2) * ((4412826 * t2613 - 14197788 * t2633 + 17075718 * t2631 - 9411336 * t2629 + 2325510 * t2627 - 207900 * t2623 + 2970) * np.exp((-4*1j) * phi2) + (t2637 + t2638) * np.exp((-4*1j) * (phi1 + phi2)) + (t2636 - t2639) * np.exp((-4*1j) * (t2625 + phi2)) + (t2637 - t2638) * np.exp((4*1j) * (phi1 - phi2)) + (t2636 + t2639) * np.exp((4*1j) * (t2625 - phi2)))

        if Bindx == 97:
            t2658 = np.cos(phi)
            t2657 = t2658 ** 2
            t2662 = t2657 ** 2
            t2663 = t2658 * t2662
            t2668 = t2663 ** 2
            t2648 = t2658 * t2668
            t2666 = t2662 ** 2
            t2650 = t2658 * t2666
            t2661 = t2658 * t2657
            t2664 = t2661 ** 2
            t2652 = t2658 * t2664
            t2676 = -4100 * t2648 + 12300 * t2650 - 8200 * t2652 - 4100 * t2658 + 12300 * t2661 - 8200 * t2663
            t2675 = -28336 * t2648 + 80528 * t2650 - 80864 * t2652 + 336 * t2658 - 5488 * t2661 + 33824 * t2663
            t2647 = t2664 ** 2
            t2674 = -126 + 10626 * t2647 + 4788 * t2657 - 26978 * t2662 + 51800 * t2664 - 30562 * t2666 - 9548 * t2668
            t2673 = 1025 + 1025 * t2647 + 2050 * t2657 - 17425 * t2662 + 28700 * t2664 - 17425 * t2666 + 2050 * t2668
            t2672 = -980628 * t2648 + 2693820 * t2650 - 2705448 * t2652 + 10604 * t2658 - 214340 * t2661 + 1193944 * t2663
            t2671 = 735471 * t2647 - 14818 * t2657 + 174625 * t2662 - 838236 * t2664 + 1884705 * t2666 - 1939938 * t2668 + 239
            t2660 = 2 * phi1
            t2659 = 3 * phi1
            tfunc[..., c] = (0.5e1 / 0.10747904e8) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.11e2) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * np.sqrt(0.23e2) * ((2704156 * t2647 - 8700328 * t2668 + 10463908 * t2666 - 5767216 * t2664 + 1425060 * t2662 - 127400 * t2657 + 1820) * np.exp((-4*1j) * phi2) + (t2671 - t2672) * np.exp((-4*1j) * (phi1 + phi2)) + (t2674 - t2675) * np.exp((-4*1j) * (t2660 + phi2)) + (t2673 - t2676) * np.exp((-4*1j) * (t2659 + phi2)) + (t2671 + t2672) * np.exp((4*1j) * (phi1 - phi2)) + (t2674 + t2675) * np.exp((4*1j) * (t2660 - phi2)) + (t2673 + t2676) * np.exp((4*1j) * (t2659 - phi2)))

        if Bindx == 98:
            t2694 = np.cos(phi)
            t2693 = t2694 ** 2
            t2699 = t2694 * t2693
            t2702 = t2699 ** 2
            t2708 = t2702 ** 2
            t2682 = t2694 * t2708
            t2700 = t2693 ** 2
            t2701 = t2694 * t2700
            t2706 = t2701 ** 2
            t2684 = t2694 * t2706
            t2704 = t2700 ** 2
            t2686 = t2694 * t2704
            t2688 = t2694 * t2702
            t2713 = 81719 * t2682 - 234498 * t2684 + 179265 * t2686 + 55556 * t2688 - 3553 * t2694 + 44574 * t2699 - 123063 * t2701
            t2712 = 27132 * t2693 - 203490 * t2700 + 617576 * t2702 - 893418 * t2704 + 616284 * t2706 - 163438 * t2708 - 646
            t2711 = 17688 * t2693 - 188100 * t2700 + 731408 * t2702 - 1290708 * t2704 + 1056856 * t2706 - 326876 * t2708 - 268
            t2710 = -326876 * t2682 + 1108536 * t2684 - 1466420 * t2686 + 952272 * t2688 - 2028 * t2694 + 45688 * t2699 - 311172 * t2701
            t2698 = 4 * phi1
            t2697 = 8 * phi1
            t2696 = -3 * phi2
            t2695 = 3 * phi2
            tfunc[..., c] = (0.15e2 / 0.167936e6*1j) * np.sqrt(0.41e2) * np.sqrt(0.7e1) * np.sqrt(0.13e2) * ((1 + t2694) ** (-0.1e1 / 0.2e1)) * ((1 - t2694) ** (-0.1e1 / 0.2e1)) * ((2970 * t2694 + 490314 * t2682 - 1748076 * t2684 + 2408934 * t2686 - 1602216 * t2688 + 521334 * t2701 - 73260 * t2699) * np.exp((-3*1j) * phi2) + (t2710 + t2711) * np.exp((-1*1j) * (t2698 + t2695)) + (-t2712 + t2713) * np.exp((-1*1j) * (t2697 + t2695)) + (t2710 - t2711) * np.exp((1j) * (t2698 + t2696)) + (t2712 + t2713) * np.exp((1j) * (t2697 + t2696)))

        if Bindx == 99:
            t2733 = np.cos(phi)
            t2732 = t2733 ** 2
            t2739 = t2732 ** 2
            t2738 = t2733 * t2732
            t2741 = t2738 ** 2
            t2743 = t2739 ** 2
            t2740 = t2733 * t2739
            t2745 = t2740 ** 2
            t2747 = t2741 ** 2
            t2754 = 1025 - 2050 * t2732 - 5125 * t2739 + 20500 * t2741 - 25625 * t2743 + 14350 * t2745 - 3075 * t2747
            t2721 = t2733 * t2747
            t2723 = t2733 * t2745
            t2725 = t2733 * t2743
            t2727 = t2733 * t2741
            t2753 = 1025 * t2721 - 2050 * t2723 - 5125 * t2725 + 20500 * t2727 - 3075 * t2733 + 14350 * t2738 - 25625 * t2740
            t2752 = 10626 * t2721 - 30492 * t2723 + 23310 * t2725 + 7224 * t2727 - 462 * t2733 + 5796 * t2738 - 16002 * t2740
            t2751 = 3528 * t2732 - 26460 * t2739 + 80304 * t2741 - 116172 * t2743 + 80136 * t2745 - 21252 * t2747 - 84
            t2750 = 39798 * t2732 - 423225 * t2739 + 1645668 * t2741 - 2904093 * t2743 + 2377926 * t2745 - 735471 * t2747 - 603
            t2749 = 735471 * t2721 - 2494206 * t2723 + 3299445 * t2725 - 2142612 * t2727 + 4563 * t2733 - 102798 * t2738 + 700137 * t2740
            t2737 = 4 * phi1
            t2736 = 8 * phi1
            t2735 = -3 * phi2
            t2734 = 3 * phi2
            tfunc[..., c] = (0.5e1 / 0.8060928e7*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.11e2) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * np.sqrt(0.23e2) * ((1 + t2733) ** (-0.1e1 / 0.2e1)) * ((1 - t2733) ** (-0.1e1 / 0.2e1)) * ((2704156 * t2721 - 9640904 * t2723 + 13285636 * t2725 - 8836464 * t2727 + 2875236 * t2740 - 404040 * t2738 + 16380 * t2733) * np.exp((-3*1j) * phi2) + (t2753 - t2754) * np.exp((-3*1j) * (t2737 + phi2)) + (t2749 - t2750) * np.exp((-1*1j) * (t2737 + t2734)) + (-t2751 + t2752) * np.exp((-1*1j) * (t2736 + t2734)) + (t2749 + t2750) * np.exp((1j) * (t2737 + t2735)) + (t2751 + t2752) * np.exp((1j) * (t2736 + t2735)) + (t2753 + t2754) * np.exp((3*1j) * (t2737 - phi2)))

        if Bindx == 100:
            t2771 = np.cos(phi)
            t2770 = t2771 ** 2
            t2775 = t2770 ** 2
            t2776 = t2771 * t2775
            t2781 = t2776 ** 2
            t2761 = t2771 * t2781
            t2779 = t2775 ** 2
            t2763 = t2771 * t2779
            t2774 = t2771 * t2770
            t2777 = t2774 ** 2
            t2765 = t2771 * t2777
            t2787 = -653752 * t2761 + 1780376 * t2763 - 1741616 * t2765 + 5560 * t2771 - 122520 * t2774 + 731952 * t2776
            t2786 = -326876 * t2761 + 1169260 * t2763 - 1563320 * t2765 + 16796 * t2771 - 239020 * t2774 + 943160 * t2776
            t2760 = t2777 ** 2
            t2785 = 245157 * t2760 - 14212 * t2770 + 143735 * t2775 - 594320 * t2777 + 1057825 * t2779 - 838508 * t2781 + 323
            t2784 = -980628 * t2760 + 42160 * t2770 - 465180 * t2775 + 1888768 * t2777 - 3497444 * t2779 + 3012944 * t2781 - 620
            t2773 = 2 * phi1
            t2772 = 4 * phi1
            tfunc[..., c] = (0.5e1 / 0.335872e6) * np.sqrt(0.41e2) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.13e2) * ((1470942 * t2760 - 4348872 * t2781 + 4796550 * t2779 - 2423520 * t2777 + 549450 * t2775 - 45144 * t2770 + 594) * np.exp((-2*1j) * phi2) + (t2784 + t2787) * np.exp((-2*1j) * (t2773 + phi2)) + (t2785 - t2786) * np.exp((-2*1j) * (t2772 + phi2)) + (t2784 - t2787) * np.exp((2*1j) * (t2773 - phi2)) + (t2785 + t2786) * np.exp((2*1j) * (t2772 - phi2)))

        if Bindx == 101:
            t2806 = np.cos(phi)
            t2805 = t2806 ** 2
            t2810 = t2806 * t2805
            t2813 = t2810 ** 2
            t2795 = t2813 ** 2
            t2811 = t2805 ** 2
            t2815 = t2811 ** 2
            t2812 = t2806 * t2811
            t2817 = t2812 ** 2
            t2825 = -1025 + 1025 * t2795 + 4100 * t2805 - 5125 * t2811 + 5125 * t2815 - 4100 * t2817
            t2796 = t2806 * t2817
            t2798 = t2806 * t2815
            t2800 = t2806 * t2813
            t2824 = -14168 * t2796 + 50680 * t2798 - 67760 * t2800 + 728 * t2806 - 10360 * t2810 + 40880 * t2812
            t2823 = -2050 * t2796 + 10250 * t2798 - 20500 * t2800 + 2050 * t2806 - 10250 * t2810 + 20500 * t2812
            t2822 = 14 + 10626 * t2795 - 616 * t2805 + 6230 * t2811 - 25760 * t2813 + 45850 * t2815 - 36344 * t2817
            t2821 = -490314 * t2796 + 1335282 * t2798 - 1306212 * t2800 + 4170 * t2806 - 91890 * t2810 + 548964 * t2812
            t2820 = 735471 * t2795 - 31620 * t2805 + 348885 * t2811 - 1416576 * t2813 + 2623083 * t2815 - 2259708 * t2817 + 465
            t2809 = 2 * phi1
            t2808 = 4 * phi1
            t2807 = 6 * phi1
            tfunc[..., c] = (0.5e1 / 0.2686976e7) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * np.sqrt(0.17e2) * np.sqrt(0.41e2) * np.sqrt(0.23e2) * ((2704156 * t2795 - 7994896 * t2817 + 8817900 * t2815 - 4455360 * t2813 + 1010100 * t2811 - 82992 * t2805 + 1092) * np.exp((-2*1j) * phi2) + (-t2823 + t2825) * np.exp((-2*1j) * (t2807 + phi2)) + (t2823 + t2825) * np.exp((2*1j) * (t2807 - phi2)) + (t2820 - t2821) * np.exp((-2*1j) * (t2809 + phi2)) + (t2822 - t2824) * np.exp((-2*1j) * (t2808 + phi2)) + (t2820 + t2821) * np.exp((2*1j) * (t2809 - phi2)) + (t2822 + t2824) * np.exp((2*1j) * (t2808 - phi2)))

        if Bindx == 102:
            t2843 = np.cos(phi)
            t2842 = t2843 ** 2
            t2847 = t2842 ** 2
            t2846 = t2843 * t2842
            t2849 = t2846 ** 2
            t2851 = t2847 ** 2
            t2848 = t2843 * t2847
            t2853 = t2848 ** 2
            t2855 = t2849 ** 2
            t2860 = 9800 * t2842 - 109620 * t2847 + 443632 * t2849 - 804916 * t2851 + 669256 * t2853 - 208012 * t2855 - 140
            t2859 = 29716 * t2842 - 216410 * t2847 + 581400 * t2849 - 733210 * t2851 + 443156 * t2853 - 104006 * t2855 - 646
            t2831 = t2843 * t2855
            t2833 = t2843 * t2853
            t2835 = t2843 * t2851
            t2837 = t2843 * t2849
            t2858 = 156009 * t2831 - 709954 * t2833 + 1287155 * t2835 - 1169260 * t2837 + 7429 * t2843 - 115634 * t2846 + 544255 * t2848
            t2857 = -624036 * t2831 + 2297176 * t2833 - 3282972 * t2835 + 2275280 * t2837 - 4900 * t2843 + 114520 * t2846 - 775068 * t2848
            t2845 = 4 * phi1
            t2844 = 8 * phi1
            tfunc[..., c] = (0.5e1 / 0.167936e6*1j) * np.sqrt(0.11e2) * np.sqrt(0.41e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * ((1 + t2843) ** (-0.1e1 / 0.2e1)) * ((1 - t2843) ** (-0.1e1 / 0.2e1)) * ((936054 * t2831 - 3174444 * t2833 + 4157010 * t2835 - 2625480 * t2837 + 810810 * t2848 - 108108 * t2846 + 4158 * t2843) * np.exp((-1*1j) * phi2) + (t2857 + t2860) * np.exp((-1*1j) * (t2845 + phi2)) + (t2858 - t2859) * np.exp((-1*1j) * (t2844 + phi2)) + (t2857 - t2860) * np.exp((1j) * (t2845 - phi2)) + (t2858 + t2859) * np.exp((1j) * (t2844 - phi2)))

        if Bindx == 103:
            t2880 = np.cos(phi)
            t2879 = t2880 ** 2
            t2885 = t2879 ** 2
            t2884 = t2880 * t2879
            t2887 = t2884 ** 2
            t2889 = t2885 ** 2
            t2886 = t2880 * t2885
            t2891 = t2886 ** 2
            t2893 = t2887 ** 2
            t2900 = -1 + 6 * t2879 - 15 * t2885 + 20 * t2887 - 15 * t2889 + 6 * t2891 - t2893
            t2868 = t2880 * t2893
            t2870 = t2880 * t2891
            t2872 = t2880 * t2889
            t2874 = t2880 * t2887
            t2899 = t2868 + t2880 - 6 * t2870 + 15 * t2872 - 20 * t2874 - 6 * t2884 + 15 * t2886
            t2898 = -44 + 2024 * t2879 - 14740 * t2885 + 39600 * t2887 - 49940 * t2889 + 30184 * t2891 - 7084 * t2893
            t2897 = 10626 * t2868 - 48356 * t2870 + 87670 * t2872 - 79640 * t2874 + 506 * t2880 - 7876 * t2884 + 37070 * t2886
            t2896 = 11550 * t2879 - 129195 * t2885 + 522852 * t2887 - 948651 * t2889 + 788766 * t2891 - 245157 * t2893 - 165
            t2895 = 735471 * t2868 - 2707386 * t2870 + 3869217 * t2872 - 2681580 * t2874 + 5775 * t2880 - 134970 * t2884 + 913473 * t2886
            t2883 = 4 * phi1
            t2882 = 8 * phi1
            t2881 = 12 * phi1
            tfunc[..., c] = (0.5e1 / 0.2686976e7*1j) * np.sqrt(0.2e1) * np.sqrt(0.41e2) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * ((1 + t2880) ** (-0.1e1 / 0.2e1)) * ((1 - t2880) ** (-0.1e1 / 0.2e1)) * ((2704156 * t2868 - 9170616 * t2870 + 12009140 * t2872 - 7584720 * t2874 + 2342340 * t2886 - 312312 * t2884 + 12012 * t2880) * np.exp((-1*1j) * phi2) + (t2895 - t2896) * np.exp((-1*1j) * (t2883 + phi2)) + (t2897 - t2898) * np.exp((-1*1j) * (t2882 + phi2)) + (t2895 + t2896) * np.exp((1j) * (t2883 - phi2)) + (t2897 + t2898) * np.exp((1j) * (t2882 - phi2)) + 1025 * (t2899 - t2900) * np.exp((-1*1j) * (t2881 + phi2)) + 1025 * (t2899 + t2900) * np.exp((1j) * (t2881 - phi2)))

        if Bindx == 104:
            t2909 = np.cos(phi)
            t2908 = t2909 ** 2
            t2910 = t2908 ** 2
            t2912 = t2910 ** 2
            t2911 = t2908 * t2910
            t2904 = t2908 * t2912
            t2903 = t2911 ** 2
            tfunc[..., c] = -0.15e2 / 0.167936e6 * np.sqrt(0.11e2) * np.sqrt(0.41e2) * (-(2028117 * t2903) + (5819814 * t2904) - (6235515 * t2912) + (3063060 * t2911) - (675675 * t2910) + (54054 * t2908) - 0.693e3 + (2704156 * t2903 - 8700328 * t2904 + 10463908 * t2912 - 5767216 * t2911 + 1425060 * t2910 - 127400 * t2908 + 1820) * np.cos((4 * phi1)) + (-676039 * t2903 + 2880514 * t2904 - 4765865 * t2912 + 3779100 * t2911 - 1406665 * t2910 + 193154 * t2908 - 4199) * np.cos((8 * phi1)))

        if Bindx == 105:
            t2924 = np.cos(phi)
            t2923 = t2924 ** 2
            t2925 = t2923 ** 2
            t2927 = t2925 ** 2
            t2926 = t2923 * t2925
            t2919 = t2923 * t2927
            t2918 = t2926 ** 2
            tfunc[..., c] = 0.5e1 / 0.8060928e7 * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.19e2) * np.sqrt(0.7e1) * np.sqrt(0.13e2) * np.sqrt(0.17e2) * np.sqrt(0.23e2) * ((1352078 * t2918) - (3879876 * t2919) + (4157010 * t2927) - (2042040 * t2926) + (450450 * t2925) - (36036 * t2923) + 0.462e3 + (735471 * t2918 - 2366298 * t2919 + 2845953 * t2927 - 1568556 * t2926 + 387585 * t2925 - 34650 * t2923 + 495) * np.cos((4 * phi1)) + (10626 * t2918 - 45276 * t2919 + 74910 * t2927 - 59400 * t2926 + 22110 * t2925 - 3036 * t2923 + 66) * np.cos((8 * phi1)) + (1025 * t2918 - 6150 * t2919 + 15375 * t2927 - 20500 * t2926 + 15375 * t2925 - 6150 * t2923 + 1025) * np.cos((12 * phi1)))

        if Bindx == 106:
            t2947 = np.cos(phi)
            t2946 = t2947 ** 2
            t2951 = t2946 ** 2
            t2950 = t2947 * t2946
            t2953 = t2950 ** 2
            t2955 = t2951 ** 2
            t2952 = t2947 * t2951
            t2957 = t2952 ** 2
            t2959 = t2953 ** 2
            t2964 = 9800 * t2946 - 109620 * t2951 + 443632 * t2953 - 804916 * t2955 + 669256 * t2957 - 208012 * t2959 - 140
            t2963 = 29716 * t2946 - 216410 * t2951 + 581400 * t2953 - 733210 * t2955 + 443156 * t2957 - 104006 * t2959 - 646
            t2935 = t2947 * t2959
            t2937 = t2947 * t2957
            t2939 = t2947 * t2955
            t2941 = t2947 * t2953
            t2962 = 156009 * t2935 - 709954 * t2937 + 1287155 * t2939 - 1169260 * t2941 + 7429 * t2947 - 115634 * t2950 + 544255 * t2952
            t2961 = -624036 * t2935 + 2297176 * t2937 - 3282972 * t2939 + 2275280 * t2941 - 4900 * t2947 + 114520 * t2950 - 775068 * t2952
            t2949 = 4 * phi1
            t2948 = 8 * phi1
            tfunc[..., c] = (0.5e1 / 0.167936e6*1j) * np.sqrt(0.11e2) * np.sqrt(0.41e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * ((1 + t2947) ** (-0.1e1 / 0.2e1)) * ((1 - t2947) ** (-0.1e1 / 0.2e1)) * ((936054 * t2935 - 3174444 * t2937 + 4157010 * t2939 - 2625480 * t2941 + 810810 * t2952 - 108108 * t2950 + 4158 * t2947) * np.exp((1j) * phi2) + (t2961 - t2964) * np.exp((-1*1j) * (t2949 - phi2)) + (t2962 + t2963) * np.exp((-1*1j) * (t2948 - phi2)) + (t2961 + t2964) * np.exp((1j) * (t2949 + phi2)) + (t2962 - t2963) * np.exp((1j) * (t2948 + phi2)))

        if Bindx == 107:
            t2984 = np.cos(phi)
            t2983 = t2984 ** 2
            t2989 = t2983 ** 2
            t2988 = t2984 * t2983
            t2991 = t2988 ** 2
            t2993 = t2989 ** 2
            t2990 = t2984 * t2989
            t2995 = t2990 ** 2
            t2997 = t2991 ** 2
            t3004 = -1 + 6 * t2983 - 15 * t2989 + 20 * t2991 - 15 * t2993 + 6 * t2995 - t2997
            t2972 = t2984 * t2997
            t2974 = t2984 * t2995
            t2976 = t2984 * t2993
            t2978 = t2984 * t2991
            t3003 = t2972 + t2984 - 6 * t2974 + 15 * t2976 - 20 * t2978 - 6 * t2988 + 15 * t2990
            t3002 = -44 + 2024 * t2983 - 14740 * t2989 + 39600 * t2991 - 49940 * t2993 + 30184 * t2995 - 7084 * t2997
            t3001 = 10626 * t2972 - 48356 * t2974 + 87670 * t2976 - 79640 * t2978 + 506 * t2984 - 7876 * t2988 + 37070 * t2990
            t3000 = 11550 * t2983 - 129195 * t2989 + 522852 * t2991 - 948651 * t2993 + 788766 * t2995 - 245157 * t2997 - 165
            t2999 = 735471 * t2972 - 2707386 * t2974 + 3869217 * t2976 - 2681580 * t2978 + 5775 * t2984 - 134970 * t2988 + 913473 * t2990
            t2987 = 4 * phi1
            t2986 = 8 * phi1
            t2985 = 12 * phi1
            tfunc[..., c] = (0.5e1 / 0.2686976e7*1j) * np.sqrt(0.2e1) * np.sqrt(0.41e2) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * ((1 + t2984) ** (-0.1e1 / 0.2e1)) * ((1 - t2984) ** (-0.1e1 / 0.2e1)) * ((2704156 * t2972 - 9170616 * t2974 + 12009140 * t2976 - 7584720 * t2978 + 2342340 * t2990 - 312312 * t2988 + 12012 * t2984) * np.exp((1j) * phi2) + (t2999 + t3000) * np.exp((-1*1j) * (t2987 - phi2)) + (t3001 + t3002) * np.exp((-1*1j) * (t2986 - phi2)) + (t2999 - t3000) * np.exp((1j) * (t2987 + phi2)) + (t3001 - t3002) * np.exp((1j) * (t2986 + phi2)) + 1025 * (t3003 + t3004) * np.exp((-1*1j) * (t2985 - phi2)) + 1025 * (t3003 - t3004) * np.exp((1j) * (t2985 + phi2)))

        if Bindx == 108:
            t3021 = np.cos(phi)
            t3020 = t3021 ** 2
            t3025 = t3020 ** 2
            t3026 = t3021 * t3025
            t3031 = t3026 ** 2
            t3011 = t3021 * t3031
            t3029 = t3025 ** 2
            t3013 = t3021 * t3029
            t3024 = t3021 * t3020
            t3027 = t3024 ** 2
            t3015 = t3021 * t3027
            t3037 = -653752 * t3011 + 1780376 * t3013 - 1741616 * t3015 + 5560 * t3021 - 122520 * t3024 + 731952 * t3026
            t3036 = -326876 * t3011 + 1169260 * t3013 - 1563320 * t3015 + 16796 * t3021 - 239020 * t3024 + 943160 * t3026
            t3010 = t3027 ** 2
            t3035 = 245157 * t3010 - 14212 * t3020 + 143735 * t3025 - 594320 * t3027 + 1057825 * t3029 - 838508 * t3031 + 323
            t3034 = -980628 * t3010 + 42160 * t3020 - 465180 * t3025 + 1888768 * t3027 - 3497444 * t3029 + 3012944 * t3031 - 620
            t3023 = 2 * phi1
            t3022 = 4 * phi1
            tfunc[..., c] = (0.5e1 / 0.335872e6) * np.sqrt(0.41e2) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.13e2) * ((1470942 * t3010 - 4348872 * t3031 + 4796550 * t3029 - 2423520 * t3027 + 549450 * t3025 - 45144 * t3020 + 594) * np.exp((2*1j) * phi2) + (t3034 - t3037) * np.exp((-2*1j) * (t3023 - phi2)) + (t3035 + t3036) * np.exp((-2*1j) * (t3022 - phi2)) + (t3034 + t3037) * np.exp((2*1j) * (t3023 + phi2)) + (t3035 - t3036) * np.exp((2*1j) * (t3022 + phi2)))

        if Bindx == 109:
            t3056 = np.cos(phi)
            t3055 = t3056 ** 2
            t3060 = t3056 * t3055
            t3063 = t3060 ** 2
            t3045 = t3063 ** 2
            t3061 = t3055 ** 2
            t3065 = t3061 ** 2
            t3062 = t3056 * t3061
            t3067 = t3062 ** 2
            t3075 = -1025 + 1025 * t3045 + 4100 * t3055 - 5125 * t3061 + 5125 * t3065 - 4100 * t3067
            t3046 = t3056 * t3067
            t3048 = t3056 * t3065
            t3050 = t3056 * t3063
            t3074 = -14168 * t3046 + 50680 * t3048 - 67760 * t3050 + 728 * t3056 - 10360 * t3060 + 40880 * t3062
            t3073 = -2050 * t3046 + 10250 * t3048 - 20500 * t3050 + 2050 * t3056 - 10250 * t3060 + 20500 * t3062
            t3072 = 14 + 10626 * t3045 - 616 * t3055 + 6230 * t3061 - 25760 * t3063 + 45850 * t3065 - 36344 * t3067
            t3071 = -490314 * t3046 + 1335282 * t3048 - 1306212 * t3050 + 4170 * t3056 - 91890 * t3060 + 548964 * t3062
            t3070 = 735471 * t3045 - 31620 * t3055 + 348885 * t3061 - 1416576 * t3063 + 2623083 * t3065 - 2259708 * t3067 + 465
            t3059 = 2 * phi1
            t3058 = 4 * phi1
            t3057 = 6 * phi1
            tfunc[..., c] = (0.5e1 / 0.2686976e7) * np.sqrt(0.41e2) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * ((2704156 * t3045 - 7994896 * t3067 + 8817900 * t3065 - 4455360 * t3063 + 1010100 * t3061 - 82992 * t3055 + 1092) * np.exp((2*1j) * phi2) + (t3073 + t3075) * np.exp((-2*1j) * (t3057 - phi2)) + (-t3073 + t3075) * np.exp((2*1j) * (t3057 + phi2)) + (t3070 + t3071) * np.exp((-2*1j) * (t3059 - phi2)) + (t3072 + t3074) * np.exp((-2*1j) * (t3058 - phi2)) + (t3070 - t3071) * np.exp((2*1j) * (t3059 + phi2)) + (t3072 - t3074) * np.exp((2*1j) * (t3058 + phi2)))

        if Bindx == 110:
            t3093 = np.cos(phi)
            t3092 = t3093 ** 2
            t3098 = t3093 * t3092
            t3101 = t3098 ** 2
            t3107 = t3101 ** 2
            t3081 = t3093 * t3107
            t3099 = t3092 ** 2
            t3100 = t3093 * t3099
            t3105 = t3100 ** 2
            t3083 = t3093 * t3105
            t3103 = t3099 ** 2
            t3085 = t3093 * t3103
            t3087 = t3093 * t3101
            t3112 = 81719 * t3081 - 234498 * t3083 + 179265 * t3085 + 55556 * t3087 - 3553 * t3093 + 44574 * t3098 - 123063 * t3100
            t3111 = 27132 * t3092 - 203490 * t3099 + 617576 * t3101 - 893418 * t3103 + 616284 * t3105 - 163438 * t3107 - 646
            t3110 = 17688 * t3092 - 188100 * t3099 + 731408 * t3101 - 1290708 * t3103 + 1056856 * t3105 - 326876 * t3107 - 268
            t3109 = -326876 * t3081 + 1108536 * t3083 - 1466420 * t3085 + 952272 * t3087 - 2028 * t3093 + 45688 * t3098 - 311172 * t3100
            t3097 = 4 * phi1
            t3096 = 8 * phi1
            t3095 = -3 * phi2
            t3094 = 3 * phi2
            tfunc[..., c] = (0.15e2 / 0.167936e6*1j) * np.sqrt(0.41e2) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * ((1 + t3093) ** (-0.1e1 / 0.2e1)) * ((1 - t3093) ** (-0.1e1 / 0.2e1)) * ((490314 * t3081 - 1748076 * t3083 + 2408934 * t3085 - 1602216 * t3087 + 521334 * t3100 - 73260 * t3098 + 2970 * t3093) * np.exp((3*1j) * phi2) + (t3109 - t3110) * np.exp((-1*1j) * (t3097 + t3095)) + (t3111 + t3112) * np.exp((-1*1j) * (t3096 + t3095)) + (t3109 + t3110) * np.exp((1j) * (t3097 + t3094)) + (-t3111 + t3112) * np.exp((1j) * (t3096 + t3094)))

        if Bindx == 111:
            t3132 = np.cos(phi)
            t3131 = t3132 ** 2
            t3138 = t3131 ** 2
            t3137 = t3132 * t3131
            t3140 = t3137 ** 2
            t3142 = t3138 ** 2
            t3139 = t3132 * t3138
            t3144 = t3139 ** 2
            t3146 = t3140 ** 2
            t3153 = 1025 - 2050 * t3131 - 5125 * t3138 + 20500 * t3140 - 25625 * t3142 + 14350 * t3144 - 3075 * t3146
            t3120 = t3132 * t3146
            t3122 = t3132 * t3144
            t3124 = t3132 * t3142
            t3126 = t3132 * t3140
            t3152 = 1025 * t3120 - 2050 * t3122 - 5125 * t3124 + 20500 * t3126 - 3075 * t3132 + 14350 * t3137 - 25625 * t3139
            t3151 = 10626 * t3120 - 30492 * t3122 + 23310 * t3124 + 7224 * t3126 - 462 * t3132 + 5796 * t3137 - 16002 * t3139
            t3150 = 3528 * t3131 - 26460 * t3138 + 80304 * t3140 - 116172 * t3142 + 80136 * t3144 - 21252 * t3146 - 84
            t3149 = 39798 * t3131 - 423225 * t3138 + 1645668 * t3140 - 2904093 * t3142 + 2377926 * t3144 - 735471 * t3146 - 603
            t3148 = 735471 * t3120 - 2494206 * t3122 + 3299445 * t3124 - 2142612 * t3126 + 4563 * t3132 - 102798 * t3137 + 700137 * t3139
            t3136 = 4 * phi1
            t3135 = 8 * phi1
            t3134 = -3 * phi2
            t3133 = 3 * phi2
            tfunc[..., c] = (0.5e1 / 0.8060928e7*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * np.sqrt(0.17e2) * np.sqrt(0.23e2) * ((1 + t3132) ** (-0.1e1 / 0.2e1)) * ((1 - t3132) ** (-0.1e1 / 0.2e1)) * ((2704156 * t3120 - 9640904 * t3122 + 13285636 * t3124 - 8836464 * t3126 + 2875236 * t3139 - 404040 * t3137 + 16380 * t3132) * np.exp((3*1j) * phi2) + (t3152 + t3153) * np.exp((-3*1j) * (t3136 - phi2)) + (t3148 + t3149) * np.exp((-1*1j) * (t3136 + t3134)) + (t3150 + t3151) * np.exp((-1*1j) * (t3135 + t3134)) + (t3148 - t3149) * np.exp((1j) * (t3136 + t3133)) + (-t3150 + t3151) * np.exp((1j) * (t3135 + t3133)) + (t3152 - t3153) * np.exp((3*1j) * (t3136 + phi2)))

        if Bindx == 112:
            t3170 = np.cos(phi)
            t3169 = t3170 ** 2
            t3173 = t3169 ** 2
            t3174 = t3170 * t3173
            t3179 = t3174 ** 2
            t3160 = t3170 * t3179
            t3177 = t3173 ** 2
            t3162 = t3170 * t3177
            t3172 = t3170 * t3169
            t3175 = t3172 ** 2
            t3164 = t3170 * t3175
            t3185 = -1961256 * t3160 + 5573688 * t3162 - 5596944 * t3164 + 23256 * t3170 - 379848 * t3172 + 2341104 * t3174
            t3184 = -3922512 * t3160 + 10775280 * t3162 - 10821792 * t3164 + 42416 * t3170 - 857360 * t3172 + 4775776 * t3174
            t3159 = t3175 ** 2
            t3183 = -2941884 * t3159 + 59272 * t3169 - 698500 * t3173 + 3352944 * t3175 - 7538820 * t3177 + 7759752 * t3179 - 956
            t3182 = 735471 * t3159 + 331398 * t3169 - 1867263 * t3173 + 3585300 * t3175 - 2115327 * t3177 - 660858 * t3179 - 8721
            t3171 = 2 * phi1
            tfunc[..., c] = (0.5e1 / 0.671744e6) * np.sqrt(0.41e2) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * ((4412826 * t3159 - 14197788 * t3179 + 17075718 * t3177 - 9411336 * t3175 + 2325510 * t3173 - 207900 * t3169 + 2970) * np.exp((4*1j) * phi2) + (t3183 - t3184) * np.exp((-4*1j) * (phi1 - phi2)) + (t3182 + t3185) * np.exp((-4*1j) * (t3171 - phi2)) + (t3183 + t3184) * np.exp((4*1j) * (phi1 + phi2)) + (t3182 - t3185) * np.exp((4*1j) * (t3171 + phi2)))

        if Bindx == 113:
            t3204 = np.cos(phi)
            t3203 = t3204 ** 2
            t3208 = t3203 ** 2
            t3209 = t3204 * t3208
            t3214 = t3209 ** 2
            t3194 = t3204 * t3214
            t3212 = t3208 ** 2
            t3196 = t3204 * t3212
            t3207 = t3204 * t3203
            t3210 = t3207 ** 2
            t3198 = t3204 * t3210
            t3222 = -4100 * t3194 + 12300 * t3196 - 8200 * t3198 - 4100 * t3204 + 12300 * t3207 - 8200 * t3209
            t3221 = -28336 * t3194 + 80528 * t3196 - 80864 * t3198 + 336 * t3204 - 5488 * t3207 + 33824 * t3209
            t3193 = t3210 ** 2
            t3220 = -126 + 10626 * t3193 + 4788 * t3203 - 26978 * t3208 + 51800 * t3210 - 30562 * t3212 - 9548 * t3214
            t3219 = 1025 + 1025 * t3193 + 2050 * t3203 - 17425 * t3208 + 28700 * t3210 - 17425 * t3212 + 2050 * t3214
            t3218 = -980628 * t3194 + 2693820 * t3196 - 2705448 * t3198 + 10604 * t3204 - 214340 * t3207 + 1193944 * t3209
            t3217 = 735471 * t3193 - 14818 * t3203 + 174625 * t3208 - 838236 * t3210 + 1884705 * t3212 - 1939938 * t3214 + 239
            t3206 = 2 * phi1
            t3205 = 3 * phi1
            tfunc[..., c] = (0.5e1 / 0.10747904e8) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.11e2) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * np.sqrt(0.23e2) * ((2704156 * t3193 - 8700328 * t3214 + 10463908 * t3212 - 5767216 * t3210 + 1425060 * t3208 - 127400 * t3203 + 1820) * np.exp((4*1j) * phi2) + (t3217 + t3218) * np.exp((-4*1j) * (phi1 - phi2)) + (t3220 + t3221) * np.exp((-4*1j) * (t3206 - phi2)) + (t3219 + t3222) * np.exp((-4*1j) * (t3205 - phi2)) + (t3217 - t3218) * np.exp((4*1j) * (phi1 + phi2)) + (t3220 - t3221) * np.exp((4*1j) * (t3206 + phi2)) + (t3219 - t3222) * np.exp((4*1j) * (t3205 + phi2)))

        if Bindx == 114:
            t3240 = np.cos(phi)
            t3239 = t3240 ** 2
            t3246 = t3239 ** 2
            t3245 = t3240 * t3239
            t3248 = t3245 ** 2
            t3250 = t3246 ** 2
            t3247 = t3240 * t3246
            t3252 = t3247 ** 2
            t3254 = t3248 ** 2
            t3259 = -11628 * t3239 + 26562 * t3246 + 94392 * t3248 - 367878 * t3250 + 402420 * t3252 - 144210 * t3254 + 342
            t3228 = t3240 * t3254
            t3230 = t3240 * t3252
            t3232 = t3240 * t3250
            t3234 = t3240 * t3248
            t3258 = -43263 * t3228 - 21318 * t3230 + 341487 * t3232 - 506388 * t3234 + 5985 * t3240 - 72390 * t3245 + 295887 * t3247
            t3257 = 173052 * t3228 - 486552 * t3230 + 475380 * t3232 - 174480 * t3234 - 404 * t3240 + 5544 * t3245 + 7460 * t3247
            t3256 = 19720 * t3239 - 189820 * t3246 + 690736 * t3248 - 1173516 * t3250 + 941640 * t3252 - 288420 * t3254 - 340
            t3244 = 4 * phi1
            t3243 = 8 * phi1
            t3242 = -5 * phi2
            t3241 = 5 * phi2
            tfunc[..., c] = (-0.5e1 / 0.335872e6*1j) * np.sqrt(0.41e2) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * np.sqrt(0.7e1) * np.sqrt(0.13e2) * ((-259578 * t3228 + 1015740 * t3230 - 1546182 * t3232 + 1142856 * t3234 - 415206 * t3247 + 65340 * t3245 - 2970 * t3240) * np.exp((5*1j) * phi2) + (t3256 + t3257) * np.exp((-1*1j) * (t3244 + t3242)) + (t3258 - t3259) * np.exp((-1*1j) * (t3243 + t3242)) + (-t3256 + t3257) * np.exp((1j) * (t3244 + t3241)) + (t3258 + t3259) * np.exp((1j) * (t3243 + t3241))) * ((1 + t3240) ** (-0.1e1 / 0.2e1)) * ((1 - t3240) ** (-0.1e1 / 0.2e1))

        if Bindx == 115:
            t3279 = np.cos(phi)
            t3278 = t3279 ** 2
            t3286 = t3278 ** 2
            t3285 = t3279 * t3278
            t3288 = t3285 ** 2
            t3290 = t3286 ** 2
            t3287 = t3279 * t3286
            t3292 = t3287 ** 2
            t3294 = t3288 ** 2
            t3301 = 84 - 2856 * t3278 + 6524 * t3286 + 23184 * t3288 - 90356 * t3290 + 98840 * t3292 - 35420 * t3294
            t3300 = -1025 - 6150 * t3278 + 29725 * t3286 - 36900 * t3288 + 9225 * t3290 + 10250 * t3292 - 5125 * t3294
            t3267 = t3279 * t3294
            t3269 = t3279 * t3292
            t3271 = t3279 * t3290
            t3273 = t3279 * t3288
            t3299 = 1025 * t3267 + 6150 * t3269 - 29725 * t3271 + 36900 * t3273 + 5125 * t3279 - 10250 * t3285 - 9225 * t3287
            t3298 = 10626 * t3267 + 5236 * t3269 - 83874 * t3271 + 124376 * t3273 - 1470 * t3279 + 17780 * t3285 - 72674 * t3287
            t3297 = 735471 * t3267 - 2067846 * t3269 + 2020365 * t3271 - 741540 * t3273 - 1717 * t3279 + 23562 * t3285 + 31705 * t3287
            t3296 = 83810 * t3278 - 806735 * t3286 + 2935628 * t3288 - 4987443 * t3290 + 4001970 * t3292 - 1225785 * t3294 - 1445
            t3284 = 4 * phi1
            t3283 = 8 * phi1
            t3282 = -5 * phi2
            t3281 = 5 * phi2
            t3280 = 12 * phi1
            tfunc[..., c] = (0.5e1 / 0.2686976e7*1j) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * np.sqrt(0.23e2) * ((1 + t3279) ** (-0.1e1 / 0.2e1)) * ((1 - t3279) ** (-0.1e1 / 0.2e1)) * ((2704156 * t3267 - 10581480 * t3269 + 16107364 * t3271 - 11905712 * t3273 + 4325412 * t3287 - 680680 * t3285 + 30940 * t3279) * np.exp((5*1j) * phi2) + (t3296 + t3297) * np.exp((-1*1j) * (t3284 + t3282)) + (t3298 + t3301) * np.exp((-1*1j) * (t3283 + t3282)) + (-t3296 + t3297) * np.exp((1j) * (t3284 + t3281)) + (t3298 - t3301) * np.exp((1j) * (t3283 + t3281)) + (t3299 + t3300) * np.exp((-1*1j) * (t3280 + t3282)) + (t3299 - t3300) * np.exp((1j) * (t3280 + t3281)))

        if Bindx == 116:
            t3318 = np.cos(phi)
            t3317 = t3318 ** 2
            t3324 = t3317 ** 2
            t3325 = t3318 * t3324
            t3330 = t3325 ** 2
            t3308 = t3318 * t3330
            t3328 = t3324 ** 2
            t3310 = t3318 * t3328
            t3323 = t3318 * t3317
            t3326 = t3323 ** 2
            t3312 = t3318 * t3326
            t3336 = -134596 * t3308 + 217588 * t3310 - 7752 * t3312 - 7676 * t3318 + 63308 * t3323 - 130872 * t3325
            t3307 = t3326 ** 2
            t3335 = -134596 * t3307 - 10192 * t3317 + 68180 * t3324 - 103936 * t3326 - 77140 * t3328 + 257488 * t3330 + 196
            t3334 = -269192 * t3308 + 750120 * t3310 - 768208 * t3312 + 3976 * t3318 - 69160 * t3323 + 352464 * t3325
            t3333 = 33649 * t3307 + 10108 * t3317 - 106533 * t3324 + 338352 * t3326 - 386403 * t3328 + 111188 * t3330 - 361
            t3322 = 2 * phi1
            t3321 = 4 * phi1
            t3320 = -3 * phi2
            t3319 = 3 * phi2
            tfunc[..., c] = (0.15e2 / 0.335872e6) * np.sqrt(0.13e2) * np.sqrt(0.17e2) * np.sqrt(0.41e2) * ((201894 * t3307 - 737352 * t3330 + 1019502 * t3328 - 653664 * t3326 + 189090 * t3324 - 19800 * t3317 + 330) * np.exp((6*1j) * phi2) + (-t3334 + t3335) * np.exp((-2*1j) * (t3322 + t3320)) + (t3333 + t3336) * np.exp((-2*1j) * (t3321 + t3320)) + (t3334 + t3335) * np.exp((2*1j) * (t3322 + t3319)) + (t3333 - t3336) * np.exp((2*1j) * (t3321 + t3319)))

        if Bindx == 117:
            t3355 = np.cos(phi)
            t3354 = t3355 ** 2
            t3360 = t3355 * t3354
            t3363 = t3360 ** 2
            t3344 = t3363 ** 2
            t3361 = t3354 ** 2
            t3365 = t3361 ** 2
            t3362 = t3355 * t3361
            t3367 = t3362 ** 2
            t3375 = -1025 + 1025 * t3344 - 12300 * t3354 + 27675 * t3361 - 27675 * t3365 + 12300 * t3367
            t3345 = t3355 * t3367
            t3347 = t3355 * t3365
            t3349 = t3355 * t3363
            t3374 = -6150 * t3345 - 2050 * t3347 + 36900 * t3349 + 6150 * t3355 + 2050 * t3360 - 36900 * t3362
            t3373 = -42504 * t3345 + 68712 * t3347 - 2448 * t3349 - 2424 * t3355 + 19992 * t3360 - 41328 * t3362
            t3372 = 10626 * t3344 + 3192 * t3354 - 33642 * t3361 + 106848 * t3363 - 122022 * t3365 + 35112 * t3367 - 114
            t3371 = -1470942 * t3345 + 4098870 * t3347 - 4197708 * t3349 + 21726 * t3355 - 377910 * t3360 + 1925964 * t3362
            t3370 = 735471 * t3344 + 55692 * t3354 - 372555 * t3361 + 567936 * t3363 + 421515 * t3365 - 1406988 * t3367 - 1071
            t3359 = 2 * phi1
            t3358 = 4 * phi1
            t3357 = -3 * phi2
            t3356 = 3 * phi2
            tfunc[..., c] = (0.5e1 / 0.16121856e8) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.7e1) * np.sqrt(0.19e2) * ((2704156 * t3344 - 9876048 * t3367 + 13655148 * t3365 - 8755136 * t3363 + 2532660 * t3361 - 265200 * t3354 + 4420) * np.exp((6*1j) * phi2) + (t3374 + t3375) * np.exp((-6*1j) * (t3359 - phi2)) + (-t3374 + t3375) * np.exp((6*1j) * (t3359 + phi2)) + (t3370 + t3371) * np.exp((-2*1j) * (t3359 + t3357)) + (t3372 + t3373) * np.exp((-2*1j) * (t3358 + t3357)) + (t3370 - t3371) * np.exp((2*1j) * (t3359 + t3356)) + (t3372 - t3373) * np.exp((2*1j) * (t3358 + t3356)))

        if Bindx == 118:
            t3393 = np.cos(phi)
            t3392 = t3393 ** 2
            t3399 = t3392 ** 2
            t3398 = t3393 * t3392
            t3401 = t3398 ** 2
            t3403 = t3399 ** 2
            t3400 = t3393 * t3399
            t3405 = t3400 ** 2
            t3407 = t3401 ** 2
            t3412 = 278 - 6116 * t3392 + 34650 * t3399 - 66360 * t3401 + 29610 * t3403 + 32732 * t3405 - 24794 * t3407
            t3381 = t3393 * t3407
            t3383 = t3393 * t3405
            t3385 = t3393 * t3403
            t3387 = t3393 * t3401
            t3411 = -21252 * t3381 + 41272 * t3383 + 7140 * t3385 - 64624 * t3387 + 924 * t3393 - 13384 * t3398 + 49924 * t3400
            t3410 = 5313 * t3381 + 29414 * t3383 - 95405 * t3385 + 82980 * t3387 + 1141 * t3393 - 3178 * t3398 - 20265 * t3400
            t3409 = -3864 * t3392 + 33740 * t3399 - 121296 * t3401 + 205996 * t3403 - 164248 * t3405 + 49588 * t3407 + 84
            t3397 = 4 * phi1
            t3396 = 8 * phi1
            t3395 = -7 * phi2
            t3394 = 7 * phi2
            tfunc[..., c] = (0.5e1 / 0.335872e6*1j) * np.sqrt(0.13e2) * np.sqrt(0.17e2) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * np.sqrt(0.41e2) * ((1 + t3393) ** (-0.1e1 / 0.2e1)) * ((1 - t3393) ** (-0.1e1 / 0.2e1)) * ((31878 * t3381 - 141372 * t3383 + 247698 * t3385 - 214632 * t3387 + 93258 * t3400 - 17820 * t3398 + 990 * t3393) * np.exp((7*1j) * phi2) + (t3409 + t3411) * np.exp((-1*1j) * (t3397 + t3395)) + (t3410 + t3412) * np.exp((-1*1j) * (t3396 + t3395)) + (-t3409 + t3411) * np.exp((1j) * (t3397 + t3394)) + (t3410 - t3412) * np.exp((1j) * (t3396 + t3394)))

        if Bindx == 119:
            t3432 = np.cos(phi)
            t3431 = t3432 ** 2
            t3439 = t3431 ** 2
            t3438 = t3432 * t3431
            t3441 = t3438 ** 2
            t3443 = t3439 ** 2
            t3440 = t3432 * t3439
            t3445 = t3440 ** 2
            t3447 = t3441 ** 2
            t3454 = -1025 - 18450 * t3431 + 25625 * t3439 + 36900 * t3441 - 64575 * t3443 + 14350 * t3445 + 7175 * t3447
            t3420 = t3432 * t3447
            t3422 = t3432 * t3445
            t3424 = t3432 * t3443
            t3426 = t3432 * t3441
            t3453 = 1025 * t3420 + 18450 * t3422 - 25625 * t3424 - 36900 * t3426 - 7175 * t3432 - 14350 * t3438 + 64575 * t3440
            t3452 = -12232 * t3431 + 69300 * t3439 - 132720 * t3441 + 59220 * t3443 + 65464 * t3445 - 49588 * t3447 + 556
            t3451 = 10626 * t3420 + 58828 * t3422 - 190810 * t3424 + 165960 * t3426 + 2282 * t3432 - 6356 * t3438 - 40530 * t3440
            t3450 = -133722 * t3431 + 1167645 * t3439 - 4197708 * t3441 + 7128933 * t3443 - 5684154 * t3445 + 1716099 * t3447 + 2907
            t3449 = 735471 * t3420 - 1428306 * t3422 - 247095 * t3424 + 2236452 * t3426 - 31977 * t3432 + 463182 * t3438 - 1727727 * t3440
            t3437 = 4 * phi1
            t3436 = 8 * phi1
            t3435 = -7 * phi2
            t3434 = 7 * phi2
            t3433 = 12 * phi1
            tfunc[..., c] = (0.5e1 / 0.2686976e7*1j) * np.sqrt(0.11e2) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * np.sqrt(0.41e2) * ((1 + t3432) ** (-0.1e1 / 0.2e1)) * ((1 - t3432) ** (-0.1e1 / 0.2e1)) * ((2704156 * t3420 - 11992344 * t3422 + 21011796 * t3424 - 18206864 * t3426 + 7910916 * t3440 - 1511640 * t3438 + 83980 * t3432) * np.exp((7*1j) * phi2) + (t3449 - t3450) * np.exp((-1*1j) * (t3437 + t3435)) + (t3451 + t3452) * np.exp((-1*1j) * (t3436 + t3435)) + (t3449 + t3450) * np.exp((1j) * (t3437 + t3434)) + (t3451 - t3452) * np.exp((1j) * (t3436 + t3434)) + (t3453 - t3454) * np.exp((-1*1j) * (t3433 + t3435)) + (t3453 + t3454) * np.exp((1j) * (t3433 + t3434)))

        if Bindx == 120:
            t3471 = np.cos(phi)
            t3470 = t3471 ** 2
            t3473 = t3470 ** 2
            t3474 = t3471 * t3473
            t3479 = t3474 ** 2
            t3461 = t3471 * t3479
            t3477 = t3473 ** 2
            t3463 = t3471 * t3477
            t3472 = t3471 * t3470
            t3475 = t3472 ** 2
            t3465 = t3471 * t3475
            t3485 = -28336 * t3461 - 2800 * t3463 + 84384 * t3465 - 176 * t3471 + 15120 * t3472 - 69216 * t3474
            t3460 = t3475 ** 2
            t3484 = -673 - 5313 * t3460 + 9422 * t3470 - 22575 * t3473 - 20412 * t3475 + 87345 * t3477 - 48818 * t3479
            t3483 = 21252 * t3460 + 9576 * t3470 - 53956 * t3473 + 103600 * t3475 - 61124 * t3477 - 19096 * t3479 - 252
            t3482 = 56672 * t3461 - 161056 * t3463 + 161728 * t3465 - 672 * t3471 + 10976 * t3472 - 67648 * t3474
            tfunc[..., c] = -(0.5e1 / 0.671744e6) * np.sqrt(0.41e2) * np.sqrt(0.19e2) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * np.sqrt(0.13e2) * ((-31878 * t3460 + 135828 * t3479 - 224730 * t3477 + 178200 * t3475 - 66330 * t3473 + 9108 * t3470 - 198) * np.exp((8*1j) * phi2) + (t3484 - t3485) * np.exp((-8*1j) * (phi1 - phi2)) + (-t3482 + t3483) * np.exp((-4*1j) * (phi1 - 2 * phi2)) + (t3482 + t3483) * np.exp((4*1j) * (phi1 + 2 * phi2)) + (t3484 + t3485) * np.exp((8*1j) * (phi1 + phi2)))

        if Bindx == 121:
            t3504 = np.cos(phi)
            t3503 = t3504 ** 2
            t3509 = t3503 ** 2
            t3510 = t3504 * t3509
            t3515 = t3510 ** 2
            t3494 = t3504 * t3515
            t3513 = t3509 ** 2
            t3496 = t3504 * t3513
            t3508 = t3504 * t3503
            t3511 = t3508 ** 2
            t3498 = t3504 * t3511
            t3523 = -8200 * t3494 - 41000 * t3496 + 49200 * t3498 - 8200 * t3504 - 41000 * t3508 + 49200 * t3510
            t3493 = t3511 ** 2
            t3522 = 1025 + 1025 * t3493 + 26650 * t3503 + 15375 * t3509 - 86100 * t3511 + 15375 * t3513 + 26650 * t3515
            t3521 = 10626 * t3493 - 18844 * t3503 + 45150 * t3509 + 40824 * t3511 - 174690 * t3513 + 97636 * t3515 + 1346
            t3520 = 56672 * t3494 + 5600 * t3496 - 168768 * t3498 + 352 * t3504 - 30240 * t3508 + 138432 * t3510
            t3519 = -1961256 * t3494 + 5573688 * t3496 - 5596944 * t3498 + 23256 * t3504 - 379848 * t3508 + 2341104 * t3510
            t3518 = 735471 * t3493 + 331398 * t3503 - 1867263 * t3509 + 3585300 * t3511 - 2115327 * t3513 - 660858 * t3515 - 8721
            t3507 = 3 * phi1
            t3506 = -2 * phi2
            t3505 = 2 * phi2
            tfunc[..., c] = (0.5e1 / 0.5373952e7) * np.sqrt(0.41e2) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * np.sqrt(0.11e2) * ((19063460 * t3513 - 15116400 * t3511 + 5626660 * t3509 - 772616 * t3503 + 2704156 * t3493 - 11522056 * t3515 + 16796) * np.exp((8*1j) * phi2) + (-t3520 + t3521) * np.exp((-8*1j) * (phi1 - phi2)) + (t3518 + t3519) * np.exp((-4*1j) * (phi1 + t3506)) + (t3522 + t3523) * np.exp((-4*1j) * (t3507 + t3506)) + (t3518 - t3519) * np.exp((4*1j) * (phi1 + t3505)) + (t3522 - t3523) * np.exp((4*1j) * (t3507 + t3505)) + (t3520 + t3521) * np.exp((8*1j) * (phi1 + phi2)))

        if Bindx == 122:
            t3540 = np.cos(phi)
            t3539 = t3540 ** 2
            t3545 = t3540 * t3539
            t3548 = t3545 ** 2
            t3529 = t3548 ** 2
            t3556 = -253 * t3529
            t3555 = 1012 * t3529
            t3546 = t3539 ** 2
            t3547 = t3540 * t3546
            t3552 = t3547 ** 2
            t3550 = t3546 ** 2
            t3544 = 4 * phi1
            t3543 = 8 * phi1
            t3542 = -9 * phi2
            t3541 = 9 * phi2
            t3534 = t3540 * t3548
            t3532 = t3540 * t3550
            t3530 = t3540 * t3552
            tfunc[..., c] = (0.15e2 / 0.335872e6*1j) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * np.sqrt(0.41e2) * np.sqrt((1 - t3540)) * ((-1518 * t3529 - 1518 * t3530 + 6270 * t3552 + 6270 * t3532 - 9900 * t3550 - 9900 * t3534 + 7260 * t3548 + 7260 * t3547 - 2310 * t3546 - 2310 * t3545 + 198 * t3539 + 198 * t3540) * np.exp((9*1j) * phi2) + (t3555 - 2024 * t3530 - 2816 * t3552 + 7432 * t3532 + 2036 * t3550 - 10384 * t3534 + 672 * t3548 + 6800 * t3547 - 1252 * t3546 - 2056 * t3545 + 352 * t3539 + 232 * t3540 - 4) * np.exp((-1*1j) * (t3544 + t3542)) + (t3556 + 1265 * t3530 - 1837 * t3552 - 865 * t3532 + 4680 * t3550 - 2934 * t3534 - 2730 * t3548 + 3774 * t3547 - 285 * t3546 - 1355 * t3545 + 487 * t3539 + 115 * t3540 - 62) * np.exp((-1*1j) * (t3543 + t3542)) + (t3555 + 4048 * t3530 + 3256 * t3552 - 6992 * t3532 - 12388 * t3550 + 32 * t3534 + 11088 * t3548 + 4960 * t3547 - 3092 * t3546 - 2288 * t3545 + 120 * t3539 + 240 * t3540 + 4) * np.exp((1j) * (t3544 + t3541)) + (t3556 - 1771 * t3530 - 4873 * t3552 - 5845 * t3532 - 300 * t3550 + 7314 * t3534 + 7518 * t3548 + 1014 * t3547 - 3045 * t3546 - 1975 * t3545 - 133 * t3539 + 239 * t3540 + 62) * np.exp((1j) * (t3543 + t3541))) * ((1 + t3540) ** (-0.1e1 / 0.2e1))

        if Bindx == 123:
            t3575 = np.cos(phi)
            t3574 = t3575 ** 2
            t3580 = t3575 * t3574
            t3583 = t3580 ** 2
            t3564 = t3583 ** 2
            t3592 = 1025 * t3564
            t3591 = 10626 * t3564
            t3590 = 735471 * t3564
            t3581 = t3574 ** 2
            t3582 = t3575 * t3581
            t3587 = t3582 ** 2
            t3585 = t3581 ** 2
            t3579 = 4 * phi1
            t3578 = 8 * phi1
            t3577 = -9 * phi2
            t3576 = 9 * phi2
            t3569 = t3575 * t3583
            t3567 = t3575 * t3585
            t3565 = t3575 * t3587
            tfunc[..., c] = (-0.5e1 / 0.8060928e7*1j) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.41e2) * np.sqrt(0.3e1) * np.sqrt((1 - t3575)) * ((1 + t3575) ** (-0.1e1 / 0.2e1)) * ((17635800 * t3585 + 17635800 * t3569 - 12932920 * t3583 - 12932920 * t3582 - 11169340 * t3587 - 11169340 * t3567 + 4115020 * t3581 + 4115020 * t3580 + 2704156 * t3564 + 2704156 * t3565 - 352716 * t3574 - 352716 * t3575) * np.exp((9*1j) * phi2) + (t3592 + 10250 * t3565 + 45100 * t3587 - 45100 * t3574 - 10250 * t3575 - 1025 + 169125 * t3585 - 169125 * t3581 + 135300 * t3569 - 135300 * t3582 + 112750 * t3567 - 112750 * t3580) * np.exp((3*1j) * (t3579 + 3 * phi2)) + (t3592 - 8200 * t3565 + 26650 * t3587 - 41000 * t3567 + 15375 * t3585 + 49200 * t3569 - 86100 * t3583 + 49200 * t3582 + 15375 * t3581 - 41000 * t3580 + 26650 * t3574 - 8200 * t3575 + 1025) * np.exp((-3*1j) * (t3579 - 3 * phi2)) + (-1470942 * t3565 + 5401206 * t3567 - 7546572 * t3569 + 255816 * t3574 + 168606 * t3575 - 1494198 * t3580 - 909891 * t3581 + 4941900 * t3582 + 488376 * t3583 + 1479663 * t3585 - 2046528 * t3587 - 2907 + t3590) * np.exp((-1*1j) * (t3579 + t3577)) + (t3591 - 53130 * t3565 + 77154 * t3587 + 36330 * t3567 - 196560 * t3585 + 123228 * t3569 + 114660 * t3583 - 158508 * t3582 + 11970 * t3581 + 56910 * t3580 - 20454 * t3574 - 4830 * t3575 + 2604) * np.exp((-1*1j) * (t3578 + t3577)) + (2941884 * t3565 - 5081436 * t3567 + 23256 * t3569 + 87210 * t3574 + 174420 * t3575 - 1662804 * t3580 - 2247111 * t3581 + 3604680 * t3582 + 8058204 * t3583 - 9002979 * t3585 + 2366298 * t3587 + 2907 + t3590) * np.exp((1j) * (t3579 + t3576)) + (t3591 + 74382 * t3565 + 204666 * t3587 + 245490 * t3567 + 12600 * t3585 - 307188 * t3569 - 315756 * t3583 - 42588 * t3582 + 127890 * t3581 + 82950 * t3580 + 5586 * t3574 - 10038 * t3575 - 2604) * np.exp((1j) * (t3578 + t3576)))

        if Bindx == 124:
            t3609 = np.cos(phi)
            t3608 = t3609 ** 2
            t3615 = t3608 ** 2
            t3616 = t3609 * t3615
            t3621 = t3616 ** 2
            t3599 = t3609 * t3621
            t3619 = t3615 ** 2
            t3601 = t3609 * t3619
            t3614 = t3609 * t3608
            t3617 = t3614 ** 2
            t3603 = t3609 * t3617
            t3627 = -920 * t3599 + 2680 * t3601 - 2416 * t3603 - 104 * t3609 + 392 * t3614 + 368 * t3616
            t3626 = -460 * t3599 - 1060 * t3601 + 2472 * t3603 + 140 * t3609 - 540 * t3614 - 552 * t3616
            t3598 = t3617 ** 2
            t3625 = 29 - 69 * t3598 + 116 * t3608 - 1335 * t3615 + 1680 * t3617 + 735 * t3619 - 1156 * t3621
            t3624 = -20 + 276 * t3598 + 400 * t3608 - 2020 * t3615 + 3584 * t3617 - 2332 * t3619 + 112 * t3621
            t3613 = 2 * phi1
            t3612 = 4 * phi1
            t3611 = -5 * phi2
            t3610 = 5 * phi2
            tfunc[..., c] = -(0.5e1 / 0.335872e6) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.19e2) * np.sqrt(0.13e2) * np.sqrt(0.17e2) * np.sqrt(0.7e1) * np.sqrt(0.41e2) * ((-414 * t3598 + 2088 * t3621 - 4230 * t3619 + 4320 * t3617 - 2250 * t3615 + 504 * t3608 - 18) * np.exp((10*1j) * phi2) + (t3624 + t3627) * np.exp((-2*1j) * (t3613 + t3611)) + (t3625 - t3626) * np.exp((-2*1j) * (t3612 + t3611)) + (t3624 - t3627) * np.exp((2*1j) * (t3613 + t3610)) + (t3625 + t3626) * np.exp((2*1j) * (t3612 + t3610)))

        if Bindx == 125:
            t3646 = np.cos(phi)
            t3645 = t3646 ** 2
            t3652 = t3646 * t3645
            t3655 = t3652 ** 2
            t3635 = t3655 ** 2
            t3653 = t3645 ** 2
            t3657 = t3653 ** 2
            t3654 = t3646 * t3653
            t3659 = t3654 ** 2
            t3667 = 1025 * t3635 - 45100 * t3645 + 45100 * t3659 - 1025 + 169125 * t3657 - 169125 * t3653
            t3636 = t3646 * t3659
            t3638 = t3646 * t3657
            t3640 = t3646 * t3655
            t3666 = -70840 * t3636 - 163240 * t3638 + 380688 * t3640 + 21560 * t3646 - 83160 * t3652 - 85008 * t3654
            t3665 = -10250 * t3636 + 10250 * t3646 - 135300 * t3640 + 135300 * t3654 - 112750 * t3638 + 112750 * t3652
            t3664 = 10626 * t3635 - 17864 * t3645 + 205590 * t3653 - 258720 * t3655 - 113190 * t3657 + 178024 * t3659 - 4466
            t3663 = -2451570 * t3636 + 7141530 * t3638 - 6438036 * t3640 - 277134 * t3646 + 1044582 * t3652 + 980628 * t3654
            t3662 = 735471 * t3635 + 1065900 * t3645 - 5382795 * t3653 + 9550464 * t3655 - 6214197 * t3657 + 298452 * t3659 - 53295
            t3651 = 2 * phi1
            t3650 = 4 * phi1
            t3649 = 6 * phi1
            t3648 = -5 * phi2
            t3647 = 5 * phi2
            tfunc[..., c] = (0.5e1 / 0.5373952e7) * np.sqrt(0.23e2) * np.sqrt(0.2e1) * np.sqrt(0.41e2) * ((2704156 * t3635 - 13638352 * t3659 + 27629420 * t3657 - 28217280 * t3655 + 14696500 * t3653 - 3292016 * t3645 + 117572) * np.exp((10*1j) * phi2) + (t3665 + t3667) * np.exp((-2*1j) * (t3649 + t3648)) + (-t3665 + t3667) * np.exp((2*1j) * (t3649 + t3647)) + (t3662 + t3663) * np.exp((-2*1j) * (t3651 + t3648)) + (t3664 + t3666) * np.exp((-2*1j) * (t3650 + t3648)) + (t3662 - t3663) * np.exp((2*1j) * (t3651 + t3647)) + (t3664 - t3666) * np.exp((2*1j) * (t3650 + t3647)))

        if Bindx == 126:
            t3683 = np.cos(phi)
            t3682 = t3683 ** 2
            t3689 = t3682 ** 2
            t3690 = t3683 * t3689
            t3695 = t3690 ** 2
            t3673 = t3683 * t3695
            t3698 = 3 * t3673
            t3697 = 1 + t3683
            t3693 = t3689 ** 2
            t3688 = t3683 * t3682
            t3691 = t3688 ** 2
            t3687 = 4 * phi1
            t3686 = 8 * phi1
            t3685 = -11 * phi2
            t3684 = 11 * phi2
            t3677 = t3683 * t3691
            t3675 = t3683 * t3693
            tfunc[..., c] = (0.5e1 / 0.335872e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * np.sqrt(0.41e2) * np.sqrt(0.11e2) * ((1 - t3683) ** (0.3e1 / 0.2e1)) * (t3697 ** (-0.1e1 / 0.2e1)) * (18 * (t3673 + 2 * t3695 - 3 * t3675 - 8 * t3693 + 2 * t3677 + 12 * t3691 + 2 * t3690 - 8 * t3689 - 3 * t3688 + 2 * t3682 + t3683) * np.exp((11*1j) * phi2) + 4 * (-3 * t3673 + 5 * t3695 + 11 * t3675 - 21 * t3693 - 14 * t3677 + 34 * t3691 + 6 * t3690 - 26 * t3689 + t3688 + 9 * t3682 - t3697) * np.exp((-1*1j) * (t3687 + t3685)) + (t3698 - 16 * t3695 + 27 * t3675 + 2 * t3693 - 58 * t3677 + 56 * t3691 + 14 * t3690 - 52 * t3689 + 23 * t3688 + 8 * t3682 - 9 * t3683 + 2) * np.exp((-1*1j) * (t3686 + t3685)) + (-12 * t3673 - 68 * t3695 - 132 * t3675 - 44 * t3693 + 200 * t3677 + 280 * t3691 + 56 * t3690 - 152 * t3689 - 124 * t3688 - 20 * t3682 + 12 * t3683 + 4) * np.exp((1j) * (t3687 + t3684)) + (t3698 + 28 * t3695 + 115 * t3675 + 270 * t3693 + 390 * t3677 + 336 * t3691 + 126 * t3690 - 60 * t3689 - 105 * t3688 - 60 * t3682 - 17 * t3683 - 2) * np.exp((1j) * (t3686 + t3684)))

        if Bindx == 127:
            t3717 = np.cos(phi)
            t3716 = t3717 ** 2
            t3723 = t3717 * t3716
            t3726 = t3723 ** 2
            t3706 = t3726 ** 2
            t3735 = 1025 * t3706
            t3734 = 10626 * t3706
            t3733 = 735471 * t3706
            t3724 = t3716 ** 2
            t3725 = t3717 * t3724
            t3730 = t3725 ** 2
            t3728 = t3724 ** 2
            t3722 = 4 * phi1
            t3721 = 8 * phi1
            t3720 = 12 * phi1
            t3719 = -11 * phi2
            t3718 = 11 * phi2
            t3711 = t3717 * t3726
            t3709 = t3717 * t3728
            t3707 = t3717 * t3730
            tfunc[..., c] = (-0.5e1 / 0.2686976e7*1j) * np.sqrt(0.41e2) * np.sqrt((1 - t3717)) * ((1 + t3717) ** (-0.1e1 / 0.2e1)) * (2704156 * (10 * t3728 + 10 * t3711 - 10 * t3726 - 10 * t3725 - 5 * t3730 - 5 * t3709 + 5 * t3724 + 5 * t3723 + t3706 + t3707 - t3716 - t3717) * np.exp((11*1j) * phi2) + (-1716099 * t3728 + 7845024 * t3709 - 11767536 * t3711 + 2451570 * t3716 - 6619239 * t3724 + 7845024 * t3725 + 6864396 * t3726 - 1470942 * t3730 + t3733 - 245157 - 1961256 * t3707 - 1961256 * t3723) * np.exp((-1*1j) * (t3722 + t3719)) + (t3735 - 10250 * t3707 + 45100 * t3730 - 45100 * t3716 + 10250 * t3717 - 1025 + 169125 * t3728 - 169125 * t3724 - 135300 * t3711 + 135300 * t3725 - 112750 * t3709 + 112750 * t3723) * np.exp((-1*1j) * (t3720 + t3719)) + (-67298 * t3707 - 88550 * t3709 + 403788 * t3711 - 60214 * t3716 + 38962 * t3717 - 53130 * t3723 + 265650 * t3724 - 233772 * t3725 - 148764 * t3726 - 212520 * t3728 + 152306 * t3730 + t3734 - 7084) * np.exp((-1*1j) * (t3721 + t3719)) + (3432198 * t3707 - 5393454 * t3709 - 4903140 * t3711 - 1961256 * t3716 + 490314 * t3717 - 6374082 * t3723 - 1716099 * t3724 + 12748164 * t3725 + 13728792 * t3726 - 14954577 * t3728 + 3922512 * t3730 + t3733 + 245157) * np.exp((1j) * (t3722 + t3718)) + (88550 * t3707 + 549010 * t3709 - 191268 * t3711 + 152306 * t3716 + 53130 * t3717 + 159390 * t3723 - 159390 * t3724 - 658812 * t3725 - 743820 * t3726 + 425040 * t3728 + 308154 * t3730 + t3734 + 7084) * np.exp((1j) * (t3721 + t3718)) + (t3735 + 12300 * t3707 + 67650 * t3730 + 947100 * t3726 + 67650 * t3716 + 12300 * t3717 + 1025 + 811800 * t3711 + 811800 * t3725 + 507375 * t3728 + 507375 * t3724 + 225500 * t3709 + 225500 * t3723) * np.exp((1j) * (t3720 + t3718)))

        if Bindx == 128:
            t3752 = np.cos(phi)
            t3751 = t3752 ** 2
            t3757 = t3751 ** 2
            t3758 = t3752 * t3757
            t3763 = t3758 ** 2
            t3770 = (-t3763 - 1) * t3752
            t3761 = t3757 ** 2
            t3744 = t3752 * t3761
            t3756 = t3752 * t3751
            t3759 = t3756 ** 2
            t3746 = t3752 * t3759
            t3769 = -40 * t3744 + 48 * t3746 - 40 * t3756 + 48 * t3758 + 8 * t3770
            t3768 = 48 * t3744 - 32 * t3746 + 48 * t3756 - 32 * t3758 + 16 * t3770
            t3741 = t3759 ** 2
            t3767 = -4 - 4 * t3741 - 8 * t3751 + 68 * t3757 - 112 * t3759 + 68 * t3761 - 8 * t3763
            t3766 = 1 + t3741 + 26 * t3751 + 15 * t3757 - 84 * t3759 + 15 * t3761 + 26 * t3763
            t3755 = 2 * phi1
            t3754 = -3 * phi2
            t3753 = 3 * phi2
            tfunc[..., c] = (0.15e2 / 0.671744e6) * np.sqrt(0.11e2) * np.sqrt(0.41e2) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * ((6 * t3741 - 36 * t3763 + 90 * t3761 - 120 * t3759 + 90 * t3757 - 36 * t3751 + 6) * np.exp((12*1j) * phi2) + (t3766 + t3769) * np.exp((-4*1j) * (t3755 + t3754)) + (t3766 - t3769) * np.exp((4*1j) * (t3755 + t3753)) + (t3767 - t3768) * np.exp((-4*1j) * (phi1 + t3754)) + (t3767 + t3768) * np.exp((4*1j) * (phi1 + t3753)))

        if Bindx == 129:
            t3789 = np.cos(phi)
            t3788 = t3789 ** 2
            t3794 = t3788 ** 2
            t3798 = t3794 ** 2
            t3811 = t3798 + t3794
            t3795 = t3789 * t3794
            t3800 = t3795 ** 2
            t3810 = t3800 + t3788
            t3779 = t3789 * t3800
            t3809 = -t3779 - t3789
            t3793 = t3789 * t3788
            t3796 = t3793 ** 2
            t3778 = t3796 ** 2
            t3808 = 1025 * t3778 + 67650 * t3788 + 947100 * t3796 + 67650 * t3800 + 507375 * t3811 + 1025
            t3781 = t3789 * t3798
            t3783 = t3789 * t3796
            t3807 = -12300 * t3779 - 12300 * t3789 - 811800 * t3783 - 811800 * t3795 - 225500 * t3781 - 225500 * t3793
            t3806 = 510048 * t3783 + 510048 * t3795 - 425040 * t3781 - 425040 * t3793 + 85008 * t3809
            t3805 = 10626 * t3778 - 892584 * t3796 + 276276 * t3810 + 159390 * t3811 + 10626
            t3804 = 8825652 * t3781 + 8825652 * t3793 - 5883768 * t3783 - 5883768 * t3795 + 2941884 * t3809
            t3803 = 735471 * t3778 + 20593188 * t3796 + 1470942 * t3810 - 12503007 * t3811 + 735471
            t3792 = 2 * phi1
            t3791 = -3 * phi2
            t3790 = 3 * phi2
            tfunc[..., c] = (0.5e1 / 0.32243712e8) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.41e2) * ((-54083120 * t3796 + 2704156 * t3778 + 2704156 + 40562340 * t3798 + 40562340 * t3794 - 16224936 * t3800 - 16224936 * t3788) * np.exp((12*1j) * phi2) + (t3803 + t3804) * np.exp((-4*1j) * (phi1 + t3791)) + (t3805 + t3806) * np.exp((-4*1j) * (t3792 + t3791)) + (t3803 - t3804) * np.exp((4*1j) * (phi1 + t3790)) + (t3805 - t3806) * np.exp((4*1j) * (t3792 + t3790)) + (t3807 + t3808) * np.exp((-12*1j) * (phi1 - phi2)) + (-t3807 + t3808) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 130:
            t3830 = np.cos(phi)
            t3829 = t3830 ** 2
            t3836 = t3830 * t3829
            t3839 = t3836 ** 2
            t3845 = t3839 ** 2
            t3818 = t3830 * t3845
            t3849 = 1 - t3818
            t3848 = 20 - 20 * t3818
            t3847 = 475 - 475 * t3818
            t3837 = t3829 ** 2
            t3838 = t3830 * t3837
            t3843 = t3838 ** 2
            t3841 = t3837 ** 2
            t3835 = 4 * phi1
            t3834 = 8 * phi1
            t3833 = 12 * phi1
            t3832 = -13 * phi2
            t3831 = 13 * phi2
            t3824 = t3830 * t3839
            t3822 = t3830 * t3841
            t3820 = t3830 * t3843
            tfunc[..., c] = (-0.9e1 / 0.131072e6*1j) * np.sqrt((1 + t3830)) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * ((-11 * t3845 - 54 * t3820 - 154 * t3843 - 275 * t3822 - 297 * t3841 - 132 * t3824 + 132 * t3839 + 297 * t3838 + 275 * t3837 + 154 * t3836 + 54 * t3829 + 11 * t3830 + t3849) * np.exp((-1*1j) * (t3833 + t3831)) + (-13 * t3845 + 78 * t3820 - 286 * t3843 + 715 * t3822 - 1287 * t3841 + 1716 * t3824 - 1716 * t3839 + 1287 * t3838 - 715 * t3837 + 286 * t3836 - 78 * t3829 + 13 * t3830 - t3849) * np.exp((1j) * (t3833 + t3832)) + (1425 * t3845 - 950 * t3820 - 6650 * t3843 - 2375 * t3822 + 11875 * t3841 + 9500 * t3824 - 9500 * t3839 - 11875 * t3838 + 2375 * t3837 + 6650 * t3836 + 950 * t3829 - 1425 * t3830 - t3847) * np.exp((-1*1j) * (t3835 + t3831)) + (140 * t3845 + 360 * t3820 + 280 * t3843 - 500 * t3822 - 1260 * t3841 - 720 * t3824 + 720 * t3839 + 1260 * t3838 + 500 * t3837 - 280 * t3836 - 360 * t3829 - 140 * t3830 - t3848) * np.exp((-1*1j) * (t3834 + t3831)) + (2375 * t3845 - 2850 * t3820 - 4750 * t3843 + 13775 * t3822 - 4275 * t3841 - 17100 * t3824 + 17100 * t3839 + 4275 * t3838 - 13775 * t3837 + 4750 * t3836 + 2850 * t3829 - 2375 * t3830 + t3847) * np.exp((1j) * (t3835 + t3832)) + (180 * t3845 - 680 * t3820 + 1320 * t3843 - 1100 * t3822 - 660 * t3841 + 2640 * t3824 - 2640 * t3839 + 660 * t3838 + 1100 * t3837 - 1320 * t3836 + 680 * t3829 - 180 * t3830 + t3848) * np.exp((1j) * (t3834 + t3832))) * ((1 - t3830) ** (-0.1e1 / 0.2e1))

        if Bindx == 131:
            t3868 = np.cos(phi)
            t3867 = t3868 ** 2
            t3873 = t3867 ** 2
            t3872 = t3868 * t3867
            t3875 = t3872 ** 2
            t3877 = t3873 ** 2
            t3874 = t3868 * t3873
            t3879 = t3874 ** 2
            t3881 = t3875 ** 2
            t3888 = 12 + 636 * t3867 + 3080 * t3873 + 792 * t3875 - 4356 * t3877 - 2068 * t3879 - 144 * t3881
            t3887 = -160 - 2080 * t3867 + 8000 * t3873 + 960 * t3875 - 14880 * t3877 + 6240 * t3879 + 1920 * t3881
            t3856 = t3868 * t3881
            t3858 = t3868 * t3879
            t3860 = t3868 * t3877
            t3862 = t3868 * t3875
            t3886 = -13 * t3856 - 714 * t3858 - 3795 * t3860 - 2508 * t3862 + 131 * t3868 + 1782 * t3872 + 3069 * t3874
            t3885 = -260 * t3856 - 5480 * t3858 + 2500 * t3860 + 14160 * t3862 + 1020 * t3868 - 360 * t3872 - 11580 * t3874
            t3884 = -1900 + 20900 * t3867 - 41800 * t3873 - 3800 * t3875 + 81700 * t3877 - 77900 * t3879 + 22800 * t3881
            t3883 = -6175 * t3856 - 4750 * t3858 + 82175 * t3860 - 157700 * t3862 + 1425 * t3868 - 35150 * t3872 + 120175 * t3874
            t3871 = 2 * phi1
            t3870 = -3 * phi2
            t3869 = 3 * phi2
            tfunc[..., c] = -(0.9e1 / 0.131072e6) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * ((-t3883 + t3884) * np.exp((-4*1j) * (phi1 + t3869)) + (-t3885 + t3887) * np.exp((-4*1j) * (t3871 + t3869)) + (t3883 + t3884) * np.exp((4*1j) * (phi1 + t3870)) + (t3885 + t3887) * np.exp((4*1j) * (t3871 + t3870)) + (t3886 + t3888) * np.exp((-12*1j) * (phi1 + phi2)) + (-t3886 + t3888) * np.exp((12*1j) * (phi1 - phi2)))

        if Bindx == 132:
            t3908 = np.cos(phi)
            t3907 = t3908 ** 2
            t3914 = t3908 * t3907
            t3917 = t3914 ** 2
            t3923 = t3917 ** 2
            t3896 = t3908 * t3923
            t3915 = t3907 ** 2
            t3916 = t3908 * t3915
            t3921 = t3916 ** 2
            t3898 = t3908 * t3921
            t3919 = t3915 ** 2
            t3900 = t3908 * t3919
            t3918 = t3908 * t3917
            t3931 = 132 * t3896 + 1408 * t3898 + 836 * t3900 + 108 * t3908 + 992 * t3914 - 308 * t3916 - 3168 * t3918
            t3930 = -1760 * t3896 - 2816 * t3898 + 13600 * t3900 - 416 * t3908 + 2560 * t3914 - 1184 * t3916 - 9984 * t3918
            t3895 = t3918 ** 2
            t3929 = -11 - 13 * t3895 - 451 * t3907 - 1023 * t3915 + 2409 * t3917 + 1551 * t3919 - 1881 * t3921 - 581 * t3923
            t3928 = -92 - 260 * t3895 - 92 * t3907 + 4660 * t3915 - 11532 * t3917 + 5100 * t3919 + 6508 * t3921 - 4292 * t3923
            t3927 = -20900 * t3896 + 80256 * t3898 - 109668 * t3900 + 2356 * t3908 - 12768 * t3914 + 6612 * t3916 + 54112 * t3918
            t3926 = 6175 * t3895 - 8303 * t3907 + 51813 * t3915 - 125267 * t3917 + 136363 * t3919 - 58653 * t3921 - 2489 * t3923 + 361
            t3913 = 4 * phi1
            t3912 = 8 * phi1
            t3911 = 12 * phi1
            t3910 = -11 * phi2
            t3909 = 11 * phi2
            tfunc[..., c] = (0.45e2 / 0.131072e6*1j) * np.sqrt(0.11e2) * np.sqrt(0.23e2) * np.sqrt(0.3e1) * ((1 + t3908) ** (-0.1e1 / 0.2e1)) * ((1 - t3908) ** (-0.1e1 / 0.2e1)) * ((-t3926 + t3927) * np.exp((-1*1j) * (t3913 + t3909)) + (t3928 + t3930) * np.exp((-1*1j) * (t3912 + t3909)) + (t3926 + t3927) * np.exp((1j) * (t3913 + t3910)) + (-t3928 + t3930) * np.exp((1j) * (t3912 + t3910)) + (-t3929 + t3931) * np.exp((-1*1j) * (t3911 + t3909)) + (t3929 + t3931) * np.exp((1j) * (t3911 + t3910)))

        if Bindx == 133:
            t3950 = np.cos(phi)
            t3949 = t3950 ** 2
            t3957 = t3949 ** 2
            t3956 = t3950 * t3949
            t3959 = t3956 ** 2
            t3961 = t3957 ** 2
            t3958 = t3950 * t3957
            t3963 = t3958 ** 2
            t3965 = t3959 ** 2
            t3972 = -10 - 310 * t3949 - 220 * t3957 + 1716 * t3959 - 66 * t3961 - 990 * t3963 - 120 * t3965
            t3971 = 48 - 432 * t3949 - 352 * t3957 + 5664 * t3959 - 8208 * t3961 + 1680 * t3963 + 1600 * t3965
            t3938 = t3950 * t3965
            t3940 = t3950 * t3963
            t3942 = t3950 * t3961
            t3944 = t3950 * t3959
            t3970 = -13 * t3938 - 472 * t3940 - 1045 * t3942 + 1320 * t3944 - 87 * t3950 - 528 * t3956 + 825 * t3958
            t3969 = -38 + 1254 * t3949 + 1596 * t3957 - 30932 * t3959 + 71250 * t3961 - 62130 * t3963 + 19000 * t3965
            t3968 = -260 * t3938 - 3456 * t3940 + 5052 * t3942 + 1632 * t3944 - 108 * t3950 + 1568 * t3956 - 4428 * t3958
            t3967 = -6175 * t3938 + 3192 * t3940 + 37449 * t3942 - 70984 * t3944 + 1235 * t3950 - 13680 * t3956 + 48963 * t3958
            t3955 = 2 * phi1
            t3954 = 4 * phi1
            t3953 = 6 * phi1
            t3952 = -5 * phi2
            t3951 = 5 * phi2
            tfunc[..., c] = -(0.45e2 / 0.65536e5) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * ((-t3967 + t3969) * np.exp((-2*1j) * (t3955 + t3951)) + (-t3968 + t3971) * np.exp((-2*1j) * (t3954 + t3951)) + (t3970 + t3972) * np.exp((-2*1j) * (t3953 + t3951)) + (t3967 + t3969) * np.exp((2*1j) * (t3955 + t3952)) + (t3968 + t3971) * np.exp((2*1j) * (t3954 + t3952)) + (-t3970 + t3972) * np.exp((2*1j) * (t3953 + t3952)))

        if Bindx == 134:
            t3992 = np.cos(phi)
            t3991 = t3992 ** 2
            t3997 = t3992 * t3991
            t4000 = t3997 ** 2
            t4006 = t4000 ** 2
            t3980 = t3992 * t4006
            t3998 = t3991 ** 2
            t3999 = t3992 * t3998
            t4004 = t3999 ** 2
            t3982 = t3992 * t4004
            t4002 = t3998 ** 2
            t3984 = t3992 * t4002
            t4001 = t3992 * t4000
            t4014 = 2484 * t3980 + 12696 * t3982 - 21252 * t3984 - 1564 * t3992 - 3496 * t3997 + 23276 * t3999 - 12144 * t4001
            t3979 = t4001 ** 2
            t4013 = -207 + 299 * t3979 - 4347 * t3991 + 8349 * t3998 + 17457 * t4000 - 32637 * t4002 + 2783 * t4004 + 8303 * t4006
            t4012 = 5980 * t3979 + 9348 * t3991 - 39708 * t3998 + 32532 * t4000 + 83388 * t4002 - 147444 * t4004 + 56396 * t4006 - 492
            t4011 = -33120 * t3980 + 13248 * t3982 + 124128 * t3984 - 480 * t3992 - 8768 * t3997 + 74336 * t3999 - 169344 * t4001
            t4010 = -393300 * t3980 + 1457832 * t3982 - 2053596 * t3984 - 2052 * t3992 + 46056 * t3997 - 403788 * t3999 + 1348848 * t4001
            t4009 = -142025 * t3979 + 59641 * t3991 - 416271 * t3998 + 1107605 * t4000 - 1258769 * t4002 + 427899 * t4004 + 223307 * t4006 - 1387
            t3996 = 4 * phi1
            t3995 = 8 * phi1
            t3994 = -9 * phi2
            t3993 = 9 * phi2
            tfunc[..., c] = (0.45e2 / 0.131072e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * ((1 + t3992) ** (-0.1e1 / 0.2e1)) * ((1 - t3992) ** (-0.1e1 / 0.2e1)) * ((t4013 + t4014) * np.exp((-3*1j) * (t3996 + 3 * phi2)) + (t4009 + t4010) * np.exp((-1*1j) * (t3996 + t3993)) + (t4011 - t4012) * np.exp((-1*1j) * (t3995 + t3993)) + (-t4009 + t4010) * np.exp((1j) * (t3996 + t3994)) + (t4011 + t4012) * np.exp((1j) * (t3995 + t3994)) + (-t4013 + t4014) * np.exp((3*1j) * (t3996 - 3 * phi2)))

        if Bindx == 135:
            t4033 = np.cos(phi)
            t4032 = t4033 ** 2
            t4038 = t4032 ** 2
            t4037 = t4033 * t4032
            t4040 = t4037 ** 2
            t4042 = t4038 ** 2
            t4039 = t4033 * t4038
            t4044 = t4039 ** 2
            t4046 = t4040 ** 2
            t4053 = 26312 * t4032 - 101200 * t4038 - 12144 * t4040 + 188232 * t4042 - 78936 * t4044 - 24288 * t4046 + 2024
            t4021 = t4033 * t4046
            t4023 = t4033 * t4044
            t4025 = t4033 * t4042
            t4027 = t4033 * t4040
            t4052 = 3289 * t4021 + 69322 * t4023 - 31625 * t4025 - 179124 * t4027 - 12903 * t4033 + 4554 * t4037 + 146487 * t4039
            t4051 = -65780 * t4021 - 455400 * t4023 + 1156980 * t4025 - 743856 * t4027 - 13236 * t4033 + 77848 * t4037 + 39348 * t4039
            t4050 = 46656 * t4032 - 346240 * t4038 + 859776 * t4040 - 635328 * t4042 - 242880 * t4044 + 323840 * t4046 - 1728
            t4049 = -193800 * t4032 + 1901520 * t4038 - 7659280 * t4040 + 14215800 * t4042 - 12113640 * t4044 + 3845600 * t4046 + 3800
            t4048 = -1562275 * t4021 + 2451570 * t4023 + 2047155 * t4025 - 6055300 * t4027 + 61085 * t4033 - 977550 * t4037 + 4035315 * t4039
            t4036 = 3 * phi1
            t4035 = -2 * phi2
            t4034 = 2 * phi2
            tfunc[..., c] = -(0.9e1 / 0.65536e5) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * ((t4050 - t4051) * np.exp((-8*1j) * (phi1 + phi2)) + (-t4048 + t4049) * np.exp((-4*1j) * (phi1 + t4034)) + (-t4052 + t4053) * np.exp((-4*1j) * (t4036 + t4034)) + (t4048 + t4049) * np.exp((4*1j) * (phi1 + t4035)) + (t4052 + t4053) * np.exp((4*1j) * (t4036 + t4035)) + (t4050 + t4051) * np.exp((8*1j) * (phi1 - phi2)))

        if Bindx == 136:
            t4073 = np.cos(phi)
            t4072 = t4073 ** 2
            t4079 = t4073 * t4072
            t4082 = t4079 ** 2
            t4088 = t4082 ** 2
            t4061 = t4073 * t4088
            t4080 = t4072 ** 2
            t4081 = t4073 * t4080
            t4086 = t4081 ** 2
            t4063 = t4073 * t4086
            t4084 = t4080 ** 2
            t4065 = t4073 * t4084
            t4083 = t4073 * t4082
            t4096 = -21252 * t4061 - 14168 * t4063 + 162932 * t4065 - 9108 * t4073 + 34408 * t4079 + 29348 * t4081 - 182160 * t4083
            t4060 = t4083 ** 2
            t4095 = -3289 * t4060 - 8855 * t4072 + 90321 * t4080 - 143451 * t4082 + 6831 * t4084 + 107019 * t4086 - 46805 * t4088 - 1771
            t4094 = 283360 * t4061 - 566720 * t4063 + 72352 * t4065 - 10144 * t4073 + 117824 * t4079 - 428512 * t4081 + 531840 * t4083
            t4093 = -65780 * t4060 + 980 * t4072 - 100492 * t4080 + 599844 * t4082 - 1269204 * t4084 + 1082620 * t4086 - 247940 * t4088 - 28
            t4092 = 3364900 * t4061 - 12113640 * t4063 + 16989420 * t4065 + 31540 * t4073 - 640680 * t4079 + 4043580 * t4081 - 11675120 * t4083
            t4091 = -1562275 * t4060 + 128915 * t4072 - 1110645 * t4080 + 3057575 * t4082 - 2494795 * t4084 - 1934295 * t4086 + 3917705 * t4088 - 2185
            t4078 = 4 * phi1
            t4077 = 8 * phi1
            t4076 = -7 * phi2
            t4075 = 7 * phi2
            t4074 = 12 * phi1
            tfunc[..., c] = (-0.9e1 / 0.131072e6*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * ((-t4091 + t4092) * np.exp((-1*1j) * (t4078 + t4075)) + (-t4093 + t4094) * np.exp((-1*1j) * (t4077 + t4075)) + (t4091 + t4092) * np.exp((1j) * (t4078 + t4076)) + (t4093 + t4094) * np.exp((1j) * (t4077 + t4076)) + (t4095 + t4096) * np.exp((-1*1j) * (t4074 + t4075)) + (-t4095 + t4096) * np.exp((1j) * (t4074 + t4076))) * ((1 + t4073) ** (-0.1e1 / 0.2e1)) * ((1 - t4073) ** (-0.1e1 / 0.2e1))

        if Bindx == 137:
            t4115 = np.cos(phi)
            t4114 = t4115 ** 2
            t4120 = t4115 * t4114
            t4123 = t4120 ** 2
            t4129 = t4123 ** 2
            t4103 = t4115 * t4129
            t4121 = t4114 ** 2
            t4122 = t4115 * t4121
            t4127 = t4122 ** 2
            t4105 = t4115 * t4127
            t4125 = t4121 ** 2
            t4107 = t4115 * t4125
            t4109 = t4115 * t4123
            t4136 = -3289 * t4103 - 30360 * t4105 + 91839 * t4107 - 54648 * t4109 - 5819 * t4115 + 36432 * t4120 - 34155 * t4122
            t4135 = 1518 * t4114 + 47564 * t4121 - 118404 * t4123 + 77418 * t4125 + 11638 * t4127 - 18216 * t4129 - 1518
            t4134 = 20336 * t4114 - 99616 * t4121 + 82272 * t4123 + 276816 * t4125 - 522192 * t4127 + 242880 * t4129 - 496
            t4133 = -65780 * t4103 - 129536 * t4105 + 658636 * t4107 - 742176 * t4109 + 4164 * t4115 - 63456 * t4120 + 338148 * t4122
            t4132 = -1562275 * t4103 + 3730232 * t4105 - 2590555 * t4107 + 28120 * t4109 + 7239 * t4115 - 138320 * t4120 + 525559 * t4122
            t4131 = -130910 * t4114 + 1390420 * t4121 - 5531356 * t4123 + 10201670 * t4125 - 8816038 * t4127 + 2884200 * t4129 + 2014
            t4119 = 2 * phi1
            t4118 = 4 * phi1
            t4117 = -3 * phi2
            t4116 = 3 * phi2
            tfunc[..., c] = -(0.45e2 / 0.65536e5) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * ((t4135 + t4136) * np.exp((-6*1j) * (t4119 + phi2)) + (t4131 - t4132) * np.exp((-2*1j) * (t4119 + t4116)) + (-t4133 + t4134) * np.exp((-2*1j) * (t4118 + t4116)) + (t4131 + t4132) * np.exp((2*1j) * (t4119 + t4117)) + (t4133 + t4134) * np.exp((2*1j) * (t4118 + t4117)) + (t4135 - t4136) * np.exp((6*1j) * (t4119 - phi2)))

        if Bindx == 138:
            t4156 = np.cos(phi)
            t4155 = t4156 ** 2
            t4162 = t4156 * t4155
            t4165 = t4162 ** 2
            t4171 = t4165 ** 2
            t4144 = t4156 * t4171
            t4163 = t4155 ** 2
            t4164 = t4156 * t4163
            t4169 = t4164 ** 2
            t4146 = t4156 * t4169
            t4167 = t4163 ** 2
            t4148 = t4156 * t4167
            t4166 = t4156 * t4165
            t4179 = -15180 * t4144 + 40480 * t4146 - 7084 * t4148 + 3036 * t4156 - 32384 * t4162 + 83996 * t4164 - 72864 * t4166
            t4143 = t4166 ** 2
            t4178 = -3289 * t4143 - 8855 * t4155 - 3795 * t4163 + 75141 * t4165 - 129789 * t4167 + 82731 * t4169 - 13409 * t4171 + 1265
            t4177 = 202400 * t4144 - 647680 * t4146 + 756128 * t4148 - 544 * t4156 + 2816 * t4162 + 63968 * t4164 - 377088 * t4166
            t4176 = -65780 * t4143 + 20116 * t4155 - 160988 * t4163 + 503844 * t4165 - 703236 * t4167 + 375100 * t4169 + 31372 * t4171 - 428
            t4175 = -1562275 * t4143 - 3053 * t4155 + 88895 * t4163 - 870585 * t4165 + 3394065 * t4167 - 6060791 * t4169 + 5013701 * t4171 + 43
            t4174 = 2403500 * t4144 - 8460320 * t4146 + 11611660 * t4148 + 15940 * t4156 - 376960 * t4162 + 2589188 * t4164 - 7783008 * t4166
            t4161 = 4 * phi1
            t4160 = 8 * phi1
            t4159 = -5 * phi2
            t4158 = 5 * phi2
            t4157 = 12 * phi1
            tfunc[..., c] = (-0.45e2 / 0.131072e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * ((t4174 - t4175) * np.exp((-1*1j) * (t4161 + t4158)) + (-t4176 + t4177) * np.exp((-1*1j) * (t4160 + t4158)) + (t4174 + t4175) * np.exp((1j) * (t4161 + t4159)) + (t4176 + t4177) * np.exp((1j) * (t4160 + t4159)) + (t4178 + t4179) * np.exp((-1*1j) * (t4157 + t4158)) + (-t4178 + t4179) * np.exp((1j) * (t4157 + t4159))) * ((1 + t4156) ** (-0.1e1 / 0.2e1)) * ((1 - t4156) ** (-0.1e1 / 0.2e1))

        if Bindx == 139:
            t4198 = np.cos(phi)
            t4197 = t4198 ** 2
            t4202 = t4197 ** 2
            t4201 = t4198 * t4197
            t4204 = t4201 ** 2
            t4206 = t4202 ** 2
            t4203 = t4198 * t4202
            t4208 = t4203 ** 2
            t4210 = t4204 ** 2
            t4217 = 1012 - 11132 * t4197 + 22264 * t4202 + 2024 * t4204 - 43516 * t4206 + 41492 * t4208 - 12144 * t4210
            t4186 = t4198 * t4210
            t4188 = t4198 * t4208
            t4190 = t4198 * t4206
            t4192 = t4198 * t4204
            t4216 = 3289 * t4186 + 2530 * t4188 - 43769 * t4190 + 83996 * t4192 - 759 * t4198 + 18722 * t4201 - 64009 * t4203
            t4215 = 65780 * t4186 - 103224 * t4188 - 86196 * t4190 + 254960 * t4192 - 2572 * t4198 + 41160 * t4201 - 169908 * t4203
            t4214 = -8160 * t4197 + 80064 * t4202 - 322496 * t4204 + 598560 * t4206 - 510048 * t4208 + 161920 * t4210 + 160
            t4213 = -65700 * t4197 + 780360 * t4202 - 3347496 * t4204 + 6460380 * t4206 - 5749172 * t4208 + 1922800 * t4210 + 876
            t4212 = -1562275 * t4186 + 4643562 * t4188 - 5292925 * t4190 + 2917260 * t4192 - 3891 * t4198 + 100650 * t4201 - 804429 * t4203
            t4200 = 2 * phi1
            t4199 = 3 * phi1
            tfunc[..., c] = -(0.45e2 / 0.131072e6) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * np.sqrt(0.2e1) * ((-t4212 + t4213) * np.exp((-4*1j) * (phi1 + phi2)) + (t4214 + t4215) * np.exp((-4*1j) * (t4200 + phi2)) + (-t4216 + t4217) * np.exp((-4*1j) * (t4199 + phi2)) + (t4212 + t4213) * np.exp((4*1j) * (phi1 - phi2)) + (t4214 - t4215) * np.exp((4*1j) * (t4200 - phi2)) + (t4216 + t4217) * np.exp((4*1j) * (t4199 - phi2)))

        if Bindx == 140:
            t4237 = np.cos(phi)
            t4236 = t4237 ** 2
            t4242 = t4237 * t4236
            t4245 = t4242 ** 2
            t4251 = t4245 ** 2
            t4225 = t4237 * t4251
            t4243 = t4236 ** 2
            t4244 = t4237 * t4243
            t4249 = t4244 ** 2
            t4227 = t4237 * t4249
            t4247 = t4243 ** 2
            t4229 = t4237 * t4247
            t4246 = t4237 * t4245
            t4259 = -9108 * t4225 + 44528 * t4227 - 86020 * t4229 + 1012 * t4237 + 4048 * t4242 - 35420 * t4244 + 80960 * t4246
            t4224 = t4246 ** 2
            t4258 = -759 - 3289 * t4224 + 11385 * t4236 - 42251 * t4243 + 67045 * t4245 - 46805 * t4247 + 5819 * t4249 + 8855 * t4251
            t4257 = -65780 * t4224 + 4180 * t4236 - 29244 * t4243 + 43172 * t4245 + 71068 * t4247 - 240900 * t4249 + 217580 * t4251 - 76
            t4256 = 121440 * t4225 - 485760 * t4227 + 763104 * t4229 + 2208 * t4237 - 41088 * t4242 + 231456 * t4244 - 591360 * t4246
            t4255 = 1442100 * t4225 - 4999280 * t4227 + 6696740 * t4229 + 7020 * t4237 - 183120 * t4242 + 1359420 * t4244 - 4322880 * t4246
            t4254 = -1562275 * t4224 - 34365 * t4236 + 461655 * t4243 - 2414745 * t4245 + 6209865 * t4247 - 8404935 * t4249 + 5744365 * t4251 + 435
            t4241 = 4 * phi1
            t4240 = 8 * phi1
            t4239 = -3 * phi2
            t4238 = 3 * phi2
            tfunc[..., c] = (-0.9e1 / 0.131072e6*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * np.sqrt(0.19e2) * ((t4258 + t4259) * np.exp((-3*1j) * (t4241 + phi2)) + (-t4254 + t4255) * np.exp((-1*1j) * (t4241 + t4238)) + (t4256 - t4257) * np.exp((-1*1j) * (t4240 + t4238)) + (t4254 + t4255) * np.exp((1j) * (t4241 + t4239)) + (t4256 + t4257) * np.exp((1j) * (t4240 + t4239)) + (-t4258 + t4259) * np.exp((3*1j) * (t4241 - phi2))) * ((1 + t4237) ** (-0.1e1 / 0.2e1)) * ((1 - t4237) ** (-0.1e1 / 0.2e1))

        if Bindx == 141:
            t4278 = np.cos(phi)
            t4277 = t4278 ** 2
            t4283 = t4277 ** 2
            t4282 = t4278 * t4277
            t4285 = t4282 ** 2
            t4287 = t4283 ** 2
            t4284 = t4278 * t4283
            t4289 = t4284 ** 2
            t4291 = t4285 ** 2
            t4298 = -46 + 782 * t4277 - 3220 * t4283 + 5980 * t4285 - 5750 * t4287 + 2806 * t4289 - 552 * t4291
            t4266 = t4278 * t4291
            t4268 = t4278 * t4289
            t4270 = t4278 * t4287
            t4272 = t4278 * t4285
            t4297 = -299 * t4266 + 1288 * t4268 - 1955 * t4270 + 920 * t4272 + 207 * t4278 - 736 * t4282 + 575 * t4284
            t4296 = 16 - 912 * t4277 + 8160 * t4283 - 26528 * t4285 + 39504 * t4287 - 27600 * t4289 + 7360 * t4291
            t4295 = -5980 * t4266 + 22080 * t4268 - 31260 * t4270 + 21152 * t4272 - 52 * t4278 + 1056 * t4282 - 6996 * t4284
            t4294 = -2430 * t4277 + 30900 * t4283 - 140220 * t4285 + 282150 * t4287 - 257830 * t4289 + 87400 * t4291 + 30
            t4293 = -142025 * t4266 + 471960 * t4268 - 606385 * t4270 + 376200 * t4272 - 555 * t4278 + 14880 * t4282 - 114075 * t4284
            t4281 = 2 * phi1
            t4280 = 4 * phi1
            t4279 = 6 * phi1
            tfunc[..., c] = -(0.9e1 / 0.32768e5) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.19e2) * np.sqrt(0.17e2) * ((-t4293 + t4294) * np.exp((-2*1j) * (t4281 + phi2)) + (-t4295 + t4296) * np.exp((-2*1j) * (t4280 + phi2)) + (t4297 + t4298) * np.exp((-2*1j) * (t4279 + phi2)) + (t4293 + t4294) * np.exp((2*1j) * (t4281 - phi2)) + (t4295 + t4296) * np.exp((2*1j) * (t4280 - phi2)) + (-t4297 + t4298) * np.exp((2*1j) * (t4279 - phi2)))

        if Bindx == 142:
            t4318 = np.cos(phi)
            t4317 = t4318 ** 2
            t4322 = t4318 * t4317
            t4325 = t4322 ** 2
            t4331 = t4325 ** 2
            t4306 = t4318 * t4331
            t4323 = t4317 ** 2
            t4324 = t4318 * t4323
            t4329 = t4324 ** 2
            t4308 = t4318 * t4329
            t4327 = t4323 ** 2
            t4310 = t4318 * t4327
            t4326 = t4318 * t4325
            t4339 = -276 * t4306 + 1656 * t4308 - 4140 * t4310 - 276 * t4318 + 1656 * t4322 - 4140 * t4324 + 5520 * t4326
            t4338 = 3680 * t4306 - 16192 * t4308 + 28064 * t4310 + 96 * t4318 - 1856 * t4322 + 10144 * t4324 - 23936 * t4326
            t4305 = t4326 ** 2
            t4337 = 23 - 299 * t4305 - 437 * t4317 + 2139 * t4323 - 4945 * t4325 + 6325 * t4327 - 4623 * t4329 + 1817 * t4331
            t4336 = 12 - 5980 * t4305 - 708 * t4317 + 7036 * t4323 - 27284 * t4325 + 52516 * t4327 - 53836 * t4329 + 28244 * t4331
            t4335 = 43700 * t4306 - 150328 * t4308 + 198284 * t4310 + 180 * t4318 - 4920 * t4322 + 38028 * t4324 - 124944 * t4326
            t4334 = -142025 * t4305 - 3735 * t4317 + 51225 * t4323 - 266187 * t4325 + 664791 * t4327 - 859541 * t4329 + 555427 * t4331 + 45
            t4321 = 4 * phi1
            t4320 = 8 * phi1
            t4319 = 12 * phi1
            tfunc[..., c] = (-0.45e2 / 0.65536e5*1j) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * ((-t4334 + t4335) * np.exp((-1*1j) * (t4321 + phi2)) + (-t4336 + t4338) * np.exp((-1*1j) * (t4320 + phi2)) + (t4334 + t4335) * np.exp((1j) * (t4321 - phi2)) + (t4336 + t4338) * np.exp((1j) * (t4320 - phi2)) + (t4337 + t4339) * np.exp((-1*1j) * (t4319 + phi2)) + (-t4337 + t4339) * np.exp((1j) * (t4319 - phi2))) * ((1 + t4318) ** (-0.1e1 / 0.2e1)) * ((1 - t4318) ** (-0.1e1 / 0.2e1))

        if Bindx == 143:
            t4349 = np.cos(phi)
            t4348 = t4349 ** 2
            t4350 = t4348 ** 2
            t4352 = t4350 ** 2
            t4351 = t4348 * t4350
            t4344 = t4348 * t4352
            t4343 = t4351 ** 2
            tfunc[..., c] = (-0.45e2 / 0.32768e5*1j) * t4349 * np.sqrt(0.3e1) * np.sqrt(0.19e2) * np.sqrt(0.2e1) * np.sqrt(0.11e2) * np.sqrt(0.1547e4) * ((-10925 * t4343 + 37582 * t4344 - 49571 * t4352 + 31236 * t4351 - 9507 * t4350 + 1230 * t4348 - 45) * np.sin((4 * phi1)) + (-460 * t4343 + 2024 * t4344 - 3508 * t4352 + 2992 * t4351 - 1268 * t4350 + 232 * t4348 - 12) * np.sin((8 * phi1)) + (23 * t4343 - 138 * t4344 + 345 * t4352 - 460 * t4351 + 345 * t4350 - 138 * t4348 + 23) * np.sin((12 * phi1)))

        if Bindx == 144:
            t4374 = np.cos(phi)
            t4373 = t4374 ** 2
            t4378 = t4374 * t4373
            t4381 = t4378 ** 2
            t4387 = t4381 ** 2
            t4362 = t4374 * t4387
            t4379 = t4373 ** 2
            t4380 = t4374 * t4379
            t4385 = t4380 ** 2
            t4364 = t4374 * t4385
            t4383 = t4379 ** 2
            t4366 = t4374 * t4383
            t4382 = t4374 * t4381
            t4395 = -276 * t4362 + 1656 * t4364 - 4140 * t4366 - 276 * t4374 + 1656 * t4378 - 4140 * t4380 + 5520 * t4382
            t4394 = 3680 * t4362 - 16192 * t4364 + 28064 * t4366 + 96 * t4374 - 1856 * t4378 + 10144 * t4380 - 23936 * t4382
            t4361 = t4382 ** 2
            t4393 = 23 - 299 * t4361 - 437 * t4373 + 2139 * t4379 - 4945 * t4381 + 6325 * t4383 - 4623 * t4385 + 1817 * t4387
            t4392 = 12 - 5980 * t4361 - 708 * t4373 + 7036 * t4379 - 27284 * t4381 + 52516 * t4383 - 53836 * t4385 + 28244 * t4387
            t4391 = 43700 * t4362 - 150328 * t4364 + 198284 * t4366 + 180 * t4374 - 4920 * t4378 + 38028 * t4380 - 124944 * t4382
            t4390 = -142025 * t4361 - 3735 * t4373 + 51225 * t4379 - 266187 * t4381 + 664791 * t4383 - 859541 * t4385 + 555427 * t4387 + 45
            t4377 = 4 * phi1
            t4376 = 8 * phi1
            t4375 = 12 * phi1
            tfunc[..., c] = (0.45e2 / 0.65536e5*1j) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * ((1 + t4374) ** (-0.1e1 / 0.2e1)) * ((1 - t4374) ** (-0.1e1 / 0.2e1)) * ((t4390 + t4391) * np.exp((-1*1j) * (t4377 - phi2)) + (t4392 + t4394) * np.exp((-1*1j) * (t4376 - phi2)) + (-t4390 + t4391) * np.exp((1j) * (t4377 + phi2)) + (-t4392 + t4394) * np.exp((1j) * (t4376 + phi2)) + (-t4393 + t4395) * np.exp((-1*1j) * (t4375 - phi2)) + (t4393 + t4395) * np.exp((1j) * (t4375 + phi2)))

        if Bindx == 145:
            t4414 = np.cos(phi)
            t4413 = t4414 ** 2
            t4419 = t4413 ** 2
            t4418 = t4414 * t4413
            t4421 = t4418 ** 2
            t4423 = t4419 ** 2
            t4420 = t4414 * t4419
            t4425 = t4420 ** 2
            t4427 = t4421 ** 2
            t4434 = -46 + 782 * t4413 - 3220 * t4419 + 5980 * t4421 - 5750 * t4423 + 2806 * t4425 - 552 * t4427
            t4402 = t4414 * t4427
            t4404 = t4414 * t4425
            t4406 = t4414 * t4423
            t4408 = t4414 * t4421
            t4433 = -299 * t4402 + 1288 * t4404 - 1955 * t4406 + 920 * t4408 + 207 * t4414 - 736 * t4418 + 575 * t4420
            t4432 = 16 - 912 * t4413 + 8160 * t4419 - 26528 * t4421 + 39504 * t4423 - 27600 * t4425 + 7360 * t4427
            t4431 = -5980 * t4402 + 22080 * t4404 - 31260 * t4406 + 21152 * t4408 - 52 * t4414 + 1056 * t4418 - 6996 * t4420
            t4430 = -2430 * t4413 + 30900 * t4419 - 140220 * t4421 + 282150 * t4423 - 257830 * t4425 + 87400 * t4427 + 30
            t4429 = -142025 * t4402 + 471960 * t4404 - 606385 * t4406 + 376200 * t4408 - 555 * t4414 + 14880 * t4418 - 114075 * t4420
            t4417 = 2 * phi1
            t4416 = 4 * phi1
            t4415 = 6 * phi1
            tfunc[..., c] = (0.9e1 / 0.32768e5) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * np.sqrt(0.11e2) * np.sqrt(0.17e2) * ((t4429 + t4430) * np.exp((-2*1j) * (t4417 - phi2)) + (t4431 + t4432) * np.exp((-2*1j) * (t4416 - phi2)) + (-t4433 + t4434) * np.exp((-2*1j) * (t4415 - phi2)) + (-t4429 + t4430) * np.exp((2*1j) * (t4417 + phi2)) + (-t4431 + t4432) * np.exp((2*1j) * (t4416 + phi2)) + (t4433 + t4434) * np.exp((2*1j) * (t4415 + phi2)))

        if Bindx == 146:
            t4454 = np.cos(phi)
            t4453 = t4454 ** 2
            t4459 = t4454 * t4453
            t4462 = t4459 ** 2
            t4468 = t4462 ** 2
            t4442 = t4454 * t4468
            t4460 = t4453 ** 2
            t4461 = t4454 * t4460
            t4466 = t4461 ** 2
            t4444 = t4454 * t4466
            t4464 = t4460 ** 2
            t4446 = t4454 * t4464
            t4463 = t4454 * t4462
            t4476 = 9108 * t4442 - 44528 * t4444 + 86020 * t4446 - 1012 * t4454 - 4048 * t4459 + 35420 * t4461 - 80960 * t4463
            t4441 = t4463 ** 2
            t4475 = -759 - 3289 * t4441 + 11385 * t4453 - 42251 * t4460 + 67045 * t4462 - 46805 * t4464 + 5819 * t4466 + 8855 * t4468
            t4474 = -65780 * t4441 + 4180 * t4453 - 29244 * t4460 + 43172 * t4462 + 71068 * t4464 - 240900 * t4466 + 217580 * t4468 - 76
            t4473 = -121440 * t4442 + 485760 * t4444 - 763104 * t4446 - 2208 * t4454 + 41088 * t4459 - 231456 * t4461 + 591360 * t4463
            t4472 = -1442100 * t4442 + 4999280 * t4444 - 6696740 * t4446 - 7020 * t4454 + 183120 * t4459 - 1359420 * t4461 + 4322880 * t4463
            t4471 = -1562275 * t4441 - 34365 * t4453 + 461655 * t4460 - 2414745 * t4462 + 6209865 * t4464 - 8404935 * t4466 + 5744365 * t4468 + 435
            t4458 = 4 * phi1
            t4457 = 8 * phi1
            t4456 = -3 * phi2
            t4455 = 3 * phi2
            tfunc[..., c] = (-0.9e1 / 0.131072e6*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.17e2) * np.sqrt(0.19e2) * ((t4475 + t4476) * np.exp((-3*1j) * (t4458 - phi2)) + (-t4471 + t4472) * np.exp((-1*1j) * (t4458 + t4456)) + (t4473 - t4474) * np.exp((-1*1j) * (t4457 + t4456)) + (t4471 + t4472) * np.exp((1j) * (t4458 + t4455)) + (t4473 + t4474) * np.exp((1j) * (t4457 + t4455)) + (-t4475 + t4476) * np.exp((3*1j) * (t4458 + phi2))) * ((1 + t4454) ** (-0.1e1 / 0.2e1)) * ((1 - t4454) ** (-0.1e1 / 0.2e1))

        if Bindx == 147:
            t4495 = np.cos(phi)
            t4494 = t4495 ** 2
            t4499 = t4494 ** 2
            t4498 = t4495 * t4494
            t4501 = t4498 ** 2
            t4503 = t4499 ** 2
            t4500 = t4495 * t4499
            t4505 = t4500 ** 2
            t4507 = t4501 ** 2
            t4514 = 1012 - 11132 * t4494 + 22264 * t4499 + 2024 * t4501 - 43516 * t4503 + 41492 * t4505 - 12144 * t4507
            t4483 = t4495 * t4507
            t4485 = t4495 * t4505
            t4487 = t4495 * t4503
            t4489 = t4495 * t4501
            t4513 = -3289 * t4483 - 2530 * t4485 + 43769 * t4487 - 83996 * t4489 + 759 * t4495 - 18722 * t4498 + 64009 * t4500
            t4512 = 65780 * t4483 - 103224 * t4485 - 86196 * t4487 + 254960 * t4489 - 2572 * t4495 + 41160 * t4498 - 169908 * t4500
            t4511 = -8160 * t4494 + 80064 * t4499 - 322496 * t4501 + 598560 * t4503 - 510048 * t4505 + 161920 * t4507 + 160
            t4510 = -65700 * t4494 + 780360 * t4499 - 3347496 * t4501 + 6460380 * t4503 - 5749172 * t4505 + 1922800 * t4507 + 876
            t4509 = -1562275 * t4483 + 4643562 * t4485 - 5292925 * t4487 + 2917260 * t4489 - 3891 * t4495 + 100650 * t4498 - 804429 * t4500
            t4497 = 2 * phi1
            t4496 = 3 * phi1
            tfunc[..., c] = (0.45e2 / 0.131072e6) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * np.sqrt(0.2e1) * ((t4509 + t4510) * np.exp((-4*1j) * (phi1 - phi2)) + (t4511 - t4512) * np.exp((-4*1j) * (t4497 - phi2)) + (-t4513 + t4514) * np.exp((-4*1j) * (t4496 - phi2)) + (-t4509 + t4510) * np.exp((4*1j) * (phi1 + phi2)) + (t4511 + t4512) * np.exp((4*1j) * (t4497 + phi2)) + (t4513 + t4514) * np.exp((4*1j) * (t4496 + phi2)))

        if Bindx == 148:
            t4534 = np.cos(phi)
            t4533 = t4534 ** 2
            t4540 = t4534 * t4533
            t4543 = t4540 ** 2
            t4549 = t4543 ** 2
            t4522 = t4534 * t4549
            t4541 = t4533 ** 2
            t4542 = t4534 * t4541
            t4547 = t4542 ** 2
            t4524 = t4534 * t4547
            t4545 = t4541 ** 2
            t4526 = t4534 * t4545
            t4544 = t4534 * t4543
            t4557 = -15180 * t4522 + 40480 * t4524 - 7084 * t4526 + 3036 * t4534 - 32384 * t4540 + 83996 * t4542 - 72864 * t4544
            t4521 = t4544 ** 2
            t4556 = -3289 * t4521 - 8855 * t4533 - 3795 * t4541 + 75141 * t4543 - 129789 * t4545 + 82731 * t4547 - 13409 * t4549 + 1265
            t4555 = 202400 * t4522 - 647680 * t4524 + 756128 * t4526 - 544 * t4534 + 2816 * t4540 + 63968 * t4542 - 377088 * t4544
            t4554 = -65780 * t4521 + 20116 * t4533 - 160988 * t4541 + 503844 * t4543 - 703236 * t4545 + 375100 * t4547 + 31372 * t4549 - 428
            t4553 = -1562275 * t4521 - 3053 * t4533 + 88895 * t4541 - 870585 * t4543 + 3394065 * t4545 - 6060791 * t4547 + 5013701 * t4549 + 43
            t4552 = 2403500 * t4522 - 8460320 * t4524 + 11611660 * t4526 + 15940 * t4534 - 376960 * t4540 + 2589188 * t4542 - 7783008 * t4544
            t4539 = 4 * phi1
            t4538 = 8 * phi1
            t4537 = -5 * phi2
            t4536 = 5 * phi2
            t4535 = 12 * phi1
            tfunc[..., c] = (0.45e2 / 0.131072e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * ((1 + t4534) ** (-0.1e1 / 0.2e1)) * ((1 - t4534) ** (-0.1e1 / 0.2e1)) * ((t4552 + t4553) * np.exp((-1*1j) * (t4539 + t4537)) + (t4554 + t4555) * np.exp((-1*1j) * (t4538 + t4537)) + (t4552 - t4553) * np.exp((1j) * (t4539 + t4536)) + (-t4554 + t4555) * np.exp((1j) * (t4538 + t4536)) + (-t4556 + t4557) * np.exp((-1*1j) * (t4535 + t4537)) + (t4556 + t4557) * np.exp((1j) * (t4535 + t4536)))

        if Bindx == 149:
            t4576 = np.cos(phi)
            t4575 = t4576 ** 2
            t4581 = t4576 * t4575
            t4584 = t4581 ** 2
            t4590 = t4584 ** 2
            t4564 = t4576 * t4590
            t4582 = t4575 ** 2
            t4583 = t4576 * t4582
            t4588 = t4583 ** 2
            t4566 = t4576 * t4588
            t4586 = t4582 ** 2
            t4568 = t4576 * t4586
            t4570 = t4576 * t4584
            t4597 = -3289 * t4564 - 30360 * t4566 + 91839 * t4568 - 54648 * t4570 - 5819 * t4576 + 36432 * t4581 - 34155 * t4583
            t4596 = 1518 * t4575 + 47564 * t4582 - 118404 * t4584 + 77418 * t4586 + 11638 * t4588 - 18216 * t4590 - 1518
            t4595 = 20336 * t4575 - 99616 * t4582 + 82272 * t4584 + 276816 * t4586 - 522192 * t4588 + 242880 * t4590 - 496
            t4594 = -65780 * t4564 - 129536 * t4566 + 658636 * t4568 - 742176 * t4570 + 4164 * t4576 - 63456 * t4581 + 338148 * t4583
            t4593 = -1562275 * t4564 + 3730232 * t4566 - 2590555 * t4568 + 28120 * t4570 + 7239 * t4576 - 138320 * t4581 + 525559 * t4583
            t4592 = -130910 * t4575 + 1390420 * t4582 - 5531356 * t4584 + 10201670 * t4586 - 8816038 * t4588 + 2884200 * t4590 + 2014
            t4580 = 2 * phi1
            t4579 = 4 * phi1
            t4578 = -3 * phi2
            t4577 = 3 * phi2
            tfunc[..., c] = (0.45e2 / 0.65536e5) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * ((t4596 - t4597) * np.exp((-6*1j) * (t4580 - phi2)) + (t4592 + t4593) * np.exp((-2*1j) * (t4580 + t4578)) + (t4594 + t4595) * np.exp((-2*1j) * (t4579 + t4578)) + (t4592 - t4593) * np.exp((2*1j) * (t4580 + t4577)) + (-t4594 + t4595) * np.exp((2*1j) * (t4579 + t4577)) + (t4596 + t4597) * np.exp((6*1j) * (t4580 + phi2)))

        if Bindx == 150:
            t4617 = np.cos(phi)
            t4616 = t4617 ** 2
            t4623 = t4617 * t4616
            t4626 = t4623 ** 2
            t4632 = t4626 ** 2
            t4605 = t4617 * t4632
            t4624 = t4616 ** 2
            t4625 = t4617 * t4624
            t4630 = t4625 ** 2
            t4607 = t4617 * t4630
            t4628 = t4624 ** 2
            t4609 = t4617 * t4628
            t4627 = t4617 * t4626
            t4640 = 21252 * t4605 + 14168 * t4607 - 162932 * t4609 + 9108 * t4617 - 34408 * t4623 - 29348 * t4625 + 182160 * t4627
            t4604 = t4627 ** 2
            t4639 = -3289 * t4604 - 8855 * t4616 + 90321 * t4624 - 143451 * t4626 + 6831 * t4628 + 107019 * t4630 - 46805 * t4632 - 1771
            t4638 = -283360 * t4605 + 566720 * t4607 - 72352 * t4609 + 10144 * t4617 - 117824 * t4623 + 428512 * t4625 - 531840 * t4627
            t4637 = -65780 * t4604 + 980 * t4616 - 100492 * t4624 + 599844 * t4626 - 1269204 * t4628 + 1082620 * t4630 - 247940 * t4632 - 28
            t4636 = -3364900 * t4605 + 12113640 * t4607 - 16989420 * t4609 - 31540 * t4617 + 640680 * t4623 - 4043580 * t4625 + 11675120 * t4627
            t4635 = -1562275 * t4604 + 128915 * t4616 - 1110645 * t4624 + 3057575 * t4626 - 2494795 * t4628 - 1934295 * t4630 + 3917705 * t4632 - 2185
            t4622 = 4 * phi1
            t4621 = 8 * phi1
            t4620 = -7 * phi2
            t4619 = 7 * phi2
            t4618 = 12 * phi1
            tfunc[..., c] = (-0.9e1 / 0.131072e6*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * ((-t4635 + t4636) * np.exp((-1*1j) * (t4622 + t4620)) + (-t4637 + t4638) * np.exp((-1*1j) * (t4621 + t4620)) + (t4635 + t4636) * np.exp((1j) * (t4622 + t4619)) + (t4637 + t4638) * np.exp((1j) * (t4621 + t4619)) + (t4639 + t4640) * np.exp((-1*1j) * (t4618 + t4620)) + (-t4639 + t4640) * np.exp((1j) * (t4618 + t4619))) * ((1 + t4617) ** (-0.1e1 / 0.2e1)) * ((1 - t4617) ** (-0.1e1 / 0.2e1))

        if Bindx == 151:
            t4659 = np.cos(phi)
            t4658 = t4659 ** 2
            t4664 = t4658 ** 2
            t4663 = t4659 * t4658
            t4666 = t4663 ** 2
            t4668 = t4664 ** 2
            t4665 = t4659 * t4664
            t4670 = t4665 ** 2
            t4672 = t4666 ** 2
            t4679 = 26312 * t4658 - 101200 * t4664 - 12144 * t4666 + 188232 * t4668 - 78936 * t4670 - 24288 * t4672 + 2024
            t4647 = t4659 * t4672
            t4649 = t4659 * t4670
            t4651 = t4659 * t4668
            t4653 = t4659 * t4666
            t4678 = 3289 * t4647 + 69322 * t4649 - 31625 * t4651 - 179124 * t4653 - 12903 * t4659 + 4554 * t4663 + 146487 * t4665
            t4677 = -65780 * t4647 - 455400 * t4649 + 1156980 * t4651 - 743856 * t4653 - 13236 * t4659 + 77848 * t4663 + 39348 * t4665
            t4676 = 46656 * t4658 - 346240 * t4664 + 859776 * t4666 - 635328 * t4668 - 242880 * t4670 + 323840 * t4672 - 1728
            t4675 = -193800 * t4658 + 1901520 * t4664 - 7659280 * t4666 + 14215800 * t4668 - 12113640 * t4670 + 3845600 * t4672 + 3800
            t4674 = -1562275 * t4647 + 2451570 * t4649 + 2047155 * t4651 - 6055300 * t4653 + 61085 * t4659 - 977550 * t4663 + 4035315 * t4665
            t4662 = 3 * phi1
            t4661 = -2 * phi2
            t4660 = 2 * phi2
            tfunc[..., c] = (0.9e1 / 0.65536e5) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * ((t4676 + t4677) * np.exp((-8*1j) * (phi1 - phi2)) + (t4674 + t4675) * np.exp((-4*1j) * (phi1 + t4661)) + (t4678 + t4679) * np.exp((-4*1j) * (t4662 + t4661)) + (-t4674 + t4675) * np.exp((4*1j) * (phi1 + t4660)) + (-t4678 + t4679) * np.exp((4*1j) * (t4662 + t4660)) + (t4676 - t4677) * np.exp((8*1j) * (phi1 + phi2)))

        if Bindx == 152:
            t4699 = np.cos(phi)
            t4698 = t4699 ** 2
            t4704 = t4699 * t4698
            t4707 = t4704 ** 2
            t4713 = t4707 ** 2
            t4687 = t4699 * t4713
            t4705 = t4698 ** 2
            t4706 = t4699 * t4705
            t4711 = t4706 ** 2
            t4689 = t4699 * t4711
            t4709 = t4705 ** 2
            t4691 = t4699 * t4709
            t4708 = t4699 * t4707
            t4721 = -2484 * t4687 - 12696 * t4689 + 21252 * t4691 + 1564 * t4699 + 3496 * t4704 - 23276 * t4706 + 12144 * t4708
            t4686 = t4708 ** 2
            t4720 = 207 - 299 * t4686 + 4347 * t4698 - 8349 * t4705 - 17457 * t4707 + 32637 * t4709 - 2783 * t4711 - 8303 * t4713
            t4719 = 5980 * t4686 + 9348 * t4698 - 39708 * t4705 + 32532 * t4707 + 83388 * t4709 - 147444 * t4711 + 56396 * t4713 - 492
            t4718 = 33120 * t4687 - 13248 * t4689 - 124128 * t4691 + 480 * t4699 + 8768 * t4704 - 74336 * t4706 + 169344 * t4708
            t4717 = 393300 * t4687 - 1457832 * t4689 + 2053596 * t4691 + 2052 * t4699 - 46056 * t4704 + 403788 * t4706 - 1348848 * t4708
            t4716 = -142025 * t4686 + 59641 * t4698 - 416271 * t4705 + 1107605 * t4707 - 1258769 * t4709 + 427899 * t4711 + 223307 * t4713 - 1387
            t4703 = 4 * phi1
            t4702 = 8 * phi1
            t4701 = -9 * phi2
            t4700 = 9 * phi2
            tfunc[..., c] = (0.45e2 / 0.131072e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * ((1 + t4699) ** (-0.1e1 / 0.2e1)) * ((1 - t4699) ** (-0.1e1 / 0.2e1)) * ((-t4720 + t4721) * np.exp((-3*1j) * (t4703 - 3 * phi2)) + (t4716 + t4717) * np.exp((-1*1j) * (t4703 + t4701)) + (t4718 - t4719) * np.exp((-1*1j) * (t4702 + t4701)) + (-t4716 + t4717) * np.exp((1j) * (t4703 + t4700)) + (t4718 + t4719) * np.exp((1j) * (t4702 + t4700)) + (t4720 + t4721) * np.exp((3*1j) * (t4703 + 3 * phi2)))

        if Bindx == 153:
            t4740 = np.cos(phi)
            t4739 = t4740 ** 2
            t4747 = t4739 ** 2
            t4746 = t4740 * t4739
            t4749 = t4746 ** 2
            t4751 = t4747 ** 2
            t4748 = t4740 * t4747
            t4753 = t4748 ** 2
            t4755 = t4749 ** 2
            t4762 = 10 + 310 * t4739 + 220 * t4747 - 1716 * t4749 + 66 * t4751 + 990 * t4753 + 120 * t4755
            t4761 = -48 + 432 * t4739 + 352 * t4747 - 5664 * t4749 + 8208 * t4751 - 1680 * t4753 - 1600 * t4755
            t4728 = t4740 * t4755
            t4730 = t4740 * t4753
            t4732 = t4740 * t4751
            t4734 = t4740 * t4749
            t4760 = -13 * t4728 - 472 * t4730 - 1045 * t4732 + 1320 * t4734 - 87 * t4740 - 528 * t4746 + 825 * t4748
            t4759 = 38 - 1254 * t4739 - 1596 * t4747 + 30932 * t4749 - 71250 * t4751 + 62130 * t4753 - 19000 * t4755
            t4758 = -260 * t4728 - 3456 * t4730 + 5052 * t4732 + 1632 * t4734 - 108 * t4740 + 1568 * t4746 - 4428 * t4748
            t4757 = -6175 * t4728 + 3192 * t4730 + 37449 * t4732 - 70984 * t4734 + 1235 * t4740 - 13680 * t4746 + 48963 * t4748
            t4745 = 2 * phi1
            t4744 = 4 * phi1
            t4743 = 6 * phi1
            t4742 = -5 * phi2
            t4741 = 5 * phi2
            tfunc[..., c] = -(0.45e2 / 0.65536e5) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * ((-t4757 + t4759) * np.exp((-2*1j) * (t4745 + t4742)) + (-t4758 + t4761) * np.exp((-2*1j) * (t4744 + t4742)) + (t4760 + t4762) * np.exp((-2*1j) * (t4743 + t4742)) + (t4757 + t4759) * np.exp((2*1j) * (t4745 + t4741)) + (t4758 + t4761) * np.exp((2*1j) * (t4744 + t4741)) + (-t4760 + t4762) * np.exp((2*1j) * (t4743 + t4741)))

        if Bindx == 154:
            t4782 = np.cos(phi)
            t4781 = t4782 ** 2
            t4788 = t4782 * t4781
            t4791 = t4788 ** 2
            t4797 = t4791 ** 2
            t4770 = t4782 * t4797
            t4789 = t4781 ** 2
            t4790 = t4782 * t4789
            t4795 = t4790 ** 2
            t4772 = t4782 * t4795
            t4793 = t4789 ** 2
            t4774 = t4782 * t4793
            t4792 = t4782 * t4791
            t4805 = 132 * t4770 + 1408 * t4772 + 836 * t4774 + 108 * t4782 + 992 * t4788 - 308 * t4790 - 3168 * t4792
            t4804 = -1760 * t4770 - 2816 * t4772 + 13600 * t4774 - 416 * t4782 + 2560 * t4788 - 1184 * t4790 - 9984 * t4792
            t4769 = t4792 ** 2
            t4803 = -11 - 13 * t4769 - 451 * t4781 - 1023 * t4789 + 2409 * t4791 + 1551 * t4793 - 1881 * t4795 - 581 * t4797
            t4802 = -92 - 260 * t4769 - 92 * t4781 + 4660 * t4789 - 11532 * t4791 + 5100 * t4793 + 6508 * t4795 - 4292 * t4797
            t4801 = -20900 * t4770 + 80256 * t4772 - 109668 * t4774 + 2356 * t4782 - 12768 * t4788 + 6612 * t4790 + 54112 * t4792
            t4800 = 6175 * t4769 - 8303 * t4781 + 51813 * t4789 - 125267 * t4791 + 136363 * t4793 - 58653 * t4795 - 2489 * t4797 + 361
            t4787 = 4 * phi1
            t4786 = 8 * phi1
            t4785 = 12 * phi1
            t4784 = -11 * phi2
            t4783 = 11 * phi2
            tfunc[..., c] = (-0.45e2 / 0.131072e6*1j) * np.sqrt(0.11e2) * np.sqrt(0.23e2) * np.sqrt(0.3e1) * ((t4800 + t4801) * np.exp((-1*1j) * (t4787 + t4784)) + (-t4802 + t4804) * np.exp((-1*1j) * (t4786 + t4784)) + (-t4800 + t4801) * np.exp((1j) * (t4787 + t4783)) + (t4802 + t4804) * np.exp((1j) * (t4786 + t4783)) + (t4803 + t4805) * np.exp((-1*1j) * (t4785 + t4784)) + (-t4803 + t4805) * np.exp((1j) * (t4785 + t4783))) * ((1 + t4782) ** (-0.1e1 / 0.2e1)) * ((1 - t4782) ** (-0.1e1 / 0.2e1))

        if Bindx == 155:
            t4824 = np.cos(phi)
            t4823 = t4824 ** 2
            t4829 = t4823 ** 2
            t4828 = t4824 * t4823
            t4831 = t4828 ** 2
            t4833 = t4829 ** 2
            t4830 = t4824 * t4829
            t4835 = t4830 ** 2
            t4837 = t4831 ** 2
            t4844 = 12 + 636 * t4823 + 3080 * t4829 + 792 * t4831 - 4356 * t4833 - 2068 * t4835 - 144 * t4837
            t4843 = -160 - 2080 * t4823 + 8000 * t4829 + 960 * t4831 - 14880 * t4833 + 6240 * t4835 + 1920 * t4837
            t4812 = t4824 * t4837
            t4814 = t4824 * t4835
            t4816 = t4824 * t4833
            t4818 = t4824 * t4831
            t4842 = -13 * t4812 - 714 * t4814 - 3795 * t4816 - 2508 * t4818 + 131 * t4824 + 1782 * t4828 + 3069 * t4830
            t4841 = -260 * t4812 - 5480 * t4814 + 2500 * t4816 + 14160 * t4818 + 1020 * t4824 - 360 * t4828 - 11580 * t4830
            t4840 = -1900 + 20900 * t4823 - 41800 * t4829 - 3800 * t4831 + 81700 * t4833 - 77900 * t4835 + 22800 * t4837
            t4839 = -6175 * t4812 - 4750 * t4814 + 82175 * t4816 - 157700 * t4818 + 1425 * t4824 - 35150 * t4828 + 120175 * t4830
            t4827 = 2 * phi1
            t4826 = -3 * phi2
            t4825 = 3 * phi2
            tfunc[..., c] = (0.9e1 / 0.131072e6) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.2e1) * ((t4839 + t4840) * np.exp((-4*1j) * (phi1 + t4826)) + (t4841 + t4843) * np.exp((-4*1j) * (t4827 + t4826)) + (-t4839 + t4840) * np.exp((4*1j) * (phi1 + t4825)) + (-t4841 + t4843) * np.exp((4*1j) * (t4827 + t4825)) + (-t4842 + t4844) * np.exp((-12*1j) * (phi1 - phi2)) + (t4842 + t4844) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 156:
            t4863 = np.cos(phi)
            t4862 = t4863 ** 2
            t4869 = t4863 * t4862
            t4872 = t4869 ** 2
            t4878 = t4872 ** 2
            t4851 = t4863 * t4878
            t4882 = -1 - t4851
            t4881 = -20 - 20 * t4851
            t4880 = -475 - 475 * t4851
            t4870 = t4862 ** 2
            t4871 = t4863 * t4870
            t4876 = t4871 ** 2
            t4874 = t4870 ** 2
            t4868 = 4 * phi1
            t4867 = 8 * phi1
            t4866 = 12 * phi1
            t4865 = -13 * phi2
            t4864 = 13 * phi2
            t4857 = t4863 * t4872
            t4855 = t4863 * t4874
            t4853 = t4863 * t4876
            tfunc[..., c] = (-0.9e1 / 0.131072e6*1j) * np.sqrt((1 - t4863)) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * ((1 + t4863) ** (-0.1e1 / 0.2e1)) * ((-11 * t4878 + 54 * t4853 - 154 * t4876 + 275 * t4855 - 297 * t4874 + 132 * t4857 + 132 * t4872 - 297 * t4871 + 275 * t4870 - 154 * t4869 + 54 * t4862 - 11 * t4863 - t4882) * np.exp((-1*1j) * (t4866 + t4865)) + (-13 * t4878 - 78 * t4853 - 286 * t4876 - 715 * t4855 - 1287 * t4874 - 1716 * t4857 - 1716 * t4872 - 1287 * t4871 - 715 * t4870 - 286 * t4869 - 78 * t4862 - 13 * t4863 + t4882) * np.exp((1j) * (t4866 + t4864)) + (1425 * t4878 + 950 * t4853 - 6650 * t4876 + 2375 * t4855 + 11875 * t4874 - 9500 * t4857 - 9500 * t4872 + 11875 * t4871 + 2375 * t4870 - 6650 * t4869 + 950 * t4862 + 1425 * t4863 + t4880) * np.exp((-1*1j) * (t4868 + t4865)) + (140 * t4878 - 360 * t4853 + 280 * t4876 + 500 * t4855 - 1260 * t4874 + 720 * t4857 + 720 * t4872 - 1260 * t4871 + 500 * t4870 + 280 * t4869 - 360 * t4862 + 140 * t4863 + t4881) * np.exp((-1*1j) * (t4867 + t4865)) + (2375 * t4878 + 2850 * t4853 - 4750 * t4876 - 13775 * t4855 - 4275 * t4874 + 17100 * t4857 + 17100 * t4872 - 4275 * t4871 - 13775 * t4870 - 4750 * t4869 + 2850 * t4862 + 2375 * t4863 - t4880) * np.exp((1j) * (t4868 + t4864)) + (180 * t4878 + 680 * t4853 + 1320 * t4876 + 1100 * t4855 - 660 * t4874 - 2640 * t4857 - 2640 * t4872 - 660 * t4871 + 1100 * t4870 + 1320 * t4869 + 680 * t4862 + 180 * t4863 - t4881) * np.exp((1j) * (t4867 + t4864)))

        if Bindx == 157:
            t4902 = np.cos(phi)
            t4901 = t4902 ** 2
            t4909 = t4901 ** 2
            t4910 = t4902 * t4909
            t4914 = t4910 ** 2
            t4893 = t4902 * t4914
            t4908 = t4902 * t4901
            t4927 = -4 * t4893 + 4 * t4908
            t4911 = t4908 ** 2
            t4916 = t4911 ** 2
            t4917 = t4902 * t4916
            t4926 = t4902 - t4917
            t4890 = t4902 * t4917
            t4925 = -1 + t4890
            t4912 = t4909 ** 2
            t4895 = t4902 * t4912
            t4924 = -20 * t4895 + 20 * t4910 + 4 * t4926 - 4 * t4927
            t4923 = -208 * t4893 - 572 * t4895 + 12 * t4902 + 208 * t4908 + 572 * t4910 - 12 * t4917
            t4922 = 2288 * t4895 - 2288 * t4910 + 208 * t4926 + 208 * t4927
            t4921 = t4916 - t4901 + 19 * t4909 - 45 * t4911 + 45 * t4912 - 19 * t4914 + t4925
            t4920 = -65 * t4901 - 429 * t4909 - 429 * t4911 + 429 * t4912 + 429 * t4914 + 65 * t4916 + t4925
            t4919 = -26 + 26 * t4890 - 650 * t4901 + 286 * t4909 + 2574 * t4911 - 2574 * t4912 - 286 * t4914 + 650 * t4916
            t4907 = 2 * phi1
            t4906 = 4 * phi1
            t4905 = 6 * phi1
            t4904 = -7 * phi2
            t4903 = 7 * phi2
            tfunc[..., c] = (0.87e2 / 0.1048576e7) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * np.sqrt(0.19e2) * ((-340 * t4890 + 2380 * t4916 - 7140 * t4914 + 11900 * t4912 - 11900 * t4911 + 7140 * t4909 - 2380 * t4901 + 340) * np.exp((-14*1j) * phi2) + (t4920 - t4923) * np.exp((-2*1j) * (t4905 + t4903)) + (t4920 + t4923) * np.exp((2*1j) * (t4905 + t4904)) + (t4919 - t4922) * np.exp((-2*1j) * (t4906 + t4903)) + (t4919 + t4922) * np.exp((2*1j) * (t4906 + t4904)) + 143 * (t4921 - t4924) * np.exp((-2*1j) * (t4907 + t4903)) + 143 * (t4921 + t4924) * np.exp((2*1j) * (t4907 + t4904)))

        if Bindx == 158:
            t4948 = np.cos(phi)
            t4947 = t4948 ** 2
            t4954 = t4948 * t4947
            t4957 = t4954 ** 2
            t4958 = t4948 * t4957
            t4935 = t4958 ** 2
            t4968 = 7 * t4935 - 1287 * t4957 - 1716 * t4958
            t4967 = 182 * t4935 + 7722 * t4957 + 10296 * t4958
            t4966 = 1001 * t4935 - 19305 * t4957 - 25740 * t4958
            t4963 = t4957 ** 2
            t4955 = t4947 ** 2
            t4956 = t4948 * t4955
            t4961 = t4956 ** 2
            t4959 = t4955 ** 2
            t4953 = 4 * phi1
            t4952 = 8 * phi1
            t4951 = 12 * phi1
            t4950 = -13 * phi2
            t4949 = 13 * phi2
            t4940 = t4948 * t4959
            t4938 = t4948 * t4961
            t4936 = t4948 * t4963
            tfunc[..., c] = (0.87e2 / 0.524288e6*1j) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt((1 + t4948)) * (2380 * (-t4935 + t4936 + 6 * t4963 - 6 * t4938 - 15 * t4961 + 15 * t4940 + 20 * t4959 - 20 * t4958 - 15 * t4957 + 15 * t4956 + 6 * t4955 - 6 * t4954 - t4947 + t4948) * np.exp((-13*1j) * phi2) + (1170 * t4936 + 2548 * t4963 + 676 * t4938 - 6006 * t4961 - 8866 * t4940 - 2002 * t4956 - 5148 * t4955 - 1820 * t4954 + 598 * t4947 + 546 * t4948 + 104 + t4967) * np.exp((-1*1j) * (t4952 + t4949)) + (2717 * t4936 - 2860 * t4963 - 13442 * t4938 - 1001 * t4961 + 26455 * t4940 + 12870 * t4959 + 12155 * t4956 + 12584 * t4955 - 2002 * t4954 - 3575 * t4947 - 143 * t4948 + 286 + t4966) * np.exp((-1*1j) * (t4953 + t4949)) + (-4719 * t4936 + 4576 * t4963 + 11726 * t4938 - 26169 * t4961 + 715 * t4940 + 38610 * t4959 + 26455 * t4956 - 1716 * t4955 - 8866 * t4954 + 3289 * t4947 + 429 * t4948 - 286 + t4966) * np.exp((1j) * (t4953 + t4950)) + (-1534 * t4936 + 5252 * t4963 - 8476 * t4938 + 3146 * t4961 + 11726 * t4940 - 20592 * t4959 - 13442 * t4956 + 6292 * t4955 + 676 * t4954 - 1898 * t4947 + 754 * t4948 - 104 + t4967) * np.exp((1j) * (t4952 + t4950)) + (71 * t4936 + 312 * t4963 + 754 * t4938 + 1001 * t4961 + 429 * t4940 - 858 * t4959 - 143 * t4956 + 572 * t4955 + 546 * t4954 + 247 * t4947 + 59 * t4948 + 6 + t4968) * np.exp((-1*1j) * (t4951 + t4949)) + (-85 * t4936 + 468 * t4963 - 1534 * t4938 + 3289 * t4961 - 4719 * t4940 + 4290 * t4959 + 2717 * t4956 - 2288 * t4955 + 1170 * t4954 - 377 * t4947 + 71 * t4948 - 6 + t4968) * np.exp((1j) * (t4951 + t4950))) * ((1 - t4948) ** (-0.1e1 / 0.2e1))

        if Bindx == 159:
            t4989 = np.cos(phi)
            t4988 = t4989 ** 2
            t4993 = t4989 * t4988
            t4996 = t4993 ** 2
            t5002 = t4996 ** 2
            t4977 = t4989 * t5002
            t4994 = t4988 ** 2
            t4995 = t4989 * t4994
            t5000 = t4995 ** 2
            t4979 = t4989 * t5000
            t4998 = t4994 ** 2
            t4981 = t4989 * t4998
            t4997 = t4989 * t4996
            t5010 = -1944 * t4977 - 21840 * t4979 - 19448 * t4981 - 1320 * t4989 - 11024 * t4993 + 10296 * t4995 + 41184 * t4997
            t4976 = t4997 ** 2
            t5009 = 137 + 189 * t4976 + 5343 * t4988 + 9009 * t4994 - 36465 * t4996 - 14157 * t4998 + 31317 * t5000 + 8723 * t5002
            t5008 = 33696 * t4977 + 62400 * t4979 - 260832 * t4981 + 6240 * t4989 - 47424 * t4993 + 41184 * t4995 + 164736 * t4997
            t5007 = 92664 * t4977 - 350064 * t4979 + 463320 * t4981 - 10296 * t4989 + 61776 * t4993 - 51480 * t4995 - 205920 * t4997
            t5006 = 4914 * t4976 - 1482 * t4988 - 74646 * t4994 + 218790 * t4996 - 120978 * t4998 - 112398 * t5000 + 84318 * t5002 + 1482
            t5005 = 27027 * t4976 - 32175 * t4988 + 217503 * t4994 - 546975 * t4996 + 611325 * t4998 - 271557 * t5000 - 6435 * t5002 + 1287
            t4992 = 2 * phi1
            t4991 = -3 * phi2
            t4990 = 3 * phi2
            tfunc[..., c] = (0.29e2 / 0.1572864e7) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.19e2) * ((2380 - 64260 * t4976 + 387940 * t5002 - 978180 * t5000 + 1320900 * t4998 - 1011500 * t4996 + 421260 * t4994 - 78540 * t4988) * np.exp((-12*1j) * phi2) + (t5005 + t5007) * np.exp((-4*1j) * (phi1 + t4990)) + (t5006 + t5008) * np.exp((-4*1j) * (t4992 + t4990)) + (t5005 - t5007) * np.exp((4*1j) * (phi1 + t4991)) + (t5006 - t5008) * np.exp((4*1j) * (t4992 + t4991)) + (t5009 - t5010) * np.exp((-12*1j) * (phi1 + phi2)) + (t5009 + t5010) * np.exp((12*1j) * (phi1 - phi2)))

        if Bindx == 160:
            t5032 = np.cos(phi)
            t5031 = t5032 ** 2
            t5039 = t5031 ** 2
            t5038 = t5032 * t5031
            t5041 = t5038 ** 2
            t5043 = t5039 ** 2
            t5040 = t5032 * t5039
            t5045 = t5040 ** 2
            t5047 = t5041 ** 2
            t5042 = t5032 * t5041
            t5049 = t5042 ** 2
            t5056 = 38 + 1026 * t5031 - 1394 * t5039 - 7062 * t5041 + 10098 * t5043 + 2662 * t5045 - 4774 * t5047 - 594 * t5049
            t5018 = t5032 * t5049
            t5020 = t5032 * t5047
            t5022 = t5032 * t5045
            t5024 = t5032 * t5043
            t5055 = 63 * t5018 + 2351 * t5020 + 4131 * t5022 - 10637 * t5024 - 319 * t5032 - 1199 * t5038 + 6237 * t5040 - 627 * t5042
            t5054 = 232 - 3016 * t5031 + 4104 * t5039 + 28248 * t5041 - 82632 * t5043 + 67496 * t5045 - 4136 * t5047 - 10296 * t5049
            t5053 = 1638 * t5018 + 21606 * t5020 - 51074 * t5022 + 10142 * t5024 - 374 * t5032 + 8426 * t5038 - 36366 * t5040 + 46002 * t5042
            t5052 = 9009 * t5018 - 11583 * t5020 - 57651 * t5022 + 167805 * t5024 + 1551 * t5032 - 20097 * t5038 + 89331 * t5040 - 178365 * t5042
            t5051 = -2442 * t5031 + 4026 * t5039 + 35310 * t5041 - 134970 * t5043 + 188034 * t5045 - 118338 * t5047 + 28314 * t5049 + 66
            t5037 = 4 * phi1
            t5036 = 8 * phi1
            t5035 = 12 * phi1
            t5034 = -11 * phi2
            t5033 = 11 * phi2
            tfunc[..., c] = (0.29e2 / 0.524288e6*1j) * np.sqrt(0.5e1) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * np.sqrt(0.2e1) * np.sqrt(0.13e2) * ((-21420 * t5018 + 130900 * t5020 - 335580 * t5022 + 464100 * t5024 - 368900 * t5042 + 164220 * t5040 - 35700 * t5038 + 2380 * t5032) * np.exp((-11*1j) * phi2) + (t5051 + t5052) * np.exp((-1*1j) * (t5037 + t5033)) + (t5053 - t5054) * np.exp((-1*1j) * (t5036 + t5033)) + (-t5051 + t5052) * np.exp((1j) * (t5037 + t5034)) + (t5053 + t5054) * np.exp((1j) * (t5036 + t5034)) + (t5055 - t5056) * np.exp((-1*1j) * (t5035 + t5033)) + (t5055 + t5056) * np.exp((1j) * (t5035 + t5034))) * ((1 + t5032) ** (-0.1e1 / 0.2e1)) * ((1 - t5032) ** (-0.1e1 / 0.2e1))

        if Bindx == 161:
            t5077 = np.cos(phi)
            t5076 = t5077 ** 2
            t5083 = t5077 * t5076
            t5086 = t5083 ** 2
            t5092 = t5086 ** 2
            t5065 = t5077 * t5092
            t5084 = t5076 ** 2
            t5085 = t5077 * t5084
            t5090 = t5085 ** 2
            t5067 = t5077 * t5090
            t5088 = t5084 ** 2
            t5069 = t5077 * t5088
            t5087 = t5077 * t5086
            t5100 = 2700 * t5065 + 16400 * t5067 - 15620 * t5069 - 1100 * t5077 - 400 * t5083 + 19140 * t5085 - 21120 * t5087
            t5064 = t5087 ** 2
            t5099 = -155 + 315 * t5064 - 2635 * t5076 + 10065 * t5084 + 7425 * t5086 - 33825 * t5088 + 9295 * t5090 + 9515 * t5092
            t5098 = 8190 * t5064 + 10258 * t5076 - 54582 * t5084 + 73722 * t5086 + 67782 * t5088 - 191114 * t5090 + 86190 * t5092 - 446
            t5097 = 46800 * t5065 + 1600 * t5067 - 196592 * t5069 + 1072 * t5077 + 4032 * t5083 - 76560 * t5085 + 219648 * t5087
            t5096 = -128700 * t5065 + 462000 * t5067 - 620268 * t5069 - 132 * t5077 + 6864 * t5083 - 95700 * t5085 + 375936 * t5087
            t5095 = 45045 * t5064 - 17061 * t5076 + 127743 * t5084 - 361713 * t5086 + 438801 * t5088 - 175263 * t5090 - 57915 * t5092 + 363
            t5082 = 2 * phi1
            t5081 = 4 * phi1
            t5080 = 6 * phi1
            t5079 = -5 * phi2
            t5078 = 5 * phi2
            tfunc[..., c] = (0.29e2 / 0.1048576e7) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((476 + 559300 * t5092 - 1190476 * t5090 + 1311380 * t5088 - 778260 * t5086 + 230860 * t5084 - 26180 * t5076 - 107100 * t5064) * np.exp((-10*1j) * phi2) + (t5095 - t5096) * np.exp((-2*1j) * (t5082 + t5078)) + (t5097 + t5098) * np.exp((-2*1j) * (t5081 + t5078)) + (t5099 + t5100) * np.exp((-2*1j) * (t5080 + t5078)) + (t5095 + t5096) * np.exp((2*1j) * (t5082 + t5079)) + (-t5097 + t5098) * np.exp((2*1j) * (t5081 + t5079)) + (t5099 - t5100) * np.exp((2*1j) * (t5080 + t5079)))

        if Bindx == 162:
            t5122 = np.cos(phi)
            t5121 = t5122 ** 2
            t5128 = t5121 ** 2
            t5127 = t5122 * t5121
            t5130 = t5127 ** 2
            t5132 = t5128 ** 2
            t5129 = t5122 * t5128
            t5134 = t5129 ** 2
            t5136 = t5130 ** 2
            t5131 = t5122 * t5130
            t5138 = t5131 ** 2
            t5145 = -370 - 2590 * t5121 + 27710 * t5128 - 43230 * t5130 - 23430 * t5132 + 73590 * t5134 - 24390 * t5136 - 7290 * t5138
            t5108 = t5122 * t5138
            t5110 = t5122 * t5136
            t5112 = t5122 * t5134
            t5114 = t5122 * t5132
            t5144 = 945 * t5108 + 21565 * t5110 - 15635 * t5112 - 64295 * t5114 + 2115 * t5122 - 8385 * t5127 - 16665 * t5129 + 80355 * t5131
            t5143 = 24570 * t5108 + 175890 * t5110 - 608670 * t5112 + 587994 * t5114 - 4194 * t5122 + 38646 * t5127 - 74250 * t5129 - 139986 * t5131
            t5142 = 10296 * t5121 - 108984 * t5128 + 409464 * t5130 - 620136 * t5132 + 277992 * t5134 + 158040 * t5136 - 126360 * t5138 - 312
            t5141 = 11286 * t5121 - 134838 * t5128 + 689238 * t5130 - 1716066 * t5132 + 2196018 * t5134 - 1392930 * t5136 + 347490 * t5138 - 198
            t5140 = 135135 * t5108 - 302445 * t5110 - 120285 * t5112 + 896247 * t5114 + 4653 * t5122 - 86031 * t5127 + 446985 * t5129 - 974259 * t5131
            t5126 = 4 * phi1
            t5125 = 8 * phi1
            t5124 = -9 * phi2
            t5123 = 9 * phi2
            tfunc[..., c] = (0.29e2 / 0.786432e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * ((1 + t5122) ** (-0.1e1 / 0.2e1)) * ((1 - t5122) ** (-0.1e1 / 0.2e1)) * ((-321300 * t5108 + 1725500 * t5110 - 3815140 * t5112 + 4438700 * t5114 - 2867900 * t5131 + 987700 * t5129 - 154700 * t5127 + 7140 * t5122) * np.exp((-9*1j) * phi2) + (t5144 - t5145) * np.exp((-3*1j) * (t5126 + 3 * phi2)) + (t5140 + t5141) * np.exp((-1*1j) * (t5126 + t5123)) + (-t5142 + t5143) * np.exp((-1*1j) * (t5125 + t5123)) + (t5140 - t5141) * np.exp((1j) * (t5126 + t5124)) + (t5142 + t5143) * np.exp((1j) * (t5125 + t5124)) + (t5144 + t5145) * np.exp((3*1j) * (t5126 - 3 * phi2)))

        if Bindx == 163:
            t5166 = np.cos(phi)
            t5165 = t5166 ** 2
            t5170 = t5166 * t5165
            t5173 = t5170 ** 2
            t5179 = t5173 ** 2
            t5154 = t5166 * t5179
            t5171 = t5165 ** 2
            t5172 = t5166 * t5171
            t5177 = t5172 ** 2
            t5156 = t5166 * t5177
            t5175 = t5171 ** 2
            t5158 = t5166 * t5175
            t5174 = t5166 * t5173
            t5187 = 49680 * t5154 + 92000 * t5156 - 384560 * t5158 + 9200 * t5166 - 69920 * t5170 + 60720 * t5172 + 242880 * t5174
            t5153 = t5174 ** 2
            t5186 = -7245 * t5153 + 2185 * t5165 + 110055 * t5171 - 322575 * t5173 + 178365 * t5175 + 165715 * t5177 - 124315 * t5179 - 2185
            t5185 = -188370 * t5153 - 23206 * t5165 - 48378 * t5171 + 1048410 * t5173 - 3069198 * t5175 + 3235870 * t5177 - 959790 * t5179 + 566
            t5184 = -861120 * t5154 + 1251200 * t5156 + 663872 * t5158 + 18880 * t5166 - 263808 * t5170 + 1189056 * t5172 - 2002176 * t5174
            t5183 = -2368080 * t5154 + 8136480 * t5156 - 10771728 * t5158 - 14256 * t5166 + 317856 * t5170 - 2195952 * t5172 + 6895680 * t5174
            t5182 = -1036035 * t5153 + 83655 * t5165 - 796983 * t5171 + 2494239 * t5173 - 2777709 * t5175 - 185955 * t5177 + 2220075 * t5179 - 1287
            t5169 = 3 * phi1
            t5168 = -2 * phi2
            t5167 = 2 * phi2
            tfunc[..., c] = -(0.29e2 / 0.524288e6) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((-2380 + 2463300 * t5153 - 11221700 * t5179 + 20418020 * t5177 - 18723460 * t5175 + 8932140 * t5173 - 2039660 * t5171 + 173740 * t5165) * np.exp((-8*1j) * phi2) + (t5184 + t5185) * np.exp((-8*1j) * (phi1 + phi2)) + (t5182 + t5183) * np.exp((-4*1j) * (phi1 + t5167)) + (t5186 - t5187) * np.exp((-4*1j) * (t5169 + t5167)) + (t5182 - t5183) * np.exp((4*1j) * (phi1 + t5168)) + (t5186 + t5187) * np.exp((4*1j) * (t5169 + t5168)) + (-t5184 + t5185) * np.exp((8*1j) * (phi1 - phi2)))

        if Bindx == 164:
            t5209 = np.cos(phi)
            t5208 = t5209 ** 2
            t5216 = t5208 ** 2
            t5215 = t5209 * t5208
            t5218 = t5215 ** 2
            t5220 = t5216 ** 2
            t5217 = t5209 * t5216
            t5222 = t5217 ** 2
            t5224 = t5218 ** 2
            t5219 = t5209 * t5218
            t5226 = t5219 ** 2
            t5233 = 230 - 2070 * t5208 - 1610 * t5216 + 31050 * t5218 - 60030 * t5220 + 36110 * t5222 + 2530 * t5224 - 6210 * t5226
            t5195 = t5209 * t5226
            t5197 = t5209 * t5224
            t5199 = t5209 * t5222
            t5201 = t5209 * t5220
            t5232 = 1035 * t5195 + 11615 * t5197 - 36225 * t5199 + 22195 * t5201 - 575 * t5209 + 8165 * t5215 - 25875 * t5217 + 19665 * t5219
            t5231 = -7448 * t5208 + 54936 * t5216 - 136920 * t5218 + 74376 * t5220 + 184184 * t5222 - 276920 * t5224 + 107640 * t5226 + 152
            t5230 = 26910 * t5195 + 62790 * t5197 - 388010 * t5199 + 563486 * t5201 + 650 * t5209 - 13454 * t5215 + 106386 * t5217 - 358758 * t5219
            t5229 = 148005 * t5195 - 444015 * t5197 + 406065 * t5199 - 3267 * t5201 + 783 * t5209 - 17877 * t5215 + 102243 * t5217 - 191937 * t5219
            t5228 = 9198 * t5208 - 114702 * t5216 + 563598 * t5218 - 1373322 * t5220 + 1765434 * t5222 - 1146090 * t5224 + 296010 * t5226 - 126
            t5214 = 4 * phi1
            t5213 = 8 * phi1
            t5212 = -7 * phi2
            t5211 = 7 * phi2
            t5210 = 12 * phi1
            tfunc[..., c] = (0.29e2 / 0.262144e6*1j) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * np.sqrt(0.19e2) * np.sqrt(0.7e1) * ((-351900 * t5195 + 1681300 * t5197 - 3260940 * t5199 + 3271140 * t5201 - 1784660 * t5219 + 506940 * t5217 - 64260 * t5215 + 2380 * t5209) * np.exp((-7*1j) * phi2) + (t5228 + t5229) * np.exp((-1*1j) * (t5214 + t5211)) + (t5230 + t5231) * np.exp((-1*1j) * (t5213 + t5211)) + (-t5228 + t5229) * np.exp((1j) * (t5214 + t5212)) + (t5230 - t5231) * np.exp((1j) * (t5213 + t5212)) + (t5232 - t5233) * np.exp((-1*1j) * (t5210 + t5211)) + (t5232 + t5233) * np.exp((1j) * (t5210 + t5212))) * ((1 + t5209) ** (-0.1e1 / 0.2e1)) * ((1 - t5209) ** (-0.1e1 / 0.2e1))

        if Bindx == 165:
            t5254 = np.cos(phi)
            t5253 = t5254 ** 2
            t5259 = t5254 * t5253
            t5262 = t5259 ** 2
            t5263 = t5254 * t5262
            t5241 = t5263 ** 2
            t5260 = t5253 ** 2
            t5264 = t5260 ** 2
            t5261 = t5254 * t5260
            t5266 = t5261 ** 2
            t5268 = t5262 ** 2
            t5276 = -21735 * t5241 - 50025 * t5253 + 133515 * t5260 + 83835 * t5262 - 580635 * t5264 + 584085 * t5266 - 152375 * t5268 + 3335
            t5242 = t5254 * t5268
            t5244 = t5254 * t5266
            t5246 = t5254 * t5264
            t5275 = -111780 * t5242 + 160080 * t5244 + 272780 * t5246 + 1380 * t5254 - 86480 * t5259 + 426420 * t5261 - 662400 * t5263
            t5274 = -3108105 * t5241 + 22041 * t5253 - 191259 * t5260 + 22581 * t5262 + 3050091 * t5264 - 8527365 * t5266 + 8732295 * t5268 - 279
            t5273 = -1937520 * t5242 + 5056320 * t5244 - 4317744 * t5246 + 10608 * t5254 - 161088 * t5259 + 358704 * t5261 + 990720 * t5263
            t5272 = -5328180 * t5242 + 17669520 * t5244 - 22706244 * t5246 - 22284 * t5254 + 581616 * t5259 - 4355964 * t5261 + 14161536 * t5263
            t5271 = -565110 * t5241 + 102630 * t5253 - 989874 * t5260 + 3787038 * t5262 - 6543198 * t5264 + 4703730 * t5266 - 493350 * t5268 - 1866
            t5258 = 2 * phi1
            t5257 = 4 * phi1
            t5256 = -3 * phi2
            t5255 = 3 * phi2
            tfunc[..., c] = -(0.29e2 / 0.3145728e7) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((-37477860 * t5264 + 15162980 * t5262 - 2905980 * t5260 + 207060 * t5253 + 7389900 * t5241 - 29833300 * t5268 + 47459580 * t5266 - 2380) * np.exp((-6*1j) * phi2) + (t5275 + t5276) * np.exp((-6*1j) * (t5258 + phi2)) + (t5272 + t5274) * np.exp((-2*1j) * (t5258 + t5255)) + (t5271 + t5273) * np.exp((-2*1j) * (t5257 + t5255)) + (-t5272 + t5274) * np.exp((2*1j) * (t5258 + t5256)) + (t5271 - t5273) * np.exp((2*1j) * (t5257 + t5256)) + (-t5275 + t5276) * np.exp((6*1j) * (t5258 - phi2)))

        if Bindx == 166:
            t5298 = np.cos(phi)
            t5297 = t5298 ** 2
            t5305 = t5297 ** 2
            t5304 = t5298 * t5297
            t5307 = t5304 ** 2
            t5309 = t5305 ** 2
            t5306 = t5298 * t5305
            t5311 = t5306 ** 2
            t5313 = t5307 ** 2
            t5308 = t5298 * t5307
            t5315 = t5308 ** 2
            t5322 = 230 - 4830 * t5297 + 25070 * t5305 - 46230 * t5307 + 22770 * t5309 + 25990 * t5311 - 33350 * t5313 + 10350 * t5315
            t5284 = t5298 * t5315
            t5286 = t5298 * t5313
            t5288 = t5298 * t5311
            t5290 = t5298 * t5309
            t5321 = 2415 * t5284 + 6095 * t5286 - 51405 * t5288 + 95795 * t5290 - 575 * t5298 - 575 * t5304 + 23805 * t5306 - 75555 * t5308
            t5320 = 62790 * t5284 - 80730 * t5286 - 226274 * t5288 + 578334 * t5290 + 1674 * t5298 - 33718 * t5304 + 197170 * t5306 - 499246 * t5308
            t5319 = -1464 * t5297 + 25976 * t5305 - 184920 * t5307 + 578248 * t5309 - 877864 * t5311 + 639400 * t5313 - 179400 * t5315 + 24
            t5318 = 345345 * t5284 - 1233375 * t5286 + 1732797 * t5288 - 1215555 * t5290 - 241 * t5298 + 7695 * t5304 - 85421 * t5306 + 448755 * t5308
            t5317 = 11050 * t5297 - 154330 * t5305 + 817426 * t5307 - 2090310 * t5309 + 2782494 * t5311 - 1859550 * t5313 + 493350 * t5315 - 130
            t5303 = 4 * phi1
            t5302 = 8 * phi1
            t5301 = -5 * phi2
            t5300 = 5 * phi2
            t5299 = 12 * phi1
            tfunc[..., c] = (0.29e2 / 0.524288e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * np.sqrt(0.5e1) * ((2380 * t5298 - 821100 * t5284 + 3558100 * t5286 - 6207516 * t5288 + 5551588 * t5290 - 2676548 * t5308 + 666876 * t5306 - 73780 * t5304) * np.exp((-5*1j) * phi2) + (t5317 + t5318) * np.exp((-1*1j) * (t5303 + t5300)) + (-t5319 + t5320) * np.exp((-1*1j) * (t5302 + t5300)) + (-t5317 + t5318) * np.exp((1j) * (t5303 + t5301)) + (t5319 + t5320) * np.exp((1j) * (t5302 + t5301)) + (t5321 + t5322) * np.exp((-1*1j) * (t5299 + t5300)) + (t5321 - t5322) * np.exp((1j) * (t5299 + t5301))) * ((1 + t5298) ** (-0.1e1 / 0.2e1)) * ((1 - t5298) ** (-0.1e1 / 0.2e1))

        if Bindx == 167:
            t5343 = np.cos(phi)
            t5342 = t5343 ** 2
            t5346 = t5343 * t5342
            t5349 = t5346 ** 2
            t5350 = t5343 * t5349
            t5330 = t5350 ** 2
            t5347 = t5342 ** 2
            t5351 = t5347 ** 2
            t5348 = t5343 * t5347
            t5353 = t5348 ** 2
            t5355 = t5349 ** 2
            t5363 = 45885 * t5330 - 54625 * t5342 + 369265 * t5347 - 928625 * t5349 + 1037875 * t5351 - 461035 * t5353 - 10925 * t5355 + 2185
            t5331 = t5343 * t5355
            t5333 = t5343 * t5353
            t5335 = t5343 * t5351
            t5362 = -157320 * t5331 + 594320 * t5333 - 786600 * t5335 + 17480 * t5343 - 104880 * t5346 + 87400 * t5348 + 349600 * t5350
            t5361 = -2726880 * t5331 + 9369280 * t5333 - 12403808 * t5335 - 16416 * t5343 + 366016 * t5346 - 2528672 * t5348 + 7940480 * t5350
            t5360 = -7498920 * t5331 + 24227280 * t5333 - 30111048 * t5335 - 21656 * t5343 + 631184 * t5346 - 5166328 * t5348 + 17935392 * t5350
            t5359 = 1193010 * t5330 - 96330 * t5342 + 917738 * t5347 - 2872154 * t5349 + 3198574 * t5351 + 214130 * t5353 - 2556450 * t5355 + 1482
            t5358 = 6561555 * t5330 + 67729 * t5342 - 1030561 * t5347 + 6149217 * t5349 - 18088323 * t5351 + 27904635 * t5353 - 21559395 * t5355 - 761
            t5345 = 2 * phi1
            t5344 = 3 * phi1
            tfunc[..., c] = (0.29e2 / 0.524288e6) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * ((2380 - 15600900 * t5330 + 57203300 * t5355 - 82164740 * t5353 + 58288580 * t5351 - 21117740 * t5349 + 3619980 * t5347 - 230860 * t5342) * np.exp((-4*1j) * phi2) + (t5358 - t5360) * np.exp((-4*1j) * (phi1 + phi2)) + (t5359 - t5361) * np.exp((-4*1j) * (t5345 + phi2)) + (-t5362 + t5363) * np.exp((-4*1j) * (t5344 + phi2)) + (t5358 + t5360) * np.exp((4*1j) * (phi1 - phi2)) + (t5359 + t5361) * np.exp((4*1j) * (t5345 - phi2)) + (t5362 + t5363) * np.exp((4*1j) * (t5344 - phi2)))

        if Bindx == 168:
            t5385 = np.cos(phi)
            t5384 = t5385 ** 2
            t5391 = t5384 ** 2
            t5390 = t5385 * t5384
            t5393 = t5390 ** 2
            t5395 = t5391 ** 2
            t5392 = t5385 * t5391
            t5397 = t5392 ** 2
            t5399 = t5393 ** 2
            t5394 = t5385 * t5393
            t5401 = t5394 ** 2
            t5408 = -126730 * t5384 + 1630010 * t5391 - 6402050 * t5393 + 11689750 * t5395 - 11147870 * t5397 + 5414430 * t5399 - 1061910 * t5401 + 4370
            t5407 = -865458 * t5384 + 13063842 * t5391 - 73723914 * t5393 + 197967726 * t5395 - 273162582 * t5397 + 187328790 * t5399 - 50617710 * t5401 + 9306
            t5406 = -975384 * t5384 + 11273688 * t5391 - 50659320 * t5393 + 112284072 * t5395 - 131299272 * t5397 + 77768520 * t5399 - 18406440 * t5401 + 14136
            t5371 = t5385 * t5401
            t5373 = t5385 * t5399
            t5375 = t5385 * t5397
            t5377 = t5385 * t5395
            t5405 = -10737090 * t5371 + 39710190 * t5373 - 54314730 * t5375 + 31494438 * t5377 - 33630 * t5385 + 660402 * t5390 - 2172726 * t5392 - 4606854 * t5394
            t5404 = -412965 * t5371 + 1352515 * t5373 - 404225 * t5375 - 3812825 * t5377 - 163875 * t5385 + 1531685 * t5390 - 4787335 * t5392 + 6697025 * t5394
            t5403 = -59053995 * t5371 + 233403885 * t5373 - 373143375 * t5375 + 308275209 * t5377 + 112563 * t5385 - 3526677 * t5390 + 32902551 * t5392 - 138970161 * t5394
            t5389 = 4 * phi1
            t5388 = 8 * phi1
            t5387 = -3 * phi2
            t5386 = 3 * phi2
            tfunc[..., c] = (-0.29e2 / 0.1572864e7*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * ((-235620 * t5385 + 140408100 * t5371 - 566832700 * t5373 + 918372980 * t5375 - 760555180 * t5377 + 338743020 * t5394 - 77833140 * t5392 + 7932540 * t5390) * np.exp((-3*1j) * phi2) + (t5404 + t5408) * np.exp((-3*1j) * (t5389 + phi2)) + (t5403 + t5407) * np.exp((-1*1j) * (t5389 + t5386)) + (t5405 + t5406) * np.exp((-1*1j) * (t5388 + t5386)) + (t5403 - t5407) * np.exp((1j) * (t5389 + t5387)) + (t5405 - t5406) * np.exp((1j) * (t5388 + t5387)) + (t5404 - t5408) * np.exp((3*1j) * (t5389 - phi2))) * ((1 + t5385) ** (-0.1e1 / 0.2e1)) * ((1 - t5385) ** (-0.1e1 / 0.2e1))

        if Bindx == 169:
            t5429 = np.cos(phi)
            t5428 = t5429 ** 2
            t5433 = t5429 * t5428
            t5436 = t5433 ** 2
            t5437 = t5429 * t5436
            t5416 = t5437 ** 2
            t5434 = t5428 ** 2
            t5438 = t5434 ** 2
            t5435 = t5429 * t5434
            t5440 = t5435 ** 2
            t5442 = t5436 ** 2
            t5450 = -137655 * t5416 + 67735 * t5428 - 168245 * t5434 - 98325 * t5436 + 797525 * t5438 - 1090315 * t5440 + 631465 * t5442 - 2185
            t5417 = t5429 * t5442
            t5419 = t5429 * t5440
            t5421 = t5429 * t5438
            t5449 = -235980 * t5417 + 1223600 * t5419 - 2578300 * t5421 - 43700 * t5429 + 454480 * t5433 - 1616900 * t5435 + 2796800 * t5437
            t5448 = -11248380 * t5417 + 35764080 * t5419 - 43320684 * t5421 - 25476 * t5429 + 790416 * t5433 - 6839316 * t5435 + 24879360 * t5437
            t5447 = -4090320 * t5417 + 16081600 * t5419 - 24590864 * t5421 - 44080 * t5429 + 1020224 * t5433 - 6606832 * t5435 + 18230272 * t5437
            t5446 = -3579030 * t5416 - 110618 * t5428 + 1380046 * t5434 - 6900610 * t5436 + 17083394 * t5438 - 22020430 * t5440 + 14145690 * t5442 + 1558
            t5445 = -19684665 * t5416 - 279015 * t5428 + 4317093 * t5434 - 25055547 * t5436 + 69396987 * t5438 - 99000165 * t5440 + 70302375 * t5442 + 2937
            t5432 = 2 * phi1
            t5431 = 4 * phi1
            t5430 = 6 * phi1
            tfunc[..., c] = -(0.29e2 / 0.1048576e7) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * ((-4620 + 217372540 * t5440 - 144749220 * t5438 + 49244580 * t5436 - 7932540 * t5434 + 475860 * t5428 + 46802700 * t5416 - 161209300 * t5442) * np.exp((-2*1j) * phi2) + (t5445 + t5448) * np.exp((-2*1j) * (t5432 + phi2)) + (t5446 + t5447) * np.exp((-2*1j) * (t5431 + phi2)) + (t5449 + t5450) * np.exp((-2*1j) * (t5430 + phi2)) + (t5445 - t5448) * np.exp((2*1j) * (t5432 - phi2)) + (t5446 - t5447) * np.exp((2*1j) * (t5431 - phi2)) + (-t5449 + t5450) * np.exp((2*1j) * (t5430 - phi2)))

        if Bindx == 170:
            t5472 = np.cos(phi)
            t5471 = t5472 ** 2
            t5477 = t5471 ** 2
            t5476 = t5472 * t5471
            t5479 = t5476 ** 2
            t5481 = t5477 ** 2
            t5478 = t5472 * t5477
            t5483 = t5478 ** 2
            t5485 = t5479 ** 2
            t5480 = t5472 * t5479
            t5487 = t5480 ** 2
            t5494 = 83226 * t5471 - 1305018 * t5477 + 7613034 * t5479 - 21013278 * t5481 + 29620734 * t5483 - 20622030 * t5485 + 5624190 * t5487 - 858
            t5493 = -144210 * t5471 + 773490 * t5477 - 1857250 * t5479 + 2425350 * t5481 - 1796070 * t5483 + 712310 * t5485 - 117990 * t5487 + 4370
            t5492 = -144248 * t5471 + 1693432 * t5477 - 7415928 * t5479 + 15545192 * t5481 - 16952104 * t5483 + 9316840 * t5485 - 2045160 * t5487 + 1976
            t5458 = t5472 * t5487
            t5460 = t5472 * t5485
            t5462 = t5472 * t5483
            t5464 = t5472 * t5481
            t5491 = -137655 * t5458 + 849965 * t5460 - 2209035 * t5462 + 3113625 * t5464 + 24035 * t5472 - 281865 * t5476 + 1186455 * t5478 - 2545525 * t5480
            t5490 = -3579030 * t5458 + 17554290 * t5460 - 35165390 * t5462 + 36735322 * t5464 + 36062 * t5472 - 882778 * t5476 + 6408662 * t5478 - 21107138 * t5480
            t5489 = -19684665 * t5458 + 81550755 * t5460 - 135917925 * t5462 + 116078391 * t5464 + 41613 * t5472 - 1346631 * t5476 + 12724569 * t5478 - 53446107 * t5480
            t5475 = 4 * phi1
            t5474 = 8 * phi1
            t5473 = 12 * phi1
            tfunc[..., c] = (-0.29e2 / 0.262144e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * ((46802700 * t5458 - 182010500 * t5460 + 283936380 * t5462 - 226326100 * t5464 + 96996900 * t5480 - 21441420 * t5478 + 2102100 * t5476 - 60060 * t5472) * np.exp((-1*1j) * phi2) + (t5489 - t5494) * np.exp((-1*1j) * (t5475 + phi2)) + (t5490 + t5492) * np.exp((-1*1j) * (t5474 + phi2)) + (t5489 + t5494) * np.exp((1j) * (t5475 - phi2)) + (t5490 - t5492) * np.exp((1j) * (t5474 - phi2)) + (t5491 + t5493) * np.exp((-1*1j) * (t5473 + phi2)) + (t5491 - t5493) * np.exp((1j) * (t5473 - phi2))) * ((1 + t5472) ** (-0.1e1 / 0.2e1)) * ((1 - t5472) ** (-0.1e1 / 0.2e1))

        if Bindx == 171:
            t5505 = np.cos(phi)
            t5504 = t5505 ** 2
            t5506 = t5504 ** 2
            t5507 = t5504 * t5506
            t5510 = t5507 ** 2
            t5508 = t5506 ** 2
            t5500 = t5504 * t5508
            t5498 = t5504 * t5510
            tfunc[..., c] = 0.29e2 / 0.393216e6 * np.sqrt(0.7e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.17e2) * (-(10029150 * t5498) + (33801950 * t5510) - (44618574 * t5500) + (29099070 * t5508) - (9699690 * t5507) + (1531530 * t5506) - (90090 * t5504) + 0.858e3 + (8436285 * t5498 - 30933045 * t5510 + 44431101 * t5500 - 31519917 * t5508 + 11419551 * t5507 - 1957527 * t5506 + 124839 * t5504 - 1287) * np.cos((4 * phi1)) + (1533870 * t5498 - 6987630 * t5510 + 12714078 * t5500 - 11658894 * t5508 + 5561946 * t5507 - 1270074 * t5506 + 108186 * t5504 - 1482) * np.cos((8 * phi1)) + (58995 * t5498 - 356155 * t5510 + 898035 * t5500 - 1212675 * t5508 + 928625 * t5507 - 386745 * t5506 + 72105 * t5504 - 2185) * np.cos((12 * phi1)))

        if Bindx == 172:
            t5533 = np.cos(phi)
            t5532 = t5533 ** 2
            t5538 = t5532 ** 2
            t5537 = t5533 * t5532
            t5540 = t5537 ** 2
            t5542 = t5538 ** 2
            t5539 = t5533 * t5538
            t5544 = t5539 ** 2
            t5546 = t5540 ** 2
            t5541 = t5533 * t5540
            t5548 = t5541 ** 2
            t5555 = 83226 * t5532 - 1305018 * t5538 + 7613034 * t5540 - 21013278 * t5542 + 29620734 * t5544 - 20622030 * t5546 + 5624190 * t5548 - 858
            t5554 = -144210 * t5532 + 773490 * t5538 - 1857250 * t5540 + 2425350 * t5542 - 1796070 * t5544 + 712310 * t5546 - 117990 * t5548 + 4370
            t5553 = -144248 * t5532 + 1693432 * t5538 - 7415928 * t5540 + 15545192 * t5542 - 16952104 * t5544 + 9316840 * t5546 - 2045160 * t5548 + 1976
            t5519 = t5533 * t5548
            t5521 = t5533 * t5546
            t5523 = t5533 * t5544
            t5525 = t5533 * t5542
            t5552 = 137655 * t5519 - 849965 * t5521 + 2209035 * t5523 - 3113625 * t5525 - 24035 * t5533 + 281865 * t5537 - 1186455 * t5539 + 2545525 * t5541
            t5551 = 3579030 * t5519 - 17554290 * t5521 + 35165390 * t5523 - 36735322 * t5525 - 36062 * t5533 + 882778 * t5537 - 6408662 * t5539 + 21107138 * t5541
            t5550 = 19684665 * t5519 - 81550755 * t5521 + 135917925 * t5523 - 116078391 * t5525 - 41613 * t5533 + 1346631 * t5537 - 12724569 * t5539 + 53446107 * t5541
            t5536 = 4 * phi1
            t5535 = 8 * phi1
            t5534 = 12 * phi1
            tfunc[..., c] = (0.29e2 / 0.262144e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * ((-46802700 * t5519 + 182010500 * t5521 - 283936380 * t5523 + 226326100 * t5525 - 96996900 * t5541 + 21441420 * t5539 - 2102100 * t5537 + 60060 * t5533) * np.exp((1j) * phi2) + (t5550 - t5555) * np.exp((-1*1j) * (t5536 - phi2)) + (t5551 + t5553) * np.exp((-1*1j) * (t5535 - phi2)) + (t5550 + t5555) * np.exp((1j) * (t5536 + phi2)) + (t5551 - t5553) * np.exp((1j) * (t5535 + phi2)) + (t5552 + t5554) * np.exp((-1*1j) * (t5534 - phi2)) + (t5552 - t5554) * np.exp((1j) * (t5534 + phi2))) * ((1 + t5533) ** (-0.1e1 / 0.2e1)) * ((1 - t5533) ** (-0.1e1 / 0.2e1))

        if Bindx == 173:
            t5576 = np.cos(phi)
            t5575 = t5576 ** 2
            t5580 = t5576 * t5575
            t5583 = t5580 ** 2
            t5584 = t5576 * t5583
            t5563 = t5584 ** 2
            t5581 = t5575 ** 2
            t5585 = t5581 ** 2
            t5582 = t5576 * t5581
            t5587 = t5582 ** 2
            t5589 = t5583 ** 2
            t5597 = -137655 * t5563 + 67735 * t5575 - 168245 * t5581 - 98325 * t5583 + 797525 * t5585 - 1090315 * t5587 + 631465 * t5589 - 2185
            t5564 = t5576 * t5589
            t5566 = t5576 * t5587
            t5568 = t5576 * t5585
            t5596 = -235980 * t5564 + 1223600 * t5566 - 2578300 * t5568 - 43700 * t5576 + 454480 * t5580 - 1616900 * t5582 + 2796800 * t5584
            t5595 = -11248380 * t5564 + 35764080 * t5566 - 43320684 * t5568 - 25476 * t5576 + 790416 * t5580 - 6839316 * t5582 + 24879360 * t5584
            t5594 = -4090320 * t5564 + 16081600 * t5566 - 24590864 * t5568 - 44080 * t5576 + 1020224 * t5580 - 6606832 * t5582 + 18230272 * t5584
            t5593 = -3579030 * t5563 - 110618 * t5575 + 1380046 * t5581 - 6900610 * t5583 + 17083394 * t5585 - 22020430 * t5587 + 14145690 * t5589 + 1558
            t5592 = -19684665 * t5563 - 279015 * t5575 + 4317093 * t5581 - 25055547 * t5583 + 69396987 * t5585 - 99000165 * t5587 + 70302375 * t5589 + 2937
            t5579 = 2 * phi1
            t5578 = 4 * phi1
            t5577 = 6 * phi1
            tfunc[..., c] = -(0.29e2 / 0.1048576e7) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * ((-4620 + 46802700 * t5563 - 161209300 * t5589 + 217372540 * t5587 - 144749220 * t5585 + 49244580 * t5583 - 7932540 * t5581 + 475860 * t5575) * np.exp((2*1j) * phi2) + (t5592 - t5595) * np.exp((-2*1j) * (t5579 - phi2)) + (t5593 - t5594) * np.exp((-2*1j) * (t5578 - phi2)) + (-t5596 + t5597) * np.exp((-2*1j) * (t5577 - phi2)) + (t5592 + t5595) * np.exp((2*1j) * (t5579 + phi2)) + (t5593 + t5594) * np.exp((2*1j) * (t5578 + phi2)) + (t5596 + t5597) * np.exp((2*1j) * (t5577 + phi2)))

        if Bindx == 174:
            t5619 = np.cos(phi)
            t5618 = t5619 ** 2
            t5625 = t5618 ** 2
            t5624 = t5619 * t5618
            t5627 = t5624 ** 2
            t5629 = t5625 ** 2
            t5626 = t5619 * t5625
            t5631 = t5626 ** 2
            t5633 = t5627 ** 2
            t5628 = t5619 * t5627
            t5635 = t5628 ** 2
            t5642 = -126730 * t5618 + 1630010 * t5625 - 6402050 * t5627 + 11689750 * t5629 - 11147870 * t5631 + 5414430 * t5633 - 1061910 * t5635 + 4370
            t5641 = -865458 * t5618 + 13063842 * t5625 - 73723914 * t5627 + 197967726 * t5629 - 273162582 * t5631 + 187328790 * t5633 - 50617710 * t5635 + 9306
            t5640 = -975384 * t5618 + 11273688 * t5625 - 50659320 * t5627 + 112284072 * t5629 - 131299272 * t5631 + 77768520 * t5633 - 18406440 * t5635 + 14136
            t5605 = t5619 * t5635
            t5607 = t5619 * t5633
            t5609 = t5619 * t5631
            t5611 = t5619 * t5629
            t5639 = 10737090 * t5605 - 39710190 * t5607 + 54314730 * t5609 - 31494438 * t5611 + 33630 * t5619 - 660402 * t5624 + 2172726 * t5626 + 4606854 * t5628
            t5638 = 412965 * t5605 - 1352515 * t5607 + 404225 * t5609 + 3812825 * t5611 + 163875 * t5619 - 1531685 * t5624 + 4787335 * t5626 - 6697025 * t5628
            t5637 = 59053995 * t5605 - 233403885 * t5607 + 373143375 * t5609 - 308275209 * t5611 - 112563 * t5619 + 3526677 * t5624 - 32902551 * t5626 + 138970161 * t5628
            t5623 = 4 * phi1
            t5622 = 8 * phi1
            t5621 = -3 * phi2
            t5620 = 3 * phi2
            tfunc[..., c] = (0.29e2 / 0.1572864e7*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * ((760555180 * t5611 - 338743020 * t5628 + 77833140 * t5626 - 7932540 * t5624 + 235620 * t5619 - 140408100 * t5605 + 566832700 * t5607 - 918372980 * t5609) * np.exp((3*1j) * phi2) + (t5638 + t5642) * np.exp((-3*1j) * (t5623 - phi2)) + (t5637 + t5641) * np.exp((-1*1j) * (t5623 + t5621)) + (t5639 + t5640) * np.exp((-1*1j) * (t5622 + t5621)) + (t5637 - t5641) * np.exp((1j) * (t5623 + t5620)) + (t5639 - t5640) * np.exp((1j) * (t5622 + t5620)) + (t5638 - t5642) * np.exp((3*1j) * (t5623 + phi2))) * ((1 + t5619) ** (-0.1e1 / 0.2e1)) * ((1 - t5619) ** (-0.1e1 / 0.2e1))

        if Bindx == 175:
            t5663 = np.cos(phi)
            t5662 = t5663 ** 2
            t5666 = t5663 * t5662
            t5669 = t5666 ** 2
            t5670 = t5663 * t5669
            t5650 = t5670 ** 2
            t5667 = t5662 ** 2
            t5671 = t5667 ** 2
            t5668 = t5663 * t5667
            t5673 = t5668 ** 2
            t5675 = t5669 ** 2
            t5683 = 45885 * t5650 - 54625 * t5662 + 369265 * t5667 - 928625 * t5669 + 1037875 * t5671 - 461035 * t5673 - 10925 * t5675 + 2185
            t5651 = t5663 * t5675
            t5653 = t5663 * t5673
            t5655 = t5663 * t5671
            t5682 = -157320 * t5651 + 594320 * t5653 - 786600 * t5655 + 17480 * t5663 - 104880 * t5666 + 87400 * t5668 + 349600 * t5670
            t5681 = -2726880 * t5651 + 9369280 * t5653 - 12403808 * t5655 - 16416 * t5663 + 366016 * t5666 - 2528672 * t5668 + 7940480 * t5670
            t5680 = -7498920 * t5651 + 24227280 * t5653 - 30111048 * t5655 - 21656 * t5663 + 631184 * t5666 - 5166328 * t5668 + 17935392 * t5670
            t5679 = 1193010 * t5650 - 96330 * t5662 + 917738 * t5667 - 2872154 * t5669 + 3198574 * t5671 + 214130 * t5673 - 2556450 * t5675 + 1482
            t5678 = 6561555 * t5650 + 67729 * t5662 - 1030561 * t5667 + 6149217 * t5669 - 18088323 * t5671 + 27904635 * t5673 - 21559395 * t5675 - 761
            t5665 = 2 * phi1
            t5664 = 3 * phi1
            tfunc[..., c] = (0.29e2 / 0.524288e6) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * ((-15600900 * t5650 + 57203300 * t5675 - 82164740 * t5673 + 58288580 * t5671 - 21117740 * t5669 + 3619980 * t5667 - 230860 * t5662 + 2380) * np.exp((4*1j) * phi2) + (t5678 + t5680) * np.exp((-4*1j) * (phi1 - phi2)) + (t5679 + t5681) * np.exp((-4*1j) * (t5665 - phi2)) + (t5682 + t5683) * np.exp((-4*1j) * (t5664 - phi2)) + (t5678 - t5680) * np.exp((4*1j) * (phi1 + phi2)) + (t5679 - t5681) * np.exp((4*1j) * (t5665 + phi2)) + (-t5682 + t5683) * np.exp((4*1j) * (t5664 + phi2)))

        if Bindx == 176:
            t5705 = np.cos(phi)
            t5704 = t5705 ** 2
            t5712 = t5704 ** 2
            t5711 = t5705 * t5704
            t5714 = t5711 ** 2
            t5716 = t5712 ** 2
            t5713 = t5705 * t5712
            t5718 = t5713 ** 2
            t5720 = t5714 ** 2
            t5715 = t5705 * t5714
            t5722 = t5715 ** 2
            t5729 = -230 + 4830 * t5704 - 25070 * t5712 + 46230 * t5714 - 22770 * t5716 - 25990 * t5718 + 33350 * t5720 - 10350 * t5722
            t5691 = t5705 * t5722
            t5693 = t5705 * t5720
            t5695 = t5705 * t5718
            t5697 = t5705 * t5716
            t5728 = 2415 * t5691 + 6095 * t5693 - 51405 * t5695 + 95795 * t5697 - 575 * t5705 - 575 * t5711 + 23805 * t5713 - 75555 * t5715
            t5727 = 62790 * t5691 - 80730 * t5693 - 226274 * t5695 + 578334 * t5697 + 1674 * t5705 - 33718 * t5711 + 197170 * t5713 - 499246 * t5715
            t5726 = -1464 * t5704 + 25976 * t5712 - 184920 * t5714 + 578248 * t5716 - 877864 * t5718 + 639400 * t5720 - 179400 * t5722 + 24
            t5725 = 345345 * t5691 - 1233375 * t5693 + 1732797 * t5695 - 1215555 * t5697 - 241 * t5705 + 7695 * t5711 - 85421 * t5713 + 448755 * t5715
            t5724 = 11050 * t5704 - 154330 * t5712 + 817426 * t5714 - 2090310 * t5716 + 2782494 * t5718 - 1859550 * t5720 + 493350 * t5722 - 130
            t5710 = 4 * phi1
            t5709 = 8 * phi1
            t5708 = -5 * phi2
            t5707 = 5 * phi2
            t5706 = 12 * phi1
            tfunc[..., c] = (0.29e2 / 0.524288e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((1 + t5705) ** (-0.1e1 / 0.2e1)) * ((1 - t5705) ** (-0.1e1 / 0.2e1)) * ((-821100 * t5691 + 3558100 * t5693 - 6207516 * t5695 + 5551588 * t5697 - 2676548 * t5715 + 666876 * t5713 - 73780 * t5711 + 2380 * t5705) * np.exp((5*1j) * phi2) + (-t5724 + t5725) * np.exp((-1*1j) * (t5710 + t5708)) + (t5726 + t5727) * np.exp((-1*1j) * (t5709 + t5708)) + (t5724 + t5725) * np.exp((1j) * (t5710 + t5707)) + (-t5726 + t5727) * np.exp((1j) * (t5709 + t5707)) + (t5728 + t5729) * np.exp((-1*1j) * (t5706 + t5708)) + (t5728 - t5729) * np.exp((1j) * (t5706 + t5707)))

        if Bindx == 177:
            t5750 = np.cos(phi)
            t5749 = t5750 ** 2
            t5755 = t5750 * t5749
            t5758 = t5755 ** 2
            t5759 = t5750 * t5758
            t5737 = t5759 ** 2
            t5756 = t5749 ** 2
            t5760 = t5756 ** 2
            t5757 = t5750 * t5756
            t5762 = t5757 ** 2
            t5764 = t5758 ** 2
            t5772 = -21735 * t5737 - 50025 * t5749 + 133515 * t5756 + 83835 * t5758 - 580635 * t5760 + 584085 * t5762 - 152375 * t5764 + 3335
            t5738 = t5750 * t5764
            t5740 = t5750 * t5762
            t5742 = t5750 * t5760
            t5771 = -111780 * t5738 + 160080 * t5740 + 272780 * t5742 + 1380 * t5750 - 86480 * t5755 + 426420 * t5757 - 662400 * t5759
            t5770 = -3108105 * t5737 + 22041 * t5749 - 191259 * t5756 + 22581 * t5758 + 3050091 * t5760 - 8527365 * t5762 + 8732295 * t5764 - 279
            t5769 = -1937520 * t5738 + 5056320 * t5740 - 4317744 * t5742 + 10608 * t5750 - 161088 * t5755 + 358704 * t5757 + 990720 * t5759
            t5768 = -5328180 * t5738 + 17669520 * t5740 - 22706244 * t5742 - 22284 * t5750 + 581616 * t5755 - 4355964 * t5757 + 14161536 * t5759
            t5767 = -565110 * t5737 + 102630 * t5749 - 989874 * t5756 + 3787038 * t5758 - 6543198 * t5760 + 4703730 * t5762 - 493350 * t5764 - 1866
            t5754 = 2 * phi1
            t5753 = 4 * phi1
            t5752 = -3 * phi2
            t5751 = 3 * phi2
            tfunc[..., c] = -(0.29e2 / 0.3145728e7) * np.sqrt(0.3e1) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((7389900 * t5737 - 29833300 * t5764 + 47459580 * t5762 - 37477860 * t5760 + 15162980 * t5758 - 2905980 * t5756 + 207060 * t5749 - 2380) * np.exp((6*1j) * phi2) + (-t5771 + t5772) * np.exp((-6*1j) * (t5754 - phi2)) + (-t5768 + t5770) * np.exp((-2*1j) * (t5754 + t5752)) + (t5767 - t5769) * np.exp((-2*1j) * (t5753 + t5752)) + (t5768 + t5770) * np.exp((2*1j) * (t5754 + t5751)) + (t5767 + t5769) * np.exp((2*1j) * (t5753 + t5751)) + (t5771 + t5772) * np.exp((6*1j) * (t5754 + phi2)))

        if Bindx == 178:
            t5794 = np.cos(phi)
            t5793 = t5794 ** 2
            t5801 = t5793 ** 2
            t5800 = t5794 * t5793
            t5803 = t5800 ** 2
            t5805 = t5801 ** 2
            t5802 = t5794 * t5801
            t5807 = t5802 ** 2
            t5809 = t5803 ** 2
            t5804 = t5794 * t5803
            t5811 = t5804 ** 2
            t5818 = 230 - 2070 * t5793 - 1610 * t5801 + 31050 * t5803 - 60030 * t5805 + 36110 * t5807 + 2530 * t5809 - 6210 * t5811
            t5780 = t5794 * t5811
            t5782 = t5794 * t5809
            t5784 = t5794 * t5807
            t5786 = t5794 * t5805
            t5817 = 1035 * t5780 + 11615 * t5782 - 36225 * t5784 + 22195 * t5786 - 575 * t5794 + 8165 * t5800 - 25875 * t5802 + 19665 * t5804
            t5816 = -7448 * t5793 + 54936 * t5801 - 136920 * t5803 + 74376 * t5805 + 184184 * t5807 - 276920 * t5809 + 107640 * t5811 + 152
            t5815 = 26910 * t5780 + 62790 * t5782 - 388010 * t5784 + 563486 * t5786 + 650 * t5794 - 13454 * t5800 + 106386 * t5802 - 358758 * t5804
            t5814 = 148005 * t5780 - 444015 * t5782 + 406065 * t5784 - 3267 * t5786 + 783 * t5794 - 17877 * t5800 + 102243 * t5802 - 191937 * t5804
            t5813 = 9198 * t5793 - 114702 * t5801 + 563598 * t5803 - 1373322 * t5805 + 1765434 * t5807 - 1146090 * t5809 + 296010 * t5811 - 126
            t5799 = 4 * phi1
            t5798 = 8 * phi1
            t5797 = -7 * phi2
            t5796 = 7 * phi2
            t5795 = 12 * phi1
            tfunc[..., c] = (0.29e2 / 0.262144e6*1j) * np.sqrt(0.11e2) * np.sqrt(0.13e2) * np.sqrt(0.19e2) * np.sqrt(0.7e1) * ((-351900 * t5780 + 1681300 * t5782 - 3260940 * t5784 + 3271140 * t5786 - 1784660 * t5804 + 506940 * t5802 - 64260 * t5800 + 2380 * t5794) * np.exp((7*1j) * phi2) + (-t5813 + t5814) * np.exp((-1*1j) * (t5799 + t5797)) + (t5815 - t5816) * np.exp((-1*1j) * (t5798 + t5797)) + (t5813 + t5814) * np.exp((1j) * (t5799 + t5796)) + (t5815 + t5816) * np.exp((1j) * (t5798 + t5796)) + (t5817 + t5818) * np.exp((-1*1j) * (t5795 + t5797)) + (t5817 - t5818) * np.exp((1j) * (t5795 + t5796))) * ((1 + t5794) ** (-0.1e1 / 0.2e1)) * ((1 - t5794) ** (-0.1e1 / 0.2e1))

        if Bindx == 179:
            t5839 = np.cos(phi)
            t5838 = t5839 ** 2
            t5843 = t5839 * t5838
            t5846 = t5843 ** 2
            t5852 = t5846 ** 2
            t5827 = t5839 * t5852
            t5844 = t5838 ** 2
            t5845 = t5839 * t5844
            t5850 = t5845 ** 2
            t5829 = t5839 * t5850
            t5848 = t5844 ** 2
            t5831 = t5839 * t5848
            t5847 = t5839 * t5846
            t5860 = 49680 * t5827 + 92000 * t5829 - 384560 * t5831 + 9200 * t5839 - 69920 * t5843 + 60720 * t5845 + 242880 * t5847
            t5826 = t5847 ** 2
            t5859 = 7245 * t5826 - 2185 * t5838 - 110055 * t5844 + 322575 * t5846 - 178365 * t5848 - 165715 * t5850 + 124315 * t5852 + 2185
            t5858 = 188370 * t5826 + 23206 * t5838 + 48378 * t5844 - 1048410 * t5846 + 3069198 * t5848 - 3235870 * t5850 + 959790 * t5852 - 566
            t5857 = -861120 * t5827 + 1251200 * t5829 + 663872 * t5831 + 18880 * t5839 - 263808 * t5843 + 1189056 * t5845 - 2002176 * t5847
            t5856 = -2368080 * t5827 + 8136480 * t5829 - 10771728 * t5831 - 14256 * t5839 + 317856 * t5843 - 2195952 * t5845 + 6895680 * t5847
            t5855 = 1036035 * t5826 - 83655 * t5838 + 796983 * t5844 - 2494239 * t5846 + 2777709 * t5848 + 185955 * t5850 - 2220075 * t5852 + 1287
            t5842 = 3 * phi1
            t5841 = -2 * phi2
            t5840 = 2 * phi2
            tfunc[..., c] = (0.29e2 / 0.524288e6) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((2380 - 2463300 * t5826 + 11221700 * t5852 - 20418020 * t5850 + 18723460 * t5848 - 8932140 * t5846 + 2039660 * t5844 - 173740 * t5838) * np.exp((8*1j) * phi2) + (t5857 + t5858) * np.exp((-8*1j) * (phi1 - phi2)) + (t5855 + t5856) * np.exp((-4*1j) * (phi1 + t5841)) + (t5859 - t5860) * np.exp((-4*1j) * (t5842 + t5841)) + (t5855 - t5856) * np.exp((4*1j) * (phi1 + t5840)) + (t5859 + t5860) * np.exp((4*1j) * (t5842 + t5840)) + (-t5857 + t5858) * np.exp((8*1j) * (phi1 + phi2)))

        if Bindx == 180:
            t5882 = np.cos(phi)
            t5881 = t5882 ** 2
            t5888 = t5881 ** 2
            t5887 = t5882 * t5881
            t5890 = t5887 ** 2
            t5892 = t5888 ** 2
            t5889 = t5882 * t5888
            t5894 = t5889 ** 2
            t5896 = t5890 ** 2
            t5891 = t5882 * t5890
            t5898 = t5891 ** 2
            t5905 = -370 - 2590 * t5881 + 27710 * t5888 - 43230 * t5890 - 23430 * t5892 + 73590 * t5894 - 24390 * t5896 - 7290 * t5898
            t5868 = t5882 * t5898
            t5870 = t5882 * t5896
            t5872 = t5882 * t5894
            t5874 = t5882 * t5892
            t5904 = 945 * t5868 + 21565 * t5870 - 15635 * t5872 - 64295 * t5874 + 2115 * t5882 - 8385 * t5887 - 16665 * t5889 + 80355 * t5891
            t5903 = 24570 * t5868 + 175890 * t5870 - 608670 * t5872 + 587994 * t5874 - 4194 * t5882 + 38646 * t5887 - 74250 * t5889 - 139986 * t5891
            t5902 = 10296 * t5881 - 108984 * t5888 + 409464 * t5890 - 620136 * t5892 + 277992 * t5894 + 158040 * t5896 - 126360 * t5898 - 312
            t5901 = 11286 * t5881 - 134838 * t5888 + 689238 * t5890 - 1716066 * t5892 + 2196018 * t5894 - 1392930 * t5896 + 347490 * t5898 - 198
            t5900 = 135135 * t5868 - 302445 * t5870 - 120285 * t5872 + 896247 * t5874 + 4653 * t5882 - 86031 * t5887 + 446985 * t5889 - 974259 * t5891
            t5886 = 4 * phi1
            t5885 = 8 * phi1
            t5884 = -9 * phi2
            t5883 = 9 * phi2
            tfunc[..., c] = (0.29e2 / 0.786432e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.23e2) * np.sqrt(0.19e2) * ((-321300 * t5868 + 1725500 * t5870 - 3815140 * t5872 + 4438700 * t5874 - 2867900 * t5891 + 987700 * t5889 - 154700 * t5887 + 7140 * t5882) * np.exp((9*1j) * phi2) + (t5904 + t5905) * np.exp((-3*1j) * (t5886 - 3 * phi2)) + (t5900 - t5901) * np.exp((-1*1j) * (t5886 + t5884)) + (t5902 + t5903) * np.exp((-1*1j) * (t5885 + t5884)) + (t5900 + t5901) * np.exp((1j) * (t5886 + t5883)) + (-t5902 + t5903) * np.exp((1j) * (t5885 + t5883)) + (t5904 - t5905) * np.exp((3*1j) * (t5886 + 3 * phi2))) * ((1 + t5882) ** (-0.1e1 / 0.2e1)) * ((1 - t5882) ** (-0.1e1 / 0.2e1))

        if Bindx == 181:
            t5926 = np.cos(phi)
            t5925 = t5926 ** 2
            t5932 = t5926 * t5925
            t5935 = t5932 ** 2
            t5941 = t5935 ** 2
            t5914 = t5926 * t5941
            t5933 = t5925 ** 2
            t5934 = t5926 * t5933
            t5939 = t5934 ** 2
            t5916 = t5926 * t5939
            t5937 = t5933 ** 2
            t5918 = t5926 * t5937
            t5936 = t5926 * t5935
            t5949 = -2700 * t5914 - 16400 * t5916 + 15620 * t5918 + 1100 * t5926 + 400 * t5932 - 19140 * t5934 + 21120 * t5936
            t5913 = t5936 ** 2
            t5948 = -155 + 315 * t5913 - 2635 * t5925 + 10065 * t5933 + 7425 * t5935 - 33825 * t5937 + 9295 * t5939 + 9515 * t5941
            t5947 = 8190 * t5913 + 10258 * t5925 - 54582 * t5933 + 73722 * t5935 + 67782 * t5937 - 191114 * t5939 + 86190 * t5941 - 446
            t5946 = 46800 * t5914 + 1600 * t5916 - 196592 * t5918 + 1072 * t5926 + 4032 * t5932 - 76560 * t5934 + 219648 * t5936
            t5945 = -128700 * t5914 + 462000 * t5916 - 620268 * t5918 - 132 * t5926 + 6864 * t5932 - 95700 * t5934 + 375936 * t5936
            t5944 = 45045 * t5913 - 17061 * t5925 + 127743 * t5933 - 361713 * t5935 + 438801 * t5937 - 175263 * t5939 - 57915 * t5941 + 363
            t5931 = 2 * phi1
            t5930 = 4 * phi1
            t5929 = 6 * phi1
            t5928 = -5 * phi2
            t5927 = 5 * phi2
            tfunc[..., c] = (0.29e2 / 0.1048576e7) * np.sqrt(0.13e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * ((476 - 107100 * t5913 + 559300 * t5941 - 1190476 * t5939 + 1311380 * t5937 - 778260 * t5935 + 230860 * t5933 - 26180 * t5925) * np.exp((10*1j) * phi2) + (t5944 + t5945) * np.exp((-2*1j) * (t5931 + t5928)) + (-t5946 + t5947) * np.exp((-2*1j) * (t5930 + t5928)) + (t5948 + t5949) * np.exp((-2*1j) * (t5929 + t5928)) + (t5944 - t5945) * np.exp((2*1j) * (t5931 + t5927)) + (t5946 + t5947) * np.exp((2*1j) * (t5930 + t5927)) + (t5948 - t5949) * np.exp((2*1j) * (t5929 + t5927)))

        if Bindx == 182:
            t5971 = np.cos(phi)
            t5970 = t5971 ** 2
            t5978 = t5970 ** 2
            t5977 = t5971 * t5970
            t5980 = t5977 ** 2
            t5982 = t5978 ** 2
            t5979 = t5971 * t5978
            t5984 = t5979 ** 2
            t5986 = t5980 ** 2
            t5981 = t5971 * t5980
            t5988 = t5981 ** 2
            t5995 = 38 + 1026 * t5970 - 1394 * t5978 - 7062 * t5980 + 10098 * t5982 + 2662 * t5984 - 4774 * t5986 - 594 * t5988
            t5957 = t5971 * t5988
            t5959 = t5971 * t5986
            t5961 = t5971 * t5984
            t5963 = t5971 * t5982
            t5994 = 63 * t5957 + 2351 * t5959 + 4131 * t5961 - 10637 * t5963 - 319 * t5971 - 1199 * t5977 + 6237 * t5979 - 627 * t5981
            t5993 = 232 - 3016 * t5970 + 4104 * t5978 + 28248 * t5980 - 82632 * t5982 + 67496 * t5984 - 4136 * t5986 - 10296 * t5988
            t5992 = 1638 * t5957 + 21606 * t5959 - 51074 * t5961 + 10142 * t5963 - 374 * t5971 + 8426 * t5977 - 36366 * t5979 + 46002 * t5981
            t5991 = 9009 * t5957 - 11583 * t5959 - 57651 * t5961 + 167805 * t5963 + 1551 * t5971 - 20097 * t5977 + 89331 * t5979 - 178365 * t5981
            t5990 = -2442 * t5970 + 4026 * t5978 + 35310 * t5980 - 134970 * t5982 + 188034 * t5984 - 118338 * t5986 + 28314 * t5988 + 66
            t5976 = 4 * phi1
            t5975 = 8 * phi1
            t5974 = 12 * phi1
            t5973 = -11 * phi2
            t5972 = 11 * phi2
            tfunc[..., c] = (0.29e2 / 0.524288e6*1j) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * ((1 + t5971) ** (-0.1e1 / 0.2e1)) * ((1 - t5971) ** (-0.1e1 / 0.2e1)) * ((-21420 * t5957 + 130900 * t5959 - 335580 * t5961 + 464100 * t5963 - 368900 * t5981 + 164220 * t5979 - 35700 * t5977 + 2380 * t5971) * np.exp((11*1j) * phi2) + (-t5990 + t5991) * np.exp((-1*1j) * (t5976 + t5973)) + (t5992 + t5993) * np.exp((-1*1j) * (t5975 + t5973)) + (t5990 + t5991) * np.exp((1j) * (t5976 + t5972)) + (t5992 - t5993) * np.exp((1j) * (t5975 + t5972)) + (t5994 + t5995) * np.exp((-1*1j) * (t5974 + t5973)) + (t5994 - t5995) * np.exp((1j) * (t5974 + t5972)))

        if Bindx == 183:
            t6016 = np.cos(phi)
            t6015 = t6016 ** 2
            t6020 = t6016 * t6015
            t6023 = t6020 ** 2
            t6029 = t6023 ** 2
            t6004 = t6016 * t6029
            t6021 = t6015 ** 2
            t6022 = t6016 * t6021
            t6027 = t6022 ** 2
            t6006 = t6016 * t6027
            t6025 = t6021 ** 2
            t6008 = t6016 * t6025
            t6024 = t6016 * t6023
            t6037 = -1944 * t6004 - 21840 * t6006 - 19448 * t6008 - 1320 * t6016 - 11024 * t6020 + 10296 * t6022 + 41184 * t6024
            t6003 = t6024 ** 2
            t6036 = 137 + 189 * t6003 + 5343 * t6015 + 9009 * t6021 - 36465 * t6023 - 14157 * t6025 + 31317 * t6027 + 8723 * t6029
            t6035 = 33696 * t6004 + 62400 * t6006 - 260832 * t6008 + 6240 * t6016 - 47424 * t6020 + 41184 * t6022 + 164736 * t6024
            t6034 = 92664 * t6004 - 350064 * t6006 + 463320 * t6008 - 10296 * t6016 + 61776 * t6020 - 51480 * t6022 - 205920 * t6024
            t6033 = 4914 * t6003 - 1482 * t6015 - 74646 * t6021 + 218790 * t6023 - 120978 * t6025 - 112398 * t6027 + 84318 * t6029 + 1482
            t6032 = 27027 * t6003 - 32175 * t6015 + 217503 * t6021 - 546975 * t6023 + 611325 * t6025 - 271557 * t6027 - 6435 * t6029 + 1287
            t6019 = 2 * phi1
            t6018 = -3 * phi2
            t6017 = 3 * phi2
            tfunc[..., c] = (0.29e2 / 0.1572864e7) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.19e2) * ((-64260 * t6003 + 387940 * t6029 - 978180 * t6027 + 1320900 * t6025 - 1011500 * t6023 + 421260 * t6021 - 78540 * t6015 + 2380) * np.exp((12*1j) * phi2) + (t6032 - t6034) * np.exp((-4*1j) * (phi1 + t6018)) + (t6033 - t6035) * np.exp((-4*1j) * (t6019 + t6018)) + (t6032 + t6034) * np.exp((4*1j) * (phi1 + t6017)) + (t6033 + t6035) * np.exp((4*1j) * (t6019 + t6017)) + (t6036 + t6037) * np.exp((-12*1j) * (phi1 - phi2)) + (t6036 - t6037) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 184:
            t6058 = np.cos(phi)
            t6057 = t6058 ** 2
            t6064 = t6058 * t6057
            t6067 = t6064 ** 2
            t6068 = t6058 * t6067
            t6045 = t6068 ** 2
            t6078 = 7 * t6045 - 1287 * t6067 + 1716 * t6068
            t6077 = 182 * t6045 + 7722 * t6067 - 10296 * t6068
            t6076 = 1001 * t6045 - 19305 * t6067 + 25740 * t6068
            t6073 = t6067 ** 2
            t6065 = t6057 ** 2
            t6066 = t6058 * t6065
            t6071 = t6066 ** 2
            t6069 = t6065 ** 2
            t6063 = 4 * phi1
            t6062 = 8 * phi1
            t6061 = 12 * phi1
            t6060 = -13 * phi2
            t6059 = 13 * phi2
            t6050 = t6058 * t6069
            t6048 = t6058 * t6071
            t6046 = t6058 * t6073
            tfunc[..., c] = (-0.87e2 / 0.524288e6*1j) * np.sqrt(0.23e2) * np.sqrt(0.5e1) * np.sqrt(0.19e2) * np.sqrt(0.2e1) * np.sqrt((1 - t6058)) * ((1 + t6058) ** (-0.1e1 / 0.2e1)) * (2380 * (-t6045 - t6046 + 6 * t6073 + 6 * t6048 - 15 * t6071 - 15 * t6050 + 20 * t6069 + 20 * t6068 - 15 * t6067 - 15 * t6066 + 6 * t6065 + 6 * t6064 - t6057 - t6058) * np.exp((13*1j) * phi2) + (-1170 * t6046 + 2548 * t6073 - 676 * t6048 - 6006 * t6071 + 8866 * t6050 + 2002 * t6066 - 5148 * t6065 + 1820 * t6064 + 598 * t6057 - 546 * t6058 + 104 + t6077) * np.exp((-1*1j) * (t6062 + t6060)) + (-2717 * t6046 - 2860 * t6073 + 13442 * t6048 - 1001 * t6071 - 26455 * t6050 + 12870 * t6069 - 12155 * t6066 + 12584 * t6065 + 2002 * t6064 - 3575 * t6057 + 143 * t6058 + 286 + t6076) * np.exp((-1*1j) * (t6063 + t6060)) + (4719 * t6046 + 4576 * t6073 - 11726 * t6048 - 26169 * t6071 - 715 * t6050 + 38610 * t6069 - 26455 * t6066 - 1716 * t6065 + 8866 * t6064 + 3289 * t6057 - 429 * t6058 - 286 + t6076) * np.exp((1j) * (t6063 + t6059)) + (1534 * t6046 + 5252 * t6073 + 8476 * t6048 + 3146 * t6071 - 11726 * t6050 - 20592 * t6069 + 13442 * t6066 + 6292 * t6065 - 676 * t6064 - 1898 * t6057 - 754 * t6058 - 104 + t6077) * np.exp((1j) * (t6062 + t6059)) + (-71 * t6046 + 312 * t6073 - 754 * t6048 + 1001 * t6071 - 429 * t6050 - 858 * t6069 + 143 * t6066 + 572 * t6065 - 546 * t6064 + 247 * t6057 - 59 * t6058 + 6 + t6078) * np.exp((-1*1j) * (t6061 + t6060)) + (85 * t6046 + 468 * t6073 + 1534 * t6048 + 3289 * t6071 + 4719 * t6050 + 4290 * t6069 - 2717 * t6066 - 2288 * t6065 - 1170 * t6064 - 377 * t6057 - 71 * t6058 - 6 + t6078) * np.exp((1j) * (t6061 + t6059)))

        if Bindx == 185:
            t6098 = np.cos(phi)
            t6097 = t6098 ** 2
            t6105 = t6097 ** 2
            t6106 = t6098 * t6105
            t6110 = t6106 ** 2
            t6089 = t6098 * t6110
            t6104 = t6098 * t6097
            t6123 = -4 * t6089 + 4 * t6104
            t6107 = t6104 ** 2
            t6112 = t6107 ** 2
            t6113 = t6098 * t6112
            t6122 = t6098 - t6113
            t6086 = t6098 * t6113
            t6121 = 1 - t6086
            t6108 = t6105 ** 2
            t6091 = t6098 * t6108
            t6120 = -20 * t6091 + 20 * t6106 + 4 * t6122 - 4 * t6123
            t6119 = -208 * t6089 - 572 * t6091 + 12 * t6098 + 208 * t6104 + 572 * t6106 - 12 * t6113
            t6118 = 2288 * t6091 - 2288 * t6106 + 208 * t6122 + 208 * t6123
            t6117 = t6097 - 19 * t6105 + 45 * t6107 - 45 * t6108 + 19 * t6110 - t6112 + t6121
            t6116 = 65 * t6097 + 429 * t6105 + 429 * t6107 - 429 * t6108 - 429 * t6110 - 65 * t6112 + t6121
            t6115 = 26 - 26 * t6086 + 650 * t6097 - 286 * t6105 - 2574 * t6107 + 2574 * t6108 + 286 * t6110 - 650 * t6112
            t6103 = 2 * phi1
            t6102 = 4 * phi1
            t6101 = 6 * phi1
            t6100 = -7 * phi2
            t6099 = 7 * phi2
            tfunc[..., c] = -(0.87e2 / 0.1048576e7) * np.sqrt(0.5e1) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * np.sqrt(0.2e1) * np.sqrt(0.19e2) * ((340 * t6086 - 2380 * t6112 + 7140 * t6110 - 11900 * t6108 + 11900 * t6107 - 7140 * t6105 + 2380 * t6097 - 340) * np.exp((14*1j) * phi2) + (t6116 - t6119) * np.exp((-2*1j) * (t6101 + t6100)) + (t6116 + t6119) * np.exp((2*1j) * (t6101 + t6099)) + (t6115 - t6118) * np.exp((-2*1j) * (t6102 + t6100)) + (t6115 + t6118) * np.exp((2*1j) * (t6102 + t6099)) + 143 * (t6117 - t6120) * np.exp((-2*1j) * (t6103 + t6100)) + 143 * (t6117 + t6120) * np.exp((2*1j) * (t6103 + t6099)))

        if Bindx == 186:
            t6142 = np.cos(phi)
            t6141 = t6142 ** 2
            t6148 = t6141 ** 2
            t6149 = t6142 * t6148
            t6153 = t6149 ** 2
            t6133 = t6142 * t6153
            t6147 = t6142 * t6141
            t6166 = -4 * t6133 + 4 * t6147
            t6150 = t6147 ** 2
            t6155 = t6150 ** 2
            t6156 = t6142 * t6155
            t6165 = t6156 - t6142
            t6130 = t6142 * t6156
            t6164 = 1 - t6130
            t6151 = t6148 ** 2
            t6135 = t6142 * t6151
            t6163 = 20 * t6135 - 20 * t6149 + 4 * t6165 + 4 * t6166
            t6162 = 208 * t6133 + 572 * t6135 - 12 * t6142 - 208 * t6147 - 572 * t6149 + 12 * t6156
            t6161 = 3168 * t6135 - 3168 * t6149 - 288 * t6165 + 288 * t6166
            t6160 = t6141 - 19 * t6148 + 45 * t6150 - 45 * t6151 + 19 * t6153 - t6155 + t6164
            t6159 = 65 * t6141 + 429 * t6148 + 429 * t6150 - 429 * t6151 - 429 * t6153 - 65 * t6155 + t6164
            t6158 = 36 - 36 * t6130 + 900 * t6141 - 396 * t6148 - 3564 * t6150 + 3564 * t6151 + 396 * t6153 - 900 * t6155
            t6146 = 4 * phi1
            t6145 = 8 * phi1
            t6144 = -15 * phi2
            t6143 = 15 * phi2
            tfunc[..., c] = (0.155e3 / 0.524288e6*1j) * np.sqrt((1 - t6142)) * np.sqrt((1 + t6142)) * np.sqrt(0.2e1) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * np.sqrt(0.29e2) * ((-t6159 + t6162) * np.exp((-3*1j) * (t6146 + 5 * phi2)) + (t6159 + t6162) * np.exp((3*1j) * (t6146 - 5 * phi2)) + (t6158 + t6161) * np.exp((-1*1j) * (t6145 + t6143)) + (-t6158 + t6161) * np.exp((1j) * (t6145 + t6144)) + 69 * (-t6160 + t6163) * np.exp((-1*1j) * (t6146 + t6143)) + 69 * (t6160 + t6163) * np.exp((1j) * (t6146 + t6144)))

        if Bindx == 187:
            t6187 = np.cos(phi)
            t6186 = t6187 ** 2
            t6193 = t6187 * t6186
            t6196 = t6193 ** 2
            t6197 = t6187 * t6196
            t6204 = t6197 ** 2
            t6212 = -4 - 56 * t6204
            t6194 = t6186 ** 2
            t6198 = t6194 ** 2
            t6195 = t6187 * t6194
            t6200 = t6195 ** 2
            t6202 = t6196 ** 2
            t6211 = 56 * t6186 - 164 * t6194 + 120 * t6196 + 180 * t6198 - 376 * t6200 + 244 * t6202 + t6212
            t6173 = t6187 * t6204
            t6175 = t6187 * t6202
            t6177 = t6187 * t6200
            t6179 = t6187 * t6198
            t6210 = t6175 - 15 * t6173 + 221 * t6177 - 595 * t6179 - t6187 + 79 * t6193 - 365 * t6195 + 675 * t6197
            t6209 = -200 * t6186 - 676 * t6194 + 1144 * t6196 + 1716 * t6198 - 1144 * t6200 - 780 * t6202 + t6212
            t6208 = -5 * t6173 - 277 * t6175 - 1313 * t6177 + 143 * t6179 - 43 * t6187 - 507 * t6193 - 143 * t6195 + 2145 * t6197
            t6207 = 96 + 960 * t6186 - 6816 * t6194 + 6336 * t6196 + 9504 * t6198 - 14784 * t6200 + 3360 * t6202 + 1344 * t6204
            t6206 = -180 * t6173 - 3732 * t6175 + 5052 * t6177 + 9372 * t6179 - 588 * t6187 + 1428 * t6193 + 6468 * t6195 - 17820 * t6197
            t6192 = 2 * phi1
            t6191 = 4 * phi1
            t6190 = 6 * phi1
            t6189 = -7 * phi2
            t6188 = 7 * phi2
            tfunc[..., c] = (0.31e2 / 0.262144e6) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * np.sqrt(0.29e2) * ((-t6206 + t6207) * np.exp((-2*1j) * (t6191 + t6188)) + (t6208 + t6209) * np.exp((-2*1j) * (t6190 + t6188)) + (t6206 + t6207) * np.exp((2*1j) * (t6191 + t6189)) + (-t6208 + t6209) * np.exp((2*1j) * (t6190 + t6189)) + 23 * (t6210 + t6211) * np.exp((-2*1j) * (t6192 + t6188)) + 23 * (-t6210 + t6211) * np.exp((2*1j) * (t6192 + t6189)))

        if Bindx == 188:
            t6233 = np.cos(phi)
            t6232 = t6233 ** 2
            t6239 = t6233 * t6232
            t6242 = t6239 ** 2
            t6243 = t6233 * t6242
            t6250 = t6243 ** 2
            t6219 = t6233 * t6250
            t6254 = 91 - 145 * t6219
            t6253 = 391 - 10005 * t6219
            t6252 = 1356 - 5220 * t6219
            t6248 = t6242 ** 2
            t6240 = t6232 ** 2
            t6241 = t6233 * t6240
            t6246 = t6241 ** 2
            t6244 = t6240 ** 2
            t6238 = 4 * phi1
            t6237 = 8 * phi1
            t6236 = 12 * phi1
            t6235 = -13 * phi2
            t6234 = 13 * phi2
            t6225 = t6233 * t6244
            t6223 = t6233 * t6246
            t6221 = t6233 * t6248
            tfunc[..., c] = (0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.7e1) * np.sqrt(0.13e2) * np.sqrt((1 + t6233)) * ((-24679 * t6250 + 35627 * t6221 + 128225 * t6248 - 23897 * t6223 - 271331 * t6246 - 64745 * t6225 + 297045 * t6244 + 135585 * t6243 - 175605 * t6242 - 103615 * t6241 + 52739 * t6240 + 35213 * t6239 - 6785 * t6232 - 4163 * t6233 + t6253) * np.exp((-1*1j) * (t6238 + t6234)) + (30972 * t6250 + 56340 * t6221 - 17652 * t6248 - 184044 * t6223 - 170676 * t6246 + 128964 * t6225 + 302940 * t6244 + 79596 * t6243 - 171468 * t6242 - 126852 * t6241 + 17892 * t6240 + 44700 * t6239 + 9348 * t6232 - 3924 * t6233 - t6252) * np.exp((-1*1j) * (t6237 + t6234)) + (-44689 * t6250 + 33741 * t6221 + 130111 * t6248 - 234439 * t6223 - 60789 * t6246 + 396865 * t6225 - 164565 * t6244 - 268065 * t6243 + 228045 * t6242 + 51175 * t6241 - 102051 * t6240 + 14099 * t6239 + 14329 * t6232 - 3381 * t6233 - t6253) * np.exp((1j) * (t6238 + t6235)) + (41412 * t6250 - 128724 * t6221 + 167412 * t6248 + 34284 * t6223 - 389004 * t6246 + 430716 * t6225 + 1188 * t6244 - 383724 * t6243 + 291852 * t6242 + 6468 * t6241 - 115428 * t6240 + 52836 * t6239 + 1212 * t6232 - 6636 * t6233 + t6252) * np.exp((1j) * (t6237 + t6235)) + (-1363 * t6250 - 5369 * t6221 - 10803 * t6248 - 9061 * t6223 + 6721 * t6246 + 24739 * t6225 + 22737 * t6244 + 429 * t6243 - 17017 * t6242 - 14443 * t6241 - 2873 * t6240 + 3081 * t6239 + 2507 * t6232 + 769 * t6233 + t6254) * np.exp((-1*1j) * (t6236 + t6234)) + (-1653 * t6250 + 8385 * t6221 - 24557 * t6248 + 44421 * t6223 - 46761 * t6246 + 15301 * t6225 + 32175 * t6244 - 55341 * t6243 + 38753 * t6242 - 7293 * t6241 - 10023 * t6240 + 9815 * t6239 - 4227 * t6232 + 951 * t6233 - t6254) * np.exp((1j) * (t6236 + t6235))) * ((1 - t6233) ** (-0.1e1 / 0.2e1))

        if Bindx == 189:
            t6275 = np.cos(phi)
            t6274 = t6275 ** 2
            t6280 = t6274 ** 2
            t6279 = t6275 * t6274
            t6282 = t6279 ** 2
            t6284 = t6280 ** 2
            t6281 = t6275 * t6280
            t6286 = t6281 ** 2
            t6288 = t6282 ** 2
            t6283 = t6275 * t6282
            t6290 = t6283 ** 2
            t6297 = -11712 * t6274 + 30264 * t6280 + 80080 * t6282 - 175032 * t6284 - 13728 * t6286 + 84968 * t6288 + 9744 * t6290 - 488
            t6261 = t6275 * t6290
            t6263 = t6275 * t6288
            t6265 = t6275 * t6286
            t6267 = t6275 * t6284
            t6296 = 1015 * t6261 + 39669 * t6263 + 86775 * t6265 - 152867 * t6267 - 3945 * t6275 - 9451 * t6279 + 90519 * t6281 - 47619 * t6283
            t6295 = -22080 * t6274 + 60168 * t6280 + 193200 * t6282 - 952200 * t6284 + 1415328 * t6286 - 919080 * t6288 + 224112 * t6290 + 552
            t6294 = -36540 * t6261 - 510804 * t6263 + 1082340 * t6265 - 2772 * t6267 + 3780 * t6275 - 147924 * t6279 + 767844 * t6281 - 1155924 * t6283
            t6293 = 70035 * t6261 - 75831 * t6263 - 499629 * t6265 + 1366545 * t6267 + 10419 * t6275 - 144279 * t6279 + 677235 * t6281 - 1404495 * t6283
            t6292 = -64512 * t6274 + 149184 * t6280 + 443520 * t6282 - 1729728 * t6284 + 1596672 * t6286 - 165312 * t6288 - 233856 * t6290 + 4032
            t6278 = 2 * phi1
            t6277 = -3 * phi2
            t6276 = 3 * phi2
            tfunc[..., c] = -(0.31e2 / 0.262144e6) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * ((t6293 + t6295) * np.exp((-4*1j) * (phi1 + t6276)) + (t6292 + t6294) * np.exp((-4*1j) * (t6278 + t6276)) + (-t6293 + t6295) * np.exp((4*1j) * (phi1 + t6277)) + (t6292 - t6294) * np.exp((4*1j) * (t6278 + t6277)) + (t6296 + t6297) * np.exp((-12*1j) * (phi1 + phi2)) + (-t6296 + t6297) * np.exp((12*1j) * (phi1 - phi2)))

        if Bindx == 190:
            t6319 = np.cos(phi)
            t6318 = t6319 ** 2
            t6326 = t6318 ** 2
            t6330 = t6326 ** 2
            t6304 = t6330 ** 2
            t6325 = t6319 * t6318
            t6328 = t6325 ** 2
            t6327 = t6319 * t6326
            t6332 = t6327 ** 2
            t6334 = t6328 ** 2
            t6329 = t6319 * t6328
            t6336 = t6329 ** 2
            t6344 = 3045 * t6304 + 13068 * t6318 - 106392 * t6326 + 101244 * t6328 + 285714 * t6330 - 444444 * t6332 + 51168 * t6334 + 95508 * t6336 + 1089
            t6305 = t6319 * t6336
            t6307 = t6319 * t6334
            t6309 = t6319 * t6332
            t6311 = t6319 * t6330
            t6343 = 26796 * t6305 + 158532 * t6307 - 262548 * t6309 - 169884 * t6311 + 7212 * t6319 - 19068 * t6325 - 120276 * t6327 + 379236 * t6329
            t6342 = 616308 * t6305 - 2765796 * t6307 + 4907188 * t6309 - 4295940 * t6311 + 1012 * t6319 + 3036 * t6325 - 322828 * t6327 + 1857020 * t6329
            t6341 = -643104 * t6305 + 376992 * t6307 + 3161312 * t6309 - 5615456 * t6311 + 16352 * t6319 - 35168 * t6325 - 712992 * t6327 + 3452064 * t6329
            t6340 = -210105 * t6304 - 72956 * t6318 + 643448 * t6326 - 2285740 * t6328 + 3908390 * t6330 - 3170228 * t6332 + 758816 * t6334 + 426972 * t6336 + 1403
            t6339 = -109620 * t6304 + 112112 * t6318 - 805728 * t6326 + 1955184 * t6328 - 899976 * t6330 - 2748592 * t6332 + 3650752 * t6334 - 1150128 * t6336 - 4004
            t6324 = 4 * phi1
            t6323 = 8 * phi1
            t6322 = 12 * phi1
            t6321 = -11 * phi2
            t6320 = 11 * phi2
            tfunc[..., c] = (-0.31e2 / 0.524288e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * ((1 + t6319) ** (-0.1e1 / 0.2e1)) * ((1 - t6319) ** (-0.1e1 / 0.2e1)) * ((-t6340 + t6342) * np.exp((-1*1j) * (t6324 + t6320)) + (t6339 + t6341) * np.exp((-1*1j) * (t6323 + t6320)) + (t6340 + t6342) * np.exp((1j) * (t6324 + t6321)) + (-t6339 + t6341) * np.exp((1j) * (t6323 + t6321)) + (t6343 + t6344) * np.exp((-1*1j) * (t6322 + t6320)) + (t6343 - t6344) * np.exp((1j) * (t6322 + t6321)))

        if Bindx == 191:
            t6365 = np.cos(phi)
            t6364 = t6365 ** 2
            t6371 = t6365 * t6364
            t6374 = t6371 ** 2
            t6375 = t6365 * t6374
            t6382 = t6375 ** 2
            t6351 = t6365 * t6382
            t6380 = t6374 ** 2
            t6353 = t6365 * t6380
            t6372 = t6364 ** 2
            t6373 = t6365 * t6372
            t6378 = t6373 ** 2
            t6355 = t6365 * t6378
            t6376 = t6372 ** 2
            t6357 = t6365 * t6376
            t6389 = -7917 * t6351 - 200109 * t6353 + 11271 * t6355 + 646503 * t6357 - 10179 * t6365 + 70941 * t6371 + 5577 * t6373 - 516087 * t6375
            t6388 = 4056 * t6364 - 158964 * t6372 + 408408 * t6374 - 46332 * t6376 - 545688 * t6378 + 273156 * t6380 + 63336 * t6382 + 2028
            t6387 = 28520 * t6364 - 394220 * t6372 + 2304232 * t6374 - 6282404 * t6376 + 8545880 * t6378 - 5658276 * t6380 + 1456728 * t6382 - 460
            t6386 = 59584 * t6364 - 895776 * t6372 + 4154304 * t6374 - 7488096 * t6376 + 4459840 * t6378 + 1231776 * t6380 - 1520064 * t6382 - 1568
            t6385 = -285012 * t6351 - 2355444 * t6353 + 6984796 * t6355 - 5422340 * t6357 + 39508 * t6365 - 445452 * t6371 + 1285284 * t6373 + 198660 * t6375
            t6384 = -546273 * t6351 + 1061151 * t6353 + 1026467 * t6355 - 4261693 * t6357 - 16399 * t6365 + 327313 * t6371 - 1815827 * t6373 + 4225261 * t6375
            t6370 = 2 * phi1
            t6369 = 4 * phi1
            t6368 = 6 * phi1
            t6367 = -5 * phi2
            t6366 = 5 * phi2
            tfunc[..., c] = -(0.155e3 / 0.262144e6) * ((-t6384 + t6387) * np.exp((-2*1j) * (t6370 + t6366)) + (t6385 + t6386) * np.exp((-2*1j) * (t6369 + t6366)) + (t6388 - t6389) * np.exp((-2*1j) * (t6368 + t6366)) + (t6384 + t6387) * np.exp((2*1j) * (t6370 + t6367)) + (-t6385 + t6386) * np.exp((2*1j) * (t6369 + t6367)) + (t6388 + t6389) * np.exp((2*1j) * (t6368 + t6367))) * np.sqrt(0.3e1)

        if Bindx == 192:
            t6411 = np.cos(phi)
            t6410 = t6411 ** 2
            t6417 = t6410 ** 2
            t6421 = t6417 ** 2
            t6396 = t6421 ** 2
            t6416 = t6411 * t6410
            t6419 = t6416 ** 2
            t6418 = t6411 * t6417
            t6423 = t6418 ** 2
            t6425 = t6419 ** 2
            t6420 = t6411 * t6419
            t6427 = t6420 ** 2
            t6435 = -65975 * t6396 - 92040 * t6410 - 337740 * t6417 + 2865720 * t6419 - 5049330 * t6421 + 1870440 * t6423 + 2038660 * t6425 - 1241240 * t6427 + 11505
            t6397 = t6411 * t6427
            t6399 = t6411 * t6425
            t6401 = t6411 * t6423
            t6403 = t6411 * t6421
            t6434 = 475020 * t6397 + 907140 * t6399 - 4685460 * t6401 + 4126980 * t6403 - 36660 * t6411 + 511940 * t6416 - 1536340 * t6418 + 237380 * t6420
            t6433 = 10925460 * t6397 - 46877220 * t6399 + 80974260 * t6401 - 71862948 * t6403 - 42412 * t6411 + 1076124 * t6416 - 8869260 * t6418 + 34675996 * t6420
            t6432 = -11400480 * t6397 + 22407840 * t6399 + 6179040 * t6401 - 45335136 * t6403 - 150304 * t6411 + 2620576 * t6416 - 15916320 * t6418 + 41594784 * t6420
            t6431 = -4552275 * t6396 - 349416 * t6410 + 3919108 * t6417 - 15865768 * t6419 + 28351686 * t6421 - 19359928 * t6423 - 4957420 * t6425 + 12809160 * t6427 + 4853
            t6430 = -2375100 * t6396 + 431424 * t6410 - 1683696 * t6417 - 5115264 * t6419 + 37361016 * t6421 - 71845312 * t6423 + 55815760 * t6425 - 12579840 * t6427 - 8988
            t6415 = 4 * phi1
            t6414 = 8 * phi1
            t6413 = -9 * phi2
            t6412 = 9 * phi2
            tfunc[..., c] = (-0.93e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * ((1 + t6411) ** (-0.1e1 / 0.2e1)) * ((1 - t6411) ** (-0.1e1 / 0.2e1)) * ((t6434 - t6435) * np.exp((-3*1j) * (t6415 + 3 * phi2)) + (-t6431 + t6433) * np.exp((-1*1j) * (t6415 + t6412)) + (t6430 + t6432) * np.exp((-1*1j) * (t6414 + t6412)) + (t6431 + t6433) * np.exp((1j) * (t6415 + t6413)) + (-t6430 + t6432) * np.exp((1j) * (t6414 + t6413)) + (t6434 + t6435) * np.exp((3*1j) * (t6415 - 3 * phi2)))

        if Bindx == 193:
            t6456 = np.cos(phi)
            t6455 = t6456 ** 2
            t6460 = t6456 * t6455
            t6463 = t6460 ** 2
            t6464 = t6456 * t6463
            t6471 = t6464 ** 2
            t6442 = t6456 * t6471
            t6469 = t6463 ** 2
            t6444 = t6456 * t6469
            t6461 = t6455 ** 2
            t6462 = t6456 * t6461
            t6467 = t6462 ** 2
            t6446 = t6456 * t6467
            t6465 = t6461 ** 2
            t6448 = t6456 * t6465
            t6478 = -28275 * t6442 - 395265 * t6444 + 837525 * t6446 - 2145 * t6448 + 2925 * t6456 - 114465 * t6460 + 594165 * t6462 - 894465 * t6464
            t6477 = 49920 * t6455 - 115440 * t6461 - 343200 * t6463 + 1338480 * t6465 - 1235520 * t6467 + 127920 * t6469 + 180960 * t6471 - 3120
            t6476 = 88320 * t6455 - 1194896 * t6461 + 6331808 * t6463 - 16530928 * t6465 + 22573120 * t6467 - 15428400 * t6469 + 4162080 * t6471 - 1104
            t6475 = 222208 * t6455 - 1954176 * t6461 + 6209280 * t6463 - 6880896 * t6465 - 2168320 * t6467 + 8910720 * t6469 - 4343040 * t6471 - 3968
            t6474 = -1950975 * t6442 + 5162235 * t6444 - 3158935 * t6446 - 2535589 * t6448 - 10143 * t6456 + 255323 * t6460 - 1650871 * t6462 + 3888955 * t6464
            t6473 = -1017900 * t6442 - 3652740 * t6444 + 16225300 * t6446 - 19711076 * t6448 - 4780 * t6456 + 172284 * t6460 - 2288748 * t6462 + 10269468 * t6464
            t6459 = 3 * phi1
            t6458 = -2 * phi2
            t6457 = 2 * phi2
            tfunc[..., c] = -(0.31e2 / 0.131072e6) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * ((t6473 + t6475) * np.exp((-8*1j) * (phi1 + phi2)) + (-t6474 + t6476) * np.exp((-4*1j) * (phi1 + t6457)) + (t6477 - t6478) * np.exp((-4*1j) * (t6459 + t6457)) + (t6474 + t6476) * np.exp((4*1j) * (phi1 + t6458)) + (t6477 + t6478) * np.exp((4*1j) * (t6459 + t6458)) + (-t6473 + t6475) * np.exp((8*1j) * (phi1 - phi2)))

        if Bindx == 194:
            t6500 = np.cos(phi)
            t6499 = t6500 ** 2
            t6506 = t6500 * t6499
            t6509 = t6506 ** 2
            t6510 = t6500 * t6509
            t6517 = t6510 ** 2
            t6486 = t6500 * t6517
            t6515 = t6509 ** 2
            t6488 = t6500 * t6515
            t6507 = t6499 ** 2
            t6508 = t6500 * t6507
            t6513 = t6508 ** 2
            t6490 = t6500 * t6513
            t6511 = t6507 ** 2
            t6492 = t6500 * t6511
            t6525 = -158340 * t6486 + 205140 * t6488 + 596700 * t6490 - 1467180 * t6492 + 3900 * t6500 + 17940 * t6506 - 339300 * t6508 + 1141140 * t6510
            t6485 = t6511 ** 2
            t6524 = -28275 * t6485 + 42120 * t6499 - 244140 * t6507 + 429000 * t6509 + 115830 * t6511 - 1046760 * t6513 + 982020 * t6515 - 248040 * t6517 - 1755
            t6523 = 3800160 * t6486 - 11662560 * t6488 + 11989600 * t6490 - 3012064 * t6492 + 19040 * t6500 - 376544 * t6506 + 1843296 * t6508 - 2600928 * t6510
            t6522 = -3641820 * t6486 + 15051660 * t6488 - 25166140 * t6490 + 21755148 * t6492 + 9828 * t6500 - 290612 * t6506 + 2562308 * t6508 - 10280372 * t6510
            t6521 = -1950975 * t6485 - 21912 * t6499 + 273188 * t6507 - 1015512 * t6509 + 653518 * t6511 + 3562424 * t6513 - 8210540 * t6515 + 6709560 * t6517 + 249
            t6520 = -1017900 * t6485 - 101632 * t6499 + 1259664 * t6507 - 6578880 * t6509 + 16803864 * t6511 - 21574784 * t6513 + 12368720 * t6515 - 1160640 * t6517 + 1588
            t6505 = 4 * phi1
            t6504 = 8 * phi1
            t6503 = -7 * phi2
            t6502 = 7 * phi2
            t6501 = 12 * phi1
            tfunc[..., c] = (0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * ((t6521 + t6522) * np.exp((-1*1j) * (t6505 + t6502)) + (-t6520 + t6523) * np.exp((-1*1j) * (t6504 + t6502)) + (-t6521 + t6522) * np.exp((1j) * (t6505 + t6503)) + (t6520 + t6523) * np.exp((1j) * (t6504 + t6503)) + (t6524 + t6525) * np.exp((-1*1j) * (t6501 + t6502)) + (-t6524 + t6525) * np.exp((1j) * (t6501 + t6503))) * ((1 + t6500) ** (-0.1e1 / 0.2e1)) * ((1 - t6500) ** (-0.1e1 / 0.2e1))

        if Bindx == 195:
            t6546 = np.cos(phi)
            t6545 = t6546 ** 2
            t6552 = t6545 ** 2
            t6551 = t6546 * t6545
            t6554 = t6551 ** 2
            t6556 = t6552 ** 2
            t6553 = t6546 * t6552
            t6558 = t6553 ** 2
            t6560 = t6554 ** 2
            t6555 = t6546 * t6554
            t6562 = t6555 ** 2
            t6569 = -7800 * t6545 + 64740 * t6552 - 190840 * t6554 + 212940 * t6556 - 29640 * t6558 - 94900 * t6560 + 45240 * t6562 + 260
            t6532 = t6546 * t6562
            t6534 = t6546 * t6560
            t6536 = t6546 * t6558
            t6538 = t6546 * t6556
            t6568 = 9425 * t6532 + 48945 * t6534 - 234195 * t6536 + 306605 * t6538 - 2145 * t6546 + 14495 * t6551 + 195 * t6553 - 143325 * t6555
            t6567 = 6720 * t6545 - 31584 * t6552 - 245952 * t6554 + 1689312 * t6556 - 3608640 * t6558 + 3276000 * t6560 - 1085760 * t6562 - 96
            t6566 = -650325 * t6532 + 2076555 * t6534 - 2498145 * t6536 + 1383519 * t6538 - 91 * t6546 + 1509 * t6551 + 23089 * t6553 - 336111 * t6555
            t6565 = 15416 * t6545 - 234884 * t6552 + 1344056 * t6554 - 3687084 * t6556 + 5235720 * t6558 - 3713580 * t6560 + 1040520 * t6562 - 164
            t6564 = -339300 * t6532 + 16380 * t6534 + 2222220 * t6536 - 3803604 * t6538 - 5532 * t6546 + 128772 * t6551 - 883596 * t6553 + 2664660 * t6555
            t6550 = 2 * phi1
            t6549 = 4 * phi1
            t6548 = -3 * phi2
            t6547 = 3 * phi2
            tfunc[..., c] = -(0.31e2 / 0.262144e6) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * ((t6568 + t6569) * np.exp((-6*1j) * (t6550 + phi2)) + (t6565 - t6566) * np.exp((-2*1j) * (t6550 + t6547)) + (t6564 + t6567) * np.exp((-2*1j) * (t6549 + t6547)) + (t6565 + t6566) * np.exp((2*1j) * (t6550 + t6548)) + (-t6564 + t6567) * np.exp((2*1j) * (t6549 + t6548)) + (-t6568 + t6569) * np.exp((6*1j) * (t6550 - phi2)))

        if Bindx == 196:
            t6591 = np.cos(phi)
            t6590 = t6591 ** 2
            t6597 = t6591 * t6590
            t6600 = t6597 ** 2
            t6601 = t6591 * t6600
            t6608 = t6601 ** 2
            t6577 = t6591 * t6608
            t6606 = t6600 ** 2
            t6579 = t6591 * t6606
            t6598 = t6590 ** 2
            t6599 = t6591 * t6598
            t6604 = t6599 ** 2
            t6581 = t6591 * t6604
            t6602 = t6598 ** 2
            t6583 = t6591 * t6602
            t6616 = -158340 * t6577 + 585780 * t6579 - 694980 * t6581 + 80340 * t6583 - 8580 * t6591 + 99060 * t6597 - 358020 * t6599 + 454740 * t6601
            t6576 = t6602 ** 2
            t6615 = 39585 * t6576 + 7020 * t6590 - 129480 * t6598 + 659100 * t6600 - 1435590 * t6602 + 1506180 * t6604 - 695760 * t6606 + 49140 * t6608 - 195
            t6614 = 3800160 * t6577 - 14807520 * t6579 + 22965600 * t6581 - 18033120 * t6583 - 6048 * t6591 + 170016 * t6597 - 1645728 * t6599 + 7556640 * t6601
            t6613 = -3641820 * t6577 + 14621100 * t6579 - 23668380 * t6581 + 19688460 * t6583 + 6436 * t6591 - 213780 * t6597 + 2064164 * t6599 - 8856180 * t6601
            t6612 = -2731365 * t6576 + 11300 * t6590 - 208280 * t6598 + 1596596 * t6600 - 6313890 * t6602 + 13835052 * t6604 - 16863600 * t6606 + 10674300 * t6608 - 113
            t6611 = -1425060 * t6576 - 95760 * t6590 + 1165920 * t6598 - 5280912 * t6600 + 11071704 * t6602 - 10525872 * t6604 + 2271360 * t6606 + 2817360 * t6608 + 1260
            t6596 = 4 * phi1
            t6595 = 8 * phi1
            t6594 = -5 * phi2
            t6593 = 5 * phi2
            t6592 = 12 * phi1
            tfunc[..., c] = (0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * ((t6612 + t6613) * np.exp((-1*1j) * (t6596 + t6593)) + (-t6611 + t6614) * np.exp((-1*1j) * (t6595 + t6593)) + (-t6612 + t6613) * np.exp((1j) * (t6596 + t6594)) + (t6611 + t6614) * np.exp((1j) * (t6595 + t6594)) + (-t6615 + t6616) * np.exp((-1*1j) * (t6592 + t6593)) + (t6615 + t6616) * np.exp((1j) * (t6592 + t6594))) * ((1 + t6591) ** (-0.1e1 / 0.2e1)) * ((1 - t6591) ** (-0.1e1 / 0.2e1))

        if Bindx == 197:
            t6637 = np.cos(phi)
            t6636 = t6637 ** 2
            t6641 = t6636 ** 2
            t6640 = t6637 * t6636
            t6643 = t6640 ** 2
            t6645 = t6641 ** 2
            t6642 = t6637 * t6641
            t6647 = t6642 ** 2
            t6649 = t6643 ** 2
            t6644 = t6637 * t6643
            t6651 = t6644 ** 2
            t6658 = 62400 * t6636 - 170040 * t6641 - 546000 * t6643 + 2691000 * t6645 - 3999840 * t6647 + 2597400 * t6649 - 633360 * t6651 - 1560
            t6623 = t6637 * t6651
            t6625 = t6637 * t6649
            t6627 = t6637 * t6647
            t6629 = t6637 * t6645
            t6657 = -197925 * t6623 + 214305 * t6625 + 1411995 * t6627 - 3861975 * t6629 - 29445 * t6637 + 407745 * t6640 - 1913925 * t6642 + 3969225 * t6644
            t6656 = -155584 * t6636 + 2590456 * t6641 - 15955632 * t6643 + 46384008 * t6645 - 68856480 * t6647 + 50554920 * t6649 - 14567280 * t6651 + 1496
            t6655 = 322560 * t6636 - 4363968 * t6641 + 23124864 * t6643 - 60373824 * t6645 + 82440960 * t6647 - 56347200 * t6649 + 15200640 * t6651 - 4032
            t6654 = -7125300 * t6623 + 18853380 * t6625 - 11536980 * t6627 - 9260412 * t6629 - 37044 * t6637 + 932484 * t6640 - 6029268 * t6642 + 14203140 * t6644
            t6653 = -13656825 * t6623 + 48944805 * t6625 - 70490745 * t6627 + 52191117 * t6629 + 12199 * t6637 - 426811 * t6640 + 4448807 * t6642 - 21026643 * t6644
            t6639 = 2 * phi1
            t6638 = 3 * phi1
            tfunc[..., c] = (0.31e2 / 0.262144e6) * np.sqrt(0.2e1) * np.sqrt(0.23e2) * ((t6653 + t6656) * np.exp((-4*1j) * (phi1 + phi2)) + (-t6654 + t6655) * np.exp((-4*1j) * (t6639 + phi2)) + (t6657 + t6658) * np.exp((-4*1j) * (t6638 + phi2)) + (-t6653 + t6656) * np.exp((4*1j) * (phi1 - phi2)) + (t6654 + t6655) * np.exp((4*1j) * (t6639 - phi2)) + (-t6657 + t6658) * np.exp((4*1j) * (t6638 - phi2)))

        if Bindx == 198:
            t6680 = np.cos(phi)
            t6679 = t6680 ** 2
            t6685 = t6680 * t6679
            t6688 = t6685 ** 2
            t6689 = t6680 * t6688
            t6696 = t6689 ** 2
            t6666 = t6680 * t6696
            t6694 = t6688 ** 2
            t6668 = t6680 * t6694
            t6686 = t6679 ** 2
            t6687 = t6680 * t6686
            t6692 = t6687 ** 2
            t6670 = t6680 * t6692
            t6690 = t6686 ** 2
            t6672 = t6680 * t6690
            t6704 = 158340 * t6666 - 839540 * t6668 + 1826500 * t6670 - 2081300 * t6672 - 3900 * t6680 + 67340 * t6685 - 436540 * t6687 + 1309100 * t6689
            t6665 = t6690 ** 2
            t6703 = 65975 * t6665 + 37180 * t6679 - 253760 * t6686 + 674700 * t6688 - 809250 * t6690 + 311220 * t6692 + 224120 * t6694 - 249340 * t6696 - 845
            t6702 = -2375100 * t6665 - 7056 * t6679 + 30912 * t6686 + 549360 * t6688 - 4270392 * t6690 + 11685072 * t6692 - 15244320 * t6694 + 9631440 * t6696 + 84
            t6701 = 3641820 * t6666 - 14334060 * t6668 + 22608540 * t6670 - 18182604 * t6672 - 4708 * t6680 + 168212 * t6685 - 1730916 * t6687 + 7833716 * t6689
            t6700 = -3800160 * t6666 + 16904160 * t6668 - 30492000 * t6670 + 28473312 * t6672 + 16800 * t6680 - 471072 * t6685 + 3892896 * t6687 - 14523936 * t6689
            t6699 = -4552275 * t6665 + 34452 * t6679 - 624448 * t6686 + 4404356 * t6688 - 15553494 * t6690 + 30338748 * t6692 - 33260760 * t6694 + 19213740 * t6696 - 319
            t6684 = 4 * phi1
            t6683 = 8 * phi1
            t6682 = -3 * phi2
            t6681 = 3 * phi2
            tfunc[..., c] = (-0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.23e2) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * ((1 + t6680) ** (-0.1e1 / 0.2e1)) * ((1 - t6680) ** (-0.1e1 / 0.2e1)) * ((t6703 + t6704) * np.exp((-3*1j) * (t6684 + phi2)) + (-t6699 + t6701) * np.exp((-1*1j) * (t6684 + t6681)) + (t6700 + t6702) * np.exp((-1*1j) * (t6683 + t6681)) + (t6699 + t6701) * np.exp((1j) * (t6684 + t6682)) + (t6700 - t6702) * np.exp((1j) * (t6683 + t6682)) + (-t6703 + t6704) * np.exp((3*1j) * (t6684 - phi2)))

        if Bindx == 199:
            t6725 = np.cos(phi)
            t6724 = t6725 ** 2
            t6729 = t6725 * t6724
            t6732 = t6729 ** 2
            t6733 = t6725 * t6732
            t6740 = t6733 ** 2
            t6711 = t6725 * t6740
            t6738 = t6732 ** 2
            t6713 = t6725 * t6738
            t6730 = t6724 ** 2
            t6731 = t6725 * t6730
            t6736 = t6731 ** 2
            t6715 = t6725 * t6736
            t6734 = t6730 ** 2
            t6717 = t6725 * t6734
            t6747 = -15225 * t6711 + 73815 * t6713 - 140325 * t6715 + 127275 * t6717 - 375 * t6725 + 4185 * t6729 - 75 * t6731 - 49275 * t6733
            t6746 = 8280 * t6724 - 63060 * t6730 + 197400 * t6732 - 318300 * t6734 + 280680 * t6736 - 129180 * t6738 + 24360 * t6740 - 180
            t6745 = 4840 * t6724 - 84876 * t6730 + 547624 * t6732 - 1656644 * t6734 + 2540120 * t6736 - 1911300 * t6738 + 560280 * t6740 - 44
            t6744 = -19264 * t6724 + 263648 * t6730 - 1332800 * t6732 + 3190432 * t6734 - 3926720 * t6736 + 2409120 * t6738 - 584640 * t6740 + 224
            t6743 = -548100 * t6711 + 2304540 * t6713 - 3894100 * t6715 + 3376268 * t6717 + 1540 * t6725 - 44828 * t6729 + 394324 * t6731 - 1589644 * t6733
            t6742 = -1050525 * t6711 + 4011315 * t6713 - 6142265 * t6715 + 4801687 * t6717 + 1133 * t6725 - 41283 * t6729 + 434313 * t6731 - 2014375 * t6733
            t6728 = 2 * phi1
            t6727 = 4 * phi1
            t6726 = 6 * phi1
            tfunc[..., c] = -(0.31e2 / 0.262144e6) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.19e2) * ((-t6742 + t6745) * np.exp((-2*1j) * (t6728 + phi2)) + (t6743 + t6744) * np.exp((-2*1j) * (t6727 + phi2)) + (t6746 - t6747) * np.exp((-2*1j) * (t6726 + phi2)) + (t6742 + t6745) * np.exp((2*1j) * (t6728 - phi2)) + (-t6743 + t6744) * np.exp((2*1j) * (t6727 - phi2)) + (t6746 + t6747) * np.exp((2*1j) * (t6726 - phi2)))

        if Bindx == 200:
            t6769 = np.cos(phi)
            t6768 = t6769 ** 2
            t6773 = t6769 * t6768
            t6776 = t6773 ** 2
            t6777 = t6769 * t6776
            t6784 = t6777 ** 2
            t6755 = t6769 * t6784
            t6782 = t6776 ** 2
            t6757 = t6769 * t6782
            t6774 = t6768 ** 2
            t6775 = t6769 * t6774
            t6780 = t6775 ** 2
            t6759 = t6769 * t6780
            t6778 = t6774 ** 2
            t6761 = t6769 * t6778
            t6792 = -1740 * t6755 + 10620 * t6757 - 27180 * t6759 + 37500 * t6761 + 180 * t6769 - 2820 * t6773 + 13140 * t6775 - 29700 * t6777
            t6754 = t6778 ** 2
            t6791 = -15 - 2175 * t6754 + 720 * t6768 - 6180 * t6774 + 22800 * t6776 - 45450 * t6778 + 53040 * t6780 - 36420 * t6782 + 13680 * t6784
            t6790 = -40020 * t6755 + 155940 * t6757 - 242420 * t6759 + 191268 * t6761 + 44 * t6769 - 1628 * t6773 + 17292 * t6775 - 80476 * t6777
            t6789 = 41760 * t6755 - 197280 * t6757 + 377120 * t6759 - 371104 * t6761 - 224 * t6769 + 6496 * t6773 - 53984 * t6775 + 197216 * t6777
            t6788 = 78300 * t6754 - 2464 * t6768 + 36176 * t6774 - 206304 * t6776 + 590056 * t6778 - 936032 * t6780 + 839120 * t6782 - 398880 * t6784 + 28
            t6787 = -150075 * t6754 + 1232 * t6768 - 22836 * t6774 + 162448 * t6776 - 571186 * t6778 + 1097008 * t6780 - 1173460 * t6782 + 656880 * t6784 - 11
            t6772 = 4 * phi1
            t6771 = 8 * phi1
            t6770 = 12 * phi1
            tfunc[..., c] = (0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * np.sqrt(0.323e3) * ((t6787 + t6790) * np.exp((-1*1j) * (t6772 + phi2)) + (t6788 + t6789) * np.exp((-1*1j) * (t6771 + phi2)) + (-t6787 + t6790) * np.exp((1j) * (t6772 - phi2)) + (-t6788 + t6789) * np.exp((1j) * (t6771 - phi2)) + (t6791 + t6792) * np.exp((-1*1j) * (t6770 + phi2)) + (-t6791 + t6792) * np.exp((1j) * (t6770 - phi2))) * ((1 + t6769) ** (-0.1e1 / 0.2e1)) * ((1 - t6769) ** (-0.1e1 / 0.2e1))

        if Bindx == 201:
            t6803 = np.cos(phi)
            t6802 = t6803 ** 2
            t6804 = t6802 ** 2
            t6805 = t6802 * t6804
            t6808 = t6805 ** 2
            t6806 = t6804 ** 2
            t6798 = t6802 * t6806
            t6796 = t6802 * t6808
            tfunc[..., c] = (0.93e2 / 0.65536e5*1j) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * t6803 * np.sqrt(0.2e1) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * np.sqrt(0.323e3) * ((10005 * t6796 - 38985 * t6808 + 60605 * t6798 - 47817 * t6806 + 20119 * t6805 - 4323 * t6804 + 407 * t6802 - 11) * np.sin((4 * phi1)) + (-5220 * t6796 + 24660 * t6808 - 47140 * t6798 + 46388 * t6806 - 24652 * t6805 + 6748 * t6804 - 812 * t6802 + 28) * np.sin((8 * phi1)) + (145 * t6796 - 885 * t6808 + 2265 * t6798 - 3125 * t6806 + 2475 * t6805 - 1095 * t6804 + 235 * t6802 - 15) * np.sin((12 * phi1)))

        if Bindx == 202:
            t6831 = np.cos(phi)
            t6830 = t6831 ** 2
            t6835 = t6831 * t6830
            t6838 = t6835 ** 2
            t6839 = t6831 * t6838
            t6846 = t6839 ** 2
            t6817 = t6831 * t6846
            t6844 = t6838 ** 2
            t6819 = t6831 * t6844
            t6836 = t6830 ** 2
            t6837 = t6831 * t6836
            t6842 = t6837 ** 2
            t6821 = t6831 * t6842
            t6840 = t6836 ** 2
            t6823 = t6831 * t6840
            t6854 = -1740 * t6817 + 10620 * t6819 - 27180 * t6821 + 37500 * t6823 + 180 * t6831 - 2820 * t6835 + 13140 * t6837 - 29700 * t6839
            t6816 = t6840 ** 2
            t6853 = 15 + 2175 * t6816 - 720 * t6830 + 6180 * t6836 - 22800 * t6838 + 45450 * t6840 - 53040 * t6842 + 36420 * t6844 - 13680 * t6846
            t6852 = -40020 * t6817 + 155940 * t6819 - 242420 * t6821 + 191268 * t6823 + 44 * t6831 - 1628 * t6835 + 17292 * t6837 - 80476 * t6839
            t6851 = 41760 * t6817 - 197280 * t6819 + 377120 * t6821 - 371104 * t6823 - 224 * t6831 + 6496 * t6835 - 53984 * t6837 + 197216 * t6839
            t6850 = 78300 * t6816 - 2464 * t6830 + 36176 * t6836 - 206304 * t6838 + 590056 * t6840 - 936032 * t6842 + 839120 * t6844 - 398880 * t6846 + 28
            t6849 = -150075 * t6816 + 1232 * t6830 - 22836 * t6836 + 162448 * t6838 - 571186 * t6840 + 1097008 * t6842 - 1173460 * t6844 + 656880 * t6846 - 11
            t6834 = 4 * phi1
            t6833 = 8 * phi1
            t6832 = 12 * phi1
            tfunc[..., c] = (-0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * np.sqrt(0.323e3) * ((1 + t6831) ** (-0.1e1 / 0.2e1)) * ((1 - t6831) ** (-0.1e1 / 0.2e1)) * ((-t6849 + t6852) * np.exp((-1*1j) * (t6834 - phi2)) + (-t6850 + t6851) * np.exp((-1*1j) * (t6833 - phi2)) + (t6849 + t6852) * np.exp((1j) * (t6834 + phi2)) + (t6850 + t6851) * np.exp((1j) * (t6833 + phi2)) + (t6853 + t6854) * np.exp((-1*1j) * (t6832 - phi2)) + (-t6853 + t6854) * np.exp((1j) * (t6832 + phi2)))

        if Bindx == 203:
            t6875 = np.cos(phi)
            t6874 = t6875 ** 2
            t6879 = t6875 * t6874
            t6882 = t6879 ** 2
            t6883 = t6875 * t6882
            t6890 = t6883 ** 2
            t6861 = t6875 * t6890
            t6888 = t6882 ** 2
            t6863 = t6875 * t6888
            t6880 = t6874 ** 2
            t6881 = t6875 * t6880
            t6886 = t6881 ** 2
            t6865 = t6875 * t6886
            t6884 = t6880 ** 2
            t6867 = t6875 * t6884
            t6897 = -15225 * t6861 + 73815 * t6863 - 140325 * t6865 + 127275 * t6867 - 375 * t6875 + 4185 * t6879 - 75 * t6881 - 49275 * t6883
            t6896 = -8280 * t6874 + 63060 * t6880 - 197400 * t6882 + 318300 * t6884 - 280680 * t6886 + 129180 * t6888 - 24360 * t6890 + 180
            t6895 = -4840 * t6874 + 84876 * t6880 - 547624 * t6882 + 1656644 * t6884 - 2540120 * t6886 + 1911300 * t6888 - 560280 * t6890 + 44
            t6894 = 19264 * t6874 - 263648 * t6880 + 1332800 * t6882 - 3190432 * t6884 + 3926720 * t6886 - 2409120 * t6888 + 584640 * t6890 - 224
            t6893 = -548100 * t6861 + 2304540 * t6863 - 3894100 * t6865 + 3376268 * t6867 + 1540 * t6875 - 44828 * t6879 + 394324 * t6881 - 1589644 * t6883
            t6892 = -1050525 * t6861 + 4011315 * t6863 - 6142265 * t6865 + 4801687 * t6867 + 1133 * t6875 - 41283 * t6879 + 434313 * t6881 - 2014375 * t6883
            t6878 = 2 * phi1
            t6877 = 4 * phi1
            t6876 = 6 * phi1
            tfunc[..., c] = -(0.31e2 / 0.262144e6) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.19e2) * ((-t6892 + t6895) * np.exp((-2*1j) * (t6878 - phi2)) + (t6893 + t6894) * np.exp((-2*1j) * (t6877 - phi2)) + (t6896 - t6897) * np.exp((-2*1j) * (t6876 - phi2)) + (t6892 + t6895) * np.exp((2*1j) * (t6878 + phi2)) + (-t6893 + t6894) * np.exp((2*1j) * (t6877 + phi2)) + (t6896 + t6897) * np.exp((2*1j) * (t6876 + phi2)))

        if Bindx == 204:
            t6919 = np.cos(phi)
            t6918 = t6919 ** 2
            t6924 = t6919 * t6918
            t6927 = t6924 ** 2
            t6928 = t6919 * t6927
            t6935 = t6928 ** 2
            t6905 = t6919 * t6935
            t6933 = t6927 ** 2
            t6907 = t6919 * t6933
            t6925 = t6918 ** 2
            t6926 = t6919 * t6925
            t6931 = t6926 ** 2
            t6909 = t6919 * t6931
            t6929 = t6925 ** 2
            t6911 = t6919 * t6929
            t6943 = 158340 * t6905 - 839540 * t6907 + 1826500 * t6909 - 2081300 * t6911 - 3900 * t6919 + 67340 * t6924 - 436540 * t6926 + 1309100 * t6928
            t6904 = t6929 ** 2
            t6942 = 65975 * t6904 + 37180 * t6918 - 253760 * t6925 + 674700 * t6927 - 809250 * t6929 + 311220 * t6931 + 224120 * t6933 - 249340 * t6935 - 845
            t6941 = -2375100 * t6904 - 7056 * t6918 + 30912 * t6925 + 549360 * t6927 - 4270392 * t6929 + 11685072 * t6931 - 15244320 * t6933 + 9631440 * t6935 + 84
            t6940 = 3641820 * t6905 - 14334060 * t6907 + 22608540 * t6909 - 18182604 * t6911 - 4708 * t6919 + 168212 * t6924 - 1730916 * t6926 + 7833716 * t6928
            t6939 = -3800160 * t6905 + 16904160 * t6907 - 30492000 * t6909 + 28473312 * t6911 + 16800 * t6919 - 471072 * t6924 + 3892896 * t6926 - 14523936 * t6928
            t6938 = -4552275 * t6904 + 34452 * t6918 - 624448 * t6925 + 4404356 * t6927 - 15553494 * t6929 + 30338748 * t6931 - 33260760 * t6933 + 19213740 * t6935 - 319
            t6923 = 4 * phi1
            t6922 = 8 * phi1
            t6921 = -3 * phi2
            t6920 = 3 * phi2
            tfunc[..., c] = (0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.23e2) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * ((-t6942 + t6943) * np.exp((-3*1j) * (t6923 - phi2)) + (t6938 + t6940) * np.exp((-1*1j) * (t6923 + t6921)) + (t6939 - t6941) * np.exp((-1*1j) * (t6922 + t6921)) + (-t6938 + t6940) * np.exp((1j) * (t6923 + t6920)) + (t6939 + t6941) * np.exp((1j) * (t6922 + t6920)) + (t6942 + t6943) * np.exp((3*1j) * (t6923 + phi2))) * ((1 + t6919) ** (-0.1e1 / 0.2e1)) * ((1 - t6919) ** (-0.1e1 / 0.2e1))

        if Bindx == 205:
            t6964 = np.cos(phi)
            t6963 = t6964 ** 2
            t6968 = t6963 ** 2
            t6967 = t6964 * t6963
            t6970 = t6967 ** 2
            t6972 = t6968 ** 2
            t6969 = t6964 * t6968
            t6974 = t6969 ** 2
            t6976 = t6970 ** 2
            t6971 = t6964 * t6970
            t6978 = t6971 ** 2
            t6985 = 62400 * t6963 - 170040 * t6968 - 546000 * t6970 + 2691000 * t6972 - 3999840 * t6974 + 2597400 * t6976 - 633360 * t6978 - 1560
            t6950 = t6964 * t6978
            t6952 = t6964 * t6976
            t6954 = t6964 * t6974
            t6956 = t6964 * t6972
            t6984 = -197925 * t6950 + 214305 * t6952 + 1411995 * t6954 - 3861975 * t6956 - 29445 * t6964 + 407745 * t6967 - 1913925 * t6969 + 3969225 * t6971
            t6983 = -155584 * t6963 + 2590456 * t6968 - 15955632 * t6970 + 46384008 * t6972 - 68856480 * t6974 + 50554920 * t6976 - 14567280 * t6978 + 1496
            t6982 = 322560 * t6963 - 4363968 * t6968 + 23124864 * t6970 - 60373824 * t6972 + 82440960 * t6974 - 56347200 * t6976 + 15200640 * t6978 - 4032
            t6981 = -7125300 * t6950 + 18853380 * t6952 - 11536980 * t6954 - 9260412 * t6956 - 37044 * t6964 + 932484 * t6967 - 6029268 * t6969 + 14203140 * t6971
            t6980 = -13656825 * t6950 + 48944805 * t6952 - 70490745 * t6954 + 52191117 * t6956 + 12199 * t6964 - 426811 * t6967 + 4448807 * t6969 - 21026643 * t6971
            t6966 = 2 * phi1
            t6965 = 3 * phi1
            tfunc[..., c] = -(0.31e2 / 0.262144e6) * np.sqrt(0.2e1) * np.sqrt(0.23e2) * ((-t6980 + t6983) * np.exp((-4*1j) * (phi1 - phi2)) + (t6981 + t6982) * np.exp((-4*1j) * (t6966 - phi2)) + (-t6984 + t6985) * np.exp((-4*1j) * (t6965 - phi2)) + (t6980 + t6983) * np.exp((4*1j) * (phi1 + phi2)) + (-t6981 + t6982) * np.exp((4*1j) * (t6966 + phi2)) + (t6984 + t6985) * np.exp((4*1j) * (t6965 + phi2)))

        if Bindx == 206:
            t7007 = np.cos(phi)
            t7006 = t7007 ** 2
            t7013 = t7007 * t7006
            t7016 = t7013 ** 2
            t7017 = t7007 * t7016
            t7024 = t7017 ** 2
            t6993 = t7007 * t7024
            t7022 = t7016 ** 2
            t6995 = t7007 * t7022
            t7014 = t7006 ** 2
            t7015 = t7007 * t7014
            t7020 = t7015 ** 2
            t6997 = t7007 * t7020
            t7018 = t7014 ** 2
            t6999 = t7007 * t7018
            t7032 = -158340 * t6993 + 585780 * t6995 - 694980 * t6997 + 80340 * t6999 - 8580 * t7007 + 99060 * t7013 - 358020 * t7015 + 454740 * t7017
            t6992 = t7018 ** 2
            t7031 = 39585 * t6992 + 7020 * t7006 - 129480 * t7014 + 659100 * t7016 - 1435590 * t7018 + 1506180 * t7020 - 695760 * t7022 + 49140 * t7024 - 195
            t7030 = 3800160 * t6993 - 14807520 * t6995 + 22965600 * t6997 - 18033120 * t6999 - 6048 * t7007 + 170016 * t7013 - 1645728 * t7015 + 7556640 * t7017
            t7029 = -3641820 * t6993 + 14621100 * t6995 - 23668380 * t6997 + 19688460 * t6999 + 6436 * t7007 - 213780 * t7013 + 2064164 * t7015 - 8856180 * t7017
            t7028 = -2731365 * t6992 + 11300 * t7006 - 208280 * t7014 + 1596596 * t7016 - 6313890 * t7018 + 13835052 * t7020 - 16863600 * t7022 + 10674300 * t7024 - 113
            t7027 = -1425060 * t6992 - 95760 * t7006 + 1165920 * t7014 - 5280912 * t7016 + 11071704 * t7018 - 10525872 * t7020 + 2271360 * t7022 + 2817360 * t7024 + 1260
            t7012 = 4 * phi1
            t7011 = 8 * phi1
            t7010 = -5 * phi2
            t7009 = 5 * phi2
            t7008 = 12 * phi1
            tfunc[..., c] = (-0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * ((1 + t7007) ** (-0.1e1 / 0.2e1)) * ((1 - t7007) ** (-0.1e1 / 0.2e1)) * ((-t7028 + t7029) * np.exp((-1*1j) * (t7012 + t7010)) + (t7027 + t7030) * np.exp((-1*1j) * (t7011 + t7010)) + (t7028 + t7029) * np.exp((1j) * (t7012 + t7009)) + (-t7027 + t7030) * np.exp((1j) * (t7011 + t7009)) + (t7031 + t7032) * np.exp((-1*1j) * (t7008 + t7010)) + (-t7031 + t7032) * np.exp((1j) * (t7008 + t7009)))

        if Bindx == 207:
            t7053 = np.cos(phi)
            t7052 = t7053 ** 2
            t7059 = t7052 ** 2
            t7058 = t7053 * t7052
            t7061 = t7058 ** 2
            t7063 = t7059 ** 2
            t7060 = t7053 * t7059
            t7065 = t7060 ** 2
            t7067 = t7061 ** 2
            t7062 = t7053 * t7061
            t7069 = t7062 ** 2
            t7076 = -7800 * t7052 + 64740 * t7059 - 190840 * t7061 + 212940 * t7063 - 29640 * t7065 - 94900 * t7067 + 45240 * t7069 + 260
            t7039 = t7053 * t7069
            t7041 = t7053 * t7067
            t7043 = t7053 * t7065
            t7045 = t7053 * t7063
            t7075 = 9425 * t7039 + 48945 * t7041 - 234195 * t7043 + 306605 * t7045 - 2145 * t7053 + 14495 * t7058 + 195 * t7060 - 143325 * t7062
            t7074 = 6720 * t7052 - 31584 * t7059 - 245952 * t7061 + 1689312 * t7063 - 3608640 * t7065 + 3276000 * t7067 - 1085760 * t7069 - 96
            t7073 = -650325 * t7039 + 2076555 * t7041 - 2498145 * t7043 + 1383519 * t7045 - 91 * t7053 + 1509 * t7058 + 23089 * t7060 - 336111 * t7062
            t7072 = 15416 * t7052 - 234884 * t7059 + 1344056 * t7061 - 3687084 * t7063 + 5235720 * t7065 - 3713580 * t7067 + 1040520 * t7069 - 164
            t7071 = -339300 * t7039 + 16380 * t7041 + 2222220 * t7043 - 3803604 * t7045 - 5532 * t7053 + 128772 * t7058 - 883596 * t7060 + 2664660 * t7062
            t7057 = 2 * phi1
            t7056 = 4 * phi1
            t7055 = -3 * phi2
            t7054 = 3 * phi2
            tfunc[..., c] = (0.31e2 / 0.262144e6) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.11e2) * ((-t7075 + t7076) * np.exp((-6*1j) * (t7057 - phi2)) + (t7072 + t7073) * np.exp((-2*1j) * (t7057 + t7055)) + (-t7071 + t7074) * np.exp((-2*1j) * (t7056 + t7055)) + (t7072 - t7073) * np.exp((2*1j) * (t7057 + t7054)) + (t7071 + t7074) * np.exp((2*1j) * (t7056 + t7054)) + (t7075 + t7076) * np.exp((6*1j) * (t7057 + phi2)))

        if Bindx == 208:
            t7098 = np.cos(phi)
            t7097 = t7098 ** 2
            t7104 = t7098 * t7097
            t7107 = t7104 ** 2
            t7108 = t7098 * t7107
            t7115 = t7108 ** 2
            t7084 = t7098 * t7115
            t7113 = t7107 ** 2
            t7086 = t7098 * t7113
            t7105 = t7097 ** 2
            t7106 = t7098 * t7105
            t7111 = t7106 ** 2
            t7088 = t7098 * t7111
            t7109 = t7105 ** 2
            t7090 = t7098 * t7109
            t7123 = -158340 * t7084 + 205140 * t7086 + 596700 * t7088 - 1467180 * t7090 + 3900 * t7098 + 17940 * t7104 - 339300 * t7106 + 1141140 * t7108
            t7083 = t7109 ** 2
            t7122 = -28275 * t7083 + 42120 * t7097 - 244140 * t7105 + 429000 * t7107 + 115830 * t7109 - 1046760 * t7111 + 982020 * t7113 - 248040 * t7115 - 1755
            t7121 = 3800160 * t7084 - 11662560 * t7086 + 11989600 * t7088 - 3012064 * t7090 + 19040 * t7098 - 376544 * t7104 + 1843296 * t7106 - 2600928 * t7108
            t7120 = -3641820 * t7084 + 15051660 * t7086 - 25166140 * t7088 + 21755148 * t7090 + 9828 * t7098 - 290612 * t7104 + 2562308 * t7106 - 10280372 * t7108
            t7119 = -1950975 * t7083 - 21912 * t7097 + 273188 * t7105 - 1015512 * t7107 + 653518 * t7109 + 3562424 * t7111 - 8210540 * t7113 + 6709560 * t7115 + 249
            t7118 = -1017900 * t7083 - 101632 * t7097 + 1259664 * t7105 - 6578880 * t7107 + 16803864 * t7109 - 21574784 * t7111 + 12368720 * t7113 - 1160640 * t7115 + 1588
            t7103 = 4 * phi1
            t7102 = 8 * phi1
            t7101 = -7 * phi2
            t7100 = 7 * phi2
            t7099 = 12 * phi1
            tfunc[..., c] = (-0.31e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * ((1 + t7098) ** (-0.1e1 / 0.2e1)) * ((1 - t7098) ** (-0.1e1 / 0.2e1)) * ((-t7119 + t7120) * np.exp((-1*1j) * (t7103 + t7101)) + (t7118 + t7121) * np.exp((-1*1j) * (t7102 + t7101)) + (t7119 + t7120) * np.exp((1j) * (t7103 + t7100)) + (-t7118 + t7121) * np.exp((1j) * (t7102 + t7100)) + (-t7122 + t7123) * np.exp((-1*1j) * (t7099 + t7101)) + (t7122 + t7123) * np.exp((1j) * (t7099 + t7100)))

        if Bindx == 209:
            t7144 = np.cos(phi)
            t7143 = t7144 ** 2
            t7148 = t7144 * t7143
            t7151 = t7148 ** 2
            t7152 = t7144 * t7151
            t7159 = t7152 ** 2
            t7130 = t7144 * t7159
            t7157 = t7151 ** 2
            t7132 = t7144 * t7157
            t7149 = t7143 ** 2
            t7150 = t7144 * t7149
            t7155 = t7150 ** 2
            t7134 = t7144 * t7155
            t7153 = t7149 ** 2
            t7136 = t7144 * t7153
            t7166 = -28275 * t7130 - 395265 * t7132 + 837525 * t7134 - 2145 * t7136 + 2925 * t7144 - 114465 * t7148 + 594165 * t7150 - 894465 * t7152
            t7165 = 49920 * t7143 - 115440 * t7149 - 343200 * t7151 + 1338480 * t7153 - 1235520 * t7155 + 127920 * t7157 + 180960 * t7159 - 3120
            t7164 = 88320 * t7143 - 1194896 * t7149 + 6331808 * t7151 - 16530928 * t7153 + 22573120 * t7155 - 15428400 * t7157 + 4162080 * t7159 - 1104
            t7163 = 222208 * t7143 - 1954176 * t7149 + 6209280 * t7151 - 6880896 * t7153 - 2168320 * t7155 + 8910720 * t7157 - 4343040 * t7159 - 3968
            t7162 = -1950975 * t7130 + 5162235 * t7132 - 3158935 * t7134 - 2535589 * t7136 - 10143 * t7144 + 255323 * t7148 - 1650871 * t7150 + 3888955 * t7152
            t7161 = -1017900 * t7130 - 3652740 * t7132 + 16225300 * t7134 - 19711076 * t7136 - 4780 * t7144 + 172284 * t7148 - 2288748 * t7150 + 10269468 * t7152
            t7147 = 3 * phi1
            t7146 = -2 * phi2
            t7145 = 2 * phi2
            tfunc[..., c] = (0.31e2 / 0.131072e6) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * ((-t7161 + t7163) * np.exp((-8*1j) * (phi1 - phi2)) + (t7162 + t7164) * np.exp((-4*1j) * (phi1 + t7146)) + (t7165 + t7166) * np.exp((-4*1j) * (t7147 + t7146)) + (-t7162 + t7164) * np.exp((4*1j) * (phi1 + t7145)) + (t7165 - t7166) * np.exp((4*1j) * (t7147 + t7145)) + (t7161 + t7163) * np.exp((8*1j) * (phi1 + phi2)))

        if Bindx == 210:
            t7188 = np.cos(phi)
            t7187 = t7188 ** 2
            t7194 = t7187 ** 2
            t7198 = t7194 ** 2
            t7173 = t7198 ** 2
            t7193 = t7188 * t7187
            t7196 = t7193 ** 2
            t7195 = t7188 * t7194
            t7200 = t7195 ** 2
            t7202 = t7196 ** 2
            t7197 = t7188 * t7196
            t7204 = t7197 ** 2
            t7212 = -65975 * t7173 - 92040 * t7187 - 337740 * t7194 + 2865720 * t7196 - 5049330 * t7198 + 1870440 * t7200 + 2038660 * t7202 - 1241240 * t7204 + 11505
            t7174 = t7188 * t7204
            t7176 = t7188 * t7202
            t7178 = t7188 * t7200
            t7180 = t7188 * t7198
            t7211 = -475020 * t7174 - 907140 * t7176 + 4685460 * t7178 - 4126980 * t7180 + 36660 * t7188 - 511940 * t7193 + 1536340 * t7195 - 237380 * t7197
            t7210 = -10925460 * t7174 + 46877220 * t7176 - 80974260 * t7178 + 71862948 * t7180 + 42412 * t7188 - 1076124 * t7193 + 8869260 * t7195 - 34675996 * t7197
            t7209 = 11400480 * t7174 - 22407840 * t7176 - 6179040 * t7178 + 45335136 * t7180 + 150304 * t7188 - 2620576 * t7193 + 15916320 * t7195 - 41594784 * t7197
            t7208 = -4552275 * t7173 - 349416 * t7187 + 3919108 * t7194 - 15865768 * t7196 + 28351686 * t7198 - 19359928 * t7200 - 4957420 * t7202 + 12809160 * t7204 + 4853
            t7207 = -2375100 * t7173 + 431424 * t7187 - 1683696 * t7194 - 5115264 * t7196 + 37361016 * t7198 - 71845312 * t7200 + 55815760 * t7202 - 12579840 * t7204 - 8988
            t7192 = 4 * phi1
            t7191 = 8 * phi1
            t7190 = -9 * phi2
            t7189 = 9 * phi2
            tfunc[..., c] = (-0.93e2 / 0.524288e6*1j) * np.sqrt(0.2e1) * ((1 + t7188) ** (-0.1e1 / 0.2e1)) * ((1 - t7188) ** (-0.1e1 / 0.2e1)) * ((t7211 - t7212) * np.exp((-3*1j) * (t7192 - 3 * phi2)) + (-t7208 + t7210) * np.exp((-1*1j) * (t7192 + t7190)) + (t7207 + t7209) * np.exp((-1*1j) * (t7191 + t7190)) + (t7208 + t7210) * np.exp((1j) * (t7192 + t7189)) + (-t7207 + t7209) * np.exp((1j) * (t7191 + t7189)) + (t7211 + t7212) * np.exp((3*1j) * (t7192 + 3 * phi2)))

        if Bindx == 211:
            t7233 = np.cos(phi)
            t7232 = t7233 ** 2
            t7239 = t7233 * t7232
            t7242 = t7239 ** 2
            t7243 = t7233 * t7242
            t7250 = t7243 ** 2
            t7219 = t7233 * t7250
            t7248 = t7242 ** 2
            t7221 = t7233 * t7248
            t7240 = t7232 ** 2
            t7241 = t7233 * t7240
            t7246 = t7241 ** 2
            t7223 = t7233 * t7246
            t7244 = t7240 ** 2
            t7225 = t7233 * t7244
            t7257 = -7917 * t7219 - 200109 * t7221 + 11271 * t7223 + 646503 * t7225 - 10179 * t7233 + 70941 * t7239 + 5577 * t7241 - 516087 * t7243
            t7256 = 4056 * t7232 - 158964 * t7240 + 408408 * t7242 - 46332 * t7244 - 545688 * t7246 + 273156 * t7248 + 63336 * t7250 + 2028
            t7255 = 28520 * t7232 - 394220 * t7240 + 2304232 * t7242 - 6282404 * t7244 + 8545880 * t7246 - 5658276 * t7248 + 1456728 * t7250 - 460
            t7254 = 59584 * t7232 - 895776 * t7240 + 4154304 * t7242 - 7488096 * t7244 + 4459840 * t7246 + 1231776 * t7248 - 1520064 * t7250 - 1568
            t7253 = -285012 * t7219 - 2355444 * t7221 + 6984796 * t7223 - 5422340 * t7225 + 39508 * t7233 - 445452 * t7239 + 1285284 * t7241 + 198660 * t7243
            t7252 = -546273 * t7219 + 1061151 * t7221 + 1026467 * t7223 - 4261693 * t7225 - 16399 * t7233 + 327313 * t7239 - 1815827 * t7241 + 4225261 * t7243
            t7238 = 2 * phi1
            t7237 = 4 * phi1
            t7236 = 6 * phi1
            t7235 = -5 * phi2
            t7234 = 5 * phi2
            tfunc[..., c] = (0.155e3 / 0.262144e6) * ((t7252 + t7255) * np.exp((-2*1j) * (t7238 + t7235)) + (-t7253 + t7254) * np.exp((-2*1j) * (t7237 + t7235)) + (t7256 + t7257) * np.exp((-2*1j) * (t7236 + t7235)) + (-t7252 + t7255) * np.exp((2*1j) * (t7238 + t7234)) + (t7253 + t7254) * np.exp((2*1j) * (t7237 + t7234)) + (t7256 - t7257) * np.exp((2*1j) * (t7236 + t7234))) * np.sqrt(0.3e1)

        if Bindx == 212:
            t7279 = np.cos(phi)
            t7278 = t7279 ** 2
            t7286 = t7278 ** 2
            t7290 = t7286 ** 2
            t7264 = t7290 ** 2
            t7285 = t7279 * t7278
            t7288 = t7285 ** 2
            t7287 = t7279 * t7286
            t7292 = t7287 ** 2
            t7294 = t7288 ** 2
            t7289 = t7279 * t7288
            t7296 = t7289 ** 2
            t7304 = 3045 * t7264 + 13068 * t7278 - 106392 * t7286 + 101244 * t7288 + 285714 * t7290 - 444444 * t7292 + 51168 * t7294 + 95508 * t7296 + 1089
            t7265 = t7279 * t7296
            t7267 = t7279 * t7294
            t7269 = t7279 * t7292
            t7271 = t7279 * t7290
            t7303 = -26796 * t7265 - 158532 * t7267 + 262548 * t7269 + 169884 * t7271 - 7212 * t7279 + 19068 * t7285 + 120276 * t7287 - 379236 * t7289
            t7302 = -616308 * t7265 + 2765796 * t7267 - 4907188 * t7269 + 4295940 * t7271 - 1012 * t7279 - 3036 * t7285 + 322828 * t7287 - 1857020 * t7289
            t7301 = 643104 * t7265 - 376992 * t7267 - 3161312 * t7269 + 5615456 * t7271 - 16352 * t7279 + 35168 * t7285 + 712992 * t7287 - 3452064 * t7289
            t7300 = -210105 * t7264 - 72956 * t7278 + 643448 * t7286 - 2285740 * t7288 + 3908390 * t7290 - 3170228 * t7292 + 758816 * t7294 + 426972 * t7296 + 1403
            t7299 = -109620 * t7264 + 112112 * t7278 - 805728 * t7286 + 1955184 * t7288 - 899976 * t7290 - 2748592 * t7292 + 3650752 * t7294 - 1150128 * t7296 - 4004
            t7284 = 4 * phi1
            t7283 = 8 * phi1
            t7282 = 12 * phi1
            t7281 = -11 * phi2
            t7280 = 11 * phi2
            tfunc[..., c] = (-0.31e2 / 0.524288e6*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * ((1 + t7279) ** (-0.1e1 / 0.2e1)) * ((1 - t7279) ** (-0.1e1 / 0.2e1)) * ((-t7300 + t7302) * np.exp((-1*1j) * (t7284 + t7281)) + (t7299 + t7301) * np.exp((-1*1j) * (t7283 + t7281)) + (t7300 + t7302) * np.exp((1j) * (t7284 + t7280)) + (-t7299 + t7301) * np.exp((1j) * (t7283 + t7280)) + (t7303 + t7304) * np.exp((-1*1j) * (t7282 + t7281)) + (t7303 - t7304) * np.exp((1j) * (t7282 + t7280)))

        if Bindx == 213:
            t7325 = np.cos(phi)
            t7324 = t7325 ** 2
            t7330 = t7324 ** 2
            t7329 = t7325 * t7324
            t7332 = t7329 ** 2
            t7334 = t7330 ** 2
            t7331 = t7325 * t7330
            t7336 = t7331 ** 2
            t7338 = t7332 ** 2
            t7333 = t7325 * t7332
            t7340 = t7333 ** 2
            t7347 = 11712 * t7324 - 30264 * t7330 - 80080 * t7332 + 175032 * t7334 + 13728 * t7336 - 84968 * t7338 - 9744 * t7340 + 488
            t7311 = t7325 * t7340
            t7313 = t7325 * t7338
            t7315 = t7325 * t7336
            t7317 = t7325 * t7334
            t7346 = 1015 * t7311 + 39669 * t7313 + 86775 * t7315 - 152867 * t7317 - 3945 * t7325 - 9451 * t7329 + 90519 * t7331 - 47619 * t7333
            t7345 = 22080 * t7324 - 60168 * t7330 - 193200 * t7332 + 952200 * t7334 - 1415328 * t7336 + 919080 * t7338 - 224112 * t7340 - 552
            t7344 = -36540 * t7311 - 510804 * t7313 + 1082340 * t7315 - 2772 * t7317 + 3780 * t7325 - 147924 * t7329 + 767844 * t7331 - 1155924 * t7333
            t7343 = 70035 * t7311 - 75831 * t7313 - 499629 * t7315 + 1366545 * t7317 + 10419 * t7325 - 144279 * t7329 + 677235 * t7331 - 1404495 * t7333
            t7342 = 64512 * t7324 - 149184 * t7330 - 443520 * t7332 + 1729728 * t7334 - 1596672 * t7336 + 165312 * t7338 + 233856 * t7340 - 4032
            t7328 = 2 * phi1
            t7327 = -3 * phi2
            t7326 = 3 * phi2
            tfunc[..., c] = -(0.31e2 / 0.262144e6) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * ((t7343 + t7345) * np.exp((-4*1j) * (phi1 + t7327)) + (t7342 + t7344) * np.exp((-4*1j) * (t7328 + t7327)) + (-t7343 + t7345) * np.exp((4*1j) * (phi1 + t7326)) + (t7342 - t7344) * np.exp((4*1j) * (t7328 + t7326)) + (t7346 + t7347) * np.exp((-12*1j) * (phi1 - phi2)) + (-t7346 + t7347) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 214:
            t7368 = np.cos(phi)
            t7367 = t7368 ** 2
            t7374 = t7368 * t7367
            t7377 = t7374 ** 2
            t7378 = t7368 * t7377
            t7385 = t7378 ** 2
            t7354 = t7368 * t7385
            t7389 = -91 - 145 * t7354
            t7388 = -1356 - 5220 * t7354
            t7387 = -391 - 10005 * t7354
            t7383 = t7377 ** 2
            t7375 = t7367 ** 2
            t7376 = t7368 * t7375
            t7381 = t7376 ** 2
            t7379 = t7375 ** 2
            t7373 = 4 * phi1
            t7372 = 8 * phi1
            t7371 = 12 * phi1
            t7370 = -13 * phi2
            t7369 = 13 * phi2
            t7360 = t7368 * t7379
            t7358 = t7368 * t7381
            t7356 = t7368 * t7383
            tfunc[..., c] = (0.31e2 / 0.524288e6*1j) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.3e1) * np.sqrt((1 - t7368)) * ((1 + t7368) ** (-0.1e1 / 0.2e1)) * ((-24679 * t7385 - 35627 * t7356 + 128225 * t7383 + 23897 * t7358 - 271331 * t7381 + 64745 * t7360 + 297045 * t7379 - 135585 * t7378 - 175605 * t7377 + 103615 * t7376 + 52739 * t7375 - 35213 * t7374 - 6785 * t7367 + 4163 * t7368 - t7387) * np.exp((-1*1j) * (t7373 + t7370)) + (30972 * t7385 - 56340 * t7356 - 17652 * t7383 + 184044 * t7358 - 170676 * t7381 - 128964 * t7360 + 302940 * t7379 - 79596 * t7378 - 171468 * t7377 + 126852 * t7376 + 17892 * t7375 - 44700 * t7374 + 9348 * t7367 + 3924 * t7368 + t7388) * np.exp((-1*1j) * (t7372 + t7370)) + (-44689 * t7385 - 33741 * t7356 + 130111 * t7383 + 234439 * t7358 - 60789 * t7381 - 396865 * t7360 - 164565 * t7379 + 268065 * t7378 + 228045 * t7377 - 51175 * t7376 - 102051 * t7375 - 14099 * t7374 + 14329 * t7367 + 3381 * t7368 + t7387) * np.exp((1j) * (t7373 + t7369)) + (41412 * t7385 + 128724 * t7356 + 167412 * t7383 - 34284 * t7358 - 389004 * t7381 - 430716 * t7360 + 1188 * t7379 + 383724 * t7378 + 291852 * t7377 - 6468 * t7376 - 115428 * t7375 - 52836 * t7374 + 1212 * t7367 + 6636 * t7368 - t7388) * np.exp((1j) * (t7372 + t7369)) + (-1363 * t7385 + 5369 * t7356 - 10803 * t7383 + 9061 * t7358 + 6721 * t7381 - 24739 * t7360 + 22737 * t7379 - 429 * t7378 - 17017 * t7377 + 14443 * t7376 - 2873 * t7375 - 3081 * t7374 + 2507 * t7367 - 769 * t7368 - t7389) * np.exp((-1*1j) * (t7371 + t7370)) + (-1653 * t7385 - 8385 * t7356 - 24557 * t7383 - 44421 * t7358 - 46761 * t7381 - 15301 * t7360 + 32175 * t7379 + 55341 * t7378 + 38753 * t7377 + 7293 * t7376 - 10023 * t7375 - 9815 * t7374 - 4227 * t7367 - 951 * t7368 + t7389) * np.exp((1j) * (t7371 + t7369)))

        if Bindx == 215:
            t7410 = np.cos(phi)
            t7409 = t7410 ** 2
            t7416 = t7410 * t7409
            t7419 = t7416 ** 2
            t7420 = t7410 * t7419
            t7427 = t7420 ** 2
            t7435 = -4 - 56 * t7427
            t7417 = t7409 ** 2
            t7421 = t7417 ** 2
            t7418 = t7410 * t7417
            t7423 = t7418 ** 2
            t7425 = t7419 ** 2
            t7434 = 56 * t7409 - 164 * t7417 + 120 * t7419 + 180 * t7421 - 376 * t7423 + 244 * t7425 + t7435
            t7396 = t7410 * t7427
            t7398 = t7410 * t7425
            t7400 = t7410 * t7423
            t7402 = t7410 * t7421
            t7433 = t7398 - 15 * t7396 + 221 * t7400 - 595 * t7402 - t7410 + 79 * t7416 - 365 * t7418 + 675 * t7420
            t7432 = -200 * t7409 - 676 * t7417 + 1144 * t7419 + 1716 * t7421 - 1144 * t7423 - 780 * t7425 + t7435
            t7431 = -5 * t7396 - 277 * t7398 - 1313 * t7400 + 143 * t7402 - 43 * t7410 - 507 * t7416 - 143 * t7418 + 2145 * t7420
            t7430 = 96 + 960 * t7409 - 6816 * t7417 + 6336 * t7419 + 9504 * t7421 - 14784 * t7423 + 3360 * t7425 + 1344 * t7427
            t7429 = -180 * t7396 - 3732 * t7398 + 5052 * t7400 + 9372 * t7402 - 588 * t7410 + 1428 * t7416 + 6468 * t7418 - 17820 * t7420
            t7415 = 2 * phi1
            t7414 = 4 * phi1
            t7413 = 6 * phi1
            t7412 = -7 * phi2
            t7411 = 7 * phi2
            tfunc[..., c] = -(0.31e2 / 0.262144e6) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.7e1) * np.sqrt(0.29e2) * ((t7429 + t7430) * np.exp((-2*1j) * (t7414 + t7412)) + (-t7431 + t7432) * np.exp((-2*1j) * (t7413 + t7412)) + (-t7429 + t7430) * np.exp((2*1j) * (t7414 + t7411)) + (t7431 + t7432) * np.exp((2*1j) * (t7413 + t7411)) + 23 * (-t7433 + t7434) * np.exp((-2*1j) * (t7415 + t7412)) + 23 * (t7433 + t7434) * np.exp((2*1j) * (t7415 + t7411)))

        if Bindx == 216:
            t7454 = np.cos(phi)
            t7453 = t7454 ** 2
            t7460 = t7453 ** 2
            t7461 = t7454 * t7460
            t7465 = t7461 ** 2
            t7445 = t7454 * t7465
            t7459 = t7454 * t7453
            t7478 = -4 * t7445 + 4 * t7459
            t7462 = t7459 ** 2
            t7467 = t7462 ** 2
            t7468 = t7454 * t7467
            t7477 = t7468 - t7454
            t7442 = t7454 * t7468
            t7476 = 1 - t7442
            t7463 = t7460 ** 2
            t7447 = t7454 * t7463
            t7475 = 20 * t7447 - 20 * t7461 + 4 * t7477 + 4 * t7478
            t7474 = 208 * t7445 + 572 * t7447 - 12 * t7454 - 208 * t7459 - 572 * t7461 + 12 * t7468
            t7473 = 3168 * t7447 - 3168 * t7461 - 288 * t7477 + 288 * t7478
            t7472 = t7453 - 19 * t7460 + 45 * t7462 - 45 * t7463 + 19 * t7465 - t7467 + t7476
            t7471 = 65 * t7453 + 429 * t7460 + 429 * t7462 - 429 * t7463 - 429 * t7465 - 65 * t7467 + t7476
            t7470 = 36 - 36 * t7442 + 900 * t7453 - 396 * t7460 - 3564 * t7462 + 3564 * t7463 + 396 * t7465 - 900 * t7467
            t7458 = 4 * phi1
            t7457 = 8 * phi1
            t7456 = -15 * phi2
            t7455 = 15 * phi2
            tfunc[..., c] = (-0.155e3 / 0.524288e6*1j) * np.sqrt((1 - t7454)) * np.sqrt((1 + t7454)) * np.sqrt(0.2e1) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * np.sqrt(0.29e2) * ((t7471 + t7474) * np.exp((-3*1j) * (t7458 - 5 * phi2)) + (-t7471 + t7474) * np.exp((3*1j) * (t7458 + 5 * phi2)) + (-t7470 + t7473) * np.exp((-1*1j) * (t7457 + t7456)) + (t7470 + t7473) * np.exp((1j) * (t7457 + t7455)) + 69 * (t7472 + t7475) * np.exp((-1*1j) * (t7458 + t7456)) + 69 * (-t7472 + t7475) * np.exp((1j) * (t7458 + t7455)))

        if Bindx == 217:
            t7501 = np.cos(phi)
            t7500 = t7501 ** 2
            t7505 = t7501 * t7500
            t7508 = t7505 ** 2
            t7509 = t7501 * t7508
            t7516 = t7509 ** 2
            t7487 = t7501 * t7516
            t7525 = -t7487 - t7501
            t7506 = t7500 ** 2
            t7510 = t7506 ** 2
            t7486 = t7510 ** 2
            t7514 = t7508 ** 2
            t7524 = 1 + t7486 + 64 * t7500 + 364 * t7506 - 858 * t7510 + 364 * t7514 + 64 * t7516
            t7507 = t7501 * t7506
            t7512 = t7507 ** 2
            t7523 = -49 - 49 * t7486 + 980 * t7506 - 3136 * t7508 + 4410 * t7510 - 3136 * t7512 + 980 * t7514
            t7489 = t7501 * t7514
            t7491 = t7501 * t7512
            t7493 = t7501 * t7510
            t7522 = -12 * t7487 - 196 * t7489 - 364 * t7491 + 572 * t7493 - 12 * t7501 - 196 * t7505 - 364 * t7507 + 572 * t7509
            t7521 = -240 * t7489 + 1200 * t7491 - 880 * t7493 - 240 * t7505 + 1200 * t7507 - 880 * t7509 + 80 * t7525
            t7520 = 980 * t7489 - 1764 * t7491 + 980 * t7493 + 980 * t7505 - 1764 * t7507 + 980 * t7509 + 196 * t7525
            t7519 = 10 + 10 * t7486 + 240 * t7500 - 360 * t7506 - 880 * t7508 + 1980 * t7510 - 880 * t7512 - 360 * t7514 + 240 * t7516
            t7504 = 3 * phi1
            t7503 = -4 * phi2
            t7502 = 4 * phi2
            tfunc[..., c] = -(0.33e2 / 0.59244544e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.23e2) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.899e3) * np.sqrt(0.5e1) * ((76 * t7486 - 608 * t7516 + 2128 * t7514 - 4256 * t7512 + 5320 * t7510 - 4256 * t7508 + 2128 * t7506 - 608 * t7500 + 76) * np.exp((-16*1j) * phi2) + (-t7522 + t7524) * np.exp((-4*1j) * (t7504 + t7502)) + (t7522 + t7524) * np.exp((4*1j) * (t7504 + t7503)) + (t7520 + t7523) * np.exp((-4*1j) * (phi1 + t7502)) + (-t7520 + t7523) * np.exp((4*1j) * (phi1 + t7503)) + (t7519 - t7521) * np.exp((-8*1j) * (phi1 + 2 * phi2)) + (t7519 + t7521) * np.exp((8*1j) * (phi1 - 2 * phi2)))

        if Bindx == 218:
            t7550 = np.cos(phi)
            t7549 = t7550 ** 2
            t7554 = t7550 * t7549
            t7557 = t7554 ** 2
            t7558 = t7550 * t7557
            t7565 = t7558 ** 2
            t7536 = t7550 * t7565
            t7578 = -t7536 - t7550
            t7563 = t7557 ** 2
            t7538 = t7550 * t7563
            t7582 = -t7538 - t7554
            t7555 = t7549 ** 2
            t7559 = t7555 ** 2
            t7542 = t7550 * t7559
            t7581 = -t7542 - t7558
            t7556 = t7550 * t7555
            t7561 = t7556 ** 2
            t7580 = t7561 + t7557
            t7579 = t7563 + t7555
            t7576 = t7581 + t7582
            t7535 = t7559 ** 2
            t7575 = 248 * t7535 + 15872 * t7549 + 90272 * t7555 - 212784 * t7559 + 90272 * t7563 + 15872 * t7565 + 248
            t7540 = t7550 * t7561
            t7574 = -56058912 * t7540 - 56058912 * t7556 + 6228768 * t7578
            t7573 = 2976 * t7536 + 48608 * t7538 + 90272 * t7540 + 2976 * t7550 + 48608 * t7554 + 90272 * t7556 + 141856 * t7581
            t7572 = 1557192 * t7535 - 140147280 * t7559 + 99660288 * t7580 + 1557192
            t7571 = -63280 * t7538 - 63280 * t7554 - 1292720 * t7542 - 1292720 * t7558 - 493584 * t7540 - 493584 * t7556 + 1808 * t7578
            t7570 = 113 * t7535 + 13560 * t7549 + 1454310 * t7559 + 13560 * t7565 + 205660 * t7579 + 904904 * t7580 + 113
            t7569 = 72540 * t7535 + 1740960 * t7549 + 14362920 * t7559 + 1740960 * t7565 - 2611440 * t7579 - 6383520 * t7580 + 72540
            t7568 = 8704800 * t7540 + 8704800 * t7556 + 6383520 * t7581 + 1740960 * t7582 + 580320 * t7578
            t7553 = 3 * phi1
            t7552 = -4 * phi2
            t7551 = 4 * phi2
            t7532 = np.exp((-4*1j) * (phi1 + t7551))
            t7530 = np.exp((4*1j) * (phi1 + t7552))
            tfunc[..., c] = (0.11e2 / 0.1895825408e10) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.29e2) * np.sqrt(0.113e3) * ((290176740 * t7559 + 4145382 * t7535 + 4145382 - 232141392 * t7561 - 232141392 * t7557 + 116070696 * t7563 + 116070696 * t7555 - 33163056 * t7565 - 33163056 * t7549) * np.exp((-16*1j) * phi2) + ((t7572 - t7574) * t7532) + ((t7572 + t7574) * t7530) + (t7573 + t7575) * np.exp((-4*1j) * (t7553 + t7551)) + (-t7573 + t7575) * np.exp((4*1j) * (t7553 + t7552)) + (-t7568 + t7569) * np.exp((-8*1j) * (phi1 + 2 * phi2)) + (t7568 + t7569) * np.exp((8*1j) * (phi1 - 2 * phi2)) + (t7570 - t7571) * np.exp((-16*1j) * (phi1 + phi2)) + (t7570 + t7571) * np.exp((16*1j) * (phi1 - phi2)) + (31143840 * (t7576 - t7579) * t7532) + (31143840 * (-t7576 - t7579) * t7530))

        if Bindx == 219:
            t7604 = np.cos(phi)
            t7603 = t7604 ** 2
            t7609 = t7604 * t7603
            t7612 = t7609 ** 2
            t7613 = t7604 * t7612
            t7620 = t7613 ** 2
            t7590 = t7604 * t7620
            t7625 = 4 * t7590
            t7624 = 40 * t7590
            t7623 = -196 * t7590
            t7622 = 49 - 637 * t7603 - 98 * t7604
            t7618 = t7612 ** 2
            t7610 = t7603 ** 2
            t7611 = t7604 * t7610
            t7616 = t7611 ** 2
            t7614 = t7610 ** 2
            t7608 = 4 * phi1
            t7607 = 8 * phi1
            t7606 = -15 * phi2
            t7605 = 15 * phi2
            t7596 = t7604 * t7614
            t7594 = t7604 * t7616
            t7592 = t7604 * t7618
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.899e3) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.23e2) * np.sqrt(0.113e3) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * ((1 + t7604) ** (0.3e1 / 0.2e1)) * ((1 - t7604) ** (-0.1e1 / 0.2e1)) * (304 * (t7590 - 2 * t7620 - 5 * t7592 + 12 * t7618 + 9 * t7594 - 30 * t7616 - 5 * t7596 + 40 * t7614 - 5 * t7613 - 30 * t7612 + 9 * t7611 + 12 * t7610 - 5 * t7609 - 2 * t7603 + t7604) * np.exp((-15*1j) * phi2) + (t7625 + 37 * t7620 + 142 * t7592 + 271 * t7618 + 184 * t7594 - 275 * t7616 - 726 * t7596 - 561 * t7614 + 132 * t7613 + 583 * t7612 + 418 * t7611 + 37 * t7610 - 128 * t7609 - 89 * t7603 - 26 * t7604 - 3) * np.exp((-3*1j) * (t7608 + 5 * phi2)) + (t7625 - 53 * t7620 + 322 * t7592 - 1183 * t7618 + 2912 * t7594 - 5005 * t7616 + 6006 * t7596 - 4719 * t7614 + 1716 * t7613 + 1001 * t7612 - 2002 * t7611 + 1547 * t7610 - 728 * t7609 + 217 * t7603 - 38 * t7604 + 3) * np.exp((3*1j) * (t7608 - 5 * phi2)) + (t7623 - 343 * t7620 + 1078 * t7592 + 2107 * t7618 - 2352 * t7594 - 5439 * t7616 + 2450 * t7596 + 7595 * t7614 - 980 * t7613 - 6125 * t7612 - 294 * t7611 + 2793 * t7610 + 392 * t7609 + t7622) * np.exp((-1*1j) * (t7608 + t7605)) + (t7624 + 220 * t7620 + 320 * t7592 - 380 * t7618 - 1480 * t7594 - 740 * t7616 + 1840 * t7596 + 2340 * t7614 - 360 * t7613 - 2060 * t7612 - 800 * t7611 + 620 * t7610 + 520 * t7609 + 20 * t7603 - 80 * t7604 - 20) * np.exp((-1*1j) * (t7607 + t7605)) + (t7623 + 1127 * t7620 - 1862 * t7592 - 1323 * t7618 + 7448 * t7594 - 5537 * t7616 - 7154 * t7596 + 12789 * t7614 - 1764 * t7613 - 8771 * t7612 + 5782 * t7611 + 1127 * t7610 - 2352 * t7609 - t7622) * np.exp((1j) * (t7608 + t7606)) + (t7624 - 380 * t7620 + 1520 * t7592 - 3140 * t7618 + 2840 * t7594 + 1540 * t7616 - 7040 * t7596 + 7260 * t7614 - 1320 * t7613 - 4180 * t7612 + 4400 * t7611 - 1580 * t7610 - 280 * t7609 + 460 * t7603 - 160 * t7604 + 20) * np.exp((1j) * (t7607 + t7606)))

        if Bindx == 220:
            t7650 = np.cos(phi)
            t7676 = 1 - t7650
            t7649 = t7650 ** 2
            t7657 = t7649 ** 2
            t7661 = t7657 ** 2
            t7635 = t7661 ** 2
            t7675 = 113 * t7635
            t7674 = 248 * t7635
            t7673 = 72540 * t7635
            t7672 = 1557192 * t7635
            t7642 = t7650 * t7661
            t7658 = t7650 * t7657
            t7656 = t7650 * t7649
            t7659 = t7656 ** 2
            t7663 = t7658 ** 2
            t7671 = 186 + 79794 * t7642 - 28210 * t7658 - 62062 * t7659 + 62062 * t7663
            t7665 = t7659 ** 2
            t7638 = t7650 * t7665
            t7660 = t7650 * t7659
            t7667 = t7660 ** 2
            t7670 = 25304370 * t7638 - 5839470 * t7649 + 5839470 * t7667 + 389298 * t7676
            t7655 = 4 * phi1
            t7654 = 8 * phi1
            t7653 = 16 * phi1
            t7652 = -15 * phi2
            t7651 = 15 * phi2
            t7640 = t7650 * t7663
            t7636 = t7650 * t7667
            tfunc[..., c] = (0.11e2 / 0.236978176e9*1j) * np.sqrt(0.113e3) * np.sqrt(0.29e2) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt((1 + t7650)) * t7676 ** (-0.1e1 / 0.2e1) * (4145382 * (-35 * t7663 + 35 * t7642 + 35 * t7661 - 35 * t7660 + 21 * t7665 - 21 * t7640 - 21 * t7659 + 21 * t7658 - 7 * t7667 + 7 * t7638 + 7 * t7657 - 7 * t7656 + t7635 - t7636 - t7649 + t7650) * np.exp((-15*1j) * phi2) + (t7675 + 1582 * t7636 + 10170 * t7667 + 39550 * t7638 - 39550 * t7656 - 10170 * t7649 - 1582 * t7650 - 113 + 226226 * t7663 - 226226 * t7659 + 185094 * t7640 - 185094 * t7658 + 161590 * t7642 - 161590 * t7660 + 102830 * t7665 - 102830 * t7657) * np.exp((-1*1j) * (t7653 + t7651)) + (t7674 + 2542 * t7636 + 11098 * t7667 + 25606 * t7638 + 28210 * t7665 - 5642 * t7640 - 26598 * t7661 + 44330 * t7660 - 5642 * t7657 - 13454 * t7656 - 7130 * t7649 - 1798 * t7650 - t7671) * np.exp((-3*1j) * (t7655 + 5 * phi2)) + (t7674 - 3038 * t7636 + 16678 * t7667 - 53382 * t7638 + 107198 * t7665 - 129766 * t7640 - 186186 * t7661 + 168454 * t7660 + 50778 * t7657 - 31682 * t7656 + 11098 * t7649 - 2170 * t7650 + t7671) * np.exp((3*1j) * (t7655 - 5 * phi2)) + (4282278 * t7636 + 61898382 * t7640 - 79806090 * t7642 + 1946490 * t7656 - 25304370 * t7657 - 19854198 * t7658 + 50998038 * t7659 + 56448210 * t7660 - 52555230 * t7661 + 23747178 * t7663 + 1946490 * t7665 - t7670 + t7672) * np.exp((-1*1j) * (t7655 + t7651)) + (471510 * t7636 - 108810 * t7638 - 4025970 * t7640 + 7580430 * t7642 - 108810 * t7649 - 181350 * t7650 + 979290 * t7656 + 2067390 * t7657 - 326430 * t7658 - 5186610 * t7659 - 4388670 * t7660 + 3590730 * t7661 + 1994850 * t7663 - 3373110 * t7665 + 979290 * t7667 + t7673 - 36270) * np.exp((-1*1j) * (t7654 + t7651)) + (-7396662 * t7636 - 15182622 * t7640 - 44769270 * t7642 + 13625430 * t7656 + 9732450 * t7657 - 54891018 * t7658 + 23747178 * t7659 + 83699070 * t7660 - 87592050 * t7661 + 100828182 * t7663 - 48662250 * t7665 + t7670 + t7672) * np.exp((1j) * (t7655 + t7652)) + (-616590 * t7636 - 2937870 * t7638 + 7943130 * t7640 + 398970 * t7642 + 544050 * t7649 - 253890 * t7650 + 326430 * t7656 - 3373110 * t7657 + 5114070 * t7658 + 398970 * t7659 - 9974250 * t7660 + 10772190 * t7661 - 9974250 * t7663 - 544050 * t7665 + 2067390 * t7667 + t7673 + 36270) * np.exp((1j) * (t7654 + t7652)) + (t7675 - 1808 * t7636 + 13560 * t7667 - 63280 * t7638 + 1454310 * t7661 - 63280 * t7656 + 13560 * t7649 - 1808 * t7650 + 113 - 1292720 * t7642 - 1292720 * t7660 + 904904 * t7663 + 904904 * t7659 - 493584 * t7640 - 493584 * t7658 + 205660 * t7665 + 205660 * t7657) * np.exp((1j) * (t7653 + t7652)))

        if Bindx == 221:
            t7699 = np.cos(phi)
            t7698 = t7699 ** 2
            t7705 = t7699 * t7698
            t7708 = t7705 ** 2
            t7709 = t7699 * t7708
            t7716 = t7709 ** 2
            t7685 = t7699 * t7716
            t7714 = t7708 ** 2
            t7687 = t7699 * t7714
            t7706 = t7698 ** 2
            t7707 = t7699 * t7706
            t7712 = t7707 ** 2
            t7689 = t7699 * t7712
            t7710 = t7706 ** 2
            t7691 = t7699 * t7710
            t7724 = -651 * t7685 - 7259 * t7687 - 2639 * t7689 + 20449 * t7691 + 315 * t7699 + 1771 * t7705 - 7553 * t7707 - 4433 * t7709
            t7723 = -4340 * t7685 - 5460 * t7687 + 43260 * t7689 - 49060 * t7691 + 500 * t7699 - 6060 * t7705 + 14340 * t7707 + 6820 * t7709
            t7722 = -10633 * t7685 + 49735 * t7687 - 88053 * t7689 + 66395 * t7691 - 1127 * t7699 + 9065 * t7705 - 17787 * t7707 - 7595 * t7709
            t7684 = t7710 ** 2
            t7721 = -34 + 62 * t7684 - 1156 * t7698 + 728 * t7706 + 12012 * t7708 - 12012 * t7710 - 12012 * t7712 + 9464 * t7714 + 2948 * t7716
            t7720 = -140 + 620 * t7684 + 840 * t7698 + 5880 * t7706 - 33880 * t7708 + 47520 * t7710 - 8360 * t7712 - 23160 * t7714 + 10680 * t7716
            t7719 = -3038 * t7684 - 2940 * t7698 + 25480 * t7706 - 83692 * t7708 + 132300 * t7710 - 104468 * t7712 + 33320 * t7714 + 2940 * t7716 + 98
            t7704 = 2 * phi1
            t7703 = 4 * phi1
            t7702 = 6 * phi1
            t7701 = -7 * phi2
            t7700 = 7 * phi2
            tfunc[..., c] = -(0.33e2 / 0.29622272e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.29e2) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * ((4712 * t7684 - 33136 * t7716 + 100016 * t7714 - 168112 * t7712 + 170240 * t7710 - 104272 * t7708 + 36176 * t7706 - 5776 * t7698 + 152) * np.exp((-14*1j) * phi2) + (t7719 + t7722) * np.exp((-2*1j) * (t7704 + t7700)) + (t7720 - t7723) * np.exp((-2*1j) * (t7703 + t7700)) + (t7721 - t7724) * np.exp((-2*1j) * (t7702 + t7700)) + (t7719 - t7722) * np.exp((2*1j) * (t7704 + t7701)) + (t7720 + t7723) * np.exp((2*1j) * (t7703 + t7701)) + (t7721 + t7724) * np.exp((2*1j) * (t7702 + t7701)))

        if Bindx == 222:
            t7749 = np.cos(phi)
            t7748 = t7749 ** 2
            t7756 = t7749 * t7748
            t7759 = t7756 ** 2
            t7760 = t7749 * t7759
            t7767 = t7760 ** 2
            t7735 = t7749 * t7767
            t7765 = t7759 ** 2
            t7737 = t7749 * t7765
            t7757 = t7748 ** 2
            t7758 = t7749 * t7757
            t7763 = t7758 ** 2
            t7739 = t7749 * t7763
            t7761 = t7757 ** 2
            t7741 = t7749 * t7761
            t7777 = -2604 * t7735 - 29036 * t7737 - 10556 * t7739 + 81796 * t7741 + 1260 * t7749 + 7084 * t7756 - 30212 * t7758 - 17732 * t7760
            t7734 = t7761 ** 2
            t7776 = -136 + 248 * t7734 - 4624 * t7748 + 2912 * t7757 + 48048 * t7759 - 48048 * t7761 - 48048 * t7763 + 37856 * t7765 + 11792 * t7767
            t7775 = 113 * t7734 - 10170 * t7748 + 10170 * t7767 - 113 + 226226 * t7763 - 226226 * t7759 + 102830 * t7765 - 102830 * t7757
            t7774 = -1582 * t7735 - 39550 * t7737 + 1582 * t7749 + 39550 * t7756 - 185094 * t7739 + 185094 * t7758 - 161590 * t7741 + 161590 * t7760
            t7773 = 72540 * t7734 + 98280 * t7748 + 687960 * t7757 - 3963960 * t7759 + 5559840 * t7761 - 978120 * t7763 - 2709720 * t7765 + 1249560 * t7767 - 16380
            t7772 = -507780 * t7735 - 638820 * t7737 + 5061420 * t7739 - 5740020 * t7741 + 58500 * t7749 - 709020 * t7756 + 1677780 * t7758 + 797940 * t7760
            t7771 = -5450172 * t7735 + 25492740 * t7737 - 45133452 * t7739 + 34032180 * t7741 - 577668 * t7749 + 4646460 * t7756 - 9117108 * t7758 - 3892980 * t7760
            t7770 = 1557192 * t7734 + 1506960 * t7748 - 13060320 * t7757 + 42898128 * t7759 - 67813200 * t7761 + 53547312 * t7763 - 17078880 * t7765 - 1506960 * t7767 - 50232
            t7755 = 2 * phi1
            t7754 = 4 * phi1
            t7753 = 6 * phi1
            t7752 = 8 * phi1
            t7751 = -7 * phi2
            t7750 = 7 * phi2
            tfunc[..., c] = (0.11e2 / 0.473956352e9) * np.sqrt(0.31e2) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.29e2) * np.sqrt(0.113e3) * ((4145382 * t7734 - 29151396 * t7767 + 87989076 * t7765 - 147896532 * t7763 + 149768640 * t7761 - 91733292 * t7759 + 31825836 * t7757 - 5081436 * t7748 + 133722) * np.exp((-14*1j) * phi2) + (-t7774 + t7775) * np.exp((-2*1j) * (t7752 + t7750)) + (t7774 + t7775) * np.exp((2*1j) * (t7752 + t7751)) + (t7770 - t7771) * np.exp((-2*1j) * (t7755 + t7750)) + (-t7772 + t7773) * np.exp((-2*1j) * (t7754 + t7750)) + (t7776 - t7777) * np.exp((-2*1j) * (t7753 + t7750)) + (t7770 + t7771) * np.exp((2*1j) * (t7755 + t7751)) + (t7772 + t7773) * np.exp((2*1j) * (t7754 + t7751)) + (t7776 + t7777) * np.exp((2*1j) * (t7753 + t7751)))

        if Bindx == 223:
            t7800 = np.cos(phi)
            t7799 = t7800 ** 2
            t7807 = t7799 ** 2
            t7811 = t7807 ** 2
            t7785 = t7811 ** 2
            t7822 = 620 * t7785
            t7821 = 6200 * t7785
            t7820 = -30380 * t7785
            t7806 = t7800 * t7799
            t7809 = t7806 ** 2
            t7810 = t7800 * t7809
            t7817 = t7810 ** 2
            t7815 = t7809 ** 2
            t7808 = t7800 * t7807
            t7813 = t7808 ** 2
            t7805 = 4 * phi1
            t7804 = 8 * phi1
            t7803 = 12 * phi1
            t7802 = -13 * phi2
            t7801 = 13 * phi2
            t7792 = t7800 * t7811
            t7790 = t7800 * t7813
            t7788 = t7800 * t7815
            t7786 = t7800 * t7817
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.29e2) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.113e3) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * np.sqrt((1 + t7800)) * ((1 - t7800) ** (-0.1e1 / 0.2e1)) * ((47120 * t7785 - 47120 * t7786 + 74480 * t7807 - 74480 * t7806 - 4560 * t7799 + 4560 * t7800 - 1010800 * t7813 + 1010800 * t7792 + 798000 * t7811 - 798000 * t7810 + 734160 * t7815 - 734160 * t7790 - 351120 * t7809 + 351120 * t7808 - 287280 * t7817 + 287280 * t7788) * np.exp((-13*1j) * phi2) + (t7820 - 68355 * t7786 + 126175 * t7817 + 370685 * t7788 - 161945 * t7815 - 831775 * t7790 - 19845 * t7813 + 991025 * t7792 + 238875 * t7811 - 667625 * t7810 - 232995 * t7809 + 249655 * t7808 + 94325 * t7807 - 47285 * t7806 - 14455 * t7799 + 3675 * t7800 + 245) * np.exp((-1*1j) * (t7805 + t7801)) + (t7821 + 34100 * t7786 + 50700 * t7817 - 51740 * t7788 - 213380 * t7815 - 109020 * t7790 + 250140 * t7813 + 306900 * t7792 - 61380 * t7811 - 260260 * t7810 - 74140 * t7809 + 89580 * t7808 + 51700 * t7807 - 9140 * t7806 - 10380 * t7799 - 420 * t7800 + 540) * np.exp((-1*1j) * (t7804 + t7801)) + (t7820 + 129115 * t7786 - 71295 * t7817 - 425565 * t7788 + 634305 * t7815 + 359415 * t7790 - 1211035 * t7813 + 239855 * t7792 + 990045 * t7811 - 561295 * t7810 - 339325 * t7809 + 322665 * t7808 + 21315 * t7807 - 68355 * t7806 + 6615 * t7799 + 4165 * t7800 - 245) * np.exp((1j) * (t7805 + t7802)) + (t7821 - 46500 * t7786 + 131300 * t7817 - 130260 * t7788 - 134860 * t7815 + 457260 * t7790 - 316140 * t7813 - 240900 * t7792 + 486420 * t7811 - 164780 * t7810 - 169620 * t7809 + 154180 * t7808 - 12900 * t7807 - 29660 * t7806 + 10140 * t7799 + 660 * t7800 - 540) * np.exp((1j) * (t7804 + t7802)) + (t7822 + 5425 * t7786 + 19155 * t7817 + 31129 * t7788 + 8099 * t7815 - 55419 * t7790 - 89089 * t7813 - 29315 * t7792 + 63063 * t7811 + 77363 * t7810 + 17017 * t7809 - 27573 * t7808 - 22295 * t7807 - 3241 * t7806 + 3189 * t7799 + 1631 * t7800 + 241) * np.exp((-1*1j) * (t7803 + t7801)) + (t7822 - 6665 * t7786 + 31245 * t7817 - 81529 * t7788 + 120757 * t7815 - 73437 * t7790 - 71071 * t7813 + 189475 * t7792 - 155727 * t7811 + 15301 * t7810 + 79079 * t7809 - 68523 * t7808 + 18655 * t7807 + 6881 * t7806 - 6933 * t7799 + 2113 * t7800 - 241) * np.exp((1j) * (t7803 + t7802)))

        if Bindx == 224:
            t7847 = np.cos(phi)
            t7846 = t7847 ** 2
            t7855 = t7846 ** 2
            t7859 = t7855 ** 2
            t7832 = t7859 ** 2
            t7871 = 565 * t7832
            t7870 = 1240 * t7832
            t7869 = 362700 * t7832
            t7868 = 7785960 * t7832
            t7854 = t7847 * t7846
            t7857 = t7854 ** 2
            t7858 = t7847 * t7857
            t7865 = t7858 ** 2
            t7863 = t7857 ** 2
            t7856 = t7847 * t7855
            t7861 = t7856 ** 2
            t7853 = 4 * phi1
            t7852 = 8 * phi1
            t7851 = 12 * phi1
            t7850 = 16 * phi1
            t7849 = -13 * phi2
            t7848 = 13 * phi2
            t7839 = t7847 * t7859
            t7837 = t7847 * t7861
            t7835 = t7847 * t7863
            t7833 = t7847 * t7865
            tfunc[..., c] = (0.11e2 / 0.236978176e9*1j) * np.sqrt(0.31e2) * np.sqrt(0.113e3) * np.sqrt(0.29e2) * np.sqrt(0.3e1) * np.sqrt((1 + t7847)) * ((1 - t7847) ** (-0.1e1 / 0.2e1)) * ((t7871 + 6780 * t7833 + 36160 * t7865 - 484770 * t7859 + 36160 * t7846 + 6780 * t7847 + 565 - 323180 * t7839 - 323180 * t7858 + 110740 * t7835 + 110740 * t7854 + 205660 * t7863 + 205660 * t7837 + 205660 * t7856 + 205660 * t7855) * np.exp((-1*1j) * (t7850 + t7848)) + (-444625650 * t7861 + 444625650 * t7839 + 351020250 * t7859 - 351020250 * t7858 + 322938630 * t7863 - 322938630 * t7837 - 154448910 * t7857 + 154448910 * t7856 - 126367290 * t7865 + 126367290 * t7835 + 32761890 * t7855 - 32761890 * t7854 + 20726910 * t7832 - 20726910 * t7833 - 2005830 * t7846 + 2005830 * t7847) * np.exp((-13*1j) * phi2) + (t7871 - 7910 * t7833 + 50850 * t7865 - 50850 * t7846 + 7910 * t7847 - 565 + 1131130 * t7861 - 1131130 * t7857 - 925470 * t7837 + 925470 * t7856 - 807950 * t7839 + 807950 * t7858 + 514150 * t7863 - 514150 * t7855 - 197750 * t7835 + 197750 * t7854) * np.exp((1j) * (t7850 + t7849)) + (17518410 * t7833 - 95001270 * t7835 + 213172050 * t7837 - 253985550 * t7839 + 3704610 * t7846 - 941850 * t7847 + 12118470 * t7854 - 24174150 * t7855 - 63983010 * t7856 + 59713290 * t7857 + 171102750 * t7858 - 61220250 * t7859 + 5085990 * t7861 + 41504190 * t7863 - 32336850 * t7865 + t7868 - 62790) * np.exp((-1*1j) * (t7853 + t7848)) + (1994850 * t7833 - 3026790 * t7835 - 6377670 * t7837 + 17953650 * t7839 - 607230 * t7846 - 24570 * t7847 - 534690 * t7854 + 3024450 * t7855 + 5240430 * t7856 - 4337190 * t7857 - 15225210 * t7858 - 3590730 * t7859 + 14633190 * t7861 - 12482730 * t7863 + 2965950 * t7865 + 31590 + t7869) * np.exp((-1*1j) * (t7852 + t7848)) + (-33090330 * t7833 + 109066230 * t7835 - 92112930 * t7837 - 61471410 * t7839 - 1695330 * t7846 - 1067430 * t7847 + 17518410 * t7854 - 5462730 * t7855 - 82694430 * t7856 + 86964150 * t7857 + 143851890 * t7858 - 253734390 * t7859 + 310370970 * t7861 - 162563310 * t7863 + 18271890 * t7865 + t7868 + 62790) * np.exp((1j) * (t7853 + t7849)) + (-2720250 * t7833 - 7620210 * t7835 + 26749710 * t7837 - 14092650 * t7839 + 593190 * t7846 + 38610 * t7847 - 1735110 * t7854 - 754650 * t7855 + 9019530 * t7856 - 9922770 * t7857 - 9639630 * t7858 + 28455570 * t7859 - 18494190 * t7861 - 7889310 * t7863 + 7681050 * t7865 - 31590 + t7869) * np.exp((1j) * (t7852 + t7849)) + (482 + t7870 + 10850 * t7833 + 38310 * t7865 + 62258 * t7835 + 16198 * t7863 - 110838 * t7837 - 178178 * t7861 - 58630 * t7839 + 126126 * t7859 + 154726 * t7858 + 34034 * t7857 - 55146 * t7856 - 44590 * t7855 - 6482 * t7854 + 6378 * t7846 + 3262 * t7847) * np.exp((-1*1j) * (t7851 + t7848)) + (-482 + t7870 - 13330 * t7833 + 62490 * t7865 - 163058 * t7835 + 241514 * t7863 - 146874 * t7837 - 142142 * t7861 + 378950 * t7839 - 311454 * t7859 + 30602 * t7858 + 158158 * t7857 - 137046 * t7856 + 37310 * t7855 + 13762 * t7854 - 13866 * t7846 + 4226 * t7847) * np.exp((1j) * (t7851 + t7849)))

        if Bindx == 225:
            t7894 = np.cos(phi)
            t7893 = t7894 ** 2
            t7898 = t7894 * t7893
            t7901 = t7898 ** 2
            t7902 = t7894 * t7901
            t7909 = t7902 ** 2
            t7880 = t7894 * t7909
            t7907 = t7901 ** 2
            t7882 = t7894 * t7907
            t7899 = t7893 ** 2
            t7900 = t7894 * t7899
            t7905 = t7900 ** 2
            t7884 = t7894 * t7905
            t7903 = t7899 ** 2
            t7886 = t7894 * t7903
            t7917 = -40455 * t7880 - 269381 * t7882 + 308217 * t7884 + 383955 * t7886 - 7303 * t7894 + 35259 * t7898 + 98553 * t7900 - 512941 * t7902
            t7916 = -269700 * t7880 + 67860 * t7882 + 1468380 * t7884 - 2280300 * t7886 + 6780 * t7894 - 34540 * t7898 - 170020 * t7900 + 1211540 * t7902
            t7915 = -660765 * t7880 + 2905945 * t7882 - 5004125 * t7884 + 4170145 * t7886 - 2205 * t7894 + 20825 * t7898 + 201635 * t7900 - 1631455 * t7902
            t7879 = t7903 ** 2
            t7914 = -4495 * t7879 - 9528 * t7893 + 129220 * t7899 - 216216 * t7901 - 265122 * t7903 + 664664 * t7905 - 151788 * t7907 - 149640 * t7909 - 1191
            t7913 = -44950 * t7879 + 35520 * t7893 - 299400 * t7899 + 855360 * t7901 - 642180 * t7903 - 855360 * t7905 + 1462520 * t7907 - 510400 * t7909 - 1110
            t7912 = 220255 * t7879 + 68600 * t7893 - 639940 * t7899 + 2381400 * t7901 - 4235070 * t7903 + 3592680 * t7905 - 988820 * t7907 - 397880 * t7909 - 1225
            t7897 = 2 * phi1
            t7896 = -3 * phi2
            t7895 = 3 * phi2
            tfunc[..., c] = (0.33e2 / 0.29622272e8) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * ((-1140 - 341620 * t7879 + 2115840 * t7909 - 5522160 * t7907 + 7831040 * t7905 - 6463800 * t7903 + 3064320 * t7901 - 755440 * t7899 + 72960 * t7893) * np.exp((-12*1j) * phi2) + (t7912 - t7915) * np.exp((-4*1j) * (phi1 + t7895)) + (t7913 + t7916) * np.exp((-4*1j) * (t7897 + t7895)) + (t7912 + t7915) * np.exp((4*1j) * (phi1 + t7896)) + (t7913 - t7916) * np.exp((4*1j) * (t7897 + t7896)) + (t7914 + t7917) * np.exp((-12*1j) * (phi1 + phi2)) + (t7914 - t7917) * np.exp((12*1j) * (phi1 - phi2)))

        if Bindx == 226:
            t7942 = np.cos(phi)
            t7941 = t7942 ** 2
            t7948 = t7941 ** 2
            t7952 = t7948 ** 2
            t7927 = t7952 ** 2
            t7947 = t7942 * t7941
            t7950 = t7947 ** 2
            t7956 = t7950 ** 2
            t7951 = t7942 * t7950
            t7958 = t7951 ** 2
            t7968 = 16385 * t7927 + 1048640 * t7941 + 5964140 * t7948 - 14058330 * t7952 + 5964140 * t7956 + 1048640 * t7958 + 16385
            t7949 = t7942 * t7948
            t7954 = t7949 ** 2
            t7967 = 35960 * t7927 + 76224 * t7941 - 1033760 * t7948 + 1729728 * t7950 + 2120976 * t7952 - 5317312 * t7954 + 1214304 * t7956 + 1197120 * t7958 + 9528
            t7928 = t7942 * t7958
            t7930 = t7942 * t7956
            t7932 = t7942 * t7954
            t7934 = t7942 * t7952
            t7966 = -323640 * t7928 - 2155048 * t7930 + 2465736 * t7932 + 3071640 * t7934 - 58424 * t7942 + 282072 * t7947 + 788424 * t7949 - 4103528 * t7951
            t7965 = 9372220 * t7934 + 9372220 * t7951 - 5964140 * t7932 - 5964140 * t7949 - 3211460 * t7930 - 3211460 * t7947 - 196620 * t7928 - 196620 * t7942
            t7964 = -63109800 * t7928 + 15879240 * t7930 + 343600920 * t7932 - 533590200 * t7934 + 1586520 * t7942 - 8082360 * t7947 - 39784680 * t7949 + 283500360 * t7951
            t7963 = -677378520 * t7928 + 2979008760 * t7930 - 5129943000 * t7932 + 4274994360 * t7934 - 2260440 * t7942 + 21348600 * t7947 + 206704680 * t7949 - 1672474440 * t7951
            t7962 = 10518300 * t7927 - 8311680 * t7941 + 70059600 * t7948 - 200154240 * t7950 + 150270120 * t7952 + 200154240 * t7954 - 342229680 * t7956 + 119433600 * t7958 + 259740
            t7961 = 225792840 * t7927 + 70324800 * t7941 - 656029920 * t7948 + 2441275200 * t7950 - 4341551760 * t7952 + 3683010240 * t7954 - 1013681760 * t7956 - 407883840 * t7958 - 1255800
            t7946 = 2 * phi1
            t7945 = 4 * phi1
            t7944 = -3 * phi2
            t7943 = 3 * phi2
            tfunc[..., c] = (0.11e2 / 0.473956352e9) * np.sqrt(0.3e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * ((601080390 * t7927 - 3722820480 * t7958 + 9716240520 * t7956 - 13778714880 * t7954 + 11373056100 * t7952 - 5391671040 * t7950 + 1329196680 * t7948 - 128373120 * t7941 + 2005830) * np.exp((-12*1j) * phi2) + (-t7965 + t7968) * np.exp((-4*1j) * (t7945 + t7943)) + (t7965 + t7968) * np.exp((4*1j) * (t7945 + t7944)) + (t7961 - t7963) * np.exp((-4*1j) * (phi1 + t7943)) + (t7962 - t7964) * np.exp((-4*1j) * (t7946 + t7943)) + (t7961 + t7963) * np.exp((4*1j) * (phi1 + t7944)) + (t7962 + t7964) * np.exp((4*1j) * (t7946 + t7944)) + (-t7966 + t7967) * np.exp((-12*1j) * (phi1 + phi2)) + (t7966 + t7967) * np.exp((12*1j) * (phi1 - phi2)))

        if Bindx == 227:
            t7992 = np.cos(phi)
            t7991 = t7992 ** 2
            t7999 = t7991 ** 2
            t8003 = t7999 ** 2
            t8011 = t8003 ** 2
            t7976 = t7992 * t8011
            t7998 = t7992 * t7991
            t8001 = t7998 ** 2
            t8002 = t7992 * t8001
            t8009 = t8002 ** 2
            t7978 = t7992 * t8009
            t8007 = t8001 ** 2
            t7980 = t7992 * t8007
            t8000 = t7992 * t7999
            t8005 = t8000 ** 2
            t7982 = t7992 * t8005
            t7984 = t7992 * t8003
            t8018 = 3596 * t7976 + 95236 * t7978 - 48132 * t7980 - 364156 * t7982 + 473044 * t7984 - 2640 * t7992 + 30668 * t7998 - 62348 * t8000 - 125268 * t8002
            t8017 = 2468 * t7991 + 43272 * t7999 - 224588 * t8001 + 286286 * t8003 + 94380 * t8005 - 354640 * t8007 + 123772 * t8009 + 29667 * t8011 - 617
            t8016 = -2640 * t7991 + 77920 * t7999 - 520400 * t8001 + 1390840 * t8003 - 1634160 * t8005 + 605440 * t8007 + 280720 * t8009 - 197780 * t8011 + 60
            t8015 = -5236 * t7991 + 93016 * t7999 - 696388 * t8001 + 2441978 * t8003 - 4485404 * t8005 + 4480784 * t8007 - 2313388 * t8009 + 484561 * t8011 + 77
            t8014 = 35960 * t7976 + 296960 * t7978 - 1191520 * t7980 + 1374720 * t7982 - 398640 * t7984 + 3960 * t7992 - 56320 * t7998 + 244640 * t8000 - 309760 * t8002
            t8013 = -176204 * t7976 + 471772 * t7978 + 186788 * t7980 - 2025380 * t7982 + 2969932 * t7984 + 4592 * t7992 - 102956 * t7998 + 677740 * t8000 - 2006284 * t8002
            t7997 = 4 * phi1
            t7996 = 8 * phi1
            t7995 = 12 * phi1
            t7994 = -11 * phi2
            t7993 = 11 * phi2
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.23e2) * np.sqrt(0.113e3) * np.sqrt(0.17e2) * np.sqrt(0.7e1) * np.sqrt(0.2e1) * ((1 + t7992) ** (-0.1e1 / 0.2e1)) * ((1 - t7992) ** (-0.1e1 / 0.2e1)) * ((273296 * t7976 - 1727936 * t7978 + 4632960 * t7980 - 6815680 * t7982 + 5931040 * t7984 - 3053376 * t8002 + 870656 * t8000 - 115520 * t7998 + 4560 * t7992) * np.exp((-11*1j) * phi2) + (t8013 - t8015) * np.exp((-1*1j) * (t7997 + t7993)) + (t8014 - t8016) * np.exp((-1*1j) * (t7996 + t7993)) + (t8013 + t8015) * np.exp((1j) * (t7997 + t7994)) + (t8014 + t8016) * np.exp((1j) * (t7996 + t7994)) + (t8017 + t8018) * np.exp((-1*1j) * (t7995 + t7993)) + (-t8017 + t8018) * np.exp((1j) * (t7995 + t7994)))

        if Bindx == 228:
            t8044 = np.cos(phi)
            t8043 = t8044 ** 2
            t8052 = t8043 ** 2
            t8051 = t8044 * t8043
            t8054 = t8051 ** 2
            t8056 = t8052 ** 2
            t8053 = t8044 * t8052
            t8058 = t8053 ** 2
            t8060 = t8054 ** 2
            t8055 = t8044 * t8054
            t8062 = t8055 ** 2
            t8064 = t8056 ** 2
            t8073 = 4936 * t8043 + 86544 * t8052 - 449176 * t8054 + 572572 * t8056 + 188760 * t8058 - 709280 * t8060 + 247544 * t8062 + 59334 * t8064 - 1234
            t8028 = t8044 * t8064
            t8030 = t8044 * t8062
            t8032 = t8044 * t8060
            t8034 = t8044 * t8058
            t8036 = t8044 * t8056
            t8072 = 7192 * t8028 + 190472 * t8030 - 96264 * t8032 - 728312 * t8034 + 946088 * t8036 - 5280 * t8044 + 61336 * t8051 - 124696 * t8053 - 250536 * t8055
            t8071 = -170404 * t8043 - 550536 * t8052 + 1192828 * t8054 + 937222 * t8056 - 1874444 * t8058 + 432564 * t8062 + 36047 * t8064 - 3277
            t8070 = 3277 * t8028 + 170404 * t8030 + 550536 * t8032 - 1192828 * t8034 - 937222 * t8036 - 36047 * t8044 - 432564 * t8051 + 1874444 * t8055
            t8069 = 154440 * t8043 - 4558320 * t8052 + 30443400 * t8054 - 81364140 * t8056 + 95598360 * t8058 - 35418240 * t8060 - 16422120 * t8062 + 11570130 * t8064 - 3510
            t8068 = 1341912 * t8043 - 23838672 * t8052 + 178474296 * t8054 - 625844076 * t8056 + 1149544968 * t8058 - 1148360928 * t8060 + 592888296 * t8062 - 124186062 * t8064 - 19734
            t8067 = 2103660 * t8028 + 17372160 * t8030 - 69703920 * t8032 + 80421120 * t8034 - 23320440 * t8036 + 231660 * t8044 - 3294720 * t8051 + 14311440 * t8053 - 18120960 * t8055
            t8066 = 45158568 * t8028 - 120908424 * t8030 - 47871096 * t8032 + 519075960 * t8034 - 761151144 * t8036 - 1176864 * t8044 + 26386152 * t8051 - 173695080 * t8053 + 514181928 * t8055
            t8050 = 4 * phi1
            t8049 = 8 * phi1
            t8048 = 12 * phi1
            t8047 = 16 * phi1
            t8046 = -11 * phi2
            t8045 = 11 * phi2
            tfunc[..., c] = (0.11e2 / 0.236978176e9*1j) * np.sqrt(0.7e1) * np.sqrt(0.31e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * ((1 + t8044) ** (-0.1e1 / 0.2e1)) * ((1 - t8044) ** (-0.1e1 / 0.2e1)) * ((120216078 * t8028 - 760075848 * t8030 + 2037923280 * t8032 - 2998047240 * t8034 + 2608916220 * t8036 - 1343103768 * t8055 + 382979808 * t8053 - 50814360 * t8051 + 2005830 * t8044) * np.exp((-11*1j) * phi2) + (t8070 + t8071) * np.exp((-1*1j) * (t8047 + t8045)) + (t8070 - t8071) * np.exp((1j) * (t8047 + t8046)) + (t8066 - t8068) * np.exp((-1*1j) * (t8050 + t8045)) + (t8067 + t8069) * np.exp((-1*1j) * (t8049 + t8045)) + (t8066 + t8068) * np.exp((1j) * (t8050 + t8046)) + (t8067 - t8069) * np.exp((1j) * (t8049 + t8046)) + (t8072 + t8073) * np.exp((-1*1j) * (t8048 + t8045)) + (t8072 - t8073) * np.exp((1j) * (t8048 + t8046)))

        if Bindx == 229:
            t8096 = np.cos(phi)
            t8095 = t8096 ** 2
            t8103 = t8095 ** 2
            t8107 = t8103 ** 2
            t8081 = t8107 ** 2
            t8102 = t8096 * t8095
            t8105 = t8102 ** 2
            t8104 = t8096 * t8103
            t8109 = t8104 ** 2
            t8111 = t8105 ** 2
            t8106 = t8096 * t8105
            t8113 = t8106 ** 2
            t8121 = 16182 * t8081 + 23436 * t8095 - 8424 * t8103 - 447876 * t8105 + 1189188 * t8107 - 787644 * t8109 - 326664 * t8111 + 343476 * t8113 - 1674
            t8082 = t8096 * t8113
            t8084 = t8096 * t8111
            t8086 = t8096 * t8109
            t8088 = t8096 * t8107
            t8120 = -121365 * t8082 - 346869 * t8084 + 1146015 * t8086 - 606177 * t8088 + 3429 * t8096 - 81819 * t8102 + 368433 * t8104 - 361647 * t8106
            t8119 = 161820 * t8081 - 31320 * t8095 + 190680 * t8103 - 88440 * t8105 - 1663200 * t8107 + 4298360 * t8109 - 3902040 * t8111 + 1033560 * t8113 + 580
            t8118 = -792918 * t8081 - 55692 * t8095 + 670152 * t8103 - 2900604 * t8105 + 5610780 * t8107 - 4516932 * t8109 - 10584 * t8111 + 1995084 * t8113 + 714
            t8117 = -809100 * t8082 + 1237140 * t8084 + 1213380 * t8086 - 3611740 * t8088 - 6260 * t8096 + 126060 * t8102 - 902340 * t8104 + 2752860 * t8106
            t8116 = -1982295 * t8082 + 8248905 * t8084 - 13703067 * t8086 + 11560101 * t8088 + 4935 * t8096 - 136185 * t8102 + 1229067 * t8104 - 5221461 * t8106
            t8101 = 2 * phi1
            t8100 = 4 * phi1
            t8099 = 6 * phi1
            t8098 = -5 * phi2
            t8097 = 5 * phi2
            tfunc[..., c] = -(0.11e2 / 0.29622272e8) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * ((760 - 4828432 * t8105 + 910480 * t8103 - 65360 * t8095 + 1229832 * t8081 - 6744240 * t8113 + 15335280 * t8111 - 18557680 * t8109 + 12719360 * t8107) * np.exp((-10*1j) * phi2) + (t8116 + t8118) * np.exp((-2*1j) * (t8101 + t8097)) + (-t8117 + t8119) * np.exp((-2*1j) * (t8100 + t8097)) + (-t8120 + t8121) * np.exp((-2*1j) * (t8099 + t8097)) + (-t8116 + t8118) * np.exp((2*1j) * (t8101 + t8098)) + (t8117 + t8119) * np.exp((2*1j) * (t8100 + t8098)) + (t8120 + t8121) * np.exp((2*1j) * (t8099 + t8098)))

        if Bindx == 230:
            t8146 = np.cos(phi)
            t8145 = t8146 ** 2
            t8153 = t8146 * t8145
            t8156 = t8153 ** 2
            t8157 = t8146 * t8156
            t8164 = t8157 ** 2
            t8132 = t8146 * t8164
            t8162 = t8156 ** 2
            t8134 = t8146 * t8162
            t8154 = t8145 ** 2
            t8155 = t8146 * t8154
            t8160 = t8155 ** 2
            t8136 = t8146 * t8160
            t8158 = t8154 ** 2
            t8138 = t8146 * t8158
            t8174 = -53940 * t8132 - 154164 * t8134 + 509340 * t8136 - 269412 * t8138 + 1524 * t8146 - 36364 * t8153 + 163748 * t8155 - 160732 * t8157
            t8131 = t8158 ** 2
            t8173 = 7192 * t8131 + 10416 * t8145 - 3744 * t8154 - 199056 * t8156 + 528528 * t8158 - 350064 * t8160 - 145184 * t8162 + 152656 * t8164 - 744
            t8172 = 3277 * t8131 - 3277 + 937222 * t8156 - 937222 * t8160 - 255606 * t8154 + 255606 * t8162 + 137634 * t8164 - 137634 * t8145
            t8171 = -32770 * t8132 + 32770 * t8146 + 937222 * t8138 - 937222 * t8157 - 294930 * t8134 + 294930 * t8153 + 255606 * t8136 - 255606 * t8155
            t8170 = -10518300 * t8132 + 16082820 * t8134 + 15773940 * t8136 - 46952620 * t8138 - 81380 * t8146 + 1638780 * t8153 - 11730420 * t8155 + 35787180 * t8157
            t8169 = -112896420 * t8132 + 469794780 * t8134 - 780422292 * t8136 + 658375276 * t8138 + 281060 * t8146 - 7756060 * t8153 + 69998292 * t8155 - 297374636 * t8157
            t8168 = 2103660 * t8131 - 407160 * t8145 + 2478840 * t8154 - 1149720 * t8156 - 21621600 * t8158 + 55878680 * t8160 - 50726520 * t8162 + 13436280 * t8164 + 7540
            t8167 = 45158568 * t8131 + 3171792 * t8145 - 38166752 * t8154 + 165196304 * t8156 - 319547280 * t8158 + 257250032 * t8160 + 602784 * t8162 - 113624784 * t8164 - 40664
            t8152 = 2 * phi1
            t8151 = 4 * phi1
            t8150 = 6 * phi1
            t8149 = 8 * phi1
            t8148 = -5 * phi2
            t8147 = 5 * phi2
            tfunc[..., c] = (0.33e2 / 0.473956352e9) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.7e1) * np.sqrt(0.31e2) * ((74290 + 120216078 * t8131 - 659249460 * t8164 + 1499023620 * t8162 - 1814013220 * t8160 + 1243317440 * t8158 - 471979228 * t8156 + 88999420 * t8154 - 6388940 * t8145) * np.exp((-10*1j) * phi2) + (-t8171 + t8172) * np.exp((-2*1j) * (t8149 + t8147)) + (t8171 + t8172) * np.exp((2*1j) * (t8149 + t8148)) + (t8167 - t8169) * np.exp((-2*1j) * (t8152 + t8147)) + (t8168 - t8170) * np.exp((-2*1j) * (t8151 + t8147)) + (t8173 - t8174) * np.exp((-2*1j) * (t8150 + t8147)) + (t8167 + t8169) * np.exp((2*1j) * (t8152 + t8148)) + (t8168 + t8170) * np.exp((2*1j) * (t8151 + t8148)) + (t8173 + t8174) * np.exp((2*1j) * (t8150 + t8148)))

        if Bindx == 231:
            t8198 = np.cos(phi)
            t8197 = t8198 ** 2
            t8204 = t8197 ** 2
            t8203 = t8198 * t8197
            t8206 = t8203 ** 2
            t8208 = t8204 ** 2
            t8205 = t8198 * t8204
            t8210 = t8205 ** 2
            t8212 = t8206 ** 2
            t8207 = t8198 * t8206
            t8214 = t8207 ** 2
            t8216 = t8208 ** 2
            t8223 = 564408 * t8197 - 3006900 * t8204 + 2683512 * t8206 + 13577850 * t8208 - 33575256 * t8210 + 24655644 * t8212 - 2035800 * t8214 - 2839941 * t8216 - 23517
            t8222 = 697600 * t8197 - 7675920 * t8204 + 33512640 * t8206 - 65998680 * t8208 + 47583360 * t8210 + 21818160 * t8212 - 48859200 * t8214 + 18932940 * t8216 - 10900
            t8182 = t8198 * t8216
            t8184 = t8198 * t8214
            t8186 = t8198 * t8212
            t8188 = t8198 * t8210
            t8190 = t8198 * t8208
            t8221 = 420732 * t8182 + 6528132 * t8184 - 16157700 * t8186 + 1919268 * t8188 + 22007700 * t8190 - 22464 * t8198 - 666900 * t8203 + 6990516 * t8205 - 21019284 * t8207
            t8220 = 685608 * t8197 - 10596348 * t8204 + 66588648 * t8206 - 215248866 * t8208 + 388443384 * t8210 - 394957836 * t8212 + 211478904 * t8214 - 46385703 * t8216 - 7791
            t8219 = 4207320 * t8182 + 15743520 * t8184 - 90417600 * t8186 + 142498720 * t8188 - 101815120 * t8190 + 18360 * t8198 - 130080 * t8203 - 4018560 * t8205 + 33913440 * t8207
            t8218 = -20615868 * t8182 + 68497884 * t8184 - 61159644 * t8186 - 35399364 * t8188 + 99922956 * t8190 + 98784 * t8198 - 2804172 * t8203 + 21869484 * t8205 - 70410060 * t8207
            t8202 = 4 * phi1
            t8201 = 8 * phi1
            t8200 = -9 * phi2
            t8199 = 9 * phi2
            tfunc[..., c] = (-0.11e2 / 0.59244544e8*1j) * np.sqrt(0.17e2) * np.sqrt(0.226e3) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * ((1 + t8198) ** (-0.1e1 / 0.2e1)) * ((1 - t8198) ** (-0.1e1 / 0.2e1)) * ((31975632 * t8182 - 181539072 * t8184 + 431795520 * t8186 - 555176960 * t8188 + 414525280 * t8190 - 179009792 * t8207 + 41717312 * t8205 - 4426240 * t8203 + 138320 * t8198) * np.exp((-9*1j) * phi2) + (t8221 - t8223) * np.exp((-3*1j) * (t8202 + 3 * phi2)) + (t8218 + t8220) * np.exp((-1*1j) * (t8202 + t8199)) + (t8219 + t8222) * np.exp((-1*1j) * (t8201 + t8199)) + (t8218 - t8220) * np.exp((1j) * (t8202 + t8200)) + (t8219 - t8222) * np.exp((1j) * (t8201 + t8200)) + (t8221 + t8223) * np.exp((3*1j) * (t8202 - 3 * phi2)))

        if Bindx == 232:
            t8249 = np.cos(phi)
            t8248 = t8249 ** 2
            t8256 = t8248 ** 2
            t8255 = t8249 * t8248
            t8258 = t8255 ** 2
            t8260 = t8256 ** 2
            t8257 = t8249 * t8256
            t8262 = t8257 ** 2
            t8264 = t8258 ** 2
            t8259 = t8249 * t8258
            t8266 = t8259 ** 2
            t8268 = t8260 ** 2
            t8277 = -9648 * t8248 + 51400 * t8256 - 45872 * t8258 - 232100 * t8260 + 573936 * t8262 - 421464 * t8264 + 34800 * t8266 + 48546 * t8268 + 402
            t8276 = -104864 * t8248 + 39324 * t8256 + 681616 * t8258 - 937222 * t8260 + 511212 * t8264 - 157296 * t8266 - 29493 * t8268 - 3277
            t8233 = t8249 * t8268
            t8235 = t8249 * t8266
            t8237 = t8249 * t8264
            t8239 = t8249 * t8262
            t8241 = t8249 * t8260
            t8275 = 3277 * t8233 + 104864 * t8235 - 39324 * t8237 - 681616 * t8239 + 937222 * t8241 + 29493 * t8249 + 157296 * t8255 - 511212 * t8257
            t8274 = 7192 * t8233 + 111592 * t8235 - 276200 * t8237 + 32808 * t8239 + 376200 * t8241 - 384 * t8249 - 11400 * t8255 + 119496 * t8257 - 359304 * t8259
            t8273 = 2103660 * t8233 + 7871760 * t8235 - 45208800 * t8237 + 71249360 * t8239 - 50907560 * t8241 + 9180 * t8249 - 65040 * t8255 - 2009280 * t8257 + 16956720 * t8259
            t8272 = -348800 * t8248 + 3837960 * t8256 - 16756320 * t8258 + 32999340 * t8260 - 23791680 * t8262 - 10909080 * t8264 + 24429600 * t8266 - 9466470 * t8268 + 5450
            t8271 = -1501808 * t8248 + 23211048 * t8256 - 145860848 * t8258 + 471497516 * t8260 - 850875984 * t8262 + 865145736 * t8264 - 463239504 * t8266 + 101606778 * t8268 + 17066
            t8270 = 45158568 * t8233 - 150042984 * t8235 + 133968744 * t8237 + 77541464 * t8239 - 218878856 * t8241 - 216384 * t8249 + 6142472 * t8255 - 47904584 * t8257 + 154231560 * t8259
            t8254 = 4 * phi1
            t8253 = 8 * phi1
            t8252 = -9 * phi2
            t8251 = 9 * phi2
            t8250 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.13e2) * ((1 + t8249) ** (-0.1e1 / 0.2e1)) * ((1 - t8249) ** (-0.1e1 / 0.2e1)) * ((120216078 * t8233 - 682517088 * t8235 + 1623385080 * t8237 - 2087251840 * t8239 + 1558455620 * t8241 - 673007968 * t8259 + 156841048 * t8257 - 16640960 * t8255 + 520030 * t8249) * np.exp((-9*1j) * phi2) + (t8275 - t8276) * np.exp((-1*1j) * (t8250 + t8251)) + (t8275 + t8276) * np.exp((1j) * (t8250 + t8252)) + (t8274 + t8277) * np.exp((-3*1j) * (t8254 + 3 * phi2)) + (t8270 + t8271) * np.exp((-1*1j) * (t8254 + t8251)) + (-t8272 + t8273) * np.exp((-1*1j) * (t8253 + t8251)) + (t8270 - t8271) * np.exp((1j) * (t8254 + t8252)) + (t8272 + t8273) * np.exp((1j) * (t8253 + t8252)) + (t8274 - t8277) * np.exp((3*1j) * (t8254 - 3 * phi2)))

        if Bindx == 233:
            t8300 = np.cos(phi)
            t8299 = t8300 ** 2
            t8304 = t8300 * t8299
            t8307 = t8304 ** 2
            t8308 = t8300 * t8307
            t8315 = t8308 ** 2
            t8286 = t8300 * t8315
            t8313 = t8307 ** 2
            t8288 = t8300 * t8313
            t8305 = t8299 ** 2
            t8306 = t8300 * t8305
            t8311 = t8306 ** 2
            t8290 = t8300 * t8311
            t8309 = t8305 ** 2
            t8292 = t8300 * t8309
            t8323 = -3155490 * t8286 + 793962 * t8288 + 17180046 * t8290 - 26679510 * t8292 + 79326 * t8300 - 404118 * t8304 - 1989234 * t8306 + 14175018 * t8308
            t8322 = -21036600 * t8286 + 54152280 * t8288 - 38034360 * t8290 - 10769000 * t8292 - 81464 * t8300 + 1854552 * t8304 - 11197368 * t8306 + 25095576 * t8308
            t8321 = -51539670 * t8286 + 204496110 * t8288 - 326265030 * t8290 + 267388590 * t8292 + 91434 * t8300 - 2931474 * t8304 + 27776826 * t8306 - 119016786 * t8308
            t8285 = t8309 ** 2
            t8320 = 525915 * t8285 - 415584 * t8299 + 3502980 * t8305 - 10007712 * t8307 + 7513506 * t8309 + 10007712 * t8311 - 17111484 * t8313 + 5971680 * t8315 + 12987
            t8319 = -25769835 * t8285 - 324576 * t8299 + 4565820 * t8305 - 20975136 * t8307 + 33747966 * t8309 + 7032480 * t8311 - 78083460 * t8313 + 79803360 * t8315 + 3381
            t8318 = 5259150 * t8285 + 247824 * t8299 - 3755640 * t8305 + 24131184 * t8307 - 73520172 * t8309 + 110430320 * t8311 - 74987640 * t8313 + 12214800 * t8315 - 3442
            t8303 = 3 * phi1
            t8302 = -2 * phi2
            t8301 = 2 * phi2
            tfunc[..., c] = -(0.11e2 / 0.29622272e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.23e2) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * ((243168536 * t8309 - 77625184 * t8307 + 12144496 * t8305 - 719264 * t8299 + 39969540 * t8285 - 195979680 * t8315 + 393559920 * t8313 - 414525280 * t8311 + 6916) * np.exp((-8*1j) * phi2) + (t8318 - t8322) * np.exp((-8*1j) * (phi1 + phi2)) + (t8319 + t8321) * np.exp((-4*1j) * (phi1 + t8301)) + (t8320 - t8323) * np.exp((-4*1j) * (t8303 + t8301)) + (t8319 - t8321) * np.exp((4*1j) * (phi1 + t8302)) + (t8320 + t8323) * np.exp((4*1j) * (t8303 + t8302)) + (t8318 + t8322) * np.exp((8*1j) * (phi1 - phi2)))

        if Bindx == 234:
            t8348 = np.cos(phi)
            t8347 = t8348 ** 2
            t8353 = t8348 * t8347
            t8356 = t8353 ** 2
            t8357 = t8348 * t8356
            t8364 = t8357 ** 2
            t8334 = t8348 * t8364
            t8362 = t8356 ** 2
            t8336 = t8348 * t8362
            t8354 = t8347 ** 2
            t8355 = t8348 * t8354
            t8360 = t8355 ** 2
            t8338 = t8348 * t8360
            t8358 = t8354 ** 2
            t8340 = t8348 * t8358
            t8374 = -215760 * t8334 + 54288 * t8336 + 1174704 * t8338 - 1824240 * t8340 + 5424 * t8348 - 27632 * t8353 - 136016 * t8355 + 969232 * t8357
            t8333 = t8358 ** 2
            t8373 = 35960 * t8333 - 28416 * t8347 + 239520 * t8354 + 513744 * t8358 - 1170016 * t8362 + 408320 * t8364 + 888 + 684288 * t8360 - 684288 * t8356
            t8372 = 16385 * t8333 + 3244230 * t8358 + 16385 - 1441880 * t8356 - 1441880 * t8360 - 589860 * t8362 - 589860 * t8354 + 393240 * t8347 + 393240 * t8364
            t8371 = 1966200 * t8338 + 1966200 * t8355 - 1441880 * t8340 - 1441880 * t8357 - 393240 * t8336 - 393240 * t8353 - 131080 * t8334 - 131080 * t8348
            t8370 = -42073200 * t8334 + 108304560 * t8336 - 76068720 * t8338 - 21538000 * t8340 - 162928 * t8348 + 3709104 * t8353 - 22394736 * t8355 + 50191152 * t8357
            t8369 = 10518300 * t8333 + 495648 * t8347 - 7511280 * t8354 + 48262368 * t8356 - 147040344 * t8358 + 220860640 * t8360 - 149975280 * t8362 + 24429600 * t8364 - 6884
            t8368 = -451585680 * t8334 + 1791775440 * t8336 - 2858703120 * t8338 + 2342833360 * t8340 + 801136 * t8348 - 25685296 * t8353 + 243377904 * t8355 - 1042813744 * t8357
            t8367 = 225792840 * t8333 + 2843904 * t8347 - 40005280 * t8354 + 183782144 * t8356 - 295696464 * t8358 - 61617920 * t8360 + 684159840 * t8362 - 699229440 * t8364 - 29624
            t8352 = 2 * phi1
            t8351 = 3 * phi1
            t8350 = -2 * phi2
            t8349 = 2 * phi2
            tfunc[..., c] = (0.33e2 / 0.947912704e9) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.13e2) * ((601080390 * t8333 - 2947232880 * t8364 + 5918535720 * t8362 - 6233822480 * t8360 + 3656880676 * t8358 - 1167363344 * t8356 + 182634536 * t8354 - 10816624 * t8347 + 104006) * np.exp((-8*1j) * phi2) + (t8369 - t8370) * np.exp((-8*1j) * (phi1 + phi2)) + (-t8371 + t8372) * np.exp((-8*1j) * (t8352 + phi2)) + (t8367 - t8368) * np.exp((-4*1j) * (phi1 + t8349)) + (t8373 - t8374) * np.exp((-4*1j) * (t8351 + t8349)) + (t8367 + t8368) * np.exp((4*1j) * (phi1 + t8350)) + (t8373 + t8374) * np.exp((4*1j) * (t8351 + t8350)) + (t8369 + t8370) * np.exp((8*1j) * (phi1 - phi2)) + (t8371 + t8372) * np.exp((8*1j) * (t8352 - phi2)))

        if Bindx == 235:
            t8398 = np.cos(phi)
            t8397 = t8398 ** 2
            t8405 = t8397 ** 2
            t8404 = t8398 * t8397
            t8407 = t8404 ** 2
            t8409 = t8405 ** 2
            t8406 = t8398 * t8405
            t8411 = t8406 ** 2
            t8413 = t8407 ** 2
            t8408 = t8398 * t8407
            t8415 = t8408 ** 2
            t8417 = t8409 ** 2
            t8424 = 170040 * t8397 - 2640924 * t8405 + 13620984 * t8407 - 30161274 * t8409 + 29024424 * t8411 - 6153420 * t8413 - 7536984 * t8415 + 3681405 * t8417 - 4251
            t8423 = 239680 * t8397 - 2574544 * t8405 + 7121408 * t8407 + 6378152 * t8409 - 62152640 * t8411 + 112585200 * t8413 - 86136960 * t8415 + 24542700 * t8417 - 2996
            t8422 = 606424 * t8397 - 10521868 * t8405 + 71006488 * t8407 - 240374498 * t8409 + 450355080 * t8411 - 474730620 * t8413 + 263794440 * t8415 - 60129615 * t8417 - 5831
            t8382 = t8398 * t8417
            t8384 = t8398 * t8415
            t8386 = t8398 * t8413
            t8388 = t8398 * t8411
            t8390 = t8398 * t8409
            t8421 = 7012200 * t8382 + 904800 * t8384 - 68752320 * t8386 + 143517920 * t8388 - 131487664 * t8390 - 65272 * t8398 + 1796512 * t8404 - 15524096 * t8406 + 62597920 * t8408
            t8420 = -34359780 * t8382 + 131897220 * t8384 - 194272260 * t8386 + 131591460 * t8388 - 33328428 * t8390 + 17248 * t8398 - 543508 * t8404 + 3862964 * t8406 - 4864916 * t8408
            t8419 = 701220 * t8382 + 4727580 * t8384 - 23128092 * t8386 + 32868732 * t8388 - 16667508 * t8390 + 104832 * t8398 - 1278732 * t8404 + 4345068 * t8406 - 1673100 * t8408
            t8403 = 4 * phi1
            t8402 = 8 * phi1
            t8401 = -7 * phi2
            t8400 = 7 * phi2
            t8399 = 12 * phi1
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * ((1 + t8398) ** (-0.1e1 / 0.2e1)) * ((1 - t8398) ** (-0.1e1 / 0.2e1)) * ((53292720 * t8382 - 275059200 * t8384 + 589717440 * t8386 - 676898560 * t8388 + 446441632 * t8390 - 168450048 * t8408 + 33971392 * t8406 - 3098368 * t8404 + 82992 * t8398) * np.exp((-7*1j) * phi2) + (t8420 + t8422) * np.exp((-1*1j) * (t8403 + t8400)) + (t8421 + t8423) * np.exp((-1*1j) * (t8402 + t8400)) + (t8420 - t8422) * np.exp((1j) * (t8403 + t8401)) + (t8421 - t8423) * np.exp((1j) * (t8402 + t8401)) + (t8419 + t8424) * np.exp((-1*1j) * (t8399 + t8400)) + (t8419 - t8424) * np.exp((1j) * (t8399 + t8401)))

        if Bindx == 236:
            t8450 = np.cos(phi)
            t8449 = t8450 ** 2
            t8458 = t8449 ** 2
            t8462 = t8458 ** 2
            t8470 = t8462 ** 2
            t8434 = t8450 * t8470
            t8457 = t8450 * t8449
            t8460 = t8457 ** 2
            t8461 = t8450 * t8460
            t8468 = t8461 ** 2
            t8436 = t8450 * t8468
            t8466 = t8460 ** 2
            t8438 = t8450 * t8466
            t8459 = t8450 * t8458
            t8464 = t8459 ** 2
            t8440 = t8450 * t8464
            t8442 = t8450 * t8462
            t8479 = 35960 * t8434 + 242440 * t8436 - 1186056 * t8438 + 1685576 * t8440 - 854744 * t8442 + 5376 * t8450 - 65576 * t8457 + 222824 * t8459 - 85800 * t8461
            t8478 = -262160 * t8449 + 983100 * t8458 - 524320 * t8460 - 1802350 * t8462 + 2883760 * t8464 - 1376340 * t8466 + 114695 * t8470 - 16385
            t8477 = 16385 * t8434 + 262160 * t8436 - 983100 * t8438 + 524320 * t8440 + 1802350 * t8442 - 114695 * t8450 + 1376340 * t8459 - 2883760 * t8461
            t8476 = 8720 * t8449 - 135432 * t8458 + 698512 * t8460 - 1546732 * t8462 + 1488432 * t8464 - 315560 * t8466 - 386512 * t8468 + 188790 * t8470 - 218
            t8475 = -359520 * t8449 + 3861816 * t8458 - 10682112 * t8460 - 9567228 * t8462 + 93228960 * t8464 - 168877800 * t8466 + 129205440 * t8468 - 36814050 * t8470 + 4494
            t8474 = 10518300 * t8434 + 1357200 * t8436 - 103128480 * t8438 + 215276880 * t8440 - 197231496 * t8442 - 97908 * t8450 + 2694768 * t8457 - 23286144 * t8459 + 93896880 * t8461
            t8473 = -3985072 * t8449 + 69143704 * t8458 - 466614064 * t8460 + 1579603844 * t8462 - 2959476240 * t8464 + 3119658360 * t8466 - 1733506320 * t8468 + 395137470 * t8470 + 38318
            t8472 = 225792840 * t8434 - 866753160 * t8436 + 1276646280 * t8438 - 864743880 * t8440 + 219015384 * t8442 - 113344 * t8450 + 3571624 * t8457 - 25385192 * t8459 + 31969448 * t8461
            t8456 = 4 * phi1
            t8455 = 8 * phi1
            t8454 = -7 * phi2
            t8453 = 7 * phi2
            t8452 = 12 * phi1
            t8451 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.13e2) * ((1 + t8450) ** (-0.1e1 / 0.2e1)) * ((1 - t8450) ** (-0.1e1 / 0.2e1)) * ((601080390 * t8434 - 3102350400 * t8436 + 6651332280 * t8438 - 7634634720 * t8440 + 5035346484 * t8442 - 1899922176 * t8461 + 383158104 * t8459 - 34946016 * t8457 + 936054 * t8450) * np.exp((-7*1j) * phi2) + (t8477 + t8478) * np.exp((-1*1j) * (t8451 + t8453)) + (t8477 - t8478) * np.exp((1j) * (t8451 + t8454)) + (t8472 + t8473) * np.exp((-1*1j) * (t8456 + t8453)) + (t8474 - t8475) * np.exp((-1*1j) * (t8455 + t8453)) + (t8472 - t8473) * np.exp((1j) * (t8456 + t8454)) + (t8474 + t8475) * np.exp((1j) * (t8455 + t8454)) + (t8476 + t8479) * np.exp((-1*1j) * (t8452 + t8453)) + (-t8476 + t8479) * np.exp((1j) * (t8452 + t8454)))

        if Bindx == 237:
            t8502 = np.cos(phi)
            t8501 = t8502 ** 2
            t8507 = t8502 * t8501
            t8510 = t8507 ** 2
            t8511 = t8502 * t8510
            t8518 = t8511 ** 2
            t8488 = t8502 * t8518
            t8516 = t8510 ** 2
            t8490 = t8502 * t8516
            t8508 = t8501 ** 2
            t8509 = t8502 * t8508
            t8514 = t8509 ** 2
            t8492 = t8502 * t8514
            t8512 = t8508 ** 2
            t8494 = t8502 * t8512
            t8526 = -241920900 * t8488 + 819409500 * t8490 - 1071825300 * t8492 + 674978700 * t8494 + 12420 * t8502 - 1065820 * t8507 + 26793620 * t8509 - 206382220 * t8511
            t8525 = 36288135 * t8488 - 96898425 * t8490 + 39248235 * t8492 + 111151755 * t8494 + 811785 * t8502 - 12822615 * t8507 + 67315365 * t8509 - 145094235 * t8511
            t8487 = t8512 ** 2
            t8524 = 8064030 * t8487 - 1237860 * t8501 - 466440 * t8508 + 51505740 * t8510 - 193590540 * t8512 + 286340340 * t8514 - 180297000 * t8516 + 29654820 * t8518 + 26910
            t8523 = -592706205 * t8488 + 2262480675 * t8490 - 3468111465 * t8492 + 2719929975 * t8494 + 658413 * t8502 - 23898035 * t8507 + 249456697 * t8509 - 1147810055 * t8511
            t8522 = 80640300 * t8487 + 3837320 * t8501 - 53355400 * t8508 + 279605480 * t8510 - 693462880 * t8512 + 833432600 * t8514 - 383019000 * t8516 - 67633800 * t8518 - 44620
            t8521 = -395137470 * t8487 + 334180 * t8501 - 8606360 * t8508 + 95133108 * t8510 - 503971860 * t8512 + 1370454540 * t8514 - 1960303800 * t8516 + 1402100700 * t8518 - 3038
            t8506 = 2 * phi1
            t8505 = 4 * phi1
            t8504 = -3 * phi2
            t8503 = 3 * phi2
            tfunc[..., c] = -(0.33e2 / 0.29622272e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * ((612866280 * t8487 - 2728243440 * t8518 + 4937016240 * t8516 - 4649784880 * t8514 + 2421469440 * t8512 - 682443216 * t8510 + 93974608 * t8508 - 4896528 * t8501 + 41496) * np.exp((-6*1j) * phi2) + (t8524 + t8525) * np.exp((-6*1j) * (t8506 + phi2)) + (t8521 + t8523) * np.exp((-2*1j) * (t8506 + t8503)) + (t8522 - t8526) * np.exp((-2*1j) * (t8505 + t8503)) + (t8521 - t8523) * np.exp((2*1j) * (t8506 + t8504)) + (t8522 + t8526) * np.exp((2*1j) * (t8505 + t8504)) + (t8524 - t8525) * np.exp((6*1j) * (t8506 - phi2)))

        if Bindx == 238:
            t8551 = np.cos(phi)
            t8550 = t8551 ** 2
            t8558 = t8550 ** 2
            t8562 = t8558 ** 2
            t8536 = t8562 ** 2
            t8557 = t8551 * t8550
            t8560 = t8557 ** 2
            t8559 = t8551 * t8558
            t8564 = t8559 ** 2
            t8566 = t8560 ** 2
            t8561 = t8551 * t8560
            t8568 = t8561 ** 2
            t8578 = 35960 * t8536 - 5520 * t8550 - 2080 * t8558 + 229680 * t8560 - 863280 * t8562 + 1276880 * t8564 - 804000 * t8566 + 132240 * t8568 + 120
            t8577 = 16385 * t8536 - 16385 + 1081410 * t8564 - 1081410 * t8560 - 819250 * t8566 + 819250 * t8558 - 163850 * t8550 + 163850 * t8568
            t8537 = t8551 * t8568
            t8539 = t8551 * t8566
            t8541 = t8551 * t8564
            t8543 = t8551 * t8562
            t8576 = -161820 * t8537 + 432100 * t8539 - 175020 * t8541 - 495660 * t8543 - 3620 * t8551 + 57180 * t8557 - 300180 * t8559 + 647020 * t8561
            t8575 = 98310 * t8537 - 98310 * t8551 + 1802350 * t8543 - 1802350 * t8561 - 557090 * t8541 + 557090 * t8559 - 163850 * t8539 + 163850 * t8557
            t8574 = -31554900 * t8537 + 106879500 * t8539 - 139803300 * t8541 + 88040700 * t8543 + 1620 * t8551 - 139020 * t8557 + 3494820 * t8559 - 26919420 * t8561
            t8573 = 10518300 * t8536 + 500520 * t8550 - 6959400 * t8558 + 36470280 * t8560 - 90451680 * t8562 + 108708600 * t8564 - 49959000 * t8566 - 8821800 * t8568 - 5820
            t8572 = -338689260 * t8537 + 1292846100 * t8539 - 1981777980 * t8541 + 1554245700 * t8543 + 376236 * t8551 - 13656020 * t8557 + 142546684 * t8559 - 655891460 * t8561
            t8571 = 225792840 * t8536 - 190960 * t8550 + 4917920 * t8558 - 54361776 * t8560 + 287983920 * t8562 - 783116880 * t8564 + 1120173600 * t8566 - 801200400 * t8568 + 1736
            t8556 = 2 * phi1
            t8555 = 4 * phi1
            t8554 = 8 * phi1
            t8553 = -3 * phi2
            t8552 = 3 * phi2
            tfunc[..., c] = (0.33e2 / 0.473956352e9) * np.sqrt(0.2e1) * np.sqrt(0.113e3) * np.sqrt(0.23e2) * np.sqrt(0.31e2) * np.sqrt(0.13e2) * ((601080390 * t8536 - 2675777220 * t8568 + 4842073620 * t8566 - 4560365940 * t8564 + 2374902720 * t8562 - 669319308 * t8560 + 92167404 * t8558 - 4802364 * t8550 + 40698) * np.exp((-6*1j) * phi2) + (t8575 + t8577) * np.exp((-2*1j) * (t8554 + t8552)) + (-t8575 + t8577) * np.exp((2*1j) * (t8554 + t8553)) + (-t8576 + t8578) * np.exp((-6*1j) * (t8556 + phi2)) + (t8571 - t8572) * np.exp((-2*1j) * (t8556 + t8552)) + (t8573 - t8574) * np.exp((-2*1j) * (t8555 + t8552)) + (t8571 + t8572) * np.exp((2*1j) * (t8556 + t8553)) + (t8573 + t8574) * np.exp((2*1j) * (t8555 + t8553)) + (t8576 + t8578) * np.exp((6*1j) * (t8556 - phi2)))

        if Bindx == 239:
            t8602 = np.cos(phi)
            t8601 = t8602 ** 2
            t8609 = t8601 ** 2
            t8608 = t8602 * t8601
            t8611 = t8608 ** 2
            t8613 = t8609 ** 2
            t8610 = t8602 * t8609
            t8615 = t8610 ** 2
            t8617 = t8611 ** 2
            t8612 = t8602 * t8611
            t8619 = t8612 ** 2
            t8621 = t8613 ** 2
            t8628 = 3089360 * t8601 - 51854880 * t8609 + 361477200 * t8611 - 1300498200 * t8613 + 2598383600 * t8615 - 2903409600 * t8617 + 1696047600 * t8619 - 403201500 * t8621 - 33580
            t8627 = 6815116 * t8601 - 129812760 * t8609 + 945287420 * t8611 - 3398637550 * t8613 + 6678759780 * t8615 - 7320811680 * t8617 + 4206302100 * t8619 - 987843675 * t8621 - 58751
            t8626 = 5364060 * t8601 - 40580280 * t8609 + 103459980 * t8611 - 51227670 * t8613 - 200048940 * t8615 + 371860320 * t8617 - 249204540 * t8619 + 60480225 * t8621 - 103155
            t8586 = t8602 * t8621
            t8588 = t8602 * t8619
            t8590 = t8602 * t8617
            t8592 = t8602 * t8615
            t8594 = t8602 * t8613
            t8625 = 16128060 * t8586 + 2601300 * t8588 - 227066580 * t8590 + 570366420 * t8592 - 627953820 * t8594 - 645840 * t8602 + 13257660 * t8608 - 101953020 * t8610 + 355265820 * t8612
            t8624 = 161280600 * t8586 - 416208000 * t8588 + 55255200 * t8590 + 850595200 * t8592 - 1149361520 * t8594 - 713000 * t8602 + 21417600 * t8608 - 181530720 * t8610 + 659264640 * t8612
            t8623 = -790274940 * t8586 + 3339548940 * t8588 - 5814981900 * t8590 + 5393033100 * t8592 - 2876351940 * t8594 - 301840 * t8602 + 12062820 * t8608 - 150426276 * t8610 + 887692036 * t8612
            t8607 = 4 * phi1
            t8606 = 8 * phi1
            t8605 = -5 * phi2
            t8604 = 5 * phi2
            t8603 = 12 * phi1
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * ((1 + t8602) ** (-0.1e1 / 0.2e1)) * ((1 - t8602) ** (-0.1e1 / 0.2e1)) * ((1225732560 * t8586 - 5851884480 * t8588 + 11551063680 * t8590 - 12149159360 * t8592 + 7308947360 * t8594 - 2505552192 * t8612 + 457673216 * t8610 - 37733696 * t8608 + 912912 * t8602) * np.exp((-5*1j) * phi2) + (t8623 + t8627) * np.exp((-1*1j) * (t8607 + t8604)) + (t8624 - t8628) * np.exp((-1*1j) * (t8606 + t8604)) + (t8623 - t8627) * np.exp((1j) * (t8607 + t8605)) + (t8624 + t8628) * np.exp((1j) * (t8606 + t8605)) + (t8625 + t8626) * np.exp((-1*1j) * (t8603 + t8604)) + (t8625 - t8626) * np.exp((1j) * (t8603 + t8605)))

        if Bindx == 240:
            t8654 = np.cos(phi)
            t8653 = t8654 ** 2
            t8662 = t8653 ** 2
            t8666 = t8662 ** 2
            t8674 = t8666 ** 2
            t8638 = t8654 * t8674
            t8661 = t8654 * t8653
            t8664 = t8661 ** 2
            t8665 = t8654 * t8664
            t8672 = t8665 ** 2
            t8640 = t8654 * t8672
            t8670 = t8664 ** 2
            t8642 = t8654 * t8670
            t8663 = t8654 * t8662
            t8668 = t8663 ** 2
            t8644 = t8654 * t8668
            t8646 = t8654 * t8666
            t8683 = 35960 * t8638 + 5800 * t8640 - 506280 * t8642 + 1271720 * t8644 - 1400120 * t8646 - 1440 * t8654 + 29560 * t8661 - 227320 * t8663 + 792120 * t8665
            t8682 = -11960 * t8653 + 90480 * t8662 - 230680 * t8664 + 114220 * t8666 + 446040 * t8668 - 829120 * t8670 + 555640 * t8672 - 134850 * t8674 + 230
            t8681 = 65540 * t8653 - 655400 * t8662 + 1638500 * t8664 - 1802350 * t8666 + 720940 * t8668 + 262160 * t8670 - 327700 * t8672 + 81925 * t8674 + 16385
            t8680 = 16385 * t8638 + 65540 * t8640 - 655400 * t8642 + 1638500 * t8644 - 1802350 * t8646 + 81925 * t8654 - 327700 * t8661 + 262160 * t8663 + 720940 * t8665
            t8679 = -201480 * t8653 + 3381840 * t8662 - 23574600 * t8664 + 84815100 * t8666 - 169459800 * t8668 + 189352800 * t8670 - 110611800 * t8672 + 26295750 * t8674 + 2190
            t8678 = 10518300 * t8638 - 27144000 * t8640 + 3603600 * t8642 + 55473600 * t8644 - 74958360 * t8646 - 46500 * t8654 + 1396800 * t8661 - 11838960 * t8663 + 42995520 * t8665
            t8677 = 1947176 * t8653 - 37089360 * t8662 + 270082120 * t8664 - 971039300 * t8666 + 1908217080 * t8668 - 2091660480 * t8670 + 1201800600 * t8672 - 282241050 * t8674 - 16786
            t8676 = 225792840 * t8638 - 954156840 * t8640 + 1661423400 * t8642 - 1540866600 * t8644 + 821814840 * t8646 + 86240 * t8654 - 3446520 * t8661 + 42978936 * t8663 - 253626296 * t8665
            t8660 = 4 * phi1
            t8659 = 8 * phi1
            t8658 = -5 * phi2
            t8657 = 5 * phi2
            t8656 = 12 * phi1
            t8655 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.113e3) * np.sqrt(0.13e2) * np.sqrt(0.23e2) * np.sqrt(0.31e2) * ((1 + t8654) ** (-0.1e1 / 0.2e1)) * ((1 - t8654) ** (-0.1e1 / 0.2e1)) * ((601080390 * t8638 - 2869674120 * t8640 + 5664463920 * t8642 - 5957760840 * t8644 + 3584195340 * t8646 - 1228684248 * t8665 + 224435904 * t8663 - 18504024 * t8661 + 447678 * t8654) * np.exp((-5*1j) * phi2) + (t8676 - t8677) * np.exp((-1*1j) * (t8660 + t8657)) + (t8678 + t8679) * np.exp((-1*1j) * (t8659 + t8657)) + (t8676 + t8677) * np.exp((1j) * (t8660 + t8658)) + (t8678 - t8679) * np.exp((1j) * (t8659 + t8658)) + (-t8682 + t8683) * np.exp((-1*1j) * (t8656 + t8657)) + (t8680 + t8681) * np.exp((-1*1j) * (t8655 + t8657)) + (t8682 + t8683) * np.exp((1j) * (t8656 + t8658)) + (t8680 - t8681) * np.exp((1j) * (t8655 + t8658)))

        if Bindx == 241:
            t8706 = np.cos(phi)
            t8705 = t8706 ** 2
            t8709 = t8706 * t8705
            t8712 = t8709 ** 2
            t8713 = t8706 * t8712
            t8720 = t8713 ** 2
            t8692 = t8706 * t8720
            t8718 = t8712 ** 2
            t8694 = t8706 * t8718
            t8710 = t8705 ** 2
            t8711 = t8706 * t8710
            t8716 = t8711 ** 2
            t8696 = t8706 * t8716
            t8714 = t8710 ** 2
            t8698 = t8706 * t8714
            t8728 = -12096045 * t8692 + 53196585 * t8694 - 91606125 * t8696 + 76339185 * t8698 - 40365 * t8706 + 381225 * t8709 + 3691155 * t8711 - 29865615 * t8713
            t8727 = 80640300 * t8692 - 319959900 * t8694 + 510482700 * t8696 - 418363100 * t8698 - 143060 * t8706 + 4586660 * t8709 - 43460340 * t8711 + 186216740 * t8713
            t8726 = -197568735 * t8692 + 732916275 * t8694 - 1085670495 * t8696 + 816475275 * t8698 + 150689 * t8706 - 5943245 * t8709 + 66777249 * t8711 - 327165685 * t8713
            t8691 = t8714 ** 2
            t8725 = 4032015 * t8691 + 1255800 * t8705 - 11714820 * t8710 + 43594200 * t8712 - 77527710 * t8714 + 65768040 * t8716 - 18101460 * t8718 - 7283640 * t8720 - 22425
            t8724 = 40320150 * t8691 + 507840 * t8705 - 7143800 * t8710 + 32818240 * t8712 - 52802940 * t8714 - 11003200 * t8716 + 122171400 * t8718 - 124862400 * t8720 - 5290
            t8723 = -197568735 * t8691 + 766920 * t8705 - 15373820 * t8710 + 119731304 * t8712 - 466534530 * t8714 + 1002881880 * t8716 - 1208707500 * t8718 + 764782200 * t8720 - 6391
            t8708 = 2 * phi1
            t8707 = 3 * phi1
            tfunc[..., c] = -(0.33e2 / 0.29622272e8) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * ((306433140 * t8691 - 1265272320 * t8720 + 2117422320 * t8718 - 1839735040 * t8716 + 882372920 * t8714 - 228836608 * t8712 + 28995824 * t8710 - 1391104 * t8705 + 10868) * np.exp((-4*1j) * phi2) + (t8723 + t8726) * np.exp((-4*1j) * (phi1 + phi2)) + (t8724 + t8727) * np.exp((-4*1j) * (t8708 + phi2)) + (t8725 - t8728) * np.exp((-4*1j) * (t8707 + phi2)) + (t8723 - t8726) * np.exp((4*1j) * (phi1 - phi2)) + (t8724 - t8727) * np.exp((4*1j) * (t8708 - phi2)) + (t8725 + t8728) * np.exp((4*1j) * (t8707 - phi2)))

        if Bindx == 242:
            t8753 = np.cos(phi)
            t8752 = t8753 ** 2
            t8758 = t8752 ** 2
            t8757 = t8753 * t8752
            t8760 = t8757 ** 2
            t8766 = t8760 ** 2
            t8780 = -t8758 - t8766
            t8741 = t8753 * t8766
            t8762 = t8758 ** 2
            t8745 = t8753 * t8762
            t8761 = t8753 * t8760
            t8779 = -t8741 - t8745 - t8757 - t8761
            t8768 = t8761 ** 2
            t8739 = t8753 * t8768
            t8759 = t8753 * t8758
            t8764 = t8759 ** 2
            t8743 = t8753 * t8764
            t8778 = -65540 * t8739 - 65540 * t8753 - 589860 * t8743 - 589860 * t8759
            t8738 = t8762 ** 2
            t8777 = 16385 * t8738 + 1048640 * t8760 - 1474650 * t8762 + 1048640 * t8764 + 16385
            t8776 = -107880 * t8739 + 474440 * t8741 - 817000 * t8743 + 680840 * t8745 - 360 * t8753 + 3400 * t8757 + 32920 * t8759 - 266360 * t8761
            t8775 = 35960 * t8738 + 11200 * t8752 - 104480 * t8758 + 388800 * t8760 - 691440 * t8762 + 586560 * t8764 - 161440 * t8766 - 64960 * t8768 - 200
            t8774 = -21036600 * t8739 + 83467800 * t8741 - 133169400 * t8743 + 109138200 * t8745 + 37320 * t8753 - 1196520 * t8757 + 11337480 * t8759 - 48578280 * t8761
            t8773 = 10518300 * t8738 + 132480 * t8752 - 1863600 * t8758 + 8561280 * t8760 - 13774680 * t8762 - 2870400 * t8764 + 31870800 * t8766 - 32572800 * t8768 - 1380
            t8772 = -225792840 * t8739 + 837618600 * t8741 - 1240766280 * t8743 + 933114600 * t8745 + 172216 * t8753 - 6792280 * t8757 + 76316856 * t8759 - 373903640 * t8761
            t8771 = 225792840 * t8738 - 876480 * t8752 + 17570080 * t8758 - 136835776 * t8760 + 533182320 * t8762 - 1146150720 * t8764 + 1381380000 * t8766 - 874036800 * t8768 + 7304
            t8756 = 2 * phi1
            t8755 = 3 * phi1
            t8754 = 4 * phi1
            t8733 = np.exp((-4*1j) * (t8754 + phi2))
            t8729 = np.exp((4*1j) * (t8754 - phi2))
            tfunc[..., c] = (0.33e2 / 0.473956352e9) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * ((1730808420 * t8762 - 448871808 * t8760 + 56876424 * t8758 - 2728704 * t8752 + 601080390 * t8738 - 2481880320 * t8768 + 4153405320 * t8766 - 3608711040 * t8764 + 21318) * np.exp((-4*1j) * phi2) + ((t8777 - t8778) * t8733) + ((t8777 + t8778) * t8729) + (t8771 - t8772) * np.exp((-4*1j) * (phi1 + phi2)) + (t8773 - t8774) * np.exp((-4*1j) * (t8756 + phi2)) + (t8775 - t8776) * np.exp((-4*1j) * (t8755 + phi2)) + (t8771 + t8772) * np.exp((4*1j) * (phi1 - phi2)) + (t8773 + t8774) * np.exp((4*1j) * (t8756 - phi2)) + (t8775 + t8776) * np.exp((4*1j) * (t8755 - phi2)) + (327700 * (t8779 + t8780) * t8733) + (327700 * (-t8779 + t8780) * t8729))

        if Bindx == 243:
            t8804 = np.cos(phi)
            t8803 = t8804 ** 2
            t8810 = t8803 ** 2
            t8814 = t8810 ** 2
            t8822 = t8814 ** 2
            t8788 = t8804 * t8822
            t8809 = t8804 * t8803
            t8812 = t8809 ** 2
            t8813 = t8804 * t8812
            t8820 = t8813 ** 2
            t8790 = t8804 * t8820
            t8818 = t8812 ** 2
            t8792 = t8804 * t8818
            t8811 = t8804 * t8810
            t8816 = t8811 ** 2
            t8794 = t8804 * t8816
            t8796 = t8804 * t8814
            t8829 = 12406200 * t8788 - 54427200 * t8790 + 96346080 * t8792 - 87753280 * t8794 + 43435408 * t8796 + 1656 * t8804 - 78016 * t8809 + 1440352 * t8811 - 11371200 * t8813
            t8828 = 211140 * t8803 - 2405616 * t8810 + 11775540 * t8812 - 29937030 * t8814 + 42912204 * t8816 - 35121000 * t8818 + 15359676 * t8820 - 2791395 * t8822 - 3519
            t8827 = 1240620 * t8788 - 5242620 * t8790 + 6933948 * t8792 + 595332 * t8794 - 10337580 * t8796 - 47472 * t8804 + 907212 * t8809 - 4784460 * t8811 + 10735020 * t8813
            t8826 = 285200 * t8803 - 4716288 * t8810 + 30110864 * t8812 - 95939624 * t8814 + 168707760 * t8816 - 166759200 * t8818 + 86923440 * t8820 - 18609300 * t8822 - 2852
            t8825 = -238700 * t8803 + 4830672 * t8810 - 37111228 * t8812 + 139707106 * t8814 - 285308100 * t8816 + 322740600 * t8818 - 190215060 * t8820 + 45592785 * t8822 + 1925
            t8824 = -60790380 * t8788 + 272576220 * t8790 - 507352860 * t8792 + 505961820 * t8794 - 290663604 * t8796 - 33264 * t8804 + 1382612 * t8809 - 17053652 * t8811 + 95973108 * t8813
            t8808 = 4 * phi1
            t8807 = 8 * phi1
            t8806 = -3 * phi2
            t8805 = 3 * phi2
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * ((1 + t8804) ** (-0.1e1 / 0.2e1)) * ((1 - t8804) ** (-0.1e1 / 0.2e1)) * ((94287120 * t8788 - 425812800 * t8790 + 793731840 * t8792 - 787159360 * t8794 + 445935776 * t8796 - 143805376 * t8813 + 24692096 * t8811 - 1912768 * t8809 + 43472 * t8804) * np.exp((-3*1j) * phi2) + (t8827 - t8828) * np.exp((-3*1j) * (t8808 + phi2)) + (t8824 - t8825) * np.exp((-1*1j) * (t8808 + t8805)) + (-t8826 + t8829) * np.exp((-1*1j) * (t8807 + t8805)) + (t8824 + t8825) * np.exp((1j) * (t8808 + t8806)) + (t8826 + t8829) * np.exp((1j) * (t8807 + t8806)) + (t8827 + t8828) * np.exp((3*1j) * (t8808 - phi2)))

        if Bindx == 244:
            t8855 = np.cos(phi)
            t8854 = t8855 ** 2
            t8861 = t8855 * t8854
            t8864 = t8861 ** 2
            t8862 = t8854 ** 2
            t8866 = t8862 ** 2
            t8863 = t8855 * t8862
            t8868 = t8863 ** 2
            t8870 = t8864 ** 2
            t8865 = t8855 * t8864
            t8872 = t8865 ** 2
            t8874 = t8866 ** 2
            t8883 = 65540 * t8854 - 458780 * t8864 + 1146950 * t8866 - 1376340 * t8868 + 917560 * t8870 - 327700 * t8872 + 49155 * t8874 - 16385
            t8839 = t8855 * t8874
            t8841 = t8855 * t8872
            t8845 = t8855 * t8868
            t8847 = t8855 * t8866
            t8882 = 16385 * t8839 - 65540 * t8841 + 458780 * t8845 - 1146950 * t8847 - 49155 * t8855 + 327700 * t8861 - 917560 * t8863 + 1376340 * t8865
            t8881 = -6120 * t8854 + 69728 * t8862 - 341320 * t8864 + 867740 * t8866 - 1243832 * t8868 + 1018000 * t8870 - 445208 * t8872 + 80910 * t8874 + 102
            t8843 = t8855 * t8870
            t8880 = 35960 * t8839 - 151960 * t8841 + 200984 * t8843 + 17256 * t8845 - 299640 * t8847 - 1376 * t8855 + 26296 * t8861 - 138680 * t8863 + 311160 * t8865
            t8879 = 10518300 * t8839 - 46144800 * t8841 + 81684720 * t8843 - 74399520 * t8845 + 36825672 * t8847 + 1404 * t8855 - 66144 * t8861 + 1221168 * t8863 - 9640800 * t8865
            t8878 = 241800 * t8854 - 3998592 * t8862 + 25528776 * t8864 - 81340116 * t8866 + 143034840 * t8868 - 141382800 * t8870 + 73695960 * t8872 - 15777450 * t8874 - 2418
            t8877 = 886600 * t8854 - 17942496 * t8862 + 137841704 * t8864 - 518912108 * t8866 + 1059715800 * t8868 - 1198750800 * t8870 + 706513080 * t8872 - 169344630 * t8874 - 7150
            t8876 = 225792840 * t8839 - 1012425960 * t8841 + 1884453480 * t8843 - 1879286760 * t8845 + 1079607672 * t8847 + 123552 * t8855 - 5135416 * t8861 + 63342136 * t8863 - 356471544 * t8865
            t8860 = 4 * phi1
            t8859 = 8 * phi1
            t8858 = -3 * phi2
            t8857 = 3 * phi2
            t8856 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.7e1) * np.sqrt(0.23e2) * np.sqrt(0.31e2) * ((1 + t8855) ** (-0.1e1 / 0.2e1)) * ((1 - t8855) ** (-0.1e1 / 0.2e1)) * ((601080390 * t8839 - 2714556600 * t8841 + 5060040480 * t8843 - 5018140920 * t8845 + 2842840572 * t8847 - 916759272 * t8865 + 157412112 * t8863 - 12193896 * t8861 + 277134 * t8855) * np.exp((-3*1j) * phi2) + (t8882 + t8883) * np.exp((-1*1j) * (t8856 + t8857)) + (t8882 - t8883) * np.exp((1j) * (t8856 + t8858)) + (t8880 + t8881) * np.exp((-3*1j) * (t8860 + phi2)) + (t8876 - t8877) * np.exp((-1*1j) * (t8860 + t8857)) + (-t8878 + t8879) * np.exp((-1*1j) * (t8859 + t8857)) + (t8876 + t8877) * np.exp((1j) * (t8860 + t8858)) + (t8878 + t8879) * np.exp((1j) * (t8859 + t8858)) + (t8880 - t8881) * np.exp((3*1j) * (t8860 - phi2)))

        if Bindx == 245:
            t8906 = np.cos(phi)
            t8905 = t8906 ** 2
            t8911 = t8905 ** 2
            t8915 = t8911 ** 2
            t8891 = t8915 ** 2
            t8910 = t8906 * t8905
            t8913 = t8910 ** 2
            t8912 = t8906 * t8911
            t8917 = t8912 ** 2
            t8919 = t8913 ** 2
            t8914 = t8906 * t8913
            t8921 = t8914 ** 2
            t8929 = -620310 * t8891 - 8556 * t8905 - 19320 * t8911 + 840420 * t8913 - 3622500 * t8915 + 6763932 * t8917 - 6495384 * t8919 + 3161580 * t8921 + 138
            t8892 = t8906 * t8921
            t8894 = t8906 * t8919
            t8896 = t8906 * t8917
            t8898 = t8906 * t8915
            t8928 = -930465 * t8892 + 5056527 * t8894 - 11351949 * t8896 + 13478115 * t8898 + 26289 * t8906 - 535647 * t8910 + 3214365 * t8912 - 8957235 * t8914
            t8927 = -15197595 * t8892 + 55397685 * t8894 - 80180415 * t8896 + 58575825 * t8898 + 9163 * t8906 - 378917 * t8910 + 4448367 * t8912 - 22674113 * t8914
            t8926 = -6203100 * t8892 + 26773380 * t8894 - 46405260 * t8896 + 41057300 * t8898 + 14812 * t8906 - 495236 * t8910 + 4700556 * t8912 - 19442452 * t8914
            t8925 = -6203100 * t8891 + 65688 * t8905 - 1127000 * t8911 + 7572152 * t8913 - 25606176 * t8915 + 47886920 * t8917 - 50201640 * t8919 + 27613800 * t8921 - 644
            t8924 = 30395190 * t8891 - 135828 * t8905 + 2798488 * t8911 - 21928676 * t8913 + 84349188 * t8915 - 176285340 * t8917 + 204347640 * t8919 - 123541740 * t8921 + 1078
            t8909 = 2 * phi1
            t8908 = 4 * phi1
            t8907 = 6 * phi1
            tfunc[..., c] = (0.33e2 / 0.29622272e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.19e2) * ((-47143560 * t8891 + 185532720 * t8921 - 295866480 * t8919 + 244964720 * t8917 - 111983872 * t8915 + 27691664 * t8913 - 3347344 * t8911 + 153296 * t8905 - 1144) * np.exp((-2*1j) * phi2) + (t8924 - t8927) * np.exp((-2*1j) * (t8909 + phi2)) + (t8925 + t8926) * np.exp((-2*1j) * (t8908 + phi2)) + (t8928 + t8929) * np.exp((-2*1j) * (t8907 + phi2)) + (t8924 + t8927) * np.exp((2*1j) * (t8909 - phi2)) + (t8925 - t8926) * np.exp((2*1j) * (t8908 - phi2)) + (-t8928 + t8929) * np.exp((2*1j) * (t8907 - phi2)))

        if Bindx == 246:
            t8954 = np.cos(phi)
            t8953 = t8954 ** 2
            t8959 = t8954 * t8953
            t8962 = t8959 ** 2
            t8968 = t8962 ** 2
            t8942 = t8954 * t8968
            t8982 = t8959 - t8942
            t8960 = t8953 ** 2
            t8961 = t8954 * t8960
            t8966 = t8961 ** 2
            t8981 = t8962 + t8968 - t8960 - t8966
            t8964 = t8960 ** 2
            t8939 = t8964 ** 2
            t8963 = t8954 * t8962
            t8970 = t8963 ** 2
            t8980 = -16385 + 16385 * t8939 + 98310 * t8953 - 98310 * t8970
            t8940 = t8954 * t8970
            t8944 = t8954 * t8966
            t8946 = t8954 * t8964
            t8979 = -32770 * t8940 + 32770 * t8954 + 1146950 * t8946 - 1146950 * t8963 - 688170 * t8944 + 688170 * t8961
            t8978 = 35960 * t8939 + 496 * t8953 + 1120 * t8960 - 48720 * t8962 + 210000 * t8964 - 392112 * t8966 + 376544 * t8968 - 183280 * t8970 - 8
            t8977 = 53940 * t8940 - 293132 * t8942 + 658084 * t8944 - 781340 * t8946 - 1524 * t8954 + 31052 * t8959 - 186340 * t8961 + 519260 * t8963
            t8976 = -10518300 * t8940 + 45398340 * t8942 - 78687180 * t8944 + 69618900 * t8946 + 25116 * t8954 - 839748 * t8959 + 7970508 * t8961 - 32967636 * t8963
            t8975 = -112896420 * t8940 + 411525660 * t8942 - 595625940 * t8944 + 435134700 * t8946 + 68068 * t8954 - 2814812 * t8959 + 33045012 * t8961 - 168436268 * t8963
            t8974 = 10518300 * t8939 - 111384 * t8953 + 1911000 * t8960 - 12839736 * t8962 + 43419168 * t8964 - 81199560 * t8966 + 85124520 * t8968 - 46823400 * t8970 + 1092
            t8973 = 225792840 * t8939 - 1009008 * t8953 + 20788768 * t8960 - 162898736 * t8962 + 626593968 * t8964 - 1309548240 * t8966 + 1518011040 * t8968 - 917738640 * t8970 + 8008
            t8958 = 2 * phi1
            t8957 = 4 * phi1
            t8956 = 6 * phi1
            t8955 = 8 * phi1
            t8934 = np.exp((-2*1j) * (t8955 + phi2))
            t8930 = np.exp((2*1j) * (t8955 - phi2))
            tfunc[..., c] = (0.33e2 / 0.473956352e9) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.23e2) * np.sqrt(0.19e2) * ((14586 + 601080390 * t8939 - 2365542180 * t8970 + 3772297620 * t8968 - 3123300180 * t8966 + 1427794368 * t8964 - 353068716 * t8962 + 42678636 * t8960 - 1954524 * t8953) * np.exp((-2*1j) * phi2) + ((-t8979 + t8980) * t8934) + ((t8979 + t8980) * t8930) + (t8973 - t8975) * np.exp((-2*1j) * (t8958 + phi2)) + (t8974 - t8976) * np.exp((-2*1j) * (t8957 + phi2)) + (t8977 + t8978) * np.exp((-2*1j) * (t8956 + phi2)) + (t8973 + t8975) * np.exp((2*1j) * (t8958 - phi2)) + (t8974 + t8976) * np.exp((2*1j) * (t8957 - phi2)) + (-t8977 + t8978) * np.exp((2*1j) * (t8956 - phi2)) + (229390 * (t8981 + t8982) * t8934) + (229390 * (t8981 - t8982) * t8930))

        if Bindx == 247:
            t9006 = np.cos(phi)
            t9005 = t9006 ** 2
            t9011 = t9005 ** 2
            t9010 = t9006 * t9005
            t9013 = t9010 ** 2
            t9015 = t9011 ** 2
            t9012 = t9006 * t9011
            t9017 = t9012 ** 2
            t9019 = t9013 ** 2
            t9014 = t9006 * t9013
            t9021 = t9014 ** 2
            t9023 = t9015 ** 2
            t9030 = 596160 * t9005 - 6172740 * t9011 + 25038720 * t9013 - 52816050 * t9015 + 63987840 * t9017 - 45121860 * t9019 + 17288640 * t9021 - 2791395 * t9023 - 9315
            t9029 = 334880 * t9005 - 5654320 * t9011 + 36141280 * t9013 - 113216120 * t9015 + 192997600 * t9017 - 183236400 * t9019 + 91245600 * t9021 - 18609300 * t9023 - 3220
            t9028 = 206976 * t9005 - 4314156 * t9011 + 34047552 * t9013 - 131284230 * t9015 + 273725760 * t9017 - 315041580 * t9019 + 188254080 * t9021 - 45592785 * t9023 - 1617
            t8990 = t9006 * t9023
            t8992 = t9006 * t9021
            t8994 = t9006 * t9019
            t8996 = t9006 * t9017
            t8998 = t9006 * t9015
            t9027 = 3721860 * t8990 - 23891940 * t8992 + 65291940 * t8994 - 98445060 * t8996 + 88533900 * t8998 + 99360 * t9006 - 2156940 * t9010 + 14576940 * t9012 - 47730060 * t9014
            t9026 = 37218600 * t8990 - 196898400 * t8992 + 434534400 * t8994 - 516101600 * t8996 + 354463120 * t8998 + 83720 * t9006 - 2910880 * t9010 + 29933120 * t9012 - 140322080 * t9014
            t9025 = -182371140 * t8990 + 841260420 * t8992 - 1604014020 * t8994 + 1629439140 * t8996 - 946882860 * t8998 - 103488 * t9006 + 4417644 * t9010 - 55385484 * t9012 + 313639788 * t9014
            t9009 = 4 * phi1
            t9008 = 8 * phi1
            t9007 = 12 * phi1
            tfunc[..., c] = (-0.11e2 / 0.59244544e8*1j) * np.sqrt(0.2e1) * np.sqrt(0.1921e4) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * ((282861360 * t8990 - 1240940160 * t8992 + 2246529600 * t8994 - 2163324800 * t8996 + 1189828640 * t8998 - 372468096 * t9014 + 62078016 * t9012 - 4667520 * t9010 + 102960 * t9006) * np.exp((-1*1j) * phi2) + (t9025 + t9028) * np.exp((-1*1j) * (t9009 + phi2)) + (t9026 - t9029) * np.exp((-1*1j) * (t9008 + phi2)) + (t9025 - t9028) * np.exp((1j) * (t9009 - phi2)) + (t9026 + t9029) * np.exp((1j) * (t9008 - phi2)) + (t9027 - t9030) * np.exp((-1*1j) * (t9007 + phi2)) + (t9027 + t9030) * np.exp((1j) * (t9007 - phi2))) * ((1 + t9006) ** (-0.1e1 / 0.2e1)) * ((1 - t9006) ** (-0.1e1 / 0.2e1))

        if Bindx == 248:
            t9056 = np.cos(phi)
            t9055 = t9056 ** 2
            t9062 = t9055 ** 2
            t9061 = t9056 * t9055
            t9064 = t9061 ** 2
            t9066 = t9062 ** 2
            t9063 = t9056 * t9062
            t9068 = t9063 ** 2
            t9070 = t9064 ** 2
            t9065 = t9056 * t9064
            t9072 = t9065 ** 2
            t9074 = t9066 ** 2
            t9083 = -5760 * t9055 + 59640 * t9062 - 241920 * t9064 + 510300 * t9066 - 618240 * t9068 + 435960 * t9070 - 167040 * t9072 + 26970 * t9074 + 90
            t9040 = t9056 * t9074
            t9042 = t9056 * t9072
            t9044 = t9056 * t9070
            t9046 = t9056 * t9068
            t9048 = t9056 * t9066
            t9082 = 35960 * t9040 - 230840 * t9042 + 630840 * t9044 - 951160 * t9046 + 855400 * t9048 + 960 * t9056 - 20840 * t9061 + 140840 * t9063 - 461160 * t9065
            t9081 = -131080 * t9055 + 458780 * t9062 - 917560 * t9064 + 1146950 * t9066 - 917560 * t9068 + 458780 * t9070 - 131080 * t9072 + 16385 * t9074 + 16385
            t9080 = 16385 * t9040 - 131080 * t9042 + 458780 * t9044 - 917560 * t9046 + 1146950 * t9048 + 16385 * t9056 - 131080 * t9061 + 458780 * t9063 - 917560 * t9065
            t9079 = -94640 * t9055 + 1597960 * t9062 - 10213840 * t9064 + 31995860 * t9066 - 54542800 * t9068 + 51784200 * t9070 - 25786800 * t9072 + 5259150 * t9074 + 910
            t9078 = 256256 * t9055 - 5341336 * t9062 + 42154112 * t9064 - 162542380 * t9066 + 338898560 * t9068 - 390051480 * t9070 + 233076480 * t9072 - 56448210 * t9074 - 2002
            t9077 = 10518300 * t9040 - 55645200 * t9042 + 122803200 * t9044 - 145854800 * t9046 + 100174360 * t9048 + 23660 * t9056 - 822640 * t9061 + 8459360 * t9063 - 39656240 * t9065
            t9076 = 225792840 * t9040 - 1041560520 * t9042 + 1985922120 * t9044 - 2017400840 * t9046 + 1172331160 * t9048 + 128128 * t9056 - 5469464 * t9061 + 68572504 * t9063 - 388315928 * t9065
            t9060 = 4 * phi1
            t9059 = 8 * phi1
            t9058 = 12 * phi1
            t9057 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.3e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * ((1 + t9056) ** (-0.1e1 / 0.2e1)) * ((1 - t9056) ** (-0.1e1 / 0.2e1)) * ((601080390 * t9040 - 2636997840 * t9042 + 4773875400 * t9044 - 4597065200 * t9046 + 2528385860 * t9048 - 791494704 * t9065 + 131915784 * t9063 - 9918480 * t9061 + 218790 * t9056) * np.exp((-1*1j) * phi2) + (t9076 - t9078) * np.exp((-1*1j) * (t9060 + phi2)) + (t9077 + t9079) * np.exp((-1*1j) * (t9059 + phi2)) + (t9076 + t9078) * np.exp((1j) * (t9060 - phi2)) + (t9077 - t9079) * np.exp((1j) * (t9059 - phi2)) + (t9082 + t9083) * np.exp((-1*1j) * (t9058 + phi2)) + (t9080 + t9081) * np.exp((-1*1j) * (t9057 + phi2)) + (t9082 - t9083) * np.exp((1j) * (t9058 - phi2)) + (t9080 - t9081) * np.exp((1j) * (t9057 - phi2)))

        if Bindx == 249:
            t9095 = np.cos(phi)
            t9094 = t9095 ** 2
            t9096 = t9094 ** 2
            t9097 = t9094 * t9096
            t9100 = t9097 ** 2
            t9098 = t9096 ** 2
            t9090 = t9094 * t9098
            t9088 = t9094 * t9100
            t9087 = t9098 ** 2
            tfunc[..., c] = 0.11e2 / 0.29622272e8 * np.sqrt(0.2e1) * np.sqrt(0.113e3) * np.sqrt(0.19e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * (-(601080390 * t9087) + (2326762800 * t9088) - (3650610600 * t9100) + (2974571600 * t9090) - (1338557220 * t9098) + (325909584 * t9097) - (38798760 * t9096) + (1750320 * t9094) - 0.12870e5 + (775077345 * t9087 - 3200319360 * t9088 + 5355706860 * t9100 - 4653337920 * t9090 + 2231831910 * t9098 - 578808384 * t9097 + 73340652 * t9096 - 3518592 * t9094 + 27489) * np.cos((4 * phi1)) + (-158179050 * t9087 + 775587600 * t9088 - 1557509400 * t9100 + 1640479600 * t9090 - 962337020 * t9098 + 307200880 * t9097 - 48061720 * t9096 + 2846480 * t9094 - 27370) * np.cos((8 * phi1)) + (-15817905 * t9087 + 97968960 * t9088 - 255690540 * t9100 + 362597760 * t9090 - 299290950 * t9098 + 141886080 * t9097 - 34978860 * t9096 + 3378240 * t9094 - 52785) * np.cos((12 * phi1)))

        if Bindx == 250:
            t9115 = np.cos(phi)
            t9114 = t9115 ** 2
            t9116 = t9114 ** 2
            t9117 = t9114 * t9116
            t9120 = t9117 ** 2
            t9118 = t9116 ** 2
            t9110 = t9114 * t9118
            t9108 = t9114 * t9120
            t9107 = t9118 ** 2
            tfunc[..., c] = 0.33e2 / 0.473956352e9 * np.sqrt(0.3e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * np.sqrt(0.17e2) * ((300540195 * t9107) - (1163381400 * t9108) + (1825305300 * t9120) - (1487285800 * t9110) + (669278610 * t9118) - (162954792 * t9117) + (19399380 * t9116) - (875160 * t9114) + 0.6435e4 + (225792840 * t9107 - 932305920 * t9108 + 1560205920 * t9120 - 1355594240 * t9110 + 650169520 * t9118 - 168616448 * t9117 + 21365344 * t9116 - 1025024 * t9114 + 8008) * np.cos((4 * phi1)) + (10518300 * t9107 - 51573600 * t9108 + 103568400 * t9120 - 109085600 * t9110 + 63991720 * t9118 - 20427680 * t9117 + 3195920 * t9116 - 189280 * t9114 + 1820) * np.cos((8 * phi1)) + (35960 * t9107 - 222720 * t9108 + 581280 * t9120 - 824320 * t9110 + 680400 * t9118 - 322560 * t9117 + 79520 * t9116 - 7680 * t9114 + 120) * np.cos((12 * phi1)) + (16385 * t9107 + 1146950 * t9118 + 16385 - 917560 * t9110 - 917560 * t9117 + 458780 * t9120 + 458780 * t9116 - 131080 * t9108 - 131080 * t9114) * np.cos((16 * phi1)))

        if Bindx == 251:
            t9146 = np.cos(phi)
            t9145 = t9146 ** 2
            t9151 = t9145 ** 2
            t9150 = t9146 * t9145
            t9153 = t9150 ** 2
            t9155 = t9151 ** 2
            t9152 = t9146 * t9151
            t9157 = t9152 ** 2
            t9159 = t9153 ** 2
            t9154 = t9146 * t9153
            t9161 = t9154 ** 2
            t9163 = t9155 ** 2
            t9170 = 596160 * t9145 - 6172740 * t9151 + 25038720 * t9153 - 52816050 * t9155 + 63987840 * t9157 - 45121860 * t9159 + 17288640 * t9161 - 2791395 * t9163 - 9315
            t9169 = 334880 * t9145 - 5654320 * t9151 + 36141280 * t9153 - 113216120 * t9155 + 192997600 * t9157 - 183236400 * t9159 + 91245600 * t9161 - 18609300 * t9163 - 3220
            t9168 = 206976 * t9145 - 4314156 * t9151 + 34047552 * t9153 - 131284230 * t9155 + 273725760 * t9157 - 315041580 * t9159 + 188254080 * t9161 - 45592785 * t9163 - 1617
            t9130 = t9146 * t9163
            t9132 = t9146 * t9161
            t9134 = t9146 * t9159
            t9136 = t9146 * t9157
            t9138 = t9146 * t9155
            t9167 = 3721860 * t9130 - 23891940 * t9132 + 65291940 * t9134 - 98445060 * t9136 + 88533900 * t9138 + 99360 * t9146 - 2156940 * t9150 + 14576940 * t9152 - 47730060 * t9154
            t9166 = 37218600 * t9130 - 196898400 * t9132 + 434534400 * t9134 - 516101600 * t9136 + 354463120 * t9138 + 83720 * t9146 - 2910880 * t9150 + 29933120 * t9152 - 140322080 * t9154
            t9165 = -182371140 * t9130 + 841260420 * t9132 - 1604014020 * t9134 + 1629439140 * t9136 - 946882860 * t9138 - 103488 * t9146 + 4417644 * t9150 - 55385484 * t9152 + 313639788 * t9154
            t9149 = 4 * phi1
            t9148 = 8 * phi1
            t9147 = 12 * phi1
            tfunc[..., c] = (-0.11e2 / 0.59244544e8*1j) * np.sqrt(0.2e1) * np.sqrt(0.1921e4) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * np.sqrt(0.19e2) * ((282861360 * t9130 - 1240940160 * t9132 + 2246529600 * t9134 - 2163324800 * t9136 + 1189828640 * t9138 - 372468096 * t9154 + 62078016 * t9152 - 4667520 * t9150 + 102960 * t9146) * np.exp((1j) * phi2) + (t9165 - t9168) * np.exp((-1*1j) * (t9149 - phi2)) + (t9166 + t9169) * np.exp((-1*1j) * (t9148 - phi2)) + (t9165 + t9168) * np.exp((1j) * (t9149 + phi2)) + (t9166 - t9169) * np.exp((1j) * (t9148 + phi2)) + (t9167 + t9170) * np.exp((-1*1j) * (t9147 - phi2)) + (t9167 - t9170) * np.exp((1j) * (t9147 + phi2))) * ((1 + t9146) ** (-0.1e1 / 0.2e1)) * ((1 - t9146) ** (-0.1e1 / 0.2e1))

        if Bindx == 252:
            t9196 = np.cos(phi)
            t9195 = t9196 ** 2
            t9202 = t9195 ** 2
            t9201 = t9196 * t9195
            t9204 = t9201 ** 2
            t9206 = t9202 ** 2
            t9203 = t9196 * t9202
            t9208 = t9203 ** 2
            t9210 = t9204 ** 2
            t9205 = t9196 * t9204
            t9212 = t9205 ** 2
            t9214 = t9206 ** 2
            t9223 = -5760 * t9195 + 59640 * t9202 - 241920 * t9204 + 510300 * t9206 - 618240 * t9208 + 435960 * t9210 - 167040 * t9212 + 26970 * t9214 + 90
            t9180 = t9196 * t9214
            t9182 = t9196 * t9212
            t9184 = t9196 * t9210
            t9186 = t9196 * t9208
            t9188 = t9196 * t9206
            t9222 = 35960 * t9180 - 230840 * t9182 + 630840 * t9184 - 951160 * t9186 + 855400 * t9188 + 960 * t9196 - 20840 * t9201 + 140840 * t9203 - 461160 * t9205
            t9221 = -131080 * t9195 + 458780 * t9202 - 917560 * t9204 + 1146950 * t9206 - 917560 * t9208 + 458780 * t9210 - 131080 * t9212 + 16385 * t9214 + 16385
            t9220 = 16385 * t9180 - 131080 * t9182 + 458780 * t9184 - 917560 * t9186 + 1146950 * t9188 + 16385 * t9196 - 131080 * t9201 + 458780 * t9203 - 917560 * t9205
            t9219 = -94640 * t9195 + 1597960 * t9202 - 10213840 * t9204 + 31995860 * t9206 - 54542800 * t9208 + 51784200 * t9210 - 25786800 * t9212 + 5259150 * t9214 + 910
            t9218 = -256256 * t9195 + 5341336 * t9202 - 42154112 * t9204 + 162542380 * t9206 - 338898560 * t9208 + 390051480 * t9210 - 233076480 * t9212 + 56448210 * t9214 + 2002
            t9217 = 10518300 * t9180 - 55645200 * t9182 + 122803200 * t9184 - 145854800 * t9186 + 100174360 * t9188 + 23660 * t9196 - 822640 * t9201 + 8459360 * t9203 - 39656240 * t9205
            t9216 = 225792840 * t9180 - 1041560520 * t9182 + 1985922120 * t9184 - 2017400840 * t9186 + 1172331160 * t9188 + 128128 * t9196 - 5469464 * t9201 + 68572504 * t9203 - 388315928 * t9205
            t9200 = 4 * phi1
            t9199 = 8 * phi1
            t9198 = 12 * phi1
            t9197 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.3e1) * np.sqrt(0.113e3) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * np.sqrt(0.31e2) * ((1 + t9196) ** (-0.1e1 / 0.2e1)) * ((1 - t9196) ** (-0.1e1 / 0.2e1)) * ((218790 * t9196 + 601080390 * t9180 - 2636997840 * t9182 + 4773875400 * t9184 - 4597065200 * t9186 + 2528385860 * t9188 - 791494704 * t9205 + 131915784 * t9203 - 9918480 * t9201) * np.exp((1j) * phi2) + (t9216 - t9218) * np.exp((-1*1j) * (t9200 - phi2)) + (t9217 - t9219) * np.exp((-1*1j) * (t9199 - phi2)) + (t9216 + t9218) * np.exp((1j) * (t9200 + phi2)) + (t9217 + t9219) * np.exp((1j) * (t9199 + phi2)) + (t9222 - t9223) * np.exp((-1*1j) * (t9198 - phi2)) + (t9220 - t9221) * np.exp((-1*1j) * (t9197 - phi2)) + (t9222 + t9223) * np.exp((1j) * (t9198 + phi2)) + (t9220 + t9221) * np.exp((1j) * (t9197 + phi2)))

        if Bindx == 253:
            t9246 = np.cos(phi)
            t9245 = t9246 ** 2
            t9251 = t9245 ** 2
            t9255 = t9251 ** 2
            t9231 = t9255 ** 2
            t9250 = t9246 * t9245
            t9253 = t9250 ** 2
            t9252 = t9246 * t9251
            t9257 = t9252 ** 2
            t9259 = t9253 ** 2
            t9254 = t9246 * t9253
            t9261 = t9254 ** 2
            t9269 = 620310 * t9231 + 8556 * t9245 + 19320 * t9251 - 840420 * t9253 + 3622500 * t9255 - 6763932 * t9257 + 6495384 * t9259 - 3161580 * t9261 - 138
            t9232 = t9246 * t9261
            t9234 = t9246 * t9259
            t9236 = t9246 * t9257
            t9238 = t9246 * t9255
            t9268 = -930465 * t9232 + 5056527 * t9234 - 11351949 * t9236 + 13478115 * t9238 + 26289 * t9246 - 535647 * t9250 + 3214365 * t9252 - 8957235 * t9254
            t9267 = -15197595 * t9232 + 55397685 * t9234 - 80180415 * t9236 + 58575825 * t9238 + 9163 * t9246 - 378917 * t9250 + 4448367 * t9252 - 22674113 * t9254
            t9266 = -6203100 * t9232 + 26773380 * t9234 - 46405260 * t9236 + 41057300 * t9238 + 14812 * t9246 - 495236 * t9250 + 4700556 * t9252 - 19442452 * t9254
            t9265 = 6203100 * t9231 - 65688 * t9245 + 1127000 * t9251 - 7572152 * t9253 + 25606176 * t9255 - 47886920 * t9257 + 50201640 * t9259 - 27613800 * t9261 + 644
            t9264 = -30395190 * t9231 + 135828 * t9245 - 2798488 * t9251 + 21928676 * t9253 - 84349188 * t9255 + 176285340 * t9257 - 204347640 * t9259 + 123541740 * t9261 - 1078
            t9249 = 2 * phi1
            t9248 = 4 * phi1
            t9247 = 6 * phi1
            tfunc[..., c] = -(0.33e2 / 0.29622272e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * np.sqrt(0.19e2) * ((47143560 * t9231 - 185532720 * t9261 + 295866480 * t9259 - 244964720 * t9257 + 111983872 * t9255 - 27691664 * t9253 + 3347344 * t9251 - 153296 * t9245 + 1144) * np.exp((2*1j) * phi2) + (t9264 - t9267) * np.exp((-2*1j) * (t9249 - phi2)) + (t9265 + t9266) * np.exp((-2*1j) * (t9248 - phi2)) + (t9268 + t9269) * np.exp((-2*1j) * (t9247 - phi2)) + (t9264 + t9267) * np.exp((2*1j) * (t9249 + phi2)) + (t9265 - t9266) * np.exp((2*1j) * (t9248 + phi2)) + (-t9268 + t9269) * np.exp((2*1j) * (t9247 + phi2)))

        if Bindx == 254:
            t9294 = np.cos(phi)
            t9293 = t9294 ** 2
            t9299 = t9294 * t9293
            t9302 = t9299 ** 2
            t9308 = t9302 ** 2
            t9282 = t9294 * t9308
            t9322 = t9299 - t9282
            t9300 = t9293 ** 2
            t9301 = t9294 * t9300
            t9306 = t9301 ** 2
            t9321 = t9302 + t9308 - t9300 - t9306
            t9304 = t9300 ** 2
            t9279 = t9304 ** 2
            t9303 = t9294 * t9302
            t9310 = t9303 ** 2
            t9320 = -16385 + 16385 * t9279 + 98310 * t9293 - 98310 * t9310
            t9280 = t9294 * t9310
            t9284 = t9294 * t9306
            t9286 = t9294 * t9304
            t9319 = -32770 * t9280 + 32770 * t9294 + 1146950 * t9286 - 1146950 * t9303 - 688170 * t9284 + 688170 * t9301
            t9318 = 35960 * t9279 + 496 * t9293 + 1120 * t9300 - 48720 * t9302 + 210000 * t9304 - 392112 * t9306 + 376544 * t9308 - 183280 * t9310 - 8
            t9317 = 53940 * t9280 - 293132 * t9282 + 658084 * t9284 - 781340 * t9286 - 1524 * t9294 + 31052 * t9299 - 186340 * t9301 + 519260 * t9303
            t9316 = -10518300 * t9280 + 45398340 * t9282 - 78687180 * t9284 + 69618900 * t9286 + 25116 * t9294 - 839748 * t9299 + 7970508 * t9301 - 32967636 * t9303
            t9315 = -112896420 * t9280 + 411525660 * t9282 - 595625940 * t9284 + 435134700 * t9286 + 68068 * t9294 - 2814812 * t9299 + 33045012 * t9301 - 168436268 * t9303
            t9314 = 10518300 * t9279 - 111384 * t9293 + 1911000 * t9300 - 12839736 * t9302 + 43419168 * t9304 - 81199560 * t9306 + 85124520 * t9308 - 46823400 * t9310 + 1092
            t9313 = 225792840 * t9279 - 1009008 * t9293 + 20788768 * t9300 - 162898736 * t9302 + 626593968 * t9304 - 1309548240 * t9306 + 1518011040 * t9308 - 917738640 * t9310 + 8008
            t9298 = 2 * phi1
            t9297 = 4 * phi1
            t9296 = 6 * phi1
            t9295 = 8 * phi1
            t9274 = np.exp((-2*1j) * (t9295 - phi2))
            t9270 = np.exp((2*1j) * (t9295 + phi2))
            tfunc[..., c] = (0.33e2 / 0.473956352e9) * np.sqrt(0.2e1) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.19e2) * np.sqrt(0.23e2) * ((14586 + 601080390 * t9279 - 2365542180 * t9310 + 3772297620 * t9308 - 3123300180 * t9306 + 1427794368 * t9304 - 353068716 * t9302 + 42678636 * t9300 - 1954524 * t9293) * np.exp((2*1j) * phi2) + ((t9319 + t9320) * t9274) + ((-t9319 + t9320) * t9270) + (t9313 + t9315) * np.exp((-2*1j) * (t9298 - phi2)) + (t9314 + t9316) * np.exp((-2*1j) * (t9297 - phi2)) + (-t9317 + t9318) * np.exp((-2*1j) * (t9296 - phi2)) + (t9313 - t9315) * np.exp((2*1j) * (t9298 + phi2)) + (t9314 - t9316) * np.exp((2*1j) * (t9297 + phi2)) + (t9317 + t9318) * np.exp((2*1j) * (t9296 + phi2)) + (229390 * (t9321 - t9322) * t9274) + (229390 * (t9321 + t9322) * t9270))

        if Bindx == 255:
            t9346 = np.cos(phi)
            t9345 = t9346 ** 2
            t9352 = t9345 ** 2
            t9356 = t9352 ** 2
            t9364 = t9356 ** 2
            t9330 = t9346 * t9364
            t9351 = t9346 * t9345
            t9354 = t9351 ** 2
            t9355 = t9346 * t9354
            t9362 = t9355 ** 2
            t9332 = t9346 * t9362
            t9360 = t9354 ** 2
            t9334 = t9346 * t9360
            t9353 = t9346 * t9352
            t9358 = t9353 ** 2
            t9336 = t9346 * t9358
            t9338 = t9346 * t9356
            t9371 = 12406200 * t9330 - 54427200 * t9332 + 96346080 * t9334 - 87753280 * t9336 + 43435408 * t9338 + 1656 * t9346 - 78016 * t9351 + 1440352 * t9353 - 11371200 * t9355
            t9370 = 211140 * t9345 - 2405616 * t9352 + 11775540 * t9354 - 29937030 * t9356 + 42912204 * t9358 - 35121000 * t9360 + 15359676 * t9362 - 2791395 * t9364 - 3519
            t9369 = 1240620 * t9330 - 5242620 * t9332 + 6933948 * t9334 + 595332 * t9336 - 10337580 * t9338 - 47472 * t9346 + 907212 * t9351 - 4784460 * t9353 + 10735020 * t9355
            t9368 = 285200 * t9345 - 4716288 * t9352 + 30110864 * t9354 - 95939624 * t9356 + 168707760 * t9358 - 166759200 * t9360 + 86923440 * t9362 - 18609300 * t9364 - 2852
            t9367 = 238700 * t9345 - 4830672 * t9352 + 37111228 * t9354 - 139707106 * t9356 + 285308100 * t9358 - 322740600 * t9360 + 190215060 * t9362 - 45592785 * t9364 - 1925
            t9366 = -60790380 * t9330 + 272576220 * t9332 - 507352860 * t9334 + 505961820 * t9336 - 290663604 * t9338 - 33264 * t9346 + 1382612 * t9351 - 17053652 * t9353 + 95973108 * t9355
            t9350 = 4 * phi1
            t9349 = 8 * phi1
            t9348 = -3 * phi2
            t9347 = 3 * phi2
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * ((94287120 * t9330 - 425812800 * t9332 + 793731840 * t9334 - 787159360 * t9336 + 445935776 * t9338 - 143805376 * t9355 + 24692096 * t9353 - 1912768 * t9351 + 43472 * t9346) * np.exp((3*1j) * phi2) + (t9369 + t9370) * np.exp((-3*1j) * (t9350 - phi2)) + (t9366 - t9367) * np.exp((-1*1j) * (t9350 + t9348)) + (t9368 + t9371) * np.exp((-1*1j) * (t9349 + t9348)) + (t9366 + t9367) * np.exp((1j) * (t9350 + t9347)) + (-t9368 + t9371) * np.exp((1j) * (t9349 + t9347)) + (t9369 - t9370) * np.exp((3*1j) * (t9350 + phi2))) * ((1 + t9346) ** (-0.1e1 / 0.2e1)) * ((1 - t9346) ** (-0.1e1 / 0.2e1))

        if Bindx == 256:
            t9397 = np.cos(phi)
            t9396 = t9397 ** 2
            t9403 = t9397 * t9396
            t9406 = t9403 ** 2
            t9404 = t9396 ** 2
            t9408 = t9404 ** 2
            t9405 = t9397 * t9404
            t9410 = t9405 ** 2
            t9412 = t9406 ** 2
            t9407 = t9397 * t9406
            t9414 = t9407 ** 2
            t9416 = t9408 ** 2
            t9425 = 65540 * t9396 - 458780 * t9406 + 1146950 * t9408 - 1376340 * t9410 + 917560 * t9412 - 327700 * t9414 + 49155 * t9416 - 16385
            t9381 = t9397 * t9416
            t9383 = t9397 * t9414
            t9387 = t9397 * t9410
            t9389 = t9397 * t9408
            t9424 = 16385 * t9381 - 65540 * t9383 + 458780 * t9387 - 1146950 * t9389 - 49155 * t9397 + 327700 * t9403 - 917560 * t9405 + 1376340 * t9407
            t9423 = -6120 * t9396 + 69728 * t9404 - 341320 * t9406 + 867740 * t9408 - 1243832 * t9410 + 1018000 * t9412 - 445208 * t9414 + 80910 * t9416 + 102
            t9385 = t9397 * t9412
            t9422 = 35960 * t9381 - 151960 * t9383 + 200984 * t9385 + 17256 * t9387 - 299640 * t9389 - 1376 * t9397 + 26296 * t9403 - 138680 * t9405 + 311160 * t9407
            t9421 = 10518300 * t9381 - 46144800 * t9383 + 81684720 * t9385 - 74399520 * t9387 + 36825672 * t9389 + 1404 * t9397 - 66144 * t9403 + 1221168 * t9405 - 9640800 * t9407
            t9420 = 241800 * t9396 - 3998592 * t9404 + 25528776 * t9406 - 81340116 * t9408 + 143034840 * t9410 - 141382800 * t9412 + 73695960 * t9414 - 15777450 * t9416 - 2418
            t9419 = -886600 * t9396 + 17942496 * t9404 - 137841704 * t9406 + 518912108 * t9408 - 1059715800 * t9410 + 1198750800 * t9412 - 706513080 * t9414 + 169344630 * t9416 + 7150
            t9418 = 225792840 * t9381 - 1012425960 * t9383 + 1884453480 * t9385 - 1879286760 * t9387 + 1079607672 * t9389 + 123552 * t9397 - 5135416 * t9403 + 63342136 * t9405 - 356471544 * t9407
            t9402 = 4 * phi1
            t9401 = 8 * phi1
            t9400 = -3 * phi2
            t9399 = 3 * phi2
            t9398 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.23e2) * np.sqrt(0.7e1) * ((1 + t9397) ** (-0.1e1 / 0.2e1)) * ((1 - t9397) ** (-0.1e1 / 0.2e1)) * ((601080390 * t9381 - 2714556600 * t9383 + 5060040480 * t9385 - 5018140920 * t9387 + 2842840572 * t9389 - 916759272 * t9407 + 157412112 * t9405 - 12193896 * t9403 + 277134 * t9397) * np.exp((3*1j) * phi2) + (t9424 - t9425) * np.exp((-1*1j) * (t9398 + t9400)) + (t9424 + t9425) * np.exp((1j) * (t9398 + t9399)) + (t9422 - t9423) * np.exp((-3*1j) * (t9402 - phi2)) + (t9418 - t9419) * np.exp((-1*1j) * (t9402 + t9400)) + (t9420 + t9421) * np.exp((-1*1j) * (t9401 + t9400)) + (t9418 + t9419) * np.exp((1j) * (t9402 + t9399)) + (-t9420 + t9421) * np.exp((1j) * (t9401 + t9399)) + (t9422 + t9423) * np.exp((3*1j) * (t9402 + phi2)))

        if Bindx == 257:
            t9448 = np.cos(phi)
            t9447 = t9448 ** 2
            t9451 = t9448 * t9447
            t9454 = t9451 ** 2
            t9455 = t9448 * t9454
            t9462 = t9455 ** 2
            t9434 = t9448 * t9462
            t9460 = t9454 ** 2
            t9436 = t9448 * t9460
            t9452 = t9447 ** 2
            t9453 = t9448 * t9452
            t9458 = t9453 ** 2
            t9438 = t9448 * t9458
            t9456 = t9452 ** 2
            t9440 = t9448 * t9456
            t9470 = -12096045 * t9434 + 53196585 * t9436 - 91606125 * t9438 + 76339185 * t9440 - 40365 * t9448 + 381225 * t9451 + 3691155 * t9453 - 29865615 * t9455
            t9469 = -80640300 * t9434 + 319959900 * t9436 - 510482700 * t9438 + 418363100 * t9440 + 143060 * t9448 - 4586660 * t9451 + 43460340 * t9453 - 186216740 * t9455
            t9468 = -197568735 * t9434 + 732916275 * t9436 - 1085670495 * t9438 + 816475275 * t9440 + 150689 * t9448 - 5943245 * t9451 + 66777249 * t9453 - 327165685 * t9455
            t9433 = t9456 ** 2
            t9467 = 4032015 * t9433 + 1255800 * t9447 - 11714820 * t9452 + 43594200 * t9454 - 77527710 * t9456 + 65768040 * t9458 - 18101460 * t9460 - 7283640 * t9462 - 22425
            t9466 = 40320150 * t9433 + 507840 * t9447 - 7143800 * t9452 + 32818240 * t9454 - 52802940 * t9456 - 11003200 * t9458 + 122171400 * t9460 - 124862400 * t9462 - 5290
            t9465 = -197568735 * t9433 + 766920 * t9447 - 15373820 * t9452 + 119731304 * t9454 - 466534530 * t9456 + 1002881880 * t9458 - 1208707500 * t9460 + 764782200 * t9462 - 6391
            t9450 = 2 * phi1
            t9449 = 3 * phi1
            tfunc[..., c] = -(0.33e2 / 0.29622272e8) * np.sqrt(0.2e1) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * ((306433140 * t9433 - 1265272320 * t9462 + 2117422320 * t9460 - 1839735040 * t9458 + 882372920 * t9456 - 228836608 * t9454 + 28995824 * t9452 - 1391104 * t9447 + 10868) * np.exp((4*1j) * phi2) + (t9465 - t9468) * np.exp((-4*1j) * (phi1 - phi2)) + (t9466 + t9469) * np.exp((-4*1j) * (t9450 - phi2)) + (t9467 + t9470) * np.exp((-4*1j) * (t9449 - phi2)) + (t9465 + t9468) * np.exp((4*1j) * (phi1 + phi2)) + (t9466 - t9469) * np.exp((4*1j) * (t9450 + phi2)) + (t9467 - t9470) * np.exp((4*1j) * (t9449 + phi2)))

        if Bindx == 258:
            t9495 = np.cos(phi)
            t9494 = t9495 ** 2
            t9500 = t9494 ** 2
            t9499 = t9495 * t9494
            t9502 = t9499 ** 2
            t9508 = t9502 ** 2
            t9522 = -t9500 - t9508
            t9483 = t9495 * t9508
            t9504 = t9500 ** 2
            t9487 = t9495 * t9504
            t9503 = t9495 * t9502
            t9521 = -t9483 - t9487 - t9499 - t9503
            t9510 = t9503 ** 2
            t9481 = t9495 * t9510
            t9501 = t9495 * t9500
            t9506 = t9501 ** 2
            t9485 = t9495 * t9506
            t9520 = -65540 * t9481 - 65540 * t9495 - 589860 * t9485 - 589860 * t9501
            t9480 = t9504 ** 2
            t9519 = 16385 * t9480 + 1048640 * t9502 - 1474650 * t9504 + 1048640 * t9506 + 16385
            t9518 = -107880 * t9481 + 474440 * t9483 - 817000 * t9485 + 680840 * t9487 - 360 * t9495 + 3400 * t9499 + 32920 * t9501 - 266360 * t9503
            t9517 = 35960 * t9480 + 11200 * t9494 - 104480 * t9500 + 388800 * t9502 - 691440 * t9504 + 586560 * t9506 - 161440 * t9508 - 64960 * t9510 - 200
            t9516 = -21036600 * t9481 + 83467800 * t9483 - 133169400 * t9485 + 109138200 * t9487 + 37320 * t9495 - 1196520 * t9499 + 11337480 * t9501 - 48578280 * t9503
            t9515 = 10518300 * t9480 + 132480 * t9494 - 1863600 * t9500 + 8561280 * t9502 - 13774680 * t9504 - 2870400 * t9506 + 31870800 * t9508 - 32572800 * t9510 - 1380
            t9514 = -225792840 * t9481 + 837618600 * t9483 - 1240766280 * t9485 + 933114600 * t9487 + 172216 * t9495 - 6792280 * t9499 + 76316856 * t9501 - 373903640 * t9503
            t9513 = 225792840 * t9480 - 876480 * t9494 + 17570080 * t9500 - 136835776 * t9502 + 533182320 * t9504 - 1146150720 * t9506 + 1381380000 * t9508 - 874036800 * t9510 + 7304
            t9498 = 2 * phi1
            t9497 = 3 * phi1
            t9496 = 4 * phi1
            t9475 = np.exp((-4*1j) * (t9496 - phi2))
            t9471 = np.exp((4*1j) * (t9496 + phi2))
            tfunc[..., c] = (0.33e2 / 0.473956352e9) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.7e1) * ((601080390 * t9480 - 2481880320 * t9510 + 4153405320 * t9508 - 3608711040 * t9506 + 1730808420 * t9504 - 448871808 * t9502 + 56876424 * t9500 - 2728704 * t9494 + 21318) * np.exp((4*1j) * phi2) + ((t9519 + t9520) * t9475) + ((t9519 - t9520) * t9471) + (t9513 + t9514) * np.exp((-4*1j) * (phi1 - phi2)) + (t9515 + t9516) * np.exp((-4*1j) * (t9498 - phi2)) + (t9517 + t9518) * np.exp((-4*1j) * (t9497 - phi2)) + (t9513 - t9514) * np.exp((4*1j) * (phi1 + phi2)) + (t9515 - t9516) * np.exp((4*1j) * (t9498 + phi2)) + (t9517 - t9518) * np.exp((4*1j) * (t9497 + phi2)) + (327700 * (-t9521 + t9522) * t9475) + (327700 * (t9521 + t9522) * t9471))

        if Bindx == 259:
            t9546 = np.cos(phi)
            t9545 = t9546 ** 2
            t9553 = t9545 ** 2
            t9552 = t9546 * t9545
            t9555 = t9552 ** 2
            t9557 = t9553 ** 2
            t9554 = t9546 * t9553
            t9559 = t9554 ** 2
            t9561 = t9555 ** 2
            t9556 = t9546 * t9555
            t9563 = t9556 ** 2
            t9565 = t9557 ** 2
            t9572 = 3089360 * t9545 - 51854880 * t9553 + 361477200 * t9555 - 1300498200 * t9557 + 2598383600 * t9559 - 2903409600 * t9561 + 1696047600 * t9563 - 403201500 * t9565 - 33580
            t9571 = 6815116 * t9545 - 129812760 * t9553 + 945287420 * t9555 - 3398637550 * t9557 + 6678759780 * t9559 - 7320811680 * t9561 + 4206302100 * t9563 - 987843675 * t9565 - 58751
            t9570 = 5364060 * t9545 - 40580280 * t9553 + 103459980 * t9555 - 51227670 * t9557 - 200048940 * t9559 + 371860320 * t9561 - 249204540 * t9563 + 60480225 * t9565 - 103155
            t9530 = t9546 * t9565
            t9532 = t9546 * t9563
            t9534 = t9546 * t9561
            t9536 = t9546 * t9559
            t9538 = t9546 * t9557
            t9569 = 16128060 * t9530 + 2601300 * t9532 - 227066580 * t9534 + 570366420 * t9536 - 627953820 * t9538 - 645840 * t9546 + 13257660 * t9552 - 101953020 * t9554 + 355265820 * t9556
            t9568 = 161280600 * t9530 - 416208000 * t9532 + 55255200 * t9534 + 850595200 * t9536 - 1149361520 * t9538 - 713000 * t9546 + 21417600 * t9552 - 181530720 * t9554 + 659264640 * t9556
            t9567 = -790274940 * t9530 + 3339548940 * t9532 - 5814981900 * t9534 + 5393033100 * t9536 - 2876351940 * t9538 - 301840 * t9546 + 12062820 * t9552 - 150426276 * t9554 + 887692036 * t9556
            t9551 = 4 * phi1
            t9550 = 8 * phi1
            t9549 = -5 * phi2
            t9548 = 5 * phi2
            t9547 = 12 * phi1
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * ((1225732560 * t9530 - 5851884480 * t9532 + 11551063680 * t9534 - 12149159360 * t9536 + 7308947360 * t9538 - 2505552192 * t9556 + 457673216 * t9554 - 37733696 * t9552 + 912912 * t9546) * np.exp((5*1j) * phi2) + (t9567 - t9571) * np.exp((-1*1j) * (t9551 + t9549)) + (t9568 + t9572) * np.exp((-1*1j) * (t9550 + t9549)) + (t9567 + t9571) * np.exp((1j) * (t9551 + t9548)) + (t9568 - t9572) * np.exp((1j) * (t9550 + t9548)) + (t9569 - t9570) * np.exp((-1*1j) * (t9547 + t9549)) + (t9569 + t9570) * np.exp((1j) * (t9547 + t9548))) * ((1 + t9546) ** (-0.1e1 / 0.2e1)) * ((1 - t9546) ** (-0.1e1 / 0.2e1))

        if Bindx == 260:
            t9598 = np.cos(phi)
            t9597 = t9598 ** 2
            t9606 = t9597 ** 2
            t9610 = t9606 ** 2
            t9618 = t9610 ** 2
            t9582 = t9598 * t9618
            t9605 = t9598 * t9597
            t9608 = t9605 ** 2
            t9609 = t9598 * t9608
            t9616 = t9609 ** 2
            t9584 = t9598 * t9616
            t9614 = t9608 ** 2
            t9586 = t9598 * t9614
            t9607 = t9598 * t9606
            t9612 = t9607 ** 2
            t9588 = t9598 * t9612
            t9590 = t9598 * t9610
            t9627 = 35960 * t9582 + 5800 * t9584 - 506280 * t9586 + 1271720 * t9588 - 1400120 * t9590 - 1440 * t9598 + 29560 * t9605 - 227320 * t9607 + 792120 * t9609
            t9626 = -11960 * t9597 + 90480 * t9606 - 230680 * t9608 + 114220 * t9610 + 446040 * t9612 - 829120 * t9614 + 555640 * t9616 - 134850 * t9618 + 230
            t9625 = 65540 * t9597 - 655400 * t9606 + 1638500 * t9608 - 1802350 * t9610 + 720940 * t9612 + 262160 * t9614 - 327700 * t9616 + 81925 * t9618 + 16385
            t9624 = 16385 * t9582 + 65540 * t9584 - 655400 * t9586 + 1638500 * t9588 - 1802350 * t9590 + 81925 * t9598 - 327700 * t9605 + 262160 * t9607 + 720940 * t9609
            t9623 = 201480 * t9597 - 3381840 * t9606 + 23574600 * t9608 - 84815100 * t9610 + 169459800 * t9612 - 189352800 * t9614 + 110611800 * t9616 - 26295750 * t9618 - 2190
            t9622 = 10518300 * t9582 - 27144000 * t9584 + 3603600 * t9586 + 55473600 * t9588 - 74958360 * t9590 - 46500 * t9598 + 1396800 * t9605 - 11838960 * t9607 + 42995520 * t9609
            t9621 = 1947176 * t9597 - 37089360 * t9606 + 270082120 * t9608 - 971039300 * t9610 + 1908217080 * t9612 - 2091660480 * t9614 + 1201800600 * t9616 - 282241050 * t9618 - 16786
            t9620 = 225792840 * t9582 - 954156840 * t9584 + 1661423400 * t9586 - 1540866600 * t9588 + 821814840 * t9590 + 86240 * t9598 - 3446520 * t9605 + 42978936 * t9607 - 253626296 * t9609
            t9604 = 4 * phi1
            t9603 = 8 * phi1
            t9602 = -5 * phi2
            t9601 = 5 * phi2
            t9600 = 12 * phi1
            t9599 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.113e3) * np.sqrt(0.13e2) * np.sqrt(0.23e2) * np.sqrt(0.31e2) * ((1 + t9598) ** (-0.1e1 / 0.2e1)) * ((1 - t9598) ** (-0.1e1 / 0.2e1)) * ((601080390 * t9582 - 2869674120 * t9584 + 5664463920 * t9586 - 5957760840 * t9588 + 3584195340 * t9590 - 1228684248 * t9609 + 224435904 * t9607 - 18504024 * t9605 + 447678 * t9598) * np.exp((5*1j) * phi2) + (t9620 + t9621) * np.exp((-1*1j) * (t9604 + t9602)) + (t9622 + t9623) * np.exp((-1*1j) * (t9603 + t9602)) + (t9620 - t9621) * np.exp((1j) * (t9604 + t9601)) + (t9622 - t9623) * np.exp((1j) * (t9603 + t9601)) + (t9626 + t9627) * np.exp((-1*1j) * (t9600 + t9602)) + (t9624 - t9625) * np.exp((-1*1j) * (t9599 + t9602)) + (-t9626 + t9627) * np.exp((1j) * (t9600 + t9601)) + (t9624 + t9625) * np.exp((1j) * (t9599 + t9601)))

        if Bindx == 261:
            t9650 = np.cos(phi)
            t9649 = t9650 ** 2
            t9655 = t9650 * t9649
            t9658 = t9655 ** 2
            t9659 = t9650 * t9658
            t9666 = t9659 ** 2
            t9636 = t9650 * t9666
            t9664 = t9658 ** 2
            t9638 = t9650 * t9664
            t9656 = t9649 ** 2
            t9657 = t9650 * t9656
            t9662 = t9657 ** 2
            t9640 = t9650 * t9662
            t9660 = t9656 ** 2
            t9642 = t9650 * t9660
            t9674 = -241920900 * t9636 + 819409500 * t9638 - 1071825300 * t9640 + 674978700 * t9642 + 12420 * t9650 - 1065820 * t9655 + 26793620 * t9657 - 206382220 * t9659
            t9673 = -36288135 * t9636 + 96898425 * t9638 - 39248235 * t9640 - 111151755 * t9642 - 811785 * t9650 + 12822615 * t9655 - 67315365 * t9657 + 145094235 * t9659
            t9635 = t9660 ** 2
            t9672 = 8064030 * t9635 - 1237860 * t9649 - 466440 * t9656 + 51505740 * t9658 - 193590540 * t9660 + 286340340 * t9662 - 180297000 * t9664 + 29654820 * t9666 + 26910
            t9671 = 592706205 * t9636 - 2262480675 * t9638 + 3468111465 * t9640 - 2719929975 * t9642 - 658413 * t9650 + 23898035 * t9655 - 249456697 * t9657 + 1147810055 * t9659
            t9670 = 80640300 * t9635 + 3837320 * t9649 - 53355400 * t9656 + 279605480 * t9658 - 693462880 * t9660 + 833432600 * t9662 - 383019000 * t9664 - 67633800 * t9666 - 44620
            t9669 = -395137470 * t9635 + 334180 * t9649 - 8606360 * t9656 + 95133108 * t9658 - 503971860 * t9660 + 1370454540 * t9662 - 1960303800 * t9664 + 1402100700 * t9666 - 3038
            t9654 = 2 * phi1
            t9653 = 4 * phi1
            t9652 = -3 * phi2
            t9651 = 3 * phi2
            tfunc[..., c] = -(0.33e2 / 0.29622272e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * ((612866280 * t9635 - 2728243440 * t9666 + 4937016240 * t9664 - 4649784880 * t9662 + 2421469440 * t9660 - 682443216 * t9658 + 93974608 * t9656 - 4896528 * t9649 + 41496) * np.exp((6*1j) * phi2) + (t9672 + t9673) * np.exp((-6*1j) * (t9654 - phi2)) + (t9669 + t9671) * np.exp((-2*1j) * (t9654 + t9652)) + (t9670 + t9674) * np.exp((-2*1j) * (t9653 + t9652)) + (t9669 - t9671) * np.exp((2*1j) * (t9654 + t9651)) + (t9670 - t9674) * np.exp((2*1j) * (t9653 + t9651)) + (t9672 - t9673) * np.exp((6*1j) * (t9654 + phi2)))

        if Bindx == 262:
            t9699 = np.cos(phi)
            t9698 = t9699 ** 2
            t9706 = t9698 ** 2
            t9710 = t9706 ** 2
            t9684 = t9710 ** 2
            t9705 = t9699 * t9698
            t9708 = t9705 ** 2
            t9707 = t9699 * t9706
            t9712 = t9707 ** 2
            t9714 = t9708 ** 2
            t9709 = t9699 * t9708
            t9716 = t9709 ** 2
            t9726 = 35960 * t9684 - 5520 * t9698 - 2080 * t9706 + 229680 * t9708 - 863280 * t9710 + 1276880 * t9712 - 804000 * t9714 + 132240 * t9716 + 120
            t9725 = 16385 * t9684 + 819250 * t9706 - 1081410 * t9708 + 1081410 * t9712 - 819250 * t9714 - 16385 - 163850 * t9698 + 163850 * t9716
            t9685 = t9699 * t9716
            t9687 = t9699 * t9714
            t9689 = t9699 * t9712
            t9691 = t9699 * t9710
            t9724 = -161820 * t9685 + 432100 * t9687 - 175020 * t9689 - 495660 * t9691 - 3620 * t9699 + 57180 * t9705 - 300180 * t9707 + 647020 * t9709
            t9723 = 98310 * t9685 - 557090 * t9689 + 1802350 * t9691 - 98310 * t9699 + 557090 * t9707 - 1802350 * t9709 - 163850 * t9687 + 163850 * t9705
            t9722 = -31554900 * t9685 + 106879500 * t9687 - 139803300 * t9689 + 88040700 * t9691 + 1620 * t9699 - 139020 * t9705 + 3494820 * t9707 - 26919420 * t9709
            t9721 = 10518300 * t9684 + 500520 * t9698 - 6959400 * t9706 + 36470280 * t9708 - 90451680 * t9710 + 108708600 * t9712 - 49959000 * t9714 - 8821800 * t9716 - 5820
            t9720 = -338689260 * t9685 + 1292846100 * t9687 - 1981777980 * t9689 + 1554245700 * t9691 + 376236 * t9699 - 13656020 * t9705 + 142546684 * t9707 - 655891460 * t9709
            t9719 = 225792840 * t9684 - 190960 * t9698 + 4917920 * t9706 - 54361776 * t9708 + 287983920 * t9710 - 783116880 * t9712 + 1120173600 * t9714 - 801200400 * t9716 + 1736
            t9704 = 2 * phi1
            t9703 = 4 * phi1
            t9702 = 8 * phi1
            t9701 = -3 * phi2
            t9700 = 3 * phi2
            tfunc[..., c] = (0.33e2 / 0.473956352e9) * np.sqrt(0.2e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.13e2) * np.sqrt(0.23e2) * ((40698 + 601080390 * t9684 - 2675777220 * t9716 + 4842073620 * t9714 - 4560365940 * t9712 + 2374902720 * t9710 - 669319308 * t9708 + 92167404 * t9706 - 4802364 * t9698) * np.exp((6*1j) * phi2) + (-t9723 + t9725) * np.exp((-2*1j) * (t9702 + t9701)) + (t9723 + t9725) * np.exp((2*1j) * (t9702 + t9700)) + (t9724 + t9726) * np.exp((-6*1j) * (t9704 - phi2)) + (t9719 + t9720) * np.exp((-2*1j) * (t9704 + t9701)) + (t9721 + t9722) * np.exp((-2*1j) * (t9703 + t9701)) + (t9719 - t9720) * np.exp((2*1j) * (t9704 + t9700)) + (t9721 - t9722) * np.exp((2*1j) * (t9703 + t9700)) + (-t9724 + t9726) * np.exp((6*1j) * (t9704 + phi2)))

        if Bindx == 263:
            t9750 = np.cos(phi)
            t9749 = t9750 ** 2
            t9757 = t9749 ** 2
            t9756 = t9750 * t9749
            t9759 = t9756 ** 2
            t9761 = t9757 ** 2
            t9758 = t9750 * t9757
            t9763 = t9758 ** 2
            t9765 = t9759 ** 2
            t9760 = t9750 * t9759
            t9767 = t9760 ** 2
            t9769 = t9761 ** 2
            t9776 = 170040 * t9749 - 2640924 * t9757 + 13620984 * t9759 - 30161274 * t9761 + 29024424 * t9763 - 6153420 * t9765 - 7536984 * t9767 + 3681405 * t9769 - 4251
            t9775 = 239680 * t9749 - 2574544 * t9757 + 7121408 * t9759 + 6378152 * t9761 - 62152640 * t9763 + 112585200 * t9765 - 86136960 * t9767 + 24542700 * t9769 - 2996
            t9774 = 606424 * t9749 - 10521868 * t9757 + 71006488 * t9759 - 240374498 * t9761 + 450355080 * t9763 - 474730620 * t9765 + 263794440 * t9767 - 60129615 * t9769 - 5831
            t9734 = t9750 * t9769
            t9736 = t9750 * t9767
            t9738 = t9750 * t9765
            t9740 = t9750 * t9763
            t9742 = t9750 * t9761
            t9773 = 7012200 * t9734 + 904800 * t9736 - 68752320 * t9738 + 143517920 * t9740 - 131487664 * t9742 - 65272 * t9750 + 1796512 * t9756 - 15524096 * t9758 + 62597920 * t9760
            t9772 = -34359780 * t9734 + 131897220 * t9736 - 194272260 * t9738 + 131591460 * t9740 - 33328428 * t9742 + 17248 * t9750 - 543508 * t9756 + 3862964 * t9758 - 4864916 * t9760
            t9771 = 701220 * t9734 + 4727580 * t9736 - 23128092 * t9738 + 32868732 * t9740 - 16667508 * t9742 + 104832 * t9750 - 1278732 * t9756 + 4345068 * t9758 - 1673100 * t9760
            t9755 = 4 * phi1
            t9754 = 8 * phi1
            t9753 = -7 * phi2
            t9752 = 7 * phi2
            t9751 = 12 * phi1
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * ((53292720 * t9734 - 275059200 * t9736 + 589717440 * t9738 - 676898560 * t9740 + 446441632 * t9742 - 168450048 * t9760 + 33971392 * t9758 - 3098368 * t9756 + 82992 * t9750) * np.exp((7*1j) * phi2) + (t9772 - t9774) * np.exp((-1*1j) * (t9755 + t9753)) + (t9773 - t9775) * np.exp((-1*1j) * (t9754 + t9753)) + (t9772 + t9774) * np.exp((1j) * (t9755 + t9752)) + (t9773 + t9775) * np.exp((1j) * (t9754 + t9752)) + (t9771 - t9776) * np.exp((-1*1j) * (t9751 + t9753)) + (t9771 + t9776) * np.exp((1j) * (t9751 + t9752))) * ((1 + t9750) ** (-0.1e1 / 0.2e1)) * ((1 - t9750) ** (-0.1e1 / 0.2e1))

        if Bindx == 264:
            t9802 = np.cos(phi)
            t9801 = t9802 ** 2
            t9810 = t9801 ** 2
            t9814 = t9810 ** 2
            t9822 = t9814 ** 2
            t9786 = t9802 * t9822
            t9809 = t9802 * t9801
            t9812 = t9809 ** 2
            t9813 = t9802 * t9812
            t9820 = t9813 ** 2
            t9788 = t9802 * t9820
            t9818 = t9812 ** 2
            t9790 = t9802 * t9818
            t9811 = t9802 * t9810
            t9816 = t9811 ** 2
            t9792 = t9802 * t9816
            t9794 = t9802 * t9814
            t9831 = 35960 * t9786 + 242440 * t9788 - 1186056 * t9790 + 1685576 * t9792 - 854744 * t9794 + 5376 * t9802 - 65576 * t9809 + 222824 * t9811 - 85800 * t9813
            t9830 = -262160 * t9801 + 983100 * t9810 - 524320 * t9812 - 1802350 * t9814 + 2883760 * t9816 - 1376340 * t9818 + 114695 * t9822 - 16385
            t9829 = 16385 * t9786 + 262160 * t9788 - 983100 * t9790 + 524320 * t9792 + 1802350 * t9794 - 114695 * t9802 + 1376340 * t9811 - 2883760 * t9813
            t9828 = 8720 * t9801 - 135432 * t9810 + 698512 * t9812 - 1546732 * t9814 + 1488432 * t9816 - 315560 * t9818 - 386512 * t9820 + 188790 * t9822 - 218
            t9827 = 359520 * t9801 - 3861816 * t9810 + 10682112 * t9812 + 9567228 * t9814 - 93228960 * t9816 + 168877800 * t9818 - 129205440 * t9820 + 36814050 * t9822 - 4494
            t9826 = 10518300 * t9786 + 1357200 * t9788 - 103128480 * t9790 + 215276880 * t9792 - 197231496 * t9794 - 97908 * t9802 + 2694768 * t9809 - 23286144 * t9811 + 93896880 * t9813
            t9825 = 3985072 * t9801 - 69143704 * t9810 + 466614064 * t9812 - 1579603844 * t9814 + 2959476240 * t9816 - 3119658360 * t9818 + 1733506320 * t9820 - 395137470 * t9822 - 38318
            t9824 = 225792840 * t9786 - 866753160 * t9788 + 1276646280 * t9790 - 864743880 * t9792 + 219015384 * t9794 - 113344 * t9802 + 3571624 * t9809 - 25385192 * t9811 + 31969448 * t9813
            t9808 = 4 * phi1
            t9807 = 8 * phi1
            t9806 = -7 * phi2
            t9805 = 7 * phi2
            t9804 = 12 * phi1
            t9803 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.13e2) * np.sqrt(0.31e2) * ((1 + t9802) ** (-0.1e1 / 0.2e1)) * ((1 - t9802) ** (-0.1e1 / 0.2e1)) * ((-1899922176 * t9813 + 383158104 * t9811 - 34946016 * t9809 + 936054 * t9802 + 601080390 * t9786 - 3102350400 * t9788 + 6651332280 * t9790 - 7634634720 * t9792 + 5035346484 * t9794) * np.exp((7*1j) * phi2) + (t9829 - t9830) * np.exp((-1*1j) * (t9803 + t9806)) + (t9829 + t9830) * np.exp((1j) * (t9803 + t9805)) + (t9824 + t9825) * np.exp((-1*1j) * (t9808 + t9806)) + (t9826 - t9827) * np.exp((-1*1j) * (t9807 + t9806)) + (t9824 - t9825) * np.exp((1j) * (t9808 + t9805)) + (t9826 + t9827) * np.exp((1j) * (t9807 + t9805)) + (-t9828 + t9831) * np.exp((-1*1j) * (t9804 + t9806)) + (t9828 + t9831) * np.exp((1j) * (t9804 + t9805)))

        if Bindx == 265:
            t9854 = np.cos(phi)
            t9853 = t9854 ** 2
            t9858 = t9854 * t9853
            t9861 = t9858 ** 2
            t9862 = t9854 * t9861
            t9869 = t9862 ** 2
            t9840 = t9854 * t9869
            t9867 = t9861 ** 2
            t9842 = t9854 * t9867
            t9859 = t9853 ** 2
            t9860 = t9854 * t9859
            t9865 = t9860 ** 2
            t9844 = t9854 * t9865
            t9863 = t9859 ** 2
            t9846 = t9854 * t9863
            t9877 = -3155490 * t9840 + 793962 * t9842 + 17180046 * t9844 - 26679510 * t9846 + 79326 * t9854 - 404118 * t9858 - 1989234 * t9860 + 14175018 * t9862
            t9876 = -21036600 * t9840 + 54152280 * t9842 - 38034360 * t9844 - 10769000 * t9846 - 81464 * t9854 + 1854552 * t9858 - 11197368 * t9860 + 25095576 * t9862
            t9875 = -51539670 * t9840 + 204496110 * t9842 - 326265030 * t9844 + 267388590 * t9846 + 91434 * t9854 - 2931474 * t9858 + 27776826 * t9860 - 119016786 * t9862
            t9839 = t9863 ** 2
            t9874 = 525915 * t9839 - 415584 * t9853 + 3502980 * t9859 - 10007712 * t9861 + 7513506 * t9863 + 10007712 * t9865 - 17111484 * t9867 + 5971680 * t9869 + 12987
            t9873 = -25769835 * t9839 - 324576 * t9853 + 4565820 * t9859 - 20975136 * t9861 + 33747966 * t9863 + 7032480 * t9865 - 78083460 * t9867 + 79803360 * t9869 + 3381
            t9872 = 5259150 * t9839 + 247824 * t9853 - 3755640 * t9859 + 24131184 * t9861 - 73520172 * t9863 + 110430320 * t9865 - 74987640 * t9867 + 12214800 * t9869 - 3442
            t9857 = 3 * phi1
            t9856 = -2 * phi2
            t9855 = 2 * phi2
            tfunc[..., c] = -(0.11e2 / 0.29622272e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.23e2) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * ((39969540 * t9839 - 195979680 * t9869 + 393559920 * t9867 - 414525280 * t9865 + 243168536 * t9863 - 77625184 * t9861 + 12144496 * t9859 - 719264 * t9853 + 6916) * np.exp((8*1j) * phi2) + (t9872 + t9876) * np.exp((-8*1j) * (phi1 - phi2)) + (t9873 - t9875) * np.exp((-4*1j) * (phi1 + t9856)) + (t9874 + t9877) * np.exp((-4*1j) * (t9857 + t9856)) + (t9873 + t9875) * np.exp((4*1j) * (phi1 + t9855)) + (t9874 - t9877) * np.exp((4*1j) * (t9857 + t9855)) + (t9872 - t9876) * np.exp((8*1j) * (phi1 + phi2)))

        if Bindx == 266:
            t9902 = np.cos(phi)
            t9901 = t9902 ** 2
            t9907 = t9902 * t9901
            t9910 = t9907 ** 2
            t9911 = t9902 * t9910
            t9918 = t9911 ** 2
            t9888 = t9902 * t9918
            t9916 = t9910 ** 2
            t9890 = t9902 * t9916
            t9908 = t9901 ** 2
            t9909 = t9902 * t9908
            t9914 = t9909 ** 2
            t9892 = t9902 * t9914
            t9912 = t9908 ** 2
            t9894 = t9902 * t9912
            t9928 = -215760 * t9888 + 54288 * t9890 + 1174704 * t9892 - 1824240 * t9894 + 5424 * t9902 - 27632 * t9907 - 136016 * t9909 + 969232 * t9911
            t9887 = t9912 ** 2
            t9927 = 35960 * t9887 - 28416 * t9901 + 239520 * t9908 + 513744 * t9912 - 1170016 * t9916 + 408320 * t9918 + 888 + 684288 * t9914 - 684288 * t9910
            t9926 = 16385 * t9887 + 3244230 * t9912 + 16385 - 1441880 * t9910 - 1441880 * t9914 - 589860 * t9916 - 589860 * t9908 + 393240 * t9901 + 393240 * t9918
            t9925 = 1966200 * t9892 + 1966200 * t9909 - 1441880 * t9894 - 1441880 * t9911 - 393240 * t9890 - 393240 * t9907 - 131080 * t9888 - 131080 * t9902
            t9924 = -42073200 * t9888 + 108304560 * t9890 - 76068720 * t9892 - 21538000 * t9894 - 162928 * t9902 + 3709104 * t9907 - 22394736 * t9909 + 50191152 * t9911
            t9923 = 10518300 * t9887 + 495648 * t9901 - 7511280 * t9908 + 48262368 * t9910 - 147040344 * t9912 + 220860640 * t9914 - 149975280 * t9916 + 24429600 * t9918 - 6884
            t9922 = -451585680 * t9888 + 1791775440 * t9890 - 2858703120 * t9892 + 2342833360 * t9894 + 801136 * t9902 - 25685296 * t9907 + 243377904 * t9909 - 1042813744 * t9911
            t9921 = 225792840 * t9887 + 2843904 * t9901 - 40005280 * t9908 + 183782144 * t9910 - 295696464 * t9912 - 61617920 * t9914 + 684159840 * t9916 - 699229440 * t9918 - 29624
            t9906 = 2 * phi1
            t9905 = 3 * phi1
            t9904 = -2 * phi2
            t9903 = 2 * phi2
            tfunc[..., c] = (0.33e2 / 0.947912704e9) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * np.sqrt(0.13e2) * ((104006 + 601080390 * t9887 - 2947232880 * t9918 + 5918535720 * t9916 - 6233822480 * t9914 + 3656880676 * t9912 - 1167363344 * t9910 + 182634536 * t9908 - 10816624 * t9901) * np.exp((8*1j) * phi2) + (t9923 + t9924) * np.exp((-8*1j) * (phi1 - phi2)) + (t9925 + t9926) * np.exp((-8*1j) * (t9906 - phi2)) + (t9921 + t9922) * np.exp((-4*1j) * (phi1 + t9904)) + (t9927 + t9928) * np.exp((-4*1j) * (t9905 + t9904)) + (t9921 - t9922) * np.exp((4*1j) * (phi1 + t9903)) + (t9927 - t9928) * np.exp((4*1j) * (t9905 + t9903)) + (t9923 - t9924) * np.exp((8*1j) * (phi1 + phi2)) + (-t9925 + t9926) * np.exp((8*1j) * (t9906 + phi2)))

        if Bindx == 267:
            t9952 = np.cos(phi)
            t9951 = t9952 ** 2
            t9958 = t9951 ** 2
            t9957 = t9952 * t9951
            t9960 = t9957 ** 2
            t9962 = t9958 ** 2
            t9959 = t9952 * t9958
            t9964 = t9959 ** 2
            t9966 = t9960 ** 2
            t9961 = t9952 * t9960
            t9968 = t9961 ** 2
            t9970 = t9962 ** 2
            t9977 = 564408 * t9951 - 3006900 * t9958 + 2683512 * t9960 + 13577850 * t9962 - 33575256 * t9964 + 24655644 * t9966 - 2035800 * t9968 - 2839941 * t9970 - 23517
            t9976 = 697600 * t9951 - 7675920 * t9958 + 33512640 * t9960 - 65998680 * t9962 + 47583360 * t9964 + 21818160 * t9966 - 48859200 * t9968 + 18932940 * t9970 - 10900
            t9936 = t9952 * t9970
            t9938 = t9952 * t9968
            t9940 = t9952 * t9966
            t9942 = t9952 * t9964
            t9944 = t9952 * t9962
            t9975 = 420732 * t9936 + 6528132 * t9938 - 16157700 * t9940 + 1919268 * t9942 + 22007700 * t9944 - 22464 * t9952 - 666900 * t9957 + 6990516 * t9959 - 21019284 * t9961
            t9974 = 685608 * t9951 - 10596348 * t9958 + 66588648 * t9960 - 215248866 * t9962 + 388443384 * t9964 - 394957836 * t9966 + 211478904 * t9968 - 46385703 * t9970 - 7791
            t9973 = 4207320 * t9936 + 15743520 * t9938 - 90417600 * t9940 + 142498720 * t9942 - 101815120 * t9944 + 18360 * t9952 - 130080 * t9957 - 4018560 * t9959 + 33913440 * t9961
            t9972 = -20615868 * t9936 + 68497884 * t9938 - 61159644 * t9940 - 35399364 * t9942 + 99922956 * t9944 + 98784 * t9952 - 2804172 * t9957 + 21869484 * t9959 - 70410060 * t9961
            t9956 = 4 * phi1
            t9955 = 8 * phi1
            t9954 = -9 * phi2
            t9953 = 9 * phi2
            tfunc[..., c] = (-0.11e2 / 0.59244544e8*1j) * np.sqrt(0.17e2) * np.sqrt(0.226e3) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.3e1) * ((1 + t9952) ** (-0.1e1 / 0.2e1)) * ((1 - t9952) ** (-0.1e1 / 0.2e1)) * ((31975632 * t9936 - 181539072 * t9938 + 431795520 * t9940 - 555176960 * t9942 + 414525280 * t9944 - 179009792 * t9961 + 41717312 * t9959 - 4426240 * t9957 + 138320 * t9952) * np.exp((9*1j) * phi2) + (t9975 + t9977) * np.exp((-3*1j) * (t9956 - 3 * phi2)) + (t9972 - t9974) * np.exp((-1*1j) * (t9956 + t9954)) + (t9973 - t9976) * np.exp((-1*1j) * (t9955 + t9954)) + (t9972 + t9974) * np.exp((1j) * (t9956 + t9953)) + (t9973 + t9976) * np.exp((1j) * (t9955 + t9953)) + (t9975 - t9977) * np.exp((3*1j) * (t9956 + 3 * phi2)))

        if Bindx == 268:
            t10003 = np.cos(phi)
            t10002 = t10003 ** 2
            t10010 = t10002 ** 2
            t10009 = t10003 * t10002
            t10012 = t10009 ** 2
            t10014 = t10010 ** 2
            t10011 = t10003 * t10010
            t10016 = t10011 ** 2
            t10018 = t10012 ** 2
            t10013 = t10003 * t10012
            t10020 = t10013 ** 2
            t10022 = t10014 ** 2
            t10031 = -9648 * t10002 + 51400 * t10010 - 45872 * t10012 - 232100 * t10014 + 573936 * t10016 - 421464 * t10018 + 34800 * t10020 + 48546 * t10022 + 402
            t10030 = -104864 * t10002 + 39324 * t10010 + 681616 * t10012 - 937222 * t10014 + 511212 * t10018 - 157296 * t10020 - 29493 * t10022 - 3277
            t9987 = t10003 * t10022
            t9989 = t10003 * t10020
            t9991 = t10003 * t10018
            t9993 = t10003 * t10016
            t9995 = t10003 * t10014
            t10029 = 29493 * t10003 + 157296 * t10009 - 511212 * t10011 + 3277 * t9987 + 104864 * t9989 - 39324 * t9991 - 681616 * t9993 + 937222 * t9995
            t10028 = -384 * t10003 - 11400 * t10009 + 119496 * t10011 - 359304 * t10013 + 7192 * t9987 + 111592 * t9989 - 276200 * t9991 + 32808 * t9993 + 376200 * t9995
            t10027 = 9180 * t10003 - 65040 * t10009 - 2009280 * t10011 + 16956720 * t10013 + 2103660 * t9987 + 7871760 * t9989 - 45208800 * t9991 + 71249360 * t9993 - 50907560 * t9995
            t10026 = -348800 * t10002 + 3837960 * t10010 - 16756320 * t10012 + 32999340 * t10014 - 23791680 * t10016 - 10909080 * t10018 + 24429600 * t10020 - 9466470 * t10022 + 5450
            t10025 = 1501808 * t10002 - 23211048 * t10010 + 145860848 * t10012 - 471497516 * t10014 + 850875984 * t10016 - 865145736 * t10018 + 463239504 * t10020 - 101606778 * t10022 - 17066
            t10024 = -216384 * t10003 + 6142472 * t10009 - 47904584 * t10011 + 154231560 * t10013 + 45158568 * t9987 - 150042984 * t9989 + 133968744 * t9991 + 77541464 * t9993 - 218878856 * t9995
            t10008 = 4 * phi1
            t10007 = 8 * phi1
            t10006 = -9 * phi2
            t10005 = 9 * phi2
            t10004 = 16 * phi1
            tfunc[..., c] = (0.33e2 / 0.236978176e9*1j) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.13e2) * np.sqrt(0.31e2) * ((1 + t10003) ** (-0.1e1 / 0.2e1)) * ((1 - t10003) ** (-0.1e1 / 0.2e1)) * ((520030 * t10003 + 120216078 * t9987 - 682517088 * t9989 + 1623385080 * t9991 - 2087251840 * t9993 + 1558455620 * t9995 - 673007968 * t10013 + 156841048 * t10011 - 16640960 * t10009) * np.exp((9*1j) * phi2) + (t10029 + t10030) * np.exp((-1*1j) * (t10004 + t10006)) + (t10029 - t10030) * np.exp((1j) * (t10004 + t10005)) + (t10028 - t10031) * np.exp((-3*1j) * (t10008 - 3 * phi2)) + (t10024 + t10025) * np.exp((-1*1j) * (t10008 + t10006)) + (t10026 + t10027) * np.exp((-1*1j) * (t10007 + t10006)) + (t10024 - t10025) * np.exp((1j) * (t10008 + t10005)) + (-t10026 + t10027) * np.exp((1j) * (t10007 + t10005)) + (t10028 + t10031) * np.exp((3*1j) * (t10008 + 3 * phi2)))

        if Bindx == 269:
            t10054 = np.cos(phi)
            t10053 = t10054 ** 2
            t10061 = t10053 ** 2
            t10065 = t10061 ** 2
            t10039 = t10065 ** 2
            t10060 = t10054 * t10053
            t10063 = t10060 ** 2
            t10062 = t10054 * t10061
            t10067 = t10062 ** 2
            t10069 = t10063 ** 2
            t10064 = t10054 * t10063
            t10071 = t10064 ** 2
            t10079 = 16182 * t10039 + 23436 * t10053 - 8424 * t10061 - 447876 * t10063 + 1189188 * t10065 - 787644 * t10067 - 326664 * t10069 + 343476 * t10071 - 1674
            t10040 = t10054 * t10071
            t10042 = t10054 * t10069
            t10044 = t10054 * t10067
            t10046 = t10054 * t10065
            t10078 = -121365 * t10040 - 346869 * t10042 + 1146015 * t10044 - 606177 * t10046 + 3429 * t10054 - 81819 * t10060 + 368433 * t10062 - 361647 * t10064
            t10077 = 161820 * t10039 - 31320 * t10053 + 190680 * t10061 - 88440 * t10063 - 1663200 * t10065 + 4298360 * t10067 - 3902040 * t10069 + 1033560 * t10071 + 580
            t10076 = -792918 * t10039 - 55692 * t10053 + 670152 * t10061 - 2900604 * t10063 + 5610780 * t10065 - 4516932 * t10067 - 10584 * t10069 + 1995084 * t10071 + 714
            t10075 = -809100 * t10040 + 1237140 * t10042 + 1213380 * t10044 - 3611740 * t10046 - 6260 * t10054 + 126060 * t10060 - 902340 * t10062 + 2752860 * t10064
            t10074 = -1982295 * t10040 + 8248905 * t10042 - 13703067 * t10044 + 11560101 * t10046 + 4935 * t10054 - 136185 * t10060 + 1229067 * t10062 - 5221461 * t10064
            t10059 = 2 * phi1
            t10058 = 4 * phi1
            t10057 = 6 * phi1
            t10056 = -5 * phi2
            t10055 = 5 * phi2
            tfunc[..., c] = -(0.11e2 / 0.29622272e8) * np.sqrt(0.7e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.3e1) * ((760 + 1229832 * t10039 - 6744240 * t10071 + 15335280 * t10069 - 18557680 * t10067 + 12719360 * t10065 - 4828432 * t10063 + 910480 * t10061 - 65360 * t10053) * np.exp((10*1j) * phi2) + (-t10074 + t10076) * np.exp((-2*1j) * (t10059 + t10056)) + (t10075 + t10077) * np.exp((-2*1j) * (t10058 + t10056)) + (t10078 + t10079) * np.exp((-2*1j) * (t10057 + t10056)) + (t10074 + t10076) * np.exp((2*1j) * (t10059 + t10055)) + (-t10075 + t10077) * np.exp((2*1j) * (t10058 + t10055)) + (-t10078 + t10079) * np.exp((2*1j) * (t10057 + t10055)))

        if Bindx == 270:
            t10104 = np.cos(phi)
            t10103 = t10104 ** 2
            t10111 = t10104 * t10103
            t10114 = t10111 ** 2
            t10115 = t10104 * t10114
            t10122 = t10115 ** 2
            t10090 = t10104 * t10122
            t10120 = t10114 ** 2
            t10092 = t10104 * t10120
            t10112 = t10103 ** 2
            t10113 = t10104 * t10112
            t10118 = t10113 ** 2
            t10094 = t10104 * t10118
            t10116 = t10112 ** 2
            t10096 = t10104 * t10116
            t10132 = -53940 * t10090 - 154164 * t10092 + 509340 * t10094 - 269412 * t10096 + 1524 * t10104 - 36364 * t10111 + 163748 * t10113 - 160732 * t10115
            t10089 = t10116 ** 2
            t10131 = 7192 * t10089 + 10416 * t10103 - 3744 * t10112 - 199056 * t10114 + 528528 * t10116 - 350064 * t10118 - 145184 * t10120 + 152656 * t10122 - 744
            t10130 = 3277 * t10089 - 3277 + 937222 * t10114 - 937222 * t10118 - 255606 * t10112 + 255606 * t10120 + 137634 * t10122 - 137634 * t10103
            t10129 = -32770 * t10090 + 32770 * t10104 + 937222 * t10096 - 937222 * t10115 - 294930 * t10092 + 294930 * t10111 + 255606 * t10094 - 255606 * t10113
            t10128 = -10518300 * t10090 + 16082820 * t10092 + 15773940 * t10094 - 46952620 * t10096 - 81380 * t10104 + 1638780 * t10111 - 11730420 * t10113 + 35787180 * t10115
            t10127 = 112896420 * t10090 - 469794780 * t10092 + 780422292 * t10094 - 658375276 * t10096 - 281060 * t10104 + 7756060 * t10111 - 69998292 * t10113 + 297374636 * t10115
            t10126 = 2103660 * t10089 - 407160 * t10103 + 2478840 * t10112 - 1149720 * t10114 - 21621600 * t10116 + 55878680 * t10118 - 50726520 * t10120 + 13436280 * t10122 + 7540
            t10125 = 45158568 * t10089 + 3171792 * t10103 - 38166752 * t10112 + 165196304 * t10114 - 319547280 * t10116 + 257250032 * t10118 + 602784 * t10120 - 113624784 * t10122 - 40664
            t10110 = 2 * phi1
            t10109 = 4 * phi1
            t10108 = 6 * phi1
            t10107 = 8 * phi1
            t10106 = -5 * phi2
            t10105 = 5 * phi2
            tfunc[..., c] = (0.33e2 / 0.473956352e9) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.7e1) * np.sqrt(0.31e2) * ((120216078 * t10089 - 659249460 * t10122 + 1499023620 * t10120 - 1814013220 * t10118 + 1243317440 * t10116 - 471979228 * t10114 + 88999420 * t10112 - 6388940 * t10103 + 74290) * np.exp((10*1j) * phi2) + (t10129 + t10130) * np.exp((-2*1j) * (t10107 + t10106)) + (-t10129 + t10130) * np.exp((2*1j) * (t10107 + t10105)) + (t10125 - t10127) * np.exp((-2*1j) * (t10110 + t10106)) + (t10126 + t10128) * np.exp((-2*1j) * (t10109 + t10106)) + (t10131 + t10132) * np.exp((-2*1j) * (t10108 + t10106)) + (t10125 + t10127) * np.exp((2*1j) * (t10110 + t10105)) + (t10126 - t10128) * np.exp((2*1j) * (t10109 + t10105)) + (t10131 - t10132) * np.exp((2*1j) * (t10108 + t10105)))

        if Bindx == 271:
            t10156 = np.cos(phi)
            t10155 = t10156 ** 2
            t10163 = t10155 ** 2
            t10167 = t10163 ** 2
            t10175 = t10167 ** 2
            t10140 = t10156 * t10175
            t10162 = t10156 * t10155
            t10165 = t10162 ** 2
            t10166 = t10156 * t10165
            t10173 = t10166 ** 2
            t10142 = t10156 * t10173
            t10171 = t10165 ** 2
            t10144 = t10156 * t10171
            t10164 = t10156 * t10163
            t10169 = t10164 ** 2
            t10146 = t10156 * t10169
            t10148 = t10156 * t10167
            t10182 = 3596 * t10140 + 95236 * t10142 - 48132 * t10144 - 364156 * t10146 + 473044 * t10148 - 2640 * t10156 + 30668 * t10162 - 62348 * t10164 - 125268 * t10166
            t10181 = 2468 * t10155 + 43272 * t10163 - 224588 * t10165 + 286286 * t10167 + 94380 * t10169 - 354640 * t10171 + 123772 * t10173 + 29667 * t10175 - 617
            t10180 = -2640 * t10155 + 77920 * t10163 - 520400 * t10165 + 1390840 * t10167 - 1634160 * t10169 + 605440 * t10171 + 280720 * t10173 - 197780 * t10175 + 60
            t10179 = -5236 * t10155 + 93016 * t10163 - 696388 * t10165 + 2441978 * t10167 - 4485404 * t10169 + 4480784 * t10171 - 2313388 * t10173 + 484561 * t10175 + 77
            t10178 = 35960 * t10140 + 296960 * t10142 - 1191520 * t10144 + 1374720 * t10146 - 398640 * t10148 + 3960 * t10156 - 56320 * t10162 + 244640 * t10164 - 309760 * t10166
            t10177 = -176204 * t10140 + 471772 * t10142 + 186788 * t10144 - 2025380 * t10146 + 2969932 * t10148 + 4592 * t10156 - 102956 * t10162 + 677740 * t10164 - 2006284 * t10166
            t10161 = 4 * phi1
            t10160 = 8 * phi1
            t10159 = 12 * phi1
            t10158 = -11 * phi2
            t10157 = 11 * phi2
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.23e2) * np.sqrt(0.5e1) * np.sqrt(0.113e3) * np.sqrt(0.17e2) * np.sqrt(0.7e1) * np.sqrt(0.2e1) * ((1 + t10156) ** (-0.1e1 / 0.2e1)) * ((1 - t10156) ** (-0.1e1 / 0.2e1)) * ((273296 * t10140 - 1727936 * t10142 + 4632960 * t10144 - 6815680 * t10146 + 5931040 * t10148 - 3053376 * t10166 + 870656 * t10164 - 115520 * t10162 + 4560 * t10156) * np.exp((11*1j) * phi2) + (t10177 + t10179) * np.exp((-1*1j) * (t10161 + t10158)) + (t10178 + t10180) * np.exp((-1*1j) * (t10160 + t10158)) + (t10177 - t10179) * np.exp((1j) * (t10161 + t10157)) + (t10178 - t10180) * np.exp((1j) * (t10160 + t10157)) + (-t10181 + t10182) * np.exp((-1*1j) * (t10159 + t10158)) + (t10181 + t10182) * np.exp((1j) * (t10159 + t10157)))

        if Bindx == 272:
            t10208 = np.cos(phi)
            t10207 = t10208 ** 2
            t10216 = t10207 ** 2
            t10215 = t10208 * t10207
            t10218 = t10215 ** 2
            t10220 = t10216 ** 2
            t10217 = t10208 * t10216
            t10222 = t10217 ** 2
            t10224 = t10218 ** 2
            t10219 = t10208 * t10218
            t10226 = t10219 ** 2
            t10228 = t10220 ** 2
            t10237 = 4936 * t10207 + 86544 * t10216 - 449176 * t10218 + 572572 * t10220 + 188760 * t10222 - 709280 * t10224 + 247544 * t10226 + 59334 * t10228 - 1234
            t10192 = t10208 * t10228
            t10194 = t10208 * t10226
            t10196 = t10208 * t10224
            t10198 = t10208 * t10222
            t10200 = t10208 * t10220
            t10236 = 7192 * t10192 + 190472 * t10194 - 96264 * t10196 - 728312 * t10198 + 946088 * t10200 - 5280 * t10208 + 61336 * t10215 - 124696 * t10217 - 250536 * t10219
            t10235 = -170404 * t10207 - 550536 * t10216 + 1192828 * t10218 + 937222 * t10220 - 1874444 * t10222 + 432564 * t10226 + 36047 * t10228 - 3277
            t10234 = 3277 * t10192 + 170404 * t10194 + 550536 * t10196 - 1192828 * t10198 - 937222 * t10200 - 36047 * t10208 - 432564 * t10215 + 1874444 * t10219
            t10233 = 154440 * t10207 - 4558320 * t10216 + 30443400 * t10218 - 81364140 * t10220 + 95598360 * t10222 - 35418240 * t10224 - 16422120 * t10226 + 11570130 * t10228 - 3510
            t10232 = 1341912 * t10207 - 23838672 * t10216 + 178474296 * t10218 - 625844076 * t10220 + 1149544968 * t10222 - 1148360928 * t10224 + 592888296 * t10226 - 124186062 * t10228 - 19734
            t10231 = 2103660 * t10192 + 17372160 * t10194 - 69703920 * t10196 + 80421120 * t10198 - 23320440 * t10200 + 231660 * t10208 - 3294720 * t10215 + 14311440 * t10217 - 18120960 * t10219
            t10230 = 45158568 * t10192 - 120908424 * t10194 - 47871096 * t10196 + 519075960 * t10198 - 761151144 * t10200 - 1176864 * t10208 + 26386152 * t10215 - 173695080 * t10217 + 514181928 * t10219
            t10214 = 4 * phi1
            t10213 = 8 * phi1
            t10212 = 12 * phi1
            t10211 = 16 * phi1
            t10210 = -11 * phi2
            t10209 = 11 * phi2
            tfunc[..., c] = (0.11e2 / 0.236978176e9*1j) * np.sqrt(0.7e1) * np.sqrt(0.31e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * ((1 + t10208) ** (-0.1e1 / 0.2e1)) * ((1 - t10208) ** (-0.1e1 / 0.2e1)) * ((120216078 * t10192 - 760075848 * t10194 + 2037923280 * t10196 - 2998047240 * t10198 + 2608916220 * t10200 - 1343103768 * t10219 + 382979808 * t10217 - 50814360 * t10215 + 2005830 * t10208) * np.exp((11*1j) * phi2) + (t10234 - t10235) * np.exp((-1*1j) * (t10211 + t10210)) + (t10234 + t10235) * np.exp((1j) * (t10211 + t10209)) + (t10230 + t10232) * np.exp((-1*1j) * (t10214 + t10210)) + (t10231 - t10233) * np.exp((-1*1j) * (t10213 + t10210)) + (t10230 - t10232) * np.exp((1j) * (t10214 + t10209)) + (t10231 + t10233) * np.exp((1j) * (t10213 + t10209)) + (t10236 - t10237) * np.exp((-1*1j) * (t10212 + t10210)) + (t10236 + t10237) * np.exp((1j) * (t10212 + t10209)))

        if Bindx == 273:
            t10260 = np.cos(phi)
            t10259 = t10260 ** 2
            t10264 = t10260 * t10259
            t10267 = t10264 ** 2
            t10268 = t10260 * t10267
            t10275 = t10268 ** 2
            t10246 = t10260 * t10275
            t10273 = t10267 ** 2
            t10248 = t10260 * t10273
            t10265 = t10259 ** 2
            t10266 = t10260 * t10265
            t10271 = t10266 ** 2
            t10250 = t10260 * t10271
            t10269 = t10265 ** 2
            t10252 = t10260 * t10269
            t10283 = -40455 * t10246 - 269381 * t10248 + 308217 * t10250 + 383955 * t10252 - 7303 * t10260 + 35259 * t10264 + 98553 * t10266 - 512941 * t10268
            t10282 = -269700 * t10246 + 67860 * t10248 + 1468380 * t10250 - 2280300 * t10252 + 6780 * t10260 - 34540 * t10264 - 170020 * t10266 + 1211540 * t10268
            t10281 = -660765 * t10246 + 2905945 * t10248 - 5004125 * t10250 + 4170145 * t10252 - 2205 * t10260 + 20825 * t10264 + 201635 * t10266 - 1631455 * t10268
            t10245 = t10269 ** 2
            t10280 = 4495 * t10245 + 9528 * t10259 - 129220 * t10265 + 216216 * t10267 + 265122 * t10269 - 664664 * t10271 + 151788 * t10273 + 149640 * t10275 + 1191
            t10279 = 44950 * t10245 - 35520 * t10259 + 299400 * t10265 - 855360 * t10267 + 642180 * t10269 + 855360 * t10271 - 1462520 * t10273 + 510400 * t10275 + 1110
            t10278 = -220255 * t10245 - 68600 * t10259 + 639940 * t10265 - 2381400 * t10267 + 4235070 * t10269 - 3592680 * t10271 + 988820 * t10273 + 397880 * t10275 + 1225
            t10263 = 2 * phi1
            t10262 = -3 * phi2
            t10261 = 3 * phi2
            tfunc[..., c] = -(0.33e2 / 0.29622272e8) * np.sqrt(0.2e1) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.3e1) * ((1140 + 755440 * t10265 - 72960 * t10259 + 341620 * t10245 - 2115840 * t10275 + 5522160 * t10273 - 7831040 * t10271 + 6463800 * t10269 - 3064320 * t10267) * np.exp((12*1j) * phi2) + (t10278 - t10281) * np.exp((-4*1j) * (phi1 + t10262)) + (t10279 + t10282) * np.exp((-4*1j) * (t10263 + t10262)) + (t10278 + t10281) * np.exp((4*1j) * (phi1 + t10261)) + (t10279 - t10282) * np.exp((4*1j) * (t10263 + t10261)) + (t10280 + t10283) * np.exp((-12*1j) * (phi1 - phi2)) + (t10280 - t10283) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 274:
            t10308 = np.cos(phi)
            t10307 = t10308 ** 2
            t10314 = t10307 ** 2
            t10318 = t10314 ** 2
            t10293 = t10318 ** 2
            t10313 = t10308 * t10307
            t10316 = t10313 ** 2
            t10322 = t10316 ** 2
            t10317 = t10308 * t10316
            t10324 = t10317 ** 2
            t10334 = 16385 * t10293 + 1048640 * t10307 + 5964140 * t10314 - 14058330 * t10318 + 5964140 * t10322 + 1048640 * t10324 + 16385
            t10315 = t10308 * t10314
            t10320 = t10315 ** 2
            t10333 = 35960 * t10293 + 76224 * t10307 - 1033760 * t10314 + 1729728 * t10316 + 2120976 * t10318 - 5317312 * t10320 + 1214304 * t10322 + 1197120 * t10324 + 9528
            t10294 = t10308 * t10324
            t10296 = t10308 * t10322
            t10298 = t10308 * t10320
            t10300 = t10308 * t10318
            t10332 = -323640 * t10294 - 2155048 * t10296 + 2465736 * t10298 + 3071640 * t10300 - 58424 * t10308 + 282072 * t10313 + 788424 * t10315 - 4103528 * t10317
            t10331 = 9372220 * t10300 + 9372220 * t10317 - 5964140 * t10298 - 5964140 * t10315 - 3211460 * t10296 - 3211460 * t10313 - 196620 * t10294 - 196620 * t10308
            t10330 = -63109800 * t10294 + 15879240 * t10296 + 343600920 * t10298 - 533590200 * t10300 + 1586520 * t10308 - 8082360 * t10313 - 39784680 * t10315 + 283500360 * t10317
            t10329 = 677378520 * t10294 - 2979008760 * t10296 + 5129943000 * t10298 - 4274994360 * t10300 + 2260440 * t10308 - 21348600 * t10313 - 206704680 * t10315 + 1672474440 * t10317
            t10328 = 10518300 * t10293 - 8311680 * t10307 + 70059600 * t10314 - 200154240 * t10316 + 150270120 * t10318 + 200154240 * t10320 - 342229680 * t10322 + 119433600 * t10324 + 259740
            t10327 = 225792840 * t10293 + 70324800 * t10307 - 656029920 * t10314 + 2441275200 * t10316 - 4341551760 * t10318 + 3683010240 * t10320 - 1013681760 * t10322 - 407883840 * t10324 - 1255800
            t10312 = 2 * phi1
            t10311 = 4 * phi1
            t10310 = -3 * phi2
            t10309 = 3 * phi2
            tfunc[..., c] = (0.11e2 / 0.473956352e9) * np.sqrt(0.3e1) * np.sqrt(0.113e3) * np.sqrt(0.31e2) * ((601080390 * t10293 - 3722820480 * t10324 + 9716240520 * t10322 - 13778714880 * t10320 + 11373056100 * t10318 - 5391671040 * t10316 + 1329196680 * t10314 - 128373120 * t10307 + 2005830) * np.exp((12*1j) * phi2) + (t10331 + t10334) * np.exp((-4*1j) * (t10311 + t10310)) + (-t10331 + t10334) * np.exp((4*1j) * (t10311 + t10309)) + (t10327 - t10329) * np.exp((-4*1j) * (phi1 + t10310)) + (t10328 + t10330) * np.exp((-4*1j) * (t10312 + t10310)) + (t10327 + t10329) * np.exp((4*1j) * (phi1 + t10309)) + (t10328 - t10330) * np.exp((4*1j) * (t10312 + t10309)) + (t10332 + t10333) * np.exp((-12*1j) * (phi1 - phi2)) + (-t10332 + t10333) * np.exp((12*1j) * (phi1 + phi2)))

        if Bindx == 275:
            t10357 = np.cos(phi)
            t10356 = t10357 ** 2
            t10364 = t10356 ** 2
            t10368 = t10364 ** 2
            t10342 = t10368 ** 2
            t10379 = 620 * t10342
            t10378 = 6200 * t10342
            t10377 = -30380 * t10342
            t10363 = t10357 * t10356
            t10366 = t10363 ** 2
            t10367 = t10357 * t10366
            t10374 = t10367 ** 2
            t10372 = t10366 ** 2
            t10365 = t10357 * t10364
            t10370 = t10365 ** 2
            t10362 = 4 * phi1
            t10361 = 8 * phi1
            t10360 = 12 * phi1
            t10359 = -13 * phi2
            t10358 = 13 * phi2
            t10349 = t10357 * t10368
            t10347 = t10357 * t10370
            t10345 = t10357 * t10372
            t10343 = t10357 * t10374
            tfunc[..., c] = (0.33e2 / 0.59244544e8*1j) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.23e2) * np.sqrt(0.29e2) * np.sqrt(0.113e3) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * np.sqrt((1 - t10357)) * ((1 + t10357) ** (-0.1e1 / 0.2e1)) * ((47120 * t10342 + 47120 * t10343 + 74480 * t10364 + 74480 * t10363 - 4560 * t10356 - 4560 * t10357 - 1010800 * t10370 - 1010800 * t10349 + 798000 * t10368 + 798000 * t10367 + 734160 * t10372 + 734160 * t10347 - 351120 * t10366 - 351120 * t10365 - 287280 * t10374 - 287280 * t10345) * np.exp((13*1j) * phi2) + (t10377 + 68355 * t10343 + 126175 * t10374 - 370685 * t10345 - 161945 * t10372 + 831775 * t10347 - 19845 * t10370 - 991025 * t10349 + 238875 * t10368 + 667625 * t10367 - 232995 * t10366 - 249655 * t10365 + 94325 * t10364 + 47285 * t10363 - 14455 * t10356 - 3675 * t10357 + 245) * np.exp((-1*1j) * (t10362 + t10359)) + (t10378 - 34100 * t10343 + 50700 * t10374 + 51740 * t10345 - 213380 * t10372 + 109020 * t10347 + 250140 * t10370 - 306900 * t10349 - 61380 * t10368 + 260260 * t10367 - 74140 * t10366 - 89580 * t10365 + 51700 * t10364 + 9140 * t10363 - 10380 * t10356 + 420 * t10357 + 540) * np.exp((-1*1j) * (t10361 + t10359)) + (t10377 - 129115 * t10343 - 71295 * t10374 + 425565 * t10345 + 634305 * t10372 - 359415 * t10347 - 1211035 * t10370 - 239855 * t10349 + 990045 * t10368 + 561295 * t10367 - 339325 * t10366 - 322665 * t10365 + 21315 * t10364 + 68355 * t10363 + 6615 * t10356 - 4165 * t10357 - 245) * np.exp((1j) * (t10362 + t10358)) + (t10378 + 46500 * t10343 + 131300 * t10374 + 130260 * t10345 - 134860 * t10372 - 457260 * t10347 - 316140 * t10370 + 240900 * t10349 + 486420 * t10368 + 164780 * t10367 - 169620 * t10366 - 154180 * t10365 - 12900 * t10364 + 29660 * t10363 + 10140 * t10356 - 660 * t10357 - 540) * np.exp((1j) * (t10361 + t10358)) + (t10379 - 5425 * t10343 + 19155 * t10374 - 31129 * t10345 + 8099 * t10372 + 55419 * t10347 - 89089 * t10370 + 29315 * t10349 + 63063 * t10368 - 77363 * t10367 + 17017 * t10366 + 27573 * t10365 - 22295 * t10364 + 3241 * t10363 + 3189 * t10356 - 1631 * t10357 + 241) * np.exp((-1*1j) * (t10360 + t10359)) + (t10379 + 6665 * t10343 + 31245 * t10374 + 81529 * t10345 + 120757 * t10372 + 73437 * t10347 - 71071 * t10370 - 189475 * t10349 - 155727 * t10368 - 15301 * t10367 + 79079 * t10366 + 68523 * t10365 + 18655 * t10364 - 6881 * t10363 - 6933 * t10356 - 2113 * t10357 - 241) * np.exp((1j) * (t10360 + t10358)))

        if Bindx == 276:
            t10404 = np.cos(phi)
            t10403 = t10404 ** 2
            t10412 = t10403 ** 2
            t10416 = t10412 ** 2
            t10389 = t10416 ** 2
            t10428 = 565 * t10389
            t10427 = 1240 * t10389
            t10426 = 362700 * t10389
            t10425 = 7785960 * t10389
            t10411 = t10404 * t10403
            t10414 = t10411 ** 2
            t10415 = t10404 * t10414
            t10422 = t10415 ** 2
            t10420 = t10414 ** 2
            t10413 = t10404 * t10412
            t10418 = t10413 ** 2
            t10410 = 4 * phi1
            t10409 = 8 * phi1
            t10408 = 12 * phi1
            t10407 = 16 * phi1
            t10406 = -13 * phi2
            t10405 = 13 * phi2
            t10396 = t10404 * t10416
            t10394 = t10404 * t10418
            t10392 = t10404 * t10420
            t10390 = t10404 * t10422
            tfunc[..., c] = (-0.11e2 / 0.236978176e9*1j) * np.sqrt(0.31e2) * np.sqrt(0.113e3) * np.sqrt(0.29e2) * np.sqrt(0.3e1) * np.sqrt((1 - t10404)) * ((1 + t10404) ** (-0.1e1 / 0.2e1)) * ((t10428 - 6780 * t10390 + 36160 * t10422 - 484770 * t10416 + 36160 * t10403 - 6780 * t10404 + 565 + 323180 * t10396 + 323180 * t10415 - 110740 * t10392 - 110740 * t10411 + 205660 * t10420 - 205660 * t10394 - 205660 * t10413 + 205660 * t10412) * np.exp((-1*1j) * (t10407 + t10406)) + (-444625650 * t10418 - 444625650 * t10396 + 351020250 * t10416 + 351020250 * t10415 + 322938630 * t10420 + 322938630 * t10394 - 154448910 * t10414 - 154448910 * t10413 - 126367290 * t10422 - 126367290 * t10392 + 32761890 * t10412 + 32761890 * t10411 + 20726910 * t10389 + 20726910 * t10390 - 2005830 * t10403 - 2005830 * t10404) * np.exp((13*1j) * phi2) + (t10428 + 7910 * t10390 + 50850 * t10422 - 50850 * t10403 - 7910 * t10404 - 565 + 1131130 * t10418 - 1131130 * t10414 + 925470 * t10394 - 925470 * t10413 + 807950 * t10396 - 807950 * t10415 + 514150 * t10420 - 514150 * t10412 + 197750 * t10392 - 197750 * t10411) * np.exp((1j) * (t10407 + t10405)) + (-17518410 * t10390 + 95001270 * t10392 - 213172050 * t10394 + 253985550 * t10396 + 3704610 * t10403 + 941850 * t10404 - 12118470 * t10411 - 24174150 * t10412 + 63983010 * t10413 + 59713290 * t10414 - 171102750 * t10415 - 61220250 * t10416 + 5085990 * t10418 + 41504190 * t10420 - 32336850 * t10422 + t10425 - 62790) * np.exp((-1*1j) * (t10410 + t10406)) + (-1994850 * t10390 + 3026790 * t10392 + 6377670 * t10394 - 17953650 * t10396 - 607230 * t10403 + 24570 * t10404 + 534690 * t10411 + 3024450 * t10412 - 5240430 * t10413 - 4337190 * t10414 + 15225210 * t10415 - 3590730 * t10416 + 14633190 * t10418 - 12482730 * t10420 + 2965950 * t10422 + 31590 + t10426) * np.exp((-1*1j) * (t10409 + t10406)) + (33090330 * t10390 - 109066230 * t10392 + 92112930 * t10394 + 61471410 * t10396 - 1695330 * t10403 + 1067430 * t10404 - 17518410 * t10411 - 5462730 * t10412 + 82694430 * t10413 + 86964150 * t10414 - 143851890 * t10415 - 253734390 * t10416 + 310370970 * t10418 - 162563310 * t10420 + 18271890 * t10422 + t10425 + 62790) * np.exp((1j) * (t10410 + t10405)) + (2720250 * t10390 + 7620210 * t10392 - 26749710 * t10394 + 14092650 * t10396 + 593190 * t10403 - 38610 * t10404 + 1735110 * t10411 - 754650 * t10412 - 9019530 * t10413 - 9922770 * t10414 + 9639630 * t10415 + 28455570 * t10416 - 18494190 * t10418 - 7889310 * t10420 + 7681050 * t10422 - 31590 + t10426) * np.exp((1j) * (t10409 + t10405)) + (t10427 - 10850 * t10390 + 38310 * t10422 - 62258 * t10392 + 16198 * t10420 + 110838 * t10394 - 178178 * t10418 + 58630 * t10396 + 126126 * t10416 - 154726 * t10415 + 34034 * t10414 + 55146 * t10413 - 44590 * t10412 + 6482 * t10411 + 6378 * t10403 - 3262 * t10404 + 482) * np.exp((-1*1j) * (t10408 + t10406)) + (-482 + t10427 + 13330 * t10390 + 62490 * t10422 + 163058 * t10392 + 241514 * t10420 + 146874 * t10394 - 142142 * t10418 - 378950 * t10396 - 311454 * t10416 - 30602 * t10415 + 158158 * t10414 + 137046 * t10413 + 37310 * t10412 - 13762 * t10411 - 13866 * t10403 - 4226 * t10404) * np.exp((1j) * (t10408 + t10405)))

        if Bindx == 277:
            t10451 = np.cos(phi)
            t10450 = t10451 ** 2
            t10457 = t10451 * t10450
            t10460 = t10457 ** 2
            t10461 = t10451 * t10460
            t10468 = t10461 ** 2
            t10437 = t10451 * t10468
            t10466 = t10460 ** 2
            t10439 = t10451 * t10466
            t10458 = t10450 ** 2
            t10459 = t10451 * t10458
            t10464 = t10459 ** 2
            t10441 = t10451 * t10464
            t10462 = t10458 ** 2
            t10443 = t10451 * t10462
            t10476 = -651 * t10437 - 7259 * t10439 - 2639 * t10441 + 20449 * t10443 + 315 * t10451 + 1771 * t10457 - 7553 * t10459 - 4433 * t10461
            t10475 = -4340 * t10437 - 5460 * t10439 + 43260 * t10441 - 49060 * t10443 + 500 * t10451 - 6060 * t10457 + 14340 * t10459 + 6820 * t10461
            t10474 = -10633 * t10437 + 49735 * t10439 - 88053 * t10441 + 66395 * t10443 - 1127 * t10451 + 9065 * t10457 - 17787 * t10459 - 7595 * t10461
            t10436 = t10462 ** 2
            t10473 = -34 + 62 * t10436 - 1156 * t10450 + 728 * t10458 + 12012 * t10460 - 12012 * t10462 - 12012 * t10464 + 9464 * t10466 + 2948 * t10468
            t10472 = -140 + 620 * t10436 + 840 * t10450 + 5880 * t10458 - 33880 * t10460 + 47520 * t10462 - 8360 * t10464 - 23160 * t10466 + 10680 * t10468
            t10471 = -3038 * t10436 - 2940 * t10450 + 25480 * t10458 - 83692 * t10460 + 132300 * t10462 - 104468 * t10464 + 33320 * t10466 + 2940 * t10468 + 98
            t10456 = 2 * phi1
            t10455 = 4 * phi1
            t10454 = 6 * phi1
            t10453 = -7 * phi2
            t10452 = 7 * phi2
            tfunc[..., c] = -(0.33e2 / 0.29622272e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.5e1) * np.sqrt(0.23e2) * np.sqrt(0.3e1) * np.sqrt(0.13e2) * np.sqrt(0.29e2) * ((4712 * t10436 - 33136 * t10468 + 100016 * t10466 - 168112 * t10464 + 170240 * t10462 - 104272 * t10460 + 36176 * t10458 - 5776 * t10450 + 152) * np.exp((14*1j) * phi2) + (t10471 - t10474) * np.exp((-2*1j) * (t10456 + t10453)) + (t10472 + t10475) * np.exp((-2*1j) * (t10455 + t10453)) + (t10473 + t10476) * np.exp((-2*1j) * (t10454 + t10453)) + (t10471 + t10474) * np.exp((2*1j) * (t10456 + t10452)) + (t10472 - t10475) * np.exp((2*1j) * (t10455 + t10452)) + (t10473 - t10476) * np.exp((2*1j) * (t10454 + t10452)))

        if Bindx == 278:
            t10501 = np.cos(phi)
            t10500 = t10501 ** 2
            t10508 = t10501 * t10500
            t10511 = t10508 ** 2
            t10512 = t10501 * t10511
            t10519 = t10512 ** 2
            t10487 = t10501 * t10519
            t10517 = t10511 ** 2
            t10489 = t10501 * t10517
            t10509 = t10500 ** 2
            t10510 = t10501 * t10509
            t10515 = t10510 ** 2
            t10491 = t10501 * t10515
            t10513 = t10509 ** 2
            t10493 = t10501 * t10513
            t10529 = -2604 * t10487 - 29036 * t10489 - 10556 * t10491 + 81796 * t10493 + 1260 * t10501 + 7084 * t10508 - 30212 * t10510 - 17732 * t10512
            t10486 = t10513 ** 2
            t10528 = -136 + 248 * t10486 - 4624 * t10500 + 2912 * t10509 + 48048 * t10511 - 48048 * t10513 - 48048 * t10515 + 37856 * t10517 + 11792 * t10519
            t10527 = 113 * t10486 - 10170 * t10500 + 10170 * t10519 - 113 + 226226 * t10515 - 226226 * t10511 + 102830 * t10517 - 102830 * t10509
            t10526 = -1582 * t10487 - 39550 * t10489 + 1582 * t10501 + 39550 * t10508 - 185094 * t10491 + 185094 * t10510 - 161590 * t10493 + 161590 * t10512
            t10525 = 72540 * t10486 + 98280 * t10500 + 687960 * t10509 - 3963960 * t10511 + 5559840 * t10513 - 978120 * t10515 - 2709720 * t10517 + 1249560 * t10519 - 16380
            t10524 = -507780 * t10487 - 638820 * t10489 + 5061420 * t10491 - 5740020 * t10493 + 58500 * t10501 - 709020 * t10508 + 1677780 * t10510 + 797940 * t10512
            t10523 = -5450172 * t10487 + 25492740 * t10489 - 45133452 * t10491 + 34032180 * t10493 - 577668 * t10501 + 4646460 * t10508 - 9117108 * t10510 - 3892980 * t10512
            t10522 = 1557192 * t10486 + 1506960 * t10500 - 13060320 * t10509 + 42898128 * t10511 - 67813200 * t10513 + 53547312 * t10515 - 17078880 * t10517 - 1506960 * t10519 - 50232
            t10507 = 2 * phi1
            t10506 = 4 * phi1
            t10505 = 6 * phi1
            t10504 = 8 * phi1
            t10503 = -7 * phi2
            t10502 = 7 * phi2
            tfunc[..., c] = (0.11e2 / 0.473956352e9) * np.sqrt(0.31e2) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.29e2) * np.sqrt(0.113e3) * ((133722 - 5081436 * t10500 + 4145382 * t10486 - 29151396 * t10519 + 87989076 * t10517 - 147896532 * t10515 + 149768640 * t10513 - 91733292 * t10511 + 31825836 * t10509) * np.exp((14*1j) * phi2) + (t10526 + t10527) * np.exp((-2*1j) * (t10504 + t10503)) + (-t10526 + t10527) * np.exp((2*1j) * (t10504 + t10502)) + (t10522 + t10523) * np.exp((-2*1j) * (t10507 + t10503)) + (t10524 + t10525) * np.exp((-2*1j) * (t10506 + t10503)) + (t10528 + t10529) * np.exp((-2*1j) * (t10505 + t10503)) + (t10522 - t10523) * np.exp((2*1j) * (t10507 + t10502)) + (-t10524 + t10525) * np.exp((2*1j) * (t10506 + t10502)) + (t10528 - t10529) * np.exp((2*1j) * (t10505 + t10502)))

        if Bindx == 279:
            t10551 = np.cos(phi)
            t10550 = t10551 ** 2
            t10556 = t10551 * t10550
            t10559 = t10556 ** 2
            t10560 = t10551 * t10559
            t10567 = t10560 ** 2
            t10537 = t10551 * t10567
            t10572 = 4 * t10537
            t10571 = 40 * t10537
            t10570 = -196 * t10537
            t10569 = 49 - 637 * t10550 + 98 * t10551
            t10565 = t10559 ** 2
            t10557 = t10550 ** 2
            t10558 = t10551 * t10557
            t10563 = t10558 ** 2
            t10561 = t10557 ** 2
            t10555 = 4 * phi1
            t10554 = 8 * phi1
            t10553 = -15 * phi2
            t10552 = 15 * phi2
            t10543 = t10551 * t10561
            t10541 = t10551 * t10563
            t10539 = t10551 * t10565
            tfunc[..., c] = (-0.33e2 / 0.59244544e8*1j) * np.sqrt(0.3e1) * np.sqrt(0.899e3) * np.sqrt(0.23e2) * np.sqrt(0.5e1) * np.sqrt(0.13e2) * np.sqrt(0.113e3) * np.sqrt(0.17e2) * np.sqrt(0.2e1) * ((1 - t10551) ** (0.3e1 / 0.2e1)) * ((1 + t10551) ** (-0.1e1 / 0.2e1)) * (304 * (t10537 + 2 * t10567 - 5 * t10539 - 12 * t10565 + 9 * t10541 + 30 * t10563 - 5 * t10543 - 40 * t10561 - 5 * t10560 + 30 * t10559 + 9 * t10558 - 12 * t10557 - 5 * t10556 + 2 * t10550 + t10551) * np.exp((15*1j) * phi2) + (t10572 - 37 * t10567 + 142 * t10539 - 271 * t10565 + 184 * t10541 + 275 * t10563 - 726 * t10543 + 561 * t10561 + 132 * t10560 - 583 * t10559 + 418 * t10558 - 37 * t10557 - 128 * t10556 + 89 * t10550 - 26 * t10551 + 3) * np.exp((-3*1j) * (t10555 - 5 * phi2)) + (t10572 + 53 * t10567 + 322 * t10539 + 1183 * t10565 + 2912 * t10541 + 5005 * t10563 + 6006 * t10543 + 4719 * t10561 + 1716 * t10560 - 1001 * t10559 - 2002 * t10558 - 1547 * t10557 - 728 * t10556 - 217 * t10550 - 38 * t10551 - 3) * np.exp((3*1j) * (t10555 + 5 * phi2)) + (t10570 + 343 * t10567 + 1078 * t10539 - 2107 * t10565 - 2352 * t10541 + 5439 * t10563 + 2450 * t10543 - 7595 * t10561 - 980 * t10560 + 6125 * t10559 - 294 * t10558 - 2793 * t10557 + 392 * t10556 - t10569) * np.exp((-1*1j) * (t10555 + t10553)) + (t10571 - 220 * t10567 + 320 * t10539 + 380 * t10565 - 1480 * t10541 + 740 * t10563 + 1840 * t10543 - 2340 * t10561 - 360 * t10560 + 2060 * t10559 - 800 * t10558 - 620 * t10557 + 520 * t10556 - 20 * t10550 - 80 * t10551 + 20) * np.exp((-1*1j) * (t10554 + t10553)) + (t10570 - 1127 * t10567 - 1862 * t10539 + 1323 * t10565 + 7448 * t10541 + 5537 * t10563 - 7154 * t10543 - 12789 * t10561 - 1764 * t10560 + 8771 * t10559 + 5782 * t10558 - 1127 * t10557 - 2352 * t10556 + t10569) * np.exp((1j) * (t10555 + t10552)) + (t10571 + 380 * t10567 + 1520 * t10539 + 3140 * t10565 + 2840 * t10541 - 1540 * t10563 - 7040 * t10543 - 7260 * t10561 - 1320 * t10560 + 4180 * t10559 + 4400 * t10558 + 1580 * t10557 - 280 * t10556 - 460 * t10550 - 160 * t10551 - 20) * np.exp((1j) * (t10554 + t10552)))

        if Bindx == 280:
            t10597 = np.cos(phi)
            t10623 = 1 + t10597
            t10596 = t10597 ** 2
            t10604 = t10596 ** 2
            t10608 = t10604 ** 2
            t10582 = t10608 ** 2
            t10622 = 113 * t10582
            t10621 = 248 * t10582
            t10620 = 72540 * t10582
            t10619 = 1557192 * t10582
            t10589 = t10597 * t10608
            t10605 = t10597 * t10604
            t10603 = t10597 * t10596
            t10606 = t10603 ** 2
            t10610 = t10605 ** 2
            t10618 = -186 + 79794 * t10589 - 28210 * t10605 + 62062 * t10606 - 62062 * t10610
            t10612 = t10606 ** 2
            t10585 = t10597 * t10612
            t10607 = t10597 * t10606
            t10614 = t10607 ** 2
            t10617 = -25304370 * t10585 - 5839470 * t10596 + 5839470 * t10614 + 389298 * t10623
            t10602 = 4 * phi1
            t10601 = 8 * phi1
            t10600 = 16 * phi1
            t10599 = -15 * phi2
            t10598 = 15 * phi2
            t10587 = t10597 * t10610
            t10583 = t10597 * t10614
            tfunc[..., c] = (-0.11e2 / 0.236978176e9*1j) * np.sqrt(0.113e3) * np.sqrt(0.29e2) * np.sqrt(0.5e1) * np.sqrt(0.3e1) * np.sqrt((1 - t10597)) * t10623 ** (-0.1e1 / 0.2e1) * (4145382 * (-35 * t10610 - 35 * t10589 + 35 * t10608 + 35 * t10607 + 21 * t10612 + 21 * t10587 - 21 * t10606 - 21 * t10605 - 7 * t10614 - 7 * t10585 + 7 * t10604 + 7 * t10603 + t10582 + t10583 - t10596 - t10597) * np.exp((15*1j) * phi2) + (t10622 - 1582 * t10583 + 10170 * t10614 - 39550 * t10585 + 39550 * t10603 - 10170 * t10596 + 1582 * t10597 - 113 + 226226 * t10610 - 226226 * t10606 - 185094 * t10587 + 185094 * t10605 - 161590 * t10589 + 161590 * t10607 + 102830 * t10612 - 102830 * t10604) * np.exp((-1*1j) * (t10600 + t10599)) + (t10621 - 2542 * t10583 + 11098 * t10614 - 25606 * t10585 + 28210 * t10612 + 5642 * t10587 - 26598 * t10608 - 44330 * t10607 - 5642 * t10604 + 13454 * t10603 - 7130 * t10596 + 1798 * t10597 + t10618) * np.exp((-3*1j) * (t10602 - 5 * phi2)) + (t10621 + 3038 * t10583 + 16678 * t10614 + 53382 * t10585 + 107198 * t10612 + 129766 * t10587 - 186186 * t10608 - 168454 * t10607 + 50778 * t10604 + 31682 * t10603 + 11098 * t10596 + 2170 * t10597 - t10618) * np.exp((3*1j) * (t10602 + 5 * phi2)) + (-4282278 * t10583 - 61898382 * t10587 + 79806090 * t10589 - 1946490 * t10603 - 25304370 * t10604 + 19854198 * t10605 + 50998038 * t10606 - 56448210 * t10607 - 52555230 * t10608 + 23747178 * t10610 + 1946490 * t10612 - t10617 + t10619) * np.exp((-1*1j) * (t10602 + t10599)) + (-471510 * t10583 + 108810 * t10585 + 4025970 * t10587 - 7580430 * t10589 - 108810 * t10596 + 181350 * t10597 - 979290 * t10603 + 2067390 * t10604 + 326430 * t10605 - 5186610 * t10606 + 4388670 * t10607 + 3590730 * t10608 + 1994850 * t10610 - 3373110 * t10612 + 979290 * t10614 + t10620 - 36270) * np.exp((-1*1j) * (t10601 + t10599)) + (7396662 * t10583 + 15182622 * t10587 + 44769270 * t10589 - 13625430 * t10603 + 9732450 * t10604 + 54891018 * t10605 + 23747178 * t10606 - 83699070 * t10607 - 87592050 * t10608 + 100828182 * t10610 - 48662250 * t10612 + t10617 + t10619) * np.exp((1j) * (t10602 + t10598)) + (616590 * t10583 + 2937870 * t10585 - 7943130 * t10587 - 398970 * t10589 + 544050 * t10596 + 253890 * t10597 - 326430 * t10603 - 3373110 * t10604 - 5114070 * t10605 + 398970 * t10606 + 9974250 * t10607 + 10772190 * t10608 - 9974250 * t10610 - 544050 * t10612 + 2067390 * t10614 + t10620 + 36270) * np.exp((1j) * (t10601 + t10598)) + (t10622 + 1808 * t10583 + 13560 * t10614 + 63280 * t10585 + 1454310 * t10608 + 63280 * t10603 + 13560 * t10596 + 1808 * t10597 + 113 + 1292720 * t10589 + 1292720 * t10607 + 904904 * t10610 + 904904 * t10606 + 493584 * t10587 + 493584 * t10605 + 205660 * t10612 + 205660 * t10604) * np.exp((1j) * (t10600 + t10598)))

        if Bindx == 281:
            t10646 = np.cos(phi)
            t10645 = t10646 ** 2
            t10650 = t10646 * t10645
            t10653 = t10650 ** 2
            t10654 = t10646 * t10653
            t10661 = t10654 ** 2
            t10632 = t10646 * t10661
            t10670 = -t10632 - t10646
            t10651 = t10645 ** 2
            t10655 = t10651 ** 2
            t10631 = t10655 ** 2
            t10659 = t10653 ** 2
            t10669 = 1 + t10631 + 64 * t10645 + 364 * t10651 - 858 * t10655 + 364 * t10659 + 64 * t10661
            t10652 = t10646 * t10651
            t10657 = t10652 ** 2
            t10668 = -49 - 49 * t10631 + 980 * t10651 - 3136 * t10653 + 4410 * t10655 - 3136 * t10657 + 980 * t10659
            t10634 = t10646 * t10659
            t10636 = t10646 * t10657
            t10638 = t10646 * t10655
            t10667 = -12 * t10632 - 196 * t10634 - 364 * t10636 + 572 * t10638 - 12 * t10646 - 196 * t10650 - 364 * t10652 + 572 * t10654
            t10666 = -240 * t10634 + 1200 * t10636 - 880 * t10638 - 240 * t10650 + 1200 * t10652 - 880 * t10654 + 80 * t10670
            t10665 = 980 * t10634 - 1764 * t10636 + 980 * t10638 + 980 * t10650 - 1764 * t10652 + 980 * t10654 + 196 * t10670
            t10664 = 10 + 10 * t10631 + 240 * t10645 - 360 * t10651 - 880 * t10653 + 1980 * t10655 - 880 * t10657 - 360 * t10659 + 240 * t10661
            t10649 = 3 * phi1
            t10648 = -4 * phi2
            t10647 = 4 * phi2
            tfunc[..., c] = -(0.33e2 / 0.59244544e8) * np.sqrt(0.17e2) * np.sqrt(0.113e3) * np.sqrt(0.23e2) * np.sqrt(0.13e2) * np.sqrt(0.5e1) * np.sqrt(0.899e3) * np.sqrt(0.3e1) * ((76 * t10631 - 608 * t10661 + 2128 * t10659 - 4256 * t10657 + 5320 * t10655 - 4256 * t10653 + 2128 * t10651 - 608 * t10645 + 76) * np.exp((16*1j) * phi2) + (t10667 + t10669) * np.exp((-4*1j) * (t10649 + t10648)) + (-t10667 + t10669) * np.exp((4*1j) * (t10649 + t10647)) + (-t10665 + t10668) * np.exp((-4*1j) * (phi1 + t10648)) + (t10665 + t10668) * np.exp((4*1j) * (phi1 + t10647)) + (t10664 + t10666) * np.exp((-8*1j) * (phi1 - 2 * phi2)) + (t10664 - t10666) * np.exp((8*1j) * (phi1 + 2 * phi2)))

        if Bindx == 282:
            t10695 = np.cos(phi)
            t10694 = t10695 ** 2
            t10699 = t10695 * t10694
            t10702 = t10699 ** 2
            t10703 = t10695 * t10702
            t10710 = t10703 ** 2
            t10681 = t10695 * t10710
            t10723 = -t10681 - t10695
            t10708 = t10702 ** 2
            t10683 = t10695 * t10708
            t10727 = -t10683 - t10699
            t10700 = t10694 ** 2
            t10704 = t10700 ** 2
            t10687 = t10695 * t10704
            t10726 = -t10687 - t10703
            t10701 = t10695 * t10700
            t10706 = t10701 ** 2
            t10725 = t10706 + t10702
            t10724 = t10708 + t10700
            t10721 = t10726 + t10727
            t10680 = t10704 ** 2
            t10720 = 248 * t10680 + 15872 * t10694 + 90272 * t10700 - 212784 * t10704 + 90272 * t10708 + 15872 * t10710 + 248
            t10685 = t10695 * t10706
            t10719 = -56058912 * t10685 - 56058912 * t10701 + 6228768 * t10723
            t10718 = 2976 * t10681 + 48608 * t10683 + 90272 * t10685 + 2976 * t10695 + 48608 * t10699 + 90272 * t10701 + 141856 * t10726
            t10717 = 1557192 * t10680 - 140147280 * t10704 + 99660288 * t10725 + 1557192
            t10716 = -63280 * t10683 - 63280 * t10699 - 1292720 * t10687 - 1292720 * t10703 - 493584 * t10685 - 493584 * t10701 + 1808 * t10723
            t10715 = 113 * t10680 + 13560 * t10694 + 1454310 * t10704 + 13560 * t10710 + 205660 * t10724 + 904904 * t10725 + 113
            t10714 = 72540 * t10680 + 1740960 * t10694 + 14362920 * t10704 + 1740960 * t10710 - 2611440 * t10724 - 6383520 * t10725 + 72540
            t10713 = 8704800 * t10685 + 8704800 * t10701 + 6383520 * t10726 + 1740960 * t10727 + 580320 * t10723
            t10698 = 3 * phi1
            t10697 = -4 * phi2
            t10696 = 4 * phi2
            t10677 = np.exp((-4*1j) * (phi1 + t10697))
            t10675 = np.exp((4*1j) * (phi1 + t10696))
            tfunc[..., c] = (0.11e2 / 0.1895825408e10) * np.sqrt(0.2e1) * np.sqrt(0.3e1) * np.sqrt(0.5e1) * np.sqrt(0.29e2) * np.sqrt(0.113e3) * ((290176740 * t10704 + 4145382 * t10680 + 4145382 - 232141392 * t10706 - 232141392 * t10702 + 116070696 * t10708 + 116070696 * t10700 - 33163056 * t10710 - 33163056 * t10694) * np.exp((16*1j) * phi2) + ((t10717 + t10719) * t10677) + ((t10717 - t10719) * t10675) + (-t10718 + t10720) * np.exp((-4*1j) * (t10698 + t10697)) + (t10718 + t10720) * np.exp((4*1j) * (t10698 + t10696)) + (t10713 + t10714) * np.exp((-8*1j) * (phi1 - 2 * phi2)) + (-t10713 + t10714) * np.exp((8*1j) * (phi1 + 2 * phi2)) + (t10715 + t10716) * np.exp((-16*1j) * (phi1 - phi2)) + (t10715 - t10716) * np.exp((16*1j) * (phi1 + phi2)) + (31143840 * (-t10721 - t10724) * t10677) + (31143840 * (t10721 - t10724) * t10675))

        c += 1

    return tfunc


if __name__ == '__main__':
    X = np.zeros([2, 3])
    phi1 = np.array([0.1, 0.2])
    X[:, 0] = phi1
    phi = np.array([0.0, 0.4])
    X[:, 1] = phi
    phi2 = np.array([0.3, 0.6])
    X[:, 2] = phi2

    indxvec = gsh_basis_info()

    lte2 = indxvec[:, 0] <= 2

    Bvec = np.arange(indxvec.shape[0])[lte2]
