import argparse as arg
import pymatbridge.publish as publish

parser = arg.ArgumentParser(description='Publish a matlab file (.m) as an interactive notebook (.ipynb)')

parser.add_argument('mfile', action='store', metavar='File',
                    help='Matlab m-file (.m)')

parser.add_argument('--outfile', action='store', metavar='File',
                    help='Output notebook (.ipynb). Default: same name and location as the input file ', default=None)

params = parser.parse_args()


if __name__ == "__main__":
    publish.convert_mfile(params.mfile, params.outfile)
