function test_dump
%TEST_DUMP Test json.dump.

  fixtures = {...
    [],        'null';...
    1,         '1.0';...
    true,      'true';...
    'foo',     'foo';...
    {},        '[]';...
    struct(),  '{}';...
    1:5,       '[1,2,3,4,5]';...
    (1:5)',    '[[1],[2],[3],[4],[5]]';...
    [1,2;3,4], '[[1,2],[3,4]]';...
    {1,2;3,4}, '[[1,2],[3,4]]';...
    {[1,2],[3,4]}, '[[1,2],[3,4]]';...
    cat(3,[1,2;3,4],[5,6;7,8]), '[[[1,2],[3,4]],[[5,6],[7,8]]]';...
    {[1,2;3,4],[5,6;7,8]}, '[[[1,2],[3,4]],[[5,6],[7,8]]]';...
    {{}},      '[[]]';...
    struct('a',[1,2]), '{"a":[1,2]}';...
    struct('a',struct('b',{1,2})), '{"a":[{"b":1},{"b":2}]}';...
    {'foo','bar','baz'}, '["foo","bar","baz"]';...
    ['foo';'bar';'baz'], '["foo","bar","baz"]';...
    };

  for i = 1:size(fixtures, 1)
    str = json.dump(fixtures{i,1});
    if strcmp(str, fixtures{i,2})
      fprintf('PASS\n');
    else
      fprintf('FAIL: fixture %d: ''%s'', expected ''%s''.\n',...
              i, str, fixtures{i,2});
    end
  end

end