import logging
from dataclasses import dataclass

basestring = str

logger = logging.getLogger(__name__)

level = 'WARNING'
fmt = '\r%(asctime)s%(levelname)8s%(filename)15s %(lineno)4s: %(message)s'
logging.basicConfig(format=fmt, level=level)



def dataclass_with_default_init(_cls=None, *args, **kwargs):
    """
    | This class allows to define Frozen Dataclasses by bypassing the __init__.
    | It is useful when the attributes of the Dataclass are dynamically generated,
    | while still allowing the attributes of the class to be frozen after initialisation.

    :rtype: object
    """
    def wrap(cls):
        # Save the current __init__ and remove it so dataclass will
        # create the default __init__.
        user_init = getattr(cls, "__init__")
        delattr(cls, "__init__")

        # let dataclass process our class.
        result = dataclass(cls, *args, **kwargs)

        # Restore the user's __init__ save the default init to __default_init__.
        setattr(result, "__default_init__", result.__init__)
        setattr(result, "__init__", user_init)

        # Just in case that dataclass will return a new instance,
        # (currently, does not happen), restore cls's __init__.
        if result is not cls:
            setattr(cls, "__init__", user_init)

        return result

    # Support both dataclass_with_default_init() and dataclass_with_default_init
    if _cls is None:
        return wrap
    else:
        return wrap(_cls)

