# -*- coding: utf-8 -*-
import pytest

import pykakasi

original_text = (
    "日本国民は、正当に選挙された国会における代表者を通じて行動し、われらとわれらの子孫のために、"
    "諸国民との協和による成果と、わが国全土にわたつて自由のもたらす恵沢を確保し、"
    "政府の行為によつて再び戦争の惨禍が起ることのないやうにすることを決意し、ここに主権が国民に存することを宣言し、"
    "この憲法を確定する。そもそも国政は、国民の厳粛な信託によるものであつて、その権威は国民に由来し、"
    "その権力は国民の代表者がこれを行使し、その福利は国民がこれを享受する。これは人類普遍の原理であり、"
    "この憲法は、かかる原理に基くものである。われらは、これに反する一切の憲法、法令及び詔勅を排除する。"
)


expected = [
    {
        "orig": "日本国民",
        "kana": "ニホンコクミン",
        "hira": "にほんこくみん",
        "hepburn": "nihonkokumin",
        "kunrei": "nihonkokumin",
        "passport": "nihonkokumin",
    },
    {
        "orig": "は、",
        "kana": "ハ、",
        "hira": "は、",
        "hepburn": "ha,",
        "kunrei": "ha,",
        "passport": "ha,",
    },
    {
        "orig": "正当",
        "kana": "セイトウ",
        "hira": "せいとう",
        "hepburn": "seitou",
        "kunrei": "seitou",
        "passport": "seito",
    },
    {
        "orig": "に",
        "kana": "ニ",
        "hira": "に",
        "hepburn": "ni",
        "kunrei": "ni",
        "passport": "ni",
    },
    {
        "orig": "選挙",
        "kana": "センキョ",
        "hira": "せんきょ",
        "hepburn": "senkyo",
        "kunrei": "senkyo",
        "passport": "senkyo",
    },
    {
        "orig": "された",
        "kana": "サレタ",
        "hira": "された",
        "hepburn": "sareta",
        "kunrei": "sareta",
        "passport": "sareta",
    },
    {
        "orig": "国会",
        "kana": "コッカイ",
        "hira": "こっかい",
        "hepburn": "kokkai",
        "kunrei": "kokkai",
        "passport": "kokkai",
    },
    {
        "orig": "における",
        "kana": "ニオケル",
        "hira": "における",
        "hepburn": "niokeru",
        "kunrei": "niokeru",
        "passport": "niokeru",
    },
    {
        "orig": "代表者",
        "kana": "ダイヒョウシャ",
        "hira": "だいひょうしゃ",
        "hepburn": "daihyousha",
        "kunrei": "daihyousya",
        "passport": "daihyousha",
    },
    {
        "orig": "を",
        "kana": "ヲ",
        "hira": "を",
        "hepburn": "wo",
        "kunrei": "wo",
        "passport": "wo",
    },
    {
        "orig": "通じ",
        "kana": "ツウジ",
        "hira": "つうじ",
        "hepburn": "tsuuji",
        "kunrei": "tuuzi",
        "passport": "tsuuji",
    },
    {
        "orig": "て",
        "kana": "テ",
        "hira": "て",
        "hepburn": "te",
        "kunrei": "te",
        "passport": "te",
    },
    {
        "orig": "行動",
        "kana": "コウドウ",
        "hira": "こうどう",
        "hepburn": "koudou",
        "kunrei": "koudou",
        "passport": "kodou",
    },
    {
        "orig": "し、",
        "kana": "シ、",
        "hira": "し、",
        "hepburn": "shi,",
        "kunrei": "si,",
        "passport": "shi,",
    },
    {
        "orig": "われらとわれらの",
        "kana": "ワレラトワレラノ",
        "hira": "われらとわれらの",
        "hepburn": "wareratowarerano",
        "kunrei": "wareratowarerano",
        "passport": "wareratowarerano",
    },
    {
        "orig": "子孫",
        "kana": "シソン",
        "hira": "しそん",
        "hepburn": "shison",
        "kunrei": "sison",
        "passport": "shison",
    },
    {
        "orig": "のために、",
        "kana": "ノタメニ、",
        "hira": "のために、",
        "hepburn": "notameni,",
        "kunrei": "notameni,",
        "passport": "notameni,",
    },
    {
        "orig": "諸国民",
        "kana": "ショコクミン",
        "hira": "しょこくみん",
        "hepburn": "shokokumin",
        "kunrei": "syokokumin",
        "passport": "shokokumin",
    },
    {
        "orig": "との",
        "kana": "トノ",
        "hira": "との",
        "hepburn": "tono",
        "kunrei": "tono",
        "passport": "tono",
    },
    {
        "orig": "協和",
        "kana": "キョウワ",
        "hira": "きょうわ",
        "hepburn": "kyouwa",
        "kunrei": "kyouwa",
        "passport": "kyouwa",
    },
    {
        "orig": "による",
        "kana": "ニヨル",
        "hira": "による",
        "hepburn": "niyoru",
        "kunrei": "niyoru",
        "passport": "niyoru",
    },
    {
        "orig": "成果",
        "kana": "セイカ",
        "hira": "せいか",
        "hepburn": "seika",
        "kunrei": "seika",
        "passport": "seika",
    },
    {
        "orig": "と、",
        "kana": "ト、",
        "hira": "と、",
        "hepburn": "to,",
        "kunrei": "to,",
        "passport": "to,",
    },
    {
        "orig": "わが",
        "kana": "ワガ",
        "hira": "わが",
        "hepburn": "waga",
        "kunrei": "waga",
        "passport": "waga",
    },
    {
        "orig": "国",
        "kana": "クニ",
        "hira": "くに",
        "hepburn": "kuni",
        "kunrei": "kuni",
        "passport": "kuni",
    },
    {
        "orig": "全土",
        "kana": "ゼンド",
        "hira": "ぜんど",
        "hepburn": "zendo",
        "kunrei": "zendo",
        "passport": "zendo",
    },
    {
        "orig": "にわたつて",
        "kana": "ニワタツテ",
        "hira": "にわたつて",
        "hepburn": "niwatatsute",
        "kunrei": "niwatatute",
        "passport": "niwatatsute",
    },
    {
        "orig": "自由",
        "kana": "ジユウ",
        "hira": "じゆう",
        "hepburn": "jiyuu",
        "kunrei": "ziyuu",
        "passport": "jiyuu",
    },
    {
        "orig": "のもたらす",
        "kana": "ノモタラス",
        "hira": "のもたらす",
        "hepburn": "nomotarasu",
        "kunrei": "nomotarasu",
        "passport": "nomotarasu",
    },
    {
        "orig": "恵沢",
        "kana": "ケイタク",
        "hira": "けいたく",
        "hepburn": "keitaku",
        "kunrei": "keitaku",
        "passport": "keitaku",
    },
    {
        "orig": "を",
        "kana": "ヲ",
        "hira": "を",
        "hepburn": "wo",
        "kunrei": "wo",
        "passport": "wo",
    },
    {
        "orig": "確保",
        "kana": "カクホ",
        "hira": "かくほ",
        "hepburn": "kakuho",
        "kunrei": "kakuho",
        "passport": "kakuho",
    },
    {
        "orig": "し、",
        "kana": "シ、",
        "hira": "し、",
        "hepburn": "shi,",
        "kunrei": "si,",
        "passport": "shi,",
    },
    {
        "orig": "政府",
        "kana": "セイフ",
        "hira": "せいふ",
        "hepburn": "seifu",
        "kunrei": "seifu",
        "passport": "seifu",
    },
    {
        "orig": "の",
        "kana": "ノ",
        "hira": "の",
        "hepburn": "no",
        "kunrei": "no",
        "passport": "no",
    },
    {
        "orig": "行為",
        "kana": "コウイ",
        "hira": "こうい",
        "hepburn": "koui",
        "kunrei": "koui",
        "passport": "koi",
    },
    {
        "orig": "によつて",
        "kana": "ニヨツテ",
        "hira": "によつて",
        "hepburn": "niyotsute",
        "kunrei": "niyotute",
        "passport": "niyotsute",
    },
    {
        "orig": "再び",
        "kana": "フタタビ",
        "hira": "ふたたび",
        "hepburn": "futatabi",
        "kunrei": "futatabi",
        "passport": "futatabi",
    },
    {
        "orig": "戦争",
        "kana": "センソウ",
        "hira": "せんそう",
        "hepburn": "sensou",
        "kunrei": "sensou",
        "passport": "senso",
    },
    {
        "orig": "の",
        "kana": "ノ",
        "hira": "の",
        "hepburn": "no",
        "kunrei": "no",
        "passport": "no",
    },
    {
        "orig": "惨禍",
        "kana": "サンカ",
        "hira": "さんか",
        "hepburn": "sanka",
        "kunrei": "sanka",
        "passport": "sanka",
    },
    {
        "orig": "が",
        "kana": "ガ",
        "hira": "が",
        "hepburn": "ga",
        "kunrei": "ga",
        "passport": "ga",
    },
    {
        "orig": "起る",
        "kana": "オコル",
        "hira": "おこる",
        "hepburn": "okoru",
        "kunrei": "okoru",
        "passport": "okoru",
    },
    {
        "orig": "ことのないやうにすることを",
        "kana": "コトノナイヤウニスルコトヲ",
        "hira": "ことのないやうにすることを",
        "hepburn": "kotononaiyaunisurukotowo",
        "kunrei": "kotononaiyaunisurukotowo",
        "passport": "kotononaiyaunisurukotowo",
    },
    {
        "orig": "決意",
        "kana": "ケツイ",
        "hira": "けつい",
        "hepburn": "ketsui",
        "kunrei": "ketui",
        "passport": "ketsui",
    },
    {
        "orig": "し、",
        "kana": "シ、",
        "hira": "し、",
        "hepburn": "shi,",
        "kunrei": "si,",
        "passport": "shi,",
    },
    {
        "orig": "ここに",
        "kana": "ココニ",
        "hira": "ここに",
        "hepburn": "kokoni",
        "kunrei": "kokoni",
        "passport": "kokoni",
    },
    {
        "orig": "主権",
        "kana": "シュケン",
        "hira": "しゅけん",
        "hepburn": "shuken",
        "kunrei": "syuken",
        "passport": "shuken",
    },
    {
        "orig": "が",
        "kana": "ガ",
        "hira": "が",
        "hepburn": "ga",
        "kunrei": "ga",
        "passport": "ga",
    },
    {
        "orig": "国民",
        "kana": "コクミン",
        "hira": "こくみん",
        "hepburn": "kokumin",
        "kunrei": "kokumin",
        "passport": "kokumin",
    },
    {
        "orig": "に",
        "kana": "ニ",
        "hira": "に",
        "hepburn": "ni",
        "kunrei": "ni",
        "passport": "ni",
    },
    {
        "orig": "存す",
        "kana": "ソンス",
        "hira": "そんす",
        "hepburn": "sonsu",
        "kunrei": "sonsu",
        "passport": "sonsu",
    },
    {
        "orig": "ることを",
        "kana": "ルコトヲ",
        "hira": "ることを",
        "hepburn": "rukotowo",
        "kunrei": "rukotowo",
        "passport": "rukotowo",
    },
    {
        "orig": "宣言",
        "kana": "センゲン",
        "hira": "せんげん",
        "hepburn": "sengen",
        "kunrei": "sengen",
        "passport": "sengen",
    },
    {
        "orig": "し、",
        "kana": "シ、",
        "hira": "し、",
        "hepburn": "shi,",
        "kunrei": "si,",
        "passport": "shi,",
    },
    {
        "orig": "この",
        "kana": "コノ",
        "hira": "この",
        "hepburn": "kono",
        "kunrei": "kono",
        "passport": "kono",
    },
    {
        "orig": "憲法",
        "kana": "ケンポウ",
        "hira": "けんぽう",
        "hepburn": "kenpou",
        "kunrei": "kenpou",
        "passport": "kempou",
    },
    {
        "orig": "を",
        "kana": "ヲ",
        "hira": "を",
        "hepburn": "wo",
        "kunrei": "wo",
        "passport": "wo",
    },
    {
        "orig": "確定す",
        "kana": "カクテイス",
        "hira": "かくていす",
        "hepburn": "kakuteisu",
        "kunrei": "kakuteisu",
        "passport": "kakuteisu",
    },
    {
        "orig": "る。",
        "kana": "ル。",
        "hira": "る。",
        "hepburn": "ru.",
        "kunrei": "ru.",
        "passport": "ru.",
    },
    {
        "orig": "そもそも",
        "kana": "ソモソモ",
        "hira": "そもそも",
        "hepburn": "somosomo",
        "kunrei": "somosomo",
        "passport": "somosomo",
    },
    {
        "orig": "国政",
        "kana": "コクセイ",
        "hira": "こくせい",
        "hepburn": "kokusei",
        "kunrei": "kokusei",
        "passport": "kokusei",
    },
    {
        "orig": "は、",
        "kana": "ハ、",
        "hira": "は、",
        "hepburn": "ha,",
        "kunrei": "ha,",
        "passport": "ha,",
    },
    {
        "orig": "国民",
        "kana": "コクミン",
        "hira": "こくみん",
        "hepburn": "kokumin",
        "kunrei": "kokumin",
        "passport": "kokumin",
    },
    {
        "orig": "の",
        "kana": "ノ",
        "hira": "の",
        "hepburn": "no",
        "kunrei": "no",
        "passport": "no",
    },
    {
        "orig": "厳粛",
        "kana": "ゲンシュク",
        "hira": "げんしゅく",
        "hepburn": "genshuku",
        "kunrei": "gensyuku",
        "passport": "genshuku",
    },
    {
        "orig": "な",
        "kana": "ナ",
        "hira": "な",
        "hepburn": "na",
        "kunrei": "na",
        "passport": "na",
    },
    {
        "orig": "信託",
        "kana": "シンタク",
        "hira": "しんたく",
        "hepburn": "shintaku",
        "kunrei": "sintaku",
        "passport": "shintaku",
    },
    {
        "orig": "によるものであつて、",
        "kana": "ニヨルモノデアツテ、",
        "hira": "によるものであつて、",
        "hepburn": "niyorumonodeatsute,",
        "kunrei": "niyorumonodeatute,",
        "passport": "niyorumonodeatsute,",
    },
    {
        "orig": "その",
        "kana": "ソノ",
        "hira": "その",
        "hepburn": "sono",
        "kunrei": "sono",
        "passport": "sono",
    },
    {
        "orig": "権威",
        "kana": "ケンイ",
        "hira": "けんい",
        "hepburn": "ken'i",
        "kunrei": "ken'i",
        "passport": "keni",
    },
    {
        "orig": "は",
        "kana": "ハ",
        "hira": "は",
        "hepburn": "ha",
        "kunrei": "ha",
        "passport": "ha",
    },
    {
        "orig": "国民",
        "kana": "コクミン",
        "hira": "こくみん",
        "hepburn": "kokumin",
        "kunrei": "kokumin",
        "passport": "kokumin",
    },
    {
        "orig": "に",
        "kana": "ニ",
        "hira": "に",
        "hepburn": "ni",
        "kunrei": "ni",
        "passport": "ni",
    },
    {
        "orig": "由来",
        "kana": "ユライ",
        "hira": "ゆらい",
        "hepburn": "yurai",
        "kunrei": "yurai",
        "passport": "yurai",
    },
    {
        "orig": "し、",
        "kana": "シ、",
        "hira": "し、",
        "hepburn": "shi,",
        "kunrei": "si,",
        "passport": "shi,",
    },
    {
        "orig": "その",
        "kana": "ソノ",
        "hira": "その",
        "hepburn": "sono",
        "kunrei": "sono",
        "passport": "sono",
    },
    {
        "orig": "権力",
        "kana": "ケンリョク",
        "hira": "けんりょく",
        "hepburn": "kenryoku",
        "kunrei": "kenryoku",
        "passport": "kenryoku",
    },
    {
        "orig": "は",
        "kana": "ハ",
        "hira": "は",
        "hepburn": "ha",
        "kunrei": "ha",
        "passport": "ha",
    },
    {
        "orig": "国民",
        "kana": "コクミン",
        "hira": "こくみん",
        "hepburn": "kokumin",
        "kunrei": "kokumin",
        "passport": "kokumin",
    },
    {
        "orig": "の",
        "kana": "ノ",
        "hira": "の",
        "hepburn": "no",
        "kunrei": "no",
        "passport": "no",
    },
    {
        "orig": "代表者",
        "kana": "ダイヒョウシャ",
        "hira": "だいひょうしゃ",
        "hepburn": "daihyousha",
        "kunrei": "daihyousya",
        "passport": "daihyousha",
    },
    {
        "orig": "がこれを",
        "kana": "ガコレヲ",
        "hira": "がこれを",
        "hepburn": "gakorewo",
        "kunrei": "gakorewo",
        "passport": "gakorewo",
    },
    {
        "orig": "行使",
        "kana": "コウシ",
        "hira": "こうし",
        "hepburn": "koushi",
        "kunrei": "kousi",
        "passport": "koshi",
    },
    {
        "orig": "し、",
        "kana": "シ、",
        "hira": "し、",
        "hepburn": "shi,",
        "kunrei": "si,",
        "passport": "shi,",
    },
    {
        "orig": "その",
        "kana": "ソノ",
        "hira": "その",
        "hepburn": "sono",
        "kunrei": "sono",
        "passport": "sono",
    },
    {
        "orig": "福利",
        "kana": "フクリ",
        "hira": "ふくり",
        "hepburn": "fukuri",
        "kunrei": "fukuri",
        "passport": "fukuri",
    },
    {
        "orig": "は",
        "kana": "ハ",
        "hira": "は",
        "hepburn": "ha",
        "kunrei": "ha",
        "passport": "ha",
    },
    {
        "orig": "国民",
        "kana": "コクミン",
        "hira": "こくみん",
        "hepburn": "kokumin",
        "kunrei": "kokumin",
        "passport": "kokumin",
    },
    {
        "orig": "がこれを",
        "kana": "ガコレヲ",
        "hira": "がこれを",
        "hepburn": "gakorewo",
        "kunrei": "gakorewo",
        "passport": "gakorewo",
    },
    {
        "orig": "享受",
        "kana": "キョウジュ",
        "hira": "きょうじゅ",
        "hepburn": "kyouju",
        "kunrei": "kyouju",
        "passport": "kyouju",
    },
    {
        "orig": "する。",
        "kana": "スル。",
        "hira": "する。",
        "hepburn": "suru.",
        "kunrei": "suru.",
        "passport": "suru.",
    },
    {
        "orig": "これは",
        "kana": "コレハ",
        "hira": "これは",
        "hepburn": "koreha",
        "kunrei": "koreha",
        "passport": "koreha",
    },
    {
        "orig": "人類普遍",
        "kana": "ジンルイフヘン",
        "hira": "じんるいふへん",
        "hepburn": "jinruifuhen",
        "kunrei": "zinruifuhen",
        "passport": "jinruifuhen",
    },
    {
        "orig": "の",
        "kana": "ノ",
        "hira": "の",
        "hepburn": "no",
        "kunrei": "no",
        "passport": "no",
    },
    {
        "orig": "原理",
        "kana": "ゲンリ",
        "hira": "げんり",
        "hepburn": "genri",
        "kunrei": "genri",
        "passport": "genri",
    },
    {
        "orig": "であり、",
        "kana": "デアリ、",
        "hira": "であり、",
        "hepburn": "deari,",
        "kunrei": "deari,",
        "passport": "deari,",
    },
    {
        "orig": "この",
        "kana": "コノ",
        "hira": "この",
        "hepburn": "kono",
        "kunrei": "kono",
        "passport": "kono",
    },
    {
        "orig": "憲法",
        "kana": "ケンポウ",
        "hira": "けんぽう",
        "hepburn": "kenpou",
        "kunrei": "kenpou",
        "passport": "kempou",
    },
    {
        "orig": "は、",
        "kana": "ハ、",
        "hira": "は、",
        "hepburn": "ha,",
        "kunrei": "ha,",
        "passport": "ha,",
    },
    {
        "orig": "かかる",
        "kana": "カカル",
        "hira": "かかる",
        "hepburn": "kakaru",
        "kunrei": "kakaru",
        "passport": "kakaru",
    },
    {
        "orig": "原理",
        "kana": "ゲンリ",
        "hira": "げんり",
        "hepburn": "genri",
        "kunrei": "genri",
        "passport": "genri",
    },
    {
        "orig": "に",
        "kana": "ニ",
        "hira": "に",
        "hepburn": "ni",
        "kunrei": "ni",
        "passport": "ni",
    },
    {
        "orig": "基く",
        "kana": "モトヅク",
        "hira": "もとづく",
        "hepburn": "motozuku",
        "kunrei": "motozuku",
        "passport": "motozuku",
    },
    {
        "orig": "ものである。",
        "kana": "モノデアル。",
        "hira": "ものである。",
        "hepburn": "monodearu.",
        "kunrei": "monodearu.",
        "passport": "monodearu.",
    },
    {
        "orig": "われらは、",
        "kana": "ワレラハ、",
        "hira": "われらは、",
        "hepburn": "wareraha,",
        "kunrei": "wareraha,",
        "passport": "wareraha,",
    },
    {
        "orig": "これに",
        "kana": "コレニ",
        "hira": "これに",
        "hepburn": "koreni",
        "kunrei": "koreni",
        "passport": "koreni",
    },
    {
        "orig": "反す",
        "kana": "ハンス",
        "hira": "はんす",
        "hepburn": "hansu",
        "kunrei": "hansu",
        "passport": "hansu",
    },
    {
        "orig": "る",
        "kana": "ル",
        "hira": "る",
        "hepburn": "ru",
        "kunrei": "ru",
        "passport": "ru",
    },
    {
        "orig": "一切",
        "kana": "イッサイ",
        "hira": "いっさい",
        "hepburn": "issai",
        "kunrei": "issai",
        "passport": "issai",
    },
    {
        "orig": "の",
        "kana": "ノ",
        "hira": "の",
        "hepburn": "no",
        "kunrei": "no",
        "passport": "no",
    },
    {
        "orig": "憲法、",
        "kana": "ケンポウ、",
        "hira": "けんぽう、",
        "hepburn": "kenpou,",
        "kunrei": "kenpou,",
        "passport": "kempou,",
    },
    {
        "orig": "法令",
        "kana": "ホウレイ",
        "hira": "ほうれい",
        "hepburn": "hourei",
        "kunrei": "hourei",
        "passport": "hourei",
    },
    {
        "orig": "及び",
        "kana": "オヨビ",
        "hira": "および",
        "hepburn": "oyobi",
        "kunrei": "oyobi",
        "passport": "oyobi",
    },
    {
        "orig": "詔勅",
        "kana": "ショウチョク",
        "hira": "しょうちょく",
        "hepburn": "shouchoku",
        "kunrei": "syoutyoku",
        "passport": "shouchoku",
    },
    {
        "orig": "を",
        "kana": "ヲ",
        "hira": "を",
        "hepburn": "wo",
        "kunrei": "wo",
        "passport": "wo",
    },
    {
        "orig": "排除",
        "kana": "ハイジョ",
        "hira": "はいじょ",
        "hepburn": "haijo",
        "kunrei": "haijo",
        "passport": "haijo",
    },
    {
        "orig": "する。",
        "kana": "スル。",
        "hira": "する。",
        "hepburn": "suru.",
        "kunrei": "suru.",
        "passport": "suru.",
    },
]


def test_kakasi_structured_constitution():
    kakasi = pykakasi.kakasi()
    result = kakasi.convert(original_text)
    for i, e in enumerate(expected):
        assert result[i]["orig"] == e["orig"]
        assert result[i]["hira"] == e["hira"]
        assert result[i]["kana"] == e["kana"]
        assert result[i]["hepburn"] == e["hepburn"]
        assert result[i]["kunrei"] == e["kunrei"]
        assert result[i]["passport"] == e["passport"]


@pytest.mark.benchmark
def test_benchmark(benchmark):
    kakasi = pykakasi.kakasi()
    benchmark.extra_info["data_size"] = len(original_text)
    result = benchmark(kakasi.convert, original_text)
    assert result[0]["hira"] == expected[0]["hira"]
