# Copyright (c) 2021 CNES
#
# All rights reserved. Use of this source code is governed by a
# BSD-style license that can be found in the LICENSE file.
import numpy
import pyinterp.geohash as geohash

testcases = [
    [0xc28a4d93b20a22f8, "sb54v4xk18jg", 0.497818518, 38.198505253],
    [0x003558b7d15148f1, "00upjeyjb54g", -84.529178182, -174.125057287],
    [0x949dcd034ca43b30, "kkfwu0udnhxm", -17.090238388, 14.947853282],
    [0x7d44be93dc8c3d1f, "gp2cx4ywjhyj", 86.06108453, -43.628546008],
    [0x801e4ccef502f590, "h0g4tmrp0cut", -85.311745894, 4.459114168],
    [0xd90e166bb45673b6, "v471duxnbttv", 57.945830289, 49.349241965],
    [0x81d1418fe43c871f, "h78n33z47k3j", -69.203844118, 11.314685805],
    [0x7ef3c3f9b722a109, "gvtw7yer4bhh", 77.073040753, -3.346243298],
    [0x03adcf02afef7916, "0fqwy0pgxxwj", -76.156584583, -136.834730089],
    [0x644a3e6ab5fbafd6, "dj53wuppzfrx", 28.411988257, -85.123100792],
    [0xbcd540239bd297fb, "rmbn08wvubcz", -11.597823607, 146.281448853],
    [0xb663a5ee6c8fa0df, "qtjucvmdjyhe", -16.010823784, 120.67064801],
    [0x4f24b9f758e2851e, "9wkcmxuswb2j", 35.419323354, -105.572143468],
    [0x49c85bd32bc93b07, "9745rntct4xh", 17.482266365, -120.621762327],
    [0x73213a6da3c7ca39, "fdhmnve3sz53", 57.159413941, -61.222135062],
    [0x0f044c9a65ca1bc2, "1w24t6m5t8ew", -54.391332719, -112.262179799],
    [0x575f88776cb53f16, "bxgshxvdqnzj", 89.33987042, -152.372551026],
    [0xf435c4f4150cf21b, "yhuw9x0p1mt1", 72.901011648, 96.39410362],
    [0x3cdb6f164961823d, "7meqy5k9d613", -12.857855257, -28.909737376],
    [0xc1d93b954a63f23d, "s7dmr5bbdgt3", 20.631055855, 14.722834905],
    [0x62f7bbb928678a26, "dcvvrf98dy52", 10.780452593, -47.821303925],
    [0xb2179f2d04b17845, "q8ctyc84q5w4", -39.761862556, 114.906271436],
    [0xa4b27243b74f03d0, "nkt74hxr9w1x", -64.134116191, 108.730725942],
    [0xa179bd0cca8bb24a, "n5wvu36bjft4", -69.294877597, 99.682985421],
    [0xa079222feba1cd94, "n1wk4czcn76t", -80.849571944, 98.920826744],
    [0x1530f246840cc164, "2nsg4jn41m0q", -7.882319175, -173.224128085],
    [0xdfbd1106fd0b9b7b, "vyyj21rx1fer", 83.899684283, 87.197879407],
    [0x6965c308fd2fd59a, "e5kw627x5zbt", 19.382500173, -38.568029617],
    [0x0c7f5145e6e372d7, "1jzp2jg6wete", -56.349801648, -125.151500328],
    [0x4aef4c3a5c4dcbb8, "9crnsfkw9r5v", 8.187341946, -91.191271032],
    [0x80c854b7dee04393, "h3459eyyw11t", -83.738044201, 14.137947303],
    [0xd493a59a7aebaf1d, "uk9uc6muxfrj", 71.160606083, 13.774107755],
    [0xe890a8694e4600a3, "x28bhubf8s0b", 2.839043217, 147.514480254],
    [0x5eed92fed26ac0d8, "cvqt5zqkec0e", 75.450760056, -91.935835199],
    [0xf3674c82c1a0a21a, "yemnt0q1n2j1", 64.425373268, 119.75949151],
    [0x198d449ce5fcca9e, "366n9775zm59", -31.182648256, -120.878132359],
    [0x0b81884da977eb75, "1f0shme9fzpr", -78.016323338, -100.355173113],
    [0x405e9f9198615636, "81g9z4dsd5c3", 10.165892946, -174.766986944],
    [0xded0cd3060d500b0, "vv8dud30un0c", 76.433419177, 79.652424948],
    [0xd2c0a330de5f2835, "uc0b6d6ycwn3", 50.682496153, 34.918400151],
    [0x0fa45fc018f86aec, "1yk5zh0sz1pf", -54.16177647, -95.316385169],
    [0xd8b7c528794d300c, "v2vwbb3t9ns0", 50.407625844, 64.019442379],
    [0xbc64d034131b0daf, "rjke0e0m3d6u", -14.924012658, 141.350509363],
    [0xc3b6ae4b11e3f9b9, "sfvbwksjwgwv", 15.582323691, 42.116387781],
    [0x860cb92613863fa9, "hs6ck9hmhszu", -65.867645766, 26.570981636],
    [0x0b7c08facfc37b3d, "1ey0jyqgsexm", -68.871297151, -103.800341659],
    [0x59e1d741422b35b2, "c7hxfhb25duv", 63.263412836, -117.333484316],
    [0xab8c832252abce1d, "pf6868kkpg71", -77.297727015, 172.381661592],
    [0x8c67ac1d8c9c3fc7, "jjmus7ddmhzw", -59.658095434, 53.27636308],
    [0xdbf4141d69242eb8, "vgu187c94hrc", 66.378215883, 84.388142665],
    [0x669c31b670e9bbc6, "duf33emhx6xw", 26.95711635, -53.01283175],
    [0x742220e83702e057, "fhj21u1r0ch5", 67.523180302, -82.5385289],
    [0xe359b46aba47ee30, "wedv8upu8zr3", 20.677081069, 116.410831463],
    [0xee06355c03e2103f, "xs33br03w883", 24.252579808, 159.269421738],
    [0x4adbbece3f7e83cd, "9cevxmjzgu1w", 9.433115669, -95.649899396],
    [0xa247bed92c4c93c4, "n93vxq9d9k9w", -81.965793153, 115.281656662],
    [0x754e47e28a17c1f1, "fp74gsnb2z0z", 86.286702788, -85.618138439],
    [0xf00c1f2fe9e69795, "y061ycz9wuct", 46.723764176, 93.119722304],
    [0x9e9d94357103c03a, "muft8ecj0g03", -17.292979155, 82.289003746],
    [0x3998ebdf47185f7b, "76dfrru731gr", -30.498851637, -29.55832495],
    [0x397522c6ea3b5789, "75uk5jrb7ecs", -23.174222138, -38.880806118],
    [0x634e27bd64ca5046, "de72ggc4t984", 18.434122958, -62.763283163],
    [0xffbd3be866569556, "zyymru36bubp", 83.915446347, 177.881387638],
    [0xf4e3c34a93c67fbd, "ymjw6knmstzv", 74.246581453, 109.092038728],
    [0x440dfed688e34088, "8h6zxpn8we08", 25.263163488, -175.815989102],
    [0x943316e1bf44ce8f, "khtjesez8m78", -18.694668135, 7.190224189],
    [0xa2744de6729fb223, "n9u4vtmkmyt2", -79.643247942, 118.374162886],
    [0xca090a1eba8d939f, "t84hn7pujq9t", 0.720326999, 70.598028855],
    [0xfeb10afcb6cd21fe, "zushpz5qtnhz", 71.055226408, 174.720260646],
    [0x09b7a446601542b8, "16vu8jm02p1c", -73.711314615, -115.657193453],
    [0x21e9a733be3b3202, "47nufdxy7dt0", -72.27521983, -69.137149187],
    [0x97afa4cc827cc4ff, "kyru9m42gm2g", -9.025110998, 44.706599785],
    [0xe40058e30a272290, "wh05jssb4wj9", 23.052095343, 90.248337023],
    [0x92c8e81139c5a8f1, "kc4fh49tsqng", -39.008727685, 37.795220131],
    [0xfef36777a7f97b07, "zvtqfxx7z5xh", 77.165885506, 176.252942053],
    [0x48eb0cc05e9fbd24, "93phth2ymyyk", 6.440471427, -113.685238245],
    [0xe035861cf09a7be1, "w0usd77hm9xy", 5.028357065, 96.431368314],
    [0x86b89245d29818d4, "huw94jfkm0de", -64.479400185, 42.981823476],
    [0xb178156141d4b0e4, "q5w1bsb1uksf", -24.978465313, 98.459661462],
    [0xb27858439e718379, "q9w5hhwyf61r", -36.009266318, 121.122649451],
    [0xc8fbcb691f7baf53, "t3xwqu8zgfrp", 9.562195714, 67.09470629],
    [0x6e21a5b8e4e5e28b, "eshucf74wrj8", 23.347787328, -15.739012399],
    [0xe8e564792f938b87, "x3kq8y9gkf5s", 8.210103138, 152.26213344],
    [0x2be6497a09d58914, "5gm4kyh9uq4j", -71.289949664, -4.003644877],
    [0x7adbb62f9b416b53, "gcevdcwv85pp", 54.413498088, -5.846433654],
    [0x00792f91a41f9f24, "01wkz4e43ygk", -80.713382948, -170.899120913],
    [0x107c6a33c25bf95d, "21y6ndy2cgwp", -34.789432458, -170.916626518],
    [0x2e3c6b38ae986f65, "5sy6qf5fm1rq", -62.874361764, -13.408932436],
    [0x0efbde6b8fe8086b, "1vxxwuwgx046", -57.718820187, -90.396920678],
    [0x5e0e5d7ed58cb48c, "cs75uzqpjku8", 69.606482362, -108.06403843],
    [0x316ccd8e3e92e6bb, "65qdv3jykcmc", -26.228778598, -80.62055385],
    [0x399860e50705c0f4, "76d61t870r0g", -30.555171945, -30.519664463],
    [0x9acca5fa5d40e9cb, "mc6bcykx83nw", -37.801287909, 82.70029131],
    [0xa35a5c5355ffd0c8, "nee5snupzz8d", -69.658815818, 116.900357853],
    [0xb3ec2adcaad5b793, "qgq2pr5buqvt", -26.680131978, 132.863005776],
    [0xde0310d1ae158079, "vs1j1nef2q07", 68.415030813, 68.955356447],
    [0xb9e8aa6437e90f04, "r7nbnt1rx47h", -28.096233881, 156.02985314],
    [0x6bb2d8cdc72ad95e, "eftejmf75cdp", 14.621953772, -3.281658328],
    [0x971e33c2b61d343e, "kwg37hpq3nu3", -6.788441405, 27.2121537],
    [0xa006ff78ee7f75ca, "n03gyy7fgxuw", -87.899723375, 92.762874736],
    [0x715fcd43e48514f9, "f5gwuhz4hnbg", 67.306746065, -84.892557798],
    [0xc655d6df20070a22, "stbxert00w52", 33.703340295, 23.352839671],
    [0x821fac203d3b0577, "h8gus81x7d2r", -84.988976419, 27.973402046],
    [0xba0a1537cadab1ef, "r851beybvbsy", -44.671650847, 161.7502458],
    [0x9649dcaf9e2a7ea2, "kt4xtcwy59zb", -15.547361482, 26.27774099],
    [0x93f78b0d22c13481, "kgvsq392s4u8", -23.150839292, 41.760927592],
    [0xb48eb9f8807d003f, "qk7cmy40gn03", -20.840903219, 106.778999007],
    [0x03822b21e0677854, "0f12q8g0dxw5", -78.701808161, -144.202307721],
    [0xff6072fd9331ad71, "zxh75zdm66qr", 84.944457022, 163.644552332],
    [0x5d914a977e57ddc2, "cq8np5vybzfw", 82.638988192, -123.434450713],
    [0x38822b95c6a4cc3e, "7212r5f6nm63", -44.935083556, -31.681208896],
    [0x0a5f398a1ce6711c, "19gmm2hwwtsj", -79.232252184, -107.692510243],
    [0x1e3f62abea3c4206, "3szq5bzb7j10", -17.222372775, -102.129119318],
    [0xed7ca14641cf4b2d, "xpyb2jk1tx5k", 43.666830267, 144.497921239],
    [0x307329bc9c914127, "61tkmg4wk50k", -35.797860399, -82.360896608],
    [0xa758f0f1ce825ed8, "nxdg1wffh9ge", -47.247724148, 116.43708],
    [0x315106109eec4435, "658hd44yxj23", -24.509353774, -89.90803204],
    [0x1a616764d7c73e99, "39hqft6rswz9", -38.15831357, -106.410280948],
    [0x9f9b485baec0b68b, "myenhqxfs2v8", -7.346673701, 83.166350612],
    [0x4a70e1709b1f5520, "99sf2w4v3xbk", 8.866910289, -105.79449857],
    [0x51d6ae8bf83dff41, "b7cbx2zs7rzn", 66.186532697, -165.960010429],
    [0x902722c8c964f89b, "k0mk5k69dmw9", -42.866991819, 7.529173579],
    [0xdcdf60963dc866e4, "vmgq15jxt1mf", 78.416211599, 60.872033224],
    [0x49f6f6b8ed7da0c1, "97vgef7egqhd", 21.722020296, -115.494315527],
    [0x7f469f0ba28c8649, "gx39y2x2jk34", 86.091636985, -20.105783569],
    [0xb81303eefcaeceb7, "r09h7vrwpv7c", -41.410532148, 136.581682342],
    [0x5c355cd30587fdf2, "chuptns5hzyz", 73.073372688, -129.149567248],
    [0xf98661d671264eb4, "z6363pmj4t7c", 58.092469996, 148.058736614],
    [0x0a23394cd708ad53, "18jmkm6r12qp", -89.04710512, -104.927268171],
    [0xb6f07346fe1a90e9, "qvs76jry3b8f", -13.461295854, 129.825172431],
    [0x56067f0a1bcbe19c, "bs37y2hvtght", 69.566390855, -155.460753178],
    [0x8e647a7aff5c77fa, "jtk7nyrzcjvz", -59.90571157, 73.783887292],
    [0x94779d1f29d45ab4, "kjvtu7t9ujec", -11.625951544, 7.9288724],
    [0x95176160ac64b2e1, "kncq2s5ddktf", -5.910190836, 1.784695975],
    [0x1192d6cfa1743a8c, "269eemx1fhx8", -30.291728586, -166.488093614],
    [0x53e16b7b96580320, "bghqqywqc01k", 63.010497772, -139.968178907],
    [0x7939eb9639f99caa, "g4wyr5jtz6fb", 60.178614149, -35.192327116],
    [0x7e9d55a77447745a, "gufpc9vn8xu5", 73.09182562, -8.364688476],
    [0x347fabe1331126c5, "6jzurs9m24md", -11.883546663, -78.770248663],
    [0x6bc0d1be3c0447ee, "eg0e3gjw0j3y", 17.463827805, -10.462414963],
    [0x7be4fcf49d8397d0, "ggkgtx4xhfcx", 63.936154081, -4.324974161],
    [0x6b6f953fbfaa2000, "eertbgxzp8h0", 19.312419902, -11.90919577],
    [0xffd0292bd133bee6, "zz82kbyj6fzf", 87.236481597, 169.318671057],
    [0xb28429a04af3551b, "qb22m82byebj", -43.548281648, 124.344570889],
    [0x2ff878b8ee91dca3, "5zw7jf7fk7fb", -47.2723902, -2.202915933],
    [0x889a76d4ac796d17, "j2e7ep5dg5qj", -86.533323002, 60.957091889],
    [0xa64d72c1eed822f0, "nt6r5hgfv0jg", -59.211716108, 115.801270607],
    [0x6de12385a9b3c725, "erhk71e9qg3k", 40.130542888, -27.636503665],
    [0xa91c68725710ab31, "p4f6hwkr22pm", -74.144109778, 138.367673384],
    [0x2320fe0d0bfe1335, "4dhgw38czs9m", -78.126200344, -60.544300755],
    [0x027a80739310a2fb, "09x80wwm22jg", -81.525892653, -146.922550519],
    [0x21841e3ff1d4b439, "4621wgzjuku3", -77.058466003, -78.443567838],
    [0xb4d80a297160c86e, "qmd0nbcjd346", -14.05743018, 104.360603995],
    [0x0b3c44c4acffb8eb, "1dy49j5dzywf", -74.063823715, -104.013406233],
    [0x1f548e56f0afa283, "3xb8wprhpyj8", -1.277815059, -111.523249963],
    [0x647277d3fad89e61, "djt7gnzuv2g6", 31.634578359, -82.47447887],
    [0x15859b21a56f9a8d, "2q2tq8e5eye8", -8.917516032, -167.756944729],
    [0x4d4a72f0b86e984f, "9p575w5seud4", 39.936099822, -130.270908449],
    [0x3c2652a704f480a1, "7hm559s4yk0b", -20.557672925, -37.809178971],
    [0x74074eeab7679d7c, "fh3nxuprdyfr", 70.072125724, -88.243096236],
    [0x034cb1e48c64e4e9, "0e6c3t4ddmkf", -71.471099912, -153.563358182],
    [0xbc3c2c5c399c8bd3, "rhy2sr1tmk5x", -18.153983311, 143.978120168],
    [0x248a5dae2871ad8c, "4k55vcj8f6qs", -66.835185565, -74.270905883],
    [0xad931bfdf6706b83, "pq9jrzgqf1ps", -52.470911617, 148.001385373],
    [0x329a1ffa7c242246, "6be1zymw4hj4", -41.844498665, -51.683028079],
    [0xce48f2bd98fb351e, "tt4g5gdszduj", 28.672400911, 71.535743214],
    [0x3a1bc7fdcd39fe39, "78ewgzfe77z3", -40.957826277, -17.409747485],
    [0x6575273193a30df9, "dpukfddmnd6z", 44.443315464, -83.910201452],
    [0x2ab232a81adbd94f, "5bt35b0uvgdn", -87.010883438, -3.701112851],
    [0xf615482fdf91fbd2, "ysbnhcyzk7xx", 72.784315039, 112.71820254],
    [0x644098f2862d51ef, "dj09jwn65p8y", 28.334124955, -89.046462627],
    [0x84bb434a02c59119, "hkxn6kh2sq8j", -63.566772948, 21.198646014],
    [0x11e0a1117eb796db, "27hb24cyqyce", -28.064838838, -162.067617252],
    [0xfc8f27393d8e2d2c, "zk7kff9xjsqk", 69.756169059, 150.943466677],
    [0x0bdc3c3586912753, "1gf3sed6k4mp", -68.622952499, -97.884915192],
    [0x2a0b67b10d860b7d, "585qgd8ehs5r", -88.799205881, -17.774994607],
    [0x40bf19e1ae01731e, "82zjmsef05tj", 5.166683833, -158.659393946],
    [0xa18d7bd37cc1068e, "n66rrnvws438", -76.031129099, 104.729406777],
    [0x0bb955bf327ad7b8, "1fwpcgtkgccv", -74.555143607, -92.728222397],
    [0xa7673717c62be991, "nxmmf5y65gnt", -48.187048118, 119.979455926],
    [0x93cae3d985a59166, "kg5f7qd5nq8q", -27.693235665, 39.169275058],
    [0x0b540afa9e71c00c, "1eb0pynyf700", -68.872116083, -112.150057306],
    [0x35406a588c448ee4, "6p06nq4d8k7f", -5.240026109, -89.370330229],
    [0x1d53134c667d2b30, "3p9j6m36gnpm", -1.860304227, -133.493017911],
    [0x63cae0934b9e1c40, "dg5f14ucmsf4", 17.241909117, -50.925855316],
    [0xe34598a5b1a98f3c, "we2tj9ejp67m", 19.169267305, 113.449259778],
    [0x96eeab1da2927881, "kvrbq7e2k9w8", -15.405527603, 44.927760749],
    [0x3efadaa322296007, "7vxep8t255h0", -13.532393409, -0.366191153],
    [0x69bba51cbfaf3db4, "e6xub75zpwyv", 14.91517922, -22.835095332],
    [0x9959ef7bada09e47, "m5dyyyxen2g4", -24.089751522, 49.174390405],
    [0x41a1d7becc2f0bbb, "86hxggqd5w5v", 12.630533887, -162.247998186],
    [0x2459f84cb08d52c9, "4jdzhm5hjp9d", -57.803838136, -85.941708225],
    [0x846b7aceddd87798, "hjprpmqxv1vt", -60.614351527, 10.523064536],
    [0xdf6cae82261e934b, "vxqbx0j63u9n", 85.869552091, 77.307091165],
    [0xd3b4eb99347dc86a, "ufufr69ngr46", 60.879187338, 40.749807126],
    [0xb3d58806497f0f6b, "qgbsh1k9gw7q", -23.195923556, 124.635240938],
    [0xaaabed662e474a42, "pbpyutjf8x54", -88.785543693, 179.854113465],
    [0xc24bf3d2eaaee230, "s95z7nrbpvj3", 6.933773356, 27.916256142],
    [0xe59e09b41f1e07f4, "wqg0me0z3s3z", 38.030443437, 105.711545941],
    [0xa4e23bb7a8644ffd, "nmj3rex8dj7z", -61.635932068, 108.972793127],
    [0xce9b1148c7e8b5e9, "tuej2k67x2uy", 26.259303417, 82.983143917],
    [0x1f91141927ae3436, "3y8j8697psu3", -7.456429463, -101.236969348],
    [0x2906ea4d88a83da3, "543fnmd8p0yu", -76.961970353, -42.26066146],
    [0x718011ba0fecf168, "f6013fhgxmsq", 56.481344253, -78.666255562],
    [0x106fa6f3ef1a9fc9, "21ruewzg3bgw", -37.140092525, -168.937030933],
    [0xbb2561786ae8eaf7, "rdkq2y3bx3pg", -31.210693076, 163.512246418],
    [0x6e3ba5fa3e6e3554, "esxucyjyesup", 26.181562495, -11.516606163],
    [0xac35960eec28bd78, "phutd3rd52yr", -62.307238141, 141.437449685],
    [0x4f9ca63bb506547e, "9yfbdfxp0tb7", 38.0716066, -97.252327803],
    [0x1974c2348eede140, "35ud4e4fxrhn", -23.53774028, -128.557918654],
    [0x723e10c4d8c257d6, "f8z11j6ss9cx", 49.424153496, -57.608676241],
    [0x0054ece783a1e995, "01bfttw3n7nt", -79.686395731, -178.694753248],
    [0x69caae0e3c2a4962, "e75bw3jw594q", 16.969420143, -28.194197856],
    [0x67098c6a028eaa05, "dw4ssuh2jup0", 34.563009892, -63.769542088],
    [0xe56c2f7bd244302a, "wpq2yyyk8hs2", 40.950961411, 99.094282424],
    [0xabb1266ea2cde246, "pfskdvp2trj4", -75.118894724, 174.857600601],
    [0xad6c33245bbcd04a, "ppq3692vrm84", -48.991225895, 143.900267218],
    [0x8bb966b6b5262e40, "jfwqeepp4sr4", -74.777217594, 87.702600863],
    [0x336af88194f8595b, "6epgj0dnz1dp", -27.593741671, -56.378785941],
    [0x83b781ec5f457ee7, "hfvs3v2z8pzf", -73.754011045, 41.562319763],
    [0xba3d179636b2bd95, "r8yjg5jqqbyt", -39.752950409, 166.07684412],
    [0x1b73f809d5305534, "3etzh2fp61bm", -24.076656493, -104.224462129],
    [0x065a8bb3cb5d4490, "0te8rdyccp29", -59.003108987, -152.239221778],
    [0x41aa8a4d6fa20848, "86p8nmcgn844", 11.282101037, -157.925781695],
    [0x109195ea6841a214, "228tcum886j1", -41.153315052, -167.962400122],
    [0x5804a882967411f7, "c02bj0nqfh8z", 46.407434186, -133.716915929],
    [0x218044c23fa40c8f, "46049hjznh68", -78.287349629, -78.697897133],
    [0xf9bba0aa9c2fc2e8, "z6xu1bnw5z1f", 59.766692856, 157.234431711],
    [0xd5acdb2f0793fd57, "uqqeqcs7kgyp", 80.736358154, 20.69330437],
    [0x175a0999812c5481, "2xe0m6d15jb8", -2.75461922, -153.047661045],
    [0xcdc1779640c0b1f7, "tr0rg5k0s2sz", 40.755247298, 56.739080506],
    [0xe44983a5e3884050, "wj4s79g3j105", 28.88186092, 93.674111409],
    [0x8cf0a3af1f884bd5, "jmsb7cszj15x", -59.009106646, 63.101224828],
    [0x251f01dc6bf915d5, "4ngh3r3cz4bx", -51.244037755, -85.723614006],
    [0x9d23a3b6a81cc9eb, "mnju7ep83m4y", -10.486379403, 53.250103389],
    [0x004a2ca9733b7961, "0152tbcm7ewq", -84.282068442, -175.175126694],
    [0x068cc76193a3ecd7, "0u6dfsdmngqe", -65.58475595, -142.621123326],
    [0x9162d79171745765, "k5jeg4cjfjcq", -27.449695074, 7.867671798],
    [0x08d7c2456ec35bd1, "13cw4jcfseex", -79.069527639, -121.550133282],
    [0xcde57b1a980a4d43, "trkrq6ns196n", 42.067344805, 62.510214248],
    [0x7785c23591b2a599, "fy2w4edjqbkt", 81.231067058, -55.433969231],
    [0x92e993fcf1e53492, "kcnt7z7jwnu9", -38.41134245, 43.059803426],
    [0x91a314f018c46376, "k6jj9w0ssjjr", -32.749443572, 18.348033481],
    [0xe6d2b6cc21c1e779, "wv9cem11s7mr", 31.228913873, 126.355322683],
    [0x2532702659827cc4, "4nt709kth9yd", -52.902421671, -82.588833124],
    [0xbb0fab4ed3a881b6, "rd7uqmqmp20v", -31.566981307, 163.056991],
    [0xf97357bad1cd230e, "z5tpgfqjtnjh", 66.063141403, 142.204506242],
    [0x88211182e24df459, "j0hj30r29ru5", -89.075647156, 50.678960877],
    [0x07967ce907913957, "0yc7tu87k4wp", -51.390723738, -144.238978774],
    [0x76ad363726a41e9c, "fuqmdet6nhg9", 69.892642032, -47.343602073],
    [0xc31e8ae307e281a1, "sdg8pss7wb0u", 15.494070806, 27.757592078],
    [0x7a76d2913b36d969, "g9ve549v6vdq", 55.385758458, -14.631264556],
    [0x4960fe88cdbd0ce4, "95hgx26ern6f", 17.492199549, -127.997971661],
    [0x6d47eb56235438e5, "ep3yqpj3bhwf", 41.918659973, -42.268171747],
    [0xffc5cbbd970fab95, "zz2wrgdr1ypt", 86.900343686, 169.796876292],
    [0xa0468a1705f4e523, "n138n5s5ymkk", -82.948851312, 92.378814054],
    [0x8d001694414acbd2, "jn01e5219c5x", -55.968211293, 45.131915857],
    [0xdd7be916c4073a7c, "vpxyk5q40wx7", 88.304364401, 56.082489913],
    [0xa55396981881fbc9, "np9te60sh7xw", -46.834010299, 92.253076544],
    [0x4ed5370d21b685bf, "9vbmf391qu2v", 33.362970305, -100.797896317],
    [0x54da25c91f8d2002, "bme2ck8zjnh0", 76.095289025, -164.123505847],
    [0xc5df8e5923e0bac1, "srgswq93w2xd", 44.420731774, 16.448528122],
    [0xc2d6340f13d5d50c, "scc383smurbh", 10.11669101, 35.524817909],
    [0x54e2d7ac6e01c1c7, "bmjegc3f070w", 73.791406708, -160.848415332],
    [0xfdddf2365140faa8, "zrfz4ekj83xb", 89.843023722, 150.232565253],
    [0x21e7755ae6fe94b5, "47mrbqr6zubc", -70.321615187, -71.345911146],
    [0xe1bc9e1d7a52e74d, "w6y9w7cubcmn", 15.75384448, 110.667725535],
    [0x97fd120f009b45f2, "kzyj43s0me2z", -0.519042479, 42.292107281],
    [0x18fcd8df7a6a7a6c, "33yejrvue9x6", -34.585553258, -114.370605536],
    [0x3310679a1c9626b3, "6d86g6hwksmc", -30.442019315, -66.999234504],
    [0x921c6195cbb17a55, "k8f635fcq5x5", -40.364908835, 25.712051288],
    [0x414957b90667870b, "854pgf86dy3h", 18.251501014, -177.022242118],
    [0x6e22e434fcd90da4, "esjf8e7wv46u", 22.958477453, -14.387065014],
    [0xb642ce1d24379def, "qt1dw7946yfy", -16.415897213, 114.885528531],
    [0x1c08e3997817e3a1, "3h4f76cs2zju", -22.088618148, -130.987890322],
    [0xdcf36ce3523ae4a6, "vmtqtsuk7ckb", 77.106907029, 63.880515608],
    [0x2dde6bca2dd22260, "5rg6rkjeu8j6", -45.988125445, -28.853330697],
    [0xed36967b5b9fc6e6, "xnv9dyuvmz3f", 38.270441272, 142.86199694],
    [0xcd2ab1031f4a4034, "tnpc20sz9903", 33.973766249, 55.905025397],
    [0x981af71a9481445f, "m0egf6nnh525", -41.516285912, 50.380726163],
    [0x4b024479b2fddd7f, "9d148yekzrfr", 11.726016998, -111.056013377],
    [0xb4225551156dd0a4, "qhj5bn8per8b", -21.803786944, 97.031390564],
    [0xa75eaa41d89522ce, "nxgbnhfsknjd", -46.379395267, 118.040721974],
    [0x9bcfb03b27856998, "mg7v0ft7hpnt", -25.825557438, 84.063786811],
    [0xa7a860bee59ae10e, "nyn61gr5mchh", -55.880020688, 132.625832284],
    [0x4929086bda4d8734, "94nhhuyu9q3m", 11.980024465, -126.344434719],
    [0x880df1755ed30a76, "j06z2xbyud57", -87.275593884, 48.890387735],
    [0x7d0e9415ca960f18, "gn7985fbks7j", 80.4405878, -40.07415109],
    [0x1fb167468cd11e77, "3ysqfjndu4g7", -7.223023253, -95.176444317],
    [0x930b261684fa4f60, "kd5kd5n4z97q", -32.942025092, 27.166769115],
    [0x2065d51feb5b952e, "41kxb7zccfbk", -81.585530027, -83.650169911],
    [0x0d0f543d08861b6f, "1n7p8g88hseq", -53.506139278, -130.747406584],
    [0xfdb9b904ec22d00d, "zqwvk17d4c80", 82.492569546, 155.922893473],
    [0xba7dd1dad2c3fae1, "r9yx3qqksgxf", -33.846711997, 166.704353996],
    [0x72dbb4d1437956b3, "fcev9nb3g5cc", 54.441696479, -50.93214262],
    [0xdb6a46a5243959f6, "vep4e99475dz", 62.323099183, 77.499064445],
    [0xfea3f9b86dce2065, "zujzmf3etsh6", 68.787396437, 177.090924755],
    [0xd7ff465d3ab3411b, "uzzndr9uqe0j", 89.778273394, 43.695309442],
    [0xe30c9eb472c06d35, "wd69xe3ks1qm", 12.938554819, 116.347111562],
    [0x0a81c0e155722406, "1b0w1sbpf8k0", -88.917888143, -100.480844224],
    [0x304f9eb0db27722b, "617txd6v4xt2", -36.988694891, -84.744643972],
    [0x0760c3152a380eaa, "0xhd659b707b", -50.210221848, -151.081447066],
    [0xa761f2e763437efd, "nxhz5tv38ezg", -49.362667309, 119.340737928],
    [0xac8636febb64924b, "pk33ezpvdk94", -65.790657299, 148.183348596],
    [0xc69d423b75ea79ca, "sufn4fvpx9ww", 27.789840214, 36.69054697],
    [0x017c3902f23d4826, "05y3k0rk7p42", -68.684382924, -171.025068012],
    [0xc8c7e8962a15ebab, "t33yj5jb2rpu", 8.102498188, 58.938581893],
    [0x465d913d51ab125f, "8tft2gbjpd95", 33.288073282, -153.951092549],
    [0x6d833e2be7154d54, "eq1mwbz72p6p", 34.721514826, -31.685597596],
    [0xc1d4b9949315237b, "s7bcm54m2njr", 21.330890683, 12.527511343],
    [0x7a60c4dbb6535153, "g9hd9qxqbe8p", 51.101337403, -16.106965452],
    [0x4eefe9b5311cf1db, "9vryme9j3msx", 30.650040867, -90.108429988],
    [0x8a88038df4bc3932, "jb4073gnrhwm", -89.945343763, 81.709751025],
    [0x753f90faaa33bcfb, "fnzt1ypb6fyg", 83.880673463, -79.365450329],
    [0x79457221c32b29cc, "g52r48f35dnw", 64.516022144, -44.535325172],
    [0x392aa078cd516c3e, "74pb0y6eb5q3", -33.715006298, -34.065161625],
    [0x95f6c48b9814ecd0, "krvd92ws2mqe", -0.963292033, 19.0482525],
    [0xe6fe497f5d59abcf, "wvz4kzuxc6pw", 32.783172074, 133.808734045],
    [0x5627e5b154357fcb, "bsmycdbn6pzw", 70.108995162, -149.348048354],
    [0x9009c38f8f6bddde, "k04w73wgegfx", -43.892505214, 3.667881573],
    [0x9746037052c40213, "kx306w2ksh11", -4.139678243, 24.016629695],
    [0xdbde585c49f4ecf0, "vgg5hr29ymqg", 66.661248283, 83.156481556],
    [0x8d0f11c5ad1074bd, "jn7j3jee21uc", -53.890118417, 49.267508433],
    [0xd6937574caa0f1b5, "uu9rbx6bn3sv", 71.714639157, 35.533836312],
    [0x3d29b7b3e4352472, "7nnvgdz46nk7", -10.223731305, -35.344299204],
    [0xa690d114d84adc27, "nu8e256s9cf2", -64.097576152, 124.456636451],
    [0x9b040e4c2a77815c, "md20wm1bfy0p", -32.228231359, 67.777179722],
    [0x911a4791eb7f7e01, "k4e4g4gcgxz0", -30.438653303, 4.355895389],
    [0xae0b6b6fbf7a8aa5, "ps5qqvxzgb5b", -66.369824278, 162.377752374],
    [0x1a9388581d4ab8a3, "3b9shq0x9bwb", -41.450125815, -98.953086536],
    [0x0927f87161bd6da0, "14mzhwc1rpqu", -76.075948224, -126.714625801],
    [0x5ea5707fd8700f40, "cukr0zysf07n", 70.180108551, -95.23146224],
    [0xa5b474938385a3c0, "nqu794w3hqjw", -51.402077841, 107.279280649],
    [0xb76c98f783f39c6d, "qxq9jxw3yff6", -4.001454391, 121.891200161],
    [0x22bb35f5f0599831, "4bxmcxghc6d3", -86.133356746, -45.984592938],
    [0x1a588dc90eab85fd, "39d8vk8fpf2z", -36.405588101, -108.752298327],
    [0x3ce3d042801388ff, "7mjx0hn02f4g", -15.622504311, -26.007349126],
    [0xde2580bb658bee63, "vsks1fv5jgr6", 69.625013998, 73.912152369],
    [0xbdb63acee3bd6226, "rqv3pmr3rpj2", -6.826377404, 153.961679969],
    [0x5242d672815c078c, "b91edwn1ch3s", 51.273517345, -155.272476811],
    [0x6d4b0d4efc71ccfc, "ep5humrwf76g", 40.239976801, -40.584082282],
    [0xda64d7a6d6e9aff7, "v9keg9qqx6rz", 52.698425339, 73.990838337],
    [0x727e5360ad6509d6, "f9z56s5edn4x", 55.437646016, -57.541490887],
    [0x8918ac9b2ac51b1d, "j4dbt6tbsnej", -75.8357548, 49.105972725],
    [0x4a039b45f13e827c, "981tqjgj7u17", 0.955360555, -110.122670401],
    [0x727f49edf574b4db, "f9znmvgpfkue", 55.975324948, -57.399341693],
    [0x3d08eee88d40c987, "7n4fxu4e834s", -10.787967233, -40.788788926],
    [0xbca4e9345ba3a794, "rkkfke2vnfmt", -20.679518093, 153.128768503],
    [0x3efb2175f57fa71d, "7vxk2xgpgymj", -13.271492785, -1.028427097],
    [0x9117747a241650a8, "k4cr8yj42t8b", -28.17951586, 1.797660642],
    [0x45d792764eafe255, "8rct4xkfpzj5", 44.512863228, -166.523899227],
    [0xe149e4cda5754c99, "w54y9me5fp69", 18.048473371, 93.926328418],
    [0xeaed6602687dec5b, "xcqqd0m8grq5", 8.17536961, 177.634654081],
    [0x635b4af6bd0964d1, "deenpxpx15ke", 20.781859278, -62.94131152],
    [0x74c43a29c433132a, "fm23nbf46d9k", 74.711551472, -78.098950795],
    [0xc87633a8e8a3d48f, "t1v37b78ngb8", 10.064870108, 52.552704621],
    [0xc535eb48dc982ec6, "snuyqk6wm0rd", 39.091803421, 6.958003719],
    [0xe53c7526c4e71a8d, "wny7b9q4wwe8", 38.635260316, 98.819558794],
    [0x1a04433f9c0f26f5, "38246gww1wmg", -43.177951963, -112.370151904],
    [0xe2ed61250249f19a, "wcqq298297st", 8.13822801, 132.56143848],
    [0x11a300d99a39e4d1, "26jh1qdu77ke", -33.01042188, -161.659896224],
    [0xa639f3f3eedaf8c5, "nswz7wzfvcwd", -63.375526469, 122.156894646],
    [0xd0a5b1239d635fd2, "u2kv28wxdegx", 47.333156933, 17.960698682],
    [0x5b0018bc87437203, "cd01jg478et0", 56.442880409, -112.244196291],
    [0x8299873e4298db5d, "hbdsfgk2m3ep", -86.334633991, 37.392540603],
    [0xe10b3eb128b9771e, "w45mxd98r5vj", 12.230593743, 94.902269671],
    [0x9ea3667455e55e69, "mujqdx2pwpg6", -21.316267015, 86.242937807],
    [0x943e8f520bdcdf75, "khz8ynhcvmgr", -18.116122501, 10.817299708],
    [0x61a234dfa7bb58b5, "d6j39rx7redc", 11.555447598, -71.301973925],
    [0x2a52e6fc7bddee62, "599fez3vvrr6", -81.082195144, -19.871629182],
    [0x15928a736d402328, "2q98nwve80jk", -8.399819618, -166.347420103],
    [0xdbb86d9fc060d7ee, "vfw6v7y0d3cy", 59.566594134, 87.77811433],
    [0x80163040cdce3350, "h0c30h6etstp", -85.58149667, 1.761488477],
    [0xb1c5ad6b920362dd, "q72uuuwk0eje", -25.85836643, 102.522039876],
    [0x717775c6b8dd8787, "f5vrcjpsvq3s", 67.484370258, -82.562715093],
    [0x4b5591109e63ce75, "9ebt244ydg77", 22.028721787, -111.792976011],
    [0x24749ac1821078e6, "4ju9phd221wf", -57.45569812, -83.36115872],
    [0x65c34de9975d481e, "dr1nvudrcp41", 40.587610891, -77.08792867],
    [0x7b0518c41859f7af, "gd2jjj0sc7vu", 58.563458382, -22.279525146],
    [0x2337ba92feb292cf, "4dvvp4ryqb9d", -73.638908095, -59.09551034],
    [0x8dbd555146552ae5, "jqypbnb6bnpf", -50.631361709, 64.687853736],
    [0x09626aefc4246c6d, "15j6pvy44jq6", -72.741479843, -127.268277151],
    [0xd8a03b2837e49692, "v2h3qb1rwkc9", 45.221039685, 62.525180293],
    [0x92d7769bf96d29d8, "kccre6ztennx", -33.821806916, 35.661072156],
    [0x36606548c2f72aca, "6th6bk62ywpd", -16.368094339, -61.509072006],
    [0xb824ef03caae9f85, "r0kfy0ybpugs", -43.106205377, 141.95296639],
    [0xecaa4145ee35a35c, "xkp42jgf6qjp", 22.927513188, 156.099003325],
    [0x617427d8e9e41bb4, "d5u2gq79whev", 21.260200794, -83.875546146],
    [0x41a223967663016f, "86j275mqdd0q", 11.312925785, -161.228033882],
    [0xf07c44902d1a2be4, "y1y4941e38py", 55.294748463, 98.483580034],
    [0xd2e54b1540518948, "ucknq5b0b64n", 53.150622693, 39.638685527],
    [0xb903a7738ed927a6, "r41ufwwfv4mu", -32.878848578, 137.580292922],
    [0x77f45a4cd5cee45b, "fzu5nm6ptvk5", 89.151249063, -50.347342816],
    [0x13a9d29a8994ce27, "2fnx56n9km72", -32.508302055, -136.957439484],
    [0x39a27df66be4f566, "76j7vxmcwmuq", -33.050705409, -26.117317833],
    [0x60a4b9ab914c4bb9, "d2kcmbwj9j5v", 1.62969501, -71.809339034],
    [0x6baad8c36b51c8aa, "efpejhvcb74b", 11.803752814, -0.475487279],
    [0xdaa3ef42eef0e8eb, "vbjyyhrfy3nf", 46.21034723, 87.110529941],
    [0xa833ab379209be19, "p0tuqewk16z1", -86.420501966, 143.380228311],
    [0x26bfa7978a976d6d, "4uzug5wbkxqq", -62.426980009, -45.210255152],
    [0x4a787ecc00c34d8f, "99w7xm00se6s", 9.080304269, -103.392137253],
    [0x3889e57658133e9a, "724ybxks2dz9", -43.772906626, -29.854628185],
    [0x4a94e26ae86ed789, "9bbf4ur8evcs", 4.593775848, -100.064000085],
    [0xde03c89da3a102ae, "vs1wj7e3n41b", 68.574096073, 69.844811248],
    [0xcf07f5be013f01a1, "tw3zcgh17w0u", 36.535281661, 70.043486252],
    [0xa02796789d3f0218, "n0mtdy4x7w11", -87.59271724, 97.858809605],
    [0xb8e9dc889fa7812e, "r3nxt24zny0k", -38.055406028, 155.625404752],
    [0x51f8c8da4da0088b, "b7wdjqken048", 65.073909816, -159.37222115],
    [0xa61ea22b53280ab9, "nsgb4bum505c", -63.276271593, 117.900257605],
    [0xb14565e60ac09fd6, "q52qcthbs2gx", -25.504669597, 90.4241908],
    [0x9d334fb35fc0bd65, "mntnzduzs2yq", -7.234577737, 52.367553765],
    [0x4e65816d119bc423, "9tks2v8jmg22", 30.309451424, -106.138668797],
    [0x0b894dd228435356, "1f4nvnj88e9p", -77.530411696, -98.210197416],
    [0x1ff4283fb13936fa, "3zu2hgxj74vg", -1.38610742, -95.054947518],
    [0x6a2cd56279967f96, "e8qebsmtktzt", 2.089708626, -13.329645979],
    [0x9cc1e334ea676f67, "mm0y6e7bdxrq", -15.758388546, 57.419817726],
    [0x42eb4a9d65c82ed3, "8cpnp7c5t0re", 6.700889579, -136.086048439],
    [0xa9a7bc4669ec9ca4, "p6mvsjm9xkfb", -76.34783093, 154.519586743],
    [0x9a43b50da1b1c198, "m91vb3e1q70t", -38.355786541, 69.97631283],
    [0xcad7d3311095457b, "tccx6d8hkp2r", 11.132666651, 80.969410535],
    [0xa3bf8caeec5f58ae, "nfzstcrdcxdb", -73.732855533, 134.559928543],
    [0x142625b8191929f8, "2hm2cf0t34nz", -20.950014595, -172.539544342],
    [0xcbf6667411c70780, "tgv6dx0jsw3s", 21.572633647, 86.242870941],
    [0x9fb8aec6e697094c, "mywbxjr6kw4n", -8.320350728, 88.559957094],
    [0x28b20d3fd572bdbb, "52t0ugypfbyv", -87.033729383, -26.501642681],
    [0x66f3c9572e303f1b, "dvtwkptf60zj", 32.077722718, -48.33185183],
    [0x1de35991a3d81beb, "3rjpm4e3v0ey", -4.336548861, -116.49434033],
    [0x89f989cf213a39ec, "j7wsmmt178wy", -69.534998905, 65.628363792],
    [0xedf862d65bf4450d, "xrw65pkvyj2h", 42.579903975, 155.17767929],
    [0xe3820f2e2ca897d6, "wf10ycjdp2cx", 11.387677714, 125.460747215],
    [0x6e6a514a91accf3d, "etp52knjpm7m", 28.719149175, -12.636708233],
    [0x4298307b9a57f4ef, "8bd30ywubzuf", 3.024844283, -143.043669915],
    [0x9efd2101df1cef80, "mvyk20fz3mrs", -11.903786429, 87.542902761],
    [0x5c31bf0ed27c8d06, "chsvy3qkgk6h", 71.330947589, -128.036928985],
    [0x455c8febc280fc26, "8pf8zuy2h3y2", 43.751687942, -176.135024881],
    [0xb5db477fb7a31b6f, "qrenfzxrndeq", -1.583561657, 105.599839552],
    [0xa9129b104f5c8017, "p499q42gck01", -75.704748335, 137.374130583],
    [0x2cdc5b702e3d5c2a, "5mf5qw1f7pf2", -57.051574118, -30.649320129],
    [0x3f7913662af40774, "7xwj6tjbyh3r", -1.862029784, -13.944481115],
    [0x9e3b5c5523f04c6c, "msxpsp93y166", -18.327634354, 77.521508572],
    [0x0a2780c9bc46d8a3, "18ms1kew8vdb", -87.864760401, -104.705850856],
    [0x8368146e659ad079, "hen18vm5mc87", -72.831922486, 30.977572755],
    [0x517f5e456634a919, "b5zpwjc66knj", 67.444103682, -169.890756684],
    [0x1e1a1a3da0775bcc, "3se1nge0fxew", -19.492322601, -107.9803871],
    [0xbb753332313157a7, "reum6djj65cu", -22.971489972, 163.593380563],
    [0xdb3695e87c262227, "vdv9cu3w4sj2", 60.800764719, 75.313453694],
    [0x3ef808e7720b12d9, "7vw0jtvk1d9e", -14.030213702, -2.56352437],
    [0x3ff7756e93ae4b82, "7zvrbvnmpt5s", -0.015593652, -3.82531878],
    [0x7ec9dda6d7885de4, "gv4xv9qrj1fy", 74.49538327, -7.48387441],
    [0x405eac10538f29fa, "81gbs42mjwnz", 9.944891947, -174.550192576],
    [0x4082576d263e803f, "8215fv967u03", 0.689800101, -167.221022239],
    [0x994404103f1dacf3, "m520841z3qqg", -26.618594408, 45.002466048],
    [0x2a4ab21c3b5c5501, "595c471vcjbh", -84.18172062, -17.125239371],
    [0xd49a1866723555ea, "uke1htmk6pby", 70.517892509, 15.67380079],
    [0x7a85ab398edd5559, "gb2uqfdfvpbp", 47.167568093, -9.894690297],
    [0xaa9b959c561723a4, "pbetc72q2wju", -86.157799163, 173.727179142],
    [0xe2ba16e28c68a01d, "wbx1esnde2h1", 3.098574018, 133.756629994],
    [0x41ce2e7c3033a82a, "8772wz1h6fn2", 18.40833307, -163.881556628],
    [0x579c3103817caebd, "byf320w1gkrc", 83.191546645, -143.077547657],
    [0xa75f4423cc029a04, "nxgn88yd0be0", -45.259205887, 116.749685302],
    [0x9c400fa44c9bc290, "mj00z92dmg19", -16.73589509, 45.330525298],
    [0x21631c4868be6e0a, "45jjsk38rtr0", -72.134786059, -82.779590971],
    [0xfbb31b085a3e69d5, "zftjq22u7tnx", 59.98748254, 176.057097164],
    [0xe259a59377b26ff3, "w9duc4vrq9rz", 9.288819634, 116.418632075],
    [0xfabf940ebbdab7bc, "zbzt83pvvbvv", 50.192032042, 179.318758984],
    [0x0e38995e110d9208, "1sw9krhj1q90", -64.42842811, -103.167059044],
    [0xfe7b4820d0628bbb, "ztxnh86hdb5v", 76.994334182, 167.544373807],
    [0x096454f583fd4c10, "15k59xd3zp61", -71.061977426, -129.305689025],
    [0xc1088e6d90ac99f1, "s448wvdhpkdz", 11.368815049, 3.815317323],
    [0xbd42793cfe56cc97, "rp17kg7ybv69", -5.034670975, 136.971738266],
    [0xafe2b316c87ee309, "pzjc65q8gvjh", -50.387264355, 176.932922395],
    [0x1e1526800945e4e4, "3sbke0098rkf", -17.489937564, -112.015897789],
    [0x388f35cfca82f7b0, "727mcmybhcvv", -42.551411861, -29.115274577],
    [0x05c575b20575b266, "0r2rcdh5fqt6", -47.84477995, -168.326922617],
    [0xc76498144b723bcc, "sxk9h52cf8xw", 40.97518822, 29.005053733],
    [0xfc1b12a0714dd793, "zhej583j9rct", 71.193766169, 139.373987638],
    [0xddb2dde92c944594, "vqtevu9dkj2t", 82.246814277, 64.239292896],
    [0x81320ba2879a87a0, "h4t0r8n7mb3u", -75.892994773, 7.369672037],
    [0xfa03efbad683d96e, "z81yzfqqhgdq", 46.199932908, 160.310303869],
    [0x35342d481d1093eb, "6nu2uk0x229y", -6.876193109, -83.835969887],
    [0xf421294db30801c9, "yhhkkmem100w", 68.278142076, 96.167837094],
    [0x68fef03951cb78a9, "e3zg0fbjtewb", 10.387162925, -22.818358217],
    [0xddf1b22c79066f87, "vrsv4c3t0trs", 88.074159995, 63.052628652],
    [0xf6b847681ac9c19e, "yuw4fu0ut70t", 70.818660623, 132.309605847],
    [0xe94e595a51e5288a, "x575kqkjwnn8", 18.887847673, 139.41127725],
    [0x26eb5ff4ef46e8f4, "4vppzx7g8vng", -60.472241644, -46.071468996],
    [0x0c92bbb62700df6c, "1k9crej703gq", -64.450768468, -120.952247566],
    [0x7217bc7e8a3823f1, "f8cvsznb70jz", 50.224043166, -64.820916046],
    [0x8e4efd3010f3c7ba, "jt7gud0hyg3v", -59.797750289, 72.971483721],
    [0xe9d7f570cbffccb0, "x7czbw6czz6c", 22.490726471, 148.737023022],
    [0x087f031a6bb86d32, "11zh66mcr1qm", -79.396597919, -125.049167743],
    [0xf2e7d6e5708ad443, "ycmxetchjcb4", 53.381891519, 131.639803772],
    [0x4cbd3ae25ee459ed, "9kympskywjdy", 27.622148639, -114.624563122],
    [0x97f3bfe4b31321bf, "kztvzt5m2dhv", -1.77337907, 42.170018667],
    [0x784a1c70d7f0a9d4, "g151sw6ry2nx", 50.924335822, -40.580129215],
    [0x4382d4cd4e6b7749, "8f1e9mbfeevn", 11.897270419, -144.084506284],
    [0x7ab31062a34ed019, "gbtj0sp39v81", 48.713666148, -4.186745697],
    [0x83669767be74b93a, "hem9ftxyfkwm", -71.379736685, 30.354986484],
    [0xdb2b94181a244c9a, "vdpt860u4j69", 57.228498191, 78.058980751],
    [0x5c5f1bff55cd9f8a, "cjgjrzuptqgs", 78.310497928, -130.434950342],
    [0x2e55713a2fac300a, "5tbr2fjgphs0", -56.370310444, -22.107276013],
    [0xb8bd18b271fcd813, "r2yjjdmjzmd1", -39.888967335, 154.936379605],
    [0x88db6339cddd0c85, "j3eq6ffevn68", -80.448083566, 60.944813309],
    [0xb2fba5c24e801cf5, "qcxuchkfh0fg", -35.703845116, 134.699081326],
    [0xdbe7fba504643940, "vgmzr984dhwn", 64.564358139, 87.16562129],
    [0xaee0453159ed896d, "pvh4bdbtxq4q", -61.37551787, 174.397973633],
    [0x241538164aa27c57, "4hbmh5kbn9y5", -62.384480912, -89.465845971],
    [0x2105a252b683827e, "442u4npqhf17", -76.606624712, -88.847259679],
    [0x155b73b9a4925f83, "2per7fe4k9gs", -1.523956653, -175.26057473],
    [0xa51e6f03d7aec4ae, "nng6y0yrpv2b", -51.542501781, 94.842901341],
    [0xccf7ca4bb9a96ed8, "tmvwnkxtp5re", 33.424032999, 64.269643561],
    [0xdc2aa40d537f3e7c, "vhpb83bmgwz7", 67.598527546, 55.909927326],
    [0xae913adbe8afb99d, "pu8mpqz8pywt", -63.771479045, 169.430807203],
    [0x6099513d6a249689, "d2dp2gcb4kc8", 4.107538955, -75.902038969],
    [0x461b126ef08c909e, "8sej4vrhjk89", 26.220956413, -153.150561094],
    [0x51812f62d015e580, "b60kysqh2rks", 57.109076047, -168.104536408],
    [0x4b3dc81df501fe4c, "9dywh7gp07z4", 16.545259059, -103.168467215],
    [0x777a18d8ab546aa0, "fxx1jq5cbjpb", 87.396567496, -57.420376798],
    [0x79f9a80b92baecb3, "g7wuh2wkrcqc", 65.394108084, -24.06212008],
    [0x9a15a82666cecaeb, "m8buh9m6tv5f", -40.070802167, 68.759903229],
    [0xdf9c1838a8609431, "vyf1hf58d2b3", 83.155607683, 81.776143678],
    [0x2e8eea0c7a931fab, "5u7fn33ukdgu", -65.734575997, -5.699302582],
    [0xfe39f52f1dce0907, "zswzbcsxts4h", 71.684354181, 167.031565108],
    [0xfd667bece2909305, "zpm7rv72k29h", 86.381424583, 142.728035671],
    [0x8ea7d87a732e1ba3, "jumxhymm5seu", -64.828065803, 86.700480334],
    [0xcc10902477bbc0e7, "th89093rrg0f", 25.496408812, 45.727148003],
    [0xa4f0cc861a74fb0a, "nmsdt1hufmxh", -58.616708138, 107.804480916],
    [0x80b0b2004ceeffba, "h2sc402dxvzv", -87.009884586, 18.018608057],
    [0xaa5fb4462c2ccde2, "p9gv8jjd5m6y", -79.161614789, 162.781133873],
    [0xef22931469a6a8bf, "xwj96539nunc", 33.987772794, 165.324624557],
    [0x1fcf87025d146c05, "3z7sf0kx2jq0", -3.381142933, -96.234046443],
    [0x09a8bfcdb081b1a9, "16nczmehh6su", -78.411469628, -113.934900111],
    [0x28c59a927429d7c4, "532tp4mn57cw", -82.07643292, -32.732249828],
    [0xac4b82a0ea71bdb7, "pj5s587bf6yv", -61.170357214, 140.08093919],
    [0x0f0953e16c715606, "1w4p7scdf5c0", -54.949001099, -109.531544184],
    [0xf9cb3914cb220063, "z75mk56c4806", 62.815876418, 150.999978025],
    [0x5ca762a86ab50dad, "ckmq5b3bqn6u", 69.962388071, -116.199727913],
    [0xaca9e134d1bc15f0, "pkny2e6jrhbz", -66.382586521, 155.767208183],
    [0xb8aaabe6b8adbaaa, "r2pbrtpspqxb", -44.927867336, 157.488648822],
    [0xb8dcd98eaad7b587, "r3fem3pbuyus", -34.579302009, 150.007190894],
    [0x541dcf0cb7a0341b, "bhfwy35rn0u1", 72.911972468, -176.204990472],
    [0x6f976becf5673ff1, "eycqrv7pdwzz", 39.097546817, -9.147373702],
    [0xc7c8c63827921a30, "sz4ddf17k8e3", 39.82600024, 37.388388751],
    [0x4be12db06a4acd7a, "9ghkvd3b9c6r", 17.722414274, -95.029256593],
    [0xecd374574c67affa, "xm9r8puddyrz", 32.29889527, 148.014121009],
    [0xad7a8e7586fd9f07, "ppx8wxd6zqgh", -47.68290156, 145.83592471],
    [0xc233c22fd99e2110, "s8tw4cytmshj", 3.877724094, 30.364392472],
    [0x3f1017f2a8744477, "7w81gwp8fj27", -8.096766264, -22.335805391],
    [0xa5879b3f1ce966fb, "nq3tqgswx5mg", -53.900538568, 103.662494113],
    [0x073d22fd567b0ee1, "0wyk5zbqgd7f", -51.284381802, -148.545643946],
    [0xfedb1d3d34da153b, "zvejug9nv8bm", 76.968631895, 173.179100184],
    [0xfa83e108ee674b03, "zb1y227fdx5h", 46.100473522, 171.22718512],
    [0xfc09a1fb76c33f11, "zh4u3yvqsdzj", 68.285280632, 138.951504123],
    [0xf0d7772ee7ced6ac, "y3crfcr7tvcb", 56.213552892, 103.138867807],
    [0x54b56ac428da0ae9, "bkuqpj18v85f", 72.801032461, -162.463519106],
    [0x110f18fe0d76685b, "247jjzheftn5", -31.425720479, -175.522269015],
    [0xbb77b85602765e95, "revvhph2ftg9", -22.988731675, 165.767667224],
    [0xd2a16240024adfa5, "ubhq4h029cgu", 46.076756191, 39.814876654],
    [0x23027273281e474b, "4d174wt83t3n", -78.186878516, -65.624705105],
    [0xb0fe42eb6f09a447, "q3z45uvg16k4", -34.778067435, 111.266500465],
    [0xa5092ba1d950cadc, "nn4kr8ftb35e", -55.49781679, 93.497101209],
    [0x51f942c7b41ff933, "b7wn5jxn3zwm", 65.773513922, -160.170967403],
    [0xfe1567246779ea23, "zsbqf937g7p2", 72.912799798, 157.963291723],
    [0x3d77c6876b21db1f, "7pvwe1vc47ej", -0.253867417, -37.125791736],
    [0x089a8b06cee19584, "12e8q1qfw6bs", -87.136243536, -118.554914488],
    [0xb9585c7ec90d326d, "r5d5szq91nt6", -24.65723318, 138.030216772],
    [0xeef31beff7c7e22d, "xvtjrvzrszj2", 31.8932624, 176.131993661],
    [0x6aa88ba64aae2f70, "ebn8r9kbpsrr", 0.050835763, -1.772930373],
    [0x06e776d165755e66, "0vmrenc5fpg6", -59.112626008, -138.733887955],
    [0x2307beeb23cecd7e, "4d3vxut3tv6r", -76.351946968, -64.691026442],
    [0x2ba2d6975ba80a36, "5fjee5uvp053", -78.113307679, -3.376961027],
    [0x1315a9bec80cab0e, "2dbumgq81kph", -28.766304684, -156.183637233],
    [0xb8a4c7b61107930f, "r2kdgehj0y9h", -43.092978075, 152.737460576],
    [0x7d7a159d9e846128, "gpx1c7dyhjhk", 87.515400764, -35.097364238],
    [0x5e274df27cde2e0f, "csmnvwmwvsr0", 70.128287385, -105.219251924],
    [0xa31c7cbc6d2c2941, "ndf7tg3e5hnn", -73.897625328, 115.91894482],
    [0x9f589cffd3ece564, "mxd9tzymxmkq", -2.50528271, 71.277210496],
    [0x3a76fd6093f5a68a, "79vgus4myqm8", -34.47407707, -14.212942781],
    [0x9082db76e8c8a8f6, "k21eqxr8t2ng", -44.388799043, 13.655553675],
    [0x77c42560b6a91857, "fz22bs5qp4d5", 85.936102602, -55.871698449],
    [0x5de70092a33d20a2, "crmh14p37nhb", 86.495608109, -116.664713082],
    [0x8139243baba447b9, "h4wk8fxcnj3v", -75.132550753, 8.832924574],
    [0xbe618089a37b5b01, "rths12e3geeh", -16.168808484, 163.887674133],
    [0xfbbf24ee068165ed, "zfzk9vh6h5ky", 61.287593371, 179.028231502],
    [0xda87b59fe94d2b47, "vb3vc7z99npn", 47.437882387, 81.276221283],
    [0xa6cf66132422656e, "nv7qd4t449kq", -59.312087806, 128.415182864],
    [0x885bebd62dc60e0d, "j1eyrpjess70", -80.424791293, 50.58880516],
    [0xa427b479428b085d, "nhmv8yb2jd45", -65.089862902, 98.119478739],
    [0x91da708b2a053a74, "k7e712tb0nx7", -24.782374196, 15.883150359],
    [0x6bceef92118ad772, "eg7fz4hjjccr", 18.776503642, -5.663203586],
    [0xd33b6e5ae585e3cc, "udxqwqr5hrjw", 60.239964034, 32.979773753],
    [0x04c471e3508d629c, "0m273suhjpj9", -59.870643932, -168.32680424],
    [0x95f74b8a00878e35, "krvnr2h0hy73", -0.307583339, 18.605554896],
    [0x566a65af81726edb, "btp6ccw1f9re", 73.616945866, -147.219425847],
    [0xe38ddc6b15c70f4a, "wf6xsuspsw7n", 14.000650635, 127.480055804],
    [0xc05ef5420caa8a66, "s1ggbhhdpb56", 10.525246102, 5.279954415],
    [0x23cb41b1075f44b6, "4g5n3d87cx2c", -72.011951385, -51.964923232],
    [0x5f3e192543f33f79, "cwz1k9b3ydzr", 83.198406006, -102.4578639],
    [0xcc477238ea2d5c6b, "tj3r4f7b5pf6", 30.774120335, 46.883943984],
    [0x9dfe42ac106eab2c, "mrz45c0heupk", -1.048399647, 66.258715806],
    [0x46c81ae42aab7cb9, "8v41pt1bpeyc", 28.328267407, -143.105175764],
    [0xf3bd926a06387f18, "yfyt4uh671zj", 61.370025372, 133.017449435],
    [0x35398ec7b9877f18, "6nwsxjxthxzj", -7.615371236, -80.541255438],
    [0xf5ebb97d1664829c, "yrpvkz8qdk19", 85.34018784, 112.357619797],
    [0xfb08ce94ad10abc5, "zd4dx55e22pw", 56.70649166, 161.328069523],
    [0xdd6738dc155bb771, "vpmmjr0pcfvr", 86.699954775, 52.613607561],
    [0x407b398c733dd037, "81xmm33m7r83", 9.368159767, -169.572118067],
    [0xb07574e7849bff25, "q1ur9tw4mgzk", -33.807271037, 96.050976769],
    [0x26aa55b6c2a37e6e, "4up5ceq2nez6", -66.822946989, -46.331460013],
    [0xb6c59ed1efa67892, "qv2txnggntw9", -14.464329604, 124.766179813],
    [0x9451e8831809824e, "kj8yj0ss1614", -13.004368086, 1.28064912],
    [0x89ec432d69bd52e1, "j7q46cc9rp9f", -71.313373936, 64.810712334],
    [0xd9d3d5349bf70c14, "v79xbe4vyw61", 66.067305045, 58.385405882],
    [0x6089edc437d1db19, "d24yvj1ru7ej", 1.215339322, -74.661182681],
    [0x5f740f64c3d50c69, "cxu0yt63un66", 88.754759373, -106.586090683],
    [0x68bf08e1f433956e, "e2zhjsgn6fbq", 4.949056274, -23.660312275],
    [0xa663b56d09f2996c, "ntjvbv89ybdq", -60.833741212, 120.619876043],
    [0x695ee81a5152c33f, "e5gfh6kjbc1m", 21.458665527, -39.534267613],
    [0x4dd9c05dcb5d35c3, "9rdw0rfccnuw", 43.2850972, -120.219563051],
    [0x64ee547a9fb01e4e, "dmr58ynzq0g4", 30.180692351, -68.863759478],
    [0x860a91f743bf54b4, "hs593xu3rxbc", -67.237444987, 27.493952339],
    [0x693aedbb4b329424, "e4xfvfuc6bb2", 14.56122333, -33.842235449],
    [0xa74449aea5113fd8, "nx24mcp524zx", -48.817175176, 112.762308851],
    [0xb42992968ff6e834, "qhnt55ngyvn3", -21.603943429, 99.282028766],
    [0x603f8f6bb8e0e27c, "d0zsyuxsw3j7", 5.079208642, -79.145918947],
    [0xf459c512e5849453, "yjdwb4r5hkb5", 77.136924087, 93.52542057],
    [0x72c6bcfbd3eb17db, "fc3ctyymxdcx", 52.33296086, -53.527469756],
    [0x98268e47c00c22a5, "m0m8wjy01hjb", -43.474252098, 53.006337322],
    [0x2f0591fba45bd138, "5w2t3yx4cg8m", -53.884701177, -21.710282014],
    [0xcd1806a39571f925, "tnd0e8wpf7wk", 36.654487165, 47.974653342],
    [0xf8397e27a64829ad, "z0wrw9x690nu", 49.139529101, 144.084715556],
    [0x8fe44fce0a0b1a39, "jzk4zmhb1de3", -48.707872115, 84.700195625],
    [0xa259f43dba46aa0a, "n9dz8geu8up0", -80.224120596, 116.405338166],
    [0x5898dd02b92716b8, "c2deu0pt4wcc", 48.47257439, -120.048184246],
    [0xfdb09c9c010a3c71, "zqs9t70118y7", 81.842827617, 152.808910692],
    [0xcb2e2899c4473a60, "tdr2j6f48wx6", 12.671820565, 77.928803174],
    [0x43ea78e42153a684, "8gp7jt11bfm8", 17.430122166, -135.811575419],
    [0xa18babb4e8fb99f0, "n65ure78zfdz", -77.984933539, 106.858170174],
    [0x95205488b5d3688d, "knh5925puen8", -10.633419004, 5.684253532],
    [0x265e095ec1aa0f5f, "4tg0krq1p87p", -57.572304925, -63.085916506],
    [0x3403f04e5e875f66, "6h1z0mkyhxgq", -21.2396195, -87.521355399],
    [0x667d4665071f43de, "dtyndt873x1x", 33.51713725, -58.952226683],
    [0x45a4df5ae7d6f02c, "8qkeyqr7uvs2", 35.850435317, -162.137050721],
    [0x091ed62cceb4a773, "14gedc6fqkmr", -73.908738896, -129.953223468],
    [0xf6d9bf094e1b507b, "yvdvy2bf3e87", 76.95276763, 127.892940711],
    [0x508b981e0132c06c, "b25th7h16c06", 45.895606122, -163.635745664],
    [0x445b2388b134fbc0, "8jek725j6mxw", 31.685502054, -175.282638668],
    [0x6ec67f039f20c71f, "ev37y0wz433j", 30.194385573, -9.219147713],
    [0x75747fce75ffa943, "fpu7zmmpzynn", 89.283132413, -83.697626724],
    [0x381aaea153af2b43, "70ebx8bmpwpn", -42.094597951, -39.396297945],
    [0x71fae8d11568ac2d, "f7xfjn8pe2q2", 65.076057006, -67.631687836],
    [0xd063cc33d553eaff, "u1jwsdypbgpg", 51.784031429, 7.940411525],
    [0xec8d1712b3458694, "xk6jf4pm8q39", 24.928956439, 149.16035975],
    [0x8fe3b5fd3f4b8dc3, "jzjvcz9z9f6w", -49.571758497, 86.915323645],
    [0xe368dea8e950912c, "wenexb79b28k", 17.491911543, 121.986018979],
    [0x4d7e3e1f0f35f2c0, "9pz3w7sg6rtd", 43.877246451, -124.523402226],
    [0x39af734972575059, "76rr6kckbx85", -31.042387215, -23.454072307],
    [0x54f22a5ca708f7e6, "bmt2nr5713vy", 75.976477648, -161.088004586],
    [0x9e98f63bed767b15, "mudgdfzeftxj", -19.056485209, 82.748453469],
    [0x3e4b579b96b51be2, "7t5pg6wqqney", -15.497853627, -18.129581979],
    [0x266813fdb4343646, "4tn17zen6hv4", -61.612975894, -58.893492582],
    [0x9c42e89b8f67b15f, "mj1fj6wgdysp", -16.509067566, 47.70104378],
    [0xe55d81ea96c1da61, "wpfs3unqs7e6", 44.36392793, 93.601299145],
    [0x0fc97e96cf17e5b1, "1z4rx5qg2zkv", -49.288190155, -97.769011972],
    [0x14007a29379e0fd5, "2h07nb9rms7x", -21.968641017, -179.34984922],
    [0x6fbde71459ce249c, "eyyyf52ttsk9", 39.17409341, -1.66899297],
    [0x0c939ab3faa5d4e2, "1k9tpdzunrbf", -63.792758988, -121.300122784],
    [0xae4332ea4a92f530, "pt1m5ukbkcum", -60.972694644, 159.42934016],
    [0xe2d219fbfebc9f8e, "wc91myzyrkgs", 8.695404576, 125.419894712],
    [0x3572df138360812e, "6ptey4w3d20k", -2.139329145, -81.993272869],
    [0x1e896fbf98ddc812, "3u4qzgwsvr41", -21.293397362, -97.736206842],
    [0x5078cd61a3c8ed60, "b1wduse3t3qq", 53.945882893, -170.656924161],
    [0x40a8ab8547bd4154, "82nbr1b7rp0p", 0.054155096, -158.94955152],
    [0xf933ba144a3879d9, "z4tvn52b71wx", 59.959311212, 143.350776989],
    [0xa44a42548cab9ffe, "nj544p4dpfgz", -61.484625984, 94.31041181],
    [0x6b4a06fdb9b99a3c, "ee50ezetr6e3", 17.005004256, -18.111332879],
    [0x18b98dc954feb94a, "32wsvkbnzuwn", -41.325262652, -114.378321198],
    [0xcfae93d589905078, "tyr97pd9k187", 35.417398421, 89.432316372],
    [0xfa08c9c0794ef685, "z84dmh3t9vv8", 45.419828869, 161.237494024],
    [0xe54fc9a6cc94e19b, "wp7wm9qdkmht", 41.887163217, 95.172689355],
    [0xd33472fddeab842b, "udu75zfypf22", 61.03970786, 28.645467218],
    [0x73181def1192e69d, "fdd1vvsjkcm9", 59.401237815, -64.429109894],
    [0x4f86ee747d63d927, "9y3fwx3xdgdk", 35.636835638, -98.501236911],
    [0x11bfaac64e6781ac, "26zupjkfdy0u", -28.79882377, -157.537302968],
    [0x6193ac7146b7f9b9, "d69uswb6qzwv", 14.891021842, -76.090666363],
    [0xb7e759c6792e5a34, "qzmpmjmt5te3", -2.914608744, 131.008684247],
    [0x71eab34f27013f5a, "f7pc6mt704zp", 62.125469879, -67.745466089],
    [0xcf0725b37d4cd64d, "tw3kcdvx9mc4", 36.007635909, 69.331338727],
    [0xe27ac378f6615114, "w9xd6y7qd58j", 8.868475615, 123.172273694],
    [0x8277abad4d76647c, "h9vurcbeftk7", -79.398894142, 30.927313505],
    [0xea07e9b8403457e8, "x83ymf206jcy", 2.5173172, 160.213711455],
    [0x37623576df02d7a3, "6xj3bxqz0ccu", -5.276345602, -60.085910448],
    [0x33460ce07841865f, "6e30ts3s8635", -26.606728212, -65.849978472],
    [0x3eb8304a7e18847d, "7uw30kmy3227", -19.487297946, -2.442000567],
    [0x9d08d40fa371d0f0, "mn4e83x3f78g", -10.626206162, 48.536665292],
    [0xbd5749da644a636b, "rpcnmqm499jq", -0.272849315, 136.643901057],
    [0xa36811f690dbab2f, "nen13xnhvfpk", -72.865994342, 121.011914535],
    [0xa15c2de93a7a0d45, "n5f2vu9ug86n", -68.748876935, 93.419304267],
    [0xee87e8417a73f323, "xu3yhhcufgtk", 24.987864948, 171.389247177],
    [0xe5ec9f107f9e83a1, "wrq9y43zmu1u", 41.102493553, 110.656949298],
    [0x9d38cd65fa32fa16, "mnwdutgu6cx1", -7.921778009, 54.34365629],
    [0x29d9c9bdcf646c3c, "57dwmgfgdjq3", -69.192638585, -29.977818476],
    [0x72e32a631cb46c02, "fcjknsswqjq0", 51.353945315, -48.575097478],
    [0xbe69624c371eb7e7, "rtnq4m1r3uvy", -15.791575482, 166.389738978],
    [0xbdddd635e99cf9cf, "rrfxdeg9mmww", -0.06704603, 149.880529079],
    [0x721f9561c83d0d9c, "f8gtbsf87n6t", 50.255662105, -62.552586786],
    [0xf2a5cb8fc14b8f6a, "ybkwr3y19f7q", 47.514766456, 130.405048053],
    [0xc54869f7218ea62d, "sp46mxt1jum2", 39.811901143, 3.412882204],
    [0xd7572dc4939c0657, "uxckvj4mmh35", 89.457101418, 24.480845052],
    [0xe412c5a9723c5995, "wh9dcbck7jdt", 25.800778346, 92.188128079],
    [0xb528046077a52274, "qnn08s3rnnj7", -11.137528999, 98.461453853],
    [0x2aa740d14c2800a4, "5bmn1nbd500b", -87.501640224, -4.173988227],
    [0xc05fbbdbc5ffc2b6, "s1gvrqy5zz1c", 10.804361968, 5.600615854],
    [0xf2d7e0766b7a6a9b, "yccy0xmcg9p9", 55.938568937, 126.240967162],
    [0x21e9a836e18fefa0, "47nuher1jzru", -72.403810964, -69.050188367],
    [0x0af94001a3230f11, "1cwn00e34d7j", -80.504881303, -92.807925452],
    [0x5484c281324467aa, "bk2d509k8jmu", 69.261360424, -167.913314437],
    [0x5a07fda5b5596b89, "c83zv9epc5ps", 47.778141621, -109.793190228],
    [0xc385704f50703d41, "sf2r0muhf0yn", 13.919124925, 34.118135885],
    [0x7b096a79120dba2e, "gd4qny8k1qx2", 57.341114681, -19.038899695],
    [0x5ea04009bdd0abd9, "cuh402exu2px", 67.855640688, -95.609014534],
    [0x1710906b4d58af91, "2w890uuec2rt", -8.234980264, -156.757672469],
    [0x5a4905729c179c09, "c94hbwnw2yf0", 51.494029097, -109.656565862],
    [0xb2e1d8870942cf40, "qchxj1s98c7n", -38.136026298, 130.304067661],
    [0xaa5b063e2a5890b1, "p9ehdgjbc28c", -80.754873206, 161.84755074],
    [0xa72c4d05df9bddd6, "nwq4u1fzmgfx", -54.349472598, 121.117308028],
    [0xc78dea66a5835547, "sy6yntp5hebn", 36.238939554, 37.912638274],
    [0x0292fa4ae50b3deb, "0b9gnkr51dyy", -86.63627948, -143.504717574],
    [0x2678a4b4bb35c0b9, "4twb9e5v6r0c", -58.957190871, -57.936646943],
    [0x15921e1e7277deb7, "2q91w7mkfzgc", -8.155118064, -167.061758862],
    [0x53d2a4ad3b125c38, "bg9b9c9v29f3", 64.784541183, -143.709730231],
    [0xcc91859f7f1384f6, "tk8sc7vz2f2g", 26.169317535, 57.015986344],
    [0x8db293dbc826f579, "jqt97qy84vur", -53.180662479, 64.13624761],
    [0x87ae05ac3eefe23e, "hyr0cc1yxzj3", -54.705267259, 43.673397475],
    [0x0b95a31d459840a2, "1fbu67b5m10b", -73.763017045, -100.096219834],
    [0xb10945bea90e7dd2, "q44ncgp91tyx", -32.546793361, 92.899777202],
    [0xedb731fde5768b0f, "xqvm3zg5fu5h", 38.934839598, 153.713959032],
    [0x252af57f4944e48d, "4npgbzu98mk8", -55.547962503, -79.062406745],
    [0x52d19b7455cbaf63, "bc8tqx2ptfrq", 54.401477592, -145.260973865],
    [0xa7806b89dc5a8ff3, "ny06r2fwcb7z", -55.849211023, 124.423679518],
    [0xf3aa5ed24f59447b, "yfp5xnkgc527", 56.900228383, 133.907933868],
    [0x4b4258d9496b04a5, "9e15jqb9ed2b", 17.439692301, -110.862199178],
    [0xf0fa1e5bfb2747cb, "y3x1wqzv4x3w", 53.739149008, 111.379160827],
    [0x5d3ccf7a9fa9ed00, "cnydyynzp7qh", 83.48632718, -125.55315523],
    [0xdde4bd513558ef8d, "vrkcun9pc3rs", 86.125910672, 63.106905991],
    [0xdbc9069450028404, "vg4he52h0b20", 62.684556481, 81.694368179],
    [0x99938e10165bd429, "m69sw40qcgb2", -30.13431914, 58.623465842],
    [0x42da7ed016a48f24, "8ce7xn0qnk7k", 9.086746917, -141.371454355],
    [0xb2c44d797d23c268, "qc24uycx4g16", -37.44705463, 123.960920041],
    [0x6fe272f2ab94ad0d, "ezj75wpckkqh", 39.935540934, -3.702545238],
    [0x4a0ca85c37069226, "986bhr1r0u92", 1.445928014, -108.44429435],
    [0x6b77c8555eb1dd50, "eevwhpbyq7fp", 22.192103721, -14.588542853],
    [0x62b337516d0c230b, "dbtmfnce1hjh", 3.860858217, -48.777187023],
    [0x492c3c1417782b92, "94q3s50rg0pt", 12.937732583, -126.034674013],
    [0xeb1c0c370be3c1af, "xdf0sescwg0u", 15.576141094, 160.517067987],
    [0x4cce290b018454b8, "9m72k2s1hjbc", 29.578144574, -118.987253868],
    [0x17a8878ab07dd5d8, "2yn8g2phgrbx", -11.117305905, -136.956799355],
    [0xaa91d46ea50b27b5, "pb8x8vp51dmv", -85.841146771, 169.495769186],
    [0x2e6396922891aa2b, "5tjte4j8k6p2", -60.897163091, -14.62604353],
    [0xfdbf484a2850d4fe, "zqznhkj8b3bg", 84.045548906, 156.288082716],
    [0x7257216c488fc606, "f9ck2v28jz30", 55.619698412, -65.708293667],
    [0xe2adfea07948ec4b, "wbqzx83t93q4", 2.726933923, 133.573899286],
    [0x1c8c936ca215bdaa, "3k696v522qyu", -20.846477798, -120.109042131],
    [0xb1437ba5786cf380, "q51rr9csemts", -26.840170238, 92.089609178],
    [0x615631b72fddb862, "d5c33etgvqw6", 21.333381589, -88.168139283],
    [0xc9332ae2c2f02168, "t4tkpsq2y0hq", 14.789100706, 52.721248845],
    [0xc3d4a2165d713f5d, "sgbb45kxf4zp", 21.112949216, 34.898853402],
    [0x0877435c3b117a49, "11vn6r1v25x4", -79.018244635, -127.867460155],
    [0x569c09bb218d8788, "buf0mft1jq3s", 71.776634092, -143.177720433],
    [0x742905c7e36805d8, "fhnhcjz3e02x", 68.366806647, -81.508468696],
    [0x56cd7ffc583292a5, "bv6rzz2s6b9b", 75.93411253, -142.744554286],
    [0xff62df0118e8dc6d, "zxjey08sx3f6", 85.037708624, 165.499047846],
    [0x6063d84ed7844c67, "d1jxhmqrhj66", 6.885538121, -82.070099555],
    [0x1bc842bb6172a6a2, "3g445fv1fbmb", -27.758029514, -98.265712778],
    [0x8465271b0a28de9e, "hjkkf6sb53g9", -59.620046475, 6.082107014],
    [0x779a5605c60221a3, "fye5d1f608hu", 82.187691448, -51.940241546],
    [0x73fbb6d1fd1f6a43, "fgxvengx3xp4", 65.692658229, -45.214846158],
    [0xf8e8981f2b49dee5, "z3n9h7tc97gf", 50.820285412, 155.58534769],
    [0x86f1f1265637cd51, "hvsz29kq6z6p", -57.780106468, 40.457617373],
    [0x72d9f2e954df536f, "fcdz5ubnvx9q", 54.695261382, -52.217779549],
    [0x2b1140e62a73371f, "5d8n1tjbfdvj", -74.855202179, -22.426071281],
    [0x518f20657a56e19e, "b67k0tcubvht", 58.391803869, -164.155273034],
    [0x9c0186201f3266c0, "mh0sd80z69md", -21.707732767, 45.814132967],
    [0x55a8f01c7f5b3925, "bqng073zcdwk", 79.296541156, -159.244350103],
    [0x11260b5cb930daea, "24m0qr5t63ef", -32.260442922, -172.689183427],
    [0xc14695b065a2575d, "s539cd35n9cp", 18.601752505, 2.176946769],
    [0x2c38ee0e93f50041, "5hwfw3nmyn04", -64.241534057, -35.22431366],
    [0x95d5b34a71154fbd, "krbv6kmj2p7v", -0.459111393, 12.410436124],
    [0x6f05263b7e7277a6, "ew2kdfvyf9vu", 35.963540692, -22.019576374],
    [0xd66146d18c13e7ae, "uthnendd2gmu", 74.303688133, 28.260309385],
    [0x1b7641e78e7eda5b, "3ev43twfgve5", -23.480027642, -105.393397049],
    [0xc3dc777c84f88cdb, "sgf7fz44z26e", 21.791855811, 37.037973462],
    [0x1a55e9aa1d1817f4, "39bymbhx30cz", -34.056367344, -111.186401854],
    [0x28d1343a48ba40c7, "538m8fk8r90d", -80.583294765, -33.358976019],
    [0x4ca3a63c9c0a9399, "9kjudg4w1b9t", 23.308528668, -115.539702371],
    [0xaae243e562ccb894, "pcj47tc2tkw9", -83.947796249, 175.937009232],
    [0x279c212ac7fb8a16, "4yf22bq7zf51", -51.985276683, -53.044058673],
    [0xa8de218a0b31445a, "p3g232hc6525", -80.112072151, 150.881853423],
    [0xd857d55c0d7ecf9d, "v1cxbr0egv7t", 56.245179702, 47.121213778],
    [0xd95d1ac24a0cc03b, "v5fjphkb1m03", 66.996029243, 48.126694608],
    [0x95318b9ec224d724, "knssr7q24mck", -7.672545289, 6.655409882],
    [0xcb4d48e39262ba1f, "te6njswkdbx1", 19.361432214, 70.562909947],
    [0x3b5489a2657d5e00, "7eb8m8m5gpg0", -23.860246083, -21.548176494],
    [0xc7c33abd5d2cb80e, "sz1mpgbx5kw0", 40.275731486, 35.849223149],
    [0xd0c2c8f0e3ff1545, "u31djw73zwbn", 51.011232532, 13.605859323],
    [0xf0aebc6ad5d1c561, "y2rcsuqpu72q", 46.694616694, 112.365600288],
    [0xa9da7adb0a49adc6, "p7e7pqsb96qw", -69.749351659, 151.1455016],
    [0xff62186359fd9bd1, "zxj1hsutzqex", 84.577896928, 164.735499552],
    [0xe4335db764943c10, "whtpvev4khy1", 26.695815971, 97.279995411],
    [0x29f787c441adb378, "57vsgj21pqtr", -68.042242219, -25.883470666],
    [0xda6b7a8201fc8488, "v9prp0h1zk28", 51.855791973, 78.008734843],
    [0x798da554ef51b565, "g66ubp7gb6uq", 58.531696024, -29.877646162],
    [0x66c02fa6ee0ff17f, "dv02z9rf1zsr", 28.264087274, -55.558123519],
    [0xbdff94eba154dda6, "rrzt9ux1bmfu", -0.414401853, 156.883406846],
    [0x69c582d32209be52, "e72s5nt216z5", 19.020095837, -32.907766134],
    [0xa23dab25edc2e3f1, "n8yuq9gescjz", -85.02395924, 122.282850111],
    [0x6c9f138581bd469b, "ekgj71d1rp39", 27.650095002, -29.396364765],
    [0x752294a119b223b8, "fnj9988tq8jv", 79.017320536, -82.198733526],
    [0xfd738734244cd1cb, "zptsfe149m8w", 88.03940015, 142.845666174],
    [0x6accf357ec516f0a, "ec6g6pzdb5rh", 7.645601288, -7.284612509],
    [0x8bf429650a89988f, "jgu2kt8bj6d8", -68.832078727, 84.925575335],
    [0x968f000953be5237, "ku7h02bmrt93", -20.385574081, 37.980403344],
    [0xbc5b2c5cdad7ca3c, "rjeksr6uuz53", -13.230805715, 139.761065059],
    [0x7bd9b87f22b39aa0, "ggdvhzt2qfeb", 65.607661316, -7.166567722],
    [0x07f5a6808279eee2, "0zuue042g7rf", -45.615087852, -139.435236651],
    [0x1ceea8462de93bd5, "3mrbhjjex4xx", -15.440668648, -112.667917635],
    [0xef1147ee6e633ebd, "xw8ngvmfddzc", 37.778306769, 157.672809274],
    [0xc386898b02e764b8, "sf38m2s2wxkc", 12.703066797, 36.096209936],
    [0xc4688118785c65ec, "sjn8263scjky", 28.182149606, 9.153720783],
    [0xe5f252a082a59122, "wrt55842nq8k", 42.714879312, 108.438417195],
    [0x39c6f4177dfd8f9c, "773g85vxzq7t", -26.081551393, -31.281193339],
    [0x22bced2feb5b71cc, "4byfuczccesw", -85.287918213, -46.538358668],
    [0xa7da5119f86de408, "nze526gserk0", -47.225293359, 127.984687901],
    [0xa9a3d0a639581c22, "p6jx19jtc0f2", -77.513046991, 154.057892086],
    [0x3b382a76653a39d1, "7dw2nxm578wx", -30.89711276, -13.418267578],
    [0xdf8bd9547455b03d, "vy5xkp3nbqs3", 80.065433379, 83.849046139],
    [0x55acab1deb4bf82e, "bqqbq7gc9gw2", 80.221071056, -158.977920712],
    [0x2f617d4c623f0729, "5xhrum327w3k", -49.233779018, -16.33480118],
    [0xa268767a687245b0, "n9n7dym8f92v", -83.725297057, 121.417573564],
    [0xe9e2cb029df211e3, "x7jdq0nxy88y", 17.271841927, 154.257253309],
    [0x69e5d07192118876, "e7kx0wdk2647", 19.548165217, -27.396798598],
    [0x15454445ebb82e7c, "2p2n8jgcr0r7", -3.044369663, -179.994539847],
    [0x75f9c2122084ec19, "frww44j0hmq1", 88.253202206, -69.514427307],
    [0x648465abe3e57438, "dk26cbz3wpu3", 24.394067551, -78.311313459],
    [0x9dc88fac44b2e488, "mr48zc24qck8", -5.485904634, 60.10649713],
    [0x79acaec94bf2090e, "g6qbxkbcy84h", 57.770534325, -23.937897093],
    [0xc87506735cdc4a57, "t1uhdwuwvj55", 10.673030648, 50.741261803],
    [0xadf4bb646dcc5258, "prucqt3etj95", -46.157053465, 153.217608062],
    [0xc0514083142d3e09, "s18n10sn5nz0", 9.496000319, 0.049576836],
    [0x1b35a7a1b615fa0f, "3duug8eq2rx0", -28.692429224, -105.662020294],
    [0xcd9cf8637e67ce2f, "tqfghsvydz72", 38.523341097, 60.322960486],
    [0x7fadc55a946a9ae5, "gyqwbqnnebef", 81.376851369, -2.089982939],
    [0x95871a7fec1a84e4, "kq3jnzzd3b2f", -8.921883702, 12.963256709],
    [0x6b159b48c3a8d5b4, "edbtqk63p3bv", 16.415129488, -21.518814691],
    [0x3b8e30a8e3b21d3a, "7f731b73q8fm", -32.166376011, -6.598037733],
    [0xe888a7f67800abec, "x24bgxms02py", 0.172349141, 150.278570548],
    [0x40180d30a48c0006, "80d0ud54jh00", 2.955687164, -176.985411505],
    [0x4f1540d3ed77df47, "9wbn1nzefzgn", 39.061202835, -112.445632873],
    [0x57283df70ca9a492, "bwn3vxsdp6k9", 79.099171513, -148.462741148],
    [0xaaf630f4a35d06bc, "pcv31x53cn3c", -79.941682395, 176.203239151],
    [0x5fb69ed159b88b49, "cyv9xnbtr25n", 83.270403043, -93.20700583],
    [0x5206dad9cc2dffc9, "b83epqfd5rzw", 46.971058582, -155.068438478],
    [0x7e3b4e6917c2aed7, "gsxnwu8rsbre", 71.481086827, -12.359061803],
    [0x8bd7289a730e4761, "jgckj6mm1t3q", -68.18987784, 80.74580122],
    [0x831b9fe352fd6bcc, "hdetzsukzppw", -74.899811245, 27.757611984],
    [0xd9ced76a7fcf3c9e, "v77efumztwy9", 63.965099585, 61.30086606],
    [0x0cef6baa978ce531, "1mrqrbnrjmkm", -59.368886495, -113.205297238],
    [0xb3e633d061e056ac, "qgm37n31w1cb", -26.46442417, 131.266281771],
    [0x2fb49bae0bf118e7, "5yu9rchcy4df", -51.805715979, -4.574514366],
    [0xabb9c594a9517ab9, "pfwwc559b5xc", -74.73417765, 177.939387462],
    [0xaafff31a2ae3bfe2, "pczz66jbwfzy", -78.870747996, 179.755511074],
    [0x5a9eebabf8e778a3, "cbgfrbzswxwb", 49.619190448, -95.625398517],
    [0x73f44a2b9c99a223, "fgu4nbwwm6j2", 66.44914274, -50.319210306],
    [0x6c8a0902f3b4aa5e, "ek50k0rmqkp5", 22.54624191, -29.345234479],
    [0xaaf738d23c3ccbcd, "pcvmjnjw7m5w", -79.243283917, 176.360236575],
    [0x81bf8168715e6d62, "h6zs2u3jctqq", -73.759817486, 21.83128012],
    [0x4286eb8d29b69f0a, "8b3fr399qugh", 1.810238292, -143.468105039],
    [0x4ff4518ed8e17847, "9zu533qsw5w4", 44.172697242, -95.560876269],
    [0x0fc45e59004073d1, "1z25wq8081tx", -48.567714965, -100.975334357],
    [0xf20a1c6dd27003ef, "y851svfkf01y", 45.296074102, 116.930668613],
    [0x03e5d33503c1500d, "0gkx6e83s580", -70.424833449, -139.811496548],
    [0x79ae696dc2bac09c, "g6r6kvf2rc09", 58.083392051, -23.342523904],
    [0xb9612b2f0a141a8f, "r5hkqcsb2he8", -27.369622725, 141.279721502],
    [0x0b61a58c8e97d645, "1ehuc34fkzc4", -72.284117625, -105.761399103],
    [0x1f46f62f0f20092d, "3x3gdcsg404k", -3.594760089, -109.911600731],
    [0xbeb8ced5d7c6be13, "ruwdxpfrsuz1", -19.204161661, 178.201545442],
    [0xd5b69903b7e022b2, "uqv9k0xrw0jc", 83.192510812, 19.170377919],
    [0x5b2202bd6df6e478, "cdj05gceyvk7", 56.271271792, -105.301599589],
    [0xd8c973a43a4db90f, "v34r791u9qwh", 51.905715408, 59.570336307],
    [0xac687af2b560c395, "pjn7pwppd31t", -61.313403474, 144.128363995],
    [0x20d1177ffa69b618, "438jfzzue6v1", -80.508398389, -78.618360964],
    [0x31cc80c6dca9a37f, "67681jqwp6jr", -26.688868873, -75.181184834],
    [0x018f7cc2d36259d8, "067rthqmd9dx", -76.001091314, -163.951267024],
    [0xd4b1246ebbf685d9, "uksk8vpvyu2x", 71.131992534, 17.270455034],
    [0x82c1ba5e5260bd3d, "hc0vnrkkd2ym", -83.455490834, 35.085287363],
    [0xaf7db1ac2c0435f2, "pxyv3c1d0huz", -45.477535295, 167.071158213],
    [0x85c8cd0b9e53da5d, "hr4du2wybge5", -50.137676834, 14.961698723],
    [0x71b13968925d8e44, "f6smku4kcq74", 60.008173586, -72.561549624],
    [0xbb18a6b9765622d9, "rddbefcqbsje", -30.833322436, 161.533728075],
    [0x37360807a71e545f, "6wv0h1x73tb5", -7.022420874, -60.282947726],
    [0x0756fc466126a67b, "0xcgsjm14um7", -45.761981502, -154.856289403],
    [0x13509cfbfd821652, "2e89tyzxh8c5", -25.0105431, -156.533695192],
    [0x456fd4cede930d5c, "8prx9mqykd6p", 42.129534723, -169.388727594],
    [0x27fe4055cb0164cb, "4zz40pfc05kd", -46.011925984, -46.40246708],
    [0x35727f7bd474142d, "6pt7yyynfhb2", -2.115057094, -82.312230494],
    [0x4a766dabccc366ca, "99v6vbydsemd", 10.331715258, -104.855374757],
    [0x55b3748ad3ac8fc9, "bqtr92qmpk7w", 82.883114822, -161.303356778],
    [0x9b4d60c4eef5cc47, "me6q1j7fyr64", -25.634711962, 70.713428717],
    [0xb7f381ad07cf9ddd, "qzts3c87tyfx", -2.056551579, 131.561872946],
    [0x2fe82e3a5597b609, "5zn2wfkpkyv0", -50.523468949, -2.158602747],
    [0xe04ab38d397ae5c4, "w15c739tgckw", 5.853961169, 95.418486684],
    [0x17411be492d274d8, "2x0jrt4ku9ue", -4.673857318, -157.167120905],
    [0x34a674bba9f4b8d9, "6km79fx9ykwe", -20.464457588, -71.279706401],
    [0xdaa87b920f3aa78b, "vbn7r4hg7bms", 45.582835374, 87.853371406],
    [0x3ca89ffcd8195825, "7kn9zz6s35d2", -22.151808872, -24.265319618],
    [0x546311ef792c8b73, "bjjj3vvt5k5r", 74.080318236, -172.884148621],
    [0x59a0d3ad30d03116, "c6he7c9hu0sj", 56.830347837, -117.255529634],
    [0x72f630dfb5380c1f, "fcv31rxp7061", 55.0619762, -48.802511121],
    [0x59a0ef1930929de5, "c6hfy69hkbfy", 56.747866091, -116.794073427],
    [0x8539f53321b7abdf, "hnwzbdt1qypx", -52.061214313, 9.521326626],
    [0x2c21048017e8a22a, "5hhh900rx2j2", -66.7076969, -39.33039293],
    [0x08dca7ec4598f34a, "13fbgv25m3tn", -79.995007963, -119.717785303],
    [0x1599c2a08f502c2a, "2qdw584gb0q2", -7.382167407, -165.076781139],
    [0x500673eeade0f397, "b0377vpew3tt", 47.00561475, -178.066817184],
    [0xc11c8694cf11babf, "s4f8e56g26xc", 15.575065049, 3.651258913],
    [0xe0a2055f91c877ea, "w2j0brwjt1vy", 0.173989205, 108.300698652],
    [0xed0dff63e7126674, "xn6zysz729m7", 36.545212424, 139.162816926],
    [0x654695890efdfde0, "dp39c28fzryy", 41.092128454, -87.83434319],
    [0x698edc4f7758a7eb, "e67esmvrc2my", 13.304402833, -28.634086037],
    [0x5a2f988f86425517, "c8rtj3w689bj", 47.293835517, -101.713807425],
    [0xd32637c0f1e38541, "udm3gh7jwf2n", 57.988170427, 30.01905803],
    [0x44909862cc6e4aa5, "8k89hsqdet5b", 25.512083327, -167.840039441],
    [0xa4796c174577962a, "njwqs5u5fyc2", -57.898642528, 98.97045692],
    [0x2d470a83d7eda9fa, "5p3hp0yrxqnz", -48.510184302, -43.277229286],
    [0x528db9cfd2dea4bd, "bb6vmmykvukc", 47.361525746, -142.14326317],
    [0x1d27bb72330395d6, "3nmvqwjm0fbx", -8.887065126, -126.621175224],
    [0xdb74652aaab22e65, "veu6bbpbq8r6", 66.577193182, 73.520453246],
    [0x318221929e184ede, "661234ny317e", -33.69398817, -76.938924582],
    [0x4397fcdc333a3e93, "8fcztr1m78z9", 16.826466983, -143.556472602],
    [0x51188c0d04aee609, "b4d8s384pvm0", 59.1590019, -176.297267909],
    [0xf8e63f472360198c, "z3m3yjt3d0ds", 52.369340543, 153.903783571],
    [0x3350158f28e24bf5, "6e81c3t8w95z", -24.996550538, -67.437231226],
    [0xdfe25a7fc29a0151, "vzj5nzy2m80p", 84.94495992, 86.08670001],
    [0x76030b81da6f3775, "fs1hr0fuewvr", 68.25200018, -65.782198982],
    [0x977dfeefc9bcf811, "kxyzxvy9rmw1", -0.056060606, 32.34200929],
    [0x413e3a5426de7235, "84z3np16vtt3", 15.683485297, -169.539055932],
    [0x3d289c8f18a4a49b, "7nn9t3ssnkk9", -10.977378722, -35.622207718],
    [0x92de9b54f71bcb67, "kcg9qp7r3g5q", -34.895436194, 38.940089649],
    [0xe1f3403615b9d701, "w7tn0ehpr7ch", 20.759932393, 108.309028314],
    [0x6b15492b5cb09be0, "edbnkbuwq2ey", 16.572579262, -22.284806638],
    [0x6d5ccb7bafde817a, "epfdqyxgvu0r", 44.025629761, -41.176853731],
    [0xb79c52d915d873fe, "qyf55q8pv1tz", -6.466860965, 126.705544817],
    [0xa128734329acb544, "n4n76ht9pkun", -78.153793444, 98.884822749],
    [0x406abdc6f60bec56, "81pcvjrq1gq5", 5.962504302, -168.87179631],
    [0xba22331ea654ad87, "r8j367p6bkqs", -44.763298263, 164.991665351],
    [0x2b22219473e7f5fa, "5dj2353mwzuz", -78.687214984, -15.071229199],
    [0x69e795c1ccbd8404, "e7mtchfdrq20", 19.318504578, -25.967935245],
    [0xa98399c0503b3b86, "p61tmh2h7dxs", -77.803058736, 148.579261949],
    [0x7ac589a42e65284a, "gc2sm91fdnn4", 52.784275175, -10.302678391],
    [0x01d3dae70b518481, "079xptscb628", -69.051506288, -166.304500612],
    [0x847260a5598303d1, "hjt619bthd1x", -58.700454182, 7.449612302],
    [0x1452cebad176e7a6, "2j9dxfqjfvmu", -13.609671248, -177.541683234],
    [0x0293643f347fdf66, "0b9q8gtngzgq", -86.024494417, -144.452196679],
    [0x10a671d9450d2cab, "22m73qb51nqb", -42.984833495, -161.312203621],
    [0x1d7b65c92790320e, "3pxqck97k0t0", -1.600696637, -124.74786059],
    [0xbd4cf1df395426b8, "rp6g3rttbhmc", -3.605252183, 138.929680175],
    [0x8cde6bea74bcdf0c, "jmg6rumnrmgh", -57.236291726, 61.168070476],
    [0x555b5d2c3c17d81c, "bpepuc1w2zd1", 88.556411233, -175.570414713],
    [0x0d5a85eab98e5476, "1pe8cuptjtb7", -47.657801647, -129.990684512],
    [0x29823ade9c926dbc, "5613prnwk9qv", -78.534686061, -31.664455249],
    [0x9c0927398efe4100, "mh4kffdfzt0h", -21.650806589, 48.289010577],
    [0x11af531f421ecadc, "26rp67u23v5e", -31.048666246, -158.801456524],
    [0xbdbcfac8cb98568e, "rqygpk6cm1c8", -6.480336238, 156.064784418],
    [0x816787a30360e995, "h5msg8s3d3nt", -70.880778641, 7.894125393],
    [0x4bb650e5be0271cb, "9fv51tey09sw", 16.027345234, -94.147654386],
    [0x2c5617b7438860a0, "5jc1geu3j1hb", -57.327856382, -43.433883971],
    [0xab3fdd3b93cde3aa, "pdzxufwmtrju", -73.154230042, 168.264431616],
    [0x365fd9dd6d595a38, "6tgxmrcec5e3", -11.338601213, -62.345304664],
    [0xefbef4a2a6e84cfa, "xyzg98p6x16g", 38.584420771, 179.724616212],
    [0xa57c10d14ac28c0c, "npy11nbbsb60", -46.193302609, 98.482682031],
    [0xf49908f76bee1558, "ykdhjxvcxsbp", 71.058481196, 104.312417746],
    [0x0041e13de3b6fc0e, "010y2gg3qvy0", -83.255522302, -178.907592322],
    [0xbcf1443118c563c9, "rmsn8d8sspjw", -12.905377851, 151.897838516],
    [0x6457788f182ff38a, "djcrj3ss5zts", 33.583186065, -88.005126209],
    [0xaa0852f74b00268e, "p8455xuc00m8", -89.429911121, 160.472839412],
    [0x5e7344e063690708, "cttn9s33e43h", 77.103694319, -105.400985114],
    [0x40f621978f6ae41b, "83v235wgeck1", 9.907529142, -161.313805843],
    [0x1e93c87c15ec0359, "3u9whz0pxh1p", -18.593050204, -98.931582829],
    [0xf353d945fd435361, "ye9xkjgx8e9q", 65.994807066, 114.789985964],
    [0x317fbff030dbb27c, "65zvzw1hvft7", -22.861719438, -78.770345335],
    [0xb34ff60c5ddd68ca, "qe7zd32xvpnd", -25.392155879, 117.87322471],
    [0xa1bdd9cba11efdb2, "n6yxmkx13vyv", -73.231870397, 110.631035215],
    [0x586d65c78b6d0d2f, "c1qqcjwcen6k", 53.248277687, -126.157590376],
    [0xdfa5b037820d4663, "vykv0ew21p36", 81.054421607, 85.460287928],
    [0x83a9a927e80ceffe, "hfnuk9z81mrz", -77.993287196, 43.450305435],
    [0x1060c886ab14988d, "21hdj1pc2kd8", -39.017705458, -173.441491119],
    [0x0e79b2af80d626f7, "1twv5cw0usmg", -58.175201828, -102.834576916],
    [0xe886040d528f87c8, "x23083bkjy3w", 1.504474877, 147.667828631],
    [0x46a9a98b81c78dfc, "8unum2w1sy6z", 23.250109197, -136.518652094],
    [0xc4406a02e0476efb, "sj06n0r08xrg", 28.478061086, 0.624879516],
    [0x7e04d5f56fdefad2, "gs2ecxcgvvxe", 69.60867545, -21.72829686],
    [0xbd89a3e59f05b533, "rq4u7tdz0qum", -10.471478527, 150.274789216],
    [0x70653c925414ed34, "f1kmt4kn2mqm", 53.01150849, -83.798198618],
    [0x74a7371a2f9ba5b4, "fkmmf6jgmfkv", 69.928549415, -71.260160916],
    [0x46541dc213ddd018, "8tb1vhhmvr81", 32.674367304, -157.274211462],
    [0xeb3586ecaa7f1c13, "xdusev5bgwf1", 16.287396627, 163.998222773],
    [0xe0b738e95b89fb00, "w2vmjubvj7xh", 5.124626564, 108.886762713],
    [0x46020e6457a1cd47, "8s10wt2rn76n", 22.617949969, -155.807491087],
    [0x1ea50ac52ba1f64b, "3ukhpj9cn7v4", -20.360220417, -95.314704315],
    [0x704363be0580fc73, "f11q7gh5h3y7", 51.740637224, -88.071708495],
    [0xc9b2bef95eb9f09f, "t6tcxybyr7s9", 14.364342723, 64.677861123],
    [0x65970914664d89fc, "dqchk5369q4z", 38.734135707, -77.166194584],
    [0x3b57895851b258be, "7ecskq2jq9dc", -23.123937885, -20.203574458],
    [0x5e8d2dfec0d9d69a, "cu6kvzq0v7c9", 69.781185413, -97.824784579],
    [0x4c97be7abf81dd93, "9kcvwypzh7ft", 27.719728502, -120.981602729],
    [0xc685a3c640bdccda, "su2u7jk0rr6e", 24.682241751, 34.94233136],
    [0x6be77083af265f07, "egmr10xg4tgh", 19.515011978, -3.812487762],
    [0x64b423b8b7e039b1, "dku27f5rw0wv", 26.774972677, -72.603912784],
    [0xf8971d3539d55a97, "z2cjue9tupe9", 50.24974586, 147.85624033],
    [0xf98fa4c4c3d59218, "z67u9j63uq91", 58.476440197, 151.570656618],
    [0xa9813ff43ed7dd8d, "p60mzx1yuzfs", -77.699604569, 146.933762975],
    [0xd4612fcd8eb1e57b, "ujhkzmdfq7kr", 73.990578242, 6.299216752],
    [0xdcfcb4ca0b6a36f5, "vmyc9khce8vg", 77.629656708, 65.803800234],
    [0x2cfd565991f59af2, "5mypdqdjyqeg", -56.301162616, -25.210603106],
    [0x5171a40528e54df1, "b5su8198wp6z", 65.486881343, -173.317991349],
    [0xae7cdcc8e35e92e3, "ptyetk73cu9f", -57.017344731, 166.875878696],
    [0xc73dcb853ebcb8b3, "swywr19yrkwc", 39.076719831, 31.950965802],
    [0x0f3d497ea6d6c240, "1wynkzp6uv14", -50.893665795, -103.843598212],
    [0x8cb21a3f5523133b, "jkt1ngup4d9m", -64.489903427, 63.583483249],
    [0x009a2dc551bf1c7e, "02e2vjbjrwf7", -87.023140326, -163.959635787],
    [0xe7c87574af234f4a, "wz47bx5g4e7n", 40.073165276, 126.941296599],
    [0x47b19aae0c6c7fc1, "8ystpchdejzw", 37.44736047, -139.574980179],
    [0x9f88db3a6581af12, "my4eqfm5h6rj", -10.665823422, 82.569314181],
    [0xd2a99eb941e50889, "ubntxfb1wn48", 45.982192807, 43.231462262],
    [0x28e24ab61cf4c31f, "53j4pehwym1j", -84.005771503, -26.382710476],
    [0x3e928a8159ddd5ff, "7u98p0btvrbz", -19.682350179, -8.832094531],
    [0xdd089d8851dbbcee, "vn49v22jvfyf", 79.059992733, 48.746593993],
    [0x24317b04421ab965, "4hsrq1223bwq", -63.406172728, -83.759338781],
    [0x4da70dba4039304a, "9qmhvfk074s4", 36.003627256, -116.460436858],
    [0x00ffde5ab3dcf1a0, "03zxwqpmvmsu", -78.803914391, -157.918278692],
    [0xbdb045117147772b, "rqs4b4cj8xvk", -7.938008909, 151.876402092],
    [0xd949b1a7187a2a1e, "v54v39ssg8p1", 62.806906967, 48.939445144],
    [0x7fc6d4d46ddb8dc3, "gz3e9p3evf6w", 86.436966699, -9.094369496],
    [0xd7a24f944cd35c18, "uyj4z52duef1", 79.251743604, 41.089749867],
    [0x9fa9a825cb33ada7, "mynuh9fc6fqu", -10.537034509, 88.443845142],
    [0xcced6070b889038b, "tmqq0w5sj41s", 30.619594592, 65.066058527],
    [0xc671728cc0c98125, "stsr5360t60k", 32.174932569, 28.622357009],
    [0x65d02e1b5354b48b, "dr82w6umbku8", 42.291509429, -78.11792578],
    [0xe46e79cbd23571ed, "wjr7mkyk6psy", 30.129402532, 100.434700872],
    [0x2a2e2d4653e3e2a9, "58r2ujkmwgjb", -88.432114667, -12.122772173],
    [0x86af9eaf3b32911e, "hurtxctv6b8j", -65.117808552, 44.645465894],
    [0xec9783f94c211bc7, "xkcs7ybd44ew", 27.503257036, 148.524947219],
    [0xd5baff01d45234fa, "uqxgy0fnb8ug", 82.226962817, 22.414884081],
    [0x1e3991ca70c54036, "3swt3kmhsp03", -18.740492184, -103.297404742],
    [0x4229221c05d94e45, "88nk4705v574", 0.720266129, -148.611841933],
    [0xb0f4ae3f82909de6, "q3ubwgw2k2fy", -35.049085233, 108.235087598],
    [0xc069ee0f9b67a4e2, "s1nyw3wvdykf", 6.776795909, 9.77623994],
    [0x044a97c2b5e00f1d, "0j59ghppw07j", -61.544120349, -174.936414298],
    [0xc51fd8582f2f2262, "sngxhq1g5wj6", 39.232725256, 5.111203169],
    [0x5db84b674c56ed2e, "cqw4qtudbvqk", 81.990094502, -115.020634785],
    [0x547a976bc82e3d33, "bjx9fuy85sym", 76.271236093, -169.323190329],
    [0x98bd95ccdbdcbeec, "m2ytcm6vvkzf", -39.740655716, 65.449569104],
    [0x99bf985fb66422d2, "m6zthrxqdhje", -28.610007231, 66.993692273],
    [0x060141feee4833d9, "0s0n3zrf90tx", -66.361108671, -157.412402172],
    [0x01915b972ed5bf2c, "068pr5tfuqzk", -74.643350817, -168.434294036],
    [0x35f8f82da6e7c54d, "6rwghce6wz2n", -2.276447292, -69.044319179],
    [0x1d0356206078f77f, "3n1pd830g3vr", -9.93012788, -133.482366615],
    [0x6c4b58509f415ba9, "ej5phn4z85eu", 29.389734691, -40.601686942],
    [0x28b1d9e3609fb859, "52sxmsv0myw5", -85.886915075, -27.173054266],
    [0x99f6f4d51cc5319c, "m7vg9p8wsnst", -23.248665279, 64.380747396],
    [0xc35ec1601bbefb89, "segd2s0vrvxs", 21.512161919, 27.445220512],
    [0x8750f118d4629a03, "hx8g266ndbe0", -47.227732776, 23.568542575],
    [0xc5ca00edc0ce43d6, "sr501vf0tt1x", 39.406699605, 15.548639062],
    [0x891a2cb80e2e4bdf, "j4e2tf0f5t5x", -75.83825157, 49.824183238],
    [0x1c68b62b2e3ddf54, "3jncdbtf7rgp", -16.608152437, -125.378922901],
    [0x7fbcd378cd1c3db3, "gyye6y6e3hyv", 83.574955616, -1.985040044],
    [0x387afe2862451078, "71xgwb328n87", -35.945771101, -33.803214498],
    [0xf2e5ff885ababc47, "yckzz22urby4", 53.395662051, 130.749661711],
    [0x4a30c4f7a77cc84c, "98sd9xx7gm44", 3.293822828, -106.095858339],
    [0xb7e25038c0873c81, "qzj50f60hwy8", -5.085260345, 130.817157452],
    [0x52596fb3f9f9feb0, "b9dqzdztz7zc", 54.640136978, -153.995726422],
    [0xf944131bd7de7f76, "z52166yrvtzr", 63.517445269, 135.10770592],
    [0xaaa220f8341063b6, "pbj21y1n21jv", -89.965961822, 176.211097927],
    [0x5c184b5eb206990c, "chd4qrpk0udh", 70.747171532, -131.902850359],
    [0xa7fbb0f3771f2f66, "nzxv1wvr3wrq", -46.895235703, 134.721639499],
    [0xc78d819abe7791d9, "sy6s36pyfy8x", 35.915501456, 37.331318534],
    [0xcd423781546b1193, "tp13g0bned8t", 39.687867156, 46.889799435],
    [0x6753a801fc065b49, "dx9uh0gw0ten", 42.895805434, -64.85844902],
    [0x2da523e3c20b17ad, "5qkk7sy21dcu", -54.070571608, -27.61097891],
    [0x5d45419ebf911bf8, "cp2n37pzk4ez", 86.897621453, -134.934248474],
    [0x3a90ee00676ce511, "7b8fw037emkj", -41.746043699, -9.92977914],
    [0x1c2c3484d4e789c7, "3hq3916nwy4w", -20.822062524, -126.163952483],
    [0xa4510b8a46b16533, "nj8hr2k6q5km", -58.313651836, 90.324703286],
    [0xa8ac8c02b0a30819, "p2q8s0phnd41", -88.50516176, 155.576301116],
    [0x0081b0cd5921b44c, "020v1mbt46u4", -89.088634576, -167.639592091],
    [0x56e9518527b58948, "bvnp3197qq4n", 74.408244931, -137.766566985],
    [0x48973d3490cd7210, "92cmue4htpt1", 5.246784571, -121.791465649],
    [0x66a028b193578795, "duh2jddmby3t", 22.514754485, -50.028614101],
    [0x04b52e02d70b2402, "0kukw0qr1dk0", -62.487647383, -162.501112666],
    [0x68c1456b1fe39b6a, "e30nbuszwfeq", 6.837544557, -33.710223525],
    [0xf1a2b8d1905ac8fb, "y6jcjndhcc4g", 56.462308121, 109.558489701],
    [0x6378ac4f51050cb3, "dewbsmuj0n6c", 19.807868384, -57.815547958],
    [0x6967007f50ee922a, "e5mh0zuhxu92", 19.027743645, -37.929963314],
    [0x381bb7825f198413, "70evg0kz3621", -41.174127672, -39.588149652],
    [0xa1d8517ee0b0bf6f, "n7d52zr0q2zq", -69.701337387, 104.105350288],
    [0x42f0ed2ad9dc80e7, "8csfubqtvk0f", 8.923280716, -139.352419412],
    [0x7cd6aa93c59bdc95, "gmcbp4y5mgf9", 77.359434551, -30.972955442],
    [0x9d5b112984075c47, "mpej2bd40xf4", -1.886516484, 49.254479852],
    [0x720a8b97b2d6d2ef, "f858r5xkuv9f", 45.064016751, -62.260344998],
    [0xc9cfa0923b9cd234, "t77u14jvmm93", 18.996292311, 61.575506283],
    [0xb6e167e4ab8cf661, "qvhqgt5cjmv6", -15.660807836, 129.885753342],
    [0xdc975e0759d4c088, "vkcpw1utum08", 73.047736326, 57.926284978],
    [0x1c80ed8d0ea0c4a1, "3k0fv38fn32b", -22.008011724, -122.463300358],
    [0xd8797319f6bd44ed, "v1wr66gqrp2f", 54.728132528, 53.892704303],
    [0xca86e7acfbd8b0f1, "tb3fgc7vv2sg", 1.897505203, 81.381113978],
    [0xd0f601387562d079, "u3v02f3pdc87", 54.901351007, 18.315700821],
    [0x6c724fb8798a7cd4, "ejt4zf3tj9ye", 31.434126353, -37.625869088],
    [0x760604ecafdd7343, "fs309v5gvptn", 69.022291478, -66.011474495],
    [0x9830dbfa2ad1ee70, "m0seryjbu7r7", -41.583105233, 51.676789737],
    [0xde447be72eaea4ed, "vt27rttfpukf", 75.133118068, 68.189387965],
    [0x33b793180a5941eb, "6fvt660bc50y", -28.597266188, -48.415673892],
    [0xe1e6f3cb6d97c1f0, "w7mg7kvekz0z", 18.879228256, 109.486517784],
    [0x49b01f7d6ae39f1a, "96s1yzcbwfgj", 14.412790637, -117.82567189],
    [0x3316b6df9f32e61b, "6dccerwz6cm1", -29.22512793, -64.886845486],
    [0x7a15c0ed0388c726, "g8bw1v83j33k", 50.303829037, -21.719400277],
    [0x9437d4b61dda8eef, "khvx9ehxvb7f", -16.945078948, 7.806724897],
    [0xaf998dfa9a578e27, "pydsvynuby72", -52.56873102, 172.527616959],
    [0x96895d4ddfa6ce90, "ku4pumfznv79", -21.104879648, 36.753338546],
    [0x2e6a8099ca1423c0, "5tp816fb2hjw", -61.859828398, -11.894409357],
    [0x4ebc8aac62a8efd6, "9uy8pc32p3rx", 26.725624421, -91.766760935],
    [0x36fe31339eff02d2, "6vz32dwyzw1e", -12.421599105, -46.023121151],
    [0x270033a8fdf9f5f9, "4w037b7xz7uz", -56.027548425, -66.978518307],
    [0xebbe9c4b5eed1124, "xfz9skuyxn8k", 15.759665839, 179.490466492],
    [0xee6ed884484027cb, "xtrej12880mw", 30.065548433, 168.267295839],
    [0x2485fb76a5f3bdbb, "4k2zqxp5yfyv", -64.780224387, -77.399755922],
    [0xdd2588802584744e, "vnksj015hju4", 80.859921273, 51.549402156],
    [0x2df4e23175312465, "5ruf4dcp64k6", -46.03832421, -26.95898434],
    [0x9f7e206f6b5d1af1, "mxz20vvccneg", -1.374328478, 77.736215923],
    [0x5ef5f8dc92144a1f, "cvuzjr4k2j51", 78.613427597, -94.336505417],
    [0xa909f84de616e6fc, "p44zhmg62vmg", -77.487530532, 139.058458405],
    [0x5956b85afc1d5057, "c5cchqrw3p85", 66.3049773, -132.341952167],
    [0xf47f9dd35b53fd37, "yjztvnuvbgym", 78.392579185, 100.773165423],
    [0x6d796a16098ae1ae, "epwqn5h9jchu", 43.258844806, -35.940832355],
    [0x89c9949a058bc194, "j74t96h5jg0t", -72.146684776, 59.826297304],
    [0xf9d1ae09d9c48417, "z78uw2ftsk21", 65.483602742, 147.582961442],
    [0xe6ad8d0ef8358f03, "wuqsu3rs6q7h", 24.748841229, 133.087792941],
    [0x63c4b84f92a8a13e, "dg2chmwkp2hm", 18.487931249, -54.999644723],
    [0x2a2b85d576cf4603, "58pscpcqtx30", -89.121312303, -11.907225546],
    [0x92024695200caa5a, "k814e5901kp5", -44.5412988, 24.039522575],
    [0xf1847d250ab6680d, "y627u98bqtn0", 58.323739327, 101.800633553],
    [0xc19860cc2b2b9023, "s6d61m1c5f82", 14.441713466, 14.471558833],
    [0x3cadf8771d272390, "7kqzhxsx4wjt", -19.82084783, -24.053764081],
    [0x112aa8615d9e1e76, "24pbhsbxmsg7", -33.722636841, -168.902881409],
    [0x8690fa3e5e82a40c, "hu8gngkyhbk0", -64.141272071, 35.10805094],
    [0x296ba2c6072c8c82, "55pu5jh75k68", -72.393871381, -33.963747131],
    [0xe505f087535587ce, "wn2z11umbq3w", 36.397353461, 91.104482341],
    [0x2509425a1fab1f76, "4n4n4qhzpdgr", -55.161135839, -87.081773601],
    [0xd31ac1fe07a4fe6d, "uded3zh7nmz6", 59.497006264, 27.504893955],
    [0x09ce479d626e95fa, "1774g7c2eubz", -71.21463971, -119.386548919],
    [0x0aabc854d82873e7, "1bpwhp6s51ty", -88.904791225, -90.523773913],
    [0x95bbf9abd62be7e8, "kqxzmbyq5gmy", -7.15791765, 22.409875005],
    [0x870717c7ade1b310, "hw3jgjxew6tj", -53.80218032, 24.048660583],
    [0xae9923281d6ea24f, "pudk6b0xeuj4", -63.939120294, 172.035766682],
    [0x95ac75f8d65c511d, "kqq7cy6qcj8j", -9.149048849, 20.119099822],
    [0x44c0012d0abe4dad, "8m002c8brt6u", 28.177256934, -168.715685261],
    [0x8b75feb8f7e32703, "jeuzxf7rwdmh", -67.574230729, 74.525012682],
    [0x88f5b41d73788a4d, "j3uv87cmg254", -79.167866222, 62.942534144],
    [0x48c39e5d855457fe, "931twrd5bjcz", 6.633671458, -121.363217561],
    [0x3ed4a2ddcc1de240, "7vbb5rfd3rj4", -12.613253851, -10.048996623],
    [0x91bc9bdb32eadc70, "k6y9rqtkxcf7", -29.275035502, 20.716773926],
    [0x3dde0acfa9ecfe47, "7rg0pmx9xmz4", -1.375748758, -29.202026117],
    [0xd8cdc5bfd1af061d, "v36wcgyjpw31", 53.239264955, 59.851092489],
    [0xc3d3c052a59fa009, "sg9w0np5myh0", 20.775736639, 35.869240338],
    [0xc49a147717ae8f93, "ske18xsrpu7t", 25.618595945, 15.496896559],
    [0x0007fa932d022662, "003zp4te08m6", -87.349031664, -177.223863626],
    [0x529f6af566e3e6f5, "bbgqpxc6wgmg", 50.316456758, -141.348083649],
    [0x36cd9c4105df631e, "6v6tsh85vxjj", -14.476551678, -52.558350683],
    [0xab0b79fc47f1cfbc, "pd5rmz27y77v", -77.435098388, 162.323614843],
    [0x39bed91850186f99, "76zek62h31rt", -28.946864157, -23.016304219],
    [0xc172daffec09c008, "s5tepzzd1700", 20.257775219, 8.085304703],
    [0xc0b498d9bc4cb92a, "s2u9jqew9kwk", 4.431377428, 17.813706757],
    [0x4ca8417b645cdf31, "9kn42yv4cmgm", 22.933090469, -115.272616513],
    [0x54d381bbe684fffc, "bm9s3fz6hmzz", 76.700051974, -166.553571364],
    [0x4cde0f6de81c8856, "9mg0yvg83k45", 32.507236617, -119.229756202],
    [0xb3b0e4626edadb3c, "qfsf8smfvcem", -30.474219876, 130.459807886],
    [0xf68079b776b0cd5a, "yu07mevqq36p", 68.092969199, 124.350742692],
    [0xd9e71b210b7d8ab2, "v7mjq88cgq5c", 64.207180914, 63.568069106],
    [0x6a1f4685fe696956, "e8gne1gye5np", 5.372074342, -18.144127304],
    [0x59f1de0a89f9072f, "c7sxw2n9z43k", 66.00617269, -117.137988005],
    [0x2f98b381a3ef88cb, "5ydc70e3xy4d", -53.214736783, -7.246177152],
    [0x6ad41380a505a1cb, "ecb170550qhw", 10.064024785, -11.114027166],
    [0x09913a8b55de990d, "168mp2upvudh", -75.053118541, -123.074091148],
    [0xd4fd2dfca4cf071b, "umykvz54tw3j", 78.217626672, 20.296105618],
    [0xb55e35c441ea134a, "qpg3cj21x89n", -1.069532518, 94.614581286],
    [0xe44c9dcd8b12d4d7, "wj69vmdc2cbe", 29.869304207, 93.750147439],
    [0x6f073afd6ef7a3e1, "ew3mpzcfyyjy", 36.078233599, -20.39891064],
    [0x0592f21396c5177d, "0q9g44wqsncr", -52.895270024, -166.192415264],
    [0x237d7d01ac746047, "4eyru0edfjh4", -67.540699344, -58.530258441],
    [0x1042e63238e3b345, "211fddjswftn", -38.923773526, -177.421349652],
    [0x1d73d51af0d9c887, "3ptxb6rhv748", -1.437004044, -127.244796829],
    [0xd97f75c848070c66, "v5zrck280w66", 67.479434615, 55.250955416],
    [0x31d81c3618e3981e, "67d1sehswfd1", -25.031562487, -75.733273602],
    [0x5ea9926efb2e6342, "cunt4vrv5tjn", 68.408631537, -91.977725354],
    [0xbd9436eb896c90bc, "rqb3euw9ek8c", -6.742576966, 146.775424485],
    [0x2633ca477e4edd3d, "4stwnjvy9vfm", -63.600079169, -59.493978414],
    [0xce6f2160cb12de5d, "ttrk2s6c2cg5", 30.301890867, 77.721098091],
    [0x2bb9adc734bdcd18, "5fwuvjtnrr6j", -75.071214038, -1.530905451],
    [0xcfbc4452c8d7bd7c, "tyy48nq8uyyr", 38.442701626, 87.196638829],
    [0x4b7c0ce24439cc50, "9ey0tsk47765", 21.205390784, -103.815165448],
    [0x130c4704f5c2ce8a, "2d64f17psc78", -31.852190916, -154.595280656],
    [0x70c2697ace3e746b, "f316kyqf7tu6", 51.055257584, -76.774021384],
    [0xe95aa666f8c5f17b, "x5ebdtrssrsr", 19.805043693, 140.393788851],
    [0x7a681de73eed7767, "g9n1vttyxpvq", 50.963988107, -13.812596797],
    [0x5743824997c138fe, "bx1s4kdrs4wg", 85.104145714, -155.288477126],
    [0x6b7f4058a73dc049, "eezn0q577r04", 22.181992345, -12.640660831],
    [0x893478449cf6cec0, "j4u7hj4wyv7d", -73.975253202, 51.1560714],
    [0x42893cd8437214da, "8b4mtq23f8be", 1.001434099, -142.854773],
    [0x911fbe43d333eb76, "k4gvwhym6gpr", -28.537442002, 5.545820346],
    [0xf3271de69e00353b, "ydmjvtny00um", 58.695492907, 119.782224939],
    [0xc33d08337d05f95a, "sdyhhdvx0rwp", 16.188224246, 31.142826045],
    [0x15e3852c30e60f0b, "2rjsbc1hws7h", -4.783749894, -160.981009482],
    [0x42c99c42fb4999db, "8c4tshrv96dx", 6.616101611, -142.547893488],
    [0x547920253d6e0b72, "bjwk099xes5r", 76.650174864, -171.186750213],
    [0x57bf055e915f6b21, "byzhbrnjcxpk", 83.843188403, -136.386949772],
    [0x49a3de197b64fcb3, "96jxw6cvdmyc", 12.584440781, -115.738457831],
    [0xe8518857be9869d8, "x18shpxym1nx", 9.182903182, 135.889772736],
    [0x10e099c0a9aba9ef, "23h9mh59pfny", -39.133117234, -162.197000015],
    [0x934ddab617494703, "ke6xpehr953h", -25.470496125, 26.351095707],
    [0x232b11d8728d0f4d, "4dpj3q3kjn7n", -77.792094828, -57.599382973],
    [0x5e6308583ff6e778, "ctjhhq1zyvmr", 73.862443721, -105.279282239],
    [0xf1e83dccf8711009, "y7n3vm7sf480", 62.212285171, 110.274667977],
    [0x232e687a369bf62b, "4dr6hyjqmgv2", -76.958135441, -57.088483416],
    [0x9746a950f16178f3, "kx3bkn7jd5wg", -4.139508914, 25.140933635],
    [0x80aa7e7898c40260, "h2p7wy4ssh16", -89.35101233, 21.745549982],
    [0x598bae2715f9c79c, "c65uw9spz73t", 57.050604133, -118.185111483],
    [0xf20842a3db5c39c3, "y84458yvchww", 45.356694618, 115.475630086],
    [0xd47db919e64c1d4b, "ujyvk6g69hfn", 78.282163481, 9.683464192],
    [0xdeac35198efdc34d, "vuq3b6dfzr1n", 69.22811088, 87.554138036],
    [0xc5d65439618c3b48, "src58fc1jhxn", 44.224287415, 12.690806422],
    [0x619ea0cf1cce16ac, "d6gb1mswtscb", 15.500103807, -73.415212452],
    [0x186c1fdc39cdf4cd, "31q1zr1ttrud", -37.621694476, -126.241605031],
    [0xd3ce5d9fc248c618, "ug75v7y29331", 63.961121759, 38.208101181],
    [0xba216eb5a958818a, "r8hqxee9c20s", -43.837894711, 163.811013453],
    [0xed367e09bbc20532, "xnv7w2evs82m", 38.587677298, 142.662814085],
    [0xf9d0aad0ebde17ee, "z78bpn7cvscy", 64.722159254, 147.617693173],
    [0x1d9c927439ff8818, "3qf94x1tzy41", -6.815997177, -120.122116259],
    [0x2d5708e4dddb876f, "5pchjt6xvf3q", -45.672942281, -43.348368848],
    [0x90618a6f5225ada2, "k1hsnvuk4qqu", -38.639568444, 6.630698045],
    [0xb22ee9087cdb2296, "q8rfk23wvdj9", -43.195699168, 123.58750852],
    [0xafbb84f332c44161, "pyxs9wtksj0q", -52.609978458, 179.370174806],
    [0x6a1c8e21950e3a20, "e8f8w8dp1sx2", 4.310612985, -18.695909714],
    [0xd2da810195c2b315, "uce820dpsbtj", 53.485483042, 38.674832184],
    [0x65dbbb502f8538e1, "drevqn1ghnwf", 43.143860804, -73.210306585],
    [0xbe2d7c1554f9f778, "rsqrs5bnz7vr", -19.75361122, 166.465162114],
    [0x9c9f255b9ba28d7e, "mkgkbqwvnb6r", -17.409722587, 60.840861526],
    [0x23984ebbf59e0ea9, "4fd4xfzpms7b", -75.48167327, -53.087069534],
    [0x069d19726afa033d, "0ufjkwmbz81m", -62.323936438, -143.23152591],
    [0xc26a189c131dcee4, "s9p1j70m3r7f", 5.818201288, 32.574864914],
    [0xbd8845b58b61027a, "rq44cedcd417", -10.747106737, 149.13228232],
    [0xb3aba56b54d2383a, "qfpubuunu8w3", -32.887784953, 134.687091445],
    [0xb1340f3cf9290b8f, "q4u0yg7t545s", -29.380691416, 95.926571122],
    [0xd4277351de6f59f6, "uhmr6nfyexdz", 70.21890023, 7.4746337],
    [0x4bc6dfe35dc4d871, "9g3ezsuxsmd7", 18.967839761, -98.804669866],
    [0xc702c929d7994cd8, "sw1dkbfrm56e", 34.150890181, 24.821423239],
    [0x12a3a742f246ba6c, "2bjufhrk8ux6", -44.140896078, -138.066173433],
    [0xb8bf4bfa90a7bdec, "r2znrynhnyyy", -39.648934225, 156.442864854],
    [0xd0bd9bfc1ef6704a, "u2ytrz0yyts4", 50.181242272, 20.732515732],
    [0x2ff7887ce258ca02, "5zvshz72c350", -45.66316541, -3.302363795],
    [0x2ab0ea0f06ad8402, "5bsfn3s6pq20", -86.827320864, -4.289506547],
    [0x983b09f35469fb10, "m0xhmwune7xj", -41.402215412, 55.091091268],
    [0xe5bc4464ca53f43a, "wqy48t6bbgu3", 38.437191279, 109.713287419],
    [0xf99becd4b270b4f4, "z6eytp5kf2ug", 60.244350293, 151.747730236],
    [0x256adba7ca9aa55e, "4pper9ybmbkp", -50.044052383, -79.114013],
    [0x4b7cd6bb2ea8d3c6, "9eyeeftfp39w", 21.723069748, -103.186370382],
    [0xc0bc7962da443d1f, "s2y7ksqu8hyj", 4.814183959, 20.246094434],
    [0x6119edf8cfe471e1, "d4dyvy6gwjsy", 15.283987095, -85.876086468],
    [0x43fb0a835c3ed7fa, "8gxhp0uw7vcz", 20.395849811, -136.092289463],
    [0xc0bc98e0ca9fa85c, "s2y9js6bmyn5", 4.41795292, 20.636355767],
    [0xe4c1e30bc1b9cc9d, "wm0y62y1r769", 29.227985014, 102.412118932],
    [0xee9997d70b6e4797, "xudtgpscet3t", 26.364727579, 172.404136432],
    [0xae0c866b5b69c9b6, "ps68duuve74v", -65.978805663, 161.143141012],
    [0x02b63ba99e61e2e9, "0bv3rbdyd7jf", -85.557644582, -138.522730307],
    [0xc984e5c0b75aee08, "t62fch5rccr0", 13.162958184, 57.353180718],
    [0x83ba1e27778448ed, "hfx1w9vrhj4f", -75.662986155, 43.886779905],
    [0xdf53fc8f65799573, "vx9zt3v5g6br", 88.516132116, 70.19865682],
    [0xc4abe59628a06a14, "skpyc5j8n1p1", 23.70300856, 22.200202824],
    [0xe28f780de7a87df8, "wb7rh3g7p1yz", 2.646857354, 128.511852905],
    [0x4792224ae84f0641, "8y924kr89w34", 36.585965694, -144.382945078],
    [0x1a68f73feaa620e4, "39ngfgzbnshf", -38.695199058, -102.876034558],
    [0x6dbc32756c6a2b10, "eqy34xcde8pj", 38.187533272, -24.848854647],
    [0x3efc47ae252acf26, "7vy4gcj55c7k", -12.166835938, -2.640673188],
    [0xd3730d4c02041036, "uethum020h83", 65.549951182, 29.71836132],
    [0x18ab1d22496ceefc, "32pju8k9emrg", -43.987598269, -113.702166226],
    [0xdafd5485e92d016d, "vcyp91g95n0q", 56.171927429, 87.236381083],
    [0xb9d373956a1ca646, "r79r75cb3km4", -24.017420436, 148.142112163],
    [0xd111d1fed6bcdf52, "u48x3zqqrmgp", 60.377844432, 0.788927657],
    [0x2231a29da31b1c2d, "48su57e33df2", -86.464919467, -60.672959463],
    [0xafbc932665ad0b57, "pyy969m5pn5p", -51.804108479, 178.007659264],
    [0x345e7447f542a348, "6jg78jzp8bjn", -12.008141451, -85.42003532],
    [0xe62580fa8a881f49, "wsks1ynbj0gn", 24.642339085, 118.914517829],
    [0xecd20b2ecb48bc73, "xm90qcqc92y7", 30.988573861, 147.962212761],
    [0xda2ff7ecb9664834, "v8rzgv5tdt43", 47.796991735, 78.568149296],
    [0x52ed2dbca26d6e9e, "bcqkvg52epr9", 52.882815433, -137.203649666],
    [0x68f2838e81f80273, "e3t873n1z017", 8.487239435, -25.864260812],
    [0x70ff2cb8b8de92e8, "f3zktf5svu9f", 55.646591825, -68.296946092],
    [0x93569483862444ab, "kec990w64j2b", -23.63946, 24.661990521],
    [0x0139816eb3594d10, "04ws2vpmc56j", -75.1619585, -170.816414043],
    [0x057caf8048d2aa3d, "0pybz028ubp3", -46.272911693, -170.199294924],
    [0xe2ea021151e3f1c5, "wcp044bjwgsw", 5.641070246, 133.681936417],
    [0xc663677162d5848c, "stjqfwc2uq28", 29.348764693, 29.99457568],
    [0x861f3ac8ff048f02, "hsgmpk7z0k7h", -62.377772681, 27.39408077],
    [0xabc943c323b38342, "pg4n7ht3qf1n", -72.001421611, 171.701836889],
    [0x6a4fb3c350a55cbd, "e97v7huhnpfc", 7.980922607, -17.08897198],
    [0x8312c9a0dd74c770, "hd9dm86xfm3r", -75.539259165, 24.854605685],
    [0x88a56e4f5b9cc4e8, "j2kqwmuvmm2f", -87.418656451, 62.507970324],
    [0x1ea9c9a58e62a33e, "3unwm9dfdbjm", -21.392697349, -91.863773905],
    [0xd6db83d53a4c60f5, "uves7p9u9jhg", 76.726568996, 38.806163508],
    [0xe6c05eca398799eb, "wv05xkjthydy", 28.763101285, 124.07636443],
    [0xd6509a9c5ace59e0, "ut89p72uttdy", 76.131937056, 23.522998269],
    [0xda855217e7757511, "vb2p45z7fpuj", 47.658004334, 78.8479382],
    [0x92df1318217f804a, "kcgj6611gy04", -34.22207916, 38.069161445],
    [0xe0eb80f9a541ffc0, "w3ps1ye587zw", 6.364452541, 111.87791998],
    [0xc57694083e2553ea, "spv9821y4p9y", 43.858493097, 7.7478531],
    [0x8868d84df3dca804, "j1nehmgmvkn0", -83.815061958, 54.332089133],
    [0x02f45b18e4d816ff, "0cu5q674v0cg", -79.572124567, -140.346004702],
    [0xc72a1628f97d8932, "swp1db7tgq4m", 34.016065272, 32.469548778],
    [0xef6fe09144c5b27c, "xxry14b4sqt7", 41.851508346, 168.44257246],
    [0x9944b2d27bbd78b2, "m52c5nmvrpwc", -26.507694844, 46.194729487],
    [0xc5332b9332bd12c3, "sntkr4tkrn9d", 37.324068042, 7.697942036],
    [0xbc04d03915cae3f0, "rh2e0f8ptcjz", -20.551379336, 135.736338519],
    [0x39fd4b36d9debcb2, "77ynqeqtvuyc", -22.788751693, -25.017673148],
    [0x5eec0d19b4e86c8d, "cvq0u6enx1q8", 74.677941504, -92.6213032],
    [0xfa1de3678da93046, "z8fy6twep4s4", 50.348124032, 161.486283048],
    [0xccf4e9317bdc5a56, "tmufkdcvvje5", 32.755381175, 63.130063363],
    [0xce594d78d45acdb4, "ttdnuy6ncc6v", 32.159522092, 70.52406565],
    [0xe20f8613ec4071e5, "w87sd4zd81sy", 2.212810186, 117.520071747],
    [0x066c7dbe267be873, "0tq7vgj6ggn7", -59.79260211, -148.45087272],
    [0x65c3d95e5b54d479, "dr1xkrkvbmb7", 40.69025797, -76.447322974],
    [0x22d47f96f667d3af, "4cb7z5rqdz9u", -79.478060667, -55.580743269],
    [0x8296310c7408c3f9, "hbc3233n131z", -85.553620394, 35.520228358],
    [0xa1d46d925cd7b29a, "n7b6v4kwuyt9", -68.409298164, 101.827680393],
    [0xf94f247818f04ff7, "z57k8y0sy17z", 64.106048017, 139.604220813],
    [0x509bb68af0d73925, "b2eve2rhuwwk", 48.781521254, -163.323925673],
    [0x5adf11a1317310b9, "ccgj389jfd8c", 55.770348839, -96.963850245],
    [0xc335ac88bc4a583a, "sduut25w99d3", 16.260889678, 29.415274583],
    [0x83cc97b21a2d3539, "hg69gdhu5num", -71.399422729, 37.426091406],
    [0x13b891d83c88216d, "2fw93q1wj0hq", -30.683783332, -137.052162917],
    [0x7ee66caf5c1e64a9, "gvm6tcuw3tkb", 74.98141727, -3.608251157],
    [0xe086a1916d9f56b6, "w23b34cemxcc", 1.465901256, 103.757181226],
    [0xca091bb524140193, "t84jre942h0t", 0.942486254, 70.643463922],
    [0x6e3cabbb119fdeb7, "esybrfsjmzgc", 26.777371354, -12.661491247],
    [0x3ce66e03c77d59b9, "7mm6w0y7gpdv", -15.024492148, -26.094799908],
    [0xb707ece6bf08643a, "qw3yttpz11k3", -8.672497533, 115.213328671],
    [0x029db43bad4dde5c, "0bfv8fxe9rg5", -84.800077211, -142.339495992],
    [0xaee5a5e49ea4cbd7, "pvkuct4ynm5x", -59.605265128, 175.49965504],
    [0x5d5f6a3bbb0ed17d, "cpgqnfxv1v8r", 89.663059554, -130.122337953],
    [0xf0eb9d71a09ff0c3, "y3ptuwe0mzsd", 51.671531299, 111.99900169],
    [0xdadf57a94b68a38f, "vcgpgbbce2js", 56.210432874, 83.134722024],
    [0x55196e6bcb46a15b, "bndqwuyc8uhp", 82.731450842, -176.529999077],
    [0x84894eb0ddc549f9, "hk4nxd6xsp4z", -66.34373602, 14.395698654],
    [0x0cdfed7c68b7a9b7, "1mgyuz38qynv", -56.429825027, -118.265463514],
    [0x85a93a5fb5c34e89, "hqnmnrxpse78", -55.328590042, 20.323531776],
    [0xb294b0b3e02e960b, "qbbc1dz05uc0", -40.590337001, 124.880381107],
    [0xf863076e12bdb8b9, "z1jhfvhkrqwc", 51.488191398, 142.158256526],
    [0x253d2b4e2f66cdbf, "4nykqmjgdv6v", -51.256083901, -80.928260899],
    [0xb28a8a8e8e85f672, "qb58p3nfhrv7", -44.994121398, 128.999937778],
    [0xe9d3e7b2f3107c9c, "x79ygdrm21y9", 20.887293922, 148.874711342],
    [0x838e48d54bf4a4fa, "hf74jpbcykkg", -76.949291766, 38.189781432],
    [0x52303b1c688e983a, "b8s3q738jud3", 48.050103661, -151.246469255],
    [0xfb89f2dc78230c08, "zf4z5r3s4d60", 57.520992907, 172.762179844],
    [0x04fa6a4d064cdece, "0mx6nm869mgd", -58.680264646, -158.279627316],
    [0x0832fdb49d09146a, "10tgve4x14b6", -86.510624067, -126.668886486],
    [0x755c7a13805ed793, "fpf7n4w0cvct", 89.134987152, -86.56394861],
    [0xcb7c4b723e62a718, "tey4qwjydbmj", 21.523334787, 76.231165907],
    [0x2b3ed8096e5d976c, "5dzeh2cfcqcq", -73.999276984, -11.763898615],
    [0x8d0285f7ac3b745a, "jn18cxxd7eu5", -56.076558466, 47.185748545],
    [0x2ede234d549a6d65, "5vg26mbnm9qq", -57.579638259, -6.580566121],
    [0xcad67b9994d79eab, "tcc7r6dnuygb", 10.42996694, 80.829371777],
    [0x50b3d3cfe42200cc, "b2tx7mz4480d", 49.118843502, -160.863081525],
    [0x90f6ecd6b07b449a, "k3vftpphge29", -34.677511721, 19.56542828],
    [0xed1fcb415cce4af0, "xngwqhbwtt5g", 39.094618478, 140.186474625],
    [0xfd65e96886e28834, "zpkyku46wb43", 86.902284896, 141.891810399],
    [0x09eabb3bf1604006, "17pcqfzjd100", -72.889217633, -112.545232613],
    [0x8b8e74b6ca00f510, "jf779eqb03uj", -76.710652581, 83.395516277],
    [0x9b7eacbb764cdd78, "mezbtfvq9mfr", -23.802105335, 78.658389687],
    [0xacf2410fad9363e6, "pmt423xekejy", -58.658177336, 153.302736928],
    [0x13775deecc50e84b, "2evpvvqdb3n4", -22.514628365, -150.207119013],
    [0x9ee26940f90b8637, "mvj6kh7t1f33", -16.455275546, 86.313477197],
    [0x9d13fa4f92198b6a, "mn9znmwk365q", -7.176077535, 47.744237094],
    [0xfc9d9c9068d7ddd8, "zkftt438uzfx", 72.698077995, 149.987618945],
    [0x6aece4e234da5aa5, "ecqf9sjnv9eb", 7.493842681, -1.684786938],
    [0x55af7f7411d71a77, "bqrryx0juwe7", 81.558029396, -158.268845383],
    [0x62696fb4e78daccc, "d9nqze77jqqd", 6.829925176, -58.376650259],
    [0x2a22612d9689b3aa, "58j62cdqj6tu", -89.595208375, -15.080905299],
    [0xe13b7867b4c99dd9, "w4xrhtxnt6fx", 15.32431292, 100.402908276],
    [0x4904a1c00de54f47, "942b3h0ewp7n", 12.722808829, -133.900418862],
    [0x8fa1a911b562fcc8, "jyhuk4epdcyd", -55.487899557, 85.609715543],
    [0x8384cae7736bf1a8, "hf2dptvmegsu", -76.959638212, 34.790092096],
    [0xa80f75b04fc2811b, "p07rcd2gsb0j", -87.218483986, 139.637464586],
    [0x4c04b3d24bc13594, "9h2c7nkcs4ut", 24.160582044, -133.80677569],
    [0xf557cbc517be393b, "ypcwrj8rrswm", 89.723864782, 92.417666016],
    [0xd3cfb6952747d9c0, "ug7ve5978zdw", 64.267915004, 39.157025605],
    [0x3e0086bffcd5e5f8, "7s08egzwurkz", -22.39031121, -21.621591408],
    [0xb7ef04e1f9efda24, "qzrh9sgtxze2", -3.400657377, 133.664811468],
    [0xb39cf20d00668e42, "qffg4380du74", -28.995557539, 127.716186603],
    [0xe087416cb72756e6, "w23n2v5r4xcf", 2.533592257, 102.693781935],
    [0x03e8a23d2c2841be, "0gnb4g9d510v", -73.105424284, -136.634772916],
    [0x9a49bcec1afa8c24, "m94vtv0uzb62", -38.379920461, 71.62123869],
    [0x3de58e3324fdcd99, "7rkswdt4zr6t", -3.413489607, -27.129049331],
    [0xcdd8a96184b71c25, "trdbksd4qwf2", 42.25658716, 60.317970012],
    [0x8b3c4bd2d462aae1, "jdy4rnqndbpf", -74.100293715, 76.253485382],
    [0xa3ca9837575592c1, "ng59heurbq9d", -72.927253723, 128.875478159],
    [0x6d9ab2eb3043f57d, "eqec5uth8gur", 36.763794416, -28.304863059],
    [0xcb4d91c55ea30f4d, "te6t3jbynd7n", 19.236730432, 71.060883447],
    [0x1b7922ee0348356f, "3ewk5vh390uq", -24.581646526, -103.540257143],
    [0xc0d79761ce722bed, "s3ctfsfff8py", 10.881057948, 13.47313274],
    [0x6fe0526642a23cfa, "ezh54tk2n8yg", 39.931187425, -5.509011921],
    [0x99762d02ece2cd16, "m5v2u0rdwc6j", -23.772603988, 52.569185894],
    [0x17e3b38a69940695, "2zjv72m9kh39", -4.700537457, -138.013513432],
    [0x3cfe482442f58511, "7mz4h922yq2j", -12.29765788, -23.707884474],
    [0x7829c0e3a0ce9c08, "g0nw1sx0tuf0", 46.07951805, -35.783594361],
    [0x6db32a608844dcff, "eqtkns488mfg", 37.287714978, -26.078095055],
    [0x68e7d5015460e4a2, "e3mxb0bnd3kb", 8.398797072, -26.015521914],
    [0x1eceedf16f2acf60, "3v7fvwcg5c7q", -14.947750008, -95.732294673],
    [0x46587d27ece8279d, "8td7u9zdx0mt", 31.606724217, -154.127575883],
    [0x4afc729707ae5393, "9cy755s7pt9t", 10.390865198, -92.3229411],
    [0x6d5513fdf18cde3b, "epbj7zgjjmg3", 44.560062968, -44.830855262],
    [0x48a34cd16e759a3c, "92jntncffqe3", 1.180164175, -116.49651904],
    [0xab2d29c213882a7c, "pdqkmhhmj0p7", -76.573848107, 166.514850092],
    [0x2cbad3800a3bbf8d, "5kxe700b7fzs", -64.116152473, -23.07008791],
    [0x3d72a4681bf4f60d, "7ptb8u0vymv0", -2.701618673, -36.879798427],
    [0x462fc3d1af491cdb, "8srw7neg94fe", 25.041204531, -146.81609264],
    [0x796560b62ef3aca4, "g5kq1ejfyfqb", 64.352901256, -38.949324341],
    [0xe1eabb02e04a78dc, "w7pcq0r099we", 17.096194357, 112.421795717],
    [0xa2a8dd488f82bef9, "nbneuk4ghbzg", -89.318328098, 133.081383586],
    [0x17252b7b40ef85dd, "2wkkqyu0xy2x", -9.059480161, -151.220979968],
    [0x85ceee77e8da0ffe, "hr7fwxz8v87z", -48.736593482, 16.81962308],
    [0x2577db02ce3ff99f, "4pvxq0qf7zwt", -45.13003519, -81.992513509],
    [0xb663f638ff4d2b62, "qtjzdf7z9npq", -15.542960323, 120.711989732],
    [0x2edeb2fece22e880, "5vgc5zqf4cn8", -57.440294617, -5.802371107],
    [0xd8f04e1cd62b7ede, "v3s4w76q5eze", 53.895856596, 62.152908695],
    [0xef2e082aa7e2d8c0, "xwr0hbp7wcdd", 35.15685922, 167.562739657],
    [0xdb494ec96c72c4b8, "ve4nxkcdfc2c", 63.044149631, 70.633282644],
    [0xaf60fde8b25c784a, "pxhgvu5kcjw4", -49.943002406, 164.436887512],
    [0x0563627d9fd4b07c, "0pjq4zdzuks7", -49.527758638, -172.492373062],
    [0xf4f79b1aec39693f, "ymvtq6rd75nm", 78.279364514, 109.269470275],
    [0xb0f3a47e6609ae68, "q3tu8zm616r6", -35.731303207, 109.376169865],
    [0x2c88504c8bcc4f24, "5k450m4ctj7k", -66.94490401, -30.922518128],
    [0x35716a191c47a05c, "6psqn68w8yh5", -1.742930986, -83.748054877],
    [0xd9193e412569ce26, "v4dmwh95e772", 60.054634462, 48.429251586],
    [0x4bc59ec8e0b7a746, "9g2txk70qymn", 19.271470389, -100.223855113],
    [0x8c72d1fd78e3bb4d, "jjte3zcswfxn", -58.447851888, 52.813638523],
    [0x800e4da9bed27f74, "h074vbeyu9zr", -88.106435597, 4.476788272],
    [0x67e2c45039878e4e, "dzjd8n1thy74", 39.848304396, -48.513356883],
    [0xd0a36cab34e64138, "u2jqtbtnwt0m", 46.146468192, 18.892644023],
    [0x2197a7c9a2d28473, "46cugke2ub27", -73.671439182, -76.141572738],
    [0x4a5aaa2460a6e660, "99ebn930nvm6", 8.444394978, -106.939247946],
    [0xee1705df5883e81f, "xschcrushgn1", 27.596986007, 158.96757364],
    [0x6cacba3a4b12bb46, "ekqcnfkc2bxn", 24.094609243, -23.954616829],
    [0x2ddc904d0bb92c6c, "5rf90m8cr4q6", -46.200029259, -30.22204973],
    [0x3c44dae8d5c6c100, "7j2epu6psv0h", -14.916745347, -43.953348381],
    [0xc5a67976b9a23f7b, "sqm7kxptn8zr", 35.766854776, 18.841155089],
    [0xe91d19089f0a23c6, "x4fjk24z18jw", 16.392804314, 138.003115981],
    [0xad580bb72fbc7976, "ppd0retgrjwr", -47.748739929, 138.150295142],
    [0x228fbba741d2b239, "4b7vr9u1ubt3", -87.660982071, -50.64126838],
    [0xf1bf86fd67ae5cb1, "y6zsezc7ptfc", 61.30288369, 111.963712114],
    [0xb005c77bc855d953, "q02wfyy8brdp", -42.369977496, 90.832914536],
    [0xb7e570f9e5aada3c, "qzkr1yg5pce3", -2.950679098, 129.807923798],
    [0x6934f78ccf33a0cc, "e4ugg36g6fhd", 16.135365204, -38.173589451],
    [0xb7bf23fccda2be3f, "qyzk7z6enbz3", -6.243834946, 134.113840376],
    [0xbd2e4456ac4b0edd, "rnr48ppd9d7e", -9.365402849, 144.854118967],
    [0xce50eee148004171, "tt8fxsb8010r", 31.403052263, 68.884964364],
    [0x18523a6d0919c5bd, "3193nv89372v", -36.356273331, -132.944815144],
    [0x3b019a817676f0de, "7d0tp0cqfvse", -32.865785063, -21.487416813],
    [0x884f2b525c05c3b6, "j17kqnkw0r1v", -82.186278944, 49.840177355],
    [0x83a734590a544051, "hfmm8q8bbj05", -76.341091443, 41.144828807],
    [0x1f31f139a65aae39, "3wsz2fe6cbr3", -7.148879371, -105.782805291],
    [0xadf99d881a2cc175, "prwtv20u5m0r", -46.801043021, 155.622507705],
    [0x4fa56eeda8aeda6c, "9ykqxve8pve6", 36.329070463, -94.927717648],
    [0x458581bb108bb129, "8q2s3fshjfsk", 35.917753992, -167.964224886],
    [0x1d1ae9988087df20, "3nefm640hzgk", -8.030963593, -129.492894785],
    [0x9b337d43021ea21a, "mdtruhs23uj1", -29.550411496, 75.064512335],
    [0x8d79bdadfa1eaf95, "jpwvvcgu3urt", -46.791391427, 54.750108097],
    [0xc2f9c458c386ce80, "scww8q63hv78", 9.61461026, 42.904909789],
    [0x49980aa71adb22f6, "96d0p9suvdjg", 14.071566481, -120.601143158],
    [0x4650bfd25b63b049, "8t8cznkvdfs4", 31.280407394, -156.131048577],
    [0x9a712465c20dfef0, "m9sk8tf21rzg", -35.739856576, 73.501689126],
    [0x7257b6841e35e0cc, "f9cve10y6rhd", 55.817150905, -64.906093814],
    [0x3c4887f9b52aa36f, "7j48gyep5bjq", -16.706255717, -41.315291939],
    [0x3101219a11853171, "640k36hjhnsr", -32.991048927, -89.587835315],
    [0x632c3516adefdbea, "ddq3b5pexzey", 12.980988763, -58.700299913],
    [0x69eb2d47177eff4b, "e7pkujsrgvzn", 17.741535649, -23.372899121],
    [0xeb0d3ccc226826bb, "xd6mtm12e0mc", 13.65060011, 160.896628792],
    [0xb785babb478989ea, "qy2vpfu7j64y", -8.949210829, 125.15132948],
    [0xafac454a155d43c5, "pyq4bkhpcp1w", -54.337009839, 177.204024452],
    [0x69c81e588d62edf4, "e741wq4edcqz", 17.172239644, -30.659281446],
    [0x7b1e9eb09fd2acc3, "gdg9xd4zubqd", 60.744740299, -17.244545908],
    [0x739ed9b82d5fe424, "ffgemf1eczk2", 61.051708118, -51.073298702],
    [0x9a3ebd0edda3bd8a, "m8zcu3qxnfys", -40.465549305, 78.594430159],
    [0xa189ba3395e9e5c0, "n64vndwpx7kw", -77.856054903, 105.411389005],
    [0xdf25736accb71957, "vwkr6uqdqwdp", 81.454432429, 73.606620225],
    [0x70bc362f83ce978c, "f2y3dcw3tucs", 49.490945355, -69.831255798],
    [0x38aa9661f1d6b767, "72p9dsgjuuvq", -44.709221927, -23.088930802],
    [0x9504acb9baf65479, "kn2btfeuytb7", -9.741279653, 1.312802363],
    [0x6a509c7b131cb830, "e989sysm3kw3", 8.737803008, -21.582236222],
    [0xd709b2d4bcf20fe6, "uw4v5p5wy87y", 79.66851958, 26.504114081],
    [0xca68b48fbbc23f7c, "t9nc93xvs8zr", 5.897861066, 77.057965217],
    [0x97ffac79faa2a614, "kzzusygunbm1", -0.577467262, 44.862624018],
    [0xef989872cdd7b7a1, "xyd9hwqeuyvu", 36.773294184, 172.472516936],
    [0xa6d5293233dea5aa, "nvbkkdjmvuku", -56.897182802, 124.306779619],
    [0x3b649e9d8d5dd9bf, "7ek9x7decrdv", -26.43516709, -15.849780645],
    [0x11a6e9b3a2855ba0, "26mfmdx2hpeu", -31.934468332, -160.412230226],
    [0xe85ca20a3483d169, "x1fb42jnhg8q", 9.844799816, 138.973135306],
    [0x3e0cffc81f757444, "7s6gzk0zfpu4", -20.411225275, -18.313087808],
    [0xfe1a9c1afe48061d, "zse9s6ry9031", 70.589648928, 162.619330079],
    [0x1e70564a61512d82, "3ts5dkm1b4qs", -13.423606508, -106.769247785],
    [0x62925797ba057b84, "db95g5xu0pxs", 3.491633435, -54.701260972],
    [0xb44fb9f77c1eced5, "qj7vmxvw3v7e", -14.502224718, 95.522769692],
    [0x92d29ec0b59c9c12, "kc99xh5pmkf1", -36.275585262, 36.171340167],
    [0x571562ac662274fb, "bwbq5c3649ug", 84.030657221, -156.981812035],
    [0x8bcb1008e5899136, "jg5j0275j68m", -72.244191116, 82.98408197],
    [0xa1292a8ddebc0f69, "n4nkp3fyrh7q", -78.036165206, 99.111747541],
    [0xabb43ab9040be4f4, "pfu3pf841gkg", -74.341374479, 175.067220214],
    [0xa60f8ef38271a663, "ns7sxww2f6m6", -65.266887615, 117.7601516],
    [0xc5b60eb3617424f4, "sqv0xdv1fhkg", 38.072070626, 18.617798554],
    [0xdfe32ef7769df90c, "vzjkxxvqmrwh", 85.209701521, 86.469845725],
    [0xee68ac70cb9760d2, "xtnbsw6ckxhe", 28.247475534, 167.193917266],
    [0x2aee04391ccadc5f, "5cr08f8wtcf5", -82.866000639, -1.372354648],
    [0x46a2332cbceffd8f, "8uj36c5wxzys", 22.726377923, -138.741189758],
    [0x54ea554dab9d8a65, "bmp5bmecmq56", 73.814639317, -158.889884117],
    [0x20cb634dc6823adf, "435q6mf6h8xe", -83.244434836, -74.07751719],
    [0xfd228ec79ee0e7ea, "znj8xjwyw3my", 78.869226558, 143.051538135],
    [0x5876bb66f917491d, "c1vcqtrt2x4j", 55.093255452, -126.618093902],
    [0x8f373f819486dbde, "jwvmz0dnhvex", -51.016700483, 75.193385114],
    [0x349ef09319aba054, "6kgg14stpfh5", -17.739303687, -73.426099352],
    [0x38d97f9458b4225d, "73drz52sqhj5", -35.181590842, -30.277369293],
    [0x28da7f171b6465c8, "53e7y5svdjkw", -80.88312092, -28.909400423],
    [0x4d4195e7458ef3d2, "9p0tctu5jvtx", 40.417873578, -134.225209596],
    [0x3e253a7a81f93fb2, "7skmnyn1z4zv", -20.181568748, -16.218255937],
    [0x03757174525847e6, "0eur2x2kc13y", -67.591187282, -151.501076119],
    [0x0249b69cf006211a, "094ve77h0shj", -83.389641397, -153.485843257],
    [0x89bcbce8d50c8cbc, "j6yctu6p1k6c", -74.243007468, 65.99767713],
    [0x18024ef7c16bd792, "3014xxy1egct", -44.517696391, -133.255757369],
    [0x6c52d1a759c827c1, "ej9e39utt0mw", 31.519348648, -42.818305228],
    [0xe1371239bfb8f37f, "w4vj4fezr3tr", 16.362643083, 97.157567937],
    [0xdf3c4b999fa8bced, "vwy4r6dzp2yf", 83.379196858, 76.260200491],
    [0x1cc45e8a152cdfe6, "3m25x2hp5mgy", -14.85228202, -123.425758652],
    [0xf15ce5114cc807ed, "y5ffb4bdt03y", 66.592686294, 93.86809125],
    [0x6f128968a32a8e31, "ew98ku535b73", 36.628591193, -20.177256195],
    [0x5f9d1eca28e5f691, "cyfjxkj8wrv9", 83.957647178, -98.111067724],
    [0x4048f9418c4e88b0, "814gkhdd9u4c", 6.221459094, -175.953519178],
    [0x5faeb19a69969369, "cyrc36m9ku9q", 80.388575971, -90.288872042],
    [0x93297a039a93a59a, "kdnrn0wukfkt", -32.516042172, 31.562214258],
    [0x6cf06df2e4dead8d, "ems6vwr4vuqs", 31.455726413, -27.52186955],
    [0x2b9e719ba0fb0a2c, "5fg736x0zd52", -73.946088456, -6.614816418],
    [0xc255e62ec410f57c, "s9bydcq423ur", 10.993591498, 23.683793482],
    [0x6c51bf34309a3e77, "ej8vye1hm8z7", 31.965455902, -43.658048809],
    [0x3c8e13bb96252aa5, "7k717fwq4npb", -20.859228243, -29.357775728],
    [0xb939c89e43e25ed6, "r4wwj7k3w9ge", -29.864692216, 144.377458163],
    [0xf7d21d556ced50ef, "yz91upcdxp8f", 87.538159059, 125.334392921],
    [0x31ae299876f50144, "66r2m63qyn0n", -32.286253046, -68.322000451],
    [0xa006e675c65fe35a, "n03fdxf6czjp", -88.111214042, 92.573972812],
    [0x5e271cedb6527765, "csmjtveqb9vq", 69.904428535, -105.211572717],
    [0x4d02ad868ec2f065, "9n1bv1nfscs6", 33.887766769, -132.309856636],
    [0x65f355b8de7ad134, "drtpcf6ygc8m", 43.563331995, -71.63790784],
    [0xe69b873c24252528, "wuesfg144nkk", 26.164317953, 128.794189681],
    [0xbb5e3ad50e139028, "reg3pp8f2f82", -23.688870344, 162.378992366],
    [0xa5cdb40a20c45ecf, "nr6v82j0sjgd", -48.251835977, 105.135216927],
    [0x7aead0abc2f94810, "gcpe1by2z541", 51.156608662, -0.617334514],
    [0xab5b29de63ec4e9c, "peekmrm3xj79", -69.525318319, 162.308540512],
    [0x02cd9d7af7b82357, "0c6tuyrrr0jp", -81.922429662, -142.515371171],
    [0xff3d8c26dffbae24, "zwyss9qzzfr2", 83.767974637, 166.847990992],
    [0x73f0bfe1bf863bbf, "fgsczsezhsxv", 65.021063174, -49.235369018],
    [0x091bbbf5b03304ec, "14evrxeh6d2f", -74.972707649, -129.392744289],
    [0xabba52717a9afa26, "pfx54wcumcx2", -75.372339689, 178.706273141],
    [0x559dbd8169ab7160, "bqfvv0c9pesq", 83.983803514, -164.66069843],
    [0x5e0e8cec9812dd01, "cs78tv4s2cfh", 69.022346116, -107.321971331],
    [0x7e7f933f03834cb1, "gtzt6gs3he6c", 78.286016979, -11.826242052],
    [0xdff3210f858bc937, "vztk23w5jg4m", 87.943342117, 86.152288443],
    [0x60c164b8c4960a15, "d30q9f64ks51", 6.780345765, -78.31858944],
    [0x7f71c3d3d734bb29, "gxsw7nyr6kxk", 88.324481093, -16.031349543],
    [0x32ba92f30ca933c6, "6bx95wsdp4tw", -41.975655353, -45.542828693],
    [0x4c2d573c4fd830a9, "9hqpfg2gv0sb", 25.28705393, -126.440399273],
    [0xacd024e05c43c702, "pm829s2w8g3h", -58.950129492, 146.668200753],
    [0x793b4e9db9dc7472, "g4xnx7etvju7", 60.225322602, -34.8326196],
    [0x34329efd581494fa, "6ht9xzbs2kbg", -19.380500556, -81.924350117],
    [0xd7501cd25e30bcf3, "ux81tnky62yg", 87.486581617, 22.726355406],
    [0x72982780324ea465, "fbd2g01k9uk6", 47.945131696, -52.952304081],
    [0xfe956f9184849d00, "zubqz4d4hkfh", 72.919375841, 169.412111389],
    [0xd833c5bc29bc1330, "v0twcg19rh9m", 49.015742508, 52.813641329],
    [0x894d1fca1dc3c84e, "j56jzkhxsg44", -70.684731163, 48.137490136],
    [0x16abe4bcf163647f, "2upy9g7jdek7", -21.338606887, -135.270425063],
    [0x6078eed84b193eac, "d1wfxq2c34zb", 8.911514842, -80.188125532],
    [0x290f53fa64dabe26, "547p7ym4vbz2", -76.034527467, -40.60933197],
    [0x3de9fca7cc033fc6, "7rnzt9yd0dzw", -4.296668397, -24.00715525],
    [0x459ec495fb42eac3, "8qgd95gv8cpd", 38.42975238, -163.778987435],
    [0x8d64944cb07591e0, "jpk98m5hfq8y", -48.926761014, 51.343328849],
    [0xfab40f41e8cea9df, "zbu0yhg8tunx", 49.376787063, 174.643734203],
    [0xf4fad16eac618f00, "ymxe2vpdd67h", 76.5366968, 111.840234291],
    [0x5dcb98566cda0a08, "cr5thpmdv850", 85.294203761, -118.644550379],
    [0xa018314013b36b6b, "n0d32h0mqepq", -86.944882408, 93.164694807],
    [0xa8ea9d9894ba36e6, "p3p9v64nr8vf", -84.055319157, 157.030664135],
    [0x1356c7dfd371fe04, "2ecdgrymf7z0", -23.379272277, -155.239113679],
    [0xc998c46cb78fad3d, "t6dd8v5rjyqm", 14.530655094, 59.803302539],
    [0x166020e8eec2100d, "2th21u7fs880", -16.851222051, -151.441190035],
    [0x66e82fb7c078e3db, "dvn2zey0g3jx", 28.277570642, -47.122960771],
    [0x5f1055f493224fdc, "cw85cx4m497x", 82.260998119, -112.430879942],
    [0xb583441963531b1b, "qq1n86c3bdej", -10.092000942, 102.668978683],
    [0xa819c9f2b19bc212, "p0dwmwpjmg11", -86.054990708, 138.767185458],
    [0xfc0a677bb3b0e2ea, "zh56fyxmq3jf", 68.020010928, 139.701394703],
    [0x70f42a3837e98c4e, "f3u2nf1rx664", 54.856036306, -72.474775884],
    [0x3631892bd36ad26d, "6ssskbymec96", -18.935357134, -60.954388898],
    [0xd78c633fe3da4859, "uy666gz3v945", 80.572663527, 37.045107359],
    [0x7f7c4e4cb5dd312c, "gxy4wm5pvnsk", 89.062034981, -13.783501477],
    [0x2196e38ebc4e0dbc, "46cf73pw9s6v", -74.129109487, -76.135872294],
    [0x2df91245f4d7c2aa, "5rwj4jgnuz1b", -46.900811781, -25.220282985],
    [0xe282ced309927930, "wb1dxns9k9wm", 0.475382175, 126.173373543],
    [0x32b3c0b6dfc5c0a9, "6btw1eqzsr0b", -41.113634654, -48.440253707],
    [0x35bef4a98ce1a73c, "6qzg9bddw6mm", -6.412826858, -67.770949483],
    [0xfb8639279de0c07c, "zf33k9wxw307", 57.885509728, 170.714761554],
    [0x9fe2ef63026672e8, "mzjfyss2dttf", -5.116766634, 87.127533722],
    [0xf07896bb365cc40e, "y1w9eftqcm20", 53.716091767, 99.312683627],
    [0x2b65b45fa50cd291, "5ekv8rx51m99", -70.71020966, -15.799657423],
    [0xe7391e5839679a42, "wwwjwq1tdye4", 37.563235205, 121.214340338],
    [0x4dd6f10dc85af868, "9rcg23f8ccw6", 44.174789238, -121.274559226],
    [0x21cc28432ee6c38a, "4762hhtfwv1s", -71.693574087, -75.401967802],
    [0x19f4a7a4ffc28ab4, "37ubg97zsb5c", -23.766259895, -116.911145152],
    [0x77e8b12497643226, "fznc294rdht2", 84.60153145, -46.732656908],
    [0xa6659543e840fef2, "ntktbhz883zg", -59.431819548, 118.838445957],
    [0xb427710bab99859e, "qhmr22xcm62t", -19.816361754, 97.404668083],
    [0x257f3d2835bf7a91, "4pzmub1prxx9", -45.394222787, -79.594242026],
    [0x7be69ce12a834754, "ggm9ts9bhe3p", 63.569659829, -3.271328041],
    [0xe9b7a674d950d36b, "x6vudx6tb39q", 16.300587219, 154.449246712],
    [0x3125413d9d4135fa, "64kn2gdx84uz", -31.224587706, -84.338601144],
    [0x0d75e8779759f596, "1puyhxwrc7ut", -45.309012328, -128.11391572],
    [0x756dfdaa4073c39d, "fpqzvbk0fg1t", 87.145073798, -80.249513571],
    [0x2bf39965b8c8fe0d, "5gttktest3z0", -69.358654038, -3.312829685],
    [0x32ee286a619e8e07, "6cr2hum1mu70", -37.945166511, -45.83882989],
    [0x17f32c4acd1c0eb7, "2ztkskqe3h7c", -1.997557426, -138.67144544],
    [0x22e4e2867d6a377a, "4ckf51mxe8vr", -82.609028379, -49.430765896],
    [0x08eadb450a8ed981, "13peqj8bjvds", -83.773468279, -112.938172981],
    [0xd718be1d32cc8cdc, "uwdcw79ktk6e", 81.846193836, 26.643791158],
    [0x4dba293c8fa3bfdd, "9qx2kg4gnfzx", 36.623455859, -113.341870778],
    [0x9ac1774633c13a23, "mc0rfjjms4x2", -37.984271895, 79.196844385],
    [0xa1a195f45785e191, "n6htcx2rhrht", -77.69819228, 107.644574758],
    [0x8553d37c7901af42, "hp9x6z3t06rn", -46.497389112, 2.232304796],
    [0x3ec11d95c2a28c88, "7v0jv5f2nb68", -15.843657081, -11.026890257],
    [0xf93bc3769ecb8be2, "z4xw6xnytf5y", 60.200712509, 145.6662599],
    [0x63db20448889b29c, "dgek0j48j6t9", 20.418104484, -51.676021368],
    [0xf29a023e0116412d, "ybe04gh12t0k", 47.829221722, 128.095114782],
    [0xe75c2559f7077f38, "wxf2bqgr0xzm", 43.763908856, 115.679543422],
    [0xa9facfc5a1283de2, "p7xdzje150yy", -69.798712462, 157.108749984],
    [0xb659982608abb52f, "qtdth9h8pfuk", -13.178085019, 116.219897298],
    [0x62ca50d34d288129, "dc551nue520k", 6.189938341, -51.98098484],
    [0x655a3cc568701ef6, "dpe3tjc8f0gg", 42.482890946, -85.207809979],
    [0x91c9737d2cfc6bca, "k74r6z9dzjpw", -26.808887272, 14.537282765],
    [0x905b38211675ae05, "k1emh88qfqr0", -35.679654764, 4.768515682],
    [0xfab6421de980fbb4, "zbv447g9h3xv", 49.591092536, 175.88512631],
    [0xd1b1a7ce86d5a6be, "u6sugmn6uqmc", 59.92543264, 18.081283258],
    [0xca3a3222edffb6fc, "t8x348rezyvg", 2.990335068, 77.815815985],
    [0xa98f5647ab5b8bde, "p67pdjxccf5x", -75.994865826, 150.567363703],
    [0x296440938b2615b3, "55k414wc4sbv", -71.35325655, -39.321676557],
    [0xc46a6a72ae485a8f, "sjp6nwpf91e8", 28.509958836, 10.491647904],
    [0x6f9a6d9927cf9602, "eye6v697tyc0", 37.060268412, -6.447009771],
    [0xd410d6a545dff8bb, "uh8ee9b5vzwc", 70.938031585, 0.857189728],
    [0x8391515519ef2f95, "hf8p2p8txwrt", -74.620908569, 33.75101864],
    [0x38a4087cc48def52, "72k0hz64jrrp", -43.553541154, -27.913278374],
    [0x5f1a1a9a535fe57a, "cwe1p6kmczkr", 81.751668023, -107.956728924],
    [0x5cd9a880eafe985e, "cmduj07bzud5", 76.642151794, -119.657600554],
    [0xf550df0e18b90798, "yp8ey3hsr43t", 87.852915339, 90.984265623],
    [0xd991539cfa9252bd, "v68p777uk99c", 60.355504771, 56.398167768],
    [0x88d8a5963481c3cc, "j3dbc5jnh71w", -81.413137404, 60.168183901],
    [0x11568e0a85dce712, "25c8w2n5vmmj", -23.817686611, -177.607494954],
    [0x7c68faaf73e25411, "gjngpcvmw9b1", 73.662910552, -35.15974753],
    [0x093da53fbfcff6e6, "14yubgxztzvf", -73.675733503, -125.463955911],
    [0xc82c8afefae7f48e, "t0q8pzruwzu8", 1.4468896, 54.492140164],
    [0x644f8f1fc7392e34, "dj7sy7y774r3", 30.387380562, -84.794745212],
    [0x16fc9b5268b481a0, "2vy9qnm8qk0u", -12.402126079, -136.837880758],
    [0xe486602be42967bd, "wk360bz455mv", 24.262294115, 103.050521166],
    [0xb0355a38fda24e19, "q0upnf7xn971", -39.53721306, 95.926720587],
    [0x3f28d38c1bac0edb, "7wne730vph7e", -10.672336082, -13.215217413],
    [0x858efecf87620743, "hq7gxmw7d83n", -54.197699991, 16.850732858],
    [0x17d0d6d820df7a42, "2z8eeq10vxx4", -2.164137287, -145.402433883],
    [0x03d378e4b8295b0c, "0g9rjt5s55eh", -69.053859218, -144.245548817],
    [0x3289d364b7b46c8b, "6b4x6t5rqjq8", -43.696847332, -52.619782062],
    [0x1295b7694a480f72, "2bbvfubb907r", -39.744326908, -145.073385536],
    [0x12938f355410ff95, "2b9syebn23zt", -41.330856447, -143.854959655],
    [0x63d7d1b229e37e82, "dgcx3dj9wez8", 22.37942802, -54.066864764],
    [0x4b94714c3ff786e4, "9fb72m1zyy3f", 16.06886924, -100.884755871],
    [0xf1f30f01ff59d083, "y7thy0gzc788", 65.527930009, 108.55012616],
    [0x85a69ef7f3a198f8, "hqm9xxzmn6dg", -54.536633854, 19.324193318],
    [0xbfd02894e6257546, "rz82j5764pun", -2.794261195, 169.325843613],
    [0xe65fa172584475bf, "wtgu2wks8juv", 33.125956875, 117.801596639],
    [0x14f41b75bebc8bdb, "2mu1qxeyrk5x", -12.394229129, -162.833889466],
    [0x39b65afe94830e65, "76v5pznnhd76", -28.964411577, -26.369736584],
    [0x5d8eb12b6cfb8caf, "cq7c2bvdzf6b", 80.380580715, -118.435713878],
    [0xf42f1cbf3191d2ee, "yhrjtgtjk79f", 69.893193397, 100.103487011],
    [0xabf06bf57e9c651d, "pgs6rxcymjkj", -69.873318136, 175.058775713],
    [0x68c6dc5e7f61bf7d, "e33esrmzd6zr", 7.687613334, -31.445854485],
    [0x694fc11167d7535b, "e57w24c7ux9p", 19.395674221, -40.076213669],
    [0xb830817a8e247dea, "r0s82ynf4jyy", -42.110220526, 141.370448884],
    [0xe7650ec91d29faa8, "wxkhxk8x57xb", 41.598205277, 118.4444402],
    [0x43bf43fb9957e43d, "8fzn7ywtbzk3", 16.604114654, -136.232490628],
    [0x2a31183ea214649a, "58sjhgp22jk9", -86.292043008, -16.656297085],
    [0xe578c009b9dd5801, "wpwd02etvpd0", 42.542836415, 99.15663516],
    [0x549d240859c362cc, "bkfk822tsejd", 72.512099596, -165.574063841],
    [0xd42363dbc66bff7a, "uhjq7qy6egzr", 68.636162131, 7.534388789],
    [0x5c4139cf8c71d20b, "cj0mmmwdf790", 74.078554864, -134.408700009],
    [0x681b6828240326df, "e0eqhb140dme", 3.867543556, -40.219544825],
    [0x2a9655c33e58d76a, "5bc5chtyc3cq", -85.09618194, -9.79185265],
    [0xb619c5042f3f46f0, "qsdwb11g7x3g", -18.494886074, 116.018180871],
    [0xb52ba7d43ba6509e, "qnpugp1vnt89", -10.37569882, 101.032956644],
    [0x3a2fd71c80a1f984, "78rxf740n7ws", -42.214946257, -11.851224481],
    [0x3b438c5d8dfeaecf, "7e1ssrdezurd", -27.292118619, -20.200081222],
    [0xfe7faab5add1b524, "ztzupeeeu6uk", 78.066760341, 168.733021958],
    [0x55bf4751c4e82600, "bqznfnf4x0m0", 84.192782794, -158.815305625],
    [0x7d85b3b7e7307e44, "gq2v7ez761z4", 81.100268663, -32.531452299],
    [0xe2b735e6855e03a7, "wbvmctn5cs1u", 5.257623998, 131.20703707],
    [0x3d920e448ea7468c, "7q90wj4fnx38", -8.32176122, -32.076020414],
    [0xf001fd701525c9f5, "y00zuw0p4r4z", 46.396504161, 91.252541714],
    [0xf80ab311bcb7cc41, "z05c64ewqz64", 45.234571659, 140.366427037],
    [0x46ea09dc5f1fd0fa, "8vp0mr2z3z8g", 28.210056048, -136.174430729],
    [0x49f8486d67d12f12, "97w4hvc7u4rj", 20.07130487, -115.101861968],
    [0x2ff50af5a79da12e, "5zuhpxe7mqhk", -45.661335389, -5.290715668],
    [0x1006df161896b09e, "203ey5hskus9", -42.917336829, -177.620563178],
    [0x8f1123d3f32217f7, "jw8k7nzm48cz", -52.652487193, 67.993464527],
    [0x6bedec397bab81f5, "egqysfcvpf0z", 19.439804666, -1.546335369],
    [0x11fa1ee597019052, "27x1xtdr0685", -25.017400176, -158.573559436],
    [0x067d229345384a1f, "0tyk54u57151", -56.937455219, -148.573475304],
    [0xfecb64fbc87889b1, "zv5q9yy8g24v", 74.304786642, 173.406286427],
    [0x20d77d50d0caee3c, "43crun6htcr3", -78.758833579, -76.813403007],
    [0x8cc0b79427a297ce, "jm0cg517nbcw", -61.550383199, 57.438532017],
    [0x9f97b6e1787b4f78, "mycvescsge7r", -6.037526596, 81.366960842],
    [0x160150148e9f9d87, "2s0p054fmyfs", -21.252628496, -157.495973246],
    [0x525518addb1853b7, "b9bjjcfv319v", 55.733179531, -157.243492534],
    [0x16339409257df487, "2stt8295gru8", -18.717271082, -149.753119712],
    [0x3fed4fd4fe72496a, "7zqnzp7yf94q", -2.99123601, -2.499622381],
    [0xf3dc91f9dc82c0cf, "ygf93yfwhc0d", 66.351591228, 127.346167339],
    [0x80de616f3b78eedb, "h3g62vtvg3re", -79.72953548, 15.861317715],
    [0x65f9db45fbf66821, "drwxqjgvytn2", 43.494513714, -69.340265876],
    [0x8dfdf8e52cabfba0, "jryzjt9dpgxu", -45.145206066, 65.986289712],
    [0x8a59072b99ddd9dc, "j9dhfbwtvrdx", -80.723763925, 70.442504884],
    [0x66ebae1f24de0c8b, "dvpuw7t4vs68", 28.935736628, -45.069798202],
    [0x2aaace318f676730, "5bpdwddgdxmm", -89.546173383, -0.413589558],
    [0x14baa92b22e4720e, "2kxbkbt2wjt0", -19.64069266, -157.63534802],
    [0x89b4338043a41a79, "j6u37023nhe7", -74.30995377, 62.359003858],
    [0x8544addb1f1cd822, "hp2bvqsz3md2", -49.049934413, 1.291980333],
    [0x7fc36b01922304d1, "gz1qq0dk4d2e", 85.477078678, -9.225317743],
    [0xed011a8708b5fe5d, "xn0jp1s8qrz5", 34.637231154, 135.31407481],
    [0x828e946626441ea6, "hb798tj68hgb", -88.302157582, 38.701062579],
    [0xeb3f9964656fb5c2, "xdztkt35eyuw", 16.421078735, 168.246169256],
    [0xcd7c3f0e48a7de73, "tpy3y3k8nzg7", 43.908275768, 54.070194665],
    [0xcd6d1d0485aed111, "tpqju145pv8j", 41.798030749, 53.616360446],
    [0x83284d5b32df11eb, "hdn4uqtkvw8y", -78.230044674, 31.131714692],
    [0x38e7d0209ebb6b18, "73mx084yrepj", -36.737191418, -25.989544329],
    [0x4a73a9f5844e806d, "99tumxd49u06", 9.226220143, -104.169541041],
    [0xa31e5b25f0e8493a, "ndg5q9ghx14m", -73.949569202, 117.00881814],
    [0x39d3c51431bb9a83, "779wb51jrfe8", -24.108582354, -31.63891431],
    [0xe6ab412799169dfc, "wupn29wt2ufz", 23.607800549, 133.624685141],
    [0x5ea44c5512e45fa8, "cuk4sp8kwjgu", 69.387705855, -95.448612661],
    [0x0075ba8e13b96043, "01uvp3hmr5h4", -79.270932865, -172.99556656],
    [0x91579b405bcc3371, "k5ctqh2vthtr", -22.95908298, 2.374298502],
    [0x72efc5918636d56b, "fcrwc4d66vbq", 53.231924493, -45.655971154],
    [0xfb2ad1655b761e9b, "zdpe2tbvfsg9", 56.853887509, 168.069989881],
    [0x91f59187897cc1ee, "k7ut31w9gm0y", -22.974830331, 17.631137454],
    [0x6c235eab71a14325, "ehjpxbvjn51k", 23.823354461, -37.621048146],
    [0x25f16dc5d1b4b36c, "4rsqvjfjqktq", -46.593464381, -72.550688911],
    [0x637ff621b7fbe504, "dezzd8erzgkh", 22.416204531, -56.486898048],
    [0x494d86b0631d8b16, "956sed333q5j", 19.084872951, -131.32879197],
    [0xff02652d7de90ad0, "zw16bccxx45e", 79.244310167, 159.293136567],
    [0x99c13049763c1cb4, "m70m0kcq7hfc", -27.21890258, 56.614397909],
    [0x33f53edf3acab54e, "6gumxrtutbun", -22.897476791, -49.946685129],
    [0xa85736376a3eccf7, "p1cmdevb7v6g", -79.168782046, 136.875736967],
    [0x678f57e6f0e40416, "dy7pgtrhwh21", 36.548189342, -51.867570733],
    [0xc08adb1a68128675, "s25eq6m82b37", 0.583693602, 16.45412021],
    [0x35140b335d42da5a, "6nb0qdux8ce5", -6.970902448, -89.708139145],
    [0x5bdfec2fcde40b9d, "cggyscyewh5t", 67.246564422, -95.758633499],
    [0xed0d6d36144132ff, "xn6quehn84tg", 36.360382801, 138.367317601],
    [0x7029f985aee9dd06, "f0nzm1efx7fh", 46.283103874, -80.282622189],
    [0xf964d001ca26f819, "z5ke00fb4vw1", 63.812743374, 141.332027822],
    [0x3b87640ee79e5140, "7f3q83r7mt8n", -31.19371701, -9.471008747],
    [0x897d3444a5799103, "j5ym8j55g68h", -67.911329411, 53.793321963],
    [0xf4fd0511cc016c62, "ymyhb4fd05q6", 78.194178257, 109.690941704],
    [0xa05a53b302cc1135, "n1e57ds2th8m", -80.977367068, 94.378609997],
    [0x3894a394206a0a3c, "72bb7510e853", -40.720739094, -32.56194846],
    [0xa8250e112d74aaab, "p0khw49efkpb", -87.788336222, 140.890839092],
    [0x1c058a64a9823c4b, "3h2snt59h8y4", -20.362983112, -134.006222483],
    [0x4c24bd222c1f9925, "9hkcu8jd3ydk", 24.214289107, -128.114927348],
    [0xed22d7c185f7e156, "xnjeghd5yzhp", 34.434581477, 142.869252652],
    [0x634b5fff15029735, "de5pzzsp0bcm", 18.279710052, -62.935146772],
    [0x12b274ca554dd804, "2bt79kkp9rd0", -41.547591865, -138.806706298],
    [0x3521a656247572b0, "6nhudpj4fptc", -10.420019717, -83.225461868],
    [0x02a6d611dbc71268, "0bmed4fvsw96", -87.962430045, -138.423762817],
    [0xe99e2e8945c94450, "x6g2x2b5t525", 15.561379286, 151.1391306],
    [0xda6b51b39ec7d607, "v9pp3dwyszc0", 51.914304508, 77.419143033],
    [0x4fb700c0e425d2c7, "9yvh1h744r9d", 38.695604995, -94.170586088],
    [0x1a7bd00a59039d98, "39xx02kt0fft", -35.329784036, -101.935923104],
    [0xd9fd1cc6788422db, "v7yjtjmshhje", 67.090094671, 64.914958962],
    [0x4ad38c87b10588dd, "9c9st1xj0q4e", 9.237646494, -98.91127108],
    [0x2d5c51464c46b095, "5pf52jkd8us9", -45.805668239, -42.181281895],
    [0xf46a507db219d16c, "yjp50zek378q", 73.694291943, 99.881226338],
    [0x6cb3a59b13b1bb81, "ektuc6smq6xs", 26.162109213, -25.603016064],
    [0xc664f467ef89d707, "stkg8tzgj7ch", 30.178606005, 29.21252997],
    [0x65c6fabdc658bd95, "dr3gpgf6c2yt", 41.329670188, -75.945334019],
    [0xf531f51da9698689, "ynszb7e9e638", 82.944300396, 96.695622047],
    [0x3d63f2096c31d7ea, "7pjz42cd67cy", -4.390003981, -36.813026415],
    [0x472a2116fd97d23d, "8wp225rxkz93", 33.813083172, -147.294182117],
    [0x40f7be7acf55aa24, "83vvwyqgbqp2", 10.845555182, -160.358141466],
    [0x0ab4451c3568e9d8, "1bu4b71pe3nx", -85.280078059, -95.612491962],
    [0xa963acea1cbd6101, "p5jutuhwrphh", -72.310900551, 143.345108709],
    [0x663f1d58bd27c65a, "dszjuq5x4z35", 27.763692226, -57.464556272],
    [0xbeaaf210b4e56c63, "rupg445nwpq6", -21.960514823, 179.740713994],
    [0x7c10c4c657ec8319, "gh8d9jkrxk1j", 70.782102073, -44.246780478],
    [0x30f51d56470e2c94, "63ujupk71sq9", -34.105144314, -72.943309171],
    [0x301ed1d5369e7eab, "60ge3p9qmtzb", -40.167658413, -85.032216346],
    [0x6197357abb3d2cc0, "d6cmbypv7nqd", 16.51338626, -76.948448006],
    [0x7c8a35df63a62634, "gk53crv3nsm3", 67.85038393, -29.117260081],
    [0x9e2eae19f416c022, "msrbw6gn2v02", -20.989653446, 78.677248241],
    [0xbd8921522c16ce9f, "rq4k2njd2v79", -10.469555997, 149.421652794],
    [0x2347f8403b9c8689, "4e3zhh1vmk38", -70.465384527, -64.860650423],
    [0x2390488e5363f0ca, "4f84j3kmdgsd", -75.578107792, -56.013326297],
    [0xfb61ad777b97d84c, "zehuuxvvkzd4", 62.753474855, 164.385544588],
    [0xfdfd24ed917f74f1, "zryk9vdjgxug", 89.416007224, 155.118869967],
    [0xf1586e8c95e8b4d4, "y5d6x34px2ue", 65.133738398, 93.485729824],
    [0xefd6b26c2d71d326, "xzcc4v1ef79k", 43.797660369, 171.333945437],
    [0x027bed227a9a6a35, "09xyu8mum9p3", -80.373868018, -146.395666373],
    [0x10ad56f264cc634c, "22qpewm4tjjn", -42.240601254, -160.151603492],
    [0x252b6bb104052234, "4npqrd840nj3", -55.13725851, -79.475090553],
    [0x2d85af194fe86eb6, "5q2uy6bgx1rc", -53.993075084, -32.419313407],
    [0xbb85982879b93ee0, "rf2thb3tr4zf", -31.462554135, 169.664235979],
    [0x70987ee4889a1b03, "f2d7xt48m8eh", 48.455246545, -75.252674225],
    [0x37eabaaa17a96e8a, "6zpcpbhrp5r8", -5.447999665, -45.004839079],
    [0xd99c255f0468dbfc, "v6f2brs4e3ez", 60.642223164, 59.43068673],
    [0x79a5d4d097ed3e94, "g6kx9n4rxnz9", 59.008892315, -27.374529246],
    [0x1eb280e76316a86b, "3ut81tv32un6", -19.655677873, -93.442456364],
    [0xa86b20d4d29e72cb, "p1pk1p6kmttd", -83.631290084, 145.24259146],
    [0x3cb1ffd460be233a, "7kszzp30rsjm", -18.285304651, -26.760992805],
    [0xd557bc61150d0f8d, "upcvss8p1n7s", 89.586502101, 2.658739211],
    [0x84964c914a51c4ac, "hkc4t4bbb72b", -62.826544391, 12.877018509],
    [0x5c45d142b8f65e00, "cj2x2hpsytg0", 75.82848296, -134.286292312],
    [0xfcf7ce82a4a1dbb8, "zmvwx0p4n7ev", 78.486691068, 154.301878678],
    [0xfd8fc00158b549a8, "zq7w00bsqp4u", 81.215825195, 151.172823055],
    [0x1558903b3f26d6bd, "2pd90ftz4vcc", -2.621753043, -176.443398998],
    [0x8d49b59ba519163e, "jp4vc6x534c3", -49.599951961, 48.93177708],
    [0x75324aa5b9268a8a, "fnt4p9et4u58", 81.923182032, -82.6342306],
    [0x9936c76ea920d5fb, "m4vdfvp943bz", -29.020203477, 52.865622113],
    [0x7b6ae1fe6556e489, "gepf3zm5bvk8", 62.311005209, -11.517753278],
    [0xd6719a5da04619a5, "utstnre08sdu", 76.857715767, 29.106928236],
    [0xd397a9e6cbff0006, "ufcumtqczw00", 61.244992121, 36.46222845],
    [0x666fd2090c3aa98b, "dtrx428d7bns", 30.7648523, -56.853391498],
    [0xe3974f0437fe5466, "wfcny11rztb6", 16.662128275, 125.421960775],
    [0x9762f841624797e2, "kxjghhc28ycy", -5.071440667, 30.763470017],
    [0x782ddd89c140af8c, "g0qxv2f182rs", 47.772934162, -35.625894566],
    [0x4dd180267586aa0f, "9r8s09mphup0", 42.898714696, -123.017822346],
    [0x7d3e5e7a9a7c1a0e, "gnz5wynughe0", 83.617782987, -34.850216331],
    [0x2600e68552f6a9b2, "4s0fe1bkyunv", -67.05009614, -66.312834407],
    [0x9f6ddf1d07fe9195, "mxqxy787zu8t", -2.836550385, 76.915959854],
    [0x5128c5457606c8fb, "b4ndbjcq0v4g", 56.766041467, -170.85762219],
    [0xb3aafc4cd03fa46e, "qfpgsm6h7yk6", -33.105162983, 134.838118567],
    [0xc78cc84fa3aa4171, "sy6dhmx3p90r", 35.538203152, 37.46267118],
    [0x72399ba068cff649, "f8wtr838tzv4", 48.736852673, -58.027471509],
    [0x830921cd839e69c5, "hd4k3md3mtnw", -77.972474714, 25.722328868],
    [0x0f7a169a450e0b8e, "1xx1e6k51s5s", -47.535931272, -102.507865184],
    [0x37052a61a491d62b, "6w2knse4k7c2", -9.115499351, -66.858488765],
    [0x4d2c3a9b8439de74, "9nq3p6w477g7", 35.346171129, -125.883950375],
    [0xbb2c14ca5cef027f, "rdq19kkwxw17", -32.055583552, 165.998935254],
    [0x2d78e2fc0892e224, "5pwf5z08kcj2", -47.422436986, -35.342119996],
    [0x5aff33f2aec7dd93, "cczm7wpfszft", 55.800032175, -90.890028612],
    [0xd17ca37afa301e07, "u5yb6yru60g0", 66.172761306, 9.623770125],
    [0xc865366cc204008d, "t1kmdv620h08", 8.026907587, 51.100502913],
    [0x89ae04add79e9744, "j6r09cfrmucn", -77.244975196, 66.173992348],
    [0xebdc6c5bfff568d4, "xgf6sqzzypne", 21.571650503, 172.111739303],
    [0x4cb56b8676af5b56, "9kuqr1mqpxep", 27.825320733, -117.458284527],
    [0xf032f908783c3411, "y0tgk23s7hu1", 48.385917612, 98.274899165],
    [0xaab5d88b0c922ee7, "pbuxj2sdk8rf", -84.547646608, 175.315221347],
    [0xca3d129be206d917, "t8yj56z20vdj", 5.112792927, 76.090313607],
    [0xf930691583fe3976, "z4s6k5d3zswr", 59.477559706, 141.155763997],
    [0x44a2de10d4658559, "8kjew46ndq2p", 23.128744541, -160.749109745],
    [0x884ebb1c53534f69, "j17cq72mbe7q", -82.730165097, 50.548465076],
    [0xd541440e5403dd75, "up0n83kn0gfr", 85.525496002, 0.016514743],
    [0xda5d532d12509edd, "v9fp6c8kb2ge", 56.127223876, 70.433708593],
    [0xecce6935fe2edee1, "xm76kegy5vgf", 29.948418387, 151.023382211],
    [0x4640bc78db5d54cd, "8t0csy6vcpbd", 28.424033257, -156.232751935],
    [0x6b0557ff7be3622f, "ed2pgzvvwej2", 14.062087066, -22.327022354],
    [0xb4feb0ea698f4d11, "qmzc1um9jx6j", -12.456911369, 112.233133643],
    [0xbbc99c3e335e6a81, "rg4tsgjmctp8", -27.1407097, 172.481649476],
    [0x8625e4bc79c3e8ea, "hsky9g3tsgnf", -64.93235849, 29.258864894],
    [0xe696ba61d77f9178, "wuccnsfrgy8r", 26.921990204, 126.499833449],
    [0x7bb71331bab003db, "gfvj6deuq01x", 61.406065287, -4.103477098],
    [0xcc9c023f4827f4cf, "tkf04gu84zud", 26.739391427, 59.189653784],
    [0xf098847274042531, "y2d88wmn0hkm", 47.935776575, 104.794469885],
    [0x3a3f48ac89426e9b, "78znjc4989r9", -39.720804907, -12.400099438],
    [0x9283f17d635b8a8c, "kb1z2zc3cf58", -43.682702669, 36.245693075],
    [0xa9592b1e3b500747, "p5dkq7jvb03n", -69.54796064, 138.446618571],
    [0xba5d15a55b4b12fd, "r9fjc9bv9d9g", -34.134936577, 160.379514835],
    [0xa5b53f5a3fac10e6, "nqumyqjzph8f", -50.986322615, 107.509418697],
    [0x29597f88ecc09a9d, "55drz27ds2e9", -68.948389889, -41.512340134],
    [0x44bccff38a8fcc5c, "8kydzwwbjz65", 27.237893516, -159.270265815],
    [0x43eed732de45d5ef, "8grefdqy8rby", 18.953947826, -135.58397997],
    [0x80c8d48c79173c78, "h34e933t2wy7", -83.751961223, 14.822646651],
    [0x57057a36f55543e6, "bw2rnerpbp1y", 81.40594059, -156.853177446],
    [0x898651282d201f5b, "j6352b1e40gp", -76.771940692, 57.691359088],
    [0xafe64dcf56804318, "pzm4vmuqh11j", -48.702729665, 176.017972561],
    [0xc04d1c4d4ae34ccb, "s16jsmbbwe6d", 8.029736241, 3.000580122],
    [0x226dd83d827bfe5d, "49qxhgd2ggz5", -81.71890567, -58.147374312],
    [0x1b9a006a78a2dcb1, "3fe00umsncfc", -30.913457795, -96.990444542],
    [0x87638e080183868b, "hxjsw201hf38", -49.833800583, 30.509239381],
    [0x45f1514e75666cb8, "8rsp2mmpdtqc", 43.492068992, -163.107030628],
    [0x420d8dca4992a53c, "886svkk9kbkm", 2.26477373, -153.747272578],
    [0x160f7c7346624f50, "2s7rswu6d97p", -19.737874728, -152.72598577],
    [0xa919d40d397f7631, "p4dx839tgxv3", -74.609872039, 138.528828512],
    [0x80f8817853e942c3, "h3w82y2mx51d", -81.483261803, 20.424229867],
    [0xa20e594d730c353f, "n875kmcm1hum", -87.989990461, 116.907283071],
    [0x4ef60436b44843ce, "9vv08epn911w", 32.449242373, -94.1871191],
    [0xfce99dbce6b8d812, "zmntvg76r3d1", 74.153989434, 155.648087717],
    [0x6bbf5e29aabe76ba, "efzpwbebrtvc", 16.789929895, -1.104139465],
    [0xbd9e2662d58f6725, "rqg2dsqpjxmk", -6.91877209, 150.93865867],
    [0x05b98a939fa49ec6, "0qwsp4wznkgd", -52.719414527, -159.292215099],
    [0xd5bf6b22e8a76536, "uqzqq8r8nxkm", 84.068795958, 21.74154147],
    [0xe5c8d0782838c8a4, "wr4e0y18734b", 39.935351107, 104.800787151],
    [0x834ff8fe4a7d66a7, "he7zjzkbgpmb", -70.448288042, 28.032782777],
    [0x8bb15909416cc291, "jfspk2b1em19", -74.658681513, 84.561909134],
    [0xe49e0b98ed5265bf, "wkg0r67eb9kv", 26.775706353, 105.792188188],
    [0x3c2d58587ea0dabc, "7hqphq3yn3ec", -19.827910668, -36.373055684],
    [0x591ce61a7f42eda2, "c4ffd6mz8cqu", 60.92185762, -131.025997764],
    [0xee51b4a8dcdd29c9, "xt8v9b6wvnnw", 31.906862147, 158.635248509],
    [0x567037c022a0f0a8, "bts3gh12n3sb", 76.267097929, -151.38961018],
    [0xf5453f8a917db424, "yp2mz2njgqu2", 86.793015538, 90.678551017],
    [0x37066a6d524f801c, "6w36nvbk9y01", -9.459796862, -65.445138013],
    [0x6e2c55148e3415cb, "esq5b54f6hbw", 24.582321977, -14.058636678],
    [0x2819bd5cdf855bbd, "50dvur6zhpev", -86.135689527, -40.942091477],
    [0x0e24ac22b8d452b2, "1skbs8psuj9c", -66.005014302, -105.612084761],
    [0x3fc4c574a383d8f3, "7z2dbx53hgdg", -3.696708404, -10.520231479],
    [0xf29f7a36a83251a4, "ybgrnep8698u", 50.465749977, 128.616365049],
    [0x2b82e8239d072542, "5f1fh8wx0wkn", -78.394454734, -8.582355278],
    [0xab40a1ab19418ab4, "pe0b3bst865c", -73.07735297, 158.63778742],
    [0x5ade11db5581982c, "ccg13quph6d2", 55.10177056, -96.970639609],
    [0xbd0f27ac64d6899c, "rn7kgc34uu4t", -9.00142813, 139.736688094],
    [0x5b81c949c2c9fc5c, "cf0wkkf2t7y5", 57.374831882, -100.356783924],
    [0x4b0b3e2005eaa485, "9d5mw805xbk8", 12.217399182, -107.643704297],
    [0x31cb1b019ebdbaef, "675jq0dyrqxf", -27.198293612, -74.263479755],
    [0x466b8c7169f7903b, "8tpsswc9yy83", 28.953429995, -146.75302087],
    [0x341f347205d6b165, "6hgm8wh5uusq", -17.280825131, -85.402012056],
    [0x80733d58ea1e8130, "h1tmuq7b3u0m", -80.517360293, 7.574805394],
    [0xd7e3c425a7b01974, "uzjw89e7q0dr", 85.526379713, 41.511071431],
    [0xf32bf810c8157d77, "ydpzh4682pyr", 57.492914195, 123.577660503],
    [0x09a7d86ebbb670be, "16mxhvpvqtsc", -76.084884438, -115.795956106],
    [0x80a86bf86a05b26a, "h2n6ry3b0qt6", -89.570124668, 20.382059959],
    [0xa54d2bd364fea117, "np6krnv4zuhj", -48.434106337, 93.478884255],
    [0xe151e166d2432d46, "w58y2tqk8dqn", 20.81575757, 91.085272853],
    [0xeb41239371b77389, "xe0k74vjqxts", 17.638118683, 157.990551457],
    [0x7f0fc0dea05b02b7, "gw7w1rp0cd1c", 81.249529434, -17.51351344],
    [0x18cd1d15ca8ec9d1, "336ju5fbjv4x", -36.93738038, -120.757692013],
    [0xb7cfdfe18eb79c12, "qz7xzsdfqyf1", -2.83130344, 129.005533852],
    [0x4dcc0e8a2f92fcb0, "9r60x2jgkcyc", 40.869708094, -120.610787137],
    [0xc06673144faca383, "s1m7652gpkjs", 7.620929039, 7.472051733],
    [0x040e763717c85e85, "0h77desrt1g8", -65.45799254, -175.313768452],
    [0x65d895a73338c6d5, "drd9c9tm733e", 42.504265499, -75.161105698],
    [0x95aea4bcd927b78c, "kqrb9g6t4yvs", -9.737111308, 22.228900656],
    [0x2d46694f0626f3a4, "5p36kms64vtu", -48.792656162, -43.049457696],
    [0x696283069b9f2f9b, "e5j861nvmwrt", 16.925374143, -37.168218242],
    [0xa1f872b27f3c8fdb, "n7w75dmz7k7x", -69.77152806, 110.200911993],
    [0xd0c94c7498c4cc3c, "u34nsx4ssm63", 51.8068312, 14.263872778],
    [0xab8c6644e9ab8155, "pf66dj79pf0p", -76.87527404, 172.007092259],
    [0x233dda2c1ff680e2, "4dyxnc0zyu0f", -73.293935889, -58.061423374],
    [0xee8d32787b080e04, "xu6m4y3v1070", 24.820348286, 172.037362334],
    [0xd7940cd83de9d7e4, "uyb0tq1xx7cy", 83.0909083, 33.983086377],
    [0xfd974794462fcfad, "zqcng5265z7u", 84.173509258, 147.788595447],
    [0x5076c422b9ad15ae, "b1vd88ptpnbu", 55.284098433, -172.233050973],
    [0x7639c0689bf84ce2, "fsww0u4vz16f", 71.390154255, -58.322335246],
    [0x5895e9e13ed30382, "c2byms9yud1s", 50.343272165, -122.451014785],
    [0x4f03d588b2d959d5, "9w1xc25kv5dx", 35.11314016, -110.331012172],
    [0x91c03f21f00ca935, "k703y8gh1knm", -27.812553866, 11.891388958],
    [0xb8f1b7f570fb91cb, "r3svgxchzf8w", -35.508355931, 153.085202974],
    [0x559bf78ab73cde25, "bqezg2pr7mg2", 82.926080212, -163.323639964],
    [0x746404b5222939ab, "fjk09e9254wu", 74.638380829, -84.307227354],
    [0xf5c3d258c7efb54f, "yr1x4q67xyun", 85.6404392, 103.461680128],
    [0x3d4b6486687e8bc2, "7p5q91m8gu5w", -4.475404192, -40.378023331],
    [0x6c56f345031fe3e9, "ejcg6j833zjy", 32.94550465, -42.450745553],
    [0x1449b8b91870248a, "2j4vjf8sf0k8", -15.981544084, -175.87934812],
    [0xd0dc6dbb1d240f7f, "u3f6vfsx4h7r", 55.342107079, 14.673018372],
    [0xc6876637d993e634, "su3qdeytkgm3", 25.070346399, 35.626813087],
    [0x950a1eb226c88258, "kn51xdj6t215", -10.974912135, 4.555776474],
    [0x519cda546b3288a4, "b6fenp3c6b4b", 61.036133875, -164.96817809],
    [0x0ab83fadcac8248d, "1bw3zcfbt0k8", -86.870182455, -92.116363979],
    [0x4aeded2274bb3ffc, "9cqyu8mnrdzz", 8.220235663, -91.552859688],
    [0x02c854cc8468cc15, "0c459m44e361", -83.731863629, -143.379679553],
    [0x485de64cc086d371, "91fydm60hv9r", 11.015197977, -131.03098342],
    [0x07fb645cb6d77420, "0zxq8r5quxu2", -46.630269403, -136.039039131],
    [0x10f1ba4fc5cb0bd8, "23svnmy5td5x", -35.65139531, -161.78717358],
    [0x2a5ec17c69cb569d, "59gd2z39tec9", -79.720638819, -17.542867783],
    [0xd8d591cd3be9705d, "v3bt3m9vx5s5", 55.797777541, 57.010765873],
    [0xc05525a028926a1c, "s1bkc818k9p1", 10.678759471, 0.419743143],
    [0xd45407b6b40e6b31, "ujb0gepn1tpm", 77.493123114, 0.163495748],
    [0xb10d296d1fe94b48, "q46kkv8zx55n", -31.565162688, 93.374137371],
    [0x5db85dac8aed17e4, "cqw5vc4bxncy", 82.227296016, -115.055735099],
    [0x4b8d80ae57960372, "9f6s1ckrks1r", 13.367508673, -97.651439301],
    [0xa9bea97ce41817cf, "p6zbkz7430cw", -74.447087855, 157.361342867],
    [0x213767fea37245fb, "44vqgzp3f92z", -73.305966079, -82.442327658],
    [0x7261b028120eb7a9, "f9hv0b0k1uvu", 51.504619093, -60.78692721],
    [0xf7239d4b45652485, "ywjtuku5dnk8", 79.787469192, 120.426727615],
    [0x0fdfc3f290c02967, "1zgw7wnhs0nq", -45.273884557, -96.165896522],
    [0xcd466b9f6f74e0ce, "tp36r7vgfmhd", 41.198028172, 47.084415295],
    [0x79a45d2d28d9dcbf, "g6k5uc98v7fc", 58.323818628, -27.913970526],
    [0xd9bbd5c34af8adf5, "v6xxchubz2qz", 60.451028612, 66.84766364],
    [0xb820865a2b56991a, "r0h8dqjcbudj", -44.878824992, 141.434933549],
    [0x1782dcc1da71bdcf, "2y1ethfuf6yw", -10.607841787, -143.917016359],
    [0x349b4898b04c430c, "6kenj65h9j1h", -18.621026109, -74.296372789],
    [0xc6415fb64dbc2133, "st0pzekerhhm", 29.50573773, 22.836075921],
    [0x1e5084b6f3da6493, "3t889ermv9k9", -13.955762594, -111.720758454],
    [0x137e0f4bb6483945, "2ez0ykxq90wn", -23.748575187, -147.371584399],
    [0x7344b497c37ed984, "fe2c95y3gvds", 63.565851912, -66.39261977],
    [0xbce3ee29b9e885ec, "rmjywbetx22y", -15.728728722, 154.637687195],
    [0x46a8d35655ba5f06, "8une6pkpr9gh", 23.112369206, -137.015665192],
    [0xa56f86eb26f7515f, "nprseut6yx8p", -48.402501516, 100.719158935],
    [0x04e57d452f491d4c, "0mkruj9g94fn", -59.075616214, -162.595207224],
    [0x1ec5be4381d206d2, "3v2vwhw1u83e", -14.476931609, -99.923205586],
    [0xff39d439e7837bfe, "zwwx8fg7hexz", 82.896500602, 166.678250995],
    [0x6c1a1ee5e17a27cb, "ehe1xtg1g8mw", 25.608060372, -40.447382387],
    [0x29e0fdc333e1833c, "57hgvhtmw61m", -72.440145265, -26.843106058],
    [0xd7780df679de16af, "uxw0vxmtvscb", 87.360174045, 31.186990998],
    [0x9432e05d92e25f17, "khtf0rdkw9gj", -19.293955941, 8.100296871],
    [0x7703a2fb58fc3745, "fw1u5yuszhvn", 79.49104587, -64.867780585],
    [0x419bf25ed431e3ea, "86ez4rqn67jy", 15.333884202, -163.369341271],
    [0x93be7f69ee226ad2, "kfz7yugf49pe", -28.845628555, 44.247210699],
    [0x3664d51ab3a48b26, "6tkeb6pmnk5k", -14.797703447, -61.150659575],
    [0x172a45b14a7df075, "2wp4cdbbgrs7", -10.751325753, -147.589156884],
    [0x6dba5d12faaf8383, "eqx5u4rupy1s", 37.234758862, -23.719490991],
    [0xe945c53657a6bef0, "x52wbekrnuzg", 19.486853845, 135.731234286],
    [0xb782ac45a0489d1c, "qy1bsje092fj", -11.131806177, 126.39089515],
    [0x37b7c34a49f3bef8, "6yvw6kk9yfzg", -5.908955538, -48.41026799],
    [0xb58a7458d4a5498b, "qq578q6nnp4s", -10.59936508, 105.834306553],
    [0xab855b83cd0ce038, "pf2pr0ye1mh3", -76.064674084, 169.066603168],
    [0xe7a4c5bf17c5a4e1, "wykdcgsrsqkf", 35.660195911, 130.161054551],
    [0x1b4f68df22bf536c, "3e7qjrt2rx9q", -25.622779531, -107.691441117],
    [0xd78d78bc8f0b35ed, "uy6rjg4g1duy", 81.403729134, 37.17059553],
    [0x99e5a18d69653c04, "m7ku33c9dny0", -25.961772847, 62.986772977],
    [0x275d14ffaa04553b, "4xfj9zxb0jbm", -45.398222642, -64.599952087],
    [0xf76d0bbc1b068dde, "yxqhrg0v0u6x", 86.54568219, 121.279142008],
    [0xe2e731e369fbf9d6, "wcmm3sv9zgwx", 7.980514539, 131.206624978],
    [0x27c9b8bd60a6a7fc, "4z4vjgc0numz", -49.725470315, -52.12845606],
    [0x0e36b858196092cf, "1svchq0td29d", -63.071562448, -104.226509411],
    [0x4bc0d6b4304bae04, "9g0eee1h9fr0", 17.507498507, -100.391608568],
    [0x2bdeead5f72ef019, "5ggfppgr5vs1", -68.510884113, -5.664315606],
    [0xfde39cbb6967dbcc, "zrjttfv9dzew", 85.3572019, 154.244736535],
    [0x8ffb5b3460b7471a, "jzxpqe30qx3j", -46.520150485, 88.881048369],
    [0xbfaea13c8685dafb, "ryrb2g46hreg", -9.782941071, 179.684674084],
    [0x9cd2e1d21b9a4c0c, "mm9f3nhvm960", -13.633125156, 58.761644861],
    [0xe5703d0af4464a6e, "wps3u2rn8t56", 42.497633522, 96.172969238],
    [0x29bfeed4c4b8b0a5, "56zyxp64r2sb", -73.348457372, -22.540881142],
    [0x518b4b7c477ede96, "b65nqz27gvg9", 57.389133099, -164.234110104],
    [0x46930354bc790140, "8u9h6p5wg40n", 26.099192935, -144.750924106],
    [0xeec52bfbecf58446, "xv2kryzdyq24", 30.315905191, 169.45270667],
    [0xc8e381e6e22bf97c, "t3js3tr25gwr", 6.400929465, 64.060418888],
    [0x54749f64e801463f, "bju9yt780533", 77.680224036, -173.381422018],
    [0x9416eb6751441cdb, "khcfqtuj8hfe", -17.853186305, 2.752078813],
    [0x7365ad806ed5123a, "fekuv03fun93", 64.118091336, -60.598009022],
    [0x371051f3600d02ef, "6w853wv01n1f", -7.829099429, -67.42717003],
    [0xa2782a7dc5fddf6d, "n9w2nzf5zrgq", -81.519241536, 121.58875567],
    [0x7606677d4392afe4, "fs36fzb3kbry", 69.432437496, -65.620780268],
    [0x0413228e34df8cc9, "0h9k53jnvy6d", -63.977689181, -178.092248465],
    [0x733ad069d424adbd, "fdxe0ufn4kqv", 59.616990033, -56.917313582],
    [0x11b09420956e3d77, "26s9884pesyr", -30.67251386, -162.396997092],
    [0xcea721cf8381b47d, "tumk3mw3h6u7", 24.683719761, 86.196515523],
    [0x18f8ffbd1ba8ac78, "33wgzg8vp2q7", -35.883234046, -113.915886635],
    [0x41cdd70f3411c57c, "876xf3tn272r", 19.652886019, -165.128620337],
    [0xd676c5ead65302e4, "utvdcuqqbd1f", 77.851664277, 30.319886241],
    [0xbeeaa4a7455c923b, "rvpb99u5ck93", -16.776828249, 179.719904228],
    [0xe34555e55fd99f83, "we2pctbzv6gs", 19.676486238, 112.567178074],
    [0x9c59bf48135a0323, "mjdvyk0mc81k", -13.028797352, 49.142255184],
    [0x9e23477686118853, "msjnfxn62645", -21.274626878, 74.649709863],
    [0x5d29fc715572c8d6, "cnnzswbpfc4e", 80.106774583, -125.309937082],
    [0x41ec62ad646e79f9, "87q65cc4etwz", 18.642885423, -159.794609785],
    [0xf387caff97d6d06c, "yf3wpzwruv86", 58.753496569, 126.208738663],
    [0xc52daf2fae5aba12, "snquycxfcbx1", 35.999925634, 9.799545958],
    [0xa4479e40c0d2fa59, "nj3twh60ucx5", -59.478469813, 92.376006936],
    [0x8cfe3c20c6ddbe9a, "jmz3s866vqz9", -57.390696353, 66.646391975],
    [0x9a7572ec58a45789, "m9ur5v2snjcs", -33.896223925, 73.642303748],
    [0x8c1bb16ee215e617, "jhev2vr22rm1", -63.73572722, 50.316370369],
    [0xc2b1923bc0bf476d, "sbst4fy0rx3q", 3.706595401, 40.207538122],
    [0x53f08f59ee1bee28, "bgs8yqgf3gr2", 64.856818483, -139.641981943],
    [0x21439eb1963e71ff, "451txddq7tsz", -72.143366492, -87.557788375],
    [0xabc2eefa8549f952, "pg1fxyn597wp", -72.651967117, 171.559815254],
    [0xf1d085aa91a8d923, "y788cbnjp3dk", 64.820203006, 102.038583303],
    [0x33d86fc0e6276244, "6gd6zh764xj4", -24.805374281, -52.773743089],
    [0xc75935e4f2d7ced8, "sxdmct7kuz7e", 43.227936106, 25.73465239],
    [0xb70e523245c27010, "qw754dk5s9s1", -9.303437581, 116.834304961],
    [0x2e8ec8815da0b364, "5u7dj0bxn2tq", -65.736862204, -6.107436455],
    [0xc9e68adc905aad86, "t7m8pr4hcbqs", 18.320519646, 64.305809041],
    [0x448ebdcb2512cd84, "8k7cvkt52c6s", 24.239151818, -163.238947584],
    [0x56a1100d2e72a5b0, "buhj039ffbkv", 68.387620263, -140.611485965],
    [0xb863f081780a67d6, "r1jz10cs19mx", -38.13971673, 143.132014591],
    [0x9e70cbc8ff95647c, "mtsdrk7zkpk7", -13.642362185, 74.152055888],
    [0xf42f37a7277cafe2, "yhrmg9t7gkry", 69.92589949, 100.356480852],
    [0x4f23b16698750d59, "9wjv2tnsfn6p", 34.701167523, -104.383074728],
    [0x355031cedb324efd, "6p833mqv697g", -2.563025741, -89.584123636],
    [0xe2fb3bec228ff341, "wcxmrv12jztn", 9.387858697, 134.287858814],
    [0xab272d165e6227c0, "pdmku5kyd8mw", -76.489818122, 165.06523157],
    [0x0b47dee4b350af9a, "1e3xxt5mb2rt", -70.371935572, -110.056550871],
    [0x3ff35bc77aeacf9a, "7ztprjvuxc7t", -1.505720221, -3.902898808],
    [0x64e3e503389c3955, "dmjyb0tsmhwp", 29.315025023, -70.656286744],
    [0x4ca139b994d6a607, "9khmmfdnuum0", 23.437766131, -117.517794679],
    [0x7995a7961c396d34, "g6bug5hw75qm", 61.321281677, -32.557159604],
    [0x7c42d93f2d0b899b, "gj1ekgte1f4t", 73.716041765, -42.674252887],
    [0x6514fcd5a5937464, "dnbgtpe5keu6", 38.625761573, -88.721267182],
    [0x6c47a5169ff10ab9, "ej3ub5nzy45c", 30.38403178, -42.529530094],
    [0x0f5b0a60bf6f7c34, "1xehns5zexy3", -47.086073027, -107.990296966],
    [0xc34b036a7f6c99a5, "se5h6umzekdu", 17.646728664, 26.847639244],
    [0x3d6e42993208fd45, "7pr4569k13yn", -3.852757405, -35.011649354],
    [0xa627508c7c00245f, "nsmp133w00k5", -64.855382842, 119.588247218],
    [0x088d261314461036, "126kd4sn8s83", -87.787861244, -120.492531756],
    [0x1c84968d64f98b2d, "3k29e3c4z65k", -20.819981469, -122.902363779],
    [0x291b6530dde5577e, "54eqbd6xwpcr", -74.737286642, -40.404022113],
    [0x750b39278d97d89a, "fn5mk9wekzd9", 79.681689613, -85.222799713],
    [0x22229a04789dfe22, "48j9n13smrz2", -89.816581147, -59.499658033],
    [0xac4ed700de768b62, "pj7ef06yfu5q", -59.807015822, 140.013664686],
    [0x203ba10157055e3b, "40xu20br0pg3", -86.43506636, -79.101214559],
    [0xdb0c98931a81e7d7, "vd69j4suh7mx", 57.84646956, 71.242064589],
    [0x88f33e1ae76f218c, "j3tmw6r7ewhs", -80.582709731, 63.917583516],
    [0x031a7db6848fbb4e, "0de7ven4jyxn", -75.261461531, -152.679492132],
    [0x4afc0fe6c16f4d6d, "9cy0ztq1ex6q", 10.004722567, -92.474516961],
    [0xa8a9c062c886813f, "p2nw0sq8hu0m", -88.921944126, 155.421728563],
    [0x5cdc729ff2a4348a, "cmf757zknhu8", 77.89240526, -120.432895035],
    [0xb34826ebac1433d3, "qe42euxd2htx", -28.011978528, 115.839164567],
    [0x09ad38f732472f7c, "16qmjxtk8wrr", -76.422837738, -114.711997115],
    [0x71d2211447ce8bea, "f7922527tu5y", 64.749921384, -76.991592111],
    [0x29082a5f514a5985, "5442nruj99ds", -78.706474974, -41.55571834],
    [0x5b80aaade3fb3d0b, "cf0bpcg3zdyh", 56.259928945, -99.84994293],
    [0x0d3d2a2f26b868fe, "1nyknct6r1ng", -51.319493029, -125.906787112],
    [0x447e0df297e7b7a5, "8jz0vwnrwyvu", 32.509869424, -169.905670283],
    [0x283ba59060147d79, "50xuc4302jyr", -86.340104428, -34.056235267],
    [0x68f02314f38a50f2, "e3s2657mj98g", 8.500164974, -27.680846555],
    [0x36f8ce21c835961a, "6vwdw8f86qc1", -13.618847693, -46.820199044],
    [0xd95c2b8394df48d5, "v5f2r0wnvx4e", 66.141638803, 48.480158825],
    [0xdb5ae42d89b8e465, "veef8cd9r3k6", 65.135414637, 72.810146623],
    [0x2d92ecf6d90a3efa, "5q9ftxqt18zg", -52.957358576, -31.038361831],
    [0x78a47267398f483a, "g2k74tttjx43", 46.964702219, -27.655781752],
    [0x0f456bd6c398196b, "1x2qrpq3m0dq", -48.080073417, -111.832019324],
    [0x1fc8f1b423879df1, "3z4g3e13hyfz", -5.03702235, -97.31497032],
    [0x158c86920ba737dd, "2q68e4hcnwvx", -9.744663839, -165.095729391],
    [0x9471aa9e7c7adeeb, "kjsup7mwgcgf", -13.340353698, 7.006010334],
    [0x03c53bbac48cda87, "0g2mrfq4jme8", -70.783165838, -145.549391421],
    [0xafb87444da154c8f, "pyw78j6u2p68", -52.792657925, 177.542842714],
    [0xc18ce1db8a1517d6, "s66f3qwb2ncx", 13.087543764, 15.181391028],
    [0x8d57c8f3943e44b2, "jpcwjwwn7t2c", -45.314755704, 47.359465332],
    [0xfdcc135e1db91688, "zr616rhxr4c8", 86.040688012, 149.167859413],
    [0x43093bcfae2e64b9, "8d4mrmxf5tkc", 12.203435676, -154.006534156],
    [0x2ba246ccf9c9cc26, "5fj4em7tt762", -78.280746083, -4.070892745],
    [0x3e7a160ff1a0b79c, "7tx1d3zjn2vt", -13.788351803, -12.547484218],
    [0xa22e334703d97f55, "n8r36js3v5zp", -88.343489196, 122.789263639],
    [0xe7f84e406ee334b0, "wzw4wh3fwduc", 42.650743154, 132.453860477],
    [0x69abcdce1c7efec5, "e6pwvmhwgvzd", 12.465179307, -22.966061259],
    [0x312c121aa4dd9dc6, "64q146p4vqfw", -32.156473021, -81.453781235],
    [0xe1d71bd6cc8cae2d, "w7cjrpqdjkr2", 22.056793267, 102.973028851],
    [0x023bcb0e11000bb8, "08xwq3hj005v", -86.082514842, -146.672968425],
    [0x69627c903f3638d1, "e5j7t41z6swe", 17.502489974, -37.394941593],
    [0xb0c3bd2056fc8120, "q31vu82qzk0k", -38.361703644, 103.909346219],
    [0x1af99489b7af737f, "3cwt92erpxtr", -35.591713377, -92.049650998],
    [0x2bad80bb828e4293, "5fqs1fw2jt19", -76.626865056, -2.023649454],
    [0xeaa650c5acde8c83, "xbm51jedvu68", 1.964301067, 175.83025205],
    [0x809125b3da8930f1, "h28kcdyuj4sg", -86.336732257, 11.676971153],
    [0xf12295b32dfbc301, "y4j9cdtezg1h", 56.572010642, 97.808180063],
    [0xff77031eaa85d374, "zxvh67pbhr9r", 89.357341301, 164.640954088],
    [0x156e976908543acd, "2pr9fu88bhxd", -3.88626021, -169.331578519],
    [0x208c8fe4bd04c099, "4268zt5x0m09", -88.433219577, -74.899967],
    [0xb5d468f6cd3bd608, "qrb6jxqe7gc0", -1.014284011, 101.852350588],
    [0x9edccca76e085bd5, "mvfdt9vf11ex", -12.206831169, 82.515268288],
    [0xd683950342cea9f8, "uu1tb0u2tunz", 68.51497056, 35.865467482],
    [0x3eb078915e07d1e5, "7us7j4by0z8y", -19.143978708, -5.052647706],
    [0xdcd6128951cdcaff, "vmc152bjtr5g", 77.524633443, 57.799302873],
    [0x232ae81b518c3fd0, "4dpfh6ujjhzx", -78.382446322, -56.409077041],
    [0x29aaf07ea481d208, "56pg0zp4h790", -78.183841972, -22.808806514],
    [0x10d77424bdc677ab, "23cr895xstvu", -33.831078418, -166.96520716],
    [0xb5180b446e93ce80, "qnd0qj3fkg78", -8.364311901, 93.07878369],
    [0x655867b0d7a78f65, "dpd6gd6rny7q", 42.684494365, -86.678744961],
    [0x6047bb054bab6371, "d13vq1bcpejr", 7.963903582, -87.274031742],
    [0x4da1307f515fe927, "9qhm0zujcznk", 34.672503694, -117.73490171],
    [0x9f347e498fcedf5b, "mwu7wkdgtvgp", -6.390663498, 73.755248299],
    [0x7b842bab31ef4610, "gf22rbtjxx31", 57.703925124, -10.550671652],
    [0x11f5766b9eeb1de8, "27urduwyxdfy", -22.5620398, -162.642992435],
    [0x2fcb19585202da03, "5z5jkq2k0ce0", -49.66712141, -6.844102724],
    [0x002dc0a52972980f, "00qw1999fbd0", -87.530519531, -170.791276102],
    [0x10ef26b27cc06ebb, "23rkedmws1rc", -37.164252027, -158.393143428],
    [0xd642d9313d220f4a, "ut1ekd9x487n", 73.711225985, 24.809300406],
    [0x12de7720fc56052a, "2cg7f87wbs2k", -34.494514836, -141.564995652],
    [0xf157f3406f97f9af, "y5cz6h3gkzwu", 67.392108943, 92.551444551],
    [0x0d67dc6b4827093e, "1pmxsuu84w4m", -47.874264965, -127.050594337],
    [0x8562fa9dea47e677, "hpjgp7gb8zm7", -50.076931512, 8.409730244],
    [0xb68d065a368e8c09, "qu6hdqjqju60", -20.268722559, 126.668836378],
    [0x182d3b37b01c2b77, "30qmqexh3hpr", -42.650920041, -125.915627159],
    [0x975fe5eba7387095, "kxgycux771s9", -0.19444106, 27.860432979],
    [0x44dbc81754238673, "8mewh5un4f37", 32.013829478, -163.646730749],
    [0xa0c33095cd3b9273, "n31m15fe7f97", -83.474922499, 103.055353764],
    [0xa8d658e85288037e, "p3c5ju2kj01r", -79.604872362, 147.90949541],
    [0xd6d65521ccf5b1d0, "uvc5b8fdyqsx", 78.007557699, 35.181930172],
    [0xe7bb02522f5eef3d, "wyxh4njgcvrm", 37.299256855, 133.689622066],
    [0xd2018c1f1070c87e, "u80ss7shf347", 45.811063051, 23.395485607],
    [0x9c22025b2f0c3cff, "mhj04qtg1hyg", -22.463753298, 52.138075645],
    [0x0d12c63553af1f86, "1n9ddebmpwgs", -52.976552219, -132.78009171],
    [0xb4d8479a12a4f410, "qmd4g6hknmu1", -13.567397552, 104.211432382],
    [0xc92202c60e78d1dc, "t4j05jhfg38x", 11.277947207, 52.169749426],
    [0xf216beac4aae33e0, "y8ccxc2bpsty", 49.489313511, 115.302873267],
    [0x75e1d5b0e15dac10, "frhxcd71cqq1", 85.749998426, -72.351775434],
    [0x9732cc34f43a0040, "kwtdse7n7804", -7.979120847, 30.436398986],
    [0xd94d5a6c0bc6bb0e, "v56pnv0csuxh", 64.539466992, 48.11037433],
    [0x9c9073faf9ffe1be, "mk877yrtzzhv", -19.080853127, 56.776996334],
    [0x4ad43fecf5eae997, "9cb3zv7pxcnt", 10.18150011, -100.553400016],
    [0x1d808114155a85d5, "3q08250pcb2x", -11.188242178, -123.046799155],
    [0x6459225bf64c97f7, "djdk4qzq9kcz", 31.678846441, -86.727048049],
    [0x4347b108076acb52, "8e3v2207ec5p", 19.204708943, -155.027567767],
    [0x964e1f0c788743e1, "kt71y33shx1y", -15.153541094, 26.995663632],
    [0x76880e0e2fbdcbc0, "fu40w3jgrr5w", 67.593980277, -53.1546295],
    [0x1b13bddc551ab770, "3d9vvr2p3bvr", -29.885682621, -109.80826742],
    [0x32dabc3f473408f4, "6cecsgu76h4g", -36.277648786, -50.761896195],
    [0x11db6d27ce688cee, "27equ9yfe26f", -24.115932572, -163.972520428],
    [0x1780f1e5536bc07e, "2y0g3tbmeg07", -10.646164419, -145.128889654],
    [0xc49dee77a48896e8, "skfywxx4j2cf", 27.902874574, 15.412672962],
    [0x09e720a2c77aab9f, "17mk18q7gbpt", -71.01360699, -116.292515174],
    [0x860bd2d3c2f49563, "hs5x5ny2ykbq", -66.232297083, 27.562562685],
    [0xaea4e02d9e10e600, "pukf0cdy23m0", -65.732868147, 175.466440524],
    [0x4e69aaa60a5d515a, "9tnup9hbcp8p", 28.833788317, -102.671656341],
    [0x7a35a37df41edbed, "g8uu6zgn3vey", 50.009495887, -15.695262663],
    [0xbb9f4e670b887cdf, "rfgnwtscj1ye", -28.358277782, 173.261141262],
    [0x2556a137833ad7b4, "4pcb2ew37ccv", -46.342853725, -87.508343489],
    [0xd52d36ee671a81ef, "unqmevm73b0y", 81.15244503, 8.961143605],
    [0xfbf3028b2bb9d655, "zgth52tcr7c5", 65.393606921, 175.932281196],
    [0xbef13c68eaf22a02, "rvsmsu7by8p0", -13.072228396, 174.94074107],
    [0xd486a5cbd7e85c99, "uk3bckyrx1f9", 69.065475562, 13.77475614],
    [0xab1d322b63e744a9, "pdfm4bv3wx2b", -73.647927421, 160.792402017],
    [0x3afa863516935e7b, "7cx8de8qkeg7", -36.454289737, -0.592720644],
    [0x7d8574277af16efe, "gq2r89vuy5rg", 81.485055847, -33.368300205],
    [0x21a2c4752171e89a, "46jd8x91f7n9", -78.269031459, -70.992173509],
    [0x9aa5b43f4fd1a413, "mbkv8gugu6k1", -42.605697744, 85.469357513],
    [0xfc31b7d66c3d73c8, "zhsvgpmd7ptw", 71.363495109, 141.81921288],
    [0x06145e317ed82a19, "0sb5wdcyv0p1", -62.649750487, -157.21172806],
    [0xb9d87dd6d8cfa8df, "r7d7vpqstyne", -24.612689557, 149.642971222],
    [0x1337a109c185d388, "2dvu22f1hr9s", -28.779847229, -149.400144965],
    [0x4ff8ed2b50ef8340, "9zwfubuhxy1n", 42.67582399, -91.543245155],
    [0xa616434b1b8ebb7e, "nsc46ksvjuxr", -62.860139219, 114.011906892],
    [0x4f007b51783457a1, "9w07qncs6jcu", 34.359129056, -111.882617497],
    [0x85fc5c3991c13e7f, "hry5sfdjs4z7", -45.776323179, 19.899168466],
    [0x8463d866dda833a8, "hjjxhtqxp0tu", -60.614487143, 7.941363592],
    [0x52b010cad1cde926, "bbs11kqjtrnk", 48.012609678, -140.561594822],
    [0x6c582c62908fd7ee, "ejd2ssnhjzcy", 31.048092593, -41.629694411],
    [0x589963b9794b2c8b, "c2dq7fct9dq8", 48.927195298, -120.419009218],
    [0x737a178c314f041c, "fex1g31j9w21", 65.00158828, -57.511989875],
    [0x7f61641425699904, "gxhq8515e6dh", 85.534672619, -16.521921999],
    [0xf6c4f18af83c53d8, "yv2g32rs7j9x", 75.10467262, 124.870049778],
    [0x8f485ae113b731c6, "jx45ps8mqwsw", -50.071999823, 70.642718262],
    [0x17281cd6e7b4d43d, "2wn1tpr7qmb3", -10.945913626, -148.832548303],
    [0x68d4ba1f14d51575, "e3bcn7snunbr", 10.03995356, -32.414989136],
    [0xd763c9a80dfed500, "uxjwmb0ezvbh", 85.474308068, 30.488079803],
    [0xe57c2e3f806e3c7d, "wpy2wgw0esy7", 43.700978667, 99.094091921],
    [0x115555d40d2d87c2, "25bpcp0e5q3w", -22.504943628, -179.955226442],
    [0x972d656a5ac71fbd, "kwqqbukuswgv", -8.63307093, 31.328743003],
    [0xcbbdf4864ae865a5, "tfyz91kbx1ku", 16.794069164, 88.292962724],
    [0x9e689e78bf8a62d7, "mtn9wy5zj9je", -16.577161516, 76.942649215],
    [0xe86c364702fecb3d, "x1q3djs2zv5m", 7.325290839, 143.883126765],
    [0xfd92eff475cfc02b, "zq9fzx3ptz02", 82.087048962, 149.042147996],
    [0x7d167092ecbc2838, "gnc714rdrhn3", 83.508861272, -43.187633523],
    [0x1dd9e2021ec8e5cf, "3rdy40hyt3kw", -1.756688828, -119.788167125],
    [0x7d103a812def1ac2, "gn83p09exwed", 81.74166387, -44.338433674],
    [0xa32808634ae53df2, "ndn0hsubwnyz", -78.723784246, 121.142043692],
    [0x8f277e26e330ee4c, "jwmrw9r363r4", -53.518302437, 75.17851951],
    [0x00d7ae6976ed7ad9, "03cuwucqxpxe", -79.33798524, -165.99040432],
    [0x150bb7f7c99efe72, "2n5vgxy9mvz7", -10.196439858, -174.563570933],
    [0x3c03ac9209a3adc7, "7h1ut4h9nfqw", -21.697813172, -42.312857584],
    [0xb8aad6b9980ffadf, "r2peefds1zxe", -44.370305171, 156.965188566],
    [0xdd112dad4c37d9c6, "vn8kvcbd6zdw", 82.407501557, 45.605056149],
    [0xf2b77ccb88505b78, "ybvrtkw8b1er", 50.561966612, 131.372456316],
    [0xd6260103a7395966, "usm020x775dq", 68.953519701, 29.54133826],
    [0x6fa50262a5d89404, "eykh4sp5v2b0", 35.881995503, -5.505298329],
    [0x8bf71b5295766e0e, "jgvjqnnpftr0", -67.949080813, 86.053278583],
    [0xf2667eef5d6cec87, "y9m7xvuxemq8", 52.679385858, 120.229716806],
    [0x5c93f1070bb37a41, "ck9z21scqex4", 71.595387567, -121.282250961],
    [0x1d2085e31fbacb66, "3nh8csszrc5q", -11.092193795, -128.599096809],
    [0x3386f5bb3b6f18b4, "6f3gcftvewdc", -31.669858131, -53.704107837],
    [0x0bddbff2dcfac855, "1gfvzwqwzc45", -67.860010828, -97.043960961],
    [0xb1750ddc3ea8e96a, "q5uhvr1yp3nq", -23.031800546, 95.858435982],
    [0xb2c9552f211e99c3, "qc4pbct13udw", -38.004215766, 126.602404023],
    [0x2301e5d90c7eeb7e, "4d0ycq8dgvpr", -77.527270837, -66.3895233],
    [0x75893b955c61845e, "fq4mr5bwd625", 79.69457941, -75.277536837],
    [0x73ec57161a9bd8e4, "fgq5f5humgdf", 63.957657942, -47.717835722],
    [0x9ff4caaf90b0329e, "mzudpcwhq0t9", -1.045715236, 85.427206063],
    [0x9bc05f227ebf79b8, "mg05y8myrxwv", -27.463333049, 79.043872101],
    [0x11ea13ed9b38d2be, "27p17vdv739c", -27.874151478, -158.737536444],
    [0xcb6e04ebb7948448, "ter09uxrkk24", 18.395127561, 77.43079329],
    [0xe0178fdbb68a740d, "w0cszqxqj9u0", 5.090455987, 92.438176515],
    [0xb7306fa21d1577eb, "qws6z8hx2pvy", -7.95281439, 118.812340152],
    [0x417637ffaaa9857d, "85v3gzxbp62r", 21.442579326, -172.441437897],
    [0x9c73ffc9815573ee, "mjtzzkd1bpty", -12.675134311, 53.407295611],
    [0x30ab61438a717c58, "62pq2hwbf5y5", -43.876498576, -68.545323706],
    [0xac2ba4ed9b96149b, "phpu9vdvksb9", -66.677845024, 145.979312412],
    [0xb0d2c56c5b10a02f, "q39dbv2v22h2", -36.049361083, 103.393380636],
    [0x496b7cb4bc7cb6f5, "95prte5wgkvg", 18.211023728, -124.558034493],
    [0x4c24062e90c0e832, "9hk0dcnhs3n3", 24.000411826, -129.24571977],
    [0x4f40a095be38ba27, "9x0b15ey72x2", 39.395301782, -111.396068041],
    [0x65083d452ccb05b5, "dn43uj9dtd2v", 34.0882718, -86.657859251],
    [0xdb0cb09bb6128390, "vd6c16xq2b1t", 57.846837889, 71.43210976],
    [0x31952a5e77fa0efa, "66bknrmrz87g", -28.786967328, -78.116242369],
    [0x7b3efe410e5dbfd1, "gdzgwh8fcqzx", 61.10921313, -11.336796933],
    [0xb7b76bd74c22d11e, "qyvqrpud4c8j", -5.889692858, 131.44672777],
    [0x879a559a7f003266, "hye5c6mz00t6", -52.764755962, 38.03158524],
    [0xb89d625663c03a13, "r2fq4pm3s0x1", -39.686476671, 149.509344105],
    [0x8eeed3414fa361d1, "jvre6hbgnehx", -59.870836076, 89.38608058],
    [0x459e4972eb796a1e, "8qg4kwrcg5p1", 38.398906871, -164.322714632],
    [0xa349201f3b2102eb, "ne4k07tv441f", -72.401779484, 115.683033699],
    [0x7e5f4133bd3a7d6c, "gtgn2dxx79yq", 78.457370786, -18.248818826],
    [0x6a8952314ea6ec8a, "eb4p4dbfnvq8", 1.245946475, -8.326308058],
    [0x5c4f78215b167a21, "cj7rh8bv2tx2", 75.766769408, -130.230872362],
    [0x9022c450105429c3, "k0jd8n0hbhnw", -44.526749978, 7.734383835],
    [0xc97f523125a5dcd3, "t5zp4d95nrfe", 22.338508784, 54.955258313],
    [0xe9b0c198cc97fc27, "x6sd366dkzy2", 14.470795402, 152.636702197],
    [0x0d19a7b31a500852, "1ndugdsub045", -52.58799025, -130.972477957],
    [0x4929843e8d4078e9, "94ns8gne81wf", 12.058104376, -125.817480402],
    [0x4987fe6384c8b90f, "963zwsw4t2wh", 13.999761257, -120.994944539],
    [0xfd7211aaa6920328, "zpt13bp6k81k", 87.407613511, 142.118305639],
    [0xfd35b1bcb9bd392a, "znuv3g5trnwk", 83.909017834, 141.761707417],
    [0xde6020fc6ab57f1e, "vth21z3bqpzj", 73.16491089, 73.556137224],
    [0xcdd8f19b626ecc59, "trdg36v2ev65", 42.77400982, 60.17949276],
    [0xb57e2512ba93ab96, "qpz2b4pukfpt", -1.262686518, 100.206169559],
    [0x038bfc41d76e8ade, "0f5zshfreu5e", -77.404238563, -140.797525442],
    [0x2726a1743ed0a9ef, "4wmb2x1yu2ny", -54.76019269, -59.389494876],
    [0x15320615d65b074e, "2nt0d5fqcd3n", -8.327838097, -172.877703449],
    [0xfe33ba6f40de3c6d, "zstvnvu0vsy6", 71.223146672, 165.888306168],
    [0x8637b4adf406d3d8, "hsvv9cgn0v9x", -62.303779405, 30.666996084],
    [0x47efdfab7d439786, "8zrxzbvx8fcs", 42.148977528, -135.354961419],
    [0xe40ad70d34ff1201, "wh5ef39nzw90", 23.168613097, 95.02244847],
    [0xd091829bc528c13b, "u28s56y5530m", 48.531252467, 12.104327082],
    [0x886bb3eb872da4d1, "j1pv7uw75qke", -83.426880142, 56.071961041],
    [0x34948dcd28c578c8, "6kb8vm98spwd", -18.119075223, -77.813921566],
    [0xa10e46f290405774, "n474ewnh81cr", -76.870554768, 94.380800054],
    [0x21c5b4d91c77a9a0, "472v9q8wfynu", -70.715055947, -77.639567143],
    [0x87b907727e524482, "hywhfwmyb928", -52.56704134, 42.305281992],
    [0x002df37faffc310d, "00qz6zxgzhsh", -87.27746851, -170.376013912],
    [0x2d785c9baee078c5, "5pw5t6xfw1wd", -47.183095028, -36.32087786],
    [0x1a7f97ff26aa7094, "39ztgzt6p9s9", -34.103957421, -101.780792319],
    [0x1cfa1193df1e926b, "3mx134yz3u96", -13.82639817, -113.852957889],
    [0x3d37156ff4aeaa89, "7nvjbvznpup8", -5.987870618, -37.925835135],
    [0xe38d05b8515f821b, "wf6hcf2jcy11", 13.504590026, 126.639481045],
    [0x1ee83f1f724a5e4a, "3vn3y7vk99g4", -16.546001232, -92.179000852],
    [0xfc3307a4b6f3be99, "zhthg95qyfz9", 71.154127802, 142.189821772],
    [0x6bce328672c56c70, "eg7351mkspq7", 18.4647096, -6.540461659],
    [0x37c0972596504292, "6z09f9dqb119", -5.307978781, -55.433919666],
    [0x2194040c8188492c, "46b08341j14k", -74.437688414, -78.736049263],
    [0x719eab19bf29a642, "f6gbq6ez56m4", 60.527642267, -73.196608174],
    [0x7eb1ae110401e931, "gusuw48407nm", 71.117608842, -4.306621474],
    [0x7a9feb77438b0eeb, "gbgyqxu3jd7f", 50.36013897, -5.684840117],
    [0x95ad9887feeae51d, "kqqtj1zyxckj", -8.954107238, 20.621332705],
    [0x8be00eb9dea4dcc6, "jgh0xffynmfd", -73.02094191, 84.719624444],
    [0xc9db6fc44e3b2a91, "t7eqzj2f7dp9", 20.90325976, 61.129119957],
    [0x3a63bc32797ac52f, "79jvsdmtgc2k", -38.394848941, -14.208593892],
    [0x827f14c8c22cbcfc, "h9zj9k625kyg", -79.166081074, 32.401920322],
    [0x3b621fd9d71e32ac, "7ej1zqfr3stb", -27.779035167, -15.14698428],
    [0xd2fc09425904f9fd, "ucy0khkt0mwz", 54.911930374, 42.369481079],
    [0x2966568334f0e8fb, "55m5e0tny3ng", -71.099604415, -37.829770036],
    [0x23eeabdb8356d10d, "4grbrqw3bv8h", -71.638768387, -45.024343527],
    [0x008fdbc8b92466d1, "027xrk5t4jme", -87.296476236, -163.50462175],
    [0x7ce038584d69a039, "gmh3hq2ee6h3", 73.33572532, -27.585837921],
    [0x3d9abaf8391a1e60, "7qecpy1t38g6", -8.227854166, -28.1338576],
    [0x5e3d844c92cc836c, "csys8m4ktk1q", 72.538026493, -103.34507156],
    [0xa1485b3c258837cc, "n545qg15j0vw", -72.536711314, 93.110726285],
    [0x3153d2096d3b4484, "659x42ce7e28", -24.077335926, -87.789537193],
    [0x508ffab4ca6585c3, "b27zpe6bdq2w", 47.654691965, -163.143098756],
    [0x6755cc94aabc7f8c, "dxbwt55brjzs", 44.752882151, -66.571687898],
    [0x96f8b279de2e13fa, "kvwc4yfy5s9z", -13.848584596, 43.366966475],
    [0xced6f85b0c45c955, "tvcghqsd8r4p", 32.907267361, 81.403898299],
    [0x73548309eb49865e, "feb862gc9635", 66.142085335, -66.692792899],
    [0xd5017a43dcdef2c7, "un0rnhywvvtd", 80.007749987, 0.624415015],
    [0xca6c1ed1ae1ffc01, "t9q1xnef3zy0", 7.331055335, 76.250350186],
    [0x16f27e49154b7a61, "2vt7wk8p9ex6", -13.421239745, -138.592455125],
    [0xae82f7a4ced0907c, "pu1gg96fu287", -66.833478498, 171.368705553],
    [0x2bceb744fc966d65, "5g7cfj7wktqq", -71.381191499, -5.883663787],
    [0xbe003e0da30645fc, "rs03w3e30t2z", -22.227887256, 158.130706601],
    [0x986b4f927a8f0a1b, "m1pnz4mujw51", -38.175397875, 55.159503923],
    [0x85b3e6c778245fd8, "hqtyejvs4jgx", -52.262617487, 19.475417269],
    [0x979cbb377a25f032, "kyfcqevu4rs3", -6.79019702, 37.910830843],
    [0xf6aa3f604b0485b1, "yup3ys2c0k2v", 67.831158485, 134.231998802],
    [0xeec9c3b522a845eb, "xv4w7e92p12y", 29.242866676, 172.421451883],
    [0x2303cc52fe0d05c5, "4d1wsnry1n2w", -77.572024966, -65.204157126],
    [0xbeae20c00c8085e3, "rur21h0dh22y", -21.071431611, 178.990127939],
    [0x35fcd60c72b5d567, "6ryed33kqrbq", -0.783376876, -69.50851271],
    [0x840567e71c4f8667, "hh2qgtsw9y36", -64.875864358, 0.51162779],
    [0x5c53d7b15d305369, "cj9xgdbx619q", 77.316164559, -132.736042029],
    [0x233884b9d777c85f, "4dw89ffrfz45", -75.833134609, -58.279259814],
    [0x9781483e27e0788c, "ky0nhgj7w1w8", -10.178224026, 33.96621641],
    [0xfd0d8899656061ce, "zn6sj6c5d1hw", 80.875088491, 138.747803329],
    [0x900201724e0e9363, "k0102wkf1u9q", -44.921353874, 1.434822654],
    [0xa6cdb5ae7b07c4b6, "nv6vccmv0z2c", -59.450243873, 127.702021542],
    [0xee5bd4c8b2e351ce, "xtex9k5kwe8w", 32.278624413, 162.481549753],
    [0x3752e178b007b6e2, "6x9f2y5h0yvf", -2.383310002, -65.001943605],
    [0x34919ec8b0b72ef6, "6k8txk5hqwrg", -18.697966755, -77.723862176],
    [0x6b2628b250a2a7fd, "edm2jdkhnbmz", 12.669298909, -14.869697478],
    [0xbaae15884049579d, "rbr1c22095ct", -43.284652576, 178.648726813],
    [0x7ac36092a4d24eab, "gc1q14p4u97b", 51.691152681, -9.43843075],
    [0x07825a0b1271db5c, "0y15n2skf7ep", -55.719074238, -144.563154534],
    [0x952a88aad2dab839, "knp8jbqkvbw3", -11.247808397, 10.808398972],
    [0x7e5d37a3564017b0, "gtfmg8uq80cv", 78.359732733, -19.176290035],
    [0x4ee2d5f1fe0297ec, "9vjecwgy0bcy", 28.822293635, -93.444522437],
    [0x0f569efb242129c2, "1xc9xyt444nw", -46.106517498, -110.043087712],
    [0x90614c536be6bb17, "k1hnsnvcwuxj", -38.195060399, 5.808976876],
    [0x211099a1bc684053, "4489m8ewe105", -75.713905134, -89.050240359],
    [0xea1889bdbe9fb868, "x8d8mgeymyw6", 2.876779483, 161.273715701],
    [0xa57f07ba17825193, "npzhgfhrh98t", -45.559092141, 100.014575357],
    [0x95773167eb41bed3, "kpvm2tzc86ze", -0.451539929, 7.415449106],
    [0x2e29770626d3752b, "5snrf1j6ueuk", -66.131709223, -13.615638022],
    [0xb8faa083b7992412, "r3xb10xrm4k1", -36.558496623, 157.202559225],
    [0x9c4db2392c3211a0, "mj6v4f9d688u", -14.575721208, 48.990205419],
    [0x2d4f156335e379f1, "5p7jbstpwewz", -48.181981108, -40.752122861],
    [0xc667b318be384feb, "stmv665y717y", 30.466168544, 30.690098355],
    [0xa90f95f582e62c97, "p47tcxd2wsq9", -76.291700155, 139.991170682],
    [0x725232c80096dbd3, "f9935k00kvex", 53.635327542, -65.599156542],
    [0x5a705bde0a6f602b, "c9s5rrhbexh2", 54.047364636, -106.54971714],
    [0x938d7ff13fe8162b, "kf6rzw9zx0c2", -30.94444821, 37.246357981],
    [0xa6d07b81f6b8cda9, "nv87r0gqr36u", -58.486010735, 124.413957929],
    [0xf4438c8704dd47b3, "yj1st1s4vp3v", 73.924767225, 92.334811765],
    [0xb5958160bd51a311, "qqbs2s5xb6jj", -6.260865006, 101.979921673],
    [0x19d6c8baab73966e, "37cdjfpcffc6", -23.543385585, -121.377176462],
    [0xc40cebe3aaec3d24, "sh6frsxbxhyk", 24.326589129, 4.207729195],
    [0x8f0d259ddcaa3e9a, "jw6kc7fwp8z9", -53.987155532, 70.722759587],
    [0xe16816a9c7bf36eb, "w5n1ebf7rwvf", 17.143386253, 98.605714689],
    [0x4594222b0146ce53, "8qb24bs18v75", 37.971782816, -168.272058409],
    [0x362d6da794ae4002, "6sqqv9wnpt00", -19.897930015, -58.460676543],
    [0xfa729c2473122e3c, "z9t9s93m28r3", 53.708941152, 165.433876945],
    [0x9643c4346a5ccaf2, "kt1w8e3bcm5g", -15.714412988, 24.633809738],
    [0x0b66da548af56066, "1emenp4byph6", -71.152787373, -104.497913216],
    [0xa6e09a32032096a1, "nvh9ndh342cb", -61.688056682, 130.369704935],
    [0xe18feab374c01b02, "w67ypdvns0eh", 13.727162866, 106.860069641],
    [0x1c536148e6354951, "3j9q2k766p4p", -12.940096203, -133.226649463],
    [0x1ef4469cf8e135f4, "3vu4e77sw4uz", -12.198155577, -95.477107273],
    [0x165e6287e8c03e2f, "2tg651z8s0z2", -12.294984465, -152.787370205],
    [0x36e10538e53ba3f1, "6vhhbf757fjz", -16.027109599, -50.587752426],
    [0x22a13f05070e015f, "4bhmy1871s0p", -88.980480293, -50.009357661],
    [0xde67878824d6d940, "vtmsg214uvdn", 75.366713519, 75.378777094],
    [0x6839e1cfd983b40e, "e0wy3mythfu0", 3.943591672, -35.443744921],
    [0x9fe3f048e5cd282c, "mzjz0k75tnn2", -4.370552215, 86.851266867],
    [0xa567f0b92c5f0c47, "npmz1f9dcw64", -47.974042245, 98.164968881],
    [0x2a876bee82e825bd, "5b3qrvn2x0kv", -87.467563195, -9.142721292],
    [0x7893ba1a50f823d3, "g29vn6khz0jx", 48.704582496, -31.008603183],
    [0x596f2ef8566c5bbd, "c5rkxy2qejev", 64.107744187, -124.463633992],
    [0x57ec469153ca3e5f, "bzq4e4bmt8z5", 86.236758153, -137.68007502],
    [0x76712c440d137241, "ftsksj0e2et4", 76.756558505, -61.346941374],
    [0x8adc0ef45f7e7d41, "jcf0xx2zgtyn", -80.027171662, 81.893278081],
    [0xb285f2bbe3d3d555, "qb2z5fz3ugbp", -42.347853206, 124.979642702],
    [0xfec2c680ae5764e6, "zv1de05fbxkf", 73.564964516, 170.996388751],
    [0xc13456d3f5040264, "s4u5enzp0h16", 16.122286777, 5.766450658],
    [0x564851b847bbc067, "bt453f27rg06", 73.709223149, -154.609919366],
    [0x27e818e39e5fa3da, "4zn1jswycyjx", -50.423307434, -47.561448288],
    [0xfc4aa1fd59bdbb3e, "zj5b3zbtrqxm", 73.212454351, 140.351349597],
    [0xcfaa390b26fa93bd, "typ3k2t6zb9v", 33.972948884, 89.139625044],
    [0xdf1b0e1c9627583f, "vwehw74q4xd3", 82.371065629, 71.996608734],
    [0xf28ed76a181b8853, "yb7efuhs3f45", 47.08814318, 128.798982292],
    [0xa3171eddab4baaf1, "ndcjxrec9fpg", -73.522985604, 114.230088909],
    [0x9f89b1961293d04d, "my4v35hkkg84", -10.309920118, 82.667173383],
    [0xe889bdbbbab7d7df, "x24vvfxuqzcx", 1.025247544, 150.380808049],
    [0x8cbf776ea300054a, "jkzrfvp3002n", -61.891305453, 66.576118754],
    [0xc7628223d07a5b34, "sxj848yhg9em", 39.379944261, 30.352632667],
    [0xe5adb376de083567, "wqqv6xqy10uq", 36.119962148, 110.861369238],
    [0x29a9fd36ce558ce3, "56nzueqfbq6f", -77.369336537, -24.050774318],
    [0xe76c1289153c7499, "wxq1528p7ju9", 40.961053433, 121.08045724],
    [0x13d0100c9d0f8376, "2g81034x1y1r", -25.129990494, -146.235503559],
    [0x303f361600cbc8a3, "60zmd5h0tg4b", -39.797871638, -79.711053161],
    [0x7849fa4fdf280f56, "g14znmyz507p", 51.8882587, -40.848751659],
    [0xc7b587c6bd8093ca, "syusgjpxh29w", 38.832382085, 40.220445328],
    [0x9778779997ba3595, "kxw7g6drr8ut", -2.138337855, 31.435302622],
    [0x376abf13e36a219a, "6xpcy4z3e8ht", -5.302018265, -56.327777733],
    [0xe03c2831d3f51c57, "w0y2hdfmynf5", 4.234880126, 98.99016663],
    [0x3d4f7d5693f2671f, "7p7rupnmy9mj", -2.816998407, -40.24503724],
    [0x63491ac18cc0049d, "de4jphdds029", 17.77905629, -64.376277058],
    [0xc3db8f5cfba34e46, "sgesyr7vne74", 20.563162548, 38.951966152],
    [0x8f2d0736eff9770a, "jwqhfergz5vh", -53.99027176, 76.058313667],
    [0x3fbde5a87b682931, "7yyycb3ve0nm", -5.842408212, -1.67836775],
    [0xda490424ac3e88d8, "v94h895d7u4e", 51.421917018, 70.339443683],
    [0x92ac04d3955fdea4, "kbq09nwpczgb", -43.468781742, 42.23976524],
    [0xf157f2121291f2b2, "y5cz44hkk7tc", 67.335953622, 92.554854864],
    [0x94509e20a644e8bd, "kj89w8568mnc", -13.798371835, 0.993252723],
    [0x447c722816f678cc, "8jy74b0qytwd", 32.872282406, -171.089456692],
    [0x0e15089e431c1ab4, "1sbhj7k33hec", -62.56003324, -112.263402618],
    [0xea1715be397c4e50, "x8cjcgjtgj75", 5.246987415, 158.990840212],
    [0x79800e607ccc583a, "g600ws3wtjd3", 56.362382075, -33.462077614],
    [0xd57857546ed68799, "upw5fp3fuu3t", 87.887000896, 8.527999921],
    [0xeb03904942cb7689, "xd1t0kb2tev8", 12.155104798, 159.620948229],
    [0xd0edc8428cecced9, "u3qwhhndxm7e", 53.108368037, 20.575648647],
    [0xc59370d9623f7ef8, "sq9r1qc27xzg", 37.830132637, 13.064621556],
    [0x653cbcfaf2c2ef8e, "dnyctyrkscrs", 38.267534119, -80.244956371],
    [0xd9e675b84c8104b6, "v7m7cf2dh42c", 63.953144976, 63.710576225],
    [0x4dc60fe87cfa00c1, "9r30zu3wz80d", 40.937590984, -122.000791352],
    [0xfbb9c512b2b2de32, "zfwwb4pkqcg3", 60.260748923, 177.900875515],
    [0xdbbfdcb42c6f43c5, "vfzxte1dex1w", 61.804056734, 89.540786447],
    [0x64fb209211565c1b, "dmxk14hjbtf1", 31.652629444, -68.505224601],
    [0xac094348a22bfc3f, "ph4n6k525gy3", -66.379374081, 137.916009753],
    [0x9b43d3f3de631f34, "me1x7wyyddgm", -26.812375602, 69.772564993],
    [0xaf39a9a15599d3b2, "pwwum8bpm79v", -52.685045619, 167.234114485],
    [0xe00088d4f9ffbe6c, "w008jp7tzyz6", 0.040849143, 90.928000599],
    [0xad21b5813afd381c, "pnhvc09uznw1", -55.235660699, 141.726344694],
    [0xe6f6f1b71d327886, "wvvg3esx69w8", 32.935517817, 131.908151434],
    [0xb347dc0895465ae4, "qe3xs24p8tef", -25.399073209, 114.798915711],
    [0xb6434a27ad0a00f8, "qt1nn9xe180g", -15.811557254, 114.202259776],
    [0xd19b8dab5d2e5c22, "u6esvbux5tf2", 59.902813309, 16.430893724],
    [0x3e83499480851f0c, "7u1nm540hngh", -21.384850719, -9.621100955],
    [0xae1c26b9945e8a80, "psf2efdncu58", -63.178446268, 160.831683837],
    [0xb190e573ef63ee7b, "q68fbwzgdgr7", -30.416403874, 102.337431219],
    [0xd4298d904a52994e, "uhnsv42bbbdn", 68.347453097, 9.361416699],
    [0xa4c62768f770ddaa, "nm32fu7rf3fu", -60.312227647, 103.13322582],
    [0x4e3e08ebe805628a, "9sz0juz80pj8", 26.744880108, -102.393257134],
    [0xcb160f2a1d077369, "tdc0ybhx0xtq", 15.601828854, 69.209089413],
    [0x870858b28d08ea56, "hw45jdne13p5", -55.711148984, 25.563188805],
    [0x458965aa91b6fe65, "8q4qcbnjqvz6", 34.937455996, -165.500493992],
    [0x6b7e528006d542d5, "eez55006up1e", 21.621604002, -12.523897015],
    [0x8fe274e961d59f8e, "jzj79uc1uqgs", -49.983335683, 86.211277493],
    [0xc3bdd59c2adc9eaf, "sfyxc71bvkgb", 16.847688573, 42.948190526],
    [0xd16060caaf52ca5f, "u5h61kpgbc55", 62.249184891, 6.042173661],
    [0x14cfb52e454180d2, "2m7vbck5860e", -14.450529296, -163.438098843],
    [0xf66cd461b78c3fb8, "ytqe8serjhzv", 75.172431564, 121.667286024],
    [0x351970f7a76318c5, "6ndr1xx7dddd", -7.165217815, -86.759952522],
    [0xe96fcb71ef7888d9, "x5rwqwggg24e", 19.41760595, 145.83781244],
    [0xb4519ad1396c31d1, "qj8tpn9tehsx", -13.146918666, 91.012936912],
    [0xf4c49b14d62906f7, "ym29q56q543g", 74.769872027, 102.220018036],
    [0xded972195086b4c6, "vvdr46bhhuud", 77.183787525, 82.013149503],
    [0x12f457e1516b482b, "2cu5gsbjee42", -34.470017496, -140.47103785],
    [0x282b571a6902b78d, "50ppf6m90bvs", -88.625159191, -35.049780201],
    [0xe88f954dff8f9bef, "x27tbmgzjyey", 2.44981553, 151.188263269],
    [0xc3730bcb6fe1913d, "sethrkvgw68m", 20.46127807, 29.858018685],
    [0xa77e961b83204fcd, "nxz9d6w3417w", -46.128665679, 123.154425789],
    [0x7f3ad3e1b051274b, "gwxe7sehb4mn", 82.159336833, -11.795189567],
    [0x3d962390b227f3c4, "7qc2745k4ztw", -6.975590384, -31.855762954],
    [0xc2e55e88ac541957, "sckpx25dbhdp", 8.350106894, 39.698412847],
    [0x45f099d5ace6a6d7, "8rs9mpedwume", 42.448877885, -162.19704475],
    [0x1f3bba917b398eff, "3wxvp4cv767g", -7.54257361, -101.29139729],
    [0x62292186366cbd9a, "d8nk31jqekyt", 0.753705608, -58.659633919],
    [0x813999a53cd5d2e0, "h4wtm99wur9f", -75.0052094, 9.384568902],
    [0x53525d3dddf5b1e4, "be95ugfxyqsy", 65.368645396, -155.881301903],
    [0x8f9c2cb7690d8994, "jyf2tev91q4t", -51.922555198, 82.163371822],
    [0x71944d11e394e8e4, "f6b4u4g3kmnf", 60.967496471, -78.569564088],
    [0x59bf68f5b809f57f, "c6zqjxes17ur", 61.565344328, -113.308122095],
    [0x399f8e32f40bd114, "76gswdrn1g8j", -28.726825074, -28.532792279],
    [0x2dd3f92adac33093, "5r9zkbqusds9", -46.535926521, -31.0708533],
    [0xabba934504a1ea64, "pfx96j84n7p6", -75.687201192, 179.385043644],
    [0xdb3595eaf0e1b739, "vdutcurhw6vm", 61.50362625, 73.914917802],
    [0x47641e0c4f8fed6d, "8xk1w32gjzqq", 41.052343372, -151.599056465],
    [0x0269001a47940b67, "09nh06k7kh5q", -83.658934869, -149.045501013],
    [0x3a4ede13c5830e0d, "797ew4y5hd70", -37.337882242, -17.306016063],
    [0x046a8609f36b641a, "0jp8d2gmeek1", -61.782027723, -169.349629017],
    [0x2ff959161ef8e5f3, "5zwpk5hyz3kz", -46.520439798, -2.629878009],
    [0x52855c5992dcd54b, "bb2psqdkvmbn", 47.761162236, -146.059916958],
    [0xb45ca59dd9fee387, "qjfbc7ftzvjs", -12.502800013, 93.925892423],
    [0x5b5e15703cf2a6ce, "ceg1bw1wybmd", 66.435486659, -108.256920075],
    [0xd6b6d48dce857ab5, "uuve93ffhpxc", 72.343981303, 41.54326527],
    [0x8b346c8ec8d39a89, "jdu6t3q8ufe8", -74.084788203, 73.716410528],
    [0x686e7978fa94cb55, "e1r7ky7ukm5p", 7.63762904, -34.590610987],
    [0x6e4eb55c4e89fe4c, "et7cbr2fj7z4", 29.879056491, -17.21431133],
    [0xfbdd64cdb67a7fa9, "zgfq9meqg9zu", 67.267709375, 171.973618148],
    [0x602d303f097220f1, "d0qm0gs9f8hg", 2.304683315, -81.171684975],
    [0x4c50066e43cce3f9, "9j80dvk3tmjz", 31.054515285, -134.873080682],
    [0x54ec139b21adbaab, "bmq176t1pqxb", 74.76491608, -160.162489478],
    [0x169279fd910210aa, "2u97mzdj088b", -19.074151204, -144.236732627],
    [0x8bfa6a26c90a5349, "jgx6n9q9199n", -69.953890259, 89.239949372],
    [0xc20fe8265b4dd9e9, "s87yh9kv9rdy", 2.468789402, 27.977772108],
    [0x513a8f6a6e5bd4d4, "b4x8yumfcgbe", 59.218174677, -169.148521927],
    [0x209a95f36341e5c9, "42e9cwv387kw", -86.842527975, -73.754980277],
    [0xbc8913ba69337360, "rk4j7fm96etq", -21.564554444, 149.234962391],
    [0xdf7750c837ba82f3, "vxvp1k1rrb1g", 89.847436527, 74.588233315],
    [0x189ea77171615f97, "32gbfwcjd5gt", -40.611369962, -118.365235245],
    [0x8e874de08ca8f154, "ju3nvs4dp3sp", -64.884901238, 80.401698979],
    [0xa44e965841a63b05, "nj79dq21nsxh", -60.170549227, 95.021040316],
    [0xb7047275e02eb6ae, "qw274xg05uvb", -9.273808632, 112.96571463],
    [0xf9b1e97ad7155863, "z6sykyqr2pd6", 60.19675025, 153.147013916],
    [0xd054059f331cc978, "u1b0c7tm3m4r", 54.995741231, 0.062198292],
    [0xe0e23dc26ac53770, "w3j3vhmbsnvr", 5.95608636, 108.860614201],
    [0xe88e5b45b9d7927b, "x275qjetuy97", 2.008773958, 150.737434233],
    [0x86fba39595ba973a, "hvxu75dprbcm", -58.294954172, 44.783354583],
    [0x1d0ac959aef17e25, "3n5dkqefy5z2", -10.818294293, -129.885940332],
    [0xd1ccdf98db806a61, "u76ez66vh1p6", 63.953653364, 15.088186513],
    [0x5af6719721898b63, "ccv735t1j65q", 55.434448586, -93.81614598],
    [0x5c5d7a9cf8e01144, "cjfrp77sw08n", 78.592847784, -131.512269949],
    [0xc1276ad0c1bf6beb, "s4mqpn61rxpy", 13.745522975, 7.693508861],
    [0x397f78058cda35f9, "75zrh1ddv8uz", -22.667064161, -34.625230411],
    [0x308cecd60f3853f5, "626ftphg719z", -43.115277464, -74.656431655],
    [0x272accf3a4d6d2dd, "4wpdtwx4uv9e", -55.77433909, -56.701606638],
    [0xbc772f1ddc1241e3, "rjvky7fw290y", -11.799610394, 142.660926551],
    [0xfc2bc1795a2bf9f9, "zhpw2ybu5gwz", 68.63641831, 145.581034144],
    [0xee0fcce4a9d559ea, "xs7wtt59updy", 25.076635603, 162.668556362],
    [0x8c486e3341f30eaa, "jj46wdu1yd7b", -61.420128193, 48.455484506],
    [0xa8ffe4bdc67d94b1, "p3zy9gf6gqbc", -78.99256399, 157.228572217],
    [0x48d49d50fbe8f406, "93b9un7vx3u0", 10.186653097, -122.865627276],
    [0x8be212b67eea84f8, "jgj15emyxb2g", -72.930248299, 85.943288809],
    [0x88dc34c0018b807f, "j3f39h01jf07", -79.870422433, 59.458255196],
    [0x031bda776f4162ed, "0dexnxvg85jf", -74.663841824, -152.284576166],
    [0xc431e380c9902e2e, "shsy7069k0r2", 26.412722146, 6.815138313],
    [0x39a8f4dca392b047, "76ng9r53kbs4", -33.096095743, -24.198208299],
    [0xa19b7700d9f52e24, "n6erf06tynr2", -74.572801351, 105.91190365],
    [0x211d12b9e9d8b74d, "44fj5fg9v2vn", -73.636931953, -87.017666324],
    [0xf68280f1965a60df, "yu181wdqc9he", 67.536870286, 125.928453579],
    [0x751008fb33e2bba2, "fn80jytmwbxu", 81.599153061, -89.739804477],
    [0x17b7b5047a5fdfd8, "2yvvb13uczgx", -6.012783217, -138.161579232],
    [0xab1487c0e1fd272b, "pdb8gh71znmk", -74.375733448, 158.339388541],
    [0x953540046157bec8, "knun0131byzd", -5.969359092, 5.626415731],
    [0xc6d06a5fb4eeea51, "sv86nrxnxvp5", 31.331404435, 34.386175783],
    [0x725ec87941783c44, "f9gdhyb1g0y4", 55.232696222, -62.369247961],
    [0x1b934d02e5ebcaae, "3f9nu0r5xg5b", -29.748986279, -99.658017811],
    [0xaa3406a704234efe, "p8u0e9s44e7g", -85.684758255, 163.284414406],
    [0xe55276cf5c43853a, "wp97emuw8f2m", 42.835448792, 91.906847394],
    [0x1e4bcfb5ffee59f3, "3t5wzegzxtdz", -15.666559001, -107.243059601],
    [0x49c0367440b9faa5, "9703dx20r7xb", 17.178559164, -123.288252655],
    [0xf56cdd0bcf0dff77, "ypqeu2yg1rzr", 86.445107453, 99.336725758],
    [0x8dfe003302d0c32c, "jrz00ds2u31k", -46.392382217, 66.121743397],
    [0xde7bdeb905670129, "vtxxxf85dw0k", 77.270226033, 78.38755902],
    [0x3bcbea91363a959e, "7g5yp49q7bbt", -27.055501732, -5.667066763],
    [0xe3a4f94f4b00fe16, "wfkgkmuc03z1", 13.259306093, 130.622998477],
    [0x237136eebacf6272, "4esmevputxj7", -69.317426741, -61.347756356],
    [0xf232d7e4aeabdff6, "y8tegt5fpggz", 48.499510218, 120.393671192],
    [0x93422aea486978ee, "ke12puk8e5wf", -28.101549014, 24.60470655],
    [0x3b638502696e90a6, "7ejsb0m9eu8b", -27.288384031, -14.757909865],
    [0x73353fea84eae0ab, "fdumzun4xchb", 61.501899444, -61.174282329],
    [0xb2b5a59d8c5a04ef, "qbuuc7ddc82f", -39.926589077, 130.488118082],
    [0xb31030b569a7e5b0, "qd831ec9nzkv", -30.740907984, 112.919836484],
    [0x9b8e85465945f10a, "mf78bjkt8rsh", -32.182089876, 83.678071201],
    [0x70cb9f6acd5adfa6, "f35tyuqeccgu", 51.659742038, -73.5224875],
    [0x1dda47d794f92bd4, "3re4gpwnz4px", -2.28673212, -119.390863793],
    [0x8e32e8ebcc898b80, "jstfjuydj65s", -64.309490235, 75.847779494],
    [0x4bf77a82a6cd9381, "9gvrp0p6tq9s", 22.3246835, -93.549386571],
    [0xdd24ea55dc18bbe8, "vnkfnpfw32xy", 80.551461123, 51.946856814],
    [0x42e0882e056553a5, "8ch8hch5dp9u", 5.63113503, -139.707553354],
    [0xe7e0a1ae7bf00d5f, "wzhb3cmvy06p", 39.426801478, 130.514748694],
    [0x66d30f5d11055981, "dv9hyr8j0pds", 31.81455895, -54.56908841],
    [0x26b24f59596ea886, "4ut4yqbteun8", -64.16605699, -48.943235413],
    [0x3954a33f66be3950, "75bb6gv6rswp", -23.841293767, -43.816923179],
    [0xadee5ca371e8680e, "prr5t8vjx1n0", -48.598446161, 156.342624437],
    [0xd7a915cadb1bcf43, "uynjckqv3g7n", 79.785007858, 42.251780647],
    [0x4d6265b78888d8dc, "9pj6cew8j3de", 39.877633156, -127.542114264],
    [0x35b0c469b8ba7e93, "6qsd8uesr9z9", -7.972588452, -72.383777448],
    [0x9783dba0470a11a7, "ky1xr827188u", -9.973694158, 36.18937368],
    [0x911d8ce8b2234294, "k4fstu5k4e19", -28.717558717, 3.772883096],
    [0xdc3ed8fc0951fd8a, "vhzejz09b7ys", 72.284867115, 55.800266955],
    [0x5260c432abfbfe59, "b9hd8dpczgz5", 51.075760537, -151.138917158],
    [0x4896fd94884b77f5, "92cgv5489evz", 4.894516445, -121.065830594],
    [0x7bbc4a1b6fc329c1, "gfy4n6vgsdnw", 60.836031307, -2.52974347],
    [0x6a6b743e067adb43, "e9pr8gh6gcen", 6.960320069, -12.265726987],
    [0x7dfada6eb45e11d1, "grxenvpncs8x", 87.743493677, -22.896815991],
    [0xab3ed6ff10dca241, "pdzeezshvkj4", -73.87397964, 168.217395144],
    [0x1fa876ef270d80ff, "3yn7evt71q0g", -10.60400541, -92.288877851],
    [0x0b675765f1ff0b6a, "1empftgjzw5q", -70.32383936, -105.354440331],
    [0xe64792444b649f07, "wt3t4j2cdkgh", 30.439279143, 114.698396286],
    [0x280e9e272f46ef0b, "5079w9tg8vrh", -88.321208681, -39.784542173],
    [0xe6ceed2c67ee068a, "wv7fuc37xs38", 30.022138534, 129.23421852],
    [0x9c26048c2c498339, "mhm0931d961m", -20.999925438, 52.088297111],
    [0xdad14643c16bb373, "vc8ndhy1eftr", 54.60644281, 78.84629849],
    [0x0035b437fcb586ff, "00uv8ezwqq3g", -84.792746684, -173.287769268],
    [0x03f31d2037e9721d, "0gtju81rx5t1", -69.300451248, -139.018972148],
    [0xbfb37917e4c30eb9, "rytrk5z4sd7c", -7.142045132, 176.318405108],
    [0xa6ca558c1a3939b8, "nv55c30u74wv", -61.209583324, 128.02484961],
    [0xcaafca045bae0ec7, "tbrwn12vps7d", 2.468685548, 89.561903532],
    [0x17f822c8c5040dc0, "2zw25k650h6w", -2.788615247, -137.315365241],
    [0x2458272521666731, "4jd2f991dtmm", -58.922137768, -86.724586598],
    [0x026c701dbb9f9d70, "09q707evmyfr", -82.421241554, -148.694551546],
    [0xc694390109dc58d8, "sub3k089vjde", 26.941553596, 34.278248559],
    [0x96937fb7a508a67d, "ku9rzex512m7", -18.305452269, 35.847076298],
    [0xfc944595f76a297b, "zkb4c5gre8nr", 72.224036506, 146.298567355],
    [0x21cf3fff58c9d077, "477mzzust787", -70.664643892, -73.832705764],
    [0x42985d625ec4b755, "8bd5uskyskvp", 3.496168237, -143.233033802],
    [0x0c6f4917d8644b58, "1jrnk5ysdj5p", -59.348717347, -124.971452303],
    [0xe9e3a784617e6222, "x7jug131gtj2", 17.71715465, 154.469304081],
    [0x365874a282292bfb, "6td798n254pz", -13.447253657, -64.261297057],
    [0x027cb45c8fd0bf6b, "09yc8r4gu2zq", -79.853477137, -147.9928572],
    [0xe8d3ed297774f457, "x39yubcrfmu5", 9.629505192, 148.921496401],
    [0xcdb2b6b79d50692b, "tqtceewxb1nk", 36.84673443, 64.498681184],
    [0xb339623154283591, "qdwq4dbn50ut", -29.866671403, 121.399060615],
    [0xa62730a1b2751928, "nsmm18ekfndk", -65.211246219, 119.953282711],
    [0x811686c8cf0f4a83, "h4c8ek6g1x58", -74.419460839, 2.256043048],
    [0x3e47cc120ee34f42, "7t3ws4hfwe7n", -14.314737922, -20.208037555],
    [0x690a1bc6fe1dc89d, "e451rjry3r49", 11.499676411, -40.46293257],
    [0xe0cc7e964ec14d44, "w367x5kfs56n", 7.664784842, 104.72837718],
    [0xeea284e36cc77d19, "xuj89svdsxyj", 22.614454794, 176.558047419],
    [0x04d7b0c39a0502b3, "0mcv1hwu0n1c", -56.751905452, -166.235845007],
    [0x1eafc04e38dbe770, "3urw0mjsvgmr", -20.01076268, -90.684331731],
    [0xa76831a41ac746b8, "nxn3390usx3c", -50.398968732, 121.356206082],
    [0xacaa32264d0e5e67, "pkp349ke1tg6", -67.316805963, 156.561424479],
    [0x642df9d353ee00c3, "dhqzmnumxs0d", 25.218708921, -80.281926831],
    [0x90179c1ad405311f, "k0cts6qn0nsj", -39.801027689, 2.304387989],
    [0xcb09417fe4a2e7e8, "td4n2zz4ncmy", 12.391555877, 70.355369631],
    [0x998907c7c04c7b97, "m64hgjy09jxt", -32.883337041, 59.202628796],
    [0x4ea071a00f473670, "9uh7380g8wv7", 23.071926622, -95.206461039],
    [0xde98137d6e64f4ed, "vud16zcfdmuf", 70.575259081, 81.685856025],
    [0x0daf9f63d4177f07, "1qrtysyn2xzh", -53.805800006, -112.909209726],
    [0x172e090ad847a29b, "2wr0k2qs8yj9", -9.797626486, -147.460516167],
    [0x1867d8b340e3364d, "31mxjdu0wdv4", -36.723074004, -127.018146751],
    [0x50503a66657d100c, "b183ntm5gn80", 53.642799062, -179.355797554],
    [0xa24cb0cb0be5007a, "n96c1kscwn07", -82.767959294, 116.428900363],
    [0x7a306349407aebb7, "g8s66kb0gcpv", 48.234235422, -16.424389057],
    [0x78db425d79dcee4c, "g3en4rctvmr4", 54.53577517, -29.430078222],
    [0xc5e27e2188c78ffa, "srj7w8d8sy7z", 39.993101504, 18.922099461],
    [0x056692866a6f3f8f, "0pm951mbewzs", -49.03597945, -172.12573205],
    [0xe39111b7cffc724d, "wf8j3eygzjt4", 15.006624636, 123.825495006],
    [0x952b8d5c3112d4ee, "knpsur1j2cbf", -10.375675863, 10.735049355],
    [0x2a448f8862267723, "5928z2324tvk", -82.835509174, -21.476440417],
    [0x84fbe0f283b84136, "hmxy1wn3r10m", -57.974632635, 22.223239414],
    [0xce410c03842f156b, "tt0hs0w45wbq", 28.9191428, 67.68417187],
    [0xb87a5e08fe867c88, "r1x5w27yhty8", -35.944831498, 145.123760093],
    [0xc38e14f3782c7981, "sf719wvs5jws", 12.957717599, 38.042358575],
    [0x8221448dd270c536, "h8hn93fkf32m", -88.846985802, 28.183118595],
    [0x3d89791d0fbfb162, "7q4rk78grysq", -9.95576607, -30.397801575],
    [0xd32fe800c682f195, "udryh066hcst", 58.712663165, 33.577518547],
    [0xffcc1884dbbd5d20, "zz61j16vrpfk", 85.964841207, 171.786306605],
    [0x5d9211ca2b51f0cc, "cq913kjcb7sd", 81.804518844, -122.280904977],
    [0x8db477caa1bc0d32, "jqu7gkp1rh6m", -51.349859422, 62.379301372],
    [0x3ca89668c6542534, "7kn9du66bhkm", -22.212486378, -24.485429746],
    [0xa92afadc128ec707, "p4pgpr0kjv3h", -78.183488486, 146.217632594],
    [0x46ebf7e29fc35044, "8vpzgsnzse84", 29.510584039, -135.188291002],
    [0x31f8060a193a44cd, "67w0d2ht792d", -25.223700947, -70.207292145],
    [0x1e7ee7d56ee7f83b, "3tzfgpcfwzw3", -12.129809921, -101.467024955],
    [0x700e55f3045a5cc8, "f075cws4c9fd", 47.101617072, -85.709770961],
    [0x22a7fd3e85422627, "4bmzugn588m2", -87.214363529, -47.947053915],
    [0x415f4f99af616be1, "85gnz6egd5py", 22.294624307, -175.457400397],
    [0x86cbba26179ea736, "hv5vn9hrmumm", -60.989332315, 39.315172474],
    [0xf972f5646c1780f5, "z5tgbt3d2y0g", 65.37593788, 143.110003356],
    [0x2031f31993130a88, "40sz66dm2d58", -85.898441043, -83.218319301],
    [0x58d0b2568de00408, "c38c4pnew020", 53.65233559, -122.598237755],
    [0x41b753382669d68a, "86vp6f16e7c8", 16.754599696, -161.59604201],
    [0x5134c98ef1e3d852, "b4udm3rjwgd5", 60.872087705, -173.431256587],
    [0x2bd4ab4ce500da72, "5gbbqm7503e7", -68.83294203, -9.916519183],
    [0x012c242bef6d27fe, "04q28bzgenmz", -77.251103901, -171.167198756],
    [0x52122ed71a53c161, "b892xpsubg0q", 47.942421926, -155.428014601],
    [0x33f9f95f44ada778, "6gwzkru4pqmr", -23.995135859, -46.565233408],
    [0xa2ea50bf7eb564b2, "ncp51gvyqpkc", -83.825944904, 133.678814727],
    [0x62a888ac24c8dece, "dbn8jc14t3gd", 0.00593214, -46.855085854],
    [0x46eea884bfa88c01, "8vrbj15zp260", 29.537946188, -135.126372271],
    [0x1cddcb26e077b8db, "3mfwq9r0fywe", -11.55058655, -119.938990409],
    [0xde650860a483ad48, "vtkhhs54hfqn", 75.256704079, 73.327085867],
    [0xe81525c82a0c94f9, "x0bkck1b1kbg", 5.075709632, 135.408952233],
    [0x1c2479c744beb0f0, "3hk7mju4rusg", -20.490464329, -128.797878805],
    [0x0e8f290f5c1b85fd, "1u7kk3uw3f2z", -65.335980361, -96.486663809],
    [0xa77838dde848f4d0, "nxw3jrg893ue", -47.59405098, 121.524641629],
    [0x5bf7d1b5c8dec5fb, "cgvx3ef8vv2z", 67.388921557, -93.446025738],
    [0xe20060be9d705162, "w8061gnxf18q", 0.369381452, 112.937479497],
    [0xb9d1ffff47d75c81, "r78zzzu7uxf8", -23.90693791, 147.651296665],
    [0x846095b502022c06, "hjh9ce8208q0", -61.548155295, 6.394415901],
    [0xd22a0d33f5fe3da2, "u8p0udzpzsyu", 45.148298694, 32.55144797],
    [0x21da597f1db4a6f2, "47e5kzsxqkmg", -69.698744334, -74.316053896],
    [0xaa3ae688121f3880, "p8xfe20k3ww8", -86.747282424, 168.54167625],
    [0x675177b400233848, "dx8rge004dw4", 43.566297951, -66.994513336],
    [0x48e7d36a0890f7c2, "93mx6uh8k3vw", 8.327690028, -115.888405728],
    [0x523f2c53a61d1e17, "b8zksnx63ng1", 50.04589396, -147.118902799],
    [0x27be993b16f62fc1, "4yz9kfsqysrw", -51.796607947, -45.488259269],
    [0xe056adbe9cd9c4ff, "w1cbvgnwv72g", 9.993242218, 92.72277602],
    [0x25a3bf5f1c49d793, "4qjvyrsw97ct", -55.196922282, -70.383168698],
    [0x30fe9ea72cb5ad96, "63z9x9tdqqqt", -34.883917686, -67.865705033],
    [0x58713a8ec6b5ba9c, "c1smp3q6qqx9", 54.323694092, -128.695972468],
    [0x22d77ea6eeb9787d, "4ccrx9rfr5w7", -78.830618488, -54.151645632],
    [0x841efa5014601060, "hhggnn0nd086", -62.719828421, 5.537195622],
    [0xb8da7329b342ac53, "r3e76bem8bq5", -35.987518315, 150.945665687],
    [0xf089c1762353afa7, "y24w2xj3bfru", 46.137398251, 104.794850127],
    [0x5e516c57ad927885, "ct8qspxek9w8", 77.121842947, -111.962154671],
    [0x328c8400f2571bcb, "6b68807kbwew", -43.503634767, -52.729885385],
    [0x364c98c8f6a94821, "6t69jk7qp542", -15.26857669, -63.748895455],
    [0x124fccbde86dc2d8, "297wtgg8er1e", -36.805448616, -152.320491216],
    [0x393a753d3ed56853, "74x7bg9yupn5", -30.257897398, -34.769145439],
    [0x8e3ea0f01c595fcd, "jszb1w0wc5gw", -63.247111019, 78.465089907],
    [0x2fd57cefaac057d8, "5zbrtvxbs1cx", -45.057581797, -10.634935083],
    [0xe9bb696131752e8c, "x6xqks9jfnr8", 15.186872736, 156.644535834],
    [0xecbcaeba8ae498f8, "xkybxfnbwkdg", 26.817737445, 156.092305466],
    [0x3c155f121c2752c7, "7hbpy4hw4x9d", -16.906888289, -44.730038924],
    [0xa74b3a69658e9a47, "nx5mnuc5jue4", -49.719461616, 117.368567548],
    [0x2eb3d0addc4e13f0, "5utx1cfw9s9z", -63.446277086, -3.435220692],
    [0x070d31e976cccdd6, "0w6m3ucqtm6x", -53.89366065, -154.25708783],
    [0x69c53c9adaa7d578, "e72mt6qunzbr", 19.261135906, -33.158164673],
    [0x8c9e89745024ff90, "jkg8kx2h4mzt", -63.196760889, 61.369735589],
    [0xd3d3c4910aa50466, "ug9w948bnn26", 65.84384501, 35.904608228],
    [0xbfa13e99374f7018, "ryhmx69r9xs1", -10.268142339, 175.046952554],
    [0x8f900a315b49c612, "jy80ndbv9731", -53.421432037, 79.036729611],
    [0x34177f81556887fa, "6hcrz0bpe23z", -16.913535434, -87.934428206],
    [0xb96530ec79edcb87, "r5km1v3txr5s", -25.810022128, 141.055842698],
    [0xac15498a6da94a09, "phbnm2mep550", -62.18071274, 135.238570644],
    [0xa03bbe9788c3e8a7, "n0xvx5w8sgnb", -86.20137497, 101.215194102],
    [0xe1fdea2600e5bdec, "w7yyn9h0wqyy", 22.1540538, 111.033602638],
    [0xde140bf195ab1efc, "vsb0rwdppdgg", 71.799617848, 67.832663565],
    [0x6c5f9dd867279249, "ejgtvq374y94", 33.389374719, -39.845575943],
    [0x8e0124e3ad7854da, "js0k9sxeg1be", -66.683611496, 67.927909894],
    [0xb88836dea0b4ae00, "r243erp0qkr0", -44.697810252, 149.566775454],
    [0x16343326c0620fe0, "2su369q0d87y", -18.054568787, -151.405222096],
    [0x3844e8b00ed5ea99, "712fjd0furp9", -37.605691329, -43.702390627],
    [0x4942d41b9c270b5f, "951e86ww4w5p", 17.505030752, -132.870600668],
    [0x43b72c38957ef253, "8fvksf4pgvt5", 16.272112381, -138.655532888],
    [0x575b75b8d1963742, "bxercf6jksvn", 88.563092037, -152.849836647],
    [0x32c764b0946cd74b, "6c3q9d4nemcn", -36.814037815, -54.423381836],
    [0x74dc2968c4082868, "fmf2ku6410n6", 77.41138494, -75.374399197],
    [0x11da6fb7d47731ac, "27e6zeynfwsu", -24.807307851, -163.841744053],
    [0x782235b7442c4ad1, "g0j3ceu45j5e", 45.32858727, -37.545642866],
    [0x868fe1662b779239, "hu7y2tjcfy93", -64.967315869, 39.053426462],
    [0xf7d0f43ce0badb15, "yz8g8g70rcej", 87.820639087, 124.842103003],
    [0xf54450ae06db9b09, "yp251ch6vfeh", 86.314573142, 90.082991776],
    [0x758c25bb9720f0b8, "fq62cfwr43sc", 80.303028705, -75.500347031],
    [0xafe68ca1dbf9a508, "pzm8t8fvz6kh", -49.125739707, 176.730167473],
    [0x19c9714b5e5c76c0, "374r2kuycjvd", -26.823303477, -120.568377723],
    [0x70e5c49c92a2e483, "f3kw974knck8", 53.191001039, -72.363557613],
    [0x575889ddce5cba2b, "bxd8mrffckx2", 87.274513595, -153.749821876],
    [0xe14284b8410b1e90, "w5189f211dg9", 16.975436856, 92.186348382],
    [0xe22f067b090ab0ae, "w8rhdys91bsb", 2.233145656, 122.470861163],
    [0xeaa5cb144772dab1, "xbkwq527fcec", 2.5233876, 175.342263303],
    [0x90cda0608e574a98, "k36u0s4fbx59", -37.243142527, 15.142963093],
    [0xd7dcb4d9f80dad46, "uzfc9qgs1qqn", 88.895222002, 37.676987516],
    [0xfd3db8724cc85dfa, "znyvhwkdt1fz", 83.882428258, 144.696339758],
    [0x5ff697798c39f84b, "czv9fydd77w4", 88.937478177, -93.391194356],
    [0x478be4d323c72d4f, "8y5y9nt3swqn", 34.92857587, -140.925205969],
    [0x03336d07530cad1a, "0dtqu1um1kqj", -74.740481553, -149.935507764],
    [0x6bfa184c6d6af3d2, "egx1hm3eectx", 19.892730426, -1.217254032],
    [0xb2e34ef21a469a57, "qcjnxwhu8ue5", -38.198665628, 131.117399298],
    [0x4f368c7535c7e42e, "9wv8sx9pszk2", 38.099165826, -104.566287959],
    [0xaac99b02add0327e, "pc4tq0peu0t7", -83.451501419, 172.539775562],
    [0xb2f6a2979f6d2d1a, "qcvb55wzenqj", -35.135702077, 131.977180207],
    [0xcb595e4ea7346be2, "tedpwmp76jpy", 21.033910957, 70.597210913],
    [0xa74c31ff669b79a6, "nx633zv6mewu", -48.956045635, 115.748421751],
    [0x06e225ce3e7126b6, "0vj2cmjyf4mc", -61.714527168, -138.804265797],
    [0xe6e9cf5792112303, "wvnwypwk24jh", 29.353463182, 133.162886757],
    [0x4ec8df68675f20f6, "9v4eyu37cwhg", 28.808202163, -97.435956698],
    [0xba2397034553c041, "r8jtf0u5bg04", -43.984477705, 165.327791032],
    [0x62c14b61a44c944d, "dc0nqse49kb4", 6.748807171, -55.960181705],
    [0xb1d7e9e4a599debe, "q7cymt55m7gc", -22.77957308, 103.956987248],
    [0x324075bef633b3e5, "6907cgrq6fty", -38.69688009, -67.061451084],
    [0xfdd315cb5560d714, "zr9jckupd3cj", 88.225632504, 147.716772759],
    [0x1232602ff5e020b7, "28t60czpw0hc", -41.825036675, -150.074351511],
    [0xec308a8020462c3d, "xhs8p0108sq3", 25.31260893, 141.637145514],
    [0x2fcfd850d63e9496, "5z7xhn6q7ub9", -47.952850341, -6.149092093],
    [0x139cba059e83aeef, "2ffcn1dyhfrf", -29.346186492, -142.115149518],
    [0x7943bc456c1925c6, "g51vsjcd34kw", 62.873781982, -42.361172273],
    [0x9e0f703ae1dfd68e, "ms7r0fr1vzc8", -19.850579553, 72.113133572],
    [0xd100c37c3a89ae0f, "u40d6z1uj6r0", 56.68465884, 0.826612856],
    [0x82c9203228cf0167, "hc4k0dj8tw0q", -83.660769518, 36.943824761],
    [0x4f8b8d57b4a8c93d, "9y5supxnp34m", 34.627195979, -96.142416326],
    [0x5d498d412eb63469, "cp4suh9fqsu6", 85.235092286, -131.305905595],
    [0x6e555070a879bfe6, "etbp0w58g6zy", 33.607322345, -22.473070841],
    [0xde25ef48c2aa1f3c, "vskyyk62p8gm", 70.116124342, 74.457762003],
    [0x2d0e0ae1e07ba06f, "5n70psg0gfh6", -54.817517502, -40.447373383],
    [0x6ea0d33906f1d08f, "euhe6f86y788", 23.085512954, -4.800412883],
    [0xd6f07ab15b41952e, "uvs7pdbv86bk", 76.480909601, 40.057193644],
    [0xa769e7c7e73708ed, "nxnygjz76w4f", -49.406300287, 122.134090966],
    [0xa423ab0a722cc1fd, "nhjuq2mk5m0z", -66.750841605, 98.36794619],
    [0xd8a722ff61a71987, "v2mk5zv1nwds", 47.152154375, 63.804756338],
    [0x4a3dc853e02934ec, "98ywhnz054uf", 5.310531561, -103.173845352],
    [0xeaab775a88210678, "xbprfqn84437", 1.395276272, 179.053203569],
    [0x7b315f4ffcf8bb26, "gdspymzwz2xk", 60.457552561, -16.589721158],
    [0x26487a4fd2093672, "4t47nmyk14v7", -61.315368642, -64.052646157],
    [0xdffbad61f2c431da, "vzxuusgkshsx", 88.049351284, 89.850832623],
    [0xbabba057ca4a455e, "rbxu0pyb992p", -41.44170915, 179.657771912],
    [0x162d4890d5ece06b, "2sqnj46pxmh6", -20.025388203, -148.839709697],
    [0xed53f76d02c8f62e, "xp9zfv82t3v2", 43.580112407, 137.582363069],
    [0xc29f42f0d044c3a1, "sbgn5w6h8m1u", 5.308569788, 38.125318285],
    [0x6ab82282dd840d54, "ebw250qxhh6p", 2.815098995, -2.320000801],
    [0x9bc064a55f2819a6, "mg0699bz50du", -27.674728737, 79.168643013],
    [0x6588473ef64e915a, "dq44fgrq9u8p", 34.252392345, -75.806618642],
    [0xbeb6cda5a6cd677e, "ruvdv9e6tpmr", -17.789142472, 176.730759361],
    [0x63eb3090768c7663, "dgpm143qjjv6", 17.767327067, -46.008803871],
    [0x7b4d843ef9a904dc, "ge6s8grtp42e", 64.090989409, -18.940815023],
    [0x407758b220c903dc, "81vpjdj0t41x", 11.085302914, -172.719967535],
    [0x1e582bc3d605e712, "3td2rhyq0rmj", -13.991392459, -109.019719688],
    [0xa08d4860eaf0a201, "n26nhs7by2j0", -87.515587729, 104.265678709],
    [0x8c04834ed1456500, "jh286mqj8pkh", -66.019981863, 45.810247132],
    [0x7ca269542a563bb0, "gkj6kp1bbsxv", 67.934113688, -26.188971064],
    [0x21be18e02dbd0c4b, "46z1js1ern64", -74.332904269, -68.662187492],
    [0xe076b8648b7a1686, "w1vcht4cg8c8", 10.047301615, 98.287620284],
    [0x78255e204dfc1862, "g0kpw82ezhd6", 47.726650892, -39.088365232],
    [0xcbc33da75ae5b3c6, "tg1mv9uuwqtw", 17.896163665, 80.756310551],
    [0x06c28447508ee2b6, "0v188juhjvjc", -61.754809958, -144.13487724],
    [0x99724199ded30f77, "m5t436fyud7r", -24.900713896, 52.090155799],
    [0xe1115f6de71021aa, "w48pyvg720hu", 15.456948976, 90.30110076],
    [0xbf4714ccc580ecea, "rx3j9m65h3qf", -3.222591988, 158.964119956],
    [0x9dbebd4c7eb16f1e, "mqzcum3yq5rj", -6.693702431, 67.337875543],
    [0x447f2cc94eb4f6ae, "8jzktkbfqmvb", 33.161275327, -169.572668425],
    [0xc5faa5bab350e6a6, "srxbcfpmb3mb", 42.331316122, 22.235316751],
    [0xbb8b91aeba251cee, "rf5t3cpu4nff", -32.820931994, 173.759512091],
    [0x24b24efb5484e759, "4kt4xyunhmmp", -64.209908638, -71.372491333],
    [0x5b7d2b99ed04526c, "ceykr6ge0j96", 66.856471433, -103.387525589],
    [0x61ecdace90c1de4a, "d7qepmnhs7g4", 18.836852509, -69.28234506],
    [0xa10956b455ea177b, "n44pee2px8cr", -77.412495122, 92.966632418],
    [0x53b8090c240802b8, "bfw0k314101c", 59.112281998, -137.624313635],
    [0x383ca01c1e6433d9, "70yb070ydhtx", -40.763629315, -35.495702768],
    [0x3556eba072d6b217, "6pcfr83kuut1", -1.008529055, -87.207545403],
    [0x80afe7d29c4d06ad, "h2rygnnw9n3b", -87.373118104, 22.289245324],
    [0x5156fbec41eb56c1, "b5cgrv21xecd", 66.694156161, -177.198162403],
    [0x3519ba53229232a6, "6ndvnnt2k8tb", -7.522842473, -85.861729905],
    [0x04ac5df2d60b573b, "0kq5vwqq1ecm", -65.399187035, -160.062151397],
    [0x14e30af62a3bc4d7, "2mjhpxjb7g2e", -16.13336185, -161.381102015],
    [0x022a436a83c8e478, "08p46un3t3k7", -89.582254813, -147.526586088],
    [0xdb20801c7009cb2e, "vdh8073h175k", 56.268556299, 73.84054291],
    [0x8019161d55ac9842, "h0djd7bppkd4", -86.198877632, 2.911690861],
    [0x1ed099a42f0c7987, "3v89m91g1jws", -13.836734965, -100.302720757],
    [0x4a21fb704ce7659f, "98hzqw2dwxkt", 1.309215382, -105.533696019],
    [0x909d089befd3158d, "k2fhj6zgudbs", -40.062359502, 14.304049929],
    [0x00ed552e308e1edc, "03qpbcjhjsge", -81.600239403, -160.272433617],
    [0xd89e6e44dc4a97a6, "v2g6wj6w9bcu", 49.688162851, 61.087495169],
    [0x3e11ae0ea95b01a8, "7s8uw3p9cd0u", -18.890679392, -21.160289011],
    [0x12834ce77db8c22e, "2b1nttvxr312", -43.824586153, -144.594184603],
    [0x2bac7f79f964109b, "5fq7yygtdh89", -76.646522945, -2.159413323],
    [0xd40d241c16542b75, "uh6k870qbhpr", 69.714926618, 3.175401902],
    [0xed1b9d95e40fb335, "xnetv5g41ytm", 37.594220748, 140.145803631],
    [0x6818413b09241bea, "e0d42fs94hey", 3.22193754, -42.148270084],
    [0x85dcd3569d514cec, "hrfe6pnxb56f", -45.79516054, 14.862445933],
    [0x5cefd421b177ac30, "cmrx88ejfyq3", 75.853376745, -113.176905991],
    [0x09c08389e36f00b0, "170872g3ew0c", -73.07664495, -122.899438322],
    [0x2d4a1949e39dea08, "5p51kkg3mrp0", -50.378928766, -40.589784317],
    [0x0d20a887c85a9304, "1nhbj1y8cb9h", -56.24025477, -128.091583042],
    [0x94bb903e5da68f26, "kkxt0gkxnu7k", -18.789515756, 21.836307943],
    [0x21a730d9f4ca6968, "46mm1qgnt9nq", -76.426642709, -71.307891386],
    [0x1be9e412db86455a, "3gny84qvht2p", -26.969174572, -91.748349394],
    [0xf43fa8fa8e5d78af, "yhzujynfcpwb", 72.455346447, 101.160445],
    [0xef2c1180e9b5d8a8, "xwq13079qrdb", 35.377604696, 165.986523934],
    [0xd6fc20530c9fdb1b, "uvy20nsdmzej", 77.379882958, 42.545493425],
    [0xcc9d558e8b4bb91b, "tkfpc3nc9fwj", 28.086819645, 59.126784809],
    [0x6668cfde8a580a32, "dtndzrnbc053", 28.646979512, -58.031454332],
    [0x07dcc74ccc0dd762, "0zfdfm6d1rcq", -45.893626543, -142.632009359],
    [0x5f7e991a8683505b, "cxz9k6n6he85", 88.824825553, -101.757580912],
    [0x7c09530cec1f1713, "gh4p637d3wcj", 68.781703879, -42.083750712],
    [0x608aadb1bc77c8ca, "d25bvdewfz4d", 0.14676545, -73.229935094],
    [0x3ad6f33cb08bcb46, "7ccg6g5hjg5n", -34.567777605, -8.663842106],
    [0xfbc058ce07b48bc7, "zg05jmh7qk5w", 62.430390085, 168.986822415],
    [0xaee6224454eab922, "pvm24j2nxbwk", -60.438791728, 176.221044252],
    [0x2dbae1bf669dc880, "5qxf3gv6mr48", -53.020969022, -22.767219738],
    [0x01dc4a48e62207ca, "07f4nk76483w", -68.530995879, -165.65826904],
    [0xa2eda63909ce645c, "ncqudf89ttk5", -82.163715212, 133.363965388],
    [0x8d8f58ccdcea6bba, "jq7pjm6wx9pv", -53.583320097, 60.703228656],
    [0x5c5964f05eff51b9, "cjdq9w2yzx8v", 77.115610264, -131.76866645],
    [0xedebefb0e4b04d58, "xrpyzd74q16p", 40.574277176, 157.482407588],
    [0x3e4cebfd1c2b69f1, "7t6frz8w5enz", -15.030996162, -18.291390414],
    [0x8a97ec33f722baa6, "jbcysdzr4bxb", -84.622361264, 81.418776344],
    [0x9c06bd7aacf9900a, "mh3cuypdz680", -20.752688327, 47.680288866],
    [0x291e21a83f96d977, "54g23b1zkvdr", -74.486029337, -40.350172959],
    [0x217c8c6ddb04890e, "45y8svfv0k4h", -68.785893156, -80.646844551],
    [0x05c69f6e68ae5996, "0r39yvm8ptdt", -48.882263258, -166.336115676],
    [0xbf5d97217854c7f3, "rxftf8csbm3z", -0.390543168, 161.127561431],
    [0xacf5b3fc2718cb55, "pmuv7z17335p", -56.694381703, 153.096256741],
    [0x29c375316e1b9626, "571rbdcf3fc2", -71.74718801, -31.967734668],
    [0x9fc9e55b5bf53c19, "mz4ybquvyny1", -4.400374232, 82.634962698],
    [0x3a6170e3a4e4e8ec, "79hr1sx4wmnf", -38.11935561, -16.44762903],
    [0x65fe6d62844a62ed, "drz6usn499jf", 44.099556093, -68.348621553],
    [0x9466d4adf4c9ce57, "kjme9cgnt775", -14.842768704, 7.815628587],
    [0xd17a1c3638a303d0, "u5x1sejsnd1x", 64.968349917, 10.04933804],
    [0x5f5e6eca9c6963fc, "cxg6xknwe5jz", 89.056308955, -107.602020925],
    [0x39187c24ed6dece2, "74d7s97eerqf", -30.314759097, -41.633228418],
    [0x4150cda0a92ba877, "858dv8595fn7", 20.171081487, -179.050199845],
    [0x3a18bdeae431e59d, "78dcvur467kt", -41.856132207, -18.370411088],
    [0xba3da47962756bd1, "r8yu8yc2fppx", -39.952987975, 167.026959034],
    [0xec6140df79678fb6, "xjhn1rvtdy7v", 29.223238109, 140.687607928],
    [0xc8d395cb297a4e70, "t39tckt9g977", 9.473269077, 58.42201434],
    [0xd3b35e9c4c9eb760, "uftpx72dmuvq", 60.399124897, 41.100794001],
    [0xf991c43ab3ca0973, "z68w8fpmt84r", 60.217009845, 146.996279559],
    [0xee4a9669dcb392b2, "xt59dufwqf9c", 28.415850869, 162.546450029],
    [0x5047d79266d14bfe, "b13xg4m6u55z", 53.40640374, -177.751402304],
    [0x5e4cd7a81ae80c01, "ct6egb0ux060", 75.191203575, -108.818247016],
    [0x16fece70049dbe8e, "2vzdww04mqz8", -12.183415345, -135.417244803],
    [0x176a4b3c54e1c466, "2xp4qg2nw726", -5.210505746, -147.359350473],
    [0x93010617b64efc75, "kd0hd5xq9vy7", -32.938611025, 22.597930485],
    [0x4148dc65fe5fef19, "854estgyczrj", 17.523018556, -176.281386549],
    [0x399e4bfd4ab0f30f, "76g4rzbbq3th", -29.093118388, -29.189368644],
    [0x8efe946e5377f367, "jvz98vkmfztq", -57.362710558, 89.335795622],
    [0x00d4ffcde887f00b, "03bgzmg8hzs0", -79.465444329, -167.371692994],
    [0xfc9fcbec14e0bd34, "zkgwrv0nw2ym", 72.845969388, 151.512727796],
    [0x99548bfab67aa3ba, "m5b8rypqgbjv", -23.828186131, 46.053826488],
    [0x0bb7fd22cb7553be, "1fvzu8qcfp9v", -73.167230434, -92.956950401],
    [0x8dda16072be30c99, "jre1d1tcwd69", -47.540318604, 60.564819543],
    [0xc22accb17f250f23, "s8pdtdcz4n7k", 0.455795223, 33.291067798],
    [0xbaec031ec9363851, "rcq067q96sw5", -37.906712619, 177.295418731],
    [0x3f157cb244411785, "7wbrtdk484cs", -5.700086296, -21.901243097],
    [0x074485b684c12175, "0x28cen4s4hr", -49.069993372, -156.722539895],
    [0xce663b029df47380, "ttm3q0nxyjts", 29.752337118, 75.155675696],
    [0x9ee2df05e62ffa7a, "mvjey1g65zx7", -16.205823193, 86.752680987],
    [0x00a903198e86ec61, "02nh66dfhvq6", -89.238824902, -160.209634241],
    [0x21a3941c8e214b5d, "46jt874f455p", -77.766362904, -71.000772052],
    [0x06ad9453be45b9d3, "0uqt8nxy8qwx", -65.090095664, -137.098712419],
    [0x3637c34d50c00560, "6svw6mbhs02q", -17.150256653, -59.666575996],
    [0x15475460df8fb859, "2p3p8s6zjyw5", -2.875807607, -178.56774576],
    [0xbe292e9dbb728ba1, "rsnkx7evfb5u", -21.688770533, 166.612938987],
    [0xca4ed8301900530c, "t97ehd0t019h", 7.570447222, 72.620317104],
    [0xbd0fdd3a2ca5a78c, "rn7xufjdnqms", -8.470081379, 140.13844415],
    [0x62a8bb671b3259da, "dbncqtsv69dx", 0.250849416, -46.465533912],
    [0x74005a20ab2d00c5, "fh05n85c5n0d", 68.027548088, -89.709076142],
    [0x468f21c50055c762, "8u7k3j80br3q", 24.683701386, -141.635729663],
    [0xf557441f5927e937, "ypcn87ut4znm", 89.757824317, 91.423542685],
    [0xcf390d3ecfa6f515, "twwhugqgnvuj", 37.415860549, 76.155805042],
    [0x1100be2cc2fb90ca, "240cwc62zf8d", -33.479319138, -178.645258146],
    [0xaf36483b445aa7b6, "pwv4hfu4cbmv", -51.664106928, 164.74556636],
    [0x390683763f6e349f, "74386xjzesu9", -32.260039279, -42.772708749],
    [0x191836e878fe5985, "34d3eu3sztds", -30.64963646, -131.668757418],
    [0x771edaa38b590b2c, "fwgep8wcc45k", 83.499152256, -62.239217982],
    [0x7477b9d0b0be2fe2, "fjvvmn5hrsry", 78.300313946, -81.689883646],
    [0xdfca1d53e759f114, "vz51unz7c7sj", 84.720359497, 83.154546626],
    [0xb49d2663251161c2, "qkfkdst525hw", -17.464940112, 104.5307984],
    [0x8e1a968245d74d86, "jse9e0k5ux6s", -64.421771437, 72.559400738],
    [0xacb5b6c3ec2fd3b3, "pkuvehzd5z9v", -62.28797615, 153.071986541],
    [0x3066361f631d2217, "61m3d7v33nj1", -37.684231681, -82.51105105],
    [0xadfe9c28c6941d28, "prz9sb66khfk", -46.140792422, 157.008880022],
    [0x3c29df1cb1abb3cd, "7hnxy75jpftw", -21.120342941, -35.580256778],
    [0x3722744d77c61141, "6wj78mcrss8n", -10.601867257, -60.104291367],
    [0x42c93f6d8b991c71, "8c4myvdcm4f7", 6.666184489, -142.785312424],
    [0xc060d50d42733752, "s1heb3b2fdvp", 6.293937407, 6.339568753],
    [0x14d1bb591b73c966, "2m8vqq8vfg4q", -13.102938624, -167.419503199],
    [0x5d6c18b68b0c1706, "cpq1jenc1hch", 85.973708652, -126.311486704],
    [0xb2c0715bbfcdf111, "qc072qxztrsj", -38.766676795, 124.123422582],
    [0x5281f207a4768e4c, "bb0z41x4fu74", 46.23920381, -145.097686568],
    [0x4c291c1bf2c4d4c8, "9hnjs6zksmbd", 23.482706763, -126.365592788],
    [0xf0f06cb77b071052, "y3s6tevv0w85", 53.898446209, 107.476179692],
    [0x1d812f0d55d2a41f, "3q0ky3bpubk1", -10.404094004, -123.123569777],
    [0x3876313ec8038964, "71v32gq80f4q", -34.918658833, -37.575266857],
    [0x52e82dc2b6ce8e95, "bcn2vhpqtu79", 50.779947487, -137.231003089],
    [0x64a960af9a738cb3, "dknq1cwuff6c", 23.563754919, -69.87464167],
    [0x66a6675152caa862, "dum6fnbktbn6", 24.427500129, -48.778698323],
    [0x1167042db23b7781, "25mh8cek7evs", -25.918744232, -172.931170164],
    [0xd4c4234743cc2113, "um226ju3thhj", 74.607060843, 11.695509674],
    [0xb22cf1506c3595e3, "q8qg2n3d6qby", -42.987705127, 121.994345101],
    [0xcc4459e31667c2b6, "tj25mssqdz1c", 30.128411926, 45.247656233],
    [0xad3b215ed859b899, "pnxk2rqsc6w9", -52.649775225, 145.215287761],
    [0x833c63747e8abcb7, "hdy66x3yjbyc", -74.09488245, 31.401585002],
    [0x5ddc32292e54a8ab, "crf34b9fbknb", 88.772771401, -120.46266456],
    [0xb89aa0a17f4e6ce2, "r2eb18cz9tqf", -42.182064165, 151.591832319],
    [0x6d44a4efac659b4d, "ep2b9vxddqen", 40.899818203, -43.858007722],
    [0x8f0ef6a3f8354360, "jw7ge8zs6p1q", -54.223627604, 72.937633348],
    [0x9cc3f1e4f5b3048e, "mm1z3t7pqd28", -15.570490112, 58.781255296],
    [0x2991aef991b768b6, "568uxydjqxnc", -75.109839766, -32.351701635],
    [0x9fd4bdfe52ce42e5, "mzbcvzkktt1f", -1.058007581, 80.063447991],
    [0x57e1e4d0484233c3, "bzhy9n2888tw", 85.551999997, -139.525651623],
    [0x5b902f77a4df4bf4, "cf82yxx4vx5z", 59.236045558, -100.602938786],
    [0xd35fbe04e0da4540, "uegvw170v92n", 67.067549829, 28.041465355],
    [0xda52fea1ed2b2012, "v99gx8ge5dh1", 54.057380161, 70.295489581],
    [0x05fec7ae7d6c4b1b, "0rzdgcmxej5j", -45.914669938, -158.030643933],
    [0xad869eb17d914c89, "pq39xdcxk568", -54.563709884, 148.691200025],
    [0x7715b27f30a68163, "fwbv4zthnu0q", 83.889564147, -66.31730633],
    [0xea857b48bf88a545, "xb2rqk5zj2kn", 2.703840832, 169.381601245],
    [0x1a2de9094ec3dc4c, "38qyk2bfsgf4", -42.490547613, -102.819808211],
    [0xa91bcfda5a304d0e, "p4ewzqku616h", -74.715907263, 140.247090475],
    [0x6c255b64eecf1483, "ehkpqt7ftwb8", 25.209968608, -39.083968781],
    [0xec9dd51145d2b4d7, "xkfxb4b5ubue", 28.096809307, 149.765834973],
    [0xbf3caf49aa6861a1, "rwybykebe1hu", -6.874602887, 167.272130738],
    [0x21ea01991c732c13, "47p0368wfdq1", -73.066150746, -68.850516235],
    [0x2c16598397ed234b, "5hc5m0wrxnjn", -62.705893646, -43.36513294],
    [0x36646aa3656d27c6, "6tk6p8v5enmw", -15.112432177, -61.186844922],
    [0x9d10a86294bff4b4, "mn8bhsnnrzuc", -8.414412605, 46.26102013],
    [0x43804e0a307335d0, "8f04w2jhfdux", 11.690284476, -145.968361937],
    [0xf09d8394f399bf1a, "y2fs757mm6zj", 49.984589916, 104.902159132],
    [0xfaed169d63502d6f, "zcqje7c3b0qq", 53.018949161, 177.332047574],
    [0x16910a56147e1603, "2u8hnphngsc0", -18.944738597, -145.980683253],
    [0xb409b9e958bc3390, "qh4vmubsrhtt", -21.550301342, 94.120867518],
    [0xd070c401bd7b9c63, "u1sd80exgff6", 53.881045225, 6.333095605],
    [0x10451e773fe2b903, "212jwxtzwbwh", -36.95946351, -179.706161176],
    [0xcb7de7861feeb5ca, "teyyg1hzxuuw", 22.287080571, 77.13088546],
    [0x19e7f8d047bfa62c, "37mzjn27rym2", -25.453357441, -115.443652768],
    [0x50eeeeec3d4c5b51, "b3rfxv1x9jep", 52.499487137, -157.508879422],
    [0xf1f8c9e2319d0d84, "y7wdmsjjmn6s", 65.105915989, 110.639408606],
    [0xa36345e72720ed55, "nejnctt743qp", -71.907741155, 119.604482384],
    [0x109b82da7b533ff1, "22es5qmvbdzz", -41.449039692, -163.677374413],
    [0x7b8ad07f92c42753, "gf5e0zwkshmp", 56.819338987, -6.286404466],
    [0xfe3886aa2a27ffd0, "zsw8ebjb4zzx", 70.400433374, 166.81344448],
    [0xe1550c6e3276b7bc, "w5bhsvjkfuvv", 21.91307328, 90.216075914],
    [0x1b1edbb57fb4a158, "3dgereczqkhp", -28.938094363, -107.245858143],
    [0x2c6f7fab9d8c6096, "5jrrzbwxjjh9", -59.102470004, -34.454964168],
    [0xfefaee20aebaa8cd, "zvxfw85frbnd", 76.377339828, 179.939573354],
    [0xadb48a9a33ad4420, "pqu8p6jmpp22", -52.019366459, 152.904239118],
    [0xce5c59610737c4df, "ttf5ks876z2e", 32.940355746, 70.510716203],
    [0x5b51dafb23504631, "ce8xpyt3b133", 65.953981658, -111.449087309],
    [0xe858c9f754045910, "x1ddmxun0jdj", 8.876640183, 138.762820134],
    [0x4e8599693b4f47e2, "9u2tku9v9x3y", 24.854804875, -100.335664629],
    [0x86ae322dc46b7063, "hur34cf4ees6", -65.907907374, 44.06906475],
    [0xfed15c5321498d69, "zv8psnt1966q", 77.291835568, 168.932704592],
    [0xc8a2a15a42061d5b, "t2jb2qk20sfp", 0.0783043, 64.352784714],
    [0xe6667ca3103f4c6d, "wtm7t8sh7x66", 30.149999899, 120.130158283],
    [0xceb3f1cdf5627db4, "tutz3mgpd9yv", 26.619797545, 86.895105383],
    [0x6bbb78201ce85fc2, "efxrh80wx1gw", 15.294094948, -0.855941703],
    [0x5adb733d8cedad98, "ccer6gddxqqt", 54.731603665, -96.555084598],
    [0xd587f8c174ca914d, "uq3zjhcntb8n", 81.413930907, 13.932284364],
    [0xc89357a97db4688b, "t29pgbcxqjn8", 4.180195974, 57.823371387],
    [0x31cccae8150cbd71, "676dpu0p1kyr", -26.343986477, -74.893736795],
    [0x5eb5fdd51a7f24d1, "cuuzvp8ugwke", 73.123102896, -94.349399651],
    [0x569f6854c773465f, "bugqhp67fe35", 72.813924773, -141.500707412],
    [0x8e58315fdd675d62, "jtd32ryxdxfq", -58.798871339, 70.684085686],
    [0xd6e53c7358775134, "uvkmswusfx8m", 75.535982305, 39.930603886],
    [0xfc3c8b04e46b4d7c, "zhy8q174ee6r", 71.770009616, 144.408570178],
    [0xb783448b19e73b5a, "qy1n92stwwxp", -10.103695078, 125.217650041],
    [0x48f688a191acc4e0, "93v8j8djpm2f", 9.847383426, -115.770866984],
    [0x56ac6ae03fbeaa8a, "buq6ps1zrup8", 69.281051198, -137.128601411],
    [0x2d3802e7664496ae, "5nw05tv68kcb", -53.405459567, -36.401468263],
    [0xf296590d4229480c, "ybc5k3b25540", 49.799668292, 125.343492523],
    [0x2bd3e9dcbc0b34b1, "5g9ymr5w1duc", -69.174370086, -8.553472301],
    [0xeb5bbf4e3a01d9ad, "xeevymju07du", 20.726414247, 163.056006793],
    [0x89d4572f16dc28b7, "j7b5fcsqvhnc", -68.237650074, 56.376909863],
    [0x2434cbf0e3271741, "4hudrw734wcn", -62.851200983, -83.337713286],
    [0x56512253dade5a6a, "bt8k4nyuvte6", 76.678549113, -157.051036444],
    [0xf0fed521579c73d4, "y3zeb8brmjtx", 55.508324901, 111.819412942],
    [0x2668b7493e20574c, "4tncfk9y41cn", -61.541623107, -57.906444925],
    [0x19e51b9d4add8f11, "37kjr7bbvq7j", -25.775135881, -117.805137163],
    [0x3fb1b16fb312036f, "7ysv2vxm281q", -7.483533661, -4.527373751],
    [0x500d188a88c5af8b, "b06jj2n8sqrs", 47.285276327, -176.947667949],
    [0xa47f9fc4a7d50b57, "njztzj57un5p", -56.617364754, 100.859131179],
    [0x4f55b444b90ec836, "9xbv8j5t1v43", 44.58889811, -111.440427711],
    [0x4c7b557310275b84, "9jxpbwsh4xes", 32.336237912, -125.128672172],
    [0x0384c2cdc8bf141e, "0f2d5mf8rwb1", -76.960522417, -145.400297375],
    [0x751e07a69e155542, "fng0g9ny2pbn", 83.107194593, -85.61817154],
    [0x9d9dd57630638e92, "mqfxbxjhdf79", -5.629708441, 59.794586929],
    [0x51f896a58e16ce13, "b7w9e9df2v71", 64.959826241, -159.451753531],
    [0x8f8b39395b3cb65c, "jy5mkfbv7kv5", -55.311114927, 83.530229065],
    [0x77698515e928a5dc, "fxnsb5g952kx", 85.230734591, -58.35442276],
    [0x428b531097882b3b, "8b5p644rj0pm", 1.286602929, -141.940044864],
    [0x2d3a2f077d97cb2e, "5nx2y1vxkz5k", -53.294768167, -34.533254008],
    [0x062f27f604f9c538, "0srkgxh4z72m", -65.219846555, -147.145074094],
    [0x10fc97c6f4eb67c5, "23y9gjrnxemw", -34.818659312, -159.467596763],
    [0x2edb5a56888dc146, "5vepnpn8jr0n", -57.793540453, -6.758426298],
    [0x0aa243545aab180e, "1bj46p2updd0", -89.563966566, -94.129504577],
    [0x3c23f47556dcb085, "7hjz8xbqvks8", -21.137885584, -36.891515159],
    [0x9cb98b3c239fe27a, "mkwsqg13mzj7", -18.923697544, 65.68922658],
    [0x9c99d84cca3fbcda, "mkdxhm6b7yye", -18.428112483, 59.956339064],
    [0x562384ba2c0decb6, "bsjs9fjd1rqc", 68.302384426, -149.681104815],
    [0x81c011e4e4b969bc, "h7013t74r5nv", -72.876031046, 11.320347495],
    [0xa4cf1f9b1fe811a9, "nm7jz6szx08u", -59.442984028, 105.794178272],
    [0x5a86de37b4894221, "cb3ewexnj512", 47.04175657, -98.845151134],
    [0x2320bef20476568c, "4dhcxwh4ftc8", -78.452866118, -60.485120009],
    [0x82d393561c083d95, "hc9t6phw10yt", -80.600161294, 35.953497078],
    [0x7aff9b4b6e28976f, "gcztqkvf52cq", 55.793042581, -0.420428963],
    [0x92a53552be73a718, "kbkmbnpyffmj", -42.548877171, 39.737330409],
    [0x7abfb25f0a1e041a, "gbzv4rsb3s21", 50.138920865, -0.246097719],
    [0xcbb11b87cf81a2e0, "tfsjr1ygh6jf", 14.995490681, 84.692077054],
    [0xf520b6dfb17ed8b1, "ynhcerxjgvdc", 79.055887382, 96.832287441],
    [0x7891728e4496eb46, "g28r53k4kvpn", 49.050249382, -33.249908698],
    [0x407d0cd17f2e6197, "81yhtncz5tht", 10.673073913, -171.340213817],
    [0x082f8772b885c111, "10rsfwpshr0j", -87.725104996, -124.332779592],
    [0xcb7fcdd689364ca0, "tezwvpn96t6b", 22.318968363, 78.275638939],
    [0xca426456647a82a0, "t9168pm4gb1b", 6.104750675, 69.264842244],
    [0xb4ad4aefa1e8829e, "qkqnpvx1x219", -20.008592329, 110.038002649],
    [0x9b3c99402829b00e, "mdy9kh1856s0", -29.289537245, 76.818611289],
    [0xa2047a6e284a5129, "n827nvj8998k", -88.038845837, 113.155811338],
    [0x4593c0c7ae3c5b35, "8q9w1jxf7jem", 37.647816629, -166.585903519],
    [0x6bc172b2e28bc352, "eg0r5dr2jg1p", 18.117845652, -10.734424306],
    [0x4f6c48c80ba910c4, "9xq4jk0cp48d", 41.154970674, -103.830456041],
    [0x2c0af98a695cd1dd, "5h5gm2m9cm8x", -66.927006398, -39.488241985],
    [0x703cbe961a2d757a, "f0ycx5hu5pur", 49.499630762, -80.193537447],
    [0x5fb1749c204836f4, "cysr971090vg", 82.89742933, -95.217081926],
    [0x424dac0547c43d57, "896us1b7shyp", 7.832506298, -153.456508088],
    [0x16504c8be2fecd9e, "2t84t2z2zv6t", -13.618769139, -157.258994485],
    [0x5bc0618ac60b1520, "cg0632q61dbk", 62.272239858, -100.834858063],
    [0xed16c19c5a1d7b7d, "xncd372u3pxr", 38.382881696, 137.16538943],
    [0xb72bc3f8be6ced83, "qwpw7y5yemqs", -10.117263489, 123.216968061],
    [0xb1059507f6478ce7, "q42tb1zq8y6f", -31.32224495, 90.713117388],
    [0x30dde865723d2564, "63fyhtck7nkq", -34.069212599, -74.683207458],
    [0xe53028d1d7940bef, "wns2jnfrkh5y", 36.600846001, 96.199555934],
    [0x222e2120706b2a11, "48r2283hedp1", -88.547647969, -57.281181919],
    [0xb41ec4802a6526bd, "qhgd901bdnmc", -17.841677193, 94.968317358],
    [0xb4996e15e03cdaa2, "qkdqw5g07meb", -18.524250055, 104.681998892],
    [0x01a716b9aad49003, "06mjefebuk80", -76.363067266, -161.548622748],
    [0x918790dec57ccbff, "k63t1rq5gm5z", -31.424346445, 13.422691197],
    [0xdb741d9bebe2a4c0, "veu1v6zcwbkd", 66.416732564, 73.366651689],
    [0xb1b08e90c8d58404, "q6s8x468uq20", -30.837087394, 107.889357855],
    [0xc57b82b8b8c8cc26, "spxs5f5st362", 42.902390608, 10.716704911],
    [0xf9866ea34b83b770, "z636x8uchfvr", 58.100010625, 148.344136442],
    [0x1deab0fa803675e5, "3rpc1yn06tuy", -5.416184842, -112.766304744],
    [0x3299edf2897e6979, "6bdyvwn9gtnr", -40.96768912, -52.132028108],
    [0xf4aedbed8f07c2bc, "ykrervdg0z1c", 69.508304293, 112.141262465],
    [0x1da1f7be1d927f57, "3qhzgghxk9zp", -9.869960577, -116.899135099],
    [0xab55417d9677f617, "pebn2zdqfzv1", -67.765217862, 157.536173707],
    [0xd490291b6b988dfc, "uk82k6vcm26z", 70.371768722, 11.79645572],
    [0xf17c2bab65af67f5, "y5y2rbv5pxmz", 66.142370398, 99.136834731],
    [0x44e096446878d010, "8mh9dj38g381", 28.417647975, -162.331784893],
    [0x8bca613d70729645, "jg562gchfbc4", -72.708072906, 83.354764185],
    [0x000994d583daba3d, "004t9pd3vbx3", -88.991700995, -176.437083118],
    [0x70f903a9546c47b5, "f3wh7bbnej3v", 54.189835112, -70.147573952],
    [0x6a732e53fa619d51, "e9tkwnzud6fp", 9.266382927, -14.842773311],
    [0xc7cc21da167d1383, "sz623qhqgn9s", 40.859348616, 36.974961517],
    [0xa5b05e165ce5838a, "nqs5w5kwwq1s", -52.803264173, 107.145122174],
    [0x5ecc1c00471579cd, "cv61s0272pww", 74.796894467, -98.26136649],
    [0x68479645acd2d3b7, "e13tdjeduc9v", 8.028740367, -42.79772156],
    [0xee06732ea9a764fe, "xs376cp9nxkg", 24.483243375, 159.389247386],
    [0xb4776b2a736d86a1, "qjvqqbmmeq3b", -11.555266168, 97.686794985],
    [0xabc3919054fa255b, "pg1t342nz8kp", -72.188627532, 170.903647819],
    [0x7e9e193b56d4108c, "gug1kfuquh88", 71.954765718, -6.816500733],
    [0x415fb6b9cb00a196, "85gveffc02ht", 22.075825698, -174.557974161],
    [0xe5452461df129808, "wp2k8sfz2bd0", 41.599605405, 90.377346797],
    [0xb9c771b6387d58ae, "r73r3ejsgpdb", -25.427000705, 148.081416298],
    [0xdce8a76e6a109dbc, "vmnbfvmb22fv", 73.28572291, 65.870948191],
    [0x5465d0a8512e137a, "bjkx1b2j5s9r", 75.763975695, -173.59481855],
    [0xf59cf12f8a871e90, "yqfg2cwbhwg9", 83.548315197, 105.15961404],
    [0xab039e7e58a0f3d9, "pd1twzksn3tx", -77.742681737, 159.91246146],
    [0x7b84d61f1f5b7982, "gf2ed7szcews", 58.292060303, -10.44140172],
    [0xd60f0e5785a590ba, "us7hwpw5nq8c", 69.739014386, 26.990931174],
    [0xe6d5bd870142c051, "wvbvv1s18c05", 33.362995351, 125.029939438],
    [0xbc0eaa0cce5d85b2, "rh7bn36fcq2v", -21.086377089, 140.551927036],
    [0x9f24a727bb823a06, "mwkbf9xvh8x0", -9.702813223, 74.300396418],
    [0xea33dd94cb6a1546, "x8txv56ce8bn", 4.192920098, 165.458028403],
    [0x39c3d54ac11a68b3, "771xbkq139nc", -26.739129192, -31.621325335],
    [0x25963a3312704772, "4qc3ndskf13r", -51.840912559, -76.700618852],
    [0xdc10f5d51aab4253, "vh8gcp8upe15", 71.013581722, 46.099986075],
    [0x521ca6e07c06c93a, "b8fbes3w0v4m", 49.331044228, -153.476908506],
    [0x19e9cc8d806a6e2d, "37nwt3d0e9r2", -26.974089449, -114.37575539],
    [0x1088c06caee7342a, "224d0v5fwwu2", -44.620506279, -165.195981254],
    [0x72df407c5dcd62be, "fcgn0z2xtpjc", 55.939588235, -51.997381803],
    [0xe9400c0a91ce3919, "x500s2njtswj", 16.963859805, 135.195251579],
    [0x84dde94975f650a5, "hmfykkcpyt8b", -56.530164613, 15.305608365],
    [0xd65640da6cf11d9b, "utc41qmdy4ft", 77.730132518, 23.968995877],
    [0x4027fb49ce34e2a6, "80mzqkff6mjb", 2.707169771, -171.635523338],
    [0x0d2aeddd5f13d2a1, "1npfvrbz2g9b", -55.722766139, -123.869785066],
    [0x8d0a0ddb8c3ded3b, "jn50vqwd7rqm", -56.082032467, 49.458537454],
    [0x171523a85e262b38, "2wbk7b2y4spm", -6.281754099, -156.982495414],
    [0x6ffa2ed18f3872d5, "ezx2xndg71te", 42.311662771, -0.743157592],
    [0xb6e5cb6e86008556, "qvkwqvn6022p", -14.342305433, 130.383349812],
    [0xfbdb87e2a99b7a62, "zgesgsp9mex6", 65.544667306, 173.836229153],
    [0x862519dd5acbd298, "hskjmrbutg99", -65.127534963, 28.356991879],
    [0xaea6b005544821f5, "pumc01bn90hz", -65.907238599, 176.835986787],
    [0xa425a2ce36ed842a, "nhku5mjqxq22", -65.362009839, 96.830031306],
    [0x19e43a485311970b, "37k3nk2m26ch", -26.518706077, -117.49842359],
    [0x912c8b256fa20d8f, "k4q8q9cgn86s", -32.289674492, 9.428955365],
    [0xdef21018458bc8b9, "vvt10625jg4c", 76.126172176, 85.792486955],
    [0x0e8ccc3fab85ccf4, "1u6dsgxchr6g", -65.634859644, -97.514805643],
    [0xe1a82d6b1ccc888c, "w6n2uuswtk48", 11.407692521, 110.254211374],
    [0x3fa43e16b788bdad, "7yk3w5prj2yu", -9.562392145, -4.999574661],
    [0xc17b90233dde49b1, "s5xt08txvt4v", 20.570510917, 10.576640531],
    [0x3f54ae92faca9c73, "7xbbx4rutbf7", -1.305222681, -21.126802431],
    [0x69d9e11e82b0428a, "e7dy27n2q118", 20.802660616, -29.86298334],
    [0xbc28cde163bf9237, "rhndvsc3ry93", -21.990259257, 144.384375243],
    [0x7850940d52ca6f94, "g18983bkt9rt", 53.711565053, -44.285299247],
    [0x0910f721d5145458, "148gf8fp2jb5", -75.272924541, -133.832702428],
    [0xe1eb722be9e88f30, "w7pr4bz9x27m", 18.109848301, 111.576777307],
    [0x9088eb845d0e36f7, "k24fr12x1svg", -44.596397987, 15.425563584],
    [0x8d5c11b7f3ecafe8, "jpf13ezmxkry", -46.164956089, 47.888696066],
    [0xd6b9a969b4bd6f81, "uuwukuenrprs", 71.085402048, 43.455358138],
    [0x9aecbf2d39a62667, "mcqcyc9tnsm6", -37.652011462, 88.541164412],
    [0xe6a2d5ca4fd70dd8, "wujeckkguw6x", 23.183204075, 131.546026451],
    [0xec8289d653566b78, "xk18mpkmbtpr", 22.584785814, 148.58496944],
    [0x6f1a26ef0ca3c3ad, "ewe2evsdng1u", 36.680963261, -17.758420515],
    [0xa1947c409827329d, "n6b7sh4s4wt9", -73.893321123, 101.780891877],
    [0xa14968308d3a1228, "n54qhd4e7892", -72.058765558, 93.365401717],
    [0x13b5c64bbedb3e04, "2fuwdkxyvdz0", -28.36277907, -139.812109556],
    [0x52a70e854a0451b4, "bbmhx1bb0j8v", 47.20690909, -138.910101775],
    [0xbd1a2b7053ff2afa, "rne2qw2mzwpg", -8.358202641, 139.856632932],
    [0x07ebbebee57abb7f, "0zpvxgr5gbxr", -49.639702599, -135.001202357],
    [0xafa1f6b27946414b, "pyhzedmt8t0n", -54.918308988, 175.591070972],
    [0x431eaa5f463d95db, "8dgbnru67qbx", 15.511745711, -151.945927397],
    [0x5f714f2965bc1d03, "cxsnybc5rhfh", 88.378727429, -106.576692618],
    [0x4dc389972fbca130, "9r1sm5tgrkhm", 40.141876621, -121.412685104],
    [0x199b37639ac21bdd, "36emfswus8ex", -29.901262081, -119.060356495],
    [0x1503edf522052220, "2n1yvx920nj2", -10.022245619, -177.295639551],
    [0xe81e04339a2be6ff, "x0g08dwu5gmg", 4.321078251, 139.25016128],
    [0x7d0f519393d6c5bc, "gn7p34wmuv2v", 81.445413118, -40.728516552],
    [0xd8ac979cbe9b156e, "v2q9g75ymdbq", 46.731435414, 65.538833775],
    [0xb47ec62c043509ed, "qjzddc046n4y", -12.21088415, 100.667814308],
    [0xd0c1111f33f25cd5, "u30j27tmy9fe", 51.568074732, 11.268478442],
    [0x27b93943e827a5af, "4ywmkhz84yku", -52.488521549, -47.274731875],
    [0xa8954ad0c74c1b71, "p2bnpn679her", -84.691604023, 146.560754418],
    [0x1409ef16037f9c81, "2h4yy5h3gyf8", -21.296660398, -175.863139832],
    [0xf63e3168d2b2aa17, "ysz32u6kqbp1", 71.962552381, 122.73166059],
    [0xb3eaea1447a4a72e, "qgpfn527nkmk", -27.755046168, 134.912728227],
    [0x5c1a4e4c3dd874de, "che4wm1xv1ue", 70.7807593, -130.504310991],
    [0xb209098467b96665, "q84hm137r5m6", -44.245487412, 115.534250691],
    [0x11a0240ff4339de0, "26h283zn6ffy", -33.651407691, -162.752716408],
    [0xc60c16548ef6c19f, "ss61dp4fyv0t", 24.208873918, 25.404457789],
    [0x457ad38ec393a78b, "8pxe73q3kfms", 42.765882911, -169.301508185],
    [0x68024f7b08551609, "e014yys8bnc0", 0.519269005, -43.290937816],
    [0xf723effda8658cc1, "ywjyzze8dq6d", 79.977841944, 120.93142016],
    [0xf3019b21a6095173, "yd0tq8e6158r", 57.175961463, 113.493276132],
    [0x88d8b1a2c3260e7a, "j3dc38q34s77", -81.341205173, 60.191800463],
    [0x28f5481ac648e49a, "53unh6q693k9", -79.088766823, -27.929589381],
    [0x775024199df0fa82, "fx8286dxy3x8", 87.29046197, -67.133739551],
    [0x673364ddb49b3456, "dwtq9renmdu5", 37.747365114, -60.05789442],
    [0x2777aa4b59b35cf8, "4xvunkutqefg", -45.67611061, -59.132941671],
    [0xa00491e849daa801, "n0293u29vbn0", -88.350377035, 90.780970781],
    [0x59d6d82ada3db935, "c7cehbqu7qwm", 66.623232447, -121.422467187],
    [0x2097c94851ddeeb6, "42cwkk2jvrrc", -84.658245028, -76.453621573],
    [0xf04a1126dfa98a51, "y15129qzp655", 50.852805956, 94.250307577],
    [0xb1a84b0522135855, "q6n4q1922ed5", -33.346190087, 109.952912709],
    [0x1f62d3b86cd67520, "3xje7f3dutuk", -5.040847697, -104.598571319],
    [0xaaa239fa269a2f66, "pbj3myj6m8rq", -89.746925743, 176.39295374],
    [0x91e8b318d48dfa8c, "k7nc666njrx8", -27.891843492, 20.844046583],
    [0xcd2b3b98cf6f1b00, "tnpmr66geweh", 34.685847575, 55.517846838],
    [0x4df0a1dd5f3c6b49, "9rsb3rbz7jpn", 42.275289769, -117.014212511],
    [0xfa0ea77ac009c96c, "z87bfyq0174q", 46.57243541, 162.902583707],
    [0x90b96eb217686fc6, "k2wqxdhre1rw", -41.032640287, 20.37462778],
    [0x3a6559889b17ee7b, "79kpm24v2zr7", -36.693395269, -16.640468349],
    [0x13489c480dfd6d8b, "2e49sk0ezpqs", -27.838672112, -153.796611384],
    [0xccc3fedd236e7c76, "tm1zxr93ety7", 29.484847063, 59.031416352],
    [0x2370e2889f9018b3, "4esf524zk0dc", -69.959690032, -60.673538206],
    [0x283ae1b9f9fd2667, "50xf3fgtznm6", -86.775864921, -34.019544086],
    [0x60658ac5f4916302, "d1kspjgnk5jh", 7.767050343, -83.359959446],
    [0x883f0af9c8bb1c1f, "j0zhpyf8rdf1", -85.040988142, 55.188084213],
    [0x0863f20524aedb42, "11jz4194pven", -83.135917645, -126.824461862],
    [0xb4769226cd0b22b9, "qjv949qe1djc", -12.47307634, 97.853236993],
    [0xbaad2fc791268d6f, "rbqkzjwj4u6q", -42.727694408, 177.855040736],
    [0x54b4cd430b399e84, "bkuduhsc76g8", 72.227097097, -162.239426393],
    [0xda4842f9ebfc8bad, "v9445ygczk5u", 51.013964024, 70.482761154],
    [0xebba83efdc0aabf3, "xfx87vyw1bpz", 14.139062231, 179.470681917],
    [0x6940c32c0a4724e1, "e50d6c0b8wkf", 17.276120753, -44.174967583],
    [0x6c405131533fc5b3, "ej052dbm7z2v", 28.712336297, -44.97752198],
    [0xb13f71f3eb972188, "q4zr3wzckwhs", -28.219509612, 100.272072849],
    [0xef86e17c3650047c, "xy3f2z1qb027", 35.591370626, 171.245613619],
    [0xb6614d78e4af8d91, "qthnuy74py6t", -15.65376655, 118.338196079],
    [0x4d91067a04b3bb5d, "9q8hdyh4qfxp", 37.386875564, -123.623357984],
    [0xd0a5c1934772064c, "u2kw34u7f834", 47.520634517, 17.628015642],
    [0x35bcae946c326797, "6qybx53d69mt", -6.925112679, -68.948020606],
    [0xed91c055d5a3cdec, "xq8w0pfpng6y", 37.660979716, 146.956165138],
    [0xb626087da7f59f06, "qsm0hze7yqgh", -21.051870573, 119.744725762],
    [0x2886ae84b5b8225f, "523bx15pr0j5", -88.499121024, -30.977018042],
    [0xfeaf6aa0efdc0f3a, "zurqp87gvh7m", 69.962978171, 179.280271374],
    [0x34e54281de322635, "6mkn50fy68m3", -14.408868073, -72.989273136],
    [0x7873bf2ecb9a3d0c, "g1tvycqcm8yh", 54.455328004, -36.607917666],
    [0xaf3752b3cf8fa24f, "pwvp5dygjyj4", -50.785127399, 164.694582083],
    [0x8be37bec0bda63de, "jgjrrv0cv9jx", -71.822813072, 86.474662304],
    [0xe5c1e88f757449b3, "wr0yj3vpfj4v", 40.44065862, 102.542356496],
    [0x64df81be7f62d1f4, "dmgs3gmzdc8z", 33.109969876, -73.743205207],
    [0xd211efc40c593a21, "u88yzj0dc4x2", 49.02697482, 23.863043998],
    [0x27a52a6bf27fefc9, "4ykknuzkgzrw", -54.113677126, -49.966679084],
    [0x10929aaf4020d2b7, "2299pcu0439c", -42.002097342, -166.294456592],
    [0x00972ef05f3955be, "02ckxw2z75bv", -84.954636504, -166.661437619],
    [0xcf7cceb7f65489a8, "txydxezqbk4u", 44.054983351, 76.980185799],
    [0x1002840d03911c8e, "20188383k4f8", -44.903640186, -177.879120072],
    [0x020215574fc71b13, "0811bpugswej", -89.64917421, -156.087029604],
    [0x67cad8f1ed9285a8, "dz5ejwgekb2u", 39.939982557, -51.081414241],
    [0xb423628766b230a4, "qhjq51v6q8sb", -21.435310448, 97.522143576],
    [0xed6668f13407edf2, "xpm6jw9n0zqz", 41.169588111, 142.625926345],
    [0xbc58f45a19ac4d9d, "rjdg8qhtpj6t", -13.413419202, 138.884657639],
    [0xee1f9adb9bfdd9b0, "xsgtpqwvzrdv", 27.634389943, 162.750063118],
    [0x300c03864b750f77, "606071kcfn7r", -43.542602976, -87.049050637],
    [0x11f0de8b9fd3178c, "27sex2wzudcs", -24.693173123, -162.093806436],
    [0x1b627200fb886a8c, "3ej7407vj1p8", -27.595419175, -105.023922178],
    [0xdad7aabee4f821a0, "vccupgr4z0hu", 55.565200553, 81.561433507],
    [0xd3734be035bfadaa, "uetnrs1pryqu", 65.809384213, 29.862555055],
    [0x7587bb448a59aabf, "fq3vqj4bc6pc", 81.106707152, -76.021549738],
    [0x42cce2425ab4f107, "8c6f4hkuqmsh", 7.40691832, -142.288125053],
    [0x161451b0168b29a3, "2sb53d0qjdnu", -17.697933188, -157.433493528],
    [0x7482f4a0c76d2713, "fk1g9867enmj", 68.117242908, -76.219919078],
    [0xcae068d6d14e53c6, "tch6jpqj9t9w", 6.017362674, 84.954595314],
    [0xfcea3313fc35b1d6, "zmp364zw6qsx", 73.360941781, 156.543605518],
    [0x1913545c565d36d7, "349p8r2qcnve", -29.578119631, -133.582369939],
    [0x2f2a9001b1c25573, "5wp900ejs9br", -56.070517411, -11.948811578],
    [0x254dfc7c6331714c, "4p6zsz3365sn", -47.860330717, -85.922264278],
    [0x26556c0b56a21709, "4tbqs2uqn8ch", -56.508517294, -66.955552944],
    [0xf9ade44de3f4fca4, "z6qy8mg3ymyb", 58.830745158, 155.757914305],
    [0xcb22f1fd084dd7d2, "tdjg3z889rcx", 11.862616391, 75.663584252],
    [0x213427801a11e96e, "44u2g00u27nq", -74.398667291, -83.890552155],
    [0x2005828d8524ea98, "402s53d54mp9", -87.881843267, -89.15119932],
    [0x662070278fd1282e, "dsh709wgu4n2", 23.03623804, -61.492014767],
    [0xa125b27915861517, "n4kv4y8phsbj", -76.427910083, 96.800730322],
    [0x4c7cb57882715bc6, "9jycby42f5ew", 32.684474808, -125.471672956],
    [0xc0ba45fde2efc47d, "s2x4czg2xz27", 3.338595821, 21.175450602],
    [0x768b084051aaa899, "fu5hhh2jpbn9", 68.227329493, -51.85512725],
    [0xc756ea8bb67f4c07, "sxcfp2xqgx60", 43.949256849, 25.28965042],
    [0x118bc763541361fd, "265wfsun2ehz", -32.536293739, -163.712740476],
    [0xbc5b90f3af255d24, "rjet1wxg4pfk", -13.147330844, 139.998524893],
    [0x10b807ce0d042f45, "22w0gmhe0hrn", -42.027659294, -160.163488536],
    [0x47861275557c2caa, "8y314xbpghqb", 35.37595648, -144.733748622],
    [0x4beefc8e97fb2405, "9grgt3nrzdk0", 18.90332012, -90.111939248],
    [0x1fb5c77d74497949, "3yuwfzcn95wn", -5.801018916, -94.799600911],
    [0xec5aca389cf82069, "xjednf4wz0h6", 31.301207936, 140.222245391],
    [0x0fca6589fd38128f, "1z56c2gx7098", -50.136234335, -96.619818273],
    [0xc140b80f084cd365, "s50ch3s89m9q", 17.059137491, 1.247690264],
    [0x0241aa50f11b5934, "090unn7j3edm", -83.636621776, -156.177453348],
    [0xb8d74b5eb95c6aff, "r3cnqrptcjpg", -34.018150521, 147.941261525],
    [0xf3152637c82955bf, "ydbkdey855bv", 61.280386104, 112.970482207],
    [0x21eb1e23404d4fae, "47pjw8u09p7u", -72.153957768, -68.615064033],
    [0xfe1940141d5dfa13, "zsdn050xcrx1", 71.385037849, 160.313249842],
    [0x1a065d2d5ea9f79c, "3835ucbyp7vt", -42.923906249, -110.883661067],
    [0x9bd600b56b3c4e09, "mgc01ecc7j70", -23.885407844, 80.224704206],
    [0xdf44b4851237dd32, "vx2c918k6zfm", 86.05393362, 68.599097276],
    [0x517e6ec249e98cc7, "b5z6xhk9x66d", 66.556819129, -169.49057589],
    [0x38356661e8fc385b, "70uqdsg8zhw5", -39.612425885, -38.908458992],
    [0x6c598be02a58b996, "ejdsrs1bc2wt", 31.706675323, -41.152319397],
    [0xc290b2a83b3a9a8b, "sb8c5b1v7be8", 2.989185234, 34.972051608],
    [0xfc54fa6ebb694c93, "zjbgnvpve569", 77.899521371, 136.362093603],
    [0xdea14eda9003fce9, "vuhnxqnh0gyf", 68.676244263, 84.701884721],
    [0x35e759a635efda42, "6rmpm9jpxze4", -2.937514743, -71.469847579],
    [0x0d5a652a7b577834, "1pe6bbmvbxw3", -47.326700728, -130.388802201],
    [0x12e634b120618f99, "2cm39d90d67t", -37.691246424, -138.799794804],
    [0x7966b96f2b035853, "g5mckvtc0ed5", 63.531379973, -36.697401607],
    [0x8a46d1362c973353, "j93e2ejdkwtp", -82.380559115, 69.639100666],
    [0xa7fe6d3a6bb7a6d5, "nzz6ufmcqyme", -45.910243185, 134.162246251],
    [0x12ebdb3d8f432f53, "2cpxqgdg8drp", -38.080745725, -135.402686606],
    [0xf274abbcbe099efe, "y9ubrg5y16gg", 54.905220145, 119.525472466],
    [0x3cc706262c56523b, "7m3hd9jdbt93", -14.671739395, -32.226310189],
    [0xb31b89479aba9d15, "qdeskjwurbfj", -30.159482722, 117.607261287],
    [0x33c4a3987e6d965d, "6g2b763yeqc5", -26.661292393, -55.04994595],
    [0x006dc5aa0dfbca1a, "01qwcbhezg51", -81.781566556, -170.775953958],
    [0x5ddd0d254a18e5ca, "crfhu9bb33kw", 89.438374623, -120.738656156],
    [0x33646b4173c1156e, "6ek6qhcms4bq", -26.296189672, -61.257876763],
    [0x55dc43058eb3e51c, "brf461dfqgkj", 88.997902156, -165.845537551],
    [0xdf9597fbd4ea9c15, "vybtgyynxbf1", 84.017691184, 79.62649497],
    [0x4c91d4c6499e1509, "9k8x9jk9msbh", 26.659939297, -122.996513629],
    [0x7c704b6eb4525ef5, "gjs4qvpnb9gg", 76.361642391, -39.068729592],
    [0xa53f9e5ed70013e7, "nnztwrqr009y", -51.023422207, 100.830118722],
    [0xa27c2de14a74546c, "n9y2vsbbfjb6", -79.998161486, 121.531878053],
    [0xb9a5ff3ee766d7f5, "r6kzygr7dvcz", -30.962959549, 153.236395167],
    [0xa14d07034ca15218, "n56hf0udn591", -70.879306898, 92.906829462],
    [0xe678bb5e65e5a218, "wtwcqrm5wqj1", 31.19768518, 122.273987285],
    [0xa5c9b6f6baafdc98, "nr4vexpupzf9", -49.619022548, 105.28197529],
    [0xf82cac7c69b01eae, "z0qbsz39q0gb", 46.534184764, 144.703250463],
    [0x3821752a495a38d2, "70hrbbk9c8we", -43.636018404, -38.984225453],
    [0xbf3f13b68fbb864c, "rwzj7engrf34", -6.091348539, 167.507162425],
    [0x8d99dbb18be160a7, "jqdxrddcw5hb", -52.149079278, 60.099255373],
    [0x83167fd7d139cb45, "hdc7zpyj775n", -73.828579832, 24.573812974],
    [0x54d2996935153afd, "bm99ku9p2nxg", 76.183225878, -166.430500845],
    [0x5bbdf94c7fef8dfe, "cfyzkm3zxy6z", 61.773325431, -91.568305063],
    [0xc6968ce139dc2e51, "suc8ts9tvhr5", 26.832370272, 36.103358131],
    [0x241dafa39fb5ecc9, "4hfuz8wzqrqd", -62.442258647, -85.793675779],
    [0x3f54852566c44b5d, "7xb8b9c6sj5p", -1.264343734, -21.773009831],
    [0xf6920371c28975e3, "yu906wf2j5uy", 70.393545353, 125.269424285],
    [0x65a8caa2c3d1d694, "dqndp8q3u7c9", 34.103256567, -69.271017639],
    [0xb7dcfcbd1436bfcb, "qzfgtg8n6uzw", -0.770690097, 127.870001443],
    [0x83b644ea226bcb59, "hfv49uj2eg5p", -74.069721047, 40.86552928],
    [0x8716d566ca689f09, "hwcebtqbe2gh", -51.343140626, 24.640761079],
    [0x59923a67dd7144ac, "c693ntyxf52b", 59.271214847, -121.697529519],
    [0xf15d5fcf6c40fda2, "y5fpzmvd83yu", 67.488079615, 93.1386765],
    [0xd0bcaaef587729c4, "u2ybpvusfwnw", 49.2511844, 21.089059538],
    [0x2e443b4d19862f53, "5t23qm8thsrp", -60.217928699, -21.872889981],
    [0x4d830fd2cb382068, "9q1hznqc70h6", 34.619508137, -122.026728476],
    [0x9be3ac3cc12bbe86, "mgjusg615fz8", -27.31594509, 87.047595442],
    [0xef6c471d059a6850, "xxq4f785m9n5", 41.284438285, 166.036621057],
    [0xa6af5b035a9eac98, "nurpq0uumuq9", -64.814463502, 133.864200685],
    [0xb43aa8de4cb3ada8, "qhxbjrkdqfqu", -19.647275555, 101.135629109],
    [0x7c57ae6330a11a6b, "gjcuwsthn4e6", 78.160185304, -42.246289331],
    [0xc8b38721a7d16b49, "t2tsf8e7u5pn", 3.650868424, 64.098882744],
    [0x31bea9fb6e279e27, "66zbmyvf4yg2", -29.449846164, -67.590858016],
    [0x7ed52ef92643adb9, "gvbkxy968fqv", 78.170913327, -10.556103226],
    [0xcc6aec7a62ebceb2, "tjpfsym2xg7c", 28.598888847, 56.114725222],
    [0x75733c6eb412eb80, "fptmsvpn2cps", 88.182841644, -82.398791924],
    [0xb2bc0290665ceaac, "qby05436cmpb", -40.768391403, 132.321116813],
    [0x49ab05f55e42ec0e, "96phcxby8cq0", 12.128655561, -113.839261538],
    [0x12460a1d0b42a3cc, "2930n78c8bjw", -37.949265341, -155.818022046],
    [0x9e44503fe6b66fc5, "mt250gz6qtrw", -14.920391339, 67.543204389],
    [0xfef95d931e068172, "zvwpv4sy0u0r", 77.314590218, 177.41378234],
    [0x3eca8920f00fb004, "7v58k87h1ys0", -16.828959768, -6.126170729],
    [0xc2063cf56d51ab31, "s833txceb6pm", 1.713149272, 24.501592173],
    [0xa41c5548467f253b, "nhf5bk26gwkm", -62.598217873, 92.823985834],
    [0x885347f5ba94c7aa, "j19ngxeukm3u", -80.334019406, 46.565393447],
    [0x9dba0c99af395a69, "mqx0t6eg75e6", -8.335299395, 66.329746019],
    [0x118536c07163c821, "262meh3jdg42", -31.352646882, -168.265107158],
    [0xd3ba0006efc39e62, "ufx001rgsfg6", 59.069982376, 43.604601304],
    [0x96c73869b017b981, "kv3mhueh2yws", -14.564359349, 35.720713567],
    [0x0d6fa66c6e4fce87, "1prudv3f9z78", -48.398427091, -123.978229729],
    [0x0182d2d97197d119, "061e5qcjkz8j", -78.184635048, -166.496225419],
    [0xd7a016d2951ad9e5, "uyh1ennp3cdy", 79.047884602, 39.515154514],
    [0x56254ef952857409, "bsknxybkhpu0", 70.086635277, -151.533903272],
    [0xe03b2e5e235e1bbf, "w0xkwrj3csev", 3.642293303, 100.477250139],
    [0x4c2b33d6ffa74eb4, "9hpm7prznx7c", 23.463917782, -124.661924539],
    [0xc792130293079b7e, "sy9160nm0yer", 36.783121032, 35.252760566],
    [0xc4e7131446839edd, "smmj6526hfge", 30.472313091, 18.36969266],
    [0xb5040d60c968ef35, "qn20us69e3rm", -9.688302951, 90.201336343],
    [0xede1ee84f6d2ab72, "xrhyx17qubpr", 40.525604468, 153.241981539],
    [0x60ddcd62a71afa51, "d3fwusp73cx5", 11.052812596, -75.026580167],
    [0x0728e2869e95f9ee, "0wnf51nykrwy", -55.891830089, -147.866515071],
    [0x0cb1c773ae66c44e, "1kswfwxfdv24", -63.464813247, -117.301250417],
    [0x0a923da833d60b5f, "1b93vb1mus5p", -86.878872971, -99.237587866],
    [0x01b3a47b0f07004d, "06tu8ysg0w04", -75.110231169, -160.624558715],
    [0x2c1ca06461be11e2, "5hfb0t31rs8y", -63.252171125, -41.109143529],
    [0x36c39389d69bb612, "6v1t72fqmfv1", -15.94694075, -53.994459264],
    [0x206e6a242951dc50, "41r6n919b7f5", -82.611373274, -79.516969565],
    [0x00a6ee31c3b5c785, "02mfwdf3qr3s", -88.138936404, -160.37505776],
    [0x0573bfbc617465a2, "0ptvzg31fjku", -46.783575764, -171.572020682],
    [0x9782078eb13c1589, "ky10g3pj7hbs", -11.111743482, 35.3088149],
    [0x467a2080861e63ac, "8tx210463tju", 30.937913856, -147.257579952],
    [0x54534af7e8f593bd, "bj9npxz8yq9v", 77.03492414, -178.253589702],
    [0x83964b7dac18737b, "hfc4qzed31tr", -74.094147934, 35.457737586],
    [0x047b8fb1f79b5ee3, "0jxszdgrmegf", -58.211167813, -169.118830812],
    [0x1841cde95a3063ba, "310wvubu61jv", -38.161648236, -134.043065682],
    [0xda0d1212b1485644, "v86j44pj91c4", 47.297096546, 70.410047936],
    [0x5532126dd0ad0236, "bnt14vfhpn13", 81.770586042, -172.844851607],
    [0x78510ad6b244bbe8, "g18hpppk8kxy", 54.179874801, -44.682405099],
    [0x9af191a36400b3aa, "mcst38v402tu", -35.635181863, 85.150928171],
    [0x544bb5dff3169d7c, "bj5vcrzm2ufr", 74.179242172, -174.661639123],
    [0xa6718c13d26e7cd3, "ntsss4yketye", -58.255574269, 119.012648349],
    [0x84622ff376f88207, "hjj2zwvqz210", -61.704926328, 7.719924704],
    [0x4205ae9ca7209409, "882ux75742b0", 2.214264189, -156.122148978],
    [0x71e2fec1b96bd8fc, "f7jgxhetegdg", 62.515917123, -70.351473986],
    [0x7a419ca183e5964d, "g90tt8d3wqc4", 51.594837659, -21.551816083],
    [0x73468f8143f587e0, "fe38z0b3yq3y", 63.417540775, -65.082393904],
    [0xc4947192c578bd2e, "skb734q5g2yk", 27.303047199, 11.653895705],
    [0xce892b86958a657e, "tu4kr1npj9kr", 23.253773109, 82.230161427],
    [0x7c011765162e1eb8, "gh0jft8q5sgc", 68.542010242, -44.88963797],
    [0xbc144c0fcff84eff, "rhb4s3ygz17g", -17.831532748, 135.196343054],
    [0x27a03f81fcf637aa, "4yh3z0gwysvu", -55.937078046, -49.960726858],
    [0x739f6a2ce80dc12e, "ffgqnc781r0k", 61.530342286, -51.378195854],
    [0x17a6035310617d1e, "2ym06nshd5yj", -9.763305566, -139.125272058],
    [0x912ac270eb64a5b4, "k4pd4w7cdkkv", -33.363823988, 10.661991122],
    [0xba3316ef672090cc, "r8tjevv7428d", -41.188599313, 164.703352151],
    [0xbfcda5b25e9ef955, "rz6ucdkymvwp", -3.370325747, 172.689883489],
    [0x5e225f676e062c3b, "csj5ytvf0sq3", 68.191131744, -105.17517895],
    [0xe3ce8c5db9162398, "wg78sret2sjt", 18.411262888, 128.863478126],
    [0x0fc6a96c3fa50c2b, "1z3bkv1znn62", -49.146103634, -98.577658202],
    [0xb8436ec44bc6a96e, "r11qxj2csunq", -38.203302706, 137.066672144],
    [0x7078c11c2dcd6e33, "f1wd271etpr3", 53.850127244, -80.846104331],
    [0xd1f46578ec96ee3c, "u7u6by7dkvr3", 66.611895402, 17.264541819],
    [0x00c3f6566ef36c50, "031zdpmfyeq5", -83.016325168, -166.192988382],
    [0x62809327e37dd7e3, "db0969z3grcy", 0.229682641, -55.426913403],
    [0x85e0b112587c75e8, "hrhc24ksgjuy", -50.392066561, 17.936002645],
    [0xe1e74c5b6dbd87c9, "w7mnsqverq3w", 19.461499472, 108.475884046],
    [0x2e06eba93502b0b9, "5s3frb9p0bsc", -65.694291051, -19.697074258],
    [0x4e520f8ffb8fdb16, "9t90z3zvjzej", 31.079848463, -110.764252539],
    [0x932411c791ed9bef, "kdk13jwjxqey", -32.092830886, 28.177501484],
    [0x693ea039859b395c, "e4zb0fd5mdwp", 15.483055497, -34.065612615],
    [0x09b53fdd958f569f, "16umzrdpjxc9", -73.478065544, -117.451849043],
    [0x7a769beeeca3d766, "g9v9rvrdngcq", 55.092680233, -14.414457638],
    [0xc3e64005112dc7e9, "sgm4018j5r3y", 18.641950499, 40.781392023],
    [0x3c52972f1e79a6ff, "7j99fcsyg6mg", -13.745471643, -42.763104796],
    [0x11fdd728d9b91693, "27yxfb6tr4c9", -22.5416558, -159.484789619],
    [0x8d3827b35c214e12, "jnw2gduw4571", -53.289510262, 53.949140893],
    [0xf1da8ce5b52f913e, "y7e8ttep5y8m", 64.806840448, 106.417855636],
    [0x9a83b58a7b670c8d, "mb1vc2mvdw68", -43.98690671, 81.273876455],
    [0x972cce71760225af, "kwqdwwcq08ku", -9.366185904, 31.928014245],
    [0x00806ef7b8526112, "0206xxxsb9hj", -89.518526523, -168.058521062],
    [0xe0ab35991af787bb, "w2pmc68uyy3v", 1.025324908, 111.501566437],
    [0x3bfd85f0e0c0e8e0, "7gyscw70s3nf", -23.036865249, -2.039145672],
    [0xa8e290305870bc2e, "p3j90d2sf2y2", -84.186039612, 154.007139532],
    [0x0b342d83fdfeefca, "1du2v0zxzvrw", -74.39393461, -106.293068268],
    [0xd1358705307b7ccf, "u4usf19hgeyd", 61.312786674, 6.417548096],
    [0x587aa232ee0aa7a7, "c1xb4drf1bmu", 53.450205116, -123.980973238],
    [0x9a631647787c872d, "m9jjdjvsgk3k", -38.375778415, 74.626835081],
    [0xed9e16ebe40ea361, "xqg1euz41ujq", 38.258880268, 150.643240127],
    [0xc4a258477f066963, "skj5hjvz0tnq", 23.060158962, 18.464957644],
    [0x7d909e900c888f25, "gq89x40dj27k", 81.837503665, -32.738341423],
    [0x10b8a9ac28d7c122, "22wbmc18uz0k", -42.137894555, -159.00286273],
    [0x1fc199b3fcc35d2c, "3z0tmdzwsefk", -4.685905546, -100.294679729],
    [0x66117e3e0c8177df, "ds8rwghdh5vx", 26.647703643, -66.845447476],
    [0x7b336dd909ea5d2c, "gdtqvq89x9fk", 60.28499667, -14.885462895],
    [0xd434974bddd0d3e2, "uhu9fkyxu39y", 72.053799168, 6.436113191],
    [0x9a28789f25a2fc1d, "m8n7j7t5ncy1", -44.452905486, 76.526939758],
    [0x98824269c92b523c, "m2144uf95e93", -44.622154256, 57.780684914],
    [0x0d1232af0b5c7e7a, "1n935csccjz7", -53.25314724, -133.070816531],
    [0xbc5bb594b70d1766, "rjevc55r1ncq", -13.034039365, 140.321890764],
    [0xafd97c0a5b46e78a, "pzdrs2kv8vms", -46.49179433, 172.107393035],
    [0x146bf26da7cc07c8, "2jpz4ve7th3w", -15.613694188, -168.976032891],
    [0xeced35c2df38616a, "xmqmchqz71hq", 30.566589068, 155.092412233],
    [0x3378b3e6603b8288, "6ewc7tm07f18", -25.063880663, -57.846974296],
    [0x24687efd3d1aa0ad, "4jn7xz9x3bhb", -61.217322194, -80.868219705],
    [0xcf77197d92affcac, "txvjkzdkpzyb", 44.558528633, 74.743422016],
    [0x8c31538cad4b0cdf, "jhsp735e9d6e", -63.406979231, 50.772696813],
    [0xc3b72446e08e32d8, "sfvk8jr0jste", 16.288629383, 41.142669167],
    [0x3a938d4a85250d4f, "7b9sukn54n6n", -41.330016759, -8.945528843],
    [0x1744cb4e0897be0c, "2x2dqmh8kyz0", -3.79569714, -156.515823557],
    [0xbb444be54ac1ff53, "re24rtbbs7zp", -26.291549305, 157.830811691],
    [0x62b7ebb3240cdbee, "dbvyrdt41mey", 5.331489658, -47.827547204],
    [0xec05972b8cbe0440, "xh2tfbwdrs24", 24.920148152, 135.833222949],
    [0x291cac2664f0a70d, "54fbs9m4y2mh", -74.436018684, -40.927916963],
    [0xd45203ca41d54893, "uj907kk1up49", 76.005129429, 1.55474059],
    [0x0c82001ed0d2ff0f, "1k1007qhuczh", -67.481321635, -122.324310414],
    [0x8de36bb0389fff0d, "jrjqrd1smzzh", -49.514608921, 63.96471861],
    [0xc675c7d7e1ae1c1e, "stuwgpz1psf1", 33.573042855, 28.969898799],
    [0x945119e8ab9fff89, "kj8jmu5cmzzs", -13.117418893, 0.258092403],
    [0x361169885591c04d, "6s8qm22pk704", -18.586232769, -66.917542032],
    [0x197c8e0489561fff, "35y8w149bsgz", -23.812538983, -125.592243148],
    [0x883e4b9f131ca466, "j0z4r7sm3kk6", -85.365591651, 55.168249499],
    [0xdac30e1de30c49c9, "vc1hw7g31j4w", 51.43681453, 80.435417916],
    [0x095abf22773da4b6, "15ecy8mr7qkc", -70.002231175, -129.433562204],
    [0x543d4bd3792e314c, "bhynrnvt5ssn", 72.855345243, -171.247173929],
    [0xdee160a9dc56fa80, "vvhq1bfwbvx8", 74.1849956, 84.806942285],
    [0xda4c683e226680da, "v966hgj2du0e", 52.399399802, 70.880131531],
    [0x529ff0776aff51f3, "bbgz0xvbzx8z", 50.491960967, -140.946370389],
    [0xe7fd1cf8d8025bd5, "wzyjty6s09ex", 44.595575143, 132.443644975],
    [0xa1c71330810afbcf, "n73j6d411cxw", -70.784731246, 102.76894535],
    [0x89c676fd99f46262, "j737ezdtyjj6", -71.061302648, 58.176305273],
    [0xb8dab62fe972dd53, "r3ecdcz9fcfp", -36.288904067, 151.654707652],
    [0x6b4c3b42449ffdcd, "ee63qhk4mzyw", 18.524751481, -19.06651678],
    [0x43f4d133fa0f9097, "8gue2dzu1y89", 21.680867105, -139.889183455],
    [0x4a3aedaac0342be9, "98xfvbq06hpy", 3.297337158, -101.340540813],
    [0x243244be7baff050, "4ht49gmvpzs5", -64.229295048, -82.883611244],
    [0x529c367d2866f0f8, "bbf3dz98dvsg", 49.523736455, -142.962903344],
    [0x913905bd2ee5a4c5, "k4whcg9fwqkd", -30.082849831, 8.517081868],
    [0x11b215e8579294c1, "26t1cu2rkbbd", -30.605287911, -161.641297795],
    [0x4639fd557750e20a, "8swzupcrb3j0", 26.718712487, -147.830296929],
    [0xf000222754392332, "y00249un74jm", 45.010697525, 90.467054852],
    [0x79096fd964fc1c02, "g44qzqc4zhf0", 57.474099855, -41.515657438],
    [0x5d2b2ee35ac21aba, "cnpkxsuus8ec", 79.567883501, -124.468376041],
    [0xa094a9db0fef181c, "n2bbmqsgxwd1", -85.700963177, 102.542248266],
    [0xede28e3179b42c10, "xrj8wdctqhq1", 39.478921015, 154.272345073],
    [0x799becc6ca593a4a, "g6eytjqbc4x4", 60.234059754, -28.247513666],
    [0x78435ad1e58414d7, "g11ppng5hhbe", 51.893088733, -43.281840476],
    [0x954368802c0b7471, "kp1qj01d1eu7", -4.56994848, 1.979669085],
    [0x64fcc17591f46290, "dmyd2xdjyjj9", 32.781470623, -69.584390851],
    [0x8c12deafe3e5bb38, "jh9excz3wqxm", -64.062359352, 47.46018566],
    [0x3dee3046709bc9c4, "7rr30jmhmg4w", -4.013382864, -23.547570924],
    [0xf523d7428f8f4d65, "ynjxfhngjx6q", 80.134832361, 97.831774469],
    [0x47eb126d174d4bd6, "8zpj4v8r9p5x", 40.285444936, -136.285009333],
    [0x5b75d1f13519af51, "ceux3w9p36rp", 67.405127481, -106.104520702],
    [0x14c93d339af0263e, "2m4mudwuy0m3", -15.849707915, -165.37864908],
    [0x7e7f39cf3c703684, "gtzmmmtwf0v8", 78.297976804, -12.066328253],
    [0x3d53b2c81e06d9cb, "7p9v5k0y0vdw", -1.910560555, -42.395174415],
    [0x826d43f7e2cf934a, "h9qn7xz2ty9n", -81.827423439, 31.101513342],
    [0x6e91b56240c62e43, "eu8vbsk0ssr4", 26.346697174, -10.167644031],
    [0x6ee3a113e3411dfe, "evju24z384fz", 28.88745004, -3.154102138],
    [0xbfa1be45561b16aa, "ryhvwjbq3dcb", -10.250529789, 175.69376968],
    [0x6e4cc7371b4ff34d, "et6dfesv9ztn", 30.034860018, -18.867906554],
    [0x1d1d8354b1612b9e, "3nfs6p5jd4pt", -6.244771747, -131.392268279],
    [0x3d213d967a965aac, "7nhmv5mukteb", -10.220645878, -38.79561615],
    [0x8b6d9e0277f7616b, "jeqtw0mryxhq", -70.749210824, 76.911791597],
    [0x6891a0a6890c6cbe, "e28u19n91jqc", 3.521318241, -32.620415887],
    [0xa7753a5f8d7b2b88, "nxumnrwegdps", -45.485489882, 118.76030754],
    [0x08f10ffe5eb04c5a, "13shzzkyq165", -80.686633521, -117.777640235],
    [0xc518cc2aea493ff6, "snddsbrb94zz", 37.003428285, 3.73506169],
    [0xc6c30a90ee07e5aa, "sv1hp47f0zku", 28.840867516, 35.469055859],
    [0x58d09dde60f0222e, "c389vrm0y0j2", 53.785071472, -122.809030811],
    [0x7dabb21150b568aa, "gqpv44bhqpnb", 79.6447796, -22.763405043],
    [0xec42401790aada06, "xj1405whpce0", 28.496483359, 136.414826507],
    [0xb5cbaffd5b499822, "qr5uzzbv96d2", -4.746509486, 106.865100407],
    [0x2c57c0b9c8b28073, "5jcw1ff8qb07", -56.586412804, -42.80999732],
    [0x67c05e92df6366ba, "dz05x4qzdemc", 40.003899063, -55.932997807],
    [0xf32b76b432a2becb, "ydpree1knbzd", 57.58552993, 122.851137749],
    [0x0078f0ed74a28025, "01wg1vcnnb02", -81.002540428, -170.429244852],
    [0xddca668145db9562, "vr56e0b5vfbq", 84.819232523, 60.95239562],
    [0x39b5b7e31796ff5c, "76uvgssrkvzp", -28.494511902, -26.910453957],
    [0x8a65f17a98bbef43, "j9kz2ynsrgrn", -81.660628888, 74.221915015],
    [0x63ea2caf4a9228bd, "dgp2tcubk8nc", 16.972546876, -45.795276449],
    [0x1dd421d8ac3eac1a, "3rb23q5d7uq1", -1.328936482, -123.338530049],
    [0x5a172abd693fde4b, "c8ckpgc97zg4", 49.94273091, -110.399386158],
    [0x8778b14cbaf16de9, "hxwc2m5uy5qy", -47.564473733, 32.008590442],
    [0x08cddcdf74d0a7ea, "136xtrvnu2my", -81.606657508, -119.996605272],
    [0x34e12c4e2a6c8204, "6mhksmjbek10", -16.05641115, -72.57863264],
    [0x66c1e9afc6943107, "dv0ymcy6khsh", 29.233657057, -54.933866738],
    [0x3f69a338c9ec11ec, "7xnu6f69xh8y", -4.865287313, -12.883228076],
    [0x5cf7056b44bd067b, "cmvhbuu4rn37", 78.205223783, -116.679995435],
    [0x73203ca47ae6f173, "fdh3t93uwvsr", 56.52134156, -61.279039481],
    [0x2f06f2f9025080f8, "5w3g5y82b20g", -54.280571429, -19.873912305],
    [0xbb420b7d0a6bb5f9, "re10qz8befuz", -28.039754135, 159.204078347],
    [0x0b4bae4faed000a9, "1e5uwmxfu00b", -72.303299857, -106.941088373],
    [0xaa92203d14547057, "pb920g8nbjs5", -87.167085062, 170.540777005],
    [0xc25c5aab74845021, "s9f5pbvnhj82", 10.376273167, 25.660114658],
    [0xceb0cda723eaabc2, "tusdv9t3xbpw", 25.804396687, 85.327376767],
    [0xc383b5202ca6e2ce, "sf1vb81dnvjd", 12.261112755, 36.235267471],
    [0xeabd328a6809c864, "xbym52m81746", 5.099046059, 177.68949456],
    [0x9628e663d91c9275, "ksnfdsyt3k97", -22.033528319, 32.111032502],
    [0xe44856b64282bd8a, "wj45eek2hbys", 28.758091877, 92.972357974],
    [0xa1ddd04df33e0955, "n7fx0mgm7s4p", -67.643271556, 104.781227493],
    [0xbd0d9ac430559cb8, "rn6tpj1hbqfc", -8.936526151, 138.824630104],
    [0xaefbcc95b8d87970, "pvxwt5esv1wr", -57.899871151, 179.521631049],
    [0xab9a2b31cd8bb2ca, "pfe2qdfejftd", -75.87791972, 173.609644659],
    [0x614aa3749a322945, "d55b6x4u68nn", 16.958128189, -84.612807314],
    [0x503424a7bfb409db, "b0u299xzqh4x", 49.316147602, -173.94661535],
    [0x67b881503ad328a0, "dyw82n1uudnb", 36.640230433, -47.106769545],
    [0x30cd3953588beb6e, "636mknusjgpq", -37.008115751, -75.403719639],
    [0xb0075ccffc1a4f03, "q03ptmzw397h", -42.242724604, 91.647331097],
    [0xa5150920285cb857, "nnbhk818ckw5", -51.284026164, 90.199875701],
    [0x5e9fbca2c71b7e06, "cugvt8q73ez0", 72.687498283, -95.726206317],
    [0xc0ef7eba0c994e9e, "s3rrxfhdm579", 8.360999634, 21.792288031],
    [0x49d63ba570a95647, "97c3r9chp5c4", 21.323796836, -121.66092253],
    [0x98c54e64fa006972, "m32nwt7u01nr", -36.796639571, 56.540802891],
    [0x6963dcdf0952e73a, "e5jxtrs9bcmm", 18.234866087, -37.02869279],
    [0x8778c70ba666de91, "hxwdf2x6dvg9", -47.325894741, 31.749581103],
    [0x5624f6b3d03fc2e0, "bskgedyh7z1f", 69.537358048, -150.658100875],
    [0xf9a03cdfb33065b3, "z6h3trxm61kv", 56.555779415, 152.467324074],
    [0x9b6dec6ed956f949, "meqysvqtbvwn", -25.546315158, 77.209894577],
    [0x3012931221ae52a1, "609964j1pt9b", -41.956585889, -87.79554365],
    [0x14ff50c5042ad716, "2mzp1j845ccj", -11.395215198, -158.862142318],
    [0x96b04e723e75530d, "kus4wwjyfp9h", -19.213888118, 39.668628364],
    [0xc82c288eb882235a, "t0q2j3psh8jp", 1.412431014, 54.03027519],
    [0xbec294e01be3215b, "rv199s0vwdhp", -16.588399377, 170.926607531],
    [0x66948ec4620f4bfe, "dub8xj321x5z", 26.835518565, -55.237471491],
    [0xc61c05b033479613, "ssf0cd1m8yc1", 26.862552835, 25.380168267],
    [0x324acbd77a643206, "695drpvudht0", -38.936123452, -62.262518739],
    [0x0235d0533be04b1b, "08ux0ntvw15j", -84.5141253, -151.163716785],
    [0xa211fbf706e567fa, "n88zrxs6wpmz", -85.871417986, 113.890379299],
    [0x60ee4daf0df544b2, "d3r4vcseyp2c", 7.523570987, -68.647125999],
    [0xaae706d4b11d0ee7, "pcmhep5j3n7f", -82.138346998, 175.917253888],
    [0xc061754f448e68ce, "s1hrbmu4jtnd", 7.019260976, 5.993287057],
    [0x680a9763e0f4c63f, "e059fsz0ym33", 0.333866926, -39.958378504],
    [0xf688b342c1b771fd, "yu4c6hq1qxsz", 67.743328619, 127.713603361],
    [0xb08c696f652b94d8, "q266kvv55fbe", -43.166126253, 104.629831018],
    [0x239615e1737afb09, "4fc1cscmgcxh", -74.196544431, -54.775944857],
    [0x48d69f20acdff04b, "93c9y85dvzs4", 10.151879898, -121.349921563],
    [0x7ecf532a4c57d5c7, "gv7p6bkdbzbw", 75.80755214, -6.904187611],
    [0xdf58b3a6735cc57c, "vxdc79mmcm2r", 87.415109491, 71.528260031],
    [0xd087465eda46387d, "u23ndrqu8sw7", 47.589450841, 12.764426704],
    [0x59ff04aebda73b57, "c7zh9cpxnwxp", 66.891496587, -113.818757531],
    [0xc93524a923fcc1d4, "t4uk9b93zm0x", 16.262840712, 51.05549523],
    [0x1bd061d688f2cda2, "3g863pn8yc6u", -24.878403895, -100.845272302],
    [0xaa092830f8a329c4, "p84khd7sndnw", -89.283816877, 160.866910614],
    [0xfce80696f4d917f0, "zmn0e5rnv4cz", 73.231918086, 154.82916593],
    [0x3da526d0a2b38c35, "7qkken52qf63", -9.019720072, -27.63684563],
    [0xe7b4225ea05ea8ad, "wyu24rp0cunb", 38.007352492, 129.835136838],
    [0xd69aa7156669c939, "uuebf5c6e74m", 70.465381448, 39.113187404],
    [0x3ca91e4f77a7ebd3, "7knjwmvrnzpx", -21.500376994, -25.03033213],
    [0x718577227d778ba5, "f62rf8mxfy5u", 59.021291352, -78.28089799],
    [0xf195e592f4b21923, "y6byc4rnq8dk", 61.668709371, 102.358527915],
    [0x7069b465f6b3ae14, "f1nv8tgqqfr1", 51.624467805, -80.481077527],
    [0x11ff043ba6bcbd60, "27zh8fx6rkyq", -23.10108872, -158.863015078],
    [0x4b9a5a27a686a844, "9fe5n9x6hun4", 14.59844873, -96.735437174],
    [0x25eb5ca363b526ba, "4rppt8v3qnmc", -49.302272453, -68.657075466],
    [0x8e88a03a4468af79, "ju4b0fk4e2rr", -67.487208656, 82.655789059],
    [0x7b67dea6ddacdb2a, "gemxx9qxpmek", 64.60770765, -14.426792937],
    [0x24eaaec9ea3ea893, "4mpbxkgb7un9", -61.760952235, -67.52763939],
    [0xcb7b95a9e12621c3, "textcbg14shw", 20.702556258, 78.128012627],
    [0x6d471ed7ddb45385, "ep3jxpyxqj9s", 41.791893744, -43.276946861],
    [0xce7a1dfc53739835, "ttx1vz2mffd3", 31.285943386, 77.596899987],
    [0x23ad9900e5d7e057, "4fqtk075uzh5", -76.418843222, -46.929264511],
    [0xd6f2ede72b05bb5d, "uvtfvttc0qxp", 76.451318675, 42.085553463],
    [0xf72b878f43454306, "ywpsg3u38p1h", 79.594869794, 123.195535208],
    [0x080b2342406ede81, "105k6hk0evg8", -89.229467, -130.336138039],
    [0x37a214e5a8f65ba7, "6yj19te8yteu", -10.955956651, -49.147741373],
    [0xb80399dcb0355c6e, "r01tmr5h6pf6", -44.037924726, 137.344296934],
    [0xbd6cd671add1ce7b, "rpqedweeu777", -3.567148328, 144.255481812],
    [0xf04bd9367d0ab0a9, "y15xkemx1bsb", 51.918471213, 95.127263647],
    [0x4bb8381ebf561ab3, "9fw3h7pzbsec", 14.256115496, -92.263500336],
    [0xea07a03ba34103f4, "x83u0fx3841z", 2.123377408, 160.003855265],
    [0x0fae44c5d4f75a4d, "1yr49jfnyxe4", -54.371511764, -91.359274934],
    [0x1f04054f55edc2e2, "3w20bmupxr1f", -9.679002998, -112.483206889],
    [0x1b4039eb05ea1860, "3e03mus5x8d6", -27.879950352, -111.889933857],
    [0x727fef7d0d565abd, "f9zyyz8ebtec", 56.072145735, -56.30421829],
    [0x47fa366f1e38ffa0, "8zx3dvsy73zu", 42.482467246, -135.92716483],
    [0x2030a8eb1c42ac8a, "40sbjusw8bq8", -87.161663604, -83.061405961],
    [0xf9c72af9af953fa0, "z73kpyegknzu", 64.020675385, 148.353720607],
    [0x3c77e713c7443a0b, "7jvyf4y78hx0", -11.453995341, -36.817579088],
    [0x1b7d6bb2d9563965, "3eyqrdqtbswq", -22.794245229, -103.372391381],
    [0x56076bc85e553aa4, "bs3qrk2ybnxb", 70.029422447, -155.422543579],
    [0x9968568dd67375b1, "m5n5e3fqfeuv", -27.498972871, 53.58352587],
    [0x12e6c1b50cdc692e, "2cmd3e8dvjnk", -37.553516447, -138.44879712],
    [0x683a4132948f624e, "e0x42dnnjxj4", 3.220062103, -35.125794528],
    [0x7bd2da550e1292e9, "gg9enp8f2b9f", 65.25643178, -8.875888372],
    [0x5cf315abb065da04, "cmtjcbxhdre0", 76.951801604, -116.632132049],
    [0xea5d815c82bb012e, "x9fs2r42rd0k", 10.629326892, 161.030023718],
    [0x92f82242d6f30ddd, "kcw24hqqyd6x", -36.537981937, 42.635818725],
    [0x568e90bd075b1f9d, "bu791g87cdgt", 69.10191681, -141.250808106],
    [0x7e4ae4a49e926785, "gt5f994yk9ms", 73.571026679, -17.15666742],
    [0xda0c9aa34c182009, "v869p8ud30h0", 46.586537415, 71.351443102],
    [0x2090ba0f461169ee, "428cn3u625ny", -87.00170225, -77.414808491],
    [0x89dec36af5316eba, "j7gd6urp65rc", -68.486134089, 61.302434142],
    [0x7ddda4ec10835a94, "grfu9v0hhee9", 89.412937153, -29.805710362],
    [0xb9a6a39a0f41be32, "r6mb76hg86z3", -32.28820259, 154.485303464],
    [0x69e8d02dea4037a2, "e7ne0cgb80vu", 17.412047337, -24.571258305],
    [0x8858278c94640004, "j1d2g34ndh00", -81.424033551, 48.309717244],
    [0xffb3696728908395, "zytqktt8k21t", 82.691389123, 176.33830391],
    [0x65cd3b6a730f5f9e, "dr6mqumm1xgt", 41.728348328, -75.282027472],
    [0xd2a34c31b2722f35, "ubjnsdekf8rm", 46.157128741, 40.983584117],
    [0x44f8f0a7aeb3b61e, "8mwg19xfqfv1", 31.47348475, -159.180954862],
    [0x7683b149c3684d57, "fu1v2kf3e16p", 68.449209611, -53.774854741],
    [0x77bbee350e29e29e, "fyxywe8f57j9", 82.724663879, -45.064740829],
    [0xb10f4d305193cd62, "q47nud2jkg6q", -31.143947279, 94.416710918],
    [0x34ab55828205efbf, "6kppc0n20rrv", -21.137655455, -68.853700214],
    [0x6f6161a507150591, "exhq39872n2t", 40.482464883, -16.457175481],
    [0x80ac581187818492, "h2q5h4d7h629", -88.052146115, 19.866554377],
    [0x629c0d762a88022a, "dbf0uxjbj012", 4.389038086, -53.231633146],
    [0x80416211ee2f759e, "h10q44gf5xut", -83.30482045, 0.444759502],
    [0x0b07bedda566c7dc, "1d3vxre5dv3x", -76.335124139, -109.716218836],
    [0xb205d7547b962855, "q82xfp3vksn5", -42.190696532, 113.293620071],
    [0xb6503a28ee7cace7, "qt83nb7fgkqf", -13.884850123, 113.153491828],
    [0x2b04dc071397b5ae, "5d2es1smkyuu", -76.719337654, -21.615046737],
    [0xb450730b0211ae1c, "qj8762s226r1", -13.488409083, 90.45629624],
    [0x1909e35ddfbe4a2d, "344y6rfzrt52", -32.607523672, -131.029832564],
    [0xf2dda8ecb8a2a3b1, "ycfujv5snbjv", 55.575028363, 127.87497697],
    [0x50620d86abaa48b5, "b1j0v1pcp94c", 50.762506454, -172.7380548],
    [0xf1604445ead1c27b, "y5h48jgbu717", 62.346184231, 95.630334203],
    [0x42d1beb70a26b705, "8c8vxesb4uvh", 9.423549253, -144.859074723],
    [0x19352c09db5cb0bf, "34uks2fvcksc", -28.735103014, -128.832833099],
    [0x16afc16f0a003bb4, "2urw2vsb00xv", -19.964901152, -135.66363244],
    [0x3c978ad8d66f3573, "7kcspq6qewur", -17.542639493, -31.318775541],
    [0x84e9eb579985af30, "hmnyqpwthqrm", -60.734275748, 21.014977928],
    [0x4b50e77598948af3, "9e8ffxdskk5g", 20.212848739, -111.33182847],
    [0x92dae029a8e1711c, "kcef0be8w5sj", -36.208085385, 39.06146603],
    [0xce36520f9c784dcb, "tsv543wwg16w", 27.25549997, 74.639185726],
    [0x4cc3badf2032940c, "9m1vprt06bb0", 29.045152041, -120.963474296],
    [0x6630844801fc4dc1, "dss88k01zj6w", 25.422692902, -61.160584909],
    [0x933da2658ed399a0, "kdyu4tdfufdu", -28.797426431, 32.106034935],
    [0xcb5f02e94f211b3c, "tegh5ubg44em", 21.823496862, 71.884665251],
    [0x0d9d66917c076d48, "1qfqe4cw0xqn", -50.872495782, -120.452011909],
    [0xa533e1eec8b80d63, "nnty3vq8r06q", -52.309982731, 98.17207173],
    [0x3c4899f057458af2, "7j49mw2r8q5g", -16.619620994, -41.242316536],
    [0x0e11fea57d04be65, "1s8zx9cx0kz6", -63.358300007, -111.113642263],
    [0x1404a0cf3a9666ee, "2h2b1mtuktmf", -21.062779422, -178.882283327],
    [0x5d498b4634f2b4de, "cp4sqjjnybue", 85.150699491, -131.213540672],
    [0x3c2b59568a0e71ce, "7hppkpnb1tsw", -21.187103156, -34.971128298],
    [0x3c74b0b24cf2437c, "7juc1dkdy91r", -12.467630417, -38.247933891],
    [0x50f25d48f698f814, "b3t5uk7qm3w1", 54.121106819, -161.527285862],
    [0x1837d64919e5dc26, "30vxdk8twrf2", -39.437185577, -127.165790066],
    [0x7c1d03bb3034429b, "ghfh7fth6j19", 72.480309834, -42.015750518],
    [0x2c8026e6caea0b10, "5k02etqbx85j", -67.383183578, -33.235033295],
    [0xfe31435a867ab46d, "zssn6qn6gbu6", 71.44456837, 163.232626895],
    [0x9f180755d8242cda, "mwd0fpfs4hqe", -8.262382093, 70.403918683],
    [0x490e6a78efd742da, "9476ny7gux1e", 13.04282656, -130.127711355],
    [0x504d4ba725bffd38, "b16nr9t5rzym", 53.138722906, -176.850702519],
    [0xee93bc0046153ac0, "xu9vs0262nxd", 26.281091649, 171.38707214],
    [0x153e492ff3a99428, "2nz4kczmp6b2", -6.62525607, -169.937241716],
    [0xbe73de74f91990d5, "rttxwx7t368e", -12.703399901, 165.524880414],
    [0xc6095c64007c4d63, "ss4pst00gj6q", 23.845983157, 25.510385781],
    [0x1b01d7d04ca3cff3, "3d0xgn2dng7z", -32.353001057, -111.664057565],
    [0xce9c9858bd62954b, "tuf9hq5xdbbn", 26.928782779, 82.457317407],
    [0x7c06271cf5b85c0e, "gh32f77pr1f0", 69.05719276, -43.138887313],
    [0x535cab47156d1ce0, "befbqjspenff", 66.169231733, -153.363515012],
    [0x8c604c8c634d6480, "jjh4t3339pk8", -61.428384028, 50.857478458],
    [0x47185861f5f39229, "8wd5hsgpyf92", 37.117280119, -154.485334616],
    [0x346a51f178ab98a4, "6jp53wcspfdb", -16.265931925, -80.087935734],
    [0x6369ad9f4c769b98, "denuv7udfuet", 17.731057354, -57.770796853],
    [0xc5fbadbdcf937d3f, "srxuvgfgkeym", 43.043639297, 22.405101368],
    [0x1ea82ddf8cfda2d1, "3un2vrwdzqje", -22.326460502, -92.220979701],
    [0x90f15e40b5050474, "k3spwh5p0n27", -35.220932197, 17.142792158],
    [0x09b5e9346279f690, "16uyke32g7v9", -73.414615358, -116.870695056],
    [0x06846ca98da7bb78, "0u26tbdenyxr", -65.650999237, -145.642019137],
    [0x16a3cee89049840f, "2ujwxu4h9620", -21.334664514, -138.172248323],
    [0xfe865d67424a778a, "zu35utu299vs", 69.597111275, 170.359912403],
    [0xb51aa6856f5ffb39, "qnebe1cgczxm", -8.339311471, 95.40776171],
    [0x792cb20d0e37ea14, "g4qc438f6zp1", 57.840695072, -35.407778113],
    [0x659d8bc91cfe790a, "dqfsrk8wztwh", 38.741728461, -74.91475462],
    [0xae328c83622a14c9, "pst8t0v258bd", -64.595485087, 165.461462445],
    [0x5e450cf7e6c0f0e0, "ct2htxz6s3sf", 75.365275215, -112.248155614],
    [0x2c366a203e90f87b, "5hv6n81yk3w7", -62.928606003, -37.328948613],
    [0x09ccc20cad90c023, "176d435ek302", -71.361130995, -120.130508638],
    [0xdb988ced125cf87b, "vfd8tv8kcmw7", 59.181448479, 82.518716164],
    [0x57bfb7bb35418a1b, "byzvgftp8651", 83.994523508, -135.179886116],
    [0xedefd1c8aac8193f, "xrrx3k5bt0dm", 42.077726203, 156.857174367],
    [0x21f864ab357b2120, "47w69btpgdhk", -69.868958485, -69.877010776],
    [0x6f06cf85c60d6a33, "ew3dz1f61pp3", 35.649642588, -20.079865183],
    [0x660edd26c397cc27, "ds7eu9q3kz62", 24.572549774, -62.371581058],
    [0x8d60970bf079f73a, "jph9f2zhg7vm", -50.312426581, 51.43676184],
    [0x082a5e8582632991, "10p5x1d2ddnt", -89.376428413, -124.845426899],
    [0x51a784262f130e24, "b6ms89jg2d72", 58.453328879, -160.9857301],
    [0x47e65fd271e88024, "8zm5znmjx202", 41.475706218, -138.903954837],
    [0xe2f1c27dc1ddf444, "wcsw4zf1vru4", 9.535101931, 130.201951871],
    [0x579e9a92ef284c1a, "byg9p4rg5161", 83.157412755, -141.009733058],
    [0x59290a54b9f6d486, "c4nhnp5tyvb8", 56.992595163, -126.293731141],
    [0xd17adb2b5dfb95bd, "u5xeqbuxzfbv", 65.264255065, 10.850019438],
    [0xf5ae48abc82d89aa, "yqr4jby85q4u", 80.511965236, 111.355505358],
    [0xc46c986a8f0007bf, "sjq9hung003v", 29.72952121, 9.358637619],
    [0x96d5b84f335fd06e, "kvbvhmtmcz86", -11.746103606, 34.998740571],
    [0xab71be46ce08ee06, "pesvwjqf13r0", -69.316513879, 164.452692246],
    [0x514d637ff34405d5, "b56q6zzm8h2x", 64.423423082, -176.705130818],
    [0xaddd675c54a83e9e, "prfqfr2np0z9", -45.178866866, 149.51325024],
    [0x7f6658d59d3326cf, "gxm5jpdx6dmd", 86.351049569, -15.245475212],
    [0xd548af5da49a051d, "up4byre4m82j", 84.548423212, 4.14620179],
    [0x1837ee8716830661, "30vyx1sqhd36", -39.629389674, -126.600413979],
    [0xdd4f4545656f62f3, "vp7nbjc5exjg", 86.999998078, 49.22028134],
    [0x964cbafbf514f382, "kt6cpyzp2mts", -15.25461514, 26.71739498],
    [0xf34f3acab25bcad4, "ye7mpkpkcg5e", 64.182960985, 117.398952217],
    [0xf065c24deb9a8d70, "y1kw4mgcmb6r", 53.117740319, 96.432401637],
    [0x2ec619aea45a9041, "5v31mcp4cb84", -60.24305513, -9.581376279],
    [0xc708acd3b1c88719, "sw4btnxjt23j", 33.874542588, 26.596753989],
    [0x294df0e6f4e6ca37, "556z1trnwv53", -70.45829919, -41.056987347],
    [0x1ddc9ed22ab2c140, "3rf9xnjbqc0n", -1.109569827, -119.918571627],
    [0xac51524778565169, "pj8p4jvsbt8q", -57.799599579, 135.095465704],
    [0xf4415c83448299ae, "yj0pt0u4hbdu", 74.447826008, 90.225427527],
    [0x6f693ef8f6036f0c, "exnmxy7q0erh", 40.377177345, -13.36586707],
    [0x5f996cd6df8dcacf, "cydqtpqzjr5d", 82.746143218, -97.8567109],
    [0xe85493eabf8755f8, "x1b97upzhxbz", 10.086693623, 135.87875728],
    [0x683095724a46d6de, "e0s9bwkb8vce", 3.154566738, -38.643344753],
    [0x03a6c476cdb1cac1, "0fmd8xqeq75d", -76.863897055, -138.484453027],
    [0x98abaafe3ae059d3, "m2pupzjuw1dx", -44.257641111, 67.4971711],
    [0x295d1ba9384d0231, "55fjrb9s9n13", -67.979846954, -41.844819267],
    [0x6626924681293d90, "dsm94jn154yt", 24.109684339, -59.669357088],
    [0x97db31f4f2826ee4, "kzem3x7kh9rf", -1.849129213, 38.390897237],
    [0xef5c08e67385098a, "xxf0jtmmhn4s", 43.623480305, 160.561584291],
    [0xc2364356bd509b28, "s8v46ppxb2ek", 4.654043693, 29.62945558],
    [0xbace5e0bfbf70807, "rc75w2zvyw40", -37.348376371, 173.254332963],
    [0x3ca52949cb50e2e0, "7kkkkkfcb3jf", -20.320281012, -27.582874909],
    [0x0f21f107c4d4cbf3, "1whz21y4um5z", -54.965472754, -105.81188523],
    [0xd67cb677724b7742, "utycdxvk9evn", 77.650787518, 32.109331729],
    [0x4c2b370f2a0f75a3, "9hpmf3tb1xuu", 23.51902423, -124.697843247],
    [0x558cb07eabda4ab5, "bq6c0zpcv95c", 80.37078949, -164.838969411],
    [0x4bb025cfee13ac27, "9fs2cmzf2fq2", 14.226320076, -95.207822174],
    [0xef76c3219029ca32, "xxvd68dh5753", 43.992707306, 165.34712885],
    [0x9f38b42b6978e5fa, "mwwc8bv9g3kz", -8.169399941, 77.032845756],
    [0x72f0a0598ed569de, "fcsb0qdfupnx", 53.47371645, -49.555368985],
    [0x84f290ba5ca6473c, "hmt91fkwnt3m", -58.873300062, 19.067739909],
    [0x52c82f4213e92225, "bc42yhhmx4j2", 50.779763592, -142.816121641],
    [0x5a28098ebd7485d8, "c8n0m3pxfk2x", 45.050792857, -103.82139],
    [0x2fbeb571456a71ac, "5yzcbwb5e9su", -51.685944324, -0.329433087],
    [0xcb084abdd0bdc3cb, "td44pgfhrr1w", 11.622930046, 70.65613622],
    [0x26a5d1f93f2ec370, "4ukx3y9z5v1r", -64.782400728, -49.842404765],
    [0x200ff14b5c390ecc, "407z2kuw747d", -87.292158018, -84.709262704],
    [0x26bc2589ab490608, "4uy2c2ec9430", -63.146397905, -47.400811514],
    [0x3873cb4c570e1fd3, "71twqm2r1sgx", -35.433799715, -36.990554247],
    [0xebca4d9d85dc229d, "xg54v7d5vhj9", 17.378290024, 173.202431629],
    [0xc0e7fafd201dec29, "s3mzpz903rq2", 8.302999354, 19.67794922],
    [0x16139a28ec83e389, "2s9tnb7dhgjs", -18.806860304, -155.088976187],
    [0x1d621ab20b2b869d, "3pj1pdhc5f39", -5.438048394, -127.632473912],
    [0x529925c32b892675, "bbdkchtcj4m7", 48.672364568, -143.033874128],
    [0x312100279fb45cd1, "64hh09wzqjfe", -33.037359284, -84.343496731],
    [0xb698f31b2e85c9f9, "qudg66tfhr4z", -19.102095938, 127.724147198],
    [0x4b2f3e502ad90b7d, "9drmwn1bv45r", 13.656146663, -102.038393248],
    [0x14c4ab17d10052d6, "2m2bq5yj019e", -15.403338363, -167.423398748],
    [0xdaa36c52c5563074, "vbjqsnq5bss7", 46.177578898, 86.316860732],
    [0x334b269d64e9ba01, "6e5ke7c4x6x0", -27.312942377, -62.78517139],
    [0xa9c59fbd20f9ede3, "p72tzg90z7qy", -70.688634478, 147.295394787],
    [0xcf178d69abb4bfdd, "twcsuuecqkzx", 38.828671548, 69.823543596],
    [0xeec4d7b6f385fc4b, "xv2egermhry4", 30.209182737, 169.61708068],
    [0xfef9bec2b74168b0, "zvwvxhpr85nc", 76.927573277, 178.559770132],
    [0x82fd010c7c36f50e, "hcyh233w6vuh", -79.401208739, 42.2006699],
    [0x90304c7a0572573e, "k0s4syh5f9cm", -41.714433839, 5.839342663],
    [0xe7265aac95edb5d7, "wwm5pc4pxqux", 35.690411897, 119.874890029],
    [0x6e6d3f6d3a830e73, "etqmyv9uhd77", 30.572903854, -13.411705761],
    [0x6806b7eebe4702aa, "e03cgvpy8w1b", 1.742481028, -42.363600442],
    [0x718909347ab0ed9b, "f64hke3uq3qt", 57.015660258, -75.73706564],
    [0xa5b9fcc290a68f2a, "nqwzthnhnu7k", -52.09645784, 110.97044813],
    [0x3d51df8f77631890, "7p8xz3vrddd9", -1.439281196, -43.970951053],
    [0x8fc5cc5bfd1f0976, "jz2wsqzx3w4r", -48.037815007, 79.650259764],
    [0x23ae4d21fdce1eac, "4fr4u8gxtsgb", -76.854918639, -46.203448291],
    [0xcd7699f6e6143925, "tpv9mxr62hwk", 43.853713209, 52.986038997],
    [0xbd839fca785bf4dc, "rq1tzkmscgue", -10.215075736, 148.685612989],
    [0x23cb541b2ef39d4d, "4g5p86tfyffn", -71.79241975, -52.012074646],
    [0xcb317aff61947bf8, "tdsrpzv1kjxz", 15.335786045, 73.824187369],
    [0xaf3aa249bd5a3f1e, "pwxb4kexc8zj", -53.411445404, 168.502194984],
    [0x85adfff9ce945988, "hqqzzyffkjds", -53.443950018, 21.08671545],
    [0x80e9914a0ae995c3, "h3nt2khbx6bw", -83.430074116, 20.408446428],
    [0xacd80d95b024f9b2, "pmd0v5eh4mwv", -58.910720965, 149.28645215],
    [0x0b3eaee32b676cfa, "1dzbxstcdxqg", -74.418343233, -101.263959621],
    [0x73dc70fafe7428dc, "fgf71yryfhne", 66.656606812, -52.998295461],
    [0x6ca22551ee31e710, "ekj2bngf67mj", 22.669319337, -26.36193431],
    [0xa7156fb24cd50fbe, "nwbqzdkdun7v", -50.831860422, 113.18750916],
    [0x966dd1fdb3d4799f, "ktqx3zemujwt", -14.152119679, 31.722173125],
    [0xe82f28cfccb955f5, "x0rkjmydr5bz", 2.141368381, 145.435253245],
    [0x994b1eca8598e42a, "m55jxkn5m3k2", -27.135665841, 49.545824561],
    [0xc2989a8ac4dd3628, "sbd9p2q4vnv2", 2.990162826, 37.592690085],
    [0xbb03fe6588be5370, "rd1zwtd8rt9r", -32.4013546, 160.250338844],
    [0x46707f8ae01d559e, "8ts7z2r03pbt", 31.598138408, -151.195177068],
    [0x82810c22be2c4374, "hb0hs8py5j1r", -89.207926313, 33.958527376],
    [0xfa643283823789d1, "z9k350w26y4x", 52.209854162, 163.617102915],
    [0x40cf98697ca34944, "837thucwne4n", 7.937295931, -163.617043147],
    [0x72f51c0f3840da7f, "fcujs3ts83e7", 55.819567774, -50.430663923],
    [0x886a783ebf331d81, "j1p7hgpz6dfs", -83.829916727, 55.414806415],
    [0xd1744a846a060f95, "u5u4p13b0s7t", 66.452202757, 5.93504668],
    [0x98d262612d0866df, "m3964s9e11me", -36.185695913, 58.119786301],
    [0x758a992e16bea42b, "fq59kchqruk2", 78.976315464, -73.613209652],
    [0xf0671a05cd7248a5, "y1mjn1fef94b", 52.920418526, 97.298466149],
    [0x203184c1a23dda7b, "40ss9he27re7", -86.371681441, -83.623322377],
    [0x6f0fa98af6b3f291, "ew7um2rqqgt9", 35.905785508, -16.985596129],
    [0xb7d791ac5bc36e2b, "qzct3c2vser2", -0.475570365, 125.937512405],
    [0xa88f340e61ebafdf, "p27m83m1xfrx", -87.619815767, 150.838508187],
    [0x09cc66f2dc47bb89, "1766ewqw8yxs", -71.243813199, -120.423160037],
    [0x2aeaec5cc7210a84, "5cpfsr674458", -83.895195609, -0.161614424],
    [0xf31f40ec82bf9a45, "ydgn1v42rye4", 61.550981566, 116.799080892],
    [0x78d2e98909900fde, "g39fm289k07x", 53.83597161, -31.057486351],
    [0xd7251a1798f3d1c0, "uwkjn5wsyg8w", 81.055217529, 28.397888676],
    [0x7f689a6a729505c4, "gxn9numkkn2w", 84.574891413, -13.055362002],
    [0x9e848cbcaeb23dfc, "mu28tg5fq8yz", -20.988988351, 79.711248593],
    [0xdde9146e1767d04b, "vrnj8vhrdz84", 85.370590779, 64.726413759],
    [0x3584e42b74651cc1, "6q2f8bvndnfd", -9.399024611, -77.655397862],
    [0xab00d6b541a1236e, "pd0eeeb1n4jq", -78.113982742, 158.357198435],
    [0x98f1f7adead2629f, "m3szgcgbu9j9", -35.190447835, 63.099833072],
    [0xf45a9b7aa162dc09, "yje9qyp1dcf0", 76.190452492, 95.228239831],
    [0xc92d347605072ec4, "t4qm8xh50wrd", 13.662047988, 53.816559915],
    [0xe90c24aa12314dba, "x4629bhk656v", 12.744888498, 138.246893096],
    [0xbfda706bd4919a71, "rze70uynk6e7", -2.257976852, 173.361697995],
    [0xbf4ff3ccbddbd24f, "rx7z7m5xvg94", -2.915520485, 162.921314678],
    [0x93bb3aa4f54eafa3, "kfxmp97p9uru", -30.050416291, 44.279107831],
    [0xdbf38e68c6226ca2, "vgtswu6649qb", 65.502211626, 86.784212219],
    [0xa884bfde7c826187, "p22czrmwh9hs", -88.245271236, 147.631043435],
    [0xbc598052097efa59, "rjds0nh9gvx5", -13.326085557, 138.521975323],
    [0x1ee7ccd966ade607, "3vmwtqc6prm0", -14.288710667, -93.282877549],
    [0xb519db854549d580, "qndxr1b597bs", -7.152851286, 93.823296505],
    [0x72580375ae1f6cc2, "f9d06xef3xqd", 53.523069518, -64.572413659],
    [0x1cd538f5c0d92ecf, "3mbmjxf0v4rd", -11.734630445, -123.153766729],
    [0xcd24cb654abaa9c6, "tnkdqtbbrbnw", 35.583387533, 51.615140932],
    [0x5535a238867022ed, "bnuu4f46f0jf", 83.683333882, -173.196279251],
    [0xeb9773fa0b1cfce3, "xfcr7yhc3myf", 16.776368855, 170.679193354],
    [0x9adc553476ce15e2, "mcf5be3qtsby", -34.478075216, 81.586426445],
    [0xbde2569d635261ac, "rrj5e7c3b9hu", -4.988859709, 153.42581693],
    [0x792897f1d428c7b0, "g4n9gwfn533v", 56.595733587, -35.702677949],
    [0x73e82a8dc4844ddc, "fgn2p3f4hj6x", 61.884985809, -47.13941217],
    [0x4ab393d17c232d0e, "9btt7ncw4dqh", 3.773473221, -93.381613484],
    [0xdbb54722732cfdd8, "vfunf8mm5myx", 61.657537068, 84.492221472],
    [0xa4f5a6b3b2508f4a, "nmuuedxkb27n", -56.850683711, 108.093467466],
    [0x3b65419938882bc5, "7ekn369sj0pw", -25.605696467, -16.817783722],
    [0x3ed4c9fa6186d21b, "7vbdmym1hv91", -12.22620853, -10.287117503],
    [0x9c242523c93de750, "mhk2b8y97rmp", -20.957539528, 51.007607786],
    [0xb0e479e1294a85bc, "q3k7ms999b2v", -37.372481927, 107.470397989],
    [0x142d7e69af5a8109, "2hqrwuegcb0h", -19.750026921, -170.909081513],
    [0x97dda04accb9d482, "kzfu0kqdr7b8", -0.679372693, 37.637412165],
    [0x73f7e28aca62f26f, "fgvy52qbdct6", 67.149905159, -48.01184517],
    [0x427169401d266e2f, "89sqkh0x4tr2", 9.559335427, -151.346852305],
    [0x41c11c91da48dcc3, "870jt4fu93fd", 17.857685358, -168.526439767],
    [0x6a311eb0cdf2efc7, "e8sjxd6eycrw", 3.792308068, -16.541677107],
    [0x025f0def2f9a01da, "09ghvvtgm80x", -79.290517585, -153.020430995],
    [0x1f84cdde6d7d60f8, "3y2dvrmegphg", -9.319844305, -100.308473665],
    [0xed55d0fc523b7fd9, "xpbx1z2k7ezx", 44.864795093, 135.780533096],
    [0xce9e2891de5666bf, "tug2j4fybtmc", 26.735043406, 83.543845107],
    [0xec053bacb3319d44, "xh2mrc5m66fn", 24.835511798, 135.696701124],
    [0x661e8daaaf3f051c, "dsg8vbpg7w2j", 26.851178295, -62.314646062],
    [0xc1108a7e0cea5792, "s488nzhdx9ct", 14.101391545, 1.006259659],
    [0x20c60c2632572ee0, "4330s9jkbwrf", -82.874516947, -77.138754435],
    [0xd13e8de4ec9ee643, "u4z8vt7dmvm4", 60.629839844, 10.793634348],
    [0xcd1f88c44db211de, "tngsjj2eq88x", 38.701275951, 50.142568158],
    [0xa897311f88a80618, "p2cm27w8p031", -84.839170845, 148.028027168],
    [0x94e3a900d523d6c3, "kmjuk06p4gcd", -16.125334261, 19.514585462],
    [0x4b998b216845198d, "9fdsq8c88nds", 14.8138117, -97.446666933],
    [0xa45cd7c974577c07, "njfegkcnbxy0", -56.969777334, 93.659850193],
    [0xc70fe4ca091d41d7, "sw7y9kh93p0x", 36.321054238, 27.834592695],
    [0xfaa13b767a8d78cf, "zbhmqxmujpwd", 45.963404382, 175.020327007],
    [0xe84eb6459d78e63b, "x17cdjdxg3m3", 7.326471593, 140.364908178],
    [0x5ce80d970f017238, "cmn0v5sg05t3", 73.276595962, -115.086243065],
    [0xe487ea81f1a1a99d, "wk3yp0gjn6nt", 24.965927409, 104.022951702],
    [0x42fd74be2552fd18, "8cyr9gj5bcyj", 11.179242863, -137.377126282],
    [0x3f591ab674ee4502, "7xdjpemnxt2h", -1.914596304, -19.350721698],
    [0xaf530fb1a92f4d61, "px9hzde95x6q", -46.963594547, 159.240799607],
    [0xa774a2186f0ce2d0, "nxub463g1mje", -46.393348046, 119.281028812],
    [0x9d423471d932577d, "mp138wft69cr", -5.323337358, 46.783327579],
    [0x53b3d94e8d5ed7fd, "bftxkmnecvcz", 60.365055764, -138.319853393],
    [0x3b10df55c66e64bd, "7d8eypf6etkc", -30.235290663, -21.529956463],
    [0x0b88f2f991a649d7, "1f4g5ydjnt4x", -78.186064249, -97.214988572],
    [0x35b60cf1fa114a17, "6qv0twgu2551", -6.905534565, -71.471896765],
    [0xf9402559c61139bc, "z502bqf624wv", 62.044315389, 135.365647989],
    [0xb23c25df24ecae14, "q8y2crt4xkr1", -40.607763095, 121.351181194],
    [0x638c958bdc88885f, "df69c2ywj245", 12.969017694, -52.670288712],
    [0xd8a32109f9364e7f, "v2jk22gt6t77", 45.752120211, 63.648717296],
    [0x7018de1c997fc3f0, "f0dew74tgz1z", 48.445239681, -86.20612022],
    [0x236371fee0da1283, "4ejr3zr0v898", -71.810629009, -60.030432],
    [0x4f85bf8dbca51034, "9y2vz3ewnn83", 36.17629706, -99.871644637],
    [0x68cd89b1d614756f, "e36smdfq2juq", 7.794531379, -29.989579848],
    [0xef130c7618af7361, "xw9hsxhspxtq", 37.392695721, 159.110512663],
    [0x5ae5c98e557bba69, "cckwm3kpgfx6", 53.138093443, -94.685498089],
    [0x99b4954cdbae93d3, "m6u9bm6vpu9x", -29.193910025, 62.593222637],
    [0xa40c9c1bc5dae495, "nh69s6y5vck9", -65.814321191, 93.710885192],
    [0xd93f62b2ee948a6f, "v4zq5drfkk56", 61.536205285, 55.359951175],
    [0xa248879fd5a01d87, "n948g7ypn0fs", -84.221358244, 116.166947941],
    [0x3e59380d3ad10318, "7tdmh39uu41j", -13.174527042, -19.146593411],
    [0x63b96a790ac9b0c4, "dfwqny8bt6sd", 15.152992768, -47.163045276],
    [0x820085b53473797c, "h808ce9nfewr", -89.847759235, 23.270532141],
    [0x7dedda21b4d95961, "grqxn8env5dq", 87.015643873, -24.319392941],
    [0x50ccabea3618ac93, "b36brujq32q9", 52.098242439, -164.534964038],
    [0xb56b6149f18a3cfd, "qppq2kgjj8yg", -4.499411667, 100.210663982],
    [0x13acb6fe79c814dd, "2fqcezmtt0be", -32.039303886, -136.585249055],
    [0xb4db8ddab5183bdf, "qmesvqpp30xx", -13.193331533, 106.412254154],
    [0x8a88be5899d0fbfe, "jb4cwq4tu3xz", -89.702372758, 82.895472028],
    [0x7ad641d0f0dbda66, "gcc43n7hvge6", 55.274424708, -9.795433536],
    [0x48b1d8a4df19989d, "92sxj96z36d9", 4.051093478, -117.176342049],
    [0xa09f6b397d390ad7, "n2gqqfcx745e", -84.666255048, 106.119136826],
    [0xea013ff5b6ef1a40, "x80mzxeqxwe4", 1.05309195, 158.185941463],
    [0xd1159446b97426d6, "u4bt8jptfhme", 61.464023161, 0.713518053],
    [0x06e649431432476e, "0vm4khsn693q", -60.047442238, -139.037366317],
    [0x4e5a427855c44351, "9te44y2psj1p", 31.324710306, -108.160227343],
    [0x4b60a333573e5078, "9ehb6dur7t87", 16.935326104, -105.704461995],
    [0xd306e7fe10b0b82f, "ud3fgzhhq2w2", 58.178832975, 25.131502473],
    [0xba1cbafb41b357ba, "r8fcpyu1qecv", -40.568154333, 161.713538443],
    [0x1c5a10b27a87ca8e, "3je11dmuhz58", -13.87363482, -130.707226802],
    [0xdc041a849282e0bf, "vh21p14khchc", 69.088216728, 45.310917579],
    [0x532d8f698bc8ebdb, "bdqsyudct3px", 58.516194249, -148.058731954],
    [0x6a912f9642fb9e2d, "eb8kz5k2zfg2", 3.665457361, -10.584646626],
    [0x91196f85d9882b28, "k4dqz1ftj0pk", -29.740504531, 3.475337437],
    [0xc33e239f53570c83, "sdz277umbw68", 15.534315329, 32.843996188],
    [0x95fc72fc9327442d, "kry75z4m4x22", -0.839556753, 20.207055175],
    [0xd11bf954c7ec70b1, "u4ezkp67xjsc", 60.377370058, 5.45261547],
    [0x60549d284d1778ea, "d1b9ub2e2xwf", 10.153338981, -89.087417278],
    [0x1d2823613f06e0bc, "3nn26s9z0vhc", -11.18010674, -126.098632203],
    [0xe3c1a3328de2021d, "wg0u6dnew811", 17.633657768, 124.923757636],
    [0xc6e702731458a85c, "svmh4wsnc2n5", 30.271239887, 40.896668339],
    [0x15b6d4ce183df6d6, "2qve9mhs7rve", -6.38777808, -160.954366589],
    [0x13f49b0af10327b6, "2gu9q2rj0dmv", -23.684278836, -139.637574459],
    [0xaac38ed26089f8cf, "pc1sxnm0j7wd", -83.549632839, 171.174092974],
    [0xf675d0f57afbdd39, "ytux1xcuzgfm", 78.617627186, 118.896782032],
    [0x0fd6fcbbb08964bc, "1zcgtfxhj5kc", -45.776578359, -98.526542771],
    [0xbe6276890f6a9214, "rtj7e28geb91", -16.25641526, 165.026827037],
    [0x5b06f966db6dd517, "cd3gktqverbj", 58.257364882, -109.831899247],
    [0x18e331aa3b914b5e, "33jm3bjvk55p", -38.451229837, -116.282210815],
    [0xc046eaf86fe76e0b, "s13fpy3gwxr0", 7.417784529, 2.804205586],
    [0x7e1c51d81a40f2cf, "gsf53q0u83td", 72.323779052, -19.631520014],
    [0x5a31d6a895ad2c67, "c8sxeb4ppnq6", 49.13209503, -106.004024575],
    [0x5e990b8cb258d9d6, "cudhr35kc3dx", 71.065888201, -98.114376127],
    [0x4c0d89a57abc50ab, "9h6sm9curj8b", 24.663692484, -131.239970832],
    [0x1601ff0218f7a9a1, "2s0zy0hsyynu", -21.136846988, -156.175162065],
    [0xbf32049c1e050c80, "rwt0970y0n68", -8.332066347, 164.587215029],
    [0x0cc7394f878d59c3, "1m3mkmw7jpdw", -59.515129763, -121.796618799],
    [0x9ceb5657b1aea495, "mmppdpxjpuk9", -15.514560492, 66.191592361],
    [0xe8ecc064bd638eb3, "x3qd0t5xdf7c", 7.411578064, 155.417527354],
    [0xc94845958fc85eeb, "t544c5dgt1gf", 17.37823511, 47.860441765],
    [0x162e73dad3dbda84, "2sr77qqmvge8", -20.487122735, -147.153030632],
    [0x9fd11c07adc3314d, "mz8js1xesdsn", -1.83684798, 78.936279607],
    [0x2f5a680f84c9e810, "5xe6h3w4t7n1", -47.452252337, -17.734446758],
    [0x85fff499b8020641, "hrzz96es0834", -45.073469345, 22.208198475],
    [0x88e6740f75bb692f, "j3m783vprenk", -82.342641136, 63.650995808],
    [0x8ee676457490cc25, "jvm7djcnk362", -59.820850195, 86.22226184],
    [0xb83bf1b4a9e12b5d, "r0xz3e59w4pp", -40.89633692, 145.969429068],
    [0x103acfe237c563ce, "20xdzsjrspjw", -41.680802803, -169.11614607],
    [0x0d8b513845e954a6, "1q5p2f25x5bb", -54.962605269, -119.497989511],
    [0x79e643f15f9a7dfc, "g7m47wbzm9yz", 63.715091874, -26.563666145],
    [0xdda60f82cff8b98c, "vqm0z0qgz2ws", 80.290106399, 63.59845697],
    [0xfc9a6920f908ec77, "zke6k87t13q7", 70.710246773, 151.022935077],
    [0x61d6c7e8f3c2ce6c, "d7cdgu7msc76", 21.601445649, -76.47115844],
    [0xd6d2a4b3d0b0a549, "uv9b9dyhq2kn", 76.041228794, 36.285369047],
    [0x196916fe4b898c2b, "35njezkcj662", -27.118193872, -126.390953346],
    [0x187eab6c22d24b8e, "31zbqv12u95s", -35.084703986, -123.803016927],
    [0xeb31e9c99c915c1d, "xdsymkdwk5f1", 15.186945383, 164.41400816],
    [0xfe608597ce123316, "zth8c5yf28tj", 73.27782517, 163.881368338],
    [0xda07a7689a48b408, "v83ufu4u92u0", 47.263960121, 70.085622883],
    [0xb6ade2cc850b4044, "quqy5m451e04", -20.011065173, 133.387820762],
    [0xd7625bf05a4fc885, "uxj5rw2u9z48", 84.981431501, 29.861948302],
    [0xcd19d259cd3da54b, "tndx4qfe7qkn", 37.830640121, 48.618080331],
    [0x0f3cc3c99415c81d, "1wyd7kdn2r41", -51.609912193, -103.213792497],
    [0x5ce1c0d80d28ad6e, "cmhw1q0e52qq", 74.213163915, -117.366108591],
    [0x99f350a84e198649, "m7tp1b2f3634", -24.08025925, 63.35923943],
    [0xb7afe60659cb73c6, "qyryd1kttetw", -8.693341398, 134.742751488],
    [0xc2c75bd6aee3cd48, "sc3prppfwg6n", 8.344563839, 35.474802783],
    [0xff31d72286557c02, "zwsxf8n6bpy0", 82.925318363, 163.946579556],
    [0x33bcb800eea1b83e, "6fych07fn6w3", -29.353738456, -46.576604544],
    [0x5fd13da34250eb75, "cz8mv8u2b3pr", 88.20249749, -100.650881287],
    [0x3ed6314a4a5952af, "7vc32kkbc59b", -12.413029817, -9.474632465],
    [0x75ee6e7b8dff92df, "frr6wywezy9e", 86.25708794, -68.248795376],
    [0x5adb18bc0325fd0f, "ccejjg034ryh", 54.33309979, -96.778116196],
    [0xe8f4ff2087aec428, "x3ugy847pv22", 10.503472855, 153.218755098],
    [0xa669ad8dfdc4a1b1, "ntnuv3gxskhv", -61.029116203, 122.227895734],
    [0x99ddd9c837e22ca3, "m7fxmk1rw8qb", -22.608574423, 59.998342661],
    [0xa1ae87b03f5f2145, "n6r8gd1zcwhn", -77.19956403, 111.953156605],
    [0xaf6c4af2ac9c6494, "pxq4pwpdmjk9", -48.833813833, 166.27761019],
    [0xfc67aad46502884e, "zjmupp350b44", 75.274715856, 143.394963151],
    [0xa849c7cfce677bdf, "p14wgmyfdxxx", -83.156420177, 138.667834659],
    [0xaf17a05cf113bc0a, "pwcu0r7j2fy0", -51.287383562, 159.976084259],
    [0x764fd65365eedfbd, "ft7xdnv5xvgv", 75.88732087, -62.483030113],
    [0x39e7280a0b89e7f6, "77mkh2hcj7mz", -26.015434642, -26.173663656],
    [0xe6614c62c3e001dd, "wthnssq3w00x", 29.291182895, 118.331595326],
    [0xf8e389e43863497d, "z3jsmt1sde4r", 51.400326027, 154.228244707],
    [0x0a1abad2cc793011, "18ecpnqdg4s1", -86.976900779, -106.90988479],
    [0xd2418d7e11b6c582, "u90suzhjqv2s", 51.49934315, 23.417648894],
    [0x92480a8dbc9cfd6a, "k940p3ewmmyq", -39.365655496, 25.636144008],
    [0x33c9cd8b1f69a78f, "6g4wv2sze6ms", -26.934429639, -52.496991862],
    [0x8c1dee9196a2ff64, "jhfyx4dqnczq", -62.123898484, 49.178194037],
    [0x8a00f24e56f8fe99, "j80g4mkqz3z9", -89.442648795, 68.659722351],
    [0x8593f3ae3cbaf84c, "hq9z7cjwrcw4", -52.156511416, 13.883626414],
]


def test_encoding_decoding():
    lon = numpy.array([item[3] for item in testcases])
    lat = numpy.array([item[2] for item in testcases])

    int_hashs = geohash.int64.encode(lon, lat)
    assert numpy.all(
        numpy.array([item[0]
                     for item in testcases], dtype='uint64') == int_hashs)
    decoded_lon, decoded_lat = geohash.int64.decode(int_hashs, round=True)
    assert numpy.all(numpy.abs(lat - decoded_lat) < 1e-7)
    assert numpy.all(numpy.abs(lon - decoded_lon) < 1e-7)

    str_hashs = geohash.encode(lon, lat)
    assert numpy.all([item[1] for item in testcases] == str_hashs.astype("U"))
    decoded_lon, decoded_lat = geohash.decode(str_hashs, round=True)
    assert numpy.all(numpy.abs(lat - decoded_lat) < 1e-6)
    assert numpy.all(numpy.abs(lon - decoded_lon) < 1e-6)
