"""
pyhmc: Hamiltonain Monte Carlo Sampling in Python
=================================================

This package is a straight-forward port of the functions `hmc2.m` and
hmc2_opt.m from the [MCMCstuff](http://www.lce.hut.fi/research/mm/mcmcstuff/)
matlab toolbox written by Aki Vehtari. The code is originally based on the
functions `hmc.m` from the [netlab toolbox](http://www.ncrg.aston.ac.uk/netlab/index.php)
written by Ian T Nabney. The portion of algorithm involving "windows" is
derived from the C code for this function included in the
[Software for Flexible Bayesian Modeling](http://www.cs.toronto.edu/~radford/fbm.software.html)
written by Radford Neal.

The original Python [port](https://github.com/koepsell/pyhmc) was made
by Kilian Koepsell, and subsequently modernized by Robert T. McGibbon.

Authors
-------
- Kilian Koepsell <kilian@berkeley.edu>
- Robert T. McGibbon <rmcgibbo@gmail.com>
"""

from __future__ import absolute_import
from ._version import get_versions
__version__ = get_versions()['version']
del get_versions
from .hmc import hmc
from .autocorr1 import integrated_autocorr1
from .autocorr2 import integrated_autocorr2
from .autocorr3 import integrated_autocorr3
from .autocorr4 import integrated_autocorr4
from .autocorr5 import integrated_autocorr5
from .autocorr6 import integrated_autocorr6
