/* -*- buffer-read-only: t -*- vi: set ro:
 *
 * DO NOT EDIT THIS FILE   (C_Worhp_Data.h)
 *
 * It has been AutoGen-ed
 * From the definitions    ../src/auto/def/worhp_data.def
 * and the template file   C_Worhp_Data.tpl */

#include <stdlib.h> /* For size_t */

#ifndef HEADER_C_WORHP_DATA_H_GUARD
#define HEADER_C_WORHP_DATA_H_GUARD 1

#ifdef __cplusplus
extern "C" {
#endif

#include "C_std.h"
#include "C_cs.h"
#include "C_timer.h"
#include "C_qp_data.h"
#include "C_filter_data.h"
#include "C_worhp_queue.h"

#define PATCH_STRING_LENGTH 8

extern const int worhp_major;
extern const int worhp_minor;
extern const char worhp_patch[PATCH_STRING_LENGTH];

extern const int nMemberOptVar;
extern const int nMemberHideOptVar;
extern const int nMemberWorkspace;
extern const int nMemberHideWorkspace;
extern const int nMemberParams;
extern const int nMemberHideParams;
extern const int nMemberControl;
extern const int nMemberHideControl;

/* Used in conditional for allocating the opt->G members. */
extern const int minM;

enum {
 /* WORHP NLP: modification strategy using no slacks */
  WORHP_NLP_MODTYPESLACKS_NONE = 0,
 /* WORHP NLP: modification strategy using slacks for inequalities */
  WORHP_NLP_MODTYPESLACKS_IEQ = 1,
 /* WORHP NLP: modification strategy using user objective */
  WORHP_NLP_MODTYPEOBJ_STD = 1,
 /* WORHP NLP: modification strategy using user objective as constraint with additional slack */
  WORHP_NLP_MODTYPEOBJ_CON = 2,
 /* WORHP NLP: do not check for nan or inf */
  WORHP_NLP_CHECKNANINF_NONE = 0,
 /* WORHP NLP: stop with error message if nan or inf found */
  WORHP_NLP_CHECKNANINF_STOP = 1,
 /* WORHP NLP: replace nan or inf with something */
  WORHP_NLP_CHECKNANINF_REPLACE = 2,
 /* WORHP NLP: index type original x */
  WORHP_NLP_IDXTYPE_X_ORIGX = 1,
 /* WORHP NLP: index type original g */
  WORHP_NLP_IDXTYPE_G_ORIGG = 2,
 /* WORHP NLP: index type original df */
  WORHP_NLP_IDXTYPE_DF_ORIGDF = 3,
 /* WORHP NLP: index type original dg */
  WORHP_NLP_IDXTYPE_DG_ORIGDG = 4,
 /* WORHP NLP: index type original hm */
  WORHP_NLP_IDXTYPE_HM_ORIGHM = 5,
 /* WORHP NLP: index type objective slack in x */
  WORHP_NLP_IDXTYPE_X_OBJSLACK = 6,
 /* WORHP NLP: index type objective constraint */
  WORHP_NLP_IDXTYPE_G_OBJCON = 7,
 /* WORHP NLP: index type gradient df w.r.t. objective slack */
  WORHP_NLP_IDXTYPE_DF_OBJSLACK = 8,
 /* WORHP NLP: index type gradient of objective constraint w.r.t. objective slack */
  WORHP_NLP_IDXTYPE_DG_OBJCONOBJSLACK = 9,
 /* WORHP NLP: index type gradient of objective constraint w.r.t. x */
  WORHP_NLP_IDXTYPE_DG_OBJCONORIGDF = 10,
 /* WORHP NLP: index type hessian of objective slack */
  WORHP_NLP_IDXTYPE_HM_OBJSLACK = 11,
 /*-----------------------------------------------------------------
  *  WORHP IP: general settings
  *-----------------------------------------------------------------*/
 /* WORHP IP: standard modification (slacks for inequality constraints) */
  WORHP_IP_NLPMODTYPE_SLACK = 1,
 /*-----------------------------------------------------------------
  *  WORHP IP: step types
  *-----------------------------------------------------------------*/
 /* WORHP IP: step undefined */
  WORHP_IP_STEP_UNDEF = 0,
 /* WORHP IP: step selection (step std / adaptive) */
  WORHP_IP_STEP = 1,
 /* WORHP IP: step selection (step std) */
  WORHP_IP_STEP_STD = 2,
 /* WORHP IP: step selection (second-order-correction) */
  WORHP_IP_STEP_CORRECT = 3,
 /* WORHP IP: step selection (refinement) */
  WORHP_IP_STEP_REFINE = 4,
 /* WORHP IP: step selection (sensitivity step bar) */
  WORHP_IP_STEP_SENSBAR = 5,
 /* WORHP IP: step selection (sensitivity step bar) */
  WORHP_IP_STEP_SENSBARSHIFT = 6,
 /* WORHP IP: step selection (sensitivity step pen obj) */
  WORHP_IP_STEP_SENSPENOBJ = 7,
 /* WORHP IP: step selection (sensitivity step pen feas) */
  WORHP_IP_STEP_SENSPENFEAS = 8,
 /* WORHP IP: step selection (sensitivity step aug mu) */
  WORHP_IP_STEP_SENSAUGMU = 9,
 /*-----------------------------------------------------------------
  *  WORHP IP: Barrier / Penalty Parameter
  *-----------------------------------------------------------------*/
 /* WORHP IP: adaptive augmented mu update (none). */
  WORHP_IP_AUGMUTRIAL_NONE = 0,
 /* WORHP IP: adaptive augmented mu update (update). */
  WORHP_IP_AUGMUTRIAL_UPDATE = 1,
 /* WORHP IP: adaptive augmented mu update (reset). */
  WORHP_IP_AUGMUTRIAL_RESET = 2,
 /* WORHP IP: adaptive augmented lambda update (none). */
  WORHP_IP_AUGLAMBDATRIAL_NONE = 0,
 /* WORHP IP: adaptive augmented lambda update (update). */
  WORHP_IP_AUGLAMBDATRIAL_UPDATE = 1,
 /* WORHP IP: adaptive augmented lambda update (reset). */
  WORHP_IP_AUGLAMBDATRIAL_RESET = 2,
 /* WORHP IP: adaptive augmented lambda update (single dimension). */
  WORHP_IP_AUGLAMBDATRIAL_SINGLE = 3,
 /*-----------------------------------------------------------------
  *  WORHP IP: parameter options
  *-----------------------------------------------------------------*/
 /* WORHP IP: Barrier type log function. */
  WORHP_IP_BARRIERTYPE_LOG = 1,
 /* WORHP IP: Barrier type log-lin function. */
  WORHP_IP_BARRIERTYPE_LOGLIN = 2,
 /* WORHP IP: Barrier type log function with shifts. */
  WORHP_IP_BARRIERTYPE_LOGSHIFT = 3,
 /* WORHP IP: Barrier type log function with shifts and augmented duals. */
  WORHP_IP_BARRIERTYPE_LOGAUG = 4,
 /* WORHP IP: barrier update conservative */
  WORHP_IP_BARRIERUPDATE_MONO = 1,
 /* WORHP IP: barrier update loqo rule */
  WORHP_IP_BARRIERUPDATE_LOQO = 2,
 /* WORHP IP: barrier update mehrotra probing */
  WORHP_IP_BARRIERUPDATE_MEHROTRA = 3,
 /* WORHP IP: barrier update quality function */
  WORHP_IP_BARRIERUPDATE_QUALITY = 4,
 /* WORHP IP: Penalty type classic interior-point */
  WORHP_IP_PENALTYTYPE_NONE = 1,
 /* WORHP IP: Penalty type l2-penalty-interior-point */
  WORHP_IP_PENALTYTYPE_L2 = 2,
 /* WORHP IP: Penalty type augmented Lagrangian penalty-interior-point */
  WORHP_IP_PENALTYTYPE_AUGLAGR = 3,
 /* WORHP IP: penalty update conservative */
  WORHP_IP_PENALTYUPDATE_CONSERV = 1,
 /* WORHP IP: penalty update adaptive */
  WORHP_IP_PENALTYUPDATE_ADAPT = 2,
 /* WORHP IP: penalty update conservative and adaptive */
  WORHP_IP_PENALTYUPDATE_CONSERVADAPT = 3,
 /* WORHP IP: Penalty position in front of constraint violation */
  WORHP_IP_PENALTYPOSITION_FEAS = 1,
 /* WORHP IP: Penalty position in front of barrier objective */
  WORHP_IP_PENALTYPOSITION_OBJ = 2,
 /* WORHP IP: Penalty position in front of barrier objective and constraint violation */
  WORHP_IP_PENALTYPOSITION_BOTH = 3,
 /* WORHP IP: conservative update strategy for augmented duals */
  WORHP_IP_AUGUPDATE_CONSERV = 1,
 /* WORHP IP: adaptive update strategy for augmented duals */
  WORHP_IP_AUGUPDATE_ADAPT = 2,
 /* WORHP IP: merit function as check for adaptive updates */
  WORHP_IP_ADAPTCHECKMETHOD_MERIT = 1,
 /* WORHP IP: filter as check for adaptive updates */
  WORHP_IP_ADAPTCHECKMETHOD_FILTER = 2,
 /* WORHP IP: line search method none */
  WORHP_IP_LINEMETHOD_NONE = 0,
 /* WORHP IP: line search method full step */
  WORHP_IP_LINEMETHOD_FULL = 1,
 /* WORHP IP: line search method filter */
  WORHP_IP_LINEMETHOD_FILTER = 2,
 /* WORHP IP: line search method merit */
  WORHP_IP_LINEMETHOD_MERIT = 3,
 /* WORHP IP: line search method filter and merit */
  WORHP_IP_LINEMETHOD_FILTERMERIT = 4,
 /* WORHP IP: line search method merit kkt */
  WORHP_IP_LINEMETHOD_MERITKKT = 5,
 /* WORHP IP: Envelope type based on feasibility */
  WORHP_IP_LINEFILTERENVELOPE_FEAS = 1,
 /* WORHP IP: Envelope type based on kkt conditions */
  WORHP_IP_LINEFILTERENVELOPE_KKT = 2,
 /* WORHP IP: do not check for nan or inf */
  WORHP_IP_CHECKNANINF_NONE = 0,
 /* WORHP IP: stop with error message if nan or inf found */
  WORHP_IP_CHECKNANINF_STOP = 1,
 /* WORHP IP: replace nan or inf with something */
  WORHP_IP_CHECKNANINF_REPLACE = 2,
 /* WORHP IP: no leq block elimination */
  WORHP_IP_LEQREDUCE_NONE = 1,
 /* WORHP IP: dual leq block elimination */
  WORHP_IP_LEQREDUCE_DUAL = 2,
 /* WORHP IP: init method for box duals (user) */
  WORHP_IP_INITMETHODDUALBOX_USER = 1,
 /* WORHP IP: init method for box duals (fixed value) */
  WORHP_IP_INITMETHODDUALBOX_FIXED = 2,
 /* WORHP IP: init method for box duals (min complementarity) */
  WORHP_IP_INITMETHODDUALBOX_COMPL = 3,
 /* WORHP IP: init method for duals (user) */
  WORHP_IP_INITMETHODDUAL_USER = 1,
 /* WORHP IP: init method for duals (fixed) */
  WORHP_IP_INITMETHODDUAL_FIXED = 2,
 /* WORHP IP: init method for duals (dual box) */
  WORHP_IP_INITMETHODDUAL_DUALBOX = 3,
 /* WORHP IP: dual regularization method (none) */
  WORHP_IP_REGMETHODDUAL_NONE = 0,
 /* WORHP IP: dual regularization method (all) */
  WORHP_IP_REGMETHODDUAL_ALL = 1,
 /* WORHP IP: dual regularization method (linear dependent by big value) */
  WORHP_IP_REGMETHODDUAL_DEPENDBIG = 2,
 /* WORHP IP: dual regularization method (linear dependent by removing) */
  WORHP_IP_REGMETHODDUAL_DEPENDREMOVE = 3,
 /* WORHP IP: no refinement step */
  WORHP_IP_REFINESTEP_NONE = 0,
 /* WORHP IP: affine refinement step */
  WORHP_IP_REFINESTEP_AFFINE = 1,
 /* WORHP IP: primal-dual refinement step */
  WORHP_IP_REFINESTEP_PRIMALDUAL = 2,
 /* WORHP IP: update strategy for barrier shift: barrier update but max possible */
  WORHP_IP_BARRIERSHIFTUPDATE_MAX = 1,
 /* WORHP IP: update strategy for barrier shift: barrier update but balanced */
  WORHP_IP_BARRIERSHIFTUPDATE_BALANCED = 2,
 /* WORHP IP: update strategy for barrier shift: barrier update */
  WORHP_IP_BARRIERSHIFTUPDATE_FORCE = 3,
 /* WORHP IP: update strategy for barrier shift: barrier update but max possible based on fraction-to-the-boundary rule */
  WORHP_IP_BARRIERSHIFTUPDATE_FRACTOBOUNDMAX = 4,
 /* WORHP IP: update strategy for barrier shift: barrier update based on fraction-to-the-boundary rule */
  WORHP_IP_BARRIERSHIFTUPDATE_FRACTOBOUNDFORCE = 5,
 /* WORHP IP: update strategy for barrier shift: project into original feasible region */
  WORHP_IP_BARRIERSHIFTUPDATE_BOUNDARYFORCE = 6,
 /* WORHP IP: initialization of augmented duals for barrier function: one */
  WORHP_IP_BARRIERINITAUG_ONE = 1,
 /* WORHP IP: initialization of augmented duals for barrier function: lambda */
  WORHP_IP_BARRIERINITAUG_LAMBDA = 2,
 /* WORHP IP: initialization of augmented duals for penalty function: zero */
  WORHP_IP_PENALTYINITAUG_ZERO = 1,
 /* WORHP IP: initialization of augmented duals for penalty function: mu */
  WORHP_IP_PENALTYINITAUG_MU = 2,
 /* WORHP IP: initialization of augmented duals for penalty function: constraints */
  WORHP_IP_PENALTYINITAUG_CON = 3,
 /* WORHP IP: update of augmented duals in barrier function: alone, no barrier update */
  WORHP_IP_BARRIERUPDATEAUG_JUSTAUG = 1,
 /* WORHP IP: update of augmented duals in barrier function: always together with the barrier parameter */
  WORHP_IP_BARRIERUPDATEAUG_COMBINED = 2,
 /* WORHP IP: update of augmented duals in barrier function: alone based on complementarity */
  WORHP_IP_BARRIERUPDATEAUG_COMPL = 3,
 /* WORHP IP: update of augmented duals in barrier function: alone based on complementarity */
  WORHP_IP_BARRIERUPDATEAUG_COMPLCOMBINED = 4,
 /* WORHP IP: check infeasibility: none */
  WORHP_IP_CHECKINFEAS_NONE = 0,
 /* WORHP IP: check infeasibility: exit as soon as possible */
  WORHP_IP_CHECKINFEAS_EXIT = 1,
 /* WORHP IP: check infeasibility: exit in case of failure */
  WORHP_IP_CHECKINFEAS_EXITFAIL = 2,
 /* WORHP IP: check fritz-john: none */
  WORHP_IP_CHECKFRITZJOHN_NONE = 0,
 /* WORHP IP: check fritz-john: exit as soon as possible */
  WORHP_IP_CHECKFRITZJOHN_EXIT = 1,
 /* WORHP IP: check fritz-john: exit in case of failure */
  WORHP_IP_CHECKFRITZJOHN_EXITFAIL = 2,
 /*-----------------------------------------------------------------
  *  WORHP IP: linear equation system
  *-----------------------------------------------------------------*/
 /* WORHP IP: standard linear equation system */
  WORHP_IP_LEQTYPE_STD = 1,
 /* WORHP IP: linear equation system for multiplier estimation */
  WORHP_IP_LEQTYPE_EST = 2,
 /* WORHP IP: solves the standard step */
  WORHP_IP_LEQSOLVEMODE_STEP = 1,
 /* WORHP IP: solves the standard step (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_STEPITREF = 2,
 /* WORHP IP: solves the standard step */
  WORHP_IP_LEQSOLVEMODE_STEPSTD = 3,
 /* WORHP IP: solves the standard step (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_STEPSTDITREF = 4,
 /* WORHP IP: solves the step for WORHP Zen */
  WORHP_IP_LEQSOLVEMODE_SENS = 5,
 /* WORHP IP: solves the step for WORHP Zen (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_SENSITREF = 6,
 /* WORHP IP: solves the second-order-correction step */
  WORHP_IP_LEQSOLVEMODE_CORRECT = 7,
 /* WORHP IP: solves the second-order-correction step (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_CORRECTITREF = 8,
 /* WORHP IP: solves the multiplier estimation */
  WORHP_IP_LEQSOLVEMODE_EST = 9,
 /* WORHP IP: solves the multiplier estimation (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_ESTITREF = 10,
 /* WORHP IP: solves the centering step */
  WORHP_IP_LEQSOLVEMODE_CENTER = 11,
 /* WORHP IP: solves the centering step (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_CENTERITREF = 12,
 /* WORHP IP: solves the step for the sensitivity analysis after warmstart */
  WORHP_IP_LEQSOLVEMODE_SENSWARM = 13,
 /* WORHP IP: solves the step for the sensitivity analysis after warmstart (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_SENSWARMITREF = 14,
 /* WORHP IP: solves the refinement step */
  WORHP_IP_LEQSOLVEMODE_REFINE = 15,
 /* WORHP IP: solves the refinement step (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_REFINEITREF = 16,
 /* WORHP IP: solves the sensitivity step w.r.t. the barrier parameter */
  WORHP_IP_LEQSOLVEMODE_STEPSENSBAR = 17,
 /* WORHP IP: solves the sensitivity step w.r.t. the barrier parameter (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_STEPSENSBARITREF = 18,
 /* WORHP IP: solves the sensitivity step w.r.t. the barrier shift parameter */
  WORHP_IP_LEQSOLVEMODE_STEPSENSBARSHIFT = 19,
 /* WORHP IP: solves the sensitivity step w.r.t. the barrier shift parameter (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_STEPSENSBARSHIFTITREF = 20,
 /* WORHP IP: solves the sensitivity step w.r.t. the objective penalty parameter */
  WORHP_IP_LEQSOLVEMODE_STEPSENSPENOBJ = 21,
 /* WORHP IP: solves the sensitivity step w.r.t. the objective penalty parameter (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_STEPSENSPENOBJITREF = 22,
 /* WORHP IP: solves the sensitivity step w.r.t. the feasibility penalty parameter */
  WORHP_IP_LEQSOLVEMODE_STEPSENSPENFEAS = 23,
 /* WORHP IP: solves the sensitivity step w.r.t. the feasibility penalty parameter (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_STEPSENSPENFEASITREF = 24,
 /* WORHP IP: solves the sensitivity step w.r.t. the augmented mu parameter */
  WORHP_IP_LEQSOLVEMODE_STEPSENSAUGMU = 25,
 /* WORHP IP: solves the sensitivity step w.r.t. the augmented mu parameter (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_STEPSENSAUGMUITREF = 26,
 /* WORHP IP: current right-hand-side is unknown */
  WORHP_IP_LEQCURRRHS_NONE = 0,
 /* WORHP IP: current right-hand-side is the one for StepStd */
  WORHP_IP_LEQCURRRHS_STEPSTD = 1,
 /* WORHP IP: current right-hand-side is the one for multiplier estimation */
  WORHP_IP_LEQCURRRHS_EST = 4,
 /* WORHP IP: current right-hand-side is the one for WORHP Zen, perturbation of type P */
  WORHP_IP_LEQCURRRHS_SENSP = 5,
 /* WORHP IP: current right-hand-side is the one for WORHP Zen, perturbation of type R */
  WORHP_IP_LEQCURRRHS_SENSR = 6,
 /* WORHP IP: current right-hand-side is the one for WORHP Zen, perturbation of type Q */
  WORHP_IP_LEQCURRRHS_SENSQ = 7,
 /* WORHP IP: current right-hand-side is the one for WORHP Zen, perturbation of type B */
  WORHP_IP_LEQCURRRHS_SENSB = 8,
 /*-----------------------------------------------------------------
  *  WORHP Line: methods
  *-----------------------------------------------------------------*/
 /* WORHP Line: method not specified */
  WORHP_LINE_METHOD_NONE = 0,
 /* WORHP Line: method full step, backtracking line search disabled */
  WORHP_LINE_METHOD_FULL = 1,
 /* WORHP Line: method filter. */
  WORHP_LINE_METHOD_FILTER = 2,
 /* WORHP Line: method merit function. */
  WORHP_LINE_METHOD_MERIT = 3,
 /* WORHP Line: method merit kkt function. */
  WORHP_LINE_METHOD_MERITKKT = 4,
 /*-----------------------------------------------------------------
  *  WORHP Line: phases
  *-----------------------------------------------------------------*/
 /* WORHP Line: phase global. */
  WORHP_LINE_PHASE_GLOBAL = 1,
 /* WORHP Line: phase local. */
  WORHP_LINE_PHASE_LOCAL = 2,
 /*-----------------------------------------------------------------
  *  WORHP Line: modes
  *-----------------------------------------------------------------*/
 /* WORHP Line: standard. */
  WORHP_LINE_MODE_STD = 1,
 /* WORHP Line: second-order-corrections. */
  WORHP_LINE_MODE_CORRECT = 2,
 /* WORHP Line: refinement steps. */
  WORHP_LINE_MODE_REFINE = 3,
 /* WORHP Line: backup. */
  WORHP_LINE_MODE_BACKUP = 4,
 /*-----------------------------------------------------------------
  *  WORHP Line: status
  *-----------------------------------------------------------------*/
 /* stages status: everything is fine, continue. */
  WORHP_LINE_OK = 100,
 /* stages status: full step size (ONE) is acceptable. */
  WORHP_LINE_ACCEPTED_FULLSTEP = 200,
 /* stages status: full step size (AlphaMax) is acceptable. */
  WORHP_LINE_ACCEPTED_MAXSTEP = 300,
 /* stages status: step size is acceptable. */
  WORHP_LINE_ACCEPTED = 400,
 /* stages status: step size is not acceptable. */
  WORHP_LINE_NOTACCEPTED = 500,
 /* stages status: full step size is not acceptable. */
  WORHP_LINE_NOTACCEPTED_FULLSTEP = 600,
 /* stages status: NaN evaluation. */
  WORHP_LINE_NAN = 700,
 /* stages status: minimum step size reached. */
  WORHP_LINE_MINSTEPSIZE = 800,
 /* stages status: line search was aborted. */
  WORHP_LINE_ABORTED = 900,
 /* stages status: otherwise. */
  WORHP_LINE_ELSE = 1000,
 /*-----------------------------------------------------------------
  *  WORHP Zen: RC flags
  *-----------------------------------------------------------------*/
  WORHP_ZEN_RC_INIT = 0,
  WORHP_ZEN_RC_RENEW_LU = 1,
  WORHP_ZEN_RC_DGP = 2,
  WORHP_ZEN_RC_DLP = 3,
  WORHP_ZEN_RC_DLXP = 4,
  WORHP_ZEN_RC_DLPP = 5,
 /*-----------------------------------------------------------------
  *  WORHP Zen: parameters
  *-----------------------------------------------------------------*/
 /* do not store sensitivity in matrices, use just temporary until calculation of next sensitivity */
  WORHP_ZEN_STORE_TMP = 1,
 /* store sensitivities in matrices in dense format */
  WORHP_ZEN_STORE_DENSE = 2,
 /* store sensitivities in matrices in sparse format based on active set */
  WORHP_ZEN_STORE_SPARSE = 3,
 /*-----------------------------------------------------------------
  *  Array sizes
  *-----------------------------------------------------------------*/
  WMTslices = 100,
  WMTrows = 6,
  WMTnames = 20,
  NAres = 7,
  NUserAction = 14,
  NStageHistory = 10,
 /*-----------------------------------------------------------------
  *  Feasibility mode flags
  *-----------------------------------------------------------------*/
  FEAS_MODE_OFF = 0,
  FEAS_MODE_INITIAL = 1,
 /* was: JustFeasible */
  FEAS_MODE_NOOBJ = 2,
 /* was: FeasModeActive */
  FEAS_MODE_DUAL = 4,
 /*-----------------------------------------------------------------
  *  NLP algorithm flag
  *-----------------------------------------------------------------*/
  ALGORITHM_SQP = 1,
  ALGORITHM_IP = 2,
  WORHP_HESSIAN_USER = 0,
  WORHP_HESSIAN_FIDIF = 1,
  WORHP_HESSIAN_BFGS = 2,
 /*-----------------------------------------------------------------
  *  Function type flags
  *-----------------------------------------------------------------*/
  WORHP_CONSTANT = 1,
  WORHP_LINEAR = 2,
  WORHP_QUADRATIC = 3,
  WORHP_NONLINEAR = 4,
 /*-----------------------------------------------------------------
  *  User action constants
  *-----------------------------------------------------------------*/
  callWorhp = 1,
  evalF = 2,
  evalG = 3,
  evalDF = 4,
  evalDG = 5,
  evalHM = 6,
  evalZenDGp = 7,
  evalZenDLxp = 8,
  evalZenDLp = 9,
  evalZenDLpp = 10,
  iterOutput = 11,
  fidif_DF = 12,
  fidif_DG = 13,
  fidif_HM = 14,
 /* Not actually a user action, but a combination of all fidif_* */
  fidif = 15,
 /*-----------------------------------------------------------------
  *  SQP status constants
  *-----------------------------------------------------------------*/
 /* 1st call to SQP */
  FirstCall = 20,
 /* SQP is iterating */
  Iterating = 21,
 /* SQP is iterating */
  IteratingAres = 22,
 /* 1st Armijo call in current major iter */
  ArmijoFirstCall = 23,
 /* Armijo updates x and flags user action */
  ArmijoUpdate = 24,
 /* Armijo evaluates merit function */
  ArmijoEvaluate = 25,
 /* QP solver wants to try an SLP step */
  SolverSLP = 26,
 /* Setting up Zen */
  ZenSetup = 27,
 /*-----------------------------------------------------------------
  *  stage status
  *-----------------------------------------------------------------*/
 /* stage status: no status set = stage not entered yet */
  WORHP_UNDEFINED = 28,
 /* stage status: everything fine, continue. */
  WORHP_OK = 29,
 /* stage status: nothing fine, maybe stop. */
  WORHP_FAIL = 30,
 /* stage status: otherwise. */
  WORHP_ELSE = 31,
 /* stage status: optimal solution found. */
  WORHP_OPTIMAL = 32,
 /* stage status: optimal solution found of modified problem. */
  WORHP_MODOPTIMAL = 33,
 /* stage status: tolerances met for crossover. */
  WORHP_CROSSOVEROPTIMAL = 34,
 /* stage status: optimal solution found by lowpass filter. */
  WORHP_LOWPASSOPTIMAL = 35,
 /* stage status: optimal solution found of barrier problem. */
  WORHP_BARRIEROPTIMAL = 36,
 /* stage status: optimal solution found of penalty problem. */
  WORHP_PENALTYOPTIMAL = 37,
 /* stage status: search direction is zero. */
  WORHP_STEPZERO = 38,
 /* stage status: update is too small. */
  WORHP_STEPSMALL = 39,
 /* stage status: too big. */
  WORHP_TOOBIG = 40,
 /* stage status: unbounded problem. */
  WORHP_UNBOUNDED = 41,
 /* stage status: iterates diverge. */
  WORHP_DIVERGENCE_PRIMAL = 42,
 /* stage status: iterates diverge. */
  WORHP_DIVERGENCE_DUAL = 43,
 /* stage status: penalty parameter diverges. */
  WORHP_DIVERGENCE_PENALTY = 44,
 /* stage status: NaN evaluation. */
  WORHP_NAN = 45,
 /* stage status: kkt matrix not positive definite. */
  WORHP_NOTPOSDEF = 46,
 /* stage status: kkt matrix singular. */
  WORHP_SINGULAR = 47,
 /* stage status: kkt matrix singular due to constraints. */
  WORHP_SINGULAR_DUAL = 48,
 /* stage status: infeasible problem. */
  WORHP_INFEASIBLEOPTIMAL = 49,
 /* stage status: infeasible problem. */
  WORHP_INFEASIBLE = 50,
 /* stage status: fritz john point. */
  WORHP_FRITZJOHN = 51,
 /* stage status: indicates that barrier has been updated */
  WORHP_UPDATED_BARRIER = 52,
 /* stage status: indicates that penalty has been updated */
  WORHP_UPDATED_PENALTY = 53,
 /* stage status: indicates that aug duals have been updated */
  WORHP_UPDATED_AUGDUALS = 54,
 /* stage status: indicates that aug duals have been updated and penalty has been reduced */
  WORHP_UPDATED_AUGDUALS_PENALTY = 55,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_start = 200,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_fi = 201,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_fij = 202,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_fdiag = 203,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_gi = 204,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_hgr = 205,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_hgrsgr = 206,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_gij = 207,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_gdiag = 208,
 /* mja: Start status for fidif method without groups */
  fidif_start = 209,
 /* mja: Status for evaluation of the positive side of the difference */
  fidif_posside = 210,
 /* mja: Status for evaluation of the negative side of the difference */
  fidif_negside = 211,
 /* mja: Status for evaluation of f or g in x0 for HM */
  fidif_hm_in_x0 = 212,
 /* mja: Status for evaluation of f or g perturbed in 2 components for HM */
  fidif_hm_2components = 213,
 /* mja: Status for evaluation of positive perturbed df or dg for HM */
  fidif_hm_userdfdg_posside = 214,
 /* mja: Status for evaluation of negative perturbed df or dg for HM */
  fidif_hm_userdfdg_negside = 215,
 /* mja: End status for fidif method without groups */
  fidif_end = 216,
 /*-----------------------------------------------------------------
  *  Armijo recovery strategies
  *-----------------------------------------------------------------*/
 /* Armijo recovery strategy: SLP step */
  AresSLP = 41,
 /* Armijo recovery strategy: Non-monotone */
  AresNonMon = 42,
 /* Armijo recovery strategy: Force 1 */
  AresForce = 43,
 /* Armijo recovery strategy: Switch to dual-feas-mode */
  AresFeas = 44,
 /* Give up */
  AresGiveUp = 50,
 /*-----------------------------------------------------------------
  *  SQP stages
  *-----------------------------------------------------------------*/
  No_Stage = 100,
  Init_Data = 101,
  WORHP_STAGE_NLP_INIT = 102,
  WORHP_STAGE_RESTART = 103,
  WORHP_STAGE_CROSSOVER = 104,
  Pre_KKT = 105,
  Check_KKT = 106,
  Create_QP = 107,
  Hessian_Regularisation = 108,
  Solve_QP = 109,
  Post_QP = 110,
  Find_Stepsize = 111,
  Update_Point = 112,
  Recovery_Strategies = 113,
  Finalise = 114,
  SLP_step = 115,
  Solve_Feasibility_QP = 116,
  Post_Optimum = 117,
  Pre_BStep = 118,
  BStep = 119,
  Post_QP_Sens = 120,
  WORHP_STAGE_IP_INIT_RESTART = 121,
  WORHP_STAGE_IP_INIT_PREPARE = 122,
  WORHP_STAGE_IP_INIT_MODIFY = 123,
  WORHP_STAGE_IP_INIT_PARAMETER = 124,
  WORHP_STAGE_IP_INIT_ESTIMATE = 125,
  WORHP_STAGE_IP_INIT_CENTERING = 126,
  WORHP_STAGE_IP_INIT_FINALIZE = 127,
  WORHP_STAGE_IP_CHECK_PREPARE = 129,
  WORHP_STAGE_IP_CHECK_ADAPT = 130,
  WORHP_STAGE_IP_CHECK = 131,
  WORHP_STAGE_IP_CHECK_INFEAS = 132,
  WORHP_STAGE_IP_CHECK_BARRIER = 133,
  WORHP_STAGE_IP_CHECK_PENALTY = 134,
  WORHP_STAGE_IP_UPDATE_BARRIER = 135,
  WORHP_STAGE_IP_UPDATE_PENALTY = 136,
  WORHP_STAGE_IP_LEQ_PREPARE = 137,
  WORHP_STAGE_IP_LEQ_CREATE = 138,
  WORHP_STAGE_IP_LEQ_REGULARIZE = 139,
  WORHP_STAGE_IP_LEQ_IMPROVE = 140,
  WORHP_STAGE_IP_LEQ_CHECK = 141,
  WORHP_STAGE_IP_ADAPT_PREPARE = 142,
  WORHP_STAGE_IP_ADAPT_BARRIER = 143,
  WORHP_STAGE_IP_ADAPT_PENALTY = 144,
  WORHP_STAGE_IP_ADAPT_SELECT = 145,
  WORHP_STAGE_IP_STEP = 146,
  WORHP_STAGE_IP_LINE_PREPARE = 147,
  WORHP_STAGE_IP_LINE_BACKUP_PREPARE = 148,
  WORHP_STAGE_IP_LINE_CHECK = 149,
  WORHP_STAGE_IP_LINE_UPDATEPRIMAL = 150,
  WORHP_STAGE_IP_LINE_UPDATEDUAL = 151,
  WORHP_STAGE_IP_LINE_REDUCEPRIMAL = 152,
  WORHP_STAGE_IP_LINE_REDUCEDUAL = 153,
  WORHP_STAGE_IP_UNBLOCK = 154,
  WORHP_STAGE_IP_REFINE_PREPARE = 155,
  WORHP_STAGE_IP_REFINE_STEP = 156,
  WORHP_STAGE_IP_REFINE_ABORT = 157,
  WORHP_STAGE_IP_CORRECT_PREPARE = 158,
  WORHP_STAGE_IP_CORRECT_STEP = 159,
  WORHP_STAGE_IP_CORRECT_ABORT = 160,
  WORHP_STAGE_IP_FINALIZE = 161,
  WORHP_STAGE_TERMINATE = 162,
 /* mja: Stage for checking user derivatives with fidif. */
  Check_Deriv_Values = 200,
 /* mja: Stage to signal fidif stage to StageMsg. Not used otherwise as fidif is called with WorhpFidif */
  Worhp_Fidif = 201,
 /*-----------------------------------------------------------------
  *  (somehow) successful termination
  *-----------------------------------------------------------------*/
  TerminateSuccess = 1000,
  OptimalSolution = 1001,
  LowPassFilterOptimal = 1011,
  OptimalSolutionConstantF = 1012,
  FritzJohn = 1021,
  NotDiffable = 1022,
  Unbounded = 1031,
  FeasibleSolution = 1041,
  SearchDirectionZero = 1051,
  SearchDirectionSmall = 1052,
  AcceptableSolution = 1061,
  AcceptablePrevious = 1062,
  LowPassFilterAcceptable = 1063,
  AcceptableSolutionConstantF = 1064,
  AcceptablePreviousConstantF = 1065,
  AcceptableSolutionSKKT = 1066,
  AcceptableSolutionScaled = 1067,
  AcceptablePreviousScaled = 1068,
 /*-----------------------------------------------------------------
  *  (somehow) unsuccessful termination
  *-----------------------------------------------------------------*/
  TerminateError = -1000,
  MaxCalls = -1001,
  MaxIter = -1002,
  Timeout = -1003,
  LocalInfeasOptimal = -1011,
  LocalInfeas = -1012,
  GlobalInfeas = -1013,
  TooBig = -1021,
  evalsNaN = -1022,
  DivergingPrimal = -1023,
  DivergingDual = -1024,
  MinimumStepsize = -1031,
  RegularizationFailed = -1032,
  InitError = -1041,
  DataError = -1042,
  RestartError = -1043,
  FileOpenError = -1044,
  QPerror = -1051,
  LinearSolverFailed = -1052,
  TerminatedByCheckFD = -1061,
  LicenseError = -1071,
  Debug = -1206,
  LicenseWarnExpiryDays = 31
};


typedef struct OptVarStruct {
  int n;
  int m;
  int k;
  int nGPart;
  int iGPart;
  double F;
  int FType;
  double *X;
  double *XL;
  double *XU;
  double *Lambda;
  double *G;
  double *GL;
  double *GU;
  int *GType;
  double *Mu;
  int *GPart;
  double *P;

 /* Indicates that X was changed by WORHP */
  bool newX;

 /* Automatically added initialisation flag.  */
  bool initialised;
} OptVar;

typedef struct WorkspaceStruct {

 /* WORHP NLP: selects the modification strategy for slacks */
  int NLP_ParModTypeSlacks;

 /* WORHP NLP: selects the modification strategy for objective */
  int NLP_ParModTypeObj;

 /* WORHP NLP: enables the storage of the gradient of the lagrangian of the modified problem without objective function */
  bool NLP_ParUseDLFeas;

 /* WORHP NLP: enables the possibility to caluclate DG^T * G with WORHP NLP */
  bool NLP_ParUseDGG;

 /* WORHP NLP: If enabled the created matrices will be sorted the WORHP way. */
  bool NLP_ParSortMatrix;

 /* WORHP NLP: max gradient after automatic scaling */
  double NLP_ParScaleMaxGrad;

 /* WORHP NLP: min scaling factor of automatic scaling */
  double NLP_ParScaleMin;

 /* WORHP NLP: if enabled use values are checked for NaN and Inf values */
  int NLP_ParCheckNanInf;

 /* WORHP NLP: if enabled an iterate can be stored for warmstart */
  bool NLP_ParStoreWarmstart;

 /* WORHP NLP: if enabled the bounds will be stored e.g. for tracking changes after warmstart */
  bool NLP_ParStoreBounds;

 /* WORHP NLP: lower bound for objective function */
  double NLP_ParObjLow;

 /* WORHP NLP: upper bound for objective function */
  double NLP_ParObjUp;

 /* WORHP NLP: indicates if index types are stored */
  bool NLP_IdxTypeStore;

 /* WORHP NLP: number of optimization variables */
  int NLP_n;

 /* WORHP NLP: number of optimization variables with bounds */
  int NLP_nIeq;

 /* WORHP NLP: number of optimization variables with just lower bounds */
  int NLP_nIeqLow;

 /* WORHP NLP: number of optimization variables with just upper bounds */
  int NLP_nIeqUp;

 /* WORHP NLP: number of optimization variables with lower and upper bounds */
  int NLP_nIeqLowUp;

 /* WORHP NLP: number of constraints */
  int NLP_m;

 /* WORHP NLP: number of equality constraints */
  int NLP_mEq;

 /* WORHP NLP: number of inequality constraints or slacks */
  int NLP_mIeq;

 /* WORHP NLP: number of inequality constraints or slacks with just lower bounds */
  int NLP_mIeqLow;

 /* WORHP NLP: number of inequality constraints or slacks with just upper bounds */
  int NLP_mIeqUp;

 /* WORHP NLP: number of inequality constraints or slacks with lower and upper bounds */
  int NLP_mIeqLowUp;

 /* WORHP NLP: Indicates that the objective is constant */
  bool NLP_ConstantF;

 /* WORHP NLP: Indicates that the Gradient is constant */
  bool NLP_ConstantDF;

 /* WORHP NLP: Indicates that the Jacobian is constant */
  bool NLP_ConstantDG;

 /* WORHP NLP: Indicates that the Hessian is constant */
  bool NLP_ConstantHM;

 /* WORHP NLP: Indicates if no objective exist and just feasibility is relevant */
  bool NLP_FeasibilityOnly;

 /* WORHP NLP: Indicates if values of bounds have been changed */
  bool NLP_UpdatedBoundsValue;

 /* WORHP NLP: Indicates if types of (box) constraints have been changed */
  bool NLP_UpdatedBoundsType;
  size_t dim_NLP_X;
  size_t dim_NLP_S;
  size_t dim_NLP_Mu;
  size_t dim_NLP_MuGL;
  size_t dim_NLP_MuGU;
  size_t dim_NLP_LambdaXL;
  size_t dim_NLP_LambdaXU;
  size_t dim_NLP_LambdaSL;
  size_t dim_NLP_LambdaSU;
  size_t dim_NLP_G;
  size_t dim_NLP_XL;
  size_t dim_NLP_XU;
  size_t dim_NLP_SL;
  size_t dim_NLP_SU;
  size_t dim_NLP_GL;
  size_t dim_NLP_GU;
  size_t dim_NLP_GB;
  size_t dim_NLP_XL0;
  size_t dim_NLP_XU0;
  size_t dim_NLP_GL0;
  size_t dim_NLP_GU0;

 /* WORHP NLP: optimization variable */
  double *NLP_X;

 /* WORHP NLP: slack variables */
  double *NLP_S;

 /* WORHP NLP: lagrangian multipliers of equality constraints */
  double *NLP_Mu;

 /* WORHP NLP: lagrangian multipliers for lower bounds GL */
  double *NLP_MuGL;

 /* WORHP NLP: lagrangian multipliers for lower bounds GU */
  double *NLP_MuGU;

 /* WORHP NLP: lagrangian multipliers for lower bounds XL */
  double *NLP_LambdaXL;

 /* WORHP NLP: lagrangian multipliers for lower bounds XU */
  double *NLP_LambdaXU;

 /* WORHP NLP: lagrangian multipliers for lower bounds SL */
  double *NLP_LambdaSL;

 /* WORHP NLP: lagrangian multipliers for lower bounds SU */
  double *NLP_LambdaSU;

 /* WORHP NLP: objective function of the modified problem. */
  double NLP_F;

 /* WORHP NLP: constraints of the modified problem */
  double *NLP_G;

 /* WORHP NLP: lower bounds for optimization variables */
  double *NLP_XL;

 /* WORHP NLP: upper bounds for optimization variables */
  double *NLP_XU;

 /* WORHP NLP: lower bounds for slacks */
  double *NLP_SL;

 /* WORHP NLP: upper bounds for slacks */
  double *NLP_SU;

 /* WORHP NLP: lower bounds for inequality constraints */
  double *NLP_GL;

 /* WORHP NLP: upper bounds for inequality constraints */
  double *NLP_GU;

 /* WORHP NLP: bounds for equality constraints */
  double *NLP_GB;

 /* WORHP NLP: gradient of the objective function of the modified problem. */
  WorhpMatrix NLP_DF;

 /* WORHP NLP: jacobian of the constraints of the modified problem. */
  WorhpMatrix NLP_DG;

 /* WORHP NLP: hessian of the modified problem. */
  WorhpMatrix NLP_HM;

 /* WORHP NLP: lower bounds for optimization variables (original bounds) */
  double *NLP_XL0;

 /* WORHP NLP: lower bounds for optimization variables (original bounds) */
  double *NLP_XU0;

 /* WORHP NLP: lower bounds for optimization variables (original bounds) */
  double *NLP_GL0;

 /* WORHP NLP: lower bounds for optimization variables (original bounds) */
  double *NLP_GU0;
  size_t dim_NLP_X0;
  size_t dim_NLP_S0;
  size_t dim_NLP_Mu0;
  size_t dim_NLP_MuGL0;
  size_t dim_NLP_MuGU0;
  size_t dim_NLP_LambdaXL0;
  size_t dim_NLP_LambdaXU0;
  size_t dim_NLP_LambdaSL0;
  size_t dim_NLP_LambdaSU0;

 /* WORHP NLP: optimization variable of former iteration */
  double *NLP_X0;

 /* WORHP NLP: slack variables of former iteration */
  double *NLP_S0;

 /* WORHP NLP: lagrangian multipliers of equality constraints of former iteration */
  double *NLP_Mu0;

 /* WORHP NLP: lagrangian multipliers for lower bounds GL of former iteration */
  double *NLP_MuGL0;

 /* WORHP NLP: lagrangian multipliers for lower bounds GU of former iteration */
  double *NLP_MuGU0;

 /* WORHP NLP: lagrangian multipliers for lower bounds XL of former iteration */
  double *NLP_LambdaXL0;

 /* WORHP NLP: lagrangian multipliers for lower bounds XU of former iteration */
  double *NLP_LambdaXU0;

 /* WORHP NLP: lagrangian multipliers for lower bounds SL of former iteration */
  double *NLP_LambdaSL0;

 /* WORHP NLP: lagrangian multipliers for lower bounds SU of former iteration */
  double *NLP_LambdaSU0;
  size_t dim_NLP_ActiveSetXL;
  size_t dim_NLP_ActiveSetXU;
  size_t dim_NLP_ActiveSetSL;
  size_t dim_NLP_ActiveSetSU;
  size_t dim_NLP_ActiveSetGL;
  size_t dim_NLP_ActiveSetGU;

 /* Active set for lower box constraints */
  bool *NLP_ActiveSetXL;

 /* Active set for upper box constraints */
  bool *NLP_ActiveSetXU;

 /* Active set for lower constraints */
  bool *NLP_ActiveSetSL;

 /* Active set for upper constraints */
  bool *NLP_ActiveSetSU;

 /* Active set for lower constraints */
  bool *NLP_ActiveSetGL;

 /* Active set for upper constraints */
  bool *NLP_ActiveSetGU;
  size_t dim_NLP_DLx;
  size_t dim_NLP_DLs;
  size_t dim_NLP_DLxFeas;
  size_t dim_NLP_DLsFeas;
  size_t dim_NLP_OrigDL;

 /* WORHP NLP: gradient of the lagrangian w.r.t. X (modified problem) */
  double *NLP_DLx;

 /* WORHP NLP: gradient of the lagrangian w.r.t. S (modified problem) */
  double *NLP_DLs;

 /* WORHP NLP: gradient of the lagrangian w.r.t. X (modified problem without objective function) */
  double *NLP_DLxFeas;

 /* WORHP NLP: gradient of the lagrangian w.r.t. S (modified problem without objective function) */
  double *NLP_DLsFeas;

 /* WORHP NLP: gradient of the lagrangian (original problem) */
  double *NLP_OrigDL;
  size_t dim_NLP_DGG;

 /* WORHP NLP: Result of the product DG^T * G */
  double *NLP_DGG;
  size_t dim_NLP_ScaleX;
  size_t dim_NLP_ScaleG;

 /* WORHP NLP: scaling factor of objective */
  double NLP_ScaleF;

 /* WORHP NLP: scaling factor of objective set by algorithm */
  double NLP_ScaleFalg;

 /* WORHP NLP: scaling factor of objective in lagrangian function set by algorithm */
  double NLP_ScaleLFalg;

 /* WORHP NLP: scaling factor of optimization variable */
  double *NLP_ScaleX;

 /* WORHP NLP: scaling factor of constraints */
  double *NLP_ScaleG;
  size_t dim_NLP_AcceptOrigX;
  size_t dim_NLP_AcceptOrigMu;
  size_t dim_NLP_AcceptOrigLambda;

 /* WORHP NLP: variable X of acceptable solution (original problem) */
  double *NLP_AcceptOrigX;

 /* WORHP NLP: variable Mu of acceptable solution (original problem) */
  double *NLP_AcceptOrigMu;

 /* WORHP NLP: variable Lambda of acceptable solution (original problem) */
  double *NLP_AcceptOrigLambda;

 /* WORHP NLP: objective function of acceptable solution (original problem) */
  double NLP_AcceptOrigF;

 /* WORHP NLP: optimality of acceptable solution (original problem) */
  double NLP_AcceptOrigOptiMax;

 /* WORHP NLP: feasibility of acceptable solution (original problem) */
  double NLP_AcceptOrigFeasMax;

 /* WORHP NLP: complementarity of acceptable solution (original problem) */
  double NLP_AcceptOrigComplMax;

 /* WORHP NLP: optimality of acceptable solution (modified problem) */
  double NLP_AcceptOptiMax;

 /* WORHP NLP: feasibility of acceptable solution (modified problem) */
  double NLP_AcceptFeasMax;

 /* WORHP NLP: complementarity of acceptable solution (modified problem) */
  double NLP_AcceptComplMax;

 /* WORHP NLP: iteration of acceptable solution */
  int NLP_AcceptMajorIter;

 /* WORHP NLP: indicates if acceptbale solution has been found */
  bool NLP_AcceptSolFound;
  size_t dim_NLP_WarmX;
  size_t dim_NLP_WarmMu;
  size_t dim_NLP_WarmLambda;

 /* WORHP IP: optimization variable for warmstart */
  double *NLP_WarmX;

 /* WORHP IP: lagrange multiplier Mu for warmstart */
  double *NLP_WarmMu;

 /* WORHP IP: lagrange multiplier Lambda for warmstart */
  double *NLP_WarmLambda;

 /* WORHP IP: indicates if iterate has been stored for warmstart */
  bool NLP_WarmStored;
  size_t dim_NLP_idxX;
  size_t dim_NLP_idxG;
  size_t dim_NLP_idxDF;
  size_t dim_NLP_idxDG;
  size_t dim_NLP_idxHM;
  size_t dim_NLP_idxXType;
  size_t dim_NLP_idxGType;
  size_t dim_NLP_idxDFType;
  size_t dim_NLP_idxDGType;
  size_t dim_NLP_idxHMType;
  size_t dim_NLP_idxOrigX;
  size_t dim_NLP_idxOrigG;
  size_t dim_NLP_idxHMdiag;

 /* WORHP NLP: mapping modified X -> original X */
  int *NLP_idxX;

 /* WORHP NLP: mapping modified G -> original G */
  int *NLP_idxG;

 /* WORHP NLP: mapping modified DF -> original DF */
  int *NLP_idxDF;

 /* WORHP NLP: mapping modified DG -> original DG */
  int *NLP_idxDG;

 /* WORHP NLP: mapping modified HM -> original HM */
  int *NLP_idxHM;

 /* WORHP NLP: type of variables X */
  int *NLP_idxXType;

 /* WORHP NLP: type of constraints G */
  int *NLP_idxGType;

 /* WORHP NLP: type of gradient df */
  int *NLP_idxDFType;

 /* WORHP NLP: type of jacobian dg */
  int *NLP_idxDGType;

 /* WORHP NLP: type of hessian hm */
  int *NLP_idxHMType;

 /* WORHP NLP: mapping modified X <- original X */
  int *NLP_idxOrigX;

 /* WORHP NLP: mapping modified G <- original G */
  int *NLP_idxOrigG;

 /* WORHP NLP: indices of HM diagonal */
  int *NLP_idxHMdiag;

 /* WORHP NLP: start index for unbounded X */
  int NLP_idxXunbnd0;

 /* WORHP NLP: end index for unbounded X */
  int NLP_idxXunbnd1;

 /* WORHP NLP: start index for lower bounded X */
  int NLP_idxXieqLow0;

 /* WORHP NLP: end index for lower bounded X */
  int NLP_idxXieqLow1;

 /* WORHP NLP: start index for lower and upper bounded X */
  int NLP_idxXieqLowUp0;

 /* WORHP NLP: end index for lower and upper bounded X */
  int NLP_idxXieqLowUp1;

 /* WORHP NLP: start index for upper bounded X */
  int NLP_idxXieqUp0;

 /* WORHP NLP: end index for upper bounded X */
  int NLP_idxXieqUp1;

 /* WORHP NLP: start index for equality G */
  int NLP_idxGeq0;

 /* WORHP NLP: end index for equality G */
  int NLP_idxGeq1;

 /* WORHP NLP: start index for lower bounded G */
  int NLP_idxGieqLow0;

 /* WORHP NLP: end index for lower bounded G */
  int NLP_idxGieqLow1;

 /* WORHP NLP: start index for lower and upper bounded G */
  int NLP_idxGieqLowUp0;

 /* WORHP NLP: end index for lower and upper bounded G */
  int NLP_idxGieqLowUp1;

 /* WORHP NLP: start index for upper bounded G */
  int NLP_idxGieqUp0;

 /* WORHP NLP: end index for upper bounded G */
  int NLP_idxGieqUp1;

 /* WORHP NLP: number of diagonal elements in HM */
  int NLP_nnzHMdiag;

 /* WORHP NLP: position of objective slack variable */
  int NLP_idxObjSlack;

 /* WORHP NLP: position of objective constraint */
  int NLP_idxObjCon;

 /* WORHP NLP: Evaluation flag for objective function (original problem) */
  bool NLP_EvalOrigF;

 /* WORHP NLP: Evaluation flag for constraints (original problem) */
  bool NLP_EvalOrigG;

 /* WORHP NLP: Evaluation flag for gradient (original problem) */
  bool NLP_EvalOrigDF;

 /* WORHP NLP: Evaluation flag for jacobian (original problem) */
  bool NLP_EvalOrigDG;

 /* WORHP NLP: Evaluation flag for hessian (original problem) */
  bool NLP_EvalOrigHM;

 /* WORHP NLP: Evaluation flag for gradient of lagrangian (original problem) */
  bool NLP_EvalOrigDL;

 /* WORHP NLP: Evalutation flag for optimality (original problem) */
  bool NLP_EvalOptiOrig;

 /* WORHP NLP: Evalutation flag for feasibility (original problem) */
  bool NLP_EvalFeasOrig;

 /* WORHP NLP: Evalutation flag for complementarity (original problem) */
  bool NLP_EvalComplOrig;

 /* WORHP NLP: Evaluation flag for objective function (modified problem) */
  bool NLP_EvalF;

 /* WORHP NLP: Evaluation flag for constraints (modified problem) */
  bool NLP_EvalG;

 /* WORHP NLP: Evaluation flag for gradient (modified problem) */
  bool NLP_EvalDF;

 /* WORHP NLP: Evaluation flag for jacobian (modified problem) */
  bool NLP_EvalDG;

 /* WORHP NLP: Evaluation flag for hessian (modified problem) */
  bool NLP_EvalHM;

 /* WORHP NLP: Evalutation flag for gradient of lagrangian (modified problem) */
  bool NLP_EvalDL;

 /* WORHP NLP: Evalutation flag for gradient of lagrangian (modified problem without objective function) */
  bool NLP_EvalDLFeas;

 /* WORHP NLP: Evaluation flag for product DG^T * G */
  bool NLP_EvalDGG;

 /* WORHP NLP: Evalutation flag for optimality (modified problem) */
  bool NLP_EvalOpti;

 /* WORHP NLP: Evalutation flag for feasibility (modified problem) */
  bool NLP_EvalFeas;

 /* WORHP NLP: Evalutation flag for complementarity (modified problem) */
  bool NLP_EvalCompl;

 /* WORHP NLP: storage of unscaled f needed for finite differences */
  double NLP_FidifF0;
  size_t dim_NLP_FidifDF0;

 /* WORHP NLP: storage of unscaled df needed for finite differences */
  double *NLP_FidifDF0;

 /* WORHP IP: modification of nlp due to penalty function */
  int IP_NlpModType;

 /* WORHP IP: objective of barrier problem */
  double IP_ObjBarr;

 /* WORHP IP: objective of barrier / penalty problem */
  double IP_ObjBarrPen;

 /* WORHP IP: barrier part of objective of barrier problem */
  double IP_ObjBarrPart;

 /* WORHP IP: penalty part of objective of barrier / penalty problem */
  double IP_ObjPenPart;

 /* WORHP IP: approximated optimality of modified problem (2-norm) */
  double IP_Opti2;

 /* WORHP IP: approximated optimality of modified problem (max-norm) */
  double IP_OptiMax;

 /* WORHP IP: approximated optimality of feasibility problem (2-norm) */
  double IP_OptiFeasApprox2;

 /* WORHP IP: approximated optimality of feasibility problem (max norm) */
  double IP_OptiFeasApproxMax;

 /* WORHP IP: optimality of feasibility problem (2-norm) */
  double IP_OptiFeas2;

 /* WORHP IP: optimality of feasibility problem (max norm) */
  double IP_OptiFeasMax;

 /* WORHP IP: optimality of fritz-john problem (max norm) */
  double IP_OptiFritzJohnMax;

 /* WORHP IP: optimality with augmented mu (max norm) */
  double IP_OptiAugMuMax;

 /* WORHP IP: feasibility of (modified) problem (2-norm) */
  double IP_Feas2;

 /* WORHP IP: feasibility of (modified) problem (max norm) */
  double IP_FeasMax;

 /* WORHP IP: feasibility of (modified) problem w.r.t. box constraints (2-norm) */
  double IP_FeasBox2;

 /* WORHP IP: feasibility of (modified) problem w.r.t. box constraints (max norm) */
  double IP_FeasBoxMax;

 /* WORHP IP: feasibility of barrier/penalty problem (2-norm) */
  double IP_FeasBarrPen2;

 /* WORHP IP: feasibility of barrier/penalty problem (max norm) */
  double IP_FeasBarrPenMax;

 /* WORHP IP: complementarity of modified problem (2-norm) */
  double IP_Compl2;

 /* WORHP IP: complementarity of modified problem (max norm) */
  double IP_ComplMax;

 /* WORHP IP: complementarity of barrier problem (2-norm) */
  double IP_ComplBarr2;

 /* WORHP IP: complementarity of barrier problem (max norm) */
  double IP_ComplBarrMax;

 /* WORHP IP: complementarity of barrier problem (2-norm) */
  double IP_ComplBarrInv2;

 /* WORHP IP: complementarity of barrier problem (max norm) */
  double IP_ComplBarrInvMax;

 /* WORHP IP: complementarity of feasibility problem (2-norm) */
  double IP_ComplFeas2;

 /* WORHP IP: complementarity of feasibility problem (max norm) */
  double IP_ComplFeasMax;

 /* WORHP IP: complementarity of fritz-john problem (max norm) */
  double IP_ComplFritzJohnMax;

 /* WORHP IP: inital constraint violation */
  double IP_FeasInit;

 /* WORHP IP: constraint violation at the beginning of the iteration (2-norm) */
  double IP_Feas2IterInit;

 /* WORHP IP: dual trust region condition */
  double IP_DualTrustRegionMu;

 /* WORHP IP: dual trust region condition */
  double IP_DualTrustRegionMuTrial;

 /* WORHP IP: dual trust region condition */
  double IP_DualTrustRegionLambda;

 /* WORHP IP: dual trust region condition */
  double IP_DualTrustRegionLambdaTrial;

 /* WORHP IP: merit function part for feasibility of penalty subproblem */
  double IP_MeritFeasPen;

 /* WORHP IP: merit function part for complementarity of barrier subproblem */
  double IP_MeritComplBarr;
  size_t dim_IP_FeasBarrPen;

 /* WORHP IP: feasibility of barrier / penalty subproblem */
  double *IP_FeasBarrPen;

 /* WORHP IP: barrier parameter */
  double IP_Barrier;

 /* WORHP IP: barrier shift */
  double IP_BarrierShift;

 /* WORHP IP: min value of barrier parameter */
  double IP_BarrierMin;

 /* WORHP IP: max value of barrier parameter */
  double IP_BarrierMax;

 /* WORHP IP: min value of barrier shift parameter */
  double IP_BarrierShiftMin;

 /* WORHP IP: max value of barrier shift parameter */
  double IP_BarrierShiftMax;

 /* WORHP IP: barrier update strategy (belongs to the equally named parameter) */
  int IP_BarrierUpdate;

 /* WORHP IP: barrier shift update strategy (belongs to the equally named parameter) */
  int IP_BarrierShiftUpdate;

 /* WORHP IP: penalty parameter (for objective) */
  double IP_PenaltyObj;

 /* WORHP IP: penalty parameter (for constraint violation) */
  double IP_PenaltyFeas;

 /* WORHP IP: penalty update strategy (belongs to the equally named parameter) */
  int IP_PenaltyUpdate;

 /* WORHP IP: fraction-to-the-boundary parameter. */
  double IP_Tau;

 /* WORHP IP: trial fraction-to-the-boundary parameter. */
  double IP_TauTrial;

 /* WORHP IP: iterations after last monotone barrier update */
  int IP_IterBarrierUpdateMono;

 /* WORHP IP: trial barrier parameter for updates */
  double IP_BarrierTrial;

 /* WORHP IP: barrier parameter used for linear equation system */
  double IP_Barrier0;

 /* WORHP IP: trial barrier shift parameter for updates */
  double IP_BarrierShiftTrial;

 /* WORHP IP: barrier shift parameter used for linear equation system */
  double IP_BarrierShift0;

 /* WORHP IP: trial value of PenaltyObj for updates */
  double IP_PenaltyObjTrial;

 /* WORHP IP: trial value of PenaltyFeas for updates */
  double IP_PenaltyFeasTrial;

 /* WORHP IP: penalty parameter (for objective) used for linear equation system */
  double IP_PenaltyObj0;

 /* WORHP IP: penalty parameter (for constraint violation) used for linear equation system */
  double IP_PenaltyFeas0;

 /* WORHP IP: threshold for penalty obj / penalty feas update */
  double IP_PenaltySwitch;

 /* WORHP IP: trial value of updating augmented mu duals */
  int IP_AugMuTrial;

 /* WORHP IP: indicates if the barrier shift update forced an X variable update */
  bool IP_BarrierShiftPushedVarX;

 /* WORHP IP: indicates if the barrier shift update forced an S variable update */
  bool IP_BarrierShiftPushedVarS;

 /* WORHP IP: indicates if the penalty obj or penalty feas is should be increased */
  bool IP_PenaltyUpdateIncrObj;

 /* WORHP IP: indicates if the penalty obj or penalty feas is should be decreased */
  bool IP_PenaltyUpdateDecrObj;

 /* WORHP IP: indicates if the augmented mu have been updated */
  bool IP_AugMuUpdated;

 /* WORHP IP: indicates if the augmented lambda have been updated */
  bool IP_AugLambdaUpdated;
  size_t dim_IP_ShiftXL;
  size_t dim_IP_ShiftXU;
  size_t dim_IP_ShiftSL;
  size_t dim_IP_ShiftSU;

 /* WORHP IP: lower bound shift of X for modified barrier function */
  double *IP_ShiftXL;

 /* WORHP IP: upper bound shift of X for modified barrier function */
  double *IP_ShiftXU;

 /* WORHP IP: lower bound shift of S for modified barrier function */
  double *IP_ShiftSL;

 /* WORHP IP: upper bound shift of S for modified barrier function */
  double *IP_ShiftSU;

 /* WORHP IP: regularization term in hessian */
  double IP_RegTau;

 /* WORHP IP: regularization term in jacobian */
  double IP_RegTauC;

 /* WORHP IP: former regularization term in hessian */
  double IP_RegTauOld;

 /* WORHP IP: scaling factor for optimality in KKT conditions */
  double IP_ScaleKKTOpt;

 /* WORHP IP: scaling factor for feasibility in KKT conditions */
  double IP_ScaleKKTFeas;
  size_t dim_IP_XUX;
  size_t dim_IP_XXL;
  size_t dim_IP_SUS;
  size_t dim_IP_SSL;
  size_t dim_IP_XUX0;
  size_t dim_IP_XXL0;
  size_t dim_IP_SUS0;
  size_t dim_IP_SSL0;

 /* WORHP IP: the difference XU-X */
  double *IP_XUX;

 /* WORHP IP: the difference X-XL */
  double *IP_XXL;

 /* WORHP IP: the difference SU-S */
  double *IP_SUS;

 /* WORHP IP: the difference S-GS */
  double *IP_SSL;

 /* WORHP IP: the difference XU-X before linesearch */
  double *IP_XUX0;

 /* WORHP IP: the difference X-XL before linesearch */
  double *IP_XXL0;

 /* WORHP IP: the difference SU-S before linesearch */
  double *IP_SUS0;

 /* WORHP IP: the difference S-SL before linesearch */
  double *IP_SSL0;

 /* WORHP IP: system matrix for the linear equation system */
  WorhpMatrix IP_LEQ;
  size_t dim_IP_LeqX;
  size_t dim_IP_LeqLinDependCon;

 /* WORHP IP: right-hand-side and solution of linear equation system. */
  double *IP_LeqX;

 /* WORHP IP: indicates linear dependent constraint gradients in current linear equation system */
  bool *IP_LeqLinDependCon;

 /* WORHP IP: start index in solution vector */
  int IP_Leq01;

 /* WORHP IP: start index in solution vector */
  int IP_Leq02;

 /* WORHP IP: start index in solution vector */
  int IP_Leq03;

 /* WORHP IP: start index in solution vector */
  int IP_Leq05;

 /* WORHP IP: start index in solution vector */
  int IP_Leq06;

 /* WORHP IP: start index in solution vector */
  int IP_Leq07;

 /* WORHP IP: start index in solution vector */
  int IP_Leq08;

 /* WORHP IP: start index of block 01-01 */
  int IP_Leq0101s;

 /* WORHP IP: end index of block 01-01 */
  int IP_Leq0101e;

 /* WORHP IP: start index of block 02-02 */
  int IP_Leq0202s;

 /* WORHP IP: end index of block 02-02 */
  int IP_Leq0202e;

 /* WORHP IP: start index of block 03-01 */
  int IP_Leq0301s;

 /* WORHP IP: end index of block 03-01 */
  int IP_Leq0301e;

 /* WORHP IP: start index of block 03-02 */
  int IP_Leq0302s;

 /* WORHP IP: end index of block 03-02 */
  int IP_Leq0302e;

 /* WORHP IP: start index of block 03-03 */
  int IP_Leq0303s;

 /* WORHP IP: end index of block 03-03 */
  int IP_Leq0303e;

 /* WORHP IP: start index of block 04-04 */
  int IP_Leq0404s;

 /* WORHP IP: end index of block 04-04 */
  int IP_Leq0404e;

 /* WORHP IP: start index of block 05-01 */
  int IP_Leq0501s;

 /* WORHP IP: end index of block 05-01 */
  int IP_Leq0501e;

 /* WORHP IP: start index of block 05-05 */
  int IP_Leq0505s;

 /* WORHP IP: end index of block 05-05 */
  int IP_Leq0505e;

 /* WORHP IP: start index of block 06-01 */
  int IP_Leq0601s;

 /* WORHP IP: end index of block 06-01 */
  int IP_Leq0601e;

 /* WORHP IP: start index of block 06-06 */
  int IP_Leq0606s;

 /* WORHP IP: end index of block 06-06 */
  int IP_Leq0606e;

 /* WORHP IP: start index of block 07-02 */
  int IP_Leq0702s;

 /* WORHP IP: end index of block 07-02 */
  int IP_Leq0702e;

 /* WORHP IP: start index of block 07-07 */
  int IP_Leq0707s;

 /* WORHP IP: end index of block 07-07 */
  int IP_Leq0707e;

 /* WORHP IP: start index of block 08-02 */
  int IP_Leq0802s;

 /* WORHP IP: end index of block 08-02 */
  int IP_Leq0802e;

 /* WORHP IP: start index of block 08-08 */
  int IP_Leq0808s;

 /* WORHP IP: end index of block 08-08 */
  int IP_Leq0808e;

 /* WORHP IP: chooses the specific linear equation system */
  int IP_LeqType;

 /* WORHP IP: chooses the specific linear equation system */
  int IP_LeqBarrierType;

 /* WORHP IP: chooses the specific linear equation system */
  int IP_LeqPenaltyType;

 /* WORHP IP: flag indicating that matrix has been provided */
  bool IP_LeqDoneMatrix;

 /* WORHP IP: flag indicating that factorization has been done */
  bool IP_LeqDoneFactorization;

 /* WORHP IP: indicates inertia status of the LEQ matrix. */
  int IP_LeqInertia;

 /* WORHP IP: min number of iterative refinement steps */
  int IP_LeqItRefMinIter;

 /* WORHP IP: max number of iterative refinement steps */
  int IP_LeqItRefMaxIter;

 /* WORHP IP: residual ratio of iterative refinement */
  double IP_LeqItRefRatio;

 /* WORHP IP: iteration counter for iterative refinement */
  int IP_LeqItRefIter;

 /* WORHP IP: indicates if quality has been increased in this iteration */
  bool IP_LeqIncQuality;

 /* WORHP IP: specifies if identity matrix should be used instead of hessian */
  bool IP_LeqUseIdentity;

 /* WORHP IP: indicates which leq solve mode is currently enabled. */
  int IP_LeqSolveMode;

 /* WORHP IP: indicates which type of rhs is currently stored in the rhs vectors */
  int IP_LeqCurrRhs;

 /* WORHP IP: indicates that the current linear equation system has been primal regularized */
  bool IP_LeqRegPrimal;

 /* WORHP IP: indicates that the current linear equation system has been dual regularized */
  bool IP_LeqRegDual;
  size_t dim_IP_LeqGerschgorin;

 /* WORHP IP: Gerschgorin circles of top-left primal leq matrix part */
  double *IP_LeqGerschgorin;

 /* WORHP IP: current variable of newton system check */
  int IP_LeqCheckVar;

 /* WORHP IP: current dimension of newton system check */
  int IP_LeqCheckDim;

 /* WORHP IP: finite difference step of newton system check */
  double IP_LeqCheckEps;

 /* WORHP IP: indicates if the newton system check has failed */
  bool IP_LeqCheckFail;

 /* WORHP IP: forces the evaluation within the newton system check */
  bool IP_LeqCheckEvalHM;
  size_t dim_IP_DStdX;
  size_t dim_IP_DStdS;
  size_t dim_IP_DStdMu;
  size_t dim_IP_DStdLambdaXL;
  size_t dim_IP_DStdLambdaXU;
  size_t dim_IP_DStdLambdaSL;
  size_t dim_IP_DStdLambdaSU;

 /* WORHP IP: search direction of X */
  double *IP_DStdX;

 /* WORHP IP: search direction of S */
  double *IP_DStdS;

 /* WORHP IP: search direction of Mu */
  double *IP_DStdMu;

 /* WORHP IP: search direction of LambdaXL */
  double *IP_DStdLambdaXL;

 /* WORHP IP: search direction of LambdaXU */
  double *IP_DStdLambdaXU;

 /* WORHP IP: search direction of LambdaSL */
  double *IP_DStdLambdaSL;

 /* WORHP IP: search direction of LambdaSU */
  double *IP_DStdLambdaSU;
  size_t dim_IP_DSensBarX;
  size_t dim_IP_DSensBarS;
  size_t dim_IP_DSensBarMu;
  size_t dim_IP_DSensBarLambdaXL;
  size_t dim_IP_DSensBarLambdaXU;
  size_t dim_IP_DSensBarLambdaSL;
  size_t dim_IP_DSensBarLambdaSU;

 /* WORHP IP: search direction of X */
  double *IP_DSensBarX;

 /* WORHP IP: search direction of S */
  double *IP_DSensBarS;

 /* WORHP IP: search direction of Mu */
  double *IP_DSensBarMu;

 /* WORHP IP: search direction of LambdaXL */
  double *IP_DSensBarLambdaXL;

 /* WORHP IP: search direction of LambdaXU */
  double *IP_DSensBarLambdaXU;

 /* WORHP IP: search direction of LambdaSL */
  double *IP_DSensBarLambdaSL;

 /* WORHP IP: search direction of LambdaSU */
  double *IP_DSensBarLambdaSU;
  size_t dim_IP_DSensBarShiftX;
  size_t dim_IP_DSensBarShiftS;
  size_t dim_IP_DSensBarShiftMu;
  size_t dim_IP_DSensBarShiftLambdaXL;
  size_t dim_IP_DSensBarShiftLambdaXU;
  size_t dim_IP_DSensBarShiftLambdaSL;
  size_t dim_IP_DSensBarShiftLambdaSU;

 /* WORHP IP: search direction of X */
  double *IP_DSensBarShiftX;

 /* WORHP IP: search direction of S */
  double *IP_DSensBarShiftS;

 /* WORHP IP: search direction of Mu */
  double *IP_DSensBarShiftMu;

 /* WORHP IP: search direction of LambdaXL */
  double *IP_DSensBarShiftLambdaXL;

 /* WORHP IP: search direction of LambdaXU */
  double *IP_DSensBarShiftLambdaXU;

 /* WORHP IP: search direction of LambdaSL */
  double *IP_DSensBarShiftLambdaSL;

 /* WORHP IP: search direction of LambdaSU */
  double *IP_DSensBarShiftLambdaSU;
  size_t dim_IP_DSensPenObjX;
  size_t dim_IP_DSensPenObjS;
  size_t dim_IP_DSensPenObjMu;
  size_t dim_IP_DSensPenObjLambdaXL;
  size_t dim_IP_DSensPenObjLambdaXU;
  size_t dim_IP_DSensPenObjLambdaSL;
  size_t dim_IP_DSensPenObjLambdaSU;

 /* WORHP IP: search direction of X */
  double *IP_DSensPenObjX;

 /* WORHP IP: search direction of S */
  double *IP_DSensPenObjS;

 /* WORHP IP: search direction of Mu */
  double *IP_DSensPenObjMu;

 /* WORHP IP: search direction of LambdaXL */
  double *IP_DSensPenObjLambdaXL;

 /* WORHP IP: search direction of LambdaXU */
  double *IP_DSensPenObjLambdaXU;

 /* WORHP IP: search direction of LambdaSL */
  double *IP_DSensPenObjLambdaSL;

 /* WORHP IP: search direction of LambdaSU */
  double *IP_DSensPenObjLambdaSU;
  size_t dim_IP_DSensPenFeasX;
  size_t dim_IP_DSensPenFeasS;
  size_t dim_IP_DSensPenFeasMu;
  size_t dim_IP_DSensPenFeasLambdaXL;
  size_t dim_IP_DSensPenFeasLambdaXU;
  size_t dim_IP_DSensPenFeasLambdaSL;
  size_t dim_IP_DSensPenFeasLambdaSU;

 /* WORHP IP: search direction of X */
  double *IP_DSensPenFeasX;

 /* WORHP IP: search direction of S */
  double *IP_DSensPenFeasS;

 /* WORHP IP: search direction of Mu */
  double *IP_DSensPenFeasMu;

 /* WORHP IP: search direction of LambdaXL */
  double *IP_DSensPenFeasLambdaXL;

 /* WORHP IP: search direction of LambdaXU */
  double *IP_DSensPenFeasLambdaXU;

 /* WORHP IP: search direction of LambdaSL */
  double *IP_DSensPenFeasLambdaSL;

 /* WORHP IP: search direction of LambdaSU */
  double *IP_DSensPenFeasLambdaSU;
  size_t dim_IP_DSensAugMuX;
  size_t dim_IP_DSensAugMuS;
  size_t dim_IP_DSensAugMuMu;
  size_t dim_IP_DSensAugMuLambdaXL;
  size_t dim_IP_DSensAugMuLambdaXU;
  size_t dim_IP_DSensAugMuLambdaSL;
  size_t dim_IP_DSensAugMuLambdaSU;

 /* WORHP IP: search direction of X */
  double *IP_DSensAugMuX;

 /* WORHP IP: search direction of S */
  double *IP_DSensAugMuS;

 /* WORHP IP: search direction of Mu */
  double *IP_DSensAugMuMu;

 /* WORHP IP: search direction of LambdaXL */
  double *IP_DSensAugMuLambdaXL;

 /* WORHP IP: search direction of LambdaXU */
  double *IP_DSensAugMuLambdaXU;

 /* WORHP IP: search direction of LambdaSL */
  double *IP_DSensAugMuLambdaSL;

 /* WORHP IP: search direction of LambdaSU */
  double *IP_DSensAugMuLambdaSU;
  size_t dim_IP_DX;
  size_t dim_IP_DS;
  size_t dim_IP_DMu;
  size_t dim_IP_DLambdaXL;
  size_t dim_IP_DLambdaXU;
  size_t dim_IP_DLambdaSL;
  size_t dim_IP_DLambdaSU;

 /* WORHP IP: search direction of X */
  double *IP_DX;

 /* WORHP IP: search direction of S */
  double *IP_DS;

 /* WORHP IP: search direction of Mu */
  double *IP_DMu;

 /* WORHP IP: search direction of LambdaXL */
  double *IP_DLambdaXL;

 /* WORHP IP: search direction of LambdaXU */
  double *IP_DLambdaXU;

 /* WORHP IP: search direction of LambdaSL */
  double *IP_DLambdaSL;

 /* WORHP IP: search direction of LambdaSU */
  double *IP_DLambdaSU;
  size_t dim_IP_DCorrectX;
  size_t dim_IP_DCorrectS;
  size_t dim_IP_DCorrectMu;
  size_t dim_IP_DCorrectLambdaXL;
  size_t dim_IP_DCorrectLambdaXU;
  size_t dim_IP_DCorrectLambdaSL;
  size_t dim_IP_DCorrectLambdaSU;

 /* WORHP IP: search direction of X (second-order-corrections) */
  double *IP_DCorrectX;

 /* WORHP IP: search direction of S (second-order-corrections) */
  double *IP_DCorrectS;

 /* WORHP IP: search direction of Mu (second-order-corrections) */
  double *IP_DCorrectMu;

 /* WORHP IP: search direction of LambdaXL (second-order-corrections) */
  double *IP_DCorrectLambdaXL;

 /* WORHP IP: search direction of LambdaXU (second-order-corrections) */
  double *IP_DCorrectLambdaXU;

 /* WORHP IP: search direction of LambdaSL (second-order-corrections) */
  double *IP_DCorrectLambdaSL;

 /* WORHP IP: search direction of LambdaSU (second-order-corrections) */
  double *IP_DCorrectLambdaSU;

 /* WORHP IP: descent direction for (scaled) problem (step std) */
  double IP_DescD;

 /* WORHP IP: descent direction for (scaled) problem (step feas) */
  double IP_DescDFeas;

 /* WORHP IP: descent direction for (scaled) problem (trial step and trial parameters) */
  double IP_DescTrial;

 /* WORHP IP: descent direction for barrier problem (step std) */
  double IP_DescBarrD;

 /* WORHP IP: descent direction for barrier problem (step feas) */
  double IP_DescBarrDFeas;

 /* WORHP IP: descent direction for barrier problem (trial step and trial parameters) */
  double IP_DescBarrTrial;

 /* WORHP IP: descent direction for barrier / penalty problem (step std) */
  double IP_DescBarrPenD;

 /* WORHP IP: descent direction for barrier / penalty problem (step feas) */
  double IP_DescBarrPenDFeas;

 /* WORHP IP: descent direction for barrier / penalty problem (trial step and trial parameters) */
  double IP_DescBarrPenTrial;

 /* WORHP IP: descent direction for feasibility problem (step std) */
  double IP_DescFeasD;

 /* WORHP IP: descent direction for feasibility problem (step feas) */
  double IP_DescFeasDFeas;

 /* WORHP IP: descent direction for feasibility problem (trial step and trial parameters) */
  double IP_DescFeasTrial;

 /* WORHP IP: descent direction for barrier / penalty problem based on linear equation system block elimination (step std) */
  double IP_DescLeqD;

 /* WORHP IP: quality function */
  double IP_QualityFunTrial;
  size_t dim_IP_RhsX;
  size_t dim_IP_RhsS;
  size_t dim_IP_RhsMu;
  size_t dim_IP_RhsLambdaXL;
  size_t dim_IP_RhsLambdaXU;
  size_t dim_IP_RhsLambdaSL;
  size_t dim_IP_RhsLambdaSU;
  size_t dim_IP_RhsCorrectMu;

 /* WORHP IP: right-hand-side of X */
  double *IP_RhsX;

 /* WORHP IP: right-hand-side of S */
  double *IP_RhsS;

 /* WORHP IP: right-hand-side of Mu */
  double *IP_RhsMu;

 /* WORHP IP: right-hand-side of LambdaXL */
  double *IP_RhsLambdaXL;

 /* WORHP IP: right-hand-side of LambdaXU */
  double *IP_RhsLambdaXU;

 /* WORHP IP: right-hand-side of LambdaSL */
  double *IP_RhsLambdaSL;

 /* WORHP IP: right-hand-side of LambdaSU */
  double *IP_RhsLambdaSU;

 /* WORHP IP: right-hand-side of Mu (temporary storage, e.g. for second-order-corrections) */
  double *IP_RhsCorrectMu;
  size_t dim_IP_ResX;
  size_t dim_IP_ResS;
  size_t dim_IP_ResMu;
  size_t dim_IP_ResLambdaXL;
  size_t dim_IP_ResLambdaXU;
  size_t dim_IP_ResLambdaSL;
  size_t dim_IP_ResLambdaSU;

 /* WORHP IP: residual of X */
  double *IP_ResX;

 /* WORHP IP: residual of S */
  double *IP_ResS;

 /* WORHP IP: residual of Mu */
  double *IP_ResMu;

 /* WORHP IP: residual of LambdaXL */
  double *IP_ResLambdaXL;

 /* WORHP IP: residual of LambdaXU */
  double *IP_ResLambdaXU;

 /* WORHP IP: residual of LambdaSL */
  double *IP_ResLambdaSL;

 /* WORHP IP: residual of LambdaSU */
  double *IP_ResLambdaSU;
  size_t dim_IP_LeqCheckRhsX;
  size_t dim_IP_LeqCheckRhsS;
  size_t dim_IP_LeqCheckRhsMu;
  size_t dim_IP_LeqCheckRhsLambdaXL;
  size_t dim_IP_LeqCheckRhsLambdaXU;
  size_t dim_IP_LeqCheckRhsLambdaSL;
  size_t dim_IP_LeqCheckRhsLambdaSU;
  size_t dim_IP_LeqCheckRhsX0;
  size_t dim_IP_LeqCheckRhsS0;
  size_t dim_IP_LeqCheckRhsMu0;
  size_t dim_IP_LeqCheckRhsLambdaXL0;
  size_t dim_IP_LeqCheckRhsLambdaXU0;
  size_t dim_IP_LeqCheckRhsLambdaSL0;
  size_t dim_IP_LeqCheckRhsLambdaSU0;

 /* WORHP IP: right-hand-side for linear equation system check of X */
  double *IP_LeqCheckRhsX;

 /* WORHP IP: right-hand-side for linear equation system check of S */
  double *IP_LeqCheckRhsS;

 /* WORHP IP: right-hand-side for linear equation system check of Mu */
  double *IP_LeqCheckRhsMu;

 /* WORHP IP: right-hand-side for linear equation system check of LambdaXL */
  double *IP_LeqCheckRhsLambdaXL;

 /* WORHP IP: right-hand-side for linear equation system check of LambdaXU */
  double *IP_LeqCheckRhsLambdaXU;

 /* WORHP IP: right-hand-side for linear equation system check of LambdaSL */
  double *IP_LeqCheckRhsLambdaSL;

 /* WORHP IP: right-hand-side for linear equation system check of LambdaSU */
  double *IP_LeqCheckRhsLambdaSU;

 /* WORHP IP: right-hand-side for linear equation system check of X (unperturbed) */
  double *IP_LeqCheckRhsX0;

 /* WORHP IP: right-hand-side for linear equation system check of S (unperturbed) */
  double *IP_LeqCheckRhsS0;

 /* WORHP IP: right-hand-side for linear equation system check of Mu (unperturbed) */
  double *IP_LeqCheckRhsMu0;

 /* WORHP IP: right-hand-side for linear equation system check of LambdaXL (unperturbed) */
  double *IP_LeqCheckRhsLambdaXL0;

 /* WORHP IP: right-hand-side for linear equation system check of LambdaXU (unperturbed) */
  double *IP_LeqCheckRhsLambdaXU0;

 /* WORHP IP: right-hand-side for linear equation system check of LambdaSL (unperturbed) */
  double *IP_LeqCheckRhsLambdaSL0;

 /* WORHP IP: right-hand-side for linear equation system check of LambdaSU (unperturbed) */
  double *IP_LeqCheckRhsLambdaSU0;
  size_t dim_IP_DLxFeas;
  size_t dim_IP_DLsFeas;

 /* WORHP IP: gradient of lagrangian of feasibility problem w.r.t. x */
  double *IP_DLxFeas;

 /* WORHP IP: gradient of lagrangian of feasibility problem w.r.t. x */
  double *IP_DLsFeas;
  size_t dim_IP_DLxAugMu;
  size_t dim_IP_DLsAugMu;

 /* WORHP IP: gradient of lagrangian with augmented mu w.r.t. x */
  double *IP_DLxAugMu;

 /* WORHP IP: gradient of lagrangian with augmented mu w.r.t. x */
  double *IP_DLsAugMu;
  size_t dim_IP_DGDX;
  size_t dim_IP_DGDStdX;
  size_t dim_IP_DGDSensBarX;
  size_t dim_IP_DGDSensBarShiftX;
  size_t dim_IP_DGDSensPenObjX;
  size_t dim_IP_DGDSensPenFeasX;
  size_t dim_IP_DGDSensAugMuX;
  size_t dim_IP_DGDCorrectX;
  size_t dim_IP_DGTDMu;
  size_t dim_IP_DGTDStdMu;
  size_t dim_IP_DGTDSensBarMu;
  size_t dim_IP_DGTDSensBarShiftMu;
  size_t dim_IP_DGTDSensPenObjMu;
  size_t dim_IP_DGTDSensPenFeasMu;
  size_t dim_IP_DGTDSensAugMuMu;
  size_t dim_IP_DGTDCorrectMu;
  size_t dim_IP_HMDX;
  size_t dim_IP_HMDStdX;
  size_t dim_IP_HMDSensBarX;
  size_t dim_IP_HMDSensBarShiftX;
  size_t dim_IP_HMDSensPenObjX;
  size_t dim_IP_HMDSensPenFeasX;
  size_t dim_IP_HMDSensAugMuX;
  size_t dim_IP_HMDCorrectX;

 /* WORHP IP: Result of the product DG * DX */
  double *IP_DGDX;

 /* WORHP IP: Result of the product DG * DStdX */
  double *IP_DGDStdX;

 /* WORHP IP: Result of the product DG * DSensBarX */
  double *IP_DGDSensBarX;

 /* WORHP IP: Result of the product DG * DSensBarShiftX */
  double *IP_DGDSensBarShiftX;

 /* WORHP IP: Result of the product DG * DSensPenObjX */
  double *IP_DGDSensPenObjX;

 /* WORHP IP: Result of the product DG * DSensPenFeasX */
  double *IP_DGDSensPenFeasX;

 /* WORHP IP: Result of the product DG * DSensAugMuX */
  double *IP_DGDSensAugMuX;

 /* WORHP IP: Result of the product DG * DCorrectX */
  double *IP_DGDCorrectX;

 /* WORHP IP: Result of the product DGT * DMu */
  double *IP_DGTDMu;

 /* WORHP IP: Result of the product DGT * DStdMu */
  double *IP_DGTDStdMu;

 /* WORHP IP: Result of the product DGT * DSensBarMu */
  double *IP_DGTDSensBarMu;

 /* WORHP IP: Result of the product DGT * DSensBarShiftMu */
  double *IP_DGTDSensBarShiftMu;

 /* WORHP IP: Result of the product DGT * DSensPenObjMu */
  double *IP_DGTDSensPenObjMu;

 /* WORHP IP: Result of the product DGT * DSensPenFeasMu */
  double *IP_DGTDSensPenFeasMu;

 /* WORHP IP: Result of the product DGT * DSensAugMuMu */
  double *IP_DGTDSensAugMuMu;

 /* WORHP IP: Result of the product DGT * DCorrectMu */
  double *IP_DGTDCorrectMu;

 /* WORHP IP: Result of the product HM * DX */
  double *IP_HMDX;

 /* WORHP IP: Result of the product HM * DStdX */
  double *IP_HMDStdX;

 /* WORHP IP: Result of the product HM * DSensBarX */
  double *IP_HMDSensBarX;

 /* WORHP IP: Result of the product HM * DSensBarShiftX */
  double *IP_HMDSensBarShiftX;

 /* WORHP IP: Result of the product HM * DSensPenObjX */
  double *IP_HMDSensPenObjX;

 /* WORHP IP: Result of the product HM * DSensPenFeasX */
  double *IP_HMDSensPenFeasX;

 /* WORHP IP: Result of the product HM * DSensAugMuX */
  double *IP_HMDSensAugMuX;

 /* WORHP IP: Result of the product HM * DCorrectX */
  double *IP_HMDCorrectX;
  size_t dim_IP_AugMu;
  size_t dim_IP_AugLambdaXL;
  size_t dim_IP_AugLambdaXU;
  size_t dim_IP_AugLambdaSL;
  size_t dim_IP_AugLambdaSU;
  size_t dim_IP_AugLambdaTrialXL;
  size_t dim_IP_AugLambdaTrialXU;
  size_t dim_IP_AugLambdaTrialSL;
  size_t dim_IP_AugLambdaTrialSU;

 /* WORHP IP: augmented lagrangian parameter for Mu */
  double *IP_AugMu;

 /* WORHP IP: augmented lagrangian parameter for LambdaXL */
  double *IP_AugLambdaXL;

 /* WORHP IP: augmented lagrangian parameter for LambdaXU */
  double *IP_AugLambdaXU;

 /* WORHP IP: augmented lagrangian parameter for LambdaSL */
  double *IP_AugLambdaSL;

 /* WORHP IP: augmented lagrangian parameter for LambdaSU */
  double *IP_AugLambdaSU;

 /* WORHP IP: trial augmented lagrangian parameter for LambdaXL */
  double *IP_AugLambdaTrialXL;

 /* WORHP IP: trial augmented lagrangian parameter for LambdaXU */
  double *IP_AugLambdaTrialXU;

 /* WORHP IP: trial augmented lagrangian parameter for LambdaSL */
  double *IP_AugLambdaTrialSL;

 /* WORHP IP: trial augmented lagrangian parameter for LambdaSU */
  double *IP_AugLambdaTrialSU;

 /* WORHP IP: flag for evaluation of optimality of modified problem */
  bool IP_EvalOpti;

 /* WORHP IP: flag for evaluation of optimality of feasibility problem */
  bool IP_EvalOptiFeasApprox;

 /* WORHP IP: flag for evaluation of optimality of feasibility problem */
  bool IP_EvalOptiFeas;

 /* WORHP IP: flag for evaluation of optimality of fritz-john problem */
  bool IP_EvalOptiFritzJohn;

 /* WORHP IP: flag for evaluation of optimality with aug mu */
  bool IP_EvalOptiAugMu;

 /* WORHP IP: flag for evaluation of feasibility complementarity */
  bool IP_EvalComplFeas;

 /* WORHP IP: flag for evaluation of fritz-john complementarity */
  bool IP_EvalComplFritzJohn;

 /* WORHP IP: flag for evaluation of barrier objective */
  bool IP_EvalObjBarr;

 /* WORHP IP: flag for evaluation of barrier / penalty objective */
  bool IP_EvalObjBarrPen;

 /* WORHP IP: flag for evaluation of feasibility */
  bool IP_EvalFeas;

 /* WORHP IP: flag for evaluation of feasibility w.r.t. box constraints */
  bool IP_EvalFeasBox;

 /* WORHP IP: flag for evaluation of barrier/penalty feasibility */
  bool IP_EvalFeasBarrPen;

 /* WORHP IP: flag for evaluation of modified complementarity */
  bool IP_EvalCompl;

 /* WORHP IP: flag for evaluation of barrier complementarity */
  bool IP_EvalComplBarr;

 /* WORHP IP: flag for evaluation of barrier complementarity */
  bool IP_EvalComplBarrInv;

 /* WORHP_IP: indicates if gradient of lagrangian of feasibility problem needs to be evaluated */
  bool IP_EvalGradLagrFeas;

 /* WORHP_IP: indicates if gradient of lagrangian needs to be evaluated (full space) */
  bool IP_EvalGradLagrFull;

 /* WORHP IP: flag for evaluation of descent of (scaled) problem (step std) */
  bool IP_EvalDescD;

 /* WORHP IP: flag for evaluation of descent of barrier problem (step std) */
  bool IP_EvalDescBarrD;

 /* WORHP IP: flag for evaluation of descent of barrier / penalty problem (step std) */
  bool IP_EvalDescBarrPenD;

 /* WORHP IP: flag for evaluation of descent of feasibility problem (step std) */
  bool IP_EvalDescFeasD;

 /* WORHP IP: flag for evaluation of stable descent for standard step */
  bool IP_EvalDescLeqD;

 /* WORHP IP: flag for evaluation of gradient of lagrangian of feasibility problem */
  bool IP_EvalDLFeas;

 /* WORHP IP: flag for evaluation of gradient of lagrangian with augmented mu */
  bool IP_EvalDLAugMu;

 /* WORHP IP: flag for evaluation of step */
  bool IP_EvalD;

 /* WORHP IP: flag for evaluation of step (std) */
  bool IP_EvalDStd;

 /* WORHP IP: flag for evaluation of step (sens bar) */
  bool IP_EvalDSensBar;

 /* WORHP IP: flag for evaluation of step (sens bar shift) */
  bool IP_EvalDSensBarShift;

 /* WORHP IP: flag for evaluation of step (sens pen obj) */
  bool IP_EvalDSensPenObj;

 /* WORHP IP: flag for evaluation of step (sens pen feas) */
  bool IP_EvalDSensPenFeas;

 /* WORHP IP: flag for evaluation of step (sens aug mu) */
  bool IP_EvalDSensAugMu;

 /* WORHP IP: flag for evaluation of dual trust region condition of mu */
  bool IP_EvalDualTrustRegionMu;

 /* WORHP IP: flag for evaluation of dual trust region condition of lambda */
  bool IP_EvalDualTrustRegionLambda;

 /* WORHP IP: flag for evaluation of merit function part for penalty subproblem feasibility */
  bool IP_EvalMeritFeasPen;

 /* WORHP IP: flag for evaluation of merit function part for barrier subproblem complementarity */
  bool IP_EvalMeritComplBarr;

 /* WORHP IP: tolerance for the barrier subproblem. */
  double IP_TolBarr;

 /* WORHP IP: tolerance for the barrier / penalty subproblem. */
  double IP_TolBarrPen;

 /* WORHP IP: lowpass filter for original (scaled) problem */
  double IP_Lowpass;

 /* WORHP IP: lowpass filter for barrier problem */
  double IP_LowpassBarr;

 /* WORHP IP: lowpass filter for penalty problem */
  double IP_LowpassBarrPen;

 /* WORHP IP: flag to indicate if problem has been unmodified */
  bool IP_ModifiedOpt;

 /* WORHP IP: iteration counter for iterations after problem has been unmodified */
  counter IP_UnmodifiedIter;

 /* WORHP IP: iteration counter for how long the problem has been feasible */
  counter IP_IterFeasible;

 /* WORHP IP: filter for checking global convergence of adaptive mode */
  FilterNode *IP_AdaptFilter;

 /* WORHP IP: number of initial filter entries of adapt filter */
  int IP_AdaptFilterInitNum;
  size_t dim_IP_HistoryIterKkt;
  size_t dim_IP_HistoryIterFeas;
  size_t dim_IP_HistoryBarrPenOptKkt;
  size_t dim_IP_HistoryAugLambdaUpdateBarrKkt;
  size_t dim_IP_HistoryAugLambdaUpdateKkt;

 /* WORHP IP: old kkt value of last iterations */
  double *IP_HistoryIterKkt;

 /* WORHP IP: old feasibility of last iterations */
  double *IP_HistoryIterFeas;

 /* WORHP IP: old KKT conditions of barrier / penalty problem of iterations in which it has been optimal */
  double *IP_HistoryBarrPenOptKkt;

 /* WORHP IP: old KKT conditions of barrier problem of iterations in which augmented lambda has been updated */
  double *IP_HistoryAugLambdaUpdateBarrKkt;

 /* WORHP IP: old KKT conditions original problem of iterations in which augmented lambda has been updated */
  double *IP_HistoryAugLambdaUpdateKkt;

 /* WORHP IP: flag if algorithm has been initialized */
  bool IP_Initialized;

 /* WORHP IP: iterations of centering steps */
  counter IP_IterCentering;

 /* WORHP IP: general status of subroutines. */
  int IP_Status;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_RESTART. */
  int IP_StatusInitRestart;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_MODIFY. */
  int IP_StatusInitModify;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_PARAMETER. */
  int IP_StatusInitParameter;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_PREPARE. */
  int IP_StatusInitPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_ESTIMATE. */
  int IP_StatusInitEstimate;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_CENTERING. */
  int IP_StatusInitCentering;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_FINALIZE. */
  int IP_StatusInitFinalize;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_PREPARE. */
  int IP_StatusCheckPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_ADAPT. */
  int IP_StatusCheckAdapt;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK. */
  int IP_StatusCheck;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_INFEAS. */
  int IP_StatusCheckInfeas;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_BARRIER. */
  int IP_StatusCheckBarrier;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_PENALTY. */
  int IP_StatusCheckPenalty;

 /* WORHP IP: status of stage WORHP_STAGE_IP_UPDATE_BARRIER. */
  int IP_StatusUpdateBarrier;

 /* WORHP IP: status of stage WORHP_STAGE_IP_UPDATE_PENALTY. */
  int IP_StatusUpdatePenalty;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LEQ_PREPARE. */
  int IP_StatusLeqPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LEQ_CREATE. */
  int IP_StatusLeqCreate;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LEQ_CHECK. */
  int IP_StatusLeqCheck;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LEQ_REGULARIZE. */
  int IP_StatusLeqRegularize;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LEQ_IMPROVE. */
  int IP_StatusLeqImprove;

 /* WORHP IP: status of stage WORHP_STAGE_IP_STEP. */
  int IP_StatusStep;

 /* WORHP IP: status of stage WORHP_STAGE_IP_REFINE_PREPARE. */
  int IP_StatusRefinePrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_REFINE_STEP. */
  int IP_StatusRefineStep;

 /* WORHP IP: status of stage WORHP_STAGE_IP_REFINE_ABORT. */
  int IP_StatusRefineAbort;

 /* WORHP IP: status of stage WORHP_STAGE_IP_ADAPT_PREPARE. */
  int IP_StatusAdaptPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_ADAPT_BARRIER. */
  int IP_StatusAdaptBarrier;

 /* WORHP IP: status of stage WORHP_STAGE_IP_ADAPT_PENALTY. */
  int IP_StatusAdaptPenalty;

 /* WORHP IP: status of stage WORHP_STAGE_IP_ADAPT_SELECT. */
  int IP_StatusAdaptSelect;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_PREPARE. */
  int IP_StatusLinePrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_BACKUP_PREPARE. */
  int IP_StatusLineBackupPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_UPDATEPRIMAL. */
  int IP_StatusLineUpdatePrimal;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_UPDATEDUAL. */
  int IP_StatusLineUpdateDual;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_CHECK. */
  int IP_StatusLineCheck;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_REDUCEPRIMAL. */
  int IP_StatusLineReducePrimal;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_REDUCEDUAL. */
  int IP_StatusLineReduceDual;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CORRECT_PREPARE. */
  int IP_StatusCorrectPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CORRECT_STEP. */
  int IP_StatusCorrectStep;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CORRECT_ABORT. */
  int IP_StatusCorrectAbort;

 /* WORHP IP: status of stage WORHP_STAGE_IP_FINALIZE. */
  int IP_StatusFinalize;

 /* WORHP Line: current primal stepsize */
  double Line_AlphaX;

 /* WORHP Line: primal stepsize before second-order-correction */
  double Line_Alpha0X;

 /* WORHP Line: primal step size of last iteration */
  double Line_AlphaOldX;

 /* WORHP Line: maximum primal stepsize */
  double Line_AlphaMaxX;

 /* WORHP Line: current lambda stepsize */
  double Line_AlphaLambda;

 /* WORHP Line: lambda stepsize before second-order-correction */
  double Line_Alpha0Lambda;

 /* WORHP Line: lambda step size of last iteration */
  double Line_AlphaOldLambda;

 /* WORHP Line: maximum lambda stepsize */
  double Line_AlphaMaxLambda;

 /* WORHP Line: current mu stepsize */
  double Line_AlphaMu;

 /* WORHP Line: mu stepsize before second-order-correction */
  double Line_Alpha0Mu;

 /* WORHP Line: mu step size of last iteration */
  double Line_AlphaOldMu;

 /* WORHP Line: maximum mu stepsize */
  double Line_AlphaMaxMu;

 /* WORHP Line: maximal step size */
  double Line_AlphaMax;

 /* WORHP Line: minimal step size */
  double Line_AlphaMin;

 /* WORHP Line: indicates if full step can be taken (all max alpha are one) */
  bool Line_AlphaMaxFull;

 /* WORHP Line: global filter */
  FilterNode *Line_FilterGlobal;

 /* WORHP Line: local filter */
  FilterNode *Line_FilterLocal;

 /* WORHP Line: CV threshold for switching condition */
  double Line_FilterCVmin;

 /* WORHP Line: filter criteria objective */
  double Line_FilterObj;

 /* WORHP Line: filter criteria feasibility */
  double Line_FilterFeas;

 /* WORHP Line: descent for filter obejctive */
  double Line_FilterDesc;

 /* WORHP Line: filter criteria objective without step */
  double Line_FilterObj0;

 /* WORHP Line: filter criteria feasibility without step */
  double Line_FilterFeas0;

 /* WORHP Line: filter criteria feasibility at the beginning of the optimization */
  double Line_FilterFeasInit;

 /* WORHP Line: envelope of obj dimension in filter */
  double Line_FilterEnvObj;

 /* WORHP Line: envelope of feas dimension in filter */
  double Line_FilterEnvFeas;

 /* WORHP Line: envelope basis (e.g. constraint violation) */
  double Line_FilterEnvBase;

 /* WORHP Line: initial number of elements in local filter */
  int Line_FilterLocalInitNum;

 /* WORHP Line: merit function value. */
  double Line_Merit;

 /* WORHP Line: merit function objective value. */
  double Line_MeritObj;

 /* WORHP Line: merit function constraint violation value. */
  double Line_MeritFeas;

 /* WORHP Line: descent for merit function objective */
  double Line_MeritDescObj;

 /* WORHP Line: descent (quadratic part) for merit function objective */
  double Line_MeritDescQuadObj;

 /* WORHP Line: descent for merit function constraint violation */
  double Line_MeritDescFeas;

 /* WORHP Line: merit function value without step. */
  double Line_Merit0;

 /* WORHP Line: merit function of last step. */
  double Line_MeritOld;
  size_t dim_Line_MeritHistory;

 /* WORHP Line: historic data for nonmonotone merit line search */
  double *Line_MeritHistory;

 /* WORHP Line: penalty parameter for merit function */
  double Line_MeritPenalty;

 /* WORHP Line: merit function value. */
  double Line_MeritKkt;

 /* WORHP Line: descent for merit function */
  double Line_MeritKktDesc;

 /* WORHP Line: merit function value without step. */
  double Line_MeritKkt0;

 /* WORHP Line: merit function of last step. */
  double Line_MeritKktOld;
  size_t dim_Line_MeritKktHistory;

 /* WORHP Line: historic data for nonmonotone merit line search */
  double *Line_MeritKktHistory;

 /* WORHP LINE: iteration counter of line search */
  counter Line_Iter;

 /* WORHP LINE: iteration counter of second order corrections */
  counter Line_IterCorrect;

 /* WORHP LINE: iteration counter of refinement steps */
  counter Line_IterRefine;

 /* WORHP LINE: status after evaluation of Line stage. */
  int Line_Status;

 /* WORHP LINE: current phase of line search (local/global) */
  int Line_Phase;

 /* WORHP LINE: current mode */
  int Line_Mode;

 /* WORHP LINE: indicator if non-monotone mode is activated */
  bool Line_Nonmon;

 /* WORHP LINE: method that accepted the step */
  int Line_AcceptMethod;

 /* WORHP LINE: phase that accepted the step */
  int Line_AcceptPhase;

 /* WORHP Line: indicator if line search should work in constrained mode */
  bool Line_Constrained;

 /* WORHP Line: number of different methods to choose */
  int Line_MethodNum;
  size_t dim_Line_MethodInitStep;
  size_t dim_Line_MethodCheck;

 /* WORHP Line: number of different backup methods to choose */
  int Line_MethodBackupNum;
  size_t dim_Line_MethodBackupInitStep;
  size_t dim_Line_MethodBackupCheck;

 /* WORHP LINE: selects method (filter, merit function...) */
  int *Line_MethodInitStep;

 /* WORHP LINE: selects method (filter, merit function...) */
  int *Line_MethodCheck;

 /* WORHP LINE: selects backup method (filter, merit function...) */
  int *Line_MethodBackupInitStep;

 /* WORHP LINE: selects backup method (filter, merit function...) */
  int *Line_MethodBackupCheck;

 /* WORHP LINE: selects method (filter, merit function...) */
  int Line_MethodReduce;

 /* WORHP LINE: selects backup method (filter, merit function...) */
  int Line_MethodBackupReduce;

 /* WORHP LINE: flag for needed update of primal variables */
  bool Line_UpdatePrimal;

 /* WORHP LINE: flag for needed update of dual variables */
  bool Line_UpdateDual;

 /* WORHP LINE: flag for needed user derivative evaluations */
  bool Line_NeedUserDeriv;

 /* WORHP LINE: number of non monotone level of merit approach */
  int Line_MeritNonmon;

 /* WORHP LINE: number of non monotone level of merit kkt approach */
  int Line_MeritKktNonmon;

 /* WORHP LINE: number of non monotone level of filter approach */
  int Line_FilterNonmon;

 /* WORHP LINE: enables step size interpolation. */
  bool Line_Interp;

 /* WORHP LINE: min decrease in relation to old step size */
  double Line_InterpMin;

 /* WORHP LINE: max decrease in relation to old step size */
  double Line_InterpMax;

 /* WORHP LINE: armijo beta for step size reduction. */
  double Line_ArmijoBeta;

 /* WORHP LINE: reduction factor for armijo condition. */
  double Line_ArmijoEta;

 /* WORHP LINE: filter objective decrease factor */
  double Line_FilterGammaObj;

 /* WORHP LINE: filter constraint violation decrease factor */
  double Line_FilterGammaFeas;

 /* Derivative DG_P for post analysis */
  WorhpMatrix ZenDGp;

 /* Derivative DL_XP (Lagrangian) for post analysis */
  WorhpMatrix ZenDLxp;

 /* Derivative DL_P (Lagrangian) for post analysis */
  WorhpMatrix ZenDLp;

 /* Derivative DL_PP (Lagrangian) for post analysis */
  WorhpMatrix ZenDLpp;

 /* Sensitivity derivatives dx/dp, d^2f/(dr*dq). */
  WorhpMatrix ZenDx_pDf2_rp;

 /* Sensitivity derivatives dx/dr, d^2f/dr^2. Symmetric. */
  WorhpMatrix ZenDx_rDf2_rr;

 /* Sensitivity derivative dx/dq, (dmu/dr)^T, d^2f/(dr*dq). */
  WorhpMatrix ZenDx_qDm_rDf2_rq;

 /* Sensitivity derivative dmu/dp, d^2f/(dq*dp). */
  WorhpMatrix ZenDm_pDf2_qp;

 /* Sensitivity derivative dmu/dq, df^2/dq^2. Symmetric. */
  WorhpMatrix ZenDm_qDf2_qq;

 /* Sensitivity derivative dlambda/dp, d^2f/(db*dp). */
  WorhpMatrix ZenDl_pDf2_bp;

 /* Sensitivity derivative (dx/db)^T, dlambda/dr, d^2f/(db*dr). */
  WorhpMatrix ZenDl_rDx_bDf2_br;

 /* Sensitivity derivative (dmu/db)^T, dlambda/dq, d^2f/(db*dq). */
  WorhpMatrix ZenDl_qDm_bDf2_bq;

 /* Sensitivity derivative dlambda/db, d^2f/db^2. Symmetric. */
  WorhpMatrix ZenDl_bDf2_bb;

 /* Sensitivity derivative df/dp. Vector. */
  WorhpMatrix ZenDf_p;

 /* Sensitivity derivative d^2f/dp^2. Symmetric. */
  WorhpMatrix ZenDf2_pp;

 /* Sensitivity derivative dg/dp. */
  WorhpMatrix ZenDg_p;

 /* Sensitivity derivative dg/dr. */
  WorhpMatrix ZenDg_r;

 /* Sensitivity derivative dg/dq. */
  WorhpMatrix ZenDg_q;

 /* Sensitivity derivative dg/db. */
  WorhpMatrix ZenDg_b;
  size_t dim_ZenDX;
  size_t dim_ZenDM;
  size_t dim_ZenDL;
  size_t dim_ZenDG;
  size_t dim_ZenDF;
  size_t dim_ZenDF2;

 /* sensitivity of x */
  double *ZenDX;

 /* sensitivity of mu */
  double *ZenDM;

 /* sensitivity of lambda */
  double *ZenDL;

 /* sensitivity of g */
  double *ZenDG;

 /* sensitivity of f */
  double *ZenDF;

 /* sensitivity of f */
  double *ZenDF2;
  size_t dim_ZenStatus;
  size_t dim_ZenStatus2;

 /* Calculation status of sensitivity derivatives of x */
  bool *ZenStatusDX;

 /* Calculation status of sensitivity derivatives of mu */
  bool *ZenStatusDM;

 /* Calculation status of sensitivity derivatives of lambda */
  bool *ZenStatusDL;

 /* Calculation status of sensitivity derivatives of f */
  bool *ZenStatusDF;

 /* Calculation status of sensitivity derivatives of f */
  bool *ZenStatusDF2;

 /* Calculation status of sensitivity derivatives of g */
  bool *ZenStatusDG;

 /*------------------------------------------------
  *  Filter nodes
  *------------------------------------------------ */
  FilterNode *FirstFilterNode;

 /*------------------------------------------------
  *  QP Workspace
  *------------------------------------------------ */
  QPWorkspace qp;

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker01;

 /*------------------------------------------------
  *  Matrices
  *------------------------------------------------ */
  WorhpMatrix DF;
  WorhpMatrix DG;
  WorhpMatrix DL;
  WorhpMatrix oldDL;
  WorhpMatrix HM;
  WorhpMatrix HM_bfgs;
  WorhpMatrix ID;
  WorhpMatrix Q;
  WorhpMatrix A;
  WorhpMatrix C;

 /* Incidence matrix for group algorithms */
  WorhpMatrix Inc;

 /* RHS for calculation of sensitivity for correction step. */
  WorhpMatrix Bstep_RHS;

 /* Sensitivity derivative for correction step dmu/dq. */
  WorhpMatrix Bstep_dmudq;

 /* Perturbation for sensitivity analysis in correction step. */
  WorhpMatrix BstepPerturbG;

 /* Search direction in correction step. */
  WorhpMatrix BstepDx;

 /* Search direction for lagrangian multipliers in correction step. */
  WorhpMatrix BstepDMu;

 /* Saves final lagrange multiplier for lower box constraints. */
  WorhpMatrix BstepInitialZL;

 /* Saves final lagrange multiplier for upper box constraints. */
  WorhpMatrix BstepInitialZU;

 /* Saves the last 2 iterates of the primal variables to perform a Steffensen Extrapolation step. */
  WorhpMatrix BstepSteffensenOldIterates;

 /* Saves the last 2 iterates of the dual variables (box constraints) to perform a Steffensen Extrapolation step. */
  WorhpMatrix BstepSteffensenOldLambdas;

 /* Saves the last 2 iterates of the dual variables (general constraints) to perform a Steffensen Extrapolation step. */
  WorhpMatrix BstepSteffensenOldMus;

 /* FIFO for F values */
  WorhpQueue QueueF;

 /* FIFO for constraint violations */
  WorhpQueue QueueCV;

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker02;

 /*------------------------------------------------
  *  Reals
  *------------------------------------------------ */

 /* = |dT*H*d|                           [SCAL] */
  double Abs_Curvature;

 /* CV value of best-so-far acceptable solution */
  double AcceptCV;

 /* F value of best-so-far acceptable solution */
  double AcceptF;

 /* Scaled value of optimality of best-so-far acceptable solution */
  double AcceptOptiMax;

 /* Unscaled value of optimality of best-so-far acceptable solution */
  double AcceptOptiOrigMax;

 /* Scaled complementarity value of best-so-far acceptable solution */
  double AcceptComplMax;

 /* Unscaled complementarity value of best-so-far acceptable solution */
  double AcceptComplOrigMax;

 /* ScaleObj value of best-so-far acceptable solution */
  double AcceptScaleObj;

 /* Armijo stepsize                      [ALPHA] */
  double ArmijoAlpha;

 /* Betts-update parameter               [ACTUAL] */
  double BettsActual;

 /* Betts-update parameter               [OLDRHO] */
  double BettsOldRho;

 /* Betts-update parameter               [PRDTED] */
  double BettsPredicted;

 /* Used for calculating the Bettsupdate */
  double BettsRho;

 /* Betts-update parameter */
  double BettsSigma;

 /* Sum of Betts-update parameter for AutoQPRecovery */
  double BettsSumTau;

 /* Betts-update parameter               [TAU] */
  double BettsTau;

 /* Betts-update: Value added to HM diag */
  double BettsValue;

 /* Maximum constraint violation at uncorrected next iterate */
  double BstepOldMaxCV;

 /* Value of old Lagrangian function as watch dog for bstep progress */
  double BstepOldLagrangianValue;

 /* Norm of difference between last 2 iterates during Feasibility Refinement */
  double BstepOldIterDiff;

 /* Value of penalty for merit function within BStep */
  double BstepMeritPenalty;

 /* = dT*H*d */
  double Curvature;

 /* df^T*d */
  double Descent;

 /* RC value F0 */
  double F0;

 /* 2-Norm of the vector of inactive constraint violations */
  double InActiveNormG;

 /* Lowpass filter value for F */
  double LowPassF;

 /* Lowpass filter value for G */
  double LowPassG;

 /* Lowpass filter value for the merit function */
  double LowPassMerit;

 /* Derivative of merit function         [FAC] */
  double MeritGradient;

 /* New value of merit function        [VAXLK] */
  double MeritNewValue;

 /* Old value of merit function        [VAL] */
  double MeritOldValue;

 /* 2-norm of QP search direction        [NRMDX] */
  double Norm2_DX;

 /* Max-norm of Constraints Violation    [NRMNB] */
  double NormMax_CV;

 /* Max-norm of Gradient of Lagrangian   [NRMGRD] */
  double NormMax_DL;

 /* old value of F */
  double oldF;

 /* old 2-norm of QP search direction */
  double oldNorm2_DX;

 /* old NormMax value of G */
  double oldNormMaxG;

 /* penalty parameter update             [DELTAK] */
  double PenUpdDeltaK;

 /* penalty parameter update             [R] */
  double PenUpdR;

 /* PostQP-Sensitivity, Suggestion for new value */
  double qppsa_HMReg;

 /* sge: Save value of original IpComTol parameter */
  double SaveIpComTol;

 /* sge: Save value of original IpResTol parameter */
  double SaveIpResTol;

 /* sge: Save value of original LsTol parameter */
  double SaveLsTol;

 /* sge: Maximum violation of optimality criterion */
  double OptiMax;

 /* 2-norm of optimality criterion */
  double Opti2;

 /* Maximum violation of constraint violation */
  double FeasMax;

 /* 2-norm of constraint violation */
  double Feas2;

 /* sge: Maximum violation of complementarity criterion */
  double ComplMax;

 /* 2-norm of complementarity criterion */
  double Compl2;

 /* sge: Maximum violation of optimality criterion (unscaled) */
  double OptiOrigMax;

 /* Maximum violation of constraint violation (unscaled) */
  double FeasOrigMax;

 /* sge: Maximum violation of complementarity criterion (unscaled) */
  double ComplOrigMax;

 /* Scaling for the objective function */
  double ScaleObj;

 /* Scaling for the objective function for the QP */
  double ScaleObjQP;

 /* Minimal trial stepsize. */
  double Alpha_Min;

 /* Betts-update parameter. */
  double CVActual;

 /* Derivative of constraint violation. */
  double CVGradient;

 /* Betts-update parameter. */
  double CVPredicted;

 /* Maximal CV for the initialization of the filter. */
  double CV_Max;

 /* If CV < CV_Min check the the switching condition. */
  double CV_Min;

 /* Betts-update parameter. */
  double FActual;

 /* Constraint violation value of the filter entry which dominates the trial iterate. */
  double FilterDominatingCV;

 /* Objective function value of the filter entry which dominates the trial iterate. */
  double FilterDominatingF;

 /* Constraint violation value at the intersection of the filter envelope with the line that connects the previous iterate with the current trial iterate. */
  double FilterIntersectionCV;

 /* Betts-update parameter. */
  double FPredicted;

 /* Original df^T*d for accelerating heuristic (ignore criteria). */
  double olddescent;

 /* Betts-update parameter. */
  double PrevBettsTau;

 /* Initial value of the objective function. */
  double StartF;

 /* Machine epsilon */
  double eps;

 /*------------------------------------------------
  *  Variable size arrays
  *------------------------------------------------ */
  size_t dim_hm_fidif;
  size_t dim_adaptiveRelax;
  size_t dim_BStepFeasActiveSet;
  size_t dim_idxXeq;
  size_t dim_idxXneq;
  size_t dim_idxXneqInv;
  size_t dim_idxXieq;
  size_t dim_idxXieqLow;
  size_t dim_idxXieqUp;
  size_t dim_idxGeq;
  size_t dim_idxGieq;
  size_t dim_idxGieqLow;
  size_t dim_idxGieqUp;
  size_t dim_idxDGGeq;
  size_t dim_idxDGGieq;
  size_t dim_idxDGGieqLow;
  size_t dim_idxDGGieqUp;
  size_t dim_idxDGGieqLowUp;

 /* values vector for finite differences sparse Hessian */
  double *hm_fidif;

 /* states the algorithm that terminated (un-)successfully */
  int AlgorithmTerminated;

 /* sge: Save correspondence between relaxation variables and constraints */
  int *adaptiveRelax;

 /* Vector of activity indicators for feasibility refinementq */
  int *BStepFeasActiveSet;

 /* index map for equality box constraints */
  int *idxXeq;

 /* index map for non-equality box constraints */
  int *idxXneq;

 /* index map like idxXneq but other way round */
  int *idxXneqInv;

 /* index map for inequality box constraints */
  int *idxXieq;

 /* index map for lower inequality box constraints */
  int *idxXieqLow;

 /* index map for upper inequality box constraints */
  int *idxXieqUp;

 /* index map for equality constraints */
  int *idxGeq;

 /* index map for inequality constraints */
  int *idxGieq;

 /* index map for lower inequality constraints */
  int *idxGieqLow;

 /* index map for upper inequality constraints */
  int *idxGieqUp;

 /* sge: index map for DG only equality constraints */
  int *idxDGGeq;

 /* sge: index map for DG only inequality constraints */
  int *idxDGGieq;

 /* sge: index map for DG only inequality constraints with lower bound */
  int *idxDGGieqLow;

 /* sge: index map for DG only inequality constraints with upper bound */
  int *idxDGGieqUp;

 /* sge: index map for DG inequality constraints with upper and lower bound */
  int *idxDGGieqLowUp;
  size_t dim_bstepSaveRHS;
  size_t dim_dfdense;
  size_t dim_relaxDelta;
  size_t dim_penalty;
  size_t dim_qpIdxMap;
  size_t dim_qpIdxMapInvA;
  size_t dim_qpIdxMapInvC;
  size_t dim_qpeqrhs;
  size_t dim_qpierhs;
  size_t dim_qpdx;
  size_t dim_qpdx_reg;
  size_t dim_qpdx_relax;
  size_t dim_qpdx_backup;
  size_t dim_qpeqlm;
  size_t dim_qpeqlm_reg;
  size_t dim_qpeqlm_relax;
  size_t dim_qpeqlm_backup;
  size_t dim_qpielm;
  size_t dim_qpielm_reg;
  size_t dim_qpielm_relax;
  size_t dim_qpielm_backup;
  size_t dim_QPPSA_relaxPen;
  size_t dim_fidif_ddg;
  size_t dim_fidif_DF_CRrow;
  size_t dim_fidif_HM_groups_DF;
  size_t dim_fidif_nPairgroups;
  size_t dim_fidif_Pairgroups;
  size_t dim_fidif_Relentries;
  size_t dim_fidif_Relvars;
  size_t dim_fidif_savex;
  size_t dim_fidif_saveDF;
  size_t dim_fidif_saveDG;
  size_t dim_fidif_saveG0;
  size_t dim_fidif_last_indices;
  size_t dim_newEntriesX;
  size_t dim_saved_userDF;
  size_t dim_saved_userDG;
  size_t dim_saved_userHM;
  size_t dim_BStepOldX;
  size_t dim_SBFGS_blockval;
  size_t dim_SBFGS_blockcsc;
  size_t dim_SBFGS_blockcol;
  size_t dim_SBFGS_blocksize;
  size_t dim_SBFGS_blockstart;
  size_t dim_SBFGS_inblock;
  size_t dim_SBFGS_idxinblock;

 /* Save bstepRHS before realtime update strategy */
  double *bstepSaveRHS;

 /* values of dense objective gradient for QP */
  double *dfdense;

 /* Penalty (ies) for merit function */
  double *penalty;

 /* Relaxation variables for constraints */
  double *relaxDelta;

 /* Mapping from NLP constraints (m) to QP constraints (>= m). Equality constraints are at position nXeq + qpIdxMap(i) within A. Inequality constraints at position qpIdxMap(i) in C. */
  int *qpIdxMap;

 /* Mapping from QP equality constraints (1:ADIM) to NLP constraints (m). (Inv = Inverse) */
  int *qpIdxMapInvA;

 /* Mapping from QP inequality constraints (1:CDIM) to NLP constraints (m). (Inv = Inverse) */
  int *qpIdxMapInvC;

 /* RHS of equalities for QP */
  double *qpeqrhs;

 /* RHS of inequalities for QP */
  double *qpierhs;

 /* Search direction from QP */
  double *qpdx;

 /* sge: Search direction from QP enhanced with sensitivities due to hessian regularisation */
  double *qpdx_reg;

 /* sge: Search direction from QP enhanced with sensitivities due to constraint relaxation */
  double *qpdx_relax;

 /* sge: Original search direction before sensitivity enhanced QP */
  double *qpdx_backup;

 /* LMs of equalities from QP */
  double *qpeqlm;

 /* sge: Updated LMs of equalities from QP with post QP PSA for regularisation */
  double *qpeqlm_reg;

 /* sge: Updated LMs of equalities from QP with post QP PSA for relaxation */
  double *qpeqlm_relax;

 /* sge: Backup of LMs of equalities from QP because of post QP PSA */
  double *qpeqlm_backup;

 /* LMs of inequalities from QP */
  double *qpielm;

 /* sge: Updated LMs of inequalities from QP with post QP PSA for regularisation */
  double *qpielm_reg;

 /* sge: Updated LMs of inequalities from QP with post QP PSA for relaxation */
  double *qpielm_relax;

 /* sge: Updated LMs of inequalities from QP because of post QP PSA */
  double *qpielm_backup;

 /* sge: Vector or Scalar value (depending on par.MoreRelax) to update relaxation penalty using PSA. */
  double *QPPSA_relaxPen;

 /* structure of Hessian without f */
  int *fidif_ddg;

 /* mja: Indices of rowstarts in DFval for fast access in fidif */
  int *fidif_DF_CRrow;

 /* mja: Hessian groups for when calculating finite differences using DF */
  int *fidif_HM_groups_DF;

 /* vector of number of pairgroups */
  int *fidif_nPairgroups;

 /* vector of pairgroups memberships     [hm%nnz] */
  int *fidif_Pairgroups;

 /* vector of relevant entries for hessiangroup creation [opt%m] */
  int *fidif_Relentries;

 /* vector of relevant variables for hessiangroup creation [opt%n] */
  int *fidif_Relvars;

 /* mja: Vector to save old x to restore after perturbation in fidif */
  double *fidif_savex;

 /* mja: Vector to save DF(x0) for fidif */
  double *fidif_saveDF;

 /* mja: Vector to save DG(x0) for fidif */
  double *fidif_saveDG;

 /* mja: Vector to save G(x0) for fidif */
  double *fidif_saveG0;

 /* mja: Vector to store the indices that were last perturbed in fidif and will therefore be reset. */
  int *fidif_last_indices;

 /* mja: Vector that tells the user which entries of x have been changed */
  bool *newEntriesX;

 /* mja: Storage for the DF value provided by the user for comparison with DF from fidif */
  double *saved_userDF;

 /* mja: Storage for the DG value provided by the user for comparison with DG from fidif */
  double *saved_userDG;

 /* ssu: Saves X for Bstep without overwriting OldX for BFGS */
  double *BStepOldX;

 /* mja: Storage for the HM value provided by the user for comparison with HM from fidif */
  double *saved_userHM;

 /* values of SBFGS blocks */
  double *SBFGS_blockval;

 /* CS column vector for SBFGS */
  int *SBFGS_blockcsc;

 /* CC column vector for SBFGS */
  int *SBFGS_blockcol;

 /* size of SBFGS blocks */
  int *SBFGS_blocksize;

 /* vector of first columns for SBFGS */
  int *SBFGS_blockstart;

 /* index vector for SBFGS */
  int *SBFGS_inblock;

 /* index vector for SBFGS */
  int *SBFGS_idxinblock;
  size_t dim_NactiveGc;
  size_t dim_NactiveXc;

 /* cumulated number of active constraints */
  int *NactiveGc;

 /* cumulated number of active box constraints */
  int *NactiveXc;

 /*------------------------------------------------
  *  Workspace stuff
  *------------------------------------------------ */
  size_t niws;
  size_t nrws;
  int *iws;
  double *rws;
  size_t IWMT[WMTrows][WMTslices];
  size_t RWMT[WMTrows][WMTslices];
  char IWMTnames[WMTnames][WMTslices];
  char RWMTnames[WMTnames][WMTslices];

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker03;

 /*------------------------------------------------
  *  WMT indices
  *------------------------------------------------ */

 /* Values of LAMBDA of the last acceptable solution */
  rwmt_index acceptlambda;

 /* Values of Mu of the last acceptable solution */
  rwmt_index acceptmu;

 /* Values of X of the last acceptable solution */
  rwmt_index acceptx;

 /* Active Set flags for G */
  iwmt_index activeSetG;

 /* Index of the QP inequality constraints LM in the general problem */
  iwmt_index activeSetGM;

 /* Index of the QP equality constraints LM in the general problem */
  iwmt_index activeSetGMeq;

 /* Index of the QP inequality constraints LM for qp warmstart */
  iwmt_index activeSetGMwarm;

 /* Active Set flags for X */
  iwmt_index activeSetX;

 /* Active Set flags for X */
  iwmt_index activeSetXUpDown;

 /* for realsparse BFGS */
  iwmt_index degree;

 /* Hessian (symmetric) permutation vector */
  iwmt_index hperm;

 /* Hessian inverse (symmetric) permutation vector */
  iwmt_index hperminv;

 /* Inactive Set indicies for G */
  iwmt_index InActiveSetG;

 /* Used for building the box constraints */
  iwmt_index IXLtemp;

 /* Used for building the box constraints */
  iwmt_index IXUtemp;

 /* New Box LMs                          [LQLAM] */
  rwmt_index newlambda;

 /* New Non-box LMs                      [LQLAM] */
  rwmt_index newmu;

 /* Original LAMBDA for Armijo */
  rwmt_index oldlambda;

 /* Original MU for Armijo */
  rwmt_index oldmu;

 /* Original X for Armijo */
  rwmt_index oldx;

 /* LMs for penalty parameter update     [LPPADD] */
  rwmt_index penmu;

 /* sge: Counter for feasibility refinement iterations */
  counter RefineFeasIter;

 /* mja: Counter for overall feasibility refinement iterations of all major iterations. */
  counter RefineFeasIterOverall;

 /* constraint relaxation penaltys       [RDELTA] */
  rwmt_index RelaxPen;

 /* temporary constraint relaxation penaltys */
  rwmt_index RelaxPenTemp;

 /* Vector of scaling factors for the eq. constraints */
  rwmt_index scalecona;

 /* Vector of scaling factors for the ie. constraints */
  rwmt_index scaleconc;

 /* Vector of scaling factors for the eq. constraints */
  rwmt_index scaleconaWAS;

 /* Vector of scaling factors for the ie. constraints */
  rwmt_index scaleconcWAS;

 /* Original G for Armijo */
  rwmt_index oldg;

 /* Original qpdx for accelerating heuristic (ignore criteria). */
  rwmt_index oldqpdx;

 /* WARMSALL for QP warmstart */
  rwmt_index WARMSALL;

 /* WARMSLALL for QP warmstart */
  rwmt_index WARMSLALL;

 /* WARMSUALL for QP warmstart */
  rwmt_index WARMSUALL;

 /* WARMSALL for QP warmstart */
  rwmt_index WARMZALL;

 /* WARMSLALL for QP warmstart */
  rwmt_index WARMZLALL;

 /* WARMSUALL for QP warmstart */
  rwmt_index WARMZUALL;

 /* Used for building the box constraints */
  rwmt_index XLtemp;

 /* Used for building the box constraints */
  rwmt_index XUtemp;

 /*------------------------------------------------
  *  Counters
  *------------------------------------------------ */

 /* MajorIter corresponding to AcceptMerit */
  counter AcceptMajorIter;

 /* Counter: WORHP calls */
  counter Calls;

 /* ssu: Counts number of 'Find Stepsizes' to display */
  counter FindStepsizeCounter;

 /* Iteration counter for force steps */
  counter ForceIter;

 /* Counter: major (= SQP) iterations */
  counter MajorIter;

 /* Counter: minor (= QP) iterations */
  counter MinorIter;

 /* Counter: overall minor (= QP) iterations of all major iterations. */
  counter MinorIterOverall;

 /* Next Armijo recovery strategy to be used */
  counter NextAres;

 /* Counter for loops with Reverse Communication */
  counter RCCounter;

 /* Counter for loops with Reverse Communication */
  counter RCCounter2;

 /* Counter for loops with Reverse Communication */
  counter RCCounter3;

 /* Counter for loops with Reverse Communication */
  counter RCCounter4;

 /* Counter: Check whether accelerating heuristics would help. */
  counter LScounter;

 /* ssu: Counter for number of 'Update Point' steps to display */
  counter UpdatePointCounter;

 /* mja: Counter for current column in HM while using fidif for HM */
  counter fidif_hm_col;

 /* mja: Counter for current HMval index while using fidif for HMval */
  counter fidif_hm_counter;

 /* mja: Counter for current f-part of HMval index while using fidif for HMval */
  counter fidif_hm_counter_f;

 /* mja: Counter for current g-part of HMval index while using fidif for HMval */
  counter fidif_hm_counter_g;

 /* mja: Counter for current DFval index while using fidif for DFval */
  counter fidif_df_counter;

 /* mja: Counter for current DGval index while using fidif for DGval */
  counter fidif_dg_counter;

 /* mja: Counter for number of calls to WorhpFidif for output */
  counter fidif_calls;

 /*------------------------------------------------
  *  Dimensions and element counts
  *------------------------------------------------ */
  int blocknnz;
  int boxLDIM;
  int boxUDIM;

 /* mja: Number of Hessian groups for when calculating finite differences using DF */
  int fidif_num_HM_groups_DF;

 /* Currently active feasibility mode */
  int CurrentFeasMode;

 /* Number of active general constraints */
  int NactiveG;

 /* Number of active NLP constraints */
  int NactiveGNLP;
  int nbcol;
  int nblock;
  int num_fidif_last_indices;

 /* number of box equality constraints (same naming as index maps) */
  int nXeq;

 /* number of non box equality constraints (same naming as index maps) */
  int nXneq;

 /* number of box inequality constraints (same naming as index maps) */
  int nXieq;

 /* number of box inequality constraints within QP (constraints with lower and upper bound counted twice) */
  int nXieqQP;

 /* number of box inequality constraints with lower bound only (same naming as index maps) */
  int nXieqLow;

 /* number of box inequality constraints with upper bound only (same naming as index maps) */
  int nXieqUp;

 /* number of box inequality constraints with lower and upper bound (same naming as index maps) */
  int nXieqLowUp;

 /* number of general equality constraints (same naming as index maps) */
  int nGeq;

 /* number of general inequality constraints (same naming as index maps) */
  int nGieq;

 /* number of box inequality constraints within QP (constraints with lower and upper bound counted twice) */
  int nGieqQP;

 /* number of general inequality constraints with lower bound only (same naming as index maps) */
  int nGieqLow;

 /* number of general inequality constraints with upper bound only (same naming as index maps) */
  int nGieqUp;

 /* number of general inequality constraints with lower and upper bound (same naming as index maps) */
  int nGieqLowUp;

 /* number of non-zeros of DG that do belong to general equality constraints. */
  int nnzDGGeq;

 /* number of non-zeros of DG that do belong to general inequality constraints. */
  int nnzDGGieq;

 /* number of non-zeros of DG that do belong to general inequality constraints with only lower bound. */
  int nnzDGGieqLow;

 /* number of non-zeros of DG that do belong to general inequality constraints with only upper bound */
  int nnzDGGieqUp;

 /* number of non-zeros of DG that do belong to general inequality constraints with upper and lower bound */
  int nnzDGGieqLowUp;

 /* Number of variables for QP */
  int nQP;

 /* Stage that is currently being processed in the main 'Worhp' function. Used for proper output in StageMsg. */
  int ProcessedStage;

 /* Number of constraint relaxation variables */
  int RelaxNvar;

 /* Maximum Number of Filter Entries */
  int nFilterEntries;

 /* mja: Number of positive eigenvalues of KKT-matrix in last factorization. */
  int KKTInertiaPosEV;

 /* mjaP: Number of negative eigenvalues of KKT-matrix in last factorization. */
  int KKTInertiaNegEV;

 /* mja: Number of zero eigenvalues of KKT-matrix in last factorization. */
  int KKTInertiaZeroEV;

 /* sge: Minor iteration count of last major iteration. */
  int SaveOldMinorIterCount;

 /* sge: Currently active switch mode. */
  int SwitchModeActiveKind;

 /* mja: Iteration in which sKKT were met for functionality of parameter sKKTOnlyAcceptable */
  int TerminationMetSKKTiter;

 /* iteration at which last crossover has been applied. */
  int CrossoverIter;

 /* ssu: Saves current AresFlag for output after linesearch */
  int AresInLinesearch;

 /*------------------------------------------------
  *  Logicals
  *------------------------------------------------ */

 /* Current point feasible to acceptable tol.? */
  bool AcceptFeasible;

 /* Current point optimal to acceptable tol.? */
  bool AcceptOptimal;

 /* Found an acceptable solution? */
  bool AcceptSolFound;

 /* mja: Indicates whether the best so far acceptable solution was chosen because F was found to be constant */
  bool AcceptTerminationByConstantF;

 /* Automatic QP Recovery Active? */
  bool AutoQPRecActive;

 /* Do Betts' update */
  bool BettsUpdate;

 /* Complementarity conditions satisfied? */
  bool Complementary;

 /* Problem has constraints on G  <=>  M > 0 */
  bool Constrained;

 /* sge - Flag to signalise BuildBoxConstraints it is called the first time */
  bool BstepFeasFirstTimeBuildBox;

 /* sge - Correction step declined due to merit function. No new DF DG required. */
  bool BstepFeasMeritFail;

 /* sge - Correction step due to perturbed constraints is active */
  bool BstepFeasActive;

 /* sge - Abort correction step due to bad contraction factor */
  bool BstepFeasAbortFactor;

 /* sge - Flag showing that correction via feasibility finished */
  bool BstepFeasFinished;

 /* sge - Correction step was successful */
  bool BstepSuccessful;

 /* sge - Correction step not yet initialised, but first call to armijo */
  bool BstepFirstArmijoCall;

 /* mja: Whether fidif derivatives have been evaluated for derivative check */
  bool CheckDerivFidifDone;

 /* mja: Whether user derivatives have been evaluated for derivative check */
  bool CheckDerivUserDone;

 /* DGslc has been constructed */
  bool DGslcDone;

 /* ssu: used to correctly display functions used in Linesearch */
  bool DidLinesearchEvalF;

 /* ssu: used to correctly display functions used in Linesearch */
  bool DidLinesearchEvalG;

 /* ssu: Was the last Find Stepsize with SRS? */
  bool DidLinesearchStartAres;

 /* Current point feasible? */
  bool Feasible;

 /* Feasible Dual shall be used */
  bool FeasibleDual;

 /* FeasibleInit shall be used */
  bool FeasibleInit;

 /* FeasibleInit has failed */
  bool FeasibleInitFailed;

 /* FeasibleInit mode has been completed */
  bool FeasibleInitDone;

 /* Focus on feasibility? */
  bool FeasibleStep;

 /* mja: Whether the first evaluation has been done already to help with RC */
  bool fidif_first_evald;

 /* mja: Whether f has been evaluated when using fidif for DF and DG */
  bool fidif_f_evald;

 /* mja: Whether g has been evaluated when using fidif for DF and DG */
  bool fidif_g_evald;

 /* Hessian guaranteed as positive definite */
  bool HMposdef;

 /* HMslc has been constructed */
  bool HMslcDone;

 /* Do estimation for LM? */
  bool InitialLMEst;

 /* ssu: Saves whether the first Solve_QP call was for initial multiplier estimation. This prevents unnecessary function evaluations */
  bool WasInitialLMEst;

 /* sge: Updating the lagrange multipliers requires several informations from the QP. Do not erase those. */
  bool KeepQPVectorsForBstep;

 /* KKT conditions satisfied? */
  bool KKTok;

 /* Whether a major iteration was just finished. Used to update counter of MajorIter correctly. */
  bool MajorIterFinished;

 /* mja: To remember the old par%UserDF value that might be changed for checking the user derivatives */
  bool oldUserDF;

 /* mja: To remember the old par%UserDG value that might be changed for checking the user derivatives */
  bool oldUserDG;

 /* mja: To remember the old par%UserHM value that might be changed for checking the user derivatives */
  bool oldUserHM;

 /* Current point optimal? */
  bool Optimal;

 /* sgef: Post QP Sensitivity analysis used and qpdx altered? */
  bool PostQPSensActive;

 /* Intermediate QP solution used? */
  bool QPNotFinished;

 /* Do constraint relaxation in QP?      [LIQP] */
  bool RelaxCon;

 /* sge: Flag to mark change of adaptive relaxation set */
  bool adaptiveRelaxationChanged;

 /* sge: Extraction of regularisation strategy functions required to move a GOTO flag. This boolean is used to perform this move. */
  bool regStrategyGotoFlag;

 /* sge: Save fidif HM for switch mode. Thus, activate fidif after BFGS/identity instead of userhm */
  bool saveFidifHM;

 /* scaled QP */
  bool scaledQP;

 /* weakactiveset is allowed to set constraint to inactive */
  bool setInactive;

 /* sge: flag to signalise, that some kind of switch mode is active */
  bool switchModeActive;

 /* sge: flag to signalise, that the switch mode has finished */
  bool switchModeFinished;

 /* MinimumStepsize hit during TakeQPSol */
  bool TakeQPSolError;

 /* mja: Indicates if the current acceptable or optimal solution was chosen because F was found to be constant */
  bool TerminationByConstantF;

 /* Use identity matrix in QP? */
  bool UseId;

 /* Indicates if the last iteration was in Feasible Mode */
  bool WasFeasMode;

 /* Current point acceptable to filter? */
  bool Acceptable;

 /* AresForce applicable? (don't do it when no search direction is calculated yet) */
  bool AresForce;

 /* Augment filter after accelerating heuristic (ignore criteria)? */
  bool AugmentFilter;

 /* Check full stepsize (accelerating heuristic: ignore criteria)? */
  bool CheckFullStepsize;

 /* Feasibility restoration invoked? */
  bool FeasRest;

 /* Is it the first Hessian regularization? */
  bool FirstHessianReg;

 /* Accept full stepsize in next iteration? */
  bool FullStepsize;

 /* Step size is an f-step-size? */
  bool FStepsize;

 /* PostQP-Sensitivity, alternative qpdx was used and failed */
  bool qppsa_qpdx_failed;

 /* PostQP-Sensitivity, qpdx w.r.t. regularisation available */
  bool qppsa_qpdx_reg_available;

 /* PostQP-Sensitivity, regularisation update available */
  bool qppsa_HMReg_available;

 /* PostQP-Sensitivity, qpdx w.r.t. relaxation available */
  bool qppsa_qpdx_relax_available;

 /* PostQP-Sensitivity, relaxation penalty update available */
  bool qppsa_relaxpen_available;

 /* PostQP-Sensitivity, relaxation penalty sensitivity not negative */
  bool qppsa_relaxpen_failed;

 /* PostQP-Sensitivity, hessian regularisation value newton method failed */
  bool qppsa_HMreg_failed;

 /* Last unsuccessful trial stepsize rejected because of the filter? */
  bool RejectedByFilter;

 /* Is it the second Hessian regularization? */
  bool SecondHessianReg;

 /* SLP step? */
  bool SLPstep;

 /* Accelerating heuristic (ignore criteria) unsuccessful? */
  bool SmallerAlpha;

 /* Switching condition satisfied? */
  bool SwitchingCond;

 /* sge: Use sensitivities with respect to regularisation in post qp psa */
  bool UseRegSens;

 /* sge: Use sensitivities with respect to relaxation in post qp psa */
  bool UseRelaxSens;

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker04;

 /* Automatically added initialisation flag.  */
  bool initialised;
} Workspace;

typedef struct ParamsStruct {

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker05;

 /* Switch between SQP and IP */
  int Algorithm;

 /* Feasibility tolerance */
  double TolFeas;

 /* Optimality tolerance */
  double TolOpti;

 /* Complementarity tolerance */
  double TolComp;

 /* Tolerance for acceptable feasibility */
  double AcceptTolFeas;

 /* Tolerance for acceptable optimality */
  double AcceptTolOpti;

 /* Save acceptable solutions as fallback */
  bool KeepAcceptableSol;

 /* Enable lowpass-filter termination criterion */
  bool LowPassFilter;

 /* Enable too-big termination heuristics */
  bool TooBig;

 /* Upper bound to Reverse Communication calls */
  int MaxCalls;

 /* Upper bound on major iterations */
  int MaxIter;

 /* Timeout in seconds */
  double Timeout;

 /* Tolerance for unboundedness detection heuristic */
  double InftyUnbounded;

 /* Lowpass-filter update factor for objective values */
  double LowPassAlphaF;

 /* Lowpass-filter update factor for constraint values */
  double LowPassAlphaG;

 /* Upper bound on constraint violation for too-big heuristic */
  double TooBigCV;

 /* Upper bound on KKT values for too-big heuristic */
  double TooBigKKT;

 /* Switch to SQP algorithm after IP solve */
  int Crossover;

 /* Iteration at which a crossover is forced */
  int CrossoverIter;

 /* Relaxation factor of original tolerances to be satisfied for crossover */
  double CrossoverTol;

 /* If WORHP monitor is available show window. */
  bool ShowMonitor;

 /* Enable information about which entries of X changed */
  bool DetailedNewX;

 /* Enable XML logfiles and writing interval */
  int LogLevel;

 /* Enable XML result logging and detail level */
  int LogResult;

 /* NLP print level [-1..4] */
  int NLPprint;

 /* Objective gradient values supplied by caller */
  bool UserDF;

 /* Jacobian values supplied by caller */
  bool UserDG;

 /* Hessian values supplied by caller */
  bool UserHM;

 /* F and G cannot be evaluated separately */
  bool FGtogether;

 /* Enable automatic Hessian structure generation or checking */
  int UserHMstructure;

 /* Approximate Hessian by finite differences (otherwise BFGS) */
  bool FidifHM;

 /* mja: Whether to use group methods for finite differences */
  bool FidifGroups;

 /* Use a scaled perturbation for finite differences */
  bool ScaledFD;

 /* Enable check of group composition for derivatives */
  bool CheckGroups;

 /* Use central finite difference quotient for first derivatives */
  bool FirstDifCentral;

 /* mja: Use central finite difference quotient for second derivatives */
  bool SecondDifCentral;

 /* Select method to determine graph colouring groups */
  int GroupMethod;

 /* (experimental) */
  int MaxGPart;

 /* Select method to determine graph colouring pairgroups */
  int PairMethod;

 /* Finite difference perturbation */
  double FidifEps;

 /* Enable structural checking of DF */
  bool CheckStructureDF;

 /* Enable structural checking of DG */
  bool CheckStructureDG;

 /* Enable structural checking of HM */
  bool CheckStructureHM;

 /* mja: Enable comparison of DF values provided by the user with fidif ones */
  bool CheckValuesDF;

 /* mja: Enable comparison of DG values provided by the user with fidif ones */
  bool CheckValuesDG;

 /* mja: Enable comparison of HM values provided by the user with fidif ones */
  bool CheckValuesHM;

 /* The number of the iteration in which user derivatives shall be checked */
  int CheckDerivIter;

 /* How much the user derivative can differ absolutely from fidif without being considered wrong */
  double CheckDerivTolAbs;

 /* How much the user derivative can differ relatively from fidif without being considered wrong */
  double CheckDerivTolRel;

 /* Choose BFGS method (0: dense, 1-3: block, 100+: sparse) */
  int BFGSmethod;

 /* Block size parameter used by certain BFGS methods */
  int BFGSmaxblockSize;

 /* Block size parameter used by certain BFGS methods */
  int BFGSminblockSize;

 /* Restart BFGS update after this many iterations */
  int BFGSrestart;

 /* BFGS Curvature condition bound */
  double CurvCond;

 /* BFGS curvature condition regularisation factor */
  double CurvFac;

 /* Block BFGS curvature condition bound */
  double CurvBCond;

 /* Block BFGS curvature condition regularisation factor */
  double CurvBFac;

 /* sge: Switch mode during globalisation, 0 - none, 1 - Hessian BFGS -> User, 2 - Hessian Identity -> User */
  int SwitchMode;

 /* sge: Threshold of minor iteration to determine globalisation phase and stop switch mode */
  int SwitchModeMaxMinor;

 /* sge: Switch mode termination criterion based on major iteration count. Upper bound on major iteration count */
  int SwitchModeMaxIter;

 /* sge: Switch mode termination criterion, 0 - tolerance based, 1 - minor iteration count of last iterations, 2 - major iteration count */
  int SwitchModeTermination;

 /* sge: Tolerances during switch mode, 0 - normal, 1 - reduced QP and LEQ tolerances, see Switch */
  int SwitchModeTolerances;

 /* sge: Reduced IpComTol for tolerance reduction mode */
  double SwitchModeIpComTol;

 /* sge: Reduced IpResTol for tolerance reduction mode */
  double SwitchModeIpResTol;

 /* sge: Reduced LsTol for tolerance reduction mode */
  double SwitchModeLsTol;

 /* sge: Tolerance to be checked to decide upon termination of globalisation phase */
  double SwitchModeTermTol;

 /* Enable Fritz-John and non-differentiable check heuristics */
  bool FJandND;

 /* mja: If scaled KKT are met, the solution will only be considered acceptable and iteration will continue to try and satisfy normal KKT */
  bool sKKTOnlyAcceptable;

 /* Scale KKT conditions */
  bool ScaledKKT;

 /* Factor in determining active constraints by KKT */
  double BoundTolFac;

 /* Upper bound used by Fritz-John heuristic */
  double CheckFJ;

 /* Lowpass-filter update factor for merit function values */
  double LowPassAlphaMerit;

 /* Enable automatic QP recovery */
  bool AutoQPRecovery;

 /* Update factor for Betts' Hessian regularisation */
  double BettsFactor;

 /* Smallest eigenvalue of the regularised Hessian */
  double BettsPoint;

 /* Increase factor for Betts' update dampening term */
  double IncBettsTau;

 /* Larger increase factor for Betts' update dampening term */
  double IncBettsTauMore;

 /* Initial value for Betts' update dampening term */
  double StartBettsTau;

 /* Select (1) Meritfunction or (3) Filter globalisation */
  int LineSearchMethod;

 /* Control Lagrange multiplier update */
  bool LinMult;

 /* Trial stepsize decrease factor for Armijo rule */
  double ArmijoBeta;

 /* Trial stepsize decrease factor for Armijo rule when in a recovery strategy */
  double ArmijoBetaAres;

 /* Initial alpha for Armijo rule */
  double ArmijoMaxAlpha;

 /* Lower bound on alpha for Armijo rule */
  double ArmijoMinAlpha;

 /* Lower bound on alpha for Armijo rule during recovery */
  double ArmijoMinAlphaRec;

 /* Scale factor for linearised descent check in Armijo rule */
  double ArmijoSigma;

 /* Use a constant lower bound on Armijo stepsize in Filter */
  bool AlphaMinConst;

 /* Filter heuristic to save Armijo iterations */
  bool FilterBisecAlpha;

 /* Filter heuristic to save Armijo iterations */
  bool FilterIntersecAlpha;

 /* Activate accelerating heuristics for Filter */
  bool IgnoreFilterCrit;

 /* Enables Filter-reinitialisation accelerating heuristic */
  bool ReinitFilter;

 /* Select max-norm instead of 1-norm in Filter */
  bool MaxNorm;

 /* Whether to use the feasibility restoration before using any other recovery strategy when the filter is used and the minimum stepsize is reached */
  bool FilterRestFeas;

 /* Do restoration until a feasible solution is found */
  bool RestUntilFeas;

 /* Control activation of Filter acceleration heuristics */
  int MaxLScounter;

 /* Select Hessian regularisation strategy in Filter */
  int RegStrategy;

 /* Constraint violation decrease factor in Filter acceptance check */
  double FilterGammaCV;

 /* Objective decrease factor in Filter acceptance check */
  double FilterGammaF;

 /* Safety factor for alphamin calculation by Filter */
  double GammaAlpha;

 /* Lower bound for Betts' update dampening term */
  double MinBettsTau;

 /* Decrease factor for Betts' update dampening term */
  double ReduceBettsTau;

 /* Filter switching condition parameter */
  double SwitchingDelta;

 /* Filter switching condition parameter */
  double SwitchingSF;

 /* Filter switching condition parameter */
  double SwitchingSCV;

 /* Evaluate QP search direction regardless of convergence */
  bool TakeQPSol;

 /* Select merit function and penalty update [0, 3..5] */
  int MeritFunction;

 /* Penalty update parameter */
  int PenUpdEpsKSequence;

 /* Penalty update parameter factor for MeritFunction = 3 */
  double PenUpdEpsBar;

 /* Penalty update parameter factor for MeritFunction = 4 */
  double PenUpdEpsKFac;

 /* Max penalty for MeritFunction = 4 */
  double PenUpdMaxDeltaK;

 /* Max factor for increasing penalty for MeritFunction = 4 */
  double PenUpdMaxFac;

 /* Penalty update parameter for MeritFunction = 3 */
  double PenUpdRBar;

 /* Threshold of meritfunction gradient for increasing Hessian regularisation */
  double MeritGradTol;

 /* Activates new iterative refinement of constraints only when Armijo alpha equals one */
  bool RefineOnlyOnAlpha;

 /* Use MeritGradient as starting criterion. */
  bool RefineFeasMerit;

 /* Use Steffensen Extrapolation during Feasibility Refinement */
  bool SteffensenOnRefine;

 /* Activates update of lagrangian multipliers during feasibility refinement */
  bool UpdateMu;

 /* sge: Maximum number of feasibility refinement iterations */
  int RefineFeasMaxIter;

 /* 0 - Deactivated, 1 - After first feasible iterate, 2 - Always on, Activates iterative refinement due to perturbation in constraints using parametric sensitivities, 3 - Always on, but correction depending of Active Set of QP */
  int RefineFeasibility;

 /* Termination criteria for Feasibility refinement 0 - just constraints, 1 - constraints and factor, 2 - Lagrangian as watch dog, 3 - Lagrangian and factor */
  int RefineFeasTermination;

 /* Limit for contraction factor to determine slow progress during feasibility refinement */
  double RefineContrLimitc;

 /* Limit for constraint violation in comparison to contraction factor etaq during feasibility refinement */
  double RefineContrLimitq;

 /* Start tolerance for successful termination of iterative refinement due to perturbation in constraints */
  double RefineStartTol;

 /* Maximum allowed relaxation to apply feasibility refinement */
  double RefineMaxRelax;

 /* Maximum allowed regularisation of the hessian CAUTION absolute value */
  double RefineMaxHMReg;

 /* sge: 0 - Turn off, 1 - Activate sensitivity based update of regularisation value using the curvature condition, 2 - Activate sensitivity based on objective deviation, 3 - activate 1 and use 2 as fallback */
  int PostQPSensRegVal;

 /* sge: Activate sensitivity based update of relaxation penalty due to PostQPSensRelaxFrac */
  bool PostQPSensRelaxPen;

 /* sge: 0 - Deactivated, 1 - Use constraint relaxation sensitivity, 2 - Use Hessian regularisation sensitivity, 3 - Use both. */
  int PostQPSensitivity;

 /* sge: Goal fraction for the sensitivity based reduction of relaxDelta */
  double PostQPSensRelaxFrac;

 /* sge: Fraction between sensitivity based Hessian regularisation and old value */
  double PostQPSensRegValFrac;

 /* sge: Allowed deviation for subproblem objective value under regularisation change */
  double PostQPSensRegValObjDev;

 /* enables constraint relaxation */
  bool RelaxCon;

 /* mja: Disable relaxation for constant and linear constraints */
  bool RelaxOnlyNonlinear;

 /* sge: Activate adaptive relaxation of constraints */
  bool AdaptiveConstrRelax;

 /* Introduce one relaxation variable for every constraint */
  bool MoreRelax;

 /* Only one relaxation penalty if MoreRelax is true */
  bool RelaxPenOnlyOne;

 /* Upper bound for accepting the constraint relaxation variable */
  double RelaxMaxDelta;

 /* Upper bound on the constraint relaxation penalty */
  double RelaxMaxPen;

 /* Update factor for the constraint relaxation penalty */
  double RelaxRho;

 /* Initial value of the constraint relaxation penalty */
  double RelaxStart;

 /* Scale constraints in every iteration */
  bool ScaleConIter;

 /* Scale the objective function */
  bool ScaledObj;

 /* Scale some matrices handed to the QP */
  bool ScaledQP;

 /* Value to scale large objective functions to */
  double ScaleFacObj;

 /* Upper bound on resulting matrix norm for QP scaling */
  double ScaleFacQP;

 /* Enable initial Lagrange multiplier estimate */
  bool InitialLMest;

 /* IP complementarity tolerance in initial multiplier estimate */
  double LMestQPipComTol;

 /* IP residual tolerance in initial multiplier estimate */
  double LMestQPipResTol;

 /* Activate dual feasibility mode */
  bool FeasibleDual;

 /* Activate initial feasibility mode */
  bool FeasibleInit;

 /* Activate feasible-only mode */
  bool FeasibleOnly;

 /* Enable Focus-on-Feasibility mode */
  bool FocusOnFeas;

 /* Feasibility tolerance for no-objective feasible mode */
  double FeasibleInitTol;

 /* Factor in Focus-on-Feasibility mode */
  double FocusOnFeasFactor;

 /* Maximum number of Force recovery strategy steps */
  int MaxForce;

 /* Armijo recovery strategies */
  int Ares[NAres];

 /* WORHP IP: Enable the relaxation of bounds at the beginning */
  bool IP_NlpRelaxBounds;

 /* WORHP IP: Enable the relaxation of bounds during optimization */
  bool IP_NlpRelaxBoundsIter;

 /* WORHP IP: Enable the projection back into the original bounds */
  bool IP_NlpStressBounds;

 /* WORHP IP: Lower objective bound */
  double IP_NlpObjLow;

 /* WORHP IP: Upper objective bound */
  double IP_NlpObjUp;

 /* Worhp IP: barrier function */
  int IP_BarrierType;

 /* Worhp IP: strategy for updating barrier parameter */
  int IP_BarrierUpdate;

 /* WORHP IP: strategy for updating augmented duals of barrier function */
  int IP_BarrierUpdateAug;

 /* WORHP IP: max iter without update to switch to fast update */
  int IP_BarrierIterFast;

 /* WORHP IP: initial value of barrier parameter */
  double IP_BarrierInit;

 /* WORHP IP: initialization of augmented Langrangian multipliers of box constraints */
  int IP_BarrierInitAug;

 /* WORHP IP: tolerance for barrier parameter */
  double IP_BarrierTol;

 /* WORHP IP: linear decrease factor for barrier. */
  double IP_BarrierLinDecr;

 /* WORHP IP: superlinear decrease power for barrier. */
  double IP_BarrierSupDecr;

 /* WORHP IP: fast linear decrease factor for barrier. */
  double IP_BarrierLinDecrFast;

 /* WORHP IP: fast superlinear decrease power for barrier. */
  double IP_BarrierSupDecrFast;

 /* WORHP IP: linear damping factor for log-lin barrier function. */
  double IP_BarrierLinDamp;

 /* WORHP IP: update strategy for the barrier shift */
  int IP_BarrierShiftUpdate;

 /* WORHP IP: initial value of barrier based shift */
  double IP_BarrierShiftInit;

 /* WORHP IP: balance of barrier shift update between former shift and max possible shift */
  double IP_BarrierShiftBalance;

 /* WORHP IP: exponent in barrier shift update */
  double IP_BarrierShiftUpdateExp;

 /* WORHP IP: max iterations in classic IP algorithm before switch to PIPA. (-1 is infinity, 0 means disabled) */
  int IP_PenaltyZeroIter;

 /* WORHP IP: penalty function (l1, l2, augmented Lagrangian) */
  int IP_PenaltyType;

 /* WORHP IP: update strategy for penalty parameter */
  int IP_PenaltyUpdate;

 /* WORHP IP: selects the position of the penalty parameter (obj or con). */
  int IP_PenaltyPosition;

 /* WORHP IP: max value of penalty parameter in front of constraint violation after which the penalty obj will be updated */
  double IP_PenaltySwitch;

 /* WORHP IP: initial value of penalty parameter */
  double IP_PenaltyInit;

 /* WORHP IP: initialization of augmented Langrangian multipliers of nonlinear constraints */
  int IP_PenaltyInitAug;

 /* WORHP IP: tolerance for the penalty problem. */
  double IP_PenaltyTol;

 /* WORHP IP: dual factor for termination criteria */
  double IP_PenaltyTolDual;

 /* WORHP IP: linear increase factor for penalty. */
  double IP_PenaltyLinIncr;

 /* WORHP IP: linear decrease factor for penalty. */
  double IP_PenaltyLinDecr;

 /* WORHP IP: value to be considered as divergence of PenaltyObj */
  double IP_PenaltyMin;

 /* WORHP IP: value to be considered as divergence of PenaltyFeas */
  double IP_PenaltyMax;

 /* WORHP IP: number of adaptive penalty updates to consider */
  int IP_PenaltyAdaptNum;

 /* WORHP IP: Improvement factor for the feasibility condition of the adaptive updates. */
  double IP_PenaltyAdaptImprFeas;

 /* WORHP IP: Improvement factor for the quadratic model condition of the adaptive updates. */
  double IP_PenaltyAdaptImprQuad;

 /* WORHP IP: Tolerance for complementarity measure of adaptive augmented duals update */
  double IP_PenaltyAdaptAugTol;

 /* WORHP IP: Allows the reduction of the penalty parameter */
  bool IP_PenaltyAllowReduce;

 /* WORHP IP: chooses the method for checking for global convergence */
  int IP_AdaptCheckMethod;

 /* WORHP IP: nonmonotonicity of the filter for adaptive updates */
  int IP_AdaptFilterNonmon;

 /* WORHP IP: method for init dual variables */
  int IP_InitMethodDual;

 /* WORHP IP: method for init dual box variables */
  int IP_InitMethodDualBox;

 /* WORHP IP: enables multiplier estimation */
  bool IP_InitDualEstimation;

 /* WORHP IP: enables the dual adjustment */
  bool IP_InitDualAdjustment;

 /* WORHP IP: number of centering steps */
  int IP_InitCenteringSteps;

 /* WORHP IP: initial value of multipliers */
  double IP_InitDual;

 /* WORHP IP: initial value of box multipliers */
  double IP_InitDualBox;

 /* WORHP IP: min absolute distance to box bound of X */
  double IP_InitBoundDistAbs;

 /* WORHP IP: min relative distance to box bound of X */
  double IP_InitBoundDistRel;

 /* WORHP IP: min absolute distance to box bound of S */
  double IP_InitBoundDistSAbs;

 /* WORHP IP: min relative distance to box bound of S */
  double IP_InitBoundDistSRel;

 /* WORHP IP: min absolute distance to zero of duals */
  double IP_InitBoundDistDual;

 /* WORHP IP: Stores an intermediate iterate for warmstart */
  bool IP_WarmStore;

 /* WORHP IP: Real-time update after warmstart using sensitivity analysis */
  bool IP_WarmSensUpdate;

 /* WORHP IP: method for init dual variables after warmstart */
  int IP_WarmMethodDual;

 /* WORHP IP: method for init dual box variables after warmstart */
  int IP_WarmMethodDualBox;

 /* WORHP IP: enables multiplier estimation */
  bool IP_WarmDualEstimation;

 /* WORHP IP: enables the dual adjustment */
  bool IP_WarmDualAdjustment;

 /* WORHP IP: number of centering steps */
  int IP_WarmCenteringSteps;

 /* WORHP IP: initial value of multipliers after warmstart */
  double IP_WarmDual;

 /* WORHP IP: initial value of box multipliers after warmstart */
  double IP_WarmDualBox;

 /* WORHP IP: min absolute distance to box bound of X after warmstart */
  double IP_WarmBoundDistAbs;

 /* WORHP IP: min relative distance to box bound of X after warmstart */
  double IP_WarmBoundDistRel;

 /* WORHP IP: min absolute distance to box bound of S after warmstart */
  double IP_WarmBoundDistSAbs;

 /* WORHP IP: min absolute relative to box bound of S after warmstart */
  double IP_WarmBoundDistSRel;

 /* WORHP IP: min absolute distance to zero of duals after warmstart */
  double IP_WarmBoundDistDual;

 /* WORHP IP: enables the check of correct inertia */
  bool IP_RegCheckInertia;

 /* WORHP IP: Method for dual regularization */
  int IP_RegMethodDual;

 /* WORHP IP: if regularization fails, use identity matrix */
  bool IP_RegFailUseIdentity;

 /* WORHP IP: guaranteed min value of descent */
  double IP_RegMinDescent;

 /* WORHP IP: start value for regularization */
  double IP_RegHessStart;

 /* WORHP IP: fraction of old value for regularization */
  double IP_RegHessOldFrac;

 /* WORHP IP: fast increase of value for regularization */
  double IP_RegHessIncrFast;

 /* WORHP IP: normal increase of value for regularization */
  double IP_RegHessIncrStd;

 /* WORHP IP: max value for hessian regularization before considered as failure */
  double IP_RegHessMax;

 /* WORHP IP: jacobian regularization term */
  double IP_RegJac;

 /* WORHP IP: enables further quality improvements for linear system solves */
  bool IP_LeqIncQuality;

 /* WORHP IP: block elimination technique for the linear equation systemm */
  int IP_LeqReduce;

 /* WORHP IP: max iterations for reduced iterative refinement */
  int IP_LeqItRefRedMaxIter;

 /* WORHP IP: min iterations for iterative refinement */
  int IP_LeqItRefMinIter;

 /* WORHP IP: max iterations for iterative refinement */
  int IP_LeqItRefMaxIter;

 /* WORHP IP: maximum iterations for iterative refinement */
  double IP_LeqItRefTol;

 /* WORHP IP: improvement factor for iterative refinement */
  double IP_LeqItRefImprFac;

 /* WORHP IP: if enabled the newton system will be checked by finite differences */
  bool IP_LeqCheck;

 /* WORHP IP: absolute tolerance for newton system check using finite differences */
  double IP_LeqCheckTolAbs;

 /* WORHP IP: absolute tolerance for newton system check using finite differences */
  double IP_LeqCheckTolRel;

 /* WORHP IP: automatic selection of MA97 parameters */
  bool IP_LeqMa97Auto;

 /* WORHP IP: chooses refinement step */
  int IP_RefineStep;

 /* WORHP IP: max iterations of refinement step */
  int IP_RefineStepMaxIter;

 /* WORHP IP: line search method (filter, merit function) */
  int IP_LineMethod;

 /* WORHP IP: line search backup method (filter, merit function) */
  int IP_LineMethodBackup;

 /* WORHP IP: number of non monotone level of merit approach */
  int IP_LineMeritNonmon;

 /* WORHP IP: number of non monotone level of filter approach */
  int IP_LineFilterNonmon;

 /* WORHP IP: type of filter envelope */
  int IP_LineFilterEnvelope;

 /* WORHP IP: objective decrease factor in filter */
  double IP_LineFilterGammaObj;

 /* WORHP IP: constraint violation decrease factor in filter */
  double IP_LineFilterGammaFeas;

 /* WORHP IP: update factor for step size */
  double IP_LineArmijoBeta;

 /* WORHP IP: reduction factor for armijo condition. */
  double IP_LineArmijoEta;

 /* WORHP IP: max step size */
  double IP_LineAlphaMax;

 /* WORHP IP: max step size */
  double IP_LineAlphaMin;

 /* WORHP IP: penalty for feasibility of penalty subproblem */
  double IP_LinePenaltyFeasPen;

 /* WORHP IP: penalty for complementarity of barrier subproblem */
  double IP_LinePenaltyComplBarr;

 /* WORHP IP: enables interpolation for step size update */
  bool IP_LineInterp;

 /* WORHP IP: min decrease in relation to old step size */
  double IP_LineInterpMin;

 /* WORHP IP: max decrease in relation to old step size */
  double IP_LineInterpMax;

 /* WORHP IP: Enable slack reset after update. */
  bool IP_LineSlackReset;

 /* WORHP IP: minimal fraction to the boundary */
  double IP_LineFracToBound;

 /* WORHP IP: fraction to the boundary threshold */
  double IP_LineFracToBoundThres;

 /* WORHP IP: huge parameter defining the trust region of lambda */
  double IP_LineTrustDual;

 /* WORHP IP: max iter of second-order correction */
  int IP_LineCorMaxIter;

 /* WORHP IP: enable check of kkt conditions of feasibility problem */
  int IP_CheckInfeas;

 /* WORHP IP: enable check of kkt conditions for fritz john point */
  int IP_CheckFritzJohn;

 /* WORHP IP: Enable check for NaN / Inf in function evaluations. */
  int IP_CheckNanInf;

 /* WORHP IP: max value of primal iterates */
  double IP_CheckMaxPrimal;

 /* WORHP IP: max value of dual iterates */
  double IP_CheckMaxDual;

 /* WORHP IP: Enable lowpass filter on barrier level */
  bool IP_CheckLowPassBarr;

 /* WORHP IP: Enable lowpass filter on penalty level */
  bool IP_CheckLowPassPen;

 /* WORHP IP: relative tolerance for lowpass filter */
  double IP_CheckLowPassTol;

 /* WORHP IP: enables optimization after modified problem has been solved */
  bool IP_CheckOrigCont;

 /* WORHP IP: enables unscaling after modified problem has been solved */
  bool IP_CheckOrigContUnscale;

 /* WORHP IP: enables to continue for n iterations after modified problem has been solved */
  int IP_CheckOrigContMaxIter;

 /* WORHP IP: Enable scaling of objective function. */
  bool IP_ScaleF;

 /* WORHP IP: Enable scaling of constraints. */
  bool IP_ScaleG;

 /* WORHP IP: max gradient after automatic scaling */
  double IP_ScaleMaxGrad;

 /* WORHP IP: min scaling factor of automatic scaling */
  double IP_ScaleMin;

 /* Run Zen module after successful termination */
  bool UseZen;

 /* Hessian values supplied by caller */
  bool UserZenDGp;

 /* Hessian values supplied by caller */
  bool UserZenDLxp;

 /* Gradient values supplied by caller */
  bool UserZenDLp;

 /* Hessian values supplied by caller */
  bool UserZenDLpp;

 /* Check maximum of secure perturbation when updating solution */
  bool ZenCheckMaxPert;

 /* false: use LU from last QP step; true: renew LU decomposition. */
  bool ZenRenewLU;

 /* selects different storage options for sensitivities */
  int ZenStore;

 /* Use BLAS level 3 (dgemm) in MA97 */
  bool MA97blas3;

 /* Use multifrontal-style forward solve of MA97 */
  bool MA97mf;

 /* Ordering used by MA97 */
  int MA97ordering;

 /* Scaling used by MA97 */
  int MA97scaling;

 /* Print level used by MA97 */
  int MA97print;

 /* Node amalgation, controls merging in elimination tree by MA97 */
  int MA97nemin;

 /* Min number of expected flops before parallel execution is used in factorization */
  int MA97factorMin;

 /* Any pivot whose modulus is less than this is treated as zero by MA97 */
  double MA97small;

 /* Relative pivot tolerance of MA97 */
  double MA97u;

 /* Max pivot tolerance of MA97 */
  double MA97umax;

 /* Upper bound for numbers to be regarded as finite */
  double Infty;

 /* Increase factor for estimated integer workspace requirement */
  double IncreaseIWS;

 /* Increase factor for estimated real workspace requirement */
  double IncreaseRWS;

 /* Counter for changed parameters. Internal use only. */
  int internalParChanged;

 /* Not to be included into a parameter file! */
  bool MatrixCC;

 /* (currently unused) Scaling factor for QP */
  double QPscaleParam;

 /* (currently unused) Relative precision of objective */
  double PrecisionF;

 /* (currently unused) Relative precision of constraints */
  double PrecisionG;

 /* (experimental) */
  double TolWeakActive;

 /* (experimental) */
  bool WeakActiveSet;

 /* Pointer to QP parameter structure */
  QPParams qp;

 /* Can be pointed at a string which will be used as the license file content instead of opening the worhp.lic file. */
  const char* licenseFileContent;

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker06;

 /* Automatically added initialisation flag.  */
  bool initialised;
} Params;

typedef struct ControlStruct {
  DateType Date;
  TimerType Timer;

 /* Ring buffer for stage history */
  int Stage[NStageHistory];

 /* Logical field for user action flags */
  bool UserAction[NUserAction];

 /* External status flag */
  int status;

 /* Internal status flag */
  int int_status;

 /* WORHP status cached by Zen */
  int pre_zen_status;
  int currentStage;

 /* Indicates if current optimization has been warmstarted. */
  bool Warmstarted;

 /* Counter for Zen loops with Reverse Communication */
  counter ZenRCcounter1;

 /* Counter for Zen loops with Reverse Communication */
  counter ZenRCcounter2;

 /* True if Zen has been initialised. */
  bool ZenInit;

 /* Automatically added initialisation flag.  */
  bool initialised;
} Control;

/* Defined in Worhp_Data.F90 via C-interop  */
DLL_PUBLIC bool GetUserAction(const Control *cnt, int action);
DLL_PUBLIC void DoneUserAction(Control *cnt, int done);
DLL_PUBLIC void AddUserAction(Control *cnt, int add);
DLL_PUBLIC void SetNextStage(Control*, int);
DLL_PUBLIC int  GetCurrentStage(Control*);
DLL_PUBLIC int  GetPreviousStage(Control*, int);

/* Defined in C_Worhp_Data.c  */
DLL_PUBLIC void WorhpVersion(int *major, int *minor, char patch[PATCH_STRING_LENGTH]);
DLL_PUBLIC int CheckWorhpVersion(int major, int minor, const char *patch);

#ifdef __cplusplus
}
#endif

#endif /* HEADER_C_WORHP_DATA_H_GUARD */


