/* -*- buffer-read-only: t -*- vi: set ro:
 *
 * DO NOT EDIT THIS FILE   (C_Worhp_Data.h)
 *
 * It has been AutoGen-ed
 * From the definitions    /drone/src/titan.math.uni-bremen.de/gogs/steinbeis/worhp/src/auto/def/worhp_data.def
 * and the template file   C_Worhp_Data.tpl */

#include <stdlib.h> /* For size_t */

#ifndef HEADER_C_WORHP_DATA_H_GUARD
#define HEADER_C_WORHP_DATA_H_GUARD 1

#ifdef __cplusplus
extern "C" {
#endif

#include "C_std.h"
#include "C_cs.h"
#include "C_timer.h"
#include "C_qp_data.h"
#include "C_filter_data.h"
#include "C_worhp_queue.h"

#define PATCH_STRING_LENGTH 8

extern const int worhp_major;
extern const int worhp_minor;
extern const char worhp_patch[PATCH_STRING_LENGTH];

extern const int nMemberOptVar;
extern const int nMemberHideOptVar;
extern const int nMemberWorkspace;
extern const int nMemberHideWorkspace;
extern const int nMemberParams;
extern const int nMemberHideParams;
extern const int nMemberControl;
extern const int nMemberHideControl;

/* Used in conditional for allocating the opt->G members. */
extern const int minM;

enum {
 /* WORHP NLP: modification strategy original */
  WORHP_NLP_MODTYPE_ORIG = 0,
 /* WORHP NLP: modification strategy using slacks */
  WORHP_NLP_MODTYPE_SLACKS = 1,
 /* WORHP NLP: do not check for nan or inf */
  WORHP_NLP_CHECKNANINF_NONE = 0,
 /* WORHP NLP: stop with error message if nan or inf found */
  WORHP_NLP_CHECKNANINF_STOP = 1,
 /* WORHP NLP: replace nan or inf with something */
  WORHP_NLP_CHECKNANINF_REPLACE = 2,
 /*-----------------------------------------------------------------
  *  WORHP IP: modes
  *-----------------------------------------------------------------*/
 /* mode: none selected */
  WORHP_IP_MODE_NONE = 0,
 /* mode: classic interior-point method */
  WORHP_IP_MODE_PENNO = 1,
 /* mode: penalty-interior-point method with conservative updates */
  WORHP_IP_MODE_PENCONSERV = 2,
 /* mode: penalty-interior-point method with adaptive updates */
  WORHP_IP_MODE_PENADAPT = 3,
 /* mode: penalty-interior-point method normally with adaptive updates but currently with conservative updates */
  WORHP_IP_MODE_PENADAPTCONSERV = 4,
 /* mode: second order correction refinement. */
  WORHP_IP_MODE_REF = 5,
 /*-----------------------------------------------------------------
  *  WORHP IP: step types
  *-----------------------------------------------------------------*/
 /* WORHP IP: step undefined */
  WORHP_IP_STEP_UNDEF = 0,
 /* WORHP IP: step selection (step std) */
  WORHP_IP_STEP_STD = 1,
 /* WORHP IP: step selection (step augeq) */
  WORHP_IP_STEP_AUGEQ = 2,
 /* WORHP IP: step for feasibility problem */
  WORHP_IP_STEP_FEAS = 3,
 /* WORHP IP: step selection (second-order-correction) */
  WORHP_IP_STEP_CORRECT = 4,
 /* WORHP IP: step for adaptive update */
  WORHP_IP_STEP_ADAPT = 5,
 /*-----------------------------------------------------------------
  *  WORHP IP: parameter options
  *-----------------------------------------------------------------*/
 /* WORHP IP: Barrier type log function. */
  WORHP_IP_BARRIERTYPE_LOG = 1,
 /* WORHP IP: Barrier type log-lin function. */
  WORHP_IP_BARRIERTYPE_LOGLIN = 2,
 /* WORHP IP: Barrier type polyak's modified function. */
  WORHP_IP_BARRIERTYPE_LOGMOD = 3,
 /* WORHP IP: barrier update conservative */
  WORHP_IP_BARRIERUPDATE_CONSERV = 1,
 /* WORHP IP: barrier update loqo rule */
  WORHP_IP_BARRIERUPDATE_LOQO = 2,
 /* WORHP IP: Penalty type classic interior-point */
  WORHP_IP_PENALTYTYPE_NONE = 1,
 /* WORHP IP: Penalty type l2-penalty-interior-point */
  WORHP_IP_PENALTYTYPE_L2 = 2,
 /* WORHP IP: Penalty type augmented Lagrangian penalty-interior-point */
  WORHP_IP_PENALTYTYPE_AUGLAGR = 3,
 /* WORHP IP: penalty update conservative */
  WORHP_IP_PENALTYUPDATE_CONSERV = 1,
 /* WORHP IP: penalty update adaptive */
  WORHP_IP_PENALTYUPDATE_ADAPT = 2,
 /* WORHP IP: Penalty position in front of constraint violation */
  WORHP_IP_PENALTYPOSITION_FEAS = 1,
 /* WORHP IP: Penalty position in front of barrier objective */
  WORHP_IP_PENALTYPOSITION_OBJ = 2,
 /* WORHP IP: Penalty position in front of barrier objective and constraint violation */
  WORHP_IP_PENALTYPOSITION_BOTH = 3,
 /* WORHP IP: conservative update strategy for augmented duals */
  WORHP_IP_AUGUPDATE_CONSERV = 1,
 /* WORHP IP: adaptive update strategy for augmented duals */
  WORHP_IP_AUGUPDATE_ADAPT = 2,
 /* WORHP IP: merit function as check for adaptive updates */
  WORHP_IP_ADAPTCHECKMETHOD_MERIT = 1,
 /* WORHP IP: filter as check for adaptive updates */
  WORHP_IP_ADAPTCHECKMETHOD_FILTER = 2,
 /* WORHP IP: Envelope type based on feasibility */
  WORHP_IP_LINEFILTERENVELOPE_FEAS = 1,
 /* WORHP IP: Envelope type based on kkt conditions */
  WORHP_IP_LINEFILTERENVELOPE_KKT = 2,
 /* WORHP IP: do not check for nan or inf */
  WORHP_IP_CHECKNANINF_NONE = 0,
 /* WORHP IP: stop with error message if nan or inf found */
  WORHP_IP_CHECKNANINF_STOP = 1,
 /* WORHP IP: replace nan or inf with something */
  WORHP_IP_CHECKNANINF_REPLACE = 2,
 /* WORHP IP: no leq block elimination */
  WORHP_IP_LEQREDUCE_NONE = 1,
 /* WORHP IP: dual leq block elimination */
  WORHP_IP_LEQREDUCE_DUAL = 2,
 /* WORHP IP: dual and slack leq block elimination */
  WORHP_IP_LEQREDUCE_DUAL_SLACK = 3,
 /* WORHP IP: init method for box duals (user) */
  WORHP_IP_INITMETHODDUALBOX_USER = 1,
 /* WORHP IP: init method for box duals (fixed value) */
  WORHP_IP_INITMETHODDUALBOX_FIXED = 2,
 /* WORHP IP: init method for box duals (min complementarity) */
  WORHP_IP_INITMETHODDUALBOX_COMPL = 3,
 /* WORHP IP: init method for duals (user) */
  WORHP_IP_INITMETHODDUAL_USER = 1,
 /* WORHP IP: init method for duals (fixed) */
  WORHP_IP_INITMETHODDUAL_FIXED = 2,
 /* WORHP IP: init method for duals (dual box) */
  WORHP_IP_INITMETHODDUAL_DUALBOX = 3,
 /*-----------------------------------------------------------------
  *  WORHP IP: linear equation system
  *-----------------------------------------------------------------*/
 /* WORHP IP: standard linear equation system */
  WORHP_IP_LEQTYPE_STD = 1,
 /* WORHP IP: linear equation system for multiplier estimation */
  WORHP_IP_LEQTYPE_EST = 2,
 /* WORHP IP: solves the standard step */
  WORHP_IP_LEQSOLVEMODE_STD = 1,
 /* WORHP IP: solves the standard step (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_STDITREF = 2,
 /* WORHP IP: solves the step when updating augmented duals */
  WORHP_IP_LEQSOLVEMODE_AUGEQ = 3,
 /* WORHP IP: solves the step when updating augmented duals (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_AUGEQITREF = 4,
 /* WORHP IP: solves the step when penaltyobj = zero */
  WORHP_IP_LEQSOLVEMODE_FEAS = 5,
 /* WORHP IP: solves the step when penaltyobj = zero (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_FEASITREF = 6,
 /* WORHP IP: solves the step for WORHP Zen */
  WORHP_IP_LEQSOLVEMODE_SENS = 7,
 /* WORHP IP: solves the step for WORHP Zen (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_SENSITREF = 8,
 /* WORHP IP: solves the second-order-correction step */
  WORHP_IP_LEQSOLVEMODE_CORRECT = 9,
 /* WORHP IP: solves the second-order-correction step (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_CORRECTITREF = 10,
 /* WORHP IP: solves the multiplier estimation */
  WORHP_IP_LEQSOLVEMODE_EST = 11,
 /* WORHP IP: solves the multiplier estimation (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_ESTITREF = 12,
 /* WORHP IP: solves the centering step */
  WORHP_IP_LEQSOLVEMODE_CENTER = 13,
 /* WORHP IP: solves the centering step (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_CENTERITREF = 14,
 /* WORHP IP: solves the step for the sensitivity analysis after warmstart */
  WORHP_IP_LEQSOLVEMODE_SENSWARM = 15,
 /* WORHP IP: solves the step for the sensitivity analysis after warmstart (iterative refinement) */
  WORHP_IP_LEQSOLVEMODE_SENSWARMITREF = 16,
 /* WORHP IP: current right-hand-side is unknown */
  WORHP_IP_LEQCURRRHS_NONE = 0,
 /* WORHP IP: current right-hand-side is the one for StepStd */
  WORHP_IP_LEQCURRRHS_STEPSTD = 1,
 /* WORHP IP: current right-hand-side is the one for StepAugEq */
  WORHP_IP_LEQCURRRHS_STEPAUGEQ = 2,
 /* WORHP IP: current right-hand-side is the one for multiplier estimation */
  WORHP_IP_LEQCURRRHS_EST = 3,
 /* WORHP IP: current right-hand-side is the one for WORHP Zen, perturbation of type P */
  WORHP_IP_LEQCURRRHS_SENSP = 3,
 /* WORHP IP: current right-hand-side is the one for WORHP Zen, perturbation of type R */
  WORHP_IP_LEQCURRRHS_SENSR = 4,
 /* WORHP IP: current right-hand-side is the one for WORHP Zen, perturbation of type Q */
  WORHP_IP_LEQCURRRHS_SENSQ = 5,
 /* WORHP IP: current right-hand-side is the one for WORHP Zen, perturbation of type B */
  WORHP_IP_LEQCURRRHS_SENSB = 6,
 /*-----------------------------------------------------------------
  *  WORHP Line: methods
  *-----------------------------------------------------------------*/
 /* WORHP Line: method not specified */
  WORHP_LINE_METHOD_NONE = 0,
 /* WORHP Line: method full step, backtracking line search disabled */
  WORHP_LINE_METHOD_FULL = 1,
 /* WORHP Line: method filter. */
  WORHP_LINE_METHOD_FILTER = 2,
 /* WORHP Line: method merit function. */
  WORHP_LINE_METHOD_MERIT = 3,
 /*-----------------------------------------------------------------
  *  WORHP Line: phases
  *-----------------------------------------------------------------*/
 /* WORHP Line: phase global. */
  WORHP_LINE_PHASE_GLOBAL = 1,
 /* WORHP Line: phase local. */
  WORHP_LINE_PHASE_LOCAL = 2,
 /*-----------------------------------------------------------------
  *  WORHP Line: status
  *-----------------------------------------------------------------*/
 /* stages status: everything is fine, continue. */
  WORHP_LINE_OK = 100,
 /* stages status: full step size (ONE) is acceptable. */
  WORHP_LINE_ACCEPTED_FULLSTEP = 200,
 /* stages status: full step size (AlphaMax) is acceptable. */
  WORHP_LINE_ACCEPTED_MAXSTEP = 300,
 /* stages status: step size is acceptable. */
  WORHP_LINE_ACCEPTED = 400,
 /* stages status: step size is not acceptable. */
  WORHP_LINE_NOTACCEPTED = 500,
 /* stages status: full step size is not acceptable. */
  WORHP_LINE_NOTACCEPTED_FULLSTEP = 600,
 /* stages status: NaN evaluation. */
  WORHP_LINE_NAN = 700,
 /* stages status: minimum step size reached. */
  WORHP_LINE_MINSTEPSIZE = 800,
 /* stages status: line search was aborted. */
  WORHP_LINE_ABORTED = 900,
 /* stages status: otherwise. */
  WORHP_LINE_ELSE = 1000,
 /*-----------------------------------------------------------------
  *  WORHP Zen: RC flags
  *-----------------------------------------------------------------*/
  WORHP_ZEN_RC_INIT = 0,
  WORHP_ZEN_RC_RENEW_LU = 1,
  WORHP_ZEN_RC_DGP = 2,
  WORHP_ZEN_RC_DLP = 3,
  WORHP_ZEN_RC_DLXP = 4,
  WORHP_ZEN_RC_DLPP = 5,
 /*-----------------------------------------------------------------
  *  WORHP Zen: parameters
  *-----------------------------------------------------------------*/
 /* do not store sensitivity in matrices, use just temporary until calculation of next sensitivity */
  WORHP_ZEN_STORE_TMP = 1,
 /* store sensitivities in matrices in dense format */
  WORHP_ZEN_STORE_DENSE = 2,
 /* store sensitivities in matrices in sparse format based on active set */
  WORHP_ZEN_STORE_SPARSE = 3,
 /*-----------------------------------------------------------------
  *  Array sizes
  *-----------------------------------------------------------------*/
  WMTslices = 100,
  WMTrows = 6,
  WMTnames = 20,
  NAres = 7,
  NUserAction = 14,
  NStageHistory = 10,
 /*-----------------------------------------------------------------
  *  Feasibility mode flags
  *-----------------------------------------------------------------*/
  FEAS_MODE_OFF = 0,
  FEAS_MODE_INITIAL = 1,
 /* was: JustFeasible */
  FEAS_MODE_NOOBJ = 2,
 /* was: FeasModeActive */
  FEAS_MODE_DUAL = 4,
 /*-----------------------------------------------------------------
  *  NLP algorithm flag
  *-----------------------------------------------------------------*/
  ALGORITHM_SQP = 1,
  ALGORITHM_IP = 2,
  WORHP_HESSIAN_USER = 0,
  WORHP_HESSIAN_FIDIF = 1,
  WORHP_HESSIAN_BFGS = 2,
 /*-----------------------------------------------------------------
  *  Function type flags
  *-----------------------------------------------------------------*/
  WORHP_CONSTANT = 1,
  WORHP_LINEAR = 2,
  WORHP_QUADRATIC = 3,
  WORHP_NONLINEAR = 4,
 /*-----------------------------------------------------------------
  *  User action constants
  *-----------------------------------------------------------------*/
  callWorhp = 1,
  evalF = 2,
  evalG = 3,
  evalDF = 4,
  evalDG = 5,
  evalHM = 6,
  evalZenDGp = 7,
  evalZenDLxp = 8,
  evalZenDLp = 9,
  evalZenDLpp = 10,
  iterOutput = 11,
  fidif_DF = 12,
  fidif_DG = 13,
  fidif_HM = 14,
 /* Not actually a user action, but a combination of all fidif_* */
  fidif = 15,
 /*-----------------------------------------------------------------
  *  SQP status constants
  *-----------------------------------------------------------------*/
 /* 1st call to SQP */
  FirstCall = 20,
 /* SQP is iterating */
  Iterating = 21,
 /* SQP is iterating */
  IteratingAres = 22,
 /* 1st Armijo call in current major iter */
  ArmijoFirstCall = 23,
 /* Armijo updates x and flags user action */
  ArmijoUpdate = 24,
 /* Armijo evaluates merit function */
  ArmijoEvaluate = 25,
 /* QP solver wants to try an SLP step */
  SolverSLP = 26,
 /* Setting up Zen */
  ZenSetup = 27,
 /*-----------------------------------------------------------------
  *  stage status
  *-----------------------------------------------------------------*/
 /* stage status: no status set = stage not entered yet */
  WORHP_UNDEFINED = 28,
 /* stage status: everything fine, continue. */
  WORHP_OK = 29,
 /* stage status: nothing fine, maybe stop. */
  WORHP_FAIL = 30,
 /* stage status: otherwise. */
  WORHP_ELSE = 31,
 /* stage status: optimal solution found. */
  WORHP_OPTIMAL = 32,
 /* stage status: optimal solution found of modified problem. */
  WORHP_MODOPTIMAL = 33,
 /* stage status: tolerances met for crossover. */
  WORHP_CROSSOVEROPTIMAL = 34,
 /* stage status: optimal solution found by lowpass filter. */
  WORHP_LOWPASSOPTIMAL = 35,
 /* stage status: optimal solution found of barrier problem. */
  WORHP_BARRIEROPTIMAL = 36,
 /* stage status: optimal solution found of penalty problem. */
  WORHP_PENALTYOPTIMAL = 37,
 /* stage status: search direction is zero. */
  WORHP_STEPZERO = 38,
 /* stage status: update is too small. */
  WORHP_STEPSMALL = 39,
 /* stage status: too big. */
  WORHP_TOOBIG = 40,
 /* stage status: unbounded problem. */
  WORHP_UNBOUNDED = 41,
 /* stage status: iterates diverge. */
  WORHP_DIVERGENCE_PRIMAL = 42,
 /* stage status: iterates diverge. */
  WORHP_DIVERGENCE_DUAL = 43,
 /* stage status: penalty parameter diverges. */
  WORHP_DIVERGENCE_PENALTY = 44,
 /* stage status: NaN evaluation. */
  WORHP_NAN = 45,
 /* stage status: kkt matrix not positive definite. */
  WORHP_NOTPOSDEF = 46,
 /* stage status: kkt matrix singular. */
  WORHP_SINGULAR = 47,
 /* stage status: infeasible problem. */
  WORHP_INFEASIBLEOPTIMAL = 48,
 /* stage status: infeasible problem. */
  WORHP_INFEASIBLE = 49,
 /* stage status: fritz john point. */
  WORHP_FRITZJOHN = 50,
 /* stage status: indicates that barrier has been updated */
  WORHP_UPDATEDBARRIER = 51,
 /* stage status: indicates that penalty has been updated */
  WORHP_UPDATEDPENALTY = 52,
 /* stage status: indicates that aug duals have been updated */
  WORHP_UPDATEDAUGDUALS = 53,
 /* stage status: indicates that current steps blocks progress */
  WORHP_BLOCKING = 54,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_start = 200,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_fi = 201,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_fij = 202,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_fdiag = 203,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_gi = 204,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_hgr = 205,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_hgrsgr = 206,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_gij = 207,
 /* FD Hessian determination RC flag */
  fidif_HM_RC_pert_gdiag = 208,
 /* mja: Start status for fidif method without groups */
  fidif_start = 209,
 /* mja: Status for evaluation of the positive side of the difference */
  fidif_posside = 210,
 /* mja: Status for evaluation of the negative side of the difference */
  fidif_negside = 211,
 /* mja: Status for evaluation of f or g in x0 for HM */
  fidif_hm_in_x0 = 212,
 /* mja: Status for evaluation of f or g perturbed in 2 components for HM */
  fidif_hm_2components = 213,
 /* mja: Status for evaluation of positive perturbed df or dg for HM */
  fidif_hm_userdfdg_posside = 214,
 /* mja: Status for evaluation of negative perturbed df or dg for HM */
  fidif_hm_userdfdg_negside = 215,
 /* mja: End status for fidif method without groups */
  fidif_end = 216,
 /*-----------------------------------------------------------------
  *  Armijo recovery strategies
  *-----------------------------------------------------------------*/
 /* Armijo recovery strategy: SLP step */
  AresSLP = 41,
 /* Armijo recovery strategy: Non-monotone */
  AresNonMon = 42,
 /* Armijo recovery strategy: Force 1 */
  AresForce = 43,
 /* Armijo recovery strategy: Switch to dual-feas-mode */
  AresFeas = 44,
 /* Give up */
  AresGiveUp = 50,
 /*-----------------------------------------------------------------
  *  SQP stages
  *-----------------------------------------------------------------*/
  No_Stage = 100,
  Init_Data = 101,
  WORHP_STAGE_NLP_INIT = 102,
  WORHP_STAGE_RESTART = 103,
  WORHP_STAGE_CROSSOVER = 104,
  Pre_KKT = 105,
  Check_KKT = 106,
  Create_QP = 107,
  Hessian_Regularisation = 108,
  Solve_QP = 109,
  Post_QP = 110,
  Find_Stepsize = 111,
  Update_Point = 112,
  Recovery_Strategies = 113,
  Finalise = 114,
  SLP_step = 115,
  Solve_Feasibility_QP = 116,
  Post_Optimum = 117,
  Pre_BStep = 118,
  BStep = 119,
  Post_QP_Sens = 120,
  WORHP_STAGE_IP_INIT_RESTART = 121,
  WORHP_STAGE_IP_INIT_PREPARE = 122,
  WORHP_STAGE_IP_INIT_MODIFY = 123,
  WORHP_STAGE_IP_INIT_PARAMETER = 124,
  WORHP_STAGE_IP_INIT_ESTIMATE = 125,
  WORHP_STAGE_IP_INIT_CENTERING = 126,
  WORHP_STAGE_IP_INIT_FINALIZE = 127,
  WORHP_STAGE_IP_INIT_MODE = 128,
  WORHP_STAGE_IP_CHECK_PREPARE = 129,
  WORHP_STAGE_IP_CHECK_ADAPT = 130,
  WORHP_STAGE_IP_CHECK = 131,
  WORHP_STAGE_IP_CHECK_INFEAS = 132,
  WORHP_STAGE_IP_CHECK_BARRIER = 133,
  WORHP_STAGE_IP_CHECK_PENALTY = 134,
  WORHP_STAGE_IP_UPDATE_BARRIER = 135,
  WORHP_STAGE_IP_UPDATE_PENALTY = 136,
  WORHP_STAGE_IP_LEQ_PREPARE = 137,
  WORHP_STAGE_IP_LEQ_CREATE = 138,
  WORHP_STAGE_IP_LEQ_REGULARIZE = 139,
  WORHP_STAGE_IP_STEP_PREPARE = 140,
  WORHP_STAGE_IP_STEP_SELECT = 141,
  WORHP_STAGE_IP_ADAPT_BARRIER = 142,
  WORHP_STAGE_IP_ADAPT_PENALTY = 143,
  WORHP_STAGE_IP_LINE_PREPARE = 145,
  WORHP_STAGE_IP_LINE_CHECK = 146,
  WORHP_STAGE_IP_LINE_UPDATE = 147,
  WORHP_STAGE_IP_LINE_REDUCE = 148,
  WORHP_STAGE_IP_UNBLOCK = 149,
  WORHP_STAGE_IP_CORRECT_PREPARE = 150,
  WORHP_STAGE_IP_CORRECT_STEP = 151,
  WORHP_STAGE_IP_CORRECT_ABORT = 152,
  WORHP_STAGE_IP_FINALIZE = 153,
  WORHP_STAGE_TERMINATE = 154,
 /* mja: Stage for checking user derivatives with fidif. */
  Check_Deriv_Values = 200,
 /* mja: Stage to signal fidif stage to StageMsg. Not used otherwise as fidif is called with WorhpFidif */
  Worhp_Fidif = 201,
 /*-----------------------------------------------------------------
  *  (somehow) successful termination
  *-----------------------------------------------------------------*/
  TerminateSuccess = 1000,
  OptimalSolution = 1001,
  LowPassFilterOptimal = 1011,
  OptimalSolutionConstantF = 1012,
  FritzJohn = 1021,
  NotDiffable = 1022,
  Unbounded = 1031,
  FeasibleSolution = 1041,
  SearchDirectionZero = 1051,
  SearchDirectionSmall = 1052,
  AcceptableSolution = 1061,
  AcceptablePrevious = 1062,
  LowPassFilterAcceptable = 1063,
  AcceptableSolutionConstantF = 1064,
  AcceptablePreviousConstantF = 1065,
  AcceptableSolutionSKKT = 1066,
  AcceptableSolutionScaled = 1067,
  AcceptablePreviousScaled = 1068,
 /*-----------------------------------------------------------------
  *  (somehow) unsuccessful termination
  *-----------------------------------------------------------------*/
  TerminateError = -1000,
  MaxCalls = -1001,
  MaxIter = -1002,
  Timeout = -1003,
  LocalInfeasOptimal = -1011,
  LocalInfeas = -1012,
  GlobalInfeas = -1013,
  TooBig = -1021,
  evalsNaN = -1022,
  DivergingPrimal = -1023,
  DivergingDual = -1024,
  MinimumStepsize = -1031,
  RegularizationFailed = -1032,
  InitError = -1041,
  DataError = -1042,
  RestartError = -1043,
  QPerror = -1051,
  LinearSolverFailed = -1052,
  TerminatedByCheckFD = -1061,
  LicenseError = -1071,
  Debug = -1206,
  LicenseWarnExpiryDays = 31
};


typedef struct OptVarStruct {
  int n;
  int m;
  int k;
  int nGPart;
  int iGPart;
  double F;
  int FType;
  double *X;
  double *XL;
  double *XU;
  double *Lambda;
  double *G;
  double *GL;
  double *GU;
  int *GType;
  double *Mu;
  int *GPart;
  double *P;

 /* Indicates that X was changed by WORHP */
  bool newX;

 /* Automatically added initialisation flag.  */
  bool initialised;
} OptVar;

typedef struct WorkspaceStruct {

 /* WORHP NLP: selects the modification strategy */
  int NLP_ParModType;

 /* WORHP NLP: enables the storage of the gradient of the lagrangian of the modified problem without objective function */
  bool NLP_ParUseDLFeas;

 /* WORHP NLP: enables the possibility to caluclate DG^T * G with WORHP NLP */
  bool NLP_ParUseDGG;

 /* WORHP NLP: If enabled the created matrices will be sorted the WORHP way. */
  bool NLP_ParSortMatrix;

 /* WORHP NLP: max gradient after automatic scaling */
  double NLP_ParScaleMaxGrad;

 /* WORHP NLP: min scaling factor of automatic scaling */
  double NLP_ParScaleMin;

 /* WORHP NLP: if enabled use values are checked for NaN and Inf values */
  int NLP_ParCheckNanInf;

 /* WORHP NLP: if enabled an iterate can be stored for warmstart */
  bool NLP_ParStoreWarmstart;

 /* WORHP NLP: if enabled the bounds will be stored e.g. for tracking changes after warmstart */
  bool NLP_ParStoreBounds;

 /* WORHP NLP: number of optimization variables */
  int NLP_n;

 /* WORHP NLP: number of optimization variables with bounds */
  int NLP_nIeq;

 /* WORHP NLP: number of optimization variables with just lower bounds */
  int NLP_nIeqLow;

 /* WORHP NLP: number of optimization variables with just upper bounds */
  int NLP_nIeqUp;

 /* WORHP NLP: number of optimization variables with lower and upper bounds */
  int NLP_nIeqLowUp;

 /* WORHP NLP: number of constraints */
  int NLP_m;

 /* WORHP NLP: number of equality constraints */
  int NLP_mEq;

 /* WORHP NLP: number of inequality constraints or slacks */
  int NLP_mIeq;

 /* WORHP NLP: number of inequality constraints or slacks with just lower bounds */
  int NLP_mIeqLow;

 /* WORHP NLP: number of inequality constraints or slacks with just upper bounds */
  int NLP_mIeqUp;

 /* WORHP NLP: number of inequality constraints or slacks with lower and upper bounds */
  int NLP_mIeqLowUp;

 /* WORHP NLP: Indicates that the objective is constant */
  bool NLP_ConstantF;

 /* WORHP NLP: Indicates that the Gradient is constant */
  bool NLP_ConstantDF;

 /* WORHP NLP: Indicates that the Jacobian is constant */
  bool NLP_ConstantDG;

 /* WORHP NLP: Indicates that the Hessian is constant */
  bool NLP_ConstantHM;

 /* WORHP NLP: Indicates if no objective exist and just feasibility is relevant */
  bool NLP_FeasibilityOnly;

 /* WORHP NLP: Indicates if values of bounds have been changed */
  bool NLP_UpdatedBoundsValue;

 /* WORHP NLP: Indicates if types of (box) constraints have been changed */
  bool NLP_UpdatedBoundsType;
  size_t dim_NLP_X;
  size_t dim_NLP_S;
  size_t dim_NLP_Mu;
  size_t dim_NLP_MuGL;
  size_t dim_NLP_MuGU;
  size_t dim_NLP_LambdaXL;
  size_t dim_NLP_LambdaXU;
  size_t dim_NLP_LambdaSL;
  size_t dim_NLP_LambdaSU;
  size_t dim_NLP_G;
  size_t dim_NLP_XL;
  size_t dim_NLP_XU;
  size_t dim_NLP_SL;
  size_t dim_NLP_SU;
  size_t dim_NLP_GL;
  size_t dim_NLP_GU;
  size_t dim_NLP_GB;
  size_t dim_NLP_XL0;
  size_t dim_NLP_XU0;
  size_t dim_NLP_GL0;
  size_t dim_NLP_GU0;

 /* WORHP NLP: optimization variable */
  double *NLP_X;

 /* WORHP NLP: slack variables */
  double *NLP_S;

 /* WORHP NLP: lagrangian multipliers of equality constraints */
  double *NLP_Mu;

 /* WORHP NLP: lagrangian multipliers for lower bounds GL */
  double *NLP_MuGL;

 /* WORHP NLP: lagrangian multipliers for lower bounds GU */
  double *NLP_MuGU;

 /* WORHP NLP: lagrangian multipliers for lower bounds XL */
  double *NLP_LambdaXL;

 /* WORHP NLP: lagrangian multipliers for lower bounds XU */
  double *NLP_LambdaXU;

 /* WORHP NLP: lagrangian multipliers for lower bounds SL */
  double *NLP_LambdaSL;

 /* WORHP NLP: lagrangian multipliers for lower bounds SU */
  double *NLP_LambdaSU;

 /* WORHP NLP: objective function of the modified problem. */
  double NLP_F;

 /* WORHP NLP: constraints of the modified problem */
  double *NLP_G;

 /* WORHP NLP: lower bounds for optimization variables */
  double *NLP_XL;

 /* WORHP NLP: upper bounds for optimization variables */
  double *NLP_XU;

 /* WORHP NLP: lower bounds for slacks */
  double *NLP_SL;

 /* WORHP NLP: upper bounds for slacks */
  double *NLP_SU;

 /* WORHP NLP: lower bounds for inequality constraints */
  double *NLP_GL;

 /* WORHP NLP: upper bounds for inequality constraints */
  double *NLP_GU;

 /* WORHP NLP: bounds for equality constraints */
  double *NLP_GB;

 /* WORHP NLP: gradient of the objective function of the modified problem. */
  WorhpMatrix NLP_DF;

 /* WORHP NLP: jacobian of the constraints of the modified problem. */
  WorhpMatrix NLP_DG;

 /* WORHP NLP: hessian of the modified problem. */
  WorhpMatrix NLP_HM;

 /* WORHP NLP: lower bounds for optimization variables (original bounds) */
  double *NLP_XL0;

 /* WORHP NLP: lower bounds for optimization variables (original bounds) */
  double *NLP_XU0;

 /* WORHP NLP: lower bounds for optimization variables (original bounds) */
  double *NLP_GL0;

 /* WORHP NLP: lower bounds for optimization variables (original bounds) */
  double *NLP_GU0;
  size_t dim_NLP_X0;
  size_t dim_NLP_S0;
  size_t dim_NLP_Mu0;
  size_t dim_NLP_MuGL0;
  size_t dim_NLP_MuGU0;
  size_t dim_NLP_LambdaXL0;
  size_t dim_NLP_LambdaXU0;
  size_t dim_NLP_LambdaSL0;
  size_t dim_NLP_LambdaSU0;

 /* WORHP NLP: optimization variable of former iteration */
  double *NLP_X0;

 /* WORHP NLP: slack variables of former iteration */
  double *NLP_S0;

 /* WORHP NLP: lagrangian multipliers of equality constraints of former iteration */
  double *NLP_Mu0;

 /* WORHP NLP: lagrangian multipliers for lower bounds GL of former iteration */
  double *NLP_MuGL0;

 /* WORHP NLP: lagrangian multipliers for lower bounds GU of former iteration */
  double *NLP_MuGU0;

 /* WORHP NLP: lagrangian multipliers for lower bounds XL of former iteration */
  double *NLP_LambdaXL0;

 /* WORHP NLP: lagrangian multipliers for lower bounds XU of former iteration */
  double *NLP_LambdaXU0;

 /* WORHP NLP: lagrangian multipliers for lower bounds SL of former iteration */
  double *NLP_LambdaSL0;

 /* WORHP NLP: lagrangian multipliers for lower bounds SU of former iteration */
  double *NLP_LambdaSU0;
  size_t dim_NLP_DLx;
  size_t dim_NLP_DLs;
  size_t dim_NLP_DLxFeas;
  size_t dim_NLP_DLsFeas;
  size_t dim_NLP_OrigDL;

 /* WORHP NLP: gradient of the lagrangian w.r.t. X (modified problem) */
  double *NLP_DLx;

 /* WORHP NLP: gradient of the lagrangian w.r.t. S (modified problem) */
  double *NLP_DLs;

 /* WORHP NLP: gradient of the lagrangian w.r.t. X (modified problem without objective function) */
  double *NLP_DLxFeas;

 /* WORHP NLP: gradient of the lagrangian w.r.t. S (modified problem without objective function) */
  double *NLP_DLsFeas;

 /* WORHP NLP: gradient of the lagrangian (original problem) */
  double *NLP_OrigDL;
  size_t dim_NLP_DGG;

 /* WORHP NLP: Result of the product DG^T * G */
  double *NLP_DGG;
  size_t dim_NLP_ScaleX;
  size_t dim_NLP_ScaleG;

 /* WORHP NLP: scaling factor of objective */
  double NLP_ScaleF;

 /* WORHP NLP: scaling factor of objective set by algorithm */
  double NLP_ScaleFalg;

 /* WORHP NLP: scaling factor of objective in lagrangian function set by algorithm */
  double NLP_ScaleLFalg;

 /* WORHP NLP: scaling factor of optimization variable */
  double *NLP_ScaleX;

 /* WORHP NLP: scaling factor of constraints */
  double *NLP_ScaleG;
  size_t dim_NLP_AcceptOrigX;
  size_t dim_NLP_AcceptOrigMu;
  size_t dim_NLP_AcceptOrigLambda;

 /* WORHP NLP: variable X of acceptable solution (original problem) */
  double *NLP_AcceptOrigX;

 /* WORHP NLP: variable Mu of acceptable solution (original problem) */
  double *NLP_AcceptOrigMu;

 /* WORHP NLP: variable Lambda of acceptable solution (original problem) */
  double *NLP_AcceptOrigLambda;

 /* WORHP NLP: objective function of acceptable solution (original problem) */
  double NLP_AcceptOrigF;

 /* WORHP NLP: optimality of acceptable solution (original problem) */
  double NLP_AcceptOrigOptiMax;

 /* WORHP NLP: feasibility of acceptable solution (original problem) */
  double NLP_AcceptOrigFeasMax;

 /* WORHP NLP: complementarity of acceptable solution (original problem) */
  double NLP_AcceptOrigComplMax;

 /* WORHP NLP: optimality of acceptable solution (modified problem) */
  double NLP_AcceptOptiMax;

 /* WORHP NLP: feasibility of acceptable solution (modified problem) */
  double NLP_AcceptFeasMax;

 /* WORHP NLP: complementarity of acceptable solution (modified problem) */
  double NLP_AcceptComplMax;

 /* WORHP NLP: iteration of acceptable solution */
  int NLP_AcceptMajorIter;

 /* WORHP NLP: indicates if acceptbale solution has been found */
  bool NLP_AcceptSolFound;
  size_t dim_NLP_WarmX;
  size_t dim_NLP_WarmMu;
  size_t dim_NLP_WarmLambda;

 /* WORHP IP: optimization variable for warmstart */
  double *NLP_WarmX;

 /* WORHP IP: lagrange multiplier Mu for warmstart */
  double *NLP_WarmMu;

 /* WORHP IP: lagrange multiplier Lambda for warmstart */
  double *NLP_WarmLambda;

 /* WORHP IP: indicates if iterate has been stored for warmstart */
  bool NLP_WarmStored;
  size_t dim_NLP_idxOrigX;
  size_t dim_NLP_idxOrigG;
  size_t dim_NLP_idxOrigDF;
  size_t dim_NLP_idxOrigDG;
  size_t dim_NLP_idxOrigHM;
  size_t dim_NLP_idxX;
  size_t dim_NLP_idxG;
  size_t dim_NLP_idxHMdiag;

 /* WORHP NLP: mapping modified X -> original X */
  int *NLP_idxOrigX;

 /* WORHP NLP: mapping modified G -> original G */
  int *NLP_idxOrigG;

 /* WORHP NLP: mapping modified DF -> original DF */
  int *NLP_idxOrigDF;

 /* WORHP NLP: mapping modified DG -> original DG */
  int *NLP_idxOrigDG;

 /* WORHP NLP: mapping modified HM -> original HM */
  int *NLP_idxOrigHM;

 /* WORHP NLP: mapping modified X <- original X */
  int *NLP_idxX;

 /* WORHP NLP: mapping modified G <- original G */
  int *NLP_idxG;

 /* WORHP NLP: indices of HM diagonal */
  int *NLP_idxHMdiag;

 /* WORHP NLP: start index for unbounded X */
  int NLP_idxXunbnd0;

 /* WORHP NLP: end index for unbounded X */
  int NLP_idxXunbnd1;

 /* WORHP NLP: start index for lower bounded X */
  int NLP_idxXieqLow0;

 /* WORHP NLP: end index for lower bounded X */
  int NLP_idxXieqLow1;

 /* WORHP NLP: start index for lower and upper bounded X */
  int NLP_idxXieqLowUp0;

 /* WORHP NLP: end index for lower and upper bounded X */
  int NLP_idxXieqLowUp1;

 /* WORHP NLP: start index for upper bounded X */
  int NLP_idxXieqUp0;

 /* WORHP NLP: end index for upper bounded X */
  int NLP_idxXieqUp1;

 /* WORHP NLP: start index for equality G */
  int NLP_idxGeq0;

 /* WORHP NLP: end index for equality G */
  int NLP_idxGeq1;

 /* WORHP NLP: start index for lower bounded G */
  int NLP_idxGieqLow0;

 /* WORHP NLP: end index for lower bounded G */
  int NLP_idxGieqLow1;

 /* WORHP NLP: start index for lower and upper bounded G */
  int NLP_idxGieqLowUp0;

 /* WORHP NLP: end index for lower and upper bounded G */
  int NLP_idxGieqLowUp1;

 /* WORHP NLP: start index for upper bounded G */
  int NLP_idxGieqUp0;

 /* WORHP NLP: end index for upper bounded G */
  int NLP_idxGieqUp1;

 /* WORHP NLP: number of diagonal elements in HM */
  int NLP_nnzHMdiag;

 /* WORHP NLP: Evaluation flag for objective function (original problem) */
  bool NLP_EvalOrigF;

 /* WORHP NLP: Evaluation flag for constraints (original problem) */
  bool NLP_EvalOrigG;

 /* WORHP NLP: Evaluation flag for gradient (original problem) */
  bool NLP_EvalOrigDF;

 /* WORHP NLP: Evaluation flag for jacobian (original problem) */
  bool NLP_EvalOrigDG;

 /* WORHP NLP: Evaluation flag for hessian (original problem) */
  bool NLP_EvalOrigHM;

 /* WORHP NLP: Evaluation flag for gradient of lagrangian (original problem) */
  bool NLP_EvalOrigDL;

 /* WORHP NLP: Evalutation flag for optimality (original problem) */
  bool NLP_EvalOptiOrig;

 /* WORHP NLP: Evalutation flag for feasibility (original problem) */
  bool NLP_EvalFeasOrig;

 /* WORHP NLP: Evalutation flag for complementarity (original problem) */
  bool NLP_EvalComplOrig;

 /* WORHP NLP: Evaluation flag for objective function (modified problem) */
  bool NLP_EvalF;

 /* WORHP NLP: Evaluation flag for constraints (modified problem) */
  bool NLP_EvalG;

 /* WORHP NLP: Evaluation flag for gradient (modified problem) */
  bool NLP_EvalDF;

 /* WORHP NLP: Evaluation flag for jacobian (modified problem) */
  bool NLP_EvalDG;

 /* WORHP NLP: Evaluation flag for hessian (modified problem) */
  bool NLP_EvalHM;

 /* WORHP NLP: Evalutation flag for gradient of lagrangian (modified problem) */
  bool NLP_EvalDL;

 /* WORHP NLP: Evalutation flag for gradient of lagrangian (modified problem without objective function) */
  bool NLP_EvalDLFeas;

 /* WORHP NLP: Evaluation flag for product DG^T * G */
  bool NLP_EvalDGG;

 /* WORHP NLP: Evalutation flag for optimality (modified problem) */
  bool NLP_EvalOpti;

 /* WORHP NLP: Evalutation flag for feasibility (modified problem) */
  bool NLP_EvalFeas;

 /* WORHP NLP: Evalutation flag for complementarity (modified problem) */
  bool NLP_EvalCompl;

 /* WORHP IP: objective of barrier problem */
  double IP_ObjBarr;

 /* WORHP IP: objective of barrier / penalty problem */
  double IP_ObjBarrPen;

 /* WORHP IP: barrier part of objective of barrier problem */
  double IP_ObjBarrPart;

 /* WORHP IP: penalty part of objective of barrier / penalty problem */
  double IP_ObjPenPart;

 /* WORHP IP: approximated optimality of feasibility problem (2-norm) */
  double IP_OptiFeasApprox2;

 /* WORHP IP: approximated optimality of feasibility problem (max norm) */
  double IP_OptiFeasApproxMax;

 /* WORHP IP: optimality of feasibility problem (2-norm) */
  double IP_OptiFeas2;

 /* WORHP IP: optimality of feasibility problem (max norm) */
  double IP_OptiFeasMax;

 /* WORHP IP: feasibility of barrier/penalty problem (2-norm) */
  double IP_FeasBarrPen2;

 /* WORHP IP: feasibility of barrier/penalty problem (max norm) */
  double IP_FeasBarrPenMax;

 /* WORHP IP: complementarity of barrier problem (2-norm) */
  double IP_ComplBarr2;

 /* WORHP IP: complementarity of barrier problem (max norm) */
  double IP_ComplBarrMax;

 /* WORHP IP: complementarity of barrier problem (2-norm) */
  double IP_ComplBarrInv2;

 /* WORHP IP: complementarity of barrier problem (max norm) */
  double IP_ComplBarrInvMax;

 /* WORHP IP: complementarity of feasibility problem (2-norm) */
  double IP_ComplFeas2;

 /* WORHP IP: complementarity of feasibility problem (max norm) */
  double IP_ComplFeasMax;

 /* WORHP IP: inital constraint violation */
  double IP_FeasInit;
  size_t dim_IP_FeasBarrPen;
  size_t dim_IP_ComplBarrXL;
  size_t dim_IP_ComplBarrXU;
  size_t dim_IP_ComplBarrSL;
  size_t dim_IP_ComplBarrSU;

 /* WORHP IP: feasibility of barrier / penalty subproblem */
  double *IP_FeasBarrPen;

 /* WORHP IP: complementarity of lower box constraints of barrier problem */
  double *IP_ComplBarrXL;

 /* WORHP IP: complementarity of upper box constraints of barrier problem */
  double *IP_ComplBarrXU;

 /* WORHP IP: complementarity of lower constraints of barrier problem */
  double *IP_ComplBarrSL;

 /* WORHP IP: complementarity of upper constraints of barrier problem */
  double *IP_ComplBarrSU;

 /* WORHP IP: barrier parameter */
  double IP_Barrier;

 /* WORHP IP: min value of barrier parameter */
  double IP_BarrierMin;

 /* WORHP IP: penalty parameter (for objective) */
  double IP_PenaltyObj;

 /* WORHP IP: penalty parameter (for constraint violation) */
  double IP_PenaltyFeas;

 /* WORHP IP: fraction-to-the-boundary parameter. */
  double IP_Tau;

 /* WORHP IP: iterations after last barrier update */
  int IP_IterUpdate;

 /* WORHP IP: trial value of PenaltyObj for adaptive updates */
  double IP_AdaptPenaltyObj;

 /* WORHP IP: regularization term in hessian */
  double IP_RegTau;

 /* WORHP IP: regularization term in jacobian */
  double IP_RegTauC;

 /* WORHP IP: former regularization term in hessian */
  double IP_RegTauOld;

 /* WORHP IP: scaling factor for optimality in KKT conditions */
  double IP_ScaleKKTOpt;

 /* WORHP IP: scaling factor for feasibility in KKT conditions */
  double IP_ScaleKKTFeas;
  size_t dim_IP_XUX;
  size_t dim_IP_XXL;
  size_t dim_IP_GUS;
  size_t dim_IP_SGL;
  size_t dim_IP_XUX0;
  size_t dim_IP_XXL0;
  size_t dim_IP_GUS0;
  size_t dim_IP_SGL0;

 /* WORHP IP: the difference XU-X */
  double *IP_XUX;

 /* WORHP IP: the difference X-XL */
  double *IP_XXL;

 /* WORHP IP: the difference GU-S */
  double *IP_GUS;

 /* WORHP IP: the difference S-GL */
  double *IP_SGL;

 /* WORHP IP: the difference XU-X before linesearch */
  double *IP_XUX0;

 /* WORHP IP: the difference X-XL before linesearch */
  double *IP_XXL0;

 /* WORHP IP: the difference GU-S before linesearch */
  double *IP_GUS0;

 /* WORHP IP: the difference S-GL before linesearch */
  double *IP_SGL0;

 /* WORHP IP: system matrix for the linear equation system */
  WorhpMatrix IP_LEQ;
  size_t dim_IP_LeqX;

 /* WORHP IP: right-hand-side and solution of linear equation system. */
  double *IP_LeqX;

 /* WORHP IP: start index of block 11 */
  int IP_Leq11s;

 /* WORHP IP: end index of block 11 */
  int IP_Leq11e;

 /* WORHP IP: start index of block 31 */
  int IP_Leq31s;

 /* WORHP IP: end index of block 31 */
  int IP_Leq31e;

 /* WORHP IP: start index of block 22 */
  int IP_Leq22s;

 /* WORHP IP: end index of block 22 */
  int IP_Leq22e;

 /* WORHP IP: start index of block 23 */
  int IP_Leq32s;

 /* WORHP IP: end index of block 23 */
  int IP_Leq32e;

 /* WORHP IP: start index of block 33 */
  int IP_Leq33s;

 /* WORHP IP: end index of block 33 */
  int IP_Leq33e;

 /* WORHP IP: start index of block 44 */
  int IP_Leq44s;

 /* WORHP IP: end index of block 44 */
  int IP_Leq44e;

 /* WORHP IP: start index of block 51 */
  int IP_Leq51s;

 /* WORHP IP: end index of block 51 */
  int IP_Leq51e;

 /* WORHP IP: start index of block 55 */
  int IP_Leq55s;

 /* WORHP IP: end index of block 55 */
  int IP_Leq55e;

 /* WORHP IP: start index of block 61 */
  int IP_Leq61s;

 /* WORHP IP: end index of block 61 */
  int IP_Leq61e;

 /* WORHP IP: start index of block 66 */
  int IP_Leq66s;

 /* WORHP IP: end index of block 66 */
  int IP_Leq66e;

 /* WORHP IP: start index of block 72 */
  int IP_Leq72s;

 /* WORHP IP: end index of block 72 */
  int IP_Leq72e;

 /* WORHP IP: start index of block 77 */
  int IP_Leq77s;

 /* WORHP IP: end index of block 77 */
  int IP_Leq77e;

 /* WORHP IP: start index of block 82 */
  int IP_Leq82s;

 /* WORHP IP: end index of block 82 */
  int IP_Leq82e;

 /* WORHP IP: start index of block 88 */
  int IP_Leq88s;

 /* WORHP IP: end index of block 88 */
  int IP_Leq88e;

 /* WORHP IP: current value of block 44 */
  double IP_Leq44val;

 /* WORHP IP: chooses the specific linear equation system */
  int IP_LeqType;

 /* WORHP IP: chooses the specific linear equation system */
  int IP_LeqBarrierType;

 /* WORHP IP: chooses the specific linear equation system */
  int IP_LeqPenaltyType;

 /* WORHP IP: flag indicating that matrix has been provided */
  bool IP_LeqDoneMatrix;

 /* WORHP IP: flag indicating that factorization has been done */
  bool IP_LeqDoneFactorization;

 /* WORHP IP: indicates inertia status of the LEQ matrix. */
  int IP_LeqInertia;

 /* WORHP IP: min number of iterative refinement steps */
  int IP_LeqItRefMinIter;

 /* WORHP IP: max number of iterative refinement steps */
  int IP_LeqItRefMaxIter;

 /* WORHP IP: residual ratio of iterative refinement */
  double IP_LeqItRefRatio;

 /* WORHP IP: iteration counter for iterative refinement */
  int IP_LeqItRefIter;

 /* WORHP IP: indicates if quality has been increased in this iteration */
  bool IP_LeqIncQuality;

 /* WORHP IP: specifies if identity matrix should be used instead of hessian */
  bool IP_LeqUseIdentity;

 /* WORHP IP: enables the solution of the standard step */
  bool IP_LeqSolveStepStd;

 /* WORHP IP: enables the solution of the step (barrier = 0) */
  bool IP_LeqSolveStepBarrZero;

 /* WORHP IP: enables the solution of the step (penaltyobj = 0) */
  bool IP_LeqSolveStepFeas;

 /* WORHP IP: enables the solution of the step (aug = mu) */
  bool IP_LeqSolveStepAugEq;

 /* WORHP IP: indicates which leq solve mode is currently enabled. */
  int IP_LeqSolveMode;

 /* WORHP IP: indicates which type of rhs is currently stored in the rhs vectors */
  int IP_LeqCurrRhs;
  size_t dim_IP_DStdX;
  size_t dim_IP_DStdS;
  size_t dim_IP_DStdMu;
  size_t dim_IP_DStdLambdaXL;
  size_t dim_IP_DStdLambdaXU;
  size_t dim_IP_DStdLambdaSL;
  size_t dim_IP_DStdLambdaSU;
  size_t dim_IP_DAugEqX;
  size_t dim_IP_DAugEqS;
  size_t dim_IP_DAugEqMu;
  size_t dim_IP_DAugEqLambdaXL;
  size_t dim_IP_DAugEqLambdaXU;
  size_t dim_IP_DAugEqLambdaSL;
  size_t dim_IP_DAugEqLambdaSU;
  size_t dim_IP_DFeasX;
  size_t dim_IP_DFeasS;
  size_t dim_IP_DFeasMu;
  size_t dim_IP_DFeasLambdaXL;
  size_t dim_IP_DFeasLambdaXU;
  size_t dim_IP_DFeasLambdaSL;
  size_t dim_IP_DFeasLambdaSU;
  size_t dim_IP_DAdaptX;
  size_t dim_IP_DAdaptS;
  size_t dim_IP_DAdaptMu;
  size_t dim_IP_DAdaptLambdaXL;
  size_t dim_IP_DAdaptLambdaXU;
  size_t dim_IP_DAdaptLambdaSL;
  size_t dim_IP_DAdaptLambdaSU;
  size_t dim_IP_DCorrectX;
  size_t dim_IP_DCorrectS;
  size_t dim_IP_DCorrectMu;
  size_t dim_IP_DCorrectLambdaXL;
  size_t dim_IP_DCorrectLambdaXU;
  size_t dim_IP_DCorrectLambdaSL;
  size_t dim_IP_DCorrectLambdaSU;

 /* WORHP IP: search direction of X */
  double *IP_DStdX;

 /* WORHP IP: search direction of S */
  double *IP_DStdS;

 /* WORHP IP: search direction of Mu */
  double *IP_DStdMu;

 /* WORHP IP: search direction of LambdaXL */
  double *IP_DStdLambdaXL;

 /* WORHP IP: search direction of LambdaXU */
  double *IP_DStdLambdaXU;

 /* WORHP IP: search direction of LambdaSL */
  double *IP_DStdLambdaSL;

 /* WORHP IP: search direction of LambdaSU */
  double *IP_DStdLambdaSU;

 /* WORHP IP: search direction of X if updating augmented duals */
  double *IP_DAugEqX;

 /* WORHP IP: search direction of S if updating augmented duals */
  double *IP_DAugEqS;

 /* WORHP IP: search direction of Mu if updating augmented duals */
  double *IP_DAugEqMu;

 /* WORHP IP: search direction of LambdaXL if updating augmented duals */
  double *IP_DAugEqLambdaXL;

 /* WORHP IP: search direction of LambdaXU if updating augmented duals */
  double *IP_DAugEqLambdaXU;

 /* WORHP IP: search direction of LambdaSL if updating augmented duals */
  double *IP_DAugEqLambdaSL;

 /* WORHP IP: search direction of LambdaSU if updating augmented duals */
  double *IP_DAugEqLambdaSU;

 /* WORHP IP: search direction of X for feasibility problem */
  double *IP_DFeasX;

 /* WORHP IP: search direction of S for feasibility problem */
  double *IP_DFeasS;

 /* WORHP IP: search direction of Mu for feasibility problem */
  double *IP_DFeasMu;

 /* WORHP IP: search direction of LambdaXL for feasibility problem */
  double *IP_DFeasLambdaXL;

 /* WORHP IP: search direction of LambdaXU for feasibility problem */
  double *IP_DFeasLambdaXU;

 /* WORHP IP: search direction of LambdaSL for feasibility problem */
  double *IP_DFeasLambdaSL;

 /* WORHP IP: search direction of LambdaSU for feasibility problem */
  double *IP_DFeasLambdaSU;

 /* WORHP IP: search direction of X for adaptive update */
  double *IP_DAdaptX;

 /* WORHP IP: search direction of S for adaptive update */
  double *IP_DAdaptS;

 /* WORHP IP: search direction of Mu for adaptive update */
  double *IP_DAdaptMu;

 /* WORHP IP: search direction of LambdaXL for adaptive update */
  double *IP_DAdaptLambdaXL;

 /* WORHP IP: search direction of LambdaXU for adaptive update */
  double *IP_DAdaptLambdaXU;

 /* WORHP IP: search direction of LambdaSL for adaptive update */
  double *IP_DAdaptLambdaSL;

 /* WORHP IP: search direction of LambdaSU for adaptive update */
  double *IP_DAdaptLambdaSU;

 /* WORHP IP: search direction of X without corrections */
  double *IP_DCorrectX;

 /* WORHP IP: search direction of S without corrections */
  double *IP_DCorrectS;

 /* WORHP IP: search direction of Mu without corrections */
  double *IP_DCorrectMu;

 /* WORHP IP: search direction of LambdaXL without corrections */
  double *IP_DCorrectLambdaXL;

 /* WORHP IP: search direction of LambdaXU without corrections */
  double *IP_DCorrectLambdaXU;

 /* WORHP IP: search direction of LambdaSL without corrections */
  double *IP_DCorrectLambdaSL;

 /* WORHP IP: search direction of LambdaSU without corrections */
  double *IP_DCorrectLambdaSU;

 /* WORHP IP: descent direction for (scaled) problem (step std) */
  double IP_DescDStd;

 /* WORHP IP: descent direction for (scaled) problem (step feas) */
  double IP_DescDFeas;

 /* WORHP IP: descent direction for (scaled) problem (step adapt) */
  double IP_DescDAdapt;

 /* WORHP IP: descent direction for barrier problem (step std) */
  double IP_DescBarrDStd;

 /* WORHP IP: descent direction for barrier problem (step feas) */
  double IP_DescBarrDFeas;

 /* WORHP IP: descent direction for barrier problem (step adapt) */
  double IP_DescBarrDAdapt;

 /* WORHP IP: descent direction for barrier / penalty problem (step std) */
  double IP_DescBarrPenDStd;

 /* WORHP IP: descent direction for barrier / penalty problem (step feas) */
  double IP_DescBarrPenDFeas;

 /* WORHP IP: descent direction for barrier / penalty problem (step feas) */
  double IP_DescBarrPenDAdapt;

 /* WORHP IP: descent direction for feasibility problem (step std) */
  double IP_DescFeasDStd;

 /* WORHP IP: descent direction for feasibility problem (step feas) */
  double IP_DescFeasDFeas;

 /* WORHP IP: descent direction for feasibility problem (step adapt) */
  double IP_DescFeasDAdapt;

 /* WORHP IP: descent direction for barrier / penalty problem based on linear equation system block elimination (step std) */
  double IP_DescLeqDStd;
  size_t dim_IP_RhsX;
  size_t dim_IP_RhsS;
  size_t dim_IP_RhsMu;
  size_t dim_IP_RhsLambdaXL;
  size_t dim_IP_RhsLambdaXU;
  size_t dim_IP_RhsLambdaSL;
  size_t dim_IP_RhsLambdaSU;
  size_t dim_IP_RhsCorrectMu;

 /* WORHP IP: right-hand-side of X */
  double *IP_RhsX;

 /* WORHP IP: right-hand-side of S */
  double *IP_RhsS;

 /* WORHP IP: right-hand-side of Mu */
  double *IP_RhsMu;

 /* WORHP IP: right-hand-side of LambdaXL */
  double *IP_RhsLambdaXL;

 /* WORHP IP: right-hand-side of LambdaXU */
  double *IP_RhsLambdaXU;

 /* WORHP IP: right-hand-side of LambdaSL */
  double *IP_RhsLambdaSL;

 /* WORHP IP: right-hand-side of LambdaSU */
  double *IP_RhsLambdaSU;

 /* WORHP IP: right-hand-side of Mu (temporary storage, e.g. for second-order-corrections) */
  double *IP_RhsCorrectMu;
  size_t dim_IP_ResX;
  size_t dim_IP_ResS;
  size_t dim_IP_ResMu;
  size_t dim_IP_ResLambdaXL;
  size_t dim_IP_ResLambdaXU;
  size_t dim_IP_ResLambdaSL;
  size_t dim_IP_ResLambdaSU;

 /* WORHP IP: residual of X */
  double *IP_ResX;

 /* WORHP IP: residual of S */
  double *IP_ResS;

 /* WORHP IP: residual of Mu */
  double *IP_ResMu;

 /* WORHP IP: residual of LambdaXL */
  double *IP_ResLambdaXL;

 /* WORHP IP: residual of LambdaXU */
  double *IP_ResLambdaXU;

 /* WORHP IP: residual of LambdaSL */
  double *IP_ResLambdaSL;

 /* WORHP IP: residual of LambdaSU */
  double *IP_ResLambdaSU;
  size_t dim_IP_DLxFeas;
  size_t dim_IP_DLsFeas;

 /* WORHP IP: gradient of lagrangian of feasibility problem w.r.t. x */
  double *IP_DLxFeas;

 /* WORHP IP: gradient of lagrangian of feasibility problem w.r.t. x */
  double *IP_DLsFeas;
  size_t dim_IP_DGDX;

 /* WORHP IP: Result of the product DG * DX */
  double *IP_DGDX;
  size_t dim_IP_AugMu;

 /* WORHP IP: augmented lagrangian parameter for mu */
  double *IP_AugMu;
  size_t dim_IP_UnblockIdx;
  size_t dim_IP_UnblockAmount;

 /* WORHP IP: indices of optimization variable for unblocking */
  int *IP_UnblockIdx;

 /* WORHP IP: blocking value */
  int *IP_UnblockAmount;

 /* WORHP IP: number of variables to unblock */
  int IP_UnblockRate;

 /* WORHP IP: max number of variables to unblock */
  int IP_UnblockRateMax;

 /* WORHP IP: iteration counter for unblocking */
  counter IP_IterUnblock;

 /* WORHP IP: flag for evaluation of optimality of feasibility problem */
  bool IP_EvalOptiFeasApprox;

 /* WORHP IP: flag for evaluation of optimality of feasibility problem */
  bool IP_EvalOptiFeas;

 /* WORHP IP: flag for evaluation of feasibility complementarity */
  bool IP_EvalComplFeas;

 /* WORHP IP: flag for evaluation of barrier objective */
  bool IP_EvalObjBarr;

 /* WORHP IP: flag for evaluation of barrier / penalty objective */
  bool IP_EvalObjBarrPen;

 /* WORHP IP: flag for evaluation of barrier/penalty feasibility */
  bool IP_EvalFeasBarrPen;

 /* WORHP IP: flag for evaluation of barrier complementarity */
  bool IP_EvalComplBarr;

 /* WORHP IP: flag for evaluation of barrier complementarity */
  bool IP_EvalComplBarrInv;

 /* WORHP_IP: indicates if gradient of lagrangian of feasibility problem needs to be evaluated */
  bool IP_EvalGradLagrFeas;

 /* WORHP_IP: indicates if gradient of lagrangian needs to be evaluated (full space) */
  bool IP_EvalGradLagrFull;

 /* WORHP IP: flag for evaluation of descent of (scaled) problem (step std) */
  bool IP_EvalDescDStd;

 /* WORHP IP: flag for evaluation of descent of (scaled) problem (step feas) */
  bool IP_EvalDescDFeas;

 /* WORHP IP: flag for evaluation of descent of (scaled) problem (step adapt) */
  bool IP_EvalDescDAdapt;

 /* WORHP IP: flag for evaluation of descent of barrier problem (step std) */
  bool IP_EvalDescBarrDStd;

 /* WORHP IP: flag for evaluation of descent of barrier problem (step feas) */
  bool IP_EvalDescBarrDFeas;

 /* WORHP IP: flag for evaluation of descent of barrier problem (step adapt) */
  bool IP_EvalDescBarrDAdapt;

 /* WORHP IP: flag for evaluation of descent of barrier / penalty problem (step std) */
  bool IP_EvalDescBarrPenDStd;

 /* WORHP IP: flag for evaluation of descent of barrier / penalty problem (step feas) */
  bool IP_EvalDescBarrPenDFeas;

 /* WORHP IP: flag for evaluation of descent of barrier / penalty problem (step adapt) */
  bool IP_EvalDescBarrPenDAdapt;

 /* WORHP IP: flag for evaluation of descent of feasibility problem (step std) */
  bool IP_EvalDescFeasDStd;

 /* WORHP IP: flag for evaluation of descent of feasibility problem (step feas) */
  bool IP_EvalDescFeasDFeas;

 /* WORHP IP: flag for evaluation of descent of feasibility problem (step adapt) */
  bool IP_EvalDescFeasDAdapt;

 /* WORHP IP: flag for evaluation of stable descent for standard step */
  bool IP_EvalDescLeqDStd;

 /* WORHP IP: flag for evaluation of gradient of lagrangian of feasibility problem */
  bool IP_EvalDLFeas;

 /* WORHP IP: tolerance for the barrier subproblem. */
  double IP_TolBarr;

 /* WORHP IP: tolerance for the barrier / penalty subproblem. */
  double IP_TolBarrPen;

 /* WORHP IP: lowpass filter for original (scaled) problem */
  double IP_Lowpass;

 /* WORHP IP: lowpass filter for barrier problem */
  double IP_LowpassBarr;

 /* WORHP IP: lowpass filter for penalty problem */
  double IP_LowpassBarrPen;

 /* WORHP IP: flag to indicate if problem has been unmodified */
  bool IP_ModifiedOpt;

 /* WORHP IP: iteration counter for iterations after problem has been unmodified */
  counter IP_UnmodifiedIter;

 /* WORHP IP: iteration counter for how long the problem has been feasible */
  counter IP_IterFeasible;

 /* WORHP IP: filter for checking global convergence of adaptive mode */
  FilterNode *IP_AdaptFilter;
  size_t dim_IP_HistoryIterKkt;
  size_t dim_IP_HistoryIterFeas;
  size_t dim_IP_HistoryBarrPenOptKkt;

 /* WORHP IP: old kkt value of last iterations */
  double *IP_HistoryIterKkt;

 /* WORHP IP: old feasibility of last iterations */
  double *IP_HistoryIterFeas;

 /* WORHP IP: old KKT conditions of barrier / penalty problem of iterations in which it has been optimal */
  double *IP_HistoryBarrPenOptKkt;

 /* WORHP IP: flag if algorithm has been initialized */
  bool IP_Initialized;

 /* WORHP IP: mode of interior-point method. */
  int IP_Mode;

 /* WORHP IP: iterations of centering steps */
  counter IP_IterCentering;

 /* WORHP IP: general status of subroutines. */
  int IP_Status;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_RESTART. */
  int IP_StatusInitRestart;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_MODIFY. */
  int IP_StatusInitModify;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_PARAMETER. */
  int IP_StatusInitParameter;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_PREPARE. */
  int IP_StatusInitPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_ESTIMATE. */
  int IP_StatusInitEstimate;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_CENTERING. */
  int IP_StatusInitCentering;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_FINALIZE. */
  int IP_StatusInitFinalize;

 /* WORHP IP: status of stage WORHP_STAGE_IP_INIT_MODE. */
  int IP_StatusInitMode;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_PREPARE. */
  int IP_StatusCheckPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_ADAPT. */
  int IP_StatusCheckAdapt;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK. */
  int IP_StatusCheck;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_INFEAS. */
  int IP_StatusCheckInfeas;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_BARRIER. */
  int IP_StatusCheckBarrier;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CHECK_PENALTY. */
  int IP_StatusCheckPenalty;

 /* WORHP IP: status of stage WORHP_STAGE_IP_UPDATE_BARRIER. */
  int IP_StatusUpdateBarrier;

 /* WORHP IP: status of stage WORHP_STAGE_IP_UPDATE_PENALTY. */
  int IP_StatusUpdatePenalty;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LEQ_PREPARE. */
  int IP_StatusLeqPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LEQ_CREATE. */
  int IP_StatusLeqCreate;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LEQ_REGULARIZE. */
  int IP_StatusLeqRegularize;

 /* WORHP IP: status of stage WORHP_STAGE_IP_STEP_PREPARE. */
  int IP_StatusStepPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_STEP_SELECT. */
  int IP_StatusStepSelect;

 /* WORHP IP: status of stage WORHP_STAGE_IP_ADAPT_BARRIER. */
  int IP_StatusAdaptBarrier;

 /* WORHP IP: status of stage WORHP_STAGE_IP_ADAPT_PENALTY. */
  int IP_StatusAdaptPenalty;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_PREPARE. */
  int IP_StatusLinePrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_UPDATE. */
  int IP_StatusLineUpdate;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_CHECK. */
  int IP_StatusLineCheck;

 /* WORHP IP: status of stage WORHP_STAGE_IP_LINE_REDUCE. */
  int IP_StatusLineReduce;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CORRECT_PREPARE. */
  int IP_StatusCorrectPrepare;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CORRECT_STEP. */
  int IP_StatusCorrectStep;

 /* WORHP IP: status of stage WORHP_STAGE_IP_CORRECT_ABORT. */
  int IP_StatusCorrectAbort;

 /* WORHP IP: status of stage WORHP_STAGE_IP_UNBLOCK. */
  int IP_StatusUnblock;

 /* WORHP IP: status of stage WORHP_STAGE_IP_FINALIZE. */
  int IP_StatusFinalize;

 /* WORHP Line: current primal stepsize */
  double Line_AlphaX;

 /* WORHP Line: primal stepsize before second-order-correction */
  double Line_Alpha0X;

 /* WORHP Line: primal step size of last iteration */
  double Line_AlphaOldX;

 /* WORHP Line: maximum primal stepsize */
  double Line_AlphaMaxX;

 /* WORHP Line: current lambda stepsize */
  double Line_AlphaLambda;

 /* WORHP Line: lambda stepsize before second-order-correction */
  double Line_Alpha0Lambda;

 /* WORHP Line: lambda step size of last iteration */
  double Line_AlphaOldLambda;

 /* WORHP Line: maximum lambda stepsize */
  double Line_AlphaMaxLambda;

 /* WORHP Line: current mu stepsize */
  double Line_AlphaMu;

 /* WORHP Line: mu stepsize before second-order-correction */
  double Line_Alpha0Mu;

 /* WORHP Line: mu step size of last iteration */
  double Line_AlphaOldMu;

 /* WORHP Line: maximum mu stepsize */
  double Line_AlphaMaxMu;

 /* WORHP Line: maximal step size */
  double Line_AlphaMax;

 /* WORHP Line: minimal step size */
  double Line_AlphaMin;

 /* WORHP Line: indicates if full step can be taken (all max alpha are one) */
  bool Line_AlphaMaxFull;

 /* WORHP Line: global filter */
  FilterNode *Line_FilterGlobal;

 /* WORHP Line: local filter */
  FilterNode *Line_FilterLocal;

 /* WORHP Line: CV threshold for switching condition */
  double Line_FilterCVmin;

 /* WORHP Line: filter criteria objective */
  double Line_FilterObj;

 /* WORHP Line: filter criteria feasibility */
  double Line_FilterFeas;

 /* WORHP Line: descent for filter obejctive */
  double Line_FilterDesc;

 /* WORHP Line: filter criteria objective without step */
  double Line_FilterObj0;

 /* WORHP Line: filter criteria feasibility without step */
  double Line_FilterFeas0;

 /* WORHP Line: filter criteria feasibility at the beginning of the optimization */
  double Line_FilterFeasInit;

 /* WORHP Line: envelope of obj dimension in filter */
  double Line_FilterEnvObj;

 /* WORHP Line: envelope of feas dimension in filter */
  double Line_FilterEnvFeas;

 /* WORHP Line: envelope basis (e.g. constraint violation) */
  double Line_FilterEnvBase;

 /* WORHP Line: merit function value. */
  double Line_Merit;

 /* WORHP Line: descent for merit function */
  double Line_MeritDesc;

 /* WORHP Line: merit function value without step. */
  double Line_Merit0;

 /* WORHP Line: merit function of last step. */
  double Line_MeritOld;
  size_t dim_Line_MeritHistory;

 /* WORHP Line: historic data for nonmonotone merit line search */
  double *Line_MeritHistory;

 /* WORHP LINE: iteration counter of line search */
  counter Line_Iter;

 /* WORHP LINE: iteration counter of second order corrections */
  counter Line_IterCorrect;

 /* WORHP LINE: status after evaluation of Line stage. */
  int Line_Status;

 /* WORHP LINE: current phase of line search (local/global) */
  int Line_Phase;

 /* WORHP LINE: indicator if non-monotone mode is activated */
  bool Line_Nonmon;

 /* WORHP LINE: method that accepted the step */
  int Line_AcceptMethod;

 /* WORHP LINE: phase that accepted the step */
  int Line_AcceptPhase;

 /* WORHP Line: indicator if line search should work in constrained mode */
  bool Line_Constrained;

 /* WORHP Line: number of different methods to choose */
  int Line_MethodNum;
  size_t dim_Line_MethodInitStep;
  size_t dim_Line_MethodCheck;

 /* WORHP LINE: selects method (filter, merit function...) */
  int *Line_MethodInitStep;

 /* WORHP LINE: selects method (filter, merit function...) */
  int *Line_MethodCheck;

 /* WORHP LINE: selects method (filter, merit function...) */
  int Line_MethodReduce;

 /* WORHP LINE: flag for needed update of primal variables */
  bool Line_UpdatePrimal;

 /* WORHP LINE: flag for needed update of dual variables */
  bool Line_UpdateDual;

 /* WORHP LINE: number of non monotone level of merit approach */
  int Line_MeritNonmon;

 /* WORHP LINE: number of non monotone level of filter approach */
  int Line_FilterNonmon;

 /* WORHP LINE: enables step size interpolation. */
  bool Line_Interp;

 /* WORHP LINE: min decrease in relation to old step size */
  double Line_InterpMin;

 /* WORHP LINE: max decrease in relation to old step size */
  double Line_InterpMax;

 /* WORHP LINE: armijo beta for step size reduction. */
  double Line_ArmijoBeta;

 /* WORHP LINE: reduction factor for armijo condition. */
  double Line_ArmijoEta;

 /* WORHP LINE: filter objective decrease factor */
  double Line_FilterGammaObj;

 /* WORHP LINE: filter constraint violation decrease factor */
  double Line_FilterGammaFeas;

 /* Derivative DG_P for post analysis */
  WorhpMatrix ZenDGp;

 /* Derivative DL_XP (Lagrangian) for post analysis */
  WorhpMatrix ZenDLxp;

 /* Derivative DL_P (Lagrangian) for post analysis */
  WorhpMatrix ZenDLp;

 /* Derivative DL_PP (Lagrangian) for post analysis */
  WorhpMatrix ZenDLpp;

 /* Sensitivity derivatives dx/dp, d^2f/(dr*dq). */
  WorhpMatrix ZenDx_pDf2_rp;

 /* Sensitivity derivatives dx/dr, d^2f/dr^2. Symmetric. */
  WorhpMatrix ZenDx_rDf2_rr;

 /* Sensitivity derivative dx/dq, (dmu/dr)^T, d^2f/(dr*dq). */
  WorhpMatrix ZenDx_qDm_rDf2_rq;

 /* Sensitivity derivative dmu/dp, d^2f/(dq*dp). */
  WorhpMatrix ZenDm_pDf2_qp;

 /* Sensitivity derivative dmu/dq, df^2/dq^2. Symmetric. */
  WorhpMatrix ZenDm_qDf2_qq;

 /* Sensitivity derivative dlambda/dp, d^2f/(db*dp). */
  WorhpMatrix ZenDl_pDf2_bp;

 /* Sensitivity derivative (dx/db)^T, dlambda/dr, d^2f/(db*dr). */
  WorhpMatrix ZenDl_rDx_bDf2_br;

 /* Sensitivity derivative (dmu/db)^T, dlambda/dq, d^2f/(db*dq). */
  WorhpMatrix ZenDl_qDm_bDf2_bq;

 /* Sensitivity derivative dlambda/db, d^2f/db^2. Symmetric. */
  WorhpMatrix ZenDl_bDf2_bb;

 /* Sensitivity derivative df/dp. Vector. */
  WorhpMatrix ZenDf_p;

 /* Sensitivity derivative d^2f/dp^2. Symmetric. */
  WorhpMatrix ZenDf2_pp;

 /* Sensitivity derivative dg/dp. */
  WorhpMatrix ZenDg_p;

 /* Sensitivity derivative dg/dr. */
  WorhpMatrix ZenDg_r;

 /* Sensitivity derivative dg/dq. */
  WorhpMatrix ZenDg_q;

 /* Sensitivity derivative dg/db. */
  WorhpMatrix ZenDg_b;
  size_t dim_ZenDX;
  size_t dim_ZenDM;
  size_t dim_ZenDL;
  size_t dim_ZenDG;
  size_t dim_ZenDF;
  size_t dim_ZenDF2;

 /* sensitivity of x */
  double *ZenDX;

 /* sensitivity of mu */
  double *ZenDM;

 /* sensitivity of lambda */
  double *ZenDL;

 /* sensitivity of g */
  double *ZenDG;

 /* sensitivity of f */
  double *ZenDF;

 /* sensitivity of f */
  double *ZenDF2;
  size_t dim_ZenStatus;
  size_t dim_ZenStatus2;

 /* Calculation status of sensitivity derivatives of x */
  bool *ZenStatusDX;

 /* Calculation status of sensitivity derivatives of mu */
  bool *ZenStatusDM;

 /* Calculation status of sensitivity derivatives of lambda */
  bool *ZenStatusDL;

 /* Calculation status of sensitivity derivatives of f */
  bool *ZenStatusDF;

 /* Calculation status of sensitivity derivatives of f */
  bool *ZenStatusDF2;

 /* Calculation status of sensitivity derivatives of g */
  bool *ZenStatusDG;

 /*------------------------------------------------
  *  Filter nodes
  *------------------------------------------------ */
  FilterNode *FirstFilterNode;

 /*------------------------------------------------
  *  QP Workspace
  *------------------------------------------------ */
  QPWorkspace qp;

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker01;

 /*------------------------------------------------
  *  Matrices
  *------------------------------------------------ */
  WorhpMatrix DF;
  WorhpMatrix DG;
  WorhpMatrix DL;
  WorhpMatrix oldDL;
  WorhpMatrix HM;
  WorhpMatrix HM_bfgs;
  WorhpMatrix ID;
  WorhpMatrix Q;
  WorhpMatrix A;
  WorhpMatrix C;

 /* Incidence matrix for group algorithms */
  WorhpMatrix Inc;

 /* RHS for calculation of sensitivity for correction step. */
  WorhpMatrix Bstep_RHS;

 /* Sensitivity derivative for correction step dmu/dq. */
  WorhpMatrix Bstep_dmudq;

 /* Perturbation for sensitivity analysis in correction step. */
  WorhpMatrix BstepPerturbG;

 /* Search direction in correction step. */
  WorhpMatrix BstepDx;

 /* Search direction for lagrangian multipliers in correction step. */
  WorhpMatrix BstepDMu;

 /* Saves final lagrange multiplier for lower box constraints. */
  WorhpMatrix BstepInitialZL;

 /* Saves final lagrange multiplier for upper box constraints. */
  WorhpMatrix BstepInitialZU;

 /* Saves the last 2 iterates of the primal variables to perform a Steffensen Extrapolation step. */
  WorhpMatrix BstepSteffensenOldIterates;

 /* Saves the last 2 iterates of the dual variables (box constraints) to perform a Steffensen Extrapolation step. */
  WorhpMatrix BstepSteffensenOldLambdas;

 /* Saves the last 2 iterates of the dual variables (general constraints) to perform a Steffensen Extrapolation step. */
  WorhpMatrix BstepSteffensenOldMus;

 /* FIFO for F values */
  WorhpQueue QueueF;

 /* FIFO for constraint violations */
  WorhpQueue QueueCV;

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker02;

 /*------------------------------------------------
  *  Reals
  *------------------------------------------------ */

 /* = |dT*H*d|                           [SCAL] */
  double Abs_Curvature;

 /* CV value of best-so-far acceptable solution */
  double AcceptCV;

 /* F value of best-so-far acceptable solution */
  double AcceptF;

 /* Scaled value of optimality of best-so-far acceptable solution */
  double AcceptOptiMax;

 /* Unscaled value of optimality of best-so-far acceptable solution */
  double AcceptOptiOrigMax;

 /* Scaled complementarity value of best-so-far acceptable solution */
  double AcceptComplMax;

 /* Unscaled complementarity value of best-so-far acceptable solution */
  double AcceptComplOrigMax;

 /* ScaleObj value of best-so-far acceptable solution */
  double AcceptScaleObj;

 /* Armijo stepsize                      [ALPHA] */
  double ArmijoAlpha;

 /* Betts-update parameter               [ACTUAL] */
  double BettsActual;

 /* Betts-update parameter               [OLDRHO] */
  double BettsOldRho;

 /* Betts-update parameter               [PRDTED] */
  double BettsPredicted;

 /* Used for calculating the Bettsupdate */
  double BettsRho;

 /* Betts-update parameter */
  double BettsSigma;

 /* Sum of Betts-update parameter for AutoQPRecovery */
  double BettsSumTau;

 /* Betts-update parameter               [TAU] */
  double BettsTau;

 /* Betts-update: Value added to HM diag */
  double BettsValue;

 /* Maximum constraint violation at uncorrected next iterate */
  double BstepOldMaxCV;

 /* Value of old Lagrangian function as watch dog for bstep progress */
  double BstepOldLagrangianValue;

 /* Norm of difference between last 2 iterates during Feasibility Refinement */
  double BstepOldIterDiff;

 /* Value of penalty for merit function within BStep */
  double BstepMeritPenalty;

 /* = dT*H*d */
  double Curvature;

 /* df^T*d */
  double Descent;

 /* RC value F0 */
  double F0;

 /* 2-Norm of the vector of inactive constraint violations */
  double InActiveNormG;

 /* Lowpass filter value for F */
  double LowPassF;

 /* Lowpass filter value for G */
  double LowPassG;

 /* Lowpass filter value for the merit function */
  double LowPassMerit;

 /* Derivative of merit function         [FAC] */
  double MeritGradient;

 /* New value of merit function        [VAXLK] */
  double MeritNewValue;

 /* Old value of merit function        [VAL] */
  double MeritOldValue;

 /* 2-norm of QP search direction        [NRMDX] */
  double Norm2_DX;

 /* Max-norm of Constraints Violation    [NRMNB] */
  double NormMax_CV;

 /* Max-norm of Gradient of Lagrangian   [NRMGRD] */
  double NormMax_DL;

 /* old value of F */
  double oldF;

 /* old 2-norm of QP search direction */
  double oldNorm2_DX;

 /* old NormMax value of G */
  double oldNormMaxG;

 /* penalty parameter update             [DELTAK] */
  double PenUpdDeltaK;

 /* penalty parameter update             [R] */
  double PenUpdR;

 /* PostQP-Sensitivity, Suggestion for new value */
  double qppsa_HMReg;

 /* sge: Save value of original IpComTol parameter */
  double SaveIpComTol;

 /* sge: Save value of original IpResTol parameter */
  double SaveIpResTol;

 /* sge: Save value of original LsTol parameter */
  double SaveLsTol;

 /* sge: Maximum violation of optimality criterion */
  double OptiMax;

 /* 2-norm of optimality criterion */
  double Opti2;

 /* Maximum violation of constraint violation */
  double FeasMax;

 /* 2-norm of constraint violation */
  double Feas2;

 /* sge: Maximum violation of complementarity criterion */
  double ComplMax;

 /* 2-norm of complementarity criterion */
  double Compl2;

 /* sge: Maximum violation of optimality criterion (unscaled) */
  double OptiOrigMax;

 /* Maximum violation of constraint violation (unscaled) */
  double FeasOrigMax;

 /* sge: Maximum violation of complementarity criterion (unscaled) */
  double ComplOrigMax;

 /* Scaling for the objective function */
  double ScaleObj;

 /* Scaling for the objective function for the QP */
  double ScaleObjQP;

 /* Minimal trial stepsize. */
  double Alpha_Min;

 /* Betts-update parameter. */
  double CVActual;

 /* Derivative of constraint violation. */
  double CVGradient;

 /* Betts-update parameter. */
  double CVPredicted;

 /* Maximal CV for the initialization of the filter. */
  double CV_Max;

 /* If CV < CV_Min check the the switching condition. */
  double CV_Min;

 /* Betts-update parameter. */
  double FActual;

 /* Constraint violation value of the filter entry which dominates the trial iterate. */
  double FilterDominatingCV;

 /* Objective function value of the filter entry which dominates the trial iterate. */
  double FilterDominatingF;

 /* Constraint violation value at the intersection of the filter envelope with the line that connects the previous iterate with the current trial iterate. */
  double FilterIntersectionCV;

 /* Betts-update parameter. */
  double FPredicted;

 /* Original df^T*d for accelerating heuristic (ignore criteria). */
  double olddescent;

 /* Betts-update parameter. */
  double PrevBettsTau;

 /* Initial value of the objective function. */
  double StartF;

 /* Machine epsilon */
  double eps;

 /*------------------------------------------------
  *  Variable size arrays
  *------------------------------------------------ */
  size_t dim_hm_fidif;
  size_t dim_adaptiveRelax;
  size_t dim_BStepFeasActiveSet;
  size_t dim_idxXeq;
  size_t dim_idxXneq;
  size_t dim_idxXneqInv;
  size_t dim_idxXieq;
  size_t dim_idxXieqLow;
  size_t dim_idxXieqUp;
  size_t dim_idxGeq;
  size_t dim_idxGieq;
  size_t dim_idxGieqLow;
  size_t dim_idxGieqUp;
  size_t dim_idxDGGeq;
  size_t dim_idxDGGieq;
  size_t dim_idxDGGieqLow;
  size_t dim_idxDGGieqUp;
  size_t dim_idxDGGieqLowUp;

 /* values vector for finite differences sparse Hessian */
  double *hm_fidif;

 /* sge: Save correspondence between relaxation variables and constraints */
  int *adaptiveRelax;

 /* Vector of activity indicators for feasibility refinementq */
  int *BStepFeasActiveSet;

 /* index map for equality box constraints */
  int *idxXeq;

 /* index map for non-equality box constraints */
  int *idxXneq;

 /* index map like idxXneq but other way round */
  int *idxXneqInv;

 /* index map for inequality box constraints */
  int *idxXieq;

 /* index map for lower inequality box constraints */
  int *idxXieqLow;

 /* index map for upper inequality box constraints */
  int *idxXieqUp;

 /* index map for equality constraints */
  int *idxGeq;

 /* index map for inequality constraints */
  int *idxGieq;

 /* index map for lower inequality constraints */
  int *idxGieqLow;

 /* index map for upper inequality constraints */
  int *idxGieqUp;

 /* sge: index map for DG only equality constraints */
  int *idxDGGeq;

 /* sge: index map for DG only inequality constraints */
  int *idxDGGieq;

 /* sge: index map for DG only inequality constraints with lower bound */
  int *idxDGGieqLow;

 /* sge: index map for DG only inequality constraints with upper bound */
  int *idxDGGieqUp;

 /* sge: index map for DG inequality constraints with upper and lower bound */
  int *idxDGGieqLowUp;
  size_t dim_bstepSaveRHS;
  size_t dim_dfdense;
  size_t dim_relaxDelta;
  size_t dim_penalty;
  size_t dim_qpIdxMap;
  size_t dim_qpIdxMapInvA;
  size_t dim_qpIdxMapInvC;
  size_t dim_qpeqrhs;
  size_t dim_qpierhs;
  size_t dim_qpdx;
  size_t dim_qpdx_reg;
  size_t dim_qpdx_relax;
  size_t dim_qpdx_backup;
  size_t dim_qpeqlm;
  size_t dim_qpeqlm_reg;
  size_t dim_qpeqlm_relax;
  size_t dim_qpeqlm_backup;
  size_t dim_qpielm;
  size_t dim_qpielm_reg;
  size_t dim_qpielm_relax;
  size_t dim_qpielm_backup;
  size_t dim_QPPSA_relaxPen;
  size_t dim_fidif_ddg;
  size_t dim_fidif_DF_CRrow;
  size_t dim_fidif_nPairgroups;
  size_t dim_fidif_Pairgroups;
  size_t dim_fidif_Relentries;
  size_t dim_fidif_Relvars;
  size_t dim_fidif_savex;
  size_t dim_fidif_saveDF;
  size_t dim_fidif_saveDG;
  size_t dim_fidif_saveG0;
  size_t dim_fidif_last_indices;
  size_t dim_newEntriesX;
  size_t dim_saved_userDF;
  size_t dim_saved_userDG;
  size_t dim_saved_userHM;
  size_t dim_SBFGS_blockval;
  size_t dim_SBFGS_blockcsc;
  size_t dim_SBFGS_blockcol;
  size_t dim_SBFGS_blocksize;
  size_t dim_SBFGS_blockstart;
  size_t dim_SBFGS_inblock;
  size_t dim_SBFGS_idxinblock;

 /* Save bstepRHS before realtime update strategy */
  double *bstepSaveRHS;

 /* values of dense objective gradient for QP */
  double *dfdense;

 /* Penalty (ies) for merit function */
  double *penalty;

 /* Relaxation variables for constraints */
  double *relaxDelta;

 /* Mapping from NLP constraints (m) to QP constraints (>= m). Equality constraints are at position nXeq + qpIdxMap(i) within A. Inequality constraints at position qpIdxMap(i) in C. */
  int *qpIdxMap;

 /* Mapping from QP equality constraints (1:ADIM) to NLP constraints (m). (Inv = Inverse) */
  int *qpIdxMapInvA;

 /* Mapping from QP inequality constraints (1:CDIM) to NLP constraints (m). (Inv = Inverse) */
  int *qpIdxMapInvC;

 /* RHS of equalities for QP */
  double *qpeqrhs;

 /* RHS of inequalities for QP */
  double *qpierhs;

 /* Search direction from QP */
  double *qpdx;

 /* sge: Search direction from QP enhanced with sensitivities due to hessian regularisation */
  double *qpdx_reg;

 /* sge: Search direction from QP enhanced with sensitivities due to constraint relaxation */
  double *qpdx_relax;

 /* sge: Original search direction before sensitivity enhanced QP */
  double *qpdx_backup;

 /* LMs of equalities from QP */
  double *qpeqlm;

 /* sge: Updated LMs of equalities from QP with post QP PSA for regularisation */
  double *qpeqlm_reg;

 /* sge: Updated LMs of equalities from QP with post QP PSA for relaxation */
  double *qpeqlm_relax;

 /* sge: Backup of LMs of equalities from QP because of post QP PSA */
  double *qpeqlm_backup;

 /* LMs of inequalities from QP */
  double *qpielm;

 /* sge: Updated LMs of inequalities from QP with post QP PSA for regularisation */
  double *qpielm_reg;

 /* sge: Updated LMs of inequalities from QP with post QP PSA for relaxation */
  double *qpielm_relax;

 /* sge: Updated LMs of inequalities from QP because of post QP PSA */
  double *qpielm_backup;

 /* sge: Vector or Scalar value (depending on par.MoreRelax) to update relaxation penalty using PSA. */
  double *QPPSA_relaxPen;

 /* structure of Hessian without f */
  int *fidif_ddg;

 /* mja: Indices of rowstarts in DFval for fast access in fidif */
  int *fidif_DF_CRrow;

 /* vector of number of pairgroups */
  int *fidif_nPairgroups;

 /* vector of pairgroups memberships     [hm%nnz] */
  int *fidif_Pairgroups;

 /* vector of relevant entries for hessiangroup creation [opt%m] */
  int *fidif_Relentries;

 /* vector of relevant variables for hessiangroup creation [opt%n] */
  int *fidif_Relvars;

 /* mja: Vector to save old x to restore after perturbation in fidif */
  double *fidif_savex;

 /* mja: Vector to save DF(x0) for fidif */
  double *fidif_saveDF;

 /* mja: Vector to save DG(x0) for fidif */
  double *fidif_saveDG;

 /* mja: Vector to save G(x0) for fidif */
  double *fidif_saveG0;

 /* mja: Vector to store the indices that were last perturbed in fidif and will therefore be reset. */
  int *fidif_last_indices;

 /* mja: Vector that tells the user which entries of x have been changed */
  bool *newEntriesX;

 /* mja: Storage for the DF value provided by the user for comparison with DF from fidif */
  double *saved_userDF;

 /* mja: Storage for the DG value provided by the user for comparison with DG from fidif */
  double *saved_userDG;

 /* mja: Storage for the HM value provided by the user for comparison with HM from fidif */
  double *saved_userHM;

 /* values of SBFGS blocks */
  double *SBFGS_blockval;

 /* CS column vector for SBFGS */
  int *SBFGS_blockcsc;

 /* CC column vector for SBFGS */
  int *SBFGS_blockcol;

 /* size of SBFGS blocks */
  int *SBFGS_blocksize;

 /* vector of first columns for SBFGS */
  int *SBFGS_blockstart;

 /* index vector for SBFGS */
  int *SBFGS_inblock;

 /* index vector for SBFGS */
  int *SBFGS_idxinblock;
  size_t dim_NactiveGc;
  size_t dim_NactiveXc;

 /* cumulated number of active constraints */
  int *NactiveGc;

 /* cumulated number of active box constraints */
  int *NactiveXc;

 /*------------------------------------------------
  *  Workspace stuff
  *------------------------------------------------ */
  size_t niws;
  size_t nrws;
  int *iws;
  double *rws;
  size_t IWMT[WMTrows][WMTslices];
  size_t RWMT[WMTrows][WMTslices];
  char IWMTnames[WMTnames][WMTslices];
  char RWMTnames[WMTnames][WMTslices];

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker03;

 /*------------------------------------------------
  *  WMT indices
  *------------------------------------------------ */

 /* Values of LAMBDA of the last acceptable solution */
  rwmt_index acceptlambda;

 /* Values of Mu of the last acceptable solution */
  rwmt_index acceptmu;

 /* Values of X of the last acceptable solution */
  rwmt_index acceptx;

 /* Active Set flags for G */
  iwmt_index activeSetG;

 /* Index of the QP inequality constraints LM in the general problem */
  iwmt_index activeSetGM;

 /* Index of the QP equality constraints LM in the general problem */
  iwmt_index activeSetGMeq;

 /* Index of the QP inequality constraints LM for qp warmstart */
  iwmt_index activeSetGMwarm;

 /* Active Set flags for X */
  iwmt_index activeSetX;

 /* Active Set flags for X */
  iwmt_index activeSetXUpDown;

 /* for realsparse BFGS */
  iwmt_index degree;

 /* Hessian (symmetric) permutation vector */
  iwmt_index hperm;

 /* Hessian inverse (symmetric) permutation vector */
  iwmt_index hperminv;

 /* Inactive Set indicies for G */
  iwmt_index InActiveSetG;

 /* Used for building the box constraints */
  iwmt_index IXLtemp;

 /* Used for building the box constraints */
  iwmt_index IXUtemp;

 /* New Box LMs                          [LQLAM] */
  rwmt_index newlambda;

 /* New Non-box LMs                      [LQLAM] */
  rwmt_index newmu;

 /* Original LAMBDA for Armijo */
  rwmt_index oldlambda;

 /* Original MU for Armijo */
  rwmt_index oldmu;

 /* Original X for Armijo */
  rwmt_index oldx;

 /* LMs for penalty parameter update     [LPPADD] */
  rwmt_index penmu;

 /* sge: Counter for feasibility refinement iterations */
  counter RefineFeasIter;

 /* mja: Counter for overall feasibility refinement iterations of all major iterations. */
  counter RefineFeasIterOverall;

 /* constraint relaxation penaltys       [RDELTA] */
  rwmt_index RelaxPen;

 /* temporary constraint relaxation penaltys */
  rwmt_index RelaxPenTemp;

 /* Vector of scaling factors for the eq. constraints */
  rwmt_index scalecona;

 /* Vector of scaling factors for the ie. constraints */
  rwmt_index scaleconc;

 /* Vector of scaling factors for the eq. constraints */
  rwmt_index scaleconaWAS;

 /* Vector of scaling factors for the ie. constraints */
  rwmt_index scaleconcWAS;

 /* Original G for Armijo */
  rwmt_index oldg;

 /* Original qpdx for accelerating heuristic (ignore criteria). */
  rwmt_index oldqpdx;

 /* WARMSALL for QP warmstart */
  rwmt_index WARMSALL;

 /* WARMSLALL for QP warmstart */
  rwmt_index WARMSLALL;

 /* WARMSUALL for QP warmstart */
  rwmt_index WARMSUALL;

 /* WARMSALL for QP warmstart */
  rwmt_index WARMZALL;

 /* WARMSLALL for QP warmstart */
  rwmt_index WARMZLALL;

 /* WARMSUALL for QP warmstart */
  rwmt_index WARMZUALL;

 /* Used for building the box constraints */
  rwmt_index XLtemp;

 /* Used for building the box constraints */
  rwmt_index XUtemp;

 /*------------------------------------------------
  *  Counters
  *------------------------------------------------ */

 /* MajorIter corresponding to AcceptMerit */
  counter AcceptMajorIter;

 /* Counter: WORHP calls */
  counter Calls;

 /* Iteration counter for force steps */
  counter ForceIter;

 /* Counter: major (= SQP) iterations */
  counter MajorIter;

 /* Counter: minor (= QP) iterations */
  counter MinorIter;

 /* Counter: overall minor (= QP) iterations of all major iterations. */
  counter MinorIterOverall;

 /* Next Armijo recovery strategy to be used */
  counter NextAres;

 /* Counter for loops with Reverse Communication */
  counter RCCounter;

 /* Counter for loops with Reverse Communication */
  counter RCCounter2;

 /* Counter for loops with Reverse Communication */
  counter RCCounter3;

 /* Counter for loops with Reverse Communication */
  counter RCCounter4;

 /* Counter: Check whether accelerating heuristics would help. */
  counter LScounter;

 /* mja: Counter for current column in HM while using fidif for HM */
  counter fidif_hm_col;

 /* mja: Counter for current HMval index while using fidif for HMval */
  counter fidif_hm_counter;

 /* mja: Counter for current f-part of HMval index while using fidif for HMval */
  counter fidif_hm_counter_f;

 /* mja: Counter for current g-part of HMval index while using fidif for HMval */
  counter fidif_hm_counter_g;

 /* mja: Counter for current DFval index while using fidif for DFval */
  counter fidif_df_counter;

 /* mja: Counter for current DGval index while using fidif for DGval */
  counter fidif_dg_counter;

 /* mja: Counter for number of calls to WorhpFidif for output */
  counter fidif_calls;

 /*------------------------------------------------
  *  Dimensions and element counts
  *------------------------------------------------ */
  int blocknnz;
  int boxLDIM;
  int boxUDIM;

 /* Currently active feasibility mode */
  int CurrentFeasMode;

 /* Number of active general constraints */
  int NactiveG;

 /* Number of active NLP constraints */
  int NactiveGNLP;
  int nbcol;
  int nblock;
  int num_fidif_last_indices;

 /* number of box equality constraints (same naming as index maps) */
  int nXeq;

 /* number of non box equality constraints (same naming as index maps) */
  int nXneq;

 /* number of box inequality constraints (same naming as index maps) */
  int nXieq;

 /* number of box inequality constraints within QP (constraints with lower and upper bound counted twice) */
  int nXieqQP;

 /* number of box inequality constraints with lower bound only (same naming as index maps) */
  int nXieqLow;

 /* number of box inequality constraints with upper bound only (same naming as index maps) */
  int nXieqUp;

 /* number of box inequality constraints with lower and upper bound (same naming as index maps) */
  int nXieqLowUp;

 /* number of general equality constraints (same naming as index maps) */
  int nGeq;

 /* number of general inequality constraints (same naming as index maps) */
  int nGieq;

 /* number of box inequality constraints within QP (constraints with lower and upper bound counted twice) */
  int nGieqQP;

 /* number of general inequality constraints with lower bound only (same naming as index maps) */
  int nGieqLow;

 /* number of general inequality constraints with upper bound only (same naming as index maps) */
  int nGieqUp;

 /* number of general inequality constraints with lower and upper bound (same naming as index maps) */
  int nGieqLowUp;

 /* number of non-zeros of DG that do belong to general equality constraints. */
  int nnzDGGeq;

 /* number of non-zeros of DG that do belong to general inequality constraints. */
  int nnzDGGieq;

 /* number of non-zeros of DG that do belong to general inequality constraints with only lower bound. */
  int nnzDGGieqLow;

 /* number of non-zeros of DG that do belong to general inequality constraints with only upper bound */
  int nnzDGGieqUp;

 /* number of non-zeros of DG that do belong to general inequality constraints with upper and lower bound */
  int nnzDGGieqLowUp;

 /* Number of variables for QP */
  int nQP;

 /* Stage that is currently being processed in the main 'Worhp' function. Used for proper output in StageMsg. */
  int ProcessedStage;

 /* Number of constraint relaxation variables */
  int RelaxNvar;

 /* Maximum Number of Filter Entries */
  int nFilterEntries;

 /* mja: Number of positive eigenvalues of KKT-matrix in last factorization. */
  int KKTInertiaPosEV;

 /* mjaP: Number of negative eigenvalues of KKT-matrix in last factorization. */
  int KKTInertiaNegEV;

 /* mja: Number of zero eigenvalues of KKT-matrix in last factorization. */
  int KKTInertiaZeroEV;

 /* sge: Minor iteration count of last major iteration. */
  int SaveOldMinorIterCount;

 /* sge: Currently active switch mode. */
  int SwitchModeActiveKind;

 /* mja: Iteration in which sKKT were met for functionality of parameter sKKTOnlyAcceptable */
  int TerminationMetSKKTiter;

 /* iteration at which last crossover has been applied. */
  int CrossoverIter;

 /*------------------------------------------------
  *  Logicals
  *------------------------------------------------ */

 /* Current point feasible to acceptable tol.? */
  bool AcceptFeasible;

 /* Current point optimal to acceptable tol.? */
  bool AcceptOptimal;

 /* Found an acceptable solution? */
  bool AcceptSolFound;

 /* mja: Indicates whether the best so far acceptable solution was chosen because F was found to be constant */
  bool AcceptTerminationByConstantF;

 /* Automatic QP Recovery Active? */
  bool AutoQPRecActive;

 /* Do Betts' update */
  bool BettsUpdate;

 /* Complementarity conditions satisfied? */
  bool Complementary;

 /* Problem has constraints on G  <=>  M > 0 */
  bool Constrained;

 /* sge - Flag to signalise BuildBoxConstraints it is called the first time */
  bool BstepFeasFirstTimeBuildBox;

 /* sge - Correction step declined due to merit function. No new DF DG required. */
  bool BstepFeasMeritFail;

 /* sge - Correction step due to perturbed constraints is active */
  bool BstepFeasActive;

 /* sge - Abort correction step due to bad contraction factor */
  bool BstepFeasAbortFactor;

 /* sge - Flag showing that correction via feasibility finished */
  bool BstepFeasFinished;

 /* sge - Correction step was successful */
  bool BstepSuccessful;

 /* sge - Correction step not yet initialised, but first call to armijo */
  bool BstepFirstArmijoCall;

 /* mja: Whether fidif derivatives have been evaluated for derivative check */
  bool CheckDerivFidifDone;

 /* mja: Whether user derivatives have been evaluated for derivative check */
  bool CheckDerivUserDone;

 /* DGslc has been constructed */
  bool DGslcDone;

 /* Current point feasible? */
  bool Feasible;

 /* FeasibleInit shall be used */
  bool FeasibleInit;

 /* FeasibleInit has failed */
  bool FeasibleInitFailed;

 /* FeasibleInit mode has been completed */
  bool FeasibleInitDone;

 /* Focus on feasibility? */
  bool FeasibleStep;

 /* mja: Whether the first evaluation has been done already to help with RC */
  bool fidif_first_evald;

 /* mja: Whether f has been evaluated when using fidif for DF and DG */
  bool fidif_f_evald;

 /* mja: Whether g has been evaluated when using fidif for DF and DG */
  bool fidif_g_evald;

 /* Hessian guaranteed as positive definite */
  bool HMposdef;

 /* HMslc has been constructed */
  bool HMslcDone;

 /* Do estimation for LM? */
  bool InitialLMEst;

 /* sge: Updating the lagrange multipliers requires several informations from the QP. Do not erase those. */
  bool KeepQPVectorsForBstep;

 /* KKT conditions satisfied? */
  bool KKTok;

 /* Whether a major iteration was just finished. Used to update counter of MajorIter correctly. */
  bool MajorIterFinished;

 /* mja: To remember the old par%UserDF value that might be changed for checking the user derivatives */
  bool oldUserDF;

 /* mja: To remember the old par%UserDG value that might be changed for checking the user derivatives */
  bool oldUserDG;

 /* mja: To remember the old par%UserHM value that might be changed for checking the user derivatives */
  bool oldUserHM;

 /* Current point optimal? */
  bool Optimal;

 /* sgef: Post QP Sensitivity analysis used and qpdx altered? */
  bool PostQPSensActive;

 /* Intermediate QP solution used? */
  bool QPNotFinished;

 /* Do constraint relaxation in QP?      [LIQP] */
  bool RelaxCon;

 /* sge: Flag to mark change of adaptive relaxation set */
  bool adaptiveRelaxationChanged;

 /* sge: Extraction of regularisation strategy functions required to move a GOTO flag. This boolean is used to perform this move. */
  bool regStrategyGotoFlag;

 /* sge: Save fidif HM for switch mode. Thus, activate fidif after BFGS/identity instead of userhm */
  bool saveFidifHM;

 /* scaled QP */
  bool scaledQP;

 /* weakactiveset is allowed to set constraint to inactive */
  bool setInactive;

 /* sge: flag to signalise, that some kind of switch mode is active */
  bool switchModeActive;

 /* sge: flag to signalise, that the switch mode has finished */
  bool switchModeFinished;

 /* MinimumStepsize hit during TakeQPSol */
  bool TakeQPSolError;

 /* mja: Indicates if the current acceptable or optimal solution was chosen because F was found to be constant */
  bool TerminationByConstantF;

 /* Use identity matrix in QP? */
  bool UseId;

 /* Indicates if the last iteration was in Feasible Mode */
  bool WasFeasMode;

 /* Current point acceptable to filter? */
  bool Acceptable;

 /* AresForce applicable? (don't do it when no search direction is calculated yet) */
  bool AresForce;

 /* Augment filter after accelerating heuristic (ignore criteria)? */
  bool AugmentFilter;

 /* Check full stepsize (accelerating heuristic: ignore criteria)? */
  bool CheckFullStepsize;

 /* Feasibility restoration invoked? */
  bool FeasRest;

 /* Is it the first Hessian regularization? */
  bool FirstHessianReg;

 /* Accept full stepsize in next iteration? */
  bool FullStepsize;

 /* Step size is an f-step-size? */
  bool FStepsize;

 /* PostQP-Sensitivity, alternative qpdx was used and failed */
  bool qppsa_qpdx_failed;

 /* PostQP-Sensitivity, qpdx w.r.t. regularisation available */
  bool qppsa_qpdx_reg_available;

 /* PostQP-Sensitivity, regularisation update available */
  bool qppsa_HMReg_available;

 /* PostQP-Sensitivity, qpdx w.r.t. relaxation available */
  bool qppsa_qpdx_relax_available;

 /* PostQP-Sensitivity, relaxation penalty update available */
  bool qppsa_relaxpen_available;

 /* PostQP-Sensitivity, relaxation penalty sensitivity not negative */
  bool qppsa_relaxpen_failed;

 /* PostQP-Sensitivity, hessian regularisation value newton method failed */
  bool qppsa_HMreg_failed;

 /* Last unsuccessful trial stepsize rejected because of the filter? */
  bool RejectedByFilter;

 /* Is it the second Hessian regularization? */
  bool SecondHessianReg;

 /* SLP step? */
  bool SLPstep;

 /* Accelerating heuristic (ignore criteria) unsuccessful? */
  bool SmallerAlpha;

 /* Switching condition satisfied? */
  bool SwitchingCond;

 /* sge: Use sensitivities with respect to regularisation in post qp psa */
  bool UseRegSens;

 /* sge: Use sensitivities with respect to relaxation in post qp psa */
  bool UseRelaxSens;

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker04;

 /* Automatically added initialisation flag.  */
  bool initialised;
} Workspace;

typedef struct ParamsStruct {

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker05;

 /* Switch between SQP and IP */
  int Algorithm;

 /* Feasibility tolerance */
  double TolFeas;

 /* Optimality tolerance */
  double TolOpti;

 /* Complementarity tolerance */
  double TolComp;

 /* Tolerance for acceptable feasibility */
  double AcceptTolFeas;

 /* Tolerance for acceptable optimality */
  double AcceptTolOpti;

 /* Save acceptable solutions as fallback */
  bool KeepAcceptableSol;

 /* Enable lowpass-filter termination criterion */
  bool LowPassFilter;

 /* Enable too-big termination heuristics */
  bool TooBig;

 /* Upper bound to Reverse Communication calls */
  int MaxCalls;

 /* Upper bound on major iterations */
  int MaxIter;

 /* Timeout in seconds */
  double Timeout;

 /* Tolerance for unboundedness detection heuristic */
  double InftyUnbounded;

 /* Lowpass-filter update factor for objective values */
  double LowPassAlphaF;

 /* Lowpass-filter update factor for constraint values */
  double LowPassAlphaG;

 /* Upper bound on constraint violation for too-big heuristic */
  double TooBigCV;

 /* Upper bound on KKT values for too-big heuristic */
  double TooBigKKT;

 /* Switch to SQP algorithm after IP solve */
  int Crossover;

 /* Iteration at which a crossover is forced */
  int CrossoverIter;

 /* Relaxation factor of original tolerances to be satisfied for crossover */
  double CrossoverTol;

 /* If WORHP monitor is available show window. */
  bool ShowMonitor;

 /* Enable information about which entries of X changed */
  bool DetailedNewX;

 /* Enable XML logfiles and writing interval */
  int LogLevel;

 /* Enable XML result logging and detail level */
  int LogResult;

 /* NLP print level [-1..4] */
  int NLPprint;

 /* Objective gradient values supplied by caller */
  bool UserDF;

 /* Jacobian values supplied by caller */
  bool UserDG;

 /* Hessian values supplied by caller */
  bool UserHM;

 /* F and G cannot be evaluated separately */
  bool FGtogether;

 /* Enable automatic Hessian structure generation or checking */
  int UserHMstructure;

 /* Approximate Hessian by finite differences (otherwise BFGS) */
  bool FidifHM;

 /* mja: Whether to use group methods for finite differences */
  bool FidifGroups;

 /* Use a scaled perturbation for finite differences */
  bool ScaledFD;

 /* Enable check of group composition for derivatives */
  bool CheckGroups;

 /* Use central finite difference quotient for first derivatives */
  bool FirstDifCentral;

 /* mja: Use central finite difference quotient for second derivatives */
  bool SecondDifCentral;

 /* Select method to determine graph colouring groups */
  int GroupMethod;

 /* (experimental) */
  int MaxGPart;

 /* Select method to determine graph colouring pairgroups */
  int PairMethod;

 /* Finite difference perturbation */
  double FidifEps;

 /* Enable structural checking of DF */
  bool CheckStructureDF;

 /* Enable structural checking of DG */
  bool CheckStructureDG;

 /* Enable structural checking of HM */
  bool CheckStructureHM;

 /* mja: Enable comparison of DF values provided by the user with fidif ones */
  bool CheckValuesDF;

 /* mja: Enable comparison of DG values provided by the user with fidif ones */
  bool CheckValuesDG;

 /* mja: Enable comparison of HM values provided by the user with fidif ones */
  bool CheckValuesHM;

 /* The number of the iteration in which user derivatives shall be checked */
  int CheckDerivIter;

 /* How much the user derivative can differ absolutely from fidif without being considered wrong */
  double CheckDerivTolAbs;

 /* How much the user derivative can differ relatively from fidif without being considered wrong */
  double CheckDerivTolRel;

 /* Choose BFGS method (0: dense, 1-3: block, 100+: sparse) */
  int BFGSmethod;

 /* Block size parameter used by certain BFGS methods */
  int BFGSmaxblockSize;

 /* Block size parameter used by certain BFGS methods */
  int BFGSminblockSize;

 /* Restart BFGS update after this many iterations */
  int BFGSrestart;

 /* BFGS Curvature condition bound */
  double CurvCond;

 /* BFGS curvature condition regularisation factor */
  double CurvFac;

 /* Block BFGS curvature condition bound */
  double CurvBCond;

 /* Block BFGS curvature condition regularisation factor */
  double CurvBFac;

 /* sge: Switch mode during globalisation, 0 - none, 1 - Hessian BFGS -> User, 2 - Hessian Identity -> User */
  int SwitchMode;

 /* sge: Threshold of minor iteration to determine globalisation phase and stop switch mode */
  int SwitchModeMaxMinor;

 /* sge: Switch mode termination criterion based on major iteration count. Upper bound on major iteration count */
  int SwitchModeMaxIter;

 /* sge: Switch mode termination criterion, 0 - tolerance based, 1 - minor iteration count of last iterations, 2 - major iteration count */
  int SwitchModeTermination;

 /* sge: Tolerances during switch mode, 0 - normal, 1 - reduced QP and LEQ tolerances, see Switch */
  int SwitchModeTolerances;

 /* sge: Reduced IpComTol for tolerance reduction mode */
  double SwitchModeIpComTol;

 /* sge: Reduced IpResTol for tolerance reduction mode */
  double SwitchModeIpResTol;

 /* sge: Reduced LsTol for tolerance reduction mode */
  double SwitchModeLsTol;

 /* sge: Tolerance to be checked to decide upon termination of globalisation phase */
  double SwitchModeTermTol;

 /* Enable Fritz-John and non-differentiable check heuristics */
  bool FJandND;

 /* mja: If scaled KKT are met, the solution will only be considered acceptable and iteration will continue to try and satisfy normal KKT */
  bool sKKTOnlyAcceptable;

 /* Scale KKT conditions */
  bool ScaledKKT;

 /* Factor in determining active constraints by KKT */
  double BoundTolFac;

 /* Upper bound used by Fritz-John heuristic */
  double CheckFJ;

 /* Lowpass-filter update factor for merit function values */
  double LowPassAlphaMerit;

 /* Enable automatic QP recovery */
  bool AutoQPRecovery;

 /* Update factor for Betts' Hessian regularisation */
  double BettsFactor;

 /* Smallest eigenvalue of the regularised Hessian */
  double BettsPoint;

 /* Increase factor for Betts' update dampening term */
  double IncBettsTau;

 /* Larger increase factor for Betts' update dampening term */
  double IncBettsTauMore;

 /* Initial value for Betts' update dampening term */
  double StartBettsTau;

 /* Select (1) Meritfunction or (3) Filter globalisation */
  int LineSearchMethod;

 /* Control Lagrange multiplier update */
  bool LinMult;

 /* Trial stepsize decrease factor for Armijo rule */
  double ArmijoBeta;

 /* Trial stepsize decrease factor for Armijo rule when in a recovery strategy */
  double ArmijoBetaAres;

 /* Initial alpha for Armijo rule */
  double ArmijoMaxAlpha;

 /* Lower bound on alpha for Armijo rule */
  double ArmijoMinAlpha;

 /* Lower bound on alpha for Armijo rule during recovery */
  double ArmijoMinAlphaRec;

 /* Scale factor for linearised descent check in Armijo rule */
  double ArmijoSigma;

 /* Use a constant lower bound on Armijo stepsize in Filter */
  bool AlphaMinConst;

 /* Filter heuristic to save Armijo iterations */
  bool FilterBisecAlpha;

 /* Filter heuristic to save Armijo iterations */
  bool FilterIntersecAlpha;

 /* Activate accelerating heuristics for Filter */
  bool IgnoreFilterCrit;

 /* Enables Filter-reinitialisation accelerating heuristic */
  bool ReinitFilter;

 /* Select max-norm instead of 1-norm in Filter */
  bool MaxNorm;

 /* Whether to use the feasibility restoration before using any other recovery strategy when the filter is used and the minimum stepsize is reached */
  bool FilterRestFeas;

 /* Do restoration until a feasible solution is found */
  bool RestUntilFeas;

 /* Control activation of Filter acceleration heuristics */
  int MaxLScounter;

 /* Select Hessian regularisation strategy in Filter */
  int RegStrategy;

 /* Constraint violation decrease factor in Filter acceptance check */
  double FilterGammaCV;

 /* Objective decrease factor in Filter acceptance check */
  double FilterGammaF;

 /* Safety factor for alphamin calculation by Filter */
  double GammaAlpha;

 /* Lower bound for Betts' update dampening term */
  double MinBettsTau;

 /* Decrease factor for Betts' update dampening term */
  double ReduceBettsTau;

 /* Filter switching condition parameter */
  double SwitchingDelta;

 /* Filter switching condition parameter */
  double SwitchingSF;

 /* Filter switching condition parameter */
  double SwitchingSCV;

 /* Evaluate QP search direction regardless of convergence */
  bool TakeQPSol;

 /* Select merit function and penalty update [0, 3..5] */
  int MeritFunction;

 /* Penalty update parameter */
  int PenUpdEpsKSequence;

 /* Penalty update parameter factor for MeritFunction = 3 */
  double PenUpdEpsBar;

 /* Penalty update parameter factor for MeritFunction = 4 */
  double PenUpdEpsKFac;

 /* Max penalty for MeritFunction = 4 */
  double PenUpdMaxDeltaK;

 /* Max factor for increasing penalty for MeritFunction = 4 */
  double PenUpdMaxFac;

 /* Penalty update parameter for MeritFunction = 3 */
  double PenUpdRBar;

 /* Threshold of meritfunction gradient for increasing Hessian regularisation */
  double MeritGradTol;

 /* Activates new iterative refinement of constraints only when Armijo alpha equals one */
  bool RefineOnlyOnAlpha;

 /* Use MeritGradient as starting criterion. */
  bool RefineFeasMerit;

 /* Use Steffensen Extrapolation during Feasibility Refinement */
  bool SteffensenOnRefine;

 /* Activates update of lagrangian multipliers during feasibility refinement */
  bool UpdateMu;

 /* sge: Maximum number of feasibility refinement iterations */
  int RefineFeasMaxIter;

 /* 0 - Deactivated, 1 - After first feasible iterate, 2 - Always on, Activates iterative refinement due to perturbation in constraints using parametric sensitivities, 3 - Always on, but correction depending of Active Set of QP */
  int RefineFeasibility;

 /* Termination criteria for Feasibility refinement 0 - just constraints, 1 - constraints and factor, 2 - Lagrangian as watch dog, 3 - Lagrangian and factor */
  int RefineFeasTermination;

 /* Limit for contraction factor to determine slow progress during feasibility refinement */
  double RefineContrLimitc;

 /* Limit for constraint violation in comparison to contraction factor etaq during feasibility refinement */
  double RefineContrLimitq;

 /* Start tolerance for successful termination of iterative refinement due to perturbation in constraints */
  double RefineStartTol;

 /* Maximum allowed relaxation to apply feasibility refinement */
  double RefineMaxRelax;

 /* Maximum allowed regularisation of the hessian CAUTION absolute value */
  double RefineMaxHMReg;

 /* sge: 0 - Turn off, 1 - Activate sensitivity based update of regularisation value using the curvature condition, 2 - Activate sensitivity based on objective deviation, 3 - activate 1 and use 2 as fallback */
  int PostQPSensRegVal;

 /* sge: Activate sensitivity based update of relaxation penalty due to PostQPSensRelaxFrac */
  bool PostQPSensRelaxPen;

 /* sge: 0 - Deactivated, 1 - Use constraint relaxation sensitivity, 2 - Use Hessian regularisation sensitivity, 3 - Use both. */
  int PostQPSensitivity;

 /* sge: Goal fraction for the sensitivity based reduction of relaxDelta */
  double PostQPSensRelaxFrac;

 /* sge: Fraction between sensitivity based Hessian regularisation and old value */
  double PostQPSensRegValFrac;

 /* sge: Allowed deviation for subproblem objective value under regularisation change */
  double PostQPSensRegValObjDev;

 /* enables constraint relaxation */
  bool RelaxCon;

 /* mja: Disable relaxation for constant and linear constraints */
  bool RelaxOnlyNonlinear;

 /* sge: Activate adaptive relaxation of constraints */
  bool AdaptiveConstrRelax;

 /* Introduce one relaxation variable for every constraint */
  bool MoreRelax;

 /* Only one relaxation penalty if MoreRelax is true */
  bool RelaxPenOnlyOne;

 /* Upper bound for accepting the constraint relaxation variable */
  double RelaxMaxDelta;

 /* Upper bound on the constraint relaxation penalty */
  double RelaxMaxPen;

 /* Update factor for the constraint relaxation penalty */
  double RelaxRho;

 /* Initial value of the constraint relaxation penalty */
  double RelaxStart;

 /* Scale constraints in every iteration */
  bool ScaleConIter;

 /* Scale the objective function */
  bool ScaledObj;

 /* Scale some matrices handed to the QP */
  bool ScaledQP;

 /* Value to scale large objective functions to */
  double ScaleFacObj;

 /* Upper bound on resulting matrix norm for QP scaling */
  double ScaleFacQP;

 /* Enable initial Lagrange multiplier estimate */
  bool InitialLMest;

 /* IP complementarity tolerance in initial multiplier estimate */
  double LMestQPipComTol;

 /* IP residual tolerance in initial multiplier estimate */
  double LMestQPipResTol;

 /* Activate dual feasibility mode */
  bool FeasibleDual;

 /* Activate initial feasibility mode */
  bool FeasibleInit;

 /* Activate feasible-only mode */
  bool FeasibleOnly;

 /* Enable Focus-on-Feasibility mode */
  bool FocusOnFeas;

 /* Feasibility tolerance for no-objective feasible mode */
  double FeasibleInitTol;

 /* Factor in Focus-on-Feasibility mode */
  double FocusOnFeasFactor;

 /* Maximum number of Force recovery strategy steps */
  int MaxForce;

 /* Armijo recovery strategies */
  int Ares[NAres];

 /* WORHP IP: Enable the relaxation of bounds at the beginning */
  bool IP_NlpRelaxBounds;

 /* WORHP IP: Enable the relaxation of bounds during optimization */
  bool IP_NlpRelaxBoundsIter;

 /* WORHP IP: Enable the projection back into the original bounds */
  bool IP_NlpStressBounds;

 /* Worhp IP: barrier function */
  int IP_BarrierType;

 /* Worhp IP: strategy for updating barrier parameter */
  int IP_BarrierUpdate;

 /* WORHP IP: max iter without update to switch to fast update */
  int IP_BarrierIterFast;

 /* WORHP IP: initial value of barrier parameter */
  double IP_BarrierInit;

 /* WORHP IP: tolerance for barrier parameter */
  double IP_BarrierTol;

 /* WORHP IP: linear decrease factor for barrier. */
  double IP_BarrierLinDecr;

 /* WORHP IP: superlinear decrease power for barrier. */
  double IP_BarrierSupDecr;

 /* WORHP IP: fast linear decrease factor for barrier. */
  double IP_BarrierLinDecrFast;

 /* WORHP IP: fast superlinear decrease power for barrier. */
  double IP_BarrierSupDecrFast;

 /* WORHP IP: linear damping factor for log-lin barrier function. */
  double IP_BarrierLinDamp;

 /* WORHP IP: max iterations in classic IP algorithm before switch to PIPA. (-1 is infinity, 0 means disabled) */
  int IP_PenaltyZeroIter;

 /* WORHP IP: penalty function (l1, l2, augmented Lagrangian) */
  int IP_PenaltyType;

 /* WORHP IP: update strategy for penalty parameter */
  int IP_PenaltyUpdate;

 /* WORHP IP: selects the position of the penalty parameter (obj or con). */
  int IP_PenaltyPosition;

 /* WORHP IP: max value of penalty parameter in front of constraint violation after which the penalty obj will be updated */
  double IP_PenaltySwitch;

 /* WORHP IP: initial value of penalty parameter */
  double IP_PenaltyInit;

 /* WORHP IP: tolerance for the penalty problem. */
  double IP_PenaltyTol;

 /* WORHP IP: dual factor for termination criteria */
  double IP_PenaltyTolDual;

 /* WORHP IP: linear increase factor for penalty. */
  double IP_PenaltyLinIncr;

 /* WORHP IP: linear decrease factor for penalty. */
  double IP_PenaltyLinDecr;

 /* WORHP IP: value to be considered as divergence of PenaltyObj */
  double IP_PenaltyMin;

 /* WORHP IP: value to be considered as divergence of PenaltyFeas */
  double IP_PenaltyMax;

 /* WORHP IP: number of adaptive penalty updates to consider */
  int IP_PenaltyAdaptNum;

 /* WORHP IP: Improvement factor for the feasibility condition of the adaptive updates. */
  double IP_PenaltyAdaptImprFeas;

 /* WORHP IP: Improvement factor for the quadratic model condition of the adaptive updates. */
  double IP_PenaltyAdaptImprQuad;

 /* WORHP IP: initialization of augmented Langrangian multipliers */
  int IP_AugInitMethod;

 /* WORHP IP: chooses the update strategy of for the augmented duals */
  int IP_AugUpdate;

 /* WORHP IP: chooses the method for checking for global convergence */
  int IP_AdaptCheckMethod;

 /* WORHP IP: method for init dual variables */
  int IP_InitMethodDual;

 /* WORHP IP: method for init dual box variables */
  int IP_InitMethodDualBox;

 /* WORHP IP: enables multiplier estimation */
  bool IP_InitDualEstimation;

 /* WORHP IP: enables the dual adjustment */
  bool IP_InitDualAdjustment;

 /* WORHP IP: number of centering steps */
  int IP_InitCenteringSteps;

 /* WORHP IP: initial value of multipliers */
  double IP_InitDual;

 /* WORHP IP: initial value of box multipliers */
  double IP_InitDualBox;

 /* WORHP IP: min absolute distance to box bound of X */
  double IP_InitBoundDistAbs;

 /* WORHP IP: min relative distance to box bound of X */
  double IP_InitBoundDistRel;

 /* WORHP IP: min absolute distance to box bound of S */
  double IP_InitBoundDistSAbs;

 /* WORHP IP: min relative distance to box bound of S */
  double IP_InitBoundDistSRel;

 /* WORHP IP: min absolute distance to zero of duals */
  double IP_InitBoundDistDual;

 /* WORHP IP: Stores an intermediate iterate for warmstart */
  bool IP_WarmStore;

 /* WORHP IP: Real-time update after warmstart using sensitivity analysis */
  bool IP_WarmSensUpdate;

 /* WORHP IP: method for init dual variables after warmstart */
  int IP_WarmMethodDual;

 /* WORHP IP: method for init dual box variables after warmstart */
  int IP_WarmMethodDualBox;

 /* WORHP IP: enables multiplier estimation */
  bool IP_WarmDualEstimation;

 /* WORHP IP: enables the dual adjustment */
  bool IP_WarmDualAdjustment;

 /* WORHP IP: number of centering steps */
  int IP_WarmCenteringSteps;

 /* WORHP IP: initial value of multipliers after warmstart */
  double IP_WarmDual;

 /* WORHP IP: initial value of box multipliers after warmstart */
  double IP_WarmDualBox;

 /* WORHP IP: min absolute distance to box bound of X after warmstart */
  double IP_WarmBoundDistAbs;

 /* WORHP IP: min relative distance to box bound of X after warmstart */
  double IP_WarmBoundDistRel;

 /* WORHP IP: min absolute distance to box bound of S after warmstart */
  double IP_WarmBoundDistSAbs;

 /* WORHP IP: min absolute relative to box bound of S after warmstart */
  double IP_WarmBoundDistSRel;

 /* WORHP IP: min absolute distance to zero of duals after warmstart */
  double IP_WarmBoundDistDual;

 /* WORHP IP: enables the check of correct inertia */
  bool IP_RegCheckInertia;

 /* WORHP IP: if regularization fails, use identity matrix */
  bool IP_RegFailUseIdentity;

 /* WORHP IP: guaranteed min value of descent */
  double IP_RegMinDescent;

 /* WORHP IP: start value for regularization */
  double IP_RegHessStart;

 /* WORHP IP: fraction of old value for regularization */
  double IP_RegHessOldFrac;

 /* WORHP IP: fast increase of value for regularization */
  double IP_RegHessIncrFast;

 /* WORHP IP: normal increase of value for regularization */
  double IP_RegHessIncrStd;

 /* WORHP IP: max value for hessian regularization before considered as failure */
  double IP_RegHessMax;

 /* WORHP IP: jacobian regularization term */
  double IP_RegJac;

 /* WORHP IP: enables further quality improvements for linear system solves */
  bool IP_LeqIncQuality;

 /* WORHP IP: block elimination technique for the linear equation systemm */
  int IP_LeqReduce;

 /* WORHP IP: min iterations for iterative refinement */
  int IP_LeqItRefMinIter;

 /* WORHP IP: max iterations for iterative refinement */
  int IP_LeqItRefMaxIter;

 /* WORHP IP: maximum iterations for iterative refinement */
  double IP_LeqItRefTol;

 /* WORHP IP: improvement factor for iterative refinement */
  double IP_LeqItRefImprFac;

 /* WORHP IP: line search method (filter, merit function) */
  int IP_LineMethod;

 /* WORHP IP: number of non monotone level of merit approach */
  int IP_LineMeritNonmon;

 /* WORHP IP: number of non monotone level of filter approach */
  int IP_LineFilterNonmon;

 /* WORHP IP: type of filter envelope */
  int IP_LineFilterEnvelope;

 /* WORHP IP: objective decrease factor in filter */
  double IP_LineFilterGammaObj;

 /* WORHP IP: constraint violation decrease factor in filter */
  double IP_LineFilterGammaFeas;

 /* WORHP IP: update factor for step size */
  double IP_LineArmijoBeta;

 /* WORHP IP: reduction factor for armijo condition. */
  double IP_LineArmijoEta;

 /* WORHP IP: max step size */
  double IP_LineAlphaMax;

 /* WORHP IP: max step size */
  double IP_LineAlphaMin;

 /* WORHP IP: enables interpolation for step size update */
  bool IP_LineInterp;

 /* WORHP IP: min decrease in relation to old step size */
  double IP_LineInterpMin;

 /* WORHP IP: max decrease in relation to old step size */
  double IP_LineInterpMax;

 /* WORHP IP: Enable slack reset after update. */
  bool IP_LineSlackReset;

 /* WORHP IP: minimal fraction to the boundary */
  double IP_LineFracToBound;

 /* WORHP IP: huge parameter defining the trust region of lambda */
  double IP_LineTrustDual;

 /* WORHP IP: max iter of second-order correction */
  int IP_LineCorMaxIter;

 /* WORHP IP: enables unblocking strategy */
  bool IP_LineUnblock;

 /* WORHP IP: specifies the unblocking level */
  double IP_LineUnblockLevel;

 /* WORHP IP: max iterations of refinement step. */
  int IP_RefMaxIter;

 /* WORHP IP: enable check of kkt conditions of feasibility problem */
  bool IP_CheckInfeas;

 /* WORHP IP: enable check of kkt conditions for fritz john point */
  bool IP_CheckFritzJohn;

 /* WORHP IP: Enable check for NaN / Inf in function evaluations. */
  int IP_CheckNanInf;

 /* WORHP IP: max value of primal iterates */
  double IP_CheckMaxPrimal;

 /* WORHP IP: max value of dual iterates */
  double IP_CheckMaxDual;

 /* WORHP IP: Enable lowpass filter on barrier level */
  bool IP_CheckLowPassBarr;

 /* WORHP IP: Enable lowpass filter on penalty level */
  bool IP_CheckLowPassPen;

 /* WORHP IP: relative tolerance for lowpass filter */
  double IP_CheckLowPassTol;

 /* WORHP IP: enables optimization after modified problem has been solved */
  bool IP_CheckOrigCont;

 /* WORHP IP: enables to continue for n iterations after modified problem has been solved */
  int IP_CheckOrigContMaxIter;

 /* WORHP IP: Enable scaling of objective function. */
  bool IP_ScaleF;

 /* WORHP IP: Enable scaling of constraints. */
  bool IP_ScaleG;

 /* WORHP IP: max gradient after automatic scaling */
  double IP_ScaleMaxGrad;

 /* WORHP IP: min scaling factor of automatic scaling */
  double IP_ScaleMin;

 /* Run Zen module after successful termination */
  bool UseZen;

 /* Hessian values supplied by caller */
  bool UserZenDGp;

 /* Hessian values supplied by caller */
  bool UserZenDLxp;

 /* Gradient values supplied by caller */
  bool UserZenDLp;

 /* Hessian values supplied by caller */
  bool UserZenDLpp;

 /* Check maximum of secure perturbation when updating solution */
  bool ZenCheckMaxPert;

 /* false: use LU from last QP step; true: renew LU decomposition. */
  bool ZenRenewLU;

 /* selects different storage options for sensitivities */
  int ZenStore;

 /* Use BLAS level 3 (dgemm) in MA97 */
  bool MA97blas3;

 /* Use multifrontal-style forward solve of MA97 */
  bool MA97mf;

 /* Ordering used by MA97 */
  int MA97ordering;

 /* Scaling used by MA97 */
  int MA97scaling;

 /* Print level used by MA97 */
  int MA97print;

 /* Node amalgation, controls merging in elimination tree by MA97 */
  int MA97nemin;

 /* Min number of expected flops before parallel execution is used in factorization */
  int MA97factorMin;

 /* Any pivot whose modulus is less than this is treated as zero by MA97 */
  double MA97small;

 /* Relative pivot tolerance of MA97 */
  double MA97u;

 /* Max pivot tolerance of MA97 */
  double MA97umax;

 /* Upper bound for numbers to be regarded as finite */
  double Infty;

 /* Increase factor for estimated integer workspace requirement */
  double IncreaseIWS;

 /* Increase factor for estimated real workspace requirement */
  double IncreaseRWS;

 /* Counter for changed parameters. Internal use only. */
  int internalParChanged;

 /* Not to be included into a parameter file! */
  bool MatrixCC;

 /* (currently unused) Scaling factor for QP */
  double QPscaleParam;

 /* (currently unused) Relative precision of objective */
  double PrecisionF;

 /* (currently unused) Relative precision of constraints */
  double PrecisionG;

 /* (experimental) */
  double TolWeakActive;

 /* (experimental) */
  bool WeakActiveSet;

 /* Pointer to QP parameter structure */
  QPParams qp;

 /* Can be pointed at a string which will be used as the license file content instead of opening the worhp.lic file. */
  const char* licenseFileContent;

 /* Debug marker. Used to find memory alignment/padding issues */
  int DebugMarker06;

 /* Automatically added initialisation flag.  */
  bool initialised;
} Params;

typedef struct ControlStruct {
  DateType Date;
  TimerType Timer;

 /* Ring buffer for stage history */
  int Stage[NStageHistory];

 /* Logical field for user action flags */
  bool UserAction[NUserAction];

 /* External status flag */
  int status;

 /* Internal status flag */
  int int_status;

 /* WORHP status cached by Zen */
  int pre_zen_status;
  int currentStage;

 /* Indicates if current optimization has been warmstarted. */
  bool Warmstarted;

 /* Counter for Zen loops with Reverse Communication */
  counter ZenRCcounter1;

 /* Counter for Zen loops with Reverse Communication */
  counter ZenRCcounter2;

 /* True if Zen has been initialised. */
  bool ZenInit;

 /* Automatically added initialisation flag.  */
  bool initialised;
} Control;

/* Defined in Worhp_Data.F90 via C-interop  */
DLL_PUBLIC bool GetUserAction(const Control *cnt, int action);
DLL_PUBLIC void DoneUserAction(Control *cnt, int done);
DLL_PUBLIC void AddUserAction(Control *cnt, int add);
DLL_PUBLIC void SetNextStage(Control*, int);
DLL_PUBLIC int  GetCurrentStage(Control*);
DLL_PUBLIC int  GetPreviousStage(Control*, int);

/* Defined in C_Worhp_Data.c  */
DLL_PUBLIC void WorhpVersion(int *major, int *minor, char patch[PATCH_STRING_LENGTH]);
DLL_PUBLIC int CheckWorhpVersion(int major, int minor, const char *patch);

#ifdef __cplusplus
}
#endif

#endif /* HEADER_C_WORHP_DATA_H_GUARD */


