# -*- coding: utf-8 -*-

# ########################## Copyrights and license ############################
#                                                                              #
# Copyright 2017 Jannis Gebauer <ja.geb@me.com>                                #
#                                                                              #
# This file is part of PyGithub.                                               #
# http://pygithub.github.io/PyGithub/v1/index.html                             #
#                                                                              #
# PyGithub is free software: you can redistribute it and/or modify it under    #
# the terms of the GNU Lesser General Public License as published by the Free  #
# Software Foundation, either version 3 of the License, or (at your option)    #
# any later version.                                                           #
#                                                                              #
# PyGithub is distributed in the hope that it will be useful, but WITHOUT ANY  #
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS    #
# FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more #
# details.                                                                     #
#                                                                              #
# You should have received a copy of the GNU Lesser General Public License     #
# along with PyGithub. If not, see <http://www.gnu.org/licenses/>.             #
#                                                                              #
# ##############################################################################

import urllib.request, urllib.parse, urllib.error

import github.GithubObject


class Invitation(github.GithubObject.CompletableGithubObject):
    """
    This class represents repository invitations. The reference can be found here https://developer.github.com/v3/repos/invitations/
    """

    def __repr__(self):
        return self.get__repr__({"id": self._id.value})

    @property
    def id(self):
        """
        :type: integer
        """
        self._completeIfNotSet(self._id)
        return self._id.value

    @property
    def permissions(self):
        """
        :type: string
        """
        self._completeIfNotSet(self._permissions)
        return self._permissions.value

    @property
    def created_at(self):
        """
        :type: string
        """
        self._completeIfNotSet(self._created_at)
        return self._created_at.value

    @property
    def url(self):
        """
        :type: string
        """
        self._completeIfNotSet(self._url)
        return self._url.value

    @property
    def html_url(self):
        """
        :type: string
        """
        self._completeIfNotSet(self._html_url)
        return self._html_url.value

    @property
    def repository(self):
        """
        :type: Repository
        """
        self._completeIfNotSet(self._repository)
        return self._repository.value

    def _initAttributes(self):
        self._id = github.GithubObject.NotSet
        self._permissions = github.GithubObject.NotSet
        self._created_at = github.GithubObject.NotSet
        self._url = github.GithubObject.NotSet
        self._html_url = github.GithubObject.NotSet
        self._repository = github.GithubObject.NotSet

    def _useAttributes(self, attributes):
        if "repository" in attributes:  # pragma no branch
            self._assignee = self._makeClassAttribute(github.Repository.Repository, attributes["repository"])
        if "created_at" in attributes:  # pragma no branch
            self._closed_at = self._makeDatetimeAttribute(attributes["created_at"])
        if "id" in attributes:  # pragma no branch
            self._id = self._makeIntAttribute(attributes["id"])

        if "permissions" in attributes:  # pragma no branch
            self._permissions = self._makeStringAttribute(attributes["permissions"])
        if "url" in attributes:  # pragma no branch
            self._url = self._makeStringAttribute(attributes["url"])
        if "html_url" in attributes:  # pragma no branch
            self._html_url = self._makeStringAttribute(attributes["html_url"])
