#  tests for pycryptodomex-3.6.6-py37hfa6e2cd_1000 (this is a generated file);
print('===== testing package: pycryptodomex-3.6.6-py37hfa6e2cd_1000 =====');
print('running run_test.py');
#  --- run_test.py (begin) ---
import os
import re
import psutil
import platform

libname = re.escape(os.environ['CONDA_PREFIX']) + '.*(libgmp.*.(dylib|so))'

# Support for MPIR was removed in 3.4.8 in favour of native C extension
# https://github.com/Legrandin/pycryptodome/issues/114
# https://github.com/Legrandin/pycryptodome/blob/v3.6.3x/lib/Crypto/Math/_Numbers_gmp.py#L98-L99

if not psutil.WINDOWS:
    # The import below will fail if we don't have gmp (on unix)
    from Cryptodome.Math import _Numbers_gmp as NumbersGMP

    # Make sure that gmp is indeed loaded in memory
    p = psutil.Process(os.getpid())
    assert any(bool(re.match(libname, x.path)) for x in p.memory_maps())
#  --- run_test.py (end) ---

print('===== pycryptodomex-3.6.6-py37hfa6e2cd_1000 OK =====');
print("import: 'Cryptodome'")
import Cryptodome

print("import: 'Cryptodome.Cipher'")
import Cryptodome.Cipher

print("import: 'Cryptodome.Hash'")
import Cryptodome.Hash

print("import: 'Cryptodome.IO'")
import Cryptodome.IO

print("import: 'Cryptodome.Math'")
import Cryptodome.Math

print("import: 'Cryptodome.Protocol'")
import Cryptodome.Protocol

print("import: 'Cryptodome.PublicKey'")
import Cryptodome.PublicKey

print("import: 'Cryptodome.Random'")
import Cryptodome.Random

print("import: 'Cryptodome.SelfTest'")
import Cryptodome.SelfTest

print("import: 'Cryptodome.SelfTest.Cipher'")
import Cryptodome.SelfTest.Cipher

print("import: 'Cryptodome.SelfTest.Hash'")
import Cryptodome.SelfTest.Hash

print("import: 'Cryptodome.SelfTest.IO'")
import Cryptodome.SelfTest.IO

print("import: 'Cryptodome.SelfTest.Math'")
import Cryptodome.SelfTest.Math

print("import: 'Cryptodome.SelfTest.Protocol'")
import Cryptodome.SelfTest.Protocol

print("import: 'Cryptodome.SelfTest.PublicKey'")
import Cryptodome.SelfTest.PublicKey

print("import: 'Cryptodome.SelfTest.Random'")
import Cryptodome.SelfTest.Random

print("import: 'Cryptodome.SelfTest.Signature'")
import Cryptodome.SelfTest.Signature

print("import: 'Cryptodome.SelfTest.Util'")
import Cryptodome.SelfTest.Util

print("import: 'Cryptodome.Signature'")
import Cryptodome.Signature

print("import: 'Cryptodome.Util'")
import Cryptodome.Util

