"""
The datasets module contains some serialized databases for unit testing purposes.

These databases are not claimed suitable for any other purpose.
"""

ALCRNI_TDB = """
Elem /-          ELECTRON_GAS         0         0         0 !
ELEM VA                VACUUM         0         0         0 !
ELEMENT AL                FCC_A1    26.982      4540      28.3 !
ELEMENT CR                BCC_A2    51.996      4050    23.543 !
ELEMENT NI                FCC_A1     58.69      4787    29.796 !

$------------------------------------------------------------------------------
 FUNCT GHSERAL  298.15    -7976.15+137.093038*T-24.3671976*T*LN(T)
    -1.884662E-3*T**2-0.877664E-6*T**3+74092*T**(-1);                     700 Y
    -11276.24+223.048446*T-38.5844296*T*LN(T)+18.531982E-3*T**2
    -5.764227E-6*T**3+74092*T**(-1);                                   933.47 Y
    -11278.378+188.684153*T-31.748192*T*LN(T)-1230.524E25*T**(-9);     2900 N !

 FUNCTION GALBCC   298.15    +2106.85+132.280038*T-24.3671976*T*LN(T)
    -1.884662E-3*T**2-0.877664E-6*T**3+74092*T**(-1);                     700 Y
    -1193.24+218.235446*T-38.5844296*T*LN(T)+18.531982E-3*T**2-5.764227E-6*T**3
    +74092*T**(-1);                                                    933.47 Y
    -1195.378+183.871153*T-31.748192*T*LN(T)-1230.524E25*T**(-9);      2900 N !

 FUNCTION GALLIQ   298.15     +3028.879+125.251171*T-24.3671976*T*LN(T)
    -1.884662E-3*T**2-0.877664E-6*T**3+74092*T**(-1)+79.337E-21*T**7;     700 Y
    -271.21+211.206579*T-38.5844296*T*LN(T)+18.531982E-3*T**2-5.764227E-6*T**3
    +74092*T**(-1)+79.337E-21*T**7;                                    933.47 Y
    -795.996+177.430178*T-31.748192*T*LN(T);                           2900 N !


 FUNCTION GHSERCR   298.15    -8856.94+157.48*T-26.908*T*LN(T)+1.89435E-3*T**2
    -1.47721E-6*T**3+139250*T**(-1);                                     2180 Y
    -34869.344+344.18*T-50*T*LN(T)-2885.26E29*T**(-9);                 6000 N !
$ PARAMETER  TC(BCC_A2,CR:VA;0)   298.15  -311.50;  6000.00 N !
$ PARAMETER  BM(BCC_A2,CR:VA;0)   298.15    -0.008;  6000.00 N !

 FUNCTION GCRLIQ   298.15      +15483.015+146.059775*T-26.908*T*LN(T)
    +1.89435E-3*T**2-1.47721E-6*T**3+139250*T**(-1)+237.615E-23*T**7;    2180 Y
    -16459.984+335.616316*T-50*T*LN(T);                                6000 N !

 FUNCTION GCRFCC   298.15      -1572.94+157.643*T-26.908*T*LN(T)
    +1.89435E-3*T**2-1.47721E-6*T**3+139250*T**(-1);                     2180 Y
    -27585.344+344.343*T-50*T*LN(T)-2885.26E29*T**(-9);                6000 N !

 FUNCTION GHSERNI   298.15     -5179.159+117.854*T-22.096*T*LN(T)
     -4.8407E-3*T**2;                                                    1728 Y
    -27840.655+279.135*T-43.1*T*LN(T)+1127.54E28*T**(-9);              3000 N !

 FUNCTION GNILIQ   298.15      +11235.527+108.457*T-22.096*T*LN(T)
    -4.8407E-3*T**2-382.318E-23*T**7;                                    1728 Y
    -9549.775+268.598*T-43.1*T*LN(T);                                  3000 N !

 FUNCTION GNIBCC   298.15      +3535.925+114.298*T-22.096*T*LN(T)
    -4.8407E-3*T**2;                                                     1728 Y
    -19125.571+275.579*T-43.1*T*LN(T)+1127.54E28*T**(-9);              3000 N !


 FUNCTION L0ALNI   298.15  +ZERO;                             6000 N !
 FUNCTION L1ALNI   298.15  +7204-3.743*T;                     6000 N !
 FUNCTION L0ALCR   298.15  +ZERO;                             6000 N !
 FUNCTION L1ALCR   298.15  +ZERO;                             6000 N !
 FUNCTION L0CRNI   298.15  +ZERO;                             6000 N !
 FUNCTION L1CRNI   298.15  +ZERO;                             6000 N !
 FUNCTION U1ALNI   298.15  -14808.67+2.93067*T;               6000 N !
 FUNCTION U1CRNI   298.15  -1980;                             6000 N !
 FUNCTION U1ALCR   298.15  -830;                              6000 N !
 FUNCTION UALCRNI2 298.15  +U1ALCR+2*U1ALNI+2*U1CRNI+6650;    6000 N !
 FUNCTION ALPHALVA 298.15  +10000-T;                          6000 N !
 FUNCTION ALPHNIVA 298.15  +162397-27.406*T;                  6000 N !
 FUNCTION ALPHALNI 298.15  -152397+26.406*T;                  6000 N !
 FUNCTION LAMBALVA 298.15  +150000;                           6000 N !
 FUNCTION LAMBNIVA 298.15  -64024+26.494*T;                   6000 N !
 FUNCTION LAMBALNI 298.15  -52441+11.301*T;                   6000 N !
 FUNCTION ZERO     298.15  +0;                                6000 N !
 FUNCTION UN_ASS   298.15  +0;                                6000 N !


$------------------------------------------------------------------------------
 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA /- !

$------------------------------------------------------------------------------

TYPE_DEFINITION & GES A_P_D BCC_A2   MAGNETIC -1       0.4!
TYPE_DEFINITION ) GES A_P_D B2       DIS_PART BCC_A2   ,,,!
TYPE_DEFINITION ( GES A_P_D FCC_A1   MAGNETIC -3      0.28!
TYPE_DEFINITION ' GES A_P_D L12_FCC  DIS_PART FCC_A1   ,,,!

$------------------------------------------------------------------------------
$ PARAMETERS FOR LIQUID PHASE
$------------------------------------------------------------------------------
 PHASE LIQUID % 1 1 !
   CONSTITUENT LIQUID :AL,CR,NI: !
  PARA G(LIQUID,AL)          +GALLIQ;  N !
  Parameter G(LIQUID,CR;0)          298.15  +GCRLIQ;            6000 N !
  PARAM G(LIQUID,NI;0)          298.15  +GNILIQ;            6000 N !
  PAR G(LIQUID,AL,CR;0)       298.15  -29000;             6000 N !
  PARAMETER G(LIQUID,AL,CR;1)       298.15  -11000;             6000 N !
  PARAMETER G(LIQUID,AL,NI;0)       298.15  -207109+41.315*T;   6000 N !
  PARAMETER G(LIQUID,AL,NI;1)       298.15  -10186+5.871*T;     6000 N !
  PARAMETER G(LIQUID,AL,NI;2)       298.15  +81205-31.957*T;    6000 N !
  PARAMETER G(LIQUID,AL,NI;3)       298.15  +4365-2.516*T;      6000 N !
  PARAMETER G(LIQUID,AL,NI;4)       298.15  -22101.64+13.163*T; 6000 N !
  PARAMETER G(LIQUID,CR,NI;0)       298.15  +318-7.33*T;        6000 N !
  PARAMETER G(LIQUID,CR,NI;1)       298.15  +16941-6.37*T;      6000 N !
  PARAMETER G(LIQUID,AL,CR,NI;0)    298.15  +16000;             6000 N !
  PARAMETER G(LIQUID,AL,CR,NI;1)    298.15  +16000;             6000 N !
  PARAMETER G(LIQUID,AL,CR,NI;2)    298.15  +16000;             6000 N !

$------------------------------------------------------------------------------
$ PARAMETERS FOR BCC PHASE
$------------------------------------------------------------------------------

 PHASE BCC_A2 %& 1 1 !
   CONSTITUENT BCC_A2 :AL,CR,NI,VA: !
  Para G(BCC_A2,AL)  +GALBCC; N !
  PARAMETER G(BCC_A2,CR;0)        298.15  +GHSERCR;             6000 N !
  PARAMETER G(BCC_A2,NI;0)        298.15  +GNIBCC;              6000 N !
  PARAMETER G(BCC_A2,VA;0)        298.15  +300;                 6000 N !
  PARAMETER G(BCC_A2,AL,VA;0)     298.15  +ALPHALVA+LAMBALVA;   6000 N !
  PARAMETER G(BCC_A2,CR,VA;0)     298.15  +100000;              6000 N !
  PARAMETER G(BCC_A2,NI,VA;0)     298.15  +ALPHNIVA+LAMBNIVA;   6000 N !
  PARAMETER G(BCC_A2,AL,CR;0)     298.15  -54900+10*T;          6000 N !
  PARAMETER G(BCC_A2,AL,NI;0)     298.15  +ALPHALNI+LAMBALNI;   6000 N !
  PARAMETER G(BCC_A2,CR,NI;0)     298.15  +17170-11.82*T;       6000 N !
  PARAMETER G(BCC_A2,CR,NI;1)     298.15  +34418-11.858*T;      6000 N !
  PARAMETER TC(BCC_A2,CR;0)       298.15  -311.50;              6000 N !
  PARAMETER BMAGN(BCC_A2,CR;0)    298.15  -0.008;               6000 N !
  PARAMETER TC(BCC_A2,NI;0)       298.15   +575;                6000 N !
  PARAMETER BMAGN(BCC_A2,NI;0)    298.15   +0.85;               6000 N !
  PARAMETER TC(BCC_A2,CR,NI;0)       298.15   +2373;            6000 N !
  PARAMETER TC(BCC_A2,CR,NI;1)       298.15   +617;             6000 N !
  PARAMETER BMAGN(BCC_A2,CR,NI;0)    298.15   +4;               6000 N !
  PARAMETER G(BCC_A2,AL,CR,NI;0)     298.15   +42500;           6000 N !

 PHASE B2 %) 2 0.5 0.5 !
   CONSTITUENT B2 : AL,CR,NI,VA : AL,CR,NI,VA: !
  PARAMETER G(B2,AL:AL;0)  298.15  +ZERO;                       6000 N !
  PARAMETER G(B2,CR:CR;0)  298.15  +ZERO;                       6000 N !
  PARAMETER G(B2,NI:NI;0)  298.15  +ZERO;                       6000 N !
  PARAMETER G(B2,VA:VA;0)  298.15  +300;                        6000 N !
  PARAMETER G(B2,AL:VA;0)  298.15  +0.5*ALPHALVA-0.5*LAMBALVA;  6000 N !
  PARAMETER G(B2,VA:AL;0)  298.15  +0.5*ALPHALVA-0.5*LAMBALVA;  6000 N !
  PARAMETER G(B2,CR:VA;0)  298.15  +ZERO;                       6000 N !
  PARAMETER G(B2,VA:CR;0)  298.15  +ZERO;                       6000 N !
  PARAMETER G(B2,NI:VA;0)  298.15  +0.5*ALPHNIVA-0.5*LAMBNIVA;  6000 N !
  PARAMETER G(B2,VA:NI;0)  298.15  +0.5*ALPHNIVA-0.5*LAMBNIVA;  6000 N !
  PARAMETER G(B2,CR:AL;0)  298.15  -2000;                       6000 N !
  PARAMETER G(B2,AL:CR;0)  298.15  -2000;                       6000 N !
  PARAMETER G(B2,NI:AL;0)  298.15  +0.5*ALPHALNI-0.5*LAMBALNI;  6000 N !
  PARAMETER G(B2,AL:NI;0)  298.15  +0.5*ALPHALNI-0.5*LAMBALNI;  6000 N !
  PARAMETER G(B2,NI:CR;0)  298.15  +4000;                       6000 N !
  PARAMETER G(B2,CR:NI;0)  298.15  +4000;                       6000 N !





$------------------------------------------------------------------------------
$ PARAMETERS FOR FCC PHASE
$------------------------------------------------------------------------------
 PHASE FCC_A1 %( 1 1 !
   CONSTITUENT FCC_A1 :AL,CR,NI: !
  PARAMETER G(FCC_A1,AL;0)         298.15  +GHSERAL;            6000 N !
  PARAMETER G(FCC_A1,CR;0)         298.15  +GCRFCC;             6000 N !
  PARAMETER TC(FCC_A1,CR;0)        298.15  -1109.00;            6000 N !
  PARAMETER BMAGN(FCC_A1,CR;0)     298.15  -2.46;               6000 N !
  PARAMETER G(FCC_A1,NI;0)         298.15  +GHSERNI;            6000 N !
  PARAMETER TC(FCC_A1,NI;0)        298.15  +633;                6000 N !
  PARAMETER BMAGN(FCC_A1,NI;0)     298.15  +0.52;               6000 N !
  PARAMETER G(FCC_A1,AL,CR;0)      298.15  -45900+6*T;          6000 N !
  PARAMETER G(FCC_A1,AL,NI;0)      298.15  -162408+16.213*T;    6000 N !
  PARAMETER G(FCC_A1,AL,NI;1)      298.15  +73418-34.914*T;     6000 N !
  PARAMETER G(FCC_A1,AL,NI;2)      298.15  +33471-9.837*T;      6000 N !
  PARAMETER G(FCC_A1,AL,NI;3)      298.15  -30758+10.253*T;     6000 N !
  PARAMETER TC(FCC_A1,AL,NI;0)     298.15  -1112;               6000 N !
  PARAMETER TC(FCC_A1,AL,NI;1)     298.15  +1745;               6000 N !
  PARAMETER G(FCC_A1,CR,NI;0)      298.15  +8030-12.880*T;      6000 N !
  PARAMETER G(FCC_A1,CR,NI;1)      298.15  +33080-16.036*T;     6000 N !
  PARAMETER TC(FCC_A1,CR,NI;0)     298.15  -3605;               6000 N !
  PARAMETER BMAGN(FCC_A1,CR,NI;0)  298.15  -1.91;               6000 N !
  PARAMETER G(FCC_A1,AL,CR,NI;0)   298.15  +30300;              6000 N !

 PHASE  L12_FCC %' 2  0.75  0.25 !
   CONSTITUENT L12_FCC :AL,CR,NI: AL,CR,NI : !
  PARAMETER G(L12_FCC,AL:AL;0)      298.15  +ZERO;              6000 N !
  PARAMETER G(L12_FCC,CR:CR;0)      298.15  +ZERO;              6000 N !
  PARAMETER G(L12_FCC,NI:NI;0)      298.15  +ZERO;              6000 N !
  PARAMETER G(L12_FCC,AL:NI;0)      298.15  +3*U1ALNI;          6000 N !
  PARAMETER G(L12_FCC,NI:AL;0)      298.15  +3*U1ALNI;          6000 N !
  PARAMETER G(L12_FCC,AL:CR;0)      298.15  +3*U1ALCR;          6000 N !
  PARAMETER G(L12_FCC,CR:AL;0)      298.15  +3*U1ALCR;          6000 N !
  PARAMETER G(L12_FCC,CR:NI;0)      298.15  +3*U1CRNI;          6000 N !
  PARAMETER G(L12_FCC,NI:CR;0)      298.15  +3*U1CRNI;          6000 N !

  PARAMETER G(L12_FCC,AL,NI:AL;0)  298.15   +6*U1ALNI;          6000 N !
  PARAMETER G(L12_FCC,AL,NI:NI;0)  298.15   +6*U1ALNI;          6000 N !
  PARAMETER G(L12_FCC,AL,NI:AL;1)  298.15   +3*L1ALNI;          6000 N !
  PARAMETER G(L12_FCC,AL,NI:NI;1)  298.15   +3*L1ALNI;          6000 N !
  PARAMETER G(L12_FCC,AL:AL,NI;0)  298.15   +L0ALNI;            6000 N !
  PARAMETER G(L12_FCC,NI:AL,NI;0)  298.15   +L0ALNI;            6000 N !
  PARAMETER G(L12_FCC,CR:AL,NI;0)  298.15   +L0ALNI;            6000 N !
  PARAMETER G(L12_FCC,AL:AL,NI;1)  298.15   +L1ALNI;            6000 N !
  PARAMETER G(L12_FCC,NI:AL,NI;1)  298.15   +L1ALNI;            6000 N !
  PARAMETER G(L12_FCC,CR:AL,NI;1)  298.15   +L1ALNI;            6000 N !
$
  PARAMETER G(L12_FCC,AL,CR:AL;0)  298.15   +6*U1ALCR;          6000 N !
  PARAMETER G(L12_FCC,AL,CR:CR;0)  298.15   +6*U1ALCR;          6000 N !
  PARAMETER G(L12_FCC,AL,CR:AL;1)  298.15   +3*L1ALCR;          6000 N !
  PARAMETER G(L12_FCC,AL,CR:CR;1)  298.15   +3*L1ALCR;          6000 N !
$
  PARAMETER G(L12_FCC,CR,NI:CR;0)  298.15   +6*U1CRNI;          6000 N !
  PARAMETER G(L12_FCC,CR,NI:NI;0)  298.15   +6*U1CRNI;          6000 N !
  PARAMETER G(L12_FCC,CR,NI:CR;1)  298.15   +3*L1CRNI;          6000 N !
  PARAMETER G(L12_FCC,CR,NI:NI;1)  298.15   +3*L1CRNI;          6000 N !


  PARAMETER G(L12_FCC,AL,CR:NI;0)  298.15   +6*U1ALCR;          6000 N !
  PARAMETER G(L12_FCC,AL,NI:CR;0)  298.15   +6*U1ALNI+9975;     6000 N !
  PARAMETER G(L12_FCC,CR,NI:AL;0)  298.15   +6*U1CRNI+9975;     6000 N !

  PARAMETER G(L12_FCC,AL,CR:NI;1)  298.15   0;                  6000 N !
  PARAMETER G(L12_FCC,AL,NI:CR;1)  298.15   -9975+3*L1ALNI;     6000 N !
  PARAMETER G(L12_FCC,CR,NI:AL;1)  298.15   -9975;              6000 N !

  PARAMETER G(L12_FCC,AL,CR,NI:AL;0)  298.15   -9975;           6000 N !
  PARAMETER G(L12_FCC,AL,CR,NI:CR;0)  298.15   -9975;           6000 N !
  PARAMETER G(L12_FCC,AL,CR,NI:NI;0)  298.15   +39900;          6000 N !



"""

ALNIPT_TDB = """
$
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5773E+03  2.8322E+01!
 ELEMENT NI   FCC_A1                    5.8690E+01  4.7870E+03  2.9796E+01!
 ELEMENT PT   FCC_A1                    1.9508E+02  5.7237E+03  4.1631E+01!

$$$$$$$$$$$$$$$$$XUAN

 FUNCTION VX1   298.15  -2.2745400E+04;   6000.0   N !
 FUNCTION VX2   298.15   7.5000000E-01;   6000.0   N !
 FUNCTION VX3   298.15   2.2500000E+04;   6000.0   N !
 FUNCTION VX10  298.15   4.1176252E+04;   6000.0   N !
 FUNCTION VX11  298.15  -3.3084025E+01;   6000.0   N !
 FUNCTION VX20  298.15   2.9968958E+03;   6000.0   N !
 FUNCTION VX40  298.15  -2.7046916E+05;   6000.0   N !
 FUNCTION VX41  298.15  -8.3384917E+00;   6000.0   N !
 FUNCTION VX42  298.15  -1.9293253E+04;   6000.0   N !
 FUNCTION VX43  298.15   2.4643347E+01;   6000.0   N !
 FUNCTION VX44  298.15   4.5967650E+04;   6000.0   N !
 FUNCTION VX50  298.15  -2.0570000E+05;   6000.0   N !
 FUNCTION VX51  298.15   1.2175000E+01;   6000.0   N !
 FUNCTION VX53  298.15  -5.0000000E+01;   6000.0   N !
 FUNCTION VX54  298.15   4.5000000E+04;   6000.0   N !
 FUNCTION VX85  298.15  -1.0118662E+05;   6000.0   N !
 FUNCTION VX90  298.15   6.0995004E+00;   6000.0   N !
 FUNCTION VX91  298.15   9.4351782E+00;   6000.0   N !
 FUNCTION VX92  298.15   5.2341182E+00;   6000.0   N !
 FUNCTION VX93  298.15   6.4125253E+00;   6000.0   N !
 FUNCTION VX94  298.15   6.9806493E+00;   6000.0   N !
 FUNCTION VX95  298.15   8.6920000E+00;   6000.0   N !
 FUNCTION VX96  298.15   9.3985666E+00;   6000.0   N !

 FUNCTION B2ALPT    298.15  -205700+12.18*T;   6000.0   N !
 FUNCTION LB2ALPT   298.15  -50*T;   6000.0   N !

 FUNCTION L1A2ALPT   298.15  45000;   6000.0   N !

 FUNCTION B2PTVA     298.15  B2ALVA-B2ALPT;   6000.0   N !
 FUNCTION LB2PTVA    298.15 -15000+5*T; 6000.00  N !

$$$$$$$$$$$$$$$$$$

 FUNCTION GHSERAL    2.98150E+02  -7976.15+137.093038*T-24.3671976*T*LN(T)
     -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1);  7.00000E+02  Y
      -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
     -5.764227E-06*T**3+74092*T**(-1);  9.33600E+02  Y
      -11278.378+188.684153*T-31.748192*T*LN(T)-1.231E+28*T**(-9);
     6.00000E+03  N !
 FUNCTION GBCCAL     2.98150E+02  +10083-4.813*T+GHSERAL#;   6.00000E+03  N !
 FUNCTION GALBCC     298.15  +10083-4.813*T+GHSERAL#;   6000.0   N
     !
 FUNCTION GLIQAL     2.98140E+02  +11005.029-11.841867*T+7.934E-20*T**7
     +GHSERAL#;  9.33590E+02  Y
      +10482.282-11.253974*T+1.231E+28*T**(-9)+GHSERAL#;  6.00000E+03  N !

 FUNCTION GHSERNI    2.98150E+02  -5179.159+117.854*T-22.096*T*LN(T)
     -.0048407*T**2;  1.72800E+03  Y
      -27840.655+279.135*T-43.1*T*LN(T)+1.12754E+31*T**(-9); 6.00000E+03  N !
 FUNCTION GBCCNI     2.98150E+02  +8715.084-3.556*T+GHSERNI#; 6.00000E+03 N !

 FUNCTION GHSERPT    2.98150E+02  -7595.631+124.388276*T-24.5526*T*LN(T)
     -.00248297*T**2-2.0138E-08*T**3+7974*T**(-1);  1.30000E+03  Y
      -9253.174+161.529616*T-30.2527*T*LN(T)+.002321665*T**2
     -6.56947E-07*T**3-272106*T**(-1);  2.04210E+03  Y
      -222518.973+1021.21087*T-136.422689*T*LN(T)+.020501692*T**2
     -7.60985E-07*T**3+71709819*T**(-1);  4.00000E+03  N !
 FUNCTION GBCCPT     2.98150E+02  +15000-2.4*T+GHSERPT#;   6.00000E+03   N!
 FUNCTION GPTBCC     298.15  +15000-2.4*T+GHSERPT#;  4.00000E+03  N !

 FUNCTION VA1  298.15    2.00000000E+05;,, N 05LU !
$$FUNCTION VA31 298.15    3.00000000E+04;,, N 05LU !

$$FUNCTION VA31 298.15    30000;,, N 05LU !
$$FUNCTION VA33 298.15    30000;,, N 05LU !
$$FUNCTION VA35 298.15    30000;,, N 05LU !

$$$$$$GAL2NIPT
 FUNCTION VA40 298.15   0;,, N 05LU !
$$$$$$GNI2ALPT
 FUNCTION VA42 298.15   0;,, N 05LU !
$$$$$$GPT2ALNI
 FUNCTION VA44 298.15   0;,, N 05LU !

$$$$$$LALNIALPT
 FUNCTION VA46 298.15    0;,, N 05LU !
$$$$$$LALNINIPT
 FUNCTION VA48 298.15    0;,, N 05LU !
$$$$$$LALPTNIPT
 FUNCTION VA50 298.15    0;,, N 05LU !




$$$THIS SET IS LIKE CALPHAD PAPER
$$FUNCTION VA42 298.15   +3000;,, N 05LU !
$$FUNCTION VA44 298.15   -3000;,, N 05LU !



$$FUNCTION VA70 298.15   -5.00000000E+04;,, N 05LU !
$$FUNCTION VA71 298.15    1.0e1;,, N 05LU !

FUNCTION VA70 298.15   -55000;,, N 05LU !
FUNCTION VA71 298.15    1.0;,, N 05LU !

FUNCTION VA76 298.15    7.00000000E+03;,, N 05LU !
FUNCTION VA77 298.15    2.00000000E+03;,, N 05LU !
FUNCTION VA78 298.15   -9.50000000E+04;,, N 05LU !
FUNCTION VA79 298.15    6.00000000E+00;,, N 05LU !
FUNCTION VA85 298.15   -4.50000000E+04;,, N 05LU !
FUNCTION VA86 298.15   0.0;,, N 05LU !
FUNCTION VA87 298.15   -5.00000000E+03;,, N 05LU !
FUNCTION VA88 298.15   0.0;,, N 05LU !
FUNCTION VA89 298.15   0.0;,, N 05LU !
FUNCTION VA90 298.15   0.0;,, N 05LU !
FUNCTION VA91 298.15   -9.80000000E+04;,, N 05LU !
FUNCTION VA92 298.15    6.00000000E+00;,, N 05LU !
FUNCTION VA93 298.15   -2.00000000E+04;,, N 05LU !
FUNCTION VA95 298.15    1.00000000E+05;,, N 05LU !
FUNCTION VA97 298.15    0.0;,, N 05LU !
FUNCTION VA98 298.15    0.0;,, N 05LU !
FUNCTION VA99 298.15    0.0;,, N 05LU !

FUNCTION VA2 298.15    0.0;,, N 05LU !
FUNCTION VA3 298.15    0.0;,, N 05LU !
FUNCTION VA4 298.15    0.0;,, N 05LU !
FUNCTION VA5 298.15    0.0;,, N 05LU !
FUNCTION VA6 298.15    0.0;,, N 05LU !
FUNCTION VA32 298.15    0.0;,, N 05LU !
FUNCTION VA33 298.15    0.0;,, N 05LU !
FUNCTION VA34 298.15    0.0;,, N 05LU !
FUNCTION VA35 298.15    0.0;,, N 05LU !
FUNCTION VA36 298.15    0.0;,, N 05LU !
FUNCTION VA74 298.15    0.0;,, N 05LU !
FUNCTION VA75 298.15    0.0;,, N 05LU !
FUNCTION VA80 298.15    0.0;,, N 05LU !
FUNCTION VA81 298.15    0.0;,, N 05LU !
FUNCTION VA60 298.15    0.0;,, N 05LU !
FUNCTION VA61 298.15    0.0;,, N 05LU !
FUNCTION VA62 298.15    0.0;,, N 05LU !
FUNCTION VA63 298.15    0.0;,, N 05LU !
FUNCTION VA64 298.15    0.0;,, N 05LU !
FUNCTION VA65 298.15    0.0;,, N 05LU !
FUNCTION VA66 298.15    0.0;,, N 05LU !
FUNCTION VA67 298.15    0.0;,, N 05LU !
FUNCTION VA72 298.15    0.0;,, N 05LU !
FUNCTION VA73 298.15    0.0;,, N 05LU !
FUNCTION VA94 298.15    0.0;,, N 05LU !
FUNCTION VA96 298.15    0.0;,, N 05LU !

 FUNCTION LLIQ2      298.15  +81204.81-31.95713*T;,,   N 95DUP3 !
 FUNCTION LLIQ3      298.15  +4365.35-2.51632*T;,,   N 95DUP3 !
 FUNCTION LLIQ4      298.15  -22101.64+13.16341*T;,,   N 95DUP3 !
 FUNCTION LLIQ0      298.15  -5*LLIQ2-9*LLIQ4;,,   N 95DUP3 !
 FUNCTION LLIQ1      298.15  -7*UNTIER*LLIQ3;,,   N 95DUP3 !
 FUNCTION DEUX       298.15  2;,,   N 95DUP3 !
 FUNCTION UNSURDEU   298.15  +DEUX**(-1);,,   N 95DUP3 !
 FUNCTION GB2NINI    298.15  +GBCCNI;,,   N 95DUP3 !
 FUNCTION GB2ALVA    298.15  +5000-.5*T+UNSURDEU*GBCCAL;,,  N 95DUP3 !
 FUNCTION GB2ALNI    298.15  -76198.65+13.202875*T
                             +UNSURDEU*GBCCAL+UNSURDEU*GBCCNI;,, N 95DUP3 !
 FUNCTION GB2NIVA    298.15  -GB2ALNI+GB2NINI+GB2ALVA;,,  N 95DUP3 !
 FUNCTION SIX        298.15  6;,,   N 95DUP3 !
 FUNCTION UNSURSIX   298.15  +SIX**(-1);,,   N 95DUP3 !
 FUNCTION GALALVA    298.15  +5000-.5*T+5*UNSURSIX*GBCCAL;,,  N 95DUP3 !
 FUNCTION GALNINI    298.15  +5000+GB2ALNI;,,   N 95DUP3 !
 FUNCTION GALNIVA    298.15  -59620.987+11.387*T
                     +3*UNSURSIX*GBCCAL+2*UNSURSIX*GBCCNI;,, N 95DUP3 !
 FUNCTION GALALNI    298.15  -GALNIVA+GALALVA+GALNINI;,,     N 95DUP3 !
 FUNCTION L32ALNI    298.15  -32247.363+21.965*T;,,   N 95DUP3 !
 FUNCTION L32NIVA    298.15  -3666.95+1.1722*T;,,   N 95DUP3 !
 FUNCTION U1ALNI     298.15  -13415.515+2.0819247*T;,,   N 95DUP3 !

 FUNCTION UALNI      298.15  -43590+6.22*T;,,   N 03SUN !
 FUNCTION ALPHA      298.15  -29600;,,   N 03SUN !
 FUNCTION BETA       298.15  -66718+11.64*T;,,   N 03SUN !
 FUNCTION AL3NI      298.15  ALPHA;,,   N 03SUN !
 FUNCTION AL2NI2     298.15  BETA;,,    N 03SUN !
 FUNCTION ALNI3      298.15  UALNI;,,   N 03SUN !

 FUNCTION URALNI     298.15  -34575+13.22*T;,,   N 03SUN !

 FUNCTION LFCC0      298.15  +AL3NI+1.5*AL2NI2+ALNI3+1.5*URALNI;,,  N 03SUN !
 FUNCTION LFCC1      298.15  +2*AL3NI-2*ALNI3;,,   N 03SUN !
 FUNCTION LFCC2      298.15  +AL3NI-1.5*AL2NI2+ALNI3-1.5*URALNI;,,  N 03SUN !
 FUNCTION LFCC3      298.15 0.0; 6000.00  N 03SUN !
 FUNCTION U3ALNI     298.15 0.0; 6000.00  N 03SUN !

 FUNCTION L0ALNI     298.15  5310-1.46*T;,,   N !
 FUNCTION UN_ASS 298.15 0; 300 N !

$****AL-PT
$ FUNCTION UAB        298.15  -13595+8.3*T;   6000   N !
$ FUNCTION UPT3AL     298.15  +3*UAB#-3913;   6000   N !
$ FUNCTION UALPT      298.15  +4*UAB#;   6000   N !
$ FUNCTION UALPT3     298.15  +3*UAB#;   6000   N !
$ FUNCTION UL0        298.15  +1412.8+5.7*T;   6000   N !
$ FUNCTION USRO       298.15  +UAB#;   6000   N !
$ FUNCTION ULD0       298.15  -110531-22.9*T;   6000   N !
$ FUNCTION ULD1       298.15  -25094;   6000   N !
$ FUNCTION ULD2       298.15  +21475;   6000   N !
$ FUNCTION DG0        298.15  +UALPT3#+1.5*UALPT#+UPT3AL#;   6000
$       N !
$ FUNCTION DG1        298.15  +2*UALPT3#-2*UPT3AL#;   6000   N !
$ FUNCTION DG2        298.15  +UALPT3#-1.5*UALPT#+UPT3AL#;   6000
$       N !

 FUNCTION APL0FCC    2.98150E+02  +41176.252-33.084025*T;   6.00000E+03   N !
 FUNCTION APL1FCC    298.15  0;   6000 N !
 FUNCTION APL2FCC    298.15  0;   6000 N !
 FUNCTION APL3FCC    298.15  0;   6000 N !

 FUNCTION RAL3PT1     2.98150E+02  +3*UALPT#+APALP#;   6.00000E+03   N !
 FUNCTION RAL2PT2    2.98150E+02  +4*UALPT#;   6.00000E+03   N !
 FUNCTION RAL1PT3     2.98150E+02  +3*UALPT#+APBET#;   6.00000E+03   N !
 FUNCTION UALPT      2.98150E+02  -22745.4+0.75*T;   6.00000E+03   N !
 FUNCTION RECALPT    2.98150E+02  0;   6.00000E+03   N !

 FUNCTION APALP      2.98150E+02  +22500;   6.00000E+03   N !
 FUNCTION APBET       2.98150E+02  0;   6.00000E+03   N !

 FUNCTION GAL3PT1  298.15 RAL3PT1-0.1875*APL0FCC-0.09375*APL1FCC
     -0.046875*APL2FCC-0.0234375*APL3FCC; 6000 N !
 FUNCTION GAL2PT2  298.15 RAL2PT2-0.25*APL0FCC; 6000 N !
 FUNCTION GAL1PT3  298.15 RAL1PT3-0.1875*APL0FCC+0.09375*APL1FCC
     -0.046875*APL2FCC+0.0234375*APL3FCC; 6000 N !

 FUNCTION ALPTG0     2.98150E+02  +GAL3PT1#+1.5*GAL2PT2#+GAL1PT3#;
     6.00000E+03   N !
 FUNCTION ALPTG1     2.98150E+02  +2*GAL3PT1#-2*GAL1PT3#;   6.00000E+03   N !
 FUNCTION ALPTG2     2.98150E+02  +GAL3PT1#-1.5*GAL2PT2#+GAL1PT3#;
     6.00000E+03   N !

 FUNCTION UL0 298.15  0;   6000   N !
 FUNCTION UL1        2.98150E+02  2996.8958;   6.00000E+03   N !

$ UAP only used in ternary
 FUNCTION UAP 298.15  +UALPT;   6000   N !
 FUNCTION REC       2.98150E+02  +UALPT#+RECALPT#;   6.00000E+03   N !

$*****NI-PT
 FUNCTION L0FCC    298.15  27500+10.977*T;   6000 N !
 FUNCTION L1FCC    298.15  -6500;   6000 N !
 FUNCTION L2FCC    298.15  0;   6000 N !
 FUNCTION L3FCC    298.15  0;   6000 N !

 FUNCTION RNI3PT1  298.15 -1.09000000E+04; 6000 N !
 FUNCTION RNI2PT2  298.15 -1.35000000E+04-0.5*T; 6000 N !
 FUNCTION RNI1PT3  298.15 -8.30000000E+03-0.5*T; 6000 N !

 FUNCTION GNI3PT1  298.15 RNI3PT1-0.1875*L0FCC-0.09375*L1FCC
     -0.046875*L2FCC-0.0234375*L3FCC; 6000 N !
 FUNCTION GNI2PT2  298.15 RNI2PT2-0.25*L0FCC; 6000 N !
 FUNCTION GNI1PT3  298.15 RNI1PT3-0.1875*L0FCC+0.09375*L1FCC
     -0.046875*L2FCC+0.0234375*L3FCC; 6000 N !

 FUNCTION NIPTG0     2.98150E+02  +GNI3PT1#+1.5*GNI2PT2#+GNI1PT3#;
     6.00000E+03   N !
 FUNCTION NIPTG1     2.98150E+02  +2*GNI3PT1#-2*GNI1PT3#;   6.00000E+03   N !
 FUNCTION NIPTG2     2.98150E+02  +GNI3PT1#-1.5*GNI2PT2#+GNI1PT3#;
     6.00000E+03   N !

 FUNCTION RECNINI  298.15 -3.67000000E+03; 6000 N !
 FUNCTION RECNIPT  298.15 -3.25000000E+03; 6000 N !
 FUNCTION RECPTPT  298.15 -2.73000000E+03; 6000 N !

$*****NI-AL-PT
 FUNCTION TROIS      2.98150E+02  3;   6.00000E+03   N !
 FUNCTION UNTIER     2.98150E+02  +TROIS#**(-1);   6.00000E+03   N !
 FUNCTION GNIPT 298.15 GNI3PT1#*UNTIER#; 6000 N !
 FUNCTION GAL2NIPT 298.15 2*UAP#+2*U1ALNI#+GNIPT#+VA40+VA41*T; 6000 N !
 FUNCTION GNI2ALPT 298.15 2*U1ALNI#+2*GNIPT#+UAP#+VA42+VA43*T; 6000 N !
 FUNCTION GPT2ALNI 298.15 2*GNIPT#+2*UAP#+U1ALNI#+VA44+VA45*T; 6000 N !
 FUNCTION LALNIALPT 298.15 0.5*U1ALNI+0.5*UAP-0.5*GNIPT+VA46+VA47*T; 6000 N !
 FUNCTION LALNINIPT 298.15 0.5*U1ALNI-0.5*UAP+0.5*GNIPT+VA48+VA49*T; 6000 N !
 FUNCTION LALPTNIPT 298.15 -0.5*U1ALNI+0.5*UAP+0.5*GNIPT+VA50+VA51*T; 6000 N !
$***************

 TYPE_DEFINITION % SEQ *!
$ DEFINE_SYSTEM_DEFAULT ELEMENT 4 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA !


$******************************** Liquid

 PHASE LIQUID:L %  1  1.0  !
    CONSTITUENT LIQUID:L :AL,NI,PT :  !

   PARAMETER G(LIQUID,AL;0)  2.98150E+02  +11005.029-11.841867*T
      +7.934E-20*T**7+GHSERAL#;  9.33600E+02  Y
      +10482.282-11.253974*T+1.231E+28*T**(-9)+GHSERAL#;  6.00000E+03  N
      91DIN !
   PARAMETER G(LIQUID,NI;0)  2.98130E+02  +16414.686-9.397*T
      -3.82318E-21*T**7+GHSERNI#;  1.72800E+03  Y
      +18290.88-10.537*T-1.12754E+31*T**(-9)+GHSERNI#;  6.00E+03  N 91DIN !
   PARAMETER G(LIQUID,PT;0)  2.98150E+02  +12520.614+115.114727*T
      -24.5526*T*LN(T)-.00248297*T**2-2.0138E-08*T**3+7974*T**(-1); 6.0E+02
       Y
    +19019.913+33.017485*T-12.351404*T*LN(T)-.011543133*T**2+9.30579E-07*T**3
      -600885*T**(-1);  2.04210E+03  Y
      +1404.968+205.861909*T-36.5*T*LN(T);  4.00000E+03  N REF283 !

   PARAMETER L(LIQUID,AL,NI;0)  298.15  +LLIQ0;,,   N 95DUP3 !
   PARAMETER L(LIQUID,AL,NI;1)  298.15  +LLIQ1;,,   N 95DUP3 !
   PARAMETER L(LIQUID,AL,NI;2)  298.15  +LLIQ2;,,   N 95DUP3 !
   PARAMETER L(LIQUID,AL,NI;3)  298.15  +LLIQ3;,,   N 95DUP3 !
   PARAMETER L(LIQUID,AL,NI;4)  298.15  +LLIQ4;,,   N 95DUP3 !

  PARAMETER L(liquid,ni,pt;0) 2.98150E+02 -4.07756E+04;
         6.00000E+03 N 05LU !
  PARAMETER L(liquid,ni,pt;1) 2.98150E+02 -5.5E+03; 6.00000E+03 N 05LU !
  PARAMETER L(liquid,ni,pt;2) 2.98150E+02 3.50E+03; 6.00000E+03 N 05LU !

  PARAMETER L(liquid,al,ni,pt;0) 2.98150E+02 +VA1+VA2*T;
        6.00000E+03 N 05LU !
  PARAMETER L(liquid,al,ni,pt;1) 2.98150E+02 +VA3+VA4*T;
      6.00000E+03 N 05LU !
  PARAMETER L(liquid,al,ni,pt;2) 2.98150E+02 +VA5+VA6*T;
      6.00000E+03 N 05LU !

   PARAMETER G(LIQUID,AL,PT;0)  298.15  +VX40#+VX41#*T;   6000.0   N
  REF0 !
   PARAMETER G(LIQUID,AL,PT;1)  298.15  +VX42#+VX43#*T;   6000.0   N
  REF0 !
   PARAMETER G(LIQUID,AL,PT;2)  298.15  +VX44#+VX45#*T;   6000.0   N
  REF0 !
   PARAMETER G(LIQUID,AL,PT;3)  298.15  +VX46#+VX47#*T;   6000.0   N
  REF0 !

$*********************  FCC_A1

 TYPE_DEFINITION ( GES A_P_D FCC_A1 MAGNETIC  -3.0    2.80000E-01 !
 PHASE FCC_A1  %(  2 1   1 !
    CONSTITUENT FCC_A1  :AL,NI%,PT : VA% :  !

   PARAMETER G(FCC_A1,AL:VA;0)  2.98150E+02  +GHSERAL#;  6.00000E+03  N
     91DIN !
   PARAMETER G(FCC_A1,NI:VA;0)  2.98150E+02  +GHSERNI#;  6.00000E+03  N
     91DIN !
   PARAMETER G(FCC_A1,PT:VA;0)  2.98150E+02  +GHSERPT#;  4.00000E+03  N
  REF283 !
$   PARAMETER TC(FCC_A1,PT:VA;0)  2.98150E+02  -307.85;   6.00000E+03
$   N REF0 !
   PARAMETER TC(FCC_A1,NI:VA;0)  2.98150E+02  633;   6.00000E+03   N 89DIN !
   PARAMETER BMAGN(FCC_A1,NI:VA;0)  2.98150E+02  .52;   6.00000E+03 N 89DIN !
$  PARAMETER L(fcc_a1,al,pt:va;0) 2.98150E+02 -262446.89; 2.90000E+03 N !
$  PARAMETER L(fcc_a1,al,pt:va;1) 2.9815E+02 102728.95-8.57*T; 2.90000E+03 N
$     REF01!
   PARAMETER TC(FCC_A1,AL,NI:VA;0)  2.98150E+02  -1112;   6.00000E+03   N
  95DUP3   !
   PARAMETER TC(FCC_A1,AL,NI:VA;1)  2.98150E+02  1745;   6.00000E+03   N
  95DUP3   !

   PARAMETER L(FCC_A1,AL,NI:VA;0)  298.15  +LFCC0+4*L0ALNI;,, N  03SUN !
   PARAMETER L(FCC_A1,AL,NI:VA;1)  298.15  +LFCC1;,,          N  03SUN !
   PARAMETER L(FCC_A1,AL,NI:VA;2)  298.15  +LFCC2;,,          N  03SUN !
   PARAMETER L(FCC_A1,AL,NI:VA;3)  298.15  +LFCC3;,,          N  03SUN !

  PARAMETER L(fcc_a1,ni,pt:va;0) 2.98150E+02 +L0FCC+NIPTG0+0.375*RECNINI
      +0.75*RECNIPT#+0.375*RECPTPT#; 6.00000E+03 N 05LU !
  PARAMETER L(fcc_a1,ni,pt:va;1) 2.98150E+02 +L1FCC+NIPTG1+0.75*RECNINI#
      -0.75*RECPTPT#; 6.00000E+03 N 05LU !
  PARAMETER L(fcc_a1,ni,pt:va;2) 2.98150E+02 +L2FCC+NIPTG2-1.5*RECNIPT#;
      6.00000E+03 N 05LU !
  PARAMETER L(fcc_a1,ni,pt:va;3) 2.98150E+02 +L3FCC-0.75*RECNINI#
      +0.75*RECPTPT#; 6.00000E+03 N 05LU !
  PARAMETER L(fcc_a1,ni,pt:va;4) 2.98150E+02 -0.375*RECNINI#+0.75*RECNIPT#
      -0.375*RECPTPT#; 6.0E+03 N 05LU !

  PARAMETER L(fcc_a1,al,ni,pt:va;0) 2.98150E+02 +VA31+VA32*T;
    6.00000E+03 N 05LU !
  PARAMETER L(fcc_a1,al,ni,pt:va;1) 2.98150E+02 +VA33+VA34*T;
    6.00000E+03 N 05LU !
  PARAMETER L(fcc_a1,al,ni,pt:va;2) 2.98150E+02 +VA35+VA36*T;
    6.00000E+03 N 05LU !

   PARAMETER G(FCC_A1,AL,PT:VA;0)  298.15  +APL0FCC#+ALPTG0#+1.5*REC#;
  6000   N REF0 !
   PARAMETER G(FCC_A1,AL,PT:VA;1)  298.15  +APL1FCC#+ALPTG1#;   6000   N
  REF0 !
   PARAMETER G(FCC_A1,AL,PT:VA;2)  298.15  +APL2FCC#+ALPTG2#-1.5*REC#;
  6000   N REF0 !
   PARAMETER G(FCC_A1,AL,PT:VA;3)  298.15  +APL3FCC#;
  6000   N REF0 !


$************FCC_L12
 TYPE_DEFINITION * GES AMEND_PHASE_DESCRIPTION FCC_L12 DIS_PART FCC_A1,,,!
$ TYPE_DEFINITION M GES A_P_D FCC_L12 C_S 2 NI:NI:NI:PT:VA !
$ TYPE_DEFINITION P GES A_P_D FCC_L12 C_S 3 NI:NI:PT:PT:VA !
$ TYPE_DEFINITION Q GES A_P_D FCC_L12 C_S 4 NI:PT:PT:PT:VA !
 PHASE FCC_L12  %*  5 .25 .25 .25 .25   1 !
    CONSTITUENT FCC_L12  :AL,NI,PT:AL,NI,PT:AL,NI,PT:AL,NI,PT:VA%:  !

       PARA G(FCC_L12,AL:AL:AL:AL:VA;0) 298.15 0; 6000 N!
       PARA G(FCC_L12,NI:NI:NI:NI:VA;0) 298.15 0; 6000 N!
       PARA G(FCC_L12,PT:PT:PT:PT:VA;0) 298.15 0; 6000 N!

   PARAMETER G(FCC_L12,NI:AL:AL:AL:VA;0)  298.15  +AL3NI;  ,,   N 03SUN !
   PARAMETER G(FCC_L12,AL:NI:AL:AL:VA;0)  298.15  +AL3NI;  ,,   N 03SUN !
   PARAMETER G(FCC_L12,NI:NI:AL:AL:VA;0)  298.15  +AL2NI2; ,,   N 03SUN !
   PARAMETER G(FCC_L12,AL:AL:NI:AL:VA;0)  298.15  +AL3NI;  ,,   N 03SUN !
   PARAMETER G(FCC_L12,NI:AL:NI:AL:VA;0)  298.15  +AL2NI2; ,,   N 03SUN !
   PARAMETER G(FCC_L12,AL:NI:NI:AL:VA;0)  298.15  +AL2NI2; ,,   N 03SUN !
   PARAMETER G(FCC_L12,NI:NI:NI:AL:VA;0)  298.15  +ALNI3;  ,,   N 03SUN !
   PARAMETER G(FCC_L12,AL:AL:AL:NI:VA;0)  298.15  +AL3NI;  ,,   N 03SUN !
   PARAMETER G(FCC_L12,NI:AL:AL:NI:VA;0)  298.15  +AL2NI2; ,,   N 03SUN !
   PARAMETER G(FCC_L12,AL:NI:AL:NI:VA;0)  298.15  +AL2NI2; ,,   N 03SUN !
   PARAMETER G(FCC_L12,NI:NI:AL:NI:VA;0)  298.15  +ALNI3;  ,,   N 03SUN !
   PARAMETER G(FCC_L12,AL:AL:NI:NI:VA;0)  298.15  +AL2NI2; ,,   N 03SUN !
   PARAMETER G(FCC_L12,NI:AL:NI:NI:VA;0)  298.15  +ALNI3;  ,,   N 03SUN !
   PARAMETER G(FCC_L12,AL:NI:NI:NI:VA;0)  298.15  +ALNI3;  ,,   N 03SUN !

   PARAMETER G(FCC_L12,PT:AL:AL:AL:VA;0)  298.15  +GAL3PT1#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,AL:PT:AL:AL:VA;0)  298.15  +GAL3PT1#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,PT:PT:AL:AL:VA;0)  298.15  +GAL2PT2#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,AL:AL:PT:AL:VA;0)  298.15  +GAL3PT1#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,PT:AL:PT:AL:VA;0)  298.15  +GAL2PT2#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,AL:PT:PT:AL:VA;0)  298.15  +GAL2PT2#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,PT:PT:PT:AL:VA;0)  298.15  +GAL1PT3#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,AL:AL:AL:PT:VA;0)  298.15  +GAL3PT1#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,PT:AL:AL:PT:VA;0)  298.15  +GAL2PT2#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,AL:PT:AL:PT:VA;0)  298.15  +GAL2PT2#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,PT:PT:AL:PT:VA;0)  298.15  +GAL1PT3#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,AL:AL:PT:PT:VA;0)  298.15  +GAL2PT2#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,PT:AL:PT:PT:VA;0)  298.15  +GAL1PT3#;
	3000  N  REF0 !
   PARAMETER G(FCC_L12,AL:PT:PT:PT:VA;0)  298.15  +GAL1PT3#;
	3000  N  REF0 !

   PARAMETER G(FCC_L12,PT:NI:NI:NI:VA;0)  2.98150E+02  +GNI3PT1#;
6.0E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:NI:NI:VA;0)  2.98150E+02  +GNI3PT1#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:PT:NI:NI:VA;0)  2.98150E+02  +GNI2PT2#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:NI:PT:NI:VA;0)  2.98150E+02  +GNI3PT1#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:NI:PT:NI:VA;0)  2.98150E+02  +GNI2PT2#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:PT:NI:VA;0)  2.98150E+02  +GNI2PT2#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:PT:PT:NI:VA;0)  2.98150E+02  +GNI1PT3#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:NI:NI:PT:VA;0)  2.98150E+02  +GNI3PT1#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:NI:NI:PT:VA;0)  2.98150E+02  +GNI2PT2#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:NI:PT:VA;0)  2.98150E+02  +GNI2PT2#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:PT:NI:PT:VA;0)  2.98150E+02  +GNI1PT3#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:NI:PT:PT:VA;0)  2.98150E+02  +GNI2PT2#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:NI:PT:PT:VA;0)  2.98150E+02  +GNI1PT3#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:PT:PT:VA;0)  2.98150E+02  +GNI1PT3#;
6E+03 N 05LU !

   PARAMETER G(FCC_L12,NI:NI:AL:PT:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:NI:PT:AL:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:AL:NI:PT:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:NI:AL:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:AL:PT:NI:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:AL:NI:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:PT:NI:NI:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:AL:NI:NI:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:NI:PT:NI:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:NI:AL:NI:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:NI:NI:PT:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:NI:NI:AL:VA;0)  2.98150E+02  +GNI2ALPT#;
6E+03 N 05LU !

   PARAMETER G(FCC_L12,AL:AL:NI:PT:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:AL:PT:NI:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:NI:AL:PT:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:PT:AL:NI:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:NI:PT:AL:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:PT:NI:AL:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:AL:AL:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:NI:AL:AL:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:AL:PT:AL:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:AL:NI:AL:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:AL:AL:PT:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:AL:AL:NI:VA;0)  2.98150E+02  +GAL2NIPT#;
6E+03 N 05LU !

   PARAMETER G(FCC_L12,PT:PT:NI:AL:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:PT:AL:NI:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:NI:PT:AL:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:AL:PT:NI:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:NI:AL:PT:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,PT:AL:NI:PT:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:AL:PT:PT:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:NI:PT:PT:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:AL:PT:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:PT:NI:PT:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI:PT:PT:AL:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL:PT:PT:NI:VA;0)  2.98150E+02  +GPT2ALNI#;
6E+03 N 05LU !

   PARAMETER L(FCC_L12,AL,NI:*:*:*:VA;0)  298.15  +L0ALNI;    ,,   N 03SUN !
   PARAMETER L(FCC_L12,*:AL,NI:*:*:VA;0)  298.15  +L0ALNI;    ,,   N 03SUN !
   PARAMETER L(FCC_L12,*:*:AL,NI:*:VA;0)  298.15  +L0ALNI;    ,,   N 03SUN !
   PARAMETER L(FCC_L12,*:*:*:AL,NI:VA;0)  298.15  +L0ALNI;    ,,   N 03SUN !

   PARAMETER G(FCC_L12,AL,PT:*:*:*:VA;0)  298.15  +UL0#;  3000  N REF0 !
   PARAMETER G(FCC_L12,*:AL,PT:*:*:VA;0)  298.15  +UL0#;  3000  N REF0 !
   PARAMETER G(FCC_L12,*:*:AL,PT:*:VA;0)  298.15  +UL0#;  3000  N REF0 !
   PARAMETER G(FCC_L12,*:*:*:AL,PT:VA;0)  298.15  +UL0#;  3000  N REF0 !

   PARAMETER G(FCC_L12,AL,PT:*:*:*:VA;1)  298.15  +UL1#;  3000  N REF0 !
   PARAMETER G(FCC_L12,*:AL,PT:*:*:VA;1)  298.15  +UL1#;  3000  N REF0 !
   PARAMETER G(FCC_L12,*:*:AL,PT:*:VA;1)  298.15  +UL1#;  3000  N REF0 !
   PARAMETER G(FCC_L12,*:*:*:AL,PT:VA;1)  298.15  +UL1#;  3000  N REF0 !


   PARAMETER G(FCC_L12,AL,PT:AL,PT:*:*:VA;0)  298.15  +REC#; 3000  N REF0 !
   PARAMETER G(FCC_L12,AL,PT:*:AL,PT:*:VA;0)  298.15  +REC#; 3000  N REF0 !
   PARAMETER G(FCC_L12,AL,PT:*:*:AL,PT:VA;0)  298.15  +REC#; 3000  N REF0 !
   PARAMETER G(FCC_L12,*:AL,PT:AL,PT:*:VA;0)  298.15  +REC#; 3000  N REF0 !
   PARAMETER G(FCC_L12,*:AL,PT:*:AL,PT:VA;0)  298.15  +REC#; 3000  N REF0 !
   PARAMETER G(FCC_L12,*:*:AL,PT:AL,PT:VA;0)  298.15  +REC#; 3000  N REF0 !

   PARAMETER L(FCC_L12,*:*:AL,NI:AL,NI:VA;0)  298.15  +URALNI;,,   N 03SUN !
   PARAMETER L(FCC_L12,*:AL,NI:*:AL,NI:VA;0)  298.15  +URALNI;,,   N 03SUN !
   PARAMETER L(FCC_L12,AL,NI:*:*:AL,NI:VA;0)  298.15  +URALNI;,,   N 03SUN !
   PARAMETER L(FCC_L12,*:AL,NI:AL,NI:*:VA;0)  298.15  +URALNI;,,   N 03SUN !
   PARAMETER L(FCC_L12,AL,NI:*:AL,NI:*:VA;0)  298.15  +URALNI;,,   N 03SUN !
   PARAMETER L(FCC_L12,AL,NI:AL,NI:*:*:VA;0)  298.15  +URALNI;,,   N 03SUN !

   PARAMETER G(FCC_L12,NI:NI:NI,PT:NI,PT:VA;0)  2.98150E+02  RECNINI;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI:NI,PT:NI:NI,PT:VA;0)  2.98150E+02  RECNINI;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI:NI,PT:NI,PT:NI:VA;0)  2.98150E+02  RECNINI;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI:NI:NI,PT:VA;0)  2.98150E+02  RECNINI;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI:NI,PT:NI:VA;0)  2.98150E+02  RECNINI;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI,PT:NI:NI:VA;0)  2.98150E+02  RECNINI;
  6.00000E+03   N  05LU !

   PARAMETER G(FCC_L12,PT:PT:NI,PT:NI,PT:VA;0)  2.98150E+02  RECPTPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,PT:NI,PT:PT:NI,PT:VA;0)  2.98150E+02  RECPTPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,PT:NI,PT:NI,PT:PT:VA;0)  2.98150E+02  RECPTPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:PT:PT:NI,PT:VA;0)  2.98150E+02  RECPTPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:PT:NI,PT:PT:VA;0)  2.98150E+02  RECPTPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI,PT:PT:PT:VA;0)  2.98150E+02  RECPTPT;
  6.00000E+03   N  05LU !

   PARAMETER G(FCC_L12,AL:AL:NI,PT:NI,PT:VA;0) 2.98150E+02 RECPTPT+VA74+VA75*T;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,AL:NI,PT:AL:NI,PT:VA;0) 2.98150E+02 RECPTPT+VA74+VA75*T;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,AL:NI,PT:NI,PT:AL:VA;0) 2.98150E+02 RECPTPT+VA74+VA75*T;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:AL:AL:NI,PT:VA;0) 2.98150E+02 RECPTPT+VA74+VA75*T;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:AL:NI,PT:AL:VA;0) 2.98150E+02 RECPTPT+VA74+VA75*T;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI,PT:AL:AL:VA;0) 2.98150E+02 RECPTPT+VA74+VA75*T;
  6.00000E+03   N  05LU !

   PARAMETER G(FCC_L12,NI:PT:NI,PT:NI,PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,PT:NI:NI,PT:NI,PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI:NI,PT:PT:NI,PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,PT:NI,PT:NI:NI,PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI:NI,PT:NI,PT:PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,PT:NI,PT:NI,PT:NI:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI:PT:NI,PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:PT:NI:NI,PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI:NI,PT:PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:PT:NI,PT:NI:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI,PT:NI:PT:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI,PT:PT:NI:VA;0)  2.98150E+02  RECNIPT;
  6.00000E+03   N  05LU !

   PARAMETER G(FCC_L12,NI,PT:NI,PT:AL:NI:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI,PT:NI:AL:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:AL:NI:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI:AL:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:AL:NI,PT:NI:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI:NI,PT:AL:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,AL:NI:NI,PT:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI:AL:NI,PT:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,AL:NI,PT:NI,PT:NI:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI:NI,PT:NI,PT:AL:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,AL:NI,PT:NI:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI:NI,PT:AL:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA76;
  6.00000E+03   N  05LU !

   PARAMETER G(FCC_L12,NI,PT:NI,PT:AL:PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:NI,PT:PT:AL:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:AL:PT:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:PT:AL:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:AL:NI,PT:PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,NI,PT:PT:NI,PT:AL:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,AL:PT:NI,PT:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,PT:AL:NI,PT:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,AL:NI,PT:NI,PT:PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,PT:NI,PT:NI,PT:AL:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,AL:NI,PT:PT:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !
   PARAMETER G(FCC_L12,PT:NI,PT:AL:NI,PT:VA;0)  2.98150E+02  RECNIPT+VA77;
  6.00000E+03   N  05LU !

   PARAMETER G(FCC_L12,AL,NI:AL,PT:*:*:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,PT:AL,NI:*:*:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,NI:*:AL,PT:*:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,PT:*:AL,NI:*:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,NI:*:*:AL,PT:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,PT:*:*:AL,NI:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,NI:AL,PT:*:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,PT:AL,NI:*:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:*:AL,NI:AL,PT:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:*:AL,PT:AL,NI:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,NI:*:AL,PT:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,PT:*:AL,NI:VA;0) 2.9815E+02  LALNIALPT;
6E+03 N 05LU !

   PARAMETER G(FCC_L12,AL,NI:NI,PT:*:*:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI,PT:AL,NI:*:*:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,NI:*:NI,PT:*:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI,PT:*:AL,NI:*:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,NI:*:*:NI,PT:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI,PT:*:*:AL,NI:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:*:AL,NI:NI,PT:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:*:NI,PT:AL,NI:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,NI:*:NI,PT:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:NI,PT:*:AL,NI:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,NI:NI,PT:*:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:NI,PT:AL,NI:*:VA;0) 2.9815E+02  LALNINIPT;
6E+03 N 05LU !

   PARAMETER G(FCC_L12,AL,PT:NI,PT:*:*:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI,PT:AL,PT:*:*:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,PT:*:NI,PT:*:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI,PT:*:AL,PT:*:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,PT:*:*:NI,PT:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,NI,PT:*:*:AL,PT:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:*:AL,PT:NI,PT:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:*:NI,PT:AL,PT:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,PT:*:NI,PT:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:NI,PT:*:AL,PT:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,PT:NI,PT:*:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:NI,PT:AL,PT:*:VA;0) 2.9815E+02  LALPTNIPT;
6E+03 N 05LU !

   PARAMETER G(FCC_L12,AL,NI,PT:AL,NI,PT:*:*:VA;0) 2.9815E+02
         VA80+VA81*T; 6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,NI,PT:*:AL,NI,PT:*:VA;0) 2.9815E+02
         VA80+VA81*T; 6E+03 N 05LU !
   PARAMETER G(FCC_L12,AL,NI,PT:*:*:AL,NI,PT:VA;0) 2.9815E+02
         VA80+VA81*T; 6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,NI,PT:AL,NI,PT:*:VA;0) 2.9815E+02
         VA80+VA81*T; 6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:AL,NI,PT:*:AL,NI,PT:VA;0) 2.9815E+02
         VA80+VA81*T; 6E+03 N 05LU !
   PARAMETER G(FCC_L12,*:*:AL,NI,PT:AL,NI,PT:VA;0) 2.9815E+02
         VA80+VA81*T; 6E+03 N 05LU !
$***********AL3NI1
 PHASE AL3NI1  %  2 .75   .25 !
    CONSTITUENT AL3NI1  :AL : NI :  !

   PARAMETER G(AL3NI1,AL:NI;0)  2.98150E+02  -48483.73+12.29913*T
  +.75*GHSERAL#+.25*GHSERNI#;   6.00000E+03   N 95DUP3   !

$******************** AL3NI2

 PHASE AL3NI2  %  3 3   2   1 !
    CONSTITUENT AL3NI2  :AL : AL,NI%,PT : NI,VA% :  !

   PARAMETER G(AL3NI2,AL:AL:NI;0)  298.15  +6*GALALNI;,,     N  95DUP3 !
   PARAMETER G(AL3NI2,AL:NI:NI;0)  298.15  +6*GALNINI;,,     N  95DUP3 !
   PARAMETER G(AL3NI2,AL:AL:VA;0)  298.15  +6*GALALVA;,,     N  95DUP3 !
   PARAMETER G(AL3NI2,AL:NI:VA;0)  298.15  +6*GALNIVA;,,     N  95DUP3 !

   PARAMETER G(AL3NI2,AL:PT:NI;0)  2.98150E+02  +3*GBCCAL#+GBCCNI#+2*GBCCPT#
  +VA60+VA61*T;   6.00000E+03   N  05LU !
   PARAMETER G(AL3NI2,AL:PT:VA;0)  2.98150E+02  VA62+VA63*T
  +3*GBCCAL#+2*GBCCPT#;   6.00000E+03  N 05LU  !

   PARAMETER L(AL3NI2,AL:AL,NI:*;0)  298.15  +6*L32ALNI;,,     N 95DUP3  !
   PARAMETER L(AL3NI2,AL:*:NI,VA;0)  298.15  +6*L32NIVA;,,     N 95DUP3  !

   PARAMETER G(AL3NI2,AL:NI,PT:*;0)  2.98150E+02  VA64+VA65*T;
  6.00000E+03   N 05LU !
   PARAMETER G(AL3NI2,AL:AL,PT:*;0)  2.98150E+02  VA66+VA67*T;
  6.00000E+03   N 05LU !

$******************** AL3NI5

 PHASE AL3NI5  %  2 .375   .625 !
    CONSTITUENT AL3NI5  :AL : NI :  !

   PARAMETER G(AL3NI5,AL:NI;0)  298.15  -66520+18.9*T
                                +.375*GHSERAL+.625*GHSERNI;,,   N 03SUN !

$   PARAMETER G(AL3NI5,AL:NI;0)  2.98150E+02  +.375*GHSERAL#+.625*GHSERNI#
$  -55507.7594+7.2648103*T;   6.00000E+03   N 95DUP3   !

$***************************** BCC_A2

 FUNCTION B2ORDER   298.15  0.5*B2ALPT-0.5*LB2ALPT;   6000.0   N !
 FUNCTION L0A2ALPT  298.15  B2ALPT+LB2ALPT;   6000.0   N !


$****************** BCC_B2
 PHASE BCC_B2  % 3 .5   .5   3 !
    CONSTITUENT BCC_B2  :AL,NI%,PT,VA : AL%,NI,PT,VA : VA :  !

  PARA G(BCC_B2,AL:AL:VA;0) 298.15 +GBCCAL; 6000 N 91DIN !
  PARA G(BCC_B2,NI:NI:VA;0) 298.15 +GBCCNI; 6000 N  91DIN !
  PARA G(BCC_B2,PT:PT:VA;0) 298.15 +GBCCPT; 6000 N  91DIN !
  PARA G(BCC_B2,VA:VA:VA;0) 298.15 0; 6000 N !
 PARAMETER TC(BCC_B2,NI:VA:VA;0)  298.15  575;,, N 89DIN !
 PARAMETER BMAGN(BCC_B2,NI:VA:VA;0)  298.15  .85;,, N 89DIN !

   FUNCTION B2ALNI 295.15 -152397.3+26.40575*T;,, N 95DUP3 !
PARA G(BCC_B2,NI:AL:VA;0) 2.9815E+02 +.5*GBCCAL+.5*GBCCNI+.5*B2ALNI;
6000 N 95DUP3 !
PARA G(BCC_B2,AL:NI:VA;0) 2.9815E+02 +.5*GBCCAL+.5*GBCCNI+.5*B2ALNI;
6000 N 95DUP3 !

   FUNCTION B2ALVA 295.15 10000-T;,,N  95DUP3 !
PARA G(BCC_B2,VA:AL:VA;0) 2.9815E+02 +0.5*GBCCAL+.5*B2ALVA; 6000 N 95DUP3 !
PARA G(BCC_B2,AL:VA:VA;0) 2.9815E+02 +0.5*GBCCAL+.5*B2ALVA; 6000 N 95DUP3 !

   PARAMETER G(BCC_B2,AL:PT:VA;0)  2.98150E+02  +.5*GALBCC#+.5*GPTBCC#
  +.5*B2ALPT#;   6.00000E+03   N REF11 !
   PARAMETER G(BCC_B2,PT:AL:VA;0)  2.98150E+02  +.5*GALBCC#+.5*GPTBCC#
  +.5*B2ALPT#;   6.00000E+03   N REF11 !

   FUNCTION B2NIVA 295.15 +162397.3-27.40575*T;,, N 95DUP3 !
PARA G(BCC_B2,VA:NI:VA;0) 2.9815E+02  +.5*GBCCNI+.5*B2NIVA; 6000 N 95DUP3 !
PARA G(BCC_B2,NI:VA:VA;0) 2.9815E+02  +.5*GBCCNI+.5*B2NIVA; 6000 N 95DUP3 !

PARA G(BCC_B2,PT:NI:VA;0) 2.9815E+02  +.5*GBCCNI+.5*GBCCPT+VA93+VA94*T;
  6000 N 05LU !
PARA G(BCC_B2,NI:PT:VA;0) 2.9815E+02  +.5*GBCCNI+.5*GBCCPT+VA93+VA94*T;
  6000 N 05LU !

   PARAMETER G(BCC_B2,PT:VA:VA;0)  2.98150E+02  +.5*GPTBCC#+.5*B2PTVA#;
  6.00000E+03   N REF11 !
   PARAMETER G(BCC_B2,VA:PT:VA;0)  2.98150E+02  +.5*GPTBCC#+.5*B2PTVA#;
  6.00000E+03   N REF11 !

   FUNCTION LB2ALNI 298.15 -62104+19.28*T;,, N 03SUN !
PARA G(BCC_B2,*:AL,NI:VA;0) 2.9815E+02  +.5*LB2ALNI; 6000  N 95DUP3 !
PARA G(BCC_B2,AL,NI:*:VA;0) 2.9815E+02  +.5*LB2ALNI; 6000  N 95DUP3 !

   FUNCTION LB2ALVA 298.15 200000;,,N  !
PARA G(BCC_B2,*:AL,VA:VA;0) 2.9815E+02  +.5*LB2ALVA; 6000  N 95DUP3 !
PARA G(BCC_B2,AL,VA:*:VA;0) 2.9815E+02  +.5*LB2ALVA; 6000  N 95DUP3 !

   FUNCTION LB2NIVA 298.15 -64024.38+26.49419*T;,, N !
PARA G(BCC_B2,*:NI,VA:VA;0) 2.9815E+02  +.5*LB2NIVA; 6000  N 95DUP3 !
PARA G(BCC_B2,NI,VA:*:VA;0) 2.9815E+02  +.5*LB2NIVA; 6000  N 95DUP3 !


PARA G(BCC_B2,*:NI,PT:VA;0) 2.9815E+02  +VA87+VA88*T; 6000  N 05LU !
PARA G(BCC_B2,NI,PT:*:VA;0) 2.9815E+02  +VA87+VA88*T; 6000  N 05LU !


   PARAMETER G(BCC_B2,*:PT,VA:VA;0)  2.98150E+02  +.5*LB2PTVA#;
  6.00000E+03   N REF11 !
   PARAMETER G(BCC_B2,PT,VA:*:VA;0)  2.98150E+02  +.5*LB2PTVA#;
  6.00000E+03   N REF11 !

   PARAMETER G(BCC_B2,AL,PT:AL:VA;0)  2.98150E+02
   -0.5*B2ORDER+0.25*L0A2ALPT+0.375*L1A2ALPT;
  6.00000E+03   N REF11 !
   PARAMETER G(BCC_B2,AL:AL,PT:VA;0)  2.98150E+02
   -0.5*B2ORDER+0.25*L0A2ALPT+0.375*L1A2ALPT;
  6.00000E+03   N REF11 !

   PARAMETER G(BCC_B2,AL,PT:PT:VA;0)  2.98150E+02
   -0.5*B2ORDER+0.25*L0A2ALPT-0.375*L1A2ALPT;
  6.00000E+03   N REF11 !
   PARAMETER G(BCC_B2,PT:AL,PT:VA;0)  2.98150E+02
   -0.5*B2ORDER+0.25*L0A2ALPT-0.375*L1A2ALPT;
  6.00000E+03   N REF11 !

   PARAMETER G(BCC_B2,AL,PT:*:VA;1)  2.98150E+02  +0.125*L1A2ALPT;
  6.00000E+03   N REF11 !
   PARAMETER G(BCC_B2,*:AL,PT:VA;1)  2.98150E+02  +0.125*L1A2ALPT;
  6.00000E+03   N REF11 !

$******************************** Compounds in AL-Pt

$  PHASE AL21PT8 % 2 .724138 .275862 !
$      CONS AL21PT8 :AL:PT NI:!
$  PARAMETER G(AL21PT8,AL:NI;0)  2.98150E+02 -35000+.724138*GHSERAL#
$    +.275862*GHSERNI#;   6.00000E+03   N REF0 !

$   PARAMETER G(AL21PT8,AL:PT;0)  298.15  -82342+23.7*T+.7242*GHSERAL#
$  +.2759*GHSERPT#;   6000   N REF0 !

  PHASE ALPT % 2 .5 .5 !
  CONS ALPT :AL:PT NI:!
  PARAMETER G(ALPT,AL:NI;0)  2.98150E+02 VA70+VA71*T+.5*GHSERAL#+.5*GHSERNI#;
     6.00000E+03   N REF0 !
  PARAMETER G(ALPT,AL:NI,PT;0)  2.98150E+02  VA72+VA73*T;   6.00000E+03
     N REF0 !
   PARAMETER G(ALPT,AL:PT;0)  298.15  +.5*GHSERAL#+.5*GHSERPT#+VX85#
  +VX95#*T;   6000.0   N REF0 !
$*******************

 PHASE PT2AL  %  2 .3333   .6667 !
    CONSTITUENT PT2AL  :AL : PT :  !

   PARAMETER G(PT2AL,AL:PT;0)  298.15  +.3333*GHSERAL#+.6667*GHSERPT#
  -84137+VX90#*T;   6000.0   N REF0 !


 PHASE PT2AL3  %  2 .6   .4 !
    CONSTITUENT PT2AL3  :AL : PT :  !

   PARAMETER G(PT2AL3,AL:PT;0)  298.15  +.6*GHSERAL#+.4*GHSERPT#-98234
  +VX91#*T;   6000.0   N REF0 !


 PHASE PT5AL21  %  2 .8077   .1923 !
    CONSTITUENT PT5AL21  :AL : PT :  !

   PARAMETER G(PT5AL21,AL:PT;0)  298.15  +.8077*GHSERAL#+.1923*GHSERPT#
  -53148+VX92#*T;   6000.0   N REF0 !


 PHASE PT5AL3  %  2 .375   .625 !
    CONSTITUENT PT5AL3  :AL : PT :  !

   PARAMETER G(PT5AL3,AL:PT;0)  298.15  +.375*GHSERAL#+.625*GHSERPT#
  -88904+VX93#*T;   6000.0   N REF0 !


 PHASE PT8AL21  %  2 .7241   .2759 !
    CONSTITUENT PT8AL21  :AL : PT :  !

   PARAMETER G(PT8AL21,AL:PT;0)  298.15  +.7241*GHSERAL#+.2759*GHSERPT#
  -74851+VX94#*T;   6000.0   N REF0 !


 PHASE ALPT2  %  2 .6667   .3333 !
    CONSTITUENT ALPT2  :AL : PT :  !

   PARAMETER G(ALPT2,AL:PT;0)  298.15  +.6667*GHSERAL#+.3333*GHSERPT#
  -89614+VX96#*T;   6000.0   N REF0 !
$*************************************
$ASSESSED_SYSTEM AL-NI(;P3 STP:.8/1200/1) !


 LIST_OF_REFERENCES
 NUMBER  SOURCE
   REF01  'Kaisheng WU and Zhanpeng JIN, J. Phase Equil., Vol.21(3), 2000'
   REF02  'P.Nash and M.F.Singleton, Bulletin of Alloy Phase Diagrams,
           Vol.10(3),1989'
   REF283   'Alan Dinsdale, SGTE Data for Pure Elements,
          Calphad Vol 15(1991) p 317-425,
          also in NPL Report DMA(A)195 Rev. August 1990'
  91DIN    'Alan Dinsdale, SGTE Data for Pure Elements, Calphad Vol 15(1991)
         p 317-425, also in NPL Report DMA(A)195 Rev. August 1990'
   REF95    'I Ansara, P Willemin B Sundman (1988); Al-Ni'
   REF295   'N. Saunders, unpublished research, COST-507, (1991); Al-Cu'
   REF281   'Alan Dinsdale, SGTE Data for Pure Elements, NPL Report
         DMA(A)195
          September 1989'
  89DIN    'Alan Dinsdale, SGTE Data for Pure Elements, NPL Report DMA(A)195
         September 1989'
   REF26    'A. Fernandez Guillermet, Z. Metallkde. Vol 79(1988) p.524-536,
          TRITA-MAC 362 (1988); C-CO-NI AND C-CO-FE-NI'
   REF293   'N. Saunders, private communication (1991); Al-Ti-V'
  95DUP3   'N. Dupin, Thesis, LTPCM, France, 1995; Al-Ni, also in I. Ansara,
         N. Dupin, H.L. Lukas, B. Sundman J. Alloys Compds, 247 (1-2), 20-30
         (1997)'
  99DUP    'N. Dupin, I. Ansara, Z. metallkd., Vol 90 (1999) p 76-85; Al-Ni'
  99DUP3   'N. Dupin, July 1999, unpublished revision ; Al-Ni'
  03SUN     'B. Sundman, N. Dupin, JEEP 2003 Lyon'
  REF0 'S Prins and B Sundman, provisional Al-Pt (2003)'
  05LU     'X.-G Lu, PhD thesis work, unpublished'
 !
"""

ROSE_TDB = """
ELEMENT H                 TEST    0      0    0  !
ELEMENT HE                TEST    0      0    0  !
ELEMENT LI                TEST    0      0    0  !
ELEMENT BE                TEST    0      0    0  !
ELEMENT B                 TEST    0      0    0  !
ELEMENT C                 TEST    0      0    0  !
ELEMENT N                 TEST    0      0    0  !
ELEMENT O                 TEST    0      0    0  !
ELEMENT F                 TEST    0      0    0  !
ELEMENT NE                TEST    0      0    0  !

TYPE_DEFINITION % SEQ * !
FUNCTION STR 300 200000; 6000 N !

 PHASE TEST % 1 1 !
 CONSTITUENT TEST : H,HE,LI,BE,B,C,N,O,F,NE : !

PARAMETER G(TEST,H,HE,LI;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,LI;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,LI;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,BE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,BE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,BE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,B;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,B;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,B;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,HE,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,BE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,BE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,BE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,B;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,B;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,B;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,LI,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,B;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,B;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,B;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,BE,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,B,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,C,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,N,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,O,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,O,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,O,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,O,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,O,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,O,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,H,F,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,H,F,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,H,F,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,BE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,BE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,BE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,B;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,B;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,B;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,LI,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,B;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,B;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,B;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,BE,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,B,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,C,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,N,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,O,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,O,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,O,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,O,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,O,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,O,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,F,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,F,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,HE,F,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,B;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,B;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,B;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,BE,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,B,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,C,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,N,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,O,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,O,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,O,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,O,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,O,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,O,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,F,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,F,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,LI,F,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,C;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,C;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,C;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,B,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,C,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,N,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,O,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,O,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,O,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,O,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,O,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,O,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,F,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,F,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,BE,F,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,N;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,N;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,N;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,C,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,N,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,O,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,O,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,O,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,O,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,O,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,O,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,B,F,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,B,F,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,B,F,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,O;0)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,O;1)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,O;2)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,C,N,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,C,O,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,C,O,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,C,O,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,C,O,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,C,O,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,C,O,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,C,F,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,C,F,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,C,F,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,N,O,F;0)     300  STR#;               6000 N !
PARAMETER G(TEST,N,O,F;1)     300  STR#;               6000 N !
PARAMETER G(TEST,N,O,F;2)     300  STR#;               6000 N !
PARAMETER G(TEST,N,O,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,N,O,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,N,O,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,N,F,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,N,F,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,N,F,NE;2)     300  STR#;               6000 N !
PARAMETER G(TEST,O,F,NE;0)     300  STR#;               6000 N !
PARAMETER G(TEST,O,F,NE;1)     300  STR#;               6000 N !
PARAMETER G(TEST,O,F,NE;2)     300  STR#;               6000 N !
"""

ALFE_TDB = """
$ ALFE
$
$ -----------------------------------------------------------------------------
$ 2006.12.21
$ 2007.02.20 mod  ( 386.15 --> 368.15 )
$
$ TDB file created by K.Hashimoto and T.Abe,
$
$ Particle Simulation and Thermodynamics Group, National Institute for
$ Materials Science. 1-2-1 Sengen, Tsukuba, Ibaraki 305-0047, Japan
$
$ e-mail: abe.taichi@nims.go.jp
$
$ Copyright (C) NIMS 2007
$ -----------------------------------------------------------------------------
$
$ The parameter set is taken from
$ COST 507, Thermochemical database for light metal alloys, vol.2
$ Ed. I.Ansara, A.T.Dinsdale, M.H.Rand, (1998)
$ ISBN: 92-828-3902-8
$
$ -----------------------------------------------------------------------------
$
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AL   FCC_A1                    26.981539   4577.296    28.3215!
 ELEMENT FE   BCC_A2                    55.847      4489        27.28  !

$
$--------1---------2---------3---------4---------5---------6---------7---------8
$
 FUNCTION UN_ASS     298.15   0;                                 300.00 N !
 FUNCTION GHSERAL    298.15  -7976.15+137.093038*T-24.3671976*T*LN(T)
   -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1);              700  Y
   -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
   -5.764227E-06*T**3+74092*T**(-1);                             933.47 Y
   -11278.378+188.684153*T-31.748192*T*LN(T)-1.230524E+28*T**(-9); 2900 N !

 FUNCTION GHSERFE    298.15  +1225.7+124.134*T-23.5143*T*LN(T)
     -.00439752*T**2-5.8927E-08*T**3+77359*T**(-1);              1811  Y
      -25383.581+299.31255*T-46*T*LN(T)+2.29603E+31*T**(-9);     6000  N !
$
 FUNCTION GALBCC     298.15  +10083-4.813*T+GHSERAL#;            6000  N !
 FUNCTION GBCCAL     298.15  +10083-4.813*T+GHSERAL#;            6000  N !
 FUNCTION GALLIQ     298.15  +11005.029-11.841867*T
                  +7.934E-20*T**7+GHSERAL#;                      933.47  Y
       +10482.382-11.253974*T+1.231E+28*T**(-9)+GHSERAL#;        2900 N !
 FUNCTION GFEFCC     298.15  -1462.4+8.282*T-1.15*T*LN(T)
     +6.4E-04*T**2+GHSERFE#;                                     1811  Y
      -1713.815+0.94001*T+0.49251E+31*T**(-9)+GHSERFE#;          6000  N !
 FUNCTION GFELIQ     298.15  +12040.17-6.55843*T
     -3.67516E-21*T**7+GHSERFE#;                                 1811  Y
     +14544.751-8.01055*T-2.29603E+31*T**(-9)+GHSERFE#;          6000  N !
$
 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA !
$
PHASE LIQUID %  1  1.0  !
   CONSTITUENT LIQUID :AL,FE: !
   PARAMETER G(LIQUID,AL;0)  298.15  +GALLIQ#;            6000 N !
   PARAMETER G(LIQUID,FE;0)  298.15  +GFELIQ#;            6000 N !
   PARAMETER G(LIQUID,AL,FE;0) 298.15 -91976.5+22.1314*T; 6000 N !
   PARAMETER G(LIQUID,AL,FE;1) 298.15 -5672.58+4.8728*T;  6000 N !
   PARAMETER G(LIQUID,AL,FE;2) 298.15 +121.9;             6000 N !


TYPE_DEFINITION & GES A_P_D B2_BCC DIS_PART BCC_A2 ,,,!
TYPE_DEFINITION - GES A_P_D BCC_A2 MAGNETIC  -1.0    0.4 !
PHASE BCC_A2  %&-  2 1   3 !
   CONSTITUENT BCC_A2  :AL,FE: VA :  !
   PARAMETER G(BCC_A2,AL:VA;0)      298.15  +GALBCC#;      2900 N !
   PARAMETER G(BCC_A2,FE:VA;0)      298.15  +GHSERFE#;     6000 N !
   PARAMETER TC(BCC_A2,FE:VA;0)     298.15  1043;          6000 N !
   PARAMETER BMAGN(BCC_A2,FE:VA;0)  298.15  2.22;          6000 N !
$  PARAMETER G(BCC_A2,AL,FE:VA;0)   298.15  +4.0*(-30740+7.9972*T);
   PARAMETER G(BCC_A2,AL,FE:VA;0)   298.15  -122960.+31.9888*T; 6000 N !
$  PARAMETER G(BCC_A2,AL,FE:VA;1)   298.15  +8.0*(368.15);
   PARAMETER G(BCC_A2,AL,FE:VA;1)   298.15  +2945.2;       6000 N !
   PARAMETER TC(BCC_A2,AL,FE:VA;1)  298.15   +504;         6000 N !

$ separate the order and disordered phases
$ -2*860*8.31451
$
PHASE B2_BCC %&  3 0.5  0.5  3  !
   CONSTITUENT B2_BCC  :AL,FE:AL,FE:VA:  !
   PARAMETER G(B2_BCC,AL:AL:VA;0)  298.15  0.0;         6000 N !
   PARAMETER G(B2_BCC,FE:AL:VA;0)  298.15  -14300.9572; 6000 N !
   PARAMETER G(B2_BCC,AL:FE:VA;0)  298.15  -14300.9572; 6000 N !
   PARAMETER G(B2_BCC,FE:FE:VA;0)  298.15  0.0;         6000 N !


$ includes the parameters of order + disordered in a single description
$TYPE_DEFINITION + GES A_P_D BCC_B2 MAGNETIC  -1.0    0.4 !
$PHASE BCC_B2 %+  3 0.5  0.5  3  !
$   CONSTITUENT BCC_B2  :AL,FE:AL,FE:VA:  !
$   PARAMETER G(BCC_B2,AL:AL:VA;0)  298.15  +GBCCAL#;       6000 N !
$   PARAMETER G(BCC_B2,FE:AL:VA;0)  298.15
$             -37890.478+7.9972*T+0.5*GALBCC#+0.5*GHSERFE#; 6000 N !
$   PARAMETER G(BCC_B2,AL:FE:VA;0)  298.15
$             -37890.478+7.9972*T+0.5*GALBCC#+0.5*GHSERFE#; 6000 N !
$   PARAMETER G(BCC_B2,FE:FE:VA;0)  298.15  +GHSERFE#;      6000 N !
$   PARAMETER TC(BCC_B2,FE:AL:VA;0)     298.15  521.5;      6000 N !
$   PARAMETER BMAGN(BCC_B2,FE:AL:VA;0)  298.15  1.11;       6000 N !
$   PARAMETER TC(BCC_B2,AL:FE:VA;0)     298.15  521.5;      6000 N !
$   PARAMETER BMAGN(BCC_B2,AL:FE:VA;0)  298.15  1.11;       6000 N !
$   PARAMETER TC(BCC_B2,FE:FE:VA;0)     298.15  1043.0;     6000 N !
$   PARAMETER BMAGN(BCC_B2,FE:FE:VA;0)  298.15  2.22;       6000 N !
$   PARAMETER G(BCC_B2,AL,FE:AL:VA;0)
$                               298.15 -22485.072+7.9772*T; 6000 N !
$   PARAMETER G(BCC_B2,AL:AL,FE:VA;0)
$                               298.15 -22485.072+7.9772*T; 6000 N !
$   PARAMETER G(BCC_B2,AL,FE:AL:VA;1)     298.15 +368.15;   6000 N !
$   PARAMETER G(BCC_B2,AL:AL,FE:VA;1)     298.15 +368.15;   6000 N !
$   PARAMETER TC(BCC_B2,AL,FE:AL:VA;0)    298.15  189.0;    6000 N !
$   PARAMETER TC(BCC_B2,AL:AL,FE:VA;0)    298.15  189.0;    6000 N !
$   PARAMETER TC(BCC_B2,AL,FE:AL:VA;1)    298.15   63.0;    6000 N !
$   PARAMETER TC(BCC_B2,AL:AL,FE:VA;1)    298.15   63.0;    6000 N !
$   PARAMETER BMAGN(BCC_B2,AL,FE:AL:VA;0) 298.15    0.0;    6000 N !
$   PARAMETER BMAGN(BCC_B2,AL:AL,FE:VA;0) 298.15    0.0;    6000 N !
$   PARAMETER TC(BCC_B2,AL,FE:FE:VA;0)    289.15 -189.0;    6000 N !
$   PARAMETER TC(BCC_B2,FE:AL,FE:VA;0)    298.15 -189.0;    6000 N !
$   PARAMETER TC(BCC_B2,AL,FE:FE:VA;1)    298.15   63.0;    6000 N !
$   PARAMETER TC(BCC_B2,FE:AL,FE:VA;1)    298.15   63.0;    6000 N !
$   PARAMETER BMAGN(BCC_B2,AL,FE:FE:VA;0) 298.15    0.0;    6000 N !
$   PARAMETER BMAGN(BCC_B2,FE:AL,FE:VA;0) 298.15    0.0;    6000 N !
$   PARAMETER G(BCC_B2,AL,FE:FE:VA;0)
$                               298.15 -24693.972+7.9772*T; 6000 N !
$   PARAMETER G(BCC_B2,FE:AL,FE:VA;0)
$                               298.15 -24693.972+7.9772*T; 6000 N !
$   PARAMETER G(BCC_B2,AL,FE:FE:VA;1)     298.15 +368.15;   6000 N !
$   PARAMETER G(BCC_B2,FE:AL,FE:VA;1)     298.15 +368.15;   6000 N !

TYPE_DEFINITION / GES A_P_D FCC_A1 MAGNETIC  -3.0    2.80000E-01 !
PHASE FCC_A1  %/  2 1   1 !
   CONSTITUENT FCC_A1  :AL,FE : VA :  !
   PARAMETER G(FCC_A1,AL:VA;0)      298.15   +GHSERAL#;       2900 N !
   PARAMETER G(FCC_A1,FE:VA;0)      298.15   +GFEFCC#;        6000 N !
   PARAMETER TC(FCC_A1,FE:VA;0)     298.15   +67;             6000 N !
   PARAMETER BMAGN(FCC_A1,FE:VA;0)  298.15   +0.7;            6000 N !
   PARAMETER G(FCC_A1,AL,FE:VA;0)   298.15  -76066.1+18.6758*T; 6000 N !
   PARAMETER G(FCC_A1,AL,FE:VA;1)   298.15  +21167.4+1.3398*T;  6000 N !

TYPE_DEFINITION ) GES A_P_D HCP_A3 MAGNETIC  -3.0    2.80000E-01 !
PHASE HCP_A3 %) 2 1 .5 !
   CONSTITUENT HCP_A3  :AL,FE: VA :  !
   PARAMETER G(HCP_A3,AL:VA;0)  298.15  +5481-1.8*T+GHSERAL#;  2900 N !
   PARAMETER G(HCP_A3,FE:VA;0)  298.15
                  -3705.78+12.591*T-1.15*T*LN(T)
                  +6.4E-04*T**2+GHSERFE#;  1.81100E+03  Y
                  -3957.199+5.24951*T+4.9251E+30*T**(-9)+GHSERFE#;  6000 N !
   PARAMETER G(HCP_A3,AL,FE:VA;0)  298.15  -106903.0+20.0*T;        6000 N !

PHASE AL2FE % 2  2  1   !
   CONSTITUENT AL2FE  :AL:FE:  !
   PARAMETER G(AL2FE,AL:FE;0)  298.15
                              -98097.0+18.7503*T+2*GHSERAL#+GHSERFE#; 6000 N !

PHASE AL13FE4 %  3  0.6275  0.235  0.1375  !
   CONSTITUENT AL13FE4  :AL:FE:AL,VA:  !
   PARAMETER G(AL13FE4,AL:FE:AL;0)  298.15
                   -30714.4+7.44*T+0.765*GHSERAL#+0.235*GHSERFE#;     6000 N !
   PARAMETER G(AL13FE4,AL:FE:VA;0)  298.15
                   -27781.3+7.2566*T+0.6275*GHSERAL#+0.235*GHSERFE#;  6000 N !

PHASE AL5FE2 % 2  5  2  !
   CONSTITUENT AL5FE2  :AL:FE:  !
   PARAMETER G(AL5FE2,AL:FE;0)  298.15
                            -228576+48.99503*T+5*GHSERAL#+2*GHSERFE#; 6000 N !

PHASE AL5FE4 % 1 1.0 !
   CONSTITUENT AL5FE4  :AL,FE :  !
   PARAMETER G(AL5FE4,AL;0)     298.15  +12178.90-4.813*T+GHSERAL#;   6000 N !
   PARAMETER G(AL5FE4,FE;0)     298.15  +5009.03+GHSERFE#;            6000 N !
   PARAMETER G(AL5FE4,AL,FE;0)  298.15  -131649+29.4833*T;            6000 N !
   PARAMETER G(AL5FE4,AL,FE;1)  298.15  -18619.5;                     6000 N !

$ALFE-NIMS
"""

DIFFUSION_TDB = """
$--------------------------------------------------------------
$$ 			Version MGMOB1
$$   MODIFIED FOR TESTING PURPOSES -- NOT FOR RESEARCH
$--------------------------------------------------------------
$
$ OPTIMIZED USING THERMO-CALC TCMG2 THERMODYNAMIC DATABASE
$
$
$=======================ELEMENT DATA===========================
$$ ELEMENT STABLE ELEMENT  REFERENCE	  MASS	      H298-H0	   S298
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AG   FCC_A1                    1.0787E+02  5.7446E+03  4.2551E+01!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5773E+03  2.8322E+01!
 ELEMENT BE   HCP_A3                    9.0122E+00  0.0000E+00  0.0000E+00!
 ELEMENT CA   FCC_A1                    4.0078E+01  6.1965E+03  4.1589E+01!
 ELEMENT CD   HCP_A3                    1.1241E+02  6.2509E+03  5.1798E+01!
 ELEMENT CE   FCC_A1                    1.4011E+02  0.0000E+00  0.0000E+00!
 ELEMENT EU   BCC_A2                    1.5197E+02  0.0000E+00  8.0793E+01!
 ELEMENT FE   BCC_A2                    5.5847E+01  4.4890E+03  2.7280E+01!
 ELEMENT GA   ORTHORHOMBIC_CMCA         6.9723E+01  5.5731E+03  4.0828E+01!
 ELEMENT GD   HCP_A3                    1.5725E+02  0.0000E+00  0.0000E+00!
 ELEMENT IN   TETRAGONAL_A6             1.1482E+02  6.6100E+03  5.7650E+01!
 ELEMENT LA   DOUBLE_HCP(ABAC)          1.3891E+02  0.0000E+00  0.0000E+00!
 ELEMENT MG   HCP_A3                    2.4305E+01  4.9980E+03  3.2671E+01!
 ELEMENT MN   CBCC_A12                  5.4938E+01  4.9960E+03  3.2008E+01!
 ELEMENT ND   DHCP                      1.4424E+02  0.0000E+00  0.0000E+00!
 ELEMENT NI   FCC_A1                    5.8690E+01  4.7870E+03  2.9796E+01!
 ELEMENT PR   DOUBLE_HCP(ABAC)          1.4091E+02  0.0000E+00  0.0000E+00!
 ELEMENT SB   RHOMBOHEDRAL_A7           1.2175E+02  5.8702E+03  4.5522E+01!
 ELEMENT SM   RHOMBOHEDRAL              1.5036E+02  0.0000E+00  0.0000E+00!
 ELEMENT SN   BCT_A5                    1.1871E+02  6.3220E+03  5.1195E+01!
 ELEMENT U    ORTHORHOMBIC(A20)         2.3803E+02  0.0000E+00  0.0000E+00!
 ELEMENT Y    HCP_A3                    8.8906E+01  0.0000E+00  0.0000E+00!
 ELEMENT ZN   HCP_A3                    6.5390E+01  5.6568E+03  4.1631E+01!
$
$=======================PHASE DATA=============================
$PHASE NAME   TYPE NR OF SUBL. IN EACH SUBL.
 PHASE HCP_A3  XH  2 1   .5 !
$====================CONSTITUENT DATA==========================
 CONST HCP_A3 : AG,AL,CE,LA,MG%,MN,SN,ZN : VA% : !
$=======================SYSTEM DATA============================
 TYPE_DEFINITION X SEQ * !
 TYPE_DEFINITION H GES A_P_D HCP_A3 MAGNETIC  -3.0    2.80000E-01 !
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_EL VA /- !
$======================VOLUME DATA=============================
$Molar volume set to 1E-5
$VS: volume counted per mole of volume carrying species
$ PARAM VS(HCP_A3) 0 1.0E-5; 6000 N !
$====================ZERO VOLUME DATA==========================
$ ZEROVOLUME_SPECIES VA !
$===================DIFFUSION FORMULA==========================
$ GIVEN GENERAL FORM: D=AEXP(-Q/RT)
$ DEFINE MQ=-Q+RTLN(A)
$
$===================SELF DIFFUSIVITY===========================
 PARA MQ(HCP_A3&AG,*:VA),, -1.3991E5+R*T*LN(6.13E-4);,,N  !

 PARA MQ(HCP_A3&AL,*:VA),, -1.5705E5+R*T*LN(1.47E-3);,,N  !
 PARA MQ(HCP_A3&AL,MG:VA),, -1.5231E5+R*T*LN(5.74E-4);,,N  !
 PARA MQ(HCP_A3&AL,AL,MG:VA),, -7.0918E5+1.167E3*T;,,N  !

 PARA MQ(HCP_A3&BE,*:VA),, -1.5700E5+R*T*LN(8.06E-4);,,N  !

 PARA MQ(HCP_A3&CD,*:VA),, -1.4070E5+R*T*LN(1.29E-4);,,N  !

 PARA MQ(HCP_A3&CE,*:VA),, -1.7580E5+R*T*LN(4.50E-2);,,N  !

 PARA MQ(HCP_A3&FE,*:VA),, -8.8800E4+R*T*LN(4.00E-2);,,N  !

 PARA MQ(HCP_A3&GA,*:VA),, -1.3430E5+R*T*LN(1.20E-4);,,N  !

 PARA MQ(HCP_A3&IN,*:VA),, -1.1882E5+R*T*LN(5.20E-6);,,N  !

 PARA MQ(HCP_A3&LA,*:VA),, -1.0220E5+R*T*LN(2.20E-6);,,N  !

 PARA MQ(HCP_A3&MG,*:VA),,  -125077.2+R*T*LN(2.48E-5);,,N  !
 PARA MQ(HCP_A3&MG,MG:VA),, -125077.2+R*T*LN(2.48E-5);,,N  !
 PARA MQ(HCP_A3&MG,AL:VA),, -9.4176E5+R*T*LN(5.01E-4);,,N  !
 PARA MQ(HCP_A3&MG,MG,AL:VA),, -2.8842E5+1.967E3*T;,,N  !
 PARA MQ(HCP_A3&MG,ZN:VA),, -8.2169E7+R*T*LN(1.29E-11);,,N  !
 PARA MQ(HCP_A3&MG,MG,ZN:VA),, 8.2831E7+3.785E3*T;,,N  !

 PARA MQ(HCP_A3&MN,*:VA),, -1.5400E5+R*T*LN(0.76E-4);,,N  !

 PARA MQ(HCP_A3&NI,*:VA),, -9.5900E4+R*T*LN(5.00E-10);,,N  !

 PARA MQ(HCP_A3&SB,*:VA),, -1.3730E5+R*T*LN(2.57E-4);,,N  !

 PARA MQ(HCP_A3&SN,*:VA),, -1.5132E5+R*T*LN(4.56E-4);,,N  !

 PARA MQ(HCP_A3&ZN,*:VA),,  -1.2552E5+R*T*LN(9.38E-5);,,N  !
 PARA MQ(HCP_A3&ZN,MG:VA),,  -1.2552E5+R*T*LN(9.38E-5);,,N  !
 PARA MQ(HCP_A3&ZN,ZN,MG:VA),,  -2.5024E6+3.350E3*T;,,N  !
 PARA MQ(HCP_A3&ZN,AL,MG:VA),, 3.5434E3+9.763E1*T;,,N  !

 PARA MQ(HCP_A3&U,*:VA),, -1.1470E5+R*T*LN(2.50E-9);,,N  !
"""

ALNIFCC4SL_TDB = """
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$ Date: 2016-04-09 00:08
$ Components: AL, NI, VA
$ Phases: AL3NI1, AL3NI2, AL3NI5, BCC_B2, FCC_L12, LIQUID
$ Generated by rotis (pycalphad 0.3.2+32.g27d5e34)
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

ELEMENT AL BLANK 0 0 0 !
ELEMENT NI BLANK 0 0 0 !
ELEMENT VA BLANK 0 0 0 !

FUNCTION GBCCAL 298.15 -4.813*T + GHSERAL# + 10083; 2900.0 N !
FUNCTION GBCCNI 298.15 -3.556*T + GHSERNI# + 8715.084; 3000.0 N !
FUNCTION GFCCAL 298.15 GHSERAL#; 2900.0 N !
FUNCTION GFCCNI 298.15 GHSERNI#; 3000.0 N !
FUNCTION GHSERAL 298.15 -8.77664E-7*T**3 - 0.001884662*T**2 -
   24.3671976*T*LN(T) + 137.093038*T - 7976.15 + 74092*T**(-1); 700.0 Y
   -5.764227E-6*T**3 + 0.018531982*T**2 - 38.5844296*T*LN(T) + 223.048446*T -
   11276.24 + 74092*T**(-1); 933.47 Y -31.748192*T*LN(T) + 188.684153*T -
   11278.378 - 1.230524E+28*T**(-9); 2900.0 N !
FUNCTION GHSERNI 298.15 -0.0048407*T**2 - 22.096*T*LN(T) + 117.854*T -
   5179.159; 1728.0 Y -43.1*T*LN(T) + 279.135*T - 27840.655 +
   1.12754E+31*T**(-9); 3000.0 N !
FUNCTION GHSERVA 1 0; 10000 N !
FUNCTION GLIQAL 298.15 7.9337E-20*T**7 - 11.841867*T + GHSERAL# + 11005.029;
   700.0 Y 7.9337E-20*T**7 - 11.841867*T + GHSERAL# + 11005.03; 933.47 Y
   -31.748192*T*LN(T) + 177.430178*T - 795.996; 2900.0 N !
FUNCTION GLIQNI 298.15 -3.82318E-21*T**7 - 9.397*T + GHSERNI# + 16414.686;
   1728.0 Y -43.1*T*LN(T) + 268.598*T - 9549.775; 3000.0 N !
$ Make sure we can still read functions with no "N" at the end
FUN TESTF 298.15 0.0; 6000.00 01DUP !

TYPE_DEFINITION % SEQ * !
DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
DEFAULT_COMMAND DEFINE_SYSTEM_ELEMENT VA !

PHASE AL3NI1 %  2 0.75 0.25 !
CONSTITUENT AL3NI1 :AL:NI: !

PHASE AL3NI2 %  3 3 2 1 !
CONSTITUENT AL3NI2 :AL:AL,NI:NI,VA: !

PHASE AL3NI5 %  2 0.375 0.625 !
CONSTITUENT AL3NI5 :AL:NI: !

PHASE BCC_B2 %  3 0.5 0.5 1 !
CONSTITUENT BCC_B2 :AL,NI,VA:AL,NI,VA:VA: !

PHASE FCC_L12 %  5 0.25 0.25 0.25 0.25 1 !
CONSTITUENT FCC_L12 :AL,NI:AL,NI:AL,NI:AL,NI:VA: !

PHASE LIQUID %  1 1 !
CONSTITUENT LIQUID :AL,NI: !



$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     AL                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(AL3NI2,AL:AL:VA;0) 1 -2.5*T + 5*GHSERAL# + 25000.0; 10000 N !
PARAMETER G(BCC_B2,AL:AL:VA;0) 1 1.0*GBCCAL#; 10000 N !
PARAMETER G(BCC_B2,AL:VA:VA;0) 1 10.0*T + 0.5*GHSERAL# + 16432.5; 10000 N !
PARAMETER G(BCC_B2,VA:AL:VA;0) 1 10.0*T + 0.5*GHSERAL# + 16432.5; 10000 N !
PARAMETER L(BCC_B2,AL,VA:VA:VA;0) 1 67135.0; 10000 N !
PARAMETER L(BCC_B2,VA:AL,VA:VA;0) 1 67135.0; 10000 N !
PARAMETER G(FCC_L12,AL:AL:AL:AL:VA;0) 1 1.0*GFCCAL#; 10000 N !
PARAMETER G(LIQUID,AL;0) 1 GLIQAL#; 10000 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     NI                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(BCC_B2,NI:NI:VA;0) 1 1.0*GBCCNI#; 10000 N !
PARAMETER G(BCC_B2,NI:VA:VA;0) 1 0.5*GHSERNI# + 32790.6; 10000 N !
PARAMETER G(BCC_B2,VA:NI:VA;0) 1 0.5*GHSERNI# + 32790.6; 10000 N !
PARAMETER L(BCC_B2,NI,VA:VA:VA;0) 1 34418.8; 10000 N !
PARAMETER L(BCC_B2,VA:NI,VA:VA;0) 1 34418.8; 10000 N !
PARAMETER G(FCC_L12,NI:NI:NI:NI:VA;0) 1 1.0*GFCCNI#; 10000 N !
PARAMETER G(LIQUID,NI;0) 1 GLIQNI#; 10000 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     VA                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(BCC_B2,VA:VA:VA;0) 1 0; 10000 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   AL-NI                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(AL3NI1,AL:NI;0) 1 3.2538*T + 0.75*GHSERAL# + 0.25*GHSERNI# -
   39656.1; 10000 N !
PARAMETER G(AL3NI2,AL:AL:NI;0) 1 2.32722*T + 5*GHSERAL# + GHSERNI# - 32826.0;
   10000 N !
PARAMETER G(AL3NI2,AL:NI:NI;0) 1 60.669*T + 3*GHSERAL# + 3*GHSERNI# -
   356448.0; 10000 N !
PARAMETER G(AL3NI2,AL:NI:VA;0) 1 55.52*T + 3*GHSERAL# + 2*GHSERNI# -
   298627.0; 10000 N !
PARAMETER L(AL3NI2,AL:AL:NI,VA;0) 1 -22660.0; 10000 N !
PARAMETER L(AL3NI2,AL:AL:NI,VA;1) 1 -10.6667; 10000 N !
PARAMETER L(AL3NI2,AL:AL:NI,VA;2) 1 10.6667; 10000 N !
PARAMETER L(AL3NI2,AL:AL,NI:NI;0) 1 -39696.0; 10000 N !
PARAMETER L(AL3NI2,AL:AL,NI:NI;1) 1 7.44649E-12; 10000 N !
PARAMETER L(AL3NI2,AL:AL,NI:NI;2) 1 -64.0; 10000 N !
PARAMETER L(AL3NI2,AL:AL,NI:VA;0) 1 -39700.0; 10000 N !
PARAMETER L(AL3NI2,AL:AL,NI:VA;1) 1 3.09086E-12; 10000 N !
PARAMETER L(AL3NI2,AL:AL,NI:VA;2) 1 -26.6667; 10000 N !
PARAMETER L(AL3NI2,AL:NI:NI,VA;0) 1 -22660.0; 10000 N !
PARAMETER L(AL3NI2,AL:NI:NI,VA;1) 1 -10.6667; 10000 N !
PARAMETER L(AL3NI2,AL:NI:NI,VA;2) 1 10.6667; 10000 N !
PARAMETER G(AL3NI5,AL:NI;0) 1 5.392*T + 0.375*GHSERAL# + 0.625*GHSERNI# -
   55383.5; 10000 N !
PARAMETER G(BCC_B2,AL:NI:VA;0) 1 9.52839E-8*T**3 + 0.00123463*T**2 +
   0.000871897*T*LN(T) + 1.31471*T + 0.5*GHSERAL# + 0.5*GHSERNI# - 64435.3 +
   23095.2*T**(-1); 10000 N !
PARAMETER G(BCC_B2,NI:AL:VA;0) 1 9.52839E-8*T**3 + 0.00123463*T**2 +
   0.000871897*T*LN(T) + 1.31471*T + 0.5*GHSERAL# + 0.5*GHSERNI# - 64435.3 +
   23095.2*T**(-1); 10000 N !
PARAMETER L(BCC_B2,AL:AL,NI:VA;0) 1 45262.9; 10000 N !
PARAMETER L(BCC_B2,AL:NI,VA:VA;0) 1 -28577.7; 10000 N !
PARAMETER L(BCC_B2,AL,NI:AL:VA;0) 1 45262.9; 10000 N !
PARAMETER L(BCC_B2,AL,NI:NI:VA;0) 1 -20275.1; 10000 N !
PARAMETER L(BCC_B2,AL,NI:VA:VA;0) 1 -150055.0; 10000 N !
PARAMETER L(BCC_B2,AL,VA:NI:VA;0) 1 41335.6; 10000 N !
PARAMETER L(BCC_B2,NI:AL,NI:VA;0) 1 -20275.1; 10000 N !
PARAMETER L(BCC_B2,NI:AL,VA:VA;0) 1 41335.6; 10000 N !
PARAMETER L(BCC_B2,NI,VA:AL:VA;0) 1 -28577.7; 10000 N !
PARAMETER L(BCC_B2,VA:AL,NI:VA;0) 1 -150055.0; 10000 N !
PARAMETER L(BCC_B2,AL,NI:AL,NI:VA;0) 1 -152236.0; 10000 N !
PARAMETER G(FCC_L12,AL:AL:AL:NI:VA;0) 1 0.55316*T + 0.75*GHSERAL# +
   0.25*GHSERNI# - 21524.2; 10000 N !
PARAMETER G(FCC_L12,AL:AL:NI:AL:VA;0) 1 0.55316*T + 0.75*GHSERAL# +
   0.25*GHSERNI# - 21524.2; 10000 N !
PARAMETER G(FCC_L12,AL:AL:NI:NI:VA;0) 1 1.10633*T + 0.5*GHSERAL# +
   0.5*GHSERNI# - 57350.5; 10000 N !
PARAMETER G(FCC_L12,AL:NI:AL:AL:VA;0) 1 0.55316*T + 0.75*GHSERAL# +
   0.25*GHSERNI# - 21524.2; 10000 N !
PARAMETER G(FCC_L12,AL:NI:NI:AL:VA;0) 1 1.10633*T + 0.5*GHSERAL# +
   0.5*GHSERNI# - 57350.5; 10000 N !
PARAMETER G(FCC_L12,AL:NI:NI:NI:VA;0) 1 3.13447E-7*T**3 - 0.000436214*T**2 +
   1.13542*T*LN(T) - 5.83812*T + 0.25*GHSERAL# + 0.75*GHSERNI# - 41810.9 -
   6040.3*T**(-1); 10000 N !
PARAMETER G(FCC_L12,NI:AL:AL:AL:VA;0) 1 0.55316*T + 0.75*GHSERAL# +
   0.25*GHSERNI# - 21524.2; 10000 N !
PARAMETER G(FCC_L12,NI:AL:AL:NI:VA;0) 1 1.10633*T + 0.5*GHSERAL# +
   0.5*GHSERNI# - 57350.5; 10000 N !
PARAMETER G(FCC_L12,NI:AL:NI:NI:VA;0) 1 3.13447E-7*T**3 - 0.000436214*T**2 +
   1.13542*T*LN(T) - 5.83812*T + 0.25*GHSERAL# + 0.75*GHSERNI# - 41810.9 -
   6040.3*T**(-1); 10000 N !
PARAMETER G(FCC_L12,NI:NI:AL:AL:VA;0) 1 1.10633*T + 0.5*GHSERAL# +
   0.5*GHSERNI# - 57350.5; 10000 N !
PARAMETER G(FCC_L12,NI:NI:AL:NI:VA;0) 1 3.13447E-7*T**3 - 0.000436214*T**2 +
   1.13542*T*LN(T) - 5.83812*T + 0.25*GHSERAL# + 0.75*GHSERNI# - 41810.9 -
   6040.3*T**(-1); 10000 N !
PARAMETER G(FCC_L12,NI:NI:NI:AL:VA;0) 1 3.13447E-7*T**3 - 0.000436214*T**2 +
   1.13542*T*LN(T) - 5.83812*T + 0.25*GHSERAL# + 0.75*GHSERNI# - 41810.9 -
   6040.3*T**(-1); 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL:AL,NI:VA;0) 1 5512.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL:AL,NI:VA;1) 1 -533.333; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL:AL,NI:VA;2) 1 -1952.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:AL:VA;0) 1 5512.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:AL:VA;1) 1 -533.333; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:AL:VA;2) 1 -1952.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:NI:VA;0) 1 3768.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:NI:VA;1) 1 2752.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:NI:VA;2) 1 32.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:AL:AL:VA;0) 1 5512.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:AL:AL:VA;1) 1 -533.333; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:AL:AL:VA;2) 1 -1952.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:AL:VA;0) 1 3768.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:AL:VA;1) 1 2752.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:AL:VA;2) 1 32.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:NI:VA;0) 1 -5196.0; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:NI:VA;1) 1 3125.33; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:NI:VA;2) 1 2522.67; 10000 N !
PARAMETER L(FCC_L12,AL,NI:AL:AL:AL:VA;0) 1 5512.0; 10000 N !
PARAMETER L(FCC_L12,AL,NI:AL:AL:AL:VA;1) 1 -533.333; 10000 N !
PARAMETER L(FCC_L12,AL,NI:AL:AL:AL:VA;2) 1 -1952.0; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:AL:AL:VA;0) 1 3768.0; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:AL:AL:VA;1) 1 2752.0; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:AL:AL:VA;2) 1 32.0; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:AL:VA;0) 1 -5196.0; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:AL:VA;1) 1 3125.33; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:AL:VA;2) 1 2522.67; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:NI:VA;0) 1 5122.0; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:NI:VA;1) 1 1226.67; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:NI:VA;2) 1 -1704.0; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL:AL,NI:VA;0) 1 3768.0; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL:AL,NI:VA;1) 1 2752.0; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL:AL,NI:VA;2) 1 32.0; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL,NI:NI:VA;0) 1 -5196.0; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL,NI:NI:VA;1) 1 3125.33; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL,NI:NI:VA;2) 1 2522.67; 10000 N !
PARAMETER L(FCC_L12,NI:AL,NI:NI:NI:VA;0) 1 5122.0; 10000 N !
PARAMETER L(FCC_L12,NI:AL,NI:NI:NI:VA;1) 1 1226.67; 10000 N !
PARAMETER L(FCC_L12,NI:AL,NI:NI:NI:VA;2) 1 -1704.0; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL:AL,NI:VA;0) 1 -5196.0; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL:AL,NI:VA;1) 1 3125.33; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL:AL,NI:VA;2) 1 2522.67; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL,NI:NI:VA;0) 1 5122.0; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL,NI:NI:VA;1) 1 1226.67; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL,NI:NI:VA;2) 1 -1704.0; 10000 N !
PARAMETER L(FCC_L12,NI:NI:NI:AL,NI:VA;0) 1 5122.0; 10000 N !
PARAMETER L(FCC_L12,NI:NI:NI:AL,NI:VA;1) 1 1226.67; 10000 N !
PARAMETER L(FCC_L12,NI:NI:NI:AL,NI:VA;2) 1 -1704.0; 10000 N !
PARAMETER L(FCC_L12,AL,NI:AL,NI:AL,NI:AL,NI:VA;0) 1 -4257290.0; 10000 N !
PARAMETER L(LIQUID,AL,NI;0) 1 -197437.0; 10000 N !
PARAMETER L(LIQUID,AL,NI;1) 1 14423.4; 10000 N !
PARAMETER L(LIQUID,AL,NI;2) 1 61412.5; 10000 N !
"""

ALCOCRNI_TDB = """
$ FOR TESTING PURPOSES ONLY -- NOT FOR RESEARCH
$****************************************************************************
$$ WARNING: TESTED ONLY IN THERMO-CALC, MAY NOT WORK WITH PANDAT OR OTHERS
$$ Al-Co-Cr-Ni Quaternary combined from 4 ternaries:
$$ (1) Al-Co-Cr, (2) Al-Co-Ni, (3) Al-Cr-Ni, (4) Co-Cr-Ni
$$ CRALDAD VERSION 1
$$ ChRome ALuminum D(ensity functional theory)-Amended Database
$****************************************************************************
$$
$$                     _______
$$             \\ //  /   -^--\ |
$$             ||||  / /\_____/ /
$$ {\         ______{ }        /
$$ {_}{\{\{\{|         \=@____/
$$<{_{-{-{-{-| ====---- >>>
$$ { }{/{/{/{|______  _/=@_____
$$ {/               { }        \
$$             ||||  \ \______  \
$$             // \\  \    _^_\  |
$$                     \______/
$$
$****************************************************************************
$$ Database developed by:
$$ Xuan L. Liu, Thomas Gheno
$$ Greta Lindwall, Bonnie Lindahl
$$ Zi-Kui Liu, Brian Gleeson
$$ 2-16-2015
$****************************************************************************
$$ Database based off of work by:
$$ N. Dupin, I. Ansara, B. Sundman,
$$ Thermodynamic Re-Assessment of the Ternary System Al-Cr-Ni,
$$ Calphad, 25 (2), 279-298 (2001); Al-Cr-Ni'
$****************************************************************************


 ELEMENT /-   ELECTRON_GAS               .0000E+00   .0000E+00   .0000E+00!
 ELEMENT VA   VACUUM                     .0000E+00   .0000E+00   .0000E+00!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5773E+03  2.8322E+01!
 ELEMENT CO   HCP_A3                    5.8933E+01  4.7656E+03  3.0040E+01!
 ELEMENT CR   BCC_A2                    5.1996E+01  4.0500E+03  2.3560E+01!
 ELEMENT NI   FCC_A1                    5.8690E+01  4.7870E+03  2.9796E+01!

 SPECIES AL1CO1                      AL1CO1!
 SPECIES AL1NI1                      AL1NI1!
 SPECIES AL1NI3                      AL1NI3!
 SPECIES AL2                         AL2!
 SPECIES AL3CO1                      AL3CO1!
 SPECIES AL3NI1                      AL3NI1!
 SPECIES AL3NI2                      AL3NI2!
 SPECIES AL5CO2                      AL5CO2!
 SPECIES AL9CO2                      AL9CO2!
 SPECIES CO2                         CO2!
 SPECIES CR2                         CR2!
 SPECIES NI2                         NI2!


 FUNCTION UNASS      298.15  0;,,N !


 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT E 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA !

 DEFAULT_COMMAND REJECT_PHASE GAS !

 PHASE GAS:G %  1  1.0  !
 CONST GAS:G :AL,AL2,CR,CR2,NI,NI2 :  !

 PHASE LIQUID:L %  1  1.0  !
 CONST LIQUID:L :AL,CO,CR,NI :  !

 PHASE FCC_A1  %A  2 1   1 !
 CONST FCC_A1  :AL,CO,CR,NI : VA :  !

 PHASE BCC_A2  %B  2 1   3 !
 CONST BCC_A2  :AL,CO,CR,NI,VA : VA :  !

 PHASE HCP_A3  %A  2   1   .5 !
 CONST HCP_A3  :AL,CO,CR,NI : VA :  !

 PHASE BCC_B2  %BC  3 .5 .5    3 !
 CONST BCC_B2  :AL,CO,CR,NI,VA : AL,CO,CR,NI,VA : VA: !

 PHASE L12_FCC  %AD  3 .75   .25   1 !
 CONST L12_FCC  :AL,CO,CR,NI : AL,CO,CR,NI : VA :  !

 PHASE SIGMA_SGTE  %  3 8   18   4 !
 CONST SIGMA_SGTE  :AL,CO,NI : AL,CO,CR,NI : CR :  !


 TYPE_DEFINITION A GES A_P_D @ MAGNETIC  -3.0 .28 !
 TYPE_DEFINITION B GES A_P_D @ MAGNETIC  -1.0 .40 !

 TYPE_DEFINITION C GES A_P_D BCC_B2 DIS_PART BCC_A2 !
 TYPE_DEFINITION D GES A_P_D L12_FCC DIS_PART FCC_A1 !


$ TYPE_DEFINITION G IF (AL AND NI) THEN
$                  GES A_P_D L12_FCC C_S 2 NI:AL:VA !
$ TYPE_DEFINITION G IF (NI) THEN
$                  GES A_P_D L12_FCC MAJ 1 NI:NI:VA !

$ TYPE_DEFINITION W IF (CR AND AL AND NI) THEN
$                  GES A_P_D BCC_B2 C_S,, NI:AL:VA !

$ TYPE_DEFINITION W IF (CR AND AL AND CO) THEN
$                  GES A_P_D BCC_B2 C_S,, CO:AL:VA !

$ TYPE_DEFINITION W IF (CR) THEN
$                  GES A_P_D BCC_B2 MAJ 1 CR:CR:VA !


 FUNCTION ZERO       298.15  0;,,N !
 FUNCTION DP         298.15  +P-101325;,,N !
 FUNCTION TROIS 298.15 3;,,N !
 FUNCTION UNTIER 298.15 TROIS**(-1);,,N !

 PARAMETER G(BCC_A2,VA:VA;0)  298.15  0.0;,,N 01DUP !

$****************************************************************************
$
$                                                            UNARY PARAMETERS
$
$----------------------------------------------------------------------------
$
$                                                                          Al
$
$                                                                   FUNCTIONS
$
 FUNCTION F154T      298.15
    +323947.58-25.1480943*T-20.859*T*LN(T)
    +4.5665E-05*T**2-3.942E-09*T**3-24275.5*T**(-1);
                    4300.0  Y
    +342017.233-54.0526109*T-17.7891*T*LN(T)+6.822E-05*T**2
    -1.91111667E-08*T**3-14782200*T**(-1);
                    8200.0  Y
    +542396.07-411.214335*T+22.2419*T*LN(T)-.00349619*T**2
    +4.0491E-08*T**3-2.0366965E+08*T**(-1);  1.00000E+04  N !
$
 FUNCTION F625T      298.15
    +496408.232+35.479739*T-41.6397*T*LN(T)
    +.00249636*T**2-4.90507333E-07*T**3+85390.3*T**(-1);
                     900.00  Y
    +497613.221+17.368131*T-38.85476*T*LN(T)-2.249805E-04*T**2
    -9.49003167E-09*T**3-5287.23*T**(-1);  2.80000E+03  N !
$
 FUNCTION GHSERAL    298.15
    -7976.15+137.093038*T-24.3671976*T*LN(T)
    -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1);
                     700.00  Y
    -11276.24+223.048446*T-38.5844296*T*LN(T)
    +.018531982*T**2-5.764227E-06*T**3+74092*T**(-1);
                     933.60  Y
    -11278.378+188.684153*T-31.748192*T*LN(T)
    -1.231E+28*T**(-9);,,  N !
$
 FUNCTION GHCPAL     298.15  +5481-1.8*T+GHSERAL;,,N !
$
 FUNCTION GBCCAL     298.15  +10083-4.813*T+GHSERAL;,,N !
 FUNCTION GALBCC     298.15  +10083-4.813*T+GHSERAL;,,N !
$
 FUNCTION GLIQAL     298.14
    +11005.029-11.841867*T+7.934E-20*T**7+GHSERAL;
                     933.59  Y
    +10482.282-11.253974*T+1.231E+28*T**(-9)+GHSERAL;,,N !
$
 FUNCTION GALHCP     298.15  +5481-1.8*T+GHSERAL;,,N !
$
$                                                                   GAS PHASE
$
 PARAMETER G(GAS,AL;0)  298.15  +F154T+R*T*LN(1E-05*P);,,N REF184 !
 PARAMETER G(GAS,AL2;0)  298.15  +F625T+R*T*LN(1E-05*P);,,N REF448 !
$
$                                                                LIQUID PHASE
$
 PARAMETER   G(LIQUID,AL;0)   298.13
      +11005.029-11.841867*T+7.934E-20*T**7+GHSERAL;
                                933.60  Y
      +10482.382-11.253974*T+1.231E+28*T**(-9)
      +GHSERAL;,,N 91DIN !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,AL:VA;0)  298.15  +GHSERAL;,,N 91DIN !
 PARAMETER V0(FCC_A1,AL:VA;0)  298.15  1.0162E-05;,,N DFT !

$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,AL:VA;0)  298.15  +GBCCAL;,,N 91DIN !
   FUNC B2ALVA 295.15 10000-T;,,N !
   FUNC LB2ALVA 298.15 150000;,,N !
 PARAMETER L(BCC_A2,AL,VA:VA;0)  298.15  B2ALVA+LB2ALVA;,,N 99DUP !
$
$                                                                HCP_A3 PHASE
$
 PARAMETER G(HCP_A3,AL:VA;0)  298.15  +GHCPAL;,,N 91DIN !
$
$                                                                BCC_B2 PHASE
$
 PARAMETER G(BCC_B2,AL:VA:VA;0)  298.15  .5*B2ALVA-.5*LB2ALVA;,,N 99DUP !
 PARAMETER G(BCC_B2,VA:AL:VA;0)  298.15  .5*B2ALVA-.5*LB2ALVA;,,N 99DUP !
$
$----------------------------------------------------------------------------
$
$                                                                          Co
$
$                                                                   FUNCTIONS
$
$
 FUNCTION F7439T     298.15  +416729.448-35.265807*T-20.78*T*LN(T)
     -.0080941*T**2+1.95473333E-06*T**3+68440*T**(-1);
                    6.00000E+02  Y
      +415600.439-4.47823809*T-25.919*T*LN(T)-3.217E-04*T**2+1.228E-08*T**3
     +69800*T**(-1);
                    1.60000E+03  Y
      +404059.608+60.9456563*T-34.475*T*LN(T)+.00226985*T**2
     -1.11743333E-07*T**3+2845480*T**(-1);
                    5.30000E+03  Y
      +619409.166-455.183402*T+25.674*T*LN(T)-.00531515*T**2
     +7.04183333E-08*T**3-1.4391985E+08*T**(-1);  1.00000E+04  N !
$
 FUNCTION F7591T     298.15  +739344.57+228.270513*T-75.86201*T*LN(T)
     +.02653785*T**2-3.82613167E-06*T**3+589055*T**(-1);
                    9.00000E+02  Y
      +766271.806-69.2721015*T-32.277*T*LN(T)-.0051345*T**2+5.3545E-07*T**3
     -2559210*T**(-1);
                    2.50000E+03  Y
      +742734.911+122.487527*T-58.296*T*LN(T)+.0049326*T**2
     -1.22191667E-07*T**3-1487375*T**(-1);
                    5.80000E+03  Y
      +1148759.49-821.285064*T+51.18*T*LN(T)-.0082646*T**2
     +1.77621667E-07*T**3-2.8575475E+08*T**(-1);  6.00000E+03  N !
$
 FUNCTION GHSERCO    298.15  +310.241+133.36601*T-25.0861*T*LN(T)
     -.002654739*T**2-1.7348E-07*T**3+72526.9*T**(-1);  1.76800E+03  Y
      -17197.666+253.28374*T-40.5*T*LN(T)+9.3488E+30*T**(-9);,,N !
$
 FUNCTION GCOFCC     298.15  +427.59-.61525*T+GHSERCO;,,N !
$
 FUNCTION GCOBCC     298.15  +2938-.7138*T+GHSERCO;,,N !
$
$                                                                   GAS PHASE
$
 PARAMETER G(GAS,CO;0)  298.15  +F7439T#+R#*T*LN(1E-05*P);,,N REF4469 !
 PARAMETER G(GAS,CO2;0)  298.15  +F7591T#+R#*T*LN(1E-05*P);,,N REF4561 !
$
$                                                                LIQUID PHASE
$
 PARAMETER G(LIQUID,CO;0)  298.15  +15085.037-8.931932*T
  -2.19801E-21*T**7+GHSERCO;  1.76800E+03  Y
   +16351.056-9.683796*T-9.3488E+30*T**(-9)+GHSERCO;,,N !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,CO:VA;0)  298.15  +GCOFCC;,,N 90DIN !
 PARAMETER TC(FCC_A1,CO:VA;0)  298.15  1396;,,N 90DIN !
 PARAMETER BMAGN(FCC_A1,CO:VA;0)  298.15  1.35;,,N 90DIN !
 PARAMETER V0(FCC_A1,CO:VA;0)  298.15  6.67741E-06;,,N DFT !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,CO:VA;0)  298.15  +GCOBCC;,,N 91DIN !
 PARAMETER TC(BCC_A2,CO:VA;0)  298.15  1450;,,N 91DIN !
 PARAMETER BMAGN(BCC_A2,CO:VA;0)  298.15  1.35;,,N 91DIN !

 FUNCTION GB2COVA    298.15  +148500-35.62*T;,,N 15LIU !
 FUNCTION LB2COVA    298.15  +45030-34.47*T;,,N 15LIU !

 PARAMETER G(BCC_A2,CO,VA:VA;0)  298.15  +GB2COVA+LB2COVA;,,N 15LIU !
$
$                                                                HCP_A3 PHASE
$
 PARAMETER G(HCP_A3,CO:VA;0)  298.15  +GHSERCO;,,N 91DIN !
 PARAMETER TC(HCP_A3,CO:VA;0)  298.15  1396;,,N 91DIN !
 PARAMETER BMAGN(HCP_A3,CO:VA;0)  298.15  1.35;,,N 91DIN !
$
$                                                                BCC_B2 PHASE
$
 PARAMETER G(BCC_B2,CO:VA:VA;0)  298.15  +.5*GB2COVA-.5*LB2COVA;,,N 15LIU !
 PARAMETER G(BCC_B2,VA:CO:VA;0)  298.15  +.5*GB2COVA-.5*LB2COVA;,,N 15LIU !
$
$----------------------------------------------------------------------------
$
$                                                                          Cr
$
$                                                                   FUNCTIONS
$
 FUNCTION F7454T     298.15
    +390765.331-31.5192154*T-21.36083*T*LN(T)
    +7.253215E-04*T**2-1.588679E-07*T**3+10285.15*T**(-1);
                     1100.0  Y
    +393886.928-44.107465*T-19.96003*T*LN(T)+.001513089*T**2
    -4.23648333E-07*T**3-722515*T**(-1);
                     2000.0  Y
    +421372.003-231.888524*T+5.362886*T*LN(T)-.00848877*T**2
    +2.984635E-07*T**3-6015405*T**(-1);
                     3300.0  Y
    +305164.698+251.019831*T-55.20304*T*LN(T)+.005324585*T**2
    -2.850405E-07*T**3+34951485*T**(-1);
                     5100.0  Y
    +1069921.1-1708.93262*T+175.0508*T*LN(T)-.025574185*T**2
    +4.94447E-07*T**3-4.4276355E+08*T**(-1);
                     7600.0  Y
    -871952.838+1686.47356*T-204.5589*T*LN(T)+.007475225*T**2
    -4.618745E-08*T**3+1.423504E+09*T**(-1);  1.00000E+04  N !
$
 FUNCTION F7735T     298.15  +598511.402+41.5353219*T-40.56798*T*LN(T)
    +.004961847*T**2-1.61216717E-06*T**3+154422.85*T**(-1);
                     800.00  Y
    +613345.232-104.20799*T-19.7643*T*LN(T)-.007085085*T**2
    -4.69883E-07*T**3-1738066.5*T**(-1);
                     1400.0  Y
    +642608.843-369.286259*T+17.64743*T*LN(T)-.02767321*T**2
    +1.605906E-06*T**3-5831655*T**(-1);
                     2300.0  Y
    +553119.895+159.188556*T-52.07969*T*LN(T)-.004229401*T**2
    +1.5939925E-07*T**3+14793625*T**(-1);
                     3900.0  Y
    +347492.339+623.137624*T-105.0428*T*LN(T)+3.9699545E-04*T**2
    +1.51783483E-07*T**3+1.4843765E+08*T**(-1);
                     5800.0  Y
    -484185.055+2598.25559*T-334.7145*T*LN(T)+.028597625*T**2
    -4.97520167E-07*T**3+7.135805E+08*T**(-1);  6.00000E+03  N !
$
 FUNCTION GHSERCR    298.14
    -8856.94+157.48*T-26.908*T*LN(T)
    +.00189435*T**2-1.47721E-06*T**3+139250*T**(-1);
                     2180.0  Y
    -34869.344+344.18*T-50*T*LN(T)-2.88526E+32*T**(-9);,,N !
$
 FUNCTION GCRLIQ     298.15
    +24339.955-11.420225*T+2.37615E-21*T**7+GHSERCR;
                     2180.0  Y
    -16459.984+335.616316*T-50*T*LN(T);,,N !
$
 FUNCTION GFCCCR     298.15  +7284+.163*T+GHSERCR;,,N !
$
 FUNCTION GHCPCR     298.15  +4438+GHSERCR;,,N !
$
 FUNCTION ACRBCC     298.15  +1.7E-05*T+9.2E-09*T**2;,,N !
 FUNCTION BCRBCC     298.15  +1+2.6E-11*P;,,N !
 FUNCTION CCRBCC     298.15  2.08E-11;,,N !
 FUNCTION DCRBCC     298.15  +1*LN(BCRBCC);,,N !
 FUNCTION VCRBCC     298.15  +7.188E-06*EXP(ACRBCC);,,N !
 FUNCTION ECRBCC     298.15  +1*LN(CCRBCC);,,N !
 FUNCTION XCRBCC     298.15  +1*EXP(.8*DCRBCC)-1;,,N !
 FUNCTION YCRBCC     298.15  +VCRBCC*EXP(-ECRBCC);,,N !
 FUNCTION ZCRBCC     298.15  +1*LN(XCRBCC);,,N !
 FUNCTION GPCRBCC    298.15  +YCRBCC*EXP(ZCRBCC);,,N !
$
 FUNCTION ACRLIQ     298.15  +1.7E-05*T+9.2E-09*T**2;,,N !
 FUNCTION BCRLIQ     298.15  +1+4.65E-11*P;,,N !
 FUNCTION CCRLIQ     298.15  3.72E-11;,,N !
 FUNCTION DCRLIQ     298.15  +1*LN(BCRLIQ);,,N !
 FUNCTION VCRLIQ     298.15  +7.653E-06*EXP(ACRLIQ);,,N !
 FUNCTION ECRLIQ     298.15  +1*LN(CCRLIQ);,,N !
 FUNCTION XCRLIQ     298.15  +1*EXP(.8*DCRLIQ)-1;,,N !
 FUNCTION YCRLIQ     298.15  +VCRLIQ*EXP(-ECRLIQ);,,N !
 FUNCTION ZCRLIQ     298.15  +1*LN(XCRLIQ);,,N !
 FUNCTION GPCRLIQ    298.15  +YCRLIQ*EXP(ZCRLIQ);,,N !
$
$                                                                   GAS PHASE
$
 PARAMETER G(GAS,CR;0)  298.15  +F7454T+R*T*LN(1E-05*P);,,N REF4465 !
 PARAMETER G(GAS,CR2;0)  298.15  +F7735T+R*T*LN(1E-05*P);,,  N REF4591 !
$
$                                                                LIQUID PHASE
$
 PARAMETER G(LIQUID,CR;0)  298.15  +GCRLIQ+GPCRLIQ;,,  N 91DIN !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,CR:VA;0)  298.15  +GFCCCR+GPCRBCC;,,N 89DIN !
 PARAMETER TC(FCC_A1,CR:VA;0)  298.15  -1109;,,N 89DIN !
 PARAMETER BMAGN(FCC_A1,CR:VA;0)  298.15  -2.46;,,N 89DIN !
 PARAMETER V0(FCC_A1,CR:VA;0)  298.15  7.28246E-06;,,N DFT !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,CR:VA;0)  298.15  +GHSERCR+GPCRBCC;,,N 91DIN !
 PARAMETER TC(BCC_A2,CR:VA;0)  298.15  -311.5;,,N 89DIN !
 PARAMETER BMAGN(BCC_A2,CR:VA;0)  298.15  -.008;,,N 89DIN !
 PARAMETER L(BCC_A2,CR,VA:VA;0)  298.15  100000;,,N 01DUP !
$
$                                                                HCP_A3 PHASE
$
 PARAMETER G(HCP_A3,CR:VA;0)  298.15  +GHCPCR;,,N 90DIN !
 PARAMETER TC(HCP_A3,CR:VA;0)  298.15  -1109;,,N 90DIN1 !
 PARAMETER BMAGN(HCP_A3,CR:VA;0)  298.15  -2.46;,,N 90DIN1 !
$
$                                                                BCC_B2 PHASE
$
 PARAMETER G(BCC_B2,CR:VA:VA;0)  298.15  0;,,N 01DUP !
 PARAMETER G(BCC_B2,VA:CR:VA;0)  298.15  0;,,N 01DUP !
$
$----------------------------------------------------------------------------
$
$                                                                          Ni
$
$                                                                   FUNCTIONS
$
 FUNCTION F13191T    298.15
    +417658.868-44.7777921*T-20.056*T*LN(T)
    -.0060415*T**2+1.24774E-06*T**3-16320*T**(-1);
                     800.00  Y
    +413885.448+9.41787679*T-28.332*T*LN(T)+.00173115*T**2
    -8.399E-08*T**3+289050*T**(-1);
                     3900.0  Y
    +440866.732-62.5810038*T-19.819*T*LN(T)+5.067E-04*T**2
    -4.93233333E-08*T**3-15879735*T**(-1);
                     7600.0  Y
    +848806.287-813.398164*T+64.69*T*LN(T)-.00731865*T**2
    +8.71833333E-08*T**3-3.875846E+08*T**(-1);  10000.  N !
$
 FUNCTION F13265T    298.15
    +638073.279-68.1901928*T-24.897*T*LN(T)
    -.0313584*T**2+5.93355333E-06*T**3-14215*T**(-1);
                     800.00  Y
    +611401.772+268.084821*T-75.25401*T*LN(T)+.01088525*T**2
    -7.08741667E-07*T**3+2633835*T**(-1);
                     2100.0  Y
    +637459.339+72.0712678*T-48.587*T*LN(T)-9.09E-05*T**2
    +9.12933333E-08*T**3-1191755*T**(-1);
                     4500.0 Y
    +564540.781+329.599011*T-80.11301*T*LN(T)+.00578085*T**2
    -1.08841667E-07*T**3+29137900*T**(-1);  6000.0  N !
$
 FUNCTION GHSERNI    298.14
    -5179.159+117.854*T-22.096*T*LN(T)
    -.0048407*T**2;
                     1728.0  Y
    -27840.655+279.135*T-43.1*T*LN(T)+1.12754E+31*T**(-9);,,  N   !
$
 FUNCTION GHCPNI     298.15  +1046+1.2552*T+GHSERNI;,,N !
$
 FUNCTION GBCCNI     298.15  +8715.084-3.556*T+GHSERNI;,,,   N !
 FUNCTION GNIBCC     298.15  +8715.084-3.556*T+GHSERNI;,,,   N !
$
$                                                                   GAS PHASE
$
 PARAMETER G(GAS,NI;0)  298.15  +F13191T+R*T*LN(1E-05*P);,,N REF7504 !
 PARAMETER G(GAS,NI2;0)  298.15 +F13265T+R*T*LN(1E-05*P);,,N REF7553 !
$
$                                                                LIQUID PHASE
$
 PARAMETER G(LIQUID,NI;0) 298.13
      +16414.686-9.397*T-3.82318E-21*T**7+GHSERNI;
                            1728.0  Y
      +18290.88-10.537*T-1.12754E+31*T**(-9)
      +GHSERNI;,,N 91DIN !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,NI:VA;0)  298.15  +GHSERNI;,,N 91DIN !
 PARAMETER TC(FCC_A1,NI:VA;0)  298.15  633;,,N 89DIN !
 PARAMETER BMAGN(FCC_A1,NI:VA;0)  298.15  .52;,,N 89DIN !
 PARAMETER V0(FCC_A1,NI:VA;0)  298.15  6.69108E-06;,,N DFT !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,NI:VA;0)  298.15  +GBCCNI;,,N 91DIN !
 PARAMETER TC(BCC_A2,NI:VA;0)  298.15  575;,,N 89DIN !
 PARAMETER BMAGN(BCC_A2,NI:VA;0)  298.15  .85;,,N 89DIN !
   FUNC B2NIVA 295.15 +162397.3-27.40575*T;,,N !
   FUNC LB2NIVA 298.15 -64024.38+26.49419*T;,,N !
 PARAMETER L(BCC_A2,NI,VA:VA;0)  298.15  B2NIVA+LB2NIVA;,,N 99DUP !
$
$                                                                HCP_A3 PHASE
$
 PARAMETER G(HCP_A3,NI:VA;0)  298.15  +GHCPNI;,,N 90DIN !
 PARAMETER TC(HCP_A3,NI:VA;0)  298.15  633;,,N 88GUI !
 PARAMETER BMAGN(HCP_A3,NI:VA;0)  298.15  .52;,,N 88GUI !
$
$                                                                BCC_B2 PHASE
$
 PARAMETER G(BCC_B2,VA:NI:VA;0)  298.15  .5*B2NIVA-.5*LB2NIVA;,,N 99DUP !
 PARAMETER G(BCC_B2,NI:VA:VA;0)  298.15  .5*B2NIVA-.5*LB2NIVA;,,N 99DUP !
$
$****************************************************************************
$
$                                                           BINARY PARAMETERS
$
$----------------------------------------------------------------------------
$
$                                                                       Al-Co
$                             From Dupin & Ansara (1998)
$                             A2/B2 implemented, LB2ALCO changed slightly
$                             in the current work
$
$                                                                LIQUID PHASE
$
 PARAMETER G(LIQUID,AL,CO;0)  298.15  -152470+40.259*T;,,N 98DUP !
 PARAMETER G(LIQUID,AL,CO;1)  298.15  -57527.5+27.0453*T;,,N 98DUP !
 PARAMETER G(LIQUID,AL,CO;2)  298.15  +30494-8.0518*T;,,N 98DUP !
 PARAMETER G(LIQUID,AL,CO;3)  298.15  +24655-11.591*T;,,N 98DUP !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,AL,CO:VA;0)  298.15  -122840+22.925*T;,,N 98DUP !
 PARAMETER G(FCC_A1,AL,CO:VA;2)  298.15  +24568-4.585*T;,,N 98DUP !
 PARAMETER TC(FCC_A1,AL,CO:VA;0)  298.15  -1830;,,N 98DUP !
 PARAMETER TC(FCC_A1,AL,CO:VA;1)  298.15  970;,,N 98DUP !
 PARAMETER BMAGN(FCC_A1,AL,CO:VA;0)  298.15  10;,,N 98DUP !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,AL,CO:VA;0)  298.15  +GB2ALCO+LB2ALCO;,,N 15LIU !
$
$                                                                HCP_A3 PHASE
$
 PARAMETER TC(HCP_A3,AL,CO:VA;0)  298.15  -1830;,,N 98DUP !
 PARAMETER TC(HCP_A3,AL,CO:VA;1)  298.15  970;,,N 98DUP !
 PARAMETER BMAGN(HCP_A3,AL,CO:VA;0)  298.15  10;,,N 98DUP !
$
$                                                                BCC_B2 PHASE
$                                                                  metastable
$ Present work: 2015 CRALDAD
 FUNCTION GB2ALCO    298.15  -138500+34.62*T;,,N 98DUP !
 FUNCTION LB2ALCO    298.15  +56531-37.04*T;,,N 15LIU !

 PARAMETER G(BCC_B2,AL:CO:VA;0)  298.15  +.5*GB2ALCO-.5*LB2ALCO;,,N 15LIU !
 PARAMETER G(BCC_B2,CO:AL:VA;0)  298.15  +.5*GB2ALCO-.5*LB2ALCO;,,N 15LIU !
$
$                                                               L12_FCC PHASE
$                                                                  metastable
$ Present work: 2015 CRALDAD
$ Using the same interaction constraints shown by Dupin for Al-Cr-Ni
     FUN U1ALCO  298.15 -4872;,,N  15LIU !
     FUN U3ALCO  298.15 0.0; 6000.00  N 15LIU !
     FUN U4ALCO  298.15 3023; 6000.00 N  15LIU !
   FUNCTION L04ALCO 298.15 U3ALCO;,,N !
   FUNCTION L14ALCO 298.15 U4ALCO;,,N !
   FUNCTION ALCO3 298.15 3*U1ALCO;,,N !
   FUNCTION AL2CO2 298.15 4*U1ALCO;,,N !
   FUNCTION AL3CO 298.15 3*U1ALCO;,,N !
 PARAMETER G(L12_FCC,CO:AL:VA;0)  298.15  +ALCO3;,,  N  15LIU !
 PARAMETER G(L12_FCC,AL:CO:VA;0)  298.15  +AL3CO;,,  N  15LIU !
 PARAMETER L(L12_FCC,AL,CO:AL:VA;0) 298.15
     -1.5*ALCO3+1.5*AL2CO2+1.5*AL3CO;,,N 15LIU !
 PARAMETER L(L12_FCC,AL,CO:CO:VA;0) 298.15
     +1.5*ALCO3+1.5*AL2CO2-1.5*AL3CO;,,N 15LIU !
 PARAMETER L(L12_FCC,AL,CO:AL:VA;1) 298.15
     +0.5*ALCO3-1.5*AL2CO2+1.5*AL3CO;,,N 15LIU !
 PARAMETER L(L12_FCC,AL,CO:CO:VA;1) 298.15
     -1.5*ALCO3+1.5*AL2CO2-0.5*AL3CO;,,N 15LIU !
 PARAMETER L(L12_FCC,*:AL,CO:VA;0) 298.15 +L04ALCO;,,N 15LIU !
 PARAMETER L(L12_FCC,*:AL,CO:VA;1) 298.15 +L14ALCO;,,N 15LIU !
 PARAMETER L(L12_FCC,AL,CO:*:VA;0) 298.15 +3*L04ALCO;,,N 15LIU !
 PARAMETER L(L12_FCC,AL,CO:*:VA;1) 298.15 +3*L14ALCO;,,N 15LIU !
$
$                                                               AL13CO4 PHASE
$
 PHASE AL13CO4  %  2 13   4 !
 CONSTITUENT AL13CO4  :AL : CO :  !

 PARAMETER G(AL13CO4,AL:CO;0)  298.15  -711760+170.4*T+13*GHSERAL
  +4*GHSERCO;,,N 98DUP !
$
$                                                                 AL3CO PHASE
$
 PHASE AL3CO  %  2 3   1 !
 CONSTITUENT AL3CO  :AL : CO :  !

 PARAMETER G(AL3CO,AL:CO;0)  298.15  -174490+41.735*T+3*GHSERAL
 +GHSERCO;,,N 98DUP !
$
$                                                                AL5CO2 PHASE
$
 PHASE AL5CO2  %  2 5   2 !
 CONSTITUENT AL5CO2  :AL : CO :  !

 PARAMETER G(AL5CO2,AL:CO;0)  298.15  -335100+81.65*T+5*GHSERAL
 +2*GHSERCO;,,N 98DUP !
$
$                                                                AL9CO2 PHASE
$
 PHASE AL9CO2  %  2 9   2 !
 CONSTITUENT AL9CO2  :AL : CO :  !

 PARAMETER G(AL9CO2,AL:CO;0)  298.15  -391800+103.77*T+9*GHSERAL
 +2*GHSERCO;,,N 98DUP !
$
$----------------------------------------------------------------------------
$
$                                                                       Al-Cr
$                             Mainly from Saunders (COST507)
$                             Metastable B2 and L12 from revision of Al-Cr-Ni
$
$                                                                LIQUID PHASE
$
 PARAMETER L(LIQUID,AL,CR;0)  298.15  -29000;,,N 91SAU1 !
 PARAMETER L(LIQUID,AL,CR;1)  298.15  -11000;,,N 91SAU1 !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,AL,CR:VA;0)  298.15  -45900+6*T;,,N 91SAU1 !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,AL,CR:VA;0)  298.15  -54900+10*T;,,N 91SAU1 !
$
$                                                                BCC_B2 PHASE
$                                                                  metastable
$ Present work: july 1999, study of Al-Cr-Ni, revision of NDTH. The B2
$ phase is not stabilized enough to become stable in the Al-Cr. It is
$ thus not in agreement with "T. Helander, and O. Tolochko, J. of Phase
$ Eq, 20 (1) 1999, 57-60." Further study on the extension of the B2 phase
$ towards AlCr in Al-Cr-Ni would be desirable.
 PARAMETER G(BCC_B2,AL:CR:VA;0)  298.15  -2000;,,N 01DUP  !
 PARAMETER G(BCC_B2,CR:AL:VA;0)  298.15  -2000;,,N 01DUP !
$
$                                                               L12_FCC PHASE
$                                                                  metastable
$ Present work: july 1999, study of Al-Cr-Ni, revision of NDTH.
     FUN U1ALCR  298.15 -830;,,N  01DUP !
     FUN U3ALCR  298.15 0.0; 6000.00   01DUP !
     FUN U4ALCR  298.15 0.0; 6000.00 N  01DUP !
   FUNCTION L04ALCR 298.15 U3ALCR;,,N !
   FUNCTION L14ALCR 298.15 U4ALCR;,,N !
   FUNCTION ALCR3 298.15 3*U1ALCR;,,N !
   FUNCTION AL2CR2 298.15 4*U1ALCR;,,N !
   FUNCTION AL3CR 298.15 3*U1ALCR;,,N !
 PARAMETER G(L12_FCC,CR:AL:VA;0)  298.15  +ALCR3;,,  N  01DUP !
 PARAMETER G(L12_FCC,AL:CR:VA;0)  298.15  +AL3CR;,,  N  01DUP !
 PARAMETER L(L12_FCC,AL,CR:AL:VA;0) 298.15
     -1.5*ALCR3+1.5*AL2CR2+1.5*AL3CR;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,CR:CR:VA;0) 298.15
     +1.5*ALCR3+1.5*AL2CR2-1.5*AL3CR;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,CR:AL:VA;1) 298.15
     +0.5*ALCR3-1.5*AL2CR2+1.5*AL3CR;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,CR:CR:VA;1) 298.15
     -1.5*ALCR3+1.5*AL2CR2-0.5*AL3CR;,,N 01DUP !
 PARAMETER L(L12_FCC,*:AL,CR:VA;0) 298.15 +L04ALCR;,,N 01DUP !
 PARAMETER L(L12_FCC,*:AL,CR:VA;1) 298.15 +L14ALCR;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,CR:*:VA;0) 298.15 +3*L04ALCR;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,CR:*:VA;1) 298.15 +3*L14ALCR;,,N 01DUP !
$
$                                                               AL11CR2 PHASE
$
 PHASE AL11CR2  %  3 10   1   2 !
 CONST AL11CR2  :AL : AL : CR : !
 PARAMETER G(AL11CR2,AL:AL:CR;0)  298.15
     +11*GHSERAL+2*GHSERCR-175500+25.805*T;,,N 91SAU1 !
$
$                                                               AL13CR2 PHASE
$
 PHASE AL13CR2  %  2 13   2 !
 CONST AL13CR2  :AL : CR :  !
 PARAMETER G(AL13CR2,AL:CR;0)  298.15
     +13*GHSERAL+2*GHSERCR-174405+22.2*T;,,N 91SAU1 !
$
$                                                                 AL4CR PHASE
$
 PHASE AL4CR  %  2 4   1 !
 CONST AL4CR  :AL : CR :  !
 PARAMETER G(AL4CR,AL:CR;0)  298.15
     +4*GHSERAL+GHSERCR-89025+19.05*T;,,N 91SAU1 !
$
$                                                              AL8CR5_H PHASE
$
 PHASE AL8CR5_H  %  2 8   5 !
 CONST AL8CR5_H  :AL : CR :  !
 PARAMETER G(AL8CR5_H,AL:CR;0)  298.15
     +8*GHSERAL+5*GHSERCR-147732-58.5*T;,,N 91SAU1 !
$
$                                                              AL8CR5_L PHASE
$
 PHASE AL8CR5_L  %  2 8   5 !
 CONST AL8CR5_L  :AL : CR :  !
 PARAMETER G(AL8CR5_L,AL:CR;0)  298.15
     +8*GHSERAL+5*GHSERCR-229515;,,N 91SAU1 !
$
$                                                              AL9CR4_H PHASE
$
 PHASE AL9CR4_H  %  2 9   4 !
 CONST AL9CR4_H  :AL : CR :  !
 PARAMETER G(AL9CR4_H,AL:CR;0)  298.15
     +9*GHSERAL+4*GHSERCR-134433-56.16*T;,,N 91SAU1 !
$
$                                                              AL9CR4_L PHASE
$
 PHASE AL9CR4_L  %  2 9   4 !
 CONST AL9CR4_L  :AL : CR :  !
 PARAMETER G(AL9CR4_L,AL:CR;0)  298.15
     +9*GHSERAL+4*GHSERCR-230750+16.094*T;,,N 91SAU1 !
$
$                                                                 ALCR2 PHASE
$
 PHASE ALCR2  %  2 1   2 !
 CONST ALCR2  :AL : CR :  !
 PARAMETER G(ALCR2,AL:CR;0)  298.15
     +GHSERAL+2*GHSERCR-32700-8.79*T;,,N 91SAU1 !
$
$                                                            SIGMA_SGTE PHASE
$                                                                  metastable
 PARAMETER G(SIGMA_SGTE,AL:AL:CR;0)  298.15
 +161148+8*GHSERAL+18*GALBCC+4*GHSERCR;,,N 15LIU !
 PARAMETER G(SIGMA_SGTE,AL:CR:CR;0)  298.15
 +47886+8*GHSERAL+22*GHSERCR;,,N 15LIU !
$
$----------------------------------------------------------------------------
$
$                                                                       Al-Ni
$                    Mainly from ND thesis,
$                    slightly revised to get better solvus at low temperature
$
$                                                                LIQUID PHASE
$
 PARAMETER L(LIQUID,AL,NI;0)  298.15 -207109.28+41.31501*T;,,N 95DUP3 !
 PARAMETER L(LIQUID,AL,NI;1)  298.15 -10185.79+5.8714*T;,,N 95DUP3 !
 PARAMETER L(LIQUID,AL,NI;2)  298.15 +81204.81-31.95713*T;,,N 95DUP3 !
 PARAMETER L(LIQUID,AL,NI;3)  298.15  +4365.35-2.51632*T;,,N 95DUP3 !
 PARAMETER L(LIQUID,AL,NI;4)  298.15  -22101.64+13.16341*T;,,N 95DUP3 !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER TC(FCC_A1,AL,NI:VA;0)  298.15  -1112;,,N 95DUP3 !
 PARAMETER TC(FCC_A1,AL,NI:VA;1)  298.15  1745;,,N 95DUP3 !
 PARAMETER G(FCC_A1,AL,NI:VA;0)  298.15  -162407.75+16.212965*T;,,N 95DUP3 !
 PARAMETER G(FCC_A1,AL,NI:VA;1)  298.15  +73417.798-34.914168*T;,,N 95DUP3 !
 PARAMETER G(FCC_A1,AL,NI:VA;2)  298.15  +33471.014-9.8373558*T;,,N 95DUP3 !
 PARAMETER G(FCC_A1,AL,NI:VA;3)  298.15  -30758.01+10.25267*T;,,N 95DUP3 !
$
$                                                                BCC_A2 PHASE
$                                                                  metastable
$
   FUNC B2ALNI 295.15 -152397.3+26.40575*T;,,N !
   FUNC LB2ALNI 298.15 -52440.88+11.30117*T;,,N !
 PARAMETER L(BCC_A2,AL,NI:VA;0)  298.15  B2ALNI+LB2ALNI;,,N 99DUP!
$
$                                                                BCC_B2 PHASE
$
 PARAMETER G(BCC_B2,AL:NI:VA;0)  298.15  .5*B2ALNI-.5*LB2ALNI;,,N 99DUP !
 PARAMETER G(BCC_B2,NI:AL:VA;0)  298.15  .5*B2ALNI-.5*LB2ALNI;,,N 99DUP !
$
$                                                               L12_FCC PHASE
$
     FUN UALNI 298.15 -22212.8931+4.39570389*T;,,,N 01DUP !
     FUN U1ALNI 298.15 2*UNTIER*UALNI;,,,N 01DUP !
     FUN U3ALNI 298.15 0;,,,N 01DUP !
     FUN U4ALNI 298.15 7203.60609-3.74273030*T;,,,N 01DUP !
   FUNCTION L04ALNI 298.15 U3ALNI;,,N 01DUP !
   FUNCTION L14ALNI 298.15 U4ALNI;,,N 01DUP !
   FUNCTION ALNI3   298.15 +3*U1ALNI;,,,N 01DUP !
   FUNCTION AL2NI2  298.15 +4*U1ALNI;,,,N 01DUP !
   FUNCTION AL3NI   298.15 +3*U1ALNI;,,,N 01DUP !
 PARAMETER G(L12_FCC,NI:AL:VA;0)  298.15  +ALNI3;,,N 01DUP !
 PARAMETER G(L12_FCC,AL:NI:VA;0)  298.15  +AL3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,NI:AL:VA;0) 298.15
     -1.5*ALNI3+1.5*AL2NI2+1.5*AL3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,NI:NI:VA;0) 298.15
     +1.5*ALNI3+1.5*AL2NI2-1.5*AL3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,NI:AL:VA;1) 298.15
     +0.5*ALNI3-1.5*AL2NI2+1.5*AL3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,NI:NI:VA;1) 298.15
     -1.5*ALNI3+1.5*AL2NI2-0.5*AL3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,*:AL,NI:VA;0) 298.15 +L04ALNI;,,N 01DUP !
 PARAMETER L(L12_FCC,*:AL,NI:VA;1) 298.15 +L14ALNI;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,NI:*:VA;0) 298.15 +3*L04ALNI;,,N 01DUP !
 PARAMETER L(L12_FCC,AL,NI:*:VA;1) 298.15 +3*L14ALNI;,,N 01DUP !
$
$                                                                AL3NI1 PHASE
$
 PHASE AL3NI1  %  2 .75   .25 !
 CONST AL3NI1  :AL : NI :  !
 PARAMETER G(AL3NI1,AL:NI;0)  298.15
 -48483.73+12.29913*T
 +.75*GHSERAL+.25*GHSERNI;,,N 95DUP3 !
$
$                                                                AL3NI2 PHASE
$
 PHASE AL3NI2  %  3 3   2   1 !
 CONST AL3NI2  :AL : AL,NI% : NI,VA% :  !
 PARAMETER  G(AL3NI2,AL:AL:NI;0)  298.15  +5*GBCCAL+GBCCNI
     -39465.978+7.89525*T;,,N 95DUP3 !
 PARAMETER G(AL3NI2,AL:NI:NI;0)  298.15  +3*GBCCAL+3*GBCCNI
     -427191.9+79.21725*T;,,N 95DUP3 !
 PARAMETER  G(AL3NI2,AL:AL:VA;0) 298.15  +5*GBCCAL
     +30000-3*T;,,N 95DUP3 !
 PARAMETER  G(AL3NI2,AL:NI:VA;0)  298.15  +3*GBCCAL+2*GBCCNI
     -357725.92+68.322*T;,,N 95DUP3 !
 PARAMETER  L(AL3NI2,AL:AL,NI:*;0)  298.15
     -193484.18+131.79*T;,,N 95DUP3 !
 PARAMETER  L(AL3NI2,AL:*:NI,VA;0)  298.15
     -22001.7+7.0332*T;,,N 95DUP3 !
$
$                                                                AL3NI5 PHASE
$
 PHASE AL3NI5  %  2 .375   .625 !
 CONST AL3NI5  :AL : NI :  !
 PARAMETER G(AL3NI5,AL:NI;0)  298.15  +.375*GHSERAL+.625*GHSERNI
     -55507.7594+7.2648103*T;,,N 95DUP3 !
$
$----------------------------------------------------------------------------
$
$                                                                       Co-Cr
$                             Mainly from Kusoffsky
$                             Metastable B2 and L12 from the current work
$
$                                                                LIQUID PHASE
$
 PARAMETER G(LIQUID,CO,CR;0)  3.00000E+02  -3034-5.614*T;,,N 97KUS !
 PARAMETER G(LIQUID,CO,CR;1)  3.00000E+02  909;,,N 97KUS !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,CO,CR:VA;0)  3.00000E+02  +1500-9.592*T;,,N 97KUS !
 PARAMETER TC(FCC_A1,CO,CR:VA;0)  3.00000E+02  -1795;,,N 97KUS !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,CO,CR:VA;0)  298.15  +17208-13.519*T;,,N 97KUS !
 PARAMETER G(BCC_A2,CO,CR:VA;1)  298.15  -5470;,,N 97KUS !
$
$                                                                HCP_A3 PHASE
$
 PARAMETER G(HCP_A3,CO,CR:VA;0)  3.00000E+02  -6436;,,N 97KUS !
 PARAMETER TC(HCP_A3,CO,CR:VA;0)  3.00000E+02  -1795;,,N 97KUS !
$
$                                                                BCC_B2 PHASE
$                                                                  metastable
$
$ Present work: 2015 CRALDAD
 FUNCTION GB2COCR    298.15  -6.148723*T;,,N 15LIU !

 PARAMETER G(BCC_B2,CO:CR:VA;0)  298.15  +.5*GB2COCR;,,N 15LIU !
 PARAMETER G(BCC_B2,CR:CO:VA;0)  298.15  +.5*GB2COCR;,,N 15LIU !
$
$                                                               L12_FCC PHASE
$                                                                  metastable
$ Present work: 2015 CRALDAD
$ Using the same interaction constraints shown by Dupin for Al-Cr-Ni
     FUN U1COCR 298.15 0;,,,N 15LIU !
     FUN U3COCR 298.15 0;,,,N 15LIU !
     FUN U4COCR 298.15 0;,,,N 15LIU !
   FUNCTION L04COCR 298.15 U3COCR;,,N 15LIU !
   FUNCTION L14COCR 298.15 U4COCR;,,N 15LIU !
   FUNCTION COCR3   298.15 +3*U1COCR;,,,N 15LIU !
   FUNCTION CO2CR2  298.15 +4*U1COCR;,,,N 15LIU !
   FUNCTION CO3CR   298.15 +3*U1COCR;,,,N 15LIU !
 PARAMETER G(L12_FCC,CR:CO:VA;0)  298.15  +COCR3;,,  N 15LIU !
 PARAMETER G(L12_FCC,CO:CR:VA;0)  298.15  +CO3CR;,,  N 15LIU !
 PARAMETER L(L12_FCC,CO,CR:CO:VA;0) 298.15
     -1.5*COCR3+1.5*CO2CR2+1.5*CO3CR;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,CR:CR:VA;0) 298.15
     +1.5*COCR3+1.5*CO2CR2-1.5*CO3CR;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,CR:CO:VA;1) 298.15
     +0.5*COCR3-1.5*CO2CR2+1.5*CO3CR;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,CR:CR:VA;1) 298.15
     -1.5*COCR3+1.5*CO2CR2-0.5*CO3CR;,,N 15LIU !
 PARAMETER L(L12_FCC,*:CO,CR:VA;0) 298.15 +L04COCR;,,N 15LIU !
 PARAMETER L(L12_FCC,*:CO,CR:VA;1) 298.15 +L14COCR;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,CR:*:VA;0) 298.15 +3*L04COCR;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,CR:*:VA;1) 298.15 +3*L14COCR;,,N 15LIU !
$
$                                                            SIGMA_SGTE PHASE
$
 PARAMETER G(SIGMA_SGTE,CO:CO:CR;0)  298.15
 +17077-30.518*T+8*GCOFCC+18*GCOBCC+4*GHSERCR;,,N 97KUS !
 PARAMETER G(SIGMA_SGTE,CO:CR:CR;0)  298.15
 -7466-104.215*T+8*GCOFCC+22*GHSERCR;,,N 97KUS !
$
$----------------------------------------------------------------------------
$
$                                                                       Co-Ni
$                             Mainly from SGTE
$                             Metastable B2 and L12 from the current work
$
$                                                                LIQUID PHASE
$
 PARAMETER G(LIQUID,CO,NI;0)  298.15  1331;,,N 87GU3 !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,CO,NI:VA;0)  298.15  -800+1.2629*T;,,N 87GU3 !
 PARAMETER TC(FCC_A1,CO,NI:VA;0)  298.15  411;,,N 87GU3 !
 PARAMETER TC(FCC_A1,CO,NI:VA;1)  298.15  -99;,,N 87GU3 !
 PARAMETER BMAGN(FCC_A1,CO,NI:VA;0)  298.15  1.046;,,N 87GU3 !
 PARAMETER BMAGN(FCC_A1,CO,NI:VA;1)  298.15  .165;,,N 87GU3 !
$
$                                                                BCC_A2 PHASE
$                                                                  metastable
 PARAMETER G(BCC_A2,CO,NI:VA;0)  298.15  2000;,,N 87GU3 !
 PARAMETER TC(BCC_A2,CO,NI:VA;0)  298.15  556;,,N 87GU3 !
 PARAMETER TC(BCC_A2,CO,NI:VA;1)  298.15  -288;,,N 87GU3 !
 PARAMETER BMAGN(BCC_A2,CO,NI:VA;0)  298.15  .474;,,N 87GU3 !
$
$                                                                HCP_A3 PHASE
$
 PARAMETER G(HCP_A3,CO,NI:VA;0)  298.15  -1620-.385*T;,,N 87GU3 !
 PARAMETER TC(HCP_A3,CO,NI:VA;0)  298.15  411;,,N 87GU3 !
 PARAMETER TC(HCP_A3,CO,NI:VA;1)  298.15  -99;,,N 87GU3 !
 PARAMETER BMAGN(HCP_A3,CO,NI:VA;0)  298.15  1.046;,,N 87GU3 !
 PARAMETER BMAGN(HCP_A3,CO,NI:VA;1)  298.15  .165;,,N 87GU3 !
$
$                                                                BCC_B2 PHASE
$                                                                  metastable
$
$ Present work: 2015 CRALDAD
 FUNCTION GB2CONI    298.15  +7728-3.328*T;,,N 15LIU !

 PARAMETER G(BCC_B2,CO:NI:VA;0)  298.15  +.5*GB2CONI;,,N 15LIU !
 PARAMETER G(BCC_B2,NI:CO:VA;0)  298.15  +.5*GB2CONI;,,N 15LIU !
$
$                                                               L12_FCC PHASE
$                                                                  metastable
$ Present work: 2015 CRALDAD
$ Using the same interaction constraints shown by Dupin for Al-Cr-Ni
     FUN U1CONI 298.15 0;,,,N 15LIU !
     FUN U3CONI 298.15 0;,,,N 15LIU !
     FUN U4CONI 298.15 0;,,,N 15LIU !
   FUNCTION L04CONI 298.15 U3CONI;,,N 15LIU !
   FUNCTION L14CONI 298.15 U4CONI;,,N 15LIU !
   FUNCTION CONI3   298.15 +3*U1CONI;,,,N 15LIU !
   FUNCTION CO2NI2  298.15 +4*U1CONI;,,,N 15LIU !
   FUNCTION CO3NI   298.15 +3*U1CONI;,,,N 15LIU !
 PARAMETER G(L12_FCC,NI:CO:VA;0)  298.15  +CONI3;,,  N 15LIU !
 PARAMETER G(L12_FCC,CO:NI:VA;0)  298.15  +CO3NI;,,  N 15LIU !
 PARAMETER L(L12_FCC,CO,NI:CO:VA;0) 298.15
     -1.5*CONI3+1.5*CO2NI2+1.5*CO3NI;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,NI:NI:VA;0) 298.15
     +1.5*CONI3+1.5*CO2NI2-1.5*CO3NI;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,NI:CO:VA;1) 298.15
     +0.5*CONI3-1.5*CO2NI2+1.5*CO3NI;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,NI:NI:VA;1) 298.15
     -1.5*CONI3+1.5*CO2NI2-0.5*CO3NI;,,N 15LIU !
 PARAMETER L(L12_FCC,*:CO,NI:VA;0) 298.15 +L04CONI;,,N 15LIU !
 PARAMETER L(L12_FCC,*:CO,NI:VA;1) 298.15 +L14CONI;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,NI:*:VA;0) 298.15 +3*L04CONI;,,N 15LIU !
 PARAMETER L(L12_FCC,CO,NI:*:VA;1) 298.15 +3*L14CONI;,,N 15LIU !
$
$----------------------------------------------------------------------------
$
$                                                                       Cr-Ni
$                             Mainly from SSOL
$                             Metastable B2 and L12 from revision of Al-Cr-Ni
$
$                                                                LIQUID PHASE
$
 PARAMETER L(LIQUID,CR,NI;0)  298.15  +318-7.3318*T;,,N 91LEE !
 PARAMETER L(LIQUID,CR,NI;1)  298.15  +16941-6.3696*T;,,N 91LEE !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,CR,NI:VA;0)  298.15  +8030-12.8801*T;,,N 91LEE !
 PARAMETER G(FCC_A1,CR,NI:VA;1)  298.15  +33080-16.0362*T;,,N 91LEE !
 PARAMETER TC(FCC_A1,CR,NI:VA;0)  298.15  -3605;,,N 86DIN !
 PARAMETER BMAGN(FCC_A1,CR,NI:VA;0)  298.15  -1.91;,,N 86DIN !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,CR,NI:VA;0)  298.15  +17170-11.8199*T;,,N 91LEE !
 PARAMETER G(BCC_A2,CR,NI:VA;1)  298.15  +34418-11.8577*T;,,N 91LEE !
 PARAMETER TC(BCC_A2,CR,NI:VA;0)  298.15  2373;,,N 86DIN !
 PARAMETER TC(BCC_A2,CR,NI:VA;1)  298.15  617;,,N 86DIN !
 PARAMETER BMAGN(BCC_A2,CR,NI:VA;0)  298.15  4;,,N 86DIN !
$
$                                                                BCC_B2 PHASE
$                                                                  metastable
$
$ Present work: july 1999, study of Al-Cr-Ni, revision of NDTH.
 PARAMETER G(BCC_B2,CR:NI:VA;0)  298.15  4000;,,N 01DUP !
 PARAMETER G(BCC_B2,NI:CR:VA;0)  298.15  4000;,,N 01DUP !
$
$                                                               L12_FCC PHASE
$                                                                  metastable
$ Present work: july 1999, study of Al-Cr-Ni, revision of NDTH.
$ The L12 phase is metastable in the binary Cr-Ni while it was stable in NDTH.
     FUN U1CRNI 298.15 -1980;,,,N 01DUP !
$     FUN U1CRNI 298.15 -7060+3.63*T;,,,N 01DUP !
     FUN U3CRNI 298.15 0;,,,N 01DUP !
     FUN U4CRNI 298.15 0;,,,N 01DUP !
   FUNCTION L04CRNI 298.15 U3CRNI;,,N 01DUP !
   FUNCTION L14CRNI 298.15 U4CRNI;,,N 01DUP !
   FUNCTION CRNI3   298.15 +3*U1CRNI;,,,N 01DUP !
   FUNCTION CR2NI2  298.15 +4*U1CRNI;,,,N 01DUP !
   FUNCTION CR3NI   298.15 +3*U1CRNI;,,,N 01DUP !
 PARAMETER G(L12_FCC,NI:CR:VA;0)  298.15  +CRNI3;,,  N 01DUP !
 PARAMETER G(L12_FCC,CR:NI:VA;0)  298.15  +CR3NI;,,  N 01DUP !
 PARAMETER L(L12_FCC,CR,NI:CR:VA;0) 298.15
     -1.5*CRNI3+1.5*CR2NI2+1.5*CR3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,CR,NI:NI:VA;0) 298.15
     +1.5*CRNI3+1.5*CR2NI2-1.5*CR3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,CR,NI:CR:VA;1) 298.15
     +0.5*CRNI3-1.5*CR2NI2+1.5*CR3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,CR,NI:NI:VA;1) 298.15
     -1.5*CRNI3+1.5*CR2NI2-0.5*CR3NI;,,N 01DUP !
 PARAMETER L(L12_FCC,*:CR,NI:VA;0) 298.15 +L04CRNI;,,N 01DUP !
 PARAMETER L(L12_FCC,*:CR,NI:VA;1) 298.15 +L14CRNI;,,N 01DUP !
 PARAMETER L(L12_FCC,CR,NI:*:VA;0) 298.15 +3*L04CRNI;,,N 01DUP !
 PARAMETER L(L12_FCC,CR,NI:*:VA;1) 298.15 +3*L14CRNI;,,N 01DUP !
$
$                                                            SIGMA_SGTE PHASE
$                                                                  metastable
$ Modified by Ursula R. Kattner, NIST, Gaithersburg, MD, USA
 PARAMETER G(SIGMA_SGTE,NI:CR:CR;0)  298.15
 +221157-227*T+8*GHSERNI+18*GHSERCR+4*GHSERCR;,,N 88GUS1 !
 PARAMETER G(SIGMA_SGTE,NI:NI:CR;0)  298.15
 +175400+8*GHSERNI+18*GNIBCC+4*GHSERCR;,,N 88GUS1 !
$
$****************************************************************************
$
$                                                          TERNARY PARAMETERS
$
$----------------------------------------------------------------------------
$
$                                                                    Al-Co-Cr
$                 Mainly from the current work (2015)
$                 Co-Cr from Kusoffsky used instead of Oikawa as energies
$                 are shown to be better for sigma. Also produces a better
$                 Co-Cr-Ni extrapolation
$
$                                                                LIQUID PHASE
$
$Simple parameter to suppress liquid formation a 1573 K
 PARAMETER G(LIQUID,AL,CO,CR;0)  298.15  +30000;,,N 15LIU !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,AL,CO,CR:VA;0)  298.15  +989.5+8.277709*T;,,N 15LIU !
$
$                                                                BCC_A2 PHASE
$
$   BCC_A2 L0, L1 and L2 parameters are all used
$   just using L0 cannot reproduce accurate phase boundaries for the A2/B2
$   Al-Co and Al-Cr binaries may need severe work to reduce these
 PARAMETER G(BCC_A2,AL,CO,CR:VA;0)  298.15  -28128;,,N 15LIU !
 PARAMETER G(BCC_A2,AL,CO,CR:VA;1)  298.15  123468-61.878631*T;,,N 15LIU !
 PARAMETER G(BCC_A2,AL,CO,CR:VA;2)  298.15  -12107-32.267228*T;,,N 15LIU !
$
$                                                                BCC_B2 PHASE
$
 FUNCTION BCOCRMAL   298.15  -22138;,,N 15LIU !
 FUNCTION BALCOMCR   298.15  -61790;,,N 15LIU !

 PARAMETER G(BCC_B2,AL:CO,CR:VA;0)  298.15  +.5*BCOCRMAL;,,N 15LIU !
 PARAMETER G(BCC_B2,CO,CR:AL:VA;0)  298.15  +.5*BCOCRMAL;,,N 15LIU !

 PARAMETER G(BCC_B2,AL,CO:CR:VA;0)  298.15  +.5*BALCOMCR;,,N 15LIU !
 PARAMETER G(BCC_B2,CR:AL,CO:VA;0)  298.15  +.5*BALCOMCR;,,N 15LIU !
$
$                                                               L12_FCC PHASE
$                                                                  metastable
$ Present work: 2015 CRALDAD
$ Using the same interaction constraints shown by Dupin for Al-Cr-Ni
   FUN U1ALCOCR 298.15 0;,,N 15LIU !
   FUN U2ALCOCR 298.15 0;,,N 15LIU !
   FUN U3ALCOCR 298.15 0;,,N 15LIU !
   FUN ALCOCR2 298.15 U1ALCO+2*U1ALCR+2*U1COCR+U1ALCOCR;,,N 15LIU !
   FUN ALCO2CR 298.15 2*U1ALCO+U1ALCR+2*U1COCR+U2ALCOCR;,,N 15LIU !
   FUN AL2COCR 298.15 2*U1ALCO+2*U1ALCR+U1COCR+U3ALCOCR;,,N 15LIU !
 PARA L(L12_FCC,AL,CO,CR:AL:VA;0) 298.15
     -1.5*ALCOCR2-1.5*ALCO2CR+ALCO3+ALCR3+6*AL2COCR
     -1.5*AL2CO2-1.5*AL2CR2-1.5*AL3CO-1.5*AL3CR;,,N 15LIU !
 PARA L(L12_FCC,AL,CO,CR:CO:VA;0) 298.15
     -1.5*ALCOCR2+6*ALCO2CR-1.5*ALCO3-1.5*AL2COCR
     -1.5*AL2CO2+AL3CO+COCR3-1.5*CO2CR2-1.5*CO3CR;,,N 15LIU !
 PARA L(L12_FCC,AL,CO,CR:CR:VA;0) 298.15
     +6*ALCOCR2-1.5*ALCO2CR-1.5*ALCR3-1.5*AL2COCR
     -1.5*AL2CR2+AL3CR-1.5*COCR3-1.5*CO2CR2+CO3CR;,,N 15LIU !
 PARA L(L12_FCC,AL,CO:CR:VA;0) 298.15
     +1.5*ALCO2CR+1.5*AL2COCR-1.5*AL3CR-1.5*CO3CR;,,N 15LIU !
 PARA L(L12_FCC,AL,CR:CO:VA;0) 298.15
     +1.5*ALCOCR2+1.5*AL2COCR-1.5*AL3CO-1.5*COCR3;,,N 15LIU !
 PARA L(L12_FCC,CO,CR:AL:VA;0) 298.15
     +1.5*ALCOCR2+1.5*ALCO2CR-1.5*ALCO3-1.5*ALCR3;,,N 15LIU !
 PARA L(L12_FCC,AL,CO:CR:VA;1) 298.15
     -1.5*ALCO2CR+1.5*AL2COCR-0.5*AL3CR+0.5*CO3CR;,,N 15LIU !
 PARA L(L12_FCC,AL,CR:CO:VA;1) 298.15
     -1.5*ALCOCR2+1.5*AL2COCR-0.5*AL3CO+0.5*COCR3;,,N 15LIU !
 PARA L(L12_FCC,CO,CR:AL:VA;1) 298.15
     -1.5*ALCOCR2+1.5*ALCO2CR-0.5*ALCO3+0.5*ALCR3;,,N 15LIU !
$
$                                                            SIGMA_SGTE PHASE
$
 PARAMETER G(SIGMA_SGTE,CO:AL:CR;0)  298.15
 -931862+8*GCOFCC+18*GALBCC+4*GHSERCR;,,N 15LIU !
 PARAMETER G(SIGMA_SGTE,AL:CO:CR;0)  298.15
 -617537+8*GHSERAL+18*GCOBCC+4*GHSERCR;,,N 15LIU !
 PARAMETER G(SIGMA_SGTE,CO:AL,CR:CR;0)  298.15  -200000;,,N 15LIU !
$
$----------------------------------------------------------------------------
$
$                                                                    Al-Co-Ni
$                 Mainly from the current work (2015)
$                 Update of Al-Co-Ni from NDTH by Dupin
$
$
$
$                                                                LIQUID PHASE
$
 PARAMETER G(LIQUID,AL,CO,NI;0)  298.15  20000;,,N 15LIU !
$
$                                                                FCC_A1 PHASE
$
$$$$$ NONE
$
$                                                                BCC_A2 PHASE
$                                                                  metastable
$
 PARAMETER G(BCC_A2,AL,CO,NI:VA;0)  298.15  -15483;,,N 15LIU !
$
$                                                                BCC_B2 PHASE
$
 FUNCTION BALCOMNI   298.15  -43538;,,N 15LIU !

 PARAMETER G(BCC_B2,NI:AL,CO:VA;0)  298.15  +.5*BALCOMNI;,,N 15LIU !
 PARAMETER G(BCC_B2,AL,CO:NI:VA;0)  298.15  +.5*BALCOMNI;,,N 15LIU !
$
$                                                               L12_FCC PHASE
$ Present work: 2015 CRALDAD
$ Using the same interaction constraints shown by Dupin for Al-Cr-Ni
   FUN U1ALCONI 298.15 0;,,N 15LIU !
   FUN U2ALCONI 298.15 0;,,N 15LIU !
   FUN U3ALCONI 298.15 0;,,N 15LIU !
   FUN ALCONI2 298.15 U1ALCO+2*U1ALNI+2*U1CONI+U1ALCONI;,,N 15LIU !
   FUN ALCO2NI 298.15 2*U1ALCO+U1ALNI+2*U1CONI+U2ALCONI;,,N 15LIU !
   FUN AL2CONI 298.15 2*U1ALCO+2*U1ALNI+U1CONI+U3ALCONI;,,N 15LIU !
 PARA L(L12_FCC,AL,CO,NI:AL:VA;0) 298.15
     -1.5*ALCONI2-1.5*ALCO2NI+ALCO3+ALNI3+6*AL2CONI
     -1.5*AL2CO2-1.5*AL2NI2-1.5*AL3CO-1.5*AL3NI;,,N 15LIU !
 PARA L(L12_FCC,AL,CO,NI:CO:VA;0) 298.15
     -1.5*ALCONI2+6*ALCO2NI-1.5*ALCO3-1.5*AL2CONI
     -1.5*AL2CO2+AL3CO+CONI3-1.5*CO2NI2-1.5*CO3NI;,,N 15LIU !
 PARA L(L12_FCC,AL,CO,NI:NI:VA;0) 298.15
     +6*ALCONI2-1.5*ALCO2NI-1.5*ALNI3-1.5*AL2CONI
     -1.5*AL2NI2+AL3NI-1.5*CONI3-1.5*CO2NI2+CO3NI;,,N 15LIU !
 PARA L(L12_FCC,AL,CO:NI:VA;0) 298.15
     +1.5*ALCO2NI+1.5*AL2CONI-1.5*AL3NI-1.5*CO3NI;,,N 15LIU !
 PARA L(L12_FCC,AL,NI:CO:VA;0) 298.15
     +1.5*ALCONI2+1.5*AL2CONI-1.5*AL3CO-1.5*CONI3;,,N 15LIU !
 PARA L(L12_FCC,CO,NI:AL:VA;0) 298.15
     +1.5*ALCONI2+1.5*ALCO2NI-1.5*ALCO3-1.5*ALNI3;,,N 15LIU !
 PARA L(L12_FCC,AL,CO:NI:VA;1) 298.15
     -1.5*ALCO2NI+1.5*AL2CONI-0.5*AL3NI+0.5*CO3NI;,,N 15LIU !
 PARA L(L12_FCC,AL,NI:CO:VA;1) 298.15
     -1.5*ALCONI2+1.5*AL2CONI-0.5*AL3CO+0.5*CONI3;,,N 15LIU !
 PARA L(L12_FCC,CO,NI:AL:VA;1) 298.15
     -1.5*ALCONI2+1.5*ALCO2NI-0.5*ALCO3+0.5*ALNI3;,,N 15LIU !
$
$----------------------------------------------------------------------------
$
$                                                                    Al-Cr-Ni
$                                    July 1999, ND
$                                    Revision. Main changes:
$                                    - description of the A2/B2
$                                    - new liquidus data taken into account
$                                    - simpler ternary interaction parameters
$
$                                                                LIQUID PHASE
$
 PARAMETER L(LIQUID,AL,CR,NI;0)  298.15  16000;,,N 01DUP !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,AL,CR,NI:VA;0)  298.15  30300;,,N 01DUP !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,AL,CR,NI:VA;0)  298.15  42500;,,N 01DUP !
$
$                                                               L12_FCC PHASE
$
   FUN U1ALCRNI 298.15 6650;,,N 01DUP !
   FUN U2ALCRNI 298.15 0;,,N 01DUP !
   FUN U3ALCRNI 298.15 0;,,N 01DUP !
   FUN ALCRNI2 298.15 U1ALCR+2*U1ALNI+2*U1CRNI+U1ALCRNI;,,N 01DUP !
   FUN ALCR2NI 298.15 2*U1ALCR+U1ALNI+2*U1CRNI+U2ALCRNI;,,N 01DUP !
   FUN AL2CRNI 298.15 2*U1ALCR+2*U1ALNI+U1CRNI+U3ALCRNI;,,N 01DUP !
 PARA L(L12_FCC,AL,CR,NI:AL:VA;0) 298.15
     -1.5*ALCRNI2-1.5*ALCR2NI+ALCR3+ALNI3+6*AL2CRNI
     -1.5*AL2CR2-1.5*AL2NI2-1.5*AL3CR-1.5*AL3NI;,,N 01DUP !
 PARA L(L12_FCC,AL,CR,NI:CR:VA;0) 298.15
     -1.5*ALCRNI2+6*ALCR2NI-1.5*ALCR3-1.5*AL2CRNI
     -1.5*AL2CR2+AL3CR+CRNI3-1.5*CR2NI2-1.5*CR3NI;,,N 01DUP !
 PARA L(L12_FCC,AL,CR,NI:NI:VA;0) 298.15
     +6*ALCRNI2-1.5*ALCR2NI-1.5*ALNI3-1.5*AL2CRNI
     -1.5*AL2NI2+AL3NI-1.5*CRNI3-1.5*CR2NI2+CR3NI;,,N 01DUP !
 PARA L(L12_FCC,AL,CR:NI:VA;0) 298.15
     +1.5*ALCR2NI+1.5*AL2CRNI-1.5*AL3NI-1.5*CR3NI;,,N 01DUP !
 PARA L(L12_FCC,AL,NI:CR:VA;0) 298.15
     +1.5*ALCRNI2+1.5*AL2CRNI-1.5*AL3CR-1.5*CRNI3;,,N 01DUP !
 PARA L(L12_FCC,CR,NI:AL:VA;0) 298.15
     +1.5*ALCRNI2+1.5*ALCR2NI-1.5*ALCR3-1.5*ALNI3;,,N 01DUP !
 PARA L(L12_FCC,AL,CR:NI:VA;1) 298.15
     -1.5*ALCR2NI+1.5*AL2CRNI-0.5*AL3NI+0.5*CR3NI;,,N 01DUP !
 PARA L(L12_FCC,AL,NI:CR:VA;1) 298.15
     -1.5*ALCRNI2+1.5*AL2CRNI-0.5*AL3CR+0.5*CRNI3;,,N 01DUP !
 PARA L(L12_FCC,CR,NI:AL:VA;1) 298.15
     -1.5*ALCRNI2+1.5*ALCR2NI-0.5*ALCR3+0.5*ALNI3;,,N 01DUP !
$
$                                                            SIGMA_SGTE PHASE
$                                                                  metastable
 PARAMETER G(SIGMA_SGTE,AL:NI:CR;0)  298.15
 -1045169+8*GHSERAL+18*GNIBCC+4*GHSERCR;,,N 15LIU !
 PARAMETER G(SIGMA_SGTE,NI:AL:CR;0)  298.15
 -1169367+8*GHSERNI+18*GALBCC+4*GHSERCR;,,N 15LIU !
$
$----------------------------------------------------------------------------
$
$                                                                    Co-Cr-Ni
$                 Mainly from the current work (2015)
$                 Extrapolations from binaries are slightly improved
$
$
$
$
$                                                                LIQUID PHASE
$
 PARAMETER G(LIQUID,CO,CR,NI;0)  298.15  -16000;,,N 15LIU !
$
$                                                                FCC_A1 PHASE
$
 PARAMETER G(FCC_A1,CO,CR,NI:VA;0)  298.15  -40710+13.5334*T;,,N 15LIU !
$
$                                                                BCC_A2 PHASE
$
 PARAMETER G(BCC_A2,CO,CR,NI:VA;0)  298.15  -60134+17.699513*T;,,N 15LIU !
$
$
$                                                               L12_FCC PHASE
$                                                                  metastable
$ Present work: 2015 CRALDAD
$ Using the same interaction constraints shown by Dupin for Al-Cr-Ni
   FUN U1COCRNI 298.15 0;,,N 15LIU !
   FUN U2COCRNI 298.15 0;,,N 15LIU !
   FUN U3COCRNI 298.15 0;,,N 15LIU !
   FUN COCRNI2 298.15 U1COCR+2*U1CONI+2*U1CRNI+U1COCRNI;,,N 15LIU !
   FUN COCR2NI 298.15 2*U1COCR+U1CONI+2*U1CRNI+U2COCRNI;,,N 15LIU !
   FUN CO2CRNI 298.15 2*U1COCR+2*U1CONI+U1CRNI+U3COCRNI;,,N 15LIU !
 PARA L(L12_FCC,CO,CR,NI:CO:VA;0) 298.15
     -1.5*COCRNI2-1.5*COCR2NI+COCR3+CONI3+6*CO2CRNI
     -1.5*CO2CR2-1.5*CO2NI2-1.5*CO3CR-1.5*CO3NI;,,N 15LIU !
 PARA L(L12_FCC,CO,CR,NI:CR:VA;0) 298.15
     -1.5*COCRNI2+6*COCR2NI-1.5*COCR3-1.5*CO2CRNI
     -1.5*CO2CR2+CO3CR+CRNI3-1.5*CR2NI2-1.5*CR3NI;,,N 15LIU !
 PARA L(L12_FCC,CO,CR,NI:NI:VA;0) 298.15
     +6*COCRNI2-1.5*COCR2NI-1.5*CONI3-1.5*CO2CRNI
     -1.5*CO2NI2+CO3NI-1.5*CRNI3-1.5*CR2NI2+CR3NI;,,N 15LIU !
 PARA L(L12_FCC,CO,CR:NI:VA;0) 298.15
     +1.5*COCR2NI+1.5*CO2CRNI-1.5*CO3NI-1.5*CR3NI;,,N 15LIU !
 PARA L(L12_FCC,CO,NI:CR:VA;0) 298.15
     +1.5*COCRNI2+1.5*CO2CRNI-1.5*CO3CR-1.5*CRNI3;,,N 15LIU !
 PARA L(L12_FCC,CR,NI:CO:VA;0) 298.15
     +1.5*COCRNI2+1.5*COCR2NI-1.5*COCR3-1.5*CONI3;,,N 15LIU !
 PARA L(L12_FCC,CO,CR:NI:VA;1) 298.15
     -1.5*COCR2NI+1.5*CO2CRNI-0.5*CO3NI+0.5*CR3NI;,,N 15LIU !
 PARA L(L12_FCC,CO,NI:CR:VA;1) 298.15
     -1.5*COCRNI2+1.5*CO2CRNI-0.5*CO3CR+0.5*CRNI3;,,N 15LIU !
 PARA L(L12_FCC,CR,NI:CO:VA;1) 298.15
     -1.5*COCRNI2+1.5*COCR2NI-0.5*COCR3+0.5*CONI3;,,N 15LIU !
$
$                                                            SIGMA_SGTE PHASE
$ Phase boundaries well reproduced without the need of ternary end-members
$ excess energies
 PARAMETER G(SIGMA_SGTE,NI:CO:CR;0)  298.15
 +8*GHSERNI+18*GCOBCC+4*GHSERCR;,,N 15LIU !
 PARAMETER G(SIGMA_SGTE,CO:NI:CR;0)  298.15
 +8*GCOFCC+18*GNIBCC+4*GHSERCR;,,N 15LIU !
$
$----------------------------------------------------------------------------
$----------------------------------------------------------------------------
$----------------------------------------------------------------------------
$----------------------------------------------------------------------------
$
$                                                                 Al-Co-Cr-Ni
$                 Mainly from the current work (2015)
$                 Extrapolations from ternaries only
$
$
$                                                                LIQUID PHASE
$
$$$$$ NONE
$
$                                                                FCC_A1 PHASE
$
$$$$$ NONE
$
$                                                                BCC_A2 PHASE
$
$$$$$ NONE
$
$                                                                BCC_B2 PHASE
$
$$$$$ NONE
$
$                                                               L12_FCC PHASE
$
$ Using the same interaction constraints shown by Dupin in NDTH
 FUNCTION ALCOCRNI   298.15 0.0;,,N 15LIU !

 PARAMETER G(L12_FCC,AL,CO,CR:NI:VA;0)  298.15  +AL3NI+CO3NI+CR3NI
 -1.5*ALCO2NI-1.5*ALCR2NI-1.5*AL2CONI-1.5*AL2CRNI-1.5*COCR2NI
 -1.5*CO2CRNI+6*ALCOCRNI;,,N 15LIU !

 PARAMETER G(L12_FCC,AL,CO,NI:CR:VA;0)  298.15  +AL3CR+CO3CR+CRNI3
 -1.5*ALCO2CR-1.5*ALCRNI2-1.5*AL2COCR-1.5*AL2CRNI-1.5*COCRNI2
 -1.5*CO2CRNI+6*ALCOCRNI;,,N 15LIU !

 PARAMETER G(L12_FCC,AL,CR,NI:CO:VA;0)  298.15  +AL3CO+COCR3+CONI3
 -1.5*ALCOCR2-1.5*ALCONI2-1.5*AL2COCR-1.5*AL2CONI-1.5*COCRNI2
 -1.5*COCR2NI+6*ALCOCRNI;,,N 15LIU ! !

 PARAMETER G(L12_FCC,CO,CR,NI:AL:VA;0)  298.15  +ALCO3+ALCR3+ALNI3
 -1.5*ALCOCR2-1.5*ALCONI2-1.5*ALCO2CR-1.5*ALCO2NI-1.5*ALCRNI2
 -1.5*ALCR2NI+6*ALCOCRNI;,,N 15LIU !
$
$****************************************************************************

 LIST_OF_REFERENCES
 NUMBER  SOURCE
  86DIN     'A. Dinsdale, T. Chart, MTDS NPL, Unpublished work (1986); CR-NI'
  89DIN     'Alan Dinsdale, SGTE Data for Pure Elements,
          NPL Report DMA(A)195 September 1989'
  91DIN     'Alan Dinsdale, SGTE Data for Pure Elements, NPL Report
          DMA(A)195 Rev. August 1990'
  91LEE     'Byeong-Joo Lee, unpublished revision (1991); C-Cr-Fe-Ni'
  91SAU1    'Nigel Saunders, 1991, based on
            N. Saunders, V.G. Rivlin
            Z. metallkde, 78 (11), 795-801 (1987); Al-Cr'
  91DIN     'Alan Dinsdale, SGTE Data for Pure Elements,
          Calphad Vol 15(1991) p 317-425,
          also in NPL Report DMA(A)195 Rev. August 1990'
  95DUP3     'N. Dupin, Thesis, LTPCM, France, 1995;
          Al-Ni,
          also in I. Ansara, N. Dupin, H.L. Lukas, B. SUndman
          J. Alloys Compds, 247 (1-2), 20-30 (1997)'
  99DUP      'N. Dupin, I. Ansara,
          Z. metallkd., Vol 90 (1999) p 76-85;
          Al-Ni'
  01DUP    'N. Dupin, I. Ansara, B. Sundman
          Thermodynamic Re-Assessment of the Ternary System Al-Cr-Ni,
          Calphad, 25 (2), 279-298 (2001); Al-Cr-Ni'
   REF184   'AL1<G> CODATA KEY VALUES SGTE **
          ALUMINIUM <GAS>
          Cp values similar in Codata Key Values and IVTAN Vol. 3'
   REF448   'AL2<G> CHATILLON(1992)
         Enthalpy of formation for Al1<g> taken from Codata Key Values.
         Enthalpy of form. from TPIS dissociation energy mean Value
         corrected with new fef from Sunil K.K. and Jordan K.D.
         (J.Phys. Chem. 92(1988)2774) ab initio calculations.'
   REF4469 'CO1<G> T.C.R.A.S Class: 1
         Data provided by TCRAS. October 1996. Error in version 1997.
         S298 corrected to 1bar.'
   REF4561 'CO2<G> T.C.R.A.S Class: 6
         Data provided by T.C.R.A.S. October 1996.'
   REF4465  'CR1<G> T.C.R.A.S. Class: 1
         CHROMIUM <GAS>'
   REF4591  'CR2<G> T.C.R.A.S. Class: 6'
   REF7504  'NI1<G> T.C.R.A.S Class: 1
         Data provided by T.C.R.A.S. October 1996'
   REF7553  'NI2<G> T.C.R.A.S Class: 5
         Data provided by T.C.R.A.S. October 1996'
   90DIN    90Din 'Alan Dinsdale, SGTE Data for Pure Elements, NPL Report
          DMA(A)195, Rev. August 1990'
   REF78   DUP-ALNI 'Nathalie Dupin, J Alloy and Compounds, (1997); Al-Ni'
   87GU3   87Gui3 'A. Fernandez Guillermet, Z Metallkde, Vol 78 (1987)
          p 639-647
          TRITA-MAC 324B (1986); CO-NI'

   87GU4    87Gui4 'A. Fernandez Guillermet, Int. J of Thermophys vol 8
         (1987)
          p 481-510, TRITA-MAC 308 (1986); CO'
   90DIN1   89Din 'Alan Dinsdale, SGTE Data for Pure Elements, NPL Report
          DMA(A)195, September 1989'
   88GUI   88Gui2 'A. Fernandez Guillermet, Z. Metallkde. Vol 79(1988)
          p.524-536,
          TRITA-MAC 362 (1988); C-CO-NI AND C-CO-FE-NI'
   93SAU   NIG-ALCU 'Nigel Saunders, COST 507 round 1, (1993); Al-Cu'
   91SAU   NIG-ALTI 'Nigel Saunders, COST 507 round 1, (1991); Al-Ti'

   88GUS1    'P. Gustafson, CALPHAD 12 (1988) 277-292; Cr-W, Cr-Ni-W,
          Modified by Ursula R. Kattner, NIST, Gaithersburg, MD, USA '

   98DUP    'N. Dupin, I. Ansara,
          Thermodynamic Assessment of the System Al-Co,
          Revue de Metallurgie, 95(9), 1121-1129 (1998); Al-Co'
   97KUS    'A. Kusoffsky, B. Jansson,
          A Thermodynamic Evaluation of the Co-Cr and the C-Co-Cr Systems,
          Calphad, 21(3), 321-333 (1997); Co-Cr'

   15LIU    'Xuan L. Liu, Thomas Gheno, Bonnie Lindahl,
          Greta Lindwall, Brian Gleeson, Zi-Kui Liu,
          First-principles calculations, experimental study,
          and thermodynamic modeling of the Al-Co-Cr-Ni system
          (2015); X.L. Liu Ph.D. Thesis'

  !
"""

ISSUE43_TDB = """
$ Database file written 2016- 5-19
$ From database: TTNI5
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5400E+03  2.8300E+01!
 ELEMENT CR   BCC_A2                    5.1996E+01  4.0500E+03  2.3543E+01!
 ELEMENT NI   FCC_A1                    5.8690E+01  4.7870E+03  2.9796E+01!


 FUNCTION GHSERAL   298.14 -7976.15+137.093038*T-24.3671976*T*LN(T)
     -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1); 700 Y
      -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
     -5.764227E-06*T**3+74092*T**(-1); 933.47 Y
      -11278.378+188.684153*T-31.748192*T*LN(T)-1.231E+28*T**(-9); 2900 N !
 FUNCTION ZERO      298.15 +0.0; 6000 N !
 FUNCTION GFCCCR    298.15 +7284+.163*T+GHSERCR#; 6000 N !
 FUNCTION GHSERNI   298.14 -5179.159+117.854*T-22.096*T*LN(T)-.0048407*T**2;
     1728 Y
      -27840.655+279.135*T-43.1*T*LN(T)+1.12754E+31*T**(-9); 3000 N !
 FUNCTION GHSERCR   298.14 -8856.94+157.48*T-26.908*T*LN(T)+.00189435*T**2
     -1.47721E-06*T**3+139250*T**(-1); 2180 Y
      -34869.344+344.18*T-50*T*LN(T)-2.88526E+32*T**(-9); 6000 N !
 FUNCTION UN_ASS 298.15 +0; 300 N !

 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA /- !


 TYPE_DEFINITION & GES A_P_D FCC_A1 MAGNETIC  -3.0    2.80000E-01 !
 PHASE FCC_A1  %&  2 1 1!
    CONSTITUENT FCC_A1  :AL,CR,NI% :VA: !

   PARAMETER G(FCC_A1,AL:VA;0)            298.15 +GHSERAL#; 6000 N REF0 !
   PARAMETER TC(FCC_A1,AL:VA;0)           298.15 +ZERO#; 6000 N REF0 !
   PARAMETER BMAGN(FCC_A1,AL:VA;0)        298.15 +ZERO#; 6000 N REF0 !
   PARAMETER G(FCC_A1,CR:VA;0)            298.15 +GFCCCR#; 6000 N REF0 !
   PARAMETER TC(FCC_A1,CR:VA;0)           298.15 -1109; 6000 N REF0 !
   PARAMETER BMAGN(FCC_A1,CR:VA;0)        298.15 -2.46; 6000 N REF0 !
   PARAMETER G(FCC_A1,NI:VA;0)            298.15 +GHSERNI#; 6000 N REF0 !
   PARAMETER TC(FCC_A1,NI:VA;0)           298.15 +633; 6000 N REF0 !
   PARAMETER BMAGN(FCC_A1,NI:VA;0)        298.15 +.52; 6000 N REF0 !
   PARAMETER G(FCC_A1,AL,CR:VA;0)         298.15 -45900+6*T; 6000 N REF0 !
   PARAMETER G(FCC_A1,AL,CR,NI:VA;0)      298.15 +30500-5*T; 6000 N REF0 !
   PARAMETER G(FCC_A1,AL,NI:VA;0)         298.15 -173950+19.35*T; 6000 N
  REF0 !
   PARAMETER G(FCC_A1,AL,NI:VA;1)         298.15 +28500; 6000 N REF0 !
   PARAMETER G(FCC_A1,AL,NI:VA;2)         298.15 +47000; 6000 N REF0 !
   PARAMETER G(FCC_A1,CR,NI:VA;0)         298.15 +8030-12.8801*T; 6000 N
  REF0 !
   PARAMETER G(FCC_A1,CR,NI:VA;1)         298.15 +33080-16.0362*T; 6000 N
  REF0 !
   PARAMETER TC(FCC_A1,CR,NI:VA;0)        298.15 -3605; 6000 N REF0 !
   PARAMETER BMAGN(FCC_A1,CR,NI:VA;0)     298.15 -1.91; 6000 N REF0 !


 TYPE_DEFINITION ' GES A_P_D GAMMA_PRIME MAGNETIC  -3.0    2.80000E-01 !
 PHASE GAMMA_PRIME  %'  2 .75   .25 !
    CONSTITUENT GAMMA_PRIME  :AL,CR,NI% : AL%,CR,NI :  !

   PARAMETER G(GAMMA_PRIME,AL:AL;0)       298.15 +GHSERAL#; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,CR:AL;0)       298.15 -8606+1.125*T+.75*GFCCCR#
  +.25*GHSERAL#; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,NI:AL;0)       298.15 -39860+3.175*T+.75*GHSERNI#
  +.25*GHSERAL#; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL:CR;0)       298.15 -8606+1.125*T+.75*GHSERAL#
  +.25*GFCCCR#; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,CR:CR;0)       298.15 +GFCCCR#; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,NI:CR;0)       298.15 -1915-.91*T+.75*GHSERNI#
  +.25*GFCCCR#; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL:NI;0)       298.15 -35000+5*T+.75*GHSERAL#
  +.25*GHSERNI#; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,CR:NI;0)       298.15 +10000-3.92*T+.75*GFCCCR#
  +.25*GHSERNI#; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,NI:NI;0)       298.15 +GHSERNI#; 6000 N REF0 !
   PARAMETER TC(GAMMA_PRIME,NI:NI;0)      298.15 +633; 6000 N REF0 !
   PARAMETER BMAGN(GAMMA_PRIME,NI:NI;0)   298.15 +.52; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL,NI:AL;0)    298.15 -59500+20*T; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL,NI:AL;1)    298.15 +53350; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL:AL,NI;0)    298.15 +10000; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL:AL,CR;0)    298.15 -2869+.375*T; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,CR:AL,NI;0)    298.15 +10000; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,CR:AL,CR;0)    298.15 -2869+.375*T; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,NI:AL,NI;0)    298.15 +9100-1.5*T; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,NI:AL,NI;1)    298.15 -5400; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,NI:AL,CR;0)    298.15 -6250+T; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL,NI:CR;0)    298.15 -60000+20*T; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL,NI:NI;0)    298.15 -50000; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,AL,CR:*;0)     298.15 -25819+3.375*T; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,*:CR,NI;0)     298.15 +3000; 6000 N REF0 !
   PARAMETER G(GAMMA_PRIME,CR,NI:*;0)     298.15 -1500; 6000 N REF0 !

 LIST_OF_REFERENCES
 NUMBER  SOURCE
  !
"""

FEMN_TDB = """
$ FOR TESTING PURPOSES ONLY -- NOT FOR RESEARCH
$ NO INTERACTION PARAMETERS
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT FE   BCC_A2                    5.5847E+01  4.4890E+03  2.7280E+01!
 ELEMENT MN   CBCC_A12                  5.4938E+01  4.9960E+03  3.2008E+01!

 FUNCTION TEMP      0.99 +T**(-1); 6000 N !
 FUNCTION RTEMP     0.99 +R#**(-1)*TEMP#; 6000 N !
 FUNCTION ZERO      0.99 +0.0; 6000 N !
 FUNCTION INTR      0.99 +1000; 6000 N !
 FUNCTION INFINITE  0.99 +1000000; 6000 N !
 FUNCTION G2STFCC1  0.99 +9023.52375-2.4952226*T; 6000 N !
 FUNCTION G2STFCC2  0.99 -G2STFCC1#*RTEMP#; 6000 N !
 FUNCTION G2STFCC3  0.99 +1+1*EXP(G2STFCC2#); 6000 N !
 FUNCTION G2STFCC4  0.99 +1*LN(G2STFCC3#); 6000 N !
 FUNCTION G2STFCC   0.99 -R#*T*G2STFCC4#; 6000 N !
 FUNCTION GGBCCL    0.99 -8410.26596-.0032390815*T**2-3.3191338E-14*T**5;
     6000 N !
 FUNCTION GGBCCH    0.99 -33208.4173+165.40504*T-21.0474823*T*LN(T)
     -2.781828E+18*T**(-5)+4.2811788E+37*T**(-11); 6000 N !
 FUNCTION GEIN309   0.99 +0.0; 6000 N !
 FUNCTION GGFCCL    0.99 -2615.00904-.0027933375*T**2-2.1239087E-14*T**5
     +G2STFCC#; 6000 N !
 FUNCTION GGFCCH    0.99 -32389.5438+168.31394*T-20.9834791*T*LN(T)
     +9.2444598E+18*T**(-5)-1.4750509E+37*T**(-11)+G2STFCC#; 6000 N !
 FUNCTION GHSERFE   0.99 +GGBCCL#+8927.2831-9.7228331*T; 1811 Y
      +GGBCCH#+8927.2831-9.7228331*T; 6000 N !
 FUNCTION GGHCPL    0.99 -3307.07993-.00431797569*T**2-2.1239086E-14*T**5;
     6000 N !
 FUNCTION GGHCPH    0.99 -24924.6659+161.764208*T-21.0325858*T*LN(T)
     -4.71013343E+18*T**(-5); 6000 N !
 FUNCTION TECBCCMN  0.99 +287.60608; 6000 N !
 FUNCTION TECUBMN   0.99 +247.87895; 6000 N !
 FUNCTION TEFCCMN   0.99 +257.58049; 6000 N !
 FUNCTION TEBCCMN   0.99 +265.03333; 6000 N !
 FUNCTION TELIQMN   0.99 +119.579259; 6000 N !
 FUNCTION TEHCPMN   0.99 +438.579784; 6000 N !
 FUNCTION BETA1     0.99 +1.22; 6000 N !
 FUNCTION BETA2     0.99 +1.62; 6000 N !
 FUNCTION BETA3     0.99 +1.27; 6000 N !
 FUNCTION MNCBCCB   0.99 +1*LN(BETA1#); 6000 N !
 FUNCTION MNFCCB    0.99 +1*LN(BETA2#); 6000 N !
 FUNCTION MNBCCB    0.99 +1*LN(BETA3#); 6000 N !
 FUNCTION GGMNCBCL  0.99 -8621.707-.0054695069*T**2+3.6645644E-08*T**3
     -2.588845E-14*T**5; 6000 N !
 FUNCTION GGMNCBCH  0.99 -25954.328+130.73341*T+20.178863*T
     -20.178863*T*LN(T)-7.4173873E+17*T**(-5)+3.5722E+36*T**(-11); 6000 N !
 FUNCTION GGMNCUBL  0.99 -6181.4708-.0057218755*T**2+8.9632678E-12*T**3
     -1.9360399E-14*T**5; 6000 N !
 FUNCTION GGMNCUBH  0.99 -24465.161+136.70198*T+21.095719*T
     -21.095719*T*LN(T)-3.967E+17*T**(-5)+2.9953E+36*T**(-11); 6000 N !
 FUNCTION GGMNFCCL  0.99 -5356.328-.0044627084*T**2-3.7906096E-10*T**4
     +8.1018765E-14*T**5; 6000 N !
 FUNCTION GGMNFCCH  0.99 -22440.434+135.25456*T+20.797951*T
     -20.797951*T*LN(T)-1.8964E+18*T**(-5)+5.208E+36*T**(-11); 6000 N !
 FUNCTION GGMNBCCL  0.99 -4692.6774-.006846492*T**2-3.2311349E-15*T**5;
     6000 N !
 FUNCTION GGMNBCCH  0.99 -18620.432+127.31728*T+20.301009*T
     -20.301009*T*LN(T)-2.2035E+18*T**(-5)+5.1886E+36*T**(-11); 6000 N !
 FUNCTION GGMNHCPL  0.99 -9755.88935-.00699764166*T**2+4.12888434E-15*T**5;
      6000 N !
 FUNCTION GGMNHCPH  0.99 -25379.581+133.19315*T+21.0957581*T
     -21.0957581*T*LN(T)-1.1043E+18*T**(-5)+3.3993E+36*T**(-11); 6000 N !
 FUNCTION UN_ASS    0.99 +0.0; 300 N !

 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA /- !


 TYPE_DEFINITION * GES A_P_D LIQUID MAGNETIC   0.0    0.25 !
 PHASE LIQUID  %*  2 1   1 !
    CONSTITUENT LIQUID  :FE,MN : VA :  !

   PARAMETER G(LIQUID,FE:VA;0)            0.99 +7103.20801
  -.0019730116*T**2+1392.1182-8.2584018*T; 6000 N REF0 !
   PARAMETER TC(LIQUID,FE:VA;0)           0.99 +200; 6000 N REF0 !
   PARAMETER NT(LIQUID,FE:VA;0)           0.99 -200; 6000 N REF0 !
   PARAMETER BMAGN(LIQUID,FE:VA;0)        0.99 +1.7; 6000 N REF0 !
   PARAMETER THETA(LIQUID,FE:VA;0)        0.99 +1*LN(245); 6000 N REF0 !
   PARAMETER GD(LIQUID,FE:VA;0)           0.99 +42754.9478-7.624*T
  -1.08230446*T*LN(T); 6000 N REF0 !
   PARAMETER G(LIQUID,MN:VA;0)            0.99 +13256.8283
  -.0017557494*T**2; 6000 N REF0 !
   PARAMETER THETA(LIQUID,MN:VA;0)        0.99 +1*LN(TELIQMN#); 6000 N
  REF0 !
   PARAMETER GD(LIQUID,MN:VA;0)           0.99 +50493.6966-8.314*T
  -1.07778322*T*LN(T); 6000 N REF0 !

 LIST_OF_REFERENCES
 NUMBER  SOURCE
  !

"""

ALNI_TOUGH_CHEMPOT_TDB = """
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$ Date: 2016-12-14 15:39
$ Components: AL, NI, VA
$ Phases: AL3NI1, AL3NI2, AL3NI5, BCC_B2, FCC_L12, LIQUID
$ Generated by rotis (pycalphad 0.4.2+61.g2a7ce13.dirty)
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

ELEMENT AL BLANK 0 0 0 !
ELEMENT NI BLANK 0 0 0 !
ELEMENT VA BLANK 0 0 0 !

FUNCTION GBCCAL 298.15 -4.813*T + GHSERAL# + 10083; 2900.0 N !
FUNCTION GBCCNI 298.15 -3.556*T + GHSERNI# + 8715.084; 3000.0 N !
FUNCTION GFCCAL 298.15 GHSERAL#; 2900.0 N !
FUNCTION GFCCNI 298.15 GHSERNI#; 3000.0 N !
FUNCTION GHSERAL 298.15 -8.77664E-7*T**3 - 0.001884662*T**2 -
   24.3671976*T*LN(T) + 137.093038*T - 7976.15 + 74092*T**(-1); 700.0 Y
   -5.764227E-6*T**3 + 0.018531982*T**2 - 38.5844296*T*LN(T) + 223.048446*T -
   11276.24 + 74092*T**(-1); 933.47 Y -31.748192*T*LN(T) + 188.684153*T -
   11278.378 - 1.230524E+28*T**(-9); 2900.0 N !
FUNCTION GHSERNI 298.15 -0.0048407*T**2 - 22.096*T*LN(T) + 117.854*T -
   5179.159; 1728.0 Y -43.1*T*LN(T) + 279.135*T - 27840.655 +
   1.12754E+31*T**(-9); 3000.0 N !
FUNCTION GHSERVA 1 0; 10000 N !
FUNCTION GLIQAL 298.15 7.9337E-20*T**7 - 11.841867*T + GHSERAL# + 11005.029;
   700.0 Y 7.9337E-20*T**7 - 11.841867*T + GHSERAL# + 11005.03; 933.47 Y
   -31.748192*T*LN(T) + 177.430178*T - 795.996; 2900.0 N !
FUNCTION GLIQNI 298.15 -3.82318E-21*T**7 - 9.397*T + GHSERNI# + 16414.686;
   1728.0 Y -43.1*T*LN(T) + 268.598*T - 9549.775; 3000.0 N !
FUNCTION VV0000 1 44829.5347002512; 10000 N !
FUNCTION VV0001 1 21083.3819526426; 10000 N !
FUNCTION VV0002 1 -172266.35740234; 10000 N !
FUNCTION VV0003 1 -21505.9578761833; 10000 N !
FUNCTION VV0004 1 0.354592876983304; 10000 N !
FUNCTION VV0005 1 -47332.7755500104; 10000 N !
FUNCTION VV0006 1 1.62618549502645; 10000 N !
FUNCTION VV0007 1 -41810.7541019748; 10000 N !
FUNCTION VV0008 1 -6039.53606796524; 10000 N !
FUNCTION VV0009 1 -0.000224426712081812; 10000 N !
FUNCTION VV0010 1 3.67679761555988E-7; 10000 N !
FUNCTION VV0011 1 0.98863889021688; 10000 N !
FUNCTION VV0012 1 -8.69340819947539; 10000 N !
FUNCTION VV0013 1 -2927.77707586163; 10000 N !
FUNCTION VV0014 1 -536.346451563302; 10000 N !
FUNCTION VV0015 1 5511.98810420907; 10000 N !
FUNCTION VV0016 1 31.9853544423023; 10000 N !
FUNCTION VV0017 1 2751.99998592011; 10000 N !
FUNCTION VV0018 1 3768.00000024449; 10000 N !
FUNCTION VV0019 1 2525.31616310146; 10000 N !
FUNCTION VV0020 1 3125.33; 10000 N !
FUNCTION VV0021 1 -5196.0; 10000 N !
FUNCTION VV0022 1 -2550.0483402143; 10000 N !
FUNCTION VV0023 1 1385.39243202476; 10000 N !
FUNCTION VV0024 1 5122.0; 10000 N !
FUNCTION VV0025 1 -4257289.9378801; 10000 N !
FUNCTION VV0026 1 -38986.7771525212; 10000 N !
FUNCTION VV0027 1 2.65420662533769; 10000 N !
FUNCTION VV0028 1 -56769.0171420757; 10000 N !
FUNCTION VV0029 1 3.01846325747057; 10000 N !
FUNCTION VV0030 1 -64435.3; 10000 N !
FUNCTION VV0031 1 23095.199992201; 10000 N !
FUNCTION VV0032 1 0.0010690375657278; 10000 N !
FUNCTION VV0033 1 8.82128846920494E-8; 10000 N !
FUNCTION VV0034 1 0.00053171740659028; 10000 N !
FUNCTION VV0035 1 0.696676025156; 10000 N !
FUNCTION VV0036 1 16432.5; 10000 N !
FUNCTION VV0037 1 5.15785972911005; 10000 N !
FUNCTION VV0038 1 32790.5999979329; 10000 N !
FUNCTION VV0039 1 45158.3776161547; 10000 N !
FUNCTION VV0040 1 -28577.7054781016; 10000 N !
FUNCTION VV0041 1 -30348.3852118209; 10000 N !
FUNCTION VV0042 1 -150059.187357092; 10000 N !
FUNCTION VV0043 1 41336.6; 10000 N !
FUNCTION VV0044 1 67135.0000000003; 10000 N !
FUNCTION VV0045 1 34418.7999999758; 10000 N !
FUNCTION VV0046 1 -152236.00000115; 10000 N !
FUNCTION VV0047 1 -342965.522247774; 10000 N !
FUNCTION VV0048 1 54.8086813459034; 10000 N !
FUNCTION VV0049 1 987.085683202265; 10000 N !
FUNCTION VV0050 1 77152.5226372817; 10000 N !
FUNCTION VV0051 1 5330.80281318475; 10000 N !

TYPE_DEFINITION % SEQ * !
DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
DEFAULT_COMMAND DEFINE_SYSTEM_ELEMENT VA !

PHASE AL3NI1 %  2 0.75 0.25 !
CONSTITUENT AL3NI1 :AL:NI: !

PHASE AL3NI2 %  3 2 1 2 !
CONSTITUENT AL3NI2 :AL,NI:AL,NI:NI: !

PHASE AL3NI5 %  2 0.375 0.625 !
CONSTITUENT AL3NI5 :AL:NI: !

PHASE BCC_B2 %  3 0.5 0.5 1 !
CONSTITUENT BCC_B2 :AL,NI,VA:AL,NI,VA:VA: !

PHASE FCC_L12 %  5 0.25 0.25 0.25 0.25 1 !
CONSTITUENT FCC_L12 :AL,NI:AL,NI:AL,NI:AL,NI:VA: !

PHASE LIQUID %  1 1 !
CONSTITUENT LIQUID :AL,NI: !



$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     AL                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(BCC_B2,AL:AL:VA;0) 1 1.0*GBCCAL#; 10000 N !
PARAMETER G(BCC_B2,AL:VA:VA;0) 1 T*VV0037# + 0.5*GHSERAL# + VV0036#; 10000 N !
PARAMETER G(BCC_B2,VA:AL:VA;0) 1 T*VV0037# + 0.5*GHSERAL# + VV0036#; 10000 N !
PARAMETER L(BCC_B2,AL,VA:VA:VA;0) 1 VV0044#; 10000 N !
PARAMETER L(BCC_B2,VA:AL,VA:VA;0) 1 VV0044#; 10000 N !
PARAMETER G(FCC_L12,AL:AL:AL:AL:VA;0) 1 1.0*GFCCAL#; 10000 N !
PARAMETER G(LIQUID,AL;0) 1 GLIQAL#; 10000 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     NI                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(AL3NI2,NI:NI:NI;0) 1 5*GHSERNI# + VV0051#; 10000 N !
PARAMETER G(BCC_B2,NI:NI:VA;0) 1 1.0*GBCCNI#; 10000 N !
PARAMETER G(BCC_B2,NI:VA:VA;0) 1 0.5*GHSERNI# + VV0038#; 10000 N !
PARAMETER G(BCC_B2,VA:NI:VA;0) 1 0.5*GHSERNI# + VV0038#; 10000 N !
PARAMETER L(BCC_B2,NI,VA:VA:VA;0) 1 VV0045#; 10000 N !
PARAMETER L(BCC_B2,VA:NI,VA:VA;0) 1 VV0045#; 10000 N !
PARAMETER G(FCC_L12,NI:NI:NI:NI:VA;0) 1 1.0*GFCCNI#; 10000 N !
PARAMETER G(LIQUID,NI;0) 1 GLIQNI#; 10000 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     VA                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(BCC_B2,VA:VA:VA;0) 1 0; 10000 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   AL-NI                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(AL3NI1,AL:NI;0) 1 T*VV0027# + 0.75*GHSERAL# + 0.25*GHSERNI# +
   VV0026#; 10000 N !
PARAMETER G(AL3NI2,AL:AL:NI;0) 1 T*VV0048# + 3*GHSERAL# + 2*GHSERNI# +
   VV0047#; 10000 N !
PARAMETER G(AL3NI2,AL:NI:NI;0) 1 2*GHSERAL# + 3*GHSERNI# + VV0049#; 10000 N !
PARAMETER G(AL3NI2,NI:AL:NI;0) 1 GHSERAL# + 4*GHSERNI# + VV0050#; 10000 N !
PARAMETER G(AL3NI5,AL:NI;0) 1 T*VV0029# + 0.375*GHSERAL# + 0.625*GHSERNI# +
   VV0028#; 10000 N !
PARAMETER G(BCC_B2,AL:NI:VA;0) 1 T**3*VV0033# + T**2*VV0032# +
   T*VV0034#*LN(T) + T*VV0035# + 0.5*GHSERAL# + 0.5*GHSERNI# + VV0030# +
   VV0031#*T**(-1); 10000 N !
PARAMETER G(BCC_B2,NI:AL:VA;0) 1 T**3*VV0033# + T**2*VV0032# +
   T*VV0034#*LN(T) + T*VV0035# + 0.5*GHSERAL# + 0.5*GHSERNI# + VV0030# +
   VV0031#*T**(-1); 10000 N !
PARAMETER L(BCC_B2,AL:AL,NI:VA;0) 1 VV0039#; 10000 N !
PARAMETER L(BCC_B2,AL:NI,VA:VA;0) 1 VV0040#; 10000 N !
PARAMETER L(BCC_B2,AL,NI:AL:VA;0) 1 VV0039#; 10000 N !
PARAMETER L(BCC_B2,AL,NI:NI:VA;0) 1 VV0041#; 10000 N !
PARAMETER L(BCC_B2,AL,NI:VA:VA;0) 1 VV0042#; 10000 N !
PARAMETER L(BCC_B2,AL,VA:NI:VA;0) 1 VV0043#; 10000 N !
PARAMETER L(BCC_B2,NI:AL,NI:VA;0) 1 VV0041#; 10000 N !
PARAMETER L(BCC_B2,NI:AL,VA:VA;0) 1 VV0043#; 10000 N !
PARAMETER L(BCC_B2,NI,VA:AL:VA;0) 1 VV0040#; 10000 N !
PARAMETER L(BCC_B2,VA:AL,NI:VA;0) 1 VV0042#; 10000 N !
PARAMETER L(BCC_B2,AL,NI:AL,NI:VA;0) 1 VV0046#; 10000 N !
PARAMETER G(FCC_L12,AL:AL:AL:NI:VA;0) 1 T*VV0004# + 0.75*GHSERAL# +
   0.25*GHSERNI# + VV0003#; 10000 N !
PARAMETER G(FCC_L12,AL:AL:NI:AL:VA;0) 1 T*VV0004# + 0.75*GHSERAL# +
   0.25*GHSERNI# + VV0003#; 10000 N !
PARAMETER G(FCC_L12,AL:AL:NI:NI:VA;0) 1 T*VV0006# + 0.5*GHSERAL# +
   0.5*GHSERNI# + VV0005#; 10000 N !
PARAMETER G(FCC_L12,AL:NI:AL:AL:VA;0) 1 T*VV0004# + 0.75*GHSERAL# +
   0.25*GHSERNI# + VV0003#; 10000 N !
PARAMETER G(FCC_L12,AL:NI:NI:AL:VA;0) 1 T*VV0006# + 0.5*GHSERAL# +
   0.5*GHSERNI# + VV0005#; 10000 N !
PARAMETER G(FCC_L12,AL:NI:NI:NI:VA;0) 1 T**3*VV0010# + T**2*VV0009# +
   T*VV0011#*LN(T) + T*VV0012# + 0.25*GHSERAL# + 0.75*GHSERNI# + VV0007# +
   VV0008#*T**(-1); 10000 N !
PARAMETER G(FCC_L12,NI:AL:AL:AL:VA;0) 1 T*VV0004# + 0.75*GHSERAL# +
   0.25*GHSERNI# + VV0003#; 10000 N !
PARAMETER G(FCC_L12,NI:AL:AL:NI:VA;0) 1 T*VV0006# + 0.5*GHSERAL# +
   0.5*GHSERNI# + VV0005#; 10000 N !
PARAMETER G(FCC_L12,NI:AL:NI:NI:VA;0) 1 T**3*VV0010# + T**2*VV0009# +
   T*VV0011#*LN(T) + T*VV0012# + 0.25*GHSERAL# + 0.75*GHSERNI# + VV0007# +
   VV0008#*T**(-1); 10000 N !
PARAMETER G(FCC_L12,NI:NI:AL:AL:VA;0) 1 T*VV0006# + 0.5*GHSERAL# +
   0.5*GHSERNI# + VV0005#; 10000 N !
PARAMETER G(FCC_L12,NI:NI:AL:NI:VA;0) 1 T**3*VV0010# + T**2*VV0009# +
   T*VV0011#*LN(T) + T*VV0012# + 0.25*GHSERAL# + 0.75*GHSERNI# + VV0007# +
   VV0008#*T**(-1); 10000 N !
PARAMETER G(FCC_L12,NI:NI:NI:AL:VA;0) 1 T**3*VV0010# + T**2*VV0009# +
   T*VV0011#*LN(T) + T*VV0012# + 0.25*GHSERAL# + 0.75*GHSERNI# + VV0007# +
   VV0008#*T**(-1); 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL:AL,NI:VA;0) 1 VV0015#; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL:AL,NI:VA;1) 1 VV0014#; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL:AL,NI:VA;2) 1 VV0013#; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:AL:VA;0) 1 VV0015#; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:AL:VA;1) 1 VV0014#; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:AL:VA;2) 1 VV0013#; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:NI:VA;0) 1 VV0018#; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:NI:VA;1) 1 VV0017#; 10000 N !
PARAMETER L(FCC_L12,AL:AL:AL,NI:NI:VA;2) 1 VV0016#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:AL:AL:VA;0) 1 VV0015#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:AL:AL:VA;1) 1 VV0014#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:AL:AL:VA;2) 1 VV0013#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:AL:VA;0) 1 VV0018#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:AL:VA;1) 1 VV0017#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:AL:VA;2) 1 VV0016#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:NI:VA;0) 1 VV0021#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:NI:VA;1) 1 VV0020#; 10000 N !
PARAMETER L(FCC_L12,AL:AL,NI:NI:NI:VA;2) 1 VV0019#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:AL:AL:AL:VA;0) 1 VV0015#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:AL:AL:AL:VA;1) 1 VV0014#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:AL:AL:AL:VA;2) 1 VV0013#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:AL:AL:VA;0) 1 VV0018#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:AL:AL:VA;1) 1 VV0017#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:AL:AL:VA;2) 1 VV0016#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:AL:VA;0) 1 VV0021#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:AL:VA;1) 1 VV0020#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:AL:VA;2) 1 VV0019#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:NI:VA;0) 1 VV0024#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:NI:VA;1) 1 VV0023#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:NI:NI:NI:VA;2) 1 VV0022#; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL:AL,NI:VA;0) 1 VV0018#; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL:AL,NI:VA;1) 1 VV0017#; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL:AL,NI:VA;2) 1 VV0016#; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL,NI:NI:VA;0) 1 VV0021#; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL,NI:NI:VA;1) 1 VV0020#; 10000 N !
PARAMETER L(FCC_L12,NI:AL:AL,NI:NI:VA;2) 1 VV0019#; 10000 N !
PARAMETER L(FCC_L12,NI:AL,NI:NI:NI:VA;0) 1 VV0024#; 10000 N !
PARAMETER L(FCC_L12,NI:AL,NI:NI:NI:VA;1) 1 VV0023#; 10000 N !
PARAMETER L(FCC_L12,NI:AL,NI:NI:NI:VA;2) 1 VV0022#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL:AL,NI:VA;0) 1 VV0021#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL:AL,NI:VA;1) 1 VV0020#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL:AL,NI:VA;2) 1 VV0019#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL,NI:NI:VA;0) 1 VV0024#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL,NI:NI:VA;1) 1 VV0023#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:AL,NI:NI:VA;2) 1 VV0022#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:NI:AL,NI:VA;0) 1 VV0024#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:NI:AL,NI:VA;1) 1 VV0023#; 10000 N !
PARAMETER L(FCC_L12,NI:NI:NI:AL,NI:VA;2) 1 VV0022#; 10000 N !
PARAMETER L(FCC_L12,AL,NI:AL,NI:AL,NI:AL,NI:VA;0) 1 VV0025#; 10000 N !
PARAMETER L(LIQUID,AL,NI;0) 1 VV0002#; 10000 N !
PARAMETER L(LIQUID,AL,NI;1) 1 VV0001#; 10000 N !
PARAMETER L(LIQUID,AL,NI;2) 1 VV0000#; 10000 N !
"""

CUO_TDB = """
$CuO
$ -----------------------------------------------------------------------------
$ 2008.12.5
$
$ TDB file created by K.Hashimoto and T.Abe,
$
$ Particle Simulation and Thermodynamics Group, National Institute for
$ Materials Science. 1-2-1 Sengen, Tsukuba, Ibaraki 305-0047, Japan
$
$ e-mail: abe.taichi@nims.go.jp
$
$ Copyright (C) NIMS 2008
$ -----------------------------------------------------------------------------
$
$ The parameter set is taken from
$ Thermodynamic Reassessment of the Cu-O Phase Diagram
$     L.Schramm, G.Behr, W.Loser, and K.Wetzig, J. Phase Equilibria and Diffusion, 26 (2005), 605-612.
$
$ -----------------------------------------------------------------------------
$ For pure elements, A.Dinsdale, Calphad 15 (1991) 317-425.
$
 ELEMENT /-   ELECTRON_GAS              0.0         0.0         0.0!
 ELEMENT VA   VACUUM                    0.0         0.0         0.0!
 ELEMENT CU   FCC_A1                    63.546      5004.064    33.1498!
 ELEMENT O    1/2_MOLE_O2(G)            15.999      4341.0      102.52!
$--------1---------2---------3---------4---------5---------6---------7---------8
$ Associates in the liquid, gas-O2, and ionic species
  SPECIES O2        O2!
  SPECIES O-2       O1/-2!
  SPECIES CU+1      CU1/+1!
  SPECIES CU+2      CU1/+2!
  SPECIES CU+3      CU1/+3!
$ -----------------------------------------------------------------------------
 FUNCTION GHSERCU    298.15  -7770.458+130.485235*T-24.112392*T*LN(T)
     -.00265684*T**2+1.29223E-07*T**3+52478*T**(-1);                  1358 Y
     -13542.026+183.803828*T-31.38*T*LN(T)+3.64167E+29*T**(-9);       3200 N ! $

 FUNCTION GCUBCC     298.15  +4017.00-1.255*T+GHSERCU;                6000 N !
 FUNCTION GCULIQ     298.15  +12964.735-9.511904*T
                             -5.849E-21*T**7 +GHSERCU;                1358 Y
       +13495.481-9.922344*T-3.64167E+29*T**(-9)+GHSERCU;             3200 N ! $

 FUNCTION GHSEROO    298.15 -3480.87-25.503038*T-11.136*T*LN(T)
      -.005098888*T**2+6.61846E-07*T**3-38365*T**(-1);               1000 Y
      -6568.763+12.65988*T-16.8138*T*LN(T)-5.95798E-04*T**2
      +6.781E-09*T**3+262905*T**(-1);                                3300 Y
      -13986.728+31.259625*T-18.9536*T*LN(T)-4.25243E-04*T**2
      +1.0721E-08*T**3+4383200*T**(-1);                              6000 N ! $

 FUNCTION GBCCOO     298.15 +26519.13-25.503038*T-11.1355*T*LN(T)
     -.005098875*T**2+6.61846E-07*T**3-38365*T**(-1);              1000 Y
     +23431.237+12.659879*T-16.8138*T*LN(T)-5.95797E-04*T**2+6.781E-09*T**3
     +262905*T**(-1);                                              3300 Y
     +16013.272+31.259624*T-18.9536*T*LN(T)-4.25243E-04*T**2+1.0721E-08*T**3
     +4383200*T**(-1);                                             6000 N !  $unary

 FUNCTION GCUCUO     298.15  -114945+307.98*T-67.71*T*LN(T);           6000 N ! $ 05Sch
 FUNCTION GCUCUO2    298.15  +1.333333*GCUCUO +16236 -20*T;            6000 N ! $ 05Sch
 FUNCTION GCUCUO3    298.15  +1.666667*GCUCUO -33972.668 +25.917348*T; 6000 N ! $ 05Sch

 FUNCTION UN_ASS 298.15 +0;                                         300. N !
 FUNCTION ZERO   298.15 +0;                                         300. N !

 TYPE_DEFINITION % SEQ *!

$ -----------------------------------------------------------------------------
 PHASE GAS:G %  1  1.0  !
   CONSTITUENT GAS:G :O2 :  !
   PARAMETER G(GAS,O2;0) 298.15 +2*GHSEROO+R*T*LN(1E-05*P); 6000 N !


 PHASE IONIC_LIQ:Y %  2 1   1 !
   CONSTITUENT IONIC_LIQ:Y : CU+1,CU+2,CU+3 : O-2,VA :  !                          $ 05Sch

   PARAMETER G(IONIC_LIQ,CU+1:VA;0)   298.15  +GCULIQ;                    3200 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+2:VA;0)   298.15  +3*GCULIQ+GCUCUO2-2*GCUCUO; 6000 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+3:VA;0)   298.15  +6*GCULIQ+0.5*GCUCUO2
                                              +GCUCUO3-4*GCUCUO;          6000 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+1:O-2;0)  298.15  +GCUCUO;                    6000 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+2:O-2;0)  298.15  +GCUCUO2;                   6000 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+3:O-2;0)  298.15  +GCUCUO3;                   6000 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+1:O-2,VA;0)   298.15  +13287+11.82*T;         6000 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+1:O-2,VA;1)   298.15  -17125+11.52*T;         6000 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+1:O-2,VA;2)   298.15  +21762-10.15*T;         6000 N ! $ 05Sch
   PARAMETER G(IONIC_LIQ,CU+1,CU+2:O-2;0) 298.15  -106048+70*T;           6000 N ! $ 05Sch


$ TYPE_DEFINITION ' GES A_P_D FCC_A1 MAGNETIC  -3.0 0.28 !
 PHASE FCC_A1  %'  1  1    !
   CONSTITUENT FCC_A1  : CU,O :  !
   PARAMETER G(FCC_A1,CU;0)      298.15 +GHSERCU;                   3200 N ! $ 05Sch
   PARAMETER G(FCC_A1,O;0)       298.15 +1000000 +GHSEROO;          6000 N ! $ 05Sch
   PARAMETER G(FCC_A1,CU,O;0)    298.15 -1017730 +29.6*T;           6000 N ! $ 05Sch

$ Non-stoichiometric compounds ----------------------------------------------


$ Line compounds ----------------------------------------------------------

 PHASE CU2O %  2 2 1 !
   CONSTITUENT CU2O  : CU : O :  !
   PARAMETER G(CU2O,CU:O;0) 298.15 -193230+360.057*T-66.26*T*LN(T)
                                   -0.00796*T**2 +374000*T**(-1);    6000 N ! $ 05Sch
$
 PHASE CUO  %  2 1 1 !
   CONSTITUENT CUO  : CU : O :  !
   PARAMETER G(CUO,CU:O;0) 298.15 -178002.39+275.159239*T-44.965711*T*LN(T)
                               -0.010809208*T**2 +1369987.3*T**(-1); 6000 N ! $ 05Sch
$
$
$CuO-NIMS

"""


PBSN_TDB = """
$ PBSN
$
$ TDB-file for the thermodynamic assessment of the Pb-Sn system
$
$--------------------------------------------------------------------------
$ 2011.12.1
$
$ TDB file created by T.Abe, K.Hashimoto and Y.Sawada
$
$ Particle Simulation and Thermodynamics Group, National Institute for
$ Materials Science. 1-2-1 Sengen, Tsukuba, Ibaraki 305-0047, Japan
$ e-mail: abe.taichi@nims.go.jp
$ Copyright (C) NIMS 2011
$
$
$ PARAMETERS ARE TAKEN FROM
$ A thermodynamic analysis of the Pb-Sn system and
$ the calculation of the Pb-Sn phase diagram,
$ T.L.Ngai, Y.A.Chang, CALPHAD, 5 (1981) 267-276.
$
$ ------------------------------------------------------------------------------
$
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT PB   FCC_A1                    2.0720E+02  6.8785E+03  6.4785E+01!
 ELEMENT SN   BCT_A5                    1.1871E+02  6.3220E+03  5.1195E+01!
$
$-------------------------------------------------------------------------------
$ FUNCTIONS FOR PURE AND OTHERS
$-------------------------------------------------------------------------------
FUNCTION GHSERPB  298.15
   -7650.085+101.715188*T-24.5242231*T*LN(T)-3.65895E-3*T**2-0.24395E-6*T**3;
                                                                     600.65 Y
   -10531.115+154.258155*T-32.4913959*T*LN(T)+1.54613E-3*T**2
   +805.644E23*T**(-9);                                             1200.00 Y
   +4157.596+53.154045*T-18.9640637*T*LN(T)-2.882943E-3*T**2+0.098144E-6*T**3
   -2696755*T**(-1)+805.644E23*T**(-9);                             5000.00 N !
FUNCTION GPBLIQ  298.15
   +4672.157-7.750257*T-6.0144E-19*T**7+GHSERPB#;                    600.65 Y
   +4853.112-8.066587*T-8.05644E25*T**(-9)+GHSERPB#;                5000.00 N !
FUNCTION GPBBCT  298.15  +489+3.52*T+GHSERPB#;                      5000.00 N !

FUNCTION GHSERSN    100  -7958.517+122.750027*T-25.858*T*LN(T)
    +5.1185E-04*T**2-3.192767E-06*T**3+18440*T**(-1);                   250 Y
    -5855.135+65.427891*T-15.961*T*LN(T)-.0188702*T**2+3.121167E-06*T**3
    -61960*T**(-1);                                                  505.08 Y
    +2524.724+3.989845*T-8.2590486*T*LN(T)-.016814429*T**2
    +2.623131E-06*T**3-1081244*T**(-1)-1.2307E+25*T**(-9);              800 Y
    -8256.959+138.981456*T-28.4512*T*LN(T)-1.2307E+25*T**(-9);          3000 N !
 FUNCTION GSNLIQ     100
    +7104.222-14.09088*T+1.49316649E-18*T**7+GHSERSN#;               505.06 Y
    +6970.705-13.813302*T+1.24912E+25*T**(-9)+GHSERSN#;                3000 N !
 FUNCTION GSNFCC     298.15  +4150-5.2*T+GHSERSN#;                     3000 N !

$-------------------------------------------------------------------------------
 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA /- !

$-------------------------------------------------------------------------------
$ PARAMETERS FOR LIQUID PHASE
$-------------------------------------------------------------------------------
 PHASE LIQUID:L %  1  1.0  !
    CONSTITUENT LIQUID:L :PB,SN :  !
   PARAMETER G(LIQUID,PB;0)     298.15   +GPBLIQ#;                      5000 N !
   PARAMETER G(LIQUID,SN;0)     298.15   +GSNLIQ#;                      4000 N !
   PARAMETER G(LIQUID,PB,SN;0)  298.15   +5125+1.46424*T;               6000 N !
   PARAMETER G(LIQUID,PB,SN;1)  298.15   +293.82;                       6000 N !

$-------------------------------------------------------------------------------
$ FUNCTIONS FOR FCC_A1
$-------------------------------------------------------------------------------
 PHASE FCC_A1  %  2 1   1 !
    CONSTITUENT FCC_A1  :PB,SN : VA :  !
   PARAMETER G(FCC_A1,PB:VA;0)     298.15  +GHSERPB#;                   5000 N !
   PARAMETER G(FCC_A1,SN:VA;0)     298.15  +GSNFCC#;                    4000 N !
   PARAMETER G(FCC_A1,PB,SN:VA;0)  298.15  +5132.41+1.56312*T;          6000 N !

$-------------------------------------------------------------------------------
$ FUNCTIONS FOR BCT_A5
$-------------------------------------------------------------------------------
 PHASE BCT_A5  %  2 1   3 !
    CONSTITUENT BCT_A5  :PB,SN : VA% :  !
   PARAMETER G(BCT_A5,PB:VA;0)      298.15  +GPBBCT#;                   4000 N !
   PARAMETER G(BCT_A5,SN:VA;0)      298.15  +GHSERSN#;                  6000 N !
   PARAMETER G(BCT_A5,PB,SN:VA;0)   298.15  +17117.78-11.8066*T;        6000 N !

$PB-SN

"""

AL_PARAMETER_TDB = """
ELEMENT AL   FCC_A1                    26.981539   4577.296    28.3215!
FUNCTION VV0000     298.15   5000;              6000.00 N !

PHASE FCC_A1  %  1 1 !
   CONSTITUENT FCC_A1  :AL:  !
   PARAMETER G(FCC_A1,AL;0)      298.15   +VV0000#;       2900 N !
"""

VA_INTERACTION_TDB = """
ELEMENT AL   FCC_A1                    26.981539   4577.296    28.3215!
ELEMENT VA   BLANK                     0.0 0.0 0.0 !

PHASE FCC_A1  %  2 1 1 !
   CONSTITUENT FCC_A1  :AL,VA:VA:  !
   PARAMETER G(FCC_A1,AL:VA;0)      0.01   100;       6000 N !
   PARAMETER G(FCC_A1,VA:VA;0)      0.01   500;       6000 N !
   PARAMETER G(FCC_A1,AL,VA:VA;0)      0.01   4000;       6000 N !

"""

CRFE_BCC_MAGNETIC_TDB = """
ELEMENT CR BLANK 0 0 0 !
ELEMENT FE BLANK 0 0 0 !
ELEMENT VA BLANK 0 0 0 !

FUNCTION GHSERCR 1 -1.47721E-6*T**3 + 0.00189435*T**2 - 26.908*T*LN(T) +
   157.48*T - 8856.94 + 139250*T**(-1); 2180.0 Y -50*T*LN(T) + 344.18*T -
   34869.344 - 2.88526E+32*T**(-9); 6000.0 N !
FUNCTION GHSERFE 1 -5.8927E-8*T**3 - 0.00439752*T**2 - 23.5143*T*LN(T) +
   124.134*T + 1225.7 + 77359*T**(-1); 1811.0 Y -46*T*LN(T) + 299.31255*T -
   25383.581 + 2.29603E+31*T**(-9); 6000.0 N !

FUNCTION GBCCCR 1 GHSERCR#; 6000.0 N !
FUNCTION GBCCFE 1 GHSERFE#; 6000.0 N !

TYPE_DEFINITION % SEQ * !
DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
DEFAULT_COMMAND DEFINE_SYSTEM_ELEMENT VA !

TYPE_DEFINITION & GES A_P_D BCC_A2 MAGNETIC -1.0 0.4 !

PHASE BCC_A2 %&  2 1 3 !
CONSTITUENT BCC_A2 :CR,FE:VA: !

PARAMETER G(BCC_A2,CR:VA;0) 1 GBCCCR#; 10000 N !
PARAMETER G(BCC_A2,FE:VA;0) 1 GBCCFE#; 10000 N !

PARAMETER TC(BCC_A2,CR:VA;0) 1 -311.50; 6000 N !
PARAMETER BM(BCC_A2,CR:VA;0) 1 -0.008; 6000 N !

PARAMETER TC(BCC_A2,FE:VA;0) 1 1043; 6000 N !
PARAMETER BM(BCC_A2,FE:VA;0) 1 2.22; 6000 N !

PARAMETER L(BCC_A2,CR,FE:VA;0) 1 1000; 10000 N !

"""

CUMG_TDB = """$ CUMG
$
$ TDB-file for the thermodynamic assessment of the Cu-Mg system
$
$--------------------------------------------------------------------------
$ 2008.10.21
$
$ TDB file for PANDAT created by M.Palumbo, T.Abe and K.Hashimoto
$
$ Particle Simulation and Thermodynamics Group, National Institute for
$ Materials Science. 1-2-1 Sengen, Tsukuba, Ibaraki 305-0047, Japan
$ e-mail: abe.taichi@nims.go.jp
$ Copyright (C) NIMS 2008
$
$
$ PARAMETERS ARE TAKEN FROM
$   P. Liang et al. CALPHAD 22 (1998) pp. 527-544
$
$ Parameters are the same as in C. A. Coughanowr et al. Z. Metallkde. 82
$ (1991) pp. 574-581 (Parameter set 3), with some minor adjustments on Cu2Mg
$ Laves phase in order to use it in ternary and higher order systems.
$ With respect to results published by Coughanowr, some minor differences
$ exist in reaction temperatures (<5K).
$
$ -------------------------------------------------------------------------
$
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT CU   FCC_A1                    6.3546E+01  5.0041E+03  3.3150E+01!
 ELEMENT MG   HCP_A3                    2.4305E+01  4.9980E+03  3.2671E+01!
$
$ -------------------------------------------------------------------------
$
 FUNCTION GHSERCU    298.15  -7770.458+130.485403*T-24.112392*T*LN(T)
                  -.00265684*T**2+1.29223E-07*T**3+52478*T**(-1); 1358.02 Y
        -13542.33+183.804197*T-31.38*T*LN(T)+3.64643E+29*T**(-9);  3200 N !
 FUNCTION GMGLIQ     298.15  +8202.24-8.83693*T-8.01759E-20*T**7
                                                       +GHSERMG#;  923 Y
                 +8690.32-9.39216*T-1.03819E+28*T**(-9)+GHSERMG#;  6000 N !
 FUNCTION GHSERMG    298.15  -8367.34+143.677875*T-26.1849782*T*LN(T)
                 +4.858E-04*T**2-1.393669E-06*T**3+78950*T**(-1);  923 Y
    -14130.185+204.718543*T-34.3088*T*LN(T)+1.038192E+28*T**(-9);  3000 N !
 FUNCTION UN_ASS     298.15                                    0;   300 N !

 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA !
$
$ -------------------------------------------------------------------------
$
 PHASE LIQUID:L %  1  1.0  !
  CONSTITUENT LIQUID:L :CU,MG :  !
  PARAMETER G(LIQUID,CU;0)     298.15      +12964.84-9.510243*T
                                     -5.83932E-21*T**7+GHSERCU#; 1358.02 Y
               +13495.4-9.920463*T-3.64643E+29*T**(-9)+GHSERCU#;  3200 N !
  PARAMETER G(LIQUID,MG;0)     298.15                  +GMGLIQ#;  3000 N !
  PARAMETER G(LIQUID,CU,MG;0)  298.15       -36984.00+4.75612*T;  6000 N !
  PARAMETER G(LIQUID,CU,MG;1)  298.15                  -8191.29;  6000 N !

 TYPE_DEFINITION & GES A_P_D FCC_A1 MAGNETIC  -3.0    2.80000E-01 !
 PHASE FCC_A1  %&  2 1   1 !
  CONSTITUENT FCC_A1  :CU,MG : VA :  !
  PARAMETER G(FCC_A1,CU:VA;0)     298.15              +GHSERCU#;  3200 N !
  PARAMETER G(FCC_A1,MG:VA;0)     298.15    +2600-.9*T+GHSERMG#;  3000 N !
  PARAMETER G(FCC_A1,CU,MG:VA;0)  298.15      -22279.28+5.868*T;  6000 N !

 PHASE HCP_A3  %  2 1   .5 !
  CONSTITUENT HCP_A3  :MG : VA :  !
  PARAMETER G(HCP_A3,MG:VA;0)     298.15              +GHSERMG#;  3000 N !

 PHASE CU2MG  %  2 2 1 !
  CONSTITUENT CU2MG  :CU,MG : CU,MG :  !
  PARAMETER G(CU2MG,CU:CU;0)     298.15    +21014.88+3*GHSERCU#;  6000 N !
   PARAMETER G(CU2MG,CU:MG;0)    298.15   -54690.99+364.73085*T
               -69.276417*T*LN(T)-5.1925E-4*T**2+143502*T**(-1)
                                             -5.65953E-6*T**(3);  6000 N !
   PARAMETER G(CU2MG,MG:CU;0)    298.15          +105000-16.5*T
                                           +2*GHSERMG#+GHSERCU#;  6000 N !
   PARAMETER G(CU2MG,MG:MG;0)    298.15    +27357.33+3*GHSERMG#;  6000 N !
   PARAMETER G(CU2MG,CU,MG:*;0)  298.15                 6599.45;  6000 N !
   PARAMETER G(CU2MG,*:CU,MG;0)  298.15                13011.35;  6000 N !

 PHASE CUMG2  %  2 1   2 !
  CONSTITUENT CUMG2  :CU : MG :  !
  PARAMETER G(CUMG2,CU:MG;0)     298.15    -28620.00+1.859733*T
                                           +GHSERCU#+2*GHSERMG#;  6000 N !
$
$------------------------------------------------------------ END OF LINE
$ CU-MG NIMS
"""

CUMG_PARAMETERS_TDB = """
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$ Date: 2018-12-18 11:03
$ Components: CU, MG, VA
$ Phases: CUMG2, FCC_A1, HCP_A3, LAVES_C15, LIQUID
$ Generated by brandon (pycalphad 0.7.1.post2)
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

ELEMENT CU BLANK 0 0 0 !
ELEMENT MG BLANK 0 0 0 !
ELEMENT VA BLANK 0 0 0 !


FUNCTION GFCCCU 1.0 GHSERCU#; 10000.0 N !
FUNCTION GFCCMG 0.01 -2.18283562784578E-6*T**3 - 6.21802726222479E-5*T**2 +
   3.2404446864*T*LN(EXP(95.82831*T**(-1)) - 1.0) +
   21.6535319868*T*LN(EXP(247.8675*T**(-1)) - 1.0) + 0.246565697987779*T -
   8158.16393259455; 298.15 Y -1.393669E-6*T**3 + 0.0004858*T**2 -
   26.1849782*T*LN(T) + 142.775547*T - 5767.34 + 78950*T**(-1);
   922.205302616508 Y -34.3088*T*LN(T) + 203.816215*T - 11530.1836392866 +
   1.038192E+28*T**(-9); 3000.0 N !
FUNCTION GHCPCU 0.01 -3.38438862938597E-7*T**3 - 0.00121182291077191*T**2 +
   8.7685671186*T*LN(EXP(155.1404*T**(-1)) - 1.0) +
   16.1968683846*T*LN(EXP(290.9421*T**(-1)) - 1.0) - 0.321147237334052*T -
   10441.4393392344; 298.15 Y 1.29223E-7*T**3 - 0.00265684*T**2 -
   24.112392*T*LN(T) + 130.685235*T - 7170.458 + 52478*T**(-1); 1357.77 Y
   -31.38*T*LN(T) + 184.003828*T - 12942.0252504739 + 3.64167E+29*T**(-9);
   3200.0 N !
FUNCTION GHCPMG 1.0 GHSERMG#; 10000.0 N !
FUNCTION GHSERCU 0.01 -0.0010514335*T**2 +
   8.7685671186*T*LN(EXP(155.1404*T**(-1)) - 1.0) +
   16.1968683846*T*LN(EXP(290.9421*T**(-1)) - 1.0) - 11038.0904080745;
   103.57591 Y -2.15621953171362E-6*T**3 + 0.000288560900942072*T**2 -
   0.13879113947248*T*LN(T) + 8.7685671186*T*LN(EXP(155.1404*T**(-1)) - 1.0)
   + 16.1968683846*T*LN(EXP(290.9421*T**(-1)) - 1.0) + 0.574637617323048*T -
   11042.8822142647; 210.33309 Y -0.002432585*T**2 + 0.4335558862135*T*LN(T)
   + 8.7685671186*T*LN(EXP(155.1404*T**(-1)) - 1.0) +
   16.1968683846*T*LN(EXP(290.9421*T**(-1)) - 1.0) - 2.20049706600083*T -
   11002.7543747764; 1357.77 Y -31.38*T*LN(T) + 183.555483717662*T -
   12730.2995781851 + 7.42232714807953E+28*T**(-9); 3200.0 N !
FUNCTION GHSERMG 0.01 0.0047195465*T**2 +
   3.2404446864*T*LN(EXP(95.82831*T**(-1)) - 1.0) +
   21.6535319868*T*LN(EXP(247.8675*T**(-1)) - 1.0) - 10652.1012810789;
   36.71926 Y -1.53643054262276E-5*T**3 + 0.00810454205399037*T**2 -
   0.124294531845816*T*LN(T) + 3.2404446864*T*LN(EXP(95.82831*T**(-1)) - 1.0)
   + 21.6535319868*T*LN(EXP(247.8675*T**(-1)) - 1.0) + 0.385723396310737*T -
   10653.6226154894; 143.18844 Y -0.0050954035*T**2 + 1.765785080115*T*LN(T)
   + 3.2404446864*T*LN(EXP(95.82831*T**(-1)) - 1.0) +
   21.6535319868*T*LN(EXP(247.8675*T**(-1)) - 1.0) - 8.0518972866125*T -
   10563.4100984519; 922.205302616508 Y -34.3088*T*LN(T) + 204.341485347575*T
   - 13775.4156328263 + 9.4687256586798E+27*T**(-9); 10000.0 N !
FUNCTION GHSERVA 1 0; 10000 N !
FUNCTION GLIQCU 0.01 -3.40056501515466E-7*T**3 - 0.00121066539331185*T**2 +
   8.7685671186*T*LN(EXP(155.1404*T**(-1)) - 1.0) +
   16.1968683846*T*LN(EXP(290.9421*T**(-1)) - 1.0) - 10.033338832193*T +
   2379.36422209194; 298.15 Y -5.8489E-21*T**7 + 1.29223E-7*T**3 -
   0.00265684*T**2 - 24.112392*T*LN(T) + 120.973331*T + 5650.32106235287 +
   52478*T**(-1); 1357.77 Y -31.38*T*LN(T) + 173.881484*T + 409.498458129716;
   3200.0 N !
FUNCTION GLIQMG 0.01 -2.2050100179942E-6*T**3 - 4.63131660076452E-5*T**2 +
   3.2404446864*T*LN(EXP(95.82831*T**(-1)) - 1.0) +
   21.6535319868*T*LN(EXP(247.8675*T**(-1)) - 1.0) - 7.6943066168765*T -
   2555.58510336379; 298.15 Y -8.0176E-20*T**7 - 1.393669E-6*T**3 +
   0.0004858*T**2 - 26.1849782*T*LN(T) + 134.838617*T - 165.096999676889 +
   78950*T**(-1); 922.205302616508 Y -34.3088*T*LN(T) + 195.324057*T -
   5439.86911093575; 10000.0 N !
FUNCTION VV0000 1 -32539.5; 10000 N !
FUNCTION VV0001 1 8236.3; 10000 N !
FUNCTION VV0002 1 -14675.0; 10000 N !
FUNCTION VV0003 1 -24441.2; 10000 N !
FUNCTION VV0004 1 20149.6; 10000 N !
FUNCTION VV0005 1 46500.0; 10000 N !
FUNCTION VV0006 1 -39591.3; 10000 N !
FUNCTION VV0007 1 104160.0; 10000 N !
FUNCTION VV0008 1 21000.0; 10000 N !
FUNCTION VV0009 1 17772.0; 10000 N !
FUNCTION VV0010 1 21240.0; 10000 N !
FUNCTION VV0011 1 14321.1; 10000 N !
FUNCTION VV0012 1 -4923.18; 10000 N !
FUNCTION VV0013 1 -1962.8; 10000 N !
FUNCTION VV0014 1 -31626.6; 10000 N !

TYPE_DEFINITION % SEQ * !
DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
DEFAULT_COMMAND DEFINE_SYSTEM_ELEMENT VA !

PHASE CUMG2 %  2 1 2 !
CONSTITUENT CUMG2 :CU:MG: !

PHASE FCC_A1 %  1 1 !
CONSTITUENT FCC_A1 :CU,MG: !

PHASE HCP_A3 %  1 1 !
CONSTITUENT HCP_A3 :CU,MG: !

PHASE LAVES_C15 %  2 2 1 !
CONSTITUENT LAVES_C15 :CU,MG:CU,MG: !

PHASE LIQUID %  1 1 !
CONSTITUENT LIQUID :CU,MG: !



$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     CU                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(FCC_A1,CU;0) 1 GFCCCU#; 10000 N !
PARAMETER G(HCP_A3,CU;0) 1 GHCPCU#; 10000 N !
PARAMETER G(LAVES_C15,CU:CU;0) 1 3*GHSERCU# + VV0005#; 10000 N !
PARAMETER G(LIQUID,CU;0) 1 GLIQCU#; 10000 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     MG                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(FCC_A1,MG;0) 1 GFCCMG#; 10000 N !
PARAMETER G(HCP_A3,MG;0) 1 GHCPMG#; 10000 N !
PARAMETER G(LAVES_C15,MG:MG;0) 1 3*GHSERMG# + VV0008#; 10000 N !
PARAMETER G(LIQUID,MG;0) 1 GLIQMG#; 10000 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   CU-MG                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(CUMG2,CU:MG;0) 1 GHSERCU# + 2*GHSERMG# + VV0000#; 10000 N !
PARAMETER L(FCC_A1,CU,MG;0) 1 VV0002#; 10000 N !
PARAMETER L(FCC_A1,CU,MG;1) 1 VV0001#; 10000 N !
PARAMETER L(HCP_A3,CU,MG;0) 1 VV0004#; 10000 N !
PARAMETER L(HCP_A3,CU,MG;1) 1 VV0003#; 10000 N !
PARAMETER G(LAVES_C15,CU:MG;0) 1 2*GHSERCU# + GHSERMG# + VV0006#; 10000 N !
PARAMETER G(LAVES_C15,MG:CU;0) 1 GHSERCU# + 2*GHSERMG# + VV0007#; 10000 N !
PARAMETER L(LAVES_C15,CU:CU,MG;0) 1 VV0009#; 10000 N !
PARAMETER L(LAVES_C15,CU,MG:MG;0) 1 VV0010#; 10000 N !
PARAMETER L(LIQUID,CU,MG;0) 1 VV0014#; 10000 N !
PARAMETER L(LIQUID,CU,MG;1) 1 VV0013#; 10000 N !
PARAMETER L(LIQUID,CU,MG;2) 1 VV0012#; 10000 N !
PARAMETER L(LIQUID,CU,MG;3) 1 VV0011#; 10000 N !
"""

ZRO2_CUBIC_BCC_TDB = """
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5773E+03  2.8321E+01!
 ELEMENT CU   FCC_A1                    6.3546E+01  5.0041E+03  3.3150E+01!
 ELEMENT O    1/2_MOLE_O2(G)            1.5999E+01  4.3410E+03  1.0252E+02!
 ELEMENT ZR   HCP_A3                    9.1224E+01  5.5663E+03  3.9181E+01!

 PHASE BCC_A2  %  2 1   3 !
    CONSTITUENT BCC_A2  :AL,CU,ZR : O,VA% :  !

 PHASE ZRO2_CUBIC  %  2 1   2 !
    CONSTITUENT ZRO2_CUBIC  :VA,ZR% : O%,VA :  !
"""

C_FE_BROSHE_TDB = """$ Database has pressure dependence, which is useful for testing.
$ Database file written 2014- 6- 9
$ From database: User data 2014.06.09

 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT C    GRAPHITE                  1.2011E+01  1.0540E+03  5.7400E+00!
 ELEMENT FE   BCC_A2                    5.5847E+01  4.4890E+03  2.7280E+01!


$------------------------------------------------------------------------------
$ definition of functions

 FUNCTION GHSERCC     0.01 -1049.14084-.09009204*T-2.75E-05*T**3; 103 Y
      -988.25091-7.39898691*T+1.76583*T*LN(T)-.01706952*T**2; 350 Y
      -17368.441+170.73*T-24.3*T*LN(T)-4.723E-04*T**2+2562600*T**(-1)
     -2.643E+08*T**(-2)+1.2E+10*T**(-3); 6000 N 10Hal !
 FUNCTION GA9C      298.15 +GHSERCC#; 6000 N 10Hal !
 FUNCTION GA4C        0.01 +1366.36944+.0375684493*T-1.795E-08*T**4;  78 Y
      +3386.8147-64.4266811*T+11.71699*T*LN(T)-.0304*T**2+3.3333E-06*T**3
     -91196.5*T**(-1)+2797170*T**(-2)-38820740*T**(-3); 330 Y
      -16359.441+175.61*T-24.31*T*LN(T)-4.723E-04*T**2+2698000*T**(-1)
     -2.61E+08*T**(-2)+1.11E+10*T**(-3); 6000 N 10Hal !
 FUNCTION GLIQC     298.15 +117369-24.63*T+GHSERCC#; 6000 N 91Din !
 FUNCTION GHSERFE     0.01 +4701.3908-9.929623*T-1.975E-06*T**4;  50 Y
      +4871.6848-41.511332*T+8.75517*T*LN(T)-.13106*T**2+9.2615E-05*T**3;
     170 Y
      +1225.7+124.134*T-23.5143*T*LN(T)-.00439752*T**2-5.8927E-08*T**3
     +77359*T**(-1); 1811 Y
      -25383.581+299.31255*T-46*T*LN(T)+2.29603E+31*T**(-9); 6000 N 10Hal !
 FUNCTION GA2FE     298.15 +GHSERFE#; 6000 N 10Hal !
 FUNCTION GA1FE     298.15 -1462.4+8.282*T-1.15*T*LN(T)+6.4E-04*T**2
     +GHSERFE#; 1811 Y
      -1713.815+.940009*T+GHSERFE#+4.9251E+30*T**(-9); 6000 N !
 FUNCTION GA3FE     298.15 -3705.78+12.591*T-1.15*T*LN(T)+6.4E-04*T**2
     +GHSERFE#; 1811 Y
      -3957.195+5.249009*T+GHSERFE#+4.9251E+30*T**(-9); 6000 N 91Din !
 FUNCTION GL1FE     298.15 +12040.17-6.55843*T+GHSERFE#-3.67516E-21*T**7;
     1811 Y
      -10838.83+291.302*T-46*T*LN(T); 6000 N 91Din !
 FUNCTION GFECEM      0.01 +11369.9377-5.64125926*T-8.333E-06*T**4;  43 Y
      +11622.6472-59.5377093*T+15.74232*T*LN(T)-.27565*T**2; 163 Y
      -10195.8608+690.949888*T-118.47637*T*LN(T)-7E-04*T**2+590527*T**(-1);
     6000 N 10Hal !
$ constants derived from 91Din for implementation calculation of 07Br EOS
 FUNCTION HSEA1FE   298.15 +7973.03; 6000 N !
 FUNCTION SSEA1FE   298.15 +35.902103; 6000 N !
 FUNCTION CSEA1FE   298.15 +25.19585; 6000 N !
 FUNCTION HSEA3FE   298.15 +5729.65; 6000 N !
 FUNCTION SSEA3FE   298.15 +31.593103; 6000 N !
 FUNCTION CSEA3FE   298.15 +25.19585; 6000 N !
 FUNCTION HSEL1FE   298.15 +21189.6; 6000 N !
 FUNCTION SSEL1FE   298.15 +43.421947; 6000 N !
 FUNCTION CSEL1FE   298.15 +24.42759; 6000 N !


$ parameters for BCC_A2 Fe
 FUNCTION FV0A2FE   298.15 +7.05E-06; 6000 N !
 FUNCTION FV1A2FE   298.15 +1.7E+11; 6000 N !
 FUNCTION FV2A2FE   298.15 +6.2; 6000 N !
 FUNCTION FV3A2FE   298.15 +300; 6000 N !
 FUNCTION FV4A2FE   298.15 +1.55; 6000 N !
 FUNCTION FV5A2FE   298.15 +6; 6000 N !
 FUNCTION FV6A2FE   298.15 +1; 6000 N !
 FUNCTION FV7A2FE   298.15 +15; 6000 N !
 FUNCTION FV8A2FE   298.15 +3; 6000 N !

$ implementation of EOS for BCC_A2 Fe
 FUNCTION PA2FE     298.15 +FV1A2FE#**(-1)*P; 6000 N !
 FUNCTION BVA2FE    298.15 +FV0A2FE#*FV1A2FE#; 6000 N !
 FUNCTION IAA2FE    298.15 +FV2A2FE#-.333333333; 6000 N !
 FUNCTION FCA2FE    298.15 +1+1.33333333*IAA2FE#*PA2FE#; 6000 N !
 FUNCTION LFCA2FE   298.15 +1*LN(FCA2FE#); 6000 N !
 FUNCTION IXCA2FE   298.15 +1-IAA2FE#**(-1)+IAA2FE#**(-1)*EXP(.25*LFCA2FE#);
     6000 N !
 FUNCTION G2A2FE    298.15 +1.5*FV2A2FE#**3-6*FV2A2FE#**2+8*FV2A2FE#
     -3.55555555; 6000 N !
 FUNCTION G1A2FE    298.15 -9*FV2A2FE#**3+27*FV2A2FE#**2-24*FV2A2FE#
     +5.33333333; 6000 N !
 FUNCTION GLA2FE    298.15 +9*FV2A2FE#**3-18*FV2A2FE#**2+9*FV2A2FE#
     -1.33333333; 6000 N !
 FUNCTION GM1A2FE   298.15 +3*FV2A2FE#**3-3*FV2A2FE#**2+FV2A2FE#-.111111111;
     6000 N !
 FUNCTION GPCA2FE   298.15 +G2A2FE#*IXCA2FE#**(-2)+G1A2FE#*IXCA2FE#**(-1)
     -GLA2FE#*LN(IXCA2FE#)+GM1A2FE#*IXCA2FE#-G2A2FE#-G1A2FE#-GM1A2FE#; 6000
     N !
 FUNCTION PTA2FE    298.15 +FV1A2FE#**(-1)*P+FV5A2FE#*FV1A2FE#**(-1)*P; 6000
     N !
 FUNCTION IATA2FE   298.15 +3*FV6A2FE#-1; 6000 N !
 FUNCTION FTA2FE    298.15 +1+.666666667*IATA2FE#*PTA2FE#; 6000 N !
 FUNCTION LTFA2FE   298.15 +1*LN(FTA2FE#); 6000 N !
 FUNCTION IXTA2FE   298.15 +1-IATA2FE#**(-1)+IATA2FE#**(-1)*EXP(.5*LTFA2FE#);
      6000 N !
 FUNCTION GPTA2FE   298.15 +4.5*FV6A2FE#*IXTA2FE#**(-2)-3*IXTA2FE#**(-2)
     -9*FV6A2FE#*IXTA2FE#**(-1)+3*IXTA2FE#**(-1)+4.5*FV6A2FE#; 6000 N !
 FUNCTION PT2A2FE   298.15 +FV1A2FE#**(-1)*P+FV7A2FE#*FV1A2FE#**(-1)*P; 6000 N !
 FUNCTION IYA2FE    298.15 +1+2*FV8A2FE#*PT2A2FE#; 6000 N !
 FUNCTION LYA2FE    298.15 +.5*LN(IYA2FE#); 6000 N !
 FUNCTION YA2FE     298.15 +1*EXP(LYA2FE#); 6000 N !
 FUNCTION IBA2FE    298.15 +FV8A2FE#**(-1)-FV8A2FE#**(-1)*EXP(LYA2FE#); 6000 N !
 FUNCTION GBPA2FE   298.15 +1+FV8A2FE#-FV8A2FE#*EXP(IBA2FE#)
     -YA2FE#*EXP(IBA2FE#); 6000 N !
 FUNCTION GBMA2FE   298.15 +1+FV8A2FE#; 6000 N !
 FUNCTION GBRA2FE   298.15 +GBMA2FE#**(-1)*GBPA2FE#; 6000 N !
 FUNCTION IGRA2FE   298.15 +FV5A2FE#*FV4A2FE#**(-1)+FV4A2FE#**(-1); 6000 N !
 FUNCTION INTA2FE   298.15 +IGRA2FE#**(-1)*GPTA2FE#; 6000 N !
 FUNCTION TA2FE     298.15 +FV3A2FE#*EXP(INTA2FE#); 6000 N !
 FUNCTION IEA2FE    298.15 +1-1*EXP(-TA2FE#*T**(-1)); 6000 N !
 FUNCTION IE0A2FE   298.15 +1-1*EXP(-FV3A2FE#*T**(-1)); 6000 N !
 FUNCTION HSEA2FE   298.15 +4701.3908; 6000 N !
 FUNCTION SSEA2FE   298.15 +9.929623; 6000 N !
 FUNCTION DGTA2FE   298.15 -HSEA2FE#+SSEA2FE#*T+GHSERFE#-3*R#*T*LN(IE0A2FE#);
      6000 N !

$  parameters for FCC_A1 Fe
 FUNCTION FV0A1FE   298.15 +6.831E-06; 6000 N !
 FUNCTION FV1A1FE   298.15 +1.65E+11; 6000 N !
 FUNCTION FV2A1FE   298.15 +5.25; 6000 N !
 FUNCTION FV3A1FE   298.15 +250; 6000 N !
 FUNCTION FV4A1FE   298.15 +2.35; 6000 N !
 FUNCTION FV5A1FE   298.15 +5; 6000 N !
 FUNCTION FV6A1FE   298.15 +1; 6000 N !
 FUNCTION FV7A1FE   298.15 +10; 6000 N !
 FUNCTION FV8A1FE   298.15 +3; 6000 N !

$ implementation of EOS for FCC_A1 Fe
 FUNCTION PA1FE     298.15 +FV1A1FE#**(-1)*P; 6000 N !
 FUNCTION BVA1FE    298.15 +FV0A1FE#*FV1A1FE#; 6000 N !
 FUNCTION IAA1FE    298.15 +FV2A1FE#-.333333333; 6000 N !
 FUNCTION FCA1FE    298.15 +1+1.33333333*IAA1FE#*PA1FE#; 6000 N !
 FUNCTION LFCA1FE   298.15 +1*LN(FCA1FE#); 6000 N !
 FUNCTION IXCA1FE   298.15 +1-IAA1FE#**(-1)+IAA1FE#**(-1)*EXP(.25*LFCA1FE#);
     6000 N !
 FUNCTION G2A1FE    298.15 +1.5*FV2A1FE#**3-6*FV2A1FE#**2+8*FV2A1FE#
     -3.55555555; 6000 N !
 FUNCTION G1A1FE    298.15 -9*FV2A1FE#**3+27*FV2A1FE#**2-24*FV2A1FE#
     +5.33333333; 6000 N !
 FUNCTION GLA1FE    298.15 +9*FV2A1FE#**3-18*FV2A1FE#**2+9*FV2A1FE#
     -1.33333333; 6000 N !
 FUNCTION GM1A1FE   298.15 +3*FV2A1FE#**3-3*FV2A1FE#**2+FV2A1FE#-.111111111;
     6000 N !
 FUNCTION GPCA1FE   298.15 +G2A1FE#*IXCA1FE#**(-2)+G1A1FE#*IXCA1FE#**(-1)
     -GLA1FE#*LN(IXCA1FE#)+GM1A1FE#*IXCA1FE#-G2A1FE#-G1A1FE#-GM1A1FE#; 6000
     N !
 FUNCTION PTA1FE    298.15 +FV1A1FE#**(-1)*P+FV5A1FE#*FV1A1FE#**(-1)*P; 6000
     N !
 FUNCTION IATA1FE   298.15 +3*FV6A1FE#-1; 6000 N !
 FUNCTION FTA1FE    298.15 +1+.666666667*IATA1FE#*PTA1FE#; 6000 N !
 FUNCTION LTFA1FE   298.15 +1*LN(FTA1FE#); 6000 N !
 FUNCTION IXTA1FE   298.15 +1-IATA1FE#**(-1)+IATA1FE#**(-1)*EXP(.5*LTFA1FE#);
      6000 N !
 FUNCTION GPTA1FE   298.15 +4.5*FV6A1FE#*IXTA1FE#**(-2)-3*IXTA1FE#**(-2)
     -9*FV6A1FE#*IXTA1FE#**(-1)+3*IXTA1FE#**(-1)+4.5*FV6A1FE#; 6000 N !
 FUNCTION PT2A1FE   298.15 +FV1A1FE#**(-1)*P+FV7A1FE#*FV1A1FE#**(-1)*P; 6000
     N !
 FUNCTION IYA1FE    298.15 +1+2*FV8A1FE#*PT2A1FE#; 6000 N !
 FUNCTION LYA1FE    298.15 +.5*LN(IYA1FE#); 6000 N !
 FUNCTION YA1FE     298.15 +1*EXP(LYA1FE#); 6000 N !
 FUNCTION IBA1FE    298.15 +FV8A1FE#**(-1)-FV8A1FE#**(-1)*EXP(LYA1FE#); 6000
     N !
 FUNCTION GBPA1FE   298.15 +1+FV8A1FE#-FV8A1FE#*EXP(IBA1FE#)
     -YA1FE#*EXP(IBA1FE#); 6000 N !
 FUNCTION GBMA1FE   298.15 +1+FV8A1FE#; 6000 N !
 FUNCTION GBRA1FE   298.15 +GBMA1FE#**(-1)*GBPA1FE#; 6000 N !
 FUNCTION IGRA1FE   298.15 +FV5A1FE#*FV4A1FE#**(-1)+FV4A1FE#**(-1); 6000 N !
 FUNCTION INTA1FE   298.15 +IGRA1FE#**(-1)*GPTA1FE#; 6000 N !
 FUNCTION TA1FE     298.15 +FV3A1FE#*EXP(INTA1FE#); 6000 N !
 FUNCTION IEA1FE    298.15 +1-1*EXP(-TA1FE#*T**(-1)); 6000 N !
 FUNCTION IE0A1FE   298.15 +1-1*EXP(-FV3A1FE#*T**(-1)); 6000 N !
 FUNCTION GQHA1FE   298.15 +24.9435*T*LN(IEA1FE#)-24.9435*T*LN(IE0A1FE#);
     6000 N !
 FUNCTION C0A1FE    298.15 +1-1*EXP(-.00335401644*FV3A1FE#); 6000 N !
 FUNCTION C20A1FE   298.15
     +1.12494262E-05*FV3A1FE#**2*EXP(-.00335401644*FV3A1FE#); 6000 N !
 FUNCTION CP0A1FE   298.15 +24.9435*C20A1FE#*C0A1FE#**(-2); 6000 N !
 FUNCTION IH0A1FE   298.15 +24.9435*FV3A1FE#*C0A1FE#**(-1); 6000 N !
 FUNCTION H0A1FE    298.15 +IH0A1FE#*EXP(-.00335401644*FV3A1FE#); 6000 N !
 FUNCTION S0A1FE    298.15
     +.00335401644*IH0A1FE#*EXP(-.00335401644*FV3A1FE#)-24.9435*LN(C0A1FE#);
     6000 N !
 FUNCTION GT0A1FE   298.15 +24.9435*T*LN(IE0A1FE#)-H0A1FE#+S0A1FE#*T; 6000 N
     !
 FUNCTION DGTA1FE     1 -.00167700822*CSEA1FE#*T**2
     +.00167700822*CP0A1FE#*T**2; 298.15 Y
      -HSEA1FE#+SSEA1FE#*T+GA1FE#-GT0A1FE#+149.075*CSEA1FE#-149.075*CP0A1FE#
     -CSEA1FE#*T+CP0A1FE#*T; 6000 N !


$ parameters for HCP_A3 Fe
 FUNCTION FV0A3FE   298.15 +6.678E-06; 6000 N !
 FUNCTION FV1A3FE   298.15 +1.8E+11; 6000 N !
 FUNCTION FV2A3FE   298.15 +5; 6000 N !
 FUNCTION FV3A3FE   298.15 +250; 6000 N !
 FUNCTION FV4A3FE   298.15 +2.85; 6000 N !
 FUNCTION FV5A3FE   298.15 +5.5; 6000 N !
 FUNCTION FV6A3FE   298.15 +.7; 6000 N !
 FUNCTION FV7A3FE   298.15 +10; 6000 N !
 FUNCTION FV8A3FE   298.15 +5; 6000 N !

$ implementation of EOS for HCP_A3 Fe
 FUNCTION PA3FE     298.15 +FV1A3FE#**(-1)*P; 6000 N !
 FUNCTION BVA3FE    298.15 +FV0A3FE#*FV1A3FE#; 6000 N !
 FUNCTION IAA3FE    298.15 +FV2A3FE#-.333333333; 6000 N !
 FUNCTION FCA3FE    298.15 +1+1.33333333*IAA3FE#*PA3FE#; 6000 N !
 FUNCTION LFCA3FE   298.15 +1*LN(FCA3FE#); 6000 N !
 FUNCTION IXCA3FE   298.15 +1-IAA3FE#**(-1)+IAA3FE#**(-1)*EXP(.25*LFCA3FE#);
     6000 N !
 FUNCTION G2A3FE    298.15 +1.5*FV2A3FE#**3-6*FV2A3FE#**2+8*FV2A3FE#
     -3.55555555; 6000 N !
 FUNCTION G1A3FE    298.15 -9*FV2A3FE#**3+27*FV2A3FE#**2-24*FV2A3FE#
     +5.33333333; 6000 N !
 FUNCTION GLA3FE    298.15 +9*FV2A3FE#**3-18*FV2A3FE#**2+9*FV2A3FE#
     -1.33333333; 6000 N !
 FUNCTION GM1A3FE   298.15 +3*FV2A3FE#**3-3*FV2A3FE#**2+FV2A3FE#-.111111111;
     6000 N !
 FUNCTION GPCA3FE   298.15 +G2A3FE#*IXCA3FE#**(-2)+G1A3FE#*IXCA3FE#**(-1)
     -GLA3FE#*LN(IXCA3FE#)+GM1A3FE#*IXCA3FE#-G2A3FE#-G1A3FE#-GM1A3FE#; 6000
     N !
 FUNCTION PTA3FE    298.15 +FV1A3FE#**(-1)*P+FV5A3FE#*FV1A3FE#**(-1)*P; 6000
     N !
 FUNCTION IATA3FE   298.15 +3*FV6A3FE#-1; 6000 N !
 FUNCTION FTA3FE    298.15 +1+.666666667*IATA3FE#*PTA3FE#; 6000 N !
 FUNCTION LTFA3FE   298.15 +1*LN(FTA3FE#); 6000 N !
 FUNCTION IXTA3FE   298.15 +1-IATA3FE#**(-1)+IATA3FE#**(-1)*EXP(.5*LTFA3FE#);
      6000 N !
 FUNCTION GPTA3FE   298.15 +4.5*FV6A3FE#*IXTA3FE#**(-2)-3*IXTA3FE#**(-2)
     -9*FV6A3FE#*IXTA3FE#**(-1)+3*IXTA3FE#**(-1)+4.5*FV6A3FE#; 6000 N !
 FUNCTION PT2A3FE   298.15 +FV1A3FE#**(-1)*P+FV7A3FE#*FV1A3FE#**(-1)*P; 6000
     N !
 FUNCTION IYA3FE    298.15 +1+2*FV8A3FE#*PT2A3FE#; 6000 N !
 FUNCTION LYA3FE    298.15 +.5*LN(IYA3FE#); 6000 N !
 FUNCTION YA3FE     298.15 +1*EXP(LYA3FE#); 6000 N !
 FUNCTION IBA3FE    298.15 +FV8A3FE#**(-1)-FV8A3FE#**(-1)*EXP(LYA3FE#); 6000
     N !
 FUNCTION GBPA3FE   298.15 +1+FV8A3FE#-FV8A3FE#*EXP(IBA3FE#)
     -YA3FE#*EXP(IBA3FE#); 6000 N !
 FUNCTION GBMA3FE   298.15 +1+FV8A3FE#; 6000 N !
 FUNCTION GBRA3FE   298.15 +GBMA3FE#**(-1)*GBPA3FE#; 6000 N !
 FUNCTION IGRA3FE   298.15 +FV5A3FE#*FV4A3FE#**(-1)+FV4A3FE#**(-1); 6000 N !
 FUNCTION INTA3FE   298.15 +IGRA3FE#**(-1)*GPTA3FE#; 6000 N !
 FUNCTION TA3FE     298.15 +FV3A3FE#*EXP(INTA3FE#); 6000 N !
 FUNCTION IEA3FE    298.15 +1-1*EXP(-TA3FE#*T**(-1)); 6000 N !
 FUNCTION IE0A3FE   298.15 +1-1*EXP(-FV3A3FE#*T**(-1)); 6000 N !
 FUNCTION GQHA3FE   298.15 +24.9435*T*LN(IEA3FE#)-24.9435*T*LN(IE0A3FE#);
     6000 N !
 FUNCTION C0A3FE    298.15 +1-1*EXP(-.00335401644*FV3A3FE#); 6000 N !
 FUNCTION C20A3FE   298.15
     +1.12494262E-05*FV3A3FE#**2*EXP(-.00335401644*FV3A3FE#); 6000 N !
 FUNCTION CP0A3FE   298.15 +24.9435*C20A3FE#*C0A3FE#**(-2); 6000 N !
 FUNCTION IH0A3FE   298.15 +24.9435*FV3A3FE#*C0A3FE#**(-1); 6000 N !
 FUNCTION H0A3FE    298.15 +IH0A3FE#*EXP(-.00335401644*FV3A3FE#); 6000 N !
 FUNCTION S0A3FE    298.15
     +.00335401644*IH0A3FE#*EXP(-.00335401644*FV3A3FE#)-24.9435*LN(C0A3FE#);
     6000 N !
 FUNCTION GT0A3FE   298.15 +24.9435*T*LN(IE0A3FE#)-H0A3FE#+S0A3FE#*T; 6000 N
     !
 FUNCTION DGTA3FE     1 -.00167700822*CSEA3FE#*T**2
     +.00167700822*CP0A3FE#*T**2; 298.15 Y
      -HSEA3FE#+SSEA3FE#*T+GA3FE#-GT0A3FE#+149.075*CSEA3FE#-149.075*CP0A3FE#
     -CSEA3FE#*T+CP0A3FE#*T; 6000 N !

$ parameters for pure liquid Fe
 FUNCTION FV0L1FE   298.15 +7.084E-06; 6000 N !
 FUNCTION FV1L1FE   298.15 +1.5E+11; 6000 N !
 FUNCTION FV2L1FE   298.15 +5.1; 6000 N !
 FUNCTION FV3L1FE   298.15 +250; 6000 N !
 FUNCTION FV4L1FE   298.15 +2.1; 6000 N !
 FUNCTION FV5L1FE   298.15 +6; 6000 N !
 FUNCTION FV6L1FE   298.15 +1; 6000 N !
 FUNCTION FV7L1FE   298.15 +13; 6000 N !
 FUNCTION FV8L1FE   298.15 +2.3; 6000 N !


$ implementation of EOS for pure liquid Fe
 FUNCTION PL1FE     298.15 +FV1L1FE#**(-1)*P; 6000 N !
 FUNCTION BVL1FE    298.15 +FV0L1FE#*FV1L1FE#; 6000 N !
 FUNCTION IAL1FE    298.15 +FV2L1FE#-.333333333; 6000 N !
 FUNCTION FCL1FE    298.15 +1+1.33333333*IAL1FE#*PL1FE#; 6000 N !
 FUNCTION LFCL1FE   298.15 +1*LN(FCL1FE#); 6000 N !
 FUNCTION IXCL1FE   298.15 +1-IAL1FE#**(-1)+IAL1FE#**(-1)*EXP(.25*LFCL1FE#);
     6000 N !
 FUNCTION G2L1FE    298.15 +1.5*FV2L1FE#**3-6*FV2L1FE#**2+8*FV2L1FE#
     -3.55555555; 6000 N !
 FUNCTION G1L1FE    298.15 -9*FV2L1FE#**3+27*FV2L1FE#**2-24*FV2L1FE#
     +5.33333333; 6000 N !
 FUNCTION GLL1FE    298.15 +9*FV2L1FE#**3-18*FV2L1FE#**2+9*FV2L1FE#
     -1.33333333; 6000 N !
 FUNCTION GM1L1FE   298.15 +3*FV2L1FE#**3-3*FV2L1FE#**2+FV2L1FE#-.111111111;
     6000 N !
 FUNCTION GPCL1FE   298.15 +G2L1FE#*IXCL1FE#**(-2)+G1L1FE#*IXCL1FE#**(-1)
     -GLL1FE#*LN(IXCL1FE#)+GM1L1FE#*IXCL1FE#-G2L1FE#-G1L1FE#-GM1L1FE#; 6000
     N !
 FUNCTION PTL1FE    298.15 +FV1L1FE#**(-1)*P+FV5L1FE#*FV1L1FE#**(-1)*P; 6000
     N !
 FUNCTION IATL1FE   298.15 +3*FV6L1FE#-1; 6000 N !
 FUNCTION FTL1FE    298.15 +1+.666666667*IATL1FE#*PTL1FE#; 6000 N !
 FUNCTION LTFL1FE   298.15 +1*LN(FTL1FE#); 6000 N !
 FUNCTION IXTL1FE   298.15 +1-IATL1FE#**(-1)+IATL1FE#**(-1)*EXP(.5*LTFL1FE#);
      6000 N !
 FUNCTION GPTL1FE   298.15 +4.5*FV6L1FE#*IXTL1FE#**(-2)-3*IXTL1FE#**(-2)
     -9*FV6L1FE#*IXTL1FE#**(-1)+3*IXTL1FE#**(-1)+4.5*FV6L1FE#; 6000 N !
 FUNCTION PT2L1FE   298.15 +FV1L1FE#**(-1)*P+FV7L1FE#*FV1L1FE#**(-1)*P; 6000
     N !
 FUNCTION IYL1FE    298.15 +1+2*FV8L1FE#*PT2L1FE#; 6000 N !
 FUNCTION LYL1FE    298.15 +.5*LN(IYL1FE#); 6000 N !
 FUNCTION YL1FE     298.15 +1*EXP(LYL1FE#); 6000 N !
 FUNCTION IBL1FE    298.15 +FV8L1FE#**(-1)-FV8L1FE#**(-1)*EXP(LYL1FE#); 6000
     N !
 FUNCTION GBPL1FE   298.15 +1+FV8L1FE#-FV8L1FE#*EXP(IBL1FE#)
     -YL1FE#*EXP(IBL1FE#); 6000 N !
 FUNCTION GBML1FE   298.15 +1+FV8L1FE#; 6000 N !
 FUNCTION GBRL1FE   298.15 +GBML1FE#**(-1)*GBPL1FE#; 6000 N !
 FUNCTION IGRL1FE   298.15 +FV5L1FE#*FV4L1FE#**(-1)+FV4L1FE#**(-1); 6000 N !
 FUNCTION INTL1FE   298.15 +IGRL1FE#**(-1)*GPTL1FE#; 6000 N !
 FUNCTION TL1FE     298.15 +FV3L1FE#*EXP(INTL1FE#); 6000 N !
 FUNCTION IEL1FE    298.15 +1-1*EXP(-TL1FE#*T**(-1)); 6000 N !
 FUNCTION IE0L1FE   298.15 +1-1*EXP(-FV3L1FE#*T**(-1)); 6000 N !
 FUNCTION GQHL1FE   298.15 +24.9435*T*LN(IEL1FE#)-24.9435*T*LN(IE0L1FE#);
     6000 N !
 FUNCTION C0L1FE    298.15 +1-1*EXP(-.00335401644*FV3L1FE#); 6000 N !
 FUNCTION C20L1FE   298.15
     +1.12494262E-05*FV3L1FE#**2*EXP(-.00335401644*FV3L1FE#); 6000 N !
 FUNCTION CP0L1FE   298.15 +24.9435*C20L1FE#*C0L1FE#**(-2); 6000 N !
 FUNCTION IH0L1FE   298.15 +24.9435*FV3L1FE#*C0L1FE#**(-1); 6000 N !
 FUNCTION H0L1FE    298.15 +IH0L1FE#*EXP(-.00335401644*FV3L1FE#); 6000 N !
 FUNCTION S0L1FE    298.15
     +.00335401644*IH0L1FE#*EXP(-.00335401644*FV3L1FE#)-24.9435*LN(C0L1FE#);
     6000 N !
 FUNCTION GT0L1FE   298.15 +24.9435*T*LN(IE0L1FE#)-H0L1FE#+S0L1FE#*T; 6000 N
     !
 FUNCTION DGTL1FE     1 -.00167700822*CSEL1FE#*T**2
     +.00167700822*CP0L1FE#*T**2; 298.15 Y
      -HSEL1FE#+SSEL1FE#*T+GL1FE#-GT0L1FE#+149.075*CSEL1FE#-149.075*CP0L1FE#
     -CSEL1FE#*T+CP0L1FE#*T; 6000 N !

$ parameters for Graphite
 FUNCTION FV0A9C    298.15 +5.273E-06; 6000 N !
 FUNCTION FV1A9C    298.15 +3.38E+10; 6000 N !
 FUNCTION FV2A9C    298.15 +8.9; 6000 N !
 FUNCTION FV3A9C1   298.15 +520; 6000 N !
 FUNCTION FV4A9C1   298.15 +.7; 6000 N !
 FUNCTION FV3A9C2   298.15 +1677; 6000 N !
 FUNCTION FV4A9C2   298.15 +.01; 6000 N !
 FUNCTION FV5A9C    298.15 +5; 6000 N !
 FUNCTION FV6A9C    298.15 +1; 6000 N !
 FUNCTION FV7A9C    298.15 +5; 6000 N !
 FUNCTION FV8A9C    298.15 +10; 6000 N !

$ implementation of EOS for graphite
 FUNCTION PA9C      298.15 +FV1A9C#**(-1)*P; 6000 N !
 FUNCTION BVA9C     298.15 +FV0A9C#*FV1A9C#; 6000 N !
 FUNCTION IAA9C     298.15 +FV2A9C#-.333333333; 6000 N !
 FUNCTION FCA9C     298.15 +1+1.33333333*IAA9C#*PA9C#; 6000 N !
 FUNCTION LFCA9C    298.15 +1*LN(FCA9C#); 6000 N !
 FUNCTION IXCA9C    298.15 +1-IAA9C#**(-1)+IAA9C#**(-1)*EXP(.25*LFCA9C#);
     6000 N !
 FUNCTION G2A9C     298.15 +1.5*FV2A9C#**3-6*FV2A9C#**2+8*FV2A9C#-3.55555555;
      6000 N !
 FUNCTION G1A9C     298.15 -9*FV2A9C#**3+27*FV2A9C#**2-24*FV2A9C#+5.33333333;
      6000 N !
 FUNCTION GLA9C     298.15 +9*FV2A9C#**3-18*FV2A9C#**2+9*FV2A9C#-1.33333333;
     6000 N !
 FUNCTION GM1A9C    298.15 +3*FV2A9C#**3-3*FV2A9C#**2+FV2A9C#-.111111111;
     6000 N !
 FUNCTION GPCA9C    298.15 +G2A9C#*IXCA9C#**(-2)+G1A9C#*IXCA9C#**(-1)
     -GLA9C#*LN(IXCA9C#)+GM1A9C#*IXCA9C#-G2A9C#-G1A9C#-GM1A9C#; 6000 N !
 FUNCTION PTA9C     298.15 +FV1A9C#**(-1)*P+FV5A9C#*FV1A9C#**(-1)*P; 6000 N !
 FUNCTION IATA9C    298.15 +3*FV6A9C#-1; 6000 N !
 FUNCTION FTA9C     298.15 +1+.666666667*IATA9C#*PTA9C#; 6000 N !
 FUNCTION LTFA9C    298.15 +1*LN(FTA9C#); 6000 N !
 FUNCTION IXTA9C    298.15 +1-IATA9C#**(-1)+IATA9C#**(-1)*EXP(.5*LTFA9C#);
     6000 N !
 FUNCTION GPTA9C    298.15 +4.5*FV6A9C#*IXTA9C#**(-2)-3*IXTA9C#**(-2)
     -9*FV6A9C#*IXTA9C#**(-1)+3*IXTA9C#**(-1)+4.5*FV6A9C#; 6000 N !
 FUNCTION PT2A9C    298.15 +FV1A9C#**(-1)*P+FV7A9C#*FV1A9C#**(-1)*P; 6000 N !
 FUNCTION IYA9C     298.15 +1+2*FV8A9C#*PT2A9C#; 6000 N !
 FUNCTION LYA9C     298.15 +.5*LN(IYA9C#); 6000 N !
 FUNCTION YA9C      298.15 +1*EXP(LYA9C#); 6000 N !
 FUNCTION IBA9C     298.15 +FV8A9C#**(-1)-FV8A9C#**(-1)*EXP(LYA9C#); 6000 N !
 FUNCTION GBPA9C    298.15 +1+FV8A9C#-FV8A9C#*EXP(IBA9C#)-YA9C#*EXP(IBA9C#);
     6000 N !
 FUNCTION GBMA9C    298.15 +1+FV8A9C#; 6000 N !
 FUNCTION GBRA9C    298.15 +GBMA9C#**(-1)*GBPA9C#; 6000 N !
 FUNCTION IGRA9C1   298.15 +FV5A9C#*FV4A9C1#**(-1)+FV4A9C1#**(-1); 6000 N !
 FUNCTION INTA9C1   298.15 +IGRA9C1#**(-1)*GPTA9C#; 6000 N !
 FUNCTION TA9C1     298.15 +FV3A9C1#*EXP(INTA9C1#); 6000 N !
 FUNCTION IEA9C1    298.15 +1-1*EXP(-TA9C1#*T**(-1)); 6000 N !
 FUNCTION IE0A9C1   298.15 +1-1*EXP(-FV3A9C1#*T**(-1)); 6000 N !
 FUNCTION IGRA9C2   298.15 +FV5A9C#*FV4A9C2#**(-1)+FV4A9C2#**(-1); 6000 N !
 FUNCTION INTA9C2   298.15 +IGRA9C2#**(-1)*GPTA9C#; 6000 N !
 FUNCTION TA9C2     298.15 +FV3A9C2#*EXP(INTA9C2#); 6000 N !
 FUNCTION IEA9C2    298.15 +1-1*EXP(-TA9C2#*T**(-1)); 6000 N !
 FUNCTION IE0A9C2   298.15 +1-1*EXP(-FV3A9C2#*T**(-1)); 6000 N !
 FUNCTION HSEA9C    298.15 -1049.14084; 6000 N !
 FUNCTION SSEA9C    298.15 +.09009204; 6000 N !
 FUNCTION DGTA9C    298.15 -HSEA9C#+SSEA9C#*T+GHSERCC#-2*R#*T*LN(IE0A9C2#)
     -R#*T*LN(IE0A9C1#); 6000 N !


$ parameters for diamond
 FUNCTION FV0A4C    298.15 +3.4145E-06; 6000 N !
 FUNCTION FV1A4C    298.15 +4.47E+11; 6000 N !
 FUNCTION FV2A4C    298.15 +3.5; 6000 N !
 FUNCTION FV3A4C    298.15 +1650; 6000 N !
 FUNCTION FV4A4C    298.15 +.93; 6000 N !
 FUNCTION FV5A4C    298.15 +5; 6000 N !
 FUNCTION FV6A4C    298.15 +1; 6000 N !
 FUNCTION FV7A4C    298.15 +5; 6000 N !
 FUNCTION FV8A4C    298.15 +10; 6000 N !

$ impplementation of EOS for diamond
 FUNCTION PA4C      298.15 +FV1A4C#**(-1)*P; 6000 N !
 FUNCTION BVA4C     298.15 +FV0A4C#*FV1A4C#; 6000 N !
 FUNCTION IAA4C     298.15 +FV2A4C#-.333333333; 6000 N !
 FUNCTION FCA4C     298.15 +1+1.33333333*IAA4C#*PA4C#; 6000 N !
 FUNCTION LFCA4C    298.15 +1*LN(FCA4C#); 6000 N !
 FUNCTION IXCA4C    298.15 +1-IAA4C#**(-1)+IAA4C#**(-1)*EXP(.25*LFCA4C#);
     6000 N !
 FUNCTION G2A4C     298.15 +1.5*FV2A4C#**3-6*FV2A4C#**2+8*FV2A4C#-3.55555555;
      6000 N !
 FUNCTION G1A4C     298.15 -9*FV2A4C#**3+27*FV2A4C#**2-24*FV2A4C#+5.33333333;
      6000 N !
 FUNCTION GLA4C     298.15 +9*FV2A4C#**3-18*FV2A4C#**2+9*FV2A4C#-1.33333333;
     6000 N !
 FUNCTION GM1A4C    298.15 +3*FV2A4C#**3-3*FV2A4C#**2+FV2A4C#-.111111111;
     6000 N !
 FUNCTION GPCA4C    298.15 +G2A4C#*IXCA4C#**(-2)+G1A4C#*IXCA4C#**(-1)
     -GLA4C#*LN(IXCA4C#)+GM1A4C#*IXCA4C#-G2A4C#-G1A4C#-GM1A4C#; 6000 N !
 FUNCTION PTA4C     298.15 +FV1A4C#**(-1)*P+FV5A4C#*FV1A4C#**(-1)*P; 6000 N !
 FUNCTION IATA4C    298.15 +3*FV6A4C#-1; 6000 N !
 FUNCTION FTA4C     298.15 +1+.666666667*IATA4C#*PTA4C#; 6000 N !
 FUNCTION LTFA4C    298.15 +1*LN(FTA4C#); 6000 N !
 FUNCTION IXTA4C    298.15 +1-IATA4C#**(-1)+IATA4C#**(-1)*EXP(.5*LTFA4C#);
     6000 N !
 FUNCTION GPTA4C    298.15 +4.5*FV6A4C#*IXTA4C#**(-2)-3*IXTA4C#**(-2)
     -9*FV6A4C#*IXTA4C#**(-1)+3*IXTA4C#**(-1)+4.5*FV6A4C#; 6000 N !
 FUNCTION PT2A4C    298.15 +FV1A4C#**(-1)*P+FV7A4C#*FV1A4C#**(-1)*P; 6000 N !
 FUNCTION IYA4C     298.15 +1+2*FV8A4C#*PT2A4C#; 6000 N !
 FUNCTION LYA4C     298.15 +.5*LN(IYA4C#); 6000 N !
 FUNCTION YA4C      298.15 +1*EXP(LYA4C#); 6000 N !
 FUNCTION IBA4C     298.15 +FV8A4C#**(-1)-FV8A4C#**(-1)*EXP(LYA4C#); 6000 N !
 FUNCTION GBPA4C    298.15 +1+FV8A4C#-FV8A4C#*EXP(IBA4C#)-YA4C#*EXP(IBA4C#);
     6000 N !
 FUNCTION GBMA4C    298.15 +1+FV8A4C#; 6000 N !
 FUNCTION GBRA4C    298.15 +GBMA4C#**(-1)*GBPA4C#; 6000 N !
 FUNCTION IGRA4C    298.15 +FV5A4C#*FV4A4C#**(-1)+FV4A4C#**(-1); 6000 N !
 FUNCTION INTA4C    298.15 +IGRA4C#**(-1)*GPTA4C#; 6000 N !
 FUNCTION TA4C      298.15 +FV3A4C#*EXP(INTA4C#); 6000 N !
 FUNCTION IEA4C     298.15 +1-1*EXP(-TA4C#*T**(-1)); 6000 N !
 FUNCTION IE0A4C    298.15 +1-1*EXP(-FV3A4C#*T**(-1)); 6000 N !
 FUNCTION HSEA4C    298.15 +1366.36944; 6000 N !
 FUNCTION SSEA4C    298.15 -.0375684493; 6000 N !
 FUNCTION DGTA4C    298.15 -HSEA4C#+SSEA4C#*T+GA4C#-3*R#*T*LN(IE0A4C#); 6000 N !

$ parameters for liquid carbon - high pressure part of EOS
 FUNCTION FV0L1C    298.15 +3.8E-06; 6000 N !
 FUNCTION FV1L1C    298.15 +3E+11; 6000 N !
 FUNCTION FV2L1C    298.15 +4; 6000 N !
 FUNCTION FV3L1C    298.15 +1350; 6000 N !
 FUNCTION FV4L1C    298.15 +1; 6000 N !
 FUNCTION FV5L1C    298.15 +5; 6000 N !
 FUNCTION FV6L1C    298.15 +1; 6000 N !
 FUNCTION FV7L1C    298.15 +5; 6000 N !
 FUNCTION FV8L1C    298.15 +5; 6000 N !

$ implementation of EOS for liquid carbon - high pressure part
 FUNCTION PL1C      298.15 +FV1L1C#**(-1)*P; 6000 N !
 FUNCTION BVL1C     298.15 +FV0L1C#*FV1L1C#; 6000 N !
 FUNCTION IAL1C     298.15 +FV2L1C#-.333333333; 6000 N !
 FUNCTION FCL1C     298.15 +1+1.33333333*IAL1C#*PL1C#; 6000 N !
 FUNCTION LFCL1C    298.15 +1*LN(FCL1C#); 6000 N !
 FUNCTION IXCL1C    298.15 +1-IAL1C#**(-1)+IAL1C#**(-1)*EXP(.25*LFCL1C#);
     6000 N !
 FUNCTION G2L1C     298.15 +1.5*FV2L1C#**3-6*FV2L1C#**2+8*FV2L1C#-3.55555555;
      6000 N !
 FUNCTION G1L1C     298.15 -9*FV2L1C#**3+27*FV2L1C#**2-24*FV2L1C#+5.33333333;
      6000 N !
 FUNCTION GLL1C     298.15 +9*FV2L1C#**3-18*FV2L1C#**2+9*FV2L1C#-1.33333333;
     6000 N !
 FUNCTION GM1L1C    298.15 +3*FV2L1C#**3-3*FV2L1C#**2+FV2L1C#-.111111111;
     6000 N !
 FUNCTION GPCL1C    298.15 +G2L1C#*IXCL1C#**(-2)+G1L1C#*IXCL1C#**(-1)
     -GLL1C#*LN(IXCL1C#)+GM1L1C#*IXCL1C#-G2L1C#-G1L1C#-GM1L1C#; 6000 N !
 FUNCTION PTL1C     298.15 +FV1L1C#**(-1)*P+FV5L1C#*FV1L1C#**(-1)*P; 6000 N !
 FUNCTION IATL1C    298.15 +3*FV6L1C#-1; 6000 N !
 FUNCTION FTL1C     298.15 +1+.666666667*IATL1C#*PTL1C#; 6000 N !
 FUNCTION LTFL1C    298.15 +1*LN(FTL1C#); 6000 N !
 FUNCTION IXTL1C    298.15 +1-IATL1C#**(-1)+IATL1C#**(-1)*EXP(.5*LTFL1C#);
     6000 N !
 FUNCTION GPTL1C    298.15 +4.5*FV6L1C#*IXTL1C#**(-2)-3*IXTL1C#**(-2)
     -9*FV6L1C#*IXTL1C#**(-1)+3*IXTL1C#**(-1)+4.5*FV6L1C#; 6000 N !
 FUNCTION PT2L1C    298.15 +FV1L1C#**(-1)*P+FV7L1C#*FV1L1C#**(-1)*P; 6000 N !
 FUNCTION IYL1C     298.15 +1+2*FV8L1C#*PT2L1C#; 6000 N !
 FUNCTION LYL1C     298.15 +.5*LN(IYL1C#); 6000 N !
 FUNCTION YL1C      298.15 +1*EXP(LYL1C#); 6000 N !
 FUNCTION IBL1C     298.15 +FV8L1C#**(-1)-FV8L1C#**(-1)*EXP(LYL1C#); 6000 N !
 FUNCTION GBPL1C    298.15 +1+FV8L1C#-FV8L1C#*EXP(IBL1C#)-YL1C#*EXP(IBL1C#);
     6000 N !
 FUNCTION GBML1C    298.15 +1+FV8L1C#; 6000 N !
 FUNCTION GBRL1C    298.15 +GBML1C#**(-1)*GBPL1C#; 6000 N !
 FUNCTION IGRL1C    298.15 +FV5L1C#*FV4L1C#**(-1)+FV4L1C#**(-1); 6000 N !
 FUNCTION INTL1C    298.15 +IGRL1C#**(-1)*GPTL1C#; 6000 N !
 FUNCTION TL1C      298.15 +FV3L1C#*EXP(INTL1C#); 6000 N !
 FUNCTION IEL1C     298.15 +1-1*EXP(-TL1C#*T**(-1)); 6000 N !
 FUNCTION IE0L1C    298.15 +1-1*EXP(-FV3L1C#*T**(-1)); 6000 N !
 FUNCTION GQHL1C    298.15 +3*R#*T*LN(IEL1C#)-3*R#*T*LN(IE0L1C#); 6000 N !
 FUNCTION DGTL1C    298.15 -HSEA9C#+SSEA9C#*T+GHSERCC#-3*R#*T*LN(IE0L1C#);
     6000 N !

$ Parameters for liquid C - low pressure compressible addition
 FUNCTION FV0L2C    298.15 +3.6E-06; 6000 N !
 FUNCTION FV1L2C    298.15 +4E+09; 6000 N !
 FUNCTION FV2L2C    298.15 +.1; 6000 N !
 FUNCTION FV3L2C    298.15 +6.5E-05; 6000 N !
 FUNCTION FV4L2C    298.15 +500; 6000 N !

$ EOS of liquid C - low pressure compressible addition
 FUNCTION PL2C      298.15 +FV1L2C#**(-1)*P; 6000 N !
 FUNCTION BVL2C     298.15 +FV0L2C#*FV1L2C#; 6000 N !
 FUNCTION IBPL2C    298.15 +FV2L2C#-1; 6000 N !
 FUNCTION AL2C      298.15 +FV2L2C#*FV3L2C#; 6000 N !
 FUNCTION ITL2C     298.15 +1+FV4L2C#**(-1)*T; 6000 N !
 FUNCTION LTL2C     298.15 +FV4L2C#*LN(ITL2C#); 6000 N !
 FUNCTION ATL2C     298.15 +AL2C#*T-AL2C#*LTL2C#; 6000 N !
 FUNCTION FL2C      298.15 +1*EXP(-ATL2C#)+FV2L2C#*PL2C#; 6000 N !
 FUNCTION LFL2C     298.15 +1*LN(FL2C#)-FV2L2C#**(-1)*LN(FL2C#); 6000 N !
 FUNCTION LF0L2C    298.15 -ATL2C#+FV2L2C#**(-1)*ATL2C#; 6000 N !
 FUNCTION GPCL2C    298.15 +IBPL2C#**(-1)*EXP(LFL2C#)
     -IBPL2C#**(-1)*EXP(LF0L2C#); 6000 N !

$ parameters for C in Fe:C end-member in FCC_A1 solution
 FUNCTION FV0A1C    298.15 +3.5E-06; 6000 N !
 FUNCTION FV1A1C    298.15 +2E+11; 6000 N !
 FUNCTION FV2A1C    298.15 +9; 6000 N !
 FUNCTION FV3A1C    298.15 +1350; 6000 N !
 FUNCTION FV4A1C    298.15 +2; 6000 N !
 FUNCTION FV5A1C    298.15 +5; 6000 N !
 FUNCTION FV6A1C    298.15 +1; 6000 N !
 FUNCTION FV7A1C    298.15 +10; 6000 N !
 FUNCTION FV8A1C    298.15 +1; 6000 N !

$ EOS for C in Fe:C end-member in FCC_A1 solution
 FUNCTION PA1C      298.15 +FV1A1C#**(-1)*P; 6000 N !
 FUNCTION BVA1C     298.15 +FV0A1C#*FV1A1C#; 6000 N !
 FUNCTION IAA1C     298.15 +FV2A1C#-.333333333; 6000 N !
 FUNCTION FCA1C     298.15 +1+1.33333333*IAA1C#*PA1C#; 6000 N !
 FUNCTION LFCA1C    298.15 +1*LN(FCA1C#); 6000 N !
 FUNCTION IXCA1C    298.15 +1-IAA1C#**(-1)+IAA1C#**(-1)*EXP(.25*LFCA1C#);
     6000 N !
 FUNCTION G2A1C     298.15 +1.5*FV2A1C#**3-6*FV2A1C#**2+8*FV2A1C#-3.55555555;
      6000 N !
 FUNCTION G1A1C     298.15 -9*FV2A1C#**3+27*FV2A1C#**2-24*FV2A1C#+5.33333333;
      6000 N !
 FUNCTION GLA1C     298.15 +9*FV2A1C#**3-18*FV2A1C#**2+9*FV2A1C#-1.33333333;
     6000 N !
 FUNCTION GM1A1C    298.15 +3*FV2A1C#**3-3*FV2A1C#**2+FV2A1C#-.111111111;
     6000 N !
 FUNCTION GPCA1C    298.15 +G2A1C#*IXCA1C#**(-2)+G1A1C#*IXCA1C#**(-1)
     -GLA1C#*LN(IXCA1C#)+GM1A1C#*IXCA1C#-G2A1C#-G1A1C#-GM1A1C#; 6000 N !
 FUNCTION PTA1C     298.15 +FV1A1C#**(-1)*P+FV5A1C#*FV1A1C#**(-1)*P; 6000 N !
 FUNCTION IATA1C    298.15 +3*FV6A1C#-1; 6000 N !
 FUNCTION FTA1C     298.15 +1+.666666667*IATA1C#*PTA1C#; 6000 N !
 FUNCTION LTFA1C    298.15 +1*LN(FTA1C#); 6000 N !
 FUNCTION IXTA1C    298.15 +1-IATA1C#**(-1)+IATA1C#**(-1)*EXP(.5*LTFA1C#);
     6000 N !
 FUNCTION GPTA1C    298.15 +4.5*FV6A1C#*IXTA1C#**(-2)-3*IXTA1C#**(-2)
     -9*FV6A1C#*IXTA1C#**(-1)+3*IXTA1C#**(-1)+4.5*FV6A1C#; 6000 N !
 FUNCTION PT2A1C    298.15 +FV1A1C#**(-1)*P+FV7A1C#*FV1A1C#**(-1)*P; 6000 N !
 FUNCTION IYA1C     298.15 +1+2*FV8A1C#*PT2A1C#; 6000 N !
 FUNCTION LYA1C     298.15 +.5*LN(IYA1C#); 6000 N !
 FUNCTION YA1C      298.15 +1*EXP(LYA1C#); 6000 N !
 FUNCTION IBA1C     298.15 +FV8A1C#**(-1)-FV8A1C#**(-1)*EXP(LYA1C#); 6000 N !
 FUNCTION GBPA1C    298.15 +1+FV8A1C#-FV8A1C#*EXP(IBA1C#)-YA1C#*EXP(IBA1C#);
     6000 N !
 FUNCTION GBMA1C    298.15 +1+FV8A1C#; 6000 N !
 FUNCTION GBRA1C    298.15 +GBMA1C#**(-1)*GBPA1C#; 6000 N !
 FUNCTION IGRA1C    298.15 +FV5A1C#*FV4A1C#**(-1)+FV4A1C#**(-1); 6000 N !
 FUNCTION INTA1C    298.15 +IGRA1C#**(-1)*GPTA1C#; 6000 N !
 FUNCTION TA1C      298.15 +FV3A1C#*EXP(INTA1C#); 6000 N !
 FUNCTION IEA1C     298.15 +1-1*EXP(-TA1C#*T**(-1)); 6000 N !
 FUNCTION IE0A1C    298.15 +1-1*EXP(-FV3A1C#*T**(-1)); 6000 N !
 FUNCTION GQHA1C    298.15 +3*R#*T*LN(IEA1C#)-3*R#*T*LN(IE0A1C#); 6000 N !
 FUNCTION DGTA1C    298.15 -HSEA9C#+SSEA9C#*T+GHSERCC#-3*R#*T*LN(IE0A1C#);
     6000 N !
 FUNCTION IGPA1FC   298.15 +BVA1FE#*GPCA1FE#+BVA1C#*GPCA1C#
     -DGTA1FE#*GBRA1FE#-DGTA1C#*GBRA1C#; 6000 N !


$ parameters for C in Fe:C end-member in BCC_A2 solution
 FUNCTION FV0A2C    298.15 +3.7E-06; 6000 N !
 FUNCTION FV1A2C    298.15 +2E+11; 6000 N !
 FUNCTION FV2A2C    298.15 +9; 6000 N !
 FUNCTION FV3A2C    298.15 +1350; 6000 N !
 FUNCTION FV4A2C    298.15 +2; 6000 N !
 FUNCTION FV5A2C    298.15 +5; 6000 N !
 FUNCTION FV6A2C    298.15 +1; 6000 N !
 FUNCTION FV7A2C    298.15 +10; 6000 N !
 FUNCTION FV8A2C    298.15 +1; 6000 N !

$ EOS for for C in Fe:C end-member in BCC_A2 solution
 FUNCTION PA2C      298.15 +FV1A2C#**(-1)*P; 6000 N !
 FUNCTION BVA2C     298.15 +FV0A2C#*FV1A2C#; 6000 N !
 FUNCTION IAA2C     298.15 +FV2A2C#-.333333333; 6000 N !
 FUNCTION FCA2C     298.15 +1+1.33333333*IAA2C#*PA2C#; 6000 N !
 FUNCTION LFCA2C    298.15 +1*LN(FCA2C#); 6000 N !
 FUNCTION IXCA2C    298.15 +1-IAA2C#**(-1)+IAA2C#**(-1)*EXP(.25*LFCA2C#);
     6000 N !
 FUNCTION G2A2C     298.15 +1.5*FV2A2C#**3-6*FV2A2C#**2+8*FV2A2C#-3.55555555;
      6000 N !
 FUNCTION G1A2C     298.15 -9*FV2A2C#**3+27*FV2A2C#**2-24*FV2A2C#+5.33333333;
      6000 N !
 FUNCTION GLA2C     298.15 +9*FV2A2C#**3-18*FV2A2C#**2+9*FV2A2C#-1.33333333;
     6000 N !
 FUNCTION GM1A2C    298.15 +3*FV2A2C#**3-3*FV2A2C#**2+FV2A2C#-.111111111;
     6000 N !
 FUNCTION GPCA2C    298.15 +G2A2C#*IXCA2C#**(-2)+G1A2C#*IXCA2C#**(-1)
     -GLA2C#*LN(IXCA2C#)+GM1A2C#*IXCA2C#-G2A2C#-G1A2C#-GM1A2C#; 6000 N !
 FUNCTION PTA2C     298.15 +FV1A2C#**(-1)*P+FV5A2C#*FV1A2C#**(-1)*P; 6000 N !
 FUNCTION IATA2C    298.15 +3*FV6A2C#-1; 6000 N !
 FUNCTION FTA2C     298.15 +1+.666666667*IATA2C#*PTA2C#; 6000 N !
 FUNCTION LTFA2C    298.15 +1*LN(FTA2C#); 6000 N !
 FUNCTION IXTA2C    298.15 +1-IATA2C#**(-1)+IATA2C#**(-1)*EXP(.5*LTFA2C#);
     6000 N !
 FUNCTION GPTA2C    298.15 +4.5*FV6A2C#*IXTA2C#**(-2)-3*IXTA2C#**(-2)
     -9*FV6A2C#*IXTA2C#**(-1)+3*IXTA2C#**(-1)+4.5*FV6A2C#; 6000 N !
 FUNCTION PT2A2C    298.15 +FV1A2C#**(-1)*P+FV7A2C#*FV1A2C#**(-1)*P; 6000 N !
 FUNCTION IYA2C     298.15 +1+2*FV8A2C#*PT2A2C#; 6000 N !
 FUNCTION LYA2C     298.15 +.5*LN(IYA2C#); 6000 N !
 FUNCTION YA2C      298.15 +1*EXP(LYA2C#); 6000 N !
 FUNCTION IBA2C     298.15 +FV8A2C#**(-1)-FV8A2C#**(-1)*EXP(LYA2C#); 6000 N !
 FUNCTION GBPA2C    298.15 +1+FV8A2C#-FV8A2C#*EXP(IBA2C#)-YA2C#*EXP(IBA2C#);
     6000 N !
 FUNCTION GBMA2C    298.15 +1+FV8A2C#; 6000 N !
 FUNCTION GBRA2C    298.15 +GBMA2C#**(-1)*GBPA2C#; 6000 N !
 FUNCTION IGRA2C    298.15 +FV5A2C#*FV4A2C#**(-1)+FV4A2C#**(-1); 6000 N !
 FUNCTION INTA2C    298.15 +IGRA2C#**(-1)*GPTA2C#; 6000 N !
 FUNCTION TA2C      298.15 +FV3A2C#*EXP(INTA2C#); 6000 N !
 FUNCTION IEA2C     298.15 +1-1*EXP(-TA2C#*T**(-1)); 6000 N !
 FUNCTION IE0A2C    298.15 +1-1*EXP(-FV3A2C#*T**(-1)); 6000 N !
 FUNCTION GQHA2C    298.15 +3*R#*T*LN(IEA2C#)-3*R#*T*LN(IE0A2C#); 6000 N !
 FUNCTION DGTA2C    298.15 -HSEA9C#+SSEA9C#*T+GHSERCC#-3*R#*T*LN(IE0A2C#);
     6000 N !
 FUNCTION IGPA2FC   298.15 +BVA2FE#*GPCA2FE#+3*BVA2C#*GPCA2C#
     -DGTA2FE#*GBRA2FE#-3*DGTA2C#*GBRA2C#; 6000 N !

$ parameters for C in Fe:C end-member in HCP_A3 solution
 FUNCTION FV0A3C    298.15 +3.5E-06; 6000 N !
 FUNCTION FV1A3C    298.15 +2E+11; 6000 N !
 FUNCTION FV2A3C    298.15 +9; 6000 N !
 FUNCTION FV3A3C    298.15 +1350; 6000 N !
 FUNCTION FV4A3C    298.15 +2; 6000 N !
 FUNCTION FV5A3C    298.15 +5; 6000 N !
 FUNCTION FV6A3C    298.15 +1; 6000 N !
 FUNCTION FV7A3C    298.15 +10; 6000 N !
 FUNCTION FV8A3C    298.15 +1; 6000 N !

$ EOS for C in Fe:C end-member in HCP_A3 solution
 FUNCTION PA3C      298.15 +FV1A3C#**(-1)*P; 6000 N !
 FUNCTION BVA3C     298.15 +FV0A3C#*FV1A3C#; 6000 N !
 FUNCTION IAA3C     298.15 +FV2A3C#-.333333333; 6000 N !
 FUNCTION FCA3C     298.15 +1+1.33333333*IAA3C#*PA3C#; 6000 N !
 FUNCTION LFCA3C    298.15 +1*LN(FCA3C#); 6000 N !
 FUNCTION IXCA3C    298.15 +1-IAA3C#**(-1)+IAA3C#**(-1)*EXP(.25*LFCA3C#);
     6000 N !
 FUNCTION G2A3C     298.15 +1.5*FV2A3C#**3-6*FV2A3C#**2+8*FV2A3C#-3.55555555;
      6000 N !
 FUNCTION G1A3C     298.15 -9*FV2A3C#**3+27*FV2A3C#**2-24*FV2A3C#+5.33333333;
      6000 N !
 FUNCTION GLA3C     298.15 +9*FV2A3C#**3-18*FV2A3C#**2+9*FV2A3C#-1.33333333;
     6000 N !
 FUNCTION GM1A3C    298.15 +3*FV2A3C#**3-3*FV2A3C#**2+FV2A3C#-.111111111;
     6000 N !
 FUNCTION GPCA3C    298.15 +G2A3C#*IXCA3C#**(-2)+G1A3C#*IXCA3C#**(-1)
     -GLA3C#*LN(IXCA3C#)+GM1A3C#*IXCA3C#-G2A3C#-G1A3C#-GM1A3C#; 6000 N !
 FUNCTION PTA3C     298.15 +FV1A3C#**(-1)*P+FV5A3C#*FV1A3C#**(-1)*P; 6000 N !
 FUNCTION IATA3C    298.15 +3*FV6A3C#-1; 6000 N !
 FUNCTION FTA3C     298.15 +1+.666666667*IATA3C#*PTA3C#; 6000 N !
 FUNCTION LTFA3C    298.15 +1*LN(FTA3C#); 6000 N !
 FUNCTION IXTA3C    298.15 +1-IATA3C#**(-1)+IATA3C#**(-1)*EXP(.5*LTFA3C#);
     6000 N !
 FUNCTION GPTA3C    298.15 +4.5*FV6A3C#*IXTA3C#**(-2)-3*IXTA3C#**(-2)
     -9*FV6A3C#*IXTA3C#**(-1)+3*IXTA3C#**(-1)+4.5*FV6A3C#; 6000 N !
 FUNCTION PT2A3C    298.15 +FV1A3C#**(-1)*P+FV7A3C#*FV1A3C#**(-1)*P; 6000 N !
 FUNCTION IYA3C     298.15 +1+2*FV8A3C#*PT2A3C#; 6000 N !
 FUNCTION LYA3C     298.15 +.5*LN(IYA3C#); 6000 N !
 FUNCTION YA3C      298.15 +1*EXP(LYA3C#); 6000 N !
 FUNCTION IBA3C     298.15 +FV8A3C#**(-1)-FV8A3C#**(-1)*EXP(LYA3C#); 6000 N !
 FUNCTION GBPA3C    298.15 +1+FV8A3C#-FV8A3C#*EXP(IBA3C#)-YA3C#*EXP(IBA3C#);
     6000 N !
 FUNCTION GBMA3C    298.15 +1+FV8A3C#; 6000 N !
 FUNCTION GBRA3C    298.15 +GBMA3C#**(-1)*GBPA3C#; 6000 N !
 FUNCTION IGRA3C    298.15 +FV5A3C#*FV4A3C#**(-1)+FV4A3C#**(-1); 6000 N !
 FUNCTION INTA3C    298.15 +IGRA3C#**(-1)*GPTA3C#; 6000 N !
 FUNCTION TA3C      298.15 +FV3A3C#*EXP(INTA3C#); 6000 N !
 FUNCTION IEA3C     298.15 +1-1*EXP(-TA3C#*T**(-1)); 6000 N !
 FUNCTION IE0A3C    298.15 +1-1*EXP(-FV3A3C#*T**(-1)); 6000 N !
 FUNCTION GQHA3C    298.15 +3*R#*T*LN(IEA3C#)-3*R#*T*LN(IE0A3C#); 6000 N !
 FUNCTION DGTA3C    298.15 -HSEA9C#+SSEA9C#*T+GHSERCC#-3*R#*T*LN(IE0A3C#);
     6000 N !
 FUNCTION IGPA3FC   298.15 +BVA3FE#*GPCA3FE#+.5*BVA3C#*GPCA3C#
     -DGTA1FE#*GBRA3FE#-.5*DGTA3C#*GBRA3C#; 6000 N !

$ parameters for C-Fe interaction in liquid
 FUNCTION FV0L0FC   298.15 -1.53E-06; 6000 N !
 FUNCTION FV1L0FC   298.15 +6E+09; 6000 N !
 FUNCTION FV2L0FC   298.15 +.5; 6000 N !

$ EOS for interaction C-Fe parameter in liquid
 FUNCTION BVL0FC    298.15 +FV0L0FC#*FV1L0FC#; 6000 N !
 FUNCTION PL0FC     298.15 +FV1L0FC#**(-1)*P; 6000 N !
 FUNCTION IYL0FC    298.15 +1+2*FV2L0FC#*PL0FC#; 6000 N !
 FUNCTION LYL0FC    298.15 +.5*LN(IYL0FC#); 6000 N !
 FUNCTION YL0FC     298.15 +1*EXP(LYL0FC#); 6000 N !
 FUNCTION IBL0FC    298.15 +FV2L0FC#**(-1)-FV2L0FC#**(-1)*EXP(LYL0FC#); 6000
     N !
 FUNCTION GPCL0FC   298.15 +1+FV2L0FC#-FV2L0FC#*EXP(IBL0FC#)
     -YL0FC#*EXP(IBL0FC#); 6000 N !

$ parameters for cementite
 FUNCTION FV0FE3C   298.15 +5.755E-06; 6000 N !
 FUNCTION FV1FE3C   298.15 +2E+11; 6000 N !
 FUNCTION FV2FE3C   298.15 +5.2; 6000 N !
 FUNCTION FV3FE3C   298.15 +400; 6000 N !
 FUNCTION FV4FE3C   298.15 +1.7; 6000 N !
 FUNCTION FV5FE3C   298.15 +5; 6000 N !
 FUNCTION FV6FE3C   298.15 +1; 6000 N !
 FUNCTION FV7FE3C   298.15 +10; 6000 N !
 FUNCTION FV8FE3C   298.15 +4; 6000 N !

$ EOS for cementite
 FUNCTION PFE3C     298.15 +FV1FE3C#**(-1)*P; 6000 N !
 FUNCTION BVFE3C    298.15 +FV0FE3C#*FV1FE3C#; 6000 N !
 FUNCTION IAFE3C    298.15 +FV2FE3C#-.333333333; 6000 N !
 FUNCTION FCFE3C    298.15 +1+1.33333333*IAFE3C#*PFE3C#; 6000 N !
 FUNCTION LFCFE3C   298.15 +1*LN(FCFE3C#); 6000 N !
 FUNCTION IXCFE3C   298.15 +1-IAFE3C#**(-1)+IAFE3C#**(-1)*EXP(.25*LFCFE3C#);
     6000 N !
 FUNCTION G2FE3C    298.15 +1.5*FV2FE3C#**3-6*FV2FE3C#**2+8*FV2FE3C#
     -3.55555555; 6000 N !
 FUNCTION G1FE3C    298.15 -9*FV2FE3C#**3+27*FV2FE3C#**2-24*FV2FE3C#
     +5.33333333; 6000 N !
 FUNCTION GLFE3C    298.15 +9*FV2FE3C#**3-18*FV2FE3C#**2+9*FV2FE3C#
     -1.33333333; 6000 N !
 FUNCTION GM1FE3C   298.15 +3*FV2FE3C#**3-3*FV2FE3C#**2+FV2FE3C#-.111111111;
     6000 N !
 FUNCTION GPCFE3C   298.15 +G2FE3C#*IXCFE3C#**(-2)+G1FE3C#*IXCFE3C#**(-1)
     -GLFE3C#*LN(IXCFE3C#)+GM1FE3C#*IXCFE3C#-G2FE3C#-G1FE3C#-GM1FE3C#; 6000
     N !
 FUNCTION PTFE3C    298.15 +FV1FE3C#**(-1)*P+FV5FE3C#*FV1FE3C#**(-1)*P; 6000
     N !
 FUNCTION IATFE3C   298.15 +3*FV6FE3C#-1; 6000 N !
 FUNCTION FTFE3C    298.15 +1+.666666667*IATFE3C#*PTFE3C#; 6000 N !
 FUNCTION LTFFE3C   298.15 +1*LN(FTFE3C#); 6000 N !
 FUNCTION IXTFE3C   298.15 +1-IATFE3C#**(-1)+IATFE3C#**(-1)*EXP(.5*LTFFE3C#);
      6000 N !
 FUNCTION GPTFE3C   298.15 +4.5*FV6FE3C#*IXTFE3C#**(-2)-3*IXTFE3C#**(-2)
     -9*FV6FE3C#*IXTFE3C#**(-1)+3*IXTFE3C#**(-1)+4.5*FV6FE3C#; 6000 N !
 FUNCTION PT2FE3C   298.15 +FV1FE3C#**(-1)*P+FV7FE3C#*FV1FE3C#**(-1)*P; 6000
     N !
 FUNCTION IYFE3C    298.15 +1+2*FV8FE3C#*PT2FE3C#; 6000 N !
 FUNCTION LYFE3C    298.15 +.5*LN(IYFE3C#); 6000 N !
 FUNCTION YFE3C     298.15 +1*EXP(LYFE3C#); 6000 N !
 FUNCTION IBFE3C    298.15 +FV8FE3C#**(-1)-FV8FE3C#**(-1)*EXP(LYFE3C#); 6000
     N !
 FUNCTION GBPFE3C   298.15 +1+FV8FE3C#-FV8FE3C#*EXP(IBFE3C#)
     -YFE3C#*EXP(IBFE3C#); 6000 N !
 FUNCTION GBMFE3C   298.15 +1+FV8FE3C#; 6000 N !
 FUNCTION GBRFE3C   298.15 +GBMFE3C#**(-1)*GBPFE3C#; 6000 N !
 FUNCTION IGRFE3C   298.15 +FV5FE3C#*FV4FE3C#**(-1)+FV4FE3C#**(-1); 6000 N !
 FUNCTION INTFE3C   298.15 +IGRFE3C#**(-1)*GPTFE3C#; 6000 N !
 FUNCTION TFE3C     298.15 +FV3FE3C#*EXP(INTFE3C#); 6000 N !
 FUNCTION IEFE3C    298.15 +1-1*EXP(-TFE3C#*T**(-1)); 6000 N !
 FUNCTION IE0FE3C   298.15 +1-1*EXP(-FV3FE3C#*T**(-1)); 6000 N !
 FUNCTION NMFE3C    298.15 +4; 6000 N !
 FUNCTION HSEFE3C   298.15 +11369.9377*NMFE3C#**(-1); 6000 N !
 FUNCTION SSEFE3C   298.15 +5.64125926*NMFE3C#**(-1); 6000 N !
 FUNCTION DGTFE3C   298.15 -HSEFE3C#+SSEFE3C#*T+GFECEM#*NMFE3C#**(-1)
     -3*R#*T*LN(IE0FE3C#); 6000 N !


$ functions for calculation of magnetic Gibbs energy of Cementite

 FUNCTION AM1FE3C   298.15 +1-1E-10*P; 6000 N !
 FUNCTION AM2FE3C   298.15 +AM1FE3C#**2+1E-04; 6000 N !
 FUNCTION AM3FE3C   298.15 +1*LN(AM2FE3C#); 6000 N !
 FUNCTION AM4FE3C   298.15 +.5*EXP(.5*AM3FE3C#)+.5*AM1FE3C#; 6000 N !
 FUNCTION AM5FE3C   298.15 +.75*LN(AM4FE3C#); 6000 N !
 FUNCTION BMFE3C    298.15 +1.008; 6000 N !
 FUNCTION TCFE3C    298.15 +485*EXP(AM5FE3C#); 6000 N !

$ parameters for Fe7C3
 FUNCTION FV0FE7C3  298.15 +5.515E-06; 6000 N !
 FUNCTION FV1FE7C3  298.15 +2.55E+11; 6000 N !
 FUNCTION FV2FE7C3  298.15 +4; 6000 N !
 FUNCTION FV3FE7C3  298.15 +445; 6000 N !
 FUNCTION FV4FE7C3  298.15 +1.7; 6000 N !
 FUNCTION FV5FE7C3  298.15 +4; 6000 N !
 FUNCTION FV6FE7C3  298.15 +1; 6000 N !
 FUNCTION FV7FE7C3  298.15 +10; 6000 N !
 FUNCTION FV8FE7C3  298.15 +4; 6000 N !

$ EOS for Fe7C3
 FUNCTION PFE7C3    298.15 +FV1FE7C3#**(-1)*P; 6000 N !
 FUNCTION BVFE7C3   298.15 +FV0FE7C3#*FV1FE7C3#; 6000 N !
 FUNCTION IAFE7C3   298.15 +FV2FE7C3#-.333333333; 6000 N !
 FUNCTION FCFE7C3   298.15 +1+1.33333333*IAFE7C3#*PFE7C3#; 6000 N !
 FUNCTION LFCFE7C3  298.15 +1*LN(FCFE7C3#); 6000 N !
 FUNCTION IXCFE7C3  298.15 +1-IAFE7C3#**(-1)
     +IAFE7C3#**(-1)*EXP(.25*LFCFE7C3#); 6000 N !
 FUNCTION G2FE7C3   298.15 +1.5*FV2FE7C3#**3-6*FV2FE7C3#**2+8*FV2FE7C3#
     -3.55555555; 6000 N !
 FUNCTION G1FE7C3   298.15 -9*FV2FE7C3#**3+27*FV2FE7C3#**2-24*FV2FE7C3#
     +5.33333333; 6000 N !
 FUNCTION GLFE7C3   298.15 +9*FV2FE7C3#**3-18*FV2FE7C3#**2+9*FV2FE7C3#
     -1.33333333; 6000 N !
 FUNCTION GM1FE7C3  298.15 +3*FV2FE7C3#**3-3*FV2FE7C3#**2+FV2FE7C3#
     -.111111111; 6000 N !
 FUNCTION GPCFE7C3  298.15 +G2FE7C3#*IXCFE7C3#**(-2)
     +G1FE7C3#*IXCFE7C3#**(-1)-GLFE7C3#*LN(IXCFE7C3#)+GM1FE7C3#*IXCFE7C3#
     -G2FE7C3#-G1FE7C3#-GM1FE7C3#; 6000 N !
 FUNCTION PTFE7C3   298.15 +FV1FE7C3#**(-1)*P+FV5FE7C3#*FV1FE7C3#**(-1)*P;
     6000 N !
 FUNCTION IATFE7C3  298.15 +3*FV6FE7C3#-1; 6000 N !
 FUNCTION FTFE7C3   298.15 +1+.666666667*IATFE7C3#*PTFE7C3#; 6000 N !
 FUNCTION LTFFE7C3  298.15 +1*LN(FTFE7C3#); 6000 N !
 FUNCTION IXTFE7C3  298.15 +1-IATFE7C3#**(-1)
     +IATFE7C3#**(-1)*EXP(.5*LTFFE7C3#); 6000 N !
 FUNCTION GPTFE7C3  298.15 +4.5*FV6FE7C3#*IXTFE7C3#**(-2)-3*IXTFE7C3#**(-2)
     -9*FV6FE7C3#*IXTFE7C3#**(-1)+3*IXTFE7C3#**(-1)+4.5*FV6FE7C3#; 6000 N !
 FUNCTION PT2FE7C3  298.15 +FV1FE7C3#**(-1)*P+FV7FE7C3#*FV1FE7C3#**(-1)*P;
     6000 N !
 FUNCTION IYFE7C3   298.15 +1+2*FV8FE7C3#*PT2FE7C3#; 6000 N !
 FUNCTION LYFE7C3   298.15 +.5*LN(IYFE7C3#); 6000 N !
 FUNCTION YFE7C3    298.15 +1*EXP(LYFE7C3#); 6000 N !
 FUNCTION IBFE7C3   298.15 +FV8FE7C3#**(-1)-FV8FE7C3#**(-1)*EXP(LYFE7C3#);
     6000 N !
 FUNCTION GBPFE7C3  298.15 +1+FV8FE7C3#-FV8FE7C3#*EXP(IBFE7C3#)
     -YFE7C3#*EXP(IBFE7C3#); 6000 N !
 FUNCTION GBMFE7C3  298.15 +1+FV8FE7C3#; 6000 N !
 FUNCTION GBRFE7C3  298.15 +GBMFE7C3#**(-1)*GBPFE7C3#; 6000 N !
 FUNCTION IGRFE7C3  298.15 +FV5FE7C3#*FV4FE7C3#**(-1)+FV4FE7C3#**(-1); 6000
     N !
 FUNCTION INTFE7C3  298.15 +IGRFE7C3#**(-1)*GPTFE7C3#; 6000 N !
 FUNCTION TFE7C3    298.15 +FV3FE7C3#*EXP(INTFE7C3#); 6000 N !
 FUNCTION IEFE7C3   298.15 +1-1*EXP(-TFE7C3#*T**(-1)); 6000 N !
 FUNCTION IE0FE7C3  298.15 +1-1*EXP(-FV3FE7C3#*T**(-1)); 6000 N !
 FUNCTION NMFE7C3   298.15 +10; 6000 N !
 FUNCTION GFE7C3    298.15 +2.333333*GFECEM#+.666667*GHSERCC#; 6000 N !
 FUNCTION HSEFE7C3  298.15 +.2333333*HSEFE3C#+.0666667*HSEA9C#; 6000 N !
 FUNCTION SSEFE7C3  298.15 +.2333333*SSEFE3C#+.0666667*SSEA9C#; 6000 N !
 FUNCTION DGTFE7C3  298.15 -HSEFE7C3#+SSEFE7C3#*T+GFE7C3#*NMFE7C3#**(-1)
     -3*R#*T*LN(IE0FE7C3#); 6000 N !



$ functions for calculation of magnetic Gibbs energy of Fe7C3
 FUNCTION AM1FE7C3  298.15 +1-5E-11*P; 6000 N !
 FUNCTION AM2FE7C3  298.15 +AM1FE7C3#**2+1E-04; 6000 N !
 FUNCTION AM3FE7C3  298.15 +1*LN(AM2FE7C3#); 6000 N !
 FUNCTION AM4FE7C3  298.15 +.5*EXP(.5*AM3FE7C3#)+.5*AM1FE7C3#; 6000 N !
 FUNCTION AM5FE7C3  298.15 +1.25*LN(AM4FE7C3#); 6000 N !
 FUNCTION BMFE7C3   298.15 +3.5; 6000 N !
 FUNCTION TCFE7C3   298.15 +525*EXP(AM5FE7C3#); 6000 N !

$-------------------------------------------------------------------------------
 FUNCTION UN_ASS 298.15 +0; 300 N !

$------------------------------------------ End definition of functions---------


$ some technical keywords: magic spell of Thermo-Calc

 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA /- !

$-------------------------------------------------------------------------------

$ definition of phases


$ Liquid
 PHASE LIQUID:L %  1  1.0  !
    CONSTITUENT LIQUID:L :C,FE :  !

   PARAMETER G(LIQUID,C;0)                298.15 +GLIQC#+BVL1C#*GPCL1C#
  +BVL2C#*GPCL2C#+3*R#*T*LN(IEL1C#)-3*R#*T*LN(IE0L1C#)-DGTL1C#*GBRL1C#; 6000
  N REF0 !
   PARAMETER G(LIQUID,FE;0)               298.15 +GL1FE#+BVL1FE#*GPCL1FE#
  +3*R#*T*LN(IEL1FE#)-3*R#*T*LN(IE0L1FE#)-DGTL1FE#*GBRL1FE#; 6000 N REF0 !
   PARAMETER G(LIQUID,C,FE;0)             298.15 -124320+28.5*T
  +4*BVL0FC#*GPCL0FC#; 6000 N REF0 !
   PARAMETER G(LIQUID,C,FE;1)             298.15 +19300; 6000 N 10Hal !
   PARAMETER G(LIQUID,C,FE;2)             298.15 +49260-19*T; 6000 N 10Hal !



$ BCC_A2
 TYPE_DEFINITION & GES A_P_D BCC_A2 MAGNETIC  -1.0    4.00000E-01 !
 PHASE BCC_A2  %&  2 1   3 !
    CONSTITUENT BCC_A2  :FE : C,VA :  !

   PARAMETER G(BCC_A2,FE:C;0)             298.15 +GA2FE#+3*GA9C#+322050
  +75.667*T+IGPA2FC#+3*R#*T*LN(IEA2FE#)-3*R#*T*LN(IE0A2FE#)
  +9*R#*T*LN(IEA2C#)-9*R#*T*LN(IE0A2C#); 6000 N REF0 !
   PARAMETER TC(BCC_A2,FE:C;0)            298.15 +1043; 6000 N 91Din !
   PARAMETER BMAGN(BCC_A2,FE:C;0)         298.15 +2.22; 6000 N 91Din !
   PARAMETER G(BCC_A2,FE:VA;0)            298.15 +GA2FE#+BVA2FE#*GPCA2FE#
  +3*R#*T*LN(IEA2FE#)-3*R#*T*LN(IE0A2FE#)-DGTA2FE#*GBRA2FE#; 6000 N REF0 !
   PARAMETER TC(BCC_A2,FE:VA;0)           298.15 +1043; 6000 N 10Hal !
   PARAMETER BMAGN(BCC_A2,FE:VA;0)        298.15 +2.22; 6000 N 10Hal !
   PARAMETER G(BCC_A2,FE:C,VA;0)            1 -190*T; 3900 Y
   +0.0; 6000 N 10Hal !


$ Cementite
 TYPE_DEFINITION ' GES A_P_D CEMENTITE_D011 MAGNETIC  -3.0    2.80000E-01 !
 PHASE CEMENTITE_D011  %'  2 3   1 !
    CONSTITUENT CEMENTITE_D011  :FE : C :  !

   PARAMETER TC(CEMENTITE_D011,FE:C;0)    298.15 +TCFE3C#; 6000 N REF0 !
   PARAMETER BMAGN(CEMENTITE_D011,FE:C;0) 298.15 +BMFE3C#; 6000 N REF0 !
   PARAMETER G(CEMENTITE_D011,FE:C;0)     298.15 +GFECEM#+4*BVFE3C#*GPCFE3C#
  +12*R#*T*LN(IEFE3C#)-12*R#*T*LN(IE0FE3C#)-4*DGTFE3C#*GBRFE3C#; 6000 N REF0 !

$ diamond
 PHASE DIAMOND_A4  %  1  1.0  !
    CONSTITUENT DIAMOND_A4  :C :  !

   PARAMETER G(DIAMOND_A4,C;0)            298.15 +GA4C#+BVA4C#*GPCA4C#
  +3*R#*T*LN(IEA4C#)-3*R#*T*LN(IE0A4C#)-DGTA4C#*GBRA4C#; 6000 N REF0 !

$ FCC
 TYPE_DEFINITION ( GES A_P_D FCC_A1 MAGNETIC  -3.0    2.80000E-01 !
 PHASE FCC_A1  %(  2 1   1 !
    CONSTITUENT FCC_A1  :FE : C,VA :  !

   PARAMETER G(FCC_A1,FE:C;0)             298.15 +GA1FE#+GHSERCC#+77207
  -15.877*T+IGPA1FC#+3*R#*T*LN(IEA1FE#)-3*R#*T*LN(IE0A1FE#)
  +3*R#*T*LN(IEA1C#)-3*R#*T*LN(IE0A1C#); 6000 N REF0 !
   PARAMETER TC(FCC_A1,FE:C;0)            298.15 -201; 6000 N REF0 !
   PARAMETER BMAGN(FCC_A1,FE:C;0)         298.15 -2.1; 6000 N REF0 !
   PARAMETER G(FCC_A1,FE:VA;0)            298.15 +GA1FE#+BVA1FE#*GPCA1FE#
  +3*R#*T*LN(IEA1FE#)-3*R#*T*LN(IE0A1FE#)-DGTA1FE#*GBRA1FE#; 6000 N REF0 !
   PARAMETER TC(FCC_A1,FE:VA;0)           298.15 -201; 6000 N REF0 !
   PARAMETER BMAGN(FCC_A1,FE:VA;0)        298.15 -2.1; 6000 N REF0 !
   PARAMETER G(FCC_A1,FE:C,VA;0)          298.15 -34671; 6000 N REF0 !

$ Graphite
 PHASE GRAPHITE  %  1  1.0  !
    CONSTITUENT GRAPHITE  :C :  !

   PARAMETER G(GRAPHITE,C;0)              298.15 +GA9C#+BVA9C#*GPCA9C#
  +R#*T*LN(IEA9C1#)-R#*T*LN(IE0A9C1#)+2*R#*T*LN(IEA9C2#)-2*R#*T*LN(IE0A9C2#)
  -DGTA9C#*GBRA9C#; 6000 N REF0 !

$ HCP_A3
 TYPE_DEFINITION ) GES A_P_D HCP_A3 MAGNETIC  -3.0    2.80000E-01 !
 PHASE HCP_A3  %)  2 1   .5 !
    CONSTITUENT HCP_A3  :FE : C,VA :  !

   PARAMETER G(HCP_A3,FE:C;0)             298.15 +GA1FE#+.5*GHSERCC#+52905
  -11.9075*T+IGPA3FC#+3*R#*T*LN(IEA1FE#)-3*R#*T*LN(IE0A1FE#)
  +1.5*R#*T*LN(IEA3C#)-1.5*R#*T*LN(IE0A3C#); 6000 N REF0 !
   PARAMETER G(HCP_A3,FE:VA;0)            298.15 +GA3FE#+BVA3FE#*GPCA3FE#
  +3*R#*T*LN(IEA3FE#)-3*R#*T*LN(IE0A3FE#)-DGTA3FE#*GBRA3FE#; 6000 N REF0 !
   PARAMETER G(HCP_A3,FE:C,VA;0)          298.15 -22126; 6000 N 10Hal !

$ Fe7C3
 TYPE_DEFINITION * GES A_P_D M7C3_D101 MAGNETIC  -3.0    2.80000E-01 !
 PHASE M7C3_D101  %*  2 7   3 !
    CONSTITUENT M7C3_D101  :FE : C :  !

   PARAMETER TC(M7C3_D101,FE:C;0)         298.15 +TCFE7C3#; 6000 N REF1 !
   PARAMETER BMAGN(M7C3_D101,FE:C;0)      298.15 +BMFE7C3#; 6000 N REF1 !
   PARAMETER G(M7C3_D101,FE:C;0)          298.15 +32848.5-12.5057*T+10*DGTFE3C#
  +10*BVFE7C3#*GPCFE7C3#+30*R#*T*LN(IEFE7C3#)-10*DGTFE3C#*GBRFE7C3#;
  6000 N REF1 !

 LIST_OF_REFERENCES
 NUMBER  SOURCE

  REF0   'Combination of 10Hal and EOS of this work.'
  REF1   'This work.'
  07Br   'Brosh et al. CALPHAD 31 (2007) 173–185, EOS.'
  91Din  'A.T. Dinsdale, Calphad, 15, 317-425(1991).'
  10Hal  'B. Hallstedt, D. Djurovic, J. von Appen, R. Dronskowski, A. Dick,
          F. Koermann, T. Hickel, J. Neugebauer,
          Calphad, 34, 129-33(2010); Fe-C'
  !

"""

NI_AL_DUPIN_2001_TDB = """

$ Database file written 2014-10-21
$ From database: USER                    
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5773E+03  2.8322E+01!
 ELEMENT NI   FCC_A1                    5.8690E+01  4.7870E+03  2.9796E+01!
 
 FUNCTION F154T      2.98150E+02  +323947.58-25.1480943*T-20.859*T*LN(T)
     +4.5665E-05*T**2-3.942E-09*T**3-24275.5*T**(-1);  4.30000E+03  Y
      +342017.233-54.0526109*T-17.7891*T*LN(T)+6.822E-05*T**2
     -1.91111667E-08*T**3-14782200*T**(-1);  8.20000E+03  Y
      +542396.07-411.214335*T+22.2419*T*LN(T)-.00349619*T**2+4.0491E-08*T**3
     -2.0366965E+08*T**(-1);  1.00000E+04  N !
 FUNCTION F625T      2.98150E+02  +496408.232+35.479739*T-41.6397*T*LN(T)
     +.00249636*T**2-4.90507333E-07*T**3+85390.3*T**(-1);  9.00000E+02  Y
      +497613.221+17.368131*T-38.85476*T*LN(T)-2.249805E-04*T**2
     -9.49003167E-09*T**3-5287.23*T**(-1);  2.80000E+03  N !
 FUNCTION GHSERAL    2.98150E+02  -7976.15+137.093038*T-24.3671976*T*LN(T)
     -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1);  7.00000E+02  Y
      -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
     -5.764227E-06*T**3+74092*T**(-1);  9.33600E+02  Y
      -11278.378+188.684153*T-31.748192*T*LN(T)-1.231E+28*T**(-9);  
     6.00000E+03  N !
 FUNCTION GBCCAL     2.98150E+02  +10083-4.813*T+GHSERAL#;   6.00000E+03   N 
     !
 FUNCTION LB2ALVA    2.98150E+02  150000;   6.00000E+03   N !
 FUNCTION B2ALVA     2.98150E+02  +10000-T;   6.00000E+03   N !
 FUNCTION F13191T    2.98150E+02  +417658.868-44.7777921*T-20.056*T*LN(T)
     -.0060415*T**2+1.24774E-06*T**3-16320*T**(-1);  8.00000E+02  Y
      +413885.448+9.41787679*T-28.332*T*LN(T)+.00173115*T**2-8.399E-08*T**3
     +289050*T**(-1);  3.90000E+03  Y
      +440866.732-62.5810038*T-19.819*T*LN(T)+5.067E-04*T**2
     -4.93233333E-08*T**3-15879735*T**(-1);  7.60000E+03  Y
      +848806.287-813.398164*T+64.69*T*LN(T)-.00731865*T**2
     +8.71833333E-08*T**3-3.875846E+08*T**(-1);  1.00000E+04  N !
 FUNCTION F13265T    2.98150E+02  +638073.279-68.1901928*T-24.897*T*LN(T)
     -.0313584*T**2+5.93355333E-06*T**3-14215*T**(-1);  8.00000E+02  Y
      +611401.772+268.084821*T-75.25401*T*LN(T)+.01088525*T**2
     -7.08741667E-07*T**3+2633835*T**(-1);  2.10000E+03  Y
      +637459.339+72.0712678*T-48.587*T*LN(T)-9.09E-05*T**2
     +9.12933333E-08*T**3-1191755*T**(-1);  4.50000E+03  Y
      +564540.781+329.599011*T-80.11301*T*LN(T)+.00578085*T**2
     -1.08841667E-07*T**3+29137900*T**(-1);  6.00000E+03  N !
 FUNCTION GHSERNI    2.98140E+02  -5179.159+117.854*T-22.096*T*LN(T)
     -.0048407*T**2;  1.72800E+03  Y
      -27840.655+279.135*T-43.1*T*LN(T)+1.12754E+31*T**(-9);  6.00000E+03  N 
     !
 FUNCTION GBCCNI     2.98150E+02  +8715.084-3.556*T+GHSERNI#;   6.00000E+03  
      N !
 FUNCTION LB2NIVA    2.98150E+02  -64024.38+26.49419*T;   6.00000E+03   N !
 FUNCTION B2NIVA     2.98150E+02  +162397.3-27.40575*T;   6.00000E+03   N !
 FUNCTION LB2ALNI    2.98150E+02  -52440.88+11.30117*T;   6.00000E+03   N !
 FUNCTION B2ALNI     2.98150E+02  -152397.3+26.40575*T;   6.00000E+03   N !
 FUNCTION ALNI3      2.98150E+02  +3*U1ALNI#;   6.00000E+03   N !
 FUNCTION AL3NI      2.98150E+02  +3*U1ALNI#;   6.00000E+03   N !
 FUNCTION AL2NI2     2.98150E+02  +4*U1ALNI#;   6.00000E+03   N !
 FUNCTION L04ALNI    2.98150E+02  +U3ALNI#;   6.00000E+03   N !
 FUNCTION L14ALNI    2.98150E+02  +U4ALNI#;   6.00000E+03   N !
 FUNCTION U3ALNI     298.15 0.0; 6000.00  N !
 FUNCTION U4ALNI     2.98150E+02  +7203.60609-3.7427303*T;   6.00000E+03   N 
     !
 FUNCTION U1ALNI     2.98150E+02  +2*UNTIER#*UALNI#;   6.00000E+03   N !
 FUNCTION UNTIER     2.98150E+02  +TROIS#**(-1);   6.00000E+03   N !
 FUNCTION UALNI      2.98150E+02  -22212.8931+4.39570389*T;   6.00000E+03   
     N !
 FUNCTION TROIS      2.98150E+02  3;   6.00000E+03   N !
 FUNCTION UN_ASS 298.15 0; 300 N !
 
 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA /- !


 PHASE LIQUID %  1  1.0  !
 CONSTITUENT LIQUID :AL,NI :  !

   PARAMETER G(LIQUID,AL;0)  2.98130E+02  +11005.029-11.841867*T
  +7.934E-20*T**7+GHSERAL#;  9.33600E+02  Y
   +10482.382-11.253974*T+1.231E+28*T**(-9)+GHSERAL#;  6.00000E+03  N REF3 !
   PARAMETER G(LIQUID,NI;0)  2.98130E+02  +16414.686-9.397*T
  -3.82318E-21*T**7+GHSERNI#;  1.72800E+03  Y
   +18290.88-10.537*T-1.12754E+31*T**(-9)+GHSERNI#;  6.00000E+03  N REF3 !
   PARAMETER G(LIQUID,AL,NI;0)  2.98150E+02  -207109.28+41.31501*T;   
  6.00000E+03   N REF7 !
   PARAMETER G(LIQUID,AL,NI;1)  2.98150E+02  -10185.79+5.8714*T;   
  6.00000E+03   N REF7 !
   PARAMETER G(LIQUID,AL,NI;2)  2.98150E+02  +81204.81-31.95713*T;   
  6.00000E+03   N REF7 !
   PARAMETER G(LIQUID,AL,NI;3)  2.98150E+02  +4365.35-2.51632*T;   
  6.00000E+03   N REF7 !
   PARAMETER G(LIQUID,AL,NI;4)  2.98150E+02  -22101.64+13.16341*T;   
  6.00000E+03   N REF7 !


 PHASE AL3NI1  %  2 .75   .25 !
    CONSTITUENT AL3NI1  :AL : NI :  !

   PARAMETER G(AL3NI1,AL:NI;0)  2.98150E+02  -48483.73+12.29913*T
  +.75*GHSERAL#+.25*GHSERNI#;   6.00000E+03   N REF7 !


 PHASE AL3NI2  %  3 3   2   1 !
    CONSTITUENT AL3NI2  :AL : AL,NI : NI,VA :  !

   PARAMETER G(AL3NI2,AL:AL:NI;0)  2.98150E+02  +5*GBCCAL#+GBCCNI#-39465.978
  +7.89525*T;   6.00000E+03   N REF7 !
   PARAMETER G(AL3NI2,AL:NI:NI;0)  2.98150E+02  +3*GBCCAL#+3*GBCCNI#
  -427191.9+79.21725*T;   6.00000E+03   N REF7 !
   PARAMETER G(AL3NI2,AL:AL:VA;0)  2.98150E+02  +5*GBCCAL#+30000-3*T;   
  6.00000E+03   N REF7 !
   PARAMETER G(AL3NI2,AL:NI:VA;0)  2.98150E+02  +3*GBCCAL#+2*GBCCNI#
  -357725.92+68.322*T;   6.00000E+03   N REF7 !
   PARAMETER G(AL3NI2,AL:AL,NI:*;0)  2.98150E+02  -193484.18+131.79*T;   
  6.00000E+03   N REF7 !
$   PARAMETER G(AL3NI2,AL:AL,NI:NI;0)  2.98150E+02  -193484.18+131.79*T;   
$  6.00000E+03   N REF7 !
$   PARAMETER G(AL3NI2,AL:AL,NI:VA;0)  2.98150E+02  -193484.18+131.79*T;   
$  6.00000E+03   N REF7 !
   PARAMETER G(AL3NI2,AL:*:NI,VA;0)  2.98150E+02  -22001.7+7.0332*T;   
  6.00000E+03   N REF7 !
$   PARAMETER G(AL3NI2,AL:AL:NI,VA;0)  2.98150E+02  -22001.7+7.0332*T;   
$  6.00000E+03   N REF7 !
$   PARAMETER G(AL3NI2,AL:NI:NI,VA;0)  2.98150E+02  -22001.7+7.0332*T;   
$  6.00000E+03   N REF7 !


 PHASE AL3NI5  %  2 .375   .625 !
    CONSTITUENT AL3NI5  :AL : NI :  !

   PARAMETER G(AL3NI5,AL:NI;0)  2.98150E+02  +.375*GHSERAL#+.625*GHSERNI#
  -55507.7594+7.2648103*T;   6.00000E+03   N REF7 !


 TYPE_DEFINITION & GES A_P_D BCC_A2 MAGNETIC  -1.0    4.00000E-01 !
 PHASE BCC_A2  %&  2 1   3 !
    CONSTITUENT BCC_A2  :AL,NI,VA : VA :  !

   PARAMETER G(BCC_A2,AL:VA;0)  2.98150E+02  +GBCCAL#;   6.00000E+03   N 
  REF3 !
   PARAMETER G(BCC_A2,NI:VA;0)  2.98150E+02  +GBCCNI#;   6.00000E+03   N 
  REF3 !
   PARAMETER TC(BCC_A2,NI:VA;0)  2.98150E+02  575;   6.00000E+03   N REF2 !
   PARAMETER BMAGN(BCC_A2,NI:VA;0)  2.98150E+02  .85;   6.00000E+03   N REF2 !
   PARAMETER G(BCC_A2,VA:VA;0) 298.15 0; 6000 N!
   PARAMETER G(BCC_A2,AL,VA:VA;0)  2.98150E+02  +B2ALVA#+LB2ALVA#;   
  6.00000E+03   N REF8 !
   PARAMETER G(BCC_A2,AL,NI:VA;0)  2.98150E+02  +B2ALNI#+LB2ALNI#;   
  6.00000E+03   N REF8 !
   PARAMETER G(BCC_A2,NI,VA:VA;0)  2.98150E+02  +B2NIVA#+LB2NIVA#;   
  6.00000E+03   N REF8 !


$ THIS PHASE HAS A DISORDERED CONTRIBUTION FROM BCC_A2                  
 TYPE_DEFINITION ' GES A_P_D BCC_B2 DIS_PART BCC_A2 ,,,!
 TYPE_DEFINITION ( GES A_P_D BCC_B2 MAGNETIC  -1.0    4.00000E-01 !
 PHASE BCC_B2  %('  3 .5   .5   3 !
    CONSTITUENT BCC_B2  :AL,NI,VA : AL,NI,VA : VA :  !

   PARAMETER G(BCC_B2,AL:AL:VA;0) 298.15 0; 6000 N!
   PARAMETER G(BCC_B2,NI:AL:VA;0)  2.98150E+02  +.5*B2ALNI#-.5*LB2ALNI#;   
  6.00000E+03   N REF8 !
   PARAMETER G(BCC_B2,VA:AL:VA;0)  2.98150E+02  +.5*B2ALVA#-.5*LB2ALVA#;   
  6.00000E+03   N REF8 !
   PARAMETER G(BCC_B2,AL:NI:VA;0)  2.98150E+02  +.5*B2ALNI#-.5*LB2ALNI#;   
  6.00000E+03   N REF8 !
   PARAMETER G(BCC_B2,NI:NI:VA;0) 298.15 0; 6000 N!
   PARAMETER G(BCC_B2,VA:NI:VA;0)  2.98150E+02  +.5*B2NIVA#-.5*LB2NIVA#;   
  6.00000E+03   N REF8 !
   PARAMETER G(BCC_B2,AL:VA:VA;0)  2.98150E+02  +.5*B2ALVA#-.5*LB2ALVA#;   
  6.00000E+03   N REF8 !
   PARAMETER G(BCC_B2,NI:VA:VA;0)  2.98150E+02  +.5*B2NIVA#-.5*LB2NIVA#;   
  6.00000E+03   N REF8 !
   PARAMETER G(BCC_B2,VA:VA:VA;0) 298.15 0; 6000 N!


 TYPE_DEFINITION ) GES A_P_D FCC_A1 MAGNETIC  -3.0    2.80000E-01 !
 PHASE FCC_A1  %)  2 1   1 !
    CONSTITUENT FCC_A1  :AL,NI : VA :  !

   PARAMETER G(FCC_A1,AL:VA;0)  2.98150E+02  +GHSERAL#;   6.00000E+03   N 
  REF3 !
   PARAMETER G(FCC_A1,NI:VA;0)  2.98150E+02  +GHSERNI#;   6.00000E+03   N 
  REF3 !
   PARAMETER TC(FCC_A1,NI:VA;0)  2.98150E+02  633;   6.00000E+03   N REF2 !
   PARAMETER BMAGN(FCC_A1,NI:VA;0)  2.98150E+02  .52;   6.00000E+03   N REF2 !
   PARAMETER TC(FCC_A1,AL,NI:VA;0)  2.98150E+02  -1112;   6.00000E+03   N 
  REF7 !
   PARAMETER TC(FCC_A1,AL,NI:VA;1)  2.98150E+02  1745;   6.00000E+03   N 
  REF7 !
   PARAMETER G(FCC_A1,AL,NI:VA;0)  2.98150E+02  -162407.75+16.212965*T;   
  6.00000E+03   N REF7 !
   PARAMETER G(FCC_A1,AL,NI:VA;1)  2.98150E+02  +73417.798-34.914168*T;   
  6.00000E+03   N REF7 !
   PARAMETER G(FCC_A1,AL,NI:VA;2)  2.98150E+02  +33471.014-9.8373558*T;   
  6.00000E+03   N REF7 !
   PARAMETER G(FCC_A1,AL,NI:VA;3)  2.98150E+02  -30758.01+10.25267*T;   
  6.00000E+03   N REF7 !


$ THIS PHASE HAS A DISORDERED CONTRIBUTION FROM FCC_A1                  
 TYPE_DEFINITION * GES A_P_D FCC_L12 DIS_PART FCC_A1 ,,,!
 TYPE_DEFINITION + GES A_P_D FCC_L12 MAGNETIC  -3.0    2.80000E-01 !
 PHASE FCC_L12  %*+  3 .75   .25   1 !
    CONSTITUENT FCC_L12  :AL,NI : AL,NI : VA :  !

   PARAMETER G(FCC_L12,AL:AL:VA;0) 298.15 0; 6000 N!
   PARAMETER G(FCC_L12,NI:AL:VA;0)  2.98150E+02  +ALNI3#;   6.00000E+03   N 
  REF9 !
   PARAMETER G(FCC_L12,AL:NI:VA;0)  2.98150E+02  +AL3NI#;   6.00000E+03   N 
  REF9 !
   PARAMETER G(FCC_L12,NI:NI:VA;0) 298.15 0; 6000 N!
   PARAMETER G(FCC_L12,AL,NI:AL:VA;0)  2.98150E+02  -1.5*ALNI3#+1.5*AL2NI2#
  +1.5*AL3NI#;   6.00000E+03   N REF9 !
   PARAMETER G(FCC_L12,AL,NI:AL:VA;1)  2.98150E+02  +.5*ALNI3#-1.5*AL2NI2#
  +1.5*AL3NI#;   6.00000E+03   N REF9 !
   PARAMETER G(FCC_L12,AL,NI:NI:VA;0)  2.98150E+02  +1.5*ALNI3#+1.5*AL2NI2#
  -1.5*AL3NI#;   6.00000E+03   N REF9 !
   PARAMETER G(FCC_L12,AL,NI:NI:VA;1)  2.98150E+02  -1.5*ALNI3#+1.5*AL2NI2#
  -.5*AL3NI#;   6.00000E+03   N REF9 !
   PARAMETER G(FCC_L12,*:AL,NI:VA;0)  2.98150E+02  +L04ALNI#;   6.00000E+03  
   N REF9 !
   PARAMETER G(FCC_L12,*:AL,NI:VA;1)  2.98150E+02  +L14ALNI#;   6.00000E+03  
   N REF9 !
   PARAMETER G(FCC_L12,AL,NI:*:VA;0)  2.98150E+02  +3*L04ALNI#;   
  6.00000E+03   N REF9 !
   PARAMETER G(FCC_L12,AL,NI:*:VA;1)  2.98150E+02  +3*L14ALNI#;   
  6.00000E+03   N REF9 !

 LIST_OF_REFERENCES
 NUMBER  SOURCE
   REF10  'AL1<G> CODATA KEY VALUES SGTE ** ALUMINIUM <GAS> Cp values 
         similar in Codata Key Values and IVTAN Vol. 3'
   REF11  'AL2<G> CHATILLON(1992) Enthalpy of formation for Al1<g> taken 
         from Codata Key Values. Enthalpy of form. from TPIS dissociation 
         energy mean Value corrected with new fef from Sunil K.K. and Jordan 
         K.D. (J.Phys. Chem. 92(1988)2774) ab initio calculations.'
   REF3   'Alan Dinsdale, SGTE Data for Pure Elements, NPL Report DMA(A)195 
         Rev. August 1990'
   REF8   'N. Dupin, I. Ansara, Z. metallkd., Vol 90 (1999) p 76-85; Al-Ni'
   REF14  'NI1<G> T.C.R.A.S Class: 1 Data provided by T.C.R.A.S. October 1996'
   REF15  'NI2<G> T.C.R.A.S Class: 5 Data provided by T.C.R.A.S. October 1996'
   REF2   'Alan Dinsdale, SGTE Data for Pure Elements, NPL Report DMA(A)195 
         September 1989'
   REF7   'N. Dupin, Thesis, LTPCM, France, 1995; Al-Ni, also in I. Ansara, 
         N. Dupin, H.L. Lukas, B. SUndman J. Alloys Compds, 247 (1-2), 20-30 
         (1997)'
   REF9   ' N. Dupin, I. Ansara, B. Sundman Thermodynamic Re-Assessment of 
         the Ternary System Al-Cr-Ni, Calphad, 25 (2), 279-298 (2001); Al-Cr
         -Ni'
  ! 
"""

FE_MN_S_TDB = """$ From
$    Dilner, Mao, Selleby, Calphad 48 (2015) 95-105
$    doi: 10.1016/j.calphad.2014.11.004
$ For pycalphad, all upper temperature limts extended to T=10,000 K.
$ All phases except for ionic liquid for testing purposes.

$ Database file written 2014- 2-14
$ From database: SSUB4
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT FE   BCC_A2                    5.5847E+01  4.4890E+03  2.7280E+01!
 ELEMENT MN   CBCC_A12                  5.4938E+01  4.9960E+03  3.2008E+01!
 ELEMENT S    ORTHORHOMBIC_S            3.2066E+01  0.0000E+00  0.0000E+00!

 SPECIES FE+2                        FE1/+2!
 SPECIES MN+2                        MN1/+2!
 SPECIES S-2                         S1/-2!

 FUNCTION GFELIQ     2.98150E+02  +GHSERFE#+12040.17-6.55843*T
     -3.67516E-21*T**7;  1.81100E+03  Y
      -10838.83+291.302*T-46*T*LN(T);  10000  N !
 FUNCTION GSSLIQ     2.98150E+02  -4001.549+77.889686*T-15.504*T*LN(T)
     -.018629*T**2-2.4942E-07*T**3-113945*T**(-1);  3.88360E+02  Y
      -5285183.35+118449.585*T-19762.4*T*LN(T)+32.79275*T**2
     -.0102214167*T**3+2.646735E+08*T**(-1);  4.28150E+02  Y
      -8174995.23+319914.078*T-57607.3*T*LN(T)+135.3045*T**2
     -.0529973333*T**3;  4.32250E+02  Y
      -219408.801+7758.83993*T-1371.85*T*LN(T)+2.845035*T**2
     -.00101380333*T**3;  4.53150E+02  Y
      +92539.872-1336.36627*T+202.958*T*LN(T)-.2531915*T**2+5.18835E-05*T**3
     -8202200*T**(-1);  7.17000E+02  Y
      -6889.972+176.35482*T-32*T*LN(T);  10000  N !
 FUNCTION GHSERMN    2.98150E+02  -8115.28+130.059*T-23.4582*T*LN(T)
     -.00734768*T**2+69827*T**(-1);  1.51900E+03  Y
      -28733.41+312.2648*T-48*T*LN(T)+1.656847E+30*T**(-9);  10000  N !
 FUNCTION GLIQMN     2.98150E+02  +17859.91-12.6208*T+GHSERMN#
     -4.41929E-21*T**7;  1.51900E+03  Y
      -9993.9+299.036*T-48*T*LN(T);  10000  N !
 FUNCTION GHSERFE    2.98150E+02  +1225.7+124.134*T-23.5143*T*LN(T)
     -.00439752*T**2-5.8927E-08*T**3+77359*T**(-1);  1.81100E+03  Y
      -25383.581+299.31255*T-46*T*LN(T)+2.29603E+31*T**(-9);  10000  N
     !
 FUNCTION GLIQFES    2.98150E+02  -104225-1.479*T;   10000   N !
 FUNCTION GMNS       2.98150E+02  -230200+239*T
     -47.28*T*LN(T)-0.00444*T**2;   10000   N !
 FUNCTION UN_ASS 298.15 0; 300 N !

 PHASE IONIC_LIQ:Y %  2 6   4 !
    CONSTITUENT IONIC_LIQ:Y :FE+2,MN+2 : S-2,VA,S :  !

   PARAMETER G(IONIC_LIQ,FE+2:S-2;0)  2.98150E+02  +2*GLIQFES#+2*GFELIQ#
  +2*GSSLIQ#;  10000  N REF2 !
   PARAMETER G(IONIC_LIQ,MN+2:S-2;0)  2.98150E+02
  +2*GMNS#+52220-27.88*T;   10000   N REF0 !
   PARAMETER G(IONIC_LIQ,FE+2:VA;0)  2.98150E+02  +GFELIQ#;   10000
  N REF1 !
   PARAMETER G(IONIC_LIQ,MN+2:VA;0)  2.98150E+02  +GLIQMN#;   10000
  N REF1 !
   PARAMETER G(IONIC_LIQ,S;0)  2.98150E+02  +GSSLIQ#;  10000  N REF1 !
   PARAMETER G(IONIC_LIQ,FE+2,MN+2:S-2;0)  2.98150E+02  20000;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,FE+2,MN+2:S-2,VA;0)  2.98150E+02  -1e5;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,FE+2,MN+2:S-2,VA;1)  2.98150E+02  -1e5;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,FE+2,MN+2:S-2,VA;2)  2.98150E+02  +1e5;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,FE+2,MN+2:S-2,S;0)  2.98150E+02  300000;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,FE+2:S-2,VA;0)  2.98150E+02  +103758-46.3734*T;
  10000  N REF2 !
   PARAMETER G(IONIC_LIQ,FE+2:S-2,VA;1)  2.98150E+02  -27530;  10000
  N REF2 !
   PARAMETER G(IONIC_LIQ,FE+2:S-2,S;0)  2.98150E+02  +96626-43.614*T;
  10000  N REF2 !
   PARAMETER G(IONIC_LIQ,FE+2:S-2,S;1)  2.98150E+02  -145966+49.429*T;
  10000  N REF2 !
   PARAMETER G(IONIC_LIQ,MN+2:S-2,VA;0)  2.98150E+02  137000;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,MN+2:S-2,VA;1)  2.98150E+02  -11400;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,MN+2:S-2,S;0)  2.98150E+02  +96626-43.614*T;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,MN+2:S-2,S;1)  2.98150E+02  -145966+49.429*T;
  10000  N REF0 !
   PARAMETER G(IONIC_LIQ,FE+2,MN+2:VA;0)  2.98150E+02  -3950+.489*T;
  10000   N REF3 !
   PARAMETER G(IONIC_LIQ,FE+2,MN+2:VA;1)  2.98150E+02  1145;   10000
  N REF3 !
"""

TDB_PARAMETER_FILTERS_TEST = """
ELEMENT A BLANK 0 0 0 !
ELEMENT B BLANK 0 0 0 !
ELEMENT C BLANK 0 0 0 !

TYPE_DEFINITION % SEQ * !
DEFINE_SYSTEM_DEFAULT ELEMENT 2 !

PHASE ALPHA %  2 0.5 0.5 !
CONSTITUENT ALPHA :A: A,B :  !

PARAMETER G(ALPHA,A:A;0) 1 -10; 10000 N !
PARAMETER G(ALPHA,A:B;0) 1 -10; 10000 N !

$ _array_validitiy should filter this parameter because B is not in the first sublattice
PARAMETER G(ALPHA,B:A;0) 1 1e5; 10000 N !

PHASE BETA % 2 0.5 0.5 !
CONSTITUENT BETA :B: B,C :  !

PARAMETER G(BETA,B:B;0) 1 -10; 10000 N !
PARAMETER G(BETA,B:B,C;0) 1 -10; 10000 N !
$ _array_validity should filter this parameter because D is not in the sublattice model
PARAMETER G(BETA,B:D;0) 1 1e5; 10000 N !
$ _array_validity should filter this parameter because there are 3 sublattices
PARAMETER G(BETA,B:B:C;0) 1 1e5; 10000 N !
"""

AL_C_FE_B2_TDB = """
$ B2 phase from Connetable et al., Calphad 2008, 32 (2), 361–370.
$ https://doi.org/10.1016/j.calphad.2008.01.002.

 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5400E+03  2.8300E+01!
 ELEMENT C    GRAPHITE                  1.2011E+01  1.0540E+03  5.7423E+00!
 ELEMENT FE   BCC_A2                    5.5847E+01  4.4890E+03  2.7280E+01!


 FUNCTION GHSERAL   298.15 -7976.15+137.093038*T-24.3671976*T*LN(T)
     -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1); 700 Y
      -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
     -5.764227E-06*T**3+74092*T**(-1); 933.47 Y
      -11278.378+188.684153*T-31.748192*T*LN(T)-1.230524E+28*T**(-9); 2900 N
     !
 FUNCTION GB2ALVA   298.15 +10000-T-30*T; 6000 N !
 FUNCTION LB2ALVA   298.15 +150000; 6000 N !
 FUNCTION GHSERCC   298.15 -17368.441+170.73*T-24.3*T*LN(T)-4.723E-04*T**2
     +2562600*T**(-1)-2.643E+08*T**(-2)+1.2E+10*T**(-3); 6000 N !
 FUNCTION GHSERFE   298.15 +1225.7+124.134*T-23.5143*T*LN(T)-.00439752*T**2
     -5.8927E-08*T**3+77359*T**(-1); 1811 Y
      -25383.581+299.31255*T-46*T*LN(T)+2.29603E+31*T**(-9); 6000 N !
 FUNCTION ZERO      298.15 +0.0; 6000 N !
 FUNCTION GB2ALFE   298.15 +4*UB1ALFE#; 6000 N !
 FUNCTION UB2ALFE   298.15 -1973-2*T; 6000 N !
 FUNCTION UTCBALFE  298.15 -125; 6000 N !
 FUNCTION UBMBALFE  298.15 -1.36; 6000 N !
 FUNCTION BM0BALFE  298.15 -.3; 6000 N !
 FUNCTION BM1BALFE  298.15 -.8; 6000 N !
 FUNCTION BM2BALFE  298.15 +.2; 6000 N !
 FUNCTION UB1ALFE   298.15 -4023-1.14*T; 6000 N !

 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA !


 TYPE_DEFINITION ' GES A_P_D A2_BCC MAGNETIC  -1.0    4.00000E-01 !
 PHASE A2_BCC  %'  2 1   3 !
    CONSTITUENT A2_BCC  :AL,FE,VA : C,VA% :  !

   PARAMETER G(A2_BCC,AL:C;0)             298.15 +GHSERAL#+3*GHSERCC#+100000
  +80*T; 6000 N REF77 !
   PARAMETER G(A2_BCC,FE:C;0)             298.15 +GHSERFE#+3*GHSERCC#+322050
  +75.667*T; 6000 N REF7 !
   PARAMETER TC(A2_BCC,FE:C;0)            298.15 +1043; 6000 N REF7 !
   PARAMETER BMAGN(A2_BCC,FE:C;0)         298.15 +2.22; 6000 N REF7 !
   PARAMETER G(A2_BCC,VA:C;0)             298.15 +30*T; 6000 N REF79 !
   PARAMETER G(A2_BCC,AL:VA;0)            298.15 +GHSERAL#+10083-4.813*T;
  2900 N REF32 !
   PARAMETER G(A2_BCC,FE:VA;0)            298.15 +GHSERFE#; 6000 N REF32 !
   PARAMETER TC(A2_BCC,FE:VA;0)           298.15 +1043; 6000 N REF32 !
   PARAMETER BMAGN(A2_BCC,FE:VA;0)        298.15 +2.22; 6000 N REF32 !
   PARAMETER G(A2_BCC,VA:VA;0)            298.15 +30*T; 6000 N REF79 !
   PARAMETER G(A2_BCC,AL:C,VA;0)          298.15 +130000+14*T; 6000 N REF77 !
   PARAMETER G(A2_BCC,FE:C,VA;0)          298.15 -190*T; 6000 N REF7 !
   PARAMETER G(A2_BCC,AL,VA:VA;0)         298.15 +GB2ALVA#+LB2ALVA#; 6000 N
  REF56 !
   PARAMETER G(A2_BCC,AL,FE:VA;0)         298.15 -122960+32*T; 6000 N REF46 !
   PARAMETER G(A2_BCC,AL,FE:VA;1)         298.15 +2945.2; 6000 N REF46 !
   PARAMETER TC(A2_BCC,AL,FE:VA;0)        298.15 -438; 6000 N REF79 !
   PARAMETER TC(A2_BCC,AL,FE:VA;1)        298.15 -1720; 6000 N REF79 !
   PARAMETER G(A2_BCC,FE,VA:VA;0)         298.15 +150000; 6000 N REF79 !


$ THIS PHASE HAS A DISORDERED CONTRIBUTION FROM A2_BCC
 TYPE_DEFINITION ( GES AMEND_PHASE_DESCRIPTION B2_BCC DIS_PART A2_BCC,,,!
 TYPE_DEFINITION ) GES A_P_D B2_BCC MAGNETIC  -1.0    4.00000E-01 !
 PHASE B2_BCC  %()  3 .5   .5   3 !
    CONSTITUENT B2_BCC  :AL,FE,VA : AL,FE,VA% : C,VA :  !

   PARAMETER G(B2_BCC,AL:AL:C;0)          298.15 +ZERO#; 6000 N REF77 !
   PARAMETER G(B2_BCC,FE:AL:C;0)          298.15 +ZERO#; 6000 N REF77 !
   PARAMETER G(B2_BCC,VA:AL:C;0)          298.15 +ZERO#; 6000 N REF77 !
   PARAMETER G(B2_BCC,AL:FE:C;0)          298.15 +ZERO#; 6000 N REF77 !
   PARAMETER G(B2_BCC,FE:FE:C;0)          298.15 +ZERO#; 6000 N REF77 !
   PARAMETER G(B2_BCC,VA:FE:C;0)          298.15 +ZERO#; 6000 N REF77 !
   PARAMETER G(B2_BCC,AL:VA:C;0)          298.15 +ZERO#; 6000 N REF77 !
   PARAMETER G(B2_BCC,FE:VA:C;0)          298.15 +ZERO#; 6000 N REF77 !
       PARA G(B2_BCC,VA:VA:C;0) 298.15 +0; 6000 N!
       PARA G(B2_BCC,AL:AL:VA;0) 298.15 +0; 6000 N!
   PARAMETER G(B2_BCC,FE:AL:VA;0)         298.15 +GB2ALFE#; 6000 N REF79 !
   PARAMETER TC(B2_BCC,FE:AL:VA;0)        298.15 +2*UTCBALFE#; 6000 N REF79 !
   PARAMETER BMAGN(B2_BCC,FE:AL:VA;0)     298.15 +2*UBMBALFE#; 6000 N REF79 !
   PARAMETER G(B2_BCC,VA:AL:VA;0)         298.15 +.5*GB2ALVA#-.5*LB2ALVA#;
  6000 N REF56 !
   PARAMETER G(B2_BCC,AL:FE:VA;0)         298.15 +GB2ALFE#; 6000 N REF79 !
   PARAMETER TC(B2_BCC,AL:FE:VA;0)        298.15 +2*UTCBALFE#; 6000 N REF79 !
   PARAMETER BMAGN(B2_BCC,AL:FE:VA;0)     298.15 +2*UBMBALFE#; 6000 N REF79 !
       PARA G(B2_BCC,FE:FE:VA;0) 298.15 +0; 6000 N!
   PARAMETER G(B2_BCC,VA:FE:VA;0)         298.15 +ZERO#; 6000 N REF79 !
   PARAMETER G(B2_BCC,AL:VA:VA;0)         298.15 +.5*GB2ALVA#-.5*LB2ALVA#;
  6000 N REF56 !
   PARAMETER G(B2_BCC,FE:VA:VA;0)         298.15 +ZERO#; 6000 N REF79 !
       PARA G(B2_BCC,VA:VA:VA;0) 298.15 +0; 6000 N!
       PARA G(B2_BCC,AL:*:VA;0) 298.15 +0; 6000 N!
       PARA G(B2_BCC,*:AL:VA;0) 298.15 +0; 6000 N!
   PARAMETER G(B2_BCC,AL,FE:AL:VA;0)      298.15 +5600; 6000 N REF79 !
   PARAMETER G(B2_BCC,AL,FE:AL,FE:VA;0)   298.15 -8400-4.8*T; 6000 N REF79 !
   PARAMETER G(B2_BCC,AL:AL,FE:VA;0)      298.15 +5600; 6000 N REF79 !
   PARAMETER G(B2_BCC,FE:AL,FE:VA;0)      298.15 -1400+2.4*T; 6000 N REF79 !
   PARAMETER G(B2_BCC,AL,FE:FE:VA;0)      298.15 -1400+2.4*T; 6000 N REF79 !
   PARAMETER G(B2_BCC,AL,FE:*:VA;0)       298.15 +2*UB2ALFE#; 6000 N REF79 !
   PARAMETER G(B2_BCC,AL,FE:*:VA;1)       298.15 -524; 6000 N REF79 !
   PARAMETER G(B2_BCC,AL,FE:*:VA;2)       298.15 -1560; 6000 N REF79 !
   PARAMETER TC(B2_BCC,AL,FE:*:VA;0)      298.15 -2*UTCBALFE#; 6000 N REF79 !
   PARAMETER BMAGN(B2_BCC,AL,FE:*:VA;0)   298.15 +2*BM0BALFE#; 6000 N REF79 !
   PARAMETER BMAGN(B2_BCC,AL,FE:*:VA;1)   298.15 +2*BM1BALFE#; 6000 N REF79 !
   PARAMETER BMAGN(B2_BCC,AL,FE:*:VA;2)   298.15 +2*BM2BALFE#; 6000 N REF79 !
   PARAMETER G(B2_BCC,*:AL,FE:VA;0)       298.15 +2*UB2ALFE#; 6000 N REF79 !
   PARAMETER G(B2_BCC,*:AL,FE:VA;1)       298.15 -524; 6000 N REF79 !
   PARAMETER G(B2_BCC,*:AL,FE:VA;2)       298.15 -1560; 6000 N REF79 !
   PARAMETER TC(B2_BCC,*:AL,FE:VA;0)      298.15 -2*UTCBALFE#; 6000 N REF79 !
   PARAMETER BMAGN(B2_BCC,*:AL,FE:VA;0)   298.15 +2*BM0BALFE#; 6000 N REF79 !
   PARAMETER BMAGN(B2_BCC,*:AL,FE:VA;1)   298.15 +2*BM1BALFE#; 6000 N REF79 !
   PARAMETER BMAGN(B2_BCC,*:AL,FE:VA;2)   298.15 +2*BM2BALFE#; 6000 N REF79 !
"""

MC_FECOCRNBTI_TDB = """
$ Based on Matcalc steel database 2.060; used under ODBL
$ https://opendatacommons.org/licenses/odbl/1-0/
$ Only Fe-Co-Cr-Nb-Ti parameters retained (for performance in test)
$ Generated by brandon (pycalphad 0.8.4+142.g7d607139)
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

ELEMENT AL FCC_A1 26.98154 4540.0 28.3 !
ELEMENT B BETA_RHOMBO_B 10.811 1222.0 5.9 !
ELEMENT C HEX_A9 12.011 1054.0 5.7423 !
ELEMENT CO HCP_A3 58.933 4765.567 30.03 !
ELEMENT CR BCC_A2 51.996 4050.0 23.5429 !
ELEMENT CU FCC_A1 63.546 5004.0 33.15 !
ELEMENT FE BCC_A2 55.847 4489.0 27.2797 !
ELEMENT H 1/2_MOLE_H2(GAS) 1.0079 4234.0 65.285 !
ELEMENT HF HCP_A3 178.49 5845.0 43.56 !
ELEMENT LA DOUBLE_HCP(ABAC) 138.91 6665.1 56.902 !
ELEMENT MN BCC_A12 54.938 4995.696 32.2206 !
ELEMENT MO BCC_A2 95.94 4589.0 28.56 !
ELEMENT N 1/2_MOLE_N2(G) 14.007 4335.0 95.751 !
ELEMENT NB BCC_A2 92.9064 5220.0 36.27 !
ELEMENT NI FCC_A1 58.69 4787.0 29.7955 !
ELEMENT O 1/2_MOLE_O2(GAS) 15.999 4341.0 102.52 !
ELEMENT P WHITE_P 30.974 5360.0 41.09 !
ELEMENT PD FCC_A1 106.42 5468.5 37.8234 !
ELEMENT S FC_ORTHORH 32.066 4412.0 32.054 !
ELEMENT SI DIA_A4 28.0855 3217.0 18.81 !
ELEMENT TI HCP_A3 47.88 4824.0 30.72 !
ELEMENT V BCC_A2 50.9415 4507.0 30.89 !
ELEMENT VA VACUUM 0.0 0.0 0.0 !
ELEMENT W BCC_A2 183.85 4970.0 32.6176 !
ELEMENT Y HCP_A3 88.9059 5966.384 44.4341 !


FUNCTION AL2NI2 273.0 4*U1ALNI#; 6000.0 N !
FUNCTION AL3NI 273.0 3*U1ALNI#; 6000.0 N !
FUNCTION ALNI3 273.0 3*U1ALNI#; 6000.0 N !
FUNCTION B2ALNI 273.0 26.40575*T - 152397.88; 6000.0 N !
FUNCTION B2NIVA 273.0 162397.3 - 27.40575*T; 6000.0 N !
FUNCTION DGLAV 273.0 5000; 6000.0 N !
FUNCTION ETCFESI 273.0 63; 6000.0 N !
FUNCTION FESIW1 273.0 10476.27; 6000.0 N !
FUNCTION GAL2O3 273.0 1.4205433E-5*T**3 - 0.06747*T**2 - 67.4804*T*LN(T) +
   448.021092*T - 1707351.3 + 938780*T**(-1); 600.0 Y 2.78532E-7*T**3 -
   0.0072257*T**2 - 116.258*T*LN(T) + 754.856573*T - 1724886.06 +
   2120700*T**(-1); 1500.0 Y -6.29402E-7*T**3 + 0.00709105*T**2 -
   156.058*T*LN(T) + 1053.4548*T - 1772163.19 + 12366650*T**(-1); 6000.0 N !
FUNCTION GALBCC 273.0 -4.813*T + GHSERAL# + 10083; 6000.0 N !
FUNCTION GALHCP 273.0 -1.8*T + GHSERAL# + 5481; 6000.0 N !
FUNCTION GCOBCC 273.0 -0.7138*T + GHSERCO# + 2938; 6000.0 N !
FUNCTION GCOFCC 273.0 -0.61525*T + GHSERCO# + 427.591; 6000.0 N !
FUNCTION GCOM23C6 273.0 116*T + 6*GHSERCC# + 23*GHSERCO# + 145000; 6000.0 N !
FUNCTION GCR2O3 273.0 -0.00497*T**2 - 119.8*T*LN(T) + 728.56*T - 1164542 +
   1050000*T**(-1); 6000.0 N !
FUNCTION GCR3O4 273.0 -93.76*T + 1.5*GCR2O3# - 0.5*GHSEROO# + 280045; 6000.0
   N !
FUNCTION GCRFCC 273.0 0.163*T + GHSERCR# + 7284; 6000.0 N !
FUNCTION GCRM23C6 273.0 -0.126431*T**2 - 620.965*T*LN(T) + 3622.24*T -
   521983; 6000.0 N !
FUNCTION GCRM3C2 273.0 -0.0301188*T**2 - 89.6694*T*LN(T) + 530.66989*T -
   100823.8; 6000.0 N !
FUNCTION GCRM7C3 273.0 -0.0578207*T**2 - 190.177*T*LN(T) + 1103.128*T -
   201690; 6000.0 N !
FUNCTION GCUBCC 273.0 -1.255*T + GHSERCU# + 4017; 6000.0 N !
FUNCTION GDHCFE 273.0 0.5*GFEFCC# + 0.5*GFEHCP#; 6000.0 N !
FUNCTION GDHCNI 273.0 0.5*GHSERNI# + 0.5*GNIHCP#; 6000.0 N !
FUNCTION GDHCNIA 273.0 0.5*GHSERNIA# + 0.5*GNIHCPA#; 6000.0 N !
FUNCTION GDHCTI 273.0 0.5*GHSERTI# + 0.5*GTIFCC#; 6000.0 N !
FUNCTION GDHCTIA 273.0 0.5*GHSERTIA# + 0.5*GTIFCCA#; 6000.0 N !
FUNCTION GDIG 273.0 8.1715*T*LN(T) - 97.82124*T + 2*GHSERCU# + GHSERSS# -
   73851.5; 3000.0 N !
FUNCTION GFE2O3 273.0 -137.0089*T*LN(T) + 827.946*T - 858683 +
   1453810*T**(-1); 6000.0 N !
FUNCTION GFECEM 273.0 -0.0007*T**2 - 118.47637*T*LN(T) + 690.949887637*T -
   10195.860754 + 590527*T**(-1); 6000.0 N !
FUNCTION GFEFCC 273.0 0.00064*T**2 - 1.15*T*LN(T) + 8.282*T + GHSERFE# -
   1462.4; 1811.0 Y -46*T*LN(T) + 300.25256*T - 27098.266 +
   2.78854E+31*T**(-9); 6000.0 N !
FUNCTION GFEHCP 273.0 -5.8927E-8*T**3 - 0.00375752*T**2 - 24.6643*T*LN(T) +
   136.725*T - 2480.08 + 77358.5*T**(-1); 1811.0 Y -46*T*LN(T) + 304.56206*T
   - 29340.78 + 2.78854E+31*T**(-9); 6000.0 N !
FUNCTION GFEM23C6 273.0 -40*T + 7.666667*GFECEM# - 1.666667*GHSERCC# + 66920;
   6000.0 N !
FUNCTION GFEO 273.0 -0.0057403*T**2 - 46.12826*T*LN(T) + 252.848*T - 279318;
   6000.0 N !
FUNCTION GHEXTNB 273.0 -3.50119E-7*T**3 + 0.000203475*T**2 - 26.4711*T*LN(T)
   + 142.048*T - 8519.35 + 93398.8*T**(-1); 6000.0 N !
FUNCTION GHF1O2_S 273.0 -0.00297849*T**2 - 74.15647*T*LN(T) + 446.1053*T -
   1144500 + 630000*T**(-1); 6000.0 N !
FUNCTION GHFBCC 273.0 -1.446E-10*T**4 + 8.71923E-7*T**3 - 0.004206605*T**2 -
   22.8995*T*LN(T) + 103.836026*T + 5370.703 - 22590*T**(-1); 2506.0 Y
   1.3427829E-5*T**3 - 0.286857065*T**2 + 1087.6141247*T*LN(T) - 8624.20573*T
   + 1912456.771 - 610085091*T**(-1); 6000.0 N !
FUNCTION GHFC 273.0 -0.00299726*T**2 - 45.61482*T*LN(T) + 272.916*T - 226447
   + 501495*T**(-1) - 958263000.0*T**(-3); 4000.0 N !
FUNCTION GHFFCC 273.0 -4.77E-10*T**3 - 0.004146*T**2 - 22.7075*T*LN(T) +
   108.544*T + 3012.703 - 22590*T**(-1); 2506.0 Y -7.575759E-6*T**3 +
   0.1735215*T**2 - 787.5363829*T*LN(T) + 6191.409991*T - 1436776.329 +
   501742495*T**(-1); 3000.0 N !
FUNCTION GHSERAL 273.0 -8.77664E-7*T**3 - 0.001884662*T**2 -
   24.3671976*T*LN(T) + 137.093038*T - 7976.15 + 74092*T**(-1); 700.0 Y
   -5.764227E-6*T**3 + 0.018531982*T**2 - 38.5844296*T*LN(T) + 223.048446*T -
   11276.24 + 74092*T**(-1); 933.47 Y -31.748192*T*LN(T) + 188.684153*T -
   11278.378 - 1.231E+28*T**(-9); 6000.0 N !
FUNCTION GHSERBB 273.0 6.18878E-7*T**3 - 0.006864515*T**2 - 15.6641*T*LN(T) +
   107.111864*T - 7735.284 + 370843*T**(-1); 1100.0 Y -2.556E-8*T**3 -
   0.00079809*T**2 - 26.6047*T*LN(T) + 184.801744*T - 16649.474 +
   1748270*T**(-1); 2348.0 Y 1.34719E-7*T**3 - 0.00159488*T**2 -
   31.5957527*T*LN(T) + 231.336244*T - 36667.582 + 11205883*T**(-1); 3000.0 Y
   -31.4*T*LN(T) + 222.396264*T - 21530.653; 6000.0 N !
FUNCTION GHSERCC 273.0 -0.01706952*T**2 + 1.76583*T*LN(T) - 7.39898691*T -
   988.25091; 350.0 Y -0.0004723*T**2 - 24.3*T*LN(T) + 170.73*T - 17368.441 +
   2562600*T**(-1) - 264300000.0*T**(-2) + 12000000000.0*T**(-3); 6000.0 N !
FUNCTION GHSERCO 273.0 -1.7348E-7*T**3 - 0.0026547387*T**2 - 25.0861*T*LN(T)
   + 133.36601*T + 310.241 + 72526.9*T**(-1); 1768.0 Y -40.5*T*LN(T) +
   253.28374*T - 17197.666 + 9.3488E+30*T**(-9); 6000.0 N !
FUNCTION GHSERCR 273.0 -1.47721E-6*T**3 + 0.00189435*T**2 - 26.908*T*LN(T) +
   157.48*T - 8856.94 + 139250*T**(-1); 2180.0 Y -50*T*LN(T) + 344.18*T -
   34869.344 - 2.88526E+32*T**(-9); 6000.0 N !
FUNCTION GHSERCU 273.0 1.29223E-7*T**3 - 0.00265684*T**2 - 24.112392*T*LN(T)
   + 130.485235*T - 7770.458 + 52478*T**(-1); 1357.77 Y -31.38*T*LN(T) +
   183.803828*T - 13542.026 + 3.642E+29*T**(-9); 6000.0 N !
FUNCTION GHSERFE 273.0 -5.89269E-8*T**3 - 0.00439752*T**2 - 23.5143*T*LN(T) +
   124.134*T + 1225.7 + 77358.5*T**(-1); 1811.0 Y -46*T*LN(T) + 299.31255*T -
   25383.581 + 2.2960305E+31*T**(-9); 6000.0 N !
FUNCTION GHSERHF 273.0 -4.77E-10*T**3 - 0.004146145*T**2 - 22.7075*T*LN(T) +
   110.744026*T - 6987.297 - 22590*T**(-1); 2506.0 Y -7.575759E-6*T**3 +
   0.1735215*T**2 - 787.5363829*T*LN(T) + 6193.609991*T - 1446776.329 +
   501742495*T**(-1); 6000.0 N !
FUNCTION GHSERHH 273.0 -7.46390667E-7*T**3 + 0.0027589925*T**2 -
   31.35707*T*LN(T) + 78.5273873*T - 9522.97393 + 56582.3*T**(-1); 1000.0 Y
   3.14618667E-7*T**3 - 0.00584168*T**2 - 17.84857*T*LN(T) - 15.6128262*T +
   180.10884 - 1280036*T**(-1); 2100.0 Y 1.14281783E-8*T**3 -
   0.0010728235*T**2 - 32.05082*T*LN(T) + 92.3120249*T - 18840.1661 +
   3561002.5*T**(-1); 6000.0 N !
FUNCTION GHSERLA 273.0 -0.001295165*T**2 - 26.34*T*LN(T) + 120.284604*T -
   7968.403; 550.0 Y 6.8932E-7*T**3 - 0.008371705*T**2 - 17.1659411*T*LN(T) +
   59.06113*T - 3381.413 - 399448*T**(-1); 2000.0 Y -34.3088*T*LN(T) +
   181.390071*T - 15608.882; 6000.0 N !
FUNCTION GHSERMN 273.0 -0.00734768*T**2 - 23.4582*T*LN(T) + 130.059*T -
   8115.28 + 69827.1*T**(-1); 1519.0 Y -48.0*T*LN(T) + 312.2648*T - 28733.41
   + 1.656847E+30*T**(-9); 6000.0 N !
FUNCTION GHSERMO 273.0 -1.309265E-10*T**4 + 5.662834E-7*T**3 -
   0.003443396*T**2 - 23.56414*T*LN(T) + 131.9197*T - 7746.302 +
   65812.39*T**(-1); 2896.0 Y -42.63829*T*LN(T) + 283.559746*T - 30556.41 -
   4.849315E+33*T**(-9); 5000.0 N !
FUNCTION GHSERNB 273.0 -3.5011E-7*T**3 + 0.000203475*T**2 - 26.4711*T*LN(T) +
   142.045475*T - 8519.353 + 93399*T**(-1); 2750.0 Y -41.77*T*LN(T) +
   271.720843*T - 37669.3 + 1.52824E+32*T**(-9); 6000.0 N !
FUNCTION GHSERNI 273.0 -0.0048407*T**2 - 22.096*T*LN(T) + 117.854*T -
   5179.159; 1728.0 Y -43.1*T*LN(T) + 279.135*T - 27840.655 +
   1.12754E+31*T**(-9); 6000.0 N !
FUNCTION GHSERNIA 273.0 -0.0048407*T**2 - 22.096*T*LN(T) + 117.854*T -
   5179.159; 6000.0 N !
FUNCTION GHSERNN 273.0 2.680735E-9*T**3 - 0.00176686*T**2 - 12.7819*T*LN(T) -
   9.45425*T - 3750.675 - 32374*T**(-1); 950.0 Y 3.0097E-8*T**3 -
   0.00065107*T**2 - 16.3699*T*LN(T) + 17.2003*T - 7358.85 + 563070*T**(-1);
   3350.0 Y -8.3331E-9*T**3 + 0.000239754*T**2 - 20.4695*T*LN(T) + 50.26*T -
   16392.8 + 4596375*T**(-1); 6000.0 N !
FUNCTION GHSEROO 273.0 6.6184604E-7*T**3 - 0.005098873*T**2 -
   11.1355068*T*LN(T) - 25.5028601*T - 3480.87226 - 38364.8742*T**(-1);
   1000.0 Y 6.78055555E-9*T**3 - 0.00059579637*T**2 - 16.8138015*T*LN(T) +
   12.6600017*T - 6568.76015 + 262904.778*T**(-1); 3300.0 Y 1.0721E-8*T**3 -
   0.000425243*T**2 - 18.9536*T*LN(T) + 31.259625*T - 13986.728 +
   4383200*T**(-1); 6000.0 N !
FUNCTION GHSERPD 273.0 -1.919875E-6*T**3 + 0.007120975*T**2 - 32.211*T*LN(T)
   + 176.076315*T - 10204.027 + 168687*T**(-1); 900.0 Y 1.91115E-7*T**3 -
   0.00717522*T**2 - 13.5708*T*LN(T) + 49.659892*T + 917.062 -
   1112465*T**(-1); 1828.0 Y -6.2811E-8*T**3 + 0.002091396*T**2 -
   54.2067086*T*LN(T) + 370.102147*T - 67161.018 + 18683526*T**(-1); 6000.0 N
   !
FUNCTION GHSERPP 273.0 -0.000104022667*T**3 + 0.290708*T**2 - 178.426*T*LN(T)
   + 1026.69389*T - 43821.799 + 1632695*T**(-1); 317.3 Y -2.2829E-7*T**3 +
   0.001715669*T**2 - 28.7335301*T*LN(T) + 152.341487*T - 9587.448 +
   172966*T**(-1); 1000.0 Y -26.326*T*LN(T) + 135.876831*T - 8093.075; 3000.0
   N !
FUNCTION GHSERSI 273.0 -3.552E-9*T**3 - 0.001912904*T**2 - 22.8317533*T*LN(T)
   + 137.236859*T - 8162.609 + 176667*T**(-1); 1687.0 Y -27.196*T*LN(T) +
   167.281367*T - 9457.642 - 4.2037E+30*T**(-9); 3600.0 N !
FUNCTION GHSERSS 273.0 7.754333E-6*T**3 - 0.026529*T**2 - 11.007*T*LN(T) +
   55.417762*T - 5228.956; 368.3 Y 1.402558E-6*T**3 - 0.010895125*T**2 -
   17.941839*T*LN(T) + 94.692922*T - 6513.769 + 39910*T**(-1); 3000.0 N !
FUNCTION GHSERTI 273.0 1.06716E-7*T**3 - 0.004777975*T**2 - 23.9933*T*LN(T) +
   133.615208*T - 8059.921 + 72636*T**(-1); 900.0 Y -9.0876E-8*T**3 -
   0.0042033*T**2 - 23.9887*T*LN(T) + 132.988068*T - 7811.815 +
   42680*T**(-1); 1155.0 Y 2.02715E-7*T**3 - 0.0081465*T**2 - 14.9466*T*LN(T)
   + 66.976538*T + 908.837 - 1477660*T**(-1); 1941.0 Y -3.04747E-7*T**3 +
   0.008204849*T**2 - 87.2182461*T*LN(T) + 638.806871*T - 124526.786 +
   36699805*T**(-1); 4000.0 N !
FUNCTION GHSERTIA 273.0 1.06716E-7*T**3 - 0.004777975*T**2 - 23.9933*T*LN(T)
   + 133.615208*T - 8059.921 + 72636*T**(-1); 6000.0 N !
FUNCTION GHSERVV 273.0 1.2175E-7*T**3 - 0.003098*T**2 - 24.134*T*LN(T) +
   133.346053*T - 7930.43 + 69460*T**(-1); 790.0 Y -6.8E-7*T**3 +
   6.25E-5*T**2 - 25.9*T*LN(T) + 143.291093*T - 7967.842; 2183.0 Y
   -47.43*T*LN(T) + 321.140783*T - 41689.864 + 6.44389E+31*T**(-9); 4000.0 N !
FUNCTION GHSERWW 273.0 -5.33E-11*T**4 + 2.07E-7*T**3 - 0.001936*T**2 -
   24.1*T*LN(T) + 130.4*T - 7646.311 + 44500*T**(-1); 3695.0 Y -54.0*T*LN(T)
   + 389.362335*T - 82868.801 + 1.528621E+33*T**(-9); 6000.0 N !
FUNCTION GHSERYY 273.0 1.1125E-8*T**3 - 0.003845475*T**2 - 23.8685*T*LN(T) +
   117.532124*T - 7347.055 - 16486*T**(-1); 1500.0 Y -1.14182E-6*T**3 +
   0.0068095*T**2 - 40.2851*T*LN(T) + 229.831717*T - 15802.62; 1799.0 Y
   -7.2627E-8*T**3 + 0.002436461*T**2 - 58.2078433*T*LN(T) + 393.885821*T -
   72946.216 + 20866567*T**(-1); 6000.0 N !
FUNCTION GLA2O3D 273.0 -0.006854*T**2 - 120.629*T*LN(T) + 692.9664*T -
   1833257 + 808000*T**(-1) - 10000000*T**(-2); 6000.0 N !
FUNCTION GLA2O3H 273.0 -13.986*T + GLA2O3D# + 32350; 6000.0 N !
FUNCTION GLA2O3X 273.0 -18.555*T + GLA2O3D# + 43192; 6000.0 N !
FUNCTION GLABCC 273.0 -5.25865E-7*T**3 - 0.004045175*T**2 - 21.7919*T*LN(T) +
   88.072353*T - 3952.161; 800.0 Y 4.9547989E-5*T**3 - 0.387295093*T**2 +
   513.440708*T*LN(T) - 3565.08252*T + 321682.673 - 36581228*T**(-1); 1134.0
   Y -39.5388*T*LN(T) + 218.492988*T - 16377.894; 1193.0 Y -4.056395E-6*T**3
   + 0.053968535*T**2 - 163.413074*T*LN(T) + 1123.34397*T - 136609.91 +
   21167204*T**(-1); 2000.0 Y -34.3088*T*LN(T) + 174.836315*T - 8205.988;
   6000.0 N !
FUNCTION GLAFCC 273.0 -5.25865E-7*T**3 - 0.004045175*T**2 - 21.7919*T*LN(T) +
   89.878761*T - 6109.797; 1134.0 Y -3.066199E-6*T**3 + 0.042032405*T**2 -
   139.346741*T*LN(T) + 955.878375*T - 124598.976 + 20994153*T**(-1); 2000.0
   Y -34.3088*T*LN(T) + 178.54399*T - 12599.386; 6000.0 N !
FUNCTION GLAVNI 273.0 DGLAV# + GHSERNI#; 6000.0 N !
FUNCTION GLAVTI 273.0 DGLAV# + GHSERTI#; 6000.0 N !
FUNCTION GMN2NI2 273.0 -30156.6806; 6000.0 N !
FUNCTION GMN3NI 273.0 -20080.5831; 6000.0 N !
FUNCTION GMNBCC 273.0 -0.00744271*T**2 - 23.7*T*LN(T) + 127.85*T - 3235.3 +
   60000*T**(-1); 1519.0 Y -48*T*LN(T) + 307.7043*T - 23188.83 +
   1.265152E+30*T**(-9); 6000.0 N !
FUNCTION GMNFCC 273.0 -0.006*T**2 - 24.5177*T*LN(T) + 131.884*T - 3439.3 +
   69600*T**(-1); 1519.0 Y -48*T*LN(T) + 309.6664*T - 26070.1 +
   3.86196E+30*T**(-9); 6000.0 N !
FUNCTION GMNM23C6 273.0 50.966*T + 6*GHSERCC# + 23*GHSERMN# - 308065; 6000.0
   N !
FUNCTION GMNNI3 273.0 -21016.3924; 6000.0 N !
FUNCTION GMOFCC 273.0 0.63*T + GHSERMO# + 15200; 6000.0 N !
FUNCTION GMOHCP 273.0 -1.30927E-10*T**4 + 5.66283E-7*T**3 - 0.003443396*T**2
   - 23.56414*T*LN(T) + 131.9197*T + 3803.698 + 65812*T**(-1); 2896.0 Y
   -42.63829*T*LN(T) + 283.559746*T - 19006.41 - 4.849315E+33*T**(-9); 5000.0
   N !
FUNCTION GNIBCC 273.0 -3.556*T + GHSERNI# + 8715.084; 6000.0 N !
FUNCTION GNIHCP 273.0 1.2552*T + GHSERNI# + 1046; 6000.0 N !
FUNCTION GNIHCPA 273.0 1.2552*T + GHSERNIA# + 1046; 6000.0 N !
FUNCTION GNIM23C6 273.0 -84.71*T + 6*GHSERCC# + 23*GHSERNI# + 210000; 6000.0
   N !
FUNCTION GNIO 273.0 1.29092E-6*T**3 - 0.00931454*T**2 - 46.0391*T*LN(T) +
   276.208*T - 254927.2 + 382916*T**(-1); 1000.0 Y -8.11809E-7*T**3 +
   0.00254106*T**2 - 56.36068*T*LN(T) + 340.043*T - 256835.2 + 1270*T**(-1);
   1800.0 Y -7.80093E-7*T**3 + 0.00220246*T**2 - 55.75758*T*LN(T) + 337.305*T
   - 259131.4; 6000.0 N !
FUNCTION GPBCC 273.0 -2.418867E-6*T**3 + 0.0034121*T**2 - 25.55*T*LN(T) +
   135.412002*T + 18792.241 + 160095*T**(-1); 500.0 Y 3.93917E-7*T**3 -
   0.00957685*T**2 - 14.368*T*LN(T) + 64.411737*T + 23045.079 -
   141375*T**(-1); 852.35 Y -6.651929E-6*T**3 + 0.067272364*T**2 -
   149.4495562*T*LN(T) + 1012.76962*T - 74639.613 + 12495943*T**(-1); 1500.0
   Y -26.326*T*LN(T) + 140.579181*T + 20244.681; 3000.0 N !
FUNCTION GPDBCC 273.0 -1.8*T + GHSERPD# + 10500; 6000.0 N !
FUNCTION GPFCC 273.0 -2.418867E-6*T**3 + 0.0034121*T**2 - 25.55*T*LN(T) +
   135.534002*T + 10842.441 + 160095*T**(-1); 500.0 Y 3.93917E-7*T**3 -
   0.00957685*T**2 - 14.368*T*LN(T) + 64.533737*T + 15095.279 -
   141375*T**(-1); 852.35 Y -6.651929E-6*T**3 + 0.067272364*T**2 -
   149.4495562*T*LN(T) + 1012.89162*T - 82589.413 + 12495943*T**(-1); 1500.0
   Y -26.326*T*LN(T) + 140.701181*T + 12294.881; 3000.0 N !
FUNCTION GPRED 273.0 -2.418867E-6*T**3 + 0.0034121*T**2 - 25.55*T*LN(T) +
   148.672002*T - 25976.559 + 160095*T**(-1); 500.0 Y 3.93917E-7*T**3 -
   0.00957685*T**2 - 14.368*T*LN(T) + 77.671736*T - 21723.721 -
   141375*T**(-1); 852.35 Y -6.651929E-6*T**3 + 0.067272364*T**2 -
   149.4495562*T*LN(T) + 1026.02962*T - 119408.413 + 12495943*T**(-1); 1500.0
   Y -26.326*T*LN(T) + 153.839181*T - 24524.119; 3000.0 N !
FUNCTION GSIBCC 273.0 -22.5*T + GHSERSI# + 47000; 6000.0 N !
FUNCTION GSIFCC 273.0 -21.8*T + GHSERSI# + 51000; 6000.0 N !
FUNCTION GSIO2 273.0 4.9509742E-5*T**3 - 0.189203605*T**2 + 61.1323*T*LN(T) -
   360.892175*T - 900936.64 - 854401*T**(-1); 540.0 Y -9.09177E-5*T**3 +
   0.428883845*T**2 - 452.1367*T*LN(T) + 2882.67275*T - 1091193.54 +
   12476689*T**(-1); 770.0 Y -0.000235047657*T**3 + 1.28404426*T**2 -
   1404.5352*T*LN(T) + 9178.58655*T - 1563481.44 + 56402304*T**(-1); 848.0 Y
   -2.47E-10*T**3 - 0.00515995*T**2 - 58.4292*T*LN(T) + 356.218325*T -
   928732.923 - 95113*T**(-1); 1800.0 Y 6.78127E-7*T**3 - 0.01200315*T**2 -
   47.451*T*LN(T) + 281.229013*T - 924076.574 + 665385*T**(-1); 2900.0 Y
   -82.709*T*LN(T) + 544.992084*T - 957997.4; 6000.0 N !
FUNCTION GSSLIQ 273.0 -2.4942E-7*T**3 - 0.018629*T**2 - 15.504*T*LN(T) +
   77.905686*T - 4001.549 - 113945*T**(-1); 388.36 Y -0.010221416667*T**3 +
   32.79275*T**2 - 19762.4*T*LN(T) + 118449.601*T - 5285183.35 +
   264673500*T**(-1); 428.15 Y -0.052997333333*T**3 + 135.3045*T**2 -
   57607.3*T*LN(T) + 319914.094*T - 8174995.226; 432.25 Y
   -0.001013803333*T**3 + 2.845035*T**2 - 1371.85*T*LN(T) + 7758.85593*T -
   219408.801; 453.15 Y 5.18835E-5*T**3 - 0.2531915*T**2 + 202.958*T*LN(T) -
   1336.35027*T + 92539.872 - 8202200*T**(-1); 717.0 Y -32*T*LN(T) +
   176.37082*T - 6889.972; 6000.0 N !
FUNCTION GTI2NI 273.0 2.85345219*T + 0.33333*GHSERNIA# + 0.66666667*GHSERTIA#
   - 27514.218; 6000.0 N !
FUNCTION GTI2O3 273.0 -5.93279345E-6*T**3 - 0.099958898*T**2 -
   30.3934128*T*LN(T) + 185.96227*T - 1543640 - 117799.056*T**(-1); 470.0 Y
   -1.53383348E-10*T**3 - 0.00173711312*T**2 - 147.673862*T*LN(T) + 937.087*T
   - 1585377.8 + 2395423.68*T**(-1); 6000.0 N !
FUNCTION GTIBCC 273.0 -3.85519E-7*T**3 + 0.00411413*T**2 - 1.5835*T*LN(T) +
   1.098972*T + GHSERTI# + 6787.856 - 65428*T**(-1); 900.0 Y -1.87927E-7*T**3
   + 0.003539455*T**2 - 1.5881*T*LN(T) + 1.726111*T + GHSERTI# + 6539.75 -
   35472*T**(-1); 1155.0 Y -1.048055E-6*T**3 + 0.00936357*T**2 -
   7.4305*T*LN(T) + 38.389841*T + GHSERTI# + 5758.548 - 525090*T**(-1);
   1941.0 Y 1.533611E-6*T**3 - 0.030213169*T**2 + 106.3083366*T*LN(T) -
   821.233343*T + GHSERTI# + 151010.046 - 35299304*T**(-1); 4000.0 N !
FUNCTION GTIC 273.0 -0.0044617*T**2 - 42.248*T*LN(T) + 258*T - 175000 +
   31263*T**(-1) + 6960000000.0*T**(-3); 6000.0 N !
FUNCTION GTIFCC 273.0 -0.1*T + GHSERTI# + 6000; 6000.0 N !
FUNCTION GTIFCCA 273.0 -0.1*T + GHSERTIA# + 6000; 6000.0 N !
FUNCTION GTIN 273.0 -0.00092840476*T**2 - 52.458723*T*LN(T) + 330.4982*T -
   357905 + 871489.25*T**(-1) - 2413972100.0*T**(-3); 6000.0 N !
FUNCTION GTRID 273.0 -2.2791833E-5*T**3 - 0.0148714*T**2 - 25.1574*T*LN(T) +
   140.55925*T - 918008.73 + 66331*T**(-1); 388.0 Y -1.6835E-7*T**3 -
   0.02368535*T**2 - 37.8701*T*LN(T) + 224.53808*T - 921013.31; 433.0 Y
   4.6255E-6*T**3 - 0.03049985*T**2 - 35.605*T*LN(T) + 210.51651*T -
   919633.42 - 162026*T**(-1); 900.0 Y -3.786883E-6*T**3 + 0.03387055*T**2 -
   128.434*T*LN(T) + 848.3098*T - 979377.7 + 7070800*T**(-1); 1668.0 Y
   -4.63118E-7*T**3 + 0.003040245*T**2 - 77.5875*T*LN(T) + 493.58035*T -
   943685.26 + 2227125*T**(-1); 3300.0 Y -87.373*T*LN(T) + 587.37585*T -
   974449.74; 6000.0 N !
FUNCTION GVM23C6 273.0 -728.829*T*LN(T) + 4330.63*T - 990367 +
   5003425*T**(-1); 6000.0 N !
FUNCTION GWFCC 273.0 0.63*T + GHSERWW# + 19300; 6000.0 N !
FUNCTION GY2O3C 273.0 -0.00558*T**2 - 125.692*T*LN(T) + 763.71851*T - 1984291
   + 2344020.5*T**(-1) - 117305560.0*T**(-2); 6000.0 N !
FUNCTION GY2O3H 273.0 -0.00558*T**2 - 125.692*T*LN(T) + 754.10313*T - 1959291
   + 2344020.5*T**(-1) - 117305560.0*T**(-2); 6000.0 N !
FUNCTION GYYBCC 273.0 7.47591E-7*T**3 - 0.004150358*T**2 + 2.927924*T*LN(T) -
   20.009726*T + GHSERYY# + 5485.858 - 37863*T**(-1); 1500.0 Y
   1.900536E-6*T**3 - 0.014805333*T**2 + 19.344524*T*LN(T) - 132.309319*T +
   GHSERYY# + 13941.422 - 54349*T**(-1); 1752.0 Y 1.14182E-6*T**3 -
   0.0068095*T**2 + 5.265*T*LN(T) - 34.089733*T + GHSERYY# + 5594.895; 1799.0
   Y 9.13936E-7*T**3 - 0.0223552*T**2 + 98.0154419*T*LN(T) - 780.053385*T +
   GHSERYY# + 177760.169 - 52416530*T**(-1); 6000.0 N !
FUNCTION L04ALNI 273.0 U3ALNI#; 6000.0 N !
FUNCTION L14ALNI 273.0 U4ALNI#; 6000.0 N !
FUNCTION LB2ALNI 273.0 11.30117*T - 52440.88; 6000.0 N !
FUNCTION LB2NIVA 273.0 26.49419*T - 64024.38; 6000.0 N !
FUNCTION LF0 273.0 -11.7930695*T - 20455.7462; 6000.0 N !
FUNCTION LF1 273.0 15581.5125 - 8.49116947*T; 6000.0 N !
FUNCTION LFESIB0 273.0 11.62*T - 27809; 6000.0 N !
FUNCTION LFESIB1 273.0 -23088; 6000.0 N !
FUNCTION LFESIB2 273.0 3890; 6000.0 N !
FUNCTION LRMNNI 273.0 -6829.00181; 6000.0 N !
FUNCTION MCEX 273.0 -1.0E-5*T**3 + 0.005*T**2 - 6*T*LN(T) + 75*T + 355000 +
   950000*T**(-1); 1000.0 N !
FUNCTION U1ALNI 273.0 0.666666667*UALNI#; 6000.0 N !
FUNCTION U3ALNI 273.0 1.0E-8; 6000.0 N !
FUNCTION U4ALNI 273.0 7203.60609 - 3.7427303*T; 6000.0 N !
FUNCTION UALNI 273.0 4.39570389*T - 22212.8931; 6000.0 N !
FUNCTION UNDEF 273.0 1.0E-8; 6000.0 N !

TYPE_DEFINITION % SEQ * !
DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
DEFAULT_COMMAND DEFINE_SYSTEM_ELEMENT VA !

TYPE_DEFINITION ^ GES AMEND_PHASE_DESCRIPTION ALPHA_MN MAGNETIC -3.0 0.28 !
TYPE_DEFINITION & GES AMEND_PHASE_DESCRIPTION BCC_A2 MAGNETIC -1.0 0.4 !
TYPE_DEFINITION * GES AMEND_PHASE_DESCRIPTION BCC_DISL MAGNETIC -1.0 0.4 !
TYPE_DEFINITION ( GES AMEND_PHASE_DESCRIPTION CEMENTITE MAGNETIC -3.0 0.28 !
TYPE_DEFINITION ) GES AMEND_PHASE_DESCRIPTION CORUND MAGNETIC -3.0 0.28 !
TYPE_DEFINITION ' GES AMEND_PHASE_DESCRIPTION FCC_A1 MAGNETIC -3.0 0.28 !
TYPE_DEFINITION A GES AMEND_PHASE_DESCRIPTION FEB MAGNETIC -3.0 0.28 !
TYPE_DEFINITION B GES AMEND_PHASE_DESCRIPTION HCP_A3 MAGNETIC -3.0 0.28 !
TYPE_DEFINITION C GES AMEND_PHASE_DESCRIPTION H_BCC MAGNETIC -1.0 0.4 !
TYPE_DEFINITION D GES AMEND_PHASE_DESCRIPTION M2B MAGNETIC -3.0 0.28 !
TYPE_DEFINITION E GES AMEND_PHASE_DESCRIPTION PDFE_L12 MAGNETIC -3.0 0.28 !
TYPE_DEFINITION F GES AMEND_PHASE_DESCRIPTION PDMN_P MAGNETIC -3.0 0.28 !
PHASE ALN %  2 1.0 1.0 !
CONSTITUENT ALN :AL:N: !

PHASE ALN_EQU %  2 1.0 1.0 !
CONSTITUENT ALN_EQU :AL,CR:N: !

PHASE ALPHA_MN %^  2 1.0 1.0 !
CONSTITUENT ALPHA_MN :AL,CO,CR,CU,FE,MN,MO,NI,PD,SI,V:C,N,VA: !

PHASE ANILITE %  2 1.75 1.0 !
CONSTITUENT ANILITE :CU:S: !

PHASE A_CHALC %  2 2.0 1.0 !
CONSTITUENT A_CHALC :CU:S: !

PHASE BCC_A2 %&  2 1.0 3.0 !
CONSTITUENT BCC_A2
   :AL,CO,CR,CU,FE,HF,LA,MN,MO,NB,NI,P,PD,S,SI,TI,V,W,Y:B,C,H,N,O,VA: !

PHASE BCC_B2 %  3 0.5 0.5 3.0 !
CONSTITUENT BCC_B2
   :AL,CO,CR,FE,MN,MO,NI,SI,TI:AL,CO,CR,FE,MN,MO,NI,SI,TI:C,VA: !

PHASE BCC_DISL %*  2 1.0 3.0 !
CONSTITUENT BCC_DISL :AL,CO,CR,CU,FE,MN,MO,NB,NI,S,SI,TI,V,W:B,C,N,VA: !

PHASE BETA_MN %  2 1.0 1.0 !
CONSTITUENT BETA_MN :AL,CO,CR,CU,FE,MN,MO,NI,PD,SI,V:C,N,VA: !

PHASE BETA_RHOMBO_B %  1 1.0 !
CONSTITUENT BETA_RHOMBO_B :B,CU,MN,NB,TI: !

PHASE BN_HP4 %  2 1.0 1.0 !
CONSTITUENT BN_HP4 :B:N: !

PHASE B_CHALC %  2 2.0 1.0 !
CONSTITUENT B_CHALC :CU:S: !

PHASE CEMENTITE %(  2 3.0 1.0 !
CONSTITUENT CEMENTITE :AL,CO,CR,CU,FE,MN,MO,NB,NI,SI,V,W:B,C,N: !

PHASE CHI_A12 %  4 24.0 10.0 24.0 2.0 !
CONSTITUENT CHI_A12 :FE:CR,MO,W:CR,FE,MO,NI,SI,W:C,VA: !

PHASE CO3MO %  2 3.0 1.0 !
CONSTITUENT CO3MO :CO:MO,W: !

PHASE CO3V %  2 3.0 1.0 !
CONSTITUENT CO3V :CO:V: !

PHASE CORUND %)  2 2.0 3.0 !
CONSTITUENT CORUND :AL,CR,FE,NI:O: !

PHASE COV3 %  2 1.0 3.0 !
CONSTITUENT COV3 :CO:V: !

PHASE COVELLITE %  2 1.0 1.0 !
CONSTITUENT COVELLITE :CU:S: !

PHASE CR2B %  2 0.666667 0.333333 !
CONSTITUENT CR2B :CR,FE,MN:B: !

PHASE CR2VC2 %  3 2.0 1.0 2.0 !
CONSTITUENT CR2VC2 :CR:V:C: !

PHASE CR3MN5 %  2 3.0 5.0 !
CONSTITUENT CR3MN5 :CR:MN: !

PHASE CR3NI2SIN %  4 3.0 2.0 1.0 1.0 !
CONSTITUENT CR3NI2SIN :CR,MO:FE,NI:SI:C,N: !

PHASE CR5B3 %  2 0.625 0.375 !
CONSTITUENT CR5B3 :CR:B: !

PHASE CRB %  2 0.5 0.5 !
CONSTITUENT CRB :CR,FE,NI:B: !

PHASE CU2S %  3 2.0 1.0 1.0 !
CONSTITUENT CU2S :CU,FE:S:S,VA: !

PHASE DIAMOND_A4 %  1 1.0 !
CONSTITUENT DIAMOND_A4 :AL,B,C,SI,TI: !

PHASE DIGENITE %  3 2.0 1.0 1.0 !
CONSTITUENT DIGENITE :CU,FE,VA:CU,VA:S: !

PHASE DISULF %  2 1.0 2.0 !
CONSTITUENT DISULF :FE:S: !

PHASE DJURLEITE %  2 1.93 1.0 !
CONSTITUENT DJURLEITE :CU:S: !

PHASE EPS_CARB %  2 6.0 3.0 !
CONSTITUENT EPS_CARB :AL,CO,CR,CU,FE,MN,MO,NB,NI,SI,TI,V,W:C,VA: !

PHASE ETA %  2 3.0 1.0 !
CONSTITUENT ETA :AL,FE,NI,TI:AL,FE,NI,TI: !

PHASE ETA_CARB %  2 6.0 3.0 !
CONSTITUENT ETA_CARB :AL,CO,CR,CU,FE,MN,MO,NB,NI,SI,TI,V,W:C,VA: !

PHASE FCC_A1 %'  2 1.0 1.0 !
CONSTITUENT FCC_A1
   :AL,CO,CR,CU,FE,HF,LA,MN,MO,NB,NI,P,PD,S,SI,TI,V,W,Y:B,C,H,N,O,VA: !

PHASE FC_MONO %  1 1.0 !
CONSTITUENT FC_MONO :S: !

PHASE FC_ORTHO %  1 1.0 !
CONSTITUENT FC_ORTHO :S: !

PHASE FE17Y2 %  2 0.895 0.105 !
CONSTITUENT FE17Y2 :FE:Y: !

PHASE FE24C10 %  2 24.0 10.0 !
CONSTITUENT FE24C10 :AL,CO,CR,CU,FE,MN,MO,NB,NI,SI,TI,V,W:C,VA: !

PHASE FE3NB3B4 %  3 3.0 3.0 4.0 !
CONSTITUENT FE3NB3B4 :FE:NB:B: !

PHASE FE4N %  2 4.0 1.0 !
CONSTITUENT FE4N :CR,FE,MN,NI:N: !

PHASE FEB %A  2 0.5 0.5 !
CONSTITUENT FEB :CR,FE,MN,NI:B: !

PHASE FENBB %  3 1.0 1.0 1.0 !
CONSTITUENT FENBB :FE:NB:B: !

PHASE FES_P %  2 1.0 1.0 !
CONSTITUENT FES_P :FE,MN:S: !

PHASE GRAPHITE %  1 1.0 !
CONSTITUENT GRAPHITE :B,C: !

PHASE G_PHASE %  3 16.0 6.0 7.0 !
CONSTITUENT G_PHASE :CO,NI:CR,FE,MN,NB,TI:SI: !

PHASE HALITE %  2 1.0 1.0 !
CONSTITUENT HALITE :AL,CR,FE,NI:O: !

PHASE HCP_A3 %B  2 1.0 0.5 !
CONSTITUENT HCP_A3 :AL,CO,CR,CU,FE,HF,MN,MO,NB,NI,PD,SI,TI,V,W,Y:B,C,N,O,VA: !

PHASE HF1O2_C %  2 0.33333 0.66667 !
CONSTITUENT HF1O2_C :HF:O: !

PHASE HF1O2_M %  2 0.33333 0.66667 !
CONSTITUENT HF1O2_M :HF:O: !

PHASE HF1O2_T %  2 0.33333 0.66667 !
CONSTITUENT HF1O2_T :HF:O: !

PHASE H_BCC %C  2 1.0 1.0 !
CONSTITUENT H_BCC :FE:H,VA: !

PHASE KSI_CARBIDE %  2 3.0 1.0 !
CONSTITUENT KSI_CARBIDE :AL,CO,CR,CU,FE,MN,MO,NB,NI,SI,TI,V,W:C,VA: !

PHASE KSI_FE5C2 %  2 5.0 2.0 !
CONSTITUENT KSI_FE5C2 :AL,CO,CR,CU,FE,MN,MO,NB,NI,SI,TI,V,W:C,VA: !

PHASE K_CARB %  3 3.0 1.0 1.0 !
CONSTITUENT K_CARB :FE,MN:AL:C,VA: !

PHASE LA2O3_A %  2 2.0 3.0 !
CONSTITUENT LA2O3_A :LA:O: !

PHASE LA2O3_C %  2 2.0 3.0 !
CONSTITUENT LA2O3_C :LA:O: !

PHASE LA2O3_H %  2 2.0 3.0 !
CONSTITUENT LA2O3_H :LA:O: !

PHASE LAVES_PHASE %  2 2.0 1.0 !
CONSTITUENT LAVES_PHASE
   :CO,CR,FE,MN,MO,NB,NI,SI,TI,V,W:CO,CR,FE,MN,MO,NB,NI,SI,TI,V,W: !

PHASE LIQUID %  1 1.0 !
CONSTITUENT LIQUID
   :AL,B,C,CO,CR,CU,FE,HF,LA,MN,MO,N,NB,NI,P,PD,S,SI,TI,V,W,Y: !

PHASE M12C %  3 6.0 6.0 1.0 !
CONSTITUENT M12C :CO:W:C: !

PHASE M23C6 %  3 20.0 3.0 6.0 !
CONSTITUENT M23C6 :CO,CR,FE,MN,NI,V:CO,CR,FE,MN,MO,NI,V,W:B,C: !

PHASE M2B %D  2 0.666667 0.333333 !
CONSTITUENT M2B :CR,FE,MN,MO,NI:B: !

PHASE M2P %  2 2.0 1.0 !
CONSTITUENT M2P :CR,FE,NB,TI:P: !

PHASE M3C2 %  2 3.0 2.0 !
CONSTITUENT M3C2 :CR,MO,V:C: !

PHASE M3P %  2 3.0 1.0 !
CONSTITUENT M3P :CR,FE,NB,TI:P: !

PHASE M5B6 %  2 5.0 6.0 !
CONSTITUENT M5B6 :FE,NB,V:B: !

PHASE M6C %  4 2.0 2.0 2.0 1.0 !
CONSTITUENT M6C :CO,FE,NI:CR,MO,W:CO,CR,FE,MO,NI,SI,V,W:C: !

PHASE M7C3 %  2 7.0 3.0 !
CONSTITUENT M7C3 :CO,CR,FE,MN,MO,NI,SI,V,W:C: !

PHASE MN3B4 %  2 0.428571 0.571429 !
CONSTITUENT MN3B4 :MN:B: !

PHASE MN6N4 %  2 6.0 4.0 !
CONSTITUENT MN6N4 :MN:N: !

PHASE MN6N5 %  2 6.0 5.0 !
CONSTITUENT MN6N5 :MN:N: !

PHASE MNB2 %  2 0.333333 0.666667 !
CONSTITUENT MNB2 :MN:B: !

PHASE MNB4 %  2 0.2 0.8 !
CONSTITUENT MNB4 :MN:B: !

PHASE MNNI %  2 0.5 0.5 !
CONSTITUENT MNNI :CU,MN,NI:CU,MN,NI: !

PHASE MNNI2 %  2 1.0 2.0 !
CONSTITUENT MNNI2 :MN,NI:NI: !

PHASE MNNI_T3 %  3 0.2069 0.5517 0.2414 !
CONSTITUENT MNNI_T3 :MN:NI:SI: !

PHASE MNSIN2 %  3 0.25 0.25 0.5 !
CONSTITUENT MNSIN2 :MN:SI:N: !

PHASE MNS_Q %  2 1.0 1.0 !
CONSTITUENT MNS_Q :CU,FE,MN:S: !

PHASE MO2M1B2 %  3 2.0 1.0 2.0 !
CONSTITUENT MO2M1B2 :MO:CR,FE:B: !

PHASE MOB %  2 0.5 0.5 !
CONSTITUENT MOB :MO:B: !

PHASE MOB2 %  2 1.0 2.0 !
CONSTITUENT MOB2 :MO:B,VA: !

PHASE MOC_ETA %  2 1.0 1.0 !
CONSTITUENT MOC_ETA :MO:C,VA: !

PHASE MU_PHASE %  3 7.0 2.0 4.0 !
CONSTITUENT MU_PHASE :CO,CR,FE,MN,MO,NB,NI,SI:MO,NB,W:CO,CR,FE,MO,NB,NI,SI,W:
   !

PHASE MU_PHASE_I %  4 6.0 1.0 2.0 4.0 !
CONSTITUENT MU_PHASE_I :CO,FE,MO:CO,FE,MO,SI:CO,FE,MO,SI:CO,FE,MO: !

PHASE NB3B2 %  2 3.0 2.0 !
CONSTITUENT NB3B2 :FE,NB:B: !

PHASE NBB %  2 1.0 1.0 !
CONSTITUENT NBB :NB:B,NB: !

PHASE NI5Y %  2 5.0 1.0 !
CONSTITUENT NI5Y :NI:Y: !

PHASE NITI2 %  2 2.0 1.0 !
CONSTITUENT NITI2 :NI,TI:NI,TI: !

PHASE O1_GAS %  1 1.0 !
CONSTITUENT O1_GAS :O: !

PHASE O_MN2B %  2 0.670691 0.329309 !
CONSTITUENT O_MN2B :MN:B: !

PHASE PD2MN %  2 0.3333 0.6667 !
CONSTITUENT PD2MN :MN:PD: !

PHASE PD3MN %  2 0.25 0.75 !
CONSTITUENT PD3MN :MN,PD:MN,PD: !

PHASE PD5MN3 %  2 0.375 0.625 !
CONSTITUENT PD5MN3 :MN:PD: !

PHASE PD6FE5MN2 %  3 0.3846 0.46154 0.15385 !
CONSTITUENT PD6FE5MN2 :FE:PD:MN: !

PHASE PDFE_L12 %E  2 0.25 0.75 !
CONSTITUENT PDFE_L12 :FE,MN,PD:FE,MN,PD: !

PHASE PDMN_AF %  2 0.5 0.5 !
CONSTITUENT PDMN_AF :MN,PD:MN,PD: !

PHASE PDMN_B2 %  2 0.5 0.5 !
CONSTITUENT PDMN_B2 :FE,MN,PD:FE,MN,PD: !

PHASE PDMN_P %F  2 0.5 0.5 !
CONSTITUENT PDMN_P :FE,MN,PD:FE,MN,PD: !

PHASE PI_PHASE %  3 7.0 13.0 4.0 !
CONSTITUENT PI_PHASE :FE,NI:CR,MO:N: !

PHASE PYRR %  2 1.0 1.0 !
CONSTITUENT PYRR :CU,FE,VA:S: !

PHASE R_PHASE %  3 27.0 14.0 12.0 !
CONSTITUENT R_PHASE :CR,FE,MN:MN,MO:CR,FE,MN,MO,NI,SI: !

PHASE SI3N4 %  2 3.0 4.0 !
CONSTITUENT SI3N4 :SI:N: !

PHASE SIGMA %  3 8.0 4.0 18.0 !
CONSTITUENT SIGMA :CO,FE,MN,NI:CR,MO,V:CO,CR,FE,MN,MO,NI,SI,V: !

PHASE SIO2 %  2 1.0 2.0 !
CONSTITUENT SIO2 :SI:O: !

PHASE SPINEL %  3 1.0 2.0 4.0 !
CONSTITUENT SPINEL :AL,CR,FE,NI:AL,CR,FE,NI:O: !

PHASE TI2O3 %  2 2.0 3.0 !
CONSTITUENT TI2O3 :TI:O: !

PHASE TI3B4 %  2 3.0 4.0 !
CONSTITUENT TI3B4 :CR,FE,NB,TI:B: !

PHASE TI4C2S2 %  3 4.0 2.0 2.0 !
CONSTITUENT TI4C2S2 :TI:C:S: !

PHASE TIB %  2 1.0 1.0 !
CONSTITUENT TIB :TI:B,TI: !

PHASE TIB2 %  2 1.0 2.0 !
CONSTITUENT TIB2 :B,CR,FE,TI:B,CR,FE,TI,VA: !

PHASE TIO2 %  2 1.0 2.0 !
CONSTITUENT TIO2 :TI:O: !

PHASE TIS %  2 1.0 1.0 !
CONSTITUENT TIS :TI:S: !

PHASE TRID %  2 1.0 2.0 !
CONSTITUENT TRID :SI:O: !

PHASE V3C2 %  2 3.0 2.0 !
CONSTITUENT V3C2 :V:C: !

PHASE WC %  2 1.0 1.0 !
CONSTITUENT WC :MO,W:C: !

PHASE Y2O3_C %  2 2.0 3.0 !
CONSTITUENT Y2O3_C :Y:O: !

PHASE Y2O3_H %  2 2.0 3.0 !
CONSTITUENT Y2O3_H :Y:O: !

PHASE Y2TI2O7 %  3 2.0 2.0 7.0 !
CONSTITUENT Y2TI2O7 :Y:TI:O: !

PHASE Y2TIO5 %  3 2.0 1.0 5.0 !
CONSTITUENT Y2TIO5 :Y:TI:O: !

PHASE Y4AL2O9 %  3 4.0 2.0 9.0 !
CONSTITUENT Y4AL2O9 :Y:AL:O: !

PHASE YALO3 %  3 1.0 1.0 3.0 !
CONSTITUENT YALO3 :Y:AL:O: !

PHASE ZET %  3 1.0 1.0 1.0 !
CONSTITUENT ZET :CR,FE:MO,NB,V:N,VA: !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     CO                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(ALPHA_MN,CO:VA;0) 273.0 GHSERCO# + 3000; 6000.0 N !
PARAMETER BMAGN(BCC_A2,CO:VA;0) 273.0 1.35; 6000.0 N !
PARAMETER G(BCC_A2,CO:VA;0) 273.0 GCOBCC#; 6000.0 N !
PARAMETER TC(BCC_A2,CO:VA;0) 273.0 1450; 6000.0 N !
PARAMETER G(BETA_MN,CO:VA;0) 273.0 GHSERCO# + 3000; 6000.0 N !
PARAMETER G(EPS_CARB,CO:VA;0) 273.0 6*GHSERCO# + 300000; 6000.0 N !
PARAMETER G(ETA_CARB,CO:VA;0) 273.0 6*GHSERCO# + 300000; 6000.0 N !
PARAMETER BMAGN(FCC_A1,CO:VA;0) 273.0 1.35; 6000.0 N !
PARAMETER G(FCC_A1,CO:VA;0) 273.0 GCOFCC#; 6000.0 N !
PARAMETER TC(FCC_A1,CO:VA;0) 273.0 1396; 6000.0 N !
PARAMETER G(FE24C10,CO:VA;0) 273.0 24*GHSERCO# + 300000; 6000.0 N !
PARAMETER BMAGN(HCP_A3,CO:VA;0) 273.0 1.35; 6000.0 N !
PARAMETER G(HCP_A3,CO:VA;0) 273.0 GHSERCO#; 6000.0 N !
PARAMETER TC(HCP_A3,CO:VA;0) 273.0 1396; 6000.0 N !
PARAMETER G(KSI_CARBIDE,CO:VA;0) 273.0 3*GHSERCO# + 300000; 6000.0 N !
PARAMETER G(KSI_FE5C2,CO:VA;0) 273.0 5*GHSERCO# + 300000; 6000.0 N !
PARAMETER G(LAVES_PHASE,CO:CO;0) 273.0 3*GHSERCO# + 15000; 6000.0 N !
PARAMETER G(LIQUID,CO;0) 273.0 -2.19801E-21*T**7 - 8.931932*T + GHSERCO# +
   15085.037; 1768.0 Y -9.683796*T + GHSERCO# + 16351.056 -
   9.3488E+30*T**(-9); 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     CR                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(ALPHA_MN,CR:VA;0) 273.0 2.7196*T + GHSERCR# + 11087.0; 6000.0 N !
PARAMETER BMAGN(BCC_A2,CR:VA;0) 273.0 -0.008; 6000.0 N !
PARAMETER G(BCC_A2,CR:VA;0) 273.0 GHSERCR#; 6000.0 N !
PARAMETER TC(BCC_A2,CR:VA;0) 273.0 -311.5; 6000.0 N !
PARAMETER G(BCC_B2,CR:CR:VA;0) 273.0 1.0E-8; 6000.0 N !
PARAMETER G(BETA_MN,CR:VA;0) 273.0 0.6276*T + GHSERCR# + 15899.0; 6000.0 N !
PARAMETER G(EPS_CARB,CR:VA;0) 273.0 6*GHSERCR# + 300000; 6000.0 N !
PARAMETER G(ETA_CARB,CR:VA;0) 273.0 6*GHSERCR# + 300000; 6000.0 N !
PARAMETER BMAGN(FCC_A1,CR:VA;0) 273.0 -2.46; 6000.0 N !
PARAMETER G(FCC_A1,CR:VA;0) 273.0 0.163*T + GHSERCR# + 7284; 6000.0 N !
PARAMETER TC(FCC_A1,CR:VA;0) 273.0 -1109; 6000.0 N !
PARAMETER G(FE24C10,CR:VA;0) 273.0 24*GHSERCR# + 300000; 6000.0 N !
PARAMETER BMAGN(HCP_A3,CR:VA;0) 273.0 -2.46; 6000.0 N !
PARAMETER G(HCP_A3,CR:VA;0) 273.0 GHSERCR# + 4438; 6000.0 N !
PARAMETER TC(HCP_A3,CR:VA;0) 273.0 -1109; 6000.0 N !
PARAMETER G(KSI_CARBIDE,CR:VA;0) 273.0 3*GHSERCR# + 300000; 6000.0 N !
PARAMETER G(KSI_FE5C2,CR:VA;0) 273.0 5*GHSERCR# + 300000; 6000.0 N !
PARAMETER G(LAVES_PHASE,CR:CR;0) 273.0 3*GHSERCR# + 86000; 6000.0 N !
PARAMETER G(LIQUID,CR;0) 273.0 2.37615E-21*T**7 - 11.420225*T + GHSERCR# +
   24339.955; 2180.0 Y -8.563683*T + GHSERCR# + 18409.36 +
   2.88526E+32*T**(-9); 6000.0 N !
PARAMETER G(TIB2,CR:CR;0) 273.0 3*GHSERCR# + 18000; 6000.0 N !
PARAMETER G(TIB2,CR:VA;0) 273.0 GHSERCR# + 150000; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     FE                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(ALPHA_MN,FE:VA;0) 273.0 GHSERFE# + 4745; 6000.0 N !
PARAMETER BMAGN(BCC_A2,FE:VA;0) 273.0 2.22; 6000.0 N !
PARAMETER G(BCC_A2,FE:VA;0) 273.0 GHSERFE#; 6000.0 N !
PARAMETER TC(BCC_A2,FE:VA;0) 273.0 1043; 6000.0 N !
PARAMETER G(BETA_MN,FE:VA;0) 273.0 GHSERFE# + 3745; 6000.0 N !
PARAMETER G(EPS_CARB,FE:VA;0) 273.0 6*GHSERFE# + 300000; 6000.0 N !
PARAMETER G(ETA,FE:FE;0) 273.0 4*GHSERFE# + 1000; 6000.0 N !
PARAMETER G(ETA_CARB,FE:VA;0) 273.0 6*GHSERFE# + 500000; 6000.0 N !
PARAMETER BMAGN(FCC_A1,FE:VA;0) 273.0 -2.1; 6000.0 N !
PARAMETER G(FCC_A1,FE:VA;0) 273.0 0.00064*T**2 - 1.15*T*LN(T) + 8.282*T +
   GHSERFE# - 1462.4; 1811.0 Y 0.94001*T + GHSERFE# - 1713.815 +
   4.925095E+30*T**(-9); 6000.0 N !
PARAMETER TC(FCC_A1,FE:VA;0) 273.0 -201; 6000.0 N !
PARAMETER G(FE24C10,FE:VA;0) 273.0 24*GHSERFE# + 300000; 6000.0 N !
PARAMETER G(HCP_A3,FE:VA;0) 273.0 0.00064*T**2 - 1.15*T*LN(T) + 12.591*T +
   GHSERFE# - 3705.78; 1811.0 Y 5.24951*T + GHSERFE# - 3957.199 +
   4.9251E+30*T**(-9); 6000.0 N !
PARAMETER BMAGN(H_BCC,FE:VA;0) 273.0 2.22; 6000.0 N !
PARAMETER G(H_BCC,FE:VA;0) 273.0 GHSERFE#; 6000.0 N !
PARAMETER TC(H_BCC,FE:VA;0) 273.0 1043; 6000.0 N !
PARAMETER G(KSI_CARBIDE,FE:VA;0) 273.0 3*GHSERFE# + 300000; 6000.0 N !
PARAMETER G(KSI_FE5C2,FE:VA;0) 273.0 5*GHSERFE# + 300000; 6000.0 N !
PARAMETER G(LAVES_PHASE,FE:FE;0) 273.0 3*GHSERFE# + 61970; 6000.0 N !
PARAMETER G(LIQUID,FE;0) 273.0 -3.6751551E-21*T**7 - 6.55843*T + GHSERFE# +
   12040.17; 1811.0 Y -46*T*LN(T) + 291.302*T - 10839.7; 6000.0 N !
PARAMETER G(MU_PHASE_I,FE:FE:FE:FE;0) 273.0 7*GFEFCC# + 6*GHSERFE# + 100000;
   6000.0 N !
PARAMETER BMAGN(PDFE_L12,FE:FE;0) 273.0 0.7; 6000.0 N !
PARAMETER G(PDFE_L12,FE:FE;0) 273.0 GFEFCC# + 100; 6000.0 N !
PARAMETER TC(PDFE_L12,FE:FE;0) 273.0 67; 6000.0 N !
PARAMETER G(PDMN_B2,FE:FE;0) 273.0 GHSERFE# + 20000; 6000.0 N !
PARAMETER BMAGN(PDMN_P,FE:FE;0) 273.0 0.7; 6000.0 N !
PARAMETER G(PDMN_P,FE:FE;0) 273.0 GHSERFE# + 10000; 6000.0 N !
PARAMETER TC(PDMN_P,FE:FE;0) 273.0 67; 6000.0 N !
PARAMETER G(TIB2,FE:FE;0) 273.0 3*GHSERFE# + 18000; 6000.0 N !
PARAMETER G(TIB2,FE:VA;0) 273.0 GHSERFE# + 150000; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     NB                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(BCC_A2,NB:VA;0) 273.0 GHSERNB#; 6000.0 N !
PARAMETER G(BETA_RHOMBO_B,NB;0) 273.0 GHSERNB# + 10000; 6000.0 N !
PARAMETER G(EPS_CARB,NB:VA;0) 273.0 6*GHSERNB# + 300000; 6000.0 N !
PARAMETER G(ETA_CARB,NB:VA;0) 273.0 6*GHSERNB# + 300000; 6000.0 N !
PARAMETER G(FCC_A1,NB:VA;0) 273.0 1.7*T + GHEXTNB# + 13500; 5000.0 N !
PARAMETER G(FE24C10,NB:VA;0) 273.0 24*GHSERNB# + 300000; 6000.0 N !
PARAMETER G(HCP_A3,NB:VA;0) 273.0 2.4*T + GHEXTNB# + 10000; 6000.0 N !
PARAMETER G(KSI_CARBIDE,NB:VA;0) 273.0 3*GHSERNB# + 300000; 6000.0 N !
PARAMETER G(KSI_FE5C2,NB:VA;0) 273.0 5*GHSERNB# + 300000; 6000.0 N !
PARAMETER G(LAVES_PHASE,NB:NB;0) 273.0 3*GHSERNB# + 15000; 6000.0 N !
PARAMETER G(LIQUID,NB;0) 273.0 -3.06098E-23*T**7 - 10.816417*T + GHSERNB# +
   29781.555; 2750.0 Y -10.964695*T + GHSERNB# + 30169.901 -
   1.528238E+32*T**(-9); 6000.0 N !
PARAMETER G(MU_PHASE,NB:NB:NB;0) 273.0 13*GHSERNB# + 65000; 6000.0 N !
PARAMETER G(NBB,NB:NB;0) 273.0 2*GHSERNB# + 75000; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                     TI                                     $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(BCC_A2,TI:VA;0) 273.0 GTIBCC#; 6000.0 N !
PARAMETER G(BETA_RHOMBO_B,TI;0) 273.0 GHSERTI# + 10000; 6000.0 N !
PARAMETER G(DIAMOND_A4,TI;0) 273.0 GHSERTI# + 25000; 6000.0 N !
PARAMETER G(EPS_CARB,TI:VA;0) 273.0 6*GHSERTI# + 300000; 6000.0 N !
PARAMETER G(ETA,TI:TI;0) 273.0 4*GDHCTI# + 5000; 6000.0 N !
PARAMETER G(ETA_CARB,TI:VA;0) 273.0 6*GHSERTI# + 300000; 6000.0 N !
PARAMETER G(FCC_A1,TI:VA;0) 273.0 -0.1*T + GHSERTI# + 6000; 3000.0 N !
PARAMETER G(FE24C10,TI:VA;0) 273.0 24*GHSERTI# + 300000; 6000.0 N !
PARAMETER G(HCP_A3,TI:VA;0) 273.0 GHSERTI#; 4000.0 N !
PARAMETER G(KSI_CARBIDE,TI:VA;0) 273.0 3*GHSERTI# + 300000; 6000.0 N !
PARAMETER G(KSI_FE5C2,TI:VA;0) 273.0 5*GHSERTI# + 300000; 6000.0 N !
PARAMETER G(LAVES_PHASE,TI:TI;0) 273.0 3*GHSERTI# + 15000; 6000.0 N !
PARAMETER G(LIQUID,TI;0) 273.0 -6.980938*T + GHSERTI# + 12194.415; 1300.0 Y
   1.2254402E-5*T**3 - 0.155262855*T**2 + 357.005867*T*LN(T) - 2620.9995038*T
   + GHSERTI# + 368610.36 - 65556856*T**(-1); 1941.0 Y 3.04747E-7*T**3 -
   0.01*T**2 + 40.9282461*T*LN(T) - 340.070171*T + GHSERTI# + 111400 -
   36699805*T**(-1); 4000.0 N !
PARAMETER G(TIB,TI:TI;0) 273.0 2*GHSERTI# + 40000; 6000.0 N !
PARAMETER G(TIB2,TI:TI;0) 273.0 3*GHSERTI# + 18000; 6000.0 N !
PARAMETER G(TIB2,TI:VA;0) 273.0 GHSERTI# + 150000; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   CO-CR                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,CO,CR:VA;0) 273.0 17208 - 13.519*T; 6000.0 N !
PARAMETER L(BCC_A2,CO,CR:VA;1) 273.0 -5470; 6000.0 N !
PARAMETER L(FCC_A1,CO,CR:VA;0) 273.0 1500 - 9.592*T; 6000.0 N !
PARAMETER TC(FCC_A1,CO,CR:VA;0) 273.0 -1795; 6000.0 N !
PARAMETER L(HCP_A3,CO,CR:VA;0) 273.0 -6436; 6000.0 N !
PARAMETER TC(HCP_A3,CO,CR:VA;0) 273.0 -1795; 6000.0 N !
PARAMETER G(LAVES_PHASE,CO:CR;0) 273.0 2*GHSERCO# + GHSERCR# + 15000; 6000.0
   N !
PARAMETER G(LAVES_PHASE,CR:CO;0) 273.0 GHSERCO# + 2*GHSERCR# + 15000; 6000.0
   N !
PARAMETER L(LAVES_PHASE,*:CO,CR;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,CO,CR:*;0) 273.0 70000; 6000.0 N !
PARAMETER L(LIQUID,CO,CR;0) 273.0 -5.624*T - 3034; 6000.0 N !
PARAMETER L(LIQUID,CO,CR;1) 273.0 909; 6000.0 N !
PARAMETER G(SIGMA,CO:CR:CO;0) 273.0 -30.518*T + 18*GCOBCC# + 8*GCOFCC# +
   4*GHSERCR# + 17077; 6000.0 N !
PARAMETER G(SIGMA,CO:CR:CR;0) 273.0 -104.215*T + 8*GCOFCC# + 22*GHSERCR# -
   7466; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   CO-FE                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER BMAGN(BCC_A2,CO,FE:VA;0) 273.0 1.406; 6000.0 N !
PARAMETER BMAGN(BCC_A2,CO,FE:VA;1) 273.0 -0.6617; 6000.0 N !
PARAMETER L(BCC_A2,CO,FE:VA;0) 273.0 -15.502*T*LN(T) + 125*T - 26222.7 -
   632250*T**(-1); 6000.0 N !
PARAMETER L(BCC_A2,CO,FE:VA;2) 273.0 2686.79 + 632250*T**(-1); 6000.0 N !
PARAMETER TC(BCC_A2,CO,FE:VA;0) 273.0 590; 6000.0 N !
PARAMETER BMAGN(BCC_B2,CO:FE:VA;0) 273.0 0.1; 6000.0 N !
PARAMETER BMAGN(BCC_B2,FE:CO:VA;0) 273.0 0.1; 6000.0 N !
PARAMETER BMAGN(BCC_B2,CO:CO,FE:VA;0) 273.0 -0.1; 6000.0 N !
PARAMETER BMAGN(BCC_B2,CO,FE:CO:VA;0) 273.0 -0.1; 6000.0 N !
PARAMETER BMAGN(BCC_B2,CO,FE:FE:VA;0) 273.0 -0.1; 6000.0 N !
PARAMETER BMAGN(BCC_B2,FE:CO,FE:VA;0) 273.0 -0.1; 6000.0 N !
PARAMETER G(BCC_B2,CO:FE:VA;0) 273.0 -1621.23; 6000.0 N !
PARAMETER G(BCC_B2,FE:CO:VA;0) 273.0 -1621.23; 6000.0 N !
PARAMETER L(BCC_B2,CO:CO,FE:VA;0) 273.0 1744.89; 6000.0 N !
PARAMETER L(BCC_B2,CO:CO,FE:VA;1) 273.0 -123.653; 6000.0 N !
PARAMETER L(BCC_B2,CO,FE:CO:VA;0) 273.0 1744.89; 6000.0 N !
PARAMETER L(BCC_B2,CO,FE:CO:VA;1) 273.0 -123.653; 6000.0 N !
PARAMETER L(BCC_B2,CO,FE:FE:VA;0) 273.0 1497.58; 6000.0 N !
PARAMETER L(BCC_B2,CO,FE:FE:VA;1) 273.0 -123.653; 6000.0 N !
PARAMETER L(BCC_B2,FE:CO,FE:VA;0) 273.0 1497.58; 6000.0 N !
PARAMETER L(BCC_B2,FE:CO,FE:VA;1) 273.0 -123.653; 6000.0 N !
PARAMETER L(BCC_B2,CO,FE:CO,FE:VA;0) 273.0 -2529000.0*T**(-1); 6000.0 N !
PARAMETER TC(BCC_B2,CO:FE:VA;0) 273.0 370; 6000.0 N !
PARAMETER TC(BCC_B2,FE:CO:VA;0) 273.0 370; 6000.0 N !
PARAMETER TC(BCC_B2,CO:CO,FE:VA;0) 273.0 -370; 6000.0 N !
PARAMETER TC(BCC_B2,CO,FE:CO:VA;0) 273.0 -370; 6000.0 N !
PARAMETER TC(BCC_B2,CO,FE:FE:VA;0) 273.0 -370; 6000.0 N !
PARAMETER TC(BCC_B2,FE:CO,FE:VA;0) 273.0 -370; 6000.0 N !
PARAMETER BMAGN(FCC_A1,CO,FE:VA;0) 273.0 8.407; 6000.0 N !
PARAMETER BMAGN(FCC_A1,CO,FE:VA;1) 273.0 -3.644; 6000.0 N !
PARAMETER L(FCC_A1,CO,FE:VA;0) 273.0 -8968.75; 6000.0 N !
PARAMETER L(FCC_A1,CO,FE:VA;2) 273.0 3528.8; 6000.0 N !
PARAMETER TC(FCC_A1,CO,FE:VA;0) 273.0 283; 6000.0 N !
PARAMETER TC(FCC_A1,CO,FE:VA;1) 273.0 879; 6000.0 N !
PARAMETER BMAGN(HCP_A3,CO,FE:VA;0) 273.0 5.41; 6000.0 N !
PARAMETER BMAGN(HCP_A3,CO,FE:VA;1) 273.0 -0.24; 6000.0 N !
PARAMETER L(HCP_A3,CO,FE:VA;0) 273.0 5000; 6000.0 N !
PARAMETER TC(HCP_A3,CO,FE:VA;0) 273.0 -253; 6000.0 N !
PARAMETER TC(HCP_A3,CO,FE:VA;1) 273.0 1494; 6000.0 N !
PARAMETER G(LAVES_PHASE,CO:FE;0) 273.0 2*GHSERCO# + GHSERFE# + 15000; 6000.0
   N !
PARAMETER G(LAVES_PHASE,FE:CO;0) 273.0 GHSERCO# + 2*GHSERFE# + 15000; 6000.0
   N !
PARAMETER L(LAVES_PHASE,*:CO,FE;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,CO,FE:*;0) 273.0 70000; 6000.0 N !
PARAMETER L(LIQUID,CO,FE;0) 273.0 -9753.82; 6000.0 N !
PARAMETER L(LIQUID,CO,FE;2) 273.0 2757.96; 6000.0 N !
PARAMETER G(MU_PHASE_I,CO:CO:CO:FE;0) 273.0 2*GCOBCC# + 7*GCOFCC# +
   4*GHSERFE#; 6000.0 N !
PARAMETER G(MU_PHASE_I,CO:CO:FE:FE;0) 273.0 7*GCOFCC# + 6*GHSERMO#; 6000.0 N !
PARAMETER G(MU_PHASE_I,CO:FE:CO:FE;0) 273.0 2*GCOBCC# + 6*GCOFCC# +
   4*GHSERMO# + GMOFCC#; 6000.0 N !
PARAMETER G(MU_PHASE_I,CO:FE:FE:CO;0) 273.0 4*GCOBCC# + 6*GCOFCC# + GFEFCC# +
   2*GHSERFE#; 6000.0 N !
PARAMETER G(MU_PHASE_I,CO:FE:FE:FE;0) 273.0 6*GCOFCC# + 6*GHSERMO# + GMOFCC#;
   6000.0 N !
PARAMETER G(MU_PHASE_I,FE:CO:CO:FE;0) 273.0 2*GCOBCC# + GCOFCC# + 6*GFEFCC# +
   4*GHSERFE#; 6000.0 N !
PARAMETER G(MU_PHASE_I,FE:CO:FE:CO;0) 273.0 4*GCOBCC# + GCOFCC# + 6*GFEFCC# +
   2*GHSERFE#; 6000.0 N !
PARAMETER G(MU_PHASE_I,FE:CO:FE:FE;0) 273.0 GCOFCC# + 6*GFEFCC# + 6*GHSERFE#;
   6000.0 N !
PARAMETER G(MU_PHASE_I,FE:FE:CO:CO;0) 273.0 6*GCOBCC# + 7*GFEFCC#; 6000.0 N !
PARAMETER G(MU_PHASE_I,FE:FE:CO:FE;0) 273.0 2*GCOBCC# + 7*GFEFCC# +
   4*GHSERFE#; 6000.0 N !
PARAMETER G(MU_PHASE_I,FE:FE:FE:CO;0) 273.0 4*GCOBCC# + 7*GFEFCC# +
   2*GHSERFE#; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   CO-NB                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,CO,NB:VA;0) 273.0 6627; 6000.0 N !
PARAMETER L(FCC_A1,CO,NB:VA;0) 273.0 -41634; 6000.0 N !
PARAMETER L(FCC_A1,CO,NB:VA;1) 273.0 -10241; 6000.0 N !
PARAMETER L(HCP_A3,CO,NB:VA;0) 273.0 -7146; 6000.0 N !
PARAMETER G(LAVES_PHASE,CO:NB;0) 273.0 2*GHSERCO# + GHSERNB# + 15000; 6000.0
   N !
PARAMETER G(LAVES_PHASE,NB:CO;0) 273.0 GHSERCO# + 2*GHSERNB# + 15000; 6000.0
   N !
PARAMETER L(LAVES_PHASE,CO,NB:NB;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,NB:CO,NB;0) 273.0 70000; 6000.0 N !
PARAMETER L(LIQUID,CO,NB;0) 273.0 14.284*T - 85028; 6000.0 N !
PARAMETER L(LIQUID,CO,NB;1) 273.0 -9936; 6000.0 N !
PARAMETER G(MU_PHASE,CO:NB:NB;0) 273.0 57.096*T + 7*GCOFCC# + 6*GHSERNB# -
   335543; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   CO-TI                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(HCP_A3,CO,TI:VA;0) 273.0 14.242*T - 65952; 6000.0 N !
PARAMETER G(LAVES_PHASE,CO:TI;0) 273.0 2*GHSERCO# + GHSERTI# + 15000; 6000.0
   N !
PARAMETER G(LAVES_PHASE,TI:CO;0) 273.0 GHSERCO# + 2*GHSERTI# + 15000; 6000.0
   N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   CR-FE                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER BMAGN(BCC_A2,CR,FE:VA;0) 273.0 -0.85; 6000.0 N !
PARAMETER L(BCC_A2,CR,FE:VA;0) 273.0 20500 - 9.68*T; 6000.0 N !
PARAMETER TC(BCC_A2,CR,FE:VA;0) 273.0 1650; 6000.0 N !
PARAMETER TC(BCC_A2,CR,FE:VA;1) 273.0 550; 6000.0 N !
PARAMETER G(CHI_A12,FE:CR:CR:VA;0) 273.0 -100*T + 24*GCRFCC# + 24*GFEFCC# +
   10*GHSERCR# + 18300; 6000.0 N !
PARAMETER G(CHI_A12,FE:CR:FE:VA;0) 273.0 -100*T + 48*GFEFCC# + 10*GHSERCR# +
   57300; 6000.0 N !
PARAMETER L(FCC_A1,CR,FE:VA;0) 273.0 10833 - 7.477*T; 6000.0 N !
PARAMETER L(FCC_A1,CR,FE:VA;1) 273.0 1410; 6000.0 N !
PARAMETER L(HCP_A3,CR,FE:VA;0) 273.0 10833 - 7.477*T; 6000.0 N !
PARAMETER G(LAVES_PHASE,CR:FE;0) 273.0 2*GHSERCR# + GHSERFE# + 15000; 6000.0
   N !
PARAMETER G(LAVES_PHASE,FE:CR;0) 273.0 GHSERCR# + 2*GHSERFE# + 15000; 6000.0
   N !
PARAMETER L(LAVES_PHASE,CR:CR,FE;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR,FE:CR;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR,FE:FE;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,FE:CR,FE;0) 273.0 70000; 6000.0 N !
PARAMETER L(LIQUID,CR,FE;0) 273.0 7.996546*T - 17737; 6000.0 N !
PARAMETER L(LIQUID,CR,FE;1) 273.0 -1331; 6000.0 N !
PARAMETER G(SIGMA,FE:CR:CR;0) 273.0 -95.96*T + 8*GFEFCC# + 22*GHSERCR# +
   92300; 6000.0 N !
PARAMETER G(SIGMA,FE:CR:FE;0) 273.0 -95.96*T + 8*GFEFCC# + 4*GHSERCR# +
   18*GHSERFE# + 117300; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   CR-NB                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,CR,NB:VA;0) 273.0 43426.41 - 13.01153*T; 6000.0 N !
PARAMETER L(BCC_A2,CR,NB:VA;1) 273.0 13201.2 - 6.666*T; 6000.0 N !
PARAMETER L(FCC_A1,CR,NB:VA;0) 273.0 40000; 6000.0 N !
PARAMETER G(LAVES_PHASE,CR:NB;0) 273.0 -5*T*LN(T) + 31.01111*T + 2*GHSERCR# +
   GHSERNB# - 12667.55; 6000.0 N !
PARAMETER G(LAVES_PHASE,NB:CR;0) 273.0 5*T*LN(T) - 31.01111*T + GHSERCR# +
   2*GHSERNB# + 42667.55; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR:CR,NB;0) 273.0 18511.36; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR,NB:CR;0) 273.0 90673.45; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR,NB:NB;0) 273.0 90673.45; 6000.0 N !
PARAMETER L(LAVES_PHASE,NB:CR,NB;0) 273.0 18511.36; 6000.0 N !
PARAMETER L(LIQUID,CR,NB;0) 273.0 0.60618*T - 10304.91; 6000.0 N !
PARAMETER L(LIQUID,CR,NB;1) 273.0 0.5008*T - 8513.45; 6000.0 N !
PARAMETER G(ZET,CR:NB:VA;0) 273.0 GHSERCR# + GHSERNB#; 6000.0 N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   CR-TI                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,CR,TI:VA;0) 273.0 19100; 6000.0 N !
PARAMETER L(BCC_A2,CR,TI:VA;1) 273.0 5500; 6000.0 N !
PARAMETER L(BCC_A2,CR,TI:VA;2) 273.0 1750; 6000.0 N !
PARAMETER L(FCC_A1,CR,TI:VA;0) 273.0 66300.0 - 27.7*T; 6000.0 N !
PARAMETER L(HCP_A3,CR,TI:VA;0) 273.0 32500; 6000.0 N !
PARAMETER G(LAVES_PHASE,CR:TI;0) 273.0 -6.3*T + 2*GHSERCR# + GHSERTI# - 1780;
   6000.0 N !
PARAMETER G(LAVES_PHASE,TI:CR;0) 273.0 6.3*T + GHSERCR# + 2*GHSERTI# + 31780;
   6000.0 N !
PARAMETER L(LAVES_PHASE,CR:CR,TI;0) 273.0 50000; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR,TI:CR;0) 273.0 27*T + 10800; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR,TI:TI;0) 273.0 27*T + 10800; 6000.0 N !
PARAMETER L(LAVES_PHASE,TI:CR,TI;0) 273.0 50000; 6000.0 N !
PARAMETER L(LIQUID,CR,TI;0) 273.0 5250; 6000.0 N !
PARAMETER L(LIQUID,CR,TI;1) 273.0 1500; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   FE-NB                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,FE,NB:VA;0) 273.0 6.333*T - 4400; 6000.0 N !
PARAMETER L(FCC_A1,FE,NB:VA;0) 273.0 -2000; 6000.0 N !
PARAMETER L(HCP_A3,FE,NB:VA;0) 273.0 -4784; 6000.0 N !
PARAMETER G(LAVES_PHASE,FE:NB;0) 273.0 13.8*T + 2*GFEFCC# + GHSERNB# - 70290;
   6000.0 N !
PARAMETER G(LAVES_PHASE,NB:FE;0) 273.0 GHSERFE# + 2*GHSERNB# + 15000; 6000.0
   N !
PARAMETER L(LAVES_PHASE,FE:FE,NB;0) 273.0 30000; 6000.0 N !
PARAMETER L(LAVES_PHASE,FE,NB:FE;0) 273.0 30000; 6000.0 N !
PARAMETER L(LAVES_PHASE,FE,NB:NB;0) 273.0 30000; 6000.0 N !
PARAMETER L(LAVES_PHASE,NB:FE,NB;0) 273.0 30000; 6000.0 N !
PARAMETER L(LIQUID,FE,NB;0) 273.0 10.828*T - 56553; 6000.0 N !
PARAMETER L(LIQUID,FE,NB;1) 273.0 13400; 6000.0 N !
PARAMETER G(MU_PHASE,FE:NB:FE;0) 273.0 7*GFEFCC# + 4*GHSERFE# + 2*GHSERNB# +
   103747; 6000.0 N !
PARAMETER G(MU_PHASE,FE:NB:NB;0) 273.0 20*T + 7*GFEFCC# + 6*GHSERNB# -
   239093; 6000.0 N !
PARAMETER G(ZET,FE:NB:VA;0) 273.0 GHSERFE# + GHSERNB#; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   FE-TI                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,FE,TI:VA;0) 273.0 11.5*T - 59098; 6000.0 N !
PARAMETER L(BCC_A2,FE,TI:VA;1) 273.0 T - 1796; 6000.0 N !
PARAMETER L(BCC_A2,FE,TI:VA;2) 273.0 3.5*T + 5602; 6000.0 N !
PARAMETER G(ETA,FE:TI;0) 273.0 2*T + 3*GHSERFE# + GHSERTI# - 33000; 6000.0 N !
PARAMETER G(ETA,TI:FE;0) 273.0 GDHCFE# + 3*GDHCTI# + 30000; 6000.0 N !
PARAMETER L(FCC_A1,FE,TI:VA;0) 273.0 10.4*T - 51136; 6000.0 N !
PARAMETER L(FCC_A1,FE,TI:VA;1) 273.0 -6*T - 1950; 6000.0 N !
PARAMETER L(FCC_A1,FE,TI:VA;2) 273.0 14875; 6000.0 N !
PARAMETER L(HCP_A3,FE,TI:VA;0) 273.0 11*T - 28750; 6000.0 N !
PARAMETER L(HCP_A3,FE,TI:VA;1) 273.0 -6*T - 1700; 6000.0 N !
PARAMETER L(HCP_A3,FE,TI:VA;2) 273.0 15000; 6000.0 N !
PARAMETER G(LAVES_PHASE,FE:TI;0) 273.0 -0.01017*T**2 - 73.55318*T*LN(T) +
   409*T - 91500 + 124200*T**(-1); 6000.0 N !
PARAMETER G(LAVES_PHASE,TI:FE;0) 273.0 GHSERFE# + 2*GHSERTI# + 15000; 6000.0
   N !
PARAMETER L(LAVES_PHASE,FE:FE,TI;0) 273.0 16000; 6000.0 N !
PARAMETER L(LAVES_PHASE,FE,TI:FE;0) 273.0 -38000; 6000.0 N !
PARAMETER L(LAVES_PHASE,FE,TI:TI;0) 273.0 -38000; 6000.0 N !
PARAMETER L(LAVES_PHASE,TI:FE,TI;0) 273.0 16000; 6000.0 N !
PARAMETER L(LIQUID,FE,TI;0) 273.0 8.25*T - 71347; 6000.0 N !
PARAMETER L(LIQUID,FE,TI;1) 273.0 7434 - 4.5*T; 6000.0 N !
PARAMETER L(LIQUID,FE,TI;2) 273.0 0.25*T + 12155; 6000.0 N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                   NB-TI                                    $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,NB,TI:VA;0) 273.0 14000; 6000.0 N !
PARAMETER L(FCC_A1,NB,TI:VA;0) 273.0 13600; 6000.0 N !
PARAMETER L(HCP_A3,NB,TI:VA;0) 273.0 13600; 6000.0 N !
PARAMETER G(LAVES_PHASE,NB:TI;0) 273.0 2*GHSERNB# + GHSERTI# + 15000; 6000.0
   N !
PARAMETER G(LAVES_PHASE,TI:NB;0) 273.0 GHSERNB# + 2*GHSERTI# + 15000; 6000.0
   N !
PARAMETER L(LIQUID,NB,TI;0) 273.0 8500; 6000.0 N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                  CO-CR-FE                                  $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER G(SIGMA,CO:CR:FE;0) 273.0 8*GCOFCC# + 4*GHSERCR# + 18*GHSERFE#;
   6000.0 N !
PARAMETER G(SIGMA,FE:CR:CO;0) 273.0 18*GCOBCC# + 8*GFEFCC# + 4*GHSERCR#;
   6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                  CR-FE-NB                                  $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,CR,FE,NB:VA;0) 273.0 -35000; 6000.0 N !
PARAMETER L(FCC_A1,CR,FE,NB:VA;0) 273.0 1.0E-7; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR,FE:NB;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,CR,NB:FE;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,FE:CR,NB;0) 273.0 70000; 6000.0 N !
PARAMETER L(LAVES_PHASE,NB:CR,FE;0) 273.0 70000; 6000.0 N !
PARAMETER L(LIQUID,CR,FE,NB;0) 273.0 -10000; 6000.0 N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                  CR-FE-TI                                  $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(BCC_A2,CR,FE,TI:VA;0) 273.0 1.0E-7; 6000.0 N !
PARAMETER L(FCC_A1,CR,FE,TI:VA;0) 273.0 1.0E-7; 6000.0 N !
PARAMETER L(LIQUID,CR,FE,TI;0) 273.0 -90000; 6000.0 N !
PARAMETER L(LIQUID,CR,FE,TI;1) 273.0 70000; 6000.0 N !
PARAMETER L(LIQUID,CR,FE,TI;2) 273.0 -90000; 6000.0 N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$                                  FE-NB-TI                                  $
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

PARAMETER L(LAVES_PHASE,FE,NB:TI;0) 273.0 30000; 6000.0 N !
PARAMETER L(LAVES_PHASE,FE,TI:NB;0) 273.0 -38000; 6000.0 N !
PARAMETER L(LAVES_PHASE,NB:FE,TI;0) 273.0 16000; 6000.0 N !
PARAMETER L(LAVES_PHASE,TI:FE,NB;0) 273.0 30000; 6000.0 N !

"""
AL2O3_ND2O3_ZRO2_TDB = """$ ZrO2-Nd2O3-Al2O3
$
$ TDB-file for the thermodynamic assessment of the Nd2O3-Y2O3 system
$
$------------------------------------------------------------------------------
$ 2013.3.15
$
$ TDB file created by T.Abe, K.Hashimoto and Y.Sawada
$
$ Thermodynamics Modeling Group, National Institute for
$ Materials Science. 1-2-1 Sengen, Tsukuba, Ibaraki 305-0047, Japan
$ e-mail: abe.taichi @nims.go.jp
$ Copyright (C) NIMS 2013
$     Assessment of thermodynamic functions in the ZrO2-Nd2O3-Al2O3 system.
$     O.Fabrichnaya, H.J.Seifert, CALPHAD, 32 (2008), 142-151.

$     Note: modify value in GNDALO3.

$ 2013-03-11

$ Modified slightly by Brandon Bocklund to make T-C compatible (line length)
$ and to add :I phase codes to all charged phases.

$
$
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AL   FCC_A1                    26.981539   4577.296    28.3215!
 ELEMENT ND   DOUBLE_HCP(ABAC)          1.4424E+02  0.0000E+00  0.0000E+00!
 ELEMENT O    1/2_MOLE_O2(G)            1.5999E+01  4.3410E+03  1.0252E+02!
 ELEMENT ZR   HCP_A3                    91.224      5566.27     39.181 !
$--------1---------2---------3---------4---------5---------6---------7---------8
$
  SPECIES O2        O2!
  SPECIES O-2       O1/-2!
  SPECIES AL+3      AL1/+3!
  SPECIES ND+3      ND1/+3!
  SPECIES ZR+4      ZR1/+4!
  SPECIES ALO3/2    AL1O1.5!

 FUNCTION GHSERAL 298.15  -7976.15+137.093038*T-24.3671976*T*LN(T)
   -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1);                  700  Y
   -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
   -5.764227E-06*T**3+74092*T**(-1);                                 933.47  Y
   -11278.378+188.684153*T-31.748192*T*LN(T)-1.230524E+28*T**(-9);   2900  N !


 FUNCTION GHSERND   298.15
    -8402.93+111.10239*T-27.0858*T*LN(T)
    +5.56125E-04*T**2-2.6923E-06*T**3+34887*T**(-1);                    900 Y
    -6984.083+83.662617*T-22.7536*T*LN(T)-.00420402*T**2-1.802E-06*T**3;
                                                                       1128 Y
    -225610.846+1673.04075*T-238.182873*T*LN(T)+.078615997*T**2
    -6.048207E-06*T**3+38810350*T**(-1);                               1800 N !


 FUNCTION GNDLIQ    298.15
    +5350.01-86.593963*T+5.357301*T*LN(T)-.046955463*T**2+6.860782E-06*T**3
    -374380*T**(-1);                                                   1128 Y
    -16335.232+268.625903*T-48.7854*T*LN(T);                           1800 N !


 FUNCTION GNDBCC    298.15
    -6965.635+110.556109*T-27.0858*T*LN(T)+5.56125E-04*T**2
    -2.6923E-06*T**3+34887*T**(-1);                                     400 Y
    +7312.2-153.033976*T+14.9956777*T*LN(T)-.050479*T**2+7.287217E-06*T**3
    -831810*T**(-1);                                                   1128 Y
    -18030.266+239.677322*T-44.5596*T*LN(T);                           1289 Y
    +334513.017-2363.9199*T+311.409193*T*LN(T)-.156030778*T**2
    +1.2408421E-05*T**3-64319604*T**(-1);                              1800 N !

 FUNCTION GND2O3A   298.15
          -1847329+637.4243*T-116.358*T*LN(T)
          -0.014677*T**2 +711000*T**(-1) -1E+07*T**(-2);
                                                        6000  N ! $ 08Fab,06Hua
 FUNCTION GND2O3L   298.15 +GND2O3A  +143621-56.785*T;
                                                        6000  N ! $ 08Fab,06Hua
 FUNCTION GND2O3H   298.15 +GND2O3A   +33189-13.986*T;
                                                        6000  N ! $ 08Fab,06Hua
 FUNCTION GND2O3X   298.15 +GND2O3A   +44489-18.555*T;
                                                        6000  N ! $ 08Fab,06Hua
 FUNCTION GND2O3B   298.15 +GND2O3A     -399+1.684*T;
                                                        6000  N ! $       06Hua
 FUNCTION GND2O3C   298.15 +GND2O3A    -1311+6.55*T;
                                                        6000  N ! $       06Hua



 FUNCTION GHSEROO    298.15 -3480.87-25.503038*T-11.136*T*LN(T)
               -.005098888*T**2+6.61846E-07*T**3-38365*T**(-1);          1000 Y
               -6568.763+12.65988*T-16.8138*T*LN(T)-5.95798E-04*T**2
               +6.781E-09*T**3+262905*T**(-1);                           3300 Y
               -13986.728+31.259625*T-18.9536*T*LN(T)-4.25243E-04*T**2
               +1.0721E-08*T**3+4383200*T**(-1);               6000 N ! $ 91Din

 FUNCTION GOOBCC     298.15 +26519.13-25.503038*T-11.1355*T*LN(T)
              -.005098875*T**2+6.61846E-07*T**3-38365*T**(-1);           1000 Y
              +23431.237+12.659879*T-16.8138*T*LN(T)-5.95797E-04*T**2
              +6.781E-09*T**3+262905*T**(-1);                            3300 Y
              +16013.272+31.259624*T-18.9536*T*LN(T)-4.25243E-04*T**2
              +1.0721E-08*T**3+4383200*T**(-1);                6000 N ! $ 91Din


 FUNCTION GHSERZR    298.15  -7827.595+125.64905*T-24.1618*T*LN(T)
     -.00437791*T**2+34971*T**(-1);  2.12800E+03  Y
      -26085.921+262.724183*T-42.144*T*LN(T)-1.342895E+31*T**(-9);
     4.00000E+03  N !


 FUNCTION GZRO2M     298.15  -1126163.54+424.890806*T-69.3875137*T*LN(T)
                     -0.00375880141*T**2 +683000*T**(-1);      6000 N ! $ 08Fab
 FUNCTION GZRO2T     298.15  +5468-4.0*T  +GZRO2M;             6000 N ! $ 08Fab
 FUNCTION GZRO2C     298.15  +10336-4.0*T +GZRO2T;             6000 N ! $ 08Fab
 FUNCTION GZRO2L     298.15  +87027-29.17432*T +GZRO2C;        6000 N ! $ 08Fab




$               08Fab = 21207*T**(-1)

$ Corundum from 92Tay , CALPHAD 16 (1992), 173-179.

 FUNCTION GCORUND     298.15  -1707351.298 +448.021092*T -67.4804*T*LN(T)
      -0.06747*T**2 +14.205433E-06*T**3 +938780*T**(-1);                 600  Y
      -1724886.064+754.856573*T-116.258*T*LN(T)
      -0.0072257*T**2+0.278532E-06*T**3+2120700*T**(-1);                1500  Y
      -1772163.194+1053.4548*T-156.058*T*LN(T)
      +0.00709105*T**2-0.629402E-06*T**3+12366650*T**(-1);
                                                  3000  N ! $ 92Tay,97Lee,08Fab

 FUNCTION GAL2O3L    298.15  -1607850.8+405.559491*T
      -67.4804*T*LN(T)-0.06747*T**2+1.4205433E-05*T**3+938780*T**(-1);
                                                                          600 Y
                                              -1625385.57+712.394972*T
      -116.258*T*LN(T)-0.0072257*T**2+2.78532E-07*T**3+2120700*T**(-1);
                                                                         1500 Y
                                              -1672662.69+1010.9932*T
      -156.058*T*LN(T)+0.00709105*T**2-6.29402E-07*T**3+12366650*T**(-1);
                                                                         1912 Y
                                              +29178041.6-168360.926*T
      +21987.1791*T*LN(T)-6.99552951*T**2+4.10226192E-04*T**3
      -7.98843618E+09*T**(-1);                                           2327 Y
      -1757702.05+1344.84833*T-192.464*T*LN(T);          4000 N ! $ 97Lee,08Fab

$FUNCTION GNDALO3    298.15  -18032701+643.783*T-109.1273*T*LN(T)
$                         -0.013364*T**2 +890990*T**(-1);  6000 N ! $ 08Fab_org

 FUNCTION GNDALO3    298.15  -1803270.1 -29000 +643.783*T-109.1273*T*LN(T)
                          -0.013364*T**2 +890990*T**(-1);
                                                           6000 N ! $ 08Fab_mod
 FUNCTION GND2O3F    298.15  +GND2O3A +63285.47-19.33*T;       6000 N ! $ 08Fab
 FUNCTION GND2O3T    298.15  +GND2O3F  +10000;                 6000 N ! $ 08Fab
 FUNCTION GPYRO      298.15  -4.17E+06 +1561.884*T -270.085210*T*LN(T)
                          +1.89413764E+06*T**(-1) -0.0156136089*T**2;
                                                               6000 N ! $ 08Fab
 FUNCTION GANCA      298.15  +317600;                          6000 N ! $ 08Fab
 FUNCTION GPYROZR    298.15  +4*GZRO2C  +10000+16*T;           6000 N ! $ 08Fab
 FUNCTION GPYROND    298.15  +2*GND2O3A +120000-13*T;          6000 N ! $ 08Fab

 FUNCTION GREC1      298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC2      298.15  +59000;                           6000 N ! $ 08Fab
 FUNCTION GREC3      298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC4      298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC5      298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC6      298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC7      298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC8      298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC9      298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC10     298.15  +0;                               6000 N ! $ 08Fab
 FUNCTION GREC11     298.15  +0;                               6000 N ! $ 08Fab

 FUNCTION UN_ASS     298.15  +0;                                       300. N !
 FUNCTION ZERO       298.15  +0;                                       300. N !


 TYPE_DEFINITION % SEQ * !

$
$ -----------------------------------------------------------------------------
$
$ PHASE GAS:G %  1  1.0  !
$   CONSTITUENT GAS:G :O2:  !
$   PARAMETER G(GAS,O2;0)    298.15 +2*GHSEROO +R*T*LN(1E-05*P); 6000 N !




 PHASE I_LIQUID:Y  %  2  1  1  !
   CONSTITUENT I_LIQUID:Y    :ND+3,ZR+4:O-2,ALO3/2:  !                  $ 08Fab
   PARAMETER G(I_LIQUID,ZR+4:O-2;0)        298.15   +2*GZRO2L;       6000 N ! $
   PARAMETER G(I_LIQUID,ND+3:O-2;0)        298.15   +GND2O3L;        6000 N ! $
   PARAMETER G(I_LIQUID,ALO3/2;0)          298.15   +0.5*GAL2O3L;    6000 N ! $
   PARAMETER G(I_LIQUID,ND+3,ZR+4:O-2;0)   298.15   -173251;         6000 N ! $
   PARAMETER G(I_LIQUID,ND+3,ZR+4:O-2;1)   298.15   -33251;          6000 N ! $
   PARAMETER G(I_LIQUID,ND+3:O-2,ALO3/2;0) 298.15   -118838.48;      6000 N ! $
   PARAMETER G(I_LIQUID,ND+3:O-2,ALO3/2;1) 298.15   -52117.431;      6000 N ! $
   PARAMETER G(I_LIQUID,ZR+4:O-2,ALO3/2;0) 298.15   +50000;          6000 N ! $
   PARAMETER G(I_LIQUID,ZR+4:O-2,ALO3/2;1) 298.15   -40000;          6000 N ! $
   PARAMETER G(I_LIQUID,ND+3,ZR+4:O-2,ALO3/2;0)     298.15   +175000;
                                                               6000 N ! $ 08Fab


$ Fluorite

 PHASE FLUO:I  %  2  2  4    !
   CONSTITUENT FLUO:I  :AL+3,ND+3,ZR+4:O-2,VA:  !   $ 08Fab
   PARAMETER G(FLUO,ZR+4:O-2;0)        298.15  +2*GZRO2C;
                                                                     6000 N ! $
   PARAMETER G(FLUO,ZR+4:VA;0)         298.15  +2*GZRO2C -4*GHSEROO;
                                                                     6000 N ! $
   PARAMETER G(FLUO,AL+3:O-2;0)        298.15
      +GCORUND    +GHSEROO +18.702165*T +100000;                     6000 N ! $
   PARAMETER G(FLUO,AL+3:VA;0)         298.15
      +GCORUND  -3*GHSEROO +18.702165*T +100000;                     6000 N ! $
   PARAMETER G(FLUO,ND+3:O-2;0)        298.15
      +GND2O3F    +GHSEROO +18.702165*T;                             6000 N ! $
   PARAMETER G(FLUO,ND+3:VA;0)         298.15
      +GND2O3F  -3*GHSEROO +18.702165*T;                             6000 N ! $
   PARAMETER G(FLUO,ND+3,ZR+4:O-2;0)   298.15
      -269135+299.193*T-32*T*LN(T);                                  6000 N ! $
   PARAMETER G(FLUO,ND+3,ZR+4:VA;0)    298.15
      -269135+299.193*T-32*T*LN(T);                                  6000 N ! $
   PARAMETER G(FLUO,ND+3,ZR+4:O-2;1)   298.15  -54416;               6000 N ! $
   PARAMETER G(FLUO,ND+3,ZR+4:VA;1)    298.15  -54416;               6000 N ! $
   PARAMETER G(FLUO,ND+3,ZR+4:O-2;2)   298.15  +35213;               6000 N ! $
   PARAMETER G(FLUO,ND+3,ZR+4:VA;2)    298.15  +35213;               6000 N ! $
   PARAMETER G(FLUO,AL+3,ZR+4:O-2;0)   298.15  +18500;               6000 N ! $
   PARAMETER G(FLUO,AL+3,ZR+4:VA;0)    298.15  +18500;               6000 N ! $
   PARAMETER G(FLUO,AL+3,ND+3:O-2;0)   298.15  +100000;              6000 N ! $
   PARAMETER G(FLUO,AL+3,ND+3:VA;0)    298.15  +100000;        6000 N ! $ 08Gab

$ Tetragonal

 PHASE TETR:I  %  2  2  4    !
   CONSTITUENT TETR:I  :AL+3,ND+3,ZR+4:O-2,VA:  ! $ 08Fab
   PARAMETER G(TETR,ZR+4:O-2;0)        298.15  +2*GZRO2T;            6000 N ! $
   PARAMETER G(TETR,ZR+4:VA;0)         298.15
      +2*GZRO2T -4*GHSEROO;                                          6000 N ! $
   PARAMETER G(TETR,AL+3:O-2;0)        298.15
      +GCORUND    +GHSEROO +18.702165*T +100000;           6000 N ! $ same FLUO
   PARAMETER G(TETR,AL+3:VA;0)         298.15
      +GCORUND  -3*GHSEROO +18.702165*T +100000;           6000 N ! $ same FLUO
   PARAMETER G(TETR,ND+3:O-2;0)        298.15
      +GND2O3T    +GHSEROO +18.702165*T;                             6000 N ! $
   PARAMETER G(TETR,ND+3:VA;0)         298.15
      +GND2O3T  -3*GHSEROO +18.702165*T;                             6000 N ! $
   PARAMETER G(TETR,ND+3,ZR+4:O-2;0)   298.15  -30000;               6000 N ! $
   PARAMETER G(TETR,ND+3,ZR+4:VA;0)    298.15  -30000;               6000 N ! $
   PARAMETER G(TETR,AL+3,ZR+4:O-2;0)   298.15  +20000;               6000 N ! $
   PARAMETER G(TETR,AL+3,ZR+4:VA;0)    298.15  +20000;               6000 N ! $
   PARAMETER G(TETR,AL+3,ND+3:O-2;0)   298.15  +100000;              6000 N ! $
   PARAMETER G(TETR,AL+3,ND+3:VA;0)    298.15  +100000;        6000 N ! $ 08Fab

$ Monoclinic

 PHASE MONO:I  %  2  2  4    !
   CONSTITUENT MONO:I  :AL+3,ND+3,ZR+4:O-2,VA:  ! $ 08Fab
   PARAMETER G(MONO,ZR+4:O-2;0)        298.15  +2*GZRO2M;            6000 N ! $
   PARAMETER G(MONO,ZR+4:VA;0)         298.15
      +2*GZRO2M -4*GHSEROO;                                          6000 N ! $
   PARAMETER G(MONO,AL+3:O-2;0)        298.15
      +GCORUND    +GHSEROO +18.702165*T +200000;                     6000 N ! $
   PARAMETER G(MONO,AL+3:VA;0)         298.15
      +GCORUND  -3*GHSEROO +18.702165*T +200000;                     6000 N ! $
   PARAMETER G(MONO,ND+3:O-2;0)        298.15
      +GND2O3A    +GHSEROO +18.702165*T +160000;                     6000 N ! $
   PARAMETER G(MONO,ND+3:VA;0)         298.15
      +GND2O3A  -3*GHSEROO +18.702165*T +160000;               6000 N ! $ 08Fab




 PHASE ND2O3_A:I  %  3  2  3  1  !
   CONSTITUENT ND2O3_A:I  :ND+3,ZR+4:O-2:O-2,VA:  ! $ 08Fab
   PARAMETER G(ND2O3_A,ZR+4:O-2:O-2;0)      298.15
      +2*GZRO2C +50000;                                              6000 N ! $
   PARAMETER G(ND2O3_A,ZR+4:O-2:VA;0)       298.15
      +2*GZRO2C-GHSEROO+50000;                                       6000 N ! $
   PARAMETER G(ND2O3_A,ND+3:O-2:O-2;0)      298.15
      +GND2O3A +GHSEROO;                                             6000 N ! $
   PARAMETER G(ND2O3_A,ND+3:O-2:VA;0)       298.15
      +GND2O3A;                                                      6000 N ! $
   PARAMETER G(ND2O3_A,ND+3,ZR+4:O-2:O-2;0) 298.15  -30000;          6000 N ! $
   PARAMETER G(ND2O3_A,ND+3,ZR+4:O-2:VA;0)  298.15  -30000;    6000 N ! $ 08Fab

 PHASE ND2O3_H:I  %  3  2  3  1  !
   CONSTITUENT ND2O3_H:I  :ND+3,ZR+4:O-2:O-2,VA:  ! $ 08Fab
   PARAMETER G(ND2O3_H,ZR+4:O-2:O-2;0)      298.15
      +2*GZRO2C +20000;                                              6000 N ! $
   PARAMETER G(ND2O3_H,ZR+4:O-2:VA;0)       298.15
      +2*GZRO2C-GHSEROO+20000;                                       6000 N ! $
   PARAMETER G(ND2O3_H,ND+3:O-2:O-2;0)      298.15
      +GND2O3H +GHSEROO;                                             6000 N ! $
   PARAMETER G(ND2O3_H,ND+3:O-2:VA;0)       298.15  +GND2O3H;        6000 N ! $
   PARAMETER G(ND2O3_H,ND+3,ZR+4:O-2:O-2;0) 298.15  -37700;          6000 N ! $
   PARAMETER G(ND2O3_H,ND+3,ZR+4:O-2:VA;0)  298.15  -37700;    6000 N ! $ 08Fab

 PHASE ND2O3_X:I  %  3  2  3  1  !
   CONSTITUENT ND2O3_X:I  :ND+3,ZR+4:O-2:O-2,VA:  ! $ 08Fab
   PARAMETER G(ND2O3_X,ZR+4:O-2:O-2;0)      298.15
      +2*GZRO2C +10000;                                              6000 N ! $
   PARAMETER G(ND2O3_X,ZR+4:O-2:VA;0)       298.15
      +2*GZRO2C-GHSEROO+10000;                                       6000 N ! $
   PARAMETER G(ND2O3_X,ND+3:O-2:O-2;0)      298.15
      +GND2O3X +GHSEROO;                                             6000 N ! $
   PARAMETER G(ND2O3_X,ND+3:O-2:VA;0)       298.15  +GND2O3X;        6000 N ! $
   PARAMETER G(ND2O3_X,ND+3,ZR+4:O-2:O-2;0) 298.15  -35763;          6000 N ! $
   PARAMETER G(ND2O3_X,ND+3,ZR+4:O-2:VA;0)  298.15  -35763;    6000 N ! $ 08Fab

$ corundum

 PHASE AL2O3_C:I  %  2  2  3    !
   CONSTITUENT AL2O3_C:I  :AL+3:O-2:  ! $ 08Fab
   PARAMETER G(AL2O3_C,AL+3:O-2;0)          298.15  +GCORUND;  6000 N ! $ 08Fab

$ NDAP_NdAlO3

 PHASE NDAP:I  %  3   1  1   3    !
   CONSTITUENT NDAP:I  :ND+3:AL+3:O-2:  ! $ 08Fab
   PARAMETER G(NDAP,ND+3:AL+3:O-2;0)        298.15  +GNDALO3;  6000 N ! $ 08Fab

$ Beta_NdAl11O18

 PHASE BETA:I  %  3   1  11   18    !
   CONSTITUENT BETA:I  :ND+3:AL+3:O-2:  !  $ 08Fab
   PARAMETER G(BETA,ND+3:AL+3:O-2;0) 298.15
     +5.5*GCORUND+0.5*GND2O3A-59000+1.9*T;  6000 N ! $ 08Fab

$ Pyrochlore

 PHASE PYRO:I  %  5   2  2  6  1  1    !
   CONSTITUENT PYRO:I  :ND+3,ZR+4:ND+3,ZR+4:O-2,VA:O-2:O-2,VA:  !  $ 08Fab
   PARAMETER G(PYRO,ZR+4:ZR+4:O-2:O-2:VA;0)   298.15
      +GPYROZR -GHSEROO;                                             6000 N ! $
   PARAMETER G(PYRO,ND+3:ZR+4:O-2:O-2:VA;0)   298.15
      +GPYRO;                                                        6000 N ! $
   PARAMETER G(PYRO,ZR+4:ND+3:O-2:O-2:VA;0)   298.15
      +GPYRO +GANCA;                                                 6000 N ! $
   PARAMETER G(PYRO,ND+3:ND+3:O-2:O-2:VA;0)   298.15
      +2*GPYRO -GPYROZR +GHSEROO +GANCA +GREC1;                      6000 N ! $
   PARAMETER G(PYRO,ZR+4:ZR+4:O-2:O-2:O-2;0)  298.15  +GPYROZR;      6000 N ! $
   PARAMETER G(PYRO,ND+3:ZR+4:O-2:O-2:O-2;0)  298.15
      +GPYRO+GHSEROO +GREC2;                                         6000 N ! $
   PARAMETER G(PYRO,ZR+4:ND+3:O-2:O-2:O-2;0)  298.15
      +GPYRO +GHSEROO +GANCA -GREC1 +GREC2+GREC3+GREC4;              6000 N ! $
   PARAMETER G(PYRO,ND+3:ND+3:O-2:O-2:O-2;0)  298.15
      +2*GPYRO +2*GHSEROO -GPYROZR +GANCA +GREC1+GREC2+GREC3;        6000 N ! $
   PARAMETER G(PYRO,ZR+4:ZR+4:VA:O-2:VA;0)    298.15
      +6*GPYROND -12*GPYRO -7*GHSEROO +7*GPYROZR -6*GANCA +134.8548*T
      -6*GREC1+GREC5+GREC6;                                          6000 N ! $
   PARAMETER G(PYRO,ND+3:ZR+4:VA:O-2:VA;0)    298.15
      +6*GPYROND -11*GPYRO -6*GHSEROO +6*GPYROZR -6*GANCA +134.8548*T
      -6*GREC1+GREC5+GREC6;                                          6000 N ! $
   PARAMETER G(PYRO,ZR+4:ND+3:VA:O-2:VA;0)    298.15
      +6*GPYROND -11*GPYRO -6*GHSEROO +6*GPYROZR -5*GANCA +134.8548*T
      -6*GREC1+GREC7;                                                6000 N ! $
   PARAMETER G(PYRO,ND+3:ND+3:VA:O-2:VA;0)    298.15
      +6*GPYROND -10*GPYRO -5*GHSEROO +5*GPYROZR -5*GANCA
      +134.8548*T -5*GREC1;                                          6000 N ! $

   PARAMETER G(PYRO,ZR+4:ZR+4:VA:O-2:O-2;0)   298.15
      +6*GPYROND -12*GPYRO -6*GHSEROO +7*GPYROZR -6*GANCA +134.8548*T
      -6*GREC1+GREC5+GREC8+GREC10;                                   6000 N ! $
   PARAMETER G(PYRO,ND+3:ZR+4:VA:O-2:O-2;0)   298.15
      +6*GPYROND -11*GPYRO -5*GHSEROO +6*GPYROZR -6*GANCA +134.8548*T
      -6*GREC1+GREC2+GREC5+GREC8;                                    6000 N ! $
   PARAMETER G(PYRO,ZR+4:ND+3:VA:O-2:O-2;0)   298.15
      +6*GPYROND -11*GPYRO -5*GHSEROO +6*GPYROZR -5*GANCA +134.8548*T
      -6*GREC1+GREC5+GREC8+GREC10;                                   6000 N ! $
   PARAMETER G(PYRO,ND+3:ND+3:VA:O-2:O-2;0)    298.15
      +6*GPYROND -10*GPYRO -4*GHSEROO +5*GPYROZR -5*GANCA +134.8548*T
      -5*GREC1+GREC2+GREC3+GREC5+GREC8+GREC9; 6000 N !                  $ 08Fab

$
"""

ALFEO_TDB = """
$****************************************************************************
$$ Al-Fe-O Ternary
$$
$****************************************************************************
$****************************************************************************
$$ Database developed by:
$$ Greta Lindwall
$$ Xuan L. Liu 
$$ Zi-Kui Liu
$$ Maj 2015
$****************************************************************************
            
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5773E+03  2.8322E+01!
 ELEMENT FE   BCC_A2                    5.5847E+01  4.4890E+03  2.7280E+01!
 ELEMENT O    1/2_MOLE_O2(G)            1.5999E+01  4.3410E+03  1.0252E+02!
 
 SPECIES AL+3                        AL1/+3!
 SPECIES AL1O1                       AL1O1!
 SPECIES AL1O2                       AL1O2!
 SPECIES AL2                         AL2!
 SPECIES AL2FE1O4                    AL2FE1O4!
 SPECIES AL2O                        AL2O1!
 SPECIES AL2O1                       AL2O1!
 SPECIES AL2O2                       AL2O2!
 SPECIES AL2O3                       AL2O3!
 SPECIES ALO                         AL1O1!
 SPECIES ALO2                        AL1O2!
 SPECIES ALO3/2                      AL1O1.5!
 SPECIES FE+2                        FE1/+2!
 SPECIES FE+3                        FE1/+3!
 SPECIES FE+4                        FE1/+4!
 SPECIES FE1O1                       FE1O1!
 SPECIES FE1O2                       FE1O2!
 SPECIES FE2                         FE2!
 SPECIES FE2O3                       FE2O3!
 SPECIES FEO                         FE1O1!
 SPECIES FEO3/2                      FE1O1.5!
 SPECIES O-2                         O1/-2!
 SPECIES O2                          O2!
 SPECIES O3                          O3!


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--DEFAULT FUNCS-------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
 
 FUNCTION F162T      298.15  +308413.104-26.8663217*T-20.78039*T*LN(T)
     +3.520865E-08*T**2-1.789015E-10*T**3-27114.25*T**(-1);  3.30000E+03  Y
      +294502.846+22.5173774*T-26.85062*T*LN(T)+.001194919*T**2
     -4.501805E-08*T**3+6025110*T**(-1);  6.40000E+03  Y
      +447945.062-285.801392*T+8.243415*T*LN(T)-.0023944315*T**2
     +2.426725E-08*T**3-1.2048605E+08*T**(-1);  9.40000E+03  Y
      +349945.955-150.289475*T-6.454579*T*LN(T)-.0014339715*T**2
     +1.278805E-08*T**3;  1.00000E+04  N !
 FUNCTION F577T      298.15  +68468.7356-29.708552*T-27.37717*T*LN(T)
     -.008706905*T**2+1.34759667E-06*T**3+42904.83*T**(-1);  8.00000E+02  Y
      +70559.2235-26.9045572*T-28.56166*T*LN(T)-.0034503355*T**2
     -1.4328805E-07*T**3-437311.7*T**(-1);  1.60000E+03  Y
      +68575.8626-63.4014165*T-22.54674*T*LN(T)-.009242035*T**2
     +5.66213667E-07*T**3+1636864.5*T**(-1);  2.80000E+03  Y
      -17076.0658+348.591643*T-75.33292*T*LN(T)+.005011805*T**2
     -1.47269833E-07*T**3+27223195*T**(-1);  6000.0  N !
 FUNCTION F587T      298.15  -200250.88+67.6442736*T-45.11105*T*LN(T)
     -.016095035*T**2+2.90117167E-06*T**3+212888.2*T**(-1);  8.00000E+02  Y
      -208337.344+178.095443*T-61.93533*T*LN(T)-1.05714E-04*T**2
     +3.98789667E-09*T**3+970284*T**(-1);  3.00000E+03  N !
 FUNCTION F623T      298.15  +480383.542-1.58706566*T-36.90579*T*LN(T)
     -7.56815E-04*T**2-1.31040183E-07*T**3+16498.85*T**(-1);  1.60000E+03  Y
      +484703.82-58.8210679*T-28.53999*T*LN(T)-.00618347*T**2
     +4.55704333E-07*T**3;  3.10000E+03  Y
      +399551.917+333.52963*T-78.48514*T*LN(T)+.006619755*T**2
     -1.5106045E-07*T**3+26673440*T**(-1);  3.80000E+03  N !
 FUNCTION F768T      298.15  -201660.825+80.9385369*T-49.25823*T*LN(T)
     -.012061425*T**2+2.14597333E-06*T**3+130925.75*T**(-1);  8.00000E+02  Y
      -208004.473+165.926016*T-62.16169*T*LN(T)-3.72899E-05*T**2
     +1.19899483E-09*T**3+738957*T**(-1);  6000.0  N !
 FUNCTION F776T      298.15  -494047.79-72.1054899*T-23.89169*T*LN(T)
     -.0621397*T**2+1.29213783E-05*T**3+78100*T**(-1);  6.00000E+02  Y
      -514422.654+254.039684*T-74.96724*T*LN(T)-.0042506095*T**2
     +4.18842167E-07*T**3+1628653.5*T**(-1);  1.50000E+03  Y
      -521272.731+311.4317*T-82.99675*T*LN(T)-2.4276615E-05*T**2
     +7.14432E-10*T**3+2748177*T**(-1);  6000.0  N !
 FUNCTION F802T      298.15  -575903.151+252.49861*T-82.26331*T*LN(T)
     -.025448955*T**2+4.17391E-06*T**3+366776.4*T**(-1);  8.00000E+02  Y
      -591324.268+447.940009*T-111.611*T*LN(T)-1.2771895E-04*T**2
     +4.43587833E-09*T**3+1918382*T**(-1);  6000.0  N !
 FUNCTION F10105T    298.15  +401732.827+37.9381886*T-32.861*T*LN(T)
     +.00908265*T**2-1.34845667E-06*T**3+108791.4*T**(-1);  9.00000E+02  Y
      +410335.744-51.7107058*T-19.84276*T*LN(T)+6.959445E-05*T**2
     -1.30682983E-07*T**3-976411.5*T**(-1);  2.40000E+03  Y
      +406591.004-47.1975307*T-20.12513*T*LN(T)-5.66549E-04*T**2
     -5.290265E-08*T**3+887592*T**(-1);  5.50000E+03  Y
      +518056.742-373.01803*T+18.70844*T*LN(T)-.00634452*T**2
     +1.038655E-07*T**3-55487750*T**(-1);  1.00000E+04  N !
 FUNCTION F10173T    298.15  +247269.947-13.1139445*T-32.67*T*LN(T)
     -.0075012*T**2+1.18220167E-06*T**3-34235*T**(-1);  9.00000E+02  Y
      +240957.695+66.2179313*T-44.511*T*LN(T)+.00209225*T**2
     -2.42841667E-07*T**3+572515*T**(-1);  2.80000E+03  Y
      +309524.921-212.054229*T-9.622001*T*LN(T)-.00601295*T**2
     +1.2057E-07*T**3-25282085*T**(-1);  5.80000E+03  Y
      +485837.27-638.31461*T+40.074*T*LN(T)-.01226245*T**2
     +2.68271667E-07*T**3-1.4323085E+08*T**(-1);  6000.0  N !
 FUNCTION F10179T    298.15  +58475.2387-2.12934624*T-37.569*T*LN(T)
     -.01894785*T**2+3.36232667E-06*T**3+205940*T**(-1);  7.00000E+02  Y
      +48666.2154+131.021135*T-57.802*T*LN(T)-7.83E-05*T**2
     +2.57666667E-09*T**3+1111465*T**(-1);  6000.0  N !
 FUNCTION F10240T    298.15  +496936.137+167.757207*T-48.04721*T*LN(T)
     +.0045131445*T**2-1.38132583E-06*T**3+1236257.5*T**(-1);  1.10000E+03  Y
      +413625.937+278.684005*T-57.36458*T*LN(T)+7.8394E-05*T**2
     +3.40843667E-07*T**3+40989960.5*T**(-1);  2.50000E+03  Y
      +457326.556+298.173624*T-62.41141*T*LN(T)+.00532538*T**2
     -1.30827917E-07*T**3-6839750*T**(-1);  6000.0  N !
 FUNCTION F13634T    298.15  +243206.494-20.8612587*T-21.01555*T*LN(T)
     +1.2687055E-04*T**2-1.23131283E-08*T**3-42897.09*T**(-1);  2.95000E+03  
     Y
      +252301.423-52.0847285*T-17.21188*T*LN(T)-5.413565E-04*T**2
     +7.64520667E-09*T**3-3973170.5*T**(-1);  6000.0  N !
 FUNCTION F14003T    298.15  -6960.69252-51.1831473*T-22.25862*T*LN(T)
     -.01023867*T**2+1.339947E-06*T**3-76749.55*T**(-1);  9.00000E+02  Y
      -13136.0172+24.743296*T-33.55726*T*LN(T)-.0012348985*T**2
     +1.66943333E-08*T**3+539886*T**(-1);  3.70000E+03  Y
      +14154.6461-51.4854586*T-24.47978*T*LN(T)-.002634759*T**2
     +6.01544333E-08*T**3-15120935*T**(-1);  9.60000E+03  Y
      -314316.628+515.068037*T-87.56143*T*LN(T)+.0025787245*T**2
     -1.878765E-08*T**3+2.9052515E+08*T**(-1);  1.85000E+04  Y
      -108797.175+288.483019*T-63.737*T*LN(T)+.0014375*T**2-9E-09*T**3
     +.25153895*T**(-1);  2.00000E+04  N !
 FUNCTION F14300T    298.15  +130696.944-37.9096651*T-27.58118*T*LN(T)
     -.02763076*T**2+4.60539333E-06*T**3+99530.45*T**(-1);  7.00000E+02  Y
      +114760.623+176.626736*T-60.10286*T*LN(T)+.00206456*T**2
     -5.17486667E-07*T**3+1572175*T**(-1);  1.30000E+03  Y
      +49468.3958+710.094819*T-134.3696*T*LN(T)+.039707355*T**2
     -4.10457667E-06*T**3+12362250*T**(-1);  2.10000E+03  Y
      +866367.075-3566.80563*T+421.2001*T*LN(T)-.1284109*T**2
     +5.44768833E-06*T**3-2.1304835E+08*T**(-1);  2.80000E+03  Y
      +409416.384-1950.70834*T+223.4437*T*LN(T)-.0922361*T**2
     +4.306855E-06*T**3-21589870*T**(-1);  3.50000E+03  Y
      -1866338.6+6101.13383*T-764.8435*T*LN(T)+.09852775*T**2
     -2.59784667E-06*T**3+9.610855E+08*T**(-1);  4.90000E+03  Y
      +97590.0432+890.79836*T-149.9608*T*LN(T)+.01283575*T**2
     -3.555105E-07*T**3-2.1699975E+08*T**(-1);  6000.0  N !
 FUNCTION F700T      298.15  -2038876.81+959.91444*T-155.3938*T*LN(T)
     -.013075*T**2+1566908*T**(-1);  2.05300E+03  N !
 FUNCTION F787T      298.15  -1699084.53+463.030133*T-69.46026*T*LN(T)
     -.0695571*T**2+1.4647905E-05*T**3+966159*T**(-1);  6.00000E+02  Y
      -1717152.63+779.276539*T-119.736*T*LN(T)-.00744798*T**2
     +2.87318833E-07*T**3+2183608.5*T**(-1);  1.50000E+03  Y
      -1765472.13+1084.73224*T-160.4551*T*LN(T)+.007211335*T**2
     -6.42760667E-07*T**3+12643315*T**(-1);  2.30800E+03  N !
 FUNCTION F792T      298.15  -1689981.34+469.457943*T-70.54517*T*LN(T)
     -.0707939*T**2+1.491345E-05*T**3+981167*T**(-1);  6.00000E+02  Y
      -1708394.01+791.595033*T-121.7544*T*LN(T)-.007546725*T**2
     +2.89573167E-07*T**3+2222750*T**(-1);  1.50000E+03  Y
      -1758865.4+1110.41949*T-164.253*T*LN(T)+.007753035*T**2
     -6.82469667E-07*T**3+13162740*T**(-1);  2.29000E+03  N !
 FUNCTION F797T      298.15  -1694673.42+456.64816*T-69.0088*T*LN(T)
     -.0688841*T**2+1.44969317E-05*T**3+960094*T**(-1);  6.00000E+02  Y
      -1712611.55+770.32884*T-118.8687*T*LN(T)-.00734585*T**2
     +2.796585E-07*T**3+2170324.5*T**(-1);  1.50000E+03  Y
      -1760866.16+1075.07673*T-159.4861*T*LN(T)+.007252735*T**2
     -6.44151167E-07*T**3+12625030*T**(-1);  2.31200E+03  N !
 FUNCTION F781T      298.15  -1707353.3+448.021203*T-67.48039*T*LN(T)
     -.06746995*T**2+1.42054467E-05*T**3+938781*T**(-1);  6.00000E+02  Y
      -1724888.03+754.856078*T-116.2579*T*LN(T)-.007225685*T**2
     +2.78531667E-07*T**3+2120702*T**(-1);  1.50000E+03  Y
      -1772165.63+1053.45681*T-156.0582*T*LN(T)+.007091065*T**2
     -6.29401833E-07*T**3+12366670*T**(-1);  2.32700E+03  Y
      -1868789.09+1392.58608*T-192.464*T*LN(T);  4.00000E+03  N !
 FUNCTION F142T      298.15  -7976.15095+137.093054*T-24.3672*T*LN(T)
     -.001884662*T**2-8.77663667E-07*T**3+74092.35*T**(-1);  7.00000E+02  Y
      -11276.2396+223.048449*T-38.58443*T*LN(T)+.01853198*T**2
     -5.76422667E-06*T**3+74092.35*T**(-1);  9.33400E+02  Y
      -11507.187+188.904759*T-31.74819*T*LN(T);  2.90000E+03  N !
 FUNCTION F10170T    298.15  -292304.954+332.506251*T-58.508*T*LN(T)
     +.00435465*T**2-1.51982667E-06*T**3+323095*T**(-1);  1.65000E+03  Y
      -306106.137+415.840209*T-68.2*T*LN(T)-15*T**(-1);  3.00000E+03  N !
 FUNCTION F10270T    298.15  -847288.445+691.541902*T-113.641*T*LN(T)
     -.02191185*T**2-1.27666667E-09*T**3+813725*T**(-1);  1.00000E+03  N !
 FUNCTION F10272T    298.15  -877405.917+885.09611*T-143.718*T*LN(T)
     +.01841615*T**2-1.20420333E-05*T**3+1573510*T**(-1);  7.00000E+02  Y
      -1111615.16+4131.10513*T-638.059*T*LN(T)+.48202345*T**2
     -9.35382167E-05*T**3+22374620*T**(-1);  9.55000E+02  Y
      +3.27006633E+09-34689515*T+5041690*T*LN(T)-3454.0955*T**2
     +.4437025*T**3-3.978962E+11*T**(-1);  9.70000E+02  Y
      +23531923.1-239873.228*T+34422.16*T*LN(T)-21.754045*T**2
     +.00256640667*T**3-3.228093E+09*T**(-1);  1.05000E+03  Y
      -812640.026+424.887189*T-80.37801*T*LN(T)-.02791235*T**2
     +2.06075667E-06*T**3-8342755*T**(-1);  1.81200E+03  Y
      -908058.175+1066.04422*T-165*T*LN(T);  4.00000E+03  N !
 FUNCTION F10092T    298.15  +1225.7335+124.133669*T-23.5143*T*LN(T)
     -.00439752*T**2-5.89269E-08*T**3+77358.5*T**(-1);  1.18480E+03  Y
      -1249.64032+133.270633*T-24.6643*T*LN(T)-.00375752*T**2
     -5.89269E-08*T**3+77358.5*T**(-1);  1.66750E+03  Y
      -613.083946+125.483901*T-23.5143*T*LN(T)-.00439752*T**2
     -5.89269E-08*T**3+77358.5*T**(-1);  1.81100E+03  Y
      -25628.1272+299.878718*T-46*T*LN(T);  6000.0  N !
 FUNCTION F10299T    298.15  -1163383.29+613.642203*T-104.502*T*LN(T)
     -.0885768*T**2-2.12787833E-06*T**3+498705*T**(-1);  9.00000E+02  Y
      -1.87688112E+09+21072487.4*T-3092834*T*LN(T)+2265.38*T**2
     -.311026333*T**3+2.1321835E+11*T**(-1);  9.20000E+02  Y
      +84841141.2-915108.031*T+133080.9*T*LN(T)-91.8423*T**2
     +.0118721917*T**3-1.0414835E+10*T**(-1);  9.70000E+02  Y
      +2112277.84-29721.0904*T+4203.302*T*LN(T)-2.621552*T**2
     +2.92221667E-04*T**3-4.5878255E+08*T**(-1);  1.10000E+03  Y
      -1165334.32+1145.99464*T-193.693*T*LN(T)-.00325635*T**2
     +2.7627E-07*T**3-1239335*T**(-1);  1.70000E+03  N !
 FUNCTION F10089T    298.15  -284454.832+328.485604*T-57.49*T*LN(T)
     +.00488095*T**2-1.52004333E-06*T**3+323120*T**(-1);  1.65000E+03  Y
      -301366.59+422.114457*T-68.2*T*LN(T)-15*T**(-1);  3.00000E+03  N !
	  
	  
	  
 FUNCTION GHSERAL    298.15  -7976.15+137.093038*T-24.3671976*T*LN(T)
     -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1);  7.00000E+02  Y
      -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
     -5.764227E-06*T**3+74092*T**(-1);  9.33470E+02  Y
      -11278.378+188.684153*T-31.748192*T*LN(T)-1.230524E+28*T**(-9);  
     2.90000E+03  N !
 FUNCTION GHSERFE    298.15  +1225.7+124.134*T-23.5143*T*LN(T)
     -.00439752*T**2-5.8927E-08*T**3+77359*T**(-1);  1.81100E+03  Y
      -25383.581+299.31255*T-46*T*LN(T)+2.29603E+31*T**(-9);  6000.0  N 
     !
 FUNCTION GO2GAS     298.15  -6961.74451-76729.7484*T**(-1)
     -51.0057202*T-22.2710136*T*LN(T)-.0101977469*T**2+1.32369208E-06*T**3;  
     1.00000E+03  Y
      -13137.5203+525809.556*T**(-1)+25.3200332*T-33.627603*T*LN(T)
     -.00119159274*T**2+1.35611111E-08*T**3;  3000.0  Y
      -27973.4908+8766421.4*T**(-1)+62.5195726*T-37.9072074*T*LN(T)
     -8.50483772E-04*T**2+2.14409777E-08*T**3;  6000.0  N !
 FUNCTION GOSOL      298.15  +.5*GO2GAS+65*T;   6000.0   N !
 FUNCTION GBCCAL     298.15  +10083-4.813*T+GHSERAL;   6000.0   N 
     !
 FUNCTION L0ALFE     298.15  -30740+7.9972*T;   6000.0   N !
 FUNCTION L1ALFE     298.15  386.15;   6000.0   N !
 FUNCTION GFEFCC     298.15  -1462.4+8.282*T-1.15*T*LN(T)+6.4E-04*T**2
     +GHSERFE;  1.81100E+03  Y
      -1713.815+.94001*T+4.9251E+30*T**(-9)+GHSERFE;  6000.0  N !
 FUNCTION GHFEFCC    298.15  -236.7+132.416*T-24.6643*T*LN(T)
     -.00375752*T**2-5.8927E-08*T**3+77359*T**(-1);  1.81100E+03  Y
      -27097.3963+300.252559*T-46*T*LN(T)+2.78854E+31*T**(-9);  6000.0  
     N !
 FUNCTION UN_ASS 298.15 0; 300 N !
 
 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA /- !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--GAS-----------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
 
 PHASE GAS:G %  1  1.0  !
    CONSTITUENT GAS:G :AL,AL1O1,AL1O2,AL2,AL2O,AL2O1,AL2O2,AL2O3,ALO,ALO2,FE,
    FE1O1,FE1O2,FE2,O,O2,O3 :  !

   PARAMETER G(GAS,AL;0)  298.15  +F162T+R*T*LN(1E-05*P);   
  6000.0   N REF191 !
   PARAMETER G(GAS,AL1O1;0)  298.15  +F577T+R*T*LN(1E-05*P);   
  6000.0   N REF411 !
   PARAMETER G(GAS,AL1O2;0)  298.15  +F587T+R*T*LN(1E-05*P);   
  6000.0   N REF416 !
   PARAMETER G(GAS,AL2;0)  298.15  +F623T+R*T*LN(1E-05*P);   
  6000.0   N REF447 !
   PARAMETER G(GAS,AL2O1;0)  298.15  +F768T+R*T*LN(1E-05*P);   
  6000.0   N REF589 !
   PARAMETER G(GAS,AL2O2;0)  298.15  +F776T+R*T*LN(1E-05*P);   
  6000.0   N REF595 !
   PARAMETER G(GAS,AL2O3;0)  298.15  +F802T+R*T*LN(1E-05*P);   
  6000.0   N REF615 !
   PARAMETER G(GAS,FE;0)  298.15  +F10105T+R*T*LN(1E-05*P);   
  6000.0   N REF5818 !
   PARAMETER G(GAS,FE1O1;0)  298.15  +F10173T+R*T*LN(1E-05*P);   
  6000.0   N REF5869 !
   PARAMETER G(GAS,FE1O2;0)  298.15  +F10179T+R*T*LN(1E-05*P);   
  6000.0   N REF5871 !
   PARAMETER G(GAS,FE2;0)  298.15  +F10240T+R*T*LN(1E-05*P);   
  6000.0   N REF5927 !
   PARAMETER G(GAS,O;0)  298.15  +F13634T+R*T*LN(1E-05*P);   
  6000.0   N REF7934 !
   PARAMETER G(GAS,O2;0)  298.15  +F14003T+R*T*LN(1E-05*P);   
  6000.0   N REF8065 !
   PARAMETER G(GAS,O3;0)  298.15  +F14300T+R*T*LN(1E-05*P);   
  6000.0   N REF8221 !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--LIQUID FUNCS--------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 FUNCTION GAL2O3_L   2.98140E+02  -1607850.8+405.559491*T-67.4804*T*LN(T)
     -.06747*T**2+1.4205433E-05*T**3+938780*T**(-1);  6.00000E+02  Y
      -1625385.57+712.394972*T-116.258*T*LN(T)-.0072257*T**2
     +2.78532E-07*T**3+2120700*T**(-1);  1.50000E+03  Y
      -1672662.69+1010.9932*T-156.058*T*LN(T)+.00709105*T**2
     -6.29402E-07*T**3+12366650*T**(-1);  1.91200E+03  Y
      +29178041.6-168360.926*T+21987.1791*T*LN(T)-6.99552951*T**2
     +4.10226192E-04*T**3-7.98843618E+09*T**(-1);  2.32700E+03  Y
      -1757702.05+1344.84833*T-192.464*T*LN(T);  4.00000E+03  N !
 FUNCTION GFEOLIQ    298.15  -137252+224.641*T-37.1815*T*LN(T);  
     3000.0  N !
 FUNCTION GLIQAL     298.15  +11005.029-11.841867*T+7.934E-20*T**7
     +GHSERAL;  9.33470E+02  Y
      +10482.382-11.253974*T+1.231E+28*T**(-9)+GHSERAL;  6000.0  N !
$ FUNCTION GHSERFE    298.15  +1225.7+124.134*T-23.5143*T*LN(T)
$     -.00439752*T**2-5.8927E-08*T**3+77359*T**(-1);  1.81100E+03  Y
$      -25383.581+299.31255*T-46*T*LN(T)+2.29603E+31*T**(-9);  6000.0  N 
$     !
$ FUNCTION GHSERAL    298.15  -7976.15+137.093038*T-24.3671976*T*LN(T)
$     -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1);  7.00000E+02  Y
$      -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
$     -5.764227E-06*T**3+74092*T**(-1);  9.33470E+02  Y
$      -11278.378+188.684153*T-31.748192*T*LN(T)-1.230524E+28*T**(-9);  
$     2.90000E+03  N !


$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--CORUNDUM FUNCS------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 FUNCTION GCORUND    298.15  -1707351.3+448.021092*T-67.4804*T*LN(T)
     -.06747*T**2+1.4205433E-05*T**3+938780*T**(-1);  6.00000E+02  Y
      -1724886.06+754.856573*T-116.258*T*LN(T)-.0072257*T**2
     +2.78532E-07*T**3+2120700*T**(-1);  1.50000E+03  Y
      -1772163.19+1053.4548*T-156.058*T*LN(T)+.00709105*T**2
     -6.29402E-07*T**3+12366650*T**(-1);  3000.0  N !
 FUNCTION GFE2O3     298.15  -858683+827.946*T-137.0089*T*LN(T)
     +1453810*T**(-1);  3000.0  N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--CORUNDUM------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

$ TYPE_DEFINITION ' GES A_P_D CORUNDUM MAGNETIC  -3.0    2.80000E-01 !
 PHASE CORUNDUM:I %  3 2   1   3 !
    CONSTITUENT CORUNDUM:I :AL+3%,FE+2,FE+3 : FE+3,VA% : O-2% :  !
	
$--Al-O--OXIDE	
$$--END-MEMBERS

   PARAMETER G(CORUNDUM,AL+3:VA:O-2;0)  298.15  +GCORUND;   
  6000.0   N REF598 !
  
$--Fe-O--OXIDE   
$$--END-MEMBERS

   PARAMETER G(CORUNDUM,FE+2:FE+3:O-2;0)  298.15  +GFE2O3+85000;   
  6000.0   N REF3 !
   PARAMETER TC(CORUNDUM,FE+2:FE+3:O-2;0)  298.15  -2867;  3000.0  
  N REF3 !
   PARAMETER BMAGN(CORUNDUM,FE+2:FE+3:O-2;0)  298.15  -25.1;  
  3000.0  N REF3 !
  
   PARAMETER G(CORUNDUM,FE+3:FE+3:O-2;0)  298.15  +GFE2O3+85000;   
  6000.0   N REF3 !
   PARAMETER TC(CORUNDUM,FE+3:FE+3:O-2;0)  298.15  -2867;  3000.0  
  N REF3 !
   PARAMETER BMAGN(CORUNDUM,FE+3:FE+3:O-2;0)  298.15  -25.1;  
  3000.0  N REF3 !  
  
   PARAMETER G(CORUNDUM,FE+2:VA:O-2;0)  298.15  +GFE2O3;   6000.0 
    N REF3 !
   PARAMETER TC(CORUNDUM,FE+2:VA:O-2;0)  298.15  -2867;  3000.0  N 
  REF3 !
   PARAMETER BMAGN(CORUNDUM,FE+2:VA:O-2;0)  298.15  -25.1;  3000.0 
   N REF3 !
   
   PARAMETER G(CORUNDUM,FE+3:VA:O-2;0)  298.15  +GFE2O3;   6000.0 
    N REF3 !
   PARAMETER TC(CORUNDUM,FE+3:VA:O-2;0)  298.15  -2867;  3000.0  N 
  REF3 !
   PARAMETER BMAGN(CORUNDUM,FE+3:VA:O-2;0)  298.15  -25.1;  3000.0 
   N REF3 ! 
 
$--Al-Fe-O--OXIDE
$$--END-MEMBERS

   PARAMETER G(CORUNDUM,AL+3:FE+3:O-2;0)  298.15  +GCORUND+85000;   
  6000.0   N REFLIN !
  
$$--INTERACTIONS
  
   PARAMETER G(CORUNDUM,AL+3,FE+3:VA:O-2;0)  298.15  +110010.11
  -31.780943*T;   6000.0   N REFLIN !
   PARAMETER G(CORUNDUM,AL+3,FE+3:VA:O-2;1)  298.15  25408.249;   
  6000.0   N REFLIN !
   PARAMETER G(CORUNDUM,AL+3,FE+3:VA:O-2;2)  298.15  -65488.58;   
  6000.0   N REFLIN !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--HALITE FUNCS--------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 FUNCTION GWUSTITE   298.15  -279318+252.848*T-46.12826*T*LN(T)
     -.0057402984*T**2;  3000.0  N !
 FUNCTION AWUSTITE   298.15  -55384+27.888*T;  3000.0  N !
 FUNCTION ZERO       298.15 0.0; 6000.00  N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--HALITE--------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

$ TYPE_DEFINITION ) GES A_P_D HALITE MAGNETIC  -3.0    2.80000E-01 !
 PHASE HALITE:I %  2 1   1 !
    CONSTITUENT HALITE:I :AL+3,FE+2,FE+3,VA : O-2:  !

   PARAMETER G(HALITE,VA:O-2;0)  298.15  +ZERO;   6000.0   N REF3 !	
	
$--Al-O--OXIDE
$$--END-MEMBERS  

   PARAMETER G(HALITE,AL+3:O-2;0)  298.15  +50000+.5*GCORUND;   
  6000.0   N REF2 ! 

$--Fe-O--OXIDE
$$--END-MEMBERS   	

   PARAMETER G(HALITE,FE+2:O-2;0)  298.15  +GWUSTITE;   6000.0   
  N REF3 !
   PARAMETER G(HALITE,FE+3:O-2;0)  298.15  +1.25*AWUSTITE
  +1.25*GWUSTITE;   6000.0   N REF3 !
  
$$--INTERACTIONS
  
   PARAMETER G(HALITE,FE+2,FE+3:O-2;0)  298.15  -12324.4;   6000.0 
    N REF3 !
   PARAMETER G(HALITE,FE+2,FE+3:O-2;1)  298.15  20070;   6000.0   
  N REF3 !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--SPINEL FUNCS--------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 FUNCTION GPP        298.15  +1.5*GFEAL2O4-.5*GF2F2VAB+J23;   
     6000.0   N !
 FUNCTION GF2F3F2B   298.15  +GF2F3VAB+GSPDF2VB;   6000.0   N !
 FUNCTION GF2F3VAB   298.15  +7*GFFB;   6000.0   N !
 FUNCTION GFEAL2O4   298.15  -2038876.81+959.91444*T-155.3938*T*LN(T)
     -.013075*T**2+1566908*T**(-1)+222.11456-1.7470282*T+.0033609*T**2;  
     2053.0  N !
 FUNCTION G3P        298.15  -GF2F3VAB+GF3F3VAB+GFEAL2O4+DG3P3P
     -DG2P3P;   6000.0   N !
 FUNCTION GP2        298.15  +J23+.5*GFEAL2O4+.5*GF2F2VAB+DG2P2P;   
     6000.0   N !
 FUNCTION GFE3O4     298.15  -161731+144.873*T-24.9879*T*LN(T)
     -.0011952256*T**2+206520*T**(-1);  3000.0  N !
 FUNCTION D          298.15  +402520-30.529*T;  6000.0  N !
 FUNCTION JFF     298.15  +46826-27.266*T;  6000.0  N !
 FUNCTION GP3        298.15  +GF2F3VAB+.5*GFEAL2O4+J23-.5*GF2F2VAB
     +DG2P3P;   6000.0   N !
 FUNCTION GPV        298.15  +8*GGAMMA-7.5*GFEAL2O4+2.5*GF2F2VAB
     -5*J23+44.9543481*T;   6000.0   N !
 FUNCTION CFE3O4     298.15  +120730-20.102*T;  3000.0  N !
 FUNCTION GF2F2VAB   298.15  +7*GFFB+JFF;   6000.0   N !
 FUNCTION J23        298.15  +29163.95+7.88*T;   6000.0   N !
 FUNCTION GFFB       298.15  -161731+144.873*T-24.9879*T*LN(T)
     -.0011952256*T**2+206520*T**(-1);   6000.0   N !
 FUNCTION GSPDF2VB   298.15  +2*GFFB+D-JFF;   6000.0   N !
 FUNCTION GF3F3VAB   298.15  +7*GFFB-JFF;   6000.0   N !
 FUNCTION DG3P3P     298.15  +133833.21-52.276862*T;   6000.0   N !
 FUNCTION DG2P3P     298.15 0.0; 6000.00  N !
 FUNCTION DG2P2P     298.15 0.0; 6000.00  N !
 FUNCTION GGAMMA     298.15  -1689977.34+469.458181*T-70.5452*T*LN(T)
     -.070794*T**2+1.491345E-05*T**3+981165*T**(-1);  6.00000E+02  Y
      -1708389.72+791.591946*T-121.754*T*LN(T)-.0075467*T**2
     +2.89573E-07*T**3+2222750*T**(-1);  1500.0  Y
      -1758861.74+1110.41976*T-164.253*T*LN(T)+.00775305*T**2
     -6.8247E-07*T**3+13162750*T**(-1);  3000.0  N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--SPINEL--------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 TYPE_DEFINITION * GES A_P_D SPINEL_B MAGNETIC  -3.0    2.80000E-01 !
 PHASE SPINEL_B:I %*  4 1   2   2   4 !
    CONSTITUENT SPINEL_B:I :AL+3,FE+2%,FE+3 : AL+3,FE+2,FE+3%,VA : FE+2,VA% 
    : O-2% :  !

$--Al-O--OXIDE  

$--Fe-O--OXIDE  
$$--END-MEMBERS

   PARAMETER G(SPINEL_B,FE+2:FE+2:FE+2:O-2;0)  298.15  +9*GFE3O4
  +D;  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+2:FE+2:FE+2:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+2:FE+2:FE+2:O-2;0)  298.15  848;  
  2053.0  N REF3 !
  
   PARAMETER G(SPINEL_B,FE+3:FE+2:FE+2:O-2;0)  298.15  +9*GFE3O4
  -JFF+D;  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+3:FE+2:FE+2:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+3:FE+2:FE+2:O-2;0)  298.15  848;  
  2053.0  N REF3 !
  
   PARAMETER G(SPINEL_B,FE+2:FE+3:FE+2:O-2;0)  298.15  +9*GFE3O4
  -JFF+D;  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+2:FE+3:FE+2:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+2:FE+3:FE+2:O-2;0)  298.15  848;  
  2053.0  N REF3 !
  
   PARAMETER G(SPINEL_B,FE+3:FE+3:FE+2:O-2;0)  298.15  +9*GFE3O4
  -2*JFF+D;  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+3:FE+3:FE+2:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+3:FE+3:FE+2:O-2;0)  298.15  848;  
  2053.0  N REF3 !
  
   PARAMETER G(SPINEL_B,FE+2:VA:FE+2:O-2;0)  298.15  +7*GFE3O4-JFF
  +CFE3O4+D;  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+2:VA:FE+2:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+2:VA:FE+2:O-2;0)  298.15  848;  2053.0 
   N REF3 !
   
   PARAMETER G(SPINEL_B,FE+3:VA:FE+2:O-2;0)  298.15  +7*GFE3O4
  -2*JFF+CFE3O4+D;  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+3:VA:FE+2:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+3:VA:FE+2:O-2;0)  298.15  848;  2053.0 
   N REF3 !  
   
   PARAMETER G(SPINEL_B,FE+2:FE+2:VA:O-2;0)  298.15  +7*GFE3O4+JFF;
    2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+2:FE+2:VA:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+2:FE+2:VA:O-2;0)  298.15  848;  2053.0 
   N REF3 !
   
   PARAMETER G(SPINEL_B,FE+3:FE+2:VA:O-2;0)  298.15  +7*GFE3O4;  
  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+3:FE+2:VA:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+3:FE+2:VA:O-2;0)  298.15  848;  2053.0 
   N REF3 !
   
   PARAMETER G(SPINEL_B,FE+2:FE+3:VA:O-2;0)  298.15  +7*GFE3O4;  
  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+2:FE+3:VA:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+2:FE+3:VA:O-2;0)  298.15  848;  2053.0 
   N REF3 !
   
   PARAMETER G(SPINEL_B,FE+3:FE+3:VA:O-2;0)  298.15  +7*GFE3O4-JFF;
    2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+3:FE+3:VA:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+3:FE+3:VA:O-2;0)  298.15  848;  2053.0 
   N REF3 !
   
   PARAMETER G(SPINEL_B,FE+2:VA:VA:O-2;0)  298.15  +5*GFE3O4+CFE3O4;  
  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+2:VA:VA:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+2:VA:VA:O-2;0)  298.15  848;  2053.0  
  N REF3 !
  
   PARAMETER G(SPINEL_B,FE+3:VA:VA:O-2;0)  298.15  +5*GFE3O4-JFF
  +CFE3O4;  2053.0  N REF3 !
   PARAMETER BMAGN(SPINEL_B,FE+3:VA:VA:O-2;0)  298.15  44.54;  
  2053.0  N REF3 !
   PARAMETER TC(SPINEL_B,FE+3:VA:VA:O-2;0)  298.15  848;  2053.0  
  N REF3 !
  
$--Al-Fe-O--OXIDE
$$--END-MEMBERS
	
   PARAMETER G(SPINEL_B,AL+3:AL+3:FE+2:O-2;0)  298.15  +GPP+GF2F3F2B
  -GF2F3VAB;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,FE+2:AL+3:FE+2:O-2;0)  298.15  +GFEAL2O4
  +GF2F3F2B-GF2F3VAB;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,FE+3:AL+3:FE+2:O-2;0)  298.15  +G3P+GF2F3F2B
  -GF2F3VAB;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,AL+3:FE+2:FE+2:O-2;0)  298.15  +GP2+GF2F3F2B
  -GF2F3VAB;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,AL+3:FE+3:FE+2:O-2;0)  298.15  +GP3+GF2F3F2B
  -GF2F3VAB;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,AL+3:VA:FE+2:O-2;0)  298.15  +GPV+GF2F3F2B
  -GF2F3VAB;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,AL+3:AL+3:VA:O-2;0)  298.15  +GPP;  
  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,FE+2:AL+3:VA:O-2;0)  298.15  +GFEAL2O4;  
  2053.0  N REF500 !
   PARAMETER G(SPINEL_B,FE+3:AL+3:VA:O-2;0)  298.15  +G3P;  
  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,AL+3:FE+2:VA:O-2;0)  298.15  +GP2;  
  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,AL+3:FE+3:VA:O-2;0)  298.15  +GP3;  
  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,AL+3:VA:VA:O-2;0)  298.15  +GPV;  2053.0  
  N REF606 !

$$--INTERACTIONS 

   PARAMETER G(SPINEL_B,FE+2:AL+3,FE+3:VA:O-2;0)  298.15  +16426.656
  -6.4652626*T;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,FE+3:AL+3,FE+3:VA:O-2;0)  298.15  -132424.88
  +39.326407*T;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,FE+3:AL+3,FE+3:VA:O-2;1)  298.15  -91226.064
  +80.135254*T;  2053.0  N REFLIN !
   PARAMETER G(SPINEL_B,FE+3:AL+3,FE+3:VA:O-2;2)  298.15  -91.207976*T; 
   2053.0  N REFLIN !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--ALFEO3 FUNC---------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 FUNCTION GALFEO     298.15  -1163720.03+771.9659*T-126.28*T*LN(T)
     -.013681*T**2+1512700*T**(-1)+1.1664E-07*T**3;   6000.0   N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--ALFEO3--------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 PHASE AL1FE1O3  %  3 1   1   3 !
    CONSTITUENT AL1FE1O3  :AL+3 : FE+3 : O-2 :  !

$--Al-Fe-O--OXIDE
$$--END-MEMBERS
	
   PARAMETER G(AL1FE1O3,AL+3:FE+3:O-2;0)  298.15  +GALFEO-120765.33
  +23.2456*T;   6000.0   N REFLIN !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--BCC_A2 ------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--A2/B2 FUNC---------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 FUNCTION L0BCC      298.15  -30740.04+7.9972*T+W1;   6000.0   N !
 FUNCTION W1         298.15  +860*R;   6000.0   N !
 FUNCTION L1BCC      298.15  368.15;   6000.0   N !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
 
 TYPE_DEFINITION & GES A_P_D BCC_A2 MAGNETIC  -1.0    4.00000E-01 !
 PHASE BCC_A2  %&  2 1   3 !
    CONSTITUENT BCC_A2  :AL,FE : O,VA :  !

$$--END-MEMBERS
	
   PARAMETER G(BCC_A2,AL:O;0)  298.15  +GHSERAL+1.5*GO2GAS+195*T;   
  6000.0   N REF2 !
   PARAMETER G(BCC_A2,FE:O;0)  298.15  +GHSERFE+3*GOSOL;  3000.0 
   N REF3 !
   
   PARAMETER G(BCC_A2,AL:VA;0)  298.15  +GBCCAL;   6000.0   N 
  REF1 !
   PARAMETER G(BCC_A2,FE:VA;0)  298.15  +GHSERFE;   6000.0   N 
  REF1 !
   PARAMETER TC(BCC_A2,FE:VA;0)  298.15  1043;   6000.0   N REF10 !
   PARAMETER BMAGN(BCC_A2,FE:VA;0)  298.15  2.22;   6000.0   N 
  REF1 !

$$--INTERACTIONS   
  
   PARAMETER G(BCC_A2,FE:O,VA;0)  298.15  -517548+71.83*T;  3000.0 
   N REF3 !
   
   PARAMETER G(BCC_A2,AL,FE:VA;0)  298.15  +4*L0BCC-4*W1;   
  6000.0   N REF4 !
   PARAMETER G(BCC_A2,AL,FE:VA;1)  298.15  +8*L1BCC;   6000.0   N 
  REF4 !
   PARAMETER TC(BCC_A2,AL,FE:VA;1)  298.15  504;   6000.0   N REF4 !

$$ Same as for the Al-Fe interaction as assessmed by REF4
   PARAMETER G(BCC_A2,AL,FE:O;0)  298.15  +4*L0BCC-4*W1;   
  6000.0   N REFLIN !
   PARAMETER G(BCC_A2,AL,FE:O;1)  298.15  +8*L1BCC;   6000.0   N 
  REFLIN !
   PARAMETER TC(BCC_A2,AL,FE:O;1)  298.15  504;   6000.0   N REFLIN !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--BCC_B2 ------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$   
   
$ THIS PHASE HAS A DISORDERED CONTRIBUTION FROM BCC_A2                  
 TYPE_DEFINITION K GES AMEND_PHASE_DESCRIPTION BCC_B2 DIS_PART BCC_A2,,,!
 PHASE BCC_B2  %KW  3 .5   .5   3 !
    CONSTITUENT BCC_B2  :AL%,FE% : AL,FE : O,VA :  !

$$--END-MEMBERS
	
   PARAMETER G(BCC_B2,AL:AL:VA;0) 298.15 0; 6000 N!
   PARAMETER G(BCC_B2,FE:AL:VA;0)  298.15  -2*W1;   6000.0   
  N REF4 !
   PARAMETER G(BCC_B2,AL:FE:VA;0)  298.15  -2*W1;   6000.0   
  N REF4 !
   PARAMETER G(BCC_B2,FE:FE:VA;0) 298.15 0; 6000 N!   

$$--END-MEMBERS--WITH-O
   
   PARAMETER G(BCC_B2,AL:AL:O;0) 298.15 0; 6000 N!
   PARAMETER G(BCC_B2,FE:AL:O;0)  298.15  -2*W1;   6000.0   
  N REF4 !
   PARAMETER G(BCC_B2,AL:FE:O;0)  298.15  -2*W1;   6000.0   
  N REF4 !
   PARAMETER G(BCC_B2,FE:FE:O;0) 298.15 0; 6000 N!   
   
$$--A2/B2--TYPE-DEF
   

	   
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--FCC_A1 ------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 TYPE_DEFINITION ( GES A_P_D FCC_A1 MAGNETIC  -3.0    2.80000E-01 !
 PHASE FCC_A1  %(  2 1   1 !
    CONSTITUENT FCC_A1  :AL,FE : O,VA :  !

$$--END-MEMBERS	
	
   PARAMETER G(FCC_A1,AL:O;0)  298.15  +GHSERAL+.5*GO2GAS-236446.62;  
   6000.0   N REF2 !
   PARAMETER G(FCC_A1,FE:O;0)  298.15  +GFEFCC+GOSOL;  3000.0  N 
  REF3 !
  
   PARAMETER G(FCC_A1,AL:VA;0)  298.15  +GHSERAL;   6000.0   N 
  REF1 !
   PARAMETER G(FCC_A1,FE:VA;0)  298.15  +GHFEFCC;   6000.0   N 
  REF1 !
   PARAMETER TC(FCC_A1,FE:VA;0)  298.15  67;   6000.0   N REF1 !
   PARAMETER BMAGN(FCC_A1,FE:VA;0)  298.15  .7;   6000.0   N REF1 !
 
$$--INTERACTIONS  
 
   PARAMETER G(FCC_A1,AL:O,VA;0)  298.15  -90252.23;   6000.0   N 
  REF2 !
   PARAMETER G(FCC_A1,FE:O,VA;0)  298.15  -168758+19.17*T;  3000.0 
   N REF3 !
   
   PARAMETER G(FCC_A1,AL,FE:VA;0)  298.15  -76066.1+18.6758*T;   
  6000.0   N REF4 !
   PARAMETER G(FCC_A1,AL,FE:VA;1)  298.15  +21167.4+1.3398*T;   
  6000.0   N REF4 !

$$ Same as for the Al-Fe interaction as assessmed by REF4
   PARAMETER G(FCC_A1,AL,FE:O;0)  298.15  -76066.1+18.6758*T;   
  6000.0   N REFLIN !
   PARAMETER G(FCC_A1,AL,FE:O;1)  298.15  +21167.4+1.3398*T;   
  6000.0   N REFLIN !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--AL2FE---------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ 

 PHASE AL2FE  %  2 2   1 !
    CONSTITUENT AL2FE  :AL : FE :  !

   PARAMETER G(AL2FE,AL:FE;0)  298.15  
   -98096.9+18.7503*T
   +2*GHSERAL+GHSERFE;   6000.0   N REF4 !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--AL13FE4-------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ 

 PHASE AL13FE4  %  3 .6275   .235   .1375 !
    CONSTITUENT AL13FE4  :AL : FE : AL,VA :  !

   PARAMETER G(AL13FE4,AL:FE:AL;0)  298.15  
   -30814.4+7.44*T
   +.765*GHSERAL+.235*GHSERFE;   6000.0   N REF4 !
  
   PARAMETER G(AL13FE4,AL:FE:VA;0)  298.15  
   -27781.3+7.2566*T
   +.6275*GHSERAL+.235*GHSERFE;   6000.0   N REF4 !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--AL5FE2--------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ 

 PHASE AL5FE2  %  2 5   2 !
    CONSTITUENT AL5FE2  :AL : FE :  !

   PARAMETER G(AL5FE2,AL:FE;0)  298.15  
   -228576+48.99503*T+5*GHSERAL
   +2*GHSERFE;   6000.0   N REF4 !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$--AL5FE4--------------------------------------------------------------------$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

 PHASE AL5FE4  %  1  1.0  !
    CONSTITUENT AL5FE4  :AL,FE :  !

   PARAMETER G(AL5FE4,AL;0)  298.15  
   +12178.9-4.813*T+GHSERAL;   6000.0   N REF4 !
  
   PARAMETER G(AL5FE4,FE;0)  298.15  
   +5009.03+GHSERFE;   6000.0   N REF4 !
  
   PARAMETER G(AL5FE4,AL,FE;0)  298.15  
   -131649+29.4833*T;   6000.0   N REF4 !
  
   PARAMETER G(AL5FE4,AL,FE;1)  298.15  
   -18619.5;   6000.0   N REF4 !

$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$



 LIST_OF_REFERENCES
 NUMBER  SOURCE
   REF191  'AL1<G> THERMODATA SGTE ** 
         ALUMINIUM <GAS> 
         New Assessment'
   REF411  'AL1O1<G> THERMODATA 01/93 
         ALUMINIUM MONOXIDE <GAS> 
         28/01/93'
   REF416  'AL1O2<G> THERMODATA 01/93 
         ALUMINIUM DIOXIDE <GAS> 
         28/01/93'
   REF447  'AL2<G> THERMODATA 
         New Assessment'
   REF589  'AL2O1<G> THERMODATA 01/93 
         ALUMINIUM SUBOXIDE <GAS> 
         28/01/93'
   REF595  'AL2O2<G> THERMODATA 01/93 
         ALUMINIUM MONOXIDE <GAS> 
         28/01/93'
   REF615  'AL2O3<G> T.C.R.A.S. Class: 7 
         ALPHA-ALUMINIUM OXIDE <GAS>'
   REF5818 'FE1<G> THERMODATA 
         Data provided by T.C.R.A.S. October 1996 
         Modified by Thermodata - new assessment'
   REF5869 'FE1O1<G> T.C.R.A.S Class: 5 
         Data provided by T.C.R.A.S. in 2000'
   REF5871 'FE1O2<G> T.C.R.A.S Class: 6 
         Data provided by TCRAS. October 1996. Error in version 1997. 
         S298 corrected to 1bar'
   REF5927 'FE2<G> THERMODATA 
         Data provided by T.C.R.A.S. October 1996 
         Modified by Thermodata - new assessment'
   REF7934 'O1<G> JANAF 1982; ASSESSMENT DATED 3/77 SGTE 
         OXYGEN <MONATOMIC GAS>'
   REF8065 'O2<G> T.C.R.A.S. Class: 1 
         OXYGEN <DIATOMIC GAS>'
   REF8221 'O3<G> T.C.R.A.S. Class: 4 
         OZONE <GAS>'
   REF500  'AL2FE1O4 KUBASCHEWSKI EVANS ALCOCK1967 SGTE 
         IRON DIALUMINIUM TETROXIDE 
         FE1AL2O4 SUBIT UNE DECOMPOSITION PERITECTIQUE A 1713.15K. 
         DELTA H298 CALCULE A PARTIR DES OXYDES=-6600.0'
   REF602  'AL2O3<AL2O3_DELTA> JANAF THERMOCHEMICAL TABLES SGTE 
         DELTA-AL2O3 
         PUB. BY JANAF AT 6/75 **.AL2O3(DELTA) ALWAYS METASTABLE COMPARED 
         TO ALPHA. HEAT OF FUSION CALCULATED :2308K . 1978 SUPPL.'
   REF606  'AL2O3<AL2O3_GAMMA> JANAF THERMOCHEMICAL TABLES SGTE 
         GAMMA-AL2O3 
         PUBLISHED BY JANAF AT 6/75 ** 
         AL2O3(GAMMA) EST TOUJOURS METASTABLE PAR RAPPORT A ALPHA 
         T FUSION CALCULEE : 2290K. 1978 SUPPL.'
   REF611  'AL2O3<AL2O3_KAPPA> JANAF THERMOCHEMICAL TABLES SGTE ** 
         KAPPA-AL2O3 
         PUBL. BY JANAF AT 6/75 **.AL2O3(KAPPA) ALWAYS METASTABLE COMPARED 
         TO ALPHA. HEAT OF FUSION CALCULATED :2312K .'
   REF598  'AL2O3 JANAF THERMOCHEMICAL TABLES SGTE 
         ALPHA-ALUMINIUM OXIDE 
         PUBLISHED BY JANAF AT 6/75 **.DATA CORRESPOND TO AL2O3(ALPHA) 
         1978 SUPPL'
   REF167  'AL1 JANAF THERMOCHEMICAL TABLES SGTE ** 
         ALUMINIUM 
         AT WEIGHT 26.9815 - U.D. 30/10/85 CODATA KEY VALUES FOR 298.15K'
   REF5867 'FE1O1 T.C.R.A.S Class: 5 
         IRON OXIDE. Data provided by T.C.R.A.S. in 2000'
   REF5954 'FE2O3<FE2O3_GAMMA> T.C.R.A.S Class: 5 
         Data provided by T.C.R.A.S. in 2000'
   REF5956 'FE2O3<FE2O3_HEMATITE> T.C.R.A.S Class: 7 
         Data provided by T.C.R.A.S. in 2000 with previous description 
         of the magnetic transition fitted by IA. In version 2000 only 
         H298 has been changed.'
   REF5811 'FE1 S.G.T.E. ** 
         Data from SGTE Unary DB'
   REF5982 'FE3O4<MAGNETITE> JANAF 4th Ed. 
         Data refitted by IA to reproduce the magnetic transition.'
   REF5809 'FE0.947O1<WUSTITE> T.C.R.A.S Class: 5 
         WUSTITE. Data provided by T.C.R.A.S. in 2000'
   REF1   'SGTE' 
   REF2   '*Al-O*(1) J.R.Taylor, A.T.Dinsdale, M.Hilleit, M.Selleby, 
         A Critical Assessment of Thermodynamic and Phase Diagram 
         Data for the Al-O System, Calphad. 16 (1992) 173-179.  
         (2) H.Mozaffarie-Jovein, Enwincklung und Einsatz von 
         keramischen Materialien als Warmedammschicht fur 
         Ni-Basis-legierungen fur Temperaturen gosser als 1350C,
         Universitat Stuttgart, 2002.' 
   REF3   '*Fe-O*(1) L.Kjellqvist, M.Selleby, B.Sundman, Thermodynamic 
         modelling of the Cr-Fe-Ni-O system, Calphad. 32 (2008) 577-592.
         (2) B.Sundman, An Assessment of the Fe-O System, 
         J. Phase Equilibria. 12 (1991) 127-140.
         (3) M.Kowalski, P.J.Spencer, Thermodynamic reevaluation 
         of the Cr-O, Fe-O and Ni-O systems, Calphad. 19 (1995) 229-243.' 
   REF4   '*Al-Fe*(1) I.Ansara, A.T.Dinsdale, M.H.Rand, COST 507, 
         Thermochem. Database Light Met. Alloy. 2 (1998) 20-22' 
   REFLIN '*Al-Fe-O* G.Lindwall, X.L.Liu, A.Ross, H.Fang, B.C.Zhou, Z.K.Liu, 
         Thermodynamic Modeling of the Aluminum-Iron-Oxygen System,
         This work submitted to CALPHAD (2015)' 
  ! 
"""

ZRLAYALO_TDB = """

$ Database file written 2009- 1-29
$ From database: User data 2009. 1.29    
 ELEMENT /-   ELECTRON_GAS              0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT VA   VACUUM                    0.0000E+00  0.0000E+00  0.0000E+00!
 ELEMENT LA   DOUBLE_HCP(ABAC)          1.3891E+02  0.0000E+00  0.0000E+00!
 ELEMENT O    1/2_MOLE_O2(G)            1.5999E+01  4.3410E+03  1.0252E+02!
 ELEMENT Y    HCP(A3)                   8.8906E+01  5.9664E+03  4.4434E+01!
 ELEMENT ZR   HCP_A3                    9.1224E+01  5.5663E+03  3.9181E+01!
 ELEMENT AL   FCC_A1                    2.6982E+01  4.5773E+03  2.8321E+01!

 SPECIES AL+3                        AL1/+3!
 SPECIES AL1                         AL!
 SPECIES AL1O1                       AL1O1!
 SPECIES AL1O2                       AL1O2!
 SPECIES AL2                         AL2!
 SPECIES AL2O                        AL2O1!
 SPECIES AL2O1                       AL2O1!
 SPECIES AL2O2                       AL2O2!
 SPECIES AL2O3                       AL2O3!
 SPECIES ALO                         AL1O1!
 SPECIES ALO2                        AL1O2!
 SPECIES ALO3/2                      AL1O1.5!
 SPECIES LA+3                        LA1/+3!
 SPECIES LA1O1                       LA1O1!
 SPECIES LA2O3                       LA2O3!
 SPECIES LAO3/2                      LA1O1.5!
 SPECIES O-2                         O1/-2!
 SPECIES O2                          O2!
 SPECIES Y+3                         Y1/+3!
 SPECIES Y2O                         O1Y2!
 SPECIES Y2O2                        O2Y2!
 SPECIES Y2O3                        O3Y2!
 SPECIES YO                          O1Y1!
 SPECIES YO2                         O2Y1!
 SPECIES YO3/2                       O1.5Y1!
 SPECIES ZR+4                        ZR1/+4!
 SPECIES ZRO2                        O2ZR1!
 
  
 FUNCTION GHSEROO    2.98150E+02  -3480.87-25.503038*T
-11.136*T*LN(T)
     -.005098888*T**2+6.61846E-07*T**3-38365*T**(-1); 
 1.00000E+03  Y
      -6568.763+12.65988*T-16.8138*T*LN(T)-5.95798E-04*T**2
+6.781E-09*T**3
     +262905*T**(-1);  3.30000E+03  Y
      -13986.728+31.259625*T-18.9536*T*LN(T)-4.25243E-04*T**2
     +1.0721E-08*T**3+4383200*T**(-1);  6.00000E+03  N !
 FUNCTION GHSERZR    2.98150E+02  -7827.595+125.64905*T
-24.1618*T*LN(T)
     -.00437791*T**2+34971*T**(-1);  2.12800E+03  Y
      -26085.921+262.724183*T-42.144*T*LN(T)
-1.342895E+31*T**(-9);  
     6.00000E+03  N !
 FUNCTION GZRBCC     2.98140E+02  +7302.056-.70335*T
-1.445606*T*LN(T)
     +.004037826*T**2-9.7289735E-09*T**3-7.6142894E-11*T**4
-9737*T**(-1)
     +GHSERZR#;  2.12800E+03  Y
      -4620.034+1.55998*T+1.41035E+32*T**(-9)+GHSERZR#;  6.00000E+03  N !
 FUNCTION GZRFCC     2.98150E+02  +7600-.9*T+GHSERZR#;   6.00000E+03   N !
 FUNCTION GZRLIQ     2.98150E+02  +18147.703-9.080762*T
+1.6275E-22*T**7 +GHSERZR#;  2.12800E+03  Y
      +17804.649-8.91153*T+1.343E+31*T**(-9)+GHSERZR#;  
6.00000E+03  N !
 FUNCTION GZRO2M     2.98150E+02  -1126163.54+424.890806*T
     -69.3875137*T*LN(T)-.00375880141*T**2+683000*T**(-1);
   6.00000E+03   N   !
 FUNCTION GZRO2T     2.98150E+02  +5468-4*T+GZRO2M#;  
 6.00000E+03   N !
 FUNCTION GZRO2C     2.98150E+02  +10336-4*T+GZRO2T#;  
 6.00000E+03   N !
 FUNCTION GZRO2L     2.98150E+02  +87027-29.17432*T+GZRO2C#;
   6.00000E+03    N !
 FUNCTION GHSERLA    2.98140E+02  -7968.403+120.284604*T
  -26.34*T*LN(T)-.001295165*T**2;  5.50000E+02  Y
      -3381.413+59.06113*T-17.1659411*T*LN(T)-.008371705*T**2
     +6.8932E-07*T**3-399448*T**(-1);  2.00000E+03  Y
      -15608.882+181.390071*T-34.3088*T*LN(T);  4.00000E+03  N !
 FUNCTION GLABCC     2.98140E+02  -3952.161+88.072353*T
 -21.7919*T*LN(T)-.004045175*T**2-5.25865E-07*T**3; 
 8.00000E+02  Y
      +321682.673-3565.08252*T+513.440708*T*LN(T)
  -.387295093*T**2
     +4.9547989E-05*T**3-36581228*T**(-1);  1.13400E+03  Y
      -16377.894+218.492988*T-39.5388*T*LN(T);  1.19300E+03  Y
      -136609.91+1123.34397*T-163.413074*T*LN(T)
  +.053968535*T**2
     -4.056395E-06*T**3+21167204*T**(-1);  2.00000E+03  Y
      -8205.988+174.836315*T-34.3088*T*LN(T);  4.00000E+03  N !
 FUNCTION GLAFCC     2.98140E+02  -6109.797+89.878761*T
 -21.7919*T*LN(T)
     -.004045175*T**2-5.25865E-07*T**3;  1.13400E+03  Y
      -124598.976+955.878375*T-139.346741*T*LN(T)+.042032405*T**2
     -3.066199E-06*T**3+20994153*T**(-1);  2.00000E+03  Y
      -12599.386+178.54399*T-34.3088*T*LN(T);  4.00000E+03  N !
 FUNCTION GLALIQ     2.98140E+02  +5332.653+18.23012*T
 -11.0188191*T*LN(T)
     -.020171603*T**2+2.93775E-06*T**3-133541*T**(-1); 
 1.13400E+03  Y
      -3942.004+171.018431*T-34.3088*T*LN(T);  4.00000E+03  N !
 FUNCTION GLA2O3A    2.98150E+02  -1833257+692.9664*T
-120.629*T*LN(T)
     -.006854*T**2+808000*T**(-1)-10000000*T**(-2);
   6.00000E+03   N !
 FUNCTION GLA2O3H    2.98150E+02  +GLA2O3A#+32350-13.986*T;
   6.00000E+03    N !
 FUNCTION GLA2O3X    2.98150E+02  +GLA2O3A#+43192-18.555*T; 
  6.00000E+03    N !
 FUNCTION GLA2O3B    2.98150E+02  +GLA2O3A#+4139+2.215*T;   6.00000E+03   N !
 FUNCTION GLA2O3C    2.98150E+02  +GLA2O3A#+8337+7.788*T;   6.00000E+03   N !
 FUNCTION GLA2O3L    2.98150E+02  +141329-56.622*T+GLA2O3A#; 
  6.00000E+03     N !
FUNCTION GAL2O3_L   2.98140E+02  -1607850.8+405.559491*T
 -67.4804*T*LN(T)-.06747*T**2+1.4205433E-05*T**3+938780*T**(-1);  
  6.00000E+02  Y
    -1625385.57+712.394972*T-116.258*T*LN(T)-.0072257*T**2
     +2.78532E-07*T**3+2120700*T**(-1);  1.50000E+03  Y
      -1672662.69+1010.9932*T-156.058*T*LN(T)+.00709105*T**2
   -6.29402E-07*T**3+12366650*T**(-1);  1.91200E+03  Y
    +29178041.6-168360.926*T+21987.1791*T*LN(T)-6.99552951*T**2
   +4.10226192E-04*T**3-7.98843618E+09*T**(-1);  2.32700E+03  Y
    -1757702.05+1344.84833*T-192.464*T*LN(T);  4.00000E+03  N !
 FUNCTION GCORUND    2.98140E+02  -1707351.3+448.021092*T
  -67.4804*T*LN(T) -.06747*T**2+1.4205433E-05*T**3
  +938780*T**(-1); 6.00000E+02  Y
      -1724886.06+754.856573*T-116.258*T*LN(T)-.0072257*T**2
     +2.78532E-07*T**3+2120700*T**(-1);  1.50000E+03  Y
      -1772163.19+1053.4548*T-156.058*T*LN(T)+.00709105*T**2
     -6.29402E-07*T**3+12366650*T**(-1);  3.00000E+03  N !
 FUNCTION GHSERAL    2.98140E+02  
  -7976.15+137.093038*T-24.3671976*T*LN(T)
     -.001884662*T**2-8.77664E-07*T**3+74092*T**(-1); 
 7.00000E+02  Y
      -11276.24+223.048446*T-38.5844296*T*LN(T)+.018531982*T**2
     -5.764227E-06*T**3+74092*T**(-1);  9.33470E+02  Y
      -11278.378+188.684153*T-31.748192*T*LN(T)
 -1.230524E+28*T**(-9);    2.90000E+03  N !
 FUNCTION GHSERYY    2.98140E+02  -8011.09379+128.572856*T
     -25.6656992*T*LN(T)-.00175716414*T**2-4.17561786E-07*T**3
     +26911.509*T**(-1);  1.00000E+03  Y
      -7179.74574+114.497104*T-23.4941827*T*LN(T)
 -.0038211802*T**2
     -8.2534534E-08*T**3;  1.79515E+03  Y
      -67480.7761+382.124727*T-56.9527111*T*LN(T)
 +.00231774379*T**2
     -7.22513088E-08*T**3+18077162.6*T**(-1);  3.70000E+03  N !
 FUNCTION GBCCYY     2.98140E+02  -833.658863+123.667346*T
     -25.5832578*T*LN(T)-.00237175965*T**2+9.10372497E-09*T**3
     +27340.0687*T**(-1);  1.00000E+03  Y
      -1297.79829+134.528352*T-27.3038477*T*LN(T)
 -5.41757644E-04*T**2
     -3.05012175E-07*T**3;  1.79515E+03  Y
      +15389.4975+.981325399*T-8.88296647*T*LN(T)
 -.00904576576*T**2
     +4.02944768E-07*T**3-2542575.96*T**(-1);  3.70000E+03  N !
 FUNCTION GLIQYY     2.98140E+02  +2098.50738+119.41873*T
 -24.6467508*T*LN(T)
     -.00347023463*T**2-8.12981167E-07*T**3
 +23713.7332*T**(-1);  1.00000E+03  Y
    +7386.44846+19.4520171*T-9.0681627*T*LN(T)-.0189533369*T**2
     +1.7595327E-06*T**3;  1.79515E+03  Y
      -12976.5957+257.400783*T-43.0952*T*LN(T);  3.70000E+03  N !
 FUNCTION GY2O3R      2.98150E+02  -1976462+731.6512*T
-121.881*T*LN(T)-.00506*T**2+1090000*T**(-1)-13000000*T**(-2);  
 6.00000E+03   N !
 FUNCTION GZYO       2.98150E+02  +.4286*GZRO2C#+.2857*GY2O3R#
 -14550.3912 -.520412688*T;   6.00000E+03   N !
 FUNCTION GLA2O3F    2.98150E+02  +GLA2O3A#+50000;   
 6.00000E+03   N !
 FUNCTION GLA2O3T    2.98150E+02  +GLA2O3F#+10000;   
 6.00000E+03   N !
 FUNCTION GPYRLAZR   2.98150E+02  -4194070.04+1531.07053*T
 -260.811*T*LN(T)
     +1898400*T**(-1)-.00891455*T**2;   6.00000E+03   N !
FUNCTION GPYRYZR    2.98150E+02  +GY2O3R#+2*GZRO2C#+2.0E+03;
   6.00000E+03 N !
 FUNCTION GPYRYY     2.98150E+02  +2*GY2O3R#+5.0E+03;  
 6.00000E+03   N !
 FUNCTION GPYRLAY    2.98150E+02  +GLA2O3A#+GY2O3R#+9.0E4;
 6.00000E+03   N !
 FUNCTION GANCA      2.98150E+02  400000;   6.00000E+03   N !
 FUNCTION GANCA1     2.98150E+02  +8.0E+04;   6.00000E+03   N !
 FUNCTION GANCA2     2.98150E+02  +3E+04;   6.00000E+03   N !
 FUNCTION GPYROZR    2.98150E+02  +4*GZRO2C#+10000+16*T;
 6.00000E+03   N !
 FUNCTION GPYROLA    2.98150E+02  +2*GLA2O3A#+160000;  
 6.00000E+03   N !
 FUNCTION GREC1      298.15 0.0; 6000.00  N !
 FUNCTION GREC2      2.98150E+02  120000;   6.00000E+03   N !
 FUNCTION GREC3      298.15 0.0; 6000.00  N !
 FUNCTION GREC4      298.15 0.0; 6000.00  N !
 FUNCTION GREC5      298.15 0.0; 6000.00  N !
 FUNCTION GREC6      298.15 0.0; 6000.00  N !
 FUNCTION GREC7      298.15 0.0; 6000.00  N !
 FUNCTION GREC8      298.15 0.0; 6000.00  N !
 FUNCTION GREC9      298.15 0.0; 6000.00  N !
 FUNCTION GREC10     298.15 0.0; 6000.00  N !
 FUNCTION GREC11     298.15 0.0; 6000.00  N !
 FUNCTION GREC102    2.98150E+02  +1.61E+05;   6.00000E+03   N !
 FUNCTION GREC101    298.15 0.0; 6000.00  N !
 FUNCTION GREC103    298.15 0.0; 6000.00  N !
 FUNCTION GREC104    298.15 0.0; 6000.00  N !
 FUNCTION GREC105    298.15 0.0; 6000.00  N !
 FUNCTION GREC107    298.15 0.0; 6000.00  N !
 FUNCTION GREC108    298.15 0.0; 6000.00  N !
 FUNCTION GREC109    298.15 0.0; 6000.00  N !
 FUNCTION GREC111    298.15 0.0; 6000.00  N !
 FUNCTION GREC201    298.15 0.0; 6000.00  N !
 FUNCTION GREC202    298.15 0.0; 6000.00  N !
 FUNCTION GREC209    298.15 0.0; 6000.00  N !
 FUNCTION GREC301    298.15 0.0; 6000.00  N !
 FUNCTION GREC303    298.15 0.0; 6000.00  N !
 FUNCTION GREC309    298.15 0.0; 6000.00  N !
 FUNCTION GLAYP      2.98150E+02  -1946588.1+737.23096*T
   -123.362712*T*LN(T)
   -.00221374777*T**2+741418.873*T**(-1);   6.00000E+03   N !
 FUNCTION GLAAP      2.98150E+02  -1.8452069E+06+7.2320269E+02*T
   -1.1876439E+02*T*LN(T)-6.1979994E-03*T**2
   +1.3806196E+06*T**(-1);   6000   N !
 FUNCTION GYAG       2.98140E+02  -7363443.37+2714.0547*T-438.9177*T*LN(T)
     -.034315335*T**2+4800831.7*T**(-1);  3.00000E+03  N !
 FUNCTION GYAM       2.98140E+02  -5686303.14+2239.26502*T
   -368.158373*T*LN(T)-.018363228*T**2+4310328.16*T**(-1);  3.00E+03  N  !

 FUNCTION UN_ASS 298.15 0; 300 N !
 
 TYPE_DEFINITION % SEQ *!
 DEFINE_SYSTEM_DEFAULT ELEMENT 2 !
 DEFAULT_COMMAND DEF_SYS_ELEMENT VA /- !


  PHASE IONIC_LIQ:Y %  2 1   1 !
    CONSTITUENT IONIC_LIQ:Y :LA+3,Y+3,ZR+4 : O-2,ALO3/2 :  !

   PARAMETER G(IONIC_LIQ,LA+3:O-2;0)  2.98150E+02  
   +GLA2O3L#; 6.00000E+03  N REF0 !
   PARAMETER G(IONIC_LIQ,Y+3:O-2;0)  2.98150E+02  +108779
   -40.509*T+GY2O3R#;    6.00000E+03   N REF0 !
   PARAMETER G(IONIC_LIQ,ZR+4:O-2;0)  2.98150E+02  +2*GZRO2L#;
   6.00000E+03   N REF0 !
   PARAMETER G(IONIC_LIQ,ALO3/2;0)  2.98150E+02  +.5*GAL2O3_L#;   
   6.00000E+03   N REF:0 !
   PARAMETER G(IONIC_LIQ,LA+3,ZR+4:O-2;0)  2.98150E+02 
   -168369.962;   6.00000E+03   N REF0 !
   PARAMETER G(IONIC_LIQ,LA+3,ZR+4:O-2;1)  2.98150E+02  
   -27425.9756;   6.00000E+03   N REF0 !
   PARAMETER G(IONIC_LIQ,Y+3,ZR+4:O-2;0)  2.98150E+02  
   +11488.4008;    6.00000E+03   N REF0 !
   PARAMETER G(IONIC_LIQ,Y+3,ZR+4:O-2;1)  2.98150E+02 
   +1608.38521;   6.00000E+03   N REF0 !
  PARAMETER G(IONIC_LIQ,LA+3,ZR+4:O-2,ALO3/2;0)  2.98150E+02
   190000;    6.00000E+03   N REF:0 !
 PARAMETER G(IONIC_LIQ,LA+3:O-2,ALO3/2;0)  2.98150E+02  
  -1.88377985E+05;   6.00000E+03   N REF0 !
   PARAMETER G(IONIC_LIQ,LA+3:O-2,ALO3/2;1)  2.98150E+02  
  -6.87136229E+04;   6.00000E+03   N REF0 !
   PARAMETER G(IONIC_LIQ,ZR+4:O-2,ALO3/2;0)  2.98150E+02  
 50000;    6.00000E+03   N REF:0 !
   PARAMETER G(IONIC_LIQ,ZR+4:O-2,ALO3/2;1)  2.98150E+02 
  -40000;    6.00000E+03   N REF:0 !
   PARAMETER G(IONIC_LIQ,Y+3:O-2,ALO3/2;0)  2.98150E+02  
 -124454.878+12.2306693*T;   6.00000E+03   N REF:0 !
   PARAMETER G(IONIC_LIQ,Y+3:O-2,ALO3/2;1)  2.98150E+02  
  +266563.943-151.915942*T;   6.00000E+03   N REF:0 !
   PARAMETER G(IONIC_LIQ,Y+3,ZR+4:O-2,ALO3/2;0)  2.98150E+02 
 -89310.9277+8.79137067*T;   6.00000E+03   N REF:0 !


PHASE BETA_AL11LA1O18  %  3 11   1   18 !
    CONSTITUENT BETA_AL11LA1O18  :AL+3 : LA+3 : O-2 :  !

  PARAMETER G(BETA_AL11LA1O18,AL+3:LA+3:O-2;0)  2.98150E+02 
  +5.5*GCORUND#
  +.5*GLA2O3A#-6.90997182E+04-10*T;   6.00000E+03   N REF:0 !


 TYPE_DEFINITION & GES A_P_D CORUNDUM MAGNETIC  -3.0  
   2.80000E-01 !
 PHASE CORUNDUM  %&  3 2   1   3 !
    CONSTITUENT CORUNDUM  :AL+3 : VA : O-2 :  !

   PARAMETER G(CORUNDUM,AL+3:VA:O-2;0)  2.98150E+02  +GCORUND#;   
   6.00000E+03   N REF:0 !


 PHASE FLUORITE:I %  2 2   4 !
    CONSTITUENT FLUORITE:I :AL+3,LA+3,Y+3,ZR+4 : O-2,VA :  !

   PARAMETER G(FLUORITE,AL+3:O-2;0)  2.98150E+02 +GCORUND#
  +GHSEROO#+18.702165*T+100000;   6.00000E+03   N REF:0 !
  PARAMETER G(FLUORITE,AL+3:VA;0)  2.98150E+02  +GCORUND#
  -3*GHSEROO#+18.702165*T+100000;   6.00000E+03   N REF:0 !
   PARAMETER G(FLUORITE,LA+3:O-2;0)  2.98150E+02 
  +GLA2O3F#+GHSEROO#+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(FLUORITE,Y+3:O-2;0)  2.98150E+02  +GY2O3R#+4000
  +GHSEROO#+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(FLUORITE,ZR+4:O-2;0)  2.98150E+02  +2*GZRO2C#; 
  6.00000E+03  N REF0 !
   PARAMETER G(FLUORITE,LA+3:VA;0)  2.98150E+02  +GLA2O3F#
  -3*GHSEROO#+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(FLUORITE,Y+3:VA;0)  2.98150E+02  +GY2O3R#+4000
  -3*GHSEROO#+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(FLUORITE,ZR+4:VA;0)  2.98150E+02  +2*GZRO2C#
  -4*GHSEROO#;    6.00000E+03   N REF0 !
   PARAMETER G(FLUORITE,LA+3,ZR+4:*;0)  2.98150E+02  
 -170010.399;    6.00000E+03   N REF0 !
   PARAMETER G(FLUORITE,LA+3,ZR+4:*;1)  2.98150E+02  
 -134621.411;    6.00000E+03   N REF0 !
  PARAMETER G(FLUORITE,LA+3,Y+3:*;0)  2.98150E+02  -2.0E+03;   
   6.00000E+03   N  REF0 !
   PARAMETER G(FLUORITE,Y+3,ZR+4:*;0)  2.98150E+02  -130802.772
  +50.199044*T; 6.00000E+03   N REF0 !
   PARAMETER G(FLUORITE,Y+3,ZR+4:*;1)  2.98150E+02  +134082.393
  -42.0543792*T; 6.00000E+03   N REF0 !
  PARAMETER G(FLUORITE,LA+3,Y+3,ZR+4:*;0)  2.98150E+02  -52700
  -100*T;   6.00000E+03   N  REF0 !
 PARAMETER G(FLUORITE,AL+3,ZR+4:*;0)  2.98150E+02  18500; 
   6.00000E+03  N REF:0 !
 PARAMETER G(FLUORITE,AL+3,LA+3:*;0)  298.15  0; 6000  N REF:0 !


 PHASE LA2O3_A:I %  3 2   3   1 !
    CONSTITUENT LA2O3_A:I :LA+3,Y+3,ZR+4 : O-2 : O-2,VA :  !

   PARAMETER G(LA2O3_A,LA+3:O-2:O-2;0)  2.98150E+02   
  +GLA2O3A#+GHSEROO#;    6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_A,Y+3:O-2:O-2;0)  2.98150E+02  +18569
  -5.439*T+GY2O3R#+GHSEROO#;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_A,ZR+4:O-2:O-2;0)  2.98150E+02  +2*GZRO2C#
  +50000;    6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_A,LA+3:O-2:VA;0)  2.98150E+02  +GLA2O3A#;
   6.00000E+03  N REF0 !
   PARAMETER G(LA2O3_A,Y+3:O-2:VA;0)  2.98150E+02  +18569
   -5.439*T+GY2O3R#;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_A,ZR+4:O-2:VA;0)  2.98150E+02  +2*GZRO2C#
   -GHSEROO#+50000;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_A,LA+3,Y+3:O-2:*;0)  2.98150E+02 
  +28018.3771;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_A,LA+3,Y+3:O-2:*;1)  2.98150E+02  
   +3073.21531;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_A,LA+3,ZR+4:O-2:*;0)  2.98150E+02  +20000;
   6.00000E+03  N REF0 !
   PARAMETER G(LA2O3_A,Y+3,ZR+4:O-2:*;0)  2.98150E+02  +100000;
   6.00000E+03   N REF0 !


 PHASE LA2O3_H:I %  3 2   3   1 !
    CONSTITUENT LA2O3_H:I :LA+3,Y+3,ZR+4 : O-2 : O-2,VA :  !

   PARAMETER G(LA2O3_H,LA+3:O-2:O-2;0)  2.98150E+02 
 +GLA2O3H#+GHSEROO#;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_H,Y+3:O-2:O-2;0)  2.98150E+02  +25100
 -9.654*T+GY2O3R#+GHSEROO#;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_H,ZR+4:O-2:O-2;0)  2.98150E+02  +2*GZRO2C#
 +20000;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_H,LA+3:O-2:VA;0)  2.98150E+02  +GLA2O3H#;
   6.00000E+03  N REF0 !
   PARAMETER G(LA2O3_H,Y+3:O-2:VA;0)  2.98150E+02  +25100
  -9.654*T+GY2O3R#;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_H,ZR+4:O-2:VA;0)  2.98150E+02  +2*GZRO2C#
 -GHSEROO#+20000;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_H,LA+3,ZR+4:O-2:*;0)  2.98150E+02  -31800;   
  6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_H,LA+3,Y+3:O-2:*;0)  2.98150E+02
 + 23306.5767;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_H,Y+3,ZR+4:O-2:*;0)  2.98150E+02  180000;   6.00000E+03 
    N REF0 !


 PHASE LA2O3_X:I %  3 2   3   1 !
    CONSTITUENT LA2O3_X:I :LA+3,Y+3,ZR+4 : O-2 : O-2,VA :  !

   PARAMETER G(LA2O3_X,LA+3:O-2:O-2;0)  2.98150E+02 
 +GLA2O3X#+GHSEROO#;    6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_X,Y+3:O-2:O-2;0)  2.98150E+02  +37765
 -14.223*T+GY2O3R#+GHSEROO#;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_X,ZR+4:O-2:O-2;0)  2.98150E+02  +2*GZRO2C#
 +10000;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_X,LA+3:O-2:VA;0)  2.98150E+02  +GLA2O3X#; 
  6.00000E+03  N REF0 !
   PARAMETER G(LA2O3_X,Y+3:O-2:VA;0)  2.98150E+02  +37765
 -14.223*T+GY2O3R#;    6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_X,ZR+4:O-2:VA;0)  2.98150E+02  +2*GZRO2C#
 -GHSEROO#+10000;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_X,LA+3,ZR+4:O-2:*;0)  2.98150E+02  -28000;   
  6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_X,LA+3,Y+3:O-2:*;0)  2.98150E+02 
 +17647.4448;   6.00000E+03   N REF0 !
   PARAMETER G(LA2O3_X,Y+3,ZR+4:O-2:*;0)  2.98150E+02  180000;
   6.00000E+03  N REF0 !


 PHASE LAYP  %  3 1   1   3 !
    CONSTITUENT LAYP  :LA+3,Y+3 : LA+3,Y+3 : O-2 :  !

   PARAMETER G(LAYP,LA+3:LA+3:O-2;0)  2.98150E+02  +GLA2O3B#
  +3.0211333E+04;   6.00000E+03   N REF0 !
   PARAMETER G(LAYP,Y+3:LA+3:O-2;0)  2.98150E+02  +GLAYP#
  +4.0E+04;   6.00000E+03   N REF0 !
   PARAMETER G(LAYP,LA+3:Y+3:O-2;0)  2.98150E+02  +GLAYP#;   
   6.00000E+03   N REF0 !
   PARAMETER G(LAYP,Y+3:Y+3:O-2;0)  2.98150E+02  +11087
  -3.967*T+GY2O3R#+2.00E+04;   6.00000E+03   N REF0 !
   PARAMETER G(LAYP,LA+3:LA+3,Y+3:O-2;0)  2.98150E+02  
 +5.9991149E+03;  6.00000E+03   N REF0 !
   PARAMETER G(LAYP,Y+3:LA+3,Y+3:O-2;0)  2.98150E+02  
 +5.9991149E+03;  6.00000E+03   N REF0 !
   PARAMETER G(LAYP,LA+3,Y+3:*:O-2;0)  2.98150E+02  
  2.6810660E+04;   6.00000E+03   N REF0 !

 PHASE LAAP_ALO3LA  %  3 1   1   3 !
    CONSTITUENT LAAP_ALO3LA  :AL+3 : LA+3,Y+3 : O-2 :  !


 PARAMETER G(LAAP_ALO3LA,AL+3:LA+3:O-2;0)  298.15  +GLAAP#;
 6.00000E+03   N REF0 !
 PARAMETER G(LAAP_ALO3LA,AL+3:Y+3:O-2;0)  2.98150E+02  
  -2000+.5*GCORUND#+.5*GY2O3R#;   6.00000E+03   N REF0 !


   PHASE M2O3B:I %  3 2   3   1 !
  CONSTITUENT M2O3B:I :LA+3,Y+3,ZR+4 : O-2 : O-2,VA :  !

   PARAMETER G(M2O3B,LA+3:O-2:O-2;0)  2.98150E+02  
   +GLA2O3B#+GHSEROO#;    6.00000E+03   N REF0 !
   PARAMETER G(M2O3B,Y+3:O-2:O-2;0)  2.98150E+02  
   +11087-3.967*T+GY2O3R# +GHSEROO#; 6.00000E+03   N REF0 !
   PARAMETER G(M2O3B,ZR+4:O-2:O-2;0)  2.98150E+02 
   +2*GZRO2C#+5E4;   6.00000E+03   N REF0 !
   PARAMETER G(M2O3B,LA+3:O-2:VA;0)  2.98150E+02 +GLA2O3B#;
    6.00000E+03    N REF0 !
   PARAMETER G(M2O3B,Y+3:O-2:VA;0)  2.98150E+02  +11087
   -3.967*T+GY2O3R#;   6.00000E+03   N REF0 !
   PARAMETER G(M2O3B,ZR+4:O-2:VA;0)  2.98150E+02 +2*GZRO2C#
   -GHSEROO#+5E4;  6.00000E+03   N REF0 !
   PARAMETER G(M2O3B,LA+3,Y+3:O-2:*;0)  2.98150E+02 
  -56418.7854+36.2995704*T;  6.00000E+03   N REF0 !
   PARAMETER G(M2O3B,LA+3,Y+3:O-2:*;1)  2.98150E+02  
  -108889.852+49.7308132*T;  6.00000E+03   N REF0 !
   PARAMETER G(M2O3B,LA+3,ZR+4:O-2:*;0)  2.98150E+02  +2E4;   
   6.00000E+03    N REF0 !
   PARAMETER G(M2O3B,Y+3,ZR+4:O-2:*;0)  2.98150E+02  +2E4;   
   6.00000E+03    N REF0 !


 PHASE M2O3C:I %  3 2   3   1 !
    CONSTITUENT M2O3C:I :LA+3,Y+3,ZR+4 : O-2 : O-2,VA :  !

   PARAMETER G(M2O3C,LA+3:O-2:O-2;0)  2.98150E+02  
 +GLA2O3C#+GHSEROO#;   
  6.00000E+03   N REF0 !
 PARAMETER G(M2O3C,Y+3:O-2:O-2;0)  2.98150E+02  +GY2O3R#
 +GHSEROO#;   6.00000E+03   N REF0 !
   PARAMETER G(M2O3C,ZR+4:O-2:O-2;0)  2.98150E+02  +2*GZRO2C#;
   6.00000E+03   N REF0 !
   PARAMETER G(M2O3C,LA+3:O-2:VA;0)  2.98150E+02  +GLA2O3C#;
    6.00000E+03   N REF0 !
   PARAMETER G(M2O3C,Y+3:O-2:VA;0)  2.98150E+02  +GY2O3R#; 
  6.00000E+03   N  REF0 !
   PARAMETER G(M2O3C,ZR+4:O-2:VA;0)  2.98150E+02  +2*GZRO2C#
 -GHSEROO#;   6.00000E+03   N REF0 !
   PARAMETER G(M2O3C,Y+3,ZR+4:O-2:*;0)  2.98150E+02  -34451.2175
  +39.5035342*T;   6.00000E+03   N REF0 !
   PARAMETER G(M2O3C,LA+3,Y+3:O-2:*;0)  2.98150E+02  9976.47331;   
  6.00000E+03   N REF0 !
   PARAMETER G(M2O3C,LA+3,ZR+4:O-2:*;0)  2.98150E+02  45000;
   6.00000E+03    N REF0 !


 PHASE MONO:I %  2 2   4 !
    CONSTITUENT MONO:I :AL+3,LA+3,Y+3,ZR+4 : O-2,VA :  !

   PARAMETER G(MONO,LA+3:O-2;0)  2.98150E+02  +GLA2O3A#+GHSEROO#
 +100000+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(MONO,Y+3:O-2;0)  2.98150E+02  +GY2O3R#
 +53800+GHSEROO#+50.8*T
  +18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(MONO,ZR+4:O-2;0)  2.98150E+02  +2*GZRO2M#;
   6.00000E+03   N REF0 !
   PARAMETER G(MONO,LA+3:VA;0)  2.98150E+02  +GLA2O3A#
  -3*GHSEROO#+100000+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(MONO,Y+3:VA;0)  2.98150E+02  +GY2O3R#+53800
 -3*GHSEROO#+50.8*T+18.7022*T;   6.00000E+03   N REF0 !
   PARAMETER G(MONO,ZR+4:VA;0)  2.98150E+02  +2*GZRO2M#
 -4*GHSEROO#;   6.00000E+03   N REF0 !
 PARAMETER G(MONO,AL+3:O-2;0)  2.98150E+02  +GCORUND#+GHSEROO#
   +200000+18.702165*T;   6.00000E+03   N REF:0 !
 PARAMETER G(MONO,AL+3:VA;0)  2.98150E+02  +GCORUND#
   -3*GHSEROO#+200000+18.702165*T;   6.00000E+03   N REF:0 !
   

 PHASE PYROCHLORE:I %  5 2   2   6   1   1 !
    CONSTITUENT PYROCHLORE:I :LA+3,Y+3,ZR+4 : LA+3,Y+3,ZR+4 : 
 O-2,VA : O-2 :  O-2,VA :  !

   PARAMETER G(PYROCHLORE,LA+3:LA+3:O-2:O-2:O-2;0)  2.98150E+02  
  +2*GPYRLAZR#+2*GHSEROO#-GPYROZR#+GANCA#+GREC1#+GREC2#+GREC3#;   
  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:LA+3:O-2:O-2:O-2;0)  2.98150E+02
   +GPYRLAZR#
  +GPYRYZR#-GPYROZR#+2*GHSEROO#+GANCA#+GREC2#+GREC3#
 +GREC4#+GREC301#+GREC303#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:LA+3:O-2:O-2:O-2;0)  2.98150E+02
  +GPYRLAZR#
  +GHSEROO#+GANCA#+GREC2#+GREC3#+GREC4#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:Y+3:O-2:O-2:O-2;0)  2.98150E+02
  +GPYRLAZR#
  +GPYRYZR#-GPYROZR#+2*GHSEROO#+GANCA1#+GREC201#+GREC2#
  +GREC3#+GREC4#+GREC202#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:Y+3:O-2:O-2:O-2;0)  2.98150E+02  
 +2*GPYRYZR#+2*GHSEROO#-GPYROZR#+GANCA1#+GREC101#+GREC102#
 +GREC103#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:Y+3:O-2:O-2:O-2;0)  2.98150E+02 
 +GPYRYZR#
  +GHSEROO#+GANCA1#+GREC102#+GREC103#+GREC104#;  
 6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:ZR+4:O-2:O-2:O-2;0)  2.98150E+02
  +GPYRLAZR#
  +GHSEROO#+GREC2#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:ZR+4:O-2:O-2:O-2;0)  2.98150E+02
  +GPYRYZR#+GHSEROO#+GREC102#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:ZR+4:O-2:O-2:O-2;0)  2.98150E+02
  +GPYROZR#;  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:LA+3:VA:O-2:O-2;0)  2.98150E+02 
  +5*GPYROZR#
  -10*GPYRLAZR#+6*GPYROLA#-4*GHSEROO#+134.8548*T-5*GANCA#
 -5*GREC1#+GREC2#
  +GREC3#+GREC5#+GREC8#+GREC9#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:LA+3:VA:O-2:O-2;0)  2.98150E+02 
 +GPYRYZR#
  -11*GPYRLAZR#+6*GPYROLA#-4*GHSEROO#-5*GANCA#-6*GREC1#
  +GREC2#+GREC3#+GREC4#
  +GREC5#+GREC8#+GREC10#+GREC11#-GREC301#+GREC309#;   
  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:LA+3:VA:O-2:O-2;0)  2.98150E+02  
  +6*GPYROZR#
  -11*GPYRLAZR#+6*GPYROLA#-5*GHSEROO#+134.8548*T-5*GANCA#
 -6*GREC1#+GREC2#
  +GREC3#+GREC4#+GREC5#+GREC8#+GREC10#+GREC11#;  
  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:Y+3:VA:O-2:O-2;0)  2.98150E+02 
  +5*GPYROZR#
  -11*GPYRLAZR#+6*GPYROLA#-4*GHSEROO#+134.8548*T-6*GANCA#
 -6*GREC1#+GREC2#
  +GREC3#+GREC4#+GREC5#+GREC8#+GREC10#+GREC11#+GANCA1#
 +GREC202#+GREC209#;   
  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:Y+3:VA:O-2:O-2;0)  2.98150E+02  
 +6*GPYRYY#
  -10*GPYRYZR#+5*GPYROZR#-5*GANCA1#-4*GHSEROO#+134.8548*T
 -5*GREC101#
  +GREC102#+GREC103#+GREC105#+GREC108#+GREC109#;  
  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:Y+3:VA:O-2:O-2;0)  2.98150E+02  
 +6*GPYRYY#
  -11*GPYRYZR#+6*GPYROZR#-5*GANCA1#-5*GHSEROO#+134.8548*T
 -6*GREC101#
  +GREC102#+GREC103#+GREC104#+GREC107#+GREC111#;  
  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:ZR+4:VA:O-2:O-2;0)  2.98150E+02 
  +6*GPYROZR#
  -11*GPYRLAZR#+6*GPYROLA#-5*GHSEROO#+134.8548*T-6*GANCA#
 -6*GREC1#+GREC2#+GREC5#+GREC8#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:ZR+4:VA:O-2:O-2;0)  2.98150E+02 
   +6*GPYRYY#
  -11*GPYRYZR#+6*GPYROZR#-6*GANCA1#-5*GHSEROO#+134.8548*T
  -6*GREC101#
  +GREC102#+GREC105#+GREC108#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:ZR+4:VA:O-2:O-2;0)  2.98150E+02 
   +GPYROZR#-6*GHSEROO#+600000;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:LA+3:O-2:O-2:VA;0)  2.98150E+02 
  +2*GPYRLAZR#
  -GPYROZR#+GHSEROO#+GANCA#+GREC1#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:LA+3:O-2:O-2:VA;0)  2.98150E+02 
  +GPYRLAZR#
  +GPYRYZR#-GPYROZR#+GHSEROO#+GANCA#+GREC301#;   
 6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:LA+3:O-2:O-2:VA;0)  2.98150E+02 
 +GPYRLAZR# +GANCA#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:Y+3:O-2:O-2:VA;0)  2.98150E+02
  +GPYRLAZR#
  +GPYRYZR#-GPYROZR#+GHSEROO#+GANCA1#+GREC201#; 
   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:Y+3:O-2:O-2:VA;0)  2.98150E+02 
  +2*GPYRYZR#
  -GPYROZR#+GANCA1#+GHSEROO#+GREC101#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:Y+3:O-2:O-2:VA;0)  2.98150E+02
   +GPYRYZR#+GANCA1#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:ZR+4:O-2:O-2:VA;0)  2.98150E+02
   +GPYRLAZR#;  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:ZR+4:O-2:O-2:VA;0)  2.98150E+02
   +GPYRYZR#;    6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:ZR+4:O-2:O-2:VA;0)  2.98150E+02
   +GPYROZR#-GHSEROO#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:LA+3:VA:O-2:VA;0)  2.98150E+02 
  +6*GPYROLA#-10*GPYRLAZR#+5*GPYROZR#-5*GHSEROO#-5*GANCA#
  +134.8548*T-5*GREC1#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:LA+3:VA:O-2:VA;0)  2.98150E+02  
  +6*GPYRLAY#
  +6*GANCA2#-5*GPYRLAZR#-5*GPYRYZR#+5*GPYROZR#-5*GHSEROO#
 -5*GANCA#
  -5*GREC301#+134.8548*T;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:LA+3:VA:O-2:VA;0)  2.98150E+02  
 +6*GPYROLA#
  -11*GPYRLAZR#+6*GPYROZR#-6*GHSEROO#-5*GANCA#+134.8548*T
 -6*GREC1#+GREC7#;   
  6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:Y+3:VA:O-2:VA;0)  2.98150E+02  
 +6*GPYRLAY#
  -5*GPYRLAZR#-5*GPYRYZR#+5*GPYROZR#-5*GHSEROO#-5*GANCA1#
 -5*GREC201#
  +134.8548*T;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:Y+3:VA:O-2:VA;0)  2.98150E+02 
  +6*GPYRYY#
  -10*GPYRYZR#+5*GPYROZR#-5*GANCA1#-5*GHSEROO#+134.8548*T
 -5*GREC101#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:Y+3:VA:O-2:VA;0)  2.98150E+02 
  +6*GPYRYY#
  -11*GPYRYZR#+6*GPYROZR#-5*GANCA1#-6*GHSEROO#+134.8548*T
 -6*GREC101#+GREC107#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,LA+3:ZR+4:VA:O-2:VA;0)  2.98150E+02  
 +6*GPYROLA#
  -11*GPYRLAZR#+6*GPYROZR#-6*GHSEROO#-6*GANCA#+134.8548*T
 -6*GREC1#+GREC5#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,Y+3:ZR+4:VA:O-2:VA;0)  2.98150E+02  
 +6*GPYRYY#
  -11*GPYRYZR#+6*GPYROZR#-6*GANCA1#-6*GHSEROO#+134.8548*T
 -6*GREC101#+GREC105#;   6.00000E+03   N REF0 !
   PARAMETER G(PYROCHLORE,ZR+4:ZR+4:VA:O-2:VA;0)  2.98150E+02  
 +GPYROZR#-7*GHSEROO#+700000;   6.00000E+03   N REF0 !


 PHASE TETR:I %  2 2   4 !
    CONSTITUENT TETR:I :AL+3,LA+3,Y+3,ZR+4 : O-2,VA :  !

   PARAMETER G(TETR,LA+3:O-2;0)  2.98150E+02  +GLA2O3T#+GHSEROO#
 +18.702165*T;  6.00000E+03   N REF0 !
   PARAMETER G(TETR,Y+3:O-2;0)  2.98150E+02  +GY2O3R#+20000
+GHSEROO#+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(TETR,ZR+4:O-2;0)  2.98150E+02  +2*GZRO2T#; 
  6.00000E+03   N  REF0 !
   PARAMETER G(TETR,LA+3:VA;0)  2.98150E+02  +GLA2O3T#
 -3*GHSEROO#+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(TETR,Y+3:VA;0)  2.98150E+02  +GY2O3R#+20000
 -3*GHSEROO#+18.702165*T;   6.00000E+03   N REF0 !
   PARAMETER G(TETR,ZR+4:VA;0)  2.98150E+02  +2*GZRO2T#
 -4*GHSEROO#;    6.00000E+03   N REF0 !
 PARAMETER G(TETR,AL+3:O-2;0)  2.98150E+02  +GCORUND#+GHSEROO#
  +18.702165*T+100000;   6.00000E+03   N REF:0 !
 PARAMETER G(TETR,AL+3:VA;0)  2.98150E+02  +GCORUND#-3*GHSEROO#
  +18.702165*T+100000;   6.00000E+03   N REF:0 !

   PARAMETER G(TETR,LA+3,ZR+4:*;0)  2.98150E+02  
 20000;   6.00000E+03   N REF0 !
   PARAMETER G(TETR,Y+3,ZR+4:*;0)  2.98150E+02  -126467.417+60*T;   
  6.00000E+03   N REF0 !


 PHASE ZR3Y4O12  %  3 3   4   12 !
    CONSTITUENT ZR3Y4O12  :ZR+4 : Y+3 : O-2 :  !

   PARAMETER G(ZR3Y4O12,ZR+4:Y+3:O-2;0)  2.98150E+02  +7*GZYO#;   
  6.00000E+03   N REF0 !

 PHASE YAG_AL5O12Y3  %  3 5   3   12 !
    CONSTITUENT YAG_AL5O12Y3  :AL+3 : LA+3,Y+3 : O-2 :  !

   PARAMETER G(YAG_AL5O12Y3,AL+3:Y+3:O-2;0)  2.98150E+02  +GYAG#
 -1684.32744;    6.00000E+03   N REF:0 !
 PARAMETER G(YAG_AL5O12Y3,AL+3:LA+3:O-2;0)  2.98150E+02
  +2.5*GCORUND+1.5*GLA2O3A-7E4;  6.00000E+03   N REF0 !

 PHASE YAM_AL2O9Y4  %  3 2   4   9 !
    CONSTITUENT YAM_AL2O9Y4  :AL+3 : LA+3,Y+3 : O-2 :  !

   PARAMETER G(YAM_AL2O9Y4,AL+3:Y+3:O-2;0)  2.98150E+02  +GYAM#
 -9035.18728+2.18809722*T;   6.00000E+03   N REF:0 !
 PARAMETER G(YAM_AL2O9Y4,AL+3:LA+3:O-2;0)  2.98150E+02 
 +2*GLA2O3A#+GCORUND#-63460+20*T;   6.00000E+03   N REF0 !

 PHASE YAP_ALO3Y  %  3 1   1   3 !
    CONSTITUENT YAP_ALO3Y  :AL+3 : LA+3,Y+3 : O-2 :  !

   PARAMETER G(YAP_ALO3Y,AL+3:Y+3:O-2;0)  2.98150E+02  -24515
  -6.8586*T+.5*GCORUND#+.5*GY2O3R#;   6.00000E+03   N REF:0 !
 PARAMETER G(YAP_ALO3Y,AL+3:LA+3:O-2;0)  2.98150E+02 
 +0.5*GLA2O3A#+0.5*GCORUND#-20000; 6.00000E+03   N REF0 !



 LIST_OF_REFERENCES
 NUMBER  SOURCE
  ! 
"""
