"""A few useful physical constants

Note that energy is expressed in units of eV.
"""
from math import pi

c = 299792458  #: [m/s] speed of light
e = 1.602 * 10**-19  #: [C] electron charge
epsilon0 = 8.854 * 10**-12  #: [F/m] vacuum permittivity
hbar = 6.58211899 * 10**-16  #: [eV*s] reduced Plank constant
phi0 = 2 * pi * hbar  #: [V*s] magnetic quantum
