#
# Linear kinetics
#

from .base_kinetics import BaseKinetics


class Linear(BaseKinetics):
    """
    Submodel which implements linear kinetics. Valid for small overpotentials/currents.

    Parameters
    ----------
    param : parameter class
        model parameters
    domain : str
        The domain to implement the model, either: 'Negative' or 'Positive'.
    reaction : str
        The name of the reaction being implemented
    options: dict
        A dictionary of options to be passed to the model.
        See :class:`pybamm.BaseBatteryModel`

    **Extends:** :class:`pybamm.interface.kinetics.BaseKinetics`
    """

    def __init__(self, param, domain, reaction, options):
        super().__init__(param, domain, reaction, options)

    def _get_kinetics(self, j0, ne, eta_r, T, u):
        prefactor = ne / (2 * (1 + self.param.Theta * T))
        return 2 * u * j0 * prefactor * eta_r
