# -*- coding: utf-8 -*-
from __future__ import absolute_import
from __future__ import unicode_literals


__all__ = [
    'Error', 'Warning', 'InterfaceError', 'DatabaseError', 'InternalError',
    'OperationalError', 'ProgrammingError', 'DataError', 'NotSupportedError',
]


class Error(Exception):
    pass


class Warning(Exception):
    pass


class InterfaceError(Error):
    pass


class DatabaseError(Error):
    pass


class InternalError(DatabaseError):
    pass


class OperationalError(DatabaseError):
    pass


class ProgrammingError(DatabaseError):
    pass


class IntegrityError(DatabaseError):
    pass


class DataError(DatabaseError):
    pass


class NotSupportedError(DatabaseError):
    pass
