# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""pyAgrum is a scientific C++ and Python library dedicated to Bayesian Networks and other Probabilistic Graphical Models.  It provides a high-level interface to the part of the C++ aGrUM library allowing to create, model, learn, use, calculate with and embed Bayesian Networks. Some specific (python and C++) codes are added in order to simplify and extend the aGrUM API. The module is mainly generated by the SWIG interface generator."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _pyAgrum
else:
    import _pyAgrum

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class SwigPyIterator(object):
    r"""Proxy of C++ swig::SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        r"""value(self) -> PyObject *"""
        return _pyAgrum.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        r"""incr(self, n=1) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        r"""decr(self, n=1) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        r"""distance(self, x) -> ptrdiff_t"""
        return _pyAgrum.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        r"""equal(self, x) -> bool"""
        return _pyAgrum.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        r"""copy(self) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        r"""next(self) -> PyObject *"""
        return _pyAgrum.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        r"""__next__(self) -> PyObject *"""
        return _pyAgrum.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        r"""previous(self) -> PyObject *"""
        return _pyAgrum.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        r"""advance(self, n) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        r"""__eq__(self, x) -> bool"""
        return _pyAgrum.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        r"""__ne__(self, x) -> bool"""
        return _pyAgrum.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        r"""__iadd__(self, n) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        r"""__isub__(self, n) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        r"""__add__(self, n) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        r"""
        __sub__(self, n) -> SwigPyIterator
        __sub__(self, x) -> ptrdiff_t
        """
        return _pyAgrum.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _pyAgrum:
_pyAgrum.SwigPyIterator_swigregister(SwigPyIterator)


import numpy
from numbers import Number

class JunctionTreeGenerator(object):
    r"""

    JunctionTreeGenerator is use to generate junction tree or binary junction tree from Bayesian networks.

    JunctionTreeGenerator() -> JunctionTreeGenerator
        default constructor

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def junctionTree(self, *args) -> "gum::JunctionTree":
        r"""
        junctionTree(self, g, partial_order=None) -> CliqueGraph
        junctionTree(self, dag, partial_order=None) -> CliqueGraph
        junctionTree(self, bn, partial_order=None) -> CliqueGraph
        junctionTree(self, mn, partial_order=None) -> CliqueGraph

        Computes the junction tree for its parameters. If the first parameter is a graph, the heurisitcs assume that all the node have the same domain size (2). If given, the heuristic takes into account the partial order for its elimination order.

        Parameters
        ----------
        g : pyAgrum.UndiGraph
        	a undirected graph

        dag : pyAgrum.DAG
        	a dag

        bn : pyAgrum.BayesNet
        	a BayesianNetwork

        partial_order: List[List[int]]
        	a partial order among the nodeIDs

        Returns
        -------
        pyAgrum.CliqueGraph
        	the current junction tree. 

        """
        return _pyAgrum.JunctionTreeGenerator_junctionTree(self, *args)

    def eliminationOrder(self, *args) -> "PyObject *":
        r"""
        eliminationOrder(self, g, partial_order=None) -> PyObject
        eliminationOrder(self, dag, partial_order=None) -> PyObject
        eliminationOrder(self, bn, partial_order=None) -> PyObject

        Computes the elimination for its parameters. If the first parameter is a graph, the heurisitcs assume that all the node have the same domain size (2). If given, the heuristic takes into account the partial order for its elimination order.

        Parameters
        ----------
        g : pyAgrum.UndiGraph
        	a undirected graph

        dag : pyAgrum.DAG
        	a dag

        bn : pyAgrum.BayesNet
        	a BayesianNetwork

        partial_order: List[List[int]]
        	a partial order among the nodeIDs

        Returns
        -------
        pyAgrum.CliqueGraph
        	the current elimination order.

        """
        return _pyAgrum.JunctionTreeGenerator_eliminationOrder(self, *args)

    def binaryJoinTree(self, *args) -> "gum::JunctionTree":
        r"""
        binaryJoinTree(self, g, partial_order=None) -> CliqueGraph
        binaryJoinTree(self, dag, partial_order=None) -> CliqueGraph
        binaryJoinTree(self, bn, partial_order=None) -> CliqueGraph

        Computes the binary joint tree for its parameters. If the first parameter is a graph, the heurisitcs assume that all the node have the same domain size (2). If given, the heuristic takes into account the partial order for its elimination order.

        Parameters
        ----------
        g : pyAgrum.UndiGraph
        	a undirected graph

        dag : pyAgrum.DAG
        	a dag

        bn : pyAgrum.BayesNet
        	a BayesianNetwork

        partial_order: List[List[int]]
        	a partial order among the nodeIDs

        Returns
        -------
        pyAgrum.CliqueGraph
        	the current binary joint tree 

        """
        return _pyAgrum.JunctionTreeGenerator_binaryJoinTree(self, *args)

    def __init__(self):
        r"""
        __init__(self) -> JunctionTreeGenerator

        JunctionTreeGenerator is use to generate junction tree or binary junction tree from Bayesian networks.

        JunctionTreeGenerator() -> JunctionTreeGenerator
            default constructor

        """
        _pyAgrum.JunctionTreeGenerator_swiginit(self, _pyAgrum.new_JunctionTreeGenerator())
    __swig_destroy__ = _pyAgrum.delete_JunctionTreeGenerator

# Register JunctionTreeGenerator in _pyAgrum:
_pyAgrum.JunctionTreeGenerator_swigregister(JunctionTreeGenerator)

class PythonBNListener(object):
    r"""Proxy of C++ PythonBNListener class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "BayesNet", vnm: "VariableNodeMap"):
        r"""__init__(self, bn, vnm) -> PythonBNListener"""
        _pyAgrum.PythonBNListener_swiginit(self, _pyAgrum.new_PythonBNListener(bn, vnm))
    __swig_destroy__ = _pyAgrum.delete_PythonBNListener

    def whenNodeAdded(self, source: "void const *", id: "gum::NodeId") -> "void":
        r"""whenNodeAdded(self, source, id)"""
        return _pyAgrum.PythonBNListener_whenNodeAdded(self, source, id)

    def whenNodeDeleted(self, arg2: "void const *", id: "gum::NodeId") -> "void":
        r"""whenNodeDeleted(self, arg2, id)"""
        return _pyAgrum.PythonBNListener_whenNodeDeleted(self, arg2, id)

    def whenArcAdded(self, arg2: "void const *", src: "gum::NodeId", dst: "gum::NodeId") -> "void":
        r"""whenArcAdded(self, arg2, src, dst)"""
        return _pyAgrum.PythonBNListener_whenArcAdded(self, arg2, src, dst)

    def whenArcDeleted(self, arg2: "void const *", src: "gum::NodeId", dst: "gum::NodeId") -> "void":
        r"""whenArcDeleted(self, arg2, src, dst)"""
        return _pyAgrum.PythonBNListener_whenArcDeleted(self, arg2, src, dst)

    def setWhenArcAdded(self, pyfunc: "PyObject *") -> "void":
        r"""
        setWhenArcAdded(self, pyfunc)



        """
        return _pyAgrum.PythonBNListener_setWhenArcAdded(self, pyfunc)

    def setWhenArcDeleted(self, pyfunc: "PyObject *") -> "void":
        r"""
        setWhenArcDeleted(self, pyfunc)



        """
        return _pyAgrum.PythonBNListener_setWhenArcDeleted(self, pyfunc)

    def setWhenNodeAdded(self, pyfunc: "PyObject *") -> "void":
        r"""
        setWhenNodeAdded(self, pyfunc)



        """
        return _pyAgrum.PythonBNListener_setWhenNodeAdded(self, pyfunc)

    def setWhenNodeDeleted(self, pyfunc: "PyObject *") -> "void":
        r"""
        setWhenNodeDeleted(self, pyfunc)



        """
        return _pyAgrum.PythonBNListener_setWhenNodeDeleted(self, pyfunc)

# Register PythonBNListener in _pyAgrum:
_pyAgrum.PythonBNListener_swigregister(PythonBNListener)

class PythonLoadListener(object):
    r"""Proxy of C++ PythonLoadListener class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def whenLoading(self, buffer: "void const *", percent: "int") -> "void":
        r"""whenLoading(self, buffer, percent)"""
        return _pyAgrum.PythonLoadListener_whenLoading(self, buffer, percent)

    def setPythonListener(self, l: "PyObject *") -> "bool":
        r"""
        setPythonListener(self, l) -> bool



        """
        return _pyAgrum.PythonLoadListener_setPythonListener(self, l)

    def __init__(self):
        r"""__init__(self) -> PythonLoadListener"""
        _pyAgrum.PythonLoadListener_swiginit(self, _pyAgrum.new_PythonLoadListener())
    __swig_destroy__ = _pyAgrum.delete_PythonLoadListener

# Register PythonLoadListener in _pyAgrum:
_pyAgrum.PythonLoadListener_swigregister(PythonLoadListener)


def _fillLoadListeners_(py_listener: "std::vector< PythonLoadListener,std::allocator< PythonLoadListener > > &", l: "PyObject *") -> "int":
    r"""_fillLoadListeners_(py_listener, l) -> int"""
    return _pyAgrum._fillLoadListeners_(py_listener, l)
class PythonApproximationListener(object):
    r"""

    Parameters
    ----------
    algo : IApproximationSchemeConfiguration
    	an approxmation scheme

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, algo: "IApproximationSchemeConfiguration"):
        r"""
        __init__(self, algo) -> PythonApproximationListener

        Parameters
        ----------
        algo : IApproximationSchemeConfiguration
        	an approxmation scheme

        """
        _pyAgrum.PythonApproximationListener_swiginit(self, _pyAgrum.new_PythonApproximationListener(algo))
    __swig_destroy__ = _pyAgrum.delete_PythonApproximationListener

    def whenProgress(self, src: "void const *", step: "gum::Size const", error: "double const", duration: "double const") -> "void":
        r"""whenProgress(self, src, step, error, duration)"""
        return _pyAgrum.PythonApproximationListener_whenProgress(self, src, step, error, duration)

    def whenStop(self, src: "void const *", message: "std::string const") -> "void":
        r"""whenStop(self, src, message)"""
        return _pyAgrum.PythonApproximationListener_whenStop(self, src, message)

    def setWhenProgress(self, pyfunc: "PyObject *") -> "void":
        r"""
        setWhenProgress(self, pyfunc)

        Parameters
        ----------
        pyfunc
        	the function to execute

        """
        return _pyAgrum.PythonApproximationListener_setWhenProgress(self, pyfunc)

    def setWhenStop(self, pyfunc: "PyObject *") -> "void":
        r"""
        setWhenStop(self, pyfunc)

        Parameters
        ----------
        pyfunc
        	the function to execute

        """
        return _pyAgrum.PythonApproximationListener_setWhenStop(self, pyfunc)

# Register PythonApproximationListener in _pyAgrum:
_pyAgrum.PythonApproximationListener_swigregister(PythonApproximationListener)

class PythonDatabaseGeneratorListener(object):
    r"""Proxy of C++ PythonDatabaseGeneratorListener class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, notif: "BNDatabaseGenerator"):
        r"""__init__(self, notif) -> PythonDatabaseGeneratorListener"""
        _pyAgrum.PythonDatabaseGeneratorListener_swiginit(self, _pyAgrum.new_PythonDatabaseGeneratorListener(notif))
    __swig_destroy__ = _pyAgrum.delete_PythonDatabaseGeneratorListener

    def whenProgress(self, src: "void const *", step: "gum::Size const", duration: "double const") -> "void":
        r"""whenProgress(self, src, step, duration)"""
        return _pyAgrum.PythonDatabaseGeneratorListener_whenProgress(self, src, step, duration)

    def whenStop(self, src: "void const *", message: "std::string const &") -> "void":
        r"""whenStop(self, src, message)"""
        return _pyAgrum.PythonDatabaseGeneratorListener_whenStop(self, src, message)

    def setWhenProgress(self, pyfunc: "PyObject *") -> "void":
        r"""setWhenProgress(self, pyfunc)"""
        return _pyAgrum.PythonDatabaseGeneratorListener_setWhenProgress(self, pyfunc)

    def setWhenStop(self, pyfunc: "PyObject *") -> "void":
        r"""setWhenStop(self, pyfunc)"""
        return _pyAgrum.PythonDatabaseGeneratorListener_setWhenStop(self, pyfunc)

# Register PythonDatabaseGeneratorListener in _pyAgrum:
_pyAgrum.PythonDatabaseGeneratorListener_swigregister(PythonDatabaseGeneratorListener)

class BNGenerator(object):
    r"""

    BNGenerator is used to easily generate Bayesian networks.

    BNGenerator() -> BNGenerator
        default constructor

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def generate(self, n_nodes: "gum::Size"=10, n_arcs: "gum::Size"=15, n_modmax: "gum::Size"=4) -> "gum::BayesNet< double >":
        r"""
        generate(self, n_nodes=10, n_arcs=15, n_modmax=4) -> BayesNet

        Generate a new Bayesian network 

        Parameters
        ----------
        n_nodes : int
        	the number of nodes (default=10)
        n_arcs : int
        	the number of arcs (default=15)
        n_nodmax : int
        	the max number of modalities for a node (default=4)

        Returns
        -------
        pyAgrum.BayesNet
        	the generated Bayesian network

        Raises
        ------
        gum.OperationNotAllowed
        	If n_modmax < 2
        gum.OperationNotAllowed
        	If n_arcs is incompatible with n_nodes (not enough arcs)

        """
        return _pyAgrum.BNGenerator_generate(self, n_nodes, n_arcs, n_modmax)

    def __init__(self):
        r"""
        __init__(self) -> BNGenerator

        BNGenerator is used to easily generate Bayesian networks.

        BNGenerator() -> BNGenerator
            default constructor

        """
        _pyAgrum.BNGenerator_swiginit(self, _pyAgrum.new_BNGenerator())
    __swig_destroy__ = _pyAgrum.delete_BNGenerator

# Register BNGenerator in _pyAgrum:
_pyAgrum.BNGenerator_swigregister(BNGenerator)

class IDGenerator(object):
    r"""

    IDGenerator is used to easily generate influence diagrams.

    IDGenerator() -> IDGenerator
        default constructor

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def generate(self, nbrNodes: "gum::Size"=10, arcDensity: "double"=0.2, chanceNodeDensity: "double"=0.8, utilityNodeDensity: "double"=0.1, max_modality: "int"=2) -> "gum::InfluenceDiagram< double >":
        r"""
        generate(self, nbrNodes=10, arcDensity=0.2, chanceNodeDensity=0.8, utilityNodeDensity=0.1, max_modality=2) -> InfluenceDiagram

        Generate a new influence diagram given the parameters.

        Parameters
        ----------
        nbrNodes : int
        	the number of node
        arcDensity : double
        	the density of arc (1 for a complete graph)
        chanceNodeDensity : double
        	the density of chance node
        utilityNodeDensity : double
        	the density of utility node
        max_modality : int
        	the maximum value for modalities

        Returns
        -------
        pyAgrum.InfluenceDiagram
        	the generated influence diagram

        """
        return _pyAgrum.IDGenerator_generate(self, nbrNodes, arcDensity, chanceNodeDensity, utilityNodeDensity, max_modality)

    def __init__(self):
        r"""
        __init__(self) -> IDGenerator

        IDGenerator is used to easily generate influence diagrams.

        IDGenerator() -> IDGenerator
            default constructor

        """
        _pyAgrum.IDGenerator_swiginit(self, _pyAgrum.new_IDGenerator())
    __swig_destroy__ = _pyAgrum.delete_IDGenerator

# Register IDGenerator in _pyAgrum:
_pyAgrum.IDGenerator_swigregister(IDGenerator)

class PRMexplorer(object):
    r"""

    PRMexplorer helps navigate through probabilistic relational models.

    PRMexplorer() -> PRMexplorer
        default constructor

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> PRMexplorer

        PRMexplorer helps navigate through probabilistic relational models.

        PRMexplorer() -> PRMexplorer
            default constructor

        """
        _pyAgrum.PRMexplorer_swiginit(self, _pyAgrum.new_PRMexplorer())
    __swig_destroy__ = _pyAgrum.delete_PRMexplorer

    def load(self, *args) -> "void":
        r"""
        load(self, filename, classpath="", verbose=False)

        Load a PRM into the explorer.

        Parameters
        ----------
        filename : str
        	the name of the o3prm file
        classpath : str
        	the classpath of the PRM

        Raises
        ------
        gum.FatalError
        	If file not found

        """
        return _pyAgrum.PRMexplorer_load(self, *args)

    def isType(self, name: "std::string") -> "PyObject *":
        r"""
        isType(self, name) -> PyObject *

        Parameters
        ----------
        name : str
        	an element name

        Returns
        -------
        bool
        	True if the parameter correspond to a type in the PRM

        """
        return _pyAgrum.PRMexplorer_isType(self, name)

    def isClass(self, name: "std::string") -> "PyObject *":
        r"""
        isClass(self, name) -> PyObject *

        Parameters
        ----------
        name : str
        	an element name

        Returns
        -------
        bool
        	True if the parameter correspond to a class in the PRM

        """
        return _pyAgrum.PRMexplorer_isClass(self, name)

    def isInterface(self, name: "std::string") -> "PyObject *":
        r"""
        isInterface(self, name) -> PyObject *

        Parameters
        ----------
        name : str
        	an element name

        Returns
        -------
        bool
        	True if the parameter correspond to an interface in the PRM

        """
        return _pyAgrum.PRMexplorer_isInterface(self, name)

    def classes(self) -> "PyObject *":
        r"""
        classes(self) -> PyObject *

        Returns
        -------
        list
        	the list of classes

        """
        return _pyAgrum.PRMexplorer_classes(self)

    def classAttributes(self, class_name: "std::string") -> "PyObject *":
        r"""
        classAttributes(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of attributes

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classAttributes(self, class_name)

    def isAttribute(self, class_name: "std::string", att_name: "std::string") -> "PyObject *":
        r"""
        isAttribute(self, class_name, att_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name
        att_name : str
        	the name of the attribute to be tested

        Returns
        -------
        bool
        	True if att_name is an attribute of class_name

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM
        gum.IndexError
        	If att_name is not an element of class_name

        """
        return _pyAgrum.PRMexplorer_isAttribute(self, class_name, att_name)

    def classReferences(self, class_name: "std::string") -> "PyObject *":
        r"""
        classReferences(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of references

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classReferences(self, class_name)

    def classParameters(self, class_name: "std::string") -> "PyObject *":
        r"""
        classParameters(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of parameters

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classParameters(self, class_name)

    def classImplements(self, class_name: "std::string") -> "PyObject *":
        r"""
        classImplements(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of interfaces implemented by the class

        """
        return _pyAgrum.PRMexplorer_classImplements(self, class_name)
    aggType = property(_pyAgrum.PRMexplorer_aggType_get, _pyAgrum.PRMexplorer_aggType_set, doc=r"""
    aggType

    min/max/count/exists/forall/or/and/amplitude/median

    """)

    def classAggregates(self, class_name: "std::string") -> "PyObject *":
        r"""
        classAggregates(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of aggregates in the class

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classAggregates(self, class_name)

    def classSlotChains(self, class_name: "std::string") -> "PyObject *":
        r"""
        classSlotChains(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of class slot chains

        Raises
        ------
        gum.IndexError 
        	if the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classSlotChains(self, class_name)

    def classDag(self, class_name: "std::string") -> "PyObject *":
        r"""
        classDag(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        tuple
        	a description of the DAG

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classDag(self, class_name)

    def getalltheSystems(self) -> "PyObject *":
        r"""
        getalltheSystems(self) -> PyObject *

        Returns
        -------
        list
        	the list of all the systems and their components

        """
        return _pyAgrum.PRMexplorer_getalltheSystems(self)

    def getSuperClass(self, class_name: "std::string") -> "PyObject *":
        r"""
        getSuperClass(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        str
        	the class extended by class_name

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getSuperClass(self, class_name)

    def getDirectSubClass(self, class_name: "std::string") -> "PyObject *":
        r"""
        getDirectSubClass(self, class_name) -> PyObject *

        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of direct subclasses

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getDirectSubClass(self, class_name)

    def cpf(self, class_name: "std::string", attribute: "std::string") -> "gum::Potential< double > const &":
        r"""
        cpf(self, class_name, attribute) -> Potential

        Parameters
        ----------
        class_name : str
        	a class name

        attribute : str
        	an attribute

        Returns
        -------
        pyAgrum.Potential
        	the potential of the attribute

        Raises
        ------
        gum.OperationNotAllowed
        	If the class element doesn't have any gum::Potential (like a gum::PRMReferenceSlot). 
        gum.IndexError
        	If the class is not in the PRM
        gum.IndexError
        	If the attribute in parameters does not exist 

        """
        return _pyAgrum.PRMexplorer_cpf(self, class_name, attribute)

    def types(self) -> "PyObject *":
        r"""
        types(self) -> PyObject *

        Returns
        -------
        list
        	the list of the custom types in the PRM 

        """
        return _pyAgrum.PRMexplorer_types(self)

    def getSuperType(self, type_name: "std::string") -> "PyObject *":
        r"""
        getSuperType(self, type_name) -> PyObject *

        Parameters
        ----------
        type_name : str
        	a type name

        Returns
        -------
        str
        	the type extended by type_name

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getSuperType(self, type_name)

    def getDirectSubTypes(self, type_name: "std::string") -> "PyObject *":
        r"""
        getDirectSubTypes(self, type_name) -> PyObject *

        Parameters
        ----------
        type_name : str
        	a type name

        Returns
        -------
        list
        	the list of direct subtypes

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getDirectSubTypes(self, type_name)

    def getLabels(self, type_name: "std::string") -> "PyObject *":
        r"""
        getLabels(self, type_name) -> PyObject *

        Parameters
        ----------
        type_name : str
        	a type name

        Returns
        -------
        list
        	the list of type labels

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getLabels(self, type_name)

    def getLabelMap(self, type_name: "std::string") -> "PyObject *":
        r"""
        getLabelMap(self, type_name) -> PyObject *

        Parameters
        ----------
        type_name : str
        	a type name

        Returns
        -------
        dict
        	a dict containing pairs of label and their values 

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getLabelMap(self, type_name)

    def interfaces(self) -> "PyObject *":
        r"""
        interfaces(self) -> PyObject *

        Returns
        -------
        list
        	the list of interfaces in the PRM 

        """
        return _pyAgrum.PRMexplorer_interfaces(self)

    def interAttributes(self, interface_name: "std::string", allAttributes: "bool"=False) -> "PyObject *":
        r"""
        interAttributes(self, interface_name, allAttributes=False) -> PyObject

        Parameters
        ----------
        interface_name : str
        	an interface

        allAttributes : bool
        	True if supertypes of a custom type should be indicated

        Returns
        -------
        list
        	the list of (<type>,<attribute_name>) for the given interface

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_interAttributes(self, interface_name, allAttributes)

    def interReferences(self, interface_name: "std::string") -> "PyObject *":
        r"""
        interReferences(self, interface_name) -> PyObject *

        Parameters
        ----------
        interface_name : str
        	an interface

        Returns
        -------
        list
        	the list of (<reference_type>,<reference_name>,<True if the reference is an array>) for the given interface

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_interReferences(self, interface_name)

    def getSuperInterface(self, interface_name: "std::string") -> "PyObject *":
        r"""
        getSuperInterface(self, interface_name) -> PyObject *

        Parameters
        ----------
        interface_name : str
        	an interface name

        Returns
        -------
        str
        	the interace extended by interface_name

        Raises
        ------
        gum.IndexError
        	If the interface is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getSuperInterface(self, interface_name)

    def getDirectSubInterfaces(self, interface_name: "std::string") -> "PyObject *":
        r"""
        getDirectSubInterfaces(self, interface_name) -> PyObject *

        Parameters
        ----------
        interface_name : str
        	an interface name

        Returns
        -------
        list
        	the list of direct subinterfaces

        Raises
        ------
        gum.IndexError
        	If the interface is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getDirectSubInterfaces(self, interface_name)

    def getImplementations(self, interface_name: "std::string") -> "PyObject *":
        r"""
        getImplementations(self, interface_name) -> PyObject *

        Parameters
        ----------
        interface_name : str
        	an interface name

        Returns
        -------
        str
        	the list of classes implementing the interface 

        Raises
        ------
        gum.IndexError
        	If the interface is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getImplementations(self, interface_name)

# Register PRMexplorer in _pyAgrum:
_pyAgrum.PRMexplorer_swigregister(PRMexplorer)

class Vector(object):
    r"""Proxy of C++ std::vector< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        r"""iterator(self) -> SwigPyIterator"""
        return _pyAgrum.Vector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        r"""__nonzero__(self) -> bool"""
        return _pyAgrum.Vector___nonzero__(self)

    def __bool__(self) -> "bool":
        r"""__bool__(self) -> bool"""
        return _pyAgrum.Vector___bool__(self)

    def __len__(self) -> "std::vector< double >::size_type":
        r"""__len__(self) -> std::vector< double >::size_type"""
        return _pyAgrum.Vector___len__(self)

    def __getslice__(self, i: "std::vector< double >::difference_type", j: "std::vector< double >::difference_type") -> "std::vector< double,std::allocator< double > > *":
        r"""__getslice__(self, i, j) -> Vector"""
        return _pyAgrum.Vector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        r"""
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _pyAgrum.Vector___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< double >::difference_type", j: "std::vector< double >::difference_type") -> "void":
        r"""__delslice__(self, i, j)"""
        return _pyAgrum.Vector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        r"""
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _pyAgrum.Vector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< double >::value_type const &":
        r"""
        __getitem__(self, slice) -> Vector
        __getitem__(self, i) -> std::vector< double >::value_type const &
        """
        return _pyAgrum.Vector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        r"""
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _pyAgrum.Vector___setitem__(self, *args)

    def pop(self) -> "std::vector< double >::value_type":
        r"""pop(self) -> std::vector< double >::value_type"""
        return _pyAgrum.Vector_pop(self)

    def append(self, x: "std::vector< double >::value_type const &") -> "void":
        r"""append(self, x)"""
        return _pyAgrum.Vector_append(self, x)

    def empty(self) -> "bool":
        r"""empty(self) -> bool"""
        return _pyAgrum.Vector_empty(self)

    def size(self) -> "std::vector< double >::size_type":
        r"""size(self) -> std::vector< double >::size_type"""
        return _pyAgrum.Vector_size(self)

    def swap(self, v: "Vector") -> "void":
        r"""swap(self, v)"""
        return _pyAgrum.Vector_swap(self, v)

    def begin(self) -> "std::vector< double >::iterator":
        r"""begin(self) -> std::vector< double >::iterator"""
        return _pyAgrum.Vector_begin(self)

    def end(self) -> "std::vector< double >::iterator":
        r"""end(self) -> std::vector< double >::iterator"""
        return _pyAgrum.Vector_end(self)

    def rbegin(self) -> "std::vector< double >::reverse_iterator":
        r"""rbegin(self) -> std::vector< double >::reverse_iterator"""
        return _pyAgrum.Vector_rbegin(self)

    def rend(self) -> "std::vector< double >::reverse_iterator":
        r"""rend(self) -> std::vector< double >::reverse_iterator"""
        return _pyAgrum.Vector_rend(self)

    def clear(self) -> "void":
        r"""clear(self)"""
        return _pyAgrum.Vector_clear(self)

    def get_allocator(self) -> "std::vector< double >::allocator_type":
        r"""get_allocator(self) -> std::vector< double >::allocator_type"""
        return _pyAgrum.Vector_get_allocator(self)

    def pop_back(self) -> "void":
        r"""pop_back(self)"""
        return _pyAgrum.Vector_pop_back(self)

    def erase(self, *args) -> "std::vector< double >::iterator":
        r"""
        erase(self, pos) -> std::vector< double >::iterator
        erase(self, first, last) -> std::vector< double >::iterator
        """
        return _pyAgrum.Vector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(self) -> Vector
        __init__(self, other) -> Vector
        __init__(self, size) -> Vector
        __init__(self, size, value) -> Vector
        """
        _pyAgrum.Vector_swiginit(self, _pyAgrum.new_Vector(*args))

    def push_back(self, x: "std::vector< double >::value_type const &") -> "void":
        r"""push_back(self, x)"""
        return _pyAgrum.Vector_push_back(self, x)

    def front(self) -> "std::vector< double >::value_type const &":
        r"""front(self) -> std::vector< double >::value_type const &"""
        return _pyAgrum.Vector_front(self)

    def back(self) -> "std::vector< double >::value_type const &":
        r"""back(self) -> std::vector< double >::value_type const &"""
        return _pyAgrum.Vector_back(self)

    def assign(self, n: "std::vector< double >::size_type", x: "std::vector< double >::value_type const &") -> "void":
        r"""assign(self, n, x)"""
        return _pyAgrum.Vector_assign(self, n, x)

    def resize(self, *args) -> "void":
        r"""
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _pyAgrum.Vector_resize(self, *args)

    def insert(self, *args) -> "void":
        r"""
        insert(self, pos, x) -> std::vector< double >::iterator
        insert(self, pos, n, x)
        """
        return _pyAgrum.Vector_insert(self, *args)

    def reserve(self, n: "std::vector< double >::size_type") -> "void":
        r"""reserve(self, n)"""
        return _pyAgrum.Vector_reserve(self, n)

    def capacity(self) -> "std::vector< double >::size_type":
        r"""capacity(self) -> std::vector< double >::size_type"""
        return _pyAgrum.Vector_capacity(self)
    __swig_destroy__ = _pyAgrum.delete_Vector

# Register Vector in _pyAgrum:
_pyAgrum.Vector_swigregister(Vector)

class Vector_int(object):
    r"""Proxy of C++ std::vector< unsigned int > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        r"""iterator(self) -> SwigPyIterator"""
        return _pyAgrum.Vector_int_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        r"""__nonzero__(self) -> bool"""
        return _pyAgrum.Vector_int___nonzero__(self)

    def __bool__(self) -> "bool":
        r"""__bool__(self) -> bool"""
        return _pyAgrum.Vector_int___bool__(self)

    def __len__(self) -> "std::vector< unsigned int >::size_type":
        r"""__len__(self) -> std::vector< unsigned int >::size_type"""
        return _pyAgrum.Vector_int___len__(self)

    def __getslice__(self, i: "std::vector< unsigned int >::difference_type", j: "std::vector< unsigned int >::difference_type") -> "std::vector< unsigned int,std::allocator< unsigned int > > *":
        r"""__getslice__(self, i, j) -> Vector_int"""
        return _pyAgrum.Vector_int___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        r"""
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _pyAgrum.Vector_int___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< unsigned int >::difference_type", j: "std::vector< unsigned int >::difference_type") -> "void":
        r"""__delslice__(self, i, j)"""
        return _pyAgrum.Vector_int___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        r"""
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _pyAgrum.Vector_int___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< unsigned int >::value_type const &":
        r"""
        __getitem__(self, slice) -> Vector_int
        __getitem__(self, i) -> std::vector< unsigned int >::value_type const &
        """
        return _pyAgrum.Vector_int___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        r"""
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _pyAgrum.Vector_int___setitem__(self, *args)

    def pop(self) -> "std::vector< unsigned int >::value_type":
        r"""pop(self) -> std::vector< unsigned int >::value_type"""
        return _pyAgrum.Vector_int_pop(self)

    def append(self, x: "std::vector< unsigned int >::value_type const &") -> "void":
        r"""append(self, x)"""
        return _pyAgrum.Vector_int_append(self, x)

    def empty(self) -> "bool":
        r"""empty(self) -> bool"""
        return _pyAgrum.Vector_int_empty(self)

    def size(self) -> "std::vector< unsigned int >::size_type":
        r"""size(self) -> std::vector< unsigned int >::size_type"""
        return _pyAgrum.Vector_int_size(self)

    def swap(self, v: "Vector_int") -> "void":
        r"""swap(self, v)"""
        return _pyAgrum.Vector_int_swap(self, v)

    def begin(self) -> "std::vector< unsigned int >::iterator":
        r"""begin(self) -> std::vector< unsigned int >::iterator"""
        return _pyAgrum.Vector_int_begin(self)

    def end(self) -> "std::vector< unsigned int >::iterator":
        r"""end(self) -> std::vector< unsigned int >::iterator"""
        return _pyAgrum.Vector_int_end(self)

    def rbegin(self) -> "std::vector< unsigned int >::reverse_iterator":
        r"""rbegin(self) -> std::vector< unsigned int >::reverse_iterator"""
        return _pyAgrum.Vector_int_rbegin(self)

    def rend(self) -> "std::vector< unsigned int >::reverse_iterator":
        r"""rend(self) -> std::vector< unsigned int >::reverse_iterator"""
        return _pyAgrum.Vector_int_rend(self)

    def clear(self) -> "void":
        r"""clear(self)"""
        return _pyAgrum.Vector_int_clear(self)

    def get_allocator(self) -> "std::vector< unsigned int >::allocator_type":
        r"""get_allocator(self) -> std::vector< unsigned int >::allocator_type"""
        return _pyAgrum.Vector_int_get_allocator(self)

    def pop_back(self) -> "void":
        r"""pop_back(self)"""
        return _pyAgrum.Vector_int_pop_back(self)

    def erase(self, *args) -> "std::vector< unsigned int >::iterator":
        r"""
        erase(self, pos) -> std::vector< unsigned int >::iterator
        erase(self, first, last) -> std::vector< unsigned int >::iterator
        """
        return _pyAgrum.Vector_int_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(self) -> Vector_int
        __init__(self, other) -> Vector_int
        __init__(self, size) -> Vector_int
        __init__(self, size, value) -> Vector_int
        """
        _pyAgrum.Vector_int_swiginit(self, _pyAgrum.new_Vector_int(*args))

    def push_back(self, x: "std::vector< unsigned int >::value_type const &") -> "void":
        r"""push_back(self, x)"""
        return _pyAgrum.Vector_int_push_back(self, x)

    def front(self) -> "std::vector< unsigned int >::value_type const &":
        r"""front(self) -> std::vector< unsigned int >::value_type const &"""
        return _pyAgrum.Vector_int_front(self)

    def back(self) -> "std::vector< unsigned int >::value_type const &":
        r"""back(self) -> std::vector< unsigned int >::value_type const &"""
        return _pyAgrum.Vector_int_back(self)

    def assign(self, n: "std::vector< unsigned int >::size_type", x: "std::vector< unsigned int >::value_type const &") -> "void":
        r"""assign(self, n, x)"""
        return _pyAgrum.Vector_int_assign(self, n, x)

    def resize(self, *args) -> "void":
        r"""
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _pyAgrum.Vector_int_resize(self, *args)

    def insert(self, *args) -> "void":
        r"""
        insert(self, pos, x) -> std::vector< unsigned int >::iterator
        insert(self, pos, n, x)
        """
        return _pyAgrum.Vector_int_insert(self, *args)

    def reserve(self, n: "std::vector< unsigned int >::size_type") -> "void":
        r"""reserve(self, n)"""
        return _pyAgrum.Vector_int_reserve(self, n)

    def capacity(self) -> "std::vector< unsigned int >::size_type":
        r"""capacity(self) -> std::vector< unsigned int >::size_type"""
        return _pyAgrum.Vector_int_capacity(self)
    __swig_destroy__ = _pyAgrum.delete_Vector_int

# Register Vector_int in _pyAgrum:
_pyAgrum.Vector_int_swigregister(Vector_int)

class Vector_string(object):
    r"""Proxy of C++ std::vector< std::string > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        r"""iterator(self) -> SwigPyIterator"""
        return _pyAgrum.Vector_string_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        r"""__nonzero__(self) -> bool"""
        return _pyAgrum.Vector_string___nonzero__(self)

    def __bool__(self) -> "bool":
        r"""__bool__(self) -> bool"""
        return _pyAgrum.Vector_string___bool__(self)

    def __len__(self) -> "std::vector< std::string >::size_type":
        r"""__len__(self) -> std::vector< std::string >::size_type"""
        return _pyAgrum.Vector_string___len__(self)

    def __getslice__(self, i: "std::vector< std::string >::difference_type", j: "std::vector< std::string >::difference_type") -> "std::vector< std::string,std::allocator< std::string > > *":
        r"""__getslice__(self, i, j) -> Vector_string"""
        return _pyAgrum.Vector_string___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        r"""
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _pyAgrum.Vector_string___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< std::string >::difference_type", j: "std::vector< std::string >::difference_type") -> "void":
        r"""__delslice__(self, i, j)"""
        return _pyAgrum.Vector_string___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        r"""
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _pyAgrum.Vector_string___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< std::string >::value_type const &":
        r"""
        __getitem__(self, slice) -> Vector_string
        __getitem__(self, i) -> std::vector< std::string >::value_type const &
        """
        return _pyAgrum.Vector_string___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        r"""
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _pyAgrum.Vector_string___setitem__(self, *args)

    def pop(self) -> "std::vector< std::string >::value_type":
        r"""pop(self) -> std::vector< std::string >::value_type"""
        return _pyAgrum.Vector_string_pop(self)

    def append(self, x: "std::vector< std::string >::value_type const &") -> "void":
        r"""append(self, x)"""
        return _pyAgrum.Vector_string_append(self, x)

    def empty(self) -> "bool":
        r"""empty(self) -> bool"""
        return _pyAgrum.Vector_string_empty(self)

    def size(self) -> "std::vector< std::string >::size_type":
        r"""size(self) -> std::vector< std::string >::size_type"""
        return _pyAgrum.Vector_string_size(self)

    def swap(self, v: "Vector_string") -> "void":
        r"""swap(self, v)"""
        return _pyAgrum.Vector_string_swap(self, v)

    def begin(self) -> "std::vector< std::string >::iterator":
        r"""begin(self) -> std::vector< std::string >::iterator"""
        return _pyAgrum.Vector_string_begin(self)

    def end(self) -> "std::vector< std::string >::iterator":
        r"""end(self) -> std::vector< std::string >::iterator"""
        return _pyAgrum.Vector_string_end(self)

    def rbegin(self) -> "std::vector< std::string >::reverse_iterator":
        r"""rbegin(self) -> std::vector< std::string >::reverse_iterator"""
        return _pyAgrum.Vector_string_rbegin(self)

    def rend(self) -> "std::vector< std::string >::reverse_iterator":
        r"""rend(self) -> std::vector< std::string >::reverse_iterator"""
        return _pyAgrum.Vector_string_rend(self)

    def clear(self) -> "void":
        r"""clear(self)"""
        return _pyAgrum.Vector_string_clear(self)

    def get_allocator(self) -> "std::vector< std::string >::allocator_type":
        r"""get_allocator(self) -> std::vector< std::string >::allocator_type"""
        return _pyAgrum.Vector_string_get_allocator(self)

    def pop_back(self) -> "void":
        r"""pop_back(self)"""
        return _pyAgrum.Vector_string_pop_back(self)

    def erase(self, *args) -> "std::vector< std::string >::iterator":
        r"""
        erase(self, pos) -> std::vector< std::string >::iterator
        erase(self, first, last) -> std::vector< std::string >::iterator
        """
        return _pyAgrum.Vector_string_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(self) -> Vector_string
        __init__(self, other) -> Vector_string
        __init__(self, size) -> Vector_string
        __init__(self, size, value) -> Vector_string
        """
        _pyAgrum.Vector_string_swiginit(self, _pyAgrum.new_Vector_string(*args))

    def push_back(self, x: "std::vector< std::string >::value_type const &") -> "void":
        r"""push_back(self, x)"""
        return _pyAgrum.Vector_string_push_back(self, x)

    def front(self) -> "std::vector< std::string >::value_type const &":
        r"""front(self) -> std::vector< std::string >::value_type const &"""
        return _pyAgrum.Vector_string_front(self)

    def back(self) -> "std::vector< std::string >::value_type const &":
        r"""back(self) -> std::vector< std::string >::value_type const &"""
        return _pyAgrum.Vector_string_back(self)

    def assign(self, n: "std::vector< std::string >::size_type", x: "std::vector< std::string >::value_type const &") -> "void":
        r"""assign(self, n, x)"""
        return _pyAgrum.Vector_string_assign(self, n, x)

    def resize(self, *args) -> "void":
        r"""
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _pyAgrum.Vector_string_resize(self, *args)

    def insert(self, *args) -> "void":
        r"""
        insert(self, pos, x) -> std::vector< std::string >::iterator
        insert(self, pos, n, x)
        """
        return _pyAgrum.Vector_string_insert(self, *args)

    def reserve(self, n: "std::vector< std::string >::size_type") -> "void":
        r"""reserve(self, n)"""
        return _pyAgrum.Vector_string_reserve(self, n)

    def capacity(self) -> "std::vector< std::string >::size_type":
        r"""capacity(self) -> std::vector< std::string >::size_type"""
        return _pyAgrum.Vector_string_capacity(self)
    __swig_destroy__ = _pyAgrum.delete_Vector_string

# Register Vector_string in _pyAgrum:
_pyAgrum.Vector_string_swigregister(Vector_string)

class SetIteratorStaticEnd(object):
    r"""Proxy of C++ gum::SetIteratorStaticEnd class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> SetIteratorStaticEnd"""
        _pyAgrum.SetIteratorStaticEnd_swiginit(self, _pyAgrum.new_SetIteratorStaticEnd())
    __swig_destroy__ = _pyAgrum.delete_SetIteratorStaticEnd

# Register SetIteratorStaticEnd in _pyAgrum:
_pyAgrum.SetIteratorStaticEnd_swigregister(SetIteratorStaticEnd)

class GumException(Exception):
    r"""Proxy of C++ gum::Exception class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Exception(aMsg="", aType="Generic error") -> GumException
        __init__(self, e) -> GumException
        """
        _pyAgrum.GumException_swiginit(self, _pyAgrum.new_GumException(*args))
    __swig_destroy__ = _pyAgrum.delete_GumException

    def what(self) -> "std::string":
        r"""what(self) -> std::string"""
        return _pyAgrum.GumException_what(self)

    def errorContent(self) -> "std::string":
        r"""
        errorContent(self) -> std::string

        Returns
        -------
        str
        	the error content

        """
        return _pyAgrum.GumException_errorContent(self)

    def errorType(self) -> "std::string":
        r"""
        errorType(self) -> std::string

        Returns
        -------
        str
        	the error type

        """
        return _pyAgrum.GumException_errorType(self)

    def errorCallStack(self) -> "std::string":
        r"""
        errorCallStack(self) -> std::string

        Returns
        -------
        str
        	the error call stack

        """
        return _pyAgrum.GumException_errorCallStack(self)

# Register GumException in _pyAgrum:
_pyAgrum.GumException_swigregister(GumException)


def _createMsg_(filename: "std::string const &", function: "std::string const &", line: "int", msg: "std::string const &") -> "std::string const":
    r"""_createMsg_(filename, function, line, msg) -> std::string const"""
    return _pyAgrum._createMsg_(filename, function, line, msg)
class FatalError(GumException):
    r"""Proxy of C++ gum::FatalError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Fatal error") -> FatalError
        __init__(self, src) -> FatalError
        """
        _pyAgrum.FatalError_swiginit(self, _pyAgrum.new_FatalError(*args))
    __swig_destroy__ = _pyAgrum.delete_FatalError

# Register FatalError in _pyAgrum:
_pyAgrum.FatalError_swigregister(FatalError)

class NotImplementedYet(GumException):
    r"""Proxy of C++ gum::NotImplementedYet class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Not implemented yet") -> NotImplementedYet
        __init__(self, src) -> NotImplementedYet
        """
        _pyAgrum.NotImplementedYet_swiginit(self, _pyAgrum.new_NotImplementedYet(*args))
    __swig_destroy__ = _pyAgrum.delete_NotImplementedYet

# Register NotImplementedYet in _pyAgrum:
_pyAgrum.NotImplementedYet_swigregister(NotImplementedYet)

class IteratorError(GumException):
    r"""Proxy of C++ gum::IteratorError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Error in iterator") -> IteratorError
        __init__(self, src) -> IteratorError
        """
        _pyAgrum.IteratorError_swiginit(self, _pyAgrum.new_IteratorError(*args))
    __swig_destroy__ = _pyAgrum.delete_IteratorError

# Register IteratorError in _pyAgrum:
_pyAgrum.IteratorError_swigregister(IteratorError)

class UndefinedIteratorValue(IteratorError):
    r"""Proxy of C++ gum::UndefinedIteratorValue class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Undefined iterator") -> UndefinedIteratorValue
        __init__(self, src) -> UndefinedIteratorValue
        """
        _pyAgrum.UndefinedIteratorValue_swiginit(self, _pyAgrum.new_UndefinedIteratorValue(*args))
    __swig_destroy__ = _pyAgrum.delete_UndefinedIteratorValue

# Register UndefinedIteratorValue in _pyAgrum:
_pyAgrum.UndefinedIteratorValue_swigregister(UndefinedIteratorValue)

class UndefinedIteratorKey(IteratorError):
    r"""Proxy of C++ gum::UndefinedIteratorKey class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Undefined iterator\'s key") -> UndefinedIteratorKey
        __init__(self, src) -> UndefinedIteratorKey
        """
        _pyAgrum.UndefinedIteratorKey_swiginit(self, _pyAgrum.new_UndefinedIteratorKey(*args))
    __swig_destroy__ = _pyAgrum.delete_UndefinedIteratorKey

# Register UndefinedIteratorKey in _pyAgrum:
_pyAgrum.UndefinedIteratorKey_swigregister(UndefinedIteratorKey)

class NullElement(GumException):
    r"""Proxy of C++ gum::NullElement class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Null element") -> NullElement
        __init__(self, src) -> NullElement
        """
        _pyAgrum.NullElement_swiginit(self, _pyAgrum.new_NullElement(*args))
    __swig_destroy__ = _pyAgrum.delete_NullElement

# Register NullElement in _pyAgrum:
_pyAgrum.NullElement_swigregister(NullElement)

class UndefinedElement(GumException):
    r"""Proxy of C++ gum::UndefinedElement class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Undefined element") -> UndefinedElement
        __init__(self, src) -> UndefinedElement
        """
        _pyAgrum.UndefinedElement_swiginit(self, _pyAgrum.new_UndefinedElement(*args))
    __swig_destroy__ = _pyAgrum.delete_UndefinedElement

# Register UndefinedElement in _pyAgrum:
_pyAgrum.UndefinedElement_swigregister(UndefinedElement)

class SizeError(GumException):
    r"""Proxy of C++ gum::SizeError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="incorrect size") -> SizeError
        __init__(self, src) -> SizeError
        """
        _pyAgrum.SizeError_swiginit(self, _pyAgrum.new_SizeError(*args))
    __swig_destroy__ = _pyAgrum.delete_SizeError

# Register SizeError in _pyAgrum:
_pyAgrum.SizeError_swigregister(SizeError)

class ArgumentError(GumException):
    r"""Proxy of C++ gum::ArgumentError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Argument error") -> ArgumentError
        __init__(self, src) -> ArgumentError
        """
        _pyAgrum.ArgumentError_swiginit(self, _pyAgrum.new_ArgumentError(*args))
    __swig_destroy__ = _pyAgrum.delete_ArgumentError

# Register ArgumentError in _pyAgrum:
_pyAgrum.ArgumentError_swigregister(ArgumentError)

class InvalidArgumentsNumber(ArgumentError):
    r"""Proxy of C++ gum::InvalidArgumentsNumber class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Invalid argument number") -> InvalidArgumentsNumber
        __init__(self, src) -> InvalidArgumentsNumber
        """
        _pyAgrum.InvalidArgumentsNumber_swiginit(self, _pyAgrum.new_InvalidArgumentsNumber(*args))
    __swig_destroy__ = _pyAgrum.delete_InvalidArgumentsNumber

# Register InvalidArgumentsNumber in _pyAgrum:
_pyAgrum.InvalidArgumentsNumber_swigregister(InvalidArgumentsNumber)

class InvalidArgument(ArgumentError):
    r"""Proxy of C++ gum::InvalidArgument class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Invalid argument") -> InvalidArgument
        __init__(self, src) -> InvalidArgument
        """
        _pyAgrum.InvalidArgument_swiginit(self, _pyAgrum.new_InvalidArgument(*args))
    __swig_destroy__ = _pyAgrum.delete_InvalidArgument

# Register InvalidArgument in _pyAgrum:
_pyAgrum.InvalidArgument_swigregister(InvalidArgument)

class IOError(GumException):
    r"""Proxy of C++ gum::IOError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="I/O Error") -> IOError
        __init__(self, src) -> IOError
        """
        _pyAgrum.IOError_swiginit(self, _pyAgrum.new_IOError(*args))
    __swig_destroy__ = _pyAgrum.delete_IOError

# Register IOError in _pyAgrum:
_pyAgrum.IOError_swigregister(IOError)

class FormatNotFound(IOError):
    r"""Proxy of C++ gum::FormatNotFound class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Format not found") -> FormatNotFound
        __init__(self, src) -> FormatNotFound
        """
        _pyAgrum.FormatNotFound_swiginit(self, _pyAgrum.new_FormatNotFound(*args))
    __swig_destroy__ = _pyAgrum.delete_FormatNotFound

# Register FormatNotFound in _pyAgrum:
_pyAgrum.FormatNotFound_swigregister(FormatNotFound)

class OperationNotAllowed(GumException):
    r"""Proxy of C++ gum::OperationNotAllowed class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Operation not allowed") -> OperationNotAllowed
        __init__(self, src) -> OperationNotAllowed
        """
        _pyAgrum.OperationNotAllowed_swiginit(self, _pyAgrum.new_OperationNotAllowed(*args))
    __swig_destroy__ = _pyAgrum.delete_OperationNotAllowed

# Register OperationNotAllowed in _pyAgrum:
_pyAgrum.OperationNotAllowed_swigregister(OperationNotAllowed)

class NotFound(GumException):
    r"""Proxy of C++ gum::NotFound class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Object not found") -> NotFound
        __init__(self, src) -> NotFound
        """
        _pyAgrum.NotFound_swiginit(self, _pyAgrum.new_NotFound(*args))
    __swig_destroy__ = _pyAgrum.delete_NotFound

# Register NotFound in _pyAgrum:
_pyAgrum.NotFound_swigregister(NotFound)

class OutOfBounds(ArgumentError):
    r"""Proxy of C++ gum::OutOfBounds class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Out of bound error") -> OutOfBounds
        __init__(self, src) -> OutOfBounds
        """
        _pyAgrum.OutOfBounds_swiginit(self, _pyAgrum.new_OutOfBounds(*args))
    __swig_destroy__ = _pyAgrum.delete_OutOfBounds

# Register OutOfBounds in _pyAgrum:
_pyAgrum.OutOfBounds_swigregister(OutOfBounds)

class DuplicateElement(ArgumentError):
    r"""Proxy of C++ gum::DuplicateElement class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Duplicate element") -> DuplicateElement
        __init__(self, src) -> DuplicateElement
        """
        _pyAgrum.DuplicateElement_swiginit(self, _pyAgrum.new_DuplicateElement(*args))
    __swig_destroy__ = _pyAgrum.delete_DuplicateElement

# Register DuplicateElement in _pyAgrum:
_pyAgrum.DuplicateElement_swigregister(DuplicateElement)

class DuplicateLabel(ArgumentError):
    r"""Proxy of C++ gum::DuplicateLabel class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Duplicate label") -> DuplicateLabel
        __init__(self, src) -> DuplicateLabel
        """
        _pyAgrum.DuplicateLabel_swiginit(self, _pyAgrum.new_DuplicateLabel(*args))
    __swig_destroy__ = _pyAgrum.delete_DuplicateLabel

# Register DuplicateLabel in _pyAgrum:
_pyAgrum.DuplicateLabel_swigregister(DuplicateLabel)

class GraphError(GumException):
    r"""Proxy of C++ gum::GraphError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Graph error") -> GraphError
        __init__(self, src) -> GraphError
        """
        _pyAgrum.GraphError_swiginit(self, _pyAgrum.new_GraphError(*args))
    __swig_destroy__ = _pyAgrum.delete_GraphError

# Register GraphError in _pyAgrum:
_pyAgrum.GraphError_swigregister(GraphError)

class NoNeighbour(GraphError):
    r"""Proxy of C++ gum::NoNeighbour class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="No neighbour found") -> NoNeighbour
        __init__(self, src) -> NoNeighbour
        """
        _pyAgrum.NoNeighbour_swiginit(self, _pyAgrum.new_NoNeighbour(*args))
    __swig_destroy__ = _pyAgrum.delete_NoNeighbour

# Register NoNeighbour in _pyAgrum:
_pyAgrum.NoNeighbour_swigregister(NoNeighbour)

class NoParent(GraphError):
    r"""Proxy of C++ gum::NoParent class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="No parent found") -> NoParent
        __init__(self, src) -> NoParent
        """
        _pyAgrum.NoParent_swiginit(self, _pyAgrum.new_NoParent(*args))
    __swig_destroy__ = _pyAgrum.delete_NoParent

# Register NoParent in _pyAgrum:
_pyAgrum.NoParent_swigregister(NoParent)

class NoChild(GraphError):
    r"""Proxy of C++ gum::NoChild class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="No child found") -> NoChild
        __init__(self, src) -> NoChild
        """
        _pyAgrum.NoChild_swiginit(self, _pyAgrum.new_NoChild(*args))
    __swig_destroy__ = _pyAgrum.delete_NoChild

# Register NoChild in _pyAgrum:
_pyAgrum.NoChild_swigregister(NoChild)

class InvalidEdge(GraphError):
    r"""Proxy of C++ gum::InvalidEdge class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Invalid edge") -> InvalidEdge
        __init__(self, src) -> InvalidEdge
        """
        _pyAgrum.InvalidEdge_swiginit(self, _pyAgrum.new_InvalidEdge(*args))
    __swig_destroy__ = _pyAgrum.delete_InvalidEdge

# Register InvalidEdge in _pyAgrum:
_pyAgrum.InvalidEdge_swigregister(InvalidEdge)

class InvalidArc(GraphError):
    r"""Proxy of C++ gum::InvalidArc class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Invalid arc") -> InvalidArc
        __init__(self, src) -> InvalidArc
        """
        _pyAgrum.InvalidArc_swiginit(self, _pyAgrum.new_InvalidArc(*args))
    __swig_destroy__ = _pyAgrum.delete_InvalidArc

# Register InvalidArc in _pyAgrum:
_pyAgrum.InvalidArc_swigregister(InvalidArc)

class InvalidNode(GraphError):
    r"""Proxy of C++ gum::InvalidNode class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Invalid node") -> InvalidNode
        __init__(self, src) -> InvalidNode
        """
        _pyAgrum.InvalidNode_swiginit(self, _pyAgrum.new_InvalidNode(*args))
    __swig_destroy__ = _pyAgrum.delete_InvalidNode

# Register InvalidNode in _pyAgrum:
_pyAgrum.InvalidNode_swigregister(InvalidNode)

class DefaultInLabel(GraphError):
    r"""Proxy of C++ gum::DefaultInLabel class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Error on label") -> DefaultInLabel
        __init__(self, src) -> DefaultInLabel
        """
        _pyAgrum.DefaultInLabel_swiginit(self, _pyAgrum.new_DefaultInLabel(*args))
    __swig_destroy__ = _pyAgrum.delete_DefaultInLabel

# Register DefaultInLabel in _pyAgrum:
_pyAgrum.DefaultInLabel_swigregister(DefaultInLabel)

class InvalidDirectedCycle(GraphError):
    r"""Proxy of C++ gum::InvalidDirectedCycle class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Directed cycle detected") -> InvalidDirectedCycle
        __init__(self, src) -> InvalidDirectedCycle
        """
        _pyAgrum.InvalidDirectedCycle_swiginit(self, _pyAgrum.new_InvalidDirectedCycle(*args))
    __swig_destroy__ = _pyAgrum.delete_InvalidDirectedCycle

# Register InvalidDirectedCycle in _pyAgrum:
_pyAgrum.InvalidDirectedCycle_swigregister(InvalidDirectedCycle)

class CPTError(GumException):
    r"""Proxy of C++ gum::CPTError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="CPT error") -> CPTError
        __init__(self, src) -> CPTError
        """
        _pyAgrum.CPTError_swiginit(self, _pyAgrum.new_CPTError(*args))
    __swig_destroy__ = _pyAgrum.delete_CPTError

# Register CPTError in _pyAgrum:
_pyAgrum.CPTError_swigregister(CPTError)

class IncompatibleEvidence(GumException):
    r"""Proxy of C++ gum::IncompatibleEvidence class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Several evidence/CPT are incompatible together (proba=0)") -> IncompatibleEvidence
        __init__(self, src) -> IncompatibleEvidence
        """
        _pyAgrum.IncompatibleEvidence_swiginit(self, _pyAgrum.new_IncompatibleEvidence(*args))
    __swig_destroy__ = _pyAgrum.delete_IncompatibleEvidence

# Register IncompatibleEvidence in _pyAgrum:
_pyAgrum.IncompatibleEvidence_swigregister(IncompatibleEvidence)

class FactoryError(GumException):
    r"""Proxy of C++ gum::FactoryError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Factory error") -> FactoryError
        __init__(self, src) -> FactoryError
        """
        _pyAgrum.FactoryError_swiginit(self, _pyAgrum.new_FactoryError(*args))
    __swig_destroy__ = _pyAgrum.delete_FactoryError

# Register FactoryError in _pyAgrum:
_pyAgrum.FactoryError_swigregister(FactoryError)

class FactoryInvalidState(FactoryError):
    r"""Proxy of C++ gum::FactoryInvalidState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Invalid state error") -> FactoryInvalidState
        __init__(self, src) -> FactoryInvalidState
        """
        _pyAgrum.FactoryInvalidState_swiginit(self, _pyAgrum.new_FactoryInvalidState(*args))
    __swig_destroy__ = _pyAgrum.delete_FactoryInvalidState

# Register FactoryInvalidState in _pyAgrum:
_pyAgrum.FactoryInvalidState_swigregister(FactoryInvalidState)

class TypeError(FactoryError):
    r"""Proxy of C++ gum::TypeError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Wrong type") -> TypeError
        __init__(self, src) -> TypeError
        """
        _pyAgrum.TypeError_swiginit(self, _pyAgrum.new_TypeError(*args))
    __swig_destroy__ = _pyAgrum.delete_TypeError

# Register TypeError in _pyAgrum:
_pyAgrum.TypeError_swigregister(TypeError)

class WrongClassElement(FactoryError):
    r"""Proxy of C++ gum::WrongClassElement class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Wrong ClassElement") -> WrongClassElement
        __init__(self, src) -> WrongClassElement
        """
        _pyAgrum.WrongClassElement_swiginit(self, _pyAgrum.new_WrongClassElement(*args))
    __swig_destroy__ = _pyAgrum.delete_WrongClassElement

# Register WrongClassElement in _pyAgrum:
_pyAgrum.WrongClassElement_swigregister(WrongClassElement)

class PRMTypeError(FactoryError):
    r"""Proxy of C++ gum::PRMTypeError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Wrong subtype or subclass") -> PRMTypeError
        __init__(self, src) -> PRMTypeError
        """
        _pyAgrum.PRMTypeError_swiginit(self, _pyAgrum.new_PRMTypeError(*args))
    __swig_destroy__ = _pyAgrum.delete_PRMTypeError

# Register PRMTypeError in _pyAgrum:
_pyAgrum.PRMTypeError_swigregister(PRMTypeError)

class LearningError(GumException):
    r"""Proxy of C++ gum::LearningError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Factory error") -> LearningError
        __init__(self, src) -> LearningError
        """
        _pyAgrum.LearningError_swiginit(self, _pyAgrum.new_LearningError(*args))
    __swig_destroy__ = _pyAgrum.delete_LearningError

# Register LearningError in _pyAgrum:
_pyAgrum.LearningError_swigregister(LearningError)

class IncompatibleScoreApriori(LearningError):
    r"""Proxy of C++ gum::IncompatibleScoreApriori class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Incompatible (maybe implicit) priors") -> IncompatibleScoreApriori
        __init__(self, src) -> IncompatibleScoreApriori
        """
        _pyAgrum.IncompatibleScoreApriori_swiginit(self, _pyAgrum.new_IncompatibleScoreApriori(*args))
    __swig_destroy__ = _pyAgrum.delete_IncompatibleScoreApriori

# Register IncompatibleScoreApriori in _pyAgrum:
_pyAgrum.IncompatibleScoreApriori_swigregister(IncompatibleScoreApriori)

class PossiblyIncompatibleScoreApriori(LearningError):
    r"""Proxy of C++ gum::PossiblyIncompatibleScoreApriori class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Possible incompatibility between score and prior") -> PossiblyIncompatibleScoreApriori
        __init__(self, src) -> PossiblyIncompatibleScoreApriori
        """
        _pyAgrum.PossiblyIncompatibleScoreApriori_swiginit(self, _pyAgrum.new_PossiblyIncompatibleScoreApriori(*args))
    __swig_destroy__ = _pyAgrum.delete_PossiblyIncompatibleScoreApriori

# Register PossiblyIncompatibleScoreApriori in _pyAgrum:
_pyAgrum.PossiblyIncompatibleScoreApriori_swigregister(PossiblyIncompatibleScoreApriori)

class DatabaseError(LearningError):
    r"""Proxy of C++ gum::DatabaseError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Database error") -> DatabaseError
        __init__(self, src) -> DatabaseError
        """
        _pyAgrum.DatabaseError_swiginit(self, _pyAgrum.new_DatabaseError(*args))
    __swig_destroy__ = _pyAgrum.delete_DatabaseError

# Register DatabaseError in _pyAgrum:
_pyAgrum.DatabaseError_swigregister(DatabaseError)

class MissingVariableInDatabase(LearningError):
    r"""Proxy of C++ gum::MissingVariableInDatabase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Missing variable name in database") -> MissingVariableInDatabase
        __init__(self, src) -> MissingVariableInDatabase
        """
        _pyAgrum.MissingVariableInDatabase_swiginit(self, _pyAgrum.new_MissingVariableInDatabase(*args))
    __swig_destroy__ = _pyAgrum.delete_MissingVariableInDatabase

# Register MissingVariableInDatabase in _pyAgrum:
_pyAgrum.MissingVariableInDatabase_swigregister(MissingVariableInDatabase)

class MissingValueInDatabase(LearningError):
    r"""Proxy of C++ gum::MissingValueInDatabase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="The database contains some missing values") -> MissingValueInDatabase
        __init__(self, src) -> MissingValueInDatabase
        """
        _pyAgrum.MissingValueInDatabase_swiginit(self, _pyAgrum.new_MissingValueInDatabase(*args))
    __swig_destroy__ = _pyAgrum.delete_MissingValueInDatabase

# Register MissingValueInDatabase in _pyAgrum:
_pyAgrum.MissingValueInDatabase_swigregister(MissingValueInDatabase)

class UnknownLabelInDatabase(LearningError):
    r"""Proxy of C++ gum::UnknownLabelInDatabase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aMsg, aType="Unknown label found in database") -> UnknownLabelInDatabase
        __init__(self, src) -> UnknownLabelInDatabase
        """
        _pyAgrum.UnknownLabelInDatabase_swiginit(self, _pyAgrum.new_UnknownLabelInDatabase(*args))
    __swig_destroy__ = _pyAgrum.delete_UnknownLabelInDatabase

# Register UnknownLabelInDatabase in _pyAgrum:
_pyAgrum.UnknownLabelInDatabase_swigregister(UnknownLabelInDatabase)

class SyntaxError(IOError):
    r"""Proxy of C++ gum::SyntaxError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(self, aMsg, nol, noc, aType="Syntax Error") -> SyntaxError"""
        _pyAgrum.SyntaxError_swiginit(self, _pyAgrum.new_SyntaxError(*args))

    def col(self) -> "gum::Size":
        r"""
        col(self) -> gum::Size

        Returns
        -------
        int
        	the indice of the colonne of the error

        """
        return _pyAgrum.SyntaxError_col(self)

    def line(self) -> "gum::Size":
        r"""
        line(self) -> gum::Size

        Returns
        -------
        int
        	the indice of the line of the error

        """
        return _pyAgrum.SyntaxError_line(self)
    __swig_destroy__ = _pyAgrum.delete_SyntaxError

# Register SyntaxError in _pyAgrum:
_pyAgrum.SyntaxError_swigregister(SyntaxError)


def randomValue(max: "gum::Size const"=2) -> "gum::Idx":
    r"""
    randomValue(max=2) -> gum::Idx

    Returns
    -------
    int
      a value randomly drawn (0 or 1)

    """
    return _pyAgrum.randomValue(max)

def randomProba() -> "double":
    r"""
    randomProba() -> double

    Returns
    -------
    double
        a random number between 0 and 1 included (i.e. a proba). 

    """
    return _pyAgrum.randomProba()

def randomGeneratorSeed() -> "unsigned int":
    r"""
    randomGeneratorSeed() -> unsigned int

    Returns
    -------
    int
      a randomly generated seed

    """
    return _pyAgrum.randomGeneratorSeed()

def initRandom(seed: "unsigned int"=0) -> "void":
    r"""
    initRandom(seed=0)

    Initialize random generator seed.

    Parameters
    ----------
    seed : int
      the seed used to initialize the random generator

    """
    return _pyAgrum.initRandom(seed)

def getRandomGenerator(seed: "unsigned int"=0) -> "std::default_random_engine":
    r"""
    getRandomGenerator(seed=0) -> std::default_random_engine

    Returns
    -------
    tbw
      the random generator

    """
    return _pyAgrum.getRandomGenerator(seed)

def isOMP() -> "bool":
    r"""
    isOMP() -> bool

    Returns
    -------
    bool
      True if OMP has been set at compilation, False otherwise

    """
    return _pyAgrum.isOMP()

def setNumberOfThreads(number: "unsigned int") -> "void":
    r"""
    setNumberOfThreads(number)

    To avoid spare cycles (less then 100% CPU occupied), use more threads than logical processors (x2 is a good all-around value). 

    Returns
    -------
    number : int
      the number of threads to be used

    """
    return _pyAgrum.setNumberOfThreads(number)

def getMaxNumberOfThreads() -> "unsigned int":
    r"""
    getMaxNumberOfThreads() -> unsigned int

    Returns
    -------
    int
      the max number of threads

    """
    return _pyAgrum.getMaxNumberOfThreads()

def getThreadNumber() -> "unsigned int":
    r"""
    getThreadNumber() -> unsigned int

    Returns
    -------
    int
      the number of thread

    """
    return _pyAgrum.getThreadNumber()

def getNumberOfRunningThreads() -> "unsigned int":
    r"""
    getNumberOfRunningThreads() -> unsigned int

    Returns
    -------
    int
      the number of running threads

    """
    return _pyAgrum.getNumberOfRunningThreads()

def getNumberOfLogicalProcessors() -> "unsigned int":
    r"""
    getNumberOfLogicalProcessors() -> unsigned int

    Returns
    -------
    int
      the number of logical processors

    """
    return _pyAgrum.getNumberOfLogicalProcessors()

def setNestedParallelism(value: "bool") -> "void":
    r"""
    setNestedParallelism(value)

    Parameters
    ----------
    value : bool
      True if nested parallelism should be activated

    """
    return _pyAgrum.setNestedParallelism(value)

def getNestedParallelism() -> "bool":
    r"""
    getNestedParallelism() -> bool

    Returns
    -------
    bool
      True if nested parallelism is enabled

    """
    return _pyAgrum.getNestedParallelism()

def setDynamicThreadsNumber(value: "bool") -> "void":
    r"""
    setDynamicThreadsNumber(value)

    Parameters
    ----------
    value : bool
      True if the number of threads should be dynamic

    """
    return _pyAgrum.setDynamicThreadsNumber(value)

def getDynamicThreadsNumber() -> "bool":
    r"""
    getDynamicThreadsNumber() -> bool

    Returns
    -------
    bool
      True if dynamic threads number is enabled

    """
    return _pyAgrum.getDynamicThreadsNumber()
VarType_Discretized = _pyAgrum.VarType_Discretized

VarType_Labelized = _pyAgrum.VarType_Labelized

VarType_Integer = _pyAgrum.VarType_Integer

VarType_Range = _pyAgrum.VarType_Range

VarType_Continuous = _pyAgrum.VarType_Continuous

class Variable(object):
    r"""

    Abstract class used by DiscreteVariable.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_Variable

    def clone(self) -> "gum::Variable *":
        r"""
        clone(self) -> Variable

        Copy factory

        Returns
        -------
        pyAgrum.DiscreteVariable
        	a pointer on a new copy of this

        """
        return _pyAgrum.Variable_clone(self)

    def __eq__(self, aRV: "Variable") -> "bool":
        r"""__eq__(self, aRV) -> bool"""
        return _pyAgrum.Variable___eq__(self, aRV)

    def __ne__(self, aRV: "Variable") -> "bool":
        r"""__ne__(self, aRV) -> bool"""
        return _pyAgrum.Variable___ne__(self, aRV)

    def setName(self, theValue: "std::string const &") -> "void":
        r"""
        setName(self, theValue)

        sets the name of the variable.

        Parameters
        ----------
        theValue : str
        	the new description of the variable

        """
        return _pyAgrum.Variable_setName(self, theValue)

    def name(self) -> "std::string const &":
        r"""
        name(self) -> std::string const &

        Returns
        -------
        str
        	the name of the variable

        """
        return _pyAgrum.Variable_name(self)

    def setDescription(self, theValue: "std::string const &") -> "void":
        r"""
        setDescription(self, theValue)

        set the description of the variable.

        Parameters
        ----------
        theValue : str
        	the new description of the variable

        """
        return _pyAgrum.Variable_setDescription(self, theValue)

    def description(self) -> "std::string const &":
        r"""
        description(self) -> std::string const &

        Returns
        -------
        str
        	the description of the variable

        """
        return _pyAgrum.Variable_description(self)

    def varType(self) -> "gum::VarType":
        r"""varType(self) -> gum::VarType"""
        return _pyAgrum.Variable_varType(self)

    def domain(self) -> "std::string const":
        r"""domain(self) -> std::string const"""
        return _pyAgrum.Variable_domain(self)

# Register Variable in _pyAgrum:
_pyAgrum.Variable_swigregister(Variable)

class DiscreteVariable(Variable):
    r"""

    DiscreteVariable is the base class for discrete random variables.

    DiscreteVariable(aName, aDesc='') -> DiscreteVariable
        Parameters:
            * **aName** (*str*) -- the name of the variable
            * **aDesc** (*str*) -- the (optional) description of the variable

    DiscreteVariable(aDRV) -> DiscreteVariable
        Parameters:
            * **aDRV** (*pyAgrum.DiscreteVariable*) -- the pyAgrum.DiscreteVariable that will be copied

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __swig_destroy__ = _pyAgrum.delete_DiscreteVariable

    def clone(self) -> "gum::DiscreteVariable *":
        r"""
        clone(self) -> DiscreteVariable

        Returns
        -------
        pyAgrum.DiscreteVariable
        	a copy of the DiscreteVariable

        """
        return _pyAgrum.DiscreteVariable_clone(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool

        Returns
        -------
        bool
        	True if the domain size < 2

        """
        return _pyAgrum.DiscreteVariable_empty(self)

    def domainSize(self) -> "gum::Size":
        r"""
        domainSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.DiscreteVariable_domainSize(self)

    def labels(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        labels(self) -> Vector_string

        Returns
        -------
        tuple
        	a tuple containing the labels

        """
        return _pyAgrum.DiscreteVariable_labels(self)

    def numerical(self, indice: "gum::Idx") -> "double":
        r"""
        numerical(self, indice) -> double

        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.DiscreteVariable_numerical(self, indice)

    def varType(self) -> "gum::VarType":
        r"""
        varType(self) -> gum::VarType

        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.DiscreteVariable_varType(self)

    def __eq__(self, aRV: "DiscreteVariable") -> "bool":
        r"""__eq__(self, aRV) -> bool"""
        return _pyAgrum.DiscreteVariable___eq__(self, aRV)

    def __ne__(self, aRV: "DiscreteVariable") -> "bool":
        r"""__ne__(self, aRV) -> bool"""
        return _pyAgrum.DiscreteVariable___ne__(self, aRV)

    def index(self, label: "std::string const &") -> "gum::Idx":
        r"""
        index(self, label) -> gum::Idx

        Parameters
        ----------
        label : str
        	a label

        Returns
        -------
        int
        	the indice of the label

        """
        return _pyAgrum.DiscreteVariable_index(self, label)

    def label(self, i: "gum::Idx") -> "std::string":
        r"""
        label(self, i) -> std::string

        Parameters
        ----------
        i : int
        	the index of the label we wish to return

        Returns
        -------
        str
        	the indice-th label

        Raises
        ------
        gum.OutOfBound
        	If the variable does not contain the label

        """
        return _pyAgrum.DiscreteVariable_label(self, i)

    def toStringWithDescription(self) -> "std::string":
        r"""
        toStringWithDescription(self) -> std::string

        Returns
        -------
        str
        	a description of the variable

        """
        return _pyAgrum.DiscreteVariable_toStringWithDescription(self)

    def domain(self) -> "std::string const":
        r"""
        domain(self) -> std::string const

        Returns
        -------
        str
        	the domain of the variable

        """
        return _pyAgrum.DiscreteVariable_domain(self)

    def stype(self) -> "std::string const":
        r"""stype(self) -> std::string const"""
        return _pyAgrum.DiscreteVariable_stype(self)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.DiscreteVariable___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.DiscreteVariable___str__(self)

    def __getitem__(self,label):   # adding the y() function here
        return self.index(label)


    def toLabelizedVar(self) -> "gum::LabelizedVariable":
        r"""
        toLabelizedVar(self) -> LabelizedVariable

        Returns
        -------
        pyAgrum.LabelizedVariable
        	the labelized variable

        Raises
        ------
        gum.RuntimeError
        	If the variable is not a LabelizedVariable

        """
        return _pyAgrum.DiscreteVariable_toLabelizedVar(self)

    def toRangeVar(self) -> "gum::RangeVariable":
        r"""
        toRangeVar(self) -> RangeVariable

        Returns
        -------
        pyAgrum.RangeVariable
        	the range variable

        Raises
        ------
        gum.RuntimeError
        	If the variable is not a RangeVariable

        """
        return _pyAgrum.DiscreteVariable_toRangeVar(self)

    def toIntegerVar(self) -> "gum::IntegerVariable":
        r"""toIntegerVar(self) -> IntegerVariable"""
        return _pyAgrum.DiscreteVariable_toIntegerVar(self)

    def toDiscretizedVar(self) -> "gum::DiscretizedVariable< double >":
        r"""
        toDiscretizedVar(self) -> DiscretizedVariable

        Returns
        -------
        pyAgrum.DiscretizedVariable
        	the discretized variable

        Raises
        ------
        gum.RuntimeError 
        	If the variable is not a DiscretizedVariable

        """
        return _pyAgrum.DiscreteVariable_toDiscretizedVar(self)

# Register DiscreteVariable in _pyAgrum:
_pyAgrum.DiscreteVariable_swigregister(DiscreteVariable)

class LabelizedVariable(DiscreteVariable):
    r"""

    LabelizedVariable is a discrete random variable with a customizable sequence of labels.

    LabelizedVariable(aName, aDesc='', nbrLabel=2) -> LabelizedVariable
        Parameters:
            * **aName** (*str*) -- the name of the variable
            * **aDesc** (*str*) -- the (optional) description of the variable
            * **nbrLabel** (*int*) -- the number of labels to create (2 by default)

    LabelizedVariable(aLDRV) -> LabelizedVariable
        Parameters:
            * **aLDRV** (*pyAgrum.LabelizedVariable*) -- The pyAgrum.LabelizedVariable that will be copied

    Examples
    --------
    >>> import pyAgrum as gum
    >>>
    >>> # creating a variable with 3 labels : '0', '1' and '2'
    >>> va=gum.LabelizedVariable('a','a labelized variable',3)
    >>> print(va)
    >>> ## a<0,1,2>
    >>>
    >>> va.addLabel('foo')
    >>> print(va)
    >>> ## a<0,1,2,foo>
    >>>
    >>> va.chgLabel(1,'bar')
    >>> print(va)
    >>> a<0,bar,2,foo>
    >>>
    >>> vb=gum.LabelizedVariable('b','b',0).addLabel('A').addLabel('B').addLabel('C')
    >>> print(vb)
    >>> ## b<A,B,C>
    >>> 
    >>> vb.labels()
    >>> ## ('A', 'B', 'C')
    >>> 
    >>> vb.isLabel('E')
    >>> ## False
    >>> 
    >>> vb.label(2)
    >>> ## 'B'

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self, aName, aDesc="", nbrLabel=2) -> LabelizedVariable
        __init__(self, aName, aDesc, labels) -> LabelizedVariable
        __init__(self, aLDRV) -> LabelizedVariable
        """
        _pyAgrum.LabelizedVariable_swiginit(self, _pyAgrum.new_LabelizedVariable(*args))
    __swig_destroy__ = _pyAgrum.delete_LabelizedVariable

    def clone(self) -> "gum::LabelizedVariable *":
        r"""
        clone(self) -> LabelizedVariable

        Returns
        -------
        pyAgrum.LabelizedVariable
        	a copy of the LabelizedVariable

        """
        return _pyAgrum.LabelizedVariable_clone(self)

    def index(self, label: "std::string const &") -> "gum::Idx":
        r"""
        index(self, label) -> gum::Idx

        Parameters
        ----------
        label : str
        	a label

        Returns
        -------
        int
        	the indice of the label

        """
        return _pyAgrum.LabelizedVariable_index(self, label)

    def isLabel(self, aLabel: "std::string const &") -> "bool":
        r"""
        isLabel(self, aLabel) -> bool

        Indicates whether the variable already has the label passed in argument

        Parameters
        ----------
        aLabel : str
        	the label to be tested

        Returns
        -------
        bool
        	True if the label already exists

        """
        return _pyAgrum.LabelizedVariable_isLabel(self, aLabel)

    def addLabel(self,*args):
        """
        Add a label with a new index (we assume that we will NEVER remove a label).

        Parameters
        ----------
        aLabel : str
            the label to be added to the labelized variable

        Returns
        -------
        pyAgrum.LabelizedVariable
            the labelized variable

        Raises
        ------
        gum.DuplicateElement
            If the variable already contains the label
        """
        _pyAgrum.LabelizedVariable_addLabel(self,*args)
        return self



    def changeLabel(self, pos: "gum::Idx", aLabel: "std::string const &") -> "void":
        r"""
        changeLabel(self, pos, aLabel)

        Change the label at the specified index

        Parameters
        ----------
        pos : int
        	the index of the label to be changed
        aLabel : str
        	the label to be added to the labelized variable

        Raises
        ------
        gum.DuplicatedElement
          If the variable already contains the new label
        gum.OutOfBounds
          If the index is greater than the size of the variable

        """
        return _pyAgrum.LabelizedVariable_changeLabel(self, pos, aLabel)

    def eraseLabels(self) -> "void":
        r"""
        eraseLabels(self)

        Erase all the labels from the variable.

        """
        return _pyAgrum.LabelizedVariable_eraseLabels(self)

    def label(self, i: "gum::Idx") -> "std::string":
        r"""
        label(self, i) -> std::string

        Parameters
        ----------
        i : int
        	the index of the label we wish to return

        Returns
        -------
        str
        	the indice-th label

        Raises
        ------
        gum.OutOfBound
        	If the variable does not contain the label

        """
        return _pyAgrum.LabelizedVariable_label(self, i)

    def posLabel(self, label: "std::string const &") -> "gum::Idx":
        r"""posLabel(self, label) -> gum::Idx"""
        return _pyAgrum.LabelizedVariable_posLabel(self, label)

    def numerical(self, index: "gum::Idx") -> "double":
        r"""
        numerical(self, index) -> double

        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.LabelizedVariable_numerical(self, index)

    def domainSize(self) -> "gum::Size":
        r"""
        domainSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.LabelizedVariable_domainSize(self)

    def varType(self) -> "gum::VarType":
        r"""
        varType(self) -> gum::VarType

        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.LabelizedVariable_varType(self)

    def domain(self) -> "std::string const":
        r"""
        domain(self) -> std::string const

        Returns
        -------
        str
            the domain of the variable as a string

        """
        return _pyAgrum.LabelizedVariable_domain(self)

    def stype(self) -> "std::string const":
        r"""stype(self) -> std::string const"""
        return _pyAgrum.LabelizedVariable_stype(self)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.LabelizedVariable___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.LabelizedVariable___str__(self)

# Register LabelizedVariable in _pyAgrum:
_pyAgrum.LabelizedVariable_swigregister(LabelizedVariable)

class RangeVariable(DiscreteVariable):
    r"""

    RangeVariable represents a variable with a range of integers as domain.

    RangeVariable(aName, aDesc,minVal, maxVal) -> RangeVariable
        Parameters:
            * **aName** (*str*) -- the name of the variable
            * **aDesc** (*str*) -- the description of the variable
            * **minVal** (*int*) -- the minimal integer of the interval
            * **maxVal** (*int*) -- the maximal integer of the interval

    RangeVariable(aName, aDesc='') -> RangeVariable
        Parameters:
            * **aName** (*str*) -- the name of the variable
            * **aDesc** (*str*) -- the description of the variable

        By default ``minVal=0`` and ``maxVal=1``

    RangeVariable(aRV) -> RangeVariable
        Parameters:
            * **aDV** (*RangeVariable*) -- the pyAgrum.RangeVariable that will be copied

    Examples
    --------
    >>> import pyAgrum as gum
    >>>
    >>> vI=gum.gum.RangeVariable('I','I in [4,10]',4,10)
    >>> print(vI)
    >>> ## I[4-10]
    >>> 
    >>> vX.maxVal()
    >>> ## 10
    >>> 
    >>> vX.belongs(1)
    >>> ## False
    >>> 
    >>> # where is the value 5 ?
    >>> vX.index('5')
    >>> ## 1
    >>> 
    >>> vi.labels()
    >>> ## ('4', '5', '6', '7', '8', '9', '10')

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self, aName, aDesc, minVal, maxVal) -> RangeVariable
        __init__(self, aName, aDesc) -> RangeVariable
        __init__(self, aDRV) -> RangeVariable
        """
        _pyAgrum.RangeVariable_swiginit(self, _pyAgrum.new_RangeVariable(*args))
    __swig_destroy__ = _pyAgrum.delete_RangeVariable

    def clone(self) -> "gum::RangeVariable *":
        r"""
        clone(self) -> RangeVariable

        Returns
        -------
        pyAgrum.RangeVariable
        	a copy of the RangeVariable

        """
        return _pyAgrum.RangeVariable_clone(self)

    def domainSize(self) -> "gum::Size":
        r"""
        domainSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.RangeVariable_domainSize(self)

    def varType(self) -> "gum::VarType":
        r"""
        varType(self) -> gum::VarType

        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.RangeVariable_varType(self)

    def label(self, index: "gum::Idx") -> "std::string":
        r"""
        label(self, index) -> std::string

        Parameters
        ----------
        indice : int
          the index of the label we wish to return

        Returns
        -------
        str
          the indice-th label

        Raises
        ------
        gum.OutOfBound
          If the variable does not contain the label

        """
        return _pyAgrum.RangeVariable_label(self, index)

    def numerical(self, index: "gum::Idx") -> "double":
        r"""
        numerical(self, index) -> double

        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.RangeVariable_numerical(self, index)

    def minVal(self) -> "long":
        r"""
        minVal(self) -> long

        Returns
        -------
        long :
          the lower bound of the variable

        """
        return _pyAgrum.RangeVariable_minVal(self)

    def setMinVal(self, minVal: "long") -> "void":
        r"""
        setMinVal(self, minVal)

        Set a new value of the lower bound

        Parameters
        ----------
        minVal : long
          The new value of the lower bound

        Warnings
        --------
        An error should be raised if the value is higher than the upper bound.

        """
        return _pyAgrum.RangeVariable_setMinVal(self, minVal)

    def maxVal(self) -> "long":
        r"""
        maxVal(self) -> long

        Returns
        -------
        long :
          the upper bound of the variable.

        """
        return _pyAgrum.RangeVariable_maxVal(self)

    def setMaxVal(self, maxVal: "long") -> "void":
        r"""
        setMaxVal(self, maxVal)

        Set a new value of the upper bound

        Parameters
        ----------
        maxVal : long
          The new value of the upper bound

        Warnings
        --------
        An error should be raised if the value is lower than the lower bound.

        """
        return _pyAgrum.RangeVariable_setMaxVal(self, maxVal)

    def belongs(self, val: "long") -> "bool":
        r"""
        belongs(self, val) -> bool

        Parameters
        ----------
        val : long
          the value to be tested

        Returns
        -------
        bool:
          True if the value in parameters belongs to the variable's interval.

        """
        return _pyAgrum.RangeVariable_belongs(self, val)

    def index(self, arg2: "std::string const &") -> "gum::Idx":
        r"""
        index(self, arg2) -> gum::Idx

        Parameters
        ----------
        arg2 : str
          a label

        Returns
        -------
        int
          the indice of the label

        """
        return _pyAgrum.RangeVariable_index(self, arg2)

    def domain(self) -> "std::string const":
        r"""
        domain(self) -> std::string const

        Returns
        -------
        str
        	the domain of the variable

        """
        return _pyAgrum.RangeVariable_domain(self)

    def stype(self) -> "std::string const":
        r"""stype(self) -> std::string const"""
        return _pyAgrum.RangeVariable_stype(self)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.RangeVariable___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.RangeVariable___str__(self)

# Register RangeVariable in _pyAgrum:
_pyAgrum.RangeVariable_swigregister(RangeVariable)

class IntegerVariable(DiscreteVariable):
    r"""Proxy of C++ gum::IntegerVariable class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aName, aDesc="") -> IntegerVariable
        __init__(self, aName, aDesc, domain) -> IntegerVariable
        __init__(self, _from) -> IntegerVariable
        __init__(self, _from) -> IntegerVariable
        """
        _pyAgrum.IntegerVariable_swiginit(self, _pyAgrum.new_IntegerVariable(*args))

    def clone(self) -> "gum::IntegerVariable *":
        r"""
        clone(self) -> IntegerVariable

        Returns
        -------
        pyAgrum.DiscreteVariable
        	a copy of the DiscreteVariable

        """
        return _pyAgrum.IntegerVariable_clone(self)
    __swig_destroy__ = _pyAgrum.delete_IntegerVariable

    def __eq__(self, var: "Variable") -> "bool":
        r"""__eq__(self, var) -> bool"""
        return _pyAgrum.IntegerVariable___eq__(self, var)

    def __ne__(self, var: "Variable") -> "bool":
        r"""__ne__(self, var) -> bool"""
        return _pyAgrum.IntegerVariable___ne__(self, var)

    def domainSize(self) -> "gum::Size":
        r"""
        domainSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.IntegerVariable_domainSize(self)

    def varType(self) -> "gum::VarType":
        r"""
        varType(self) -> gum::VarType

        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.IntegerVariable_varType(self)

    def index(self, label: "std::string const &") -> "gum::Idx":
        r"""
        index(self, label) -> gum::Idx

        Parameters
        ----------
        label : str
        	a label

        Returns
        -------
        int
        	the indice of the label

        """
        return _pyAgrum.IntegerVariable_index(self, label)

    def label(self, index: "gum::Idx") -> "std::string":
        r"""
        label(self, index) -> std::string

        Parameters
        ----------
        i : int
        	the index of the label we wish to return

        Returns
        -------
        str
        	the indice-th label

        Raises
        ------
        gum.OutOfBound
        	If the variable does not contain the label

        """
        return _pyAgrum.IntegerVariable_label(self, index)

    def numerical(self, index: "gum::Idx") -> "double":
        r"""
        numerical(self, index) -> double

        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.IntegerVariable_numerical(self, index)

    def domain(self) -> "std::string const":
        r"""
        domain(self) -> std::string const

        Returns
        -------
        str
        	the domain of the variable

        """
        return _pyAgrum.IntegerVariable_domain(self)

    def stype(self) -> "std::string const":
        r"""stype(self) -> std::string const"""
        return _pyAgrum.IntegerVariable_stype(self)

    def integerDomain(self) -> "gum::Sequence< int > const &":
        r"""integerDomain(self) -> gum::Sequence< int > const &"""
        return _pyAgrum.IntegerVariable_integerDomain(self)

    def addValue(self, value: "int") -> "gum::IntegerVariable &":
        r"""addValue(self, value) -> IntegerVariable"""
        return _pyAgrum.IntegerVariable_addValue(self, value)

    def changeValue(self, old_value: "int", new_value: "int") -> "void":
        r"""changeValue(self, old_value, new_value)"""
        return _pyAgrum.IntegerVariable_changeValue(self, old_value, new_value)

    def eraseValue(self, value: "int") -> "void":
        r"""eraseValue(self, value)"""
        return _pyAgrum.IntegerVariable_eraseValue(self, value)

    def eraseValues(self) -> "void":
        r"""eraseValues(self)"""
        return _pyAgrum.IntegerVariable_eraseValues(self)

# Register IntegerVariable in _pyAgrum:
_pyAgrum.IntegerVariable_swigregister(IntegerVariable)

class IDiscretizedVariable(DiscreteVariable):
    r"""Proxy of C++ gum::IDiscretizedVariable class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_IDiscretizedVariable

    def clone(self) -> "gum::IDiscretizedVariable *":
        r"""
        clone(self) -> IDiscretizedVariable

        Returns
        -------
        pyAgrum.DiscreteVariable
        	a copy of the DiscreteVariable

        """
        return _pyAgrum.IDiscretizedVariable_clone(self)

# Register IDiscretizedVariable in _pyAgrum:
_pyAgrum.IDiscretizedVariable_swigregister(IDiscretizedVariable)

class Edge(object):
    r"""

    pyAgrum.Edge is the representation of an arc between two nodes represented by int : the first and the second.

    Edge(aN1,aN2) -> Edge
        Parameters:
            * **aN1** (*int*) -- the nodeId of the first node
            * **aN2** (*int*) -- the nodeId of the secondnode

    Edge(src) -> Edge
        Parameters:
            * **src** (*yAgrum.Edge*) -- the Edge to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, aN1, aN2) -> Edge
        __init__(self, src) -> Edge
        """
        _pyAgrum.Edge_swiginit(self, _pyAgrum.new_Edge(*args))
    __swig_destroy__ = _pyAgrum.delete_Edge

    def other(self, id: "gum::NodeId") -> "gum::NodeId":
        r"""
        other(self, id) -> gum::NodeId

        Parameters
        ----------
        id : int
          the nodeId of one of the nodes of the Edge


        Returns
        ------
        int
          the nodeId of the other node

        """
        return _pyAgrum.Edge_other(self, id)

    def first(self) -> "gum::NodeId":
        r"""
        first(self) -> gum::NodeId

        Returns
        ------
        int
          the nodeId of the first node of the arc (the tail)

        """
        return _pyAgrum.Edge_first(self)

    def second(self) -> "gum::NodeId":
        r"""
        second(self) -> gum::NodeId

        Returns
        ------
        int
          the nodeId of the second node of the arc (the head)

        """
        return _pyAgrum.Edge_second(self)

    def __eq__(self, src: "Edge") -> "bool":
        r"""__eq__(self, src) -> bool"""
        return _pyAgrum.Edge___eq__(self, src)

    def __ne__(self, src: "Edge") -> "bool":
        r"""__ne__(self, src) -> bool"""
        return _pyAgrum.Edge___ne__(self, src)

# Register Edge in _pyAgrum:
_pyAgrum.Edge_swigregister(Edge)

class Arc(object):
    r"""

    pyAgrum.Arc is the representation of an arc between two nodes represented by int : the head and the tail.

    Arc(tail, head) -> Arc
        Parameters:
            * **tail** (*int*) -- the tail
            * **head** (*int*) -- the head

    Arc(src) -> Arc
        Parameters:
            * **src** (*Arc*) -- the gum.Arc to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, tail, head) -> Arc
        __init__(self, src) -> Arc
        """
        _pyAgrum.Arc_swiginit(self, _pyAgrum.new_Arc(*args))
    __swig_destroy__ = _pyAgrum.delete_Arc

    def tail(self) -> "gum::NodeId":
        r"""
        tail(self) -> gum::NodeId

        Returns
        -------
        int
          the id of the tail node

        """
        return _pyAgrum.Arc_tail(self)

    def head(self) -> "gum::NodeId":
        r"""
        head(self) -> gum::NodeId

        Returns
        ------
        int
          the id of the head node

        """
        return _pyAgrum.Arc_head(self)

    def other(self, id: "gum::NodeId") -> "gum::NodeId":
        r"""
        other(self, id) -> gum::NodeId

        Parameters
        ----------
        id : int
          the nodeId of the head or the tail


        Returns
        -------
        int
          the nodeId of the other node

        """
        return _pyAgrum.Arc_other(self, id)

    def first(self) -> "gum::NodeId":
        r"""
        first(self) -> gum::NodeId

        Returns
        -------
        int
          the nodeId of the first node of the arc (the tail)

        """
        return _pyAgrum.Arc_first(self)

    def second(self) -> "gum::NodeId":
        r"""
        second(self) -> gum::NodeId

        Returns
        -------
        int
          the nodeId of the second node of the arc (the head)

        """
        return _pyAgrum.Arc_second(self)

    def __eq__(self, src: "Arc") -> "bool":
        r"""__eq__(self, src) -> bool"""
        return _pyAgrum.Arc___eq__(self, src)

    def __ne__(self, src: "Arc") -> "bool":
        r"""__ne__(self, src) -> bool"""
        return _pyAgrum.Arc___ne__(self, src)

# Register Arc in _pyAgrum:
_pyAgrum.Arc_swigregister(Arc)

class UndiGraph(object):
    r"""

    UndiGraph represents an Undirected Graph.

    UndiGraph() -> UndiGraph
        default constructor

    UndiGraph(src) -> UndiGraph
        Parameters!
            * **src** (*UndiGraph*) -- the pyAgrum.UndiGraph to copy


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self, nodes_size=HashTableConst::default_size, nodes_resize_policy=True, edges_size=HashTableConst::default_size, edges_resize_policy=True) -> UndiGraph
        __init__(self, g) -> UndiGraph
        """
        _pyAgrum.UndiGraph_swiginit(self, _pyAgrum.new_UndiGraph(*args))
    __swig_destroy__ = _pyAgrum.delete_UndiGraph

    def __eq__(self, g: "UndiGraph") -> "bool":
        r"""__eq__(self, g) -> bool"""
        return _pyAgrum.UndiGraph___eq__(self, g)

    def __ne__(self, g: "UndiGraph") -> "bool":
        r"""__ne__(self, g) -> bool"""
        return _pyAgrum.UndiGraph___ne__(self, g)

    def eraseNode(self, id: "gum::NodeId") -> "void":
        r"""
        eraseNode(self, id)

        Erase the node and all the adjacent edges.

        Parameters
        ----------
        id : int
          the id of the node

        """
        return _pyAgrum.UndiGraph_eraseNode(self, id)

    def clear(self) -> "void":
        r"""
        clear(self)

        Remove all the nodes and edges from the graph.

        """
        return _pyAgrum.UndiGraph_clear(self)

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.UndiGraph_toDot(self)

    def hasUndirectedCycle(self) -> "bool":
        r"""
        hasUndirectedCycle(self) -> bool

        Checks whether the graph contains cycles.

        Returns
        -------
        bool
            True if the graph contains a cycle

        """
        return _pyAgrum.UndiGraph_hasUndirectedCycle(self)

    def partialUndiGraph(self, nodes: "gum::NodeSet") -> "gum::UndiGraph":
        r"""
        partialUndiGraph(self, nodes) -> UndiGraph

        Parameters
        ----------
        nodesSet : Set
            The set of nodes composing the partial graph

        Returns
        -------
        pyAgrum.UndiGraph
            The partial graph formed by the nodes given in parameter

        """
        return _pyAgrum.UndiGraph_partialUndiGraph(self, nodes)

    def nodes2ConnectedComponent(self) -> "gum::NodeProperty< gum::NodeId >":
        r"""nodes2ConnectedComponent(self) -> gum::NodeProperty< gum::NodeId >"""
        return _pyAgrum.UndiGraph_nodes2ConnectedComponent(self)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.UndiGraph___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.UndiGraph___str__(self)

    def nodes(self) -> "PyObject *":
        r"""
        nodes(self) -> PyObject *

        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.UndiGraph_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def addNodes(self, n: "gum::Size") -> "PyObject *":
        r"""
        addNodes(self, n) -> PyObject *

        Add n nodes.

        Parameters
        ----------
        n : int
          the number of nodes to add.

        Returns
        -------
        Set of int
          the new ids

        """
        return _pyAgrum.UndiGraph_addNodes(self, n)

    def edges(self) -> "PyObject *":
        r"""
        edges(self) -> PyObject *

        Returns
        -------
        List
          the list of the edges

        """
        return _pyAgrum.UndiGraph_edges(self)

    def neighbours(self, id: "gum::NodeId") -> "PyObject *":
        r"""
        neighbours(self, id) -> PyObject *

        Parameters
        ----------
        id : int
            the id of the checked node

        Returns
        -------
        Set
            The set of edges adjacent to the given node

        """
        return _pyAgrum.UndiGraph_neighbours(self, id)

    def addNode(self) -> "gum::NodeId":
        r"""
        addNode(self) -> gum::NodeId

        Returns
        -------
        int
          the new NodeId

        """
        return _pyAgrum.UndiGraph_addNode(self)

    def addNodeWithId(self, id: "gum::NodeId const") -> "void":
        r"""
        addNodeWithId(self, id)

        Add a node by choosing a new NodeId.

        Parameters
        ----------
        id : int
          The id of the new node

        Raises
        ------
        gum.DuplicateElement
          If the given id is already used

        """
        return _pyAgrum.UndiGraph_addNodeWithId(self, id)

    def existsNode(self, id: "gum::NodeId const") -> "bool":
        r"""
        existsNode(self, id) -> bool

        Check if a node with a certain id exists in the graph.

        Parameters
        ----------
        id : int
            the checked id

        Returns
        -------
        bool
            True if the node exists

        """
        return _pyAgrum.UndiGraph_existsNode(self, id)

    def size(self) -> "gum::Size":
        r"""
        size(self) -> gum::Size

        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.UndiGraph_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool

        Check if the graph is empty.

        Returns
        -------
        bool
            True if the graph is empty

        """
        return _pyAgrum.UndiGraph_empty(self)

    def addEdge(self, *args) -> "void":
        r"""
        addEdge(self, first, second)
        addEdge(self, n1, n2)

        Insert a new edge into the graph.

        Parameters
        ----------
        n1 : int
          the id of one node of the new inserted edge
        n2 : int
          the id of the other node of the new inserted edge

        Raises
        ------
        gum.InvalidNode
          If n1 or n2 does not belong to the graph nodes.

        """
        return _pyAgrum.UndiGraph_addEdge(self, *args)

    def eraseEdge(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "void":
        r"""
        eraseEdge(self, n1, n2)

        Erase the edge between n1 and n2.

        Parameters
        ----------
        n1 : int
          the id of the tail node
        n2 : int
          the id of the head node

        """
        return _pyAgrum.UndiGraph_eraseEdge(self, n1, n2)

    def existsEdge(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "bool":
        r"""
        existsEdge(self, n1, n2) -> bool

        Check if an edge exists bewteen n1 and n2.

        Parameters
        ----------
        n1 : int
          the id of one extremity of the edge
        n2 : int
          the id of the other extremity if tge edge

        Returns
        -------
        bool
            True if the arc exists

        """
        return _pyAgrum.UndiGraph_existsEdge(self, n1, n2)

    def sizeEdges(self) -> "gum::Size":
        r"""
        sizeEdges(self) -> gum::Size

        Returns
        -------
        int
            the number of edges in the graph

        """
        return _pyAgrum.UndiGraph_sizeEdges(self)

    def emptyEdges(self) -> "bool":
        r"""
        emptyEdges(self) -> bool

        Check if the graph doesn't contains edges.

        Returns
        -------
        bool
            True if the graph doesn't contains edges

        """
        return _pyAgrum.UndiGraph_emptyEdges(self)

    def eraseNeighbours(self, n: "gum::NodeId const") -> "void":
        r"""
        eraseNeighbours(self, n)

        Erase all the edges adjacent to a given node.

        Parameters
        ----------
        n : int
          the id of the node

        """
        return _pyAgrum.UndiGraph_eraseNeighbours(self, n)

# Register UndiGraph in _pyAgrum:
_pyAgrum.UndiGraph_swigregister(UndiGraph)

class DiGraph(object):
    r"""

    DiGraph represents a Directed Graph.

    DiGraph() -> DiGraph
        default constructor

    DiGraph(src) -> DiGraph
        Parameters:
            * **src** (*pyAgrum.DiGraph*) -- the digraph to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self, nodes_size=HashTableConst::default_size, nodes_resize_policy=True, arcs_size=HashTableConst::default_size, arcs_resize_policy=True) -> DiGraph
        __init__(self, g) -> DiGraph
        """
        _pyAgrum.DiGraph_swiginit(self, _pyAgrum.new_DiGraph(*args))
    __swig_destroy__ = _pyAgrum.delete_DiGraph

    def __eq__(self, g: "DiGraph") -> "bool":
        r"""__eq__(self, g) -> bool"""
        return _pyAgrum.DiGraph___eq__(self, g)

    def __ne__(self, g: "DiGraph") -> "bool":
        r"""__ne__(self, g) -> bool"""
        return _pyAgrum.DiGraph___ne__(self, g)

    def eraseNode(self, id: "gum::NodeId const") -> "void":
        r"""
        eraseNode(self, id)

        Erase the node and all the related arcs.

        Parameters
        ----------
        id : int
        	the id of the node

        """
        return _pyAgrum.DiGraph_eraseNode(self, id)

    def clear(self) -> "void":
        r"""
        clear(self)

        Remove all the nodes and arcs from the graph.

        """
        return _pyAgrum.DiGraph_clear(self)

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format 

        """
        return _pyAgrum.DiGraph_toDot(self)

    def topologicalOrder(self, clear: "bool"=True) -> "gum::Sequence< gum::NodeId > const &":
        r"""
        topologicalOrder(self, clear=True) -> gum::Sequence< gum::NodeId > const

        Returns
        -------
        List
            the list of the nodes Ids in a topological order

        Raises
        ------
        gum.InvalidDirectedCycle
          If this graph contains cycles

        """
        return _pyAgrum.DiGraph_topologicalOrder(self, clear)

    def hasDirectedPath(self, _from: "gum::NodeId const", to: "gum::NodeId const") -> "bool":
        r"""
        hasDirectedPath(self, _from, to) -> bool

        Check if a directedpath exists bewteen from and to.

        Parameters
        ----------
        from : int
        	the id of the first node of the (possible) path
        to : int
        	the id of the last node of the (possible) path

        Returns
        -------
        bool
            True if the directed path exists

        """
        return _pyAgrum.DiGraph_hasDirectedPath(self, _from, to)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.DiGraph___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.DiGraph___str__(self)

    def nodes(self) -> "PyObject *":
        r"""
        nodes(self) -> PyObject *

        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.DiGraph_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def addNodes(self, n: "gum::Size") -> "PyObject *":
        r"""
        addNodes(self, n) -> PyObject *

        Add n nodes.

        Parameters
        ----------
        n : int
          the number of nodes to add.

        Returns
        -------
        Set of int
          the new ids

        """
        return _pyAgrum.DiGraph_addNodes(self, n)

    def arcs(self) -> "PyObject *":
        r"""
        arcs(self) -> PyObject *

        Returns
        -------
        List
        	the list of the arcs

        """
        return _pyAgrum.DiGraph_arcs(self)

    def parents(self, id: "gum::NodeId") -> "PyObject *":
        r"""
        parents(self, id) -> PyObject *

        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.DiGraph_parents(self, id)

    def children(self, id: "gum::NodeId") -> "PyObject *":
        r"""
        children(self, id) -> PyObject *

        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.DiGraph_children(self, id)

    def addNode(self) -> "gum::NodeId":
        r"""
        addNode(self) -> gum::NodeId

        Returns
        -------
        int
          the new NodeId

        """
        return _pyAgrum.DiGraph_addNode(self)

    def addNodeWithId(self, id: "gum::NodeId const") -> "void":
        r"""
        addNodeWithId(self, id)

        Add a node by choosing a new NodeId.

        Parameters
        ----------
        id : int
          The id of the new node

        Raises
        ------
        gum.DuplicateElement
          If the given id is already used

        """
        return _pyAgrum.DiGraph_addNodeWithId(self, id)

    def existsNode(self, id: "gum::NodeId const") -> "bool":
        r"""
        existsNode(self, id) -> bool

        Check if a node with a certain id exists in the graph.

        Parameters
        ----------
        id : int
            the checked id

        Returns
        -------
        bool
            True if the node exists

        """
        return _pyAgrum.DiGraph_existsNode(self, id)

    def size(self) -> "gum::Size":
        r"""
        size(self) -> gum::Size

        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.DiGraph_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool

        Check if the graph is empty.

        Returns
        -------
        bool
            True if the graph is empty

        """
        return _pyAgrum.DiGraph_empty(self)

    def addArc(self, *args) -> "void":
        r"""
        addArc(self, tail, head)
        addArc(self, n1, n2)

        Add an arc from tail to head.

        Parameters
        ----------
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        Raises
        ------
        gum.InvalidNode
          If head or tail does not belong to the graph nodes.

        """
        return _pyAgrum.DiGraph_addArc(self, *args)

    def eraseArc(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "void":
        r"""
        eraseArc(self, n1, n2)

        Erase the arc between n1 and n2.

        Parameters
        ----------
        n1 : int
        	the id of the tail node
        n2 : int
        	the id of the head node

        """
        return _pyAgrum.DiGraph_eraseArc(self, n1, n2)

    def existsArc(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "bool":
        r"""
        existsArc(self, n1, n2) -> bool

        Check if an arc exists bewteen n1 and n2.

        Parameters
        ----------
        n1 : int
        	the id of the tail node
        n2 : int
        	the id of the head node

        Returns
        -------
        bool
            True if the arc exists

        """
        return _pyAgrum.DiGraph_existsArc(self, n1, n2)

    def eraseParents(self, n: "gum::NodeId const") -> "void":
        r"""
        eraseParents(self, n)

        Erase the arcs coming to the node.

        Parameters
        ----------
        n : int
        	the id of the child node

        """
        return _pyAgrum.DiGraph_eraseParents(self, n)

    def eraseChildren(self, n: "gum::NodeId const") -> "void":
        r"""
        eraseChildren(self, n)

        Erase the arcs heading through the node's children.

        Parameters
        ----------
        n : int
        	the id of the parent node

        """
        return _pyAgrum.DiGraph_eraseChildren(self, n)

    def sizeArcs(self) -> "gum::Size":
        r"""
        sizeArcs(self) -> gum::Size

        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.DiGraph_sizeArcs(self)

    def emptyArcs(self) -> "bool":
        r"""
        emptyArcs(self) -> bool

        Check if the graph doesn't contains arcs.

        Returns
        -------
        bool
            True if the graph doesn't contains arcs

        """
        return _pyAgrum.DiGraph_emptyArcs(self)

# Register DiGraph in _pyAgrum:
_pyAgrum.DiGraph_swigregister(DiGraph)

class DAG(DiGraph):
    r"""

    DAG represents a Directed Acyclic Graph.

    DAG() -> DAG
        default constructor

    DAG(src) -> DAG
        Parameters:
            * **src** (*DAG*) -- the DAG to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, nodes_size=HashTableConst::default_size, nodes_resize_policy=True, arcs_size=HashTableConst::default_size, arcs_resize_policy=True) -> DAG
        __init__(self, g) -> DAG
        """
        _pyAgrum.DAG_swiginit(self, _pyAgrum.new_DAG(*args))
    __swig_destroy__ = _pyAgrum.delete_DAG

    def moralGraph(self) -> "gum::UndiGraph":
        r"""moralGraph(self) -> UndiGraph"""
        return _pyAgrum.DAG_moralGraph(self)

    def moralizedAncestralGraph(self, nodes: "gum::NodeSet const &") -> "gum::UndiGraph":
        r"""moralizedAncestralGraph(self, nodes) -> UndiGraph"""
        return _pyAgrum.DAG_moralizedAncestralGraph(self, nodes)

    def dSeparation(self, *args) -> "bool":
        r"""
        dSeparation(self, X, Y, Z) -> bool
        dSeparation(self, X, Y, Z) -> bool
        """
        return _pyAgrum.DAG_dSeparation(self, *args)

    def addArc(self, *args) -> "void":
        r"""
        addArc(self, tail, head)
        addArc(self, n1, n2)

        Add an arc from tail to head.

        Parameters
        ----------
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        Raises
        ------
        gum.InvalidDirectedCircle
        	If any (directed) cycle is created by this arc
        gum.InvalidNode
        	If head or tail does not belong to the graph nodes

        """
        return _pyAgrum.DAG_addArc(self, *args)

    def eraseArc(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "void":
        r"""eraseArc(self, n1, n2)"""
        return _pyAgrum.DAG_eraseArc(self, n1, n2)

    def existsArc(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "bool":
        r"""existsArc(self, n1, n2) -> bool"""
        return _pyAgrum.DAG_existsArc(self, n1, n2)

    def eraseParents(self, n: "gum::NodeId const") -> "void":
        r"""eraseParents(self, n)"""
        return _pyAgrum.DAG_eraseParents(self, n)

    def eraseChildren(self, n: "gum::NodeId const") -> "void":
        r"""eraseChildren(self, n)"""
        return _pyAgrum.DAG_eraseChildren(self, n)

    def sizeArcs(self) -> "gum::Size":
        r"""sizeArcs(self) -> gum::Size"""
        return _pyAgrum.DAG_sizeArcs(self)

    def emptyArcs(self) -> "bool":
        r"""emptyArcs(self) -> bool"""
        return _pyAgrum.DAG_emptyArcs(self)

# Register DAG in _pyAgrum:
_pyAgrum.DAG_swigregister(DAG)

class MixedGraph(UndiGraph, DiGraph):
    r"""

    MixedGraph represents a graph with both arcs and edges.

    MixedGraph() -> MixedGraph
        default constructor

    MixedGraph(src) -> MixedGraph
        Parameters:
            * **src** (*pyAgrum.MixedGraph*) --the MixedGraph to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self, nodes_size=HashTableConst::default_size, nodes_resize_policy=True, arcs_size=HashTableConst::default_size, arcs_resize_policy=True, edges_size=HashTableConst::default_size, edges_resize_policy=True) -> MixedGraph
        __init__(self, g) -> MixedGraph
        __init__(self, g) -> MixedGraph
        __init__(self, g) -> MixedGraph
        """
        _pyAgrum.MixedGraph_swiginit(self, _pyAgrum.new_MixedGraph(*args))
    __swig_destroy__ = _pyAgrum.delete_MixedGraph

    def __eq__(self, g: "MixedGraph") -> "bool":
        r"""__eq__(self, g) -> bool"""
        return _pyAgrum.MixedGraph___eq__(self, g)

    def __ne__(self, g: "MixedGraph") -> "bool":
        r"""__ne__(self, g) -> bool"""
        return _pyAgrum.MixedGraph___ne__(self, g)

    def eraseNode(self, id: "gum::NodeId const") -> "void":
        r"""
        eraseNode(self, id)

        Erase the node and all the related arcs and edges.

        Parameters
        ----------
        id : int
        	the id of the node

        """
        return _pyAgrum.MixedGraph_eraseNode(self, id)

    def clear(self) -> "void":
        r"""
        clear(self)

        Remove all the nodes and edges from the graph.

        """
        return _pyAgrum.MixedGraph_clear(self)

    def mixedOrientedPath(self, node1: "gum::NodeId", node2: "gum::NodeId") -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > >":
        r"""
        mixedOrientedPath(self, node1, node2) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > >

        Parameters
        ----------
        node1 : int
        	the id form which the path begins
        node2 : int
        	the id to witch the path ends

        Returns
        -------
        List
        	 a path from node1 to node2, using edges and/or arcs (following the direction of the arcs). If no path is found, the returned list is empty.

        """
        return _pyAgrum.MixedGraph_mixedOrientedPath(self, node1, node2)

    def mixedUnorientedPath(self, node1: "gum::NodeId", node2: "gum::NodeId") -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > >":
        r"""
        mixedUnorientedPath(self, node1, node2) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > >

        Parameters
        ----------
        node1 : int
        	the id from which the path begins
        node2 : int
        	the id to which the path ends

        Returns
        -------
        List
        	 a path from node1 to node2, using edges and/or arcs (not necessarily following the direction of the arcs). If no path is found, the list is empty.


        """
        return _pyAgrum.MixedGraph_mixedUnorientedPath(self, node1, node2)

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.MixedGraph_toDot(self)

    def adjacents(self, id: "gum::NodeId const") -> "gum::NodeSet":
        r"""adjacents(self, id) -> gum::NodeSet"""
        return _pyAgrum.MixedGraph_adjacents(self, id)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.MixedGraph___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.MixedGraph___str__(self)

    def addNodes(self, n: "gum::Size") -> "PyObject *":
        r"""
        addNodes(self, n) -> PyObject *

        Add n nodes.

        Parameters
        ----------
        n : int
          the number of nodes to add.

        Returns
        -------
        Set of int
          the new ids

        """
        return _pyAgrum.MixedGraph_addNodes(self, n)

    def addNode(self) -> "gum::NodeId":
        r"""
        addNode(self) -> gum::NodeId

        Returns
        -------
        int
          the new NodeId

        """
        return _pyAgrum.MixedGraph_addNode(self)

    def addNodeWithId(self, id: "gum::NodeId const") -> "void":
        r"""
        addNodeWithId(self, id)

        Add a node by choosing a new NodeId.

        Parameters
        ----------
        id : int
          The id of the new node

        Raises
        ------
        gum.DuplicateElement
          If the given id is already used

        """
        return _pyAgrum.MixedGraph_addNodeWithId(self, id)

    def existsNode(self, id: "gum::NodeId const") -> "bool":
        r"""
        existsNode(self, id) -> bool

        Check if a node with a certain id exists in the graph.

        Parameters
        ----------
        id : int
            the checked id

        Returns
        -------
        bool
            True if the node exists

        """
        return _pyAgrum.MixedGraph_existsNode(self, id)

    def size(self) -> "gum::Size":
        r"""
        size(self) -> gum::Size

        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.MixedGraph_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool

        Check if the graph is empty.

        Returns
        -------
        bool
            True if the graph is empty

        """
        return _pyAgrum.MixedGraph_empty(self)

    def addEdge(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "void":
        r"""
        addEdge(self, n1, n2)

        Insert a new edge into the graph.

        Parameters
        ----------
        n1 : int
          the id of one node of the new inserted edge
        n2 : int
          the id of the other node of the new inserted edge

        Raises
        ------
        gum.InvalidNode
          If n1 or n2 does not belong to the graph nodes.

        """
        return _pyAgrum.MixedGraph_addEdge(self, n1, n2)

    def eraseEdge(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "void":
        r"""
        eraseEdge(self, n1, n2)

        Erase the edge between n1 and n2.

        Parameters
        ----------
        n1 : int
          the id of the tail node
        n2 : int
          the id of the head node

        """
        return _pyAgrum.MixedGraph_eraseEdge(self, n1, n2)

    def existsEdge(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "bool":
        r"""
        existsEdge(self, n1, n2) -> bool

        Check if an edge exists bewteen n1 and n2.

        Parameters
        ----------
        n1 : int
          the id of one extremity of the edge
        n2 : int
          the id of the other extremity if tge edge

        Returns
        -------
        bool
            True if the arc exists

        """
        return _pyAgrum.MixedGraph_existsEdge(self, n1, n2)

    def sizeEdges(self) -> "gum::Size":
        r"""
        sizeEdges(self) -> gum::Size

        Returns
        -------
        int
            the number of edges in the graph

        """
        return _pyAgrum.MixedGraph_sizeEdges(self)

    def emptyEdges(self) -> "bool":
        r"""
        emptyEdges(self) -> bool

        Check if the graph doesn't contains edges.

        Returns
        -------
        bool
            True if the graph doesn't contains edges

        """
        return _pyAgrum.MixedGraph_emptyEdges(self)

    def eraseNeighbours(self, n: "gum::NodeId const") -> "void":
        r"""
        eraseNeighbours(self, n)

        Erase all the edges adjacent to a given node.

        Parameters
        ----------
        n : int
          the id of the node

        """
        return _pyAgrum.MixedGraph_eraseNeighbours(self, n)

    def addArc(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "void":
        r"""
        addArc(self, n1, n2)

        Add an arc from tail to head.

        Parameters
        ----------
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        Raises
        ------
        gum.InvalidNode
          If head or tail does not belong to the graph nodes.

        """
        return _pyAgrum.MixedGraph_addArc(self, n1, n2)

    def eraseArc(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "void":
        r"""
        eraseArc(self, n1, n2)

        Erase the arc between n1 and n2.

        Parameters
        ----------
        n1 : int
        	the id of the tail node
        n2 : int
        	the id of the head node

        """
        return _pyAgrum.MixedGraph_eraseArc(self, n1, n2)

    def existsArc(self, n1: "gum::NodeId const", n2: "gum::NodeId const") -> "bool":
        r"""
        existsArc(self, n1, n2) -> bool

        Check if an arc exists bewteen n1 and n2.

        Parameters
        ----------
        n1 : int
        	the id of the tail node
        n2 : int
        	the id of the head node

        Returns
        -------
        bool
            True if the arc exists

        """
        return _pyAgrum.MixedGraph_existsArc(self, n1, n2)

    def eraseParents(self, n: "gum::NodeId const") -> "void":
        r"""
        eraseParents(self, n)

        Erase the arcs coming to the node.

        Parameters
        ----------
        n : int
        	the id of the child node

        """
        return _pyAgrum.MixedGraph_eraseParents(self, n)

    def eraseChildren(self, n: "gum::NodeId const") -> "void":
        r"""
        eraseChildren(self, n)

        Erase the arcs heading through the node's children.

        Parameters
        ----------
        n : int
        	the id of the parent node

        """
        return _pyAgrum.MixedGraph_eraseChildren(self, n)

    def sizeArcs(self) -> "gum::Size":
        r"""
        sizeArcs(self) -> gum::Size

        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.MixedGraph_sizeArcs(self)

    def emptyArcs(self) -> "bool":
        r"""
        emptyArcs(self) -> bool

        Check if the graph doesn't contains arcs.

        Returns
        -------
        bool
            True if the graph doesn't contains arcs

        """
        return _pyAgrum.MixedGraph_emptyArcs(self)

# Register MixedGraph in _pyAgrum:
_pyAgrum.MixedGraph_swigregister(MixedGraph)

class CliqueGraph(UndiGraph):
    r"""

    CliqueGraph represents a Clique Graph.

    CliqueGraph() -> CliqueGraph
        default constructor

    CliqueGraph(src) -> CliqueGraph
        Parameter
            * **src** (*pyAgrum.CliqueGraph*) -- the CliqueGraph to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, nodes_size=HashTableConst::default_size, nodes_resize_policy=True, edges_size=HashTableConst::default_size, edges_resize_policy=True) -> CliqueGraph
        __init__(self, _from) -> CliqueGraph
        """
        _pyAgrum.CliqueGraph_swiginit(self, _pyAgrum.new_CliqueGraph(*args))
    __swig_destroy__ = _pyAgrum.delete_CliqueGraph

    def addEdge(self, first: "gum::NodeId const", second: "gum::NodeId const") -> "void":
        r"""
        addEdge(self, first, second)

        Insert a new edge into the graph.

        Parameters
        ----------
        n1 : int
          the id of one node of the new inserted edge
        n2 : int
          the id of the other node of the new inserted edge

        Raises
        ------
        gum.InvalidNode
          If n1 or n2 does not belong to the graph nodes.

        """
        return _pyAgrum.CliqueGraph_addEdge(self, first, second)

    def eraseEdge(self, edge: "Edge") -> "void":
        r"""
        eraseEdge(self, edge)

        Erase the edge between n1 and n2.

        Parameters
        ----------
        n1 : int
          the id of the tail node
        n2 : int
          the id of the head node

        """
        return _pyAgrum.CliqueGraph_eraseEdge(self, edge)

    def clearEdges(self) -> "void":
        r"""
        clearEdges(self)

        Remove all edges and their separators 

        """
        return _pyAgrum.CliqueGraph_clearEdges(self)

    def addNode(self, *args) -> "void":
        r"""
        addNode(self, clique) -> gum::NodeId
        addNode(self) -> gum::NodeId
        addNode(self, id, clique)
        addNode(self, id)

        Returns
        -------
        int
          the new NodeId

        """
        return _pyAgrum.CliqueGraph_addNode(self, *args)

    def eraseNode(self, node: "gum::NodeId const") -> "void":
        r"""
        eraseNode(self, node)

        Erase the node and all the adjacent edges.

        Parameters
        ----------
        id : int
          the id of the node

        """
        return _pyAgrum.CliqueGraph_eraseNode(self, node)

    def clear(self) -> "void":
        r"""
        clear(self)

        Remove all the nodes and edges from the graph.

        """
        return _pyAgrum.CliqueGraph_clear(self)

    def container(self, idNode: "gum::NodeId const") -> "gum::NodeId":
        r"""
        container(self, idNode) -> gum::NodeId

        Parameters
        ----------
        idNode : int
          the id of the node

        Returns
        -------
        int
          the id of a clique containing the node

        Raises
        ------
        gum.NotFound
          If no clique contains idNode  

        """
        return _pyAgrum.CliqueGraph_container(self, idNode)

    def setClique(self, idClique: "gum::NodeId const", new_clique: "gum::NodeSet const &") -> "void":
        r"""
        setClique(self, idClique, new_clique)

        changes the set of nodes included into a given clique

        Parameters
        ----------
        idClique : int
          the id of the clique
        new_clique : Set
          the new set of nodes to be included in the clique

        Raises
        ------
        gum.NotFound
          If idClique is not a clique of the graph

        """
        return _pyAgrum.CliqueGraph_setClique(self, idClique, new_clique)

    def addToClique(self, clique_id: "gum::NodeId const", node_id: "gum::NodeId const") -> "void":
        r"""
        addToClique(self, clique_id, node_id)

        Change the set of nodes included into a given clique and returns the new set 

        Parameters
        ----------
        clique_id : int
          the id of the clique
        node_id : int
          the id of the node

        Raises
        ------
        gum.NotFound
          If clique_id does not exist
        gum.DuplicateElement
          If clique_id set already contains the ndoe

        """
        return _pyAgrum.CliqueGraph_addToClique(self, clique_id, node_id)

    def eraseFromClique(self, clique_id: "gum::NodeId const", node_id: "gum::NodeId const") -> "void":
        r"""
        eraseFromClique(self, clique_id, node_id)

        Remove a node from a clique

        Parameters
        ----------
        clique_id : int
          the id of the clique
        node_id : int
          the id of the node

        Raises
        ------
        gum.NotFound
          If clique_id does not exist

        """
        return _pyAgrum.CliqueGraph_eraseFromClique(self, clique_id, node_id)

    def containerPath(self, node1: "gum::NodeId const", node2: "gum::NodeId const") -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > >":
        r"""
        containerPath(self, node1, node2) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > >

        Parameters
        ----------
        node1 : int
          the id of one node
        node2 : int
          the id of the other node

        Returns
        -------
        List
          a path from a clique containing node1 to a clique containing node2

        Raises
        ------
        gum.NotFound 
          If such path cannot be found

        """
        return _pyAgrum.CliqueGraph_containerPath(self, node1, node2)

    def hasRunningIntersection(self) -> "bool":
        r"""
        hasRunningIntersection(self) -> bool

        Returns
        -------
        bool
          True if the running intersection property holds 

        """
        return _pyAgrum.CliqueGraph_hasRunningIntersection(self)

    def isJoinTree(self) -> "bool":
        r"""
        isJoinTree(self) -> bool

        Returns
        -------
        bool
          True if the graph is a join tree 

        """
        return _pyAgrum.CliqueGraph_isJoinTree(self)

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.CliqueGraph_toDot(self)

    def __ne__(self, _from: "CliqueGraph") -> "bool":
        r"""__ne__(self, _from) -> bool"""
        return _pyAgrum.CliqueGraph___ne__(self, _from)

    def __eq__(self, _from: "CliqueGraph") -> "bool":
        r"""__eq__(self, _from) -> bool"""
        return _pyAgrum.CliqueGraph___eq__(self, _from)

    def clique(self, clique: "gum::NodeId const") -> "PyObject *":
        r"""
        clique(self, clique) -> PyObject *

        Parameters
        ----------
        idClique : int
          the id of the clique

        Returns
        -------
        Set
          The set of nodes included in the clique

        Raises
        ------
        gum.NotFound
          If the clique does not belong to the clique graph

        """
        return _pyAgrum.CliqueGraph_clique(self, clique)

    def separator(self, cliq1: "gum::NodeId const", cliq2: "gum::NodeId const") -> "PyObject *":
        r"""
        separator(self, cliq1, cliq2) -> PyObject *

        Parameters
        ----------
        edge : pyAgrum.Edge
          the edge to be checked
        clique1 : int 
          one extremity of the edge
        clique : int 
          the other extremity of the edge

        Returns
        -------
        Set
          the separator included in a given edge

        Raises
        ------
        gum.NotFound
          If the edge does not belong to the clique graph

        """
        return _pyAgrum.CliqueGraph_separator(self, cliq1, cliq2)

    def toDotWithNames(self,bn):
        """
        Parameters
        ----------
        bn : pyAgrum.BayesNet
        a Bayesian network

        Returns
        -------
        str
          a friendly display of the graph in DOT format where ids have been changed according to their correspondance in the BN
        """
        def nameFromId(m):
          return " ".join([bn.variable(int(n)).name()
                           for n in m.group().split("-")])
        import re
        m = re.compile('(?<=label=\")\d+[\-\d+]*')
        return m.sub(nameFromId,self.toDot())


# Register CliqueGraph in _pyAgrum:
_pyAgrum.CliqueGraph_swigregister(CliqueGraph)

class Instantiation(object):
    r"""

    Class for assigning/browsing values to tuples of discrete variables.

    Instantiation is designed to assign values to tuples of variables and to efficiently loop over values of subsets of variables.

    Instantiation() -> Instantiation
        default constructor

    Instantiation(aI) -> Instantiation
        Parameters:
          * **aI** (*pyAgrum.Instantiation*) -- the Instantiation we copy

    Returns
    -------
    pyAgrum.Instantiation
    	An empty tuple or a copy of the one in parameters

    Instantiation is subscriptable therefore values can be easily accessed/modified.

    Examples
    --------
    >>> ## Access the value of A in an instantiation aI
    >>> valueOfA = aI['A']
    >>> ## Modify the value
    >>> aI['A'] = newValueOfA

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self) -> Instantiation
        __init__(self, aI, notifyMaster=True) -> Instantiation
        __init__(self, aMD) -> Instantiation
        __init__(self, aMD) -> Instantiation
        __init__(self, aMD) -> Instantiation
        __init__(self, aMD) -> Instantiation
        """
        _pyAgrum.Instantiation_swiginit(self, _pyAgrum.new_Instantiation(*args))
    __swig_destroy__ = _pyAgrum.delete_Instantiation

    def nbrDim(self) -> "gum::Idx":
        r"""
        nbrDim(self) -> gum::Idx

        Returns
        -------
        int
            The number of variables in the Instantiation.

        """
        return _pyAgrum.Instantiation_nbrDim(self)

    def add(self, v: "DiscreteVariable") -> "void":
        r"""
        add(self, v)

        Adds a new variable in the Instantiation.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The new variable added to the Instantiation

        Raises
        ------
        DuplicateElement
          If the variable is already in this Instantiation


        """
        val = _pyAgrum.Instantiation_add(self, v)

        return self


        return val


    def erase(self, *args) -> "void":
        r"""
        erase(self, v)
        erase(self, name)

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The variable to be removed from this Instantiation.

        Raises
        ------
        NotFound
          If v does not belong to this Instantiation.

        """
        return _pyAgrum.Instantiation_erase(self, *args)

    def clear(self) -> "void":
        r"""
        clear(self)

        Erase all variables from an Instantiation.

        """
        return _pyAgrum.Instantiation_clear(self)

    def domainSize(self) -> "gum::Size":
        r"""
        domainSize(self) -> gum::Size

        Returns
        -------
        int
            The product of the variable's domain size in the Instantiation.

        """
        return _pyAgrum.Instantiation_domainSize(self)

    def pos(self, v: "DiscreteVariable") -> "gum::Idx":
        r"""
        pos(self, v) -> gum::Idx

        Returns
        -------
        int
           the position of the variable v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            the variable for which its position is return.

        Raises
        ------
        NotFound
          If v does not belong to the instantiation.

        """
        return _pyAgrum.Instantiation_pos(self, v)

    def val(self, *args) -> "gum::Idx":
        r"""
        val(self, i) -> gum::Idx
        val(self, var) -> gum::Idx
        val(self, name) -> gum::Idx

        Parameters
        ----------
        i : int
        	The index of the variable.
        var : pyAgrum.DiscreteVariable
        	The variable the value of which we wish to know

        Returns
        -------
        int
        	the current value of the variable.

        Raises
        ------
        NotFound
          If the element cannot be found.

        """
        return _pyAgrum.Instantiation_val(self, *args)

    def variable(self, *args) -> "gum::DiscreteVariable const &":
        r"""
        variable(self, i) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable

        Parameters
        ----------
        i : int
          The index of the variable

        Returns
        -------
        pyAgrum.DiscreteVariable
          the variable at position i in the tuple.

        Raises
        ------
        NotFound
          If the element cannot be found.

        """
        return _pyAgrum.Instantiation_variable(self, *args)

    def chgVal(self, *args) -> "gum::Instantiation &":
        r"""
        chgVal(self, v, newval) -> Instantiation
        chgVal(self, v, newval) -> Instantiation
        chgVal(self, varPos, newval) -> Instantiation
        chgVal(self, var, newval) -> Instantiation
        chgVal(self, var, newval) -> Instantiation

        Assign newval to v (or to the variable at position varPos) in the Instantiation.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable or string
          The variable whose value is assigned (or its name)
        varPos : int
          The index of the variable whose value is assigned in the tuple of variables of the Instantiation
        newval : int or string
          The index of the value assigned (or its name)

        Returns
        -------
        pyAgrum.Instantiation
            The modified instantiation

        Raises
        ------
        NotFound
          If variable v does not belong to the instantiation.
        OutOfBound
          If newval is not a possible value for the variable.

        """
        return _pyAgrum.Instantiation_chgVal(self, *args)

    def setVals(self, i: "Instantiation") -> "gum::Instantiation &":
        r"""
        setVals(self, i) -> Instantiation

        Assign the values from i in the Instantiation.

        Parameters
        ----------
        i : pyAgrum.Instantiation
          An Instantiation in which the new values are searched

        Returns
        -------
        pyAgrum.Instantiation
          a reference to the instantiation

        """
        return _pyAgrum.Instantiation_setVals(self, i)

    def contains(self, *args) -> "bool":
        r"""
        contains(self, v) -> bool
        contains(self, name) -> bool
        contains(self, v) -> bool

        Indicates whether a given variable belongs to the Instantiation.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable for which the test is made.

        Returns
        -------
        bool :
            True if the variable is in the Instantiation.

        """
        return _pyAgrum.Instantiation_contains(self, *args)

    def variablesSequence(self) -> "gum::Sequence< gum::DiscreteVariable const * > const &":
        r"""
        variablesSequence(self) -> gum::Sequence< gum::DiscreteVariable const * > const &

        Returns
        -------
        List
            the sequence of DiscreteVariable of this instantiation.

        """
        return _pyAgrum.Instantiation_variablesSequence(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool

        Returns
        -------
        bool
            True if the instantiation is empty.

        """
        return _pyAgrum.Instantiation_empty(self)

    def inOverflow(self) -> "bool":
        r"""
        inOverflow(self) -> bool

        Returns
        -------
        bool
          True if the current value of the tuple is correct

        """
        return _pyAgrum.Instantiation_inOverflow(self)

    def unsetOverflow(self) -> "void":
        r"""
        unsetOverflow(self)

        Removes the flag overflow.

        """
        return _pyAgrum.Instantiation_unsetOverflow(self)

    def unsetEnd(self) -> "void":
        r"""
        unsetEnd(self)

        Alias for unsetOverflow().

        """
        return _pyAgrum.Instantiation_unsetEnd(self)

    def end(self) -> "bool":
        r"""
        end(self) -> bool

        Returns
        -------
        bool
            True if the Instantiation reached the end.

        """
        return _pyAgrum.Instantiation_end(self)

    def rend(self) -> "bool":
        r"""
        rend(self) -> bool

        Returns
        -------
        bool:
          True if the Instantiation reached the rend.

        """
        return _pyAgrum.Instantiation_rend(self)

    def inc(self) -> "void":
        r"""
        inc(self)

        Operator ++.

        """
        return _pyAgrum.Instantiation_inc(self)

    def dec(self) -> "void":
        r"""
        dec(self)

        Operator --.

        """
        return _pyAgrum.Instantiation_dec(self)

    def incIn(self, i: "Instantiation") -> "void":
        r"""
        incIn(self, i)

        Operator ++ for the variables in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
            The set of variables to increment in this Instantiation.

        """
        return _pyAgrum.Instantiation_incIn(self, i)

    def decIn(self, i: "Instantiation") -> "void":
        r"""
        decIn(self, i)

        Operator -- for the variables in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The set of variables to decrement in this Instantiation

        """
        return _pyAgrum.Instantiation_decIn(self, i)

    def incOut(self, i: "Instantiation") -> "void":
        r"""
        incOut(self, i)

        Operator ++ for the variables not in i.

        Parameters
        ----------
        i : Instantiation
            The set of variable to not increment in this Instantiation.

        """
        return _pyAgrum.Instantiation_incOut(self, i)

    def decOut(self, i: "Instantiation") -> "void":
        r"""
        decOut(self, i)

        Operator -- for the variables not in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The set of variables to not decrement in this Instantiation.

        """
        return _pyAgrum.Instantiation_decOut(self, i)

    def incNotVar(self, v: "DiscreteVariable") -> "void":
        r"""
        incNotVar(self, v)

        Operator ++ for vars which are not v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable not to increment in this Instantiation.

        """
        return _pyAgrum.Instantiation_incNotVar(self, v)

    def decNotVar(self, v: "DiscreteVariable") -> "void":
        r"""
        decNotVar(self, v)

        Operator -- for vars which are not v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The variable not to decrement in this Instantiation.

        """
        return _pyAgrum.Instantiation_decNotVar(self, v)

    def incVar(self, v: "DiscreteVariable") -> "void":
        r"""
        incVar(self, v)

        Operator ++ for variable v only.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable to increment in this Instantiation.

        Raises
        ------
        NotFound
          If variable v does not belong to the Instantiation.

        """
        return _pyAgrum.Instantiation_incVar(self, v)

    def decVar(self, v: "DiscreteVariable") -> "void":
        r"""
        decVar(self, v)

        Operator -- for variable v only.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
         The variable to decrement in this Instantiation.

        Raises
        ------
        NotFound
          If variable v does not belong to the Instantiation.

        """
        return _pyAgrum.Instantiation_decVar(self, v)

    def setFirst(self) -> "void":
        r"""
        setFirst(self)

        Assign the first values to the tuple of the Instantiation.

        """
        return _pyAgrum.Instantiation_setFirst(self)

    def setLast(self) -> "void":
        r"""
        setLast(self)

        Assign the last values in the Instantiation.

        """
        return _pyAgrum.Instantiation_setLast(self)

    def setFirstIn(self, i: "Instantiation") -> "void":
        r"""
        setFirstIn(self, i)

        Assign the first values in the Instantiation for the variables in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The variables to which their first value is assigned in this Instantiation.

        """
        return _pyAgrum.Instantiation_setFirstIn(self, i)

    def setLastIn(self, i: "Instantiation") -> "void":
        r"""
        setLastIn(self, i)

        Assign the last values in the Instantiation for the variables in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
            The variables to which their last value is assigned in this Instantiation.

        """
        return _pyAgrum.Instantiation_setLastIn(self, i)

    def setFirstOut(self, i: "Instantiation") -> "void":
        r"""
        setFirstOut(self, i)

        Assign the first values in the Instantiation for the variables not in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
            The variable that will not be set to their first value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setFirstOut(self, i)

    def setLastOut(self, i: "Instantiation") -> "void":
        r"""
        setLastOut(self, i)

        Assign the last values in the Instantiation for the variables not in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
            The variables that will not be set to their last value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setLastOut(self, i)

    def setFirstNotVar(self, v: "DiscreteVariable") -> "void":
        r"""
        setFirstNotVar(self, v)

        Assign the first values to variables different of v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The variable that will not be set to its first value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setFirstNotVar(self, v)

    def setLastNotVar(self, v: "DiscreteVariable") -> "void":
        r"""
        setLastNotVar(self, v)

        Assign the last values to variables different of v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable that will not be set to its last value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setLastNotVar(self, v)

    def setFirstVar(self, v: "DiscreteVariable") -> "void":
        r"""
        setFirstVar(self, v)

        Assign the first value in the Instantiation for var v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable that will be set to its first value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setFirstVar(self, v)

    def setLastVar(self, v: "DiscreteVariable") -> "void":
        r"""
        setLastVar(self, v)

        Assign the last value in the Instantiation for var v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The variable that will be set to its last value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setLastVar(self, v)

    def __eq__(self, other: "Instantiation") -> "bool":
        r"""__eq__(self, other) -> bool"""
        return _pyAgrum.Instantiation___eq__(self, other)

    def __iadd__(self, depl: "gum::Size") -> "gum::Instantiation &":
        r"""__iadd__(self, depl) -> Instantiation"""
        return _pyAgrum.Instantiation___iadd__(self, depl)

    def __isub__(self, depl: "gum::Size") -> "gum::Instantiation &":
        r"""__isub__(self, depl) -> Instantiation"""
        return _pyAgrum.Instantiation___isub__(self, depl)

    def hamming(self) -> "gum::Idx":
        r"""
        hamming(self) -> gum::Idx

        Returns
        -------
        int
          the hamming distance of this instantiation.

        """
        return _pyAgrum.Instantiation_hamming(self)

    def reorder(self, *args) -> "void":
        r"""
        reorder(self, v)
        reorder(self, i)

        Reorder vars of this instantiation giving the order in v (or i).

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The sequence of variables with which to reorder this Instantiation.
        v : list
            The new order of variables for this Instantiation.

        """
        return _pyAgrum.Instantiation_reorder(self, *args)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.Instantiation___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.Instantiation___str__(self)

    def setMutable(self) -> "void":
        r"""setMutable(self)"""
        return _pyAgrum.Instantiation_setMutable(self)

    def isMutable(self) -> "bool":
        r"""isMutable(self) -> bool"""
        return _pyAgrum.Instantiation_isMutable(self)

    def todict(self, withLabels: "bool"=False) -> "PyObject *":
        r"""
        todict(self, withLabels=False) -> PyObject

        Create a dict (variable_name:value) from an instantiation

        Parameters
        ----------
        withLabels : boolean
        	The value will be a label (string) if True. It will be a position (int) if False.

        Returns
        -------
        Dict
            The dictionary

        """
        return _pyAgrum.Instantiation_todict(self, withLabels)

    def fromdict(self, dict: "PyObject *") -> "void":
        r"""
        fromdict(self, dict)

        Change the values in an instantiation from a dict (variable_name:value) where value can be a position (int) or a label (string).

        If a variable_name does not occur in the instantiation, nothing is done.

        Warnings
        --------
            OutOfBounds raised if a value cannot be found.

        """
        return _pyAgrum.Instantiation_fromdict(self, dict)

    def __setitem__(self,key,item):
      self.chgVal(key,item)

    def __getitem__(self,key):
      return self.val(self.variable(key))

    def addVarsFromModel(self,model,names):
      r"""
      From a graphical model, add all the variable whose names are in the iterable

      Parameters
      ----------
      model : pyAgrum.GraphicalModel
      a (discrete) graphical model such as Bayesian network, Markov network, Influence Diagram, etc.

      names : iterable of strings
      a list/set/etc of names of variables (as string)

      Returns
      -------
      pyAgrum.Instantiation
      the current instantiation (self) in order to chain methods.
      """
      for name in names:
        self.add(model.variable(name))
      return self



# Register Instantiation in _pyAgrum:
_pyAgrum.Instantiation_swigregister(Instantiation)

GUM_DEFAULT_ITERATOR_NUMBER = _pyAgrum.GUM_DEFAULT_ITERATOR_NUMBER

class GraphicalModel(object):
    r"""Proxy of C++ gum::GraphicalModel class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_GraphicalModel

    def property(self, name: "std::string const &") -> "std::string const &":
        r"""property(self, name) -> std::string const &"""
        return _pyAgrum.GraphicalModel_property(self, name)

    def propertyWithDefault(self, name: "std::string const &", byDefault: "std::string const &") -> "std::string const &":
        r"""propertyWithDefault(self, name, byDefault) -> std::string const &"""
        return _pyAgrum.GraphicalModel_propertyWithDefault(self, name, byDefault)

    def setProperty(self, name: "std::string const &", value: "std::string const &") -> "void":
        r"""setProperty(self, name, value)"""
        return _pyAgrum.GraphicalModel_setProperty(self, name, value)

    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        r"""variableNodeMap(self) -> VariableNodeMap"""
        return _pyAgrum.GraphicalModel_variableNodeMap(self)

    def size(self) -> "gum::Size":
        r"""size(self) -> gum::Size"""
        return _pyAgrum.GraphicalModel_size(self)

    def empty(self) -> "bool":
        r"""empty(self) -> bool"""
        return _pyAgrum.GraphicalModel_empty(self)

    def exists(self, *args) -> "bool":
        r"""
        exists(self, node) -> bool
        exists(self, name) -> bool
        """
        return _pyAgrum.GraphicalModel_exists(self, *args)

    def names(self, *args) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        names(self, ids) -> Vector_string
        names(self, ids) -> Vector_string
        """
        return _pyAgrum.GraphicalModel_names(self, *args)

    def ids(self, names: "Vector_string") -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > >":
        r"""ids(self, names) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > >"""
        return _pyAgrum.GraphicalModel_ids(self, names)

    def nodeset(self, names: "Vector_string") -> "gum::NodeSet":
        r"""nodeset(self, names) -> gum::NodeSet"""
        return _pyAgrum.GraphicalModel_nodeset(self, names)

    def nodes(self) -> "gum::NodeGraphPart const &":
        r"""nodes(self) -> NodeGraphPart"""
        return _pyAgrum.GraphicalModel_nodes(self)

    def completeInstantiation(self) -> "gum::Instantiation":
        r"""completeInstantiation(self) -> Instantiation"""
        return _pyAgrum.GraphicalModel_completeInstantiation(self)

    def variable(self, id: "gum::NodeId") -> "gum::DiscreteVariable const &":
        r"""variable(self, id) -> DiscreteVariable"""
        return _pyAgrum.GraphicalModel_variable(self, id)

    def nodeId(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""nodeId(self, var) -> gum::NodeId"""
        return _pyAgrum.GraphicalModel_nodeId(self, var)

    def idFromName(self, name: "std::string const &") -> "gum::NodeId":
        r"""idFromName(self, name) -> gum::NodeId"""
        return _pyAgrum.GraphicalModel_idFromName(self, name)

    def variableFromName(self, name: "std::string const &") -> "gum::DiscreteVariable const &":
        r"""variableFromName(self, name) -> DiscreteVariable"""
        return _pyAgrum.GraphicalModel_variableFromName(self, name)

    def log10DomainSize(self) -> "double":
        r"""log10DomainSize(self) -> double"""
        return _pyAgrum.GraphicalModel_log10DomainSize(self)

    def isIndependent(self, *args) -> "bool":
        r"""
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, X, Y, Z) -> bool
        """
        return _pyAgrum.GraphicalModel_isIndependent(self, *args)

# Register GraphicalModel in _pyAgrum:
_pyAgrum.GraphicalModel_swigregister(GraphicalModel)
cvar = _pyAgrum.cvar
_list_end_safe_ = cvar._list_end_safe_
_list_end_ = cvar._list_end_

class DAGmodel(GraphicalModel):
    r"""

    Abstract class used by IBayesNet and InfluenceDiagram.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_DAGmodel

    def dag(self) -> "gum::DAG const &":
        r"""
        dag(self) -> DAG

        Returns
        -------
        pyAgrum.DAG
        	a constant reference to the dag of this BayesNet.

        """
        val = _pyAgrum.DAGmodel_dag(self)

        val = DAG(val) # copying the DAG


        return val


    def size(self) -> "gum::Size":
        r"""
        size(self) -> gum::Size

        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.DAGmodel_size(self)

    def sizeArcs(self) -> "gum::Size":
        r"""
        sizeArcs(self) -> gum::Size

        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.DAGmodel_sizeArcs(self)

    def nodes(self) -> "gum::NodeGraphPart const &":
        r"""
        nodes(self) -> NodeGraphPart

        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.DAGmodel_nodes(self)

    def exists(self, node: "gum::NodeId") -> "bool":
        r"""exists(self, node) -> bool"""
        return _pyAgrum.DAGmodel_exists(self, node)

    def arcs(self) -> "gum::ArcSet const &":
        r"""
        arcs(self) -> gum::ArcSet const &

        Returns
        -------
        list
        	The lisf of arcs in the graph

        """
        return _pyAgrum.DAGmodel_arcs(self)

    def existsArc(self, *args) -> "bool":
        r"""
        existsArc(self, tail, head) -> bool
        existsArc(self, nametail, namehead) -> bool
        """
        return _pyAgrum.DAGmodel_existsArc(self, *args)

    def parents(self, *args) -> "gum::NodeSet":
        r"""
        parents(self, id) -> gum::NodeSet const
        parents(self, name) -> gum::NodeSet const
        parents(self, ids) -> gum::NodeSet
        parents(self, names) -> gum::NodeSet
        """
        return _pyAgrum.DAGmodel_parents(self, *args)

    def family(self, *args) -> "gum::NodeSet":
        r"""
        family(self, id) -> gum::NodeSet
        family(self, name) -> gum::NodeSet
        """
        return _pyAgrum.DAGmodel_family(self, *args)

    def children(self, *args) -> "gum::NodeSet":
        r"""
        children(self, id) -> gum::NodeSet const
        children(self, name) -> gum::NodeSet const
        children(self, ids) -> gum::NodeSet
        children(self, names) -> gum::NodeSet
        """
        return _pyAgrum.DAGmodel_children(self, *args)

    def descendants(self, *args) -> "gum::NodeSet":
        r"""
        descendants(self, id) -> gum::NodeSet
        descendants(self, name) -> gum::NodeSet
        """
        return _pyAgrum.DAGmodel_descendants(self, *args)

    def ancestors(self, *args) -> "gum::NodeSet":
        r"""
        ancestors(self, id) -> gum::NodeSet
        ancestors(self, name) -> gum::NodeSet
        """
        return _pyAgrum.DAGmodel_ancestors(self, *args)

    def moralizedAncestralGraph(self, *args) -> "gum::UndiGraph":
        r"""
        moralizedAncestralGraph(self, nodes) -> UndiGraph
        moralizedAncestralGraph(self, nodenames) -> UndiGraph
        """
        return _pyAgrum.DAGmodel_moralizedAncestralGraph(self, *args)

    def isIndependent(self, *args) -> "bool":
        r"""
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, Xname, Yname, Znames) -> bool
        isIndependent(self, Xnames, Ynames, Znames) -> bool
        """
        return _pyAgrum.DAGmodel_isIndependent(self, *args)

    def moralGraph(self, clear: "bool"=True) -> "gum::UndiGraph const &":
        r"""
        moralGraph(self, clear=True) -> UndiGraph

        Returns the moral graph of the BayesNet, formed by adding edges between all pairs of nodes that have a common child, and then making all edges in the graph undirected.

        Returns
        -------
        pyAgrum.UndiGraph
        	The moral graph

        """
        return _pyAgrum.DAGmodel_moralGraph(self, clear)

    def topologicalOrder(self, clear: "bool"=True) -> "gum::Sequence< gum::NodeId > const &":
        r"""
        topologicalOrder(self, clear=True) -> gum::Sequence< gum::NodeId > const

        Returns
        -------
        List
            the list of the nodes Ids in a topological order

        Raises
        ------
        gum.InvalidDirectedCycle
        	If this graph contains cycles

        """
        return _pyAgrum.DAGmodel_topologicalOrder(self, clear)

    def hasSameStructure(self, other: "DAGmodel") -> "bool":
        r"""
        hasSameStructure(self, other) -> bool

        Parameters
        ----------
        pyAgrum.DAGmodel
        	a direct acyclic model

        Returns
        -------
        bool
            True if all the named node are the same and all the named arcs are the same

        """
        return _pyAgrum.DAGmodel_hasSameStructure(self, other)

# Register DAGmodel in _pyAgrum:
_pyAgrum.DAGmodel_swigregister(DAGmodel)

class UGmodel(GraphicalModel):
    r"""Proxy of C++ gum::UGmodel class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_UGmodel

    def graph(self) -> "gum::UndiGraph const &":
        r"""graph(self) -> UndiGraph"""
        return _pyAgrum.UGmodel_graph(self)

    def size(self) -> "gum::Size":
        r"""size(self) -> gum::Size"""
        return _pyAgrum.UGmodel_size(self)

    def sizeEdges(self) -> "gum::Size":
        r"""sizeEdges(self) -> gum::Size"""
        return _pyAgrum.UGmodel_sizeEdges(self)

    def nodes(self) -> "gum::NodeGraphPart const &":
        r"""nodes(self) -> NodeGraphPart"""
        return _pyAgrum.UGmodel_nodes(self)

    def exists(self, node: "gum::NodeId") -> "bool":
        r"""exists(self, node) -> bool"""
        return _pyAgrum.UGmodel_exists(self, node)

    def edges(self) -> "gum::EdgeSet const &":
        r"""edges(self) -> gum::EdgeSet const &"""
        return _pyAgrum.UGmodel_edges(self)

    def existsEdge(self, *args) -> "bool":
        r"""
        existsEdge(self, node1, node2) -> bool
        existsEdge(self, name1, name2) -> bool
        """
        return _pyAgrum.UGmodel_existsEdge(self, *args)

    def neighbours(self, *args) -> "gum::NodeSet const &":
        r"""
        neighbours(self, id) -> gum::NodeSet const
        neighbours(self, name) -> gum::NodeSet const &
        """
        return _pyAgrum.UGmodel_neighbours(self, *args)

    def isIndependent(self, *args) -> "bool":
        r"""
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, Xname, Yname, Znames) -> bool
        isIndependent(self, Xnames, Ynames, Znames) -> bool
        """
        return _pyAgrum.UGmodel_isIndependent(self, *args)

    def hasSameStructure(self, other: "UGmodel") -> "bool":
        r"""hasSameStructure(self, other) -> bool"""
        return _pyAgrum.UGmodel_hasSameStructure(self, other)

# Register UGmodel in _pyAgrum:
_pyAgrum.UGmodel_swigregister(UGmodel)

class EssentialGraph(object):
    r"""Proxy of C++ gum::EssentialGraph class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> EssentialGraph
        __init__(self, m) -> EssentialGraph
        __init__(self, m, mg) -> EssentialGraph
        __init__(self, g) -> EssentialGraph
        """
        _pyAgrum.EssentialGraph_swiginit(self, _pyAgrum.new_EssentialGraph(*args))
    __swig_destroy__ = _pyAgrum.delete_EssentialGraph

    def mixedGraph(self) -> "gum::MixedGraph":
        r"""
        mixedGraph(self) -> MixedGraph

        Returns
        -------
        pyAgrum.MixedGraph
        	the mixed graph

        """
        return _pyAgrum.EssentialGraph_mixedGraph(self)

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format 

        """
        return _pyAgrum.EssentialGraph_toDot(self)

    def sizeArcs(self) -> "gum::Size":
        r"""
        sizeArcs(self) -> gum::Size

        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.EssentialGraph_sizeArcs(self)

    def sizeEdges(self) -> "gum::Size":
        r"""
        sizeEdges(self) -> gum::Size

        Returns
        -------
        int
            the number of edges in the graph

        """
        return _pyAgrum.EssentialGraph_sizeEdges(self)

    def sizeNodes(self) -> "gum::Size":
        r"""
        sizeNodes(self) -> gum::Size

        Returns
        -------
        int
        	the number of nodes in the graph

        """
        return _pyAgrum.EssentialGraph_sizeNodes(self)

    def size(self) -> "gum::Size":
        r"""
        size(self) -> gum::Size

        Returns
        -------
        int
        	the number of nodes in the graph

        """
        return _pyAgrum.EssentialGraph_size(self)

    def skeleton(self) -> "gum::UndiGraph":
        r"""skeleton(self) -> UndiGraph"""
        return _pyAgrum.EssentialGraph_skeleton(self)

    def nodes(self) -> "PyObject *":
        r"""nodes(self) -> PyObject *"""
        return _pyAgrum.EssentialGraph_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def arcs(self) -> "PyObject *":
        r"""
        arcs(self) -> PyObject *

        Returns
        -------
        list
        	The lisf of arcs in the EssentialGraph

        """
        return _pyAgrum.EssentialGraph_arcs(self)

    def parents(self, id: "gum::NodeId") -> "PyObject *":
        r"""
        parents(self, id) -> PyObject *

        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.EssentialGraph_parents(self, id)

    def children(self, id: "gum::NodeId") -> "PyObject *":
        r"""
        children(self, id) -> PyObject *

        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.EssentialGraph_children(self, id)

    def edges(self) -> "PyObject *":
        r"""
        edges(self) -> PyObject *

        Returns
        -------
        List
          the list of the edges

        """
        return _pyAgrum.EssentialGraph_edges(self)

    def neighbours(self, id: "gum::NodeId") -> "PyObject *":
        r"""
        neighbours(self, id) -> PyObject *

        Parameters
        ----------
        id : int
            the id of the checked node

        Returns
        -------
        Set
            The set of edges adjacent to the given node 

        """
        return _pyAgrum.EssentialGraph_neighbours(self, id)

# Register EssentialGraph in _pyAgrum:
_pyAgrum.EssentialGraph_swigregister(EssentialGraph)

class MarkovBlanket(object):
    r"""Proxy of C++ gum::MarkovBlanket class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, m, n, level=1) -> MarkovBlanket
        __init__(self, m, name, level=1) -> MarkovBlanket
        """
        _pyAgrum.MarkovBlanket_swiginit(self, _pyAgrum.new_MarkovBlanket(*args))
    __swig_destroy__ = _pyAgrum.delete_MarkovBlanket

    def dag(self) -> "gum::DAG":
        r"""
        dag(self) -> DAG

        Returns
        -------
        pyAgrum.DAG
          a copy of the DAG

        """
        return _pyAgrum.MarkovBlanket_dag(self)

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format 

        """
        return _pyAgrum.MarkovBlanket_toDot(self)

    def sizeArcs(self) -> "gum::Size":
        r"""
        sizeArcs(self) -> gum::Size

        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.MarkovBlanket_sizeArcs(self)

    def sizeNodes(self) -> "gum::Size":
        r"""
        sizeNodes(self) -> gum::Size

        Returns
        -------
        int
        	the number of nodes in the graph

        """
        return _pyAgrum.MarkovBlanket_sizeNodes(self)

    def size(self) -> "gum::Size":
        r"""
        size(self) -> gum::Size

        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.MarkovBlanket_size(self)

    def hasSameStructure(self, other: "DAGmodel") -> "bool":
        r"""
        hasSameStructure(self, other) -> bool

        Parameters
        ----------
        pyAgrum.DAGmodel
        	a direct acyclic model

        Returns
        -------
        bool
            True if all the named node are the same and all the named arcs are the same 

        """
        return _pyAgrum.MarkovBlanket_hasSameStructure(self, other)

    def nodes(self) -> "PyObject *":
        r"""
        nodes(self) -> PyObject *

        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.MarkovBlanket_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def arcs(self) -> "PyObject *":
        r"""
        arcs(self) -> PyObject *

        Returns
        -------
        List
        	the list of the arcs

        """
        return _pyAgrum.MarkovBlanket_arcs(self)

    def parents(self, id: "gum::NodeId") -> "PyObject *":
        r"""
        parents(self, id) -> PyObject *

        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.MarkovBlanket_parents(self, id)

    def children(self, id: "gum::NodeId") -> "PyObject *":
        r"""
        children(self, id) -> PyObject *

        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.MarkovBlanket_children(self, id)

# Register MarkovBlanket in _pyAgrum:
_pyAgrum.MarkovBlanket_swigregister(MarkovBlanket)

class StructuralComparator(object):
    r"""Proxy of C++ gum::StructuralComparator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> StructuralComparator"""
        _pyAgrum.StructuralComparator_swiginit(self, _pyAgrum.new_StructuralComparator())
    __swig_destroy__ = _pyAgrum.delete_StructuralComparator

    def compare(self, *args) -> "void":
        r"""
        compare(self, ref, test)
        compare(self, ref, test)
        compare(self, ref, test)

        Use to compare the edges/arcs of two structure of the same type and same sizes (either DiGraph, UndiGraph or MixedGraph).

        Could be use to compare a BN and its learned version.

        Parameters
        ----------
        ref :
        	the structure of reference
        test :
        	the structure we want to test

        """
        return _pyAgrum.StructuralComparator_compare(self, *args)

    def precision_skeleton(self) -> "double":
        r"""
        precision_skeleton(self) -> double

        Rate of true postive over labelized edges.

        Returns
        -------
        double
        	the precision of the tested graph skeleton

        """
        return _pyAgrum.StructuralComparator_precision_skeleton(self)

    def recall_skeleton(self) -> "double":
        r"""
        recall_skeleton(self) -> double

        Rate of true postive over labelized edges.

        Returns
        -------
        double
        	the recall of the tested graph skeleton

        """
        return _pyAgrum.StructuralComparator_recall_skeleton(self)

    def f_score_skeleton(self) -> "double":
        r"""
        f_score_skeleton(self) -> double

        Harmonic mean between recall and precision.

        Returns
        -------
        double
        	the tarmonic mean of the tested graph skeleton

        """
        return _pyAgrum.StructuralComparator_f_score_skeleton(self)

    def precision(self) -> "double":
        r"""
        precision(self) -> double

        Rate of true postive over postively labelized arcs/edges.

        Returns
        -------
        double
        	the precision of the tested graph

        """
        return _pyAgrum.StructuralComparator_precision(self)

    def recall(self) -> "double":
        r"""
        recall(self) -> double

        Rate of true postive over labelized arcs/edges.

        Returns
        -------
        double
        	the recall of the tested graph

        """
        return _pyAgrum.StructuralComparator_recall(self)

    def f_score(self) -> "double":
        r"""
        f_score(self) -> double

        Harmonic mean between recall and precision.

        Returns
        -------
        double
        	the harmonic mean of the tested graph

        """
        return _pyAgrum.StructuralComparator_f_score(self)

# Register StructuralComparator in _pyAgrum:
_pyAgrum.StructuralComparator_swigregister(StructuralComparator)

class ApproximationScheme(object):
    r"""

    Used to parametrize stopping criteria in approximate inference or learning algorithm.

    ApproximationScheme(verbosity=False) -> ApproximationScheme
        Parameters:
          * **verbosity** (*bool*) -- to keep (or not) tracks of the learning process (history of epsilons)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, verbosity: "bool"=False):
        r"""__init__(self, verbosity=False) -> ApproximationScheme"""
        _pyAgrum.ApproximationScheme_swiginit(self, _pyAgrum.new_ApproximationScheme(verbosity))
    __swig_destroy__ = _pyAgrum.delete_ApproximationScheme

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.ApproximationScheme_setEpsilon(self, eps)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.ApproximationScheme_epsilon(self)

    def disableEpsilon(self) -> "void":
        r"""
        disableEpsilon(self)

        Disable epsilon as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_disableEpsilon(self)

    def enableEpsilon(self) -> "void":
        r"""
        enableEpsilon(self)

        Enable epsilon as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_enableEpsilon(self)

    def isEnabledEpsilon(self) -> "bool":
        r"""
        isEnabledEpsilon(self) -> bool

        Returns
        -------
        bool
          True if epsilon is used as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_isEnabledEpsilon(self)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.ApproximationScheme_setMinEpsilonRate(self, rate)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.ApproximationScheme_minEpsilonRate(self)

    def disableMinEpsilonRate(self) -> "void":
        r"""
        disableMinEpsilonRate(self)

        Disable a min epsilon rate as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_disableMinEpsilonRate(self)

    def enableMinEpsilonRate(self) -> "void":
        r"""
        enableMinEpsilonRate(self)

        Enable a min epsilon rate as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_enableMinEpsilonRate(self)

    def isEnabledMinEpsilonRate(self) -> "bool":
        r"""
        isEnabledMinEpsilonRate(self) -> bool

        Returns
        -------
        bool
          True if epsilon rate is used as a stopping criterion

        """
        return _pyAgrum.ApproximationScheme_isEnabledMinEpsilonRate(self)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.ApproximationScheme_setMaxIter(self, max)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.ApproximationScheme_maxIter(self)

    def disableMaxIter(self) -> "void":
        r"""
        disableMaxIter(self)

        Disable max iterations as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_disableMaxIter(self)

    def enableMaxIter(self) -> "void":
        r"""
        enableMaxIter(self)

        Enable max iterations as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_enableMaxIter(self)

    def isEnabledMaxIter(self) -> "bool":
        r"""
        isEnabledMaxIter(self) -> bool

        Returns
        -------
        bool
          True if max iterations is used as a stopping criterion

        """
        return _pyAgrum.ApproximationScheme_isEnabledMaxIter(self)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.ApproximationScheme_setMaxTime(self, timeout)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.ApproximationScheme_maxTime(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.ApproximationScheme_currentTime(self)

    def disableMaxTime(self) -> "void":
        r"""
        disableMaxTime(self)

        Disable max time as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_disableMaxTime(self)

    def enableMaxTime(self) -> "void":
        r"""
        enableMaxTime(self)

        Enable max time as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_enableMaxTime(self)

    def isEnabledMaxTime(self) -> "bool":
        r"""
        isEnabledMaxTime(self) -> bool

        Returns
        -------
        bool
          True if max time is used as a stopping criterion

        """
        return _pyAgrum.ApproximationScheme_isEnabledMaxTime(self)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.ApproximationScheme_setPeriodSize(self, p)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.ApproximationScheme_periodSize(self)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.ApproximationScheme_setVerbosity(self, v)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.ApproximationScheme_verbosity(self)

    def stateApproximationScheme(self) -> "gum::IApproximationSchemeConfiguration::ApproximationSchemeSTATE":
        r"""
        stateApproximationScheme(self) -> gum::IApproximationSchemeConfiguration::ApproximationSchemeSTATE

        Returns
        -------
        int
          the state of the approximation scheme

        """
        return _pyAgrum.ApproximationScheme_stateApproximationScheme(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.ApproximationScheme_nbrIterations(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.ApproximationScheme_history(self)

    def initApproximationScheme(self) -> "void":
        r"""
        initApproximationScheme(self)

        Initiate the approximation scheme.

        """
        return _pyAgrum.ApproximationScheme_initApproximationScheme(self)

    def startOfPeriod(self) -> "bool":
        r"""
        startOfPeriod(self) -> bool

        Returns
        -------
        bool
          True if it is a start of a period

        """
        return _pyAgrum.ApproximationScheme_startOfPeriod(self)

    def updateApproximationScheme(self, incr: "unsigned int"=1) -> "void":
        r"""
        updateApproximationScheme(self, incr=1)

        Update the approximation scheme.

        """
        return _pyAgrum.ApproximationScheme_updateApproximationScheme(self, incr)

    def remainingBurnIn(self) -> "gum::Size":
        r"""
        remainingBurnIn(self) -> gum::Size

        Returns
        -------
        int
          the number of remaining burn in

        """
        return _pyAgrum.ApproximationScheme_remainingBurnIn(self)

    def stopApproximationScheme(self) -> "void":
        r"""
        stopApproximationScheme(self)

        Stop the approximation scheme.

        """
        return _pyAgrum.ApproximationScheme_stopApproximationScheme(self)

    def continueApproximationScheme(self, error: "double") -> "bool":
        r"""
        continueApproximationScheme(self, error) -> bool

        Continue the approximation scheme.

        Parameters
        ----------
        error : double

        """
        return _pyAgrum.ApproximationScheme_continueApproximationScheme(self, error)

# Register ApproximationScheme in _pyAgrum:
_pyAgrum.ApproximationScheme_swigregister(ApproximationScheme)

FindBarrenNodesType_FIND_NO_BARREN_NODES = _pyAgrum.FindBarrenNodesType_FIND_NO_BARREN_NODES

FindBarrenNodesType_FIND_BARREN_NODES = _pyAgrum.FindBarrenNodesType_FIND_BARREN_NODES


def randomDistribution(n: "gum::Size") -> "std::vector< double,std::allocator< double > >":
    r"""
    randomDistribution(n) -> Vector

    Parameters
    ----------
    n : int
      The number of modalities for the ditribution.

    Returns
    -------
    a random discrete distribution. 

    """
    return _pyAgrum.randomDistribution(n)
class DiscretizedVariable(IDiscretizedVariable):
    r"""



    DiscretizedVariable is a discrete random variable with a set of ``ticks`` defining intervalls.

    DiscretizedVariable(aName, aDesc='') -> DiscretizedVariable`
        Parameters:
            * **aName** (*str*) -- the name of the variable
            * **aDesc** (*str*) -- the (optional) description of the variable

    DiscretizedVariable(aDDRV) -> DiscretizedVariable
        Parameters:
            * **aDDRV** (*pyAgrum.DiscretizedVariable*) -- the pyAgrum.DiscretizedVariable that will be copied

    Examples
    --------
    >>> import pyAgrum as gum
    >>>
    >>> vX=gum.DiscretizedVariable('X','X has been discretized')
    >>> vX.addTick(1).addTick(2).addTick(3).addTick(3.1415) #doctest: +ELLIPSIS
    >>> ## <pyAgrum.pyAgrum.DiscretizedVariable;...>
    >>> print(vX)
    >>> ## X<[1;2[,[2;3[,[3;3.1415]>
    >>>
    >>> vX.isTick(4)
    >>> ## False
    >>>
    >>> vX.labels()
    >>> ## ('[1;2[', '[2;3[', '[3;3.1415]')
    >>>
    >>> # where is the real value 2.5 ?
    >>> vX.index('2.5')
    >>> ## 1

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self, aName, aDesc) -> DiscretizedVariable
        __init__(self, aName, aDesc, ticks) -> DiscretizedVariable
        __init__(self, aDRV) -> DiscretizedVariable
        """
        _pyAgrum.DiscretizedVariable_swiginit(self, _pyAgrum.new_DiscretizedVariable(*args))
    __swig_destroy__ = _pyAgrum.delete_DiscretizedVariable

    def clone(self) -> "gum::DiscretizedVariable< double > *":
        r"""
        clone(self) -> DiscretizedVariable

        Returns
        -------
        pyAgrum.DiscretizedVariable
        	a copy of the DiscretizedVariable

        """
        return _pyAgrum.DiscretizedVariable_clone(self)

    def varType(self) -> "gum::VarType":
        r"""
        varType(self) -> gum::VarType

        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.DiscretizedVariable_varType(self)

    def isTick(self, aTick: "double const &") -> "bool":
        r"""
        isTick(self, aTick) -> bool

        Parameters
        ----------
        aTick : double
        	the Tick to be tested

        Returns
        -------
        bool :
        	True if the Tick already exists

        """
        return _pyAgrum.DiscretizedVariable_isTick(self, aTick)

    def addTick(self,*args):
        """
        Parameters
        ----------
        aTick : double
            the Tick to be added

        Returns
        -------
        pyAgrum.DiscretizedVariable
            the discretized variable

        Raises
        ------
        gum.DefaultInLabel
            If the tick is already defined
        """
        _pyAgrum.DiscretizedVariable_addTick(self,*args)
        return self



    def eraseTicks(self) -> "void":
        r"""
        eraseTicks(self)

        erase all the Ticks 

        """
        return _pyAgrum.DiscretizedVariable_eraseTicks(self)

    def label(self, i: "gum::Idx") -> "std::string":
        r"""
        label(self, i) -> std::string

        Parameters
        ----------
        i : int
        	the index of the label we wish to return

        Returns
        -------
        str
        	the indice-th label

        Raises
        ------
        gum.OutOfBound
        	If the variable does not contain the label

        """
        return _pyAgrum.DiscretizedVariable_label(self, i)

    def numerical(self, indice: "gum::Idx") -> "double":
        r"""
        numerical(self, indice) -> double

        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.DiscretizedVariable_numerical(self, indice)

    def index(self, label: "std::string const &") -> "gum::Idx":
        r"""
        index(self, label) -> gum::Idx

        Parameters
        ----------
        label : str
        	a label

        Returns
        -------
        int
        	the indice of the label

        """
        return _pyAgrum.DiscretizedVariable_index(self, label)

    def domainSize(self) -> "gum::Size":
        r"""
        domainSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.DiscretizedVariable_domainSize(self)

    def domain(self) -> "std::string const":
        r"""
        domain(self) -> std::string const

        Returns
        -------
        str
            the domain of the variable as a string

        """
        return _pyAgrum.DiscretizedVariable_domain(self)

    def stype(self) -> "std::string const":
        r"""stype(self) -> std::string const"""
        return _pyAgrum.DiscretizedVariable_stype(self)

    def tick(self, i: "gum::Idx") -> "double const &":
        r"""
        tick(self, i) -> double const &

        Indicate the index of the Tick

        Parameters
        ----------
        i : int
        	the index of the Tick

        Returns
        -------
        aTick : double
        	the index-th Tick

        Raises
        ------
        gum.NotFound
        	If the index is greater than the number of Ticks

        """
        return _pyAgrum.DiscretizedVariable_tick(self, i)

    def ticks(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        ticks(self) -> Vector

        Returns
        -------
        tuple :
        	a tuple containing all the Ticks

        """
        return _pyAgrum.DiscretizedVariable_ticks(self)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.DiscretizedVariable___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.DiscretizedVariable___str__(self)

# Register DiscretizedVariable in _pyAgrum:
_pyAgrum.DiscretizedVariable_swigregister(DiscretizedVariable)

class MultiDimContainer(object):
    r"""
    Proxy of C++ gum::MultiDimContainer< double > class.
    Proxy of C++ gum::MultiDimContainer< double > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_MultiDimContainer

    def set(self, i: "Instantiation", value: "double const &") -> "void":
        r"""set(self, i, value)"""
        return _pyAgrum.MultiDimContainer_set(self, i, value)

    def get(self, i: "Instantiation") -> "double":
        r"""get(self, i) -> double"""
        return _pyAgrum.MultiDimContainer_get(self, i)

    def fill(self, d: "double const &") -> "void":
        r"""fill(self, d)"""
        return _pyAgrum.MultiDimContainer_fill(self, d)

    def populate(self, *args) -> "void":
        r"""
        populate(self, v)
        populate(self, l)
        """
        return _pyAgrum.MultiDimContainer_populate(self, *args)

    def copyFrom(self, *args) -> "void":
        r"""
        copyFrom(self, src)
        copyFrom(self, src, p_i)
        """
        return _pyAgrum.MultiDimContainer_copyFrom(self, *args)

    def extractFrom(self, src: "MultiDimContainer", mask: "Instantiation") -> "void":
        r"""extractFrom(self, src, mask)"""
        return _pyAgrum.MultiDimContainer_extractFrom(self, src, mask)

    def content(self, *args) -> "gum::MultiDimImplementation< double > *":
        r"""
        content(self) -> gum::MultiDimImplementation< double > const
        content(self) -> gum::MultiDimImplementation< double > *
        """
        return _pyAgrum.MultiDimContainer_content(self, *args)

    def getMasterRef(self, *args) -> "gum::MultiDimAdressable const &":
        r"""
        getMasterRef(self) -> MultiDimAdressable
        getMasterRef(self) -> MultiDimAdressable
        """
        return _pyAgrum.MultiDimContainer_getMasterRef(self, *args)

    def copy(self, src: "MultiDimContainer") -> "void":
        r"""copy(self, src)"""
        return _pyAgrum.MultiDimContainer_copy(self, src)

    def newFactory(self) -> "gum::MultiDimContainer< double > *":
        r"""newFactory(self) -> MultiDimContainer"""
        return _pyAgrum.MultiDimContainer_newFactory(self)

    def toString(self, *args) -> "std::string":
        r"""
        toString(self) -> std::string
        toString(self, i) -> std::string
        """
        return _pyAgrum.MultiDimContainer_toString(self, *args)

    def __eq__(self, p: "MultiDimContainer") -> "bool":
        r"""__eq__(self, p) -> bool"""
        return _pyAgrum.MultiDimContainer___eq__(self, p)

    def __ne__(self, p: "MultiDimContainer") -> "bool":
        r"""__ne__(self, p) -> bool"""
        return _pyAgrum.MultiDimContainer___ne__(self, p)

    def apply(self, f: "std::function< double (double) >") -> "void":
        r"""apply(self, f)"""
        return _pyAgrum.MultiDimContainer_apply(self, f)

    def reduce(self, f: "std::function< double (double,double) >", base: "double") -> "double":
        r"""reduce(self, f, base) -> double"""
        return _pyAgrum.MultiDimContainer_reduce(self, f, base)

    def beginMultipleChanges(self) -> "void":
        r"""beginMultipleChanges(self)"""
        return _pyAgrum.MultiDimContainer_beginMultipleChanges(self)

    def endMultipleChanges(self, *args) -> "void":
        r"""
        endMultipleChanges(self)
        endMultipleChanges(self, v)
        """
        return _pyAgrum.MultiDimContainer_endMultipleChanges(self, *args)

# Register MultiDimContainer in _pyAgrum:
_pyAgrum.MultiDimContainer_swigregister(MultiDimContainer)

class Potential(object):
    r"""



    Class representing a potential.

    Potential() -> Potential
        default constructor

    Potential(src) -> Potential
        Parameters:
            * **src** (*pyAgrum.Potential*) -- the Potential to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self) -> Potential
        __init__(self, aContent) -> Potential
        __init__(self, aContent, src) -> Potential
        __init__(self, src) -> Potential
        __init__(self, _from) -> Potential
        """
        _pyAgrum.Potential_swiginit(self, _pyAgrum.new_Potential(*args))

        self._list_vars=list()



    __swig_destroy__ = _pyAgrum.delete_Potential

    def newFactory(self) -> "gum::Potential< double > *":
        r"""
        newFactory(self) -> Potential

        Erase the Potential content and create a new empty one.

        Returns
        -------
        pyAgrum.Potential
         a reference to the new Potential

        """
        return _pyAgrum.Potential_newFactory(self)

    def random(self) -> "gum::Potential< double > const &":
        r"""random(self) -> Potential"""
        return _pyAgrum.Potential_random(self)

    def randomDistribution(self) -> "gum::Potential< double > const &":
        r"""randomDistribution(self) -> Potential"""
        return _pyAgrum.Potential_randomDistribution(self)

    def randomCPT(self) -> "gum::Potential< double > const &":
        r"""randomCPT(self) -> Potential"""
        return _pyAgrum.Potential_randomCPT(self)

    def noising(self, alpha: "double") -> "gum::Potential< double > const &":
        r"""noising(self, alpha) -> Potential"""
        return _pyAgrum.Potential_noising(self, alpha)

    def isNonZeroMap(self) -> "gum::Potential< double >":
        r"""
        isNonZeroMap(self) -> Potential

        Returns
        -------
        pyAgrum.Potential
          a boolean-like potential using the predicate isNonZero

        """
        return _pyAgrum.Potential_isNonZeroMap(self)

    def sum(self) -> "double":
        r"""
        sum(self) -> double

        Returns
        -------
        double :
          the sum of all elements in the Potential

        """
        return _pyAgrum.Potential_sum(self)

    def product(self) -> "double":
        r"""
        product(self) -> double

        Returns
        -------
        double
          the product of all elements in the Potential

        """
        return _pyAgrum.Potential_product(self)

    def max(self) -> "double":
        r"""
        max(self) -> double

        Returns
        -------
        double
          the maximum of all elements in the Potential

        """
        return _pyAgrum.Potential_max(self)

    def min(self) -> "double":
        r"""
        min(self) -> double

        Returns
        -------
        double
          the min of all elements in the Potential

        """
        return _pyAgrum.Potential_min(self)

    def maxNonOne(self) -> "double":
        r"""
        maxNonOne(self) -> double

        Returns
        -------
        double
          the maximum of non one elements in the Potential

        Raises
        ------
        gum.NotFound
          If all value == 1.0

        """
        return _pyAgrum.Potential_maxNonOne(self)

    def minNonZero(self) -> "double":
        r"""
        minNonZero(self) -> double

        Returns
        -------
        double
          the min of non zero elements in the Potential

        Raises
        ------
        gum.NotFound
          If all value == 0.0

        """
        return _pyAgrum.Potential_minNonZero(self)

    def findAll(self, v: "double") -> "gum::Set< gum::Instantiation >":
        r"""findAll(self, v) -> gum::Set< gum::Instantiation >"""
        return _pyAgrum.Potential_findAll(self, v)

    def argmax(self) -> "gum::Set< gum::Instantiation >":
        r"""argmax(self) -> gum::Set< gum::Instantiation >"""
        return _pyAgrum.Potential_argmax(self)

    def argmin(self) -> "gum::Set< gum::Instantiation >":
        r"""argmin(self) -> gum::Set< gum::Instantiation >"""
        return _pyAgrum.Potential_argmin(self)

    def entropy(self) -> "double":
        r"""
        entropy(self) -> double

        Returns
        -------
        double
          the entropy of the potential

        """
        return _pyAgrum.Potential_entropy(self)

    def reorganize(self, *args) -> "gum::Potential< double >":
        r"""
        reorganize(self, vars) -> Potential
        reorganize(self, vars) -> Potential

        Create a new Potential with another order.

        Returns
        -------
        varnames : list
          a list of the var names in the new order

        Returns
        -------
        pyAgrum.Potential
          a reference to the modified potential

        """
        return _pyAgrum.Potential_reorganize(self, *args)

    def putFirst(self, varname: "std::string const &") -> "gum::Potential< double >":
        r"""
        putFirst(self, varname) -> Potential

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable for which the index should be 0.

        Returns
        -------
        pyAgrum.Potential
          a reference to the modified potential

        Raises
        ------
        gum.InvalidArgument
          If the var is not in the potential 

        """
        return _pyAgrum.Potential_putFirst(self, varname)

    def fillWith(self, *args) -> "gum::Potential< double > const &":
        r"""
        fillWith(self, src) -> Potential
        fillWith(self, src, mapSrc) -> Potential
        fillWith(self, data) -> Potential
        fillWith(self, val) -> Potential

        Automatically fills the potential with v.

        Parameters
        ----------
        v : number or list or pyAgrum.Potential the number of parameters of the Potential
            a value or a list/pyAgrum.Potential containing the values to fill the Potential with.

        Warning
        -------
            if v is a list, the size of the list must be the
            if v is a pyAgrum.Potential. It must to contain variables with exactly the same names and labels but not necessarily the same variables.

        Returns
        -------
        pyAgrum.Potential
              a reference to the modified potentia

        Raises
        ------
        gum.SizeError
          If v size's does not matches the domain size. 

        """
        val = _pyAgrum.Potential_fillWith(self, *args)

        return self


        return val


    def abs(self) -> "gum::Potential< double > const &":
        r"""
        abs(self) -> Potential

        Apply abs on every element of the container

        Returns
        -------
        pyAgrum.Potential
            a reference to the modified potential.

        """
        val = _pyAgrum.Potential_abs(self)

        return self


        return val


    def sq(self) -> "gum::Potential< double > const &":
        r"""
        sq(self) -> Potential

        Square all the values in the Potential

        """
        val = _pyAgrum.Potential_sq(self)

        return self


        return val


    def log2(self) -> "gum::Potential< double > const &":
        r"""
        log2(self) -> Potential

        log2 all the values in the Potential

        Warning
        -------
        When the Potential contains 0 or negative values, no exception are raised but `-inf` or `nan` values are assigned.

        """
        val = _pyAgrum.Potential_log2(self)

        return self


        return val


    def new_abs(self) -> "gum::Potential< double > const":
        r"""new_abs(self) -> Potential"""
        return _pyAgrum.Potential_new_abs(self)

    def new_sq(self) -> "gum::Potential< double > const":
        r"""new_sq(self) -> Potential"""
        return _pyAgrum.Potential_new_sq(self)

    def new_log2(self) -> "gum::Potential< double > const":
        r"""new_log2(self) -> Potential"""
        return _pyAgrum.Potential_new_log2(self)

    def normalize(self) -> "gum::Potential< double > const &":
        r"""
        normalize(self) -> Potential

        Normalize the Potential (do nothing if sum is 0)

        Returns
        -------
        pyAgrum.Potential
          a reference to the normalized Potential

        """
        val = _pyAgrum.Potential_normalize(self)

        return self


        return val


    def KL(self, p: "Potential") -> "double":
        r"""
        KL(self, p) -> double

        Check the compatibility and compute the Kullback-Leibler divergence between the potential and.

        Parameters
        ----------
        p : pyAgrum.Potential
          the potential from which we want to calculate the divergence.

        Returns
        -------
        float
          The value of the divergence

        Raises
        ------
        gum.InvalidArgument
          If p is not compatible with the potential (dimension, variables)
        gum.FatalError
          If a zero is found in p or the potential and not in the other. 

        """
        return _pyAgrum.Potential_KL(self, p)

    def normalizeAsCPT(self, varId: "gum::Idx const &"=0) -> "gum::Potential< double > const &":
        r"""
        normalizeAsCPT(self, varId=0) -> Potential

        Normalize the Potential as a CPT

        Returns
        -------
        pyAgrum.Potential
          a reference to the normalized Potential

        Raises
        ------
        gum.FatalError
          If some distribution sums to 0

        """
        val = _pyAgrum.Potential_normalizeAsCPT(self, varId)

        return self


        return val


    def scale(self, v: "double") -> "gum::Potential< double > const &":
        r"""
        scale(self, v) -> Potential

        Create a new potential multiplied by v.

        Parameters
        ----------
        v : double
          a multiplier

        Returns
        -------
          a reference to the modified potential

        """
        val = _pyAgrum.Potential_scale(self, v)

        return self


        return val


    def translate(self, v: "double") -> "gum::Potential< double > const &":
        r"""
        translate(self, v) -> Potential

        Create a new potential added with v.

        Parameters
        ----------
        v : double
          The value to be added

        Returns
        -------
          a reference to the modified potential

        """
        val = _pyAgrum.Potential_translate(self, v)

        return self


        return val


    def inverse(self) -> "gum::Potential< double > const &":
        r"""inverse(self) -> Potential"""
        val = _pyAgrum.Potential_inverse(self)

        return self


        return val


    def draw(self) -> "gum::Idx":
        r"""
        draw(self) -> gum::Idx

        draw a value using the potential as a probability table.

        Returns
        -------
        int
          the index of the drawn value

        """
        return _pyAgrum.Potential_draw(self)

    def __add__(self, *args) -> "gum::Potential< double >":
        r"""
        __add__(self, p2) -> Potential
        __add__(self, v) -> Potential
        """
        return _pyAgrum.Potential___add__(self, *args)

    def __sub__(self, *args) -> "gum::Potential< double >":
        r"""
        __sub__(self, p2) -> Potential
        __sub__(self, v) -> Potential
        """
        return _pyAgrum.Potential___sub__(self, *args)

    def __mul__(self, *args) -> "gum::Potential< double >":
        r"""
        __mul__(self, p2) -> Potential
        __mul__(self, v) -> Potential
        """
        return _pyAgrum.Potential___mul__(self, *args)

    def __truediv__(self, *args):
        return _pyAgrum.Potential___truediv__(self, *args)
    __div__ = __truediv__



    def __iadd__(self, *args) -> "gum::Potential< double > &":
        r"""
        __iadd__(self, r) -> Potential
        __iadd__(self, v) -> Potential
        """
        return _pyAgrum.Potential___iadd__(self, *args)

    def __imul__(self, *args) -> "gum::Potential< double > &":
        r"""
        __imul__(self, r) -> Potential
        __imul__(self, v) -> Potential
        """
        return _pyAgrum.Potential___imul__(self, *args)

    def __isub__(self, *args) -> "gum::Potential< double > &":
        r"""
        __isub__(self, r) -> Potential
        __isub__(self, v) -> Potential
        """
        return _pyAgrum.Potential___isub__(self, *args)

    def __itruediv__(self, *args):
        return _pyAgrum.Potential___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.Potential___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.Potential___str__(self)

    def extract(self, *args) -> "gum::Potential< double >":
        r"""
        extract(self, inst) -> Potential
        extract(self, dict) -> Potential

        create a new Potential extracted from self given a partial instantiation.

        Parameters
        ----------
        inst : pyAgrum.instantiation
          a partial instantiation
        dict : dict
          a dictionnary containing discrete variables (?)

        Returns
        -------
        pyAgrum.Potential
          the new Potential

        """
        return _pyAgrum.Potential_extract(self, *args)

    def margSumOut(self, varnames: "PyObject *") -> "gum::Potential< double >":
        r"""
        margSumOut(self, varnames) -> Potential

        Projection using sum as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to eliminate

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        Raises
        ------
        gum.InvalidArgument 
          If varnames contains only one variable that does not exist in the Potential

        """
        return _pyAgrum.Potential_margSumOut(self, varnames)

    def margProdOut(self, varnames: "PyObject *") -> "gum::Potential< double >":
        r"""
        margProdOut(self, varnames) -> Potential

        Projection using multiplication as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to eliminate

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        Raises
        ------
        gum.InvalidArgument
          If varnames contains only one variable that does not exist in the Potential

        """
        return _pyAgrum.Potential_margProdOut(self, varnames)

    def margMaxOut(self, varnames: "PyObject *") -> "gum::Potential< double >":
        r"""
        margMaxOut(self, varnames) -> Potential

        Projection using max as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to eliminate

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        Raises
        ------
        gum.InvalidArgument
          If varnames contains only one variable that does not exist in the Potential

        """
        return _pyAgrum.Potential_margMaxOut(self, varnames)

    def margMinOut(self, varnames: "PyObject *") -> "gum::Potential< double >":
        r"""
        margMinOut(self, varnames) -> Potential

        Projection using min as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to eliminate

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        Warnings
        --------
        InvalidArgument raised if varnames contains only one variable that does not exist in the Potential

        """
        return _pyAgrum.Potential_margMinOut(self, varnames)

    def margSumIn(self, varnames: "PyObject *") -> "gum::Potential< double >":
        r"""
        margSumIn(self, varnames) -> Potential

        Projection using sum as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to keep

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        """
        return _pyAgrum.Potential_margSumIn(self, varnames)

    def margProdIn(self, varnames: "PyObject *") -> "gum::Potential< double >":
        r"""
        margProdIn(self, varnames) -> Potential

        Projection using multiplication as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to keep

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        """
        return _pyAgrum.Potential_margProdIn(self, varnames)

    def margMaxIn(self, varnames: "PyObject *") -> "gum::Potential< double >":
        r"""
        margMaxIn(self, varnames) -> Potential

        Projection using max as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to keep

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        """
        return _pyAgrum.Potential_margMaxIn(self, varnames)

    def margMinIn(self, varnames: "PyObject *") -> "gum::Potential< double >":
        r"""
        margMinIn(self, varnames) -> Potential

        Projection using min as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to keep

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        """
        return _pyAgrum.Potential_margMinIn(self, varnames)

    def __eq__(self, *args) -> "bool":
        r"""
        __eq__(self, r) -> bool
        __eq__(self, b) -> bool
        """
        return _pyAgrum.Potential___eq__(self, *args)

    def __ne__(self, *args) -> "bool":
        r"""
        __ne__(self, r) -> bool
        __ne__(self, b) -> bool
        """
        return _pyAgrum.Potential___ne__(self, *args)

    def __radd__(self,other):
      return self.__add__(other)

    def __rmul__(self,other):
      return self.__mul__(other)

    def __rsub__(self,other):
      return (self*-1)+other

    def __rfloordiv__(self,other):
      return Potential(self).inverse().scale(other)

    def __rtruediv__(self,other):
      return Potential(self).inverse().scale(other)

    def __rdiv__(self,other):
      return Potential(self).inverse().scale(other)

    def __neg__(self):
      return -1*self

    def __abs__(self):
      return Potential(self).abs()

    def loopIn(self):
      """
      Generator to iterate inside a Potential. 

      Yield an gum.Instantiation that iterates over all the possible values for the gum.Potential

      Examples
      --------
      >>> import pyAgrum as gum
      >>> bn=gum.fastBN("A[3]->B[3]<-C[3]")
      >>> for i in bn.cpt("B").loopIn():
            print(i)
            print(bn.cpt("B").get(i))
            bn.cpt("B").set(i,0.3) 
      """
      i=Instantiation(self)
      i.setFirst()
      while not i.end():
        yield i
        i.inc()
      return

    def fillWithFunction(self,s,noise=None):
      """
      Automatically fills the potential as a (quasi) deterministic CPT with the evaluation of the expression s.

      The expression s gives a value for the first variable using the names of the last variables.
      The computed CPT is deterministic unless noise is used to add a 'probabilistic' noise around the exact value given by the expression.


      Examples
      --------
      >>> import pyAgrum as gum
      >>> bn=gum.fastBN("A[3]->B[3]<-C[3]")
      >>> bn.cpt("B").fillWithFunction("(A+C)/2")

      Parameters
      ----------
      s : str
          an expression using the name of the last variables of the Potential and giving a value to the first variable of the Potential
      noise : list
          an (odd) list of numerics giving a pattern of 'probabilistic noise' around the value.

      Warning
      -------
          The expression may have any numerical values, but will be then transformed to the closest correct value for the range of the variable.

      Returns
      -------
      pyAgrum.Potential
            a reference to the modified potential

      Raises
      ------
      gum.InvalidArgument
        If the first variable is Labelized or Integer, or if the len of the noise is not odd.
      """
      if self.variable(0).varType()==VarType_Labelized:
        raise InvalidArgument("[pyAgrum] The variable "+self.variable(0).name()+" is a LabelizedVariable")
      if self.variable(0).varType()==VarType_Integer:
        raise InvalidArgument("[pyAgrum] The variable "+self.variable(0).name()+" is neither Range nor Discretized variable.")

      if noise==None:
        mid=0
      else:
        if len(noise)%2==0:
          raise InvalidArgument("[pyAgrum] len(noise) must not be even")
        mid=int((len(noise)-1)/2)

      self.fillWith(0)
      mi=self.variable(0).numerical(0)
      ma=self.variable(0).numerical(self.variable(0).domainSize()-1)

      I=Instantiation(self)

      I.setFirst()
      while not I.end():
        vars={self.variable(i).name():self.variable(i).numerical(I.val(i)) for i in range(1,self.nbrDim())}
        res=eval(s,None,vars)
        if res<mi:
          res=mi
        if res>ma:
          res=ma
        pos=self.variable(0).index(str(res))
        if mid==0:
          I.chgVal(0,pos)
          self.set(I,1)
        else:
          for i,v in enumerate(noise):
            if 0<=pos+i-mid<self.variable(0).domainSize():
              I.chgVal(0,pos+i-mid)
              self.set(I,v)
        I.incNotVar(self.variable(0))
      self.normalizeAsCPT()
      return self

    def variablesSequence(self):
        """
        Returns
        -------
        list
            a list containing the sequence of variables
        """
        varlist = []
        for i in range(0, self.nbrDim()):
            varlist.append(self.variable(i))
        return varlist

    def __prepareIndices__(self,ind):
      """
      From an indice (dict or tuple), returns a pair of gum.Instantiation to loop in a part of the Potential.
      """
      loopvars=Instantiation(self)
      loopvars.setMutable()

      inst=Instantiation(self)
      inst.setFirst()

      if isinstance(ind, (Number,slice)):
        i = tuple([ind])
      else:
        i = ind

      vn=self.var_names
      if isinstance(i,dict):
          for nam in vn:        
              if nam in i:
                  inst.chgVal(nam,i[nam])
                  loopvars.erase(nam)
      elif isinstance(i,tuple):
          if len(i)>self.nbrDim():
              raise KeyError("Too many values in '"+str(i)+"' for '"+str(self)+"'")
          for k,v in enumerate(i):
              if not isinstance(v,slice):
                  nam=vn[k]
                  inst.chgVal(nam,v)
                  loopvars.erase(nam)
      else:
          raise ValueError("No subscript using '"+str(i)+"'")
      return inst,loopvars

    def __getitem__(self, id):
      if isinstance(id,Instantiation):
          return self.get(id)

      inst,loopvars=self.__prepareIndices__(id)

      if loopvars.nbrDim()==0:
          return self.get(inst)

      if loopvars.nbrDim()==self.nbrDim():
        content=[]

        inst=Instantiation(self)
        while not inst.end():
            content.append(self.get(inst)) 
            inst.inc()
        tab=numpy.array(content,dtype=numpy.float64)
        tab.shape=tuple(self.var_dims)
        return tab

      names=[loopvars.variable(i-1).name() for i in range(loopvars.nbrDim(),0,-1)]
      tab=numpy.zeros(tuple([loopvars.variable(i-1).domainSize() for i in range(loopvars.nbrDim(),0,-1)]))
      while not inst.end():
          indice=[inst.val(name) for name in names]
          tab[tuple(indice)]=self.get(inst)
          inst.incIn(loopvars)
      return tab

    def __setitem__(self, id, value):
      if isinstance(id,Instantiation):
          self.set(id,value)
          return

      inst,loopvars=self.__prepareIndices__(id)

      if loopvars.nbrDim()==0:
          self.set(inst,value)
          return

      if isinstance(value,Number):
        while not inst.end():
            self.set(inst,value)
            inst.incIn(loopvars)
      else:
        if isinstance(value,list):
            value=numpy.array(value)

        shape=tuple([loopvars.variable(i-1).domainSize() for i in range(loopvars.nbrDim(),0,-1)])
        if value.shape!=shape:
          raise IndexError("Shape of '"+str(value)+"' is not '"+str(shape)+"'")

        names = [loopvars.variable(i - 1).name() for i in range(loopvars.nbrDim(), 0, -1)]
        while not inst.end():
            indice = tuple([inst.val(name) for name in names])
            self.set(inst,float(value[indice]))
            inst.incIn(loopvars)

    def tolist(self):
        """
        Returns
        -------
        list
            the potential as a list
        """
        return self.__getitem__({}).tolist()

    def toarray(self):
        """
        Returns
        -------
        array
            the potential as an array
        """
        return self.__getitem__({})

    def topandas(self):
        """
        Returns
        -------
        pandas.DataFrame
           the potential as an pandas.DataFrame
        """
        import pandas as pd
        varnames = self.var_names
        data = []
        pname = ""
        for inst in self.loopIn():
            d = {k:v for k,v in reversed(inst.todict(True).items())}
            d[pname] = self.get(inst)
            d[pname], d[varnames[-1]] = d[varnames[-1]], d[pname]
            data.append(d)
        cols = varnames[:-1] + [pname]
        return pd.DataFrame(data).set_index(cols).unstack(pname)

    def tolatex(self):
        """
        Render object to a LaTeX tabular.

        Requires to include `booktabs` package in the LaTeX document.

        Returns
        -------
        str
         the potential as LaTeX string
        """
        return self.topandas().to_latex()

    def toclipboard(self,**kwargs):
        """
        Write a text representation of object to the system clipboard. This can be pasted into spreadsheet, for instance.
        """
        return self.topandas().to_clipboard()

    @property
    def var_names(self):
        """
        Returns
        -------
        list
            a list containing the name of each variables in the potential

        Warnings
        --------
            listed in the reverse order of the enumeration order of the variables.
        """
        return [self.variable(i-1).name() for i in range(self.nbrDim(),0,-1)]

    @property
    def var_dims(self):
        """
        Returns
        -------
        list
            a list containing the dimensions of each variables in the potential
        """
        return [self.variable(i-1).domainSize() for i in range(self.nbrDim(),0,-1)]


    def get(self, i: "Instantiation") -> "double":
        r"""
        get(self, i) -> double

        Parameters
        ----------
        i : pyAgrum.Instantiation
          an Instantiation

        Returns
        -------
        double
          the value in the Potential at the position given by the instantiation

        """
        return _pyAgrum.Potential_get(self, i)

    def set(self, i: "Instantiation", value: "double const &") -> "void":
        r"""
        set(self, i, value)

        Change the value pointed by i

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The Instantiation to be changed
        value : double
          The new value of the Instantiation

        """
        return _pyAgrum.Potential_set(self, i, value)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool

        Returns
        -------
        bool
            Returns true if no variable is in the potential. 

        """
        return _pyAgrum.Potential_empty(self)

    def pos(self, v: "DiscreteVariable") -> "gum::Idx":
        r"""
        pos(self, v) -> gum::Idx

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable for which the index is returned.

        Returns
        -------
            Returns the index of a variable. 

        Raises
        ------
        gum.NotFound 
          If v is not in this multidimensional matrix. 

        """
        return _pyAgrum.Potential_pos(self, v)

    def contains(self, v: "DiscreteVariable") -> "bool":
        r"""
        contains(self, v) -> bool

        Parameters
        ----------
        v : pyAgrum.Potential
            a DiscreteVariable.

        Returns
        -------
        bool
            True if the var is in the potential

        """
        return _pyAgrum.Potential_contains(self, v)

    def variable(self, *args) -> "gum::DiscreteVariable const &":
        r"""
        variable(self, i) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable

        Parameters
        ----------
        i : int 
          An index of this multidimensional matrix.

        Returns
        -------
          the varible at the ith index 

        Raises
        ------
        gum.NotFound
          If i does not reference a variable in this multidimensional matrix. 

        """
        return _pyAgrum.Potential_variable(self, *args)

    def remove(self, var: "DiscreteVariable") -> "void":
        r"""
        remove(self, var)

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable to be removed

        Returns
        -------
        pyAgrum.Potential
          a reference to the modified potential

        Warnings
        --------
        IndexError raised if the var is not in the potential 

        """
        val = _pyAgrum.Potential_remove(self, var)

        self._list_vars.remove(var)


        return val


    def add(self, v: "DiscreteVariable") -> "void":
        r"""
        add(self, v)

        Add a discrete variable to the potential.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          the var to be added

        Raises
        ------
        DuplicateElement
          If the variable is already in this Potential.
        InvalidArgument
          If the variable is empty.

        """
        val = _pyAgrum.Potential_add(self, v)

        self._list_vars.append(v)
        return self


        return val


    def domainSize(self) -> "gum::Size":
        r"""domainSize(self) -> gum::Size"""
        return _pyAgrum.Potential_domainSize(self)

    def nbrDim(self, *args) -> "gum::Size":
        r"""
        nbrDim(self) -> gum::Idx
        nbrDim(self) -> gum::Size

        Returns
        -------
        int
          the number of vars in the multidimensional container. 

        """
        return _pyAgrum.Potential_nbrDim(self, *args)

# Register Potential in _pyAgrum:
_pyAgrum.Potential_swigregister(Potential)

class IBayesNet(DAGmodel):
    r"""



    Abstract class used by BayesNet.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __swig_destroy__ = _pyAgrum.delete_IBayesNet

    def cpt(self, varId: "gum::NodeId") -> "gum::Potential< double > const &":
        r"""
        cpt(self, varId) -> Potential

        Returns the CPT of a variable.

        Parameters
        ----------
        VarId : int
        	A variable's id in the pyAgrum.IBayesNet.
        name : str
        	A variable's name in the pyAgrum.IBayesNet.

        Returns
        -------
        pyAgrum.Potential
        	The variable's CPT. 

        Raises
        ------
        gum.NotFound 
        	If no variable's id matches varId. 

        """
        return _pyAgrum.IBayesNet_cpt(self, varId)

    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        r"""
        variableNodeMap(self) -> VariableNodeMap

        Returns
        -------
        pyAgrum.variableNodeMap
        	the variable node map

        """
        return _pyAgrum.IBayesNet_variableNodeMap(self)

    def variable(self, id: "gum::NodeId") -> "gum::DiscreteVariable const &":
        r"""
        variable(self, id) -> DiscreteVariable

        Parameters
        ----------
        id : int
        	a variable's id
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.IBayesNet_variable(self, id)

    def nodeId(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        nodeId(self, var) -> gum::NodeId

        Parameters
        ----------
        var : pyAgrum.DiscreteVariable
        	a variable

        Returns
        -------
        int
        	the id of the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.IBayesNet_nodeId(self, var)

    def idFromName(self, name: "std::string const &") -> "gum::NodeId":
        r"""
        idFromName(self, name) -> gum::NodeId

        Returns a variable's id given its name in the graph.

        Parameters
        ----------
        name : str
        	The variable's name from which the id is returned.

        Returns
        -------
        int :
        	The variable's node id.

        Raises
        ------
        gum.NotFound
        	If name does not match a variable in the graph

        """
        return _pyAgrum.IBayesNet_idFromName(self, name)

    def variableFromName(self, name: "std::string const &") -> "gum::DiscreteVariable const &":
        r"""
        variableFromName(self, name) -> DiscreteVariable

        Parameters
        ----------
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.IBayesNet_variableFromName(self, name)

    def jointProbability(self, i: "Instantiation") -> "double":
        r"""
        jointProbability(self, i) -> double

        Parameters
        ----------
        i : pyAgrum.instantiation
        	an instantiation of the variables

        Returns
        -------
        double
        	a parameter of the joint probability for the BayesNet

        Warnings
        --------
        a variable not present in the instantiation is assumed to be instantiated to 0

        """
        return _pyAgrum.IBayesNet_jointProbability(self, i)

    def log2JointProbability(self, i: "Instantiation") -> "double":
        r"""
        log2JointProbability(self, i) -> double

        Parameters
        ----------
        i : pyAgrum.instantiation
        	an instantiation of the variables

        Returns
        -------
        double
        	a parameter of the log joint probability for the BayesNet

        Warnings
        --------
        a variable not present in the instantiation is assumed to be instantiated to 0

        """
        return _pyAgrum.IBayesNet_log2JointProbability(self, i)

    def __eq__(self, _from: "IBayesNet") -> "bool":
        r"""__eq__(self, _from) -> bool"""
        return _pyAgrum.IBayesNet___eq__(self, _from)

    def __ne__(self, _from: "IBayesNet") -> "bool":
        r"""__ne__(self, _from) -> bool"""
        return _pyAgrum.IBayesNet___ne__(self, _from)

    def dim(self) -> "gum::Size":
        r"""
        dim(self) -> gum::Size

        Returns the dimension (the number of free parameters) in this BayesNet.

        Returns
        -------
        int
        	the dimension of the BayesNet

        """
        return _pyAgrum.IBayesNet_dim(self)

    def maxVarDomainSize(self) -> "gum::Size":
        r"""
        maxVarDomainSize(self) -> gum::Size

        Returns
        -------
        int
        	the biggest domain size among the variables of the BayesNet

        """
        return _pyAgrum.IBayesNet_maxVarDomainSize(self)

    def minParam(self) -> "double":
        r"""
        minParam(self) -> double

        Returns
        -------
        double
            the smallest value in the CPTs of the IBayesNet

        """
        return _pyAgrum.IBayesNet_minParam(self)

    def maxParam(self) -> "double":
        r"""
        maxParam(self) -> double

        Returns
        -------
        double
            the biggest value in the CPTs of the BayesNet

        """
        return _pyAgrum.IBayesNet_maxParam(self)

    def minNonZeroParam(self) -> "double":
        r"""
        minNonZeroParam(self) -> double

        Returns
        -------
        double
            the smallest value (not equal to 0) in the CPTs of the IBayesNet

        """
        return _pyAgrum.IBayesNet_minNonZeroParam(self)

    def maxNonOneParam(self) -> "double":
        r"""
        maxNonOneParam(self) -> double

        Returns
        -------
        double
        	The biggest value (not equal to 1) in the CPTs of the BayesNet

        """
        return _pyAgrum.IBayesNet_maxNonOneParam(self)

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.IBayesNet_toDot(self)

    def minimalCondSet(self, *args) -> "PyObject *":
        r"""
        minimalCondSet(self, target, soids) -> gum::NodeSet
        minimalCondSet(self, targets, soids) -> gum::NodeSet
        minimalCondSet(self, target, list) -> PyObject
        minimalCondSet(self, targets, list) -> PyObject *

        Returns, given one or many targets and a list of variables, the minimal set of those needed to calculate the target/targets.

        Parameters
        ----------
        target : int
        	The id of the target
        targets : list
        	The ids of the targets
        list : list
        	The list of available variables

        Returns
        -------
        Set
        	The minimal set of variables

        """
        return _pyAgrum.IBayesNet_minimalCondSet(self, *args)

    def isIndependent(self, *args) -> "bool":
        r"""
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, X, Y) -> bool
        """
        return _pyAgrum.IBayesNet_isIndependent(self, *args)

    def names(self) -> "PyObject *":
        r"""
        names(self) -> PyObject *

        Returns
        -------
        list
        	The names of the graph variables

        """
        return _pyAgrum.IBayesNet_names(self)

    def nodes(self) -> "PyObject *":
        r"""
        nodes(self) -> PyObject *

        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.IBayesNet_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def arcs(self) -> "PyObject *":
        r"""
        arcs(self) -> PyObject *

        Returns
        -------
        list
        	The lisf of arcs in the IBayesNet

        """
        return _pyAgrum.IBayesNet_arcs(self)

    def parents(self, norid: "PyObject *") -> "PyObject *":
        r"""
        parents(self, norid) -> PyObject *

        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.IBayesNet_parents(self, norid)

    def children(self, norid: "PyObject *") -> "PyObject *":
        r"""
        children(self, norid) -> PyObject *

        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.IBayesNet_children(self, norid)

    def family(self, norid: "PyObject *") -> "PyObject *":
        r"""family(self, norid) -> PyObject *"""
        return _pyAgrum.IBayesNet_family(self, norid)

    def descendants(self, norid: "PyObject *") -> "PyObject *":
        r"""descendants(self, norid) -> PyObject *"""
        return _pyAgrum.IBayesNet_descendants(self, norid)

    def ancestors(self, norid: "PyObject *") -> "PyObject *":
        r"""ancestors(self, norid) -> PyObject *"""
        return _pyAgrum.IBayesNet_ancestors(self, norid)

    def moralizedAncestralGraph(self, nodes: "PyObject *") -> "gum::UndiGraph":
        r"""moralizedAncestralGraph(self, nodes) -> UndiGraph"""
        return _pyAgrum.IBayesNet_moralizedAncestralGraph(self, nodes)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.IBayesNet___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.IBayesNet___str__(self)

# Register IBayesNet in _pyAgrum:
_pyAgrum.IBayesNet_swigregister(IBayesNet)

class BayesNet(IBayesNet):
    r"""



    BayesNet represents a Bayesian network.

    BayesNet(name='') -> BayesNet
        Parameters:
          * **name** (*str*) -- the name of the Bayes Net

    BayesNet(source) -> BayesNet
        Parameters:
          * **source** (*pyAgrum.BayesNet*) -- the Bayesian network to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    @staticmethod
    def fastPrototype(dotlike: "std::string const &", domainSize: "gum::Size"=2) -> "gum::BayesNet< double >":
        r"""
        fastPrototype(dotlike, domainSize=2) -> BayesNet

        Create a Bayesian network with a dot-like syntax which specifies:
            - the structure 'a->b->c;b->d<-e;'.
            - the type of the variables with different syntax:

              - by default, a variable is a gum.RangeVariable using the default domain size (second argument)
              - with 'a[10]', the variable is a gum.RangeVariable using 10 as domain size (from 0 to 9)
              - with 'a[3,7]', the variable is a gum.RangeVariable using a domainSize from 3 to 7
              - with 'a[1,3.14,5,6.2]', the variable is a gum.DiscretizedVariable using the given ticks (at least 3 values)
              - with 'a{top|middle|bottom}', the variable is a gum.LabelizedVariable using the given labels.
              - with 'a{-1|5|0|3}', the variable is a gum.IntegerVariable using the sorted given values.

        Note 
        ----
          - If the dot-like string contains such a specification more than once for a variable, the first specification will be used.
          - the CPTs are randomly generated.
          - see also pyAgrum.fastBN.

        Examples
        --------
        >>> import pyAgrum as gum
        >>> bn=gum.BayesNet.fastPrototype('A->B[1,3]<-C{yes|No}->D[2,4]<-E[1,2.5,3.9]',6)

        Parameters
        ----------
        dotlike : str
                the string containing the specification
        domainSize : int
                the default domain size for variables

        Returns
        -------
        pyAgrum.BayesNet
                the resulting Bayesian network

        """
        return _pyAgrum.BayesNet_fastPrototype(dotlike, domainSize)
    __swig_destroy__ = _pyAgrum.delete_BayesNet

    def __init__(self, *args):
        r"""
        __init__(self) -> BayesNet
        __init__(self, name) -> BayesNet
        __init__(self, source) -> BayesNet
        """
        _pyAgrum.BayesNet_swiginit(self, _pyAgrum.new_BayesNet(*args))

    def cpt(self, *args) -> "gum::Potential< double > const &":
        r"""
        cpt(self, varId) -> Potential
        cpt(self, name) -> Potential

        Returns the CPT of a variable.

        Parameters
        ----------
        VarId : int
        	A variable's id in the pyAgrum.BayesNet.
        name : str
        	A variable's name in the pyAgrum.BayesNet.

        Returns
        -------
        pyAgrum.Potential
        	The variable's CPT. 

        Raises
        ------
        gum.NotFound
            If no variable's id matches varId.

        """
        return _pyAgrum.BayesNet_cpt(self, *args)

    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        r"""
        variableNodeMap(self) -> VariableNodeMap

        Returns
        -------
        pyAgrum.variableNodeMap
        	the variable node map

        """
        return _pyAgrum.BayesNet_variableNodeMap(self)

    def add(self, *args) -> "gum::NodeId":
        r"""
        add(self, var) -> gum::NodeId
        add(self, name, nbrmod) -> gum::NodeId
        add(self, var, aContent) -> gum::NodeId
        add(self, var, id) -> gum::NodeId
        add(self, var, aContent, id) -> gum::NodeId

        Add a variable to the pyAgrum.BayesNet. 

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added
        name : str 
        	the variable name
        nbrmod : int
        	the number of modalities for the new variable
        id : int
        	the variable forced id in the pyAgrum.BayesNet

        Returns
        -------
        int 
        	the id of the new node

        Raises
        ------
        gum.DuplicateLabel
            If variable.name() is already used in this pyAgrum.BayesNet.
        gum.NotAllowed
            If nbrmod is less than 2
        gum.DuplicateElement
            If id is already used.

        """
        return _pyAgrum.BayesNet_add(self, *args)

    def clear(self) -> "void":
        r"""
        clear(self)

        Clear the whole BayesNet  

        """
        return _pyAgrum.BayesNet_clear(self)

    def erase(self, *args) -> "void":
        r"""
        erase(self, varId)
        erase(self, name)
        erase(self, var)

        Remove a variable from the gum::BayesNet.

        Removes the corresponding variable from the gum::BayesNet and from all of it's children gum::Potential.

        If no variable matches the given id, then nothing is done.

        Parameters
        ----------
        id : int
        	The variable's id to remove. 
        name : str
        	The variable's name to remove.
        var : pyAgrum.DiscreteVariable
        	A reference on the variable to remove. 

        """
        return _pyAgrum.BayesNet_erase(self, *args)

    def variable(self, *args) -> "gum::DiscreteVariable const &":
        r"""
        variable(self, id) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable

        Parameters
        ----------
        id : int
        	a variable's id
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNet_variable(self, *args)

    def changeVariableName(self, *args) -> "void":
        r"""
        changeVariableName(self, id, new_name)
        changeVariableName(self, name, new_name)

        Changes a variable's name in the gum::BayesNet.

        This will change the gum::DiscreteVariable names in the gum::BayesNet.

        Parameters
        ----------
        new_name : str
        	the new name of the variable
        NodeId : int
        	the id of the node
        name : str
        	the name of the variable

        Raises
        ------
        gum.DuplicateLabel
            If new_name is already used in this BayesNet.
        gum.NotFound
            If no variable matches id.

        """
        return _pyAgrum.BayesNet_changeVariableName(self, *args)

    def changeVariableLabel(self, *args) -> "void":
        r"""
        changeVariableLabel(self, id, old_label, new_label)
        changeVariableLabel(self, name, old_label, new_label)

        change the label of the variable associated to nodeId to the new value.

        Parameters
        ----------
        id : int
        	the id of the node
        name : str
        	the name of the variable
        old_label : str
        	the new label
        new_label : str
        	the new label

        Raises
        ------
        gum.NotFound
            if id/name is not a variable or if old_label does not exist.

        """
        return _pyAgrum.BayesNet_changeVariableLabel(self, *args)

    def nodeId(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        nodeId(self, var) -> gum::NodeId

        Parameters
        ----------
        var : pyAgrum.DiscreteVariable
        	a variable

        Returns
        -------
        int
        	the id of the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNet_nodeId(self, var)

    def idFromName(self, name: "std::string const &") -> "gum::NodeId":
        r"""
        idFromName(self, name) -> gum::NodeId

        Returns a variable's id given its name in the graph.

        Parameters
        ----------
        name : str
        	The variable's name from which the id is returned.

        Returns
        -------
        int :
        	The variable's node id.

        Raises
        ------
        gum.NotFound
        	If name does not match a variable in the graph

        """
        return _pyAgrum.BayesNet_idFromName(self, name)

    def variableFromName(self, name: "std::string const &") -> "gum::DiscreteVariable const &":
        r"""
        variableFromName(self, name) -> DiscreteVariable

        Parameters
        ----------
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNet_variableFromName(self, name)

    def addArc(self, *args) -> "void":
        r"""
        addArc(self, tail, head)
        addArc(self, tail, head)

        Add an arc in the BN, and update arc.head's CPT.

        Parameters
        ----------
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        Raises
        ------
        gum.InvalidEdge
            If arc.tail and/or arc.head are not in the BN.
        gum.DuplicateElement
            If the arc already exists.

        """
        return _pyAgrum.BayesNet_addArc(self, *args)

    def eraseArc(self, *args) -> "void":
        r"""
        eraseArc(self, arc)
        eraseArc(self, tail, head)
        eraseArc(self, tail, head)

        Removes an arc in the BN, and update head's CTP.

        If (tail, head) doesn't exist, the nothing happens.

        Parameters
        ----------
        arc : pyAgrum.Arc 
        	The arc to be removed.
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BayesNet_eraseArc(self, *args)

    def beginTopologyTransformation(self) -> "void":
        r"""
        beginTopologyTransformation(self)

        When inserting/removing arcs, node CPTs change their dimension with a cost in time.
        begin Multiple Change for all CPTs
        These functions delay the CPTs change to be done just once at the end of a sequence of topology modification, begins a sequence of insertions/deletions of arcs without changing the dimensions of the CPTs.

        """
        return _pyAgrum.BayesNet_beginTopologyTransformation(self)

    def endTopologyTransformation(self) -> "void":
        r"""
        endTopologyTransformation(self)

        Terminates a sequence of insertions/deletions of arcs by adjusting all CPTs dimensions.
        End Multiple Change for all CPTs.

        Returns
        -------
        pyAgrum.BayesNet

        """
        return _pyAgrum.BayesNet_endTopologyTransformation(self)

    def reverseArc(self, *args) -> "void":
        r"""
        reverseArc(self, tail, head)
        reverseArc(self, tail, head)
        reverseArc(self, arc)

        Reverses an arc while preserving the same joint distribution. 

        Parameters
        ----------
        tail
        	(int) the id of the tail variable
        head
        	(int) the id of the head variable
        tail
        	(str) the name of the tail variable
        head
        	(str) the name of the head variable
        arc : pyAgrum.Arc
        	an arc 

        Raises
        ------
        gum.InvalidArc
            If the arc does not exsit or if its reversal would induce a directed cycle.

        """
        return _pyAgrum.BayesNet_reverseArc(self, *args)

    def addNoisyOR(self, *args) -> "gum::NodeId":
        r"""
        addNoisyOR(self, var, external_weight) -> gum::NodeId
        addNoisyOR(self, var, external_weight, id) -> gum::NodeId

        Add a variable, it's associate node and a noisyOR implementation.

        Since it seems that the 'classical' noisyOR is the Compound noisyOR, we keep the addNoisyOR as an alias for addNoisyORCompound.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable. 

        Raises
        --------
        gum.DuplicateElement
            If id is already used

        """
        return _pyAgrum.BayesNet_addNoisyOR(self, *args)

    def addNoisyORNet(self, *args) -> "gum::NodeId":
        r"""
        addNoisyORNet(self, var, external_weight) -> gum::NodeId
        addNoisyORNet(self, var, external_weight, id) -> gum::NodeId

        Add a variable, its associate node and a noisyOR implementation.

        Since it seems that the 'classical' noisyOR is the Compound noisyOR, we keep the addNoisyOR as an alias for addNoisyORCompound.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable.

        """
        return _pyAgrum.BayesNet_addNoisyORNet(self, *args)

    def addNoisyORCompound(self, *args) -> "gum::NodeId":
        r"""
        addNoisyORCompound(self, var, external_weight) -> gum::NodeId
        addNoisyORCompound(self, var, external_weight, id) -> gum::NodeId

        Add a variable, it's associate node and a noisyOR implementation.

        Since it seems that the 'classical' noisyOR is the Compound noisyOR, we keep the addNoisyOR as an alias for addNoisyORCompound.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable.

        Raises
        --------
        gum.DuplicateElement
            If id is already used

        """
        return _pyAgrum.BayesNet_addNoisyORCompound(self, *args)

    def addNoisyAND(self, *args) -> "gum::NodeId":
        r"""
        addNoisyAND(self, var, external_weight, id) -> gum::NodeId
        addNoisyAND(self, var, external_weight) -> gum::NodeId

        Add a variable, its associate node and a noisyAND implementation.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable.

        Raises
        ------
        gum.DuplicateElement
            If id is already used

        """
        return _pyAgrum.BayesNet_addNoisyAND(self, *args)

    def addLogit(self, *args) -> "gum::NodeId":
        r"""
        addLogit(self, var, external_weight, id) -> gum::NodeId
        addLogit(self, var, external_weight) -> gum::NodeId

        Add a variable, its associate node and a Logit implementation.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.
        Returns
        -------
        int
        	the id of the added variable.

        Raises
        ------
        gum.DuplicateElement
            If id is already used

        """
        return _pyAgrum.BayesNet_addLogit(self, *args)

    def addOR(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        addOR(self, var) -> gum::NodeId

        Add a variable, it's associate node and an OR implementation.

        The id of the new variable is automatically generated.

        Warnings
        --------
        	If parents are not boolean, all value>1 is True

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy

        Returns
        -------
        int
        	the id of the added variable.

        Raises
        ------
        gum.SizeError
            If variable.domainSize()>2

        """
        return _pyAgrum.BayesNet_addOR(self, var)

    def addAND(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        addAND(self, var) -> gum::NodeId

        Add a variable, it's associate node and an AND implementation.

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy.

        Returns
        -------
        int
        	the id of the added variable. 

        Raises
        ------
        gum.SizeError
            If variable.domainSize()>2

        """
        return _pyAgrum.BayesNet_addAND(self, var)

    def addAMPLITUDE(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        addAMPLITUDE(self, var) -> gum::NodeId

        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_addAMPLITUDE(self, var)

    def addCOUNT(self, var: "DiscreteVariable", value: "gum::Idx"=1) -> "gum::NodeId":
        r"""
        addCOUNT(self, var, value=1) -> gum::NodeId

        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_addCOUNT(self, var, value)

    def addEXISTS(self, var: "DiscreteVariable", value: "gum::Idx"=1) -> "gum::NodeId":
        r"""
        addEXISTS(self, var, value=1) -> gum::NodeId

        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_addEXISTS(self, var, value)

    def addFORALL(self, var: "DiscreteVariable", value: "gum::Idx"=1) -> "gum::NodeId":
        r"""
        addFORALL(self, var, value=1) -> gum::NodeId

        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added variable.

        """
        return _pyAgrum.BayesNet_addFORALL(self, var, value)

    def addMAX(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        addMAX(self, var) -> gum::NodeId

        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_addMAX(self, var)

    def addMEDIAN(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        addMEDIAN(self, var) -> gum::NodeId

        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_addMEDIAN(self, var)

    def addMIN(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        addMIN(self, var) -> gum::NodeId

        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_addMIN(self, var)

    def addSUM(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        addSUM(self, var) -> gum::NodeId

        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
                the variable to be added

        Returns
        -------
        int
                the id of the added value

        """
        return _pyAgrum.BayesNet_addSUM(self, var)

    def addWeightedArc(self, *args) -> "void":
        r"""
        addWeightedArc(self, tail, head, causalWeight)
        addWeightedArc(self, tail, head, causalWeight)

        Add an arc in the BN, and update arc.head's CPT.

        Parameters
        ----------
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)
        causalWeight : double
        	the added causal weight

        Raises
        ------
        gum.InvalidArc
            If arc.tail and/or arc.head are not in the BN.
        gum.InvalidArc
            If variable in arc.head is not a NoisyOR variable.

        """
        return _pyAgrum.BayesNet_addWeightedArc(self, *args)

    def generateCPTs(self) -> "void":
        r"""
        generateCPTs(self)

        Randomly generates CPTs for a given structure.

        """
        return _pyAgrum.BayesNet_generateCPTs(self)

    def generateCPT(self, *args) -> "void":
        r"""
        generateCPT(self, node)
        generateCPT(self, name)

        Randomly generate CPT for a given node in a given structure.

        Parameters
        ----------
        node : int
        	The variable's id.
        name : str 
        	The variable's name.

        """
        return _pyAgrum.BayesNet_generateCPT(self, *args)

    def changePotential(self, *args) -> "void":
        r"""
        changePotential(self, id, newPot)
        changePotential(self, name, newPot)

        change the CPT associated to nodeId to newPot delete the old CPT associated to nodeId.

        Parameters
        ----------
        newPot : pyAgrum.Potential
        	the new potential
        NodeId : int
        	the id of the node
        name : str
        	the name of the variable

        Raises
        ------
        gum.NotAllowed
            If newPot has not the same signature as __probaMap[NodeId]

        """
        return _pyAgrum.BayesNet_changePotential(self, *args)

    def dag(self) -> "gum::DAG const &":
        r"""
        dag(self) -> DAG

        Returns
        -------
        pyAgrum.DAG
        	a constant reference to the dag of this BayesNet.

        """
        val = _pyAgrum.BayesNet_dag(self)

        val = DAG(val) # copying the DAG


        return val


    def size(self) -> "gum::Size":
        r"""
        size(self) -> gum::Size

        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.BayesNet_size(self)

    def log10DomainSize(self) -> "double":
        r"""log10DomainSize(self) -> double"""
        return _pyAgrum.BayesNet_log10DomainSize(self)

    def minimalCondSet(self, *args) -> "PyObject *":
        r"""
        minimalCondSet(self, target, list) -> PyObject
        minimalCondSet(self, targets, list) -> PyObject *

        Returns, given one or many targets and a list of variables, the minimal set of those needed to calculate the target/targets.

        Parameters
        ----------
        target : int
        	The id of the target
        targets : list
        	The ids of the targets
        list : list
        	The list of available variables

        Returns
        -------
        Set
        	The minimal set of variables

        """
        return _pyAgrum.BayesNet_minimalCondSet(self, *args)

    def isIndependent(self, *args) -> "bool":
        r"""
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, X, Y) -> bool
        """
        return _pyAgrum.BayesNet_isIndependent(self, *args)

    def names(self) -> "PyObject *":
        r"""
        names(self) -> PyObject *

        Returns
        -------
        list
        	The names of the graph variables

        """
        return _pyAgrum.BayesNet_names(self)

    def nodes(self) -> "PyObject *":
        r"""
        nodes(self) -> PyObject *

        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.BayesNet_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def arcs(self) -> "PyObject *":
        r"""
        arcs(self) -> PyObject *

        Returns
        -------
        list
        	The lisf of arcs in the IBayesNet

        """
        return _pyAgrum.BayesNet_arcs(self)

    def parents(self, norid: "PyObject *") -> "PyObject *":
        r"""
        parents(self, norid) -> PyObject *

        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.BayesNet_parents(self, norid)

    def children(self, norid: "PyObject *") -> "PyObject *":
        r"""
        children(self, norid) -> PyObject *

        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.BayesNet_children(self, norid)

    def family(self, norid: "PyObject *") -> "PyObject *":
        r"""family(self, norid) -> PyObject *"""
        return _pyAgrum.BayesNet_family(self, norid)

    def descendants(self, norid: "PyObject *") -> "PyObject *":
        r"""descendants(self, norid) -> PyObject *"""
        return _pyAgrum.BayesNet_descendants(self, norid)

    def ancestors(self, norid: "PyObject *") -> "PyObject *":
        r"""ancestors(self, norid) -> PyObject *"""
        return _pyAgrum.BayesNet_ancestors(self, norid)

    def moralizedAncestralGraph(self, nodes: "PyObject *") -> "gum::UndiGraph":
        r"""moralizedAncestralGraph(self, nodes) -> UndiGraph"""
        return _pyAgrum.BayesNet_moralizedAncestralGraph(self, nodes)

    def addStructureListener(self,whenNodeAdded=None,whenNodeDeleted=None,whenArcAdded=None,whenArcDeleted=None):
        """
        Add the listeners in parameters to the list of existing ones.

        Parameters
        ----------
        whenNodeAdded : lambda expression
          a function for when a node is added
        whenNodeDeleted : lambda expression
          a function for when a node is removed
        whenArcAdded : lambda expression
          a function for when an arc is added
        whenArcDeleted : lambda expression
          a function for when an arc is removed
        """
        if [whenNodeAdded,whenNodeDeleted,whenArcAdded,whenArcDeleted]==[None,None,None,None]:
          return

        if not hasattr(self,"_listeners"):
          self._listeners=[]

        nl = PythonBNListener(self, self.variableNodeMap())
        if whenNodeAdded is not None:
          nl.setWhenNodeAdded(whenNodeAdded)
        if whenNodeDeleted is not None:
          nl.setWhenNodeDeleted(whenNodeDeleted)
        if whenArcAdded is not None:
          nl.setWhenArcAdded(whenArcAdded)
        if whenArcDeleted is not None:
          nl.setWhenArcDeleted(whenArcDeleted)

        self._listeners.append(nl)


    def loadBIF(self, *args) -> "std::string":
        r"""
        loadBIF(self, name, l=(PyObject *) 0) -> std::string

        Load a BIF file.

        Parameters
        ----------
        name : str
        	the file's name
        l : list
        	list of functions to execute

        Raises
        --------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_loadBIF(self, *args)

    def saveBIF(self, name: "std::string") -> "void":
        r"""
        saveBIF(self, name)

        Save the BayesNet in a BIF file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_saveBIF(self, name)

    def loadDSL(self, *args) -> "std::string":
        r"""
        loadDSL(self, name, l=(PyObject *) 0) -> std::string

        Load a DSL file.

        Parameters
        ----------
        name : str
        	the file's name
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_loadDSL(self, *args)

    def saveDSL(self, name: "std::string") -> "void":
        r"""
        saveDSL(self, name)

        Save the BayesNet in a DSL file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_saveDSL(self, name)

    def loadNET(self, *args) -> "std::string":
        r"""
        loadNET(self, name, l=(PyObject *) 0) -> std::string

        Load a NET file.

        Parameters
        ----------
        name : str
        	the name's file
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_loadNET(self, *args)

    def saveNET(self, name: "std::string") -> "void":
        r"""
        saveNET(self, name)

        Save the BayesNet in a NET file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_saveNET(self, name)

    def loadO3PRM(self, *args) -> "std::string":
        r"""
        loadO3PRM(self, name, system="", classpath="", l=(PyObject *) 0) -> std::string

        Load an O3PRM file.

        Warnings
        --------
        The O3PRM language is the only language allowing to manipulate not only DiscretizedVariable but also RangeVariable and LabelizedVariable.

        Parameters
        ----------
        name : str
        	the file's name
        system : str
        	the system's name
        classpath : str
        	the classpath
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_loadO3PRM(self, *args)

    def saveO3PRM(self, name: "std::string") -> "void":
        r"""
        saveO3PRM(self, name)

        Save the BayesNet in an O3PRM file.

        Warnings
        --------
        The O3PRM language is the only language allowing to manipulate not only DiscretizedVariable but also RangeVariable and LabelizedVariable.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_saveO3PRM(self, name)

    def loadBIFXML(self, *args) -> "std::string":
        r"""
        loadBIFXML(self, name, l=(PyObject *) 0) -> std::string

        Load a BIFXML file.

        Parameters
        ----------
        name : str
        	the name's file
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_loadBIFXML(self, *args)

    def saveBIFXML(self, name: "std::string") -> "void":
        r"""
        saveBIFXML(self, name)

        Save the BayesNet in a BIFXML file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_saveBIFXML(self, name)

    def loadUAI(self, *args) -> "std::string":
        r"""
        loadUAI(self, name, l=(PyObject *) 0) -> std::string

        Load an UAI file.

        Parameters
        ----------
        name : str
        	the name's file
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_loadUAI(self, *args)

    def saveUAI(self, name: "std::string") -> "void":
        r"""
        saveUAI(self, name)

        Save the BayesNet in an UAI file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_saveUAI(self, name)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.BayesNet___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.BayesNet___str__(self)

# Register BayesNet in _pyAgrum:
_pyAgrum.BayesNet_swigregister(BayesNet)

def BayesNet_fastPrototype(dotlike: "std::string const &", domainSize: "gum::Size"=2) -> "gum::BayesNet< double >":
    r"""
    BayesNet_fastPrototype(dotlike, domainSize=2) -> BayesNet

    Create a Bayesian network with a dot-like syntax which specifies:
        - the structure 'a->b->c;b->d<-e;'.
        - the type of the variables with different syntax:

          - by default, a variable is a gum.RangeVariable using the default domain size (second argument)
          - with 'a[10]', the variable is a gum.RangeVariable using 10 as domain size (from 0 to 9)
          - with 'a[3,7]', the variable is a gum.RangeVariable using a domainSize from 3 to 7
          - with 'a[1,3.14,5,6.2]', the variable is a gum.DiscretizedVariable using the given ticks (at least 3 values)
          - with 'a{top|middle|bottom}', the variable is a gum.LabelizedVariable using the given labels.
          - with 'a{-1|5|0|3}', the variable is a gum.IntegerVariable using the sorted given values.

    Note 
    ----
      - If the dot-like string contains such a specification more than once for a variable, the first specification will be used.
      - the CPTs are randomly generated.
      - see also pyAgrum.fastBN.

    Examples
    --------
    >>> import pyAgrum as gum
    >>> bn=gum.BayesNet.fastPrototype('A->B[1,3]<-C{yes|No}->D[2,4]<-E[1,2.5,3.9]',6)

    Parameters
    ----------
    dotlike : str
            the string containing the specification
    domainSize : int
            the default domain size for variables

    Returns
    -------
    pyAgrum.BayesNet
            the resulting Bayesian network

    """
    return _pyAgrum.BayesNet_fastPrototype(dotlike, domainSize)

class BayesNetFragment(IBayesNet, ):
    r"""



    BayesNetFragment represents a part of a Bayesian network (subset of nodes). By default, the arcs and the CPTs are the same as the BN but local CPTs can be build to express different local dependencies. All the non local CPTs are not copied. Therefore a BayesNetFragment is a light object.

    BayesNetFragment(BayesNet bn) -> BayesNetFragment
        Parameters:
          * **bn** (*pyAgrum.BayesNet*) -- the bn refered by the fragment

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> BayesNetFragment"""
        _pyAgrum.BayesNetFragment_swiginit(self, _pyAgrum.new_BayesNetFragment(bn))
    __swig_destroy__ = _pyAgrum.delete_BayesNetFragment

    def whenNodeAdded(self, src: "void const *", id: "gum::NodeId") -> "void":
        r"""whenNodeAdded(self, src, id)"""
        return _pyAgrum.BayesNetFragment_whenNodeAdded(self, src, id)

    def whenNodeDeleted(self, src: "void const *", id: "gum::NodeId") -> "void":
        r"""whenNodeDeleted(self, src, id)"""
        return _pyAgrum.BayesNetFragment_whenNodeDeleted(self, src, id)

    def whenArcAdded(self, src: "void const *", _from: "gum::NodeId", to: "gum::NodeId") -> "void":
        r"""whenArcAdded(self, src, _from, to)"""
        return _pyAgrum.BayesNetFragment_whenArcAdded(self, src, _from, to)

    def whenArcDeleted(self, src: "void const *", _from: "gum::NodeId", to: "gum::NodeId") -> "void":
        r"""whenArcDeleted(self, src, _from, to)"""
        return _pyAgrum.BayesNetFragment_whenArcDeleted(self, src, _from, to)

    def cpt(self, *args) -> "gum::Potential< double > const &":
        r"""
        cpt(self, varId) -> Potential
        cpt(self, name) -> Potential

        Returns the CPT of a variable.

        Parameters
        ----------
        VarId : int
        	A variable's id in the pyAgrum.IBayesNet.
        name : str
        	A variable's name in the pyAgrum.IBayesNet.

        Returns
        -------
        pyAgrum.Potential
        	The variable's CPT. 

        Raises
        ------
        gum.NotFound 
        	If no variable's id matches varId. 

        """
        return _pyAgrum.BayesNetFragment_cpt(self, *args)

    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        r"""
        variableNodeMap(self) -> VariableNodeMap

        Returns
        -------
        pyAgrum.variableNodeMap
        	the variable node map

        """
        return _pyAgrum.BayesNetFragment_variableNodeMap(self)

    def variable(self, *args) -> "gum::DiscreteVariable const &":
        r"""
        variable(self, id) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable

        Parameters
        ----------
        id : int
        	a variable's id
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNetFragment_variable(self, *args)

    def nodeId(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        nodeId(self, var) -> gum::NodeId

        Parameters
        ----------
        var : pyAgrum.DiscreteVariable
        	a variable

        Returns
        -------
        int
        	the id of the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNetFragment_nodeId(self, var)

    def idFromName(self, name: "std::string const &") -> "gum::NodeId":
        r"""
        idFromName(self, name) -> gum::NodeId

        Returns a variable's id given its name in the graph.

        Parameters
        ----------
        name : str
        	The variable's name from which the id is returned.

        Returns
        -------
        int :
        	The variable's node id.

        Raises
        ------
        gum.NotFound
        	If name does not match a variable in the graph

        """
        return _pyAgrum.BayesNetFragment_idFromName(self, name)

    def variableFromName(self, name: "std::string const &") -> "gum::DiscreteVariable const &":
        r"""
        variableFromName(self, name) -> DiscreteVariable

        Parameters
        ----------
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNetFragment_variableFromName(self, name)

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.BayesNetFragment_toDot(self)

    def isInstalledNode(self, *args) -> "bool":
        r"""
        isInstalledNode(self, id) -> bool
        isInstalledNode(self, name) -> bool

        Check if a node is in the fragment

        Parameters
        ----------
        n : int, str
        	the id or the name of the variable.

        """
        return _pyAgrum.BayesNetFragment_isInstalledNode(self, *args)

    def installNode(self, *args) -> "void":
        r"""
        installNode(self, id)
        installNode(self, name)

        Add a node to the fragment. The arcs that can be added between installed nodes are created.
        No specific CPT are created. Then either the parents of the node are already in the fragment 
        and the node is consistant, or the parents are not in the fragment and the node is not consistant.

        Parameters
        ----------
        n : int, str
        	the id or the name of the variable.

        Raises
        ------
        gum.NotFound
          if the node is not found.

        """
        return _pyAgrum.BayesNetFragment_installNode(self, *args)

    def installAscendants(self, *args) -> "void":
        r"""
        installAscendants(self, id)
        installAscendants(self, name)

        Add the variable and all its ascendants in the fragment. No inconsistant node are created.

        Parameters
        ----------
        n : int, str
        	the id or the name of the variable.

        Raises
        ------
        gum.NotFound
          if the node is not found.

        """
        return _pyAgrum.BayesNetFragment_installAscendants(self, *args)

    def uninstallNode(self, *args) -> "void":
        r"""
        uninstallNode(self, id)
        uninstallNode(self, name)

        Remove a node from the fragment. The fragment can become inconsistant.

        Parameters
        ----------
        n : int, str
        	the id or the name of the variable.

        Raises
        ------
        gum.NotFound
          if the node is not found.

        """
        return _pyAgrum.BayesNetFragment_uninstallNode(self, *args)

    def installMarginal(self, *args) -> "void":
        r"""
        installMarginal(self, id, pot)
        installMarginal(self, name, pot)

        Install a local marginal for a node. Doing so, it removes the parents of the node in the fragment.

        Parameters
        ----------
        n : int, str
        	the id or the name of the variable.
        pot : Potential
          the Potential (marginal) to install

        Raises
        ------
        gum.NotFound
          if the node is not found.

        """
        return _pyAgrum.BayesNetFragment_installMarginal(self, *args)

    def installCPT(self, *args) -> "void":
        r"""
        installCPT(self, id, pot)
        installCPT(self, name, pot)

        Install a local CPT for a node. Doing so, it changes the parents of the node in the fragment.

        Parameters
        ----------
        n : int, str
        	the id or the name of the variable.
        pot : Potential
          the Potential to install

        Raises
        ------
        gum.NotFound
          if the node is not found.

        """
        return _pyAgrum.BayesNetFragment_installCPT(self, *args)

    def uninstallCPT(self, *args) -> "void":
        r"""
        uninstallCPT(self, id)
        uninstallCPT(self, name)

        Remove a local CPT. The fragment can become inconsistant.

        Parameters
        ----------
        n : int, str
        	the id or the name of the variable.

        Raises
        ------
        gum.NotFound
          if the node is not found.

        """
        return _pyAgrum.BayesNetFragment_uninstallCPT(self, *args)

    def checkConsistency(self, *args) -> "bool":
        r"""
        checkConsistency(self, id) -> bool
        checkConsistency(self, name) -> bool
        checkConsistency(self) -> bool

        If a variable is added to the fragment but not its parents, there is no CPT consistant for this variable. This function checks the consistency for a variable of for all.

        Parameters
        ----------

        n : int, str (optional)
        	the id or the name of the variable. If no argument, the function checks all the variables.

        Returns
        -------
        boolean
        	True if the variable(s) is consistant.

        Raises
        ------
        gum.NotFound
          if the node is not found.

        """
        return _pyAgrum.BayesNetFragment_checkConsistency(self, *args)

    def toBN(self) -> "gum::BayesNet< double >":
        r"""
        toBN(self) -> BayesNet

        Create a BayesNet from a fragment.

        Raises
        ------
        gum.OperationNotAllowed
          if the fragment is not consistent.

        """
        return _pyAgrum.BayesNetFragment_toBN(self)

    def dag(self) -> "gum::DAG const &":
        r"""
        dag(self) -> DAG

        Returns
        -------
        pyAgrum.DAG
        	a constant reference to the dag of this BayesNet.

        """
        val = _pyAgrum.BayesNetFragment_dag(self)

        val = DAG(val) # copying the DAG


        return val


    def minimalCondSet(self, *args) -> "PyObject *":
        r"""
        minimalCondSet(self, target, list) -> PyObject
        minimalCondSet(self, targets, list) -> PyObject *

        Returns, given one or many targets and a list of variables, the minimal set of those needed to calculate the target/targets.

        Parameters
        ----------
        target : int
        	The id of the target
        targets : list
        	The ids of the targets
        list : list
        	The list of available variables

        Returns
        -------
        Set
        	The minimal set of variables

        """
        return _pyAgrum.BayesNetFragment_minimalCondSet(self, *args)

    def isIndependent(self, *args) -> "bool":
        r"""
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, X, Y) -> bool
        """
        return _pyAgrum.BayesNetFragment_isIndependent(self, *args)

    def names(self) -> "PyObject *":
        r"""
        names(self) -> PyObject *

        Returns
        -------
        list
        	The names of the graph variables

        """
        return _pyAgrum.BayesNetFragment_names(self)

    def nodes(self) -> "PyObject *":
        r"""
        nodes(self) -> PyObject *

        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.BayesNetFragment_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def arcs(self) -> "PyObject *":
        r"""
        arcs(self) -> PyObject *

        Returns
        -------
        list
        	The lisf of arcs in the IBayesNet

        """
        return _pyAgrum.BayesNetFragment_arcs(self)

    def parents(self, norid: "PyObject *") -> "PyObject *":
        r"""
        parents(self, norid) -> PyObject *

        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.BayesNetFragment_parents(self, norid)

    def children(self, norid: "PyObject *") -> "PyObject *":
        r"""
        children(self, norid) -> PyObject *

        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.BayesNetFragment_children(self, norid)

    def family(self, norid: "PyObject *") -> "PyObject *":
        r"""family(self, norid) -> PyObject *"""
        return _pyAgrum.BayesNetFragment_family(self, norid)

    def descendants(self, norid: "PyObject *") -> "PyObject *":
        r"""descendants(self, norid) -> PyObject *"""
        return _pyAgrum.BayesNetFragment_descendants(self, norid)

    def ancestors(self, norid: "PyObject *") -> "PyObject *":
        r"""ancestors(self, norid) -> PyObject *"""
        return _pyAgrum.BayesNetFragment_ancestors(self, norid)

    def moralizedAncestralGraph(self, nodes: "PyObject *") -> "gum::UndiGraph":
        r"""moralizedAncestralGraph(self, nodes) -> UndiGraph"""
        return _pyAgrum.BayesNetFragment_moralizedAncestralGraph(self, nodes)

    def addStructureListener(self,whenNodeAdded=None,whenNodeDeleted=None,whenArcAdded=None,whenArcDeleted=None):
        """
        Add the listeners in parameters to the list of existing ones.

        Parameters
        ----------
        whenNodeAdded : lambda expression
          a function for when a node is added
        whenNodeDeleted : lambda expression
          a function for when a node is removed
        whenArcAdded : lambda expression
          a function for when an arc is added
        whenArcDeleted : lambda expression
          a function for when an arc is removed
        """
        if [whenNodeAdded,whenNodeDeleted,whenArcAdded,whenArcDeleted]==[None,None,None,None]:
          return

        if not hasattr(self,"_listeners"):
          self._listeners=[]

        nl = PythonBNListener(self, self.variableNodeMap())
        if whenNodeAdded is not None:
          nl.setWhenNodeAdded(whenNodeAdded)
        if whenNodeDeleted is not None:
          nl.setWhenNodeDeleted(whenNodeDeleted)
        if whenArcAdded is not None:
          nl.setWhenArcAdded(whenArcAdded)
        if whenArcDeleted is not None:
          nl.setWhenArcDeleted(whenArcDeleted)

        self._listeners.append(nl)


# Register BayesNetFragment in _pyAgrum:
_pyAgrum.BayesNetFragment_swigregister(BayesNetFragment)

class IMarkovNet(UGmodel):
    r"""
    Proxy of C++ gum::IMarkovNet< double > class.
    Proxy of C++ gum::IMarkovNet< double > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __swig_destroy__ = _pyAgrum.delete_IMarkovNet

    def smallestFactorFromNode(self, *args) -> "gum::NodeSet const &":
        r"""
        smallestFactorFromNode(self, node) -> gum::NodeSet const
        smallestFactorFromNode(self, name) -> gum::NodeSet const &
        """
        return _pyAgrum.IMarkovNet_smallestFactorFromNode(self, *args)

    def factors(self) -> "gum::FactorTable< double > const &":
        r"""factors(self) -> gum::FactorTable< double > const &"""
        return _pyAgrum.IMarkovNet_factors(self)

    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        r"""variableNodeMap(self) -> VariableNodeMap"""
        return _pyAgrum.IMarkovNet_variableNodeMap(self)

    def variable(self, id: "gum::NodeId") -> "gum::DiscreteVariable const &":
        r"""variable(self, id) -> DiscreteVariable"""
        return _pyAgrum.IMarkovNet_variable(self, id)

    def nodeId(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""nodeId(self, var) -> gum::NodeId"""
        return _pyAgrum.IMarkovNet_nodeId(self, var)

    def idFromName(self, name: "std::string const &") -> "gum::NodeId":
        r"""idFromName(self, name) -> gum::NodeId"""
        return _pyAgrum.IMarkovNet_idFromName(self, name)

    def variableFromName(self, name: "std::string const &") -> "gum::DiscreteVariable const &":
        r"""variableFromName(self, name) -> DiscreteVariable"""
        return _pyAgrum.IMarkovNet_variableFromName(self, name)

    def __eq__(self, _from: "IMarkovNet") -> "bool":
        r"""__eq__(self, _from) -> bool"""
        return _pyAgrum.IMarkovNet___eq__(self, _from)

    def __ne__(self, _from: "IMarkovNet") -> "bool":
        r"""__ne__(self, _from) -> bool"""
        return _pyAgrum.IMarkovNet___ne__(self, _from)

    def dim(self) -> "gum::Size":
        r"""dim(self) -> gum::Size"""
        return _pyAgrum.IMarkovNet_dim(self)

    def maxVarDomainSize(self) -> "gum::Size":
        r"""maxVarDomainSize(self) -> gum::Size"""
        return _pyAgrum.IMarkovNet_maxVarDomainSize(self)

    def minParam(self) -> "double":
        r"""minParam(self) -> double"""
        return _pyAgrum.IMarkovNet_minParam(self)

    def maxParam(self) -> "double":
        r"""maxParam(self) -> double"""
        return _pyAgrum.IMarkovNet_maxParam(self)

    def minNonZeroParam(self) -> "double":
        r"""minNonZeroParam(self) -> double"""
        return _pyAgrum.IMarkovNet_minNonZeroParam(self)

    def maxNonOneParam(self) -> "double":
        r"""maxNonOneParam(self) -> double"""
        return _pyAgrum.IMarkovNet_maxNonOneParam(self)

    def toDot(self) -> "std::string":
        r"""toDot(self) -> std::string"""
        return _pyAgrum.IMarkovNet_toDot(self)

    def toDotAsFactorGraph(self) -> "std::string":
        r"""toDotAsFactorGraph(self) -> std::string"""
        return _pyAgrum.IMarkovNet_toDotAsFactorGraph(self)

    def names(self) -> "PyObject *":
        r"""names(self) -> PyObject *"""
        return _pyAgrum.IMarkovNet_names(self)

    def nodes(self) -> "PyObject *":
        r"""nodes(self) -> PyObject *"""
        return _pyAgrum.IMarkovNet_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def neighbours(self, norid: "PyObject *") -> "PyObject *":
        r"""neighbours(self, norid) -> PyObject *"""
        return _pyAgrum.IMarkovNet_neighbours(self, norid)

    def edges(self) -> "PyObject *":
        r"""edges(self) -> PyObject *"""
        return _pyAgrum.IMarkovNet_edges(self)

    def minimalCondSet(self, *args) -> "PyObject *":
        r"""
        minimalCondSet(self, target, soids) -> gum::NodeSet
        minimalCondSet(self, targets, soids) -> gum::NodeSet
        minimalCondSet(self, target, list) -> PyObject
        minimalCondSet(self, targets, list) -> PyObject *
        """
        return _pyAgrum.IMarkovNet_minimalCondSet(self, *args)

    def factor(self, *args) -> "gum::Potential< double > const &":
        r"""
        factor(self, varIds) -> Potential
        factor(self, nodeseq) -> Potential
        """
        return _pyAgrum.IMarkovNet_factor(self, *args)

    def isIndependent(self, *args) -> "bool":
        r"""
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, X, Y) -> bool
        """
        return _pyAgrum.IMarkovNet_isIndependent(self, *args)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.IMarkovNet___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.IMarkovNet___str__(self)

# Register IMarkovNet in _pyAgrum:
_pyAgrum.IMarkovNet_swigregister(IMarkovNet)

class MarkovNet(IMarkovNet):
    r"""



    MarkovNet represents a Markov Network.

    MarkovNet(name='') -> MarkovNet
        Parameters:
          * **name** (*str*) -- the name of the Bayes Net

    MarkovNet(source) -> MarkovNet
        Parameters:
          * **source** (*pyAgrum.MarkovNet*) -- the Markov network to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    @staticmethod
    def fastPrototype(dotlike: "std::string const &", domainSize: "gum::Size"=2) -> "gum::MarkovNet< double >":
        r"""
        fastPrototype(dotlike, domainSize=2) -> MarkovNet

        Create a Markov network with a modified dot-like syntax which specifies:
            - the structure ``a-b-c;b-d-e;``. The substring ``a-b-c`` indicates a factor with the scope (a,b,c).
            - the type of the variables with different syntax (cf documentation).

        Examples
        --------
        >>> import pyAgrum as gum
        >>> bn=gum.MarkovNet.fastPrototype('A--B[1,3]-C{yes|No}--D[2,4]--E[1,2.5,3.9]',6)

        Parameters
        ----------
        dotlike : str
                the string containing the specification
        domainSize : int
                the default domain size for variables

        Returns
        -------
        pyAgrum.MarkovNet
                the resulting Markov network 

        """
        return _pyAgrum.MarkovNet_fastPrototype(dotlike, domainSize)

    @staticmethod
    def fromBN(bn: "BayesNet") -> "gum::MarkovNet< double >":
        r"""fromBN(bn) -> MarkovNet"""
        return _pyAgrum.MarkovNet_fromBN(bn)
    __swig_destroy__ = _pyAgrum.delete_MarkovNet

    def __init__(self, *args):
        r"""
        __init__(self) -> MarkovNet
        __init__(self, name) -> MarkovNet
        __init__(self, source) -> MarkovNet
        """
        _pyAgrum.MarkovNet_swiginit(self, _pyAgrum.new_MarkovNet(*args))

    def smallestFactorFromNode(self, node: "gum::NodeId") -> "gum::NodeSet const &":
        r"""smallestFactorFromNode(self, node) -> gum::NodeSet const &"""
        return _pyAgrum.MarkovNet_smallestFactorFromNode(self, node)

    def factors(self) -> "gum::FactorTable< double > const &":
        r"""factors(self) -> gum::FactorTable< double > const &"""
        return _pyAgrum.MarkovNet_factors(self)

    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        r"""variableNodeMap(self) -> VariableNodeMap"""
        return _pyAgrum.MarkovNet_variableNodeMap(self)

    def add(self, *args) -> "gum::NodeId":
        r"""
        add(self, var) -> gum::NodeId
        add(self, name, nbrmod) -> gum::NodeId
        add(self, var, id) -> gum::NodeId

        Add a variable to the pyAgrum.MarkovNet. 

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added
        name : str 
        	the variable name
        nbrmod : int
        	the number of modalities for the new variable
        id : int
        	the variable forced id in the pyAgrum.MarkovNet

        Returns
        -------
        int 
        	the id of the new node

        Raises
        ------
        gum.DuplicateLabel
            If variable.name() is already used in this pyAgrum.MarkovNet.
        gum.NotAllowed
            If nbrmod is less than 2
        gum.DuplicateElement
            If id is already used.

        """
        return _pyAgrum.MarkovNet_add(self, *args)

    def clear(self) -> "void":
        r"""
        clear(self)

        Clear the whole MarkovNet  

        """
        return _pyAgrum.MarkovNet_clear(self)

    def erase(self, *args) -> "void":
        r"""
        erase(self, varId)
        erase(self, name)
        erase(self, var)

        Remove a variable from the gum::MarkovNet.

        Removes the corresponding variable from the gum::MarkovNet and from all of it's children gum::Potential.

        If no variable matches the given id, then nothing is done.

        Parameters
        ----------
        id : int
        	The variable's id to remove. 
        name : str
        	The variable's name to remove.
        var : pyAgrum.DiscreteVariable
        	A reference on the variable to remove. 

        """
        return _pyAgrum.MarkovNet_erase(self, *args)

    def variable(self, *args) -> "gum::DiscreteVariable const &":
        r"""
        variable(self, id) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable
        """
        return _pyAgrum.MarkovNet_variable(self, *args)

    def changeVariableName(self, *args) -> "void":
        r"""
        changeVariableName(self, id, new_name)
        changeVariableName(self, name, new_name)

        Changes a variable's name in the gum::MarkovNet.

        This will change the gum::DiscreteVariable names in the gum::MarkovNet.

        Parameters
        ----------
        new_name : str
        	the new name of the variable
        NodeId : int
        	the id of the node
        name : str
        	the name of the variable

        Raises
        ------
        gum.DuplicateLabel
            If new_name is already used in this MarkovNet.
        gum.NotFound
            If no variable matches id.

        """
        return _pyAgrum.MarkovNet_changeVariableName(self, *args)

    def changeVariableLabel(self, *args) -> "void":
        r"""
        changeVariableLabel(self, id, old_label, new_label)
        changeVariableLabel(self, name, old_label, new_label)

        change the label of the variable associated to nodeId to the new value.

        Parameters
        ----------
        id : int
        	the id of the node
        name : str
        	the name of the variable
        old_label : str
        	the new label
        new_label : str
        	the new label

        Raises
        ------
        gum.NotFound
            if id/name is not a variable or if old_label does not exist.

        """
        return _pyAgrum.MarkovNet_changeVariableLabel(self, *args)

    def nodeId(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""nodeId(self, var) -> gum::NodeId"""
        return _pyAgrum.MarkovNet_nodeId(self, var)

    def idFromName(self, name: "std::string const &") -> "gum::NodeId":
        r"""idFromName(self, name) -> gum::NodeId"""
        return _pyAgrum.MarkovNet_idFromName(self, name)

    def variableFromName(self, name: "std::string const &") -> "gum::DiscreteVariable const &":
        r"""variableFromName(self, name) -> DiscreteVariable"""
        return _pyAgrum.MarkovNet_variableFromName(self, name)

    def generateFactors(self) -> "void":
        r"""
        generateFactors(self)

        Randomly generates factors parameters for a given structure.

        """
        return _pyAgrum.MarkovNet_generateFactors(self)

    def generateFactor(self, vars: "gum::NodeSet const &") -> "void":
        r"""
        generateFactor(self, vars)

        Randomly generate factor parameters for a given factor in a given structure.

        Parameters
        ----------
        node : int
        	The variable's id.
        name : str 
        	The variable's name.

        """
        return _pyAgrum.MarkovNet_generateFactor(self, vars)

    def beginTopologyTransformation(self) -> "void":
        r"""beginTopologyTransformation(self)"""
        return _pyAgrum.MarkovNet_beginTopologyTransformation(self)

    def endTopologyTransformation(self) -> "void":
        r"""
        endTopologyTransformation(self)

        Terminates a sequence of insertions/deletions of arcs by adjusting all CPTs dimensions.
        End Multiple Change for all CPTs.

        Returns
        -------
        pyAgrum.MarkovNet

        """
        return _pyAgrum.MarkovNet_endTopologyTransformation(self)

    def graph(self) -> "gum::UndiGraph const &":
        r"""graph(self) -> UndiGraph"""
        return _pyAgrum.MarkovNet_graph(self)

    def size(self) -> "gum::Size":
        r"""size(self) -> gum::Size"""
        return _pyAgrum.MarkovNet_size(self)

    def log10DomainSize(self) -> "double":
        r"""log10DomainSize(self) -> double"""
        return _pyAgrum.MarkovNet_log10DomainSize(self)

    def names(self) -> "PyObject *":
        r"""names(self) -> PyObject *"""
        return _pyAgrum.MarkovNet_names(self)

    def nodes(self) -> "PyObject *":
        r"""nodes(self) -> PyObject *"""
        return _pyAgrum.MarkovNet_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def neighbours(self, norid: "PyObject *") -> "PyObject *":
        r"""neighbours(self, norid) -> PyObject *"""
        return _pyAgrum.MarkovNet_neighbours(self, norid)

    def edges(self) -> "PyObject *":
        r"""edges(self) -> PyObject *"""
        return _pyAgrum.MarkovNet_edges(self)

    def minimalCondSet(self, *args) -> "PyObject *":
        r"""
        minimalCondSet(self, target, list) -> PyObject
        minimalCondSet(self, targets, list) -> PyObject *
        """
        return _pyAgrum.MarkovNet_minimalCondSet(self, *args)

    def factor(self, *args) -> "gum::Potential< double > const &":
        r"""
        factor(self, varIds) -> Potential
        factor(self, varnames) -> Potential
        factor(self, nodeseq) -> Potential

        Returns the factor of a set of variables (if existing).

        Parameters
        ----------
        VarId : Set[int]
        	A variable's id in the pyAgrum.MarkovNet.
        name : Set[str]
        	A variable's name in the pyAgrum.MarkovNet.

        Returns
        -------
        pyAgrum.Potential
        	The factor of the set of nodes. 

        Raises
        ------
        gum.NotFound
            If no variable's id matches varId.

        """
        return _pyAgrum.MarkovNet_factor(self, *args)

    def isIndependent(self, *args) -> "bool":
        r"""
        isIndependent(self, X, Y, Z) -> bool
        isIndependent(self, X, Y) -> bool
        """
        return _pyAgrum.MarkovNet_isIndependent(self, *args)

    def loadUAI(self, *args) -> "std::string":
        r"""
        loadUAI(self, name, l=(PyObject *) 0) -> std::string

        Load an UAI file.

        Parameters
        ----------
        name : str
        	the name's file
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.MarkovNet_loadUAI(self, *args)

    def saveUAI(self, name: "std::string") -> "void":
        r"""
        saveUAI(self, name)

        Save the MarkovNet in an UAI file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.MarkovNet_saveUAI(self, name)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.MarkovNet___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.MarkovNet___str__(self)

    def addFactor(self, *args) -> "gum::Potential< double > const &":
        r"""
        addFactor(self, varnames) -> Potential
        addFactor(self, vars) -> Potential
        addFactor(self, factor) -> Potential
        addFactor(self, seq) -> Potential
        """
        return _pyAgrum.MarkovNet_addFactor(self, *args)

    def eraseFactor(self, *args) -> "void":
        r"""
        eraseFactor(self, vars)
        eraseFactor(self, varnames)
        eraseFactor(self, seq)
        """
        return _pyAgrum.MarkovNet_eraseFactor(self, *args)

    def addStructureListener(self,whenNodeAdded=None,whenNodeDeleted=None,whenEdgeAdded=None,whenedgeDeleted=None):
        """
        Add the listeners in parameters to the list of existing ones.

        Parameters
        ----------
        whenNodeAdded : lambda expression
          a function for when a node is added
        whenNodeDeleted : lambda expression
          a function for when a node is removed
        whenEdgeAdded : lambda expression
          a function for when an edge is added
        whenEdgeDeleted : lambda expression
          a function for when an edge is removed
        """
        if [whenNodeAdded,whenNodeDeleted,whenEdgeAdded,whenEdgeDeleted]==[None,None,None,None]:
          return

        if not hasattr(self,"_listeners"):
          self._listeners=[]

        nl = PythonMNListener(self, self.variableNodeMap())
        if whenNodeAdded is not None:
          nl.setWhenNodeAdded(whenNodeAdded)
        if whenNodeDeleted is not None:
          nl.setWhenNodeDeleted(whenNodeDeleted)
        if whenEdgeAdded is not None:
          nl.setWhenEdgeAdded(whenEdgeAdded)
        if whenEdgeDeleted is not None:
          nl.setWhenArcDeleted(whenEdgeDeleted)

        self._listeners.append(nl)


# Register MarkovNet in _pyAgrum:
_pyAgrum.MarkovNet_swigregister(MarkovNet)

def MarkovNet_fastPrototype(dotlike: "std::string const &", domainSize: "gum::Size"=2) -> "gum::MarkovNet< double >":
    r"""
    MarkovNet_fastPrototype(dotlike, domainSize=2) -> MarkovNet

    Create a Markov network with a modified dot-like syntax which specifies:
        - the structure ``a-b-c;b-d-e;``. The substring ``a-b-c`` indicates a factor with the scope (a,b,c).
        - the type of the variables with different syntax (cf documentation).

    Examples
    --------
    >>> import pyAgrum as gum
    >>> bn=gum.MarkovNet.fastPrototype('A--B[1,3]-C{yes|No}--D[2,4]--E[1,2.5,3.9]',6)

    Parameters
    ----------
    dotlike : str
            the string containing the specification
    domainSize : int
            the default domain size for variables

    Returns
    -------
    pyAgrum.MarkovNet
            the resulting Markov network 

    """
    return _pyAgrum.MarkovNet_fastPrototype(dotlike, domainSize)

def MarkovNet_fromBN(bn: "BayesNet") -> "gum::MarkovNet< double >":
    r"""MarkovNet_fromBN(bn) -> MarkovNet"""
    return _pyAgrum.MarkovNet_fromBN(bn)

class ShaferShenoyMNInference(object):
    r"""



    Class used for Shafer-Shenoy inferences for Markov network.

    ShaferShenoyInference(bn) -> ShaferShenoyInference
        Parameters:
            * **mn** (*pyAgrum.MarkovNet*) -- a Markov network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, MN: "IMarkovNet", use_binary_join_tree: "bool"=True):
        r"""__init__(self, MN, use_binary_join_tree=True) -> ShaferShenoyMNInference"""
        _pyAgrum.ShaferShenoyMNInference_swiginit(self, _pyAgrum.new_ShaferShenoyMNInference(MN, use_binary_join_tree))

        self._model=MN#first arg of the constructor



    __swig_destroy__ = _pyAgrum.delete_ShaferShenoyMNInference

    def setTriangulation(self, new_triangulation: "Triangulation") -> "void":
        r"""setTriangulation(self, new_triangulation)"""
        return _pyAgrum.ShaferShenoyMNInference_setTriangulation(self, new_triangulation)

    def joinTree(self) -> "gum::JoinTree const *":
        r"""
        joinTree(self) -> CliqueGraph

        Returns
        -------
        pyAgrum.CliqueGraph
          the current join tree used

        """
        return _pyAgrum.ShaferShenoyMNInference_joinTree(self)

    def junctionTree(self) -> "gum::JunctionTree const *":
        r"""
        junctionTree(self) -> CliqueGraph

        Returns
        -------
        pyAgrum.CliqueGraph
          the current junction tree

        """
        val = _pyAgrum.ShaferShenoyMNInference_junctionTree(self)

        val._engine=self


        return val


    def evidenceProbability(self) -> "double":
        r"""
        evidenceProbability(self) -> double

        Returns
        -------
        double
          the probability of evidence

        """
        return _pyAgrum.ShaferShenoyMNInference_evidenceProbability(self)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.ShaferShenoyMNInference_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.ShaferShenoyMNInference_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.ShaferShenoyMNInference_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.ShaferShenoyMNInference_evidenceImpact(self, target, evs)

    def jointMutualInformation(self, targets: "PyObject *") -> "double":
        r"""jointMutualInformation(self, targets) -> double"""
        return _pyAgrum.ShaferShenoyMNInference_jointMutualInformation(self, targets)

    def jointPosterior(self, targets: "PyObject *") -> "gum::Potential< double >":
        r"""
        jointPosterior(self, targets) -> Potential

        Compute the joint posterior of a set of nodes.

        Parameters
        ----------
        list :
          the list of nodes whose posterior joint probability is wanted


        Warnings
        --------
        The order of the variables given by the list here or when the jointTarget is declared can not be assumed to be used bu the Potential.

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior joint probability of the set of nodes.

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ShaferShenoyMNInference_jointPosterior(self, targets)

    def addJointTarget(self, targets: "PyObject *") -> "void":
        r"""
        addJointTarget(self, targets)

        Add a list of nodes as a new joint target. As a collateral effect, every node is added as a marginal target.

        Parameters
        ----------
        list
          a list of names of nodes

        Raises
        ------
        gum.UndefinedElement
          If some node(s) do not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_addJointTarget(self, targets)

    def eraseJointTarget(self, targets: "PyObject *") -> "void":
        r"""
        eraseJointTarget(self, targets)

        Remove, if existing, the joint target.

        Parameters
        ----------
        list
          a list of names or Ids of nodes

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_eraseJointTarget(self, targets)

    def isJointTarget(self, targets: "PyObject *") -> "bool":
        r"""
        isJointTarget(self, targets) -> bool

        Parameters
        ----------
        list
          a list of nodes ids or names.

        Returns
        -------
        bool
          True if target is a joint target.

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_isJointTarget(self, targets)

    def jointTargets(self) -> "PyObject *":
        r"""
        jointTargets(self) -> PyObject *

        Returns
        -------
        list
          the list of target sets

        """
        return _pyAgrum.ShaferShenoyMNInference_jointTargets(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.ShaferShenoyMNInference_makeInference(self)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.ShaferShenoyMNInference_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.ShaferShenoyMNInference_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.ShaferShenoyMNInference_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.ShaferShenoyMNInference_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyMNInference_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.ShaferShenoyMNInference_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the Shanon's entropy of a node given the observation

        """
        return _pyAgrum.ShaferShenoyMNInference_H(self, *args)

    def MN(self) -> "gum::IMarkovNet< double > const &":
        r"""MN(self) -> IMarkovNet"""
        return _pyAgrum.ShaferShenoyMNInference_MN(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ShaferShenoyMNInference_posterior(self, *args)

    def eraseAllJointTargets(self) -> "void":
        r"""
        eraseAllJointTargets(self)

        Clear all previously defined joint targets.

        """
        return _pyAgrum.ShaferShenoyMNInference_eraseAllJointTargets(self)

    def eraseAllMarginalTargets(self) -> "void":
        r"""
        eraseAllMarginalTargets(self)

        Clear all the previously defined marginal targets.

        """
        return _pyAgrum.ShaferShenoyMNInference_eraseAllMarginalTargets(self)

    def nbrJointTargets(self) -> "gum::Size":
        r"""
        nbrJointTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of joint targets

        """
        return _pyAgrum.ShaferShenoyMNInference_nbrJointTargets(self)

    def I(self, X: "gum::NodeId const", Y: "gum::NodeId const") -> "double":
        r"""
        I(self, X, Y) -> double

        Parameters
        ----------
        X : int or str
          a node Id or a node name
        Y : int or str
          another node Id or node name

        Returns
        -------
        double
          the Mutual Information of X and Y given the observation

        """
        return _pyAgrum.ShaferShenoyMNInference_I(self, X, Y)

    def VI(self, X: "gum::NodeId const", Y: "gum::NodeId const") -> "double":
        r"""
        VI(self, X, Y) -> double

        Parameters
        ----------
        X : int or str
           a node Id or a node name
        Y : int or str
           another node Id or node name

        Returns
        -------
        double
          variation of information between X and Y

        """
        return _pyAgrum.ShaferShenoyMNInference_VI(self, X, Y)

    def evidenceJointImpact(self, *args) -> "gum::Potential< double >":
        r"""
        evidenceJointImpact(self, targets, evs) -> Potential
        evidenceJointImpact(self, targets, evs) -> Potential

        Create a pyAgrum.Potential for P(joint targets|evs) (for all instanciation of targets and evs)

        Parameters
        ----------
        targets :
          (int) a node Id
        targets :
          (str) a node name
        evs : set
          a set of nodes ids or names.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(target|evs)

        Raises
        ------
        gum.Exception
          If some evidene entered into the Bayes net are incompatible (their joint proba = 0)

        """
        return _pyAgrum.ShaferShenoyMNInference_evidenceJointImpact(self, *args)

# Register ShaferShenoyMNInference in _pyAgrum:
_pyAgrum.ShaferShenoyMNInference_swigregister(ShaferShenoyMNInference)

class LazyPropagation(object):
    r"""



    Class used for Lazy Propagation

    LazyPropagation(bn) -> LazyPropagation
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(self, BN, arg3=DSEP_BAYESBALL_POTENTIALS, arg4=FIND_BARREN_NODES, use_binary_join_tree=True) -> LazyPropagation"""
        _pyAgrum.LazyPropagation_swiginit(self, _pyAgrum.new_LazyPropagation(*args))

        self._model=args[0]



    __swig_destroy__ = _pyAgrum.delete_LazyPropagation

    def setTriangulation(self, new_triangulation: "Triangulation") -> "void":
        r"""setTriangulation(self, new_triangulation)"""
        return _pyAgrum.LazyPropagation_setTriangulation(self, new_triangulation)

    def setRelevantPotentialsFinderType(self, type: "gum::RelevantPotentialsFinderType") -> "void":
        r"""
        setRelevantPotentialsFinderType(self, type)

        sets how we determine the relevant potentials to combine

        When a clique sends a message to a separator, it first constitute the set of the potentials it contains and of the potentials contained in the messages it received. If RelevantPotentialsFinderType = FIND_ALL, all these potentials are combined and projected to produce the message sent to the separator. If RelevantPotentialsFinderType = DSEP_BAYESBALL_NODES, then only the set of potentials d-connected to the variables of the separator are kept for combination and projection.

        0 = FIND_ALL
        1 = DSEP_BAYESBALL_NODES
        2 = DSEP_BAYESBALL_POTENTIALS
        3 = DSEP_KOLLER_FRIEDMAN_2009

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.LazyPropagation_setRelevantPotentialsFinderType(self, type)

    def setFindBarrenNodesType(self, type: "gum::FindBarrenNodesType") -> "void":
        r"""
        setFindBarrenNodesType(self, type)

        sets how we determine barren nodes

        Barren nodes are unnecessary for probability inference, so they can be safely discarded in this case (type = FIND_BARREN_NODES). This speeds-up inference. However, there are some cases in which we do not want to remove barren nodes, typically when we want to answer queries such as Most Probable Explanations (MPE).

        0 = FIND_NO_BARREN_NODES
        1 = FIND_BARREN_NODES

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.LazyPropagation_setFindBarrenNodesType(self, type)

    def joinTree(self) -> "gum::JoinTree const *":
        r"""
        joinTree(self) -> CliqueGraph

        Returns
        -------
        pyAgrum.CliqueGraph
          the current join tree used

        """
        return _pyAgrum.LazyPropagation_joinTree(self)

    def junctionTree(self) -> "gum::JunctionTree const *":
        r"""
        junctionTree(self) -> CliqueGraph

        Returns
        -------
        pyAgrum.CliqueGraph
          the current junction tree

        """
        val = _pyAgrum.LazyPropagation_junctionTree(self)

        val._engine=self


        return val


    def evidenceProbability(self) -> "double":
        r"""
        evidenceProbability(self) -> double

        Returns
        -------
        double
          the probability of evidence

        """
        return _pyAgrum.LazyPropagation_evidenceProbability(self)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.LazyPropagation_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.LazyPropagation_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LazyPropagation_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LazyPropagation_evidenceImpact(self, target, evs)

    def jointMutualInformation(self, targets: "PyObject *") -> "double":
        r"""jointMutualInformation(self, targets) -> double"""
        return _pyAgrum.LazyPropagation_jointMutualInformation(self, targets)

    def jointPosterior(self, targets: "PyObject *") -> "gum::Potential< double >":
        r"""
        jointPosterior(self, targets) -> Potential

        Compute the joint posterior of a set of nodes.

        Parameters
        ----------
        list :
          the list of nodes whose posterior joint probability is wanted


        Warnings
        --------
        The order of the variables given by the list here or when the jointTarget is declared can not be assumed to be used bu the Potential.

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior joint probability of the set of nodes.

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LazyPropagation_jointPosterior(self, targets)

    def addJointTarget(self, targets: "PyObject *") -> "void":
        r"""
        addJointTarget(self, targets)

        Add a list of nodes as a new joint target. As a collateral effect, every node is added as a marginal target.

        Parameters
        ----------
        list
          a list of names of nodes

        Raises
        ------
        gum.UndefinedElement
          If some node(s) do not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_addJointTarget(self, targets)

    def eraseJointTarget(self, targets: "PyObject *") -> "void":
        r"""
        eraseJointTarget(self, targets)

        Remove, if existing, the joint target.

        Parameters
        ----------
        list
          a list of names or Ids of nodes

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LazyPropagation_eraseJointTarget(self, targets)

    def isJointTarget(self, targets: "PyObject *") -> "bool":
        r"""
        isJointTarget(self, targets) -> bool

        Parameters
        ----------
        list
          a list of nodes ids or names.

        Returns
        -------
        bool
          True if target is a joint target.

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LazyPropagation_isJointTarget(self, targets)

    def jointTargets(self) -> "PyObject *":
        r"""
        jointTargets(self) -> PyObject *

        Returns
        -------
        list
          the list of target sets

        """
        return _pyAgrum.LazyPropagation_jointTargets(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.LazyPropagation_makeInference(self)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LazyPropagation_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LazyPropagation_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LazyPropagation_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LazyPropagation_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.LazyPropagation_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.LazyPropagation_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.LazyPropagation_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LazyPropagation_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LazyPropagation_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LazyPropagation_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LazyPropagation_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LazyPropagation_BN(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LazyPropagation_posterior(self, *args)

    def eraseAllJointTargets(self) -> "void":
        r"""
        eraseAllJointTargets(self)

        Clear all previously defined joint targets.

        """
        return _pyAgrum.LazyPropagation_eraseAllJointTargets(self)

    def eraseAllMarginalTargets(self) -> "void":
        r"""
        eraseAllMarginalTargets(self)

        Clear all the previously defined marginal targets.

        """
        return _pyAgrum.LazyPropagation_eraseAllMarginalTargets(self)

    def nbrJointTargets(self) -> "gum::Size":
        r"""
        nbrJointTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of joint targets

        """
        return _pyAgrum.LazyPropagation_nbrJointTargets(self)

    def I(self, *args) -> "double":
        r"""
        I(self, X, Y) -> double
        I(self, X, Y) -> double

        Parameters
        ----------
        X : int or str
           a node Id or a node name
        Y : int or str
           another node Id or node name

           Returns
        -------
        double
           the Mutual Information of X and Y given the observation

        """
        return _pyAgrum.LazyPropagation_I(self, *args)

    def VI(self, *args) -> "double":
        r"""
        VI(self, X, Y) -> double
        VI(self, X, Y) -> double

        Parameters
        ----------
        X : int or str
           a node Id or a node name
        Y : int or str
           another node Id or node name

           Returns
        -------
        double
           variation of information between X and Y

        """
        return _pyAgrum.LazyPropagation_VI(self, *args)

    def evidenceJointImpact(self, *args) -> "gum::Potential< double >":
        r"""
        evidenceJointImpact(self, targets, evs) -> Potential
        evidenceJointImpact(self, targets, evs) -> Potential

        Create a pyAgrum.Potential for P(joint targets|evs) (for all instanciation of targets and evs)

        Parameters
        ----------
        targets :
          (int) a node Id
        targets :
          (str) a node name
        evs : set
          a set of nodes ids or names.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(target|evs)

        Raises
        ------
        gum.Exception
          If some evidene entered into the Bayes net are incompatible (their joint proba = 0)

        """
        return _pyAgrum.LazyPropagation_evidenceJointImpact(self, *args)

# Register LazyPropagation in _pyAgrum:
_pyAgrum.LazyPropagation_swigregister(LazyPropagation)

class ShaferShenoyInference(object):
    r"""



    Class used for Shafer-Shenoy inferences.

    ShaferShenoyInference(bn) -> ShaferShenoyInference
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(self, BN, barren_type=FIND_BARREN_NODES, use_binary_join_tree=True) -> ShaferShenoyInference"""
        _pyAgrum.ShaferShenoyInference_swiginit(self, _pyAgrum.new_ShaferShenoyInference(*args))

        self._model=args[0]



    __swig_destroy__ = _pyAgrum.delete_ShaferShenoyInference

    def setTriangulation(self, new_triangulation: "Triangulation") -> "void":
        r"""setTriangulation(self, new_triangulation)"""
        return _pyAgrum.ShaferShenoyInference_setTriangulation(self, new_triangulation)

    def setFindBarrenNodesType(self, type: "gum::FindBarrenNodesType") -> "void":
        r"""
        setFindBarrenNodesType(self, type)

        sets how we determine barren nodes

        Barren nodes are unnecessary for probability inference, so they can be safely discarded in this case (type = FIND_BARREN_NODES). This speeds-up inference. However, there are some cases in which we do not want to remove barren nodes, typically when we want to answer queries such as Most Probable Explanations (MPE).

        0 = FIND_NO_BARREN_NODES
        1 = FIND_BARREN_NODES

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.ShaferShenoyInference_setFindBarrenNodesType(self, type)

    def joinTree(self) -> "gum::JoinTree const *":
        r"""
        joinTree(self) -> CliqueGraph

        Returns
        -------
        pyAgrum.CliqueGraph
          the current join tree used

        """
        return _pyAgrum.ShaferShenoyInference_joinTree(self)

    def junctionTree(self) -> "gum::JunctionTree const *":
        r"""
        junctionTree(self) -> CliqueGraph

        Returns
        -------
        pyAgrum.CliqueGraph
          the current junction tree

        """
        val = _pyAgrum.ShaferShenoyInference_junctionTree(self)

        val._engine=self


        return val


    def evidenceProbability(self) -> "double":
        r"""
        evidenceProbability(self) -> double

        Returns
        -------
        double
          the probability of evidence

        """
        return _pyAgrum.ShaferShenoyInference_evidenceProbability(self)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.ShaferShenoyInference_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.ShaferShenoyInference_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.ShaferShenoyInference_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.ShaferShenoyInference_evidenceImpact(self, target, evs)

    def jointMutualInformation(self, targets: "PyObject *") -> "double":
        r"""jointMutualInformation(self, targets) -> double"""
        return _pyAgrum.ShaferShenoyInference_jointMutualInformation(self, targets)

    def jointPosterior(self, targets: "PyObject *") -> "gum::Potential< double >":
        r"""
        jointPosterior(self, targets) -> Potential

        Compute the joint posterior of a set of nodes.

        Parameters
        ----------
        list :
          the list of nodes whose posterior joint probability is wanted


        Warnings
        --------
        The order of the variables given by the list here or when the jointTarget is declared can not be assumed to be used bu the Potential.

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior joint probability of the set of nodes.

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ShaferShenoyInference_jointPosterior(self, targets)

    def addJointTarget(self, targets: "PyObject *") -> "void":
        r"""
        addJointTarget(self, targets)

        Add a list of nodes as a new joint target. As a collateral effect, every node is added as a marginal target.

        Parameters
        ----------
        list
          a list of names of nodes

        Raises
        ------
        gum.UndefinedElement
          If some node(s) do not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_addJointTarget(self, targets)

    def eraseJointTarget(self, targets: "PyObject *") -> "void":
        r"""
        eraseJointTarget(self, targets)

        Remove, if existing, the joint target.

        Parameters
        ----------
        list
          a list of names or Ids of nodes

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_eraseJointTarget(self, targets)

    def isJointTarget(self, targets: "PyObject *") -> "bool":
        r"""
        isJointTarget(self, targets) -> bool

        Parameters
        ----------
        list
          a list of nodes ids or names.

        Returns
        -------
        bool
          True if target is a joint target.

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_isJointTarget(self, targets)

    def jointTargets(self) -> "PyObject *":
        r"""
        jointTargets(self) -> PyObject *

        Returns
        -------
        list
          the list of target sets

        """
        return _pyAgrum.ShaferShenoyInference_jointTargets(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.ShaferShenoyInference_makeInference(self)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.ShaferShenoyInference_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.ShaferShenoyInference_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.ShaferShenoyInference_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.ShaferShenoyInference_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.ShaferShenoyInference_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.ShaferShenoyInference_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.ShaferShenoyInference_BN(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ShaferShenoyInference_posterior(self, *args)

    def eraseAllJointTargets(self) -> "void":
        r"""
        eraseAllJointTargets(self)

        Clear all previously defined joint targets.

        """
        return _pyAgrum.ShaferShenoyInference_eraseAllJointTargets(self)

    def eraseAllMarginalTargets(self) -> "void":
        r"""
        eraseAllMarginalTargets(self)

        Clear all the previously defined marginal targets.

        """
        return _pyAgrum.ShaferShenoyInference_eraseAllMarginalTargets(self)

    def nbrJointTargets(self) -> "gum::Size":
        r"""
        nbrJointTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of joint targets

        """
        return _pyAgrum.ShaferShenoyInference_nbrJointTargets(self)

    def I(self, *args) -> "double":
        r"""
        I(self, X, Y) -> double
        I(self, X, Y) -> double

        Parameters
        ----------
        X : int or str
           a node Id or a node name
        Y : int or str
           another node Id or node name

           Returns
        -------
        double
           the Mutual Information of X and Y given the observation

        """
        return _pyAgrum.ShaferShenoyInference_I(self, *args)

    def VI(self, *args) -> "double":
        r"""
        VI(self, X, Y) -> double
        VI(self, X, Y) -> double

        Parameters
        ----------
        X : int or str
           a node Id or a node name
        Y : int or str
           another node Id or node name

           Returns
        -------
        double
           variation of information between X and Y

        """
        return _pyAgrum.ShaferShenoyInference_VI(self, *args)

    def evidenceJointImpact(self, *args) -> "gum::Potential< double >":
        r"""
        evidenceJointImpact(self, targets, evs) -> Potential
        evidenceJointImpact(self, targets, evs) -> Potential

        Create a pyAgrum.Potential for P(joint targets|evs) (for all instanciation of targets and evs)

        Parameters
        ----------
        targets :
          (int) a node Id
        targets :
          (str) a node name
        evs : set
          a set of nodes ids or names.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(target|evs)

        Raises
        ------
        gum.Exception
          If some evidene entered into the Bayes net are incompatible (their joint proba = 0)

        """
        return _pyAgrum.ShaferShenoyInference_evidenceJointImpact(self, *args)

# Register ShaferShenoyInference in _pyAgrum:
_pyAgrum.ShaferShenoyInference_swigregister(ShaferShenoyInference)

class VariableElimination(object):
    r"""



    Class used for Variable Elimination inference algorithm.

    VariableElimination(bn) -> VariableElimination
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(self, BN, relevant_type=DSEP_BAYESBALL_POTENTIALS, arg4=FIND_BARREN_NODES) -> VariableElimination"""
        _pyAgrum.VariableElimination_swiginit(self, _pyAgrum.new_VariableElimination(*args))

        self._model=args[0]



    __swig_destroy__ = _pyAgrum.delete_VariableElimination

    def setTriangulation(self, new_triangulation: "Triangulation") -> "void":
        r"""setTriangulation(self, new_triangulation)"""
        return _pyAgrum.VariableElimination_setTriangulation(self, new_triangulation)

    def setRelevantPotentialsFinderType(self, type: "gum::RelevantPotentialsFinderType") -> "void":
        r"""
        setRelevantPotentialsFinderType(self, type)

        sets how we determine the relevant potentials to combine

        When a clique sends a message to a separator, it first constitute the set of the potentials it contains and of the potentials contained in the messages it received. If RelevantPotentialsFinderType = FIND_ALL, all these potentials are combined and projected to produce the message sent to the separator. If RelevantPotentialsFinderType = DSEP_BAYESBALL_NODES, then only the set of potentials d-connected to the variables of the separator are kept for combination and projection.

        0 = FIND_ALL
        1 = DSEP_BAYESBALL_NODES
        2 = DSEP_BAYESBALL_POTENTIALS
        3 = DSEP_KOLLER_FRIEDMAN_2009

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.VariableElimination_setRelevantPotentialsFinderType(self, type)

    def setFindBarrenNodesType(self, type: "gum::FindBarrenNodesType") -> "void":
        r"""
        setFindBarrenNodesType(self, type)

        sets how we determine barren nodes

        Barren nodes are unnecessary for probability inference, so they can be safely discarded in this case (type = FIND_BARREN_NODES). This speeds-up inference. However, there are some cases in which we do not want to remove barren nodes, typically when we want to answer queries such as Most Probable Explanations (MPE).

        0 = FIND_NO_BARREN_NODES
        1 = FIND_BARREN_NODES

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.VariableElimination_setFindBarrenNodesType(self, type)

    def junctionTree(self, id: "gum::NodeId") -> "gum::JunctionTree const *":
        r"""
        junctionTree(self, id) -> CliqueGraph

        Returns
        -------
        pyAgrum.CliqueGraph
          the current junction tree

        """
        val = _pyAgrum.VariableElimination_junctionTree(self, id)

        val._engine=self


        return val


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.VariableElimination_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.VariableElimination_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.VariableElimination_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.VariableElimination_evidenceImpact(self, target, evs)

    def jointMutualInformation(self, targets: "PyObject *") -> "double":
        r"""jointMutualInformation(self, targets) -> double"""
        return _pyAgrum.VariableElimination_jointMutualInformation(self, targets)

    def evidenceJointImpact(self, targets: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceJointImpact(self, targets, evs) -> Potential

        Create a pyAgrum.Potential for P(joint targets|evs) (for all instanciation of targets and evs)

        Parameters
        ----------
        targets :
          (int) a node Id
        targets :
          (str) a node name
        evs : set
          a set of nodes ids or names.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(target|evs)

        Raises
        ------
        gum.Exception
          If some evidene entered into the Bayes net are incompatible (their joint proba = 0)

        """
        return _pyAgrum.VariableElimination_evidenceJointImpact(self, targets, evs)

    def jointPosterior(self, targets: "PyObject *") -> "gum::Potential< double >":
        r"""
        jointPosterior(self, targets) -> Potential

        Compute the joint posterior of a set of nodes.

        Parameters
        ----------
        list :
          the list of nodes whose posterior joint probability is wanted


        Warnings
        --------
        The order of the variables given by the list here or when the jointTarget is declared can not be assumed to be used bu the Potential.

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior joint probability of the set of nodes.

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.VariableElimination_jointPosterior(self, targets)

    def addJointTarget(self, targets: "PyObject *") -> "void":
        r"""
        addJointTarget(self, targets)

        Add a list of nodes as a new joint target. As a collateral effect, every node is added as a marginal target.

        Parameters
        ----------
        list
          a list of names of nodes

        Raises
        ------
        gum.UndefinedElement
          If some node(s) do not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_addJointTarget(self, targets)

    def eraseJointTarget(self, targets: "PyObject *") -> "void":
        r"""
        eraseJointTarget(self, targets)

        Remove, if existing, the joint target.

        Parameters
        ----------
        list
          a list of names or Ids of nodes

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.VariableElimination_eraseJointTarget(self, targets)

    def isJointTarget(self, targets: "PyObject *") -> "bool":
        r"""
        isJointTarget(self, targets) -> bool

        Parameters
        ----------
        list
          a list of nodes ids or names.

        Returns
        -------
        bool
          True if target is a joint target.

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.VariableElimination_isJointTarget(self, targets)

    def jointTargets(self) -> "PyObject *":
        r"""
        jointTargets(self) -> PyObject *

        Returns
        -------
        list
          the list of target sets

        """
        return _pyAgrum.VariableElimination_jointTargets(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.VariableElimination_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.VariableElimination_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.VariableElimination_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.VariableElimination_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.VariableElimination_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.VariableElimination_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.VariableElimination_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.VariableElimination_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.VariableElimination_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.VariableElimination_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.VariableElimination_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.VariableElimination_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.VariableElimination_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.VariableElimination_BN(self)

# Register VariableElimination in _pyAgrum:
_pyAgrum.VariableElimination_swigregister(VariableElimination)

class GibbsSampling(object):
    r"""



    Class for making Gibbs sampling inference in Bayesian networks.

    GibbsSampling(bn) -> GibbsSampling
        Parameters:
          * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> GibbsSampling"""
        _pyAgrum.GibbsSampling_swiginit(self, _pyAgrum.new_GibbsSampling(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_GibbsSampling

    def setBurnIn(self, b: "gum::Size") -> "void":
        r"""
        setBurnIn(self, b)

        Parameters
        ----------
        b : int
          size of burn in on number of iteration

        """
        return _pyAgrum.GibbsSampling_setBurnIn(self, b)

    def burnIn(self) -> "gum::Size":
        r"""
        burnIn(self) -> gum::Size

        Returns
        -------
        int
          size of burn in on number of iteration

        """
        return _pyAgrum.GibbsSampling_burnIn(self)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.GibbsSampling_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.GibbsSampling_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.GibbsSampling_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.GibbsSampling_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.GibbsSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.GibbsSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.GibbsSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.GibbsSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.GibbsSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.GibbsSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.GibbsSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.GibbsSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.GibbsSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.GibbsSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.GibbsSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.GibbsSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.GibbsSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.GibbsSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.GibbsSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.GibbsSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.GibbsSampling__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.GibbsSampling_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.GibbsSampling_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.GibbsSampling_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.GibbsSampling_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.GibbsSampling_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.GibbsSampling_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.GibbsSampling_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.GibbsSampling_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.GibbsSampling_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.GibbsSampling_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.GibbsSampling_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.GibbsSampling_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.GibbsSampling_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.GibbsSampling_BN(self)

    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        r"""
        currentPosterior(self, id) -> Potential
        currentPosterior(self, name) -> Potential

        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.GibbsSampling_currentPosterior(self, *args)

    def nbrDrawnVar(self) -> "gum::Size":
        r"""
        nbrDrawnVar(self) -> gum::Size

        Returns
        -------
        int
          the number of variable drawn at each iteration

        """
        return _pyAgrum.GibbsSampling_nbrDrawnVar(self)

    def setNbrDrawnVar(self, _nbr: "gum::Size") -> "void":
        r"""
        setNbrDrawnVar(self, _nbr)

        Parameters
        ----------
        _nbr : int
          the number of variables to be drawn at each iteration

        """
        return _pyAgrum.GibbsSampling_setNbrDrawnVar(self, _nbr)

    def isDrawnAtRandom(self) -> "bool":
        r"""
        isDrawnAtRandom(self) -> bool

        Returns
        -------
        bool
          True if variables are drawn at random

        """
        return _pyAgrum.GibbsSampling_isDrawnAtRandom(self)

    def setDrawnAtRandom(self, _atRandom: "bool") -> "void":
        r"""
        setDrawnAtRandom(self, _atRandom)

        Parameters
        ----------
        _atRandom : bool
          indicates if variables should be drawn at random

        """
        return _pyAgrum.GibbsSampling_setDrawnAtRandom(self, _atRandom)

# Register GibbsSampling in _pyAgrum:
_pyAgrum.GibbsSampling_swigregister(GibbsSampling)

class ImportanceSampling(object):
    r"""



    Class used for inferences using the Importance Sampling algorithm.

    ImportanceSampling(bn) -> ImportanceSampling
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> ImportanceSampling"""
        _pyAgrum.ImportanceSampling_swiginit(self, _pyAgrum.new_ImportanceSampling(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_ImportanceSampling

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.ImportanceSampling_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.ImportanceSampling_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.ImportanceSampling_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.ImportanceSampling_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.ImportanceSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.ImportanceSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.ImportanceSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.ImportanceSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.ImportanceSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.ImportanceSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.ImportanceSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.ImportanceSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.ImportanceSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.ImportanceSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.ImportanceSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.ImportanceSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.ImportanceSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.ImportanceSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.ImportanceSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.ImportanceSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.ImportanceSampling__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.ImportanceSampling_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ImportanceSampling_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.ImportanceSampling_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.ImportanceSampling_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.ImportanceSampling_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.ImportanceSampling_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.ImportanceSampling_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.ImportanceSampling_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.ImportanceSampling_BN(self)

    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        r"""
        currentPosterior(self, id) -> Potential
        currentPosterior(self, name) -> Potential

        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ImportanceSampling_currentPosterior(self, *args)

# Register ImportanceSampling in _pyAgrum:
_pyAgrum.ImportanceSampling_swigregister(ImportanceSampling)

class WeightedSampling(object):
    r"""



    Class used for Weighted sampling inference algorithm.

    WeightedSampling(bn) -> WeightedSampling
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> WeightedSampling"""
        _pyAgrum.WeightedSampling_swiginit(self, _pyAgrum.new_WeightedSampling(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_WeightedSampling

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.WeightedSampling_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.WeightedSampling_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.WeightedSampling_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.WeightedSampling_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.WeightedSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.WeightedSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.WeightedSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.WeightedSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.WeightedSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.WeightedSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.WeightedSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.WeightedSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.WeightedSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.WeightedSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.WeightedSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.WeightedSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.WeightedSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.WeightedSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.WeightedSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.WeightedSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.WeightedSampling__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.WeightedSampling_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.WeightedSampling_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.WeightedSampling_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.WeightedSampling_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.WeightedSampling_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.WeightedSampling_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.WeightedSampling_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.WeightedSampling_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.WeightedSampling_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.WeightedSampling_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.WeightedSampling_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.WeightedSampling_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.WeightedSampling_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.WeightedSampling_BN(self)

    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        r"""
        currentPosterior(self, id) -> Potential
        currentPosterior(self, name) -> Potential

        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.WeightedSampling_currentPosterior(self, *args)

# Register WeightedSampling in _pyAgrum:
_pyAgrum.WeightedSampling_swigregister(WeightedSampling)

class MonteCarloSampling(object):
    r"""



    Class used for Monte Carlo sampling inference algorithm.

    MonteCarloSampling(bn) -> MonteCarloSampling
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> MonteCarloSampling"""
        _pyAgrum.MonteCarloSampling_swiginit(self, _pyAgrum.new_MonteCarloSampling(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_MonteCarloSampling

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.MonteCarloSampling_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.MonteCarloSampling_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.MonteCarloSampling_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.MonteCarloSampling_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.MonteCarloSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.MonteCarloSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.MonteCarloSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.MonteCarloSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.MonteCarloSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.MonteCarloSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.MonteCarloSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.MonteCarloSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.MonteCarloSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.MonteCarloSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.MonteCarloSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.MonteCarloSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.MonteCarloSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.MonteCarloSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.MonteCarloSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.MonteCarloSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.MonteCarloSampling__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.MonteCarloSampling_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.MonteCarloSampling_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.MonteCarloSampling_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.MonteCarloSampling_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.MonteCarloSampling_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.MonteCarloSampling_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.MonteCarloSampling_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.MonteCarloSampling_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.MonteCarloSampling_BN(self)

    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        r"""
        currentPosterior(self, id) -> Potential
        currentPosterior(self, name) -> Potential

        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.MonteCarloSampling_currentPosterior(self, *args)

# Register MonteCarloSampling in _pyAgrum:
_pyAgrum.MonteCarloSampling_swigregister(MonteCarloSampling)

class LoopyImportanceSampling(object):
    r"""

    Class used for inferences using a loopy version of importance sampling.

    LoopyImportanceSampling(bn) -> LoopyImportanceSampling
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> LoopyImportanceSampling"""
        _pyAgrum.LoopyImportanceSampling_swiginit(self, _pyAgrum.new_LoopyImportanceSampling(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyImportanceSampling

    def makeInference_(self) -> "void":
        r"""makeInference_(self)"""
        return _pyAgrum.LoopyImportanceSampling_makeInference_(self)

    def setVirtualLBPSize(self, vlbpsize: "double") -> "void":
        r"""
        setVirtualLBPSize(self, vlbpsize)

        Parameters
        ----------
        vlbpsize : double
          the size of the virtual LBP

        """
        return _pyAgrum.LoopyImportanceSampling_setVirtualLBPSize(self, vlbpsize)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.LoopyImportanceSampling_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.LoopyImportanceSampling_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyImportanceSampling_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyImportanceSampling_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.LoopyImportanceSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.LoopyImportanceSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyImportanceSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.LoopyImportanceSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyImportanceSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyImportanceSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyImportanceSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyImportanceSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyImportanceSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyImportanceSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyImportanceSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyImportanceSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyImportanceSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyImportanceSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyImportanceSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyImportanceSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.LoopyImportanceSampling__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.LoopyImportanceSampling_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyImportanceSampling_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyImportanceSampling_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.LoopyImportanceSampling_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyImportanceSampling_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.LoopyImportanceSampling_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyImportanceSampling_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyImportanceSampling_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyImportanceSampling_BN(self)

    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        r"""
        currentPosterior(self, id) -> Potential
        currentPosterior(self, name) -> Potential

        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyImportanceSampling_currentPosterior(self, *args)

# Register LoopyImportanceSampling in _pyAgrum:
_pyAgrum.LoopyImportanceSampling_swigregister(LoopyImportanceSampling)

class LoopyWeightedSampling(object):
    r"""

    Class used for inferences using a loopy version of weighted sampling.

    LoopyWeightedSampling(bn) -> LoopyWeightedSampling
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> LoopyWeightedSampling"""
        _pyAgrum.LoopyWeightedSampling_swiginit(self, _pyAgrum.new_LoopyWeightedSampling(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyWeightedSampling

    def makeInference_(self) -> "void":
        r"""makeInference_(self)"""
        return _pyAgrum.LoopyWeightedSampling_makeInference_(self)

    def setVirtualLBPSize(self, vlbpsize: "double") -> "void":
        r"""
        setVirtualLBPSize(self, vlbpsize)

        Parameters
        ----------
        vlbpsize : double
          the size of the virtual LBP

        """
        return _pyAgrum.LoopyWeightedSampling_setVirtualLBPSize(self, vlbpsize)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.LoopyWeightedSampling_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.LoopyWeightedSampling_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyWeightedSampling_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyWeightedSampling_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.LoopyWeightedSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.LoopyWeightedSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyWeightedSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.LoopyWeightedSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyWeightedSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyWeightedSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyWeightedSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyWeightedSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyWeightedSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyWeightedSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyWeightedSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyWeightedSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyWeightedSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyWeightedSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyWeightedSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyWeightedSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.LoopyWeightedSampling__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.LoopyWeightedSampling_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyWeightedSampling_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyWeightedSampling_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.LoopyWeightedSampling_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyWeightedSampling_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.LoopyWeightedSampling_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyWeightedSampling_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyWeightedSampling_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyWeightedSampling_BN(self)

    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        r"""
        currentPosterior(self, id) -> Potential
        currentPosterior(self, name) -> Potential

        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyWeightedSampling_currentPosterior(self, *args)

# Register LoopyWeightedSampling in _pyAgrum:
_pyAgrum.LoopyWeightedSampling_swigregister(LoopyWeightedSampling)

class LoopyGibbsSampling(object):
    r"""

    Class used for inferences using a loopy version of Gibbs sampling.

    LoopyGibbsSampling(bn) -> LoopyGibbsSampling
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> LoopyGibbsSampling"""
        _pyAgrum.LoopyGibbsSampling_swiginit(self, _pyAgrum.new_LoopyGibbsSampling(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyGibbsSampling

    def makeInference_(self) -> "void":
        r"""makeInference_(self)"""
        return _pyAgrum.LoopyGibbsSampling_makeInference_(self)

    def setVirtualLBPSize(self, vlbpsize: "double") -> "void":
        r"""
        setVirtualLBPSize(self, vlbpsize)

        Parameters
        ----------
        vlbpsize : double
          the size of the virtual LBP

        """
        return _pyAgrum.LoopyGibbsSampling_setVirtualLBPSize(self, vlbpsize)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.LoopyGibbsSampling_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.LoopyGibbsSampling_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyGibbsSampling_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyGibbsSampling_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.LoopyGibbsSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.LoopyGibbsSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyGibbsSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.LoopyGibbsSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyGibbsSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyGibbsSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyGibbsSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyGibbsSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyGibbsSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyGibbsSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyGibbsSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyGibbsSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyGibbsSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyGibbsSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyGibbsSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyGibbsSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.LoopyGibbsSampling__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.LoopyGibbsSampling_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyGibbsSampling_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyGibbsSampling_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.LoopyGibbsSampling_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyGibbsSampling_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.LoopyGibbsSampling_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyGibbsSampling_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyGibbsSampling_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyGibbsSampling_BN(self)

    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        r"""
        currentPosterior(self, id) -> Potential
        currentPosterior(self, name) -> Potential

        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyGibbsSampling_currentPosterior(self, *args)

    def nbrDrawnVar(self) -> "gum::Size":
        r"""
        nbrDrawnVar(self) -> gum::Size

        Returns
        -------
        int
          the number of variable drawn at each iteration

        """
        return _pyAgrum.LoopyGibbsSampling_nbrDrawnVar(self)

    def setNbrDrawnVar(self, _nbr: "gum::Size") -> "void":
        r"""
        setNbrDrawnVar(self, _nbr)

        Parameters
        ----------
        _nbr : int
          the number of variables to be drawn at each iteration

        """
        return _pyAgrum.LoopyGibbsSampling_setNbrDrawnVar(self, _nbr)

    def isDrawnAtRandom(self) -> "bool":
        r"""
        isDrawnAtRandom(self) -> bool

        Returns
        -------
        bool
          True if variables are drawn at random

        """
        return _pyAgrum.LoopyGibbsSampling_isDrawnAtRandom(self)

    def setDrawnAtRandom(self, _atRandom: "bool") -> "void":
        r"""
        setDrawnAtRandom(self, _atRandom)

        Parameters
        ----------
        _atRandom : bool
          indicates if variables should be drawn at random

        """
        return _pyAgrum.LoopyGibbsSampling_setDrawnAtRandom(self, _atRandom)

    def burnIn(self) -> "gum::Size":
        r"""
        burnIn(self) -> gum::Size

        Returns
        -------
        int
          size of burn in on number of iteration

        """
        return _pyAgrum.LoopyGibbsSampling_burnIn(self)

    def setBurnIn(self, b: "gum::Size") -> "void":
        r"""
        setBurnIn(self, b)

        Parameters
        ----------
        b : int
          size of burn in on number of iteration

        """
        return _pyAgrum.LoopyGibbsSampling_setBurnIn(self, b)

# Register LoopyGibbsSampling in _pyAgrum:
_pyAgrum.LoopyGibbsSampling_swigregister(LoopyGibbsSampling)

class LoopyMonteCarloSampling(object):
    r"""

    Class used for inferences using a loopy version of Monte Carlo sampling.

    LoopyMonteCarloSampling(bn) -> LoopyMonteCarloSampling
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> LoopyMonteCarloSampling"""
        _pyAgrum.LoopyMonteCarloSampling_swiginit(self, _pyAgrum.new_LoopyMonteCarloSampling(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyMonteCarloSampling

    def makeInference_(self) -> "void":
        r"""makeInference_(self)"""
        return _pyAgrum.LoopyMonteCarloSampling_makeInference_(self)

    def setVirtualLBPSize(self, vlbpsize: "double") -> "void":
        r"""
        setVirtualLBPSize(self, vlbpsize)

        Parameters
        ----------
        vlbpsize : double
          the size of the virtual LBP

        """
        return _pyAgrum.LoopyMonteCarloSampling_setVirtualLBPSize(self, vlbpsize)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.LoopyMonteCarloSampling_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.LoopyMonteCarloSampling_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyMonteCarloSampling_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyMonteCarloSampling_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.LoopyMonteCarloSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.LoopyMonteCarloSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyMonteCarloSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.LoopyMonteCarloSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyMonteCarloSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyMonteCarloSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyMonteCarloSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyMonteCarloSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyMonteCarloSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyMonteCarloSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyMonteCarloSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyMonteCarloSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyMonteCarloSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyMonteCarloSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyMonteCarloSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyMonteCarloSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.LoopyMonteCarloSampling__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.LoopyMonteCarloSampling_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyMonteCarloSampling_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyMonteCarloSampling_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.LoopyMonteCarloSampling_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyMonteCarloSampling_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.LoopyMonteCarloSampling_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyMonteCarloSampling_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyMonteCarloSampling_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyMonteCarloSampling_BN(self)

    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        r"""
        currentPosterior(self, id) -> Potential
        currentPosterior(self, name) -> Potential

        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyMonteCarloSampling_currentPosterior(self, *args)

# Register LoopyMonteCarloSampling in _pyAgrum:
_pyAgrum.LoopyMonteCarloSampling_swigregister(LoopyMonteCarloSampling)

class LoopyBeliefPropagation(object):
    r"""



    Class used for inferences using loopy belief propagation algorithm.

    LoopyBeliefPropagation(bn) -> LoopyBeliefPropagation
        Parameters:
            * **bn** (*pyAgrum.BayesNet*) -- a Bayesian network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "IBayesNet"):
        r"""__init__(self, bn) -> LoopyBeliefPropagation"""
        _pyAgrum.LoopyBeliefPropagation_swiginit(self, _pyAgrum.new_LoopyBeliefPropagation(bn))

        self._model=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyBeliefPropagation

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""
        hardEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with hard evidence

        """
        return _pyAgrum.LoopyBeliefPropagation_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""
        softEvidenceNodes(self) -> PyObject *

        Returns
        -------
        set
          the set of nodes with soft evidence

        """
        return _pyAgrum.LoopyBeliefPropagation_softEvidenceNodes(self)

    def targets(self) -> "PyObject *":
        r"""
        targets(self) -> PyObject *

        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyBeliefPropagation_targets(self)

    def evidenceImpact(self, target: "PyObject *", evs: "PyObject *") -> "gum::Potential< double >":
        r"""
        evidenceImpact(self, target, evs) -> Potential

        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs)

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyBeliefPropagation_evidenceImpact(self, target, evs)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.LoopyBeliefPropagation_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.LoopyBeliefPropagation_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyBeliefPropagation_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.LoopyBeliefPropagation_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyBeliefPropagation_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyBeliefPropagation_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyBeliefPropagation_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyBeliefPropagation_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyBeliefPropagation_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyBeliefPropagation_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyBeliefPropagation_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.LoopyBeliefPropagation_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyBeliefPropagation_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyBeliefPropagation_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyBeliefPropagation_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyBeliefPropagation_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.LoopyBeliefPropagation__asIApproximationSchemeConfiguration(self)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages.

        """
        return _pyAgrum.LoopyBeliefPropagation_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential

        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyBeliefPropagation_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)

        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)

        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyBeliefPropagation_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""
        hasHardEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool

        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""
        nbrEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""
        nbrHardEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""
        nbrSoftEvidence(self) -> gum::Size

        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_nbrSoftEvidence(self)

    def eraseAllTargets(self) -> "void":
        r"""
        eraseAllTargets(self)

        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user).

        """
        return _pyAgrum.LoopyBeliefPropagation_eraseAllTargets(self)

    def addAllTargets(self) -> "void":
        r"""
        addAllTargets(self)

        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyBeliefPropagation_addAllTargets(self)

    def addTarget(self, *args) -> "void":
        r"""
        addTarget(self, target)
        addTarget(self, nodeName)

        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net

        """
        return _pyAgrum.LoopyBeliefPropagation_addTarget(self, *args)

    def eraseTarget(self, *args) -> "void":
        r"""
        eraseTarget(self, target)
        eraseTarget(self, nodeName)

        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_eraseTarget(self, *args)

    def isTarget(self, *args) -> "bool":
        r"""
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool

        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_isTarget(self, *args)

    def nbrTargets(self) -> "gum::Size":
        r"""
        nbrTargets(self) -> gum::Size

        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyBeliefPropagation_nbrTargets(self)

    def H(self, *args) -> "double":
        r"""
        H(self, X) -> double
        H(self, nodeName) -> double

        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyBeliefPropagation_H(self, *args)

    def BN(self) -> "gum::IBayesNet< double > const &":
        r"""
        BN(self) -> IBayesNet

        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyBeliefPropagation_BN(self)

# Register LoopyBeliefPropagation in _pyAgrum:
_pyAgrum.LoopyBeliefPropagation_swigregister(LoopyBeliefPropagation)

class ExactBNdistance(object):
    r"""



    Class representing exacte computation of divergence and distance between BNs

    ExactBNdistance(P,Q) -> ExactBNdistance
        Parameters:
            * **P** (*pyAgrum.BayesNet*)
              a Bayesian network
            * **Q** (*pyAgrum.BayesNet*)
              another Bayesian network to compare with the first one

    ExactBNdistance(ebnd) -> ExactBNdistance
        Parameters:
            * **ebnd** (*pyAgrum.ExactBNdistance*)
              the exact BNdistance to copy

    Raises
    ------
    gum.OperationNotAllowed
    	If the 2BNs have not the same domain size of compatible node sets

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, P, Q) -> ExactBNdistance
        __init__(self, kl) -> ExactBNdistance
        """
        _pyAgrum.ExactBNdistance_swiginit(self, _pyAgrum.new_ExactBNdistance(*args))
    __swig_destroy__ = _pyAgrum.delete_ExactBNdistance

    def compute(self) -> "PyObject *":
        r"""
        compute(self) -> PyObject *

        Returns
        -------
        dict
        	a dictionnary containing the different values after the computation.

        """
        return _pyAgrum.ExactBNdistance_compute(self)

# Register ExactBNdistance in _pyAgrum:
_pyAgrum.ExactBNdistance_swigregister(ExactBNdistance)

class GibbsBNdistance(ApproximationScheme):
    r"""



    Class representing a Gibbs-Approximated computation of divergence and distance between BNs


    GibbsBNdistance(P,Q) -> GibbsBNdistance
        Parameters:
            * **P** (*pyAgrum.BayesNet*) -- a Bayesian network
            * **Q** (*pyAgrum.BayesNet*) -- another Bayesian network to compare with the first one

    GibbsBNdistance(gbnd) -> GibbsBNdistance
        Parameters:
            * **gbnd** (*pyAgrum.GibbsBNdistance*) -- the Gibbs BNdistance to copy

    Raises
    ------
    gum.OperationNotAllowed
    	If the 2BNs have not the same domain size of compatible node sets

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, P, Q) -> GibbsBNdistance
        __init__(self, kl) -> GibbsBNdistance
        """
        _pyAgrum.GibbsBNdistance_swiginit(self, _pyAgrum.new_GibbsBNdistance(*args))
    __swig_destroy__ = _pyAgrum.delete_GibbsBNdistance

    def setBurnIn(self, b: "gum::Size") -> "void":
        r"""
        setBurnIn(self, b)

        Parameters
        ----------
        b : int
        	size of burn in on number of iteration

        """
        return _pyAgrum.GibbsBNdistance_setBurnIn(self, b)

    def burnIn(self) -> "gum::Size":
        r"""
        burnIn(self) -> gum::Size

        Returns
        -------
        int
        	size of burn in on number of iteration

        """
        return _pyAgrum.GibbsBNdistance_burnIn(self)

    def compute(self) -> "PyObject *":
        r"""
        compute(self) -> PyObject *

        Returns
        -------
        dict
        	a dictionnary containing the different values after the computation.

        """
        return _pyAgrum.GibbsBNdistance_compute(self)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.GibbsBNdistance_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.GibbsBNdistance_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.GibbsBNdistance_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.GibbsBNdistance_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.GibbsBNdistance_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.GibbsBNdistance_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.GibbsBNdistance_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.GibbsBNdistance_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.GibbsBNdistance_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.GibbsBNdistance_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.GibbsBNdistance_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.GibbsBNdistance_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.GibbsBNdistance_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.GibbsBNdistance_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.GibbsBNdistance_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.GibbsBNdistance_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.GibbsBNdistance__asIApproximationSchemeConfiguration(self)

    def nbrDrawnVar(self) -> "gum::Size":
        r"""
        nbrDrawnVar(self) -> gum::Size

        Returns
        -------
        int
          the number of variable drawn at each iteration

        """
        return _pyAgrum.GibbsBNdistance_nbrDrawnVar(self)

    def setNbrDrawnVar(self, _nbr: "gum::Size") -> "void":
        r"""
        setNbrDrawnVar(self, _nbr)

        Parameters
        ----------
        _nbr : int
          the number of variables to be drawn at each iteration

        """
        return _pyAgrum.GibbsBNdistance_setNbrDrawnVar(self, _nbr)

    def isDrawnAtRandom(self) -> "bool":
        r"""
        isDrawnAtRandom(self) -> bool

        Returns
        -------
        bool
          True if variables are drawn at random

        """
        return _pyAgrum.GibbsBNdistance_isDrawnAtRandom(self)

    def setDrawnAtRandom(self, _atRandom: "bool") -> "void":
        r"""
        setDrawnAtRandom(self, _atRandom)

        Parameters
        ----------
        _atRandom : bool
          indicates if variables should be drawn at random

        """
        return _pyAgrum.GibbsBNdistance_setDrawnAtRandom(self, _atRandom)

# Register GibbsBNdistance in _pyAgrum:
_pyAgrum.GibbsBNdistance_swigregister(GibbsBNdistance)

class CredalNet(object):
    r"""



    Constructor used to create a CredalNet (step by step or with two BayesNet)

    CredalNet() -> CredalNet
        default constructor

    CredalNet(src_min_num,src_max_den) -> CredalNet

    Parameters
    ----------
    src_min_num : str or pyAgrum.BayesNet
                The path to a BayesNet or the BN itself which contains lower probabilities.
    src_max_den : str or pyAgrum.BayesNet
                The (optional) path to a BayesNet or the BN itself which contains upper probabilities.


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    NodeType_Precise = _pyAgrum.CredalNet_NodeType_Precise
    
    NodeType_Credal = _pyAgrum.CredalNet_NodeType_Credal
    
    NodeType_Vacuous = _pyAgrum.CredalNet_NodeType_Vacuous
    
    NodeType_Indic = _pyAgrum.CredalNet_NodeType_Indic
    

    def __init__(self, *args):
        r"""
        __init__(self) -> CredalNet
        __init__(self, src_min_num, src_max_den="") -> CredalNet
        __init__(self, src_min_num, src_max_den=gum::BayesNet()) -> CredalNet
        """
        _pyAgrum.CredalNet_swiginit(self, _pyAgrum.new_CredalNet(*args))
    __swig_destroy__ = _pyAgrum.delete_CredalNet

    def addVariable(self, name: "std::string const &", card: "gum::Size const &") -> "gum::NodeId":
        r"""
        addVariable(self, name, card) -> gum::NodeId

        Parameters
        ----------
        name : str
        	the name of the new variable
        card: int
            the domainSize of the new variable

        Returns
        -------
        int
        	the id of the new node

        """
        return _pyAgrum.CredalNet_addVariable(self, name, card)

    def addArc(self, tail: "gum::NodeId const &", head: "gum::NodeId const &") -> "void":
        r"""
        addArc(self, tail, head)

        Adds an arc between two nodes

        Parameters
        ----------
        tail :
        	the id of the tail node
        head : int 
        	the id of the head node

        Raises
        ------
        gum.InvalidDirectedCircle
        	If any (directed) cycle is created by this arc
        gum.InvalidNode
        	If head or tail does not belong to the graph nodes
        gum.DuplicateElement
        	If one of the arc already exists

        """
        return _pyAgrum.CredalNet_addArc(self, tail, head)

    def setCPTs(self, id: "gum::NodeId const &", cpt: "std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > const &") -> "void":
        r"""
        setCPTs(self, id, cpt)

        Warnings
        --------
        (experimental function) - Parameters to be wrapped


        Set the vertices of the credal sets (all of the conditionals) of a given node

        Parameters
        ----------
        id : int
        	the NodeId of the node
        cpt	: tbw 
        	the vertices of every credal set (for each instantiation of the parents)

        Warning
        -------
        DOES not change the BayesNet (s) associated to this credal net !

        """
        return _pyAgrum.CredalNet_setCPTs(self, id, cpt)

    def setCPT(self, *args) -> "void":
        r"""
        setCPT(self, id, entry, cpt)
        setCPT(self, id, ins, cpt)

        Warnings
        --------
        (experimental function) - Parameters to be wrapped


        Set the vertices of one credal set of a given node (any instantiation index)

        Parameters
        ----------
        id : int
        	the Id of the node
        entry : int
        	the index of the instantiation (from 0 to K - 1) excluding the given node (only the parents are used to compute the index of the credal set)
        ins : pyAgrum.Instantiation
        	the Instantiation (only the parents matter to find the credal set index) 
        cpt	: tbw
        	the vertices of every credal set (for each instantiation of the parents)

        Warnings
        --------
        DOES not change the BayesNet(s) associated to this credal net !

        """
        return _pyAgrum.CredalNet_setCPT(self, *args)

    def fillConstraints(self, id: "gum::NodeId const &", lower: "Vector", upper: "Vector") -> "void":
        r"""
        fillConstraints(self, id, lower, upper)

        Set the interval constraints of the credal sets of a given node (all instantiations) 

        Parameters
        ----------
        id : int 
        	The id of the node
        lower : list
        	The lower value for each probability in correct order
        upper : list
        	The upper value for each probability in correct order

        Warnings
        --------
        You need to call intervalToCredal when done filling all constraints.

        Warning
        -------
        DOES change the BayesNet (s) associated to this credal net !

        """
        return _pyAgrum.CredalNet_fillConstraints(self, id, lower, upper)

    def fillConstraint(self, *args) -> "void":
        r"""
        fillConstraint(self, id, entry, lower, upper)
        fillConstraint(self, id, ins, lower, upper)

        Set the interval constraints of a credal set of a given node (from an instantiation index)

        Parameters
        ----------
        id : int 
        	The id of the node
        entry : int
        	The index of the instantiation excluding the given node (only the parents are used to compute the index of the credal set)
        ins : pyAgrum.Instantiation
        	The Instantiation
        lower : list
        	The lower value for each probability in correct order
        upper : list
        	The upper value for each probability in correct order

        Warnings
        --------
        You need to call intervalToCredal when done filling all constraints.

        Warning
        -------
        DOES change the BayesNet (s) associated to this credal net ! 

        """
        return _pyAgrum.CredalNet_fillConstraint(self, *args)

    def instantiation(self, id: "gum::NodeId const &") -> "gum::Instantiation":
        r"""
        instantiation(self, id) -> Instantiation

        Get an Instantiation from a node id, usefull to fill the constraints of the network.

        bnet accessors / shortcuts.

        Parameters
        ----------
        id : int
        	the id of the node we want an instantiation from

        Returns
        -------
        pyAgrum.Instantiation
            the instantiation 

        """
        return _pyAgrum.CredalNet_instantiation(self, id)

    def domainSize(self, id: "gum::NodeId const &") -> "gum::Size":
        r"""
        domainSize(self, id) -> gum::Size

        Parameters
        ----------
        id : int
        	The id of the node

        Returns
        -------
        int
            The cardinality of the node 

        """
        return _pyAgrum.CredalNet_domainSize(self, id)

    def bnToCredal(self, beta: "double const", oneNet: "bool const", keepZeroes: "bool const"=False) -> "void":
        r"""
        bnToCredal(self, beta, oneNet, keepZeroes=False)

        Perturbates the BayesNet provided as input for this CredalNet by generating intervals instead of point probabilities and then computes each vertex of each credal set.

        Parameters
        ----------
        beta : double
        	The beta used to perturbate the network
        oneNet : bool
        	used as a flag. Set to True if one BayesNet if provided with counts, to False if two BayesNet are provided; one with probabilities (the lower net) and one with denominators over the first modalities (the upper net)
        keepZeroes : bool
        	used as a flag as whether or not - respectively True or False - we keep zeroes as zeroes. Default is False, i.e. zeroes are not kept

        """
        return _pyAgrum.CredalNet_bnToCredal(self, beta, oneNet, keepZeroes)

    def intervalToCredalWithFiles(self) -> "void":
        r"""
        intervalToCredalWithFiles(self)

        Warnings
        --------
        Deprecated : use intervalToCredal (lrsWrapper with no input / output files needed).


        Computes the vertices of each credal set according to their interval definition (uses lrs).

        Use this method when using a single BayesNet storing counts of events. 

        """
        return _pyAgrum.CredalNet_intervalToCredalWithFiles(self)

    def intervalToCredal(self) -> "void":
        r"""
        intervalToCredal(self)

        Computes the vertices of each credal set according to their interval definition (uses lrs).

        Use this method when using two BayesNet, one with lower probabilities and one with upper probabilities.

        """
        return _pyAgrum.CredalNet_intervalToCredal(self)

    def lagrangeNormalization(self) -> "void":
        r"""
        lagrangeNormalization(self)

        Normalize counts of a BayesNet storing counts of each events such that no probability is 0.

        Use this method when using a single BayesNet storing counts of events. Lagrange normalization. This call is irreversible and modify counts stored by __src_bn.

        Doest not performs computations of the parameters but keeps normalized counts of events only. Call idmLearning to compute the probabilities (with any parameter value). 

        """
        return _pyAgrum.CredalNet_lagrangeNormalization(self)

    def idmLearning(self, s: "gum::Idx const"=0, keepZeroes: "bool const"=False) -> "void":
        r"""
        idmLearning(self, s=0, keepZeroes=False)

        Learns parameters from a BayesNet storing counts of events.

        Use this method when using a single BayesNet storing counts of events. IDM model if s > 0, standard point probability if s = 0 (default value if none precised).

        Parameters
        ----------
        s : int
        	the IDM parameter.
        keepZeroes : bool
        	used as a flag as whether or not - respectively True or False - we keep zeroes as zeroes. Default is False, i.e. zeroes are not kept. 

        """
        return _pyAgrum.CredalNet_idmLearning(self, s, keepZeroes)

    def approximatedBinarization(self) -> "void":
        r"""
        approximatedBinarization(self)

        Approximate binarization.

        Each bit has a lower and upper probability which is the lowest - resp. highest - over all vertices of the credal set. Enlarge the orignal credal sets and may induce huge imprecision.

        Warnings
        --------
        Enlarge the orignal credal sets and therefor induce huge imprecision by propagation. Not recommended, use MCSampling or something else instead

        """
        return _pyAgrum.CredalNet_approximatedBinarization(self)

    def saveBNsMinMax(self, min_path: "std::string const &", max_path: "std::string const &") -> "void":
        r"""
        saveBNsMinMax(self, min_path, max_path)

        If this CredalNet was built over a perturbed BayesNet, one can save the intervals as two BayesNet.

        to call after bnToCredal(GUM_SCALAR beta) save a BN with lower probabilities and a BN with upper ones

        Parameters
        ----------
        min_path : str
        	the path to save the BayesNet which contains the lower probabilities of each node X.
        max_path : str
        	the path to save the BayesNet which contains the upper probabilities of each node X.

        """
        return _pyAgrum.CredalNet_saveBNsMinMax(self, min_path, max_path)

    def computeBinaryCPTMinMax(self) -> "void":
        r"""computeBinaryCPTMinMax(self)"""
        return _pyAgrum.CredalNet_computeBinaryCPTMinMax(self)

    def src_bn(self) -> "gum::BayesNet< double > const &":
        r"""
        src_bn(self) -> BayesNet

        Returns
        -------
        pyAgrum.BayesNet
            Returns a constant reference to the original BayesNet (used as a DAG, it's CPTs does not matter). 

        """
        return _pyAgrum.CredalNet_src_bn(self)

    def current_bn(self) -> "gum::BayesNet< double > const &":
        r"""
        current_bn(self) -> BayesNet

        Returns
        -------
        pyAgrum.BayesNet
            Returs a constant reference to the actual BayesNet (used as a DAG, it's CPTs does not matter). 

        """
        return _pyAgrum.CredalNet_current_bn(self)

    def credalNet_currentCpt(self) -> "gum::NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &":
        r"""
        credalNet_currentCpt(self) -> gum::NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &

        Warnings
        --------
        Experimental function - Return type to be wrapped

        Returns
        -------
        tbw
            a constant reference to the (up-to-date) CredalNet CPTs.

        """
        return _pyAgrum.CredalNet_credalNet_currentCpt(self)

    def credalNet_srcCpt(self) -> "gum::NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &":
        r"""
        credalNet_srcCpt(self) -> gum::NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &

        Warnings
        --------
        Experimental function - Return type to be wrapped

        Returns
        -------
        tbw
            a constant reference to the (up-to-date) CredalNet CPTs.

        """
        return _pyAgrum.CredalNet_credalNet_srcCpt(self)

    def currentNodeType(self, id: "gum::NodeId const &") -> "gum::credal::CredalNet< double >::NodeType":
        r"""
        currentNodeType(self, id) -> gum::credal::CredalNet< double >::NodeType

        Parameters
        ----------
        id : int 
        	The constant reference to the choosen NodeId

        Returns
        -------
        pyAgrum.CredalNet
            the type of the choosen node in the (up-to-date) CredalNet __current_bn if any, __src_bn otherwise. 

        """
        return _pyAgrum.CredalNet_currentNodeType(self, id)

    def nodeType(self, id: "gum::NodeId const &") -> "gum::credal::CredalNet< double >::NodeType":
        r"""
        nodeType(self, id) -> gum::credal::CredalNet< double >::NodeType

        Parameters
        ----------
        id : int
        	the constant reference to the choosen NodeId

        Returns
        -------
        pyAgrum.CredalNet
        	the type of the choosen node in the (up-to-date) CredalNet in __src_bn. 

        """
        return _pyAgrum.CredalNet_nodeType(self, id)

    def epsilonMin(self) -> "double const &":
        r"""
        epsilonMin(self) -> double const &

        Returns
        -------
        double
            a constant reference to the lowest perturbation of the BayesNet provided as input for this CredalNet. 

        """
        return _pyAgrum.CredalNet_epsilonMin(self)

    def epsilonMax(self) -> "double const &":
        r"""
        epsilonMax(self) -> double const &

        Returns
        -------
        double
            a constant reference to the highest perturbation of the BayesNet provided as input for this CredalNet. 

        """
        return _pyAgrum.CredalNet_epsilonMax(self)

    def epsilonMean(self) -> "double const &":
        r"""
        epsilonMean(self) -> double const &

        Returns
        -------
        double
            a constant reference to the average perturbation of the BayesNet provided as input for this CredalNet. 

        """
        return _pyAgrum.CredalNet_epsilonMean(self)

    def isSeparatelySpecified(self) -> "bool const":
        r"""
        isSeparatelySpecified(self) -> bool const

        Returns
        -------
        bool
        	True if this CredalNet is separately and interval specified, False otherwise. 

        """
        return _pyAgrum.CredalNet_isSeparatelySpecified(self)

    def hasComputedBinaryCPTMinMax(self) -> "bool const":
        r"""hasComputedBinaryCPTMinMax(self) -> bool const"""
        return _pyAgrum.CredalNet_hasComputedBinaryCPTMinMax(self)

    def get_binaryCPT_min(self) -> "std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &":
        r"""
        get_binaryCPT_min(self) -> std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &

        Warnings
        --------
        Experimental function - Return type to be wrapped

        Returns
        -------
        tbw
        	a constant reference to the lower probabilities of each node X over the 'True' modality

        """
        return _pyAgrum.CredalNet_get_binaryCPT_min(self)

    def get_binaryCPT_max(self) -> "std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &":
        r"""
        get_binaryCPT_max(self) -> std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &

        Warnings
        --------
        Experimental function - Return type to be wrapped

        Returns
        -------
        tbw
        	a constant reference to the upper probabilities of each node X over the 'True' modality

        """
        return _pyAgrum.CredalNet_get_binaryCPT_max(self)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.CredalNet___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.CredalNet___str__(self)

# Register CredalNet in _pyAgrum:
_pyAgrum.CredalNet_swigregister(CredalNet)

class CNMonteCarloSampling(object):
    r"""



    Class used for inferences in credal networks with Monte Carlo sampling algorithm.

    CNMonteCarloSampling(cn) -> CNMonteCarloSampling
        Parameters:
            * **cn** (*pyAgrum.CredalNet*) -- a credal network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, credalNet: "CredalNet"):
        r"""__init__(self, credalNet) -> CNMonteCarloSampling"""
        _pyAgrum.CNMonteCarloSampling_swiginit(self, _pyAgrum.new_CNMonteCarloSampling(credalNet))

        self._model=credalNet



    __swig_destroy__ = _pyAgrum.delete_CNMonteCarloSampling

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Starts the inference.

        """
        return _pyAgrum.CNMonteCarloSampling_makeInference(self)

    def insertEvidenceFile(self, path: "std::string const &") -> "void":
        r"""
        insertEvidenceFile(self, path)

        Insert evidence from file.

        Parameters
        ----------
        path : str
        	the path to the evidence file. 

        """
        return _pyAgrum.CNMonteCarloSampling_insertEvidenceFile(self, path)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.CNMonteCarloSampling_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.CNMonteCarloSampling_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.CNMonteCarloSampling_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.CNMonteCarloSampling_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.CNMonteCarloSampling_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.CNMonteCarloSampling_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.CNMonteCarloSampling_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.CNMonteCarloSampling_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.CNMonteCarloSampling_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.CNMonteCarloSampling_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.CNMonteCarloSampling_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.CNMonteCarloSampling_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.CNMonteCarloSampling_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.CNMonteCarloSampling_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.CNMonteCarloSampling_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.CNMonteCarloSampling_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.CNMonteCarloSampling__asIApproximationSchemeConfiguration(self)

    def setRepetitiveInd(self, flag: "bool const") -> "void":
        r"""
        setRepetitiveInd(self, flag)

        Parameters
        ----------
        flag : bool
        	True if repetitive independence is to be used, false otherwise. Only usefull with dynamic networks. 

        """
        return _pyAgrum.CNMonteCarloSampling_setRepetitiveInd(self, flag)

    def marginalMax(self, *args) -> "gum::Potential< double >":
        r"""
        marginalMax(self, id) -> Potential
        marginalMax(self, name) -> Potential

        Get the upper marginals of a given node id.

        Parameters
        ----------
        id : int
        	the node id which upper marginals we want.
        varName : str
        	the variable name which upper marginals we want. 

        Returns
        -------
        list
            a constant reference to this node upper marginals.

        Raises
        ------
        gum.IndexError
        	If the node does not belong to the Credal network

        """
        return _pyAgrum.CNMonteCarloSampling_marginalMax(self, *args)

    def marginalMin(self, *args) -> "gum::Potential< double >":
        r"""
        marginalMin(self, id) -> Potential
        marginalMin(self, name) -> Potential

        Get the lower marginals of a given node id.

        Parameters
        ----------
        id : int
        	the node id which lower marginals we want.
        varName : str
        	the variable name which lower marginals we want. 

        Returns
        -------
        list
            a constant reference to this node lower marginals.

        Raises
        ------
        gum.IndexError
        	If the node does not belong to the Credal network

        """
        return _pyAgrum.CNMonteCarloSampling_marginalMin(self, *args)

    def insertModalsFile(self, path: "std::string const &") -> "void":
        r"""
        insertModalsFile(self, path)

        Insert variables modalities from file to compute expectations.

        Parameters
        ----------
        path : str
        	The path to the modalities file. 

        """
        return _pyAgrum.CNMonteCarloSampling_insertModalsFile(self, path)

    def dynamicExpMax(self, varName: "std::string const &") -> "std::vector< double,std::allocator< double > > const &":
        r"""
        dynamicExpMax(self, varName) -> Vector

        Get the upper dynamic expectation of a given variable prefix.

        Parameters
        ----------
        varName : str
        	the variable name prefix which upper expectation we want.

        Returns
        -------
        double
            a constant reference to the variable upper expectation over all time steps. 

        """
        return _pyAgrum.CNMonteCarloSampling_dynamicExpMax(self, varName)

    def dynamicExpMin(self, varName: "std::string const &") -> "std::vector< double,std::allocator< double > > const &":
        r"""
        dynamicExpMin(self, varName) -> Vector

        Get the lower dynamic expectation of a given variable prefix.

        Parameters
        ----------
        varName : str
        	the variable name prefix which lower expectation we want.

        Returns
        -------
        double
            a constant reference to the variable lower expectation over all time steps. 

        """
        return _pyAgrum.CNMonteCarloSampling_dynamicExpMin(self, varName)

    def CN(self) -> "gum::credal::CredalNet< double > const &":
        r"""CN(self) -> CredalNet"""
        return _pyAgrum.CNMonteCarloSampling_CN(self)

# Register CNMonteCarloSampling in _pyAgrum:
_pyAgrum.CNMonteCarloSampling_swigregister(CNMonteCarloSampling)

class CNLoopyPropagation(object):
    r"""



    Class used for inferences in credal networks with Loopy Propagation algorithm.

    CNLoopyPropagation(cn) -> CNLoopyPropagation
        Parameters:
          * **cn** (*pyAgrum.CredalNet*) -- a Credal network

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    InferenceType_nodeToNeighbours = _pyAgrum.CNLoopyPropagation_InferenceType_nodeToNeighbours
    
    InferenceType_ordered = _pyAgrum.CNLoopyPropagation_InferenceType_ordered
    
    InferenceType_randomOrder = _pyAgrum.CNLoopyPropagation_InferenceType_randomOrder
    

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Starts the inference.

        """
        return _pyAgrum.CNLoopyPropagation_makeInference(self)

    def inferenceType(self, *args) -> "gum::credal::CNLoopyPropagation< double >::InferenceType":
        r"""
        inferenceType(self, inft)
        inferenceType(self) -> gum::credal::CNLoopyPropagation< double >::InferenceType

        Returns
        -------
        int
        	the inference type

        """
        return _pyAgrum.CNLoopyPropagation_inferenceType(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Erase all inference related data to perform another one.

        You need to insert evidence again if needed but modalities are kept. You can insert new ones by using the appropriate method which will delete the old ones.

        """
        return _pyAgrum.CNLoopyPropagation_eraseAllEvidence(self)

    def saveInference(self, path: "std::string const &") -> "void":
        r"""
        saveInference(self, path)

        Saves marginals.

        Parameters
        ----------
        path : str
        	The path to the file to save marginals. 

        """
        return _pyAgrum.CNLoopyPropagation_saveInference(self, path)

    def __init__(self, cnet: "CredalNet"):
        r"""__init__(self, cnet) -> CNLoopyPropagation"""
        _pyAgrum.CNLoopyPropagation_swiginit(self, _pyAgrum.new_CNLoopyPropagation(cnet))

        self._model=cnet



    __swig_destroy__ = _pyAgrum.delete_CNLoopyPropagation

    def insertEvidenceFile(self, path: "std::string const &") -> "void":
        r"""
        insertEvidenceFile(self, path)

        Insert evidence from file.

        Parameters
        ----------
        path : str
        	the path to the evidence file. 

        """
        return _pyAgrum.CNLoopyPropagation_insertEvidenceFile(self, path)

    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.CNLoopyPropagation_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.CNLoopyPropagation_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.CNLoopyPropagation_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.CNLoopyPropagation_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.CNLoopyPropagation_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.CNLoopyPropagation_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.CNLoopyPropagation_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.CNLoopyPropagation_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.CNLoopyPropagation_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.CNLoopyPropagation_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.CNLoopyPropagation_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.CNLoopyPropagation_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.CNLoopyPropagation_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.CNLoopyPropagation_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.CNLoopyPropagation_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.CNLoopyPropagation_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.CNLoopyPropagation__asIApproximationSchemeConfiguration(self)

    def setRepetitiveInd(self, flag: "bool const") -> "void":
        r"""
        setRepetitiveInd(self, flag)

        Parameters
        ----------
        flag : bool
        	True if repetitive independence is to be used, false otherwise. Only usefull with dynamic networks. 

        """
        return _pyAgrum.CNLoopyPropagation_setRepetitiveInd(self, flag)

    def marginalMax(self, *args) -> "gum::Potential< double >":
        r"""
        marginalMax(self, id) -> Potential
        marginalMax(self, name) -> Potential

        Get the upper marginals of a given node id.

        Parameters
        ----------
        id : int
        	the node id which upper marginals we want.
        varName : str
        	the variable name which upper marginals we want. 

        Returns
        -------
        list
            a constant reference to this node upper marginals.

        Raises
        ------
        gum.IndexError
        	If the node does not belong to the Credal network

        """
        return _pyAgrum.CNLoopyPropagation_marginalMax(self, *args)

    def marginalMin(self, *args) -> "gum::Potential< double >":
        r"""
        marginalMin(self, id) -> Potential
        marginalMin(self, name) -> Potential

        Get the lower marginals of a given node id.

        Parameters
        ----------
        id : int
        	the node id which lower marginals we want.
        varName : str
        	the variable name which lower marginals we want. 

        Returns
        -------
        list
            a constant reference to this node lower marginals.

        Raises
        ------
        gum.IndexError
        	If the node does not belong to the Credal network

        """
        return _pyAgrum.CNLoopyPropagation_marginalMin(self, *args)

    def insertModalsFile(self, path: "std::string const &") -> "void":
        r"""
        insertModalsFile(self, path)

        Insert variables modalities from file to compute expectations.

        Parameters
        ----------
        path : str
        	The path to the modalities file. 

        """
        return _pyAgrum.CNLoopyPropagation_insertModalsFile(self, path)

    def dynamicExpMax(self, varName: "std::string const &") -> "std::vector< double,std::allocator< double > > const &":
        r"""
        dynamicExpMax(self, varName) -> Vector

        Get the upper dynamic expectation of a given variable prefix.

        Parameters
        ----------
        varName : str
        	the variable name prefix which upper expectation we want.

        Returns
        -------
        double
            a constant reference to the variable upper expectation over all time steps. 

        """
        return _pyAgrum.CNLoopyPropagation_dynamicExpMax(self, varName)

    def dynamicExpMin(self, varName: "std::string const &") -> "std::vector< double,std::allocator< double > > const &":
        r"""
        dynamicExpMin(self, varName) -> Vector

        Get the lower dynamic expectation of a given variable prefix.

        Parameters
        ----------
        varName : str
        	the variable name prefix which lower expectation we want.

        Returns
        -------
        double
            a constant reference to the variable lower expectation over all time steps. 

        """
        return _pyAgrum.CNLoopyPropagation_dynamicExpMin(self, varName)

    def CN(self) -> "gum::credal::CredalNet< double > const &":
        r"""CN(self) -> CredalNet"""
        return _pyAgrum.CNLoopyPropagation_CN(self)

# Register CNLoopyPropagation in _pyAgrum:
_pyAgrum.CNLoopyPropagation_swigregister(CNLoopyPropagation)

class InfluenceDiagram(DAGmodel):
    r"""



    InfluenceDiagram represents an Influence Diagram.

    InfluenceDiagram() -> InfluenceDiagram
        default constructor

    InfluenceDiagram(source) -> InfluenceDiagram
        Parameters:
            * **source** (*pyAgrum.InfluenceDiagram*) -- the InfluenceDiagram to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    @staticmethod
    def fastPrototype(dotlike: "std::string const &", domainSize: "gum::Size"=2) -> "gum::InfluenceDiagram< double >":
        r"""
        fastPrototype(dotlike, domainSize=2) -> InfluenceDiagram

        Create an Influence Diagram with a dot-like syntax which specifies:
            - the structure 'a->b<-c;b->d;c<-e;'.
            - a prefix for the type of node (chance/decision/utiliy nodes):

              - `a` : a chance node named 'a' (by default)
              - `$a` : a utility node named 'a'
              - `*a` : a decision node named 'a'

            - the type of the variables with different syntax as postfix:

              - by default, a variable is a gum.RangeVariable using the default domain size (second argument)
              - with `'a[10]'`, the variable is a gum.RangeVariable using 10 as domain size (from 0 to 9)
              - with `'a[3,7]'`, the variable is a gum.RangeVariable using a domainSize from 3 to 7
              - with `'a[1,3.14,5,6.2]'`, the variable is a gum.DiscretizedVariable using the given ticks (at least 3 values)
              - with `'a{top|middle|bottom}'`, the variable is a gum.LabelizedVariable using the given labels.
              - with 'a{-1|5|0|3}', the variable is a gum.IntegerVariable using the sorted given values.

        Note 
        ----
          - If the dot-like string contains such a specification more than once for a variable, the first specification will be used.
          - the potentials (probabilities, utilities) are randomly generated.
          - see also pyAgrum.fastID.

        Examples
        --------
        >>> import pyAgrum as gum
        >>> bn=gum.fastID('A->B[1,3]<-*C{yes|No}->$D<-E[1,2.5,3.9]',6)

        Parameters
        ----------
        dotlike : str
                the string containing the specification
        domainSize : int
                the default domain size for variables

        Returns
        -------
        pyAgrum.InfluenceDiagram
                the resulting Influence Diagram

        """
        return _pyAgrum.InfluenceDiagram_fastPrototype(dotlike, domainSize)
    __swig_destroy__ = _pyAgrum.delete_InfluenceDiagram

    def __init__(self, *args):
        r"""
        __init__(self) -> InfluenceDiagram
        __init__(self, source) -> InfluenceDiagram
        """
        _pyAgrum.InfluenceDiagram_swiginit(self, _pyAgrum.new_InfluenceDiagram(*args))

    def toDot(self) -> "std::string":
        r"""
        toDot(self) -> std::string

        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.InfluenceDiagram_toDot(self)

    def clear(self) -> "void":
        r"""clear(self)"""
        return _pyAgrum.InfluenceDiagram_clear(self)

    def cpt(self, *args) -> "gum::Potential< double > const &":
        r"""
        cpt(self, varId) -> Potential
        cpt(self, name) -> Potential

        Returns the CPT of a variable.

        Parameters
        ----------
        VarId : int
        	A variable's id in the pyAgrum.BayesNet.

        Returns
        -------
        pyAgrum.Potential
        	The variable's CPT. 

        Raises
        ------
        gum.NotFound
        	If no variable's id matches varId. 

        """
        return _pyAgrum.InfluenceDiagram_cpt(self, *args)

    def utility(self, *args) -> "gum::Potential< double > const &":
        r"""
        utility(self, varId) -> Potential
        utility(self, name) -> Potential

        Parameters
        ----------
        varId : int 
        	the tested node id.

        Returns
        -------
        pyAgrum.Potential
        	the utility table of the node

        Raises
        ------
        gum.IndexError
        	If the InfluenceDiagram does not contain the variable

        """
        return _pyAgrum.InfluenceDiagram_utility(self, *args)

    def isUtilityNode(self, *args) -> "bool":
        r"""
        isUtilityNode(self, varId) -> bool
        isUtilityNode(self, name) -> bool

        Parameters
        ----------
        varId : int 
        	the tested node id.

        Returns
        -------
        bool
        	true if node is an utility node

        """
        return _pyAgrum.InfluenceDiagram_isUtilityNode(self, *args)

    def isDecisionNode(self, *args) -> "bool":
        r"""
        isDecisionNode(self, varId) -> bool
        isDecisionNode(self, name) -> bool

        Parameters
        ----------
        varId : int 
        	the tested node id.

        Returns
        -------
        bool
        	true if node is a decision node

        """
        return _pyAgrum.InfluenceDiagram_isDecisionNode(self, *args)

    def isChanceNode(self, *args) -> "bool":
        r"""
        isChanceNode(self, varId) -> bool
        isChanceNode(self, name) -> bool

        Parameters
        ----------
        varId : int 
        	the tested node id.

        Returns
        -------
        bool
        	true if node is a chance node

        """
        return _pyAgrum.InfluenceDiagram_isChanceNode(self, *args)

    def utilityNodeSize(self) -> "gum::Size":
        r"""
        utilityNodeSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of utility nodes

        """
        return _pyAgrum.InfluenceDiagram_utilityNodeSize(self)

    def chanceNodeSize(self) -> "gum::Size":
        r"""
        chanceNodeSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of chance nodes. 

        """
        return _pyAgrum.InfluenceDiagram_chanceNodeSize(self)

    def decisionNodeSize(self) -> "gum::Size":
        r"""
        decisionNodeSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of decision nodes

        """
        return _pyAgrum.InfluenceDiagram_decisionNodeSize(self)

    def variable(self, *args) -> "gum::DiscreteVariable const &":
        r"""
        variable(self, id) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable

        Parameters
        ----------
        id : int
         	the node id

        Returns
        ------
        pyAgrum.DiscreteVariable
        	a constant reference over a variabe given it's node id

        Raises
        ------
        gum.NotFound
        	If no variable's id matches the parameter 

        """
        return _pyAgrum.InfluenceDiagram_variable(self, *args)

    def nodeId(self, var: "DiscreteVariable") -> "gum::NodeId":
        r"""
        nodeId(self, var) -> gum::NodeId

        Parameters
        ----------
        var : pyAgrum.DiscreteVariable
        	a variable

        Returns
        -------
        int
        	the id of the variable

        Raises
        ------
        gum.IndexError
        	If the InfluenceDiagram does not contain the variable

        """
        return _pyAgrum.InfluenceDiagram_nodeId(self, var)

    def idFromName(self, name: "std::string const &") -> "gum::NodeId":
        r"""
        idFromName(self, name) -> gum::NodeId

        Returns a variable's id given its name.

        Parameters
        ----------
        name : str
        	the variable's name from which the id is returned.

        Returns
        -------
        int
        	the variable's node id. 

        Raises
        ------
        gum.NotFound
        	If no such name exists in the graph. 

        """
        return _pyAgrum.InfluenceDiagram_idFromName(self, name)

    def variableFromName(self, name: "std::string const &") -> "gum::DiscreteVariable const &":
        r"""
        variableFromName(self, name) -> DiscreteVariable

        Parameters
        ----------
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the InfluenceDiagram does not contain the variable

        """
        return _pyAgrum.InfluenceDiagram_variableFromName(self, name)

    def add(self, variable: "DiscreteVariable", id: "gum::NodeId"=0) -> "gum::NodeId":
        r"""
        add(self, variable, id=0) -> gum::NodeId

        Add a chance variable, it's associate node and it's CPT.

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy.
        id : int
        	The chosen id. If 0, the NodeGraphPart will choose.

        Warnings
        --------
        give an id (not 0) should be reserved for rare and specific situations !!! 

        Returns
        -------
        int
            the id of the added variable. 

        Raises
        ------
        gum.DuplicateElement
        	If id(<>0) is already used 

        """
        return _pyAgrum.InfluenceDiagram_add(self, variable, id)

    def addDecisionNode(self, variable: "DiscreteVariable", id: "gum::NodeId"=0) -> "gum::NodeId":
        r"""
        addDecisionNode(self, variable, id=0) -> gum::NodeId

        Add a decision variable.

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added by copy.
        id : int
        	the chosen id. If 0, the NodeGraphPart will choose.

        Warnings
        --------
        give an id (not 0) should be reserved for rare and specific situations !!! 

        Returns
        -------
        int
            the id of the added variable. 

        Raises
        ------
        gum.DuplicateElement
        	If id(<>0) is already used 

        """
        return _pyAgrum.InfluenceDiagram_addDecisionNode(self, variable, id)

    def addChanceNode(self, *args) -> "gum::NodeId":
        r"""
        addChanceNode(self, variable, id=0) -> gum::NodeId
        addChanceNode(self, variable, aContent, id=0) -> gum::NodeId

        Add a chance variable, it's associate node and it's CPT.

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added by copy.
        id : int
        	the chosen id. If 0, the NodeGraphPart will choose.

        Warnings
        --------
        give an id (not 0) should be reserved for rare and specific situations !!! 

        Returns
        -------
        int
            the id of the added variable. 

        Raises
        ------
        gum.DuplicateElement
        	If id(<>0) is already used 

        """
        return _pyAgrum.InfluenceDiagram_addChanceNode(self, *args)

    def addUtilityNode(self, *args) -> "gum::NodeId":
        r"""
        addUtilityNode(self, variable, id=0) -> gum::NodeId
        addUtilityNode(self, variable, aContent, id=0) -> gum::NodeId

        Add a utility variable, it's associate node and it's UT. 

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added by copy
        id : int
        	the chosen id. If 0, the NodeGraphPart will choose

        Warnings
        --------
        give an id (not 0) should be reserved for rare and specific situations !!! 

        Returns
        -------
        int
            the id of the added variable. 

        Raises
        ------
        gum.InvalidArgument
        	If variable has more than one label
        gum.DuplicateElement
        	If id(<>0) is already used 

        """
        return _pyAgrum.InfluenceDiagram_addUtilityNode(self, *args)

    def erase(self, *args) -> "void":
        r"""
        erase(self, id)
        erase(self, name)
        erase(self, var)

        Erase a Variable from the network and remove the variable from all his childs.

        If no variable matches the id, then nothing is done.

        Parameters
        ----------
        id : int
        	The id of the variable to erase.
        var : pyAgrum.DiscreteVariable
        	The reference on the variable to remove. 

        """
        return _pyAgrum.InfluenceDiagram_erase(self, *args)

    def changeVariableName(self, *args) -> "void":
        r"""
        changeVariableName(self, id, new_name)
        changeVariableName(self, name, new_name)

        Parameters
        ----------
        id : int
        	the node Id
        new_name : str
        	the name of the variable 

        Raises
        ------
        gum.DuplicateLabel
        	If this name already exists
        gum.NotFound
        	If no nodes matches id. 

        """
        return _pyAgrum.InfluenceDiagram_changeVariableName(self, *args)

    def addArc(self, *args) -> "void":
        r"""
        addArc(self, tail, head)
        addArc(self, tail, head)

        Add an arc in the ID, and update diagram's potential nodes cpt if necessary.

        Parameters
        ----------
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        Raises
        ------
        gum.InvalidEdge
        	If arc.tail and/or arc.head are not in the ID.
        gum.InvalidEdge
        	If tail is a utility node 

        """
        return _pyAgrum.InfluenceDiagram_addArc(self, *args)

    def eraseArc(self, *args) -> "void":
        r"""
        eraseArc(self, arc)
        eraseArc(self, tail, head)
        eraseArc(self, tail, head)

        Removes an arc in the ID, and update diagram's potential nodes cpt if necessary.

        If (tail, head) doesn't exist, the nothing happens.

        Parameters
        ----------
        arc : pyAgrum.Arc
        	The arc to be removed.
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        """
        return _pyAgrum.InfluenceDiagram_eraseArc(self, *args)

    def decisionOrderExists(self) -> "bool":
        r"""
        decisionOrderExists(self) -> bool

        Returns
        -------
        bool
        	True if a directed path exist with all decision node

        """
        return _pyAgrum.InfluenceDiagram_decisionOrderExists(self)

    def getDecisionGraph(self) -> "gum::DAG *":
        r"""
        getDecisionGraph(self) -> DAG

        Returns
        -------
        pyAgrum.DAG
        	the temporal Graph. 

        """
        return _pyAgrum.InfluenceDiagram_getDecisionGraph(self)

    def decisionOrder(self) -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > >":
        r"""decisionOrder(self) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > >"""
        return _pyAgrum.InfluenceDiagram_decisionOrder(self)

    def existsPathBetween(self, *args) -> "bool":
        r"""
        existsPathBetween(self, src, dest) -> bool
        existsPathBetween(self, src, dest) -> bool

        Returns
        -------
        bool
        	true if a path exists between two nodes. 

        """
        return _pyAgrum.InfluenceDiagram_existsPathBetween(self, *args)

    def loadBIFXML(self, *args) -> "bool":
        r"""
        loadBIFXML(self, name, l=(PyObject *) 0) -> bool

        Load a BIFXML file.

        Parameters
        ----------
        name : str
        	the name's file

        Raises
        ------
        gum.IOError
        	If file not found
        gum.FatalError
        	If file is not valid

        """
        return _pyAgrum.InfluenceDiagram_loadBIFXML(self, *args)

    def saveBIFXML(self, name: "std::string") -> "void":
        r"""
        saveBIFXML(self, name)

        Save the BayesNet in a BIFXML file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.InfluenceDiagram_saveBIFXML(self, name)

    def names(self) -> "PyObject *":
        r"""
        names(self) -> PyObject *

        Returns
        -------
        list
        	The names of the InfluenceDiagram variables

        """
        return _pyAgrum.InfluenceDiagram_names(self)

    def nodes(self) -> "PyObject *":
        r"""
        nodes(self) -> PyObject *

        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.InfluenceDiagram_nodes(self)

    def connectedComponents(self):
      """ connected components from a graph/BN

      Compute the connected components of a pyAgrum's graph or Bayesian Network
      (more generally an object that has `nodes`, `children`/`parents` or `neighbours` methods)

      The firstly visited node for each component is called a 'root' and is used as a key for the component.
      This root has been arbitrarily chosen during the algorithm.

      Returns
      -------
      dict(int,Set[int])
        dict of connected components (as set of nodeIds (int)) with a nodeId (root) of each component as key.

      """
      nodes=self.nodes()
      connected_components=dict()

      def parcours(node,orig):
          cc={node}
          nodes.discard(node)
          if hasattr(self,'children'):
              for chi in self.children(node):
                  if chi!=orig:
                      if chi in nodes:
                          cc|=parcours(chi,node)

          if hasattr(self,'parents'):
              for par in self.parents(node):
                  if par!=orig:
                      if par in nodes:
                          cc|=parcours(par,node)

          if hasattr(self,'neighbours'):
              for nei in self.neighbours(node):
                  if nei!=orig:
                      if nei in nodes:
                          cc|=parcours(nei,node)
          return cc       

      while (len(nodes)>0):
          root=nodes.pop()
          connected_components[root]=parcours(root,None)
      return connected_components


    def arcs(self) -> "PyObject *":
        r"""
        arcs(self) -> PyObject *

        Returns
        -------
        list:
        	the list of all the arcs in the Influence Diagram.

        """
        return _pyAgrum.InfluenceDiagram_arcs(self)

    def parents(self, norid: "PyObject *") -> "PyObject *":
        r"""
        parents(self, norid) -> PyObject *

        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        set
            the set of the parents ids.

        """
        return _pyAgrum.InfluenceDiagram_parents(self, norid)

    def children(self, norid: "PyObject *") -> "PyObject *":
        r"""
        children(self, norid) -> PyObject *

        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.InfluenceDiagram_children(self, norid)

    def family(self, norid: "PyObject *") -> "PyObject *":
        r"""family(self, norid) -> PyObject *"""
        return _pyAgrum.InfluenceDiagram_family(self, norid)

    def descendants(self, norid: "PyObject *") -> "PyObject *":
        r"""descendants(self, norid) -> PyObject *"""
        return _pyAgrum.InfluenceDiagram_descendants(self, norid)

    def ancestors(self, norid: "PyObject *") -> "PyObject *":
        r"""ancestors(self, norid) -> PyObject *"""
        return _pyAgrum.InfluenceDiagram_ancestors(self, norid)

    def moralizedAncestralGraph(self, nodes: "PyObject *") -> "gum::UndiGraph":
        r"""moralizedAncestralGraph(self, nodes) -> UndiGraph"""
        return _pyAgrum.InfluenceDiagram_moralizedAncestralGraph(self, nodes)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.InfluenceDiagram___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.InfluenceDiagram___str__(self)

# Register InfluenceDiagram in _pyAgrum:
_pyAgrum.InfluenceDiagram_swigregister(InfluenceDiagram)

def InfluenceDiagram_fastPrototype(dotlike: "std::string const &", domainSize: "gum::Size"=2) -> "gum::InfluenceDiagram< double >":
    r"""
    InfluenceDiagram_fastPrototype(dotlike, domainSize=2) -> InfluenceDiagram

    Create an Influence Diagram with a dot-like syntax which specifies:
        - the structure 'a->b<-c;b->d;c<-e;'.
        - a prefix for the type of node (chance/decision/utiliy nodes):

          - `a` : a chance node named 'a' (by default)
          - `$a` : a utility node named 'a'
          - `*a` : a decision node named 'a'

        - the type of the variables with different syntax as postfix:

          - by default, a variable is a gum.RangeVariable using the default domain size (second argument)
          - with `'a[10]'`, the variable is a gum.RangeVariable using 10 as domain size (from 0 to 9)
          - with `'a[3,7]'`, the variable is a gum.RangeVariable using a domainSize from 3 to 7
          - with `'a[1,3.14,5,6.2]'`, the variable is a gum.DiscretizedVariable using the given ticks (at least 3 values)
          - with `'a{top|middle|bottom}'`, the variable is a gum.LabelizedVariable using the given labels.
          - with 'a{-1|5|0|3}', the variable is a gum.IntegerVariable using the sorted given values.

    Note 
    ----
      - If the dot-like string contains such a specification more than once for a variable, the first specification will be used.
      - the potentials (probabilities, utilities) are randomly generated.
      - see also pyAgrum.fastID.

    Examples
    --------
    >>> import pyAgrum as gum
    >>> bn=gum.fastID('A->B[1,3]<-*C{yes|No}->$D<-E[1,2.5,3.9]',6)

    Parameters
    ----------
    dotlike : str
            the string containing the specification
    domainSize : int
            the default domain size for variables

    Returns
    -------
    pyAgrum.InfluenceDiagram
            the resulting Influence Diagram

    """
    return _pyAgrum.InfluenceDiagram_fastPrototype(dotlike, domainSize)

class ShaferShenoyLIMIDInference(object):
    r"""



    This inference considers the provided model as a LIMID rather than an influence diagram. It is an optimized
    implementation of the LIMID resolution algorithm. However an inference on a classical influence diagram can be performed
    by adding a assumption of the existence of the sequence of decision nodes to be solved, which also implies that the
    decision choices can have an impact on the rest of the sequence (Non Forgetting Assumption,
    cf. pyAgrum.ShaferShenoyLIMIDInference.addNoForgettingAssumption).

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, infDiag: "InfluenceDiagram"):
        r"""__init__(self, infDiag) -> ShaferShenoyLIMIDInference"""
        _pyAgrum.ShaferShenoyLIMIDInference_swiginit(self, _pyAgrum.new_ShaferShenoyLIMIDInference(infDiag))

        self._model=infDiag



    __swig_destroy__ = _pyAgrum.delete_ShaferShenoyLIMIDInference

    def junctionTree(self) -> "gum::JunctionTree const *":
        r"""junctionTree(self) -> CliqueGraph"""
        val = _pyAgrum.ShaferShenoyLIMIDInference_junctionTree(self)

        val._engine=self


        return val


    def clear(self) -> "void":
        r"""clear(self)"""
        return _pyAgrum.ShaferShenoyLIMIDInference_clear(self)

    def addNoForgettingAssumption(self, *args) -> "void":
        r"""
        addNoForgettingAssumption(self, ids)
        addNoForgettingAssumption(self, names)
        """
        return _pyAgrum.ShaferShenoyLIMIDInference_addNoForgettingAssumption(self, *args)

    def hasNoForgettingAssumption(self) -> "bool":
        r"""hasNoForgettingAssumption(self) -> bool"""
        return _pyAgrum.ShaferShenoyLIMIDInference_hasNoForgettingAssumption(self)

    def reducedGraph(self) -> "gum::DAG":
        r"""reducedGraph(self) -> DAG"""
        return _pyAgrum.ShaferShenoyLIMIDInference_reducedGraph(self)

    def reversePartialOrder(self) -> "std::vector< gum::NodeSet,std::allocator< gum::NodeSet > >":
        r"""reversePartialOrder(self) -> std::vector< gum::NodeSet,std::allocator< gum::NodeSet > >"""
        return _pyAgrum.ShaferShenoyLIMIDInference_reversePartialOrder(self)

    def reducedLIMID(self) -> "gum::InfluenceDiagram< double >":
        r"""reducedLIMID(self) -> InfluenceDiagram"""
        return _pyAgrum.ShaferShenoyLIMIDInference_reducedLIMID(self)

    def isSolvable(self) -> "bool":
        r"""isSolvable(self) -> bool"""
        return _pyAgrum.ShaferShenoyLIMIDInference_isSolvable(self)

    def optimalDecision(self, *args) -> "gum::Potential< double >":
        r"""
        optimalDecision(self, decisionId) -> Potential
        optimalDecision(self, decisionName) -> Potential

        Returns best choice for decision variable given in parameter ( based upon MEU criteria )

        Parameters
        ----------
        decisionId : int,str
        	the id or name of the decision variable

        Raises
        ------
        gum.OperationNotAllowed
        	If no inference have yet been made
        gum.InvalidNode
        	If node given in parmaeter is not a decision node 

        """
        return _pyAgrum.ShaferShenoyLIMIDInference_optimalDecision(self, *args)

    def posteriorUtility(self, *args) -> "gum::Potential< double > const &":
        r"""
        posteriorUtility(self, node) -> Potential
        posteriorUtility(self, name) -> Potential
        """
        return _pyAgrum.ShaferShenoyLIMIDInference_posteriorUtility(self, *args)

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the influence diagram
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def hardEvidenceNodes(self) -> "PyObject *":
        r"""hardEvidenceNodes(self) -> PyObject *"""
        return _pyAgrum.ShaferShenoyLIMIDInference_hardEvidenceNodes(self)

    def softEvidenceNodes(self) -> "PyObject *":
        r"""softEvidenceNodes(self) -> PyObject *"""
        return _pyAgrum.ShaferShenoyLIMIDInference_softEvidenceNodes(self)

    def MEU(self, *args) -> "PyObject *":
        r"""
        MEU(self) -> std::pair< double,double >
        MEU(self) -> PyObject *

        Returns maximum expected utility obtained from inference.

        Raises
        ------
        gum.OperationNotAllowed
        	If no inference have yet been made 

        """
        return _pyAgrum.ShaferShenoyLIMIDInference_MEU(self, *args)

    def meanVar(self, *args) -> "PyObject *":
        r"""
        meanVar(self, node) -> std::pair< double,double >
        meanVar(self, name) -> std::pair< double,double >
        meanVar(self, node) -> PyObject *
        """
        return _pyAgrum.ShaferShenoyLIMIDInference_meanVar(self, *args)

    def makeInference(self) -> "void":
        r"""
        makeInference(self)

        Makes the inference. 

        """
        return _pyAgrum.ShaferShenoyLIMIDInference_makeInference(self)

    def posterior(self, *args) -> "gum::Potential< double > const":
        r"""
        posterior(self, node) -> Potential
        posterior(self, name) -> Potential
        posterior(self, var) -> Potential
        posterior(self, nodeName) -> Potential
        """
        return _pyAgrum.ShaferShenoyLIMIDInference_posterior(self, *args)

    def addEvidence(self, *args) -> "void":
        r"""
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)
        """
        return _pyAgrum.ShaferShenoyLIMIDInference_addEvidence(self, *args)

    def chgEvidence(self, *args) -> "void":
        r"""
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)
        """
        return _pyAgrum.ShaferShenoyLIMIDInference_chgEvidence(self, *args)

    def hasEvidence(self, *args) -> "bool":
        r"""
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool
        """
        return _pyAgrum.ShaferShenoyLIMIDInference_hasEvidence(self, *args)

    def eraseAllEvidence(self) -> "void":
        r"""
        eraseAllEvidence(self)

        Removes all the evidence entered into the diagram.

        """
        return _pyAgrum.ShaferShenoyLIMIDInference_eraseAllEvidence(self)

    def eraseEvidence(self, *args) -> "void":
        r"""
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)

        Parameters
        ----------
        evidence : pyAgrum.Potential
        	the evidence to remove

        Raises
        ------
        gum.IndexError
        	If the evidence does not belong to the influence diagram

        """
        return _pyAgrum.ShaferShenoyLIMIDInference_eraseEvidence(self, *args)

    def hasHardEvidence(self, nodeName: "std::string const &") -> "bool":
        r"""hasHardEvidence(self, nodeName) -> bool"""
        return _pyAgrum.ShaferShenoyLIMIDInference_hasHardEvidence(self, nodeName)

    def hasSoftEvidence(self, *args) -> "bool":
        r"""
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool
        """
        return _pyAgrum.ShaferShenoyLIMIDInference_hasSoftEvidence(self, *args)

    def nbrEvidence(self) -> "gum::Size":
        r"""nbrEvidence(self) -> gum::Size"""
        return _pyAgrum.ShaferShenoyLIMIDInference_nbrEvidence(self)

    def nbrHardEvidence(self) -> "gum::Size":
        r"""nbrHardEvidence(self) -> gum::Size"""
        return _pyAgrum.ShaferShenoyLIMIDInference_nbrHardEvidence(self)

    def nbrSoftEvidence(self) -> "gum::Size":
        r"""nbrSoftEvidence(self) -> gum::Size"""
        return _pyAgrum.ShaferShenoyLIMIDInference_nbrSoftEvidence(self)

    def influenceDiagram(self) -> "gum::InfluenceDiagram< double > const &":
        r"""
        influenceDiagram(self) -> InfluenceDiagram

        Returns a constant reference over the InfluenceDiagram on which this class work.

        Returns
        -------
        pyAgrum.InfluenceDiagram
        	the InfluenceDiagram on which this class work

        """
        return _pyAgrum.ShaferShenoyLIMIDInference_influenceDiagram(self)

# Register ShaferShenoyLIMIDInference in _pyAgrum:
_pyAgrum.ShaferShenoyLIMIDInference_swigregister(ShaferShenoyLIMIDInference)

class BNLearner(object):
    r"""



    BNLearner(filename,inducedTypes=True) -> BNLearner
        Parameters:
            * **filename** (*str*) -- the file to learn from
            * **inducedTypes** (*Bool*) -- whether BNLearner should try to automatically find the type of each variable

    BNLearner(filename,src) -> BNLearner
        Parameters:
            * **filename** (*str*) -- the file to learn from
            * **src** (*pyAgrum.BayesNet*) -- the Bayesian network used to find those modalities

    BNLearner(learner) -> BNLearner
        Parameters:
            * **learner** (*pyAgrum.BNLearner*) -- the BNLearner to copy

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(self, filename, induceTypes=True, missingSymbols={"?"}) -> BNLearner
        __init__(self, db) -> BNLearner
        __init__(self, filename, src, missing_symbols={"?"}) -> BNLearner
        __init__(self, arg2) -> BNLearner
        __init__(self, arg2) -> BNLearner
        """
        _pyAgrum.BNLearner_swiginit(self, _pyAgrum.new_BNLearner(*args))
    __swig_destroy__ = _pyAgrum.delete_BNLearner

    def learnBN(self) -> "gum::BayesNet< double >":
        r"""
        learnBN(self) -> BayesNet

        learn a BayesNet from a file (must have read the db before)

        Returns
        -------
        pyAgrum.BayesNet
        	the learned BayesNet

        """
        return _pyAgrum.BNLearner_learnBN(self)

    def learnParameters(self, *args) -> "gum::BayesNet< double >":
        r"""
        learnParameters(self, dag, takeIntoAccountScore=True) -> BayesNet
        learnParameters(self, take_into_account_score=True) -> BayesNet

        learns a BN (its parameters) when its structure is known.

        Parameters
        ----------
        dag : pyAgrum.DAG
        bn : pyAgrum.BayesNet
        take_into_account_score : bool
        	The dag passed in argument may have been learnt from a structure learning. In this case, if the score used to learn the structure has an implicit apriori (like K2 which has a 1-smoothing apriori), it is important to also take into account this implicit apriori for parameter learning. By default, if a score exists, we will learn parameters by taking into account the apriori specified by methods useAprioriXXX () + the implicit apriori of the score, else we just take into account the apriori specified by useAprioriXXX ()

        Returns
        -------
        pyAgrum.BayesNet
        	the learned BayesNet

        Raises
        ------
        gum.MissingVariableInDatabase
        	If a variable of the BN is not found in the database
        gum.UnknownLabelInDatabase
        	If a label is found in the database that do not correspond to the variable

        """
        return _pyAgrum.BNLearner_learnParameters(self, *args)

    def __repr__(self) -> "std::string":
        r"""__repr__(self) -> std::string"""
        return _pyAgrum.BNLearner___repr__(self)

    def __str__(self) -> "std::string":
        r"""__str__(self) -> std::string"""
        return _pyAgrum.BNLearner___str__(self)

    def chi2(self, *args) -> "PyObject *":
        r"""
        chi2(self, var1, var2, knw={}) -> PyObject

        chi2 computes the chi2 statistic and pvalue for two columns, given a list of other columns.


        Parameters
        ----------
        name1: str
        	the name of the first column

        name2 : str
        	the name of the second column

        knowing : [str]
        	the list of names of conditioning columns

        Returns
        -------
        statistic,pvalue
        	the chi2 statistic and the associated p-value as a Tuple

        """
        return _pyAgrum.BNLearner_chi2(self, *args)

    def G2(self, *args) -> "PyObject *":
        r"""
        G2(self, var1, var2, knw={}) -> PyObject

        G2 computes the G2 statistic and pvalue for two columns, given a list of other columns.


        Parameters
        ----------
        name1: str
        	the name of the first column

        name2 : str
        	the name of the second column

        knowing : [str]
        	the list of names of conditioning columns

        Returns
        -------
        statistic,pvalue
        	the G2 statistic and the associated p-value as a Tuple

        """
        return _pyAgrum.BNLearner_G2(self, *args)

    def state(self) -> "PyObject *":
        r"""state(self) -> PyObject *"""
        return _pyAgrum.BNLearner_state(self)

    def pseudoCount(self,vars):
        """ access to pseudo-count (priors taken into account)

        Parameters
        ----------
        vars : list[str]
          a list of name of vars to add in the pseudo_count

        Returns
        -------
        a Potential containing this pseudo-counts
        """
        p=Potential()
        lv=list()
        for i in vars:
            if type(i) is str:
                name=i
            else:
                name=self.nameFromId(i)
            p.add(RangeVariable(name,name,0,self.domainSize(i)-1))
            lv.append(name)
        p.fillWith(self.rawPseudoCount(lv))
        return p


    def setVerbosity(self, v: "bool") -> "void":
        r"""
        setVerbosity(self, v)

        Parameters
        ----------
        v : bool
                verbosity

        """
        return _pyAgrum.BNLearner_setVerbosity(self, v)

    def setEpsilon(self, eps: "double") -> "void":
        r"""
        setEpsilon(self, eps)

        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfBounds
        	If eps<0

        """
        return _pyAgrum.BNLearner_setEpsilon(self, eps)

    def setMinEpsilonRate(self, rate: "double") -> "void":
        r"""
        setMinEpsilonRate(self, rate)

        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.BNLearner_setMinEpsilonRate(self, rate)

    def setMaxIter(self, max: "gum::Size") -> "void":
        r"""
        setMaxIter(self, max)

        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfBounds
        	If max <= 1

        """
        return _pyAgrum.BNLearner_setMaxIter(self, max)

    def setMaxTime(self, timeout: "double") -> "void":
        r"""
        setMaxTime(self, timeout)

        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfBounds
        	If timeout<=0.0

        """
        return _pyAgrum.BNLearner_setMaxTime(self, timeout)

    def setPeriodSize(self, p: "gum::Size") -> "void":
        r"""
        setPeriodSize(self, p)

        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.BNLearner_setPeriodSize(self, p)

    def verbosity(self) -> "bool":
        r"""
        verbosity(self) -> bool

        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.BNLearner_verbosity(self)

    def epsilon(self) -> "double":
        r"""
        epsilon(self) -> double

        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.BNLearner_epsilon(self)

    def minEpsilonRate(self) -> "double":
        r"""
        minEpsilonRate(self) -> double

        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.BNLearner_minEpsilonRate(self)

    def maxIter(self) -> "gum::Size":
        r"""
        maxIter(self) -> gum::Size

        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.BNLearner_maxIter(self)

    def maxTime(self) -> "double":
        r"""
        maxTime(self) -> double

        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.BNLearner_maxTime(self)

    def periodSize(self) -> "gum::Size":
        r"""
        periodSize(self) -> gum::Size

        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfBounds
        	If p<1

        """
        return _pyAgrum.BNLearner_periodSize(self)

    def nbrIterations(self) -> "gum::Size":
        r"""
        nbrIterations(self) -> gum::Size

        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.BNLearner_nbrIterations(self)

    def currentTime(self) -> "double":
        r"""
        currentTime(self) -> double

        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.BNLearner_currentTime(self)

    def messageApproximationScheme(self) -> "std::string":
        r"""
        messageApproximationScheme(self) -> std::string

        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.BNLearner_messageApproximationScheme(self)

    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        r"""
        history(self) -> Vector

        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.BNLearner_history(self)

    def _asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        r"""_asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration"""
        return _pyAgrum.BNLearner__asIApproximationSchemeConfiguration(self)

    def learnDAG(self) -> "gum::DAG":
        r"""
        learnDAG(self) -> DAG

        learn a structure from a file

        Returns
        -------
        pyAgrum.DAG
        	the learned DAG

        """
        return _pyAgrum.BNLearner_learnDAG(self)

    def names(self) -> "std::vector< std::string,std::allocator< std::string > > const &":
        r"""
        names(self) -> Vector_string

        Returns
        -------
        List[str]
        	the names of the variables in the database

        """
        return _pyAgrum.BNLearner_names(self)

    def idFromName(self, var_name: "std::string const &") -> "gum::NodeId":
        r"""
        idFromName(self, var_name) -> gum::NodeId

        Parameters
        ----------
        var_names : str
        	a variable's name

        Returns
        -------
        int
        	the column id corresponding to a variable name

        Raises
        ------
        gum.MissingVariableInDatabase
        	If a variable of the BN is not found in the database.

        """
        return _pyAgrum.BNLearner_idFromName(self, var_name)

    def nameFromId(self, id: "gum::NodeId") -> "std::string const &":
        r"""
        nameFromId(self, id) -> std::string const &

        Parameters
        ----------
        id
        	a node id

        Returns
        -------
        str
        	the variable's name

        """
        return _pyAgrum.BNLearner_nameFromId(self, id)

    def useScoreAIC(self) -> "void":
        r"""useScoreAIC(self)"""
        return _pyAgrum.BNLearner_useScoreAIC(self)

    def useScoreBD(self) -> "void":
        r"""useScoreBD(self)"""
        return _pyAgrum.BNLearner_useScoreBD(self)

    def useScoreBDeu(self) -> "void":
        r"""useScoreBDeu(self)"""
        return _pyAgrum.BNLearner_useScoreBDeu(self)

    def useScoreBIC(self) -> "void":
        r"""useScoreBIC(self)"""
        return _pyAgrum.BNLearner_useScoreBIC(self)

    def useScoreK2(self) -> "void":
        r"""useScoreK2(self)"""
        return _pyAgrum.BNLearner_useScoreK2(self)

    def useScoreLog2Likelihood(self) -> "void":
        r"""useScoreLog2Likelihood(self)"""
        return _pyAgrum.BNLearner_useScoreLog2Likelihood(self)

    def setDatabaseWeight(self, new_weight: "double const") -> "void":
        r"""
        setDatabaseWeight(self, new_weight)

        Set the database weight which is given as an equivalent sample size.

        Parameters
        ----------
        weight : double
        	the database weight

        """
        return _pyAgrum.BNLearner_setDatabaseWeight(self, new_weight)

    def setRecordWeight(self, i: "std::size_t const", weight: "double const") -> "void":
        r"""setRecordWeight(self, i, weight)"""
        return _pyAgrum.BNLearner_setRecordWeight(self, i, weight)

    def databaseWeight(self) -> "double":
        r"""databaseWeight(self) -> double"""
        return _pyAgrum.BNLearner_databaseWeight(self)

    def recordWeight(self, i: "std::size_t const") -> "double":
        r"""recordWeight(self, i) -> double"""
        return _pyAgrum.BNLearner_recordWeight(self, i)

    def useNoApriori(self) -> "void":
        r"""useNoApriori(self)"""
        return _pyAgrum.BNLearner_useNoApriori(self)

    def useAprioriSmoothing(self, *args) -> "void":
        r"""
        useAprioriSmoothing(self, weight=1)
        useAprioriSmoothing(self)
        """
        return _pyAgrum.BNLearner_useAprioriSmoothing(self, *args)

    def useAprioriDirichlet(self, *args) -> "void":
        r"""
        useAprioriDirichlet(self, filename, weight=1)
        useAprioriDirichlet(self, filename)
        """
        return _pyAgrum.BNLearner_useAprioriDirichlet(self, *args)

    def useAprioriBDeu(self, *args) -> "void":
        r"""
        useAprioriBDeu(self, weight=1)
        useAprioriBDeu(self)

        The BDeu apriori adds weight to all the cells of the counting tables.
        In other words, it adds weight rows in the database with equally probable
        values.

        Parameters
        ----------
        weight : double
        	the apriori weight

        """
        return _pyAgrum.BNLearner_useAprioriBDeu(self, *args)

    def useGreedyHillClimbing(self) -> "void":
        r"""useGreedyHillClimbing(self)"""
        return _pyAgrum.BNLearner_useGreedyHillClimbing(self)

    def useLocalSearchWithTabuList(self, *args) -> "void":
        r"""
        useLocalSearchWithTabuList(self, tabu_size=100, nb_decrease=2)
        useLocalSearchWithTabuList(self, tabu_size=100)
        useLocalSearchWithTabuList(self)

        Indicate that we wish to use a local search with tabu list

        Parameters
        ----------
        tabu_size : int
                The size of the tabu list

        nb_decrease : int
                The max number of changes decreasing the score consecutively that we allow to apply

        """
        return _pyAgrum.BNLearner_useLocalSearchWithTabuList(self, *args)

    def useK2(self, *args) -> "void":
        r"""
        useK2(self, l)
        useK2(self, order)
        useK2(self, order)

        Indicate to use the K2 algorithm (which needs a total ordering of the variables).

        Parameters
        ----------
        order : list[int or str]
              sequences of (ids or name)

        """
        return _pyAgrum.BNLearner_useK2(self, *args)

    def setMaxIndegree(self, max_indegree: "gum::Size") -> "void":
        r"""setMaxIndegree(self, max_indegree)"""
        return _pyAgrum.BNLearner_setMaxIndegree(self, max_indegree)

    def setSliceOrder(self, *args) -> "void":
        r"""
        setSliceOrder(self, l)
        setSliceOrder(self, slice_order)
        setSliceOrder(self, slices)

        Set a partial order on the nodes.

        Parameters
        ----------
        l : list
                a list of sequences (composed of ids of rows or string)

        """
        return _pyAgrum.BNLearner_setSliceOrder(self, *args)

    def setPossibleSkeleton(self, skeleton: "UndiGraph") -> "void":
        r"""setPossibleSkeleton(self, skeleton)"""
        return _pyAgrum.BNLearner_setPossibleSkeleton(self, skeleton)

    def addPossibleEdge(self, *args) -> "void":
        r"""
        addPossibleEdge(self, edge)
        addPossibleEdge(self, tail, head)
        addPossibleEdge(self, tail, head)
        """
        return _pyAgrum.BNLearner_addPossibleEdge(self, *args)

    def erasePossibleEdge(self, *args) -> "void":
        r"""
        erasePossibleEdge(self, edge)
        erasePossibleEdge(self, tail, head)
        erasePossibleEdge(self, tail, head)

        Allow the 2 arcs to be added if necessary.

        Parameters
        ----------
        arc : pyAgrum
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BNLearner_erasePossibleEdge(self, *args)

    def addForbiddenArc(self, *args) -> "void":
        r"""
        addForbiddenArc(self, arc)
        addForbiddenArc(self, tail, head)
        addForbiddenArc(self, tail, head)

        The arc in parameters won't be added.

        Parameters
        ----------
        arc : pyAgrum.Arc
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BNLearner_addForbiddenArc(self, *args)

    def eraseForbiddenArc(self, *args) -> "void":
        r"""
        eraseForbiddenArc(self, arc)
        eraseForbiddenArc(self, tail, head)
        eraseForbiddenArc(self, tail, head)

        Allow the arc to be added if necessary.

        Parameters
        ----------
        arc : pyAgrum
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BNLearner_eraseForbiddenArc(self, *args)

    def addMandatoryArc(self, *args) -> "void":
        r"""
        addMandatoryArc(self, arc)
        addMandatoryArc(self, tail, head)
        addMandatoryArc(self, tail, head)

        Allow to add prior structural knowledge.

        Parameters
        ----------
        arc : pyAgrum.Arc
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        Raises
        ------
        gum.InvalidDirectedCycle
        	If the added arc creates a directed cycle in the DAG

        """
        return _pyAgrum.BNLearner_addMandatoryArc(self, *args)

    def eraseMandatoryArc(self, *args) -> "void":
        r"""
        eraseMandatoryArc(self, arc)
        eraseMandatoryArc(self, tail, head)
        eraseMandatoryArc(self, tail, head)

        Parameters
        ----------
        arc : pyAgrum
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BNLearner_eraseMandatoryArc(self, *args)

    def useEM(self, epsilon: "double const") -> "void":
        r"""
        useEM(self, epsilon)

        Indicates if we use EM for parameter learning.

        Parameters
        ----------
        epsilon : double
        	if epsilon=0.0 then EM is not used
        	if epsilon>0 then EM is used and stops when the sum of the cumulative squared error on parameters is les than epsilon.

        """
        return _pyAgrum.BNLearner_useEM(self, epsilon)

    def hasMissingValues(self) -> "bool":
        r"""
        hasMissingValues(self) -> bool

        Indicates whether there are missing values in the database.

        Returns
        -------
        bool
            True if there are some missing values in the database.

        """
        return _pyAgrum.BNLearner_hasMissingValues(self)

    def logLikelihood(self, *args) -> "double":
        r"""
        logLikelihood(self, vars, knowing={}) -> double
        logLikelihood(self, vars) -> double
        logLikelihood(self, vars, knowing={}) -> double
        logLikelihood(self, vars) -> double

        logLikelihood computes the log-likelihood for the columns in vars, given the columns in the list knowing (optional)


        Parameters
        ----------
        vars: List[str]
        	the name of the columns of interest

        knowing : List[str]
        	the (optional) list of names of conditioning columns

        Returns
        -------
        double
        	the log-likelihood (base 2)

        """
        return _pyAgrum.BNLearner_logLikelihood(self, *args)

    def rawPseudoCount(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        rawPseudoCount(self, vars) -> Vector
        rawPseudoCount(self, vars) -> Vector
        """
        return _pyAgrum.BNLearner_rawPseudoCount(self, *args)

    def nbRows(self) -> "gum::Size":
        r"""
        nbRows(self) -> gum::Size

        Return the number of row in the database


        Returns
        -------
        int
        	the number of rows in the database

        """
        return _pyAgrum.BNLearner_nbRows(self)

    def nbCols(self) -> "gum::Size":
        r"""
        nbCols(self) -> gum::Size

        Return the nimber of columns in the database


        Returns
        -------
        int
        	the number of columns in the database

        """
        return _pyAgrum.BNLearner_nbCols(self)

    def domainSize(self, *args) -> "gum::Size":
        r"""
        domainSize(self, var) -> gum::Size
        domainSize(self, var) -> gum::Size
        """
        return _pyAgrum.BNLearner_domainSize(self, *args)

    def setInitialDAG(self, g: "DAG") -> "void":
        r"""
        setInitialDAG(self, g)

        Parameters
        ----------
        dag : pyAgrum.DAG
        	an initial DAG structure

        """
        return _pyAgrum.BNLearner_setInitialDAG(self, g)

    def use3off2(self) -> "void":
        r"""
        use3off2(self)

        Indicate that we wish to use 3off2.

        """
        return _pyAgrum.BNLearner_use3off2(self)

    def useMIIC(self) -> "void":
        r"""
        useMIIC(self)

        Indicate that we wish to use MIIC.

        """
        return _pyAgrum.BNLearner_useMIIC(self)

    def useNMLCorrection(self) -> "void":
        r"""
        useNMLCorrection(self)

        Indicate that we wish to use the NML correction for 3off2 or MIIC

        """
        return _pyAgrum.BNLearner_useNMLCorrection(self)

    def useMDLCorrection(self) -> "void":
        r"""
        useMDLCorrection(self)

        Indicate that we wish to use the MDL correction for 3off2 or MIIC

        """
        return _pyAgrum.BNLearner_useMDLCorrection(self)

    def useNoCorrection(self) -> "void":
        r"""
        useNoCorrection(self)

        Indicate that we wish to use the NoCorr correction for 3off2 or MIIC

        """
        return _pyAgrum.BNLearner_useNoCorrection(self)

    def latentVariables(self, *args) -> "std::vector< gum::Arc,std::allocator< gum::Arc > > const":
        r"""
        latentVariables(self) -> PyObject
        latentVariables(self) -> std::vector< gum::Arc,std::allocator< gum::Arc > > const

        Warnings
        --------
        learner must be using 3off2 or MIIC algorithm

        Returns
        -------
        list
        	the list of latent variables

        """
        return _pyAgrum.BNLearner_latentVariables(self, *args)

    def learnMixedStructure(self) -> "gum::MixedGraph":
        r"""
        learnMixedStructure(self) -> MixedGraph

        Warnings
        --------
        learner must be using 3off2 or MIIC algorithm

        Returns
        -------
        pyAgrum.EssentialGraph
        	the learned structure as an EssentialGraph

        """
        val = _pyAgrum.BNLearner_learnMixedStructure(self)

        bn=BayesNet()
        for i in range(len(self.names())):
          bn.add(self.nameFromId(i),2)
        ge=EssentialGraph(bn,val)
        ge._bn=bn
        return ge


        return val


# Register BNLearner in _pyAgrum:
_pyAgrum.BNLearner_swigregister(BNLearner)

class BNDatabaseGenerator(object):
    r"""



    BNDatabaseGenerator is used to easily generate databases from a gum.BayesNet.

    BNDatabaseGenerator(bn) -> BNDatabaseGenerator
        Parameters:
            * **bn** (*gum.BayesNet*) -- the Bayesian network used to generate data.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, bn: "BayesNet"):
        r"""
        __init__(self, bn) -> BNDatabaseGenerator

        BNDatabaseGenerator is used to easily generate databases from a gum.BayesNet.

        BNDatabaseGenerator(bn) -> BNDatabaseGenerator
            Parameters:
                * **bn** (*gum.BayesNet*) -- the Bayesian network used to generate data.

        """
        _pyAgrum.BNDatabaseGenerator_swiginit(self, _pyAgrum.new_BNDatabaseGenerator(bn))
    __swig_destroy__ = _pyAgrum.delete_BNDatabaseGenerator

    def drawSamples(self, nbSamples: "gum::Size") -> "double":
        r"""drawSamples(self, nbSamples) -> double"""
        return _pyAgrum.BNDatabaseGenerator_drawSamples(self, nbSamples)

    def toCSV(self, *args) -> "void":
        r"""toCSV(self, csvFileURL, useLabels=True, append=False, csvSeparator=",", checkOnAppend=False)"""
        return _pyAgrum.BNDatabaseGenerator_toCSV(self, *args)

    def toDatabaseTable(self, useLabels: "bool"=True) -> "gum::learning::DatabaseTable< >":
        r"""toDatabaseTable(self, useLabels=True) -> gum::learning::DatabaseTable< >"""
        return _pyAgrum.BNDatabaseGenerator_toDatabaseTable(self, useLabels)

    def database(self) -> "std::vector< std::vector< gum::Idx,std::allocator< gum::Idx > >,std::allocator< std::vector< gum::Idx,std::allocator< gum::Idx > > > >":
        r"""database(self) -> std::vector< std::vector< gum::Idx,std::allocator< gum::Idx > >,std::allocator< std::vector< gum::Idx,std::allocator< gum::Idx > > > >"""
        return _pyAgrum.BNDatabaseGenerator_database(self)

    def setVarOrder(self, *args) -> "void":
        r"""
        setVarOrder(self, varOrder)
        setVarOrder(self, varOrder)
        """
        return _pyAgrum.BNDatabaseGenerator_setVarOrder(self, *args)

    def setVarOrderFromCSV(self, *args) -> "void":
        r"""setVarOrderFromCSV(self, csvFileURL, csvSeparator=",")"""
        return _pyAgrum.BNDatabaseGenerator_setVarOrderFromCSV(self, *args)

    def setTopologicalVarOrder(self) -> "void":
        r"""setTopologicalVarOrder(self)"""
        return _pyAgrum.BNDatabaseGenerator_setTopologicalVarOrder(self)

    def setAntiTopologicalVarOrder(self) -> "void":
        r"""setAntiTopologicalVarOrder(self)"""
        return _pyAgrum.BNDatabaseGenerator_setAntiTopologicalVarOrder(self)

    def setRandomVarOrder(self) -> "void":
        r"""setRandomVarOrder(self)"""
        return _pyAgrum.BNDatabaseGenerator_setRandomVarOrder(self)

    def varOrder(self) -> "std::vector< gum::Idx,std::allocator< gum::Idx > >":
        r"""varOrder(self) -> std::vector< gum::Idx,std::allocator< gum::Idx > >"""
        return _pyAgrum.BNDatabaseGenerator_varOrder(self)

    def varOrderNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""varOrderNames(self) -> Vector_string"""
        return _pyAgrum.BNDatabaseGenerator_varOrderNames(self)

    def log2likelihood(self) -> "double":
        r"""log2likelihood(self) -> double"""
        return _pyAgrum.BNDatabaseGenerator_log2likelihood(self)

# Register BNDatabaseGenerator in _pyAgrum:
_pyAgrum.BNDatabaseGenerator_swigregister(BNDatabaseGenerator)


def statsObj() -> "void":
    r"""statsObj()"""
    return _pyAgrum.statsObj()


