# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.0
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
pyAgrum is a Python wrapper for the C++ aGrUM library. It provides a high-level
interface to the part of agrum allowing to create, handle and make computations
into Bayesian Networks. The module is mainly generated by the SWIG
interface generator.
"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_pyAgrum')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_pyAgrum')
    _pyAgrum = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_pyAgrum', [dirname(__file__)])
        except ImportError:
            import _pyAgrum
            return _pyAgrum
        try:
            _mod = imp.load_module('_pyAgrum', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _pyAgrum = swig_import_helper()
    del swig_import_helper
else:
    import _pyAgrum
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if name == "thisown":
        return self.this.own(value)
    if name == "this":
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if not static:
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if name == "thisown":
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_SwigPyIterator
    def __del__(self):
        return None

    def value(self) -> "PyObject *":
        """value(self) -> PyObject *"""
        return _pyAgrum.SwigPyIterator_value(self)


    def incr(self, n: 'size_t'=1) -> "swig::SwigPyIterator *":
        """
        incr(self, n=1) -> SwigPyIterator
        incr(self) -> SwigPyIterator
        """
        return _pyAgrum.SwigPyIterator_incr(self, n)


    def decr(self, n: 'size_t'=1) -> "swig::SwigPyIterator *":
        """
        decr(self, n=1) -> SwigPyIterator
        decr(self) -> SwigPyIterator
        """
        return _pyAgrum.SwigPyIterator_decr(self, n)


    def distance(self, x: 'SwigPyIterator') -> "ptrdiff_t":
        """distance(self, x) -> ptrdiff_t"""
        return _pyAgrum.SwigPyIterator_distance(self, x)


    def equal(self, x: 'SwigPyIterator') -> "bool":
        """equal(self, x) -> bool"""
        return _pyAgrum.SwigPyIterator_equal(self, x)


    def copy(self) -> "swig::SwigPyIterator *":
        """copy(self) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator_copy(self)


    def next(self) -> "PyObject *":
        """next(self) -> PyObject *"""
        return _pyAgrum.SwigPyIterator_next(self)


    def __next__(self) -> "PyObject *":
        """__next__(self) -> PyObject *"""
        return _pyAgrum.SwigPyIterator___next__(self)


    def previous(self) -> "PyObject *":
        """previous(self) -> PyObject *"""
        return _pyAgrum.SwigPyIterator_previous(self)


    def advance(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator *":
        """advance(self, n) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator_advance(self, n)


    def __eq__(self, x: 'SwigPyIterator') -> "bool":
        """__eq__(self, x) -> bool"""
        return _pyAgrum.SwigPyIterator___eq__(self, x)


    def __ne__(self, x: 'SwigPyIterator') -> "bool":
        """__ne__(self, x) -> bool"""
        return _pyAgrum.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator &":
        """__iadd__(self, n) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator &":
        """__isub__(self, n) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator___isub__(self, n)


    def __add__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator *":
        """__add__(self, n) -> SwigPyIterator"""
        return _pyAgrum.SwigPyIterator___add__(self, n)


    def __sub__(self, *args) -> "ptrdiff_t":
        """
        __sub__(self, n) -> SwigPyIterator
        __sub__(self, x) -> ptrdiff_t
        """
        return _pyAgrum.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _pyAgrum.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


import numpy

class JTGenerator(_object):
    """

    JTGenerator is use to generate junction tree or binary junction tree from bayesian networks.

    Available constructors:
    	``JTGenerator() -> JTGenerator``

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, JTGenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, JTGenerator, name)
    __repr__ = _swig_repr

    def junctionTree(self, *args) -> "gum::JunctionTree":
        """
        junctionTree(self, g) -> CliqueGraph
        junctionTree(self, bn) -> CliqueGraph


        Parameters
        ----------
        g : pyAgrum.UndiGraph
        	an Undirected graph
        bn : pyAgrum.BayesNet
        	a Bayesian network

        Returns
        -------
        pyAgrum.CliqueGraph
        	the current junction tree

        """
        return _pyAgrum.JTGenerator_junctionTree(self, *args)


    def binaryJoinTree(self, *args) -> "gum::JunctionTree":
        """
        binaryJoinTree(self, g) -> CliqueGraph
        binaryJoinTree(self, bn) -> CliqueGraph


        Parameters
        ----------
        g : pyAgrum.UndiGraph
        	an Undirected graph
        bn : pyAgrum.BayesNet
        	a Bayesian network

        Returns
        -------
        pyAgrum.CliqueGraph
        	the binary join tree

        """
        return _pyAgrum.JTGenerator_binaryJoinTree(self, *args)


    def __init__(self):
        """
        __init__(self) -> JTGenerator


        JTGenerator is use to generate junction tree or binary junction tree from bayesian networks.

        Available constructors:
        	``JTGenerator() -> JTGenerator``

        """
        this = _pyAgrum.new_JTGenerator()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_JTGenerator
    def __del__(self):
        return None
JTGenerator_swigregister = _pyAgrum.JTGenerator_swigregister
JTGenerator_swigregister(JTGenerator)

class PythonBNListener(_object):
    """Proxy of C++ PythonBNListener class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PythonBNListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PythonBNListener, name)
    __repr__ = _swig_repr

    def __init__(self, g: 'DiGraph', vnm: 'VariableNodeMap'):
        """__init__(self, g, vnm) -> PythonBNListener"""
        this = _pyAgrum.new_PythonBNListener(g, vnm)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PythonBNListener
    def __del__(self):
        return None

    def whenNodeAdded(self, source: 'void const *', id: 'gum::NodeId') -> "void":
        """whenNodeAdded(self, source, id)"""
        return _pyAgrum.PythonBNListener_whenNodeAdded(self, source, id)


    def whenNodeDeleted(self, arg2: 'void const *', id: 'gum::NodeId') -> "void":
        """whenNodeDeleted(self, arg2, id)"""
        return _pyAgrum.PythonBNListener_whenNodeDeleted(self, arg2, id)


    def whenArcAdded(self, arg2: 'void const *', src: 'gum::NodeId', dst: 'gum::NodeId') -> "void":
        """whenArcAdded(self, arg2, src, dst)"""
        return _pyAgrum.PythonBNListener_whenArcAdded(self, arg2, src, dst)


    def whenArcDeleted(self, arg2: 'void const *', src: 'gum::NodeId', dst: 'gum::NodeId') -> "void":
        """whenArcDeleted(self, arg2, src, dst)"""
        return _pyAgrum.PythonBNListener_whenArcDeleted(self, arg2, src, dst)


    def setWhenArcAdded(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenArcAdded(self, pyfunc)




        """
        return _pyAgrum.PythonBNListener_setWhenArcAdded(self, pyfunc)


    def setWhenArcDeleted(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenArcDeleted(self, pyfunc)




        """
        return _pyAgrum.PythonBNListener_setWhenArcDeleted(self, pyfunc)


    def setWhenNodeAdded(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenNodeAdded(self, pyfunc)




        """
        return _pyAgrum.PythonBNListener_setWhenNodeAdded(self, pyfunc)


    def setWhenNodeDeleted(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenNodeDeleted(self, pyfunc)




        """
        return _pyAgrum.PythonBNListener_setWhenNodeDeleted(self, pyfunc)

PythonBNListener_swigregister = _pyAgrum.PythonBNListener_swigregister
PythonBNListener_swigregister(PythonBNListener)

class PythonLoadListener(_object):
    """Proxy of C++ PythonLoadListener class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PythonLoadListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PythonLoadListener, name)
    __repr__ = _swig_repr

    def whenLoading(self, buffer: 'void const *', percent: 'int') -> "void":
        """whenLoading(self, buffer, percent)"""
        return _pyAgrum.PythonLoadListener_whenLoading(self, buffer, percent)


    def setPythonListener(self, l: 'PyObject *') -> "bool":
        """
        setPythonListener(self, l) -> bool




        """
        return _pyAgrum.PythonLoadListener_setPythonListener(self, l)


    def __init__(self):
        """__init__(self) -> PythonLoadListener"""
        this = _pyAgrum.new_PythonLoadListener()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PythonLoadListener
    def __del__(self):
        return None
PythonLoadListener_swigregister = _pyAgrum.PythonLoadListener_swigregister
PythonLoadListener_swigregister(PythonLoadListener)


def __fillLoadListeners(py_listener: 'std::vector< PythonLoadListener,std::allocator< PythonLoadListener > > &', l: 'PyObject *') -> "int":
    """__fillLoadListeners(py_listener, l) -> int"""
    return _pyAgrum.__fillLoadListeners(py_listener, l)
class PythonApproximationListener(_object):
    """

    Parameters
    ----------
    algo : IApproximationSchemeConfiguration
    	an approxmation scheme

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PythonApproximationListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PythonApproximationListener, name)
    __repr__ = _swig_repr

    def __init__(self, algo: 'IApproximationSchemeConfiguration'):
        """
        __init__(self, algo) -> PythonApproximationListener


        Parameters
        ----------
        algo : IApproximationSchemeConfiguration
        	an approxmation scheme

        """
        this = _pyAgrum.new_PythonApproximationListener(algo)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PythonApproximationListener
    def __del__(self):
        return None

    def whenProgress(self, src: 'void const *', step: 'gum::Size const', error: 'double const', duration: 'double const') -> "void":
        """whenProgress(self, src, step, error, duration)"""
        return _pyAgrum.PythonApproximationListener_whenProgress(self, src, step, error, duration)


    def whenStop(self, src: 'void const *', message: 'std::string const') -> "void":
        """whenStop(self, src, message)"""
        return _pyAgrum.PythonApproximationListener_whenStop(self, src, message)


    def setWhenProgress(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenProgress(self, pyfunc)


        Parameters
        ----------
        pyfunc
        	the function to execute

        """
        return _pyAgrum.PythonApproximationListener_setWhenProgress(self, pyfunc)


    def setWhenStop(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenStop(self, pyfunc)


        Parameters
        ----------
        pyfunc
        	the function to execute

        """
        return _pyAgrum.PythonApproximationListener_setWhenStop(self, pyfunc)

PythonApproximationListener_swigregister = _pyAgrum.PythonApproximationListener_swigregister
PythonApproximationListener_swigregister(PythonApproximationListener)

class PythonDatabaseGeneratorListener(_object):
    """Proxy of C++ PythonDatabaseGeneratorListener class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PythonDatabaseGeneratorListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PythonDatabaseGeneratorListener, name)
    __repr__ = _swig_repr

    def __init__(self, notif: 'BNDatabaseGenerator_double'):
        """__init__(self, notif) -> PythonDatabaseGeneratorListener"""
        this = _pyAgrum.new_PythonDatabaseGeneratorListener(notif)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PythonDatabaseGeneratorListener
    def __del__(self):
        return None

    def whenProgress(self, src: 'void const *', step: 'gum::Size const', duration: 'double const') -> "void":
        """whenProgress(self, src, step, duration)"""
        return _pyAgrum.PythonDatabaseGeneratorListener_whenProgress(self, src, step, duration)


    def whenStop(self, src: 'void const *', message: 'std::string const &') -> "void":
        """whenStop(self, src, message)"""
        return _pyAgrum.PythonDatabaseGeneratorListener_whenStop(self, src, message)


    def setWhenProgress(self, pyfunc: 'PyObject *') -> "void":
        """setWhenProgress(self, pyfunc)"""
        return _pyAgrum.PythonDatabaseGeneratorListener_setWhenProgress(self, pyfunc)


    def setWhenStop(self, pyfunc: 'PyObject *') -> "void":
        """setWhenStop(self, pyfunc)"""
        return _pyAgrum.PythonDatabaseGeneratorListener_setWhenStop(self, pyfunc)

PythonDatabaseGeneratorListener_swigregister = _pyAgrum.PythonDatabaseGeneratorListener_swigregister
PythonDatabaseGeneratorListener_swigregister(PythonDatabaseGeneratorListener)

class BNGenerator(_object):
    """

    BNGenerator is used to easily generate Bayesian networks.

    Available constructors:

        ``BNGenerator() -> BNGenerator``

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BNGenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BNGenerator, name)
    __repr__ = _swig_repr

    def generate(self, n_nodes: 'gum::Size'=10, n_arcs: 'gum::Size'=15, n_modmax: 'gum::Size'=4) -> "gum::BayesNet< double >":
        """
        generate(self, n_nodes=10, n_arcs=15, n_modmax=4) -> BayesNet_double
        generate(self, n_nodes=10, n_arcs=15) -> BayesNet_double
        generate(self, n_nodes=10) -> BayesNet_double
        generate(self) -> BayesNet_double


        Generate a new Bayesian network 

        Parameters
        ----------
        n_nodes : int
        	the number of nodes (default=10)
        n_arcs : int
        	the number of arcs (default=15)
        n_nodmax : int
        	the max number of modalities for a node (default=4)

        Returns
        -------
        pyAgrum.BayesNet
        	the generated Bayesian network

        Raises
        ------
        gum.OperationNotAllowed
        	If n_modmax < 2
        gum.OperationNotAllowed
        	If n_arcs is incompatible with n_nodes (not enough arcs)

        """
        return _pyAgrum.BNGenerator_generate(self, n_nodes, n_arcs, n_modmax)


    def __init__(self):
        """
        __init__(self) -> BNGenerator


        BNGenerator is used to easily generate Bayesian networks.

        Available constructors:

            ``BNGenerator() -> BNGenerator``

        """
        this = _pyAgrum.new_BNGenerator()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_BNGenerator
    def __del__(self):
        return None
BNGenerator_swigregister = _pyAgrum.BNGenerator_swigregister
BNGenerator_swigregister(BNGenerator)

class IDGenerator(_object):
    """

    IDGenerator is used to easily generate influence diagrams.

    Available constructors:

        ``IDGenerator() -> IDGenerator``

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IDGenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IDGenerator, name)
    __repr__ = _swig_repr

    def generate(self, nbrNodes: 'gum::Size'=10, arcDensity: 'double'=0.2, chanceNodeDensity: 'double'=0.8, utilityNodeDensity: 'double'=0.1, max_modality: 'int'=2) -> "gum::InfluenceDiagram< double >":
        """
        generate(self, nbrNodes=10, arcDensity=0.2, chanceNodeDensity=0.8, utilityNodeDensity=0.1, max_modality=2) -> InfluenceDiagram_double
        generate(self, nbrNodes=10, arcDensity=0.2, chanceNodeDensity=0.8, utilityNodeDensity=0.1) -> InfluenceDiagram_double
        generate(self, nbrNodes=10, arcDensity=0.2, chanceNodeDensity=0.8) -> InfluenceDiagram_double
        generate(self, nbrNodes=10, arcDensity=0.2) -> InfluenceDiagram_double
        generate(self, nbrNodes=10) -> InfluenceDiagram_double
        generate(self) -> InfluenceDiagram_double


        Generate a new influence diagram given the parameters.

        Parameters
        ----------
        nbrNodes : int
        	the number of node
        arcDensity : double
        	the density of arc (1 for a complete graph)
        chanceNodeDensity : double
        	the density of chance node
        utilityNodeDensity : double
        	the density of utility node
        max_modality : int
        	the maximum value for modalities

        Returns
        -------
        pyAgrum.InfluenceDiagram
        	the generated influence diagram

        """
        return _pyAgrum.IDGenerator_generate(self, nbrNodes, arcDensity, chanceNodeDensity, utilityNodeDensity, max_modality)


    def __init__(self):
        """
        __init__(self) -> IDGenerator


        IDGenerator is used to easily generate influence diagrams.

        Available constructors:

            ``IDGenerator() -> IDGenerator``

        """
        this = _pyAgrum.new_IDGenerator()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IDGenerator
    def __del__(self):
        return None
IDGenerator_swigregister = _pyAgrum.IDGenerator_swigregister
IDGenerator_swigregister(IDGenerator)

class PRMexplorer(_object):
    """

    PRMexplorer helps navigate through probabilistic relational models.

    Available constructors:
    	``JTGenerator() -> JTGenerator``

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PRMexplorer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PRMexplorer, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
        __init__(self) -> PRMexplorer


        PRMexplorer helps navigate through probabilistic relational models.

        Available constructors:
        	``JTGenerator() -> JTGenerator``

        """
        this = _pyAgrum.new_PRMexplorer()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PRMexplorer
    def __del__(self):
        return None

    def load(self, *args) -> "void":
        """
        load(self, filename, classpath, verbose=False)
        load(self, filename, classpath)
        load(self, filename)


        Load a PRM into the explorer.

        Parameters
        ----------
        filename : str
        	the name of the o3prm file
        classpath : str
        	the classpath of the PRM

        Raises
        ------
        gum.FatalError
        	If file not found

        """
        return _pyAgrum.PRMexplorer_load(self, *args)


    def isType(self, name: 'std::string') -> "PyObject *":
        """
        isType(self, name) -> PyObject *


        Parameters
        ----------
        name : str
        	an element name

        Returns
        -------
        bool
        	True if the parameter correspond to a type in the PRM

        """
        return _pyAgrum.PRMexplorer_isType(self, name)


    def isClass(self, name: 'std::string') -> "PyObject *":
        """
        isClass(self, name) -> PyObject *


        Parameters
        ----------
        name : str
        	an element name

        Returns
        -------
        bool
        	True if the parameter correspond to a class in the PRM

        """
        return _pyAgrum.PRMexplorer_isClass(self, name)


    def isInterface(self, name: 'std::string') -> "PyObject *":
        """
        isInterface(self, name) -> PyObject *


        Parameters
        ----------
        name : str
        	an element name

        Returns
        -------
        bool
        	True if the parameter correspond to an interface in the PRM

        """
        return _pyAgrum.PRMexplorer_isInterface(self, name)


    def classes(self) -> "PyObject *":
        """
        classes(self) -> PyObject *


        Returns
        -------
        list
        	the list of classes

        """
        return _pyAgrum.PRMexplorer_classes(self)


    def classAttributes(self, class_name: 'std::string') -> "PyObject *":
        """
        classAttributes(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of attributes

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classAttributes(self, class_name)


    def isAttribute(self, class_name: 'std::string', att_name: 'std::string') -> "PyObject *":
        """
        isAttribute(self, class_name, att_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name
        att_name : str
        	the name of the attribute to be tested

        Returns
        -------
        bool
        	True if att_name is an attribute of class_name

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM
        gum.IndexError
        	If att_name is not an element of class_name

        """
        return _pyAgrum.PRMexplorer_isAttribute(self, class_name, att_name)


    def classReferences(self, class_name: 'std::string') -> "PyObject *":
        """
        classReferences(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of references

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classReferences(self, class_name)


    def classParameters(self, class_name: 'std::string') -> "PyObject *":
        """
        classParameters(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of parameters

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classParameters(self, class_name)


    def classImplements(self, class_name: 'std::string') -> "PyObject *":
        """
        classImplements(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of interfaces implemented by the class

        """
        return _pyAgrum.PRMexplorer_classImplements(self, class_name)

    __swig_setmethods__["aggType"] = _pyAgrum.PRMexplorer_aggType_set
    __swig_getmethods__["aggType"] = _pyAgrum.PRMexplorer_aggType_get
    if _newclass:
        aggType = _swig_property(_pyAgrum.PRMexplorer_aggType_get, _pyAgrum.PRMexplorer_aggType_set)

    def classAggregates(self, class_name: 'std::string') -> "PyObject *":
        """
        classAggregates(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of aggregates in the class

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classAggregates(self, class_name)


    def classSlotChains(self, class_name: 'std::string') -> "PyObject *":
        """
        classSlotChains(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of class slot chains

        Raises
        ------
        gum.IndexError 
        	if the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classSlotChains(self, class_name)


    def classDag(self, class_name: 'std::string') -> "PyObject *":
        """
        classDag(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        tuple
        	a description of the DAG

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_classDag(self, class_name)


    def getalltheSystems(self) -> "PyObject *":
        """
        getalltheSystems(self) -> PyObject *


        Returns
        -------
        list
        	the list of all the systems and their components

        """
        return _pyAgrum.PRMexplorer_getalltheSystems(self)


    def getSuperClass(self, class_name: 'std::string') -> "PyObject *":
        """
        getSuperClass(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        str
        	the class extended by class_name

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getSuperClass(self, class_name)


    def getDirectSubClass(self, class_name: 'std::string') -> "PyObject *":
        """
        getDirectSubClass(self, class_name) -> PyObject *


        Parameters
        ----------
        class_name : str
        	a class name

        Returns
        -------
        list
        	the list of direct subclasses

        Raises
        ------
        gum.IndexError
        	If the class is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getDirectSubClass(self, class_name)


    def cpf(self, class_name: 'std::string', attribute: 'std::string') -> "gum::Potential< double > const &":
        """
        cpf(self, class_name, attribute) -> Potential_double


        Parameters
        ----------
        class_name : str
        	a class name

        attribute : str
        	an attribute

        Returns
        -------
        pyAgrum.Potential
        	the potential of the attribute

        Raises
        ------
        gum.OperationNotAllowed
        	If the class element doesn't have any gum::Potential (like a gum::PRMReferenceSlot). 
        gum.IndexError
        	If the class is not in the PRM
        gum.IndexError
        	If the attribute in parameters does not exist 

        """
        return _pyAgrum.PRMexplorer_cpf(self, class_name, attribute)


    def types(self) -> "PyObject *":
        """
        types(self) -> PyObject *


        Returns
        -------
        list
        	the list of the custom types in the PRM 

        """
        return _pyAgrum.PRMexplorer_types(self)


    def getSuperType(self, type_name: 'std::string') -> "PyObject *":
        """
        getSuperType(self, type_name) -> PyObject *


        Parameters
        ----------
        type_name : str
        	a type name

        Returns
        -------
        str
        	the type extended by type_name

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getSuperType(self, type_name)


    def getDirectSubTypes(self, type_name: 'std::string') -> "PyObject *":
        """
        getDirectSubTypes(self, type_name) -> PyObject *


        Parameters
        ----------
        type_name : str
        	a type name

        Returns
        -------
        list
        	the list of direct subtypes

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getDirectSubTypes(self, type_name)


    def getLabels(self, type_name: 'std::string') -> "PyObject *":
        """
        getLabels(self, type_name) -> PyObject *


        Parameters
        ----------
        type_name : str
        	a type name

        Returns
        -------
        list
        	the list of type labels

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getLabels(self, type_name)


    def getLabelMap(self, type_name: 'std::string') -> "PyObject *":
        """
        getLabelMap(self, type_name) -> PyObject *


        Parameters
        ----------
        type_name : str
        	a type name

        Returns
        -------
        dict
        	a dict containing pairs of label and their values 

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getLabelMap(self, type_name)


    def interfaces(self) -> "PyObject *":
        """
        interfaces(self) -> PyObject *


        Returns
        -------
        list
        	the list of interfaces in the PRM 

        """
        return _pyAgrum.PRMexplorer_interfaces(self)


    def interAttributes(self, interface_name: 'std::string', allAttributes: 'bool'=False) -> "PyObject *":
        """
        interAttributes(self, interface_name, allAttributes=False) -> PyObject
        interAttributes(self, interface_name) -> PyObject *


        Parameters
        ----------
        interface_name : str
        	an interface

        allAttributes : bool
        	True if supertypes of a custom type should be indicated

        Returns
        -------
        list
        	the list of (<type>,<attribute_name>) for the given interface

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_interAttributes(self, interface_name, allAttributes)


    def interReferences(self, interface_name: 'std::string') -> "PyObject *":
        """
        interReferences(self, interface_name) -> PyObject *


        Parameters
        ----------
        interface_name : str
        	an interface

        Returns
        -------
        list
        	the list of (<reference_type>,<reference_name>,<True if the reference is an array>) for the given interface

        Raises
        ------
        gum.IndexError
        	If the type is not in the PRM

        """
        return _pyAgrum.PRMexplorer_interReferences(self, interface_name)


    def getSuperInterface(self, interface_name: 'std::string') -> "PyObject *":
        """
        getSuperInterface(self, interface_name) -> PyObject *


        Parameters
        ----------
        interface_name : str
        	an interface name

        Returns
        -------
        str
        	the interace extended by interface_name

        Raises
        ------
        gum.IndexError
        	If the interface is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getSuperInterface(self, interface_name)


    def getDirectSubInterfaces(self, interface_name: 'std::string') -> "PyObject *":
        """
        getDirectSubInterfaces(self, interface_name) -> PyObject *


        Parameters
        ----------
        interface_name : str
        	an interface name

        Returns
        -------
        list
        	the list of direct subinterfaces

        Raises
        ------
        gum.IndexError
        	If the interface is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getDirectSubInterfaces(self, interface_name)


    def getImplementations(self, interface_name: 'std::string') -> "PyObject *":
        """
        getImplementations(self, interface_name) -> PyObject *


        Parameters
        ----------
        interface_name : str
        	an interface name

        Returns
        -------
        str
        	the list of classes implementing the interface 

        Raises
        ------
        gum.IndexError
        	If the interface is not in the PRM

        """
        return _pyAgrum.PRMexplorer_getImplementations(self, interface_name)

PRMexplorer_swigregister = _pyAgrum.PRMexplorer_swigregister
PRMexplorer_swigregister(PRMexplorer)

class Vector_double(_object):
    """Proxy of C++ std::vector< double > class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_double, name)
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        """iterator(self) -> SwigPyIterator"""
        return _pyAgrum.Vector_double_iterator(self)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        """__nonzero__(self) -> bool"""
        return _pyAgrum.Vector_double___nonzero__(self)


    def __bool__(self) -> "bool":
        """__bool__(self) -> bool"""
        return _pyAgrum.Vector_double___bool__(self)


    def __len__(self) -> "std::vector< double >::size_type":
        """__len__(self) -> std::vector< double >::size_type"""
        return _pyAgrum.Vector_double___len__(self)


    def __getslice__(self, i: 'std::vector< double >::difference_type', j: 'std::vector< double >::difference_type') -> "std::vector< double,std::allocator< double > > *":
        """__getslice__(self, i, j) -> Vector_double"""
        return _pyAgrum.Vector_double___getslice__(self, i, j)


    def __setslice__(self, *args) -> "void":
        """
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _pyAgrum.Vector_double___setslice__(self, *args)


    def __delslice__(self, i: 'std::vector< double >::difference_type', j: 'std::vector< double >::difference_type') -> "void":
        """__delslice__(self, i, j)"""
        return _pyAgrum.Vector_double___delslice__(self, i, j)


    def __delitem__(self, *args) -> "void":
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _pyAgrum.Vector_double___delitem__(self, *args)


    def __getitem__(self, *args) -> "std::vector< double >::value_type const &":
        """
        __getitem__(self, slice) -> Vector_double
        __getitem__(self, i) -> std::vector< double >::value_type const &
        """
        return _pyAgrum.Vector_double___getitem__(self, *args)


    def __setitem__(self, *args) -> "void":
        """
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _pyAgrum.Vector_double___setitem__(self, *args)


    def pop(self) -> "std::vector< double >::value_type":
        """pop(self) -> std::vector< double >::value_type"""
        return _pyAgrum.Vector_double_pop(self)


    def append(self, x: 'std::vector< double >::value_type const &') -> "void":
        """append(self, x)"""
        return _pyAgrum.Vector_double_append(self, x)


    def empty(self) -> "bool":
        """empty(self) -> bool"""
        return _pyAgrum.Vector_double_empty(self)


    def size(self) -> "std::vector< double >::size_type":
        """size(self) -> std::vector< double >::size_type"""
        return _pyAgrum.Vector_double_size(self)


    def swap(self, v: 'Vector_double') -> "void":
        """swap(self, v)"""
        return _pyAgrum.Vector_double_swap(self, v)


    def begin(self) -> "std::vector< double >::iterator":
        """begin(self) -> std::vector< double >::iterator"""
        return _pyAgrum.Vector_double_begin(self)


    def end(self) -> "std::vector< double >::iterator":
        """end(self) -> std::vector< double >::iterator"""
        return _pyAgrum.Vector_double_end(self)


    def rbegin(self) -> "std::vector< double >::reverse_iterator":
        """rbegin(self) -> std::vector< double >::reverse_iterator"""
        return _pyAgrum.Vector_double_rbegin(self)


    def rend(self) -> "std::vector< double >::reverse_iterator":
        """rend(self) -> std::vector< double >::reverse_iterator"""
        return _pyAgrum.Vector_double_rend(self)


    def clear(self) -> "void":
        """clear(self)"""
        return _pyAgrum.Vector_double_clear(self)


    def get_allocator(self) -> "std::vector< double >::allocator_type":
        """get_allocator(self) -> std::vector< double >::allocator_type"""
        return _pyAgrum.Vector_double_get_allocator(self)


    def pop_back(self) -> "void":
        """pop_back(self)"""
        return _pyAgrum.Vector_double_pop_back(self)


    def erase(self, *args) -> "std::vector< double >::iterator":
        """
        erase(self, pos) -> std::vector< double >::iterator
        erase(self, first, last) -> std::vector< double >::iterator
        """
        return _pyAgrum.Vector_double_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(self) -> Vector_double
        __init__(self, arg2) -> Vector_double
        __init__(self, size) -> Vector_double
        __init__(self, size, value) -> Vector_double
        """
        this = _pyAgrum.new_Vector_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x: 'std::vector< double >::value_type const &') -> "void":
        """push_back(self, x)"""
        return _pyAgrum.Vector_double_push_back(self, x)


    def front(self) -> "std::vector< double >::value_type const &":
        """front(self) -> std::vector< double >::value_type const &"""
        return _pyAgrum.Vector_double_front(self)


    def back(self) -> "std::vector< double >::value_type const &":
        """back(self) -> std::vector< double >::value_type const &"""
        return _pyAgrum.Vector_double_back(self)


    def assign(self, n: 'std::vector< double >::size_type', x: 'std::vector< double >::value_type const &') -> "void":
        """assign(self, n, x)"""
        return _pyAgrum.Vector_double_assign(self, n, x)


    def resize(self, *args) -> "void":
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _pyAgrum.Vector_double_resize(self, *args)


    def insert(self, *args) -> "void":
        """
        insert(self, pos, x) -> std::vector< double >::iterator
        insert(self, pos, n, x)
        """
        return _pyAgrum.Vector_double_insert(self, *args)


    def reserve(self, n: 'std::vector< double >::size_type') -> "void":
        """reserve(self, n)"""
        return _pyAgrum.Vector_double_reserve(self, n)


    def capacity(self) -> "std::vector< double >::size_type":
        """capacity(self) -> std::vector< double >::size_type"""
        return _pyAgrum.Vector_double_capacity(self)

    __swig_destroy__ = _pyAgrum.delete_Vector_double
    def __del__(self):
        return None
Vector_double_swigregister = _pyAgrum.Vector_double_swigregister
Vector_double_swigregister(Vector_double)

class Vector_int(_object):
    """Proxy of C++ std::vector< unsigned int > class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_int, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_int, name)
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        """iterator(self) -> SwigPyIterator"""
        return _pyAgrum.Vector_int_iterator(self)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        """__nonzero__(self) -> bool"""
        return _pyAgrum.Vector_int___nonzero__(self)


    def __bool__(self) -> "bool":
        """__bool__(self) -> bool"""
        return _pyAgrum.Vector_int___bool__(self)


    def __len__(self) -> "std::vector< unsigned int >::size_type":
        """__len__(self) -> std::vector< unsigned int >::size_type"""
        return _pyAgrum.Vector_int___len__(self)


    def __getslice__(self, i: 'std::vector< unsigned int >::difference_type', j: 'std::vector< unsigned int >::difference_type') -> "std::vector< unsigned int,std::allocator< unsigned int > > *":
        """__getslice__(self, i, j) -> Vector_int"""
        return _pyAgrum.Vector_int___getslice__(self, i, j)


    def __setslice__(self, *args) -> "void":
        """
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _pyAgrum.Vector_int___setslice__(self, *args)


    def __delslice__(self, i: 'std::vector< unsigned int >::difference_type', j: 'std::vector< unsigned int >::difference_type') -> "void":
        """__delslice__(self, i, j)"""
        return _pyAgrum.Vector_int___delslice__(self, i, j)


    def __delitem__(self, *args) -> "void":
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _pyAgrum.Vector_int___delitem__(self, *args)


    def __getitem__(self, *args) -> "std::vector< unsigned int >::value_type const &":
        """
        __getitem__(self, slice) -> Vector_int
        __getitem__(self, i) -> std::vector< unsigned int >::value_type const &
        """
        return _pyAgrum.Vector_int___getitem__(self, *args)


    def __setitem__(self, *args) -> "void":
        """
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _pyAgrum.Vector_int___setitem__(self, *args)


    def pop(self) -> "std::vector< unsigned int >::value_type":
        """pop(self) -> std::vector< unsigned int >::value_type"""
        return _pyAgrum.Vector_int_pop(self)


    def append(self, x: 'std::vector< unsigned int >::value_type const &') -> "void":
        """append(self, x)"""
        return _pyAgrum.Vector_int_append(self, x)


    def empty(self) -> "bool":
        """empty(self) -> bool"""
        return _pyAgrum.Vector_int_empty(self)


    def size(self) -> "std::vector< unsigned int >::size_type":
        """size(self) -> std::vector< unsigned int >::size_type"""
        return _pyAgrum.Vector_int_size(self)


    def swap(self, v: 'Vector_int') -> "void":
        """swap(self, v)"""
        return _pyAgrum.Vector_int_swap(self, v)


    def begin(self) -> "std::vector< unsigned int >::iterator":
        """begin(self) -> std::vector< unsigned int >::iterator"""
        return _pyAgrum.Vector_int_begin(self)


    def end(self) -> "std::vector< unsigned int >::iterator":
        """end(self) -> std::vector< unsigned int >::iterator"""
        return _pyAgrum.Vector_int_end(self)


    def rbegin(self) -> "std::vector< unsigned int >::reverse_iterator":
        """rbegin(self) -> std::vector< unsigned int >::reverse_iterator"""
        return _pyAgrum.Vector_int_rbegin(self)


    def rend(self) -> "std::vector< unsigned int >::reverse_iterator":
        """rend(self) -> std::vector< unsigned int >::reverse_iterator"""
        return _pyAgrum.Vector_int_rend(self)


    def clear(self) -> "void":
        """clear(self)"""
        return _pyAgrum.Vector_int_clear(self)


    def get_allocator(self) -> "std::vector< unsigned int >::allocator_type":
        """get_allocator(self) -> std::vector< unsigned int >::allocator_type"""
        return _pyAgrum.Vector_int_get_allocator(self)


    def pop_back(self) -> "void":
        """pop_back(self)"""
        return _pyAgrum.Vector_int_pop_back(self)


    def erase(self, *args) -> "std::vector< unsigned int >::iterator":
        """
        erase(self, pos) -> std::vector< unsigned int >::iterator
        erase(self, first, last) -> std::vector< unsigned int >::iterator
        """
        return _pyAgrum.Vector_int_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(self) -> Vector_int
        __init__(self, arg2) -> Vector_int
        __init__(self, size) -> Vector_int
        __init__(self, size, value) -> Vector_int
        """
        this = _pyAgrum.new_Vector_int(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x: 'std::vector< unsigned int >::value_type const &') -> "void":
        """push_back(self, x)"""
        return _pyAgrum.Vector_int_push_back(self, x)


    def front(self) -> "std::vector< unsigned int >::value_type const &":
        """front(self) -> std::vector< unsigned int >::value_type const &"""
        return _pyAgrum.Vector_int_front(self)


    def back(self) -> "std::vector< unsigned int >::value_type const &":
        """back(self) -> std::vector< unsigned int >::value_type const &"""
        return _pyAgrum.Vector_int_back(self)


    def assign(self, n: 'std::vector< unsigned int >::size_type', x: 'std::vector< unsigned int >::value_type const &') -> "void":
        """assign(self, n, x)"""
        return _pyAgrum.Vector_int_assign(self, n, x)


    def resize(self, *args) -> "void":
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _pyAgrum.Vector_int_resize(self, *args)


    def insert(self, *args) -> "void":
        """
        insert(self, pos, x) -> std::vector< unsigned int >::iterator
        insert(self, pos, n, x)
        """
        return _pyAgrum.Vector_int_insert(self, *args)


    def reserve(self, n: 'std::vector< unsigned int >::size_type') -> "void":
        """reserve(self, n)"""
        return _pyAgrum.Vector_int_reserve(self, n)


    def capacity(self) -> "std::vector< unsigned int >::size_type":
        """capacity(self) -> std::vector< unsigned int >::size_type"""
        return _pyAgrum.Vector_int_capacity(self)

    __swig_destroy__ = _pyAgrum.delete_Vector_int
    def __del__(self):
        return None
Vector_int_swigregister = _pyAgrum.Vector_int_swigregister
Vector_int_swigregister(Vector_int)

class Vector_string(_object):
    """Proxy of C++ std::vector< std::string > class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_string, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_string, name)
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        """iterator(self) -> SwigPyIterator"""
        return _pyAgrum.Vector_string_iterator(self)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        """__nonzero__(self) -> bool"""
        return _pyAgrum.Vector_string___nonzero__(self)


    def __bool__(self) -> "bool":
        """__bool__(self) -> bool"""
        return _pyAgrum.Vector_string___bool__(self)


    def __len__(self) -> "std::vector< std::string >::size_type":
        """__len__(self) -> std::vector< std::string >::size_type"""
        return _pyAgrum.Vector_string___len__(self)


    def __getslice__(self, i: 'std::vector< std::string >::difference_type', j: 'std::vector< std::string >::difference_type') -> "std::vector< std::string,std::allocator< std::string > > *":
        """__getslice__(self, i, j) -> Vector_string"""
        return _pyAgrum.Vector_string___getslice__(self, i, j)


    def __setslice__(self, *args) -> "void":
        """
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _pyAgrum.Vector_string___setslice__(self, *args)


    def __delslice__(self, i: 'std::vector< std::string >::difference_type', j: 'std::vector< std::string >::difference_type') -> "void":
        """__delslice__(self, i, j)"""
        return _pyAgrum.Vector_string___delslice__(self, i, j)


    def __delitem__(self, *args) -> "void":
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _pyAgrum.Vector_string___delitem__(self, *args)


    def __getitem__(self, *args) -> "std::vector< std::string >::value_type const &":
        """
        __getitem__(self, slice) -> Vector_string
        __getitem__(self, i) -> std::vector< std::string >::value_type const &
        """
        return _pyAgrum.Vector_string___getitem__(self, *args)


    def __setitem__(self, *args) -> "void":
        """
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _pyAgrum.Vector_string___setitem__(self, *args)


    def pop(self) -> "std::vector< std::string >::value_type":
        """pop(self) -> std::vector< std::string >::value_type"""
        return _pyAgrum.Vector_string_pop(self)


    def append(self, x: 'std::vector< std::string >::value_type const &') -> "void":
        """append(self, x)"""
        return _pyAgrum.Vector_string_append(self, x)


    def empty(self) -> "bool":
        """empty(self) -> bool"""
        return _pyAgrum.Vector_string_empty(self)


    def size(self) -> "std::vector< std::string >::size_type":
        """size(self) -> std::vector< std::string >::size_type"""
        return _pyAgrum.Vector_string_size(self)


    def swap(self, v: 'Vector_string') -> "void":
        """swap(self, v)"""
        return _pyAgrum.Vector_string_swap(self, v)


    def begin(self) -> "std::vector< std::string >::iterator":
        """begin(self) -> std::vector< std::string >::iterator"""
        return _pyAgrum.Vector_string_begin(self)


    def end(self) -> "std::vector< std::string >::iterator":
        """end(self) -> std::vector< std::string >::iterator"""
        return _pyAgrum.Vector_string_end(self)


    def rbegin(self) -> "std::vector< std::string >::reverse_iterator":
        """rbegin(self) -> std::vector< std::string >::reverse_iterator"""
        return _pyAgrum.Vector_string_rbegin(self)


    def rend(self) -> "std::vector< std::string >::reverse_iterator":
        """rend(self) -> std::vector< std::string >::reverse_iterator"""
        return _pyAgrum.Vector_string_rend(self)


    def clear(self) -> "void":
        """clear(self)"""
        return _pyAgrum.Vector_string_clear(self)


    def get_allocator(self) -> "std::vector< std::string >::allocator_type":
        """get_allocator(self) -> std::vector< std::string >::allocator_type"""
        return _pyAgrum.Vector_string_get_allocator(self)


    def pop_back(self) -> "void":
        """pop_back(self)"""
        return _pyAgrum.Vector_string_pop_back(self)


    def erase(self, *args) -> "std::vector< std::string >::iterator":
        """
        erase(self, pos) -> std::vector< std::string >::iterator
        erase(self, first, last) -> std::vector< std::string >::iterator
        """
        return _pyAgrum.Vector_string_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(self) -> Vector_string
        __init__(self, arg2) -> Vector_string
        __init__(self, size) -> Vector_string
        __init__(self, size, value) -> Vector_string
        """
        this = _pyAgrum.new_Vector_string(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x: 'std::vector< std::string >::value_type const &') -> "void":
        """push_back(self, x)"""
        return _pyAgrum.Vector_string_push_back(self, x)


    def front(self) -> "std::vector< std::string >::value_type const &":
        """front(self) -> std::vector< std::string >::value_type const &"""
        return _pyAgrum.Vector_string_front(self)


    def back(self) -> "std::vector< std::string >::value_type const &":
        """back(self) -> std::vector< std::string >::value_type const &"""
        return _pyAgrum.Vector_string_back(self)


    def assign(self, n: 'std::vector< std::string >::size_type', x: 'std::vector< std::string >::value_type const &') -> "void":
        """assign(self, n, x)"""
        return _pyAgrum.Vector_string_assign(self, n, x)


    def resize(self, *args) -> "void":
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _pyAgrum.Vector_string_resize(self, *args)


    def insert(self, *args) -> "void":
        """
        insert(self, pos, x) -> std::vector< std::string >::iterator
        insert(self, pos, n, x)
        """
        return _pyAgrum.Vector_string_insert(self, *args)


    def reserve(self, n: 'std::vector< std::string >::size_type') -> "void":
        """reserve(self, n)"""
        return _pyAgrum.Vector_string_reserve(self, n)


    def capacity(self) -> "std::vector< std::string >::size_type":
        """capacity(self) -> std::vector< std::string >::size_type"""
        return _pyAgrum.Vector_string_capacity(self)

    __swig_destroy__ = _pyAgrum.delete_Vector_string
    def __del__(self):
        return None
Vector_string_swigregister = _pyAgrum.Vector_string_swigregister
Vector_string_swigregister(Vector_string)

class SetIteratorStaticEnd(_object):
    """Proxy of C++ gum::SetIteratorStaticEnd class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SetIteratorStaticEnd, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SetIteratorStaticEnd, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(self) -> SetIteratorStaticEnd"""
        this = _pyAgrum.new_SetIteratorStaticEnd()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_SetIteratorStaticEnd
    def __del__(self):
        return None
SetIteratorStaticEnd_swigregister = _pyAgrum.SetIteratorStaticEnd_swigregister
SetIteratorStaticEnd_swigregister(SetIteratorStaticEnd)

class GumException(Exception):
    """Proxy of C++ gum::Exception class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GumException, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GumException, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> GumException
        __init__(self, aMsg) -> GumException
        __init__(self) -> GumException
        __init__(self, e) -> GumException
        """
        this = _pyAgrum.new_GumException(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_GumException
    def __del__(self):
        return None

    def what(self) -> "std::string const":
        """what(self) -> std::string const"""
        return _pyAgrum.GumException_what(self)


    def errorContent(self) -> "std::string const":
        """
        errorContent(self) -> std::string const


        Returns
        -------
        str
        	the error content

        """
        return _pyAgrum.GumException_errorContent(self)


    def errorType(self) -> "std::string const":
        """
        errorType(self) -> std::string const


        Returns
        -------
        str
        	the error type

        """
        return _pyAgrum.GumException_errorType(self)


    def errorCallStack(self) -> "std::string const":
        """
        errorCallStack(self) -> std::string const


        Returns
        -------
        str
        	the error call stack

        """
        return _pyAgrum.GumException_errorCallStack(self)

GumException_swigregister = _pyAgrum.GumException_swigregister
GumException_swigregister(GumException)


def __createMsg(filename: 'std::string const &', function: 'std::string const &', line: 'int const', msg: 'std::string const &') -> "std::string const":
    """__createMsg(filename, function, line, msg) -> std::string const"""
    return _pyAgrum.__createMsg(filename, function, line, msg)
class IdError(GumException):
    """Proxy of C++ gum::IdError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IdError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IdError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> IdError
        __init__(self, aMsg) -> IdError
        __init__(self, src) -> IdError
        """
        this = _pyAgrum.new_IdError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IdError
    def __del__(self):
        return None
IdError_swigregister = _pyAgrum.IdError_swigregister
IdError_swigregister(IdError)

class FatalError(GumException):
    """Proxy of C++ gum::FatalError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FatalError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FatalError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> FatalError
        __init__(self, aMsg) -> FatalError
        __init__(self, src) -> FatalError
        """
        this = _pyAgrum.new_FatalError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_FatalError
    def __del__(self):
        return None
FatalError_swigregister = _pyAgrum.FatalError_swigregister
FatalError_swigregister(FatalError)

class NotImplementedYet(GumException):
    """Proxy of C++ gum::NotImplementedYet class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NotImplementedYet, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NotImplementedYet, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> NotImplementedYet
        __init__(self, aMsg) -> NotImplementedYet
        __init__(self, src) -> NotImplementedYet
        """
        this = _pyAgrum.new_NotImplementedYet(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NotImplementedYet
    def __del__(self):
        return None
NotImplementedYet_swigregister = _pyAgrum.NotImplementedYet_swigregister
NotImplementedYet_swigregister(NotImplementedYet)

class UndefinedIteratorValue(GumException):
    """Proxy of C++ gum::UndefinedIteratorValue class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UndefinedIteratorValue, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UndefinedIteratorValue, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> UndefinedIteratorValue
        __init__(self, aMsg) -> UndefinedIteratorValue
        __init__(self, src) -> UndefinedIteratorValue
        """
        this = _pyAgrum.new_UndefinedIteratorValue(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UndefinedIteratorValue
    def __del__(self):
        return None
UndefinedIteratorValue_swigregister = _pyAgrum.UndefinedIteratorValue_swigregister
UndefinedIteratorValue_swigregister(UndefinedIteratorValue)

class UndefinedIteratorKey(GumException):
    """Proxy of C++ gum::UndefinedIteratorKey class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UndefinedIteratorKey, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UndefinedIteratorKey, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> UndefinedIteratorKey
        __init__(self, aMsg) -> UndefinedIteratorKey
        __init__(self, src) -> UndefinedIteratorKey
        """
        this = _pyAgrum.new_UndefinedIteratorKey(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UndefinedIteratorKey
    def __del__(self):
        return None
UndefinedIteratorKey_swigregister = _pyAgrum.UndefinedIteratorKey_swigregister
UndefinedIteratorKey_swigregister(UndefinedIteratorKey)

class NullElement(GumException):
    """Proxy of C++ gum::NullElement class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NullElement, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NullElement, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> NullElement
        __init__(self, aMsg) -> NullElement
        __init__(self, src) -> NullElement
        """
        this = _pyAgrum.new_NullElement(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NullElement
    def __del__(self):
        return None
NullElement_swigregister = _pyAgrum.NullElement_swigregister
NullElement_swigregister(NullElement)

class UndefinedElement(GumException):
    """Proxy of C++ gum::UndefinedElement class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UndefinedElement, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UndefinedElement, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> UndefinedElement
        __init__(self, aMsg) -> UndefinedElement
        __init__(self, src) -> UndefinedElement
        """
        this = _pyAgrum.new_UndefinedElement(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UndefinedElement
    def __del__(self):
        return None
UndefinedElement_swigregister = _pyAgrum.UndefinedElement_swigregister
UndefinedElement_swigregister(UndefinedElement)

class SizeError(GumException):
    """Proxy of C++ gum::SizeError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SizeError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SizeError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> SizeError
        __init__(self, aMsg) -> SizeError
        __init__(self, src) -> SizeError
        """
        this = _pyAgrum.new_SizeError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_SizeError
    def __del__(self):
        return None
SizeError_swigregister = _pyAgrum.SizeError_swigregister
SizeError_swigregister(SizeError)

class EmptySet(GumException):
    """Proxy of C++ gum::EmptySet class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EmptySet, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EmptySet, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> EmptySet
        __init__(self, aMsg) -> EmptySet
        __init__(self, src) -> EmptySet
        """
        this = _pyAgrum.new_EmptySet(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_EmptySet
    def __del__(self):
        return None
EmptySet_swigregister = _pyAgrum.EmptySet_swigregister
EmptySet_swigregister(EmptySet)

class InvalidArgumentsNumber(GumException):
    """Proxy of C++ gum::InvalidArgumentsNumber class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidArgumentsNumber, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidArgumentsNumber, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> InvalidArgumentsNumber
        __init__(self, aMsg) -> InvalidArgumentsNumber
        __init__(self, src) -> InvalidArgumentsNumber
        """
        this = _pyAgrum.new_InvalidArgumentsNumber(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidArgumentsNumber
    def __del__(self):
        return None
InvalidArgumentsNumber_swigregister = _pyAgrum.InvalidArgumentsNumber_swigregister
InvalidArgumentsNumber_swigregister(InvalidArgumentsNumber)

class InvalidArgument(GumException):
    """Proxy of C++ gum::InvalidArgument class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidArgument, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidArgument, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> InvalidArgument
        __init__(self, aMsg) -> InvalidArgument
        __init__(self, src) -> InvalidArgument
        """
        this = _pyAgrum.new_InvalidArgument(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidArgument
    def __del__(self):
        return None
InvalidArgument_swigregister = _pyAgrum.InvalidArgument_swigregister
InvalidArgument_swigregister(InvalidArgument)

class IOError(GumException):
    """Proxy of C++ gum::IOError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IOError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IOError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> IOError
        __init__(self, aMsg) -> IOError
        __init__(self, src) -> IOError
        """
        this = _pyAgrum.new_IOError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IOError
    def __del__(self):
        return None
IOError_swigregister = _pyAgrum.IOError_swigregister
IOError_swigregister(IOError)

class FormatNotFound(IOError):
    """Proxy of C++ gum::FormatNotFound class."""

    __swig_setmethods__ = {}
    for _s in [IOError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FormatNotFound, name, value)
    __swig_getmethods__ = {}
    for _s in [IOError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FormatNotFound, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> FormatNotFound
        __init__(self, aMsg) -> FormatNotFound
        __init__(self, src) -> FormatNotFound
        """
        this = _pyAgrum.new_FormatNotFound(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_FormatNotFound
    def __del__(self):
        return None
FormatNotFound_swigregister = _pyAgrum.FormatNotFound_swigregister
FormatNotFound_swigregister(FormatNotFound)

class OperationNotAllowed(GumException):
    """Proxy of C++ gum::OperationNotAllowed class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OperationNotAllowed, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OperationNotAllowed, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> OperationNotAllowed
        __init__(self, aMsg) -> OperationNotAllowed
        __init__(self, src) -> OperationNotAllowed
        """
        this = _pyAgrum.new_OperationNotAllowed(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_OperationNotAllowed
    def __del__(self):
        return None
OperationNotAllowed_swigregister = _pyAgrum.OperationNotAllowed_swigregister
OperationNotAllowed_swigregister(OperationNotAllowed)

class NotFound(GumException):
    """Proxy of C++ gum::NotFound class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NotFound, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NotFound, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> NotFound
        __init__(self, aMsg) -> NotFound
        __init__(self, src) -> NotFound
        """
        this = _pyAgrum.new_NotFound(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NotFound
    def __del__(self):
        return None
NotFound_swigregister = _pyAgrum.NotFound_swigregister
NotFound_swigregister(NotFound)

class ReferenceError(GumException):
    """Proxy of C++ gum::ReferenceError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ReferenceError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ReferenceError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> ReferenceError
        __init__(self, aMsg) -> ReferenceError
        __init__(self, src) -> ReferenceError
        """
        this = _pyAgrum.new_ReferenceError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_ReferenceError
    def __del__(self):
        return None
ReferenceError_swigregister = _pyAgrum.ReferenceError_swigregister
ReferenceError_swigregister(ReferenceError)

class OutOfBounds(ReferenceError):
    """Proxy of C++ gum::OutOfBounds class."""

    __swig_setmethods__ = {}
    for _s in [ReferenceError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OutOfBounds, name, value)
    __swig_getmethods__ = {}
    for _s in [ReferenceError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OutOfBounds, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> OutOfBounds
        __init__(self, aMsg) -> OutOfBounds
        __init__(self, src) -> OutOfBounds
        """
        this = _pyAgrum.new_OutOfBounds(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_OutOfBounds
    def __del__(self):
        return None
OutOfBounds_swigregister = _pyAgrum.OutOfBounds_swigregister
OutOfBounds_swigregister(OutOfBounds)

class OutOfLowerBound(OutOfBounds):
    """Proxy of C++ gum::OutOfLowerBound class."""

    __swig_setmethods__ = {}
    for _s in [OutOfBounds]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OutOfLowerBound, name, value)
    __swig_getmethods__ = {}
    for _s in [OutOfBounds]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OutOfLowerBound, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> OutOfLowerBound
        __init__(self, aMsg) -> OutOfLowerBound
        __init__(self, src) -> OutOfLowerBound
        """
        this = _pyAgrum.new_OutOfLowerBound(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_OutOfLowerBound
    def __del__(self):
        return None
OutOfLowerBound_swigregister = _pyAgrum.OutOfLowerBound_swigregister
OutOfLowerBound_swigregister(OutOfLowerBound)

class OutOfUpperBound(OutOfBounds):
    """Proxy of C++ gum::OutOfUpperBound class."""

    __swig_setmethods__ = {}
    for _s in [OutOfBounds]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OutOfUpperBound, name, value)
    __swig_getmethods__ = {}
    for _s in [OutOfBounds]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OutOfUpperBound, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> OutOfUpperBound
        __init__(self, aMsg) -> OutOfUpperBound
        __init__(self, src) -> OutOfUpperBound
        """
        this = _pyAgrum.new_OutOfUpperBound(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_OutOfUpperBound
    def __del__(self):
        return None
OutOfUpperBound_swigregister = _pyAgrum.OutOfUpperBound_swigregister
OutOfUpperBound_swigregister(OutOfUpperBound)

class DuplicateElement(ReferenceError):
    """Proxy of C++ gum::DuplicateElement class."""

    __swig_setmethods__ = {}
    for _s in [ReferenceError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DuplicateElement, name, value)
    __swig_getmethods__ = {}
    for _s in [ReferenceError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DuplicateElement, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> DuplicateElement
        __init__(self, aMsg) -> DuplicateElement
        __init__(self, src) -> DuplicateElement
        """
        this = _pyAgrum.new_DuplicateElement(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DuplicateElement
    def __del__(self):
        return None
DuplicateElement_swigregister = _pyAgrum.DuplicateElement_swigregister
DuplicateElement_swigregister(DuplicateElement)

class DuplicateLabel(ReferenceError):
    """Proxy of C++ gum::DuplicateLabel class."""

    __swig_setmethods__ = {}
    for _s in [ReferenceError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DuplicateLabel, name, value)
    __swig_getmethods__ = {}
    for _s in [ReferenceError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DuplicateLabel, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> DuplicateLabel
        __init__(self, aMsg) -> DuplicateLabel
        __init__(self, src) -> DuplicateLabel
        """
        this = _pyAgrum.new_DuplicateLabel(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DuplicateLabel
    def __del__(self):
        return None
DuplicateLabel_swigregister = _pyAgrum.DuplicateLabel_swigregister
DuplicateLabel_swigregister(DuplicateLabel)

class GraphError(GumException):
    """Proxy of C++ gum::GraphError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GraphError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GraphError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> GraphError
        __init__(self, aMsg) -> GraphError
        __init__(self, src) -> GraphError
        """
        this = _pyAgrum.new_GraphError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_GraphError
    def __del__(self):
        return None
GraphError_swigregister = _pyAgrum.GraphError_swigregister
GraphError_swigregister(GraphError)

class NoNeighbour(GraphError):
    """Proxy of C++ gum::NoNeighbour class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoNeighbour, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoNeighbour, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> NoNeighbour
        __init__(self, aMsg) -> NoNeighbour
        __init__(self, src) -> NoNeighbour
        """
        this = _pyAgrum.new_NoNeighbour(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NoNeighbour
    def __del__(self):
        return None
NoNeighbour_swigregister = _pyAgrum.NoNeighbour_swigregister
NoNeighbour_swigregister(NoNeighbour)

class NoParent(GraphError):
    """Proxy of C++ gum::NoParent class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoParent, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoParent, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> NoParent
        __init__(self, aMsg) -> NoParent
        __init__(self, src) -> NoParent
        """
        this = _pyAgrum.new_NoParent(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NoParent
    def __del__(self):
        return None
NoParent_swigregister = _pyAgrum.NoParent_swigregister
NoParent_swigregister(NoParent)

class NoChild(GraphError):
    """Proxy of C++ gum::NoChild class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoChild, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoChild, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> NoChild
        __init__(self, aMsg) -> NoChild
        __init__(self, src) -> NoChild
        """
        this = _pyAgrum.new_NoChild(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NoChild
    def __del__(self):
        return None
NoChild_swigregister = _pyAgrum.NoChild_swigregister
NoChild_swigregister(NoChild)

class InvalidEdge(GraphError):
    """Proxy of C++ gum::InvalidEdge class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidEdge, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidEdge, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> InvalidEdge
        __init__(self, aMsg) -> InvalidEdge
        __init__(self, src) -> InvalidEdge
        """
        this = _pyAgrum.new_InvalidEdge(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidEdge
    def __del__(self):
        return None
InvalidEdge_swigregister = _pyAgrum.InvalidEdge_swigregister
InvalidEdge_swigregister(InvalidEdge)

class InvalidArc(GraphError):
    """Proxy of C++ gum::InvalidArc class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidArc, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidArc, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> InvalidArc
        __init__(self, aMsg) -> InvalidArc
        __init__(self, src) -> InvalidArc
        """
        this = _pyAgrum.new_InvalidArc(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidArc
    def __del__(self):
        return None
InvalidArc_swigregister = _pyAgrum.InvalidArc_swigregister
InvalidArc_swigregister(InvalidArc)

class InvalidNode(GraphError):
    """Proxy of C++ gum::InvalidNode class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidNode, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidNode, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> InvalidNode
        __init__(self, aMsg) -> InvalidNode
        __init__(self, src) -> InvalidNode
        """
        this = _pyAgrum.new_InvalidNode(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidNode
    def __del__(self):
        return None
InvalidNode_swigregister = _pyAgrum.InvalidNode_swigregister
InvalidNode_swigregister(InvalidNode)

class EmptyBSTree(GraphError):
    """Proxy of C++ gum::EmptyBSTree class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EmptyBSTree, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EmptyBSTree, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> EmptyBSTree
        __init__(self, aMsg) -> EmptyBSTree
        __init__(self, src) -> EmptyBSTree
        """
        this = _pyAgrum.new_EmptyBSTree(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_EmptyBSTree
    def __del__(self):
        return None
EmptyBSTree_swigregister = _pyAgrum.EmptyBSTree_swigregister
EmptyBSTree_swigregister(EmptyBSTree)

class DefaultInLabel(GraphError):
    """Proxy of C++ gum::DefaultInLabel class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DefaultInLabel, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DefaultInLabel, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> DefaultInLabel
        __init__(self, aMsg) -> DefaultInLabel
        __init__(self, src) -> DefaultInLabel
        """
        this = _pyAgrum.new_DefaultInLabel(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DefaultInLabel
    def __del__(self):
        return None
DefaultInLabel_swigregister = _pyAgrum.DefaultInLabel_swigregister
DefaultInLabel_swigregister(DefaultInLabel)

class InvalidDirectedCycle(GraphError):
    """Proxy of C++ gum::InvalidDirectedCycle class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidDirectedCycle, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidDirectedCycle, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> InvalidDirectedCycle
        __init__(self, aMsg) -> InvalidDirectedCycle
        __init__(self, src) -> InvalidDirectedCycle
        """
        this = _pyAgrum.new_InvalidDirectedCycle(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidDirectedCycle
    def __del__(self):
        return None
InvalidDirectedCycle_swigregister = _pyAgrum.InvalidDirectedCycle_swigregister
InvalidDirectedCycle_swigregister(InvalidDirectedCycle)

class CPTError(GumException):
    """Proxy of C++ gum::CPTError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CPTError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CPTError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> CPTError
        __init__(self, aMsg) -> CPTError
        __init__(self, src) -> CPTError
        """
        this = _pyAgrum.new_CPTError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CPTError
    def __del__(self):
        return None
CPTError_swigregister = _pyAgrum.CPTError_swigregister
CPTError_swigregister(CPTError)

class CPTNoSumTo1(CPTError):
    """Proxy of C++ gum::CPTNoSumTo1 class."""

    __swig_setmethods__ = {}
    for _s in [CPTError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CPTNoSumTo1, name, value)
    __swig_getmethods__ = {}
    for _s in [CPTError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CPTNoSumTo1, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> CPTNoSumTo1
        __init__(self, aMsg) -> CPTNoSumTo1
        __init__(self, src) -> CPTNoSumTo1
        """
        this = _pyAgrum.new_CPTNoSumTo1(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CPTNoSumTo1
    def __del__(self):
        return None
CPTNoSumTo1_swigregister = _pyAgrum.CPTNoSumTo1_swigregister
CPTNoSumTo1_swigregister(CPTNoSumTo1)

class IncompatibleEvidence(GumException):
    """Proxy of C++ gum::IncompatibleEvidence class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IncompatibleEvidence, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IncompatibleEvidence, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> IncompatibleEvidence
        __init__(self, aMsg) -> IncompatibleEvidence
        __init__(self, src) -> IncompatibleEvidence
        """
        this = _pyAgrum.new_IncompatibleEvidence(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IncompatibleEvidence
    def __del__(self):
        return None
IncompatibleEvidence_swigregister = _pyAgrum.IncompatibleEvidence_swigregister
IncompatibleEvidence_swigregister(IncompatibleEvidence)

class FactoryError(GumException):
    """Proxy of C++ gum::FactoryError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FactoryError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FactoryError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> FactoryError
        __init__(self, aMsg) -> FactoryError
        __init__(self, src) -> FactoryError
        """
        this = _pyAgrum.new_FactoryError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_FactoryError
    def __del__(self):
        return None
FactoryError_swigregister = _pyAgrum.FactoryError_swigregister
FactoryError_swigregister(FactoryError)

class FactoryInvalidState(FactoryError):
    """Proxy of C++ gum::FactoryInvalidState class."""

    __swig_setmethods__ = {}
    for _s in [FactoryError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FactoryInvalidState, name, value)
    __swig_getmethods__ = {}
    for _s in [FactoryError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FactoryInvalidState, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> FactoryInvalidState
        __init__(self, aMsg) -> FactoryInvalidState
        __init__(self, src) -> FactoryInvalidState
        """
        this = _pyAgrum.new_FactoryInvalidState(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_FactoryInvalidState
    def __del__(self):
        return None
FactoryInvalidState_swigregister = _pyAgrum.FactoryInvalidState_swigregister
FactoryInvalidState_swigregister(FactoryInvalidState)

class WrongType(FactoryError):
    """Proxy of C++ gum::WrongType class."""

    __swig_setmethods__ = {}
    for _s in [FactoryError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WrongType, name, value)
    __swig_getmethods__ = {}
    for _s in [FactoryError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WrongType, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> WrongType
        __init__(self, aMsg) -> WrongType
        __init__(self, src) -> WrongType
        """
        this = _pyAgrum.new_WrongType(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_WrongType
    def __del__(self):
        return None
WrongType_swigregister = _pyAgrum.WrongType_swigregister
WrongType_swigregister(WrongType)

class WrongClassElement(FactoryError):
    """Proxy of C++ gum::WrongClassElement class."""

    __swig_setmethods__ = {}
    for _s in [FactoryError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WrongClassElement, name, value)
    __swig_getmethods__ = {}
    for _s in [FactoryError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WrongClassElement, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> WrongClassElement
        __init__(self, aMsg) -> WrongClassElement
        __init__(self, src) -> WrongClassElement
        """
        this = _pyAgrum.new_WrongClassElement(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_WrongClassElement
    def __del__(self):
        return None
WrongClassElement_swigregister = _pyAgrum.WrongClassElement_swigregister
WrongClassElement_swigregister(WrongClassElement)

class TypeError(FactoryError):
    """Proxy of C++ gum::TypeError class."""

    __swig_setmethods__ = {}
    for _s in [FactoryError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TypeError, name, value)
    __swig_getmethods__ = {}
    for _s in [FactoryError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TypeError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> TypeError
        __init__(self, aMsg) -> TypeError
        __init__(self, src) -> TypeError
        """
        this = _pyAgrum.new_TypeError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_TypeError
    def __del__(self):
        return None
TypeError_swigregister = _pyAgrum.TypeError_swigregister
TypeError_swigregister(TypeError)

class LearningError(GumException):
    """Proxy of C++ gum::LearningError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LearningError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LearningError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> LearningError
        __init__(self, aMsg) -> LearningError
        __init__(self, src) -> LearningError
        """
        this = _pyAgrum.new_LearningError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_LearningError
    def __del__(self):
        return None
LearningError_swigregister = _pyAgrum.LearningError_swigregister
LearningError_swigregister(LearningError)

class IncompatibleScoreApriori(LearningError):
    """Proxy of C++ gum::IncompatibleScoreApriori class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IncompatibleScoreApriori, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IncompatibleScoreApriori, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> IncompatibleScoreApriori
        __init__(self, aMsg) -> IncompatibleScoreApriori
        __init__(self, src) -> IncompatibleScoreApriori
        """
        this = _pyAgrum.new_IncompatibleScoreApriori(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IncompatibleScoreApriori
    def __del__(self):
        return None
IncompatibleScoreApriori_swigregister = _pyAgrum.IncompatibleScoreApriori_swigregister
IncompatibleScoreApriori_swigregister(IncompatibleScoreApriori)

class PossiblyIncompatibleScoreApriori(LearningError):
    """Proxy of C++ gum::PossiblyIncompatibleScoreApriori class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PossiblyIncompatibleScoreApriori, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PossiblyIncompatibleScoreApriori, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> PossiblyIncompatibleScoreApriori
        __init__(self, aMsg) -> PossiblyIncompatibleScoreApriori
        __init__(self, src) -> PossiblyIncompatibleScoreApriori
        """
        this = _pyAgrum.new_PossiblyIncompatibleScoreApriori(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PossiblyIncompatibleScoreApriori
    def __del__(self):
        return None
PossiblyIncompatibleScoreApriori_swigregister = _pyAgrum.PossiblyIncompatibleScoreApriori_swigregister
PossiblyIncompatibleScoreApriori_swigregister(PossiblyIncompatibleScoreApriori)

class DatabaseError(LearningError):
    """Proxy of C++ gum::DatabaseError class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseError, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> DatabaseError
        __init__(self, aMsg) -> DatabaseError
        __init__(self, src) -> DatabaseError
        """
        this = _pyAgrum.new_DatabaseError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DatabaseError
    def __del__(self):
        return None
DatabaseError_swigregister = _pyAgrum.DatabaseError_swigregister
DatabaseError_swigregister(DatabaseError)

class MissingVariableInDatabase(LearningError):
    """Proxy of C++ gum::MissingVariableInDatabase class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MissingVariableInDatabase, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MissingVariableInDatabase, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> MissingVariableInDatabase
        __init__(self, aMsg) -> MissingVariableInDatabase
        __init__(self, src) -> MissingVariableInDatabase
        """
        this = _pyAgrum.new_MissingVariableInDatabase(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_MissingVariableInDatabase
    def __del__(self):
        return None
MissingVariableInDatabase_swigregister = _pyAgrum.MissingVariableInDatabase_swigregister
MissingVariableInDatabase_swigregister(MissingVariableInDatabase)

class MissingValueInDatabase(LearningError):
    """Proxy of C++ gum::MissingValueInDatabase class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MissingValueInDatabase, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MissingValueInDatabase, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> MissingValueInDatabase
        __init__(self, aMsg) -> MissingValueInDatabase
        __init__(self, src) -> MissingValueInDatabase
        """
        this = _pyAgrum.new_MissingValueInDatabase(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_MissingValueInDatabase
    def __del__(self):
        return None
MissingValueInDatabase_swigregister = _pyAgrum.MissingValueInDatabase_swigregister
MissingValueInDatabase_swigregister(MissingValueInDatabase)

class UnknownLabelInDatabase(LearningError):
    """Proxy of C++ gum::UnknownLabelInDatabase class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UnknownLabelInDatabase, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UnknownLabelInDatabase, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, aType) -> UnknownLabelInDatabase
        __init__(self, aMsg) -> UnknownLabelInDatabase
        __init__(self, src) -> UnknownLabelInDatabase
        """
        this = _pyAgrum.new_UnknownLabelInDatabase(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UnknownLabelInDatabase
    def __del__(self):
        return None
UnknownLabelInDatabase_swigregister = _pyAgrum.UnknownLabelInDatabase_swigregister
UnknownLabelInDatabase_swigregister(UnknownLabelInDatabase)

class SyntaxError(IOError):
    """Proxy of C++ gum::SyntaxError class."""

    __swig_setmethods__ = {}
    for _s in [IOError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SyntaxError, name, value)
    __swig_getmethods__ = {}
    for _s in [IOError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SyntaxError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aMsg, nol, noc, aType) -> SyntaxError
        __init__(self, aMsg, nol, noc) -> SyntaxError
        """
        this = _pyAgrum.new_SyntaxError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def col(self) -> "gum::Size":
        """
        col(self) -> gum::Size


        Returns
        -------
        int
        	the indice of the colonne of the error

        """
        return _pyAgrum.SyntaxError_col(self)


    def line(self) -> "gum::Size":
        """
        line(self) -> gum::Size


        Returns
        -------
        int
        	the indice of the line of the error

        """
        return _pyAgrum.SyntaxError_line(self)

    __swig_destroy__ = _pyAgrum.delete_SyntaxError
    def __del__(self):
        return None
SyntaxError_swigregister = _pyAgrum.SyntaxError_swigregister
SyntaxError_swigregister(SyntaxError)


def randomValue(max: 'gum::Size const'=2) -> "gum::Idx":
    """
    randomValue(max=2) -> gum::Idx
    randomValue() -> gum::Idx


    Returns
    -------
    int
      a value randomly drawn (0 or 1)

    """
    return _pyAgrum.randomValue(max)

def randomProba() -> "double":
    """
    randomProba() -> double


    Returns
    -------
    double
        a random number between 0 and 1 included (i.e. a proba). 

    """
    return _pyAgrum.randomProba()

def randomGeneratorSeed() -> "unsigned int":
    """
    randomGeneratorSeed() -> unsigned int


    Returns
    -------
    int
      a randomly generated seed

    """
    return _pyAgrum.randomGeneratorSeed()

def initRandom(seed: 'unsigned int'=0) -> "void":
    """
    initRandom(seed=0)
    initRandom()


    Initialize random generator seed.

    Parameters
    ----------
    seed : int
      the seed used to initialize the random generator

    """
    return _pyAgrum.initRandom(seed)

def getRandomGenerator(seed: 'unsigned int'=0) -> "std::default_random_engine":
    """
    getRandomGenerator(seed=0) -> std::default_random_engine
    getRandomGenerator() -> std::default_random_engine


    Returns
    -------
    tbw
      the random generator

    """
    return _pyAgrum.getRandomGenerator(seed)

def isOMP() -> "bool":
    """
    isOMP() -> bool


    Returns
    -------
    bool
      True if OMP has been set at compilation, False otherwise

    """
    return _pyAgrum.isOMP()

def setNumberOfThreads(number: 'unsigned int') -> "void":
    """
    setNumberOfThreads(number)


    To avoid spare cycles (less then 100% CPU occupied), use more threads than logical processors (x2 is a good all-around value). 

    Returns
    -------
    number : int
      the number of threads to be used

    """
    return _pyAgrum.setNumberOfThreads(number)

def getMaxNumberOfThreads() -> "unsigned int":
    """
    getMaxNumberOfThreads() -> unsigned int


    Returns
    -------
    int
      the max number of threads

    """
    return _pyAgrum.getMaxNumberOfThreads()

def getThreadNumber() -> "unsigned int":
    """
    getThreadNumber() -> unsigned int


    Returns
    -------
    int
      the number of thread

    """
    return _pyAgrum.getThreadNumber()

def getNumberOfRunningThreads() -> "unsigned int":
    """
    getNumberOfRunningThreads() -> unsigned int


    Returns
    -------
    int
      the number of running threads

    """
    return _pyAgrum.getNumberOfRunningThreads()

def getNumberOfLogicalProcessors() -> "unsigned int":
    """
    getNumberOfLogicalProcessors() -> unsigned int


    Returns
    -------
    int
      the number of logical processors

    """
    return _pyAgrum.getNumberOfLogicalProcessors()

def setNestedParallelism(value: 'bool') -> "void":
    """
    setNestedParallelism(value)


    Parameters
    ----------
    value : bool
      True if nested parallelism should be activated

    """
    return _pyAgrum.setNestedParallelism(value)

def getNestedParallelism() -> "bool":
    """
    getNestedParallelism() -> bool


    Returns
    -------
    bool
      True if nested parallelism is enabled

    """
    return _pyAgrum.getNestedParallelism()

def setDynamicThreadsNumber(value: 'bool') -> "void":
    """
    setDynamicThreadsNumber(value)


    Parameters
    ----------
    value : bool
      True if the number of threads should be dynamic

    """
    return _pyAgrum.setDynamicThreadsNumber(value)

def getDynamicThreadsNumber() -> "bool":
    """
    getDynamicThreadsNumber() -> bool


    Returns
    -------
    bool
      True if dynamic threads number is enabled

    """
    return _pyAgrum.getDynamicThreadsNumber()
VarType_Discretized = _pyAgrum.VarType_Discretized
VarType_Labelized = _pyAgrum.VarType_Labelized
VarType_Range = _pyAgrum.VarType_Range
VarType_Continuous = _pyAgrum.VarType_Continuous
class Variable(_object):
    """

    Abstract class used by DiscreteVariable.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Variable, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Variable, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_Variable
    def __del__(self):
        return None

    def clone(self) -> "gum::Variable *":
        """
        clone(self) -> Variable


        Copy factory

        Returns
        -------
        pyAgrum.DiscreteVariable
        	a pointer on a new copy of this

        """
        return _pyAgrum.Variable_clone(self)


    def __eq__(self, aRV: 'Variable') -> "bool":
        """__eq__(self, aRV) -> bool"""
        return _pyAgrum.Variable___eq__(self, aRV)


    def __ne__(self, aRV: 'Variable') -> "bool":
        """__ne__(self, aRV) -> bool"""
        return _pyAgrum.Variable___ne__(self, aRV)


    def setName(self, theValue: 'std::string const &') -> "void":
        """
        setName(self, theValue)


        sets the name of the variable.

        Parameters
        ----------
        theValue : str
        	the new description of the variable

        """
        return _pyAgrum.Variable_setName(self, theValue)


    def name(self) -> "std::string const &":
        """
        name(self) -> std::string const &


        Returns
        -------
        str
        	the name of the variable

        """
        return _pyAgrum.Variable_name(self)


    def setDescription(self, theValue: 'std::string const &') -> "void":
        """
        setDescription(self, theValue)


        set the description of the variable.

        Parameters
        ----------
        theValue : str
        	the new description of the variable

        """
        return _pyAgrum.Variable_setDescription(self, theValue)


    def description(self) -> "std::string const &":
        """
        description(self) -> std::string const &


        Returns
        -------
        str
        	the description of the variable

        """
        return _pyAgrum.Variable_description(self)


    def varType(self) -> "gum::VarType":
        """varType(self) -> gum::VarType"""
        return _pyAgrum.Variable_varType(self)

Variable_swigregister = _pyAgrum.Variable_swigregister
Variable_swigregister(Variable)

class DiscreteVariable(Variable):
    """

    DiscreteVariable is the base class for discrete random variable.

    Available constructors:

        ``DiscreteVariable(aName, aDesc='') -> DiscreteVariable``

        ``DiscreteVariable(aDRV) -> DiscreteVariable``

    Parameters
    ----------
    aName: str
      The name of the variable
    aDesc: str
      The (optional) description of the variable
    aDRV: pyAgrum.DiscreteVariable
      Another `DiscreteVariable` that will be copied

    """

    __swig_setmethods__ = {}
    for _s in [Variable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DiscreteVariable, name, value)
    __swig_getmethods__ = {}
    for _s in [Variable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DiscreteVariable, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __swig_destroy__ = _pyAgrum.delete_DiscreteVariable
    def __del__(self):
        return None

    def clone(self) -> "gum::DiscreteVariable *":
        """
        clone(self) -> DiscreteVariable


        Returns
        -------
        pyAgrum.DiscreteVariable
        	a copy of the DiscreteVariable

        """
        return _pyAgrum.DiscreteVariable_clone(self)


    def empty(self) -> "bool":
        """
        empty(self) -> bool


        Returns
        -------
        bool
        	True if the domain size < 2

        """
        return _pyAgrum.DiscreteVariable_empty(self)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.DiscreteVariable_domainSize(self)


    def labels(self) -> "std::vector< std::string,std::allocator< std::string > >":
        """
        labels(self) -> Vector_string


        Returns
        -------
        tuple
        	a tuple containing the labels

        """
        return _pyAgrum.DiscreteVariable_labels(self)


    def numerical(self, indice: 'gum::Idx') -> "double":
        """
        numerical(self, indice) -> double


        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.DiscreteVariable_numerical(self, indice)


    def varType(self) -> "gum::VarType":
        """
        varType(self) -> gum::VarType


        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.DiscreteVariable_varType(self)


    def __eq__(self, aRV: 'DiscreteVariable') -> "bool":
        """__eq__(self, aRV) -> bool"""
        return _pyAgrum.DiscreteVariable___eq__(self, aRV)


    def __ne__(self, aRV: 'DiscreteVariable') -> "bool":
        """__ne__(self, aRV) -> bool"""
        return _pyAgrum.DiscreteVariable___ne__(self, aRV)


    def index(self, label: 'std::string const &') -> "gum::Idx":
        """
        index(self, label) -> gum::Idx


        Parameters
        ----------
        label : str
        	a label

        Returns
        -------
        int
        	the indice of the label

        """
        return _pyAgrum.DiscreteVariable_index(self, label)


    def label(self, i: 'gum::Idx') -> "std::string":
        """
        label(self, i) -> std::string


        Parameters
        ----------
        i : int
        	the index of the label we wish to return

        Returns
        -------
        str
        	the indice-th label

        Raises
        ------
        gum.OutOfBound
        	If the variable does not contain the label

        """
        return _pyAgrum.DiscreteVariable_label(self, i)


    def toStringWithDescription(self) -> "std::string const":
        """
        toStringWithDescription(self) -> std::string const


        Returns
        -------
        str
        	a description of the variable

        """
        return _pyAgrum.DiscreteVariable_toStringWithDescription(self)


    def domain(self) -> "std::string const":
        """
        domain(self) -> std::string const


        Returns
        -------
        str
        	the domain of the variable

        """
        return _pyAgrum.DiscreteVariable_domain(self)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.DiscreteVariable___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.DiscreteVariable___str__(self)


    def __getitem__(self,label):   # adding the y() function here
        return self.index(label)


    def toLabelizedVar(self) -> "gum::LabelizedVariable":
        """
        toLabelizedVar(self) -> LabelizedVariable


        Returns
        -------
        pyAgrum.LabelizedVariable
        	the labelized variable

        Raises
        ------
        gum.RuntimeError
        	If the variable is not a LabelizedVariable

        """
        return _pyAgrum.DiscreteVariable_toLabelizedVar(self)


    def toRangeVar(self) -> "gum::RangeVariable":
        """
        toRangeVar(self) -> RangeVariable


        Returns
        -------
        pyAgrum.RangeVariable
        	the range variable

        Raises
        ------
        gum.RuntimeError
        	If the variable is not a RangeVariable

        """
        return _pyAgrum.DiscreteVariable_toRangeVar(self)


    def toDiscretizedVar(self) -> "gum::DiscretizedVariable< double >":
        """
        toDiscretizedVar(self) -> DiscretizedVariable_double


        Returns
        -------
        pyAgrum.DiscretizedVariable
        	the discretized variable

        Raises
        ------
        gum.RuntimeError 
        	If the variable is not a DiscretizedVariable

        """
        return _pyAgrum.DiscreteVariable_toDiscretizedVar(self)

DiscreteVariable_swigregister = _pyAgrum.DiscreteVariable_swigregister
DiscreteVariable_swigregister(DiscreteVariable)

class LabelizedVariable(DiscreteVariable):
    """

    LabelizedVariable is a discrete random variable with a customizable sequence of labels.

    Available constructors:

        ``LabelizedVariable(aName, aDesc='', nbrLabel=2) -> LabelizedVariable``

        ``LabelizedVariable(aName, aDesc='') -> LabelizedVariable``

        ``LabelizedVariable(aLDRV) -> LabelizedVariable``

    Parameters
    ----------
    aName: str
      The name of the variable
    aDesc: str
      The (optional) description of the variable
    nbrLabel: int
      The number of labels to create (2 by default)
    aLDRV: pyAgrum.LabelizedVariable
      Another `LabelizedVariable` that will be copied

    Examples
    --------
    >>> import pyAgrum as gum
    >>>
    >>> # creating a variable with 3 labels : '0', '1' and '2'
    >>> va=gum.LabelizedVariable('a','a labelized variable',3)
    >>> print(va)
    >>> ## a<0,1,2>
    >>>
    >>> va.addLabel('foo')
    >>> print(va)
    >>> ## a<0,1,2,foo>
    >>>
    >>> va.chgLabel(1,'bar')
    >>> print(va)
    >>> a<0,bar,2,foo>
    >>>
    >>> vb=gum.LabelizedVariable('b','b',0).addLabel('A').addLabel('B').addLabel('C')
    >>> print(vb)
    >>> ## b<A,B,C>
    >>> 
    >>> vb.labels()
    >>> ## ('A', 'B', 'C')
    >>> 
    >>> vb.isLabel('E')
    >>> ## False
    >>> 
    >>> vb.label(2)
    >>> ## 'B'

    """

    __swig_setmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LabelizedVariable, name, value)
    __swig_getmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LabelizedVariable, name)

    def __init__(self, *args):
        """
        __init__(self, aName, aDesc, nbrLabel=2) -> LabelizedVariable
        __init__(self, aName, aDesc) -> LabelizedVariable
        __init__(self, aName) -> LabelizedVariable
        __init__(self, aName, aDesc, labels) -> LabelizedVariable
        __init__(self, aLDRV) -> LabelizedVariable
        """
        this = _pyAgrum.new_LabelizedVariable(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_LabelizedVariable
    def __del__(self):
        return None

    def clone(self) -> "gum::LabelizedVariable *":
        """
        clone(self) -> LabelizedVariable


        Returns
        -------
        pyAgrum.LabelizedVariable
        	a copy of the LabelizedVariable

        """
        return _pyAgrum.LabelizedVariable_clone(self)


    def index(self, label: 'std::string const &') -> "gum::Idx":
        """
        index(self, label) -> gum::Idx


        Parameters
        ----------
        label : str
        	a label

        Returns
        -------
        int
        	the indice of the label

        """
        return _pyAgrum.LabelizedVariable_index(self, label)


    def isLabel(self, aLabel: 'std::string const &') -> "bool":
        """
        isLabel(self, aLabel) -> bool


        Indicates whether the variable already has the label passed in argument

        Parameters
        ----------
        aLabel : str
        	the label to be tested

        Returns
        -------
        bool
        	True if the label already exists

        """
        return _pyAgrum.LabelizedVariable_isLabel(self, aLabel)


    def addLabel(self,*args):
        """
        Add a label with a new index (we assume that we will NEVER remove a label).

        Parameters
        ----------
        aLabel : str
            the label to be added to the labelized variable

        Returns
        -------
        pyAgrum.LabelizedVariable
            the labelized variable

        Raises
        ------
        gum.DuplicateElement
            If the variable already contains the label
        """
        _pyAgrum.LabelizedVariable_addLabel(self,*args)
        return self



    def changeLabel(self, pos: 'gum::Idx', aLabel: 'std::string const &') -> "void":
        """
        changeLabel(self, pos, aLabel)


        Change the label at the specified index

        Parameters
        ----------
        pos : int
        	the index of the label to be changed
        aLabel : str
        	the label to be added to the labelized variable

        Raises
        ------
        gum.DuplicatedElement
          If the variable already contains the new label
        gum.OutOfBounds
          If the index is greater than the size of the variable

        """
        return _pyAgrum.LabelizedVariable_changeLabel(self, pos, aLabel)


    def eraseLabels(self) -> "void":
        """
        eraseLabels(self)


        Erase all the labels from the variable.

        """
        return _pyAgrum.LabelizedVariable_eraseLabels(self)


    def label(self, i: 'gum::Idx') -> "std::string":
        """
        label(self, i) -> std::string


        Parameters
        ----------
        i : int
        	the index of the label we wish to return

        Returns
        -------
        str
        	the indice-th label

        Raises
        ------
        gum.OutOfBound
        	If the variable does not contain the label

        """
        return _pyAgrum.LabelizedVariable_label(self, i)


    def posLabel(self, label: 'std::string const &') -> "gum::Idx":
        """posLabel(self, label) -> gum::Idx"""
        return _pyAgrum.LabelizedVariable_posLabel(self, label)


    def numerical(self, indice: 'gum::Idx') -> "double":
        """
        numerical(self, indice) -> double


        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.LabelizedVariable_numerical(self, indice)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.LabelizedVariable_domainSize(self)


    def varType(self) -> "gum::VarType":
        """
        varType(self) -> gum::VarType


        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.LabelizedVariable_varType(self)


    def domain(self) -> "std::string const":
        """
        domain(self) -> std::string const


        Returns
        -------
        str
            the domain of the variable as a string

        """
        return _pyAgrum.LabelizedVariable_domain(self)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.LabelizedVariable___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.LabelizedVariable___str__(self)

LabelizedVariable_swigregister = _pyAgrum.LabelizedVariable_swigregister
LabelizedVariable_swigregister(LabelizedVariable)

class RangeVariable(DiscreteVariable):
    """

    RangeVariable represents a variable with a range of integers as domain.

    Available constructors:

    	``RangeVariable(aName, aDesc='',minVal, maxVal) -> RangeVariable``

    	``RangeVariable(aName, aDesc='',minVal) -> RangeVariable``

      ``RangeVariable(aName, aDesc='') -> RangeVariable``

      ``RangeVariable(aRV) -> RangeVariable``

    Parameters
    ----------
    aName: str
      The name of the variable
    aDesc: str
      The (optional) description of the variable
    minVal : int
      The minimal integer of the interval
    maxVal : int
      The maximal integer of the interval
    aDV: pyAgrum.RangeVariable
      Another `RangeVariable` that will be copied

    Examples
    --------
    >>> import pyAgrum as gum
    >>>
    >>> vI=gum.gum.RangeVariable('I','I in [4,10]',4,10)
    >>> print(vI)
    >>> ## I[4-10]
    >>> 
    >>> vX.maxVal()
    >>> ## 10
    >>> 
    >>> vX.belongs(1)
    >>> ## False
    >>> 
    >>> # where is the value 5 ?
    >>> vX.index('5')
    >>> ## 1
    >>> 
    >>> vi.labels()
    >>> ## ('4', '5', '6', '7', '8', '9', '10')

    """

    __swig_setmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RangeVariable, name, value)
    __swig_getmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RangeVariable, name)

    def __init__(self, *args):
        """
        __init__(self, aName, aDesc, minVal=0, maxVal=1) -> RangeVariable
        __init__(self, aName, aDesc, minVal=0) -> RangeVariable
        __init__(self, aName, aDesc) -> RangeVariable
        __init__(self, aDRV) -> RangeVariable
        """
        this = _pyAgrum.new_RangeVariable(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_RangeVariable
    def __del__(self):
        return None

    def clone(self) -> "gum::DiscreteVariable *":
        """
        clone(self) -> DiscreteVariable


        Returns
        -------
        pyAgrum.RangeVariable
        	a copy of the RangeVariable

        """
        return _pyAgrum.RangeVariable_clone(self)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.RangeVariable_domainSize(self)


    def varType(self) -> "gum::VarType":
        """
        varType(self) -> gum::VarType


        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.RangeVariable_varType(self)


    def label(self, indice: 'gum::Idx') -> "std::string":
        """
        label(self, indice) -> std::string


        Parameters
        ----------
        indice : int
          the index of the label we wish to return

        Returns
        -------
        str
          the indice-th label

        Raises
        ------
        gum.OutOfBound
          If the variable does not contain the label

        """
        return _pyAgrum.RangeVariable_label(self, indice)


    def numerical(self, indice: 'gum::Idx') -> "double":
        """
        numerical(self, indice) -> double


        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.RangeVariable_numerical(self, indice)


    def minVal(self) -> "long":
        """
        minVal(self) -> long


        Returns
        -------
        long :
          the lower bound of the variable

        """
        return _pyAgrum.RangeVariable_minVal(self)


    def setMinVal(self, minVal: 'long') -> "void":
        """
        setMinVal(self, minVal)


        Set a new value of the lower bound

        Parameters
        ----------
        minVal : long
          The new value of the lower bound

        Warnings
        --------
        An error should be raised if the value is higher than the upper bound.

        """
        return _pyAgrum.RangeVariable_setMinVal(self, minVal)


    def maxVal(self) -> "long":
        """
        maxVal(self) -> long


        Returns
        -------
        long :
          the upper bound of the variable.

        """
        return _pyAgrum.RangeVariable_maxVal(self)


    def setMaxVal(self, maxVal: 'long') -> "void":
        """
        setMaxVal(self, maxVal)


        Set a new value of the upper bound

        Parameters
        ----------
        maxVal : long
          The new value of the upper bound

        Warnings
        --------
        An error should be raised if the value is lower than the lower bound.

        """
        return _pyAgrum.RangeVariable_setMaxVal(self, maxVal)


    def belongs(self, val: 'long') -> "bool":
        """
        belongs(self, val) -> bool


        Parameters
        ----------
        val : long
          the value to be tested

        Returns
        -------
        bool:
          True if the value in parameters belongs to the variable's interval.

        """
        return _pyAgrum.RangeVariable_belongs(self, val)


    def index(self, arg2: 'std::string const &') -> "gum::Idx":
        """
        index(self, arg2) -> gum::Idx


        Parameters
        ----------
        arg2 : str
          a label

        Returns
        -------
        int
          the indice of the label

        """
        return _pyAgrum.RangeVariable_index(self, arg2)


    def domain(self) -> "std::string const":
        """
        domain(self) -> std::string const


        Returns
        -------
        str
        	the domain of the variable

        """
        return _pyAgrum.RangeVariable_domain(self)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.RangeVariable___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.RangeVariable___str__(self)

RangeVariable_swigregister = _pyAgrum.RangeVariable_swigregister
RangeVariable_swigregister(RangeVariable)

class IDiscretizedVariable(DiscreteVariable):
    """Proxy of C++ gum::IDiscretizedVariable class."""

    __swig_setmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IDiscretizedVariable, name, value)
    __swig_getmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IDiscretizedVariable, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_IDiscretizedVariable
    def __del__(self):
        return None

    def clone(self) -> "gum::IDiscretizedVariable *":
        """
        clone(self) -> IDiscretizedVariable


        Returns
        -------
        pyAgrum.DiscreteVariable
        	a copy of the DiscreteVariable

        """
        return _pyAgrum.IDiscretizedVariable_clone(self)

IDiscretizedVariable_swigregister = _pyAgrum.IDiscretizedVariable_swigregister
IDiscretizedVariable_swigregister(IDiscretizedVariable)

class Edge(_object):
    """

    pyAgrum.Edge is the representation of an arc between two nodes represented by `int`s : the first and the second.

    Available constructors :
        ``Edge(aN1,aN2) -> Edge``

        ``Edge(src) -> Edge``

    Parameters
    ----------
    aN1 : int
      the nodeId of the first node
    aN2 : int
      the nodeId of the secondnode
    src: pyAgrum.Edge
      the Edge to copy

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Edge, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Edge, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, aN1, aN2) -> Edge
        __init__(self, src) -> Edge
        """
        this = _pyAgrum.new_Edge(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_Edge
    def __del__(self):
        return None

    def other(self, id: 'gum::NodeId') -> "gum::NodeId":
        """
        other(self, id) -> gum::NodeId


        Parameters
        ----------
        id : int
          the nodeId of one of the nodes of the Edge


        Returns
        ------
        int
          the nodeId of the other node

        """
        return _pyAgrum.Edge_other(self, id)


    def first(self) -> "gum::NodeId":
        """
        first(self) -> gum::NodeId


        Returns
        ------
        int
          the nodeId of the first node of the arc (the tail)

        """
        return _pyAgrum.Edge_first(self)


    def second(self) -> "gum::NodeId":
        """
        second(self) -> gum::NodeId


        Returns
        ------
        int
          the nodeId of the second node of the arc (the head)

        """
        return _pyAgrum.Edge_second(self)


    def __eq__(self, src: 'Edge') -> "bool":
        """__eq__(self, src) -> bool"""
        return _pyAgrum.Edge___eq__(self, src)


    def __ne__(self, src: 'Edge') -> "bool":
        """__ne__(self, src) -> bool"""
        return _pyAgrum.Edge___ne__(self, src)

Edge_swigregister = _pyAgrum.Edge_swigregister
Edge_swigregister(Edge)

class Arc(_object):
    """

    pyAgrum.Arc is the representation of an arc between two nodes represented by `int`s : the head and the tail.

    Available constructors:
        ``Arc(tail, head) -> Arc``

        ``Arc(src) -> Arc``

    Parameters
    ----------
    tail : int
      the tail
    head : int
      the head
    src : :class: Arc
      the Arc to copy


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Arc, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Arc, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, tail, head) -> Arc
        __init__(self, src) -> Arc
        """
        this = _pyAgrum.new_Arc(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_Arc
    def __del__(self):
        return None

    def tail(self) -> "gum::NodeId":
        """
        tail(self) -> gum::NodeId


        Returns
        -------
        int
          the id of the tail node

        """
        return _pyAgrum.Arc_tail(self)


    def head(self) -> "gum::NodeId":
        """
        head(self) -> gum::NodeId


        Returns
        ------
        int
          the id of the head node

        """
        return _pyAgrum.Arc_head(self)


    def other(self, id: 'gum::NodeId') -> "gum::NodeId":
        """
        other(self, id) -> gum::NodeId


        Parameters
        ----------
        id : int
          the nodeId of the head or the tail


        Returns
        -------
        int
          the nodeId of the other node

        """
        return _pyAgrum.Arc_other(self, id)


    def first(self) -> "gum::NodeId":
        """
        first(self) -> gum::NodeId


        Returns
        -------
        int
          the nodeId of the first node of the arc (the tail)

        """
        return _pyAgrum.Arc_first(self)


    def second(self) -> "gum::NodeId":
        """
        second(self) -> gum::NodeId


        Returns
        -------
        int
          the nodeId of the second node of the arc (the head)

        """
        return _pyAgrum.Arc_second(self)


    def __eq__(self, src: 'Arc') -> "bool":
        """__eq__(self, src) -> bool"""
        return _pyAgrum.Arc___eq__(self, src)


    def __ne__(self, src: 'Arc') -> "bool":
        """__ne__(self, src) -> bool"""
        return _pyAgrum.Arc___ne__(self, src)

Arc_swigregister = _pyAgrum.Arc_swigregister
Arc_swigregister(Arc)

class DiGraph(_object):
    """

    DiGraph represents a Directed Graph.

    Available constructors:
        ``DiGraph() -> DiGraph``

        ``DiGraph(src) -> DiGraph``

    Parameters
    ----------
    src : pyAgrum.DiGraph
      the digraph to copy


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DiGraph, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DiGraph, name)

    def __init__(self, *args):
        """
        __init__(self, nodes_size, nodes_resize_policy=True, arcs_size, arcs_resize_policy=True) -> DiGraph
        __init__(self, nodes_size, nodes_resize_policy=True, arcs_size) -> DiGraph
        __init__(self, nodes_size, nodes_resize_policy=True) -> DiGraph
        __init__(self, nodes_size) -> DiGraph
        __init__(self) -> DiGraph
        __init__(self, g) -> DiGraph
        """
        this = _pyAgrum.new_DiGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DiGraph
    def __del__(self):
        return None

    def __eq__(self, g: 'DiGraph') -> "bool":
        """__eq__(self, g) -> bool"""
        return _pyAgrum.DiGraph___eq__(self, g)


    def __ne__(self, g: 'DiGraph') -> "bool":
        """__ne__(self, g) -> bool"""
        return _pyAgrum.DiGraph___ne__(self, g)


    def eraseNode(self, id: 'gum::NodeId const') -> "void":
        """
        eraseNode(self, id)


        Erase the node and all the related arcs.

        Parameters
        ----------
        id : int
        	the id of the node

        """
        return _pyAgrum.DiGraph_eraseNode(self, id)


    def clear(self) -> "void":
        """
        clear(self)


        Remove all the nodes and arcs from the graph.

        """
        return _pyAgrum.DiGraph_clear(self)


    def toDot(self) -> "std::string const":
        """
        toDot(self) -> std::string const


        Returns
        -------
        str
            a friendly display of the graph in DOT format 

        """
        return _pyAgrum.DiGraph_toDot(self)


    def topologicalOrder(self, clear: 'bool'=True) -> "gum::Sequence< gum::NodeId > const &":
        """
        topologicalOrder(self, clear=True) -> gum::Sequence< gum::NodeId > const
        topologicalOrder(self) -> gum::Sequence< gum::NodeId > const &


        Returns
        -------
        List
            the list of the nodes Ids in a topological order

        Raises
        ------
        gum.InvalidDirectedCycle
          If this graph contains cycles

        """
        return _pyAgrum.DiGraph_topologicalOrder(self, clear)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.DiGraph___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.DiGraph___str__(self)


    def nodes(self) -> "PyObject *":
        """
        nodes(self) -> PyObject *


        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.DiGraph_nodes(self)


    def addNodes(self, n: 'gum::Size') -> "PyObject *":
        """
        addNodes(self, n) -> PyObject *


        Add n nodes.

        Parameters
        ----------
        n : int
          the number of nodes to add.

        Returns
        -------
        Set of int
          the new ids

        """
        return _pyAgrum.DiGraph_addNodes(self, n)


    def arcs(self) -> "PyObject *":
        """
        arcs(self) -> PyObject *


        Returns
        -------
        List
        	the list of the arcs

        """
        return _pyAgrum.DiGraph_arcs(self)


    def parents(self, id: 'gum::NodeId') -> "PyObject *":
        """
        parents(self, id) -> PyObject *


        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.DiGraph_parents(self, id)


    def children(self, id: 'gum::NodeId') -> "PyObject *":
        """
        children(self, id) -> PyObject *


        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.DiGraph_children(self, id)


    def addNode(self) -> "gum::NodeId":
        """
        addNode(self) -> gum::NodeId


        Returns
        -------
        int
          the new NodeId

        """
        return _pyAgrum.DiGraph_addNode(self)


    def addNodeWithId(self, id: 'gum::NodeId const') -> "void":
        """
        addNodeWithId(self, id)


        Add a node by choosing a new NodeId.

        Parameters
        ----------
        id : int
          The id of the new node

        Raises
        ------
        gum.DuplicateElement
          If the given id is already used

        """
        return _pyAgrum.DiGraph_addNodeWithId(self, id)


    def existsNode(self, id: 'gum::NodeId const') -> "bool":
        """
        existsNode(self, id) -> bool


        Check if a node with a certain id exists in the graph.

        Parameters
        ----------
        id : int
            the checked id

        Returns
        -------
        bool
            True if the node exists

        """
        return _pyAgrum.DiGraph_existsNode(self, id)


    def size(self) -> "gum::Size":
        """
        size(self) -> gum::Size


        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.DiGraph_size(self)


    def empty(self) -> "bool":
        """
        empty(self) -> bool


        Check if the graph is empty.

        Returns
        -------
        bool
            True if the graph is empty

        """
        return _pyAgrum.DiGraph_empty(self)


    def addArc(self, *args) -> "void":
        """
        addArc(self, tail, head)
        addArc(self, n1, n2)


        Add an arc from tail to head.

        Parameters
        ----------
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        Raises
        ------
        gum.InvalidNode
          If head or tail does not belong to the graph nodes.

        """
        return _pyAgrum.DiGraph_addArc(self, *args)


    def eraseArc(self, n1: 'gum::NodeId const', n2: 'gum::NodeId const') -> "void":
        """
        eraseArc(self, n1, n2)


        Erase the arc between n1 and n2.

        Parameters
        ----------
        n1 : int
        	the id of the tail node
        n2 : int
        	the id of the head node

        """
        return _pyAgrum.DiGraph_eraseArc(self, n1, n2)


    def existsArc(self, n1: 'gum::NodeId const', n2: 'gum::NodeId const') -> "bool":
        """
        existsArc(self, n1, n2) -> bool


        Check if an arc exists bewteen n1 and n2.

        Parameters
        ----------
        n1 : int
        	the id of the tail node
        n2 : int
        	the id of the head node

        Returns
        -------
        bool
            True if the arc exists

        """
        return _pyAgrum.DiGraph_existsArc(self, n1, n2)


    def eraseParents(self, n: 'gum::NodeId const') -> "void":
        """
        eraseParents(self, n)


        Erase the arcs coming to the node.

        Parameters
        ----------
        n : int
        	the id of the child node

        """
        return _pyAgrum.DiGraph_eraseParents(self, n)


    def eraseChildren(self, n: 'gum::NodeId const') -> "void":
        """
        eraseChildren(self, n)


        Erase the arcs heading through the node's children.

        Parameters
        ----------
        n : int
        	the id of the parent node

        """
        return _pyAgrum.DiGraph_eraseChildren(self, n)


    def sizeArcs(self) -> "gum::Size":
        """
        sizeArcs(self) -> gum::Size


        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.DiGraph_sizeArcs(self)


    def emptyArcs(self) -> "bool":
        """
        emptyArcs(self) -> bool


        Check if the graph doesn't contains arcs.

        Returns
        -------
        bool
            True if the graph doesn't contains arcs

        """
        return _pyAgrum.DiGraph_emptyArcs(self)

DiGraph_swigregister = _pyAgrum.DiGraph_swigregister
DiGraph_swigregister(DiGraph)

class DAG(DiGraph):
    """

    DAG represents a Directed Acyclic Graph.

    Available constructors:
        ``DAG() -> DAG``

        ``DAG(src) -> DAG``

    Parameters
    ----------
    src : :class: DAG
      the DAG to copy

    """

    __swig_setmethods__ = {}
    for _s in [DiGraph]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DAG, name, value)
    __swig_getmethods__ = {}
    for _s in [DiGraph]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DAG, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, nodes_size, nodes_resize_policy=True, arcs_size, arcs_resize_policy=True) -> DAG
        __init__(self, nodes_size, nodes_resize_policy=True, arcs_size) -> DAG
        __init__(self, nodes_size, nodes_resize_policy=True) -> DAG
        __init__(self, nodes_size) -> DAG
        __init__(self) -> DAG
        __init__(self, g) -> DAG
        """
        this = _pyAgrum.new_DAG(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DAG
    def __del__(self):
        return None

    def addNodes(self, n: 'gum::Size') -> "PyObject *":
        """addNodes(self, n) -> PyObject *"""
        return _pyAgrum.DAG_addNodes(self, n)


    def addArc(self, *args) -> "void":
        """
        addArc(self, tail, head)
        addArc(self, n1, n2)


        Add an arc from tail to head.

        Parameters
        ----------
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        Raises
        ------
        gum.InvalidDirectedCircle
        	If any (directed) cycle is created by this arc
        gum.InvalidNode
        	If head or tail does not belong to the graph nodes

        """
        return _pyAgrum.DAG_addArc(self, *args)

DAG_swigregister = _pyAgrum.DAG_swigregister
DAG_swigregister(DAG)

class UndiGraph(_object):
    """

    UndiGraph represents an Undirected Graph.

    Available constructors:
        ``UndiGraph() -> UndiGraph``

        ``UndiGraph(src) -> UndiGraph``

    Parameters
    ----------
    src : :class: UndiGraph
      the UndiGraph to copy


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, UndiGraph, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, UndiGraph, name)

    def __init__(self, *args):
        """
        __init__(self, nodes_size, nodes_resize_policy=True, edges_size, edges_resize_policy=True) -> UndiGraph
        __init__(self, nodes_size, nodes_resize_policy=True, edges_size) -> UndiGraph
        __init__(self, nodes_size, nodes_resize_policy=True) -> UndiGraph
        __init__(self, nodes_size) -> UndiGraph
        __init__(self) -> UndiGraph
        __init__(self, g) -> UndiGraph
        """
        this = _pyAgrum.new_UndiGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UndiGraph
    def __del__(self):
        return None

    def __eq__(self, g: 'UndiGraph') -> "bool":
        """__eq__(self, g) -> bool"""
        return _pyAgrum.UndiGraph___eq__(self, g)


    def __ne__(self, g: 'UndiGraph') -> "bool":
        """__ne__(self, g) -> bool"""
        return _pyAgrum.UndiGraph___ne__(self, g)


    def eraseNode(self, id: 'gum::NodeId const') -> "void":
        """
        eraseNode(self, id)


        Erase the node and all the adjacent edges.

        Parameters
        ----------
        id : int
          the id of the node

        """
        return _pyAgrum.UndiGraph_eraseNode(self, id)


    def clear(self) -> "void":
        """
        clear(self)


        Remove all the nodes and edges from the graph.

        """
        return _pyAgrum.UndiGraph_clear(self)


    def toDot(self) -> "std::string const":
        """
        toDot(self) -> std::string const


        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.UndiGraph_toDot(self)


    def hasUndirectedCycle(self) -> "bool":
        """
        hasUndirectedCycle(self) -> bool


        Checks whether the graph contains cycles.

        Returns
        -------
        bool
            True if the graph contains a cycle

        """
        return _pyAgrum.UndiGraph_hasUndirectedCycle(self)


    def partialUndiGraph(self, nodesSet: 'gum::NodeSet') -> "gum::UndiGraph":
        """
        partialUndiGraph(self, nodesSet) -> UndiGraph


        Parameters
        ----------
        nodesSet : Set
            The set of nodes composing the partial graph

        Returns
        -------
        pyAgrum.UndiGraph
            The partial graph formed by the nodes given in parameter

        """
        return _pyAgrum.UndiGraph_partialUndiGraph(self, nodesSet)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.UndiGraph___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.UndiGraph___str__(self)


    def nodes(self) -> "PyObject *":
        """
        nodes(self) -> PyObject *


        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.UndiGraph_nodes(self)


    def addNodes(self, n: 'gum::Size') -> "PyObject *":
        """
        addNodes(self, n) -> PyObject *


        Add n nodes.

        Parameters
        ----------
        n : int
          the number of nodes to add.

        Returns
        -------
        Set of int
          the new ids

        """
        return _pyAgrum.UndiGraph_addNodes(self, n)


    def edges(self) -> "PyObject *":
        """
        edges(self) -> PyObject *


        Returns
        -------
        List
          the list of the edges

        """
        return _pyAgrum.UndiGraph_edges(self)


    def neighbours(self, id: 'gum::NodeId') -> "PyObject *":
        """
        neighbours(self, id) -> PyObject *


        Parameters
        ----------
        id : int
            the id of the checked node

        Returns
        -------
        Set
            The set of edges adjacent to the given node

        """
        return _pyAgrum.UndiGraph_neighbours(self, id)


    def addNode(self) -> "gum::NodeId":
        """
        addNode(self) -> gum::NodeId


        Returns
        -------
        int
          the new NodeId

        """
        return _pyAgrum.UndiGraph_addNode(self)


    def addNodeWithId(self, id: 'gum::NodeId const') -> "void":
        """
        addNodeWithId(self, id)


        Add a node by choosing a new NodeId.

        Parameters
        ----------
        id : int
          The id of the new node

        Raises
        ------
        gum.DuplicateElement
          If the given id is already used

        """
        return _pyAgrum.UndiGraph_addNodeWithId(self, id)


    def existsNode(self, id: 'gum::NodeId const') -> "bool":
        """
        existsNode(self, id) -> bool


        Check if a node with a certain id exists in the graph.

        Parameters
        ----------
        id : int
            the checked id

        Returns
        -------
        bool
            True if the node exists

        """
        return _pyAgrum.UndiGraph_existsNode(self, id)


    def size(self) -> "gum::Size":
        """
        size(self) -> gum::Size


        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.UndiGraph_size(self)


    def empty(self) -> "bool":
        """
        empty(self) -> bool


        Check if the graph is empty.

        Returns
        -------
        bool
            True if the graph is empty

        """
        return _pyAgrum.UndiGraph_empty(self)


    def addEdge(self, n1: 'gum::NodeId const', n2: 'gum::NodeId const') -> "void":
        """
        addEdge(self, n1, n2)


        Insert a new edge into the graph.

        Parameters
        ----------
        n1 : int
          the id of one node of the new inserted edge
        n2 : int
          the id of the other node of the new inserted edge

        Raises
        ------
        gum.InvalidNode
          If n1 or n2 does not belong to the graph nodes.

        """
        return _pyAgrum.UndiGraph_addEdge(self, n1, n2)


    def eraseEdge(self, n1: 'gum::NodeId const', n2: 'gum::NodeId const') -> "void":
        """
        eraseEdge(self, n1, n2)


        Erase the edge between n1 and n2.

        Parameters
        ----------
        n1 : int
          the id of the tail node
        n2 : int
          the id of the head node

        """
        return _pyAgrum.UndiGraph_eraseEdge(self, n1, n2)


    def existsEdge(self, n1: 'gum::NodeId const', n2: 'gum::NodeId const') -> "bool":
        """
        existsEdge(self, n1, n2) -> bool


        Check if an edge exists bewteen n1 and n2.

        Parameters
        ----------
        n1 : int
          the id of one extremity of the edge
        n2 : int
          the id of the other extremity if tge edge

        Returns
        -------
        bool
            True if the arc exists

        """
        return _pyAgrum.UndiGraph_existsEdge(self, n1, n2)


    def sizeEdges(self) -> "gum::Size":
        """
        sizeEdges(self) -> gum::Size


        Returns
        -------
        int
            the number of edges in the graph

        """
        return _pyAgrum.UndiGraph_sizeEdges(self)


    def emptyEdges(self) -> "bool":
        """
        emptyEdges(self) -> bool


        Check if the graph doesn't contains edges.

        Returns
        -------
        bool
            True if the graph doesn't contains edges

        """
        return _pyAgrum.UndiGraph_emptyEdges(self)


    def eraseNeighbours(self, n: 'gum::NodeId const') -> "void":
        """
        eraseNeighbours(self, n)


        Erase all the edges adjacent to a given node.

        Parameters
        ----------
        n : int
          the id of the node

        """
        return _pyAgrum.UndiGraph_eraseNeighbours(self, n)

UndiGraph_swigregister = _pyAgrum.UndiGraph_swigregister
UndiGraph_swigregister(UndiGraph)

class MixedGraph(UndiGraph, DiGraph):
    """

    MixedGraph represents a Clique Graph.

    Available constructors:
        ``MixedGraph() -> MixedGraph``

        ``MixedGraph(src) -> MixedGraph``

    Parameters
    ----------
    src : pyAgrum.MixedGraph
      the MixedGraph to copy

    """

    __swig_setmethods__ = {}
    for _s in [UndiGraph, DiGraph]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MixedGraph, name, value)
    __swig_getmethods__ = {}
    for _s in [UndiGraph, DiGraph]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MixedGraph, name)

    def __init__(self, *args):
        """
        __init__(self, nodes_size, nodes_resize_policy=True, arcs_size, arcs_resize_policy=True, edges_size, edges_resize_policy=True) -> MixedGraph
        __init__(self, nodes_size, nodes_resize_policy=True, arcs_size, arcs_resize_policy=True, edges_size) -> MixedGraph
        __init__(self, nodes_size, nodes_resize_policy=True, arcs_size, arcs_resize_policy=True) -> MixedGraph
        __init__(self, nodes_size, nodes_resize_policy=True, arcs_size) -> MixedGraph
        __init__(self, nodes_size, nodes_resize_policy=True) -> MixedGraph
        __init__(self, nodes_size) -> MixedGraph
        __init__(self) -> MixedGraph
        __init__(self, g) -> MixedGraph
        """
        this = _pyAgrum.new_MixedGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_MixedGraph
    def __del__(self):
        return None

    def __eq__(self, g: 'MixedGraph') -> "bool":
        """__eq__(self, g) -> bool"""
        return _pyAgrum.MixedGraph___eq__(self, g)


    def __ne__(self, g: 'MixedGraph') -> "bool":
        """__ne__(self, g) -> bool"""
        return _pyAgrum.MixedGraph___ne__(self, g)


    def eraseNode(self, id: 'gum::NodeId const') -> "void":
        """
        eraseNode(self, id)


        Erase the node and all the adjacent edges.

        Parameters
        ----------
        id : int
          the id of the node

        """
        return _pyAgrum.MixedGraph_eraseNode(self, id)


    def clear(self) -> "void":
        """
        clear(self)


        Remove all the nodes and edges from the graph.

        """
        return _pyAgrum.MixedGraph_clear(self)


    def mixedOrientedPath(self, node1: 'gum::NodeId const', node2: 'gum::NodeId const') -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > > const":
        """
        mixedOrientedPath(self, node1, node2) -> Vector_int


        Parameters
        ----------
        node1 : int
        	the id form which the path begins
        node2 : int
        	the id to witch the path ends

        Returns
        -------
        List
        	 a path from node1 to node2, using edges and/or arcs (following the direction of the arcs)

        Raises
        ------
        gum.NotFound
        	If no path can be found between the two nodes

        """
        return _pyAgrum.MixedGraph_mixedOrientedPath(self, node1, node2)


    def mixedUnorientedPath(self, node1: 'gum::NodeId const', node2: 'gum::NodeId const') -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > > const":
        """
        mixedUnorientedPath(self, node1, node2) -> Vector_int


        Parameters
        ----------
        node1 : int
        	the id from which the path begins
        node2 : int
        	the id to which the path ends

        Returns
        -------
        List
        	 a path from node1 to node2, using edges and/or arcs (not necessarily following the direction of the arcs)

        Raises
        ------
        gum.NotFound
        	If no path can be found between the two nodes

        """
        return _pyAgrum.MixedGraph_mixedUnorientedPath(self, node1, node2)


    def toDot(self) -> "std::string const":
        """
        toDot(self) -> std::string const


        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.MixedGraph_toDot(self)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.MixedGraph___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.MixedGraph___str__(self)

MixedGraph_swigregister = _pyAgrum.MixedGraph_swigregister
MixedGraph_swigregister(MixedGraph)

class CliqueGraph(UndiGraph):
    """

    CliqueGraph represents a Clique Graph.

    Available constructors:
        ``CliqueGraph() -> CliqueGraph``

        ``CliqueGraph(src) -> CliqueGraph``

    Parameters
    ----------
    src : pyAgrum.CliqueGraph
      the CliqueGraph to copy

    """

    __swig_setmethods__ = {}
    for _s in [UndiGraph]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CliqueGraph, name, value)
    __swig_getmethods__ = {}
    for _s in [UndiGraph]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CliqueGraph, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, nodes_size, nodes_resize_policy=True, edges_size, edges_resize_policy=True) -> CliqueGraph
        __init__(self, nodes_size, nodes_resize_policy=True, edges_size) -> CliqueGraph
        __init__(self, nodes_size, nodes_resize_policy=True) -> CliqueGraph
        __init__(self, nodes_size) -> CliqueGraph
        __init__(self) -> CliqueGraph
        __init__(self, arg2) -> CliqueGraph
        """
        this = _pyAgrum.new_CliqueGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CliqueGraph
    def __del__(self):
        return None

    def addEdge(self, first: 'gum::NodeId const', second: 'gum::NodeId const') -> "void":
        """
        addEdge(self, first, second)


        Insert a new edge into the graph.

        Parameters
        ----------
        n1 : int
          the id of one node of the new inserted edge
        n2 : int
          the id of the other node of the new inserted edge

        Raises
        ------
        gum.InvalidNode
          If n1 or n2 does not belong to the graph nodes.

        """
        return _pyAgrum.CliqueGraph_addEdge(self, first, second)


    def eraseEdge(self, edge: 'Edge') -> "void":
        """
        eraseEdge(self, edge)


        Erase the edge between n1 and n2.

        Parameters
        ----------
        n1 : int
          the id of the tail node
        n2 : int
          the id of the head node

        """
        return _pyAgrum.CliqueGraph_eraseEdge(self, edge)


    def clearEdges(self) -> "void":
        """
        clearEdges(self)


        Remove all edges and their separators 

        """
        return _pyAgrum.CliqueGraph_clearEdges(self)


    def addNode(self, *args) -> "void":
        """
        addNode(self, clique) -> gum::NodeId
        addNode(self) -> gum::NodeId
        addNode(self, id, clique)
        addNode(self, id)


        Returns
        -------
        int
          the new NodeId

        """
        return _pyAgrum.CliqueGraph_addNode(self, *args)


    def eraseNode(self, node: 'gum::NodeId const') -> "void":
        """
        eraseNode(self, node)


        Erase the node and all the adjacent edges.

        Parameters
        ----------
        id : int
          the id of the node

        """
        return _pyAgrum.CliqueGraph_eraseNode(self, node)


    def clear(self) -> "void":
        """
        clear(self)


        Remove all the nodes and edges from the graph.

        """
        return _pyAgrum.CliqueGraph_clear(self)


    def container(self, idNode: 'gum::NodeId const') -> "gum::NodeId":
        """
        container(self, idNode) -> gum::NodeId


        Parameters
        ----------
        idNode : int
          the id of the node

        Returns
        -------
        int
          the id of a clique containing the node

        Raises
        ------
        gum.NotFound
          If no clique contains idNode  

        """
        return _pyAgrum.CliqueGraph_container(self, idNode)


    def setClique(self, idClique: 'gum::NodeId const', new_clique: 'gum::NodeSet const &') -> "void":
        """
        setClique(self, idClique, new_clique)


        changes the set of nodes included into a given clique

        Parameters
        ----------
        idClique : int
          the id of the clique
        new_clique : Set
          the new set of nodes to be included in the clique

        Raises
        ------
        gum.NotFound
          If idClique is not a clique of the graph

        """
        return _pyAgrum.CliqueGraph_setClique(self, idClique, new_clique)


    def addToClique(self, clique_id: 'gum::NodeId const', node_id: 'gum::NodeId const') -> "void":
        """
        addToClique(self, clique_id, node_id)


        Change the set of nodes included into a given clique and returns the new set 

        Parameters
        ----------
        clique_id : int
          the id of the clique
        node_id : int
          the id of the node

        Raises
        ------
        gum.NotFound
          If clique_id does not exist
        gum.DuplicateElement
          If clique_id set already contains the ndoe

        """
        return _pyAgrum.CliqueGraph_addToClique(self, clique_id, node_id)


    def eraseFromClique(self, clique_id: 'gum::NodeId const', node_id: 'gum::NodeId const') -> "void":
        """
        eraseFromClique(self, clique_id, node_id)


        Remove a node from a clique

        Parameters
        ----------
        clique_id : int
          the id of the clique
        node_id : int
          the id of the node

        Raises
        ------
        gum.NotFound
          If clique_id does not exist

        """
        return _pyAgrum.CliqueGraph_eraseFromClique(self, clique_id, node_id)


    def separator(self, *args) -> "gum::NodeSet const &":
        """
        separator(self, edge) -> gum::NodeSet const
        separator(self, clique1, clique) -> gum::NodeSet const &


        Parameters
        ----------
        edge : pyAgrum.Edge
          the edge to be checked
        clique1 : int 
          one extremity of the edge
        clique : int 
          the other extremity of the edge

        Returns
        -------
        Set
          the separator included in a given edge

        Raises
        ------
        gum.NotFound
          If the edge does not belong to the clique graph

        """
        return _pyAgrum.CliqueGraph_separator(self, *args)


    def containerPath(self, node1: 'gum::NodeId const', node2: 'gum::NodeId const') -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > >":
        """
        containerPath(self, node1, node2) -> Vector_int


        Parameters
        ----------
        node1 : int
          the id of one node
        node2 : int
          the id of the other node

        Returns
        -------
        List
          a path from a clique containing node1 to a clique containing node2

        Raises
        ------
        gum.NotFound 
          If such path cannot be found

        """
        return _pyAgrum.CliqueGraph_containerPath(self, node1, node2)


    def hasRunningIntersection(self) -> "bool":
        """
        hasRunningIntersection(self) -> bool


        Returns
        -------
        bool
          True if the running intersection property holds 

        """
        return _pyAgrum.CliqueGraph_hasRunningIntersection(self)


    def isJoinTree(self) -> "bool":
        """
        isJoinTree(self) -> bool


        Returns
        -------
        bool
          True if the graph is a join tree 

        """
        return _pyAgrum.CliqueGraph_isJoinTree(self)


    def toDot(self) -> "std::string const":
        """
        toDot(self) -> std::string const


        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.CliqueGraph_toDot(self)


    def __ne__(self, arg2: 'CliqueGraph') -> "bool":
        """__ne__(self, arg2) -> bool"""
        return _pyAgrum.CliqueGraph___ne__(self, arg2)


    def __eq__(self, arg2: 'CliqueGraph') -> "bool":
        """__eq__(self, arg2) -> bool"""
        return _pyAgrum.CliqueGraph___eq__(self, arg2)


    def clique(self, clique: 'gum::NodeId const') -> "PyObject *":
        """
        clique(self, clique) -> PyObject *


        Parameters
        ----------
        idClique : int
          the id of the clique

        Returns
        -------
        Set
          The set of nodes included in the clique

        Raises
        ------
        gum.NotFound
          If the clique does not belong to the clique graph

        """
        return _pyAgrum.CliqueGraph_clique(self, clique)


    def toDotWithNames(self,bn):
        """
        Parameters
        ----------
        bn : pyAgrum.BayesNet
        a Bayesian network

        Returns
        -------
        str
          a friendly display of the graph in DOT format where ids have been changed according to their correspondance in the BN
        """
        def nameFromId(m):
          return " ".join([bn.variable(int(n)).name()
                           for n in m.group().split("-")])
        import re
        m = re.compile('(?<=label=\")\d+[\-\d+]*')
        return m.sub(nameFromId,self.toDot())

CliqueGraph_swigregister = _pyAgrum.CliqueGraph_swigregister
CliqueGraph_swigregister(CliqueGraph)

class Instantiation(_object):
    """

    Class for assigning/browsing values to tuples of discrete variables.

    Instantiation is designed to assign values to tuples of variables and to efficiently loop over values of subsets of variables.

    Available constructors:

    	``Instantiation() -> Instantiation``

    	``Instantiation(aI) -> Instantiation``

    Parameters
    ----------
    aI: pyAgrum.Instantiation
      The Instantiation we copy

    Returns
    -------
    pyAgrum.Instantiation
    	An empty tuple or a copy of the one in parameters

    Instantiation is subscriptable therefore values can be easily accessed/modified.

    Examples
    --------
    >>> ## Access the value of A in an instantiation aI
    >>> valueOfA = aI['A']
    >>> ## Modify the value
    >>> aI['A'] = newValueOfA

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Instantiation, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Instantiation, name)

    def __init__(self, *args):
        """
        __init__(self) -> Instantiation
        __init__(self, aI, notifyMaster=True) -> Instantiation
        __init__(self, aI) -> Instantiation
        __init__(self, aMD) -> Instantiation
        __init__(self, aMD) -> Instantiation
        __init__(self, aMD) -> Instantiation
        __init__(self, aMD) -> Instantiation
        """
        this = _pyAgrum.new_Instantiation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_Instantiation
    def __del__(self):
        return None

    def nbrDim(self) -> "gum::Idx":
        """
        nbrDim(self) -> gum::Idx


        Returns
        -------
        int
            The number of variables in the Instantiation.

        """
        return _pyAgrum.Instantiation_nbrDim(self)


    def add(self, v: 'DiscreteVariable') -> "void":
        """
        add(self, v)


        Adds a new variable in the Instantiation.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The new variable added to the Instantiation

        Raises
        ------
        DuplicateElement
          If the variable is already in this Instantiation


        """
        return _pyAgrum.Instantiation_add(self, v)


    def erase(self, v: 'DiscreteVariable') -> "void":
        """
        erase(self, v)


        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The variable to be removed from this Instantiation.

        Raises
        ------
        NotFound
          If v does not belong to this Instantiation.

        """
        return _pyAgrum.Instantiation_erase(self, v)


    def clear(self) -> "void":
        """
        clear(self)


        Erase all variables from an Instantiation.

        """
        return _pyAgrum.Instantiation_clear(self)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(self) -> gum::Size


        Returns
        -------
        int
            The product of the variable's domain size in the Instantiation.

        """
        return _pyAgrum.Instantiation_domainSize(self)


    def pos(self, v: 'DiscreteVariable') -> "gum::Idx":
        """
        pos(self, v) -> gum::Idx


        Returns
        -------
        int
           the position of the variable v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            the variable for which its position is return.

        Raises
        ------
        NotFound
          If v does not belong to the instantiation.

        """
        return _pyAgrum.Instantiation_pos(self, v)


    def val(self, *args) -> "gum::Idx":
        """
        val(self, i) -> gum::Idx
        val(self, var) -> gum::Idx


        Parameters
        ----------
        i : int
        	The index of the variable.
        var : pyAgrum.DiscreteVariable
        	The variable the value of which we wish to know

        Returns
        -------
        int
        	the current value of the variable.

        Raises
        ------
        NotFound
          If the element cannot be found.

        """
        return _pyAgrum.Instantiation_val(self, *args)


    def variable(self, *args) -> "gum::DiscreteVariable const &":
        """
        variable(self, i) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable


        Parameters
        ----------
        i : int
          The index of the variable

        Returns
        -------
        pyAgrum.DiscreteVariable
          the variable at position i in the tuple.

        Raises
        ------
        NotFound
          If the element cannot be found.

        """
        return _pyAgrum.Instantiation_variable(self, *args)


    def chgVal(self, *args) -> "gum::Instantiation &":
        """
        chgVal(self, v, newval) -> Instantiation
        chgVal(self, v, newval) -> Instantiation
        chgVal(self, varPos, newval) -> Instantiation
        chgVal(self, var, newval) -> Instantiation
        chgVal(self, var, newval) -> Instantiation


        Assign newval to v (or to the variable at position varPos) in the Instantiation.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable or string
          The variable whose value is assigned (or its name)
        varPos : int
          The index of the variable whose value is assigned in the tuple of variables of the Instantiation
        newval : int or string
          The index of the value assigned (or its name)

        Returns
        -------
        pyAgrum.Instantiation
            The modified instantiation

        Raises
        ------
        NotFound
          If variable v does not belong to the instantiation.
        OutOfBound
          If newval is not a possible value for the variable.

        """
        return _pyAgrum.Instantiation_chgVal(self, *args)


    def setVals(self, i: 'Instantiation') -> "gum::Instantiation &":
        """
        setVals(self, i) -> Instantiation


        Assign the values from i in the Instantiation.

        Parameters
        ----------
        i : pyAgrum.Instantiation
          An Instantiation in which the new values are searched

        Returns
        -------
        pyAgrum.Instantiation
          a reference to the instantiation

        """
        return _pyAgrum.Instantiation_setVals(self, i)


    def contains(self, *args) -> "bool":
        """
        contains(self, v) -> bool
        contains(self, v) -> bool


        Indicates whether a given variable belongs to the Instantiation.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable for which the test is made.

        Returns
        -------
        bool :
            True if the variable is in the Instantiation.

        """
        return _pyAgrum.Instantiation_contains(self, *args)


    def variablesSequence(self) -> "gum::Sequence< gum::DiscreteVariable const * > const &":
        """
        variablesSequence(self) -> gum::Sequence< gum::DiscreteVariable const * > const &


        Returns
        -------
        List
            the sequence of DiscreteVariable of this instantiation.

        """
        return _pyAgrum.Instantiation_variablesSequence(self)


    def empty(self) -> "bool":
        """
        empty(self) -> bool


        Returns
        -------
        bool
            True if the instantiation is empty.

        """
        return _pyAgrum.Instantiation_empty(self)


    def inOverflow(self) -> "bool":
        """
        inOverflow(self) -> bool


        Returns
        -------
        bool
          True if the current value of the tuple is correct

        """
        return _pyAgrum.Instantiation_inOverflow(self)


    def unsetOverflow(self) -> "void":
        """
        unsetOverflow(self)


        Removes the flag overflow.

        """
        return _pyAgrum.Instantiation_unsetOverflow(self)


    def unsetEnd(self) -> "void":
        """
        unsetEnd(self)


        Alias for unsetOverflow().

        """
        return _pyAgrum.Instantiation_unsetEnd(self)


    def end(self) -> "bool":
        """
        end(self) -> bool


        Returns
        -------
        bool
            True if the Instantiation reached the end.

        """
        return _pyAgrum.Instantiation_end(self)


    def rend(self) -> "bool":
        """
        rend(self) -> bool


        Returns
        -------
        bool:
          True if the Instantiation reached the rend.

        """
        return _pyAgrum.Instantiation_rend(self)


    def inc(self) -> "void":
        """
        inc(self)


        Operator ++.

        """
        return _pyAgrum.Instantiation_inc(self)


    def dec(self) -> "void":
        """
        dec(self)


        Operator --.

        """
        return _pyAgrum.Instantiation_dec(self)


    def incIn(self, i: 'Instantiation') -> "void":
        """
        incIn(self, i)


        Operator ++ for the variables in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
            The set of variables to increment in this Instantiation.

        """
        return _pyAgrum.Instantiation_incIn(self, i)


    def decIn(self, i: 'Instantiation') -> "void":
        """
        decIn(self, i)


        Operator -- for the variables in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The set of variables to decrement in this Instantiation

        """
        return _pyAgrum.Instantiation_decIn(self, i)


    def incOut(self, i: 'Instantiation') -> "void":
        """
        incOut(self, i)


        Operator ++ for the variables not in i.

        Parameters
        ----------
        i : Instantiation
            The set of variable to not increment in this Instantiation.

        """
        return _pyAgrum.Instantiation_incOut(self, i)


    def decOut(self, i: 'Instantiation') -> "void":
        """
        decOut(self, i)


        Operator -- for the variables not in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The set of variables to not decrement in this Instantiation.

        """
        return _pyAgrum.Instantiation_decOut(self, i)


    def incNotVar(self, v: 'DiscreteVariable') -> "void":
        """
        incNotVar(self, v)


        Operator ++ for vars which are not v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable not to increment in this Instantiation.

        """
        return _pyAgrum.Instantiation_incNotVar(self, v)


    def decNotVar(self, v: 'DiscreteVariable') -> "void":
        """
        decNotVar(self, v)


        Operator -- for vars which are not v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The variable not to decrement in this Instantiation.

        """
        return _pyAgrum.Instantiation_decNotVar(self, v)


    def incVar(self, v: 'DiscreteVariable') -> "void":
        """
        incVar(self, v)


        Operator ++ for variable v only.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable to increment in this Instantiation.

        Raises
        ------
        NotFound
          If variable v does not belong to the Instantiation.

        """
        return _pyAgrum.Instantiation_incVar(self, v)


    def decVar(self, v: 'DiscreteVariable') -> "void":
        """
        decVar(self, v)


        Operator -- for variable v only.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
         The variable to decrement in this Instantiation.

        Raises
        ------
        NotFound
          If variable v does not belong to the Instantiation.

        """
        return _pyAgrum.Instantiation_decVar(self, v)


    def setFirst(self) -> "void":
        """
        setFirst(self)


        Assign the first values to the tuple of the Instantiation.

        """
        return _pyAgrum.Instantiation_setFirst(self)


    def setLast(self) -> "void":
        """
        setLast(self)


        Assign the last values in the Instantiation.

        """
        return _pyAgrum.Instantiation_setLast(self)


    def setFirstIn(self, i: 'Instantiation') -> "void":
        """
        setFirstIn(self, i)


        Assign the first values in the Instantiation for the variables in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The variables to which their first value is assigned in this Instantiation.

        """
        return _pyAgrum.Instantiation_setFirstIn(self, i)


    def setLastIn(self, i: 'Instantiation') -> "void":
        """
        setLastIn(self, i)


        Assign the last values in the Instantiation for the variables in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
            The variables to which their last value is assigned in this Instantiation.

        """
        return _pyAgrum.Instantiation_setLastIn(self, i)


    def setFirstOut(self, i: 'Instantiation') -> "void":
        """
        setFirstOut(self, i)


        Assign the first values in the Instantiation for the variables not in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
            The variable that will not be set to their first value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setFirstOut(self, i)


    def setLastOut(self, i: 'Instantiation') -> "void":
        """
        setLastOut(self, i)


        Assign the last values in the Instantiation for the variables not in i.

        Parameters
        ----------
        i : pyAgrum.Instantiation
            The variables that will not be set to their last value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setLastOut(self, i)


    def setFirstNotVar(self, v: 'DiscreteVariable') -> "void":
        """
        setFirstNotVar(self, v)


        Assign the first values to variables different of v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The variable that will not be set to its first value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setFirstNotVar(self, v)


    def setLastNotVar(self, v: 'DiscreteVariable') -> "void":
        """
        setLastNotVar(self, v)


        Assign the last values to variables different of v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable that will not be set to its last value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setLastNotVar(self, v)


    def setFirstVar(self, v: 'DiscreteVariable') -> "void":
        """
        setFirstVar(self, v)


        Assign the first value in the Instantiation for var v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable that will be set to its first value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setFirstVar(self, v)


    def setLastVar(self, v: 'DiscreteVariable') -> "void":
        """
        setLastVar(self, v)


        Assign the last value in the Instantiation for var v.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          The variable that will be set to its last value in this Instantiation.

        """
        return _pyAgrum.Instantiation_setLastVar(self, v)


    def __eq__(self, other: 'Instantiation') -> "bool":
        """__eq__(self, other) -> bool"""
        return _pyAgrum.Instantiation___eq__(self, other)


    def __iadd__(self, depl: 'gum::Size') -> "gum::Instantiation &":
        """__iadd__(self, depl) -> Instantiation"""
        return _pyAgrum.Instantiation___iadd__(self, depl)


    def __isub__(self, depl: 'gum::Size') -> "gum::Instantiation &":
        """__isub__(self, depl) -> Instantiation"""
        return _pyAgrum.Instantiation___isub__(self, depl)


    def hamming(self) -> "gum::Idx":
        """
        hamming(self) -> gum::Idx


        Returns
        -------
        int
          the hamming distance of this instantiation.

        """
        return _pyAgrum.Instantiation_hamming(self)


    def reorder(self, *args) -> "void":
        """
        reorder(self, v)
        reorder(self, i)


        Reorder vars of this instantiation giving the order in v (or i).

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The sequence of variables with which to reorder this Instantiation.
        v : list
            The new order of variables for this Instantiation.

        """
        return _pyAgrum.Instantiation_reorder(self, *args)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.Instantiation___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.Instantiation___str__(self)


    def todict(self, withLabels: 'bool'=False) -> "PyObject *":
        """
        todict(self, withLabels=False) -> PyObject
        todict(self) -> PyObject *


        Create a dict (variable_name:value) from an instantiation

        Parameters
        ----------
        withLabels : boolean
        	The value will be a label (string) if True. It will be a position (int) if False.

        Returns
        -------
        Dict
            The dictionary

        """
        return _pyAgrum.Instantiation_todict(self, withLabels)


    def fromdict(self, dict: 'PyObject *') -> "void":
        """
        fromdict(self, dict)


        Change the values in an instantiation from a dict (variable_name:value) where value can be a position (int) or a label (string).

        If a variable_name does not occur in the instantiation, nothing is done.

        Warnings
        --------
            OutOfBounds raised if a value cannot be found.

        """
        return _pyAgrum.Instantiation_fromdict(self, dict)


    def __setitem__(self,key,item):
      self.chgVal(key,item)

    def __getitem__(self,key):
      return self.val(self.variable(key))

Instantiation_swigregister = _pyAgrum.Instantiation_swigregister
Instantiation_swigregister(Instantiation)

GUM_DEFAULT_ITERATOR_NUMBER = _pyAgrum.GUM_DEFAULT_ITERATOR_NUMBER
class DAGmodel(_object):
    """

    Abstract class used by IBayesNet and InfluenceDiagram.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DAGmodel, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DAGmodel, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_DAGmodel
    def __del__(self):
        return None

    def property(self, name: 'std::string const &') -> "std::string const &":
        """
        property(self, name) -> std::string const &


        Warnings
        --------
        Unreferenced function

        """
        return _pyAgrum.DAGmodel_property(self, name)


    def propertyWithDefault(self, name: 'std::string const &', byDefault: 'std::string const &') -> "std::string const &":
        """
        propertyWithDefault(self, name, byDefault) -> std::string const &


        Warnings
        --------
        Unreferenced function

        """
        return _pyAgrum.DAGmodel_propertyWithDefault(self, name, byDefault)


    def setProperty(self, name: 'std::string const &', value: 'std::string const &') -> "void":
        """
        setProperty(self, name, value)


        Warnings
        --------
        Unreferenced function

        """
        return _pyAgrum.DAGmodel_setProperty(self, name, value)


    def dag(self) -> "gum::DAG const &":
        """
        dag(self) -> DAG


        Returns
        -------
        pyAgrum.DAG
        	a constant reference to the dag of this BayesNet.

        """
        return _pyAgrum.DAGmodel_dag(self)


    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        """
        variableNodeMap(self) -> VariableNodeMap


        Returns
        -------
        pyAgrum.variableNodeMap
        	the variable node map

        """
        return _pyAgrum.DAGmodel_variableNodeMap(self)


    def size(self) -> "gum::Size":
        """
        size(self) -> gum::Size


        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.DAGmodel_size(self)


    def sizeArcs(self) -> "gum::Size":
        """
        sizeArcs(self) -> gum::Size


        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.DAGmodel_sizeArcs(self)


    def empty(self) -> "bool":
        """
        empty(self) -> bool


        Returns
        -------
        bool
        	True if the model is empty

        """
        return _pyAgrum.DAGmodel_empty(self)


    def nodes(self) -> "gum::NodeGraphPart const &":
        """
        nodes(self) -> NodeGraphPart


        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.DAGmodel_nodes(self)


    def variable(self, id: 'gum::NodeId') -> "gum::DiscreteVariable const &":
        """
        variable(self, id) -> DiscreteVariable


        Parameters
        ----------
        id : int
        	a variable's id
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.DAGmodel_variable(self, id)


    def nodeId(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        nodeId(self, var) -> gum::NodeId


        Parameters
        ----------
        var : pyAgrum.DiscreteVariable
        	a variable

        Returns
        -------
        int
        	the id of the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.DAGmodel_nodeId(self, var)


    def idFromName(self, name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(self, name) -> gum::NodeId


        Returns a variable's id given its name in the graph.

        Parameters
        ----------
        name : str
        	The variable's name from which the id is returned.

        Returns
        -------
        int :
        	The variable's node id.

        Raises
        ------
        gum.NotFound
        	If name does not match a variable in the graph

        """
        return _pyAgrum.DAGmodel_idFromName(self, name)


    def variableFromName(self, name: 'std::string const &') -> "gum::DiscreteVariable const &":
        """
        variableFromName(self, name) -> DiscreteVariable


        Parameters
        ----------
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.DAGmodel_variableFromName(self, name)


    def completeInstantiation(self) -> "gum::Instantiation":
        """
        completeInstantiation(self) -> Instantiation


        Get an instantiation over all the variables of the model.

        Returns
        ----------
        pyAgrum.instantiation
        	the complete instantiation

        """
        return _pyAgrum.DAGmodel_completeInstantiation(self)


    def arcs(self) -> "gum::ArcSet const &":
        """
        arcs(self) -> gum::ArcSet const &


        Returns
        -------
        list
        	The lisf of arcs in the graph

        """
        return _pyAgrum.DAGmodel_arcs(self)


    def parents(self, *args) -> "gum::NodeSet const &":
        """
        parents(self, id) -> gum::NodeSet const
        parents(self, name) -> gum::NodeSet const &
        """
        return _pyAgrum.DAGmodel_parents(self, *args)


    def children(self, *args) -> "gum::NodeSet const &":
        """
        children(self, id) -> gum::NodeSet const
        children(self, name) -> gum::NodeSet const &
        """
        return _pyAgrum.DAGmodel_children(self, *args)


    def moralGraph(self, clear: 'bool'=True) -> "gum::UndiGraph const &":
        """
        moralGraph(self, clear=True) -> UndiGraph
        moralGraph(self) -> UndiGraph


        Returns the moral graph of the BayesNet, formed by adding edges between all pairs of nodes that have a common child, and then making all edges in the graph undirected.

        Returns
        -------
        pyAgrum.UndiGraph
        	The moral graph

        """
        return _pyAgrum.DAGmodel_moralGraph(self, clear)


    def topologicalOrder(self, clear: 'bool'=True) -> "gum::Sequence< gum::NodeId > const &":
        """
        topologicalOrder(self, clear=True) -> gum::Sequence< gum::NodeId > const
        topologicalOrder(self) -> gum::Sequence< gum::NodeId > const &


        Returns
        -------
        List
            the list of the nodes Ids in a topological order

        Raises
        ------
        gum.InvalidDirectedCycle
        	If this graph contains cycles

        """
        return _pyAgrum.DAGmodel_topologicalOrder(self, clear)


    def log10DomainSize(self) -> "double":
        """
        log10DomainSize(self) -> double


        Returns
        -------
        double
        	The log10 domain size of the joint probability for the model.

        """
        return _pyAgrum.DAGmodel_log10DomainSize(self)


    def hasSameStructure(self, other: 'DAGmodel') -> "bool":
        """
        hasSameStructure(self, other) -> bool


        Parameters
        ----------
        pyAgrum.DAGmodel
        	a direct acyclic model

        Returns
        -------
        bool
            True if all the named node are the same and all the named arcs are the same

        """
        return _pyAgrum.DAGmodel_hasSameStructure(self, other)

DAGmodel_swigregister = _pyAgrum.DAGmodel_swigregister
DAGmodel_swigregister(DAGmodel)
cvar = _pyAgrum.cvar
__list_end_safe = cvar.__list_end_safe
__list_end = cvar.__list_end

class EssentialGraph(_object):
    """Proxy of C++ gum::EssentialGraph class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EssentialGraph, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EssentialGraph, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self) -> EssentialGraph
        __init__(self, m) -> EssentialGraph
        __init__(self, m, mg) -> EssentialGraph
        __init__(self, g) -> EssentialGraph
        """
        this = _pyAgrum.new_EssentialGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_EssentialGraph
    def __del__(self):
        return None

    def mixedGraph(self) -> "gum::MixedGraph":
        """
        mixedGraph(self) -> MixedGraph


        Returns
        -------
        pyAgrum.MixedGraph
        	the mixed graph

        """
        return _pyAgrum.EssentialGraph_mixedGraph(self)


    def toDot(self) -> "std::string":
        """
        toDot(self) -> std::string


        Returns
        -------
        str
            a friendly display of the graph in DOT format 

        """
        return _pyAgrum.EssentialGraph_toDot(self)


    def sizeArcs(self) -> "gum::Size":
        """
        sizeArcs(self) -> gum::Size


        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.EssentialGraph_sizeArcs(self)


    def sizeEdges(self) -> "gum::Size":
        """
        sizeEdges(self) -> gum::Size


        Returns
        -------
        int
            the number of edges in the graph

        """
        return _pyAgrum.EssentialGraph_sizeEdges(self)


    def sizeNodes(self) -> "gum::Size":
        """
        sizeNodes(self) -> gum::Size


        Returns
        -------
        int
        	the number of nodes in the graph

        """
        return _pyAgrum.EssentialGraph_sizeNodes(self)


    def size(self) -> "gum::Size":
        """
        size(self) -> gum::Size


        Returns
        -------
        int
        	the number of nodes in the graph

        """
        return _pyAgrum.EssentialGraph_size(self)


    def nodes(self) -> "PyObject *":
        """nodes(self) -> PyObject *"""
        return _pyAgrum.EssentialGraph_nodes(self)


    def arcs(self) -> "PyObject *":
        """
        arcs(self) -> PyObject *


        Returns
        -------
        list
        	The lisf of arcs in the EssentialGraph

        """
        return _pyAgrum.EssentialGraph_arcs(self)


    def parents(self, id: 'gum::NodeId') -> "PyObject *":
        """
        parents(self, id) -> PyObject *


        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.EssentialGraph_parents(self, id)


    def children(self, id: 'gum::NodeId') -> "PyObject *":
        """
        children(self, id) -> PyObject *


        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.EssentialGraph_children(self, id)


    def edges(self) -> "PyObject *":
        """
        edges(self) -> PyObject *


        Returns
        -------
        List
          the list of the edges

        """
        return _pyAgrum.EssentialGraph_edges(self)


    def neighbours(self, id: 'gum::NodeId') -> "PyObject *":
        """
        neighbours(self, id) -> PyObject *


        Parameters
        ----------
        id : int
            the id of the checked node

        Returns
        -------
        Set
            The set of edges adjacent to the given node 

        """
        return _pyAgrum.EssentialGraph_neighbours(self, id)

EssentialGraph_swigregister = _pyAgrum.EssentialGraph_swigregister
EssentialGraph_swigregister(EssentialGraph)

class MarkovBlanket(_object):
    """Proxy of C++ gum::MarkovBlanket class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MarkovBlanket, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MarkovBlanket, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, m, n) -> MarkovBlanket
        __init__(self, m, name) -> MarkovBlanket
        """
        this = _pyAgrum.new_MarkovBlanket(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_MarkovBlanket
    def __del__(self):
        return None

    def mb(self) -> "gum::DiGraph":
        """
        mb(self) -> DiGraph


        Returns
        -------
        pyAgrum.DiGraph
          a copy of the directed graph

        """
        return _pyAgrum.MarkovBlanket_mb(self)


    def toDot(self) -> "std::string":
        """
        toDot(self) -> std::string


        Returns
        -------
        str
            a friendly display of the graph in DOT format 

        """
        return _pyAgrum.MarkovBlanket_toDot(self)


    def sizeArcs(self) -> "gum::Size":
        """
        sizeArcs(self) -> gum::Size


        Returns
        -------
        int
            the number of arcs in the graph

        """
        return _pyAgrum.MarkovBlanket_sizeArcs(self)


    def sizeNodes(self) -> "gum::Size":
        """
        sizeNodes(self) -> gum::Size


        Returns
        -------
        int
        	the number of nodes in the graph

        """
        return _pyAgrum.MarkovBlanket_sizeNodes(self)


    def size(self) -> "gum::Size":
        """
        size(self) -> gum::Size


        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.MarkovBlanket_size(self)


    def hasSameStructure(self, other: 'DAGmodel') -> "bool":
        """
        hasSameStructure(self, other) -> bool


        Parameters
        ----------
        pyAgrum.DAGmodel
        	a direct acyclic model

        Returns
        -------
        bool
            True if all the named node are the same and all the named arcs are the same 

        """
        return _pyAgrum.MarkovBlanket_hasSameStructure(self, other)


    def nodes(self) -> "PyObject *":
        """
        nodes(self) -> PyObject *


        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.MarkovBlanket_nodes(self)


    def arcs(self) -> "PyObject *":
        """
        arcs(self) -> PyObject *


        Returns
        -------
        List
        	the list of the arcs

        """
        return _pyAgrum.MarkovBlanket_arcs(self)


    def parents(self, id: 'gum::NodeId') -> "PyObject *":
        """
        parents(self, id) -> PyObject *


        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.MarkovBlanket_parents(self, id)


    def children(self, id: 'gum::NodeId') -> "PyObject *":
        """
        children(self, id) -> PyObject *


        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.MarkovBlanket_children(self, id)

MarkovBlanket_swigregister = _pyAgrum.MarkovBlanket_swigregister
MarkovBlanket_swigregister(MarkovBlanket)

class StructuralComparator(_object):
    """Proxy of C++ gum::StructuralComparator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StructuralComparator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StructuralComparator, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(self) -> StructuralComparator"""
        this = _pyAgrum.new_StructuralComparator()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_StructuralComparator
    def __del__(self):
        return None

    def compare(self, *args) -> "void":
        """
        compare(self, ref, test)
        compare(self, ref, test)
        compare(self, ref, test)


        Use to compare the edges/arcs of two structure of the same type and same sizes (either DiGraph, UndiGraph or MixedGraph).

        Could be use to compare a BN and its learned version.

        Parameters
        ----------
        ref :
        	the structure of reference
        test :
        	the structure we want to test

        """
        return _pyAgrum.StructuralComparator_compare(self, *args)


    def precision_skeleton(self) -> "double":
        """
        precision_skeleton(self) -> double


        Rate of true postive over labelized edges.

        Returns
        -------
        double
        	the precision of the tested graph skeleton

        """
        return _pyAgrum.StructuralComparator_precision_skeleton(self)


    def recall_skeleton(self) -> "double":
        """
        recall_skeleton(self) -> double


        Rate of true postive over labelized edges.

        Returns
        -------
        double
        	the recall of the tested graph skeleton

        """
        return _pyAgrum.StructuralComparator_recall_skeleton(self)


    def f_score_skeleton(self) -> "double":
        """
        f_score_skeleton(self) -> double


        Harmonic mean between recall and precision.

        Returns
        -------
        double
        	the tarmonic mean of the tested graph skeleton

        """
        return _pyAgrum.StructuralComparator_f_score_skeleton(self)


    def precision(self) -> "double":
        """
        precision(self) -> double


        Rate of true postive over postively labelized arcs/edges.

        Returns
        -------
        double
        	the precision of the tested graph

        """
        return _pyAgrum.StructuralComparator_precision(self)


    def recall(self) -> "double":
        """
        recall(self) -> double


        Rate of true postive over labelized arcs/edges.

        Returns
        -------
        double
        	the recall of the tested graph

        """
        return _pyAgrum.StructuralComparator_recall(self)


    def f_score(self) -> "double":
        """
        f_score(self) -> double


        Harmonic mean between recall and precision.

        Returns
        -------
        double
        	the harmonic mean of the tested graph

        """
        return _pyAgrum.StructuralComparator_f_score(self)

StructuralComparator_swigregister = _pyAgrum.StructuralComparator_swigregister
StructuralComparator_swigregister(StructuralComparator)

class ApproximationScheme(_object):
    """

    Used to parametrize stopping criteria in approximate inference or learning algorithm.

    Available constructors:
    	``ApproximationScheme() -> ApproximationScheme``

    	``ApproximationScheme(v) -> ApproximationScheme``

    Parameters
    ----------
    v : bool

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ApproximationScheme, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ApproximationScheme, name)
    __repr__ = _swig_repr

    def __init__(self, v: 'bool'=False):
        """
        __init__(self, v=False) -> ApproximationScheme
        __init__(self) -> ApproximationScheme
        """
        this = _pyAgrum.new_ApproximationScheme(v)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_ApproximationScheme
    def __del__(self):
        return None

    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.ApproximationScheme_setEpsilon(self, eps)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.ApproximationScheme_epsilon(self)


    def disableEpsilon(self) -> "void":
        """
        disableEpsilon(self)


        Disable epsilon as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_disableEpsilon(self)


    def enableEpsilon(self) -> "void":
        """
        enableEpsilon(self)


        Enable epsilon as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_enableEpsilon(self)


    def isEnabledEpsilon(self) -> "bool":
        """
        isEnabledEpsilon(self) -> bool


        Returns
        -------
        bool
          True if epsilon is used as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_isEnabledEpsilon(self)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.ApproximationScheme_setMinEpsilonRate(self, rate)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.ApproximationScheme_minEpsilonRate(self)


    def disableMinEpsilonRate(self) -> "void":
        """
        disableMinEpsilonRate(self)


        Disable a min epsilon rate as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_disableMinEpsilonRate(self)


    def enableMinEpsilonRate(self) -> "void":
        """
        enableMinEpsilonRate(self)


        Enable a min epsilon rate as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_enableMinEpsilonRate(self)


    def isEnabledMinEpsilonRate(self) -> "bool":
        """
        isEnabledMinEpsilonRate(self) -> bool


        Returns
        -------
        bool
          True if epsilon rate is used as a stopping criterion

        """
        return _pyAgrum.ApproximationScheme_isEnabledMinEpsilonRate(self)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.ApproximationScheme_setMaxIter(self, max)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.ApproximationScheme_maxIter(self)


    def disableMaxIter(self) -> "void":
        """
        disableMaxIter(self)


        Disable max iterations as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_disableMaxIter(self)


    def enableMaxIter(self) -> "void":
        """
        enableMaxIter(self)


        Enable max iterations as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_enableMaxIter(self)


    def isEnabledMaxIter(self) -> "bool":
        """
        isEnabledMaxIter(self) -> bool


        Returns
        -------
        bool
          True if max iterations is used as a stopping criterion

        """
        return _pyAgrum.ApproximationScheme_isEnabledMaxIter(self)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.ApproximationScheme_setMaxTime(self, timeout)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.ApproximationScheme_maxTime(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.ApproximationScheme_currentTime(self)


    def disableMaxTime(self) -> "void":
        """
        disableMaxTime(self)


        Disable max time as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_disableMaxTime(self)


    def enableMaxTime(self) -> "void":
        """
        enableMaxTime(self)


        Enable max time as a stopping criterion.

        """
        return _pyAgrum.ApproximationScheme_enableMaxTime(self)


    def isEnabledMaxTime(self) -> "bool":
        """
        isEnabledMaxTime(self) -> bool


        Returns
        -------
        bool
          True if max time is used as a stopping criterion

        """
        return _pyAgrum.ApproximationScheme_isEnabledMaxTime(self)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.ApproximationScheme_setPeriodSize(self, p)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.ApproximationScheme_periodSize(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.ApproximationScheme_setVerbosity(self, v)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.ApproximationScheme_verbosity(self)


    def stateApproximationScheme(self) -> "gum::IApproximationSchemeConfiguration::ApproximationSchemeSTATE":
        """
        stateApproximationScheme(self) -> gum::IApproximationSchemeConfiguration::ApproximationSchemeSTATE


        Returns
        -------
        int
          the state of the approximation scheme

        """
        return _pyAgrum.ApproximationScheme_stateApproximationScheme(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.ApproximationScheme_nbrIterations(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.ApproximationScheme_history(self)


    def initApproximationScheme(self) -> "void":
        """
        initApproximationScheme(self)


        Initiate the approximation scheme.

        """
        return _pyAgrum.ApproximationScheme_initApproximationScheme(self)


    def startOfPeriod(self) -> "bool":
        """
        startOfPeriod(self) -> bool


        Returns
        -------
        bool
          True if it is a start of a period

        """
        return _pyAgrum.ApproximationScheme_startOfPeriod(self)


    def updateApproximationScheme(self, incr: 'unsigned int'=1) -> "void":
        """
        updateApproximationScheme(self, incr=1)
        updateApproximationScheme(self)


        Update the approximation scheme.

        """
        return _pyAgrum.ApproximationScheme_updateApproximationScheme(self, incr)


    def remainingBurnIn(self) -> "gum::Size":
        """
        remainingBurnIn(self) -> gum::Size


        Returns
        -------
        int
          the number of remaining burn in

        """
        return _pyAgrum.ApproximationScheme_remainingBurnIn(self)


    def stopApproximationScheme(self) -> "void":
        """
        stopApproximationScheme(self)


        Stop the approximation scheme.

        """
        return _pyAgrum.ApproximationScheme_stopApproximationScheme(self)


    def continueApproximationScheme(self, error: 'double') -> "bool":
        """
        continueApproximationScheme(self, error) -> bool


        Continue the approximation scheme.

        Parameters
        ----------
        error : double

        """
        return _pyAgrum.ApproximationScheme_continueApproximationScheme(self, error)

ApproximationScheme_swigregister = _pyAgrum.ApproximationScheme_swigregister
ApproximationScheme_swigregister(ApproximationScheme)

FindBarrenNodesType_FIND_NO_BARREN_NODES = _pyAgrum.FindBarrenNodesType_FIND_NO_BARREN_NODES
FindBarrenNodesType_FIND_BARREN_NODES = _pyAgrum.FindBarrenNodesType_FIND_BARREN_NODES

def randomDistribution_double(n: 'gum::Size') -> "std::vector< double,std::allocator< double > >":
    """
    randomDistribution_double(n) -> Vector_double


    Parameters
    ----------
    n : int
      The number of modalities for the ditribution.

    Returns
    -------
    a random discrete distribution. 

    """
    return _pyAgrum.randomDistribution_double(n)
class DiscretizedVariable_double(IDiscretizedVariable):
    """

    DiscretizedVariable is a discrete random variable with a set of ``ticks`` defining intervalls.

    Available constructors:

        ``DiscretizedVariable(aName, aDesc='') -> DiscretizedVariable``

        ``DiscretizedVariable(aDDRV) -> DiscretizedVariable``

    Parameters
    ----------
    aName: str
      The name of the variable
    aDesc: str
      The (optional) description of the variable
    aDDRV: pyAgrum.DiscretizedVariable
      Another `DiscretizedVariable` that will be copied

    Examples
    --------
    >>> import pyAgrum as gum
    >>>
    >>> vX=gum.DiscretizedVariable('X','X has been discretized')
    >>> vX.addTick(1).addTick(2).addTick(3).addTick(3.1415) #doctest: +ELLIPSIS
    >>> ## <pyAgrum.pyAgrum.DiscretizedVariable;...>
    >>> print(vX)
    >>> ## X<[1;2[,[2;3[,[3;3.1415]>
    >>>
    >>> vX.isTick(4)
    >>> ## False
    >>>
    >>> vX.labels()
    >>> ## ('[1;2[', '[2;3[', '[3;3.1415]')
    >>>
    >>> # where is the real value 2.5 ?
    >>> vX.index('2.5')
    >>> ## 1

    """

    __swig_setmethods__ = {}
    for _s in [IDiscretizedVariable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DiscretizedVariable_double, name, value)
    __swig_getmethods__ = {}
    for _s in [IDiscretizedVariable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DiscretizedVariable_double, name)

    def __init__(self, *args):
        """
        __init__(self, aName, aDesc) -> DiscretizedVariable_double
        __init__(self, aName, aDesc, ticks) -> DiscretizedVariable_double
        __init__(self, aDRV) -> DiscretizedVariable_double
        """
        this = _pyAgrum.new_DiscretizedVariable_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DiscretizedVariable_double
    def __del__(self):
        return None

    def clone(self) -> "gum::DiscretizedVariable< double > *":
        """
        clone(self) -> DiscretizedVariable_double


        Returns
        -------
        pyAgrum.DiscretizedVariable
        	a copy of the DiscretizedVariable

        """
        return _pyAgrum.DiscretizedVariable_double_clone(self)


    def varType(self) -> "gum::VarType":
        """
        varType(self) -> gum::VarType


        returns the type of variable

        Returns
        -------
        int :
        	the type of the variable, 0: DiscretizedVariable, 1: LabelizedVariable, 2: RangeVariable

        """
        return _pyAgrum.DiscretizedVariable_double_varType(self)


    def isTick(self, aTick: 'double const &') -> "bool":
        """
        isTick(self, aTick) -> bool


        Parameters
        ----------
        aTick : double
        	the Tick to be tested

        Returns
        -------
        bool :
        	True if the Tick already exists

        """
        return _pyAgrum.DiscretizedVariable_double_isTick(self, aTick)


    def addTick(self,*args):
        """
        Parameters
        ----------
        aTick : double
            the Tick to be added

        Returns
        -------
        pyAgrum.DiscretizedVariable
            the discretized variable

        Raises
        ------
        gum.DefaultInLabel
            If the tick is already defined
        """
        _pyAgrum.DiscretizedVariable_double_addTick(self,*args)
        return self



    def eraseTicks(self) -> "void":
        """
        eraseTicks(self)


        erase all the Ticks 

        """
        return _pyAgrum.DiscretizedVariable_double_eraseTicks(self)


    def label(self, i: 'gum::Idx') -> "std::string":
        """
        label(self, i) -> std::string


        Parameters
        ----------
        i : int
        	the index of the label we wish to return

        Returns
        -------
        str
        	the indice-th label

        Raises
        ------
        gum.OutOfBound
        	If the variable does not contain the label

        """
        return _pyAgrum.DiscretizedVariable_double_label(self, i)


    def numerical(self, indice: 'gum::Idx') -> "double":
        """
        numerical(self, indice) -> double


        Parameters
        ----------
        indice : int
        	an index

        Returns
        -------
        float
        	the numerical representation of the indice-th value

        """
        return _pyAgrum.DiscretizedVariable_double_numerical(self, indice)


    def index(self, label: 'std::string const &') -> "gum::Idx":
        """
        index(self, label) -> gum::Idx


        Parameters
        ----------
        label : str
        	a label

        Returns
        -------
        int
        	the indice of the label

        """
        return _pyAgrum.DiscretizedVariable_double_index(self, label)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of modalities in the variable domain

        """
        return _pyAgrum.DiscretizedVariable_double_domainSize(self)


    def domain(self) -> "std::string const":
        """
        domain(self) -> std::string const


        Returns
        -------
        str
            the domain of the variable as a string

        """
        return _pyAgrum.DiscretizedVariable_double_domain(self)


    def tick(self, i: 'gum::Idx') -> "double const &":
        """
        tick(self, i) -> double const &


        Indicate the index of the Tick

        Parameters
        ----------
        i : int
        	the index of the Tick

        Returns
        -------
        aTick : double
        	the index-th Tick

        Raises
        ------
        gum.NotFound
        	If the index is greater than the number of Ticks

        """
        return _pyAgrum.DiscretizedVariable_double_tick(self, i)


    def ticks(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        ticks(self) -> Vector_double


        Returns
        -------
        tuple :
        	a tuple containing all the Ticks

        """
        return _pyAgrum.DiscretizedVariable_double_ticks(self)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.DiscretizedVariable_double___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.DiscretizedVariable_double___str__(self)

DiscretizedVariable_double_swigregister = _pyAgrum.DiscretizedVariable_double_swigregister
DiscretizedVariable_double_swigregister(DiscretizedVariable_double)

class MultiDimContainer_double(_object):
    """Proxy of C++ gum::MultiDimContainer< double > class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiDimContainer_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultiDimContainer_double, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_MultiDimContainer_double
    def __del__(self):
        return None

    def set(self, i: 'Instantiation', value: 'double const &') -> "void":
        """set(self, i, value)"""
        return _pyAgrum.MultiDimContainer_double_set(self, i, value)


    def get(self, i: 'Instantiation') -> "double":
        """get(self, i) -> double"""
        return _pyAgrum.MultiDimContainer_double_get(self, i)


    def fill(self, d: 'double const &') -> "void":
        """fill(self, d)"""
        return _pyAgrum.MultiDimContainer_double_fill(self, d)


    def populate(self, *args) -> "void":
        """
        populate(self, v)
        populate(self, l)
        """
        return _pyAgrum.MultiDimContainer_double_populate(self, *args)


    def copyFrom(self, *args) -> "void":
        """
        copyFrom(self, src)
        copyFrom(self, src, p_i)
        """
        return _pyAgrum.MultiDimContainer_double_copyFrom(self, *args)


    def extractFrom(self, src: 'MultiDimContainer_double', mask: 'Instantiation') -> "void":
        """extractFrom(self, src, mask)"""
        return _pyAgrum.MultiDimContainer_double_extractFrom(self, src, mask)


    def content(self, *args) -> "gum::MultiDimImplementation< double > *":
        """
        content(self) -> gum::MultiDimImplementation< double > const
        content(self) -> gum::MultiDimImplementation< double > *
        """
        return _pyAgrum.MultiDimContainer_double_content(self, *args)


    def getMasterRef(self, *args) -> "gum::MultiDimAdressable const &":
        """
        getMasterRef(self) -> MultiDimAdressable
        getMasterRef(self) -> MultiDimAdressable
        """
        return _pyAgrum.MultiDimContainer_double_getMasterRef(self, *args)


    def copy(self, src: 'MultiDimContainer_double') -> "void":
        """copy(self, src)"""
        return _pyAgrum.MultiDimContainer_double_copy(self, src)


    def newFactory(self) -> "gum::MultiDimContainer< double > *":
        """newFactory(self) -> MultiDimContainer_double"""
        return _pyAgrum.MultiDimContainer_double_newFactory(self)


    def toString(self, *args) -> "std::string const":
        """
        toString(self) -> std::string const
        toString(self, i) -> std::string const
        """
        return _pyAgrum.MultiDimContainer_double_toString(self, *args)


    def __eq__(self, p: 'MultiDimContainer_double') -> "bool":
        """__eq__(self, p) -> bool"""
        return _pyAgrum.MultiDimContainer_double___eq__(self, p)


    def __ne__(self, p: 'MultiDimContainer_double') -> "bool":
        """__ne__(self, p) -> bool"""
        return _pyAgrum.MultiDimContainer_double___ne__(self, p)


    def apply(self, f: 'std::function< double (double) >') -> "void":
        """apply(self, f)"""
        return _pyAgrum.MultiDimContainer_double_apply(self, f)


    def reduce(self, f: 'std::function< double (double,double) >', base: 'double') -> "double":
        """reduce(self, f, base) -> double"""
        return _pyAgrum.MultiDimContainer_double_reduce(self, f, base)


    def beginMultipleChanges(self) -> "void":
        """beginMultipleChanges(self)"""
        return _pyAgrum.MultiDimContainer_double_beginMultipleChanges(self)


    def endMultipleChanges(self, *args) -> "void":
        """
        endMultipleChanges(self)
        endMultipleChanges(self, v)
        """
        return _pyAgrum.MultiDimContainer_double_endMultipleChanges(self, *args)

MultiDimContainer_double_swigregister = _pyAgrum.MultiDimContainer_double_swigregister
MultiDimContainer_double_swigregister(MultiDimContainer_double)

class Potential_double(_object):
    """

    Class representing a potential.

    Available constructors:

      ``Potential() -> Potential``

      ``Potential(src) -> Potential``

    Parameters
    ----------
    src: pyAgrum.Potential
      The Potential to copy

    Returns
    -------
    pyAgrum.Potential
      The new Potential


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Potential_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Potential_double, name)

    def __init__(self, *args):
        """
        __init__(self) -> Potential_double
        __init__(self, aContent) -> Potential_double
        __init__(self, aContent, src) -> Potential_double
        __init__(self, src) -> Potential_double
        __init__(self, arg2) -> Potential_double
        """
        this = _pyAgrum.new_Potential_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._notSync=True



    __swig_destroy__ = _pyAgrum.delete_Potential_double
    def __del__(self):
        return None

    def newFactory(self) -> "gum::Potential< double > *":
        """
        newFactory(self) -> Potential_double


        Erase the Potential content and create a new empty one.

        Returns
        -------
        pyAgrum.Potential
         a reference to the new Potential

        """
        return _pyAgrum.Potential_double_newFactory(self)


    def isNonZeroMap(self) -> "gum::Potential< double >":
        """
        isNonZeroMap(self) -> Potential_double


        Returns
        -------
        pyAgrum.Potential
          a boolean-like potential using the predicate isNonZero

        """
        return _pyAgrum.Potential_double_isNonZeroMap(self)


    def sum(self) -> "double":
        """
        sum(self) -> double


        Returns
        -------
        double :
          the sum of all elements in the Potential

        """
        return _pyAgrum.Potential_double_sum(self)


    def product(self) -> "double":
        """
        product(self) -> double


        Returns
        -------
        double
          the product of all elements in the Potential

        """
        return _pyAgrum.Potential_double_product(self)


    def max(self) -> "double":
        """
        max(self) -> double


        Returns
        -------
        double
          the maximum of all elements in the Potential

        """
        return _pyAgrum.Potential_double_max(self)


    def min(self) -> "double":
        """
        min(self) -> double


        Returns
        -------
        double
          the min of all elements in the Potential

        """
        return _pyAgrum.Potential_double_min(self)


    def maxNonOne(self) -> "double":
        """
        maxNonOne(self) -> double


        Returns
        -------
        double
          the maximum of non one elements in the Potential

        Raises
        ------
        gum.NotFound
          If all value == 1.0

        """
        return _pyAgrum.Potential_double_maxNonOne(self)


    def minNonZero(self) -> "double":
        """
        minNonZero(self) -> double


        Returns
        -------
        double
          the min of non zero elements in the Potential

        Raises
        ------
        gum.NotFound
          If all value == 0.0

        """
        return _pyAgrum.Potential_double_minNonZero(self)


    def findAll(self, v: 'double') -> "gum::Set< gum::Instantiation >":
        """findAll(self, v) -> gum::Set< gum::Instantiation >"""
        return _pyAgrum.Potential_double_findAll(self, v)


    def argmax(self) -> "gum::Set< gum::Instantiation >":
        """argmax(self) -> gum::Set< gum::Instantiation >"""
        return _pyAgrum.Potential_double_argmax(self)


    def argmin(self) -> "gum::Set< gum::Instantiation >":
        """argmin(self) -> gum::Set< gum::Instantiation >"""
        return _pyAgrum.Potential_double_argmin(self)


    def entropy(self) -> "double":
        """
        entropy(self) -> double


        Returns
        -------
        double
          the entropy of the potential

        """
        return _pyAgrum.Potential_double_entropy(self)


    def fillWith(self, *args) -> "gum::Potential< double > const &":
        """
        fillWith(self, src) -> Potential_double
        fillWith(self, src, mapSrc) -> Potential_double
        fillWith(self, v) -> Potential_double
        fillWith(self, v) -> Potential_double
        """
        val = _pyAgrum.Potential_double_fillWith(self, *args)

        self._notSync=True
        return self


        return val


    def abs(self) -> "gum::Potential< double > const &":
        """
        abs(self) -> Potential_double


        Apply abs on every element of the container

        Returns
        -------
        pyAgrum.Potential
            a reference to the modified potential.

        """
        val = _pyAgrum.Potential_double_abs(self)

        self._notSync=True
        return self


        return val


    def normalize(self) -> "gum::Potential< double > const &":
        """
        normalize(self) -> Potential_double


        Normalize the Potential (do nothing if sum is 0)

        Returns
        -------
        pyAgrum.Potential
          a reference to the normalized Potential

        """
        val = _pyAgrum.Potential_double_normalize(self)

        self._notSync=True
        return self


        return val


    def sq(self) -> "gum::Potential< double > const &":
        """
        sq(self) -> Potential_double


        Square all the values in the Potential

        """
        val = _pyAgrum.Potential_double_sq(self)

        self._notSync=True
        return self


        return val


    def KL(self, p: 'Potential_double') -> "double":
        """
        KL(self, p) -> double


        Compute the Kullback-Leibler divergence between the potential and p, check the compatibility and call fastKL.

        Parameters
        ----------
        p : pyAgrum.Potential
          the potential from which we want to calculate the divergence.

        Returns
        -------
        float
          The value of the divergence

        Raises
        ------
        gum.InvalidArgument
          If p is not compatible with the potential (dimension, variables)
        gum.FatalError
          If a zero is found in p or the potential and not in the other. 

        """
        return _pyAgrum.Potential_double_KL(self, p)


    def fastKL(self, p: 'Potential_double') -> "double":
        """
        fastKL(self, p) -> double


        compute KL divergence between this and p without testing compatibilty (undefined errors may occur in this case)

        Parameters
        ----------
        p : pyAgrum.Potential
          the potential from which we want to calculate the divergence.

        Returns
        -------
        float
          The value of the divergence

        Raises
        ------
        gum.FatalError
          If a zero is found in p or this and not in the other. 

        """
        return _pyAgrum.Potential_double_fastKL(self, p)


    def normalizeAsCPT(self) -> "void":
        """
        normalizeAsCPT(self)


        Normalize the Potential as a CPT

        Returns
        -------
        pyAgrum.Potential
          a reference to the normalized Potential

        Raises
        ------
        gum.FatalError
          If some distribution sums to 0

        """
        val = _pyAgrum.Potential_double_normalizeAsCPT(self)

        self._notSync=True
        return self


        return val


    def scale(self, v: 'double') -> "gum::Potential< double > const &":
        """
        scale(self, v) -> Potential_double


        Create a new potential multiplied by v.

        Parameters
        ----------
        v : double
          a multiplier

        Returns
        -------
          a reference to the modified potential

        """
        val = _pyAgrum.Potential_double_scale(self, v)

        self._notSync=True
        return self


        return val


    def translate(self, v: 'double') -> "gum::Potential< double > const &":
        """
        translate(self, v) -> Potential_double


        Create a new potential added with v.

        Parameters
        ----------
        v : double
          The value to be added

        Returns
        -------
          a reference to the modified potential

        """
        val = _pyAgrum.Potential_double_translate(self, v)

        self._notSync=True
        return self


        return val


    def draw(self) -> "gum::Idx":
        """
        draw(self) -> gum::Idx


        draw a value using the potential as a probability table.

        Returns
        -------
        int
          the index of the drawn value

        """
        return _pyAgrum.Potential_double_draw(self)


    def __add__(self, p2: 'Potential_double') -> "gum::Potential< double >":
        """__add__(self, p2) -> Potential_double"""
        return _pyAgrum.Potential_double___add__(self, p2)


    def __sub__(self, p2: 'Potential_double') -> "gum::Potential< double >":
        """__sub__(self, p2) -> Potential_double"""
        return _pyAgrum.Potential_double___sub__(self, p2)


    def __mul__(self, p2: 'Potential_double') -> "gum::Potential< double >":
        """__mul__(self, p2) -> Potential_double"""
        return _pyAgrum.Potential_double___mul__(self, p2)


    def __iadd__(self, r: 'Potential_double') -> "gum::Potential< double > &":
        """__iadd__(self, r) -> Potential_double"""
        return _pyAgrum.Potential_double___iadd__(self, r)


    def __imul__(self, r: 'Potential_double') -> "gum::Potential< double > &":
        """__imul__(self, r) -> Potential_double"""
        return _pyAgrum.Potential_double___imul__(self, r)


    def __isub__(self, r: 'Potential_double') -> "gum::Potential< double > &":
        """__isub__(self, r) -> Potential_double"""
        return _pyAgrum.Potential_double___isub__(self, r)


    def __itruediv__(self, *args):
        return _pyAgrum.Potential_double___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.Potential_double___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.Potential_double___str__(self)


    def extract(self, *args) -> "gum::Potential< double >":
        """
        extract(self, inst) -> Potential_double
        extract(self, dict) -> Potential_double


        create a new Potential extracted from self given a partial instantiation.

        Parameters
        ----------
        inst : pyAgrum.instantiation
          a partial instantiation
        dict : dict
          a dictionnary containing discrete variables (?)

        Returns
        -------
        pyAgrum.Potential
          the new Potential

        """
        return _pyAgrum.Potential_double_extract(self, *args)


    def reorganize(self, *args) -> "gum::Potential< double >":
        """
        reorganize(self, vars) -> Potential_double
        reorganize(self, varnames) -> Potential_double


        Create a new Potential with another order.

        Returns
        -------
        varnames : list
          a list of the var names in the new order

        Returns
        -------
        pyAgrum.Potential
          a reference to the modified potential

        """
        return _pyAgrum.Potential_double_reorganize(self, *args)


    def putFirst(self, varname: 'PyObject *') -> "gum::Potential< double >":
        """
        putFirst(self, varname) -> Potential_double


        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable for which the index should be 0.

        Returns
        -------
        pyAgrum.Potential
          a reference to the modified potential

        Raises
        ------
        gum.InvalidArgument
          If the var is not in the potential 

        """
        return _pyAgrum.Potential_double_putFirst(self, varname)


    def margSumOut(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margSumOut(self, varnames) -> Potential_double


        Projection using sum as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to eliminate

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        Raises
        ------
        gum.InvalidArgument 
          If varnames contains only one variable that does not exist in the Potential

        """
        return _pyAgrum.Potential_double_margSumOut(self, varnames)


    def margProdOut(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margProdOut(self, varnames) -> Potential_double


        Projection using multiplication as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to eliminate

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        Raises
        ------
        gum.InvalidArgument
          If varnames contains only one variable that does not exist in the Potential

        """
        return _pyAgrum.Potential_double_margProdOut(self, varnames)


    def margMaxOut(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margMaxOut(self, varnames) -> Potential_double


        Projection using max as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to eliminate

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        Raises
        ------
        gum.InvalidArgument
          If varnames contains only one variable that does not exist in the Potential

        """
        return _pyAgrum.Potential_double_margMaxOut(self, varnames)


    def margMinOut(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margMinOut(self, varnames) -> Potential_double


        Projection using min as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to eliminate

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        Warnings
        --------
        InvalidArgument raised if varnames contains only one variable that does not exist in the Potential

        """
        return _pyAgrum.Potential_double_margMinOut(self, varnames)


    def margSumIn(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margSumIn(self, varnames) -> Potential_double


        Projection using sum as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to keep

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        """
        return _pyAgrum.Potential_double_margSumIn(self, varnames)


    def margProdIn(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margProdIn(self, varnames) -> Potential_double


        Projection using multiplication as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to keep

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        """
        return _pyAgrum.Potential_double_margProdIn(self, varnames)


    def margMaxIn(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margMaxIn(self, varnames) -> Potential_double


        Projection using max as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to keep

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        """
        return _pyAgrum.Potential_double_margMaxIn(self, varnames)


    def margMinIn(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margMinIn(self, varnames) -> Potential_double


        Projection using min as operation.

        Parameters
        ----------
        varnames : set
          the set of vars to keep

        Returns
        -------
        pyAgrum.Potential
          the projected Potential

        """
        return _pyAgrum.Potential_double_margMinIn(self, varnames)


    def __truediv__(self, *args) -> "gum::Potential< double >":
        """
        __truediv__(self, p2) -> Potential_double
        __truediv__(self, b) -> Potential_double
        """
        return _pyAgrum.Potential_double___truediv__(self, *args)


    def __div__(self, b: 'Potential_double') -> "gum::Potential< double >":
        """__div__(self, b) -> Potential_double"""
        return _pyAgrum.Potential_double___div__(self, b)


    def __eq__(self, *args) -> "bool":
        """
        __eq__(self, r) -> bool
        __eq__(self, b) -> bool
        """
        return _pyAgrum.Potential_double___eq__(self, *args)


    def __ne__(self, *args) -> "bool":
        """
        __ne__(self, r) -> bool
        __ne__(self, b) -> bool
        """
        return _pyAgrum.Potential_double___ne__(self, *args)



    def variablesSequence(self):
        """
        Returns
        -------
        list
            a list containing the sequence of variables
        """
        varlist = []
        for i in range(0, self.nbrDim()):
            varlist.append(self.variable(i))
        return varlist


    def __fill_distrib__(self):
      if not hasattr(self,'_notSync'):
        self._notSync=True

      if self._notSync:
        self._notSync=False
        self._var_names = []
        self._var_dims = []
        if self.empty():
            i = Instantiation(self)
            content = [self.get(i)]
            self.__distrib__ = numpy.array(content, dtype=numpy.float64) #M
            return

        content = []
        i = Instantiation(self)
        i.setFirst()
        while not i.end():
            content.append(self.get(i))
            i.inc()
        self.__distrib__ = numpy.array(content, dtype=numpy.float64) #M
        for var in self.variablesSequence():
            self._var_names.append(var.name())
            self._var_dims.append(var.domainSize())
        self._var_names.reverse()
        self._var_dims.reverse()
        self.__distrib__.shape = tuple(self._var_dims)



    def __indexfromdict__(self, id_dict):
        index = []
        for name, dim in zip(self._var_names, self._var_dims):
            if name in id_dict:
                id_value = id_dict[name]
                if isinstance(id_value, str):
    # id_value is a label of a LabelizedVar
                    i = self._var_names.index(name)
                    var = self.variable(len(self._var_names) - 1 - i)
                    id_value = var[id_value]
                if id_value >= dim:
                    raise IndexError("\"%s\" size is %d !"%(name, dim))
                index.append(id_value)
            else:
                index.append(slice(None, None, None)) # equivalent to ':'
        return tuple(index)



    def tolist(self):
        """
        Returns
        -------
        list
            the potential as a list
        """
        self.__fill_distrib__()
        return self.__distrib__.tolist()



    def toarray(self):
        """
        Returns
        -------
        array
            the potential as an array
        """
        return numpy.array(self.tolist())



    def __getitem__(self, id):
        self.__fill_distrib__()
        if self.empty():
            return self.__distrib__[0]

        if isinstance(id, dict):
            id_slice = self.__indexfromdict__(id)
        else:
            id_slice = id
        return self.__distrib__[id_slice]



    def __setitem__(self, id, value):
        self.__fill_distrib__()
        if self.empty():
            self.fill(value)
            self.__distrib__= numpy.array([value], dtype=numpy.float64) #M
            return

        if isinstance(id, dict):
            id_slice = self.__indexfromdict__(id)
        else:
            id_slice = id
        self.__distrib__[id_slice] = value
        self.fillWith(self.__distrib__.reshape(self.__distrib__.size).tolist())



    @property
    def var_names(self):
        """
        Returns
        -------
        list
            a list containing the name of each variables in the potential
        """
        self.__fill_distrib__()
        return self._var_names



    @property
    def var_dims(self):
        """
        Returns
        -------
        list
            a list containing the dimensions of each variables in the potential
        """
        self.__fill_distrib__()
        return self._var_dims



    def get(self, i: 'Instantiation') -> "double":
        """
        get(self, i) -> double


        Parameters
        ----------
        i : pyAgrum.Instantiation
          an Instantiation

        Returns
        -------
        double
          the value of the instantiation

        """
        return _pyAgrum.Potential_double_get(self, i)


    def set(self, i: 'Instantiation', value: 'double const &') -> "void":
        """
        set(self, i, value)


        Change the value pointed by i

        Parameters
        ----------
        i : pyAgrum.Instantiation
          The Instantiation to be changed
        value : double
          The new value of the Instantiation

        """
        val = _pyAgrum.Potential_double_set(self, i, value)

        self._notSync=True


        return val


    def empty(self) -> "bool":
        """
        empty(self) -> bool


        Returns
        -------
        bool
            Returns true if no variable is in the potential. 

        """
        return _pyAgrum.Potential_double_empty(self)


    def pos(self, v: 'DiscreteVariable') -> "gum::Idx":
        """
        pos(self, v) -> gum::Idx


        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable for which the index is returned.

        Returns
        -------
            Returns the index of a variable. 

        Raises
        ------
        gum.NotFound 
          If v is not in this multidimensional matrix. 

        """
        return _pyAgrum.Potential_double_pos(self, v)


    def contains(self, v: 'DiscreteVariable') -> "bool":
        """
        contains(self, v) -> bool


        Parameters
        ----------
        v : pyAgrum.Potential
            a DiscreteVariable.

        Returns
        -------
        bool
            True if the var is in the potential

        """
        return _pyAgrum.Potential_double_contains(self, v)


    def nbrDim(self) -> "gum::Idx":
        """
        nbrDim(self) -> gum::Idx


        Returns
        -------
        int
          the number of vars in the multidimensional container. 

        """
        return _pyAgrum.Potential_double_nbrDim(self)


    def variable(self, *args) -> "gum::DiscreteVariable const &":
        """
        variable(self, i) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable


        Parameters
        ----------
        i : int 
          An index of this multidimensional matrix.

        Returns
        -------
          the varible at the ith index 

        Raises
        ------
        gum.NotFound
          If i does not reference a variable in this multidimensional matrix. 

        """
        return _pyAgrum.Potential_double_variable(self, *args)


    def remove(self, var: 'DiscreteVariable') -> "void":
        """
        remove(self, var)


        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
            The variable to be removed

        Returns
        -------
        pyAgrum.Potential
          a reference to the modified potential

        Warnings
        --------
        IndexError raised if the var is not in the potential 

        """
        val = _pyAgrum.Potential_double_remove(self, var)

        self._notSync=True


        return val


    def add(self, v: 'DiscreteVariable') -> "void":
        """
        add(self, v)


        Add a discrete variable to the potential.

        Parameters
        ----------
        v : pyAgrum.DiscreteVariable
          the var to be added

        Raises
        ------
        gum.Error
          If DiscretizedVariable added with no Tick.

        """
        val = _pyAgrum.Potential_double_add(self, v)

        self._notSync=True
        return self


        return val

Potential_double_swigregister = _pyAgrum.Potential_double_swigregister
Potential_double_swigregister(Potential_double)

class IBayesNet_double(DAGmodel):
    """

    Abstract class used by BayesNet.

    """

    __swig_setmethods__ = {}
    for _s in [DAGmodel]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IBayesNet_double, name, value)
    __swig_getmethods__ = {}
    for _s in [DAGmodel]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IBayesNet_double, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __swig_destroy__ = _pyAgrum.delete_IBayesNet_double
    def __del__(self):
        return None

    def cpt(self, varId: 'gum::NodeId') -> "gum::Potential< double > const &":
        """
        cpt(self, varId) -> Potential_double


        Returns the CPT of a variable.

        Parameters
        ----------
        VarId : int
        	A variable's id in the pyAgrum.IBayesNet.
        name : str
        	A variable's name in the pyAgrum.IBayesNet.

        Returns
        -------
        pyAgrum.Potential
        	The variable's CPT. 

        Raises
        ------
        gum.NotFound 
        	If no variable's id matches varId. 

        """
        return _pyAgrum.IBayesNet_double_cpt(self, varId)


    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        """
        variableNodeMap(self) -> VariableNodeMap


        Returns
        -------
        pyAgrum.variableNodeMap
        	the variable node map

        """
        return _pyAgrum.IBayesNet_double_variableNodeMap(self)


    def variable(self, id: 'gum::NodeId') -> "gum::DiscreteVariable const &":
        """
        variable(self, id) -> DiscreteVariable


        Parameters
        ----------
        id : int
        	a variable's id
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.IBayesNet_double_variable(self, id)


    def nodeId(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        nodeId(self, var) -> gum::NodeId


        Parameters
        ----------
        var : pyAgrum.DiscreteVariable
        	a variable

        Returns
        -------
        int
        	the id of the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.IBayesNet_double_nodeId(self, var)


    def idFromName(self, name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(self, name) -> gum::NodeId


        Returns a variable's id given its name in the graph.

        Parameters
        ----------
        name : str
        	The variable's name from which the id is returned.

        Returns
        -------
        int :
        	The variable's node id.

        Raises
        ------
        gum.NotFound
        	If name does not match a variable in the graph

        """
        return _pyAgrum.IBayesNet_double_idFromName(self, name)


    def variableFromName(self, name: 'std::string const &') -> "gum::DiscreteVariable const &":
        """
        variableFromName(self, name) -> DiscreteVariable


        Parameters
        ----------
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.IBayesNet_double_variableFromName(self, name)


    def jointProbability(self, i: 'Instantiation') -> "double":
        """
        jointProbability(self, i) -> double


        Parameters
        ----------
        i : pyAgrum.instantiation
        	an instantiation of the variables

        Returns
        -------
        double
        	a parameter of the joint probability for the BayesNet

        Warnings
        --------
        a variable not present in the instantiation is assumed to be instantiated to 0

        """
        return _pyAgrum.IBayesNet_double_jointProbability(self, i)


    def log2JointProbability(self, i: 'Instantiation') -> "double":
        """
        log2JointProbability(self, i) -> double


        Parameters
        ----------
        i : pyAgrum.instantiation
        	an instantiation of the variables

        Returns
        -------
        double
        	a parameter of the log joint probability for the BayesNet

        Warnings
        --------
        a variable not present in the instantiation is assumed to be instantiated to 0

        """
        return _pyAgrum.IBayesNet_double_log2JointProbability(self, i)


    def __eq__(self, arg2: 'IBayesNet_double') -> "bool":
        """__eq__(self, arg2) -> bool"""
        return _pyAgrum.IBayesNet_double___eq__(self, arg2)


    def __ne__(self, arg2: 'IBayesNet_double') -> "bool":
        """__ne__(self, arg2) -> bool"""
        return _pyAgrum.IBayesNet_double___ne__(self, arg2)


    def dim(self) -> "gum::Size":
        """
        dim(self) -> gum::Size


        Returns the dimension (the number of free parameters) in this BayesNet.

        Returns
        -------
        int
        	the dimension of the BayesNet

        """
        return _pyAgrum.IBayesNet_double_dim(self)


    def maxVarDomainSize(self) -> "gum::Size":
        """
        maxVarDomainSize(self) -> gum::Size


        Returns
        -------
        int
        	the biggest domain size among the variables of the BayesNet

        """
        return _pyAgrum.IBayesNet_double_maxVarDomainSize(self)


    def minParam(self) -> "double":
        """
        minParam(self) -> double


        Returns
        -------
        double
            the smallest value in the CPTs of the IBayesNet

        """
        return _pyAgrum.IBayesNet_double_minParam(self)


    def maxParam(self) -> "double":
        """
        maxParam(self) -> double


        Returns
        -------
        double
            the biggest value in the CPTs of the BayesNet

        """
        return _pyAgrum.IBayesNet_double_maxParam(self)


    def minNonZeroParam(self) -> "double":
        """
        minNonZeroParam(self) -> double


        Returns
        -------
        double
            the smallest value (not equal to 0) in the CPTs of the IBayesNet

        """
        return _pyAgrum.IBayesNet_double_minNonZeroParam(self)


    def maxNonOneParam(self) -> "double":
        """
        maxNonOneParam(self) -> double


        Returns
        -------
        double
        	The biggest value (not equal to 1) in the CPTs of the BayesNet

        """
        return _pyAgrum.IBayesNet_double_maxNonOneParam(self)


    def toDot(self) -> "std::string":
        """
        toDot(self) -> std::string


        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.IBayesNet_double_toDot(self)


    def nodes(self) -> "PyObject *":
        """
        nodes(self) -> PyObject *


        Returns
        -------
        set
            the set of ids

        """
        return _pyAgrum.IBayesNet_double_nodes(self)


    def names(self) -> "PyObject *":
        """
        names(self) -> PyObject *


        Returns
        -------
        list
        	The names of the graph variables

        """
        return _pyAgrum.IBayesNet_double_names(self)


    def minimalCondSet(self, *args) -> "PyObject *":
        """
        minimalCondSet(self, target, soids) -> gum::NodeSet
        minimalCondSet(self, targets, soids) -> gum::NodeSet
        minimalCondSet(self, target, list) -> PyObject
        minimalCondSet(self, targets, list) -> PyObject *


        Returns, given one or many targets and a list of variables, the minimal set of those needed to calculate the target/targets.

        Parameters
        ----------
        target : int
        	The id of the target
        targets : list
        	The ids of the targets
        list : list
        	The list of available variables

        Returns
        -------
        Set
        	The minimal set of variables

        """
        return _pyAgrum.IBayesNet_double_minimalCondSet(self, *args)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.IBayesNet_double___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.IBayesNet_double___str__(self)


    def arcs(self) -> "PyObject *":
        """
        arcs(self) -> PyObject *


        Returns
        -------
        list
        	The lisf of arcs in the IBayesNet

        """
        return _pyAgrum.IBayesNet_double_arcs(self)


    def parents(self, id: 'gum::NodeId') -> "PyObject *":
        """
        parents(self, id) -> PyObject *


        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        Set
            the set of the parents ids.

        """
        return _pyAgrum.IBayesNet_double_parents(self, id)


    def children(self, id: 'gum::NodeId') -> "PyObject *":
        """
        children(self, id) -> PyObject *


        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.IBayesNet_double_children(self, id)

IBayesNet_double_swigregister = _pyAgrum.IBayesNet_double_swigregister
IBayesNet_double_swigregister(IBayesNet_double)

class BayesNet_double(IBayesNet_double):
    """

    BayesNet represents a Bayesian Network.

    Available constructors:
    	``BayesNet(name='') -> BayesNet``

    	``BayesNet(source) -> BayesNet``

    Parameters
    ----------
    name: str
    	the name of the Bayes Net (optional)
    source : pyAgrum.BayesNet
    	the Bayesian network to copy

    """

    __swig_setmethods__ = {}
    for _s in [IBayesNet_double]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BayesNet_double, name, value)
    __swig_getmethods__ = {}
    for _s in [IBayesNet_double]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BayesNet_double, name)

    def fastPrototype(dotlike: 'std::string const &', domainSize: 'gum::Size'=2) -> "gum::BayesNet< double >":
        """
        fastPrototype(dotlike, domainSize=2) -> BayesNet_double
        fastPrototype(dotlike) -> BayesNet_double


        Create a bn with a dotlike syntax : 'a->b->c;b->d;'.

        The domain size maybe specified using 'a[10]'.

        Note that if the dotlike string contains such a specification for an already defined variable, the first specification will be used.

        Parameters
        ----------
        dotlike : str
        	the string containing the specification
        domainSize : int
        	the default domain size for variables

        Returns
        -------
        pyAgrum.BayesNet
        	the resulting bayesian network 

        """
        return _pyAgrum.BayesNet_double_fastPrototype(dotlike, domainSize)

    fastPrototype = staticmethod(fastPrototype)
    __swig_destroy__ = _pyAgrum.delete_BayesNet_double
    def __del__(self):
        return None

    def __init__(self, *args):
        """
        __init__(self) -> BayesNet_double
        __init__(self, name) -> BayesNet_double
        __init__(self, source) -> BayesNet_double
        """
        this = _pyAgrum.new_BayesNet_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def cpt(self, *args) -> "gum::Potential< double > const &":
        """
        cpt(self, varId) -> Potential_double
        cpt(self, name) -> Potential_double


        Returns the CPT of a variable.

        Parameters
        ----------
        VarId : int
        	A variable's id in the pyAgrum.BayesNet.
        name : str
        	A variable's name in the pyAgrum.BayesNet.

        Returns
        -------
        pyAgrum.Potential
        	The variable's CPT. 

        Raises
        ------
        gum.NotFound
            If no variable's id matches varId.

        """
        val = _pyAgrum.BayesNet_double_cpt(self, *args)

        val.__fill_distrib__()


        return val


    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        """
        variableNodeMap(self) -> VariableNodeMap


        Returns
        -------
        pyAgrum.variableNodeMap
        	the variable node map

        """
        return _pyAgrum.BayesNet_double_variableNodeMap(self)


    def add(self, *args) -> "gum::NodeId":
        """
        add(self, var) -> gum::NodeId
        add(self, name, nbrmod) -> gum::NodeId
        add(self, var, aContent) -> gum::NodeId
        add(self, var, id) -> gum::NodeId
        add(self, var, aContent, id) -> gum::NodeId


        Add a variable to the pyAgrum.BayesNet. 

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added
        name : str 
        	the variable name
        nbrmod : int
        	the numbre of modalities for the new variable
        id : int
        	the variable forced id in the pyAgrum.BayesNet

        Returns
        -------
        int 
        	the id of the new node

        Raises
        ------
        gum.DuplicateLabel
            If variable.name() is already used in this pyAgrum.BayesNet.
        gum.NotAllowed
            If nbrmod<2
        gum.DuplicateElement
            If id is already used.

        """
        return _pyAgrum.BayesNet_double_add(self, *args)


    def erase(self, *args) -> "void":
        """
        erase(self, varId)
        erase(self, name)
        erase(self, var)


        Remove a variable from the gum::BayesNet.

        Removes the corresponding variable from the gum::BayesNet and from all of it's children gum::Potential.

        If no variable matches the given id, then nothing is done.

        Parameters
        ----------
        id : int
        	The variable's id to remove. 
        name : str
        	The variable's name to remove.
        var : pyAgrum.DiscreteVariable
        	A reference on the variable to remove. 

        """
        return _pyAgrum.BayesNet_double_erase(self, *args)


    def variable(self, *args) -> "gum::DiscreteVariable const &":
        """
        variable(self, id) -> DiscreteVariable
        variable(self, name) -> DiscreteVariable


        Parameters
        ----------
        id : int
        	a variable's id
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNet_double_variable(self, *args)


    def changeVariableName(self, *args) -> "void":
        """
        changeVariableName(self, id, new_name)
        changeVariableName(self, name, new_name)


        Changes a variable's name in the gum::BayesNet.

        This will change the gum::DiscreteVariable names in the gum::BayesNet.

        Parameters
        ----------
        new_name : str
        	the new name of the variable
        NodeId : int
        	the id of the node
        name : str
        	the name of the variable

        Raises
        ------
        gum.DuplicateLabel
            If new_name is already used in this BayesNet.
        gum.NotFound
            If no variable matches id.

        """
        return _pyAgrum.BayesNet_double_changeVariableName(self, *args)


    def changeVariableLabel(self, *args) -> "void":
        """
        changeVariableLabel(self, id, old_label, new_label)
        changeVariableLabel(self, name, old_label, new_label)


        change the label of the variable associated to nodeId to the new value.

        Parameters
        ----------
        id : int
        	the id of the node
        name : str
        	the name of the variable
        old_label : str
        	the new label
        new_label : str
        	the new label

        Raises
        ------
        gum.NotFound
            if id/name is not a variable or if old_label does not exist.

        """
        return _pyAgrum.BayesNet_double_changeVariableLabel(self, *args)


    def nodeId(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        nodeId(self, var) -> gum::NodeId


        Parameters
        ----------
        var : pyAgrum.DiscreteVariable
        	a variable

        Returns
        -------
        int
        	the id of the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNet_double_nodeId(self, var)


    def idFromName(self, name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(self, name) -> gum::NodeId


        Returns a variable's id given its name in the graph.

        Parameters
        ----------
        name : str
        	The variable's name from which the id is returned.

        Returns
        -------
        int :
        	The variable's node id.

        Raises
        ------
        gum.NotFound
        	If name does not match a variable in the graph

        """
        return _pyAgrum.BayesNet_double_idFromName(self, name)


    def variableFromName(self, name: 'std::string const &') -> "gum::DiscreteVariable const &":
        """
        variableFromName(self, name) -> DiscreteVariable


        Parameters
        ----------
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the graph does not contain the variable

        """
        return _pyAgrum.BayesNet_double_variableFromName(self, name)


    def addArc(self, *args) -> "void":
        """
        addArc(self, tail, head)
        addArc(self, tail, head)


        Add an arc in the BN, and update arc.head's CPT.

        Parameters
        ----------
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        Raises
        ------
        gum.InvalidEdge
            If arc.tail and/or arc.head are not in the BN.

        """
        return _pyAgrum.BayesNet_double_addArc(self, *args)


    def eraseArc(self, *args) -> "void":
        """
        eraseArc(self, arc)
        eraseArc(self, tail, head)
        eraseArc(self, tail, head)


        Removes an arc in the BN, and update head's CTP.

        If (tail, head) doesn't exist, the nothing happens.

        Parameters
        ----------
        arc : pyAgrum.Arc 
        	The arc to be removed.
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BayesNet_double_eraseArc(self, *args)


    def beginTopologyTransformation(self) -> "void":
        """
        beginTopologyTransformation(self)


        When inserting/removing arcs, node CPTs change their dimension with a cost in time.
        begin Multiple Change for all CPTs
        These functions delay the CPTs change to be done just once at the end of a sequence of topology modification, begins a sequence of insertions/deletions of arcs without changing the dimensions of the CPTs.

        """
        return _pyAgrum.BayesNet_double_beginTopologyTransformation(self)


    def endTopologyTransformation(self) -> "void":
        """
        endTopologyTransformation(self)


        Terminates a sequence of insertions/deletions of arcs by adjusting all CPTs dimensions.
        End Multiple Change for all CPTs.

        Returns
        -------
        pyAgrum.BayesNet

        """
        return _pyAgrum.BayesNet_double_endTopologyTransformation(self)


    def reverseArc(self, *args) -> "void":
        """
        reverseArc(self, tail, head)
        reverseArc(self, tail, head)
        reverseArc(self, arc)


        Reverses an arc while preserving the same joint distribution. 

        Parameters
        ----------
        tail
        	(int) the id of the tail variable
        head
        	(int) the id of the head variable
        tail
        	(str) the name of the tail variable
        head
        	(str) the name of the head variable
        arc : pyAgrum.Arc
        	an arc 

        Raises
        ------
        gum.InvalidArc
            If the arc does not exsit or if its reversal would induce a directed cycle.

        """
        return _pyAgrum.BayesNet_double_reverseArc(self, *args)


    def addNoisyOR(self, *args) -> "gum::NodeId":
        """
        addNoisyOR(self, var, external_weight) -> gum::NodeId
        addNoisyOR(self, var, external_weight, id) -> gum::NodeId


        Add a variable, it's associate node and a noisyOR implementation.

        Since it seems that the 'classical' noisyOR is the Compound noisyOR, we keep the addNoisyOR as an alias for addNoisyORCompound.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable. 

        Raises
        --------
        gum.DuplicateElement
            If id is already used

        """
        return _pyAgrum.BayesNet_double_addNoisyOR(self, *args)


    def addNoisyORNet(self, *args) -> "gum::NodeId":
        """
        addNoisyORNet(self, var, external_weight) -> gum::NodeId
        addNoisyORNet(self, var, external_weight, id) -> gum::NodeId


        Add a variable, its associate node and a noisyOR implementation.

        Since it seems that the 'classical' noisyOR is the Compound noisyOR, we keep the addNoisyOR as an alias for addNoisyORCompound.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable.

        """
        return _pyAgrum.BayesNet_double_addNoisyORNet(self, *args)


    def addNoisyORCompound(self, *args) -> "gum::NodeId":
        """
        addNoisyORCompound(self, var, external_weight) -> gum::NodeId
        addNoisyORCompound(self, var, external_weight, id) -> gum::NodeId


        Add a variable, it's associate node and a noisyOR implementation.

        Since it seems that the 'classical' noisyOR is the Compound noisyOR, we keep the addNoisyOR as an alias for addNoisyORCompound.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable.

        Raises
        --------
        gum.DuplicateElement
            If id is already used

        """
        return _pyAgrum.BayesNet_double_addNoisyORCompound(self, *args)


    def addNoisyAND(self, *args) -> "gum::NodeId":
        """
        addNoisyAND(self, var, external_weight, id) -> gum::NodeId
        addNoisyAND(self, var, external_weight) -> gum::NodeId


        Add a variable, its associate node and a noisyAND implementation.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable.

        Raises
        ------
        gum.DuplicateElement
            If id is already used

        """
        return _pyAgrum.BayesNet_double_addNoisyAND(self, *args)


    def addLogit(self, *args) -> "gum::NodeId":
        """
        addLogit(self, var, external_weight, id) -> gum::NodeId
        addLogit(self, var, external_weight) -> gum::NodeId


        Add a variable, its associate node and a Logit implementation.

        (The id of the new variable can be automatically generated.)

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy
        externalWeight : double
        	the added external weight
        id : int
        	The proposed id for the variable.

        Returns
        -------
        int
        	the id of the added variable.

        Raises
        ------
        gum.DuplicateElement
            If id is already used

        """
        return _pyAgrum.BayesNet_double_addLogit(self, *args)


    def addOR(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        addOR(self, var) -> gum::NodeId


        Add a variable, it's associate node and an OR implementation.

        The id of the new variable is automatically generated.

        Warnings
        --------
        	If parents are not boolean, all value>1 is True

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy

        Returns
        -------
        int
        	the id of the added variable.

        Raises
        ------
        gum.SizeError
            If variable.domainSize()>2

        """
        return _pyAgrum.BayesNet_double_addOR(self, var)


    def addAND(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        addAND(self, var) -> gum::NodeId


        Add a variable, it's associate node and an AND implementation.

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy.

        Returns
        -------
        int
        	the id of the added variable. 

        Raises
        ------
        gum.SizeError
            If variable.domainSize()>2

        """
        return _pyAgrum.BayesNet_double_addAND(self, var)


    def addAMPLITUDE(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        addAMPLITUDE(self, var) -> gum::NodeId


        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_double_addAMPLITUDE(self, var)


    def addCOUNT(self, var: 'DiscreteVariable', value: 'gum::Idx'=1) -> "gum::NodeId":
        """
        addCOUNT(self, var, value=1) -> gum::NodeId
        addCOUNT(self, var) -> gum::NodeId


        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_double_addCOUNT(self, var, value)


    def addEXISTS(self, var: 'DiscreteVariable', value: 'gum::Idx'=1) -> "gum::NodeId":
        """
        addEXISTS(self, var, value=1) -> gum::NodeId
        addEXISTS(self, var) -> gum::NodeId


        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_double_addEXISTS(self, var, value)


    def addFORALL(self, var: 'DiscreteVariable', value: 'gum::Idx'=1) -> "gum::NodeId":
        """
        addFORALL(self, var, value=1) -> gum::NodeId
        addFORALL(self, var) -> gum::NodeId


        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added variable.

        """
        return _pyAgrum.BayesNet_double_addFORALL(self, var, value)


    def addMAX(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        addMAX(self, var) -> gum::NodeId


        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_double_addMAX(self, var)


    def addMEDIAN(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        addMEDIAN(self, var) -> gum::NodeId


        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_double_addMEDIAN(self, var)


    def addMIN(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        addMIN(self, var) -> gum::NodeId


        Others aggregators

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable to be added

        Returns
        -------
        int
        	the id of the added value

        """
        return _pyAgrum.BayesNet_double_addMIN(self, var)


    def addWeightedArc(self, *args) -> "void":
        """
        addWeightedArc(self, tail, head, causalWeight)
        addWeightedArc(self, tail, head, causalWeight)


        Add an arc in the BN, and update arc.head's CPT.

        Parameters
        ----------
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)
        causalWeight : double
        	the added causal weight

        Raises
        ------
        gum.InvalidArc
            If arc.tail and/or arc.head are not in the BN.
        gum.InvalidArc
            If variable in arc.head is not a NoisyOR variable.


        """
        return _pyAgrum.BayesNet_double_addWeightedArc(self, *args)


    def generateCPTs(self) -> "void":
        """
        generateCPTs(self)


        Randomly generates CPTs for a given structure.

        """
        return _pyAgrum.BayesNet_double_generateCPTs(self)


    def generateCPT(self, *args) -> "void":
        """
        generateCPT(self, node)
        generateCPT(self, name)


        Randomly generate CPT for a given node in a given structure.

        Parameters
        ----------
        node : int
        	The variable's id.
        name : str 
        	The variable's name.

        """
        return _pyAgrum.BayesNet_double_generateCPT(self, *args)


    def changePotential(self, *args) -> "void":
        """
        changePotential(self, id, newPot)
        changePotential(self, name, newPot)


        change the CPT associated to nodeId to newPot delete the old CPT associated to nodeId.

        Parameters
        ----------
        newPot : pyAgrum.Potential
        	the new potential
        NodeId : int
        	the id of the node
        name : str
        	the name of the variable

        Raises
        ------
        gum.NotAllowed
            If newPot has not the same signature as __probaMap[NodeId]

        """
        return _pyAgrum.BayesNet_double_changePotential(self, *args)


    def dag(self) -> "gum::DAG const &":
        """
        dag(self) -> DAG


        Returns
        -------
        pyAgrum.DAG
        	a constant reference to the dag of this BayesNet.

        """
        return _pyAgrum.BayesNet_double_dag(self)


    def size(self) -> "gum::Size":
        """
        size(self) -> gum::Size


        Returns
        -------
        int
            the number of nodes in the graph

        """
        return _pyAgrum.BayesNet_double_size(self)


    def log10DomainSize(self) -> "double":
        """
        log10DomainSize(self) -> double


        Returns
        -------
        double
        	The log10 domain size of the joint probability for the model.

        """
        return _pyAgrum.BayesNet_double_log10DomainSize(self)


    def addStructureListener(self,whenNodeAdded=None,whenNodeDeleted=None,whenArcAdded=None,whenArcDeleted=None):
        """
        Add the listeners in parameters to the list of existing ones.

        Parameters
        ----------
        whenNodeAdded : lambda expression
          a function for when a node is added
        whenNodeDeleted : lambda expression
          a function for when a node is removed
        whenArcAdded : lambda expression
          a function for when an arc is added
        whenArcDeleted : lambda expression
          a function for when an arc is removed
        """
        if [whenNodeAdded,whenNodeDeleted,whenArcAdded,whenArcDeleted]==[None,None,None,None]:
          return

        if not hasattr(self,"_listeners"):
          self._listeners=[]

        nl = PythonBNListener(self.dag(), self.variableNodeMap())
        if whenNodeAdded is not None:
          nl.setWhenNodeAdded(whenNodeAdded)
        if whenNodeDeleted is not None:
          nl.setWhenNodeDeleted(whenNodeDeleted)
        if whenArcAdded is not None:
          nl.setWhenArcAdded(whenArcAdded)
        if whenArcDeleted is not None:
          nl.setWhenArcDeleted(whenArcDeleted)

        self._listeners.append(nl)


    def loadBIF(self, *args) -> "std::string":
        """
        loadBIF(self, name, l) -> std::string
        loadBIF(self, name) -> std::string


        Load a BIF file.

        Parameters
        ----------
        name : str
        	the file's name
        l : list
        	list of functions to execute

        Raises
        --------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_double_loadBIF(self, *args)


    def saveBIF(self, name: 'std::string') -> "void":
        """
        saveBIF(self, name)


        Save the BayesNet in a BIF file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_double_saveBIF(self, name)


    def loadDSL(self, *args) -> "std::string":
        """
        loadDSL(self, name, l) -> std::string
        loadDSL(self, name) -> std::string


        Load a DSL file.

        Parameters
        ----------
        name : str
        	the file's name
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_double_loadDSL(self, *args)


    def saveDSL(self, name: 'std::string') -> "void":
        """
        saveDSL(self, name)


        Save the BayesNet in a DSL file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_double_saveDSL(self, name)


    def loadNET(self, *args) -> "std::string":
        """
        loadNET(self, name, l) -> std::string
        loadNET(self, name) -> std::string


        Load a NET file.

        Parameters
        ----------
        name : str
        	the name's file
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_double_loadNET(self, *args)


    def saveNET(self, name: 'std::string') -> "void":
        """
        saveNET(self, name)


        Save the BayesNet in a NET file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_double_saveNET(self, name)


    def loadO3PRM(self, *args) -> "std::string":
        """
        loadO3PRM(self, name, system, classpath, l) -> std::string
        loadO3PRM(self, name, system, classpath) -> std::string
        loadO3PRM(self, name, system) -> std::string
        loadO3PRM(self, name) -> std::string


        Load an O3PRM file.

        Warnings
        --------
        The O3PRM language is the only language allowing to manipulate not only DiscretizedVariable but also RangeVariable and LabelizedVariable.

        Parameters
        ----------
        name : str
        	the file's name
        system : str
        	the system's name
        classpath : str
        	the classpath
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_double_loadO3PRM(self, *args)


    def saveO3PRM(self, name: 'std::string') -> "void":
        """
        saveO3PRM(self, name)


        Save the BayesNet in an O3PRM file.

        Warnings
        --------
        The O3PRM language is the only language allowing to manipulate not only DiscretizedVariable but also RangeVariable and LabelizedVariable.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_double_saveO3PRM(self, name)


    def loadBIFXML(self, *args) -> "std::string":
        """
        loadBIFXML(self, name, l) -> std::string
        loadBIFXML(self, name) -> std::string


        Load a BIFXML file.

        Parameters
        ----------
        name : str
        	the name's file
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_double_loadBIFXML(self, *args)


    def saveBIFXML(self, name: 'std::string') -> "void":
        """
        saveBIFXML(self, name)


        Save the BayesNet in a BIFXML file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_double_saveBIFXML(self, name)


    def loadUAI(self, *args) -> "std::string":
        """
        loadUAI(self, name, l) -> std::string
        loadUAI(self, name) -> std::string


        Load an UAI file.

        Parameters
        ----------
        name : str
        	the name's file
        l : list
        	list of functions to execute

        Raises
        ------
        gum.IOError
            If file not found
        gum.FatalError
            If file is not valid

        """
        return _pyAgrum.BayesNet_double_loadUAI(self, *args)


    def saveUAI(self, name: 'std::string') -> "void":
        """
        saveUAI(self, name)


        Save the BayesNet in an UAI file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.BayesNet_double_saveUAI(self, name)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.BayesNet_double___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.BayesNet_double___str__(self)

BayesNet_double_swigregister = _pyAgrum.BayesNet_double_swigregister
BayesNet_double_swigregister(BayesNet_double)

def BayesNet_double_fastPrototype(dotlike: 'std::string const &', domainSize: 'gum::Size'=2) -> "gum::BayesNet< double >":
    """
    fastPrototype(dotlike, domainSize=2) -> BayesNet_double
    BayesNet_double_fastPrototype(dotlike) -> BayesNet_double


    Create a bn with a dotlike syntax : 'a->b->c;b->d;'.

    The domain size maybe specified using 'a[10]'.

    Note that if the dotlike string contains such a specification for an already defined variable, the first specification will be used.

    Parameters
    ----------
    dotlike : str
    	the string containing the specification
    domainSize : int
    	the default domain size for variables

    Returns
    -------
    pyAgrum.BayesNet
    	the resulting bayesian network 

    """
    return _pyAgrum.BayesNet_double_fastPrototype(dotlike, domainSize)

class BayesNetInference_double(_object):
    """Proxy of C++ gum::BayesNetInference< double > class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BayesNetInference_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BayesNetInference_double, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    StateOfInference_OutdatedBNStructure = _pyAgrum.BayesNetInference_double_StateOfInference_OutdatedBNStructure
    StateOfInference_OutdatedBNPotentials = _pyAgrum.BayesNetInference_double_StateOfInference_OutdatedBNPotentials
    StateOfInference_ReadyForInference = _pyAgrum.BayesNetInference_double_StateOfInference_ReadyForInference
    StateOfInference_Done = _pyAgrum.BayesNetInference_double_StateOfInference_Done
    __swig_destroy__ = _pyAgrum.delete_BayesNetInference_double
    def __del__(self):
        return None

    def setBN(self, bn: 'IBayesNet_double') -> "void":
        """setBN(self, bn)"""
        return _pyAgrum.BayesNetInference_double_setBN(self, bn)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """BN(self) -> IBayesNet_double"""
        return _pyAgrum.BayesNetInference_double_BN(self)


    def domainSizes(self) -> "gum::NodeProperty< gum::Size > const &":
        """domainSizes(self) -> gum::NodeProperty< gum::Size > const &"""
        return _pyAgrum.BayesNetInference_double_domainSizes(self)


    def isInferenceReady(self) -> "bool":
        """isInferenceReady(self) -> bool"""
        return _pyAgrum.BayesNetInference_double_isInferenceReady(self)


    def isInferenceOutdatedBNStructure(self) -> "bool":
        """isInferenceOutdatedBNStructure(self) -> bool"""
        return _pyAgrum.BayesNetInference_double_isInferenceOutdatedBNStructure(self)


    def isInferenceOutdatedBNPotentials(self) -> "bool":
        """isInferenceOutdatedBNPotentials(self) -> bool"""
        return _pyAgrum.BayesNetInference_double_isInferenceOutdatedBNPotentials(self)


    def isInferenceDone(self) -> "bool":
        """isInferenceDone(self) -> bool"""
        return _pyAgrum.BayesNetInference_double_isInferenceDone(self)


    def isDone(self) -> "bool":
        """isDone(self) -> bool"""
        return _pyAgrum.BayesNetInference_double_isDone(self)


    def prepareInference(self) -> "void":
        """prepareInference(self)"""
        return _pyAgrum.BayesNetInference_double_prepareInference(self)


    def makeInference(self) -> "void":
        """makeInference(self)"""
        return _pyAgrum.BayesNetInference_double_makeInference(self)


    def clear(self) -> "void":
        """clear(self)"""
        return _pyAgrum.BayesNetInference_double_clear(self)


    def state(self) -> "gum::BayesNetInference< double >::StateOfInference":
        """state(self) -> gum::BayesNetInference< double >::StateOfInference"""
        return _pyAgrum.BayesNetInference_double_state(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, label)
        addEvidence(self, nodeName, label)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)
        addEvidence(self, pot)
        addEvidence(self, pot)
        """
        return _pyAgrum.BayesNetInference_double_addEvidence(self, *args)


    def addSetOfEvidence(self, potset: 'gum::Set< gum::Potential< double > const * > const &') -> "void":
        """addSetOfEvidence(self, potset)"""
        return _pyAgrum.BayesNetInference_double_addSetOfEvidence(self, potset)


    def addListOfEvidence(self, potlist: 'gum::List< gum::Potential< double > const * > const &') -> "void":
        """addListOfEvidence(self, potlist)"""
        return _pyAgrum.BayesNetInference_double_addListOfEvidence(self, potlist)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, label)
        chgEvidence(self, nodeName, label)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)
        chgEvidence(self, pot)
        """
        return _pyAgrum.BayesNetInference_double_chgEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """eraseAllEvidence(self)"""
        return _pyAgrum.BayesNetInference_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)
        """
        return _pyAgrum.BayesNetInference_double_eraseEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self) -> bool
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool
        """
        return _pyAgrum.BayesNetInference_double_hasEvidence(self, *args)


    def hasHardEvidence(self, *args) -> "bool":
        """
        hasHardEvidence(self, id) -> bool
        hasHardEvidence(self, nodeName) -> bool
        """
        return _pyAgrum.BayesNetInference_double_hasHardEvidence(self, *args)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool
        """
        return _pyAgrum.BayesNetInference_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """nbrEvidence(self) -> gum::Size"""
        return _pyAgrum.BayesNetInference_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """nbrHardEvidence(self) -> gum::Size"""
        return _pyAgrum.BayesNetInference_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """nbrSoftEvidence(self) -> gum::Size"""
        return _pyAgrum.BayesNetInference_double_nbrSoftEvidence(self)


    def evidence(self) -> "gum::NodeProperty< gum::Potential< double > const * > const &":
        """evidence(self) -> gum::NodeProperty< gum::Potential< double > const * > const &"""
        return _pyAgrum.BayesNetInference_double_evidence(self)


    def softEvidenceNodes(self) -> "gum::NodeSet const &":
        """softEvidenceNodes(self) -> gum::NodeSet const &"""
        return _pyAgrum.BayesNetInference_double_softEvidenceNodes(self)


    def hardEvidenceNodes(self) -> "gum::NodeSet const &":
        """hardEvidenceNodes(self) -> gum::NodeSet const &"""
        return _pyAgrum.BayesNetInference_double_hardEvidenceNodes(self)


    def hardEvidence(self) -> "gum::NodeProperty< gum::Idx > const &":
        """hardEvidence(self) -> gum::NodeProperty< gum::Idx > const &"""
        return _pyAgrum.BayesNetInference_double_hardEvidence(self)

BayesNetInference_double_swigregister = _pyAgrum.BayesNetInference_double_swigregister
BayesNetInference_double_swigregister(BayesNetInference_double)

class LazyPropagation_double(_object):
    """

    Class used for Lazy Propagation

    Available constructors:
    	``LazyPropagation(bn) -> LazyPropagation``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LazyPropagation_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LazyPropagation_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, BN, arg3, arg4, use_binary_join_tree=True) -> LazyPropagation_double
        __init__(self, BN, arg3, arg4) -> LazyPropagation_double
        __init__(self, BN, arg3) -> LazyPropagation_double
        __init__(self, BN) -> LazyPropagation_double
        """
        this = _pyAgrum.new_LazyPropagation_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=args[0]#BN



    __swig_destroy__ = _pyAgrum.delete_LazyPropagation_double
    def __del__(self):
        return None

    def setTriangulation(self, new_triangulation: 'Triangulation') -> "void":
        """setTriangulation(self, new_triangulation)"""
        return _pyAgrum.LazyPropagation_double_setTriangulation(self, new_triangulation)


    def setRelevantPotentialsFinderType(self, type: 'gum::RelevantPotentialsFinderType') -> "void":
        """
        setRelevantPotentialsFinderType(self, type)


        sets how we determine the relevant potentials to combine

        When a clique sends a message to a separator, it first constitute the set of the potentials it contains and of the potentials contained in the messages it received. If RelevantPotentialsFinderType = FIND_ALL, all these potentials are combined and projected to produce the message sent to the separator. If RelevantPotentialsFinderType = DSEP_BAYESBALL_NODES, then only the set of potentials d-connected to the variables of the separator are kept for combination and projection.

        0 = FIND_ALL
        1 = DSEP_BAYESBALL_NODES
        2 = DSEP_BAYESBALL_POTENTIALS
        3 = DSEP_KOLLER_FRIEDMAN_2009

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.LazyPropagation_double_setRelevantPotentialsFinderType(self, type)


    def setFindBarrenNodesType(self, type: 'gum::FindBarrenNodesType') -> "void":
        """
        setFindBarrenNodesType(self, type)


        sets how we determine barren nodes

        Barren nodes are unnecessary for probability inference, so they can be safely discarded in this case (type = FIND_BARREN_NODES). This speeds-up inference. However, there are some cases in which we do not want to remove barren nodes, typically when we want to answer queries such as Most Probable Explanations (MPE).

        0 = FIND_NO_BARREN_NODES
        1 = FIND_BARREN_NODES

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.LazyPropagation_double_setFindBarrenNodesType(self, type)


    def joinTree(self) -> "gum::JoinTree const *":
        """
        joinTree(self) -> CliqueGraph


        Returns
        -------
        pyAgrum.CliqueGraph
          the current join tree used

        """
        return _pyAgrum.LazyPropagation_double_joinTree(self)


    def junctionTree(self) -> "gum::JunctionTree const *":
        """
        junctionTree(self) -> CliqueGraph


        Returns
        -------
        pyAgrum.CliqueGraph
          the current junction tree 

        """
        return _pyAgrum.LazyPropagation_double_junctionTree(self)


    def evidenceProbability(self) -> "double":
        """
        evidenceProbability(self) -> double


        Returns
        -------
        double
          the probability of evidence

        """
        return _pyAgrum.LazyPropagation_double_evidenceProbability(self)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.LazyPropagation_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.LazyPropagation_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LazyPropagation_double_targets(self)


    def jointPosterior(self, list: 'PyObject *') -> "gum::Potential< double >":
        """
        jointPosterior(self, list) -> Potential_double


        Compute the joint posterior of a set of nodes.

        Parameters
        ----------
        list : 
          the list of nodes whose posterior joint probability is wanted

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior joint probability of the set of nodes. 

        Raises
        ------
        gum.UndefinedElement 
          If an element of nodes is not in targets

        """
        return _pyAgrum.LazyPropagation_double_jointPosterior(self, list)


    def addJointTarget(self, list: 'PyObject *') -> "void":
        """
        addJointTarget(self, list)


        Add a list of nodes as a new joint target. As a collateral effect, every node is added as a marginal target.

        Parameters
        ----------
        list
          a list of names of nodes

        Raises
        ------
        gum.UndefinedElement
          If some node(s) do not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_addJointTarget(self, list)


    def eraseJointTarget(self, list: 'PyObject *') -> "void":
        """
        eraseJointTarget(self, list)


        Remove, if existing, the joint target.

        Parameters
        ----------
        list
          a list of names or Ids of nodes

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_eraseJointTarget(self, list)


    def isJointTarget(self, list: 'PyObject *') -> "bool":
        """
        isJointTarget(self, list) -> bool


        Parameters
        ----------
        list
          a list of nodes ids or names.

        Returns
        -------
        bool
          True if target is a joint target. 

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_isJointTarget(self, list)


    def jointTargets(self) -> "PyObject *":
        """
        jointTargets(self) -> PyObject *


        Returns
        -------
        list
          the list of target sets 

        """
        return _pyAgrum.LazyPropagation_double_jointTargets(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.LazyPropagation_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LazyPropagation_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LazyPropagation_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LazyPropagation_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.LazyPropagation_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.LazyPropagation_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.LazyPropagation_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LazyPropagation_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LazyPropagation_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LazyPropagation_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LazyPropagation_double_evidenceImpact(self, *args)


    def eraseAllJointTargets(self) -> "void":
        """
        eraseAllJointTargets(self)


        Clear all previously defined joint targets.

        """
        return _pyAgrum.LazyPropagation_double_eraseAllJointTargets(self)


    def eraseAllMarginalTargets(self) -> "void":
        """
        eraseAllMarginalTargets(self)


        Clear all the previously defined marginal targets.

        """
        return _pyAgrum.LazyPropagation_double_eraseAllMarginalTargets(self)


    def nbrJointTargets(self) -> "gum::Size":
        """
        nbrJointTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of joint targets

        """
        return _pyAgrum.LazyPropagation_double_nbrJointTargets(self)


    def I(self, X: 'gum::NodeId const', Y: 'gum::NodeId const') -> "double":
        """
        I(self, X, Y) -> double


        Parameters
        ----------
        X : int
          a node Id
        Y : int
          another node Id

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LazyPropagation_double_I(self, X, Y)


    def VI(self, X: 'gum::NodeId const', Y: 'gum::NodeId const') -> "double":
        """
        VI(self, X, Y) -> double


        Parameters
        ----------
        X : int
          a node Id
        Y : int
          another node Id

        Returns
        -------
        double
          variation of information between X and Y

        """
        return _pyAgrum.LazyPropagation_double_VI(self, X, Y)


    def evidenceJointImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceJointImpact(self, targets, evs) -> Potential_double
        evidenceJointImpact(self, targets, evs) -> Potential_double


        Create a pyAgrum.Potential for P(joint targets|evs) (for all instanciation of targets and evs) 

        Parameters
        ----------
        targets :
          (int) a node Id
        targets :
          (str) a node name
        evs : set
          a set of nodes ids or names.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(target|evs)

        Raises
        ------
        gum.Exception
          If some evidene entered into the Bayes net are incompatible (their joint proba = 0)

        """
        return _pyAgrum.LazyPropagation_double_evidenceJointImpact(self, *args)

LazyPropagation_double_swigregister = _pyAgrum.LazyPropagation_double_swigregister
LazyPropagation_double_swigregister(LazyPropagation_double)

class ShaferShenoyInference_double(_object):
    """

    Class used for Shafer-Shenoy inferences.

    Available constructors:
    	``ShaferShenoyInference(bn) -> ShaferShenoyInference``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ShaferShenoyInference_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ShaferShenoyInference_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, BN, barren_type, use_binary_join_tree=True) -> ShaferShenoyInference_double
        __init__(self, BN, barren_type) -> ShaferShenoyInference_double
        __init__(self, BN) -> ShaferShenoyInference_double
        """
        this = _pyAgrum.new_ShaferShenoyInference_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=args[0]#BN



    __swig_destroy__ = _pyAgrum.delete_ShaferShenoyInference_double
    def __del__(self):
        return None

    def setTriangulation(self, new_triangulation: 'Triangulation') -> "void":
        """setTriangulation(self, new_triangulation)"""
        return _pyAgrum.ShaferShenoyInference_double_setTriangulation(self, new_triangulation)


    def setFindBarrenNodesType(self, type: 'gum::FindBarrenNodesType') -> "void":
        """
        setFindBarrenNodesType(self, type)


        sets how we determine barren nodes

        Barren nodes are unnecessary for probability inference, so they can be safely discarded in this case (type = FIND_BARREN_NODES). This speeds-up inference. However, there are some cases in which we do not want to remove barren nodes, typically when we want to answer queries such as Most Probable Explanations (MPE).

        0 = FIND_NO_BARREN_NODES
        1 = FIND_BARREN_NODES

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.ShaferShenoyInference_double_setFindBarrenNodesType(self, type)


    def joinTree(self) -> "gum::JoinTree const *":
        """
        joinTree(self) -> CliqueGraph


        Returns
        -------
        pyAgrum.CliqueGraph
          the current join tree used

        """
        return _pyAgrum.ShaferShenoyInference_double_joinTree(self)


    def junctionTree(self) -> "gum::JunctionTree const *":
        """
        junctionTree(self) -> CliqueGraph


        Returns
        -------
        pyAgrum.CliqueGraph
          the current junction tree 

        """
        return _pyAgrum.ShaferShenoyInference_double_junctionTree(self)


    def evidenceProbability(self) -> "double":
        """
        evidenceProbability(self) -> double


        Returns
        -------
        double
          the probability of evidence

        """
        return _pyAgrum.ShaferShenoyInference_double_evidenceProbability(self)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.ShaferShenoyInference_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.ShaferShenoyInference_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.ShaferShenoyInference_double_targets(self)


    def jointPosterior(self, list: 'PyObject *') -> "gum::Potential< double >":
        """
        jointPosterior(self, list) -> Potential_double


        Compute the joint posterior of a set of nodes.

        Parameters
        ----------
        list : 
          the list of nodes whose posterior joint probability is wanted

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior joint probability of the set of nodes. 

        Raises
        ------
        gum.UndefinedElement 
          If an element of nodes is not in targets

        """
        return _pyAgrum.ShaferShenoyInference_double_jointPosterior(self, list)


    def addJointTarget(self, list: 'PyObject *') -> "void":
        """
        addJointTarget(self, list)


        Add a list of nodes as a new joint target. As a collateral effect, every node is added as a marginal target.

        Parameters
        ----------
        list
          a list of names of nodes

        Raises
        ------
        gum.UndefinedElement
          If some node(s) do not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_addJointTarget(self, list)


    def eraseJointTarget(self, list: 'PyObject *') -> "void":
        """
        eraseJointTarget(self, list)


        Remove, if existing, the joint target.

        Parameters
        ----------
        list
          a list of names or Ids of nodes

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_eraseJointTarget(self, list)


    def isJointTarget(self, list: 'PyObject *') -> "bool":
        """
        isJointTarget(self, list) -> bool


        Parameters
        ----------
        list
          a list of nodes ids or names.

        Returns
        -------
        bool
          True if target is a joint target. 

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_isJointTarget(self, list)


    def jointTargets(self) -> "PyObject *":
        """
        jointTargets(self) -> PyObject *


        Returns
        -------
        list
          the list of target sets 

        """
        return _pyAgrum.ShaferShenoyInference_double_jointTargets(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.ShaferShenoyInference_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ShaferShenoyInference_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.ShaferShenoyInference_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.ShaferShenoyInference_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.ShaferShenoyInference_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.ShaferShenoyInference_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.ShaferShenoyInference_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ShaferShenoyInference_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.ShaferShenoyInference_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.ShaferShenoyInference_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.ShaferShenoyInference_double_evidenceImpact(self, *args)


    def eraseAllJointTargets(self) -> "void":
        """
        eraseAllJointTargets(self)


        Clear all previously defined joint targets.

        """
        return _pyAgrum.ShaferShenoyInference_double_eraseAllJointTargets(self)


    def eraseAllMarginalTargets(self) -> "void":
        """
        eraseAllMarginalTargets(self)


        Clear all the previously defined marginal targets.

        """
        return _pyAgrum.ShaferShenoyInference_double_eraseAllMarginalTargets(self)


    def nbrJointTargets(self) -> "gum::Size":
        """
        nbrJointTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of joint targets

        """
        return _pyAgrum.ShaferShenoyInference_double_nbrJointTargets(self)


    def I(self, X: 'gum::NodeId const', Y: 'gum::NodeId const') -> "double":
        """
        I(self, X, Y) -> double


        Parameters
        ----------
        X : int
          a node Id
        Y : int
          another node Id

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.ShaferShenoyInference_double_I(self, X, Y)


    def VI(self, X: 'gum::NodeId const', Y: 'gum::NodeId const') -> "double":
        """
        VI(self, X, Y) -> double


        Parameters
        ----------
        X : int
          a node Id
        Y : int
          another node Id

        Returns
        -------
        double
          variation of information between X and Y

        """
        return _pyAgrum.ShaferShenoyInference_double_VI(self, X, Y)


    def evidenceJointImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceJointImpact(self, targets, evs) -> Potential_double
        evidenceJointImpact(self, targets, evs) -> Potential_double


        Create a pyAgrum.Potential for P(joint targets|evs) (for all instanciation of targets and evs) 

        Parameters
        ----------
        targets :
          (int) a node Id
        targets :
          (str) a node name
        evs : set
          a set of nodes ids or names.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(target|evs)

        Raises
        ------
        gum.Exception
          If some evidene entered into the Bayes net are incompatible (their joint proba = 0)

        """
        return _pyAgrum.ShaferShenoyInference_double_evidenceJointImpact(self, *args)

ShaferShenoyInference_double_swigregister = _pyAgrum.ShaferShenoyInference_double_swigregister
ShaferShenoyInference_double_swigregister(ShaferShenoyInference_double)

class VariableElimination_double(_object):
    """

    Class used for Variable Elimination inference algorithm.

    Available constructors:
    	``VariableElimination(bn) -> VariableElimination``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VariableElimination_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VariableElimination_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, BN, relevant_type, arg4) -> VariableElimination_double
        __init__(self, BN, relevant_type) -> VariableElimination_double
        __init__(self, BN) -> VariableElimination_double
        """
        this = _pyAgrum.new_VariableElimination_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=args[0]#BN



    __swig_destroy__ = _pyAgrum.delete_VariableElimination_double
    def __del__(self):
        return None

    def setTriangulation(self, new_triangulation: 'Triangulation') -> "void":
        """setTriangulation(self, new_triangulation)"""
        return _pyAgrum.VariableElimination_double_setTriangulation(self, new_triangulation)


    def setRelevantPotentialsFinderType(self, type: 'gum::RelevantPotentialsFinderType') -> "void":
        """
        setRelevantPotentialsFinderType(self, type)


        sets how we determine the relevant potentials to combine

        When a clique sends a message to a separator, it first constitute the set of the potentials it contains and of the potentials contained in the messages it received. If RelevantPotentialsFinderType = FIND_ALL, all these potentials are combined and projected to produce the message sent to the separator. If RelevantPotentialsFinderType = DSEP_BAYESBALL_NODES, then only the set of potentials d-connected to the variables of the separator are kept for combination and projection.

        0 = FIND_ALL
        1 = DSEP_BAYESBALL_NODES
        2 = DSEP_BAYESBALL_POTENTIALS
        3 = DSEP_KOLLER_FRIEDMAN_2009

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.VariableElimination_double_setRelevantPotentialsFinderType(self, type)


    def setFindBarrenNodesType(self, type: 'gum::FindBarrenNodesType') -> "void":
        """
        setFindBarrenNodesType(self, type)


        sets how we determine barren nodes

        Barren nodes are unnecessary for probability inference, so they can be safely discarded in this case (type = FIND_BARREN_NODES). This speeds-up inference. However, there are some cases in which we do not want to remove barren nodes, typically when we want to answer queries such as Most Probable Explanations (MPE).

        0 = FIND_NO_BARREN_NODES
        1 = FIND_BARREN_NODES

        Parameters
        ----------
        type : int
          the finder type

        Raises
        ------
        gum.InvalidArgument
          If type is not implemented

        """
        return _pyAgrum.VariableElimination_double_setFindBarrenNodesType(self, type)


    def junctionTree(self, id: 'gum::NodeId') -> "gum::JunctionTree const *":
        """
        junctionTree(self, id) -> CliqueGraph


        Returns
        -------
        pyAgrum.CliqueGraph
          the current junction tree 

        """
        return _pyAgrum.VariableElimination_double_junctionTree(self, id)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.VariableElimination_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.VariableElimination_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.VariableElimination_double_targets(self)


    def jointPosterior(self, list: 'PyObject *') -> "gum::Potential< double >":
        """
        jointPosterior(self, list) -> Potential_double


        Compute the joint posterior of a set of nodes.

        Parameters
        ----------
        list : 
          the list of nodes whose posterior joint probability is wanted

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior joint probability of the set of nodes. 

        Raises
        ------
        gum.UndefinedElement 
          If an element of nodes is not in targets

        """
        return _pyAgrum.VariableElimination_double_jointPosterior(self, list)


    def addJointTarget(self, list: 'PyObject *') -> "void":
        """
        addJointTarget(self, list)


        Add a list of nodes as a new joint target. As a collateral effect, every node is added as a marginal target.

        Parameters
        ----------
        list
          a list of names of nodes

        Raises
        ------
        gum.UndefinedElement
          If some node(s) do not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_addJointTarget(self, list)


    def eraseJointTarget(self, list: 'PyObject *') -> "void":
        """
        eraseJointTarget(self, list)


        Remove, if existing, the joint target.

        Parameters
        ----------
        list
          a list of names or Ids of nodes

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_eraseJointTarget(self, list)


    def isJointTarget(self, list: 'PyObject *') -> "bool":
        """
        isJointTarget(self, list) -> bool


        Parameters
        ----------
        list
          a list of nodes ids or names.

        Returns
        -------
        bool
          True if target is a joint target. 

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_isJointTarget(self, list)


    def jointTargets(self) -> "PyObject *":
        """
        jointTargets(self) -> PyObject *


        Returns
        -------
        list
          the list of target sets 

        """
        return _pyAgrum.VariableElimination_double_jointTargets(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.VariableElimination_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.VariableElimination_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.VariableElimination_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.VariableElimination_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.VariableElimination_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.VariableElimination_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.VariableElimination_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.VariableElimination_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.VariableElimination_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.VariableElimination_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.VariableElimination_double_evidenceImpact(self, *args)

VariableElimination_double_swigregister = _pyAgrum.VariableElimination_double_swigregister
VariableElimination_double_swigregister(VariableElimination_double)

class GibbsSampling_double(_object):
    """

    Class for making Gibbs sampling inference in bayesian networks.

    Available constructors:
    	``GibbsSampling(bn) -> GibbsSampling``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GibbsSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GibbsSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> GibbsSampling_double"""
        this = _pyAgrum.new_GibbsSampling_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_GibbsSampling_double
    def __del__(self):
        return None

    def setBurnIn(self, b: 'gum::Size') -> "void":
        """
        setBurnIn(self, b)


        Parameters
        ----------
        b : int
          size of burn in on number of iteration

        """
        return _pyAgrum.GibbsSampling_double_setBurnIn(self, b)


    def burnIn(self) -> "gum::Size":
        """
        burnIn(self) -> gum::Size


        Returns
        -------
        int
          size of burn in on number of iteration

        """
        return _pyAgrum.GibbsSampling_double_burnIn(self)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.GibbsSampling_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.GibbsSampling_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.GibbsSampling_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.GibbsSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.GibbsSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.GibbsSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.GibbsSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.GibbsSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.GibbsSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.GibbsSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.GibbsSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.GibbsSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.GibbsSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.GibbsSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.GibbsSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.GibbsSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.GibbsSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.GibbsSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.GibbsSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.GibbsSampling_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.GibbsSampling_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.GibbsSampling_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.GibbsSampling_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.GibbsSampling_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.GibbsSampling_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.GibbsSampling_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.GibbsSampling_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.GibbsSampling_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.GibbsSampling_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.GibbsSampling_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.GibbsSampling_double_evidenceImpact(self, *args)


    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        """
        currentPosterior(self, id) -> Potential_double
        currentPosterior(self, name) -> Potential_double


        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.GibbsSampling_double_currentPosterior(self, *args)


    def nbrDrawnVar(self) -> "gum::Size":
        """
        nbrDrawnVar(self) -> gum::Size


        Returns
        -------
        int
          the number of variable drawn at each iteration

        """
        return _pyAgrum.GibbsSampling_double_nbrDrawnVar(self)


    def setNbrDrawnVar(self, _nbr: 'gum::Size') -> "void":
        """
        setNbrDrawnVar(self, _nbr)


        Parameters
        ----------
        _nbr : int
          the number of variables to be drawn at each iteration

        """
        return _pyAgrum.GibbsSampling_double_setNbrDrawnVar(self, _nbr)


    def isDrawnAtRandom(self) -> "bool":
        """
        isDrawnAtRandom(self) -> bool


        Returns
        -------
        bool
          True if variables are drawn at random

        """
        return _pyAgrum.GibbsSampling_double_isDrawnAtRandom(self)


    def setDrawnAtRandom(self, _atRandom: 'bool') -> "void":
        """
        setDrawnAtRandom(self, _atRandom)


        Parameters
        ----------
        _atRandom : bool
          indicates if variables should be drawn at random

        """
        return _pyAgrum.GibbsSampling_double_setDrawnAtRandom(self, _atRandom)

GibbsSampling_double_swigregister = _pyAgrum.GibbsSampling_double_swigregister
GibbsSampling_double_swigregister(GibbsSampling_double)

class ImportanceSampling_double(_object):
    """

    Class used for inferences using the Importance Sampling algorithm.

    Available constructors:
    	``ImportanceSampling(bn) -> ImportanceSampling``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ImportanceSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ImportanceSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> ImportanceSampling_double"""
        this = _pyAgrum.new_ImportanceSampling_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_ImportanceSampling_double
    def __del__(self):
        return None

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.ImportanceSampling_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.ImportanceSampling_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.ImportanceSampling_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.ImportanceSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.ImportanceSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.ImportanceSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.ImportanceSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.ImportanceSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.ImportanceSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.ImportanceSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.ImportanceSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.ImportanceSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.ImportanceSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.ImportanceSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.ImportanceSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.ImportanceSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.ImportanceSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.ImportanceSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.ImportanceSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.ImportanceSampling_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.ImportanceSampling_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ImportanceSampling_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.ImportanceSampling_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.ImportanceSampling_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.ImportanceSampling_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.ImportanceSampling_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.ImportanceSampling_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.ImportanceSampling_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.ImportanceSampling_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.ImportanceSampling_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.ImportanceSampling_double_evidenceImpact(self, *args)


    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        """
        currentPosterior(self, id) -> Potential_double
        currentPosterior(self, name) -> Potential_double


        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.ImportanceSampling_double_currentPosterior(self, *args)

ImportanceSampling_double_swigregister = _pyAgrum.ImportanceSampling_double_swigregister
ImportanceSampling_double_swigregister(ImportanceSampling_double)

class WeightedSampling_double(_object):
    """

    Class used for Weighted sampling inference algorithm.

    Available constructors:
    	``WeightedSampling(bn) -> WeightedSampling``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeightedSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, WeightedSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> WeightedSampling_double"""
        this = _pyAgrum.new_WeightedSampling_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_WeightedSampling_double
    def __del__(self):
        return None

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.WeightedSampling_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.WeightedSampling_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.WeightedSampling_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.WeightedSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.WeightedSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.WeightedSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.WeightedSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.WeightedSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.WeightedSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.WeightedSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.WeightedSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.WeightedSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.WeightedSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.WeightedSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.WeightedSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.WeightedSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.WeightedSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.WeightedSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.WeightedSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.WeightedSampling_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.WeightedSampling_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.WeightedSampling_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.WeightedSampling_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.WeightedSampling_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.WeightedSampling_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.WeightedSampling_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.WeightedSampling_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.WeightedSampling_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.WeightedSampling_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.WeightedSampling_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.WeightedSampling_double_evidenceImpact(self, *args)


    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        """
        currentPosterior(self, id) -> Potential_double
        currentPosterior(self, name) -> Potential_double


        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.WeightedSampling_double_currentPosterior(self, *args)

WeightedSampling_double_swigregister = _pyAgrum.WeightedSampling_double_swigregister
WeightedSampling_double_swigregister(WeightedSampling_double)

class MonteCarloSampling_double(_object):
    """

    Class used for Monte Carlo sampling inference algorithm.

    Available constructors:
    	``MonteCarloSampling(bn) -> MonteCarloSampling``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonteCarloSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MonteCarloSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> MonteCarloSampling_double"""
        this = _pyAgrum.new_MonteCarloSampling_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_MonteCarloSampling_double
    def __del__(self):
        return None

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.MonteCarloSampling_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.MonteCarloSampling_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.MonteCarloSampling_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.MonteCarloSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.MonteCarloSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.MonteCarloSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.MonteCarloSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.MonteCarloSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.MonteCarloSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.MonteCarloSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.MonteCarloSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.MonteCarloSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.MonteCarloSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.MonteCarloSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.MonteCarloSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.MonteCarloSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.MonteCarloSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.MonteCarloSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.MonteCarloSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.MonteCarloSampling_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.MonteCarloSampling_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.MonteCarloSampling_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.MonteCarloSampling_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.MonteCarloSampling_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.MonteCarloSampling_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.MonteCarloSampling_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.MonteCarloSampling_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.MonteCarloSampling_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.MonteCarloSampling_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.MonteCarloSampling_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.MonteCarloSampling_double_evidenceImpact(self, *args)


    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        """
        currentPosterior(self, id) -> Potential_double
        currentPosterior(self, name) -> Potential_double


        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.MonteCarloSampling_double_currentPosterior(self, *args)

MonteCarloSampling_double_swigregister = _pyAgrum.MonteCarloSampling_double_swigregister
MonteCarloSampling_double_swigregister(MonteCarloSampling_double)

class LoopyImportanceSampling_double(_object):
    """

    Class used for inferences using a loopy version of importance sampling.

    Available constructors:
    	``LoopyImportanceSampling(bn) -> LoopyImportanceSampling``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LoopyImportanceSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LoopyImportanceSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> LoopyImportanceSampling_double"""
        this = _pyAgrum.new_LoopyImportanceSampling_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyImportanceSampling_double
    def __del__(self):
        return None

    def _makeInference(self) -> "void":
        """_makeInference(self)"""
        return _pyAgrum.LoopyImportanceSampling_double__makeInference(self)


    def setVirtualLBPSize(self, vlbpsize: 'double') -> "void":
        """
        setVirtualLBPSize(self, vlbpsize)


        Parameters
        ----------
        vlbpsize : double
          the size of the virtual LBP

        """
        return _pyAgrum.LoopyImportanceSampling_double_setVirtualLBPSize(self, vlbpsize)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.LoopyImportanceSampling_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.LoopyImportanceSampling_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyImportanceSampling_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.LoopyImportanceSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.LoopyImportanceSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyImportanceSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.LoopyImportanceSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyImportanceSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyImportanceSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyImportanceSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyImportanceSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyImportanceSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyImportanceSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyImportanceSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyImportanceSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyImportanceSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyImportanceSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyImportanceSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyImportanceSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.LoopyImportanceSampling_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.LoopyImportanceSampling_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyImportanceSampling_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyImportanceSampling_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyImportanceSampling_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.LoopyImportanceSampling_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyImportanceSampling_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.LoopyImportanceSampling_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyImportanceSampling_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyImportanceSampling_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyImportanceSampling_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyImportanceSampling_double_evidenceImpact(self, *args)


    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        """
        currentPosterior(self, id) -> Potential_double
        currentPosterior(self, name) -> Potential_double


        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyImportanceSampling_double_currentPosterior(self, *args)

LoopyImportanceSampling_double_swigregister = _pyAgrum.LoopyImportanceSampling_double_swigregister
LoopyImportanceSampling_double_swigregister(LoopyImportanceSampling_double)

class LoopyWeightedSampling_double(_object):
    """

    Class used for inferences using a loopy version of weighted sampling.

    Available constructors:
    	``LoopyWeightedSampling(bn) -> LoopyWeightedSampling``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LoopyWeightedSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LoopyWeightedSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> LoopyWeightedSampling_double"""
        this = _pyAgrum.new_LoopyWeightedSampling_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyWeightedSampling_double
    def __del__(self):
        return None

    def _makeInference(self) -> "void":
        """_makeInference(self)"""
        return _pyAgrum.LoopyWeightedSampling_double__makeInference(self)


    def setVirtualLBPSize(self, vlbpsize: 'double') -> "void":
        """
        setVirtualLBPSize(self, vlbpsize)


        Parameters
        ----------
        vlbpsize : double
          the size of the virtual LBP

        """
        return _pyAgrum.LoopyWeightedSampling_double_setVirtualLBPSize(self, vlbpsize)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.LoopyWeightedSampling_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.LoopyWeightedSampling_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyWeightedSampling_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.LoopyWeightedSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.LoopyWeightedSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyWeightedSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.LoopyWeightedSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyWeightedSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyWeightedSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyWeightedSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyWeightedSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyWeightedSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyWeightedSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyWeightedSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyWeightedSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyWeightedSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyWeightedSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyWeightedSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyWeightedSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.LoopyWeightedSampling_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.LoopyWeightedSampling_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyWeightedSampling_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyWeightedSampling_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyWeightedSampling_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.LoopyWeightedSampling_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyWeightedSampling_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.LoopyWeightedSampling_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyWeightedSampling_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyWeightedSampling_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyWeightedSampling_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyWeightedSampling_double_evidenceImpact(self, *args)


    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        """
        currentPosterior(self, id) -> Potential_double
        currentPosterior(self, name) -> Potential_double


        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyWeightedSampling_double_currentPosterior(self, *args)

LoopyWeightedSampling_double_swigregister = _pyAgrum.LoopyWeightedSampling_double_swigregister
LoopyWeightedSampling_double_swigregister(LoopyWeightedSampling_double)

class LoopyGibbsSampling_double(_object):
    """

    Class used for inferences using a loopy version of Gibbs sampling.

    Available constructors:
    	``LoopyGibbsSampling(bn) -> LoopyGibbsSampling``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LoopyGibbsSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LoopyGibbsSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> LoopyGibbsSampling_double"""
        this = _pyAgrum.new_LoopyGibbsSampling_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyGibbsSampling_double
    def __del__(self):
        return None

    def _makeInference(self) -> "void":
        """_makeInference(self)"""
        return _pyAgrum.LoopyGibbsSampling_double__makeInference(self)


    def setVirtualLBPSize(self, vlbpsize: 'double') -> "void":
        """
        setVirtualLBPSize(self, vlbpsize)


        Parameters
        ----------
        vlbpsize : double
          the size of the virtual LBP

        """
        return _pyAgrum.LoopyGibbsSampling_double_setVirtualLBPSize(self, vlbpsize)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.LoopyGibbsSampling_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.LoopyGibbsSampling_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyGibbsSampling_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.LoopyGibbsSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.LoopyGibbsSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyGibbsSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.LoopyGibbsSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyGibbsSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyGibbsSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyGibbsSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyGibbsSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyGibbsSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyGibbsSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyGibbsSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyGibbsSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyGibbsSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyGibbsSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyGibbsSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyGibbsSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.LoopyGibbsSampling_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.LoopyGibbsSampling_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyGibbsSampling_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyGibbsSampling_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyGibbsSampling_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.LoopyGibbsSampling_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyGibbsSampling_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.LoopyGibbsSampling_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyGibbsSampling_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyGibbsSampling_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyGibbsSampling_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyGibbsSampling_double_evidenceImpact(self, *args)


    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        """
        currentPosterior(self, id) -> Potential_double
        currentPosterior(self, name) -> Potential_double


        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyGibbsSampling_double_currentPosterior(self, *args)


    def nbrDrawnVar(self) -> "gum::Size":
        """
        nbrDrawnVar(self) -> gum::Size


        Returns
        -------
        int
          the number of variable drawn at each iteration

        """
        return _pyAgrum.LoopyGibbsSampling_double_nbrDrawnVar(self)


    def setNbrDrawnVar(self, _nbr: 'gum::Size') -> "void":
        """
        setNbrDrawnVar(self, _nbr)


        Parameters
        ----------
        _nbr : int
          the number of variables to be drawn at each iteration

        """
        return _pyAgrum.LoopyGibbsSampling_double_setNbrDrawnVar(self, _nbr)


    def isDrawnAtRandom(self) -> "bool":
        """
        isDrawnAtRandom(self) -> bool


        Returns
        -------
        bool
          True if variables are drawn at random

        """
        return _pyAgrum.LoopyGibbsSampling_double_isDrawnAtRandom(self)


    def setDrawnAtRandom(self, _atRandom: 'bool') -> "void":
        """
        setDrawnAtRandom(self, _atRandom)


        Parameters
        ----------
        _atRandom : bool
          indicates if variables should be drawn at random

        """
        return _pyAgrum.LoopyGibbsSampling_double_setDrawnAtRandom(self, _atRandom)


    def burnIn(self) -> "gum::Size":
        """
        burnIn(self) -> gum::Size


        Returns
        -------
        int
          size of burn in on number of iteration

        """
        return _pyAgrum.LoopyGibbsSampling_double_burnIn(self)


    def setBurnIn(self, b: 'gum::Size') -> "void":
        """
        setBurnIn(self, b)


        Parameters
        ----------
        b : int
          size of burn in on number of iteration

        """
        return _pyAgrum.LoopyGibbsSampling_double_setBurnIn(self, b)

LoopyGibbsSampling_double_swigregister = _pyAgrum.LoopyGibbsSampling_double_swigregister
LoopyGibbsSampling_double_swigregister(LoopyGibbsSampling_double)

class LoopyMonteCarloSampling_double(_object):
    """Proxy of C++ gum::LoopySamplingInference< double,gum::MonteCarloSampling > class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LoopyMonteCarloSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LoopyMonteCarloSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> LoopyMonteCarloSampling_double"""
        this = _pyAgrum.new_LoopyMonteCarloSampling_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyMonteCarloSampling_double
    def __del__(self):
        return None

    def _makeInference(self) -> "void":
        """_makeInference(self)"""
        return _pyAgrum.LoopyMonteCarloSampling_double__makeInference(self)


    def setVirtualLBPSize(self, vlbpsize: 'double') -> "void":
        """
        setVirtualLBPSize(self, vlbpsize)


        Parameters
        ----------
        vlbpsize : double
          the size of the virtual LBP

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_setVirtualLBPSize(self, vlbpsize)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_evidenceImpact(self, *args)


    def currentPosterior(self, *args) -> "gum::Potential< double > const &":
        """
        currentPosterior(self, id) -> Potential_double
        currentPosterior(self, name) -> Potential_double


        Computes and returns the current posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the current posterior probability of the node

        Raises
        ------
        UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyMonteCarloSampling_double_currentPosterior(self, *args)

LoopyMonteCarloSampling_double_swigregister = _pyAgrum.LoopyMonteCarloSampling_double_swigregister
LoopyMonteCarloSampling_double_swigregister(LoopyMonteCarloSampling_double)

class LoopyBeliefPropagation_double(_object):
    """

    Class used for inferences using loopy belief propagation algorithm.

    Available constructors:
    	``LoopyBeliefPropagation(bn) -> LoopyBeliefPropagation``

    Parameters
    ----------
    bn : pyAgrum.BayesNet
    	a Bayesian network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LoopyBeliefPropagation_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LoopyBeliefPropagation_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'IBayesNet_double'):
        """__init__(self, bn) -> LoopyBeliefPropagation_double"""
        this = _pyAgrum.new_LoopyBeliefPropagation_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._bn=bn#BN



    __swig_destroy__ = _pyAgrum.delete_LoopyBeliefPropagation_double
    def __del__(self):
        return None

    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        """
        Apply chgEvidence(key,value) for every pairs in evidces (or addEvidence).

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        """
        Remove all the targets and add the ones in parameter.

        Parameters
        ----------
        targets : set
          a set of targets

        Raises
        ------
        gum.UndefinedElement
            If one target is not in the Bayes net 
        """
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceNodes(self) -> "PyObject *":
        """
        hardEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with hard evidence 

        """
        return _pyAgrum.LoopyBeliefPropagation_double_hardEvidenceNodes(self)


    def softEvidenceNodes(self) -> "PyObject *":
        """
        softEvidenceNodes(self) -> PyObject *


        Returns
        -------
        set
          the set of nodes with soft evidence 

        """
        return _pyAgrum.LoopyBeliefPropagation_double_softEvidenceNodes(self)


    def targets(self) -> "PyObject *":
        """
        targets(self) -> PyObject *


        Returns
        -------
        list
          the list of marginal targets

        """
        return _pyAgrum.LoopyBeliefPropagation_double_targets(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.LoopyBeliefPropagation_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.LoopyBeliefPropagation_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.LoopyBeliefPropagation_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.LoopyBeliefPropagation_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.LoopyBeliefPropagation_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyBeliefPropagation_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.LoopyBeliefPropagation_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.LoopyBeliefPropagation_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.LoopyBeliefPropagation_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.LoopyBeliefPropagation_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.LoopyBeliefPropagation_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.LoopyBeliefPropagation_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.LoopyBeliefPropagation_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.LoopyBeliefPropagation_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.LoopyBeliefPropagation_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.LoopyBeliefPropagation_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.LoopyBeliefPropagation_double_asIApproximationSchemeConfiguration(self)


    def makeInference(self) -> "void":
        """
        makeInference(self)


        Perform the heavy computations needed to compute the targets' posteriors

        In a Junction tree propagation scheme, for instance, the heavy computations are those of the messages sent in the JT.
        This is precisely what makeInference should compute. Later, the computations of the posteriors can be done 'lightly' by multiplying and projecting those messages. 

        """
        return _pyAgrum.LoopyBeliefPropagation_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(self, var) -> Potential_double
        posterior(self, nodeName) -> Potential_double


        Computes and returns the posterior of a node.

        Parameters
        ----------
        var : int
          the node Id of the node for which we need a posterior probability
        nodeName : str
          the node name of the node for which we need a posterior probability

        Returns
        -------
        pyAgrum.Potential
          a const ref to the posterior probability of the node

        Raises
        ------
        gum.UndefinedElement
          If an element of nodes is not in targets

        """
        return _pyAgrum.LoopyBeliefPropagation_double_posterior(self, *args)


    def BN(self) -> "gum::IBayesNet< double > const &":
        """
        BN(self) -> IBayesNet_double


        Returns
        -------
        pyAgrum.IBayesNet
          A constant reference over the IBayesNet referenced by this class.

        Raises
        ------
        gum.UndefinedElement
          If no Bayes net has been assigned to the inference.

        """
        return _pyAgrum.LoopyBeliefPropagation_double_BN(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, val)
        addEvidence(self, nodeName, val)
        addEvidence(self, id, vals)
        addEvidence(self, nodeName, vals)


        Adds a new evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node already has an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, val)
        chgEvidence(self, nodeName, val)
        chgEvidence(self, id, vals)
        chgEvidence(self, nodeName, vals)


        Change the value of an already existing evidence on a node (might be soft or hard).

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name
        val :
          (int) a node value
        val :
          (str) the label of the node value
        vals : list
          a list of values

        Raises
        ------
        gum.InvalidArgument
          If the node does not already have an evidence
        gum.InvalidArgument
          If val is not a value for the node
        gum.InvalidArgument
          If the size of vals is different from the domain side of the node
        gum.FatalError
          If vals is a vector of 0s
        gum.UndefinedElement
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(self, id) -> bool
        hasEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if some node(s) (or the one in parameters) have received evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the network.

        """
        return _pyAgrum.LoopyBeliefPropagation_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(self, id)
        eraseEvidence(self, nodeName)


        Remove the evidence, if any, corresponding to the node Id or name.

        Parameters
        ----------
        id : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a hard evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(self, id) -> bool
        hasSoftEvidence(self, nodeName) -> bool


        Parameters
        ----------
        id : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if node has received a soft evidence

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of hard evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(self) -> gum::Size


        Returns
        -------
        int
          the number of soft evidence entered into the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(self)


        Clear all previously defined targets (marginal and joint targets).

        As a result, no posterior can be computed (since we can only compute the posteriors of the marginal or joint targets that have been added by the user). 

        """
        return _pyAgrum.LoopyBeliefPropagation_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(self)


        Add all the nodes as targets.

        """
        return _pyAgrum.LoopyBeliefPropagation_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(self, target)
        addTarget(self, nodeName)


        Add a marginal target to the list of targets.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : str
          a node name

        Raises
        ------
        gum.UndefinedElement
          If target is not a NodeId in the Bayes net 

        """
        return _pyAgrum.LoopyBeliefPropagation_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(self, target)
        eraseTarget(self, nodeName)


        Remove, if existing, the marginal target.

        Parameters
        ----------
        target : int
          a node Id
        nodeName : int
          a node name

        Raises
        ------
        gum.IndexError
          If one of the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(self, variable) -> bool
        isTarget(self, nodeName) -> bool


        Parameters
        ----------
        variable : int
         a node Id
        nodeName : str
          a node name

        Returns
        -------
        bool
          True if variable is a (marginal) target

        Raises
        ------
        gum.IndexError
          If the node does not belong to the Bayesian network
        gum.UndefinedElement
          If node Id is not in the Bayesian network

        """
        return _pyAgrum.LoopyBeliefPropagation_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(self) -> gum::Size


        Returns
        -------
        int
          the number of marginal targets

        """
        return _pyAgrum.LoopyBeliefPropagation_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(self, X) -> double
        H(self, nodeName) -> double


        Parameters
        ----------
        X : int
          a node Id
        nodeName : str
          a node name

        Returns
        -------
        double
          the computed Shanon's entropy of a node given the observation

        """
        return _pyAgrum.LoopyBeliefPropagation_double_H(self, *args)


    def evidenceImpact(self, *args) -> "gum::Potential< double >":
        """
        evidenceImpact(self, target, evs) -> Potential_double
        evidenceImpact(self, target, evs) -> Potential_double


        Create a pyAgrum.Potential for P(target|evs) (for all instanciation of target and evs) 

        Parameters
        ----------
        target : set
          a set of targets ids or names.
        evs : set
          a set of nodes ids or names.

        Warnings
        --------
        if some evs are d-separated, they are not included in the Potential.

        Returns
        -------
        pyAgrum.Potential
          a Potential for P(targets|evs)

        """
        return _pyAgrum.LoopyBeliefPropagation_double_evidenceImpact(self, *args)

LoopyBeliefPropagation_double_swigregister = _pyAgrum.LoopyBeliefPropagation_double_swigregister
LoopyBeliefPropagation_double_swigregister(LoopyBeliefPropagation_double)

class BruteForceKL_double(_object):
    """

    Class representing an exact KL-divergence

    Available constructors :

    	``BruteForceKL(P,Q) -> BruteForceKL``

    	``BruteForceKL(kl) -> BruteForceKL``

    Parameters
    ----------
    P : pyAgrum.IBayesNet
    	a Bayesian network
    Q : pyAgrum.IBayesNet
    	anotre Bayesian network
    kl : pyAgrum.KL
    	the KL to copy

    Raises
    ------
    gum.OperationNotAllowed
    	If the 2BNs have not the same domain size of compatible node sets

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BruteForceKL_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BruteForceKL_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, P, Q) -> BruteForceKL_double
        __init__(self, kl) -> BruteForceKL_double
        """
        this = _pyAgrum.new_BruteForceKL_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_BruteForceKL_double
    def __del__(self):
        return None

    def compute(self) -> "PyObject *":
        """
        compute(self) -> PyObject *


        Returns
        -------
        dict
        	a dictionnary containing the different values after the computation.

        """
        return _pyAgrum.BruteForceKL_double_compute(self)

BruteForceKL_double_swigregister = _pyAgrum.BruteForceKL_double_swigregister
BruteForceKL_double_swigregister(BruteForceKL_double)

class GibbsKL_double(ApproximationScheme):
    """

    Class representing a Gibbs-Approximated KL-divergence 

    Available constructors :

    	``GibbsKL(P,Q) -> GibbsKL``

    	``GibbsKL(kl) -> GibbsKL``

    Parameters
    ----------
    P : pyAgrum.IBayesNet
    	a Bayesian network
    Q : pyAgrum.IBayesNet
    	anotre Bayesian network
    kl : pyAgrum.KL
    	the KL to copy

    Raises
    ------
    gum.OperationNotAllowed 
    	If the 2BNs have not the same domain size of compatible node sets

    """

    __swig_setmethods__ = {}
    for _s in [ApproximationScheme]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GibbsKL_double, name, value)
    __swig_getmethods__ = {}
    for _s in [ApproximationScheme]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GibbsKL_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, P, Q) -> GibbsKL_double
        __init__(self, kl) -> GibbsKL_double
        """
        this = _pyAgrum.new_GibbsKL_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_GibbsKL_double
    def __del__(self):
        return None

    def setBurnIn(self, b: 'gum::Size') -> "void":
        """
        setBurnIn(self, b)


        Parameters
        ----------
        b : int
        	size of burn in on number of iteration

        """
        return _pyAgrum.GibbsKL_double_setBurnIn(self, b)


    def burnIn(self) -> "gum::Size":
        """
        burnIn(self) -> gum::Size


        Returns
        -------
        int
        	size of burn in on number of iteration

        """
        return _pyAgrum.GibbsKL_double_burnIn(self)


    def compute(self) -> "PyObject *":
        """
        compute(self) -> PyObject *


        Returns
        -------
        dict
        	a dictionnary containing the different values after the computation.

        """
        return _pyAgrum.GibbsKL_double_compute(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.GibbsKL_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.GibbsKL_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.GibbsKL_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.GibbsKL_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.GibbsKL_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.GibbsKL_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.GibbsKL_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.GibbsKL_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.GibbsKL_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.GibbsKL_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.GibbsKL_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.GibbsKL_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.GibbsKL_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.GibbsKL_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.GibbsKL_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.GibbsKL_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.GibbsKL_double_asIApproximationSchemeConfiguration(self)


    def nbrDrawnVar(self) -> "gum::Size":
        """
        nbrDrawnVar(self) -> gum::Size


        Returns
        -------
        int
          the number of variable drawn at each iteration

        """
        return _pyAgrum.GibbsKL_double_nbrDrawnVar(self)


    def setNbrDrawnVar(self, _nbr: 'gum::Size') -> "void":
        """
        setNbrDrawnVar(self, _nbr)


        Parameters
        ----------
        _nbr : int
          the number of variables to be drawn at each iteration

        """
        return _pyAgrum.GibbsKL_double_setNbrDrawnVar(self, _nbr)


    def isDrawnAtRandom(self) -> "bool":
        """
        isDrawnAtRandom(self) -> bool


        Returns
        -------
        bool
          True if variables are drawn at random

        """
        return _pyAgrum.GibbsKL_double_isDrawnAtRandom(self)


    def setDrawnAtRandom(self, _atRandom: 'bool') -> "void":
        """
        setDrawnAtRandom(self, _atRandom)


        Parameters
        ----------
        _atRandom : bool
          indicates if variables should be drawn at random

        """
        return _pyAgrum.GibbsKL_double_setDrawnAtRandom(self, _atRandom)

GibbsKL_double_swigregister = _pyAgrum.GibbsKL_double_swigregister
GibbsKL_double_swigregister(GibbsKL_double)

class CredalNet_double(_object):
    """

    Constructor used to create a CredalNet (step by step or with two BayesNet)

    Available constructors:
        ``CredalNet() -> CredalNet``

        ``CredalNet(src_min_num,src_max_den) -> CredalNet``

        ``CredalNet(src_min_num,src_max_den) -> CredalNet``

    Parameters
    ----------
    src_min_num
    	(str) the path to a BayesNet which contains lower probabilities.
    src_max_den
    	(str) the (optional) path to a BayesNet which contains upper probabilities.
    src_min_num
    	(pyAgrum.BayesNet) the BayesNet which contains lower probabilities.
    src_max_den
    	(pyAgrum.BayesNet) the (optional) BayesNet which contains upper probabilities. 

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CredalNet_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CredalNet_double, name)
    NodeType_Precise = _pyAgrum.CredalNet_double_NodeType_Precise
    NodeType_Credal = _pyAgrum.CredalNet_double_NodeType_Credal
    NodeType_Vacuous = _pyAgrum.CredalNet_double_NodeType_Vacuous
    NodeType_Indic = _pyAgrum.CredalNet_double_NodeType_Indic

    def __init__(self, *args):
        """
        __init__(self) -> CredalNet_double
        __init__(self, src_min_num, src_max_den) -> CredalNet_double
        __init__(self, src_min_num) -> CredalNet_double
        __init__(self, src_min_num, src_max_den) -> CredalNet_double
        __init__(self, src_min_num) -> CredalNet_double
        """
        this = _pyAgrum.new_CredalNet_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CredalNet_double
    def __del__(self):
        return None

    def addVariable(self, name: 'std::string const &', card: 'gum::Size const &') -> "gum::NodeId":
        """
        addVariable(self, name, card) -> gum::NodeId


        Parameters
        ----------
        name : str
        	the name of the new variable
        card: int
            the domainSize of the new variable

        Returns
        -------
        int
        	the id of the new node

        """
        return _pyAgrum.CredalNet_double_addVariable(self, name, card)


    def addArc(self, tail: 'gum::NodeId const &', head: 'gum::NodeId const &') -> "void":
        """
        addArc(self, tail, head)


        Adds an arc between two nodes

        Parameters
        ----------
        tail :
        	the id of the tail node
        head : int 
        	the id of the head node

        Raises
        ------
        gum.InvalidDirectedCircle
        	If any (directed) cycle is created by this arc
        gum.InvalidNode
        	If head or tail does not belong to the graph nodes
        gum.DuplicateElement
        	If one of the arc already exists

        """
        return _pyAgrum.CredalNet_double_addArc(self, tail, head)


    def setCPTs(self, id: 'gum::NodeId const &', cpt: 'std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > const &') -> "void":
        """
        setCPTs(self, id, cpt)


        Warnings
        --------
        (experimental function) - Parameters to be wrapped


        Set the vertices of the credal sets (all of the conditionals) of a given node

        Parameters
        ----------
        id : int
        	the NodeId of the node
        cpt	: tbw 
        	the vertices of every credal set (for each instantiation of the parents)

        Warning
        -------
        DOES not change the BayesNet (s) associated to this credal net !

        """
        return _pyAgrum.CredalNet_double_setCPTs(self, id, cpt)


    def setCPT(self, *args) -> "void":
        """
        setCPT(self, id, entry, cpt)
        setCPT(self, id, ins, cpt)


        Warnings
        --------
        (experimental function) - Parameters to be wrapped


        Set the vertices of one credal set of a given node (any instantiation index)

        Parameters
        ----------
        id : int
        	the Id of the node
        entry : int
        	the index of the instantiation (from 0 to K - 1) excluding the given node (only the parents are used to compute the index of the credal set)
        ins : pyAgrum.Instantiation
        	the Instantiation (only the parents matter to find the credal set index) 
        cpt	: tbw
        	the vertices of every credal set (for each instantiation of the parents)

        Warnings
        --------
        DOES not change the BayesNet(s) associated to this credal net !

        """
        return _pyAgrum.CredalNet_double_setCPT(self, *args)


    def fillConstraints(self, id: 'gum::NodeId const &', lower: 'Vector_double', upper: 'Vector_double') -> "void":
        """
        fillConstraints(self, id, lower, upper)


        Set the interval constraints of the credal sets of a given node (all instantiations) 

        Parameters
        ----------
        id : int 
        	The id of the node
        lower : list
        	The lower value for each probability in correct order
        upper : list
        	The upper value for each probability in correct order

        Warnings
        --------
        You need to call intervalToCredal when done filling all constraints.

        Warning
        -------
        DOES change the BayesNet (s) associated to this credal net !

        """
        return _pyAgrum.CredalNet_double_fillConstraints(self, id, lower, upper)


    def fillConstraint(self, *args) -> "void":
        """
        fillConstraint(self, id, entry, lower, upper)
        fillConstraint(self, id, ins, lower, upper)


        Set the interval constraints of a credal set of a given node (from an instantiation index)

        Parameters
        ----------
        id : int 
        	The id of the node
        entry : int
        	The index of the instantiation excluding the given node (only the parents are used to compute the index of the credal set)
        ins : pyAgrum.Instantiation
        	The Instantiation
        lower : list
        	The lower value for each probability in correct order
        upper : list
        	The upper value for each probability in correct order

        Warnings
        --------
        You need to call intervalToCredal when done filling all constraints.

        Warning
        -------
        DOES change the BayesNet (s) associated to this credal net ! 

        """
        return _pyAgrum.CredalNet_double_fillConstraint(self, *args)


    def instantiation(self, id: 'gum::NodeId const &') -> "gum::Instantiation":
        """
        instantiation(self, id) -> Instantiation


        Get an Instantiation from a node id, usefull to fill the constraints of the network.

        bnet accessors / shortcuts.

        Parameters
        ----------
        id : int
        	the id of the node we want an instantiation from

        Returns
        -------
        pyAgrum.Instantiation
            the instantiation 

        """
        return _pyAgrum.CredalNet_double_instantiation(self, id)


    def domainSize(self, id: 'gum::NodeId const &') -> "gum::Size":
        """
        domainSize(self, id) -> gum::Size


        Parameters
        ----------
        id : int
        	The id of the node

        Returns
        -------
        int
            The cardinality of the node 

        """
        return _pyAgrum.CredalNet_double_domainSize(self, id)


    def bnToCredal(self, beta: 'double const', oneNet: 'bool const', keepZeroes: 'bool const'=False) -> "void":
        """
        bnToCredal(self, beta, oneNet, keepZeroes=False)
        bnToCredal(self, beta, oneNet)


        Perturbates the BayesNet provided as input for this CredalNet by generating intervals instead of point probabilities and then computes each vertex of each credal set.

        Parameters
        ----------
        beta : double
        	The beta used to perturbate the network
        oneNet : bool
        	used as a flag. Set to True if one BayesNet if provided with counts, to False if two BayesNet are provided; one with probabilities (the lower net) and one with denominators over the first modalities (the upper net)
        keepZeroes : bool
        	used as a flag as whether or not - respectively True or False - we keep zeroes as zeroes. Default is False, i.e. zeroes are not kept

        """
        return _pyAgrum.CredalNet_double_bnToCredal(self, beta, oneNet, keepZeroes)


    def intervalToCredalWithFiles(self) -> "void":
        """
        intervalToCredalWithFiles(self)


        Warnings
        --------
        Deprecated : use intervalToCredal (lrsWrapper with no input / output files needed).


        Computes the vertices of each credal set according to their interval definition (uses lrs).

        Use this method when using a single BayesNet storing counts of events. 

        """
        return _pyAgrum.CredalNet_double_intervalToCredalWithFiles(self)


    def intervalToCredal(self) -> "void":
        """
        intervalToCredal(self)


        Computes the vertices of each credal set according to their interval definition (uses lrs).

        Use this method when using two BayesNet, one with lower probabilities and one with upper probabilities.

        """
        return _pyAgrum.CredalNet_double_intervalToCredal(self)


    def lagrangeNormalization(self) -> "void":
        """
        lagrangeNormalization(self)


        Normalize counts of a BayesNet storing counts of each events such that no probability is 0.

        Use this method when using a single BayesNet storing counts of events. Lagrange normalization. This call is irreversible and modify counts stored by __src_bn.

        Doest not performs computations of the parameters but keeps normalized counts of events only. Call idmLearning to compute the probabilities (with any parameter value). 

        """
        return _pyAgrum.CredalNet_double_lagrangeNormalization(self)


    def idmLearning(self, s: 'gum::Idx const'=0, keepZeroes: 'bool const'=False) -> "void":
        """
        idmLearning(self, s=0, keepZeroes=False)
        idmLearning(self, s=0)
        idmLearning(self)


        Learns parameters from a BayesNet storing counts of events.

        Use this method when using a single BayesNet storing counts of events. IDM model if s > 0, standard point probability if s = 0 (default value if none precised).

        Parameters
        ----------
        s : int
        	the IDM parameter.
        keepZeroes : bool
        	used as a flag as whether or not - respectively True or False - we keep zeroes as zeroes. Default is False, i.e. zeroes are not kept. 

        """
        return _pyAgrum.CredalNet_double_idmLearning(self, s, keepZeroes)


    def approximatedBinarization(self) -> "void":
        """
        approximatedBinarization(self)


        Approximate binarization.

        Each bit has a lower and upper probability which is the lowest - resp. highest - over all vertices of the credal set. Enlarge the orignal credal sets and may induce huge imprecision.

        Warnings
        --------
        Enlarge the orignal credal sets and therefor induce huge imprecision by propagation. Not recommended, use MCSampling or something else instead

        """
        return _pyAgrum.CredalNet_double_approximatedBinarization(self)


    def saveBNsMinMax(self, min_path: 'std::string const &', max_path: 'std::string const &') -> "void":
        """
        saveBNsMinMax(self, min_path, max_path)


        If this CredalNet was built over a perturbed BayesNet, one can save the intervals as two BayesNet.

        to call after bnToCredal(GUM_SCALAR beta) save a BN with lower probabilities and a BN with upper ones

        Parameters
        ----------
        min_path : str
        	the path to save the BayesNet which contains the lower probabilities of each node X.
        max_path : str
        	the path to save the BayesNet which contains the upper probabilities of each node X.

        """
        return _pyAgrum.CredalNet_double_saveBNsMinMax(self, min_path, max_path)


    def computeCPTMinMax(self) -> "void":
        """
        computeCPTMinMax(self)


        Used with binary networks to speed-up L2U inference.

        Store the lower and upper probabilities of each node X over the 'True' modality.

        """
        return _pyAgrum.CredalNet_double_computeCPTMinMax(self)


    def src_bn(self) -> "gum::BayesNet< double > const &":
        """
        src_bn(self) -> BayesNet_double


        Returns
        -------
        pyAgrum.BayesNet
            Returns a constant reference to the original BayesNet (used as a DAG, it's CPTs does not matter). 

        """
        return _pyAgrum.CredalNet_double_src_bn(self)


    def current_bn(self) -> "gum::BayesNet< double > const &":
        """
        current_bn(self) -> BayesNet_double


        Returns
        -------
        pyAgrum.BayesNet
            Returs a constant reference to the actual BayesNet (used as a DAG, it's CPTs does not matter). 

        """
        return _pyAgrum.CredalNet_double_current_bn(self)


    def credalNet_currentCpt(self) -> "gum::NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &":
        """
        credalNet_currentCpt(self) -> gum::NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &


        Warnings
        --------
        Experimental function - Return type to be wrapped

        Returns
        -------
        tbw
            a constant reference to the (up-to-date) CredalNet CPTs.

        """
        return _pyAgrum.CredalNet_double_credalNet_currentCpt(self)


    def credalNet_srcCpt(self) -> "gum::NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &":
        """
        credalNet_srcCpt(self) -> gum::NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &


        Warnings
        --------
        Experimental function - Return type to be wrapped

        Returns
        -------
        tbw
            a constant reference to the (up-to-date) CredalNet CPTs.

        """
        return _pyAgrum.CredalNet_double_credalNet_srcCpt(self)


    def currentNodeType(self, id: 'gum::NodeId const &') -> "gum::credal::CredalNet< double >::NodeType":
        """
        currentNodeType(self, id) -> gum::credal::CredalNet< double >::NodeType


        Parameters
        ----------
        id : int 
        	The constant reference to the choosen NodeId

        Returns
        -------
        pyAgrum.CredalNet
            the type of the choosen node in the (up-to-date) CredalNet __current_bn if any, __src_bn otherwise. 

        """
        return _pyAgrum.CredalNet_double_currentNodeType(self, id)


    def nodeType(self, id: 'gum::NodeId const &') -> "gum::credal::CredalNet< double >::NodeType":
        """
        nodeType(self, id) -> gum::credal::CredalNet< double >::NodeType


        Parameters
        ----------
        id : int
        	the constant reference to the choosen NodeId

        Returns
        -------
        pyAgrum.CredalNet
        	the type of the choosen node in the (up-to-date) CredalNet in __src_bn. 

        """
        return _pyAgrum.CredalNet_double_nodeType(self, id)


    def epsilonMin(self) -> "double const &":
        """
        epsilonMin(self) -> double const &


        Returns
        -------
        double
            a constant reference to the lowest perturbation of the BayesNet provided as input for this CredalNet. 

        """
        return _pyAgrum.CredalNet_double_epsilonMin(self)


    def epsilonMax(self) -> "double const &":
        """
        epsilonMax(self) -> double const &


        Returns
        -------
        double
            a constant reference to the highest perturbation of the BayesNet provided as input for this CredalNet. 

        """
        return _pyAgrum.CredalNet_double_epsilonMax(self)


    def epsilonMean(self) -> "double const &":
        """
        epsilonMean(self) -> double const &


        Returns
        -------
        double
            a constant reference to the average perturbation of the BayesNet provided as input for this CredalNet. 

        """
        return _pyAgrum.CredalNet_double_epsilonMean(self)


    def isSeparatelySpecified(self) -> "bool const":
        """
        isSeparatelySpecified(self) -> bool const


        Returns
        -------
        bool
        	True if this CredalNet is separately and interval specified, False otherwise. 

        """
        return _pyAgrum.CredalNet_double_isSeparatelySpecified(self)


    def hasComputedCPTMinMax(self) -> "bool const":
        """
        hasComputedCPTMinMax(self) -> bool const


        Returns
        -------
        bool
            True this CredalNet has called computeCPTMinMax() to speed-up inference with binary networks and L2U.

        """
        return _pyAgrum.CredalNet_double_hasComputedCPTMinMax(self)


    def get_CPT_min(self) -> "std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &":
        """
        get_CPT_min(self) -> std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &


        Warnings
        --------
        Experimental function - Return type to be wrapped

        Returns
        -------
        tbw
        	a constant reference to the lower probabilities of each node X over the 'True' modality

        """
        return _pyAgrum.CredalNet_double_get_CPT_min(self)


    def get_CPT_max(self) -> "std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &":
        """
        get_CPT_max(self) -> std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &


        Warnings
        --------
        Experimental function - Return type to be wrapped

        Returns
        -------
        tbw
        	a constant reference to the upper probabilities of each node X over the 'True' modality

        """
        return _pyAgrum.CredalNet_double_get_CPT_max(self)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.CredalNet_double___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.CredalNet_double___str__(self)

CredalNet_double_swigregister = _pyAgrum.CredalNet_double_swigregister
CredalNet_double_swigregister(CredalNet_double)

class CNMonteCarloSampling_double(_object):
    """

    Class used for inferences in credal networks with Monte Carlo sampling algorithm.

    Available constructors:

        ``CNMonteCarloSampling(cn) -> CNMonteCarloSampling``

    Parameters
    ----------
    cn: pyAgrum.CredalNet
      a Credal network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CNMonteCarloSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CNMonteCarloSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, credalNet: 'CredalNet_double'):
        """__init__(self, credalNet) -> CNMonteCarloSampling_double"""
        this = _pyAgrum.new_CNMonteCarloSampling_double(credalNet)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CNMonteCarloSampling_double
    def __del__(self):
        return None

    def makeInference(self) -> "void":
        """
        makeInference(self)


        Starts the inference.

        """
        return _pyAgrum.CNMonteCarloSampling_double_makeInference(self)


    def insertEvidenceFile(self, path: 'std::string const &') -> "void":
        """
        insertEvidenceFile(self, path)


        Insert evidence from file.

        Parameters
        ----------
        path : str
        	the path to the evidence file. 

        """
        return _pyAgrum.CNMonteCarloSampling_double_insertEvidenceFile(self, path)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.CNMonteCarloSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.CNMonteCarloSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.CNMonteCarloSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.CNMonteCarloSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.CNMonteCarloSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.CNMonteCarloSampling_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.CNMonteCarloSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.CNMonteCarloSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.CNMonteCarloSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.CNMonteCarloSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.CNMonteCarloSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.CNMonteCarloSampling_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.CNMonteCarloSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.CNMonteCarloSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.CNMonteCarloSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.CNMonteCarloSampling_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.CNMonteCarloSampling_double_asIApproximationSchemeConfiguration(self)


    def setRepetitiveInd(self, flag: 'bool const') -> "void":
        """
        setRepetitiveInd(self, flag)


        Parameters
        ----------
        flag : bool
        	True if repetitive independence is to be used, false otherwise. Only usefull with dynamic networks. 

        """
        return _pyAgrum.CNMonteCarloSampling_double_setRepetitiveInd(self, flag)


    def marginalMax(self, *args) -> "std::vector< double,std::allocator< double > > const &":
        """
        marginalMax(self, id) -> Vector_double
        marginalMax(self, name) -> Vector_double


        Get the upper marginals of a given node id.

        Parameters
        ----------
        id : int
        	the node id which upper marginals we want.
        varName : str
        	the variable name which upper marginals we want. 

        Returns
        -------
        list
            a constant reference to this node upper marginals.

        Raises
        ------
        gum.IndexError
        	If the node does not belong to the Credal network

        """
        return _pyAgrum.CNMonteCarloSampling_double_marginalMax(self, *args)


    def marginalMin(self, *args) -> "std::vector< double,std::allocator< double > > const &":
        """
        marginalMin(self, id) -> Vector_double
        marginalMin(self, name) -> Vector_double


        Get the lower marginals of a given node id.

        Parameters
        ----------
        id : int
        	the node id which lower marginals we want.
        varName : str
        	the variable name which lower marginals we want. 

        Returns
        -------
        list
            a constant reference to this node lower marginals.

        Raises
        ------
        gum.IndexError
        	If the node does not belong to the Credal network

        """
        return _pyAgrum.CNMonteCarloSampling_double_marginalMin(self, *args)


    def insertModalsFile(self, path: 'std::string const &') -> "void":
        """
        insertModalsFile(self, path)


        Insert variables modalities from file to compute expectations.

        Parameters
        ----------
        path : str
        	The path to the modalities file. 

        """
        return _pyAgrum.CNMonteCarloSampling_double_insertModalsFile(self, path)


    def dynamicExpMax(self, varName: 'std::string const &') -> "std::vector< double,std::allocator< double > > const &":
        """
        dynamicExpMax(self, varName) -> Vector_double


        Get the upper dynamic expectation of a given variable prefix.

        Parameters
        ----------
        varName : str
        	the variable name prefix which upper expectation we want.

        Returns
        -------
        double
            a constant reference to the variable upper expectation over all time steps. 

        """
        return _pyAgrum.CNMonteCarloSampling_double_dynamicExpMax(self, varName)


    def dynamicExpMin(self, varName: 'std::string const &') -> "std::vector< double,std::allocator< double > > const &":
        """
        dynamicExpMin(self, varName) -> Vector_double


        Get the lower dynamic expectation of a given variable prefix.

        Parameters
        ----------
        varName : str
        	the variable name prefix which lower expectation we want.

        Returns
        -------
        double
            a constant reference to the variable lower expectation over all time steps. 

        """
        return _pyAgrum.CNMonteCarloSampling_double_dynamicExpMin(self, varName)

CNMonteCarloSampling_double_swigregister = _pyAgrum.CNMonteCarloSampling_double_swigregister
CNMonteCarloSampling_double_swigregister(CNMonteCarloSampling_double)

class CNLoopyPropagation_double(_object):
    """

    Class used for inferences in credal networks with Loopy Propagation algorithm.

    Available constructors:

        ``CNLoopyPropagation(cn) -> CNLoopyPropagation``

    Parameters
    ----------
    cn: pyAgrum.CredalNet
      a Credal network

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CNLoopyPropagation_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CNLoopyPropagation_double, name)
    __repr__ = _swig_repr
    InferenceType_nodeToNeighbours = _pyAgrum.CNLoopyPropagation_double_InferenceType_nodeToNeighbours
    InferenceType_ordered = _pyAgrum.CNLoopyPropagation_double_InferenceType_ordered
    InferenceType_randomOrder = _pyAgrum.CNLoopyPropagation_double_InferenceType_randomOrder

    def makeInference(self) -> "void":
        """
        makeInference(self)


        Starts the inference.

        """
        return _pyAgrum.CNLoopyPropagation_double_makeInference(self)


    def inferenceType(self, *args) -> "gum::credal::CNLoopyPropagation< double >::InferenceType":
        """
        inferenceType(self, inft)
        inferenceType(self) -> gum::credal::CNLoopyPropagation< double >::InferenceType


        Returns
        -------
        int
        	the inference type

        """
        return _pyAgrum.CNLoopyPropagation_double_inferenceType(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Erase all inference related data to perform another one.

        You need to insert evidence again if needed but modalities are kept. You can insert new ones by using the appropriate method which will delete the old ones.

        """
        return _pyAgrum.CNLoopyPropagation_double_eraseAllEvidence(self)


    def saveInference(self, path: 'std::string const &') -> "void":
        """
        saveInference(self, path)


        Saves marginals.

        Parameters
        ----------
        path : str
        	The path to the file to save marginals. 

        """
        return _pyAgrum.CNLoopyPropagation_double_saveInference(self, path)


    def __init__(self, cnet: 'CredalNet_double'):
        """__init__(self, cnet) -> CNLoopyPropagation_double"""
        this = _pyAgrum.new_CNLoopyPropagation_double(cnet)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CNLoopyPropagation_double
    def __del__(self):
        return None

    def insertEvidenceFile(self, path: 'std::string const &') -> "void":
        """
        insertEvidenceFile(self, path)


        Insert evidence from file.

        Parameters
        ----------
        path : str
        	the path to the evidence file. 

        """
        return _pyAgrum.CNLoopyPropagation_double_insertEvidenceFile(self, path)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.CNLoopyPropagation_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.CNLoopyPropagation_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.CNLoopyPropagation_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.CNLoopyPropagation_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.CNLoopyPropagation_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.CNLoopyPropagation_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.CNLoopyPropagation_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.CNLoopyPropagation_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.CNLoopyPropagation_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.CNLoopyPropagation_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.CNLoopyPropagation_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.CNLoopyPropagation_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.CNLoopyPropagation_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.CNLoopyPropagation_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.CNLoopyPropagation_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.CNLoopyPropagation_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.CNLoopyPropagation_double_asIApproximationSchemeConfiguration(self)


    def setRepetitiveInd(self, flag: 'bool const') -> "void":
        """
        setRepetitiveInd(self, flag)


        Parameters
        ----------
        flag : bool
        	True if repetitive independence is to be used, false otherwise. Only usefull with dynamic networks. 

        """
        return _pyAgrum.CNLoopyPropagation_double_setRepetitiveInd(self, flag)


    def marginalMax(self, *args) -> "std::vector< double,std::allocator< double > > const &":
        """
        marginalMax(self, id) -> Vector_double
        marginalMax(self, name) -> Vector_double


        Get the upper marginals of a given node id.

        Parameters
        ----------
        id : int
        	the node id which upper marginals we want.
        varName : str
        	the variable name which upper marginals we want. 

        Returns
        -------
        list
            a constant reference to this node upper marginals.

        Raises
        ------
        gum.IndexError
        	If the node does not belong to the Credal network

        """
        return _pyAgrum.CNLoopyPropagation_double_marginalMax(self, *args)


    def marginalMin(self, *args) -> "std::vector< double,std::allocator< double > > const &":
        """
        marginalMin(self, id) -> Vector_double
        marginalMin(self, name) -> Vector_double


        Get the lower marginals of a given node id.

        Parameters
        ----------
        id : int
        	the node id which lower marginals we want.
        varName : str
        	the variable name which lower marginals we want. 

        Returns
        -------
        list
            a constant reference to this node lower marginals.

        Raises
        ------
        gum.IndexError
        	If the node does not belong to the Credal network

        """
        return _pyAgrum.CNLoopyPropagation_double_marginalMin(self, *args)


    def insertModalsFile(self, path: 'std::string const &') -> "void":
        """
        insertModalsFile(self, path)


        Insert variables modalities from file to compute expectations.

        Parameters
        ----------
        path : str
        	The path to the modalities file. 

        """
        return _pyAgrum.CNLoopyPropagation_double_insertModalsFile(self, path)


    def dynamicExpMax(self, varName: 'std::string const &') -> "std::vector< double,std::allocator< double > > const &":
        """
        dynamicExpMax(self, varName) -> Vector_double


        Get the upper dynamic expectation of a given variable prefix.

        Parameters
        ----------
        varName : str
        	the variable name prefix which upper expectation we want.

        Returns
        -------
        double
            a constant reference to the variable upper expectation over all time steps. 

        """
        return _pyAgrum.CNLoopyPropagation_double_dynamicExpMax(self, varName)


    def dynamicExpMin(self, varName: 'std::string const &') -> "std::vector< double,std::allocator< double > > const &":
        """
        dynamicExpMin(self, varName) -> Vector_double


        Get the lower dynamic expectation of a given variable prefix.

        Parameters
        ----------
        varName : str
        	the variable name prefix which lower expectation we want.

        Returns
        -------
        double
            a constant reference to the variable lower expectation over all time steps. 

        """
        return _pyAgrum.CNLoopyPropagation_double_dynamicExpMin(self, varName)

CNLoopyPropagation_double_swigregister = _pyAgrum.CNLoopyPropagation_double_swigregister
CNLoopyPropagation_double_swigregister(CNLoopyPropagation_double)

class InfluenceDiagram_double(DAGmodel):
    """

    InfluenceDiagram represents an Influence Diagram.

    Available constructors:
        ``InfluenceDiagram() -> InfluenceDiagram``

        ``InfluenceDiagram(source) -> InfluenceDiagram``

    Parameters
    ----------
    source : pyAgrum.InfluenceDiagram
      the InfluenceDiagram to copy

    """

    __swig_setmethods__ = {}
    for _s in [DAGmodel]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InfluenceDiagram_double, name, value)
    __swig_getmethods__ = {}
    for _s in [DAGmodel]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InfluenceDiagram_double, name)
    __swig_destroy__ = _pyAgrum.delete_InfluenceDiagram_double
    def __del__(self):
        return None

    def __init__(self, *args):
        """
        __init__(self) -> InfluenceDiagram_double
        __init__(self, source) -> InfluenceDiagram_double
        """
        this = _pyAgrum.new_InfluenceDiagram_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def toDot(self) -> "std::string":
        """
        toDot(self) -> std::string


        Returns
        -------
        str
            a friendly display of the graph in DOT format

        """
        return _pyAgrum.InfluenceDiagram_double_toDot(self)


    def cpt(self, varId: 'gum::NodeId') -> "gum::Potential< double > const &":
        """
        cpt(self, varId) -> Potential_double


        Returns the CPT of a variable.

        Parameters
        ----------
        VarId : int
        	A variable's id in the pyAgrum.BayesNet.

        Returns
        -------
        pyAgrum.Potential
        	The variable's CPT. 

        Raises
        ------
        gum.NotFound
        	If no variable's id matches varId. 

        """
        val = _pyAgrum.InfluenceDiagram_double_cpt(self, varId)

        val.__fill_distrib__()


        return val


    def utility(self, varId: 'gum::NodeId') -> "gum::Potential< double > const &":
        """
        utility(self, varId) -> Potential_double


        Parameters
        ----------
        varId : int 
        	the tested node id.

        Returns
        -------
        pyAgrum.Potential
        	the utility table of the node

        Raises
        ------
        gum.IndexError
        	If the InfluenceDiagram does not contain the variable

        """
        val = _pyAgrum.InfluenceDiagram_double_utility(self, varId)

        val.__fill_distrib__()


        return val


    def isUtilityNode(self, varId: 'gum::NodeId') -> "bool":
        """
        isUtilityNode(self, varId) -> bool


        Parameters
        ----------
        varId : int 
        	the tested node id.

        Returns
        -------
        bool
        	true if node is an utility node

        """
        return _pyAgrum.InfluenceDiagram_double_isUtilityNode(self, varId)


    def isDecisionNode(self, varId: 'gum::NodeId') -> "bool":
        """
        isDecisionNode(self, varId) -> bool


        Parameters
        ----------
        varId : int 
        	the tested node id.

        Returns
        -------
        bool
        	true if node is a decision node

        """
        return _pyAgrum.InfluenceDiagram_double_isDecisionNode(self, varId)


    def isChanceNode(self, varId: 'gum::NodeId') -> "bool":
        """
        isChanceNode(self, varId) -> bool


        Parameters
        ----------
        varId : int 
        	the tested node id.

        Returns
        -------
        bool
        	true if node is a chance node

        """
        return _pyAgrum.InfluenceDiagram_double_isChanceNode(self, varId)


    def utilityNodeSize(self) -> "gum::Size":
        """
        utilityNodeSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of utility nodes

        """
        return _pyAgrum.InfluenceDiagram_double_utilityNodeSize(self)


    def chanceNodeSize(self) -> "gum::Size":
        """
        chanceNodeSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of chance nodes. 

        """
        return _pyAgrum.InfluenceDiagram_double_chanceNodeSize(self)


    def decisionNodeSize(self) -> "gum::Size":
        """
        decisionNodeSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of decision nodes

        """
        return _pyAgrum.InfluenceDiagram_double_decisionNodeSize(self)


    def variable(self, id: 'gum::NodeId') -> "gum::DiscreteVariable const &":
        """
        variable(self, id) -> DiscreteVariable


        Parameters
        ----------
        id : int
         	the node id

        Returns
        ------
        pyAgrum.DiscreteVariable
        	a constant reference over a variabe given it's node id

        Raises
        ------
        gum.NotFound
        	If no variable's id matches the parameter 

        """
        return _pyAgrum.InfluenceDiagram_double_variable(self, id)


    def nodeId(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        nodeId(self, var) -> gum::NodeId


        Parameters
        ----------
        var : pyAgrum.DiscreteVariable
        	a variable

        Returns
        -------
        int
        	the id of the variable

        Raises
        ------
        gum.IndexError
        	If the InfluenceDiagram does not contain the variable

        """
        return _pyAgrum.InfluenceDiagram_double_nodeId(self, var)


    def idFromName(self, name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(self, name) -> gum::NodeId


        Returns a variable's id given its name.

        Parameters
        ----------
        name : str
        	the variable's name from which the id is returned.

        Returns
        -------
        int
        	the variable's node id. 

        Raises
        ------
        gum.NotFound
        	If no such name exists in the graph. 

        """
        return _pyAgrum.InfluenceDiagram_double_idFromName(self, name)


    def variableFromName(self, name: 'std::string const &') -> "gum::DiscreteVariable const &":
        """
        variableFromName(self, name) -> DiscreteVariable


        Parameters
        ----------
        name : str
        	a variable's name

        Returns
        -------
        pyAgrum.DiscreteVariable
        	the variable

        Raises
        ------
        gum.IndexError
        	If the InfluenceDiagram does not contain the variable

        """
        return _pyAgrum.InfluenceDiagram_double_variableFromName(self, name)


    def add(self, variable: 'DiscreteVariable', id: 'gum::NodeId'=0) -> "gum::NodeId":
        """
        add(self, variable, id=0) -> gum::NodeId
        add(self, variable) -> gum::NodeId


        Add a chance variable, it's associate node and it's CPT.

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	The variable added by copy.
        id : int
        	The chosen id. If 0, the NodeGraphPart will choose.

        Warnings
        --------
        give an id (not 0) should be reserved for rare and specific situations !!! 

        Returns
        -------
        int
            the id of the added variable. 

        Raises
        ------
        gum.DuplicateElement
        	If id(<>0) is already used 

        """
        return _pyAgrum.InfluenceDiagram_double_add(self, variable, id)


    def addDecisionNode(self, variable: 'DiscreteVariable', id: 'gum::NodeId'=0) -> "gum::NodeId":
        """
        addDecisionNode(self, variable, id=0) -> gum::NodeId
        addDecisionNode(self, variable) -> gum::NodeId


        Add a decision variable.

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added by copy.
        id : int
        	the chosen id. If 0, the NodeGraphPart will choose.

        Warnings
        --------
        give an id (not 0) should be reserved for rare and specific situations !!! 

        Returns
        -------
        int
            the id of the added variable. 

        Raises
        ------
        gum.DuplicateElement
        	If id(<>0) is already used 

        """
        return _pyAgrum.InfluenceDiagram_double_addDecisionNode(self, variable, id)


    def addChanceNode(self, *args) -> "gum::NodeId":
        """
        addChanceNode(self, variable, id=0) -> gum::NodeId
        addChanceNode(self, variable) -> gum::NodeId
        addChanceNode(self, variable, aContent, id=0) -> gum::NodeId
        addChanceNode(self, variable, aContent) -> gum::NodeId


        Add a chance variable, it's associate node and it's CPT.

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added by copy.
        id : int
        	the chosen id. If 0, the NodeGraphPart will choose.

        Warnings
        --------
        give an id (not 0) should be reserved for rare and specific situations !!! 

        Returns
        -------
        int
            the id of the added variable. 

        Raises
        ------
        gum.DuplicateElement
        	If id(<>0) is already used 

        """
        return _pyAgrum.InfluenceDiagram_double_addChanceNode(self, *args)


    def addUtilityNode(self, *args) -> "gum::NodeId":
        """
        addUtilityNode(self, variable, id=0) -> gum::NodeId
        addUtilityNode(self, variable) -> gum::NodeId
        addUtilityNode(self, variable, aContent, id=0) -> gum::NodeId
        addUtilityNode(self, variable, aContent) -> gum::NodeId


        Add a utility variable, it's associate node and it's UT. 

        The id of the new variable is automatically generated.

        Parameters
        ----------
        variable : pyAgrum.DiscreteVariable
        	the variable added by copy
        id : int
        	the chosen id. If 0, the NodeGraphPart will choose

        Warnings
        --------
        give an id (not 0) should be reserved for rare and specific situations !!! 

        Returns
        -------
        int
            the id of the added variable. 

        Raises
        ------
        gum.InvalidArgument
        	If variable has more than one label
        gum.DuplicateElement
        	If id(<>0) is already used 

        """
        return _pyAgrum.InfluenceDiagram_double_addUtilityNode(self, *args)


    def erase(self, *args) -> "void":
        """
        erase(self, id)
        erase(self, var)


        Erase a Variable from the network and remove the variable from all his childs.

        If no variable matches the id, then nothing is done.

        Parameters
        ----------
        id : int
        	The id of the variable to erase.
        var : pyAgrum.DiscreteVariable
        	The reference on the variable to remove. 

        """
        return _pyAgrum.InfluenceDiagram_double_erase(self, *args)


    def changeVariableName(self, id: 'gum::NodeId', new_name: 'std::string const &') -> "void":
        """
        changeVariableName(self, id, new_name)


        Parameters
        ----------
        id : int
        	the node Id
        new_name : str
        	the name of the variable 

        Raises
        ------
        gum.DuplicateLabel
        	If this name already exists
        gum.NotFound
        	If no nodes matches id. 

        """
        return _pyAgrum.InfluenceDiagram_double_changeVariableName(self, id, new_name)


    def addArc(self, tail: 'gum::NodeId', head: 'gum::NodeId') -> "void":
        """
        addArc(self, tail, head)


        Add an arc in the ID, and update diagram's potential nodes cpt if necessary.

        Parameters
        ----------
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        Raises
        ------
        gum.InvalidEdge
        	If arc.tail and/or arc.head are not in the ID.
        gum.InvalidEdge
        	If tail is a utility node 

        """
        return _pyAgrum.InfluenceDiagram_double_addArc(self, tail, head)


    def eraseArc(self, *args) -> "void":
        """
        eraseArc(self, arc)
        eraseArc(self, tail, head)


        Removes an arc in the ID, and update diagram's potential nodes cpt if necessary.

        If (tail, head) doesn't exist, the nothing happens.

        Parameters
        ----------
        arc : pyAgrum.Arc
        	The arc to be removed.
        tail : int
          the id of the tail node
        head : int
          the id of the head node

        """
        return _pyAgrum.InfluenceDiagram_double_eraseArc(self, *args)


    def decisionOrderExists(self) -> "bool":
        """
        decisionOrderExists(self) -> bool


        Returns
        -------
        bool
        	True if a directed path exist with all decision node

        """
        return _pyAgrum.InfluenceDiagram_double_decisionOrderExists(self)


    def getDecisionGraph(self) -> "gum::DAG *":
        """
        getDecisionGraph(self) -> DAG


        Returns
        -------
        pyAgrum.DAG
        	the temporal Graph. 

        """
        return _pyAgrum.InfluenceDiagram_double_getDecisionGraph(self)


    def getDecisionOrder(self) -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > > *":
        """
        getDecisionOrder(self) -> Vector_int


        Returns
        -------
        list
        	the sequence of decision nodes in the directed path.

        Raises
        ------
        NotFound
        	If such a path does not exist 

        """
        return _pyAgrum.InfluenceDiagram_double_getDecisionOrder(self)


    def existsPathBetween(self, src: 'gum::NodeId', dest: 'gum::NodeId') -> "bool":
        """
        existsPathBetween(self, src, dest) -> bool


        Returns
        -------
        bool
        	true if a path exists between two nodes. 

        """
        return _pyAgrum.InfluenceDiagram_double_existsPathBetween(self, src, dest)


    def names(self) -> "PyObject *":
        """
        names(self) -> PyObject *


        Returns
        -------
        list
        	The names of the InfluenceDiagram variables

        """
        return _pyAgrum.InfluenceDiagram_double_names(self)


    def ids(self) -> "PyObject *":
        """
        ids(self) -> PyObject *


        .. note:: Deprecated in pyAgrum>0.13.0
            Please use nodes() instead

        """
        return _pyAgrum.InfluenceDiagram_double_ids(self)


    def arcs(self) -> "PyObject *":
        """
        arcs(self) -> PyObject *


        Returns
        -------
        list:
        	the list of all the arcs in the Influence Diagram.

        """
        return _pyAgrum.InfluenceDiagram_double_arcs(self)


    def parents(self, id: 'gum::NodeId const') -> "PyObject *":
        """
        parents(self, id) -> PyObject *


        Parameters
        ----------
        id :
        	The id of the child node

        Returns
        -------
        set
            the set of the parents ids.

        """
        return _pyAgrum.InfluenceDiagram_double_parents(self, id)


    def children(self, id: 'gum::NodeId const') -> "PyObject *":
        """
        children(self, id) -> PyObject *


        Parameters
        ----------
        id : int
          the id of the parent

        Returns
        -------
        Set
        	the set of all the children

        """
        return _pyAgrum.InfluenceDiagram_double_children(self, id)


    def loadBIFXML(self, *args) -> "bool":
        """
        loadBIFXML(self, name, l) -> bool
        loadBIFXML(self, name) -> bool


        Load a BIFXML file.

        Parameters
        ----------
        name : str
        	the name's file

        Raises
        ------
        gum.IOError
        	If file not found
        gum.FatalError
        	If file is not valid

        """
        return _pyAgrum.InfluenceDiagram_double_loadBIFXML(self, *args)


    def saveBIFXML(self, name: 'std::string') -> "void":
        """
        saveBIFXML(self, name)


        Save the BayesNet in a BIFXML file.

        Parameters
        ----------
        name : str
        	the file's name

        """
        return _pyAgrum.InfluenceDiagram_double_saveBIFXML(self, name)


    def __repr__(self) -> "std::string":
        """__repr__(self) -> std::string"""
        return _pyAgrum.InfluenceDiagram_double___repr__(self)


    def __str__(self) -> "std::string":
        """__str__(self) -> std::string"""
        return _pyAgrum.InfluenceDiagram_double___str__(self)

InfluenceDiagram_double_swigregister = _pyAgrum.InfluenceDiagram_double_swigregister
InfluenceDiagram_double_swigregister(InfluenceDiagram_double)

class InfluenceDiagramInference_double(_object):
    """Proxy of C++ gum::InfluenceDiagramInference< double > class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, InfluenceDiagramInference_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, InfluenceDiagramInference_double, name)
    __repr__ = _swig_repr

    def __init__(self, infDiag: 'InfluenceDiagram_double'):
        """__init__(self, infDiag) -> InfluenceDiagramInference_double"""
        this = _pyAgrum.new_InfluenceDiagramInference_double(infDiag)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InfluenceDiagramInference_double
    def __del__(self):
        return None

    def makeInference(self) -> "void":
        """
        makeInference(self)


        Makes the inference. 

        """
        return _pyAgrum.InfluenceDiagramInference_double_makeInference(self)


    def getMEU(self) -> "double":
        """
        getMEU(self) -> double


        Returns maximum expected utility obtained from inference.

        Raises
        ------
        gum.OperationNotAllowed
        	If no inference have yet been made 

        """
        return _pyAgrum.InfluenceDiagramInference_double_getMEU(self)


    def getBestDecisionChoice(self, decisionId: 'gum::NodeId') -> "gum::Idx":
        """
        getBestDecisionChoice(self, decisionId) -> gum::Idx


        Returns best choice for decision variable given in parameter ( based upon MEU criteria )

        Parameters
        ----------
        decisionId : int
        	the id of the decision variable

        Raises
        ------
        gum.OperationNotAllowed
        	If no inference have yet been made
        gum.InvalidNode
        	If node given in parmaeter is not a decision node 

        """
        return _pyAgrum.InfluenceDiagramInference_double_getBestDecisionChoice(self, decisionId)


    def displayResult(self) -> "std::string":
        """
        displayResult(self) -> std::string


        Displays the result of an inference.

        """
        return _pyAgrum.InfluenceDiagramInference_double_displayResult(self)


    def insertEvidence(self, evidenceList: 'gum::List< gum::Potential< double > const * > const &') -> "void":
        """
        insertEvidence(self, evidenceList)


        Insert new evidence in the graph.

        Parameters
        ----------
        evidenceList : list
        	a list of potentials as evidences

        Warnings
        --------
        If an evidence already w.r.t. a given node and a new evidence w.r.t. this node is onserted, the old evidence is removed

        Raises
        ------
        gum.OperationNotAllowed
        	If an evidence is over more than one variable

        """
        return _pyAgrum.InfluenceDiagramInference_double_insertEvidence(self, evidenceList)


    def eraseEvidence(self, evidence: 'Potential_double') -> "void":
        """
        eraseEvidence(self, evidence)


        Parameters
        ----------
        evidence : pyAgrum.Potential
        	the evidence to remove

        Raises
        ------
        gum.IndexError
        	If the evidence does not belong to the influence diagram

        """
        return _pyAgrum.InfluenceDiagramInference_double_eraseEvidence(self, evidence)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(self)


        Removes all the evidence entered into the diagram.

        """
        return _pyAgrum.InfluenceDiagramInference_double_eraseAllEvidence(self)


    def displayStrongJunctionTree(self, *args) -> "void":
        """
        displayStrongJunctionTree(self, stream)


        Displays on terminal the result of strong junction tree computation for test purpose only.

        Parameters
        ----------
        args : TBW

        """
        return _pyAgrum.InfluenceDiagramInference_double_displayStrongJunctionTree(self, *args)


    def influenceDiagram(self) -> "gum::InfluenceDiagram< double > const &":
        """
        influenceDiagram(self) -> InfluenceDiagram_double


        Returns a constant reference over the InfluenceDiagram on which this class work.

        Returns
        -------
        pyAgrum.InfluenceDiagram
        	the InfluenceDiagram on which this class work

        """
        return _pyAgrum.InfluenceDiagramInference_double_influenceDiagram(self)


    def setEvidence(self, evidces):
        """
        Erase all the evidences and apply addEvidence(key,value) for every pairs in evidces.

        Parameters
        ----------
        evidces : dict
          a dict of evidences

        Raises
        ------
        gum.InvalidArgument
            If one value is not a value for the node
        gum.InvalidArgument
            If the size of a value is different from the domain side of the node
        gum.FatalError
            If one value is a vector of 0s
        gum.UndefinedElement
            If one node does not belong to the Bayesian network
        """
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be dict, not %s"%(type(evidces)))
        bn = self.influenceDiagram()

    # set evidences
        self.list_pot = []

        try:
          items=evidces.iteritems()
        except AttributeError:
          items=evidces.items()

        for var_name, evidce in items:
            pot = Potential_double()

            if isinstance(var_name, int):
                var = bn.variable(var_name)
            elif isinstance(var_name, str):
                var = bn.variableFromName(var_name)
            else:
                raise TypeError('values of the dict must be int or string')

            pot.add(var)
            if isinstance(evidce, (int, float, str)):
                pot[:] = 0
    # determine the var type
                try:
                    cast_var = var.toLabelizedVar()
                    if isinstance(evidce, int):
                        index = evidce
                    elif isinstance(evidce, str):
                        index = cast_var[evidce]
                    else:
                        raise TypeError('values of the dict must be int or string')
                except RuntimeError:
                    try:
                        cast_var = var.toRangeVar()
                        if isinstance(evidce, int):
                            index = cast_var[str(evidce)]
                        elif isinstance(evidce, str):
                            index = cast_var[evidce]
                        else:
                            raise TypeError('values of the dict must be int or string')
                    except RuntimeError:
                        cast_var = var.toDiscretizedVar()
                        if isinstance(evidce, float):
                            index = cast_var.index(evidce)
                        elif isinstance(evidce, str):
                            index = cast_var.index(float(evidce))
                        else:
                            raise TypeError('values of the dict must be float or string')
                pot[index] = 1
            elif isinstance(evidce, (list, tuple)):
                pot[:] = evidce
            else:
                raise TypeError('dict values must be number, string or sequence')
            self.list_pot.append(pot)

        self.eraseAllEvidence()
        self._setEvidence(self.list_pot)



    def _setEvidence(self, evidences: 'PyObject *') -> "void":
        """_setEvidence(self, evidences)"""
        return _pyAgrum.InfluenceDiagramInference_double__setEvidence(self, evidences)


    def junctionTreeToDot(self) -> "std::string const":
        """
        junctionTreeToDot(self) -> std::string const


        Returns
        -------
        str
        	the result of strong junction tree computation for test purpose only.

        """
        return _pyAgrum.InfluenceDiagramInference_double_junctionTreeToDot(self)

InfluenceDiagramInference_double_swigregister = _pyAgrum.InfluenceDiagramInference_double_swigregister
InfluenceDiagramInference_double_swigregister(InfluenceDiagramInference_double)

class BNLearner_double(_object):
    """

    Available constructors:
    	``BNLearner(filename) -> BNLearner``

    	``BNLearner(filename,src,parse_database=false) -> BNLearner``

    	``BNLearner(learner) -> BNLearner``

    Parameters
    ----------
    filename: str
    	the file to learn from
    src : pyAgrum.BayesNet
    	the Bayesian network used to find thoes modalities
    parse_database : bool
    	if true, the modalities specified by the user will be considered as a superset of the modalities of the variables.
    learner : pyAgrum.BNLearner
    	the BNLearner to copy

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BNLearner_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BNLearner_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, filename, missing_symbols) -> BNLearner_double
        __init__(self, filename) -> BNLearner_double
        __init__(self, db) -> BNLearner_double
        __init__(self, filename, src, missing_symbols) -> BNLearner_double
        __init__(self, filename, src) -> BNLearner_double
        __init__(self, arg2) -> BNLearner_double
        __init__(self, arg2) -> BNLearner_double
        """
        this = _pyAgrum.new_BNLearner_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_BNLearner_double
    def __del__(self):
        return None

    def learnBN(self) -> "gum::BayesNet< double >":
        """
        learnBN(self) -> BayesNet_double


        learn a BayesNet from a file (must have read the db before)

        Returns
        -------
        pyAgrum.BayesNet
        	the learned BayesNet

        """
        return _pyAgrum.BNLearner_double_learnBN(self)


    def learnParameters(self, *args) -> "gum::BayesNet< double >":
        """
        learnParameters(self, dag, take_into_account_score=True) -> BayesNet_double
        learnParameters(self, dag) -> BayesNet_double
        learnParameters(self, bn, take_into_account_score=True) -> BayesNet_double
        learnParameters(self, bn) -> BayesNet_double


        learns a BN (its parameters) when its structure is known.

        Parameters
        ----------
        dag : pyAgrum.DAG
        bn : pyAgrum.BayesNet
        take_into_account_score : bool
        	The dag passed in argument may have been learnt from a structure learning. In this case, if the score used to learn the structure has an implicit apriori (like K2 which has a 1-smoothing apriori), it is important to also take into account this implicit apriori for parameter learning. By default, if a score exists, we will learn parameters by taking into account the apriori specified by methods useAprioriXXX () + the implicit apriori of the score, else we just take into account the apriori specified by useAprioriXXX ()

        Returns
        -------
        pyAgrum.BayesNet
        	the learned BayesNet

        Raises
        ------
        gum.MissingVariableInDatabase
        	If a variable of the BN is not found in the database
        gum.UnknownLabelInDatabase
        	If a label is found in the database that do not correspond to the variable

        """
        return _pyAgrum.BNLearner_double_learnParameters(self, *args)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(self, v)


        Parameters
        ----------
        v : bool
        	verbosity

        """
        return _pyAgrum.BNLearner_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(self, eps)


        Parameters
        ----------
        eps : double
        	the epsilon we want to use

        Raises
        ------
        gum.OutOfLowerBound
        	If eps<0

        """
        return _pyAgrum.BNLearner_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(self, rate)


        Parameters
        ----------
        rate : double
        	the minimal epsilon rate

        """
        return _pyAgrum.BNLearner_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(self, max)


        Parameters
        ----------
        max : int
        	the maximum number of iteration

        Raises
        ------
        gum.OutOfLowerBound
        	If max <= 1

        """
        return _pyAgrum.BNLearner_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(self, timeout)


        Parameters
        ----------
        tiemout : double
        	stopping criterion on timeout (in seconds)

        Raises
        ------
        gum.OutOfLowerBound
        	If timeout<=0.0

        """
        return _pyAgrum.BNLearner_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(self, p)


        Parameters
        ----------
        p : int
        	number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.BNLearner_double_setPeriodSize(self, p)


    def verbosity(self) -> "bool":
        """
        verbosity(self) -> bool


        Returns
        -------
        bool
        	True if the verbosity is enabled

        """
        return _pyAgrum.BNLearner_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(self) -> double


        Returns
        -------
        double
        	the value of epsilon

        """
        return _pyAgrum.BNLearner_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(self) -> double


        Returns
        -------
        double
        	the value of the minimal epsilon rate

        """
        return _pyAgrum.BNLearner_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(self) -> gum::Size


        Returns
        -------
        int
        	the criterion on number of iterations

        """
        return _pyAgrum.BNLearner_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(self) -> double


        Returns
        -------
        double
        	the timeout(in seconds)

        """
        return _pyAgrum.BNLearner_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(self) -> gum::Size


        Returns
        -------
        int
        	the number of samples between 2 stopping

        Raises
        ------
        gum.OutOfLowerBound
        	If p<1

        """
        return _pyAgrum.BNLearner_double_periodSize(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(self) -> gum::Size


        Returns
        -------
        int
        	the number of iterations

        """
        return _pyAgrum.BNLearner_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(self) -> double


        Returns
        -------
        double
        	get the current running time in second (double)

        """
        return _pyAgrum.BNLearner_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(self) -> std::string


        Returns
        -------
        str
        	the approximation scheme message

        """
        return _pyAgrum.BNLearner_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(self) -> Vector_double


        Returns
        -------
        tuple
        	the scheme history

        Raises
        ------
        gum.OperationNotAllowed
        	If the scheme did not performed or if verbosity is set to false

        """
        return _pyAgrum.BNLearner_double_history(self)


    def asIApproximationSchemeConfiguration(self) -> "gum::IApproximationSchemeConfiguration const &":
        """
        asIApproximationSchemeConfiguration(self) -> IApproximationSchemeConfiguration


        Returns
        -------
        asIApproximationSchemeConfiguration

        """
        return _pyAgrum.BNLearner_double_asIApproximationSchemeConfiguration(self)


    def learnDAG(self) -> "gum::DAG":
        """
        learnDAG(self) -> DAG


        learn a structure from a file (must have read the db before)

        Returns
        -------
        pyAgrum.DAG
        	the learned DAG

        """
        return _pyAgrum.BNLearner_double_learnDAG(self)


    def names(self) -> "std::vector< std::string,std::allocator< std::string > > const &":
        """
        names(self) -> Vector_string


        Returns
        -------
        str
        	the names of the variables in the database

        """
        return _pyAgrum.BNLearner_double_names(self)


    def modalities(self) -> "std::vector< gum::Size,std::allocator< gum::Size > > const &":
        """
        modalities(self) -> std::vector< gum::Size,std::allocator< gum::Size > > const &


        Returns
        -------
        vector<pos,size>
        	the number of modalities of the database's variables.

        """
        return _pyAgrum.BNLearner_double_modalities(self)


    def idFromName(self, var_name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(self, var_name) -> gum::NodeId


        Parameters
        ----------
        var_names : str
        	a variable's name

        Returns
        -------
        int
        	the node id corresponding to a variable name

        Raises
        ------
        gum.MissingVariableInDatabase
        	If a variable of the BN is not found in the database.

        """
        return _pyAgrum.BNLearner_double_idFromName(self, var_name)


    def nameFromId(self, id: 'gum::NodeId') -> "std::string const &":
        """
        nameFromId(self, id) -> std::string const &


        Parameters
        ----------
        id
        	a node id

        Returns
        -------
        str
        	the variable's name

        """
        return _pyAgrum.BNLearner_double_nameFromId(self, id)


    def useScoreAIC(self) -> "void":
        """
        useScoreAIC(self)


        Indicate that we wish to use an AIC score.

        """
        return _pyAgrum.BNLearner_double_useScoreAIC(self)


    def useScoreBD(self) -> "void":
        """
        useScoreBD(self)


        Indicate that we wish to use a BD score.

        """
        return _pyAgrum.BNLearner_double_useScoreBD(self)


    def useScoreBDeu(self) -> "void":
        """
        useScoreBDeu(self)


        Indicate that we wish to use a BDeu score.

        """
        return _pyAgrum.BNLearner_double_useScoreBDeu(self)


    def useScoreBIC(self) -> "void":
        """
        useScoreBIC(self)


        Indicate that we wish to use a BIC score.

        """
        return _pyAgrum.BNLearner_double_useScoreBIC(self)


    def useScoreK2(self) -> "void":
        """
        useScoreK2(self)


        Indicate that we wish to use a K2 score.

        """
        return _pyAgrum.BNLearner_double_useScoreK2(self)


    def useScoreLog2Likelihood(self) -> "void":
        """
        useScoreLog2Likelihood(self)


        Indicate that we wish to use a Log2Likelihood score.

        """
        return _pyAgrum.BNLearner_double_useScoreLog2Likelihood(self)


    def setAprioriWeight(self, weight: 'double') -> "void":
        """
        setAprioriWeight(self, weight)


        Parameters
        ----------
        weight : double
        	the apriori weight

        """
        return _pyAgrum.BNLearner_double_setAprioriWeight(self, weight)


    def useNoApriori(self) -> "void":
        """
        useNoApriori(self)


        Use no apriori.

        """
        return _pyAgrum.BNLearner_double_useNoApriori(self)


    def useAprioriSmoothing(self, *args) -> "void":
        """
        useAprioriSmoothing(self, weight=-1)
        useAprioriSmoothing(self)


        Use the apriori smoothing.

        Parameters
        ----------
        weight : double
        	pass in argument a weight if you wish to assign a weight to the smoothing, else the current weight of the learner will be used.

        """
        return _pyAgrum.BNLearner_double_useAprioriSmoothing(self, *args)


    def useAprioriDirichlet(self, filename: 'std::string const &') -> "void":
        """
        useAprioriDirichlet(self, filename)


        Use the Dirichlet apriori.

        Parameters
        ----------
        filename : str
        	the Dirichlet related database

        """
        return _pyAgrum.BNLearner_double_useAprioriDirichlet(self, filename)


    def useGreedyHillClimbing(self) -> "void":
        """
        useGreedyHillClimbing(self)


        Indicate that we wish to use a greedy hill climbing algorithm.

        """
        return _pyAgrum.BNLearner_double_useGreedyHillClimbing(self)


    def useLocalSearchWithTabuList(self, *args) -> "void":
        """
        useLocalSearchWithTabuList(self, tabu_size=100, nb_decrease=2)
        useLocalSearchWithTabuList(self, tabu_size=100)
        useLocalSearchWithTabuList(self)


        Indicate that we wish to use a local search with tabu list

        Parameters
        ----------
        tabu_size : int
        	The size of the tabu list
        nb_decrease : int
        	The max number of changes decreasing the score consecutively that we allow to apply

        """
        return _pyAgrum.BNLearner_double_useLocalSearchWithTabuList(self, *args)


    def useK2(self, *args) -> "void":
        """
        useK2(self, l)
        useK2(self, order)
        useK2(self, order)


        Indicate that we wish to use K2.

        Parameters
        ----------
        order : list
        	a list of ids

        """
        return _pyAgrum.BNLearner_double_useK2(self, *args)


    def setMaxIndegree(self, max_indegree: 'gum::Size') -> "void":
        """
        setMaxIndegree(self, max_indegree)


        Parameters
        ----------
        max_indegree : int
        	the limit number of parents

        """
        return _pyAgrum.BNLearner_double_setMaxIndegree(self, max_indegree)


    def setSliceOrder(self, *args) -> "void":
        """
        setSliceOrder(self, l)
        setSliceOrder(self, slice_order)


        Set a partial order on the nodes.

        Parameters
        ----------
        l : list
        	a list of sequences (composed of ids)

        """
        return _pyAgrum.BNLearner_double_setSliceOrder(self, *args)


    def addForbiddenArc(self, *args) -> "void":
        """
        addForbiddenArc(self, arc)
        addForbiddenArc(self, tail, head)
        addForbiddenArc(self, tail, head)


        The arc in parameters won't be added.

        Parameters
        ----------
        arc : pyAgrum
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BNLearner_double_addForbiddenArc(self, *args)


    def eraseForbiddenArc(self, *args) -> "void":
        """
        eraseForbiddenArc(self, arc)
        eraseForbiddenArc(self, tail, head)
        eraseForbiddenArc(self, tail, head)


        Allow the arc in parameter to be added if necessary.

        Parameters
        ----------
        arc : pyAgrum
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BNLearner_double_eraseForbiddenArc(self, *args)


    def addMandatoryArc(self, *args) -> "void":
        """
        addMandatoryArc(self, arc)
        addMandatoryArc(self, tail, head)
        addMandatoryArc(self, tail, head)


        Allow to add prior structural knowledge.

        Parameters
        ----------
        arc : pyAgrum
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        Raises
        ------
        gum.InvalidDirectedCycle
        	If the added arc creates a directed cycle in the DAG

        """
        return _pyAgrum.BNLearner_double_addMandatoryArc(self, *args)


    def eraseMandatoryArc(self, *args) -> "void":
        """
        eraseMandatoryArc(self, arc)
        eraseMandatoryArc(self, tail, head)
        eraseMandatoryArc(self, tail, head)


        Parameters
        ----------
        arc : pyAgrum
        	an arc
        head :
        	a variable's id (int)
        tail :
        	a variable's id (int)
        head :
        	a variable's name (str)
        tail :
        	a variable's name (str)

        """
        return _pyAgrum.BNLearner_double_eraseMandatoryArc(self, *args)


    def setInitialDAG(self, g: 'DAG') -> "void":
        """
        setInitialDAG(self, g)


        Parameters
        ----------
        dag : pyAgrum.DAG
        	an initial DAG structure

        """
        return _pyAgrum.BNLearner_double_setInitialDAG(self, g)


    def use3off2(self) -> "void":
        """
        use3off2(self)


        Indicate that we wish to use 3off2.

        """
        return _pyAgrum.BNLearner_double_use3off2(self)


    def useMIIC(self) -> "void":
        """
        useMIIC(self)


        Indicate that we wish to use MIIC.

        """
        return _pyAgrum.BNLearner_double_useMIIC(self)


    def useNML(self) -> "void":
        """
        useNML(self)


        Indicate that we wish to use the NML correction for 3off2 or MIIC

        """
        return _pyAgrum.BNLearner_double_useNML(self)


    def useMDL(self) -> "void":
        """
        useMDL(self)


        Indicate that we wish to use the MDL correction for 3off2 or MIIC

        """
        return _pyAgrum.BNLearner_double_useMDL(self)


    def useNoCorr(self) -> "void":
        """
        useNoCorr(self)


        Indicate that we wish to use the NoCorr correction for 3off2 or MIIC

        """
        return _pyAgrum.BNLearner_double_useNoCorr(self)


    def latentVariables(self, *args) -> "std::vector< gum::Arc,std::allocator< gum::Arc > > const":
        """
        latentVariables(self) -> PyObject
        latentVariables(self) -> std::vector< gum::Arc,std::allocator< gum::Arc > > const


        Warnings
        --------
        learner must be using 3off2 or MIIC algorithm

        Returns
        -------
        list
        	the list of latent variables

        """
        return _pyAgrum.BNLearner_double_latentVariables(self, *args)


    def learnMixedStructure(self) -> "gum::MixedGraph":
        """
        learnMixedStructure(self) -> MixedGraph


        Warnings
        --------
        learner must be using 3off2 or MIIC algorithm

        Returns
        -------
        pyAgrum.EssentialGraph
        	the learned structure as an EssentialGraph

        """
        val = _pyAgrum.BNLearner_double_learnMixedStructure(self)

        bn=BayesNet()
        for i in range(len(self.names())):
          bn.add(self.nameFromId(i),2)
        ge=EssentialGraph(bn,val)
        ge._bn=bn
        return ge


        return val

BNLearner_double_swigregister = _pyAgrum.BNLearner_double_swigregister
BNLearner_double_swigregister(BNLearner_double)

class BNDatabaseGenerator_double(_object):
    """Proxy of C++ gum::learning::BNDatabaseGenerator< double > class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BNDatabaseGenerator_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BNDatabaseGenerator_double, name)
    __repr__ = _swig_repr

    def __init__(self, bn: 'BayesNet_double'):
        """__init__(self, bn) -> BNDatabaseGenerator_double"""
        this = _pyAgrum.new_BNDatabaseGenerator_double(bn)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_BNDatabaseGenerator_double
    def __del__(self):
        return None

    def drawSamples(self, nbSamples: 'gum::Size') -> "double":
        """drawSamples(self, nbSamples) -> double"""
        return _pyAgrum.BNDatabaseGenerator_double_drawSamples(self, nbSamples)


    def toCSV(self, *args) -> "void":
        """
        toCSV(self, csvFileURL, useLabels=True, append=False, csvSeparator, checkOnAppend=False)
        toCSV(self, csvFileURL, useLabels=True, append=False, csvSeparator)
        toCSV(self, csvFileURL, useLabels=True, append=False)
        toCSV(self, csvFileURL, useLabels=True)
        toCSV(self, csvFileURL)
        """
        return _pyAgrum.BNDatabaseGenerator_double_toCSV(self, *args)


    def toDatabaseTable(self, useLabels: 'bool'=True) -> "gum::learning::DatabaseTable< >":
        """
        toDatabaseTable(self, useLabels=True) -> gum::learning::DatabaseTable< >
        toDatabaseTable(self) -> gum::learning::DatabaseTable< >
        """
        return _pyAgrum.BNDatabaseGenerator_double_toDatabaseTable(self, useLabels)


    def database(self) -> "std::vector< std::vector< gum::Idx,std::allocator< gum::Idx > >,std::allocator< std::vector< gum::Idx,std::allocator< gum::Idx > > > >":
        """database(self) -> std::vector< std::vector< gum::Idx,std::allocator< gum::Idx > >,std::allocator< std::vector< gum::Idx,std::allocator< gum::Idx > > > >"""
        return _pyAgrum.BNDatabaseGenerator_double_database(self)


    def setVarOrder(self, *args) -> "void":
        """
        setVarOrder(self, varOrder)
        setVarOrder(self, varOrder)
        """
        return _pyAgrum.BNDatabaseGenerator_double_setVarOrder(self, *args)


    def setVarOrderFromCSV(self, *args) -> "void":
        """
        setVarOrderFromCSV(self, csvFileURL, csvSeparator)
        setVarOrderFromCSV(self, csvFileURL)
        """
        return _pyAgrum.BNDatabaseGenerator_double_setVarOrderFromCSV(self, *args)


    def setTopologicalVarOrder(self) -> "void":
        """setTopologicalVarOrder(self)"""
        return _pyAgrum.BNDatabaseGenerator_double_setTopologicalVarOrder(self)


    def setAntiTopologicalVarOrder(self) -> "void":
        """setAntiTopologicalVarOrder(self)"""
        return _pyAgrum.BNDatabaseGenerator_double_setAntiTopologicalVarOrder(self)


    def setRandomVarOrder(self) -> "void":
        """setRandomVarOrder(self)"""
        return _pyAgrum.BNDatabaseGenerator_double_setRandomVarOrder(self)


    def varOrder(self) -> "std::vector< gum::Idx,std::allocator< gum::Idx > >":
        """varOrder(self) -> std::vector< gum::Idx,std::allocator< gum::Idx > >"""
        return _pyAgrum.BNDatabaseGenerator_double_varOrder(self)


    def varOrderNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        """varOrderNames(self) -> Vector_string"""
        return _pyAgrum.BNDatabaseGenerator_double_varOrderNames(self)


    def log2likelihood(self) -> "double":
        """log2likelihood(self) -> double"""
        return _pyAgrum.BNDatabaseGenerator_double_log2likelihood(self)

BNDatabaseGenerator_double_swigregister = _pyAgrum.BNDatabaseGenerator_double_swigregister
BNDatabaseGenerator_double_swigregister(BNDatabaseGenerator_double)


def statsObj() -> "void":
    """statsObj()"""
    return _pyAgrum.statsObj()

Potential = Potential_double

randomDistribution = randomDistribution_double

SimpleBayesNet = IBayesNet_double
BayesNet = BayesNet_double

LazyPropagation = LazyPropagation_double
ShaferShenoyInference = ShaferShenoyInference_double
VariableElimination = VariableElimination_double

GibbsSampling = GibbsSampling_double
ImportanceSampling=ImportanceSampling_double
WeightedSampling=WeightedSampling_double
MonteCarloSampling=MonteCarloSampling_double
LoopyImportanceSampling=LoopyImportanceSampling_double
LoopyGibbsSampling=LoopyGibbsSampling_double
LoopyWeightedSampling=LoopyWeightedSampling_double
LoopyMonteCarloSampling=LoopyMonteCarloSampling_double

LoopyBeliefPropagation = LoopyBeliefPropagation_double

BruteForceKL = BruteForceKL_double
GibbsKL = GibbsKL_double

CredalNet = CredalNet_double
CNMonteCarloSampling = CNMonteCarloSampling_double
CNLoopyPropagation = CNLoopyPropagation_double

DiscretizedVariable = DiscretizedVariable_double

InfluenceDiagram = InfluenceDiagram_double
InfluenceDiagramInference = InfluenceDiagramInference_double

BNLearner =  BNLearner_double
BNDatabaseGenerator = BNDatabaseGenerator_double

# This file is compatible with both classic and new-style classes.


