/***************************************************************************
 *  aGrUM modified frames and atg files for cocoR
 *   Copyright (c) 2005 by Christophe GONZALES and Pierre-Henri WUILLEMIN  *
 *   {prenom.nom}_at_lip6.fr
***************************************************************************/
/*----------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported to C++ by Csaba Balazs, University of Szeged
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than
Coco/R itself) does not fall under the GNU General Public License.
-----------------------------------------------------------------------*/


#if !defined(gum_formula_COCO_PARSER_H__)
#define gum_formula_COCO_PARSER_H__

#include <algorithm>
#include <cmath>
#include <fstream>
#include <list>
#include <memory>
#include <sstream>
#include <stack>
#include <string>
#include <vector>

#include <agrum/core/utils_dir.h>
#include <agrum/core/math/formula.h>

#include <iostream>
#include <string>
#include <fstream>
#include "Scanner.h"

namespace gum {
namespace formula {


class Parser {
  private:
    	enum {
		_EOF=0,
		_integer=1,
		_float=2,
		_scifloat=3,
		_operator=4,
		_eol=5,
		_ident=6
	};
	int maxT;

    Token* dummyToken;
    int errDist;
    int minErrDist;

    void SynErr( int n );
    void Get();
    void Expect( int n );
    bool StartOf( int s );
    void ExpectWeak( int n, int follow );
    bool WeakSeparator( int n, int syFol, int repFol );

    ErrorsContainer  __errors;

  public:
    Scanner* scanner;

    Token* t;     // last recognized token
    Token* la;      // lookahead token

    private:
  gum::Formula* __formula;

public:
  void formula( gum::Formula* f ) {
    __formula = f;
  }

  gum::Formula& formula() { 
    return *__formula; 
  }

  const gum::Formula& formula() const {
    return *__formula; 
  }

// =============================================================================
//                              SCANNER RULES
// =============================================================================

//________________________

    Parser( Scanner* scanner );
    ~Parser();
    void SemErr( const wchar_t* msg );
    void SynErr( const std::wstring& filename,int line, int col, int n );
    void Warning( const wchar_t* msg );
    const ErrorsContainer& errors() const;
    ErrorsContainer& errors();

    	void EVAL();
	void expression();

    void Parse();

}; // end Parser

} // namespace
} // namespace


#endif // !defined(COCO_PARSER_H__)

