/***************************************************************************
 *  aGrUM modified frames and atg files for cocoR
 *   Copyright (c) 2005 by Christophe GONZALES and Pierre-Henri WUILLEMIN  *
 *   {prenom.nom}_at_lip6.fr
***************************************************************************/
/*----------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported to C++ by Csaba Balazs, University of Szeged
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than
Coco/R itself) does not fall under the GNU General Public License.
-----------------------------------------------------------------------*/


#if !defined(gum_prm_o3prmr_COCO_PARSER_H__)
#define gum_prm_o3prmr_COCO_PARSER_H__

#include <string>
#include <sstream>
#include <algorithm>
#include <fstream>


#include <agrum/PRM/o3prmr/O3prmrContext.h>


#ifdef HAVE_DIRENT_H
#include <dirent.h>
#else
#include <agrum/core/mvsc/dirent.h>
#endif

#include <iostream>
#include <string>
#include <fstream>
#include "Scanner.h"

namespace gum {
namespace prm {
namespace o3prmr {


class Parser {
  private:
    	enum {
		_EOF=0,
		_integer=1,
		_float=2,
		_word=3,
		_eol=4,
		_package=5,
		_import=6,
		_request=7,
		_query=8,
		_unobserve=9,
		_engine=10,
		_grd_engine=11,
		_as=12,
		_default=13,
		_and=14
	};
	int maxT;

    Token* dummyToken;
    int errDist;
    int minErrDist;

    void SynErr( int n );
    void Get();
    void Expect( int n );
    bool StartOf( int s );
    void ExpectWeak( int n, int follow );
    bool WeakSeparator( int n, int syFol, int repFol );

    ErrorsContainer  __errors;

  public:
    Scanner* scanner;

    Token* t;     // last recognized token
    Token* la;      // lookahead token

    gum::prm::o3prmr::O3prmrContext<double> *__context;
gum::prm::o3prmr::O3prmrSession<double> *__currentSession;

void SemErr(std::string s) {
  SemErr(widen(s).c_str());
}

void setO3prmrContext(gum::prm::o3prmr::O3prmrContext<double> *c) {
  __context=c;
}

//=====================

    Parser( Scanner* scanner );
    ~Parser();
    void SemErr( const wchar_t* msg );
    void SynErr( const std::wstring& filename,int line, int col, int n );
    void Warning( const wchar_t* msg );
    const ErrorsContainer& errors() const;
    ErrorsContainer& errors();

    	void o3prmr();
	void Ident(std::string& s);
	void RequestBloc();
	void Command();
	void Observe();
	void Unobserve();
	void Query();
	void SetEngine();
	void SetGrdEngine();
	void IdentArray(std::string& s);

    void Parse();

}; // end Parser

} // namespace
} // namespace
} // namespace


#endif // !defined(COCO_PARSER_H__)

