# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
pyAgrum is a Python wrapper for the C++ aGrUM library. It provides a high-level
interface to the part of agrum allowing to create, handle and make computations
into Bayesian Networks. The module is mainly generated by the SWIG
interface generator.
"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_pyAgrum')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_pyAgrum')
    _pyAgrum = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_pyAgrum', [dirname(__file__)])
        except ImportError:
            import _pyAgrum
            return _pyAgrum
        try:
            _mod = imp.load_module('_pyAgrum', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _pyAgrum = swig_import_helper()
    del swig_import_helper
else:
    import _pyAgrum
del _swig_python_version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self) -> "PyObject *":
        """
        value(SwigPyIterator self) -> PyObject *

        Parameters
        ----------
        self: swig::SwigPyIterator const *

        """
        return _pyAgrum.SwigPyIterator_value(self)


    def incr(self, n: 'size_t'=1) -> "swig::SwigPyIterator *":
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator

        Parameters
        ----------
        n: size_t

        incr(SwigPyIterator self) -> SwigPyIterator

        Parameters
        ----------
        self: swig::SwigPyIterator *

        """
        return _pyAgrum.SwigPyIterator_incr(self, n)


    def decr(self, n: 'size_t'=1) -> "swig::SwigPyIterator *":
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator

        Parameters
        ----------
        n: size_t

        decr(SwigPyIterator self) -> SwigPyIterator

        Parameters
        ----------
        self: swig::SwigPyIterator *

        """
        return _pyAgrum.SwigPyIterator_decr(self, n)


    def distance(self, x: 'SwigPyIterator') -> "ptrdiff_t":
        """
        distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t

        Parameters
        ----------
        x: swig::SwigPyIterator const &

        """
        return _pyAgrum.SwigPyIterator_distance(self, x)


    def equal(self, x: 'SwigPyIterator') -> "bool":
        """
        equal(SwigPyIterator self, SwigPyIterator x) -> bool

        Parameters
        ----------
        x: swig::SwigPyIterator const &

        """
        return _pyAgrum.SwigPyIterator_equal(self, x)


    def copy(self) -> "swig::SwigPyIterator *":
        """
        copy(SwigPyIterator self) -> SwigPyIterator

        Parameters
        ----------
        self: swig::SwigPyIterator const *

        """
        return _pyAgrum.SwigPyIterator_copy(self)


    def next(self) -> "PyObject *":
        """
        next(SwigPyIterator self) -> PyObject *

        Parameters
        ----------
        self: swig::SwigPyIterator *

        """
        return _pyAgrum.SwigPyIterator_next(self)


    def __next__(self) -> "PyObject *":
        """
        __next__(SwigPyIterator self) -> PyObject *

        Parameters
        ----------
        self: swig::SwigPyIterator *

        """
        return _pyAgrum.SwigPyIterator___next__(self)


    def previous(self) -> "PyObject *":
        """
        previous(SwigPyIterator self) -> PyObject *

        Parameters
        ----------
        self: swig::SwigPyIterator *

        """
        return _pyAgrum.SwigPyIterator_previous(self)


    def advance(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator *":
        """
        advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator

        Parameters
        ----------
        n: ptrdiff_t

        """
        return _pyAgrum.SwigPyIterator_advance(self, n)


    def __eq__(self, x: 'SwigPyIterator') -> "bool":
        """
        __eq__(SwigPyIterator self, SwigPyIterator x) -> bool

        Parameters
        ----------
        x: swig::SwigPyIterator const &

        """
        return _pyAgrum.SwigPyIterator___eq__(self, x)


    def __ne__(self, x: 'SwigPyIterator') -> "bool":
        """
        __ne__(SwigPyIterator self, SwigPyIterator x) -> bool

        Parameters
        ----------
        x: swig::SwigPyIterator const &

        """
        return _pyAgrum.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator &":
        """
        __iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator

        Parameters
        ----------
        n: ptrdiff_t

        """
        return _pyAgrum.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator &":
        """
        __isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator

        Parameters
        ----------
        n: ptrdiff_t

        """
        return _pyAgrum.SwigPyIterator___isub__(self, n)


    def __add__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator *":
        """
        __add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator

        Parameters
        ----------
        n: ptrdiff_t

        """
        return _pyAgrum.SwigPyIterator___add__(self, n)


    def __sub__(self, *args) -> "ptrdiff_t":
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator

        Parameters
        ----------
        n: ptrdiff_t

        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t

        Parameters
        ----------
        x: swig::SwigPyIterator const &

        """
        return _pyAgrum.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _pyAgrum.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


import numpy

class JTGenerator(_object):
    """Proxy of C++ JTGenerator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, JTGenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, JTGenerator, name)
    __repr__ = _swig_repr

    def junctionTree(self, *args) -> "gum::JunctionTree":
        """
        junctionTree(JTGenerator self, UndiGraph g) -> CliqueGraph

        Parameters
        ----------
        g: gum::UndiGraph const &

        junctionTree(JTGenerator self, BayesNet_double bn) -> CliqueGraph

        Parameters
        ----------
        bn: gum::BayesNet< double > const &

        """
        return _pyAgrum.JTGenerator_junctionTree(self, *args)


    def binaryJoinTree(self, *args) -> "gum::JunctionTree":
        """
        binaryJoinTree(JTGenerator self, UndiGraph g) -> CliqueGraph

        Parameters
        ----------
        g: gum::UndiGraph const &

        binaryJoinTree(JTGenerator self, BayesNet_double bn) -> CliqueGraph

        Parameters
        ----------
        bn: gum::BayesNet< double > const &

        """
        return _pyAgrum.JTGenerator_binaryJoinTree(self, *args)


    def __init__(self):
        """__init__(JTGenerator self) -> JTGenerator"""
        this = _pyAgrum.new_JTGenerator()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_JTGenerator
    __del__ = lambda self: None
JTGenerator_swigregister = _pyAgrum.JTGenerator_swigregister
JTGenerator_swigregister(JTGenerator)

class PythonBNListener(_object):
    """Proxy of C++ PythonBNListener class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PythonBNListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PythonBNListener, name)
    __repr__ = _swig_repr

    def __init__(self, g: 'DiGraph', vnm: 'VariableNodeMap'):
        """
        __init__(PythonBNListener self, DiGraph g, VariableNodeMap vnm) -> PythonBNListener

        Parameters
        ----------
        g: gum::DiGraph *
        vnm: gum::VariableNodeMap const *

        """
        this = _pyAgrum.new_PythonBNListener(g, vnm)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PythonBNListener
    __del__ = lambda self: None

    def whenNodeAdded(self, source: 'void const *', id: 'gum::NodeId') -> "void":
        """
        whenNodeAdded(PythonBNListener self, void const * source, gum::NodeId id)

        Parameters
        ----------
        source: void const *
        id: gum::NodeId

        """
        return _pyAgrum.PythonBNListener_whenNodeAdded(self, source, id)


    def whenNodeDeleted(self, arg2: 'void const *', id: 'gum::NodeId') -> "void":
        """
        whenNodeDeleted(PythonBNListener self, void const * arg2, gum::NodeId id)

        Parameters
        ----------
        arg2: void const *
        id: gum::NodeId

        """
        return _pyAgrum.PythonBNListener_whenNodeDeleted(self, arg2, id)


    def whenArcAdded(self, arg2: 'void const *', src: 'gum::NodeId', dst: 'gum::NodeId') -> "void":
        """
        whenArcAdded(PythonBNListener self, void const * arg2, gum::NodeId src, gum::NodeId dst)

        Parameters
        ----------
        arg2: void const *
        src: gum::NodeId
        dst: gum::NodeId

        """
        return _pyAgrum.PythonBNListener_whenArcAdded(self, arg2, src, dst)


    def whenArcDeleted(self, arg2: 'void const *', src: 'gum::NodeId', dst: 'gum::NodeId') -> "void":
        """
        whenArcDeleted(PythonBNListener self, void const * arg2, gum::NodeId src, gum::NodeId dst)

        Parameters
        ----------
        arg2: void const *
        src: gum::NodeId
        dst: gum::NodeId

        """
        return _pyAgrum.PythonBNListener_whenArcDeleted(self, arg2, src, dst)


    def setWhenArcAdded(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenArcAdded(PythonBNListener self, PyObject * pyfunc)

        Parameters
        ----------
        pyfunc: PyObject *

        """
        return _pyAgrum.PythonBNListener_setWhenArcAdded(self, pyfunc)


    def setWhenArcDeleted(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenArcDeleted(PythonBNListener self, PyObject * pyfunc)

        Parameters
        ----------
        pyfunc: PyObject *

        """
        return _pyAgrum.PythonBNListener_setWhenArcDeleted(self, pyfunc)


    def setWhenNodeAdded(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenNodeAdded(PythonBNListener self, PyObject * pyfunc)

        Parameters
        ----------
        pyfunc: PyObject *

        """
        return _pyAgrum.PythonBNListener_setWhenNodeAdded(self, pyfunc)


    def setWhenNodeDeleted(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenNodeDeleted(PythonBNListener self, PyObject * pyfunc)

        Parameters
        ----------
        pyfunc: PyObject *

        """
        return _pyAgrum.PythonBNListener_setWhenNodeDeleted(self, pyfunc)

PythonBNListener_swigregister = _pyAgrum.PythonBNListener_swigregister
PythonBNListener_swigregister(PythonBNListener)

class PythonLoadListener(_object):
    """Proxy of C++ PythonLoadListener class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PythonLoadListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PythonLoadListener, name)
    __repr__ = _swig_repr

    def whenLoading(self, buffer: 'void const *', percent: 'int') -> "void":
        """
        whenLoading(PythonLoadListener self, void const * buffer, int percent)

        Parameters
        ----------
        buffer: void const *
        percent: int

        """
        return _pyAgrum.PythonLoadListener_whenLoading(self, buffer, percent)


    def setPythonListener(self, l: 'PyObject *') -> "bool":
        """
        setPythonListener(PythonLoadListener self, PyObject * l) -> bool

        Parameters
        ----------
        l: PyObject *

        """
        return _pyAgrum.PythonLoadListener_setPythonListener(self, l)


    def __init__(self):
        """__init__(PythonLoadListener self) -> PythonLoadListener"""
        this = _pyAgrum.new_PythonLoadListener()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PythonLoadListener
    __del__ = lambda self: None
PythonLoadListener_swigregister = _pyAgrum.PythonLoadListener_swigregister
PythonLoadListener_swigregister(PythonLoadListener)


def __fillLoadListeners(py_listener: 'std::vector< PythonLoadListener,std::allocator< PythonLoadListener > > &', l: 'PyObject *') -> "int":
    """
    __fillLoadListeners(std::vector< PythonLoadListener,std::allocator< PythonLoadListener > > & py_listener, PyObject * l) -> int

    Parameters
    ----------
    py_listener: std::vector< PythonLoadListener,std::allocator< PythonLoadListener > > &
    l: PyObject *

    """
    return _pyAgrum.__fillLoadListeners(py_listener, l)
class PythonApproximationListener(_object):
    """Proxy of C++ PythonApproximationListener class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PythonApproximationListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PythonApproximationListener, name)
    __repr__ = _swig_repr

    def __init__(self, algo: 'IApproximationSchemeConfiguration'):
        """
        __init__(PythonApproximationListener self, IApproximationSchemeConfiguration algo) -> PythonApproximationListener

        Parameters
        ----------
        algo: gum::IApproximationSchemeConfiguration &

        """
        this = _pyAgrum.new_PythonApproximationListener(algo)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PythonApproximationListener
    __del__ = lambda self: None

    def whenProgress(self, src: 'void const *', step: 'gum::Size const', error: 'double const', duration: 'double const') -> "void":
        """
        whenProgress(PythonApproximationListener self, void const * src, gum::Size const step, double const error, double const duration)

        Parameters
        ----------
        src: void const *
        step: gum::Size const
        error: double const
        duration: double const

        """
        return _pyAgrum.PythonApproximationListener_whenProgress(self, src, step, error, duration)


    def whenStop(self, src: 'void const *', message: 'std::string const') -> "void":
        """
        whenStop(PythonApproximationListener self, void const * src, std::string const message)

        Parameters
        ----------
        src: void const *
        message: std::string const

        """
        return _pyAgrum.PythonApproximationListener_whenStop(self, src, message)


    def setWhenProgress(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenProgress(PythonApproximationListener self, PyObject * pyfunc)

        Parameters
        ----------
        pyfunc: PyObject *

        """
        return _pyAgrum.PythonApproximationListener_setWhenProgress(self, pyfunc)


    def setWhenStop(self, pyfunc: 'PyObject *') -> "void":
        """
        setWhenStop(PythonApproximationListener self, PyObject * pyfunc)

        Parameters
        ----------
        pyfunc: PyObject *

        """
        return _pyAgrum.PythonApproximationListener_setWhenStop(self, pyfunc)

PythonApproximationListener_swigregister = _pyAgrum.PythonApproximationListener_swigregister
PythonApproximationListener_swigregister(PythonApproximationListener)

class BNGenerator(_object):
    """Proxy of C++ BNGenerator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BNGenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BNGenerator, name)
    __repr__ = _swig_repr

    def generate(self, n_nodes: 'gum::Size'=10, n_arcs: 'gum::Size'=15, n_modmax: 'gum::Size'=4) -> "gum::BayesNet< double >":
        """
        generate(BNGenerator self, gum::Size n_nodes=10, gum::Size n_arcs=15, gum::Size n_modmax=4) -> BayesNet_double

        Parameters
        ----------
        n_nodes: gum::Size
        n_arcs: gum::Size
        n_modmax: gum::Size

        generate(BNGenerator self, gum::Size n_nodes=10, gum::Size n_arcs=15) -> BayesNet_double

        Parameters
        ----------
        n_nodes: gum::Size
        n_arcs: gum::Size

        generate(BNGenerator self, gum::Size n_nodes=10) -> BayesNet_double

        Parameters
        ----------
        n_nodes: gum::Size

        generate(BNGenerator self) -> BayesNet_double

        Parameters
        ----------
        self: BNGenerator *

        """
        return _pyAgrum.BNGenerator_generate(self, n_nodes, n_arcs, n_modmax)


    def __init__(self):
        """__init__(BNGenerator self) -> BNGenerator"""
        this = _pyAgrum.new_BNGenerator()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_BNGenerator
    __del__ = lambda self: None
BNGenerator_swigregister = _pyAgrum.BNGenerator_swigregister
BNGenerator_swigregister(BNGenerator)

class IDGenerator(_object):
    """Proxy of C++ IDGenerator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IDGenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IDGenerator, name)
    __repr__ = _swig_repr

    def generate(self, nbrNodes: 'gum::Size'=10, arcDensity: 'double'=0.2, chanceNodeDensity: 'double'=0.8, utilityNodeDensity: 'double'=0.1, max_modality: 'int'=2) -> "gum::InfluenceDiagram< double >":
        """
        generate(IDGenerator self, gum::Size nbrNodes=10, double arcDensity=0.2, double chanceNodeDensity=0.8, double utilityNodeDensity=0.1, int max_modality=2) -> InfluenceDiagram_double

        Parameters
        ----------
        nbrNodes: gum::Size
        arcDensity: double
        chanceNodeDensity: double
        utilityNodeDensity: double
        max_modality: int

        generate(IDGenerator self, gum::Size nbrNodes=10, double arcDensity=0.2, double chanceNodeDensity=0.8, double utilityNodeDensity=0.1) -> InfluenceDiagram_double

        Parameters
        ----------
        nbrNodes: gum::Size
        arcDensity: double
        chanceNodeDensity: double
        utilityNodeDensity: double

        generate(IDGenerator self, gum::Size nbrNodes=10, double arcDensity=0.2, double chanceNodeDensity=0.8) -> InfluenceDiagram_double

        Parameters
        ----------
        nbrNodes: gum::Size
        arcDensity: double
        chanceNodeDensity: double

        generate(IDGenerator self, gum::Size nbrNodes=10, double arcDensity=0.2) -> InfluenceDiagram_double

        Parameters
        ----------
        nbrNodes: gum::Size
        arcDensity: double

        generate(IDGenerator self, gum::Size nbrNodes=10) -> InfluenceDiagram_double

        Parameters
        ----------
        nbrNodes: gum::Size

        generate(IDGenerator self) -> InfluenceDiagram_double

        Parameters
        ----------
        self: IDGenerator *

        """
        return _pyAgrum.IDGenerator_generate(self, nbrNodes, arcDensity, chanceNodeDensity, utilityNodeDensity, max_modality)


    def __init__(self):
        """__init__(IDGenerator self) -> IDGenerator"""
        this = _pyAgrum.new_IDGenerator()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IDGenerator
    __del__ = lambda self: None
IDGenerator_swigregister = _pyAgrum.IDGenerator_swigregister
IDGenerator_swigregister(IDGenerator)

class PRMexplorer(_object):
    """Proxy of C++ PRMexplorer class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PRMexplorer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PRMexplorer, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(PRMexplorer self) -> PRMexplorer"""
        this = _pyAgrum.new_PRMexplorer()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PRMexplorer
    __del__ = lambda self: None

    def load(self, *args) -> "void":
        """
        load(PRMexplorer self, std::string filename, std::string classpath, bool verbose=False)

        Parameters
        ----------
        filename: std::string
        classpath: std::string
        verbose: bool

        load(PRMexplorer self, std::string filename, std::string classpath)

        Parameters
        ----------
        filename: std::string
        classpath: std::string

        load(PRMexplorer self, std::string filename)

        Parameters
        ----------
        filename: std::string

        """
        return _pyAgrum.PRMexplorer_load(self, *args)


    def isType(self, name: 'std::string') -> "PyObject *":
        """
        isType(PRMexplorer self, std::string name) -> PyObject *

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.PRMexplorer_isType(self, name)


    def isClass(self, name: 'std::string') -> "PyObject *":
        """
        isClass(PRMexplorer self, std::string name) -> PyObject *

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.PRMexplorer_isClass(self, name)


    def isInterface(self, name: 'std::string') -> "PyObject *":
        """
        isInterface(PRMexplorer self, std::string name) -> PyObject *

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.PRMexplorer_isInterface(self, name)


    def classes(self) -> "PyObject *":
        """
        classes(PRMexplorer self) -> PyObject *

        Parameters
        ----------
        self: PRMexplorer *

        """
        return _pyAgrum.PRMexplorer_classes(self)


    def classAttributes(self, class_name: 'std::string') -> "PyObject *":
        """
        classAttributes(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_classAttributes(self, class_name)


    def isAttribute(self, class_name: 'std::string', att_name: 'std::string') -> "PyObject *":
        """
        isAttribute(PRMexplorer self, std::string class_name, std::string att_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string
        att_name: std::string

        """
        return _pyAgrum.PRMexplorer_isAttribute(self, class_name, att_name)


    def classReferences(self, class_name: 'std::string') -> "PyObject *":
        """
        classReferences(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_classReferences(self, class_name)


    def classParameters(self, class_name: 'std::string') -> "PyObject *":
        """
        classParameters(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_classParameters(self, class_name)


    def classImplements(self, class_name: 'std::string') -> "PyObject *":
        """
        classImplements(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_classImplements(self, class_name)

    __swig_setmethods__["aggType"] = _pyAgrum.PRMexplorer_aggType_set
    __swig_getmethods__["aggType"] = _pyAgrum.PRMexplorer_aggType_get
    if _newclass:
        aggType = _swig_property(_pyAgrum.PRMexplorer_aggType_get, _pyAgrum.PRMexplorer_aggType_set)

    def classAggregates(self, class_name: 'std::string') -> "PyObject *":
        """
        classAggregates(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_classAggregates(self, class_name)


    def classSlotChains(self, class_name: 'std::string') -> "PyObject *":
        """
        classSlotChains(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_classSlotChains(self, class_name)


    def classDag(self, class_name: 'std::string') -> "PyObject *":
        """
        classDag(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_classDag(self, class_name)


    def getalltheSystems(self) -> "PyObject *":
        """
        getalltheSystems(PRMexplorer self) -> PyObject *

        Parameters
        ----------
        self: PRMexplorer *

        """
        return _pyAgrum.PRMexplorer_getalltheSystems(self)


    def getSuperClass(self, class_name: 'std::string') -> "PyObject *":
        """
        getSuperClass(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_getSuperClass(self, class_name)


    def getDirectSubClass(self, class_name: 'std::string') -> "PyObject *":
        """
        getDirectSubClass(PRMexplorer self, std::string class_name) -> PyObject *

        Parameters
        ----------
        class_name: std::string

        """
        return _pyAgrum.PRMexplorer_getDirectSubClass(self, class_name)


    def cpf(self, class_name: 'std::string', attribute: 'std::string') -> "gum::Potential< double > const &":
        """
        cpf(PRMexplorer self, std::string class_name, std::string attribute) -> Potential_double

        Parameters
        ----------
        class_name: std::string
        attribute: std::string

        """
        return _pyAgrum.PRMexplorer_cpf(self, class_name, attribute)


    def types(self) -> "PyObject *":
        """
        types(PRMexplorer self) -> PyObject *

        Parameters
        ----------
        self: PRMexplorer *

        """
        return _pyAgrum.PRMexplorer_types(self)


    def getSuperType(self, type_name: 'std::string') -> "PyObject *":
        """
        getSuperType(PRMexplorer self, std::string type_name) -> PyObject *

        Parameters
        ----------
        type_name: std::string

        """
        return _pyAgrum.PRMexplorer_getSuperType(self, type_name)


    def getDirectSubTypes(self, type_name: 'std::string') -> "PyObject *":
        """
        getDirectSubTypes(PRMexplorer self, std::string type_name) -> PyObject *

        Parameters
        ----------
        type_name: std::string

        """
        return _pyAgrum.PRMexplorer_getDirectSubTypes(self, type_name)


    def getLabels(self, type_name: 'std::string') -> "PyObject *":
        """
        getLabels(PRMexplorer self, std::string type_name) -> PyObject *

        Parameters
        ----------
        type_name: std::string

        """
        return _pyAgrum.PRMexplorer_getLabels(self, type_name)


    def getLabelMap(self, type_name: 'std::string') -> "PyObject *":
        """
        getLabelMap(PRMexplorer self, std::string type_name) -> PyObject *

        Parameters
        ----------
        type_name: std::string

        """
        return _pyAgrum.PRMexplorer_getLabelMap(self, type_name)


    def interfaces(self) -> "PyObject *":
        """
        interfaces(PRMexplorer self) -> PyObject *

        Parameters
        ----------
        self: PRMexplorer *

        """
        return _pyAgrum.PRMexplorer_interfaces(self)


    def interAttributes(self, interface_name: 'std::string', allAttributes: 'bool'=False) -> "PyObject *":
        """
        interAttributes(PRMexplorer self, std::string interface_name, bool allAttributes=False) -> PyObject

        Parameters
        ----------
        interface_name: std::string
        allAttributes: bool

        interAttributes(PRMexplorer self, std::string interface_name) -> PyObject *

        Parameters
        ----------
        interface_name: std::string

        """
        return _pyAgrum.PRMexplorer_interAttributes(self, interface_name, allAttributes)


    def interReferences(self, interface_name: 'std::string') -> "PyObject *":
        """
        interReferences(PRMexplorer self, std::string interface_name) -> PyObject *

        Parameters
        ----------
        interface_name: std::string

        """
        return _pyAgrum.PRMexplorer_interReferences(self, interface_name)


    def getSuperInterface(self, interface_name: 'std::string') -> "PyObject *":
        """
        getSuperInterface(PRMexplorer self, std::string interface_name) -> PyObject *

        Parameters
        ----------
        interface_name: std::string

        """
        return _pyAgrum.PRMexplorer_getSuperInterface(self, interface_name)


    def getDirectSubInterfaces(self, interface_name: 'std::string') -> "PyObject *":
        """
        getDirectSubInterfaces(PRMexplorer self, std::string interface_name) -> PyObject *

        Parameters
        ----------
        interface_name: std::string

        """
        return _pyAgrum.PRMexplorer_getDirectSubInterfaces(self, interface_name)


    def getImplementations(self, interface_name: 'std::string') -> "PyObject *":
        """
        getImplementations(PRMexplorer self, std::string interface_name) -> PyObject *

        Parameters
        ----------
        interface_name: std::string

        """
        return _pyAgrum.PRMexplorer_getImplementations(self, interface_name)

PRMexplorer_swigregister = _pyAgrum.PRMexplorer_swigregister
PRMexplorer_swigregister(PRMexplorer)

class Vector_double(_object):
    """Proxy of C++ std::vector<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_double, name)
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        """
        iterator(Vector_double self) -> SwigPyIterator

        Parameters
        ----------
        self: std::vector< double > *

        """
        return _pyAgrum.Vector_double_iterator(self)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        """
        __nonzero__(Vector_double self) -> bool

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double___nonzero__(self)


    def __bool__(self) -> "bool":
        """
        __bool__(Vector_double self) -> bool

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double___bool__(self)


    def __len__(self) -> "std::vector< double >::size_type":
        """
        __len__(Vector_double self) -> std::vector< double >::size_type

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double___len__(self)


    def __getslice__(self, i: 'std::vector< double >::difference_type', j: 'std::vector< double >::difference_type') -> "std::vector< double,std::allocator< double > > *":
        """
        __getslice__(Vector_double self, std::vector< double >::difference_type i, std::vector< double >::difference_type j) -> Vector_double

        Parameters
        ----------
        i: std::vector< double >::difference_type
        j: std::vector< double >::difference_type

        """
        return _pyAgrum.Vector_double___getslice__(self, i, j)


    def __setslice__(self, *args) -> "void":
        """
        __setslice__(Vector_double self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)

        Parameters
        ----------
        i: std::vector< double >::difference_type
        j: std::vector< double >::difference_type

        __setslice__(Vector_double self, std::vector< double >::difference_type i, std::vector< double >::difference_type j, Vector_double v)

        Parameters
        ----------
        i: std::vector< double >::difference_type
        j: std::vector< double >::difference_type
        v: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.Vector_double___setslice__(self, *args)


    def __delslice__(self, i: 'std::vector< double >::difference_type', j: 'std::vector< double >::difference_type') -> "void":
        """
        __delslice__(Vector_double self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)

        Parameters
        ----------
        i: std::vector< double >::difference_type
        j: std::vector< double >::difference_type

        """
        return _pyAgrum.Vector_double___delslice__(self, i, j)


    def __delitem__(self, *args) -> "void":
        """
        __delitem__(Vector_double self, std::vector< double >::difference_type i)

        Parameters
        ----------
        i: std::vector< double >::difference_type

        __delitem__(Vector_double self, PySliceObject * slice)

        Parameters
        ----------
        slice: PySliceObject *

        """
        return _pyAgrum.Vector_double___delitem__(self, *args)


    def __getitem__(self, *args) -> "std::vector< double >::value_type const &":
        """
        __getitem__(Vector_double self, PySliceObject * slice) -> Vector_double

        Parameters
        ----------
        slice: PySliceObject *

        __getitem__(Vector_double self, std::vector< double >::difference_type i) -> std::vector< double >::value_type const &

        Parameters
        ----------
        i: std::vector< double >::difference_type

        """
        return _pyAgrum.Vector_double___getitem__(self, *args)


    def __setitem__(self, *args) -> "void":
        """
        __setitem__(Vector_double self, PySliceObject * slice, Vector_double v)

        Parameters
        ----------
        slice: PySliceObject *
        v: std::vector< double,std::allocator< double > > const &

        __setitem__(Vector_double self, PySliceObject * slice)

        Parameters
        ----------
        slice: PySliceObject *

        __setitem__(Vector_double self, std::vector< double >::difference_type i, std::vector< double >::value_type const & x)

        Parameters
        ----------
        i: std::vector< double >::difference_type
        x: std::vector< double >::value_type const &

        """
        return _pyAgrum.Vector_double___setitem__(self, *args)


    def pop(self) -> "std::vector< double >::value_type":
        """
        pop(Vector_double self) -> std::vector< double >::value_type

        Parameters
        ----------
        self: std::vector< double > *

        """
        return _pyAgrum.Vector_double_pop(self)


    def append(self, x: 'std::vector< double >::value_type const &') -> "void":
        """
        append(Vector_double self, std::vector< double >::value_type const & x)

        Parameters
        ----------
        x: std::vector< double >::value_type const &

        """
        return _pyAgrum.Vector_double_append(self, x)


    def empty(self) -> "bool":
        """
        empty(Vector_double self) -> bool

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double_empty(self)


    def size(self) -> "std::vector< double >::size_type":
        """
        size(Vector_double self) -> std::vector< double >::size_type

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double_size(self)


    def swap(self, v: 'Vector_double') -> "void":
        """
        swap(Vector_double self, Vector_double v)

        Parameters
        ----------
        v: std::vector< double > &

        """
        return _pyAgrum.Vector_double_swap(self, v)


    def begin(self) -> "std::vector< double >::iterator":
        """
        begin(Vector_double self) -> std::vector< double >::iterator

        Parameters
        ----------
        self: std::vector< double > *

        """
        return _pyAgrum.Vector_double_begin(self)


    def end(self) -> "std::vector< double >::iterator":
        """
        end(Vector_double self) -> std::vector< double >::iterator

        Parameters
        ----------
        self: std::vector< double > *

        """
        return _pyAgrum.Vector_double_end(self)


    def rbegin(self) -> "std::vector< double >::reverse_iterator":
        """
        rbegin(Vector_double self) -> std::vector< double >::reverse_iterator

        Parameters
        ----------
        self: std::vector< double > *

        """
        return _pyAgrum.Vector_double_rbegin(self)


    def rend(self) -> "std::vector< double >::reverse_iterator":
        """
        rend(Vector_double self) -> std::vector< double >::reverse_iterator

        Parameters
        ----------
        self: std::vector< double > *

        """
        return _pyAgrum.Vector_double_rend(self)


    def clear(self) -> "void":
        """
        clear(Vector_double self)

        Parameters
        ----------
        self: std::vector< double > *

        """
        return _pyAgrum.Vector_double_clear(self)


    def get_allocator(self) -> "std::vector< double >::allocator_type":
        """
        get_allocator(Vector_double self) -> std::vector< double >::allocator_type

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double_get_allocator(self)


    def pop_back(self) -> "void":
        """
        pop_back(Vector_double self)

        Parameters
        ----------
        self: std::vector< double > *

        """
        return _pyAgrum.Vector_double_pop_back(self)


    def erase(self, *args) -> "std::vector< double >::iterator":
        """
        erase(Vector_double self, std::vector< double >::iterator pos) -> std::vector< double >::iterator

        Parameters
        ----------
        pos: std::vector< double >::iterator

        erase(Vector_double self, std::vector< double >::iterator first, std::vector< double >::iterator last) -> std::vector< double >::iterator

        Parameters
        ----------
        first: std::vector< double >::iterator
        last: std::vector< double >::iterator

        """
        return _pyAgrum.Vector_double_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(std::vector<(double)> self) -> Vector_double
        __init__(std::vector<(double)> self, Vector_double arg2) -> Vector_double

        Parameters
        ----------
        arg2: std::vector< double > const &

        __init__(std::vector<(double)> self, std::vector< double >::size_type size) -> Vector_double

        Parameters
        ----------
        size: std::vector< double >::size_type

        __init__(std::vector<(double)> self, std::vector< double >::size_type size, std::vector< double >::value_type const & value) -> Vector_double

        Parameters
        ----------
        size: std::vector< double >::size_type
        value: std::vector< double >::value_type const &

        """
        this = _pyAgrum.new_Vector_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x: 'std::vector< double >::value_type const &') -> "void":
        """
        push_back(Vector_double self, std::vector< double >::value_type const & x)

        Parameters
        ----------
        x: std::vector< double >::value_type const &

        """
        return _pyAgrum.Vector_double_push_back(self, x)


    def front(self) -> "std::vector< double >::value_type const &":
        """
        front(Vector_double self) -> std::vector< double >::value_type const &

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double_front(self)


    def back(self) -> "std::vector< double >::value_type const &":
        """
        back(Vector_double self) -> std::vector< double >::value_type const &

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double_back(self)


    def assign(self, n: 'std::vector< double >::size_type', x: 'std::vector< double >::value_type const &') -> "void":
        """
        assign(Vector_double self, std::vector< double >::size_type n, std::vector< double >::value_type const & x)

        Parameters
        ----------
        n: std::vector< double >::size_type
        x: std::vector< double >::value_type const &

        """
        return _pyAgrum.Vector_double_assign(self, n, x)


    def resize(self, *args) -> "void":
        """
        resize(Vector_double self, std::vector< double >::size_type new_size)

        Parameters
        ----------
        new_size: std::vector< double >::size_type

        resize(Vector_double self, std::vector< double >::size_type new_size, std::vector< double >::value_type const & x)

        Parameters
        ----------
        new_size: std::vector< double >::size_type
        x: std::vector< double >::value_type const &

        """
        return _pyAgrum.Vector_double_resize(self, *args)


    def insert(self, *args) -> "void":
        """
        insert(Vector_double self, std::vector< double >::iterator pos, std::vector< double >::value_type const & x) -> std::vector< double >::iterator

        Parameters
        ----------
        pos: std::vector< double >::iterator
        x: std::vector< double >::value_type const &

        insert(Vector_double self, std::vector< double >::iterator pos, std::vector< double >::size_type n, std::vector< double >::value_type const & x)

        Parameters
        ----------
        pos: std::vector< double >::iterator
        n: std::vector< double >::size_type
        x: std::vector< double >::value_type const &

        """
        return _pyAgrum.Vector_double_insert(self, *args)


    def reserve(self, n: 'std::vector< double >::size_type') -> "void":
        """
        reserve(Vector_double self, std::vector< double >::size_type n)

        Parameters
        ----------
        n: std::vector< double >::size_type

        """
        return _pyAgrum.Vector_double_reserve(self, n)


    def capacity(self) -> "std::vector< double >::size_type":
        """
        capacity(Vector_double self) -> std::vector< double >::size_type

        Parameters
        ----------
        self: std::vector< double > const *

        """
        return _pyAgrum.Vector_double_capacity(self)

    __swig_destroy__ = _pyAgrum.delete_Vector_double
    __del__ = lambda self: None
Vector_double_swigregister = _pyAgrum.Vector_double_swigregister
Vector_double_swigregister(Vector_double)

class Vector_string(_object):
    """Proxy of C++ std::vector<(std::string)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_string, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_string, name)
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        """
        iterator(Vector_string self) -> SwigPyIterator

        Parameters
        ----------
        self: std::vector< std::string > *

        """
        return _pyAgrum.Vector_string_iterator(self)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        """
        __nonzero__(Vector_string self) -> bool

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string___nonzero__(self)


    def __bool__(self) -> "bool":
        """
        __bool__(Vector_string self) -> bool

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string___bool__(self)


    def __len__(self) -> "std::vector< std::string >::size_type":
        """
        __len__(Vector_string self) -> std::vector< std::string >::size_type

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string___len__(self)


    def __getslice__(self, i: 'std::vector< std::string >::difference_type', j: 'std::vector< std::string >::difference_type') -> "std::vector< std::string,std::allocator< std::string > > *":
        """
        __getslice__(Vector_string self, std::vector< std::string >::difference_type i, std::vector< std::string >::difference_type j) -> Vector_string

        Parameters
        ----------
        i: std::vector< std::string >::difference_type
        j: std::vector< std::string >::difference_type

        """
        return _pyAgrum.Vector_string___getslice__(self, i, j)


    def __setslice__(self, *args) -> "void":
        """
        __setslice__(Vector_string self, std::vector< std::string >::difference_type i, std::vector< std::string >::difference_type j)

        Parameters
        ----------
        i: std::vector< std::string >::difference_type
        j: std::vector< std::string >::difference_type

        __setslice__(Vector_string self, std::vector< std::string >::difference_type i, std::vector< std::string >::difference_type j, Vector_string v)

        Parameters
        ----------
        i: std::vector< std::string >::difference_type
        j: std::vector< std::string >::difference_type
        v: std::vector< std::string,std::allocator< std::string > > const &

        """
        return _pyAgrum.Vector_string___setslice__(self, *args)


    def __delslice__(self, i: 'std::vector< std::string >::difference_type', j: 'std::vector< std::string >::difference_type') -> "void":
        """
        __delslice__(Vector_string self, std::vector< std::string >::difference_type i, std::vector< std::string >::difference_type j)

        Parameters
        ----------
        i: std::vector< std::string >::difference_type
        j: std::vector< std::string >::difference_type

        """
        return _pyAgrum.Vector_string___delslice__(self, i, j)


    def __delitem__(self, *args) -> "void":
        """
        __delitem__(Vector_string self, std::vector< std::string >::difference_type i)

        Parameters
        ----------
        i: std::vector< std::string >::difference_type

        __delitem__(Vector_string self, PySliceObject * slice)

        Parameters
        ----------
        slice: PySliceObject *

        """
        return _pyAgrum.Vector_string___delitem__(self, *args)


    def __getitem__(self, *args) -> "std::vector< std::string >::value_type const &":
        """
        __getitem__(Vector_string self, PySliceObject * slice) -> Vector_string

        Parameters
        ----------
        slice: PySliceObject *

        __getitem__(Vector_string self, std::vector< std::string >::difference_type i) -> std::vector< std::string >::value_type const &

        Parameters
        ----------
        i: std::vector< std::string >::difference_type

        """
        return _pyAgrum.Vector_string___getitem__(self, *args)


    def __setitem__(self, *args) -> "void":
        """
        __setitem__(Vector_string self, PySliceObject * slice, Vector_string v)

        Parameters
        ----------
        slice: PySliceObject *
        v: std::vector< std::string,std::allocator< std::string > > const &

        __setitem__(Vector_string self, PySliceObject * slice)

        Parameters
        ----------
        slice: PySliceObject *

        __setitem__(Vector_string self, std::vector< std::string >::difference_type i, std::vector< std::string >::value_type const & x)

        Parameters
        ----------
        i: std::vector< std::string >::difference_type
        x: std::vector< std::string >::value_type const &

        """
        return _pyAgrum.Vector_string___setitem__(self, *args)


    def pop(self) -> "std::vector< std::string >::value_type":
        """
        pop(Vector_string self) -> std::vector< std::string >::value_type

        Parameters
        ----------
        self: std::vector< std::string > *

        """
        return _pyAgrum.Vector_string_pop(self)


    def append(self, x: 'std::vector< std::string >::value_type const &') -> "void":
        """
        append(Vector_string self, std::vector< std::string >::value_type const & x)

        Parameters
        ----------
        x: std::vector< std::string >::value_type const &

        """
        return _pyAgrum.Vector_string_append(self, x)


    def empty(self) -> "bool":
        """
        empty(Vector_string self) -> bool

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string_empty(self)


    def size(self) -> "std::vector< std::string >::size_type":
        """
        size(Vector_string self) -> std::vector< std::string >::size_type

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string_size(self)


    def swap(self, v: 'Vector_string') -> "void":
        """
        swap(Vector_string self, Vector_string v)

        Parameters
        ----------
        v: std::vector< std::string > &

        """
        return _pyAgrum.Vector_string_swap(self, v)


    def begin(self) -> "std::vector< std::string >::iterator":
        """
        begin(Vector_string self) -> std::vector< std::string >::iterator

        Parameters
        ----------
        self: std::vector< std::string > *

        """
        return _pyAgrum.Vector_string_begin(self)


    def end(self) -> "std::vector< std::string >::iterator":
        """
        end(Vector_string self) -> std::vector< std::string >::iterator

        Parameters
        ----------
        self: std::vector< std::string > *

        """
        return _pyAgrum.Vector_string_end(self)


    def rbegin(self) -> "std::vector< std::string >::reverse_iterator":
        """
        rbegin(Vector_string self) -> std::vector< std::string >::reverse_iterator

        Parameters
        ----------
        self: std::vector< std::string > *

        """
        return _pyAgrum.Vector_string_rbegin(self)


    def rend(self) -> "std::vector< std::string >::reverse_iterator":
        """
        rend(Vector_string self) -> std::vector< std::string >::reverse_iterator

        Parameters
        ----------
        self: std::vector< std::string > *

        """
        return _pyAgrum.Vector_string_rend(self)


    def clear(self) -> "void":
        """
        clear(Vector_string self)

        Parameters
        ----------
        self: std::vector< std::string > *

        """
        return _pyAgrum.Vector_string_clear(self)


    def get_allocator(self) -> "std::vector< std::string >::allocator_type":
        """
        get_allocator(Vector_string self) -> std::vector< std::string >::allocator_type

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string_get_allocator(self)


    def pop_back(self) -> "void":
        """
        pop_back(Vector_string self)

        Parameters
        ----------
        self: std::vector< std::string > *

        """
        return _pyAgrum.Vector_string_pop_back(self)


    def erase(self, *args) -> "std::vector< std::string >::iterator":
        """
        erase(Vector_string self, std::vector< std::string >::iterator pos) -> std::vector< std::string >::iterator

        Parameters
        ----------
        pos: std::vector< std::string >::iterator

        erase(Vector_string self, std::vector< std::string >::iterator first, std::vector< std::string >::iterator last) -> std::vector< std::string >::iterator

        Parameters
        ----------
        first: std::vector< std::string >::iterator
        last: std::vector< std::string >::iterator

        """
        return _pyAgrum.Vector_string_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(std::vector<(std::string)> self) -> Vector_string
        __init__(std::vector<(std::string)> self, Vector_string arg2) -> Vector_string

        Parameters
        ----------
        arg2: std::vector< std::string > const &

        __init__(std::vector<(std::string)> self, std::vector< std::string >::size_type size) -> Vector_string

        Parameters
        ----------
        size: std::vector< std::string >::size_type

        __init__(std::vector<(std::string)> self, std::vector< std::string >::size_type size, std::vector< std::string >::value_type const & value) -> Vector_string

        Parameters
        ----------
        size: std::vector< std::string >::size_type
        value: std::vector< std::string >::value_type const &

        """
        this = _pyAgrum.new_Vector_string(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x: 'std::vector< std::string >::value_type const &') -> "void":
        """
        push_back(Vector_string self, std::vector< std::string >::value_type const & x)

        Parameters
        ----------
        x: std::vector< std::string >::value_type const &

        """
        return _pyAgrum.Vector_string_push_back(self, x)


    def front(self) -> "std::vector< std::string >::value_type const &":
        """
        front(Vector_string self) -> std::vector< std::string >::value_type const &

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string_front(self)


    def back(self) -> "std::vector< std::string >::value_type const &":
        """
        back(Vector_string self) -> std::vector< std::string >::value_type const &

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string_back(self)


    def assign(self, n: 'std::vector< std::string >::size_type', x: 'std::vector< std::string >::value_type const &') -> "void":
        """
        assign(Vector_string self, std::vector< std::string >::size_type n, std::vector< std::string >::value_type const & x)

        Parameters
        ----------
        n: std::vector< std::string >::size_type
        x: std::vector< std::string >::value_type const &

        """
        return _pyAgrum.Vector_string_assign(self, n, x)


    def resize(self, *args) -> "void":
        """
        resize(Vector_string self, std::vector< std::string >::size_type new_size)

        Parameters
        ----------
        new_size: std::vector< std::string >::size_type

        resize(Vector_string self, std::vector< std::string >::size_type new_size, std::vector< std::string >::value_type const & x)

        Parameters
        ----------
        new_size: std::vector< std::string >::size_type
        x: std::vector< std::string >::value_type const &

        """
        return _pyAgrum.Vector_string_resize(self, *args)


    def insert(self, *args) -> "void":
        """
        insert(Vector_string self, std::vector< std::string >::iterator pos, std::vector< std::string >::value_type const & x) -> std::vector< std::string >::iterator

        Parameters
        ----------
        pos: std::vector< std::string >::iterator
        x: std::vector< std::string >::value_type const &

        insert(Vector_string self, std::vector< std::string >::iterator pos, std::vector< std::string >::size_type n, std::vector< std::string >::value_type const & x)

        Parameters
        ----------
        pos: std::vector< std::string >::iterator
        n: std::vector< std::string >::size_type
        x: std::vector< std::string >::value_type const &

        """
        return _pyAgrum.Vector_string_insert(self, *args)


    def reserve(self, n: 'std::vector< std::string >::size_type') -> "void":
        """
        reserve(Vector_string self, std::vector< std::string >::size_type n)

        Parameters
        ----------
        n: std::vector< std::string >::size_type

        """
        return _pyAgrum.Vector_string_reserve(self, n)


    def capacity(self) -> "std::vector< std::string >::size_type":
        """
        capacity(Vector_string self) -> std::vector< std::string >::size_type

        Parameters
        ----------
        self: std::vector< std::string > const *

        """
        return _pyAgrum.Vector_string_capacity(self)

    __swig_destroy__ = _pyAgrum.delete_Vector_string
    __del__ = lambda self: None
Vector_string_swigregister = _pyAgrum.Vector_string_swigregister
Vector_string_swigregister(Vector_string)

class GumException(Exception):
    """Proxy of C++ gum::Exception class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GumException, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GumException, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::Exception self, std::string const aMsg, std::string const aType) -> GumException

        Parameters
        ----------
        aMsg: std::string const
        aType: std::string const

        __init__(gum::Exception self, std::string const aMsg) -> GumException

        Parameters
        ----------
        aMsg: std::string const

        __init__(gum::Exception self) -> GumException
        __init__(gum::Exception self, GumException e) -> GumException

        Parameters
        ----------
        e: gum::Exception const &

        """
        this = _pyAgrum.new_GumException(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_GumException
    __del__ = lambda self: None

    def __str__(self) -> "std::string const":
        """
        __str__(GumException self) -> std::string const

        Parameters
        ----------
        self: gum::Exception const *

        """
        return _pyAgrum.GumException___str__(self)


    def errorContent(self) -> "std::string const":
        """
        errorContent(GumException self) -> std::string const

        Parameters
        ----------
        self: gum::Exception const *

        """
        return _pyAgrum.GumException_errorContent(self)


    def errorType(self) -> "std::string const":
        """
        errorType(GumException self) -> std::string const

        Parameters
        ----------
        self: gum::Exception const *

        """
        return _pyAgrum.GumException_errorType(self)


    def errorCallStack(self) -> "std::string const":
        """
        errorCallStack(GumException self) -> std::string const

        Parameters
        ----------
        self: gum::Exception const *

        """
        return _pyAgrum.GumException_errorCallStack(self)

GumException_swigregister = _pyAgrum.GumException_swigregister
GumException_swigregister(GumException)


def __createMsg(filename: 'std::string const &', function: 'std::string const &', line: 'int const', msg: 'std::string const &') -> "std::string const":
    """
    __createMsg(std::string const & filename, std::string const & function, int const line, std::string const & msg) -> std::string const

    Parameters
    ----------
    filename: std::string const &
    function: std::string const &
    line: int const
    msg: std::string const &

    """
    return _pyAgrum.__createMsg(filename, function, line, msg)
class IdError(GumException):
    """Proxy of C++ gum::IdError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IdError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IdError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::IdError self, std::string aMsg, std::string aType) -> IdError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::IdError self, std::string aMsg) -> IdError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_IdError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IdError
    __del__ = lambda self: None
IdError_swigregister = _pyAgrum.IdError_swigregister
IdError_swigregister(IdError)

class FatalError(GumException):
    """Proxy of C++ gum::FatalError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FatalError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FatalError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::FatalError self, std::string aMsg, std::string aType) -> FatalError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::FatalError self, std::string aMsg) -> FatalError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_FatalError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_FatalError
    __del__ = lambda self: None
FatalError_swigregister = _pyAgrum.FatalError_swigregister
FatalError_swigregister(FatalError)

class UndefinedIteratorValue(GumException):
    """Proxy of C++ gum::UndefinedIteratorValue class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UndefinedIteratorValue, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UndefinedIteratorValue, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::UndefinedIteratorValue self, std::string aMsg, std::string aType) -> UndefinedIteratorValue

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::UndefinedIteratorValue self, std::string aMsg) -> UndefinedIteratorValue

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_UndefinedIteratorValue(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UndefinedIteratorValue
    __del__ = lambda self: None
UndefinedIteratorValue_swigregister = _pyAgrum.UndefinedIteratorValue_swigregister
UndefinedIteratorValue_swigregister(UndefinedIteratorValue)

class UndefinedIteratorKey(GumException):
    """Proxy of C++ gum::UndefinedIteratorKey class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UndefinedIteratorKey, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UndefinedIteratorKey, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::UndefinedIteratorKey self, std::string aMsg, std::string aType) -> UndefinedIteratorKey

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::UndefinedIteratorKey self, std::string aMsg) -> UndefinedIteratorKey

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_UndefinedIteratorKey(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UndefinedIteratorKey
    __del__ = lambda self: None
UndefinedIteratorKey_swigregister = _pyAgrum.UndefinedIteratorKey_swigregister
UndefinedIteratorKey_swigregister(UndefinedIteratorKey)

class NullElement(GumException):
    """Proxy of C++ gum::NullElement class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NullElement, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NullElement, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::NullElement self, std::string aMsg, std::string aType) -> NullElement

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::NullElement self, std::string aMsg) -> NullElement

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_NullElement(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NullElement
    __del__ = lambda self: None
NullElement_swigregister = _pyAgrum.NullElement_swigregister
NullElement_swigregister(NullElement)

class UndefinedElement(GumException):
    """Proxy of C++ gum::UndefinedElement class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UndefinedElement, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UndefinedElement, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::UndefinedElement self, std::string aMsg, std::string aType) -> UndefinedElement

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::UndefinedElement self, std::string aMsg) -> UndefinedElement

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_UndefinedElement(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UndefinedElement
    __del__ = lambda self: None
UndefinedElement_swigregister = _pyAgrum.UndefinedElement_swigregister
UndefinedElement_swigregister(UndefinedElement)

class SizeError(GumException):
    """Proxy of C++ gum::SizeError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SizeError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SizeError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::SizeError self, std::string aMsg, std::string aType) -> SizeError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::SizeError self, std::string aMsg) -> SizeError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_SizeError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_SizeError
    __del__ = lambda self: None
SizeError_swigregister = _pyAgrum.SizeError_swigregister
SizeError_swigregister(SizeError)

class EmptySet(GumException):
    """Proxy of C++ gum::EmptySet class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EmptySet, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EmptySet, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::EmptySet self, std::string aMsg, std::string aType) -> EmptySet

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::EmptySet self, std::string aMsg) -> EmptySet

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_EmptySet(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_EmptySet
    __del__ = lambda self: None
EmptySet_swigregister = _pyAgrum.EmptySet_swigregister
EmptySet_swigregister(EmptySet)

class InvalidArgumentsNumber(GumException):
    """Proxy of C++ gum::InvalidArgumentsNumber class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidArgumentsNumber, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidArgumentsNumber, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::InvalidArgumentsNumber self, std::string aMsg, std::string aType) -> InvalidArgumentsNumber

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::InvalidArgumentsNumber self, std::string aMsg) -> InvalidArgumentsNumber

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_InvalidArgumentsNumber(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidArgumentsNumber
    __del__ = lambda self: None
InvalidArgumentsNumber_swigregister = _pyAgrum.InvalidArgumentsNumber_swigregister
InvalidArgumentsNumber_swigregister(InvalidArgumentsNumber)

class InvalidArgument(GumException):
    """Proxy of C++ gum::InvalidArgument class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidArgument, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidArgument, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::InvalidArgument self, std::string aMsg, std::string aType) -> InvalidArgument

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::InvalidArgument self, std::string aMsg) -> InvalidArgument

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_InvalidArgument(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidArgument
    __del__ = lambda self: None
InvalidArgument_swigregister = _pyAgrum.InvalidArgument_swigregister
InvalidArgument_swigregister(InvalidArgument)

class IOError(GumException):
    """Proxy of C++ gum::IOError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IOError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IOError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::IOError self, std::string aMsg, std::string aType) -> IOError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::IOError self, std::string aMsg) -> IOError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_IOError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IOError
    __del__ = lambda self: None
IOError_swigregister = _pyAgrum.IOError_swigregister
IOError_swigregister(IOError)

class FormatNotFound(IOError):
    """Proxy of C++ gum::FormatNotFound class."""

    __swig_setmethods__ = {}
    for _s in [IOError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FormatNotFound, name, value)
    __swig_getmethods__ = {}
    for _s in [IOError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FormatNotFound, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::FormatNotFound self, std::string aMsg, std::string aType) -> FormatNotFound

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::FormatNotFound self, std::string aMsg) -> FormatNotFound

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_FormatNotFound(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_FormatNotFound
    __del__ = lambda self: None
FormatNotFound_swigregister = _pyAgrum.FormatNotFound_swigregister
FormatNotFound_swigregister(FormatNotFound)

class OperationNotAllowed(GumException):
    """Proxy of C++ gum::OperationNotAllowed class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OperationNotAllowed, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OperationNotAllowed, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::OperationNotAllowed self, std::string aMsg, std::string aType) -> OperationNotAllowed

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::OperationNotAllowed self, std::string aMsg) -> OperationNotAllowed

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_OperationNotAllowed(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_OperationNotAllowed
    __del__ = lambda self: None
OperationNotAllowed_swigregister = _pyAgrum.OperationNotAllowed_swigregister
OperationNotAllowed_swigregister(OperationNotAllowed)

class NotFound(GumException):
    """Proxy of C++ gum::NotFound class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NotFound, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NotFound, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::NotFound self, std::string aMsg, std::string aType) -> NotFound

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::NotFound self, std::string aMsg) -> NotFound

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_NotFound(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NotFound
    __del__ = lambda self: None
NotFound_swigregister = _pyAgrum.NotFound_swigregister
NotFound_swigregister(NotFound)

class ReferenceError(GumException):
    """Proxy of C++ gum::ReferenceError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ReferenceError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ReferenceError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::ReferenceError self, std::string aMsg, std::string aType) -> ReferenceError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::ReferenceError self, std::string aMsg) -> ReferenceError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_ReferenceError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_ReferenceError
    __del__ = lambda self: None
ReferenceError_swigregister = _pyAgrum.ReferenceError_swigregister
ReferenceError_swigregister(ReferenceError)

class OutOfBounds(ReferenceError):
    """Proxy of C++ gum::OutOfBounds class."""

    __swig_setmethods__ = {}
    for _s in [ReferenceError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OutOfBounds, name, value)
    __swig_getmethods__ = {}
    for _s in [ReferenceError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OutOfBounds, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::OutOfBounds self, std::string aMsg, std::string aType) -> OutOfBounds

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::OutOfBounds self, std::string aMsg) -> OutOfBounds

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_OutOfBounds(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_OutOfBounds
    __del__ = lambda self: None
OutOfBounds_swigregister = _pyAgrum.OutOfBounds_swigregister
OutOfBounds_swigregister(OutOfBounds)

class OutOfLowerBound(OutOfBounds):
    """Proxy of C++ gum::OutOfLowerBound class."""

    __swig_setmethods__ = {}
    for _s in [OutOfBounds]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OutOfLowerBound, name, value)
    __swig_getmethods__ = {}
    for _s in [OutOfBounds]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OutOfLowerBound, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::OutOfLowerBound self, std::string aMsg, std::string aType) -> OutOfLowerBound

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::OutOfLowerBound self, std::string aMsg) -> OutOfLowerBound

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_OutOfLowerBound(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_OutOfLowerBound
    __del__ = lambda self: None
OutOfLowerBound_swigregister = _pyAgrum.OutOfLowerBound_swigregister
OutOfLowerBound_swigregister(OutOfLowerBound)

class OutOfUpperBound(OutOfBounds):
    """Proxy of C++ gum::OutOfUpperBound class."""

    __swig_setmethods__ = {}
    for _s in [OutOfBounds]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OutOfUpperBound, name, value)
    __swig_getmethods__ = {}
    for _s in [OutOfBounds]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OutOfUpperBound, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::OutOfUpperBound self, std::string aMsg, std::string aType) -> OutOfUpperBound

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::OutOfUpperBound self, std::string aMsg) -> OutOfUpperBound

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_OutOfUpperBound(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_OutOfUpperBound
    __del__ = lambda self: None
OutOfUpperBound_swigregister = _pyAgrum.OutOfUpperBound_swigregister
OutOfUpperBound_swigregister(OutOfUpperBound)

class DuplicateElement(ReferenceError):
    """Proxy of C++ gum::DuplicateElement class."""

    __swig_setmethods__ = {}
    for _s in [ReferenceError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DuplicateElement, name, value)
    __swig_getmethods__ = {}
    for _s in [ReferenceError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DuplicateElement, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::DuplicateElement self, std::string aMsg, std::string aType) -> DuplicateElement

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::DuplicateElement self, std::string aMsg) -> DuplicateElement

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_DuplicateElement(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DuplicateElement
    __del__ = lambda self: None
DuplicateElement_swigregister = _pyAgrum.DuplicateElement_swigregister
DuplicateElement_swigregister(DuplicateElement)

class DuplicateLabel(ReferenceError):
    """Proxy of C++ gum::DuplicateLabel class."""

    __swig_setmethods__ = {}
    for _s in [ReferenceError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DuplicateLabel, name, value)
    __swig_getmethods__ = {}
    for _s in [ReferenceError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DuplicateLabel, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::DuplicateLabel self, std::string aMsg, std::string aType) -> DuplicateLabel

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::DuplicateLabel self, std::string aMsg) -> DuplicateLabel

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_DuplicateLabel(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DuplicateLabel
    __del__ = lambda self: None
DuplicateLabel_swigregister = _pyAgrum.DuplicateLabel_swigregister
DuplicateLabel_swigregister(DuplicateLabel)

class GraphError(GumException):
    """Proxy of C++ gum::GraphError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GraphError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GraphError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::GraphError self, std::string aMsg, std::string aType) -> GraphError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::GraphError self, std::string aMsg) -> GraphError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_GraphError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_GraphError
    __del__ = lambda self: None
GraphError_swigregister = _pyAgrum.GraphError_swigregister
GraphError_swigregister(GraphError)

class NoNeighbour(GraphError):
    """Proxy of C++ gum::NoNeighbour class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoNeighbour, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoNeighbour, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::NoNeighbour self, std::string aMsg, std::string aType) -> NoNeighbour

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::NoNeighbour self, std::string aMsg) -> NoNeighbour

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_NoNeighbour(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NoNeighbour
    __del__ = lambda self: None
NoNeighbour_swigregister = _pyAgrum.NoNeighbour_swigregister
NoNeighbour_swigregister(NoNeighbour)

class NoParent(GraphError):
    """Proxy of C++ gum::NoParent class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoParent, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoParent, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::NoParent self, std::string aMsg, std::string aType) -> NoParent

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::NoParent self, std::string aMsg) -> NoParent

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_NoParent(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NoParent
    __del__ = lambda self: None
NoParent_swigregister = _pyAgrum.NoParent_swigregister
NoParent_swigregister(NoParent)

class NoChild(GraphError):
    """Proxy of C++ gum::NoChild class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoChild, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoChild, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::NoChild self, std::string aMsg, std::string aType) -> NoChild

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::NoChild self, std::string aMsg) -> NoChild

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_NoChild(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_NoChild
    __del__ = lambda self: None
NoChild_swigregister = _pyAgrum.NoChild_swigregister
NoChild_swigregister(NoChild)

class InvalidEdge(GraphError):
    """Proxy of C++ gum::InvalidEdge class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidEdge, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidEdge, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::InvalidEdge self, std::string aMsg, std::string aType) -> InvalidEdge

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::InvalidEdge self, std::string aMsg) -> InvalidEdge

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_InvalidEdge(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidEdge
    __del__ = lambda self: None
InvalidEdge_swigregister = _pyAgrum.InvalidEdge_swigregister
InvalidEdge_swigregister(InvalidEdge)

class InvalidArc(GraphError):
    """Proxy of C++ gum::InvalidArc class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidArc, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidArc, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::InvalidArc self, std::string aMsg, std::string aType) -> InvalidArc

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::InvalidArc self, std::string aMsg) -> InvalidArc

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_InvalidArc(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidArc
    __del__ = lambda self: None
InvalidArc_swigregister = _pyAgrum.InvalidArc_swigregister
InvalidArc_swigregister(InvalidArc)

class InvalidNode(GraphError):
    """Proxy of C++ gum::InvalidNode class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidNode, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidNode, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::InvalidNode self, std::string aMsg, std::string aType) -> InvalidNode

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::InvalidNode self, std::string aMsg) -> InvalidNode

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_InvalidNode(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidNode
    __del__ = lambda self: None
InvalidNode_swigregister = _pyAgrum.InvalidNode_swigregister
InvalidNode_swigregister(InvalidNode)

class EmptyBSTree(GraphError):
    """Proxy of C++ gum::EmptyBSTree class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EmptyBSTree, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EmptyBSTree, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::EmptyBSTree self, std::string aMsg, std::string aType) -> EmptyBSTree

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::EmptyBSTree self, std::string aMsg) -> EmptyBSTree

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_EmptyBSTree(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_EmptyBSTree
    __del__ = lambda self: None
EmptyBSTree_swigregister = _pyAgrum.EmptyBSTree_swigregister
EmptyBSTree_swigregister(EmptyBSTree)

class DefaultInLabel(GraphError):
    """Proxy of C++ gum::DefaultInLabel class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DefaultInLabel, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DefaultInLabel, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::DefaultInLabel self, std::string aMsg, std::string aType) -> DefaultInLabel

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::DefaultInLabel self, std::string aMsg) -> DefaultInLabel

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_DefaultInLabel(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DefaultInLabel
    __del__ = lambda self: None
DefaultInLabel_swigregister = _pyAgrum.DefaultInLabel_swigregister
DefaultInLabel_swigregister(DefaultInLabel)

class InvalidDirectedCycle(GraphError):
    """Proxy of C++ gum::InvalidDirectedCycle class."""

    __swig_setmethods__ = {}
    for _s in [GraphError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidDirectedCycle, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidDirectedCycle, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::InvalidDirectedCycle self, std::string aMsg, std::string aType) -> InvalidDirectedCycle

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::InvalidDirectedCycle self, std::string aMsg) -> InvalidDirectedCycle

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_InvalidDirectedCycle(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InvalidDirectedCycle
    __del__ = lambda self: None
InvalidDirectedCycle_swigregister = _pyAgrum.InvalidDirectedCycle_swigregister
InvalidDirectedCycle_swigregister(InvalidDirectedCycle)

class CPTError(GumException):
    """Proxy of C++ gum::CPTError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CPTError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CPTError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::CPTError self, std::string aMsg, std::string aType) -> CPTError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::CPTError self, std::string aMsg) -> CPTError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_CPTError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CPTError
    __del__ = lambda self: None
CPTError_swigregister = _pyAgrum.CPTError_swigregister
CPTError_swigregister(CPTError)

class CPTNoSumTo1(CPTError):
    """Proxy of C++ gum::CPTNoSumTo1 class."""

    __swig_setmethods__ = {}
    for _s in [CPTError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CPTNoSumTo1, name, value)
    __swig_getmethods__ = {}
    for _s in [CPTError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CPTNoSumTo1, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::CPTNoSumTo1 self, std::string aMsg, std::string aType) -> CPTNoSumTo1

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::CPTNoSumTo1 self, std::string aMsg) -> CPTNoSumTo1

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_CPTNoSumTo1(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CPTNoSumTo1
    __del__ = lambda self: None
CPTNoSumTo1_swigregister = _pyAgrum.CPTNoSumTo1_swigregister
CPTNoSumTo1_swigregister(CPTNoSumTo1)

class IncompatibleEvidence(GumException):
    """Proxy of C++ gum::IncompatibleEvidence class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IncompatibleEvidence, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IncompatibleEvidence, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::IncompatibleEvidence self, std::string aMsg, std::string aType) -> IncompatibleEvidence

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::IncompatibleEvidence self, std::string aMsg) -> IncompatibleEvidence

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_IncompatibleEvidence(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IncompatibleEvidence
    __del__ = lambda self: None
IncompatibleEvidence_swigregister = _pyAgrum.IncompatibleEvidence_swigregister
IncompatibleEvidence_swigregister(IncompatibleEvidence)

class FactoryError(GumException):
    """Proxy of C++ gum::FactoryError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FactoryError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FactoryError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::FactoryError self, std::string aMsg, std::string aType) -> FactoryError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::FactoryError self, std::string aMsg) -> FactoryError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_FactoryError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_FactoryError
    __del__ = lambda self: None
FactoryError_swigregister = _pyAgrum.FactoryError_swigregister
FactoryError_swigregister(FactoryError)

class FactoryInvalidState(FactoryError):
    """Proxy of C++ gum::FactoryInvalidState class."""

    __swig_setmethods__ = {}
    for _s in [FactoryError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FactoryInvalidState, name, value)
    __swig_getmethods__ = {}
    for _s in [FactoryError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FactoryInvalidState, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::FactoryInvalidState self, std::string aMsg, std::string aType) -> FactoryInvalidState

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::FactoryInvalidState self, std::string aMsg) -> FactoryInvalidState

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_FactoryInvalidState(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_FactoryInvalidState
    __del__ = lambda self: None
FactoryInvalidState_swigregister = _pyAgrum.FactoryInvalidState_swigregister
FactoryInvalidState_swigregister(FactoryInvalidState)

class WrongType(FactoryError):
    """Proxy of C++ gum::WrongType class."""

    __swig_setmethods__ = {}
    for _s in [FactoryError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WrongType, name, value)
    __swig_getmethods__ = {}
    for _s in [FactoryError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WrongType, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::WrongType self, std::string aMsg, std::string aType) -> WrongType

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::WrongType self, std::string aMsg) -> WrongType

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_WrongType(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_WrongType
    __del__ = lambda self: None
WrongType_swigregister = _pyAgrum.WrongType_swigregister
WrongType_swigregister(WrongType)

class WrongClassElement(FactoryError):
    """Proxy of C++ gum::WrongClassElement class."""

    __swig_setmethods__ = {}
    for _s in [FactoryError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WrongClassElement, name, value)
    __swig_getmethods__ = {}
    for _s in [FactoryError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WrongClassElement, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::WrongClassElement self, std::string aMsg, std::string aType) -> WrongClassElement

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::WrongClassElement self, std::string aMsg) -> WrongClassElement

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_WrongClassElement(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_WrongClassElement
    __del__ = lambda self: None
WrongClassElement_swigregister = _pyAgrum.WrongClassElement_swigregister
WrongClassElement_swigregister(WrongClassElement)

class TypeError(FactoryError):
    """Proxy of C++ gum::TypeError class."""

    __swig_setmethods__ = {}
    for _s in [FactoryError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TypeError, name, value)
    __swig_getmethods__ = {}
    for _s in [FactoryError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TypeError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::TypeError self, std::string aMsg, std::string aType) -> TypeError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::TypeError self, std::string aMsg) -> TypeError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_TypeError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_TypeError
    __del__ = lambda self: None
TypeError_swigregister = _pyAgrum.TypeError_swigregister
TypeError_swigregister(TypeError)

class LearningError(GumException):
    """Proxy of C++ gum::LearningError class."""

    __swig_setmethods__ = {}
    for _s in [GumException]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LearningError, name, value)
    __swig_getmethods__ = {}
    for _s in [GumException]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LearningError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::LearningError self, std::string aMsg, std::string aType) -> LearningError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::LearningError self, std::string aMsg) -> LearningError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_LearningError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_LearningError
    __del__ = lambda self: None
LearningError_swigregister = _pyAgrum.LearningError_swigregister
LearningError_swigregister(LearningError)

class IncompatibleScoreApriori(LearningError):
    """Proxy of C++ gum::IncompatibleScoreApriori class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IncompatibleScoreApriori, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IncompatibleScoreApriori, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::IncompatibleScoreApriori self, std::string aMsg, std::string aType) -> IncompatibleScoreApriori

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::IncompatibleScoreApriori self, std::string aMsg) -> IncompatibleScoreApriori

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_IncompatibleScoreApriori(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_IncompatibleScoreApriori
    __del__ = lambda self: None
IncompatibleScoreApriori_swigregister = _pyAgrum.IncompatibleScoreApriori_swigregister
IncompatibleScoreApriori_swigregister(IncompatibleScoreApriori)

class PossiblyIncompatibleScoreApriori(LearningError):
    """Proxy of C++ gum::PossiblyIncompatibleScoreApriori class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PossiblyIncompatibleScoreApriori, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PossiblyIncompatibleScoreApriori, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::PossiblyIncompatibleScoreApriori self, std::string aMsg, std::string aType) -> PossiblyIncompatibleScoreApriori

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::PossiblyIncompatibleScoreApriori self, std::string aMsg) -> PossiblyIncompatibleScoreApriori

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_PossiblyIncompatibleScoreApriori(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_PossiblyIncompatibleScoreApriori
    __del__ = lambda self: None
PossiblyIncompatibleScoreApriori_swigregister = _pyAgrum.PossiblyIncompatibleScoreApriori_swigregister
PossiblyIncompatibleScoreApriori_swigregister(PossiblyIncompatibleScoreApriori)

class DatabaseError(LearningError):
    """Proxy of C++ gum::DatabaseError class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseError, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::DatabaseError self, std::string aMsg, std::string aType) -> DatabaseError

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::DatabaseError self, std::string aMsg) -> DatabaseError

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_DatabaseError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DatabaseError
    __del__ = lambda self: None
DatabaseError_swigregister = _pyAgrum.DatabaseError_swigregister
DatabaseError_swigregister(DatabaseError)

class MissingVariableInDatabase(LearningError):
    """Proxy of C++ gum::MissingVariableInDatabase class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MissingVariableInDatabase, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MissingVariableInDatabase, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::MissingVariableInDatabase self, std::string aMsg, std::string aType) -> MissingVariableInDatabase

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::MissingVariableInDatabase self, std::string aMsg) -> MissingVariableInDatabase

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_MissingVariableInDatabase(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_MissingVariableInDatabase
    __del__ = lambda self: None
MissingVariableInDatabase_swigregister = _pyAgrum.MissingVariableInDatabase_swigregister
MissingVariableInDatabase_swigregister(MissingVariableInDatabase)

class UnknownLabelInDatabase(LearningError):
    """Proxy of C++ gum::UnknownLabelInDatabase class."""

    __swig_setmethods__ = {}
    for _s in [LearningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UnknownLabelInDatabase, name, value)
    __swig_getmethods__ = {}
    for _s in [LearningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UnknownLabelInDatabase, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::UnknownLabelInDatabase self, std::string aMsg, std::string aType) -> UnknownLabelInDatabase

        Parameters
        ----------
        aMsg: std::string
        aType: std::string

        __init__(gum::UnknownLabelInDatabase self, std::string aMsg) -> UnknownLabelInDatabase

        Parameters
        ----------
        aMsg: std::string

        """
        this = _pyAgrum.new_UnknownLabelInDatabase(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UnknownLabelInDatabase
    __del__ = lambda self: None
UnknownLabelInDatabase_swigregister = _pyAgrum.UnknownLabelInDatabase_swigregister
UnknownLabelInDatabase_swigregister(UnknownLabelInDatabase)

class SyntaxError(IOError):
    """Proxy of C++ gum::SyntaxError class."""

    __swig_setmethods__ = {}
    for _s in [IOError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SyntaxError, name, value)
    __swig_getmethods__ = {}
    for _s in [IOError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SyntaxError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::SyntaxError self, std::string const & aMsg, gum::Size nol, gum::Size noc, std::string aType) -> SyntaxError

        Parameters
        ----------
        aMsg: std::string const &
        nol: gum::Size
        noc: gum::Size
        aType: std::string

        __init__(gum::SyntaxError self, std::string const & aMsg, gum::Size nol, gum::Size noc) -> SyntaxError

        Parameters
        ----------
        aMsg: std::string const &
        nol: gum::Size
        noc: gum::Size

        """
        this = _pyAgrum.new_SyntaxError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def col(self) -> "gum::Size":
        """
        col(SyntaxError self) -> gum::Size

        Parameters
        ----------
        self: gum::SyntaxError const *

        """
        return _pyAgrum.SyntaxError_col(self)


    def line(self) -> "gum::Size":
        """
        line(SyntaxError self) -> gum::Size

        Parameters
        ----------
        self: gum::SyntaxError const *

        """
        return _pyAgrum.SyntaxError_line(self)

    __swig_destroy__ = _pyAgrum.delete_SyntaxError
    __del__ = lambda self: None
SyntaxError_swigregister = _pyAgrum.SyntaxError_swigregister
SyntaxError_swigregister(SyntaxError)


def randomProba() -> "double":
    """randomProba() -> double"""
    return _pyAgrum.randomProba()

def randomGeneratorSeed() -> "unsigned int":
    """randomGeneratorSeed() -> unsigned int"""
    return _pyAgrum.randomGeneratorSeed()

def initRandom(seed: 'unsigned int'=0) -> "void":
    """
    initRandom(unsigned int seed=0)

    Parameters
    ----------
    seed: unsigned int

    initRandom()
    """
    return _pyAgrum.initRandom(seed)

def getRandomGenerator(seed: 'unsigned int'=0) -> "std::default_random_engine":
    """
    getRandomGenerator(unsigned int seed=0) -> std::default_random_engine

    Parameters
    ----------
    seed: unsigned int

    getRandomGenerator() -> std::default_random_engine
    """
    return _pyAgrum.getRandomGenerator(seed)

def isOMP() -> "bool":
    """isOMP() -> bool"""
    return _pyAgrum.isOMP()

def setNumberOfThreads(number: 'unsigned int') -> "void":
    """
    setNumberOfThreads(unsigned int number)

    Parameters
    ----------
    number: unsigned int

    """
    return _pyAgrum.setNumberOfThreads(number)

def getMaxNumberOfThreads() -> "unsigned int":
    """getMaxNumberOfThreads() -> unsigned int"""
    return _pyAgrum.getMaxNumberOfThreads()

def getThreadNumber() -> "unsigned int":
    """getThreadNumber() -> unsigned int"""
    return _pyAgrum.getThreadNumber()

def getNumberOfRunningThreads() -> "unsigned int":
    """getNumberOfRunningThreads() -> unsigned int"""
    return _pyAgrum.getNumberOfRunningThreads()

def getNumberOfLogicalProcessors() -> "unsigned int":
    """getNumberOfLogicalProcessors() -> unsigned int"""
    return _pyAgrum.getNumberOfLogicalProcessors()

def setNestedParallelism(value: 'bool') -> "void":
    """
    setNestedParallelism(bool value)

    Parameters
    ----------
    value: bool

    """
    return _pyAgrum.setNestedParallelism(value)

def getNestedParallelism() -> "bool":
    """getNestedParallelism() -> bool"""
    return _pyAgrum.getNestedParallelism()

def setDynamicThreadsNumber(value: 'bool') -> "void":
    """
    setDynamicThreadsNumber(bool value)

    Parameters
    ----------
    value: bool

    """
    return _pyAgrum.setDynamicThreadsNumber(value)

def getDynamicThreadsNumber() -> "bool":
    """getDynamicThreadsNumber() -> bool"""
    return _pyAgrum.getDynamicThreadsNumber()
class Variable(_object):
    """Proxy of C++ gum::Variable class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Variable, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Variable, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_Variable
    __del__ = lambda self: None

    def clone(self) -> "gum::Variable *":
        """
        clone(Variable self) -> Variable

        Parameters
        ----------
        self: gum::Variable const *

        """
        return _pyAgrum.Variable_clone(self)


    def __eq__(self, aRV: 'Variable') -> "bool":
        """
        __eq__(Variable self, Variable aRV) -> bool

        Parameters
        ----------
        aRV: gum::Variable const &

        """
        return _pyAgrum.Variable___eq__(self, aRV)


    def __ne__(self, aRV: 'Variable') -> "bool":
        """
        __ne__(Variable self, Variable aRV) -> bool

        Parameters
        ----------
        aRV: gum::Variable const &

        """
        return _pyAgrum.Variable___ne__(self, aRV)


    def setName(self, theValue: 'std::string const &') -> "void":
        """
        setName(Variable self, std::string const & theValue)

        Parameters
        ----------
        theValue: std::string const &

        """
        return _pyAgrum.Variable_setName(self, theValue)


    def name(self) -> "std::string const &":
        """
        name(Variable self) -> std::string const &

        Parameters
        ----------
        self: gum::Variable const *

        """
        return _pyAgrum.Variable_name(self)


    def setDescription(self, theValue: 'std::string const &') -> "void":
        """
        setDescription(Variable self, std::string const & theValue)

        Parameters
        ----------
        theValue: std::string const &

        """
        return _pyAgrum.Variable_setDescription(self, theValue)


    def description(self) -> "std::string const &":
        """
        description(Variable self) -> std::string const &

        Parameters
        ----------
        self: gum::Variable const *

        """
        return _pyAgrum.Variable_description(self)

Variable_swigregister = _pyAgrum.Variable_swigregister
Variable_swigregister(Variable)

class DiscreteVariable(Variable):
    """Proxy of C++ gum::DiscreteVariable class."""

    __swig_setmethods__ = {}
    for _s in [Variable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DiscreteVariable, name, value)
    __swig_getmethods__ = {}
    for _s in [Variable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DiscreteVariable, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    VarType_Discretized = _pyAgrum.DiscreteVariable_VarType_Discretized
    VarType_Labelized = _pyAgrum.DiscreteVariable_VarType_Labelized
    VarType_Range = _pyAgrum.DiscreteVariable_VarType_Range
    __swig_destroy__ = _pyAgrum.delete_DiscreteVariable
    __del__ = lambda self: None

    def clone(self) -> "gum::DiscreteVariable *":
        """
        clone(DiscreteVariable self) -> DiscreteVariable

        Parameters
        ----------
        self: gum::DiscreteVariable const *

        """
        return _pyAgrum.DiscreteVariable_clone(self)


    def empty(self) -> "bool":
        """
        empty(DiscreteVariable self) -> bool

        Parameters
        ----------
        self: gum::DiscreteVariable const *

        """
        return _pyAgrum.DiscreteVariable_empty(self)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(DiscreteVariable self) -> gum::Size

        Parameters
        ----------
        self: gum::DiscreteVariable const *

        """
        return _pyAgrum.DiscreteVariable_domainSize(self)


    def labels(self) -> "std::vector< std::string,std::allocator< std::string > >":
        """
        labels(DiscreteVariable self) -> Vector_string

        Parameters
        ----------
        self: gum::DiscreteVariable const *

        """
        return _pyAgrum.DiscreteVariable_labels(self)


    def numerical(self, indice: 'gum::Idx') -> "double":
        """
        numerical(DiscreteVariable self, gum::Idx indice) -> double

        Parameters
        ----------
        indice: gum::Idx

        """
        return _pyAgrum.DiscreteVariable_numerical(self, indice)


    def varType(self) -> "gum::DiscreteVariable::VarType":
        """
        varType(DiscreteVariable self) -> gum::DiscreteVariable::VarType

        Parameters
        ----------
        self: gum::DiscreteVariable const *

        """
        return _pyAgrum.DiscreteVariable_varType(self)


    def __eq__(self, aRV: 'DiscreteVariable') -> "bool":
        """
        __eq__(DiscreteVariable self, DiscreteVariable aRV) -> bool

        Parameters
        ----------
        aRV: gum::DiscreteVariable const &

        """
        return _pyAgrum.DiscreteVariable___eq__(self, aRV)


    def __ne__(self, aRV: 'DiscreteVariable') -> "bool":
        """
        __ne__(DiscreteVariable self, DiscreteVariable aRV) -> bool

        Parameters
        ----------
        aRV: gum::DiscreteVariable const &

        """
        return _pyAgrum.DiscreteVariable___ne__(self, aRV)


    def index(self, label: 'std::string const &') -> "gum::Idx":
        """
        index(DiscreteVariable self, std::string const & label) -> gum::Idx

        Parameters
        ----------
        label: std::string const &

        """
        return _pyAgrum.DiscreteVariable_index(self, label)


    def label(self, i: 'gum::Idx') -> "std::string":
        """
        label(DiscreteVariable self, gum::Idx i) -> std::string

        Parameters
        ----------
        i: gum::Idx

        """
        return _pyAgrum.DiscreteVariable_label(self, i)


    def __str__(self) -> "std::string const":
        """
        __str__(DiscreteVariable self) -> std::string const

        Parameters
        ----------
        self: gum::DiscreteVariable const *

        """
        return _pyAgrum.DiscreteVariable___str__(self)


    def toStringWithDescription(self) -> "std::string const":
        """
        toStringWithDescription(DiscreteVariable self) -> std::string const

        Parameters
        ----------
        self: gum::DiscreteVariable const *

        """
        return _pyAgrum.DiscreteVariable_toStringWithDescription(self)


    def domain(self) -> "std::string const":
        """
        domain(DiscreteVariable self) -> std::string const

        Parameters
        ----------
        self: gum::DiscreteVariable const *

        """
        return _pyAgrum.DiscreteVariable_domain(self)


    def __getitem__(self,label):   # adding the y() function here
        return self.index(label)


    def toLabelizedVar(self) -> "gum::LabelizedVariable &":
        """
        toLabelizedVar(DiscreteVariable self) -> LabelizedVariable

        Parameters
        ----------
        self: gum::DiscreteVariable *

        """
        return _pyAgrum.DiscreteVariable_toLabelizedVar(self)


    def toRangeVar(self) -> "gum::RangeVariable &":
        """
        toRangeVar(DiscreteVariable self) -> RangeVariable

        Parameters
        ----------
        self: gum::DiscreteVariable *

        """
        return _pyAgrum.DiscreteVariable_toRangeVar(self)


    def toDiscretizedVar(self) -> "gum::DiscretizedVariable< double > &":
        """
        toDiscretizedVar(DiscreteVariable self) -> DiscretizedVariable_double

        Parameters
        ----------
        self: gum::DiscreteVariable *

        """
        return _pyAgrum.DiscreteVariable_toDiscretizedVar(self)

DiscreteVariable_swigregister = _pyAgrum.DiscreteVariable_swigregister
DiscreteVariable_swigregister(DiscreteVariable)

class LabelizedVariable(DiscreteVariable):
    """Proxy of C++ gum::LabelizedVariable class."""

    __swig_setmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LabelizedVariable, name, value)
    __swig_getmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LabelizedVariable, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::LabelizedVariable self, std::string const & aName, std::string const & aDesc, int const nbrLabel=2) -> LabelizedVariable

        Parameters
        ----------
        aName: std::string const &
        aDesc: std::string const &
        nbrLabel: int const

        __init__(gum::LabelizedVariable self, std::string const & aName, std::string const & aDesc) -> LabelizedVariable

        Parameters
        ----------
        aName: std::string const &
        aDesc: std::string const &

        __init__(gum::LabelizedVariable self, std::string const & aName) -> LabelizedVariable

        Parameters
        ----------
        aName: std::string const &

        __init__(gum::LabelizedVariable self, LabelizedVariable aLDRV) -> LabelizedVariable

        Parameters
        ----------
        aLDRV: gum::LabelizedVariable const &

        """
        this = _pyAgrum.new_LabelizedVariable(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_LabelizedVariable
    __del__ = lambda self: None

    def clone(self) -> "gum::DiscreteVariable *":
        """
        clone(LabelizedVariable self) -> DiscreteVariable

        Parameters
        ----------
        self: gum::LabelizedVariable const *

        """
        return _pyAgrum.LabelizedVariable_clone(self)


    def index(self, label: 'std::string const &') -> "gum::Idx":
        """
        index(LabelizedVariable self, std::string const & label) -> gum::Idx

        Parameters
        ----------
        label: std::string const &

        """
        return _pyAgrum.LabelizedVariable_index(self, label)


    def isLabel(self, aLabel: 'std::string const &') -> "bool":
        """
        isLabel(LabelizedVariable self, std::string const & aLabel) -> bool

        Parameters
        ----------
        aLabel: std::string const &

        """
        return _pyAgrum.LabelizedVariable_isLabel(self, aLabel)


    def addLabel(self,*args):
      _pyAgrum.LabelizedVariable_addLabel(self,*args)
      return self



    def changeLabel(self, pos: 'gum::Idx', aLabel: 'std::string const') -> "void":
        """
        changeLabel(LabelizedVariable self, gum::Idx pos, std::string const aLabel)

        Parameters
        ----------
        pos: gum::Idx
        aLabel: std::string const

        """
        return _pyAgrum.LabelizedVariable_changeLabel(self, pos, aLabel)


    def eraseLabels(self) -> "void":
        """
        eraseLabels(LabelizedVariable self)

        Parameters
        ----------
        self: gum::LabelizedVariable *

        """
        return _pyAgrum.LabelizedVariable_eraseLabels(self)


    def label(self, i: 'gum::Idx') -> "std::string":
        """
        label(LabelizedVariable self, gum::Idx i) -> std::string

        Parameters
        ----------
        i: gum::Idx

        """
        return _pyAgrum.LabelizedVariable_label(self, i)


    def numerical(self, indice: 'gum::Idx') -> "double":
        """
        numerical(LabelizedVariable self, gum::Idx indice) -> double

        Parameters
        ----------
        indice: gum::Idx

        """
        return _pyAgrum.LabelizedVariable_numerical(self, indice)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(LabelizedVariable self) -> gum::Size

        Parameters
        ----------
        self: gum::LabelizedVariable const *

        """
        return _pyAgrum.LabelizedVariable_domainSize(self)


    def varType(self) -> "gum::DiscreteVariable::VarType":
        """
        varType(LabelizedVariable self) -> gum::DiscreteVariable::VarType

        Parameters
        ----------
        self: gum::LabelizedVariable const *

        """
        return _pyAgrum.LabelizedVariable_varType(self)


    def domain(self) -> "std::string const":
        """
        domain(LabelizedVariable self) -> std::string const

        Parameters
        ----------
        self: gum::LabelizedVariable const *

        """
        return _pyAgrum.LabelizedVariable_domain(self)

LabelizedVariable_swigregister = _pyAgrum.LabelizedVariable_swigregister
LabelizedVariable_swigregister(LabelizedVariable)

class RangeVariable(DiscreteVariable):
    """Proxy of C++ gum::RangeVariable class."""

    __swig_setmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RangeVariable, name, value)
    __swig_getmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RangeVariable, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::RangeVariable self, std::string const & aName, std::string const & aDesc, long minVal=0, long maxVal=1) -> RangeVariable

        Parameters
        ----------
        aName: std::string const &
        aDesc: std::string const &
        minVal: long
        maxVal: long

        __init__(gum::RangeVariable self, std::string const & aName, std::string const & aDesc, long minVal=0) -> RangeVariable

        Parameters
        ----------
        aName: std::string const &
        aDesc: std::string const &
        minVal: long

        __init__(gum::RangeVariable self, std::string const & aName, std::string const & aDesc) -> RangeVariable

        Parameters
        ----------
        aName: std::string const &
        aDesc: std::string const &

        __init__(gum::RangeVariable self, RangeVariable aDRV) -> RangeVariable

        Parameters
        ----------
        aDRV: gum::RangeVariable const &

        """
        this = _pyAgrum.new_RangeVariable(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_RangeVariable
    __del__ = lambda self: None

    def clone(self) -> "gum::DiscreteVariable *":
        """
        clone(RangeVariable self) -> DiscreteVariable

        Parameters
        ----------
        self: gum::RangeVariable const *

        """
        return _pyAgrum.RangeVariable_clone(self)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(RangeVariable self) -> gum::Size

        Parameters
        ----------
        self: gum::RangeVariable const *

        """
        return _pyAgrum.RangeVariable_domainSize(self)


    def varType(self) -> "gum::DiscreteVariable::VarType":
        """
        varType(RangeVariable self) -> gum::DiscreteVariable::VarType

        Parameters
        ----------
        self: gum::RangeVariable const *

        """
        return _pyAgrum.RangeVariable_varType(self)


    def label(self, indice: 'gum::Idx') -> "std::string":
        """
        label(RangeVariable self, gum::Idx indice) -> std::string

        Parameters
        ----------
        indice: gum::Idx

        """
        return _pyAgrum.RangeVariable_label(self, indice)


    def numerical(self, indice: 'gum::Idx') -> "double":
        """
        numerical(RangeVariable self, gum::Idx indice) -> double

        Parameters
        ----------
        indice: gum::Idx

        """
        return _pyAgrum.RangeVariable_numerical(self, indice)


    def minVal(self) -> "long":
        """
        minVal(RangeVariable self) -> long

        Parameters
        ----------
        self: gum::RangeVariable const *

        """
        return _pyAgrum.RangeVariable_minVal(self)


    def setMinVal(self, minVal: 'long') -> "void":
        """
        setMinVal(RangeVariable self, long minVal)

        Parameters
        ----------
        minVal: long

        """
        return _pyAgrum.RangeVariable_setMinVal(self, minVal)


    def maxVal(self) -> "long":
        """
        maxVal(RangeVariable self) -> long

        Parameters
        ----------
        self: gum::RangeVariable const *

        """
        return _pyAgrum.RangeVariable_maxVal(self)


    def setMaxVal(self, maxVal: 'long') -> "void":
        """
        setMaxVal(RangeVariable self, long maxVal)

        Parameters
        ----------
        maxVal: long

        """
        return _pyAgrum.RangeVariable_setMaxVal(self, maxVal)


    def belongs(self, val: 'long') -> "bool":
        """
        belongs(RangeVariable self, long val) -> bool

        Parameters
        ----------
        val: long

        """
        return _pyAgrum.RangeVariable_belongs(self, val)


    def index(self, arg2: 'std::string const &') -> "gum::Idx":
        """
        index(RangeVariable self, std::string const & arg2) -> gum::Idx

        Parameters
        ----------
        arg2: std::string const &

        """
        return _pyAgrum.RangeVariable_index(self, arg2)


    def domain(self) -> "std::string const":
        """
        domain(RangeVariable self) -> std::string const

        Parameters
        ----------
        self: gum::RangeVariable const *

        """
        return _pyAgrum.RangeVariable_domain(self)

RangeVariable_swigregister = _pyAgrum.RangeVariable_swigregister
RangeVariable_swigregister(RangeVariable)

INC_MARKS_ARRAY = _pyAgrum.INC_MARKS_ARRAY
class Edge(_object):
    """Proxy of C++ gum::Edge class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Edge, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Edge, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::Edge self, gum::NodeId aN1, gum::NodeId aN2) -> Edge

        Parameters
        ----------
        aN1: gum::NodeId
        aN2: gum::NodeId

        __init__(gum::Edge self, Edge src) -> Edge

        Parameters
        ----------
        src: gum::Edge const &

        """
        this = _pyAgrum.new_Edge(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_Edge
    __del__ = lambda self: None

    def other(self, id: 'gum::NodeId') -> "gum::NodeId":
        """
        other(Edge self, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.Edge_other(self, id)


    def first(self) -> "gum::NodeId":
        """
        first(Edge self) -> gum::NodeId

        Parameters
        ----------
        self: gum::Edge const *

        """
        return _pyAgrum.Edge_first(self)


    def second(self) -> "gum::NodeId":
        """
        second(Edge self) -> gum::NodeId

        Parameters
        ----------
        self: gum::Edge const *

        """
        return _pyAgrum.Edge_second(self)


    def __eq__(self, src: 'Edge') -> "bool":
        """
        __eq__(Edge self, Edge src) -> bool

        Parameters
        ----------
        src: gum::Edge const &

        """
        return _pyAgrum.Edge___eq__(self, src)


    def __ne__(self, src: 'Edge') -> "bool":
        """
        __ne__(Edge self, Edge src) -> bool

        Parameters
        ----------
        src: gum::Edge const &

        """
        return _pyAgrum.Edge___ne__(self, src)

Edge_swigregister = _pyAgrum.Edge_swigregister
Edge_swigregister(Edge)

class Arc(_object):
    """Proxy of C++ gum::Arc class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Arc, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Arc, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::Arc self, gum::NodeId tail, gum::NodeId head) -> Arc

        Parameters
        ----------
        tail: gum::NodeId
        head: gum::NodeId

        __init__(gum::Arc self, Arc src) -> Arc

        Parameters
        ----------
        src: gum::Arc const &

        """
        this = _pyAgrum.new_Arc(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_Arc
    __del__ = lambda self: None

    def tail(self) -> "gum::NodeId":
        """
        tail(Arc self) -> gum::NodeId

        Parameters
        ----------
        self: gum::Arc const *

        """
        return _pyAgrum.Arc_tail(self)


    def head(self) -> "gum::NodeId":
        """
        head(Arc self) -> gum::NodeId

        Parameters
        ----------
        self: gum::Arc const *

        """
        return _pyAgrum.Arc_head(self)


    def other(self, id: 'gum::NodeId') -> "gum::NodeId":
        """
        other(Arc self, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.Arc_other(self, id)


    def first(self) -> "gum::NodeId":
        """
        first(Arc self) -> gum::NodeId

        Parameters
        ----------
        self: gum::Arc const *

        """
        return _pyAgrum.Arc_first(self)


    def second(self) -> "gum::NodeId":
        """
        second(Arc self) -> gum::NodeId

        Parameters
        ----------
        self: gum::Arc const *

        """
        return _pyAgrum.Arc_second(self)


    def __eq__(self, src: 'Arc') -> "bool":
        """
        __eq__(Arc self, Arc src) -> bool

        Parameters
        ----------
        src: gum::Arc const &

        """
        return _pyAgrum.Arc___eq__(self, src)


    def __ne__(self, src: 'Arc') -> "bool":
        """
        __ne__(Arc self, Arc src) -> bool

        Parameters
        ----------
        src: gum::Arc const &

        """
        return _pyAgrum.Arc___ne__(self, src)

Arc_swigregister = _pyAgrum.Arc_swigregister
Arc_swigregister(Arc)

class DiGraph(_object):
    """Proxy of C++ gum::DiGraph class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DiGraph, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DiGraph, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::DiGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size arcs_size, bool arcs_resize_policy=True) -> DiGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        arcs_size: gum::Size
        arcs_resize_policy: bool

        __init__(gum::DiGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size arcs_size) -> DiGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        arcs_size: gum::Size

        __init__(gum::DiGraph self, gum::Size nodes_size, bool nodes_resize_policy=True) -> DiGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool

        __init__(gum::DiGraph self, gum::Size nodes_size) -> DiGraph

        Parameters
        ----------
        nodes_size: gum::Size

        __init__(gum::DiGraph self) -> DiGraph
        __init__(gum::DiGraph self, DiGraph g) -> DiGraph

        Parameters
        ----------
        g: gum::DiGraph const &

        """
        this = _pyAgrum.new_DiGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DiGraph
    __del__ = lambda self: None

    def __eq__(self, g: 'DiGraph') -> "bool":
        """
        __eq__(DiGraph self, DiGraph g) -> bool

        Parameters
        ----------
        g: gum::DiGraph const &

        """
        return _pyAgrum.DiGraph___eq__(self, g)


    def __ne__(self, g: 'DiGraph') -> "bool":
        """
        __ne__(DiGraph self, DiGraph g) -> bool

        Parameters
        ----------
        g: gum::DiGraph const &

        """
        return _pyAgrum.DiGraph___ne__(self, g)


    def addArc(self, tail: 'gum::NodeId const', head: 'gum::NodeId const') -> "void":
        """
        addArc(DiGraph self, gum::NodeId const tail, gum::NodeId const head)

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        """
        return _pyAgrum.DiGraph_addArc(self, tail, head)


    def eraseNode(self, id: 'gum::NodeId const') -> "void":
        """
        eraseNode(DiGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.DiGraph_eraseNode(self, id)


    def clear(self) -> "void":
        """
        clear(DiGraph self)

        Parameters
        ----------
        self: gum::DiGraph *

        """
        return _pyAgrum.DiGraph_clear(self)


    def __str__(self) -> "std::string const":
        """
        __str__(DiGraph self) -> std::string const

        Parameters
        ----------
        self: gum::DiGraph const *

        """
        return _pyAgrum.DiGraph___str__(self)


    def toDot(self, *args) -> "std::string const":
        """
        toDot(DiGraph self, std::string const & name) -> std::string const

        Parameters
        ----------
        name: std::string const &

        toDot(DiGraph self) -> std::string const

        Parameters
        ----------
        self: gum::DiGraph const *

        """
        return _pyAgrum.DiGraph_toDot(self, *args)


    def topologicalOrder(self, clear: 'bool'=True) -> "gum::Sequence< gum::NodeId > const &":
        """
        topologicalOrder(DiGraph self, bool clear=True) -> gum::Sequence< gum::NodeId > const

        Parameters
        ----------
        clear: bool

        topologicalOrder(DiGraph self) -> gum::Sequence< gum::NodeId > const &

        Parameters
        ----------
        self: gum::DiGraph const *

        """
        return _pyAgrum.DiGraph_topologicalOrder(self, clear)


    def ids(self) -> "PyObject *":
        """
        ids(DiGraph self) -> PyObject *

        Parameters
        ----------
        self: gum::DiGraph *

        """
        return _pyAgrum.DiGraph_ids(self)


    def arcs(self) -> "PyObject *":
        """
        arcs(DiGraph self) -> PyObject *

        Parameters
        ----------
        self: gum::DiGraph *

        """
        return _pyAgrum.DiGraph_arcs(self)


    def parents(self, id: 'gum::NodeId') -> "PyObject *":
        """
        parents(DiGraph self, gum::NodeId id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.DiGraph_parents(self, id)


    def children(self, id: 'gum::NodeId') -> "PyObject *":
        """
        children(DiGraph self, gum::NodeId id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.DiGraph_children(self, id)


    def addNode(self, *args) -> "void":
        """
        addNode(DiGraph self) -> gum::NodeId
        addNode(DiGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.DiGraph_addNode(self, *args)


    def existsNode(self, id: 'gum::NodeId const') -> "bool":
        """
        existsNode(DiGraph self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.DiGraph_existsNode(self, id)


    def size(self) -> "gum::Size":
        """
        size(DiGraph self) -> gum::Size

        Parameters
        ----------
        self: gum::DiGraph const *

        """
        return _pyAgrum.DiGraph_size(self)


    def empty(self) -> "bool":
        """
        empty(DiGraph self) -> bool

        Parameters
        ----------
        self: gum::DiGraph const *

        """
        return _pyAgrum.DiGraph_empty(self)


    def eraseArc(self, arc: 'Arc') -> "void":
        """
        eraseArc(DiGraph self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        """
        return _pyAgrum.DiGraph_eraseArc(self, arc)


    def existsArc(self, *args) -> "bool":
        """
        existsArc(DiGraph self, Arc arc) -> bool

        Parameters
        ----------
        arc: gum::Arc const &

        existsArc(DiGraph self, gum::NodeId const tail, gum::NodeId const head) -> bool

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        """
        return _pyAgrum.DiGraph_existsArc(self, *args)


    def eraseParents(self, id: 'gum::NodeId const') -> "void":
        """
        eraseParents(DiGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.DiGraph_eraseParents(self, id)


    def eraseChildren(self, id: 'gum::NodeId const') -> "void":
        """
        eraseChildren(DiGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.DiGraph_eraseChildren(self, id)


    def sizeArcs(self) -> "gum::Size":
        """
        sizeArcs(DiGraph self) -> gum::Size

        Parameters
        ----------
        self: gum::DiGraph const *

        """
        return _pyAgrum.DiGraph_sizeArcs(self)


    def emptyArcs(self) -> "bool":
        """
        emptyArcs(DiGraph self) -> bool

        Parameters
        ----------
        self: gum::DiGraph const *

        """
        return _pyAgrum.DiGraph_emptyArcs(self)

DiGraph_swigregister = _pyAgrum.DiGraph_swigregister
DiGraph_swigregister(DiGraph)

class DAG(DiGraph):
    """Proxy of C++ gum::DAG class."""

    __swig_setmethods__ = {}
    for _s in [DiGraph]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DAG, name, value)
    __swig_getmethods__ = {}
    for _s in [DiGraph]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DAG, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::DAG self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size arcs_size, bool arcs_resize_policy=True) -> DAG

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        arcs_size: gum::Size
        arcs_resize_policy: bool

        __init__(gum::DAG self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size arcs_size) -> DAG

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        arcs_size: gum::Size

        __init__(gum::DAG self, gum::Size nodes_size, bool nodes_resize_policy=True) -> DAG

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool

        __init__(gum::DAG self, gum::Size nodes_size) -> DAG

        Parameters
        ----------
        nodes_size: gum::Size

        __init__(gum::DAG self) -> DAG
        __init__(gum::DAG self, DAG g) -> DAG

        Parameters
        ----------
        g: gum::DAG const &

        """
        this = _pyAgrum.new_DAG(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DAG
    __del__ = lambda self: None

    def addArc(self, tail: 'gum::NodeId const', head: 'gum::NodeId const') -> "void":
        """
        addArc(DAG self, gum::NodeId const tail, gum::NodeId const head)

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        """
        return _pyAgrum.DAG_addArc(self, tail, head)

DAG_swigregister = _pyAgrum.DAG_swigregister
DAG_swigregister(DAG)

class UndiGraph(_object):
    """Proxy of C++ gum::UndiGraph class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, UndiGraph, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, UndiGraph, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::UndiGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size edges_size, bool edges_resize_policy=True) -> UndiGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        edges_size: gum::Size
        edges_resize_policy: bool

        __init__(gum::UndiGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size edges_size) -> UndiGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        edges_size: gum::Size

        __init__(gum::UndiGraph self, gum::Size nodes_size, bool nodes_resize_policy=True) -> UndiGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool

        __init__(gum::UndiGraph self, gum::Size nodes_size) -> UndiGraph

        Parameters
        ----------
        nodes_size: gum::Size

        __init__(gum::UndiGraph self) -> UndiGraph
        __init__(gum::UndiGraph self, UndiGraph g) -> UndiGraph

        Parameters
        ----------
        g: gum::UndiGraph const &

        """
        this = _pyAgrum.new_UndiGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_UndiGraph
    __del__ = lambda self: None

    def __eq__(self, g: 'UndiGraph') -> "bool":
        """
        __eq__(UndiGraph self, UndiGraph g) -> bool

        Parameters
        ----------
        g: gum::UndiGraph const &

        """
        return _pyAgrum.UndiGraph___eq__(self, g)


    def __ne__(self, g: 'UndiGraph') -> "bool":
        """
        __ne__(UndiGraph self, UndiGraph g) -> bool

        Parameters
        ----------
        g: gum::UndiGraph const &

        """
        return _pyAgrum.UndiGraph___ne__(self, g)


    def addEdge(self, first: 'gum::NodeId const', second: 'gum::NodeId const') -> "void":
        """
        addEdge(UndiGraph self, gum::NodeId const first, gum::NodeId const second)

        Parameters
        ----------
        first: gum::NodeId const
        second: gum::NodeId const

        """
        return _pyAgrum.UndiGraph_addEdge(self, first, second)


    def eraseNode(self, id: 'gum::NodeId const') -> "void":
        """
        eraseNode(UndiGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.UndiGraph_eraseNode(self, id)


    def clear(self) -> "void":
        """
        clear(UndiGraph self)

        Parameters
        ----------
        self: gum::UndiGraph *

        """
        return _pyAgrum.UndiGraph_clear(self)


    def __str__(self) -> "std::string const":
        """
        __str__(UndiGraph self) -> std::string const

        Parameters
        ----------
        self: gum::UndiGraph const *

        """
        return _pyAgrum.UndiGraph___str__(self)


    def toDot(self) -> "std::string const":
        """
        toDot(UndiGraph self) -> std::string const

        Parameters
        ----------
        self: gum::UndiGraph const *

        """
        return _pyAgrum.UndiGraph_toDot(self)


    def hasUndirectedCycle(self) -> "bool":
        """
        hasUndirectedCycle(UndiGraph self) -> bool

        Parameters
        ----------
        self: gum::UndiGraph const *

        """
        return _pyAgrum.UndiGraph_hasUndirectedCycle(self)


    def partialUndiGraph(self, nodesSet: 'gum::NodeSet') -> "gum::UndiGraph":
        """
        partialUndiGraph(UndiGraph self, gum::NodeSet nodesSet) -> UndiGraph

        Parameters
        ----------
        nodesSet: gum::NodeSet

        """
        return _pyAgrum.UndiGraph_partialUndiGraph(self, nodesSet)


    def ids(self) -> "PyObject *":
        """
        ids(UndiGraph self) -> PyObject *

        Parameters
        ----------
        self: gum::UndiGraph *

        """
        return _pyAgrum.UndiGraph_ids(self)


    def edges(self) -> "PyObject *":
        """
        edges(UndiGraph self) -> PyObject *

        Parameters
        ----------
        self: gum::UndiGraph *

        """
        return _pyAgrum.UndiGraph_edges(self)


    def neighbours(self, id: 'gum::NodeId') -> "PyObject *":
        """
        neighbours(UndiGraph self, gum::NodeId id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.UndiGraph_neighbours(self, id)


    def addNode(self, *args) -> "void":
        """
        addNode(UndiGraph self) -> gum::NodeId
        addNode(UndiGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.UndiGraph_addNode(self, *args)


    def existsNode(self, id: 'gum::NodeId const') -> "bool":
        """
        existsNode(UndiGraph self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.UndiGraph_existsNode(self, id)


    def size(self) -> "gum::Size":
        """
        size(UndiGraph self) -> gum::Size

        Parameters
        ----------
        self: gum::UndiGraph const *

        """
        return _pyAgrum.UndiGraph_size(self)


    def empty(self) -> "bool":
        """
        empty(UndiGraph self) -> bool

        Parameters
        ----------
        self: gum::UndiGraph const *

        """
        return _pyAgrum.UndiGraph_empty(self)


    def eraseEdge(self, edge: 'Edge') -> "void":
        """
        eraseEdge(UndiGraph self, Edge edge)

        Parameters
        ----------
        edge: gum::Edge const &

        """
        return _pyAgrum.UndiGraph_eraseEdge(self, edge)


    def existsEdge(self, *args) -> "bool":
        """
        existsEdge(UndiGraph self, Edge edge) -> bool

        Parameters
        ----------
        edge: gum::Edge const &

        existsEdge(UndiGraph self, gum::NodeId const n1, gum::NodeId const n2) -> bool

        Parameters
        ----------
        n1: gum::NodeId const
        n2: gum::NodeId const

        """
        return _pyAgrum.UndiGraph_existsEdge(self, *args)


    def sizeEdges(self) -> "gum::Size":
        """
        sizeEdges(UndiGraph self) -> gum::Size

        Parameters
        ----------
        self: gum::UndiGraph const *

        """
        return _pyAgrum.UndiGraph_sizeEdges(self)


    def emptyEdges(self) -> "bool":
        """
        emptyEdges(UndiGraph self) -> bool

        Parameters
        ----------
        self: gum::UndiGraph const *

        """
        return _pyAgrum.UndiGraph_emptyEdges(self)


    def eraseNeighbours(self, id: 'gum::NodeId const') -> "void":
        """
        eraseNeighbours(UndiGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.UndiGraph_eraseNeighbours(self, id)

UndiGraph_swigregister = _pyAgrum.UndiGraph_swigregister
UndiGraph_swigregister(UndiGraph)

class MixedGraph(UndiGraph, DiGraph):
    """Proxy of C++ gum::MixedGraph class."""

    __swig_setmethods__ = {}
    for _s in [UndiGraph, DiGraph]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MixedGraph, name, value)
    __swig_getmethods__ = {}
    for _s in [UndiGraph, DiGraph]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MixedGraph, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::MixedGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size arcs_size, bool arcs_resize_policy=True, gum::Size edges_size, bool edges_resize_policy=True) -> MixedGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        arcs_size: gum::Size
        arcs_resize_policy: bool
        edges_size: gum::Size
        edges_resize_policy: bool

        __init__(gum::MixedGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size arcs_size, bool arcs_resize_policy=True, gum::Size edges_size) -> MixedGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        arcs_size: gum::Size
        arcs_resize_policy: bool
        edges_size: gum::Size

        __init__(gum::MixedGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size arcs_size, bool arcs_resize_policy=True) -> MixedGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        arcs_size: gum::Size
        arcs_resize_policy: bool

        __init__(gum::MixedGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size arcs_size) -> MixedGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        arcs_size: gum::Size

        __init__(gum::MixedGraph self, gum::Size nodes_size, bool nodes_resize_policy=True) -> MixedGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool

        __init__(gum::MixedGraph self, gum::Size nodes_size) -> MixedGraph

        Parameters
        ----------
        nodes_size: gum::Size

        __init__(gum::MixedGraph self) -> MixedGraph
        __init__(gum::MixedGraph self, MixedGraph g) -> MixedGraph

        Parameters
        ----------
        g: gum::MixedGraph const &

        """
        this = _pyAgrum.new_MixedGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_MixedGraph
    __del__ = lambda self: None

    def __eq__(self, g: 'MixedGraph') -> "bool":
        """
        __eq__(MixedGraph self, MixedGraph g) -> bool

        Parameters
        ----------
        g: gum::MixedGraph const &

        """
        return _pyAgrum.MixedGraph___eq__(self, g)


    def __ne__(self, g: 'MixedGraph') -> "bool":
        """
        __ne__(MixedGraph self, MixedGraph g) -> bool

        Parameters
        ----------
        g: gum::MixedGraph const &

        """
        return _pyAgrum.MixedGraph___ne__(self, g)


    def eraseNode(self, id: 'gum::NodeId const') -> "void":
        """
        eraseNode(MixedGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_eraseNode(self, id)


    def clear(self) -> "void":
        """
        clear(MixedGraph self)

        Parameters
        ----------
        self: gum::MixedGraph *

        """
        return _pyAgrum.MixedGraph_clear(self)


    def mixedOrientedPath(self, node1: 'gum::NodeId const', node2: 'gum::NodeId const') -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > > const":
        """
        mixedOrientedPath(MixedGraph self, gum::NodeId const node1, gum::NodeId const node2) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > > const

        Parameters
        ----------
        node1: gum::NodeId const
        node2: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_mixedOrientedPath(self, node1, node2)


    def mixedUnorientedPath(self, node1: 'gum::NodeId const', node2: 'gum::NodeId const') -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > > const":
        """
        mixedUnorientedPath(MixedGraph self, gum::NodeId const node1, gum::NodeId const node2) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > > const

        Parameters
        ----------
        node1: gum::NodeId const
        node2: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_mixedUnorientedPath(self, node1, node2)


    def __str__(self) -> "std::string const":
        """
        __str__(MixedGraph self) -> std::string const

        Parameters
        ----------
        self: gum::MixedGraph const *

        """
        return _pyAgrum.MixedGraph___str__(self)


    def addNode(self, *args) -> "void":
        """
        addNode(MixedGraph self) -> gum::NodeId
        addNode(MixedGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_addNode(self, *args)


    def existsNode(self, id: 'gum::NodeId const') -> "bool":
        """
        existsNode(MixedGraph self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_existsNode(self, id)


    def size(self) -> "gum::Size":
        """
        size(MixedGraph self) -> gum::Size

        Parameters
        ----------
        self: gum::MixedGraph const *

        """
        return _pyAgrum.MixedGraph_size(self)


    def empty(self) -> "bool":
        """
        empty(MixedGraph self) -> bool

        Parameters
        ----------
        self: gum::MixedGraph const *

        """
        return _pyAgrum.MixedGraph_empty(self)


    def addEdge(self, n1: 'gum::NodeId const', n2: 'gum::NodeId const') -> "void":
        """
        addEdge(MixedGraph self, gum::NodeId const n1, gum::NodeId const n2)

        Parameters
        ----------
        n1: gum::NodeId const
        n2: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_addEdge(self, n1, n2)


    def eraseEdge(self, edge: 'Edge') -> "void":
        """
        eraseEdge(MixedGraph self, Edge edge)

        Parameters
        ----------
        edge: gum::Edge const &

        """
        return _pyAgrum.MixedGraph_eraseEdge(self, edge)


    def existsEdge(self, *args) -> "bool":
        """
        existsEdge(MixedGraph self, Edge edge) -> bool

        Parameters
        ----------
        edge: gum::Edge const &

        existsEdge(MixedGraph self, gum::NodeId const n1, gum::NodeId const n2) -> bool

        Parameters
        ----------
        n1: gum::NodeId const
        n2: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_existsEdge(self, *args)


    def sizeEdges(self) -> "gum::Size":
        """
        sizeEdges(MixedGraph self) -> gum::Size

        Parameters
        ----------
        self: gum::MixedGraph const *

        """
        return _pyAgrum.MixedGraph_sizeEdges(self)


    def emptyEdges(self) -> "bool":
        """
        emptyEdges(MixedGraph self) -> bool

        Parameters
        ----------
        self: gum::MixedGraph const *

        """
        return _pyAgrum.MixedGraph_emptyEdges(self)


    def eraseNeighbours(self, id: 'gum::NodeId const') -> "void":
        """
        eraseNeighbours(MixedGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_eraseNeighbours(self, id)


    def addArc(self, tail: 'gum::NodeId const', head: 'gum::NodeId const') -> "void":
        """
        addArc(MixedGraph self, gum::NodeId const tail, gum::NodeId const head)

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_addArc(self, tail, head)


    def eraseArc(self, arc: 'Arc') -> "void":
        """
        eraseArc(MixedGraph self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        """
        return _pyAgrum.MixedGraph_eraseArc(self, arc)


    def existsArc(self, *args) -> "bool":
        """
        existsArc(MixedGraph self, Arc arc) -> bool

        Parameters
        ----------
        arc: gum::Arc const &

        existsArc(MixedGraph self, gum::NodeId const tail, gum::NodeId const head) -> bool

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_existsArc(self, *args)


    def eraseParents(self, *args) -> "void":
        """
        eraseParents(MixedGraph self)
        eraseParents(MixedGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_eraseParents(self, *args)


    def eraseChildren(self, *args) -> "void":
        """
        eraseChildren(MixedGraph self)
        eraseChildren(MixedGraph self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.MixedGraph_eraseChildren(self, *args)


    def sizeArcs(self) -> "gum::Size":
        """
        sizeArcs(MixedGraph self) -> gum::Size

        Parameters
        ----------
        self: gum::MixedGraph const *

        """
        return _pyAgrum.MixedGraph_sizeArcs(self)


    def emptyArcs(self) -> "bool":
        """
        emptyArcs(MixedGraph self) -> bool

        Parameters
        ----------
        self: gum::MixedGraph const *

        """
        return _pyAgrum.MixedGraph_emptyArcs(self)

MixedGraph_swigregister = _pyAgrum.MixedGraph_swigregister
MixedGraph_swigregister(MixedGraph)

class CliqueGraph(UndiGraph):
    """Proxy of C++ gum::CliqueGraph class."""

    __swig_setmethods__ = {}
    for _s in [UndiGraph]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CliqueGraph, name, value)
    __swig_getmethods__ = {}
    for _s in [UndiGraph]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CliqueGraph, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::CliqueGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size edges_size, bool edges_resize_policy=True) -> CliqueGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        edges_size: gum::Size
        edges_resize_policy: bool

        __init__(gum::CliqueGraph self, gum::Size nodes_size, bool nodes_resize_policy=True, gum::Size edges_size) -> CliqueGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool
        edges_size: gum::Size

        __init__(gum::CliqueGraph self, gum::Size nodes_size, bool nodes_resize_policy=True) -> CliqueGraph

        Parameters
        ----------
        nodes_size: gum::Size
        nodes_resize_policy: bool

        __init__(gum::CliqueGraph self, gum::Size nodes_size) -> CliqueGraph

        Parameters
        ----------
        nodes_size: gum::Size

        __init__(gum::CliqueGraph self) -> CliqueGraph
        __init__(gum::CliqueGraph self, CliqueGraph arg2) -> CliqueGraph

        Parameters
        ----------
        from: gum::CliqueGraph const &

        """
        this = _pyAgrum.new_CliqueGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CliqueGraph
    __del__ = lambda self: None

    def addEdge(self, first: 'gum::NodeId const', second: 'gum::NodeId const') -> "void":
        """
        addEdge(CliqueGraph self, gum::NodeId const first, gum::NodeId const second)

        Parameters
        ----------
        first: gum::NodeId const
        second: gum::NodeId const

        """
        return _pyAgrum.CliqueGraph_addEdge(self, first, second)


    def eraseEdge(self, edge: 'Edge') -> "void":
        """
        eraseEdge(CliqueGraph self, Edge edge)

        Parameters
        ----------
        edge: gum::Edge const &

        """
        return _pyAgrum.CliqueGraph_eraseEdge(self, edge)


    def clearEdges(self) -> "void":
        """
        clearEdges(CliqueGraph self)

        Parameters
        ----------
        self: gum::CliqueGraph *

        """
        return _pyAgrum.CliqueGraph_clearEdges(self)


    def eraseNode(self, node: 'gum::NodeId const') -> "void":
        """
        eraseNode(CliqueGraph self, gum::NodeId const node)

        Parameters
        ----------
        node: gum::NodeId const

        """
        return _pyAgrum.CliqueGraph_eraseNode(self, node)


    def clear(self) -> "void":
        """
        clear(CliqueGraph self)

        Parameters
        ----------
        self: gum::CliqueGraph *

        """
        return _pyAgrum.CliqueGraph_clear(self)


    def container(self, idNode: 'gum::NodeId const') -> "gum::NodeId":
        """
        container(CliqueGraph self, gum::NodeId const idNode) -> gum::NodeId

        Parameters
        ----------
        idNode: gum::NodeId const

        """
        return _pyAgrum.CliqueGraph_container(self, idNode)


    def setClique(self, idClique: 'gum::NodeId const', new_clique: 'gum::NodeSet const &') -> "void":
        """
        setClique(CliqueGraph self, gum::NodeId const idClique, gum::NodeSet const & new_clique)

        Parameters
        ----------
        idClique: gum::NodeId const
        new_clique: gum::NodeSet const &

        """
        return _pyAgrum.CliqueGraph_setClique(self, idClique, new_clique)


    def addToClique(self, clique_id: 'gum::NodeId const', node_id: 'gum::NodeId const') -> "void":
        """
        addToClique(CliqueGraph self, gum::NodeId const clique_id, gum::NodeId const node_id)

        Parameters
        ----------
        clique_id: gum::NodeId const
        node_id: gum::NodeId const

        """
        return _pyAgrum.CliqueGraph_addToClique(self, clique_id, node_id)


    def eraseFromClique(self, clique_id: 'gum::NodeId const', node_id: 'gum::NodeId const') -> "void":
        """
        eraseFromClique(CliqueGraph self, gum::NodeId const clique_id, gum::NodeId const node_id)

        Parameters
        ----------
        clique_id: gum::NodeId const
        node_id: gum::NodeId const

        """
        return _pyAgrum.CliqueGraph_eraseFromClique(self, clique_id, node_id)


    def separator(self, *args) -> "gum::NodeSet const &":
        """
        separator(CliqueGraph self, Edge edge) -> gum::NodeSet const

        Parameters
        ----------
        edge: gum::Edge const &

        separator(CliqueGraph self, gum::NodeId const clique1, gum::NodeId const clique) -> gum::NodeSet const &

        Parameters
        ----------
        clique1: gum::NodeId const
        clique: gum::NodeId const

        """
        return _pyAgrum.CliqueGraph_separator(self, *args)


    def containerPath(self, node1: 'gum::NodeId const', node2: 'gum::NodeId const') -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > >":
        """
        containerPath(CliqueGraph self, gum::NodeId const node1, gum::NodeId const node2) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > >

        Parameters
        ----------
        node1: gum::NodeId const
        node2: gum::NodeId const

        """
        return _pyAgrum.CliqueGraph_containerPath(self, node1, node2)


    def hasRunningIntersection(self) -> "bool":
        """
        hasRunningIntersection(CliqueGraph self) -> bool

        Parameters
        ----------
        self: gum::CliqueGraph const *

        """
        return _pyAgrum.CliqueGraph_hasRunningIntersection(self)


    def isJoinTree(self) -> "bool":
        """
        isJoinTree(CliqueGraph self) -> bool

        Parameters
        ----------
        self: gum::CliqueGraph const *

        """
        return _pyAgrum.CliqueGraph_isJoinTree(self)


    def __str__(self) -> "std::string const":
        """
        __str__(CliqueGraph self) -> std::string const

        Parameters
        ----------
        self: gum::CliqueGraph const *

        """
        return _pyAgrum.CliqueGraph___str__(self)


    def toDot(self) -> "std::string const":
        """
        toDot(CliqueGraph self) -> std::string const

        Parameters
        ----------
        self: gum::CliqueGraph const *

        """
        return _pyAgrum.CliqueGraph_toDot(self)


    def __ne__(self, arg2: 'CliqueGraph') -> "bool":
        """
        __ne__(CliqueGraph self, CliqueGraph arg2) -> bool

        Parameters
        ----------
        from: gum::CliqueGraph const &

        """
        return _pyAgrum.CliqueGraph___ne__(self, arg2)


    def __eq__(self, arg2: 'CliqueGraph') -> "bool":
        """
        __eq__(CliqueGraph self, CliqueGraph arg2) -> bool

        Parameters
        ----------
        from: gum::CliqueGraph const &

        """
        return _pyAgrum.CliqueGraph___eq__(self, arg2)


    def clique(self, clique: 'gum::NodeId const') -> "PyObject *":
        """
        clique(CliqueGraph self, gum::NodeId const clique) -> PyObject *

        Parameters
        ----------
        clique: gum::NodeId const

        """
        return _pyAgrum.CliqueGraph_clique(self, clique)


    def toDotWithNames(self,bn):
      def nameFromId(m):
        return " ".join([bn.variable(int(n)).name()
                         for n in m.group().split("-")])
      import re
      m = re.compile('(?<=label=\")\d+[\-\d+]*')
      return m.sub(nameFromId,self.toDot())

CliqueGraph_swigregister = _pyAgrum.CliqueGraph_swigregister
CliqueGraph_swigregister(CliqueGraph)

class Instantiation(_object):
    """Proxy of C++ gum::Instantiation class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Instantiation, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Instantiation, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::Instantiation self) -> Instantiation
        __init__(gum::Instantiation self, Instantiation aI, bool const notifyMaster=True) -> Instantiation

        Parameters
        ----------
        aI: gum::Instantiation const &
        notifyMaster: bool const

        __init__(gum::Instantiation self, Instantiation aI) -> Instantiation

        Parameters
        ----------
        aI: gum::Instantiation const &

        __init__(gum::Instantiation self, MultiDimAdressable aMD) -> Instantiation

        Parameters
        ----------
        aMD: gum::MultiDimAdressable &

        __init__(gum::Instantiation self, MultiDimAdressable aMD) -> Instantiation

        Parameters
        ----------
        aMD: gum::MultiDimAdressable const &

        __init__(gum::Instantiation self, MultiDimAdressable aMD) -> Instantiation

        Parameters
        ----------
        aMD: gum::MultiDimAdressable *

        __init__(gum::Instantiation self, MultiDimAdressable aMD) -> Instantiation

        Parameters
        ----------
        aMD: gum::MultiDimAdressable const *

        """
        this = _pyAgrum.new_Instantiation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_Instantiation
    __del__ = lambda self: None

    def nbrDim(self) -> "gum::Idx":
        """
        nbrDim(Instantiation self) -> gum::Idx

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_nbrDim(self)


    def add(self, v: 'DiscreteVariable') -> "void":
        """
        add(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_add(self, v)


    def erase(self, v: 'DiscreteVariable') -> "void":
        """
        erase(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_erase(self, v)


    def clear(self) -> "void":
        """
        clear(Instantiation self)

        Parameters
        ----------
        self: gum::Instantiation *

        """
        return _pyAgrum.Instantiation_clear(self)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(Instantiation self) -> gum::Size

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_domainSize(self)


    def pos(self, v: 'DiscreteVariable') -> "gum::Idx":
        """
        pos(Instantiation self, DiscreteVariable v) -> gum::Idx

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_pos(self, v)


    def val(self, *args) -> "gum::Idx":
        """
        val(Instantiation self, gum::Idx i) -> gum::Idx

        Parameters
        ----------
        i: gum::Idx

        val(Instantiation self, DiscreteVariable var) -> gum::Idx

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_val(self, *args)


    def valFromPtr(self, pvar: 'DiscreteVariable') -> "gum::Idx":
        """
        valFromPtr(Instantiation self, DiscreteVariable pvar) -> gum::Idx

        Parameters
        ----------
        pvar: gum::DiscreteVariable const *

        """
        return _pyAgrum.Instantiation_valFromPtr(self, pvar)


    def variable(self, i: 'gum::Idx') -> "gum::DiscreteVariable const &":
        """
        variable(Instantiation self, gum::Idx i) -> DiscreteVariable

        Parameters
        ----------
        i: gum::Idx

        """
        return _pyAgrum.Instantiation_variable(self, i)


    def chgVal(self, *args) -> "gum::Instantiation &":
        """
        chgVal(Instantiation self, DiscreteVariable v, gum::Idx newval) -> Instantiation

        Parameters
        ----------
        v: gum::DiscreteVariable const &
        newval: gum::Idx

        chgVal(Instantiation self, DiscreteVariable v, gum::Idx newval) -> Instantiation

        Parameters
        ----------
        v: gum::DiscreteVariable const *
        newval: gum::Idx

        chgVal(Instantiation self, gum::Idx varPos, gum::Idx newval) -> Instantiation

        Parameters
        ----------
        varPos: gum::Idx
        newval: gum::Idx

        """
        return _pyAgrum.Instantiation_chgVal(self, *args)


    def setVals(self, i: 'Instantiation') -> "gum::Instantiation &":
        """
        setVals(Instantiation self, Instantiation i) -> Instantiation

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_setVals(self, i)


    def contains(self, *args) -> "bool":
        """
        contains(Instantiation self, DiscreteVariable v) -> bool

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        contains(Instantiation self, DiscreteVariable v) -> bool

        Parameters
        ----------
        v: gum::DiscreteVariable const *

        """
        return _pyAgrum.Instantiation_contains(self, *args)


    def variablesSequence(self) -> "gum::Sequence< gum::DiscreteVariable const * > const &":
        """
        variablesSequence(Instantiation self) -> gum::Sequence< gum::DiscreteVariable const * > const &

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_variablesSequence(self)


    def empty(self) -> "bool":
        """
        empty(Instantiation self) -> bool

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_empty(self)


    def inOverflow(self) -> "bool":
        """
        inOverflow(Instantiation self) -> bool

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_inOverflow(self)


    def unsetOverflow(self) -> "void":
        """
        unsetOverflow(Instantiation self)

        Parameters
        ----------
        self: gum::Instantiation *

        """
        return _pyAgrum.Instantiation_unsetOverflow(self)


    def unsetEnd(self) -> "void":
        """
        unsetEnd(Instantiation self)

        Parameters
        ----------
        self: gum::Instantiation *

        """
        return _pyAgrum.Instantiation_unsetEnd(self)


    def end(self) -> "bool":
        """
        end(Instantiation self) -> bool

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_end(self)


    def rend(self) -> "bool":
        """
        rend(Instantiation self) -> bool

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_rend(self)


    def inc(self) -> "void":
        """
        inc(Instantiation self)

        Parameters
        ----------
        self: gum::Instantiation *

        """
        return _pyAgrum.Instantiation_inc(self)


    def dec(self) -> "void":
        """
        dec(Instantiation self)

        Parameters
        ----------
        self: gum::Instantiation *

        """
        return _pyAgrum.Instantiation_dec(self)


    def incIn(self, i: 'Instantiation') -> "void":
        """
        incIn(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_incIn(self, i)


    def decIn(self, i: 'Instantiation') -> "void":
        """
        decIn(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_decIn(self, i)


    def incOut(self, i: 'Instantiation') -> "void":
        """
        incOut(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_incOut(self, i)


    def decOut(self, i: 'Instantiation') -> "void":
        """
        decOut(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_decOut(self, i)


    def incNotVar(self, v: 'DiscreteVariable') -> "void":
        """
        incNotVar(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_incNotVar(self, v)


    def decNotVar(self, v: 'DiscreteVariable') -> "void":
        """
        decNotVar(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_decNotVar(self, v)


    def incVar(self, v: 'DiscreteVariable') -> "void":
        """
        incVar(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_incVar(self, v)


    def decVar(self, v: 'DiscreteVariable') -> "void":
        """
        decVar(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_decVar(self, v)


    def setFirst(self) -> "void":
        """
        setFirst(Instantiation self)

        Parameters
        ----------
        self: gum::Instantiation *

        """
        return _pyAgrum.Instantiation_setFirst(self)


    def setLast(self) -> "void":
        """
        setLast(Instantiation self)

        Parameters
        ----------
        self: gum::Instantiation *

        """
        return _pyAgrum.Instantiation_setLast(self)


    def setFirstIn(self, i: 'Instantiation') -> "void":
        """
        setFirstIn(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_setFirstIn(self, i)


    def setLastIn(self, i: 'Instantiation') -> "void":
        """
        setLastIn(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_setLastIn(self, i)


    def setFirstOut(self, i: 'Instantiation') -> "void":
        """
        setFirstOut(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_setFirstOut(self, i)


    def setLastOut(self, i: 'Instantiation') -> "void":
        """
        setLastOut(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_setLastOut(self, i)


    def setFirstNotVar(self, v: 'DiscreteVariable') -> "void":
        """
        setFirstNotVar(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_setFirstNotVar(self, v)


    def setLastNotVar(self, v: 'DiscreteVariable') -> "void":
        """
        setLastNotVar(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_setLastNotVar(self, v)


    def setFirstVar(self, v: 'DiscreteVariable') -> "void":
        """
        setFirstVar(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_setFirstVar(self, v)


    def setLastVar(self, v: 'DiscreteVariable') -> "void":
        """
        setLastVar(Instantiation self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_setLastVar(self, v)


    def actAsSlave(self, aMD: 'MultiDimAdressable') -> "bool":
        """
        actAsSlave(Instantiation self, MultiDimAdressable aMD) -> bool

        Parameters
        ----------
        aMD: gum::MultiDimAdressable &

        """
        return _pyAgrum.Instantiation_actAsSlave(self, aMD)


    def forgetMaster(self) -> "bool":
        """
        forgetMaster(Instantiation self) -> bool

        Parameters
        ----------
        self: gum::Instantiation *

        """
        return _pyAgrum.Instantiation_forgetMaster(self)


    def isSlave(self) -> "bool":
        """
        isSlave(Instantiation self) -> bool

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_isSlave(self)


    def isMaster(self, *args) -> "bool":
        """
        isMaster(Instantiation self, MultiDimAdressable m) -> bool

        Parameters
        ----------
        m: gum::MultiDimAdressable const *

        isMaster(Instantiation self, MultiDimAdressable m) -> bool

        Parameters
        ----------
        m: gum::MultiDimAdressable const &

        """
        return _pyAgrum.Instantiation_isMaster(self, *args)


    def synchronizeWithMaster(self, m: 'MultiDimAdressable') -> "void":
        """
        synchronizeWithMaster(Instantiation self, MultiDimAdressable m)

        Parameters
        ----------
        m: gum::MultiDimAdressable const *

        """
        return _pyAgrum.Instantiation_synchronizeWithMaster(self, m)


    def addWithMaster(self, m: 'MultiDimAdressable', v: 'DiscreteVariable') -> "void":
        """
        addWithMaster(Instantiation self, MultiDimAdressable m, DiscreteVariable v)

        Parameters
        ----------
        m: gum::MultiDimAdressable const *
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_addWithMaster(self, m, v)


    def eraseWithMaster(self, m: 'MultiDimAdressable', v: 'DiscreteVariable') -> "void":
        """
        eraseWithMaster(Instantiation self, MultiDimAdressable m, DiscreteVariable v)

        Parameters
        ----------
        m: gum::MultiDimAdressable const *
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Instantiation_eraseWithMaster(self, m, v)


    def __iadd__(self, depl: 'gum::Size') -> "gum::Instantiation &":
        """
        __iadd__(Instantiation self, gum::Size depl) -> Instantiation

        Parameters
        ----------
        depl: gum::Size

        """
        return _pyAgrum.Instantiation___iadd__(self, depl)


    def __isub__(self, depl: 'gum::Size') -> "gum::Instantiation &":
        """
        __isub__(Instantiation self, gum::Size depl) -> Instantiation

        Parameters
        ----------
        depl: gum::Size

        """
        return _pyAgrum.Instantiation___isub__(self, depl)


    def hamming(self) -> "gum::Idx":
        """
        hamming(Instantiation self) -> gum::Idx

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation_hamming(self)


    def __str__(self) -> "std::string":
        """
        __str__(Instantiation self) -> std::string

        Parameters
        ----------
        self: gum::Instantiation const *

        """
        return _pyAgrum.Instantiation___str__(self)


    def reorder(self, *args) -> "void":
        """
        reorder(Instantiation self, gum::Sequence< gum::DiscreteVariable const * > const & v)

        Parameters
        ----------
        v: gum::Sequence< gum::DiscreteVariable const * > const &

        reorder(Instantiation self, Instantiation i)

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Instantiation_reorder(self, *args)

Instantiation_swigregister = _pyAgrum.Instantiation_swigregister
Instantiation_swigregister(Instantiation)

GUM_DEFAULT_ITERATOR_NUMBER = _pyAgrum.GUM_DEFAULT_ITERATOR_NUMBER
class DAGmodel(_object):
    """Proxy of C++ gum::DAGmodel class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DAGmodel, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DAGmodel, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_DAGmodel
    __del__ = lambda self: None

    def property(self, name: 'std::string const &') -> "std::string const &":
        """
        property(DAGmodel self, std::string const & name) -> std::string const &

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.DAGmodel_property(self, name)


    def propertyWithDefault(self, name: 'std::string const &', byDefault: 'std::string const &') -> "std::string const &":
        """
        propertyWithDefault(DAGmodel self, std::string const & name, std::string const & byDefault) -> std::string const &

        Parameters
        ----------
        name: std::string const &
        byDefault: std::string const &

        """
        return _pyAgrum.DAGmodel_propertyWithDefault(self, name, byDefault)


    def setProperty(self, name: 'std::string const &', value: 'std::string const &') -> "void":
        """
        setProperty(DAGmodel self, std::string const & name, std::string const & value)

        Parameters
        ----------
        name: std::string const &
        value: std::string const &

        """
        return _pyAgrum.DAGmodel_setProperty(self, name, value)


    def dag(self) -> "gum::DAG const &":
        """
        dag(DAGmodel self) -> DAG

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_dag(self)


    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        """
        variableNodeMap(DAGmodel self) -> VariableNodeMap

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_variableNodeMap(self)


    def size(self) -> "gum::Size":
        """
        size(DAGmodel self) -> gum::Size

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_size(self)


    def sizeArcs(self) -> "gum::Size":
        """
        sizeArcs(DAGmodel self) -> gum::Size

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_sizeArcs(self)


    def empty(self) -> "bool":
        """
        empty(DAGmodel self) -> bool

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_empty(self)


    def variable(self, id: 'gum::NodeId') -> "gum::DiscreteVariable const &":
        """
        variable(DAGmodel self, gum::NodeId id) -> DiscreteVariable

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.DAGmodel_variable(self, id)


    def nodeId(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        nodeId(DAGmodel self, DiscreteVariable var) -> gum::NodeId

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        return _pyAgrum.DAGmodel_nodeId(self, var)


    def idFromName(self, name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(DAGmodel self, std::string const & name) -> gum::NodeId

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.DAGmodel_idFromName(self, name)


    def variableFromName(self, name: 'std::string const &') -> "gum::DiscreteVariable const &":
        """
        variableFromName(DAGmodel self, std::string const & name) -> DiscreteVariable

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.DAGmodel_variableFromName(self, name)


    def completeInstantiation(self, I: 'Instantiation') -> "void":
        """
        completeInstantiation(DAGmodel self, Instantiation I)

        Parameters
        ----------
        I: gum::Instantiation &

        """
        return _pyAgrum.DAGmodel_completeInstantiation(self, I)


    def arcs(self) -> "gum::ArcSet const &":
        """
        arcs(DAGmodel self) -> gum::ArcSet const &

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_arcs(self)


    def moralGraph(self, clear: 'bool'=True) -> "gum::UndiGraph const &":
        """
        moralGraph(DAGmodel self, bool clear=True) -> UndiGraph

        Parameters
        ----------
        clear: bool

        moralGraph(DAGmodel self) -> UndiGraph

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_moralGraph(self, clear)


    def topologicalOrder(self, clear: 'bool'=True) -> "gum::Sequence< gum::NodeId > const &":
        """
        topologicalOrder(DAGmodel self, bool clear=True) -> gum::Sequence< gum::NodeId > const

        Parameters
        ----------
        clear: bool

        topologicalOrder(DAGmodel self) -> gum::Sequence< gum::NodeId > const &

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_topologicalOrder(self, clear)


    def log10DomainSize(self) -> "double":
        """
        log10DomainSize(DAGmodel self) -> double

        Parameters
        ----------
        self: gum::DAGmodel const *

        """
        return _pyAgrum.DAGmodel_log10DomainSize(self)

DAGmodel_swigregister = _pyAgrum.DAGmodel_swigregister
DAGmodel_swigregister(DAGmodel)
cvar = _pyAgrum.cvar
__list_end_safe = cvar.__list_end_safe
__list_end = cvar.__list_end

FindBarrenNodesType_FIND_NO_BARREN_NODES = _pyAgrum.FindBarrenNodesType_FIND_NO_BARREN_NODES
FindBarrenNodesType_FIND_BARREN_NODES = _pyAgrum.FindBarrenNodesType_FIND_BARREN_NODES

def randomDistribution_double(n: 'gum::Size') -> "std::vector< double,std::allocator< double > >":
    """
    randomDistribution_double(gum::Size n) -> Vector_double

    Parameters
    ----------
    n: gum::Size

    """
    return _pyAgrum.randomDistribution_double(n)
class DiscretizedVariable_double(DiscreteVariable):
    """Proxy of C++ gum::DiscretizedVariable<(double)> class."""

    __swig_setmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DiscretizedVariable_double, name, value)
    __swig_getmethods__ = {}
    for _s in [DiscreteVariable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DiscretizedVariable_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::DiscretizedVariable<(double)> self, std::string const & aName, std::string const & aDesc) -> DiscretizedVariable_double

        Parameters
        ----------
        aName: std::string const &
        aDesc: std::string const &

        __init__(gum::DiscretizedVariable<(double)> self, DiscretizedVariable_double aDRV) -> DiscretizedVariable_double

        Parameters
        ----------
        aDRV: gum::DiscretizedVariable< double > const &

        """
        this = _pyAgrum.new_DiscretizedVariable_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_DiscretizedVariable_double
    __del__ = lambda self: None

    def clone(self) -> "gum::DiscreteVariable *":
        """
        clone(DiscretizedVariable_double self) -> DiscreteVariable

        Parameters
        ----------
        self: gum::DiscretizedVariable< double > const *

        """
        return _pyAgrum.DiscretizedVariable_double_clone(self)


    def varType(self) -> "gum::DiscreteVariable::VarType":
        """
        varType(DiscretizedVariable_double self) -> gum::DiscreteVariable::VarType

        Parameters
        ----------
        self: gum::DiscretizedVariable< double > const *

        """
        return _pyAgrum.DiscretizedVariable_double_varType(self)


    def isTick(self, aTick: 'double const &') -> "bool":
        """
        isTick(DiscretizedVariable_double self, double const & aTick) -> bool

        Parameters
        ----------
        aTick: double const &

        """
        return _pyAgrum.DiscretizedVariable_double_isTick(self, aTick)


    def addTick(self,*args):
      _pyAgrum.DiscretizedVariable_double_addTick(self,*args)
      return self



    def eraseTicks(self) -> "void":
        """
        eraseTicks(DiscretizedVariable_double self)

        Parameters
        ----------
        self: gum::DiscretizedVariable< double > *

        """
        return _pyAgrum.DiscretizedVariable_double_eraseTicks(self)


    def label(self, i: 'gum::Idx') -> "std::string":
        """
        label(DiscretizedVariable_double self, gum::Idx i) -> std::string

        Parameters
        ----------
        i: gum::Idx

        """
        return _pyAgrum.DiscretizedVariable_double_label(self, i)


    def numerical(self, indice: 'gum::Idx') -> "double":
        """
        numerical(DiscretizedVariable_double self, gum::Idx indice) -> double

        Parameters
        ----------
        indice: gum::Idx

        """
        return _pyAgrum.DiscretizedVariable_double_numerical(self, indice)


    def index(self, label: 'std::string const &') -> "gum::Idx":
        """
        index(DiscretizedVariable_double self, std::string const & label) -> gum::Idx

        Parameters
        ----------
        label: std::string const &

        """
        return _pyAgrum.DiscretizedVariable_double_index(self, label)


    def domainSize(self) -> "gum::Size":
        """
        domainSize(DiscretizedVariable_double self) -> gum::Size

        Parameters
        ----------
        self: gum::DiscretizedVariable< double > const *

        """
        return _pyAgrum.DiscretizedVariable_double_domainSize(self)


    def domain(self) -> "std::string const":
        """
        domain(DiscretizedVariable_double self) -> std::string const

        Parameters
        ----------
        self: gum::DiscretizedVariable< double > const *

        """
        return _pyAgrum.DiscretizedVariable_double_domain(self)


    def tick(self, i: 'gum::Idx') -> "double const &":
        """
        tick(DiscretizedVariable_double self, gum::Idx i) -> double const &

        Parameters
        ----------
        i: gum::Idx

        """
        return _pyAgrum.DiscretizedVariable_double_tick(self, i)

DiscretizedVariable_double_swigregister = _pyAgrum.DiscretizedVariable_double_swigregister
DiscretizedVariable_double_swigregister(DiscretizedVariable_double)

class MultiDimContainer_double(_object):
    """Proxy of C++ gum::MultiDimContainer<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiDimContainer_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultiDimContainer_double, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_MultiDimContainer_double
    __del__ = lambda self: None

    def set(self, i: 'Instantiation', value: 'double const &') -> "void":
        """
        set(MultiDimContainer_double self, Instantiation i, double const & value)

        Parameters
        ----------
        i: gum::Instantiation const &
        value: double const &

        """
        return _pyAgrum.MultiDimContainer_double_set(self, i, value)


    def get(self, i: 'Instantiation') -> "double":
        """
        get(MultiDimContainer_double self, Instantiation i) -> double

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.MultiDimContainer_double_get(self, i)


    def fill(self, d: 'double const &') -> "void":
        """
        fill(MultiDimContainer_double self, double const & d)

        Parameters
        ----------
        d: double const &

        """
        return _pyAgrum.MultiDimContainer_double_fill(self, d)


    def populate(self, *args) -> "void":
        """
        populate(MultiDimContainer_double self, Vector_double v)

        Parameters
        ----------
        v: std::vector< double,std::allocator< double > > const &

        populate(MultiDimContainer_double self, std::initializer_list< double > l)

        Parameters
        ----------
        l: std::initializer_list< double >

        """
        return _pyAgrum.MultiDimContainer_double_populate(self, *args)


    def copyFrom(self, *args) -> "void":
        """
        copyFrom(MultiDimContainer_double self, MultiDimContainer_double src)

        Parameters
        ----------
        src: gum::MultiDimContainer< double > const &

        copyFrom(MultiDimContainer_double self, MultiDimContainer_double src, Instantiation p_i)

        Parameters
        ----------
        src: gum::MultiDimContainer< double > const &
        p_i: gum::Instantiation *

        """
        return _pyAgrum.MultiDimContainer_double_copyFrom(self, *args)


    def extractFrom(self, src: 'MultiDimContainer_double', mask: 'Instantiation') -> "void":
        """
        extractFrom(MultiDimContainer_double self, MultiDimContainer_double src, Instantiation mask)

        Parameters
        ----------
        src: gum::MultiDimContainer< double > const &
        mask: gum::Instantiation const &

        """
        return _pyAgrum.MultiDimContainer_double_extractFrom(self, src, mask)


    def content(self, *args) -> "gum::MultiDimImplementation< double > *":
        """
        content(MultiDimContainer_double self) -> gum::MultiDimImplementation< double > const
        content(MultiDimContainer_double self) -> gum::MultiDimImplementation< double > *

        Parameters
        ----------
        self: gum::MultiDimContainer< double > *

        """
        return _pyAgrum.MultiDimContainer_double_content(self, *args)


    def getMasterRef(self, *args) -> "gum::MultiDimAdressable const &":
        """
        getMasterRef(MultiDimContainer_double self) -> MultiDimAdressable
        getMasterRef(MultiDimContainer_double self) -> MultiDimAdressable

        Parameters
        ----------
        self: gum::MultiDimContainer< double > const *

        """
        return _pyAgrum.MultiDimContainer_double_getMasterRef(self, *args)


    def copy(self, src: 'MultiDimContainer_double') -> "void":
        """
        copy(MultiDimContainer_double self, MultiDimContainer_double src)

        Parameters
        ----------
        src: gum::MultiDimContainer< double > const &

        """
        return _pyAgrum.MultiDimContainer_double_copy(self, src)


    def newFactory(self) -> "gum::MultiDimContainer< double > *":
        """
        newFactory(MultiDimContainer_double self) -> MultiDimContainer_double

        Parameters
        ----------
        self: gum::MultiDimContainer< double > const *

        """
        return _pyAgrum.MultiDimContainer_double_newFactory(self)


    def __str__(self) -> "std::string const":
        """
        __str__(MultiDimContainer_double self) -> std::string const

        Parameters
        ----------
        self: gum::MultiDimContainer< double > const *

        """
        return _pyAgrum.MultiDimContainer_double___str__(self)


    def toString(self, i: 'Instantiation') -> "std::string const":
        """
        toString(MultiDimContainer_double self, Instantiation i) -> std::string const

        Parameters
        ----------
        i: gum::Instantiation const *

        """
        return _pyAgrum.MultiDimContainer_double_toString(self, i)


    def __eq__(self, p: 'MultiDimContainer_double') -> "bool":
        """
        __eq__(MultiDimContainer_double self, MultiDimContainer_double p) -> bool

        Parameters
        ----------
        p: gum::MultiDimContainer< double > const &

        """
        return _pyAgrum.MultiDimContainer_double___eq__(self, p)


    def __ne__(self, p: 'MultiDimContainer_double') -> "bool":
        """
        __ne__(MultiDimContainer_double self, MultiDimContainer_double p) -> bool

        Parameters
        ----------
        p: gum::MultiDimContainer< double > const &

        """
        return _pyAgrum.MultiDimContainer_double___ne__(self, p)


    def apply(self, f: 'std::function< double (double) >') -> "void":
        """
        apply(MultiDimContainer_double self, std::function< double (double) > f)

        Parameters
        ----------
        f: std::function< double (double) >

        """
        return _pyAgrum.MultiDimContainer_double_apply(self, f)


    def reduce(self, f: 'std::function< double (double,double) >', base: 'double') -> "double":
        """
        reduce(MultiDimContainer_double self, std::function< double (double,double) > f, double base) -> double

        Parameters
        ----------
        f: std::function< double (double,double) >
        base: double

        """
        return _pyAgrum.MultiDimContainer_double_reduce(self, f, base)


    def beginMultipleChanges(self) -> "void":
        """
        beginMultipleChanges(MultiDimContainer_double self)

        Parameters
        ----------
        self: gum::MultiDimContainer< double > *

        """
        return _pyAgrum.MultiDimContainer_double_beginMultipleChanges(self)


    def endMultipleChanges(self, *args) -> "void":
        """
        endMultipleChanges(MultiDimContainer_double self)
        endMultipleChanges(MultiDimContainer_double self, double const & v)

        Parameters
        ----------
        v: double const &

        """
        return _pyAgrum.MultiDimContainer_double_endMultipleChanges(self, *args)

MultiDimContainer_double_swigregister = _pyAgrum.MultiDimContainer_double_swigregister
MultiDimContainer_double_swigregister(MultiDimContainer_double)

class Potential_double(_object):
    """Proxy of C++ gum::Potential<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Potential_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Potential_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::Potential<(double)> self) -> Potential_double
        __init__(gum::Potential<(double)> self, gum::MultiDimImplementation< double > * aContent) -> Potential_double

        Parameters
        ----------
        aContent: gum::MultiDimImplementation< double > *

        __init__(gum::Potential<(double)> self, gum::MultiDimImplementation< double > * aContent, MultiDimContainer_double src) -> Potential_double

        Parameters
        ----------
        aContent: gum::MultiDimImplementation< double > *
        src: gum::MultiDimContainer< double > const &

        __init__(gum::Potential<(double)> self, Potential_double src) -> Potential_double

        Parameters
        ----------
        src: gum::Potential< double > const &

        __init__(gum::Potential<(double)> self, Potential_double arg2) -> Potential_double

        Parameters
        ----------
        from: gum::Potential< double > &&

        """
        this = _pyAgrum.new_Potential_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._notSync=True



    __swig_destroy__ = _pyAgrum.delete_Potential_double
    __del__ = lambda self: None

    def newFactory(self) -> "gum::Potential< double > *":
        """
        newFactory(Potential_double self) -> Potential_double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_newFactory(self)


    def isNonZeroMap(self) -> "gum::Potential< double >":
        """
        isNonZeroMap(Potential_double self) -> Potential_double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_isNonZeroMap(self)


    def sum(self) -> "double":
        """
        sum(Potential_double self) -> double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_sum(self)


    def product(self) -> "double":
        """
        product(Potential_double self) -> double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_product(self)


    def max(self) -> "double":
        """
        max(Potential_double self) -> double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_max(self)


    def min(self) -> "double":
        """
        min(Potential_double self) -> double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_min(self)


    def maxNonOne(self) -> "double":
        """
        maxNonOne(Potential_double self) -> double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_maxNonOne(self)


    def minNonZero(self) -> "double":
        """
        minNonZero(Potential_double self) -> double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_minNonZero(self)


    def entropy(self) -> "double":
        """
        entropy(Potential_double self) -> double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_entropy(self)


    def fillWith(self, *args) -> "gum::Potential< double > const &":
        """
        fillWith(Potential_double self, Vector_double v) -> Potential_double

        Parameters
        ----------
        v: std::vector< double,std::allocator< double > > const &

        fillWith(Potential_double self, double const & v) -> Potential_double

        Parameters
        ----------
        v: double const &

        """
        val = _pyAgrum.Potential_double_fillWith(self, *args)

        self._notSync=True
        return self


        return val


    def abs(self) -> "gum::Potential< double > const &":
        """
        abs(Potential_double self) -> Potential_double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        val = _pyAgrum.Potential_double_abs(self)

        self._notSync=True
        return self


        return val


    def normalize(self) -> "gum::Potential< double > const &":
        """
        normalize(Potential_double self) -> Potential_double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        val = _pyAgrum.Potential_double_normalize(self)

        self._notSync=True
        return self


        return val


    def sq(self) -> "gum::Potential< double > const &":
        """
        sq(Potential_double self) -> Potential_double

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        val = _pyAgrum.Potential_double_sq(self)

        self._notSync=True
        return self


        return val


    def normalizeAsCPT(self) -> "void":
        """
        normalizeAsCPT(Potential_double self)

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        val = _pyAgrum.Potential_double_normalizeAsCPT(self)

        self._notSync=True
        return self


        return val


    def scale(self, v: 'double') -> "gum::Potential< double > const &":
        """
        scale(Potential_double self, double v) -> Potential_double

        Parameters
        ----------
        v: double

        """
        val = _pyAgrum.Potential_double_scale(self, v)

        self._notSync=True
        return self


        return val


    def translate(self, v: 'double') -> "gum::Potential< double > const &":
        """
        translate(Potential_double self, double v) -> Potential_double

        Parameters
        ----------
        v: double

        """
        val = _pyAgrum.Potential_double_translate(self, v)

        self._notSync=True
        return self


        return val


    def __add__(self, p2: 'Potential_double') -> "gum::Potential< double >":
        """
        __add__(Potential_double self, Potential_double p2) -> Potential_double

        Parameters
        ----------
        p2: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___add__(self, p2)


    def __sub__(self, p2: 'Potential_double') -> "gum::Potential< double >":
        """
        __sub__(Potential_double self, Potential_double p2) -> Potential_double

        Parameters
        ----------
        p2: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___sub__(self, p2)


    def __mul__(self, p2: 'Potential_double') -> "gum::Potential< double >":
        """
        __mul__(Potential_double self, Potential_double p2) -> Potential_double

        Parameters
        ----------
        p2: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___mul__(self, p2)


    def __iadd__(self, r: 'Potential_double') -> "gum::Potential< double > &":
        """
        __iadd__(Potential_double self, Potential_double r) -> Potential_double

        Parameters
        ----------
        r: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___iadd__(self, r)


    def __imul__(self, r: 'Potential_double') -> "gum::Potential< double > &":
        """
        __imul__(Potential_double self, Potential_double r) -> Potential_double

        Parameters
        ----------
        r: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___imul__(self, r)


    def __isub__(self, r: 'Potential_double') -> "gum::Potential< double > &":
        """
        __isub__(Potential_double self, Potential_double r) -> Potential_double

        Parameters
        ----------
        r: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___isub__(self, r)


    def __itruediv__(self, r: 'Potential_double') -> "gum::Potential< double > &":
        """
        __itruediv__(Potential_double self, Potential_double r) -> Potential_double

        Parameters
        ----------
        r: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___itruediv__(self, r)


    def extract(self, *args) -> "gum::Potential< double >":
        """
        extract(Potential_double self, Instantiation inst) -> Potential_double

        Parameters
        ----------
        inst: gum::Instantiation const &

        extract(Potential_double self, PyObject * dict) -> Potential_double

        Parameters
        ----------
        dict: PyObject *

        """
        return _pyAgrum.Potential_double_extract(self, *args)


    def reorganize(self, *args) -> "gum::Potential< double >":
        """
        reorganize(Potential_double self, std::vector< gum::DiscreteVariable const *,std::allocator< gum::DiscreteVariable const * > > const & vars) -> Potential_double

        Parameters
        ----------
        vars: std::vector< gum::DiscreteVariable const *,std::allocator< gum::DiscreteVariable const * > > const &

        reorganize(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_reorganize(self, *args)


    def putFirst(self, varname: 'PyObject *') -> "gum::Potential< double >":
        """
        putFirst(Potential_double self, PyObject * varname) -> Potential_double

        Parameters
        ----------
        varname: PyObject *

        """
        return _pyAgrum.Potential_double_putFirst(self, varname)


    def margSumOut(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margSumOut(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_margSumOut(self, varnames)


    def margProdOut(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margProdOut(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_margProdOut(self, varnames)


    def margMaxOut(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margMaxOut(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_margMaxOut(self, varnames)


    def margMinOut(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margMinOut(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_margMinOut(self, varnames)


    def margSumIn(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margSumIn(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_margSumIn(self, varnames)


    def margProdIn(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margProdIn(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_margProdIn(self, varnames)


    def margMaxIn(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margMaxIn(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_margMaxIn(self, varnames)


    def margMinIn(self, varnames: 'PyObject *') -> "gum::Potential< double >":
        """
        margMinIn(Potential_double self, PyObject * varnames) -> Potential_double

        Parameters
        ----------
        varnames: PyObject *

        """
        return _pyAgrum.Potential_double_margMinIn(self, varnames)


    def __truediv__(self, *args) -> "gum::Potential< double >":
        """
        __truediv__(Potential_double self, Potential_double p2) -> Potential_double

        Parameters
        ----------
        p2: gum::Potential< double > const &

        __truediv__(Potential_double self, Potential_double b) -> Potential_double

        Parameters
        ----------
        b: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___truediv__(self, *args)


    def __div__(self, b: 'Potential_double') -> "gum::Potential< double >":
        """
        __div__(Potential_double self, Potential_double b) -> Potential_double

        Parameters
        ----------
        b: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___div__(self, b)


    def __eq__(self, *args) -> "bool":
        """
        __eq__(Potential_double self, Potential_double r) -> bool

        Parameters
        ----------
        r: gum::Potential< double > const &

        __eq__(Potential_double self, Potential_double b) -> bool

        Parameters
        ----------
        b: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___eq__(self, *args)


    def __ne__(self, *args) -> "bool":
        """
        __ne__(Potential_double self, Potential_double r) -> bool

        Parameters
        ----------
        r: gum::Potential< double > const &

        __ne__(Potential_double self, Potential_double b) -> bool

        Parameters
        ----------
        b: gum::Potential< double > const &

        """
        return _pyAgrum.Potential_double___ne__(self, *args)



    def variablesSequence(self):
        varlist = []
        for i in range(0, self.nbrDim()):
            varlist.append(self.variable(i))
        return varlist


    def __fill_distrib__(self):
      if not hasattr(self,'_notSync'):
        self._notSync=True

      if self._notSync:
        self._notSync=False
        self._var_names = []
        self._var_dims = []
        content = []
        if self.empty():
            self.__distrib__ = numpy.array(content, dtype=numpy.float64) #M
            return
        i = Instantiation(self)
        i.setFirst()
        while not i.end():
            content.append(self.get(i))
            i.inc()
        self.__distrib__ = numpy.array(content, dtype=numpy.float64) #M
        for var in self.variablesSequence():
            self._var_names.append(var.name())
            self._var_dims.append(var.domainSize())
        self._var_names.reverse()
        self._var_dims.reverse()
        self.__distrib__.shape = tuple(self._var_dims)



    def __indexfromdict__(self, id_dict):
        index = []
        for name, dim in zip(self._var_names, self._var_dims):
            if name in id_dict:
                id_value = id_dict[name]
                if isinstance(id_value, str):
    # id_value is a label of a LabelizedVar
                    i = self._var_names.index(name)
                    var = self.variable(len(self._var_names) - 1 - i)
                    id_value = var[id_value]
                if id_value >= dim:
                    raise IndexError("\"%s\" size is %d !"%(name, dim))
                index.append(id_value)
            else:
                index.append(slice(None, None, None)) # equivalent to ':'
        return tuple(index)



    def __str__(self, *args) -> "char const *":
        """
        __str__(Potential_double self) -> std::string const
        __str__(Potential_double self) -> char const *

        Parameters
        ----------
        self: gum::Potential< double > *

        """
        return _pyAgrum.Potential_double___str__(self, *args)


    def tolist(self):
        self.__fill_distrib__()
        return self.__distrib__.tolist()



    def toarray(self):
        return numpy.array(self.tolist())



    def __getitem__(self, id):
        self.__fill_distrib__()
        if self.empty():
            raise IndexError("%s is empty !!"%(str(self)))
        if isinstance(id, dict):
            id_slice = self.__indexfromdict__(id)
        else:
            id_slice = id
        return self.__distrib__[id_slice]



    def __setitem__(self, id, value):
        self.__fill_distrib__()
        if self.empty():
            raise IndexError("%s is empty !!"%(str(self)))
        if isinstance(id, dict):
            id_slice = self.__indexfromdict__(id)
        else:
            id_slice = id
        self.__distrib__[id_slice] = value
        self.populate(self.__distrib__.reshape(self.__distrib__.size).tolist())



    @property
    def var_names(self):
        self.__fill_distrib__()
        return self._var_names



    @property
    def var_dims(self):
        self.__fill_distrib__()
        return self._var_dims



    def get(self, i: 'Instantiation') -> "double":
        """
        get(Potential_double self, Instantiation i) -> double

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.Potential_double_get(self, i)


    def set(self, i: 'Instantiation', value: 'double const &') -> "void":
        """
        set(Potential_double self, Instantiation i, double const & value)

        Parameters
        ----------
        i: gum::Instantiation const &
        value: double const &

        """
        val = _pyAgrum.Potential_double_set(self, i, value)

        self._notSync=True


        return val


    def empty(self) -> "bool":
        """
        empty(Potential_double self) -> bool

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_empty(self)


    def pos(self, v: 'DiscreteVariable') -> "gum::Idx":
        """
        pos(Potential_double self, DiscreteVariable v) -> gum::Idx

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Potential_double_pos(self, v)


    def contains(self, v: 'DiscreteVariable') -> "bool":
        """
        contains(Potential_double self, DiscreteVariable v) -> bool

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.Potential_double_contains(self, v)


    def nbrDim(self) -> "gum::Idx":
        """
        nbrDim(Potential_double self) -> gum::Idx

        Parameters
        ----------
        self: gum::Potential< double > const *

        """
        return _pyAgrum.Potential_double_nbrDim(self)


    def variable(self, i: 'gum::Idx') -> "gum::DiscreteVariable const &":
        """
        variable(Potential_double self, gum::Idx i) -> DiscreteVariable

        Parameters
        ----------
        i: gum::Idx

        """
        return _pyAgrum.Potential_double_variable(self, i)


    def populate(self, v: 'Vector_double') -> "void":
        """
        populate(Potential_double self, Vector_double v)

        Parameters
        ----------
        v: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.Potential_double_populate(self, v)


    def fill(self, d: 'double const &') -> "void":
        """
        fill(Potential_double self, double const & d)

        Parameters
        ----------
        d: double const &

        """
        return _pyAgrum.Potential_double_fill(self, d)


    def remove(self, var: 'DiscreteVariable') -> "void":
        """
        remove(Potential_double self, DiscreteVariable var)

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        val = _pyAgrum.Potential_double_remove(self, var)

        self._notSync=True


        return val


    def add(self, v: 'DiscreteVariable') -> "void":
        """
        add(Potential_double self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        val = _pyAgrum.Potential_double_add(self, v)

        self._notSync=True
        return self


        return val

Potential_double_swigregister = _pyAgrum.Potential_double_swigregister
Potential_double_swigregister(Potential_double)

class UtilityTable_double(_object):
    """Proxy of C++ gum::UtilityTable<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, UtilityTable_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, UtilityTable_double, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_UtilityTable_double
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(gum::UtilityTable<(double)> self) -> UtilityTable_double
        __init__(gum::UtilityTable<(double)> self, gum::MultiDimImplementation< double > * aContent) -> UtilityTable_double

        Parameters
        ----------
        aContent: gum::MultiDimImplementation< double > *

        __init__(gum::UtilityTable<(double)> self, UtilityTable_double toCopy) -> UtilityTable_double

        Parameters
        ----------
        toCopy: gum::UtilityTable< double > const &

        """
        this = _pyAgrum.new_UtilityTable_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        self._notSync=True




    def newFactory(self) -> "gum::UtilityTable< double > *":
        """
        newFactory(UtilityTable_double self) -> UtilityTable_double

        Parameters
        ----------
        self: gum::UtilityTable< double > const *

        """
        return _pyAgrum.UtilityTable_double_newFactory(self)


    def variablesSequence(self):
        varlist = []
        for i in range(0, self.nbrDim()):
            varlist.append(self.variable(i))
        return varlist

    def __mul__(self,p2):
        """
        return self * p2
        """
        p=UtilityTable()
        p.multiplicate(self,p2)
        return p

    def eliminates(self,var):
        """
        eliminates a variable in the UtilityTable. Returns the new UtilityTable or self if the variable is not in self.
        @warning : returns a list with only one scalar if eliminates remove the last variable
        """
        if var.name() in self.var_names:
            q=UtilityTable()
            for i in range(self.nbrDim()):
                if self.variable(i)!=var:
                    q.add(self.variable(i))
            if q.nbrDim()>0:
                q.marginalize(self)
            else:
                q=[self.sum()]
            return q
        else:
            return self


    def __fill_distrib__(self):
      if not hasattr(self,'_notSync'):
        self._notSync=True

      if self._notSync:
        self._notSync=False
        self._var_names = []
        self._var_dims = []
        content = []
        if self.empty():
            self.__distrib__ = numpy.array(content, dtype=numpy.float64) #M
            return
        i = Instantiation(self)
        i.setFirst()
        while not i.end():
            content.append(self.get(i))
            i.inc()
        self.__distrib__ = numpy.array(content, dtype=numpy.float64) #M
        for var in self.variablesSequence():
            self._var_names.append(var.name())
            self._var_dims.append(var.domainSize())
        self._var_names.reverse()
        self._var_dims.reverse()
        self.__distrib__.shape = tuple(self._var_dims)



    def __indexfromdict__(self, id_dict):
        index = []
        for name, dim in zip(self._var_names, self._var_dims):
            if name in id_dict:
                id_value = id_dict[name]
                if isinstance(id_value, str):
    # id_value is a label of a LabelizedVar
                    i = self._var_names.index(name)
                    var = self.variable(len(self._var_names) - 1 - i)
                    id_value = var[id_value]
                if id_value >= dim:
                    raise IndexError("\"%s\" size is %d !"%(name, dim))
                index.append(id_value)
            else:
                index.append(slice(None, None, None)) # equivalent to ':'
        return tuple(index)



    def __str__(self) -> "char const *":
        """
        __str__(UtilityTable_double self) -> char const *

        Parameters
        ----------
        self: gum::UtilityTable< double > *

        """
        return _pyAgrum.UtilityTable_double___str__(self)


    def tolist(self):
        self.__fill_distrib__()
        return self.__distrib__.tolist()



    def toarray(self):
        return numpy.array(self.tolist())



    def __getitem__(self, id):
        self.__fill_distrib__()
        if self.empty():
            raise IndexError("%s is empty !!"%(str(self)))
        if isinstance(id, dict):
            id_slice = self.__indexfromdict__(id)
        else:
            id_slice = id
        return self.__distrib__[id_slice]



    def __setitem__(self, id, value):
        self.__fill_distrib__()
        if self.empty():
            raise IndexError("%s is empty !!"%(str(self)))
        if isinstance(id, dict):
            id_slice = self.__indexfromdict__(id)
        else:
            id_slice = id
        self.__distrib__[id_slice] = value
        self.populate(self.__distrib__.reshape(self.__distrib__.size).tolist())



    @property
    def var_names(self):
        self.__fill_distrib__()
        return self._var_names



    @property
    def var_dims(self):
        self.__fill_distrib__()
        return self._var_dims



    def get(self, i: 'Instantiation') -> "double":
        """
        get(UtilityTable_double self, Instantiation i) -> double

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.UtilityTable_double_get(self, i)


    def set(self, i: 'Instantiation', value: 'double const &') -> "void":
        """
        set(UtilityTable_double self, Instantiation i, double const & value)

        Parameters
        ----------
        i: gum::Instantiation const &
        value: double const &

        """
        val = _pyAgrum.UtilityTable_double_set(self, i, value)

        self._notSync=True


        return val


    def empty(self) -> "bool":
        """
        empty(UtilityTable_double self) -> bool

        Parameters
        ----------
        self: gum::UtilityTable< double > const *

        """
        return _pyAgrum.UtilityTable_double_empty(self)


    def pos(self, v: 'DiscreteVariable') -> "gum::Idx":
        """
        pos(UtilityTable_double self, DiscreteVariable v) -> gum::Idx

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.UtilityTable_double_pos(self, v)


    def contains(self, v: 'DiscreteVariable') -> "bool":
        """
        contains(UtilityTable_double self, DiscreteVariable v) -> bool

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        return _pyAgrum.UtilityTable_double_contains(self, v)


    def nbrDim(self) -> "gum::Idx":
        """
        nbrDim(UtilityTable_double self) -> gum::Idx

        Parameters
        ----------
        self: gum::UtilityTable< double > const *

        """
        return _pyAgrum.UtilityTable_double_nbrDim(self)


    def variable(self, i: 'gum::Idx') -> "gum::DiscreteVariable const &":
        """
        variable(UtilityTable_double self, gum::Idx i) -> DiscreteVariable

        Parameters
        ----------
        i: gum::Idx

        """
        return _pyAgrum.UtilityTable_double_variable(self, i)


    def populate(self, v: 'Vector_double') -> "void":
        """
        populate(UtilityTable_double self, Vector_double v)

        Parameters
        ----------
        v: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.UtilityTable_double_populate(self, v)


    def fill(self, d: 'double const &') -> "void":
        """
        fill(UtilityTable_double self, double const & d)

        Parameters
        ----------
        d: double const &

        """
        return _pyAgrum.UtilityTable_double_fill(self, d)


    def remove(self, var: 'DiscreteVariable') -> "void":
        """
        remove(UtilityTable_double self, DiscreteVariable var)

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        val = _pyAgrum.UtilityTable_double_remove(self, var)

        self._notSync=True


        return val


    def add(self, v: 'DiscreteVariable') -> "void":
        """
        add(UtilityTable_double self, DiscreteVariable v)

        Parameters
        ----------
        v: gum::DiscreteVariable const &

        """
        val = _pyAgrum.UtilityTable_double_add(self, v)

        self._notSync=True


        return val

UtilityTable_double_swigregister = _pyAgrum.UtilityTable_double_swigregister
UtilityTable_double_swigregister(UtilityTable_double)

class IBayesNet_double(DAGmodel):
    """Proxy of C++ gum::IBayesNet<(double)> class."""

    __swig_setmethods__ = {}
    for _s in [DAGmodel]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IBayesNet_double, name, value)
    __swig_getmethods__ = {}
    for _s in [DAGmodel]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IBayesNet_double, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_IBayesNet_double
    __del__ = lambda self: None

    def cpt(self, varId: 'gum::NodeId') -> "gum::Potential< double > const &":
        """
        cpt(IBayesNet_double self, gum::NodeId varId) -> Potential_double

        Parameters
        ----------
        varId: gum::NodeId

        """
        return _pyAgrum.IBayesNet_double_cpt(self, varId)


    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        """
        variableNodeMap(IBayesNet_double self) -> VariableNodeMap

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_variableNodeMap(self)


    def variable(self, id: 'gum::NodeId') -> "gum::DiscreteVariable const &":
        """
        variable(IBayesNet_double self, gum::NodeId id) -> DiscreteVariable

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.IBayesNet_double_variable(self, id)


    def nodeId(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        nodeId(IBayesNet_double self, DiscreteVariable var) -> gum::NodeId

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        return _pyAgrum.IBayesNet_double_nodeId(self, var)


    def idFromName(self, name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(IBayesNet_double self, std::string const & name) -> gum::NodeId

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.IBayesNet_double_idFromName(self, name)


    def variableFromName(self, name: 'std::string const &') -> "gum::DiscreteVariable const &":
        """
        variableFromName(IBayesNet_double self, std::string const & name) -> DiscreteVariable

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.IBayesNet_double_variableFromName(self, name)


    def jointProbability(self, i: 'Instantiation') -> "double":
        """
        jointProbability(IBayesNet_double self, Instantiation i) -> double

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.IBayesNet_double_jointProbability(self, i)


    def log2JointProbability(self, i: 'Instantiation') -> "double":
        """
        log2JointProbability(IBayesNet_double self, Instantiation i) -> double

        Parameters
        ----------
        i: gum::Instantiation const &

        """
        return _pyAgrum.IBayesNet_double_log2JointProbability(self, i)


    def __eq__(self, src: 'IBayesNet_double') -> "bool":
        """
        __eq__(IBayesNet_double self, IBayesNet_double src) -> bool

        Parameters
        ----------
        src: gum::IBayesNet< double > const &

        """
        return _pyAgrum.IBayesNet_double___eq__(self, src)


    def __ne__(self, src: 'IBayesNet_double') -> "bool":
        """
        __ne__(IBayesNet_double self, IBayesNet_double src) -> bool

        Parameters
        ----------
        src: gum::IBayesNet< double > const &

        """
        return _pyAgrum.IBayesNet_double___ne__(self, src)


    def dim(self) -> "gum::Size":
        """
        dim(IBayesNet_double self) -> gum::Size

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_dim(self)


    def maxVarDomainSize(self) -> "gum::Size":
        """
        maxVarDomainSize(IBayesNet_double self) -> gum::Size

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_maxVarDomainSize(self)


    def minParam(self) -> "double":
        """
        minParam(IBayesNet_double self) -> double

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_minParam(self)


    def maxParam(self) -> "double":
        """
        maxParam(IBayesNet_double self) -> double

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_maxParam(self)


    def minNonZeroParam(self) -> "double":
        """
        minNonZeroParam(IBayesNet_double self) -> double

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_minNonZeroParam(self)


    def maxNonOneParam(self) -> "double":
        """
        maxNonOneParam(IBayesNet_double self) -> double

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_maxNonOneParam(self)


    def toDot(self) -> "std::string":
        """
        toDot(IBayesNet_double self) -> std::string

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_toDot(self)


    def __str__(self) -> "std::string":
        """
        __str__(IBayesNet_double self) -> std::string

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double___str__(self)


    def names(self) -> "PyObject *":
        """
        names(IBayesNet_double self) -> PyObject *

        Parameters
        ----------
        self: gum::IBayesNet< double > const *

        """
        return _pyAgrum.IBayesNet_double_names(self)


    def ids(self) -> "PyObject *":
        """
        ids(IBayesNet_double self) -> PyObject *

        Parameters
        ----------
        self: gum::IBayesNet< double > *

        """
        return _pyAgrum.IBayesNet_double_ids(self)


    def arcs(self) -> "PyObject *":
        """
        arcs(IBayesNet_double self) -> PyObject *

        Parameters
        ----------
        self: gum::IBayesNet< double > *

        """
        return _pyAgrum.IBayesNet_double_arcs(self)


    def parents(self, id: 'gum::NodeId const') -> "PyObject *":
        """
        parents(IBayesNet_double self, gum::NodeId const id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.IBayesNet_double_parents(self, id)


    def children(self, id: 'gum::NodeId const') -> "PyObject *":
        """
        children(IBayesNet_double self, gum::NodeId const id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.IBayesNet_double_children(self, id)

IBayesNet_double_swigregister = _pyAgrum.IBayesNet_double_swigregister
IBayesNet_double_swigregister(IBayesNet_double)

class BayesNet_double(IBayesNet_double):
    """Proxy of C++ gum::BayesNet<(double)> class."""

    __swig_setmethods__ = {}
    for _s in [IBayesNet_double]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BayesNet_double, name, value)
    __swig_getmethods__ = {}
    for _s in [IBayesNet_double]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BayesNet_double, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_BayesNet_double
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(gum::BayesNet<(double)> self) -> BayesNet_double
        __init__(gum::BayesNet<(double)> self, std::string name) -> BayesNet_double

        Parameters
        ----------
        name: std::string

        __init__(gum::BayesNet<(double)> self, BayesNet_double source) -> BayesNet_double

        Parameters
        ----------
        source: gum::BayesNet< double > const &

        """
        this = _pyAgrum.new_BayesNet_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def cpt(self, *args) -> "gum::Potential< double > const &":
        """
        cpt(BayesNet_double self, gum::NodeId varId) -> Potential_double

        Parameters
        ----------
        varId: gum::NodeId

        cpt(BayesNet_double self, std::string const & name) -> Potential_double

        Parameters
        ----------
        name: std::string const &

        """
        val = _pyAgrum.BayesNet_double_cpt(self, *args)

        val.__fill_distrib__()


        return val


    def variableNodeMap(self) -> "gum::VariableNodeMap const &":
        """
        variableNodeMap(BayesNet_double self) -> VariableNodeMap

        Parameters
        ----------
        self: gum::BayesNet< double > const *

        """
        return _pyAgrum.BayesNet_double_variableNodeMap(self)


    def add(self, *args) -> "gum::NodeId":
        """
        add(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        add(BayesNet_double self, std::string const & name, unsigned int nbrmod) -> gum::NodeId

        Parameters
        ----------
        name: std::string const &
        nbrmod: unsigned int

        add(BayesNet_double self, DiscreteVariable variable, gum::MultiDimImplementation< double > * aContent) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        aContent: gum::MultiDimImplementation< double > *

        add(BayesNet_double self, DiscreteVariable variable, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        id: gum::NodeId

        add(BayesNet_double self, DiscreteVariable variable, gum::MultiDimImplementation< double > * aContent, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        aContent: gum::MultiDimImplementation< double > *
        id: gum::NodeId

        """
        return _pyAgrum.BayesNet_double_add(self, *args)


    def erase(self, *args) -> "void":
        """
        erase(BayesNet_double self, gum::NodeId id)

        Parameters
        ----------
        id: gum::NodeId

        erase(BayesNet_double self, std::string const & name)

        Parameters
        ----------
        name: std::string const &

        erase(BayesNet_double self, DiscreteVariable var)

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_erase(self, *args)


    def variable(self, *args) -> "gum::DiscreteVariable const &":
        """
        variable(BayesNet_double self, gum::NodeId id) -> DiscreteVariable

        Parameters
        ----------
        id: gum::NodeId

        variable(BayesNet_double self, std::string const & name) -> DiscreteVariable

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.BayesNet_double_variable(self, *args)


    def changeVariableName(self, *args) -> "void":
        """
        changeVariableName(BayesNet_double self, gum::NodeId id, std::string const & new_name)

        Parameters
        ----------
        id: gum::NodeId
        new_name: std::string const &

        changeVariableName(BayesNet_double self, std::string const & name, std::string const & new_name)

        Parameters
        ----------
        name: std::string const &
        new_name: std::string const &

        """
        return _pyAgrum.BayesNet_double_changeVariableName(self, *args)


    def nodeId(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        nodeId(BayesNet_double self, DiscreteVariable var) -> gum::NodeId

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_nodeId(self, var)


    def idFromName(self, name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(BayesNet_double self, std::string const & name) -> gum::NodeId

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.BayesNet_double_idFromName(self, name)


    def variableFromName(self, name: 'std::string const &') -> "gum::DiscreteVariable const &":
        """
        variableFromName(BayesNet_double self, std::string const & name) -> DiscreteVariable

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.BayesNet_double_variableFromName(self, name)


    def addArc(self, *args) -> "void":
        """
        addArc(BayesNet_double self, gum::NodeId tail, gum::NodeId head)

        Parameters
        ----------
        tail: gum::NodeId
        head: gum::NodeId

        addArc(BayesNet_double self, std::string const & tail, std::string const & head)

        Parameters
        ----------
        tail: std::string const &
        head: std::string const &

        """
        return _pyAgrum.BayesNet_double_addArc(self, *args)


    def eraseArc(self, *args) -> "void":
        """
        eraseArc(BayesNet_double self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        eraseArc(BayesNet_double self, gum::NodeId tail, gum::NodeId head)

        Parameters
        ----------
        tail: gum::NodeId
        head: gum::NodeId

        eraseArc(BayesNet_double self, std::string const & tail, std::string const & head)

        Parameters
        ----------
        tail: std::string const &
        head: std::string const &

        """
        return _pyAgrum.BayesNet_double_eraseArc(self, *args)


    def beginTopologyTransformation(self) -> "void":
        """
        beginTopologyTransformation(BayesNet_double self)

        Parameters
        ----------
        self: gum::BayesNet< double > *

        """
        return _pyAgrum.BayesNet_double_beginTopologyTransformation(self)


    def endTopologyTransformation(self) -> "void":
        """
        endTopologyTransformation(BayesNet_double self)

        Parameters
        ----------
        self: gum::BayesNet< double > *

        """
        return _pyAgrum.BayesNet_double_endTopologyTransformation(self)


    def reverseArc(self, *args) -> "void":
        """
        reverseArc(BayesNet_double self, gum::NodeId tail, gum::NodeId head)

        Parameters
        ----------
        tail: gum::NodeId
        head: gum::NodeId

        reverseArc(BayesNet_double self, std::string const & tail, std::string const & head)

        Parameters
        ----------
        tail: std::string const &
        head: std::string const &

        reverseArc(BayesNet_double self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        """
        return _pyAgrum.BayesNet_double_reverseArc(self, *args)


    def addNoisyOR(self, *args) -> "gum::NodeId":
        """
        addNoisyOR(BayesNet_double self, DiscreteVariable variable, double externalWeight) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double

        addNoisyOR(BayesNet_double self, DiscreteVariable variable, double externalWeight, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double
        id: gum::NodeId

        """
        return _pyAgrum.BayesNet_double_addNoisyOR(self, *args)


    def addNoisyORNet(self, *args) -> "gum::NodeId":
        """
        addNoisyORNet(BayesNet_double self, DiscreteVariable variable, double externalWeight) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double

        addNoisyORNet(BayesNet_double self, DiscreteVariable variable, double externalWeight, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double
        id: gum::NodeId

        """
        return _pyAgrum.BayesNet_double_addNoisyORNet(self, *args)


    def addNoisyORCompound(self, *args) -> "gum::NodeId":
        """
        addNoisyORCompound(BayesNet_double self, DiscreteVariable variable, double externalWeight) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double

        addNoisyORCompound(BayesNet_double self, DiscreteVariable variable, double externalWeight, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double
        id: gum::NodeId

        """
        return _pyAgrum.BayesNet_double_addNoisyORCompound(self, *args)


    def addNoisyAND(self, *args) -> "gum::NodeId":
        """
        addNoisyAND(BayesNet_double self, DiscreteVariable variable, double externalWeight, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double
        id: gum::NodeId

        addNoisyAND(BayesNet_double self, DiscreteVariable variable, double externalWeight) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double

        """
        return _pyAgrum.BayesNet_double_addNoisyAND(self, *args)


    def addLogit(self, *args) -> "gum::NodeId":
        """
        addLogit(BayesNet_double self, DiscreteVariable variable, double externalWeight, gum::NodeId id) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double
        id: gum::NodeId

        addLogit(BayesNet_double self, DiscreteVariable variable, double externalWeight) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        externalWeight: double

        """
        return _pyAgrum.BayesNet_double_addLogit(self, *args)


    def addOR(self, variable: 'DiscreteVariable') -> "gum::NodeId":
        """
        addOR(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addOR(self, variable)


    def addAND(self, variable: 'DiscreteVariable') -> "gum::NodeId":
        """
        addAND(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addAND(self, variable)


    def addAMPLITUDE(self, variable: 'DiscreteVariable') -> "gum::NodeId":
        """
        addAMPLITUDE(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addAMPLITUDE(self, variable)


    def addCOUNT(self, variable: 'DiscreteVariable', Value: 'gum::Idx'=1) -> "gum::NodeId":
        """
        addCOUNT(BayesNet_double self, DiscreteVariable variable, gum::Idx Value=1) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        Value: gum::Idx

        addCOUNT(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addCOUNT(self, variable, Value)


    def addEXISTS(self, variable: 'DiscreteVariable', Value: 'gum::Idx'=1) -> "gum::NodeId":
        """
        addEXISTS(BayesNet_double self, DiscreteVariable variable, gum::Idx Value=1) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        Value: gum::Idx

        addEXISTS(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addEXISTS(self, variable, Value)


    def addFORALL(self, variable: 'DiscreteVariable', Value: 'gum::Idx'=1) -> "gum::NodeId":
        """
        addFORALL(BayesNet_double self, DiscreteVariable variable, gum::Idx Value=1) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        Value: gum::Idx

        addFORALL(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addFORALL(self, variable, Value)


    def addMAX(self, variable: 'DiscreteVariable') -> "gum::NodeId":
        """
        addMAX(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addMAX(self, variable)


    def addMEDIAN(self, variable: 'DiscreteVariable') -> "gum::NodeId":
        """
        addMEDIAN(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addMEDIAN(self, variable)


    def addMIN(self, variable: 'DiscreteVariable') -> "gum::NodeId":
        """
        addMIN(BayesNet_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.BayesNet_double_addMIN(self, variable)


    def addWeightedArc(self, tail: 'gum::NodeId', head: 'gum::NodeId', causalWeight: 'double') -> "void":
        """
        addWeightedArc(BayesNet_double self, gum::NodeId tail, gum::NodeId head, double causalWeight)

        Parameters
        ----------
        tail: gum::NodeId
        head: gum::NodeId
        causalWeight: double

        """
        return _pyAgrum.BayesNet_double_addWeightedArc(self, tail, head, causalWeight)


    def generateCPTs(self) -> "void":
        """
        generateCPTs(BayesNet_double self)

        Parameters
        ----------
        self: gum::BayesNet< double > const *

        """
        return _pyAgrum.BayesNet_double_generateCPTs(self)


    def generateCPT(self, *args) -> "void":
        """
        generateCPT(BayesNet_double self, gum::NodeId node)

        Parameters
        ----------
        node: gum::NodeId

        generateCPT(BayesNet_double self, std::string const & name)

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.BayesNet_double_generateCPT(self, *args)


    def changePotential(self, *args) -> "void":
        """
        changePotential(BayesNet_double self, gum::NodeId id, Potential_double newPot)

        Parameters
        ----------
        id: gum::NodeId
        newPot: gum::Potential< double > *

        changePotential(BayesNet_double self, std::string const & name, Potential_double newPot)

        Parameters
        ----------
        name: std::string const &
        newPot: gum::Potential< double > *

        """
        return _pyAgrum.BayesNet_double_changePotential(self, *args)


    def dag(self) -> "gum::DAG const &":
        """
        dag(BayesNet_double self) -> DAG

        Parameters
        ----------
        self: gum::BayesNet< double > const *

        """
        return _pyAgrum.BayesNet_double_dag(self)


    def size(self) -> "gum::Size":
        """
        size(BayesNet_double self) -> gum::Size

        Parameters
        ----------
        self: gum::BayesNet< double > const *

        """
        return _pyAgrum.BayesNet_double_size(self)


    def log10DomainSize(self) -> "double":
        """
        log10DomainSize(BayesNet_double self) -> double

        Parameters
        ----------
        self: gum::BayesNet< double > const *

        """
        return _pyAgrum.BayesNet_double_log10DomainSize(self)


    def names(self) -> "PyObject *":
        """
        names(BayesNet_double self) -> PyObject *

        Parameters
        ----------
        self: gum::BayesNet< double > const *

        """
        return _pyAgrum.BayesNet_double_names(self)


    def ids(self) -> "PyObject *":
        """
        ids(BayesNet_double self) -> PyObject *

        Parameters
        ----------
        self: gum::BayesNet< double > *

        """
        return _pyAgrum.BayesNet_double_ids(self)


    def arcs(self) -> "PyObject *":
        """
        arcs(BayesNet_double self) -> PyObject *

        Parameters
        ----------
        self: gum::BayesNet< double > *

        """
        return _pyAgrum.BayesNet_double_arcs(self)


    def parents(self, id: 'gum::NodeId const') -> "PyObject *":
        """
        parents(BayesNet_double self, gum::NodeId const id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.BayesNet_double_parents(self, id)


    def children(self, id: 'gum::NodeId const') -> "PyObject *":
        """
        children(BayesNet_double self, gum::NodeId const id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.BayesNet_double_children(self, id)


    def loadBIF(self, *args) -> "std::string":
        """
        loadBIF(BayesNet_double self, std::string name, PyObject * l) -> std::string

        Parameters
        ----------
        name: std::string
        l: PyObject *

        loadBIF(BayesNet_double self, std::string name) -> std::string

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_loadBIF(self, *args)


    def saveBIF(self, name: 'std::string') -> "void":
        """
        saveBIF(BayesNet_double self, std::string name)

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_saveBIF(self, name)


    def loadDSL(self, *args) -> "std::string":
        """
        loadDSL(BayesNet_double self, std::string name, PyObject * l) -> std::string

        Parameters
        ----------
        name: std::string
        l: PyObject *

        loadDSL(BayesNet_double self, std::string name) -> std::string

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_loadDSL(self, *args)


    def saveDSL(self, name: 'std::string') -> "void":
        """
        saveDSL(BayesNet_double self, std::string name)

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_saveDSL(self, name)


    def loadNET(self, *args) -> "std::string":
        """
        loadNET(BayesNet_double self, std::string name, PyObject * l) -> std::string

        Parameters
        ----------
        name: std::string
        l: PyObject *

        loadNET(BayesNet_double self, std::string name) -> std::string

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_loadNET(self, *args)


    def saveNET(self, name: 'std::string') -> "void":
        """
        saveNET(BayesNet_double self, std::string name)

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_saveNET(self, name)


    def loadPRM(self, *args) -> "std::string":
        """
        loadPRM(BayesNet_double self, std::string name, std::string system, std::string classpath, PyObject * l) -> std::string

        Parameters
        ----------
        name: std::string
        system: std::string
        classpath: std::string
        l: PyObject *

        loadPRM(BayesNet_double self, std::string name, std::string system, std::string classpath) -> std::string

        Parameters
        ----------
        name: std::string
        system: std::string
        classpath: std::string

        loadPRM(BayesNet_double self, std::string name, std::string system) -> std::string

        Parameters
        ----------
        name: std::string
        system: std::string

        loadPRM(BayesNet_double self, std::string name) -> std::string

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_loadPRM(self, *args)


    def loadBIFXML(self, *args) -> "std::string":
        """
        loadBIFXML(BayesNet_double self, std::string name, PyObject * l) -> std::string

        Parameters
        ----------
        name: std::string
        l: PyObject *

        loadBIFXML(BayesNet_double self, std::string name) -> std::string

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_loadBIFXML(self, *args)


    def saveBIFXML(self, name: 'std::string') -> "void":
        """
        saveBIFXML(BayesNet_double self, std::string name)

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_saveBIFXML(self, name)


    def loadUAI(self, *args) -> "std::string":
        """
        loadUAI(BayesNet_double self, std::string name, PyObject * l) -> std::string

        Parameters
        ----------
        name: std::string
        l: PyObject *

        loadUAI(BayesNet_double self, std::string name) -> std::string

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_loadUAI(self, *args)


    def saveUAI(self, name: 'std::string') -> "void":
        """
        saveUAI(BayesNet_double self, std::string name)

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.BayesNet_double_saveUAI(self, name)

BayesNet_double_swigregister = _pyAgrum.BayesNet_double_swigregister
BayesNet_double_swigregister(BayesNet_double)

class BayesNetInference_double(_object):
    """Proxy of C++ gum::BayesNetInference<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BayesNetInference_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BayesNetInference_double, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    StateOfInference_OutdatedBNStructure = _pyAgrum.BayesNetInference_double_StateOfInference_OutdatedBNStructure
    StateOfInference_OutdatedBNPotentials = _pyAgrum.BayesNetInference_double_StateOfInference_OutdatedBNPotentials
    StateOfInference_Ready4Inference = _pyAgrum.BayesNetInference_double_StateOfInference_Ready4Inference
    StateOfInference_Done = _pyAgrum.BayesNetInference_double_StateOfInference_Done
    __swig_destroy__ = _pyAgrum.delete_BayesNetInference_double
    __del__ = lambda self: None

    def setBayesNet(self, bn: 'IBayesNet_double') -> "void":
        """
        setBayesNet(BayesNetInference_double self, IBayesNet_double bn)

        Parameters
        ----------
        bn: gum::IBayesNet< double > const *

        """
        return _pyAgrum.BayesNetInference_double_setBayesNet(self, bn)


    def BayesNet(self) -> "gum::IBayesNet< double > const &":
        """
        BayesNet(BayesNetInference_double self) -> IBayesNet_double

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_BayesNet(self)


    def domainSizes(self) -> "NodeProperty< gum::Size > const &":
        """
        domainSizes(BayesNetInference_double self) -> NodeProperty< gum::Size > const &

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_domainSizes(self)


    def isReady4Inference(self) -> "bool":
        """
        isReady4Inference(BayesNetInference_double self) -> bool

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_isReady4Inference(self)


    def isDone(self) -> "bool":
        """
        isDone(BayesNetInference_double self) -> bool

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_isDone(self)


    def prepareInference(self) -> "void":
        """
        prepareInference(BayesNetInference_double self)

        Parameters
        ----------
        self: gum::BayesNetInference< double > *

        """
        return _pyAgrum.BayesNetInference_double_prepareInference(self)


    def makeInference(self) -> "void":
        """
        makeInference(BayesNetInference_double self)

        Parameters
        ----------
        self: gum::BayesNetInference< double > *

        """
        return _pyAgrum.BayesNetInference_double_makeInference(self)


    def clear(self) -> "void":
        """
        clear(BayesNetInference_double self)

        Parameters
        ----------
        self: gum::BayesNetInference< double > *

        """
        return _pyAgrum.BayesNetInference_double_clear(self)


    def state(self) -> "gum::BayesNetInference< double >::StateOfInference":
        """
        state(BayesNetInference_double self) -> gum::BayesNetInference< double >::StateOfInference

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_state(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(BayesNetInference_double self, gum::NodeId const id, gum::Idx const val)

        Parameters
        ----------
        id: gum::NodeId const
        val: gum::Idx const

        addEvidence(BayesNetInference_double self, std::string const & nodeName, gum::Idx const val)

        Parameters
        ----------
        nodeName: std::string const &
        val: gum::Idx const

        addEvidence(BayesNetInference_double self, gum::NodeId const id, std::string const & label)

        Parameters
        ----------
        id: gum::NodeId const
        label: std::string const &

        addEvidence(BayesNetInference_double self, std::string const & nodeName, std::string const & label)

        Parameters
        ----------
        nodeName: std::string const &
        label: std::string const &

        addEvidence(BayesNetInference_double self, gum::NodeId const id, Vector_double vals)

        Parameters
        ----------
        id: gum::NodeId const
        vals: std::vector< double,std::allocator< double > > const &

        addEvidence(BayesNetInference_double self, std::string const & nodeName, Vector_double vals)

        Parameters
        ----------
        nodeName: std::string const &
        vals: std::vector< double,std::allocator< double > > const &

        addEvidence(BayesNetInference_double self, Potential_double pot)

        Parameters
        ----------
        pot: gum::Potential< double > const &

        addEvidence(BayesNetInference_double self, Potential_double pot)

        Parameters
        ----------
        pot: gum::Potential< double > &&

        """
        return _pyAgrum.BayesNetInference_double_addEvidence(self, *args)


    def addSetOfEvidence(self, potlist: 'Set< gum::Potential< double > const * > const &') -> "void":
        """
        addSetOfEvidence(BayesNetInference_double self, Set< gum::Potential< double > const * > const & potlist)

        Parameters
        ----------
        potlist: Set< gum::Potential< double > const * > const &

        """
        return _pyAgrum.BayesNetInference_double_addSetOfEvidence(self, potlist)


    def addListOfEvidence(self, potlist: 'gum::List< gum::Potential< double > const * > const &') -> "void":
        """
        addListOfEvidence(BayesNetInference_double self, gum::List< gum::Potential< double > const * > const & potlist)

        Parameters
        ----------
        potlist: gum::List< gum::Potential< double > const * > const &

        """
        return _pyAgrum.BayesNetInference_double_addListOfEvidence(self, potlist)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(BayesNetInference_double self, gum::NodeId const id, gum::Idx const val)

        Parameters
        ----------
        id: gum::NodeId const
        val: gum::Idx const

        chgEvidence(BayesNetInference_double self, std::string const & nodeName, gum::Idx const val)

        Parameters
        ----------
        nodeName: std::string const &
        val: gum::Idx const

        chgEvidence(BayesNetInference_double self, gum::NodeId const id, std::string const & label)

        Parameters
        ----------
        id: gum::NodeId const
        label: std::string const &

        chgEvidence(BayesNetInference_double self, std::string const & nodeName, std::string const & label)

        Parameters
        ----------
        nodeName: std::string const &
        label: std::string const &

        chgEvidence(BayesNetInference_double self, gum::NodeId const id, Vector_double vals)

        Parameters
        ----------
        id: gum::NodeId const
        vals: std::vector< double,std::allocator< double > > const &

        chgEvidence(BayesNetInference_double self, std::string const & nodeName, Vector_double vals)

        Parameters
        ----------
        nodeName: std::string const &
        vals: std::vector< double,std::allocator< double > > const &

        chgEvidence(BayesNetInference_double self, Potential_double pot)

        Parameters
        ----------
        pot: gum::Potential< double > const &

        """
        return _pyAgrum.BayesNetInference_double_chgEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(BayesNetInference_double self)

        Parameters
        ----------
        self: gum::BayesNetInference< double > *

        """
        return _pyAgrum.BayesNetInference_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(BayesNetInference_double self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        eraseEvidence(BayesNetInference_double self, std::string const & nodeName)

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.BayesNetInference_double_eraseEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(BayesNetInference_double self) -> bool
        hasEvidence(BayesNetInference_double self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        hasEvidence(BayesNetInference_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.BayesNetInference_double_hasEvidence(self, *args)


    def hasHardEvidence(self, *args) -> "bool":
        """
        hasHardEvidence(BayesNetInference_double self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        hasHardEvidence(BayesNetInference_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.BayesNetInference_double_hasHardEvidence(self, *args)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(BayesNetInference_double self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        hasSoftEvidence(BayesNetInference_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.BayesNetInference_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(BayesNetInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(BayesNetInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(BayesNetInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_nbrSoftEvidence(self)


    def evidence(self) -> "NodeProperty< gum::Potential< double > const * > const &":
        """
        evidence(BayesNetInference_double self) -> NodeProperty< gum::Potential< double > const * > const &

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_evidence(self)


    def softEvidenceNodes(self) -> "gum::NodeSet const &":
        """
        softEvidenceNodes(BayesNetInference_double self) -> gum::NodeSet const &

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_softEvidenceNodes(self)


    def hardEvidenceNodes(self) -> "gum::NodeSet const &":
        """
        hardEvidenceNodes(BayesNetInference_double self) -> gum::NodeSet const &

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_hardEvidenceNodes(self)


    def hardEvidence(self) -> "NodeProperty< gum::Idx > const &":
        """
        hardEvidence(BayesNetInference_double self) -> NodeProperty< gum::Idx > const &

        Parameters
        ----------
        self: gum::BayesNetInference< double > const *

        """
        return _pyAgrum.BayesNetInference_double_hardEvidence(self)

BayesNetInference_double_swigregister = _pyAgrum.BayesNetInference_double_swigregister
BayesNetInference_double_swigregister(BayesNetInference_double)

class LazyPropagation_double(_object):
    """Proxy of C++ gum::LazyPropagation<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LazyPropagation_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LazyPropagation_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::LazyPropagation<(double)> self, IBayesNet_double BN, RelevantPotentialsFinderType arg3, gum::FindBarrenNodesType arg4, bool use_binary_join_tree=True) -> LazyPropagation_double

        Parameters
        ----------
        BN: gum::IBayesNet< double > const *
        arg3: RelevantPotentialsFinderType
        arg4: enum gum::FindBarrenNodesType
        use_binary_join_tree: bool

        __init__(gum::LazyPropagation<(double)> self, IBayesNet_double BN, RelevantPotentialsFinderType arg3, gum::FindBarrenNodesType arg4) -> LazyPropagation_double

        Parameters
        ----------
        BN: gum::IBayesNet< double > const *
        arg3: RelevantPotentialsFinderType
        arg4: enum gum::FindBarrenNodesType

        __init__(gum::LazyPropagation<(double)> self, IBayesNet_double BN, RelevantPotentialsFinderType arg3) -> LazyPropagation_double

        Parameters
        ----------
        BN: gum::IBayesNet< double > const *
        arg3: RelevantPotentialsFinderType

        __init__(gum::LazyPropagation<(double)> self, IBayesNet_double BN) -> LazyPropagation_double

        Parameters
        ----------
        BN: gum::IBayesNet< double > const *

        """
        this = _pyAgrum.new_LazyPropagation_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_LazyPropagation_double
    __del__ = lambda self: None

    def setTriangulation(self, new_triangulation: 'Triangulation const &') -> "void":
        """
        setTriangulation(LazyPropagation_double self, Triangulation const & new_triangulation)

        Parameters
        ----------
        new_triangulation: Triangulation const &

        """
        return _pyAgrum.LazyPropagation_double_setTriangulation(self, new_triangulation)


    def setRelevantPotentialsFinderType(self, type: 'RelevantPotentialsFinderType') -> "void":
        """
        setRelevantPotentialsFinderType(LazyPropagation_double self, RelevantPotentialsFinderType type)

        Parameters
        ----------
        type: RelevantPotentialsFinderType

        """
        return _pyAgrum.LazyPropagation_double_setRelevantPotentialsFinderType(self, type)


    def setFindBarrenNodesType(self, type: 'gum::FindBarrenNodesType') -> "void":
        """
        setFindBarrenNodesType(LazyPropagation_double self, gum::FindBarrenNodesType type)

        Parameters
        ----------
        type: enum gum::FindBarrenNodesType

        """
        return _pyAgrum.LazyPropagation_double_setFindBarrenNodesType(self, type)


    def joinTree(self) -> "gum::JoinTree const *":
        """
        joinTree(LazyPropagation_double self) -> CliqueGraph

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_joinTree(self)


    def junctionTree(self) -> "gum::JunctionTree const *":
        """
        junctionTree(LazyPropagation_double self) -> CliqueGraph

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_junctionTree(self)


    def evidenceProbability(self) -> "double":
        """
        evidenceProbability(LazyPropagation_double self) -> double

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_evidenceProbability(self)


    def setEvidence(self, evidces):
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceList(self) -> "PyObject *":
        """
        hardEvidenceList(LazyPropagation_double self) -> PyObject *

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_hardEvidenceList(self)


    def softEvidenceList(self) -> "PyObject *":
        """
        softEvidenceList(LazyPropagation_double self) -> PyObject *

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_softEvidenceList(self)


    def targetList(self) -> "PyObject *":
        """
        targetList(LazyPropagation_double self) -> PyObject *

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_targetList(self)


    def jointPosterior(self, list: 'PyObject *') -> "gum::Potential< double >":
        """
        jointPosterior(LazyPropagation_double self, PyObject * list) -> Potential_double

        Parameters
        ----------
        list: PyObject *

        """
        return _pyAgrum.LazyPropagation_double_jointPosterior(self, list)


    def addJointTarget(self, list: 'PyObject *') -> "void":
        """
        addJointTarget(LazyPropagation_double self, PyObject * list)

        Parameters
        ----------
        list: PyObject *

        """
        return _pyAgrum.LazyPropagation_double_addJointTarget(self, list)


    def eraseJointTarget(self, list: 'PyObject *') -> "void":
        """
        eraseJointTarget(LazyPropagation_double self, PyObject * list)

        Parameters
        ----------
        list: PyObject *

        """
        return _pyAgrum.LazyPropagation_double_eraseJointTarget(self, list)


    def isJointTarget(self, list: 'PyObject *') -> "bool":
        """
        isJointTarget(LazyPropagation_double self, PyObject * list) -> bool

        Parameters
        ----------
        list: PyObject *

        """
        return _pyAgrum.LazyPropagation_double_isJointTarget(self, list)


    def jointTargets(self) -> "PyObject *":
        """
        jointTargets(LazyPropagation_double self) -> PyObject *

        Parameters
        ----------
        self: gum::LazyPropagation< double > const *

        """
        return _pyAgrum.LazyPropagation_double_jointTargets(self)


    def makeInference(self) -> "void":
        """
        makeInference(LazyPropagation_double self)

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(LazyPropagation_double self, gum::NodeId const var) -> Potential_double

        Parameters
        ----------
        var: gum::NodeId const

        posterior(LazyPropagation_double self, std::string const nodeName) -> Potential_double

        Parameters
        ----------
        nodeName: std::string const

        """
        return _pyAgrum.LazyPropagation_double_posterior(self, *args)


    def BayesNet(self) -> "gum::IBayesNet< double > const &":
        """
        BayesNet(LazyPropagation_double self) -> IBayesNet_double

        Parameters
        ----------
        self: gum::LazyPropagation< double > const *

        """
        return _pyAgrum.LazyPropagation_double_BayesNet(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(LazyPropagation_double self, gum::NodeId const id, gum::Idx const val)

        Parameters
        ----------
        id: gum::NodeId const
        val: gum::Idx const

        addEvidence(LazyPropagation_double self, std::string const & nodeName, gum::Idx const val)

        Parameters
        ----------
        nodeName: std::string const &
        val: gum::Idx const

        addEvidence(LazyPropagation_double self, gum::NodeId const id, std::string const & val)

        Parameters
        ----------
        id: gum::NodeId const
        val: std::string const &

        addEvidence(LazyPropagation_double self, std::string const & nodeName, std::string const & val)

        Parameters
        ----------
        nodeName: std::string const &
        val: std::string const &

        addEvidence(LazyPropagation_double self, gum::NodeId const id, Vector_double vals)

        Parameters
        ----------
        id: gum::NodeId const
        vals: std::vector< double,std::allocator< double > > const &

        addEvidence(LazyPropagation_double self, std::string const & nodeName, Vector_double vals)

        Parameters
        ----------
        nodeName: std::string const &
        vals: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.LazyPropagation_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(LazyPropagation_double self, gum::NodeId const id, gum::Idx const val)

        Parameters
        ----------
        id: gum::NodeId const
        val: gum::Idx const

        chgEvidence(LazyPropagation_double self, std::string const & nodeName, gum::Idx const val)

        Parameters
        ----------
        nodeName: std::string const &
        val: gum::Idx const

        chgEvidence(LazyPropagation_double self, gum::NodeId const id, std::string const & val)

        Parameters
        ----------
        id: gum::NodeId const
        val: std::string const &

        chgEvidence(LazyPropagation_double self, std::string const & nodeName, std::string const & val)

        Parameters
        ----------
        nodeName: std::string const &
        val: std::string const &

        chgEvidence(LazyPropagation_double self, gum::NodeId const id, Vector_double vals)

        Parameters
        ----------
        id: gum::NodeId const
        vals: std::vector< double,std::allocator< double > > const &

        chgEvidence(LazyPropagation_double self, std::string const & nodeName, Vector_double vals)

        Parameters
        ----------
        nodeName: std::string const &
        vals: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.LazyPropagation_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(LazyPropagation_double self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        hasEvidence(LazyPropagation_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.LazyPropagation_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(LazyPropagation_double self)

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(LazyPropagation_double self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        eraseEvidence(LazyPropagation_double self, std::string const & nodeName)

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.LazyPropagation_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(LazyPropagation_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.LazyPropagation_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(LazyPropagation_double self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        hasSoftEvidence(LazyPropagation_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.LazyPropagation_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(LazyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::LazyPropagation< double > const *

        """
        return _pyAgrum.LazyPropagation_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(LazyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::LazyPropagation< double > const *

        """
        return _pyAgrum.LazyPropagation_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(LazyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::LazyPropagation< double > const *

        """
        return _pyAgrum.LazyPropagation_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(LazyPropagation_double self)

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(LazyPropagation_double self)

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(LazyPropagation_double self, gum::NodeId const target)

        Parameters
        ----------
        target: gum::NodeId const

        addTarget(LazyPropagation_double self, std::string const & nodeName)

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.LazyPropagation_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(LazyPropagation_double self, gum::NodeId const target)

        Parameters
        ----------
        target: gum::NodeId const

        eraseTarget(LazyPropagation_double self, std::string const & nodeName)

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.LazyPropagation_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(LazyPropagation_double self, gum::NodeId const variable) -> bool

        Parameters
        ----------
        variable: gum::NodeId const

        isTarget(LazyPropagation_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.LazyPropagation_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(LazyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::LazyPropagation< double > const *

        """
        return _pyAgrum.LazyPropagation_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(LazyPropagation_double self, gum::NodeId const X) -> double

        Parameters
        ----------
        X: gum::NodeId const

        H(LazyPropagation_double self, std::string const & nodeName) -> double

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.LazyPropagation_double_H(self, *args)


    def eraseAllJointTargets(self) -> "void":
        """
        eraseAllJointTargets(LazyPropagation_double self)

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_eraseAllJointTargets(self)


    def eraseAllMarginalTargets(self) -> "void":
        """
        eraseAllMarginalTargets(LazyPropagation_double self)

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_eraseAllMarginalTargets(self)


    def nbrJointTargets(self) -> "gum::Size":
        """
        nbrJointTargets(LazyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::LazyPropagation< double > *

        """
        return _pyAgrum.LazyPropagation_double_nbrJointTargets(self)


    def I(self, X: 'gum::NodeId const', Y: 'gum::NodeId const') -> "double":
        """
        I(LazyPropagation_double self, gum::NodeId const X, gum::NodeId const Y) -> double

        Parameters
        ----------
        X: gum::NodeId const
        Y: gum::NodeId const

        """
        return _pyAgrum.LazyPropagation_double_I(self, X, Y)


    def VI(self, X: 'gum::NodeId const', Y: 'gum::NodeId const') -> "double":
        """
        VI(LazyPropagation_double self, gum::NodeId const X, gum::NodeId const Y) -> double

        Parameters
        ----------
        X: gum::NodeId const
        Y: gum::NodeId const

        """
        return _pyAgrum.LazyPropagation_double_VI(self, X, Y)

LazyPropagation_double_swigregister = _pyAgrum.LazyPropagation_double_swigregister
LazyPropagation_double_swigregister(LazyPropagation_double)

class GibbsInference_double(_object):
    """Proxy of C++ gum::GibbsInference<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GibbsInference_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GibbsInference_double, name)
    __repr__ = _swig_repr

    def __init__(self, BN: 'IBayesNet_double'):
        """
        __init__(gum::GibbsInference<(double)> self, IBayesNet_double BN) -> GibbsInference_double

        Parameters
        ----------
        BN: gum::IBayesNet< double > const *

        """
        this = _pyAgrum.new_GibbsInference_double(BN)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_GibbsInference_double
    __del__ = lambda self: None

    def setEvidence(self, evidces):
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))
        self.eraseAllEvidence()
        for k,v in evidces.items():
            self.addEvidence(k,v)



    def updateEvidence(self, evidces):
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be a dict, not %s"%(type(evidces)))

        for k,v in evidces.items():
            if self.hasEvidence(k):
                self.chgEvidence(k,v)
            else:
                self.addEvidence(k,v)



    def setTargets(self, targets):
        if not isinstance(targets, set):
            raise TypeError("setTargets parameter must be a set, not %s"%(type(targets)))

        self.eraseAllTargets()
        for k in targets:
            self.addTarget(k)



    def hardEvidenceList(self) -> "PyObject *":
        """
        hardEvidenceList(GibbsInference_double self) -> PyObject *

        Parameters
        ----------
        self: gum::GibbsInference< double > *

        """
        return _pyAgrum.GibbsInference_double_hardEvidenceList(self)


    def softEvidenceList(self) -> "PyObject *":
        """
        softEvidenceList(GibbsInference_double self) -> PyObject *

        Parameters
        ----------
        self: gum::GibbsInference< double > *

        """
        return _pyAgrum.GibbsInference_double_softEvidenceList(self)


    def targetList(self) -> "PyObject *":
        """
        targetList(GibbsInference_double self) -> PyObject *

        Parameters
        ----------
        self: gum::GibbsInference< double > *

        """
        return _pyAgrum.GibbsInference_double_targetList(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(GibbsInference_double self, bool v)

        Parameters
        ----------
        v: bool

        """
        return _pyAgrum.GibbsInference_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(GibbsInference_double self, double eps)

        Parameters
        ----------
        eps: double

        """
        return _pyAgrum.GibbsInference_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(GibbsInference_double self, double rate)

        Parameters
        ----------
        rate: double

        """
        return _pyAgrum.GibbsInference_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(GibbsInference_double self, gum::Size max)

        Parameters
        ----------
        max: gum::Size

        """
        return _pyAgrum.GibbsInference_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(GibbsInference_double self, double timeout)

        Parameters
        ----------
        timeout: double

        """
        return _pyAgrum.GibbsInference_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(GibbsInference_double self, gum::Size p)

        Parameters
        ----------
        p: gum::Size

        """
        return _pyAgrum.GibbsInference_double_setPeriodSize(self, p)


    def setBurnIn(self, b: 'gum::Size') -> "void":
        """
        setBurnIn(GibbsInference_double self, gum::Size b)

        Parameters
        ----------
        b: gum::Size

        """
        return _pyAgrum.GibbsInference_double_setBurnIn(self, b)


    def verbosity(self) -> "bool":
        """
        verbosity(GibbsInference_double self) -> bool

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(GibbsInference_double self) -> double

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(GibbsInference_double self) -> double

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(GibbsInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(GibbsInference_double self) -> double

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(GibbsInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_periodSize(self)


    def burnIn(self) -> "gum::Size":
        """
        burnIn(GibbsInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_burnIn(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(GibbsInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(GibbsInference_double self) -> double

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(GibbsInference_double self) -> std::string

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(GibbsInference_double self) -> Vector_double

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_history(self)


    def makeInference(self) -> "void":
        """
        makeInference(GibbsInference_double self)

        Parameters
        ----------
        self: gum::GibbsInference< double > *

        """
        return _pyAgrum.GibbsInference_double_makeInference(self)


    def posterior(self, *args) -> "gum::Potential< double > const":
        """
        posterior(GibbsInference_double self, gum::NodeId const var) -> Potential_double

        Parameters
        ----------
        var: gum::NodeId const

        posterior(GibbsInference_double self, std::string const nodeName) -> Potential_double

        Parameters
        ----------
        nodeName: std::string const

        """
        return _pyAgrum.GibbsInference_double_posterior(self, *args)


    def BayesNet(self) -> "gum::IBayesNet< double > const &":
        """
        BayesNet(GibbsInference_double self) -> IBayesNet_double

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_BayesNet(self)


    def addEvidence(self, *args) -> "void":
        """
        addEvidence(GibbsInference_double self, gum::NodeId const id, gum::Idx const val)

        Parameters
        ----------
        id: gum::NodeId const
        val: gum::Idx const

        addEvidence(GibbsInference_double self, std::string const & nodeName, gum::Idx const val)

        Parameters
        ----------
        nodeName: std::string const &
        val: gum::Idx const

        addEvidence(GibbsInference_double self, gum::NodeId const id, std::string const & val)

        Parameters
        ----------
        id: gum::NodeId const
        val: std::string const &

        addEvidence(GibbsInference_double self, std::string const & nodeName, std::string const & val)

        Parameters
        ----------
        nodeName: std::string const &
        val: std::string const &

        addEvidence(GibbsInference_double self, gum::NodeId const id, Vector_double vals)

        Parameters
        ----------
        id: gum::NodeId const
        vals: std::vector< double,std::allocator< double > > const &

        addEvidence(GibbsInference_double self, std::string const & nodeName, Vector_double vals)

        Parameters
        ----------
        nodeName: std::string const &
        vals: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.GibbsInference_double_addEvidence(self, *args)


    def chgEvidence(self, *args) -> "void":
        """
        chgEvidence(GibbsInference_double self, gum::NodeId const id, gum::Idx const val)

        Parameters
        ----------
        id: gum::NodeId const
        val: gum::Idx const

        chgEvidence(GibbsInference_double self, std::string const & nodeName, gum::Idx const val)

        Parameters
        ----------
        nodeName: std::string const &
        val: gum::Idx const

        chgEvidence(GibbsInference_double self, gum::NodeId const id, std::string const & val)

        Parameters
        ----------
        id: gum::NodeId const
        val: std::string const &

        chgEvidence(GibbsInference_double self, std::string const & nodeName, std::string const & val)

        Parameters
        ----------
        nodeName: std::string const &
        val: std::string const &

        chgEvidence(GibbsInference_double self, gum::NodeId const id, Vector_double vals)

        Parameters
        ----------
        id: gum::NodeId const
        vals: std::vector< double,std::allocator< double > > const &

        chgEvidence(GibbsInference_double self, std::string const & nodeName, Vector_double vals)

        Parameters
        ----------
        nodeName: std::string const &
        vals: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.GibbsInference_double_chgEvidence(self, *args)


    def hasEvidence(self, *args) -> "bool":
        """
        hasEvidence(GibbsInference_double self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        hasEvidence(GibbsInference_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.GibbsInference_double_hasEvidence(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(GibbsInference_double self)

        Parameters
        ----------
        self: gum::GibbsInference< double > *

        """
        return _pyAgrum.GibbsInference_double_eraseAllEvidence(self)


    def eraseEvidence(self, *args) -> "void":
        """
        eraseEvidence(GibbsInference_double self, gum::NodeId const id)

        Parameters
        ----------
        id: gum::NodeId const

        eraseEvidence(GibbsInference_double self, std::string const & nodeName)

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.GibbsInference_double_eraseEvidence(self, *args)


    def hasHardEvidence(self, nodeName: 'std::string const &') -> "bool":
        """
        hasHardEvidence(GibbsInference_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.GibbsInference_double_hasHardEvidence(self, nodeName)


    def hasSoftEvidence(self, *args) -> "bool":
        """
        hasSoftEvidence(GibbsInference_double self, gum::NodeId const id) -> bool

        Parameters
        ----------
        id: gum::NodeId const

        hasSoftEvidence(GibbsInference_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.GibbsInference_double_hasSoftEvidence(self, *args)


    def nbrEvidence(self) -> "gum::Size":
        """
        nbrEvidence(GibbsInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_nbrEvidence(self)


    def nbrHardEvidence(self) -> "gum::Size":
        """
        nbrHardEvidence(GibbsInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_nbrHardEvidence(self)


    def nbrSoftEvidence(self) -> "gum::Size":
        """
        nbrSoftEvidence(GibbsInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_nbrSoftEvidence(self)


    def eraseAllTargets(self) -> "void":
        """
        eraseAllTargets(GibbsInference_double self)

        Parameters
        ----------
        self: gum::GibbsInference< double > *

        """
        return _pyAgrum.GibbsInference_double_eraseAllTargets(self)


    def addAllTargets(self) -> "void":
        """
        addAllTargets(GibbsInference_double self)

        Parameters
        ----------
        self: gum::GibbsInference< double > *

        """
        return _pyAgrum.GibbsInference_double_addAllTargets(self)


    def addTarget(self, *args) -> "void":
        """
        addTarget(GibbsInference_double self, gum::NodeId const target)

        Parameters
        ----------
        target: gum::NodeId const

        addTarget(GibbsInference_double self, std::string const & nodeName)

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.GibbsInference_double_addTarget(self, *args)


    def eraseTarget(self, *args) -> "void":
        """
        eraseTarget(GibbsInference_double self, gum::NodeId const target)

        Parameters
        ----------
        target: gum::NodeId const

        eraseTarget(GibbsInference_double self, std::string const & nodeName)

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.GibbsInference_double_eraseTarget(self, *args)


    def isTarget(self, *args) -> "bool":
        """
        isTarget(GibbsInference_double self, gum::NodeId const variable) -> bool

        Parameters
        ----------
        variable: gum::NodeId const

        isTarget(GibbsInference_double self, std::string const & nodeName) -> bool

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.GibbsInference_double_isTarget(self, *args)


    def nbrTargets(self) -> "gum::Size":
        """
        nbrTargets(GibbsInference_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsInference< double > const *

        """
        return _pyAgrum.GibbsInference_double_nbrTargets(self)


    def H(self, *args) -> "double":
        """
        H(GibbsInference_double self, gum::NodeId const X) -> double

        Parameters
        ----------
        X: gum::NodeId const

        H(GibbsInference_double self, std::string const & nodeName) -> double

        Parameters
        ----------
        nodeName: std::string const &

        """
        return _pyAgrum.GibbsInference_double_H(self, *args)

GibbsInference_double_swigregister = _pyAgrum.GibbsInference_double_swigregister
GibbsInference_double_swigregister(GibbsInference_double)

class BruteForceKL_double(_object):
    """Proxy of C++ gum::BruteForceKL<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BruteForceKL_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BruteForceKL_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::BruteForceKL<(double)> self, IBayesNet_double P, IBayesNet_double Q) -> BruteForceKL_double

        Parameters
        ----------
        P: gum::IBayesNet< double > const &
        Q: gum::IBayesNet< double > const &

        __init__(gum::BruteForceKL<(double)> self, gum::KL< double > const & kl) -> BruteForceKL_double

        Parameters
        ----------
        kl: gum::KL< double > const &

        """
        this = _pyAgrum.new_BruteForceKL_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_BruteForceKL_double
    __del__ = lambda self: None

    def compute(self) -> "PyObject *":
        """
        compute(BruteForceKL_double self) -> PyObject *

        Parameters
        ----------
        self: gum::BruteForceKL< double > *

        """
        return _pyAgrum.BruteForceKL_double_compute(self)

BruteForceKL_double_swigregister = _pyAgrum.BruteForceKL_double_swigregister
BruteForceKL_double_swigregister(BruteForceKL_double)

class GibbsKL_double(_object):
    """Proxy of C++ gum::GibbsKL<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GibbsKL_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GibbsKL_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::GibbsKL<(double)> self, IBayesNet_double P, IBayesNet_double Q) -> GibbsKL_double

        Parameters
        ----------
        P: gum::IBayesNet< double > const &
        Q: gum::IBayesNet< double > const &

        __init__(gum::GibbsKL<(double)> self, gum::KL< double > const & kl) -> GibbsKL_double

        Parameters
        ----------
        kl: gum::KL< double > const &

        """
        this = _pyAgrum.new_GibbsKL_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_GibbsKL_double
    __del__ = lambda self: None

    def compute(self) -> "PyObject *":
        """
        compute(GibbsKL_double self) -> PyObject *

        Parameters
        ----------
        self: gum::GibbsKL< double > *

        """
        return _pyAgrum.GibbsKL_double_compute(self)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(GibbsKL_double self, bool v)

        Parameters
        ----------
        v: bool

        """
        return _pyAgrum.GibbsKL_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(GibbsKL_double self, double eps)

        Parameters
        ----------
        eps: double

        """
        return _pyAgrum.GibbsKL_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(GibbsKL_double self, double rate)

        Parameters
        ----------
        rate: double

        """
        return _pyAgrum.GibbsKL_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(GibbsKL_double self, gum::Size max)

        Parameters
        ----------
        max: gum::Size

        """
        return _pyAgrum.GibbsKL_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(GibbsKL_double self, double timeout)

        Parameters
        ----------
        timeout: double

        """
        return _pyAgrum.GibbsKL_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(GibbsKL_double self, gum::Size p)

        Parameters
        ----------
        p: gum::Size

        """
        return _pyAgrum.GibbsKL_double_setPeriodSize(self, p)


    def setBurnIn(self, b: 'gum::Size') -> "void":
        """
        setBurnIn(GibbsKL_double self, gum::Size b)

        Parameters
        ----------
        b: gum::Size

        """
        return _pyAgrum.GibbsKL_double_setBurnIn(self, b)


    def verbosity(self) -> "bool":
        """
        verbosity(GibbsKL_double self) -> bool

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(GibbsKL_double self) -> double

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(GibbsKL_double self) -> double

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(GibbsKL_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(GibbsKL_double self) -> double

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(GibbsKL_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_periodSize(self)


    def burnIn(self) -> "gum::Size":
        """
        burnIn(GibbsKL_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_burnIn(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(GibbsKL_double self) -> gum::Size

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(GibbsKL_double self) -> double

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(GibbsKL_double self) -> std::string

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(GibbsKL_double self) -> Vector_double

        Parameters
        ----------
        self: gum::GibbsKL< double > const *

        """
        return _pyAgrum.GibbsKL_double_history(self)

GibbsKL_double_swigregister = _pyAgrum.GibbsKL_double_swigregister
GibbsKL_double_swigregister(GibbsKL_double)

class CredalNet_double(_object):
    """Proxy of C++ gum::credal::CredalNet<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CredalNet_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CredalNet_double, name)
    __repr__ = _swig_repr
    NodeType_Precise = _pyAgrum.CredalNet_double_NodeType_Precise
    NodeType_Credal = _pyAgrum.CredalNet_double_NodeType_Credal
    NodeType_Vacuous = _pyAgrum.CredalNet_double_NodeType_Vacuous
    NodeType_Indic = _pyAgrum.CredalNet_double_NodeType_Indic

    def __init__(self, *args):
        """
        __init__(gum::credal::CredalNet<(double)> self) -> CredalNet_double
        __init__(gum::credal::CredalNet<(double)> self, std::string const & src_min_num, std::string const & src_max_den) -> CredalNet_double

        Parameters
        ----------
        src_min_num: std::string const &
        src_max_den: std::string const &

        __init__(gum::credal::CredalNet<(double)> self, std::string const & src_min_num) -> CredalNet_double

        Parameters
        ----------
        src_min_num: std::string const &

        __init__(gum::credal::CredalNet<(double)> self, BayesNet_double src_min_num, BayesNet_double src_max_den) -> CredalNet_double

        Parameters
        ----------
        src_min_num: gum::BayesNet< double > const &
        src_max_den: gum::BayesNet< double > const &

        __init__(gum::credal::CredalNet<(double)> self, BayesNet_double src_min_num) -> CredalNet_double

        Parameters
        ----------
        src_min_num: gum::BayesNet< double > const &

        """
        this = _pyAgrum.new_CredalNet_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CredalNet_double
    __del__ = lambda self: None

    def addNode(self, name: 'std::string const &', card: 'gum::Size const &') -> "gum::NodeId":
        """
        addNode(CredalNet_double self, std::string const & name, gum::Size const & card) -> gum::NodeId

        Parameters
        ----------
        name: std::string const &
        card: gum::Size const &

        """
        return _pyAgrum.CredalNet_double_addNode(self, name, card)


    def addArc(self, tail: 'gum::NodeId const &', head: 'gum::NodeId const &') -> "void":
        """
        addArc(CredalNet_double self, gum::NodeId const & tail, gum::NodeId const & head)

        Parameters
        ----------
        tail: gum::NodeId const &
        head: gum::NodeId const &

        """
        return _pyAgrum.CredalNet_double_addArc(self, tail, head)


    def setCPTs(self, id: 'gum::NodeId const &', cpt: 'std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > const &') -> "void":
        """
        setCPTs(CredalNet_double self, gum::NodeId const & id, std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > const & cpt)

        Parameters
        ----------
        id: gum::NodeId const &
        cpt: std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > const &

        """
        return _pyAgrum.CredalNet_double_setCPTs(self, id, cpt)


    def setCPT(self, *args) -> "void":
        """
        setCPT(CredalNet_double self, gum::NodeId const & id, gum::Size & entry, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & cpt)

        Parameters
        ----------
        id: gum::NodeId const &
        entry: gum::Size &
        cpt: std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &

        setCPT(CredalNet_double self, gum::NodeId const & id, Instantiation ins, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & cpt)

        Parameters
        ----------
        id: gum::NodeId const &
        ins: gum::Instantiation
        cpt: std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &

        """
        return _pyAgrum.CredalNet_double_setCPT(self, *args)


    def fillConstraints(self, id: 'gum::NodeId const &', lower: 'Vector_double', upper: 'Vector_double') -> "void":
        """
        fillConstraints(CredalNet_double self, gum::NodeId const & id, Vector_double lower, Vector_double upper)

        Parameters
        ----------
        id: gum::NodeId const &
        lower: std::vector< double,std::allocator< double > > const &
        upper: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.CredalNet_double_fillConstraints(self, id, lower, upper)


    def fillConstraint(self, *args) -> "void":
        """
        fillConstraint(CredalNet_double self, gum::NodeId const & id, gum::Idx const & entry, Vector_double lower, Vector_double upper)

        Parameters
        ----------
        id: gum::NodeId const &
        entry: gum::Idx const &
        lower: std::vector< double,std::allocator< double > > const &
        upper: std::vector< double,std::allocator< double > > const &

        fillConstraint(CredalNet_double self, gum::NodeId const & id, Instantiation ins, Vector_double lower, Vector_double upper)

        Parameters
        ----------
        id: gum::NodeId const &
        ins: gum::Instantiation
        lower: std::vector< double,std::allocator< double > > const &
        upper: std::vector< double,std::allocator< double > > const &

        """
        return _pyAgrum.CredalNet_double_fillConstraint(self, *args)


    def instantiation(self, id: 'gum::NodeId const &') -> "gum::Instantiation":
        """
        instantiation(CredalNet_double self, gum::NodeId const & id) -> Instantiation

        Parameters
        ----------
        id: gum::NodeId const &

        """
        return _pyAgrum.CredalNet_double_instantiation(self, id)


    def domainSize(self, id: 'gum::NodeId const &') -> "gum::Size":
        """
        domainSize(CredalNet_double self, gum::NodeId const & id) -> gum::Size

        Parameters
        ----------
        id: gum::NodeId const &

        """
        return _pyAgrum.CredalNet_double_domainSize(self, id)


    def bnToCredal(self, beta: 'double const', oneNet: 'bool const', keepZeroes: 'bool const'=False) -> "void":
        """
        bnToCredal(CredalNet_double self, double const beta, bool const oneNet, bool const keepZeroes=False)

        Parameters
        ----------
        beta: double const
        oneNet: bool const
        keepZeroes: bool const

        bnToCredal(CredalNet_double self, double const beta, bool const oneNet)

        Parameters
        ----------
        beta: double const
        oneNet: bool const

        """
        return _pyAgrum.CredalNet_double_bnToCredal(self, beta, oneNet, keepZeroes)


    def intervalToCredalWithFiles(self) -> "void":
        """
        intervalToCredalWithFiles(CredalNet_double self)

        Parameters
        ----------
        self: gum::credal::CredalNet< double > *

        """
        return _pyAgrum.CredalNet_double_intervalToCredalWithFiles(self)


    def intervalToCredal(self) -> "void":
        """
        intervalToCredal(CredalNet_double self)

        Parameters
        ----------
        self: gum::credal::CredalNet< double > *

        """
        return _pyAgrum.CredalNet_double_intervalToCredal(self)


    def lagrangeNormalization(self) -> "void":
        """
        lagrangeNormalization(CredalNet_double self)

        Parameters
        ----------
        self: gum::credal::CredalNet< double > *

        """
        return _pyAgrum.CredalNet_double_lagrangeNormalization(self)


    def idmLearning(self, s: 'gum::Idx const'=0, keepZeroes: 'bool const'=False) -> "void":
        """
        idmLearning(CredalNet_double self, gum::Idx const s=0, bool const keepZeroes=False)

        Parameters
        ----------
        s: gum::Idx const
        keepZeroes: bool const

        idmLearning(CredalNet_double self, gum::Idx const s=0)

        Parameters
        ----------
        s: gum::Idx const

        idmLearning(CredalNet_double self)

        Parameters
        ----------
        self: gum::credal::CredalNet< double > *

        """
        return _pyAgrum.CredalNet_double_idmLearning(self, s, keepZeroes)


    def approximatedBinarization(self) -> "void":
        """
        approximatedBinarization(CredalNet_double self)

        Parameters
        ----------
        self: gum::credal::CredalNet< double > *

        """
        return _pyAgrum.CredalNet_double_approximatedBinarization(self)


    def saveBNsMinMax(self, min_path: 'std::string const &', max_path: 'std::string const &') -> "void":
        """
        saveBNsMinMax(CredalNet_double self, std::string const & min_path, std::string const & max_path)

        Parameters
        ----------
        min_path: std::string const &
        max_path: std::string const &

        """
        return _pyAgrum.CredalNet_double_saveBNsMinMax(self, min_path, max_path)


    def __str__(self) -> "std::string":
        """
        __str__(CredalNet_double self) -> std::string

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double___str__(self)


    def computeCPTMinMax(self) -> "void":
        """
        computeCPTMinMax(CredalNet_double self)

        Parameters
        ----------
        self: gum::credal::CredalNet< double > *

        """
        return _pyAgrum.CredalNet_double_computeCPTMinMax(self)


    def src_bn(self) -> "gum::BayesNet< double > const &":
        """
        src_bn(CredalNet_double self) -> BayesNet_double

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_src_bn(self)


    def current_bn(self) -> "gum::BayesNet< double > const &":
        """
        current_bn(CredalNet_double self) -> BayesNet_double

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_current_bn(self)


    def credalNet_currentCpt(self) -> "NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &":
        """
        credalNet_currentCpt(CredalNet_double self) -> NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_credalNet_currentCpt(self)


    def credalNet_srcCpt(self) -> "NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &":
        """
        credalNet_srcCpt(CredalNet_double self) -> NodeProperty< std::vector< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > >,std::allocator< std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > > > > const &

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_credalNet_srcCpt(self)


    def currentNodeType(self, id: 'gum::NodeId const &') -> "gum::credal::CredalNet< double >::NodeType":
        """
        currentNodeType(CredalNet_double self, gum::NodeId const & id) -> gum::credal::CredalNet< double >::NodeType

        Parameters
        ----------
        id: gum::NodeId const &

        """
        return _pyAgrum.CredalNet_double_currentNodeType(self, id)


    def nodeType(self, id: 'gum::NodeId const &') -> "gum::credal::CredalNet< double >::NodeType":
        """
        nodeType(CredalNet_double self, gum::NodeId const & id) -> gum::credal::CredalNet< double >::NodeType

        Parameters
        ----------
        id: gum::NodeId const &

        """
        return _pyAgrum.CredalNet_double_nodeType(self, id)


    def epsilonMin(self) -> "double const &":
        """
        epsilonMin(CredalNet_double self) -> double const &

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_epsilonMin(self)


    def epsilonMax(self) -> "double const &":
        """
        epsilonMax(CredalNet_double self) -> double const &

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_epsilonMax(self)


    def epsilonMean(self) -> "double const &":
        """
        epsilonMean(CredalNet_double self) -> double const &

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_epsilonMean(self)


    def isSeparatelySpecified(self) -> "bool const":
        """
        isSeparatelySpecified(CredalNet_double self) -> bool const

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_isSeparatelySpecified(self)


    def hasComputedCPTMinMax(self) -> "bool const":
        """
        hasComputedCPTMinMax(CredalNet_double self) -> bool const

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_hasComputedCPTMinMax(self)


    def get_CPT_min(self) -> "std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &":
        """
        get_CPT_min(CredalNet_double self) -> std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_get_CPT_min(self)


    def get_CPT_max(self) -> "std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &":
        """
        get_CPT_max(CredalNet_double self) -> std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const &

        Parameters
        ----------
        self: gum::credal::CredalNet< double > const *

        """
        return _pyAgrum.CredalNet_double_get_CPT_max(self)

CredalNet_double_swigregister = _pyAgrum.CredalNet_double_swigregister
CredalNet_double_swigregister(CredalNet_double)

class CNMonteCarloSampling_double(_object):
    """Proxy of C++ gum::credal::CNMonteCarloSampling<(double,gum::LazyPropagation<(double)>)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CNMonteCarloSampling_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CNMonteCarloSampling_double, name)
    __repr__ = _swig_repr

    def __init__(self, credalNet: 'CredalNet_double'):
        """
        __init__(gum::credal::CNMonteCarloSampling<(double,gum::LazyPropagation<(double)>)> self, CredalNet_double credalNet) -> CNMonteCarloSampling_double

        Parameters
        ----------
        credalNet: gum::credal::CredalNet< double > const &

        """
        this = _pyAgrum.new_CNMonteCarloSampling_double(credalNet)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CNMonteCarloSampling_double
    __del__ = lambda self: None

    def makeInference(self) -> "void":
        """
        makeInference(CNMonteCarloSampling_double self)

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > *

        """
        return _pyAgrum.CNMonteCarloSampling_double_makeInference(self)


    def insertEvidenceFile(self, path: 'std::string const &') -> "void":
        """
        insertEvidenceFile(CNMonteCarloSampling_double self, std::string const & path)

        Parameters
        ----------
        path: std::string const &

        """
        return _pyAgrum.CNMonteCarloSampling_double_insertEvidenceFile(self, path)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(CNMonteCarloSampling_double self, bool v)

        Parameters
        ----------
        v: bool

        """
        return _pyAgrum.CNMonteCarloSampling_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(CNMonteCarloSampling_double self, double eps)

        Parameters
        ----------
        eps: double

        """
        return _pyAgrum.CNMonteCarloSampling_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(CNMonteCarloSampling_double self, double rate)

        Parameters
        ----------
        rate: double

        """
        return _pyAgrum.CNMonteCarloSampling_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(CNMonteCarloSampling_double self, gum::Size max)

        Parameters
        ----------
        max: gum::Size

        """
        return _pyAgrum.CNMonteCarloSampling_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(CNMonteCarloSampling_double self, double timeout)

        Parameters
        ----------
        timeout: double

        """
        return _pyAgrum.CNMonteCarloSampling_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(CNMonteCarloSampling_double self, gum::Size p)

        Parameters
        ----------
        p: gum::Size

        """
        return _pyAgrum.CNMonteCarloSampling_double_setPeriodSize(self, p)


    def setBurnIn(self, b: 'gum::Size') -> "void":
        """
        setBurnIn(CNMonteCarloSampling_double self, gum::Size b)

        Parameters
        ----------
        b: gum::Size

        """
        return _pyAgrum.CNMonteCarloSampling_double_setBurnIn(self, b)


    def verbosity(self) -> "bool":
        """
        verbosity(CNMonteCarloSampling_double self) -> bool

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(CNMonteCarloSampling_double self) -> double

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(CNMonteCarloSampling_double self) -> double

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(CNMonteCarloSampling_double self) -> gum::Size

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(CNMonteCarloSampling_double self) -> double

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(CNMonteCarloSampling_double self) -> gum::Size

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_periodSize(self)


    def burnIn(self) -> "gum::Size":
        """
        burnIn(CNMonteCarloSampling_double self) -> gum::Size

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_burnIn(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(CNMonteCarloSampling_double self) -> gum::Size

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(CNMonteCarloSampling_double self) -> double

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(CNMonteCarloSampling_double self) -> std::string

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(CNMonteCarloSampling_double self) -> Vector_double

        Parameters
        ----------
        self: gum::credal::CNMonteCarloSampling< double,gum::LazyPropagation< double > > const *

        """
        return _pyAgrum.CNMonteCarloSampling_double_history(self)


    def setRepetitiveInd(self, flag: 'bool const') -> "void":
        """
        setRepetitiveInd(CNMonteCarloSampling_double self, bool const flag)

        Parameters
        ----------
        flag: bool const

        """
        return _pyAgrum.CNMonteCarloSampling_double_setRepetitiveInd(self, flag)


    def marginalMax(self, *args) -> "std::vector< double,std::allocator< double > > const &":
        """
        marginalMax(CNMonteCarloSampling_double self, gum::NodeId const id) -> Vector_double

        Parameters
        ----------
        id: gum::NodeId const

        marginalMax(CNMonteCarloSampling_double self, std::string const name) -> Vector_double

        Parameters
        ----------
        name: std::string const

        """
        return _pyAgrum.CNMonteCarloSampling_double_marginalMax(self, *args)


    def marginalMin(self, *args) -> "std::vector< double,std::allocator< double > > const &":
        """
        marginalMin(CNMonteCarloSampling_double self, gum::NodeId const id) -> Vector_double

        Parameters
        ----------
        id: gum::NodeId const

        marginalMin(CNMonteCarloSampling_double self, std::string const name) -> Vector_double

        Parameters
        ----------
        name: std::string const

        """
        return _pyAgrum.CNMonteCarloSampling_double_marginalMin(self, *args)


    def insertModalsFile(self, path: 'std::string const &') -> "void":
        """
        insertModalsFile(CNMonteCarloSampling_double self, std::string const & path)

        Parameters
        ----------
        path: std::string const &

        """
        return _pyAgrum.CNMonteCarloSampling_double_insertModalsFile(self, path)


    def dynamicExpMax(self, varName: 'std::string const &') -> "std::vector< double,std::allocator< double > > const &":
        """
        dynamicExpMax(CNMonteCarloSampling_double self, std::string const & varName) -> Vector_double

        Parameters
        ----------
        varName: std::string const &

        """
        return _pyAgrum.CNMonteCarloSampling_double_dynamicExpMax(self, varName)


    def dynamicExpMin(self, varName: 'std::string const &') -> "std::vector< double,std::allocator< double > > const &":
        """
        dynamicExpMin(CNMonteCarloSampling_double self, std::string const & varName) -> Vector_double

        Parameters
        ----------
        varName: std::string const &

        """
        return _pyAgrum.CNMonteCarloSampling_double_dynamicExpMin(self, varName)

CNMonteCarloSampling_double_swigregister = _pyAgrum.CNMonteCarloSampling_double_swigregister
CNMonteCarloSampling_double_swigregister(CNMonteCarloSampling_double)

class CNLoopyPropagation_double(_object):
    """Proxy of C++ gum::credal::CNLoopyPropagation<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CNLoopyPropagation_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CNLoopyPropagation_double, name)
    __repr__ = _swig_repr
    InferenceType_nodeToNeighbours = _pyAgrum.CNLoopyPropagation_double_InferenceType_nodeToNeighbours
    InferenceType_ordered = _pyAgrum.CNLoopyPropagation_double_InferenceType_ordered
    InferenceType_randomOrder = _pyAgrum.CNLoopyPropagation_double_InferenceType_randomOrder

    def makeInference(self) -> "void":
        """
        makeInference(CNLoopyPropagation_double self)

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > *

        """
        return _pyAgrum.CNLoopyPropagation_double_makeInference(self)


    def inferenceType(self, *args) -> "gum::credal::CNLoopyPropagation< double >::InferenceType":
        """
        inferenceType(CNLoopyPropagation_double self, gum::credal::CNLoopyPropagation< double >::InferenceType inft)

        Parameters
        ----------
        inft: enum gum::credal::CNLoopyPropagation< double >::InferenceType

        inferenceType(CNLoopyPropagation_double self) -> gum::credal::CNLoopyPropagation< double >::InferenceType

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > *

        """
        return _pyAgrum.CNLoopyPropagation_double_inferenceType(self, *args)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(CNLoopyPropagation_double self)

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > *

        """
        return _pyAgrum.CNLoopyPropagation_double_eraseAllEvidence(self)


    def saveInference(self, path: 'std::string const &') -> "void":
        """
        saveInference(CNLoopyPropagation_double self, std::string const & path)

        Parameters
        ----------
        path: std::string const &

        """
        return _pyAgrum.CNLoopyPropagation_double_saveInference(self, path)


    def __init__(self, cnet: 'CredalNet_double'):
        """
        __init__(gum::credal::CNLoopyPropagation<(double)> self, CredalNet_double cnet) -> CNLoopyPropagation_double

        Parameters
        ----------
        cnet: gum::credal::CredalNet< double > const &

        """
        this = _pyAgrum.new_CNLoopyPropagation_double(cnet)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_CNLoopyPropagation_double
    __del__ = lambda self: None

    def insertEvidenceFile(self, path: 'std::string const &') -> "void":
        """
        insertEvidenceFile(CNLoopyPropagation_double self, std::string const & path)

        Parameters
        ----------
        path: std::string const &

        """
        return _pyAgrum.CNLoopyPropagation_double_insertEvidenceFile(self, path)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(CNLoopyPropagation_double self, bool v)

        Parameters
        ----------
        v: bool

        """
        return _pyAgrum.CNLoopyPropagation_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(CNLoopyPropagation_double self, double eps)

        Parameters
        ----------
        eps: double

        """
        return _pyAgrum.CNLoopyPropagation_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(CNLoopyPropagation_double self, double rate)

        Parameters
        ----------
        rate: double

        """
        return _pyAgrum.CNLoopyPropagation_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(CNLoopyPropagation_double self, gum::Size max)

        Parameters
        ----------
        max: gum::Size

        """
        return _pyAgrum.CNLoopyPropagation_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(CNLoopyPropagation_double self, double timeout)

        Parameters
        ----------
        timeout: double

        """
        return _pyAgrum.CNLoopyPropagation_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(CNLoopyPropagation_double self, gum::Size p)

        Parameters
        ----------
        p: gum::Size

        """
        return _pyAgrum.CNLoopyPropagation_double_setPeriodSize(self, p)


    def setBurnIn(self, b: 'gum::Size') -> "void":
        """
        setBurnIn(CNLoopyPropagation_double self, gum::Size b)

        Parameters
        ----------
        b: gum::Size

        """
        return _pyAgrum.CNLoopyPropagation_double_setBurnIn(self, b)


    def verbosity(self) -> "bool":
        """
        verbosity(CNLoopyPropagation_double self) -> bool

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(CNLoopyPropagation_double self) -> double

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(CNLoopyPropagation_double self) -> double

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(CNLoopyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_maxIter(self)


    def maxTime(self) -> "double":
        """
        maxTime(CNLoopyPropagation_double self) -> double

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(CNLoopyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_periodSize(self)


    def burnIn(self) -> "gum::Size":
        """
        burnIn(CNLoopyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_burnIn(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(CNLoopyPropagation_double self) -> gum::Size

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """
        currentTime(CNLoopyPropagation_double self) -> double

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(CNLoopyPropagation_double self) -> std::string

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(CNLoopyPropagation_double self) -> Vector_double

        Parameters
        ----------
        self: gum::credal::CNLoopyPropagation< double > const *

        """
        return _pyAgrum.CNLoopyPropagation_double_history(self)


    def setRepetitiveInd(self, flag: 'bool const') -> "void":
        """
        setRepetitiveInd(CNLoopyPropagation_double self, bool const flag)

        Parameters
        ----------
        flag: bool const

        """
        return _pyAgrum.CNLoopyPropagation_double_setRepetitiveInd(self, flag)


    def marginalMax(self, *args) -> "std::vector< double,std::allocator< double > > const &":
        """
        marginalMax(CNLoopyPropagation_double self, gum::NodeId const id) -> Vector_double

        Parameters
        ----------
        id: gum::NodeId const

        marginalMax(CNLoopyPropagation_double self, std::string const name) -> Vector_double

        Parameters
        ----------
        name: std::string const

        """
        return _pyAgrum.CNLoopyPropagation_double_marginalMax(self, *args)


    def marginalMin(self, *args) -> "std::vector< double,std::allocator< double > > const &":
        """
        marginalMin(CNLoopyPropagation_double self, gum::NodeId const id) -> Vector_double

        Parameters
        ----------
        id: gum::NodeId const

        marginalMin(CNLoopyPropagation_double self, std::string const name) -> Vector_double

        Parameters
        ----------
        name: std::string const

        """
        return _pyAgrum.CNLoopyPropagation_double_marginalMin(self, *args)


    def insertModalsFile(self, path: 'std::string const &') -> "void":
        """
        insertModalsFile(CNLoopyPropagation_double self, std::string const & path)

        Parameters
        ----------
        path: std::string const &

        """
        return _pyAgrum.CNLoopyPropagation_double_insertModalsFile(self, path)


    def dynamicExpMax(self, varName: 'std::string const &') -> "std::vector< double,std::allocator< double > > const &":
        """
        dynamicExpMax(CNLoopyPropagation_double self, std::string const & varName) -> Vector_double

        Parameters
        ----------
        varName: std::string const &

        """
        return _pyAgrum.CNLoopyPropagation_double_dynamicExpMax(self, varName)


    def dynamicExpMin(self, varName: 'std::string const &') -> "std::vector< double,std::allocator< double > > const &":
        """
        dynamicExpMin(CNLoopyPropagation_double self, std::string const & varName) -> Vector_double

        Parameters
        ----------
        varName: std::string const &

        """
        return _pyAgrum.CNLoopyPropagation_double_dynamicExpMin(self, varName)

CNLoopyPropagation_double_swigregister = _pyAgrum.CNLoopyPropagation_double_swigregister
CNLoopyPropagation_double_swigregister(CNLoopyPropagation_double)

class InfluenceDiagram_double(DAGmodel):
    """Proxy of C++ gum::InfluenceDiagram<(double)> class."""

    __swig_setmethods__ = {}
    for _s in [DAGmodel]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InfluenceDiagram_double, name, value)
    __swig_getmethods__ = {}
    for _s in [DAGmodel]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InfluenceDiagram_double, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pyAgrum.delete_InfluenceDiagram_double
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(gum::InfluenceDiagram<(double)> self) -> InfluenceDiagram_double
        __init__(gum::InfluenceDiagram<(double)> self, InfluenceDiagram_double source) -> InfluenceDiagram_double

        Parameters
        ----------
        source: gum::InfluenceDiagram< double > const &

        """
        this = _pyAgrum.new_InfluenceDiagram_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def toDot(self) -> "std::string":
        """
        toDot(InfluenceDiagram_double self) -> std::string

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double_toDot(self)


    def __str__(self) -> "std::string":
        """
        __str__(InfluenceDiagram_double self) -> std::string

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double___str__(self)


    def cpt(self, varId: 'gum::NodeId') -> "gum::Potential< double > const &":
        """
        cpt(InfluenceDiagram_double self, gum::NodeId varId) -> Potential_double

        Parameters
        ----------
        varId: gum::NodeId

        """
        val = _pyAgrum.InfluenceDiagram_double_cpt(self, varId)

        val.__fill_distrib__()


        return val


    def utility(self, varId: 'gum::NodeId') -> "gum::UtilityTable< double > const &":
        """
        utility(InfluenceDiagram_double self, gum::NodeId varId) -> UtilityTable_double

        Parameters
        ----------
        varId: gum::NodeId

        """
        val = _pyAgrum.InfluenceDiagram_double_utility(self, varId)

        val.__fill_distrib__()


        return val


    def isUtilityNode(self, varId: 'gum::NodeId') -> "bool":
        """
        isUtilityNode(InfluenceDiagram_double self, gum::NodeId varId) -> bool

        Parameters
        ----------
        varId: gum::NodeId

        """
        return _pyAgrum.InfluenceDiagram_double_isUtilityNode(self, varId)


    def isDecisionNode(self, varId: 'gum::NodeId') -> "bool":
        """
        isDecisionNode(InfluenceDiagram_double self, gum::NodeId varId) -> bool

        Parameters
        ----------
        varId: gum::NodeId

        """
        return _pyAgrum.InfluenceDiagram_double_isDecisionNode(self, varId)


    def isChanceNode(self, varId: 'gum::NodeId') -> "bool":
        """
        isChanceNode(InfluenceDiagram_double self, gum::NodeId varId) -> bool

        Parameters
        ----------
        varId: gum::NodeId

        """
        return _pyAgrum.InfluenceDiagram_double_isChanceNode(self, varId)


    def utilityNodeSize(self) -> "gum::Size":
        """
        utilityNodeSize(InfluenceDiagram_double self) -> gum::Size

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double_utilityNodeSize(self)


    def chanceNodeSize(self) -> "gum::Size":
        """
        chanceNodeSize(InfluenceDiagram_double self) -> gum::Size

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double_chanceNodeSize(self)


    def decisionNodeSize(self) -> "gum::Size":
        """
        decisionNodeSize(InfluenceDiagram_double self) -> gum::Size

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double_decisionNodeSize(self)


    def variable(self, id: 'gum::NodeId') -> "gum::DiscreteVariable const &":
        """
        variable(InfluenceDiagram_double self, gum::NodeId id) -> DiscreteVariable

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.InfluenceDiagram_double_variable(self, id)


    def nodeId(self, var: 'DiscreteVariable') -> "gum::NodeId":
        """
        nodeId(InfluenceDiagram_double self, DiscreteVariable var) -> gum::NodeId

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        return _pyAgrum.InfluenceDiagram_double_nodeId(self, var)


    def idFromName(self, name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(InfluenceDiagram_double self, std::string const & name) -> gum::NodeId

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.InfluenceDiagram_double_idFromName(self, name)


    def variableFromName(self, name: 'std::string const &') -> "gum::DiscreteVariable const &":
        """
        variableFromName(InfluenceDiagram_double self, std::string const & name) -> DiscreteVariable

        Parameters
        ----------
        name: std::string const &

        """
        return _pyAgrum.InfluenceDiagram_double_variableFromName(self, name)


    def add(self, variable: 'DiscreteVariable', id: 'gum::NodeId'=0) -> "gum::NodeId":
        """
        add(InfluenceDiagram_double self, DiscreteVariable variable, gum::NodeId id=0) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        id: gum::NodeId

        add(InfluenceDiagram_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.InfluenceDiagram_double_add(self, variable, id)


    def addDecisionNode(self, variable: 'DiscreteVariable', id: 'gum::NodeId'=0) -> "gum::NodeId":
        """
        addDecisionNode(InfluenceDiagram_double self, DiscreteVariable variable, gum::NodeId id=0) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        id: gum::NodeId

        addDecisionNode(InfluenceDiagram_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        """
        return _pyAgrum.InfluenceDiagram_double_addDecisionNode(self, variable, id)


    def addChanceNode(self, *args) -> "gum::NodeId":
        """
        addChanceNode(InfluenceDiagram_double self, DiscreteVariable variable, gum::NodeId id=0) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        id: gum::NodeId

        addChanceNode(InfluenceDiagram_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        addChanceNode(InfluenceDiagram_double self, DiscreteVariable variable, gum::MultiDimImplementation< double > * aContent, gum::NodeId id=0) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        aContent: gum::MultiDimImplementation< double > *
        id: gum::NodeId

        addChanceNode(InfluenceDiagram_double self, DiscreteVariable variable, gum::MultiDimImplementation< double > * aContent) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        aContent: gum::MultiDimImplementation< double > *

        """
        return _pyAgrum.InfluenceDiagram_double_addChanceNode(self, *args)


    def addUtilityNode(self, *args) -> "gum::NodeId":
        """
        addUtilityNode(InfluenceDiagram_double self, DiscreteVariable variable, gum::NodeId id=0) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        id: gum::NodeId

        addUtilityNode(InfluenceDiagram_double self, DiscreteVariable variable) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &

        addUtilityNode(InfluenceDiagram_double self, DiscreteVariable variable, gum::MultiDimImplementation< double > * aContent, gum::NodeId id=0) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        aContent: gum::MultiDimImplementation< double > *
        id: gum::NodeId

        addUtilityNode(InfluenceDiagram_double self, DiscreteVariable variable, gum::MultiDimImplementation< double > * aContent) -> gum::NodeId

        Parameters
        ----------
        variable: gum::DiscreteVariable const &
        aContent: gum::MultiDimImplementation< double > *

        """
        return _pyAgrum.InfluenceDiagram_double_addUtilityNode(self, *args)


    def erase(self, *args) -> "void":
        """
        erase(InfluenceDiagram_double self, gum::NodeId id)

        Parameters
        ----------
        id: gum::NodeId

        erase(InfluenceDiagram_double self, DiscreteVariable var)

        Parameters
        ----------
        var: gum::DiscreteVariable const &

        """
        return _pyAgrum.InfluenceDiagram_double_erase(self, *args)


    def changeVariableName(self, id: 'gum::NodeId', new_name: 'std::string const &') -> "void":
        """
        changeVariableName(InfluenceDiagram_double self, gum::NodeId id, std::string const & new_name)

        Parameters
        ----------
        id: gum::NodeId
        new_name: std::string const &

        """
        return _pyAgrum.InfluenceDiagram_double_changeVariableName(self, id, new_name)


    def addArc(self, tail: 'gum::NodeId', head: 'gum::NodeId') -> "void":
        """
        addArc(InfluenceDiagram_double self, gum::NodeId tail, gum::NodeId head)

        Parameters
        ----------
        tail: gum::NodeId
        head: gum::NodeId

        """
        return _pyAgrum.InfluenceDiagram_double_addArc(self, tail, head)


    def eraseArc(self, *args) -> "void":
        """
        eraseArc(InfluenceDiagram_double self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        eraseArc(InfluenceDiagram_double self, gum::NodeId tail, gum::NodeId head)

        Parameters
        ----------
        tail: gum::NodeId
        head: gum::NodeId

        """
        return _pyAgrum.InfluenceDiagram_double_eraseArc(self, *args)


    def decisionOrderExists(self) -> "bool":
        """
        decisionOrderExists(InfluenceDiagram_double self) -> bool

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double_decisionOrderExists(self)


    def getDecisionGraph(self) -> "gum::DAG *":
        """
        getDecisionGraph(InfluenceDiagram_double self) -> DAG

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double_getDecisionGraph(self)


    def getDecisionOrder(self) -> "std::vector< gum::NodeId,std::allocator< gum::NodeId > > *":
        """
        getDecisionOrder(InfluenceDiagram_double self) -> std::vector< gum::NodeId,std::allocator< gum::NodeId > > *

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double_getDecisionOrder(self)


    def existsPathBetween(self, src: 'gum::NodeId', dest: 'gum::NodeId') -> "bool":
        """
        existsPathBetween(InfluenceDiagram_double self, gum::NodeId src, gum::NodeId dest) -> bool

        Parameters
        ----------
        src: gum::NodeId
        dest: gum::NodeId

        """
        return _pyAgrum.InfluenceDiagram_double_existsPathBetween(self, src, dest)


    def names(self) -> "PyObject *":
        """
        names(InfluenceDiagram_double self) -> PyObject *

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > const *

        """
        return _pyAgrum.InfluenceDiagram_double_names(self)


    def ids(self) -> "PyObject *":
        """
        ids(InfluenceDiagram_double self) -> PyObject *

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > *

        """
        return _pyAgrum.InfluenceDiagram_double_ids(self)


    def arcs(self) -> "PyObject *":
        """
        arcs(InfluenceDiagram_double self) -> PyObject *

        Parameters
        ----------
        self: gum::InfluenceDiagram< double > *

        """
        return _pyAgrum.InfluenceDiagram_double_arcs(self)


    def parents(self, id: 'gum::NodeId const') -> "PyObject *":
        """
        parents(InfluenceDiagram_double self, gum::NodeId const id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.InfluenceDiagram_double_parents(self, id)


    def children(self, id: 'gum::NodeId const') -> "PyObject *":
        """
        children(InfluenceDiagram_double self, gum::NodeId const id) -> PyObject *

        Parameters
        ----------
        id: gum::NodeId const

        """
        return _pyAgrum.InfluenceDiagram_double_children(self, id)


    def loadBIFXML(self, *args) -> "bool":
        """
        loadBIFXML(InfluenceDiagram_double self, std::string name, PyObject * l) -> bool

        Parameters
        ----------
        name: std::string
        l: PyObject *

        loadBIFXML(InfluenceDiagram_double self, std::string name) -> bool

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.InfluenceDiagram_double_loadBIFXML(self, *args)


    def saveBIFXML(self, name: 'std::string') -> "void":
        """
        saveBIFXML(InfluenceDiagram_double self, std::string name)

        Parameters
        ----------
        name: std::string

        """
        return _pyAgrum.InfluenceDiagram_double_saveBIFXML(self, name)

InfluenceDiagram_double_swigregister = _pyAgrum.InfluenceDiagram_double_swigregister
InfluenceDiagram_double_swigregister(InfluenceDiagram_double)

class InfluenceDiagramInference_double(_object):
    """Proxy of C++ gum::InfluenceDiagramInference<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, InfluenceDiagramInference_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, InfluenceDiagramInference_double, name)
    __repr__ = _swig_repr

    def __init__(self, infDiag: 'InfluenceDiagram_double'):
        """
        __init__(gum::InfluenceDiagramInference<(double)> self, InfluenceDiagram_double infDiag) -> InfluenceDiagramInference_double

        Parameters
        ----------
        infDiag: gum::InfluenceDiagram< double > const &

        """
        this = _pyAgrum.new_InfluenceDiagramInference_double(infDiag)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_InfluenceDiagramInference_double
    __del__ = lambda self: None

    def makeInference(self) -> "void":
        """
        makeInference(InfluenceDiagramInference_double self)

        Parameters
        ----------
        self: gum::InfluenceDiagramInference< double > *

        """
        return _pyAgrum.InfluenceDiagramInference_double_makeInference(self)


    def getMEU(self) -> "double":
        """
        getMEU(InfluenceDiagramInference_double self) -> double

        Parameters
        ----------
        self: gum::InfluenceDiagramInference< double > *

        """
        return _pyAgrum.InfluenceDiagramInference_double_getMEU(self)


    def getBestDecisionChoice(self, decisionId: 'gum::NodeId') -> "gum::Idx":
        """
        getBestDecisionChoice(InfluenceDiagramInference_double self, gum::NodeId decisionId) -> gum::Idx

        Parameters
        ----------
        decisionId: gum::NodeId

        """
        return _pyAgrum.InfluenceDiagramInference_double_getBestDecisionChoice(self, decisionId)


    def displayResult(self) -> "std::string":
        """
        displayResult(InfluenceDiagramInference_double self) -> std::string

        Parameters
        ----------
        self: gum::InfluenceDiagramInference< double > *

        """
        return _pyAgrum.InfluenceDiagramInference_double_displayResult(self)


    def insertEvidence(self, evidenceList: 'gum::List< gum::Potential< double > const * > const &') -> "void":
        """
        insertEvidence(InfluenceDiagramInference_double self, gum::List< gum::Potential< double > const * > const & evidenceList)

        Parameters
        ----------
        evidenceList: gum::List< gum::Potential< double > const * > const &

        """
        return _pyAgrum.InfluenceDiagramInference_double_insertEvidence(self, evidenceList)


    def eraseEvidence(self, evidence: 'Potential_double') -> "void":
        """
        eraseEvidence(InfluenceDiagramInference_double self, Potential_double evidence)

        Parameters
        ----------
        evidence: gum::Potential< double > const *

        """
        return _pyAgrum.InfluenceDiagramInference_double_eraseEvidence(self, evidence)


    def eraseAllEvidence(self) -> "void":
        """
        eraseAllEvidence(InfluenceDiagramInference_double self)

        Parameters
        ----------
        self: gum::InfluenceDiagramInference< double > *

        """
        return _pyAgrum.InfluenceDiagramInference_double_eraseAllEvidence(self)


    def displayStrongJunctionTree(self, *args) -> "void":
        """
        displayStrongJunctionTree(InfluenceDiagramInference_double self, std::ostream & stream)

        Parameters
        ----------
        stream: std::ostream &

        """
        return _pyAgrum.InfluenceDiagramInference_double_displayStrongJunctionTree(self, *args)


    def influenceDiagram(self) -> "gum::InfluenceDiagram< double > const &":
        """
        influenceDiagram(InfluenceDiagramInference_double self) -> InfluenceDiagram_double

        Parameters
        ----------
        self: gum::InfluenceDiagramInference< double > const *

        """
        return _pyAgrum.InfluenceDiagramInference_double_influenceDiagram(self)


    def setEvidence(self, evidces):
        if not isinstance(evidces, dict):
            raise TypeError("setEvidence parameter must be dict, not %s"%(type(evidces)))
        bn = self.influenceDiagram()

    # set evidences
        self.list_pot = []

        try:
          items=evidces.iteritems()
        except AttributeError:
          items=evidces.items()

        for var_name, evidce in items:
            pot = Potential_double()

            if isinstance(var_name, int):
                var = bn.variable(var_name)
            elif isinstance(var_name, str):
                var = bn.variableFromName(var_name)
            else:
                raise TypeError('values of the dict must be int or string')

            pot.add(var)
            if isinstance(evidce, (int, float, str)):
                pot[:] = 0
    # determine the var type
                try:
                    cast_var = var.toLabelizedVar()
                    if isinstance(evidce, int):
                        index = evidce
                    elif isinstance(evidce, str):
                        index = cast_var[evidce]
                    else:
                        raise TypeError('values of the dict must be int or string')
                except RuntimeError:
                    try:
                        cast_var = var.toRangeVar()
                        if isinstance(evidce, int):
                            index = cast_var[str(evidce)]
                        elif isinstance(evidce, str):
                            index = cast_var[evidce]
                        else:
                            raise TypeError('values of the dict must be int or string')
                    except RuntimeError:
                        cast_var = var.toDiscretizedVar()
                        if isinstance(evidce, float):
                            index = cast_var.index(evidce)
                        elif isinstance(evidce, str):
                            index = cast_var.index(float(evidce))
                        else:
                            raise TypeError('values of the dict must be float or string')
                pot[index] = 1
            elif isinstance(evidce, (list, tuple)):
                pot[:] = evidce
            else:
                raise TypeError('dict values must be number, string or sequence')
            self.list_pot.append(pot)

        self.eraseAllEvidence()
        self._setEvidence(self.list_pot)



    def _setEvidence(self, evidences: 'PyObject *') -> "void":
        """
        _setEvidence(InfluenceDiagramInference_double self, PyObject * evidences)

        Parameters
        ----------
        evidences: PyObject *

        """
        return _pyAgrum.InfluenceDiagramInference_double__setEvidence(self, evidences)


    def junctionTreeToDot(self) -> "std::string const":
        """
        junctionTreeToDot(InfluenceDiagramInference_double self) -> std::string const

        Parameters
        ----------
        self: gum::InfluenceDiagramInference< double > *

        """
        return _pyAgrum.InfluenceDiagramInference_double_junctionTreeToDot(self)

InfluenceDiagramInference_double_swigregister = _pyAgrum.InfluenceDiagramInference_double_swigregister
InfluenceDiagramInference_double_swigregister(InfluenceDiagramInference_double)

class BNLearner_double(_object):
    """Proxy of C++ gum::learning::BNLearner<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BNLearner_double, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BNLearner_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(gum::learning::BNLearner<(double)> self, std::string const & filename) -> BNLearner_double

        Parameters
        ----------
        filename: std::string const &

        __init__(gum::learning::BNLearner<(double)> self, DatabaseVectInRAM db) -> BNLearner_double

        Parameters
        ----------
        db: gum::learning::DatabaseVectInRAM const &

        __init__(gum::learning::BNLearner<(double)> self, std::string const & filename, NodeProperty< gum::Sequence< std::string > > const & modalities, bool parse_database=False) -> BNLearner_double

        Parameters
        ----------
        filename: std::string const &
        modalities: NodeProperty< gum::Sequence< std::string > > const &
        parse_database: bool

        __init__(gum::learning::BNLearner<(double)> self, std::string const & filename, NodeProperty< gum::Sequence< std::string > > const & modalities) -> BNLearner_double

        Parameters
        ----------
        filename: std::string const &
        modalities: NodeProperty< gum::Sequence< std::string > > const &

        __init__(gum::learning::BNLearner<(double)> self, std::string const & filename, BayesNet_double src, bool parse_database=False) -> BNLearner_double

        Parameters
        ----------
        filename: std::string const &
        src: gum::BayesNet< double > const &
        parse_database: bool

        __init__(gum::learning::BNLearner<(double)> self, std::string const & filename, BayesNet_double src) -> BNLearner_double

        Parameters
        ----------
        filename: std::string const &
        src: gum::BayesNet< double > const &

        __init__(gum::learning::BNLearner<(double)> self, BNLearner_double arg2) -> BNLearner_double

        Parameters
        ----------
        arg2: gum::learning::BNLearner< double > const &

        __init__(gum::learning::BNLearner<(double)> self, BNLearner_double arg2) -> BNLearner_double

        Parameters
        ----------
        arg2: gum::learning::BNLearner< double > &&

        """
        this = _pyAgrum.new_BNLearner_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _pyAgrum.delete_BNLearner_double
    __del__ = lambda self: None

    def learnBN(self) -> "gum::BayesNet< double >":
        """
        learnBN(BNLearner_double self) -> BayesNet_double

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_learnBN(self)


    def learnParameters(self, *args) -> "gum::BayesNet< double >":
        """
        learnParameters(BNLearner_double self, DAG dag, bool take_into_account_score=True) -> BayesNet_double

        Parameters
        ----------
        dag: gum::DAG const &
        take_into_account_score: bool

        learnParameters(BNLearner_double self, DAG dag) -> BayesNet_double

        Parameters
        ----------
        dag: gum::DAG const &

        learnParameters(BNLearner_double self, BayesNet_double bn, bool take_into_account_score=True) -> BayesNet_double

        Parameters
        ----------
        bn: gum::BayesNet< double > const &
        take_into_account_score: bool

        learnParameters(BNLearner_double self, BayesNet_double bn) -> BayesNet_double

        Parameters
        ----------
        bn: gum::BayesNet< double > const &

        """
        return _pyAgrum.BNLearner_double_learnParameters(self, *args)


    def setVerbosity(self, v: 'bool') -> "void":
        """
        setVerbosity(BNLearner_double self, bool v)

        Parameters
        ----------
        v: bool

        """
        return _pyAgrum.BNLearner_double_setVerbosity(self, v)


    def setEpsilon(self, eps: 'double') -> "void":
        """
        setEpsilon(BNLearner_double self, double eps)

        Parameters
        ----------
        eps: double

        """
        return _pyAgrum.BNLearner_double_setEpsilon(self, eps)


    def setMinEpsilonRate(self, rate: 'double') -> "void":
        """
        setMinEpsilonRate(BNLearner_double self, double rate)

        Parameters
        ----------
        rate: double

        """
        return _pyAgrum.BNLearner_double_setMinEpsilonRate(self, rate)


    def setMaxIter(self, max: 'gum::Size') -> "void":
        """
        setMaxIter(BNLearner_double self, gum::Size max)

        Parameters
        ----------
        max: gum::Size

        """
        return _pyAgrum.BNLearner_double_setMaxIter(self, max)


    def setMaxTime(self, timeout: 'double') -> "void":
        """
        setMaxTime(BNLearner_double self, double timeout)

        Parameters
        ----------
        timeout: double

        """
        return _pyAgrum.BNLearner_double_setMaxTime(self, timeout)


    def setPeriodSize(self, p: 'gum::Size') -> "void":
        """
        setPeriodSize(BNLearner_double self, gum::Size p)

        Parameters
        ----------
        p: gum::Size

        """
        return _pyAgrum.BNLearner_double_setPeriodSize(self, p)


    def setBurnIn(self, b: 'gum::Size') -> "void":
        """
        setBurnIn(BNLearner_double self, gum::Size b)

        Parameters
        ----------
        b: gum::Size

        """
        return _pyAgrum.BNLearner_double_setBurnIn(self, b)


    def verbosity(self) -> "bool":
        """
        verbosity(BNLearner_double self) -> bool

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_verbosity(self)


    def epsilon(self) -> "double":
        """
        epsilon(BNLearner_double self) -> double

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_epsilon(self)


    def minEpsilonRate(self) -> "double":
        """
        minEpsilonRate(BNLearner_double self) -> double

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_minEpsilonRate(self)


    def maxIter(self) -> "gum::Size":
        """
        maxIter(BNLearner_double self) -> gum::Size

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_maxIter(self)


    def maxTime(self) -> "double":
        """maxTime(BNLearner_double self) -> double"""
        return _pyAgrum.BNLearner_double_maxTime(self)


    def periodSize(self) -> "gum::Size":
        """
        periodSize(BNLearner_double self) -> gum::Size

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_periodSize(self)


    def burnIn(self) -> "gum::Size":
        """
        burnIn(BNLearner_double self) -> gum::Size

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_burnIn(self)


    def nbrIterations(self) -> "gum::Size":
        """
        nbrIterations(BNLearner_double self) -> gum::Size

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_nbrIterations(self)


    def currentTime(self) -> "double":
        """currentTime(BNLearner_double self) -> double"""
        return _pyAgrum.BNLearner_double_currentTime(self)


    def messageApproximationScheme(self) -> "std::string":
        """
        messageApproximationScheme(BNLearner_double self) -> std::string

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_messageApproximationScheme(self)


    def history(self) -> "std::vector< double,std::allocator< double > > const &":
        """
        history(BNLearner_double self) -> Vector_double

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_history(self)


    def learnDAG(self) -> "gum::DAG":
        """
        learnDAG(BNLearner_double self) -> DAG

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_learnDAG(self)


    def names(self) -> "std::vector< std::string,std::allocator< std::string > > const &":
        """
        names(BNLearner_double self) -> Vector_string

        Parameters
        ----------
        self: gum::learning::BNLearner< double > const *

        """
        return _pyAgrum.BNLearner_double_names(self)


    def modalities(self) -> "std::vector< gum::Size,std::allocator< gum::Size > > const &":
        """
        modalities(BNLearner_double self) -> std::vector< gum::Size,std::allocator< gum::Size > > const &

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_modalities(self)


    def idFromName(self, var_name: 'std::string const &') -> "gum::NodeId":
        """
        idFromName(BNLearner_double self, std::string const & var_name) -> gum::NodeId

        Parameters
        ----------
        var_name: std::string const &

        """
        return _pyAgrum.BNLearner_double_idFromName(self, var_name)


    def nameFromId(self, id: 'gum::NodeId') -> "std::string const &":
        """
        nameFromId(BNLearner_double self, gum::NodeId id) -> std::string const &

        Parameters
        ----------
        id: gum::NodeId

        """
        return _pyAgrum.BNLearner_double_nameFromId(self, id)


    def useScoreAIC(self) -> "void":
        """
        useScoreAIC(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useScoreAIC(self)


    def useScoreBD(self) -> "void":
        """
        useScoreBD(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useScoreBD(self)


    def useScoreBDeu(self) -> "void":
        """
        useScoreBDeu(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useScoreBDeu(self)


    def useScoreBIC(self) -> "void":
        """
        useScoreBIC(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useScoreBIC(self)


    def useScoreK2(self) -> "void":
        """
        useScoreK2(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useScoreK2(self)


    def useScoreLog2Likelihood(self) -> "void":
        """
        useScoreLog2Likelihood(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useScoreLog2Likelihood(self)


    def setAprioriWeight(self, weight: 'double') -> "void":
        """
        setAprioriWeight(BNLearner_double self, double weight)

        Parameters
        ----------
        weight: double

        """
        return _pyAgrum.BNLearner_double_setAprioriWeight(self, weight)


    def useNoApriori(self) -> "void":
        """
        useNoApriori(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useNoApriori(self)


    def useAprioriSmoothing(self, *args) -> "void":
        """
        useAprioriSmoothing(BNLearner_double self, double weight=-1)

        Parameters
        ----------
        weight: double

        useAprioriSmoothing(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useAprioriSmoothing(self, *args)


    def useAprioriDirichlet(self, filename: 'std::string const &') -> "void":
        """
        useAprioriDirichlet(BNLearner_double self, std::string const & filename)

        Parameters
        ----------
        filename: std::string const &

        """
        return _pyAgrum.BNLearner_double_useAprioriDirichlet(self, filename)


    def useGreedyHillClimbing(self) -> "void":
        """
        useGreedyHillClimbing(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useGreedyHillClimbing(self)


    def useLocalSearchWithTabuList(self, *args) -> "void":
        """
        useLocalSearchWithTabuList(BNLearner_double self, gum::Size tabu_size=100, gum::Size nb_decrease=2)

        Parameters
        ----------
        tabu_size: gum::Size
        nb_decrease: gum::Size

        useLocalSearchWithTabuList(BNLearner_double self, gum::Size tabu_size=100)

        Parameters
        ----------
        tabu_size: gum::Size

        useLocalSearchWithTabuList(BNLearner_double self)

        Parameters
        ----------
        self: gum::learning::BNLearner< double > *

        """
        return _pyAgrum.BNLearner_double_useLocalSearchWithTabuList(self, *args)


    def useK2(self, *args) -> "void":
        """
        useK2(BNLearner_double self, PyObject * l)

        Parameters
        ----------
        l: PyObject *

        useK2(BNLearner_double self, gum::Sequence< gum::NodeId > const & order)

        Parameters
        ----------
        order: gum::Sequence< gum::NodeId > const &

        useK2(BNLearner_double self, std::vector< gum::NodeId,std::allocator< gum::NodeId > > const & order)

        Parameters
        ----------
        order: std::vector< gum::NodeId,std::allocator< gum::NodeId > > const &

        """
        return _pyAgrum.BNLearner_double_useK2(self, *args)


    def setMaxIndegree(self, max_indegree: 'gum::Size') -> "void":
        """
        setMaxIndegree(BNLearner_double self, gum::Size max_indegree)

        Parameters
        ----------
        max_indegree: gum::Size

        """
        return _pyAgrum.BNLearner_double_setMaxIndegree(self, max_indegree)


    def setSliceOrder(self, *args) -> "void":
        """
        setSliceOrder(BNLearner_double self, PyObject * l)

        Parameters
        ----------
        l: PyObject *

        setSliceOrder(BNLearner_double self, NodeProperty< gum::NodeId > const & slice_order)

        Parameters
        ----------
        slice_order: NodeProperty< gum::NodeId > const &

        """
        return _pyAgrum.BNLearner_double_setSliceOrder(self, *args)


    def addForbiddenArc(self, *args) -> "void":
        """
        addForbiddenArc(BNLearner_double self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        addForbiddenArc(BNLearner_double self, gum::NodeId const tail, gum::NodeId const head)

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        addForbiddenArc(BNLearner_double self, std::string const & tail, std::string const & head)

        Parameters
        ----------
        tail: std::string const &
        head: std::string const &

        """
        return _pyAgrum.BNLearner_double_addForbiddenArc(self, *args)


    def eraseForbiddenArc(self, *args) -> "void":
        """
        eraseForbiddenArc(BNLearner_double self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        eraseForbiddenArc(BNLearner_double self, gum::NodeId const tail, gum::NodeId const head)

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        eraseForbiddenArc(BNLearner_double self, std::string const & tail, std::string const & head)

        Parameters
        ----------
        tail: std::string const &
        head: std::string const &

        """
        return _pyAgrum.BNLearner_double_eraseForbiddenArc(self, *args)


    def addMandatoryArc(self, *args) -> "void":
        """
        addMandatoryArc(BNLearner_double self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        addMandatoryArc(BNLearner_double self, gum::NodeId const tail, gum::NodeId const head)

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        addMandatoryArc(BNLearner_double self, std::string const & tail, std::string const & head)

        Parameters
        ----------
        tail: std::string const &
        head: std::string const &

        """
        return _pyAgrum.BNLearner_double_addMandatoryArc(self, *args)


    def eraseMandatoryArc(self, *args) -> "void":
        """
        eraseMandatoryArc(BNLearner_double self, Arc arc)

        Parameters
        ----------
        arc: gum::Arc const &

        eraseMandatoryArc(BNLearner_double self, gum::NodeId const tail, gum::NodeId const head)

        Parameters
        ----------
        tail: gum::NodeId const
        head: gum::NodeId const

        eraseMandatoryArc(BNLearner_double self, std::string const & tail, std::string const & head)

        Parameters
        ----------
        tail: std::string const &
        head: std::string const &

        """
        return _pyAgrum.BNLearner_double_eraseMandatoryArc(self, *args)


    def setInitialDAG(self, g: 'DAG') -> "void":
        """
        setInitialDAG(BNLearner_double self, DAG g)

        Parameters
        ----------
        g: gum::DAG const &

        """
        return _pyAgrum.BNLearner_double_setInitialDAG(self, g)

BNLearner_double_swigregister = _pyAgrum.BNLearner_double_swigregister
BNLearner_double_swigregister(BNLearner_double)


def statsObj() -> "void":
    """statsObj()"""
    return _pyAgrum.statsObj()

Potential = Potential_double
UtilityTable = UtilityTable_double

randomDistribution = randomDistribution_double

SimpleBayesNet = IBayesNet_double
BayesNet = BayesNet_double
LazyPropagation = LazyPropagation_double
GibbsInference = GibbsInference_double

BruteForceKL = BruteForceKL_double
GibbsKL = GibbsKL_double

CredalNet = CredalNet_double
CNMonteCarloSampling = CNMonteCarloSampling_double
CNLoopyPropagation = CNLoopyPropagation_double

DiscretizedVariable = DiscretizedVariable_double

InfluenceDiagram = InfluenceDiagram_double
InfluenceDiagramInference = InfluenceDiagramInference_double

BNLearner =  BNLearner_double

# This file is compatible with both classic and new-style classes.


