"""
matrices used in MPFA and MPSA functions
"""
import numpy as np


def create_mpfa_indices():  # indices for A, C, D
    return (([0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11],
             [0, 2, 4, 1, 2, 6, 4, 8, 10, 6, 9, 10, 0, 2, 4, 0, 3, 5, 4, 8, 10, 5, 8, 11, 0, 2, 4, 0, 3, 5, 1, 2, 6, 1, 3, 7]),
            ([0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11],
             [0, 2, 3, 4, 5, 1, 2, 3, 6, 7, 4, 5, 8, 10, 11, 6, 7, 9, 10, 11, 0, 1, 2, 4, 6, 0, 1, 3, 5, 7, 4, 6, 8, 9, 10, 5, 7, 8, 9, 11, 0, 2, 4, 8, 10, 0, 3, 5, 8, 11, 1, 2, 6, 9, 10, 1, 3, 7, 9, 11]),
            ([0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11],
             [0, 1, 2, 3, 4, 5, 6, 7, 0, 2, 1, 3, 4, 6, 5, 7, 0, 4, 1, 5, 2, 6, 3, 7]))


def fill_Ampfa(k):
    return np.array([-k[0], -k[3], -k[4],
                     -k[12], k[15], -k[16],
                     k[28], -k[24], -k[27],
                     k[40], -k[36], k[39],
                     -k[3], -k[1], -k[5],
                     k[9], -k[7], -k[11],
                     k[29], -k[27], -k[25],
                     k[35], k[33], -k[31],
                     -k[4], -k[5], -k[2],
                     k[10], -k[11], -k[8],
                     -k[16], k[17], -k[14],
                     k[22], k[23], -k[20]]).transpose((1, 2, 0))


def fill_Bmpfa(k, z):
    return np.array([[k[0] + k[3] + k[4], z, z, z, z, z, z, z],
                     [z, z, k[12] - k[15] + k[16], z, z, z, z, z],
                     [z, z, z, z, k[24] + k[27] - k[28], z, z, z],
                     [z, z, z, z, z, z, k[36] - k[39] - k[40], z],
                     [k[3] + k[1] + k[5], z, z, z, z, z, z, z],
                     [z, -k[9] + k[7] + k[11], z, z, z, z, z, z],
                     [z, z, z, z, k[27] + k[25] - k[29], z, z, z],
                     [z, z, z, z, z, -k[33] + k[31] - k[35], z, z],
                     [k[4] + k[5] + k[2], z, z, z, z, z, z, z],
                     [z, -k[10] + k[11] + k[8], z, z, z, z, z, z],
                     [z, z, k[16] - k[17] + k[14], z, z, z, z, z],
                     [z, z, z, -k[22] - k[23] + k[20], z, z, z, z]]).transpose((2, 3, 0, 1))


def fill_Cmpfa(k):
    return np.array([k[6] + k[0], k[3], -k[9], k[4], -k[10],
                     k[12] + k[18], -k[15], k[21], k[16], -k[22],
                     -k[28], k[34], k[24] + k[30], k[27], -k[33],
                     -k[40], k[46], k[36] + k[42], -k[39], k[45],
                     k[3], -k[15], k[13] + k[1], k[5], -k[17],
                     -k[9], k[21], k[7] + k[19], k[11], -k[23],
                     -k[29], k[41], k[27], -k[39], k[25] + k[37],
                     -k[35], k[47], -k[33], k[45], k[31] + k[43],
                     k[4], k[5], k[2] + k[26], -k[28], -k[29],
                     -k[10], k[11], k[8] + k[32], k[34], -k[35],
                     k[16], -k[17], k[14] + k[38], -k[40], k[41],
                     -k[22], -k[23], k[20] + k[44], k[46], k[47]]).transpose((1, 2, 0))


def fill_Dmpfa(k):
    return np.array([k[0] + k[3] + k[4], k[6] - k[9] - k[10],
                     k[12] - k[15] + k[16], k[18] + k[21] - k[22],
                     k[24] + k[27] - k[28], k[30] - k[33] + k[34],
                     k[36] - k[39] - k[40], k[42] + k[45] + k[46],
                     k[3] + k[1] + k[5], -k[15] + k[13] - k[17],
                     -k[9] + k[7] + k[11], k[21] + k[19] - k[23],
                     k[27] + k[25] - k[29], -k[39] + k[37] + k[41],
                     -k[33] + k[31] - k[35], k[45] + k[43] + k[47],
                     k[4] + k[5] + k[2], -k[28] - k[29] + k[26],
                     -k[10] + k[11] + k[8], k[34] - k[35] + k[32],
                     k[16] - k[17] + k[14], -k[40] + k[41] + k[38],
                     -k[22] - k[23] + k[20], k[46] + k[47] + k[44]])


def create_mpsa_indices():  # indices for A, C, D
    return (([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35],
             [0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 31, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 31, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 31, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 31, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 31, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 31, 32, 33, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 32, 33, 34, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 32, 33, 34, 35, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 24, 25, 26, 28, 29, 30, 32, 33, 34, 35, 0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 18, 19, 21, 22, 23, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 18, 19, 21, 22, 23, 25, 26, 28, 29, 30, 32, 33, 35, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 18, 19, 21, 22, 23, 25, 26, 28, 29, 30, 32, 33, 35]),
            ([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 33, 33, 33, 33, 33, 33, 33, 33, 34, 34, 34, 34, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 35, 35, 35, 35],
             [0, 6, 7, 9, 10, 12, 13, 14, 15, 16, 17, 0, 2, 6, 7, 9, 10, 13, 14, 16, 17, 0, 1, 7, 10, 12, 13, 14, 15, 16, 17, 3, 6, 7, 9, 10, 18, 19, 20, 21, 22, 23, 3, 5, 6, 7, 9, 10, 19, 20, 22, 23, 3, 4, 7, 10, 18, 19, 20, 21, 22, 23, 12, 13, 14, 15, 16, 17, 24, 30, 31, 33, 34, 13, 14, 16, 17, 24, 26, 30, 31, 33, 34, 12, 13, 14, 15, 16, 17, 24, 25, 31, 34, 18, 19, 20, 21, 22, 23, 27, 30, 31, 33, 34, 19, 20, 22, 23, 27, 29, 30, 31, 33, 34, 18, 19, 20, 21, 22, 23, 27, 28, 31, 34, 0, 3, 6, 7, 12, 13, 14, 18, 19, 20, 0, 3, 6, 7, 12, 13, 14, 18, 19, 20, 0, 3, 6, 7, 8, 12, 14, 18, 20, 0, 3, 9, 10, 15, 16, 17, 21, 22, 23, 0, 3, 9, 10, 15, 16, 17, 21, 22, 23, 0, 3, 9, 10, 11, 15, 17, 21, 23, 12, 13, 14, 18, 19, 20, 24, 27, 30, 31, 12, 13, 14, 18, 19, 20, 24, 27, 30, 31, 12, 14, 18, 20, 24, 27, 30, 31, 32, 15, 16, 17, 21, 22, 23, 24, 27, 33, 34, 15, 16, 17, 21, 22, 23, 24, 27, 33, 34, 15, 17, 21, 23, 24, 27, 33, 34, 35, 0, 6, 7, 12, 13, 14, 24, 30, 31, 0, 6, 7, 12, 13, 14, 24, 30, 31, 0, 6, 7, 12, 13, 14, 24, 30, 31, 0, 9, 10, 15, 16, 17, 24, 33, 34, 0, 9, 10, 15, 16, 17, 24, 33, 34, 0, 9, 10, 15, 16, 17, 24, 33, 34, 3, 6, 7, 18, 19, 20, 27, 30, 31, 3, 6, 7, 18, 19, 20, 27, 30, 31, 3, 6, 7, 18, 19, 20, 27, 30, 31, 3, 9, 10, 21, 22, 23, 27, 33, 34, 3, 9, 10, 21, 22, 23, 27, 33, 34, 3, 9, 10, 21, 22, 23, 27, 33, 34]),
            ([0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32, 33, 33, 33, 33, 33, 33, 34, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 35],
             [0, 1, 8, 9, 16, 17, 0, 1, 8, 9, 16, 17, 0, 1, 8, 9, 16, 17, 2, 3, 10, 11, 18, 19, 2, 3, 10, 11, 18, 19, 2, 3, 10, 11, 18, 19, 4, 5, 12, 13, 20, 21, 4, 5, 12, 13, 20, 21, 4, 5, 12, 13, 20, 21, 6, 7, 14, 15, 22, 23, 6, 7, 14, 15, 22, 23, 6, 7, 14, 15, 22, 23, 0, 2, 8, 10, 16, 18, 0, 2, 8, 10, 16, 18, 0, 2, 8, 10, 16, 18, 1, 3, 9, 11, 17, 19, 1, 3, 9, 11, 17, 19, 1, 3, 9, 11, 17, 19, 4, 6, 12, 14, 20, 22, 4, 6, 12, 14, 20, 22, 4, 6, 12, 14, 20, 22, 5, 7, 13, 15, 21, 23, 5, 7, 13, 15, 21, 23, 5, 7, 13, 15, 21, 23, 0, 4, 8, 12, 16, 20, 0, 4, 8, 12, 16, 20, 0, 4, 8, 12, 16, 20, 1, 5, 9, 13, 17, 21, 1, 5, 9, 13, 17, 21, 1, 5, 9, 13, 17, 21, 2, 6, 10, 14, 18, 22, 2, 6, 10, 14, 18, 22, 2, 6, 10, 14, 18, 22, 3, 7, 11, 15, 19, 23, 3, 7, 11, 15, 19, 23, 3, 7, 11, 15, 19, 23]))


def fill_Ampsa(C):
    return np.array([16 * C[0], C[5] - C[26], C[4] - C[25], C[47] - C[68], C[46] - C[67], C[47] + (15 * C[5]), 16 * C[1], C[3] - C[45], C[68] - C[26], C[24] - C[66], (15 * C[4]) + C[88], (15 * C[3]) + C[87], 16 * C[2], C[109] - C[25], C[108] - C[24], C[130] - C[46], C[129] - C[45], C[151] - C[67], C[150] - C[66], C[89] - C[110], C[88] - C[109], C[131] - C[152], C[130] - C[151], C[131] - C[89], C[87] - C[129], C[152] - C[110], C[108] - C[150],
                     16 * C[4], C[19] - C[40], C[39] + (15*C[18]), C[61] - C[82], C[81] - C[60], C[61] + (15*C[19]), 16 * C[9], C[16] - C[58], C[82] - C[40], C[37] - C[79], C[18] - C[102], (15*C[16]) + C[100], 16 * C[13], C[39] - C[123], C[121] - C[37], C[60] - C[144], C[142] - C[58], C[81] - C[165], C[163] - C[79], C[103] - C[124], C[123] - C[102], C[145] - C[166], C[165] - C[144], C[145] - C[103], C[100] - C[142], C[166] - C[124], C[121] - C[163],
                     16 * C[5], C[20+21] + (15*C[20+0]), C[19] - C[40], C[20+63] - C[20+42], C[61] - C[82], C[20+0] - C[20+42], 16 * C[10], C[17] - C[59], C[20+21] - C[20+63], C[38] - C[80], (15*C[19]) + C[103], (15*C[17]) + C[101], 16 * C[14], C[124] - C[40], C[122] - C[38], C[145] - C[61], C[143] - C[59], C[166] - C[82], C[164] - C[80], C[20+105] - C[20+84], C[103] - C[124], C[20+147] - C[20+126], C[145] - C[166], C[20+84] - C[20+126], C[101] - C[143], C[20+105] - C[20+147], C[122] - C[164],
                     C[5] - C[26], C[4] - C[25], 16 * C[42], C[47] - C[68], C[46] - C[67], - (15*C[47]) - C[5], -16 * C[43], C[3] - C[45], C[68] - C[26], C[24] - C[66], C[88] - C[4], C[87] - C[3], C[109] - C[25], C[108] - C[24], (15*C[46]) + C[130], (15*C[45]) + C[129], 16 * C[44], C[151] - C[67], C[150] - C[66], C[89] - C[110], C[88] - C[109], C[131] - C[152], C[130] - C[151], C[131] - C[89], C[87] - C[129], C[152] - C[110], C[108] - C[150],
                     C[19] - C[40], C[39] - C[18], 16 * C[46], C[61] - C[82], (15*C[60]) + C[81], - (15*C[61]) - C[19], -16 * C[51], C[16] - C[58], C[82] - C[40], C[37] - C[79], C[18] - C[102], C[100] - C[16], C[39] - C[123], C[121] - C[37], C[60] - C[144], (15*C[58]) + C[142], 16 * C[55], C[81] - C[165], C[163] - C[79], C[103] - C[124], C[123] - C[102], C[145] - C[166], C[165] - C[144], C[145] - C[103], C[100] - C[142], C[166] - C[124], C[121] - C[163],
                     C[20+21] - C[20+0], C[19] - C[40], 16 * C[47], (15*C[20+42]) + C[20+63], C[61] - C[82], C[20+0] - C[20+42], -16 * C[52], C[17] - C[59], C[20+21] - C[20+63], C[38] - C[80], C[103] - C[19], C[101] - C[17], C[124] - C[40], C[122] - C[38], (15*C[61]) + C[145], (15*C[59]) + C[143], 16 * C[56], C[166] - C[82], C[164] - C[80], C[20+105] - C[20+84], C[103] - C[124], C[20+147] - C[20+126], C[145] - C[166], C[20+84] - C[20+126], C[101] - C[143], C[20+105] - C[20+147], C[122] - C[164],
                     C[5] - C[26], C[4] - C[25], C[47] - C[68], C[46] - C[67], C[47] - C[5], C[3] - C[45], C[68] - C[26], C[24] - C[66], - C[4] - (15*C[88]), - C[3] - (15*C[87]), -16 * C[86], C[109] - C[25], C[108] - C[24], C[130] - C[46], C[129] - C[45], C[151] - C[67], C[150] - C[66], 16 * C[84], C[89] - C[110], C[88] - C[109], C[131] - C[152], C[130] - C[151], (15*C[89]) + C[131], 16 * C[85], C[87] - C[129], C[152] - C[110], C[108] - C[150],
                     C[19] - C[40], C[39] - C[18], C[61] - C[82], C[81] - C[60], C[61] - C[19], C[16] - C[58], C[82] - C[40], C[37] - C[79], C[18] - C[102], - C[16] - (15*C[100]), -16 * C[97], C[39] - C[123], C[121] - C[37], C[60] - C[144], C[142] - C[58], C[81] - C[165], C[163] - C[79], 16 * C[88], C[103] - C[124], (15*C[102]) + C[123], C[145] - C[166], C[165] - C[144], (15*C[103]) + C[145], 16 * C[93], C[100] - C[142], C[166] - C[124], C[121] - C[163],
                     C[20+21] - C[20+0], C[19] - C[40], C[20+63] - C[20+42], C[61] - C[82], C[20+0] - C[20+42], C[17] - C[59], C[20+21] - C[20+63], C[38] - C[80], - C[19] - (15*C[103]), - C[17] - (15*C[101]), -16 * C[98], C[124] - C[40], C[122] - C[38], C[145] - C[61], C[143] - C[59], C[166] - C[82], C[164] - C[80], 16 * C[89], (15*C[20+84]) + C[20+105], C[103] - C[124], C[20+147] - C[20+126], C[145] - C[166], C[20+84] - C[20+126], 16 * C[94], C[101] - C[143], C[20+105] - C[20+147], C[122] - C[164],
                     C[5] - C[26], C[4] - C[25], C[47] - C[68], C[46] - C[67], C[47] - C[5], C[3] - C[45], C[68] - C[26], C[24] - C[66], C[88] - C[4], C[87] - C[3], C[109] - C[25], C[108] - C[24], - C[46] - (15*C[130]), - C[45] - (15*C[129]), -16 * C[128], C[151] - C[67], C[150] - C[66], C[89] - C[110], C[88] - C[109], 16 * C[126], C[131] - C[152], C[130] - C[151], - C[89] - (15*C[131]), -16 * C[127], C[87] - C[129], C[152] - C[110], C[108] - C[150],
                     C[19] - C[40], C[39] - C[18], C[61] - C[82], C[81] - C[60], C[61] - C[19], C[16] - C[58], C[82] - C[40], C[37] - C[79], C[18] - C[102], C[100] - C[16], C[39] - C[123], C[121] - C[37], C[60] - C[144], - C[58] - (15*C[142]), -16 * C[139], C[81] - C[165], C[163] - C[79], C[103] - C[124], C[123] - C[102], 16 * C[130], C[145] - C[166], (15*C[144]) + C[165], - C[103] - (15*C[145]), -16 * C[135], C[100] - C[142], C[166] - C[124], C[121] - C[163],
                     C[20+21] - C[20+0], C[19] - C[40], C[20+63] - C[20+42], C[61] - C[82], C[20+0] - C[20+42], C[17] - C[59], C[20+21] - C[20+63], C[38] - C[80], C[103] - C[19], C[101] - C[17], C[124] - C[40], C[122] - C[38], - C[61] - (15*C[145]), - C[59] - (15*C[143]), -16*C[140], C[166] - C[82], C[164] - C[80], C[20+105] - C[20+84], C[103] - C[124], 16*C[131], (15*C[20+126]) + C[20+147], C[145] - C[166], C[20+84] - C[20+126], -16*C[136], C[101] - C[143], C[20+105] - C[20+147], C[122] - C[164],
                     16*C[1], C[10] - C[31], C[9] - C[30], C[52] - C[73], C[51] - C[72], C[52] + (15*C[10]), 16*C[6], C[8] - C[50], C[73] - C[31], C[29] - C[71], (15*C[9]) + C[93], (15*C[8]) + C[92], 16*C[7], C[114] - C[30], C[113] - C[29], C[135] - C[51], C[134] - C[50], C[156] - C[72], C[155] - C[71], C[94] - C[115], C[93] - C[114], C[136] - C[157], C[135] - C[156], C[136] - C[94], C[92] - C[134], C[157] - C[115], C[113] - C[155],
                     16*C[5], C[20+0] - C[20+21], C[19] - C[40], C[20+42] - C[20+63], C[61] - C[82], C[20+42] + (15*C[20+0]), 16*C[10], C[17] - C[59], C[20+63] - C[20+21], C[38] - C[80], (15*C[19]) + C[103], (15*C[17]) + C[101], 16*C[14], C[124] - C[40], C[122] - C[38], C[145] - C[61], C[143] - C[59], C[166] - C[82], C[164] - C[80], C[20+84] - C[20+105], C[103] - C[124], C[20+126] - C[20+147], C[145] - C[166], C[20+126] - C[20+84], C[101] - C[143], C[20+147] - C[20+105], C[122] - C[164],
                     16*C[3], C[17] - C[38], C[16] - C[37], C[59] - C[80], C[58] - C[79], C[59] + (15*C[17]), 16*C[8], C[57] + (15*C[15]), C[80] - C[38], C[78] - C[36], (15*C[16]) + C[100], C[15] - C[99], 16*C[12], C[121] - C[37], C[36] - C[120], C[142] - C[58], C[57] - C[141], C[163] - C[79], C[78] - C[162], C[101] - C[122], C[100] - C[121], C[143] - C[164], C[142] - C[163], C[143] - C[101], C[141] - C[99], C[164] - C[122], C[162] - C[120],
                     -16*C[22], C[10] - C[31], C[9] - C[30], C[52] - C[73], C[51] - C[72], C[52] - C[10], C[8] - C[50], (15*C[31]) + C[73], 16*C[27], C[29] - C[71], C[93] - C[9], C[92] - C[8], (15*C[30]) + C[114], (15*C[29]) + C[113], 16*C[28], C[135] - C[51], C[134] - C[50], C[156] - C[72], C[155] - C[71], C[94] - C[115], C[93] - C[114], C[136] - C[157], C[135] - C[156], C[136] - C[94], C[92] - C[134], C[157] - C[115], C[113] - C[155],
                     -16*C[26], C[20+0] - C[20+21], C[19] - C[40], C[20+42] - C[20+63], C[61] - C[82], C[20+42] - C[20+0], C[17] - C[59], (15*C[20+21]) + C[20+63], 16*C[31], C[38] - C[80], C[103] - C[19], C[101] - C[17], (15*C[40]) + C[124], (15*C[38]) + C[122], 16*C[35], C[145] - C[61], C[143] - C[59], C[166] - C[82], C[164] - C[80], C[20+84] - C[20+105], C[103] - C[124], C[20+126] - C[20+147], C[145] - C[166], C[20+126] - C[20+84], C[101] - C[143], C[20+147] - C[20+105], C[122] - C[164],
                     -16*C[24], C[17] - C[38], C[16] - C[37], C[59] - C[80], C[58] - C[79], C[59] - C[17], C[57] - C[15], (15*C[38]) + C[80], 16*C[29], (15*C[36]) + C[78], C[100] - C[16], C[15] - C[99], (15*C[37]) + C[121], C[36] - C[120], 16*C[33], C[142] - C[58], C[57] - C[141], C[163] - C[79], C[78] - C[162], C[101] - C[122], C[100] - C[121], C[143] - C[164], C[142] - C[163], C[143] - C[101], C[141] - C[99], C[164] - C[122], C[162] - C[120],
                     C[10] - C[31], C[9] - C[30], C[52] - C[73], C[51] - C[72], C[52] - C[10], C[8] - C[50], C[73] - C[31], C[29] - C[71], - C[9] - (15*C[93]), - C[8] - (15*C[92]), -16*C[91], C[114] - C[30], C[113] - C[29], C[135] - C[51], C[134] - C[50], C[156] - C[72], C[155] - C[71], 16*C[85], C[94] - C[115], C[93] - C[114], C[136] - C[157], C[135] - C[156], (15*C[94]) + C[136], 16*C[90], C[92] - C[134], C[157] - C[115], C[113] - C[155],
                     C[20+0] - C[20+21], C[19] - C[40], C[20+42] - C[20+63], C[61] - C[82], C[20+42] - C[20+0], C[17] - C[59], C[20+63] - C[20+21], C[38] - C[80], - C[19] - (15*C[103]), - C[17] - (15*C[101]), -16*C[98], C[124] - C[40], C[122] - C[38], C[145] - C[61], C[143] - C[59], C[166] - C[82], C[164] - C[80], 16*C[89], C[20+84] - C[20+105], C[103] - C[124], C[20+126] - C[20+147], C[145] - C[166], (15*C[20+84]) + C[20+126], 16*C[94], C[101] - C[143], C[20+147] - C[20+105], C[122] - C[164],
                     C[17] - C[38], C[16] - C[37], C[59] - C[80], C[58] - C[79], C[59] - C[17], C[57] - C[15], C[80] - C[38], C[78] - C[36], - C[16] - (15*C[100]), C[15] - C[99], -16*C[96], C[121] - C[37], C[36] - C[120], C[142] - C[58], C[57] - C[141], C[163] - C[79], C[78] - C[162], 16*C[87], C[101] - C[122], C[100] - C[121], C[143] - C[164], C[142] - C[163], (15*C[101]) + C[143], 16*C[92], (15*C[99]) + C[141], C[164] - C[122], C[162] - C[120],
                     C[10] - C[31], C[9] - C[30], C[52] - C[73], C[51] - C[72], C[52] - C[10], C[8] - C[50], C[73] - C[31], C[29] - C[71], C[93] - C[9], C[92] - C[8], - C[30] - (15*C[114]), - C[29] - (15*C[113]), -16*C[112], C[135] - C[51], C[134] - C[50], C[156] - C[72], C[155] - C[71], -16*C[106], C[94] - C[115], C[93] - C[114], C[136] - C[157], C[135] - C[156], C[136] - C[94], C[92] - C[134], (15*C[115]) + C[157], 16*C[111], C[113] - C[155],
                     C[20+0] - C[20+21], C[19] - C[40], C[20+42] - C[20+63], C[61] - C[82], C[20+42] - C[20+0], C[17] - C[59], C[20+63] - C[20+21], C[38] - C[80], C[103] - C[19], C[101] - C[17], - C[40] - (15*C[124]), - C[38] - (15*C[122]), -16*C[119], C[145] - C[61], C[143] - C[59], C[166] - C[82], C[164] - C[80], -16*C[110], C[20+84] - C[20+105], C[103] - C[124], C[20+126] - C[20+147], C[145] - C[166], C[20+126] - C[20+84], C[101] - C[143], (15*C[20+105]) + C[20+147], 16*C[115], C[122] - C[164],
                     C[17] - C[38], C[16] - C[37], C[59] - C[80], C[58] - C[79], C[59] - C[17], C[57] - C[15], C[80] - C[38], C[78] - C[36], C[100] - C[16], C[15] - C[99], - C[37] - (15*C[121]), C[36] - C[120], -16*C[117], C[142] - C[58], C[57] - C[141], C[163] - C[79], C[78] - C[162], -16*C[108], C[101] - C[122], C[100] - C[121], C[143] - C[164], C[142] - C[163], C[143] - C[101], C[141] - C[99], (15*C[122]) + C[164], 16*C[113], (15*C[120]) + C[162],
                     16*C[2], C[14] - C[35], C[13] - C[34], C[56] - C[77], C[55] - C[76], C[56] + (15*C[14]), 16*C[7], C[12] - C[54], C[77] - C[35], C[33] - C[75], (15*C[13]) + C[97], (15*C[12]) + C[96], 16*C[11], C[118] - C[34], C[117] - C[33], C[139] - C[55], C[138] - C[54], C[160] - C[76], C[159] - C[75], C[98] - C[119], C[97] - C[118], C[140] - C[161], C[139] - C[160], C[140] - C[98], C[96] - C[138], C[161] - C[119], C[117] - C[159],
                     16*C[3], C[17] - C[38], C[16] - C[37], C[59] - C[80], C[58] - C[79], C[59] + (15*C[17]), 16*C[8], C[15] - C[57], C[80] - C[38], C[36] - C[78], (15*C[16]) + C[100], (15*C[15]) + C[99], 16*C[12], C[121] - C[37], C[120] - C[36], C[142] - C[58], C[141] - C[57], C[163] - C[79], C[162] - C[78], C[101] - C[122], C[100] - C[121], C[143] - C[164], C[142] - C[163], C[143] - C[101], C[99] - C[141], C[164] - C[122], C[120] - C[162],
                     16*C[4], C[19] - C[40], C[18] - C[39], C[61] - C[82], C[60] - C[81], C[61] + (15*C[19]), 16*C[9], C[16] - C[58], C[82] - C[40], C[37] - C[79], (15*C[18]) + C[102], (15*C[16]) + C[100], 16*C[13], C[123] - C[39], C[121] - C[37], C[144] - C[60], C[142] - C[58], C[165] - C[81], C[163] - C[79], C[103] - C[124], C[102] - C[123], C[145] - C[166], C[144] - C[165], C[145] - C[103], C[100] - C[142], C[166] - C[124], C[121] - C[163],
                     -16*C[23], C[14] - C[35], C[13] - C[34], C[56] - C[77], C[55] - C[76], C[56] - C[14], C[12] - C[54], (15*C[35]) + C[77], 16*C[28], C[33] - C[75], C[97] - C[13], C[96] - C[12], (15*C[34]) + C[118], (15*C[33]) + C[117], 16*C[32], C[139] - C[55], C[138] - C[54], C[160] - C[76], C[159] - C[75], C[98] - C[119], C[97] - C[118], C[140] - C[161], C[139] - C[160], C[140] - C[98], C[96] - C[138], C[161] - C[119], C[117] - C[159],
                     -16*C[24], C[17] - C[38], C[16] - C[37], C[59] - C[80], C[58] - C[79], C[59] - C[17], C[15] - C[57], (15*C[38]) + C[80], 16*C[29], C[36] - C[78], C[100] - C[16], C[99] - C[15], (15*C[37]) + C[121], (15*C[36]) + C[120], 16*C[33], C[142] - C[58], C[141] - C[57], C[163] - C[79], C[162] - C[78], C[101] - C[122], C[100] - C[121], C[143] - C[164], C[142] - C[163], C[143] - C[101], C[99] - C[141], C[164] - C[122], C[120] - C[162],
                     -16*C[25], C[19] - C[40], C[18] - C[39], C[61] - C[82], C[60] - C[81], C[61] - C[19], C[16] - C[58], (15*C[40]) + C[82], 16*C[30], C[37] - C[79], C[102] - C[18], C[100] - C[16], (15*C[39]) + C[123], (15*C[37]) + C[121], 16*C[34], C[144] - C[60], C[142] - C[58], C[165] - C[81], C[163] - C[79], C[103] - C[124], C[102] - C[123], C[145] - C[166], C[144] - C[165], C[145] - C[103], C[100] - C[142], C[166] - C[124], C[121] - C[163],
                     C[14] - C[35], C[13] - C[34], 16*C[44], C[56] - C[77], C[55] - C[76], - (15*C[56]) - C[14], -16*C[49], C[12] - C[54], C[77] - C[35], C[33] - C[75], C[97] - C[13], C[96] - C[12], C[118] - C[34], C[117] - C[33], (15*C[55]) + C[139], (15*C[54]) + C[138], 16*C[53], C[160] - C[76], C[159] - C[75], C[98] - C[119], C[97] - C[118], C[140] - C[161], C[139] - C[160], C[140] - C[98], C[96] - C[138], C[161] - C[119], C[117] - C[159],
                     C[17] - C[38], C[16] - C[37], 16*C[45], C[59] - C[80], C[58] - C[79], - (15*C[59]) - C[17], -16*C[50], C[15] - C[57], C[80] - C[38], C[36] - C[78], C[100] - C[16], C[99] - C[15], C[121] - C[37], C[120] - C[36], (15*C[58]) + C[142], (15*C[57]) + C[141], 16*C[54], C[163] - C[79], C[162] - C[78], C[101] - C[122], C[100] - C[121], C[143] - C[164], C[142] - C[163], C[143] - C[101], C[99] - C[141], C[164] - C[122], C[120] - C[162],
                     C[19] - C[40], C[18] - C[39], 16*C[46], C[61] - C[82], C[60] - C[81], - (15*C[61]) - C[19], -16*C[51], C[16] - C[58], C[82] - C[40], C[37] - C[79], C[102] - C[18], C[100] - C[16], C[123] - C[39], C[121] - C[37], (15*C[60]) + C[144], (15*C[58]) + C[142], 16*C[55], C[165] - C[81], C[163] - C[79], C[103] - C[124], C[102] - C[123], C[145] - C[166], C[144] - C[165], C[145] - C[103], C[100] - C[142], C[166] - C[124], C[121] - C[163],
                     C[14] - C[35], C[13] - C[34], -16*C[65], C[56] - C[77], C[55] - C[76], C[56] - C[14], C[12] - C[54], - C[35] - (15*C[77]), -16*C[70], C[33] - C[75], C[97] - C[13], C[96] - C[12], C[118] - C[34], C[117] - C[33], C[139] - C[55], C[138] - C[54], (15*C[76]) + C[160], (15*C[75]) + C[159], 16*C[74], C[98] - C[119], C[97] - C[118], C[140] - C[161], C[139] - C[160], C[140] - C[98], C[96] - C[138], C[161] - C[119], C[117] - C[159],
                     C[17] - C[38], C[16] - C[37], -16*C[66], C[59] - C[80], C[58] - C[79], C[59] - C[17], C[15] - C[57], - C[38] - (15*C[80]), -16*C[71], C[36] - C[78], C[100] - C[16], C[99] - C[15], C[121] - C[37], C[120] - C[36], C[142] - C[58], C[141] - C[57], (15*C[79]) + C[163], (15*C[78]) + C[162], 16*C[75], C[101] - C[122], C[100] - C[121], C[143] - C[164], C[142] - C[163], C[143] - C[101], C[99] - C[141], C[164] - C[122], C[120] - C[162],
                     C[19] - C[40], C[18] - C[39], -16*C[67], C[61] - C[82], C[60] - C[81], C[61] - C[19], C[16] - C[58], - C[40] - (15*C[82]), -16*C[72], C[37] - C[79], C[102] - C[18], C[100] - C[16], C[123] - C[39], C[121] - C[37], C[144] - C[60], C[142] - C[58], (15*C[81]) + C[165], (15*C[79]) + C[163], 16*C[76], C[103] - C[124], C[102] - C[123], C[145] - C[166], C[144] - C[165], C[145] - C[103], C[100] - C[142], C[166] - C[124], C[121] - C[163]]).transpose((1, 2, 0))


def fill_Bmpsa(C):
    return np.array([[- 16*C[0] - (15*C[4]) - (15*C[5]), C[25] + C[26], C[46] - C[47], C[67] - C[68], C[89] - C[88], C[110] - C[109], - C[130] - C[131], - C[151] - C[152], - 16*C[1] - (15*C[3]) - C[5], C[24] + C[26], C[45] - C[47], C[66] + C[68], - C[87] - C[89], C[110] - C[108], - C[129] - C[131], C[152] - C[150], - 16*C[2] - C[3] - C[4], C[25] - C[24], C[45] - C[46], C[66] + C[67], - C[87] - C[88], C[109] - C[108], C[129] - C[130], C[150] + C[151]],
                     [- 16*C[4] - C[18] - (15*C[19]), C[40] - C[39], - C[60] - C[61], - C[81] - C[82], C[102] + C[103], C[123] + C[124], C[144] - C[145], C[165] - C[166], - 16*C[9] - (15*C[16]) - C[19], C[37] + C[40], C[58] - C[61], C[79] + C[82], - C[100] - C[103], C[124] - C[121], - C[142] - C[145], C[166] - C[163], - 16*C[13] - C[16] - (15*C[18]), - C[37] - C[39], C[58] + C[60], C[79] - C[81], C[102] - C[100], - C[121] - C[123], C[142] + C[144], C[163] - C[165]],
                     [- 16*C[5] - (15*C[19]) - C[20+0], C[40] - C[20+21], C[61] + C[20+42], C[82] + C[20+63], - C[103] - C[20+84], - C[124] - C[20+105], C[20+126] - C[145], C[20+147] - C[166], - 16*C[10] - (15*C[17]) - (15*C[20+0]), C[38] - C[20+21], C[59] + C[20+42], C[80] - C[20+63], C[20+84] - C[101], - C[122] - C[20+105], C[20+126] - C[143], - C[164] - C[20+147], - 16*C[14] - C[17] - C[19], C[40] - C[38], C[59] - C[61], C[80] + C[82], - C[101] - C[103], C[124] - C[122], C[143] - C[145], C[164] + C[166]],
                     [C[4] + C[5], C[25] + C[26], (15*C[47]) - (15*C[46]) - 16*C[42], C[67] - C[68], C[89] - C[88], C[110] - C[109], - C[130] - C[131], - C[151] - C[152], C[3] - C[5], C[24] + C[26], 16*C[43] - (15*C[45]) - C[47], C[66] + C[68], - C[87] - C[89], C[110] - C[108], - C[129] - C[131], C[152] - C[150], - C[3] - C[4], C[25] - C[24], C[45] - 16*C[44] - C[46], C[66] + C[67], - C[87] - C[88], C[109] - C[108], C[129] - C[130], C[150] + C[151]],
                     [C[19] - C[18], C[40] - C[39], (15*C[61]) - C[60] - 16*C[46], - C[81] - C[82], C[102] + C[103], C[123] + C[124], C[144] - C[145], C[165] - C[166], C[16] - C[19], C[37] + C[40], 16*C[51] - (15*C[58]) - C[61], C[79] + C[82], - C[100] - C[103], C[124] - C[121], - C[142] - C[145], C[166] - C[163], C[18] - C[16], - C[37] - C[39], C[58] - 16*C[55] - (15*C[60]), C[79] - C[81], C[102] - C[100], - C[121] - C[123], C[142] + C[144], C[163] - C[165]],
                     [C[19] - C[20+0], C[40] - C[20+21], C[20+42] - (15*C[61]) - 16*C[47], C[82] + C[20+63], - C[103] - C[20+84], - C[124] - C[20+105], C[20+126] - C[145], C[20+147] - C[166], C[17] + C[20+0], C[38] - C[20+21], 16*C[52] - (15*C[59]) - (15*C[20+42]), C[80] - C[20+63], C[20+84] - C[101], - C[122] - C[20+105], C[20+126] - C[143], - C[164] - C[20+147], - C[17] - C[19], C[40] - C[38], C[59] - 16*C[56] - C[61], C[80] + C[82], - C[101] - C[103], C[124] - C[122], C[143] - C[145], C[164] + C[166]],
                     [C[4] + C[5], C[25] + C[26], C[46] - C[47], C[67] - C[68], (15*C[88]) - 16*C[84] - (15*C[89]), C[110] - C[109], - C[130] - C[131], - C[151] - C[152], C[3] - C[5], C[24] + C[26], C[45] - C[47], C[66] + C[68], (15*C[87]) - 16*C[85] - C[89], C[110] - C[108], - C[129] - C[131], C[152] - C[150], - C[3] - C[4], C[25] - C[24], C[45] - C[46], C[66] + C[67], 16*C[86] - C[87] - C[88], C[109] - C[108], C[129] - C[130], C[150] + C[151]],
                     [C[19] - C[18], C[40] - C[39], - C[60] - C[61], - C[81] - C[82], C[102] - 16*C[88] - (15*C[103]), C[123] + C[124], C[144] - C[145], C[165] - C[166], C[16] - C[19], C[37] + C[40], C[58] - C[61], C[79] + C[82], (15*C[100]) - 16*C[93] - C[103], C[124] - C[121], - C[142] - C[145], C[166] - C[163], C[18] - C[16], - C[37] - C[39], C[58] + C[60], C[79] - C[81], 16*C[97] - C[100] - (15*C[102]), - C[121] - C[123], C[142] + C[144], C[163] - C[165]],
                     [C[19] - C[20+0], C[40] - C[20+21], C[61] + C[20+42], C[82] + C[20+63], (15*C[103]) - 16*C[89] - C[20+84], - C[124] - C[20+105], C[20+126] - C[145], C[20+147] - C[166], C[17] + C[20+0], C[38] - C[20+21], C[59] + C[20+42], C[80] - C[20+63], (15*C[101]) - 16*C[94] - (15*C[20+84]), - C[122] - C[20+105], C[20+126] - C[143], - C[164] - C[20+147], - C[17] - C[19], C[40] - C[38], C[59] - C[61], C[80] + C[82], 16*C[98] - C[101] - C[103], C[124] - C[122], C[143] - C[145], C[164] + C[166]],
                     [C[4] + C[5], C[25] + C[26], C[46] - C[47], C[67] - C[68], C[89] - C[88], C[110] - C[109], (15*C[130]) - 16*C[126] + (15*C[131]), - C[151] - C[152], C[3] - C[5], C[24] + C[26], C[45] - C[47], C[66] + C[68], - C[87] - C[89], C[110] - C[108], 16*C[127] + (15*C[129]) - C[131], C[152] - C[150], - C[3] - C[4], C[25] - C[24], C[45] - C[46], C[66] + C[67], - C[87] - C[88], C[109] - C[108], 16*C[128] + C[129] - C[130], C[150] + C[151]],
                     [C[19] - C[18], C[40] - C[39], - C[60] - C[61], - C[81] - C[82], C[102] + C[103], C[123] + C[124], C[144] - 16*C[130] + (15*C[145]), C[165] - C[166], C[16] - C[19], C[37] + C[40], C[58] - C[61], C[79] + C[82], - C[100] - C[103], C[124] - C[121], 16*C[135] + (15*C[142]) - C[145], C[166] - C[163], C[18] - C[16], - C[37] - C[39], C[58] + C[60], C[79] - C[81], C[102] - C[100], - C[121] - C[123], 16*C[139] + C[142] - (15*C[144]), C[163] - C[165]],
                     [C[19] - C[20+0], C[40] - C[20+21], C[61] + C[20+42], C[82] + C[20+63], - C[103] - C[20+84], - C[124] - C[20+105], (15*C[145]) - 16*C[131] + C[20+126], C[20+147] - C[166], C[17] + C[20+0], C[38] - C[20+21], C[59] + C[20+42], C[80] - C[20+63], C[20+84] - C[101], - C[122] - C[20+105], 16*C[136] + (15*C[143]) - (15*C[20+126]), - C[164] - C[20+147], - C[17] - C[19], C[40] - C[38], C[59] - C[61], C[80] + C[82], - C[101] - C[103], C[124] - C[122], 16*C[140] + C[143] - C[145], C[164] + C[166]],
                     [- 16*C[1] - (15*C[9]) - (15*C[10]), C[30] + C[31], C[51] - C[52], C[72] - C[73], C[94] - C[93], C[115] - C[114], - C[135] - C[136], - C[156] - C[157], - 16*C[6] - (15*C[8]) - C[10], C[29] + C[31], C[50] - C[52], C[71] + C[73], - C[92] - C[94], C[115] - C[113], - C[134] - C[136], C[157] - C[155], - 16*C[7] - C[8] - C[9], C[30] - C[29], C[50] - C[51], C[71] + C[72], - C[92] - C[93], C[114] - C[113], C[134] - C[135], C[155] + C[156]],
                     [- 16*C[5] - (15*C[19]) - (15*C[20+0]), C[40] + C[20+21], C[61] - C[20+42], C[82] - C[20+63], C[20+84] - C[103], C[20+105] - C[124], - C[145] - C[20+126], - C[166] - C[20+147], - 16*C[10] - (15*C[17]) - C[20+0], C[38] + C[20+21], C[59] - C[20+42], C[80] + C[20+63], - C[101] - C[20+84], C[20+105] - C[122], - C[143] - C[20+126], C[20+147] - C[164], - 16*C[14] - C[17] - C[19], C[40] - C[38], C[59] - C[61], C[80] + C[82], - C[101] - C[103], C[124] - C[122], C[143] - C[145], C[164] + C[166]],
                     [- 16*C[3] - (15*C[16]) - (15*C[17]), C[37] + C[38], C[58] - C[59], C[79] - C[80], C[101] - C[100], C[122] - C[121], - C[142] - C[143], - C[163] - C[164], - 16*C[8] - C[15] - C[17], C[38] - C[36], - C[57] - C[59], C[80] - C[78], C[99] - C[101], C[120] + C[122], C[141] - C[143], C[162] + C[164], - 16*C[12] - (15*C[15]) - C[16], C[36] + C[37], - C[57] - C[58], C[79] - C[78], C[99] - C[100], C[120] + C[121], - C[141] - C[142], C[163] - C[162]],
                     [C[9] + C[10], 16*C[22] - (15*C[30]) - (15*C[31]), C[51] - C[52], C[72] - C[73], C[94] - C[93], C[115] - C[114], - C[135] - C[136], - C[156] - C[157], C[8] - C[10], C[31] - (15*C[29]) - 16*C[27], C[50] - C[52], C[71] + C[73], - C[92] - C[94], C[115] - C[113], - C[134] - C[136], C[157] - C[155], - C[8] - C[9], C[30] - C[29] - 16*C[28], C[50] - C[51], C[71] + C[72], - C[92] - C[93], C[114] - C[113], C[134] - C[135], C[155] + C[156]],
                     [C[19] + C[20+0], 16*C[26] - (15*C[40]) - (15*C[20+21]), C[61] - C[20+42], C[82] - C[20+63], C[20+84] - C[103], C[20+105] - C[124], - C[145] - C[20+126], - C[166] - C[20+147], C[17] - C[20+0], C[20+21] - (15*C[38]) - 16*C[31], C[59] - C[20+42], C[80] + C[20+63], - C[101] - C[20+84], C[20+105] - C[122], - C[143] - C[20+126], C[20+147] - C[164], - C[17] - C[19], C[40] - C[38] - 16*C[35], C[59] - C[61], C[80] + C[82], - C[101] - C[103], C[124] - C[122], C[143] - C[145], C[164] + C[166]],
                     [C[16] + C[17], 16*C[24] - (15*C[37]) - (15*C[38]), C[58] - C[59], C[79] - C[80], C[101] - C[100], C[122] - C[121], - C[142] - C[143], - C[163] - C[164], - C[15] - C[17], C[38] - C[36] - 16*C[29], - C[57] - C[59], C[80] - C[78], C[99] - C[101], C[120] + C[122], C[141] - C[143], C[162] + C[164], C[15] - C[16], C[37] - (15*C[36]) - 16*C[33], - C[57] - C[58], C[79] - C[78], C[99] - C[100], C[120] + C[121], - C[141] - C[142], C[163] - C[162]],
                     [C[9] + C[10], C[30] + C[31], C[51] - C[52], C[72] - C[73], (15*C[93]) - 16*C[85] - (15*C[94]), C[115] - C[114], - C[135] - C[136], - C[156] - C[157], C[8] - C[10], C[29] + C[31], C[50] - C[52], C[71] + C[73], (15*C[92]) - 16*C[90] - C[94], C[115] - C[113], - C[134] - C[136], C[157] - C[155], - C[8] - C[9], C[30] - C[29], C[50] - C[51], C[71] + C[72], 16*C[91] - C[92] - C[93], C[114] - C[113], C[134] - C[135], C[155] + C[156]],
                     [C[19] + C[20+0], C[40] + C[20+21], C[61] - C[20+42], C[82] - C[20+63], (15*C[103]) - 16*C[89] - (15*C[20+84]), C[20+105] - C[124], - C[145] - C[20+126], - C[166] - C[20+147], C[17] - C[20+0], C[38] + C[20+21], C[59] - C[20+42], C[80] + C[20+63], (15*C[101]) - 16*C[94] - C[20+84], C[20+105] - C[122], - C[143] - C[20+126], C[20+147] - C[164], - C[17] - C[19], C[40] - C[38], C[59] - C[61], C[80] + C[82], 16*C[98] - C[101] - C[103], C[124] - C[122], C[143] - C[145], C[164] + C[166]],
                     [C[16] + C[17], C[37] + C[38], C[58] - C[59], C[79] - C[80], (15*C[100]) - 16*C[87] - (15*C[101]), C[122] - C[121], - C[142] - C[143], - C[163] - C[164], - C[15] - C[17], C[38] - C[36], - C[57] - C[59], C[80] - C[78], C[99] - 16*C[92] - C[101], C[120] + C[122], C[141] - C[143], C[162] + C[164], C[15] - C[16], C[36] + C[37], - C[57] - C[58], C[79] - C[78], 16*C[96] - (15*C[99]) - C[100], C[120] + C[121], - C[141] - C[142], C[163] - C[162]],
                     [C[9] + C[10], C[30] + C[31], C[51] - C[52], C[72] - C[73], C[94] - C[93], 16*C[106] + (15*C[114]) - (15*C[115]), - C[135] - C[136], - C[156] - C[157], C[8] - C[10], C[29] + C[31], C[50] - C[52], C[71] + C[73], - C[92] - C[94], (15*C[113]) - 16*C[111] + C[115], - C[134] - C[136], C[157] - C[155], - C[8] - C[9], C[30] - C[29], C[50] - C[51], C[71] + C[72], - C[92] - C[93], 16*C[112] - C[113] + C[114], C[134] - C[135], C[155] + C[156]],
                     [C[19] + C[20+0], C[40] + C[20+21], C[61] - C[20+42], C[82] - C[20+63], C[20+84] - C[103], 16*C[110] + (15*C[124]) - (15*C[20+105]), - C[145] - C[20+126], - C[166] - C[20+147], C[17] - C[20+0], C[38] + C[20+21], C[59] - C[20+42], C[80] + C[20+63], - C[101] - C[20+84], (15*C[122]) - 16*C[115] + C[20+105], - C[143] - C[20+126], C[20+147] - C[164], - C[17] - C[19], C[40] - C[38], C[59] - C[61], C[80] + C[82], - C[101] - C[103], 16*C[119] - C[122] + C[124], C[143] - C[145], C[164] + C[166]],
                     [C[16] + C[17], C[37] + C[38], C[58] - C[59], C[79] - C[80], C[101] - C[100], 16*C[108] + (15*C[121]) - (15*C[122]), - C[142] - C[143], - C[163] - C[164], - C[15] - C[17], C[38] - C[36], - C[57] - C[59], C[80] - C[78], C[99] - C[101], C[120] - 16*C[113] + C[122], C[141] - C[143], C[162] + C[164], C[15] - C[16], C[36] + C[37], - C[57] - C[58], C[79] - C[78], C[99] - C[100], 16*C[117] - (15*C[120]) + C[121], - C[141] - C[142], C[163] - C[162]],
                     [- 16*C[2] - (15*C[13]) - (15*C[14]), C[34] + C[35], C[55] - C[56], C[76] - C[77], C[98] - C[97], C[119] - C[118], - C[139] - C[140], - C[160] - C[161], - 16*C[7] - (15*C[12]) - C[14], C[33] + C[35], C[54] - C[56], C[75] + C[77], - C[96] - C[98], C[119] - C[117], - C[138] - C[140], C[161] - C[159], - 16*C[11] - C[12] - C[13], C[34] - C[33], C[54] - C[55], C[75] + C[76], - C[96] - C[97], C[118] - C[117], C[138] - C[139], C[159] + C[160]],
                     [- 16*C[3] - (15*C[16]) - (15*C[17]), C[37] + C[38], C[58] - C[59], C[79] - C[80], C[101] - C[100], C[122] - C[121], - C[142] - C[143], - C[163] - C[164], - 16*C[8] - (15*C[15]) - C[17], C[36] + C[38], C[57] - C[59], C[78] + C[80], - C[99] - C[101], C[122] - C[120], - C[141] - C[143], C[164] - C[162], - 16*C[12] - C[15] - C[16], C[37] - C[36], C[57] - C[58], C[78] + C[79], - C[99] - C[100], C[121] - C[120], C[141] - C[142], C[162] + C[163]],
                     [- 16*C[4] - (15*C[18]) - (15*C[19]), C[39] + C[40], C[60] - C[61], C[81] - C[82], C[103] - C[102], C[124] - C[123], - C[144] - C[145], - C[165] - C[166], - 16*C[9] - (15*C[16]) - C[19], C[37] + C[40], C[58] - C[61], C[79] + C[82], - C[100] - C[103], C[124] - C[121], - C[142] - C[145], C[166] - C[163], - 16*C[13] - C[16] - C[18], C[39] - C[37], C[58] - C[60], C[79] + C[81], - C[100] - C[102], C[123] - C[121], C[142] - C[144], C[163] + C[165]],
                     [C[13] + C[14], 16*C[23] - (15*C[34]) - (15*C[35]), C[55] - C[56], C[76] - C[77], C[98] - C[97], C[119] - C[118], - C[139] - C[140], - C[160] - C[161], C[12] - C[14], C[35] - (15*C[33]) - 16*C[28], C[54] - C[56], C[75] + C[77], - C[96] - C[98], C[119] - C[117], - C[138] - C[140], C[161] - C[159], - C[12] - C[13], C[34] - C[33] - 16*C[32], C[54] - C[55], C[75] + C[76], - C[96] - C[97], C[118] - C[117], C[138] - C[139], C[159] + C[160]],
                     [C[16] + C[17], 16*C[24] - (15*C[37]) - (15*C[38]), C[58] - C[59], C[79] - C[80], C[101] - C[100], C[122] - C[121], - C[142] - C[143], - C[163] - C[164], C[15] - C[17], C[38] - (15*C[36]) - 16*C[29], C[57] - C[59], C[78] + C[80], - C[99] - C[101], C[122] - C[120], - C[141] - C[143], C[164] - C[162], - C[15] - C[16], C[37] - C[36] - 16*C[33], C[57] - C[58], C[78] + C[79], - C[99] - C[100], C[121] - C[120], C[141] - C[142], C[162] + C[163]],
                     [C[18] + C[19], 16*C[25] - (15*C[39]) - (15*C[40]), C[60] - C[61], C[81] - C[82], C[103] - C[102], C[124] - C[123], - C[144] - C[145], - C[165] - C[166], C[16] - C[19], C[40] - (15*C[37]) - 16*C[30], C[58] - C[61], C[79] + C[82], - C[100] - C[103], C[124] - C[121], - C[142] - C[145], C[166] - C[163], - C[16] - C[18], C[39] - C[37] - 16*C[34], C[58] - C[60], C[79] + C[81], - C[100] - C[102], C[123] - C[121], C[142] - C[144], C[163] + C[165]],
                     [C[13] + C[14], C[34] + C[35], (15*C[56]) - (15*C[55]) - 16*C[44], C[76] - C[77], C[98] - C[97], C[119] - C[118], - C[139] - C[140], - C[160] - C[161], C[12] - C[14], C[33] + C[35], 16*C[49] - (15*C[54]) - C[56], C[75] + C[77], - C[96] - C[98], C[119] - C[117], - C[138] - C[140], C[161] - C[159], - C[12] - C[13], C[34] - C[33], C[54] - 16*C[53] - C[55], C[75] + C[76], - C[96] - C[97], C[118] - C[117], C[138] - C[139], C[159] + C[160]],
                     [C[16] + C[17], C[37] + C[38], (15*C[59]) - (15*C[58]) - 16*C[45], C[79] - C[80], C[101] - C[100], C[122] - C[121], - C[142] - C[143], - C[163] - C[164], C[15] - C[17], C[36] + C[38], 16*C[50] - (15*C[57]) - C[59], C[78] + C[80], - C[99] - C[101], C[122] - C[120], - C[141] - C[143], C[164] - C[162], - C[15] - C[16], C[37] - C[36], C[57] - 16*C[54] - C[58], C[78] + C[79], - C[99] - C[100], C[121] - C[120], C[141] - C[142], C[162] + C[163]],
                     [C[18] + C[19], C[39] + C[40], (15*C[61]) - (15*C[60]) - 16*C[46], C[81] - C[82], C[103] - C[102], C[124] - C[123], - C[144] - C[145], - C[165] - C[166], C[16] - C[19], C[37] + C[40], 16*C[51] - (15*C[58]) - C[61], C[79] + C[82], - C[100] - C[103], C[124] - C[121], - C[142] - C[145], C[166] - C[163], - C[16] - C[18], C[39] - C[37], C[58] - 16*C[55] - C[60], C[79] + C[81], - C[100] - C[102], C[123] - C[121], C[142] - C[144], C[163] + C[165]],
                     [C[13] + C[14], C[34] + C[35], C[55] - C[56], 16*C[65] - (15*C[76]) + (15*C[77]), C[98] - C[97], C[119] - C[118], - C[139] - C[140], - C[160] - C[161], C[12] - C[14], C[33] + C[35], C[54] - C[56], 16*C[70] - (15*C[75]) + C[77], - C[96] - C[98], C[119] - C[117], - C[138] - C[140], C[161] - C[159], - C[12] - C[13], C[34] - C[33], C[54] - C[55], C[75] - 16*C[74] + C[76], - C[96] - C[97], C[118] - C[117], C[138] - C[139], C[159] + C[160]],
                     [C[16] + C[17], C[37] + C[38], C[58] - C[59], 16*C[66] - (15*C[79]) + (15*C[80]), C[101] - C[100], C[122] - C[121], - C[142] - C[143], - C[163] - C[164], C[15] - C[17], C[36] + C[38], C[57] - C[59], 16*C[71] - (15*C[78]) + C[80], - C[99] - C[101], C[122] - C[120], - C[141] - C[143], C[164] - C[162], - C[15] - C[16], C[37] - C[36], C[57] - C[58], C[78] - 16*C[75] + C[79], - C[99] - C[100], C[121] - C[120], C[141] - C[142], C[162] + C[163]],
                     [C[18] + C[19], C[39] + C[40], C[60] - C[61], 16*C[67] - (15*C[81]) + (15*C[82]), C[103] - C[102], C[124] - C[123], - C[144] - C[145], - C[165] - C[166], C[16] - C[19], C[37] + C[40], C[58] - C[61], 16*C[72] - (15*C[79]) + C[82], - C[100] - C[103], C[124] - C[121], - C[142] - C[145], C[166] - C[163], - C[16] - C[18], C[39] - C[37], C[58] - C[60], C[79] - 16*C[76] + C[81], - C[100] - C[102], C[123] - C[121], C[142] - C[144], C[163] + C[165]]]).transpose((2, 3, 0, 1))


def fill_Cmpsa(C):
    return np.array([C[21] + C[0], C[5], C[1], -C[26], -C[22], C[4], C[3], C[2], -C[25], -C[24], -C[23],
                     C[25] + C[4], C[39] + C[18], C[19], C[9], -C[40], -C[30], C[16], C[13], -C[37], -C[34],
                     C[26] + C[5], C[20+21] + C[20+0], C[10], -C[31], C[19], C[17], C[14], -C[40], -C[38], -C[35],
                     C[42] + C[63], -C[47], -C[43], C[68], C[64], C[46], C[45], C[44], -C[67], -C[66], -C[65],
                     C[46] + C[67], C[60] + C[81], -C[61], -C[51], C[82], C[72], C[58], C[55], -C[79], -C[76],
                     C[47] + C[68], C[20+42] + C[20+63], -C[52], C[73], C[61], C[59], C[56], -C[82], -C[80], -C[77],
                     -C[88], -C[87], -C[86], C[109], C[108], C[107], C[84] + C[105], C[89], C[85], -C[110], -C[106],
                     -C[100], -C[97], C[121], C[118], C[88] + C[109], C[102] + C[123], C[103], C[93], -C[124], -C[114],
                     -C[103], -C[101], -C[98], C[124], C[122], C[119], C[89] + C[110], C[20+84] + C[20+105], C[94], -C[115],
                     -C[130], -C[129], -C[128], C[151], C[150], C[149], C[126] + C[147], -C[131], -C[127], C[152], C[148],
                     -C[142], -C[139], C[163], C[160], C[130] + C[151], C[144] + C[165], -C[145], -C[135], C[166], C[156],
                     -C[145], -C[143], -C[140], C[166], C[164], C[161], C[131] + C[152], C[20+126] + C[20+147], -C[136], C[157],
                     C[1], -C[43], C[52] + C[10], C[48] + C[6], C[9], C[8], C[7], -C[51], -C[50], -C[49],
                     C[5], -C[47], C[20+42] + C[20+0], C[52] + C[10], C[19], C[17], C[14], -C[61], -C[59], -C[56],
                     C[3], -C[45], C[59] + C[17], C[50] + C[8], C[57] + C[15], C[16], C[12], -C[58], -C[54],
                     -C[22], C[64], C[31] + C[73], C[27] + C[69], C[30], C[29], C[28], -C[72], -C[71], -C[70],
                     -C[26], C[68], C[20+21] + C[20+63], C[31] + C[73], C[40], C[38], C[35], -C[82], -C[80], -C[77],
                     -C[24], C[66], C[38] + C[80], C[29] + C[71], C[36] + C[78], C[37], C[33], -C[79], -C[75],
                     -C[93], -C[92], -C[91], C[135], C[134], C[133], C[85], -C[127], C[94] + C[136], C[90] + C[132],
                     -C[103], -C[101], -C[98], C[145], C[143], C[140], C[89], -C[131], C[20+84] + C[20+126], C[94] + C[136],
                     -C[100], -C[96], C[142], C[138], C[87], -C[129], C[101] + C[143], C[92] + C[134], C[99] + C[141],
                     -C[114], -C[113], -C[112], C[156], C[155], C[154], -C[106], C[148], C[115] + C[157], C[111] + C[153],
                     -C[124], -C[122], -C[119], C[166], C[164], C[161], -C[110], C[152], C[20+105] + C[20+147], C[115] + C[157],
                     -C[121], -C[117], C[163], C[159], -C[108], C[150], C[122] + C[164], C[113] + C[155], C[120] + C[162],
                     C[2], C[14], C[7], C[13] + C[97], C[12] + C[96], C[11] + C[95], -C[86], -C[98], -C[91],
                     C[3], C[17], C[8], C[16] + C[100], C[15] + C[99], C[12] + C[96], -C[87], -C[101], -C[92],
                     C[4], C[19], C[9], C[18] + C[102], C[16] + C[100], C[13] + C[97], -C[88], -C[103], -C[93],
                     -C[23], C[35], C[28], C[34] + C[118], C[33] + C[117], C[32] + C[116], C[107], -C[119], -C[112],
                     -C[24], C[38], C[29], C[37] + C[121], C[36] + C[120], C[33] + C[117], C[108], -C[122], -C[113],
                     -C[25], C[40], C[30], C[39] + C[123], C[37] + C[121], C[34] + C[118], C[109], -C[124], -C[114],
                     C[44], -C[56], -C[49], C[55] + C[139], C[54] + C[138], C[53] + C[137], -C[128], C[140], C[133],
                     C[45], -C[59], -C[50], C[58] + C[142], C[57] + C[141], C[54] + C[138], -C[129], C[143], C[134],
                     C[46], -C[61], -C[51], C[60] + C[144], C[58] + C[142], C[55] + C[139], -C[130], C[145], C[135],
                     -C[65], -C[77], -C[70], C[76] + C[160], C[75] + C[159], C[74] + C[158], C[149], C[161], C[154],
                     -C[66], -C[80], -C[71], C[79] + C[163], C[78] + C[162], C[75] + C[159], C[150], C[164], C[155],
                     -C[67], -C[82], -C[72], C[81] + C[165], C[79] + C[163], C[76] + C[160], C[151], C[166], C[156]]).transpose((1, 2, 0))


def fill_Dmpsa(C):
    return np.array([C[0] + C[4] + C[5], C[21] - C[25] - C[26], C[1] + C[3], - C[22] - C[24], C[2], -C[23],
                     C[4] + C[19], C[25] - C[40], C[9] + C[16], - C[30] - C[37], C[13] + C[18], C[39] - C[34],
                     C[5] + C[19], C[26] - C[40], C[10] + C[17] + C[20+0], C[20+21] - C[38] - C[31], C[14], -C[35],
                     C[42] + C[46] - C[47], C[63] - C[67] + C[68], C[45] - C[43], C[64] - C[66], C[44], -C[65],
                     C[46] - C[61], C[67] + C[82], C[58] - C[51], C[72] - C[79], C[55] + C[60], C[81] - C[76],
                     C[47] + C[61], C[68] - C[82], C[59] - C[52] + C[20+42], C[73] - C[80] + C[20+63], C[56], -C[77],
                     C[84] - C[88] + C[89], C[105] + C[109] - C[110], C[85] - C[87], C[108] - C[106], -C[86], C[107],
                     C[88] + C[103], C[109] - C[124], C[93] - C[100], C[121] - C[114], C[102] - C[97], C[118] + C[123],
                     C[89] - C[103], C[110] + C[124], C[94] - C[101] + C[20+84], C[122] - C[115] + C[20+105], -C[98], C[119],
                     C[126] - C[130] - C[131], C[147] + C[151] + C[152], - C[127] - C[129], C[148] + C[150], -C[128], C[149],
                     C[130] - C[145], C[151] + C[166], - C[135] - C[142], C[156] + C[163], C[144] - C[139], C[160] + C[165],
                     C[131] - C[145], C[152] + C[166], C[20+126] - C[143] - C[136], C[157] + C[164] + C[20+147], -C[140], C[161],
                     C[1] + C[9] + C[10], C[52] - C[51] - C[43], C[6] + C[8], C[48] - C[50], C[7], -C[49],
                     C[5] + C[19] + C[20+0], C[20+42] - C[61] - C[47], C[10] + C[17], C[52] - C[59], C[14], -C[56],
                     C[3] + C[16] + C[17], C[59] - C[58] - C[45], C[8], C[50], C[12] + C[15], C[57] - C[54],
                     C[30] - C[22] + C[31], C[64] - C[72] + C[73], C[27] + C[29], C[69] - C[71], C[28], -C[70],
                     C[40] - C[26] + C[20+21], C[68] - C[82] + C[20+63], C[31] + C[38], C[73] - C[80], C[35], -C[77],
                     C[37] - C[24] + C[38], C[66] - C[79] + C[80], C[29], C[71], C[33] + C[36], C[78] - C[75],
                     C[85] - C[93] + C[94], C[135] - C[127] + C[136], C[90] - C[92], C[132] + C[134], -C[91], C[133],
                     C[89] - C[103] + C[20+84], C[145] - C[131] + C[20+126], C[94] - C[101], C[136] + C[143], -C[98], C[140],
                     C[87] - C[100] + C[101], C[142] - C[129] + C[143], C[92], C[134], C[99] - C[96], C[138] + C[141],
                     C[115] - C[114] - C[106], C[148] + C[156] + C[157], C[111] - C[113], C[153] + C[155], -C[112], C[154],
                     C[20+105] - C[124] - C[110], C[152] + C[166] + C[20+147], C[115] - C[122], C[157] + C[164], -C[119], C[161],
                     C[122] - C[121] - C[108], C[150] + C[163] + C[164], C[113], C[155], C[120] - C[117], C[159] + C[162],
                     C[2] + C[13] + C[14], C[97] - C[86] - C[98], C[7] + C[12], C[96] - C[91], C[11], C[95],
                     C[3] + C[16] + C[17], C[100] - C[87] - C[101], C[8] + C[15], C[99] - C[92], C[12], C[96],
                     C[4] + C[18] + C[19], C[102] - C[88] - C[103], C[9] + C[16], C[100] - C[93], C[13], C[97],
                     C[34] - C[23] + C[35], C[107] + C[118] - C[119], C[28] + C[33], C[117] - C[112], C[32], C[116],
                     C[37] - C[24] + C[38], C[108] + C[121] - C[122], C[29] + C[36], C[120] - C[113], C[33], C[117],
                     C[39] - C[25] + C[40], C[109] + C[123] - C[124], C[30] + C[37], C[121] - C[114], C[34], C[118],
                     C[44] + C[55] - C[56], C[139] - C[128] + C[140], C[54] - C[49], C[133] + C[138], C[53], C[137],
                     C[45] + C[58] - C[59], C[142] - C[129] + C[143], C[57] - C[50], C[134] + C[141], C[54], C[138],
                     C[46] + C[60] - C[61], C[144] - C[130] + C[145], C[58] - C[51], C[135] + C[142], C[55], C[139],
                     C[76] - C[65] - C[77], C[149] + C[160] + C[161], C[75] - C[70], C[154] + C[159], C[74], C[158],
                     C[79] - C[66] - C[80], C[150] + C[163] + C[164], C[78] - C[71], C[155] + C[162], C[75], C[159],
                     C[81] - C[67] - C[82], C[151] + C[165] + C[166], C[79] - C[72], C[156] + C[163], C[76], C[160]])
