# Copyright 2015 Hewlett-Packard Development Company, L.P.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import six
import sys

import mock
from oslo_utils import importutils

ironic_python_agent = importutils.try_import('ironic_python_agent')
if not ironic_python_agent:
    ipa_mock = mock.MagicMock()
    sys.modules['ironic_python_agent'] = ipa_mock
    sys.modules['ironic_python_agent.errors'] = ipa_mock.errors
    sys.modules['ironic_python_agent.hardware'] = ipa_mock.hardware
    ipa_mock.hardware.GenericHardwareManager = mock.MagicMock
    mock.MagicMock.erase_devices = mock.MagicMock(name='erase_devices')
    if 'proliantutils.ipa_hw_manager' in sys.modules:
        six.moves.reload_module('proliantutils.ipa_hw_manager')
