DATA = {
  "Examples": [],
  "dist": "potranslator-1.1.5-py_0",
  "python-scripts": [
    "potranslator"
  ],
  "site-packages": [
    "potranslator/locale_dir/lb/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ar/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mk/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ms/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/fi/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/eu/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/sv/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ku/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mk/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/sr/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/hi/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/jw/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/kn/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ro/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ne/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/mg/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/zh-TW/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/hy/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/es/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ig/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/te/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/af/LC_MESSAGES/potranslator.mo",
    "potranslator/basic.py",
    "potranslator/locale_dir/nl/LC_MESSAGES/potranslator.mo",
    "potranslator-1.1.5.dist-info/top_level.txt",
    "potranslator/locale_dir/xh/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/xh/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/gd/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/km/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/lv/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/so/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/lo/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ga/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/is/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/sw/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/pt/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/sl/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ta/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ko/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/la/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/sr/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/pl/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/gl/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/fr/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/be/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/uk/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ny/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/iw/LC_MESSAGES/potranslator.po",
    "potranslator/__init__.py",
    "potranslator/locale_dir/sd/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/si/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mt/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/sk/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/kk/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ku/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/mr/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ig/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/it/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/no/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/et/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/bs/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/hmn/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/pl/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/fr/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/lb/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/yi/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/hmn/LC_MESSAGES/potranslator.mo",
    "potranslator/commands.py",
    "potranslator/locale_dir/pa/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mn/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/sd/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ka/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/hu/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/sm/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/km/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ky/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/sv/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/bg/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/sq/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/st/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/da/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/am/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/fa/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/tl/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/vi/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/sn/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/de/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ky/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/gu/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/sw/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ha/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mi/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/eo/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/hy/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ml/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ps/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ga/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/nl/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/tr/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/hr/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/id/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ur/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/zh-CN/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/si/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ml/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/gu/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/hi/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mi/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/haw/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/th/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/so/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/bs/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/zh-CN/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ne/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/zu/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/th/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mt/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/tg/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/te/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/am/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/be/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/fy/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/kn/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/bn/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/gd/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ha/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ht/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/az/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/__init__.py",
    "potranslator-1.1.5.dist-info/RECORD",
    "potranslator/locale_dir/kk/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ja/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mg/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/pa/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/co/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ceb/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ur/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ja/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/my/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/it/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/uz/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ca/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/lt/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ceb/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/da/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/el/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/no/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mr/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/st/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/pt/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/la/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/eu/LC_MESSAGES/potranslator.po",
    "potranslator/pycompat.py",
    "potranslator/locale_dir/ka/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/cs/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ta/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/lv/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/tl/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/hr/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/yi/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/cs/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/uk/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/hu/LC_MESSAGES/potranslator.po",
    "potranslator/transifex.py",
    "potranslator/locale_dir/ms/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/fy/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/uz/LC_MESSAGES/potranslator.po",
    "potranslator/potranslator.py",
    "potranslator/locale_dir/cy/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/es/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/de/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/haw/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ny/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/tr/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/su/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/tg/LC_MESSAGES/potranslator.po",
    "potranslator-1.1.5.dist-info/entry_points.txt",
    "potranslator/locale_dir/eo/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ko/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/iw/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/zh-TW/LC_MESSAGES/potranslator.po",
    "potranslator/supported_languages.json",
    "potranslator/locale_dir/sq/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/co/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ps/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/vi/LC_MESSAGES/potranslator.po",
    "potranslator-1.1.5.dist-info/INSTALLER",
    "potranslator/locale_dir/sk/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/et/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/sm/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/sn/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ro/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/potranslator.pot",
    "potranslator/locale_dir/fi/LC_MESSAGES/potranslator.po",
    "potranslator-1.1.5.dist-info/METADATA",
    "potranslator/locale_dir/bg/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/bn/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/af/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ht/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/lt/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ru/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/ru/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/sl/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/id/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/el/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/is/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/jw/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/my/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/mn/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/zu/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/az/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/fa/LC_MESSAGES/potranslator.po",
    "potranslator-1.1.5.dist-info/WHEEL",
    "potranslator/locale_dir/ca/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/ar/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/yo/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/su/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/yo/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/gl/LC_MESSAGES/potranslator.po",
    "potranslator/locale_dir/lo/LC_MESSAGES/potranslator.mo",
    "potranslator/locale_dir/cy/LC_MESSAGES/potranslator.mo"
  ]
}
## END DATA

"""
This is code that is added to noarch Python packages. See
conda_build/noarch_python.py.

"""
import os
from os.path import dirname, exists, isdir, join, normpath
import re
import sys
import shutil


# Silence pyflakes. This variable is added when link.py is written by
# conda_build.noarch_python.
if False:
    DATA = None

THIS_DIR = dirname(__file__)
PREFIX = normpath(sys.prefix)
if sys.platform == 'win32':
    BIN_DIR = join(PREFIX, 'Scripts')
    SITE_PACKAGES = 'Lib/site-packages'
else:
    BIN_DIR = join(PREFIX, 'bin')
    SITE_PACKAGES = 'lib/python%s/site-packages' % sys.version[:3]

# the list of these files is going to be store in info/_files
FILES = []

# three capture groups: whole_shebang, executable, options
SHEBANG_REGEX = (br'^(#!'  # pretty much the whole match string
                 br'(?:[ ]*)'  # allow spaces between #! and beginning of the executable path
                 br'(/(?:\\ |[^ \n\r\t])*)'  # the executable is the next text block without an escaped space or non-space whitespace character  # NOQA
                 br'(.*)'  # the rest of the line can contain option flags
                 br')$')  # end whole_shebang group


def _link(src, dst):
    try:
        os.link(src, dst)
        # on Windows os.link raises AttributeError
    except (OSError, AttributeError):
        shutil.copy2(src, dst)


def _unlink(path):
    try:
        os.unlink(path)
    except OSError:
        pass


def pyc_f(f, version_info=sys.version_info):
    if version_info[0] == 2:
        return f + 'c'
    dn, fn = f.rsplit('/', 1)
    return '%s/__pycache__/%s.cpython-%d%d.pyc' % (
              dn, fn[:-3], version_info[0], version_info[1])


def link_files(src_root, dst_root, files):
    for f in files:
        src = join(THIS_DIR, src_root, f)
        dst = join(PREFIX, dst_root, f)
        dst_dir = dirname(dst)
        if not isdir(dst_dir):
            os.makedirs(dst_dir)
        if exists(dst):
            _unlink(dst)
        _link(src, dst)
        f = '%s/%s' % (dst_root, f)
        FILES.append(f)
        if f.endswith('.py'):
            FILES.append(pyc_f(f))


# yanked from conda
def replace_long_shebang(data):
    # this function only changes a shebang line if it exists and is greater than 127 characters
    if hasattr(data, 'encode'):
        data = data.encode()
    shebang_match = re.match(SHEBANG_REGEX, data, re.MULTILINE)
    if shebang_match:
        whole_shebang, executable, options = shebang_match.groups()
        if len(whole_shebang) > 127:
            executable_name = executable.decode('utf-8').split('/')[-1]
            new_shebang = '#!/usr/bin/env %s%s' % (executable_name, options.decode('utf-8'))
            data = data.replace(whole_shebang, new_shebang.encode('utf-8'))
    if hasattr(data, 'decode'):
        data = data.decode()
    return data


def create_script(fn):
    src = join(THIS_DIR, 'python-scripts', fn)
    dst = join(BIN_DIR, fn)
    if sys.platform == 'win32':
        shutil.copy2(src, dst + '-script.py')
        FILES.append('Scripts/%s-script.py' % fn)
        shutil.copy2(join(THIS_DIR,
                          'cli-%d.exe' % (8 * tuple.__itemsize__)),
                     dst + '.exe')
        FILES.append('Scripts/%s.exe' % fn)
    else:
        with open(src) as fi:
            data = fi.read()
        with open(dst, 'w') as fo:
            shebang = replace_long_shebang('#!%s\n' % normpath(sys.executable))
            fo.write(shebang)
            fo.write(data)
        os.chmod(dst, 0o775)
        FILES.append('bin/%s' % fn)


def create_scripts(files):
    if not files:
        return
    if not isdir(BIN_DIR):
        os.mkdir(BIN_DIR)
    for fn in files:
        create_script(fn)


def main():
    create_scripts(DATA['python-scripts'])
    link_files('site-packages', SITE_PACKAGES, DATA['site-packages'])
    link_files('Examples', 'Examples', DATA['Examples'])

    with open(join(PREFIX, 'conda-meta',
                   '%s.files' % DATA['dist']), 'w') as fo:
        for f in FILES:
            fo.write('%s\n' % f)


if __name__ == '__main__':
    main()
