# coding: utf-8

__all__ = ['atomicdata']

from io import StringIO

import pandas as pd

# This is the processed and reduced data from https://www.nist.gov/pml/atomic-weights-and-isotopic-compositions-relative-atomic-masses
atomicdatacsv = StringIO('\n'.join([
    'Atomic Number,Atomic Symbol,Mass Number,Relative Atomic Mass,Isotopic Composition,Standard Atomic Weight,Notes',
    '1,H,1,1.00782503223(9),0.999885(70),"[1.00784,1.00811]",m',
    '1,D,2,2.01410177812(12),0.000115(70),"[1.00784,1.00811]",m',
    '1,T,3,3.0160492779(24),,"[1.00784,1.00811]",m',
    '1,H,4,4.02643(11),,"[1.00784,1.00811]",m',
    '1,H,5,5.035311(96),,"[1.00784,1.00811]",m',
    '1,H,6,6.04496(27),,"[1.00784,1.00811]",m',
    '1,H,7,7.0527(11#),,"[1.00784,1.00811]",m',
    '2,He,3,3.0160293201(25),0.00000134(3),4.002602(2),"g,r"',
    '2,He,4,4.00260325413(6),0.99999866(3),4.002602(2),"g,r"',
    '2,He,5,5.012057(21),,4.002602(2),"g,r"',
    '2,He,6,6.018885891(57),,4.002602(2),"g,r"',
    '2,He,7,7.0279907(81),,4.002602(2),"g,r"',
    '2,He,8,8.033934390(95),,4.002602(2),"g,r"',
    '2,He,9,9.043946(50),,4.002602(2),"g,r"',
    '2,He,10,10.05279(11),,4.002602(2),"g,r"',
    '3,Li,3,3.0308(21#),,"[6.938,6.997]",m',
    '3,Li,4,4.02719(23),,"[6.938,6.997]",m',
    '3,Li,5,5.012538(54),,"[6.938,6.997]",m',
    '3,Li,6,6.0151228874(16),0.0759(4),"[6.938,6.997]",m',
    '3,Li,7,7.0160034366(45),0.9241(4),"[6.938,6.997]",m',
    '3,Li,8,8.022486246(50),,"[6.938,6.997]",m',
    '3,Li,9,9.02679019(20),,"[6.938,6.997]",m',
    '3,Li,10,10.035483(14),,"[6.938,6.997]",m',
    '3,Li,11,11.04372358(66),,"[6.938,6.997]",m',
    '3,Li,12,12.052517(16),,"[6.938,6.997]",m',
    '3,Li,13,13.06263(38),,"[6.938,6.997]",m',
    '4,Be,5,5.0399(22#),,9.0121831(5),',
    '4,Be,6,6.0197264(58),,9.0121831(5),',
    '4,Be,7,7.016928717(76),,9.0121831(5),',
    '4,Be,8,8.005305102(37),,9.0121831(5),',
    '4,Be,9,9.012183065(82),1,9.0121831(5),',
    '4,Be,10,10.013534695(86),,9.0121831(5),',
    '4,Be,11,11.02166108(26),,9.0121831(5),',
    '4,Be,12,12.0269221(20),,9.0121831(5),',
    '4,Be,13,13.036135(11),,9.0121831(5),',
    '4,Be,14,14.04289(14),,9.0121831(5),',
    '4,Be,15,15.05342(43#),,9.0121831(5),',
    '4,Be,16,16.06167(18),,9.0121831(5),',
    '5,B,6,6.0508(22#),,"[10.806,10.821]",m',
    '5,B,7,7.029712(27),,"[10.806,10.821]",m',
    '5,B,8,8.0246073(11),,"[10.806,10.821]",m',
    '5,B,9,9.01332965(97),,"[10.806,10.821]",m',
    '5,B,10,10.01293695(41),0.199(7),"[10.806,10.821]",m',
    '5,B,11,11.00930536(45),0.801(7),"[10.806,10.821]",m',
    '5,B,12,12.0143527(14),,"[10.806,10.821]",m',
    '5,B,13,13.0177802(12),,"[10.806,10.821]",m',
    '5,B,14,14.025404(23),,"[10.806,10.821]",m',
    '5,B,15,15.031088(23),,"[10.806,10.821]",m',
    '5,B,16,16.039842(26),,"[10.806,10.821]",m',
    '5,B,17,17.04699(18),,"[10.806,10.821]",m',
    '5,B,18,18.05566(18),,"[10.806,10.821]",m',
    '5,B,19,19.06310(43#),,"[10.806,10.821]",m',
    '5,B,20,20.07207(75#),,"[10.806,10.821]",m',
    '5,B,21,21.08129(97#),,"[10.806,10.821]",m',
    '6,C,8,8.037643(20),,"[12.0096,12.0116]",',
    '6,C,9,9.0310372(23),,"[12.0096,12.0116]",',
    '6,C,10,10.01685331(42),,"[12.0096,12.0116]",',
    '6,C,11,11.0114336(10),,"[12.0096,12.0116]",',
    '6,C,12,12.0000000(00),0.9893(8),"[12.0096,12.0116]",',
    '6,C,13,13.00335483507(23),0.0107(8),"[12.0096,12.0116]",',
    '6,C,14,14.0032419884(40),,"[12.0096,12.0116]",',
    '6,C,15,15.01059926(86),,"[12.0096,12.0116]",',
    '6,C,16,16.0147013(38),,"[12.0096,12.0116]",',
    '6,C,17,17.022577(19),,"[12.0096,12.0116]",',
    '6,C,18,18.026751(32),,"[12.0096,12.0116]",',
    '6,C,19,19.03480(11),,"[12.0096,12.0116]",',
    '6,C,20,20.04032(26),,"[12.0096,12.0116]",',
    '6,C,21,21.04900(43#),,"[12.0096,12.0116]",',
    '6,C,22,22.05753(26),,"[12.0096,12.0116]",',
    '6,C,23,23.0689(11#),,"[12.0096,12.0116]",',
    '7,N,10,10.04165(43),,"[14.00643,14.00728]",',
    '7,N,11,11.026091(50),,"[14.00643,14.00728]",',
    '7,N,12,12.0186132(11),,"[14.00643,14.00728]",',
    '7,N,13,13.00573861(29),,"[14.00643,14.00728]",',
    '7,N,14,14.00307400443(20),0.99636(20),"[14.00643,14.00728]",',
    '7,N,15,15.00010889888(64),0.00364(20),"[14.00643,14.00728]",',
    '7,N,16,16.0061019(25),,"[14.00643,14.00728]",',
    '7,N,17,17.008449(16),,"[14.00643,14.00728]",',
    '7,N,18,18.014078(20),,"[14.00643,14.00728]",',
    '7,N,19,19.017022(18),,"[14.00643,14.00728]",',
    '7,N,20,20.023366(60),,"[14.00643,14.00728]",',
    '7,N,21,21.02711(10),,"[14.00643,14.00728]",',
    '7,N,22,22.03439(21),,"[14.00643,14.00728]",',
    '7,N,23,23.04114(32#),,"[14.00643,14.00728]",',
    '7,N,24,24.05039(43#),,"[14.00643,14.00728]",',
    '7,N,25,25.06010(54#),,"[14.00643,14.00728]",',
    '8,O,12,12.034262(26),,"[15.99903,15.99977]",',
    '8,O,13,13.024815(10),,"[15.99903,15.99977]",',
    '8,O,14,14.00859636(12),,"[15.99903,15.99977]",',
    '8,O,15,15.00306562(53),,"[15.99903,15.99977]",',
    '8,O,16,15.99491461957(17),0.99757(16),"[15.99903,15.99977]",',
    '8,O,17,16.99913175650(69),0.00038(1),"[15.99903,15.99977]",',
    '8,O,18,17.99915961286(76),0.00205(14),"[15.99903,15.99977]",',
    '8,O,19,19.0035780(28),,"[15.99903,15.99977]",',
    '8,O,20,20.00407535(95),,"[15.99903,15.99977]",',
    '8,O,21,21.008655(13),,"[15.99903,15.99977]",',
    '8,O,22,22.009966(61),,"[15.99903,15.99977]",',
    '8,O,23,23.015696(97),,"[15.99903,15.99977]",',
    '8,O,24,24.01986(12),,"[15.99903,15.99977]",',
    '8,O,25,25.02936(12),,"[15.99903,15.99977]",',
    '8,O,26,26.03729(17),,"[15.99903,15.99977]",',
    '8,O,27,27.04772(54#),,"[15.99903,15.99977]",',
    '8,O,28,28.05591(75#),,"[15.99903,15.99977]",',
    '9,F,14,14.034315(44),,18.998403163(6),',
    '9,F,15,15.018043(67),,18.998403163(6),',
    '9,F,16,16.0114657(89),,18.998403163(6),',
    '9,F,17,17.00209524(27),,18.998403163(6),',
    '9,F,18,18.00093733(50),,18.998403163(6),',
    '9,F,19,18.99840316273(92),1,18.998403163(6),',
    '9,F,20,19.999981252(31),,18.998403163(6),',
    '9,F,21,20.9999489(19),,18.998403163(6),',
    '9,F,22,22.002999(13),,18.998403163(6),',
    '9,F,23,23.003557(54),,18.998403163(6),',
    '9,F,24,24.008115(78),,18.998403163(6),',
    '9,F,25,25.012199(81),,18.998403163(6),',
    '9,F,26,26.020038(83),,18.998403163(6),',
    '9,F,27,27.02644(20),,18.998403163(6),',
    '9,F,28,28.03534(21),,18.998403163(6),',
    '9,F,29,29.04254(54#),,18.998403163(6),',
    '9,F,30,30.05165(64#),,18.998403163(6),',
    '9,F,31,31.05971(56#),,18.998403163(6),',
    '10,Ne,16,16.025750(22),,20.1797(6),"g,m"',
    '10,Ne,17,17.01771396(38),,20.1797(6),"g,m"',
    '10,Ne,18,18.00570870(39),,20.1797(6),"g,m"',
    '10,Ne,19,19.00188091(17),,20.1797(6),"g,m"',
    '10,Ne,20,19.9924401762(17),0.9048(3),20.1797(6),"g,m"',
    '10,Ne,21,20.993846685(41),0.0027(1),20.1797(6),"g,m"',
    '10,Ne,22,21.991385114(18),0.0925(3),20.1797(6),"g,m"',
    '10,Ne,23,22.99446691(11),,20.1797(6),"g,m"',
    '10,Ne,24,23.99361065(55),,20.1797(6),"g,m"',
    '10,Ne,25,24.997789(48),,20.1797(6),"g,m"',
    '10,Ne,26,26.000515(20),,20.1797(6),"g,m"',
    '10,Ne,27,27.007553(70),,20.1797(6),"g,m"',
    '10,Ne,28,28.01212(10),,20.1797(6),"g,m"',
    '10,Ne,29,29.01975(11),,20.1797(6),"g,m"',
    '10,Ne,30,30.02473(30),,20.1797(6),"g,m"',
    '10,Ne,31,31.0331(17),,20.1797(6),"g,m"',
    '10,Ne,32,32.03972(54#),,20.1797(6),"g,m"',
    '10,Ne,33,33.04938(64#),,20.1797(6),"g,m"',
    '10,Ne,34,34.05673(55#),,20.1797(6),"g,m"',
    '11,Na,18,18.02688(12),,22.98976928(2),',
    '11,Na,19,19.013880(11),,22.98976928(2),',
    '11,Na,20,20.0073544(12),,22.98976928(2),',
    '11,Na,21,20.99765469(30),,22.98976928(2),',
    '11,Na,22,21.99443741(18),,22.98976928(2),',
    '11,Na,23,22.9897692820(19),1,22.98976928(2),',
    '11,Na,24,23.990962950(38),,22.98976928(2),',
    '11,Na,25,24.9899540(13),,22.98976928(2),',
    '11,Na,26,25.9926346(38),,22.98976928(2),',
    '11,Na,27,26.9940765(40),,22.98976928(2),',
    '11,Na,28,27.998939(11),,22.98976928(2),',
    '11,Na,29,29.0028771(79),,22.98976928(2),',
    '11,Na,30,30.0090979(51),,22.98976928(2),',
    '11,Na,31,31.013163(25),,22.98976928(2),',
    '11,Na,32,32.02019(13),,22.98976928(2),',
    '11,Na,33,33.02573(64#),,22.98976928(2),',
    '11,Na,34,34.03359(54#),,22.98976928(2),',
    '11,Na,35,35.04062(63#),,22.98976928(2),',
    '11,Na,36,36.04929(64#),,22.98976928(2),',
    '11,Na,37,37.05705(65#),,22.98976928(2),',
    '12,Mg,19,19.034169(54),,"[24.304,24.307]",',
    '12,Mg,20,20.018850(29),,"[24.304,24.307]",',
    '12,Mg,21,21.011716(18),,"[24.304,24.307]",',
    '12,Mg,22,21.99957065(34),,"[24.304,24.307]",',
    '12,Mg,23,22.99412421(74),,"[24.304,24.307]",',
    '12,Mg,24,23.985041697(14),0.7899(4),"[24.304,24.307]",',
    '12,Mg,25,24.985836976(50),0.1000(1),"[24.304,24.307]",',
    '12,Mg,26,25.982592968(31),0.1101(3),"[24.304,24.307]",',
    '12,Mg,27,26.984340624(53),,"[24.304,24.307]",',
    '12,Mg,28,27.9838767(22),,"[24.304,24.307]",',
    '12,Mg,29,28.988617(12),,"[24.304,24.307]",',
    '12,Mg,30,29.9904629(37),,"[24.304,24.307]",',
    '12,Mg,31,30.9966480(33),,"[24.304,24.307]",',
    '12,Mg,32,31.9991102(34),,"[24.304,24.307]",',
    '12,Mg,33,33.0053271(31),,"[24.304,24.307]",',
    '12,Mg,34,34.008935(31),,"[24.304,24.307]",',
    '12,Mg,35,35.01679(19),,"[24.304,24.307]",',
    '12,Mg,36,36.02188(49),,"[24.304,24.307]",',
    '12,Mg,37,37.03037(54#),,"[24.304,24.307]",',
    '12,Mg,38,38.03658(54#),,"[24.304,24.307]",',
    '12,Mg,39,39.04538(55#),,"[24.304,24.307]",',
    '12,Mg,40,40.05218(64#),,"[24.304,24.307]",',
    '13,Al,21,21.02897(43#),,26.9815385(7),',
    '13,Al,22,22.01954(43#),,26.9815385(7),',
    '13,Al,23,23.00724435(37),,26.9815385(7),',
    '13,Al,24,23.9999489(12),,26.9815385(7),',
    '13,Al,25,24.99042810(51),,26.9815385(7),',
    '13,Al,26,25.986891904(69),,26.9815385(7),',
    '13,Al,27,26.98153853(11),1,26.9815385(7),',
    '13,Al,28,27.98191021(13),,26.9815385(7),',
    '13,Al,29,28.9804565(10),,26.9815385(7),',
    '13,Al,30,29.982960(15),,26.9815385(7),',
    '13,Al,31,30.983945(22),,26.9815385(7),',
    '13,Al,32,31.988085(13),,26.9815385(7),',
    '13,Al,33,32.990909(81),,26.9815385(7),',
    '13,Al,34,33.996705(74),,26.9815385(7),',
    '13,Al,35,34.999764(75),,26.9815385(7),',
    '13,Al,36,36.00639(11),,26.9815385(7),',
    '13,Al,37,37.01053(13),,26.9815385(7),',
    '13,Al,38,38.01740(27),,26.9815385(7),',
    '13,Al,39,39.02254(54#),,26.9815385(7),',
    '13,Al,40,40.03003(54#),,26.9815385(7),',
    '13,Al,41,41.03638(64#),,26.9815385(7),',
    '13,Al,42,42.04384(64#),,26.9815385(7),',
    '13,Al,43,43.05147(75#),,26.9815385(7),',
    '14,Si,22,22.03579(54#),,"[28.084,28.086]",',
    '14,Si,23,23.02544(54#),,"[28.084,28.086]",',
    '14,Si,24,24.011535(21),,"[28.084,28.086]",',
    '14,Si,25,25.004109(11),,"[28.084,28.086]",',
    '14,Si,26,25.99233384(11),,"[28.084,28.086]",',
    '14,Si,27,26.98670481(15),,"[28.084,28.086]",',
    '14,Si,28,27.97692653465(44),0.92223(19),"[28.084,28.086]",',
    '14,Si,29,28.97649466490(52),0.04685(8),"[28.084,28.086]",',
    '14,Si,30,29.973770136(23),0.03092(11),"[28.084,28.086]",',
    '14,Si,31,30.975363194(46),,"[28.084,28.086]",',
    '14,Si,32,31.97415154(32),,"[28.084,28.086]",',
    '14,Si,33,32.97797696(75),,"[28.084,28.086]",',
    '14,Si,34,33.978576(15),,"[28.084,28.086]",',
    '14,Si,35,34.984583(41),,"[28.084,28.086]",',
    '14,Si,36,35.986695(77),,"[28.084,28.086]",',
    '14,Si,37,36.992921(89),,"[28.084,28.086]",',
    '14,Si,38,37.995523(75),,"[28.084,28.086]",',
    '14,Si,39,39.002491(97),,"[28.084,28.086]",',
    '14,Si,40,40.00583(25),,"[28.084,28.086]",',
    '14,Si,41,41.01301(40),,"[28.084,28.086]",',
    '14,Si,42,42.01778(54#),,"[28.084,28.086]",',
    '14,Si,43,43.02480(64#),,"[28.084,28.086]",',
    '14,Si,44,44.03061(64#),,"[28.084,28.086]",',
    '14,Si,45,45.03995(75#),,"[28.084,28.086]",',
    '15,P,24,24.03577(54#),,30.973761998(5),',
    '15,P,25,25.02119(43#),,30.973761998(5),',
    '15,P,26,26.01178(21#),,30.973761998(5),',
    '15,P,27,26.999224(28),,30.973761998(5),',
    '15,P,28,27.9923266(12),,30.973761998(5),',
    '15,P,29,28.98180079(60),,30.973761998(5),',
    '15,P,30,29.97831375(34),,30.973761998(5),',
    '15,P,31,30.97376199842(70),1,30.973761998(5),',
    '15,P,32,31.973907643(42),,30.973761998(5),',
    '15,P,33,32.9717257(12),,30.973761998(5),',
    '15,P,34,33.97364589(87),,30.973761998(5),',
    '15,P,35,34.9733141(20),,30.973761998(5),',
    '15,P,36,35.978260(14),,30.973761998(5),',
    '15,P,37,36.979607(41),,30.973761998(5),',
    '15,P,38,37.984252(93),,30.973761998(5),',
    '15,P,39,38.986227(98),,30.973761998(5),',
    '15,P,40,39.99133(12),,30.973761998(5),',
    '15,P,41,40.994654(86),,30.973761998(5),',
    '15,P,42,42.00108(23),,30.973761998(5),',
    '15,P,43,43.00502(40),,30.973761998(5),',
    '15,P,44,44.01121(54#),,30.973761998(5),',
    '15,P,45,45.01645(64#),,30.973761998(5),',
    '15,P,46,46.02446(75#),,30.973761998(5),',
    '15,P,47,47.03139(86#),,30.973761998(5),',
    '16,S,26,26.02907(64#),,"[32.059,32.076]",',
    '16,S,27,27.01828(43#),,"[32.059,32.076]",',
    '16,S,28,28.00437(17),,"[32.059,32.076]",',
    '16,S,29,28.996611(54),,"[32.059,32.076]",',
    '16,S,30,29.98490703(40),,"[32.059,32.076]",',
    '16,S,31,30.97955701(25),,"[32.059,32.076]",',
    '16,S,32,31.9720711744(14),0.9499(26),"[32.059,32.076]",',
    '16,S,33,32.9714589098(15),0.0075(2),"[32.059,32.076]",',
    '16,S,34,33.967867004(47),0.0425(24),"[32.059,32.076]",',
    '16,S,35,34.969032310(43),,"[32.059,32.076]",',
    '16,S,36,35.96708071(20),0.0001(1),"[32.059,32.076]",',
    '16,S,37,36.97112551(21),,"[32.059,32.076]",',
    '16,S,38,37.9711633(77),,"[32.059,32.076]",',
    '16,S,39,38.975134(54),,"[32.059,32.076]",',
    '16,S,40,39.9754826(43),,"[32.059,32.076]",',
    '16,S,41,40.9795935(44),,"[32.059,32.076]",',
    '16,S,42,41.9810651(30),,"[32.059,32.076]",',
    '16,S,43,42.9869076(53),,"[32.059,32.076]",',
    '16,S,44,43.9901188(56),,"[32.059,32.076]",',
    '16,S,45,44.99572(74),,"[32.059,32.076]",',
    '16,S,46,46.00004(54#),,"[32.059,32.076]",',
    '16,S,47,47.00795(54#),,"[32.059,32.076]",',
    '16,S,48,48.01370(64#),,"[32.059,32.076]",',
    '16,S,49,49.02276(72#),,"[32.059,32.076]",',
    '17,Cl,28,28.02954(64#),,"[35.446,35.457]",m',
    '17,Cl,29,29.01478(43#),,"[35.446,35.457]",m',
    '17,Cl,30,30.00477(21#),,"[35.446,35.457]",m',
    '17,Cl,31,30.992414(54),,"[35.446,35.457]",m',
    '17,Cl,32,31.98568464(60),,"[35.446,35.457]",m',
    '17,Cl,33,32.97745199(42),,"[35.446,35.457]",m',
    '17,Cl,34,33.973762485(52),,"[35.446,35.457]",m',
    '17,Cl,35,34.968852682(37),0.7576(10),"[35.446,35.457]",m',
    '17,Cl,36,35.968306809(38),,"[35.446,35.457]",m',
    '17,Cl,37,36.965902602(55),0.2424(10),"[35.446,35.457]",m',
    '17,Cl,38,37.96801044(11),,"[35.446,35.457]",m',
    '17,Cl,39,38.9680082(19),,"[35.446,35.457]",m',
    '17,Cl,40,39.970415(34),,"[35.446,35.457]",m',
    '17,Cl,41,40.970685(74),,"[35.446,35.457]",m',
    '17,Cl,42,41.97325(15),,"[35.446,35.457]",m',
    '17,Cl,43,42.97389(10),,"[35.446,35.457]",m',
    '17,Cl,44,43.97787(20),,"[35.446,35.457]",m',
    '17,Cl,45,44.98029(11),,"[35.446,35.457]",m',
    '17,Cl,46,45.98517(17),,"[35.446,35.457]",m',
    '17,Cl,47,46.98916(43#),,"[35.446,35.457]",m',
    '17,Cl,48,47.99564(54#),,"[35.446,35.457]",m',
    '17,Cl,49,49.00123(64#),,"[35.446,35.457]",m',
    '17,Cl,50,50.00905(64#),,"[35.446,35.457]",m',
    '17,Cl,51,51.01554(75#),,"[35.446,35.457]",m',
    '18,Ar,30,30.02307(54#),,39.948(1),"g,r"',
    '18,Ar,31,31.01212(22#),,39.948(1),"g,r"',
    '18,Ar,32,31.9976378(19),,39.948(1),"g,r"',
    '18,Ar,33,32.98992555(43),,39.948(1),"g,r"',
    '18,Ar,34,33.980270090(83),,39.948(1),"g,r"',
    '18,Ar,35,34.97525759(80),,39.948(1),"g,r"',
    '18,Ar,36,35.967545105(28),0.003336(21),39.948(1),"g,r"',
    '18,Ar,37,36.96677633(22),,39.948(1),"g,r"',
    '18,Ar,38,37.96273211(21),0.000629(7),39.948(1),"g,r"',
    '18,Ar,39,38.9643130(54),,39.948(1),"g,r"',
    '18,Ar,40,39.9623831237(24),0.996035(25),39.948(1),"g,r"',
    '18,Ar,41,40.96450057(37),,39.948(1),"g,r"',
    '18,Ar,42,41.9630457(62),,39.948(1),"g,r"',
    '18,Ar,43,42.9656361(57),,39.948(1),"g,r"',
    '18,Ar,44,43.9649238(17),,39.948(1),"g,r"',
    '18,Ar,45,44.96803973(55),,39.948(1),"g,r"',
    '18,Ar,46,45.968083(44),,39.948(1),"g,r"',
    '18,Ar,47,46.972935(96),,39.948(1),"g,r"',
    '18,Ar,48,47.97591(32#),,39.948(1),"g,r"',
    '18,Ar,49,48.98190(43#),,39.948(1),"g,r"',
    '18,Ar,50,49.98613(54#),,39.948(1),"g,r"',
    '18,Ar,51,50.99370(64#),,39.948(1),"g,r"',
    '18,Ar,52,51.99896(64#),,39.948(1),"g,r"',
    '18,Ar,53,53.00729(75#),,39.948(1),"g,r"',
    '19,K,32,32.02265(54#),,39.0983(1),',
    '19,K,33,33.00756(21#),,39.0983(1),',
    '19,K,34,33.99869(32#),,39.0983(1),',
    '19,K,35,34.98800541(55),,39.0983(1),',
    '19,K,36,35.98130201(37),,39.0983(1),',
    '19,K,37,36.97337589(10),,39.0983(1),',
    '19,K,38,37.96908112(21),,39.0983(1),',
    '19,K,39,38.9637064864(49),0.932581(44),39.0983(1),',
    '19,K,40,39.963998166(60),0.000117(1),39.0983(1),',
    '19,K,41,40.9618252579(41),0.067302(44),39.0983(1),',
    '19,K,42,41.96240231(11),,39.0983(1),',
    '19,K,43,42.96073470(44),,39.0983(1),',
    '19,K,44,43.96158699(45),,39.0983(1),',
    '19,K,45,44.96069149(56),,39.0983(1),',
    '19,K,46,45.96198159(78),,39.0983(1),',
    '19,K,47,46.9616616(15),,39.0983(1),',
    '19,K,48,47.96534119(83),,39.0983(1),',
    '19,K,49,48.96821075(86),,39.0983(1),',
    '19,K,50,49.9723800(83),,39.0983(1),',
    '19,K,51,50.975828(14),,39.0983(1),',
    '19,K,52,51.98224(43#),,39.0983(1),',
    '19,K,53,52.98746(54#),,39.0983(1),',
    '19,K,54,53.99463(64#),,39.0983(1),',
    '19,K,55,55.00076(75#),,39.0983(1),',
    '19,K,56,56.00851(86#),,39.0983(1),',
    '20,Ca,34,34.01487(32#),,40.078(4),g',
    '20,Ca,35,35.00514(21#),,40.078(4),g',
    '20,Ca,36,35.993074(43),,40.078(4),g',
    '20,Ca,37,36.98589785(68),,40.078(4),g',
    '20,Ca,38,37.97631922(21),,40.078(4),g',
    '20,Ca,39,38.97071081(64),,40.078(4),g',
    '20,Ca,40,39.962590863(22),0.96941(156),40.078(4),g',
    '20,Ca,41,40.96227792(15),,40.078(4),g',
    '20,Ca,42,41.95861783(16),0.00647(23),40.078(4),g',
    '20,Ca,43,42.95876644(24),0.00135(10),40.078(4),g',
    '20,Ca,44,43.95548156(35),0.02086(110),40.078(4),g',
    '20,Ca,45,44.95618635(39),,40.078(4),g',
    '20,Ca,46,45.9536890(24),0.00004(3),40.078(4),g',
    '20,Ca,47,46.9545424(24),,40.078(4),g',
    '20,Ca,48,47.95252276(13),0.00187(21),40.078(4),g',
    '20,Ca,49,48.95566274(23),,40.078(4),g',
    '20,Ca,50,49.9574992(17),,40.078(4),g',
    '20,Ca,51,50.960989(24),,40.078(4),g',
    '20,Ca,52,51.963217(64),,40.078(4),g',
    '20,Ca,53,52.96945(43#),,40.078(4),g',
    '20,Ca,54,53.97340(54#),,40.078(4),g',
    '20,Ca,55,54.98030(54#),,40.078(4),g',
    '20,Ca,56,55.98508(64#),,40.078(4),g',
    '20,Ca,57,56.99262(64#),,40.078(4),g',
    '20,Ca,58,57.99794(75#),,40.078(4),g',
    '21,Sc,36,36.01648(32#),,44.955908(5),',
    '21,Sc,37,37.00374(32#),,44.955908(5),',
    '21,Sc,38,37.99512(21#),,44.955908(5),',
    '21,Sc,39,38.984785(26),,44.955908(5),',
    '21,Sc,40,39.9779673(30),,44.955908(5),',
    '21,Sc,41,40.969251105(88),,44.955908(5),',
    '21,Sc,42,41.96551653(18),,44.955908(5),',
    '21,Sc,43,42.9611505(20),,44.955908(5),',
    '21,Sc,44,43.9594029(19),,44.955908(5),',
    '21,Sc,45,44.95590828(77),1,44.955908(5),',
    '21,Sc,46,45.95516826(78),,44.955908(5),',
    '21,Sc,47,46.9524037(21),,44.955908(5),',
    '21,Sc,48,47.9522236(53),,44.955908(5),',
    '21,Sc,49,48.9500146(29),,44.955908(5),',
    '21,Sc,50,49.952176(16),,44.955908(5),',
    '21,Sc,51,50.953592(21),,44.955908(5),',
    '21,Sc,52,51.95688(15),,44.955908(5),',
    '21,Sc,53,52.95909(29),,44.955908(5),',
    '21,Sc,54,53.96393(39),,44.955908(5),',
    '21,Sc,55,54.96782(50),,44.955908(5),',
    '21,Sc,56,55.97345(43#),,44.955908(5),',
    '21,Sc,57,56.97777(54#),,44.955908(5),',
    '21,Sc,58,57.98403(64#),,44.955908(5),',
    '21,Sc,59,58.98894(64#),,44.955908(5),',
    '21,Sc,60,59.99565(75#),,44.955908(5),',
    '21,Sc,61,61.00100(86#),,44.955908(5),',
    '22,Ti,38,38.01145(32#),,47.867(1),',
    '22,Ti,39,39.00236(22#),,47.867(1),',
    '22,Ti,40,39.99050(17),,47.867(1),',
    '22,Ti,41,40.983148(30),,47.867(1),',
    '22,Ti,42,41.97304903(30),,47.867(1),',
    '22,Ti,43,42.9685225(78),,47.867(1),',
    '22,Ti,44,43.95968995(75),,47.867(1),',
    '22,Ti,45,44.95812198(95),,47.867(1),',
    '22,Ti,46,45.95262772(35),0.0825(3),47.867(1),',
    '22,Ti,47,46.95175879(38),0.0744(2),47.867(1),',
    '22,Ti,48,47.94794198(38),0.7372(3),47.867(1),',
    '22,Ti,49,48.94786568(39),0.0541(2),47.867(1),',
    '22,Ti,50,49.94478689(39),0.0518(2),47.867(1),',
    '22,Ti,51,50.94661065(65),,47.867(1),',
    '22,Ti,52,51.9468930(76),,47.867(1),',
    '22,Ti,53,52.94973(11),,47.867(1),',
    '22,Ti,54,53.95105(13),,47.867(1),',
    '22,Ti,55,54.95527(17),,47.867(1),',
    '22,Ti,56,55.95791(15),,47.867(1),',
    '22,Ti,57,56.96364(27),,47.867(1),',
    '22,Ti,58,57.96660(43#),,47.867(1),',
    '22,Ti,59,58.97247(43#),,47.867(1),',
    '22,Ti,60,59.97603(54#),,47.867(1),',
    '22,Ti,61,60.98245(64#),,47.867(1),',
    '22,Ti,62,61.98651(75#),,47.867(1),',
    '22,Ti,63,62.99375(75#),,47.867(1),',
    '23,V,40,40.01276(43#),,50.9415(1),',
    '23,V,41,41.00021(32#),,50.9415(1),',
    '23,V,42,41.99182(32#),,50.9415(1),',
    '23,V,43,42.980766(46),,50.9415(1),',
    '23,V,44,43.97411(20),,50.9415(1),',
    '23,V,45,44.9657748(86),,50.9415(1),',
    '23,V,46,45.96019878(36),,50.9415(1),',
    '23,V,47,46.95490491(36),,50.9415(1),',
    '23,V,48,47.9522522(11),,50.9415(1),',
    '23,V,49,48.94851180(96),,50.9415(1),',
    '23,V,50,49.94715601(95),0.00250(4),50.9415(1),',
    '23,V,51,50.94395704(94),0.99750(4),50.9415(1),',
    '23,V,52,51.94477301(95),,50.9415(1),',
    '23,V,53,52.9443367(34),,50.9415(1),',
    '23,V,54,53.946439(16),,50.9415(1),',
    '23,V,55,54.94724(10),,50.9415(1),',
    '23,V,56,55.95048(19),,50.9415(1),',
    '23,V,57,56.95252(24),,50.9415(1),',
    '23,V,58,57.95672(14),,50.9415(1),',
    '23,V,59,58.95939(17),,50.9415(1),',
    '23,V,60,59.96431(24),,50.9415(1),',
    '23,V,61,60.96725(96),,50.9415(1),',
    '23,V,62,61.97265(32#),,50.9415(1),',
    '23,V,63,62.97639(43#),,50.9415(1),',
    '23,V,64,63.98264(43#),,50.9415(1),',
    '23,V,65,64.98750(54#),,50.9415(1),',
    '23,V,66,65.99398(64#),,50.9415(1),',
    '24,Cr,42,42.00670(43#),,51.9961(6),',
    '24,Cr,43,42.99753(43#),,51.9961(6),',
    '24,Cr,44,43.98536(32#),,51.9961(6),',
    '24,Cr,45,44.979050(38),,51.9961(6),',
    '24,Cr,46,45.968359(21),,51.9961(6),',
    '24,Cr,47,46.9628974(75),,51.9961(6),',
    '24,Cr,48,47.9540291(79),,51.9961(6),',
    '24,Cr,49,48.9513333(25),,51.9961(6),',
    '24,Cr,50,49.94604183(94),0.04345(13),51.9961(6),',
    '24,Cr,51,50.94476502(94),,51.9961(6),',
    '24,Cr,52,51.94050623(63),0.83789(18),51.9961(6),',
    '24,Cr,53,52.94064815(62),0.09501(17),51.9961(6),',
    '24,Cr,54,53.93887916(61),0.02365(7),51.9961(6),',
    '24,Cr,55,54.94083843(64),,51.9961(6),',
    '24,Cr,56,55.9406531(20),,51.9961(6),',
    '24,Cr,57,56.9436130(20),,51.9961(6),',
    '24,Cr,58,57.94435(22),,51.9961(6),',
    '24,Cr,59,58.94859(26),,51.9961(6),',
    '24,Cr,60,59.95008(23),,51.9961(6),',
    '24,Cr,61,60.95442(14),,51.9961(6),',
    '24,Cr,62,61.95610(16),,51.9961(6),',
    '24,Cr,63,62.96165(49),,51.9961(6),',
    '24,Cr,64,63.96408(32#),,51.9961(6),',
    '24,Cr,65,64.96996(32#),,51.9961(6),',
    '24,Cr,66,65.97366(54#),,51.9961(6),',
    '24,Cr,67,66.98016(54#),,51.9961(6),',
    '24,Cr,68,67.98403(75#),,51.9961(6),',
    '25,Mn,44,44.00715(54#),,54.938044(3),',
    '25,Mn,45,44.99449(43#),,54.938044(3),',
    '25,Mn,46,45.98609(43#),,54.938044(3),',
    '25,Mn,47,46.975775(34),,54.938044(3),',
    '25,Mn,48,47.96852(18),,54.938044(3),',
    '25,Mn,49,48.959595(11),,54.938044(3),',
    '25,Mn,50,49.95423778(95),,54.938044(3),',
    '25,Mn,51,50.94820847(94),,54.938044(3),',
    '25,Mn,52,51.9455639(20),,54.938044(3),',
    '25,Mn,53,52.94128889(68),,54.938044(3),',
    '25,Mn,54,53.9403576(12),,54.938044(3),',
    '25,Mn,55,54.93804391(48),1,54.938044(3),',
    '25,Mn,56,55.93890369(49),,54.938044(3),',
    '25,Mn,57,56.9382861(16),,54.938044(3),',
    '25,Mn,58,57.9400666(29),,54.938044(3),',
    '25,Mn,59,58.9403911(25),,54.938044(3),',
    '25,Mn,60,59.9431366(25),,54.938044(3),',
    '25,Mn,61,60.9444525(25),,54.938044(3),',
    '25,Mn,62,61.94795(16#),,54.938044(3),',
    '25,Mn,63,62.9496647(40),,54.938044(3),',
    '25,Mn,64,63.9538494(38),,54.938044(3),',
    '25,Mn,65,64.9560198(40),,54.938044(3),',
    '25,Mn,66,65.960547(12),,54.938044(3),',
    '25,Mn,67,66.96424(43#),,54.938044(3),',
    '25,Mn,68,67.96962(54#),,54.938044(3),',
    '25,Mn,69,68.97366(64#),,54.938044(3),',
    '25,Mn,70,69.97937(75#),,54.938044(3),',
    '25,Mn,71,70.98368(75#),,54.938044(3),',
    '26,Fe,45,45.01442(43#),,55.845(2),',
    '26,Fe,46,46.00063(54#),,55.845(2),',
    '26,Fe,47,46.99185(54#),,55.845(2),',
    '26,Fe,48,47.98023(43#),,55.845(2),',
    '26,Fe,49,48.973429(26),,55.845(2),',
    '26,Fe,50,49.962975(64),,55.845(2),',
    '26,Fe,51,50.9568410(96),,55.845(2),',
    '26,Fe,52,51.9481131(70),,55.845(2),',
    '26,Fe,53,52.9453064(18),,55.845(2),',
    '26,Fe,54,53.93960899(53),0.05845(35),55.845(2),',
    '26,Fe,55,54.93829199(51),,55.845(2),',
    '26,Fe,56,55.93493633(49),0.91754(36),55.845(2),',
    '26,Fe,57,56.93539284(49),0.02119(10),55.845(2),',
    '26,Fe,58,57.93327443(53),0.00282(4),55.845(2),',
    '26,Fe,59,58.93487434(54),,55.845(2),',
    '26,Fe,60,59.9340711(37),,55.845(2),',
    '26,Fe,61,60.9367462(28),,55.845(2),',
    '26,Fe,62,61.9367918(30),,55.845(2),',
    '26,Fe,63,62.9402727(46),,55.845(2),',
    '26,Fe,64,63.9409878(54),,55.845(2),',
    '26,Fe,65,64.9450115(73),,55.845(2),',
    '26,Fe,66,65.9462500(44),,55.845(2),',
    '26,Fe,67,66.95054(23),,55.845(2),',
    '26,Fe,68,67.95295(39),,55.845(2),',
    '26,Fe,69,68.95807(43#),,55.845(2),',
    '26,Fe,70,69.96102(54#),,55.845(2),',
    '26,Fe,71,70.96672(64#),,55.845(2),',
    '26,Fe,72,71.96983(75#),,55.845(2),',
    '26,Fe,73,72.97572(75#),,55.845(2),',
    '26,Fe,74,73.97935(86#),,55.845(2),',
    '27,Co,47,47.01057(86#),,58.933194(4),',
    '27,Co,48,48.00093(86#),,58.933194(4),',
    '27,Co,49,48.98891(75#),,58.933194(4),',
    '27,Co,50,49.98091(64#),,58.933194(4),',
    '27,Co,51,50.970647(52),,58.933194(4),',
    '27,Co,52,51.96351(21#),,58.933194(4),',
    '27,Co,53,52.9542041(19),,58.933194(4),',
    '27,Co,54,53.94845987(54),,58.933194(4),',
    '27,Co,55,54.94199720(57),,58.933194(4),',
    '27,Co,56,55.93983880(63),,58.933194(4),',
    '27,Co,57,56.93629057(66),,58.933194(4),',
    '27,Co,58,57.9357521(13),,58.933194(4),',
    '27,Co,59,58.93319429(56),1,58.933194(4),',
    '27,Co,60,59.93381630(56),,58.933194(4),',
    '27,Co,61,60.93247662(95),,58.933194(4),',
    '27,Co,62,61.934059(20),,58.933194(4),',
    '27,Co,63,62.933600(20),,58.933194(4),',
    '27,Co,64,63.935811(21),,58.933194(4),',
    '27,Co,65,64.9364621(22),,58.933194(4),',
    '27,Co,66,65.939443(15),,58.933194(4),',
    '27,Co,67,66.9406096(69),,58.933194(4),',
    '27,Co,68,67.94426(16),,58.933194(4),',
    '27,Co,69,68.94614(20),,58.933194(4),',
    '27,Co,70,69.94963(32),,58.933194(4),',
    '27,Co,71,70.95237(50),,58.933194(4),',
    '27,Co,72,71.95729(43#),,58.933194(4),',
    '27,Co,73,72.96039(54#),,58.933194(4),',
    '27,Co,74,73.96515(64#),,58.933194(4),',
    '27,Co,75,74.96876(75#),,58.933194(4),',
    '27,Co,76,75.97413(86#),,58.933194(4),',
    '28,Ni,48,48.01769(54#),,58.6934(4),r',
    '28,Ni,49,49.00770(86#),,58.6934(4),r',
    '28,Ni,50,49.99474(86#),,58.6934(4),r',
    '28,Ni,51,50.98611(86#),,58.6934(4),r',
    '28,Ni,52,51.97480(75#),,58.6934(4),r',
    '28,Ni,53,52.968190(27),,58.6934(4),r',
    '28,Ni,54,53.957892(54),,58.6934(4),r',
    '28,Ni,55,54.95133063(85),,58.6934(4),r',
    '28,Ni,56,55.94212855(57),,58.6934(4),r',
    '28,Ni,57,56.93979218(71),,58.6934(4),r',
    '28,Ni,58,57.93534241(52),0.68077(19),58.6934(4),r',
    '28,Ni,59,58.93434620(52),,58.6934(4),r',
    '28,Ni,60,59.93078588(52),0.26223(15),58.6934(4),r',
    '28,Ni,61,60.93105557(52),0.011399(13),58.6934(4),r',
    '28,Ni,62,61.92834537(55),0.036346(40),58.6934(4),r',
    '28,Ni,63,62.92966963(56),,58.6934(4),r',
    '28,Ni,64,63.92796682(58),0.009255(19),58.6934(4),r',
    '28,Ni,65,64.93008517(60),,58.6934(4),r',
    '28,Ni,66,65.9291393(15),,58.6934(4),r',
    '28,Ni,67,66.9315694(31),,58.6934(4),r',
    '28,Ni,68,67.9318688(32),,58.6934(4),r',
    '28,Ni,69,68.9356103(40),,58.6934(4),r',
    '28,Ni,70,69.9364313(23),,58.6934(4),r',
    '28,Ni,71,70.9405190(24),,58.6934(4),r',
    '28,Ni,72,71.9417859(24),,58.6934(4),r',
    '28,Ni,73,72.9462067(26),,58.6934(4),r',
    '28,Ni,74,73.94798(43#),,58.6934(4),r',
    '28,Ni,75,74.95250(32#),,58.6934(4),r',
    '28,Ni,76,75.95533(54#),,58.6934(4),r',
    '28,Ni,77,76.96055(54#),,58.6934(4),r',
    '28,Ni,78,77.96336(86#),,58.6934(4),r',
    '28,Ni,79,78.97025(86#),,58.6934(4),r',
    '29,Cu,52,51.99671(86#),,63.546(3),r',
    '29,Cu,53,52.98459(86#),,63.546(3),r',
    '29,Cu,54,53.97666(54#),,63.546(3),r',
    '29,Cu,55,54.96604(17),,63.546(3),r',
    '29,Cu,56,55.95895(21#),,63.546(3),r',
    '29,Cu,57,56.94921250(66),,63.546(3),r',
    '29,Cu,58,57.94453305(70),,63.546(3),r',
    '29,Cu,59,58.93949748(67),,63.546(3),r',
    '29,Cu,60,59.9373645(18),,63.546(3),r',
    '29,Cu,61,60.9334576(10),,63.546(3),r',
    '29,Cu,62,61.93259541(75),,63.546(3),r',
    '29,Cu,63,62.92959772(56),0.6915(15),63.546(3),r',
    '29,Cu,64,63.92976434(56),,63.546(3),r',
    '29,Cu,65,64.92778970(71),0.3085(15),63.546(3),r',
    '29,Cu,66,65.92886903(72),,63.546(3),r',
    '29,Cu,67,66.9277303(13),,63.546(3),r',
    '29,Cu,68,67.9296109(17),,63.546(3),r',
    '29,Cu,69,68.9294293(15),,63.546(3),r',
    '29,Cu,70,69.9323921(12),,63.546(3),r',
    '29,Cu,71,70.9326768(16),,63.546(3),r',
    '29,Cu,72,71.9358203(15),,63.546(3),r',
    '29,Cu,73,72.9366744(21),,63.546(3),r',
    '29,Cu,74,73.9398749(66),,63.546(3),r',
    '29,Cu,75,74.9415226(25),,63.546(3),r',
    '29,Cu,76,75.9452750(72),,63.546(3),r',
    '29,Cu,77,76.94792(16#),,63.546(3),r',
    '29,Cu,78,77.95223(54),,63.546(3),r',
    '29,Cu,79,78.95502(43#),,63.546(3),r',
    '29,Cu,80,79.96089(64#),,63.546(3),r',
    '29,Cu,81,80.96587(86#),,63.546(3),r',
    '29,Cu,82,81.97244(86#),,63.546(3),r',
    '30,Zn,54,53.99204(75#),,65.38(2),r',
    '30,Zn,55,54.98398(75#),,65.38(2),r',
    '30,Zn,56,55.97254(54#),,65.38(2),r',
    '30,Zn,57,56.96506(22#),,65.38(2),r',
    '30,Zn,58,57.954591(54),,65.38(2),r',
    '30,Zn,59,58.94931266(89),,65.38(2),r',
    '30,Zn,60,59.94184210(69),,65.38(2),r',
    '30,Zn,61,60.939507(17),,65.38(2),r',
    '30,Zn,62,61.93433397(73),,65.38(2),r',
    '30,Zn,63,62.9332115(17),,65.38(2),r',
    '30,Zn,64,63.92914201(71),0.4917(75),65.38(2),r',
    '30,Zn,65,64.92924077(71),,65.38(2),r',
    '30,Zn,66,65.92603381(94),0.2773(98),65.38(2),r',
    '30,Zn,67,66.92712775(96),0.0404(16),65.38(2),r',
    '30,Zn,68,67.92484455(98),0.1845(63),65.38(2),r',
    '30,Zn,69,68.9265507(10),,65.38(2),r',
    '30,Zn,70,69.9253192(21),0.0061(10),65.38(2),r',
    '30,Zn,71,70.9277196(28),,65.38(2),r',
    '30,Zn,72,71.9268428(23),,65.38(2),r',
    '30,Zn,73,72.9295826(20),,65.38(2),r',
    '30,Zn,74,73.9294073(27),,65.38(2),r',
    '30,Zn,75,74.9328402(21),,65.38(2),r',
    '30,Zn,76,75.9331150(16),,65.38(2),r',
    '30,Zn,77,76.9368872(21),,65.38(2),r',
    '30,Zn,78,77.9382892(21),,65.38(2),r',
    '30,Zn,79,78.9426381(24),,65.38(2),r',
    '30,Zn,80,79.9445529(28),,65.38(2),r',
    '30,Zn,81,80.9504026(54),,65.38(2),r',
    '30,Zn,82,81.95426(32#),,65.38(2),r',
    '30,Zn,83,82.96056(54#),,65.38(2),r',
    '30,Zn,84,83.96521(64#),,65.38(2),r',
    '30,Zn,85,84.97226(75#),,65.38(2),r',
    '31,Ga,56,55.99536(64#),,69.723(1),',
    '31,Ga,57,56.98320(32#),,69.723(1),',
    '31,Ga,58,57.97478(21#),,69.723(1),',
    '31,Ga,59,58.96353(18#),,69.723(1),',
    '31,Ga,60,59.95729(21#),,69.723(1),',
    '31,Ga,61,60.949399(41),,69.723(1),',
    '31,Ga,62,61.94419025(75),,69.723(1),',
    '31,Ga,63,62.9392942(14),,69.723(1),',
    '31,Ga,64,63.9368404(15),,69.723(1),',
    '31,Ga,65,64.93273459(88),,69.723(1),',
    '31,Ga,66,65.9315894(34),,69.723(1),',
    '31,Ga,67,66.9282025(13),,69.723(1),',
    '31,Ga,68,67.9279805(16),,69.723(1),',
    '31,Ga,69,68.9255735(13),0.60108(9),69.723(1),',
    '31,Ga,70,69.9260219(13),,69.723(1),',
    '31,Ga,71,70.92470258(87),0.39892(9),69.723(1),',
    '31,Ga,72,71.92636747(88),,69.723(1),',
    '31,Ga,73,72.9251747(18),,69.723(1),',
    '31,Ga,74,73.9269457(32),,69.723(1),',
    '31,Ga,75,74.9265002(26),,69.723(1),',
    '31,Ga,76,75.9288276(21),,69.723(1),',
    '31,Ga,77,76.9291543(26),,69.723(1),',
    '31,Ga,78,77.9316088(20),,69.723(1),',
    '31,Ga,79,78.9328523(20),,69.723(1),',
    '31,Ga,80,79.9364208(31),,69.723(1),',
    '31,Ga,81,80.9381338(35),,69.723(1),',
    '31,Ga,82,81.9431765(26),,69.723(1),',
    '31,Ga,83,82.9471203(28),,69.723(1),',
    '31,Ga,84,83.95246(43#),,69.723(1),',
    '31,Ga,85,84.95699(32#),,69.723(1),',
    '31,Ga,86,85.96301(75#),,69.723(1),',
    '31,Ga,87,86.96824(86#),,69.723(1),',
    '32,Ge,58,57.99172(43#),,72.630(8),',
    '32,Ge,59,58.98249(32#),,72.630(8),',
    '32,Ge,60,59.97036(21#),,72.630(8),',
    '32,Ge,61,60.96379(32#),,72.630(8),',
    '32,Ge,62,61.95502(15#),,72.630(8),',
    '32,Ge,63,62.949628(40),,72.630(8),',
    '32,Ge,64,63.9416899(40),,72.630(8),',
    '32,Ge,65,64.9393681(23),,72.630(8),',
    '32,Ge,66,65.9338621(26),,72.630(8),',
    '32,Ge,67,66.9327339(50),,72.630(8),',
    '32,Ge,68,67.9280953(20),,72.630(8),',
    '32,Ge,69,68.9279645(14),,72.630(8),',
    '32,Ge,70,69.92424875(90),0.2057(27),72.630(8),',
    '32,Ge,71,70.92495233(90),,72.630(8),',
    '32,Ge,72,71.922075826(81),0.2745(32),72.630(8),',
    '32,Ge,73,72.923458956(61),0.0775(12),72.630(8),',
    '32,Ge,74,73.921177761(13),0.3650(20),72.630(8),',
    '32,Ge,75,74.922858370(55),,72.630(8),',
    '32,Ge,76,75.921402726(19),0.0773(12),72.630(8),',
    '32,Ge,77,76.923549843(57),,72.630(8),',
    '32,Ge,78,77.9228529(38),,72.630(8),',
    '32,Ge,79,78.925360(40),,72.630(8),',
    '32,Ge,80,79.9253508(22),,72.630(8),',
    '32,Ge,81,80.9288329(22),,72.630(8),',
    '32,Ge,82,81.9297740(24),,72.630(8),',
    '32,Ge,83,82.9345391(26),,72.630(8),',
    '32,Ge,84,83.9375751(34),,72.630(8),',
    '32,Ge,85,84.9429697(40),,72.630(8),',
    '32,Ge,86,85.94658(32#),,72.630(8),',
    '32,Ge,87,86.95268(43#),,72.630(8),',
    '32,Ge,88,87.95691(54#),,72.630(8),',
    '32,Ge,89,88.96379(64#),,72.630(8),',
    '32,Ge,90,89.96863(75#),,72.630(8),',
    '33,As,60,59.99388(43#),,74.921595(6),',
    '33,As,61,60.98112(32#),,74.921595(6),',
    '33,As,62,61.97361(32#),,74.921595(6),',
    '33,As,63,62.96390(21#),,74.921595(6),',
    '33,As,64,63.95743(33#),,74.921595(6),',
    '33,As,65,64.949611(91),,74.921595(6),',
    '33,As,66,65.9441488(61),,74.921595(6),',
    '33,As,67,66.93925111(48),,74.921595(6),',
    '33,As,68,67.9367741(20),,74.921595(6),',
    '33,As,69,68.932246(34),,74.921595(6),',
    '33,As,70,69.930926(54),,74.921595(6),',
    '33,As,71,70.9271138(45),,74.921595(6),',
    '33,As,72,71.9267523(44),,74.921595(6),',
    '33,As,73,72.9238291(41),,74.921595(6),',
    '33,As,74,73.9239286(18),,74.921595(6),',
    '33,As,75,74.92159457(95),1,74.921595(6),',
    '33,As,76,75.92239202(95),,74.921595(6),',
    '33,As,77,76.9206476(18),,74.921595(6),',
    '33,As,78,77.921828(11),,74.921595(6),',
    '33,As,79,78.9209484(58),,74.921595(6),',
    '33,As,80,79.9224746(36),,74.921595(6),',
    '33,As,81,80.9221323(29),,74.921595(6),',
    '33,As,82,81.9247412(46),,74.921595(6),',
    '33,As,83,82.9252069(30),,74.921595(6),',
    '33,As,84,83.9293033(34),,74.921595(6),',
    '33,As,85,84.9321637(33),,74.921595(6),',
    '33,As,86,85.9367015(37),,74.921595(6),',
    '33,As,87,86.9402917(32),,74.921595(6),',
    '33,As,88,87.94555(21#),,74.921595(6),',
    '33,As,89,88.94976(32#),,74.921595(6),',
    '33,As,90,89.95563(64#),,74.921595(6),',
    '33,As,91,90.96039(64#),,74.921595(6),',
    '33,As,92,91.96674(75#),,74.921595(6),',
    '34,Se,64,63.97109(54#),,78.971(8),r',
    '34,Se,65,64.96440(64#),,78.971(8),r',
    '34,Se,66,65.95559(32#),,78.971(8),r',
    '34,Se,67,66.949994(72),,78.971(8),r',
    '34,Se,68,67.94182524(53),,78.971(8),r',
    '34,Se,69,68.9394148(16),,78.971(8),r',
    '34,Se,70,69.9335155(17),,78.971(8),r',
    '34,Se,71,70.9322094(30),,78.971(8),r',
    '34,Se,72,71.9271405(21),,78.971(8),r',
    '34,Se,73,72.9267549(80),,78.971(8),r',
    '34,Se,74,73.922475934(15),0.0089(4),78.971(8),r',
    '34,Se,75,74.922522870(78),,78.971(8),r',
    '34,Se,76,75.919213704(17),0.0937(29),78.971(8),r',
    '34,Se,77,76.919914154(67),0.0763(16),78.971(8),r',
    '34,Se,78,77.91730928(20),0.2377(28),78.971(8),r',
    '34,Se,79,78.91849929(24),,78.971(8),r',
    '34,Se,80,79.9165218(13),0.4961(41),78.971(8),r',
    '34,Se,81,80.9179930(14),,78.971(8),r',
    '34,Se,82,81.9166995(15),0.0873(22),78.971(8),r',
    '34,Se,83,82.9191186(36),,78.971(8),r',
    '34,Se,84,83.9184668(21),,78.971(8),r',
    '34,Se,85,84.9222608(28),,78.971(8),r',
    '34,Se,86,85.9243117(27),,78.971(8),r',
    '34,Se,87,86.9286886(24),,78.971(8),r',
    '34,Se,88,87.9314175(36),,78.971(8),r',
    '34,Se,89,88.9366691(40),,78.971(8),r',
    '34,Se,90,89.94010(35),,78.971(8),r',
    '34,Se,91,90.94596(54#),,78.971(8),r',
    '34,Se,92,91.94984(64#),,78.971(8),r',
    '34,Se,93,92.95629(86#),,78.971(8),r',
    '34,Se,94,93.96049(86#),,78.971(8),r',
    '34,Se,95,94.96730(86#),,78.971(8),r',
    '35,Br,67,66.96465(54#),,"[79.901,79.907]",',
    '35,Br,68,67.95873(33#),,"[79.901,79.907]",',
    '35,Br,69,68.950497(40),,"[79.901,79.907]",',
    '35,Br,70,69.944792(16),,"[79.901,79.907]",',
    '35,Br,71,70.9393422(58),,"[79.901,79.907]",',
    '35,Br,72,71.9365886(72),,"[79.901,79.907]",',
    '35,Br,73,72.9316715(78),,"[79.901,79.907]",',
    '35,Br,74,73.9299102(63),,"[79.901,79.907]",',
    '35,Br,75,74.9258105(46),,"[79.901,79.907]",',
    '35,Br,76,75.924542(10),,"[79.901,79.907]",',
    '35,Br,77,76.9213792(30),,"[79.901,79.907]",',
    '35,Br,78,77.9211459(38),,"[79.901,79.907]",',
    '35,Br,79,78.9183376(14),0.5069(7),"[79.901,79.907]",',
    '35,Br,80,79.9185298(14),,"[79.901,79.907]",',
    '35,Br,81,80.9162897(14),0.4931(7),"[79.901,79.907]",',
    '35,Br,82,81.9168032(14),,"[79.901,79.907]",',
    '35,Br,83,82.9151756(41),,"[79.901,79.907]",',
    '35,Br,84,83.916496(28),,"[79.901,79.907]",',
    '35,Br,85,84.9156458(33),,"[79.901,79.907]",',
    '35,Br,86,85.9188054(33),,"[79.901,79.907]",',
    '35,Br,87,86.9206740(34),,"[79.901,79.907]",',
    '35,Br,88,87.9240833(34),,"[79.901,79.907]",',
    '35,Br,89,88.9267046(35),,"[79.901,79.907]",',
    '35,Br,90,89.9312928(36),,"[79.901,79.907]",',
    '35,Br,91,90.9343986(38),,"[79.901,79.907]",',
    '35,Br,92,91.9396316(72),,"[79.901,79.907]",',
    '35,Br,93,92.94313(48),,"[79.901,79.907]",',
    '35,Br,94,93.94890(43#),,"[79.901,79.907]",',
    '35,Br,95,94.95301(21#),,"[79.901,79.907]",',
    '35,Br,96,95.95903(32#),,"[79.901,79.907]",',
    '35,Br,97,96.96344(43#),,"[79.901,79.907]",',
    '35,Br,98,97.96946(43#),,"[79.901,79.907]",',
    '36,Kr,69,68.96518(43#),,83.798(2),"g,m"',
    '36,Kr,70,69.95604(21#),,83.798(2),"g,m"',
    '36,Kr,71,70.95027(14),,83.798(2),"g,m"',
    '36,Kr,72,71.9420924(86),,83.798(2),"g,m"',
    '36,Kr,73,72.9392892(71),,83.798(2),"g,m"',
    '36,Kr,74,73.9330840(22),,83.798(2),"g,m"',
    '36,Kr,75,74.9309457(87),,83.798(2),"g,m"',
    '36,Kr,76,75.9259103(43),,83.798(2),"g,m"',
    '36,Kr,77,76.9246700(21),,83.798(2),"g,m"',
    '36,Kr,78,77.92036494(76),0.00355(3),83.798(2),"g,m"',
    '36,Kr,79,78.9200829(38),,83.798(2),"g,m"',
    '36,Kr,80,79.91637808(75),0.02286(10),83.798(2),"g,m"',
    '36,Kr,81,80.9165912(15),,83.798(2),"g,m"',
    '36,Kr,82,81.91348273(94),0.11593(31),83.798(2),"g,m"',
    '36,Kr,83,82.91412716(32),0.11500(19),83.798(2),"g,m"',
    '36,Kr,84,83.9114977282(44),0.56987(15),83.798(2),"g,m"',
    '36,Kr,85,84.9125273(21),,83.798(2),"g,m"',
    '36,Kr,86,85.9106106269(41),0.17279(41),83.798(2),"g,m"',
    '36,Kr,87,86.91335476(26),,83.798(2),"g,m"',
    '36,Kr,88,87.9144479(28),,83.798(2),"g,m"',
    '36,Kr,89,88.9178355(23),,83.798(2),"g,m"',
    '36,Kr,90,89.9195279(20),,83.798(2),"g,m"',
    '36,Kr,91,90.9238063(24),,83.798(2),"g,m"',
    '36,Kr,92,91.9261731(29),,83.798(2),"g,m"',
    '36,Kr,93,92.9311472(27),,83.798(2),"g,m"',
    '36,Kr,94,93.934140(13),,83.798(2),"g,m"',
    '36,Kr,95,94.939711(20),,83.798(2),"g,m"',
    '36,Kr,96,95.943017(22),,83.798(2),"g,m"',
    '36,Kr,97,96.94909(14),,83.798(2),"g,m"',
    '36,Kr,98,97.95243(32#),,83.798(2),"g,m"',
    '36,Kr,99,98.95839(54#),,83.798(2),"g,m"',
    '36,Kr,100,99.96237(43#),,83.798(2),"g,m"',
    '36,Kr,101,100.96873(54#),,83.798(2),"g,m"',
    '37,Rb,71,70.96532(54#),,85.4678(3),g',
    '37,Rb,72,71.95908(54#),,85.4678(3),g',
    '37,Rb,73,72.95053(11#),,85.4678(3),g',
    '37,Rb,74,73.9442659(32),,85.4678(3),g',
    '37,Rb,75,74.9385732(13),,85.4678(3),g',
    '37,Rb,76,75.9350730(10),,85.4678(3),g',
    '37,Rb,77,76.9304016(14),,85.4678(3),g',
    '37,Rb,78,77.9281419(35),,85.4678(3),g',
    '37,Rb,79,78.9239899(23),,85.4678(3),g',
    '37,Rb,80,79.9225164(20),,85.4678(3),g',
    '37,Rb,81,80.9189939(53),,85.4678(3),g',
    '37,Rb,82,81.9182090(32),,85.4678(3),g',
    '37,Rb,83,82.9151142(25),,85.4678(3),g',
    '37,Rb,84,83.9143752(24),,85.4678(3),g',
    '37,Rb,85,84.9117897379(54),0.7217(2),85.4678(3),g',
    '37,Rb,86,85.91116743(21),,85.4678(3),g',
    '37,Rb,87,86.9091805310(60),0.2783(2),85.4678(3),g',
    '37,Rb,88,87.91131559(17),,85.4678(3),g',
    '37,Rb,89,88.9122783(59),,85.4678(3),g',
    '37,Rb,90,89.9147985(70),,85.4678(3),g',
    '37,Rb,91,90.9165372(84),,85.4678(3),g',
    '37,Rb,92,91.9197284(66),,85.4678(3),g',
    '37,Rb,93,92.9220393(84),,85.4678(3),g',
    '37,Rb,94,93.9263948(22),,85.4678(3),g',
    '37,Rb,95,94.929260(22),,85.4678(3),g',
    '37,Rb,96,95.9341334(36),,85.4678(3),g',
    '37,Rb,97,96.9371771(21),,85.4678(3),g',
    '37,Rb,98,97.9416869(37),,85.4678(3),g',
    '37,Rb,99,98.94503(12),,85.4678(3),g',
    '37,Rb,100,99.95003(21#),,85.4678(3),g',
    '37,Rb,101,100.95404(23#),,85.4678(3),g',
    '37,Rb,102,101.95952(32#),,85.4678(3),g',
    '37,Rb,103,102.96392(43#),,85.4678(3),g',
    '38,Sr,73,72.96570(43#),,87.62(1),"g,r"',
    '38,Sr,74,73.95617(11#),,87.62(1),"g,r"',
    '38,Sr,75,74.94995(24),,87.62(1),"g,r"',
    '38,Sr,76,75.941763(37),,87.62(1),"g,r"',
    '38,Sr,77,76.9379455(85),,87.62(1),"g,r"',
    '38,Sr,78,77.9321800(80),,87.62(1),"g,r"',
    '38,Sr,79,78.9297077(90),,87.62(1),"g,r"',
    '38,Sr,80,79.9245175(37),,87.62(1),"g,r"',
    '38,Sr,81,80.9232114(34),,87.62(1),"g,r"',
    '38,Sr,82,81.9183999(64),,87.62(1),"g,r"',
    '38,Sr,83,82.9175544(73),,87.62(1),"g,r"',
    '38,Sr,84,83.9134191(13),0.0056(1),87.62(1),"g,r"',
    '38,Sr,85,84.9129320(30),,87.62(1),"g,r"',
    '38,Sr,86,85.9092606(12),0.0986(1),87.62(1),"g,r"',
    '38,Sr,87,86.9088775(12),0.0700(1),87.62(1),"g,r"',
    '38,Sr,88,87.9056125(12),0.8258(1),87.62(1),"g,r"',
    '38,Sr,89,88.9074511(12),,87.62(1),"g,r"',
    '38,Sr,90,89.9077300(28),,87.62(1),"g,r"',
    '38,Sr,91,90.9101954(61),,87.62(1),"g,r"',
    '38,Sr,92,91.9110382(37),,87.62(1),"g,r"',
    '38,Sr,93,92.9140242(81),,87.62(1),"g,r"',
    '38,Sr,94,93.9153556(18),,87.62(1),"g,r"',
    '38,Sr,95,94.9193529(63),,87.62(1),"g,r"',
    '38,Sr,96,95.9217066(93),,87.62(1),"g,r"',
    '38,Sr,97,96.9263740(36),,87.62(1),"g,r"',
    '38,Sr,98,97.9286888(40),,87.62(1),"g,r"',
    '38,Sr,99,98.9328907(38),,87.62(1),"g,r"',
    '38,Sr,100,99.935770(10),,87.62(1),"g,r"',
    '38,Sr,101,100.940352(86),,87.62(1),"g,r"',
    '38,Sr,102,101.943791(75),,87.62(1),"g,r"',
    '38,Sr,103,102.94909(21#),,87.62(1),"g,r"',
    '38,Sr,104,103.95265(32#),,87.62(1),"g,r"',
    '38,Sr,105,104.95855(54#),,87.62(1),"g,r"',
    '38,Sr,106,105.96265(64#),,87.62(1),"g,r"',
    '38,Sr,107,106.96897(75#),,87.62(1),"g,r"',
    '39,Y,76,75.95856(54#),,88.90584(2),',
    '39,Y,77,76.949781(65#),,88.90584(2),',
    '39,Y,78,77.94361(43#),,88.90584(2),',
    '39,Y,79,78.93735(48),,88.90584(2),',
    '39,Y,80,79.9343561(67),,88.90584(2),',
    '39,Y,81,80.9294556(58),,88.90584(2),',
    '39,Y,82,81.9269314(59),,88.90584(2),',
    '39,Y,83,82.922485(20),,88.90584(2),',
    '39,Y,84,83.9206721(46),,88.90584(2),',
    '39,Y,85,84.916433(20),,88.90584(2),',
    '39,Y,86,85.914886(15),,88.90584(2),',
    '39,Y,87,86.9108761(17),,88.90584(2),',
    '39,Y,88,87.9095016(20),,88.90584(2),',
    '39,Y,89,88.9058403(24),1,88.90584(2),',
    '39,Y,90,89.9071439(24),,88.90584(2),',
    '39,Y,91,90.9072974(28),,88.90584(2),',
    '39,Y,92,91.9089451(99),,88.90584(2),',
    '39,Y,93,92.909578(11),,88.90584(2),',
    '39,Y,94,93.9115906(69),,88.90584(2),',
    '39,Y,95,94.9128161(74),,88.90584(2),',
    '39,Y,96,95.9158968(69),,88.90584(2),',
    '39,Y,97,96.9182741(75),,88.90584(2),',
    '39,Y,98,97.9223821(88),,88.90584(2),',
    '39,Y,99,98.9241480(74),,88.90584(2),',
    '39,Y,100,99.927715(12),,88.90584(2),',
    '39,Y,101,100.9301477(79),,88.90584(2),',
    '39,Y,102,101.9343277(44),,88.90584(2),',
    '39,Y,103,102.937243(12),,88.90584(2),',
    '39,Y,104,103.94196(43#),,88.90584(2),',
    '39,Y,105,104.94544(54#),,88.90584(2),',
    '39,Y,106,105.95056(54#),,88.90584(2),',
    '39,Y,107,106.95452(54#),,88.90584(2),',
    '39,Y,108,107.95996(64#),,88.90584(2),',
    '39,Y,109,108.96436(75#),,88.90584(2),',
    '40,Zr,78,77.95566(54#),,91.224(2),g',
    '40,Zr,79,78.94948(43#),,91.224(2),g',
    '40,Zr,80,79.9404(16),,91.224(2),g',
    '40,Zr,81,80.93731(18),,91.224(2),g',
    '40,Zr,82,81.93135(22#),,91.224(2),g',
    '40,Zr,83,82.9292421(69),,91.224(2),g',
    '40,Zr,84,83.9233269(59),,91.224(2),g',
    '40,Zr,85,84.9214444(69),,91.224(2),g',
    '40,Zr,86,85.9162972(38),,91.224(2),g',
    '40,Zr,87,86.9148180(45),,91.224(2),g',
    '40,Zr,88,87.9102213(58),,91.224(2),g',
    '40,Zr,89,88.9088814(37),,91.224(2),g',
    '40,Zr,90,89.9046977(20),0.5145(40),91.224(2),g',
    '40,Zr,91,90.9056396(20),0.1122(5),91.224(2),g',
    '40,Zr,92,91.9050347(20),0.1715(8),91.224(2),g',
    '40,Zr,93,92.9064699(20),,91.224(2),g',
    '40,Zr,94,93.9063108(20),0.1738(28),91.224(2),g',
    '40,Zr,95,94.9080385(19),,91.224(2),g',
    '40,Zr,96,95.9082714(21),0.0280(9),91.224(2),g',
    '40,Zr,97,96.9109512(21),,91.224(2),g',
    '40,Zr,98,97.9127289(93),,91.224(2),g',
    '40,Zr,99,98.916667(11),,91.224(2),g',
    '40,Zr,100,99.9180006(89),,91.224(2),g',
    '40,Zr,101,100.9214480(91),,91.224(2),g',
    '40,Zr,102,101.9231409(97),,91.224(2),g',
    '40,Zr,103,102.927191(10),,91.224(2),g',
    '40,Zr,104,103.929436(10),,91.224(2),g',
    '40,Zr,105,104.934008(13),,91.224(2),g',
    '40,Zr,106,105.93676(21#),,91.224(2),g',
    '40,Zr,107,106.94174(32#),,91.224(2),g',
    '40,Zr,108,107.94487(43#),,91.224(2),g',
    '40,Zr,109,108.95041(54#),,91.224(2),g',
    '40,Zr,110,109.95396(64#),,91.224(2),g',
    '40,Zr,111,110.95968(75#),,91.224(2),g',
    '40,Zr,112,111.96370(75#),,91.224(2),g',
    '41,Nb,81,80.94960(43#),,92.90637(2),',
    '41,Nb,82,81.94396(32#),,92.90637(2),',
    '41,Nb,83,82.93729(32),,92.90637(2),',
    '41,Nb,84,83.93449(32#),,92.90637(2),',
    '41,Nb,85,84.9288458(44),,92.90637(2),',
    '41,Nb,86,85.9257828(59),,92.90637(2),',
    '41,Nb,87,86.9206937(73),,92.90637(2),',
    '41,Nb,88,87.918222(61),,92.90637(2),',
    '41,Nb,89,88.913445(25),,92.90637(2),',
    '41,Nb,90,89.9112584(38),,92.90637(2),',
    '41,Nb,91,90.9069897(37),,92.90637(2),',
    '41,Nb,92,91.9071881(26),,92.90637(2),',
    '41,Nb,93,92.9063730(20),1,92.90637(2),',
    '41,Nb,94,93.9072788(20),,92.90637(2),',
    '41,Nb,95,94.90683240(71),,92.90637(2),',
    '41,Nb,96,95.9080973(35),,92.90637(2),',
    '41,Nb,97,96.9080959(19),,92.90637(2),',
    '41,Nb,98,97.9103265(58),,92.90637(2),',
    '41,Nb,99,98.911613(13),,92.90637(2),',
    '41,Nb,100,99.9143276(88),,92.90637(2),',
    '41,Nb,101,100.9153103(42),,92.90637(2),',
    '41,Nb,102,101.9180772(35),,92.90637(2),',
    '41,Nb,103,102.9194572(44),,92.90637(2),',
    '41,Nb,104,103.9228925(37),,92.90637(2),',
    '41,Nb,105,104.9249465(45),,92.90637(2),',
    '41,Nb,106,105.9289317(46),,92.90637(2),',
    '41,Nb,107,106.9315937(87),,92.90637(2),',
    '41,Nb,108,107.9360748(88),,92.90637(2),',
    '41,Nb,109,108.93922(56),,92.90637(2),',
    '41,Nb,110,109.94403(21#),,92.90637(2),',
    '41,Nb,111,110.94753(32#),,92.90637(2),',
    '41,Nb,112,111.95247(32#),,92.90637(2),',
    '41,Nb,113,112.95651(43#),,92.90637(2),',
    '41,Nb,114,113.96201(54#),,92.90637(2),',
    '41,Nb,115,114.96634(54#),,92.90637(2),',
    '42,Mo,83,82.94988(43#),,95.95(1),g',
    '42,Mo,84,83.94149(43#),,95.95(1),g',
    '42,Mo,85,84.938261(17),,95.95(1),g',
    '42,Mo,86,85.9311748(40),,95.95(1),g',
    '42,Mo,87,86.9281962(31),,95.95(1),g',
    '42,Mo,88,87.9219678(41),,95.95(1),g',
    '42,Mo,89,88.9194682(42),,95.95(1),g',
    '42,Mo,90,89.9139309(38),,95.95(1),g',
    '42,Mo,91,90.9117453(67),,95.95(1),g',
    '42,Mo,92,91.90680796(84),0.1453(30),95.95(1),g',
    '42,Mo,93,92.90680958(84),,95.95(1),g',
    '42,Mo,94,93.90508490(48),0.0915(9),95.95(1),g',
    '42,Mo,95,94.90583877(47),0.1584(11),95.95(1),g',
    '42,Mo,96,95.90467612(47),0.1667(15),95.95(1),g',
    '42,Mo,97,96.90601812(49),0.0960(14),95.95(1),g',
    '42,Mo,98,97.90540482(49),0.2439(37),95.95(1),g',
    '42,Mo,99,98.90770851(52),,95.95(1),g',
    '42,Mo,100,99.9074718(11),0.0982(31),95.95(1),g',
    '42,Mo,101,100.9103414(11),,95.95(1),g',
    '42,Mo,102,101.9102834(91),,95.95(1),g',
    '42,Mo,103,102.913079(10),,95.95(1),g',
    '42,Mo,104,103.9137344(98),,95.95(1),g',
    '42,Mo,105,104.916969(10),,95.95(1),g',
    '42,Mo,106,105.918259(10),,95.95(1),g',
    '42,Mo,107,106.922106(10),,95.95(1),g',
    '42,Mo,108,107.924033(10),,95.95(1),g',
    '42,Mo,109,108.928424(12),,95.95(1),g',
    '42,Mo,110,109.930704(26),,95.95(1),g',
    '42,Mo,111,110.935654(14),,95.95(1),g',
    '42,Mo,112,111.93831(21#),,95.95(1),g',
    '42,Mo,113,112.94335(32#),,95.95(1),g',
    '42,Mo,114,113.94653(32#),,95.95(1),g',
    '42,Mo,115,114.95196(43#),,95.95(1),g',
    '42,Mo,116,115.95545(54#),,95.95(1),g',
    '42,Mo,117,116.96117(54#),,95.95(1),g',
    '43,Tc,85,84.95058(43#),,[98],',
    '43,Tc,86,85.94493(32#),,[98],',
    '43,Tc,87,86.9380672(45),,[98],',
    '43,Tc,88,87.93378(16),,[98],',
    '43,Tc,89,88.9276487(41),,[98],',
    '43,Tc,90,89.9240739(11),,[98],',
    '43,Tc,91,90.9184254(25),,[98],',
    '43,Tc,92,91.9152698(33),,[98],',
    '43,Tc,93,92.9102460(14),,[98],',
    '43,Tc,94,93.9096536(44),,[98],',
    '43,Tc,95,94.9076536(55),,[98],',
    '43,Tc,96,95.9078680(55),,[98],',
    '43,Tc,97,96.9063667(40),,[98],',
    '43,Tc,98,97.9072124(36),,[98],',
    '43,Tc,99,98.9062508(10),,[98],',
    '43,Tc,100,99.9076539(15),,[98],',
    '43,Tc,101,100.907309(26),,[98],',
    '43,Tc,102,101.9092097(99),,[98],',
    '43,Tc,103,102.909176(11),,[98],',
    '43,Tc,104,103.911425(27),,[98],',
    '43,Tc,105,104.911655(38),,[98],',
    '43,Tc,106,105.914358(13),,[98],',
    '43,Tc,107,106.9154606(93),,[98],',
    '43,Tc,108,107.9184957(94),,[98],',
    '43,Tc,109,108.920256(10),,[98],',
    '43,Tc,110,109.923744(10),,[98],',
    '43,Tc,111,110.925901(11),,[98],',
    '43,Tc,112,111.9299458(60),,[98],',
    '43,Tc,113,112.9325690(36),,[98],',
    '43,Tc,114,113.93691(11#),,[98],',
    '43,Tc,115,114.93998(21#),,[98],',
    '43,Tc,116,115.94476(32#),,[98],',
    '43,Tc,117,116.94806(43#),,[98],',
    '43,Tc,118,117.95299(43#),,[98],',
    '43,Tc,119,118.95666(54#),,[98],',
    '43,Tc,120,119.96187(54#),,[98],',
    '44,Ru,87,86.95069(43#),,101.07(2),g',
    '44,Ru,88,87.94160(32#),,101.07(2),g',
    '44,Ru,89,88.93762(32#),,101.07(2),g',
    '44,Ru,90,89.9303444(40),,101.07(2),g',
    '44,Ru,91,90.9267419(24),,101.07(2),g',
    '44,Ru,92,91.9202344(29),,101.07(2),g',
    '44,Ru,93,92.9171044(22),,101.07(2),g',
    '44,Ru,94,93.9113429(34),,101.07(2),g',
    '44,Ru,95,94.910406(10),,101.07(2),g',
    '44,Ru,96,95.90759025(49),0.0554(14),101.07(2),g',
    '44,Ru,97,96.9075471(30),,101.07(2),g',
    '44,Ru,98,97.9052868(69),0.0187(3),101.07(2),g',
    '44,Ru,99,98.9059341(11),0.1276(14),101.07(2),g',
    '44,Ru,100,99.9042143(11),0.1260(7),101.07(2),g',
    '44,Ru,101,100.9055769(12),0.1706(2),101.07(2),g',
    '44,Ru,102,101.9043441(12),0.3155(14),101.07(2),g',
    '44,Ru,103,102.9063186(12),,101.07(2),g',
    '44,Ru,104,103.9054275(28),0.1862(27),101.07(2),g',
    '44,Ru,105,104.9077476(28),,101.07(2),g',
    '44,Ru,106,105.9073291(58),,101.07(2),g',
    '44,Ru,107,106.9099720(93),,101.07(2),g',
    '44,Ru,108,107.9101880(93),,101.07(2),g',
    '44,Ru,109,108.9133260(96),,101.07(2),g',
    '44,Ru,110,109.9140407(96),,101.07(2),g',
    '44,Ru,111,110.917570(10),,101.07(2),g',
    '44,Ru,112,111.918809(10),,101.07(2),g',
    '44,Ru,113,112.922844(39),,101.07(2),g',
    '44,Ru,114,113.9246136(38),,101.07(2),g',
    '44,Ru,115,114.928820(71),,101.07(2),g',
    '44,Ru,116,115.9312192(40),,101.07(2),g',
    '44,Ru,117,116.93610(63),,101.07(2),g',
    '44,Ru,118,117.93853(32#),,101.07(2),g',
    '44,Ru,119,118.94357(32#),,101.07(2),g',
    '44,Ru,120,119.94631(43#),,101.07(2),g',
    '44,Ru,121,120.95164(43#),,101.07(2),g',
    '44,Ru,122,121.95447(54#),,101.07(2),g',
    '44,Ru,123,122.95989(54#),,101.07(2),g',
    '44,Ru,124,123.96305(64#),,101.07(2),g',
    '45,Rh,89,88.95058(39#),,102.90550(2),',
    '45,Rh,90,89.94422(43#),,102.90550(2),',
    '45,Rh,91,90.93688(43#),,102.90550(2),',
    '45,Rh,92,91.9323677(47),,102.90550(2),',
    '45,Rh,93,92.9259128(28),,102.90550(2),',
    '45,Rh,94,93.9217305(36),,102.90550(2),',
    '45,Rh,95,94.9158979(42),,102.90550(2),',
    '45,Rh,96,95.914453(11),,102.90550(2),',
    '45,Rh,97,96.911329(38),,102.90550(2),',
    '45,Rh,98,97.910708(13),,102.90550(2),',
    '45,Rh,99,98.9081282(73),,102.90550(2),',
    '45,Rh,100,99.908117(19),,102.90550(2),',
    '45,Rh,101,100.9061606(63),,102.90550(2),',
    '45,Rh,102,101.9068374(50),,102.90550(2),',
    '45,Rh,103,102.9054980(26),1,102.90550(2),',
    '45,Rh,104,103.9066492(26),,102.90550(2),',
    '45,Rh,105,104.9056885(27),,102.90550(2),',
    '45,Rh,106,105.9072868(58),,102.90550(2),',
    '45,Rh,107,106.906748(13),,102.90550(2),',
    '45,Rh,108,107.908714(15),,102.90550(2),',
    '45,Rh,109,108.9087488(43),,102.90550(2),',
    '45,Rh,110,109.911079(19),,102.90550(2),',
    '45,Rh,111,110.9116423(74),,102.90550(2),',
    '45,Rh,112,111.914403(47),,102.90550(2),',
    '45,Rh,113,112.9154393(77),,102.90550(2),',
    '45,Rh,114,113.918718(77),,102.90550(2),',
    '45,Rh,115,114.9203116(78),,102.90550(2),',
    '45,Rh,116,115.924059(76),,102.90550(2),',
    '45,Rh,117,116.9260354(95),,102.90550(2),',
    '45,Rh,118,117.930340(26),,102.90550(2),',
    '45,Rh,119,118.932557(10),,102.90550(2),',
    '45,Rh,120,119.93686(21#),,102.90550(2),',
    '45,Rh,121,120.93942(32#),,102.90550(2),',
    '45,Rh,122,121.94399(32#),,102.90550(2),',
    '45,Rh,123,122.94685(43#),,102.90550(2),',
    '45,Rh,124,123.95151(43#),,102.90550(2),',
    '45,Rh,125,124.95469(54#),,102.90550(2),',
    '45,Rh,126,125.95946(54#),,102.90550(2),',
    '46,Pd,91,90.95032(54#),,106.42(1),g',
    '46,Pd,92,91.94088(54#),,106.42(1),g',
    '46,Pd,93,92.93651(43#),,106.42(1),g',
    '46,Pd,94,93.9290376(46),,106.42(1),g',
    '46,Pd,95,94.9248898(33),,106.42(1),g',
    '46,Pd,96,95.9182151(45),,106.42(1),g',
    '46,Pd,97,96.9164720(52),,106.42(1),g',
    '46,Pd,98,97.9126983(51),,106.42(1),g',
    '46,Pd,99,98.9117748(54),,106.42(1),g',
    '46,Pd,100,99.908505(19),,106.42(1),g',
    '46,Pd,101,100.9082864(49),,106.42(1),g',
    '46,Pd,102,101.9056022(28),0.0102(1),106.42(1),g',
    '46,Pd,103,102.9060809(27),,106.42(1),g',
    '46,Pd,104,103.9040305(14),0.1114(8),106.42(1),g',
    '46,Pd,105,104.9050796(12),0.2233(8),106.42(1),g',
    '46,Pd,106,105.9034804(12),0.2733(3),106.42(1),g',
    '46,Pd,107,106.9051282(13),,106.42(1),g',
    '46,Pd,108,107.9038916(12),0.2646(9),106.42(1),g',
    '46,Pd,109,108.9059504(12),,106.42(1),g',
    '46,Pd,110,109.90517220(75),0.1172(9),106.42(1),g',
    '46,Pd,111,110.90768968(86),,106.42(1),g',
    '46,Pd,112,111.9073297(70),,106.42(1),g',
    '46,Pd,113,112.9102610(75),,106.42(1),g',
    '46,Pd,114,113.9103686(75),,106.42(1),g',
    '46,Pd,115,114.913659(15),,106.42(1),g',
    '46,Pd,116,115.9142970(77),,106.42(1),g',
    '46,Pd,117,116.9179547(78),,106.42(1),g',
    '46,Pd,118,117.9190667(27),,106.42(1),g',
    '46,Pd,119,118.9233402(89),,106.42(1),g',
    '46,Pd,120,119.9245511(25),,106.42(1),g',
    '46,Pd,121,120.9289503(36),,106.42(1),g',
    '46,Pd,122,121.930632(21),,106.42(1),g',
    '46,Pd,123,122.93514(21#),,106.42(1),g',
    '46,Pd,124,123.93714(32#),,106.42(1),g',
    '46,Pd,125,124.94179(43#),,106.42(1),g',
    '46,Pd,126,125.94416(54#),,106.42(1),g',
    '46,Pd,127,126.94907(54#),,106.42(1),g',
    '46,Pd,128,127.95183(64#),,106.42(1),g',
    '47,Ag,93,92.95033(54#),,107.8682(2),g',
    '47,Ag,94,93.94373(69#),,107.8682(2),g',
    '47,Ag,95,94.93602(43#),,107.8682(2),g',
    '47,Ag,96,95.930744(97),,107.8682(2),g',
    '47,Ag,97,96.92397(12),,107.8682(2),g',
    '47,Ag,98,97.921560(35),,107.8682(2),g',
    '47,Ag,99,98.9176458(67),,107.8682(2),g',
    '47,Ag,100,99.9161154(54),,107.8682(2),g',
    '47,Ag,101,100.9126840(52),,107.8682(2),g',
    '47,Ag,102,101.9117047(88),,107.8682(2),g',
    '47,Ag,103,102.9089631(41),,107.8682(2),g',
    '47,Ag,104,103.9086239(45),,107.8682(2),g',
    '47,Ag,105,104.9065256(49),,107.8682(2),g',
    '47,Ag,106,105.9066636(32),,107.8682(2),g',
    '47,Ag,107,106.9050916(26),0.51839(8),107.8682(2),g',
    '47,Ag,108,107.9059503(26),,107.8682(2),g',
    '47,Ag,109,108.9047553(14),0.48161(8),107.8682(2),g',
    '47,Ag,110,109.9061102(14),,107.8682(2),g',
    '47,Ag,111,110.9052959(16),,107.8682(2),g',
    '47,Ag,112,111.9070486(26),,107.8682(2),g',
    '47,Ag,113,112.906573(18),,107.8682(2),g',
    '47,Ag,114,113.9088230(49),,107.8682(2),g',
    '47,Ag,115,114.908767(20),,107.8682(2),g',
    '47,Ag,116,115.9113868(35),,107.8682(2),g',
    '47,Ag,117,116.911774(15),,107.8682(2),g',
    '47,Ag,118,117.9145955(27),,107.8682(2),g',
    '47,Ag,119,118.915570(16),,107.8682(2),g',
    '47,Ag,120,119.9187848(48),,107.8682(2),g',
    '47,Ag,121,120.920125(13),,107.8682(2),g',
    '47,Ag,122,121.923664(41),,107.8682(2),g',
    '47,Ag,123,122.925337(33),,107.8682(2),g',
    '47,Ag,124,123.92893(27),,107.8682(2),g',
    '47,Ag,125,124.93105(64),,107.8682(2),g',
    '47,Ag,126,125.93475(21#),,107.8682(2),g',
    '47,Ag,127,126.93711(21#),,107.8682(2),g',
    '47,Ag,128,127.94106(32#),,107.8682(2),g',
    '47,Ag,129,128.94395(32#),,107.8682(2),g',
    '47,Ag,130,129.95070(36#),,107.8682(2),g',
    '48,Cd,95,94.94994(54#),,112.414(4),g',
    '48,Cd,96,95.94034(43#),,112.414(4),g',
    '48,Cd,97,96.93510(32#),,112.414(4),g',
    '48,Cd,98,97.927389(56),,112.414(4),g',
    '48,Cd,99,98.9249258(17),,112.414(4),g',
    '48,Cd,100,99.9203488(18),,112.414(4),g',
    '48,Cd,101,100.9185862(16),,112.414(4),g',
    '48,Cd,102,101.9144820(18),,112.414(4),g',
    '48,Cd,103,102.9134165(19),,112.414(4),g',
    '48,Cd,104,103.9098564(18),,112.414(4),g',
    '48,Cd,105,104.9094639(15),,112.414(4),g',
    '48,Cd,106,105.9064599(12),0.0125(6),112.414(4),g',
    '48,Cd,107,106.9066121(18),,112.414(4),g',
    '48,Cd,108,107.9041834(12),0.0089(3),112.414(4),g',
    '48,Cd,109,108.9049867(17),,112.414(4),g',
    '48,Cd,110,109.90300661(61),0.1249(18),112.414(4),g',
    '48,Cd,111,110.90418287(61),0.1280(12),112.414(4),g',
    '48,Cd,112,111.90276287(60),0.2413(21),112.414(4),g',
    '48,Cd,113,112.90440813(45),0.1222(12),112.414(4),g',
    '48,Cd,114,113.90336509(43),0.2873(42),112.414(4),g',
    '48,Cd,115,114.90543751(77),,112.414(4),g',
    '48,Cd,116,115.90476315(17),0.0749(18),112.414(4),g',
    '48,Cd,117,116.9072260(11),,112.414(4),g',
    '48,Cd,118,117.906922(21),,112.414(4),g',
    '48,Cd,119,118.909847(40),,112.414(4),g',
    '48,Cd,120,119.9098681(40),,112.414(4),g',
    '48,Cd,121,120.9129637(21),,112.414(4),g',
    '48,Cd,122,121.9134591(25),,112.414(4),g',
    '48,Cd,123,122.9168925(29),,112.414(4),g',
    '48,Cd,124,123.9176574(32),,112.414(4),g',
    '48,Cd,125,124.9212576(31),,112.414(4),g',
    '48,Cd,126,125.9224291(27),,112.414(4),g',
    '48,Cd,127,126.926472(14),,112.414(4),g',
    '48,Cd,128,127.9278129(78),,112.414(4),g',
    '48,Cd,129,128.93182(21#),,112.414(4),g',
    '48,Cd,130,129.93394(18),,112.414(4),g',
    '48,Cd,131,130.94060(21#),,112.414(4),g',
    '48,Cd,132,131.94604(21#),,112.414(4),g',
    '48,Cd,133,132.95285(32#),,112.414(4),g',
    '49,In,97,96.94934(54#),,114.818(1),',
    '49,In,98,97.94214(21#),,114.818(1),',
    '49,In,99,98.93411(21#),,114.818(1),',
    '49,In,100,99.93096(20),,114.818(1),',
    '49,In,101,100.92634(32#),,114.818(1),',
    '49,In,102,101.9241071(49),,114.818(1),',
    '49,In,103,102.9198819(98),,114.818(1),',
    '49,In,104,103.9182145(62),,114.818(1),',
    '49,In,105,104.914502(11),,114.818(1),',
    '49,In,106,105.913464(13),,114.818(1),',
    '49,In,107,106.910290(12),,114.818(1),',
    '49,In,108,107.9096935(93),,114.818(1),',
    '49,In,109,108.9071514(43),,114.818(1),',
    '49,In,110,109.907170(12),,114.818(1),',
    '49,In,111,110.9051085(38),,114.818(1),',
    '49,In,112,111.9055377(46),,114.818(1),',
    '49,In,113,112.90406184(91),0.0429(5),114.818(1),',
    '49,In,114,113.90491791(94),,114.818(1),',
    '49,In,115,114.903878776(12),0.9571(5),114.818(1),',
    '49,In,116,115.90525999(24),,114.818(1),',
    '49,In,117,116.9045157(52),,114.818(1),',
    '49,In,118,117.9063566(83),,114.818(1),',
    '49,In,119,118.9058507(78),,114.818(1),',
    '49,In,120,119.907967(43),,114.818(1),',
    '49,In,121,120.907851(29),,114.818(1),',
    '49,In,122,121.910281(54),,114.818(1),',
    '49,In,123,122.910434(21),,114.818(1),',
    '49,In,124,123.913182(33),,114.818(1),',
    '49,In,125,124.913605(29),,114.818(1),',
    '49,In,126,125.916507(29),,114.818(1),',
    '49,In,127,126.917446(23),,114.818(1),',
    '49,In,128,127.92040(16),,114.818(1),',
    '49,In,129,128.9218053(29),,114.818(1),',
    '49,In,130,129.924977(41),,114.818(1),',
    '49,In,131,130.9269715(29),,114.818(1),',
    '49,In,132,131.933001(64),,114.818(1),',
    '49,In,133,132.93831(21#),,114.818(1),',
    '49,In,134,133.94454(32#),,114.818(1),',
    '49,In,135,134.95005(43#),,114.818(1),',
    '50,Sn,99,98.94853(54#),,118.710(7),g',
    '50,Sn,100,99.93850(32),,118.710(7),g',
    '50,Sn,101,100.93526(32),,118.710(7),g',
    '50,Sn,102,101.93029(11),,118.710(7),g',
    '50,Sn,103,102.928105(76),,118.710(7),g',
    '50,Sn,104,103.9231052(62),,118.710(7),g',
    '50,Sn,105,104.9212684(43),,118.710(7),g',
    '50,Sn,106,105.9169574(55),,118.710(7),g',
    '50,Sn,107,106.9157137(57),,118.710(7),g',
    '50,Sn,108,107.9118943(58),,118.710(7),g',
    '50,Sn,109,108.9112921(85),,118.710(7),g',
    '50,Sn,110,109.907845(15),,118.710(7),g',
    '50,Sn,111,110.9077401(58),,118.710(7),g',
    '50,Sn,112,111.90482387(61),0.0097(1),118.710(7),g',
    '50,Sn,113,112.9051757(18),,118.710(7),g',
    '50,Sn,114,113.9027827(10),0.0066(1),118.710(7),g',
    '50,Sn,115,114.903344699(16),0.0034(1),118.710(7),g',
    '50,Sn,116,115.90174280(10),0.1454(9),118.710(7),g',
    '50,Sn,117,116.90295398(52),0.0768(7),118.710(7),g',
    '50,Sn,118,117.90160657(54),0.2422(9),118.710(7),g',
    '50,Sn,119,118.90331117(78),0.0859(4),118.710(7),g',
    '50,Sn,120,119.90220163(97),0.3258(9),118.710(7),g',
    '50,Sn,121,120.9042426(10),,118.710(7),g',
    '50,Sn,122,121.9034438(26),0.0463(3),118.710(7),g',
    '50,Sn,123,122.9057252(26),,118.710(7),g',
    '50,Sn,124,123.9052766(11),0.0579(5),118.710(7),g',
    '50,Sn,125,124.9077864(11),,118.710(7),g',
    '50,Sn,126,125.907659(11),,118.710(7),g',
    '50,Sn,127,126.910390(11),,118.710(7),g',
    '50,Sn,128,127.910507(19),,118.710(7),g',
    '50,Sn,129,128.913465(21),,118.710(7),g',
    '50,Sn,130,129.9139738(23),,118.710(7),g',
    '50,Sn,131,130.9170450(65),,118.710(7),g',
    '50,Sn,132,131.9178267(31),,118.710(7),g',
    '50,Sn,133,132.9239134(26),,118.710(7),g',
    '50,Sn,134,133.9286821(35),,118.710(7),g',
    '50,Sn,135,134.9349086(33),,118.710(7),g',
    '50,Sn,136,135.93999(43#),,118.710(7),g',
    '50,Sn,137,136.94655(54#),,118.710(7),g',
    '50,Sn,138,137.95184(64#),,118.710(7),g',
    '51,Sb,103,102.93969(32#),,121.760(1),g',
    '51,Sb,104,103.93648(13),,121.760(1),g',
    '51,Sb,105,104.931276(23),,121.760(1),g',
    '51,Sb,106,105.9286380(80),,121.760(1),g',
    '51,Sb,107,106.9241506(45),,121.760(1),g',
    '51,Sb,108,107.9222267(59),,121.760(1),g',
    '51,Sb,109,108.9181411(57),,121.760(1),g',
    '51,Sb,110,109.9168543(64),,121.760(1),g',
    '51,Sb,111,110.9132182(95),,121.760(1),g',
    '51,Sb,112,111.912400(19),,121.760(1),g',
    '51,Sb,113,112.909375(18),,121.760(1),g',
    '51,Sb,114,113.909290(23),,121.760(1),g',
    '51,Sb,115,114.906598(17),,121.760(1),g',
    '51,Sb,116,115.9067931(55),,121.760(1),g',
    '51,Sb,117,116.9048415(91),,121.760(1),g',
    '51,Sb,118,117.9055321(32),,121.760(1),g',
    '51,Sb,119,118.9039455(83),,121.760(1),g',
    '51,Sb,120,119.9050794(77),,121.760(1),g',
    '51,Sb,121,120.9038120(30),0.5721(5),121.760(1),g',
    '51,Sb,122,121.9051699(30),,121.760(1),g',
    '51,Sb,123,122.9042132(23),0.4279(5),121.760(1),g',
    '51,Sb,124,123.9059350(23),,121.760(1),g',
    '51,Sb,125,124.9052530(28),,121.760(1),g',
    '51,Sb,126,125.907253(34),,121.760(1),g',
    '51,Sb,127,126.9069243(55),,121.760(1),g',
    '51,Sb,128,127.909146(21),,121.760(1),g',
    '51,Sb,129,128.909147(23),,121.760(1),g',
    '51,Sb,130,129.911662(15),,121.760(1),g',
    '51,Sb,131,130.9119888(23),,121.760(1),g',
    '51,Sb,132,131.9145077(29),,121.760(1),g',
    '51,Sb,133,132.9152732(34),,121.760(1),g',
    '51,Sb,134,133.9205357(18),,121.760(1),g',
    '51,Sb,135,134.9251851(31),,121.760(1),g',
    '51,Sb,136,135.9307459(68),,121.760(1),g',
    '51,Sb,137,136.93555(32),,121.760(1),g',
    '51,Sb,138,137.94145(32#),,121.760(1),g',
    '51,Sb,139,138.94655(43#),,121.760(1),g',
    '51,Sb,140,139.95283(64#),,121.760(1),g',
    '52,Te,105,104.94330(32),,127.60(3),g',
    '52,Te,106,105.93750(11),,127.60(3),g',
    '52,Te,107,106.935012(76),,127.60(3),g',
    '52,Te,108,107.9293805(58),,127.60(3),g',
    '52,Te,109,108.9273045(47),,127.60(3),g',
    '52,Te,110,109.9224581(71),,127.60(3),g',
    '52,Te,111,110.9210006(69),,127.60(3),g',
    '52,Te,112,111.9167279(90),,127.60(3),g',
    '52,Te,113,112.915891(30),,127.60(3),g',
    '52,Te,114,113.912089(30),,127.60(3),g',
    '52,Te,115,114.911902(30),,127.60(3),g',
    '52,Te,116,115.908460(30),,127.60(3),g',
    '52,Te,117,116.908646(14),,127.60(3),g',
    '52,Te,118,117.905854(20),,127.60(3),g',
    '52,Te,119,118.9064071(85),,127.60(3),g',
    '52,Te,120,119.9040593(33),0.0009(1),127.60(3),g',
    '52,Te,121,120.904944(28),,127.60(3),g',
    '52,Te,122,121.9030435(16),0.0255(12),127.60(3),g',
    '52,Te,123,122.9042698(16),0.0089(3),127.60(3),g',
    '52,Te,124,123.9028171(16),0.0474(14),127.60(3),g',
    '52,Te,125,124.9044299(16),0.0707(15),127.60(3),g',
    '52,Te,126,125.9033109(16),0.1884(25),127.60(3),g',
    '52,Te,127,126.9052257(16),,127.60(3),g',
    '52,Te,128,127.90446128(93),0.3174(8),127.60(3),g',
    '52,Te,129,128.90659646(93),,127.60(3),g',
    '52,Te,130,129.906222748(12),0.3408(62),127.60(3),g',
    '52,Te,131,130.908522213(65),,127.60(3),g',
    '52,Te,132,131.9085467(37),,127.60(3),g',
    '52,Te,133,132.9109688(39),,127.60(3),g',
    '52,Te,134,133.9113940(30),,127.60(3),g',
    '52,Te,135,134.9165557(29),,127.60(3),g',
    '52,Te,136,135.9201006(26),,127.60(3),g',
    '52,Te,137,136.9255989(27),,127.60(3),g',
    '52,Te,138,137.9294722(47),,127.60(3),g',
    '52,Te,139,138.9353672(38),,127.60(3),g',
    '52,Te,140,139.939499(30),,127.60(3),g',
    '52,Te,141,140.94580(43#),,127.60(3),g',
    '52,Te,142,141.95022(54#),,127.60(3),g',
    '52,Te,143,142.95676(54#),,127.60(3),g',
    '53,I,107,106.94678(32#),,126.90447(3),',
    '53,I,108,107.94348(14),,126.90447(3),',
    '53,I,109,108.9380853(61),,126.90447(3),',
    '53,I,110,109.935089(54),,126.90447(3),',
    '53,I,111,110.9302692(51),,126.90447(3),',
    '53,I,112,111.928005(11),,126.90447(3),',
    '53,I,113,112.9236501(86),,126.90447(3),',
    '53,I,114,113.92185(32#),,126.90447(3),',
    '53,I,115,114.918048(31),,126.90447(3),',
    '53,I,116,115.91681(10),,126.90447(3),',
    '53,I,117,116.913648(28),,126.90447(3),',
    '53,I,118,117.913074(21),,126.90447(3),',
    '53,I,119,118.910074(30),,126.90447(3),',
    '53,I,120,119.910087(16),,126.90447(3),',
    '53,I,121,120.9074051(58),,126.90447(3),',
    '53,I,122,121.9075888(56),,126.90447(3),',
    '53,I,123,122.9055885(40),,126.90447(3),',
    '53,I,124,123.9062090(26),,126.90447(3),',
    '53,I,125,124.9046294(16),,126.90447(3),',
    '53,I,126,125.9056233(41),,126.90447(3),',
    '53,I,127,126.9044719(39),1,126.90447(3),',
    '53,I,128,127.9058086(39),,126.90447(3),',
    '53,I,129,128.9049837(34),,126.90447(3),',
    '53,I,130,129.9066702(34),,126.90447(3),',
    '53,I,131,130.90612630(69),,126.90447(3),',
    '53,I,132,131.9079935(44),,126.90447(3),',
    '53,I,133,132.9077970(50),,126.90447(3),',
    '53,I,134,133.9097588(59),,126.90447(3),',
    '53,I,135,134.9100488(58),,126.90447(3),',
    '53,I,136,135.914604(15),,126.90447(3),',
    '53,I,137,136.9180282(90),,126.90447(3),',
    '53,I,138,137.9227264(64),,126.90447(3),',
    '53,I,139,138.926506(31),,126.90447(3),',
    '53,I,140,139.93173(20),,126.90447(3),',
    '53,I,141,140.93569(21#),,126.90447(3),',
    '53,I,142,141.94120(40),,126.90447(3),',
    '53,I,143,142.94565(32#),,126.90447(3),',
    '53,I,144,143.95139(43#),,126.90447(3),',
    '53,I,145,144.95605(54#),,126.90447(3),',
    '54,Xe,109,108.95043(32),,131.293(6),"g,m"',
    '54,Xe,110,109.94426(11),,131.293(6),"g,m"',
    '54,Xe,111,110.941607(93),,131.293(6),"g,m"',
    '54,Xe,112,111.9355590(89),,131.293(6),"g,m"',
    '54,Xe,113,112.9332217(73),,131.293(6),"g,m"',
    '54,Xe,114,113.927980(12),,131.293(6),"g,m"',
    '54,Xe,115,114.926294(13),,131.293(6),"g,m"',
    '54,Xe,116,115.921581(14),,131.293(6),"g,m"',
    '54,Xe,117,116.920359(11),,131.293(6),"g,m"',
    '54,Xe,118,117.916179(11),,131.293(6),"g,m"',
    '54,Xe,119,118.915411(11),,131.293(6),"g,m"',
    '54,Xe,120,119.911784(13),,131.293(6),"g,m"',
    '54,Xe,121,120.911453(11),,131.293(6),"g,m"',
    '54,Xe,122,121.908368(12),,131.293(6),"g,m"',
    '54,Xe,123,122.908482(10),,131.293(6),"g,m"',
    '54,Xe,124,123.9058920(19),0.000952(3),131.293(6),"g,m"',
    '54,Xe,125,124.9063944(20),,131.293(6),"g,m"',
    '54,Xe,126,125.9042983(38),0.000890(2),131.293(6),"g,m"',
    '54,Xe,127,126.9051829(44),,131.293(6),"g,m"',
    '54,Xe,128,127.9035310(11),0.019102(8),131.293(6),"g,m"',
    '54,Xe,129,128.9047808611(60),0.264006(82),131.293(6),"g,m"',
    '54,Xe,130,129.903509349(10),0.040710(13),131.293(6),"g,m"',
    '54,Xe,131,130.90508406(24),0.212324(30),131.293(6),"g,m"',
    '54,Xe,132,131.9041550856(56),0.269086(33),131.293(6),"g,m"',
    '54,Xe,133,132.9059108(26),,131.293(6),"g,m"',
    '54,Xe,134,133.90539466(90),0.104357(21),131.293(6),"g,m"',
    '54,Xe,135,134.9072278(45),,131.293(6),"g,m"',
    '54,Xe,136,135.907214484(11),0.088573(44),131.293(6),"g,m"',
    '54,Xe,137,136.91155778(11),,131.293(6),"g,m"',
    '54,Xe,138,137.9141463(30),,131.293(6),"g,m"',
    '54,Xe,139,138.9187922(23),,131.293(6),"g,m"',
    '54,Xe,140,139.9216458(25),,131.293(6),"g,m"',
    '54,Xe,141,140.9267872(31),,131.293(6),"g,m"',
    '54,Xe,142,141.9299731(29),,131.293(6),"g,m"',
    '54,Xe,143,142.9353696(50),,131.293(6),"g,m"',
    '54,Xe,144,143.9389451(57),,131.293(6),"g,m"',
    '54,Xe,145,144.944720(12),,131.293(6),"g,m"',
    '54,Xe,146,145.948518(26),,131.293(6),"g,m"',
    '54,Xe,147,146.95426(21#),,131.293(6),"g,m"',
    '54,Xe,148,147.95813(21#),,131.293(6),"g,m"',
    '55,Cs,112,111.950309(93),,132.90545196(6),',
    '55,Cs,113,112.9444291(93),,132.90545196(6),',
    '55,Cs,114,113.941296(76),,132.90545196(6),',
    '55,Cs,115,114.93591(32#),,132.90545196(6),',
    '55,Cs,116,115.93337(11#),,132.90545196(6),',
    '55,Cs,117,116.928617(67),,132.90545196(6),',
    '55,Cs,118,117.926560(14),,132.90545196(6),',
    '55,Cs,119,118.922377(15),,132.90545196(6),',
    '55,Cs,120,119.920677(11),,132.90545196(6),',
    '55,Cs,121,120.917227(15),,132.90545196(6),',
    '55,Cs,122,121.916108(36),,132.90545196(6),',
    '55,Cs,123,122.912996(13),,132.90545196(6),',
    '55,Cs,124,123.9122578(89),,132.90545196(6),',
    '55,Cs,125,124.9097280(83),,132.90545196(6),',
    '55,Cs,126,125.909446(11),,132.90545196(6),',
    '55,Cs,127,126.9074174(60),,132.90545196(6),',
    '55,Cs,128,127.9077487(58),,132.90545196(6),',
    '55,Cs,129,128.9060657(49),,132.90545196(6),',
    '55,Cs,130,129.9067093(90),,132.90545196(6),',
    '55,Cs,131,130.9054649(53),,132.90545196(6),',
    '55,Cs,132,131.9064339(21),,132.90545196(6),',
    '55,Cs,133,132.9054519610(80),1,132.90545196(6),',
    '55,Cs,134,133.906718503(17),,132.90545196(6),',
    '55,Cs,135,134.9059770(11),,132.90545196(6),',
    '55,Cs,136,135.9073114(20),,132.90545196(6),',
    '55,Cs,137,136.90708923(36),,132.90545196(6),',
    '55,Cs,138,137.9110171(98),,132.90545196(6),',
    '55,Cs,139,138.9133638(34),,132.90545196(6),',
    '55,Cs,140,139.9172831(88),,132.90545196(6),',
    '55,Cs,141,140.9200455(98),,132.90545196(6),',
    '55,Cs,142,141.9242960(79),,132.90545196(6),',
    '55,Cs,143,142.927349(24),,132.90545196(6),',
    '55,Cs,144,143.932076(27),,132.90545196(6),',
    '55,Cs,145,144.935527(12),,132.90545196(6),',
    '55,Cs,146,145.940344(42),,132.90545196(6),',
    '55,Cs,147,146.944156(57),,132.90545196(6),',
    '55,Cs,148,147.94923(62),,132.90545196(6),',
    '55,Cs,149,148.95302(21#),,132.90545196(6),',
    '55,Cs,150,149.95833(32#),,132.90545196(6),',
    '55,Cs,151,150.96258(43#),,132.90545196(6),',
    '56,Ba,114,113.95066(12),,137.327(7),',
    '56,Ba,115,114.94737(54#),,137.327(7),',
    '56,Ba,116,115.94128(32#),,137.327(7),',
    '56,Ba,117,116.93814(21),,137.327(7),',
    '56,Ba,118,117.93306(21#),,137.327(7),',
    '56,Ba,119,118.93066(21),,137.327(7),',
    '56,Ba,120,119.92605(32),,137.327(7),',
    '56,Ba,121,120.92405(15),,137.327(7),',
    '56,Ba,122,121.919904(30),,137.327(7),',
    '56,Ba,123,122.918781(13),,137.327(7),',
    '56,Ba,124,123.915094(13),,137.327(7),',
    '56,Ba,125,124.914472(12),,137.327(7),',
    '56,Ba,126,125.911250(13),,137.327(7),',
    '56,Ba,127,126.911091(12),,137.327(7),',
    '56,Ba,128,127.9083420(56),,137.327(7),',
    '56,Ba,129,128.908681(11),,137.327(7),',
    '56,Ba,130,129.9063207(28),0.00106(1),137.327(7),',
    '56,Ba,131,130.9069410(28),,137.327(7),',
    '56,Ba,132,131.9050611(11),0.00101(1),137.327(7),',
    '56,Ba,133,132.9060074(11),,137.327(7),',
    '56,Ba,134,133.90450818(30),0.02417(18),137.327(7),',
    '56,Ba,135,134.90568838(29),0.06592(12),137.327(7),',
    '56,Ba,136,135.90457573(29),0.07854(24),137.327(7),',
    '56,Ba,137,136.90582714(30),0.11232(24),137.327(7),',
    '56,Ba,138,137.90524700(31),0.71698(42),137.327(7),',
    '56,Ba,139,138.90884110(31),,137.327(7),',
    '56,Ba,140,139.9106057(85),,137.327(7),',
    '56,Ba,141,140.9144033(57),,137.327(7),',
    '56,Ba,142,141.9164324(64),,137.327(7),',
    '56,Ba,143,142.9206253(74),,137.327(7),',
    '56,Ba,144,143.9229549(77),,137.327(7),',
    '56,Ba,145,144.9275184(91),,137.327(7),',
    '56,Ba,146,145.930284(22),,137.327(7),',
    '56,Ba,147,146.935304(21),,137.327(7),',
    '56,Ba,148,147.938171(68),,137.327(7),',
    '56,Ba,149,148.94308(21#),,137.327(7),',
    '56,Ba,150,149.94605(32#),,137.327(7),',
    '56,Ba,151,150.95127(32#),,137.327(7),',
    '56,Ba,152,151.95481(43#),,137.327(7),',
    '56,Ba,153,152.96036(43#),,137.327(7),',
    '57,La,116,115.95630(23#),,138.90547(7),g',
    '57,La,117,116.94999(32#),,138.90547(7),g',
    '57,La,118,117.94673(32#),,138.90547(7),g',
    '57,La,119,118.94099(32#),,138.90547(7),g',
    '57,La,120,119.93807(32#),,138.90547(7),g',
    '57,La,121,120.93315(32#),,138.90547(7),g',
    '57,La,122,121.93071(32#),,138.90547(7),g',
    '57,La,123,122.92630(21#),,138.90547(7),g',
    '57,La,124,123.924574(61),,138.90547(7),g',
    '57,La,125,124.920816(28),,138.90547(7),g',
    '57,La,126,125.919513(97),,138.90547(7),g',
    '57,La,127,126.916375(28),,138.90547(7),g',
    '57,La,128,127.915592(58),,138.90547(7),g',
    '57,La,129,128.912694(23),,138.90547(7),g',
    '57,La,130,129.912369(28),,138.90547(7),g',
    '57,La,131,130.910070(30),,138.90547(7),g',
    '57,La,132,131.910119(39),,138.90547(7),g',
    '57,La,133,132.908218(30),,138.90547(7),g',
    '57,La,134,133.908514(21),,138.90547(7),g',
    '57,La,135,134.906984(10),,138.90547(7),g',
    '57,La,136,135.907635(57),,138.90547(7),g',
    '57,La,137,136.9064504(18),,138.90547(7),g',
    '57,La,138,137.9071149(37),0.0008881(71),138.90547(7),g',
    '57,La,139,138.9063563(24),0.9991119(71),138.90547(7),g',
    '57,La,140,139.9094806(24),,138.90547(7),g',
    '57,La,141,140.9109660(48),,138.90547(7),g',
    '57,La,142,141.9140909(69),,138.90547(7),g',
    '57,La,143,142.9160795(79),,138.90547(7),g',
    '57,La,144,143.919646(14),,138.90547(7),g',
    '57,La,145,144.921808(13),,138.90547(7),g',
    '57,La,146,145.925875(36),,138.90547(7),g',
    '57,La,147,146.928418(12),,138.90547(7),g',
    '57,La,148,147.932679(21),,138.90547(7),g',
    '57,La,149,148.93535(21),,138.90547(7),g',
    '57,La,150,149.93947(21#),,138.90547(7),g',
    '57,La,151,150.94232(21#),,138.90547(7),g',
    '57,La,152,151.94682(32#),,138.90547(7),g',
    '57,La,153,152.95036(32#),,138.90547(7),g',
    '57,La,154,153.95517(43#),,138.90547(7),g',
    '57,La,155,154.95901(43#),,138.90547(7),g',
    '58,Ce,119,118.95271(54#),,140.116(1),g',
    '58,Ce,120,119.94654(54#),,140.116(1),g',
    '58,Ce,121,120.94335(43#),,140.116(1),g',
    '58,Ce,122,121.93787(43#),,140.116(1),g',
    '58,Ce,123,122.93528(32#),,140.116(1),g',
    '58,Ce,124,123.93031(32#),,140.116(1),g',
    '58,Ce,125,124.92844(21#),,140.116(1),g',
    '58,Ce,126,125.923971(30),,140.116(1),g',
    '58,Ce,127,126.922727(31),,140.116(1),g',
    '58,Ce,128,127.918911(30),,140.116(1),g',
    '58,Ce,129,128.918102(30),,140.116(1),g',
    '58,Ce,130,129.914736(30),,140.116(1),g',
    '58,Ce,131,130.914429(35),,140.116(1),g',
    '58,Ce,132,131.911464(22),,140.116(1),g',
    '58,Ce,133,132.911520(18),,140.116(1),g',
    '58,Ce,134,133.908928(22),,140.116(1),g',
    '58,Ce,135,134.909161(11),,140.116(1),g',
    '58,Ce,136,135.90712921(41),0.00185(2),140.116(1),g',
    '58,Ce,137,136.90776236(45),,140.116(1),g',
    '58,Ce,138,137.905991(11),0.00251(2),140.116(1),g',
    '58,Ce,139,138.9066551(78),,140.116(1),g',
    '58,Ce,140,139.9054431(23),0.88450(51),140.116(1),g',
    '58,Ce,141,140.9082807(23),,140.116(1),g',
    '58,Ce,142,141.9092504(29),0.11114(51),140.116(1),g',
    '58,Ce,143,142.9123921(29),,140.116(1),g',
    '58,Ce,144,143.9136529(34),,140.116(1),g',
    '58,Ce,145,144.917265(36),,140.116(1),g',
    '58,Ce,146,145.918802(18),,140.116(1),g',
    '58,Ce,147,146.9226899(92),,140.116(1),g',
    '58,Ce,148,147.924424(12),,140.116(1),g',
    '58,Ce,149,148.928427(11),,140.116(1),g',
    '58,Ce,150,149.930384(13),,140.116(1),g',
    '58,Ce,151,150.934272(19),,140.116(1),g',
    '58,Ce,152,151.93660(21#),,140.116(1),g',
    '58,Ce,153,152.94093(21#),,140.116(1),g',
    '58,Ce,154,153.94380(32#),,140.116(1),g',
    '58,Ce,155,154.94855(43#),,140.116(1),g',
    '58,Ce,156,155.95183(43#),,140.116(1),g',
    '58,Ce,157,156.95705(54#),,140.116(1),g',
    '59,Pr,121,120.95532(54#),,140.90766(2),',
    '59,Pr,122,121.95175(54#),,140.90766(2),',
    '59,Pr,123,122.94596(43#),,140.90766(2),',
    '59,Pr,124,123.94294(43#),,140.90766(2),',
    '59,Pr,125,124.93770(32#),,140.90766(2),',
    '59,Pr,126,125.93524(21#),,140.90766(2),',
    '59,Pr,127,126.93071(21#),,140.90766(2),',
    '59,Pr,128,127.928791(32),,140.90766(2),',
    '59,Pr,129,128.925095(32),,140.90766(2),',
    '59,Pr,130,129.923590(69),,140.90766(2),',
    '59,Pr,131,130.920235(50),,140.90766(2),',
    '59,Pr,132,131.919255(61),,140.90766(2),',
    '59,Pr,133,132.916331(13),,140.90766(2),',
    '59,Pr,134,133.915697(22),,140.90766(2),',
    '59,Pr,135,134.913112(13),,140.90766(2),',
    '59,Pr,136,135.912677(12),,140.90766(2),',
    '59,Pr,137,136.9106792(87),,140.90766(2),',
    '59,Pr,138,137.910754(15),,140.90766(2),',
    '59,Pr,139,138.9089408(85),,140.90766(2),',
    '59,Pr,140,139.9090803(69),,140.90766(2),',
    '59,Pr,141,140.9076576(23),1,140.90766(2),',
    '59,Pr,142,141.9100496(23),,140.90766(2),',
    '59,Pr,143,142.9108228(24),,140.90766(2),',
    '59,Pr,144,143.9133109(32),,140.90766(2),',
    '59,Pr,145,144.9145182(78),,140.90766(2),',
    '59,Pr,146,145.917680(37),,140.90766(2),',
    '59,Pr,147,146.919008(17),,140.90766(2),',
    '59,Pr,148,147.922130(16),,140.90766(2),',
    '59,Pr,149,148.923736(11),,140.90766(2),',
    '59,Pr,150,149.9266765(97),,140.90766(2),',
    '59,Pr,151,150.928309(13),,140.90766(2),',
    '59,Pr,152,151.931553(20),,140.90766(2),',
    '59,Pr,153,152.933904(13),,140.90766(2),',
    '59,Pr,154,153.93753(16),,140.90766(2),',
    '59,Pr,155,154.940509(18),,140.90766(2),',
    '59,Pr,156,155.94464(32#),,140.90766(2),',
    '59,Pr,157,156.94789(43#),,140.90766(2),',
    '59,Pr,158,157.95241(43#),,140.90766(2),',
    '59,Pr,159,158.95589(54#),,140.90766(2),',
    '60,Nd,124,123.95220(54#),,144.242(3),g',
    '60,Nd,125,124.94890(43#),,144.242(3),g',
    '60,Nd,126,125.94311(32#),,144.242(3),g',
    '60,Nd,127,126.94038(32#),,144.242(3),g',
    '60,Nd,128,127.93525(21#),,144.242(3),g',
    '60,Nd,129,128.93310(22#),,144.242(3),g',
    '60,Nd,130,129.928506(30),,144.242(3),g',
    '60,Nd,131,130.927248(30),,144.242(3),g',
    '60,Nd,132,131.923321(26),,144.242(3),g',
    '60,Nd,133,132.922348(50),,144.242(3),g',
    '60,Nd,134,133.918790(13),,144.242(3),g',
    '60,Nd,135,134.918181(21),,144.242(3),g',
    '60,Nd,136,135.914976(13),,144.242(3),g',
    '60,Nd,137,136.914562(13),,144.242(3),g',
    '60,Nd,138,137.911950(12),,144.242(3),g',
    '60,Nd,139,138.911954(30),,144.242(3),g',
    '60,Nd,140,139.909550(28),,144.242(3),g',
    '60,Nd,141,140.9096147(38),,144.242(3),g',
    '60,Nd,142,141.9077290(20),0.27152(40),144.242(3),g',
    '60,Nd,143,142.9098200(20),0.12174(26),144.242(3),g',
    '60,Nd,144,143.9100930(20),0.23798(19),144.242(3),g',
    '60,Nd,145,144.9125793(20),0.08293(12),144.242(3),g',
    '60,Nd,146,145.9131226(20),0.17189(32),144.242(3),g',
    '60,Nd,147,146.9161061(20),,144.242(3),g',
    '60,Nd,148,147.9168993(26),0.05756(21),144.242(3),g',
    '60,Nd,149,148.9201548(26),,144.242(3),g',
    '60,Nd,150,149.9209022(18),0.05638(28),144.242(3),g',
    '60,Nd,151,150.9238403(18),,144.242(3),g',
    '60,Nd,152,151.924692(26),,144.242(3),g',
    '60,Nd,153,152.9277180(29),,144.242(3),g',
    '60,Nd,154,153.92948(12),,144.242(3),g',
    '60,Nd,155,154.9331357(98),,144.242(3),g',
    '60,Nd,156,155.93508(21),,144.242(3),g',
    '60,Nd,157,156.939386(27),,144.242(3),g',
    '60,Nd,158,157.94197(32#),,144.242(3),g',
    '60,Nd,159,158.94653(43#),,144.242(3),g',
    '60,Nd,160,159.94940(43#),,144.242(3),g',
    '60,Nd,161,160.95428(54#),,144.242(3),g',
    '61,Pm,126,125.95792(54#),,[145],',
    '61,Pm,127,126.95192(43#),,[145],',
    '61,Pm,128,127.94870(32#),,[145],',
    '61,Pm,129,128.94323(32#),,[145],',
    '61,Pm,130,129.94053(21#),,[145],',
    '61,Pm,131,130.93567(21#),,[145],',
    '61,Pm,132,131.93384(16#),,[145],',
    '61,Pm,133,132.929782(54),,[145],',
    '61,Pm,134,133.928353(62),,[145],',
    '61,Pm,135,134.924823(70),,[145],',
    '61,Pm,136,135.923585(77),,[145],',
    '61,Pm,137,136.920480(14),,[145],',
    '61,Pm,138,137.919548(30),,[145],',
    '61,Pm,139,138.916800(15),,[145],',
    '61,Pm,140,139.916040(38),,[145],',
    '61,Pm,141,140.913555(15),,[145],',
    '61,Pm,142,141.912890(25),,[145],',
    '61,Pm,143,142.9109383(34),,[145],',
    '61,Pm,144,143.9125964(34),,[145],',
    '61,Pm,145,144.9127559(33),,[145],',
    '61,Pm,146,145.9147024(48),,[145],',
    '61,Pm,147,146.9151450(19),,[145],',
    '61,Pm,148,147.9174819(63),,[145],',
    '61,Pm,149,148.9183423(27),,[145],',
    '61,Pm,150,149.920991(22),,[145],',
    '61,Pm,151,150.9212175(51),,[145],',
    '61,Pm,152,151.923506(28),,[145],',
    '61,Pm,153,152.9241567(97),,[145],',
    '61,Pm,154,153.926472(48),,[145],',
    '61,Pm,155,154.9281370(51),,[145],',
    '61,Pm,156,155.9311175(39),,[145],',
    '61,Pm,157,156.9331214(75),,[145],',
    '61,Pm,158,157.936565(14),,[145],',
    '61,Pm,159,158.939287(11),,[145],',
    '61,Pm,160,159.94310(32#),,[145],',
    '61,Pm,161,160.94607(32#),,[145],',
    '61,Pm,162,161.95022(43#),,[145],',
    '61,Pm,163,162.95357(54#),,[145],',
    '62,Sm,128,127.95842(54#),,150.36(2),g',
    '62,Sm,129,128.95476(54#),,150.36(2),g',
    '62,Sm,130,129.94900(43#),,150.36(2),g',
    '62,Sm,131,130.94618(43#),,150.36(2),g',
    '62,Sm,132,131.94087(32#),,150.36(2),g',
    '62,Sm,133,132.93856(32#),,150.36(2),g',
    '62,Sm,134,133.93411(21#),,150.36(2),g',
    '62,Sm,135,134.93252(17),,150.36(2),g',
    '62,Sm,136,135.928276(13),,150.36(2),g',
    '62,Sm,137,136.926971(46),,150.36(2),g',
    '62,Sm,138,137.923244(13),,150.36(2),g',
    '62,Sm,139,138.922297(12),,150.36(2),g',
    '62,Sm,140,139.918995(13),,150.36(2),g',
    '62,Sm,141,140.9184816(92),,150.36(2),g',
    '62,Sm,142,141.9152044(36),,150.36(2),g',
    '62,Sm,143,142.9146353(33),,150.36(2),g',
    '62,Sm,144,143.9120065(21),0.0307(7),150.36(2),g',
    '62,Sm,145,144.9134173(21),,150.36(2),g',
    '62,Sm,146,145.9130470(35),,150.36(2),g',
    '62,Sm,147,146.9149044(19),0.1499(18),150.36(2),g',
    '62,Sm,148,147.9148292(19),0.1124(10),150.36(2),g',
    '62,Sm,149,148.9171921(18),0.1382(7),150.36(2),g',
    '62,Sm,150,149.9172829(18),0.0738(1),150.36(2),g',
    '62,Sm,151,150.9199398(18),,150.36(2),g',
    '62,Sm,152,151.9197397(18),0.2675(16),150.36(2),g',
    '62,Sm,153,152.9221047(18),,150.36(2),g',
    '62,Sm,154,153.9222169(20),0.2275(29),150.36(2),g',
    '62,Sm,155,154.9246477(20),,150.36(2),g',
    '62,Sm,156,155.925536(10),,150.36(2),g',
    '62,Sm,157,156.9284187(48),,150.36(2),g',
    '62,Sm,158,157.9299510(53),,150.36(2),g',
    '62,Sm,159,158.9332172(64),,150.36(2),g',
    '62,Sm,160,159.9353353(64),,150.36(2),g',
    '62,Sm,161,160.9391602(73),,150.36(2),g',
    '62,Sm,162,161.94146(21#),,150.36(2),g',
    '62,Sm,163,162.94555(32#),,150.36(2),g',
    '62,Sm,164,163.94836(32#),,150.36(2),g',
    '62,Sm,165,164.95297(43#),,150.36(2),g',
    '63,Eu,130,129.96369(54#),,151.964(1),g',
    '63,Eu,131,130.95784(43#),,151.964(1),g',
    '63,Eu,132,131.95467(43#),,151.964(1),g',
    '63,Eu,133,132.94929(32#),,151.964(1),g',
    '63,Eu,134,133.94640(32#),,151.964(1),g',
    '63,Eu,135,134.94187(21#),,151.964(1),g',
    '63,Eu,136,135.93962(21#),,151.964(1),g',
    '63,Eu,137,136.93546(21#),,151.964(1),g',
    '63,Eu,138,137.933709(30),,151.964(1),g',
    '63,Eu,139,138.929792(14),,151.964(1),g',
    '63,Eu,140,139.928088(55),,151.964(1),g',
    '63,Eu,141,140.924932(14),,151.964(1),g',
    '63,Eu,142,141.923442(32),,151.964(1),g',
    '63,Eu,143,142.920299(12),,151.964(1),g',
    '63,Eu,144,143.918820(12),,151.964(1),g',
    '63,Eu,145,144.9162726(36),,151.964(1),g',
    '63,Eu,146,145.9172110(65),,151.964(1),g',
    '63,Eu,147,146.9167527(31),,151.964(1),g',
    '63,Eu,148,147.918089(11),,151.964(1),g',
    '63,Eu,149,148.9179378(44),,151.964(1),g',
    '63,Eu,150,149.9197077(68),,151.964(1),g',
    '63,Eu,151,150.9198578(18),0.4781(6),151.964(1),g',
    '63,Eu,152,151.9217522(18),,151.964(1),g',
    '63,Eu,153,152.9212380(18),0.5219(6),151.964(1),g',
    '63,Eu,154,153.9229870(19),,151.964(1),g',
    '63,Eu,155,154.9229011(19),,151.964(1),g',
    '63,Eu,156,155.9247605(59),,151.964(1),g',
    '63,Eu,157,156.9254334(46),,151.964(1),g',
    '63,Eu,158,157.927799(11),,151.964(1),g',
    '63,Eu,159,158.9291001(47),,151.964(1),g',
    '63,Eu,160,159.931851(10),,151.964(1),g',
    '63,Eu,161,160.933664(11),,151.964(1),g',
    '63,Eu,162,161.936989(65),,151.964(1),g',
    '63,Eu,163,162.939196(76),,151.964(1),g',
    '63,Eu,164,163.94274(22#),,151.964(1),g',
    '63,Eu,165,164.94559(35#),,151.964(1),g',
    '63,Eu,166,165.94962(32#),,151.964(1),g',
    '63,Eu,167,166.95289(43#),,151.964(1),g',
    '64,Gd,133,132.96133(54#),,157.25(3),g',
    '64,Gd,134,133.95566(43#),,157.25(3),g',
    '64,Gd,135,134.95245(43#),,157.25(3),g',
    '64,Gd,136,135.94730(32#),,157.25(3),g',
    '64,Gd,137,136.94502(32#),,157.25(3),g',
    '64,Gd,138,137.94025(21#),,157.25(3),g',
    '64,Gd,139,138.93813(21#),,157.25(3),g',
    '64,Gd,140,139.933674(30),,157.25(3),g',
    '64,Gd,141,140.932126(21),,157.25(3),g',
    '64,Gd,142,141.928116(30),,157.25(3),g',
    '64,Gd,143,142.92675(22),,157.25(3),g',
    '64,Gd,144,143.922963(30),,157.25(3),g',
    '64,Gd,145,144.921713(21),,157.25(3),g',
    '64,Gd,146,145.9183188(46),,157.25(3),g',
    '64,Gd,147,146.9191014(25),,157.25(3),g',
    '64,Gd,148,147.9181215(21),,157.25(3),g',
    '64,Gd,149,148.9193481(38),,157.25(3),g',
    '64,Gd,150,149.9186644(66),,157.25(3),g',
    '64,Gd,151,150.9203560(35),,157.25(3),g',
    '64,Gd,152,151.9197995(18),0.0020(1),157.25(3),g',
    '64,Gd,153,152.9217580(18),,157.25(3),g',
    '64,Gd,154,153.9208741(17),0.0218(3),157.25(3),g',
    '64,Gd,155,154.9226305(17),0.1480(12),157.25(3),g',
    '64,Gd,156,155.9221312(17),0.2047(9),157.25(3),g',
    '64,Gd,157,156.9239686(17),0.1565(2),157.25(3),g',
    '64,Gd,158,157.9241123(17),0.2484(7),157.25(3),g',
    '64,Gd,159,158.9263970(17),,157.25(3),g',
    '64,Gd,160,159.9270624(18),0.2186(19),157.25(3),g',
    '64,Gd,161,160.9296775(21),,157.25(3),g',
    '64,Gd,162,161.9309930(45),,157.25(3),g',
    '64,Gd,163,162.9341769(90),,157.25(3),g',
    '64,Gd,164,163.93583(21#),,157.25(3),g',
    '64,Gd,165,164.93936(32#),,157.25(3),g',
    '64,Gd,166,165.94146(64#),,157.25(3),g',
    '64,Gd,167,166.94545(43#),,157.25(3),g',
    '64,Gd,168,167.94808(43#),,157.25(3),g',
    '64,Gd,169,168.95260(54#),,157.25(3),g',
    '65,Tb,135,134.96476(43#),,158.92535(2),',
    '65,Tb,136,135.96129(54#),,158.92535(2),',
    '65,Tb,137,136.95602(54#),,158.92535(2),',
    '65,Tb,138,137.95312(32#),,158.92535(2),',
    '65,Tb,139,138.94833(32#),,158.92535(2),',
    '65,Tb,140,139.94581(86),,158.92535(2),',
    '65,Tb,141,140.94145(11),,158.92535(2),',
    '65,Tb,142,141.93928(75),,158.92535(2),',
    '65,Tb,143,142.935137(55),,158.92535(2),',
    '65,Tb,144,143.933045(30),,158.92535(2),',
    '65,Tb,145,144.92882(10),,158.92535(2),',
    '65,Tb,146,145.927253(48),,158.92535(2),',
    '65,Tb,147,146.9240548(87),,158.92535(2),',
    '65,Tb,148,147.924282(14),,158.92535(2),',
    '65,Tb,149,148.9232535(41),,158.92535(2),',
    '65,Tb,150,149.9236649(80),,158.92535(2),',
    '65,Tb,151,150.9231096(46),,158.92535(2),',
    '65,Tb,152,151.924083(43),,158.92535(2),',
    '65,Tb,153,152.9234424(44),,158.92535(2),',
    '65,Tb,154,153.924685(49),,158.92535(2),',
    '65,Tb,155,154.923511(11),,158.92535(2),',
    '65,Tb,156,155.9247552(43),,158.92535(2),',
    '65,Tb,157,156.9240330(18),,158.92535(2),',
    '65,Tb,158,157.9254209(20),,158.92535(2),',
    '65,Tb,159,158.9253547(19),1,158.92535(2),',
    '65,Tb,160,159.9271756(19),,158.92535(2),',
    '65,Tb,161,160.9275778(20),,158.92535(2),',
    '65,Tb,162,161.929495(39),,158.92535(2),',
    '65,Tb,163,162.9306547(47),,158.92535(2),',
    '65,Tb,164,163.93336(11),,158.92535(2),',
    '65,Tb,165,164.93498(21#),,158.92535(2),',
    '65,Tb,166,165.937860(75),,158.92535(2),',
    '65,Tb,167,166.93996(21#),,158.92535(2),',
    '65,Tb,168,167.94340(32#),,158.92535(2),',
    '65,Tb,169,168.94597(32#),,158.92535(2),',
    '65,Tb,170,169.94984(43#),,158.92535(2),',
    '65,Tb,171,170.95273(54#),,158.92535(2),',
    '66,Dy,138,137.96250(43#),,162.500(1),g',
    '66,Dy,139,138.95959(54#),,162.500(1),g',
    '66,Dy,140,139.95402(54#),,162.500(1),g',
    '66,Dy,141,140.95128(32#),,162.500(1),g',
    '66,Dy,142,141.94619(78#),,162.500(1),g',
    '66,Dy,143,142.943994(14),,162.500(1),g',
    '66,Dy,144,143.9392695(77),,162.500(1),g',
    '66,Dy,145,144.9374740(70),,162.500(1),g',
    '66,Dy,146,145.9328445(72),,162.500(1),g',
    '66,Dy,147,146.9310827(95),,162.500(1),g',
    '66,Dy,148,147.927157(10),,162.500(1),g',
    '66,Dy,149,148.927322(10),,162.500(1),g',
    '66,Dy,150,149.9255933(48),,162.500(1),g',
    '66,Dy,151,150.9261916(38),,162.500(1),g',
    '66,Dy,152,151.9247253(51),,162.500(1),g',
    '66,Dy,153,152.9257724(45),,162.500(1),g',
    '66,Dy,154,153.9244293(80),,162.500(1),g',
    '66,Dy,155,154.925759(10),,162.500(1),g',
    '66,Dy,156,155.9242847(17),0.00056(3),162.500(1),g',
    '66,Dy,157,156.9254707(57),,162.500(1),g',
    '66,Dy,158,157.9244159(31),0.00095(3),162.500(1),g',
    '66,Dy,159,158.9257470(22),,162.500(1),g',
    '66,Dy,160,159.9252046(20),0.02329(18),162.500(1),g',
    '66,Dy,161,160.9269405(20),0.18889(42),162.500(1),g',
    '66,Dy,162,161.9268056(20),0.25475(36),162.500(1),g',
    '66,Dy,163,162.9287383(20),0.24896(42),162.500(1),g',
    '66,Dy,164,163.9291819(20),0.28260(54),162.500(1),g',
    '66,Dy,165,164.9317105(20),,162.500(1),g',
    '66,Dy,166,165.9328139(21),,162.500(1),g',
    '66,Dy,167,166.935661(65),,162.500(1),g',
    '66,Dy,168,167.93713(15),,162.500(1),g',
    '66,Dy,169,168.94031(32),,162.500(1),g',
    '66,Dy,170,169.94239(21#),,162.500(1),g',
    '66,Dy,171,170.94612(32#),,162.500(1),g',
    '66,Dy,172,171.94846(32#),,162.500(1),g',
    '66,Dy,173,172.95283(43#),,162.500(1),g',
    '67,Ho,140,139.96859(54#),,164.93033(2),',
    '67,Ho,141,140.96311(54#),,164.93033(2),',
    '67,Ho,142,141.96001(54#),,164.93033(2),',
    '67,Ho,143,142.95486(43#),,164.93033(2),',
    '67,Ho,144,143.9521097(91),,164.93033(2),',
    '67,Ho,145,144.9472674(80),,164.93033(2),',
    '67,Ho,146,145.9449935(71),,164.93033(2),',
    '67,Ho,147,146.9401423(54),,164.93033(2),',
    '67,Ho,148,147.937744(90),,164.93033(2),',
    '67,Ho,149,148.933803(16),,164.93033(2),',
    '67,Ho,150,149.933498(15),,164.93033(2),',
    '67,Ho,151,150.9316983(89),,164.93033(2),',
    '67,Ho,152,151.931724(14),,164.93033(2),',
    '67,Ho,153,152.9302064(56),,164.93033(2),',
    '67,Ho,154,153.9306068(89),,164.93033(2),',
    '67,Ho,155,154.929104(19),,164.93033(2),',
    '67,Ho,156,155.929706(64),,164.93033(2),',
    '67,Ho,157,156.928254(25),,164.93033(2),',
    '67,Ho,158,157.928946(29),,164.93033(2),',
    '67,Ho,159,158.9277197(36),,164.93033(2),',
    '67,Ho,160,159.928737(16),,164.93033(2),',
    '67,Ho,161,160.9278615(30),,164.93033(2),',
    '67,Ho,162,161.9291023(39),,164.93033(2),',
    '67,Ho,163,162.9287410(20),,164.93033(2),',
    '67,Ho,164,163.9302403(25),,164.93033(2),',
    '67,Ho,165,164.9303288(21),1,164.93033(2),',
    '67,Ho,166,165.9322909(21),,164.93033(2),',
    '67,Ho,167,166.9331385(59),,164.93033(2),',
    '67,Ho,168,167.935522(32),,164.93033(2),',
    '67,Ho,169,168.936878(22),,164.93033(2),',
    '67,Ho,170,169.939625(54),,164.93033(2),',
    '67,Ho,171,170.94147(64),,164.93033(2),',
    '67,Ho,172,171.94473(21#),,164.93033(2),',
    '67,Ho,173,172.94702(32#),,164.93033(2),',
    '67,Ho,174,173.95095(32#),,164.93033(2),',
    '67,Ho,175,174.95362(43#),,164.93033(2),',
    '68,Er,142,141.97010(54#),,167.259(3),g',
    '68,Er,143,142.96662(43#),,167.259(3),g',
    '68,Er,144,143.96070(21#),,167.259(3),g',
    '68,Er,145,144.95805(21#),,167.259(3),g',
    '68,Er,146,145.9524184(72),,167.259(3),g',
    '68,Er,147,146.949964(41),,167.259(3),g',
    '68,Er,148,147.944735(11),,167.259(3),g',
    '68,Er,149,148.942306(30),,167.259(3),g',
    '68,Er,150,149.937916(18),,167.259(3),g',
    '68,Er,151,150.937449(18),,167.259(3),g',
    '68,Er,152,151.935057(10),,167.259(3),g',
    '68,Er,153,152.935080(10),,167.259(3),g',
    '68,Er,154,153.9327908(55),,167.259(3),g',
    '68,Er,155,154.9332159(67),,167.259(3),g',
    '68,Er,156,155.931067(26),,167.259(3),g',
    '68,Er,157,156.931949(27),,167.259(3),g',
    '68,Er,158,157.929893(27),,167.259(3),g',
    '68,Er,159,158.9306918(42),,167.259(3),g',
    '68,Er,160,159.929077(26),,167.259(3),g',
    '68,Er,161,160.9300046(96),,167.259(3),g',
    '68,Er,162,161.9287884(20),0.00139(5),167.259(3),g',
    '68,Er,163,162.9300408(53),,167.259(3),g',
    '68,Er,164,163.9292088(20),0.01601(3),167.259(3),g',
    '68,Er,165,164.9307345(21),,167.259(3),g',
    '68,Er,166,165.9302995(22),0.33503(36),167.259(3),g',
    '68,Er,167,166.9320546(22),0.22869(9),167.259(3),g',
    '68,Er,168,167.9323767(22),0.26978(18),167.259(3),g',
    '68,Er,169,168.9345968(22),,167.259(3),g',
    '68,Er,170,169.9354702(26),0.14910(36),167.259(3),g',
    '68,Er,171,170.9380357(26),,167.259(3),g',
    '68,Er,172,171.9393619(47),,167.259(3),g',
    '68,Er,173,172.94240(21#),,167.259(3),g',
    '68,Er,174,173.94423(32#),,167.259(3),g',
    '68,Er,175,174.94777(43#),,167.259(3),g',
    '68,Er,176,175.94994(43#),,167.259(3),g',
    '68,Er,177,176.95399(54#),,167.259(3),g',
    '69,Tm,144,143.97628(43#),,168.93422(2),',
    '69,Tm,145,144.97039(21#),,168.93422(2),',
    '69,Tm,146,145.96684(21#),,168.93422(2),',
    '69,Tm,147,146.9613799(73),,168.93422(2),',
    '69,Tm,148,147.958384(11),,168.93422(2),',
    '69,Tm,149,148.95289(32#),,168.93422(2),',
    '69,Tm,150,149.95009(21#),,168.93422(2),',
    '69,Tm,151,150.945488(21),,168.93422(2),',
    '69,Tm,152,151.944422(79),,168.93422(2),',
    '69,Tm,153,152.942040(16),,168.93422(2),',
    '69,Tm,154,153.941570(15),,168.93422(2),',
    '69,Tm,155,154.939210(11),,168.93422(2),',
    '69,Tm,156,155.938992(16),,168.93422(2),',
    '69,Tm,157,156.936944(28),,168.93422(2),',
    '69,Tm,158,157.936980(27),,168.93422(2),',
    '69,Tm,159,158.934975(30),,168.93422(2),',
    '69,Tm,160,159.935263(37),,168.93422(2),',
    '69,Tm,161,160.933549(30),,168.93422(2),',
    '69,Tm,162,161.934002(28),,168.93422(2),',
    '69,Tm,163,162.9326592(62),,168.93422(2),',
    '69,Tm,164,163.933544(26),,168.93422(2),',
    '69,Tm,165,164.9324431(26),,168.93422(2),',
    '69,Tm,166,165.933561(13),,168.93422(2),',
    '69,Tm,167,166.9328562(25),,168.93422(2),',
    '69,Tm,168,167.9341774(27),,168.93422(2),',
    '69,Tm,169,168.9342179(22),1,168.93422(2),',
    '69,Tm,170,169.9358060(22),,168.93422(2),',
    '69,Tm,171,170.9364339(24),,168.93422(2),',
    '69,Tm,172,171.9384055(62),,168.93422(2),',
    '69,Tm,173,172.9396084(53),,168.93422(2),',
    '69,Tm,174,173.942173(48),,168.93422(2),',
    '69,Tm,175,174.943841(54),,168.93422(2),',
    '69,Tm,176,175.94700(11),,168.93422(2),',
    '69,Tm,177,176.94904(32#),,168.93422(2),',
    '69,Tm,178,177.95264(43#),,168.93422(2),',
    '69,Tm,179,178.95534(54#),,168.93422(2),',
    '70,Yb,148,147.96758(64#),,173.054(5),g',
    '70,Yb,149,148.96436(54#),,173.054(5),g',
    '70,Yb,150,149.95852(43#),,173.054(5),g',
    '70,Yb,151,150.95540(32),,173.054(5),g',
    '70,Yb,152,151.95027(17),,173.054(5),g',
    '70,Yb,153,152.94932(21#),,173.054(5),g',
    '70,Yb,154,153.946396(19),,173.054(5),g',
    '70,Yb,155,154.945783(18),,173.054(5),g',
    '70,Yb,156,155.942825(11),,173.054(5),g',
    '70,Yb,157,156.942645(12),,173.054(5),g',
    '70,Yb,158,157.9398705(86),,173.054(5),g',
    '70,Yb,159,158.940055(19),,173.054(5),g',
    '70,Yb,160,159.937557(17),,173.054(5),g',
    '70,Yb,161,160.937907(17),,173.054(5),g',
    '70,Yb,162,161.935774(17),,173.054(5),g',
    '70,Yb,163,162.936340(17),,173.054(5),g',
    '70,Yb,164,163.934495(17),,173.054(5),g',
    '70,Yb,165,164.935270(28),,173.054(5),g',
    '70,Yb,166,165.9338747(78),,173.054(5),g',
    '70,Yb,167,166.9349530(47),,173.054(5),g',
    '70,Yb,168,167.9338896(22),0.00123(3),173.054(5),g',
    '70,Yb,169,168.9351825(22),,173.054(5),g',
    '70,Yb,170,169.9347664(22),0.02982(39),173.054(5),g',
    '70,Yb,171,170.9363302(22),0.1409(14),173.054(5),g',
    '70,Yb,172,171.9363859(22),0.2168(13),173.054(5),g',
    '70,Yb,173,172.9382151(22),0.16103(63),173.054(5),g',
    '70,Yb,174,173.9388664(22),0.32026(80),173.054(5),g',
    '70,Yb,175,174.9412808(22),,173.054(5),g',
    '70,Yb,176,175.9425764(24),0.12996(83),173.054(5),g',
    '70,Yb,177,176.9452656(24),,173.054(5),g',
    '70,Yb,178,177.946651(11),,173.054(5),g',
    '70,Yb,179,178.95004(21#),,173.054(5),g',
    '70,Yb,180,179.95212(32#),,173.054(5),g',
    '70,Yb,181,180.95589(32#),,173.054(5),g',
    '71,Lu,150,149.97355(54#),,174.9668(1),g',
    '71,Lu,151,150.96768(43#),,174.9668(1),g',
    '71,Lu,152,151.96412(21#),,174.9668(1),g',
    '71,Lu,153,152.95875(17),,174.9668(1),g',
    '71,Lu,154,153.95736(22#),,174.9668(1),g',
    '71,Lu,155,154.954321(21),,174.9668(1),g',
    '71,Lu,156,155.953033(79),,174.9668(1),g',
    '71,Lu,157,156.950127(16),,174.9668(1),g',
    '71,Lu,158,157.949316(16),,174.9668(1),g',
    '71,Lu,159,158.946636(40),,174.9668(1),g',
    '71,Lu,160,159.946033(61),,174.9668(1),g',
    '71,Lu,161,160.943572(30),,174.9668(1),g',
    '71,Lu,162,161.943283(81),,174.9668(1),g',
    '71,Lu,163,162.941179(30),,174.9668(1),g',
    '71,Lu,164,163.941339(30),,174.9668(1),g',
    '71,Lu,165,164.939407(28),,174.9668(1),g',
    '71,Lu,166,165.939859(32),,174.9668(1),g',
    '71,Lu,167,166.938270(34),,174.9668(1),g',
    '71,Lu,168,167.938736(42),,174.9668(1),g',
    '71,Lu,169,168.9376441(39),,174.9668(1),g',
    '71,Lu,170,169.938478(18),,174.9668(1),g',
    '71,Lu,171,170.9379170(27),,174.9668(1),g',
    '71,Lu,172,171.9390891(30),,174.9668(1),g',
    '71,Lu,173,172.9389340(23),,174.9668(1),g',
    '71,Lu,174,173.9403409(23),,174.9668(1),g',
    '71,Lu,175,174.9407752(20),0.97401(13),174.9668(1),g',
    '71,Lu,176,175.9426897(20),0.02599(13),174.9668(1),g',
    '71,Lu,177,176.9437615(20),,174.9668(1),g',
    '71,Lu,178,177.9459580(29),,174.9668(1),g',
    '71,Lu,179,178.9473309(57),,174.9668(1),g',
    '71,Lu,180,179.949888(76),,174.9668(1),g',
    '71,Lu,181,180.95191(17),,174.9668(1),g',
    '71,Lu,182,181.95504(21#),,174.9668(1),g',
    '71,Lu,183,182.957363(98),,174.9668(1),g',
    '71,Lu,184,183.96091(32#),,174.9668(1),g',
    '71,Lu,185,184.96362(32#),,174.9668(1),g',
    '72,Hf,153,152.97069(54#),,178.49(2),',
    '72,Hf,154,153.96486(54#),,178.49(2),',
    '72,Hf,155,154.96311(32#),,178.49(2),',
    '72,Hf,156,155.95935(17),,178.49(2),',
    '72,Hf,157,156.95824(21#),,178.49(2),',
    '72,Hf,158,157.954801(19),,178.49(2),',
    '72,Hf,159,158.953996(18),,178.49(2),',
    '72,Hf,160,159.950691(11),,178.49(2),',
    '72,Hf,161,160.950278(24),,178.49(2),',
    '72,Hf,162,161.9472148(97),,178.49(2),',
    '72,Hf,163,162.947113(27),,178.49(2),',
    '72,Hf,164,163.944371(17),,178.49(2),',
    '72,Hf,165,164.944567(30),,178.49(2),',
    '72,Hf,166,165.942180(30),,178.49(2),',
    '72,Hf,167,166.942600(30),,178.49(2),',
    '72,Hf,168,167.940568(30),,178.49(2),',
    '72,Hf,169,168.941259(30),,178.49(2),',
    '72,Hf,170,169.939609(30),,178.49(2),',
    '72,Hf,171,170.940492(31),,178.49(2),',
    '72,Hf,172,171.939450(26),,178.49(2),',
    '72,Hf,173,172.940513(30),,178.49(2),',
    '72,Hf,174,173.9400461(28),0.0016(1),178.49(2),',
    '72,Hf,175,174.9415092(29),,178.49(2),',
    '72,Hf,176,175.9414076(22),0.0526(7),178.49(2),',
    '72,Hf,177,176.9432277(20),0.1860(9),178.49(2),',
    '72,Hf,178,177.9437058(20),0.2728(7),178.49(2),',
    '72,Hf,179,178.9458232(20),0.1362(2),178.49(2),',
    '72,Hf,180,179.9465570(20),0.3508(16),178.49(2),',
    '72,Hf,181,180.9491083(20),,178.49(2),',
    '72,Hf,182,181.9505612(68),,178.49(2),',
    '72,Hf,183,182.953530(32),,178.49(2),',
    '72,Hf,184,183.955446(43),,178.49(2),',
    '72,Hf,185,184.958862(98),,178.49(2),',
    '72,Hf,186,185.960897(59),,178.49(2),',
    '72,Hf,187,186.96477(32#),,178.49(2),',
    '72,Hf,188,187.96685(32#),,178.49(2),',
    '72,Hf,189,188.97084(32#),,178.49(2),',
    '73,Ta,155,154.97424(54#),,180.94788(2),',
    '73,Ta,156,155.97203(32#),,180.94788(2),',
    '73,Ta,157,156.96818(17),,180.94788(2),',
    '73,Ta,158,157.96654(22#),,180.94788(2),',
    '73,Ta,159,158.963023(21),,180.94788(2),',
    '73,Ta,160,159.961488(79),,180.94788(2),',
    '73,Ta,161,160.958452(27),,180.94788(2),',
    '73,Ta,162,161.957294(56),,180.94788(2),',
    '73,Ta,163,162.954337(41),,180.94788(2),',
    '73,Ta,164,163.953534(30),,180.94788(2),',
    '73,Ta,165,164.950781(15),,180.94788(2),',
    '73,Ta,166,165.950512(30),,180.94788(2),',
    '73,Ta,167,166.948093(30),,180.94788(2),',
    '73,Ta,168,167.948047(30),,180.94788(2),',
    '73,Ta,169,168.946011(30),,180.94788(2),',
    '73,Ta,170,169.946175(30),,180.94788(2),',
    '73,Ta,171,170.944476(30),,180.94788(2),',
    '73,Ta,172,171.944895(30),,180.94788(2),',
    '73,Ta,173,172.943750(30),,180.94788(2),',
    '73,Ta,174,173.944454(30),,180.94788(2),',
    '73,Ta,175,174.943737(30),,180.94788(2),',
    '73,Ta,176,175.944857(33),,180.94788(2),',
    '73,Ta,177,176.9444795(38),,180.94788(2),',
    '73,Ta,178,177.945678(56#),,180.94788(2),',
    '73,Ta,179,178.9459366(21),,180.94788(2),',
    '73,Ta,180,179.9474648(24),0.0001201(32),180.94788(2),',
    '73,Ta,181,180.9479958(20),0.9998799(32),180.94788(2),',
    '73,Ta,182,181.9501519(20),,180.94788(2),',
    '73,Ta,183,182.9513726(20),,180.94788(2),',
    '73,Ta,184,183.954008(28),,180.94788(2),',
    '73,Ta,185,184.955559(15),,180.94788(2),',
    '73,Ta,186,185.958551(64),,180.94788(2),',
    '73,Ta,187,186.960386(71),,180.94788(2),',
    '73,Ta,188,187.963916(71),,180.94788(2),',
    '73,Ta,189,188.96583(32#),,180.94788(2),',
    '73,Ta,190,189.96939(21#),,180.94788(2),',
    '73,Ta,191,190.97156(32#),,180.94788(2),',
    '73,Ta,192,191.97514(43#),,180.94788(2),',
    '74,W,157,156.97884(43#),,183.84(1),',
    '74,W,158,157.97456(54#),,183.84(1),',
    '74,W,159,158.97264(32#),,183.84(1),',
    '74,W,160,159.96846(17),,183.84(1),',
    '74,W,161,160.96720(21#),,183.84(1),',
    '74,W,162,161.963499(19),,183.84(1),',
    '74,W,163,162.962524(57),,183.84(1),',
    '74,W,164,163.958961(11),,183.84(1),',
    '74,W,165,164.958281(27),,183.84(1),',
    '74,W,166,165.955031(10),,183.84(1),',
    '74,W,167,166.954805(20),,183.84(1),',
    '74,W,168,167.951806(14),,183.84(1),',
    '74,W,169,168.951779(17),,183.84(1),',
    '74,W,170,169.949232(14),,183.84(1),',
    '74,W,171,170.949451(30),,183.84(1),',
    '74,W,172,171.947292(30),,183.84(1),',
    '74,W,173,172.947689(30),,183.84(1),',
    '74,W,174,173.946079(30),,183.84(1),',
    '74,W,175,174.946717(30),,183.84(1),',
    '74,W,176,175.945634(30),,183.84(1),',
    '74,W,177,176.946643(30),,183.84(1),',
    '74,W,178,177.945883(16),,183.84(1),',
    '74,W,179,178.947077(16),,183.84(1),',
    '74,W,180,179.9467108(20),0.0012(1),183.84(1),',
    '74,W,181,180.9481978(51),,183.84(1),',
    '74,W,182,181.94820394(91),0.2650(16),183.84(1),',
    '74,W,183,182.95022275(90),0.1431(4),183.84(1),',
    '74,W,184,183.95093092(94),0.3064(2),183.84(1),',
    '74,W,185,184.95341897(99),,183.84(1),',
    '74,W,186,185.9543628(17),0.2843(19),183.84(1),',
    '74,W,187,186.9571588(17),,183.84(1),',
    '74,W,188,187.9584862(36),,183.84(1),',
    '74,W,189,188.961763(44),,183.84(1),',
    '74,W,190,189.963091(42),,183.84(1),',
    '74,W,191,190.966531(48),,183.84(1),',
    '74,W,192,191.96817(21#),,183.84(1),',
    '74,W,193,192.97178(21#),,183.84(1),',
    '74,W,194,193.97367(32#),,183.84(1),',
    '75,Re,159,158.98418(54#),,186.207(1),',
    '75,Re,160,159.98182(32#),,186.207(1),',
    '75,Re,161,160.97757(17),,186.207(1),',
    '75,Re,162,161.97584(22#),,186.207(1),',
    '75,Re,163,162.972080(20),,186.207(1),',
    '75,Re,164,163.970453(79),,186.207(1),',
    '75,Re,165,164.967103(27),,186.207(1),',
    '75,Re,166,165.965761(78),,186.207(1),',
    '75,Re,167,166.962595(44#),,186.207(1),',
    '75,Re,168,167.961573(33),,186.207(1),',
    '75,Re,169,168.958766(12),,186.207(1),',
    '75,Re,170,169.958220(28),,186.207(1),',
    '75,Re,171,170.955716(30),,186.207(1),',
    '75,Re,172,171.955420(42),,186.207(1),',
    '75,Re,173,172.953243(30),,186.207(1),',
    '75,Re,174,173.953115(30),,186.207(1),',
    '75,Re,175,174.951381(30),,186.207(1),',
    '75,Re,176,175.951623(30),,186.207(1),',
    '75,Re,177,176.950328(30),,186.207(1),',
    '75,Re,178,177.950989(30),,186.207(1),',
    '75,Re,179,178.949989(26),,186.207(1),',
    '75,Re,180,179.950792(23),,186.207(1),',
    '75,Re,181,180.950058(14),,186.207(1),',
    '75,Re,182,181.95121(11),,186.207(1),',
    '75,Re,183,182.9508196(86),,186.207(1),',
    '75,Re,184,183.9525228(47),,186.207(1),',
    '75,Re,185,184.9529545(13),0.3740(2),186.207(1),',
    '75,Re,186,185.9549856(13),,186.207(1),',
    '75,Re,187,186.9557501(16),0.6260(2),186.207(1),',
    '75,Re,188,187.9581115(16),,186.207(1),',
    '75,Re,189,188.9592260(89),,186.207(1),',
    '75,Re,190,189.961744(76),,186.207(1),',
    '75,Re,191,190.963122(11),,186.207(1),',
    '75,Re,192,191.966088(82),,186.207(1),',
    '75,Re,193,192.967541(41),,186.207(1),',
    '75,Re,194,193.97076(21#),,186.207(1),',
    '75,Re,195,194.97254(32#),,186.207(1),',
    '75,Re,196,195.97580(32#),,186.207(1),',
    '75,Re,197,196.97799(32#),,186.207(1),',
    '75,Re,198,197.98160(43#),,186.207(1),',
    '76,Os,161,160.98903(43#),,190.23(3),g',
    '76,Os,162,161.98443(54#),,190.23(3),g',
    '76,Os,163,162.98241(32#),,190.23(3),g',
    '76,Os,164,163.97802(17),,190.23(3),g',
    '76,Os,165,164.97660(22#),,190.23(3),g',
    '76,Os,166,165.972692(20),,190.23(3),g',
    '76,Os,167,166.971549(78),,190.23(3),g',
    '76,Os,168,167.967808(12),,190.23(3),g',
    '76,Os,169,168.967018(27),,190.23(3),g',
    '76,Os,170,169.963578(11),,190.23(3),g',
    '76,Os,171,170.963174(19),,190.23(3),g',
    '76,Os,172,171.960017(14),,190.23(3),g',
    '76,Os,173,172.959808(16),,190.23(3),g',
    '76,Os,174,173.957064(11),,190.23(3),g',
    '76,Os,175,174.956945(13),,190.23(3),g',
    '76,Os,176,175.954806(30),,190.23(3),g',
    '76,Os,177,176.954966(17),,190.23(3),g',
    '76,Os,178,177.953254(15),,190.23(3),g',
    '76,Os,179,178.953817(18),,190.23(3),g',
    '76,Os,180,179.952375(17),,190.23(3),g',
    '76,Os,181,180.953247(27),,190.23(3),g',
    '76,Os,182,181.952110(23),,190.23(3),g',
    '76,Os,183,182.953125(53),,190.23(3),g',
    '76,Os,184,183.9524885(14),0.0002(1),190.23(3),g',
    '76,Os,185,184.9540417(14),,190.23(3),g',
    '76,Os,186,185.9538350(16),0.0159(3),190.23(3),g',
    '76,Os,187,186.9557474(16),0.0196(2),190.23(3),g',
    '76,Os,188,187.9558352(16),0.1324(8),190.23(3),g',
    '76,Os,189,188.9581442(17),0.1615(5),190.23(3),g',
    '76,Os,190,189.9584437(17),0.2626(2),190.23(3),g',
    '76,Os,191,190.9609264(17),,190.23(3),g',
    '76,Os,192,191.9614770(29),0.4078(19),190.23(3),g',
    '76,Os,193,192.9641479(29),,190.23(3),g',
    '76,Os,194,193.9651772(30),,190.23(3),g',
    '76,Os,195,194.968318(65),,190.23(3),g',
    '76,Os,196,195.969641(43),,190.23(3),g',
    '76,Os,197,196.97283(21#),,190.23(3),g',
    '76,Os,198,197.97441(21#),,190.23(3),g',
    '76,Os,199,198.97801(21#),,190.23(3),g',
    '76,Os,200,199.97984(32#),,190.23(3),g',
    '76,Os,201,200.98364(32#),,190.23(3),g',
    '76,Os,202,201.98595(43#),,190.23(3),g',
    '77,Ir,164,163.99191(34#),,192.217(3),',
    '77,Ir,165,164.98750(18#),,192.217(3),',
    '77,Ir,166,165.98566(22#),,192.217(3),',
    '77,Ir,167,166.981666(20),,192.217(3),',
    '77,Ir,168,167.979907(80),,192.217(3),',
    '77,Ir,169,168.976298(27),,192.217(3),',
    '77,Ir,170,169.974922(95#),,192.217(3),',
    '77,Ir,171,170.971640(42),,192.217(3),',
    '77,Ir,172,171.970607(35),,192.217(3),',
    '77,Ir,173,172.967506(12),,192.217(3),',
    '77,Ir,174,173.966861(30),,192.217(3),',
    '77,Ir,175,174.964150(13),,192.217(3),',
    '77,Ir,176,175.963650(22),,192.217(3),',
    '77,Ir,177,176.961301(21),,192.217(3),',
    '77,Ir,178,177.961082(21),,192.217(3),',
    '77,Ir,179,178.959120(10),,192.217(3),',
    '77,Ir,180,179.959229(23),,192.217(3),',
    '77,Ir,181,180.957625(28),,192.217(3),',
    '77,Ir,182,181.958076(23),,192.217(3),',
    '77,Ir,183,182.956840(26),,192.217(3),',
    '77,Ir,184,183.957476(30),,192.217(3),',
    '77,Ir,185,184.956698(30),,192.217(3),',
    '77,Ir,186,185.957944(18),,192.217(3),',
    '77,Ir,187,186.957542(30),,192.217(3),',
    '77,Ir,188,187.958828(10),,192.217(3),',
    '77,Ir,189,188.958715(14),,192.217(3),',
    '77,Ir,190,189.9605412(21),,192.217(3),',
    '77,Ir,191,190.9605893(21),0.373(2),192.217(3),',
    '77,Ir,192,191.9626002(21),,192.217(3),',
    '77,Ir,193,192.9629216(21),0.627(2),192.217(3),',
    '77,Ir,194,193.9650735(21),,192.217(3),',
    '77,Ir,195,194.9659747(21),,192.217(3),',
    '77,Ir,196,195.968397(41),,192.217(3),',
    '77,Ir,197,196.969655(22),,192.217(3),',
    '77,Ir,198,197.97228(21#),,192.217(3),',
    '77,Ir,199,198.973805(44),,192.217(3),',
    '77,Ir,200,199.97680(21#),,192.217(3),',
    '77,Ir,201,200.97864(21#),,192.217(3),',
    '77,Ir,202,201.98199(32#),,192.217(3),',
    '77,Ir,203,202.98423(43#),,192.217(3),',
    '77,Ir,204,203.98960(43#),,192.217(3),',
    '78,Pt,166,165.99486(54#),,195.084(9),',
    '78,Pt,167,166.99269(33#),,195.084(9),',
    '78,Pt,168,167.98813(17),,195.084(9),',
    '78,Pt,169,168.98657(22#),,195.084(9),',
    '78,Pt,170,169.982496(20),,195.084(9),',
    '78,Pt,171,170.981245(78),,195.084(9),',
    '78,Pt,172,171.977351(12),,195.084(9),',
    '78,Pt,173,172.976443(60),,195.084(9),',
    '78,Pt,174,173.972820(11),,195.084(9),',
    '78,Pt,175,174.972410(19),,195.084(9),',
    '78,Pt,176,175.968938(14),,195.084(9),',
    '78,Pt,177,176.968470(16),,195.084(9),',
    '78,Pt,178,177.965650(11),,195.084(9),',
    '78,Pt,179,178.9653590(86),,195.084(9),',
    '78,Pt,180,179.963032(12),,195.084(9),',
    '78,Pt,181,180.963098(16),,195.084(9),',
    '78,Pt,182,181.961172(14),,195.084(9),',
    '78,Pt,183,182.961597(17),,195.084(9),',
    '78,Pt,184,183.959915(17),,195.084(9),',
    '78,Pt,185,184.960614(28),,195.084(9),',
    '78,Pt,186,185.959351(23),,195.084(9),',
    '78,Pt,187,186.960617(26),,195.084(9),',
    '78,Pt,188,187.9593889(61),,195.084(9),',
    '78,Pt,189,188.960831(12),,195.084(9),',
    '78,Pt,190,189.9599297(63),0.00012(2),195.084(9),',
    '78,Pt,191,190.9616729(53),,195.084(9),',
    '78,Pt,192,191.9610387(32),0.00782(24),195.084(9),',
    '78,Pt,193,192.9629824(21),,195.084(9),',
    '78,Pt,194,193.9626809(10),0.3286(40),195.084(9),',
    '78,Pt,195,194.9647917(10),0.3378(24),195.084(9),',
    '78,Pt,196,195.96495209(99),0.2521(34),195.084(9),',
    '78,Pt,197,196.96734069(94),,195.084(9),',
    '78,Pt,198,197.9678949(23),0.07356(130),195.084(9),',
    '78,Pt,199,198.9705952(24),,195.084(9),',
    '78,Pt,200,199.971443(22),,195.084(9),',
    '78,Pt,201,200.974513(54),,195.084(9),',
    '78,Pt,202,201.975639(27),,195.084(9),',
    '78,Pt,203,202.97893(21#),,195.084(9),',
    '78,Pt,204,203.98076(21#),,195.084(9),',
    '78,Pt,205,204.98608(32#),,195.084(9),',
    '78,Pt,206,205.98966(32#),,195.084(9),',
    '79,Au,169,168.99808(32#),,196.966569(5),',
    '79,Au,170,169.99597(22#),,196.966569(5),',
    '79,Au,171,170.991876(22),,196.966569(5),',
    '79,Au,172,171.989942(81),,196.966569(5),',
    '79,Au,173,172.986241(26),,196.966569(5),',
    '79,Au,174,173.984717(95#),,196.966569(5),',
    '79,Au,175,174.981304(42),,196.966569(5),',
    '79,Au,176,175.980250(36),,196.966569(5),',
    '79,Au,177,176.976870(11),,196.966569(5),',
    '79,Au,178,177.976032(61),,196.966569(5),',
    '79,Au,179,178.973174(13),,196.966569(5),',
    '79,Au,180,179.972523(21),,196.966569(5),',
    '79,Au,181,180.970079(21),,196.966569(5),',
    '79,Au,182,181.969618(22),,196.966569(5),',
    '79,Au,183,182.967591(10),,196.966569(5),',
    '79,Au,184,183.967452(24),,196.966569(5),',
    '79,Au,185,184.965790(28),,196.966569(5),',
    '79,Au,186,185.965953(23),,196.966569(5),',
    '79,Au,187,186.964543(24),,196.966569(5),',
    '79,Au,188,187.965349(17),,196.966569(5),',
    '79,Au,189,188.963948(22),,196.966569(5),',
    '79,Au,190,189.964698(17),,196.966569(5),',
    '79,Au,191,190.963702(40),,196.966569(5),',
    '79,Au,192,191.964814(17),,196.966569(5),',
    '79,Au,193,192.9641373(93),,196.966569(5),',
    '79,Au,194,193.9654178(23),,196.966569(5),',
    '79,Au,195,194.9650352(15),,196.966569(5),',
    '79,Au,196,195.9665699(32),,196.966569(5),',
    '79,Au,197,196.96656879(71),1,196.966569(5),',
    '79,Au,198,197.96824242(70),,196.966569(5),',
    '79,Au,199,198.96876528(70),,196.966569(5),',
    '79,Au,200,199.970756(29),,196.966569(5),',
    '79,Au,201,200.9716575(34),,196.966569(5),',
    '79,Au,202,201.973856(25),,196.966569(5),',
    '79,Au,203,202.9751544(33),,196.966569(5),',
    '79,Au,204,203.97783(22#),,196.966569(5),',
    '79,Au,205,204.97985(21#),,196.966569(5),',
    '79,Au,206,205.98474(32#),,196.966569(5),',
    '79,Au,207,206.98840(32#),,196.966569(5),',
    '79,Au,208,207.99345(32#),,196.966569(5),',
    '79,Au,209,208.99735(43#),,196.966569(5),',
    '79,Au,210,210.00250(43#),,196.966569(5),',
    '80,Hg,171,171.00353(33#),,200.592(3),',
    '80,Hg,172,171.99881(17),,200.592(3),',
    '80,Hg,173,172.99709(22#),,200.592(3),',
    '80,Hg,174,173.992865(21),,200.592(3),',
    '80,Hg,175,174.991441(78),,200.592(3),',
    '80,Hg,176,175.987361(14),,200.592(3),',
    '80,Hg,177,176.986277(81),,200.592(3),',
    '80,Hg,178,177.982484(12),,200.592(3),',
    '80,Hg,179,178.981831(29),,200.592(3),',
    '80,Hg,180,179.978260(14),,200.592(3),',
    '80,Hg,181,180.977819(17),,200.592(3),',
    '80,Hg,182,181.974689(11),,200.592(3),',
    '80,Hg,183,182.9744448(76),,200.592(3),',
    '80,Hg,184,183.971714(11),,200.592(3),',
    '80,Hg,185,184.971899(17),,200.592(3),',
    '80,Hg,186,185.969362(13),,200.592(3),',
    '80,Hg,187,186.969814(15),,200.592(3),',
    '80,Hg,188,187.967567(12),,200.592(3),',
    '80,Hg,189,188.968195(34),,200.592(3),',
    '80,Hg,190,189.966323(17),,200.592(3),',
    '80,Hg,191,190.967157(24),,200.592(3),',
    '80,Hg,192,191.965635(17),,200.592(3),',
    '80,Hg,193,192.966653(17),,200.592(3),',
    '80,Hg,194,193.9654491(31),,200.592(3),',
    '80,Hg,195,194.966721(25),,200.592(3),',
    '80,Hg,196,195.9658326(32),0.0015(1),200.592(3),',
    '80,Hg,197,196.9672128(35),,200.592(3),',
    '80,Hg,198,197.96676860(52),0.0997(20),200.592(3),',
    '80,Hg,199,198.96828064(46),0.1687(22),200.592(3),',
    '80,Hg,200,199.96832659(47),0.2310(19),200.592(3),',
    '80,Hg,201,200.97030284(69),0.1318(9),200.592(3),',
    '80,Hg,202,201.97064340(69),0.2986(26),200.592(3),',
    '80,Hg,203,202.9728728(18),,200.592(3),',
    '80,Hg,204,203.97349398(53),0.0687(15),200.592(3),',
    '80,Hg,205,204.9760734(39),,200.592(3),',
    '80,Hg,206,205.977514(22),,200.592(3),',
    '80,Hg,207,206.982300(32),,200.592(3),',
    '80,Hg,208,207.985759(33),,200.592(3),',
    '80,Hg,209,208.99072(16#),,200.592(3),',
    '80,Hg,210,209.99424(21#),,200.592(3),',
    '80,Hg,211,210.99933(21#),,200.592(3),',
    '80,Hg,212,212.00296(32#),,200.592(3),',
    '80,Hg,213,213.00823(32#),,200.592(3),',
    '80,Hg,214,214.01200(43#),,200.592(3),',
    '80,Hg,215,215.01740(43#),,200.592(3),',
    '80,Hg,216,216.02132(43#),,200.592(3),',
    '81,Tl,176,176.000624(81),,"[204.382,204.385]",',
    '81,Tl,177,176.996431(25),,"[204.382,204.385]",',
    '81,Tl,178,177.99485(11#),,"[204.382,204.385]",',
    '81,Tl,179,178.991111(43),,"[204.382,204.385]",',
    '81,Tl,180,179.990057(64),,"[204.382,204.385]",',
    '81,Tl,181,180.9862600(98),,"[204.382,204.385]",',
    '81,Tl,182,181.985713(63),,"[204.382,204.385]",',
    '81,Tl,183,182.982193(10),,"[204.382,204.385]",',
    '81,Tl,184,183.981886(22),,"[204.382,204.385]",',
    '81,Tl,185,184.978789(22),,"[204.382,204.385]",',
    '81,Tl,186,185.978651(24),,"[204.382,204.385]",',
    '81,Tl,187,186.9759063(88),,"[204.382,204.385]",',
    '81,Tl,188,187.976021(32),,"[204.382,204.385]",',
    '81,Tl,189,188.973588(12),,"[204.382,204.385]",',
    '81,Tl,190,189.973828(54#),,"[204.382,204.385]",',
    '81,Tl,191,190.9717842(79),,"[204.382,204.385]",',
    '81,Tl,192,191.972225(34),,"[204.382,204.385]",',
    '81,Tl,193,192.9705020(72),,"[204.382,204.385]",',
    '81,Tl,194,193.971081(15),,"[204.382,204.385]",',
    '81,Tl,195,194.969774(12),,"[204.382,204.385]",',
    '81,Tl,196,195.970481(13),,"[204.382,204.385]",',
    '81,Tl,197,196.969576(18),,"[204.382,204.385]",',
    '81,Tl,198,197.970483(86),,"[204.382,204.385]",',
    '81,Tl,199,198.969877(30),,"[204.382,204.385]",',
    '81,Tl,200,199.9709633(62),,"[204.382,204.385]",',
    '81,Tl,201,200.970822(15),,"[204.382,204.385]",',
    '81,Tl,202,201.972102(15),,"[204.382,204.385]",',
    '81,Tl,203,202.9723446(14),0.2952(1),"[204.382,204.385]",',
    '81,Tl,204,203.9738639(13),,"[204.382,204.385]",',
    '81,Tl,205,204.9744278(14),0.7048(1),"[204.382,204.385]",',
    '81,Tl,206,205.9761106(15),,"[204.382,204.385]",',
    '81,Tl,207,206.9774197(59),,"[204.382,204.385]",',
    '81,Tl,208,207.9820190(21),,"[204.382,204.385]",',
    '81,Tl,209,208.9853594(86),,"[204.382,204.385]",',
    '81,Tl,210,209.990074(12),,"[204.382,204.385]",',
    '81,Tl,211,210.993475(45),,"[204.382,204.385]",',
    '81,Tl,212,211.99834(22#),,"[204.382,204.385]",',
    '81,Tl,213,213.001915(29),,"[204.382,204.385]",',
    '81,Tl,214,214.00694(21#),,"[204.382,204.385]",',
    '81,Tl,215,215.01064(32#),,"[204.382,204.385]",',
    '81,Tl,216,216.01580(32#),,"[204.382,204.385]",',
    '81,Tl,217,217.01966(43#),,"[204.382,204.385]",',
    '81,Tl,218,218.02479(43#),,"[204.382,204.385]",',
    '82,Pb,178,178.003831(26),,207.2(1),"g,r"',
    '82,Pb,179,179.002201(81),,207.2(1),"g,r"',
    '82,Pb,180,179.997928(15),,207.2(1),"g,r"',
    '82,Pb,181,180.996653(81),,207.2(1),"g,r"',
    '82,Pb,182,181.992672(13),,207.2(1),"g,r"',
    '82,Pb,183,182.991872(30),,207.2(1),"g,r"',
    '82,Pb,184,183.988136(14),,207.2(1),"g,r"',
    '82,Pb,185,184.987610(17),,207.2(1),"g,r"',
    '82,Pb,186,185.984238(12),,207.2(1),"g,r"',
    '82,Pb,187,186.9839109(55),,207.2(1),"g,r"',
    '82,Pb,188,187.980875(11),,207.2(1),"g,r"',
    '82,Pb,189,188.980807(37),,207.2(1),"g,r"',
    '82,Pb,190,189.978082(13),,207.2(1),"g,r"',
    '82,Pb,191,190.978276(41),,207.2(1),"g,r"',
    '82,Pb,192,191.975775(13),,207.2(1),"g,r"',
    '82,Pb,193,192.976173(53),,207.2(1),"g,r"',
    '82,Pb,194,193.974012(19),,207.2(1),"g,r"',
    '82,Pb,195,194.974543(25),,207.2(1),"g,r"',
    '82,Pb,196,195.972774(15),,207.2(1),"g,r"',
    '82,Pb,197,196.9734312(60),,207.2(1),"g,r"',
    '82,Pb,198,197.972034(16),,207.2(1),"g,r"',
    '82,Pb,199,198.972913(11),,207.2(1),"g,r"',
    '82,Pb,200,199.971819(12),,207.2(1),"g,r"',
    '82,Pb,201,200.972883(23),,207.2(1),"g,r"',
    '82,Pb,202,201.9721520(40),,207.2(1),"g,r"',
    '82,Pb,203,202.9733911(71),,207.2(1),"g,r"',
    '82,Pb,204,203.9730440(13),0.014(1),207.2(1),"g,r"',
    '82,Pb,205,204.9744822(13),,207.2(1),"g,r"',
    '82,Pb,206,205.9744657(13),0.241(1),207.2(1),"g,r"',
    '82,Pb,207,206.9758973(13),0.221(1),207.2(1),"g,r"',
    '82,Pb,208,207.9766525(13),0.524(1),207.2(1),"g,r"',
    '82,Pb,209,208.9810905(19),,207.2(1),"g,r"',
    '82,Pb,210,209.9841889(16),,207.2(1),"g,r"',
    '82,Pb,211,210.9887371(28),,207.2(1),"g,r"',
    '82,Pb,212,211.9918977(23),,207.2(1),"g,r"',
    '82,Pb,213,212.9965629(72),,207.2(1),"g,r"',
    '82,Pb,214,213.9998059(25),,207.2(1),"g,r"',
    '82,Pb,215,215.00474(11#),,207.2(1),"g,r"',
    '82,Pb,216,216.00803(21#),,207.2(1),"g,r"',
    '82,Pb,217,217.01314(32#),,207.2(1),"g,r"',
    '82,Pb,218,218.01659(32#),,207.2(1),"g,r"',
    '82,Pb,219,219.02177(43#),,207.2(1),"g,r"',
    '82,Pb,220,220.02541(43#),,207.2(1),"g,r"',
    '83,Bi,184,184.001275(84),,208.98040(1),',
    '83,Bi,185,184.997600(87#),,208.98040(1),',
    '83,Bi,186,185.996644(65),,208.98040(1),',
    '83,Bi,187,186.993147(11),,208.98040(1),',
    '83,Bi,188,187.992287(22),,208.98040(1),',
    '83,Bi,189,188.989195(22),,208.98040(1),',
    '83,Bi,190,189.988622(24),,208.98040(1),',
    '83,Bi,191,190.9857866(80),,208.98040(1),',
    '83,Bi,192,191.985469(33),,208.98040(1),',
    '83,Bi,193,192.982960(10),,208.98040(1),',
    '83,Bi,194,193.982785(54#),,208.98040(1),',
    '83,Bi,195,194.9806488(57),,208.98040(1),',
    '83,Bi,196,195.980667(26),,208.98040(1),',
    '83,Bi,197,196.9788651(89),,208.98040(1),',
    '83,Bi,198,197.979206(30),,208.98040(1),',
    '83,Bi,199,198.977673(11),,208.98040(1),',
    '83,Bi,200,199.978131(24),,208.98040(1),',
    '83,Bi,201,200.977010(16),,208.98040(1),',
    '83,Bi,202,201.977734(17),,208.98040(1),',
    '83,Bi,203,202.976893(14),,208.98040(1),',
    '83,Bi,204,203.9778361(99),,208.98040(1),',
    '83,Bi,205,204.9773867(55),,208.98040(1),',
    '83,Bi,206,205.9784993(82),,208.98040(1),',
    '83,Bi,207,206.9784710(26),,208.98040(1),',
    '83,Bi,208,207.9797425(25),,208.98040(1),',
    '83,Bi,209,208.9803991(16),1,208.98040(1),',
    '83,Bi,210,209.9841207(16),,208.98040(1),',
    '83,Bi,211,210.9872697(59),,208.98040(1),',
    '83,Bi,212,211.9912860(21),,208.98040(1),',
    '83,Bi,213,212.9943851(56),,208.98040(1),',
    '83,Bi,214,213.998712(12),,208.98040(1),',
    '83,Bi,215,215.001770(16),,208.98040(1),',
    '83,Bi,216,216.006306(12),,208.98040(1),',
    '83,Bi,217,217.009372(19),,208.98040(1),',
    '83,Bi,218,218.014188(29),,208.98040(1),',
    '83,Bi,219,219.01748(21#),,208.98040(1),',
    '83,Bi,220,220.02235(32#),,208.98040(1),',
    '83,Bi,221,221.02587(32#),,208.98040(1),',
    '83,Bi,222,222.03078(32#),,208.98040(1),',
    '83,Bi,223,223.03450(43#),,208.98040(1),',
    '83,Bi,224,224.03947(43#),,208.98040(1),',
    '84,Po,186,186.004393(35),,[209],',
    '84,Po,187,187.003041(34),,[209],',
    '84,Po,188,187.999416(21),,[209],',
    '84,Po,189,188.998473(24),,[209],',
    '84,Po,190,189.995101(14),,[209],',
    '84,Po,191,190.9945585(76),,[209],',
    '84,Po,192,191.991336(12),,[209],',
    '84,Po,193,192.991026(37),,[209],',
    '84,Po,194,193.988186(14),,[209],',
    '84,Po,195,194.988126(41),,[209],',
    '84,Po,196,195.985526(14),,[209],',
    '84,Po,197,196.985660(53),,[209],',
    '84,Po,198,197.983389(19),,[209],',
    '84,Po,199,198.983667(25),,[209],',
    '84,Po,200,199.981799(15),,[209],',
    '84,Po,201,200.9822598(63),,[209],',
    '84,Po,202,201.980758(16),,[209],',
    '84,Po,203,202.9814161(93),,[209],',
    '84,Po,204,203.980310(12),,[209],',
    '84,Po,205,204.981203(22),,[209],',
    '84,Po,206,205.9804740(43),,[209],',
    '84,Po,207,206.9815938(72),,[209],',
    '84,Po,208,207.9812461(19),,[209],',
    '84,Po,209,208.9824308(20),,[209],',
    '84,Po,210,209.9828741(13),,[209],',
    '84,Po,211,210.9866536(14),,[209],',
    '84,Po,212,211.9888684(13),,[209],',
    '84,Po,213,212.9928576(33),,[209],',
    '84,Po,214,213.9952017(16),,[209],',
    '84,Po,215,214.9994201(27),,[209],',
    '84,Po,216,216.0019152(23),,[209],',
    '84,Po,217,217.0063182(67),,[209],',
    '84,Po,218,218.0089735(25),,[209],',
    '84,Po,219,219.013614(17),,[209],',
    '84,Po,220,220.016386(19),,[209],',
    '84,Po,221,221.021228(21),,[209],',
    '84,Po,222,222.024140(43),,[209],',
    '84,Po,223,223.02907(21#),,[209],',
    '84,Po,224,224.03211(21#),,[209],',
    '84,Po,225,225.03707(32#),,[209],',
    '84,Po,226,226.04031(43#),,[209],',
    '84,Po,227,227.04539(43#),,[209],',
    '85,At,191,191.004148(17),,[210],',
    '85,At,192,192.003152(35),,[210],',
    '85,At,193,192.999927(23),,[210],',
    '85,At,194,193.999236(29),,[210],',
    '85,At,195,194.9962685(98),,[210],',
    '85,At,196,195.995800(33),,[210],',
    '85,At,197,196.993189(55),,[210],',
    '85,At,198,197.992784(54#),,[210],',
    '85,At,199,198.9905277(58),,[210],',
    '85,At,200,199.990351(26),,[210],',
    '85,At,201,200.9884171(88),,[210],',
    '85,At,202,201.988630(30),,[210],',
    '85,At,203,202.986943(11),,[210],',
    '85,At,204,203.987251(24),,[210],',
    '85,At,205,204.986076(16),,[210],',
    '85,At,206,205.986657(16),,[210],',
    '85,At,207,206.985800(13),,[210],',
    '85,At,208,207.9866133(96),,[210],',
    '85,At,209,208.9861702(55),,[210],',
    '85,At,210,209.9871479(83),,[210],',
    '85,At,211,210.9874966(30),,[210],',
    '85,At,212,211.9907377(26),,[210],',
    '85,At,213,212.9929370(53),,[210],',
    '85,At,214,213.9963721(46),,[210],',
    '85,At,215,214.9986528(73),,[210],',
    '85,At,216,216.0024236(39),,[210],',
    '85,At,217,217.0047192(55),,[210],',
    '85,At,218,218.008695(12),,[210],',
    '85,At,219,219.0111618(42),,[210],',
    '85,At,220,220.015433(15),,[210],',
    '85,At,221,221.018017(15),,[210],',
    '85,At,222,222.022494(17),,[210],',
    '85,At,223,223.025151(15),,[210],',
    '85,At,224,224.029749(24),,[210],',
    '85,At,225,225.03263(32#),,[210],',
    '85,At,226,226.03716(32#),,[210],',
    '85,At,227,227.04024(32#),,[210],',
    '85,At,228,228.04475(43#),,[210],',
    '85,At,229,229.04812(43#),,[210],',
    '86,Rn,193,193.009708(27),,[222],',
    '86,Rn,194,194.006144(18),,[222],',
    '86,Rn,195,195.005422(54),,[222],',
    '86,Rn,196,196.002116(15),,[222],',
    '86,Rn,197,197.001585(38),,[222],',
    '86,Rn,198,197.998679(14),,[222],',
    '86,Rn,199,198.998390(68),,[222],',
    '86,Rn,200,199.995690(14),,[222],',
    '86,Rn,201,200.995628(53),,[222],',
    '86,Rn,202,201.993264(19),,[222],',
    '86,Rn,203,202.993388(25),,[222],',
    '86,Rn,204,203.991430(16),,[222],',
    '86,Rn,205,204.991719(54),,[222],',
    '86,Rn,206,205.990214(16),,[222],',
    '86,Rn,207,206.9907303(91),,[222],',
    '86,Rn,208,207.989635(12),,[222],',
    '86,Rn,209,208.990415(22),,[222],',
    '86,Rn,210,209.9896891(49),,[222],',
    '86,Rn,211,210.9906011(73),,[222],',
    '86,Rn,212,211.9907039(34),,[222],',
    '86,Rn,213,212.9938831(61),,[222],',
    '86,Rn,214,213.9953630(99),,[222],',
    '86,Rn,215,214.9987459(83),,[222],',
    '86,Rn,216,216.0002719(65),,[222],',
    '86,Rn,217,217.0039280(45),,[222],',
    '86,Rn,218,218.0056016(25),,[222],',
    '86,Rn,219,219.0094804(27),,[222],',
    '86,Rn,220,220.0113941(23),,[222],',
    '86,Rn,221,221.0155371(63),,[222],',
    '86,Rn,222,222.0175782(25),,[222],',
    '86,Rn,223,223.0218893(84),,[222],',
    '86,Rn,224,224.024096(11),,[222],',
    '86,Rn,225,225.028486(12),,[222],',
    '86,Rn,226,226.030861(11),,[222],',
    '86,Rn,227,227.035304(15),,[222],',
    '86,Rn,228,228.037835(19),,[222],',
    '86,Rn,229,229.042257(14),,[222],',
    '86,Rn,230,230.04514(21#),,[222],',
    '86,Rn,231,231.04987(32#),,[222],',
    '87,Fr,199,199.007259(45),,[223],',
    '87,Fr,200,200.006586(63),,[223],',
    '87,Fr,201,201.003867(77),,[223],',
    '87,Fr,202,202.003320(55#),,[223],',
    '87,Fr,203,203.0009407(67),,[223],',
    '87,Fr,204,204.000652(26),,[223],',
    '87,Fr,205,204.9985939(84),,[223],',
    '87,Fr,206,205.998666(30),,[223],',
    '87,Fr,207,206.996946(19),,[223],',
    '87,Fr,208,207.997138(12),,[223],',
    '87,Fr,209,208.995955(16),,[223],',
    '87,Fr,210,209.996422(16),,[223],',
    '87,Fr,211,210.995556(13),,[223],',
    '87,Fr,212,211.9962257(94),,[223],',
    '87,Fr,213,212.9961860(55),,[223],',
    '87,Fr,214,213.9989713(93),,[223],',
    '87,Fr,215,215.0003418(76),,[223],',
    '87,Fr,216,216.0031899(45),,[223],',
    '87,Fr,217,217.0046323(70),,[223],',
    '87,Fr,218,218.0075787(51),,[223],',
    '87,Fr,219,219.0092524(76),,[223],',
    '87,Fr,220,220.0123277(44),,[223],',
    '87,Fr,221,221.0142552(54),,[223],',
    '87,Fr,222,222.017552(23),,[223],',
    '87,Fr,223,223.0197360(25),,[223],',
    '87,Fr,224,224.023398(14),,[223],',
    '87,Fr,225,225.025573(13),,[223],',
    '87,Fr,226,226.029566(13),,[223],',
    '87,Fr,227,227.031869(14),,[223],',
    '87,Fr,228,228.035823(14),,[223],',
    '87,Fr,229,229.038298(15),,[223],',
    '87,Fr,230,230.042416(17),,[223],',
    '87,Fr,231,231.045158(27),,[223],',
    '87,Fr,232,232.04937(17#),,[223],',
    '87,Fr,233,233.05264(32#),,[223],',
    '88,Ra,201,201.01271(11#),,[226],',
    '88,Ra,202,202.009760(26),,[226],',
    '88,Ra,203,203.009304(86),,[226],',
    '88,Ra,204,204.006492(16),,[226],',
    '88,Ra,205,205.006268(76),,[226],',
    '88,Ra,206,206.003828(19),,[226],',
    '88,Ra,207,207.003799(59),,[226],',
    '88,Ra,208,208.001841(17),,[226],',
    '88,Ra,209,209.001990(54),,[226],',
    '88,Ra,210,210.000494(16),,[226],',
    '88,Ra,211,211.0008932(85),,[226],',
    '88,Ra,212,211.999787(12),,[226],',
    '88,Ra,213,213.000384(22),,[226],',
    '88,Ra,214,214.0000997(56),,[226],',
    '88,Ra,215,215.0027204(82),,[226],',
    '88,Ra,216,216.0035334(94),,[226],',
    '88,Ra,217,217.0063207(92),,[226],',
    '88,Ra,218,218.007141(12),,[226],',
    '88,Ra,219,219.0100855(89),,[226],',
    '88,Ra,220,220.0110259(89),,[226],',
    '88,Ra,221,221.0139177(50),,[226],',
    '88,Ra,222,222.0153748(49),,[226],',
    '88,Ra,223,223.0185023(27),,[226],',
    '88,Ra,224,224.0202120(23),,[226],',
    '88,Ra,225,225.0236119(32),,[226],',
    '88,Ra,226,226.0254103(25),,[226],',
    '88,Ra,227,227.0291783(25),,[226],',
    '88,Ra,228,228.0310707(26),,[226],',
    '88,Ra,229,229.034942(16),,[226],',
    '88,Ra,230,230.037055(11),,[226],',
    '88,Ra,231,231.041027(12),,[226],',
    '88,Ra,232,232.0434753(98),,[226],',
    '88,Ra,233,233.047582(17),,[226],',
    '88,Ra,234,234.050342(33),,[226],',
    '88,Ra,235,235.05497(32#),,[226],',
    '89,Ac,206,206.014452(77#),,[227],',
    '89,Ac,207,207.011966(54),,[227],',
    '89,Ac,208,208.011550(60),,[227],',
    '89,Ac,209,209.009495(54),,[227],',
    '89,Ac,210,210.009436(62),,[227],',
    '89,Ac,211,211.007732(57),,[227],',
    '89,Ac,212,212.007813(55),,[227],',
    '89,Ac,213,213.006609(56),,[227],',
    '89,Ac,214,214.006918(16),,[227],',
    '89,Ac,215,215.006475(13),,[227],',
    '89,Ac,216,216.008743(12),,[227],',
    '89,Ac,217,217.009344(12),,[227],',
    '89,Ac,218,218.011642(54),,[227],',
    '89,Ac,219,219.012421(54),,[227],',
    '89,Ac,220,220.0147549(66),,[227],',
    '89,Ac,221,221.015592(54),,[227],',
    '89,Ac,222,222.0178442(56),,[227],',
    '89,Ac,223,223.0191377(77),,[227],',
    '89,Ac,224,224.0217232(45),,[227],',
    '89,Ac,225,225.0232300(53),,[227],',
    '89,Ac,226,226.0260984(36),,[227],',
    '89,Ac,227,227.0277523(25),,[227],',
    '89,Ac,228,228.0310215(27),,[227],',
    '89,Ac,229,229.032956(13),,[227],',
    '89,Ac,230,230.036327(17),,[227],',
    '89,Ac,231,231.038393(14),,[227],',
    '89,Ac,232,232.042034(14),,[227],',
    '89,Ac,233,233.044346(14),,[227],',
    '89,Ac,234,234.048139(15),,[227],',
    '89,Ac,235,235.050840(15),,[227],',
    '89,Ac,236,236.054988(41),,[227],',
    '89,Ac,237,237.05827(43#),,[227],',
    '90,Th,208,208.017900(36),,232.0377(4),g',
    '90,Th,209,209.017753(93),,232.0377(4),g',
    '90,Th,210,210.015094(20),,232.0377(4),g',
    '90,Th,211,211.014929(80),,232.0377(4),g',
    '90,Th,212,212.012988(17),,232.0377(4),g',
    '90,Th,213,213.013009(76),,232.0377(4),g',
    '90,Th,214,214.011500(17),,232.0377(4),g',
    '90,Th,215,215.0117248(95),,232.0377(4),g',
    '90,Th,216,216.011056(13),,232.0377(4),g',
    '90,Th,217,217.013117(22),,232.0377(4),g',
    '90,Th,218,218.013276(11),,232.0377(4),g',
    '90,Th,219,219.015537(54),,232.0377(4),g',
    '90,Th,220,220.015748(24),,232.0377(4),g',
    '90,Th,221,221.018184(10),,232.0377(4),g',
    '90,Th,222,222.018469(13),,232.0377(4),g',
    '90,Th,223,223.0208119(99),,232.0377(4),g',
    '90,Th,224,224.021464(11),,232.0377(4),g',
    '90,Th,225,225.0239514(55),,232.0377(4),g',
    '90,Th,226,226.0249034(50),,232.0377(4),g',
    '90,Th,227,227.0277042(27),,232.0377(4),g',
    '90,Th,228,228.0287413(23),,232.0377(4),g',
    '90,Th,229,229.0317627(30),,232.0377(4),g',
    '90,Th,230,230.0331341(19),,232.0377(4),g',
    '90,Th,231,231.0363046(19),,232.0377(4),g',
    '90,Th,232,232.0380558(21),1,232.0377(4),g',
    '90,Th,233,233.0415823(21),,232.0377(4),g',
    '90,Th,234,234.0436014(37),,232.0377(4),g',
    '90,Th,235,235.047255(14),,232.0377(4),g',
    '90,Th,236,236.049657(15),,232.0377(4),g',
    '90,Th,237,237.053629(17),,232.0377(4),g',
    '90,Th,238,238.05650(30#),,232.0377(4),g',
    '90,Th,239,239.06077(43#),,232.0377(4),g',
    '91,Pa,212,212.023203(80),,231.03588(2),',
    '91,Pa,213,213.021109(76),,231.03588(2),',
    '91,Pa,214,214.020918(82),,231.03588(2),',
    '91,Pa,215,215.019183(78),,231.03588(2),',
    '91,Pa,216,216.019109(57),,231.03588(2),',
    '91,Pa,217,217.018325(56),,231.03588(2),',
    '91,Pa,218,218.020059(20),,231.03588(2),',
    '91,Pa,219,219.019904(55),,231.03588(2),',
    '91,Pa,220,220.021705(55#),,231.03588(2),',
    '91,Pa,221,221.021875(55),,231.03588(2),',
    '91,Pa,222,222.023784(78#),,231.03588(2),',
    '91,Pa,223,223.023963(76),,231.03588(2),',
    '91,Pa,224,224.0256176(82),,231.03588(2),',
    '91,Pa,225,225.026131(76),,231.03588(2),',
    '91,Pa,226,226.027948(12),,231.03588(2),',
    '91,Pa,227,227.0288054(80),,231.03588(2),',
    '91,Pa,228,228.0310517(47),,231.03588(2),',
    '91,Pa,229,229.0320972(38),,231.03588(2),',
    '91,Pa,230,230.0345410(35),,231.03588(2),',
    '91,Pa,231,231.0358842(24),1,231.03588(2),',
    '91,Pa,232,232.0385917(83),,231.03588(2),',
    '91,Pa,233,233.0402472(22),,231.03588(2),',
    '91,Pa,234,234.0433072(51),,231.03588(2),',
    '91,Pa,235,235.045399(15),,231.03588(2),',
    '91,Pa,236,236.048668(15),,231.03588(2),',
    '91,Pa,237,237.051023(14),,231.03588(2),',
    '91,Pa,238,238.054637(17),,231.03588(2),',
    '91,Pa,239,239.05726(21#),,231.03588(2),',
    '91,Pa,240,240.06098(32#),,231.03588(2),',
    '91,Pa,241,241.06408(43#),,231.03588(2),',
    '92,U,217,217.02466(11#),,238.02891(3),"g,m"',
    '92,U,218,218.023523(20),,238.02891(3),"g,m"',
    '92,U,219,219.024999(55),,238.02891(3),"g,m"',
    '92,U,220,220.02462(11#),,238.02891(3),"g,m"',
    '92,U,221,221.02628(11#),,238.02891(3),"g,m"',
    '92,U,222,222.02600(11#),,238.02891(3),"g,m"',
    '92,U,223,223.027739(76),,238.02891(3),"g,m"',
    '92,U,224,224.027605(27),,238.02891(3),"g,m"',
    '92,U,225,225.029391(13),,238.02891(3),"g,m"',
    '92,U,226,226.029339(14),,238.02891(3),"g,m"',
    '92,U,227,227.031157(18),,238.02891(3),"g,m"',
    '92,U,228,228.031371(15),,238.02891(3),"g,m"',
    '92,U,229,229.0335063(64),,238.02891(3),"g,m"',
    '92,U,230,230.0339401(51),,238.02891(3),"g,m"',
    '92,U,231,231.0362939(32),,238.02891(3),"g,m"',
    '92,U,232,232.0371563(23),,238.02891(3),"g,m"',
    '92,U,233,233.0396355(29),,238.02891(3),"g,m"',
    '92,U,234,234.0409523(19),0.000054(5),238.02891(3),"g,m"',
    '92,U,235,235.0439301(19),0.007204(6),238.02891(3),"g,m"',
    '92,U,236,236.0455682(19),,238.02891(3),"g,m"',
    '92,U,237,237.0487304(20),,238.02891(3),"g,m"',
    '92,U,238,238.0507884(20),0.992742(10),238.02891(3),"g,m"',
    '92,U,239,239.0542935(20),,238.02891(3),"g,m"',
    '92,U,240,240.0565934(57),,238.02891(3),"g,m"',
    '92,U,241,241.06033(32#),,238.02891(3),"g,m"',
    '92,U,242,242.06293(22#),,238.02891(3),"g,m"',
    '92,U,243,243.06699(43#),,238.02891(3),"g,m"',
    '93,Np,219,219.03143(21#),,[237],',
    '93,Np,220,220.03254(21#),,[237],',
    '93,Np,221,221.03204(21#),,[237],',
    '93,Np,222,222.03330(21#),,[237],',
    '93,Np,223,223.03285(21#),,[237],',
    '93,Np,224,224.03422(21#),,[237],',
    '93,Np,225,225.033911(77),,[237],',
    '93,Np,226,226.035188(95#),,[237],',
    '93,Np,227,227.034957(78),,[237],',
    '93,Np,228,228.036067(54),,[237],',
    '93,Np,229,229.036264(93),,[237],',
    '93,Np,230,230.037828(55),,[237],',
    '93,Np,231,231.038245(54),,[237],',
    '93,Np,232,232.04011(11#),,[237],',
    '93,Np,233,233.040741(55),,[237],',
    '93,Np,234,234.0428953(91),,[237],',
    '93,Np,235,235.0440635(21),,[237],',
    '93,Np,236,236.046570(54),,[237],',
    '93,Np,237,237.0481736(19),,[237],',
    '93,Np,238,238.0509466(19),,[237],',
    '93,Np,239,239.0529392(22),,[237],',
    '93,Np,240,240.056165(18),,[237],',
    '93,Np,241,241.058253(76),,[237],',
    '93,Np,242,242.06164(21),,[237],',
    '93,Np,243,243.064280(34#),,[237],',
    '93,Np,244,244.06785(32#),,[237],',
    '93,Np,245,245.07080(43#),,[237],',
    '94,Pu,228,228.038732(33),,[244],',
    '94,Pu,229,229.040144(55),,[244],',
    '94,Pu,230,230.039650(16),,[244],',
    '94,Pu,231,231.041102(28),,[244],',
    '94,Pu,232,232.041185(19),,[244],',
    '94,Pu,233,233.042998(54),,[244],',
    '94,Pu,234,234.0433174(75),,[244],',
    '94,Pu,235,235.045286(22),,[244],',
    '94,Pu,236,236.0460581(23),,[244],',
    '94,Pu,237,237.0484098(24),,[244],',
    '94,Pu,238,238.0495601(19),,[244],',
    '94,Pu,239,239.0521636(19),,[244],',
    '94,Pu,240,240.0538138(19),,[244],',
    '94,Pu,241,241.0568517(19),,[244],',
    '94,Pu,242,242.0587428(20),,[244],',
    '94,Pu,243,243.0620036(34),,[244],',
    '94,Pu,244,244.0642053(56),,[244],',
    '94,Pu,245,245.067826(15),,[244],',
    '94,Pu,246,246.070205(16),,[244],',
    '94,Pu,247,247.07419(21#),,[244],',
    '95,Am,230,230.04609(14#),,,',
    '95,Am,231,231.04556(32#),,,',
    '95,Am,232,232.04645(32#),,,',
    '95,Am,233,233.04644(11#),,,',
    '95,Am,234,234.04773(17#),,,',
    '95,Am,235,235.047908(56),,,',
    '95,Am,236,236.04943(12#),,,',
    '95,Am,237,237.049996(64#),,,',
    '95,Am,238,238.051985(54),,,',
    '95,Am,239,239.0530247(26),,,',
    '95,Am,240,240.055300(15),,,',
    '95,Am,241,241.0568293(19),,,',
    '95,Am,242,242.0595494(19),,,',
    '95,Am,243,243.0613813(24),,,',
    '95,Am,244,244.0642851(22),,,',
    '95,Am,245,245.0664548(34),,,',
    '95,Am,246,246.069775(20#),,,',
    '95,Am,247,247.07209(11#),,,',
    '95,Am,248,248.07575(22#),,,',
    '95,Am,249,249.07848(32#),,,',
    '96,Cm,232,232.04982(22#),,,',
    '96,Cm,233,233.050770(77),,,',
    '96,Cm,234,234.050160(20),,,',
    '96,Cm,235,235.05154(22#),,,',
    '96,Cm,236,236.051374(20),,,',
    '96,Cm,237,237.052869(76),,,',
    '96,Cm,238,238.053081(13),,,',
    '96,Cm,239,239.054910(58),,,',
    '96,Cm,240,240.0555297(24),,,',
    '96,Cm,241,241.0576532(23),,,',
    '96,Cm,242,242.0588360(19),,,',
    '96,Cm,243,243.0613893(22),,,',
    '96,Cm,244,244.0627528(19),,,',
    '96,Cm,245,245.0654915(22),,,',
    '96,Cm,246,246.0672238(22),,,',
    '96,Cm,247,247.0703541(47),,,',
    '96,Cm,248,248.0723499(56),,,',
    '96,Cm,249,249.0759548(56),,,',
    '96,Cm,250,250.078358(12),,,',
    '96,Cm,251,251.082286(24),,,',
    '96,Cm,252,252.08487(32#),,,',
    '97,Bk,234,234.05727(15#),,,',
    '97,Bk,235,235.05658(43#),,,',
    '97,Bk,236,236.05748(43#),,,',
    '97,Bk,237,237.05710(24#),,,',
    '97,Bk,238,238.05820(27#),,,',
    '97,Bk,239,239.05824(22#),,,',
    '97,Bk,240,240.05976(16#),,,',
    '97,Bk,241,241.06016(22#),,,',
    '97,Bk,242,242.06198(22#),,,',
    '97,Bk,243,243.0630078(51),,,',
    '97,Bk,244,244.065181(16),,,',
    '97,Bk,245,245.0663618(24),,,',
    '97,Bk,246,246.068673(64),,,',
    '97,Bk,247,247.0703073(59),,,',
    '97,Bk,248,248.073088(76#),,,',
    '97,Bk,249,249.0749877(27),,,',
    '97,Bk,250,250.0783167(42),,,',
    '97,Bk,251,251.080762(12),,,',
    '97,Bk,252,252.08431(22#),,,',
    '97,Bk,253,253.08688(39#),,,',
    '97,Bk,254,254.09060(32#),,,',
    '98,Cf,237,237.062198(94),,,',
    '98,Cf,238,238.06149(32#),,,',
    '98,Cf,239,239.06253(23#),,,',
    '98,Cf,240,240.062256(20),,,',
    '98,Cf,241,241.06369(18#),,,',
    '98,Cf,242,242.063754(14),,,',
    '98,Cf,243,243.06548(12#),,,',
    '98,Cf,244,244.0660008(31),,,',
    '98,Cf,245,245.0680487(30),,,',
    '98,Cf,246,246.0688055(22),,,',
    '98,Cf,247,247.070965(16),,,',
    '98,Cf,248,248.0721851(57),,,',
    '98,Cf,249,249.0748539(23),,,',
    '98,Cf,250,250.0764062(22),,,',
    '98,Cf,251,251.0795886(48),,,',
    '98,Cf,252,252.0816272(56),,,',
    '98,Cf,253,253.0851345(67),,,',
    '98,Cf,254,254.087324(13),,,',
    '98,Cf,255,255.09105(22#),,,',
    '98,Cf,256,256.09344(34#),,,',
    '99,Es,239,239.06823(32#),,,',
    '99,Es,240,240.06892(43#),,,',
    '99,Es,241,241.06856(24#),,,',
    '99,Es,242,242.06957(28#),,,',
    '99,Es,243,243.06951(22#),,,',
    '99,Es,244,244.07088(20#),,,',
    '99,Es,245,245.07125(22#),,,',
    '99,Es,246,246.07290(24#),,,',
    '99,Es,247,247.073622(21),,,',
    '99,Es,248,248.075471(56#),,,',
    '99,Es,249,249.076411(32#),,,',
    '99,Es,250,250.07861(11#),,,',
    '99,Es,251,251.0799936(67),,,',
    '99,Es,252,252.082980(54),,,',
    '99,Es,253,253.0848257(27),,,',
    '99,Es,254,254.0880222(45),,,',
    '99,Es,255,255.090275(12),,,',
    '99,Es,256,256.09360(11#),,,',
    '99,Es,257,257.09598(44#),,,',
    '99,Es,258,258.09952(32#),,,',
    '100,Fm,241,241.07421(32#),,,',
    '100,Fm,242,242.07343(43#),,,',
    '100,Fm,243,243.07446(23#),,,',
    '100,Fm,244,244.07404(22#),,,',
    '100,Fm,245,245.07535(21#),,,',
    '100,Fm,246,246.075350(17),,,',
    '100,Fm,247,247.07694(12#),,,',
    '100,Fm,248,248.0771865(92),,,',
    '100,Fm,249,249.0789275(68),,,',
    '100,Fm,250,250.0795210(86),,,',
    '100,Fm,251,251.081540(16),,,',
    '100,Fm,252,252.0824671(61),,,',
    '100,Fm,253,253.0851846(37),,,',
    '100,Fm,254,254.0868544(30),,,',
    '100,Fm,255,255.0899640(52),,,',
    '100,Fm,256,256.0917745(78),,,',
    '100,Fm,257,257.0951061(69),,,',
    '100,Fm,258,258.09708(22#),,,',
    '100,Fm,259,259.10060(30#),,,',
    '100,Fm,260,260.10281(55#),,,',
    '101,Md,245,245.08081(33#),,,',
    '101,Md,246,246.08171(28#),,,',
    '101,Md,247,247.08152(22#),,,',
    '101,Md,248,248.08282(26#),,,',
    '101,Md,249,249.08291(22#),,,',
    '101,Md,250,250.08441(32#),,,',
    '101,Md,251,251.084774(20),,,',
    '101,Md,252,252.08643(14#),,,',
    '101,Md,253,253.087144(34#),,,',
    '101,Md,254,254.08959(11#),,,',
    '101,Md,255,255.0910841(73),,,',
    '101,Md,256,256.09389(13#),,,',
    '101,Md,257,257.0955424(29),,,',
    '101,Md,258,258.0984315(50),,,',
    '101,Md,259,259.10051(22#),,,',
    '101,Md,260,260.10365(34#),,,',
    '101,Md,261,261.10583(62#),,,',
    '101,Md,262,262.10910(45#),,,',
    '102,No,248,248.08655(24#),,,',
    '102,No,249,249.08780(30#),,,',
    '102,No,250,250.08756(22#),,,',
    '102,No,251,251.08894(12#),,,',
    '102,No,252,252.088967(10),,,',
    '102,No,253,253.0905641(75),,,',
    '102,No,254,254.090956(11),,,',
    '102,No,255,255.093191(16),,,',
    '102,No,256,256.0942829(84),,,',
    '102,No,257,257.0968878(74),,,',
    '102,No,258,258.09821(11#),,,',
    '102,No,259,259.10103(11#),,,',
    '102,No,260,260.10264(22#),,,',
    '102,No,261,261.10570(22#),,,',
    '102,No,262,262.10746(39#),,,',
    '102,No,263,263.11071(53#),,,',
    '102,No,264,264.11273(70#),,,',
    '103,Lr,251,251.09418(32#),,,',
    '103,Lr,252,252.09526(26#),,,',
    '103,Lr,253,253.09509(22#),,,',
    '103,Lr,254,254.09648(32#),,,',
    '103,Lr,255,255.096562(19),,,',
    '103,Lr,256,256.098494(89),,,',
    '103,Lr,257,257.099418(47#),,,',
    '103,Lr,258,258.10176(11#),,,',
    '103,Lr,259,259.102902(76#),,,',
    '103,Lr,260,260.10550(13#),,,',
    '103,Lr,261,261.10688(22#),,,',
    '103,Lr,262,262.10961(22#),,,',
    '103,Lr,263,263.11136(30#),,,',
    '103,Lr,264,264.11420(47#),,,',
    '103,Lr,265,265.11619(65#),,,',
    '103,Lr,266,266.11983(56#),,,',
    '104,Rf,253,253.10044(44#),,,',
    '104,Rf,254,254.10005(30#),,,',
    '104,Rf,255,255.10127(12#),,,',
    '104,Rf,256,256.101152(19),,,',
    '104,Rf,257,257.102918(12),,,',
    '104,Rf,258,258.103428(34),,,',
    '104,Rf,259,259.105596(78#),,,',
    '104,Rf,260,260.10644(22#),,,',
    '104,Rf,261,261.108773(54),,,',
    '104,Rf,262,262.10992(24#),,,',
    '104,Rf,263,263.11249(20#),,,',
    '104,Rf,264,264.11388(39#),,,',
    '104,Rf,265,265.11668(39#),,,',
    '104,Rf,266,266.11817(50#),,,',
    '104,Rf,267,267.12179(62#),,,',
    '104,Rf,268,268.12397(77#),,,',
    '105,Db,255,255.10707(45#),,,',
    '105,Db,256,256.10789(26#),,,',
    '105,Db,257,257.10758(22#),,,',
    '105,Db,258,258.10928(33#),,,',
    '105,Db,259,259.109492(57),,,',
    '105,Db,260,260.11130(10#),,,',
    '105,Db,261,261.11192(12#),,,',
    '105,Db,262,262.11407(15#),,,',
    '105,Db,263,263.11499(18#),,,',
    '105,Db,264,264.11741(25#),,,',
    '105,Db,265,265.11861(24#),,,',
    '105,Db,266,266.12103(30#),,,',
    '105,Db,267,267.12247(44#),,,',
    '105,Db,268,268.12567(57#),,,',
    '105,Db,269,269.12791(73#),,,',
    '105,Db,270,270.13136(64#),,,',
    '106,Sg,258,258.11298(44#),,,',
    '106,Sg,259,259.11440(13#),,,',
    '106,Sg,260,260.114384(22),,,',
    '106,Sg,261,261.115949(20),,,',
    '106,Sg,262,262.116337(38),,,',
    '106,Sg,263,263.11829(10#),,,',
    '106,Sg,264,264.11893(30#),,,',
    '106,Sg,265,265.12109(13#),,,',
    '106,Sg,266,266.12198(26#),,,',
    '106,Sg,267,267.12436(30#),,,',
    '106,Sg,268,268.12539(50#),,,',
    '106,Sg,269,269.12863(39#),,,',
    '106,Sg,270,270.13043(60#),,,',
    '106,Sg,271,271.13393(63#),,,',
    '106,Sg,272,272.13589(83#),,,',
    '106,Sg,273,273.13958(54#),,,',
    '107,Bh,260,260.12166(26#),,,',
    '107,Bh,261,261.12145(22#),,,',
    '107,Bh,262,262.12297(33#),,,',
    '107,Bh,263,263.12292(33#),,,',
    '107,Bh,264,264.12459(19#),,,',
    '107,Bh,265,265.12491(25#),,,',
    '107,Bh,266,266.12679(18#),,,',
    '107,Bh,267,267.12750(28#),,,',
    '107,Bh,268,268.12969(41#),,,',
    '107,Bh,269,269.13042(40#),,,',
    '107,Bh,270,270.13336(31#),,,',
    '107,Bh,271,271.13526(48#),,,',
    '107,Bh,272,272.13826(58#),,,',
    '107,Bh,273,273.14024(80#),,,',
    '107,Bh,274,274.14355(65#),,,',
    '107,Bh,275,275.14567(64#),,,',
    '108,Hs,263,263.12852(14#),,,',
    '108,Hs,264,264.128357(31),,,',
    '108,Hs,265,265.129793(26),,,',
    '108,Hs,266,266.130046(42),,,',
    '108,Hs,267,267.13167(10#),,,',
    '108,Hs,268,268.13186(30#),,,',
    '108,Hs,269,269.13375(13#),,,',
    '108,Hs,270,270.13429(27#),,,',
    '108,Hs,271,271.13717(32#),,,',
    '108,Hs,272,272.13850(55#),,,',
    '108,Hs,273,273.14168(40#),,,',
    '108,Hs,274,274.14330(63#),,,',
    '108,Hs,275,275.14667(63#),,,',
    '108,Hs,276,276.14846(86#),,,',
    '108,Hs,277,277.15190(58#),,,',
    '109,Mt,265,265.13600(48#),,,',
    '109,Mt,266,266.13737(33#),,,',
    '109,Mt,267,267.13719(54#),,,',
    '109,Mt,268,268.13865(25#),,,',
    '109,Mt,269,269.13882(50#),,,',
    '109,Mt,270,270.14033(18#),,,',
    '109,Mt,271,271.14074(35#),,,',
    '109,Mt,272,272.14341(52#),,,',
    '109,Mt,273,273.14440(52#),,,',
    '109,Mt,274,274.14724(38#),,,',
    '109,Mt,275,275.14882(50#),,,',
    '109,Mt,276,276.15159(59#),,,',
    '109,Mt,277,277.15327(82#),,,',
    '109,Mt,278,278.15631(68#),,,',
    '109,Mt,279,279.15808(72#),,,',
    '110,Ds,267,267.14377(15#),,,',
    '110,Ds,268,268.14348(32#),,,',
    '110,Ds,269,269.144752(34),,,',
    '110,Ds,270,270.144584(52),,,',
    '110,Ds,271,271.14595(10#),,,',
    '110,Ds,272,272.14602(44#),,,',
    '110,Ds,273,273.14856(14#),,,',
    '110,Ds,274,274.14941(42#),,,',
    '110,Ds,275,275.15203(45#),,,',
    '110,Ds,276,276.15303(59#),,,',
    '110,Ds,277,277.15591(41#),,,',
    '110,Ds,278,278.15704(67#),,,',
    '110,Ds,279,279.16010(64#),,,',
    '110,Ds,280,280.16131(89#),,,',
    '110,Ds,281,281.16451(59#),,,',
    '111,Rg,272,272.15327(25#),,,',
    '111,Rg,273,273.15313(56#),,,',
    '111,Rg,274,274.15525(19#),,,',
    '111,Rg,275,275.15594(56#),,,',
    '111,Rg,276,276.15833(68#),,,',
    '111,Rg,277,277.15907(61#),,,',
    '111,Rg,278,278.16149(38#),,,',
    '111,Rg,279,279.16272(51#),,,',
    '111,Rg,280,280.16514(61#),,,',
    '111,Rg,281,281.16636(89#),,,',
    '111,Rg,282,282.16912(72#),,,',
    '111,Rg,283,283.17054(79#),,,',
    '112,Cn,276,276.16141(64#),,,',
    '112,Cn,277,277.16364(15#),,,',
    '112,Cn,278,278.16416(47#),,,',
    '112,Cn,279,279.16654(50#),,,',
    '112,Cn,280,280.16715(63#),,,',
    '112,Cn,281,281.16975(42#),,,',
    '112,Cn,282,282.17050(70#),,,',
    '112,Cn,283,283.17327(65#),,,',
    '112,Cn,284,284.17416(91#),,,',
    '112,Cn,285,285.17712(60#),,,',
    '113,Nh,278,278.17058(20#),,,',
    '113,Nh,279,279.17095(75#),,,',
    '113,Nh,280,280.17293(75#),,,',
    '113,Nh,281,281.17348(75#),,,',
    '113,Nh,282,282.17567(39#),,,',
    '113,Nh,283,283.17657(52#),,,',
    '113,Nh,284,284.17873(62#),,,',
    '113,Nh,285,285.17973(89#),,,',
    '113,Nh,286,286.18221(72#),,,',
    '113,Nh,287,287.18339(81#),,,',
    '114,Fl,285,285.18364(47#),,,',
    '114,Fl,286,286.18423(71#),,,',
    '114,Fl,287,287.18678(66#),,,',
    '114,Fl,288,288.18757(91#),,,',
    '114,Fl,289,289.19042(60#),,,',
    '115,Mc,287,287.19070(52#),,,',
    '115,Mc,288,288.19274(62#),,,',
    '115,Mc,289,289.19363(89#),,,',
    '115,Mc,290,290.19598(73#),,,',
    '115,Mc,291,291.19707(88#),,,',
    '116,Lv,289,289.19816(57#),,,',
    '116,Lv,290,290.19864(71#),,,',
    '116,Lv,291,291.20108(66#),,,',
    '116,Lv,292,292.20174(91#),,,',
    '116,Lv,293,293.20449(60#),,,',
    '117,Ts,291,291.20553(68#),,,',
    '117,Ts,292,292.20746(75#),,,',
    '117,Ts,293,293.20824(89#),,,',
    '117,Ts,294,294.21046(74#),,,',
    '118,Og,293,293.21356(78#),,,',
    '118,Og,294,294.21392(71#),,,',
    '118,Og,295,295.21624(69#),,,'
    ]))

atomicdata = pd.read_csv(atomicdatacsv)