from __future__ import annotations

from typing import Union

import pytest

from plum import Dispatcher, NotFoundLookupError

dispatch = Dispatcher()


class Number:
    def __init__(self, value):
        self.value = value

    @dispatch
    def __add__(self, other: Union[Number, int]) -> "Number":
        if isinstance(other, int):
            other_value = other
        else:
            other_value = other.value
        return Number(self.value + other_value)


def test_forward_reference():
    one = Number(1)
    two = Number(2)
    three = one + two
    assert isinstance(three, Number)
    assert three.value == 3

    three = one + 2
    assert isinstance(three, Number)
    assert three.value == 3

    with pytest.raises(NotFoundLookupError):
        three = one + 2.0
