import pytest
import numpy as np


dynmat_ref_000 = [
    0.052897, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    -0.042597, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.000000, 0.000000, 0.052897, 0.000000, 0.000000, 0.000000,
    0.000000, 0.000000, -0.042597, 0.000000, 0.000000, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, 0.052897, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, -0.042597, 0.000000,
    -0.042597, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.034302, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.000000, 0.000000, -0.042597, 0.000000, 0.000000, 0.000000,
    0.000000, 0.000000, 0.034302, 0.000000, 0.000000, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, -0.042597, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, 0.034302, 0.000000]


dynmat_ref_252525 = [
    0.075295, 0.000000, 0.016777, 0.000000, 0.016777, 0.000000,
    -0.040182, 0.000000, -0.004226, 0.000000, -0.004226, 0.000000,
    0.016777, 0.000000, 0.075295, 0.000000, 0.016777, 0.000000,
    -0.004226, 0.000000, -0.040182, 0.000000, -0.004226, 0.000000,
    0.016777, 0.000000, 0.016777, 0.000000, 0.075295, 0.000000,
    -0.004226, 0.000000, -0.004226, 0.000000, -0.040182, 0.000000,
    -0.040182, 0.000000, -0.004226, 0.000000, -0.004226, 0.000000,
    0.055704, 0.000000, 0.011621, 0.000000, 0.011621, 0.000000,
    -0.004226, 0.000000, -0.040182, 0.000000, -0.004226, 0.000000,
    0.011621, 0.000000, 0.055704, 0.000000, 0.011621, 0.000000,
    -0.004226, 0.000000, -0.004226, 0.000000, -0.040182, 0.000000,
    0.011621, 0.000000, 0.011621, 0.000000, 0.055704, 0.000000]

dynmat_gonze_lee_ref_252525 = [
    0.081339, 0.000000, 0.029509, 0.000000, 0.029509, 0.000000,
    -0.045098, 0.000000, -0.015204, 0.000000, -0.015204, 0.000000,
    0.029509, 0.000000, 0.081339, 0.000000, 0.029509, 0.000000,
    -0.015204, 0.000000, -0.045098, 0.000000, -0.015204, 0.000000,
    0.029509, 0.000000, 0.029509, 0.000000, 0.081339, 0.000000,
    -0.015204, 0.000000, -0.015204, 0.000000, -0.045098, 0.000000,
    -0.045098, 0.000000, -0.015204, 0.000000, -0.015204, 0.000000,
    0.059623, 0.000000, 0.019878, 0.000000, 0.019878, 0.000000,
    -0.015204, 0.000000, -0.045098, 0.000000, -0.015204, 0.000000,
    0.019878, 0.000000, 0.059623, 0.000000, 0.019878, 0.000000,
    -0.015204, 0.000000, -0.015204, 0.000000, -0.045098, 0.000000,
    0.019878, 0.000000, 0.019878, 0.000000, 0.059623, 0.000000]

dynmat_wang_ref_252525 = [
    0.081339, -0.000000, 0.022821, 0.000000, 0.022821, 0.000000,
    -0.045098, -0.000000, -0.009142, -0.000000, -0.009142, 0.000000,
    0.022821, 0.000000, 0.081339, 0.000000, 0.022821, 0.000000,
    -0.009142, 0.000000, -0.045098, 0.000000, -0.009142, 0.000000,
    0.022821, 0.000000, 0.022821, 0.000000, 0.081339, 0.000000,
    -0.009142, 0.000000, -0.009142, 0.000000, -0.045098, 0.000000,
    -0.045098, 0.000000, -0.009142, 0.000000, -0.009142, 0.000000,
    0.059623, 0.000000, 0.015541, 0.000000, 0.015541, 0.000000,
    -0.009142, 0.000000, -0.045098, 0.000000, -0.009142, 0.000000,
    0.015541, 0.000000, 0.059623, 0.000000, 0.015541, 0.000000,
    -0.009142, 0.000000, -0.009142, 0.000000, -0.045098, 0.000000,
    0.015541, 0.000000, 0.015541, -0.000000, 0.059623, 0.000000]

dynmat_ref_555 = [
    0.091690, 0.000000, 0.033857, 0.000000, 0.033857, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.033857, 0.000000, 0.091690, 0.000000, 0.033857, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.033857, 0.000000, 0.033857, 0.000000, 0.091690, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.064909, 0.000000, 0.021086, 0.000000, 0.021086, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.021086, 0.000000, 0.064909, 0.000000, 0.021086, 0.000000,
    0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
    0.021086, 0.000000, 0.021086, 0.000000, 0.064909, 0.000000]



@pytest.mark.parametrize("is_compact_fc,lang",
                         [(True, "C"), (False, "C"),
                          (True, "Py"), (False, "Py")])
def test_dynmat(ph_nacl_nonac,
                ph_nacl_nonac_compact_fc,
                is_compact_fc,
                lang):
    if is_compact_fc:
        ph = ph_nacl_nonac_compact_fc
    else:
        ph = ph_nacl_nonac
    dynmat = ph.dynamical_matrix
    _test_dynmat(dynmat, lang=lang)
    _test_dynmat_252525(dynmat, dynmat_ref_252525, lang=lang)


def test_dynmat_dense_svecs(ph_nacl_nonac_dense_svecs):
    ph = ph_nacl_nonac_dense_svecs
    svecs, multi = ph.primitive.get_smallest_vectors()
    dynmat = ph.dynamical_matrix
    lang = 'Py'
    _test_dynmat(dynmat, lang=lang)
    _test_dynmat_252525(dynmat, dynmat_ref_252525, lang=lang)


def test_dynmat_gonze_lee(ph_nacl):
    dynmat = ph_nacl.dynamical_matrix
    _test_dynmat_252525(dynmat, dynmat_gonze_lee_ref_252525)


def test_dynmat_wang(ph_nacl):
    nac_params = ph_nacl.nac_params
    nac_params['method'] = 'wang'
    ph_nacl.nac_params = nac_params
    dynmat = ph_nacl.dynamical_matrix
    _test_dynmat_252525(dynmat, dynmat_wang_ref_252525)
    # Reset nac_params['method']
    nac_params.pop('method')
    ph_nacl.nac_params = nac_params


def _test_dynmat(dynmat, lang=None):
    dtype_complex = ("c%d" % (np.dtype('double').itemsize * 2))
    if lang:
        dynmat.run([0, 0, 0], lang=lang)
    else:
        dynmat.run([0, 0, 0])
    dynmat_ref = np.array(
        dynmat_ref_000, dtype='double').view(dtype=dtype_complex).reshape(6, 6)
    np.testing.assert_allclose(dynmat.dynamical_matrix, dynmat_ref, atol=1e-5)

    if lang:
        dynmat.run([0.5, 0.5, 0.5], lang=lang)
    else:
        dynmat.run([0.5, 0.5, 0.5])
    dynmat_ref = np.array(
        dynmat_ref_555, dtype='double').view(dtype=dtype_complex).reshape(6, 6)
    np.testing.assert_allclose(dynmat.dynamical_matrix, dynmat_ref, atol=1e-5)


def _test_dynmat_252525(dynmat, dynmat_ref, lang=None):
    dtype_complex = ("c%d" % (np.dtype('double').itemsize * 2))
    if lang:
        dynmat.run([0.25, 0.25, 0.25], lang=lang)
    else:
        dynmat.run([0.25, 0.25, 0.25])
    # for row in dynmat.dynamical_matrix:
    #     print("".join(["%f, %f, " % (c.real, c.imag) for c in row]))
    dynmat_ref = np.array(
        dynmat_ref, dtype='double').view(dtype=dtype_complex).reshape(6, 6)
    np.testing.assert_allclose(dynmat.dynamical_matrix, dynmat_ref, atol=1e-5)
