/******************************************************************************
 *
 * Copyright (c) 2019, the Perspective Authors.
 *
 * This file is part of the Perspective library, distributed under the terms of
 * the Apache License 2.0.  The full license can be found in the LICENSE file.
 *
 */
#pragma once
#ifdef PSP_ENABLE_PYTHON

#include <perspective/base.h>
#include <perspective/binding.h>
#include <perspective/python/base.h>
#include <perspective/utils.h>

namespace perspective {
namespace binding {

    /******************************************************************************
     *
     * Fill columns with data
     */

    template <>
    void set_column_nth(
        std::shared_ptr<t_column> col, t_uindex idx, t_val value);

    /******************************************************************************
     *
     * Fill tables with data
     */

    void _fill_data(t_data_table& tbl, t_data_accessor accessor,
        const t_schema& input_schema, const std::string& index,
        std::uint32_t offset, std::uint32_t limit, bool is_update);

} // namespace binding
} // namespace perspective

#endif