################################################################################
#
# Copyright (c) 2019, the Perspective Authors.
#
# This file is part of the Perspective library, distributed under the terms of
# the Apache License 2.0.  The full license can be found in the LICENSE file.
#

from datetime import date, datetime

import perspective
from pytest import mark


class TestTableInfer(object):

    def test_table_limit_wraparound_does_not_respect_partial(self):
        t = perspective.Table({'a':float, 'b':float}, limit=3)
        t.update([{'a':10}, {'b':1}, {'a':20}, {'a':None,'b':2}])
        df = t.view().to_df()

        t2 = perspective.Table({'a':float, 'b':float}, limit=3)
        t2.update([{'a':10}, {'b':1}, {'a':20}, {'b':2}])
        df2 = t2.view().to_df()

        assert df.to_dict() == df2.to_dict()
