# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'nedelja',
        1: 'ponedeljek',
        2: 'torek',
        3: 'sreda',
        4: 'četrtek',
        5: 'petek',
        6: 'sobota'
    },
    'days_abbrev': {
        0: 'ned.',
        1: 'pon.',
        2: 'tor.',
        3: 'sre.',
        4: 'čet.',
        5: 'pet.',
        6: 'sob.'
    },

    # Months
    'months': {
        1: 'januar',
        2: 'februar',
        3: 'marec',
        4: 'april',
        5: 'maj',
        6: 'junij',
        7: 'julij',
        8: 'avgust',
        9: 'september',
        10: 'oktober',
        11: 'november',
        12: 'december'
    },
    'months_abbrev': {
        1: 'jan.',
        2: 'feb.',
        3: 'mar.',
        4: 'apr.',
        5: 'maj.',
        6: 'jun.',
        7: 'jul.',
        8: 'avg.',
        9: 'sep.',
        10: 'okt.',
        11: 'nov.',
        12: 'dec.'
    },

    # Units of time
    'year': ['{count} leto', '{count} leti', '{count} leta', '{count} let'],
    'month': ['{count} mesec', '{count} meseca', '{count} mesece', '{count} mesecev'],
    'week': ['{count} teden', '{count} tedna', '{count} tedne', '{count} tednov'],
    'day': ['{count} dan', '{count} dni', '{count} dni', '{count} dni'],
    'hour': ['{count} uro', '{count} uri', '{count} ure', '{count} ur'],
    'minute': ['{count} minuto', '{count} minuti', '{count} minute', '{count} minut'],
    'second': ['{count} sekundo', '{count} sekundi', '{count} sekunde', '{count} sekund'],

    # Relative time
    'year_ago': ['{count} letom', '{count} leti', '{count} leti', '{count} leti'],
    'month_ago': ['{count} mesecem', '{count} meseci', '{count} meseci', '{count} meseci'],
    'week_ago': ['{count} tednom', '{count} tednoma', '{count} tedni', '{count} tedni'],
    'day_ago': ['{count} dnem', '{count} dnevoma', '{count} dnevi', '{count} dnevi'],
    'hour_ago': ['{count} uro', '{count} urama', '{count} urami', '{count} urami'],
    'minute_ago': ['{count} minuto', '{count} minutama', '{count} minutami', '{count} minutami'],
    'second_ago': ['{count} sekundo', '{count} sekundama', '{count} sekundami', '{count} sekundami'],
    'ago': 'pred {time}',
    'from_now': 'čez {time}',
    'after': 'čez {time}',
    'before': 'pred {time}',

    # Date formats
    'date_formats': {
        'LTS': 'H:mm:ss',
        'LT': 'H:mm',
        'LLLL': 'dddd, D. MMMM YYYY H:mm',
        'LLL': 'D. MMMM YYYY H:mm',
        'LL': 'D. MMMM YYYY',
        'L': 'DD. MM. YYYY',
    },
}
