# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'Sonntag',
        1: 'Montag',
        2: 'Dienstag',
        3: 'Mittwoch',
        4: 'Donnerstag',
        5: 'Freitag',
        6: 'Samstag'
    },
    'days_abbrev': {
        0: 'So',
        1: 'Mo',
        2: 'Di',
        3: 'Mi',
        4: 'Do',
        5: 'Fr',
        6: 'Sa'
    },

    # Months
    'months': {
        1: 'Januar',
        2: 'Februar',
        3: 'März',
        4: 'April',
        5: 'Mai',
        6: 'Juni',
        7: 'Juli',
        8: 'August',
        9: 'September',
        10: 'Oktober',
        11: 'November',
        12: 'Dezember',
    },
    'months_abbrev': {
        1: 'Jan',
        2: 'Feb',
        3: 'Mär',
        4: 'Apr',
        5: 'Mai',
        6: 'Jun',
        7: 'Jul',
        8: 'Aug',
        9: 'Sep',
        10: 'Okt',
        11: 'Nov',
        12: 'Dez',
    },

    # Units of time
    'year': ['{count} Jahr', '{count} Jahre'],
    'month': ['{count} Monat', '{count} Monate'],
    'week': ['{count} Woche', '{count} Wochen'],
    'day': ['{count} Tag', '{count} Tage'],
    'hour': ['{count} Stunde', '{count} Stunden'],
    'minute': ['{count} Minute', '{count} Minuten'],
    'second': ['{count} Sekunde', '{count} Sekunden'],

    # Relative time
    'ago': 'vor {time}',
    'from_now': 'in {time}',
    'after': '{time} später',
    'before': '{time} zuvor',

    'year_from_now': ['{count} Jahr', '{count} Jahren'],
    'month_from_now': ['{count} Monat', '{count} Monaten'],
    'week_from_now': ['{count} Woche', '{count} Wochen'],
    'day_from_now': ['{count} Tag', '{count} Tagen'],
    'year_ago': ['{count} Jahr', '{count} Jahren'],
    'month_ago': ['{count} Monat', '{count} Monaten'],
    'week_ago': ['{count} Woche', '{count} Wochen'],
    'day_ago': ['{count} Tag', '{count} Tagen'],

    # Date formats
    'date_formats': {
        'LTS': 'HH:mm:ss',
        'LT': 'HH:mm',
        'LLLL': 'dddd, D. MMMM YYYY HH:mm',
        'LLL': 'D. MMMM YYYY HH:mm',
        'LL': 'D. MMMM YYYY',
        'L': 'DD.MM.YYYY',
    },
}
