# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'রবিবার',
        1: 'সোমবার',
        2: 'মঙ্গলবার',
        3: 'বুধবার',
        4: 'বৃহস্পতিবার',
        5: 'শুক্রবার',
        6: 'শনিবার'
    },
    'days_abbrev': {
        0: 'রবি',
        1: 'সোম',
        2: 'মঙ্গল',
        3: 'বুধ',
        4: 'বৃহঃ',
        5: 'শুক্র',
        6: 'শনি'
    },

    # Months
    'months': {
        1: 'জানুয়ারি',
        2: 'ফেব্রুয়ারি',
        3: 'মার্চ',
        4: 'এপ্রিল',
        5: 'মে',
        6: 'জুন',
        7: 'জুলাই',
        8: 'আগস্ট',
        9: 'সেপ্টেম্বর',
        10: 'অক্টোবর',
        11: 'নভেম্বর',
        12: 'ডিসেম্বর',
    },
    'months_abbrev': {
        1: 'জানু',
        2: 'ফেব',
        3: 'মার্চ',
        4: 'এপ্রি',
        5: 'মে',
        6: 'জুন',
        7: 'জুল',
        8: 'অগা',
        9: 'সেপ্ট',
        10: 'অক্টো',
        11: 'নভে',
        12: 'ডিসে',
    },

    # Units of time
    'year': ['১ বছর', '{count} বছর'],
    'month': ['১ মাস', '{count} মাস'],
    'week': ['১ সপ্তাহ', '{count} সপ্তাহ'],
    'day': ['১ দিন', '{count} দিন'],
    'hour': ['১ ঘন্টা', '{count} ঘন্টা'],
    'minute': ['১ মিনিট', '{count} মিনিট'],
    'second': ['১ সেকেন্ড', '{count} সেকেন্ড'],
    'ago': '{time} পূর্বে',
    'from_now': 'এখন থেকে {time}',
    'after': '{time} পরে',
    'before': '{time} আগে',

    # Meridians
    'meridian': lambda time: 'সকাল' if 0 <= time[0] < 12 else 'বিকাল',

    # Date formats
    'date_formats': {
        'LTS': 'A h:mm:ss সময়',
        'LT': 'A h:mm সময়',
        'LLLL': 'dddd, D MMMM YYYY, A h:mm সময়',
        'LLL': 'D MMMM YYYY, A h:mm সময়',
        'LL': 'D MMMM YYYY',
        'L': 'DD/MM/YYYY',
    },
}
