# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'воскресенье',
        1: 'понедельник',
        2: 'вторник',
        3: 'среда',
        4: 'четверг',
        5: 'пятница',
        6: 'суббота'
    },
    'days_abbrev': {
        0: 'вс',
        1: 'пн',
        2: 'вт',
        3: 'ср',
        4: 'чт',
        5: 'пт',
        6: 'сб'
    },

    # Months
    'months': {
        1: 'января',
        2: 'февраля',
        3: 'марта',
        4: 'апреля',
        5: 'мая',
        6: 'июня',
        7: 'июля',
        8: 'августа',
        9: 'сентября',
        10: 'октября',
        11: 'ноября',
        12: 'декабря',
    },
    'months_abbrev': {
        1: 'янв',
        2: 'фев',
        3: 'мар',
        4: 'апр',
        5: 'май',
        6: 'июн',
        7: 'июл',
        8: 'авг',
        9: 'сен',
        10: 'окт',
        11: 'ноя',
        12: 'дек',
    },

    # Units of time
    'year': ['{count} год', '{count} года', '{count} лет'],
    'month': ['{count} месяц', '{count} месяца', '{count} месяцев'],
    'week': ['{count} неделю', '{count} недели', '{count} недель'],
    'day': ['{count} день', '{count} дня', '{count} дней'],
    'hour': ['{count} час', '{count} часа', '{count} часов'],
    'minute': ['{count} минуту', '{count} минуты', '{count} минут'],
    'second': ['{count} секунду', '{count} секунды', '{count} секунд'],

    # Relative time
    'ago': '{time} назад',
    'from_now': 'через {time}',
    'after': '{time} после',
    'before': '{time} до',

    # Date formats
    'date_formats': {
        'LTS': 'HH:mm:ss',
        'LT': 'HH:mm',
        'LLLL': 'dddd, D MMMM YYYY г., HH:mm',
        'LLL': 'D MMMM YYYY г., HH:mm',
        'LL': 'D MMMM YYYY г.',
        'L': 'DD.MM.YYYY',
    },
}
