# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'อาทิตย์',
        1: 'จันทร์',
        2: 'อังคาร',
        3: 'พุธ',
        4: 'พฤหัสบดี',
        5: 'ศุกร์',
        6: 'เสาร์'
    },
    'days_abbrev': {
        0: 'อา',
        1: 'จ',
        2: 'อ',
        3: 'พ',
        4: 'พฤ',
        5: 'ศ',
        6: 'ส'
    },

    # Months
    'months': {
        1: 'มกราคม',
        2: 'กุมภาพันธ์',
        3: 'มีนาคม',
        4: 'เมษายน',
        5: 'พฤษภาคม',
        6: 'มิถุนายน',
        7: 'กรกฎาคม',
        8: 'สิงหาคม',
        9: 'กันยายน',
        10: 'ตุลาคม',
        11: 'พฤศจิกายน',
        12: 'ธันวาคม',
    },
    'months_abbrev': {
        1: 'ม.ค.',
        2: 'ก.พ.',
        3: 'มี.ค.',
        4: 'เม.ย.',
        5: 'พ.ค.',
        6: 'มิ.ย.',
        7: 'ก.ค.',
        8: 'ส.ค.',
        9: 'ก.ย.',
        10: 'ต.ค.',
        11: 'พ.ย.',
        12: 'ธ.ค.',
    },

    # Units of time
    'year': ['{count} ปี', '{count} ปี'],
    'month': ['{count} เดือน', '{count} เดือน'],
    'week': ['{count} สัปดาห์', '{count} สัปดาห์'],
    'day': ['{count} วัน', '{count} วัน'],
    'hour': ['{count} ชั่วโมง', '{count} ชั่วโมง'],
    'minute': ['{count} นาที', '{count} นาที'],
    'second': ['{count} วินาที', '{count} วินาที'],

    # Relative time
    'ago': '{time} ที่แล้ว',
    'from_now': '{time} จากนี้',
    'after': 'หลัง{time}',
    'before': 'ก่อน{time}',

    # Date formats
    'date_formats': {
        'LTS': 'H นาฬิกา m นาที s วินาที',
        'LT': 'H นาฬิกา m นาที',
        'LLLL': 'วันddddที่ D MMMM YYYY เวลา H นาฬิกา m นาที',
        'LLL': 'D MMMM YYYY เวลา H นาฬิกา m นาที',
        'LL': 'D MMMM YYYY',
        'L': 'YYYY/MM/DD',
    },
}
