# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'ראשון',
        1: 'שני',
        2: 'שלישי',
        3: 'רביעי',
        4: 'חמישי',
        5: 'שישי',
        6: 'שבת'
    },
    'days_abbrev': {
        0: 'א׳',
        1: 'ב׳',
        2: 'ג׳',
        3: 'ד׳',
        4: 'ה׳',
        5: 'ו׳',
        6: 'ש׳'
    },

    # Months
    'months': {
        1: 'ינואר',
        2: 'פברואר',
        3: 'מרץ',
        4: 'אפריל',
        5: 'מאי',
        6: 'יוני',
        7: 'יולי',
        8: 'אוגוסט',
        9: 'ספטמבר',
        10: 'אוקטובר',
        11: 'נובמבר',
        12: 'דצמבר',
    },
    'months_abbrev': {
        1: 'ינו׳',
        2: 'פבר׳',
        3: 'מרץ',
        4: 'אפר׳',
        5: 'מאי',
        6: 'יוני',
        7: 'יולי',
        8: 'אוג׳',
        9: 'ספט׳',
        10: 'אוק׳',
        11: 'נוב׳',
        12: 'דצמ׳',
    },

    # Units of time
    'year': {
        1: 'שנה',
        2: 'שנתיים',
        'default': '{count} שנים'
    },
    'month': {
        1: 'חודש',
        2: 'חודשיים',
        'default': '{count} חודשים'
    },
    'week': {
        1: 'שבוע',
        2: 'שבועיים',
        'default': '{count} שבועות'
    },
    'day': {
        1: 'יום',
        2: 'יומיים',
        'default': '{count} ימים'
    },
    'hour': {
        1: 'שעה',
        2: 'שעתיים',
        'default': '{count} שעות'
    },
    'minute': {
        1: 'דקה',
        2: 'דקותיים',
        'default': '{count} דקות'
    },
    'second': ['שניה', '{count} שניות'],

    # Relative time
    'ago': 'לפני {time}',
    'from_now': 'בעוד {time}',
    'after': 'אחרי {time}',
    'before': 'לפני {time}',

    # Date formats
    'date_formats': {
        'LTS': 'HH:mm:ss',
        'LT': 'HH:mm',
        'LLLL': 'dddd, D [ב]MMMM YYYY HH:mm',
        'LLL': 'D [ב]MMMM YYYY HH:mm',
        'LL': 'D [ב]MMMM YYYY',
        'L': 'DD/MM/YYYY',
    },
}
