# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'zondag',
        1: 'maandag',
        2: 'dinsdag',
        3: 'woensdag',
        4: 'donderdag',
        5: 'vrijdag',
        6: 'zaterdag'
    },
    'days_abbrev': {
        0: 'zo',
        1: 'ma',
        2: 'di',
        3: 'wo',
        4: 'do',
        5: 'vr',
        6: 'za'
    },

    # Months
    'months': {
        1: 'januari',
        2: 'februari',
        3: 'maart',
        4: 'april',
        5: 'mei',
        6: 'juni',
        7: 'juli',
        8: 'augustus',
        9: 'september',
        10: 'oktober',
        11: 'november',
        12: 'december',
    },
    'months_abbrev': {
        1: 'jan',
        2: 'feb',
        3: 'mrt',
        4: 'apr',
        5: 'mei',
        6: 'jun',
        7: 'jul',
        8: 'aug',
        9: 'sep',
        10: 'okt',
        11: 'nov',
        12: 'dec',
    },

    # Units of time
    'year': '{count} jaar',
    'month': ['{count} maand', '{count} maanden'],
    'week': ['{count} week', '{count} weken'],
    'day': ['{count} dag', '{count} dagen'],
    'hour': '{count} uur',
    'minute': ['{count} minuut', '{count} minuten'],
    'second': ['{count} seconde', '{count} seconden'],

    # Relative time
    'ago': '{time} geleden',
    'from_now': 'over {time}',
    'after': '{time} later',
    'before': '{time} eerder',

    # Date formats
    'date_formats': {
        'LTS': 'HH:mm:ss',
        'LT': 'HH:mm',
        'LLLL': 'dddd D MMMM YYYY HH:mm',
        'LLL': 'D MMMM YYYY HH:mm',
        'LL': 'D MMMM YYYY',
        'L': 'DD-MM-YYYY',
    },
}
