# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'Domingo',
        1: 'Luns',
        2: 'Martes',
        3: 'Mércores',
        4: 'Xoves',
        5: 'Venres',
        6: 'Sábado'
    },
    'days_abbrev': {
        0: 'Dom.',
        1: 'Lun.',
        2: 'Mar.',
        3: 'Mér.',
        4: 'Xov.',
        5: 'Ven.',
        6: 'Sáb.'
    },

    # Months
    'months': {
        1: 'Xaneiro',
        2: 'Febreiro',
        3: 'Marzo',
        4: 'Abril',
        5: 'Maio',
        6: 'Xuño',
        7: 'Xullo',
        8: 'Agosto',
        9: 'Setembro',
        10: 'Outubro',
        11: 'Novembro',
        12: 'Decembro',
    },
    'months_abbrev': {
        1: 'Xan.',
        2: 'Feb.',
        3: 'Mar.',
        4: 'Abr.',
        5: 'Mai.',
        6: 'Xuñ.',
        7: 'Xul.',
        8: 'Ago.',
        9: 'Set.',
        10: 'Out.',
        11: 'Nov.',
        12: 'Dec.'
    },

    # Units of time
    'year': ['{count} ano', '{count} anos'],
    'month': ['{count} mes', '{count} meses'],
    'week': ['{count} semana', '{count} semanas'],
    'day': ['{count} día', '{count} días'],
    'hour': ['{count} hora', '{count} horas'],
    'minute': ['{count} minuto', '{count} minutos'],
    'second': ['{count} segundo', '{count} segundos'],

    # Relative time
    'ago': 'fai {time}',
    'from_now': 'dentro de {time}',
    'after': '{time} despois',
    'before': '{time} antes',

    # Ordinals
    'ordinal': 'º',

    # Date formats
    'date_formats': {
        'LTS': 'H:mm:ss',
        'LT': 'H:mm',
        'LLLL': 'dddd D MMMM YYYY H:mm',
        'LLL': 'D MMMM YYYY H:mm',
        'LL': 'D MMMM YYYY',
        'L': 'DD/MM/YYYY',
    },
}
