# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'duminică',
        1: 'luni',
        2: 'marți',
        3: 'miercuri',
        4: 'joi',
        5: 'vineri',
        6: 'sâmbătă'
    },
    'days_abbrev': {
        0: 'Dum',
        1: 'Lun',
        2: 'Mar',
        3: 'Mie',
        4: 'Joi',
        5: 'Vin',
        6: 'Sâm'
    },

    # Months
    'months': {
        1: 'ianuarie',
        2: 'februarie',
        3: 'martie',
        4: 'aprilie',
        5: 'mai',
        6: 'iunie',
        7: 'iulie',
        8: 'august',
        9: 'septembrie',
        10: 'octombrie',
        11: 'noiembrie',
        12: 'decembrie'
    },
    'months_abbrev': {
        1: 'ian.',
        2: 'febr.',
        3: 'mart.',
        4: 'apr.',
        5: 'mai',
        6: 'iun.',
        7: 'iul.',
        8: 'aug.',
        9: 'sept.',
        10: 'oct.',
        11: 'nov.',
        12: 'dec.'
    },

    # Units of time
    'year': ['un an', '{count} ani', '{count} ani'],
    'month': ['o lună', '{count} luni', '{count} luni'],
    'week': ['o săptămână', '{count} săptămâni', '{count} săptămâni'],
    'day': ['o zi', '{count} zile', '{count} zile'],
    'hour': ['o oră', '{count} ore', '{count} ore'],
    'minute': ['un minut', '{count} minute', '{count} minute'],
    'second': ['o secundă', '{count} secunde', '{count} secunde'],

    # Relative time
    'ago': 'acum {time}',
    'from_now': '{time} de acum',
    'after': 'peste {time}',
    'before': 'acum {time}',

    # Date formats
    'date_formats': {
        'LTS': 'H:mm:ss',
        'LT': 'H:mm',
        'LLLL': 'dddd, D MMMM YYYY H:mm',
        'LLL': 'D MMMM YYYY H:mm',
        'LL': 'D MMMM YYYY',
        'L': 'DD.MM.YYYY',
    },
}
