# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'dimanche',
        1: 'lundi',
        2: 'mardi',
        3: 'mercredi',
        4: 'jeudi',
        5: 'vendredi',
        6: 'samedi'
    },
    'days_abbrev': {
        0: 'dim',
        1: 'lun',
        2: 'mar',
        3: 'mer',
        4: 'jeu',
        5: 'ven',
        6: 'sam'
    },

    # Months
    'months': {
        1: 'janvier',
        2: 'février',
        3: 'mars',
        4: 'avril',
        5: 'mai',
        6: 'juin',
        7: 'juillet',
        8: 'août',
        9: 'septembre',
        10: 'octobre',
        11: 'novembre',
        12: 'décembre',
    },
    'months_abbrev': {
        1: 'janv',
        2: 'févr',
        3: 'mars',
        4: 'avr',
        5: 'mai',
        6: 'juin',
        7: 'juil',
        8: 'août',
        9: 'sept',
        10: 'oct',
        11: 'nov',
        12: 'déc',
    },

    # Units of time
    'year': ['{count} an', '{count} ans'],
    'month': '{count} mois',
    'week': ['{count} semaine', '{count} semaines'],
    'day': ['{count} jour', '{count} jours'],
    'hour': ['{count} heure', '{count} heures'],
    'minute': ['{count} minute', '{count} minutes'],
    'second': ['{count} seconde', '{count} secondes'],

    # Relative Time
    'ago': 'il y a {time}',
    'from_now': 'dans {time}',
    'after': '{time} après',
    'before': '{time} avant',

    # Ordinals
    'ordinal': {
        1: 'er',
        'default': 'e'
    },

    # Date formats
    'date_formats': {
        'LTS': 'HH:mm:ss',
        'LT': 'HH:mm',
        'LLLL': 'dddd D MMMM YYYY HH:mm',
        'LLL': 'D MMMM YYYY HH:mm',
        'LL': 'D MMMM YYYY',
        'L': 'DD/MM/YYYY',
    },
}
