# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'nedeľa',
        1: 'pondelok',
        2: 'utorok',
        3: 'streda',
        4: 'štvrtok',
        5: 'piatok',
        6: 'sobota'
    },
    'days_abbrev': {
        0: 'ne',
        1: 'po',
        2: 'ut',
        3: 'st',
        4: 'št',
        5: 'pi',
        6: 'so'
    },

    # Months
    'months': {
        1: 'január',
        2: 'február',
        3: 'marec',
        4: 'apríl',
        5: 'máj',
        6: 'jún',
        7: 'júl',
        8: 'august',
        9: 'september',
        10: 'október',
        11: 'november',
        12: 'december'
    },
    'months_abbrev': {
        1: 'jan',
        2: 'feb',
        3: 'mar',
        4: 'apr',
        5: 'máj',
        6: 'jún',
        7: 'júl',
        8: 'aug',
        9: 'sep',
        10: 'okt',
        11: 'nov',
        12: 'dec'
    },

    # Units of time
    'year': ['rok', '{count} roky', '{count} rokov'],
    'month': ['mesiac', '{count} mesiace', '{count} mesiacov'],
    'week': ['týždeň', '{count} týždne', '{count} týždňov'],
    'day': ['deň', '{count} dni', '{count} dní'],
    'hour': ['hodinu', '{count} hodiny', '{count} hodín'],
    'minute': ['minútu', '{count} minúty', '{count} minút'],
    'second': ['sekundu', '{count} sekundy', '{count} sekúnd'],

    # Relative time
    'ago': 'pred {time}',
    'from_now': 'o {time}',
    'after': '{time} neskôr',
    'before': '{time} predtým',

    # Date formats
    'date_formats': {
        'LTS': 'H:mm:ss',
        'LT': 'H:mm',
        'LLLL': 'dddd D. MMMM YYYY H:mm',
        'LLL': 'D. MMMM YYYY H:mm',
        'LL': 'D. MMMM YYYY',
        'L': 'DD.MM.YYYY',
    },
}
